// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3351C4_nt  {
  int s3351c4f0[2];
  void  mf3351c4(); // _ZN10S3351C4_nt8mf3351c4Ev
};
//SIG(-1 S3351C4_nt) C1{ m Fi[2]}


void  S3351C4_nt ::mf3351c4(){}

//skip512 S3351C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C3_nt  {
  int s3351c3f0;
  __tsi64 s3351c3f1;
  void *s3351c3f2[4];
  int s3351c3f3[2];
  void *s3351c3f4;
  ::S3351C4_nt s3351c3f5;
  void *s3351c3f6[2];
  virtual  ~S3351C3_nt(); // _ZN10S3351C3_ntD1Ev
  virtual void  v6(); // _ZN10S3351C3_nt2v6Ev
  virtual void  v7(); // _ZN10S3351C3_nt2v7Ev
  virtual void  v8(); // _ZN10S3351C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3351C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3351C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3351C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3351C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3351C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3351C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3351C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3351C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3351C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3351C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3351C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3351C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3351C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3351C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3351C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3351C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3351C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3351C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3351C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3351C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3351C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3351C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3351C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3351C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3351C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3351C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3351C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3351C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3351C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3351C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3351C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3351C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3351C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3351C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3351C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3351C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3351C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3351C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3351C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3351C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3351C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3351C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3351C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3351C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3351C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3351C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3351C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3351C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3351C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3351C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3351C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3351C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3351C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3351C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3351C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3351C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3351C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3351C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3351C3_nt3v67Ev
  virtual void  v68(); // _ZN10S3351C3_nt3v68Ev
  virtual void  v69(); // _ZN10S3351C3_nt3v69Ev
  S3351C3_nt(); // tgen
};
//SIG(-1 S3351C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3351C3_nt ::~S3351C3_nt(){ note_dtor("S3351C3_nt", this);}
void  S3351C3_nt ::v6(){vfunc_called(this, "_ZN10S3351C3_nt2v6Ev");}
void  S3351C3_nt ::v7(){vfunc_called(this, "_ZN10S3351C3_nt2v7Ev");}
void  S3351C3_nt ::v8(){vfunc_called(this, "_ZN10S3351C3_nt2v8Ev");}
void  S3351C3_nt ::v9(){vfunc_called(this, "_ZN10S3351C3_nt2v9Ev");}
void  S3351C3_nt ::v10(){vfunc_called(this, "_ZN10S3351C3_nt3v10Ev");}
void  S3351C3_nt ::v11(){vfunc_called(this, "_ZN10S3351C3_nt3v11Ev");}
void  S3351C3_nt ::v12(){vfunc_called(this, "_ZN10S3351C3_nt3v12Ev");}
void  S3351C3_nt ::v13(){vfunc_called(this, "_ZN10S3351C3_nt3v13Ev");}
void  S3351C3_nt ::v14(){vfunc_called(this, "_ZN10S3351C3_nt3v14Ev");}
void  S3351C3_nt ::v15(){vfunc_called(this, "_ZN10S3351C3_nt3v15Ev");}
void  S3351C3_nt ::v16(){vfunc_called(this, "_ZN10S3351C3_nt3v16Ev");}
void  S3351C3_nt ::v17(){vfunc_called(this, "_ZN10S3351C3_nt3v17Ev");}
void  S3351C3_nt ::v18(){vfunc_called(this, "_ZN10S3351C3_nt3v18Ev");}
void  S3351C3_nt ::v19(){vfunc_called(this, "_ZN10S3351C3_nt3v19Ev");}
void  S3351C3_nt ::v20(){vfunc_called(this, "_ZN10S3351C3_nt3v20Ev");}
void  S3351C3_nt ::v21(){vfunc_called(this, "_ZN10S3351C3_nt3v21Ev");}
void  S3351C3_nt ::v22(){vfunc_called(this, "_ZN10S3351C3_nt3v22Ev");}
void  S3351C3_nt ::v23(){vfunc_called(this, "_ZN10S3351C3_nt3v23Ev");}
void  S3351C3_nt ::v24(){vfunc_called(this, "_ZN10S3351C3_nt3v24Ev");}
void  S3351C3_nt ::v25(){vfunc_called(this, "_ZN10S3351C3_nt3v25Ev");}
void  S3351C3_nt ::v26(){vfunc_called(this, "_ZN10S3351C3_nt3v26Ev");}
void  S3351C3_nt ::v27(){vfunc_called(this, "_ZN10S3351C3_nt3v27Ev");}
void  S3351C3_nt ::v28(){vfunc_called(this, "_ZN10S3351C3_nt3v28Ev");}
void  S3351C3_nt ::v29(){vfunc_called(this, "_ZN10S3351C3_nt3v29Ev");}
void  S3351C3_nt ::v30(){vfunc_called(this, "_ZN10S3351C3_nt3v30Ev");}
void  S3351C3_nt ::v31(){vfunc_called(this, "_ZN10S3351C3_nt3v31Ev");}
void  S3351C3_nt ::v32(){vfunc_called(this, "_ZN10S3351C3_nt3v32Ev");}
void  S3351C3_nt ::v33(){vfunc_called(this, "_ZN10S3351C3_nt3v33Ev");}
void  S3351C3_nt ::v34(){vfunc_called(this, "_ZN10S3351C3_nt3v34Ev");}
void  S3351C3_nt ::v35(){vfunc_called(this, "_ZN10S3351C3_nt3v35Ev");}
void  S3351C3_nt ::v36(){vfunc_called(this, "_ZN10S3351C3_nt3v36Ev");}
void  S3351C3_nt ::v37(){vfunc_called(this, "_ZN10S3351C3_nt3v37Ev");}
void  S3351C3_nt ::v38(){vfunc_called(this, "_ZN10S3351C3_nt3v38Ev");}
void  S3351C3_nt ::v39(){vfunc_called(this, "_ZN10S3351C3_nt3v39Ev");}
void  S3351C3_nt ::v40(){vfunc_called(this, "_ZN10S3351C3_nt3v40Ev");}
void  S3351C3_nt ::v41(){vfunc_called(this, "_ZN10S3351C3_nt3v41Ev");}
void  S3351C3_nt ::v42(){vfunc_called(this, "_ZN10S3351C3_nt3v42Ev");}
void  S3351C3_nt ::v43(){vfunc_called(this, "_ZN10S3351C3_nt3v43Ev");}
void  S3351C3_nt ::v44(){vfunc_called(this, "_ZN10S3351C3_nt3v44Ev");}
void  S3351C3_nt ::v45(){vfunc_called(this, "_ZN10S3351C3_nt3v45Ev");}
void  S3351C3_nt ::v46(){vfunc_called(this, "_ZN10S3351C3_nt3v46Ev");}
void  S3351C3_nt ::v47(){vfunc_called(this, "_ZN10S3351C3_nt3v47Ev");}
void  S3351C3_nt ::v48(){vfunc_called(this, "_ZN10S3351C3_nt3v48Ev");}
void  S3351C3_nt ::v49(){vfunc_called(this, "_ZN10S3351C3_nt3v49Ev");}
void  S3351C3_nt ::v50(){vfunc_called(this, "_ZN10S3351C3_nt3v50Ev");}
void  S3351C3_nt ::v51(){vfunc_called(this, "_ZN10S3351C3_nt3v51Ev");}
void  S3351C3_nt ::v52(){vfunc_called(this, "_ZN10S3351C3_nt3v52Ev");}
void  S3351C3_nt ::v53(){vfunc_called(this, "_ZN10S3351C3_nt3v53Ev");}
void  S3351C3_nt ::v54(){vfunc_called(this, "_ZN10S3351C3_nt3v54Ev");}
void  S3351C3_nt ::v55(){vfunc_called(this, "_ZN10S3351C3_nt3v55Ev");}
void  S3351C3_nt ::v56(){vfunc_called(this, "_ZN10S3351C3_nt3v56Ev");}
void  S3351C3_nt ::v57(){vfunc_called(this, "_ZN10S3351C3_nt3v57Ev");}
void  S3351C3_nt ::v58(){vfunc_called(this, "_ZN10S3351C3_nt3v58Ev");}
void  S3351C3_nt ::v59(){vfunc_called(this, "_ZN10S3351C3_nt3v59Ev");}
void  S3351C3_nt ::v60(){vfunc_called(this, "_ZN10S3351C3_nt3v60Ev");}
void  S3351C3_nt ::v61(){vfunc_called(this, "_ZN10S3351C3_nt3v61Ev");}
void  S3351C3_nt ::v62(){vfunc_called(this, "_ZN10S3351C3_nt3v62Ev");}
void  S3351C3_nt ::v63(){vfunc_called(this, "_ZN10S3351C3_nt3v63Ev");}
void  S3351C3_nt ::v64(){vfunc_called(this, "_ZN10S3351C3_nt3v64Ev");}
void  S3351C3_nt ::v65(){vfunc_called(this, "_ZN10S3351C3_nt3v65Ev");}
void  S3351C3_nt ::v66(){vfunc_called(this, "_ZN10S3351C3_nt3v66Ev");}
void  S3351C3_nt ::v67(){vfunc_called(this, "_ZN10S3351C3_nt3v67Ev");}
void  S3351C3_nt ::v68(){vfunc_called(this, "_ZN10S3351C3_nt3v68Ev");}
void  S3351C3_nt ::v69(){vfunc_called(this, "_ZN10S3351C3_nt3v69Ev");}
S3351C3_nt ::S3351C3_nt(){ note_ctor("S3351C3_nt", this);} // tgen

//skip512 S3351C3_nt

#else // __cplusplus

extern void _ZN10S3351C3_ntC1Ev();
extern void _ZN10S3351C3_ntD1Ev();
Name_Map name_map_S3351C3_nt[] = {
  NSPAIR(_ZN10S3351C3_ntC1Ev),
  NSPAIR(_ZN10S3351C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3351C3_nt[];
extern void _ZN10S3351C3_ntD1Ev();
extern void _ZN10S3351C3_ntD0Ev();
extern void _ZN10S3351C3_nt2v6Ev();
extern void _ZN10S3351C3_nt2v7Ev();
extern void _ZN10S3351C3_nt2v8Ev();
extern void _ZN10S3351C3_nt2v9Ev();
extern void _ZN10S3351C3_nt3v10Ev();
extern void _ZN10S3351C3_nt3v11Ev();
extern void _ZN10S3351C3_nt3v12Ev();
extern void _ZN10S3351C3_nt3v13Ev();
extern void _ZN10S3351C3_nt3v14Ev();
extern void _ZN10S3351C3_nt3v15Ev();
extern void _ZN10S3351C3_nt3v16Ev();
extern void _ZN10S3351C3_nt3v17Ev();
extern void _ZN10S3351C3_nt3v18Ev();
extern void _ZN10S3351C3_nt3v19Ev();
extern void _ZN10S3351C3_nt3v20Ev();
extern void _ZN10S3351C3_nt3v21Ev();
extern void _ZN10S3351C3_nt3v22Ev();
extern void _ZN10S3351C3_nt3v23Ev();
extern void _ZN10S3351C3_nt3v24Ev();
extern void _ZN10S3351C3_nt3v25Ev();
extern void _ZN10S3351C3_nt3v26Ev();
extern void _ZN10S3351C3_nt3v27Ev();
extern void _ZN10S3351C3_nt3v28Ev();
extern void _ZN10S3351C3_nt3v29Ev();
extern void _ZN10S3351C3_nt3v30Ev();
extern void _ZN10S3351C3_nt3v31Ev();
extern void _ZN10S3351C3_nt3v32Ev();
extern void _ZN10S3351C3_nt3v33Ev();
extern void _ZN10S3351C3_nt3v34Ev();
extern void _ZN10S3351C3_nt3v35Ev();
extern void _ZN10S3351C3_nt3v36Ev();
extern void _ZN10S3351C3_nt3v37Ev();
extern void _ZN10S3351C3_nt3v38Ev();
extern void _ZN10S3351C3_nt3v39Ev();
extern void _ZN10S3351C3_nt3v40Ev();
extern void _ZN10S3351C3_nt3v41Ev();
extern void _ZN10S3351C3_nt3v42Ev();
extern void _ZN10S3351C3_nt3v43Ev();
extern void _ZN10S3351C3_nt3v44Ev();
extern void _ZN10S3351C3_nt3v45Ev();
extern void _ZN10S3351C3_nt3v46Ev();
extern void _ZN10S3351C3_nt3v47Ev();
extern void _ZN10S3351C3_nt3v48Ev();
extern void _ZN10S3351C3_nt3v49Ev();
extern void _ZN10S3351C3_nt3v50Ev();
extern void _ZN10S3351C3_nt3v51Ev();
extern void _ZN10S3351C3_nt3v52Ev();
extern void _ZN10S3351C3_nt3v53Ev();
extern void _ZN10S3351C3_nt3v54Ev();
extern void _ZN10S3351C3_nt3v55Ev();
extern void _ZN10S3351C3_nt3v56Ev();
extern void _ZN10S3351C3_nt3v57Ev();
extern void _ZN10S3351C3_nt3v58Ev();
extern void _ZN10S3351C3_nt3v59Ev();
extern void _ZN10S3351C3_nt3v60Ev();
extern void _ZN10S3351C3_nt3v61Ev();
extern void _ZN10S3351C3_nt3v62Ev();
extern void _ZN10S3351C3_nt3v63Ev();
extern void _ZN10S3351C3_nt3v64Ev();
extern void _ZN10S3351C3_nt3v65Ev();
extern void _ZN10S3351C3_nt3v66Ev();
extern void _ZN10S3351C3_nt3v67Ev();
extern void _ZN10S3351C3_nt3v68Ev();
extern void _ZN10S3351C3_nt3v69Ev();
static  VTBL_ENTRY vtc_S3351C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3351C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3351C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S3351C3_nt[];
VTBL_ENTRY *P__ZTI10S3351C3_nt = _ZTI10S3351C3_nt; 
extern  VTBL_ENTRY _ZTV10S3351C3_nt[];
Class_Descriptor cd_S3351C3_nt = {  "S3351C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3351C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3351C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3351C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C7_nt  {
  void *s3351c7f0;
  int s3351c7f1[2];
  void  mf3351c7(); // _ZN10S3351C7_nt8mf3351c7Ev
};
//SIG(-1 S3351C7_nt) C1{ m Fp Fi[2]}


void  S3351C7_nt ::mf3351c7(){}

//skip512 S3351C7_nt

#else // __cplusplus

Class_Descriptor cd_S3351C7_nt = {  "S3351C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C6_nt  : S3351C7_nt {
};
//SIG(-1 S3351C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3351C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C6_nt = {  "S3351C6_nt", // class name
  bases_S3351C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C5_nt  : S3351C6_nt {
};
//SIG(-1 S3351C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3351C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
extern Class_Descriptor cd_S3351C6_nt;
static Base_Class bases_S3351C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C8_nt  {
  int s3351c8f0;
  void  mf3351c8(); // _ZN10S3351C8_nt8mf3351c8Ev
};
//SIG(-1 S3351C8_nt) C1{ m Fi}


void  S3351C8_nt ::mf3351c8(){}

//skip512 S3351C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3351C8_nt[];
VTBL_ENTRY *P__ZTI10S3351C8_nt = _ZTI10S3351C8_nt; 
Class_Descriptor cd_S3351C8_nt = {  "S3351C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3351C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C12  : S3351C7_nt {
};
//SIG(-1 S3351C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3351C12()
{
  extern Class_Descriptor cd_S3351C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C12, buf);
    S3351C12 &lv = *(new (buf) S3351C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C12)");
    check_base_class_offset(lv, (S3351C7_nt*), 0, "S3351C12");
    test_class_info(&lv, &cd_S3351C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C12(Test_S3351C12, "S3351C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C12 = {  "S3351C12", // class name
  bases_S3351C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C11  : S3351C12 {
};
//SIG(-1 S3351C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3351C11()
{
  extern Class_Descriptor cd_S3351C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C11, buf);
    S3351C11 &lv = *(new (buf) S3351C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C11)");
    check_base_class_offset(lv, (S3351C7_nt*)(S3351C12*), 0, "S3351C11");
    check_base_class_offset(lv, (S3351C12*), 0, "S3351C11");
    test_class_info(&lv, &cd_S3351C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C11(Test_S3351C11, "S3351C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
extern Class_Descriptor cd_S3351C12;
static Base_Class bases_S3351C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C11 = {  "S3351C11", // class name
  bases_S3351C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C13_nt  {
  int s3351c13f0[3];
  void  mf3351c13(); // _ZN11S3351C13_nt9mf3351c13Ev
};
//SIG(-1 S3351C13_nt) C1{ m Fi[3]}


void  S3351C13_nt ::mf3351c13(){}

//skip512 S3351C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C18  : S3351C7_nt {
};
//SIG(-1 S3351C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3351C18()
{
  extern Class_Descriptor cd_S3351C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C18, buf);
    S3351C18 &lv = *(new (buf) S3351C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C18)");
    check_base_class_offset(lv, (S3351C7_nt*), 0, "S3351C18");
    test_class_info(&lv, &cd_S3351C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C18(Test_S3351C18, "S3351C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C18 = {  "S3351C18", // class name
  bases_S3351C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C17  : S3351C18 {
};
//SIG(-1 S3351C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3351C17()
{
  extern Class_Descriptor cd_S3351C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C17, buf);
    S3351C17 &lv = *(new (buf) S3351C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C17)");
    check_base_class_offset(lv, (S3351C7_nt*)(S3351C18*), 0, "S3351C17");
    check_base_class_offset(lv, (S3351C18*), 0, "S3351C17");
    test_class_info(&lv, &cd_S3351C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C17(Test_S3351C17, "S3351C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
extern Class_Descriptor cd_S3351C18;
static Base_Class bases_S3351C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C17 = {  "S3351C17", // class name
  bases_S3351C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C2_nt  : S3351C3_nt {
  ::S3351C5_nt s3351c2f0;
  ::S3351C5_nt s3351c2f1;
  ::S3351C8_nt s3351c2f2;
  int s3351c2f3;
  char s3351c2f4[4];
  void *s3351c2f5[2];
  ::S3351C5_nt s3351c2f6;
  unsigned int s3351c2f7:1;
  unsigned int s3351c2f8:1;
  unsigned int s3351c2f9:1;
  unsigned int s3351c2f10:1;
  unsigned int s3351c2f11:1;
  unsigned int s3351c2f12:1;
  unsigned int s3351c2f13:1;
  unsigned int s3351c2f14:1;
  unsigned int s3351c2f15:1;
  unsigned int s3351c2f16:1;
  unsigned int s3351c2f17:1;
  unsigned int s3351c2f18:1;
  unsigned int s3351c2f19:1;
  unsigned int s3351c2f20:1;
  unsigned int s3351c2f21:1;
  unsigned int s3351c2f22:1;
  unsigned int s3351c2f23:1;
  unsigned int s3351c2f24:1;
  unsigned int s3351c2f25:1;
  unsigned int s3351c2f26:1;
  unsigned int s3351c2f27:1;
  unsigned int s3351c2f28:1;
  unsigned int s3351c2f29:1;
  unsigned int s3351c2f30:1;
  unsigned int s3351c2f31:1;
  unsigned int s3351c2f32:1;
  unsigned int s3351c2f33:1;
  unsigned int s3351c2f34:1;
  unsigned int s3351c2f35:1;
  unsigned int s3351c2f36:1;
  unsigned int s3351c2f37:1;
  unsigned int s3351c2f38:1;
  unsigned int s3351c2f39:1;
  unsigned int s3351c2f40:1;
  unsigned int s3351c2f41:1;
  unsigned int s3351c2f42:1;
  unsigned int s3351c2f43:1;
  unsigned int s3351c2f44:1;
  unsigned int s3351c2f45:1;
  unsigned int s3351c2f46:1;
  unsigned int s3351c2f47:1;
  unsigned int s3351c2f48:1;
  unsigned int s3351c2f49:1;
  unsigned int s3351c2f50:1;
  unsigned int s3351c2f51:1;
  unsigned int s3351c2f52:1;
  unsigned int s3351c2f53:1;
  unsigned int s3351c2f54:1;
  unsigned int s3351c2f55:1;
  unsigned int s3351c2f56:1;
  unsigned int s3351c2f57:1;
  unsigned int s3351c2f58:1;
  unsigned int s3351c2f59:1;
  unsigned int s3351c2f60:1;
  unsigned int s3351c2f61:1;
  unsigned int s3351c2f62:1;
  unsigned int s3351c2f63:1;
  unsigned int s3351c2f64:1;
  unsigned int s3351c2f65:1;
  unsigned int s3351c2f66:1;
  unsigned int s3351c2f67:1;
  unsigned int s3351c2f68:1;
  unsigned int s3351c2f69:1;
  unsigned int s3351c2f70:1;
  unsigned int s3351c2f71:1;
  unsigned int s3351c2f72:1;
  unsigned int s3351c2f73:1;
  unsigned int s3351c2f74:1;
  unsigned int s3351c2f75:1;
  unsigned int s3351c2f76:1;
  unsigned int s3351c2f77:1;
  unsigned int s3351c2f78:1;
  unsigned int s3351c2f79:1;
  unsigned int s3351c2f80:1;
  unsigned int s3351c2f81:1;
  unsigned int s3351c2f82:1;
  unsigned int s3351c2f83:1;
  int s3351c2f84[5];
  void *s3351c2f85[2];
  int s3351c2f86[3];
  ::S3351C4_nt s3351c2f87;
  ::S3351C4_nt s3351c2f88;
  ::S3351C4_nt s3351c2f89;
  ::S3351C11 s3351c2f90;
  ::S3351C11 s3351c2f91;
  int s3351c2f92;
  void *s3351c2f93[2];
  ::S3351C13_nt s3351c2f94;
  ::S3351C13_nt s3351c2f95;
  ::S3351C13_nt s3351c2f96;
  ::S3351C13_nt s3351c2f97;
  void *s3351c2f98;
  ::S3351C4_nt s3351c2f99;
  ::S3351C11 s3351c2f100;
  ::S3351C13_nt s3351c2f101;
  ::S3351C13_nt s3351c2f102;
  int s3351c2f103;
  ::S3351C13_nt s3351c2f104;
  ::S3351C13_nt s3351c2f105;
  void *s3351c2f106;
  int s3351c2f107;
  char s3351c2f108;
  ::S3351C13_nt s3351c2f109;
  ::S3351C13_nt s3351c2f110;
  void *s3351c2f111;
  int s3351c2f112;
  void *s3351c2f113;
  ::S3351C11 s3351c2f114;
  ::S3351C17 s3351c2f115;
  ::S3351C17 s3351c2f116;
  virtual  ~S3351C2_nt(); // _ZN10S3351C2_ntD1Ev
  virtual void  v70(); // _ZN10S3351C2_nt3v70Ev
  virtual void  v71(); // _ZN10S3351C2_nt3v71Ev
  virtual void  v72(); // _ZN10S3351C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3351C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3351C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3351C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3351C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3351C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3351C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3351C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3351C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3351C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3351C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3351C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3351C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3351C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3351C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3351C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3351C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3351C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3351C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3351C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3351C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3351C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3351C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3351C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3351C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3351C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3351C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3351C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3351C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3351C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3351C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3351C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3351C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3351C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3351C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3351C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3351C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3351C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3351C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3351C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3351C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3351C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3351C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3351C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3351C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3351C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3351C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3351C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3351C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3351C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3351C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3351C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3351C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3351C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3351C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3351C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3351C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3351C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3351C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3351C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3351C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3351C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3351C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3351C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3351C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3351C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3351C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3351C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3351C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3351C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3351C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3351C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3351C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3351C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3351C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3351C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3351C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3351C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3351C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3351C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3351C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3351C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3351C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3351C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3351C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3351C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3351C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3351C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3351C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3351C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3351C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3351C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3351C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3351C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3351C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3351C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3351C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3351C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3351C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3351C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3351C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3351C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3351C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3351C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3351C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3351C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3351C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3351C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3351C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3351C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3351C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3351C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3351C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3351C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3351C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3351C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3351C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3351C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3351C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3351C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3351C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3351C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3351C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3351C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3351C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3351C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3351C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3351C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3351C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3351C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3351C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3351C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3351C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3351C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3351C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3351C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3351C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3351C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3351C2_nt4v210Ev
  virtual void  v211(); // _ZN10S3351C2_nt4v211Ev
  virtual void  v212(); // _ZN10S3351C2_nt4v212Ev
  S3351C2_nt(); // tgen
};
//SIG(-1 S3351C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3351C2_nt ::~S3351C2_nt(){ note_dtor("S3351C2_nt", this);}
void  S3351C2_nt ::v70(){vfunc_called(this, "_ZN10S3351C2_nt3v70Ev");}
void  S3351C2_nt ::v71(){vfunc_called(this, "_ZN10S3351C2_nt3v71Ev");}
void  S3351C2_nt ::v72(){vfunc_called(this, "_ZN10S3351C2_nt3v72Ev");}
void  S3351C2_nt ::v73(){vfunc_called(this, "_ZN10S3351C2_nt3v73Ev");}
void  S3351C2_nt ::v74(){vfunc_called(this, "_ZN10S3351C2_nt3v74Ev");}
void  S3351C2_nt ::v75(){vfunc_called(this, "_ZN10S3351C2_nt3v75Ev");}
void  S3351C2_nt ::v76(){vfunc_called(this, "_ZN10S3351C2_nt3v76Ev");}
void  S3351C2_nt ::v77(){vfunc_called(this, "_ZN10S3351C2_nt3v77Ev");}
void  S3351C2_nt ::v78(){vfunc_called(this, "_ZN10S3351C2_nt3v78Ev");}
void  S3351C2_nt ::v79(){vfunc_called(this, "_ZN10S3351C2_nt3v79Ev");}
void  S3351C2_nt ::v80(){vfunc_called(this, "_ZN10S3351C2_nt3v80Ev");}
void  S3351C2_nt ::v81(){vfunc_called(this, "_ZN10S3351C2_nt3v81Ev");}
void  S3351C2_nt ::v82(){vfunc_called(this, "_ZN10S3351C2_nt3v82Ev");}
void  S3351C2_nt ::v83(){vfunc_called(this, "_ZN10S3351C2_nt3v83Ev");}
void  S3351C2_nt ::v84(){vfunc_called(this, "_ZN10S3351C2_nt3v84Ev");}
void  S3351C2_nt ::v85(){vfunc_called(this, "_ZN10S3351C2_nt3v85Ev");}
void  S3351C2_nt ::v86(){vfunc_called(this, "_ZN10S3351C2_nt3v86Ev");}
void  S3351C2_nt ::v87(){vfunc_called(this, "_ZN10S3351C2_nt3v87Ev");}
void  S3351C2_nt ::v88(){vfunc_called(this, "_ZN10S3351C2_nt3v88Ev");}
void  S3351C2_nt ::v89(){vfunc_called(this, "_ZN10S3351C2_nt3v89Ev");}
void  S3351C2_nt ::v90(){vfunc_called(this, "_ZN10S3351C2_nt3v90Ev");}
void  S3351C2_nt ::v91(){vfunc_called(this, "_ZN10S3351C2_nt3v91Ev");}
void  S3351C2_nt ::v92(){vfunc_called(this, "_ZN10S3351C2_nt3v92Ev");}
void  S3351C2_nt ::v93(){vfunc_called(this, "_ZN10S3351C2_nt3v93Ev");}
void  S3351C2_nt ::v94(){vfunc_called(this, "_ZN10S3351C2_nt3v94Ev");}
void  S3351C2_nt ::v95(){vfunc_called(this, "_ZN10S3351C2_nt3v95Ev");}
void  S3351C2_nt ::v96(){vfunc_called(this, "_ZN10S3351C2_nt3v96Ev");}
void  S3351C2_nt ::v97(){vfunc_called(this, "_ZN10S3351C2_nt3v97Ev");}
void  S3351C2_nt ::v98(){vfunc_called(this, "_ZN10S3351C2_nt3v98Ev");}
void  S3351C2_nt ::v99(){vfunc_called(this, "_ZN10S3351C2_nt3v99Ev");}
void  S3351C2_nt ::v100(){vfunc_called(this, "_ZN10S3351C2_nt4v100Ev");}
void  S3351C2_nt ::v101(){vfunc_called(this, "_ZN10S3351C2_nt4v101Ev");}
void  S3351C2_nt ::v102(){vfunc_called(this, "_ZN10S3351C2_nt4v102Ev");}
void  S3351C2_nt ::v103(){vfunc_called(this, "_ZN10S3351C2_nt4v103Ev");}
void  S3351C2_nt ::v104(){vfunc_called(this, "_ZN10S3351C2_nt4v104Ev");}
void  S3351C2_nt ::v105(){vfunc_called(this, "_ZN10S3351C2_nt4v105Ev");}
void  S3351C2_nt ::v106(){vfunc_called(this, "_ZN10S3351C2_nt4v106Ev");}
void  S3351C2_nt ::v107(){vfunc_called(this, "_ZN10S3351C2_nt4v107Ev");}
void  S3351C2_nt ::v108(){vfunc_called(this, "_ZN10S3351C2_nt4v108Ev");}
void  S3351C2_nt ::v109(){vfunc_called(this, "_ZN10S3351C2_nt4v109Ev");}
void  S3351C2_nt ::v110(){vfunc_called(this, "_ZN10S3351C2_nt4v110Ev");}
void  S3351C2_nt ::v111(){vfunc_called(this, "_ZN10S3351C2_nt4v111Ev");}
void  S3351C2_nt ::v112(){vfunc_called(this, "_ZN10S3351C2_nt4v112Ev");}
void  S3351C2_nt ::v113(){vfunc_called(this, "_ZN10S3351C2_nt4v113Ev");}
void  S3351C2_nt ::v114(){vfunc_called(this, "_ZN10S3351C2_nt4v114Ev");}
void  S3351C2_nt ::v115(){vfunc_called(this, "_ZN10S3351C2_nt4v115Ev");}
void  S3351C2_nt ::v116(){vfunc_called(this, "_ZN10S3351C2_nt4v116Ev");}
void  S3351C2_nt ::v117(){vfunc_called(this, "_ZN10S3351C2_nt4v117Ev");}
void  S3351C2_nt ::v118(){vfunc_called(this, "_ZN10S3351C2_nt4v118Ev");}
void  S3351C2_nt ::v119(){vfunc_called(this, "_ZN10S3351C2_nt4v119Ev");}
void  S3351C2_nt ::v120(){vfunc_called(this, "_ZN10S3351C2_nt4v120Ev");}
void  S3351C2_nt ::v121(){vfunc_called(this, "_ZN10S3351C2_nt4v121Ev");}
void  S3351C2_nt ::v122(){vfunc_called(this, "_ZN10S3351C2_nt4v122Ev");}
void  S3351C2_nt ::v123(){vfunc_called(this, "_ZN10S3351C2_nt4v123Ev");}
void  S3351C2_nt ::v124(){vfunc_called(this, "_ZN10S3351C2_nt4v124Ev");}
void  S3351C2_nt ::v125(){vfunc_called(this, "_ZN10S3351C2_nt4v125Ev");}
void  S3351C2_nt ::v126(){vfunc_called(this, "_ZN10S3351C2_nt4v126Ev");}
void  S3351C2_nt ::v127(){vfunc_called(this, "_ZN10S3351C2_nt4v127Ev");}
void  S3351C2_nt ::v128(){vfunc_called(this, "_ZN10S3351C2_nt4v128Ev");}
void  S3351C2_nt ::v129(){vfunc_called(this, "_ZN10S3351C2_nt4v129Ev");}
void  S3351C2_nt ::v130(){vfunc_called(this, "_ZN10S3351C2_nt4v130Ev");}
void  S3351C2_nt ::v131(){vfunc_called(this, "_ZN10S3351C2_nt4v131Ev");}
void  S3351C2_nt ::v132(){vfunc_called(this, "_ZN10S3351C2_nt4v132Ev");}
void  S3351C2_nt ::v133(){vfunc_called(this, "_ZN10S3351C2_nt4v133Ev");}
void  S3351C2_nt ::v134(){vfunc_called(this, "_ZN10S3351C2_nt4v134Ev");}
void  S3351C2_nt ::v135(){vfunc_called(this, "_ZN10S3351C2_nt4v135Ev");}
void  S3351C2_nt ::v136(){vfunc_called(this, "_ZN10S3351C2_nt4v136Ev");}
void  S3351C2_nt ::v137(){vfunc_called(this, "_ZN10S3351C2_nt4v137Ev");}
void  S3351C2_nt ::v138(){vfunc_called(this, "_ZN10S3351C2_nt4v138Ev");}
void  S3351C2_nt ::v139(){vfunc_called(this, "_ZN10S3351C2_nt4v139Ev");}
void  S3351C2_nt ::v140(){vfunc_called(this, "_ZN10S3351C2_nt4v140Ev");}
void  S3351C2_nt ::v141(){vfunc_called(this, "_ZN10S3351C2_nt4v141Ev");}
void  S3351C2_nt ::v142(){vfunc_called(this, "_ZN10S3351C2_nt4v142Ev");}
void  S3351C2_nt ::v143(){vfunc_called(this, "_ZN10S3351C2_nt4v143Ev");}
void  S3351C2_nt ::v144(){vfunc_called(this, "_ZN10S3351C2_nt4v144Ev");}
void  S3351C2_nt ::v145(){vfunc_called(this, "_ZN10S3351C2_nt4v145Ev");}
void  S3351C2_nt ::v146(){vfunc_called(this, "_ZN10S3351C2_nt4v146Ev");}
void  S3351C2_nt ::v147(){vfunc_called(this, "_ZN10S3351C2_nt4v147Ev");}
void  S3351C2_nt ::v148(){vfunc_called(this, "_ZN10S3351C2_nt4v148Ev");}
void  S3351C2_nt ::v149(){vfunc_called(this, "_ZN10S3351C2_nt4v149Ev");}
void  S3351C2_nt ::v150(){vfunc_called(this, "_ZN10S3351C2_nt4v150Ev");}
void  S3351C2_nt ::v151(){vfunc_called(this, "_ZN10S3351C2_nt4v151Ev");}
void  S3351C2_nt ::v152(){vfunc_called(this, "_ZN10S3351C2_nt4v152Ev");}
void  S3351C2_nt ::v153(){vfunc_called(this, "_ZN10S3351C2_nt4v153Ev");}
void  S3351C2_nt ::v154(){vfunc_called(this, "_ZN10S3351C2_nt4v154Ev");}
void  S3351C2_nt ::v155(){vfunc_called(this, "_ZN10S3351C2_nt4v155Ev");}
void  S3351C2_nt ::v156(){vfunc_called(this, "_ZN10S3351C2_nt4v156Ev");}
void  S3351C2_nt ::v157(){vfunc_called(this, "_ZN10S3351C2_nt4v157Ev");}
void  S3351C2_nt ::v158(){vfunc_called(this, "_ZN10S3351C2_nt4v158Ev");}
void  S3351C2_nt ::v159(){vfunc_called(this, "_ZN10S3351C2_nt4v159Ev");}
void  S3351C2_nt ::v160(){vfunc_called(this, "_ZN10S3351C2_nt4v160Ev");}
void  S3351C2_nt ::v161(){vfunc_called(this, "_ZN10S3351C2_nt4v161Ev");}
void  S3351C2_nt ::v162(){vfunc_called(this, "_ZN10S3351C2_nt4v162Ev");}
void  S3351C2_nt ::v163(){vfunc_called(this, "_ZN10S3351C2_nt4v163Ev");}
void  S3351C2_nt ::v164(){vfunc_called(this, "_ZN10S3351C2_nt4v164Ev");}
void  S3351C2_nt ::v165(){vfunc_called(this, "_ZN10S3351C2_nt4v165Ev");}
void  S3351C2_nt ::v166(){vfunc_called(this, "_ZN10S3351C2_nt4v166Ev");}
void  S3351C2_nt ::v167(){vfunc_called(this, "_ZN10S3351C2_nt4v167Ev");}
void  S3351C2_nt ::v168(){vfunc_called(this, "_ZN10S3351C2_nt4v168Ev");}
void  S3351C2_nt ::v169(){vfunc_called(this, "_ZN10S3351C2_nt4v169Ev");}
void  S3351C2_nt ::v170(){vfunc_called(this, "_ZN10S3351C2_nt4v170Ev");}
void  S3351C2_nt ::v171(){vfunc_called(this, "_ZN10S3351C2_nt4v171Ev");}
void  S3351C2_nt ::v172(){vfunc_called(this, "_ZN10S3351C2_nt4v172Ev");}
void  S3351C2_nt ::v173(){vfunc_called(this, "_ZN10S3351C2_nt4v173Ev");}
void  S3351C2_nt ::v174(){vfunc_called(this, "_ZN10S3351C2_nt4v174Ev");}
void  S3351C2_nt ::v175(){vfunc_called(this, "_ZN10S3351C2_nt4v175Ev");}
void  S3351C2_nt ::v176(){vfunc_called(this, "_ZN10S3351C2_nt4v176Ev");}
void  S3351C2_nt ::v177(){vfunc_called(this, "_ZN10S3351C2_nt4v177Ev");}
void  S3351C2_nt ::v178(){vfunc_called(this, "_ZN10S3351C2_nt4v178Ev");}
void  S3351C2_nt ::v179(){vfunc_called(this, "_ZN10S3351C2_nt4v179Ev");}
void  S3351C2_nt ::v180(){vfunc_called(this, "_ZN10S3351C2_nt4v180Ev");}
void  S3351C2_nt ::v181(){vfunc_called(this, "_ZN10S3351C2_nt4v181Ev");}
void  S3351C2_nt ::v182(){vfunc_called(this, "_ZN10S3351C2_nt4v182Ev");}
void  S3351C2_nt ::v183(){vfunc_called(this, "_ZN10S3351C2_nt4v183Ev");}
void  S3351C2_nt ::v184(){vfunc_called(this, "_ZN10S3351C2_nt4v184Ev");}
void  S3351C2_nt ::v185(){vfunc_called(this, "_ZN10S3351C2_nt4v185Ev");}
void  S3351C2_nt ::v186(){vfunc_called(this, "_ZN10S3351C2_nt4v186Ev");}
void  S3351C2_nt ::v187(){vfunc_called(this, "_ZN10S3351C2_nt4v187Ev");}
void  S3351C2_nt ::v188(){vfunc_called(this, "_ZN10S3351C2_nt4v188Ev");}
void  S3351C2_nt ::v189(){vfunc_called(this, "_ZN10S3351C2_nt4v189Ev");}
void  S3351C2_nt ::v190(){vfunc_called(this, "_ZN10S3351C2_nt4v190Ev");}
void  S3351C2_nt ::v191(){vfunc_called(this, "_ZN10S3351C2_nt4v191Ev");}
void  S3351C2_nt ::v192(){vfunc_called(this, "_ZN10S3351C2_nt4v192Ev");}
void  S3351C2_nt ::v193(){vfunc_called(this, "_ZN10S3351C2_nt4v193Ev");}
void  S3351C2_nt ::v194(){vfunc_called(this, "_ZN10S3351C2_nt4v194Ev");}
void  S3351C2_nt ::v195(){vfunc_called(this, "_ZN10S3351C2_nt4v195Ev");}
void  S3351C2_nt ::v196(){vfunc_called(this, "_ZN10S3351C2_nt4v196Ev");}
void  S3351C2_nt ::v197(){vfunc_called(this, "_ZN10S3351C2_nt4v197Ev");}
void  S3351C2_nt ::v198(){vfunc_called(this, "_ZN10S3351C2_nt4v198Ev");}
void  S3351C2_nt ::v199(){vfunc_called(this, "_ZN10S3351C2_nt4v199Ev");}
void  S3351C2_nt ::v200(){vfunc_called(this, "_ZN10S3351C2_nt4v200Ev");}
void  S3351C2_nt ::v201(){vfunc_called(this, "_ZN10S3351C2_nt4v201Ev");}
void  S3351C2_nt ::v202(){vfunc_called(this, "_ZN10S3351C2_nt4v202Ev");}
void  S3351C2_nt ::v203(){vfunc_called(this, "_ZN10S3351C2_nt4v203Ev");}
void  S3351C2_nt ::v204(){vfunc_called(this, "_ZN10S3351C2_nt4v204Ev");}
void  S3351C2_nt ::v205(){vfunc_called(this, "_ZN10S3351C2_nt4v205Ev");}
void  S3351C2_nt ::v206(){vfunc_called(this, "_ZN10S3351C2_nt4v206Ev");}
void  S3351C2_nt ::v207(){vfunc_called(this, "_ZN10S3351C2_nt4v207Ev");}
void  S3351C2_nt ::v208(){vfunc_called(this, "_ZN10S3351C2_nt4v208Ev");}
void  S3351C2_nt ::v209(){vfunc_called(this, "_ZN10S3351C2_nt4v209Ev");}
void  S3351C2_nt ::v210(){vfunc_called(this, "_ZN10S3351C2_nt4v210Ev");}
void  S3351C2_nt ::v211(){vfunc_called(this, "_ZN10S3351C2_nt4v211Ev");}
void  S3351C2_nt ::v212(){vfunc_called(this, "_ZN10S3351C2_nt4v212Ev");}
S3351C2_nt ::S3351C2_nt(){ note_ctor("S3351C2_nt", this);} // tgen

//skip512 S3351C2_nt

#else // __cplusplus

extern void _ZN10S3351C2_ntC1Ev();
extern void _ZN10S3351C2_ntD1Ev();
Name_Map name_map_S3351C2_nt[] = {
  NSPAIR(_ZN10S3351C2_ntC1Ev),
  NSPAIR(_ZN10S3351C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3351C3_nt;
extern VTBL_ENTRY _ZTI10S3351C3_nt[];
extern  VTBL_ENTRY _ZTV10S3351C3_nt[];
static Base_Class bases_S3351C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3351C2_nt[];
extern void _ZN10S3351C2_ntD1Ev();
extern void _ZN10S3351C2_ntD0Ev();
extern void _ZN10S3351C3_nt2v6Ev();
extern void _ZN10S3351C3_nt2v7Ev();
extern void _ZN10S3351C3_nt2v8Ev();
extern void _ZN10S3351C3_nt2v9Ev();
extern void _ZN10S3351C3_nt3v10Ev();
extern void _ZN10S3351C3_nt3v11Ev();
extern void _ZN10S3351C3_nt3v12Ev();
extern void _ZN10S3351C3_nt3v13Ev();
extern void _ZN10S3351C3_nt3v14Ev();
extern void _ZN10S3351C3_nt3v15Ev();
extern void _ZN10S3351C3_nt3v16Ev();
extern void _ZN10S3351C3_nt3v17Ev();
extern void _ZN10S3351C3_nt3v18Ev();
extern void _ZN10S3351C3_nt3v19Ev();
extern void _ZN10S3351C3_nt3v20Ev();
extern void _ZN10S3351C3_nt3v21Ev();
extern void _ZN10S3351C3_nt3v22Ev();
extern void _ZN10S3351C3_nt3v23Ev();
extern void _ZN10S3351C3_nt3v24Ev();
extern void _ZN10S3351C3_nt3v25Ev();
extern void _ZN10S3351C3_nt3v26Ev();
extern void _ZN10S3351C3_nt3v27Ev();
extern void _ZN10S3351C3_nt3v28Ev();
extern void _ZN10S3351C3_nt3v29Ev();
extern void _ZN10S3351C3_nt3v30Ev();
extern void _ZN10S3351C3_nt3v31Ev();
extern void _ZN10S3351C3_nt3v32Ev();
extern void _ZN10S3351C3_nt3v33Ev();
extern void _ZN10S3351C3_nt3v34Ev();
extern void _ZN10S3351C3_nt3v35Ev();
extern void _ZN10S3351C3_nt3v36Ev();
extern void _ZN10S3351C3_nt3v37Ev();
extern void _ZN10S3351C3_nt3v38Ev();
extern void _ZN10S3351C3_nt3v39Ev();
extern void _ZN10S3351C3_nt3v40Ev();
extern void _ZN10S3351C3_nt3v41Ev();
extern void _ZN10S3351C3_nt3v42Ev();
extern void _ZN10S3351C3_nt3v43Ev();
extern void _ZN10S3351C3_nt3v44Ev();
extern void _ZN10S3351C3_nt3v45Ev();
extern void _ZN10S3351C3_nt3v46Ev();
extern void _ZN10S3351C3_nt3v47Ev();
extern void _ZN10S3351C3_nt3v48Ev();
extern void _ZN10S3351C3_nt3v49Ev();
extern void _ZN10S3351C3_nt3v50Ev();
extern void _ZN10S3351C3_nt3v51Ev();
extern void _ZN10S3351C3_nt3v52Ev();
extern void _ZN10S3351C3_nt3v53Ev();
extern void _ZN10S3351C3_nt3v54Ev();
extern void _ZN10S3351C3_nt3v55Ev();
extern void _ZN10S3351C3_nt3v56Ev();
extern void _ZN10S3351C3_nt3v57Ev();
extern void _ZN10S3351C3_nt3v58Ev();
extern void _ZN10S3351C3_nt3v59Ev();
extern void _ZN10S3351C3_nt3v60Ev();
extern void _ZN10S3351C3_nt3v61Ev();
extern void _ZN10S3351C3_nt3v62Ev();
extern void _ZN10S3351C3_nt3v63Ev();
extern void _ZN10S3351C3_nt3v64Ev();
extern void _ZN10S3351C3_nt3v65Ev();
extern void _ZN10S3351C3_nt3v66Ev();
extern void _ZN10S3351C3_nt3v67Ev();
extern void _ZN10S3351C3_nt3v68Ev();
extern void _ZN10S3351C3_nt3v69Ev();
extern void _ZN10S3351C2_nt3v70Ev();
extern void _ZN10S3351C2_nt3v71Ev();
extern void _ZN10S3351C2_nt3v72Ev();
extern void _ZN10S3351C2_nt3v73Ev();
extern void _ZN10S3351C2_nt3v74Ev();
extern void _ZN10S3351C2_nt3v75Ev();
extern void _ZN10S3351C2_nt3v76Ev();
extern void _ZN10S3351C2_nt3v77Ev();
extern void _ZN10S3351C2_nt3v78Ev();
extern void _ZN10S3351C2_nt3v79Ev();
extern void _ZN10S3351C2_nt3v80Ev();
extern void _ZN10S3351C2_nt3v81Ev();
extern void _ZN10S3351C2_nt3v82Ev();
extern void _ZN10S3351C2_nt3v83Ev();
extern void _ZN10S3351C2_nt3v84Ev();
extern void _ZN10S3351C2_nt3v85Ev();
extern void _ZN10S3351C2_nt3v86Ev();
extern void _ZN10S3351C2_nt3v87Ev();
extern void _ZN10S3351C2_nt3v88Ev();
extern void _ZN10S3351C2_nt3v89Ev();
extern void _ZN10S3351C2_nt3v90Ev();
extern void _ZN10S3351C2_nt3v91Ev();
extern void _ZN10S3351C2_nt3v92Ev();
extern void _ZN10S3351C2_nt3v93Ev();
extern void _ZN10S3351C2_nt3v94Ev();
extern void _ZN10S3351C2_nt3v95Ev();
extern void _ZN10S3351C2_nt3v96Ev();
extern void _ZN10S3351C2_nt3v97Ev();
extern void _ZN10S3351C2_nt3v98Ev();
extern void _ZN10S3351C2_nt3v99Ev();
extern void _ZN10S3351C2_nt4v100Ev();
extern void _ZN10S3351C2_nt4v101Ev();
extern void _ZN10S3351C2_nt4v102Ev();
extern void _ZN10S3351C2_nt4v103Ev();
extern void _ZN10S3351C2_nt4v104Ev();
extern void _ZN10S3351C2_nt4v105Ev();
extern void _ZN10S3351C2_nt4v106Ev();
extern void _ZN10S3351C2_nt4v107Ev();
extern void _ZN10S3351C2_nt4v108Ev();
extern void _ZN10S3351C2_nt4v109Ev();
extern void _ZN10S3351C2_nt4v110Ev();
extern void _ZN10S3351C2_nt4v111Ev();
extern void _ZN10S3351C2_nt4v112Ev();
extern void _ZN10S3351C2_nt4v113Ev();
extern void _ZN10S3351C2_nt4v114Ev();
extern void _ZN10S3351C2_nt4v115Ev();
extern void _ZN10S3351C2_nt4v116Ev();
extern void _ZN10S3351C2_nt4v117Ev();
extern void _ZN10S3351C2_nt4v118Ev();
extern void _ZN10S3351C2_nt4v119Ev();
extern void _ZN10S3351C2_nt4v120Ev();
extern void _ZN10S3351C2_nt4v121Ev();
extern void _ZN10S3351C2_nt4v122Ev();
extern void _ZN10S3351C2_nt4v123Ev();
extern void _ZN10S3351C2_nt4v124Ev();
extern void _ZN10S3351C2_nt4v125Ev();
extern void _ZN10S3351C2_nt4v126Ev();
extern void _ZN10S3351C2_nt4v127Ev();
extern void _ZN10S3351C2_nt4v128Ev();
extern void _ZN10S3351C2_nt4v129Ev();
extern void _ZN10S3351C2_nt4v130Ev();
extern void _ZN10S3351C2_nt4v131Ev();
extern void _ZN10S3351C2_nt4v132Ev();
extern void _ZN10S3351C2_nt4v133Ev();
extern void _ZN10S3351C2_nt4v134Ev();
extern void _ZN10S3351C2_nt4v135Ev();
extern void _ZN10S3351C2_nt4v136Ev();
extern void _ZN10S3351C2_nt4v137Ev();
extern void _ZN10S3351C2_nt4v138Ev();
extern void _ZN10S3351C2_nt4v139Ev();
extern void _ZN10S3351C2_nt4v140Ev();
extern void _ZN10S3351C2_nt4v141Ev();
extern void _ZN10S3351C2_nt4v142Ev();
extern void _ZN10S3351C2_nt4v143Ev();
extern void _ZN10S3351C2_nt4v144Ev();
extern void _ZN10S3351C2_nt4v145Ev();
extern void _ZN10S3351C2_nt4v146Ev();
extern void _ZN10S3351C2_nt4v147Ev();
extern void _ZN10S3351C2_nt4v148Ev();
extern void _ZN10S3351C2_nt4v149Ev();
extern void _ZN10S3351C2_nt4v150Ev();
extern void _ZN10S3351C2_nt4v151Ev();
extern void _ZN10S3351C2_nt4v152Ev();
extern void _ZN10S3351C2_nt4v153Ev();
extern void _ZN10S3351C2_nt4v154Ev();
extern void _ZN10S3351C2_nt4v155Ev();
extern void _ZN10S3351C2_nt4v156Ev();
extern void _ZN10S3351C2_nt4v157Ev();
extern void _ZN10S3351C2_nt4v158Ev();
extern void _ZN10S3351C2_nt4v159Ev();
extern void _ZN10S3351C2_nt4v160Ev();
extern void _ZN10S3351C2_nt4v161Ev();
extern void _ZN10S3351C2_nt4v162Ev();
extern void _ZN10S3351C2_nt4v163Ev();
extern void _ZN10S3351C2_nt4v164Ev();
extern void _ZN10S3351C2_nt4v165Ev();
extern void _ZN10S3351C2_nt4v166Ev();
extern void _ZN10S3351C2_nt4v167Ev();
extern void _ZN10S3351C2_nt4v168Ev();
extern void _ZN10S3351C2_nt4v169Ev();
extern void _ZN10S3351C2_nt4v170Ev();
extern void _ZN10S3351C2_nt4v171Ev();
extern void _ZN10S3351C2_nt4v172Ev();
extern void _ZN10S3351C2_nt4v173Ev();
extern void _ZN10S3351C2_nt4v174Ev();
extern void _ZN10S3351C2_nt4v175Ev();
extern void _ZN10S3351C2_nt4v176Ev();
extern void _ZN10S3351C2_nt4v177Ev();
extern void _ZN10S3351C2_nt4v178Ev();
extern void _ZN10S3351C2_nt4v179Ev();
extern void _ZN10S3351C2_nt4v180Ev();
extern void _ZN10S3351C2_nt4v181Ev();
extern void _ZN10S3351C2_nt4v182Ev();
extern void _ZN10S3351C2_nt4v183Ev();
extern void _ZN10S3351C2_nt4v184Ev();
extern void _ZN10S3351C2_nt4v185Ev();
extern void _ZN10S3351C2_nt4v186Ev();
extern void _ZN10S3351C2_nt4v187Ev();
extern void _ZN10S3351C2_nt4v188Ev();
extern void _ZN10S3351C2_nt4v189Ev();
extern void _ZN10S3351C2_nt4v190Ev();
extern void _ZN10S3351C2_nt4v191Ev();
extern void _ZN10S3351C2_nt4v192Ev();
extern void _ZN10S3351C2_nt4v193Ev();
extern void _ZN10S3351C2_nt4v194Ev();
extern void _ZN10S3351C2_nt4v195Ev();
extern void _ZN10S3351C2_nt4v196Ev();
extern void _ZN10S3351C2_nt4v197Ev();
extern void _ZN10S3351C2_nt4v198Ev();
extern void _ZN10S3351C2_nt4v199Ev();
extern void _ZN10S3351C2_nt4v200Ev();
extern void _ZN10S3351C2_nt4v201Ev();
extern void _ZN10S3351C2_nt4v202Ev();
extern void _ZN10S3351C2_nt4v203Ev();
extern void _ZN10S3351C2_nt4v204Ev();
extern void _ZN10S3351C2_nt4v205Ev();
extern void _ZN10S3351C2_nt4v206Ev();
extern void _ZN10S3351C2_nt4v207Ev();
extern void _ZN10S3351C2_nt4v208Ev();
extern void _ZN10S3351C2_nt4v209Ev();
extern void _ZN10S3351C2_nt4v210Ev();
extern void _ZN10S3351C2_nt4v211Ev();
extern void _ZN10S3351C2_nt4v212Ev();
static  VTBL_ENTRY vtc_S3351C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3351C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3351C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v212Ev,
};
extern VTBL_ENTRY _ZTI10S3351C2_nt[];
VTBL_ENTRY *P__ZTI10S3351C2_nt = _ZTI10S3351C2_nt; 
extern  VTBL_ENTRY _ZTV10S3351C2_nt[];
Class_Descriptor cd_S3351C2_nt = {  "S3351C2_nt", // class name
  bases_S3351C2_nt, 1,
  &(vtc_S3351C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3351C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3351C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C23  : S3351C7_nt {
};
//SIG(-1 S3351C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3351C23()
{
  extern Class_Descriptor cd_S3351C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C23, buf);
    S3351C23 &lv = *(new (buf) S3351C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C23)");
    check_base_class_offset(lv, (S3351C7_nt*), 0, "S3351C23");
    test_class_info(&lv, &cd_S3351C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C23(Test_S3351C23, "S3351C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C23 = {  "S3351C23", // class name
  bases_S3351C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C22_nt  {
  ::S3351C23 s3351c22f0;
  void *s3351c22f1;
  int s3351c22f2;
  void  mf3351c22(); // _ZN11S3351C22_nt9mf3351c22Ev
};
//SIG(-1 S3351C22_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S3351C22_nt ::mf3351c22(){}

//skip512 S3351C22_nt

#else // __cplusplus

Class_Descriptor cd_S3351C22_nt = {  "S3351C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C21_nt  : S3351C22_nt {
};
//SIG(-1 S3351C21_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S3351C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S3351C22_nt;
static Base_Class bases_S3351C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C25  : S3351C7_nt {
};
//SIG(-1 S3351C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3351C25()
{
  extern Class_Descriptor cd_S3351C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C25, buf);
    S3351C25 &lv = *(new (buf) S3351C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C25)");
    check_base_class_offset(lv, (S3351C7_nt*), 0, "S3351C25");
    test_class_info(&lv, &cd_S3351C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C25(Test_S3351C25, "S3351C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C25 = {  "S3351C25", // class name
  bases_S3351C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C24  : S3351C25 {
};
//SIG(-1 S3351C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3351C24()
{
  extern Class_Descriptor cd_S3351C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C24, buf);
    S3351C24 &lv = *(new (buf) S3351C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C24)");
    check_base_class_offset(lv, (S3351C7_nt*)(S3351C25*), 0, "S3351C24");
    check_base_class_offset(lv, (S3351C25*), 0, "S3351C24");
    test_class_info(&lv, &cd_S3351C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C24(Test_S3351C24, "S3351C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
extern Class_Descriptor cd_S3351C25;
static Base_Class bases_S3351C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C24 = {  "S3351C24", // class name
  bases_S3351C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C29  : S3351C7_nt {
};
//SIG(-1 S3351C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3351C29()
{
  extern Class_Descriptor cd_S3351C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C29, buf);
    S3351C29 &lv = *(new (buf) S3351C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C29)");
    check_base_class_offset(lv, (S3351C7_nt*), 0, "S3351C29");
    test_class_info(&lv, &cd_S3351C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C29(Test_S3351C29, "S3351C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
static Base_Class bases_S3351C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C29 = {  "S3351C29", // class name
  bases_S3351C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C28  : S3351C29 {
};
//SIG(-1 S3351C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3351C28()
{
  extern Class_Descriptor cd_S3351C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3351C28, buf);
    S3351C28 &lv = *(new (buf) S3351C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3351C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C28)");
    check_base_class_offset(lv, (S3351C7_nt*)(S3351C29*), 0, "S3351C28");
    check_base_class_offset(lv, (S3351C29*), 0, "S3351C28");
    test_class_info(&lv, &cd_S3351C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C28(Test_S3351C28, "S3351C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3351C7_nt;
extern Class_Descriptor cd_S3351C29;
static Base_Class bases_S3351C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3351C28 = {  "S3351C28", // class name
  bases_S3351C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3351C1  : S3351C2_nt {
  void *s3351c1f0;
  int s3351c1f1;
  ::S3351C21_nt s3351c1f2;
  void *s3351c1f3;
  int s3351c1f4[2];
  ::S3351C24 s3351c1f5;
  ::S3351C24 s3351c1f6;
  ::S3351C24 s3351c1f7;
  ::S3351C28 s3351c1f8;
  ::S3351C21_nt s3351c1f9;
  virtual  ~S3351C1(); // _ZN7S3351C1D1Ev
  virtual void  v1(); // _ZN7S3351C12v1Ev
  virtual void  v2(); // _ZN7S3351C12v2Ev
  virtual void  v3(); // _ZN7S3351C12v3Ev
  virtual void  v4(); // _ZN7S3351C12v4Ev
  virtual void  v5(); // _ZN7S3351C12v5Ev
  S3351C1(); // tgen
};
//SIG(1 S3351C1) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 Fp Fi FC14{ BC15{ m FC16{ BC7} Fp Fi}} Fp Fi[2] FC17{ BC18{ BC7}} FC17 FC17 FC19{ BC20{ BC7}} FC14}


 S3351C1 ::~S3351C1(){ note_dtor("S3351C1", this);}
void  S3351C1 ::v1(){vfunc_called(this, "_ZN7S3351C12v1Ev");}
void  S3351C1 ::v2(){vfunc_called(this, "_ZN7S3351C12v2Ev");}
void  S3351C1 ::v3(){vfunc_called(this, "_ZN7S3351C12v3Ev");}
void  S3351C1 ::v4(){vfunc_called(this, "_ZN7S3351C12v4Ev");}
void  S3351C1 ::v5(){vfunc_called(this, "_ZN7S3351C12v5Ev");}
S3351C1 ::S3351C1(){ note_ctor("S3351C1", this);} // tgen

static void Test_S3351C1()
{
  extern Class_Descriptor cd_S3351C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,137)];
    init_test(&cd_S3351C1, buf);
    S3351C1 *dp, &lv = *(dp=new (buf) S3351C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,544), "sizeof(S3351C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3351C1)");
    check_base_class_offset(lv, (S3351C3_nt*)(S3351C2_nt*), 0, "S3351C1");
    check_base_class_offset(lv, (S3351C2_nt*), 0, "S3351C1");
    check_field_offset(lv, s3351c1f0, ABISELECT(568,436), "S3351C1.s3351c1f0");
    check_field_offset(lv, s3351c1f1, ABISELECT(576,440), "S3351C1.s3351c1f1");
    check_field_offset(lv, s3351c1f2, ABISELECT(584,444), "S3351C1.s3351c1f2");
    check_field_offset(lv, s3351c1f3, ABISELECT(616,464), "S3351C1.s3351c1f3");
    check_field_offset(lv, s3351c1f4, ABISELECT(624,468), "S3351C1.s3351c1f4");
    check_field_offset(lv, s3351c1f5, ABISELECT(632,476), "S3351C1.s3351c1f5");
    check_field_offset(lv, s3351c1f6, ABISELECT(648,488), "S3351C1.s3351c1f6");
    check_field_offset(lv, s3351c1f7, ABISELECT(664,500), "S3351C1.s3351c1f7");
    check_field_offset(lv, s3351c1f8, ABISELECT(680,512), "S3351C1.s3351c1f8");
    check_field_offset(lv, s3351c1f9, ABISELECT(696,524), "S3351C1.s3351c1f9");
    test_class_info(&lv, &cd_S3351C1);
    dp->~S3351C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3351C1(Test_S3351C1, "S3351C1", ABISELECT(728,544));

#else // __cplusplus

extern void _ZN7S3351C1C1Ev();
extern void _ZN7S3351C1D1Ev();
Name_Map name_map_S3351C1[] = {
  NSPAIR(_ZN7S3351C1C1Ev),
  NSPAIR(_ZN7S3351C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3351C3_nt;
extern VTBL_ENTRY _ZTI10S3351C3_nt[];
extern  VTBL_ENTRY _ZTV10S3351C3_nt[];
extern Class_Descriptor cd_S3351C2_nt;
extern VTBL_ENTRY _ZTI10S3351C2_nt[];
extern  VTBL_ENTRY _ZTV10S3351C2_nt[];
static Base_Class bases_S3351C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3351C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3351C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3351C1[];
extern void _ZN7S3351C1D1Ev();
extern void _ZN7S3351C1D0Ev();
extern void _ZN10S3351C3_nt2v6Ev();
extern void _ZN10S3351C3_nt2v7Ev();
extern void _ZN10S3351C3_nt2v8Ev();
extern void _ZN10S3351C3_nt2v9Ev();
extern void _ZN10S3351C3_nt3v10Ev();
extern void _ZN10S3351C3_nt3v11Ev();
extern void _ZN10S3351C3_nt3v12Ev();
extern void _ZN10S3351C3_nt3v13Ev();
extern void _ZN10S3351C3_nt3v14Ev();
extern void _ZN10S3351C3_nt3v15Ev();
extern void _ZN10S3351C3_nt3v16Ev();
extern void _ZN10S3351C3_nt3v17Ev();
extern void _ZN10S3351C3_nt3v18Ev();
extern void _ZN10S3351C3_nt3v19Ev();
extern void _ZN10S3351C3_nt3v20Ev();
extern void _ZN10S3351C3_nt3v21Ev();
extern void _ZN10S3351C3_nt3v22Ev();
extern void _ZN10S3351C3_nt3v23Ev();
extern void _ZN10S3351C3_nt3v24Ev();
extern void _ZN10S3351C3_nt3v25Ev();
extern void _ZN10S3351C3_nt3v26Ev();
extern void _ZN10S3351C3_nt3v27Ev();
extern void _ZN10S3351C3_nt3v28Ev();
extern void _ZN10S3351C3_nt3v29Ev();
extern void _ZN10S3351C3_nt3v30Ev();
extern void _ZN10S3351C3_nt3v31Ev();
extern void _ZN10S3351C3_nt3v32Ev();
extern void _ZN10S3351C3_nt3v33Ev();
extern void _ZN10S3351C3_nt3v34Ev();
extern void _ZN10S3351C3_nt3v35Ev();
extern void _ZN10S3351C3_nt3v36Ev();
extern void _ZN10S3351C3_nt3v37Ev();
extern void _ZN10S3351C3_nt3v38Ev();
extern void _ZN10S3351C3_nt3v39Ev();
extern void _ZN10S3351C3_nt3v40Ev();
extern void _ZN10S3351C3_nt3v41Ev();
extern void _ZN10S3351C3_nt3v42Ev();
extern void _ZN10S3351C3_nt3v43Ev();
extern void _ZN10S3351C3_nt3v44Ev();
extern void _ZN10S3351C3_nt3v45Ev();
extern void _ZN10S3351C3_nt3v46Ev();
extern void _ZN10S3351C3_nt3v47Ev();
extern void _ZN10S3351C3_nt3v48Ev();
extern void _ZN10S3351C3_nt3v49Ev();
extern void _ZN10S3351C3_nt3v50Ev();
extern void _ZN10S3351C3_nt3v51Ev();
extern void _ZN10S3351C3_nt3v52Ev();
extern void _ZN10S3351C3_nt3v53Ev();
extern void _ZN10S3351C3_nt3v54Ev();
extern void _ZN10S3351C3_nt3v55Ev();
extern void _ZN10S3351C3_nt3v56Ev();
extern void _ZN10S3351C3_nt3v57Ev();
extern void _ZN10S3351C3_nt3v58Ev();
extern void _ZN10S3351C3_nt3v59Ev();
extern void _ZN10S3351C3_nt3v60Ev();
extern void _ZN10S3351C3_nt3v61Ev();
extern void _ZN10S3351C3_nt3v62Ev();
extern void _ZN10S3351C3_nt3v63Ev();
extern void _ZN10S3351C3_nt3v64Ev();
extern void _ZN10S3351C3_nt3v65Ev();
extern void _ZN10S3351C3_nt3v66Ev();
extern void _ZN10S3351C3_nt3v67Ev();
extern void _ZN10S3351C3_nt3v68Ev();
extern void _ZN10S3351C3_nt3v69Ev();
extern void _ZN10S3351C2_nt3v70Ev();
extern void _ZN10S3351C2_nt3v71Ev();
extern void _ZN10S3351C2_nt3v72Ev();
extern void _ZN10S3351C2_nt3v73Ev();
extern void _ZN10S3351C2_nt3v74Ev();
extern void _ZN10S3351C2_nt3v75Ev();
extern void _ZN10S3351C2_nt3v76Ev();
extern void _ZN10S3351C2_nt3v77Ev();
extern void _ZN10S3351C2_nt3v78Ev();
extern void _ZN10S3351C2_nt3v79Ev();
extern void _ZN10S3351C2_nt3v80Ev();
extern void _ZN10S3351C2_nt3v81Ev();
extern void _ZN10S3351C2_nt3v82Ev();
extern void _ZN10S3351C2_nt3v83Ev();
extern void _ZN10S3351C2_nt3v84Ev();
extern void _ZN10S3351C2_nt3v85Ev();
extern void _ZN10S3351C2_nt3v86Ev();
extern void _ZN10S3351C2_nt3v87Ev();
extern void _ZN10S3351C2_nt3v88Ev();
extern void _ZN10S3351C2_nt3v89Ev();
extern void _ZN10S3351C2_nt3v90Ev();
extern void _ZN10S3351C2_nt3v91Ev();
extern void _ZN10S3351C2_nt3v92Ev();
extern void _ZN10S3351C2_nt3v93Ev();
extern void _ZN10S3351C2_nt3v94Ev();
extern void _ZN10S3351C2_nt3v95Ev();
extern void _ZN10S3351C2_nt3v96Ev();
extern void _ZN10S3351C2_nt3v97Ev();
extern void _ZN10S3351C2_nt3v98Ev();
extern void _ZN10S3351C2_nt3v99Ev();
extern void _ZN10S3351C2_nt4v100Ev();
extern void _ZN10S3351C2_nt4v101Ev();
extern void _ZN10S3351C2_nt4v102Ev();
extern void _ZN10S3351C2_nt4v103Ev();
extern void _ZN10S3351C2_nt4v104Ev();
extern void _ZN10S3351C2_nt4v105Ev();
extern void _ZN10S3351C2_nt4v106Ev();
extern void _ZN10S3351C2_nt4v107Ev();
extern void _ZN10S3351C2_nt4v108Ev();
extern void _ZN10S3351C2_nt4v109Ev();
extern void _ZN10S3351C2_nt4v110Ev();
extern void _ZN10S3351C2_nt4v111Ev();
extern void _ZN10S3351C2_nt4v112Ev();
extern void _ZN10S3351C2_nt4v113Ev();
extern void _ZN10S3351C2_nt4v114Ev();
extern void _ZN10S3351C2_nt4v115Ev();
extern void _ZN10S3351C2_nt4v116Ev();
extern void _ZN10S3351C2_nt4v117Ev();
extern void _ZN10S3351C2_nt4v118Ev();
extern void _ZN10S3351C2_nt4v119Ev();
extern void _ZN10S3351C2_nt4v120Ev();
extern void _ZN10S3351C2_nt4v121Ev();
extern void _ZN10S3351C2_nt4v122Ev();
extern void _ZN10S3351C2_nt4v123Ev();
extern void _ZN10S3351C2_nt4v124Ev();
extern void _ZN10S3351C2_nt4v125Ev();
extern void _ZN10S3351C2_nt4v126Ev();
extern void _ZN10S3351C2_nt4v127Ev();
extern void _ZN10S3351C2_nt4v128Ev();
extern void _ZN10S3351C2_nt4v129Ev();
extern void _ZN10S3351C2_nt4v130Ev();
extern void _ZN10S3351C2_nt4v131Ev();
extern void _ZN10S3351C2_nt4v132Ev();
extern void _ZN10S3351C2_nt4v133Ev();
extern void _ZN10S3351C2_nt4v134Ev();
extern void _ZN10S3351C2_nt4v135Ev();
extern void _ZN10S3351C2_nt4v136Ev();
extern void _ZN10S3351C2_nt4v137Ev();
extern void _ZN10S3351C2_nt4v138Ev();
extern void _ZN10S3351C2_nt4v139Ev();
extern void _ZN10S3351C2_nt4v140Ev();
extern void _ZN10S3351C2_nt4v141Ev();
extern void _ZN10S3351C2_nt4v142Ev();
extern void _ZN10S3351C2_nt4v143Ev();
extern void _ZN10S3351C2_nt4v144Ev();
extern void _ZN10S3351C2_nt4v145Ev();
extern void _ZN10S3351C2_nt4v146Ev();
extern void _ZN10S3351C2_nt4v147Ev();
extern void _ZN10S3351C2_nt4v148Ev();
extern void _ZN10S3351C2_nt4v149Ev();
extern void _ZN10S3351C2_nt4v150Ev();
extern void _ZN10S3351C2_nt4v151Ev();
extern void _ZN10S3351C2_nt4v152Ev();
extern void _ZN10S3351C2_nt4v153Ev();
extern void _ZN10S3351C2_nt4v154Ev();
extern void _ZN10S3351C2_nt4v155Ev();
extern void _ZN10S3351C2_nt4v156Ev();
extern void _ZN10S3351C2_nt4v157Ev();
extern void _ZN10S3351C2_nt4v158Ev();
extern void _ZN10S3351C2_nt4v159Ev();
extern void _ZN10S3351C2_nt4v160Ev();
extern void _ZN10S3351C2_nt4v161Ev();
extern void _ZN10S3351C2_nt4v162Ev();
extern void _ZN10S3351C2_nt4v163Ev();
extern void _ZN10S3351C2_nt4v164Ev();
extern void _ZN10S3351C2_nt4v165Ev();
extern void _ZN10S3351C2_nt4v166Ev();
extern void _ZN10S3351C2_nt4v167Ev();
extern void _ZN10S3351C2_nt4v168Ev();
extern void _ZN10S3351C2_nt4v169Ev();
extern void _ZN10S3351C2_nt4v170Ev();
extern void _ZN10S3351C2_nt4v171Ev();
extern void _ZN10S3351C2_nt4v172Ev();
extern void _ZN10S3351C2_nt4v173Ev();
extern void _ZN10S3351C2_nt4v174Ev();
extern void _ZN10S3351C2_nt4v175Ev();
extern void _ZN10S3351C2_nt4v176Ev();
extern void _ZN10S3351C2_nt4v177Ev();
extern void _ZN10S3351C2_nt4v178Ev();
extern void _ZN10S3351C2_nt4v179Ev();
extern void _ZN10S3351C2_nt4v180Ev();
extern void _ZN10S3351C2_nt4v181Ev();
extern void _ZN10S3351C2_nt4v182Ev();
extern void _ZN10S3351C2_nt4v183Ev();
extern void _ZN10S3351C2_nt4v184Ev();
extern void _ZN10S3351C2_nt4v185Ev();
extern void _ZN10S3351C2_nt4v186Ev();
extern void _ZN10S3351C2_nt4v187Ev();
extern void _ZN10S3351C2_nt4v188Ev();
extern void _ZN10S3351C2_nt4v189Ev();
extern void _ZN10S3351C2_nt4v190Ev();
extern void _ZN10S3351C2_nt4v191Ev();
extern void _ZN10S3351C2_nt4v192Ev();
extern void _ZN10S3351C2_nt4v193Ev();
extern void _ZN10S3351C2_nt4v194Ev();
extern void _ZN10S3351C2_nt4v195Ev();
extern void _ZN10S3351C2_nt4v196Ev();
extern void _ZN10S3351C2_nt4v197Ev();
extern void _ZN10S3351C2_nt4v198Ev();
extern void _ZN10S3351C2_nt4v199Ev();
extern void _ZN10S3351C2_nt4v200Ev();
extern void _ZN10S3351C2_nt4v201Ev();
extern void _ZN10S3351C2_nt4v202Ev();
extern void _ZN10S3351C2_nt4v203Ev();
extern void _ZN10S3351C2_nt4v204Ev();
extern void _ZN10S3351C2_nt4v205Ev();
extern void _ZN10S3351C2_nt4v206Ev();
extern void _ZN10S3351C2_nt4v207Ev();
extern void _ZN10S3351C2_nt4v208Ev();
extern void _ZN10S3351C2_nt4v209Ev();
extern void _ZN10S3351C2_nt4v210Ev();
extern void _ZN10S3351C2_nt4v211Ev();
extern void _ZN10S3351C2_nt4v212Ev();
extern void _ZN7S3351C12v1Ev();
extern void _ZN7S3351C12v2Ev();
extern void _ZN7S3351C12v3Ev();
extern void _ZN7S3351C12v4Ev();
extern void _ZN7S3351C12v5Ev();
static  VTBL_ENTRY vtc_S3351C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3351C1[0]),
  (VTBL_ENTRY)&_ZN7S3351C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3351C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3351C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3351C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN7S3351C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3351C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3351C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3351C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3351C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S3351C1[];
extern  VTBL_ENTRY _ZTV7S3351C1[];
Class_Descriptor cd_S3351C1 = {  "S3351C1", // class name
  bases_S3351C1, 2,
  &(vtc_S3351C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(728,544), // object size
  NSPAIRA(_ZTI7S3351C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3351C1),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C7_nt  {
  void  mf2264c7(); // _ZN10S2264C7_nt8mf2264c7Ev
};
//SIG(-1 S2264C7_nt) C1{ m}


void  S2264C7_nt ::mf2264c7(){}

//skip512 S2264C7_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S2264C7_nt[];
VTBL_ENTRY *P__ZTI10S2264C7_nt = _ZTI10S2264C7_nt; 
Class_Descriptor cd_S2264C7_nt = {  "S2264C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S2264C7_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C6_nt  {
  void *s2264c6f0;
  int s2264c6f1;
  ::S2264C7_nt s2264c6f2;
  ::S2264C7_nt s2264c6f3;
  void  mf2264c6(); // _ZN10S2264C6_nt8mf2264c6Ev
};
//SIG(-1 S2264C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2264C6_nt ::mf2264c6(){}

//skip512 S2264C6_nt

#else // __cplusplus

Class_Descriptor cd_S2264C6_nt = {  "S2264C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C5_nt  : S2264C6_nt {
};
//SIG(-1 S2264C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2264C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2264C6_nt;
static Base_Class bases_S2264C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2264C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C4_nt  {
  void *s2264c4f0;
  int s2264c4f1;
  ::S2264C5_nt s2264c4f2;
  ::S2264C5_nt s2264c4f3;
  int s2264c4f4;
  virtual  ~S2264C4_nt(); // _ZN10S2264C4_ntD1Ev
  virtual void  v4(); // _ZN10S2264C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2264C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2264C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2264C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2264C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2264C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2264C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2264C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2264C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2264C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2264C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2264C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2264C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2264C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2264C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2264C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2264C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2264C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2264C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2264C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2264C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2264C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2264C4_nt3v26Ev
  S2264C4_nt(); // tgen
};
//SIG(-1 S2264C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2264C4_nt ::~S2264C4_nt(){ note_dtor("S2264C4_nt", this);}
void  S2264C4_nt ::v4(){vfunc_called(this, "_ZN10S2264C4_nt2v4Ev");}
void  S2264C4_nt ::v5(){vfunc_called(this, "_ZN10S2264C4_nt2v5Ev");}
void  S2264C4_nt ::v6(){vfunc_called(this, "_ZN10S2264C4_nt2v6Ev");}
void  S2264C4_nt ::v7(){vfunc_called(this, "_ZN10S2264C4_nt2v7Ev");}
void  S2264C4_nt ::v8(){vfunc_called(this, "_ZN10S2264C4_nt2v8Ev");}
void  S2264C4_nt ::v9(){vfunc_called(this, "_ZN10S2264C4_nt2v9Ev");}
void  S2264C4_nt ::v10(){vfunc_called(this, "_ZN10S2264C4_nt3v10Ev");}
void  S2264C4_nt ::v11(){vfunc_called(this, "_ZN10S2264C4_nt3v11Ev");}
void  S2264C4_nt ::v12(){vfunc_called(this, "_ZN10S2264C4_nt3v12Ev");}
void  S2264C4_nt ::v13(){vfunc_called(this, "_ZN10S2264C4_nt3v13Ev");}
void  S2264C4_nt ::v14(){vfunc_called(this, "_ZN10S2264C4_nt3v14Ev");}
void  S2264C4_nt ::v15(){vfunc_called(this, "_ZN10S2264C4_nt3v15Ev");}
void  S2264C4_nt ::v16(){vfunc_called(this, "_ZN10S2264C4_nt3v16Ev");}
void  S2264C4_nt ::v17(){vfunc_called(this, "_ZN10S2264C4_nt3v17Ev");}
void  S2264C4_nt ::v18(){vfunc_called(this, "_ZN10S2264C4_nt3v18Ev");}
void  S2264C4_nt ::v19(){vfunc_called(this, "_ZN10S2264C4_nt3v19Ev");}
void  S2264C4_nt ::v20(){vfunc_called(this, "_ZN10S2264C4_nt3v20Ev");}
void  S2264C4_nt ::v21(){vfunc_called(this, "_ZN10S2264C4_nt3v21Ev");}
void  S2264C4_nt ::v22(){vfunc_called(this, "_ZN10S2264C4_nt3v22Ev");}
void  S2264C4_nt ::v23(){vfunc_called(this, "_ZN10S2264C4_nt3v23Ev");}
void  S2264C4_nt ::v24(){vfunc_called(this, "_ZN10S2264C4_nt3v24Ev");}
void  S2264C4_nt ::v25(){vfunc_called(this, "_ZN10S2264C4_nt3v25Ev");}
void  S2264C4_nt ::v26(){vfunc_called(this, "_ZN10S2264C4_nt3v26Ev");}
S2264C4_nt ::S2264C4_nt(){ note_ctor("S2264C4_nt", this);} // tgen

//skip512 S2264C4_nt

#else // __cplusplus

extern void _ZN10S2264C4_ntC1Ev();
extern void _ZN10S2264C4_ntD1Ev();
Name_Map name_map_S2264C4_nt[] = {
  NSPAIR(_ZN10S2264C4_ntC1Ev),
  NSPAIR(_ZN10S2264C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2264C4_nt[];
extern void _ZN10S2264C4_ntD1Ev();
extern void _ZN10S2264C4_ntD0Ev();
extern void _ZN10S2264C4_nt2v4Ev();
extern void _ZN10S2264C4_nt2v5Ev();
extern void _ZN10S2264C4_nt2v6Ev();
extern void _ZN10S2264C4_nt2v7Ev();
extern void _ZN10S2264C4_nt2v8Ev();
extern void _ZN10S2264C4_nt2v9Ev();
extern void _ZN10S2264C4_nt3v10Ev();
extern void _ZN10S2264C4_nt3v11Ev();
extern void _ZN10S2264C4_nt3v12Ev();
extern void _ZN10S2264C4_nt3v13Ev();
extern void _ZN10S2264C4_nt3v14Ev();
extern void _ZN10S2264C4_nt3v15Ev();
extern void _ZN10S2264C4_nt3v16Ev();
extern void _ZN10S2264C4_nt3v17Ev();
extern void _ZN10S2264C4_nt3v18Ev();
extern void _ZN10S2264C4_nt3v19Ev();
extern void _ZN10S2264C4_nt3v20Ev();
extern void _ZN10S2264C4_nt3v21Ev();
extern void _ZN10S2264C4_nt3v22Ev();
extern void _ZN10S2264C4_nt3v23Ev();
extern void _ZN10S2264C4_nt3v24Ev();
extern void _ZN10S2264C4_nt3v25Ev();
extern void _ZN10S2264C4_nt3v26Ev();
static  VTBL_ENTRY vtc_S2264C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2264C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2264C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v26Ev,
};
extern VTBL_ENTRY _ZTI10S2264C4_nt[];
VTBL_ENTRY *P__ZTI10S2264C4_nt = _ZTI10S2264C4_nt; 
extern  VTBL_ENTRY _ZTV10S2264C4_nt[];
Class_Descriptor cd_S2264C4_nt = {  "S2264C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2264C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2264C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2264C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C14_nt  {
  __tsi64 s2264c14f0[2];
  void  mf2264c14(); // _ZN11S2264C14_nt9mf2264c14Ev
};
//SIG(-1 S2264C14_nt) C1{ m FL[2]}


void  S2264C14_nt ::mf2264c14(){}

//skip512 S2264C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C13_nt  {
  ::S2264C14_nt s2264c13f0;
  void  mf2264c13(); // _ZN11S2264C13_nt9mf2264c13Ev
};
//SIG(-1 S2264C13_nt) C1{ m FC2{ m FL[2]}}


void  S2264C13_nt ::mf2264c13(){}

//skip512 S2264C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C17_nt  {
  ::S2264C13_nt s2264c17f0;
  void  mf2264c17(); // _ZN11S2264C17_nt9mf2264c17Ev
};
//SIG(-1 S2264C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2264C17_nt ::mf2264c17(){}

//skip512 S2264C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C18_nt  {
  ::S2264C13_nt s2264c18f0;
  ::S2264C13_nt s2264c18f1;
  ::S2264C13_nt s2264c18f2;
  ::S2264C13_nt s2264c18f3;
  void  mf2264c18(); // _ZN11S2264C18_nt9mf2264c18Ev
};
//SIG(-1 S2264C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2264C18_nt ::mf2264c18(){}

//skip512 S2264C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C21  {
  void  mf2264c21(); // _ZN8S2264C219mf2264c21Ev
};
//SIG(-1 S2264C21) C1{ m}


void  S2264C21 ::mf2264c21(){}

static void Test_S2264C21()
{
  {
    init_simple_test("S2264C21");
    S2264C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2264C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2264C21)");
  }
}
static Arrange_To_Call_Me vS2264C21(Test_S2264C21, "S2264C21", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2264C21[];
VTBL_ENTRY *P__ZTI8S2264C21 = _ZTI8S2264C21; 
Class_Descriptor cd_S2264C21 = {  "S2264C21", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2264C21),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C20_nt  {
  void *s2264c20f0;
  int s2264c20f1;
  ::S2264C21 s2264c20f2;
  void  mf2264c20(); // _ZN11S2264C20_nt9mf2264c20Ev
};
//SIG(-1 S2264C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2264C20_nt ::mf2264c20(){}

//skip512 S2264C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C19_nt  {
  ::S2264C20_nt s2264c19f0;
  int s2264c19f1;
  void  mf2264c19(); // _ZN11S2264C19_nt9mf2264c19Ev
};
//SIG(-1 S2264C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2264C19_nt ::mf2264c19(){}

//skip512 S2264C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C24  {
  void  mf2264c24(); // _ZN8S2264C249mf2264c24Ev
};
//SIG(-1 S2264C24) C1{ m}


void  S2264C24 ::mf2264c24(){}

static void Test_S2264C24()
{
  {
    init_simple_test("S2264C24");
    S2264C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2264C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2264C24)");
  }
}
static Arrange_To_Call_Me vS2264C24(Test_S2264C24, "S2264C24", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2264C24[];
VTBL_ENTRY *P__ZTI8S2264C24 = _ZTI8S2264C24; 
Class_Descriptor cd_S2264C24 = {  "S2264C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2264C24),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C22  {
  void *s2264c22f0;
  int s2264c22f1;
  ::S2264C21 s2264c22f2;
  ::S2264C24 s2264c22f3;
  void  mf2264c22(); // _ZN8S2264C229mf2264c22Ev
};
//SIG(-1 S2264C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2264C22 ::mf2264c22(){}

static void Test_S2264C22()
{
  {
    init_simple_test("S2264C22");
    S2264C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2264C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2264C22)");
    check_field_offset(lv, s2264c22f0, 0, "S2264C22.s2264c22f0");
    check_field_offset(lv, s2264c22f1, ABISELECT(8,4), "S2264C22.s2264c22f1");
    check_field_offset(lv, s2264c22f2, ABISELECT(12,8), "S2264C22.s2264c22f2");
    check_field_offset(lv, s2264c22f3, ABISELECT(13,9), "S2264C22.s2264c22f3");
  }
}
static Arrange_To_Call_Me vS2264C22(Test_S2264C22, "S2264C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C28  {
  void  mf2264c28(); // _ZN8S2264C289mf2264c28Ev
};
//SIG(-1 S2264C28) C1{ m}


void  S2264C28 ::mf2264c28(){}

static void Test_S2264C28()
{
  {
    init_simple_test("S2264C28");
    S2264C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2264C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2264C28)");
  }
}
static Arrange_To_Call_Me vS2264C28(Test_S2264C28, "S2264C28", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2264C28[];
VTBL_ENTRY *P__ZTI8S2264C28 = _ZTI8S2264C28; 
Class_Descriptor cd_S2264C28 = {  "S2264C28", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2264C28),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C26  {
  void *s2264c26f0;
  int s2264c26f1;
  ::S2264C24 s2264c26f2;
  ::S2264C28 s2264c26f3;
  void  mf2264c26(); // _ZN8S2264C269mf2264c26Ev
};
//SIG(-1 S2264C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2264C26 ::mf2264c26(){}

static void Test_S2264C26()
{
  {
    init_simple_test("S2264C26");
    S2264C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2264C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2264C26)");
    check_field_offset(lv, s2264c26f0, 0, "S2264C26.s2264c26f0");
    check_field_offset(lv, s2264c26f1, ABISELECT(8,4), "S2264C26.s2264c26f1");
    check_field_offset(lv, s2264c26f2, ABISELECT(12,8), "S2264C26.s2264c26f2");
    check_field_offset(lv, s2264c26f3, ABISELECT(13,9), "S2264C26.s2264c26f3");
  }
}
static Arrange_To_Call_Me vS2264C26(Test_S2264C26, "S2264C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2264C26 = {  "S2264C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C25  : S2264C26 {
};
//SIG(-1 S2264C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2264C25()
{
  extern Class_Descriptor cd_S2264C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2264C25, buf);
    S2264C25 &lv = *(new (buf) S2264C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2264C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2264C25)");
    check_base_class_offset(lv, (S2264C26*), 0, "S2264C25");
    test_class_info(&lv, &cd_S2264C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2264C25(Test_S2264C25, "S2264C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2264C26;
static Base_Class bases_S2264C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2264C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2264C25 = {  "S2264C25", // class name
  bases_S2264C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C29_nt  {
  void *s2264c29f0;
  int s2264c29f1[2];
  ::S2264C28 s2264c29f2;
  void  mf2264c29(); // _ZN11S2264C29_nt9mf2264c29Ev
};
//SIG(-1 S2264C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2264C29_nt ::mf2264c29(){}

//skip512 S2264C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C38  {
  void  mf2264c38(); // _ZN8S2264C389mf2264c38Ev
};
//SIG(-1 S2264C38) C1{ m}


void  S2264C38 ::mf2264c38(){}

static void Test_S2264C38()
{
  {
    init_simple_test("S2264C38");
    S2264C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2264C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2264C38)");
  }
}
static Arrange_To_Call_Me vS2264C38(Test_S2264C38, "S2264C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2264C38[];
VTBL_ENTRY *P__ZTI8S2264C38 = _ZTI8S2264C38; 
Class_Descriptor cd_S2264C38 = {  "S2264C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2264C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C37  {
  void *s2264c37f0;
  int s2264c37f1[2];
  ::S2264C38 s2264c37f2;
  void  mf2264c37(); // _ZN8S2264C379mf2264c37Ev
};
//SIG(-1 S2264C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2264C37 ::mf2264c37(){}

static void Test_S2264C37()
{
  {
    init_simple_test("S2264C37");
    S2264C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2264C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2264C37)");
    check_field_offset(lv, s2264c37f0, 0, "S2264C37.s2264c37f0");
    check_field_offset(lv, s2264c37f1, ABISELECT(8,4), "S2264C37.s2264c37f1");
    check_field_offset(lv, s2264c37f2, ABISELECT(16,12), "S2264C37.s2264c37f2");
  }
}
static Arrange_To_Call_Me vS2264C37(Test_S2264C37, "S2264C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C3_nt  : S2264C4_nt {
  ::S2264C13_nt s2264c3f0;
  ::S2264C13_nt s2264c3f1;
  ::S2264C13_nt s2264c3f2;
  ::S2264C13_nt s2264c3f3;
  ::S2264C17_nt s2264c3f4;
  ::S2264C18_nt s2264c3f5;
  ::S2264C18_nt s2264c3f6;
  ::S2264C13_nt s2264c3f7;
  ::S2264C13_nt s2264c3f8;
  ::S2264C13_nt s2264c3f9;
  void *s2264c3f10;
  ::S2264C17_nt s2264c3f11;
  ::S2264C19_nt s2264c3f12;
  int s2264c3f13;
  void *s2264c3f14[7];
  ::S2264C22 s2264c3f15;
  int s2264c3f16:8;
  int s2264c3f17:8;
  int s2264c3f18:16;
  int s2264c3f19:16;
  int s2264c3f20:8;
  int s2264c3f21:8;
  int s2264c3f22:8;
  int s2264c3f23:32;
  int s2264c3f24:8;
  int s2264c3f25:4;
  int s2264c3f26:4;
  int s2264c3f27:4;
  int s2264c3f28:4;
  int s2264c3f29:4;
  int s2264c3f30:4;
  int s2264c3f31:4;
  int s2264c3f32:4;
  int s2264c3f33:4;
  int s2264c3f34:4;
  unsigned char s2264c3f35:1;
  unsigned char s2264c3f36:1;
  unsigned char s2264c3f37:1;
  unsigned char s2264c3f38:1;
  unsigned char s2264c3f39:1;
  unsigned char s2264c3f40:1;
  unsigned char s2264c3f41:1;
  unsigned char s2264c3f42:1;
  unsigned char s2264c3f43:1;
  unsigned char s2264c3f44:1;
  unsigned char s2264c3f45:1;
  unsigned char s2264c3f46:1;
  unsigned char s2264c3f47:1;
  unsigned char s2264c3f48:1;
  unsigned char s2264c3f49:1;
  unsigned char s2264c3f50:1;
  unsigned char s2264c3f51:1;
  unsigned char s2264c3f52:1;
  unsigned char s2264c3f53:1;
  unsigned char s2264c3f54:1;
  unsigned char s2264c3f55:1;
  unsigned char s2264c3f56:1;
  unsigned char s2264c3f57:1;
  unsigned char s2264c3f58:1;
  unsigned char s2264c3f59:1;
  unsigned char s2264c3f60:1;
  unsigned char s2264c3f61:1;
  unsigned char s2264c3f62:1;
  unsigned char s2264c3f63:1;
  unsigned char s2264c3f64:1;
  unsigned char s2264c3f65:1;
  unsigned char s2264c3f66:1;
  unsigned char s2264c3f67:1;
  unsigned char s2264c3f68:1;
  unsigned char s2264c3f69:1;
  unsigned char s2264c3f70:1;
  unsigned char s2264c3f71:1;
  unsigned char s2264c3f72:1;
  unsigned char s2264c3f73:1;
  unsigned char s2264c3f74:1;
  unsigned char s2264c3f75:1;
  int s2264c3f76[7];
  void *s2264c3f77[6];
  int s2264c3f78:8;
  int s2264c3f79:8;
  int s2264c3f80:8;
  int s2264c3f81:8;
  int s2264c3f82:8;
  int s2264c3f83:8;
  ::S2264C25 s2264c3f84;
  void *s2264c3f85[4];
  int s2264c3f86:8;
  int s2264c3f87:8;
  int s2264c3f88:8;
  int s2264c3f89:8;
  int s2264c3f90:8;
  int s2264c3f91:16;
  int s2264c3f92:16;
  int s2264c3f93:16;
  int s2264c3f94:4;
  int s2264c3f95:4;
  int s2264c3f96:4;
  int s2264c3f97:4;
  int s2264c3f98:4;
  int s2264c3f99:4;
  int s2264c3f100:4;
  int s2264c3f101:4;
  int s2264c3f102:4;
  int s2264c3f103:4;
  int s2264c3f104:4;
  int s2264c3f105:4;
  int s2264c3f106:8;
  int s2264c3f107:8;
  int s2264c3f108:8;
  void *s2264c3f109[7];
  ::S2264C29_nt s2264c3f110;
  void *s2264c3f111[2];
  int s2264c3f112:16;
  int s2264c3f113:16;
  ::S2264C25 s2264c3f114;
  ::S2264C29_nt s2264c3f115;
  ::S2264C37 s2264c3f116;
  void *s2264c3f117[2];
  int s2264c3f118:24;
  int s2264c3f119:8;
  void *s2264c3f120;
  virtual  ~S2264C3_nt(); // _ZN10S2264C3_ntD1Ev
  virtual void  v27(); // _ZN10S2264C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2264C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2264C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2264C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2264C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2264C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2264C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2264C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2264C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2264C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2264C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2264C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2264C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2264C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2264C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2264C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2264C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2264C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2264C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2264C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2264C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2264C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2264C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2264C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2264C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2264C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2264C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2264C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2264C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2264C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2264C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2264C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2264C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2264C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2264C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2264C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2264C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2264C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2264C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2264C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2264C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2264C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2264C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2264C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2264C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2264C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2264C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2264C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2264C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2264C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2264C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2264C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2264C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2264C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2264C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2264C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2264C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2264C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2264C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2264C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2264C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2264C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2264C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2264C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2264C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2264C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2264C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2264C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2264C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2264C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2264C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2264C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2264C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2264C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2264C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2264C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2264C3_nt4v103Ev
  virtual void  v104(); // _ZN10S2264C3_nt4v104Ev
  S2264C3_nt(); // tgen
};
//SIG(-1 S2264C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2264C3_nt ::~S2264C3_nt(){ note_dtor("S2264C3_nt", this);}
void  S2264C3_nt ::v27(){vfunc_called(this, "_ZN10S2264C3_nt3v27Ev");}
void  S2264C3_nt ::v28(){vfunc_called(this, "_ZN10S2264C3_nt3v28Ev");}
void  S2264C3_nt ::v29(){vfunc_called(this, "_ZN10S2264C3_nt3v29Ev");}
void  S2264C3_nt ::v30(){vfunc_called(this, "_ZN10S2264C3_nt3v30Ev");}
void  S2264C3_nt ::v31(){vfunc_called(this, "_ZN10S2264C3_nt3v31Ev");}
void  S2264C3_nt ::v32(){vfunc_called(this, "_ZN10S2264C3_nt3v32Ev");}
void  S2264C3_nt ::v33(){vfunc_called(this, "_ZN10S2264C3_nt3v33Ev");}
void  S2264C3_nt ::v34(){vfunc_called(this, "_ZN10S2264C3_nt3v34Ev");}
void  S2264C3_nt ::v35(){vfunc_called(this, "_ZN10S2264C3_nt3v35Ev");}
void  S2264C3_nt ::v36(){vfunc_called(this, "_ZN10S2264C3_nt3v36Ev");}
void  S2264C3_nt ::v37(){vfunc_called(this, "_ZN10S2264C3_nt3v37Ev");}
void  S2264C3_nt ::v38(){vfunc_called(this, "_ZN10S2264C3_nt3v38Ev");}
void  S2264C3_nt ::v39(){vfunc_called(this, "_ZN10S2264C3_nt3v39Ev");}
void  S2264C3_nt ::v40(){vfunc_called(this, "_ZN10S2264C3_nt3v40Ev");}
void  S2264C3_nt ::v41(){vfunc_called(this, "_ZN10S2264C3_nt3v41Ev");}
void  S2264C3_nt ::v42(){vfunc_called(this, "_ZN10S2264C3_nt3v42Ev");}
void  S2264C3_nt ::v43(){vfunc_called(this, "_ZN10S2264C3_nt3v43Ev");}
void  S2264C3_nt ::v44(){vfunc_called(this, "_ZN10S2264C3_nt3v44Ev");}
void  S2264C3_nt ::v45(){vfunc_called(this, "_ZN10S2264C3_nt3v45Ev");}
void  S2264C3_nt ::v46(){vfunc_called(this, "_ZN10S2264C3_nt3v46Ev");}
void  S2264C3_nt ::v47(){vfunc_called(this, "_ZN10S2264C3_nt3v47Ev");}
void  S2264C3_nt ::v48(){vfunc_called(this, "_ZN10S2264C3_nt3v48Ev");}
void  S2264C3_nt ::v49(){vfunc_called(this, "_ZN10S2264C3_nt3v49Ev");}
void  S2264C3_nt ::v50(){vfunc_called(this, "_ZN10S2264C3_nt3v50Ev");}
void  S2264C3_nt ::v51(){vfunc_called(this, "_ZN10S2264C3_nt3v51Ev");}
void  S2264C3_nt ::v52(){vfunc_called(this, "_ZN10S2264C3_nt3v52Ev");}
void  S2264C3_nt ::v53(){vfunc_called(this, "_ZN10S2264C3_nt3v53Ev");}
void  S2264C3_nt ::v54(){vfunc_called(this, "_ZN10S2264C3_nt3v54Ev");}
void  S2264C3_nt ::v55(){vfunc_called(this, "_ZN10S2264C3_nt3v55Ev");}
void  S2264C3_nt ::v56(){vfunc_called(this, "_ZN10S2264C3_nt3v56Ev");}
void  S2264C3_nt ::v57(){vfunc_called(this, "_ZN10S2264C3_nt3v57Ev");}
void  S2264C3_nt ::v58(){vfunc_called(this, "_ZN10S2264C3_nt3v58Ev");}
void  S2264C3_nt ::v59(){vfunc_called(this, "_ZN10S2264C3_nt3v59Ev");}
void  S2264C3_nt ::v60(){vfunc_called(this, "_ZN10S2264C3_nt3v60Ev");}
void  S2264C3_nt ::v61(){vfunc_called(this, "_ZN10S2264C3_nt3v61Ev");}
void  S2264C3_nt ::v62(){vfunc_called(this, "_ZN10S2264C3_nt3v62Ev");}
void  S2264C3_nt ::v63(){vfunc_called(this, "_ZN10S2264C3_nt3v63Ev");}
void  S2264C3_nt ::v64(){vfunc_called(this, "_ZN10S2264C3_nt3v64Ev");}
void  S2264C3_nt ::v65(){vfunc_called(this, "_ZN10S2264C3_nt3v65Ev");}
void  S2264C3_nt ::v66(){vfunc_called(this, "_ZN10S2264C3_nt3v66Ev");}
void  S2264C3_nt ::v67(){vfunc_called(this, "_ZN10S2264C3_nt3v67Ev");}
void  S2264C3_nt ::v68(){vfunc_called(this, "_ZN10S2264C3_nt3v68Ev");}
void  S2264C3_nt ::v69(){vfunc_called(this, "_ZN10S2264C3_nt3v69Ev");}
void  S2264C3_nt ::v70(){vfunc_called(this, "_ZN10S2264C3_nt3v70Ev");}
void  S2264C3_nt ::v71(){vfunc_called(this, "_ZN10S2264C3_nt3v71Ev");}
void  S2264C3_nt ::v72(){vfunc_called(this, "_ZN10S2264C3_nt3v72Ev");}
void  S2264C3_nt ::v73(){vfunc_called(this, "_ZN10S2264C3_nt3v73Ev");}
void  S2264C3_nt ::v74(){vfunc_called(this, "_ZN10S2264C3_nt3v74Ev");}
void  S2264C3_nt ::v75(){vfunc_called(this, "_ZN10S2264C3_nt3v75Ev");}
void  S2264C3_nt ::v76(){vfunc_called(this, "_ZN10S2264C3_nt3v76Ev");}
void  S2264C3_nt ::v77(){vfunc_called(this, "_ZN10S2264C3_nt3v77Ev");}
void  S2264C3_nt ::v78(){vfunc_called(this, "_ZN10S2264C3_nt3v78Ev");}
void  S2264C3_nt ::v79(){vfunc_called(this, "_ZN10S2264C3_nt3v79Ev");}
void  S2264C3_nt ::v80(){vfunc_called(this, "_ZN10S2264C3_nt3v80Ev");}
void  S2264C3_nt ::v81(){vfunc_called(this, "_ZN10S2264C3_nt3v81Ev");}
void  S2264C3_nt ::v82(){vfunc_called(this, "_ZN10S2264C3_nt3v82Ev");}
void  S2264C3_nt ::v83(){vfunc_called(this, "_ZN10S2264C3_nt3v83Ev");}
void  S2264C3_nt ::v84(){vfunc_called(this, "_ZN10S2264C3_nt3v84Ev");}
void  S2264C3_nt ::v85(){vfunc_called(this, "_ZN10S2264C3_nt3v85Ev");}
void  S2264C3_nt ::v86(){vfunc_called(this, "_ZN10S2264C3_nt3v86Ev");}
void  S2264C3_nt ::v87(){vfunc_called(this, "_ZN10S2264C3_nt3v87Ev");}
void  S2264C3_nt ::v88(){vfunc_called(this, "_ZN10S2264C3_nt3v88Ev");}
void  S2264C3_nt ::v89(){vfunc_called(this, "_ZN10S2264C3_nt3v89Ev");}
void  S2264C3_nt ::v90(){vfunc_called(this, "_ZN10S2264C3_nt3v90Ev");}
void  S2264C3_nt ::v91(){vfunc_called(this, "_ZN10S2264C3_nt3v91Ev");}
void  S2264C3_nt ::v92(){vfunc_called(this, "_ZN10S2264C3_nt3v92Ev");}
void  S2264C3_nt ::v93(){vfunc_called(this, "_ZN10S2264C3_nt3v93Ev");}
void  S2264C3_nt ::v94(){vfunc_called(this, "_ZN10S2264C3_nt3v94Ev");}
void  S2264C3_nt ::v95(){vfunc_called(this, "_ZN10S2264C3_nt3v95Ev");}
void  S2264C3_nt ::v96(){vfunc_called(this, "_ZN10S2264C3_nt3v96Ev");}
void  S2264C3_nt ::v97(){vfunc_called(this, "_ZN10S2264C3_nt3v97Ev");}
void  S2264C3_nt ::v98(){vfunc_called(this, "_ZN10S2264C3_nt3v98Ev");}
void  S2264C3_nt ::v99(){vfunc_called(this, "_ZN10S2264C3_nt3v99Ev");}
void  S2264C3_nt ::v100(){vfunc_called(this, "_ZN10S2264C3_nt4v100Ev");}
void  S2264C3_nt ::v101(){vfunc_called(this, "_ZN10S2264C3_nt4v101Ev");}
void  S2264C3_nt ::v102(){vfunc_called(this, "_ZN10S2264C3_nt4v102Ev");}
void  S2264C3_nt ::v103(){vfunc_called(this, "_ZN10S2264C3_nt4v103Ev");}
void  S2264C3_nt ::v104(){vfunc_called(this, "_ZN10S2264C3_nt4v104Ev");}
S2264C3_nt ::S2264C3_nt(){ note_ctor("S2264C3_nt", this);} // tgen

//skip512 S2264C3_nt

#else // __cplusplus

extern void _ZN10S2264C3_ntC1Ev();
extern void _ZN10S2264C3_ntD1Ev();
Name_Map name_map_S2264C3_nt[] = {
  NSPAIR(_ZN10S2264C3_ntC1Ev),
  NSPAIR(_ZN10S2264C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2264C4_nt;
extern VTBL_ENTRY _ZTI10S2264C4_nt[];
extern  VTBL_ENTRY _ZTV10S2264C4_nt[];
static Base_Class bases_S2264C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2264C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2264C3_nt[];
extern void _ZN10S2264C3_ntD1Ev();
extern void _ZN10S2264C3_ntD0Ev();
extern void _ZN10S2264C4_nt2v4Ev();
extern void _ZN10S2264C4_nt2v5Ev();
extern void _ZN10S2264C4_nt2v6Ev();
extern void _ZN10S2264C4_nt2v7Ev();
extern void _ZN10S2264C4_nt2v8Ev();
extern void _ZN10S2264C4_nt2v9Ev();
extern void _ZN10S2264C4_nt3v10Ev();
extern void _ZN10S2264C4_nt3v11Ev();
extern void _ZN10S2264C4_nt3v12Ev();
extern void _ZN10S2264C4_nt3v13Ev();
extern void _ZN10S2264C4_nt3v14Ev();
extern void _ZN10S2264C4_nt3v15Ev();
extern void _ZN10S2264C4_nt3v16Ev();
extern void _ZN10S2264C4_nt3v17Ev();
extern void _ZN10S2264C4_nt3v18Ev();
extern void _ZN10S2264C4_nt3v19Ev();
extern void _ZN10S2264C4_nt3v20Ev();
extern void _ZN10S2264C4_nt3v21Ev();
extern void _ZN10S2264C4_nt3v22Ev();
extern void _ZN10S2264C4_nt3v23Ev();
extern void _ZN10S2264C4_nt3v24Ev();
extern void _ZN10S2264C4_nt3v25Ev();
extern void _ZN10S2264C4_nt3v26Ev();
extern void _ZN10S2264C3_nt3v27Ev();
extern void _ZN10S2264C3_nt3v28Ev();
extern void _ZN10S2264C3_nt3v29Ev();
extern void _ZN10S2264C3_nt3v30Ev();
extern void _ZN10S2264C3_nt3v31Ev();
extern void _ZN10S2264C3_nt3v32Ev();
extern void _ZN10S2264C3_nt3v33Ev();
extern void _ZN10S2264C3_nt3v34Ev();
extern void _ZN10S2264C3_nt3v35Ev();
extern void _ZN10S2264C3_nt3v36Ev();
extern void _ZN10S2264C3_nt3v37Ev();
extern void _ZN10S2264C3_nt3v38Ev();
extern void _ZN10S2264C3_nt3v39Ev();
extern void _ZN10S2264C3_nt3v40Ev();
extern void _ZN10S2264C3_nt3v41Ev();
extern void _ZN10S2264C3_nt3v42Ev();
extern void _ZN10S2264C3_nt3v43Ev();
extern void _ZN10S2264C3_nt3v44Ev();
extern void _ZN10S2264C3_nt3v45Ev();
extern void _ZN10S2264C3_nt3v46Ev();
extern void _ZN10S2264C3_nt3v47Ev();
extern void _ZN10S2264C3_nt3v48Ev();
extern void _ZN10S2264C3_nt3v49Ev();
extern void _ZN10S2264C3_nt3v50Ev();
extern void _ZN10S2264C3_nt3v51Ev();
extern void _ZN10S2264C3_nt3v52Ev();
extern void _ZN10S2264C3_nt3v53Ev();
extern void _ZN10S2264C3_nt3v54Ev();
extern void _ZN10S2264C3_nt3v55Ev();
extern void _ZN10S2264C3_nt3v56Ev();
extern void _ZN10S2264C3_nt3v57Ev();
extern void _ZN10S2264C3_nt3v58Ev();
extern void _ZN10S2264C3_nt3v59Ev();
extern void _ZN10S2264C3_nt3v60Ev();
extern void _ZN10S2264C3_nt3v61Ev();
extern void _ZN10S2264C3_nt3v62Ev();
extern void _ZN10S2264C3_nt3v63Ev();
extern void _ZN10S2264C3_nt3v64Ev();
extern void _ZN10S2264C3_nt3v65Ev();
extern void _ZN10S2264C3_nt3v66Ev();
extern void _ZN10S2264C3_nt3v67Ev();
extern void _ZN10S2264C3_nt3v68Ev();
extern void _ZN10S2264C3_nt3v69Ev();
extern void _ZN10S2264C3_nt3v70Ev();
extern void _ZN10S2264C3_nt3v71Ev();
extern void _ZN10S2264C3_nt3v72Ev();
extern void _ZN10S2264C3_nt3v73Ev();
extern void _ZN10S2264C3_nt3v74Ev();
extern void _ZN10S2264C3_nt3v75Ev();
extern void _ZN10S2264C3_nt3v76Ev();
extern void _ZN10S2264C3_nt3v77Ev();
extern void _ZN10S2264C3_nt3v78Ev();
extern void _ZN10S2264C3_nt3v79Ev();
extern void _ZN10S2264C3_nt3v80Ev();
extern void _ZN10S2264C3_nt3v81Ev();
extern void _ZN10S2264C3_nt3v82Ev();
extern void _ZN10S2264C3_nt3v83Ev();
extern void _ZN10S2264C3_nt3v84Ev();
extern void _ZN10S2264C3_nt3v85Ev();
extern void _ZN10S2264C3_nt3v86Ev();
extern void _ZN10S2264C3_nt3v87Ev();
extern void _ZN10S2264C3_nt3v88Ev();
extern void _ZN10S2264C3_nt3v89Ev();
extern void _ZN10S2264C3_nt3v90Ev();
extern void _ZN10S2264C3_nt3v91Ev();
extern void _ZN10S2264C3_nt3v92Ev();
extern void _ZN10S2264C3_nt3v93Ev();
extern void _ZN10S2264C3_nt3v94Ev();
extern void _ZN10S2264C3_nt3v95Ev();
extern void _ZN10S2264C3_nt3v96Ev();
extern void _ZN10S2264C3_nt3v97Ev();
extern void _ZN10S2264C3_nt3v98Ev();
extern void _ZN10S2264C3_nt3v99Ev();
extern void _ZN10S2264C3_nt4v100Ev();
extern void _ZN10S2264C3_nt4v101Ev();
extern void _ZN10S2264C3_nt4v102Ev();
extern void _ZN10S2264C3_nt4v103Ev();
extern void _ZN10S2264C3_nt4v104Ev();
static  VTBL_ENTRY vtc_S2264C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2264C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2264C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v104Ev,
};
extern VTBL_ENTRY _ZTI10S2264C3_nt[];
VTBL_ENTRY *P__ZTI10S2264C3_nt = _ZTI10S2264C3_nt; 
extern  VTBL_ENTRY _ZTV10S2264C3_nt[];
Class_Descriptor cd_S2264C3_nt = {  "S2264C3_nt", // class name
  bases_S2264C3_nt, 1,
  &(vtc_S2264C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2264C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2264C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C2_nt  : S2264C3_nt {
  void *s2264c2f0;
  virtual  ~S2264C2_nt(); // _ZN10S2264C2_ntD1Ev
  virtual void  v105(); // _ZN10S2264C2_nt4v105Ev
  virtual void  v106(); // _ZN10S2264C2_nt4v106Ev
  virtual void  v107(); // _ZN10S2264C2_nt4v107Ev
  virtual void  v108(); // _ZN10S2264C2_nt4v108Ev
  virtual void  v109(); // _ZN10S2264C2_nt4v109Ev
  virtual void  v110(); // _ZN10S2264C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2264C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2264C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2264C2_nt4v113Ev
  virtual void  v114(); // _ZN10S2264C2_nt4v114Ev
  S2264C2_nt(); // tgen
};
//SIG(-1 S2264C2_nt) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S2264C2_nt ::~S2264C2_nt(){ note_dtor("S2264C2_nt", this);}
void  S2264C2_nt ::v105(){vfunc_called(this, "_ZN10S2264C2_nt4v105Ev");}
void  S2264C2_nt ::v106(){vfunc_called(this, "_ZN10S2264C2_nt4v106Ev");}
void  S2264C2_nt ::v107(){vfunc_called(this, "_ZN10S2264C2_nt4v107Ev");}
void  S2264C2_nt ::v108(){vfunc_called(this, "_ZN10S2264C2_nt4v108Ev");}
void  S2264C2_nt ::v109(){vfunc_called(this, "_ZN10S2264C2_nt4v109Ev");}
void  S2264C2_nt ::v110(){vfunc_called(this, "_ZN10S2264C2_nt4v110Ev");}
void  S2264C2_nt ::v111(){vfunc_called(this, "_ZN10S2264C2_nt4v111Ev");}
void  S2264C2_nt ::v112(){vfunc_called(this, "_ZN10S2264C2_nt4v112Ev");}
void  S2264C2_nt ::v113(){vfunc_called(this, "_ZN10S2264C2_nt4v113Ev");}
void  S2264C2_nt ::v114(){vfunc_called(this, "_ZN10S2264C2_nt4v114Ev");}
S2264C2_nt ::S2264C2_nt(){ note_ctor("S2264C2_nt", this);} // tgen

//skip512 S2264C2_nt

#else // __cplusplus

extern void _ZN10S2264C2_ntC1Ev();
extern void _ZN10S2264C2_ntD1Ev();
Name_Map name_map_S2264C2_nt[] = {
  NSPAIR(_ZN10S2264C2_ntC1Ev),
  NSPAIR(_ZN10S2264C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2264C4_nt;
extern VTBL_ENTRY _ZTI10S2264C4_nt[];
extern  VTBL_ENTRY _ZTV10S2264C4_nt[];
extern Class_Descriptor cd_S2264C3_nt;
extern VTBL_ENTRY _ZTI10S2264C3_nt[];
extern  VTBL_ENTRY _ZTV10S2264C3_nt[];
static Base_Class bases_S2264C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2264C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2264C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2264C2_nt[];
extern void _ZN10S2264C2_ntD1Ev();
extern void _ZN10S2264C2_ntD0Ev();
extern void _ZN10S2264C4_nt2v4Ev();
extern void _ZN10S2264C4_nt2v5Ev();
extern void _ZN10S2264C4_nt2v6Ev();
extern void _ZN10S2264C4_nt2v7Ev();
extern void _ZN10S2264C4_nt2v8Ev();
extern void _ZN10S2264C4_nt2v9Ev();
extern void _ZN10S2264C4_nt3v10Ev();
extern void _ZN10S2264C4_nt3v11Ev();
extern void _ZN10S2264C4_nt3v12Ev();
extern void _ZN10S2264C4_nt3v13Ev();
extern void _ZN10S2264C4_nt3v14Ev();
extern void _ZN10S2264C4_nt3v15Ev();
extern void _ZN10S2264C4_nt3v16Ev();
extern void _ZN10S2264C4_nt3v17Ev();
extern void _ZN10S2264C4_nt3v18Ev();
extern void _ZN10S2264C4_nt3v19Ev();
extern void _ZN10S2264C4_nt3v20Ev();
extern void _ZN10S2264C4_nt3v21Ev();
extern void _ZN10S2264C4_nt3v22Ev();
extern void _ZN10S2264C4_nt3v23Ev();
extern void _ZN10S2264C4_nt3v24Ev();
extern void _ZN10S2264C4_nt3v25Ev();
extern void _ZN10S2264C4_nt3v26Ev();
extern void _ZN10S2264C3_nt3v27Ev();
extern void _ZN10S2264C3_nt3v28Ev();
extern void _ZN10S2264C3_nt3v29Ev();
extern void _ZN10S2264C3_nt3v30Ev();
extern void _ZN10S2264C3_nt3v31Ev();
extern void _ZN10S2264C3_nt3v32Ev();
extern void _ZN10S2264C3_nt3v33Ev();
extern void _ZN10S2264C3_nt3v34Ev();
extern void _ZN10S2264C3_nt3v35Ev();
extern void _ZN10S2264C3_nt3v36Ev();
extern void _ZN10S2264C3_nt3v37Ev();
extern void _ZN10S2264C3_nt3v38Ev();
extern void _ZN10S2264C3_nt3v39Ev();
extern void _ZN10S2264C3_nt3v40Ev();
extern void _ZN10S2264C3_nt3v41Ev();
extern void _ZN10S2264C3_nt3v42Ev();
extern void _ZN10S2264C3_nt3v43Ev();
extern void _ZN10S2264C3_nt3v44Ev();
extern void _ZN10S2264C3_nt3v45Ev();
extern void _ZN10S2264C3_nt3v46Ev();
extern void _ZN10S2264C3_nt3v47Ev();
extern void _ZN10S2264C3_nt3v48Ev();
extern void _ZN10S2264C3_nt3v49Ev();
extern void _ZN10S2264C3_nt3v50Ev();
extern void _ZN10S2264C3_nt3v51Ev();
extern void _ZN10S2264C3_nt3v52Ev();
extern void _ZN10S2264C3_nt3v53Ev();
extern void _ZN10S2264C3_nt3v54Ev();
extern void _ZN10S2264C3_nt3v55Ev();
extern void _ZN10S2264C3_nt3v56Ev();
extern void _ZN10S2264C3_nt3v57Ev();
extern void _ZN10S2264C3_nt3v58Ev();
extern void _ZN10S2264C3_nt3v59Ev();
extern void _ZN10S2264C3_nt3v60Ev();
extern void _ZN10S2264C3_nt3v61Ev();
extern void _ZN10S2264C3_nt3v62Ev();
extern void _ZN10S2264C3_nt3v63Ev();
extern void _ZN10S2264C3_nt3v64Ev();
extern void _ZN10S2264C3_nt3v65Ev();
extern void _ZN10S2264C3_nt3v66Ev();
extern void _ZN10S2264C3_nt3v67Ev();
extern void _ZN10S2264C3_nt3v68Ev();
extern void _ZN10S2264C3_nt3v69Ev();
extern void _ZN10S2264C3_nt3v70Ev();
extern void _ZN10S2264C3_nt3v71Ev();
extern void _ZN10S2264C3_nt3v72Ev();
extern void _ZN10S2264C3_nt3v73Ev();
extern void _ZN10S2264C3_nt3v74Ev();
extern void _ZN10S2264C3_nt3v75Ev();
extern void _ZN10S2264C3_nt3v76Ev();
extern void _ZN10S2264C3_nt3v77Ev();
extern void _ZN10S2264C3_nt3v78Ev();
extern void _ZN10S2264C3_nt3v79Ev();
extern void _ZN10S2264C3_nt3v80Ev();
extern void _ZN10S2264C3_nt3v81Ev();
extern void _ZN10S2264C3_nt3v82Ev();
extern void _ZN10S2264C3_nt3v83Ev();
extern void _ZN10S2264C3_nt3v84Ev();
extern void _ZN10S2264C3_nt3v85Ev();
extern void _ZN10S2264C3_nt3v86Ev();
extern void _ZN10S2264C3_nt3v87Ev();
extern void _ZN10S2264C3_nt3v88Ev();
extern void _ZN10S2264C3_nt3v89Ev();
extern void _ZN10S2264C3_nt3v90Ev();
extern void _ZN10S2264C3_nt3v91Ev();
extern void _ZN10S2264C3_nt3v92Ev();
extern void _ZN10S2264C3_nt3v93Ev();
extern void _ZN10S2264C3_nt3v94Ev();
extern void _ZN10S2264C3_nt3v95Ev();
extern void _ZN10S2264C3_nt3v96Ev();
extern void _ZN10S2264C3_nt3v97Ev();
extern void _ZN10S2264C3_nt3v98Ev();
extern void _ZN10S2264C3_nt3v99Ev();
extern void _ZN10S2264C3_nt4v100Ev();
extern void _ZN10S2264C3_nt4v101Ev();
extern void _ZN10S2264C3_nt4v102Ev();
extern void _ZN10S2264C3_nt4v103Ev();
extern void _ZN10S2264C3_nt4v104Ev();
extern void _ZN10S2264C2_nt4v105Ev();
extern void _ZN10S2264C2_nt4v106Ev();
extern void _ZN10S2264C2_nt4v107Ev();
extern void _ZN10S2264C2_nt4v108Ev();
extern void _ZN10S2264C2_nt4v109Ev();
extern void _ZN10S2264C2_nt4v110Ev();
extern void _ZN10S2264C2_nt4v111Ev();
extern void _ZN10S2264C2_nt4v112Ev();
extern void _ZN10S2264C2_nt4v113Ev();
extern void _ZN10S2264C2_nt4v114Ev();
static  VTBL_ENTRY vtc_S2264C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2264C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2264C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI10S2264C2_nt[];
VTBL_ENTRY *P__ZTI10S2264C2_nt = _ZTI10S2264C2_nt; 
extern  VTBL_ENTRY _ZTV10S2264C2_nt[];
Class_Descriptor cd_S2264C2_nt = {  "S2264C2_nt", // class name
  bases_S2264C2_nt, 2,
  &(vtc_S2264C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI10S2264C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2264C2_nt),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2264C1  : S2264C2_nt {
  virtual  ~S2264C1(); // _ZN7S2264C1D1Ev
  virtual void  v1(); // _ZN7S2264C12v1Ev
  virtual void  v2(); // _ZN7S2264C12v2Ev
  virtual void  v3(); // _ZN7S2264C12v3Ev
  S2264C1(); // tgen
};
//SIG(1 S2264C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fp} vd v1 v2 v3}


 S2264C1 ::~S2264C1(){ note_dtor("S2264C1", this);}
void  S2264C1 ::v1(){vfunc_called(this, "_ZN7S2264C12v1Ev");}
void  S2264C1 ::v2(){vfunc_called(this, "_ZN7S2264C12v2Ev");}
void  S2264C1 ::v3(){vfunc_called(this, "_ZN7S2264C12v3Ev");}
S2264C1 ::S2264C1(){ note_ctor("S2264C1", this);} // tgen

static void Test_S2264C1()
{
  extern Class_Descriptor cd_S2264C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(106,160)];
    init_test(&cd_S2264C1, buf);
    S2264C1 *dp, &lv = *(dp=new (buf) S2264C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(840,636), "sizeof(S2264C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2264C1)");
    check_base_class_offset(lv, (S2264C4_nt*)(S2264C3_nt*)(S2264C2_nt*), 0, "S2264C1");
    check_base_class_offset(lv, (S2264C3_nt*)(S2264C2_nt*), 0, "S2264C1");
    check_base_class_offset(lv, (S2264C2_nt*), 0, "S2264C1");
    test_class_info(&lv, &cd_S2264C1);
    dp->~S2264C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2264C1(Test_S2264C1, "S2264C1", ABISELECT(840,636));

#else // __cplusplus

extern void _ZN7S2264C1C1Ev();
extern void _ZN7S2264C1D1Ev();
Name_Map name_map_S2264C1[] = {
  NSPAIR(_ZN7S2264C1C1Ev),
  NSPAIR(_ZN7S2264C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2264C4_nt;
extern VTBL_ENTRY _ZTI10S2264C4_nt[];
extern  VTBL_ENTRY _ZTV10S2264C4_nt[];
extern Class_Descriptor cd_S2264C3_nt;
extern VTBL_ENTRY _ZTI10S2264C3_nt[];
extern  VTBL_ENTRY _ZTV10S2264C3_nt[];
extern Class_Descriptor cd_S2264C2_nt;
extern VTBL_ENTRY _ZTI10S2264C2_nt[];
extern  VTBL_ENTRY _ZTV10S2264C2_nt[];
static Base_Class bases_S2264C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2264C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2264C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2264C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2264C1[];
extern void _ZN7S2264C1D1Ev();
extern void _ZN7S2264C1D0Ev();
extern void _ZN10S2264C4_nt2v4Ev();
extern void _ZN10S2264C4_nt2v5Ev();
extern void _ZN10S2264C4_nt2v6Ev();
extern void _ZN10S2264C4_nt2v7Ev();
extern void _ZN10S2264C4_nt2v8Ev();
extern void _ZN10S2264C4_nt2v9Ev();
extern void _ZN10S2264C4_nt3v10Ev();
extern void _ZN10S2264C4_nt3v11Ev();
extern void _ZN10S2264C4_nt3v12Ev();
extern void _ZN10S2264C4_nt3v13Ev();
extern void _ZN10S2264C4_nt3v14Ev();
extern void _ZN10S2264C4_nt3v15Ev();
extern void _ZN10S2264C4_nt3v16Ev();
extern void _ZN10S2264C4_nt3v17Ev();
extern void _ZN10S2264C4_nt3v18Ev();
extern void _ZN10S2264C4_nt3v19Ev();
extern void _ZN10S2264C4_nt3v20Ev();
extern void _ZN10S2264C4_nt3v21Ev();
extern void _ZN10S2264C4_nt3v22Ev();
extern void _ZN10S2264C4_nt3v23Ev();
extern void _ZN10S2264C4_nt3v24Ev();
extern void _ZN10S2264C4_nt3v25Ev();
extern void _ZN10S2264C4_nt3v26Ev();
extern void _ZN10S2264C3_nt3v27Ev();
extern void _ZN10S2264C3_nt3v28Ev();
extern void _ZN10S2264C3_nt3v29Ev();
extern void _ZN10S2264C3_nt3v30Ev();
extern void _ZN10S2264C3_nt3v31Ev();
extern void _ZN10S2264C3_nt3v32Ev();
extern void _ZN10S2264C3_nt3v33Ev();
extern void _ZN10S2264C3_nt3v34Ev();
extern void _ZN10S2264C3_nt3v35Ev();
extern void _ZN10S2264C3_nt3v36Ev();
extern void _ZN10S2264C3_nt3v37Ev();
extern void _ZN10S2264C3_nt3v38Ev();
extern void _ZN10S2264C3_nt3v39Ev();
extern void _ZN10S2264C3_nt3v40Ev();
extern void _ZN10S2264C3_nt3v41Ev();
extern void _ZN10S2264C3_nt3v42Ev();
extern void _ZN10S2264C3_nt3v43Ev();
extern void _ZN10S2264C3_nt3v44Ev();
extern void _ZN10S2264C3_nt3v45Ev();
extern void _ZN10S2264C3_nt3v46Ev();
extern void _ZN10S2264C3_nt3v47Ev();
extern void _ZN10S2264C3_nt3v48Ev();
extern void _ZN10S2264C3_nt3v49Ev();
extern void _ZN10S2264C3_nt3v50Ev();
extern void _ZN10S2264C3_nt3v51Ev();
extern void _ZN10S2264C3_nt3v52Ev();
extern void _ZN10S2264C3_nt3v53Ev();
extern void _ZN10S2264C3_nt3v54Ev();
extern void _ZN10S2264C3_nt3v55Ev();
extern void _ZN10S2264C3_nt3v56Ev();
extern void _ZN10S2264C3_nt3v57Ev();
extern void _ZN10S2264C3_nt3v58Ev();
extern void _ZN10S2264C3_nt3v59Ev();
extern void _ZN10S2264C3_nt3v60Ev();
extern void _ZN10S2264C3_nt3v61Ev();
extern void _ZN10S2264C3_nt3v62Ev();
extern void _ZN10S2264C3_nt3v63Ev();
extern void _ZN10S2264C3_nt3v64Ev();
extern void _ZN10S2264C3_nt3v65Ev();
extern void _ZN10S2264C3_nt3v66Ev();
extern void _ZN10S2264C3_nt3v67Ev();
extern void _ZN10S2264C3_nt3v68Ev();
extern void _ZN10S2264C3_nt3v69Ev();
extern void _ZN10S2264C3_nt3v70Ev();
extern void _ZN10S2264C3_nt3v71Ev();
extern void _ZN10S2264C3_nt3v72Ev();
extern void _ZN10S2264C3_nt3v73Ev();
extern void _ZN10S2264C3_nt3v74Ev();
extern void _ZN10S2264C3_nt3v75Ev();
extern void _ZN10S2264C3_nt3v76Ev();
extern void _ZN10S2264C3_nt3v77Ev();
extern void _ZN10S2264C3_nt3v78Ev();
extern void _ZN10S2264C3_nt3v79Ev();
extern void _ZN10S2264C3_nt3v80Ev();
extern void _ZN10S2264C3_nt3v81Ev();
extern void _ZN10S2264C3_nt3v82Ev();
extern void _ZN10S2264C3_nt3v83Ev();
extern void _ZN10S2264C3_nt3v84Ev();
extern void _ZN10S2264C3_nt3v85Ev();
extern void _ZN10S2264C3_nt3v86Ev();
extern void _ZN10S2264C3_nt3v87Ev();
extern void _ZN10S2264C3_nt3v88Ev();
extern void _ZN10S2264C3_nt3v89Ev();
extern void _ZN10S2264C3_nt3v90Ev();
extern void _ZN10S2264C3_nt3v91Ev();
extern void _ZN10S2264C3_nt3v92Ev();
extern void _ZN10S2264C3_nt3v93Ev();
extern void _ZN10S2264C3_nt3v94Ev();
extern void _ZN10S2264C3_nt3v95Ev();
extern void _ZN10S2264C3_nt3v96Ev();
extern void _ZN10S2264C3_nt3v97Ev();
extern void _ZN10S2264C3_nt3v98Ev();
extern void _ZN10S2264C3_nt3v99Ev();
extern void _ZN10S2264C3_nt4v100Ev();
extern void _ZN10S2264C3_nt4v101Ev();
extern void _ZN10S2264C3_nt4v102Ev();
extern void _ZN10S2264C3_nt4v103Ev();
extern void _ZN10S2264C3_nt4v104Ev();
extern void _ZN10S2264C2_nt4v105Ev();
extern void _ZN10S2264C2_nt4v106Ev();
extern void _ZN10S2264C2_nt4v107Ev();
extern void _ZN10S2264C2_nt4v108Ev();
extern void _ZN10S2264C2_nt4v109Ev();
extern void _ZN10S2264C2_nt4v110Ev();
extern void _ZN10S2264C2_nt4v111Ev();
extern void _ZN10S2264C2_nt4v112Ev();
extern void _ZN10S2264C2_nt4v113Ev();
extern void _ZN10S2264C2_nt4v114Ev();
extern void _ZN7S2264C12v1Ev();
extern void _ZN7S2264C12v2Ev();
extern void _ZN7S2264C12v3Ev();
static  VTBL_ENTRY vtc_S2264C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2264C1[0]),
  (VTBL_ENTRY)&_ZN7S2264C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2264C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2264C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2264C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2264C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN7S2264C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2264C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2264C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S2264C1[];
extern  VTBL_ENTRY _ZTV7S2264C1[];
Class_Descriptor cd_S2264C1 = {  "S2264C1", // class name
  bases_S2264C1, 3,
  &(vtc_S2264C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(840,636), // object size
  NSPAIRA(_ZTI7S2264C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2264C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C3  {
  int  :0;
  int s3052c3f1[7];
  void *s3052c3f2;
  virtual void  v2(); // _ZN7S3052C32v2Ev
  ~S3052C3(); // tgen
  S3052C3(); // tgen
};
//SIG(-1 S3052C3) C1{ v1 Fi:0 Fi[7] Fp}


void  S3052C3 ::v2(){vfunc_called(this, "_ZN7S3052C32v2Ev");}
S3052C3 ::~S3052C3(){ note_dtor("S3052C3", this);} // tgen
S3052C3 ::S3052C3(){ note_ctor("S3052C3", this);} // tgen

static void Test_S3052C3()
{
  extern Class_Descriptor cd_S3052C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_S3052C3, buf);
    S3052C3 *dp, &lv = *(dp=new (buf) S3052C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(S3052C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C3)");
    check_field_offset(lv, s3052c3f1, ABISELECT(8,4), "S3052C3.s3052c3f1");
    check_field_offset(lv, s3052c3f2, ABISELECT(40,32), "S3052C3.s3052c3f2");
    test_class_info(&lv, &cd_S3052C3);
    dp->~S3052C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C3(Test_S3052C3, "S3052C3", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN7S3052C3C1Ev();
extern void _ZN7S3052C3D1Ev();
Name_Map name_map_S3052C3[] = {
  NSPAIR(_ZN7S3052C3C1Ev),
  NSPAIR(_ZN7S3052C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3052C3[];
extern void _ZN7S3052C32v2Ev();
static  VTBL_ENTRY vtc_S3052C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C3[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
};
extern VTBL_ENTRY _ZTI7S3052C3[];
extern  VTBL_ENTRY _ZTV7S3052C3[];
Class_Descriptor cd_S3052C3 = {  "S3052C3", // class name
  0,0,//no base classes
  &(vtc_S3052C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI7S3052C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3052C3),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C6  {
  short s3052c6f0[6];
  __tsi64 s3052c6f1[8];
  int s3052c6f2;
  virtual  ~S3052C6(); // _ZN7S3052C6D1Ev
  virtual void  v3(); // _ZN7S3052C62v3Ev
  S3052C6(); // tgen
};
//SIG(-1 S3052C6) C1{ vd v1 Fs[6] FL[8] Fi}


 S3052C6 ::~S3052C6(){ note_dtor("S3052C6", this);}
void  S3052C6 ::v3(){vfunc_called(this, "_ZN7S3052C62v3Ev");}
S3052C6 ::S3052C6(){ note_ctor("S3052C6", this);} // tgen

static void Test_S3052C6()
{
  extern Class_Descriptor cd_S3052C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,22)];
    init_test(&cd_S3052C6, buf);
    S3052C6 *dp, &lv = *(dp=new (buf) S3052C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,84), "sizeof(S3052C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C6)");
    check_field_offset(lv, s3052c6f0, ABISELECT(8,4), "S3052C6.s3052c6f0");
    check_field_offset(lv, s3052c6f1, ABISELECT(24,16), "S3052C6.s3052c6f1");
    check_field_offset(lv, s3052c6f2, ABISELECT(88,80), "S3052C6.s3052c6f2");
    test_class_info(&lv, &cd_S3052C6);
    dp->~S3052C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C6(Test_S3052C6, "S3052C6", ABISELECT(96,84));

#else // __cplusplus

extern void _ZN7S3052C6C1Ev();
extern void _ZN7S3052C6D1Ev();
Name_Map name_map_S3052C6[] = {
  NSPAIR(_ZN7S3052C6C1Ev),
  NSPAIR(_ZN7S3052C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3052C6[];
extern void _ZN7S3052C6D1Ev();
extern void _ZN7S3052C6D0Ev();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C6[0]),
  (VTBL_ENTRY)&_ZN7S3052C6D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C6D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
Class_Descriptor cd_S3052C6 = {  "S3052C6", // class name
  0,0,//no base classes
  &(vtc_S3052C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,84), // object size
  NSPAIRA(_ZTI7S3052C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3052C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C8  : virtual S3052C6 {
  __tsi64 s3052c8f0;
  void *s3052c8f1;
  __tsi64 s3052c8f2:54;
  ~S3052C8(); // tgen
  S3052C8(); // tgen
};
//SIG(-1 S3052C8) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} FL Fp FL:54}


S3052C8 ::~S3052C8(){ note_dtor("S3052C8", this);} // tgen
S3052C8 ::S3052C8(){ note_ctor("S3052C8", this);} // tgen

static void Test_S3052C8()
{
  extern Class_Descriptor cd_S3052C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,28)];
    init_test(&cd_S3052C8, buf);
    S3052C8 *dp, &lv = *(dp=new (buf) S3052C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,108), "sizeof(S3052C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C8)");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(32,24), "S3052C8");
    check_field_offset(lv, s3052c8f0, ABISELECT(8,4), "S3052C8.s3052c8f0");
    check_field_offset(lv, s3052c8f1, ABISELECT(16,12), "S3052C8.s3052c8f1");
    set_bf_and_test(lv, s3052c8f2, ABISELECT(24,16), 0, 54, 1, "S3052C8");
    set_bf_and_test(lv, s3052c8f2, ABISELECT(24,16), 0, 54, hide_sll(1LL<<53), "S3052C8");
    test_class_info(&lv, &cd_S3052C8);
    dp->~S3052C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C8(Test_S3052C8, "S3052C8", ABISELECT(128,108));

#else // __cplusplus

extern void _ZN7S3052C8C1Ev();
extern void _ZN7S3052C8D1Ev();
Name_Map name_map_S3052C8[] = {
  NSPAIR(_ZN7S3052C8C1Ev),
  NSPAIR(_ZN7S3052C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
static Base_Class bases_S3052C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C8[];
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn32_N7S3052C8D1Ev,_ZThn24_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn32_N7S3052C8D0Ev,_ZThn24_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C8[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTV7S3052C8[];
static  VTT_ENTRY vtt_S3052C8[] = {
  {&(_ZTV7S3052C8[3]),  3,12},
  {&(_ZTV7S3052C8[9]),  9,12},
};
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7S3052C8D0Ev,_ZThn24_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N7S3052C8D1Ev,_ZThn24_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C8 = {  "S3052C8", // class name
  bases_S3052C8, 1,
  &(vtc_S3052C8[0]), // expected_vtbl_contents
  &(vtt_S3052C8[0]), // expected_vtt_contents
  ABISELECT(128,108), // object size
  NSPAIRA(_ZTI7S3052C8),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S3052C8),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C8),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C7  : virtual S3052C6 , S3052C8 {
  char  :0;
  void *s3052c7f1[8];
  char s3052c7f2;
  virtual void  v4(); // _ZN7S3052C72v4Ev
  virtual void  v5(); // _ZN7S3052C72v5Ev
  ~S3052C7(); // tgen
  S3052C7(); // tgen
};
//SIG(-1 S3052C7) C1{ VBC2{ vd v3 Fs[6] FL[8] Fi} BC3{ VBC2 FL Fp FL:54} v1 v2 Fc:0 Fp[8] Fc}


void  S3052C7 ::v4(){vfunc_called(this, "_ZN7S3052C72v4Ev");}
void  S3052C7 ::v5(){vfunc_called(this, "_ZN7S3052C72v5Ev");}
S3052C7 ::~S3052C7(){ note_dtor("S3052C7", this);} // tgen
S3052C7 ::S3052C7(){ note_ctor("S3052C7", this);} // tgen

static void Test_S3052C7()
{
  extern Class_Descriptor cd_S3052C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,37)];
    init_test(&cd_S3052C7, buf);
    S3052C7 *dp, &lv = *(dp=new (buf) S3052C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,144), "sizeof(S3052C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C7)");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(104,60), "S3052C7");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(104,60), "S3052C7");
    check_base_class_offset(lv, (S3052C8*), 0, "S3052C7");
    check_field_offset(lv, s3052c7f1, ABISELECT(32,24), "S3052C7.s3052c7f1");
    check_field_offset(lv, s3052c7f2, ABISELECT(96,56), "S3052C7.s3052c7f2");
    test_class_info(&lv, &cd_S3052C7);
    dp->~S3052C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C7(Test_S3052C7, "S3052C7", ABISELECT(200,144));

#else // __cplusplus

extern void _ZN7S3052C7C1Ev();
extern void _ZN7S3052C7D1Ev();
Name_Map name_map_S3052C7[] = {
  NSPAIR(_ZN7S3052C7C1Ev),
  NSPAIR(_ZN7S3052C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
static Base_Class bases_S3052C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(104,60), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C7[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C7[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTV7S3052C7[];
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__7S3052C7[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__7S3052C7[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C7[] = {
  {&(_ZTV7S3052C7[3]),  3,14},
  {&(_tg__ZTV7S3052C8__7S3052C7[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__7S3052C7[4]),  4,7},
  {&(_ZTV7S3052C7[11]),  11,14},
};
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C7 = {  "S3052C7", // class name
  bases_S3052C7, 2,
  &(vtc_S3052C7[0]), // expected_vtbl_contents
  &(vtt_S3052C7[0]), // expected_vtt_contents
  ABISELECT(200,144), // object size
  NSPAIRA(_ZTI7S3052C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3052C7),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C7),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C5  : virtual S3052C6 , S3052C7 {
  void *s3052c5f0[3];
  char s3052c5f1:8;
  int s3052c5f2[2];
  char s3052c5f3;
  ::S3052C6 s3052c5f4;
  void *s3052c5f5[3];
  __tsi64 s3052c5f6[5];
  int s3052c5f7;
  ~S3052C5(); // tgen
  S3052C5(); // tgen
};
//SIG(-1 S3052C5) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi}


S3052C5 ::~S3052C5(){ note_dtor("S3052C5", this);} // tgen
S3052C5 ::S3052C5(){ note_ctor("S3052C5", this);} // tgen

static void Test_S3052C5()
{
  extern Class_Descriptor cd_S3052C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(52,79)];
    init_test(&cd_S3052C5, buf);
    S3052C5 *dp, &lv = *(dp=new (buf) S3052C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(408,312), "sizeof(S3052C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C5)");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(312,228), "S3052C5");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(312,228), "S3052C5");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(312,228), "S3052C5");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*), 0, "S3052C5");
    check_base_class_offset(lv, (S3052C7*), 0, "S3052C5");
    check_field_offset(lv, s3052c5f0, ABISELECT(104,60), "S3052C5.s3052c5f0");
    set_bf_and_test(lv, s3052c5f1, ABISELECT(128,72), 0, 8, 1, "S3052C5");
    set_bf_and_test(lv, s3052c5f1, ABISELECT(128,72), 0, 8, hide_sll(1LL<<7), "S3052C5");
    check_field_offset(lv, s3052c5f2, ABISELECT(132,76), "S3052C5.s3052c5f2");
    check_field_offset(lv, s3052c5f3, ABISELECT(140,84), "S3052C5.s3052c5f3");
    check_field_offset(lv, s3052c5f4, ABISELECT(144,88), "S3052C5.s3052c5f4");
    check_field_offset(lv, s3052c5f5, ABISELECT(240,172), "S3052C5.s3052c5f5");
    check_field_offset(lv, s3052c5f6, ABISELECT(264,184), "S3052C5.s3052c5f6");
    check_field_offset(lv, s3052c5f7, ABISELECT(304,224), "S3052C5.s3052c5f7");
    test_class_info(&lv, &cd_S3052C5);
    dp->~S3052C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C5(Test_S3052C5, "S3052C5", ABISELECT(408,312));

#else // __cplusplus

extern void _ZN7S3052C5C1Ev();
extern void _ZN7S3052C5D1Ev();
Name_Map name_map_S3052C5[] = {
  NSPAIR(_ZN7S3052C5C1Ev),
  NSPAIR(_ZN7S3052C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
static Base_Class bases_S3052C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(312,228), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C5[];
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C5[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTV7S3052C5[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C5[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__7S3052C5[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__7S3052C5[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__7S3052C5[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C5[] = {
  {&(_ZTV7S3052C5[3]),  3,14},
  {&(_tg__ZTV7S3052C7__7S3052C5[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__7S3052C5[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__7S3052C5[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__7S3052C5[4]),  4,7},
  {&(_ZTV7S3052C5[11]),  11,14},
};
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C5 = {  "S3052C5", // class name
  bases_S3052C5, 3,
  &(vtc_S3052C5[0]), // expected_vtbl_contents
  &(vtt_S3052C5[0]), // expected_vtt_contents
  ABISELECT(408,312), // object size
  NSPAIRA(_ZTI7S3052C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3052C5),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C5),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C10  {
  void *s3052c10f0;
  int s3052c10f1;
  __tsi64 s3052c10f2;
  void *s3052c10f3;
  int s3052c10f4;
  void  mf3052c10(); // _ZN8S3052C109mf3052c10Ev
};
//SIG(-1 S3052C10) C1{ m Fp Fi FL Fp Fi}


void  S3052C10 ::mf3052c10(){}

static void Test_S3052C10()
{
  {
    init_simple_test("S3052C10");
    S3052C10 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S3052C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C10)");
    check_field_offset(lv, s3052c10f0, 0, "S3052C10.s3052c10f0");
    check_field_offset(lv, s3052c10f1, ABISELECT(8,4), "S3052C10.s3052c10f1");
    check_field_offset(lv, s3052c10f2, ABISELECT(16,8), "S3052C10.s3052c10f2");
    check_field_offset(lv, s3052c10f3, ABISELECT(24,16), "S3052C10.s3052c10f3");
    check_field_offset(lv, s3052c10f4, ABISELECT(32,20), "S3052C10.s3052c10f4");
  }
}
static Arrange_To_Call_Me vS3052C10(Test_S3052C10, "S3052C10", ABISELECT(40,24));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S3052C10[];
VTBL_ENTRY *P__ZTI8S3052C10 = _ZTI8S3052C10; 
Class_Descriptor cd_S3052C10 = {  "S3052C10", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S3052C10),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C12  {
  ::S3052C7 s3052c12f0;
  void  mf3052c12(); // _ZN8S3052C129mf3052c12Ev
  virtual  ~S3052C12(); // _ZN8S3052C12D1Ev
  S3052C12(); // tgen
};
//SIG(-1 S3052C12) C1{ vd m FC2{ VBC3{ vd v3 Fs[6] FL[8] Fi} BC4{ VBC3 FL Fp FL:54} v1 v2 Fc:0 Fp[8] Fc}}


void  S3052C12 ::mf3052c12(){}
 S3052C12 ::~S3052C12(){ note_dtor("S3052C12", this);}
S3052C12 ::S3052C12(){ note_ctor("S3052C12", this);} // tgen

static void Test_S3052C12()
{
  extern Class_Descriptor cd_S3052C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,38)];
    init_test(&cd_S3052C12, buf);
    S3052C12 *dp, &lv = *(dp=new (buf) S3052C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S3052C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C12)");
    check_field_offset(lv, s3052c12f0, ABISELECT(8,4), "S3052C12.s3052c12f0");
    test_class_info(&lv, &cd_S3052C12);
    dp->~S3052C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C12(Test_S3052C12, "S3052C12", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S3052C12C1Ev();
extern void _ZN8S3052C12D1Ev();
Name_Map name_map_S3052C12[] = {
  NSPAIR(_ZN8S3052C12C1Ev),
  NSPAIR(_ZN8S3052C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S3052C12[];
extern void _ZN8S3052C12D1Ev();
extern void _ZN8S3052C12D0Ev();
static  VTBL_ENTRY vtc_S3052C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C12[0]),
  (VTBL_ENTRY)&_ZN8S3052C12D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C12D0Ev,
};
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
Class_Descriptor cd_S3052C12 = {  "S3052C12", // class name
  0,0,//no base classes
  &(vtc_S3052C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S3052C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S3052C12),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S3052C13  {
  void *s3052c13f0;
  int s3052c13f1;
  int s3052c13f2;
  int s3052c13f3;
  int s3052c13f4:19;
  void *s3052c13f5;
  char s3052c13f6;
  long double s3052c13f7;
  int s3052c13f8;
  short s3052c13f9;
  void  mf3052c13(); // _ZN8S3052C139mf3052c13Ev
};
//SIG(1 S3052C13) U1{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}

#endif // __cplusplus
#ifdef __cplusplus

struct  S3052C11  : virtual S3052C6 , S3052C7 , S3052C5 , S3052C12 , virtual S3052C8 {
  void *s3052c11f0;
  long s3052c11f1;
  ::S3052C5 s3052c11f2;
  ::S3052C12 s3052c11f3;
  ::S3052C8 s3052c11f4;
  int s3052c11f5[2];
  ::S3052C13 s3052c11f6[9];
  ~S3052C11(); // tgen
  S3052C11(); // tgen
};
//SIG(-1 S3052C11) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} BC5{ VBC2 BC3 Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} BC6{ vd m FC3} VBC4 Fp Fl FC5 FC6 FC4 Fi[2] FU7{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}


S3052C11 ::~S3052C11(){ note_dtor("S3052C11", this);} // tgen
S3052C11 ::S3052C11(){ note_ctor("S3052C11", this);} // tgen

static void Test_S3052C11()
{
  extern Class_Descriptor cd_S3052C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(105,310)];
    init_test(&cd_S3052C11, buf);
    S3052C11 *dp, &lv = *(dp=new (buf) S3052C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1664,1236), "sizeof(S3052C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C11)");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(1536,1128), "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(1536,1128), "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(1536,1128), "S3052C11");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*), ABISELECT(1536,1128), "S3052C11");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*), ABISELECT(1536,1128), "S3052C11");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(1536,1128), "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(1536,1128), "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), 0, "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*), 0, "S3052C11");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(104,60), "S3052C11");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*), ABISELECT(104,60), "S3052C11");
    check_base_class_offset(lv, (S3052C5*), ABISELECT(104,60), "S3052C11");
    check_base_class_offset(lv, (S3052C12*), ABISELECT(416,288), "S3052C11");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*), ABISELECT(1632,1212), "S3052C11");
    check_field_offset(lv, s3052c11f0, ABISELECT(624,436), "S3052C11.s3052c11f0");
    check_field_offset(lv, s3052c11f1, ABISELECT(632,440), "S3052C11.s3052c11f1");
    check_field_offset(lv, s3052c11f2, ABISELECT(640,444), "S3052C11.s3052c11f2");
    check_field_offset(lv, s3052c11f3, ABISELECT(1048,756), "S3052C11.s3052c11f3");
    check_field_offset(lv, s3052c11f4, ABISELECT(1256,904), "S3052C11.s3052c11f4");
    check_field_offset(lv, s3052c11f5, ABISELECT(1384,1012), "S3052C11.s3052c11f5");
    check_field_offset(lv, s3052c11f6, ABISELECT(1392,1020), "S3052C11.s3052c11f6");
    test_class_info(&lv, &cd_S3052C11);
    dp->~S3052C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C11(Test_S3052C11, "S3052C11", ABISELECT(1664,1236));

#else // __cplusplus

extern void _ZN8S3052C11C1Ev();
extern void _ZN8S3052C11D1Ev();
Name_Map name_map_S3052C11[] = {
  NSPAIR(_ZN8S3052C11C1Ev),
  NSPAIR(_ZN8S3052C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
static Base_Class bases_S3052C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(1536,1128), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(104,60), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C12,    ABISELECT(416,288), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(1632,1212), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C11[];
extern void _ZN8S3052C11D1Ev();
extern void _ZN8S3052C11D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZThn416_N8S3052C11D1Ev,_ZThn288_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn416_N8S3052C11D0Ev,_ZThn288_N8S3052C11D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1632_N8S3052C11D1Ev,_ZThn1212_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1632_N8S3052C11D0Ev,_ZThn1212_N8S3052C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C11[] = {
  ABISELECT(1632,1212),
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&_ZN8S3052C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C11D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(1432,1068),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-416,-288),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn416_N8S3052C11D1Ev,_ZThn288_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn416_N8S3052C11D0Ev,_ZThn288_N8S3052C11D0Ev),
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(-1632,-1212),
  ABISELECT(-96,-84),
  ABISELECT(-1632,-1212),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev),
};
extern VTBL_ENTRY _ZTV8S3052C11[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C11[] = {
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C11[] = {
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn1536_N7S3052C8D1Ev,_ZThn1128_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn1536_N7S3052C8D0Ev,_ZThn1128_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C11[] = {
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn1536_N7S3052C7D1Ev,_ZThn1128_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn1536_N7S3052C7D0Ev,_ZThn1128_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__8S3052C11[] = {
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C11[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C5__A1__8S3052C11[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C5__A1__8S3052C11[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C8D1Ev,_ZThn1068_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C8D0Ev,_ZThn1068_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__A1__8S3052C11[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C7D1Ev,_ZThn1068_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C7D0Ev,_ZThn1068_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C5__A1__8S3052C11[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C5D1Ev,_ZThn1068_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn1432_N7S3052C5D0Ev,_ZThn1068_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C5__8S3052C11[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C11[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A2__8S3052C11[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C11[] = {
  {&(_ZTV8S3052C11[4]),  4,32},
  {&(_tg__ZTV7S3052C7__8S3052C11[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C11[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C11[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__8S3052C11[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C11[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C5__A1__8S3052C11[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C5__A1__8S3052C11[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__A1__8S3052C11[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C5__A1__8S3052C11[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C5__8S3052C11[4]),  4,7},
  {&(_ZTV8S3052C11[23]),  23,32},
  {&(_ZTV8S3052C11[11]),  11,32},
  {&(_ZTV8S3052C11[30]),  30,32},
  {&(_tg__ZTV7S3052C8__A2__8S3052C11[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A2__8S3052C11[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C11[];
extern  VTBL_ENTRY _ZTV8S3052C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C11[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C5D0Ev,_ZThn1068_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C5D1Ev,_ZThn1068_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C7D0Ev,_ZThn1068_N7S3052C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N7S3052C7D0Ev,_ZThn1128_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C7D1Ev,_ZThn1068_N7S3052C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N7S3052C7D1Ev,_ZThn1128_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C8D0Ev,_ZThn1068_N7S3052C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N7S3052C8D0Ev,_ZThn1128_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N7S3052C8D1Ev,_ZThn1068_N7S3052C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N7S3052C8D1Ev,_ZThn1128_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1632_N8S3052C11D0Ev,_ZThn1212_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1632_N8S3052C11D1Ev,_ZThn1212_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C11 = {  "S3052C11", // class name
  bases_S3052C11, 8,
  &(vtc_S3052C11[0]), // expected_vtbl_contents
  &(vtt_S3052C11[0]), // expected_vtt_contents
  ABISELECT(1664,1236), // object size
  NSPAIRA(_ZTI8S3052C11),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S3052C11),32, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C11),16, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C9  : S3052C10 , virtual S3052C7 {
  void *s3052c9f0;
  char s3052c9f1[4];
  int s3052c9f2:11;
  void *s3052c9f3[2];
  int s3052c9f4[6];
  ::S3052C11 s3052c9f5[6];
  ~S3052C9(); // tgen
  S3052C9(); // tgen
};
//SIG(-1 S3052C9) C1{ BC2{ m Fp Fi FL Fp Fi} VBC3{ VBC4{ vd v1 Fs[6] FL[8] Fi} BC5{ VBC4 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp Fc[4] Fi:11 Fp[2] Fi[6] FC6{ VBC4 BC3 BC7{ VBC4 BC3 Fp[3] Fc:8 Fi[2] Fc FC4 Fp[3] FL[5] Fi} BC8{ vd m FC3} VBC5 Fp Fl FC7 FC8 FC5 Fi[2] FU9{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]}


S3052C9 ::~S3052C9(){ note_dtor("S3052C9", this);} // tgen
S3052C9 ::S3052C9(){ note_ctor("S3052C9", this);} // tgen

static void Test_S3052C9()
{
  extern Class_Descriptor cd_S3052C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(645,1909)];
    init_test(&cd_S3052C9, buf);
    S3052C9 *dp, &lv = *(dp=new (buf) S3052C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(10304,7632), "sizeof(S3052C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C9)");
    check_base_class_offset(lv, (S3052C10*), ABISELECT(8,4), "S3052C9");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(10200,7548), "S3052C9");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(10200,7548), "S3052C9");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(10096,7488), "S3052C9");
    check_base_class_offset(lv, (S3052C7*), ABISELECT(10096,7488), "S3052C9");
    check_field_offset(lv, s3052c9f0, ABISELECT(48,28), "S3052C9.s3052c9f0");
    check_field_offset(lv, s3052c9f1, ABISELECT(56,32), "S3052C9.s3052c9f1");
    set_bf_and_test(lv, s3052c9f2, ABISELECT(60,36), 0, 11, 1, "S3052C9");
    set_bf_and_test(lv, s3052c9f2, ABISELECT(60,36), 0, 11, hide_sll(1LL<<10), "S3052C9");
    check_field_offset(lv, s3052c9f3, ABISELECT(64,40), "S3052C9.s3052c9f3");
    check_field_offset(lv, s3052c9f4, ABISELECT(80,48), "S3052C9.s3052c9f4");
    check_field_offset(lv, s3052c9f5, ABISELECT(112,72), "S3052C9.s3052c9f5");
    test_class_info(&lv, &cd_S3052C9);
    dp->~S3052C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C9(Test_S3052C9, "S3052C9", ABISELECT(10304,7632));

#else // __cplusplus

extern void _ZN7S3052C9C1Ev();
extern void _ZN7S3052C9D1Ev();
Name_Map name_map_S3052C9[] = {
  NSPAIR(_ZN7S3052C9C1Ev),
  NSPAIR(_ZN7S3052C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
static Base_Class bases_S3052C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C10,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C6,    ABISELECT(10200,7548), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(10096,7488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(10096,7488), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C9[];
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10096_N7S3052C9D1Ev,_ZThn7488_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10096_N7S3052C9D0Ev,_ZThn7488_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10200_N7S3052C9D1Ev,_ZThn7548_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10200_N7S3052C9D0Ev,_ZThn7548_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C9[] = {
  ABISELECT(10200,7548),
  ABISELECT(10096,7488),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
  0,
  0,
  ABISELECT(-10096,-7488),
  ABISELECT(104,60),
  ABISELECT(-10096,-7488),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-10200,-7548),
  ABISELECT(-10200,-7548),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTV7S3052C9[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C9[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__7S3052C9[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__7S3052C9[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__7S3052C9[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C9[] = {
  {&(_ZTV7S3052C9[4]),  4,23},
  {&(_ZTV7S3052C9[12]),  12,23},
  {&(_ZTV7S3052C9[20]),  20,23},
  {&(_tg__ZTV7S3052C7__7S3052C9[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__7S3052C9[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__7S3052C9[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__7S3052C9[4]),  4,7},
};
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10200_N7S3052C9D0Ev,_ZThn7548_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10200_N7S3052C9D1Ev,_ZThn7548_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10096_N7S3052C9D0Ev,_ZThn7488_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10096_N7S3052C9D1Ev,_ZThn7488_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C9 = {  "S3052C9", // class name
  bases_S3052C9, 4,
  &(vtc_S3052C9[0]), // expected_vtbl_contents
  &(vtt_S3052C9[0]), // expected_vtt_contents
  ABISELECT(10304,7632), // object size
  NSPAIRA(_ZTI7S3052C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3052C9),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C9),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C4  : S3052C5 , virtual S3052C7 , S3052C9 , virtual S3052C11 , virtual S3052C12 {
  ::S3052C12 s3052c4f0[2];
  int s3052c4f1;
  long double s3052c4f2;
  long double s3052c4f3;
  char  :0;
  void *s3052c4f5;
  virtual  ~S3052C4(); // _ZN7S3052C4D2Ev
  S3052C4(); // tgen
};
//SIG(-1 S3052C4) C1{ BC2{ VBC3{ vd v1 Fs[6] FL[8] Fi} BC4{ VBC3 BC5{ VBC3 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} VBC4 BC6{ BC7{ m Fp Fi FL Fp Fi} VBC4 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC8{ VBC3 BC4 BC2 BC9{ vd m FC4} VBC5 Fp Fl FC2 FC9 FC5 Fi[2] FU10{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} VBC8 VBC9 vd FC9[2] Fi FD FD Fc:0 Fp}


 S3052C4 ::~S3052C4(){ note_dtor("S3052C4", this);}
S3052C4 ::S3052C4(){ note_ctor("S3052C4", this);} // tgen

static void Test_S3052C4()
{
  extern Class_Descriptor cd_S3052C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(805,2373)];
    init_test(&cd_S3052C4, buf);
    S3052C4 *dp, &lv = *(dp=new (buf) S3052C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12864,9488), "sizeof(S3052C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C4)");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C5*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(10888,8044), "S3052C4");
    check_base_class_offset(lv, (S3052C6*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(10888,8044), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*), 0, "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C5*), 0, "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C5*), 0, "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(10984,8128), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*), ABISELECT(10984,8128), "S3052C4");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*), ABISELECT(10984,8128), "S3052C4");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*), ABISELECT(328,232), "S3052C4");
    check_base_class_offset(lv, (S3052C9*), ABISELECT(320,228), "S3052C4");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(11088,8188), "S3052C4");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C11*), ABISELECT(11088,8188), "S3052C4");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(11192,8248), "S3052C4");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(11192,8248), "S3052C4");
    check_base_class_offset(lv, (S3052C5*)(S3052C11*), ABISELECT(11192,8248), "S3052C4");
    check_base_class_offset(lv, (S3052C12*)(S3052C11*), ABISELECT(11504,8476), "S3052C4");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C11*), ABISELECT(12624,9316), "S3052C4");
    check_base_class_offset(lv, (S3052C11*), ABISELECT(11088,8188), "S3052C4");
    /*is_ambiguous_... S3052C4::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*), ABISELECT(12656,9340), "S3052C4");
    check_field_offset(lv, s3052c4f0, ABISELECT(10416,7716), "S3052C4.s3052c4f0");
    check_field_offset(lv, s3052c4f1, ABISELECT(10832,8012), "S3052C4.s3052c4f1");
    check_field_offset(lv, s3052c4f2, ABISELECT(10848,8016), "S3052C4.s3052c4f2");
    check_field_offset(lv, s3052c4f3, ABISELECT(10864,8028), "S3052C4.s3052c4f3");
    check_field_offset(lv, s3052c4f5, ABISELECT(10880,8040), "S3052C4.s3052c4f5");
    test_class_info(&lv, &cd_S3052C4);
    dp->~S3052C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C4(Test_S3052C4, "S3052C4", ABISELECT(12864,9488));

#else // __cplusplus

extern void _ZN7S3052C4C1Ev();
extern void _ZN7S3052C4D2Ev();
Name_Map name_map_S3052C4[] = {
  NSPAIR(_ZN7S3052C4C1Ev),
  NSPAIR(_ZN7S3052C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C11;
extern VTBL_ENTRY _ZTI8S3052C11[];
extern  VTBL_ENTRY _ZTV8S3052C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
static Base_Class bases_S3052C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(10888,8044), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(10984,8128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(10984,8128), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C10,    ABISELECT(328,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(320,228), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(11088,8188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(11088,8188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(11192,8248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(11192,8248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(11192,8248), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(11504,8476), //bcp->offset
    52, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(12624,9316), //bcp->offset
    56, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3052C11,    ABISELECT(11088,8188), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    ABISELECT(12656,9340), //bcp->offset
    62, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C4[];
extern void _ZN7S3052C4D1Ev();
extern void _ZN7S3052C4D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C4[] = {
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&_ZN7S3052C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev),
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-10984,-8128),
  ABISELECT(-96,-84),
  ABISELECT(-10984,-8128),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  0,
  ABISELECT(-11088,-8188),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-11088,-8188),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-304,-204),
  ABISELECT(-11192,-8248),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-11504,-8476),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev),
  ABISELECT(-12624,-9316),
  ABISELECT(-1736,-1272),
  ABISELECT(-12624,-9316),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
  ABISELECT(-12656,-9340),
  ABISELECT(-12656,-9340),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
};
extern VTBL_ENTRY _ZTV7S3052C4[];
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__7S3052C4[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C5__7S3052C4[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C5__7S3052C4[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__7S3052C4[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C5__7S3052C4[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C5__7S3052C4[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C9__7S3052C4[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C9__7S3052C4[] = {
  0,
  0,
  ABISELECT(-10664,-7900),
  ABISELECT(-96,-84),
  ABISELECT(-10664,-7900),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C9__7S3052C4[] = {
  0,
  ABISELECT(-10568,-7816),
  ABISELECT(-10568,-7816),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C4[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A1__7S3052C4[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C4[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__7S3052C4[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C11D1Ev();
extern void _ZN8S3052C11D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C4[] = {
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&_ZN8S3052C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C11D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C78S3052C11__A2__7S3052C4[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C4[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C4[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C4[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C4[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C4[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C4[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C4[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C4[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C4[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C11__7S3052C4[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C11__7S3052C4[] = {
  ABISELECT(-304,-204),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C11__7S3052C4[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-1736,-1272),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev),
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C4[] = {
  ABISELECT(-1736,-1272),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A4__7S3052C4[] = {
  0,
  ABISELECT(1736,1272),
  ABISELECT(1736,1272),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C4[] = {
  {&(_ZTV7S3052C4[7]),  7,67},
  {&(_tg__ZTV7S3052C5__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C5__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C5__7S3052C4[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C5__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C5__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C9__7S3052C4[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C9__7S3052C4[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C9__7S3052C4[4]),  4,7},
  {&(_ZTV7S3052C4[21]),  21,67},
  {&(_ZTV7S3052C4[30]),  30,67},
  {&(_ZTV7S3052C4[15]),  15,67},
  {&(_ZTV7S3052C4[41]),  41,67},
  {&(_ZTV7S3052C4[48]),  48,67},
  {&(_ZTV7S3052C4[54]),  54,67},
  {&(_ZTV7S3052C4[60]),  60,67},
  {&(_ZTV7S3052C4[65]),  65,67},
  {&(_tg__ZTV7S3052C7__A1__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A1__7S3052C4[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__7S3052C4[4]),  4,7},
  {&(_tg__ZTV8S3052C11__7S3052C4[4]),  4,8},
  {&(_tg__ZTV7S3052C78S3052C11__A2__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C4[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C4[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C11__7S3052C4[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C11__7S3052C4[3]),  3,7},
  {&(_tg__ZTV7S3052C8__A2__8S3052C11__7S3052C4[4]),  4,6},
  {&(_tg__ZTV7S3052C8__A4__7S3052C4[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A4__7S3052C4[4]),  4,7},
};
extern VTBL_ENTRY _ZTI7S3052C4[];
extern  VTBL_ENTRY _ZTV7S3052C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C4[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C4 = {  "S3052C4", // class name
  bases_S3052C4, 17,
  &(vtc_S3052C4[0]), // expected_vtbl_contents
  &(vtt_S3052C4[0]), // expected_vtt_contents
  ABISELECT(12864,9488), // object size
  NSPAIRA(_ZTI7S3052C4),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S3052C4),67, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C4),38, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S3052C16  {
  char s3052c16f0:2;
  char s3052c16f1;
  void *s3052c16f2;
  void *s3052c16f3;
  void *s3052c16f4;
  int s3052c16f5;
  short s3052c16f6[6];
  char s3052c16f7;
  void  mf3052c16(); // _ZN8S3052C169mf3052c16Ev
};
//SIG(1 S3052C16) U1{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc}

#endif // __cplusplus
#ifdef __cplusplus

struct  S3052C15  : S3052C12 , virtual S3052C6 , virtual S3052C7 {
  ::S3052C7 s3052c15f0[2];
  long double s3052c15f1;
  ::S3052C12 s3052c15f2;
  void *s3052c15f3[3];
  ::S3052C5 s3052c15f4;
  int s3052c15f5;
  ::S3052C16 s3052c15f6;
  int s3052c15f7;
  virtual void  v6(); // _ZN8S3052C152v6Ev
  ~S3052C15(); // tgen
  S3052C15(); // tgen
};
//SIG(-1 S3052C15) C1{ BC2{ vd m FC3{ VBC4{ vd v2 Fs[6] FL[8] Fi} BC5{ VBC4 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc}} VBC4 VBC3 v1 FC3[2] FD FC2 Fp[3] FC6{ VBC4 BC3 Fp[3] Fc:8 Fi[2] Fc FC4 Fp[3] FL[5] Fi} Fi FU7{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi}


void  S3052C15 ::v6(){vfunc_called(this, "_ZN8S3052C152v6Ev");}
S3052C15 ::~S3052C15(){ note_dtor("S3052C15", this);} // tgen
S3052C15 ::S3052C15(){ note_ctor("S3052C15", this);} // tgen

static void Test_S3052C15()
{
  extern Class_Descriptor cd_S3052C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(95,272)];
    init_test(&cd_S3052C15, buf);
    S3052C15 *dp, &lv = *(dp=new (buf) S3052C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1504,1084), "sizeof(S3052C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C15)");
    check_base_class_offset(lv, (S3052C12*), 0, "S3052C15");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(1296,940), "S3052C15");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(1296,940), "S3052C15");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(1296,940), "S3052C15");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(1392,1024), "S3052C15");
    check_base_class_offset(lv, (S3052C7*), ABISELECT(1392,1024), "S3052C15");
    check_field_offset(lv, s3052c15f0, ABISELECT(208,148), "S3052C15.s3052c15f0");
    check_field_offset(lv, s3052c15f1, ABISELECT(608,436), "S3052C15.s3052c15f1");
    check_field_offset(lv, s3052c15f2, ABISELECT(624,448), "S3052C15.s3052c15f2");
    check_field_offset(lv, s3052c15f3, ABISELECT(832,596), "S3052C15.s3052c15f3");
    check_field_offset(lv, s3052c15f4, ABISELECT(856,608), "S3052C15.s3052c15f4");
    check_field_offset(lv, s3052c15f5, ABISELECT(1264,920), "S3052C15.s3052c15f5");
    check_field_offset(lv, s3052c15f6, ABISELECT(1272,924), "S3052C15.s3052c15f6");
    check_field_offset(lv, s3052c15f7, ABISELECT(1288,936), "S3052C15.s3052c15f7");
    test_class_info(&lv, &cd_S3052C15);
    dp->~S3052C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C15(Test_S3052C15, "S3052C15", ABISELECT(1504,1084));

#else // __cplusplus

extern void _ZN8S3052C15C1Ev();
extern void _ZN8S3052C15D1Ev();
Name_Map name_map_S3052C15[] = {
  NSPAIR(_ZN8S3052C15C1Ev),
  NSPAIR(_ZN8S3052C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
static Base_Class bases_S3052C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C6,    ABISELECT(1296,940), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1392,1024), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C15[];
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1296_N8S3052C15D1Ev,_ZThn940_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1296_N8S3052C15D0Ev,_ZThn940_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C15D1Ev,_ZThn1024_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C15D0Ev,_ZThn1024_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY vtc_S3052C15[] = {
  ABISELECT(1392,1024),
  ABISELECT(1296,940),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  0,
  ABISELECT(-1296,-940),
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-1392,-1024),
  ABISELECT(-96,-84),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern VTBL_ENTRY _ZTV8S3052C15[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C15[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C15[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C15[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__8S3052C15[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C15[] = {
  {&(_ZTV8S3052C15[4]),  4,24},
  {&(_ZTV8S3052C15[11]),  11,24},
  {&(_ZTV8S3052C15[20]),  20,24},
  {&(_tg__ZTV7S3052C7__8S3052C15[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C15[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C15[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__8S3052C15[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1392_N8S3052C15D0Ev,_ZThn1024_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1392_N8S3052C15D1Ev,_ZThn1024_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N8S3052C15D0Ev,_ZThn940_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N8S3052C15D1Ev,_ZThn940_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C15 = {  "S3052C15", // class name
  bases_S3052C15, 4,
  &(vtc_S3052C15[0]), // expected_vtbl_contents
  &(vtt_S3052C15[0]), // expected_vtt_contents
  ABISELECT(1504,1084), // object size
  NSPAIRA(_ZTI8S3052C15),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3052C15),24, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C15),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C17  : virtual S3052C6 , S3052C5 , virtual S3052C8 , virtual S3052C7 {
  void *s3052c17f0;
  void *s3052c17f1[5];
  void *s3052c17f2;
  virtual  ~S3052C17(); // _ZN8S3052C17D2Ev
  S3052C17(); // tgen
};
//SIG(-1 S3052C17) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 BC5{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} VBC5 VBC4 vd Fp[7]}


 S3052C17 ::~S3052C17(){ note_dtor("S3052C17", this);}
S3052C17 ::S3052C17(){ note_ctor("S3052C17", this);} // tgen

static void Test_S3052C17()
{
  extern Class_Descriptor cd_S3052C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(76,107)];
    init_test(&cd_S3052C17, buf);
    S3052C17 *dp, &lv = *(dp=new (buf) S3052C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(600,424), "sizeof(S3052C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C17)");
    check_base_class_offset(lv, (S3052C6*), ABISELECT(368,256), "S3052C17");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*), ABISELECT(368,256), "S3052C17");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*), ABISELECT(368,256), "S3052C17");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(368,256), "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(368,256), "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(368,256), "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(368,256), "S3052C17");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*), 0, "S3052C17");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*), 0, "S3052C17");
    check_base_class_offset(lv, (S3052C5*), 0, "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*), ABISELECT(464,340), "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(496,364), "S3052C17");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*), ABISELECT(496,364), "S3052C17");
    check_field_offset(lv, s3052c17f0, ABISELECT(312,228), "S3052C17.s3052c17f0");
    check_field_offset(lv, s3052c17f1, ABISELECT(320,232), "S3052C17.s3052c17f1");
    check_field_offset(lv, s3052c17f2, ABISELECT(360,252), "S3052C17.s3052c17f2");
    test_class_info(&lv, &cd_S3052C17);
    dp->~S3052C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C17(Test_S3052C17, "S3052C17", ABISELECT(600,424));

#else // __cplusplus

extern void _ZN8S3052C17C1Ev();
extern void _ZN8S3052C17D2Ev();
Name_Map name_map_S3052C17[] = {
  NSPAIR(_ZN8S3052C17C1Ev),
  NSPAIR(_ZN8S3052C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
static Base_Class bases_S3052C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(368,256), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(464,340), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    ABISELECT(496,364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(496,364), //bcp->offset
    22, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C17[];
extern void _ZN8S3052C17D1Ev();
extern void _ZN8S3052C17D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn368_N8S3052C17D1Ev,_ZThn256_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn368_N8S3052C17D0Ev,_ZThn256_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn464_N8S3052C17D1Ev,_ZThn340_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn464_N8S3052C17D0Ev,_ZThn340_N8S3052C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn496_N8S3052C17D1Ev,_ZThn364_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn496_N8S3052C17D0Ev,_ZThn364_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY vtc_S3052C17[] = {
  ABISELECT(496,364),
  ABISELECT(464,340),
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&_ZN8S3052C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C17D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(-464,-340),
  ABISELECT(-96,-84),
  ABISELECT(-464,-340),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  0,
  0,
  ABISELECT(-496,-364),
  ABISELECT(-128,-108),
  ABISELECT(-496,-364),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern VTBL_ENTRY _ZTV8S3052C17[];
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C17[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C5__8S3052C17[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C5__8S3052C17[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn368_N7S3052C8D1Ev,_ZThn256_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn368_N7S3052C8D0Ev,_ZThn256_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C17[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn368_N7S3052C7D1Ev,_ZThn256_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn368_N7S3052C7D0Ev,_ZThn256_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C17[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn368_N7S3052C5D1Ev,_ZThn256_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn368_N7S3052C5D0Ev,_ZThn256_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C5__8S3052C17[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C17[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A1__8S3052C17[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C17[] = {
  ABISELECT(-128,-108),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A2__8S3052C17[] = {
  ABISELECT(-128,-108),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A2__8S3052C17[] = {
  0,
  ABISELECT(128,108),
  ABISELECT(128,108),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__8S3052C17[] = {
  0,
  ABISELECT(128,108),
  ABISELECT(128,108),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C17[] = {
  {&(_ZTV8S3052C17[5]),  5,32},
  {&(_tg__ZTV7S3052C5__8S3052C17[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C5__8S3052C17[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C5__8S3052C17[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C17[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C17[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C5__8S3052C17[4]),  4,7},
  {&(_ZTV8S3052C17[13]),  13,32},
  {&(_ZTV8S3052C17[20]),  20,32},
  {&(_ZTV8S3052C17[28]),  28,32},
  {&(_tg__ZTV7S3052C8__A1__8S3052C17[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A1__8S3052C17[4]),  4,7},
  {&(_tg__ZTV7S3052C7__A1__8S3052C17[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A2__8S3052C17[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A2__8S3052C17[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__8S3052C17[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C17[];
extern  VTBL_ENTRY _ZTV8S3052C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C17[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C5D0Ev,_ZThn256_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C5D1Ev,_ZThn256_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C7D0Ev,_ZThn256_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C7D1Ev,_ZThn256_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C8D0Ev,_ZThn256_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N7S3052C8D1Ev,_ZThn256_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S3052C17D0Ev,_ZThn364_N8S3052C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S3052C17D0Ev,_ZThn340_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S3052C17D1Ev,_ZThn364_N8S3052C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S3052C17D1Ev,_ZThn340_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C17D0Ev,_ZThn256_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C17D1Ev,_ZThn256_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C17 = {  "S3052C17", // class name
  bases_S3052C17, 7,
  &(vtc_S3052C17[0]), // expected_vtbl_contents
  &(vtt_S3052C17[0]), // expected_vtt_contents
  ABISELECT(600,424), // object size
  NSPAIRA(_ZTI8S3052C17),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3052C17),32, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C17),16, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C14  : S3052C15 , virtual S3052C8 , S3052C6 , S3052C17 {
  ::S3052C6 s3052c14f0[9];
  char s3052c14f1;
  int s3052c14f2;
  int s3052c14f3;
  int s3052c14f4;
  char s3052c14f5;
  virtual void  v7(); // _ZN8S3052C142v7Ev
  ~S3052C14(); // tgen
  S3052C14(); // tgen
};
//SIG(-1 S3052C14) C1{ BC2{ BC3{ vd m FC4{ VBC5{ vd v2 Fs[6] FL[8] Fi} BC6{ VBC5 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc}} VBC5 VBC4 v5 FC4[2] FD FC3 Fp[3] FC7{ VBC5 BC4 Fp[3] Fc:8 Fi[2] Fc FC5 Fp[3] FL[5] Fi} Fi FU8{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} VBC6 BC5 BC9{ VBC5 BC7 VBC6 VBC4 vd Fp Fp[5] Fp} v1 FC5[9] Fc Fi Fi Fi Fc}


void  S3052C14 ::v7(){vfunc_called(this, "_ZN8S3052C142v7Ev");}
S3052C14 ::~S3052C14(){ note_dtor("S3052C14", this);} // tgen
S3052C14 ::S3052C14(){ note_ctor("S3052C14", this);} // tgen

static void Test_S3052C14()
{
  extern Class_Descriptor cd_S3052C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(181,557)];
    init_test(&cd_S3052C14, buf);
    S3052C14 *dp, &lv = *(dp=new (buf) S3052C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2880,2224), "sizeof(S3052C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C14)");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*), 0, "S3052C14");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*), ABISELECT(2648,2056), "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(2648,2056), "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(2648,2056), "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(2648,2056), "S3052C14");
    check_base_class_offset(lv, (S3052C6*)(S3052C17*), ABISELECT(2648,2056), "S3052C14");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C17*), ABISELECT(2648,2056), "S3052C14");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C17*), ABISELECT(2648,2056), "S3052C14");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*), ABISELECT(2648,2056), "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(2744,2140), "S3052C14");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*), ABISELECT(2744,2140), "S3052C14");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C17*), ABISELECT(2744,2140), "S3052C14");
    check_base_class_offset(lv, (S3052C15*), 0, "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*), ABISELECT(2848,2200), "S3052C14");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C17*), ABISELECT(2848,2200), "S3052C14");
    /*is_ambiguous_... S3052C14::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*), ABISELECT(1296,940), "S3052C14");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*), ABISELECT(1392,1024), "S3052C14");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C17*), ABISELECT(1392,1024), "S3052C14");
    check_base_class_offset(lv, (S3052C5*)(S3052C17*), ABISELECT(1392,1024), "S3052C14");
    check_base_class_offset(lv, (S3052C17*), ABISELECT(1392,1024), "S3052C14");
    check_field_offset(lv, s3052c14f0, ABISELECT(1760,1280), "S3052C14.s3052c14f0");
    check_field_offset(lv, s3052c14f1, ABISELECT(2624,2036), "S3052C14.s3052c14f1");
    check_field_offset(lv, s3052c14f2, ABISELECT(2628,2040), "S3052C14.s3052c14f2");
    check_field_offset(lv, s3052c14f3, ABISELECT(2632,2044), "S3052C14.s3052c14f3");
    check_field_offset(lv, s3052c14f4, ABISELECT(2636,2048), "S3052C14.s3052c14f4");
    check_field_offset(lv, s3052c14f5, ABISELECT(2640,2052), "S3052C14.s3052c14f5");
    test_class_info(&lv, &cd_S3052C14);
    dp->~S3052C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C14(Test_S3052C14, "S3052C14", ABISELECT(2880,2224));

#else // __cplusplus

extern void _ZN8S3052C14C1Ev();
extern void _ZN8S3052C14D1Ev();
Name_Map name_map_S3052C14[] = {
  NSPAIR(_ZN8S3052C14C1Ev),
  NSPAIR(_ZN8S3052C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C17;
extern VTBL_ENTRY _ZTI8S3052C17[];
extern  VTBL_ENTRY _ZTV8S3052C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C17[];
static Base_Class bases_S3052C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C6,    ABISELECT(2648,2056), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(2744,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(2744,2140), //bcp->offset
    30, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3052C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(2848,2200), //bcp->offset
    40, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C6,    ABISELECT(1296,940), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3052C17,    ABISELECT(1392,1024), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C14[];
extern void _ZN8S3052C14D1Ev();
extern void _ZN8S3052C14D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
extern void ABISELECT(_ZThn1296_N8S3052C14D1Ev,_ZThn940_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1296_N8S3052C14D0Ev,_ZThn940_N8S3052C14D0Ev)();
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn2648_N8S3052C14D1Ev,_ZThn2056_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn2648_N8S3052C14D0Ev,_ZThn2056_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn2744_N8S3052C14D1Ev,_ZThn2140_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn2744_N8S3052C14D0Ev,_ZThn2140_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn2848_N8S3052C14D1Ev,_ZThn2200_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn2848_N8S3052C14D0Ev,_ZThn2200_N8S3052C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C14[] = {
  ABISELECT(2848,2200),
  ABISELECT(2744,2140),
  ABISELECT(2648,2056),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&_ZN8S3052C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C14D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N8S3052C14D1Ev,_ZThn940_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N8S3052C14D0Ev,_ZThn940_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(1352,1116),
  ABISELECT(1456,1176),
  ABISELECT(1256,1032),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-2648,-2056),
  ABISELECT(-2648,-2056),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-2744,-2140),
  ABISELECT(-96,-84),
  ABISELECT(-2744,-2140),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-2848,-2200),
  ABISELECT(-200,-144),
  ABISELECT(-2848,-2200),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
};
extern VTBL_ENTRY _ZTV8S3052C14[];
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C15__8S3052C14[] = {
  ABISELECT(2744,2140),
  ABISELECT(2648,2056),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn2648_N8S3052C15D1Ev,_ZThn2056_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn2648_N8S3052C15D0Ev,_ZThn2056_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C15__8S3052C14[] = {
  0,
  ABISELECT(-2648,-2056),
  ABISELECT(-2648,-2056),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn2744_N8S3052C15D1Ev,_ZThn2140_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn2744_N8S3052C15D0Ev,_ZThn2140_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C15__8S3052C14[] = {
  0,
  0,
  ABISELECT(-2744,-2140),
  ABISELECT(-96,-84),
  ABISELECT(-2744,-2140),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN8S3052C17D1Ev();
extern void _ZN8S3052C17D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C17__8S3052C14[] = {
  ABISELECT(1352,1116),
  ABISELECT(1456,1176),
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&_ZN8S3052C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C17D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C17__8S3052C14[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C17__A1__8S3052C14[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C17__A2__8S3052C14[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C8D1Ev,_ZThn1032_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C8D0Ev,_ZThn1032_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C17__A2__8S3052C14[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C7D1Ev,_ZThn1032_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C7D0Ev,_ZThn1032_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C17__A1__8S3052C14[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C5D1Ev,_ZThn1032_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn1256_N7S3052C5D0Ev,_ZThn1032_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C17__8S3052C14[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1256_N8S3052C17D1Ev,_ZThn1032_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1256_N8S3052C17D0Ev,_ZThn1032_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C17__8S3052C14[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1456_N8S3052C17D1Ev,_ZThn1176_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1456_N8S3052C17D0Ev,_ZThn1176_N8S3052C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C17__8S3052C14[] = {
  ABISELECT(-1456,-1176),
  ABISELECT(-200,-144),
  ABISELECT(-1456,-1176),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1352_N8S3052C17D1Ev,_ZThn1116_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1352_N8S3052C17D0Ev,_ZThn1116_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C17__8S3052C14[] = {
  0,
  0,
  ABISELECT(-1352,-1116),
  ABISELECT(-96,-84),
  ABISELECT(-1352,-1116),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C14[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C14[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C14[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__8S3052C14[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C14[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A1__8S3052C14[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C14[] = {
  {&(_ZTV8S3052C14[5]),  5,46},
  {&(_tg__ZTV8S3052C15__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C15__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C15__8S3052C14[6]),  6,10},
  {&(_tg__ZTV8S3052C17__8S3052C14[5]),  5,9},
  {&(_tg__ZTV7S3052C58S3052C17__8S3052C14[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C17__A1__8S3052C14[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C17__A2__8S3052C14[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C17__A2__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C17__A1__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C17__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C17__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C17__8S3052C14[4]),  4,6},
  {&(_tg__ZTV7S3052C7__A1__8S3052C17__8S3052C14[6]),  6,10},
  {&(_ZTV8S3052C14[27]),  27,46},
  {&(_ZTV8S3052C14[36]),  36,46},
  {&(_ZTV8S3052C14[44]),  44,46},
  {&(_ZTV8S3052C14[19]),  19,46},
  {&(_tg__ZTV7S3052C7__8S3052C14[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C14[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__8S3052C14[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C14[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A1__8S3052C14[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C14[];
extern  VTBL_ENTRY _ZTV8S3052C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C14[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S3052C17D0Ev,_ZThn1116_N8S3052C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1456_N8S3052C17D0Ev,_ZThn1176_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S3052C17D1Ev,_ZThn1116_N8S3052C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1456_N8S3052C17D1Ev,_ZThn1176_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S3052C17D0Ev,_ZThn1032_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S3052C17D1Ev,_ZThn1032_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C5D0Ev,_ZThn1032_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C5D1Ev,_ZThn1032_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C7D0Ev,_ZThn1032_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C7D1Ev,_ZThn1032_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C8D0Ev,_ZThn1032_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N7S3052C8D1Ev,_ZThn1032_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N8S3052C15D0Ev,_ZThn2140_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N8S3052C15D1Ev,_ZThn2140_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N8S3052C15D0Ev,_ZThn2056_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N8S3052C15D1Ev,_ZThn2056_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2848_N8S3052C14D0Ev,_ZThn2200_N8S3052C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N8S3052C14D0Ev,_ZThn2140_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2848_N8S3052C14D1Ev,_ZThn2200_N8S3052C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N8S3052C14D1Ev,_ZThn2140_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N8S3052C14D0Ev,_ZThn2056_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N8S3052C14D1Ev,_ZThn2056_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C14 = {  "S3052C14", // class name
  bases_S3052C14, 11,
  &(vtc_S3052C14[0]), // expected_vtbl_contents
  &(vtt_S3052C14[0]), // expected_vtt_contents
  ABISELECT(2880,2224), // object size
  NSPAIRA(_ZTI8S3052C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3052C14),46, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C14),24, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S3052C18  {
  short s3052c18f0;
  void *s3052c18f1[9];
  char s3052c18f2;
  int s3052c18f3[5];
  __tsi64 s3052c18f4;
  void *s3052c18f5;
  void *s3052c18f6;
  int s3052c18f7;
  long double s3052c18f8;
  int s3052c18f9[4];
  int s3052c18f10:32;
  int s3052c18f11;
  long double s3052c18f12;
  void  mf3052c18(); // _ZN8S3052C189mf3052c18Ev
};
//SIG(1 S3052C18) U1{ m Fs Fp[9] Fc Fi[5] FL Fp Fp Fi FD Fi[4] Fi:32 Fi FD}

#endif // __cplusplus
#ifdef __cplusplus

struct  S3052C22_nt  {
};
//SIG(-1 S3052C22_nt) C1{}



//skip512 S3052C22_nt

#else // __cplusplus

Class_Descriptor cd_S3052C22_nt = {  "S3052C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C21  : virtual S3052C7 , virtual S3052C9 , S3052C15 {
  void *s3052c21f0;
  ::S3052C22_nt s3052c21f1;
  ::S3052C6 s3052c21f2;
  __tsi64 s3052c21f3;
  ::S3052C13 s3052c21f4;
  __tsi64 s3052c21f5[6];
  __tsi64 s3052c21f6;
  ::S3052C5 s3052c21f7;
  virtual void  v9(); // _ZN8S3052C212v9Ev
  ~S3052C21(); // tgen
  S3052C21(); // tgen
};
//SIG(-1 S3052C21) C1{ VBC2{ VBC3{ vd v2 Fs[6] FL[8] Fi} BC4{ VBC3 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} VBC5{ BC6{ m Fp Fi FL Fp Fi} VBC2 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC7{ VBC3 BC2 BC8{ VBC3 BC2 Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} BC9{ vd m FC2} VBC4 Fp Fl FC8 FC9 FC4 Fi[2] FU10{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC11{ BC9 VBC3 VBC2 v5 FC2[2] FD FC9 Fp[3] FC8 Fi FU12{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v1 Fp FC13{} FC3 FL FU10 FL[6] FL FC8}


void  S3052C21 ::v9(){vfunc_called(this, "_ZN8S3052C212v9Ev");}
S3052C21 ::~S3052C21(){ note_dtor("S3052C21", this);} // tgen
S3052C21 ::S3052C21(){ note_ctor("S3052C21", this);} // tgen

static void Test_S3052C21()
{
  extern Class_Descriptor cd_S3052C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(764,2264)];
    init_test(&cd_S3052C21, buf);
    S3052C21 *dp, &lv = *(dp=new (buf) S3052C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12208,9052), "sizeof(S3052C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C21)");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(2008,1480), "S3052C21");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(2008,1480), "S3052C21");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*), ABISELECT(2008,1480), "S3052C21");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(1904,1420), "S3052C21");
    check_base_class_offset(lv, (S3052C7*), ABISELECT(1904,1420), "S3052C21");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*), ABISELECT(1904,1420), "S3052C21");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*), ABISELECT(1904,1420), "S3052C21");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*), ABISELECT(2120,1568), "S3052C21");
    check_base_class_offset(lv, (S3052C9*), ABISELECT(2112,1564), "S3052C21");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*), 0, "S3052C21");
    check_base_class_offset(lv, (S3052C15*), 0, "S3052C21");
    check_field_offset(lv, s3052c21f0, ABISELECT(1296,940), "S3052C21.s3052c21f0");
    check_field_offset(lv, s3052c21f1, ABISELECT(1304,944), "S3052C21.s3052c21f1");
    check_field_offset(lv, s3052c21f2, ABISELECT(1312,948), "S3052C21.s3052c21f2");
    check_field_offset(lv, s3052c21f3, ABISELECT(1408,1032), "S3052C21.s3052c21f3");
    check_field_offset(lv, s3052c21f4, ABISELECT(1424,1040), "S3052C21.s3052c21f4");
    check_field_offset(lv, s3052c21f5, ABISELECT(1440,1052), "S3052C21.s3052c21f5");
    check_field_offset(lv, s3052c21f6, ABISELECT(1488,1100), "S3052C21.s3052c21f6");
    check_field_offset(lv, s3052c21f7, ABISELECT(1496,1108), "S3052C21.s3052c21f7");
    test_class_info(&lv, &cd_S3052C21);
    dp->~S3052C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C21(Test_S3052C21, "S3052C21", ABISELECT(12208,9052));

#else // __cplusplus

extern void _ZN8S3052C21C1Ev();
extern void _ZN8S3052C21D1Ev();
Name_Map name_map_S3052C21[] = {
  NSPAIR(_ZN8S3052C21C1Ev),
  NSPAIR(_ZN8S3052C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
static Base_Class bases_S3052C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(2008,1480), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(1904,1420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1904,1420), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C10,    ABISELECT(2120,1568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(2112,1564), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C21[];
extern void _ZN8S3052C21D1Ev();
extern void _ZN8S3052C21D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C212v9Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn2008_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn2008_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn2112_N8S3052C21D1Ev,_ZThn1564_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn2112_N8S3052C21D0Ev,_ZThn1564_N8S3052C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C21[] = {
  ABISELECT(2112,1564),
  ABISELECT(1904,1420),
  ABISELECT(2008,1480),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&_ZN8S3052C21D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C21D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C212v9Ev,
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(104,60),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-2008,-1480),
  ABISELECT(-2008,-1480),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(-2112,-1564),
  ABISELECT(-104,-84),
  ABISELECT(-208,-144),
  ABISELECT(-2112,-1564),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev),
};
extern VTBL_ENTRY _ZTV8S3052C21[];
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C15__8S3052C21[] = {
  ABISELECT(1904,1420),
  ABISELECT(2008,1480),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn2008_N8S3052C15D1Ev,_ZThn1480_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn2008_N8S3052C15D0Ev,_ZThn1480_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C15__8S3052C21[] = {
  0,
  ABISELECT(-2008,-1480),
  ABISELECT(-2008,-1480),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C15__8S3052C21[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(104,60),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C21[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C21[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C21[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__8S3052C21[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C9__8S3052C21[] = {
  ABISELECT(-104,-84),
  ABISELECT(-208,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C9__8S3052C21[] = {
  0,
  0,
  ABISELECT(208,144),
  ABISELECT(104,60),
  ABISELECT(208,144),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C9__8S3052C21[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C21[] = {
  {&(_ZTV8S3052C21[5]),  5,33},
  {&(_tg__ZTV8S3052C15__8S3052C21[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C15__8S3052C21[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C15__8S3052C21[6]),  6,10},
  {&(_ZTV8S3052C21[15]),  15,33},
  {&(_ZTV8S3052C21[23]),  23,33},
  {&(_ZTV8S3052C21[31]),  31,33},
  {&(_tg__ZTV7S3052C7__8S3052C21[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C21[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C21[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__8S3052C21[4]),  4,7},
  {&(_tg__ZTV7S3052C9__8S3052C21[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C9__8S3052C21[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C9__8S3052C21[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C21[];
extern  VTBL_ENTRY _ZTV8S3052C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C21[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D0Ev,_ZThn60_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C7D1Ev,_ZThn60_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D0Ev,_ZThn60_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S3052C8D1Ev,_ZThn60_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N8S3052C15D0Ev,_ZThn1480_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N8S3052C15D1Ev,_ZThn1480_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N8S3052C21D0Ev,_ZThn1564_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N8S3052C21D1Ev,_ZThn1564_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C21 = {  "S3052C21", // class name
  bases_S3052C21, 7,
  &(vtc_S3052C21[0]), // expected_vtbl_contents
  &(vtt_S3052C21[0]), // expected_vtt_contents
  ABISELECT(12208,9052), // object size
  NSPAIRA(_ZTI8S3052C21),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3052C21),33, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C21),14, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C20  : virtual S3052C6 , virtual S3052C21 , S3052C14 {
  ::S3052C11 s3052c20f0;
  ::S3052C13 s3052c20f1;
  int s3052c20f2;
  char s3052c20f3;
  virtual  ~S3052C20(); // _ZN8S3052C20D2Ev
  S3052C20(); // tgen
};
//SIG(-1 S3052C20) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} VBC3{ VBC4{ VBC2 BC5{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} VBC6{ BC7{ m Fp Fi FL Fp Fi} VBC4 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC8{ VBC2 BC4 BC9{ VBC2 BC4 Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} BC10{ vd m FC4} VBC5 Fp Fl FC9 FC10 FC5 Fi[2] FU11{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC12{ BC10 VBC2 VBC4 v4 FC4[2] FD FC10 Fp[3] FC9 Fi FU13{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v5 Fp FC14{} FC2 FL FU11 FL[6] FL FC9} BC15{ BC12 VBC5 BC2 BC16{ VBC2 BC9 VBC5 VBC4 vd Fp Fp[5] Fp} v6 FC2[9] Fc Fi Fi Fi Fc} vd FC8 FU11 Fi Fc}


 S3052C20 ::~S3052C20(){ note_dtor("S3052C20", this);}
S3052C20 ::S3052C20(){ note_ctor("S3052C20", this);} // tgen

static void Test_S3052C20()
{
  extern Class_Descriptor cd_S3052C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1038,3098)];
    init_test(&cd_S3052C20, buf);
    S3052C20 *dp, &lv = *(dp=new (buf) S3052C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16592,12388), "sizeof(S3052C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C20)");
    /*is_ambiguous_... S3052C20::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*), ABISELECT(4344,3312), "S3052C20");
    /*is_ambiguous_... S3052C20::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(4344,3312), "S3052C20");
    /*is_ambiguous_... S3052C20::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*)(S3052C21*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*)(S3052C14*), ABISELECT(4344,3312), "S3052C20");
    /*is_ambiguous_... S3052C20::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C17*)(S3052C14*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(4344,3312), "S3052C20");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(4344,3312), "S3052C20");
    /*is_ambiguous_... S3052C20::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(6352,4816), "S3052C20");
    check_base_class_offset(lv, (S3052C7*)(S3052C21*), ABISELECT(6352,4816), "S3052C20");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*), ABISELECT(6352,4816), "S3052C20");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*)(S3052C21*), ABISELECT(6352,4816), "S3052C20");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*)(S3052C14*), ABISELECT(6352,4816), "S3052C20");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C17*)(S3052C14*), ABISELECT(6352,4816), "S3052C20");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*), ABISELECT(6472,4880), "S3052C20");
    check_base_class_offset(lv, (S3052C9*)(S3052C21*), ABISELECT(6464,4876), "S3052C20");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*)(S3052C21*), ABISELECT(4448,3396), "S3052C20");
    check_base_class_offset(lv, (S3052C15*)(S3052C21*), ABISELECT(4448,3396), "S3052C20");
    check_base_class_offset(lv, (S3052C21*), ABISELECT(4448,3396), "S3052C20");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*)(S3052C14*), 0, "S3052C20");
    check_base_class_offset(lv, (S3052C15*)(S3052C14*), 0, "S3052C20");
    /*is_ambiguous_... S3052C14::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C14*), ABISELECT(16560,12364), "S3052C20");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C17*)(S3052C14*), ABISELECT(16560,12364), "S3052C20");
    /*is_ambiguous_... S3052C14::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C14*), ABISELECT(1296,940), "S3052C20");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1392,1024), "S3052C20");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1392,1024), "S3052C20");
    check_base_class_offset(lv, (S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1392,1024), "S3052C20");
    check_base_class_offset(lv, (S3052C17*)(S3052C14*), ABISELECT(1392,1024), "S3052C20");
    check_base_class_offset(lv, (S3052C14*), 0, "S3052C20");
    check_field_offset(lv, s3052c20f0, ABISELECT(2656,2056), "S3052C20.s3052c20f0");
    check_field_offset(lv, s3052c20f1, ABISELECT(4320,3292), "S3052C20.s3052c20f1");
    check_field_offset(lv, s3052c20f2, ABISELECT(4336,3304), "S3052C20.s3052c20f2");
    check_field_offset(lv, s3052c20f3, ABISELECT(4340,3308), "S3052C20.s3052c20f3");
    test_class_info(&lv, &cd_S3052C20);
    dp->~S3052C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C20(Test_S3052C20, "S3052C20", ABISELECT(16592,12388));

#else // __cplusplus

extern void _ZN8S3052C20C1Ev();
extern void _ZN8S3052C20D2Ev();
Name_Map name_map_S3052C20[] = {
  NSPAIR(_ZN8S3052C20C1Ev),
  NSPAIR(_ZN8S3052C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C21;
extern VTBL_ENTRY _ZTI8S3052C21[];
extern  VTBL_ENTRY _ZTV8S3052C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C21[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C17;
extern VTBL_ENTRY _ZTI8S3052C17[];
extern  VTBL_ENTRY _ZTV8S3052C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C17[];
extern Class_Descriptor cd_S3052C14;
extern VTBL_ENTRY _ZTI8S3052C14[];
extern  VTBL_ENTRY _ZTV8S3052C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C14[];
static Base_Class bases_S3052C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(4344,3312), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    ABISELECT(6352,4816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(6352,4816), //bcp->offset
    44, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(6472,4880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(6464,4876), //bcp->offset
    54, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(4448,3396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C15,    ABISELECT(4448,3396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3052C21,    ABISELECT(4448,3396), //bcp->offset
    32, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S3052C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(16560,12364), //bcp->offset
    61, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3052C6,    ABISELECT(1296,940), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3052C17,    ABISELECT(1392,1024), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C20[];
extern void _ZN8S3052C20D1Ev();
extern void _ZN8S3052C20D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
extern void ABISELECT(_ZThn1296_N8S3052C20D1Ev,_ZThn940_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn1296_N8S3052C20D0Ev,_ZThn940_N8S3052C20D0Ev)();
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZThn1392_N8S3052C20D1Ev,_ZThn1024_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C20D0Ev,_ZThn1024_N8S3052C20D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C20D1Ev,_ZTv0_n12_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C20D1Ev,_ZThn3312_N8S3052C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C20D0Ev,_ZTv0_n12_N8S3052C20D0Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C20D0Ev,_ZThn3312_N8S3052C20D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S3052C20D1Ev,_ZTv0_n24_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn4448_N8S3052C20D1Ev,_ZThn3396_N8S3052C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3052C20D0Ev,_ZTv0_n24_N8S3052C20D0Ev)();
extern void ABISELECT(_ZThn4448_N8S3052C20D0Ev,_ZThn3396_N8S3052C20D0Ev)() __attribute__((weak));
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C212v9Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C20D1Ev,_ZTv0_n16_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C20D1Ev,_ZThn4816_N8S3052C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C20D0Ev,_ZTv0_n16_N8S3052C20D0Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C20D0Ev,_ZThn4816_N8S3052C20D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n40_N8S3052C20D1Ev,_ZTv0_n20_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn6464_N8S3052C20D1Ev,_ZThn4876_N8S3052C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C20D0Ev,_ZTv0_n20_N8S3052C20D0Ev)();
extern void ABISELECT(_ZThn6464_N8S3052C20D0Ev,_ZThn4876_N8S3052C20D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C20D1Ev,_ZTv0_n16_N8S3052C20D1Ev)();
extern void ABISELECT(_ZThn16560_N8S3052C20D1Ev,_ZThn12364_N8S3052C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C20D0Ev,_ZTv0_n16_N8S3052C20D0Ev)();
extern void ABISELECT(_ZThn16560_N8S3052C20D0Ev,_ZThn12364_N8S3052C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C20[] = {
  ABISELECT(6464,4876),
  ABISELECT(4448,3396),
  ABISELECT(16560,12364),
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&_ZN8S3052C20D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C20D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N8S3052C20D1Ev,_ZThn940_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N8S3052C20D0Ev,_ZThn940_N8S3052C20D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C20D1Ev,_ZThn1024_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C20D0Ev,_ZThn1024_N8S3052C20D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C20D1Ev,_ZTv0_n12_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C20D0Ev,_ZTv0_n12_N8S3052C20D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-4448,-3396),
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  ABISELECT(-4448,-3396),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3052C20D1Ev,_ZTv0_n24_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3052C20D0Ev,_ZTv0_n24_N8S3052C20D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C212v9Ev,
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C20D1Ev,_ZTv0_n16_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C20D0Ev,_ZTv0_n16_N8S3052C20D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-6464,-4876),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-6464,-4876),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C20D1Ev,_ZTv0_n20_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C20D0Ev,_ZTv0_n20_N8S3052C20D0Ev),
  ABISELECT(-16560,-12364),
  ABISELECT(-12216,-9052),
  ABISELECT(-16560,-12364),
  (VTBL_ENTRY)&(_ZTI8S3052C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C20D1Ev,_ZTv0_n16_N8S3052C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C20D0Ev,_ZTv0_n16_N8S3052C20D0Ev),
};
extern VTBL_ENTRY _ZTV8S3052C20[];
extern void _ZN8S3052C14D1Ev();
extern void _ZN8S3052C14D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C14__8S3052C20[] = {
  ABISELECT(16560,12364),
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&_ZN8S3052C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C14D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C158S3052C14__A1__8S3052C20[] = {
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C15D1Ev,_ZThn3312_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C15D0Ev,_ZThn3312_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C158S3052C14__A1__8S3052C20[] = {
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C15D1Ev,_ZThn4816_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C15D0Ev,_ZThn4816_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C158S3052C14__A1__8S3052C20[] = {
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN8S3052C17D1Ev();
extern void _ZN8S3052C17D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C178S3052C14__8S3052C20[] = {
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&_ZN8S3052C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C17D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C178S3052C14__8S3052C20[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C178S3052C14__A1__8S3052C20[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C14__A2__8S3052C20[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C8D1Ev,_ZThn2288_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C8D0Ev,_ZThn2288_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C14__A2__8S3052C20[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C7D1Ev,_ZThn2288_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C7D0Ev,_ZThn2288_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C14__A1__8S3052C20[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C5D1Ev,_ZThn2288_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn2952_N7S3052C5D0Ev,_ZThn2288_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C178S3052C14__8S3052C20[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn2952_N8S3052C17D1Ev,_ZThn2288_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn2952_N8S3052C17D0Ev,_ZThn2288_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C178S3052C14__8S3052C20[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn15168_N8S3052C17D1Ev,_ZThn11340_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn15168_N8S3052C17D0Ev,_ZThn11340_N8S3052C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C178S3052C14__8S3052C20[] = {
  ABISELECT(-15168,-11340),
  ABISELECT(-12216,-9052),
  ABISELECT(-15168,-11340),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn4960_N8S3052C17D1Ev,_ZThn3792_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn4960_N8S3052C17D0Ev,_ZThn3792_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C178S3052C14__8S3052C20[] = {
  0,
  0,
  ABISELECT(-4960,-3792),
  ABISELECT(-2008,-1504),
  ABISELECT(-4960,-3792),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C14D1Ev,_ZThn3312_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn4344_N8S3052C14D0Ev,_ZThn3312_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C14__8S3052C20[] = {
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C14D1Ev,_ZThn4816_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn6352_N8S3052C14D0Ev,_ZThn4816_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C14__8S3052C20[] = {
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn16560_N8S3052C14D1Ev,_ZThn12364_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn16560_N8S3052C14D0Ev,_ZThn12364_N8S3052C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C14__8S3052C20[] = {
  ABISELECT(-16560,-12364),
  ABISELECT(-12216,-9052),
  ABISELECT(-16560,-12364),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
};
extern void ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C17__8S3052C14__8S3052C20[] = {
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN8S3052C21D1Ev();
extern void _ZN8S3052C21D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C212v9Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C21__8S3052C20[] = {
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&_ZN8S3052C21D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C21D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C212v9Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C158S3052C21__8S3052C20[] = {
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C158S3052C21__8S3052C20[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C158S3052C21__8S3052C20[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C21__8S3052C20[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C21__8S3052C20[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn2016_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn2016_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C9__8S3052C21__8S3052C20[] = {
  ABISELECT(-2016,-1480),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-2016,-1480),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev),
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C20[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C20[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C20[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__8S3052C20[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C9__8S3052C20[] = {
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C9__8S3052C20[] = {
  0,
  0,
  ABISELECT(112,60),
  ABISELECT(-2008,-1504),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C9__8S3052C20[] = {
  0,
  ABISELECT(2120,1564),
  ABISELECT(2120,1564),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C20[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A1__8S3052C20[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C20[] = {
  {&(_ZTV8S3052C20[7]),  7,67},
  {&(_tg__ZTV8S3052C14__8S3052C20[5]),  5,9},
  {&(_tg__ZTV8S3052C158S3052C14__A1__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C158S3052C14__A1__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C158S3052C14__A1__8S3052C20[6]),  6,10},
  {&(_tg__ZTV8S3052C178S3052C14__8S3052C20[5]),  5,9},
  {&(_tg__ZTV7S3052C58S3052C178S3052C14__8S3052C20[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C178S3052C14__A1__8S3052C20[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C14__A2__8S3052C20[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C14__A2__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C14__A1__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C178S3052C14__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C178S3052C14__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C178S3052C14__8S3052C20[4]),  4,6},
  {&(_tg__ZTV7S3052C7__A1__8S3052C178S3052C14__8S3052C20[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C14__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C14__8S3052C20[6]),  6,10},
  {&(_tg__ZTV7S3052C8__A1__8S3052C14__8S3052C20[4]),  4,6},
  {&(_tg__ZTV8S3052C17__8S3052C14__8S3052C20[5]),  5,9},
  {&(_ZTV8S3052C20[29]),  29,67},
  {&(_ZTV8S3052C20[40]),  40,67},
  {&(_ZTV8S3052C20[50]),  50,67},
  {&(_ZTV8S3052C20[59]),  59,67},
  {&(_ZTV8S3052C20[65]),  65,67},
  {&(_ZTV8S3052C20[21]),  21,67},
  {&(_tg__ZTV8S3052C21__8S3052C20[5]),  5,9},
  {&(_tg__ZTV8S3052C158S3052C21__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C158S3052C21__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C158S3052C21__8S3052C20[6]),  6,10},
  {&(_tg__ZTV7S3052C7__8S3052C21__8S3052C20[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C21__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C9__8S3052C21__8S3052C20[5]),  5,7},
  {&(_tg__ZTV7S3052C7__8S3052C20[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C20[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C9__8S3052C20[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C9__8S3052C20[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C9__8S3052C20[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C20[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A1__8S3052C20[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C20[];
extern  VTBL_ENTRY _ZTV8S3052C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C20[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N8S3052C14D0Ev,_ZThn12364_N8S3052C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C14D0Ev,_ZThn4816_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N8S3052C14D1Ev,_ZThn12364_N8S3052C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C14D1Ev,_ZThn4816_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C14D0Ev,_ZThn3312_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C14D1Ev,_ZThn3312_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4960_N8S3052C17D0Ev,_ZThn3792_N8S3052C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15168_N8S3052C17D0Ev,_ZThn11340_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4960_N8S3052C17D1Ev,_ZThn3792_N8S3052C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15168_N8S3052C17D1Ev,_ZThn11340_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S3052C17D0Ev,_ZThn2288_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S3052C17D1Ev,_ZThn2288_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C5D0Ev,_ZThn2288_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C5D1Ev,_ZThn2288_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C7D0Ev,_ZThn2288_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C7D1Ev,_ZThn2288_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C8D0Ev,_ZThn2288_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N7S3052C8D1Ev,_ZThn2288_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C15D0Ev,_ZThn4816_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C15D1Ev,_ZThn4816_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C15D0Ev,_ZThn3312_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C15D1Ev,_ZThn3312_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C20D0Ev,_ZTv0_n20_N8S3052C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6464_N8S3052C20D0Ev,_ZThn4876_N8S3052C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C20D1Ev,_ZTv0_n20_N8S3052C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6464_N8S3052C20D1Ev,_ZThn4876_N8S3052C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C20D0Ev,_ZTv0_n16_N8S3052C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N8S3052C20D0Ev,_ZThn12364_N8S3052C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C20D0Ev,_ZThn4816_N8S3052C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C20D1Ev,_ZTv0_n16_N8S3052C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N8S3052C20D1Ev,_ZThn12364_N8S3052C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N8S3052C20D1Ev,_ZThn4816_N8S3052C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3052C20D0Ev,_ZTv0_n24_N8S3052C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4448_N8S3052C20D0Ev,_ZThn3396_N8S3052C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3052C20D1Ev,_ZTv0_n24_N8S3052C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4448_N8S3052C20D1Ev,_ZThn3396_N8S3052C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C20D0Ev,_ZTv0_n12_N8S3052C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C20D0Ev,_ZThn3312_N8S3052C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C20D1Ev,_ZTv0_n12_N8S3052C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N8S3052C20D1Ev,_ZThn3312_N8S3052C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C20 = {  "S3052C20", // class name
  bases_S3052C20, 17,
  &(vtc_S3052C20[0]), // expected_vtbl_contents
  &(vtt_S3052C20[0]), // expected_vtt_contents
  ABISELECT(16592,12388), // object size
  NSPAIRA(_ZTI8S3052C20),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S3052C20),67, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C20),41, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C24  : virtual S3052C5 {
  void *s3052c24f0[6];
  ~S3052C24(); // tgen
  S3052C24(); // tgen
};
//SIG(-1 S3052C24) C1{ VBC2{ VBC3{ vd v1 Fs[6] FL[8] Fi} BC4{ VBC3 BC5{ VBC3 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} Fp[6]}


S3052C24 ::~S3052C24(){ note_dtor("S3052C24", this);} // tgen
S3052C24 ::S3052C24(){ note_ctor("S3052C24", this);} // tgen

static void Test_S3052C24()
{
  extern Class_Descriptor cd_S3052C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,86)];
    init_test(&cd_S3052C24, buf);
    S3052C24 *dp, &lv = *(dp=new (buf) S3052C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,340), "sizeof(S3052C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3052C24)");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*), ABISELECT(368,256), "S3052C24");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*), ABISELECT(368,256), "S3052C24");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(368,256), "S3052C24");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(56,28), "S3052C24");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*), ABISELECT(56,28), "S3052C24");
    check_base_class_offset(lv, (S3052C5*), ABISELECT(56,28), "S3052C24");
    check_field_offset(lv, s3052c24f0, ABISELECT(8,4), "S3052C24.s3052c24f0");
    test_class_info(&lv, &cd_S3052C24);
    dp->~S3052C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C24(Test_S3052C24, "S3052C24", ABISELECT(464,340));

#else // __cplusplus

extern void _ZN8S3052C24C1Ev();
extern void _ZN8S3052C24D1Ev();
Name_Map name_map_S3052C24[] = {
  NSPAIR(_ZN8S3052C24C1Ev),
  NSPAIR(_ZN8S3052C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
static Base_Class bases_S3052C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(368,256), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(56,28), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C24[];
extern void _ZN8S3052C24D1Ev();
extern void _ZN8S3052C24D0Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev)();
extern void ABISELECT(_ZThn56_N8S3052C24D1Ev,_ZThn28_N8S3052C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev)();
extern void ABISELECT(_ZThn56_N8S3052C24D0Ev,_ZThn28_N8S3052C24D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev)();
extern void ABISELECT(_ZThn368_N8S3052C24D1Ev,_ZThn256_N8S3052C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev)();
extern void ABISELECT(_ZThn368_N8S3052C24D0Ev,_ZThn256_N8S3052C24D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY vtc_S3052C24[] = {
  ABISELECT(368,256),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&_ZN8S3052C24D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C24D0Ev,
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(312,228),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern VTBL_ENTRY _ZTV8S3052C24[];
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C24[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C5__8S3052C24[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C5__8S3052C24[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C24[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C24[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C5__8S3052C24[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C24[] = {
  {&(_ZTV8S3052C24[4]),  4,23},
  {&(_ZTV8S3052C24[12]),  12,23},
  {&(_ZTV8S3052C24[20]),  20,23},
  {&(_tg__ZTV7S3052C5__8S3052C24[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C5__8S3052C24[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C5__8S3052C24[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C24[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C24[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C5__8S3052C24[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C24[];
extern  VTBL_ENTRY _ZTV8S3052C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C24[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C24D0Ev,_ZThn256_N8S3052C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C24D1Ev,_ZThn256_N8S3052C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S3052C24D0Ev,_ZThn28_N8S3052C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S3052C24D1Ev,_ZThn28_N8S3052C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C24 = {  "S3052C24", // class name
  bases_S3052C24, 4,
  &(vtc_S3052C24[0]), // expected_vtbl_contents
  &(vtt_S3052C24[0]), // expected_vtt_contents
  ABISELECT(464,340), // object size
  NSPAIRA(_ZTI8S3052C24),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S3052C24),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C24),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C23  : virtual S3052C24 , virtual S3052C21 , virtual S3052C4 , S3052C3 , S3052C6 {
  int s3052c23f0;
  void *s3052c23f1;
  int s3052c23f2;
  ::S3052C9 s3052c23f3[2];
  ::S3052C8 s3052c23f4;
  long double s3052c23f5;
  int s3052c23f6[3];
  ::S3052C13 s3052c23f7;
  __tsi64 s3052c23f8;
  int s3052c23f9[2];
  int s3052c23f10;
  ::S3052C13 s3052c23f11;
  void *s3052c23f12;
  virtual void  v10(); // _ZN8S3052C233v10Ev
  ~S3052C23(); // tgen
  S3052C23(); // tgen
};
//SIG(1 S3052C23) C1{ VBC2{ VBC3{ VBC4{ vd v2 Fs[6] FL[8] Fi} BC5{ VBC4 BC6{ VBC4 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC4 Fp[3] FL[5] Fi} Fp[6]} VBC7{ VBC5 VBC8{ BC9{ m Fp Fi FL Fp Fi} VBC5 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC10{ VBC4 BC5 BC3 BC11{ vd m FC5} VBC6 Fp Fl FC3 FC11 FC6 Fi[2] FU12{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC13{ BC11 VBC4 VBC5 v5 FC5[2] FD FC11 Fp[3] FC3 Fi FU14{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v6 Fp FC15{} FC4 FL FU12 FL[6] FL FC3} VBC16{ BC3 VBC5 BC8 VBC10 VBC11 vd FC11[2] Fi FD FD Fc:0 Fp} BC17{ v7 Fi:0 Fi[7] Fp} BC4 v1 Fi Fp Fi FC8[2] FC6 FD Fi[3] FU12 FL Fi[2] Fi FU12 Fp}


void  S3052C23 ::v10(){vfunc_called(this, "_ZN8S3052C233v10Ev");}
S3052C23 ::~S3052C23(){ note_dtor("S3052C23", this);} // tgen
S3052C23 ::S3052C23(){ note_ctor("S3052C23", this);} // tgen

static void Test_S3052C23()
{
  extern Class_Descriptor cd_S3052C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2892,8558)];
    init_test(&cd_S3052C23, buf);
    S3052C23 *dp, &lv = *(dp=new (buf) S3052C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(46256,34228), "sizeof(S3052C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C23)");
    /*is_ambiguous_... S3052C23::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C5*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(21368,15832), "S3052C23");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*)(S3052C21*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C4*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(21368,15832), "S3052C23");
    check_base_class_offset(lv, (S3052C6*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(21368,15832), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*), ABISELECT(21056,15604), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C5*), ABISELECT(21056,15604), "S3052C23");
    check_base_class_offset(lv, (S3052C5*)(S3052C24*), ABISELECT(21056,15604), "S3052C23");
    check_base_class_offset(lv, (S3052C24*), ABISELECT(21000,15576), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(23376,17336), "S3052C23");
    check_base_class_offset(lv, (S3052C7*)(S3052C21*), ABISELECT(23376,17336), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C9 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C9*), ABISELECT(23376,17336), "S3052C23");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*)(S3052C21*), ABISELECT(23376,17336), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C4*), ABISELECT(23376,17336), "S3052C23");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*)(S3052C4*), ABISELECT(23376,17336), "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C9 */ AMB_check_base_class_offset(lv, (S3052C10*)(S3052C9*), ABISELECT(23496,17400), "S3052C23");
    check_base_class_offset(lv, (S3052C9*)(S3052C21*), ABISELECT(23488,17396), "S3052C23");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*)(S3052C21*), ABISELECT(21472,15916), "S3052C23");
    check_base_class_offset(lv, (S3052C15*)(S3052C21*), ABISELECT(21472,15916), "S3052C23");
    check_base_class_offset(lv, (S3052C21*), ABISELECT(21472,15916), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(33584,24884), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(33584,24884), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C5*)(S3052C4*), ABISELECT(33584,24884), "S3052C23");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*)(S3052C4*), ABISELECT(33912,25116), "S3052C23");
    check_base_class_offset(lv, (S3052C9*)(S3052C4*), ABISELECT(33904,25112), "S3052C23");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(44480,32928), "S3052C23");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C11*), ABISELECT(44480,32928), "S3052C23");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(44584,32988), "S3052C23");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(44584,32988), "S3052C23");
    check_base_class_offset(lv, (S3052C5*)(S3052C11*), ABISELECT(44584,32988), "S3052C23");
    check_base_class_offset(lv, (S3052C12*)(S3052C11*), ABISELECT(44896,33216), "S3052C23");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C11*), ABISELECT(46016,34056), "S3052C23");
    check_base_class_offset(lv, (S3052C11*)(S3052C4*), ABISELECT(44480,32928), "S3052C23");
    /*is_ambiguous_... S3052C4::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*)(S3052C4*), ABISELECT(46048,34080), "S3052C23");
    check_base_class_offset(lv, (S3052C4*), ABISELECT(33584,24884), "S3052C23");
    check_base_class_offset(lv, (S3052C3*), 0, "S3052C23");
    /*is_ambiguous_... S3052C23::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*), ABISELECT(48,36), "S3052C23");
    check_field_offset(lv, s3052c23f0, ABISELECT(140,120), "S3052C23.s3052c23f0");
    check_field_offset(lv, s3052c23f1, ABISELECT(144,124), "S3052C23.s3052c23f1");
    check_field_offset(lv, s3052c23f2, ABISELECT(152,128), "S3052C23.s3052c23f2");
    check_field_offset(lv, s3052c23f3, ABISELECT(160,132), "S3052C23.s3052c23f3");
    check_field_offset(lv, s3052c23f4, ABISELECT(20768,15396), "S3052C23.s3052c23f4");
    check_field_offset(lv, s3052c23f5, ABISELECT(20896,15504), "S3052C23.s3052c23f5");
    check_field_offset(lv, s3052c23f6, ABISELECT(20912,15516), "S3052C23.s3052c23f6");
    check_field_offset(lv, s3052c23f7, ABISELECT(20928,15528), "S3052C23.s3052c23f7");
    check_field_offset(lv, s3052c23f8, ABISELECT(20944,15540), "S3052C23.s3052c23f8");
    check_field_offset(lv, s3052c23f9, ABISELECT(20952,15548), "S3052C23.s3052c23f9");
    check_field_offset(lv, s3052c23f10, ABISELECT(20960,15556), "S3052C23.s3052c23f10");
    check_field_offset(lv, s3052c23f11, ABISELECT(20976,15560), "S3052C23.s3052c23f11");
    check_field_offset(lv, s3052c23f12, ABISELECT(20992,15572), "S3052C23.s3052c23f12");
    test_class_info(&lv, &cd_S3052C23);
    dp->~S3052C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C23(Test_S3052C23, "S3052C23", ABISELECT(46256,34228));

#else // __cplusplus

extern void _ZN8S3052C23C1Ev();
extern void _ZN8S3052C23D1Ev();
Name_Map name_map_S3052C23[] = {
  NSPAIR(_ZN8S3052C23C1Ev),
  NSPAIR(_ZN8S3052C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C24;
extern VTBL_ENTRY _ZTI8S3052C24[];
extern  VTBL_ENTRY _ZTV8S3052C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C24[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C21;
extern VTBL_ENTRY _ZTI8S3052C21[];
extern  VTBL_ENTRY _ZTV8S3052C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C21[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C11;
extern VTBL_ENTRY _ZTI8S3052C11[];
extern  VTBL_ENTRY _ZTV8S3052C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C4;
extern VTBL_ENTRY _ZTI7S3052C4[];
extern  VTBL_ENTRY _ZTV7S3052C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C4[];
extern Class_Descriptor cd_S3052C3;
extern VTBL_ENTRY _ZTI7S3052C3[];
extern  VTBL_ENTRY _ZTV7S3052C3[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
static Base_Class bases_S3052C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(21368,15832), //bcp->offset
    38, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(21056,15604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(21056,15604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(21056,15604), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3052C24,    ABISELECT(21000,15576), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    ABISELECT(23376,17336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(23376,17336), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(23496,17400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(23488,17396), //bcp->offset
    67, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(21472,15916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3052C15,    ABISELECT(21472,15916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3052C21,    ABISELECT(21472,15916), //bcp->offset
    45, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C8,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C10,    ABISELECT(33912,25116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(33904,25112), //bcp->offset
    88, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(44480,32928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(44480,32928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(44584,32988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(44584,32988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(44584,32988), //bcp->offset
    105, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(44896,33216), //bcp->offset
    112, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(46016,34056), //bcp->offset
    116, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S3052C11,    ABISELECT(44480,32928), //bcp->offset
    94, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(46048,34080), //bcp->offset
    122, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S3052C4,    ABISELECT(33584,24884), //bcp->offset
    74, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C6,    ABISELECT(48,36), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C23[];
extern void _ZN7S3052C32v2Ev();
extern void _ZN8S3052C233v10Ev();
extern void _ZN8S3052C23D1Ev();
extern void _ZN8S3052C23D0Ev();
extern void ABISELECT(_ZThn48_N8S3052C23D1Ev,_ZThn36_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn48_N8S3052C23D0Ev,_ZThn36_N8S3052C23D0Ev)();
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn21000_N8S3052C23D1Ev,_ZThn15576_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn21000_N8S3052C23D0Ev,_ZThn15576_N8S3052C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn21056_N8S3052C23D1Ev,_ZThn15604_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn21056_N8S3052C23D0Ev,_ZThn15604_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S3052C23D1Ev,_ZTv0_n12_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn21368_N8S3052C23D1Ev,_ZThn15832_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C23D0Ev,_ZTv0_n12_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn21368_N8S3052C23D0Ev,_ZThn15832_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S3052C23D1Ev,_ZTv0_n24_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn21472_N8S3052C23D1Ev,_ZThn15916_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S3052C23D0Ev,_ZTv0_n24_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn21472_N8S3052C23D0Ev,_ZThn15916_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C212v9Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn23376_N8S3052C23D1Ev,_ZThn17336_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn23376_N8S3052C23D0Ev,_ZThn17336_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn23488_N8S3052C23D1Ev,_ZThn17396_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn23488_N8S3052C23D0Ev,_ZThn17396_N8S3052C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S3052C23D1Ev,_ZTv0_n32_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn33584_N8S3052C23D1Ev,_ZThn24884_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S3052C23D0Ev,_ZTv0_n32_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn33584_N8S3052C23D0Ev,_ZThn24884_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn320_n64_N8S3052C23D1Ev,_ZTvn228_n32_N8S3052C23D1Ev)();
extern void ABISELECT(_ZTvn320_n64_N8S3052C23D0Ev,_ZTvn228_n32_N8S3052C23D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn44480_N8S3052C23D1Ev,_ZThn32928_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn44480_N8S3052C23D0Ev,_ZThn32928_N8S3052C23D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn104_n40_N8S3052C23D1Ev,_ZTvn60_n20_N8S3052C23D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N8S3052C23D0Ev,_ZTvn60_n20_N8S3052C23D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn416_n40_N8S3052C23D1Ev,_ZTvn288_n20_N8S3052C23D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N8S3052C23D0Ev,_ZTvn288_n20_N8S3052C23D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn46016_N8S3052C23D1Ev,_ZThn34056_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn46016_N8S3052C23D0Ev,_ZThn34056_N8S3052C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C23D1Ev,_ZTv0_n12_N8S3052C23D1Ev)();
extern void ABISELECT(_ZThn46048_N8S3052C23D1Ev,_ZThn34080_N8S3052C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C23D0Ev,_ZTv0_n12_N8S3052C23D0Ev)();
extern void ABISELECT(_ZThn46048_N8S3052C23D0Ev,_ZThn34080_N8S3052C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C23[] = {
  ABISELECT(46048,34080),
  ABISELECT(46016,34056),
  ABISELECT(44480,32928),
  ABISELECT(33584,24884),
  ABISELECT(23488,17396),
  ABISELECT(23376,17336),
  ABISELECT(21472,15916),
  ABISELECT(21368,15832),
  ABISELECT(21056,15604),
  ABISELECT(21000,15576),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
  (VTBL_ENTRY)&_ZN8S3052C233v10Ev,
  (VTBL_ENTRY)&_ZN8S3052C23D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C23D0Ev,
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S3052C23D1Ev,_ZThn36_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S3052C23D0Ev,_ZThn36_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(-21000,-15576),
  ABISELECT(368,256),
  ABISELECT(56,28),
  ABISELECT(-21000,-15576),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev),
  0,
  0,
  ABISELECT(-21056,-15604),
  ABISELECT(312,228),
  ABISELECT(-21056,-15604),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  ABISELECT(-21368,-15832),
  ABISELECT(-21368,-15832),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C23D1Ev,_ZTv0_n12_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C23D0Ev,_ZTv0_n12_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-21472,-15916),
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  ABISELECT(-21472,-15916),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3052C23D1Ev,_ZTv0_n24_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S3052C23D0Ev,_ZTv0_n24_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C212v9Ev,
  0,
  0,
  ABISELECT(-23376,-17336),
  ABISELECT(-2008,-1504),
  ABISELECT(-23376,-17336),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-23488,-17396),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-23488,-17396),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev),
  0,
  0,
  ABISELECT(-33584,-24884),
  ABISELECT(12464,9196),
  ABISELECT(12432,9172),
  ABISELECT(10896,8044),
  ABISELECT(-10208,-7548),
  ABISELECT(-12216,-9052),
  ABISELECT(-33584,-24884),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S3052C23D1Ev,_ZTv0_n32_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S3052C23D0Ev,_ZTv0_n32_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  ABISELECT(-33904,-25112),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N8S3052C23D1Ev,_ZTvn228_n32_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N8S3052C23D0Ev,_ZTvn228_n32_N8S3052C23D0Ev),
  0,
  0,
  ABISELECT(-44480,-32928),
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  ABISELECT(-44480,-32928),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-23216,-17156),
  ABISELECT(-44584,-32988),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N8S3052C23D1Ev,_ZTvn60_n20_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N8S3052C23D0Ev,_ZTvn60_n20_N8S3052C23D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-44896,-33216),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N8S3052C23D1Ev,_ZTvn288_n20_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N8S3052C23D0Ev,_ZTvn288_n20_N8S3052C23D0Ev),
  ABISELECT(-46016,-34056),
  ABISELECT(-24648,-18224),
  ABISELECT(-46016,-34056),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev),
  ABISELECT(-46048,-34080),
  ABISELECT(-46048,-34080),
  (VTBL_ENTRY)&(_ZTI8S3052C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C23D1Ev,_ZTv0_n12_N8S3052C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C23D0Ev,_ZTv0_n12_N8S3052C23D0Ev),
};
extern VTBL_ENTRY _ZTV8S3052C23[];
extern void _ZN8S3052C24D1Ev();
extern void _ZN8S3052C24D0Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C24__8S3052C23[] = {
  ABISELECT(368,256),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&_ZN8S3052C24D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C24D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev)();
extern void ABISELECT(_ZThn56_N8S3052C24D1Ev,_ZThn28_N8S3052C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev)();
extern void ABISELECT(_ZThn56_N8S3052C24D0Ev,_ZThn28_N8S3052C24D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C24__8S3052C23[] = {
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(312,228),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev)();
extern void ABISELECT(_ZThn368_N8S3052C24D1Ev,_ZThn256_N8S3052C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev)();
extern void ABISELECT(_ZThn368_N8S3052C24D0Ev,_ZThn256_N8S3052C24D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C24__8S3052C23[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S3052C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C23[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C5__8S3052C23[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C5__8S3052C23[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C23[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C23[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C5__8S3052C23[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C21D1Ev();
extern void _ZN8S3052C21D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C212v9Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C21__8S3052C23[] = {
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&_ZN8S3052C21D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C21D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C212v9Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C158S3052C21__8S3052C23[] = {
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C158S3052C21__8S3052C23[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C158S3052C21__8S3052C23[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C21__8S3052C23[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C21__8S3052C23[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D1Ev,_ZTv0_n12_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C21D0Ev,_ZTv0_n12_N8S3052C21D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev)();
extern void ABISELECT(_ZThn2016_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev)();
extern void ABISELECT(_ZThn2016_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C9__8S3052C21__8S3052C23[] = {
  ABISELECT(-2016,-1480),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-2016,-1480),
  (VTBL_ENTRY)&(_ZTI8S3052C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev),
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C23[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A1__8S3052C23[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A1__8S3052C23[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__8S3052C23[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C9__8S3052C23[] = {
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C9__8S3052C23[] = {
  0,
  0,
  ABISELECT(112,60),
  ABISELECT(-2008,-1504),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C9__8S3052C23[] = {
  0,
  ABISELECT(2120,1564),
  ABISELECT(2120,1564),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C4D1Ev();
extern void _ZN7S3052C4D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C4__8S3052C23[] = {
  ABISELECT(12464,9196),
  ABISELECT(12432,9172),
  ABISELECT(10896,8044),
  ABISELECT(-10208,-7548),
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&_ZN7S3052C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C57S3052C4__A1__8S3052C23[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C57S3052C4__A2__8S3052C23[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C57S3052C4__A2__8S3052C23[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__A2__8S3052C23[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__A2__8S3052C23[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C57S3052C4__A1__8S3052C23[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C97S3052C4__A1__8S3052C23[] = {
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C97S3052C4__A1__8S3052C23[] = {
  0,
  0,
  ABISELECT(10528,7776),
  ABISELECT(-2008,-1504),
  ABISELECT(10528,7776),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C97S3052C4__A1__8S3052C23[] = {
  0,
  ABISELECT(12536,9280),
  ABISELECT(12536,9280),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C4__8S3052C23[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C4__8S3052C23[] = {
  0,
  0,
  ABISELECT(10208,7548),
  ABISELECT(-2008,-1504),
  ABISELECT(10208,7548),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3052C9__7S3052C4__8S3052C23[] = {
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10896_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10896_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C4__8S3052C23[] = {
  0,
  0,
  ABISELECT(-10896,-8044),
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  ABISELECT(-10896,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C4__8S3052C23[] = {
  ABISELECT(-23216,-17156),
  ABISELECT(-11000,-8104),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S3052C128S3052C11__7S3052C4__8S3052C23[] = {
  ABISELECT(-11312,-8332),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12432_N7S3052C4D1Ev,_ZThn9172_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12432_N7S3052C4D0Ev,_ZThn9172_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C4__8S3052C23[] = {
  ABISELECT(-12432,-9172),
  ABISELECT(-24648,-18224),
  ABISELECT(-12432,-9172),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12464_N7S3052C4D1Ev,_ZThn9196_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12464_N7S3052C4D0Ev,_ZThn9196_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3052C12__A1__7S3052C4__8S3052C23[] = {
  ABISELECT(-12464,-9196),
  ABISELECT(-12464,-9196),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
};
extern void _ZN8S3052C11D1Ev();
extern void _ZN8S3052C11D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__8S3052C23[] = {
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&_ZN8S3052C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C11D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C78S3052C11__A3__8S3052C23[] = {
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C78S3052C11__A3__8S3052C23[] = {
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A3__8S3052C23[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C78S3052C11__A3__8S3052C23[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A2__8S3052C23[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C11__A4__8S3052C23[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A4__8S3052C23[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A4__8S3052C23[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A4__8S3052C23[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C11__A2__8S3052C23[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C11__8S3052C23[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C11__8S3052C23[] = {
  ABISELECT(-23216,-17156),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C11__8S3052C23[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-24648,-18224),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev),
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A5__8S3052C23[] = {
  ABISELECT(-24648,-18224),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A5__8S3052C23[] = {
  0,
  ABISELECT(24648,18224),
  ABISELECT(24648,18224),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C23[] = {
  {&(_ZTV8S3052C23[12]),  12,127},
  {&(_ZTV8S3052C23[26]),  26,127},
  {&(_ZTV8S3052C23[34]),  34,127},
  {&(_ZTV8S3052C23[42]),  42,127},
  {&(_ZTV8S3052C23[53]),  53,127},
  {&(_ZTV8S3052C23[63]),  63,127},
  {&(_ZTV8S3052C23[72]),  72,127},
  {&(_ZTV8S3052C23[84]),  84,127},
  {&(_ZTV8S3052C23[92]),  92,127},
  {&(_ZTV8S3052C23[101]),  101,127},
  {&(_ZTV8S3052C23[108]),  108,127},
  {&(_ZTV8S3052C23[114]),  114,127},
  {&(_ZTV8S3052C23[120]),  120,127},
  {&(_ZTV8S3052C23[125]),  125,127},
  {&(_tg__ZTV8S3052C24__8S3052C23[4]),  4,6},
  {&(_tg__ZTV7S3052C5__8S3052C24__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C24__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C5__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C5__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C5__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C5__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C5__8S3052C23[4]),  4,7},
  {&(_tg__ZTV8S3052C21__8S3052C23[5]),  5,9},
  {&(_tg__ZTV8S3052C158S3052C21__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C158S3052C21__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C158S3052C21__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C7__8S3052C21__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C21__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C9__8S3052C21__8S3052C23[5]),  5,7},
  {&(_tg__ZTV7S3052C7__A1__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A1__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A1__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C9__8S3052C23[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C9__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C9__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C4__8S3052C23[7]),  7,11},
  {&(_tg__ZTV7S3052C57S3052C4__A1__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C57S3052C4__A2__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C57S3052C4__A2__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__A2__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__A2__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C57S3052C4__A1__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C97S3052C4__A1__8S3052C23[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C97S3052C4__A1__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C97S3052C4__A1__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C4__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C7__A1__7S3052C4__8S3052C23[6]),  6,10},
  {&(_tg__ZTV7S3052C9__7S3052C4__8S3052C23[4]),  4,6},
  {&(_tg__ZTV8S3052C11__7S3052C4__8S3052C23[7]),  7,11},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C4__8S3052C23[3]),  3,7},
  {&(_tg__ZTV8S3052C128S3052C11__7S3052C4__8S3052C23[2]),  2,4},
  {&(_tg__ZTV7S3052C8__A4__7S3052C4__8S3052C23[4]),  4,6},
  {&(_tg__ZTV8S3052C12__A1__7S3052C4__8S3052C23[3]),  3,5},
  {&(_tg__ZTV8S3052C11__8S3052C23[4]),  4,8},
  {&(_tg__ZTV7S3052C78S3052C11__A3__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C78S3052C11__A3__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A3__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C78S3052C11__A3__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C58S3052C11__A2__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C11__A4__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A4__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A4__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A4__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C11__A2__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C11__8S3052C23[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C11__8S3052C23[3]),  3,7},
  {&(_tg__ZTV7S3052C8__A2__8S3052C11__8S3052C23[4]),  4,6},
  {&(_tg__ZTV7S3052C8__A5__8S3052C23[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A5__8S3052C23[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C23[];
extern  VTBL_ENTRY _ZTV8S3052C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C23[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12464_N7S3052C4D0Ev,_ZThn9196_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12464_N7S3052C4D1Ev,_ZThn9196_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12432_N7S3052C4D0Ev,_ZThn9172_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12432_N7S3052C4D1Ev,_ZThn9172_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10896_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10896_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D0Ev,_ZTv0_n20_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S3052C21D0Ev,_ZThn1480_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C21D1Ev,_ZTv0_n20_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S3052C21D1Ev,_ZThn1480_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D0Ev,_ZTv0_n16_N8S3052C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D0Ev,_ZThn1420_N8S3052C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C21D1Ev,_ZTv0_n16_N8S3052C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C21D1Ev,_ZThn1420_N8S3052C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D0Ev,_ZThn1420_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S3052C15D1Ev,_ZThn1420_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D0Ev,_ZThn228_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C5D1Ev,_ZThn228_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D0Ev,_ZThn228_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C7D1Ev,_ZThn228_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D0Ev,_ZThn228_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N7S3052C8D1Ev,_ZThn228_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C24D0Ev,_ZTv0_n12_N8S3052C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C24D0Ev,_ZThn256_N8S3052C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C24D1Ev,_ZTv0_n12_N8S3052C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S3052C24D1Ev,_ZThn256_N8S3052C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C24D0Ev,_ZTv0_n16_N8S3052C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S3052C24D0Ev,_ZThn28_N8S3052C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C24D1Ev,_ZTv0_n16_N8S3052C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S3052C24D1Ev,_ZThn28_N8S3052C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S3052C23D0Ev,_ZTv0_n32_N8S3052C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn33584_N8S3052C23D0Ev,_ZThn24884_N8S3052C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S3052C23D1Ev,_ZTv0_n32_N8S3052C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn33584_N8S3052C23D1Ev,_ZThn24884_N8S3052C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3052C23D0Ev,_ZTv0_n24_N8S3052C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21472_N8S3052C23D0Ev,_ZThn15916_N8S3052C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S3052C23D1Ev,_ZTv0_n24_N8S3052C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21472_N8S3052C23D1Ev,_ZThn15916_N8S3052C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C23D0Ev,_ZTv0_n12_N8S3052C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn46048_N8S3052C23D0Ev,_ZThn34080_N8S3052C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21368_N8S3052C23D0Ev,_ZThn15832_N8S3052C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C23D1Ev,_ZTv0_n12_N8S3052C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn46048_N8S3052C23D1Ev,_ZThn34080_N8S3052C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21368_N8S3052C23D1Ev,_ZThn15832_N8S3052C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C23D0Ev,_ZTv0_n16_N8S3052C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn46016_N8S3052C23D0Ev,_ZThn34056_N8S3052C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23376_N8S3052C23D0Ev,_ZThn17336_N8S3052C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21056_N8S3052C23D0Ev,_ZThn15604_N8S3052C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C23D1Ev,_ZTv0_n16_N8S3052C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn46016_N8S3052C23D1Ev,_ZThn34056_N8S3052C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23376_N8S3052C23D1Ev,_ZThn17336_N8S3052C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21056_N8S3052C23D1Ev,_ZThn15604_N8S3052C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C23D0Ev,_ZTv0_n20_N8S3052C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44480_N8S3052C23D0Ev,_ZThn32928_N8S3052C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23488_N8S3052C23D0Ev,_ZThn17396_N8S3052C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21000_N8S3052C23D0Ev,_ZThn15576_N8S3052C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S3052C23D1Ev,_ZTv0_n20_N8S3052C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn44480_N8S3052C23D1Ev,_ZThn32928_N8S3052C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23488_N8S3052C23D1Ev,_ZThn17396_N8S3052C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21000_N8S3052C23D1Ev,_ZThn15576_N8S3052C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C23 = {  "S3052C23", // class name
  bases_S3052C23, 29,
  &(vtc_S3052C23[0]), // expected_vtbl_contents
  &(vtt_S3052C23[0]), // expected_vtt_contents
  ABISELECT(46256,34228), // object size
  NSPAIRA(_ZTI8S3052C23),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S3052C23),127, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C23),71, //virtual table table var
  27, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C19  {
  ::S3052C20 s3052c19f0;
  ::S3052C21 s3052c19f1[4];
  char s3052c19f2[10];
  int s3052c19f3;
  void *s3052c19f4;
  int s3052c19f5;
  int s3052c19f6[10];
  void *s3052c19f7;
  int s3052c19f8;
  int s3052c19f9:22;
  void *s3052c19f10;
  void *s3052c19f11;
  ::S3052C23 s3052c19f12[10];
  void  mf3052c19(); // _ZN8S3052C199mf3052c19Ev
};
//SIG(-1 S3052C19) C1{ m FC2{ VBC3{ vd v1 Fs[6] FL[8] Fi} VBC4{ VBC5{ VBC3 BC6{ VBC3 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} VBC7{ BC8{ m Fp Fi FL Fp Fi} VBC5 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC9{ VBC3 BC5 BC10{ VBC3 BC5 Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} BC11{ vd m FC5} VBC6 Fp Fl FC10 FC11 FC6 Fi[2] FU12{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC13{ BC11 VBC3 VBC5 v4 FC5[2] FD FC11 Fp[3] FC10 Fi FU14{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v5 Fp FC15{} FC3 FL FU12 FL[6] FL FC10} BC16{ BC13 VBC6 BC3 BC17{ VBC3 BC10 VBC6 VBC5 vd Fp Fp[5] Fp} v6 FC3[9] Fc Fi Fi Fi Fc} vd FC9 FU12 Fi Fc} FC4[4] Fc[10] Fi Fp Fi Fi[10] Fp Fi Fi:22 Fp Fp FC18{ VBC19{ VBC10 Fp[6]} VBC4 VBC20{ BC10 VBC5 BC7 VBC9 VBC11 vd FC11[2] Fi FD FD Fc:0 Fp} BC21{ v8 Fi:0 Fi[7] Fp} BC3 v7 Fi Fp Fi FC7[2] FC6 FD Fi[3] FU12 FL Fi[2] Fi FU12 Fp}[10]}


void  S3052C19 ::mf3052c19(){}

static void Test_S3052C19()
{
  {
    init_simple_test("S3052C19");
    static S3052C19 lv;
    check2(sizeof(lv), ABISELECT(528096,390960), "sizeof(S3052C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C19)");
    check_field_offset(lv, s3052c19f0, 0, "S3052C19.s3052c19f0");
    check_field_offset(lv, s3052c19f1, ABISELECT(16592,12388), "S3052C19.s3052c19f1");
    check_field_offset(lv, s3052c19f2, ABISELECT(65424,48596), "S3052C19.s3052c19f2");
    check_field_offset(lv, s3052c19f3, ABISELECT(65436,48608), "S3052C19.s3052c19f3");
    check_field_offset(lv, s3052c19f4, ABISELECT(65440,48612), "S3052C19.s3052c19f4");
    check_field_offset(lv, s3052c19f5, ABISELECT(65448,48616), "S3052C19.s3052c19f5");
    check_field_offset(lv, s3052c19f6, ABISELECT(65452,48620), "S3052C19.s3052c19f6");
    check_field_offset(lv, s3052c19f7, ABISELECT(65496,48660), "S3052C19.s3052c19f7");
    check_field_offset(lv, s3052c19f8, ABISELECT(65504,48664), "S3052C19.s3052c19f8");
    set_bf_and_test(lv, s3052c19f9, ABISELECT(65508,48668), 0, 22, 1, "S3052C19");
    set_bf_and_test(lv, s3052c19f9, ABISELECT(65508,48668), 0, 22, hide_sll(1LL<<21), "S3052C19");
    check_field_offset(lv, s3052c19f10, ABISELECT(65512,48672), "S3052C19.s3052c19f10");
    check_field_offset(lv, s3052c19f11, ABISELECT(65520,48676), "S3052C19.s3052c19f11");
    check_field_offset(lv, s3052c19f12, ABISELECT(65536,48680), "S3052C19.s3052c19f12");
  }
}
static Arrange_To_Call_Me vS3052C19(Test_S3052C19, "S3052C19", ABISELECT(528096,390960));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S3052C19[];
VTBL_ENTRY *P__ZTI8S3052C19 = _ZTI8S3052C19; 
Class_Descriptor cd_S3052C19 = {  "S3052C19", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(528096,390960), // object size
  NSPAIRA(_ZTI8S3052C19),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C25  : S3052C7 , S3052C15 , S3052C19 , S3052C8 {
  ::S3052C13 s3052c25f0;
  int s3052c25f1;
  void *s3052c25f2;
  char s3052c25f3[7];
  void *s3052c25f4;
  int s3052c25f5;
  ::S3052C22_nt s3052c25f6;
  int s3052c25f7;
  long double s3052c25f8;
  virtual void  v11(); // _ZN8S3052C253v11Ev
  ~S3052C25(); // tgen
  S3052C25(); // tgen
};
//SIG(-1 S3052C25) C1{ BC2{ VBC3{ vd v2 Fs[6] FL[8] Fi} BC4{ VBC3 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} BC5{ BC6{ vd m FC2} VBC3 VBC2 v5 FC2[2] FD FC6 Fp[3] FC7{ VBC3 BC2 Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} Fi FU8{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} BC9{ m FC10{ VBC3 VBC11{ VBC2 VBC12{ BC13{ m Fp Fi FL Fp Fi} VBC2 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC14{ VBC3 BC2 BC7 BC6 VBC4 Fp Fl FC7 FC6 FC4 Fi[2] FU15{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC5 v6 Fp FC16{} FC3 FL FU15 FL[6] FL FC7} BC17{ BC5 VBC4 BC3 BC18{ VBC3 BC7 VBC4 VBC2 vd Fp Fp[5] Fp} v7 FC3[9] Fc Fi Fi Fi Fc} vd FC14 FU15 Fi Fc} FC11[4] Fc[10] Fi Fp Fi Fi[10] Fp Fi Fi:22 Fp Fp FC19{ VBC20{ VBC7 Fp[6]} VBC11 VBC21{ BC7 VBC2 BC12 VBC14 VBC6 vd FC6[2] Fi FD FD Fc:0 Fp} BC22{ v9 Fi:0 Fi[7] Fp} BC3 v8 Fi Fp Fi FC12[2] FC4 FD Fi[3] FU15 FL Fi[2] Fi FU15 Fp}[10]} BC4 v1 FU15 Fi Fp Fc[7] Fp Fi FC16 Fi FD}


void  S3052C25 ::v11(){vfunc_called(this, "_ZN8S3052C253v11Ev");}
S3052C25 ::~S3052C25(){ note_dtor("S3052C25", this);} // tgen
S3052C25 ::S3052C25(){ note_ctor("S3052C25", this);} // tgen

static void Test_S3052C25()
{
  extern Class_Descriptor cd_S3052C25;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33115,98047)];
    init_test(&cd_S3052C25, buf);
    S3052C25 *dp, &lv = *(dp=new (buf) S3052C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(529824,392184), "sizeof(S3052C25)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C25)");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(529616,392040), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(529616,392040), "S3052C25");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*), ABISELECT(529616,392040), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(529616,392040), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(529616,392040), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(529616,392040), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), 0, "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*), 0, "S3052C25");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*), ABISELECT(112,60), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(529712,392124), "S3052C25");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*), ABISELECT(529712,392124), "S3052C25");
    check_base_class_offset(lv, (S3052C15*), ABISELECT(112,60), "S3052C25");
    check_base_class_offset(lv, (S3052C19*), ABISELECT(1408,1000), "S3052C25");
    /*is_ambiguous_... S3052C25::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*), ABISELECT(529504,391960), "S3052C25");
    check_field_offset(lv, s3052c25f0, ABISELECT(529536,391984), "S3052C25.s3052c25f0");
    check_field_offset(lv, s3052c25f1, ABISELECT(529552,391996), "S3052C25.s3052c25f1");
    check_field_offset(lv, s3052c25f2, ABISELECT(529560,392000), "S3052C25.s3052c25f2");
    check_field_offset(lv, s3052c25f3, ABISELECT(529568,392004), "S3052C25.s3052c25f3");
    check_field_offset(lv, s3052c25f4, ABISELECT(529576,392012), "S3052C25.s3052c25f4");
    check_field_offset(lv, s3052c25f5, ABISELECT(529584,392016), "S3052C25.s3052c25f5");
    check_field_offset(lv, s3052c25f6, ABISELECT(529588,392020), "S3052C25.s3052c25f6");
    check_field_offset(lv, s3052c25f7, ABISELECT(529592,392024), "S3052C25.s3052c25f7");
    check_field_offset(lv, s3052c25f8, ABISELECT(529600,392028), "S3052C25.s3052c25f8");
    test_class_info(&lv, &cd_S3052C25);
    dp->~S3052C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C25(Test_S3052C25, "S3052C25", ABISELECT(529824,392184));

#else // __cplusplus

extern void _ZN8S3052C25C1Ev();
extern void _ZN8S3052C25D1Ev();
Name_Map name_map_S3052C25[] = {
  NSPAIR(_ZN8S3052C25C1Ev),
  NSPAIR(_ZN8S3052C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C19;
extern VTBL_ENTRY _ZTI8S3052C19[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
static Base_Class bases_S3052C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C6,    ABISELECT(529616,392040), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S3052C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3052C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C12,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(529712,392124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(529712,392124), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S3052C15,    ABISELECT(112,60), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C19,    ABISELECT(1408,1000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C8,    ABISELECT(529504,391960), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S3052C25[];
extern void _ZN8S3052C25D1Ev();
extern void _ZN8S3052C25D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void _ZN8S3052C253v11Ev();
extern void ABISELECT(_ZThn112_N8S3052C25D1Ev,_ZThn60_N8S3052C25D1Ev)();
extern void ABISELECT(_ZThn112_N8S3052C25D0Ev,_ZThn60_N8S3052C25D0Ev)();
extern void _ZN8S3052C152v6Ev();
extern void ABISELECT(_ZThn529504_N8S3052C25D1Ev,_ZThn391960_N8S3052C25D1Ev)();
extern void ABISELECT(_ZThn529504_N8S3052C25D0Ev,_ZThn391960_N8S3052C25D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C25D1Ev,_ZTv0_n12_N8S3052C25D1Ev)();
extern void ABISELECT(_ZThn529616_N8S3052C25D1Ev,_ZThn392040_N8S3052C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C25D0Ev,_ZTv0_n12_N8S3052C25D0Ev)();
extern void ABISELECT(_ZThn529616_N8S3052C25D0Ev,_ZThn392040_N8S3052C25D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S3052C25D1Ev,_ZTv0_n16_N8S3052C25D1Ev)();
extern void ABISELECT(_ZThn529712_N8S3052C25D1Ev,_ZThn392124_N8S3052C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C25D0Ev,_ZTv0_n16_N8S3052C25D0Ev)();
extern void ABISELECT(_ZThn529712_N8S3052C25D0Ev,_ZThn392124_N8S3052C25D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY vtc_S3052C25[] = {
  ABISELECT(529712,392124),
  ABISELECT(529616,392040),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C25[0]),
  (VTBL_ENTRY)&_ZN8S3052C25D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C25D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  (VTBL_ENTRY)&_ZN8S3052C253v11Ev,
  ABISELECT(529600,392064),
  ABISELECT(529504,391980),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S3052C25D1Ev,_ZThn60_N8S3052C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N8S3052C25D0Ev,_ZThn60_N8S3052C25D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  ABISELECT(112,80),
  ABISELECT(-529504,-391960),
  (VTBL_ENTRY)&(_ZTI8S3052C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn529504_N8S3052C25D1Ev,_ZThn391960_N8S3052C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn529504_N8S3052C25D0Ev,_ZThn391960_N8S3052C25D0Ev),
  0,
  ABISELECT(-529616,-392040),
  ABISELECT(-529616,-392040),
  (VTBL_ENTRY)&(_ZTI8S3052C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C25D1Ev,_ZTv0_n12_N8S3052C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C25D0Ev,_ZTv0_n12_N8S3052C25D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-529712,-392124),
  ABISELECT(-96,-84),
  ABISELECT(-529712,-392124),
  (VTBL_ENTRY)&(_ZTI8S3052C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C25D1Ev,_ZTv0_n16_N8S3052C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C25D0Ev,_ZTv0_n16_N8S3052C25D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern VTBL_ENTRY _ZTV8S3052C25[];
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A__8S3052C25[] = {
  ABISELECT(529616,392040),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__8S3052C25[] = {
  ABISELECT(529616,392040),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn529616_N7S3052C8D1Ev,_ZThn392040_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn529616_N7S3052C8D0Ev,_ZThn392040_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C25[] = {
  0,
  ABISELECT(-529616,-392040),
  ABISELECT(-529616,-392040),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn529616_N7S3052C7D1Ev,_ZThn392040_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn529616_N7S3052C7D0Ev,_ZThn392040_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A__8S3052C25[] = {
  0,
  ABISELECT(-529616,-392040),
  ABISELECT(-529616,-392040),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C15__8S3052C25[] = {
  ABISELECT(529600,392064),
  ABISELECT(529504,391980),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn529504_N8S3052C15D1Ev,_ZThn391980_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn529504_N8S3052C15D0Ev,_ZThn391980_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C15__8S3052C25[] = {
  0,
  ABISELECT(-529504,-391980),
  ABISELECT(-529504,-391980),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn529600_N8S3052C15D1Ev,_ZThn392064_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn529600_N8S3052C15D0Ev,_ZThn392064_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C15__8S3052C25[] = {
  0,
  0,
  ABISELECT(-529600,-392064),
  ABISELECT(-96,-84),
  ABISELECT(-529600,-392064),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C25[] = {
  ABISELECT(112,80),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn112_N7S3052C8D1Ev,_ZThn80_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn112_N7S3052C8D0Ev,_ZThn80_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A2__8S3052C25[] = {
  0,
  ABISELECT(-112,-80),
  ABISELECT(-112,-80),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C25[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A1__8S3052C25[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A1__8S3052C25[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__8S3052C25[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C25[] = {
  {&(_ZTV8S3052C25[4]),  4,38},
  {&(_tg__ZTV7S3052C7__A__8S3052C25[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__8S3052C25[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__8S3052C25[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A__8S3052C25[4]),  4,7},
  {&(_tg__ZTV8S3052C15__8S3052C25[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C15__8S3052C25[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C15__8S3052C25[6]),  6,10},
  {&(_tg__ZTV7S3052C8__A2__8S3052C25[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A2__8S3052C25[4]),  4,7},
  {&(_ZTV8S3052C25[25]),  25,38},
  {&(_ZTV8S3052C25[13]),  13,38},
  {&(_ZTV8S3052C25[34]),  34,38},
  {&(_ZTV8S3052C25[19]),  19,38},
  {&(_tg__ZTV7S3052C7__A1__8S3052C25[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A1__8S3052C25[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A1__8S3052C25[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__8S3052C25[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S3052C25[];
extern  VTBL_ENTRY _ZTV8S3052C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C25[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529600_N8S3052C15D0Ev,_ZThn392064_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529600_N8S3052C15D1Ev,_ZThn392064_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529504_N8S3052C15D0Ev,_ZThn391980_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529504_N8S3052C15D1Ev,_ZThn391980_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N7S3052C7D0Ev,_ZThn392040_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N7S3052C7D1Ev,_ZThn392040_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S3052C8D0Ev,_ZThn80_N7S3052C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N7S3052C8D0Ev,_ZThn392040_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S3052C8D1Ev,_ZThn80_N7S3052C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N7S3052C8D1Ev,_ZThn392040_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C25D0Ev,_ZTv0_n16_N8S3052C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529712_N8S3052C25D0Ev,_ZThn392124_N8S3052C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C25D1Ev,_ZTv0_n16_N8S3052C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529712_N8S3052C25D1Ev,_ZThn392124_N8S3052C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C25D0Ev,_ZTv0_n12_N8S3052C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N8S3052C25D0Ev,_ZThn392040_N8S3052C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C25D1Ev,_ZTv0_n12_N8S3052C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn529616_N8S3052C25D1Ev,_ZThn392040_N8S3052C25D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C25 = {  "S3052C25", // class name
  bases_S3052C25, 9,
  &(vtc_S3052C25[0]), // expected_vtbl_contents
  &(vtt_S3052C25[0]), // expected_vtt_contents
  ABISELECT(529824,392184), // object size
  NSPAIRA(_ZTI8S3052C25),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S3052C25),38, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S3052C25),18, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C2  : S3052C3 , virtual S3052C4 , S3052C14 , virtual S3052C10 {
  ::S3052C18 s3052c2f0;
  ::S3052C13 s3052c2f1;
  ::S3052C19 s3052c2f2;
  ::S3052C25 s3052c2f3;
  int s3052c2f4;
  char s3052c2f5;
  int s3052c2f6;
  virtual void  v8(); // _ZN7S3052C22v8Ev
  ~S3052C2(); // tgen
  S3052C2(); // tgen
};
//SIG(-1 S3052C2) C1{ BC2{ v2 Fi:0 Fi[7] Fp} VBC3{ BC4{ VBC5{ vd v3 Fs[6] FL[8] Fi} BC6{ VBC5 BC7{ VBC5 FL Fp FL:54} v4 v5 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC5 Fp[3] FL[5] Fi} VBC6 BC8{ BC9{ m Fp Fi FL Fp Fi} VBC6 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC10{ VBC5 BC6 BC4 BC11{ vd m FC6} VBC7 Fp Fl FC4 FC11 FC7 Fi[2] FU12{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} VBC10 VBC11 vd FC11[2] Fi FD FD Fc:0 Fp} BC13{ BC14{ BC11 VBC5 VBC6 v6 FC6[2] FD FC11 Fp[3] FC4 Fi FU15{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} VBC7 BC5 BC16{ VBC5 BC4 VBC7 VBC6 vd Fp Fp[5] Fp} v7 FC5[9] Fc Fi Fi Fi Fc} VBC9 v1 FU17{ m Fs Fp[9] Fc Fi[5] FL Fp Fp Fi FD Fi[4] Fi:32 Fi FD} FU12 FC18{ m FC19{ VBC5 VBC20{ VBC6 VBC8 BC14 v8 Fp FC21{} FC5 FL FU12 FL[6] FL FC4} BC13 vd FC10 FU12 Fi Fc} FC20[4] Fc[10] Fi Fp Fi Fi[10] Fp Fi Fi:22 Fp Fp FC22{ VBC23{ VBC4 Fp[6]} VBC20 VBC3 BC2 BC5 v9 Fi Fp Fi FC8[2] FC7 FD Fi[3] FU12 FL Fi[2] Fi FU12 Fp}[10]} FC24{ BC6 BC14 BC18 BC7 v10 FU12 Fi Fp Fc[7] Fp Fi FC21 Fi FD} Fi Fc Fi}


void  S3052C2 ::v8(){vfunc_called(this, "_ZN7S3052C22v8Ev");}
S3052C2 ::~S3052C2(){ note_dtor("S3052C2", this);} // tgen
S3052C2 ::S3052C2(){ note_ctor("S3052C2", this);} // tgen

static void Test_S3052C2()
{
  extern Class_Descriptor cd_S3052C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(67104,198703)];
    init_test(&cd_S3052C2, buf);
    S3052C2 *dp, &lv = *(dp=new (buf) S3052C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1073648,794808), "sizeof(S3052C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C2)");
    check_base_class_offset(lv, (S3052C3*), 0, "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C4*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C2::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C2::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C2::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*)(S3052C14*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C17*)(S3052C14*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1071624,793340), "S3052C2");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1071624,793340), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1060736,785296), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1060736,785296), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C5*)(S3052C4*), ABISELECT(1060736,785296), "S3052C2");
    /*is_ambiguous_... S3052C2::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(1071720,793424), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C4*), ABISELECT(1071720,793424), "S3052C2");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*)(S3052C4*), ABISELECT(1071720,793424), "S3052C2");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*)(S3052C14*), ABISELECT(1071720,793424), "S3052C2");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C17*)(S3052C14*), ABISELECT(1071720,793424), "S3052C2");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*)(S3052C4*), ABISELECT(1061064,785528), "S3052C2");
    check_base_class_offset(lv, (S3052C9*)(S3052C4*), ABISELECT(1061056,785524), "S3052C2");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(1071824,793484), "S3052C2");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C11*), ABISELECT(1071824,793484), "S3052C2");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071928,793544), "S3052C2");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071928,793544), "S3052C2");
    check_base_class_offset(lv, (S3052C5*)(S3052C11*), ABISELECT(1071928,793544), "S3052C2");
    check_base_class_offset(lv, (S3052C12*)(S3052C11*), ABISELECT(1072240,793772), "S3052C2");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C11*), ABISELECT(1073360,794612), "S3052C2");
    /*is_ambiguous_... S3052C14::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C14*), ABISELECT(1073360,794612), "S3052C2");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C17*)(S3052C14*), ABISELECT(1073360,794612), "S3052C2");
    check_base_class_offset(lv, (S3052C11*)(S3052C4*), ABISELECT(1071824,793484), "S3052C2");
    /*is_ambiguous_... S3052C4::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*)(S3052C4*), ABISELECT(1073392,794636), "S3052C2");
    check_base_class_offset(lv, (S3052C4*), ABISELECT(1060736,785296), "S3052C2");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*)(S3052C14*), ABISELECT(48,36), "S3052C2");
    check_base_class_offset(lv, (S3052C15*)(S3052C14*), ABISELECT(48,36), "S3052C2");
    /*is_ambiguous_... S3052C14::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C14*), ABISELECT(1344,976), "S3052C2");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1440,1060), "S3052C2");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1440,1060), "S3052C2");
    check_base_class_offset(lv, (S3052C5*)(S3052C17*)(S3052C14*), ABISELECT(1440,1060), "S3052C2");
    check_base_class_offset(lv, (S3052C17*)(S3052C14*), ABISELECT(1440,1060), "S3052C2");
    check_base_class_offset(lv, (S3052C14*), ABISELECT(48,36), "S3052C2");
    /*is_ambiguous_... S3052C2::S3052C10 */ AMB_check_base_class_offset(lv, (S3052C10*), ABISELECT(1073600,794784), "S3052C2");
    check_field_offset(lv, s3052c2f0, ABISELECT(2704,2092), "S3052C2.s3052c2f0");
    check_field_offset(lv, s3052c2f1, ABISELECT(2784,2128), "S3052C2.s3052c2f1");
    check_field_offset(lv, s3052c2f2, ABISELECT(2800,2140), "S3052C2.s3052c2f2");
    check_field_offset(lv, s3052c2f3, ABISELECT(530896,393100), "S3052C2.s3052c2f3");
    check_field_offset(lv, s3052c2f4, ABISELECT(1060720,785284), "S3052C2.s3052c2f4");
    check_field_offset(lv, s3052c2f5, ABISELECT(1060724,785288), "S3052C2.s3052c2f5");
    check_field_offset(lv, s3052c2f6, ABISELECT(1060728,785292), "S3052C2.s3052c2f6");
    test_class_info(&lv, &cd_S3052C2);
    dp->~S3052C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C2(Test_S3052C2, "S3052C2", ABISELECT(1073648,794808));

#else // __cplusplus

extern void _ZN7S3052C2C1Ev();
extern void _ZN7S3052C2D1Ev();
Name_Map name_map_S3052C2[] = {
  NSPAIR(_ZN7S3052C2C1Ev),
  NSPAIR(_ZN7S3052C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C3;
extern VTBL_ENTRY _ZTI7S3052C3[];
extern  VTBL_ENTRY _ZTV7S3052C3[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C11;
extern VTBL_ENTRY _ZTI8S3052C11[];
extern  VTBL_ENTRY _ZTV8S3052C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C4;
extern VTBL_ENTRY _ZTI7S3052C4[];
extern  VTBL_ENTRY _ZTV7S3052C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C4[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C17;
extern VTBL_ENTRY _ZTI8S3052C17[];
extern  VTBL_ENTRY _ZTV8S3052C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C17[];
extern Class_Descriptor cd_S3052C14;
extern VTBL_ENTRY _ZTI8S3052C14[];
extern  VTBL_ENTRY _ZTV8S3052C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C14[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
static Base_Class bases_S3052C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C6,    ABISELECT(1071624,793340), //bcp->offset
    56, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(1060736,785296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1060736,785296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1060736,785296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1071720,793424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1071720,793424), //bcp->offset
    63, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(1061064,785528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(1061056,785524), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1071824,793484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1071824,793484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1071928,793544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1071928,793544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1071928,793544), //bcp->offset
    84, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(1072240,793772), //bcp->offset
    91, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1073360,794612), //bcp->offset
    95, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S3052C11,    ABISELECT(1071824,793484), //bcp->offset
    73, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(1073392,794636), //bcp->offset
    101, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S3052C4,    ABISELECT(1060736,785296), //bcp->offset
    36, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3052C15,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C6,    ABISELECT(1344,976), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3052C17,    ABISELECT(1440,1060), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C14,    ABISELECT(48,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C10,    ABISELECT(1073600,794784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C2[];
extern void _ZN7S3052C32v2Ev();
extern void _ZN7S3052C22v8Ev();
extern void _ZN7S3052C2D1Ev();
extern void _ZN7S3052C2D0Ev();
extern void ABISELECT(_ZThn48_N7S3052C2D1Ev,_ZThn36_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S3052C2D0Ev,_ZThn36_N7S3052C2D0Ev)();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
extern void ABISELECT(_ZThn1344_N7S3052C2D1Ev,_ZThn976_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1344_N7S3052C2D0Ev,_ZThn976_N7S3052C2D0Ev)();
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZThn1440_N7S3052C2D1Ev,_ZThn1060_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1440_N7S3052C2D0Ev,_ZThn1060_N7S3052C2D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1060736_N7S3052C2D1Ev,_ZThn785296_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1060736_N7S3052C2D0Ev,_ZThn785296_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn320_n64_N7S3052C2D1Ev,_ZTvn228_n32_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn320_n64_N7S3052C2D0Ev,_ZTvn228_n32_N7S3052C2D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071624_N7S3052C2D1Ev,_ZThn793340_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071624_N7S3052C2D0Ev,_ZThn793340_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071720_N7S3052C2D1Ev,_ZThn793424_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071720_N7S3052C2D0Ev,_ZThn793424_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071824_N7S3052C2D1Ev,_ZThn793484_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071824_N7S3052C2D0Ev,_ZThn793484_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn104_n40_N7S3052C2D1Ev,_ZTvn60_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C2D0Ev,_ZTvn60_n20_N7S3052C2D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn416_n40_N7S3052C2D1Ev,_ZTvn288_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C2D0Ev,_ZTvn288_n20_N7S3052C2D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1073360_N7S3052C2D1Ev,_ZThn794612_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1073360_N7S3052C2D0Ev,_ZThn794612_N7S3052C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1073392_N7S3052C2D1Ev,_ZThn794636_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1073392_N7S3052C2D0Ev,_ZThn794636_N7S3052C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S3052C2[] = {
  ABISELECT(1073600,794784),
  ABISELECT(1073392,794636),
  ABISELECT(1073360,794612),
  ABISELECT(1071824,793484),
  ABISELECT(1071720,793424),
  ABISELECT(1071624,793340),
  ABISELECT(1060736,785296),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
  (VTBL_ENTRY)&_ZN7S3052C22v8Ev,
  (VTBL_ENTRY)&_ZN7S3052C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C2D0Ev,
  ABISELECT(1073312,794576),
  ABISELECT(1071672,793388),
  ABISELECT(1071576,793304),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C2D1Ev,_ZThn36_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C2D0Ev,_ZThn36_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
  ABISELECT(-1344,-976),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1344_N7S3052C2D1Ev,_ZThn976_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1344_N7S3052C2D0Ev,_ZThn976_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(1070280,792364),
  ABISELECT(1071920,793552),
  ABISELECT(1070184,792280),
  ABISELECT(-1440,-1060),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C2D1Ev,_ZThn1060_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C2D0Ev,_ZThn1060_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  0,
  ABISELECT(-1060736,-785296),
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  ABISELECT(-1060736,-785296),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-1061056,-785524),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C2D1Ev,_ZTvn228_n32_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C2D0Ev,_ZTvn228_n32_N7S3052C2D0Ev),
  0,
  ABISELECT(-1071624,-793340),
  ABISELECT(-1071624,-793340),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-1071720,-793424),
  ABISELECT(-96,-84),
  ABISELECT(-1071720,-793424),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  0,
  ABISELECT(-1071824,-793484),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-1071824,-793484),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-304,-204),
  ABISELECT(-1071928,-793544),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C2D1Ev,_ZTvn60_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C2D0Ev,_ZTvn60_n20_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-1072240,-793772),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C2D1Ev,_ZTvn288_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C2D0Ev,_ZTvn288_n20_N7S3052C2D0Ev),
  ABISELECT(-1073360,-794612),
  ABISELECT(-1736,-1272),
  ABISELECT(-1073360,-794612),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev),
  ABISELECT(-1073392,-794636),
  ABISELECT(-1073392,-794636),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev),
};
extern VTBL_ENTRY _ZTV7S3052C2[];
extern void _ZN8S3052C14D1Ev();
extern void _ZN8S3052C14D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C14__7S3052C2[] = {
  ABISELECT(1073312,794576),
  ABISELECT(1071672,793388),
  ABISELECT(1071576,793304),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&_ZN8S3052C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C14D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C158S3052C14__7S3052C2[] = {
  ABISELECT(1071672,793388),
  ABISELECT(1071576,793304),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1071576_N8S3052C15D1Ev,_ZThn793304_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1071576_N8S3052C15D0Ev,_ZThn793304_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C158S3052C14__7S3052C2[] = {
  0,
  ABISELECT(-1071576,-793304),
  ABISELECT(-1071576,-793304),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1071672_N8S3052C15D1Ev,_ZThn793388_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1071672_N8S3052C15D0Ev,_ZThn793388_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C158S3052C14__7S3052C2[] = {
  0,
  0,
  ABISELECT(-1071672,-793388),
  ABISELECT(-96,-84),
  ABISELECT(-1071672,-793388),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN8S3052C17D1Ev();
extern void _ZN8S3052C17D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C178S3052C14__7S3052C2[] = {
  ABISELECT(1070280,792364),
  ABISELECT(1071920,793552),
  ABISELECT(1070184,792280),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&_ZN8S3052C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C17D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C178S3052C14__A2__7S3052C2[] = {
  ABISELECT(1070184,792280),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C178S3052C14__A4__7S3052C2[] = {
  ABISELECT(1070184,792280),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C14__A5__7S3052C2[] = {
  ABISELECT(1070184,792280),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C8D1Ev,_ZThn792280_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C8D0Ev,_ZThn792280_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C14__A5__7S3052C2[] = {
  0,
  ABISELECT(-1070184,-792280),
  ABISELECT(-1070184,-792280),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C7D1Ev,_ZThn792280_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C7D0Ev,_ZThn792280_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C14__A4__7S3052C2[] = {
  0,
  ABISELECT(-1070184,-792280),
  ABISELECT(-1070184,-792280),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C5D1Ev,_ZThn792280_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn1070184_N7S3052C5D0Ev,_ZThn792280_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C178S3052C14__A2__7S3052C2[] = {
  0,
  ABISELECT(-1070184,-792280),
  ABISELECT(-1070184,-792280),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1070184_N8S3052C17D1Ev,_ZThn792280_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1070184_N8S3052C17D0Ev,_ZThn792280_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C178S3052C14__7S3052C2[] = {
  0,
  ABISELECT(-1070184,-792280),
  ABISELECT(-1070184,-792280),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1071920_N8S3052C17D1Ev,_ZThn793552_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1071920_N8S3052C17D0Ev,_ZThn793552_N8S3052C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C178S3052C14__7S3052C2[] = {
  ABISELECT(-1071920,-793552),
  ABISELECT(-1736,-1272),
  ABISELECT(-1071920,-793552),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1070280_N8S3052C17D1Ev,_ZThn792364_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1070280_N8S3052C17D0Ev,_ZThn792364_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C178S3052C14__7S3052C2[] = {
  0,
  0,
  ABISELECT(-1070280,-792364),
  ABISELECT(-96,-84),
  ABISELECT(-1070280,-792364),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1071576_N8S3052C14D1Ev,_ZThn793304_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1071576_N8S3052C14D0Ev,_ZThn793304_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C14__7S3052C2[] = {
  0,
  ABISELECT(-1071576,-793304),
  ABISELECT(-1071576,-793304),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1071672_N8S3052C14D1Ev,_ZThn793388_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1071672_N8S3052C14D0Ev,_ZThn793388_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C14__7S3052C2[] = {
  0,
  0,
  ABISELECT(-1071672,-793388),
  ABISELECT(-96,-84),
  ABISELECT(-1071672,-793388),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1073312_N8S3052C14D1Ev,_ZThn794576_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1073312_N8S3052C14D0Ev,_ZThn794576_N8S3052C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C14__7S3052C2[] = {
  ABISELECT(-1073312,-794576),
  ABISELECT(-1736,-1272),
  ABISELECT(-1073312,-794576),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
};
extern void ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C17__8S3052C14__7S3052C2[] = {
  ABISELECT(1070280,792364),
  ABISELECT(1071920,793552),
  ABISELECT(1070184,792280),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C4D1Ev();
extern void _ZN7S3052C4D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C4__7S3052C2[] = {
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&_ZN7S3052C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C57S3052C4__7S3052C2[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C57S3052C4__7S3052C2[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C57S3052C4__7S3052C2[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__7S3052C2[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__7S3052C2[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C57S3052C4__7S3052C2[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C97S3052C4__7S3052C2[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C97S3052C4__7S3052C2[] = {
  0,
  0,
  ABISELECT(-10664,-7900),
  ABISELECT(-96,-84),
  ABISELECT(-10664,-7900),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C97S3052C4__7S3052C2[] = {
  0,
  ABISELECT(-10568,-7816),
  ABISELECT(-10568,-7816),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C4__7S3052C2[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C4__7S3052C2[] = {
  0,
  0,
  ABISELECT(-10984,-8128),
  ABISELECT(-96,-84),
  ABISELECT(-10984,-8128),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3052C9__7S3052C4__7S3052C2[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C4__7S3052C2[] = {
  0,
  0,
  ABISELECT(-11088,-8188),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-11088,-8188),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C4__7S3052C2[] = {
  ABISELECT(-304,-204),
  ABISELECT(-11192,-8248),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S3052C128S3052C11__7S3052C4__7S3052C2[] = {
  ABISELECT(-11504,-8476),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C4__7S3052C2[] = {
  ABISELECT(-12624,-9316),
  ABISELECT(-1736,-1272),
  ABISELECT(-12624,-9316),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3052C12__A1__7S3052C4__7S3052C2[] = {
  ABISELECT(-12656,-9340),
  ABISELECT(-12656,-9340),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C2[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A1__7S3052C2[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C2[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__7S3052C2[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C11D1Ev();
extern void _ZN8S3052C11D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C2[] = {
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&_ZN8S3052C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C11D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C78S3052C11__A2__7S3052C2[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C2[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C2[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C2[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C2[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C2[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C2[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C2[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C2[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C2[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C11__7S3052C2[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C11__7S3052C2[] = {
  ABISELECT(-304,-204),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C11__7S3052C2[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-1736,-1272),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev),
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C2[] = {
  ABISELECT(-1736,-1272),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A4__7S3052C2[] = {
  0,
  ABISELECT(1736,1272),
  ABISELECT(1736,1272),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
static  VTT_ENTRY vtt_S3052C2[] = {
  {&(_ZTV7S3052C2[9]),  9,106},
  {&(_tg__ZTV8S3052C14__7S3052C2[5]),  5,9},
  {&(_tg__ZTV8S3052C158S3052C14__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C158S3052C14__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C158S3052C14__7S3052C2[6]),  6,10},
  {&(_tg__ZTV8S3052C178S3052C14__7S3052C2[5]),  5,9},
  {&(_tg__ZTV7S3052C58S3052C178S3052C14__A2__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C178S3052C14__A4__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C14__A5__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C14__A5__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C14__A4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C178S3052C14__A2__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C178S3052C14__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C178S3052C14__7S3052C2[4]),  4,6},
  {&(_tg__ZTV7S3052C7__A1__8S3052C178S3052C14__7S3052C2[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C14__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C14__7S3052C2[6]),  6,10},
  {&(_tg__ZTV7S3052C8__A1__8S3052C14__7S3052C2[4]),  4,6},
  {&(_tg__ZTV8S3052C17__8S3052C14__7S3052C2[5]),  5,9},
  {&(_ZTV7S3052C2[46]),  46,106},
  {&(_ZTV7S3052C2[60]),  60,106},
  {&(_ZTV7S3052C2[69]),  69,106},
  {&(_ZTV7S3052C2[54]),  54,106},
  {&(_ZTV7S3052C2[80]),  80,106},
  {&(_ZTV7S3052C2[87]),  87,106},
  {&(_ZTV7S3052C2[93]),  93,106},
  {&(_ZTV7S3052C2[99]),  99,106},
  {&(_ZTV7S3052C2[104]),  104,106},
  {&(_ZTV7S3052C2[18]),  18,106},
  {&(_ZTV7S3052C2[32]),  32,106},
  {&(_tg__ZTV7S3052C4__7S3052C2[7]),  7,11},
  {&(_tg__ZTV7S3052C57S3052C4__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C57S3052C4__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C57S3052C4__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C57S3052C4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C97S3052C4__7S3052C2[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C97S3052C4__7S3052C2[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C97S3052C4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C4__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C7__A1__7S3052C4__7S3052C2[6]),  6,10},
  {&(_tg__ZTV7S3052C9__7S3052C4__7S3052C2[4]),  4,6},
  {&(_tg__ZTV8S3052C11__7S3052C4__7S3052C2[7]),  7,11},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C4__7S3052C2[3]),  3,7},
  {&(_tg__ZTV8S3052C128S3052C11__7S3052C4__7S3052C2[2]),  2,4},
  {&(_tg__ZTV7S3052C8__A4__7S3052C4__7S3052C2[4]),  4,6},
  {&(_tg__ZTV8S3052C12__A1__7S3052C4__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C7__A1__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A1__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__7S3052C2[4]),  4,7},
  {&(_tg__ZTV8S3052C11__7S3052C2[4]),  4,8},
  {&(_tg__ZTV7S3052C78S3052C11__A2__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C11__7S3052C2[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C11__7S3052C2[3]),  3,7},
  {&(_tg__ZTV7S3052C8__A2__8S3052C11__7S3052C2[4]),  4,6},
  {&(_tg__ZTV7S3052C8__A4__7S3052C2[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A4__7S3052C2[4]),  4,7},
};
extern VTBL_ENTRY _ZTI7S3052C2[];
extern  VTBL_ENTRY _ZTV7S3052C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C2[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073312_N8S3052C14D0Ev,_ZThn794576_N8S3052C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071672_N8S3052C14D0Ev,_ZThn793388_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073312_N8S3052C14D1Ev,_ZThn794576_N8S3052C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071672_N8S3052C14D1Ev,_ZThn793388_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071576_N8S3052C14D0Ev,_ZThn793304_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071576_N8S3052C14D1Ev,_ZThn793304_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070280_N8S3052C17D0Ev,_ZThn792364_N8S3052C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071920_N8S3052C17D0Ev,_ZThn793552_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070280_N8S3052C17D1Ev,_ZThn792364_N8S3052C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071920_N8S3052C17D1Ev,_ZThn793552_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N8S3052C17D0Ev,_ZThn792280_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N8S3052C17D1Ev,_ZThn792280_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C5D0Ev,_ZThn792280_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C5D1Ev,_ZThn792280_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C7D0Ev,_ZThn792280_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C7D1Ev,_ZThn792280_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C8D0Ev,_ZThn792280_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070184_N7S3052C8D1Ev,_ZThn792280_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071672_N8S3052C15D0Ev,_ZThn793388_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071672_N8S3052C15D1Ev,_ZThn793388_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071576_N8S3052C15D0Ev,_ZThn793304_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071576_N8S3052C15D1Ev,_ZThn793304_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071824_N7S3052C2D0Ev,_ZThn793484_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071824_N7S3052C2D1Ev,_ZThn793484_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073360_N7S3052C2D0Ev,_ZThn794612_N7S3052C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N7S3052C2D0Ev,_ZThn793424_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073360_N7S3052C2D1Ev,_ZThn794612_N7S3052C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N7S3052C2D1Ev,_ZThn793424_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073392_N7S3052C2D0Ev,_ZThn794636_N7S3052C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071624_N7S3052C2D0Ev,_ZThn793340_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073392_N7S3052C2D1Ev,_ZThn794636_N7S3052C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071624_N7S3052C2D1Ev,_ZThn793340_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060736_N7S3052C2D0Ev,_ZThn785296_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060736_N7S3052C2D1Ev,_ZThn785296_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C2 = {  "S3052C2", // class name
  bases_S3052C2, 28,
  &(vtc_S3052C2[0]), // expected_vtbl_contents
  &(vtt_S3052C2[0]), // expected_vtt_contents
  ABISELECT(1073648,794808), // object size
  NSPAIRA(_ZTI7S3052C2),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S3052C2),106, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C2),68, //virtual table table var
  26, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3052C1  : S3052C2 , S3052C10 , S3052C3 , virtual S3052C15 {
  int s3052c1f0;
  long double s3052c1f1;
  int s3052c1f2[6];
  char s3052c1f3[4];
  int s3052c1f4;
  virtual  ~S3052C1(); // _ZN7S3052C1D2Ev
  virtual void  v1(); // _ZN7S3052C12v1Ev
  S3052C1(); // tgen
};
//SIG(1 S3052C1) C1{ BC2{ BC3{ v2 Fi:0 Fi[7] Fp} VBC4{ BC5{ VBC6{ vd v3 Fs[6] FL[8] Fi} BC7{ VBC6 BC8{ VBC6 FL Fp FL:54} v4 v5 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC6 Fp[3] FL[5] Fi} VBC7 BC9{ BC10{ m Fp Fi FL Fp Fi} VBC7 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC11{ VBC6 BC7 BC5 BC12{ vd m FC7} VBC8 Fp Fl FC5 FC12 FC8 Fi[2] FU13{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} VBC11 VBC12 vd FC12[2] Fi FD FD Fc:0 Fp} BC14{ BC15{ BC12 VBC6 VBC7 v6 FC7[2] FD FC12 Fp[3] FC5 Fi FU16{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} VBC8 BC6 BC17{ VBC6 BC5 VBC8 VBC7 vd Fp Fp[5] Fp} v7 FC6[9] Fc Fi Fi Fi Fc} VBC10 v8 FU18{ m Fs Fp[9] Fc Fi[5] FL Fp Fp Fi FD Fi[4] Fi:32 Fi FD} FU13 FC19{ m FC20{ VBC6 VBC21{ VBC7 VBC9 BC15 v9 Fp FC22{} FC6 FL FU13 FL[6] FL FC5} BC14 vd FC11 FU13 Fi Fc} FC21[4] Fc[10] Fi Fp Fi Fi[10] Fp Fi Fi:22 Fp Fp FC23{ VBC24{ VBC5 Fp[6]} VBC21 VBC4 BC3 BC6 v10 Fi Fp Fi FC9[2] FC8 FD Fi[3] FU13 FL Fi[2] Fi FU13 Fp}[10]} FC25{ BC7 BC15 BC19 BC8 v11 FU13 Fi Fp Fc[7] Fp Fi FC22 Fi FD} Fi Fc Fi} BC10 BC3 VBC15 vd v1 Fi FD Fi[6] Fc[4] Fi}


 S3052C1 ::~S3052C1(){ note_dtor("S3052C1", this);}
void  S3052C1 ::v1(){vfunc_called(this, "_ZN7S3052C12v1Ev");}
S3052C1 ::S3052C1(){ note_ctor("S3052C1", this);} // tgen

static void Test_S3052C1()
{
  extern Class_Descriptor cd_S3052C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(67194,198965)];
    init_test(&cd_S3052C1, buf);
    S3052C1 *dp, &lv = *(dp=new (buf) S3052C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1075088,795856), "sizeof(S3052C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S3052C1)");
    check_base_class_offset(lv, (S3052C3*)(S3052C2*), 0, "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C4*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C8*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C15*)(S3052C14*)(S3052C2*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1071768,793448), "S3052C1");
    check_base_class_offset(lv, (S3052C6*)(S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C15 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C15*), ABISELECT(1071768,793448), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1060880,785404), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C4*), ABISELECT(1060880,785404), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C5 */ AMB_check_base_class_offset(lv, (S3052C5*)(S3052C4*), ABISELECT(1060880,785404), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*), ABISELECT(1071864,793532), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C4*), ABISELECT(1071864,793532), "S3052C1");
    check_base_class_offset(lv, (S3052C7*)(S3052C9*)(S3052C4*), ABISELECT(1071864,793532), "S3052C1");
    check_base_class_offset(lv, (S3052C7*)(S3052C15*)(S3052C14*)(S3052C2*), ABISELECT(1071864,793532), "S3052C1");
    /*is_ambiguous_... S3052C17::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1071864,793532), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C15 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C15*), ABISELECT(1071864,793532), "S3052C1");
    check_base_class_offset(lv, (S3052C10*)(S3052C9*)(S3052C4*), ABISELECT(1061208,785636), "S3052C1");
    check_base_class_offset(lv, (S3052C9*)(S3052C4*), ABISELECT(1061200,785632), "S3052C1");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C11*), ABISELECT(1071968,793592), "S3052C1");
    /*is_ambiguous_... S3052C11::S3052C7 */ AMB_check_base_class_offset(lv, (S3052C7*)(S3052C11*), ABISELECT(1071968,793592), "S3052C1");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1072072,793652), "S3052C1");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C11*), ABISELECT(1072072,793652), "S3052C1");
    check_base_class_offset(lv, (S3052C5*)(S3052C11*), ABISELECT(1072072,793652), "S3052C1");
    check_base_class_offset(lv, (S3052C12*)(S3052C11*), ABISELECT(1072384,793880), "S3052C1");
    /*is_ambiguous_... S3052C11::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C11*), ABISELECT(1073504,794720), "S3052C1");
    /*is_ambiguous_... S3052C14::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C14*)(S3052C2*), ABISELECT(1073504,794720), "S3052C1");
    /*is_ambiguous_... S3052C17::S3052C8 */ AMB_check_base_class_offset(lv, (S3052C8*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1073504,794720), "S3052C1");
    check_base_class_offset(lv, (S3052C11*)(S3052C4*), ABISELECT(1071968,793592), "S3052C1");
    /*is_ambiguous_... S3052C4::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*)(S3052C4*), ABISELECT(1073536,794744), "S3052C1");
    check_base_class_offset(lv, (S3052C4*)(S3052C2*), ABISELECT(1060880,785404), "S3052C1");
    check_base_class_offset(lv, (S3052C12*)(S3052C15*)(S3052C14*)(S3052C2*), ABISELECT(48,36), "S3052C1");
    check_base_class_offset(lv, (S3052C15*)(S3052C14*)(S3052C2*), ABISELECT(48,36), "S3052C1");
    /*is_ambiguous_... S3052C14::S3052C6 */ AMB_check_base_class_offset(lv, (S3052C6*)(S3052C14*)(S3052C2*), ABISELECT(1344,976), "S3052C1");
    check_base_class_offset(lv, (S3052C8*)(S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1440,1060), "S3052C1");
    check_base_class_offset(lv, (S3052C7*)(S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1440,1060), "S3052C1");
    check_base_class_offset(lv, (S3052C5*)(S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1440,1060), "S3052C1");
    check_base_class_offset(lv, (S3052C17*)(S3052C14*)(S3052C2*), ABISELECT(1440,1060), "S3052C1");
    check_base_class_offset(lv, (S3052C14*)(S3052C2*), ABISELECT(48,36), "S3052C1");
    /*is_ambiguous_... S3052C2::S3052C10 */ AMB_check_base_class_offset(lv, (S3052C10*)(S3052C2*), ABISELECT(1073744,794892), "S3052C1");
    check_base_class_offset(lv, (S3052C2*), 0, "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C10 */ AMB_check_base_class_offset(lv, (S3052C10*), ABISELECT(1060736,785296), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C3 */ AMB_check_base_class_offset(lv, (S3052C3*), ABISELECT(1060776,785320), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C15 */ AMB_check_base_class_offset(lv, (S3052C12*)(S3052C15*), ABISELECT(1073792,794916), "S3052C1");
    /*is_ambiguous_... S3052C1::S3052C15 */ AMB_check_base_class_offset(lv, (S3052C15*), ABISELECT(1073792,794916), "S3052C1");
    check_field_offset(lv, s3052c1f0, ABISELECT(1060824,785356), "S3052C1.s3052c1f0");
    check_field_offset(lv, s3052c1f1, ABISELECT(1060832,785360), "S3052C1.s3052c1f1");
    check_field_offset(lv, s3052c1f2, ABISELECT(1060848,785372), "S3052C1.s3052c1f2");
    check_field_offset(lv, s3052c1f3, ABISELECT(1060872,785396), "S3052C1.s3052c1f3");
    check_field_offset(lv, s3052c1f4, ABISELECT(1060876,785400), "S3052C1.s3052c1f4");
    test_class_info(&lv, &cd_S3052C1);
    dp->~S3052C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3052C1(Test_S3052C1, "S3052C1", ABISELECT(1075088,795856));

#else // __cplusplus

extern void _ZN7S3052C1C1Ev();
extern void _ZN7S3052C1D2Ev();
Name_Map name_map_S3052C1[] = {
  NSPAIR(_ZN7S3052C1C1Ev),
  NSPAIR(_ZN7S3052C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C3;
extern VTBL_ENTRY _ZTI7S3052C3[];
extern  VTBL_ENTRY _ZTV7S3052C3[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C9;
extern VTBL_ENTRY _ZTI7S3052C9[];
extern  VTBL_ENTRY _ZTV7S3052C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C9[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C11;
extern VTBL_ENTRY _ZTI8S3052C11[];
extern  VTBL_ENTRY _ZTV8S3052C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C4;
extern VTBL_ENTRY _ZTI7S3052C4[];
extern  VTBL_ENTRY _ZTV7S3052C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C4[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
extern Class_Descriptor cd_S3052C6;
extern VTBL_ENTRY _ZTI7S3052C6[];
extern  VTBL_ENTRY _ZTV7S3052C6[];
extern Class_Descriptor cd_S3052C8;
extern VTBL_ENTRY _ZTI7S3052C8[];
extern  VTBL_ENTRY _ZTV7S3052C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C8[];
extern Class_Descriptor cd_S3052C7;
extern VTBL_ENTRY _ZTI7S3052C7[];
extern  VTBL_ENTRY _ZTV7S3052C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C7[];
extern Class_Descriptor cd_S3052C5;
extern VTBL_ENTRY _ZTI7S3052C5[];
extern  VTBL_ENTRY _ZTV7S3052C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C5[];
extern Class_Descriptor cd_S3052C17;
extern VTBL_ENTRY _ZTI8S3052C17[];
extern  VTBL_ENTRY _ZTV8S3052C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C17[];
extern Class_Descriptor cd_S3052C14;
extern VTBL_ENTRY _ZTI8S3052C14[];
extern  VTBL_ENTRY _ZTV8S3052C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C14[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C2;
extern VTBL_ENTRY _ZTI7S3052C2[];
extern  VTBL_ENTRY _ZTV7S3052C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C2[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S3052C3;
extern VTBL_ENTRY _ZTI7S3052C3[];
extern  VTBL_ENTRY _ZTV7S3052C3[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S3052C15;
extern VTBL_ENTRY _ZTI8S3052C15[];
extern  VTBL_ENTRY _ZTV8S3052C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S3052C15[];
static Base_Class bases_S3052C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S3052C6,    ABISELECT(1071768,793448), //bcp->offset
    61, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S3052C8,    ABISELECT(1060880,785404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1060880,785404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1060880,785404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1071864,793532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1071864,793532), //bcp->offset
    68, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(1061208,785636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S3052C9,    ABISELECT(1061200,785632), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1071968,793592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1071968,793592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1072072,793652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1072072,793652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1072072,793652), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(1072384,793880), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1073504,794720), //bcp->offset
    100, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S3052C11,    ABISELECT(1071968,793592), //bcp->offset
    78, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(1073536,794744), //bcp->offset
    106, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S3052C4,    ABISELECT(1060880,785404), //bcp->offset
    41, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S3052C15,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C6,    ABISELECT(1344,976), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C8,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S3052C7,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C5,    ABISELECT(1440,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3052C17,    ABISELECT(1440,1060), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C14,    ABISELECT(48,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S3052C10,    ABISELECT(1073744,794892), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S3052C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C10,    ABISELECT(1060736,785296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C3,    ABISELECT(1060776,785320), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C12,    ABISELECT(1073792,794916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S3052C15,    ABISELECT(1073792,794916), //bcp->offset
    111, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S3052C1[];
extern void _ZN7S3052C32v2Ev();
extern void _ZN7S3052C22v8Ev();
extern void _ZN7S3052C1D1Ev();
extern void _ZN7S3052C1D0Ev();
extern void _ZN7S3052C12v1Ev();
extern void ABISELECT(_ZThn48_N7S3052C1D1Ev,_ZThn36_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn48_N7S3052C1D0Ev,_ZThn36_N7S3052C1D0Ev)();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
extern void ABISELECT(_ZThn1344_N7S3052C1D1Ev,_ZThn976_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1344_N7S3052C1D0Ev,_ZThn976_N7S3052C1D0Ev)();
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZThn1440_N7S3052C1D1Ev,_ZThn1060_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1440_N7S3052C1D0Ev,_ZThn1060_N7S3052C1D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void _ZN7S3052C32v2Ev();
extern void ABISELECT(_ZTv0_n64_N7S3052C1D1Ev,_ZTv0_n32_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1060880_N7S3052C1D1Ev,_ZThn785404_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S3052C1D0Ev,_ZTv0_n32_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1060880_N7S3052C1D0Ev,_ZThn785404_N7S3052C1D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn320_n64_N7S3052C1D1Ev,_ZTvn228_n32_N7S3052C1D1Ev)();
extern void ABISELECT(_ZTvn320_n64_N7S3052C1D0Ev,_ZTvn228_n32_N7S3052C1D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C1D1Ev,_ZTv0_n12_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1071768_N7S3052C1D1Ev,_ZThn793448_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C1D0Ev,_ZTv0_n12_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1071768_N7S3052C1D0Ev,_ZThn793448_N7S3052C1D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
extern void ABISELECT(_ZTv0_n32_N7S3052C1D1Ev,_ZTv0_n16_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1071864_N7S3052C1D1Ev,_ZThn793532_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C1D0Ev,_ZTv0_n16_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1071864_N7S3052C1D0Ev,_ZThn793532_N7S3052C1D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTv0_n40_N7S3052C1D1Ev,_ZTv0_n20_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1071968_N7S3052C1D1Ev,_ZThn793592_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C1D0Ev,_ZTv0_n20_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1071968_N7S3052C1D0Ev,_ZThn793592_N7S3052C1D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn104_n40_N7S3052C1D1Ev,_ZTvn60_n20_N7S3052C1D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C1D0Ev,_ZTvn60_n20_N7S3052C1D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
extern void ABISELECT(_ZTvn416_n40_N7S3052C1D1Ev,_ZTvn288_n20_N7S3052C1D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C1D0Ev,_ZTvn288_n20_N7S3052C1D0Ev)();
extern void ABISELECT(_ZTv0_n32_N7S3052C1D1Ev,_ZTv0_n16_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1073504_N7S3052C1D1Ev,_ZThn794720_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C1D0Ev,_ZTv0_n16_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1073504_N7S3052C1D0Ev,_ZThn794720_N7S3052C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C1D1Ev,_ZTv0_n12_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1073536_N7S3052C1D1Ev,_ZThn794744_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C1D0Ev,_ZTv0_n12_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1073536_N7S3052C1D0Ev,_ZThn794744_N7S3052C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C1D1Ev,_ZTv0_n20_N7S3052C1D1Ev)();
extern void ABISELECT(_ZThn1073792_N7S3052C1D1Ev,_ZThn794916_N7S3052C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C1D0Ev,_ZTv0_n20_N7S3052C1D0Ev)();
extern void ABISELECT(_ZThn1073792_N7S3052C1D0Ev,_ZThn794916_N7S3052C1D0Ev)() __attribute__((weak));
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY vtc_S3052C1[] = {
  ABISELECT(1073792,794916),
  ABISELECT(1073744,794892),
  ABISELECT(1073536,794744),
  ABISELECT(1073504,794720),
  ABISELECT(1071968,793592),
  ABISELECT(1071864,793532),
  ABISELECT(1071768,793448),
  ABISELECT(1060880,785404),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
  (VTBL_ENTRY)&_ZN7S3052C22v8Ev,
  (VTBL_ENTRY)&_ZN7S3052C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C12v1Ev,
  ABISELECT(1073456,794684),
  ABISELECT(1071816,793496),
  ABISELECT(1071720,793412),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C1D1Ev,_ZThn36_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C1D0Ev,_ZThn36_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
  ABISELECT(-1344,-976),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1344_N7S3052C1D1Ev,_ZThn976_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1344_N7S3052C1D0Ev,_ZThn976_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  ABISELECT(1070424,792472),
  ABISELECT(1072064,793660),
  ABISELECT(1070328,792388),
  ABISELECT(-1440,-1060),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C1D1Ev,_ZThn1060_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C1D0Ev,_ZThn1060_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-1060776,-785320),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
  0,
  0,
  ABISELECT(-1060880,-785404),
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  ABISELECT(-1060880,-785404),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C1D1Ev,_ZTv0_n32_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C1D0Ev,_ZTv0_n32_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-1061200,-785632),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C1D1Ev,_ZTvn228_n32_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C1D0Ev,_ZTvn228_n32_N7S3052C1D0Ev),
  0,
  ABISELECT(-1071768,-793448),
  ABISELECT(-1071768,-793448),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C1D1Ev,_ZTv0_n12_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C1D0Ev,_ZTv0_n12_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
  0,
  0,
  ABISELECT(-1071864,-793532),
  ABISELECT(-96,-84),
  ABISELECT(-1071864,-793532),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C1D1Ev,_ZTv0_n16_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C1D0Ev,_ZTv0_n16_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  0,
  0,
  ABISELECT(-1071968,-793592),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-1071968,-793592),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C1D1Ev,_ZTv0_n20_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C1D0Ev,_ZTv0_n20_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-304,-204),
  ABISELECT(-1072072,-793652),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C1D1Ev,_ZTvn60_n20_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C1D0Ev,_ZTvn60_n20_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
  ABISELECT(-1072384,-793880),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C1D1Ev,_ZTvn288_n20_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C1D0Ev,_ZTvn288_n20_N7S3052C1D0Ev),
  ABISELECT(-1073504,-794720),
  ABISELECT(-1736,-1272),
  ABISELECT(-1073504,-794720),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C1D1Ev,_ZTv0_n16_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C1D0Ev,_ZTv0_n16_N7S3052C1D0Ev),
  ABISELECT(-1073536,-794744),
  ABISELECT(-1073536,-794744),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C1D1Ev,_ZTv0_n12_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C1D0Ev,_ZTv0_n12_N7S3052C1D0Ev),
  0,
  ABISELECT(-1073792,-794916),
  ABISELECT(-1928,-1384),
  ABISELECT(-2024,-1468),
  ABISELECT(-1073792,-794916),
  (VTBL_ENTRY)&(_ZTI7S3052C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C1D1Ev,_ZTv0_n20_N7S3052C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C1D0Ev,_ZTv0_n20_N7S3052C1D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern VTBL_ENTRY _ZTV7S3052C1[];
extern void _ZN7S3052C32v2Ev();
extern void _ZN7S3052C22v8Ev();
extern void _ZN7S3052C2D1Ev();
extern void _ZN7S3052C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C2__7S3052C1[] = {
  ABISELECT(1073744,794892),
  ABISELECT(1073536,794744),
  ABISELECT(1073504,794720),
  ABISELECT(1071968,793592),
  ABISELECT(1071864,793532),
  ABISELECT(1071768,793448),
  ABISELECT(1060880,785404),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&_ZN7S3052C32v2Ev,
  (VTBL_ENTRY)&_ZN7S3052C22v8Ev,
  (VTBL_ENTRY)&_ZN7S3052C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C2D0Ev,
};
extern void _ZN8S3052C14D1Ev();
extern void _ZN8S3052C14D0Ev();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(1073456,794684),
  ABISELECT(1071816,793496),
  ABISELECT(1071720,793412),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&_ZN8S3052C14D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C14D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C158S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(1071816,793496),
  ABISELECT(1071720,793412),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1071720_N8S3052C15D1Ev,_ZThn793412_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1071720_N8S3052C15D0Ev,_ZThn793412_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C158S3052C147S3052C2__7S3052C1[] = {
  0,
  ABISELECT(-1071720,-793412),
  ABISELECT(-1071720,-793412),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZThn1071816_N8S3052C15D1Ev,_ZThn793496_N8S3052C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void ABISELECT(_ZThn1071816_N8S3052C15D0Ev,_ZThn793496_N8S3052C15D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C158S3052C147S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1071816,-793496),
  ABISELECT(-96,-84),
  ABISELECT(-1071816,-793496),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN8S3052C17D1Ev();
extern void _ZN8S3052C17D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C178S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(1070424,792472),
  ABISELECT(1072064,793660),
  ABISELECT(1070328,792388),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&_ZN8S3052C17D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C17D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C178S3052C147S3052C2__A2__7S3052C1[] = {
  ABISELECT(1070328,792388),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C178S3052C147S3052C2__A4__7S3052C1[] = {
  ABISELECT(1070328,792388),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C147S3052C2__A5__7S3052C1[] = {
  ABISELECT(1070328,792388),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C8D1Ev,_ZThn792388_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C8D0Ev,_ZThn792388_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C147S3052C2__A5__7S3052C1[] = {
  0,
  ABISELECT(-1070328,-792388),
  ABISELECT(-1070328,-792388),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C7D1Ev,_ZThn792388_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C7D0Ev,_ZThn792388_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C147S3052C2__A4__7S3052C1[] = {
  0,
  ABISELECT(-1070328,-792388),
  ABISELECT(-1070328,-792388),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C5D1Ev,_ZThn792388_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn1070328_N7S3052C5D0Ev,_ZThn792388_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C178S3052C147S3052C2__A2__7S3052C1[] = {
  0,
  ABISELECT(-1070328,-792388),
  ABISELECT(-1070328,-792388),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1070328_N8S3052C17D1Ev,_ZThn792388_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1070328_N8S3052C17D0Ev,_ZThn792388_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C178S3052C147S3052C2__7S3052C1[] = {
  0,
  ABISELECT(-1070328,-792388),
  ABISELECT(-1070328,-792388),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1072064_N8S3052C17D1Ev,_ZThn793660_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1072064_N8S3052C17D0Ev,_ZThn793660_N8S3052C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C178S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(-1072064,-793660),
  ABISELECT(-1736,-1272),
  ABISELECT(-1072064,-793660),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev)();
extern void ABISELECT(_ZThn1070424_N8S3052C17D1Ev,_ZThn792472_N8S3052C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev)();
extern void ABISELECT(_ZThn1070424_N8S3052C17D0Ev,_ZThn792472_N8S3052C17D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__8S3052C178S3052C147S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1070424,-792472),
  ABISELECT(-96,-84),
  ABISELECT(-1070424,-792472),
  (VTBL_ENTRY)&(_ZTI8S3052C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1071720_N8S3052C14D1Ev,_ZThn793412_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1071720_N8S3052C14D0Ev,_ZThn793412_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C147S3052C2__7S3052C1[] = {
  0,
  ABISELECT(-1071720,-793412),
  ABISELECT(-1071720,-793412),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1071816_N8S3052C14D1Ev,_ZThn793496_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1071816_N8S3052C14D0Ev,_ZThn793496_N8S3052C14D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C147S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1071816,-793496),
  ABISELECT(-96,-84),
  ABISELECT(-1071816,-793496),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1073456_N8S3052C14D1Ev,_ZThn794684_N8S3052C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev)();
extern void ABISELECT(_ZThn1073456_N8S3052C14D0Ev,_ZThn794684_N8S3052C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A1__8S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(-1073456,-794684),
  ABISELECT(-1736,-1272),
  ABISELECT(-1073456,-794684),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev),
};
extern void ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev)();
extern void ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C17__8S3052C147S3052C2__7S3052C1[] = {
  ABISELECT(1070424,792472),
  ABISELECT(1072064,793660),
  ABISELECT(1070328,792388),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI8S3052C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D1Ev,_ZThn1024_N8S3052C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N8S3052C14D0Ev,_ZThn1024_N8S3052C14D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1060880_N7S3052C2D1Ev,_ZThn785404_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1060880_N7S3052C2D0Ev,_ZThn785404_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C4__7S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1060880,-785404),
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  ABISELECT(-1060880,-785404),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071768_N7S3052C2D1Ev,_ZThn793448_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071768_N7S3052C2D0Ev,_ZThn793448_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C2__7S3052C1[] = {
  0,
  ABISELECT(-1071768,-793448),
  ABISELECT(-1071768,-793448),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071864_N7S3052C2D1Ev,_ZThn793532_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071864_N7S3052C2D0Ev,_ZThn793532_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1071864,-793532),
  ABISELECT(-96,-84),
  ABISELECT(-1071864,-793532),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn320_n64_N7S3052C2D1Ev,_ZTvn228_n32_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn320_n64_N7S3052C2D0Ev,_ZTvn228_n32_N7S3052C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3052C97S3052C4__7S3052C2__7S3052C1[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-1061200,-785632),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C2D1Ev,_ZTvn228_n32_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N7S3052C2D0Ev,_ZTvn228_n32_N7S3052C2D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1071968_N7S3052C2D1Ev,_ZThn793592_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1071968_N7S3052C2D0Ev,_ZThn793592_N7S3052C2D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C2__7S3052C1[] = {
  0,
  0,
  ABISELECT(-1071968,-793592),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-1071968,-793592),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn104_n40_N7S3052C2D1Ev,_ZTvn60_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C2D0Ev,_ZTvn60_n20_N7S3052C2D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C2__7S3052C1[] = {
  ABISELECT(-304,-204),
  ABISELECT(-1072072,-793652),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C2D1Ev,_ZTvn60_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C2D0Ev,_ZTvn60_n20_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn416_n40_N7S3052C2D1Ev,_ZTvn288_n20_N7S3052C2D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C2D0Ev,_ZTvn288_n20_N7S3052C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S3052C128S3052C11__7S3052C2__7S3052C1[] = {
  ABISELECT(-1072384,-793880),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C2D1Ev,_ZTvn288_n20_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C2D0Ev,_ZTvn288_n20_N7S3052C2D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1073504_N7S3052C2D1Ev,_ZThn794720_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1073504_N7S3052C2D0Ev,_ZThn794720_N7S3052C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C2__7S3052C1[] = {
  ABISELECT(-1073504,-794720),
  ABISELECT(-1736,-1272),
  ABISELECT(-1073504,-794720),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1073536_N7S3052C2D1Ev,_ZThn794744_N7S3052C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev)();
extern void ABISELECT(_ZThn1073536_N7S3052C2D0Ev,_ZThn794744_N7S3052C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3052C12__A1__7S3052C2__7S3052C1[] = {
  ABISELECT(-1073536,-794744),
  ABISELECT(-1073536,-794744),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev),
};
extern void ABISELECT(_ZThn48_N7S3052C2D1Ev,_ZThn36_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn48_N7S3052C2D0Ev,_ZThn36_N7S3052C2D0Ev)();
extern void _ZN8S3052C152v6Ev();
extern void _ZN8S3052C142v7Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C14__7S3052C2__7S3052C1[] = {
  ABISELECT(1073456,794684),
  ABISELECT(1071816,793496),
  ABISELECT(1071720,793412),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C2D1Ev,_ZThn36_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N7S3052C2D0Ev,_ZThn36_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
  (VTBL_ENTRY)&_ZN8S3052C142v7Ev,
};
extern void ABISELECT(_ZThn1440_N7S3052C2D1Ev,_ZThn1060_N7S3052C2D1Ev)();
extern void ABISELECT(_ZThn1440_N7S3052C2D0Ev,_ZThn1060_N7S3052C2D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C178S3052C14__7S3052C2__7S3052C1[] = {
  ABISELECT(1070424,792472),
  ABISELECT(1072064,793660),
  ABISELECT(1070328,792388),
  ABISELECT(-1440,-1060),
  (VTBL_ENTRY)&(_ZTI7S3052C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C2D1Ev,_ZThn1060_N7S3052C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1440_N7S3052C2D0Ev,_ZThn1060_N7S3052C2D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C4D1Ev();
extern void _ZN7S3052C4D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C4__7S3052C1[] = {
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&_ZN7S3052C4D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C4D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C57S3052C4__7S3052C1[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C57S3052C4__7S3052C1[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C57S3052C4__7S3052C1[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__7S3052C1[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__7S3052C1[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C57S3052C4__7S3052C1[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C9D1Ev();
extern void _ZN7S3052C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C97S3052C4__7S3052C1[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&_ZN7S3052C9D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C9D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__7S3052C97S3052C4__7S3052C1[] = {
  0,
  0,
  ABISELECT(-10664,-7900),
  ABISELECT(-96,-84),
  ABISELECT(-10664,-7900),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev)();
extern void ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C97S3052C4__7S3052C1[] = {
  0,
  ABISELECT(-10568,-7816),
  ABISELECT(-10568,-7816),
  (VTBL_ENTRY)&(_ZTI7S3052C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C4__7S3052C1[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C4__7S3052C1[] = {
  0,
  0,
  ABISELECT(-10984,-8128),
  ABISELECT(-96,-84),
  ABISELECT(-10984,-8128),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S3052C9__7S3052C4__7S3052C1[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D1Ev,_ZThn228_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S3052C4D0Ev,_ZThn228_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev)() __attribute__((weak));
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C4__7S3052C1[] = {
  0,
  0,
  ABISELECT(-11088,-8188),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-11088,-8188),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C4__7S3052C1[] = {
  ABISELECT(-304,-204),
  ABISELECT(-11192,-8248),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D1Ev,_ZTvn60_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N7S3052C4D0Ev,_ZTvn60_n20_N7S3052C4D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S3052C128S3052C11__7S3052C4__7S3052C1[] = {
  ABISELECT(-11504,-8476),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D1Ev,_ZTvn288_n20_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N7S3052C4D0Ev,_ZTvn288_n20_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C4__7S3052C1[] = {
  ABISELECT(-12624,-9316),
  ABISELECT(-1736,-1272),
  ABISELECT(-12624,-9316),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev)();
extern void ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3052C12__A1__7S3052C4__7S3052C1[] = {
  ABISELECT(-12656,-9340),
  ABISELECT(-12656,-9340),
  (VTBL_ENTRY)&(_ZTI7S3052C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev),
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__A1__7S3052C1[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C7__A1__7S3052C1[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C1[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C7__A1__7S3052C1[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C11D1Ev();
extern void _ZN8S3052C11D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C11__7S3052C1[] = {
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&_ZN8S3052C11D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C11D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C78S3052C11__A2__7S3052C1[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C1[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C1[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C1[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN7S3052C5D1Ev();
extern void _ZN7S3052C5D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C58S3052C11__A1__7S3052C1[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&_ZN7S3052C5D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C5D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C7D1Ev();
extern void _ZN7S3052C7D0Ev();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C1[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&_ZN7S3052C7D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C7D0Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C1[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C1[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C1[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C1[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI7S3052C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C11__7S3052C1[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D1Ev,_ZTv0_n12_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C11D0Ev,_ZTv0_n12_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C5__8S3052C11__7S3052C1[] = {
  ABISELECT(-304,-204),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D1Ev,_ZThn60_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N8S3052C11D0Ev,_ZThn60_N8S3052C11D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev)();
extern void ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S3052C8__A2__8S3052C11__7S3052C1[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-1736,-1272),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S3052C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev),
};
extern void _ZN7S3052C8D1Ev();
extern void _ZN7S3052C8D0Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C8__A4__7S3052C1[] = {
  ABISELECT(-1736,-1272),
  0,
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&_ZN7S3052C8D1Ev,
  (VTBL_ENTRY)&_ZN7S3052C8D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__7S3052C8__A4__7S3052C1[] = {
  0,
  ABISELECT(1736,1272),
  ABISELECT(1736,1272),
  (VTBL_ENTRY)&(_ZTI7S3052C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void _ZN8S3052C15D1Ev();
extern void _ZN8S3052C15D0Ev();
extern void _ZN8S3052C152v6Ev();
static  VTBL_ENTRY _tg__ZTV8S3052C15__A1__7S3052C1[] = {
  ABISELECT(-1928,-1384),
  ABISELECT(-2024,-1468),
  0,
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&_ZN8S3052C15D1Ev,
  (VTBL_ENTRY)&_ZN8S3052C15D0Ev,
  (VTBL_ENTRY)&_ZN8S3052C152v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev)();
extern void _ZN7S3052C62v3Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C6__8S3052C15__A1__7S3052C1[] = {
  0,
  ABISELECT(2024,1468),
  ABISELECT(2024,1468),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev)();
extern void _ZN7S3052C72v4Ev();
extern void _ZN7S3052C72v5Ev();
static  VTBL_ENTRY _tg__ZTV7S3052C7__8S3052C15__A1__7S3052C1[] = {
  0,
  0,
  ABISELECT(1928,1384),
  ABISELECT(-96,-84),
  ABISELECT(1928,1384),
  (VTBL_ENTRY)&(_ZTI8S3052C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev),
  (VTBL_ENTRY)&_ZN7S3052C72v4Ev,
  (VTBL_ENTRY)&_ZN7S3052C72v5Ev,
};
static  VTT_ENTRY vtt_S3052C1[] = {
  {&(_ZTV7S3052C1[10]),  10,120},
  {&(_tg__ZTV7S3052C2__7S3052C1[9]),  9,13},
  {&(_tg__ZTV8S3052C147S3052C2__7S3052C1[5]),  5,9},
  {&(_tg__ZTV8S3052C158S3052C147S3052C2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C158S3052C147S3052C2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C158S3052C147S3052C2__7S3052C1[6]),  6,10},
  {&(_tg__ZTV8S3052C178S3052C147S3052C2__7S3052C1[5]),  5,9},
  {&(_tg__ZTV7S3052C58S3052C178S3052C147S3052C2__A2__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C178S3052C147S3052C2__A4__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C178S3052C147S3052C2__A5__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C178S3052C147S3052C2__A5__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C178S3052C147S3052C2__A4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C178S3052C147S3052C2__A2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C178S3052C147S3052C2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C8__A1__8S3052C178S3052C147S3052C2__7S3052C1[4]),  4,6},
  {&(_tg__ZTV7S3052C7__A1__8S3052C178S3052C147S3052C2__7S3052C1[6]),  6,10},
  {&(_tg__ZTV7S3052C6__8S3052C147S3052C2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C147S3052C2__7S3052C1[6]),  6,10},
  {&(_tg__ZTV7S3052C8__A1__8S3052C147S3052C2__7S3052C1[4]),  4,6},
  {&(_tg__ZTV8S3052C17__8S3052C147S3052C2__7S3052C1[5]),  5,9},
  {&(_tg__ZTV7S3052C4__7S3052C2__7S3052C1[10]),  10,14},
  {&(_tg__ZTV7S3052C6__7S3052C2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C7__A1__7S3052C2__7S3052C1[6]),  6,10},
  {&(_tg__ZTV7S3052C97S3052C4__7S3052C2__7S3052C1[4]),  4,6},
  {&(_tg__ZTV8S3052C11__7S3052C2__7S3052C1[7]),  7,11},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C2__7S3052C1[3]),  3,7},
  {&(_tg__ZTV8S3052C128S3052C11__7S3052C2__7S3052C1[2]),  2,4},
  {&(_tg__ZTV7S3052C8__A4__7S3052C2__7S3052C1[4]),  4,6},
  {&(_tg__ZTV8S3052C12__A1__7S3052C2__7S3052C1[3]),  3,5},
  {&(_tg__ZTV8S3052C14__7S3052C2__7S3052C1[5]),  5,9},
  {&(_tg__ZTV8S3052C178S3052C14__7S3052C2__7S3052C1[5]),  5,9},
  {&(_ZTV7S3052C1[51]),  51,120},
  {&(_ZTV7S3052C1[65]),  65,120},
  {&(_ZTV7S3052C1[74]),  74,120},
  {&(_ZTV7S3052C1[59]),  59,120},
  {&(_ZTV7S3052C1[85]),  85,120},
  {&(_ZTV7S3052C1[92]),  92,120},
  {&(_ZTV7S3052C1[98]),  98,120},
  {&(_ZTV7S3052C1[104]),  104,120},
  {&(_ZTV7S3052C1[109]),  109,120},
  {&(_ZTV7S3052C1[20]),  20,120},
  {&(_ZTV7S3052C1[34]),  34,120},
  {&(_ZTV7S3052C1[117]),  117,120},
  {&(_tg__ZTV7S3052C4__7S3052C1[7]),  7,11},
  {&(_tg__ZTV7S3052C57S3052C4__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C57S3052C4__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C57S3052C4__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C57S3052C4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C57S3052C4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C57S3052C4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C97S3052C4__7S3052C1[4]),  4,6},
  {&(_tg__ZTV7S3052C7__7S3052C97S3052C4__7S3052C1[6]),  6,10},
  {&(_tg__ZTV7S3052C6__7S3052C97S3052C4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C7__A1__7S3052C4__7S3052C1[6]),  6,10},
  {&(_tg__ZTV7S3052C9__7S3052C4__7S3052C1[4]),  4,6},
  {&(_tg__ZTV8S3052C11__7S3052C4__7S3052C1[7]),  7,11},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C4__7S3052C1[3]),  3,7},
  {&(_tg__ZTV8S3052C128S3052C11__7S3052C4__7S3052C1[2]),  2,4},
  {&(_tg__ZTV7S3052C8__A4__7S3052C4__7S3052C1[4]),  4,6},
  {&(_tg__ZTV8S3052C12__A1__7S3052C4__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C7__A1__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C7__A1__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C7__A1__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C7__A1__7S3052C1[4]),  4,7},
  {&(_tg__ZTV8S3052C11__7S3052C1[4]),  4,8},
  {&(_tg__ZTV7S3052C78S3052C11__A2__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C78S3052C11__A2__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C78S3052C11__A2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C78S3052C11__A2__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C58S3052C11__A1__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C77S3052C58S3052C11__A3__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C87S3052C77S3052C58S3052C11__A3__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C77S3052C58S3052C11__A3__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__7S3052C58S3052C11__A1__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C11__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C5__8S3052C11__7S3052C1[3]),  3,7},
  {&(_tg__ZTV7S3052C8__A2__8S3052C11__7S3052C1[4]),  4,6},
  {&(_tg__ZTV7S3052C8__A4__7S3052C1[3]),  3,5},
  {&(_tg__ZTV7S3052C6__7S3052C8__A4__7S3052C1[4]),  4,7},
  {&(_tg__ZTV8S3052C15__A1__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C6__8S3052C15__A1__7S3052C1[4]),  4,7},
  {&(_tg__ZTV7S3052C7__8S3052C15__A1__7S3052C1[6]),  6,10},
};
extern VTBL_ENTRY _ZTI7S3052C1[];
extern  VTBL_ENTRY _ZTV7S3052C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S3052C1[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D0Ev,_ZTv0_n16_N8S3052C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D0Ev,_ZThn1128_N8S3052C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C11D1Ev,_ZTv0_n16_N8S3052C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S3052C11D1Ev,_ZThn1128_N8S3052C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D0Ev,_ZTv0_n20_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D0Ev,_ZThn8188_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C4D1Ev,_ZTv0_n20_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N7S3052C4D1Ev,_ZThn8188_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D0Ev,_ZTv0_n16_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D0Ev,_ZThn9316_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D0Ev,_ZThn8128_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C4D1Ev,_ZTv0_n16_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N7S3052C4D1Ev,_ZThn9316_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N7S3052C4D1Ev,_ZThn8128_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D0Ev,_ZTv0_n12_N7S3052C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D0Ev,_ZThn9340_N7S3052C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D0Ev,_ZThn8044_N7S3052C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C4D1Ev,_ZTv0_n12_N7S3052C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N7S3052C4D1Ev,_ZThn9340_N7S3052C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C4D1Ev,_ZThn8044_N7S3052C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D0Ev,_ZTv0_n12_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D0Ev,_ZThn7816_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C9D1Ev,_ZTv0_n12_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N7S3052C9D1Ev,_ZThn7816_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D0Ev,_ZTv0_n16_N7S3052C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D0Ev,_ZThn7900_N7S3052C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C9D1Ev,_ZTv0_n16_N7S3052C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N7S3052C9D1Ev,_ZThn7900_N7S3052C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C2D0Ev,_ZTv0_n20_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071968_N7S3052C2D0Ev,_ZThn793592_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C2D1Ev,_ZTv0_n20_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071968_N7S3052C2D1Ev,_ZThn793592_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C2D0Ev,_ZTv0_n16_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073504_N7S3052C2D0Ev,_ZThn794720_N7S3052C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071864_N7S3052C2D0Ev,_ZThn793532_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C2D1Ev,_ZTv0_n16_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073504_N7S3052C2D1Ev,_ZThn794720_N7S3052C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071864_N7S3052C2D1Ev,_ZThn793532_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C2D0Ev,_ZTv0_n12_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073536_N7S3052C2D0Ev,_ZThn794744_N7S3052C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071768_N7S3052C2D0Ev,_ZThn793448_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C2D1Ev,_ZTv0_n12_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073536_N7S3052C2D1Ev,_ZThn794744_N7S3052C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071768_N7S3052C2D1Ev,_ZThn793448_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C2D0Ev,_ZTv0_n32_N7S3052C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060880_N7S3052C2D0Ev,_ZThn785404_N7S3052C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C2D1Ev,_ZTv0_n32_N7S3052C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060880_N7S3052C2D1Ev,_ZThn785404_N7S3052C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D0Ev,_ZTv0_n16_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073456_N8S3052C14D0Ev,_ZThn794684_N8S3052C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071816_N8S3052C14D0Ev,_ZThn793496_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C14D1Ev,_ZTv0_n16_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073456_N8S3052C14D1Ev,_ZThn794684_N8S3052C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071816_N8S3052C14D1Ev,_ZThn793496_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D0Ev,_ZTv0_n12_N8S3052C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N8S3052C14D0Ev,_ZThn793412_N8S3052C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C14D1Ev,_ZTv0_n12_N8S3052C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N8S3052C14D1Ev,_ZThn793412_N8S3052C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D0Ev,_ZTv0_n16_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070424_N8S3052C17D0Ev,_ZThn792472_N8S3052C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072064_N8S3052C17D0Ev,_ZThn793660_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C17D1Ev,_ZTv0_n16_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070424_N8S3052C17D1Ev,_ZThn792472_N8S3052C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072064_N8S3052C17D1Ev,_ZThn793660_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D0Ev,_ZTv0_n12_N8S3052C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N8S3052C17D0Ev,_ZThn792388_N8S3052C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C17D1Ev,_ZTv0_n12_N8S3052C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N8S3052C17D1Ev,_ZThn792388_N8S3052C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D0Ev,_ZTv0_n12_N7S3052C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D0Ev,_ZThn8044_N7S3052C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C5D0Ev,_ZThn792388_N7S3052C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C5D1Ev,_ZTv0_n12_N7S3052C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C5D1Ev,_ZThn8044_N7S3052C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C5D1Ev,_ZThn792388_N7S3052C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D0Ev,_ZTv0_n12_N7S3052C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D0Ev,_ZThn8044_N7S3052C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C7D0Ev,_ZThn792388_N7S3052C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C7D1Ev,_ZTv0_n12_N7S3052C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C7D1Ev,_ZThn8044_N7S3052C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C7D1Ev,_ZThn792388_N7S3052C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D0Ev,_ZTv0_n12_N7S3052C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D0Ev,_ZThn8044_N7S3052C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C8D0Ev,_ZThn792388_N7S3052C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C8D1Ev,_ZTv0_n12_N7S3052C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N7S3052C8D1Ev,_ZThn8044_N7S3052C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1070328_N7S3052C8D1Ev,_ZThn792388_N7S3052C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D0Ev,_ZTv0_n16_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071816_N8S3052C15D0Ev,_ZThn793496_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S3052C15D1Ev,_ZTv0_n16_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071816_N8S3052C15D1Ev,_ZThn793496_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D0Ev,_ZTv0_n12_N8S3052C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N8S3052C15D0Ev,_ZThn793412_N8S3052C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S3052C15D1Ev,_ZTv0_n12_N8S3052C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1071720_N8S3052C15D1Ev,_ZThn793412_N8S3052C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C1D0Ev,_ZTv0_n20_N7S3052C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073792_N7S3052C1D0Ev,_ZThn794916_N7S3052C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071968_N7S3052C1D0Ev,_ZThn793592_N7S3052C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S3052C1D1Ev,_ZTv0_n20_N7S3052C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073792_N7S3052C1D1Ev,_ZThn794916_N7S3052C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071968_N7S3052C1D1Ev,_ZThn793592_N7S3052C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C1D0Ev,_ZTv0_n16_N7S3052C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073504_N7S3052C1D0Ev,_ZThn794720_N7S3052C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071864_N7S3052C1D0Ev,_ZThn793532_N7S3052C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N7S3052C1D1Ev,_ZTv0_n16_N7S3052C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073504_N7S3052C1D1Ev,_ZThn794720_N7S3052C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071864_N7S3052C1D1Ev,_ZThn793532_N7S3052C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C1D0Ev,_ZTv0_n12_N7S3052C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073536_N7S3052C1D0Ev,_ZThn794744_N7S3052C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071768_N7S3052C1D0Ev,_ZThn793448_N7S3052C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S3052C1D1Ev,_ZTv0_n12_N7S3052C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1073536_N7S3052C1D1Ev,_ZThn794744_N7S3052C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1071768_N7S3052C1D1Ev,_ZThn793448_N7S3052C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C1D0Ev,_ZTv0_n32_N7S3052C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060880_N7S3052C1D0Ev,_ZThn785404_N7S3052C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S3052C1D1Ev,_ZTv0_n32_N7S3052C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1060880_N7S3052C1D1Ev,_ZThn785404_N7S3052C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S3052C1 = {  "S3052C1", // class name
  bases_S3052C1, 33,
  &(vtc_S3052C1[0]), // expected_vtbl_contents
  &(vtt_S3052C1[0]), // expected_vtt_contents
  ABISELECT(1075088,795856), // object size
  NSPAIRA(_ZTI7S3052C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S3052C1),120, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S3052C1),84, //virtual table table var
  30, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C3  {
  short s20846c3f0[6];
  __tsi64 s20846c3f1[8];
  int s20846c3f2;
  virtual  ~S20846C3(); // _ZN8S20846C3D1Ev
  virtual void  v3(); // _ZN8S20846C32v3Ev
  S20846C3(); // tgen
};
//SIG(-1 S20846C3) C1{ vd v1 Fs[6] FL[8] Fi}


 S20846C3 ::~S20846C3(){ note_dtor("S20846C3", this);}
void  S20846C3 ::v3(){vfunc_called(this, "_ZN8S20846C32v3Ev");}
S20846C3 ::S20846C3(){ note_ctor("S20846C3", this);} // tgen

static void Test_S20846C3()
{
  extern Class_Descriptor cd_S20846C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,22)];
    init_test(&cd_S20846C3, buf);
    S20846C3 *dp, &lv = *(dp=new (buf) S20846C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,84), "sizeof(S20846C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C3)");
    check_field_offset(lv, s20846c3f0, ABISELECT(8,4), "S20846C3.s20846c3f0");
    check_field_offset(lv, s20846c3f1, ABISELECT(24,16), "S20846C3.s20846c3f1");
    check_field_offset(lv, s20846c3f2, ABISELECT(88,80), "S20846C3.s20846c3f2");
    test_class_info(&lv, &cd_S20846C3);
    dp->~S20846C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C3(Test_S20846C3, "S20846C3", ABISELECT(96,84));

#else // __cplusplus

extern void _ZN8S20846C3C1Ev();
extern void _ZN8S20846C3D1Ev();
Name_Map name_map_S20846C3[] = {
  NSPAIR(_ZN8S20846C3C1Ev),
  NSPAIR(_ZN8S20846C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20846C3[];
extern void _ZN8S20846C3D1Ev();
extern void _ZN8S20846C3D0Ev();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C3[0]),
  (VTBL_ENTRY)&_ZN8S20846C3D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C3D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
Class_Descriptor cd_S20846C3 = {  "S20846C3", // class name
  0,0,//no base classes
  &(vtc_S20846C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,84), // object size
  NSPAIRA(_ZTI8S20846C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20846C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C4  : virtual S20846C3 {
  __tsi64 s20846c4f0;
  void *s20846c4f1;
  __tsi64 s20846c4f2:54;
  ~S20846C4(); // tgen
  S20846C4(); // tgen
};
//SIG(-1 S20846C4) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} FL Fp FL:54}


S20846C4 ::~S20846C4(){ note_dtor("S20846C4", this);} // tgen
S20846C4 ::S20846C4(){ note_ctor("S20846C4", this);} // tgen

static void Test_S20846C4()
{
  extern Class_Descriptor cd_S20846C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,28)];
    init_test(&cd_S20846C4, buf);
    S20846C4 *dp, &lv = *(dp=new (buf) S20846C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,108), "sizeof(S20846C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C4)");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(32,24), "S20846C4");
    check_field_offset(lv, s20846c4f0, ABISELECT(8,4), "S20846C4.s20846c4f0");
    check_field_offset(lv, s20846c4f1, ABISELECT(16,12), "S20846C4.s20846c4f1");
    set_bf_and_test(lv, s20846c4f2, ABISELECT(24,16), 0, 54, 1, "S20846C4");
    set_bf_and_test(lv, s20846c4f2, ABISELECT(24,16), 0, 54, hide_sll(1LL<<53), "S20846C4");
    test_class_info(&lv, &cd_S20846C4);
    dp->~S20846C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C4(Test_S20846C4, "S20846C4", ABISELECT(128,108));

#else // __cplusplus

extern void _ZN8S20846C4C1Ev();
extern void _ZN8S20846C4D1Ev();
Name_Map name_map_S20846C4[] = {
  NSPAIR(_ZN8S20846C4C1Ev),
  NSPAIR(_ZN8S20846C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
static Base_Class bases_S20846C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(32,24), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20846C4[];
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn32_N8S20846C4D1Ev,_ZThn24_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn32_N8S20846C4D0Ev,_ZThn24_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C4[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S20846C4[];
static  VTT_ENTRY vtt_S20846C4[] = {
  {&(_ZTV8S20846C4[3]),  3,12},
  {&(_ZTV8S20846C4[9]),  9,12},
};
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20846C4D0Ev,_ZThn24_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20846C4D1Ev,_ZThn24_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C4 = {  "S20846C4", // class name
  bases_S20846C4, 1,
  &(vtc_S20846C4[0]), // expected_vtbl_contents
  &(vtt_S20846C4[0]), // expected_vtt_contents
  ABISELECT(128,108), // object size
  NSPAIRA(_ZTI8S20846C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20846C4),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20846C4),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C2  : virtual S20846C3 , S20846C4 {
  char  :0;
  void *s20846c2f1[8];
  char s20846c2f2;
  virtual void  v4(); // _ZN8S20846C22v4Ev
  virtual void  v5(); // _ZN8S20846C22v5Ev
  ~S20846C2(); // tgen
  S20846C2(); // tgen
};
//SIG(-1 S20846C2) C1{ VBC2{ vd v3 Fs[6] FL[8] Fi} BC3{ VBC2 FL Fp FL:54} v1 v2 Fc:0 Fp[8] Fc}


void  S20846C2 ::v4(){vfunc_called(this, "_ZN8S20846C22v4Ev");}
void  S20846C2 ::v5(){vfunc_called(this, "_ZN8S20846C22v5Ev");}
S20846C2 ::~S20846C2(){ note_dtor("S20846C2", this);} // tgen
S20846C2 ::S20846C2(){ note_ctor("S20846C2", this);} // tgen

static void Test_S20846C2()
{
  extern Class_Descriptor cd_S20846C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,37)];
    init_test(&cd_S20846C2, buf);
    S20846C2 *dp, &lv = *(dp=new (buf) S20846C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,144), "sizeof(S20846C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C2)");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(104,60), "S20846C2");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(104,60), "S20846C2");
    check_base_class_offset(lv, (S20846C4*), 0, "S20846C2");
    check_field_offset(lv, s20846c2f1, ABISELECT(32,24), "S20846C2.s20846c2f1");
    check_field_offset(lv, s20846c2f2, ABISELECT(96,56), "S20846C2.s20846c2f2");
    test_class_info(&lv, &cd_S20846C2);
    dp->~S20846C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C2(Test_S20846C2, "S20846C2", ABISELECT(200,144));

#else // __cplusplus

extern void _ZN8S20846C2C1Ev();
extern void _ZN8S20846C2D1Ev();
Name_Map name_map_S20846C2[] = {
  NSPAIR(_ZN8S20846C2C1Ev),
  NSPAIR(_ZN8S20846C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
static Base_Class bases_S20846C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(104,60), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20846C2[];
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C2[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S20846C2[];
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__8S20846C2[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__8S20846C2[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C2[] = {
  {&(_ZTV8S20846C2[3]),  3,14},
  {&(_tg__ZTV8S20846C4__8S20846C2[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__8S20846C2[4]),  4,7},
  {&(_ZTV8S20846C2[11]),  11,14},
};
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C2 = {  "S20846C2", // class name
  bases_S20846C2, 2,
  &(vtc_S20846C2[0]), // expected_vtbl_contents
  &(vtt_S20846C2[0]), // expected_vtt_contents
  ABISELECT(200,144), // object size
  NSPAIRA(_ZTI8S20846C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20846C2),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20846C2),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C6  : virtual S20846C3 , S20846C2 {
  void *s20846c6f0[3];
  char s20846c6f1:8;
  int s20846c6f2[2];
  char s20846c6f3;
  ::S20846C3 s20846c6f4;
  void *s20846c6f5[3];
  __tsi64 s20846c6f6[5];
  int s20846c6f7;
  ~S20846C6(); // tgen
  S20846C6(); // tgen
};
//SIG(-1 S20846C6) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi}


S20846C6 ::~S20846C6(){ note_dtor("S20846C6", this);} // tgen
S20846C6 ::S20846C6(){ note_ctor("S20846C6", this);} // tgen

static void Test_S20846C6()
{
  extern Class_Descriptor cd_S20846C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(52,79)];
    init_test(&cd_S20846C6, buf);
    S20846C6 *dp, &lv = *(dp=new (buf) S20846C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(408,312), "sizeof(S20846C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C6)");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(312,228), "S20846C6");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(312,228), "S20846C6");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(312,228), "S20846C6");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*), 0, "S20846C6");
    check_base_class_offset(lv, (S20846C2*), 0, "S20846C6");
    check_field_offset(lv, s20846c6f0, ABISELECT(104,60), "S20846C6.s20846c6f0");
    set_bf_and_test(lv, s20846c6f1, ABISELECT(128,72), 0, 8, 1, "S20846C6");
    set_bf_and_test(lv, s20846c6f1, ABISELECT(128,72), 0, 8, hide_sll(1LL<<7), "S20846C6");
    check_field_offset(lv, s20846c6f2, ABISELECT(132,76), "S20846C6.s20846c6f2");
    check_field_offset(lv, s20846c6f3, ABISELECT(140,84), "S20846C6.s20846c6f3");
    check_field_offset(lv, s20846c6f4, ABISELECT(144,88), "S20846C6.s20846c6f4");
    check_field_offset(lv, s20846c6f5, ABISELECT(240,172), "S20846C6.s20846c6f5");
    check_field_offset(lv, s20846c6f6, ABISELECT(264,184), "S20846C6.s20846c6f6");
    check_field_offset(lv, s20846c6f7, ABISELECT(304,224), "S20846C6.s20846c6f7");
    test_class_info(&lv, &cd_S20846C6);
    dp->~S20846C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C6(Test_S20846C6, "S20846C6", ABISELECT(408,312));

#else // __cplusplus

extern void _ZN8S20846C6C1Ev();
extern void _ZN8S20846C6D1Ev();
Name_Map name_map_S20846C6[] = {
  NSPAIR(_ZN8S20846C6C1Ev),
  NSPAIR(_ZN8S20846C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
static Base_Class bases_S20846C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(312,228), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20846C6[];
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C6[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S20846C6[];
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__8S20846C6[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__8S20846C6[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__8S20846C6[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__8S20846C6[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C6[] = {
  {&(_ZTV8S20846C6[3]),  3,14},
  {&(_tg__ZTV8S20846C2__8S20846C6[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__8S20846C6[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__8S20846C6[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__8S20846C6[4]),  4,7},
  {&(_ZTV8S20846C6[11]),  11,14},
};
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C6 = {  "S20846C6", // class name
  bases_S20846C6, 3,
  &(vtc_S20846C6[0]), // expected_vtbl_contents
  &(vtt_S20846C6[0]), // expected_vtt_contents
  ABISELECT(408,312), // object size
  NSPAIRA(_ZTI8S20846C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20846C6),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20846C6),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C7  : virtual S20846C3 , S20846C6 , virtual S20846C4 , virtual S20846C2 {
  void *s20846c7f0[7];
  virtual  ~S20846C7(); // _ZN8S20846C7D2Ev
  S20846C7(); // tgen
};
//SIG(-1 S20846C7) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 BC5{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} VBC5 VBC4 vd Fp[7]}


 S20846C7 ::~S20846C7(){ note_dtor("S20846C7", this);}
S20846C7 ::S20846C7(){ note_ctor("S20846C7", this);} // tgen

static void Test_S20846C7()
{
  extern Class_Descriptor cd_S20846C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(76,107)];
    init_test(&cd_S20846C7, buf);
    S20846C7 *dp, &lv = *(dp=new (buf) S20846C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(600,424), "sizeof(S20846C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C7)");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(368,256), "S20846C7");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(368,256), "S20846C7");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(368,256), "S20846C7");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(368,256), "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(368,256), "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(368,256), "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(368,256), "S20846C7");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), 0, "S20846C7");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*), 0, "S20846C7");
    check_base_class_offset(lv, (S20846C6*), 0, "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*), ABISELECT(464,340), "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(496,364), "S20846C7");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*), ABISELECT(496,364), "S20846C7");
    check_field_offset(lv, s20846c7f0, ABISELECT(312,228), "S20846C7.s20846c7f0");
    test_class_info(&lv, &cd_S20846C7);
    dp->~S20846C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C7(Test_S20846C7, "S20846C7", ABISELECT(600,424));

#else // __cplusplus

extern void _ZN8S20846C7C1Ev();
extern void _ZN8S20846C7D2Ev();
Name_Map name_map_S20846C7[] = {
  NSPAIR(_ZN8S20846C7C1Ev),
  NSPAIR(_ZN8S20846C7D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
static Base_Class bases_S20846C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(368,256), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(464,340), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(496,364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(496,364), //bcp->offset
    22, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20846C7[];
extern void _ZN8S20846C7D1Ev();
extern void _ZN8S20846C7D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn368_N8S20846C7D1Ev,_ZThn256_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn368_N8S20846C7D0Ev,_ZThn256_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn464_N8S20846C7D1Ev,_ZThn340_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn464_N8S20846C7D0Ev,_ZThn340_N8S20846C7D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn496_N8S20846C7D1Ev,_ZThn364_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn496_N8S20846C7D0Ev,_ZThn364_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY vtc_S20846C7[] = {
  ABISELECT(496,364),
  ABISELECT(464,340),
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&_ZN8S20846C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(-464,-340),
  ABISELECT(-96,-84),
  ABISELECT(-464,-340),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
  0,
  0,
  ABISELECT(-496,-364),
  ABISELECT(-128,-108),
  ABISELECT(-496,-364),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern VTBL_ENTRY _ZTV8S20846C7[];
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__8S20846C7[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__8S20846C7[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__8S20846C7[] = {
  ABISELECT(368,256),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn368_N8S20846C4D1Ev,_ZThn256_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn368_N8S20846C4D0Ev,_ZThn256_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__8S20846C7[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn368_N8S20846C2D1Ev,_ZThn256_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn368_N8S20846C2D0Ev,_ZThn256_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__8S20846C7[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn368_N8S20846C6D1Ev,_ZThn256_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn368_N8S20846C6D0Ev,_ZThn256_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__8S20846C7[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__8S20846C7[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A1__8S20846C7[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__8S20846C7[] = {
  ABISELECT(-128,-108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__A2__8S20846C7[] = {
  ABISELECT(-128,-108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__A2__8S20846C7[] = {
  0,
  ABISELECT(128,108),
  ABISELECT(128,108),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__A1__8S20846C7[] = {
  0,
  ABISELECT(128,108),
  ABISELECT(128,108),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C7[] = {
  {&(_ZTV8S20846C7[5]),  5,32},
  {&(_tg__ZTV8S20846C6__8S20846C7[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__8S20846C7[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__8S20846C7[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__8S20846C7[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__8S20846C7[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__8S20846C7[4]),  4,7},
  {&(_ZTV8S20846C7[13]),  13,32},
  {&(_ZTV8S20846C7[20]),  20,32},
  {&(_ZTV8S20846C7[28]),  28,32},
  {&(_tg__ZTV8S20846C4__A1__8S20846C7[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A1__8S20846C7[4]),  4,7},
  {&(_tg__ZTV8S20846C2__A1__8S20846C7[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__A2__8S20846C7[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__A2__8S20846C7[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__A1__8S20846C7[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S20846C7[];
extern  VTBL_ENTRY _ZTV8S20846C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C7[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C6D0Ev,_ZThn256_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C6D1Ev,_ZThn256_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C2D0Ev,_ZThn256_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C2D1Ev,_ZThn256_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C4D0Ev,_ZThn256_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C4D1Ev,_ZThn256_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S20846C7D0Ev,_ZThn364_N8S20846C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S20846C7D0Ev,_ZThn340_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S20846C7D1Ev,_ZThn364_N8S20846C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S20846C7D1Ev,_ZThn340_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C7D0Ev,_ZThn256_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N8S20846C7D1Ev,_ZThn256_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C7 = {  "S20846C7", // class name
  bases_S20846C7, 7,
  &(vtc_S20846C7[0]), // expected_vtbl_contents
  &(vtt_S20846C7[0]), // expected_vtt_contents
  ABISELECT(600,424), // object size
  NSPAIRA(_ZTI8S20846C7),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20846C7),32, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20846C7),16, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C5  : S20846C6 , virtual S20846C2 , virtual S20846C4 , virtual S20846C7 , virtual S3052C12 {
  int s20846c5f0;
  __tsi64 s20846c5f1;
  int s20846c5f2[2];
  short s20846c5f3[8];
  ::S3052C12 s20846c5f4;
  ::S3052C16 s20846c5f5;
  long double s20846c5f6[5];
  int s20846c5f7:5;
  int s20846c5f8;
  virtual  ~S20846C5(); // _ZN8S20846C5D2Ev
  virtual void  v6(); // _ZN8S20846C52v6Ev
  S20846C5(); // tgen
};
//SIG(-1 S20846C5) C1{ BC2{ VBC3{ vd v2 Fs[6] FL[8] Fi} BC4{ VBC3 BC5{ VBC3 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} VBC4 VBC5 VBC6{ VBC3 BC2 VBC5 VBC4 vd Fp[7]} VBC7{ vd m FC8{ VBC9{ vd v7 Fs[6] FL[8] Fi} BC10{ VBC9 FL Fp FL:54} v5 v6 Fc:0 Fp[8] Fc}} vd v1 Fi FL Fi[2] Fs[8] FC7 FU11{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} FD[5] Fi:5 Fi}


 S20846C5 ::~S20846C5(){ note_dtor("S20846C5", this);}
void  S20846C5 ::v6(){vfunc_called(this, "_ZN8S20846C52v6Ev");}
S20846C5 ::S20846C5(){ note_ctor("S20846C5", this);} // tgen

static void Test_S20846C5()
{
  extern Class_Descriptor cd_S20846C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(93,267)];
    init_test(&cd_S20846C5, buf);
    S20846C5 *dp, &lv = *(dp=new (buf) S20846C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1472,1064), "sizeof(S20846C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C5)");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(664,492), "S20846C5");
    check_base_class_offset(lv, (S20846C3*)(S20846C7*), ABISELECT(664,492), "S20846C5");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C7*), ABISELECT(664,492), "S20846C5");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(664,492), "S20846C5");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(664,492), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), 0, "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C6*), 0, "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C6*), 0, "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(760,576), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*), ABISELECT(760,576), "S20846C5");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C7*), ABISELECT(760,576), "S20846C5");
    /*is_ambiguous_... S20846C5::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*), ABISELECT(864,636), "S20846C5");
    /*is_ambiguous_... S20846C7::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C7*), ABISELECT(864,636), "S20846C5");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(896,660), "S20846C5");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(896,660), "S20846C5");
    check_base_class_offset(lv, (S20846C6*)(S20846C7*), ABISELECT(896,660), "S20846C5");
    check_base_class_offset(lv, (S20846C7*), ABISELECT(896,660), "S20846C5");
    check_base_class_offset(lv, (S3052C12*), ABISELECT(1264,916), "S20846C5");
    check_field_offset(lv, s20846c5f0, ABISELECT(308,228), "S20846C5.s20846c5f0");
    check_field_offset(lv, s20846c5f1, ABISELECT(312,232), "S20846C5.s20846c5f1");
    check_field_offset(lv, s20846c5f2, ABISELECT(320,240), "S20846C5.s20846c5f2");
    check_field_offset(lv, s20846c5f3, ABISELECT(328,248), "S20846C5.s20846c5f3");
    check_field_offset(lv, s20846c5f4, ABISELECT(344,264), "S20846C5.s20846c5f4");
    check_field_offset(lv, s20846c5f5, ABISELECT(552,412), "S20846C5.s20846c5f5");
    check_field_offset(lv, s20846c5f6, ABISELECT(576,424), "S20846C5.s20846c5f6");
    set_bf_and_test(lv, s20846c5f7, ABISELECT(656,484), 0, 5, 1, "S20846C5");
    set_bf_and_test(lv, s20846c5f7, ABISELECT(656,484), 0, 5, hide_sll(1LL<<4), "S20846C5");
    check_field_offset(lv, s20846c5f8, ABISELECT(660,488), "S20846C5.s20846c5f8");
    test_class_info(&lv, &cd_S20846C5);
    dp->~S20846C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C5(Test_S20846C5, "S20846C5", ABISELECT(1472,1064));

#else // __cplusplus

extern void _ZN8S20846C5C1Ev();
extern void _ZN8S20846C5D2Ev();
Name_Map name_map_S20846C5[] = {
  NSPAIR(_ZN8S20846C5C1Ev),
  NSPAIR(_ZN8S20846C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C7;
extern VTBL_ENTRY _ZTI8S20846C7[];
extern  VTBL_ENTRY _ZTV8S20846C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C7[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
static Base_Class bases_S20846C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(664,492), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(760,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(760,576), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(864,636), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(896,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(896,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(896,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20846C7,    ABISELECT(896,660), //bcp->offset
    35, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    ABISELECT(1264,916), //bcp->offset
    47, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20846C5[];
extern void _ZN8S20846C5D1Ev();
extern void _ZN8S20846C5D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void _ZN8S20846C52v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C5D1Ev,_ZTv0_n12_N8S20846C5D1Ev)();
extern void ABISELECT(_ZThn664_N8S20846C5D1Ev,_ZThn492_N8S20846C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C5D0Ev,_ZTv0_n12_N8S20846C5D0Ev)();
extern void ABISELECT(_ZThn664_N8S20846C5D0Ev,_ZThn492_N8S20846C5D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N8S20846C5D1Ev,_ZTv0_n16_N8S20846C5D1Ev)();
extern void ABISELECT(_ZThn760_N8S20846C5D1Ev,_ZThn576_N8S20846C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C5D0Ev,_ZTv0_n16_N8S20846C5D0Ev)();
extern void ABISELECT(_ZThn760_N8S20846C5D0Ev,_ZThn576_N8S20846C5D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n32_N8S20846C5D1Ev,_ZTv0_n16_N8S20846C5D1Ev)();
extern void ABISELECT(_ZThn864_N8S20846C5D1Ev,_ZThn636_N8S20846C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C5D0Ev,_ZTv0_n16_N8S20846C5D0Ev)();
extern void ABISELECT(_ZThn864_N8S20846C5D0Ev,_ZThn636_N8S20846C5D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S20846C5D1Ev,_ZTv0_n24_N8S20846C5D1Ev)();
extern void ABISELECT(_ZThn896_N8S20846C5D1Ev,_ZThn660_N8S20846C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S20846C5D0Ev,_ZTv0_n24_N8S20846C5D0Ev)();
extern void ABISELECT(_ZThn896_N8S20846C5D0Ev,_ZThn660_N8S20846C5D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N8S20846C5D1Ev,_ZTv0_n12_N8S20846C5D1Ev)();
extern void ABISELECT(_ZThn1264_N8S20846C5D1Ev,_ZThn916_N8S20846C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C5D0Ev,_ZTv0_n12_N8S20846C5D0Ev)();
extern void ABISELECT(_ZThn1264_N8S20846C5D0Ev,_ZThn916_N8S20846C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C5[] = {
  ABISELECT(1264,916),
  ABISELECT(896,660),
  ABISELECT(864,636),
  ABISELECT(760,576),
  ABISELECT(664,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&_ZN8S20846C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C5D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20846C52v6Ev,
  0,
  ABISELECT(-664,-492),
  ABISELECT(-664,-492),
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C5D1Ev,_ZTv0_n12_N8S20846C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C5D0Ev,_ZTv0_n12_N8S20846C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-760,-576),
  ABISELECT(-96,-84),
  ABISELECT(-760,-576),
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C5D1Ev,_ZTv0_n16_N8S20846C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C5D0Ev,_ZTv0_n16_N8S20846C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-864,-636),
  ABISELECT(-200,-144),
  ABISELECT(-864,-636),
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C5D1Ev,_ZTv0_n16_N8S20846C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C5D0Ev,_ZTv0_n16_N8S20846C5D0Ev),
  0,
  0,
  ABISELECT(-896,-660),
  ABISELECT(-136,-84),
  ABISELECT(-32,-24),
  ABISELECT(-232,-168),
  ABISELECT(-896,-660),
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20846C5D1Ev,_ZTv0_n24_N8S20846C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S20846C5D0Ev,_ZTv0_n24_N8S20846C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-1264,-916),
  ABISELECT(-1264,-916),
  (VTBL_ENTRY)&(_ZTI8S20846C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C5D1Ev,_ZTv0_n12_N8S20846C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C5D0Ev,_ZTv0_n12_N8S20846C5D0Ev),
};
extern VTBL_ENTRY _ZTV8S20846C5[];
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__8S20846C5[] = {
  ABISELECT(664,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__8S20846C5[] = {
  ABISELECT(664,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__8S20846C5[] = {
  ABISELECT(664,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn664_N8S20846C4D1Ev,_ZThn492_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn664_N8S20846C4D0Ev,_ZThn492_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__8S20846C5[] = {
  0,
  ABISELECT(-664,-492),
  ABISELECT(-664,-492),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn664_N8S20846C2D1Ev,_ZThn492_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn664_N8S20846C2D0Ev,_ZThn492_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__8S20846C5[] = {
  0,
  ABISELECT(-664,-492),
  ABISELECT(-664,-492),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn664_N8S20846C6D1Ev,_ZThn492_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn664_N8S20846C6D0Ev,_ZThn492_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__8S20846C5[] = {
  0,
  ABISELECT(-664,-492),
  ABISELECT(-664,-492),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__8S20846C5[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__A1__8S20846C5[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__A1__8S20846C5[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__A1__8S20846C5[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A2__8S20846C5[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A2__8S20846C5[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C7D1Ev();
extern void _ZN8S20846C7D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C7__8S20846C5[] = {
  ABISELECT(-136,-84),
  ABISELECT(-32,-24),
  ABISELECT(-232,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&_ZN8S20846C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C68S20846C7__A1__8S20846C5[] = {
  ABISELECT(-232,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C68S20846C7__A2__8S20846C5[] = {
  ABISELECT(-232,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C68S20846C7__A3__8S20846C5[] = {
  ABISELECT(-232,-168),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C7__A3__8S20846C5[] = {
  0,
  ABISELECT(232,168),
  ABISELECT(232,168),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C68S20846C7__A2__8S20846C5[] = {
  0,
  ABISELECT(232,168),
  ABISELECT(232,168),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C68S20846C7__A1__8S20846C5[] = {
  0,
  ABISELECT(232,168),
  ABISELECT(232,168),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C7__8S20846C5[] = {
  0,
  ABISELECT(232,168),
  ABISELECT(232,168),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__8S20846C7__8S20846C5[] = {
  ABISELECT(32,24),
  ABISELECT(-200,-144),
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__8S20846C7__8S20846C5[] = {
  0,
  0,
  ABISELECT(136,84),
  ABISELECT(-96,-84),
  ABISELECT(136,84),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
static  VTT_ENTRY vtt_S20846C5[] = {
  {&(_ZTV8S20846C5[7]),  7,52},
  {&(_tg__ZTV8S20846C6__8S20846C5[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__8S20846C5[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__8S20846C5[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__8S20846C5[4]),  4,7},
  {&(_ZTV8S20846C5[16]),  16,52},
  {&(_ZTV8S20846C5[25]),  25,52},
  {&(_ZTV8S20846C5[33]),  33,52},
  {&(_ZTV8S20846C5[43]),  43,52},
  {&(_ZTV8S20846C5[50]),  50,52},
  {&(_tg__ZTV8S20846C2__A1__8S20846C5[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__A1__8S20846C5[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__A1__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__A1__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A2__8S20846C5[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A2__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C7__8S20846C5[5]),  5,9},
  {&(_tg__ZTV8S20846C68S20846C7__A1__8S20846C5[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C68S20846C7__A2__8S20846C5[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C68S20846C7__A3__8S20846C5[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C7__A3__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C68S20846C7__A2__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C68S20846C7__A1__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C7__8S20846C5[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A1__8S20846C7__8S20846C5[4]),  4,6},
  {&(_tg__ZTV8S20846C2__A1__8S20846C7__8S20846C5[6]),  6,10},
};
extern VTBL_ENTRY _ZTI8S20846C5[];
extern  VTBL_ENTRY _ZTV8S20846C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C5[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C6D0Ev,_ZThn492_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C6D1Ev,_ZThn492_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C2D0Ev,_ZThn492_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C2D1Ev,_ZThn492_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C4D0Ev,_ZThn492_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C4D1Ev,_ZThn492_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20846C5D0Ev,_ZTv0_n24_N8S20846C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn896_N8S20846C5D0Ev,_ZThn660_N8S20846C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S20846C5D1Ev,_ZTv0_n24_N8S20846C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn896_N8S20846C5D1Ev,_ZThn660_N8S20846C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C5D0Ev,_ZTv0_n16_N8S20846C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn864_N8S20846C5D0Ev,_ZThn636_N8S20846C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn760_N8S20846C5D0Ev,_ZThn576_N8S20846C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C5D1Ev,_ZTv0_n16_N8S20846C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn864_N8S20846C5D1Ev,_ZThn636_N8S20846C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn760_N8S20846C5D1Ev,_ZThn576_N8S20846C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C5D0Ev,_ZTv0_n12_N8S20846C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N8S20846C5D0Ev,_ZThn916_N8S20846C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C5D0Ev,_ZThn492_N8S20846C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C5D1Ev,_ZTv0_n12_N8S20846C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N8S20846C5D1Ev,_ZThn916_N8S20846C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn664_N8S20846C5D1Ev,_ZThn492_N8S20846C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C5 = {  "S20846C5", // class name
  bases_S20846C5, 12,
  &(vtc_S20846C5[0]), // expected_vtbl_contents
  &(vtt_S20846C5[0]), // expected_vtt_contents
  ABISELECT(1472,1064), // object size
  NSPAIRA(_ZTI8S20846C5),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20846C5),52, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20846C5),28, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C13  : virtual S20846C3 , S20846C2 , S20846C6 , S3052C12 , virtual S20846C4 {
  void *s20846c13f0;
  long s20846c13f1;
  ::S20846C6 s20846c13f2;
  ::S3052C12 s20846c13f3;
  ::S20846C4 s20846c13f4;
  int s20846c13f5;
  int s20846c13f6;
  ::S3052C13 s20846c13f7[9];
  ~S20846C13(); // tgen
  S20846C13(); // tgen
};
//SIG(-1 S20846C13) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} BC3{ VBC2 BC4{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} BC5{ VBC2 BC3 Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} BC6{ vd m FC7{ VBC8{ vd v6 Fs[6] FL[8] Fi} BC9{ VBC8 FL Fp FL:54} v4 v5 Fc:0 Fp[8] Fc}} VBC4 Fp Fl FC5 FC6 FC4 Fi[2] FU10{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}


S20846C13 ::~S20846C13(){ note_dtor("S20846C13", this);} // tgen
S20846C13 ::S20846C13(){ note_ctor("S20846C13", this);} // tgen

static void Test_S20846C13()
{
  extern Class_Descriptor cd_S20846C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(105,310)];
    init_test(&cd_S20846C13, buf);
    S20846C13 *dp, &lv = *(dp=new (buf) S20846C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1664,1236), "sizeof(S20846C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C13)");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(1536,1128), "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(1536,1128), "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(1536,1128), "S20846C13");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(1536,1128), "S20846C13");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(1536,1128), "S20846C13");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(1536,1128), "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(1536,1128), "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), 0, "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*), 0, "S20846C13");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(104,60), "S20846C13");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*), ABISELECT(104,60), "S20846C13");
    check_base_class_offset(lv, (S20846C6*), ABISELECT(104,60), "S20846C13");
    check_base_class_offset(lv, (S3052C12*), ABISELECT(416,288), "S20846C13");
    /*is_ambiguous_... S20846C13::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*), ABISELECT(1632,1212), "S20846C13");
    check_field_offset(lv, s20846c13f0, ABISELECT(624,436), "S20846C13.s20846c13f0");
    check_field_offset(lv, s20846c13f1, ABISELECT(632,440), "S20846C13.s20846c13f1");
    check_field_offset(lv, s20846c13f2, ABISELECT(640,444), "S20846C13.s20846c13f2");
    check_field_offset(lv, s20846c13f3, ABISELECT(1048,756), "S20846C13.s20846c13f3");
    check_field_offset(lv, s20846c13f4, ABISELECT(1256,904), "S20846C13.s20846c13f4");
    check_field_offset(lv, s20846c13f5, ABISELECT(1384,1012), "S20846C13.s20846c13f5");
    check_field_offset(lv, s20846c13f6, ABISELECT(1388,1016), "S20846C13.s20846c13f6");
    check_field_offset(lv, s20846c13f7, ABISELECT(1392,1020), "S20846C13.s20846c13f7");
    test_class_info(&lv, &cd_S20846C13);
    dp->~S20846C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C13(Test_S20846C13, "S20846C13", ABISELECT(1664,1236));

#else // __cplusplus

extern void _ZN9S20846C13C1Ev();
extern void _ZN9S20846C13D1Ev();
Name_Map name_map_S20846C13[] = {
  NSPAIR(_ZN9S20846C13C1Ev),
  NSPAIR(_ZN9S20846C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
static Base_Class bases_S20846C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(1536,1128), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(104,60), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3052C12,    ABISELECT(416,288), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(1632,1212), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C13[];
extern void _ZN9S20846C13D1Ev();
extern void _ZN9S20846C13D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZThn416_N9S20846C13D1Ev,_ZThn288_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn416_N9S20846C13D0Ev,_ZThn288_N9S20846C13D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn1632_N9S20846C13D1Ev,_ZThn1212_N9S20846C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev)();
extern void ABISELECT(_ZThn1632_N9S20846C13D0Ev,_ZThn1212_N9S20846C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C13[] = {
  ABISELECT(1632,1212),
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&_ZN9S20846C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(1432,1068),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-416,-288),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn416_N9S20846C13D1Ev,_ZThn288_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn416_N9S20846C13D0Ev,_ZThn288_N9S20846C13D0Ev),
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(-1632,-1212),
  ABISELECT(-96,-84),
  ABISELECT(-1632,-1212),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C13[];
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C13[] = {
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C13[] = {
  ABISELECT(1536,1128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn1536_N8S20846C4D1Ev,_ZThn1128_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn1536_N8S20846C4D0Ev,_ZThn1128_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C13[] = {
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn1536_N8S20846C2D1Ev,_ZThn1128_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn1536_N8S20846C2D0Ev,_ZThn1128_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C13[] = {
  0,
  ABISELECT(-1536,-1128),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C13[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__A1__9S20846C13[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__A1__9S20846C13[] = {
  ABISELECT(1432,1068),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C4D1Ev,_ZThn1068_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C4D0Ev,_ZThn1068_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__A1__9S20846C13[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C2D1Ev,_ZThn1068_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C2D0Ev,_ZThn1068_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__A1__9S20846C13[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C6D1Ev,_ZThn1068_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn1432_N8S20846C6D0Ev,_ZThn1068_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__9S20846C13[] = {
  0,
  ABISELECT(-1432,-1068),
  ABISELECT(-1432,-1068),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A2__9S20846C13[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A2__9S20846C13[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C13[] = {
  {&(_ZTV9S20846C13[4]),  4,32},
  {&(_tg__ZTV8S20846C2__9S20846C13[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C13[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C13[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C13[4]),  4,7},
  {&(_tg__ZTV8S20846C6__9S20846C13[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__A1__9S20846C13[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__A1__9S20846C13[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__A1__9S20846C13[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__A1__9S20846C13[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__9S20846C13[4]),  4,7},
  {&(_ZTV9S20846C13[23]),  23,32},
  {&(_ZTV9S20846C13[11]),  11,32},
  {&(_ZTV9S20846C13[30]),  30,32},
  {&(_tg__ZTV8S20846C4__A2__9S20846C13[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A2__9S20846C13[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C13[];
extern  VTBL_ENTRY _ZTV9S20846C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C13[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C6D0Ev,_ZThn1068_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C6D1Ev,_ZThn1068_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C2D0Ev,_ZThn1068_N8S20846C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S20846C2D0Ev,_ZThn1128_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C2D1Ev,_ZThn1068_N8S20846C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S20846C2D1Ev,_ZThn1128_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C4D0Ev,_ZThn1068_N8S20846C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S20846C4D0Ev,_ZThn1128_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1432_N8S20846C4D1Ev,_ZThn1068_N8S20846C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N8S20846C4D1Ev,_ZThn1128_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1632_N9S20846C13D0Ev,_ZThn1212_N9S20846C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1632_N9S20846C13D1Ev,_ZThn1212_N9S20846C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C13 = {  "S20846C13", // class name
  bases_S20846C13, 8,
  &(vtc_S20846C13[0]), // expected_vtbl_contents
  &(vtt_S20846C13[0]), // expected_vtt_contents
  ABISELECT(1664,1236), // object size
  NSPAIRA(_ZTI9S20846C13),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20846C13),32, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C13),16, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C11  : S3052C10 , virtual S20846C2 {
  void *s20846c11f0;
  char s20846c11f1[4];
  int s20846c11f2:11;
  void *s20846c11f3;
  void *s20846c11f4;
  int s20846c11f5[6];
  ::S20846C13 s20846c11f6[6];
  ~S20846C11(); // tgen
  S20846C11(); // tgen
};
//SIG(-1 S20846C11) C1{ BC2{ m Fp Fi FL Fp Fi} VBC3{ VBC4{ vd v1 Fs[6] FL[8] Fi} BC5{ VBC4 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp Fc[4] Fi:11 Fp[2] Fi[6] FC6{ VBC4 BC3 BC7{ VBC4 BC3 Fp[3] Fc:8 Fi[2] Fc FC4 Fp[3] FL[5] Fi} BC8{ vd m FC9{ VBC10{ vd v6 Fs[6] FL[8] Fi} BC11{ VBC10 FL Fp FL:54} v4 v5 Fc:0 Fp[8] Fc}} VBC5 Fp Fl FC7 FC8 FC5 Fi[2] FU12{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]}


S20846C11 ::~S20846C11(){ note_dtor("S20846C11", this);} // tgen
S20846C11 ::S20846C11(){ note_ctor("S20846C11", this);} // tgen

static void Test_S20846C11()
{
  extern Class_Descriptor cd_S20846C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(645,1909)];
    init_test(&cd_S20846C11, buf);
    S20846C11 *dp, &lv = *(dp=new (buf) S20846C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(10304,7632), "sizeof(S20846C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C11)");
    check_base_class_offset(lv, (S3052C10*), ABISELECT(8,4), "S20846C11");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(10200,7548), "S20846C11");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(10200,7548), "S20846C11");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(10096,7488), "S20846C11");
    check_base_class_offset(lv, (S20846C2*), ABISELECT(10096,7488), "S20846C11");
    check_field_offset(lv, s20846c11f0, ABISELECT(48,28), "S20846C11.s20846c11f0");
    check_field_offset(lv, s20846c11f1, ABISELECT(56,32), "S20846C11.s20846c11f1");
    set_bf_and_test(lv, s20846c11f2, ABISELECT(60,36), 0, 11, 1, "S20846C11");
    set_bf_and_test(lv, s20846c11f2, ABISELECT(60,36), 0, 11, hide_sll(1LL<<10), "S20846C11");
    check_field_offset(lv, s20846c11f3, ABISELECT(64,40), "S20846C11.s20846c11f3");
    check_field_offset(lv, s20846c11f4, ABISELECT(72,44), "S20846C11.s20846c11f4");
    check_field_offset(lv, s20846c11f5, ABISELECT(80,48), "S20846C11.s20846c11f5");
    check_field_offset(lv, s20846c11f6, ABISELECT(112,72), "S20846C11.s20846c11f6");
    test_class_info(&lv, &cd_S20846C11);
    dp->~S20846C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C11(Test_S20846C11, "S20846C11", ABISELECT(10304,7632));

#else // __cplusplus

extern void _ZN9S20846C11C1Ev();
extern void _ZN9S20846C11D1Ev();
Name_Map name_map_S20846C11[] = {
  NSPAIR(_ZN9S20846C11C1Ev),
  NSPAIR(_ZN9S20846C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
static Base_Class bases_S20846C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C10,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C3,    ABISELECT(10200,7548), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20846C4,    ABISELECT(10096,7488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(10096,7488), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C11[];
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZThn10096_N9S20846C11D1Ev,_ZThn7488_N9S20846C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void ABISELECT(_ZThn10096_N9S20846C11D0Ev,_ZThn7488_N9S20846C11D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZThn10200_N9S20846C11D1Ev,_ZThn7548_N9S20846C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void ABISELECT(_ZThn10200_N9S20846C11D0Ev,_ZThn7548_N9S20846C11D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C11[] = {
  ABISELECT(10200,7548),
  ABISELECT(10096,7488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
  0,
  0,
  ABISELECT(-10096,-7488),
  ABISELECT(104,60),
  ABISELECT(-10096,-7488),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-10200,-7548),
  ABISELECT(-10200,-7548),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S20846C11[];
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C11[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C11[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C11[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C11[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C11[] = {
  {&(_ZTV9S20846C11[4]),  4,23},
  {&(_ZTV9S20846C11[12]),  12,23},
  {&(_ZTV9S20846C11[20]),  20,23},
  {&(_tg__ZTV8S20846C2__9S20846C11[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C11[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C11[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C11[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10200_N9S20846C11D0Ev,_ZThn7548_N9S20846C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10200_N9S20846C11D1Ev,_ZThn7548_N9S20846C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10096_N9S20846C11D0Ev,_ZThn7488_N9S20846C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10096_N9S20846C11D1Ev,_ZThn7488_N9S20846C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C11 = {  "S20846C11", // class name
  bases_S20846C11, 4,
  &(vtc_S20846C11[0]), // expected_vtbl_contents
  &(vtt_S20846C11[0]), // expected_vtt_contents
  ABISELECT(10304,7632), // object size
  NSPAIRA(_ZTI9S20846C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20846C11),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C11),7, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C10  : S20846C6 , virtual S20846C2 , S20846C11 , virtual S20846C13 , virtual S3052C12 {
  ::S3052C12 s20846c10f0[2];
  int s20846c10f1;
  long double s20846c10f2;
  long double s20846c10f3;
  char  :0;
  void *s20846c10f5;
  virtual  ~S20846C10(); // _ZN9S20846C10D2Ev
  S20846C10(); // tgen
};
//SIG(-1 S20846C10) C1{ BC2{ VBC3{ vd v1 Fs[6] FL[8] Fi} BC4{ VBC3 BC5{ VBC3 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} VBC4 BC6{ BC7{ m Fp Fi FL Fp Fi} VBC4 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC8{ VBC3 BC4 BC2 BC9{ vd m FC10{ VBC11{ vd v6 Fs[6] FL[8] Fi} BC12{ VBC11 FL Fp FL:54} v4 v5 Fc:0 Fp[8] Fc}} VBC5 Fp Fl FC2 FC9 FC5 Fi[2] FU13{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} VBC8 VBC9 vd FC9[2] Fi FD FD Fc:0 Fp}


 S20846C10 ::~S20846C10(){ note_dtor("S20846C10", this);}
S20846C10 ::S20846C10(){ note_ctor("S20846C10", this);} // tgen

static void Test_S20846C10()
{
  extern Class_Descriptor cd_S20846C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(805,2373)];
    init_test(&cd_S20846C10, buf);
    S20846C10 *dp, &lv = *(dp=new (buf) S20846C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12864,9488), "sizeof(S20846C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C10)");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(10888,8044), "S20846C10");
    check_base_class_offset(lv, (S20846C3*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(10888,8044), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), 0, "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C6*), 0, "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C6*), 0, "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(10984,8128), "S20846C10");
    /*is_ambiguous_... S20846C10::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*), ABISELECT(10984,8128), "S20846C10");
    check_base_class_offset(lv, (S20846C2*)(S20846C11*), ABISELECT(10984,8128), "S20846C10");
    check_base_class_offset(lv, (S3052C10*)(S20846C11*), ABISELECT(328,232), "S20846C10");
    check_base_class_offset(lv, (S20846C11*), ABISELECT(320,228), "S20846C10");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C13*), ABISELECT(11088,8188), "S20846C10");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C13*), ABISELECT(11088,8188), "S20846C10");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(11192,8248), "S20846C10");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(11192,8248), "S20846C10");
    check_base_class_offset(lv, (S20846C6*)(S20846C13*), ABISELECT(11192,8248), "S20846C10");
    check_base_class_offset(lv, (S3052C12*)(S20846C13*), ABISELECT(11504,8476), "S20846C10");
    /*is_ambiguous_... S20846C13::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C13*), ABISELECT(12624,9316), "S20846C10");
    check_base_class_offset(lv, (S20846C13*), ABISELECT(11088,8188), "S20846C10");
    /*is_ambiguous_... S20846C10::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*), ABISELECT(12656,9340), "S20846C10");
    check_field_offset(lv, s20846c10f0, ABISELECT(10416,7716), "S20846C10.s20846c10f0");
    check_field_offset(lv, s20846c10f1, ABISELECT(10832,8012), "S20846C10.s20846c10f1");
    check_field_offset(lv, s20846c10f2, ABISELECT(10848,8016), "S20846C10.s20846c10f2");
    check_field_offset(lv, s20846c10f3, ABISELECT(10864,8028), "S20846C10.s20846c10f3");
    check_field_offset(lv, s20846c10f5, ABISELECT(10880,8040), "S20846C10.s20846c10f5");
    test_class_info(&lv, &cd_S20846C10);
    dp->~S20846C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C10(Test_S20846C10, "S20846C10", ABISELECT(12864,9488));

#else // __cplusplus

extern void _ZN9S20846C10C1Ev();
extern void _ZN9S20846C10D2Ev();
Name_Map name_map_S20846C10[] = {
  NSPAIR(_ZN9S20846C10C1Ev),
  NSPAIR(_ZN9S20846C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C11;
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C13;
extern VTBL_ENTRY _ZTI9S20846C13[];
extern  VTBL_ENTRY _ZTV9S20846C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C13[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
static Base_Class bases_S20846C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(10888,8044), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20846C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(10984,8128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(10984,8128), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C10,    ABISELECT(328,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20846C11,    ABISELECT(320,228), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(11088,8188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(11088,8188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(11192,8248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(11192,8248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(11192,8248), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(11504,8476), //bcp->offset
    52, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(12624,9316), //bcp->offset
    56, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S20846C13,    ABISELECT(11088,8188), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    ABISELECT(12656,9340), //bcp->offset
    62, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C10[];
extern void _ZN9S20846C10D1Ev();
extern void _ZN9S20846C10D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZThn320_N9S20846C10D1Ev,_ZThn228_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn320_N9S20846C10D0Ev,_ZThn228_N9S20846C10D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn10888_N9S20846C10D1Ev,_ZThn8044_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn10888_N9S20846C10D0Ev,_ZThn8044_N9S20846C10D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn10984_N9S20846C10D1Ev,_ZThn8128_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn10984_N9S20846C10D0Ev,_ZThn8128_N9S20846C10D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn11088_N9S20846C10D1Ev,_ZThn8188_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn11088_N9S20846C10D0Ev,_ZThn8188_N9S20846C10D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTvn104_n40_N9S20846C10D1Ev,_ZTvn60_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N9S20846C10D0Ev,_ZTvn60_n20_N9S20846C10D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTvn416_n40_N9S20846C10D1Ev,_ZTvn288_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N9S20846C10D0Ev,_ZTvn288_n20_N9S20846C10D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn12624_N9S20846C10D1Ev,_ZThn9316_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn12624_N9S20846C10D0Ev,_ZThn9316_N9S20846C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn12656_N9S20846C10D1Ev,_ZThn9340_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn12656_N9S20846C10D0Ev,_ZThn9340_N9S20846C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C10[] = {
  ABISELECT(12656,9340),
  ABISELECT(12624,9316),
  ABISELECT(11088,8188),
  ABISELECT(10984,8128),
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&_ZN9S20846C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C10D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N9S20846C10D1Ev,_ZThn228_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N9S20846C10D0Ev,_ZThn228_N9S20846C10D0Ev),
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-10984,-8128),
  ABISELECT(-96,-84),
  ABISELECT(-10984,-8128),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  0,
  ABISELECT(-11088,-8188),
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  ABISELECT(-11088,-8188),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-304,-204),
  ABISELECT(-11192,-8248),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C10D1Ev,_ZTvn60_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C10D0Ev,_ZTvn60_n20_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-11504,-8476),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C10D1Ev,_ZTvn288_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C10D0Ev,_ZTvn288_n20_N9S20846C10D0Ev),
  ABISELECT(-12624,-9316),
  ABISELECT(-1736,-1272),
  ABISELECT(-12624,-9316),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev),
  ABISELECT(-12656,-9340),
  ABISELECT(-12656,-9340),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C10[];
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C10[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__9S20846C10[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__9S20846C10[] = {
  ABISELECT(10888,8044),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C4D1Ev,_ZThn8044_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C4D0Ev,_ZThn8044_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C10[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C2D1Ev,_ZThn8044_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C2D0Ev,_ZThn8044_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C10[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C6D1Ev,_ZThn8044_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn10888_N8S20846C6D0Ev,_ZThn8044_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__9S20846C10[] = {
  0,
  ABISELECT(-10888,-8044),
  ABISELECT(-10888,-8044),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C10[] = {
  ABISELECT(10568,7816),
  ABISELECT(10664,7900),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZThn10664_N9S20846C11D1Ev,_ZThn7900_N9S20846C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void ABISELECT(_ZThn10664_N9S20846C11D0Ev,_ZThn7900_N9S20846C11D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C11__9S20846C10[] = {
  0,
  0,
  ABISELECT(-10664,-7900),
  ABISELECT(-96,-84),
  ABISELECT(-10664,-7900),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZThn10568_N9S20846C11D1Ev,_ZThn7816_N9S20846C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void ABISELECT(_ZThn10568_N9S20846C11D0Ev,_ZThn7816_N9S20846C11D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C11__9S20846C10[] = {
  0,
  ABISELECT(-10568,-7816),
  ABISELECT(-10568,-7816),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__9S20846C10[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__A1__9S20846C10[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__A1__9S20846C10[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__A1__9S20846C10[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C13D1Ev();
extern void _ZN9S20846C13D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C13__9S20846C10[] = {
  ABISELECT(1536,1128),
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&_ZN9S20846C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C29S20846C13__A2__9S20846C10[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C29S20846C13__A2__9S20846C10[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C29S20846C13__A2__9S20846C10[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C29S20846C13__A2__9S20846C10[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C69S20846C13__A1__9S20846C10[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C69S20846C13__A3__9S20846C10[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C69S20846C13__A3__9S20846C10[] = {
  ABISELECT(-304,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C13__A3__9S20846C10[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C69S20846C13__A3__9S20846C10[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C69S20846C13__A1__9S20846C10[] = {
  0,
  ABISELECT(304,204),
  ABISELECT(304,204),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C13__9S20846C10[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C13__9S20846C10[] = {
  ABISELECT(-304,-204),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A2__9S20846C13__9S20846C10[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-1736,-1272),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev),
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A4__9S20846C10[] = {
  ABISELECT(-1736,-1272),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A4__9S20846C10[] = {
  0,
  ABISELECT(1736,1272),
  ABISELECT(1736,1272),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C10[] = {
  {&(_ZTV9S20846C10[7]),  7,67},
  {&(_tg__ZTV8S20846C6__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__9S20846C10[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__9S20846C10[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C10[4]),  4,6},
  {&(_tg__ZTV8S20846C2__9S20846C11__9S20846C10[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C11__9S20846C10[4]),  4,7},
  {&(_ZTV9S20846C10[21]),  21,67},
  {&(_ZTV9S20846C10[30]),  30,67},
  {&(_ZTV9S20846C10[15]),  15,67},
  {&(_ZTV9S20846C10[41]),  41,67},
  {&(_ZTV9S20846C10[48]),  48,67},
  {&(_ZTV9S20846C10[54]),  54,67},
  {&(_ZTV9S20846C10[60]),  60,67},
  {&(_ZTV9S20846C10[65]),  65,67},
  {&(_tg__ZTV8S20846C2__A1__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__A1__9S20846C10[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__A1__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__A1__9S20846C10[4]),  4,7},
  {&(_tg__ZTV9S20846C13__9S20846C10[4]),  4,8},
  {&(_tg__ZTV8S20846C29S20846C13__A2__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C29S20846C13__A2__9S20846C10[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C29S20846C13__A2__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C29S20846C13__A2__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C69S20846C13__A1__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C69S20846C13__A3__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C69S20846C13__A3__9S20846C10[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C13__A3__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C69S20846C13__A3__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C69S20846C13__A1__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C13__9S20846C10[4]),  4,7},
  {&(_tg__ZTV8S20846C6__9S20846C13__9S20846C10[3]),  3,7},
  {&(_tg__ZTV8S20846C4__A2__9S20846C13__9S20846C10[4]),  4,6},
  {&(_tg__ZTV8S20846C4__A4__9S20846C10[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A4__9S20846C10[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C10[];
extern  VTBL_ENTRY _ZTV9S20846C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C10[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N9S20846C11D0Ev,_ZThn7816_N9S20846C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10568_N9S20846C11D1Ev,_ZThn7816_N9S20846C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N9S20846C11D0Ev,_ZThn7900_N9S20846C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10664_N9S20846C11D1Ev,_ZThn7900_N9S20846C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C6D0Ev,_ZThn8044_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C6D1Ev,_ZThn8044_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C2D0Ev,_ZThn8044_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C2D1Ev,_ZThn8044_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C4D0Ev,_ZThn8044_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N8S20846C4D1Ev,_ZThn8044_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N9S20846C10D0Ev,_ZThn8188_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11088_N9S20846C10D1Ev,_ZThn8188_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N9S20846C10D0Ev,_ZThn9316_N9S20846C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N9S20846C10D0Ev,_ZThn8128_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12624_N9S20846C10D1Ev,_ZThn9316_N9S20846C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10984_N9S20846C10D1Ev,_ZThn8128_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N9S20846C10D0Ev,_ZThn9340_N9S20846C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N9S20846C10D0Ev,_ZThn8044_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12656_N9S20846C10D1Ev,_ZThn9340_N9S20846C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn10888_N9S20846C10D1Ev,_ZThn8044_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C10 = {  "S20846C10", // class name
  bases_S20846C10, 17,
  &(vtc_S20846C10[0]), // expected_vtbl_contents
  &(vtt_S20846C10[0]), // expected_vtt_contents
  ABISELECT(12864,9488), // object size
  NSPAIRA(_ZTI9S20846C10),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20846C10),67, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C10),38, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C18  : S3052C12 , virtual S20846C3 , virtual S20846C2 {
  ::S20846C2 s20846c18f0[2];
  long double s20846c18f1;
  ::S3052C12 s20846c18f2;
  void *s20846c18f3[3];
  ::S20846C6 s20846c18f4;
  int s20846c18f5;
  ::S3052C16 s20846c18f6;
  int s20846c18f7;
  virtual void  v7(); // _ZN9S20846C182v7Ev
  ~S20846C18(); // tgen
  S20846C18(); // tgen
};
//SIG(-1 S20846C18) C1{ BC2{ vd m FC3{ VBC4{ vd v7 Fs[6] FL[8] Fi} BC5{ VBC4 FL Fp FL:54} v5 v6 Fc:0 Fp[8] Fc}} VBC6{ vd v2 Fs[6] FL[8] Fi} VBC7{ VBC6 BC8{ VBC6 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} v1 FC7[2] FD FC2 Fp[3] FC9{ VBC6 BC7 Fp[3] Fc:8 Fi[2] Fc FC6 Fp[3] FL[5] Fi} Fi FU10{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi}


void  S20846C18 ::v7(){vfunc_called(this, "_ZN9S20846C182v7Ev");}
S20846C18 ::~S20846C18(){ note_dtor("S20846C18", this);} // tgen
S20846C18 ::S20846C18(){ note_ctor("S20846C18", this);} // tgen

static void Test_S20846C18()
{
  extern Class_Descriptor cd_S20846C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(95,272)];
    init_test(&cd_S20846C18, buf);
    S20846C18 *dp, &lv = *(dp=new (buf) S20846C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1504,1084), "sizeof(S20846C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C18)");
    check_base_class_offset(lv, (S3052C12*), 0, "S20846C18");
    check_base_class_offset(lv, (S20846C3*), ABISELECT(1296,940), "S20846C18");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(1296,940), "S20846C18");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(1296,940), "S20846C18");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(1392,1024), "S20846C18");
    check_base_class_offset(lv, (S20846C2*), ABISELECT(1392,1024), "S20846C18");
    check_field_offset(lv, s20846c18f0, ABISELECT(208,148), "S20846C18.s20846c18f0");
    check_field_offset(lv, s20846c18f1, ABISELECT(608,436), "S20846C18.s20846c18f1");
    check_field_offset(lv, s20846c18f2, ABISELECT(624,448), "S20846C18.s20846c18f2");
    check_field_offset(lv, s20846c18f3, ABISELECT(832,596), "S20846C18.s20846c18f3");
    check_field_offset(lv, s20846c18f4, ABISELECT(856,608), "S20846C18.s20846c18f4");
    check_field_offset(lv, s20846c18f5, ABISELECT(1264,920), "S20846C18.s20846c18f5");
    check_field_offset(lv, s20846c18f6, ABISELECT(1272,924), "S20846C18.s20846c18f6");
    check_field_offset(lv, s20846c18f7, ABISELECT(1288,936), "S20846C18.s20846c18f7");
    test_class_info(&lv, &cd_S20846C18);
    dp->~S20846C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C18(Test_S20846C18, "S20846C18", ABISELECT(1504,1084));

#else // __cplusplus

extern void _ZN9S20846C18C1Ev();
extern void _ZN9S20846C18D1Ev();
Name_Map name_map_S20846C18[] = {
  NSPAIR(_ZN9S20846C18C1Ev),
  NSPAIR(_ZN9S20846C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
static Base_Class bases_S20846C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C3,    ABISELECT(1296,940), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(1392,1024), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C18[];
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn1296_N9S20846C18D1Ev,_ZThn940_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn1296_N9S20846C18D0Ev,_ZThn940_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn1392_N9S20846C18D1Ev,_ZThn1024_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn1392_N9S20846C18D0Ev,_ZThn1024_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY vtc_S20846C18[] = {
  ABISELECT(1392,1024),
  ABISELECT(1296,940),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  0,
  ABISELECT(-1296,-940),
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-1392,-1024),
  ABISELECT(-96,-84),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern VTBL_ENTRY _ZTV9S20846C18[];
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C18[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C18[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C18[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C18[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C18[] = {
  {&(_ZTV9S20846C18[4]),  4,24},
  {&(_ZTV9S20846C18[11]),  11,24},
  {&(_ZTV9S20846C18[20]),  20,24},
  {&(_tg__ZTV8S20846C2__9S20846C18[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C18[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C18[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C18[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1392_N9S20846C18D0Ev,_ZThn1024_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1392_N9S20846C18D1Ev,_ZThn1024_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N9S20846C18D0Ev,_ZThn940_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N9S20846C18D1Ev,_ZThn940_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C18 = {  "S20846C18", // class name
  bases_S20846C18, 4,
  &(vtc_S20846C18[0]), // expected_vtbl_contents
  &(vtt_S20846C18[0]), // expected_vtt_contents
  ABISELECT(1504,1084), // object size
  NSPAIRA(_ZTI9S20846C18),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20846C18),24, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C18),7, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C17  : virtual S20846C2 , virtual S20846C11 , S20846C18 {
  void *s20846c17f0;
  ::S3052C22_nt s20846c17f1;
  ::S20846C3 s20846c17f2;
  __tsi64 s20846c17f3;
  ::S3052C13 s20846c17f4;
  __tsi64 s20846c17f5[6];
  __tsi64 s20846c17f6;
  ::S20846C6 s20846c17f7;
  virtual void  v8(); // _ZN9S20846C172v8Ev
  ~S20846C17(); // tgen
  S20846C17(); // tgen
};
//SIG(-1 S20846C17) C1{ VBC2{ VBC3{ vd v2 Fs[6] FL[8] Fi} BC4{ VBC3 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} VBC5{ BC6{ m Fp Fi FL Fp Fi} VBC2 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC7{ VBC3 BC2 BC8{ VBC3 BC2 Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} BC9{ vd m FC10{ VBC11{ vd v8 Fs[6] FL[8] Fi} BC12{ VBC11 FL Fp FL:54} v6 v7 Fc:0 Fp[8] Fc}} VBC4 Fp Fl FC8 FC9 FC4 Fi[2] FU13{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC14{ BC9 VBC3 VBC2 v5 FC2[2] FD FC9 Fp[3] FC8 Fi FU15{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v1 Fp FC16{} FC3 FL FU13 FL[6] FL FC8}


void  S20846C17 ::v8(){vfunc_called(this, "_ZN9S20846C172v8Ev");}
S20846C17 ::~S20846C17(){ note_dtor("S20846C17", this);} // tgen
S20846C17 ::S20846C17(){ note_ctor("S20846C17", this);} // tgen

static void Test_S20846C17()
{
  extern Class_Descriptor cd_S20846C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(764,2264)];
    init_test(&cd_S20846C17, buf);
    S20846C17 *dp, &lv = *(dp=new (buf) S20846C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12208,9052), "sizeof(S20846C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C17)");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(2008,1480), "S20846C17");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(2008,1480), "S20846C17");
    check_base_class_offset(lv, (S20846C3*)(S20846C18*), ABISELECT(2008,1480), "S20846C17");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(1904,1420), "S20846C17");
    check_base_class_offset(lv, (S20846C2*), ABISELECT(1904,1420), "S20846C17");
    check_base_class_offset(lv, (S20846C2*)(S20846C11*), ABISELECT(1904,1420), "S20846C17");
    check_base_class_offset(lv, (S20846C2*)(S20846C18*), ABISELECT(1904,1420), "S20846C17");
    check_base_class_offset(lv, (S3052C10*)(S20846C11*), ABISELECT(2120,1568), "S20846C17");
    check_base_class_offset(lv, (S20846C11*), ABISELECT(2112,1564), "S20846C17");
    check_base_class_offset(lv, (S3052C12*)(S20846C18*), 0, "S20846C17");
    check_base_class_offset(lv, (S20846C18*), 0, "S20846C17");
    check_field_offset(lv, s20846c17f0, ABISELECT(1296,940), "S20846C17.s20846c17f0");
    check_field_offset(lv, s20846c17f1, ABISELECT(1304,944), "S20846C17.s20846c17f1");
    check_field_offset(lv, s20846c17f2, ABISELECT(1312,948), "S20846C17.s20846c17f2");
    check_field_offset(lv, s20846c17f3, ABISELECT(1408,1032), "S20846C17.s20846c17f3");
    check_field_offset(lv, s20846c17f4, ABISELECT(1424,1040), "S20846C17.s20846c17f4");
    check_field_offset(lv, s20846c17f5, ABISELECT(1440,1052), "S20846C17.s20846c17f5");
    check_field_offset(lv, s20846c17f6, ABISELECT(1488,1100), "S20846C17.s20846c17f6");
    check_field_offset(lv, s20846c17f7, ABISELECT(1496,1108), "S20846C17.s20846c17f7");
    test_class_info(&lv, &cd_S20846C17);
    dp->~S20846C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C17(Test_S20846C17, "S20846C17", ABISELECT(12208,9052));

#else // __cplusplus

extern void _ZN9S20846C17C1Ev();
extern void _ZN9S20846C17D1Ev();
Name_Map name_map_S20846C17[] = {
  NSPAIR(_ZN9S20846C17C1Ev),
  NSPAIR(_ZN9S20846C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C11;
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C18;
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
static Base_Class bases_S20846C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(2008,1480), //bcp->offset
    19, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20846C4,    ABISELECT(1904,1420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(1904,1420), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C10,    ABISELECT(2120,1568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20846C11,    ABISELECT(2112,1564), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20846C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C17[];
extern void _ZN9S20846C17D1Ev();
extern void _ZN9S20846C17D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C172v8Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn2008_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn2008_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn2112_N9S20846C17D1Ev,_ZThn1564_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn2112_N9S20846C17D0Ev,_ZThn1564_N9S20846C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C17[] = {
  ABISELECT(2112,1564),
  ABISELECT(1904,1420),
  ABISELECT(2008,1480),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&_ZN9S20846C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C17D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C172v8Ev,
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(104,60),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-2008,-1480),
  ABISELECT(-2008,-1480),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(-2112,-1564),
  ABISELECT(-104,-84),
  ABISELECT(-208,-144),
  ABISELECT(-2112,-1564),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C17[];
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C18__9S20846C17[] = {
  ABISELECT(1904,1420),
  ABISELECT(2008,1480),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn2008_N9S20846C18D1Ev,_ZThn1480_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn2008_N9S20846C18D0Ev,_ZThn1480_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C18__9S20846C17[] = {
  0,
  ABISELECT(-2008,-1480),
  ABISELECT(-2008,-1480),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C18__9S20846C17[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(104,60),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C17[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C17[] = {
  ABISELECT(104,60),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C17[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C17[] = {
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C17[] = {
  ABISELECT(-104,-84),
  ABISELECT(-208,-144),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C11__9S20846C17[] = {
  0,
  0,
  ABISELECT(208,144),
  ABISELECT(104,60),
  ABISELECT(208,144),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C11__9S20846C17[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C17[] = {
  {&(_ZTV9S20846C17[5]),  5,33},
  {&(_tg__ZTV9S20846C18__9S20846C17[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C18__9S20846C17[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C18__9S20846C17[6]),  6,10},
  {&(_ZTV9S20846C17[15]),  15,33},
  {&(_ZTV9S20846C17[23]),  23,33},
  {&(_ZTV9S20846C17[31]),  31,33},
  {&(_tg__ZTV8S20846C2__9S20846C17[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C17[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C17[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C17[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C17[4]),  4,6},
  {&(_tg__ZTV8S20846C2__9S20846C11__9S20846C17[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C11__9S20846C17[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C17[];
extern  VTBL_ENTRY _ZTV9S20846C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C17[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D0Ev,_ZThn60_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C2D1Ev,_ZThn60_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D0Ev,_ZThn60_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N8S20846C4D1Ev,_ZThn60_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N9S20846C18D0Ev,_ZThn1480_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N9S20846C18D1Ev,_ZThn1480_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N9S20846C17D0Ev,_ZThn1564_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N9S20846C17D1Ev,_ZThn1564_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2008_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C17 = {  "S20846C17", // class name
  bases_S20846C17, 7,
  &(vtc_S20846C17[0]), // expected_vtbl_contents
  &(vtt_S20846C17[0]), // expected_vtt_contents
  ABISELECT(12208,9052), // object size
  NSPAIRA(_ZTI9S20846C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20846C17),33, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C17),14, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C20  : S20846C18 , virtual S20846C4 , S20846C3 , S20846C7 {
  ::S20846C3 s20846c20f0[9];
  char s20846c20f1;
  int s20846c20f2;
  int s20846c20f3;
  int s20846c20f4;
  char s20846c20f5;
  virtual void  v9(); // _ZN9S20846C202v9Ev
  ~S20846C20(); // tgen
  S20846C20(); // tgen
};
//SIG(-1 S20846C20) C1{ BC2{ BC3{ vd m FC4{ VBC5{ vd v8 Fs[6] FL[8] Fi} BC6{ VBC5 FL Fp FL:54} v6 v7 Fc:0 Fp[8] Fc}} VBC7{ vd v2 Fs[6] FL[8] Fi} VBC8{ VBC7 BC9{ VBC7 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} v5 FC8[2] FD FC3 Fp[3] FC10{ VBC7 BC8 Fp[3] Fc:8 Fi[2] Fc FC7 Fp[3] FL[5] Fi} Fi FU11{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} VBC9 BC7 BC12{ VBC7 BC10 VBC9 VBC8 vd Fp[7]} v1 FC7[9] Fc Fi Fi Fi Fc}


void  S20846C20 ::v9(){vfunc_called(this, "_ZN9S20846C202v9Ev");}
S20846C20 ::~S20846C20(){ note_dtor("S20846C20", this);} // tgen
S20846C20 ::S20846C20(){ note_ctor("S20846C20", this);} // tgen

static void Test_S20846C20()
{
  extern Class_Descriptor cd_S20846C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(181,557)];
    init_test(&cd_S20846C20, buf);
    S20846C20 *dp, &lv = *(dp=new (buf) S20846C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2880,2224), "sizeof(S20846C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C20)");
    check_base_class_offset(lv, (S3052C12*)(S20846C18*), 0, "S20846C20");
    check_base_class_offset(lv, (S20846C3*)(S20846C18*), ABISELECT(2648,2056), "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(2648,2056), "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(2648,2056), "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(2648,2056), "S20846C20");
    check_base_class_offset(lv, (S20846C3*)(S20846C7*), ABISELECT(2648,2056), "S20846C20");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C7*), ABISELECT(2648,2056), "S20846C20");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(2648,2056), "S20846C20");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(2648,2056), "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(2744,2140), "S20846C20");
    check_base_class_offset(lv, (S20846C2*)(S20846C18*), ABISELECT(2744,2140), "S20846C20");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C7*), ABISELECT(2744,2140), "S20846C20");
    check_base_class_offset(lv, (S20846C18*), 0, "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*), ABISELECT(2848,2200), "S20846C20");
    /*is_ambiguous_... S20846C7::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C7*), ABISELECT(2848,2200), "S20846C20");
    /*is_ambiguous_... S20846C20::S20846C3 */ AMB_check_base_class_offset(lv, (S20846C3*), ABISELECT(1296,940), "S20846C20");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(1392,1024), "S20846C20");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C7*), ABISELECT(1392,1024), "S20846C20");
    check_base_class_offset(lv, (S20846C6*)(S20846C7*), ABISELECT(1392,1024), "S20846C20");
    check_base_class_offset(lv, (S20846C7*), ABISELECT(1392,1024), "S20846C20");
    check_field_offset(lv, s20846c20f0, ABISELECT(1760,1280), "S20846C20.s20846c20f0");
    check_field_offset(lv, s20846c20f1, ABISELECT(2624,2036), "S20846C20.s20846c20f1");
    check_field_offset(lv, s20846c20f2, ABISELECT(2628,2040), "S20846C20.s20846c20f2");
    check_field_offset(lv, s20846c20f3, ABISELECT(2632,2044), "S20846C20.s20846c20f3");
    check_field_offset(lv, s20846c20f4, ABISELECT(2636,2048), "S20846C20.s20846c20f4");
    check_field_offset(lv, s20846c20f5, ABISELECT(2640,2052), "S20846C20.s20846c20f5");
    test_class_info(&lv, &cd_S20846C20);
    dp->~S20846C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C20(Test_S20846C20, "S20846C20", ABISELECT(2880,2224));

#else // __cplusplus

extern void _ZN9S20846C20C1Ev();
extern void _ZN9S20846C20D1Ev();
Name_Map name_map_S20846C20[] = {
  NSPAIR(_ZN9S20846C20C1Ev),
  NSPAIR(_ZN9S20846C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C18;
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C7;
extern VTBL_ENTRY _ZTI8S20846C7[];
extern  VTBL_ENTRY _ZTV8S20846C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C7[];
static Base_Class bases_S20846C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20846C3,    ABISELECT(2648,2056), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20846C4,    ABISELECT(2744,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(2744,2140), //bcp->offset
    30, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20846C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(2848,2200), //bcp->offset
    40, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C3,    ABISELECT(1296,940), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C4,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20846C7,    ABISELECT(1392,1024), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C20[];
extern void _ZN9S20846C20D1Ev();
extern void _ZN9S20846C20D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C202v9Ev();
extern void ABISELECT(_ZThn1296_N9S20846C20D1Ev,_ZThn940_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn1296_N9S20846C20D0Ev,_ZThn940_N9S20846C20D0Ev)();
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZThn1392_N9S20846C20D1Ev,_ZThn1024_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn1392_N9S20846C20D0Ev,_ZThn1024_N9S20846C20D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn2648_N9S20846C20D1Ev,_ZThn2056_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn2648_N9S20846C20D0Ev,_ZThn2056_N9S20846C20D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn2744_N9S20846C20D1Ev,_ZThn2140_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn2744_N9S20846C20D0Ev,_ZThn2140_N9S20846C20D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn2848_N9S20846C20D1Ev,_ZThn2200_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn2848_N9S20846C20D0Ev,_ZThn2200_N9S20846C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C20[] = {
  ABISELECT(2848,2200),
  ABISELECT(2744,2140),
  ABISELECT(2648,2056),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&_ZN9S20846C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C20D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C202v9Ev,
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N9S20846C20D1Ev,_ZThn940_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N9S20846C20D0Ev,_ZThn940_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(1352,1116),
  ABISELECT(1456,1176),
  ABISELECT(1256,1032),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C20D1Ev,_ZThn1024_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C20D0Ev,_ZThn1024_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-2648,-2056),
  ABISELECT(-2648,-2056),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-2744,-2140),
  ABISELECT(-96,-84),
  ABISELECT(-2744,-2140),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-2848,-2200),
  ABISELECT(-200,-144),
  ABISELECT(-2848,-2200),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C20[];
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C18__9S20846C20[] = {
  ABISELECT(2744,2140),
  ABISELECT(2648,2056),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn2648_N9S20846C18D1Ev,_ZThn2056_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn2648_N9S20846C18D0Ev,_ZThn2056_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C18__9S20846C20[] = {
  0,
  ABISELECT(-2648,-2056),
  ABISELECT(-2648,-2056),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn2744_N9S20846C18D1Ev,_ZThn2140_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn2744_N9S20846C18D0Ev,_ZThn2140_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C18__9S20846C20[] = {
  0,
  0,
  ABISELECT(-2744,-2140),
  ABISELECT(-96,-84),
  ABISELECT(-2744,-2140),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C7D1Ev();
extern void _ZN8S20846C7D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C7__9S20846C20[] = {
  ABISELECT(1352,1116),
  ABISELECT(1456,1176),
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&_ZN8S20846C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C68S20846C7__9S20846C20[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C68S20846C7__A1__9S20846C20[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C68S20846C7__A2__9S20846C20[] = {
  ABISELECT(1256,1032),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C4D1Ev,_ZThn1032_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C4D0Ev,_ZThn1032_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C7__A2__9S20846C20[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C2D1Ev,_ZThn1032_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C2D0Ev,_ZThn1032_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C68S20846C7__A1__9S20846C20[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C6D1Ev,_ZThn1032_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C6D0Ev,_ZThn1032_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C68S20846C7__9S20846C20[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C7D1Ev,_ZThn1032_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn1256_N8S20846C7D0Ev,_ZThn1032_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C7__9S20846C20[] = {
  0,
  ABISELECT(-1256,-1032),
  ABISELECT(-1256,-1032),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn1456_N8S20846C7D1Ev,_ZThn1176_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn1456_N8S20846C7D0Ev,_ZThn1176_N8S20846C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__8S20846C7__9S20846C20[] = {
  ABISELECT(-1456,-1176),
  ABISELECT(-200,-144),
  ABISELECT(-1456,-1176),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn1352_N8S20846C7D1Ev,_ZThn1116_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn1352_N8S20846C7D0Ev,_ZThn1116_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__8S20846C7__9S20846C20[] = {
  0,
  0,
  ABISELECT(-1352,-1116),
  ABISELECT(-96,-84),
  ABISELECT(-1352,-1116),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C20[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C20[] = {
  ABISELECT(-96,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C20[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C20[] = {
  0,
  ABISELECT(96,84),
  ABISELECT(96,84),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__9S20846C20[] = {
  ABISELECT(-200,-144),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A1__9S20846C20[] = {
  0,
  ABISELECT(200,144),
  ABISELECT(200,144),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C20[] = {
  {&(_ZTV9S20846C20[5]),  5,46},
  {&(_tg__ZTV9S20846C18__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C18__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C18__9S20846C20[6]),  6,10},
  {&(_tg__ZTV8S20846C7__9S20846C20[5]),  5,9},
  {&(_tg__ZTV8S20846C68S20846C7__9S20846C20[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C68S20846C7__A1__9S20846C20[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C68S20846C7__A2__9S20846C20[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C7__A2__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C68S20846C7__A1__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C68S20846C7__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C7__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A1__8S20846C7__9S20846C20[4]),  4,6},
  {&(_tg__ZTV8S20846C2__A1__8S20846C7__9S20846C20[6]),  6,10},
  {&(_ZTV9S20846C20[27]),  27,46},
  {&(_ZTV9S20846C20[36]),  36,46},
  {&(_ZTV9S20846C20[44]),  44,46},
  {&(_ZTV9S20846C20[19]),  19,46},
  {&(_tg__ZTV8S20846C2__9S20846C20[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C20[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C20[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A1__9S20846C20[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A1__9S20846C20[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C20[];
extern  VTBL_ENTRY _ZTV9S20846C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C20[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S20846C7D0Ev,_ZThn1116_N8S20846C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1456_N8S20846C7D0Ev,_ZThn1176_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S20846C7D1Ev,_ZThn1116_N8S20846C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1456_N8S20846C7D1Ev,_ZThn1176_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C7D0Ev,_ZThn1032_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C7D1Ev,_ZThn1032_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C6D0Ev,_ZThn1032_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C6D1Ev,_ZThn1032_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C2D0Ev,_ZThn1032_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C2D1Ev,_ZThn1032_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C4D0Ev,_ZThn1032_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1256_N8S20846C4D1Ev,_ZThn1032_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N9S20846C18D0Ev,_ZThn2140_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N9S20846C18D1Ev,_ZThn2140_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N9S20846C18D0Ev,_ZThn2056_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N9S20846C18D1Ev,_ZThn2056_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2848_N9S20846C20D0Ev,_ZThn2200_N9S20846C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N9S20846C20D0Ev,_ZThn2140_N9S20846C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2848_N9S20846C20D1Ev,_ZThn2200_N9S20846C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2744_N9S20846C20D1Ev,_ZThn2140_N9S20846C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N9S20846C20D0Ev,_ZThn2056_N9S20846C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2648_N9S20846C20D1Ev,_ZThn2056_N9S20846C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C20 = {  "S20846C20", // class name
  bases_S20846C20, 11,
  &(vtc_S20846C20[0]), // expected_vtbl_contents
  &(vtt_S20846C20[0]), // expected_vtt_contents
  ABISELECT(2880,2224), // object size
  NSPAIRA(_ZTI9S20846C20),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20846C20),46, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C20),24, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C16  : virtual S20846C3 , virtual S20846C17 , S20846C20 {
  ::S20846C13 s20846c16f0;
  ::S3052C13 s20846c16f1;
  int s20846c16f2;
  char s20846c16f3;
  virtual  ~S20846C16(); // _ZN9S20846C16D2Ev
  S20846C16(); // tgen
};
//SIG(-1 S20846C16) C1{ VBC2{ vd v1 Fs[6] FL[8] Fi} VBC3{ VBC4{ VBC2 BC5{ VBC2 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} VBC6{ BC7{ m Fp Fi FL Fp Fi} VBC4 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC8{ VBC2 BC4 BC9{ VBC2 BC4 Fp[3] Fc:8 Fi[2] Fc FC2 Fp[3] FL[5] Fi} BC10{ vd m FC11{ VBC12{ vd v9 Fs[6] FL[8] Fi} BC13{ VBC12 FL Fp FL:54} v7 v8 Fc:0 Fp[8] Fc}} VBC5 Fp Fl FC9 FC10 FC5 Fi[2] FU14{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC15{ BC10 VBC2 VBC4 v4 FC4[2] FD FC10 Fp[3] FC9 Fi FU16{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v5 Fp FC17{} FC2 FL FU14 FL[6] FL FC9} BC18{ BC15 VBC5 BC2 BC19{ VBC2 BC9 VBC5 VBC4 vd Fp[7]} v6 FC2[9] Fc Fi Fi Fi Fc} vd FC8 FU14 Fi Fc}


 S20846C16 ::~S20846C16(){ note_dtor("S20846C16", this);}
S20846C16 ::S20846C16(){ note_ctor("S20846C16", this);} // tgen

static void Test_S20846C16()
{
  extern Class_Descriptor cd_S20846C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1038,3098)];
    init_test(&cd_S20846C16, buf);
    S20846C16 *dp, &lv = *(dp=new (buf) S20846C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16592,12388), "sizeof(S20846C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C16)");
    /*is_ambiguous_... S20846C16::S20846C3 */ AMB_check_base_class_offset(lv, (S20846C3*), ABISELECT(4344,3312), "S20846C16");
    /*is_ambiguous_... S20846C16::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(4344,3312), "S20846C16");
    /*is_ambiguous_... S20846C16::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C18*)(S20846C17*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C18*)(S20846C20*), ABISELECT(4344,3312), "S20846C16");
    /*is_ambiguous_... S20846C16::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C7*)(S20846C20*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(4344,3312), "S20846C16");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(4344,3312), "S20846C16");
    /*is_ambiguous_... S20846C16::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(6352,4816), "S20846C16");
    check_base_class_offset(lv, (S20846C2*)(S20846C17*), ABISELECT(6352,4816), "S20846C16");
    check_base_class_offset(lv, (S20846C2*)(S20846C11*), ABISELECT(6352,4816), "S20846C16");
    check_base_class_offset(lv, (S20846C2*)(S20846C18*)(S20846C17*), ABISELECT(6352,4816), "S20846C16");
    check_base_class_offset(lv, (S20846C2*)(S20846C18*)(S20846C20*), ABISELECT(6352,4816), "S20846C16");
    /*is_ambiguous_... S20846C7::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C7*)(S20846C20*), ABISELECT(6352,4816), "S20846C16");
    check_base_class_offset(lv, (S3052C10*)(S20846C11*), ABISELECT(6472,4880), "S20846C16");
    check_base_class_offset(lv, (S20846C11*)(S20846C17*), ABISELECT(6464,4876), "S20846C16");
    check_base_class_offset(lv, (S3052C12*)(S20846C18*)(S20846C17*), ABISELECT(4448,3396), "S20846C16");
    check_base_class_offset(lv, (S20846C18*)(S20846C17*), ABISELECT(4448,3396), "S20846C16");
    check_base_class_offset(lv, (S20846C17*), ABISELECT(4448,3396), "S20846C16");
    check_base_class_offset(lv, (S3052C12*)(S20846C18*)(S20846C20*), 0, "S20846C16");
    check_base_class_offset(lv, (S20846C18*)(S20846C20*), 0, "S20846C16");
    /*is_ambiguous_... S20846C20::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C20*), ABISELECT(16560,12364), "S20846C16");
    /*is_ambiguous_... S20846C7::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C7*)(S20846C20*), ABISELECT(16560,12364), "S20846C16");
    /*is_ambiguous_... S20846C20::S20846C3 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C20*), ABISELECT(1296,940), "S20846C16");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(1392,1024), "S20846C16");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(1392,1024), "S20846C16");
    check_base_class_offset(lv, (S20846C6*)(S20846C7*)(S20846C20*), ABISELECT(1392,1024), "S20846C16");
    check_base_class_offset(lv, (S20846C7*)(S20846C20*), ABISELECT(1392,1024), "S20846C16");
    check_base_class_offset(lv, (S20846C20*), 0, "S20846C16");
    check_field_offset(lv, s20846c16f0, ABISELECT(2656,2056), "S20846C16.s20846c16f0");
    check_field_offset(lv, s20846c16f1, ABISELECT(4320,3292), "S20846C16.s20846c16f1");
    check_field_offset(lv, s20846c16f2, ABISELECT(4336,3304), "S20846C16.s20846c16f2");
    check_field_offset(lv, s20846c16f3, ABISELECT(4340,3308), "S20846C16.s20846c16f3");
    test_class_info(&lv, &cd_S20846C16);
    dp->~S20846C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C16(Test_S20846C16, "S20846C16", ABISELECT(16592,12388));

#else // __cplusplus

extern void _ZN9S20846C16C1Ev();
extern void _ZN9S20846C16D2Ev();
Name_Map name_map_S20846C16[] = {
  NSPAIR(_ZN9S20846C16C1Ev),
  NSPAIR(_ZN9S20846C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C11;
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C18;
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
extern Class_Descriptor cd_S20846C17;
extern VTBL_ENTRY _ZTI9S20846C17[];
extern  VTBL_ENTRY _ZTV9S20846C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C17[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C18;
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C7;
extern VTBL_ENTRY _ZTI8S20846C7[];
extern  VTBL_ENTRY _ZTV8S20846C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C7[];
extern Class_Descriptor cd_S20846C20;
extern VTBL_ENTRY _ZTI9S20846C20[];
extern  VTBL_ENTRY _ZTV9S20846C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C20[];
static Base_Class bases_S20846C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(4344,3312), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(6352,4816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(6352,4816), //bcp->offset
    44, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(6472,4880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20846C11,    ABISELECT(6464,4876), //bcp->offset
    54, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(4448,3396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20846C18,    ABISELECT(4448,3396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20846C17,    ABISELECT(4448,3396), //bcp->offset
    32, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3052C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20846C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(16560,12364), //bcp->offset
    61, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S20846C3,    ABISELECT(1296,940), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(1392,1024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20846C7,    ABISELECT(1392,1024), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20846C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C16[];
extern void _ZN9S20846C16D1Ev();
extern void _ZN9S20846C16D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C202v9Ev();
extern void ABISELECT(_ZThn1296_N9S20846C16D1Ev,_ZThn940_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn1296_N9S20846C16D0Ev,_ZThn940_N9S20846C16D0Ev)();
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZThn1392_N9S20846C16D1Ev,_ZThn1024_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn1392_N9S20846C16D0Ev,_ZThn1024_N9S20846C16D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C16D1Ev,_ZTv0_n12_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C16D1Ev,_ZThn3312_N9S20846C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C16D0Ev,_ZTv0_n12_N9S20846C16D0Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C16D0Ev,_ZThn3312_N9S20846C16D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S20846C16D1Ev,_ZTv0_n24_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn4448_N9S20846C16D1Ev,_ZThn3396_N9S20846C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20846C16D0Ev,_ZTv0_n24_N9S20846C16D0Ev)();
extern void ABISELECT(_ZThn4448_N9S20846C16D0Ev,_ZThn3396_N9S20846C16D0Ev)() __attribute__((weak));
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C172v8Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C16D1Ev,_ZTv0_n16_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C16D1Ev,_ZThn4816_N9S20846C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C16D0Ev,_ZTv0_n16_N9S20846C16D0Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C16D0Ev,_ZThn4816_N9S20846C16D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n40_N9S20846C16D1Ev,_ZTv0_n20_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn6464_N9S20846C16D1Ev,_ZThn4876_N9S20846C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C16D0Ev,_ZTv0_n20_N9S20846C16D0Ev)();
extern void ABISELECT(_ZThn6464_N9S20846C16D0Ev,_ZThn4876_N9S20846C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C16D1Ev,_ZTv0_n16_N9S20846C16D1Ev)();
extern void ABISELECT(_ZThn16560_N9S20846C16D1Ev,_ZThn12364_N9S20846C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C16D0Ev,_ZTv0_n16_N9S20846C16D0Ev)();
extern void ABISELECT(_ZThn16560_N9S20846C16D0Ev,_ZThn12364_N9S20846C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C16[] = {
  ABISELECT(6464,4876),
  ABISELECT(4448,3396),
  ABISELECT(16560,12364),
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&_ZN9S20846C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C202v9Ev,
  ABISELECT(-1296,-940),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N9S20846C16D1Ev,_ZThn940_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N9S20846C16D0Ev,_ZThn940_N9S20846C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C16D1Ev,_ZThn1024_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C16D0Ev,_ZThn1024_N9S20846C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C16D1Ev,_ZTv0_n12_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C16D0Ev,_ZTv0_n12_N9S20846C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-4448,-3396),
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  ABISELECT(-4448,-3396),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20846C16D1Ev,_ZTv0_n24_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20846C16D0Ev,_ZTv0_n24_N9S20846C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C172v8Ev,
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C16D1Ev,_ZTv0_n16_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C16D0Ev,_ZTv0_n16_N9S20846C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-6464,-4876),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-6464,-4876),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C16D1Ev,_ZTv0_n20_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C16D0Ev,_ZTv0_n20_N9S20846C16D0Ev),
  ABISELECT(-16560,-12364),
  ABISELECT(-12216,-9052),
  ABISELECT(-16560,-12364),
  (VTBL_ENTRY)&(_ZTI9S20846C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C16D1Ev,_ZTv0_n16_N9S20846C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C16D0Ev,_ZTv0_n16_N9S20846C16D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C16[];
extern void _ZN9S20846C20D1Ev();
extern void _ZN9S20846C20D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C202v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C20__9S20846C16[] = {
  ABISELECT(16560,12364),
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&_ZN9S20846C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C20D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C202v9Ev,
};
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C189S20846C20__A1__9S20846C16[] = {
  ABISELECT(6352,4816),
  ABISELECT(4344,3312),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C18D1Ev,_ZThn3312_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C18D0Ev,_ZThn3312_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C189S20846C20__A1__9S20846C16[] = {
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C18D1Ev,_ZThn4816_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C18D0Ev,_ZThn4816_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C189S20846C20__A1__9S20846C16[] = {
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C7D1Ev();
extern void _ZN8S20846C7D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C79S20846C20__9S20846C16[] = {
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&_ZN8S20846C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C68S20846C79S20846C20__9S20846C16[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C68S20846C79S20846C20__A1__9S20846C16[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C68S20846C79S20846C20__A2__9S20846C16[] = {
  ABISELECT(2952,2288),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C4D1Ev,_ZThn2288_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C4D0Ev,_ZThn2288_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C79S20846C20__A2__9S20846C16[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C2D1Ev,_ZThn2288_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C2D0Ev,_ZThn2288_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C68S20846C79S20846C20__A1__9S20846C16[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C6D1Ev,_ZThn2288_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C6D0Ev,_ZThn2288_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C68S20846C79S20846C20__9S20846C16[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C7D1Ev,_ZThn2288_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn2952_N8S20846C7D0Ev,_ZThn2288_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C79S20846C20__9S20846C16[] = {
  0,
  ABISELECT(-2952,-2288),
  ABISELECT(-2952,-2288),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn15168_N8S20846C7D1Ev,_ZThn11340_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn15168_N8S20846C7D0Ev,_ZThn11340_N8S20846C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__8S20846C79S20846C20__9S20846C16[] = {
  ABISELECT(-15168,-11340),
  ABISELECT(-12216,-9052),
  ABISELECT(-15168,-11340),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev)();
extern void ABISELECT(_ZThn4960_N8S20846C7D1Ev,_ZThn3792_N8S20846C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev)();
extern void ABISELECT(_ZThn4960_N8S20846C7D0Ev,_ZThn3792_N8S20846C7D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__8S20846C79S20846C20__9S20846C16[] = {
  0,
  0,
  ABISELECT(-4960,-3792),
  ABISELECT(-2008,-1504),
  ABISELECT(-4960,-3792),
  (VTBL_ENTRY)&(_ZTI8S20846C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C20D1Ev,_ZThn3312_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn4344_N9S20846C20D0Ev,_ZThn3312_N9S20846C20D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C20__9S20846C16[] = {
  0,
  ABISELECT(-4344,-3312),
  ABISELECT(-4344,-3312),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C20D1Ev,_ZThn4816_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn6352_N9S20846C20D0Ev,_ZThn4816_N9S20846C20D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C20__9S20846C16[] = {
  0,
  0,
  ABISELECT(-6352,-4816),
  ABISELECT(-2008,-1504),
  ABISELECT(-6352,-4816),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn16560_N9S20846C20D1Ev,_ZThn12364_N9S20846C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev)();
extern void ABISELECT(_ZThn16560_N9S20846C20D0Ev,_ZThn12364_N9S20846C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__9S20846C20__9S20846C16[] = {
  ABISELECT(-16560,-12364),
  ABISELECT(-12216,-9052),
  ABISELECT(-16560,-12364),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev),
};
extern void ABISELECT(_ZThn1392_N9S20846C20D1Ev,_ZThn1024_N9S20846C20D1Ev)();
extern void ABISELECT(_ZThn1392_N9S20846C20D0Ev,_ZThn1024_N9S20846C20D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C7__9S20846C20__9S20846C16[] = {
  ABISELECT(4960,3792),
  ABISELECT(15168,11340),
  ABISELECT(2952,2288),
  ABISELECT(-1392,-1024),
  (VTBL_ENTRY)&(_ZTI9S20846C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C20D1Ev,_ZThn1024_N9S20846C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1392_N9S20846C20D0Ev,_ZThn1024_N9S20846C20D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN9S20846C17D1Ev();
extern void _ZN9S20846C17D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C172v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C17__9S20846C16[] = {
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&_ZN9S20846C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C17D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C172v8Ev,
};
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C189S20846C17__9S20846C16[] = {
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C189S20846C17__9S20846C16[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C189S20846C17__9S20846C16[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C17__9S20846C16[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C17__9S20846C16[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn2016_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn2016_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C17__9S20846C16[] = {
  ABISELECT(-2016,-1480),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-2016,-1480),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev),
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C16[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__9S20846C16[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C16[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__9S20846C16[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C16[] = {
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C11__9S20846C16[] = {
  0,
  0,
  ABISELECT(112,60),
  ABISELECT(-2008,-1504),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C11__9S20846C16[] = {
  0,
  ABISELECT(2120,1564),
  ABISELECT(2120,1564),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A1__9S20846C16[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A1__9S20846C16[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C16[] = {
  {&(_ZTV9S20846C16[7]),  7,67},
  {&(_tg__ZTV9S20846C20__9S20846C16[5]),  5,9},
  {&(_tg__ZTV9S20846C189S20846C20__A1__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C189S20846C20__A1__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C189S20846C20__A1__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C79S20846C20__9S20846C16[5]),  5,9},
  {&(_tg__ZTV8S20846C68S20846C79S20846C20__9S20846C16[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C68S20846C79S20846C20__A1__9S20846C16[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C68S20846C79S20846C20__A2__9S20846C16[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C68S20846C79S20846C20__A2__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C68S20846C79S20846C20__A1__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C68S20846C79S20846C20__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C79S20846C20__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A1__8S20846C79S20846C20__9S20846C16[4]),  4,6},
  {&(_tg__ZTV8S20846C2__A1__8S20846C79S20846C20__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C20__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C20__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C4__A1__9S20846C20__9S20846C16[4]),  4,6},
  {&(_tg__ZTV8S20846C7__9S20846C20__9S20846C16[5]),  5,9},
  {&(_ZTV9S20846C16[29]),  29,67},
  {&(_ZTV9S20846C16[40]),  40,67},
  {&(_ZTV9S20846C16[50]),  50,67},
  {&(_ZTV9S20846C16[59]),  59,67},
  {&(_ZTV9S20846C16[65]),  65,67},
  {&(_ZTV9S20846C16[21]),  21,67},
  {&(_tg__ZTV9S20846C17__9S20846C16[5]),  5,9},
  {&(_tg__ZTV9S20846C189S20846C17__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C189S20846C17__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C189S20846C17__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C2__9S20846C17__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C17__9S20846C16[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C17__9S20846C16[5]),  5,7},
  {&(_tg__ZTV8S20846C2__9S20846C16[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__9S20846C16[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__9S20846C16[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C16[4]),  4,6},
  {&(_tg__ZTV8S20846C2__9S20846C11__9S20846C16[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C11__9S20846C16[4]),  4,7},
  {&(_tg__ZTV8S20846C4__A1__9S20846C16[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A1__9S20846C16[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C16[];
extern  VTBL_ENTRY _ZTV9S20846C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C16[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C20D0Ev,_ZTv0_n16_N9S20846C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N9S20846C20D0Ev,_ZThn12364_N9S20846C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C20D0Ev,_ZThn4816_N9S20846C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C20D1Ev,_ZTv0_n16_N9S20846C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N9S20846C20D1Ev,_ZThn12364_N9S20846C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C20D1Ev,_ZThn4816_N9S20846C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C20D0Ev,_ZTv0_n12_N9S20846C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C20D0Ev,_ZThn3312_N9S20846C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C20D1Ev,_ZTv0_n12_N9S20846C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C20D1Ev,_ZThn3312_N9S20846C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D0Ev,_ZTv0_n16_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4960_N8S20846C7D0Ev,_ZThn3792_N8S20846C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15168_N8S20846C7D0Ev,_ZThn11340_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20846C7D1Ev,_ZTv0_n16_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4960_N8S20846C7D1Ev,_ZThn3792_N8S20846C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn15168_N8S20846C7D1Ev,_ZThn11340_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D0Ev,_ZTv0_n12_N8S20846C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C7D0Ev,_ZThn2288_N8S20846C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C7D1Ev,_ZTv0_n12_N8S20846C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C7D1Ev,_ZThn2288_N8S20846C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C6D0Ev,_ZThn2288_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C6D1Ev,_ZThn2288_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C2D0Ev,_ZThn2288_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C2D1Ev,_ZThn2288_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C4D0Ev,_ZThn2288_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2952_N8S20846C4D1Ev,_ZThn2288_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C18D0Ev,_ZThn4816_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C18D1Ev,_ZThn4816_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C18D0Ev,_ZThn3312_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C18D1Ev,_ZThn3312_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C16D0Ev,_ZTv0_n20_N9S20846C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6464_N9S20846C16D0Ev,_ZThn4876_N9S20846C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C16D1Ev,_ZTv0_n20_N9S20846C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6464_N9S20846C16D1Ev,_ZThn4876_N9S20846C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C16D0Ev,_ZTv0_n16_N9S20846C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N9S20846C16D0Ev,_ZThn12364_N9S20846C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C16D0Ev,_ZThn4816_N9S20846C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C16D1Ev,_ZTv0_n16_N9S20846C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16560_N9S20846C16D1Ev,_ZThn12364_N9S20846C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S20846C16D1Ev,_ZThn4816_N9S20846C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20846C16D0Ev,_ZTv0_n24_N9S20846C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4448_N9S20846C16D0Ev,_ZThn3396_N9S20846C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S20846C16D1Ev,_ZTv0_n24_N9S20846C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4448_N9S20846C16D1Ev,_ZThn3396_N9S20846C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C16D0Ev,_ZTv0_n12_N9S20846C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C16D0Ev,_ZThn3312_N9S20846C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C16D1Ev,_ZTv0_n12_N9S20846C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4344_N9S20846C16D1Ev,_ZThn3312_N9S20846C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C16 = {  "S20846C16", // class name
  bases_S20846C16, 17,
  &(vtc_S20846C16[0]), // expected_vtbl_contents
  &(vtt_S20846C16[0]), // expected_vtt_contents
  ABISELECT(16592,12388), // object size
  NSPAIRA(_ZTI9S20846C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20846C16),67, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C16),41, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C21  : virtual S20846C6 {
  void *s20846c21f0[6];
  ~S20846C21(); // tgen
  S20846C21(); // tgen
};
//SIG(-1 S20846C21) C1{ VBC2{ VBC3{ vd v1 Fs[6] FL[8] Fi} BC4{ VBC3 BC5{ VBC3 FL Fp FL:54} v2 v3 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC3 Fp[3] FL[5] Fi} Fp[6]}


S20846C21 ::~S20846C21(){ note_dtor("S20846C21", this);} // tgen
S20846C21 ::S20846C21(){ note_ctor("S20846C21", this);} // tgen

static void Test_S20846C21()
{
  extern Class_Descriptor cd_S20846C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,86)];
    init_test(&cd_S20846C21, buf);
    S20846C21 *dp, &lv = *(dp=new (buf) S20846C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,340), "sizeof(S20846C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C21)");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(368,256), "S20846C21");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(368,256), "S20846C21");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(368,256), "S20846C21");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(56,28), "S20846C21");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*), ABISELECT(56,28), "S20846C21");
    check_base_class_offset(lv, (S20846C6*), ABISELECT(56,28), "S20846C21");
    check_field_offset(lv, s20846c21f0, ABISELECT(8,4), "S20846C21.s20846c21f0");
    test_class_info(&lv, &cd_S20846C21);
    dp->~S20846C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C21(Test_S20846C21, "S20846C21", ABISELECT(464,340));

#else // __cplusplus

extern void _ZN9S20846C21C1Ev();
extern void _ZN9S20846C21D1Ev();
Name_Map name_map_S20846C21[] = {
  NSPAIR(_ZN9S20846C21C1Ev),
  NSPAIR(_ZN9S20846C21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
static Base_Class bases_S20846C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(368,256), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20846C4,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(56,28), //bcp->offset
    6, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C21[];
extern void _ZN9S20846C21D1Ev();
extern void _ZN9S20846C21D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C21D1Ev,_ZTv0_n16_N9S20846C21D1Ev)();
extern void ABISELECT(_ZThn56_N9S20846C21D1Ev,_ZThn28_N9S20846C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C21D0Ev,_ZTv0_n16_N9S20846C21D0Ev)();
extern void ABISELECT(_ZThn56_N9S20846C21D0Ev,_ZThn28_N9S20846C21D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev)();
extern void ABISELECT(_ZThn368_N9S20846C21D1Ev,_ZThn256_N9S20846C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev)();
extern void ABISELECT(_ZThn368_N9S20846C21D0Ev,_ZThn256_N9S20846C21D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY vtc_S20846C21[] = {
  ABISELECT(368,256),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&_ZN9S20846C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C21D0Ev,
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(312,228),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C21D1Ev,_ZTv0_n16_N9S20846C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C21D0Ev,_ZTv0_n16_N9S20846C21D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S20846C21[];
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C21[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__9S20846C21[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__9S20846C21[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C21[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C21[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__9S20846C21[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C21[] = {
  {&(_ZTV9S20846C21[4]),  4,23},
  {&(_ZTV9S20846C21[12]),  12,23},
  {&(_ZTV9S20846C21[20]),  20,23},
  {&(_tg__ZTV8S20846C6__9S20846C21[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__9S20846C21[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__9S20846C21[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C21[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C21[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__9S20846C21[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C21[];
extern  VTBL_ENTRY _ZTV9S20846C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C21[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N9S20846C21D0Ev,_ZThn256_N9S20846C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N9S20846C21D1Ev,_ZThn256_N9S20846C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C21D0Ev,_ZTv0_n16_N9S20846C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S20846C21D0Ev,_ZThn28_N9S20846C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C21D1Ev,_ZTv0_n16_N9S20846C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S20846C21D1Ev,_ZThn28_N9S20846C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20846C21 = {  "S20846C21", // class name
  bases_S20846C21, 4,
  &(vtc_S20846C21[0]), // expected_vtbl_contents
  &(vtt_S20846C21[0]), // expected_vtt_contents
  ABISELECT(464,340), // object size
  NSPAIRA(_ZTI9S20846C21),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20846C21),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20846C21),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C23  {
  int  :0;
  int s20846c23f1[6];
  int s20846c23f2;
  void *s20846c23f3;
  virtual void  v10(); // _ZN9S20846C233v10Ev
  ~S20846C23(); // tgen
  S20846C23(); // tgen
};
//SIG(-1 S20846C23) C1{ v1 Fi:0 Fi[7] Fp}


void  S20846C23 ::v10(){vfunc_called(this, "_ZN9S20846C233v10Ev");}
S20846C23 ::~S20846C23(){ note_dtor("S20846C23", this);} // tgen
S20846C23 ::S20846C23(){ note_ctor("S20846C23", this);} // tgen

static void Test_S20846C23()
{
  extern Class_Descriptor cd_S20846C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_S20846C23, buf);
    S20846C23 *dp, &lv = *(dp=new (buf) S20846C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(S20846C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20846C23)");
    check_field_offset(lv, s20846c23f1, ABISELECT(8,4), "S20846C23.s20846c23f1");
    check_field_offset(lv, s20846c23f2, ABISELECT(32,28), "S20846C23.s20846c23f2");
    check_field_offset(lv, s20846c23f3, ABISELECT(40,32), "S20846C23.s20846c23f3");
    test_class_info(&lv, &cd_S20846C23);
    dp->~S20846C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C23(Test_S20846C23, "S20846C23", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN9S20846C23C1Ev();
extern void _ZN9S20846C23D1Ev();
Name_Map name_map_S20846C23[] = {
  NSPAIR(_ZN9S20846C23C1Ev),
  NSPAIR(_ZN9S20846C23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20846C23[];
extern void _ZN9S20846C233v10Ev();
static  VTBL_ENTRY vtc_S20846C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C23[0]),
  (VTBL_ENTRY)&_ZN9S20846C233v10Ev,
};
extern VTBL_ENTRY _ZTI9S20846C23[];
extern  VTBL_ENTRY _ZTV9S20846C23[];
Class_Descriptor cd_S20846C23 = {  "S20846C23", // class name
  0,0,//no base classes
  &(vtc_S20846C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI9S20846C23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20846C23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20846C22  : virtual S20846C21 , virtual S20846C17 , virtual S20846C10 , S20846C23 , S20846C3 {
  int s20846c22f0;
  void *s20846c22f1;
  int s20846c22f2;
  ::S20846C11 s20846c22f3[2];
  ::S20846C4 s20846c22f4;
  long double s20846c22f5;
  int s20846c22f6[3];
  ::S3052C13 s20846c22f7;
  __tsi64 s20846c22f8;
  int s20846c22f9[2];
  int s20846c22f10;
  ::S3052C13 s20846c22f11;
  void *s20846c22f12;
  virtual void  v11(); // _ZN9S20846C223v11Ev
  ~S20846C22(); // tgen
  S20846C22(); // tgen
};
//SIG(-1 S20846C22) C1{ VBC2{ VBC3{ VBC4{ vd v2 Fs[6] FL[8] Fi} BC5{ VBC4 BC6{ VBC4 FL Fp FL:54} v3 v4 Fc:0 Fp[8] Fc} Fp[3] Fc:8 Fi[2] Fc FC4 Fp[3] FL[5] Fi} Fp[6]} VBC7{ VBC5 VBC8{ BC9{ m Fp Fi FL Fp Fi} VBC5 Fp Fc[4] Fi:11 Fp[2] Fi[6] FC10{ VBC4 BC5 BC3 BC11{ vd m FC12{ VBC13{ vd v10 Fs[6] FL[8] Fi} BC14{ VBC13 FL Fp FL:54} v8 v9 Fc:0 Fp[8] Fc}} VBC6 Fp Fl FC3 FC11 FC6 Fi[2] FU15{ m Fp Fi Fi Fi Fi:19 Fp Fc FD Fi Fs}[9]}[6]} BC16{ BC11 VBC4 VBC5 v5 FC5[2] FD FC11 Fp[3] FC3 Fi FU17{ m Fc:2 Fc Fp Fp Fp Fi Fs[6] Fc} Fi} v6 Fp FC18{} FC4 FL FU15 FL[6] FL FC3} VBC19{ BC3 VBC5 BC8 VBC10 VBC11 vd FC11[2] Fi FD FD Fc:0 Fp} BC20{ v7 Fi:0 Fi[6] Fi Fp} BC4 v1 Fi Fp Fi FC8[2] FC6 FD Fi[3] FU15 FL Fi[2] Fi FU15 Fp}


void  S20846C22 ::v11(){vfunc_called(this, "_ZN9S20846C223v11Ev");}
S20846C22 ::~S20846C22(){ note_dtor("S20846C22", this);} // tgen
S20846C22 ::S20846C22(){ note_ctor("S20846C22", this);} // tgen

static void Test_S20846C22()
{
  extern Class_Descriptor cd_S20846C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2892,8558)];
    init_test(&cd_S20846C22, buf);
    S20846C22 *dp, &lv = *(dp=new (buf) S20846C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(46256,34228), "sizeof(S20846C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20846C22)");
    /*is_ambiguous_... S20846C22::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C6*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*), ABISELECT(21368,15832), "S20846C22");
    check_base_class_offset(lv, (S20846C3*)(S20846C18*)(S20846C17*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C10*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C10*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C10*), ABISELECT(21368,15832), "S20846C22");
    check_base_class_offset(lv, (S20846C3*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    check_base_class_offset(lv, (S20846C3*)(S20846C6*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    check_base_class_offset(lv, (S20846C3*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    check_base_class_offset(lv, (S20846C3*)(S20846C4*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C3*)(S20846C4*), ABISELECT(21368,15832), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*), ABISELECT(21056,15604), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C6*), ABISELECT(21056,15604), "S20846C22");
    check_base_class_offset(lv, (S20846C6*)(S20846C21*), ABISELECT(21056,15604), "S20846C22");
    check_base_class_offset(lv, (S20846C21*), ABISELECT(21000,15576), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*), ABISELECT(23376,17336), "S20846C22");
    check_base_class_offset(lv, (S20846C2*)(S20846C17*), ABISELECT(23376,17336), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C11 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C11*), ABISELECT(23376,17336), "S20846C22");
    check_base_class_offset(lv, (S20846C2*)(S20846C18*)(S20846C17*), ABISELECT(23376,17336), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C10*), ABISELECT(23376,17336), "S20846C22");
    check_base_class_offset(lv, (S20846C2*)(S20846C11*)(S20846C10*), ABISELECT(23376,17336), "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C11 */ AMB_check_base_class_offset(lv, (S3052C10*)(S20846C11*), ABISELECT(23496,17400), "S20846C22");
    check_base_class_offset(lv, (S20846C11*)(S20846C17*), ABISELECT(23488,17396), "S20846C22");
    check_base_class_offset(lv, (S3052C12*)(S20846C18*)(S20846C17*), ABISELECT(21472,15916), "S20846C22");
    check_base_class_offset(lv, (S20846C18*)(S20846C17*), ABISELECT(21472,15916), "S20846C22");
    check_base_class_offset(lv, (S20846C17*), ABISELECT(21472,15916), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C10*), ABISELECT(33584,24884), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C10*), ABISELECT(33584,24884), "S20846C22");
    /*is_ambiguous_... S20846C10::S20846C6 */ AMB_check_base_class_offset(lv, (S20846C6*)(S20846C10*), ABISELECT(33584,24884), "S20846C22");
    check_base_class_offset(lv, (S3052C10*)(S20846C11*)(S20846C10*), ABISELECT(33912,25116), "S20846C22");
    check_base_class_offset(lv, (S20846C11*)(S20846C10*), ABISELECT(33904,25112), "S20846C22");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C13*), ABISELECT(44480,32928), "S20846C22");
    /*is_ambiguous_... S20846C13::S20846C2 */ AMB_check_base_class_offset(lv, (S20846C2*)(S20846C13*), ABISELECT(44480,32928), "S20846C22");
    check_base_class_offset(lv, (S20846C4*)(S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(44584,32988), "S20846C22");
    check_base_class_offset(lv, (S20846C2*)(S20846C6*)(S20846C13*), ABISELECT(44584,32988), "S20846C22");
    check_base_class_offset(lv, (S20846C6*)(S20846C13*), ABISELECT(44584,32988), "S20846C22");
    check_base_class_offset(lv, (S3052C12*)(S20846C13*), ABISELECT(44896,33216), "S20846C22");
    /*is_ambiguous_... S20846C13::S20846C4 */ AMB_check_base_class_offset(lv, (S20846C4*)(S20846C13*), ABISELECT(46016,34056), "S20846C22");
    check_base_class_offset(lv, (S20846C13*)(S20846C10*), ABISELECT(44480,32928), "S20846C22");
    /*is_ambiguous_... S20846C10::S3052C12 */ AMB_check_base_class_offset(lv, (S3052C12*)(S20846C10*), ABISELECT(46048,34080), "S20846C22");
    check_base_class_offset(lv, (S20846C10*), ABISELECT(33584,24884), "S20846C22");
    check_base_class_offset(lv, (S20846C23*), 0, "S20846C22");
    /*is_ambiguous_... S20846C22::S20846C3 */ AMB_check_base_class_offset(lv, (S20846C3*), ABISELECT(48,36), "S20846C22");
    check_field_offset(lv, s20846c22f0, ABISELECT(140,120), "S20846C22.s20846c22f0");
    check_field_offset(lv, s20846c22f1, ABISELECT(144,124), "S20846C22.s20846c22f1");
    check_field_offset(lv, s20846c22f2, ABISELECT(152,128), "S20846C22.s20846c22f2");
    check_field_offset(lv, s20846c22f3, ABISELECT(160,132), "S20846C22.s20846c22f3");
    check_field_offset(lv, s20846c22f4, ABISELECT(20768,15396), "S20846C22.s20846c22f4");
    check_field_offset(lv, s20846c22f5, ABISELECT(20896,15504), "S20846C22.s20846c22f5");
    check_field_offset(lv, s20846c22f6, ABISELECT(20912,15516), "S20846C22.s20846c22f6");
    check_field_offset(lv, s20846c22f7, ABISELECT(20928,15528), "S20846C22.s20846c22f7");
    check_field_offset(lv, s20846c22f8, ABISELECT(20944,15540), "S20846C22.s20846c22f8");
    check_field_offset(lv, s20846c22f9, ABISELECT(20952,15548), "S20846C22.s20846c22f9");
    check_field_offset(lv, s20846c22f10, ABISELECT(20960,15556), "S20846C22.s20846c22f10");
    check_field_offset(lv, s20846c22f11, ABISELECT(20976,15560), "S20846C22.s20846c22f11");
    check_field_offset(lv, s20846c22f12, ABISELECT(20992,15572), "S20846C22.s20846c22f12");
    test_class_info(&lv, &cd_S20846C22);
    dp->~S20846C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20846C22(Test_S20846C22, "S20846C22", ABISELECT(46256,34228));

#else // __cplusplus

extern void _ZN9S20846C22C1Ev();
extern void _ZN9S20846C22D1Ev();
Name_Map name_map_S20846C22[] = {
  NSPAIR(_ZN9S20846C22C1Ev),
  NSPAIR(_ZN9S20846C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S20846C21;
extern VTBL_ENTRY _ZTI9S20846C21[];
extern  VTBL_ENTRY _ZTV9S20846C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C21[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C11;
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C18;
extern VTBL_ENTRY _ZTI9S20846C18[];
extern  VTBL_ENTRY _ZTV9S20846C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C18[];
extern Class_Descriptor cd_S20846C17;
extern VTBL_ENTRY _ZTI9S20846C17[];
extern  VTBL_ENTRY _ZTV9S20846C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C17[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S3052C10;
extern VTBL_ENTRY _ZTI8S3052C10[];
extern Class_Descriptor cd_S20846C11;
extern VTBL_ENTRY _ZTI9S20846C11[];
extern  VTBL_ENTRY _ZTV9S20846C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C11[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C2;
extern VTBL_ENTRY _ZTI8S20846C2[];
extern  VTBL_ENTRY _ZTV8S20846C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C2[];
extern Class_Descriptor cd_S20846C6;
extern VTBL_ENTRY _ZTI8S20846C6[];
extern  VTBL_ENTRY _ZTV8S20846C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C6[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C4;
extern VTBL_ENTRY _ZTI8S20846C4[];
extern  VTBL_ENTRY _ZTV8S20846C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20846C4[];
extern Class_Descriptor cd_S20846C13;
extern VTBL_ENTRY _ZTI9S20846C13[];
extern  VTBL_ENTRY _ZTV9S20846C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C13[];
extern Class_Descriptor cd_S3052C12;
extern VTBL_ENTRY _ZTI8S3052C12[];
extern  VTBL_ENTRY _ZTV8S3052C12[];
extern Class_Descriptor cd_S20846C10;
extern VTBL_ENTRY _ZTI9S20846C10[];
extern  VTBL_ENTRY _ZTV9S20846C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C10[];
extern Class_Descriptor cd_S20846C23;
extern VTBL_ENTRY _ZTI9S20846C23[];
extern  VTBL_ENTRY _ZTV9S20846C23[];
extern Class_Descriptor cd_S20846C3;
extern VTBL_ENTRY _ZTI8S20846C3[];
extern  VTBL_ENTRY _ZTV8S20846C3[];
static Base_Class bases_S20846C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20846C3,    ABISELECT(21368,15832), //bcp->offset
    38, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20846C4,    ABISELECT(21056,15604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(21056,15604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(21056,15604), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20846C21,    ABISELECT(21000,15576), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(23376,17336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(23376,17336), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S3052C10,    ABISELECT(23496,17400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20846C11,    ABISELECT(23488,17396), //bcp->offset
    67, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(21472,15916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20846C18,    ABISELECT(21472,15916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20846C17,    ABISELECT(21472,15916), //bcp->offset
    45, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C4,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(33584,24884), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S3052C10,    ABISELECT(33912,25116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20846C11,    ABISELECT(33904,25112), //bcp->offset
    88, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(44480,32928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(44480,32928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(44584,32988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20846C2,    ABISELECT(44584,32988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20846C6,    ABISELECT(44584,32988), //bcp->offset
    105, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3052C12,    ABISELECT(44896,33216), //bcp->offset
    112, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20846C4,    ABISELECT(46016,34056), //bcp->offset
    116, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S20846C13,    ABISELECT(44480,32928), //bcp->offset
    94, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S3052C12,    ABISELECT(46048,34080), //bcp->offset
    122, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S20846C10,    ABISELECT(33584,24884), //bcp->offset
    74, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20846C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20846C3,    ABISELECT(48,36), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20846C22[];
extern void _ZN9S20846C233v10Ev();
extern void _ZN9S20846C223v11Ev();
extern void _ZN9S20846C22D1Ev();
extern void _ZN9S20846C22D0Ev();
extern void ABISELECT(_ZThn48_N9S20846C22D1Ev,_ZThn36_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn48_N9S20846C22D0Ev,_ZThn36_N9S20846C22D0Ev)();
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn21000_N9S20846C22D1Ev,_ZThn15576_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn21000_N9S20846C22D0Ev,_ZThn15576_N9S20846C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn21056_N9S20846C22D1Ev,_ZThn15604_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn21056_N9S20846C22D0Ev,_ZThn15604_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n24_N9S20846C22D1Ev,_ZTv0_n12_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn21368_N9S20846C22D1Ev,_ZThn15832_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C22D0Ev,_ZTv0_n12_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn21368_N9S20846C22D0Ev,_ZThn15832_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S20846C22D1Ev,_ZTv0_n24_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn21472_N9S20846C22D1Ev,_ZThn15916_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S20846C22D0Ev,_ZTv0_n24_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn21472_N9S20846C22D0Ev,_ZThn15916_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C172v8Ev();
extern void ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn23376_N9S20846C22D1Ev,_ZThn17336_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn23376_N9S20846C22D0Ev,_ZThn17336_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn23488_N9S20846C22D1Ev,_ZThn17396_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn23488_N9S20846C22D0Ev,_ZThn17396_N9S20846C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S20846C22D1Ev,_ZTv0_n32_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn33584_N9S20846C22D1Ev,_ZThn24884_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S20846C22D0Ev,_ZTv0_n32_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn33584_N9S20846C22D0Ev,_ZThn24884_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTvn320_n64_N9S20846C22D1Ev,_ZTvn228_n32_N9S20846C22D1Ev)();
extern void ABISELECT(_ZTvn320_n64_N9S20846C22D0Ev,_ZTvn228_n32_N9S20846C22D0Ev)();
extern void ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn44480_N9S20846C22D1Ev,_ZThn32928_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn44480_N9S20846C22D0Ev,_ZThn32928_N9S20846C22D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTvn104_n40_N9S20846C22D1Ev,_ZTvn60_n20_N9S20846C22D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N9S20846C22D0Ev,_ZTvn60_n20_N9S20846C22D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
extern void ABISELECT(_ZTvn416_n40_N9S20846C22D1Ev,_ZTvn288_n20_N9S20846C22D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N9S20846C22D0Ev,_ZTvn288_n20_N9S20846C22D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn46016_N9S20846C22D1Ev,_ZThn34056_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn46016_N9S20846C22D0Ev,_ZThn34056_N9S20846C22D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C22D1Ev,_ZTv0_n12_N9S20846C22D1Ev)();
extern void ABISELECT(_ZThn46048_N9S20846C22D1Ev,_ZThn34080_N9S20846C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C22D0Ev,_ZTv0_n12_N9S20846C22D0Ev)();
extern void ABISELECT(_ZThn46048_N9S20846C22D0Ev,_ZThn34080_N9S20846C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20846C22[] = {
  ABISELECT(46048,34080),
  ABISELECT(46016,34056),
  ABISELECT(44480,32928),
  ABISELECT(33584,24884),
  ABISELECT(23488,17396),
  ABISELECT(23376,17336),
  ABISELECT(21472,15916),
  ABISELECT(21368,15832),
  ABISELECT(21056,15604),
  ABISELECT(21000,15576),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&_ZN9S20846C233v10Ev,
  (VTBL_ENTRY)&_ZN9S20846C223v11Ev,
  (VTBL_ENTRY)&_ZN9S20846C22D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C22D0Ev,
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S20846C22D1Ev,_ZThn36_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S20846C22D0Ev,_ZThn36_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  ABISELECT(-21000,-15576),
  ABISELECT(368,256),
  ABISELECT(56,28),
  ABISELECT(-21000,-15576),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev),
  0,
  0,
  ABISELECT(-21056,-15604),
  ABISELECT(312,228),
  ABISELECT(-21056,-15604),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  0,
  ABISELECT(-21368,-15832),
  ABISELECT(-21368,-15832),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C22D1Ev,_ZTv0_n12_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C22D0Ev,_ZTv0_n12_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
  0,
  0,
  ABISELECT(-21472,-15916),
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  ABISELECT(-21472,-15916),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20846C22D1Ev,_ZTv0_n24_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S20846C22D0Ev,_ZTv0_n24_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C172v8Ev,
  0,
  0,
  ABISELECT(-23376,-17336),
  ABISELECT(-2008,-1504),
  ABISELECT(-23376,-17336),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-23488,-17396),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-23488,-17396),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev),
  0,
  0,
  ABISELECT(-33584,-24884),
  ABISELECT(12464,9196),
  ABISELECT(12432,9172),
  ABISELECT(10896,8044),
  ABISELECT(-10208,-7548),
  ABISELECT(-12216,-9052),
  ABISELECT(-33584,-24884),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S20846C22D1Ev,_ZTv0_n32_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S20846C22D0Ev,_ZTv0_n32_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  ABISELECT(-33904,-25112),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N9S20846C22D1Ev,_ZTvn228_n32_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn320_n64_N9S20846C22D0Ev,_ZTvn228_n32_N9S20846C22D0Ev),
  0,
  0,
  ABISELECT(-44480,-32928),
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  ABISELECT(-44480,-32928),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D1Ev,_ZTv0_n20_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C22D0Ev,_ZTv0_n20_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-23216,-17156),
  ABISELECT(-44584,-32988),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C22D1Ev,_ZTvn60_n20_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C22D0Ev,_ZTvn60_n20_N9S20846C22D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
  ABISELECT(-44896,-33216),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C22D1Ev,_ZTvn288_n20_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C22D0Ev,_ZTvn288_n20_N9S20846C22D0Ev),
  ABISELECT(-46016,-34056),
  ABISELECT(-24648,-18224),
  ABISELECT(-46016,-34056),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D1Ev,_ZTv0_n16_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C22D0Ev,_ZTv0_n16_N9S20846C22D0Ev),
  ABISELECT(-46048,-34080),
  ABISELECT(-46048,-34080),
  (VTBL_ENTRY)&(_ZTI9S20846C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C22D1Ev,_ZTv0_n12_N9S20846C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C22D0Ev,_ZTv0_n12_N9S20846C22D0Ev),
};
extern VTBL_ENTRY _ZTV9S20846C22[];
extern void _ZN9S20846C21D1Ev();
extern void _ZN9S20846C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C21__9S20846C22[] = {
  ABISELECT(368,256),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&_ZN9S20846C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C21D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C21D1Ev,_ZTv0_n16_N9S20846C21D1Ev)();
extern void ABISELECT(_ZThn56_N9S20846C21D1Ev,_ZThn28_N9S20846C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C21D0Ev,_ZTv0_n16_N9S20846C21D0Ev)();
extern void ABISELECT(_ZThn56_N9S20846C21D0Ev,_ZThn28_N9S20846C21D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C21__9S20846C22[] = {
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(312,228),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C21D1Ev,_ZTv0_n16_N9S20846C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C21D0Ev,_ZTv0_n16_N9S20846C21D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev)();
extern void ABISELECT(_ZThn368_N9S20846C21D1Ev,_ZThn256_N9S20846C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev)();
extern void ABISELECT(_ZThn368_N9S20846C21D0Ev,_ZThn256_N9S20846C21D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C21__9S20846C22[] = {
  0,
  ABISELECT(-368,-256),
  ABISELECT(-368,-256),
  (VTBL_ENTRY)&(_ZTI9S20846C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C22[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C6__9S20846C22[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C6__9S20846C22[] = {
  ABISELECT(312,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C22[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C22[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev)() __attribute__((weak));
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C6__9S20846C22[] = {
  0,
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C17D1Ev();
extern void _ZN9S20846C17D0Ev();
extern void _ZN9S20846C182v7Ev();
extern void _ZN9S20846C172v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C17__9S20846C22[] = {
  ABISELECT(2016,1480),
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&_ZN9S20846C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C17D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
  (VTBL_ENTRY)&_ZN9S20846C172v8Ev,
};
extern void _ZN9S20846C18D1Ev();
extern void _ZN9S20846C18D0Ev();
extern void _ZN9S20846C182v7Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C189S20846C17__9S20846C22[] = {
  ABISELECT(1904,1420),
  ABISELECT(-104,-84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&_ZN9S20846C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20846C182v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C189S20846C17__9S20846C22[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D1Ev,_ZTv0_n12_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C18D0Ev,_ZTv0_n12_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C189S20846C17__9S20846C22[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C17__9S20846C22[] = {
  0,
  0,
  ABISELECT(-1904,-1420),
  ABISELECT(-2008,-1504),
  ABISELECT(-1904,-1420),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C17__9S20846C22[] = {
  0,
  ABISELECT(104,84),
  ABISELECT(104,84),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D1Ev,_ZTv0_n12_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C17D0Ev,_ZTv0_n12_N9S20846C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev)();
extern void ABISELECT(_ZThn2016_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev)();
extern void ABISELECT(_ZThn2016_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C17__9S20846C22[] = {
  ABISELECT(-2016,-1480),
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  ABISELECT(-2016,-1480),
  (VTBL_ENTRY)&(_ZTI9S20846C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev),
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__9S20846C22[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C2__A1__9S20846C22[] = {
  ABISELECT(-2008,-1504),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C2__A1__9S20846C22[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C2__A1__9S20846C22[] = {
  0,
  ABISELECT(2008,1504),
  ABISELECT(2008,1504),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C22[] = {
  ABISELECT(-2120,-1564),
  ABISELECT(-112,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C11__9S20846C22[] = {
  0,
  0,
  ABISELECT(112,60),
  ABISELECT(-2008,-1504),
  ABISELECT(112,60),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C11__9S20846C22[] = {
  0,
  ABISELECT(2120,1564),
  ABISELECT(2120,1564),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C10D1Ev();
extern void _ZN9S20846C10D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C10__9S20846C22[] = {
  ABISELECT(12464,9196),
  ABISELECT(12432,9172),
  ABISELECT(10896,8044),
  ABISELECT(-10208,-7548),
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&_ZN9S20846C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C10D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C69S20846C10__A1__9S20846C22[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C69S20846C10__A2__9S20846C22[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C69S20846C10__A2__9S20846C22[] = {
  ABISELECT(-12216,-9052),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C10__A2__9S20846C22[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C69S20846C10__A2__9S20846C22[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C69S20846C10__A1__9S20846C22[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN9S20846C11D1Ev();
extern void _ZN9S20846C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C119S20846C10__A1__9S20846C22[] = {
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&_ZN9S20846C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C11D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__9S20846C119S20846C10__A1__9S20846C22[] = {
  0,
  0,
  ABISELECT(10528,7776),
  ABISELECT(-2008,-1504),
  ABISELECT(10528,7776),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D1Ev,_ZTv0_n16_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C11D0Ev,_ZTv0_n16_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C119S20846C10__A1__9S20846C22[] = {
  0,
  ABISELECT(12536,9280),
  ABISELECT(12536,9280),
  (VTBL_ENTRY)&(_ZTI9S20846C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D1Ev,_ZTv0_n12_N9S20846C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C11D0Ev,_ZTv0_n12_N9S20846C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C10__9S20846C22[] = {
  0,
  ABISELECT(12216,9052),
  ABISELECT(12216,9052),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C2__A1__9S20846C10__9S20846C22[] = {
  0,
  0,
  ABISELECT(10208,7548),
  ABISELECT(-2008,-1504),
  ABISELECT(10208,7548),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZThn320_N9S20846C10D1Ev,_ZThn228_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn320_N9S20846C10D0Ev,_ZThn228_N9S20846C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20846C11__9S20846C10__9S20846C22[] = {
  ABISELECT(-12536,-9280),
  ABISELECT(-10528,-7776),
  ABISELECT(-320,-228),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N9S20846C10D1Ev,_ZThn228_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N9S20846C10D0Ev,_ZThn228_N9S20846C10D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn10896_N9S20846C10D1Ev,_ZThn8044_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn10896_N9S20846C10D0Ev,_ZThn8044_N9S20846C10D0Ev)() __attribute__((weak));
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C13__9S20846C10__9S20846C22[] = {
  0,
  0,
  ABISELECT(-10896,-8044),
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  ABISELECT(-10896,-8044),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTvn104_n40_N9S20846C10D1Ev,_ZTvn60_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTvn104_n40_N9S20846C10D0Ev,_ZTvn60_n20_N9S20846C10D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C69S20846C13__A1__9S20846C10__9S20846C22[] = {
  ABISELECT(-23216,-17156),
  ABISELECT(-11000,-8104),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C10D1Ev,_ZTvn60_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn104_n40_N9S20846C10D0Ev,_ZTvn60_n20_N9S20846C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTvn416_n40_N9S20846C10D1Ev,_ZTvn288_n20_N9S20846C10D1Ev)();
extern void ABISELECT(_ZTvn416_n40_N9S20846C10D0Ev,_ZTvn288_n20_N9S20846C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S3052C129S20846C13__9S20846C10__9S20846C22[] = {
  ABISELECT(-11312,-8332),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C10D1Ev,_ZTvn288_n20_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn416_n40_N9S20846C10D0Ev,_ZTvn288_n20_N9S20846C10D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn12432_N9S20846C10D1Ev,_ZThn9172_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn12432_N9S20846C10D0Ev,_ZThn9172_N9S20846C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A4__9S20846C10__9S20846C22[] = {
  ABISELECT(-12432,-9172),
  ABISELECT(-24648,-18224),
  ABISELECT(-12432,-9172),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev)();
extern void ABISELECT(_ZThn12464_N9S20846C10D1Ev,_ZThn9196_N9S20846C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev)();
extern void ABISELECT(_ZThn12464_N9S20846C10D0Ev,_ZThn9196_N9S20846C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S3052C12__A1__9S20846C10__9S20846C22[] = {
  ABISELECT(-12464,-9196),
  ABISELECT(-12464,-9196),
  (VTBL_ENTRY)&(_ZTI9S20846C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev),
};
extern void _ZN9S20846C13D1Ev();
extern void _ZN9S20846C13D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV9S20846C13__9S20846C22[] = {
  ABISELECT(1536,1128),
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&_ZN9S20846C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20846C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C29S20846C13__A3__9S20846C22[] = {
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C29S20846C13__A3__9S20846C22[] = {
  ABISELECT(-23112,-17096),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C29S20846C13__A3__9S20846C22[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C29S20846C13__A3__9S20846C22[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void _ZN8S20846C6D1Ev();
extern void _ZN8S20846C6D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C69S20846C13__A2__9S20846C22[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&_ZN8S20846C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C6D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C2D1Ev();
extern void _ZN8S20846C2D0Ev();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C28S20846C69S20846C13__A4__9S20846C22[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&_ZN8S20846C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C48S20846C28S20846C69S20846C13__A4__9S20846C22[] = {
  ABISELECT(-23216,-17156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C13__A4__9S20846C22[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C28S20846C69S20846C13__A4__9S20846C22[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI8S20846C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C69S20846C13__A2__9S20846C22[] = {
  0,
  ABISELECT(23216,17156),
  ABISELECT(23216,17156),
  (VTBL_ENTRY)&(_ZTI8S20846C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__9S20846C13__9S20846C22[] = {
  0,
  ABISELECT(23112,17096),
  ABISELECT(23112,17096),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D1Ev,_ZTv0_n12_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20846C13D0Ev,_ZTv0_n12_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
extern void ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev)();
extern void _ZN8S20846C22v4Ev();
extern void _ZN8S20846C22v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C6__9S20846C13__9S20846C22[] = {
  ABISELECT(-23216,-17156),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D1Ev,_ZThn60_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N9S20846C13D0Ev,_ZThn60_N9S20846C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C22v4Ev,
  (VTBL_ENTRY)&_ZN8S20846C22v5Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev)();
extern void ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20846C4__A2__9S20846C13__9S20846C22[] = {
  ABISELECT(-1536,-1128),
  ABISELECT(-24648,-18224),
  ABISELECT(-1536,-1128),
  (VTBL_ENTRY)&(_ZTI9S20846C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev),
};
extern void _ZN8S20846C4D1Ev();
extern void _ZN8S20846C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C4__A5__9S20846C22[] = {
  ABISELECT(-24648,-18224),
  0,
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&_ZN8S20846C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20846C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev)();
extern void _ZN8S20846C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S20846C3__8S20846C4__A5__9S20846C22[] = {
  0,
  ABISELECT(24648,18224),
  ABISELECT(24648,18224),
  (VTBL_ENTRY)&(_ZTI8S20846C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20846C32v3Ev,
};
static  VTT_ENTRY vtt_S20846C22[] = {
  {&(_ZTV9S20846C22[12]),  12,127},
  {&(_ZTV9S20846C22[26]),  26,127},
  {&(_ZTV9S20846C22[34]),  34,127},
  {&(_ZTV9S20846C22[42]),  42,127},
  {&(_ZTV9S20846C22[53]),  53,127},
  {&(_ZTV9S20846C22[63]),  63,127},
  {&(_ZTV9S20846C22[72]),  72,127},
  {&(_ZTV9S20846C22[84]),  84,127},
  {&(_ZTV9S20846C22[92]),  92,127},
  {&(_ZTV9S20846C22[101]),  101,127},
  {&(_ZTV9S20846C22[108]),  108,127},
  {&(_ZTV9S20846C22[114]),  114,127},
  {&(_ZTV9S20846C22[120]),  120,127},
  {&(_ZTV9S20846C22[125]),  125,127},
  {&(_tg__ZTV9S20846C21__9S20846C22[4]),  4,6},
  {&(_tg__ZTV8S20846C6__9S20846C21__9S20846C22[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C21__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C6__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C6__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C6__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C6__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C6__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C6__9S20846C22[4]),  4,7},
  {&(_tg__ZTV9S20846C17__9S20846C22[5]),  5,9},
  {&(_tg__ZTV9S20846C189S20846C17__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C189S20846C17__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C2__9S20846C189S20846C17__9S20846C22[6]),  6,10},
  {&(_tg__ZTV8S20846C2__9S20846C17__9S20846C22[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C17__9S20846C22[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C17__9S20846C22[5]),  5,7},
  {&(_tg__ZTV8S20846C2__A1__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C2__A1__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C2__A1__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C2__A1__9S20846C22[4]),  4,7},
  {&(_tg__ZTV9S20846C11__9S20846C22[4]),  4,6},
  {&(_tg__ZTV8S20846C2__9S20846C11__9S20846C22[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C11__9S20846C22[4]),  4,7},
  {&(_tg__ZTV9S20846C10__9S20846C22[7]),  7,11},
  {&(_tg__ZTV8S20846C69S20846C10__A1__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C69S20846C10__A2__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C69S20846C10__A2__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C10__A2__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C69S20846C10__A2__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C69S20846C10__A1__9S20846C22[4]),  4,7},
  {&(_tg__ZTV9S20846C119S20846C10__A1__9S20846C22[4]),  4,6},
  {&(_tg__ZTV8S20846C2__9S20846C119S20846C10__A1__9S20846C22[6]),  6,10},
  {&(_tg__ZTV8S20846C3__9S20846C119S20846C10__A1__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C10__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C2__A1__9S20846C10__9S20846C22[6]),  6,10},
  {&(_tg__ZTV9S20846C11__9S20846C10__9S20846C22[4]),  4,6},
  {&(_tg__ZTV9S20846C13__9S20846C10__9S20846C22[7]),  7,11},
  {&(_tg__ZTV8S20846C69S20846C13__A1__9S20846C10__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S3052C129S20846C13__9S20846C10__9S20846C22[2]),  2,4},
  {&(_tg__ZTV8S20846C4__A4__9S20846C10__9S20846C22[4]),  4,6},
  {&(_tg__ZTV8S3052C12__A1__9S20846C10__9S20846C22[3]),  3,5},
  {&(_tg__ZTV9S20846C13__9S20846C22[4]),  4,8},
  {&(_tg__ZTV8S20846C29S20846C13__A3__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C29S20846C13__A3__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C29S20846C13__A3__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C29S20846C13__A3__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C69S20846C13__A2__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C28S20846C69S20846C13__A4__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C48S20846C28S20846C69S20846C13__A4__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C48S20846C28S20846C69S20846C13__A4__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C28S20846C69S20846C13__A4__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__8S20846C69S20846C13__A2__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C3__9S20846C13__9S20846C22[4]),  4,7},
  {&(_tg__ZTV8S20846C6__9S20846C13__9S20846C22[3]),  3,7},
  {&(_tg__ZTV8S20846C4__A2__9S20846C13__9S20846C22[4]),  4,6},
  {&(_tg__ZTV8S20846C4__A5__9S20846C22[3]),  3,5},
  {&(_tg__ZTV8S20846C3__8S20846C4__A5__9S20846C22[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20846C22[];
extern  VTBL_ENTRY _ZTV9S20846C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20846C22[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D0Ev,_ZTv0_n16_N9S20846C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D0Ev,_ZThn1128_N9S20846C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C13D1Ev,_ZTv0_n16_N9S20846C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1536_N9S20846C13D1Ev,_ZThn1128_N9S20846C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C10D0Ev,_ZTv0_n12_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12464_N9S20846C10D0Ev,_ZThn9196_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C10D1Ev,_ZTv0_n12_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12464_N9S20846C10D1Ev,_ZThn9196_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C10D0Ev,_ZTv0_n16_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12432_N9S20846C10D0Ev,_ZThn9172_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C10D1Ev,_ZTv0_n16_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12432_N9S20846C10D1Ev,_ZThn9172_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C10D0Ev,_ZTv0_n20_N9S20846C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10896_N9S20846C10D0Ev,_ZThn8044_N9S20846C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C10D1Ev,_ZTv0_n20_N9S20846C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10896_N9S20846C10D1Ev,_ZThn8044_N9S20846C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D0Ev,_ZTv0_n20_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N9S20846C17D0Ev,_ZThn1480_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20846C17D1Ev,_ZTv0_n20_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N9S20846C17D1Ev,_ZThn1480_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D0Ev,_ZTv0_n16_N9S20846C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D0Ev,_ZThn1420_N9S20846C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C17D1Ev,_ZTv0_n16_N9S20846C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C17D1Ev,_ZThn1420_N9S20846C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D0Ev,_ZTv0_n16_N9S20846C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D0Ev,_ZThn1420_N9S20846C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20846C18D1Ev,_ZTv0_n16_N9S20846C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S20846C18D1Ev,_ZThn1420_N9S20846C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D0Ev,_ZTv0_n12_N8S20846C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D0Ev,_ZThn228_N8S20846C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C6D1Ev,_ZTv0_n12_N8S20846C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C6D1Ev,_ZThn228_N8S20846C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D0Ev,_ZTv0_n12_N8S20846C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D0Ev,_ZThn228_N8S20846C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C2D1Ev,_ZTv0_n12_N8S20846C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C2D1Ev,_ZThn228_N8S20846C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D0Ev,_ZTv0_n12_N8S20846C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D0Ev,_ZThn228_N8S20846C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20846C4D1Ev,_ZTv0_n12_N8S20846C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S20846C4D1Ev,_ZThn228_N8S20846C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C21D0Ev,_ZTv0_n12_N9S20846C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn368_N9S20846C21D0Ev,_ZThn256_N9S20846C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20846C21D1Ev,_ZTv0_n12_N9S20846C21D1Ev), 