// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S79C8_nt  {
  int s79c8f0[2];
  void  mf79c8(); // _ZN8S79C8_nt6mf79c8Ev
};
//SIG(-1 S79C8_nt) C1{ m Fi[2]}


void  S79C8_nt ::mf79c8(){}

//skip512 S79C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S79C8_nt[];
VTBL_ENTRY *P__ZTI8S79C8_nt = _ZTI8S79C8_nt; 
Class_Descriptor cd_S79C8_nt = {  "S79C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI8S79C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C7_nt  {
  int s79c7f0;
  __tsi64 s79c7f1;
  void *s79c7f2[4];
  int s79c7f3[2];
  void *s79c7f4;
  ::S79C8_nt s79c7f5;
  void *s79c7f6[2];
  virtual  ~S79C7_nt(); // _ZN8S79C7_ntD1Ev
  virtual void  v4(); // _ZN8S79C7_nt2v4Ev
  virtual void  v5(); // _ZN8S79C7_nt2v5Ev
  virtual void  v6(); // _ZN8S79C7_nt2v6Ev
  virtual void  v7(); // _ZN8S79C7_nt2v7Ev
  virtual void  v8(); // _ZN8S79C7_nt2v8Ev
  virtual void  v9(); // _ZN8S79C7_nt2v9Ev
  virtual void  v10(); // _ZN8S79C7_nt3v10Ev
  virtual void  v11(); // _ZN8S79C7_nt3v11Ev
  virtual void  v12(); // _ZN8S79C7_nt3v12Ev
  virtual void  v13(); // _ZN8S79C7_nt3v13Ev
  virtual void  v14(); // _ZN8S79C7_nt3v14Ev
  virtual void  v15(); // _ZN8S79C7_nt3v15Ev
  virtual void  v16(); // _ZN8S79C7_nt3v16Ev
  virtual void  v17(); // _ZN8S79C7_nt3v17Ev
  virtual void  v18(); // _ZN8S79C7_nt3v18Ev
  virtual void  v19(); // _ZN8S79C7_nt3v19Ev
  virtual void  v20(); // _ZN8S79C7_nt3v20Ev
  virtual void  v21(); // _ZN8S79C7_nt3v21Ev
  virtual void  v22(); // _ZN8S79C7_nt3v22Ev
  virtual void  v23(); // _ZN8S79C7_nt3v23Ev
  virtual void  v24(); // _ZN8S79C7_nt3v24Ev
  virtual void  v25(); // _ZN8S79C7_nt3v25Ev
  virtual void  v26(); // _ZN8S79C7_nt3v26Ev
  virtual void  v27(); // _ZN8S79C7_nt3v27Ev
  virtual void  v28(); // _ZN8S79C7_nt3v28Ev
  virtual void  v29(); // _ZN8S79C7_nt3v29Ev
  virtual void  v30(); // _ZN8S79C7_nt3v30Ev
  virtual void  v31(); // _ZN8S79C7_nt3v31Ev
  virtual void  v32(); // _ZN8S79C7_nt3v32Ev
  virtual void  v33(); // _ZN8S79C7_nt3v33Ev
  virtual void  v34(); // _ZN8S79C7_nt3v34Ev
  virtual void  v35(); // _ZN8S79C7_nt3v35Ev
  virtual void  v36(); // _ZN8S79C7_nt3v36Ev
  virtual void  v37(); // _ZN8S79C7_nt3v37Ev
  virtual void  v38(); // _ZN8S79C7_nt3v38Ev
  virtual void  v39(); // _ZN8S79C7_nt3v39Ev
  virtual void  v40(); // _ZN8S79C7_nt3v40Ev
  virtual void  v41(); // _ZN8S79C7_nt3v41Ev
  virtual void  v42(); // _ZN8S79C7_nt3v42Ev
  virtual void  v43(); // _ZN8S79C7_nt3v43Ev
  virtual void  v44(); // _ZN8S79C7_nt3v44Ev
  virtual void  v45(); // _ZN8S79C7_nt3v45Ev
  virtual void  v46(); // _ZN8S79C7_nt3v46Ev
  virtual void  v47(); // _ZN8S79C7_nt3v47Ev
  virtual void  v48(); // _ZN8S79C7_nt3v48Ev
  virtual void  v49(); // _ZN8S79C7_nt3v49Ev
  virtual void  v50(); // _ZN8S79C7_nt3v50Ev
  virtual void  v51(); // _ZN8S79C7_nt3v51Ev
  virtual void  v52(); // _ZN8S79C7_nt3v52Ev
  virtual void  v53(); // _ZN8S79C7_nt3v53Ev
  virtual void  v54(); // _ZN8S79C7_nt3v54Ev
  virtual void  v55(); // _ZN8S79C7_nt3v55Ev
  virtual void  v56(); // _ZN8S79C7_nt3v56Ev
  virtual void  v57(); // _ZN8S79C7_nt3v57Ev
  virtual void  v58(); // _ZN8S79C7_nt3v58Ev
  virtual void  v59(); // _ZN8S79C7_nt3v59Ev
  virtual void  v60(); // _ZN8S79C7_nt3v60Ev
  virtual void  v61(); // _ZN8S79C7_nt3v61Ev
  virtual void  v62(); // _ZN8S79C7_nt3v62Ev
  virtual void  v63(); // _ZN8S79C7_nt3v63Ev
  virtual void  v64(); // _ZN8S79C7_nt3v64Ev
  virtual void  v65(); // _ZN8S79C7_nt3v65Ev
  virtual void  v66(); // _ZN8S79C7_nt3v66Ev
  virtual void  v67(); // _ZN8S79C7_nt3v67Ev
  S79C7_nt(); // tgen
};
//SIG(-1 S79C7_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S79C7_nt ::~S79C7_nt(){ note_dtor("S79C7_nt", this);}
void  S79C7_nt ::v4(){vfunc_called(this, "_ZN8S79C7_nt2v4Ev");}
void  S79C7_nt ::v5(){vfunc_called(this, "_ZN8S79C7_nt2v5Ev");}
void  S79C7_nt ::v6(){vfunc_called(this, "_ZN8S79C7_nt2v6Ev");}
void  S79C7_nt ::v7(){vfunc_called(this, "_ZN8S79C7_nt2v7Ev");}
void  S79C7_nt ::v8(){vfunc_called(this, "_ZN8S79C7_nt2v8Ev");}
void  S79C7_nt ::v9(){vfunc_called(this, "_ZN8S79C7_nt2v9Ev");}
void  S79C7_nt ::v10(){vfunc_called(this, "_ZN8S79C7_nt3v10Ev");}
void  S79C7_nt ::v11(){vfunc_called(this, "_ZN8S79C7_nt3v11Ev");}
void  S79C7_nt ::v12(){vfunc_called(this, "_ZN8S79C7_nt3v12Ev");}
void  S79C7_nt ::v13(){vfunc_called(this, "_ZN8S79C7_nt3v13Ev");}
void  S79C7_nt ::v14(){vfunc_called(this, "_ZN8S79C7_nt3v14Ev");}
void  S79C7_nt ::v15(){vfunc_called(this, "_ZN8S79C7_nt3v15Ev");}
void  S79C7_nt ::v16(){vfunc_called(this, "_ZN8S79C7_nt3v16Ev");}
void  S79C7_nt ::v17(){vfunc_called(this, "_ZN8S79C7_nt3v17Ev");}
void  S79C7_nt ::v18(){vfunc_called(this, "_ZN8S79C7_nt3v18Ev");}
void  S79C7_nt ::v19(){vfunc_called(this, "_ZN8S79C7_nt3v19Ev");}
void  S79C7_nt ::v20(){vfunc_called(this, "_ZN8S79C7_nt3v20Ev");}
void  S79C7_nt ::v21(){vfunc_called(this, "_ZN8S79C7_nt3v21Ev");}
void  S79C7_nt ::v22(){vfunc_called(this, "_ZN8S79C7_nt3v22Ev");}
void  S79C7_nt ::v23(){vfunc_called(this, "_ZN8S79C7_nt3v23Ev");}
void  S79C7_nt ::v24(){vfunc_called(this, "_ZN8S79C7_nt3v24Ev");}
void  S79C7_nt ::v25(){vfunc_called(this, "_ZN8S79C7_nt3v25Ev");}
void  S79C7_nt ::v26(){vfunc_called(this, "_ZN8S79C7_nt3v26Ev");}
void  S79C7_nt ::v27(){vfunc_called(this, "_ZN8S79C7_nt3v27Ev");}
void  S79C7_nt ::v28(){vfunc_called(this, "_ZN8S79C7_nt3v28Ev");}
void  S79C7_nt ::v29(){vfunc_called(this, "_ZN8S79C7_nt3v29Ev");}
void  S79C7_nt ::v30(){vfunc_called(this, "_ZN8S79C7_nt3v30Ev");}
void  S79C7_nt ::v31(){vfunc_called(this, "_ZN8S79C7_nt3v31Ev");}
void  S79C7_nt ::v32(){vfunc_called(this, "_ZN8S79C7_nt3v32Ev");}
void  S79C7_nt ::v33(){vfunc_called(this, "_ZN8S79C7_nt3v33Ev");}
void  S79C7_nt ::v34(){vfunc_called(this, "_ZN8S79C7_nt3v34Ev");}
void  S79C7_nt ::v35(){vfunc_called(this, "_ZN8S79C7_nt3v35Ev");}
void  S79C7_nt ::v36(){vfunc_called(this, "_ZN8S79C7_nt3v36Ev");}
void  S79C7_nt ::v37(){vfunc_called(this, "_ZN8S79C7_nt3v37Ev");}
void  S79C7_nt ::v38(){vfunc_called(this, "_ZN8S79C7_nt3v38Ev");}
void  S79C7_nt ::v39(){vfunc_called(this, "_ZN8S79C7_nt3v39Ev");}
void  S79C7_nt ::v40(){vfunc_called(this, "_ZN8S79C7_nt3v40Ev");}
void  S79C7_nt ::v41(){vfunc_called(this, "_ZN8S79C7_nt3v41Ev");}
void  S79C7_nt ::v42(){vfunc_called(this, "_ZN8S79C7_nt3v42Ev");}
void  S79C7_nt ::v43(){vfunc_called(this, "_ZN8S79C7_nt3v43Ev");}
void  S79C7_nt ::v44(){vfunc_called(this, "_ZN8S79C7_nt3v44Ev");}
void  S79C7_nt ::v45(){vfunc_called(this, "_ZN8S79C7_nt3v45Ev");}
void  S79C7_nt ::v46(){vfunc_called(this, "_ZN8S79C7_nt3v46Ev");}
void  S79C7_nt ::v47(){vfunc_called(this, "_ZN8S79C7_nt3v47Ev");}
void  S79C7_nt ::v48(){vfunc_called(this, "_ZN8S79C7_nt3v48Ev");}
void  S79C7_nt ::v49(){vfunc_called(this, "_ZN8S79C7_nt3v49Ev");}
void  S79C7_nt ::v50(){vfunc_called(this, "_ZN8S79C7_nt3v50Ev");}
void  S79C7_nt ::v51(){vfunc_called(this, "_ZN8S79C7_nt3v51Ev");}
void  S79C7_nt ::v52(){vfunc_called(this, "_ZN8S79C7_nt3v52Ev");}
void  S79C7_nt ::v53(){vfunc_called(this, "_ZN8S79C7_nt3v53Ev");}
void  S79C7_nt ::v54(){vfunc_called(this, "_ZN8S79C7_nt3v54Ev");}
void  S79C7_nt ::v55(){vfunc_called(this, "_ZN8S79C7_nt3v55Ev");}
void  S79C7_nt ::v56(){vfunc_called(this, "_ZN8S79C7_nt3v56Ev");}
void  S79C7_nt ::v57(){vfunc_called(this, "_ZN8S79C7_nt3v57Ev");}
void  S79C7_nt ::v58(){vfunc_called(this, "_ZN8S79C7_nt3v58Ev");}
void  S79C7_nt ::v59(){vfunc_called(this, "_ZN8S79C7_nt3v59Ev");}
void  S79C7_nt ::v60(){vfunc_called(this, "_ZN8S79C7_nt3v60Ev");}
void  S79C7_nt ::v61(){vfunc_called(this, "_ZN8S79C7_nt3v61Ev");}
void  S79C7_nt ::v62(){vfunc_called(this, "_ZN8S79C7_nt3v62Ev");}
void  S79C7_nt ::v63(){vfunc_called(this, "_ZN8S79C7_nt3v63Ev");}
void  S79C7_nt ::v64(){vfunc_called(this, "_ZN8S79C7_nt3v64Ev");}
void  S79C7_nt ::v65(){vfunc_called(this, "_ZN8S79C7_nt3v65Ev");}
void  S79C7_nt ::v66(){vfunc_called(this, "_ZN8S79C7_nt3v66Ev");}
void  S79C7_nt ::v67(){vfunc_called(this, "_ZN8S79C7_nt3v67Ev");}
S79C7_nt ::S79C7_nt(){ note_ctor("S79C7_nt", this);} // tgen

//skip512 S79C7_nt

#else // __cplusplus

extern void _ZN8S79C7_ntC1Ev();
extern void _ZN8S79C7_ntD1Ev();
Name_Map name_map_S79C7_nt[] = {
  NSPAIR(_ZN8S79C7_ntC1Ev),
  NSPAIR(_ZN8S79C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern void _ZN8S79C7_ntD1Ev();
extern void _ZN8S79C7_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
static  VTBL_ENTRY vtc_S79C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI8S79C7_nt[];
VTBL_ENTRY *P__ZTI8S79C7_nt = _ZTI8S79C7_nt; 
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
Class_Descriptor cd_S79C7_nt = {  "S79C7_nt", // class name
  0,0,//no base classes
  &(vtc_S79C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S79C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S79C7_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C6_nt  : S79C7_nt {
  virtual  ~S79C6_nt(); // _ZN8S79C6_ntD1Ev
  virtual void  v68(); // _ZN8S79C6_nt3v68Ev
  virtual void  v69(); // _ZN8S79C6_nt3v69Ev
  S79C6_nt(); // tgen
};
//SIG(-1 S79C6_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S79C6_nt ::~S79C6_nt(){ note_dtor("S79C6_nt", this);}
void  S79C6_nt ::v68(){vfunc_called(this, "_ZN8S79C6_nt3v68Ev");}
void  S79C6_nt ::v69(){vfunc_called(this, "_ZN8S79C6_nt3v69Ev");}
S79C6_nt ::S79C6_nt(){ note_ctor("S79C6_nt", this);} // tgen

//skip512 S79C6_nt

#else // __cplusplus

extern void _ZN8S79C6_ntC1Ev();
extern void _ZN8S79C6_ntD1Ev();
Name_Map name_map_S79C6_nt[] = {
  NSPAIR(_ZN8S79C6_ntC1Ev),
  NSPAIR(_ZN8S79C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
static Base_Class bases_S79C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern void _ZN8S79C6_ntD1Ev();
extern void _ZN8S79C6_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
static  VTBL_ENTRY vtc_S79C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI8S79C6_nt[];
VTBL_ENTRY *P__ZTI8S79C6_nt = _ZTI8S79C6_nt; 
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
Class_Descriptor cd_S79C6_nt = {  "S79C6_nt", // class name
  bases_S79C6_nt, 1,
  &(vtc_S79C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S79C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S79C6_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C9_nt  {
  int s79c9f0[4];
  char s79c9f1[9];
  void  mf79c9(); // _ZN8S79C9_nt6mf79c9Ev
};
//SIG(-1 S79C9_nt) C1{ m Fi[4] Fc[9]}


void  S79C9_nt ::mf79c9(){}

//skip512 S79C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C12_nt  {
  void *s79c12f0;
  int s79c12f1[2];
  void  mf79c12(); // _ZN9S79C12_nt7mf79c12Ev
};
//SIG(-1 S79C12_nt) C1{ m Fp Fi[2]}


void  S79C12_nt ::mf79c12(){}

//skip512 S79C12_nt

#else // __cplusplus

Class_Descriptor cd_S79C12_nt = {  "S79C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C11_nt  : S79C12_nt {
};
//SIG(-1 S79C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S79C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
static Base_Class bases_S79C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C11_nt = {  "S79C11_nt", // class name
  bases_S79C11_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C10_nt  : S79C11_nt {
};
//SIG(-1 S79C10_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S79C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C11_nt;
static Base_Class bases_S79C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C16  : S79C12_nt {
};
//SIG(-1 S79C16) C1{ BC2{ m Fp Fi[2]}}



static void Test_S79C16()
{
  extern Class_Descriptor cd_S79C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C16, buf);
    S79C16 &lv = *(new (buf) S79C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C16)");
    check_base_class_offset(lv, (S79C12_nt*), 0, "S79C16");
    test_class_info(&lv, &cd_S79C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C16(Test_S79C16, "S79C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
static Base_Class bases_S79C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C16 = {  "S79C16", // class name
  bases_S79C16, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C15  : S79C16 {
};
//SIG(-1 S79C15) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S79C15()
{
  extern Class_Descriptor cd_S79C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C15, buf);
    S79C15 &lv = *(new (buf) S79C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C15)");
    check_base_class_offset(lv, (S79C12_nt*)(S79C16*), 0, "S79C15");
    check_base_class_offset(lv, (S79C16*), 0, "S79C15");
    test_class_info(&lv, &cd_S79C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C15(Test_S79C15, "S79C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C16;
static Base_Class bases_S79C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C15 = {  "S79C15", // class name
  bases_S79C15, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C20  : S79C12_nt {
};
//SIG(-1 S79C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S79C20()
{
  extern Class_Descriptor cd_S79C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C20, buf);
    S79C20 &lv = *(new (buf) S79C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C20)");
    check_base_class_offset(lv, (S79C12_nt*), 0, "S79C20");
    test_class_info(&lv, &cd_S79C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C20(Test_S79C20, "S79C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
static Base_Class bases_S79C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C20 = {  "S79C20", // class name
  bases_S79C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C19  : S79C20 {
};
//SIG(-1 S79C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S79C19()
{
  extern Class_Descriptor cd_S79C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C19, buf);
    S79C19 &lv = *(new (buf) S79C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C19)");
    check_base_class_offset(lv, (S79C12_nt*)(S79C20*), 0, "S79C19");
    check_base_class_offset(lv, (S79C20*), 0, "S79C19");
    test_class_info(&lv, &cd_S79C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C19(Test_S79C19, "S79C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C20;
static Base_Class bases_S79C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C19 = {  "S79C19", // class name
  bases_S79C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C21_nt  {
  void *s79c21f0;
  ::S79C8_nt s79c21f1;
  void  mf79c21(); // _ZN9S79C21_nt7mf79c21Ev
};
//SIG(-1 S79C21_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S79C21_nt ::mf79c21(){}

//skip512 S79C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C5_nt  : S79C6_nt {
  ::S79C9_nt s79c5f0;
  int s79c5f1;
  unsigned int s79c5f2:1;
  unsigned int s79c5f3:1;
  unsigned int s79c5f4:1;
  unsigned int s79c5f5:1;
  ::S79C10_nt s79c5f6;
  ::S79C10_nt s79c5f7;
  void *s79c5f8;
  ::S79C15 s79c5f9;
  ::S79C15 s79c5f10;
  ::S79C15 s79c5f11;
  ::S79C19 s79c5f12;
  char s79c5f13;
  int s79c5f14;
  void *s79c5f15;
  ::S79C8_nt s79c5f16;
  ::S79C8_nt s79c5f17;
  ::S79C8_nt s79c5f18;
  ::S79C8_nt s79c5f19;
  ::S79C8_nt s79c5f20;
  ::S79C8_nt s79c5f21;
  ::S79C21_nt s79c5f22;
  ::S79C21_nt s79c5f23;
  ::S79C21_nt s79c5f24;
  ::S79C21_nt s79c5f25;
  ::S79C21_nt s79c5f26;
  ::S79C21_nt s79c5f27;
  ::S79C21_nt s79c5f28;
  ::S79C21_nt s79c5f29;
  ::S79C21_nt s79c5f30;
  ::S79C21_nt s79c5f31;
  virtual  ~S79C5_nt(); // _ZN8S79C5_ntD1Ev
  virtual void  v70(); // _ZN8S79C5_nt3v70Ev
  virtual void  v71(); // _ZN8S79C5_nt3v71Ev
  virtual void  v72(); // _ZN8S79C5_nt3v72Ev
  virtual void  v73(); // _ZN8S79C5_nt3v73Ev
  virtual void  v74(); // _ZN8S79C5_nt3v74Ev
  virtual void  v75(); // _ZN8S79C5_nt3v75Ev
  virtual void  v76(); // _ZN8S79C5_nt3v76Ev
  virtual void  v77(); // _ZN8S79C5_nt3v77Ev
  virtual void  v78(); // _ZN8S79C5_nt3v78Ev
  virtual void  v79(); // _ZN8S79C5_nt3v79Ev
  virtual void  v80(); // _ZN8S79C5_nt3v80Ev
  virtual void  v81(); // _ZN8S79C5_nt3v81Ev
  virtual void  v82(); // _ZN8S79C5_nt3v82Ev
  virtual void  v83(); // _ZN8S79C5_nt3v83Ev
  virtual void  v84(); // _ZN8S79C5_nt3v84Ev
  virtual void  v85(); // _ZN8S79C5_nt3v85Ev
  virtual void  v86(); // _ZN8S79C5_nt3v86Ev
  virtual void  v87(); // _ZN8S79C5_nt3v87Ev
  virtual void  v88(); // _ZN8S79C5_nt3v88Ev
  virtual void  v89(); // _ZN8S79C5_nt3v89Ev
  virtual void  v90(); // _ZN8S79C5_nt3v90Ev
  virtual void  v91(); // _ZN8S79C5_nt3v91Ev
  virtual void  v92(); // _ZN8S79C5_nt3v92Ev
  virtual void  v93(); // _ZN8S79C5_nt3v93Ev
  virtual void  v94(); // _ZN8S79C5_nt3v94Ev
  virtual void  v95(); // _ZN8S79C5_nt3v95Ev
  virtual void  v96(); // _ZN8S79C5_nt3v96Ev
  virtual void  v97(); // _ZN8S79C5_nt3v97Ev
  virtual void  v98(); // _ZN8S79C5_nt3v98Ev
  virtual void  v99(); // _ZN8S79C5_nt3v99Ev
  virtual void  v100(); // _ZN8S79C5_nt4v100Ev
  virtual void  v101(); // _ZN8S79C5_nt4v101Ev
  virtual void  v102(); // _ZN8S79C5_nt4v102Ev
  virtual void  v103(); // _ZN8S79C5_nt4v103Ev
  virtual void  v104(); // _ZN8S79C5_nt4v104Ev
  virtual void  v105(); // _ZN8S79C5_nt4v105Ev
  virtual void  v106(); // _ZN8S79C5_nt4v106Ev
  virtual void  v107(); // _ZN8S79C5_nt4v107Ev
  virtual void  v108(); // _ZN8S79C5_nt4v108Ev
  virtual void  v109(); // _ZN8S79C5_nt4v109Ev
  virtual void  v110(); // _ZN8S79C5_nt4v110Ev
  virtual void  v111(); // _ZN8S79C5_nt4v111Ev
  virtual void  v112(); // _ZN8S79C5_nt4v112Ev
  virtual void  v113(); // _ZN8S79C5_nt4v113Ev
  virtual void  v114(); // _ZN8S79C5_nt4v114Ev
  virtual void  v115(); // _ZN8S79C5_nt4v115Ev
  virtual void  v116(); // _ZN8S79C5_nt4v116Ev
  virtual void  v117(); // _ZN8S79C5_nt4v117Ev
  virtual void  v118(); // _ZN8S79C5_nt4v118Ev
  virtual void  v119(); // _ZN8S79C5_nt4v119Ev
  virtual void  v120(); // _ZN8S79C5_nt4v120Ev
  virtual void  v121(); // _ZN8S79C5_nt4v121Ev
  virtual void  v122(); // _ZN8S79C5_nt4v122Ev
  virtual void  v123(); // _ZN8S79C5_nt4v123Ev
  virtual void  v124(); // _ZN8S79C5_nt4v124Ev
  virtual void  v125(); // _ZN8S79C5_nt4v125Ev
  virtual void  v126(); // _ZN8S79C5_nt4v126Ev
  virtual void  v127(); // _ZN8S79C5_nt4v127Ev
  virtual void  v128(); // _ZN8S79C5_nt4v128Ev
  virtual void  v129(); // _ZN8S79C5_nt4v129Ev
  virtual void  v130(); // _ZN8S79C5_nt4v130Ev
  virtual void  v131(); // _ZN8S79C5_nt4v131Ev
  virtual void  v132(); // _ZN8S79C5_nt4v132Ev
  virtual void  v133(); // _ZN8S79C5_nt4v133Ev
  virtual void  v134(); // _ZN8S79C5_nt4v134Ev
  virtual void  v135(); // _ZN8S79C5_nt4v135Ev
  virtual void  v136(); // _ZN8S79C5_nt4v136Ev
  virtual void  v137(); // _ZN8S79C5_nt4v137Ev
  virtual void  v138(); // _ZN8S79C5_nt4v138Ev
  virtual void  v139(); // _ZN8S79C5_nt4v139Ev
  virtual void  v140(); // _ZN8S79C5_nt4v140Ev
  virtual void  v141(); // _ZN8S79C5_nt4v141Ev
  virtual void  v142(); // _ZN8S79C5_nt4v142Ev
  virtual void  v143(); // _ZN8S79C5_nt4v143Ev
  virtual void  v144(); // _ZN8S79C5_nt4v144Ev
  virtual void  v145(); // _ZN8S79C5_nt4v145Ev
  S79C5_nt(); // tgen
};
//SIG(-1 S79C5_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S79C5_nt ::~S79C5_nt(){ note_dtor("S79C5_nt", this);}
void  S79C5_nt ::v70(){vfunc_called(this, "_ZN8S79C5_nt3v70Ev");}
void  S79C5_nt ::v71(){vfunc_called(this, "_ZN8S79C5_nt3v71Ev");}
void  S79C5_nt ::v72(){vfunc_called(this, "_ZN8S79C5_nt3v72Ev");}
void  S79C5_nt ::v73(){vfunc_called(this, "_ZN8S79C5_nt3v73Ev");}
void  S79C5_nt ::v74(){vfunc_called(this, "_ZN8S79C5_nt3v74Ev");}
void  S79C5_nt ::v75(){vfunc_called(this, "_ZN8S79C5_nt3v75Ev");}
void  S79C5_nt ::v76(){vfunc_called(this, "_ZN8S79C5_nt3v76Ev");}
void  S79C5_nt ::v77(){vfunc_called(this, "_ZN8S79C5_nt3v77Ev");}
void  S79C5_nt ::v78(){vfunc_called(this, "_ZN8S79C5_nt3v78Ev");}
void  S79C5_nt ::v79(){vfunc_called(this, "_ZN8S79C5_nt3v79Ev");}
void  S79C5_nt ::v80(){vfunc_called(this, "_ZN8S79C5_nt3v80Ev");}
void  S79C5_nt ::v81(){vfunc_called(this, "_ZN8S79C5_nt3v81Ev");}
void  S79C5_nt ::v82(){vfunc_called(this, "_ZN8S79C5_nt3v82Ev");}
void  S79C5_nt ::v83(){vfunc_called(this, "_ZN8S79C5_nt3v83Ev");}
void  S79C5_nt ::v84(){vfunc_called(this, "_ZN8S79C5_nt3v84Ev");}
void  S79C5_nt ::v85(){vfunc_called(this, "_ZN8S79C5_nt3v85Ev");}
void  S79C5_nt ::v86(){vfunc_called(this, "_ZN8S79C5_nt3v86Ev");}
void  S79C5_nt ::v87(){vfunc_called(this, "_ZN8S79C5_nt3v87Ev");}
void  S79C5_nt ::v88(){vfunc_called(this, "_ZN8S79C5_nt3v88Ev");}
void  S79C5_nt ::v89(){vfunc_called(this, "_ZN8S79C5_nt3v89Ev");}
void  S79C5_nt ::v90(){vfunc_called(this, "_ZN8S79C5_nt3v90Ev");}
void  S79C5_nt ::v91(){vfunc_called(this, "_ZN8S79C5_nt3v91Ev");}
void  S79C5_nt ::v92(){vfunc_called(this, "_ZN8S79C5_nt3v92Ev");}
void  S79C5_nt ::v93(){vfunc_called(this, "_ZN8S79C5_nt3v93Ev");}
void  S79C5_nt ::v94(){vfunc_called(this, "_ZN8S79C5_nt3v94Ev");}
void  S79C5_nt ::v95(){vfunc_called(this, "_ZN8S79C5_nt3v95Ev");}
void  S79C5_nt ::v96(){vfunc_called(this, "_ZN8S79C5_nt3v96Ev");}
void  S79C5_nt ::v97(){vfunc_called(this, "_ZN8S79C5_nt3v97Ev");}
void  S79C5_nt ::v98(){vfunc_called(this, "_ZN8S79C5_nt3v98Ev");}
void  S79C5_nt ::v99(){vfunc_called(this, "_ZN8S79C5_nt3v99Ev");}
void  S79C5_nt ::v100(){vfunc_called(this, "_ZN8S79C5_nt4v100Ev");}
void  S79C5_nt ::v101(){vfunc_called(this, "_ZN8S79C5_nt4v101Ev");}
void  S79C5_nt ::v102(){vfunc_called(this, "_ZN8S79C5_nt4v102Ev");}
void  S79C5_nt ::v103(){vfunc_called(this, "_ZN8S79C5_nt4v103Ev");}
void  S79C5_nt ::v104(){vfunc_called(this, "_ZN8S79C5_nt4v104Ev");}
void  S79C5_nt ::v105(){vfunc_called(this, "_ZN8S79C5_nt4v105Ev");}
void  S79C5_nt ::v106(){vfunc_called(this, "_ZN8S79C5_nt4v106Ev");}
void  S79C5_nt ::v107(){vfunc_called(this, "_ZN8S79C5_nt4v107Ev");}
void  S79C5_nt ::v108(){vfunc_called(this, "_ZN8S79C5_nt4v108Ev");}
void  S79C5_nt ::v109(){vfunc_called(this, "_ZN8S79C5_nt4v109Ev");}
void  S79C5_nt ::v110(){vfunc_called(this, "_ZN8S79C5_nt4v110Ev");}
void  S79C5_nt ::v111(){vfunc_called(this, "_ZN8S79C5_nt4v111Ev");}
void  S79C5_nt ::v112(){vfunc_called(this, "_ZN8S79C5_nt4v112Ev");}
void  S79C5_nt ::v113(){vfunc_called(this, "_ZN8S79C5_nt4v113Ev");}
void  S79C5_nt ::v114(){vfunc_called(this, "_ZN8S79C5_nt4v114Ev");}
void  S79C5_nt ::v115(){vfunc_called(this, "_ZN8S79C5_nt4v115Ev");}
void  S79C5_nt ::v116(){vfunc_called(this, "_ZN8S79C5_nt4v116Ev");}
void  S79C5_nt ::v117(){vfunc_called(this, "_ZN8S79C5_nt4v117Ev");}
void  S79C5_nt ::v118(){vfunc_called(this, "_ZN8S79C5_nt4v118Ev");}
void  S79C5_nt ::v119(){vfunc_called(this, "_ZN8S79C5_nt4v119Ev");}
void  S79C5_nt ::v120(){vfunc_called(this, "_ZN8S79C5_nt4v120Ev");}
void  S79C5_nt ::v121(){vfunc_called(this, "_ZN8S79C5_nt4v121Ev");}
void  S79C5_nt ::v122(){vfunc_called(this, "_ZN8S79C5_nt4v122Ev");}
void  S79C5_nt ::v123(){vfunc_called(this, "_ZN8S79C5_nt4v123Ev");}
void  S79C5_nt ::v124(){vfunc_called(this, "_ZN8S79C5_nt4v124Ev");}
void  S79C5_nt ::v125(){vfunc_called(this, "_ZN8S79C5_nt4v125Ev");}
void  S79C5_nt ::v126(){vfunc_called(this, "_ZN8S79C5_nt4v126Ev");}
void  S79C5_nt ::v127(){vfunc_called(this, "_ZN8S79C5_nt4v127Ev");}
void  S79C5_nt ::v128(){vfunc_called(this, "_ZN8S79C5_nt4v128Ev");}
void  S79C5_nt ::v129(){vfunc_called(this, "_ZN8S79C5_nt4v129Ev");}
void  S79C5_nt ::v130(){vfunc_called(this, "_ZN8S79C5_nt4v130Ev");}
void  S79C5_nt ::v131(){vfunc_called(this, "_ZN8S79C5_nt4v131Ev");}
void  S79C5_nt ::v132(){vfunc_called(this, "_ZN8S79C5_nt4v132Ev");}
void  S79C5_nt ::v133(){vfunc_called(this, "_ZN8S79C5_nt4v133Ev");}
void  S79C5_nt ::v134(){vfunc_called(this, "_ZN8S79C5_nt4v134Ev");}
void  S79C5_nt ::v135(){vfunc_called(this, "_ZN8S79C5_nt4v135Ev");}
void  S79C5_nt ::v136(){vfunc_called(this, "_ZN8S79C5_nt4v136Ev");}
void  S79C5_nt ::v137(){vfunc_called(this, "_ZN8S79C5_nt4v137Ev");}
void  S79C5_nt ::v138(){vfunc_called(this, "_ZN8S79C5_nt4v138Ev");}
void  S79C5_nt ::v139(){vfunc_called(this, "_ZN8S79C5_nt4v139Ev");}
void  S79C5_nt ::v140(){vfunc_called(this, "_ZN8S79C5_nt4v140Ev");}
void  S79C5_nt ::v141(){vfunc_called(this, "_ZN8S79C5_nt4v141Ev");}
void  S79C5_nt ::v142(){vfunc_called(this, "_ZN8S79C5_nt4v142Ev");}
void  S79C5_nt ::v143(){vfunc_called(this, "_ZN8S79C5_nt4v143Ev");}
void  S79C5_nt ::v144(){vfunc_called(this, "_ZN8S79C5_nt4v144Ev");}
void  S79C5_nt ::v145(){vfunc_called(this, "_ZN8S79C5_nt4v145Ev");}
S79C5_nt ::S79C5_nt(){ note_ctor("S79C5_nt", this);} // tgen

//skip512 S79C5_nt

#else // __cplusplus

extern void _ZN8S79C5_ntC1Ev();
extern void _ZN8S79C5_ntD1Ev();
Name_Map name_map_S79C5_nt[] = {
  NSPAIR(_ZN8S79C5_ntC1Ev),
  NSPAIR(_ZN8S79C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
extern Class_Descriptor cd_S79C6_nt;
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
static Base_Class bases_S79C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S79C5_nt[];
extern void _ZN8S79C5_ntD1Ev();
extern void _ZN8S79C5_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
extern void _ZN8S79C5_nt3v70Ev();
extern void _ZN8S79C5_nt3v71Ev();
extern void _ZN8S79C5_nt3v72Ev();
extern void _ZN8S79C5_nt3v73Ev();
extern void _ZN8S79C5_nt3v74Ev();
extern void _ZN8S79C5_nt3v75Ev();
extern void _ZN8S79C5_nt3v76Ev();
extern void _ZN8S79C5_nt3v77Ev();
extern void _ZN8S79C5_nt3v78Ev();
extern void _ZN8S79C5_nt3v79Ev();
extern void _ZN8S79C5_nt3v80Ev();
extern void _ZN8S79C5_nt3v81Ev();
extern void _ZN8S79C5_nt3v82Ev();
extern void _ZN8S79C5_nt3v83Ev();
extern void _ZN8S79C5_nt3v84Ev();
extern void _ZN8S79C5_nt3v85Ev();
extern void _ZN8S79C5_nt3v86Ev();
extern void _ZN8S79C5_nt3v87Ev();
extern void _ZN8S79C5_nt3v88Ev();
extern void _ZN8S79C5_nt3v89Ev();
extern void _ZN8S79C5_nt3v90Ev();
extern void _ZN8S79C5_nt3v91Ev();
extern void _ZN8S79C5_nt3v92Ev();
extern void _ZN8S79C5_nt3v93Ev();
extern void _ZN8S79C5_nt3v94Ev();
extern void _ZN8S79C5_nt3v95Ev();
extern void _ZN8S79C5_nt3v96Ev();
extern void _ZN8S79C5_nt3v97Ev();
extern void _ZN8S79C5_nt3v98Ev();
extern void _ZN8S79C5_nt3v99Ev();
extern void _ZN8S79C5_nt4v100Ev();
extern void _ZN8S79C5_nt4v101Ev();
extern void _ZN8S79C5_nt4v102Ev();
extern void _ZN8S79C5_nt4v103Ev();
extern void _ZN8S79C5_nt4v104Ev();
extern void _ZN8S79C5_nt4v105Ev();
extern void _ZN8S79C5_nt4v106Ev();
extern void _ZN8S79C5_nt4v107Ev();
extern void _ZN8S79C5_nt4v108Ev();
extern void _ZN8S79C5_nt4v109Ev();
extern void _ZN8S79C5_nt4v110Ev();
extern void _ZN8S79C5_nt4v111Ev();
extern void _ZN8S79C5_nt4v112Ev();
extern void _ZN8S79C5_nt4v113Ev();
extern void _ZN8S79C5_nt4v114Ev();
extern void _ZN8S79C5_nt4v115Ev();
extern void _ZN8S79C5_nt4v116Ev();
extern void _ZN8S79C5_nt4v117Ev();
extern void _ZN8S79C5_nt4v118Ev();
extern void _ZN8S79C5_nt4v119Ev();
extern void _ZN8S79C5_nt4v120Ev();
extern void _ZN8S79C5_nt4v121Ev();
extern void _ZN8S79C5_nt4v122Ev();
extern void _ZN8S79C5_nt4v123Ev();
extern void _ZN8S79C5_nt4v124Ev();
extern void _ZN8S79C5_nt4v125Ev();
extern void _ZN8S79C5_nt4v126Ev();
extern void _ZN8S79C5_nt4v127Ev();
extern void _ZN8S79C5_nt4v128Ev();
extern void _ZN8S79C5_nt4v129Ev();
extern void _ZN8S79C5_nt4v130Ev();
extern void _ZN8S79C5_nt4v131Ev();
extern void _ZN8S79C5_nt4v132Ev();
extern void _ZN8S79C5_nt4v133Ev();
extern void _ZN8S79C5_nt4v134Ev();
extern void _ZN8S79C5_nt4v135Ev();
extern void _ZN8S79C5_nt4v136Ev();
extern void _ZN8S79C5_nt4v137Ev();
extern void _ZN8S79C5_nt4v138Ev();
extern void _ZN8S79C5_nt4v139Ev();
extern void _ZN8S79C5_nt4v140Ev();
extern void _ZN8S79C5_nt4v141Ev();
extern void _ZN8S79C5_nt4v142Ev();
extern void _ZN8S79C5_nt4v143Ev();
extern void _ZN8S79C5_nt4v144Ev();
extern void _ZN8S79C5_nt4v145Ev();
static  VTBL_ENTRY vtc_S79C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v145Ev,
};
extern VTBL_ENTRY _ZTI8S79C5_nt[];
VTBL_ENTRY *P__ZTI8S79C5_nt = _ZTI8S79C5_nt; 
extern  VTBL_ENTRY _ZTV8S79C5_nt[];
Class_Descriptor cd_S79C5_nt = {  "S79C5_nt", // class name
  bases_S79C5_nt, 2,
  &(vtc_S79C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI8S79C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S79C5_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C23_nt  {
  int s79c23f0[4];
  void  mf79c23(); // _ZN9S79C23_nt7mf79c23Ev
};
//SIG(-1 S79C23_nt) C1{ m Fi[4]}


void  S79C23_nt ::mf79c23(){}

//skip512 S79C23_nt

#else // __cplusplus

Class_Descriptor cd_S79C23_nt = {  "S79C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C22_nt  : S79C23_nt {
};
//SIG(-1 S79C22_nt) C1{ BC2{ m Fi[4]}}



//skip512 S79C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C23_nt;
static Base_Class bases_S79C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C24_nt  {
  ::S79C8_nt s79c24f0;
  void *s79c24f1;
  ::S79C22_nt s79c24f2;
  void *s79c24f3;
  void  mf79c24(); // _ZN9S79C24_nt7mf79c24Ev
};
//SIG(-1 S79C24_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S79C24_nt ::mf79c24(){}

//skip512 S79C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C26_nt  {
  void *s79c26f0[8];
  char s79c26f1[4];
  void  mf79c26(); // _ZN9S79C26_nt7mf79c26Ev
};
//SIG(-1 S79C26_nt) C1{ m Fp[8] Fc[4]}


void  S79C26_nt ::mf79c26(){}

//skip512 S79C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C28_nt  {
  int s79c28f0[4];
  char s79c28f1[4];
  void  mf79c28(); // _ZN9S79C28_nt7mf79c28Ev
};
//SIG(-1 S79C28_nt) C1{ m Fi[4] Fc[4]}


void  S79C28_nt ::mf79c28(){}

//skip512 S79C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C27_nt  {
  void *s79c27f0[5];
  ::S79C28_nt s79c27f1;
  unsigned int s79c27f2:1;
  unsigned int s79c27f3:1;
  int s79c27f4;
  char s79c27f5[8];
  void  mf79c27(); // _ZN9S79C27_nt7mf79c27Ev
};
//SIG(-1 S79C27_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S79C27_nt ::mf79c27(){}

//skip512 S79C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C31_nt  {
  int s79c31f0[3];
  void  mf79c31(); // _ZN9S79C31_nt7mf79c31Ev
};
//SIG(-1 S79C31_nt) C1{ m Fi[3]}


void  S79C31_nt ::mf79c31(){}

//skip512 S79C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C32_nt  {
  void  mf79c32(); // _ZN9S79C32_nt7mf79c32Ev
};
//SIG(-1 S79C32_nt) C1{ m}


void  S79C32_nt ::mf79c32(){}

//skip512 S79C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C34_nt  {
  int s79c34f0[2];
  char s79c34f1[2];
  void  mf79c34(); // _ZN9S79C34_nt7mf79c34Ev
};
//SIG(-1 S79C34_nt) C1{ m Fi[2] Fc[2]}


void  S79C34_nt ::mf79c34(){}

//skip512 S79C34_nt

#else // __cplusplus

Class_Descriptor cd_S79C34_nt = {  "S79C34_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C33_nt  : S79C34_nt {
  int s79c33f0;
};
//SIG(-1 S79C33_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S79C33_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C34_nt;
static Base_Class bases_S79C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C30_nt  {
  ::S79C31_nt s79c30f0;
  ::S79C32_nt s79c30f1;
  ::S79C33_nt s79c30f2;
  char s79c30f3;
  void  mf79c30(); // _ZN9S79C30_nt7mf79c30Ev
};
//SIG(-1 S79C30_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S79C30_nt ::mf79c30(){}

//skip512 S79C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C38_nt  {
  void *s79c38f0[2];
  void  mf79c38(); // _ZN9S79C38_nt7mf79c38Ev
};
//SIG(-1 S79C38_nt) C1{ m Fp[2]}


void  S79C38_nt ::mf79c38(){}

//skip512 S79C38_nt

#else // __cplusplus

Class_Descriptor cd_S79C38_nt = {  "S79C38_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C37_nt  : S79C38_nt {
};
//SIG(-1 S79C37_nt) C1{ BC2{ m Fp[2]}}



//skip512 S79C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C38_nt;
static Base_Class bases_S79C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C41  : S79C12_nt {
};
//SIG(-1 S79C41) C1{ BC2{ m Fp Fi[2]}}



static void Test_S79C41()
{
  extern Class_Descriptor cd_S79C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C41, buf);
    S79C41 &lv = *(new (buf) S79C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C41)");
    check_base_class_offset(lv, (S79C12_nt*), 0, "S79C41");
    test_class_info(&lv, &cd_S79C41);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C41(Test_S79C41, "S79C41", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
static Base_Class bases_S79C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C41 = {  "S79C41", // class name
  bases_S79C41, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C40  : S79C41 {
};
//SIG(-1 S79C40) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S79C40()
{
  extern Class_Descriptor cd_S79C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C40, buf);
    S79C40 &lv = *(new (buf) S79C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C40)");
    check_base_class_offset(lv, (S79C12_nt*)(S79C41*), 0, "S79C40");
    check_base_class_offset(lv, (S79C41*), 0, "S79C40");
    test_class_info(&lv, &cd_S79C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C40(Test_S79C40, "S79C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C41;
static Base_Class bases_S79C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C40 = {  "S79C40", // class name
  bases_S79C40, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C39_nt  : S79C40 {
};
//SIG(-1 S79C39_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S79C39_nt

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C41;
extern Class_Descriptor cd_S79C40;
static Base_Class bases_S79C39_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S79C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C36_nt  {
  ::S79C37_nt s79c36f0;
  char s79c36f1;
  ::S79C39_nt s79c36f2;
  int s79c36f3;
  ::S79C8_nt s79c36f4;
  ::S79C8_nt s79c36f5;
  void *s79c36f6;
  void  mf79c36(); // _ZN9S79C36_nt7mf79c36Ev
};
//SIG(-1 S79C36_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S79C36_nt ::mf79c36(){}

//skip512 S79C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C45  : S79C12_nt {
};
//SIG(-1 S79C45) C1{ BC2{ m Fp Fi[2]}}



static void Test_S79C45()
{
  extern Class_Descriptor cd_S79C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C45, buf);
    S79C45 &lv = *(new (buf) S79C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C45)");
    check_base_class_offset(lv, (S79C12_nt*), 0, "S79C45");
    test_class_info(&lv, &cd_S79C45);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C45(Test_S79C45, "S79C45", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
static Base_Class bases_S79C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C45 = {  "S79C45", // class name
  bases_S79C45, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C44  : S79C45 {
};
//SIG(-1 S79C44) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S79C44()
{
  extern Class_Descriptor cd_S79C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S79C44, buf);
    S79C44 &lv = *(new (buf) S79C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S79C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C44)");
    check_base_class_offset(lv, (S79C12_nt*)(S79C45*), 0, "S79C44");
    check_base_class_offset(lv, (S79C45*), 0, "S79C44");
    test_class_info(&lv, &cd_S79C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C44(Test_S79C44, "S79C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S79C12_nt;
extern Class_Descriptor cd_S79C45;
static Base_Class bases_S79C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C45,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S79C44 = {  "S79C44", // class name
  bases_S79C44, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C4_nt  : S79C5_nt {
  ::S79C22_nt s79c4f0;
  ::S79C8_nt s79c4f1;
  void *s79c4f2[2];
  ::S79C24_nt s79c4f3;
  ::S79C26_nt s79c4f4;
  int s79c4f5;
  ::S79C27_nt s79c4f6;
  int s79c4f7[4];
  ::S79C8_nt s79c4f8[4];
  ::S79C30_nt s79c4f9;
  ::S79C31_nt s79c4f10;
  int s79c4f11;
  ::S79C36_nt s79c4f12;
  ::S79C36_nt s79c4f13;
  void *s79c4f14;
  ::S79C31_nt s79c4f15;
  ::S79C19 s79c4f16;
  ::S79C44 s79c4f17;
  unsigned int s79c4f18:1;
  unsigned int s79c4f19:1;
  unsigned int s79c4f20:1;
  ::S79C32_nt s79c4f21;
  ::S79C21_nt s79c4f22;
  ::S79C21_nt s79c4f23;
  ::S79C21_nt s79c4f24;
  ::S79C21_nt s79c4f25;
  ::S79C21_nt s79c4f26;
  ::S79C21_nt s79c4f27;
  ::S79C21_nt s79c4f28;
  ::S79C21_nt s79c4f29;
  ::S79C21_nt s79c4f30;
  ::S79C21_nt s79c4f31;
  ::S79C21_nt s79c4f32;
  ::S79C21_nt s79c4f33;
  ::S79C21_nt s79c4f34;
  virtual  ~S79C4_nt(); // _ZN8S79C4_ntD1Ev
  virtual void  v146(); // _ZN8S79C4_nt4v146Ev
  virtual void  v147(); // _ZN8S79C4_nt4v147Ev
  virtual void  v148(); // _ZN8S79C4_nt4v148Ev
  virtual void  v149(); // _ZN8S79C4_nt4v149Ev
  virtual void  v150(); // _ZN8S79C4_nt4v150Ev
  virtual void  v151(); // _ZN8S79C4_nt4v151Ev
  virtual void  v152(); // _ZN8S79C4_nt4v152Ev
  virtual void  v153(); // _ZN8S79C4_nt4v153Ev
  virtual void  v154(); // _ZN8S79C4_nt4v154Ev
  virtual void  v155(); // _ZN8S79C4_nt4v155Ev
  virtual void  v156(); // _ZN8S79C4_nt4v156Ev
  virtual void  v157(); // _ZN8S79C4_nt4v157Ev
  virtual void  v158(); // _ZN8S79C4_nt4v158Ev
  virtual void  v159(); // _ZN8S79C4_nt4v159Ev
  virtual void  v160(); // _ZN8S79C4_nt4v160Ev
  virtual void  v161(); // _ZN8S79C4_nt4v161Ev
  virtual void  v162(); // _ZN8S79C4_nt4v162Ev
  virtual void  v163(); // _ZN8S79C4_nt4v163Ev
  virtual void  v164(); // _ZN8S79C4_nt4v164Ev
  virtual void  v165(); // _ZN8S79C4_nt4v165Ev
  virtual void  v166(); // _ZN8S79C4_nt4v166Ev
  virtual void  v167(); // _ZN8S79C4_nt4v167Ev
  virtual void  v168(); // _ZN8S79C4_nt4v168Ev
  virtual void  v169(); // _ZN8S79C4_nt4v169Ev
  virtual void  v170(); // _ZN8S79C4_nt4v170Ev
  virtual void  v171(); // _ZN8S79C4_nt4v171Ev
  virtual void  v172(); // _ZN8S79C4_nt4v172Ev
  virtual void  v173(); // _ZN8S79C4_nt4v173Ev
  virtual void  v174(); // _ZN8S79C4_nt4v174Ev
  virtual void  v175(); // _ZN8S79C4_nt4v175Ev
  virtual void  v176(); // _ZN8S79C4_nt4v176Ev
  virtual void  v177(); // _ZN8S79C4_nt4v177Ev
  virtual void  v178(); // _ZN8S79C4_nt4v178Ev
  virtual void  v179(); // _ZN8S79C4_nt4v179Ev
  virtual void  v180(); // _ZN8S79C4_nt4v180Ev
  virtual void  v181(); // _ZN8S79C4_nt4v181Ev
  virtual void  v182(); // _ZN8S79C4_nt4v182Ev
  virtual void  v183(); // _ZN8S79C4_nt4v183Ev
  virtual void  v184(); // _ZN8S79C4_nt4v184Ev
  virtual void  v185(); // _ZN8S79C4_nt4v185Ev
  virtual void  v186(); // _ZN8S79C4_nt4v186Ev
  virtual void  v187(); // _ZN8S79C4_nt4v187Ev
  virtual void  v188(); // _ZN8S79C4_nt4v188Ev
  virtual void  v189(); // _ZN8S79C4_nt4v189Ev
  virtual void  v190(); // _ZN8S79C4_nt4v190Ev
  virtual void  v191(); // _ZN8S79C4_nt4v191Ev
  virtual void  v192(); // _ZN8S79C4_nt4v192Ev
  virtual void  v193(); // _ZN8S79C4_nt4v193Ev
  virtual void  v194(); // _ZN8S79C4_nt4v194Ev
  virtual void  v195(); // _ZN8S79C4_nt4v195Ev
  virtual void  v196(); // _ZN8S79C4_nt4v196Ev
  virtual void  v197(); // _ZN8S79C4_nt4v197Ev
  virtual void  v198(); // _ZN8S79C4_nt4v198Ev
  virtual void  v199(); // _ZN8S79C4_nt4v199Ev
  virtual void  v200(); // _ZN8S79C4_nt4v200Ev
  virtual void  v201(); // _ZN8S79C4_nt4v201Ev
  virtual void  v202(); // _ZN8S79C4_nt4v202Ev
  virtual void  v203(); // _ZN8S79C4_nt4v203Ev
  virtual void  v204(); // _ZN8S79C4_nt4v204Ev
  virtual void  v205(); // _ZN8S79C4_nt4v205Ev
  virtual void  v206(); // _ZN8S79C4_nt4v206Ev
  virtual void  v207(); // _ZN8S79C4_nt4v207Ev
  virtual void  v208(); // _ZN8S79C4_nt4v208Ev
  virtual void  v209(); // _ZN8S79C4_nt4v209Ev
  virtual void  v210(); // _ZN8S79C4_nt4v210Ev
  virtual void  v211(); // _ZN8S79C4_nt4v211Ev
  virtual void  v212(); // _ZN8S79C4_nt4v212Ev
  virtual void  v213(); // _ZN8S79C4_nt4v213Ev
  virtual void  v214(); // _ZN8S79C4_nt4v214Ev
  S79C4_nt(); // tgen
};
//SIG(-1 S79C4_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S79C4_nt ::~S79C4_nt(){ note_dtor("S79C4_nt", this);}
void  S79C4_nt ::v146(){vfunc_called(this, "_ZN8S79C4_nt4v146Ev");}
void  S79C4_nt ::v147(){vfunc_called(this, "_ZN8S79C4_nt4v147Ev");}
void  S79C4_nt ::v148(){vfunc_called(this, "_ZN8S79C4_nt4v148Ev");}
void  S79C4_nt ::v149(){vfunc_called(this, "_ZN8S79C4_nt4v149Ev");}
void  S79C4_nt ::v150(){vfunc_called(this, "_ZN8S79C4_nt4v150Ev");}
void  S79C4_nt ::v151(){vfunc_called(this, "_ZN8S79C4_nt4v151Ev");}
void  S79C4_nt ::v152(){vfunc_called(this, "_ZN8S79C4_nt4v152Ev");}
void  S79C4_nt ::v153(){vfunc_called(this, "_ZN8S79C4_nt4v153Ev");}
void  S79C4_nt ::v154(){vfunc_called(this, "_ZN8S79C4_nt4v154Ev");}
void  S79C4_nt ::v155(){vfunc_called(this, "_ZN8S79C4_nt4v155Ev");}
void  S79C4_nt ::v156(){vfunc_called(this, "_ZN8S79C4_nt4v156Ev");}
void  S79C4_nt ::v157(){vfunc_called(this, "_ZN8S79C4_nt4v157Ev");}
void  S79C4_nt ::v158(){vfunc_called(this, "_ZN8S79C4_nt4v158Ev");}
void  S79C4_nt ::v159(){vfunc_called(this, "_ZN8S79C4_nt4v159Ev");}
void  S79C4_nt ::v160(){vfunc_called(this, "_ZN8S79C4_nt4v160Ev");}
void  S79C4_nt ::v161(){vfunc_called(this, "_ZN8S79C4_nt4v161Ev");}
void  S79C4_nt ::v162(){vfunc_called(this, "_ZN8S79C4_nt4v162Ev");}
void  S79C4_nt ::v163(){vfunc_called(this, "_ZN8S79C4_nt4v163Ev");}
void  S79C4_nt ::v164(){vfunc_called(this, "_ZN8S79C4_nt4v164Ev");}
void  S79C4_nt ::v165(){vfunc_called(this, "_ZN8S79C4_nt4v165Ev");}
void  S79C4_nt ::v166(){vfunc_called(this, "_ZN8S79C4_nt4v166Ev");}
void  S79C4_nt ::v167(){vfunc_called(this, "_ZN8S79C4_nt4v167Ev");}
void  S79C4_nt ::v168(){vfunc_called(this, "_ZN8S79C4_nt4v168Ev");}
void  S79C4_nt ::v169(){vfunc_called(this, "_ZN8S79C4_nt4v169Ev");}
void  S79C4_nt ::v170(){vfunc_called(this, "_ZN8S79C4_nt4v170Ev");}
void  S79C4_nt ::v171(){vfunc_called(this, "_ZN8S79C4_nt4v171Ev");}
void  S79C4_nt ::v172(){vfunc_called(this, "_ZN8S79C4_nt4v172Ev");}
void  S79C4_nt ::v173(){vfunc_called(this, "_ZN8S79C4_nt4v173Ev");}
void  S79C4_nt ::v174(){vfunc_called(this, "_ZN8S79C4_nt4v174Ev");}
void  S79C4_nt ::v175(){vfunc_called(this, "_ZN8S79C4_nt4v175Ev");}
void  S79C4_nt ::v176(){vfunc_called(this, "_ZN8S79C4_nt4v176Ev");}
void  S79C4_nt ::v177(){vfunc_called(this, "_ZN8S79C4_nt4v177Ev");}
void  S79C4_nt ::v178(){vfunc_called(this, "_ZN8S79C4_nt4v178Ev");}
void  S79C4_nt ::v179(){vfunc_called(this, "_ZN8S79C4_nt4v179Ev");}
void  S79C4_nt ::v180(){vfunc_called(this, "_ZN8S79C4_nt4v180Ev");}
void  S79C4_nt ::v181(){vfunc_called(this, "_ZN8S79C4_nt4v181Ev");}
void  S79C4_nt ::v182(){vfunc_called(this, "_ZN8S79C4_nt4v182Ev");}
void  S79C4_nt ::v183(){vfunc_called(this, "_ZN8S79C4_nt4v183Ev");}
void  S79C4_nt ::v184(){vfunc_called(this, "_ZN8S79C4_nt4v184Ev");}
void  S79C4_nt ::v185(){vfunc_called(this, "_ZN8S79C4_nt4v185Ev");}
void  S79C4_nt ::v186(){vfunc_called(this, "_ZN8S79C4_nt4v186Ev");}
void  S79C4_nt ::v187(){vfunc_called(this, "_ZN8S79C4_nt4v187Ev");}
void  S79C4_nt ::v188(){vfunc_called(this, "_ZN8S79C4_nt4v188Ev");}
void  S79C4_nt ::v189(){vfunc_called(this, "_ZN8S79C4_nt4v189Ev");}
void  S79C4_nt ::v190(){vfunc_called(this, "_ZN8S79C4_nt4v190Ev");}
void  S79C4_nt ::v191(){vfunc_called(this, "_ZN8S79C4_nt4v191Ev");}
void  S79C4_nt ::v192(){vfunc_called(this, "_ZN8S79C4_nt4v192Ev");}
void  S79C4_nt ::v193(){vfunc_called(this, "_ZN8S79C4_nt4v193Ev");}
void  S79C4_nt ::v194(){vfunc_called(this, "_ZN8S79C4_nt4v194Ev");}
void  S79C4_nt ::v195(){vfunc_called(this, "_ZN8S79C4_nt4v195Ev");}
void  S79C4_nt ::v196(){vfunc_called(this, "_ZN8S79C4_nt4v196Ev");}
void  S79C4_nt ::v197(){vfunc_called(this, "_ZN8S79C4_nt4v197Ev");}
void  S79C4_nt ::v198(){vfunc_called(this, "_ZN8S79C4_nt4v198Ev");}
void  S79C4_nt ::v199(){vfunc_called(this, "_ZN8S79C4_nt4v199Ev");}
void  S79C4_nt ::v200(){vfunc_called(this, "_ZN8S79C4_nt4v200Ev");}
void  S79C4_nt ::v201(){vfunc_called(this, "_ZN8S79C4_nt4v201Ev");}
void  S79C4_nt ::v202(){vfunc_called(this, "_ZN8S79C4_nt4v202Ev");}
void  S79C4_nt ::v203(){vfunc_called(this, "_ZN8S79C4_nt4v203Ev");}
void  S79C4_nt ::v204(){vfunc_called(this, "_ZN8S79C4_nt4v204Ev");}
void  S79C4_nt ::v205(){vfunc_called(this, "_ZN8S79C4_nt4v205Ev");}
void  S79C4_nt ::v206(){vfunc_called(this, "_ZN8S79C4_nt4v206Ev");}
void  S79C4_nt ::v207(){vfunc_called(this, "_ZN8S79C4_nt4v207Ev");}
void  S79C4_nt ::v208(){vfunc_called(this, "_ZN8S79C4_nt4v208Ev");}
void  S79C4_nt ::v209(){vfunc_called(this, "_ZN8S79C4_nt4v209Ev");}
void  S79C4_nt ::v210(){vfunc_called(this, "_ZN8S79C4_nt4v210Ev");}
void  S79C4_nt ::v211(){vfunc_called(this, "_ZN8S79C4_nt4v211Ev");}
void  S79C4_nt ::v212(){vfunc_called(this, "_ZN8S79C4_nt4v212Ev");}
void  S79C4_nt ::v213(){vfunc_called(this, "_ZN8S79C4_nt4v213Ev");}
void  S79C4_nt ::v214(){vfunc_called(this, "_ZN8S79C4_nt4v214Ev");}
S79C4_nt ::S79C4_nt(){ note_ctor("S79C4_nt", this);} // tgen

//skip512 S79C4_nt

#else // __cplusplus

extern void _ZN8S79C4_ntC1Ev();
extern void _ZN8S79C4_ntD1Ev();
Name_Map name_map_S79C4_nt[] = {
  NSPAIR(_ZN8S79C4_ntC1Ev),
  NSPAIR(_ZN8S79C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
extern Class_Descriptor cd_S79C6_nt;
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
extern Class_Descriptor cd_S79C5_nt;
extern VTBL_ENTRY _ZTI8S79C5_nt[];
extern  VTBL_ENTRY _ZTV8S79C5_nt[];
static Base_Class bases_S79C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S79C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S79C4_nt[];
extern void _ZN8S79C4_ntD1Ev();
extern void _ZN8S79C4_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
extern void _ZN8S79C5_nt3v70Ev();
extern void _ZN8S79C5_nt3v71Ev();
extern void _ZN8S79C5_nt3v72Ev();
extern void _ZN8S79C5_nt3v73Ev();
extern void _ZN8S79C5_nt3v74Ev();
extern void _ZN8S79C5_nt3v75Ev();
extern void _ZN8S79C5_nt3v76Ev();
extern void _ZN8S79C5_nt3v77Ev();
extern void _ZN8S79C5_nt3v78Ev();
extern void _ZN8S79C5_nt3v79Ev();
extern void _ZN8S79C5_nt3v80Ev();
extern void _ZN8S79C5_nt3v81Ev();
extern void _ZN8S79C5_nt3v82Ev();
extern void _ZN8S79C5_nt3v83Ev();
extern void _ZN8S79C5_nt3v84Ev();
extern void _ZN8S79C5_nt3v85Ev();
extern void _ZN8S79C5_nt3v86Ev();
extern void _ZN8S79C5_nt3v87Ev();
extern void _ZN8S79C5_nt3v88Ev();
extern void _ZN8S79C5_nt3v89Ev();
extern void _ZN8S79C5_nt3v90Ev();
extern void _ZN8S79C5_nt3v91Ev();
extern void _ZN8S79C5_nt3v92Ev();
extern void _ZN8S79C5_nt3v93Ev();
extern void _ZN8S79C5_nt3v94Ev();
extern void _ZN8S79C5_nt3v95Ev();
extern void _ZN8S79C5_nt3v96Ev();
extern void _ZN8S79C5_nt3v97Ev();
extern void _ZN8S79C5_nt3v98Ev();
extern void _ZN8S79C5_nt3v99Ev();
extern void _ZN8S79C5_nt4v100Ev();
extern void _ZN8S79C5_nt4v101Ev();
extern void _ZN8S79C5_nt4v102Ev();
extern void _ZN8S79C5_nt4v103Ev();
extern void _ZN8S79C5_nt4v104Ev();
extern void _ZN8S79C5_nt4v105Ev();
extern void _ZN8S79C5_nt4v106Ev();
extern void _ZN8S79C5_nt4v107Ev();
extern void _ZN8S79C5_nt4v108Ev();
extern void _ZN8S79C5_nt4v109Ev();
extern void _ZN8S79C5_nt4v110Ev();
extern void _ZN8S79C5_nt4v111Ev();
extern void _ZN8S79C5_nt4v112Ev();
extern void _ZN8S79C5_nt4v113Ev();
extern void _ZN8S79C5_nt4v114Ev();
extern void _ZN8S79C5_nt4v115Ev();
extern void _ZN8S79C5_nt4v116Ev();
extern void _ZN8S79C5_nt4v117Ev();
extern void _ZN8S79C5_nt4v118Ev();
extern void _ZN8S79C5_nt4v119Ev();
extern void _ZN8S79C5_nt4v120Ev();
extern void _ZN8S79C5_nt4v121Ev();
extern void _ZN8S79C5_nt4v122Ev();
extern void _ZN8S79C5_nt4v123Ev();
extern void _ZN8S79C5_nt4v124Ev();
extern void _ZN8S79C5_nt4v125Ev();
extern void _ZN8S79C5_nt4v126Ev();
extern void _ZN8S79C5_nt4v127Ev();
extern void _ZN8S79C5_nt4v128Ev();
extern void _ZN8S79C5_nt4v129Ev();
extern void _ZN8S79C5_nt4v130Ev();
extern void _ZN8S79C5_nt4v131Ev();
extern void _ZN8S79C5_nt4v132Ev();
extern void _ZN8S79C5_nt4v133Ev();
extern void _ZN8S79C5_nt4v134Ev();
extern void _ZN8S79C5_nt4v135Ev();
extern void _ZN8S79C5_nt4v136Ev();
extern void _ZN8S79C5_nt4v137Ev();
extern void _ZN8S79C5_nt4v138Ev();
extern void _ZN8S79C5_nt4v139Ev();
extern void _ZN8S79C5_nt4v140Ev();
extern void _ZN8S79C5_nt4v141Ev();
extern void _ZN8S79C5_nt4v142Ev();
extern void _ZN8S79C5_nt4v143Ev();
extern void _ZN8S79C5_nt4v144Ev();
extern void _ZN8S79C5_nt4v145Ev();
extern void _ZN8S79C4_nt4v146Ev();
extern void _ZN8S79C4_nt4v147Ev();
extern void _ZN8S79C4_nt4v148Ev();
extern void _ZN8S79C4_nt4v149Ev();
extern void _ZN8S79C4_nt4v150Ev();
extern void _ZN8S79C4_nt4v151Ev();
extern void _ZN8S79C4_nt4v152Ev();
extern void _ZN8S79C4_nt4v153Ev();
extern void _ZN8S79C4_nt4v154Ev();
extern void _ZN8S79C4_nt4v155Ev();
extern void _ZN8S79C4_nt4v156Ev();
extern void _ZN8S79C4_nt4v157Ev();
extern void _ZN8S79C4_nt4v158Ev();
extern void _ZN8S79C4_nt4v159Ev();
extern void _ZN8S79C4_nt4v160Ev();
extern void _ZN8S79C4_nt4v161Ev();
extern void _ZN8S79C4_nt4v162Ev();
extern void _ZN8S79C4_nt4v163Ev();
extern void _ZN8S79C4_nt4v164Ev();
extern void _ZN8S79C4_nt4v165Ev();
extern void _ZN8S79C4_nt4v166Ev();
extern void _ZN8S79C4_nt4v167Ev();
extern void _ZN8S79C4_nt4v168Ev();
extern void _ZN8S79C4_nt4v169Ev();
extern void _ZN8S79C4_nt4v170Ev();
extern void _ZN8S79C4_nt4v171Ev();
extern void _ZN8S79C4_nt4v172Ev();
extern void _ZN8S79C4_nt4v173Ev();
extern void _ZN8S79C4_nt4v174Ev();
extern void _ZN8S79C4_nt4v175Ev();
extern void _ZN8S79C4_nt4v176Ev();
extern void _ZN8S79C4_nt4v177Ev();
extern void _ZN8S79C4_nt4v178Ev();
extern void _ZN8S79C4_nt4v179Ev();
extern void _ZN8S79C4_nt4v180Ev();
extern void _ZN8S79C4_nt4v181Ev();
extern void _ZN8S79C4_nt4v182Ev();
extern void _ZN8S79C4_nt4v183Ev();
extern void _ZN8S79C4_nt4v184Ev();
extern void _ZN8S79C4_nt4v185Ev();
extern void _ZN8S79C4_nt4v186Ev();
extern void _ZN8S79C4_nt4v187Ev();
extern void _ZN8S79C4_nt4v188Ev();
extern void _ZN8S79C4_nt4v189Ev();
extern void _ZN8S79C4_nt4v190Ev();
extern void _ZN8S79C4_nt4v191Ev();
extern void _ZN8S79C4_nt4v192Ev();
extern void _ZN8S79C4_nt4v193Ev();
extern void _ZN8S79C4_nt4v194Ev();
extern void _ZN8S79C4_nt4v195Ev();
extern void _ZN8S79C4_nt4v196Ev();
extern void _ZN8S79C4_nt4v197Ev();
extern void _ZN8S79C4_nt4v198Ev();
extern void _ZN8S79C4_nt4v199Ev();
extern void _ZN8S79C4_nt4v200Ev();
extern void _ZN8S79C4_nt4v201Ev();
extern void _ZN8S79C4_nt4v202Ev();
extern void _ZN8S79C4_nt4v203Ev();
extern void _ZN8S79C4_nt4v204Ev();
extern void _ZN8S79C4_nt4v205Ev();
extern void _ZN8S79C4_nt4v206Ev();
extern void _ZN8S79C4_nt4v207Ev();
extern void _ZN8S79C4_nt4v208Ev();
extern void _ZN8S79C4_nt4v209Ev();
extern void _ZN8S79C4_nt4v210Ev();
extern void _ZN8S79C4_nt4v211Ev();
extern void _ZN8S79C4_nt4v212Ev();
extern void _ZN8S79C4_nt4v213Ev();
extern void _ZN8S79C4_nt4v214Ev();
static  VTBL_ENTRY vtc_S79C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C4_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v214Ev,
};
extern VTBL_ENTRY _ZTI8S79C4_nt[];
VTBL_ENTRY *P__ZTI8S79C4_nt = _ZTI8S79C4_nt; 
extern  VTBL_ENTRY _ZTV8S79C4_nt[];
Class_Descriptor cd_S79C4_nt = {  "S79C4_nt", // class name
  bases_S79C4_nt, 3,
  &(vtc_S79C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI8S79C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S79C4_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C3_nt  : S79C4_nt {
  unsigned int s79c3f0:1;
  void *s79c3f1;
  virtual  ~S79C3_nt(); // _ZN8S79C3_ntD1Ev
  virtual void  v215(); // _ZN8S79C3_nt4v215Ev
  virtual void  v216(); // _ZN8S79C3_nt4v216Ev
  virtual void  v217(); // _ZN8S79C3_nt4v217Ev
  virtual void  v218(); // _ZN8S79C3_nt4v218Ev
  virtual void  v219(); // _ZN8S79C3_nt4v219Ev
  virtual void  v220(); // _ZN8S79C3_nt4v220Ev
  S79C3_nt(); // tgen
};
//SIG(-1 S79C3_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 Fi:1 Fp}


 S79C3_nt ::~S79C3_nt(){ note_dtor("S79C3_nt", this);}
void  S79C3_nt ::v215(){vfunc_called(this, "_ZN8S79C3_nt4v215Ev");}
void  S79C3_nt ::v216(){vfunc_called(this, "_ZN8S79C3_nt4v216Ev");}
void  S79C3_nt ::v217(){vfunc_called(this, "_ZN8S79C3_nt4v217Ev");}
void  S79C3_nt ::v218(){vfunc_called(this, "_ZN8S79C3_nt4v218Ev");}
void  S79C3_nt ::v219(){vfunc_called(this, "_ZN8S79C3_nt4v219Ev");}
void  S79C3_nt ::v220(){vfunc_called(this, "_ZN8S79C3_nt4v220Ev");}
S79C3_nt ::S79C3_nt(){ note_ctor("S79C3_nt", this);} // tgen

//skip512 S79C3_nt

#else // __cplusplus

extern void _ZN8S79C3_ntC1Ev();
extern void _ZN8S79C3_ntD1Ev();
Name_Map name_map_S79C3_nt[] = {
  NSPAIR(_ZN8S79C3_ntC1Ev),
  NSPAIR(_ZN8S79C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
extern Class_Descriptor cd_S79C6_nt;
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
extern Class_Descriptor cd_S79C5_nt;
extern VTBL_ENTRY _ZTI8S79C5_nt[];
extern  VTBL_ENTRY _ZTV8S79C5_nt[];
extern Class_Descriptor cd_S79C4_nt;
extern VTBL_ENTRY _ZTI8S79C4_nt[];
extern  VTBL_ENTRY _ZTV8S79C4_nt[];
static Base_Class bases_S79C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S79C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S79C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S79C3_nt[];
extern void _ZN8S79C3_ntD1Ev();
extern void _ZN8S79C3_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
extern void _ZN8S79C5_nt3v70Ev();
extern void _ZN8S79C5_nt3v71Ev();
extern void _ZN8S79C5_nt3v72Ev();
extern void _ZN8S79C5_nt3v73Ev();
extern void _ZN8S79C5_nt3v74Ev();
extern void _ZN8S79C5_nt3v75Ev();
extern void _ZN8S79C5_nt3v76Ev();
extern void _ZN8S79C5_nt3v77Ev();
extern void _ZN8S79C5_nt3v78Ev();
extern void _ZN8S79C5_nt3v79Ev();
extern void _ZN8S79C5_nt3v80Ev();
extern void _ZN8S79C5_nt3v81Ev();
extern void _ZN8S79C5_nt3v82Ev();
extern void _ZN8S79C5_nt3v83Ev();
extern void _ZN8S79C5_nt3v84Ev();
extern void _ZN8S79C5_nt3v85Ev();
extern void _ZN8S79C5_nt3v86Ev();
extern void _ZN8S79C5_nt3v87Ev();
extern void _ZN8S79C5_nt3v88Ev();
extern void _ZN8S79C5_nt3v89Ev();
extern void _ZN8S79C5_nt3v90Ev();
extern void _ZN8S79C5_nt3v91Ev();
extern void _ZN8S79C5_nt3v92Ev();
extern void _ZN8S79C5_nt3v93Ev();
extern void _ZN8S79C5_nt3v94Ev();
extern void _ZN8S79C5_nt3v95Ev();
extern void _ZN8S79C5_nt3v96Ev();
extern void _ZN8S79C5_nt3v97Ev();
extern void _ZN8S79C5_nt3v98Ev();
extern void _ZN8S79C5_nt3v99Ev();
extern void _ZN8S79C5_nt4v100Ev();
extern void _ZN8S79C5_nt4v101Ev();
extern void _ZN8S79C5_nt4v102Ev();
extern void _ZN8S79C5_nt4v103Ev();
extern void _ZN8S79C5_nt4v104Ev();
extern void _ZN8S79C5_nt4v105Ev();
extern void _ZN8S79C5_nt4v106Ev();
extern void _ZN8S79C5_nt4v107Ev();
extern void _ZN8S79C5_nt4v108Ev();
extern void _ZN8S79C5_nt4v109Ev();
extern void _ZN8S79C5_nt4v110Ev();
extern void _ZN8S79C5_nt4v111Ev();
extern void _ZN8S79C5_nt4v112Ev();
extern void _ZN8S79C5_nt4v113Ev();
extern void _ZN8S79C5_nt4v114Ev();
extern void _ZN8S79C5_nt4v115Ev();
extern void _ZN8S79C5_nt4v116Ev();
extern void _ZN8S79C5_nt4v117Ev();
extern void _ZN8S79C5_nt4v118Ev();
extern void _ZN8S79C5_nt4v119Ev();
extern void _ZN8S79C5_nt4v120Ev();
extern void _ZN8S79C5_nt4v121Ev();
extern void _ZN8S79C5_nt4v122Ev();
extern void _ZN8S79C5_nt4v123Ev();
extern void _ZN8S79C5_nt4v124Ev();
extern void _ZN8S79C5_nt4v125Ev();
extern void _ZN8S79C5_nt4v126Ev();
extern void _ZN8S79C5_nt4v127Ev();
extern void _ZN8S79C5_nt4v128Ev();
extern void _ZN8S79C5_nt4v129Ev();
extern void _ZN8S79C5_nt4v130Ev();
extern void _ZN8S79C5_nt4v131Ev();
extern void _ZN8S79C5_nt4v132Ev();
extern void _ZN8S79C5_nt4v133Ev();
extern void _ZN8S79C5_nt4v134Ev();
extern void _ZN8S79C5_nt4v135Ev();
extern void _ZN8S79C5_nt4v136Ev();
extern void _ZN8S79C5_nt4v137Ev();
extern void _ZN8S79C5_nt4v138Ev();
extern void _ZN8S79C5_nt4v139Ev();
extern void _ZN8S79C5_nt4v140Ev();
extern void _ZN8S79C5_nt4v141Ev();
extern void _ZN8S79C5_nt4v142Ev();
extern void _ZN8S79C5_nt4v143Ev();
extern void _ZN8S79C5_nt4v144Ev();
extern void _ZN8S79C5_nt4v145Ev();
extern void _ZN8S79C4_nt4v146Ev();
extern void _ZN8S79C4_nt4v147Ev();
extern void _ZN8S79C4_nt4v148Ev();
extern void _ZN8S79C4_nt4v149Ev();
extern void _ZN8S79C4_nt4v150Ev();
extern void _ZN8S79C4_nt4v151Ev();
extern void _ZN8S79C4_nt4v152Ev();
extern void _ZN8S79C4_nt4v153Ev();
extern void _ZN8S79C4_nt4v154Ev();
extern void _ZN8S79C4_nt4v155Ev();
extern void _ZN8S79C4_nt4v156Ev();
extern void _ZN8S79C4_nt4v157Ev();
extern void _ZN8S79C4_nt4v158Ev();
extern void _ZN8S79C4_nt4v159Ev();
extern void _ZN8S79C4_nt4v160Ev();
extern void _ZN8S79C4_nt4v161Ev();
extern void _ZN8S79C4_nt4v162Ev();
extern void _ZN8S79C4_nt4v163Ev();
extern void _ZN8S79C4_nt4v164Ev();
extern void _ZN8S79C4_nt4v165Ev();
extern void _ZN8S79C4_nt4v166Ev();
extern void _ZN8S79C4_nt4v167Ev();
extern void _ZN8S79C4_nt4v168Ev();
extern void _ZN8S79C4_nt4v169Ev();
extern void _ZN8S79C4_nt4v170Ev();
extern void _ZN8S79C4_nt4v171Ev();
extern void _ZN8S79C4_nt4v172Ev();
extern void _ZN8S79C4_nt4v173Ev();
extern void _ZN8S79C4_nt4v174Ev();
extern void _ZN8S79C4_nt4v175Ev();
extern void _ZN8S79C4_nt4v176Ev();
extern void _ZN8S79C4_nt4v177Ev();
extern void _ZN8S79C4_nt4v178Ev();
extern void _ZN8S79C4_nt4v179Ev();
extern void _ZN8S79C4_nt4v180Ev();
extern void _ZN8S79C4_nt4v181Ev();
extern void _ZN8S79C4_nt4v182Ev();
extern void _ZN8S79C4_nt4v183Ev();
extern void _ZN8S79C4_nt4v184Ev();
extern void _ZN8S79C4_nt4v185Ev();
extern void _ZN8S79C4_nt4v186Ev();
extern void _ZN8S79C4_nt4v187Ev();
extern void _ZN8S79C4_nt4v188Ev();
extern void _ZN8S79C4_nt4v189Ev();
extern void _ZN8S79C4_nt4v190Ev();
extern void _ZN8S79C4_nt4v191Ev();
extern void _ZN8S79C4_nt4v192Ev();
extern void _ZN8S79C4_nt4v193Ev();
extern void _ZN8S79C4_nt4v194Ev();
extern void _ZN8S79C4_nt4v195Ev();
extern void _ZN8S79C4_nt4v196Ev();
extern void _ZN8S79C4_nt4v197Ev();
extern void _ZN8S79C4_nt4v198Ev();
extern void _ZN8S79C4_nt4v199Ev();
extern void _ZN8S79C4_nt4v200Ev();
extern void _ZN8S79C4_nt4v201Ev();
extern void _ZN8S79C4_nt4v202Ev();
extern void _ZN8S79C4_nt4v203Ev();
extern void _ZN8S79C4_nt4v204Ev();
extern void _ZN8S79C4_nt4v205Ev();
extern void _ZN8S79C4_nt4v206Ev();
extern void _ZN8S79C4_nt4v207Ev();
extern void _ZN8S79C4_nt4v208Ev();
extern void _ZN8S79C4_nt4v209Ev();
extern void _ZN8S79C4_nt4v210Ev();
extern void _ZN8S79C4_nt4v211Ev();
extern void _ZN8S79C4_nt4v212Ev();
extern void _ZN8S79C4_nt4v213Ev();
extern void _ZN8S79C4_nt4v214Ev();
extern void _ZN8S79C3_nt4v215Ev();
extern void _ZN8S79C3_nt4v216Ev();
extern void _ZN8S79C3_nt4v217Ev();
extern void _ZN8S79C3_nt4v218Ev();
extern void _ZN8S79C3_nt4v219Ev();
extern void _ZN8S79C3_nt4v220Ev();
static  VTBL_ENTRY vtc_S79C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C3_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v220Ev,
};
extern VTBL_ENTRY _ZTI8S79C3_nt[];
VTBL_ENTRY *P__ZTI8S79C3_nt = _ZTI8S79C3_nt; 
extern  VTBL_ENTRY _ZTV8S79C3_nt[];
Class_Descriptor cd_S79C3_nt = {  "S79C3_nt", // class name
  bases_S79C3_nt, 4,
  &(vtc_S79C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1240,916), // object size
  NSPAIRA(_ZTI8S79C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S79C3_nt),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C2_nt  : S79C3_nt {
  unsigned int s79c2f0:1;
  void *s79c2f1;
  int s79c2f2[5];
  ::S79C21_nt s79c2f3;
  virtual  ~S79C2_nt(); // _ZN8S79C2_ntD1Ev
  virtual void  v221(); // _ZN8S79C2_nt4v221Ev
  virtual void  v222(); // _ZN8S79C2_nt4v222Ev
  virtual void  v223(); // _ZN8S79C2_nt4v223Ev
  S79C2_nt(); // tgen
};
//SIG(-1 S79C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC17{ BC18{ m Fi[4]}} FC7 Fp[2] FC19{ m FC7 Fp FC17 Fp} FC20{ m Fp[8] Fc[4]} Fi FC21{ m Fp[5] FC22{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC7[4] FC23{ m FC24{ m Fi[3]} FC25{ m} FC26{ BC27{ m Fi[2] Fc[2]} Fi} Fc} FC24 Fi FC28{ m FC29{ BC30{ m Fp[2]}} Fc FC31{ BC32{ BC33{ BC11}}} Fi FC7 FC7 Fp} FC28 Fp FC24 FC14 FC34{ BC35{ BC11}} Fi:1 Fi:1 Fi:1 FC25 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v215 v216 v217 v218 v219 v220 Fi:1 Fp} vd v1 v2 v3 Fi:1 Fp Fi[5] FC16}


 S79C2_nt ::~S79C2_nt(){ note_dtor("S79C2_nt", this);}
void  S79C2_nt ::v221(){vfunc_called(this, "_ZN8S79C2_nt4v221Ev");}
void  S79C2_nt ::v222(){vfunc_called(this, "_ZN8S79C2_nt4v222Ev");}
void  S79C2_nt ::v223(){vfunc_called(this, "_ZN8S79C2_nt4v223Ev");}
S79C2_nt ::S79C2_nt(){ note_ctor("S79C2_nt", this);} // tgen

//skip512 S79C2_nt

#else // __cplusplus

extern void _ZN8S79C2_ntC1Ev();
extern void _ZN8S79C2_ntD1Ev();
Name_Map name_map_S79C2_nt[] = {
  NSPAIR(_ZN8S79C2_ntC1Ev),
  NSPAIR(_ZN8S79C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
extern Class_Descriptor cd_S79C6_nt;
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
extern Class_Descriptor cd_S79C5_nt;
extern VTBL_ENTRY _ZTI8S79C5_nt[];
extern  VTBL_ENTRY _ZTV8S79C5_nt[];
extern Class_Descriptor cd_S79C4_nt;
extern VTBL_ENTRY _ZTI8S79C4_nt[];
extern  VTBL_ENTRY _ZTV8S79C4_nt[];
extern Class_Descriptor cd_S79C3_nt;
extern VTBL_ENTRY _ZTI8S79C3_nt[];
extern  VTBL_ENTRY _ZTV8S79C3_nt[];
static Base_Class bases_S79C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S79C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S79C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S79C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S79C2_nt[];
extern void _ZN8S79C2_ntD1Ev();
extern void _ZN8S79C2_ntD0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
extern void _ZN8S79C5_nt3v70Ev();
extern void _ZN8S79C5_nt3v71Ev();
extern void _ZN8S79C5_nt3v72Ev();
extern void _ZN8S79C5_nt3v73Ev();
extern void _ZN8S79C5_nt3v74Ev();
extern void _ZN8S79C5_nt3v75Ev();
extern void _ZN8S79C5_nt3v76Ev();
extern void _ZN8S79C5_nt3v77Ev();
extern void _ZN8S79C5_nt3v78Ev();
extern void _ZN8S79C5_nt3v79Ev();
extern void _ZN8S79C5_nt3v80Ev();
extern void _ZN8S79C5_nt3v81Ev();
extern void _ZN8S79C5_nt3v82Ev();
extern void _ZN8S79C5_nt3v83Ev();
extern void _ZN8S79C5_nt3v84Ev();
extern void _ZN8S79C5_nt3v85Ev();
extern void _ZN8S79C5_nt3v86Ev();
extern void _ZN8S79C5_nt3v87Ev();
extern void _ZN8S79C5_nt3v88Ev();
extern void _ZN8S79C5_nt3v89Ev();
extern void _ZN8S79C5_nt3v90Ev();
extern void _ZN8S79C5_nt3v91Ev();
extern void _ZN8S79C5_nt3v92Ev();
extern void _ZN8S79C5_nt3v93Ev();
extern void _ZN8S79C5_nt3v94Ev();
extern void _ZN8S79C5_nt3v95Ev();
extern void _ZN8S79C5_nt3v96Ev();
extern void _ZN8S79C5_nt3v97Ev();
extern void _ZN8S79C5_nt3v98Ev();
extern void _ZN8S79C5_nt3v99Ev();
extern void _ZN8S79C5_nt4v100Ev();
extern void _ZN8S79C5_nt4v101Ev();
extern void _ZN8S79C5_nt4v102Ev();
extern void _ZN8S79C5_nt4v103Ev();
extern void _ZN8S79C5_nt4v104Ev();
extern void _ZN8S79C5_nt4v105Ev();
extern void _ZN8S79C5_nt4v106Ev();
extern void _ZN8S79C5_nt4v107Ev();
extern void _ZN8S79C5_nt4v108Ev();
extern void _ZN8S79C5_nt4v109Ev();
extern void _ZN8S79C5_nt4v110Ev();
extern void _ZN8S79C5_nt4v111Ev();
extern void _ZN8S79C5_nt4v112Ev();
extern void _ZN8S79C5_nt4v113Ev();
extern void _ZN8S79C5_nt4v114Ev();
extern void _ZN8S79C5_nt4v115Ev();
extern void _ZN8S79C5_nt4v116Ev();
extern void _ZN8S79C5_nt4v117Ev();
extern void _ZN8S79C5_nt4v118Ev();
extern void _ZN8S79C5_nt4v119Ev();
extern void _ZN8S79C5_nt4v120Ev();
extern void _ZN8S79C5_nt4v121Ev();
extern void _ZN8S79C5_nt4v122Ev();
extern void _ZN8S79C5_nt4v123Ev();
extern void _ZN8S79C5_nt4v124Ev();
extern void _ZN8S79C5_nt4v125Ev();
extern void _ZN8S79C5_nt4v126Ev();
extern void _ZN8S79C5_nt4v127Ev();
extern void _ZN8S79C5_nt4v128Ev();
extern void _ZN8S79C5_nt4v129Ev();
extern void _ZN8S79C5_nt4v130Ev();
extern void _ZN8S79C5_nt4v131Ev();
extern void _ZN8S79C5_nt4v132Ev();
extern void _ZN8S79C5_nt4v133Ev();
extern void _ZN8S79C5_nt4v134Ev();
extern void _ZN8S79C5_nt4v135Ev();
extern void _ZN8S79C5_nt4v136Ev();
extern void _ZN8S79C5_nt4v137Ev();
extern void _ZN8S79C5_nt4v138Ev();
extern void _ZN8S79C5_nt4v139Ev();
extern void _ZN8S79C5_nt4v140Ev();
extern void _ZN8S79C5_nt4v141Ev();
extern void _ZN8S79C5_nt4v142Ev();
extern void _ZN8S79C5_nt4v143Ev();
extern void _ZN8S79C5_nt4v144Ev();
extern void _ZN8S79C5_nt4v145Ev();
extern void _ZN8S79C4_nt4v146Ev();
extern void _ZN8S79C4_nt4v147Ev();
extern void _ZN8S79C4_nt4v148Ev();
extern void _ZN8S79C4_nt4v149Ev();
extern void _ZN8S79C4_nt4v150Ev();
extern void _ZN8S79C4_nt4v151Ev();
extern void _ZN8S79C4_nt4v152Ev();
extern void _ZN8S79C4_nt4v153Ev();
extern void _ZN8S79C4_nt4v154Ev();
extern void _ZN8S79C4_nt4v155Ev();
extern void _ZN8S79C4_nt4v156Ev();
extern void _ZN8S79C4_nt4v157Ev();
extern void _ZN8S79C4_nt4v158Ev();
extern void _ZN8S79C4_nt4v159Ev();
extern void _ZN8S79C4_nt4v160Ev();
extern void _ZN8S79C4_nt4v161Ev();
extern void _ZN8S79C4_nt4v162Ev();
extern void _ZN8S79C4_nt4v163Ev();
extern void _ZN8S79C4_nt4v164Ev();
extern void _ZN8S79C4_nt4v165Ev();
extern void _ZN8S79C4_nt4v166Ev();
extern void _ZN8S79C4_nt4v167Ev();
extern void _ZN8S79C4_nt4v168Ev();
extern void _ZN8S79C4_nt4v169Ev();
extern void _ZN8S79C4_nt4v170Ev();
extern void _ZN8S79C4_nt4v171Ev();
extern void _ZN8S79C4_nt4v172Ev();
extern void _ZN8S79C4_nt4v173Ev();
extern void _ZN8S79C4_nt4v174Ev();
extern void _ZN8S79C4_nt4v175Ev();
extern void _ZN8S79C4_nt4v176Ev();
extern void _ZN8S79C4_nt4v177Ev();
extern void _ZN8S79C4_nt4v178Ev();
extern void _ZN8S79C4_nt4v179Ev();
extern void _ZN8S79C4_nt4v180Ev();
extern void _ZN8S79C4_nt4v181Ev();
extern void _ZN8S79C4_nt4v182Ev();
extern void _ZN8S79C4_nt4v183Ev();
extern void _ZN8S79C4_nt4v184Ev();
extern void _ZN8S79C4_nt4v185Ev();
extern void _ZN8S79C4_nt4v186Ev();
extern void _ZN8S79C4_nt4v187Ev();
extern void _ZN8S79C4_nt4v188Ev();
extern void _ZN8S79C4_nt4v189Ev();
extern void _ZN8S79C4_nt4v190Ev();
extern void _ZN8S79C4_nt4v191Ev();
extern void _ZN8S79C4_nt4v192Ev();
extern void _ZN8S79C4_nt4v193Ev();
extern void _ZN8S79C4_nt4v194Ev();
extern void _ZN8S79C4_nt4v195Ev();
extern void _ZN8S79C4_nt4v196Ev();
extern void _ZN8S79C4_nt4v197Ev();
extern void _ZN8S79C4_nt4v198Ev();
extern void _ZN8S79C4_nt4v199Ev();
extern void _ZN8S79C4_nt4v200Ev();
extern void _ZN8S79C4_nt4v201Ev();
extern void _ZN8S79C4_nt4v202Ev();
extern void _ZN8S79C4_nt4v203Ev();
extern void _ZN8S79C4_nt4v204Ev();
extern void _ZN8S79C4_nt4v205Ev();
extern void _ZN8S79C4_nt4v206Ev();
extern void _ZN8S79C4_nt4v207Ev();
extern void _ZN8S79C4_nt4v208Ev();
extern void _ZN8S79C4_nt4v209Ev();
extern void _ZN8S79C4_nt4v210Ev();
extern void _ZN8S79C4_nt4v211Ev();
extern void _ZN8S79C4_nt4v212Ev();
extern void _ZN8S79C4_nt4v213Ev();
extern void _ZN8S79C4_nt4v214Ev();
extern void _ZN8S79C3_nt4v215Ev();
extern void _ZN8S79C3_nt4v216Ev();
extern void _ZN8S79C3_nt4v217Ev();
extern void _ZN8S79C3_nt4v218Ev();
extern void _ZN8S79C3_nt4v219Ev();
extern void _ZN8S79C3_nt4v220Ev();
extern void _ZN8S79C2_nt4v221Ev();
extern void _ZN8S79C2_nt4v222Ev();
extern void _ZN8S79C2_nt4v223Ev();
static  VTBL_ENTRY vtc_S79C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S79C2_nt[0]),
  (VTBL_ENTRY)&_ZN8S79C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S79C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v223Ev,
};
extern VTBL_ENTRY _ZTI8S79C2_nt[];
VTBL_ENTRY *P__ZTI8S79C2_nt = _ZTI8S79C2_nt; 
extern  VTBL_ENTRY _ZTV8S79C2_nt[];
Class_Descriptor cd_S79C2_nt = {  "S79C2_nt", // class name
  bases_S79C2_nt, 5,
  &(vtc_S79C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1296,956), // object size
  NSPAIRA(_ZTI8S79C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S79C2_nt),224, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S79C1  : S79C2_nt {
  void *s79c1f0[2];
  unsigned int s79c1f1:1;
  ::S79C32_nt s79c1f2[2];
  ::S79C32_nt s79c1f3[2];
  int s79c1f4;
  ::S79C39_nt s79c1f5[2];
  ::S79C39_nt s79c1f6;
  virtual  ~S79C1(); // _ZN5S79C1D1Ev
  virtual void  v1(); // _ZN5S79C12v1Ev
  virtual void  v2(); // _ZN5S79C12v2Ev
  virtual void  v3(); // _ZN5S79C12v3Ev
  S79C1(); // tgen
};
//SIG(1 S79C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC10 Fp FC13{ BC14{ BC12}} FC13 FC13 FC15{ BC16{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC17{ m Fp FC8} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC18{ BC19{ m Fi[4]}} FC8 Fp[2] FC20{ m FC8 Fp FC18 Fp} FC21{ m Fp[8] Fc[4]} Fi FC22{ m Fp[5] FC23{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC8[4] FC24{ m FC25{ m Fi[3]} FC26{ m} FC27{ BC28{ m Fi[2] Fc[2]} Fi} Fc} FC25 Fi FC29{ m FC30{ BC31{ m Fp[2]}} Fc FC32{ BC33{ BC34{ BC12}}} Fi FC8 FC8 Fp} FC29 Fp FC25 FC15 FC35{ BC36{ BC12}} Fi:1 Fi:1 Fi:1 FC26 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17} vd v215 v216 v217 v218 v219 v220 Fi:1 Fp} vd v221 v222 v223 Fi:1 Fp Fi[5] FC17} vd v1 v2 v3 Fp[2] Fi:1 FC26[2] FC26[2] Fi FC32[2] FC32}


 S79C1 ::~S79C1(){ note_dtor("S79C1", this);}
void  S79C1 ::v1(){vfunc_called(this, "_ZN5S79C12v1Ev");}
void  S79C1 ::v2(){vfunc_called(this, "_ZN5S79C12v2Ev");}
void  S79C1 ::v3(){vfunc_called(this, "_ZN5S79C12v3Ev");}
S79C1 ::S79C1(){ note_ctor("S79C1", this);} // tgen

static void Test_S79C1()
{
  extern Class_Descriptor cd_S79C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(173,254)];
    init_test(&cd_S79C1, buf);
    S79C1 *dp, &lv = *(dp=new (buf) S79C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1376,1012), "sizeof(S79C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S79C1)");
    check_base_class_offset(lv, (S79C7_nt*)(S79C6_nt*)(S79C5_nt*)(S79C4_nt*)(S79C3_nt*)(S79C2_nt*), 0, "S79C1");
    check_base_class_offset(lv, (S79C6_nt*)(S79C5_nt*)(S79C4_nt*)(S79C3_nt*)(S79C2_nt*), 0, "S79C1");
    check_base_class_offset(lv, (S79C5_nt*)(S79C4_nt*)(S79C3_nt*)(S79C2_nt*), 0, "S79C1");
    check_base_class_offset(lv, (S79C4_nt*)(S79C3_nt*)(S79C2_nt*), 0, "S79C1");
    check_base_class_offset(lv, (S79C3_nt*)(S79C2_nt*), 0, "S79C1");
    check_base_class_offset(lv, (S79C2_nt*), 0, "S79C1");
    check_field_offset(lv, s79c1f0, ABISELECT(1296,956), "S79C1.s79c1f0");
    set_bf_and_test(lv, s79c1f1, ABISELECT(1312,964), 0, 1, 1, "S79C1");
    check_field_offset(lv, s79c1f2, ABISELECT(1313,965), "S79C1.s79c1f2");
    check_field_offset(lv, s79c1f3, ABISELECT(1315,967), "S79C1.s79c1f3");
    check_field_offset(lv, s79c1f4, ABISELECT(1320,972), "S79C1.s79c1f4");
    check_field_offset(lv, s79c1f5, ABISELECT(1328,976), "S79C1.s79c1f5");
    check_field_offset(lv, s79c1f6, ABISELECT(1360,1000), "S79C1.s79c1f6");
    test_class_info(&lv, &cd_S79C1);
    dp->~S79C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS79C1(Test_S79C1, "S79C1", ABISELECT(1376,1012));

#else // __cplusplus

extern void _ZN5S79C1C1Ev();
extern void _ZN5S79C1D1Ev();
Name_Map name_map_S79C1[] = {
  NSPAIR(_ZN5S79C1C1Ev),
  NSPAIR(_ZN5S79C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S79C7_nt;
extern VTBL_ENTRY _ZTI8S79C7_nt[];
extern  VTBL_ENTRY _ZTV8S79C7_nt[];
extern Class_Descriptor cd_S79C6_nt;
extern VTBL_ENTRY _ZTI8S79C6_nt[];
extern  VTBL_ENTRY _ZTV8S79C6_nt[];
extern Class_Descriptor cd_S79C5_nt;
extern VTBL_ENTRY _ZTI8S79C5_nt[];
extern  VTBL_ENTRY _ZTV8S79C5_nt[];
extern Class_Descriptor cd_S79C4_nt;
extern VTBL_ENTRY _ZTI8S79C4_nt[];
extern  VTBL_ENTRY _ZTV8S79C4_nt[];
extern Class_Descriptor cd_S79C3_nt;
extern VTBL_ENTRY _ZTI8S79C3_nt[];
extern  VTBL_ENTRY _ZTV8S79C3_nt[];
extern Class_Descriptor cd_S79C2_nt;
extern VTBL_ENTRY _ZTI8S79C2_nt[];
extern  VTBL_ENTRY _ZTV8S79C2_nt[];
static Base_Class bases_S79C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S79C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S79C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S79C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S79C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S79C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S79C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S79C1[];
extern void _ZN5S79C1D1Ev();
extern void _ZN5S79C1D0Ev();
extern void _ZN8S79C7_nt2v4Ev();
extern void _ZN8S79C7_nt2v5Ev();
extern void _ZN8S79C7_nt2v6Ev();
extern void _ZN8S79C7_nt2v7Ev();
extern void _ZN8S79C7_nt2v8Ev();
extern void _ZN8S79C7_nt2v9Ev();
extern void _ZN8S79C7_nt3v10Ev();
extern void _ZN8S79C7_nt3v11Ev();
extern void _ZN8S79C7_nt3v12Ev();
extern void _ZN8S79C7_nt3v13Ev();
extern void _ZN8S79C7_nt3v14Ev();
extern void _ZN8S79C7_nt3v15Ev();
extern void _ZN8S79C7_nt3v16Ev();
extern void _ZN8S79C7_nt3v17Ev();
extern void _ZN8S79C7_nt3v18Ev();
extern void _ZN8S79C7_nt3v19Ev();
extern void _ZN8S79C7_nt3v20Ev();
extern void _ZN8S79C7_nt3v21Ev();
extern void _ZN8S79C7_nt3v22Ev();
extern void _ZN8S79C7_nt3v23Ev();
extern void _ZN8S79C7_nt3v24Ev();
extern void _ZN8S79C7_nt3v25Ev();
extern void _ZN8S79C7_nt3v26Ev();
extern void _ZN8S79C7_nt3v27Ev();
extern void _ZN8S79C7_nt3v28Ev();
extern void _ZN8S79C7_nt3v29Ev();
extern void _ZN8S79C7_nt3v30Ev();
extern void _ZN8S79C7_nt3v31Ev();
extern void _ZN8S79C7_nt3v32Ev();
extern void _ZN8S79C7_nt3v33Ev();
extern void _ZN8S79C7_nt3v34Ev();
extern void _ZN8S79C7_nt3v35Ev();
extern void _ZN8S79C7_nt3v36Ev();
extern void _ZN8S79C7_nt3v37Ev();
extern void _ZN8S79C7_nt3v38Ev();
extern void _ZN8S79C7_nt3v39Ev();
extern void _ZN8S79C7_nt3v40Ev();
extern void _ZN8S79C7_nt3v41Ev();
extern void _ZN8S79C7_nt3v42Ev();
extern void _ZN8S79C7_nt3v43Ev();
extern void _ZN8S79C7_nt3v44Ev();
extern void _ZN8S79C7_nt3v45Ev();
extern void _ZN8S79C7_nt3v46Ev();
extern void _ZN8S79C7_nt3v47Ev();
extern void _ZN8S79C7_nt3v48Ev();
extern void _ZN8S79C7_nt3v49Ev();
extern void _ZN8S79C7_nt3v50Ev();
extern void _ZN8S79C7_nt3v51Ev();
extern void _ZN8S79C7_nt3v52Ev();
extern void _ZN8S79C7_nt3v53Ev();
extern void _ZN8S79C7_nt3v54Ev();
extern void _ZN8S79C7_nt3v55Ev();
extern void _ZN8S79C7_nt3v56Ev();
extern void _ZN8S79C7_nt3v57Ev();
extern void _ZN8S79C7_nt3v58Ev();
extern void _ZN8S79C7_nt3v59Ev();
extern void _ZN8S79C7_nt3v60Ev();
extern void _ZN8S79C7_nt3v61Ev();
extern void _ZN8S79C7_nt3v62Ev();
extern void _ZN8S79C7_nt3v63Ev();
extern void _ZN8S79C7_nt3v64Ev();
extern void _ZN8S79C7_nt3v65Ev();
extern void _ZN8S79C7_nt3v66Ev();
extern void _ZN8S79C7_nt3v67Ev();
extern void _ZN8S79C6_nt3v68Ev();
extern void _ZN8S79C6_nt3v69Ev();
extern void _ZN8S79C5_nt3v70Ev();
extern void _ZN8S79C5_nt3v71Ev();
extern void _ZN8S79C5_nt3v72Ev();
extern void _ZN8S79C5_nt3v73Ev();
extern void _ZN8S79C5_nt3v74Ev();
extern void _ZN8S79C5_nt3v75Ev();
extern void _ZN8S79C5_nt3v76Ev();
extern void _ZN8S79C5_nt3v77Ev();
extern void _ZN8S79C5_nt3v78Ev();
extern void _ZN8S79C5_nt3v79Ev();
extern void _ZN8S79C5_nt3v80Ev();
extern void _ZN8S79C5_nt3v81Ev();
extern void _ZN8S79C5_nt3v82Ev();
extern void _ZN8S79C5_nt3v83Ev();
extern void _ZN8S79C5_nt3v84Ev();
extern void _ZN8S79C5_nt3v85Ev();
extern void _ZN8S79C5_nt3v86Ev();
extern void _ZN8S79C5_nt3v87Ev();
extern void _ZN8S79C5_nt3v88Ev();
extern void _ZN8S79C5_nt3v89Ev();
extern void _ZN8S79C5_nt3v90Ev();
extern void _ZN8S79C5_nt3v91Ev();
extern void _ZN8S79C5_nt3v92Ev();
extern void _ZN8S79C5_nt3v93Ev();
extern void _ZN8S79C5_nt3v94Ev();
extern void _ZN8S79C5_nt3v95Ev();
extern void _ZN8S79C5_nt3v96Ev();
extern void _ZN8S79C5_nt3v97Ev();
extern void _ZN8S79C5_nt3v98Ev();
extern void _ZN8S79C5_nt3v99Ev();
extern void _ZN8S79C5_nt4v100Ev();
extern void _ZN8S79C5_nt4v101Ev();
extern void _ZN8S79C5_nt4v102Ev();
extern void _ZN8S79C5_nt4v103Ev();
extern void _ZN8S79C5_nt4v104Ev();
extern void _ZN8S79C5_nt4v105Ev();
extern void _ZN8S79C5_nt4v106Ev();
extern void _ZN8S79C5_nt4v107Ev();
extern void _ZN8S79C5_nt4v108Ev();
extern void _ZN8S79C5_nt4v109Ev();
extern void _ZN8S79C5_nt4v110Ev();
extern void _ZN8S79C5_nt4v111Ev();
extern void _ZN8S79C5_nt4v112Ev();
extern void _ZN8S79C5_nt4v113Ev();
extern void _ZN8S79C5_nt4v114Ev();
extern void _ZN8S79C5_nt4v115Ev();
extern void _ZN8S79C5_nt4v116Ev();
extern void _ZN8S79C5_nt4v117Ev();
extern void _ZN8S79C5_nt4v118Ev();
extern void _ZN8S79C5_nt4v119Ev();
extern void _ZN8S79C5_nt4v120Ev();
extern void _ZN8S79C5_nt4v121Ev();
extern void _ZN8S79C5_nt4v122Ev();
extern void _ZN8S79C5_nt4v123Ev();
extern void _ZN8S79C5_nt4v124Ev();
extern void _ZN8S79C5_nt4v125Ev();
extern void _ZN8S79C5_nt4v126Ev();
extern void _ZN8S79C5_nt4v127Ev();
extern void _ZN8S79C5_nt4v128Ev();
extern void _ZN8S79C5_nt4v129Ev();
extern void _ZN8S79C5_nt4v130Ev();
extern void _ZN8S79C5_nt4v131Ev();
extern void _ZN8S79C5_nt4v132Ev();
extern void _ZN8S79C5_nt4v133Ev();
extern void _ZN8S79C5_nt4v134Ev();
extern void _ZN8S79C5_nt4v135Ev();
extern void _ZN8S79C5_nt4v136Ev();
extern void _ZN8S79C5_nt4v137Ev();
extern void _ZN8S79C5_nt4v138Ev();
extern void _ZN8S79C5_nt4v139Ev();
extern void _ZN8S79C5_nt4v140Ev();
extern void _ZN8S79C5_nt4v141Ev();
extern void _ZN8S79C5_nt4v142Ev();
extern void _ZN8S79C5_nt4v143Ev();
extern void _ZN8S79C5_nt4v144Ev();
extern void _ZN8S79C5_nt4v145Ev();
extern void _ZN8S79C4_nt4v146Ev();
extern void _ZN8S79C4_nt4v147Ev();
extern void _ZN8S79C4_nt4v148Ev();
extern void _ZN8S79C4_nt4v149Ev();
extern void _ZN8S79C4_nt4v150Ev();
extern void _ZN8S79C4_nt4v151Ev();
extern void _ZN8S79C4_nt4v152Ev();
extern void _ZN8S79C4_nt4v153Ev();
extern void _ZN8S79C4_nt4v154Ev();
extern void _ZN8S79C4_nt4v155Ev();
extern void _ZN8S79C4_nt4v156Ev();
extern void _ZN8S79C4_nt4v157Ev();
extern void _ZN8S79C4_nt4v158Ev();
extern void _ZN8S79C4_nt4v159Ev();
extern void _ZN8S79C4_nt4v160Ev();
extern void _ZN8S79C4_nt4v161Ev();
extern void _ZN8S79C4_nt4v162Ev();
extern void _ZN8S79C4_nt4v163Ev();
extern void _ZN8S79C4_nt4v164Ev();
extern void _ZN8S79C4_nt4v165Ev();
extern void _ZN8S79C4_nt4v166Ev();
extern void _ZN8S79C4_nt4v167Ev();
extern void _ZN8S79C4_nt4v168Ev();
extern void _ZN8S79C4_nt4v169Ev();
extern void _ZN8S79C4_nt4v170Ev();
extern void _ZN8S79C4_nt4v171Ev();
extern void _ZN8S79C4_nt4v172Ev();
extern void _ZN8S79C4_nt4v173Ev();
extern void _ZN8S79C4_nt4v174Ev();
extern void _ZN8S79C4_nt4v175Ev();
extern void _ZN8S79C4_nt4v176Ev();
extern void _ZN8S79C4_nt4v177Ev();
extern void _ZN8S79C4_nt4v178Ev();
extern void _ZN8S79C4_nt4v179Ev();
extern void _ZN8S79C4_nt4v180Ev();
extern void _ZN8S79C4_nt4v181Ev();
extern void _ZN8S79C4_nt4v182Ev();
extern void _ZN8S79C4_nt4v183Ev();
extern void _ZN8S79C4_nt4v184Ev();
extern void _ZN8S79C4_nt4v185Ev();
extern void _ZN8S79C4_nt4v186Ev();
extern void _ZN8S79C4_nt4v187Ev();
extern void _ZN8S79C4_nt4v188Ev();
extern void _ZN8S79C4_nt4v189Ev();
extern void _ZN8S79C4_nt4v190Ev();
extern void _ZN8S79C4_nt4v191Ev();
extern void _ZN8S79C4_nt4v192Ev();
extern void _ZN8S79C4_nt4v193Ev();
extern void _ZN8S79C4_nt4v194Ev();
extern void _ZN8S79C4_nt4v195Ev();
extern void _ZN8S79C4_nt4v196Ev();
extern void _ZN8S79C4_nt4v197Ev();
extern void _ZN8S79C4_nt4v198Ev();
extern void _ZN8S79C4_nt4v199Ev();
extern void _ZN8S79C4_nt4v200Ev();
extern void _ZN8S79C4_nt4v201Ev();
extern void _ZN8S79C4_nt4v202Ev();
extern void _ZN8S79C4_nt4v203Ev();
extern void _ZN8S79C4_nt4v204Ev();
extern void _ZN8S79C4_nt4v205Ev();
extern void _ZN8S79C4_nt4v206Ev();
extern void _ZN8S79C4_nt4v207Ev();
extern void _ZN8S79C4_nt4v208Ev();
extern void _ZN8S79C4_nt4v209Ev();
extern void _ZN8S79C4_nt4v210Ev();
extern void _ZN8S79C4_nt4v211Ev();
extern void _ZN8S79C4_nt4v212Ev();
extern void _ZN8S79C4_nt4v213Ev();
extern void _ZN8S79C4_nt4v214Ev();
extern void _ZN8S79C3_nt4v215Ev();
extern void _ZN8S79C3_nt4v216Ev();
extern void _ZN8S79C3_nt4v217Ev();
extern void _ZN8S79C3_nt4v218Ev();
extern void _ZN8S79C3_nt4v219Ev();
extern void _ZN8S79C3_nt4v220Ev();
extern void _ZN8S79C2_nt4v221Ev();
extern void _ZN8S79C2_nt4v222Ev();
extern void _ZN8S79C2_nt4v223Ev();
extern void _ZN5S79C12v1Ev();
extern void _ZN5S79C12v2Ev();
extern void _ZN5S79C12v3Ev();
static  VTBL_ENTRY vtc_S79C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S79C1[0]),
  (VTBL_ENTRY)&_ZN5S79C1D1Ev,
  (VTBL_ENTRY)&_ZN5S79C1D0Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S79C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S79C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S79C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S79C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S79C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S79C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN5S79C12v1Ev,
  (VTBL_ENTRY)&_ZN5S79C12v2Ev,
  (VTBL_ENTRY)&_ZN5S79C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S79C1[];
extern  VTBL_ENTRY _ZTV5S79C1[];
Class_Descriptor cd_S79C1 = {  "S79C1", // class name
  bases_S79C1, 6,
  &(vtc_S79C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1376,1012), // object size
  NSPAIRA(_ZTI5S79C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S79C1),227, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C7_nt  {
  void  mf5266c7(); // _ZN10S5266C7_nt8mf5266c7Ev
};
//SIG(-1 S5266C7_nt) C1{ m}


void  S5266C7_nt ::mf5266c7(){}

//skip512 S5266C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C5_nt  {
  void *s5266c5f0;
  int s5266c5f1;
  ::S79C32_nt s5266c5f2;
  ::S5266C7_nt s5266c5f3;
  void  mf5266c5(); // _ZN10S5266C5_nt8mf5266c5Ev
};
//SIG(-1 S5266C5_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S5266C5_nt ::mf5266c5(){}

//skip512 S5266C5_nt

#else // __cplusplus

Class_Descriptor cd_S5266C5_nt = {  "S5266C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C4_nt  : S5266C5_nt {
};
//SIG(-1 S5266C4_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S5266C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S5266C5_nt;
static Base_Class bases_S5266C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5266C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C3_nt  {
  void *s5266c3f0;
  int s5266c3f1;
  ::S5266C4_nt s5266c3f2;
  ::S5266C4_nt s5266c3f3;
  int s5266c3f4;
  virtual  ~S5266C3_nt(); // _ZN10S5266C3_ntD1Ev
  virtual void  v5(); // _ZN10S5266C3_nt2v5Ev
  virtual void  v6(); // _ZN10S5266C3_nt2v6Ev
  virtual void  v7(); // _ZN10S5266C3_nt2v7Ev
  virtual void  v8(); // _ZN10S5266C3_nt2v8Ev
  virtual void  v9(); // _ZN10S5266C3_nt2v9Ev
  virtual void  v10(); // _ZN10S5266C3_nt3v10Ev
  virtual void  v11(); // _ZN10S5266C3_nt3v11Ev
  virtual void  v12(); // _ZN10S5266C3_nt3v12Ev
  virtual void  v13(); // _ZN10S5266C3_nt3v13Ev
  virtual void  v14(); // _ZN10S5266C3_nt3v14Ev
  virtual void  v15(); // _ZN10S5266C3_nt3v15Ev
  virtual void  v16(); // _ZN10S5266C3_nt3v16Ev
  virtual void  v17(); // _ZN10S5266C3_nt3v17Ev
  virtual void  v18(); // _ZN10S5266C3_nt3v18Ev
  virtual void  v19(); // _ZN10S5266C3_nt3v19Ev
  virtual void  v20(); // _ZN10S5266C3_nt3v20Ev
  virtual void  v21(); // _ZN10S5266C3_nt3v21Ev
  virtual void  v22(); // _ZN10S5266C3_nt3v22Ev
  virtual void  v23(); // _ZN10S5266C3_nt3v23Ev
  virtual void  v24(); // _ZN10S5266C3_nt3v24Ev
  virtual void  v25(); // _ZN10S5266C3_nt3v25Ev
  virtual void  v26(); // _ZN10S5266C3_nt3v26Ev
  virtual void  v27(); // _ZN10S5266C3_nt3v27Ev
  S5266C3_nt(); // tgen
};
//SIG(-1 S5266C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S5266C3_nt ::~S5266C3_nt(){ note_dtor("S5266C3_nt", this);}
void  S5266C3_nt ::v5(){vfunc_called(this, "_ZN10S5266C3_nt2v5Ev");}
void  S5266C3_nt ::v6(){vfunc_called(this, "_ZN10S5266C3_nt2v6Ev");}
void  S5266C3_nt ::v7(){vfunc_called(this, "_ZN10S5266C3_nt2v7Ev");}
void  S5266C3_nt ::v8(){vfunc_called(this, "_ZN10S5266C3_nt2v8Ev");}
void  S5266C3_nt ::v9(){vfunc_called(this, "_ZN10S5266C3_nt2v9Ev");}
void  S5266C3_nt ::v10(){vfunc_called(this, "_ZN10S5266C3_nt3v10Ev");}
void  S5266C3_nt ::v11(){vfunc_called(this, "_ZN10S5266C3_nt3v11Ev");}
void  S5266C3_nt ::v12(){vfunc_called(this, "_ZN10S5266C3_nt3v12Ev");}
void  S5266C3_nt ::v13(){vfunc_called(this, "_ZN10S5266C3_nt3v13Ev");}
void  S5266C3_nt ::v14(){vfunc_called(this, "_ZN10S5266C3_nt3v14Ev");}
void  S5266C3_nt ::v15(){vfunc_called(this, "_ZN10S5266C3_nt3v15Ev");}
void  S5266C3_nt ::v16(){vfunc_called(this, "_ZN10S5266C3_nt3v16Ev");}
void  S5266C3_nt ::v17(){vfunc_called(this, "_ZN10S5266C3_nt3v17Ev");}
void  S5266C3_nt ::v18(){vfunc_called(this, "_ZN10S5266C3_nt3v18Ev");}
void  S5266C3_nt ::v19(){vfunc_called(this, "_ZN10S5266C3_nt3v19Ev");}
void  S5266C3_nt ::v20(){vfunc_called(this, "_ZN10S5266C3_nt3v20Ev");}
void  S5266C3_nt ::v21(){vfunc_called(this, "_ZN10S5266C3_nt3v21Ev");}
void  S5266C3_nt ::v22(){vfunc_called(this, "_ZN10S5266C3_nt3v22Ev");}
void  S5266C3_nt ::v23(){vfunc_called(this, "_ZN10S5266C3_nt3v23Ev");}
void  S5266C3_nt ::v24(){vfunc_called(this, "_ZN10S5266C3_nt3v24Ev");}
void  S5266C3_nt ::v25(){vfunc_called(this, "_ZN10S5266C3_nt3v25Ev");}
void  S5266C3_nt ::v26(){vfunc_called(this, "_ZN10S5266C3_nt3v26Ev");}
void  S5266C3_nt ::v27(){vfunc_called(this, "_ZN10S5266C3_nt3v27Ev");}
S5266C3_nt ::S5266C3_nt(){ note_ctor("S5266C3_nt", this);} // tgen

//skip512 S5266C3_nt

#else // __cplusplus

extern void _ZN10S5266C3_ntC1Ev();
extern void _ZN10S5266C3_ntD1Ev();
Name_Map name_map_S5266C3_nt[] = {
  NSPAIR(_ZN10S5266C3_ntC1Ev),
  NSPAIR(_ZN10S5266C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S5266C3_nt[];
extern void _ZN10S5266C3_ntD1Ev();
extern void _ZN10S5266C3_ntD0Ev();
extern void _ZN10S5266C3_nt2v5Ev();
extern void _ZN10S5266C3_nt2v6Ev();
extern void _ZN10S5266C3_nt2v7Ev();
extern void _ZN10S5266C3_nt2v8Ev();
extern void _ZN10S5266C3_nt2v9Ev();
extern void _ZN10S5266C3_nt3v10Ev();
extern void _ZN10S5266C3_nt3v11Ev();
extern void _ZN10S5266C3_nt3v12Ev();
extern void _ZN10S5266C3_nt3v13Ev();
extern void _ZN10S5266C3_nt3v14Ev();
extern void _ZN10S5266C3_nt3v15Ev();
extern void _ZN10S5266C3_nt3v16Ev();
extern void _ZN10S5266C3_nt3v17Ev();
extern void _ZN10S5266C3_nt3v18Ev();
extern void _ZN10S5266C3_nt3v19Ev();
extern void _ZN10S5266C3_nt3v20Ev();
extern void _ZN10S5266C3_nt3v21Ev();
extern void _ZN10S5266C3_nt3v22Ev();
extern void _ZN10S5266C3_nt3v23Ev();
extern void _ZN10S5266C3_nt3v24Ev();
extern void _ZN10S5266C3_nt3v25Ev();
extern void _ZN10S5266C3_nt3v26Ev();
extern void _ZN10S5266C3_nt3v27Ev();
static  VTBL_ENTRY vtc_S5266C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5266C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S5266C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v27Ev,
};
extern VTBL_ENTRY _ZTI10S5266C3_nt[];
VTBL_ENTRY *P__ZTI10S5266C3_nt = _ZTI10S5266C3_nt; 
extern  VTBL_ENTRY _ZTV10S5266C3_nt[];
Class_Descriptor cd_S5266C3_nt = {  "S5266C3_nt", // class name
  0,0,//no base classes
  &(vtc_S5266C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S5266C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S5266C3_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C13_nt  {
  __tsi64 s5266c13f0[2];
  void  mf5266c13(); // _ZN11S5266C13_nt9mf5266c13Ev
};
//SIG(-1 S5266C13_nt) C1{ m FL[2]}


void  S5266C13_nt ::mf5266c13(){}

//skip512 S5266C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C12_nt  {
  ::S5266C13_nt s5266c12f0;
  void  mf5266c12(); // _ZN11S5266C12_nt9mf5266c12Ev
};
//SIG(-1 S5266C12_nt) C1{ m FC2{ m FL[2]}}


void  S5266C12_nt ::mf5266c12(){}

//skip512 S5266C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C16_nt  {
  ::S5266C12_nt s5266c16f0;
  void  mf5266c16(); // _ZN11S5266C16_nt9mf5266c16Ev
};
//SIG(-1 S5266C16_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S5266C16_nt ::mf5266c16(){}

//skip512 S5266C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C17_nt  {
  ::S5266C12_nt s5266c17f0;
  ::S5266C12_nt s5266c17f1;
  ::S5266C12_nt s5266c17f2;
  ::S5266C12_nt s5266c17f3;
  void  mf5266c17(); // _ZN11S5266C17_nt9mf5266c17Ev
};
//SIG(-1 S5266C17_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S5266C17_nt ::mf5266c17(){}

//skip512 S5266C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C19_nt  {
  void *s5266c19f0;
  int s5266c19f1;
  ::S5266C7_nt s5266c19f2;
  void  mf5266c19(); // _ZN11S5266C19_nt9mf5266c19Ev
};
//SIG(-1 S5266C19_nt) C1{ m Fp Fi FC2{ m}}


void  S5266C19_nt ::mf5266c19(){}

//skip512 S5266C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C18_nt  {
  ::S5266C19_nt s5266c18f0;
  int s5266c18f1;
  void  mf5266c18(); // _ZN11S5266C18_nt9mf5266c18Ev
};
//SIG(-1 S5266C18_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S5266C18_nt ::mf5266c18(){}

//skip512 S5266C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C22  {
  void  mf5266c22(); // _ZN8S5266C229mf5266c22Ev
};
//SIG(-1 S5266C22) C1{ m}


void  S5266C22 ::mf5266c22(){}

static void Test_S5266C22()
{
  {
    init_simple_test("S5266C22");
    S5266C22 lv;
    check2(sizeof(lv), 1, "sizeof(S5266C22)");
    check2(__alignof__(lv), 1, "__alignof__(S5266C22)");
  }
}
static Arrange_To_Call_Me vS5266C22(Test_S5266C22, "S5266C22", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5266C22[];
VTBL_ENTRY *P__ZTI8S5266C22 = _ZTI8S5266C22; 
Class_Descriptor cd_S5266C22 = {  "S5266C22", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5266C22),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C21  {
  void *s5266c21f0;
  int s5266c21f1;
  ::S5266C22 s5266c21f2;
  ::S5266C22 s5266c21f3;
  void  mf5266c21(); // _ZN8S5266C219mf5266c21Ev
};
//SIG(-1 S5266C21) C1{ m Fp Fi FC2{ m} FC2}


void  S5266C21 ::mf5266c21(){}

static void Test_S5266C21()
{
  {
    init_simple_test("S5266C21");
    S5266C21 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5266C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5266C21)");
    check_field_offset(lv, s5266c21f0, 0, "S5266C21.s5266c21f0");
    check_field_offset(lv, s5266c21f1, ABISELECT(8,4), "S5266C21.s5266c21f1");
    check_field_offset(lv, s5266c21f2, ABISELECT(12,8), "S5266C21.s5266c21f2");
    check_field_offset(lv, s5266c21f3, ABISELECT(13,9), "S5266C21.s5266c21f3");
  }
}
static Arrange_To_Call_Me vS5266C21(Test_S5266C21, "S5266C21", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C26  {
  void  mf5266c26(); // _ZN8S5266C269mf5266c26Ev
};
//SIG(-1 S5266C26) C1{ m}


void  S5266C26 ::mf5266c26(){}

static void Test_S5266C26()
{
  {
    init_simple_test("S5266C26");
    S5266C26 lv;
    check2(sizeof(lv), 1, "sizeof(S5266C26)");
    check2(__alignof__(lv), 1, "__alignof__(S5266C26)");
  }
}
static Arrange_To_Call_Me vS5266C26(Test_S5266C26, "S5266C26", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5266C26[];
VTBL_ENTRY *P__ZTI8S5266C26 = _ZTI8S5266C26; 
Class_Descriptor cd_S5266C26 = {  "S5266C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5266C26),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C25  {
  void *s5266c25f0;
  int s5266c25f1;
  ::S5266C26 s5266c25f2;
  ::S5266C26 s5266c25f3;
  void  mf5266c25(); // _ZN8S5266C259mf5266c25Ev
};
//SIG(-1 S5266C25) C1{ m Fp Fi FC2{ m} FC2}


void  S5266C25 ::mf5266c25(){}

static void Test_S5266C25()
{
  {
    init_simple_test("S5266C25");
    S5266C25 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5266C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5266C25)");
    check_field_offset(lv, s5266c25f0, 0, "S5266C25.s5266c25f0");
    check_field_offset(lv, s5266c25f1, ABISELECT(8,4), "S5266C25.s5266c25f1");
    check_field_offset(lv, s5266c25f2, ABISELECT(12,8), "S5266C25.s5266c25f2");
    check_field_offset(lv, s5266c25f3, ABISELECT(13,9), "S5266C25.s5266c25f3");
  }
}
static Arrange_To_Call_Me vS5266C25(Test_S5266C25, "S5266C25", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S5266C25 = {  "S5266C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C24  : S5266C25 {
};
//SIG(-1 S5266C24) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S5266C24()
{
  extern Class_Descriptor cd_S5266C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S5266C24, buf);
    S5266C24 &lv = *(new (buf) S5266C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5266C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5266C24)");
    check_base_class_offset(lv, (S5266C25*), 0, "S5266C24");
    test_class_info(&lv, &cd_S5266C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5266C24(Test_S5266C24, "S5266C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S5266C25;
static Base_Class bases_S5266C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5266C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5266C24 = {  "S5266C24", // class name
  bases_S5266C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C29  {
  void  mf5266c29(); // _ZN8S5266C299mf5266c29Ev
};
//SIG(-1 S5266C29) C1{ m}


void  S5266C29 ::mf5266c29(){}

static void Test_S5266C29()
{
  {
    init_simple_test("S5266C29");
    S5266C29 lv;
    check2(sizeof(lv), 1, "sizeof(S5266C29)");
    check2(__alignof__(lv), 1, "__alignof__(S5266C29)");
  }
}
static Arrange_To_Call_Me vS5266C29(Test_S5266C29, "S5266C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5266C29[];
VTBL_ENTRY *P__ZTI8S5266C29 = _ZTI8S5266C29; 
Class_Descriptor cd_S5266C29 = {  "S5266C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5266C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C28_nt  {
  void *s5266c28f0;
  int s5266c28f1[2];
  ::S5266C29 s5266c28f2;
  void  mf5266c28(); // _ZN11S5266C28_nt9mf5266c28Ev
};
//SIG(-1 S5266C28_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S5266C28_nt ::mf5266c28(){}

//skip512 S5266C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C36  {
  void *s5266c36f0;
  int s5266c36f1[2];
  ::S5266C29 s5266c36f2;
  void  mf5266c36(); // _ZN8S5266C369mf5266c36Ev
};
//SIG(-1 S5266C36) C1{ m Fp Fi[2] FC2{ m}}


void  S5266C36 ::mf5266c36(){}

static void Test_S5266C36()
{
  {
    init_simple_test("S5266C36");
    S5266C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S5266C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5266C36)");
    check_field_offset(lv, s5266c36f0, 0, "S5266C36.s5266c36f0");
    check_field_offset(lv, s5266c36f1, ABISELECT(8,4), "S5266C36.s5266c36f1");
    check_field_offset(lv, s5266c36f2, ABISELECT(16,12), "S5266C36.s5266c36f2");
  }
}
static Arrange_To_Call_Me vS5266C36(Test_S5266C36, "S5266C36", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5266C36[];
VTBL_ENTRY *P__ZTI8S5266C36 = _ZTI8S5266C36; 
Class_Descriptor cd_S5266C36 = {  "S5266C36", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S5266C36),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C2_nt  : S5266C3_nt {
  ::S5266C12_nt s5266c2f0;
  ::S5266C12_nt s5266c2f1;
  ::S5266C12_nt s5266c2f2;
  ::S5266C12_nt s5266c2f3;
  ::S5266C16_nt s5266c2f4;
  ::S5266C17_nt s5266c2f5;
  ::S5266C17_nt s5266c2f6;
  ::S5266C12_nt s5266c2f7;
  ::S5266C12_nt s5266c2f8;
  ::S5266C12_nt s5266c2f9;
  void *s5266c2f10;
  ::S5266C16_nt s5266c2f11;
  ::S5266C18_nt s5266c2f12;
  int s5266c2f13;
  void *s5266c2f14[7];
  ::S5266C21 s5266c2f15;
  int s5266c2f16:8;
  int s5266c2f17:8;
  int s5266c2f18:16;
  int s5266c2f19:16;
  int s5266c2f20:8;
  int s5266c2f21:8;
  int s5266c2f22:8;
  int s5266c2f23:32;
  int s5266c2f24:8;
  int s5266c2f25:4;
  int s5266c2f26:4;
  int s5266c2f27:4;
  int s5266c2f28:4;
  int s5266c2f29:4;
  int s5266c2f30:4;
  int s5266c2f31:4;
  int s5266c2f32:4;
  int s5266c2f33:4;
  int s5266c2f34:4;
  unsigned char s5266c2f35:1;
  unsigned char s5266c2f36:1;
  unsigned char s5266c2f37:1;
  unsigned char s5266c2f38:1;
  unsigned char s5266c2f39:1;
  unsigned char s5266c2f40:1;
  unsigned char s5266c2f41:1;
  unsigned char s5266c2f42:1;
  unsigned char s5266c2f43:1;
  unsigned char s5266c2f44:1;
  unsigned char s5266c2f45:1;
  unsigned char s5266c2f46:1;
  unsigned char s5266c2f47:1;
  unsigned char s5266c2f48:1;
  unsigned char s5266c2f49:1;
  unsigned char s5266c2f50:1;
  unsigned char s5266c2f51:1;
  unsigned char s5266c2f52:1;
  unsigned char s5266c2f53:1;
  unsigned char s5266c2f54:1;
  unsigned char s5266c2f55:1;
  unsigned char s5266c2f56:1;
  unsigned char s5266c2f57:1;
  unsigned char s5266c2f58:1;
  unsigned char s5266c2f59:1;
  unsigned char s5266c2f60:1;
  unsigned char s5266c2f61:1;
  unsigned char s5266c2f62:1;
  unsigned char s5266c2f63:1;
  unsigned char s5266c2f64:1;
  unsigned char s5266c2f65:1;
  unsigned char s5266c2f66:1;
  unsigned char s5266c2f67:1;
  unsigned char s5266c2f68:1;
  unsigned char s5266c2f69:1;
  unsigned char s5266c2f70:1;
  unsigned char s5266c2f71:1;
  unsigned char s5266c2f72:1;
  unsigned char s5266c2f73:1;
  unsigned char s5266c2f74:1;
  unsigned char s5266c2f75:1;
  int s5266c2f76[7];
  void *s5266c2f77[6];
  int s5266c2f78:8;
  int s5266c2f79:8;
  int s5266c2f80:8;
  int s5266c2f81:8;
  int s5266c2f82:8;
  int s5266c2f83:8;
  ::S5266C24 s5266c2f84;
  void *s5266c2f85[4];
  int s5266c2f86:8;
  int s5266c2f87:8;
  int s5266c2f88:8;
  int s5266c2f89:8;
  int s5266c2f90:8;
  int s5266c2f91:16;
  int s5266c2f92:16;
  int s5266c2f93:16;
  int s5266c2f94:4;
  int s5266c2f95:4;
  int s5266c2f96:4;
  int s5266c2f97:4;
  int s5266c2f98:4;
  int s5266c2f99:4;
  int s5266c2f100:4;
  int s5266c2f101:4;
  int s5266c2f102:4;
  int s5266c2f103:4;
  int s5266c2f104:4;
  int s5266c2f105:4;
  int s5266c2f106:8;
  int s5266c2f107:8;
  int s5266c2f108:8;
  void *s5266c2f109[7];
  ::S5266C28_nt s5266c2f110;
  void *s5266c2f111[2];
  int s5266c2f112:16;
  int s5266c2f113:16;
  ::S5266C24 s5266c2f114;
  ::S5266C28_nt s5266c2f115;
  ::S5266C36 s5266c2f116;
  void *s5266c2f117[2];
  int s5266c2f118:24;
  int s5266c2f119:8;
  void *s5266c2f120;
  virtual  ~S5266C2_nt(); // _ZN10S5266C2_ntD1Ev
  virtual void  v28(); // _ZN10S5266C2_nt3v28Ev
  virtual void  v29(); // _ZN10S5266C2_nt3v29Ev
  virtual void  v30(); // _ZN10S5266C2_nt3v30Ev
  virtual void  v31(); // _ZN10S5266C2_nt3v31Ev
  virtual void  v32(); // _ZN10S5266C2_nt3v32Ev
  virtual void  v33(); // _ZN10S5266C2_nt3v33Ev
  virtual void  v34(); // _ZN10S5266C2_nt3v34Ev
  virtual void  v35(); // _ZN10S5266C2_nt3v35Ev
  virtual void  v36(); // _ZN10S5266C2_nt3v36Ev
  virtual void  v37(); // _ZN10S5266C2_nt3v37Ev
  virtual void  v38(); // _ZN10S5266C2_nt3v38Ev
  virtual void  v39(); // _ZN10S5266C2_nt3v39Ev
  virtual void  v40(); // _ZN10S5266C2_nt3v40Ev
  virtual void  v41(); // _ZN10S5266C2_nt3v41Ev
  virtual void  v42(); // _ZN10S5266C2_nt3v42Ev
  virtual void  v43(); // _ZN10S5266C2_nt3v43Ev
  virtual void  v44(); // _ZN10S5266C2_nt3v44Ev
  virtual void  v45(); // _ZN10S5266C2_nt3v45Ev
  virtual void  v46(); // _ZN10S5266C2_nt3v46Ev
  virtual void  v47(); // _ZN10S5266C2_nt3v47Ev
  virtual void  v48(); // _ZN10S5266C2_nt3v48Ev
  virtual void  v49(); // _ZN10S5266C2_nt3v49Ev
  virtual void  v50(); // _ZN10S5266C2_nt3v50Ev
  virtual void  v51(); // _ZN10S5266C2_nt3v51Ev
  virtual void  v52(); // _ZN10S5266C2_nt3v52Ev
  virtual void  v53(); // _ZN10S5266C2_nt3v53Ev
  virtual void  v54(); // _ZN10S5266C2_nt3v54Ev
  virtual void  v55(); // _ZN10S5266C2_nt3v55Ev
  virtual void  v56(); // _ZN10S5266C2_nt3v56Ev
  virtual void  v57(); // _ZN10S5266C2_nt3v57Ev
  virtual void  v58(); // _ZN10S5266C2_nt3v58Ev
  virtual void  v59(); // _ZN10S5266C2_nt3v59Ev
  virtual void  v60(); // _ZN10S5266C2_nt3v60Ev
  virtual void  v61(); // _ZN10S5266C2_nt3v61Ev
  virtual void  v62(); // _ZN10S5266C2_nt3v62Ev
  virtual void  v63(); // _ZN10S5266C2_nt3v63Ev
  virtual void  v64(); // _ZN10S5266C2_nt3v64Ev
  virtual void  v65(); // _ZN10S5266C2_nt3v65Ev
  virtual void  v66(); // _ZN10S5266C2_nt3v66Ev
  virtual void  v67(); // _ZN10S5266C2_nt3v67Ev
  virtual void  v68(); // _ZN10S5266C2_nt3v68Ev
  virtual void  v69(); // _ZN10S5266C2_nt3v69Ev
  virtual void  v70(); // _ZN10S5266C2_nt3v70Ev
  virtual void  v71(); // _ZN10S5266C2_nt3v71Ev
  virtual void  v72(); // _ZN10S5266C2_nt3v72Ev
  virtual void  v73(); // _ZN10S5266C2_nt3v73Ev
  virtual void  v74(); // _ZN10S5266C2_nt3v74Ev
  virtual void  v75(); // _ZN10S5266C2_nt3v75Ev
  virtual void  v76(); // _ZN10S5266C2_nt3v76Ev
  virtual void  v77(); // _ZN10S5266C2_nt3v77Ev
  virtual void  v78(); // _ZN10S5266C2_nt3v78Ev
  virtual void  v79(); // _ZN10S5266C2_nt3v79Ev
  virtual void  v80(); // _ZN10S5266C2_nt3v80Ev
  virtual void  v81(); // _ZN10S5266C2_nt3v81Ev
  virtual void  v82(); // _ZN10S5266C2_nt3v82Ev
  virtual void  v83(); // _ZN10S5266C2_nt3v83Ev
  virtual void  v84(); // _ZN10S5266C2_nt3v84Ev
  virtual void  v85(); // _ZN10S5266C2_nt3v85Ev
  virtual void  v86(); // _ZN10S5266C2_nt3v86Ev
  virtual void  v87(); // _ZN10S5266C2_nt3v87Ev
  virtual void  v88(); // _ZN10S5266C2_nt3v88Ev
  virtual void  v89(); // _ZN10S5266C2_nt3v89Ev
  virtual void  v90(); // _ZN10S5266C2_nt3v90Ev
  virtual void  v91(); // _ZN10S5266C2_nt3v91Ev
  virtual void  v92(); // _ZN10S5266C2_nt3v92Ev
  virtual void  v93(); // _ZN10S5266C2_nt3v93Ev
  virtual void  v94(); // _ZN10S5266C2_nt3v94Ev
  virtual void  v95(); // _ZN10S5266C2_nt3v95Ev
  virtual void  v96(); // _ZN10S5266C2_nt3v96Ev
  virtual void  v97(); // _ZN10S5266C2_nt3v97Ev
  virtual void  v98(); // _ZN10S5266C2_nt3v98Ev
  virtual void  v99(); // _ZN10S5266C2_nt3v99Ev
  virtual void  v100(); // _ZN10S5266C2_nt4v100Ev
  virtual void  v101(); // _ZN10S5266C2_nt4v101Ev
  virtual void  v102(); // _ZN10S5266C2_nt4v102Ev
  virtual void  v103(); // _ZN10S5266C2_nt4v103Ev
  virtual void  v104(); // _ZN10S5266C2_nt4v104Ev
  virtual void  v105(); // _ZN10S5266C2_nt4v105Ev
  S5266C2_nt(); // tgen
};
//SIG(-1 S5266C2_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S5266C2_nt ::~S5266C2_nt(){ note_dtor("S5266C2_nt", this);}
void  S5266C2_nt ::v28(){vfunc_called(this, "_ZN10S5266C2_nt3v28Ev");}
void  S5266C2_nt ::v29(){vfunc_called(this, "_ZN10S5266C2_nt3v29Ev");}
void  S5266C2_nt ::v30(){vfunc_called(this, "_ZN10S5266C2_nt3v30Ev");}
void  S5266C2_nt ::v31(){vfunc_called(this, "_ZN10S5266C2_nt3v31Ev");}
void  S5266C2_nt ::v32(){vfunc_called(this, "_ZN10S5266C2_nt3v32Ev");}
void  S5266C2_nt ::v33(){vfunc_called(this, "_ZN10S5266C2_nt3v33Ev");}
void  S5266C2_nt ::v34(){vfunc_called(this, "_ZN10S5266C2_nt3v34Ev");}
void  S5266C2_nt ::v35(){vfunc_called(this, "_ZN10S5266C2_nt3v35Ev");}
void  S5266C2_nt ::v36(){vfunc_called(this, "_ZN10S5266C2_nt3v36Ev");}
void  S5266C2_nt ::v37(){vfunc_called(this, "_ZN10S5266C2_nt3v37Ev");}
void  S5266C2_nt ::v38(){vfunc_called(this, "_ZN10S5266C2_nt3v38Ev");}
void  S5266C2_nt ::v39(){vfunc_called(this, "_ZN10S5266C2_nt3v39Ev");}
void  S5266C2_nt ::v40(){vfunc_called(this, "_ZN10S5266C2_nt3v40Ev");}
void  S5266C2_nt ::v41(){vfunc_called(this, "_ZN10S5266C2_nt3v41Ev");}
void  S5266C2_nt ::v42(){vfunc_called(this, "_ZN10S5266C2_nt3v42Ev");}
void  S5266C2_nt ::v43(){vfunc_called(this, "_ZN10S5266C2_nt3v43Ev");}
void  S5266C2_nt ::v44(){vfunc_called(this, "_ZN10S5266C2_nt3v44Ev");}
void  S5266C2_nt ::v45(){vfunc_called(this, "_ZN10S5266C2_nt3v45Ev");}
void  S5266C2_nt ::v46(){vfunc_called(this, "_ZN10S5266C2_nt3v46Ev");}
void  S5266C2_nt ::v47(){vfunc_called(this, "_ZN10S5266C2_nt3v47Ev");}
void  S5266C2_nt ::v48(){vfunc_called(this, "_ZN10S5266C2_nt3v48Ev");}
void  S5266C2_nt ::v49(){vfunc_called(this, "_ZN10S5266C2_nt3v49Ev");}
void  S5266C2_nt ::v50(){vfunc_called(this, "_ZN10S5266C2_nt3v50Ev");}
void  S5266C2_nt ::v51(){vfunc_called(this, "_ZN10S5266C2_nt3v51Ev");}
void  S5266C2_nt ::v52(){vfunc_called(this, "_ZN10S5266C2_nt3v52Ev");}
void  S5266C2_nt ::v53(){vfunc_called(this, "_ZN10S5266C2_nt3v53Ev");}
void  S5266C2_nt ::v54(){vfunc_called(this, "_ZN10S5266C2_nt3v54Ev");}
void  S5266C2_nt ::v55(){vfunc_called(this, "_ZN10S5266C2_nt3v55Ev");}
void  S5266C2_nt ::v56(){vfunc_called(this, "_ZN10S5266C2_nt3v56Ev");}
void  S5266C2_nt ::v57(){vfunc_called(this, "_ZN10S5266C2_nt3v57Ev");}
void  S5266C2_nt ::v58(){vfunc_called(this, "_ZN10S5266C2_nt3v58Ev");}
void  S5266C2_nt ::v59(){vfunc_called(this, "_ZN10S5266C2_nt3v59Ev");}
void  S5266C2_nt ::v60(){vfunc_called(this, "_ZN10S5266C2_nt3v60Ev");}
void  S5266C2_nt ::v61(){vfunc_called(this, "_ZN10S5266C2_nt3v61Ev");}
void  S5266C2_nt ::v62(){vfunc_called(this, "_ZN10S5266C2_nt3v62Ev");}
void  S5266C2_nt ::v63(){vfunc_called(this, "_ZN10S5266C2_nt3v63Ev");}
void  S5266C2_nt ::v64(){vfunc_called(this, "_ZN10S5266C2_nt3v64Ev");}
void  S5266C2_nt ::v65(){vfunc_called(this, "_ZN10S5266C2_nt3v65Ev");}
void  S5266C2_nt ::v66(){vfunc_called(this, "_ZN10S5266C2_nt3v66Ev");}
void  S5266C2_nt ::v67(){vfunc_called(this, "_ZN10S5266C2_nt3v67Ev");}
void  S5266C2_nt ::v68(){vfunc_called(this, "_ZN10S5266C2_nt3v68Ev");}
void  S5266C2_nt ::v69(){vfunc_called(this, "_ZN10S5266C2_nt3v69Ev");}
void  S5266C2_nt ::v70(){vfunc_called(this, "_ZN10S5266C2_nt3v70Ev");}
void  S5266C2_nt ::v71(){vfunc_called(this, "_ZN10S5266C2_nt3v71Ev");}
void  S5266C2_nt ::v72(){vfunc_called(this, "_ZN10S5266C2_nt3v72Ev");}
void  S5266C2_nt ::v73(){vfunc_called(this, "_ZN10S5266C2_nt3v73Ev");}
void  S5266C2_nt ::v74(){vfunc_called(this, "_ZN10S5266C2_nt3v74Ev");}
void  S5266C2_nt ::v75(){vfunc_called(this, "_ZN10S5266C2_nt3v75Ev");}
void  S5266C2_nt ::v76(){vfunc_called(this, "_ZN10S5266C2_nt3v76Ev");}
void  S5266C2_nt ::v77(){vfunc_called(this, "_ZN10S5266C2_nt3v77Ev");}
void  S5266C2_nt ::v78(){vfunc_called(this, "_ZN10S5266C2_nt3v78Ev");}
void  S5266C2_nt ::v79(){vfunc_called(this, "_ZN10S5266C2_nt3v79Ev");}
void  S5266C2_nt ::v80(){vfunc_called(this, "_ZN10S5266C2_nt3v80Ev");}
void  S5266C2_nt ::v81(){vfunc_called(this, "_ZN10S5266C2_nt3v81Ev");}
void  S5266C2_nt ::v82(){vfunc_called(this, "_ZN10S5266C2_nt3v82Ev");}
void  S5266C2_nt ::v83(){vfunc_called(this, "_ZN10S5266C2_nt3v83Ev");}
void  S5266C2_nt ::v84(){vfunc_called(this, "_ZN10S5266C2_nt3v84Ev");}
void  S5266C2_nt ::v85(){vfunc_called(this, "_ZN10S5266C2_nt3v85Ev");}
void  S5266C2_nt ::v86(){vfunc_called(this, "_ZN10S5266C2_nt3v86Ev");}
void  S5266C2_nt ::v87(){vfunc_called(this, "_ZN10S5266C2_nt3v87Ev");}
void  S5266C2_nt ::v88(){vfunc_called(this, "_ZN10S5266C2_nt3v88Ev");}
void  S5266C2_nt ::v89(){vfunc_called(this, "_ZN10S5266C2_nt3v89Ev");}
void  S5266C2_nt ::v90(){vfunc_called(this, "_ZN10S5266C2_nt3v90Ev");}
void  S5266C2_nt ::v91(){vfunc_called(this, "_ZN10S5266C2_nt3v91Ev");}
void  S5266C2_nt ::v92(){vfunc_called(this, "_ZN10S5266C2_nt3v92Ev");}
void  S5266C2_nt ::v93(){vfunc_called(this, "_ZN10S5266C2_nt3v93Ev");}
void  S5266C2_nt ::v94(){vfunc_called(this, "_ZN10S5266C2_nt3v94Ev");}
void  S5266C2_nt ::v95(){vfunc_called(this, "_ZN10S5266C2_nt3v95Ev");}
void  S5266C2_nt ::v96(){vfunc_called(this, "_ZN10S5266C2_nt3v96Ev");}
void  S5266C2_nt ::v97(){vfunc_called(this, "_ZN10S5266C2_nt3v97Ev");}
void  S5266C2_nt ::v98(){vfunc_called(this, "_ZN10S5266C2_nt3v98Ev");}
void  S5266C2_nt ::v99(){vfunc_called(this, "_ZN10S5266C2_nt3v99Ev");}
void  S5266C2_nt ::v100(){vfunc_called(this, "_ZN10S5266C2_nt4v100Ev");}
void  S5266C2_nt ::v101(){vfunc_called(this, "_ZN10S5266C2_nt4v101Ev");}
void  S5266C2_nt ::v102(){vfunc_called(this, "_ZN10S5266C2_nt4v102Ev");}
void  S5266C2_nt ::v103(){vfunc_called(this, "_ZN10S5266C2_nt4v103Ev");}
void  S5266C2_nt ::v104(){vfunc_called(this, "_ZN10S5266C2_nt4v104Ev");}
void  S5266C2_nt ::v105(){vfunc_called(this, "_ZN10S5266C2_nt4v105Ev");}
S5266C2_nt ::S5266C2_nt(){ note_ctor("S5266C2_nt", this);} // tgen

//skip512 S5266C2_nt

#else // __cplusplus

extern void _ZN10S5266C2_ntC1Ev();
extern void _ZN10S5266C2_ntD1Ev();
Name_Map name_map_S5266C2_nt[] = {
  NSPAIR(_ZN10S5266C2_ntC1Ev),
  NSPAIR(_ZN10S5266C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5266C3_nt;
extern VTBL_ENTRY _ZTI10S5266C3_nt[];
extern  VTBL_ENTRY _ZTV10S5266C3_nt[];
static Base_Class bases_S5266C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5266C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S5266C2_nt[];
extern void _ZN10S5266C2_ntD1Ev();
extern void _ZN10S5266C2_ntD0Ev();
extern void _ZN10S5266C3_nt2v5Ev();
extern void _ZN10S5266C3_nt2v6Ev();
extern void _ZN10S5266C3_nt2v7Ev();
extern void _ZN10S5266C3_nt2v8Ev();
extern void _ZN10S5266C3_nt2v9Ev();
extern void _ZN10S5266C3_nt3v10Ev();
extern void _ZN10S5266C3_nt3v11Ev();
extern void _ZN10S5266C3_nt3v12Ev();
extern void _ZN10S5266C3_nt3v13Ev();
extern void _ZN10S5266C3_nt3v14Ev();
extern void _ZN10S5266C3_nt3v15Ev();
extern void _ZN10S5266C3_nt3v16Ev();
extern void _ZN10S5266C3_nt3v17Ev();
extern void _ZN10S5266C3_nt3v18Ev();
extern void _ZN10S5266C3_nt3v19Ev();
extern void _ZN10S5266C3_nt3v20Ev();
extern void _ZN10S5266C3_nt3v21Ev();
extern void _ZN10S5266C3_nt3v22Ev();
extern void _ZN10S5266C3_nt3v23Ev();
extern void _ZN10S5266C3_nt3v24Ev();
extern void _ZN10S5266C3_nt3v25Ev();
extern void _ZN10S5266C3_nt3v26Ev();
extern void _ZN10S5266C3_nt3v27Ev();
extern void _ZN10S5266C2_nt3v28Ev();
extern void _ZN10S5266C2_nt3v29Ev();
extern void _ZN10S5266C2_nt3v30Ev();
extern void _ZN10S5266C2_nt3v31Ev();
extern void _ZN10S5266C2_nt3v32Ev();
extern void _ZN10S5266C2_nt3v33Ev();
extern void _ZN10S5266C2_nt3v34Ev();
extern void _ZN10S5266C2_nt3v35Ev();
extern void _ZN10S5266C2_nt3v36Ev();
extern void _ZN10S5266C2_nt3v37Ev();
extern void _ZN10S5266C2_nt3v38Ev();
extern void _ZN10S5266C2_nt3v39Ev();
extern void _ZN10S5266C2_nt3v40Ev();
extern void _ZN10S5266C2_nt3v41Ev();
extern void _ZN10S5266C2_nt3v42Ev();
extern void _ZN10S5266C2_nt3v43Ev();
extern void _ZN10S5266C2_nt3v44Ev();
extern void _ZN10S5266C2_nt3v45Ev();
extern void _ZN10S5266C2_nt3v46Ev();
extern void _ZN10S5266C2_nt3v47Ev();
extern void _ZN10S5266C2_nt3v48Ev();
extern void _ZN10S5266C2_nt3v49Ev();
extern void _ZN10S5266C2_nt3v50Ev();
extern void _ZN10S5266C2_nt3v51Ev();
extern void _ZN10S5266C2_nt3v52Ev();
extern void _ZN10S5266C2_nt3v53Ev();
extern void _ZN10S5266C2_nt3v54Ev();
extern void _ZN10S5266C2_nt3v55Ev();
extern void _ZN10S5266C2_nt3v56Ev();
extern void _ZN10S5266C2_nt3v57Ev();
extern void _ZN10S5266C2_nt3v58Ev();
extern void _ZN10S5266C2_nt3v59Ev();
extern void _ZN10S5266C2_nt3v60Ev();
extern void _ZN10S5266C2_nt3v61Ev();
extern void _ZN10S5266C2_nt3v62Ev();
extern void _ZN10S5266C2_nt3v63Ev();
extern void _ZN10S5266C2_nt3v64Ev();
extern void _ZN10S5266C2_nt3v65Ev();
extern void _ZN10S5266C2_nt3v66Ev();
extern void _ZN10S5266C2_nt3v67Ev();
extern void _ZN10S5266C2_nt3v68Ev();
extern void _ZN10S5266C2_nt3v69Ev();
extern void _ZN10S5266C2_nt3v70Ev();
extern void _ZN10S5266C2_nt3v71Ev();
extern void _ZN10S5266C2_nt3v72Ev();
extern void _ZN10S5266C2_nt3v73Ev();
extern void _ZN10S5266C2_nt3v74Ev();
extern void _ZN10S5266C2_nt3v75Ev();
extern void _ZN10S5266C2_nt3v76Ev();
extern void _ZN10S5266C2_nt3v77Ev();
extern void _ZN10S5266C2_nt3v78Ev();
extern void _ZN10S5266C2_nt3v79Ev();
extern void _ZN10S5266C2_nt3v80Ev();
extern void _ZN10S5266C2_nt3v81Ev();
extern void _ZN10S5266C2_nt3v82Ev();
extern void _ZN10S5266C2_nt3v83Ev();
extern void _ZN10S5266C2_nt3v84Ev();
extern void _ZN10S5266C2_nt3v85Ev();
extern void _ZN10S5266C2_nt3v86Ev();
extern void _ZN10S5266C2_nt3v87Ev();
extern void _ZN10S5266C2_nt3v88Ev();
extern void _ZN10S5266C2_nt3v89Ev();
extern void _ZN10S5266C2_nt3v90Ev();
extern void _ZN10S5266C2_nt3v91Ev();
extern void _ZN10S5266C2_nt3v92Ev();
extern void _ZN10S5266C2_nt3v93Ev();
extern void _ZN10S5266C2_nt3v94Ev();
extern void _ZN10S5266C2_nt3v95Ev();
extern void _ZN10S5266C2_nt3v96Ev();
extern void _ZN10S5266C2_nt3v97Ev();
extern void _ZN10S5266C2_nt3v98Ev();
extern void _ZN10S5266C2_nt3v99Ev();
extern void _ZN10S5266C2_nt4v100Ev();
extern void _ZN10S5266C2_nt4v101Ev();
extern void _ZN10S5266C2_nt4v102Ev();
extern void _ZN10S5266C2_nt4v103Ev();
extern void _ZN10S5266C2_nt4v104Ev();
extern void _ZN10S5266C2_nt4v105Ev();
static  VTBL_ENTRY vtc_S5266C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5266C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S5266C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v105Ev,
};
extern VTBL_ENTRY _ZTI10S5266C2_nt[];
VTBL_ENTRY *P__ZTI10S5266C2_nt = _ZTI10S5266C2_nt; 
extern  VTBL_ENTRY _ZTV10S5266C2_nt[];
Class_Descriptor cd_S5266C2_nt = {  "S5266C2_nt", // class name
  bases_S5266C2_nt, 1,
  &(vtc_S5266C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S5266C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S5266C2_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C39_nt  {
  __tsi64 s5266c39f0;
  void  mf5266c39(); // _ZN11S5266C39_nt9mf5266c39Ev
};
//SIG(-1 S5266C39_nt) C1{ m FL}


void  S5266C39_nt ::mf5266c39(){}

//skip512 S5266C39_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C38_nt  {
  ::S5266C39_nt s5266c38f0;
  void  mf5266c38(); // _ZN11S5266C38_nt9mf5266c38Ev
};
//SIG(-1 S5266C38_nt) C1{ m FC2{ m FL}}


void  S5266C38_nt ::mf5266c38(){}

//skip512 S5266C38_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5266C1  : S5266C2_nt {
  void *s5266c1f0;
  ::S5266C38_nt s5266c1f1;
  ::S5266C38_nt s5266c1f2;
  void *s5266c1f3;
  ::S5266C38_nt s5266c1f4;
  ::S5266C38_nt s5266c1f5;
  ::S5266C12_nt s5266c1f6;
  int s5266c1f7;
  char s5266c1f8;
  virtual  ~S5266C1(); // _ZN7S5266C1D1Ev
  virtual void  v1(); // _ZN7S5266C12v1Ev
  virtual void  v2(); // _ZN7S5266C12v2Ev
  virtual void  v3(); // _ZN7S5266C12v3Ev
  virtual void  v4(); // _ZN7S5266C12v4Ev
  S5266C1(); // tgen
};
//SIG(1 S5266C1) C1{ BC2{ BC3{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 Fp FC22{ m FC23{ m FL}} FC22 Fp FC22 FC22 FC8 Fi Fc}


 S5266C1 ::~S5266C1(){ note_dtor("S5266C1", this);}
void  S5266C1 ::v1(){vfunc_called(this, "_ZN7S5266C12v1Ev");}
void  S5266C1 ::v2(){vfunc_called(this, "_ZN7S5266C12v2Ev");}
void  S5266C1 ::v3(){vfunc_called(this, "_ZN7S5266C12v3Ev");}
void  S5266C1 ::v4(){vfunc_called(this, "_ZN7S5266C12v4Ev");}
S5266C1 ::S5266C1(){ note_ctor("S5266C1", this);} // tgen

static void Test_S5266C1()
{
  extern Class_Descriptor cd_S5266C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(114,175)];
    init_test(&cd_S5266C1, buf);
    S5266C1 *dp, &lv = *(dp=new (buf) S5266C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(904,696), "sizeof(S5266C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5266C1)");
    check_base_class_offset(lv, (S5266C3_nt*)(S5266C2_nt*), 0, "S5266C1");
    check_base_class_offset(lv, (S5266C2_nt*), 0, "S5266C1");
    check_field_offset(lv, s5266c1f0, ABISELECT(832,632), "S5266C1.s5266c1f0");
    check_field_offset(lv, s5266c1f1, ABISELECT(840,636), "S5266C1.s5266c1f1");
    check_field_offset(lv, s5266c1f2, ABISELECT(848,644), "S5266C1.s5266c1f2");
    check_field_offset(lv, s5266c1f3, ABISELECT(856,652), "S5266C1.s5266c1f3");
    check_field_offset(lv, s5266c1f4, ABISELECT(864,656), "S5266C1.s5266c1f4");
    check_field_offset(lv, s5266c1f5, ABISELECT(872,664), "S5266C1.s5266c1f5");
    check_field_offset(lv, s5266c1f6, ABISELECT(880,672), "S5266C1.s5266c1f6");
    check_field_offset(lv, s5266c1f7, ABISELECT(896,688), "S5266C1.s5266c1f7");
    check_field_offset(lv, s5266c1f8, ABISELECT(900,692), "S5266C1.s5266c1f8");
    test_class_info(&lv, &cd_S5266C1);
    dp->~S5266C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5266C1(Test_S5266C1, "S5266C1", ABISELECT(904,696));

#else // __cplusplus

extern void _ZN7S5266C1C1Ev();
extern void _ZN7S5266C1D1Ev();
Name_Map name_map_S5266C1[] = {
  NSPAIR(_ZN7S5266C1C1Ev),
  NSPAIR(_ZN7S5266C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5266C3_nt;
extern VTBL_ENTRY _ZTI10S5266C3_nt[];
extern  VTBL_ENTRY _ZTV10S5266C3_nt[];
extern Class_Descriptor cd_S5266C2_nt;
extern VTBL_ENTRY _ZTI10S5266C2_nt[];
extern  VTBL_ENTRY _ZTV10S5266C2_nt[];
static Base_Class bases_S5266C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5266C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5266C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S5266C1[];
extern void _ZN7S5266C1D1Ev();
extern void _ZN7S5266C1D0Ev();
extern void _ZN10S5266C3_nt2v5Ev();
extern void _ZN10S5266C3_nt2v6Ev();
extern void _ZN10S5266C3_nt2v7Ev();
extern void _ZN10S5266C3_nt2v8Ev();
extern void _ZN10S5266C3_nt2v9Ev();
extern void _ZN10S5266C3_nt3v10Ev();
extern void _ZN10S5266C3_nt3v11Ev();
extern void _ZN10S5266C3_nt3v12Ev();
extern void _ZN10S5266C3_nt3v13Ev();
extern void _ZN10S5266C3_nt3v14Ev();
extern void _ZN10S5266C3_nt3v15Ev();
extern void _ZN10S5266C3_nt3v16Ev();
extern void _ZN10S5266C3_nt3v17Ev();
extern void _ZN10S5266C3_nt3v18Ev();
extern void _ZN10S5266C3_nt3v19Ev();
extern void _ZN10S5266C3_nt3v20Ev();
extern void _ZN10S5266C3_nt3v21Ev();
extern void _ZN10S5266C3_nt3v22Ev();
extern void _ZN10S5266C3_nt3v23Ev();
extern void _ZN10S5266C3_nt3v24Ev();
extern void _ZN10S5266C3_nt3v25Ev();
extern void _ZN10S5266C3_nt3v26Ev();
extern void _ZN10S5266C3_nt3v27Ev();
extern void _ZN10S5266C2_nt3v28Ev();
extern void _ZN10S5266C2_nt3v29Ev();
extern void _ZN10S5266C2_nt3v30Ev();
extern void _ZN10S5266C2_nt3v31Ev();
extern void _ZN10S5266C2_nt3v32Ev();
extern void _ZN10S5266C2_nt3v33Ev();
extern void _ZN10S5266C2_nt3v34Ev();
extern void _ZN10S5266C2_nt3v35Ev();
extern void _ZN10S5266C2_nt3v36Ev();
extern void _ZN10S5266C2_nt3v37Ev();
extern void _ZN10S5266C2_nt3v38Ev();
extern void _ZN10S5266C2_nt3v39Ev();
extern void _ZN10S5266C2_nt3v40Ev();
extern void _ZN10S5266C2_nt3v41Ev();
extern void _ZN10S5266C2_nt3v42Ev();
extern void _ZN10S5266C2_nt3v43Ev();
extern void _ZN10S5266C2_nt3v44Ev();
extern void _ZN10S5266C2_nt3v45Ev();
extern void _ZN10S5266C2_nt3v46Ev();
extern void _ZN10S5266C2_nt3v47Ev();
extern void _ZN10S5266C2_nt3v48Ev();
extern void _ZN10S5266C2_nt3v49Ev();
extern void _ZN10S5266C2_nt3v50Ev();
extern void _ZN10S5266C2_nt3v51Ev();
extern void _ZN10S5266C2_nt3v52Ev();
extern void _ZN10S5266C2_nt3v53Ev();
extern void _ZN10S5266C2_nt3v54Ev();
extern void _ZN10S5266C2_nt3v55Ev();
extern void _ZN10S5266C2_nt3v56Ev();
extern void _ZN10S5266C2_nt3v57Ev();
extern void _ZN10S5266C2_nt3v58Ev();
extern void _ZN10S5266C2_nt3v59Ev();
extern void _ZN10S5266C2_nt3v60Ev();
extern void _ZN10S5266C2_nt3v61Ev();
extern void _ZN10S5266C2_nt3v62Ev();
extern void _ZN10S5266C2_nt3v63Ev();
extern void _ZN10S5266C2_nt3v64Ev();
extern void _ZN10S5266C2_nt3v65Ev();
extern void _ZN10S5266C2_nt3v66Ev();
extern void _ZN10S5266C2_nt3v67Ev();
extern void _ZN10S5266C2_nt3v68Ev();
extern void _ZN10S5266C2_nt3v69Ev();
extern void _ZN10S5266C2_nt3v70Ev();
extern void _ZN10S5266C2_nt3v71Ev();
extern void _ZN10S5266C2_nt3v72Ev();
extern void _ZN10S5266C2_nt3v73Ev();
extern void _ZN10S5266C2_nt3v74Ev();
extern void _ZN10S5266C2_nt3v75Ev();
extern void _ZN10S5266C2_nt3v76Ev();
extern void _ZN10S5266C2_nt3v77Ev();
extern void _ZN10S5266C2_nt3v78Ev();
extern void _ZN10S5266C2_nt3v79Ev();
extern void _ZN10S5266C2_nt3v80Ev();
extern void _ZN10S5266C2_nt3v81Ev();
extern void _ZN10S5266C2_nt3v82Ev();
extern void _ZN10S5266C2_nt3v83Ev();
extern void _ZN10S5266C2_nt3v84Ev();
extern void _ZN10S5266C2_nt3v85Ev();
extern void _ZN10S5266C2_nt3v86Ev();
extern void _ZN10S5266C2_nt3v87Ev();
extern void _ZN10S5266C2_nt3v88Ev();
extern void _ZN10S5266C2_nt3v89Ev();
extern void _ZN10S5266C2_nt3v90Ev();
extern void _ZN10S5266C2_nt3v91Ev();
extern void _ZN10S5266C2_nt3v92Ev();
extern void _ZN10S5266C2_nt3v93Ev();
extern void _ZN10S5266C2_nt3v94Ev();
extern void _ZN10S5266C2_nt3v95Ev();
extern void _ZN10S5266C2_nt3v96Ev();
extern void _ZN10S5266C2_nt3v97Ev();
extern void _ZN10S5266C2_nt3v98Ev();
extern void _ZN10S5266C2_nt3v99Ev();
extern void _ZN10S5266C2_nt4v100Ev();
extern void _ZN10S5266C2_nt4v101Ev();
extern void _ZN10S5266C2_nt4v102Ev();
extern void _ZN10S5266C2_nt4v103Ev();
extern void _ZN10S5266C2_nt4v104Ev();
extern void _ZN10S5266C2_nt4v105Ev();
extern void _ZN7S5266C12v1Ev();
extern void _ZN7S5266C12v2Ev();
extern void _ZN7S5266C12v3Ev();
extern void _ZN7S5266C12v4Ev();
static  VTBL_ENTRY vtc_S5266C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5266C1[0]),
  (VTBL_ENTRY)&_ZN7S5266C1D1Ev,
  (VTBL_ENTRY)&_ZN7S5266C1D0Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5266C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S5266C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN7S5266C12v1Ev,
  (VTBL_ENTRY)&_ZN7S5266C12v2Ev,
  (VTBL_ENTRY)&_ZN7S5266C12v3Ev,
  (VTBL_ENTRY)&_ZN7S5266C12v4Ev,
};
extern VTBL_ENTRY _ZTI7S5266C1[];
extern  VTBL_ENTRY _ZTV7S5266C1[];
Class_Descriptor cd_S5266C1 = {  "S5266C1", // class name
  bases_S5266C1, 2,
  &(vtc_S5266C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(904,696), // object size
  NSPAIRA(_ZTI7S5266C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S5266C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C3  {
  int s3262c3f0;
  __tsi64 s3262c3f1;
  void *s3262c3f2[4];
  int s3262c3f3[2];
  void *s3262c3f4;
  ::S79C8_nt s3262c3f5;
  void *s3262c3f6[2];
  virtual  ~S3262C3(); // _ZN7S3262C3D1Ev
  virtual void  v44(); // _ZN7S3262C33v44Ev
  virtual void  v45(); // _ZN7S3262C33v45Ev
  virtual void  v46(); // _ZN7S3262C33v46Ev
  virtual void  v47(); // _ZN7S3262C33v47Ev
  virtual void  v48(); // _ZN7S3262C33v48Ev
  virtual void  v49(); // _ZN7S3262C33v49Ev
  virtual void  v50(); // _ZN7S3262C33v50Ev
  virtual void  v51(); // _ZN7S3262C33v51Ev
  virtual void  v52(); // _ZN7S3262C33v52Ev
  virtual void  v53(); // _ZN7S3262C33v53Ev
  virtual void  v54(); // _ZN7S3262C33v54Ev
  virtual void  v55(); // _ZN7S3262C33v55Ev
  virtual void  v56(); // _ZN7S3262C33v56Ev
  virtual void  v57(); // _ZN7S3262C33v57Ev
  virtual void  v58(); // _ZN7S3262C33v58Ev
  virtual void  v59(); // _ZN7S3262C33v59Ev
  virtual void  v60(); // _ZN7S3262C33v60Ev
  virtual void  v61(); // _ZN7S3262C33v61Ev
  virtual void  v62(); // _ZN7S3262C33v62Ev
  virtual void  v63(); // _ZN7S3262C33v63Ev
  virtual void  v64(); // _ZN7S3262C33v64Ev
  virtual void  v65(); // _ZN7S3262C33v65Ev
  virtual void  v66(); // _ZN7S3262C33v66Ev
  virtual void  v67(); // _ZN7S3262C33v67Ev
  virtual void  v68(); // _ZN7S3262C33v68Ev
  virtual void  v69(); // _ZN7S3262C33v69Ev
  virtual void  v70(); // _ZN7S3262C33v70Ev
  virtual void  v71(); // _ZN7S3262C33v71Ev
  virtual void  v72(); // _ZN7S3262C33v72Ev
  virtual void  v73(); // _ZN7S3262C33v73Ev
  virtual void  v74(); // _ZN7S3262C33v74Ev
  virtual void  v75(); // _ZN7S3262C33v75Ev
  virtual void  v76(); // _ZN7S3262C33v76Ev
  virtual void  v77(); // _ZN7S3262C33v77Ev
  virtual void  v78(); // _ZN7S3262C33v78Ev
  virtual void  v79(); // _ZN7S3262C33v79Ev
  virtual void  v80(); // _ZN7S3262C33v80Ev
  virtual void  v81(); // _ZN7S3262C33v81Ev
  virtual void  v82(); // _ZN7S3262C33v82Ev
  virtual void  v83(); // _ZN7S3262C33v83Ev
  virtual void  v84(); // _ZN7S3262C33v84Ev
  virtual void  v85(); // _ZN7S3262C33v85Ev
  virtual void  v86(); // _ZN7S3262C33v86Ev
  virtual void  v87(); // _ZN7S3262C33v87Ev
  virtual void  v88(); // _ZN7S3262C33v88Ev
  virtual void  v89(); // _ZN7S3262C33v89Ev
  virtual void  v90(); // _ZN7S3262C33v90Ev
  virtual void  v91(); // _ZN7S3262C33v91Ev
  virtual void  v92(); // _ZN7S3262C33v92Ev
  virtual void  v93(); // _ZN7S3262C33v93Ev
  virtual void  v94(); // _ZN7S3262C33v94Ev
  virtual void  v95(); // _ZN7S3262C33v95Ev
  virtual void  v96(); // _ZN7S3262C33v96Ev
  virtual void  v97(); // _ZN7S3262C33v97Ev
  virtual void  v98(); // _ZN7S3262C33v98Ev
  virtual void  v99(); // _ZN7S3262C33v99Ev
  virtual void  v100(); // _ZN7S3262C34v100Ev
  virtual void  v101(); // _ZN7S3262C34v101Ev
  virtual void  v102(); // _ZN7S3262C34v102Ev
  virtual void  v103(); // _ZN7S3262C34v103Ev
  virtual void  v104(); // _ZN7S3262C34v104Ev
  virtual void  v105(); // _ZN7S3262C34v105Ev
  virtual void  v106(); // _ZN7S3262C34v106Ev
  virtual void  v107(); // _ZN7S3262C34v107Ev
  S3262C3(); // tgen
};
//SIG(-1 S3262C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3262C3 ::~S3262C3(){ note_dtor("S3262C3", this);}
void  S3262C3 ::v44(){vfunc_called(this, "_ZN7S3262C33v44Ev");}
void  S3262C3 ::v45(){vfunc_called(this, "_ZN7S3262C33v45Ev");}
void  S3262C3 ::v46(){vfunc_called(this, "_ZN7S3262C33v46Ev");}
void  S3262C3 ::v47(){vfunc_called(this, "_ZN7S3262C33v47Ev");}
void  S3262C3 ::v48(){vfunc_called(this, "_ZN7S3262C33v48Ev");}
void  S3262C3 ::v49(){vfunc_called(this, "_ZN7S3262C33v49Ev");}
void  S3262C3 ::v50(){vfunc_called(this, "_ZN7S3262C33v50Ev");}
void  S3262C3 ::v51(){vfunc_called(this, "_ZN7S3262C33v51Ev");}
void  S3262C3 ::v52(){vfunc_called(this, "_ZN7S3262C33v52Ev");}
void  S3262C3 ::v53(){vfunc_called(this, "_ZN7S3262C33v53Ev");}
void  S3262C3 ::v54(){vfunc_called(this, "_ZN7S3262C33v54Ev");}
void  S3262C3 ::v55(){vfunc_called(this, "_ZN7S3262C33v55Ev");}
void  S3262C3 ::v56(){vfunc_called(this, "_ZN7S3262C33v56Ev");}
void  S3262C3 ::v57(){vfunc_called(this, "_ZN7S3262C33v57Ev");}
void  S3262C3 ::v58(){vfunc_called(this, "_ZN7S3262C33v58Ev");}
void  S3262C3 ::v59(){vfunc_called(this, "_ZN7S3262C33v59Ev");}
void  S3262C3 ::v60(){vfunc_called(this, "_ZN7S3262C33v60Ev");}
void  S3262C3 ::v61(){vfunc_called(this, "_ZN7S3262C33v61Ev");}
void  S3262C3 ::v62(){vfunc_called(this, "_ZN7S3262C33v62Ev");}
void  S3262C3 ::v63(){vfunc_called(this, "_ZN7S3262C33v63Ev");}
void  S3262C3 ::v64(){vfunc_called(this, "_ZN7S3262C33v64Ev");}
void  S3262C3 ::v65(){vfunc_called(this, "_ZN7S3262C33v65Ev");}
void  S3262C3 ::v66(){vfunc_called(this, "_ZN7S3262C33v66Ev");}
void  S3262C3 ::v67(){vfunc_called(this, "_ZN7S3262C33v67Ev");}
void  S3262C3 ::v68(){vfunc_called(this, "_ZN7S3262C33v68Ev");}
void  S3262C3 ::v69(){vfunc_called(this, "_ZN7S3262C33v69Ev");}
void  S3262C3 ::v70(){vfunc_called(this, "_ZN7S3262C33v70Ev");}
void  S3262C3 ::v71(){vfunc_called(this, "_ZN7S3262C33v71Ev");}
void  S3262C3 ::v72(){vfunc_called(this, "_ZN7S3262C33v72Ev");}
void  S3262C3 ::v73(){vfunc_called(this, "_ZN7S3262C33v73Ev");}
void  S3262C3 ::v74(){vfunc_called(this, "_ZN7S3262C33v74Ev");}
void  S3262C3 ::v75(){vfunc_called(this, "_ZN7S3262C33v75Ev");}
void  S3262C3 ::v76(){vfunc_called(this, "_ZN7S3262C33v76Ev");}
void  S3262C3 ::v77(){vfunc_called(this, "_ZN7S3262C33v77Ev");}
void  S3262C3 ::v78(){vfunc_called(this, "_ZN7S3262C33v78Ev");}
void  S3262C3 ::v79(){vfunc_called(this, "_ZN7S3262C33v79Ev");}
void  S3262C3 ::v80(){vfunc_called(this, "_ZN7S3262C33v80Ev");}
void  S3262C3 ::v81(){vfunc_called(this, "_ZN7S3262C33v81Ev");}
void  S3262C3 ::v82(){vfunc_called(this, "_ZN7S3262C33v82Ev");}
void  S3262C3 ::v83(){vfunc_called(this, "_ZN7S3262C33v83Ev");}
void  S3262C3 ::v84(){vfunc_called(this, "_ZN7S3262C33v84Ev");}
void  S3262C3 ::v85(){vfunc_called(this, "_ZN7S3262C33v85Ev");}
void  S3262C3 ::v86(){vfunc_called(this, "_ZN7S3262C33v86Ev");}
void  S3262C3 ::v87(){vfunc_called(this, "_ZN7S3262C33v87Ev");}
void  S3262C3 ::v88(){vfunc_called(this, "_ZN7S3262C33v88Ev");}
void  S3262C3 ::v89(){vfunc_called(this, "_ZN7S3262C33v89Ev");}
void  S3262C3 ::v90(){vfunc_called(this, "_ZN7S3262C33v90Ev");}
void  S3262C3 ::v91(){vfunc_called(this, "_ZN7S3262C33v91Ev");}
void  S3262C3 ::v92(){vfunc_called(this, "_ZN7S3262C33v92Ev");}
void  S3262C3 ::v93(){vfunc_called(this, "_ZN7S3262C33v93Ev");}
void  S3262C3 ::v94(){vfunc_called(this, "_ZN7S3262C33v94Ev");}
void  S3262C3 ::v95(){vfunc_called(this, "_ZN7S3262C33v95Ev");}
void  S3262C3 ::v96(){vfunc_called(this, "_ZN7S3262C33v96Ev");}
void  S3262C3 ::v97(){vfunc_called(this, "_ZN7S3262C33v97Ev");}
void  S3262C3 ::v98(){vfunc_called(this, "_ZN7S3262C33v98Ev");}
void  S3262C3 ::v99(){vfunc_called(this, "_ZN7S3262C33v99Ev");}
void  S3262C3 ::v100(){vfunc_called(this, "_ZN7S3262C34v100Ev");}
void  S3262C3 ::v101(){vfunc_called(this, "_ZN7S3262C34v101Ev");}
void  S3262C3 ::v102(){vfunc_called(this, "_ZN7S3262C34v102Ev");}
void  S3262C3 ::v103(){vfunc_called(this, "_ZN7S3262C34v103Ev");}
void  S3262C3 ::v104(){vfunc_called(this, "_ZN7S3262C34v104Ev");}
void  S3262C3 ::v105(){vfunc_called(this, "_ZN7S3262C34v105Ev");}
void  S3262C3 ::v106(){vfunc_called(this, "_ZN7S3262C34v106Ev");}
void  S3262C3 ::v107(){vfunc_called(this, "_ZN7S3262C34v107Ev");}
S3262C3 ::S3262C3(){ note_ctor("S3262C3", this);} // tgen

static void Test_S3262C3()
{
  extern Class_Descriptor cd_S3262C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3262C3, buf);
    S3262C3 *dp, &lv = *(dp=new (buf) S3262C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3262C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3262C3)");
    check_field_offset(lv, s3262c3f0, ABISELECT(8,4), "S3262C3.s3262c3f0");
    check_field_offset(lv, s3262c3f1, ABISELECT(16,8), "S3262C3.s3262c3f1");
    check_field_offset(lv, s3262c3f2, ABISELECT(24,16), "S3262C3.s3262c3f2");
    check_field_offset(lv, s3262c3f3, ABISELECT(56,32), "S3262C3.s3262c3f3");
    check_field_offset(lv, s3262c3f4, ABISELECT(64,40), "S3262C3.s3262c3f4");
    check_field_offset(lv, s3262c3f5, ABISELECT(72,44), "S3262C3.s3262c3f5");
    check_field_offset(lv, s3262c3f6, ABISELECT(80,52), "S3262C3.s3262c3f6");
    test_class_info(&lv, &cd_S3262C3);
    dp->~S3262C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3262C3(Test_S3262C3, "S3262C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3262C3C1Ev();
extern void _ZN7S3262C3D1Ev();
Name_Map name_map_S3262C3[] = {
  NSPAIR(_ZN7S3262C3C1Ev),
  NSPAIR(_ZN7S3262C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3262C3[];
extern void _ZN7S3262C3D1Ev();
extern void _ZN7S3262C3D0Ev();
extern void _ZN7S3262C33v44Ev();
extern void _ZN7S3262C33v45Ev();
extern void _ZN7S3262C33v46Ev();
extern void _ZN7S3262C33v47Ev();
extern void _ZN7S3262C33v48Ev();
extern void _ZN7S3262C33v49Ev();
extern void _ZN7S3262C33v50Ev();
extern void _ZN7S3262C33v51Ev();
extern void _ZN7S3262C33v52Ev();
extern void _ZN7S3262C33v53Ev();
extern void _ZN7S3262C33v54Ev();
extern void _ZN7S3262C33v55Ev();
extern void _ZN7S3262C33v56Ev();
extern void _ZN7S3262C33v57Ev();
extern void _ZN7S3262C33v58Ev();
extern void _ZN7S3262C33v59Ev();
extern void _ZN7S3262C33v60Ev();
extern void _ZN7S3262C33v61Ev();
extern void _ZN7S3262C33v62Ev();
extern void _ZN7S3262C33v63Ev();
extern void _ZN7S3262C33v64Ev();
extern void _ZN7S3262C33v65Ev();
extern void _ZN7S3262C33v66Ev();
extern void _ZN7S3262C33v67Ev();
extern void _ZN7S3262C33v68Ev();
extern void _ZN7S3262C33v69Ev();
extern void _ZN7S3262C33v70Ev();
extern void _ZN7S3262C33v71Ev();
extern void _ZN7S3262C33v72Ev();
extern void _ZN7S3262C33v73Ev();
extern void _ZN7S3262C33v74Ev();
extern void _ZN7S3262C33v75Ev();
extern void _ZN7S3262C33v76Ev();
extern void _ZN7S3262C33v77Ev();
extern void _ZN7S3262C33v78Ev();
extern void _ZN7S3262C33v79Ev();
extern void _ZN7S3262C33v80Ev();
extern void _ZN7S3262C33v81Ev();
extern void _ZN7S3262C33v82Ev();
extern void _ZN7S3262C33v83Ev();
extern void _ZN7S3262C33v84Ev();
extern void _ZN7S3262C33v85Ev();
extern void _ZN7S3262C33v86Ev();
extern void _ZN7S3262C33v87Ev();
extern void _ZN7S3262C33v88Ev();
extern void _ZN7S3262C33v89Ev();
extern void _ZN7S3262C33v90Ev();
extern void _ZN7S3262C33v91Ev();
extern void _ZN7S3262C33v92Ev();
extern void _ZN7S3262C33v93Ev();
extern void _ZN7S3262C33v94Ev();
extern void _ZN7S3262C33v95Ev();
extern void _ZN7S3262C33v96Ev();
extern void _ZN7S3262C33v97Ev();
extern void _ZN7S3262C33v98Ev();
extern void _ZN7S3262C33v99Ev();
extern void _ZN7S3262C34v100Ev();
extern void _ZN7S3262C34v101Ev();
extern void _ZN7S3262C34v102Ev();
extern void _ZN7S3262C34v103Ev();
extern void _ZN7S3262C34v104Ev();
extern void _ZN7S3262C34v105Ev();
extern void _ZN7S3262C34v106Ev();
extern void _ZN7S3262C34v107Ev();
static  VTBL_ENTRY vtc_S3262C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3262C3[0]),
  (VTBL_ENTRY)&_ZN7S3262C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3262C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v81Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v82Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v83Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v84Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v85Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v86Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v87Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v88Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v89Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v90Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v91Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v92Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v93Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v94Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v95Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v96Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v97Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v98Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v99Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v100Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v101Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v102Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v103Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v104Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v105Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v106Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v107Ev,
};
extern VTBL_ENTRY _ZTI7S3262C3[];
extern  VTBL_ENTRY _ZTV7S3262C3[];
Class_Descriptor cd_S3262C3 = {  "S3262C3", // class name
  0,0,//no base classes
  &(vtc_S3262C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3262C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3262C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C5  {
  virtual void  v108(); // _ZN7S3262C54v108Ev
  virtual void  v109(); // _ZN7S3262C54v109Ev
  virtual void  v110(); // _ZN7S3262C54v110Ev
  virtual void  v111(); // _ZN7S3262C54v111Ev
  virtual void  v112(); // _ZN7S3262C54v112Ev
  virtual void  v113(); // _ZN7S3262C54v113Ev
  virtual void  v114(); // _ZN7S3262C54v114Ev
  virtual void  v115(); // _ZN7S3262C54v115Ev
  virtual void  v116(); // _ZN7S3262C54v116Ev
  virtual void  v117(); // _ZN7S3262C54v117Ev
  virtual void  v118(); // _ZN7S3262C54v118Ev
  virtual void  v119(); // _ZN7S3262C54v119Ev
  virtual void  v120(); // _ZN7S3262C54v120Ev
  virtual void  v121(); // _ZN7S3262C54v121Ev
  virtual void  v122(); // _ZN7S3262C54v122Ev
  virtual void  v123(); // _ZN7S3262C54v123Ev
  ~S3262C5(); // tgen
  S3262C5(); // tgen
};
//SIG(-1 S3262C5) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S3262C5 ::v108(){vfunc_called(this, "_ZN7S3262C54v108Ev");}
void  S3262C5 ::v109(){vfunc_called(this, "_ZN7S3262C54v109Ev");}
void  S3262C5 ::v110(){vfunc_called(this, "_ZN7S3262C54v110Ev");}
void  S3262C5 ::v111(){vfunc_called(this, "_ZN7S3262C54v111Ev");}
void  S3262C5 ::v112(){vfunc_called(this, "_ZN7S3262C54v112Ev");}
void  S3262C5 ::v113(){vfunc_called(this, "_ZN7S3262C54v113Ev");}
void  S3262C5 ::v114(){vfunc_called(this, "_ZN7S3262C54v114Ev");}
void  S3262C5 ::v115(){vfunc_called(this, "_ZN7S3262C54v115Ev");}
void  S3262C5 ::v116(){vfunc_called(this, "_ZN7S3262C54v116Ev");}
void  S3262C5 ::v117(){vfunc_called(this, "_ZN7S3262C54v117Ev");}
void  S3262C5 ::v118(){vfunc_called(this, "_ZN7S3262C54v118Ev");}
void  S3262C5 ::v119(){vfunc_called(this, "_ZN7S3262C54v119Ev");}
void  S3262C5 ::v120(){vfunc_called(this, "_ZN7S3262C54v120Ev");}
void  S3262C5 ::v121(){vfunc_called(this, "_ZN7S3262C54v121Ev");}
void  S3262C5 ::v122(){vfunc_called(this, "_ZN7S3262C54v122Ev");}
void  S3262C5 ::v123(){vfunc_called(this, "_ZN7S3262C54v123Ev");}
S3262C5 ::~S3262C5(){ note_dtor("S3262C5", this);} // tgen
S3262C5 ::S3262C5(){ note_ctor("S3262C5", this);} // tgen

static void Test_S3262C5()
{
  extern Class_Descriptor cd_S3262C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3262C5, buf);
    S3262C5 *dp, &lv = *(dp=new (buf) S3262C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3262C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3262C5)");
    test_class_info(&lv, &cd_S3262C5);
    dp->~S3262C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3262C5(Test_S3262C5, "S3262C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3262C5C1Ev();
extern void _ZN7S3262C5D1Ev();
Name_Map name_map_S3262C5[] = {
  NSPAIR(_ZN7S3262C5C1Ev),
  NSPAIR(_ZN7S3262C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3262C5[];
extern void _ZN7S3262C54v108Ev();
extern void _ZN7S3262C54v109Ev();
extern void _ZN7S3262C54v110Ev();
extern void _ZN7S3262C54v111Ev();
extern void _ZN7S3262C54v112Ev();
extern void _ZN7S3262C54v113Ev();
extern void _ZN7S3262C54v114Ev();
extern void _ZN7S3262C54v115Ev();
extern void _ZN7S3262C54v116Ev();
extern void _ZN7S3262C54v117Ev();
extern void _ZN7S3262C54v118Ev();
extern void _ZN7S3262C54v119Ev();
extern void _ZN7S3262C54v120Ev();
extern void _ZN7S3262C54v121Ev();
extern void _ZN7S3262C54v122Ev();
extern void _ZN7S3262C54v123Ev();
static  VTBL_ENTRY vtc_S3262C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3262C5[0]),
  (VTBL_ENTRY)&_ZN7S3262C54v108Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v109Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v110Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v111Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v112Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v113Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v114Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v115Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v116Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v117Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v118Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v119Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v120Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v121Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v122Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v123Ev,
};
extern VTBL_ENTRY _ZTI7S3262C5[];
extern  VTBL_ENTRY _ZTV7S3262C5[];
Class_Descriptor cd_S3262C5 = {  "S3262C5", // class name
  0,0,//no base classes
  &(vtc_S3262C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3262C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3262C5),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C6  {
  virtual void  v124(); // _ZN7S3262C64v124Ev
  virtual void  v125(); // _ZN7S3262C64v125Ev
  virtual void  v126(); // _ZN7S3262C64v126Ev
  virtual void  v127(); // _ZN7S3262C64v127Ev
  virtual void  v128(); // _ZN7S3262C64v128Ev
  virtual void  v129(); // _ZN7S3262C64v129Ev
  virtual void  v130(); // _ZN7S3262C64v130Ev
  virtual void  v131(); // _ZN7S3262C64v131Ev
  virtual void  v132(); // _ZN7S3262C64v132Ev
  ~S3262C6(); // tgen
  S3262C6(); // tgen
};
//SIG(-1 S3262C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S3262C6 ::v124(){vfunc_called(this, "_ZN7S3262C64v124Ev");}
void  S3262C6 ::v125(){vfunc_called(this, "_ZN7S3262C64v125Ev");}
void  S3262C6 ::v126(){vfunc_called(this, "_ZN7S3262C64v126Ev");}
void  S3262C6 ::v127(){vfunc_called(this, "_ZN7S3262C64v127Ev");}
void  S3262C6 ::v128(){vfunc_called(this, "_ZN7S3262C64v128Ev");}
void  S3262C6 ::v129(){vfunc_called(this, "_ZN7S3262C64v129Ev");}
void  S3262C6 ::v130(){vfunc_called(this, "_ZN7S3262C64v130Ev");}
void  S3262C6 ::v131(){vfunc_called(this, "_ZN7S3262C64v131Ev");}
void  S3262C6 ::v132(){vfunc_called(this, "_ZN7S3262C64v132Ev");}
S3262C6 ::~S3262C6(){ note_dtor("S3262C6", this);} // tgen
S3262C6 ::S3262C6(){ note_ctor("S3262C6", this);} // tgen

static void Test_S3262C6()
{
  extern Class_Descriptor cd_S3262C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3262C6, buf);
    S3262C6 *dp, &lv = *(dp=new (buf) S3262C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3262C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3262C6)");
    test_class_info(&lv, &cd_S3262C6);
    dp->~S3262C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3262C6(Test_S3262C6, "S3262C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3262C6C1Ev();
extern void _ZN7S3262C6D1Ev();
Name_Map name_map_S3262C6[] = {
  NSPAIR(_ZN7S3262C6C1Ev),
  NSPAIR(_ZN7S3262C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3262C6[];
extern void _ZN7S3262C64v124Ev();
extern void _ZN7S3262C64v125Ev();
extern void _ZN7S3262C64v126Ev();
extern void _ZN7S3262C64v127Ev();
extern void _ZN7S3262C64v128Ev();
extern void _ZN7S3262C64v129Ev();
extern void _ZN7S3262C64v130Ev();
extern void _ZN7S3262C64v131Ev();
extern void _ZN7S3262C64v132Ev();
static  VTBL_ENTRY vtc_S3262C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3262C6[0]),
  (VTBL_ENTRY)&_ZN7S3262C64v124Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v125Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v126Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v127Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v128Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v129Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v130Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v131Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v132Ev,
};
extern VTBL_ENTRY _ZTI7S3262C6[];
extern  VTBL_ENTRY _ZTV7S3262C6[];
Class_Descriptor cd_S3262C6 = {  "S3262C6", // class name
  0,0,//no base classes
  &(vtc_S3262C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3262C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3262C6),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C2  : S3262C3 , S3262C5 , S3262C6 {
  void *s3262c2f0;
  ::S79C39_nt s3262c2f1;
  unsigned int s3262c2f2:1;
  unsigned int s3262c2f3:1;
  unsigned int s3262c2f4:1;
  unsigned int s3262c2f5:1;
  virtual  ~S3262C2(); // _ZN7S3262C2D1Ev
  virtual void  v133(); // _ZN7S3262C24v133Ev
  virtual void  v134(); // _ZN7S3262C24v134Ev
  virtual void  v135(); // _ZN7S3262C24v135Ev
  virtual void  v136(); // _ZN7S3262C24v136Ev
  virtual void  v137(); // _ZN7S3262C24v137Ev
  virtual void  v138(); // _ZN7S3262C24v138Ev
  virtual void  v139(); // _ZN7S3262C24v139Ev
  virtual void  v140(); // _ZN7S3262C24v140Ev
  virtual void  v141(); // _ZN7S3262C24v141Ev
  virtual void  v142(); // _ZN7S3262C24v142Ev
  virtual void  v143(); // _ZN7S3262C24v143Ev
  virtual void  v144(); // _ZN7S3262C24v144Ev
  virtual void  v145(); // _ZN7S3262C24v145Ev
  virtual void  v146(); // _ZN7S3262C24v146Ev
  virtual void  v147(); // _ZN7S3262C24v147Ev
  virtual void  v148(); // _ZN7S3262C24v148Ev
  virtual void  v149(); // _ZN7S3262C24v149Ev
  virtual void  v150(); // _ZN7S3262C24v150Ev
  virtual void  v151(); // _ZN7S3262C24v151Ev
  virtual void  v152(); // _ZN7S3262C24v152Ev
  virtual void  v153(); // _ZN7S3262C24v153Ev
  virtual void  v154(); // _ZN7S3262C24v154Ev
  virtual void  v155(); // _ZN7S3262C24v155Ev
  virtual void  v156(); // _ZN7S3262C24v156Ev
  S3262C2(); // tgen
};
//SIG(-1 S3262C2) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S3262C2 ::~S3262C2(){ note_dtor("S3262C2", this);}
void  S3262C2 ::v133(){vfunc_called(this, "_ZN7S3262C24v133Ev");}
void  S3262C2 ::v134(){vfunc_called(this, "_ZN7S3262C24v134Ev");}
void  S3262C2 ::v135(){vfunc_called(this, "_ZN7S3262C24v135Ev");}
void  S3262C2 ::v136(){vfunc_called(this, "_ZN7S3262C24v136Ev");}
void  S3262C2 ::v137(){vfunc_called(this, "_ZN7S3262C24v137Ev");}
void  S3262C2 ::v138(){vfunc_called(this, "_ZN7S3262C24v138Ev");}
void  S3262C2 ::v139(){vfunc_called(this, "_ZN7S3262C24v139Ev");}
void  S3262C2 ::v140(){vfunc_called(this, "_ZN7S3262C24v140Ev");}
void  S3262C2 ::v141(){vfunc_called(this, "_ZN7S3262C24v141Ev");}
void  S3262C2 ::v142(){vfunc_called(this, "_ZN7S3262C24v142Ev");}
void  S3262C2 ::v143(){vfunc_called(this, "_ZN7S3262C24v143Ev");}
void  S3262C2 ::v144(){vfunc_called(this, "_ZN7S3262C24v144Ev");}
void  S3262C2 ::v145(){vfunc_called(this, "_ZN7S3262C24v145Ev");}
void  S3262C2 ::v146(){vfunc_called(this, "_ZN7S3262C24v146Ev");}
void  S3262C2 ::v147(){vfunc_called(this, "_ZN7S3262C24v147Ev");}
void  S3262C2 ::v148(){vfunc_called(this, "_ZN7S3262C24v148Ev");}
void  S3262C2 ::v149(){vfunc_called(this, "_ZN7S3262C24v149Ev");}
void  S3262C2 ::v150(){vfunc_called(this, "_ZN7S3262C24v150Ev");}
void  S3262C2 ::v151(){vfunc_called(this, "_ZN7S3262C24v151Ev");}
void  S3262C2 ::v152(){vfunc_called(this, "_ZN7S3262C24v152Ev");}
void  S3262C2 ::v153(){vfunc_called(this, "_ZN7S3262C24v153Ev");}
void  S3262C2 ::v154(){vfunc_called(this, "_ZN7S3262C24v154Ev");}
void  S3262C2 ::v155(){vfunc_called(this, "_ZN7S3262C24v155Ev");}
void  S3262C2 ::v156(){vfunc_called(this, "_ZN7S3262C24v156Ev");}
S3262C2 ::S3262C2(){ note_ctor("S3262C2", this);} // tgen

static void Test_S3262C2()
{
  extern Class_Descriptor cd_S3262C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S3262C2, buf);
    S3262C2 *dp, &lv = *(dp=new (buf) S3262C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S3262C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3262C2)");
    check_base_class_offset(lv, (S3262C3*), 0, "S3262C2");
    check_base_class_offset(lv, (S3262C5*), ABISELECT(96,60), "S3262C2");
    check_base_class_offset(lv, (S3262C6*), ABISELECT(104,64), "S3262C2");
    check_field_offset(lv, s3262c2f0, ABISELECT(112,68), "S3262C2.s3262c2f0");
    check_field_offset(lv, s3262c2f1, ABISELECT(120,72), "S3262C2.s3262c2f1");
    set_bf_and_test(lv, s3262c2f2, ABISELECT(136,84), 0, 1, 1, "S3262C2");
    set_bf_and_test(lv, s3262c2f3, ABISELECT(136,84), 1, 1, 1, "S3262C2");
    set_bf_and_test(lv, s3262c2f4, ABISELECT(136,84), 2, 1, 1, "S3262C2");
    set_bf_and_test(lv, s3262c2f5, ABISELECT(136,84), 3, 1, 1, "S3262C2");
    test_class_info(&lv, &cd_S3262C2);
    dp->~S3262C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3262C2(Test_S3262C2, "S3262C2", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S3262C2C1Ev();
extern void _ZN7S3262C2D1Ev();
Name_Map name_map_S3262C2[] = {
  NSPAIR(_ZN7S3262C2C1Ev),
  NSPAIR(_ZN7S3262C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3262C3;
extern VTBL_ENTRY _ZTI7S3262C3[];
extern  VTBL_ENTRY _ZTV7S3262C3[];
extern Class_Descriptor cd_S3262C5;
extern VTBL_ENTRY _ZTI7S3262C5[];
extern  VTBL_ENTRY _ZTV7S3262C5[];
extern Class_Descriptor cd_S3262C6;
extern VTBL_ENTRY _ZTI7S3262C6[];
extern  VTBL_ENTRY _ZTV7S3262C6[];
static Base_Class bases_S3262C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3262C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3262C5,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3262C6,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3262C2[];
extern void _ZN7S3262C2D1Ev();
extern void _ZN7S3262C2D0Ev();
extern void _ZN7S3262C33v44Ev();
extern void _ZN7S3262C33v45Ev();
extern void _ZN7S3262C33v46Ev();
extern void _ZN7S3262C33v47Ev();
extern void _ZN7S3262C33v48Ev();
extern void _ZN7S3262C33v49Ev();
extern void _ZN7S3262C33v50Ev();
extern void _ZN7S3262C33v51Ev();
extern void _ZN7S3262C33v52Ev();
extern void _ZN7S3262C33v53Ev();
extern void _ZN7S3262C33v54Ev();
extern void _ZN7S3262C33v55Ev();
extern void _ZN7S3262C33v56Ev();
extern void _ZN7S3262C33v57Ev();
extern void _ZN7S3262C33v58Ev();
extern void _ZN7S3262C33v59Ev();
extern void _ZN7S3262C33v60Ev();
extern void _ZN7S3262C33v61Ev();
extern void _ZN7S3262C33v62Ev();
extern void _ZN7S3262C33v63Ev();
extern void _ZN7S3262C33v64Ev();
extern void _ZN7S3262C33v65Ev();
extern void _ZN7S3262C33v66Ev();
extern void _ZN7S3262C33v67Ev();
extern void _ZN7S3262C33v68Ev();
extern void _ZN7S3262C33v69Ev();
extern void _ZN7S3262C33v70Ev();
extern void _ZN7S3262C33v71Ev();
extern void _ZN7S3262C33v72Ev();
extern void _ZN7S3262C33v73Ev();
extern void _ZN7S3262C33v74Ev();
extern void _ZN7S3262C33v75Ev();
extern void _ZN7S3262C33v76Ev();
extern void _ZN7S3262C33v77Ev();
extern void _ZN7S3262C33v78Ev();
extern void _ZN7S3262C33v79Ev();
extern void _ZN7S3262C33v80Ev();
extern void _ZN7S3262C33v81Ev();
extern void _ZN7S3262C33v82Ev();
extern void _ZN7S3262C33v83Ev();
extern void _ZN7S3262C33v84Ev();
extern void _ZN7S3262C33v85Ev();
extern void _ZN7S3262C33v86Ev();
extern void _ZN7S3262C33v87Ev();
extern void _ZN7S3262C33v88Ev();
extern void _ZN7S3262C33v89Ev();
extern void _ZN7S3262C33v90Ev();
extern void _ZN7S3262C33v91Ev();
extern void _ZN7S3262C33v92Ev();
extern void _ZN7S3262C33v93Ev();
extern void _ZN7S3262C33v94Ev();
extern void _ZN7S3262C33v95Ev();
extern void _ZN7S3262C33v96Ev();
extern void _ZN7S3262C33v97Ev();
extern void _ZN7S3262C33v98Ev();
extern void _ZN7S3262C33v99Ev();
extern void _ZN7S3262C34v100Ev();
extern void _ZN7S3262C34v101Ev();
extern void _ZN7S3262C34v102Ev();
extern void _ZN7S3262C34v103Ev();
extern void _ZN7S3262C34v104Ev();
extern void _ZN7S3262C34v105Ev();
extern void _ZN7S3262C34v106Ev();
extern void _ZN7S3262C34v107Ev();
extern void _ZN7S3262C24v133Ev();
extern void _ZN7S3262C24v134Ev();
extern void _ZN7S3262C24v135Ev();
extern void _ZN7S3262C24v136Ev();
extern void _ZN7S3262C24v137Ev();
extern void _ZN7S3262C24v138Ev();
extern void _ZN7S3262C24v139Ev();
extern void _ZN7S3262C24v140Ev();
extern void _ZN7S3262C24v141Ev();
extern void _ZN7S3262C24v142Ev();
extern void _ZN7S3262C24v143Ev();
extern void _ZN7S3262C24v144Ev();
extern void _ZN7S3262C24v145Ev();
extern void _ZN7S3262C24v146Ev();
extern void _ZN7S3262C24v147Ev();
extern void _ZN7S3262C24v148Ev();
extern void _ZN7S3262C24v149Ev();
extern void _ZN7S3262C24v150Ev();
extern void _ZN7S3262C24v151Ev();
extern void _ZN7S3262C24v152Ev();
extern void _ZN7S3262C24v153Ev();
extern void _ZN7S3262C24v154Ev();
extern void _ZN7S3262C24v155Ev();
extern void _ZN7S3262C24v156Ev();
extern void _ZN7S3262C54v108Ev();
extern void _ZN7S3262C54v109Ev();
extern void _ZN7S3262C54v110Ev();
extern void _ZN7S3262C54v111Ev();
extern void _ZN7S3262C54v112Ev();
extern void _ZN7S3262C54v113Ev();
extern void _ZN7S3262C54v114Ev();
extern void _ZN7S3262C54v115Ev();
extern void _ZN7S3262C54v116Ev();
extern void _ZN7S3262C54v117Ev();
extern void _ZN7S3262C54v118Ev();
extern void _ZN7S3262C54v119Ev();
extern void _ZN7S3262C54v120Ev();
extern void _ZN7S3262C54v121Ev();
extern void _ZN7S3262C54v122Ev();
extern void _ZN7S3262C54v123Ev();
extern void _ZN7S3262C64v124Ev();
extern void _ZN7S3262C64v125Ev();
extern void _ZN7S3262C64v126Ev();
extern void _ZN7S3262C64v127Ev();
extern void _ZN7S3262C64v128Ev();
extern void _ZN7S3262C64v129Ev();
extern void _ZN7S3262C64v130Ev();
extern void _ZN7S3262C64v131Ev();
extern void _ZN7S3262C64v132Ev();
static  VTBL_ENTRY vtc_S3262C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3262C2[0]),
  (VTBL_ENTRY)&_ZN7S3262C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3262C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v81Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v82Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v83Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v84Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v85Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v86Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v87Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v88Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v89Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v90Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v91Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v92Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v93Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v94Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v95Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v96Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v97Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v98Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v99Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v100Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v101Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v102Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v103Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v104Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v105Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v106Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v107Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v156Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3262C2[0]),
  (VTBL_ENTRY)&_ZN7S3262C54v108Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v109Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v110Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v111Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v112Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v113Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v114Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v115Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v116Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v117Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v118Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v119Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v120Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v121Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v122Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v123Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S3262C2[0]),
  (VTBL_ENTRY)&_ZN7S3262C64v124Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v125Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v126Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v127Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v128Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v129Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v130Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v131Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v132Ev,
};
extern VTBL_ENTRY _ZTI7S3262C2[];
extern  VTBL_ENTRY _ZTV7S3262C2[];
Class_Descriptor cd_S3262C2 = {  "S3262C2", // class name
  bases_S3262C2, 3,
  &(vtc_S3262C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S3262C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S3262C2),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C11_nt  {
  ::S79C44 s3262c11f0;
  char s3262c11f1;
  void  mf3262c11(); // _ZN11S3262C11_nt9mf3262c11Ev
};
//SIG(-1 S3262C11_nt) C1{ m FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fc}


void  S3262C11_nt ::mf3262c11(){}

//skip512 S3262C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C14_nt  {
  ::S79C40 s3262c14f0;
  void  mf3262c14(); // _ZN11S3262C14_nt9mf3262c14Ev
};
//SIG(-1 S3262C14_nt) C1{ m FC2{ BC3{ BC4{ m Fp Fi[2]}}}}


void  S3262C14_nt ::mf3262c14(){}

//skip512 S3262C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3262C1  : S3262C2 {
  ::S3262C11_nt s3262c1f0;
  ::S3262C11_nt s3262c1f1;
  ::S3262C14_nt s3262c1f2;
  ::S79C8_nt s3262c1f3;
  int s3262c1f4[2];
  unsigned int s3262c1f5:1;
  unsigned int s3262c1f6:1;
  unsigned int s3262c1f7:1;
  unsigned int s3262c1f8:1;
  unsigned int s3262c1f9:1;
  unsigned int s3262c1f10:1;
  char s3262c1f11;
  char s3262c1f12;
  virtual  ~S3262C1(); // _ZN7S3262C1D1Ev
  virtual void  v1(); // _ZN7S3262C12v1Ev
  virtual void  v2(); // _ZN7S3262C12v2Ev
  virtual void  v3(); // _ZN7S3262C12v3Ev
  virtual void  v4(); // _ZN7S3262C12v4Ev
  virtual void  v5(); // _ZN7S3262C12v5Ev
  virtual void  v6(); // _ZN7S3262C12v6Ev
  virtual void  v7(); // _ZN7S3262C12v7Ev
  virtual void  v8(); // _ZN7S3262C12v8Ev
  virtual void  v9(); // _ZN7S3262C12v9Ev
  virtual void  v10(); // _ZN7S3262C13v10Ev
  virtual void  v11(); // _ZN7S3262C13v11Ev
  virtual void  v12(); // _ZN7S3262C13v12Ev
  virtual void  v13(); // _ZN7S3262C13v13Ev
  virtual void  v14(); // _ZN7S3262C13v14Ev
  virtual void  v15(); // _ZN7S3262C13v15Ev
  virtual void  v16(); // _ZN7S3262C13v16Ev
  virtual void  v17(); // _ZN7S3262C13v17Ev
  virtual void  v18(); // _ZN7S3262C13v18Ev
  virtual void  v19(); // _ZN7S3262C13v19Ev
  virtual void  v20(); // _ZN7S3262C13v20Ev
  virtual void  v21(); // _ZN7S3262C13v21Ev
  virtual void  v22(); // _ZN7S3262C13v22Ev
  virtual void  v23(); // _ZN7S3262C13v23Ev
  virtual void  v24(); // _ZN7S3262C13v24Ev
  virtual void  v25(); // _ZN7S3262C13v25Ev
  virtual void  v26(); // _ZN7S3262C13v26Ev
  virtual void  v27(); // _ZN7S3262C13v27Ev
  virtual void  v28(); // _ZN7S3262C13v28Ev
  virtual void  v29(); // _ZN7S3262C13v29Ev
  virtual void  v30(); // _ZN7S3262C13v30Ev
  virtual void  v31(); // _ZN7S3262C13v31Ev
  virtual void  v32(); // _ZN7S3262C13v32Ev
  virtual void  v33(); // _ZN7S3262C13v33Ev
  virtual void  v34(); // _ZN7S3262C13v34Ev
  virtual void  v35(); // _ZN7S3262C13v35Ev
  virtual void  v36(); // _ZN7S3262C13v36Ev
  virtual void  v37(); // _ZN7S3262C13v37Ev
  virtual void  v38(); // _ZN7S3262C13v38Ev
  virtual void  v39(); // _ZN7S3262C13v39Ev
  virtual void  v40(); // _ZN7S3262C13v40Ev
  virtual void  v41(); // _ZN7S3262C13v41Ev
  virtual void  v42(); // _ZN7S3262C13v42Ev
  virtual void  v43(); // _ZN7S3262C13v43Ev
  S3262C1(); // tgen
};
//SIG(1 S3262C1) C1{ BC2{ BC3{ vd v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123} BC6{ v124 v125 v126 v127 v128 v129 v130 v131 v132} vd v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 FC11{ m FC12{ BC13{ BC10}} Fc} FC11 FC14{ m FC8} FC4 Fi[2] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc[2]}


 S3262C1 ::~S3262C1(){ note_dtor("S3262C1", this);}
void  S3262C1 ::v1(){vfunc_called(this, "_ZN7S3262C12v1Ev");}
void  S3262C1 ::v2(){vfunc_called(this, "_ZN7S3262C12v2Ev");}
void  S3262C1 ::v3(){vfunc_called(this, "_ZN7S3262C12v3Ev");}
void  S3262C1 ::v4(){vfunc_called(this, "_ZN7S3262C12v4Ev");}
void  S3262C1 ::v5(){vfunc_called(this, "_ZN7S3262C12v5Ev");}
void  S3262C1 ::v6(){vfunc_called(this, "_ZN7S3262C12v6Ev");}
void  S3262C1 ::v7(){vfunc_called(this, "_ZN7S3262C12v7Ev");}
void  S3262C1 ::v8(){vfunc_called(this, "_ZN7S3262C12v8Ev");}
void  S3262C1 ::v9(){vfunc_called(this, "_ZN7S3262C12v9Ev");}
void  S3262C1 ::v10(){vfunc_called(this, "_ZN7S3262C13v10Ev");}
void  S3262C1 ::v11(){vfunc_called(this, "_ZN7S3262C13v11Ev");}
void  S3262C1 ::v12(){vfunc_called(this, "_ZN7S3262C13v12Ev");}
void  S3262C1 ::v13(){vfunc_called(this, "_ZN7S3262C13v13Ev");}
void  S3262C1 ::v14(){vfunc_called(this, "_ZN7S3262C13v14Ev");}
void  S3262C1 ::v15(){vfunc_called(this, "_ZN7S3262C13v15Ev");}
void  S3262C1 ::v16(){vfunc_called(this, "_ZN7S3262C13v16Ev");}
void  S3262C1 ::v17(){vfunc_called(this, "_ZN7S3262C13v17Ev");}
void  S3262C1 ::v18(){vfunc_called(this, "_ZN7S3262C13v18Ev");}
void  S3262C1 ::v19(){vfunc_called(this, "_ZN7S3262C13v19Ev");}
void  S3262C1 ::v20(){vfunc_called(this, "_ZN7S3262C13v20Ev");}
void  S3262C1 ::v21(){vfunc_called(this, "_ZN7S3262C13v21Ev");}
void  S3262C1 ::v22(){vfunc_called(this, "_ZN7S3262C13v22Ev");}
void  S3262C1 ::v23(){vfunc_called(this, "_ZN7S3262C13v23Ev");}
void  S3262C1 ::v24(){vfunc_called(this, "_ZN7S3262C13v24Ev");}
void  S3262C1 ::v25(){vfunc_called(this, "_ZN7S3262C13v25Ev");}
void  S3262C1 ::v26(){vfunc_called(this, "_ZN7S3262C13v26Ev");}
void  S3262C1 ::v27(){vfunc_called(this, "_ZN7S3262C13v27Ev");}
void  S3262C1 ::v28(){vfunc_called(this, "_ZN7S3262C13v28Ev");}
void  S3262C1 ::v29(){vfunc_called(this, "_ZN7S3262C13v29Ev");}
void  S3262C1 ::v30(){vfunc_called(this, "_ZN7S3262C13v30Ev");}
void  S3262C1 ::v31(){vfunc_called(this, "_ZN7S3262C13v31Ev");}
void  S3262C1 ::v32(){vfunc_called(this, "_ZN7S3262C13v32Ev");}
void  S3262C1 ::v33(){vfunc_called(this, "_ZN7S3262C13v33Ev");}
void  S3262C1 ::v34(){vfunc_called(this, "_ZN7S3262C13v34Ev");}
void  S3262C1 ::v35(){vfunc_called(this, "_ZN7S3262C13v35Ev");}
void  S3262C1 ::v36(){vfunc_called(this, "_ZN7S3262C13v36Ev");}
void  S3262C1 ::v37(){vfunc_called(this, "_ZN7S3262C13v37Ev");}
void  S3262C1 ::v38(){vfunc_called(this, "_ZN7S3262C13v38Ev");}
void  S3262C1 ::v39(){vfunc_called(this, "_ZN7S3262C13v39Ev");}
void  S3262C1 ::v40(){vfunc_called(this, "_ZN7S3262C13v40Ev");}
void  S3262C1 ::v41(){vfunc_called(this, "_ZN7S3262C13v41Ev");}
void  S3262C1 ::v42(){vfunc_called(this, "_ZN7S3262C13v42Ev");}
void  S3262C1 ::v43(){vfunc_called(this, "_ZN7S3262C13v43Ev");}
S3262C1 ::S3262C1(){ note_ctor("S3262C1", this);} // tgen

static void Test_S3262C1()
{
  extern Class_Descriptor cd_S3262C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,39)];
    init_test(&cd_S3262C1, buf);
    S3262C1 *dp, &lv = *(dp=new (buf) S3262C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,152), "sizeof(S3262C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3262C1)");
    check_base_class_offset(lv, (S3262C3*)(S3262C2*), 0, "S3262C1");
    check_base_class_offset(lv, (S3262C5*)(S3262C2*), ABISELECT(96,60), "S3262C1");
    check_base_class_offset(lv, (S3262C6*)(S3262C2*), ABISELECT(104,64), "S3262C1");
    check_base_class_offset(lv, (S3262C2*), 0, "S3262C1");
    check_field_offset(lv, s3262c1f0, ABISELECT(144,88), "S3262C1.s3262c1f0");
    check_field_offset(lv, s3262c1f1, ABISELECT(168,104), "S3262C1.s3262c1f1");
    check_field_offset(lv, s3262c1f2, ABISELECT(192,120), "S3262C1.s3262c1f2");
    check_field_offset(lv, s3262c1f3, ABISELECT(208,132), "S3262C1.s3262c1f3");
    check_field_offset(lv, s3262c1f4, ABISELECT(216,140), "S3262C1.s3262c1f4");
    set_bf_and_test(lv, s3262c1f5, ABISELECT(224,148), 0, 1, 1, "S3262C1");
    set_bf_and_test(lv, s3262c1f6, ABISELECT(224,148), 1, 1, 1, "S3262C1");
    set_bf_and_test(lv, s3262c1f7, ABISELECT(224,148), 2, 1, 1, "S3262C1");
    set_bf_and_test(lv, s3262c1f8, ABISELECT(224,148), 3, 1, 1, "S3262C1");
    set_bf_and_test(lv, s3262c1f9, ABISELECT(224,148), 4, 1, 1, "S3262C1");
    set_bf_and_test(lv, s3262c1f10, ABISELECT(224,148), 5, 1, 1, "S3262C1");
    check_field_offset(lv, s3262c1f11, ABISELECT(225,149), "S3262C1.s3262c1f11");
    check_field_offset(lv, s3262c1f12, ABISELECT(226,150), "S3262C1.s3262c1f12");
    test_class_info(&lv, &cd_S3262C1);
    dp->~S3262C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3262C1(Test_S3262C1, "S3262C1", ABISELECT(232,152));

#else // __cplusplus

extern void _ZN7S3262C1C1Ev();
extern void _ZN7S3262C1D1Ev();
Name_Map name_map_S3262C1[] = {
  NSPAIR(_ZN7S3262C1C1Ev),
  NSPAIR(_ZN7S3262C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3262C3;
extern VTBL_ENTRY _ZTI7S3262C3[];
extern  VTBL_ENTRY _ZTV7S3262C3[];
extern Class_Descriptor cd_S3262C5;
extern VTBL_ENTRY _ZTI7S3262C5[];
extern  VTBL_ENTRY _ZTV7S3262C5[];
extern Class_Descriptor cd_S3262C6;
extern VTBL_ENTRY _ZTI7S3262C6[];
extern  VTBL_ENTRY _ZTV7S3262C6[];
extern Class_Descriptor cd_S3262C2;
extern VTBL_ENTRY _ZTI7S3262C2[];
extern  VTBL_ENTRY _ZTV7S3262C2[];
static Base_Class bases_S3262C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3262C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3262C5,    ABISELECT(96,60), //bcp->offset
    135, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3262C6,    ABISELECT(104,64), //bcp->offset
    153, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3262C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3262C1[];
extern void _ZN7S3262C1D1Ev();
extern void _ZN7S3262C1D0Ev();
extern void _ZN7S3262C33v44Ev();
extern void _ZN7S3262C33v45Ev();
extern void _ZN7S3262C33v46Ev();
extern void _ZN7S3262C33v47Ev();
extern void _ZN7S3262C33v48Ev();
extern void _ZN7S3262C33v49Ev();
extern void _ZN7S3262C33v50Ev();
extern void _ZN7S3262C33v51Ev();
extern void _ZN7S3262C33v52Ev();
extern void _ZN7S3262C33v53Ev();
extern void _ZN7S3262C33v54Ev();
extern void _ZN7S3262C33v55Ev();
extern void _ZN7S3262C33v56Ev();
extern void _ZN7S3262C33v57Ev();
extern void _ZN7S3262C33v58Ev();
extern void _ZN7S3262C33v59Ev();
extern void _ZN7S3262C33v60Ev();
extern void _ZN7S3262C33v61Ev();
extern void _ZN7S3262C33v62Ev();
extern void _ZN7S3262C33v63Ev();
extern void _ZN7S3262C33v64Ev();
extern void _ZN7S3262C33v65Ev();
extern void _ZN7S3262C33v66Ev();
extern void _ZN7S3262C33v67Ev();
extern void _ZN7S3262C33v68Ev();
extern void _ZN7S3262C33v69Ev();
extern void _ZN7S3262C33v70Ev();
extern void _ZN7S3262C33v71Ev();
extern void _ZN7S3262C33v72Ev();
extern void _ZN7S3262C33v73Ev();
extern void _ZN7S3262C33v74Ev();
extern void _ZN7S3262C33v75Ev();
extern void _ZN7S3262C33v76Ev();
extern void _ZN7S3262C33v77Ev();
extern void _ZN7S3262C33v78Ev();
extern void _ZN7S3262C33v79Ev();
extern void _ZN7S3262C33v80Ev();
extern void _ZN7S3262C33v81Ev();
extern void _ZN7S3262C33v82Ev();
extern void _ZN7S3262C33v83Ev();
extern void _ZN7S3262C33v84Ev();
extern void _ZN7S3262C33v85Ev();
extern void _ZN7S3262C33v86Ev();
extern void _ZN7S3262C33v87Ev();
extern void _ZN7S3262C33v88Ev();
extern void _ZN7S3262C33v89Ev();
extern void _ZN7S3262C33v90Ev();
extern void _ZN7S3262C33v91Ev();
extern void _ZN7S3262C33v92Ev();
extern void _ZN7S3262C33v93Ev();
extern void _ZN7S3262C33v94Ev();
extern void _ZN7S3262C33v95Ev();
extern void _ZN7S3262C33v96Ev();
extern void _ZN7S3262C33v97Ev();
extern void _ZN7S3262C33v98Ev();
extern void _ZN7S3262C33v99Ev();
extern void _ZN7S3262C34v100Ev();
extern void _ZN7S3262C34v101Ev();
extern void _ZN7S3262C34v102Ev();
extern void _ZN7S3262C34v103Ev();
extern void _ZN7S3262C34v104Ev();
extern void _ZN7S3262C34v105Ev();
extern void _ZN7S3262C34v106Ev();
extern void _ZN7S3262C34v107Ev();
extern void _ZN7S3262C24v133Ev();
extern void _ZN7S3262C24v134Ev();
extern void _ZN7S3262C24v135Ev();
extern void _ZN7S3262C24v136Ev();
extern void _ZN7S3262C24v137Ev();
extern void _ZN7S3262C24v138Ev();
extern void _ZN7S3262C24v139Ev();
extern void _ZN7S3262C24v140Ev();
extern void _ZN7S3262C24v141Ev();
extern void _ZN7S3262C24v142Ev();
extern void _ZN7S3262C24v143Ev();
extern void _ZN7S3262C24v144Ev();
extern void _ZN7S3262C24v145Ev();
extern void _ZN7S3262C24v146Ev();
extern void _ZN7S3262C24v147Ev();
extern void _ZN7S3262C24v148Ev();
extern void _ZN7S3262C24v149Ev();
extern void _ZN7S3262C24v150Ev();
extern void _ZN7S3262C24v151Ev();
extern void _ZN7S3262C24v152Ev();
extern void _ZN7S3262C24v153Ev();
extern void _ZN7S3262C24v154Ev();
extern void _ZN7S3262C24v155Ev();
extern void _ZN7S3262C24v156Ev();
extern void _ZN7S3262C12v1Ev();
extern void _ZN7S3262C12v2Ev();
extern void _ZN7S3262C12v3Ev();
extern void _ZN7S3262C12v4Ev();
extern void _ZN7S3262C12v5Ev();
extern void _ZN7S3262C12v6Ev();
extern void _ZN7S3262C12v7Ev();
extern void _ZN7S3262C12v8Ev();
extern void _ZN7S3262C12v9Ev();
extern void _ZN7S3262C13v10Ev();
extern void _ZN7S3262C13v11Ev();
extern void _ZN7S3262C13v12Ev();
extern void _ZN7S3262C13v13Ev();
extern void _ZN7S3262C13v14Ev();
extern void _ZN7S3262C13v15Ev();
extern void _ZN7S3262C13v16Ev();
extern void _ZN7S3262C13v17Ev();
extern void _ZN7S3262C13v18Ev();
extern void _ZN7S3262C13v19Ev();
extern void _ZN7S3262C13v20Ev();
extern void _ZN7S3262C13v21Ev();
extern void _ZN7S3262C13v22Ev();
extern void _ZN7S3262C13v23Ev();
extern void _ZN7S3262C13v24Ev();
extern void _ZN7S3262C13v25Ev();
extern void _ZN7S3262C13v26Ev();
extern void _ZN7S3262C13v27Ev();
extern void _ZN7S3262C13v28Ev();
extern void _ZN7S3262C13v29Ev();
extern void _ZN7S3262C13v30Ev();
extern void _ZN7S3262C13v31Ev();
extern void _ZN7S3262C13v32Ev();
extern void _ZN7S3262C13v33Ev();
extern void _ZN7S3262C13v34Ev();
extern void _ZN7S3262C13v35Ev();
extern void _ZN7S3262C13v36Ev();
extern void _ZN7S3262C13v37Ev();
extern void _ZN7S3262C13v38Ev();
extern void _ZN7S3262C13v39Ev();
extern void _ZN7S3262C13v40Ev();
extern void _ZN7S3262C13v41Ev();
extern void _ZN7S3262C13v42Ev();
extern void _ZN7S3262C13v43Ev();
extern void _ZN7S3262C54v108Ev();
extern void _ZN7S3262C54v109Ev();
extern void _ZN7S3262C54v110Ev();
extern void _ZN7S3262C54v111Ev();
extern void _ZN7S3262C54v112Ev();
extern void _ZN7S3262C54v113Ev();
extern void _ZN7S3262C54v114Ev();
extern void _ZN7S3262C54v115Ev();
extern void _ZN7S3262C54v116Ev();
extern void _ZN7S3262C54v117Ev();
extern void _ZN7S3262C54v118Ev();
extern void _ZN7S3262C54v119Ev();
extern void _ZN7S3262C54v120Ev();
extern void _ZN7S3262C54v121Ev();
extern void _ZN7S3262C54v122Ev();
extern void _ZN7S3262C54v123Ev();
extern void _ZN7S3262C64v124Ev();
extern void _ZN7S3262C64v125Ev();
extern void _ZN7S3262C64v126Ev();
extern void _ZN7S3262C64v127Ev();
extern void _ZN7S3262C64v128Ev();
extern void _ZN7S3262C64v129Ev();
extern void _ZN7S3262C64v130Ev();
extern void _ZN7S3262C64v131Ev();
extern void _ZN7S3262C64v132Ev();
static  VTBL_ENTRY vtc_S3262C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3262C1[0]),
  (VTBL_ENTRY)&_ZN7S3262C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3262C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v81Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v82Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v83Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v84Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v85Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v86Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v87Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v88Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v89Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v90Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v91Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v92Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v93Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v94Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v95Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v96Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v97Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v98Ev,
  (VTBL_ENTRY)&_ZN7S3262C33v99Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v100Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v101Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v102Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v103Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v104Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v105Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v106Ev,
  (VTBL_ENTRY)&_ZN7S3262C34v107Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v133Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v134Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v135Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v136Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v137Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v138Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v139Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v140Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v141Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v142Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v143Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v144Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v145Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v146Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v147Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v148Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v149Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v150Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v151Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v152Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v153Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v154Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v155Ev,
  (VTBL_ENTRY)&_ZN7S3262C24v156Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3262C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v16Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v17Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v18Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v19Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v20Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v21Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v22Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v23Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v24Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v25Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v26Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v27Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v28Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v29Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v30Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v31Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v32Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v33Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v34Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v35Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v36Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v37Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v38Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v39Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v40Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v41Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v42Ev,
  (VTBL_ENTRY)&_ZN7S3262C13v43Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3262C1[0]),
  (VTBL_ENTRY)&_ZN7S3262C54v108Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v109Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v110Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v111Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v112Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v113Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v114Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v115Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v116Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v117Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v118Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v119Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v120Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v121Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v122Ev,
  (VTBL_ENTRY)&_ZN7S3262C54v123Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S3262C1[0]),
  (VTBL_ENTRY)&_ZN7S3262C64v124Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v125Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v126Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v127Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v128Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v129Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v130Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v131Ev,
  (VTBL_ENTRY)&_ZN7S3262C64v132Ev,
};
extern VTBL_ENTRY _ZTI7S3262C1[];
extern  VTBL_ENTRY _ZTV7S3262C1[];
Class_Descriptor cd_S3262C1 = {  "S3262C1", // class name
  bases_S3262C1, 4,
  &(vtc_S3262C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,152), // object size
  NSPAIRA(_ZTI7S3262C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3262C1),164, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C4  {
  int s1350c4f0;
  __tsi64 s1350c4f1;
  void *s1350c4f2[4];
  int s1350c4f3[2];
  void *s1350c4f4;
  ::S79C8_nt s1350c4f5;
  void *s1350c4f6[2];
  virtual  ~S1350C4(); // _ZN7S1350C4D1Ev
  virtual void  v22(); // _ZN7S1350C43v22Ev
  virtual void  v23(); // _ZN7S1350C43v23Ev
  virtual void  v24(); // _ZN7S1350C43v24Ev
  virtual void  v25(); // _ZN7S1350C43v25Ev
  virtual void  v26(); // _ZN7S1350C43v26Ev
  virtual void  v27(); // _ZN7S1350C43v27Ev
  virtual void  v28(); // _ZN7S1350C43v28Ev
  virtual void  v29(); // _ZN7S1350C43v29Ev
  virtual void  v30(); // _ZN7S1350C43v30Ev
  virtual void  v31(); // _ZN7S1350C43v31Ev
  virtual void  v32(); // _ZN7S1350C43v32Ev
  virtual void  v33(); // _ZN7S1350C43v33Ev
  virtual void  v34(); // _ZN7S1350C43v34Ev
  virtual void  v35(); // _ZN7S1350C43v35Ev
  virtual void  v36(); // _ZN7S1350C43v36Ev
  virtual void  v37(); // _ZN7S1350C43v37Ev
  virtual void  v38(); // _ZN7S1350C43v38Ev
  virtual void  v39(); // _ZN7S1350C43v39Ev
  virtual void  v40(); // _ZN7S1350C43v40Ev
  virtual void  v41(); // _ZN7S1350C43v41Ev
  virtual void  v42(); // _ZN7S1350C43v42Ev
  virtual void  v43(); // _ZN7S1350C43v43Ev
  virtual void  v44(); // _ZN7S1350C43v44Ev
  virtual void  v45(); // _ZN7S1350C43v45Ev
  virtual void  v46(); // _ZN7S1350C43v46Ev
  virtual void  v47(); // _ZN7S1350C43v47Ev
  virtual void  v48(); // _ZN7S1350C43v48Ev
  virtual void  v49(); // _ZN7S1350C43v49Ev
  virtual void  v50(); // _ZN7S1350C43v50Ev
  virtual void  v51(); // _ZN7S1350C43v51Ev
  virtual void  v52(); // _ZN7S1350C43v52Ev
  virtual void  v53(); // _ZN7S1350C43v53Ev
  virtual void  v54(); // _ZN7S1350C43v54Ev
  virtual void  v55(); // _ZN7S1350C43v55Ev
  virtual void  v56(); // _ZN7S1350C43v56Ev
  virtual void  v57(); // _ZN7S1350C43v57Ev
  virtual void  v58(); // _ZN7S1350C43v58Ev
  virtual void  v59(); // _ZN7S1350C43v59Ev
  virtual void  v60(); // _ZN7S1350C43v60Ev
  virtual void  v61(); // _ZN7S1350C43v61Ev
  virtual void  v62(); // _ZN7S1350C43v62Ev
  virtual void  v63(); // _ZN7S1350C43v63Ev
  virtual void  v64(); // _ZN7S1350C43v64Ev
  virtual void  v65(); // _ZN7S1350C43v65Ev
  virtual void  v66(); // _ZN7S1350C43v66Ev
  virtual void  v67(); // _ZN7S1350C43v67Ev
  virtual void  v68(); // _ZN7S1350C43v68Ev
  virtual void  v69(); // _ZN7S1350C43v69Ev
  virtual void  v70(); // _ZN7S1350C43v70Ev
  virtual void  v71(); // _ZN7S1350C43v71Ev
  virtual void  v72(); // _ZN7S1350C43v72Ev
  virtual void  v73(); // _ZN7S1350C43v73Ev
  virtual void  v74(); // _ZN7S1350C43v74Ev
  virtual void  v75(); // _ZN7S1350C43v75Ev
  virtual void  v76(); // _ZN7S1350C43v76Ev
  virtual void  v77(); // _ZN7S1350C43v77Ev
  virtual void  v78(); // _ZN7S1350C43v78Ev
  virtual void  v79(); // _ZN7S1350C43v79Ev
  virtual void  v80(); // _ZN7S1350C43v80Ev
  virtual void  v81(); // _ZN7S1350C43v81Ev
  virtual void  v82(); // _ZN7S1350C43v82Ev
  virtual void  v83(); // _ZN7S1350C43v83Ev
  virtual void  v84(); // _ZN7S1350C43v84Ev
  virtual void  v85(); // _ZN7S1350C43v85Ev
  S1350C4(); // tgen
};
//SIG(-1 S1350C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1350C4 ::~S1350C4(){ note_dtor("S1350C4", this);}
void  S1350C4 ::v22(){vfunc_called(this, "_ZN7S1350C43v22Ev");}
void  S1350C4 ::v23(){vfunc_called(this, "_ZN7S1350C43v23Ev");}
void  S1350C4 ::v24(){vfunc_called(this, "_ZN7S1350C43v24Ev");}
void  S1350C4 ::v25(){vfunc_called(this, "_ZN7S1350C43v25Ev");}
void  S1350C4 ::v26(){vfunc_called(this, "_ZN7S1350C43v26Ev");}
void  S1350C4 ::v27(){vfunc_called(this, "_ZN7S1350C43v27Ev");}
void  S1350C4 ::v28(){vfunc_called(this, "_ZN7S1350C43v28Ev");}
void  S1350C4 ::v29(){vfunc_called(this, "_ZN7S1350C43v29Ev");}
void  S1350C4 ::v30(){vfunc_called(this, "_ZN7S1350C43v30Ev");}
void  S1350C4 ::v31(){vfunc_called(this, "_ZN7S1350C43v31Ev");}
void  S1350C4 ::v32(){vfunc_called(this, "_ZN7S1350C43v32Ev");}
void  S1350C4 ::v33(){vfunc_called(this, "_ZN7S1350C43v33Ev");}
void  S1350C4 ::v34(){vfunc_called(this, "_ZN7S1350C43v34Ev");}
void  S1350C4 ::v35(){vfunc_called(this, "_ZN7S1350C43v35Ev");}
void  S1350C4 ::v36(){vfunc_called(this, "_ZN7S1350C43v36Ev");}
void  S1350C4 ::v37(){vfunc_called(this, "_ZN7S1350C43v37Ev");}
void  S1350C4 ::v38(){vfunc_called(this, "_ZN7S1350C43v38Ev");}
void  S1350C4 ::v39(){vfunc_called(this, "_ZN7S1350C43v39Ev");}
void  S1350C4 ::v40(){vfunc_called(this, "_ZN7S1350C43v40Ev");}
void  S1350C4 ::v41(){vfunc_called(this, "_ZN7S1350C43v41Ev");}
void  S1350C4 ::v42(){vfunc_called(this, "_ZN7S1350C43v42Ev");}
void  S1350C4 ::v43(){vfunc_called(this, "_ZN7S1350C43v43Ev");}
void  S1350C4 ::v44(){vfunc_called(this, "_ZN7S1350C43v44Ev");}
void  S1350C4 ::v45(){vfunc_called(this, "_ZN7S1350C43v45Ev");}
void  S1350C4 ::v46(){vfunc_called(this, "_ZN7S1350C43v46Ev");}
void  S1350C4 ::v47(){vfunc_called(this, "_ZN7S1350C43v47Ev");}
void  S1350C4 ::v48(){vfunc_called(this, "_ZN7S1350C43v48Ev");}
void  S1350C4 ::v49(){vfunc_called(this, "_ZN7S1350C43v49Ev");}
void  S1350C4 ::v50(){vfunc_called(this, "_ZN7S1350C43v50Ev");}
void  S1350C4 ::v51(){vfunc_called(this, "_ZN7S1350C43v51Ev");}
void  S1350C4 ::v52(){vfunc_called(this, "_ZN7S1350C43v52Ev");}
void  S1350C4 ::v53(){vfunc_called(this, "_ZN7S1350C43v53Ev");}
void  S1350C4 ::v54(){vfunc_called(this, "_ZN7S1350C43v54Ev");}
void  S1350C4 ::v55(){vfunc_called(this, "_ZN7S1350C43v55Ev");}
void  S1350C4 ::v56(){vfunc_called(this, "_ZN7S1350C43v56Ev");}
void  S1350C4 ::v57(){vfunc_called(this, "_ZN7S1350C43v57Ev");}
void  S1350C4 ::v58(){vfunc_called(this, "_ZN7S1350C43v58Ev");}
void  S1350C4 ::v59(){vfunc_called(this, "_ZN7S1350C43v59Ev");}
void  S1350C4 ::v60(){vfunc_called(this, "_ZN7S1350C43v60Ev");}
void  S1350C4 ::v61(){vfunc_called(this, "_ZN7S1350C43v61Ev");}
void  S1350C4 ::v62(){vfunc_called(this, "_ZN7S1350C43v62Ev");}
void  S1350C4 ::v63(){vfunc_called(this, "_ZN7S1350C43v63Ev");}
void  S1350C4 ::v64(){vfunc_called(this, "_ZN7S1350C43v64Ev");}
void  S1350C4 ::v65(){vfunc_called(this, "_ZN7S1350C43v65Ev");}
void  S1350C4 ::v66(){vfunc_called(this, "_ZN7S1350C43v66Ev");}
void  S1350C4 ::v67(){vfunc_called(this, "_ZN7S1350C43v67Ev");}
void  S1350C4 ::v68(){vfunc_called(this, "_ZN7S1350C43v68Ev");}
void  S1350C4 ::v69(){vfunc_called(this, "_ZN7S1350C43v69Ev");}
void  S1350C4 ::v70(){vfunc_called(this, "_ZN7S1350C43v70Ev");}
void  S1350C4 ::v71(){vfunc_called(this, "_ZN7S1350C43v71Ev");}
void  S1350C4 ::v72(){vfunc_called(this, "_ZN7S1350C43v72Ev");}
void  S1350C4 ::v73(){vfunc_called(this, "_ZN7S1350C43v73Ev");}
void  S1350C4 ::v74(){vfunc_called(this, "_ZN7S1350C43v74Ev");}
void  S1350C4 ::v75(){vfunc_called(this, "_ZN7S1350C43v75Ev");}
void  S1350C4 ::v76(){vfunc_called(this, "_ZN7S1350C43v76Ev");}
void  S1350C4 ::v77(){vfunc_called(this, "_ZN7S1350C43v77Ev");}
void  S1350C4 ::v78(){vfunc_called(this, "_ZN7S1350C43v78Ev");}
void  S1350C4 ::v79(){vfunc_called(this, "_ZN7S1350C43v79Ev");}
void  S1350C4 ::v80(){vfunc_called(this, "_ZN7S1350C43v80Ev");}
void  S1350C4 ::v81(){vfunc_called(this, "_ZN7S1350C43v81Ev");}
void  S1350C4 ::v82(){vfunc_called(this, "_ZN7S1350C43v82Ev");}
void  S1350C4 ::v83(){vfunc_called(this, "_ZN7S1350C43v83Ev");}
void  S1350C4 ::v84(){vfunc_called(this, "_ZN7S1350C43v84Ev");}
void  S1350C4 ::v85(){vfunc_called(this, "_ZN7S1350C43v85Ev");}
S1350C4 ::S1350C4(){ note_ctor("S1350C4", this);} // tgen

static void Test_S1350C4()
{
  extern Class_Descriptor cd_S1350C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1350C4, buf);
    S1350C4 *dp, &lv = *(dp=new (buf) S1350C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1350C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C4)");
    check_field_offset(lv, s1350c4f0, ABISELECT(8,4), "S1350C4.s1350c4f0");
    check_field_offset(lv, s1350c4f1, ABISELECT(16,8), "S1350C4.s1350c4f1");
    check_field_offset(lv, s1350c4f2, ABISELECT(24,16), "S1350C4.s1350c4f2");
    check_field_offset(lv, s1350c4f3, ABISELECT(56,32), "S1350C4.s1350c4f3");
    check_field_offset(lv, s1350c4f4, ABISELECT(64,40), "S1350C4.s1350c4f4");
    check_field_offset(lv, s1350c4f5, ABISELECT(72,44), "S1350C4.s1350c4f5");
    check_field_offset(lv, s1350c4f6, ABISELECT(80,52), "S1350C4.s1350c4f6");
    test_class_info(&lv, &cd_S1350C4);
    dp->~S1350C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C4(Test_S1350C4, "S1350C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1350C4C1Ev();
extern void _ZN7S1350C4D1Ev();
Name_Map name_map_S1350C4[] = {
  NSPAIR(_ZN7S1350C4C1Ev),
  NSPAIR(_ZN7S1350C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1350C4[];
extern void _ZN7S1350C4D1Ev();
extern void _ZN7S1350C4D0Ev();
extern void _ZN7S1350C43v22Ev();
extern void _ZN7S1350C43v23Ev();
extern void _ZN7S1350C43v24Ev();
extern void _ZN7S1350C43v25Ev();
extern void _ZN7S1350C43v26Ev();
extern void _ZN7S1350C43v27Ev();
extern void _ZN7S1350C43v28Ev();
extern void _ZN7S1350C43v29Ev();
extern void _ZN7S1350C43v30Ev();
extern void _ZN7S1350C43v31Ev();
extern void _ZN7S1350C43v32Ev();
extern void _ZN7S1350C43v33Ev();
extern void _ZN7S1350C43v34Ev();
extern void _ZN7S1350C43v35Ev();
extern void _ZN7S1350C43v36Ev();
extern void _ZN7S1350C43v37Ev();
extern void _ZN7S1350C43v38Ev();
extern void _ZN7S1350C43v39Ev();
extern void _ZN7S1350C43v40Ev();
extern void _ZN7S1350C43v41Ev();
extern void _ZN7S1350C43v42Ev();
extern void _ZN7S1350C43v43Ev();
extern void _ZN7S1350C43v44Ev();
extern void _ZN7S1350C43v45Ev();
extern void _ZN7S1350C43v46Ev();
extern void _ZN7S1350C43v47Ev();
extern void _ZN7S1350C43v48Ev();
extern void _ZN7S1350C43v49Ev();
extern void _ZN7S1350C43v50Ev();
extern void _ZN7S1350C43v51Ev();
extern void _ZN7S1350C43v52Ev();
extern void _ZN7S1350C43v53Ev();
extern void _ZN7S1350C43v54Ev();
extern void _ZN7S1350C43v55Ev();
extern void _ZN7S1350C43v56Ev();
extern void _ZN7S1350C43v57Ev();
extern void _ZN7S1350C43v58Ev();
extern void _ZN7S1350C43v59Ev();
extern void _ZN7S1350C43v60Ev();
extern void _ZN7S1350C43v61Ev();
extern void _ZN7S1350C43v62Ev();
extern void _ZN7S1350C43v63Ev();
extern void _ZN7S1350C43v64Ev();
extern void _ZN7S1350C43v65Ev();
extern void _ZN7S1350C43v66Ev();
extern void _ZN7S1350C43v67Ev();
extern void _ZN7S1350C43v68Ev();
extern void _ZN7S1350C43v69Ev();
extern void _ZN7S1350C43v70Ev();
extern void _ZN7S1350C43v71Ev();
extern void _ZN7S1350C43v72Ev();
extern void _ZN7S1350C43v73Ev();
extern void _ZN7S1350C43v74Ev();
extern void _ZN7S1350C43v75Ev();
extern void _ZN7S1350C43v76Ev();
extern void _ZN7S1350C43v77Ev();
extern void _ZN7S1350C43v78Ev();
extern void _ZN7S1350C43v79Ev();
extern void _ZN7S1350C43v80Ev();
extern void _ZN7S1350C43v81Ev();
extern void _ZN7S1350C43v82Ev();
extern void _ZN7S1350C43v83Ev();
extern void _ZN7S1350C43v84Ev();
extern void _ZN7S1350C43v85Ev();
static  VTBL_ENTRY vtc_S1350C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C4[0]),
  (VTBL_ENTRY)&_ZN7S1350C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1350C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v84Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v85Ev,
};
extern VTBL_ENTRY _ZTI7S1350C4[];
extern  VTBL_ENTRY _ZTV7S1350C4[];
Class_Descriptor cd_S1350C4 = {  "S1350C4", // class name
  0,0,//no base classes
  &(vtc_S1350C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1350C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1350C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C6  {
  virtual void  v86(); // _ZN7S1350C63v86Ev
  virtual void  v87(); // _ZN7S1350C63v87Ev
  virtual void  v88(); // _ZN7S1350C63v88Ev
  virtual void  v89(); // _ZN7S1350C63v89Ev
  virtual void  v90(); // _ZN7S1350C63v90Ev
  virtual void  v91(); // _ZN7S1350C63v91Ev
  virtual void  v92(); // _ZN7S1350C63v92Ev
  virtual void  v93(); // _ZN7S1350C63v93Ev
  virtual void  v94(); // _ZN7S1350C63v94Ev
  virtual void  v95(); // _ZN7S1350C63v95Ev
  virtual void  v96(); // _ZN7S1350C63v96Ev
  virtual void  v97(); // _ZN7S1350C63v97Ev
  virtual void  v98(); // _ZN7S1350C63v98Ev
  virtual void  v99(); // _ZN7S1350C63v99Ev
  virtual void  v100(); // _ZN7S1350C64v100Ev
  virtual void  v101(); // _ZN7S1350C64v101Ev
  ~S1350C6(); // tgen
  S1350C6(); // tgen
};
//SIG(-1 S1350C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1350C6 ::v86(){vfunc_called(this, "_ZN7S1350C63v86Ev");}
void  S1350C6 ::v87(){vfunc_called(this, "_ZN7S1350C63v87Ev");}
void  S1350C6 ::v88(){vfunc_called(this, "_ZN7S1350C63v88Ev");}
void  S1350C6 ::v89(){vfunc_called(this, "_ZN7S1350C63v89Ev");}
void  S1350C6 ::v90(){vfunc_called(this, "_ZN7S1350C63v90Ev");}
void  S1350C6 ::v91(){vfunc_called(this, "_ZN7S1350C63v91Ev");}
void  S1350C6 ::v92(){vfunc_called(this, "_ZN7S1350C63v92Ev");}
void  S1350C6 ::v93(){vfunc_called(this, "_ZN7S1350C63v93Ev");}
void  S1350C6 ::v94(){vfunc_called(this, "_ZN7S1350C63v94Ev");}
void  S1350C6 ::v95(){vfunc_called(this, "_ZN7S1350C63v95Ev");}
void  S1350C6 ::v96(){vfunc_called(this, "_ZN7S1350C63v96Ev");}
void  S1350C6 ::v97(){vfunc_called(this, "_ZN7S1350C63v97Ev");}
void  S1350C6 ::v98(){vfunc_called(this, "_ZN7S1350C63v98Ev");}
void  S1350C6 ::v99(){vfunc_called(this, "_ZN7S1350C63v99Ev");}
void  S1350C6 ::v100(){vfunc_called(this, "_ZN7S1350C64v100Ev");}
void  S1350C6 ::v101(){vfunc_called(this, "_ZN7S1350C64v101Ev");}
S1350C6 ::~S1350C6(){ note_dtor("S1350C6", this);} // tgen
S1350C6 ::S1350C6(){ note_ctor("S1350C6", this);} // tgen

static void Test_S1350C6()
{
  extern Class_Descriptor cd_S1350C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1350C6, buf);
    S1350C6 *dp, &lv = *(dp=new (buf) S1350C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1350C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C6)");
    test_class_info(&lv, &cd_S1350C6);
    dp->~S1350C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C6(Test_S1350C6, "S1350C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1350C6C1Ev();
extern void _ZN7S1350C6D1Ev();
Name_Map name_map_S1350C6[] = {
  NSPAIR(_ZN7S1350C6C1Ev),
  NSPAIR(_ZN7S1350C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1350C6[];
extern void _ZN7S1350C63v86Ev();
extern void _ZN7S1350C63v87Ev();
extern void _ZN7S1350C63v88Ev();
extern void _ZN7S1350C63v89Ev();
extern void _ZN7S1350C63v90Ev();
extern void _ZN7S1350C63v91Ev();
extern void _ZN7S1350C63v92Ev();
extern void _ZN7S1350C63v93Ev();
extern void _ZN7S1350C63v94Ev();
extern void _ZN7S1350C63v95Ev();
extern void _ZN7S1350C63v96Ev();
extern void _ZN7S1350C63v97Ev();
extern void _ZN7S1350C63v98Ev();
extern void _ZN7S1350C63v99Ev();
extern void _ZN7S1350C64v100Ev();
extern void _ZN7S1350C64v101Ev();
static  VTBL_ENTRY vtc_S1350C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C6[0]),
  (VTBL_ENTRY)&_ZN7S1350C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v99Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v100Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v101Ev,
};
extern VTBL_ENTRY _ZTI7S1350C6[];
extern  VTBL_ENTRY _ZTV7S1350C6[];
Class_Descriptor cd_S1350C6 = {  "S1350C6", // class name
  0,0,//no base classes
  &(vtc_S1350C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1350C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1350C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C7  {
  virtual void  v102(); // _ZN7S1350C74v102Ev
  virtual void  v103(); // _ZN7S1350C74v103Ev
  virtual void  v104(); // _ZN7S1350C74v104Ev
  virtual void  v105(); // _ZN7S1350C74v105Ev
  virtual void  v106(); // _ZN7S1350C74v106Ev
  virtual void  v107(); // _ZN7S1350C74v107Ev
  virtual void  v108(); // _ZN7S1350C74v108Ev
  virtual void  v109(); // _ZN7S1350C74v109Ev
  virtual void  v110(); // _ZN7S1350C74v110Ev
  ~S1350C7(); // tgen
  S1350C7(); // tgen
};
//SIG(-1 S1350C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1350C7 ::v102(){vfunc_called(this, "_ZN7S1350C74v102Ev");}
void  S1350C7 ::v103(){vfunc_called(this, "_ZN7S1350C74v103Ev");}
void  S1350C7 ::v104(){vfunc_called(this, "_ZN7S1350C74v104Ev");}
void  S1350C7 ::v105(){vfunc_called(this, "_ZN7S1350C74v105Ev");}
void  S1350C7 ::v106(){vfunc_called(this, "_ZN7S1350C74v106Ev");}
void  S1350C7 ::v107(){vfunc_called(this, "_ZN7S1350C74v107Ev");}
void  S1350C7 ::v108(){vfunc_called(this, "_ZN7S1350C74v108Ev");}
void  S1350C7 ::v109(){vfunc_called(this, "_ZN7S1350C74v109Ev");}
void  S1350C7 ::v110(){vfunc_called(this, "_ZN7S1350C74v110Ev");}
S1350C7 ::~S1350C7(){ note_dtor("S1350C7", this);} // tgen
S1350C7 ::S1350C7(){ note_ctor("S1350C7", this);} // tgen

static void Test_S1350C7()
{
  extern Class_Descriptor cd_S1350C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1350C7, buf);
    S1350C7 *dp, &lv = *(dp=new (buf) S1350C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1350C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C7)");
    test_class_info(&lv, &cd_S1350C7);
    dp->~S1350C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C7(Test_S1350C7, "S1350C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1350C7C1Ev();
extern void _ZN7S1350C7D1Ev();
Name_Map name_map_S1350C7[] = {
  NSPAIR(_ZN7S1350C7C1Ev),
  NSPAIR(_ZN7S1350C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1350C7[];
extern void _ZN7S1350C74v102Ev();
extern void _ZN7S1350C74v103Ev();
extern void _ZN7S1350C74v104Ev();
extern void _ZN7S1350C74v105Ev();
extern void _ZN7S1350C74v106Ev();
extern void _ZN7S1350C74v107Ev();
extern void _ZN7S1350C74v108Ev();
extern void _ZN7S1350C74v109Ev();
extern void _ZN7S1350C74v110Ev();
static  VTBL_ENTRY vtc_S1350C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C7[0]),
  (VTBL_ENTRY)&_ZN7S1350C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v108Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v109Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v110Ev,
};
extern VTBL_ENTRY _ZTI7S1350C7[];
extern  VTBL_ENTRY _ZTV7S1350C7[];
Class_Descriptor cd_S1350C7 = {  "S1350C7", // class name
  0,0,//no base classes
  &(vtc_S1350C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1350C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1350C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C3  : S1350C4 , S1350C6 , S1350C7 {
  void *s1350c3f0;
  ::S79C39_nt s1350c3f1;
  unsigned int s1350c3f2:1;
  unsigned int s1350c3f3:1;
  unsigned int s1350c3f4:1;
  unsigned int s1350c3f5:1;
  virtual  ~S1350C3(); // _ZN7S1350C3D1Ev
  virtual void  v111(); // _ZN7S1350C34v111Ev
  virtual void  v112(); // _ZN7S1350C34v112Ev
  virtual void  v113(); // _ZN7S1350C34v113Ev
  virtual void  v114(); // _ZN7S1350C34v114Ev
  virtual void  v115(); // _ZN7S1350C34v115Ev
  virtual void  v116(); // _ZN7S1350C34v116Ev
  virtual void  v117(); // _ZN7S1350C34v117Ev
  virtual void  v118(); // _ZN7S1350C34v118Ev
  virtual void  v119(); // _ZN7S1350C34v119Ev
  virtual void  v120(); // _ZN7S1350C34v120Ev
  virtual void  v121(); // _ZN7S1350C34v121Ev
  virtual void  v122(); // _ZN7S1350C34v122Ev
  virtual void  v123(); // _ZN7S1350C34v123Ev
  virtual void  v124(); // _ZN7S1350C34v124Ev
  virtual void  v125(); // _ZN7S1350C34v125Ev
  virtual void  v126(); // _ZN7S1350C34v126Ev
  virtual void  v127(); // _ZN7S1350C34v127Ev
  virtual void  v128(); // _ZN7S1350C34v128Ev
  virtual void  v129(); // _ZN7S1350C34v129Ev
  virtual void  v130(); // _ZN7S1350C34v130Ev
  virtual void  v131(); // _ZN7S1350C34v131Ev
  virtual void  v132(); // _ZN7S1350C34v132Ev
  virtual void  v133(); // _ZN7S1350C34v133Ev
  virtual void  v134(); // _ZN7S1350C34v134Ev
  S1350C3(); // tgen
};
//SIG(-1 S1350C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1350C3 ::~S1350C3(){ note_dtor("S1350C3", this);}
void  S1350C3 ::v111(){vfunc_called(this, "_ZN7S1350C34v111Ev");}
void  S1350C3 ::v112(){vfunc_called(this, "_ZN7S1350C34v112Ev");}
void  S1350C3 ::v113(){vfunc_called(this, "_ZN7S1350C34v113Ev");}
void  S1350C3 ::v114(){vfunc_called(this, "_ZN7S1350C34v114Ev");}
void  S1350C3 ::v115(){vfunc_called(this, "_ZN7S1350C34v115Ev");}
void  S1350C3 ::v116(){vfunc_called(this, "_ZN7S1350C34v116Ev");}
void  S1350C3 ::v117(){vfunc_called(this, "_ZN7S1350C34v117Ev");}
void  S1350C3 ::v118(){vfunc_called(this, "_ZN7S1350C34v118Ev");}
void  S1350C3 ::v119(){vfunc_called(this, "_ZN7S1350C34v119Ev");}
void  S1350C3 ::v120(){vfunc_called(this, "_ZN7S1350C34v120Ev");}
void  S1350C3 ::v121(){vfunc_called(this, "_ZN7S1350C34v121Ev");}
void  S1350C3 ::v122(){vfunc_called(this, "_ZN7S1350C34v122Ev");}
void  S1350C3 ::v123(){vfunc_called(this, "_ZN7S1350C34v123Ev");}
void  S1350C3 ::v124(){vfunc_called(this, "_ZN7S1350C34v124Ev");}
void  S1350C3 ::v125(){vfunc_called(this, "_ZN7S1350C34v125Ev");}
void  S1350C3 ::v126(){vfunc_called(this, "_ZN7S1350C34v126Ev");}
void  S1350C3 ::v127(){vfunc_called(this, "_ZN7S1350C34v127Ev");}
void  S1350C3 ::v128(){vfunc_called(this, "_ZN7S1350C34v128Ev");}
void  S1350C3 ::v129(){vfunc_called(this, "_ZN7S1350C34v129Ev");}
void  S1350C3 ::v130(){vfunc_called(this, "_ZN7S1350C34v130Ev");}
void  S1350C3 ::v131(){vfunc_called(this, "_ZN7S1350C34v131Ev");}
void  S1350C3 ::v132(){vfunc_called(this, "_ZN7S1350C34v132Ev");}
void  S1350C3 ::v133(){vfunc_called(this, "_ZN7S1350C34v133Ev");}
void  S1350C3 ::v134(){vfunc_called(this, "_ZN7S1350C34v134Ev");}
S1350C3 ::S1350C3(){ note_ctor("S1350C3", this);} // tgen

static void Test_S1350C3()
{
  extern Class_Descriptor cd_S1350C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1350C3, buf);
    S1350C3 *dp, &lv = *(dp=new (buf) S1350C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1350C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C3)");
    check_base_class_offset(lv, (S1350C4*), 0, "S1350C3");
    check_base_class_offset(lv, (S1350C6*), ABISELECT(96,60), "S1350C3");
    check_base_class_offset(lv, (S1350C7*), ABISELECT(104,64), "S1350C3");
    check_field_offset(lv, s1350c3f0, ABISELECT(112,68), "S1350C3.s1350c3f0");
    check_field_offset(lv, s1350c3f1, ABISELECT(120,72), "S1350C3.s1350c3f1");
    set_bf_and_test(lv, s1350c3f2, ABISELECT(136,84), 0, 1, 1, "S1350C3");
    set_bf_and_test(lv, s1350c3f3, ABISELECT(136,84), 1, 1, 1, "S1350C3");
    set_bf_and_test(lv, s1350c3f4, ABISELECT(136,84), 2, 1, 1, "S1350C3");
    set_bf_and_test(lv, s1350c3f5, ABISELECT(136,84), 3, 1, 1, "S1350C3");
    test_class_info(&lv, &cd_S1350C3);
    dp->~S1350C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C3(Test_S1350C3, "S1350C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1350C3C1Ev();
extern void _ZN7S1350C3D1Ev();
Name_Map name_map_S1350C3[] = {
  NSPAIR(_ZN7S1350C3C1Ev),
  NSPAIR(_ZN7S1350C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1350C4;
extern VTBL_ENTRY _ZTI7S1350C4[];
extern  VTBL_ENTRY _ZTV7S1350C4[];
extern Class_Descriptor cd_S1350C6;
extern VTBL_ENTRY _ZTI7S1350C6[];
extern  VTBL_ENTRY _ZTV7S1350C6[];
extern Class_Descriptor cd_S1350C7;
extern VTBL_ENTRY _ZTI7S1350C7[];
extern  VTBL_ENTRY _ZTV7S1350C7[];
static Base_Class bases_S1350C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1350C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1350C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1350C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1350C3[];
extern void _ZN7S1350C3D1Ev();
extern void _ZN7S1350C3D0Ev();
extern void _ZN7S1350C43v22Ev();
extern void _ZN7S1350C43v23Ev();
extern void _ZN7S1350C43v24Ev();
extern void _ZN7S1350C43v25Ev();
extern void _ZN7S1350C43v26Ev();
extern void _ZN7S1350C43v27Ev();
extern void _ZN7S1350C43v28Ev();
extern void _ZN7S1350C43v29Ev();
extern void _ZN7S1350C43v30Ev();
extern void _ZN7S1350C43v31Ev();
extern void _ZN7S1350C43v32Ev();
extern void _ZN7S1350C43v33Ev();
extern void _ZN7S1350C43v34Ev();
extern void _ZN7S1350C43v35Ev();
extern void _ZN7S1350C43v36Ev();
extern void _ZN7S1350C43v37Ev();
extern void _ZN7S1350C43v38Ev();
extern void _ZN7S1350C43v39Ev();
extern void _ZN7S1350C43v40Ev();
extern void _ZN7S1350C43v41Ev();
extern void _ZN7S1350C43v42Ev();
extern void _ZN7S1350C43v43Ev();
extern void _ZN7S1350C43v44Ev();
extern void _ZN7S1350C43v45Ev();
extern void _ZN7S1350C43v46Ev();
extern void _ZN7S1350C43v47Ev();
extern void _ZN7S1350C43v48Ev();
extern void _ZN7S1350C43v49Ev();
extern void _ZN7S1350C43v50Ev();
extern void _ZN7S1350C43v51Ev();
extern void _ZN7S1350C43v52Ev();
extern void _ZN7S1350C43v53Ev();
extern void _ZN7S1350C43v54Ev();
extern void _ZN7S1350C43v55Ev();
extern void _ZN7S1350C43v56Ev();
extern void _ZN7S1350C43v57Ev();
extern void _ZN7S1350C43v58Ev();
extern void _ZN7S1350C43v59Ev();
extern void _ZN7S1350C43v60Ev();
extern void _ZN7S1350C43v61Ev();
extern void _ZN7S1350C43v62Ev();
extern void _ZN7S1350C43v63Ev();
extern void _ZN7S1350C43v64Ev();
extern void _ZN7S1350C43v65Ev();
extern void _ZN7S1350C43v66Ev();
extern void _ZN7S1350C43v67Ev();
extern void _ZN7S1350C43v68Ev();
extern void _ZN7S1350C43v69Ev();
extern void _ZN7S1350C43v70Ev();
extern void _ZN7S1350C43v71Ev();
extern void _ZN7S1350C43v72Ev();
extern void _ZN7S1350C43v73Ev();
extern void _ZN7S1350C43v74Ev();
extern void _ZN7S1350C43v75Ev();
extern void _ZN7S1350C43v76Ev();
extern void _ZN7S1350C43v77Ev();
extern void _ZN7S1350C43v78Ev();
extern void _ZN7S1350C43v79Ev();
extern void _ZN7S1350C43v80Ev();
extern void _ZN7S1350C43v81Ev();
extern void _ZN7S1350C43v82Ev();
extern void _ZN7S1350C43v83Ev();
extern void _ZN7S1350C43v84Ev();
extern void _ZN7S1350C43v85Ev();
extern void _ZN7S1350C34v111Ev();
extern void _ZN7S1350C34v112Ev();
extern void _ZN7S1350C34v113Ev();
extern void _ZN7S1350C34v114Ev();
extern void _ZN7S1350C34v115Ev();
extern void _ZN7S1350C34v116Ev();
extern void _ZN7S1350C34v117Ev();
extern void _ZN7S1350C34v118Ev();
extern void _ZN7S1350C34v119Ev();
extern void _ZN7S1350C34v120Ev();
extern void _ZN7S1350C34v121Ev();
extern void _ZN7S1350C34v122Ev();
extern void _ZN7S1350C34v123Ev();
extern void _ZN7S1350C34v124Ev();
extern void _ZN7S1350C34v125Ev();
extern void _ZN7S1350C34v126Ev();
extern void _ZN7S1350C34v127Ev();
extern void _ZN7S1350C34v128Ev();
extern void _ZN7S1350C34v129Ev();
extern void _ZN7S1350C34v130Ev();
extern void _ZN7S1350C34v131Ev();
extern void _ZN7S1350C34v132Ev();
extern void _ZN7S1350C34v133Ev();
extern void _ZN7S1350C34v134Ev();
extern void _ZN7S1350C63v86Ev();
extern void _ZN7S1350C63v87Ev();
extern void _ZN7S1350C63v88Ev();
extern void _ZN7S1350C63v89Ev();
extern void _ZN7S1350C63v90Ev();
extern void _ZN7S1350C63v91Ev();
extern void _ZN7S1350C63v92Ev();
extern void _ZN7S1350C63v93Ev();
extern void _ZN7S1350C63v94Ev();
extern void _ZN7S1350C63v95Ev();
extern void _ZN7S1350C63v96Ev();
extern void _ZN7S1350C63v97Ev();
extern void _ZN7S1350C63v98Ev();
extern void _ZN7S1350C63v99Ev();
extern void _ZN7S1350C64v100Ev();
extern void _ZN7S1350C64v101Ev();
extern void _ZN7S1350C74v102Ev();
extern void _ZN7S1350C74v103Ev();
extern void _ZN7S1350C74v104Ev();
extern void _ZN7S1350C74v105Ev();
extern void _ZN7S1350C74v106Ev();
extern void _ZN7S1350C74v107Ev();
extern void _ZN7S1350C74v108Ev();
extern void _ZN7S1350C74v109Ev();
extern void _ZN7S1350C74v110Ev();
static  VTBL_ENTRY vtc_S1350C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C3[0]),
  (VTBL_ENTRY)&_ZN7S1350C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1350C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v84Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v85Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v134Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1350C3[0]),
  (VTBL_ENTRY)&_ZN7S1350C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v99Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v100Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v101Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1350C3[0]),
  (VTBL_ENTRY)&_ZN7S1350C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v108Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v109Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v110Ev,
};
extern VTBL_ENTRY _ZTI7S1350C3[];
extern  VTBL_ENTRY _ZTV7S1350C3[];
Class_Descriptor cd_S1350C3 = {  "S1350C3", // class name
  bases_S1350C3, 3,
  &(vtc_S1350C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1350C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1350C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C2  : S1350C3 {
  ::S3262C11_nt s1350c2f0;
  int s1350c2f1;
  virtual  ~S1350C2(); // _ZN7S1350C2D1Ev
  virtual void  v135(); // _ZN7S1350C24v135Ev
  virtual void  v136(); // _ZN7S1350C24v136Ev
  virtual void  v137(); // _ZN7S1350C24v137Ev
  virtual void  v138(); // _ZN7S1350C24v138Ev
  virtual void  v139(); // _ZN7S1350C24v139Ev
  virtual void  v140(); // _ZN7S1350C24v140Ev
  virtual void  v141(); // _ZN7S1350C24v141Ev
  virtual void  v142(); // _ZN7S1350C24v142Ev
  virtual void  v143(); // _ZN7S1350C24v143Ev
  virtual void  v144(); // _ZN7S1350C24v144Ev
  virtual void  v145(); // _ZN7S1350C24v145Ev
  virtual void  v146(); // _ZN7S1350C24v146Ev
  virtual void  v147(); // _ZN7S1350C24v147Ev
  virtual void  v148(); // _ZN7S1350C24v148Ev
  virtual void  v149(); // _ZN7S1350C24v149Ev
  virtual void  v150(); // _ZN7S1350C24v150Ev
  virtual void  v151(); // _ZN7S1350C24v151Ev
  virtual void  v152(); // _ZN7S1350C24v152Ev
  virtual void  v153(); // _ZN7S1350C24v153Ev
  virtual void  v154(); // _ZN7S1350C24v154Ev
  virtual void  v155(); // _ZN7S1350C24v155Ev
  virtual void  v156(); // _ZN7S1350C24v156Ev
  virtual void  v157(); // _ZN7S1350C24v157Ev
  virtual void  v158(); // _ZN7S1350C24v158Ev
  virtual void  v159(); // _ZN7S1350C24v159Ev
  virtual void  v160(); // _ZN7S1350C24v160Ev
  S1350C2(); // tgen
};
//SIG(-1 S1350C2) C1{ BC2{ BC3{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106} BC6{ v107 v108 v109 v110 v111 v112 v113 v114 v115} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1350C2 ::~S1350C2(){ note_dtor("S1350C2", this);}
void  S1350C2 ::v135(){vfunc_called(this, "_ZN7S1350C24v135Ev");}
void  S1350C2 ::v136(){vfunc_called(this, "_ZN7S1350C24v136Ev");}
void  S1350C2 ::v137(){vfunc_called(this, "_ZN7S1350C24v137Ev");}
void  S1350C2 ::v138(){vfunc_called(this, "_ZN7S1350C24v138Ev");}
void  S1350C2 ::v139(){vfunc_called(this, "_ZN7S1350C24v139Ev");}
void  S1350C2 ::v140(){vfunc_called(this, "_ZN7S1350C24v140Ev");}
void  S1350C2 ::v141(){vfunc_called(this, "_ZN7S1350C24v141Ev");}
void  S1350C2 ::v142(){vfunc_called(this, "_ZN7S1350C24v142Ev");}
void  S1350C2 ::v143(){vfunc_called(this, "_ZN7S1350C24v143Ev");}
void  S1350C2 ::v144(){vfunc_called(this, "_ZN7S1350C24v144Ev");}
void  S1350C2 ::v145(){vfunc_called(this, "_ZN7S1350C24v145Ev");}
void  S1350C2 ::v146(){vfunc_called(this, "_ZN7S1350C24v146Ev");}
void  S1350C2 ::v147(){vfunc_called(this, "_ZN7S1350C24v147Ev");}
void  S1350C2 ::v148(){vfunc_called(this, "_ZN7S1350C24v148Ev");}
void  S1350C2 ::v149(){vfunc_called(this, "_ZN7S1350C24v149Ev");}
void  S1350C2 ::v150(){vfunc_called(this, "_ZN7S1350C24v150Ev");}
void  S1350C2 ::v151(){vfunc_called(this, "_ZN7S1350C24v151Ev");}
void  S1350C2 ::v152(){vfunc_called(this, "_ZN7S1350C24v152Ev");}
void  S1350C2 ::v153(){vfunc_called(this, "_ZN7S1350C24v153Ev");}
void  S1350C2 ::v154(){vfunc_called(this, "_ZN7S1350C24v154Ev");}
void  S1350C2 ::v155(){vfunc_called(this, "_ZN7S1350C24v155Ev");}
void  S1350C2 ::v156(){vfunc_called(this, "_ZN7S1350C24v156Ev");}
void  S1350C2 ::v157(){vfunc_called(this, "_ZN7S1350C24v157Ev");}
void  S1350C2 ::v158(){vfunc_called(this, "_ZN7S1350C24v158Ev");}
void  S1350C2 ::v159(){vfunc_called(this, "_ZN7S1350C24v159Ev");}
void  S1350C2 ::v160(){vfunc_called(this, "_ZN7S1350C24v160Ev");}
S1350C2 ::S1350C2(){ note_ctor("S1350C2", this);} // tgen

static void Test_S1350C2()
{
  extern Class_Descriptor cd_S1350C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1350C2, buf);
    S1350C2 *dp, &lv = *(dp=new (buf) S1350C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1350C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C2)");
    check_base_class_offset(lv, (S1350C4*)(S1350C3*), 0, "S1350C2");
    check_base_class_offset(lv, (S1350C6*)(S1350C3*), ABISELECT(96,60), "S1350C2");
    check_base_class_offset(lv, (S1350C7*)(S1350C3*), ABISELECT(104,64), "S1350C2");
    check_base_class_offset(lv, (S1350C3*), 0, "S1350C2");
    check_field_offset(lv, s1350c2f0, ABISELECT(144,88), "S1350C2.s1350c2f0");
    check_field_offset(lv, s1350c2f1, ABISELECT(168,104), "S1350C2.s1350c2f1");
    test_class_info(&lv, &cd_S1350C2);
    dp->~S1350C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C2(Test_S1350C2, "S1350C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1350C2C1Ev();
extern void _ZN7S1350C2D1Ev();
Name_Map name_map_S1350C2[] = {
  NSPAIR(_ZN7S1350C2C1Ev),
  NSPAIR(_ZN7S1350C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1350C4;
extern VTBL_ENTRY _ZTI7S1350C4[];
extern  VTBL_ENTRY _ZTV7S1350C4[];
extern Class_Descriptor cd_S1350C6;
extern VTBL_ENTRY _ZTI7S1350C6[];
extern  VTBL_ENTRY _ZTV7S1350C6[];
extern Class_Descriptor cd_S1350C7;
extern VTBL_ENTRY _ZTI7S1350C7[];
extern  VTBL_ENTRY _ZTV7S1350C7[];
extern Class_Descriptor cd_S1350C3;
extern VTBL_ENTRY _ZTI7S1350C3[];
extern  VTBL_ENTRY _ZTV7S1350C3[];
static Base_Class bases_S1350C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1350C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C6,    ABISELECT(96,60), //bcp->offset
    118, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C7,    ABISELECT(104,64), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1350C2[];
extern void _ZN7S1350C2D1Ev();
extern void _ZN7S1350C2D0Ev();
extern void _ZN7S1350C43v22Ev();
extern void _ZN7S1350C43v23Ev();
extern void _ZN7S1350C43v24Ev();
extern void _ZN7S1350C43v25Ev();
extern void _ZN7S1350C43v26Ev();
extern void _ZN7S1350C43v27Ev();
extern void _ZN7S1350C43v28Ev();
extern void _ZN7S1350C43v29Ev();
extern void _ZN7S1350C43v30Ev();
extern void _ZN7S1350C43v31Ev();
extern void _ZN7S1350C43v32Ev();
extern void _ZN7S1350C43v33Ev();
extern void _ZN7S1350C43v34Ev();
extern void _ZN7S1350C43v35Ev();
extern void _ZN7S1350C43v36Ev();
extern void _ZN7S1350C43v37Ev();
extern void _ZN7S1350C43v38Ev();
extern void _ZN7S1350C43v39Ev();
extern void _ZN7S1350C43v40Ev();
extern void _ZN7S1350C43v41Ev();
extern void _ZN7S1350C43v42Ev();
extern void _ZN7S1350C43v43Ev();
extern void _ZN7S1350C43v44Ev();
extern void _ZN7S1350C43v45Ev();
extern void _ZN7S1350C43v46Ev();
extern void _ZN7S1350C43v47Ev();
extern void _ZN7S1350C43v48Ev();
extern void _ZN7S1350C43v49Ev();
extern void _ZN7S1350C43v50Ev();
extern void _ZN7S1350C43v51Ev();
extern void _ZN7S1350C43v52Ev();
extern void _ZN7S1350C43v53Ev();
extern void _ZN7S1350C43v54Ev();
extern void _ZN7S1350C43v55Ev();
extern void _ZN7S1350C43v56Ev();
extern void _ZN7S1350C43v57Ev();
extern void _ZN7S1350C43v58Ev();
extern void _ZN7S1350C43v59Ev();
extern void _ZN7S1350C43v60Ev();
extern void _ZN7S1350C43v61Ev();
extern void _ZN7S1350C43v62Ev();
extern void _ZN7S1350C43v63Ev();
extern void _ZN7S1350C43v64Ev();
extern void _ZN7S1350C43v65Ev();
extern void _ZN7S1350C43v66Ev();
extern void _ZN7S1350C43v67Ev();
extern void _ZN7S1350C43v68Ev();
extern void _ZN7S1350C43v69Ev();
extern void _ZN7S1350C43v70Ev();
extern void _ZN7S1350C43v71Ev();
extern void _ZN7S1350C43v72Ev();
extern void _ZN7S1350C43v73Ev();
extern void _ZN7S1350C43v74Ev();
extern void _ZN7S1350C43v75Ev();
extern void _ZN7S1350C43v76Ev();
extern void _ZN7S1350C43v77Ev();
extern void _ZN7S1350C43v78Ev();
extern void _ZN7S1350C43v79Ev();
extern void _ZN7S1350C43v80Ev();
extern void _ZN7S1350C43v81Ev();
extern void _ZN7S1350C43v82Ev();
extern void _ZN7S1350C43v83Ev();
extern void _ZN7S1350C43v84Ev();
extern void _ZN7S1350C43v85Ev();
extern void _ZN7S1350C34v111Ev();
extern void _ZN7S1350C34v112Ev();
extern void _ZN7S1350C34v113Ev();
extern void _ZN7S1350C34v114Ev();
extern void _ZN7S1350C34v115Ev();
extern void _ZN7S1350C34v116Ev();
extern void _ZN7S1350C34v117Ev();
extern void _ZN7S1350C34v118Ev();
extern void _ZN7S1350C34v119Ev();
extern void _ZN7S1350C34v120Ev();
extern void _ZN7S1350C34v121Ev();
extern void _ZN7S1350C34v122Ev();
extern void _ZN7S1350C34v123Ev();
extern void _ZN7S1350C34v124Ev();
extern void _ZN7S1350C34v125Ev();
extern void _ZN7S1350C34v126Ev();
extern void _ZN7S1350C34v127Ev();
extern void _ZN7S1350C34v128Ev();
extern void _ZN7S1350C34v129Ev();
extern void _ZN7S1350C34v130Ev();
extern void _ZN7S1350C34v131Ev();
extern void _ZN7S1350C34v132Ev();
extern void _ZN7S1350C34v133Ev();
extern void _ZN7S1350C34v134Ev();
extern void _ZN7S1350C24v135Ev();
extern void _ZN7S1350C24v136Ev();
extern void _ZN7S1350C24v137Ev();
extern void _ZN7S1350C24v138Ev();
extern void _ZN7S1350C24v139Ev();
extern void _ZN7S1350C24v140Ev();
extern void _ZN7S1350C24v141Ev();
extern void _ZN7S1350C24v142Ev();
extern void _ZN7S1350C24v143Ev();
extern void _ZN7S1350C24v144Ev();
extern void _ZN7S1350C24v145Ev();
extern void _ZN7S1350C24v146Ev();
extern void _ZN7S1350C24v147Ev();
extern void _ZN7S1350C24v148Ev();
extern void _ZN7S1350C24v149Ev();
extern void _ZN7S1350C24v150Ev();
extern void _ZN7S1350C24v151Ev();
extern void _ZN7S1350C24v152Ev();
extern void _ZN7S1350C24v153Ev();
extern void _ZN7S1350C24v154Ev();
extern void _ZN7S1350C24v155Ev();
extern void _ZN7S1350C24v156Ev();
extern void _ZN7S1350C24v157Ev();
extern void _ZN7S1350C24v158Ev();
extern void _ZN7S1350C24v159Ev();
extern void _ZN7S1350C24v160Ev();
extern void _ZN7S1350C63v86Ev();
extern void _ZN7S1350C63v87Ev();
extern void _ZN7S1350C63v88Ev();
extern void _ZN7S1350C63v89Ev();
extern void _ZN7S1350C63v90Ev();
extern void _ZN7S1350C63v91Ev();
extern void _ZN7S1350C63v92Ev();
extern void _ZN7S1350C63v93Ev();
extern void _ZN7S1350C63v94Ev();
extern void _ZN7S1350C63v95Ev();
extern void _ZN7S1350C63v96Ev();
extern void _ZN7S1350C63v97Ev();
extern void _ZN7S1350C63v98Ev();
extern void _ZN7S1350C63v99Ev();
extern void _ZN7S1350C64v100Ev();
extern void _ZN7S1350C64v101Ev();
extern void _ZN7S1350C74v102Ev();
extern void _ZN7S1350C74v103Ev();
extern void _ZN7S1350C74v104Ev();
extern void _ZN7S1350C74v105Ev();
extern void _ZN7S1350C74v106Ev();
extern void _ZN7S1350C74v107Ev();
extern void _ZN7S1350C74v108Ev();
extern void _ZN7S1350C74v109Ev();
extern void _ZN7S1350C74v110Ev();
static  VTBL_ENTRY vtc_S1350C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C2[0]),
  (VTBL_ENTRY)&_ZN7S1350C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1350C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v84Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v85Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v134Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v149Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v150Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v151Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v152Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v153Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v154Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v155Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v156Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v157Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v158Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v159Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v160Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1350C2[0]),
  (VTBL_ENTRY)&_ZN7S1350C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v99Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v100Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v101Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1350C2[0]),
  (VTBL_ENTRY)&_ZN7S1350C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v108Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v109Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v110Ev,
};
extern VTBL_ENTRY _ZTI7S1350C2[];
extern  VTBL_ENTRY _ZTV7S1350C2[];
Class_Descriptor cd_S1350C2 = {  "S1350C2", // class name
  bases_S1350C2, 4,
  &(vtc_S1350C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1350C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1350C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1350C1  : S1350C2 {
  ::S79C44 s1350c1f0;
  ::S79C8_nt s1350c1f1;
  ::S79C40 s1350c1f2;
  virtual  ~S1350C1(); // _ZN7S1350C1D1Ev
  virtual void  v1(); // _ZN7S1350C12v1Ev
  virtual void  v2(); // _ZN7S1350C12v2Ev
  virtual void  v3(); // _ZN7S1350C12v3Ev
  virtual void  v4(); // _ZN7S1350C12v4Ev
  virtual void  v5(); // _ZN7S1350C12v5Ev
  virtual void  v6(); // _ZN7S1350C12v6Ev
  virtual void  v7(); // _ZN7S1350C12v7Ev
  virtual void  v8(); // _ZN7S1350C12v8Ev
  virtual void  v9(); // _ZN7S1350C12v9Ev
  virtual void  v10(); // _ZN7S1350C13v10Ev
  virtual void  v11(); // _ZN7S1350C13v11Ev
  virtual void  v12(); // _ZN7S1350C13v12Ev
  virtual void  v13(); // _ZN7S1350C13v13Ev
  virtual void  v14(); // _ZN7S1350C13v14Ev
  virtual void  v15(); // _ZN7S1350C13v15Ev
  virtual void  v16(); // _ZN7S1350C13v16Ev
  virtual void  v17(); // _ZN7S1350C13v17Ev
  virtual void  v18(); // _ZN7S1350C13v18Ev
  virtual void  v19(); // _ZN7S1350C13v19Ev
  virtual void  v20(); // _ZN7S1350C13v20Ev
  virtual void  v21(); // _ZN7S1350C13v21Ev
  S1350C1(); // tgen
};
//SIG(1 S1350C1) C1{ BC2{ BC3{ BC4{ vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101} BC7{ v102 v103 v104 v105 v106 v107 v108 v109 v110} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 FC13 FC5 FC9}


 S1350C1 ::~S1350C1(){ note_dtor("S1350C1", this);}
void  S1350C1 ::v1(){vfunc_called(this, "_ZN7S1350C12v1Ev");}
void  S1350C1 ::v2(){vfunc_called(this, "_ZN7S1350C12v2Ev");}
void  S1350C1 ::v3(){vfunc_called(this, "_ZN7S1350C12v3Ev");}
void  S1350C1 ::v4(){vfunc_called(this, "_ZN7S1350C12v4Ev");}
void  S1350C1 ::v5(){vfunc_called(this, "_ZN7S1350C12v5Ev");}
void  S1350C1 ::v6(){vfunc_called(this, "_ZN7S1350C12v6Ev");}
void  S1350C1 ::v7(){vfunc_called(this, "_ZN7S1350C12v7Ev");}
void  S1350C1 ::v8(){vfunc_called(this, "_ZN7S1350C12v8Ev");}
void  S1350C1 ::v9(){vfunc_called(this, "_ZN7S1350C12v9Ev");}
void  S1350C1 ::v10(){vfunc_called(this, "_ZN7S1350C13v10Ev");}
void  S1350C1 ::v11(){vfunc_called(this, "_ZN7S1350C13v11Ev");}
void  S1350C1 ::v12(){vfunc_called(this, "_ZN7S1350C13v12Ev");}
void  S1350C1 ::v13(){vfunc_called(this, "_ZN7S1350C13v13Ev");}
void  S1350C1 ::v14(){vfunc_called(this, "_ZN7S1350C13v14Ev");}
void  S1350C1 ::v15(){vfunc_called(this, "_ZN7S1350C13v15Ev");}
void  S1350C1 ::v16(){vfunc_called(this, "_ZN7S1350C13v16Ev");}
void  S1350C1 ::v17(){vfunc_called(this, "_ZN7S1350C13v17Ev");}
void  S1350C1 ::v18(){vfunc_called(this, "_ZN7S1350C13v18Ev");}
void  S1350C1 ::v19(){vfunc_called(this, "_ZN7S1350C13v19Ev");}
void  S1350C1 ::v20(){vfunc_called(this, "_ZN7S1350C13v20Ev");}
void  S1350C1 ::v21(){vfunc_called(this, "_ZN7S1350C13v21Ev");}
S1350C1 ::S1350C1(){ note_ctor("S1350C1", this);} // tgen

static void Test_S1350C1()
{
  extern Class_Descriptor cd_S1350C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,36)];
    init_test(&cd_S1350C1, buf);
    S1350C1 *dp, &lv = *(dp=new (buf) S1350C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,140), "sizeof(S1350C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1350C1)");
    check_base_class_offset(lv, (S1350C4*)(S1350C3*)(S1350C2*), 0, "S1350C1");
    check_base_class_offset(lv, (S1350C6*)(S1350C3*)(S1350C2*), ABISELECT(96,60), "S1350C1");
    check_base_class_offset(lv, (S1350C7*)(S1350C3*)(S1350C2*), ABISELECT(104,64), "S1350C1");
    check_base_class_offset(lv, (S1350C3*)(S1350C2*), 0, "S1350C1");
    check_base_class_offset(lv, (S1350C2*), 0, "S1350C1");
    check_field_offset(lv, s1350c1f0, ABISELECT(176,108), "S1350C1.s1350c1f0");
    check_field_offset(lv, s1350c1f1, ABISELECT(192,120), "S1350C1.s1350c1f1");
    check_field_offset(lv, s1350c1f2, ABISELECT(200,128), "S1350C1.s1350c1f2");
    test_class_info(&lv, &cd_S1350C1);
    dp->~S1350C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1350C1(Test_S1350C1, "S1350C1", ABISELECT(216,140));

#else // __cplusplus

extern void _ZN7S1350C1C1Ev();
extern void _ZN7S1350C1D1Ev();
Name_Map name_map_S1350C1[] = {
  NSPAIR(_ZN7S1350C1C1Ev),
  NSPAIR(_ZN7S1350C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1350C4;
extern VTBL_ENTRY _ZTI7S1350C4[];
extern  VTBL_ENTRY _ZTV7S1350C4[];
extern Class_Descriptor cd_S1350C6;
extern VTBL_ENTRY _ZTI7S1350C6[];
extern  VTBL_ENTRY _ZTV7S1350C6[];
extern Class_Descriptor cd_S1350C7;
extern VTBL_ENTRY _ZTI7S1350C7[];
extern  VTBL_ENTRY _ZTV7S1350C7[];
extern Class_Descriptor cd_S1350C3;
extern VTBL_ENTRY _ZTI7S1350C3[];
extern  VTBL_ENTRY _ZTV7S1350C3[];
extern Class_Descriptor cd_S1350C2;
extern VTBL_ENTRY _ZTI7S1350C2[];
extern  VTBL_ENTRY _ZTV7S1350C2[];
static Base_Class bases_S1350C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1350C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C6,    ABISELECT(96,60), //bcp->offset
    139, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C7,    ABISELECT(104,64), //bcp->offset
    157, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1350C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1350C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1350C1[];
extern void _ZN7S1350C1D1Ev();
extern void _ZN7S1350C1D0Ev();
extern void _ZN7S1350C43v22Ev();
extern void _ZN7S1350C43v23Ev();
extern void _ZN7S1350C43v24Ev();
extern void _ZN7S1350C43v25Ev();
extern void _ZN7S1350C43v26Ev();
extern void _ZN7S1350C43v27Ev();
extern void _ZN7S1350C43v28Ev();
extern void _ZN7S1350C43v29Ev();
extern void _ZN7S1350C43v30Ev();
extern void _ZN7S1350C43v31Ev();
extern void _ZN7S1350C43v32Ev();
extern void _ZN7S1350C43v33Ev();
extern void _ZN7S1350C43v34Ev();
extern void _ZN7S1350C43v35Ev();
extern void _ZN7S1350C43v36Ev();
extern void _ZN7S1350C43v37Ev();
extern void _ZN7S1350C43v38Ev();
extern void _ZN7S1350C43v39Ev();
extern void _ZN7S1350C43v40Ev();
extern void _ZN7S1350C43v41Ev();
extern void _ZN7S1350C43v42Ev();
extern void _ZN7S1350C43v43Ev();
extern void _ZN7S1350C43v44Ev();
extern void _ZN7S1350C43v45Ev();
extern void _ZN7S1350C43v46Ev();
extern void _ZN7S1350C43v47Ev();
extern void _ZN7S1350C43v48Ev();
extern void _ZN7S1350C43v49Ev();
extern void _ZN7S1350C43v50Ev();
extern void _ZN7S1350C43v51Ev();
extern void _ZN7S1350C43v52Ev();
extern void _ZN7S1350C43v53Ev();
extern void _ZN7S1350C43v54Ev();
extern void _ZN7S1350C43v55Ev();
extern void _ZN7S1350C43v56Ev();
extern void _ZN7S1350C43v57Ev();
extern void _ZN7S1350C43v58Ev();
extern void _ZN7S1350C43v59Ev();
extern void _ZN7S1350C43v60Ev();
extern void _ZN7S1350C43v61Ev();
extern void _ZN7S1350C43v62Ev();
extern void _ZN7S1350C43v63Ev();
extern void _ZN7S1350C43v64Ev();
extern void _ZN7S1350C43v65Ev();
extern void _ZN7S1350C43v66Ev();
extern void _ZN7S1350C43v67Ev();
extern void _ZN7S1350C43v68Ev();
extern void _ZN7S1350C43v69Ev();
extern void _ZN7S1350C43v70Ev();
extern void _ZN7S1350C43v71Ev();
extern void _ZN7S1350C43v72Ev();
extern void _ZN7S1350C43v73Ev();
extern void _ZN7S1350C43v74Ev();
extern void _ZN7S1350C43v75Ev();
extern void _ZN7S1350C43v76Ev();
extern void _ZN7S1350C43v77Ev();
extern void _ZN7S1350C43v78Ev();
extern void _ZN7S1350C43v79Ev();
extern void _ZN7S1350C43v80Ev();
extern void _ZN7S1350C43v81Ev();
extern void _ZN7S1350C43v82Ev();
extern void _ZN7S1350C43v83Ev();
extern void _ZN7S1350C43v84Ev();
extern void _ZN7S1350C43v85Ev();
extern void _ZN7S1350C34v111Ev();
extern void _ZN7S1350C34v112Ev();
extern void _ZN7S1350C34v113Ev();
extern void _ZN7S1350C34v114Ev();
extern void _ZN7S1350C34v115Ev();
extern void _ZN7S1350C34v116Ev();
extern void _ZN7S1350C34v117Ev();
extern void _ZN7S1350C34v118Ev();
extern void _ZN7S1350C34v119Ev();
extern void _ZN7S1350C34v120Ev();
extern void _ZN7S1350C34v121Ev();
extern void _ZN7S1350C34v122Ev();
extern void _ZN7S1350C34v123Ev();
extern void _ZN7S1350C34v124Ev();
extern void _ZN7S1350C34v125Ev();
extern void _ZN7S1350C34v126Ev();
extern void _ZN7S1350C34v127Ev();
extern void _ZN7S1350C34v128Ev();
extern void _ZN7S1350C34v129Ev();
extern void _ZN7S1350C34v130Ev();
extern void _ZN7S1350C34v131Ev();
extern void _ZN7S1350C34v132Ev();
extern void _ZN7S1350C34v133Ev();
extern void _ZN7S1350C34v134Ev();
extern void _ZN7S1350C24v135Ev();
extern void _ZN7S1350C24v136Ev();
extern void _ZN7S1350C24v137Ev();
extern void _ZN7S1350C24v138Ev();
extern void _ZN7S1350C24v139Ev();
extern void _ZN7S1350C24v140Ev();
extern void _ZN7S1350C24v141Ev();
extern void _ZN7S1350C24v142Ev();
extern void _ZN7S1350C24v143Ev();
extern void _ZN7S1350C24v144Ev();
extern void _ZN7S1350C24v145Ev();
extern void _ZN7S1350C24v146Ev();
extern void _ZN7S1350C24v147Ev();
extern void _ZN7S1350C24v148Ev();
extern void _ZN7S1350C24v149Ev();
extern void _ZN7S1350C24v150Ev();
extern void _ZN7S1350C24v151Ev();
extern void _ZN7S1350C24v152Ev();
extern void _ZN7S1350C24v153Ev();
extern void _ZN7S1350C24v154Ev();
extern void _ZN7S1350C24v155Ev();
extern void _ZN7S1350C24v156Ev();
extern void _ZN7S1350C24v157Ev();
extern void _ZN7S1350C24v158Ev();
extern void _ZN7S1350C24v159Ev();
extern void _ZN7S1350C24v160Ev();
extern void _ZN7S1350C12v1Ev();
extern void _ZN7S1350C12v2Ev();
extern void _ZN7S1350C12v3Ev();
extern void _ZN7S1350C12v4Ev();
extern void _ZN7S1350C12v5Ev();
extern void _ZN7S1350C12v6Ev();
extern void _ZN7S1350C12v7Ev();
extern void _ZN7S1350C12v8Ev();
extern void _ZN7S1350C12v9Ev();
extern void _ZN7S1350C13v10Ev();
extern void _ZN7S1350C13v11Ev();
extern void _ZN7S1350C13v12Ev();
extern void _ZN7S1350C13v13Ev();
extern void _ZN7S1350C13v14Ev();
extern void _ZN7S1350C13v15Ev();
extern void _ZN7S1350C13v16Ev();
extern void _ZN7S1350C13v17Ev();
extern void _ZN7S1350C13v18Ev();
extern void _ZN7S1350C13v19Ev();
extern void _ZN7S1350C13v20Ev();
extern void _ZN7S1350C13v21Ev();
extern void _ZN7S1350C63v86Ev();
extern void _ZN7S1350C63v87Ev();
extern void _ZN7S1350C63v88Ev();
extern void _ZN7S1350C63v89Ev();
extern void _ZN7S1350C63v90Ev();
extern void _ZN7S1350C63v91Ev();
extern void _ZN7S1350C63v92Ev();
extern void _ZN7S1350C63v93Ev();
extern void _ZN7S1350C63v94Ev();
extern void _ZN7S1350C63v95Ev();
extern void _ZN7S1350C63v96Ev();
extern void _ZN7S1350C63v97Ev();
extern void _ZN7S1350C63v98Ev();
extern void _ZN7S1350C63v99Ev();
extern void _ZN7S1350C64v100Ev();
extern void _ZN7S1350C64v101Ev();
extern void _ZN7S1350C74v102Ev();
extern void _ZN7S1350C74v103Ev();
extern void _ZN7S1350C74v104Ev();
extern void _ZN7S1350C74v105Ev();
extern void _ZN7S1350C74v106Ev();
extern void _ZN7S1350C74v107Ev();
extern void _ZN7S1350C74v108Ev();
extern void _ZN7S1350C74v109Ev();
extern void _ZN7S1350C74v110Ev();
static  VTBL_ENTRY vtc_S1350C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1350C1[0]),
  (VTBL_ENTRY)&_ZN7S1350C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1350C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v84Ev,
  (VTBL_ENTRY)&_ZN7S1350C43v85Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v133Ev,
  (VTBL_ENTRY)&_ZN7S1350C34v134Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v149Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v150Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v151Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v152Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v153Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v154Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v155Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v156Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v157Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v158Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v159Ev,
  (VTBL_ENTRY)&_ZN7S1350C24v160Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1350C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v15Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v16Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v17Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v18Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v19Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v20Ev,
  (VTBL_ENTRY)&_ZN7S1350C13v21Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1350C1[0]),
  (VTBL_ENTRY)&_ZN7S1350C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1350C63v99Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v100Ev,
  (VTBL_ENTRY)&_ZN7S1350C64v101Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1350C1[0]),
  (VTBL_ENTRY)&_ZN7S1350C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v108Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v109Ev,
  (VTBL_ENTRY)&_ZN7S1350C74v110Ev,
};
extern VTBL_ENTRY _ZTI7S1350C1[];
extern  VTBL_ENTRY _ZTV7S1350C1[];
Class_Descriptor cd_S1350C1 = {  "S1350C1", // class name
  bases_S1350C1, 5,
  &(vtc_S1350C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,140), // object size
  NSPAIRA(_ZTI7S1350C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1350C1),168, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C4  {
  int s1346c4f0;
  __tsi64 s1346c4f1;
  void *s1346c4f2[4];
  int s1346c4f3[2];
  void *s1346c4f4;
  ::S79C8_nt s1346c4f5;
  void *s1346c4f6[2];
  virtual  ~S1346C4(); // _ZN7S1346C4D1Ev
  virtual void  v20(); // _ZN7S1346C43v20Ev
  virtual void  v21(); // _ZN7S1346C43v21Ev
  virtual void  v22(); // _ZN7S1346C43v22Ev
  virtual void  v23(); // _ZN7S1346C43v23Ev
  virtual void  v24(); // _ZN7S1346C43v24Ev
  virtual void  v25(); // _ZN7S1346C43v25Ev
  virtual void  v26(); // _ZN7S1346C43v26Ev
  virtual void  v27(); // _ZN7S1346C43v27Ev
  virtual void  v28(); // _ZN7S1346C43v28Ev
  virtual void  v29(); // _ZN7S1346C43v29Ev
  virtual void  v30(); // _ZN7S1346C43v30Ev
  virtual void  v31(); // _ZN7S1346C43v31Ev
  virtual void  v32(); // _ZN7S1346C43v32Ev
  virtual void  v33(); // _ZN7S1346C43v33Ev
  virtual void  v34(); // _ZN7S1346C43v34Ev
  virtual void  v35(); // _ZN7S1346C43v35Ev
  virtual void  v36(); // _ZN7S1346C43v36Ev
  virtual void  v37(); // _ZN7S1346C43v37Ev
  virtual void  v38(); // _ZN7S1346C43v38Ev
  virtual void  v39(); // _ZN7S1346C43v39Ev
  virtual void  v40(); // _ZN7S1346C43v40Ev
  virtual void  v41(); // _ZN7S1346C43v41Ev
  virtual void  v42(); // _ZN7S1346C43v42Ev
  virtual void  v43(); // _ZN7S1346C43v43Ev
  virtual void  v44(); // _ZN7S1346C43v44Ev
  virtual void  v45(); // _ZN7S1346C43v45Ev
  virtual void  v46(); // _ZN7S1346C43v46Ev
  virtual void  v47(); // _ZN7S1346C43v47Ev
  virtual void  v48(); // _ZN7S1346C43v48Ev
  virtual void  v49(); // _ZN7S1346C43v49Ev
  virtual void  v50(); // _ZN7S1346C43v50Ev
  virtual void  v51(); // _ZN7S1346C43v51Ev
  virtual void  v52(); // _ZN7S1346C43v52Ev
  virtual void  v53(); // _ZN7S1346C43v53Ev
  virtual void  v54(); // _ZN7S1346C43v54Ev
  virtual void  v55(); // _ZN7S1346C43v55Ev
  virtual void  v56(); // _ZN7S1346C43v56Ev
  virtual void  v57(); // _ZN7S1346C43v57Ev
  virtual void  v58(); // _ZN7S1346C43v58Ev
  virtual void  v59(); // _ZN7S1346C43v59Ev
  virtual void  v60(); // _ZN7S1346C43v60Ev
  virtual void  v61(); // _ZN7S1346C43v61Ev
  virtual void  v62(); // _ZN7S1346C43v62Ev
  virtual void  v63(); // _ZN7S1346C43v63Ev
  virtual void  v64(); // _ZN7S1346C43v64Ev
  virtual void  v65(); // _ZN7S1346C43v65Ev
  virtual void  v66(); // _ZN7S1346C43v66Ev
  virtual void  v67(); // _ZN7S1346C43v67Ev
  virtual void  v68(); // _ZN7S1346C43v68Ev
  virtual void  v69(); // _ZN7S1346C43v69Ev
  virtual void  v70(); // _ZN7S1346C43v70Ev
  virtual void  v71(); // _ZN7S1346C43v71Ev
  virtual void  v72(); // _ZN7S1346C43v72Ev
  virtual void  v73(); // _ZN7S1346C43v73Ev
  virtual void  v74(); // _ZN7S1346C43v74Ev
  virtual void  v75(); // _ZN7S1346C43v75Ev
  virtual void  v76(); // _ZN7S1346C43v76Ev
  virtual void  v77(); // _ZN7S1346C43v77Ev
  virtual void  v78(); // _ZN7S1346C43v78Ev
  virtual void  v79(); // _ZN7S1346C43v79Ev
  virtual void  v80(); // _ZN7S1346C43v80Ev
  virtual void  v81(); // _ZN7S1346C43v81Ev
  virtual void  v82(); // _ZN7S1346C43v82Ev
  virtual void  v83(); // _ZN7S1346C43v83Ev
  S1346C4(); // tgen
};
//SIG(-1 S1346C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1346C4 ::~S1346C4(){ note_dtor("S1346C4", this);}
void  S1346C4 ::v20(){vfunc_called(this, "_ZN7S1346C43v20Ev");}
void  S1346C4 ::v21(){vfunc_called(this, "_ZN7S1346C43v21Ev");}
void  S1346C4 ::v22(){vfunc_called(this, "_ZN7S1346C43v22Ev");}
void  S1346C4 ::v23(){vfunc_called(this, "_ZN7S1346C43v23Ev");}
void  S1346C4 ::v24(){vfunc_called(this, "_ZN7S1346C43v24Ev");}
void  S1346C4 ::v25(){vfunc_called(this, "_ZN7S1346C43v25Ev");}
void  S1346C4 ::v26(){vfunc_called(this, "_ZN7S1346C43v26Ev");}
void  S1346C4 ::v27(){vfunc_called(this, "_ZN7S1346C43v27Ev");}
void  S1346C4 ::v28(){vfunc_called(this, "_ZN7S1346C43v28Ev");}
void  S1346C4 ::v29(){vfunc_called(this, "_ZN7S1346C43v29Ev");}
void  S1346C4 ::v30(){vfunc_called(this, "_ZN7S1346C43v30Ev");}
void  S1346C4 ::v31(){vfunc_called(this, "_ZN7S1346C43v31Ev");}
void  S1346C4 ::v32(){vfunc_called(this, "_ZN7S1346C43v32Ev");}
void  S1346C4 ::v33(){vfunc_called(this, "_ZN7S1346C43v33Ev");}
void  S1346C4 ::v34(){vfunc_called(this, "_ZN7S1346C43v34Ev");}
void  S1346C4 ::v35(){vfunc_called(this, "_ZN7S1346C43v35Ev");}
void  S1346C4 ::v36(){vfunc_called(this, "_ZN7S1346C43v36Ev");}
void  S1346C4 ::v37(){vfunc_called(this, "_ZN7S1346C43v37Ev");}
void  S1346C4 ::v38(){vfunc_called(this, "_ZN7S1346C43v38Ev");}
void  S1346C4 ::v39(){vfunc_called(this, "_ZN7S1346C43v39Ev");}
void  S1346C4 ::v40(){vfunc_called(this, "_ZN7S1346C43v40Ev");}
void  S1346C4 ::v41(){vfunc_called(this, "_ZN7S1346C43v41Ev");}
void  S1346C4 ::v42(){vfunc_called(this, "_ZN7S1346C43v42Ev");}
void  S1346C4 ::v43(){vfunc_called(this, "_ZN7S1346C43v43Ev");}
void  S1346C4 ::v44(){vfunc_called(this, "_ZN7S1346C43v44Ev");}
void  S1346C4 ::v45(){vfunc_called(this, "_ZN7S1346C43v45Ev");}
void  S1346C4 ::v46(){vfunc_called(this, "_ZN7S1346C43v46Ev");}
void  S1346C4 ::v47(){vfunc_called(this, "_ZN7S1346C43v47Ev");}
void  S1346C4 ::v48(){vfunc_called(this, "_ZN7S1346C43v48Ev");}
void  S1346C4 ::v49(){vfunc_called(this, "_ZN7S1346C43v49Ev");}
void  S1346C4 ::v50(){vfunc_called(this, "_ZN7S1346C43v50Ev");}
void  S1346C4 ::v51(){vfunc_called(this, "_ZN7S1346C43v51Ev");}
void  S1346C4 ::v52(){vfunc_called(this, "_ZN7S1346C43v52Ev");}
void  S1346C4 ::v53(){vfunc_called(this, "_ZN7S1346C43v53Ev");}
void  S1346C4 ::v54(){vfunc_called(this, "_ZN7S1346C43v54Ev");}
void  S1346C4 ::v55(){vfunc_called(this, "_ZN7S1346C43v55Ev");}
void  S1346C4 ::v56(){vfunc_called(this, "_ZN7S1346C43v56Ev");}
void  S1346C4 ::v57(){vfunc_called(this, "_ZN7S1346C43v57Ev");}
void  S1346C4 ::v58(){vfunc_called(this, "_ZN7S1346C43v58Ev");}
void  S1346C4 ::v59(){vfunc_called(this, "_ZN7S1346C43v59Ev");}
void  S1346C4 ::v60(){vfunc_called(this, "_ZN7S1346C43v60Ev");}
void  S1346C4 ::v61(){vfunc_called(this, "_ZN7S1346C43v61Ev");}
void  S1346C4 ::v62(){vfunc_called(this, "_ZN7S1346C43v62Ev");}
void  S1346C4 ::v63(){vfunc_called(this, "_ZN7S1346C43v63Ev");}
void  S1346C4 ::v64(){vfunc_called(this, "_ZN7S1346C43v64Ev");}
void  S1346C4 ::v65(){vfunc_called(this, "_ZN7S1346C43v65Ev");}
void  S1346C4 ::v66(){vfunc_called(this, "_ZN7S1346C43v66Ev");}
void  S1346C4 ::v67(){vfunc_called(this, "_ZN7S1346C43v67Ev");}
void  S1346C4 ::v68(){vfunc_called(this, "_ZN7S1346C43v68Ev");}
void  S1346C4 ::v69(){vfunc_called(this, "_ZN7S1346C43v69Ev");}
void  S1346C4 ::v70(){vfunc_called(this, "_ZN7S1346C43v70Ev");}
void  S1346C4 ::v71(){vfunc_called(this, "_ZN7S1346C43v71Ev");}
void  S1346C4 ::v72(){vfunc_called(this, "_ZN7S1346C43v72Ev");}
void  S1346C4 ::v73(){vfunc_called(this, "_ZN7S1346C43v73Ev");}
void  S1346C4 ::v74(){vfunc_called(this, "_ZN7S1346C43v74Ev");}
void  S1346C4 ::v75(){vfunc_called(this, "_ZN7S1346C43v75Ev");}
void  S1346C4 ::v76(){vfunc_called(this, "_ZN7S1346C43v76Ev");}
void  S1346C4 ::v77(){vfunc_called(this, "_ZN7S1346C43v77Ev");}
void  S1346C4 ::v78(){vfunc_called(this, "_ZN7S1346C43v78Ev");}
void  S1346C4 ::v79(){vfunc_called(this, "_ZN7S1346C43v79Ev");}
void  S1346C4 ::v80(){vfunc_called(this, "_ZN7S1346C43v80Ev");}
void  S1346C4 ::v81(){vfunc_called(this, "_ZN7S1346C43v81Ev");}
void  S1346C4 ::v82(){vfunc_called(this, "_ZN7S1346C43v82Ev");}
void  S1346C4 ::v83(){vfunc_called(this, "_ZN7S1346C43v83Ev");}
S1346C4 ::S1346C4(){ note_ctor("S1346C4", this);} // tgen

static void Test_S1346C4()
{
  extern Class_Descriptor cd_S1346C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1346C4, buf);
    S1346C4 *dp, &lv = *(dp=new (buf) S1346C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1346C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C4)");
    check_field_offset(lv, s1346c4f0, ABISELECT(8,4), "S1346C4.s1346c4f0");
    check_field_offset(lv, s1346c4f1, ABISELECT(16,8), "S1346C4.s1346c4f1");
    check_field_offset(lv, s1346c4f2, ABISELECT(24,16), "S1346C4.s1346c4f2");
    check_field_offset(lv, s1346c4f3, ABISELECT(56,32), "S1346C4.s1346c4f3");
    check_field_offset(lv, s1346c4f4, ABISELECT(64,40), "S1346C4.s1346c4f4");
    check_field_offset(lv, s1346c4f5, ABISELECT(72,44), "S1346C4.s1346c4f5");
    check_field_offset(lv, s1346c4f6, ABISELECT(80,52), "S1346C4.s1346c4f6");
    test_class_info(&lv, &cd_S1346C4);
    dp->~S1346C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C4(Test_S1346C4, "S1346C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1346C4C1Ev();
extern void _ZN7S1346C4D1Ev();
Name_Map name_map_S1346C4[] = {
  NSPAIR(_ZN7S1346C4C1Ev),
  NSPAIR(_ZN7S1346C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1346C4[];
extern void _ZN7S1346C4D1Ev();
extern void _ZN7S1346C4D0Ev();
extern void _ZN7S1346C43v20Ev();
extern void _ZN7S1346C43v21Ev();
extern void _ZN7S1346C43v22Ev();
extern void _ZN7S1346C43v23Ev();
extern void _ZN7S1346C43v24Ev();
extern void _ZN7S1346C43v25Ev();
extern void _ZN7S1346C43v26Ev();
extern void _ZN7S1346C43v27Ev();
extern void _ZN7S1346C43v28Ev();
extern void _ZN7S1346C43v29Ev();
extern void _ZN7S1346C43v30Ev();
extern void _ZN7S1346C43v31Ev();
extern void _ZN7S1346C43v32Ev();
extern void _ZN7S1346C43v33Ev();
extern void _ZN7S1346C43v34Ev();
extern void _ZN7S1346C43v35Ev();
extern void _ZN7S1346C43v36Ev();
extern void _ZN7S1346C43v37Ev();
extern void _ZN7S1346C43v38Ev();
extern void _ZN7S1346C43v39Ev();
extern void _ZN7S1346C43v40Ev();
extern void _ZN7S1346C43v41Ev();
extern void _ZN7S1346C43v42Ev();
extern void _ZN7S1346C43v43Ev();
extern void _ZN7S1346C43v44Ev();
extern void _ZN7S1346C43v45Ev();
extern void _ZN7S1346C43v46Ev();
extern void _ZN7S1346C43v47Ev();
extern void _ZN7S1346C43v48Ev();
extern void _ZN7S1346C43v49Ev();
extern void _ZN7S1346C43v50Ev();
extern void _ZN7S1346C43v51Ev();
extern void _ZN7S1346C43v52Ev();
extern void _ZN7S1346C43v53Ev();
extern void _ZN7S1346C43v54Ev();
extern void _ZN7S1346C43v55Ev();
extern void _ZN7S1346C43v56Ev();
extern void _ZN7S1346C43v57Ev();
extern void _ZN7S1346C43v58Ev();
extern void _ZN7S1346C43v59Ev();
extern void _ZN7S1346C43v60Ev();
extern void _ZN7S1346C43v61Ev();
extern void _ZN7S1346C43v62Ev();
extern void _ZN7S1346C43v63Ev();
extern void _ZN7S1346C43v64Ev();
extern void _ZN7S1346C43v65Ev();
extern void _ZN7S1346C43v66Ev();
extern void _ZN7S1346C43v67Ev();
extern void _ZN7S1346C43v68Ev();
extern void _ZN7S1346C43v69Ev();
extern void _ZN7S1346C43v70Ev();
extern void _ZN7S1346C43v71Ev();
extern void _ZN7S1346C43v72Ev();
extern void _ZN7S1346C43v73Ev();
extern void _ZN7S1346C43v74Ev();
extern void _ZN7S1346C43v75Ev();
extern void _ZN7S1346C43v76Ev();
extern void _ZN7S1346C43v77Ev();
extern void _ZN7S1346C43v78Ev();
extern void _ZN7S1346C43v79Ev();
extern void _ZN7S1346C43v80Ev();
extern void _ZN7S1346C43v81Ev();
extern void _ZN7S1346C43v82Ev();
extern void _ZN7S1346C43v83Ev();
static  VTBL_ENTRY vtc_S1346C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C4[0]),
  (VTBL_ENTRY)&_ZN7S1346C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1346C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v83Ev,
};
extern VTBL_ENTRY _ZTI7S1346C4[];
extern  VTBL_ENTRY _ZTV7S1346C4[];
Class_Descriptor cd_S1346C4 = {  "S1346C4", // class name
  0,0,//no base classes
  &(vtc_S1346C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1346C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1346C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C6  {
  virtual void  v84(); // _ZN7S1346C63v84Ev
  virtual void  v85(); // _ZN7S1346C63v85Ev
  virtual void  v86(); // _ZN7S1346C63v86Ev
  virtual void  v87(); // _ZN7S1346C63v87Ev
  virtual void  v88(); // _ZN7S1346C63v88Ev
  virtual void  v89(); // _ZN7S1346C63v89Ev
  virtual void  v90(); // _ZN7S1346C63v90Ev
  virtual void  v91(); // _ZN7S1346C63v91Ev
  virtual void  v92(); // _ZN7S1346C63v92Ev
  virtual void  v93(); // _ZN7S1346C63v93Ev
  virtual void  v94(); // _ZN7S1346C63v94Ev
  virtual void  v95(); // _ZN7S1346C63v95Ev
  virtual void  v96(); // _ZN7S1346C63v96Ev
  virtual void  v97(); // _ZN7S1346C63v97Ev
  virtual void  v98(); // _ZN7S1346C63v98Ev
  virtual void  v99(); // _ZN7S1346C63v99Ev
  ~S1346C6(); // tgen
  S1346C6(); // tgen
};
//SIG(-1 S1346C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1346C6 ::v84(){vfunc_called(this, "_ZN7S1346C63v84Ev");}
void  S1346C6 ::v85(){vfunc_called(this, "_ZN7S1346C63v85Ev");}
void  S1346C6 ::v86(){vfunc_called(this, "_ZN7S1346C63v86Ev");}
void  S1346C6 ::v87(){vfunc_called(this, "_ZN7S1346C63v87Ev");}
void  S1346C6 ::v88(){vfunc_called(this, "_ZN7S1346C63v88Ev");}
void  S1346C6 ::v89(){vfunc_called(this, "_ZN7S1346C63v89Ev");}
void  S1346C6 ::v90(){vfunc_called(this, "_ZN7S1346C63v90Ev");}
void  S1346C6 ::v91(){vfunc_called(this, "_ZN7S1346C63v91Ev");}
void  S1346C6 ::v92(){vfunc_called(this, "_ZN7S1346C63v92Ev");}
void  S1346C6 ::v93(){vfunc_called(this, "_ZN7S1346C63v93Ev");}
void  S1346C6 ::v94(){vfunc_called(this, "_ZN7S1346C63v94Ev");}
void  S1346C6 ::v95(){vfunc_called(this, "_ZN7S1346C63v95Ev");}
void  S1346C6 ::v96(){vfunc_called(this, "_ZN7S1346C63v96Ev");}
void  S1346C6 ::v97(){vfunc_called(this, "_ZN7S1346C63v97Ev");}
void  S1346C6 ::v98(){vfunc_called(this, "_ZN7S1346C63v98Ev");}
void  S1346C6 ::v99(){vfunc_called(this, "_ZN7S1346C63v99Ev");}
S1346C6 ::~S1346C6(){ note_dtor("S1346C6", this);} // tgen
S1346C6 ::S1346C6(){ note_ctor("S1346C6", this);} // tgen

static void Test_S1346C6()
{
  extern Class_Descriptor cd_S1346C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1346C6, buf);
    S1346C6 *dp, &lv = *(dp=new (buf) S1346C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1346C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C6)");
    test_class_info(&lv, &cd_S1346C6);
    dp->~S1346C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C6(Test_S1346C6, "S1346C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1346C6C1Ev();
extern void _ZN7S1346C6D1Ev();
Name_Map name_map_S1346C6[] = {
  NSPAIR(_ZN7S1346C6C1Ev),
  NSPAIR(_ZN7S1346C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1346C6[];
extern void _ZN7S1346C63v84Ev();
extern void _ZN7S1346C63v85Ev();
extern void _ZN7S1346C63v86Ev();
extern void _ZN7S1346C63v87Ev();
extern void _ZN7S1346C63v88Ev();
extern void _ZN7S1346C63v89Ev();
extern void _ZN7S1346C63v90Ev();
extern void _ZN7S1346C63v91Ev();
extern void _ZN7S1346C63v92Ev();
extern void _ZN7S1346C63v93Ev();
extern void _ZN7S1346C63v94Ev();
extern void _ZN7S1346C63v95Ev();
extern void _ZN7S1346C63v96Ev();
extern void _ZN7S1346C63v97Ev();
extern void _ZN7S1346C63v98Ev();
extern void _ZN7S1346C63v99Ev();
static  VTBL_ENTRY vtc_S1346C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C6[0]),
  (VTBL_ENTRY)&_ZN7S1346C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v99Ev,
};
extern VTBL_ENTRY _ZTI7S1346C6[];
extern  VTBL_ENTRY _ZTV7S1346C6[];
Class_Descriptor cd_S1346C6 = {  "S1346C6", // class name
  0,0,//no base classes
  &(vtc_S1346C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1346C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1346C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C7  {
  virtual void  v100(); // _ZN7S1346C74v100Ev
  virtual void  v101(); // _ZN7S1346C74v101Ev
  virtual void  v102(); // _ZN7S1346C74v102Ev
  virtual void  v103(); // _ZN7S1346C74v103Ev
  virtual void  v104(); // _ZN7S1346C74v104Ev
  virtual void  v105(); // _ZN7S1346C74v105Ev
  virtual void  v106(); // _ZN7S1346C74v106Ev
  virtual void  v107(); // _ZN7S1346C74v107Ev
  virtual void  v108(); // _ZN7S1346C74v108Ev
  ~S1346C7(); // tgen
  S1346C7(); // tgen
};
//SIG(-1 S1346C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1346C7 ::v100(){vfunc_called(this, "_ZN7S1346C74v100Ev");}
void  S1346C7 ::v101(){vfunc_called(this, "_ZN7S1346C74v101Ev");}
void  S1346C7 ::v102(){vfunc_called(this, "_ZN7S1346C74v102Ev");}
void  S1346C7 ::v103(){vfunc_called(this, "_ZN7S1346C74v103Ev");}
void  S1346C7 ::v104(){vfunc_called(this, "_ZN7S1346C74v104Ev");}
void  S1346C7 ::v105(){vfunc_called(this, "_ZN7S1346C74v105Ev");}
void  S1346C7 ::v106(){vfunc_called(this, "_ZN7S1346C74v106Ev");}
void  S1346C7 ::v107(){vfunc_called(this, "_ZN7S1346C74v107Ev");}
void  S1346C7 ::v108(){vfunc_called(this, "_ZN7S1346C74v108Ev");}
S1346C7 ::~S1346C7(){ note_dtor("S1346C7", this);} // tgen
S1346C7 ::S1346C7(){ note_ctor("S1346C7", this);} // tgen

static void Test_S1346C7()
{
  extern Class_Descriptor cd_S1346C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1346C7, buf);
    S1346C7 *dp, &lv = *(dp=new (buf) S1346C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1346C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C7)");
    test_class_info(&lv, &cd_S1346C7);
    dp->~S1346C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C7(Test_S1346C7, "S1346C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1346C7C1Ev();
extern void _ZN7S1346C7D1Ev();
Name_Map name_map_S1346C7[] = {
  NSPAIR(_ZN7S1346C7C1Ev),
  NSPAIR(_ZN7S1346C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1346C7[];
extern void _ZN7S1346C74v100Ev();
extern void _ZN7S1346C74v101Ev();
extern void _ZN7S1346C74v102Ev();
extern void _ZN7S1346C74v103Ev();
extern void _ZN7S1346C74v104Ev();
extern void _ZN7S1346C74v105Ev();
extern void _ZN7S1346C74v106Ev();
extern void _ZN7S1346C74v107Ev();
extern void _ZN7S1346C74v108Ev();
static  VTBL_ENTRY vtc_S1346C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C7[0]),
  (VTBL_ENTRY)&_ZN7S1346C74v100Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v101Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v108Ev,
};
extern VTBL_ENTRY _ZTI7S1346C7[];
extern  VTBL_ENTRY _ZTV7S1346C7[];
Class_Descriptor cd_S1346C7 = {  "S1346C7", // class name
  0,0,//no base classes
  &(vtc_S1346C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1346C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1346C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C3  : S1346C4 , S1346C6 , S1346C7 {
  void *s1346c3f0;
  ::S79C39_nt s1346c3f1;
  unsigned int s1346c3f2:1;
  unsigned int s1346c3f3:1;
  unsigned int s1346c3f4:1;
  unsigned int s1346c3f5:1;
  virtual  ~S1346C3(); // _ZN7S1346C3D1Ev
  virtual void  v109(); // _ZN7S1346C34v109Ev
  virtual void  v110(); // _ZN7S1346C34v110Ev
  virtual void  v111(); // _ZN7S1346C34v111Ev
  virtual void  v112(); // _ZN7S1346C34v112Ev
  virtual void  v113(); // _ZN7S1346C34v113Ev
  virtual void  v114(); // _ZN7S1346C34v114Ev
  virtual void  v115(); // _ZN7S1346C34v115Ev
  virtual void  v116(); // _ZN7S1346C34v116Ev
  virtual void  v117(); // _ZN7S1346C34v117Ev
  virtual void  v118(); // _ZN7S1346C34v118Ev
  virtual void  v119(); // _ZN7S1346C34v119Ev
  virtual void  v120(); // _ZN7S1346C34v120Ev
  virtual void  v121(); // _ZN7S1346C34v121Ev
  virtual void  v122(); // _ZN7S1346C34v122Ev
  virtual void  v123(); // _ZN7S1346C34v123Ev
  virtual void  v124(); // _ZN7S1346C34v124Ev
  virtual void  v125(); // _ZN7S1346C34v125Ev
  virtual void  v126(); // _ZN7S1346C34v126Ev
  virtual void  v127(); // _ZN7S1346C34v127Ev
  virtual void  v128(); // _ZN7S1346C34v128Ev
  virtual void  v129(); // _ZN7S1346C34v129Ev
  virtual void  v130(); // _ZN7S1346C34v130Ev
  virtual void  v131(); // _ZN7S1346C34v131Ev
  virtual void  v132(); // _ZN7S1346C34v132Ev
  S1346C3(); // tgen
};
//SIG(-1 S1346C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1346C3 ::~S1346C3(){ note_dtor("S1346C3", this);}
void  S1346C3 ::v109(){vfunc_called(this, "_ZN7S1346C34v109Ev");}
void  S1346C3 ::v110(){vfunc_called(this, "_ZN7S1346C34v110Ev");}
void  S1346C3 ::v111(){vfunc_called(this, "_ZN7S1346C34v111Ev");}
void  S1346C3 ::v112(){vfunc_called(this, "_ZN7S1346C34v112Ev");}
void  S1346C3 ::v113(){vfunc_called(this, "_ZN7S1346C34v113Ev");}
void  S1346C3 ::v114(){vfunc_called(this, "_ZN7S1346C34v114Ev");}
void  S1346C3 ::v115(){vfunc_called(this, "_ZN7S1346C34v115Ev");}
void  S1346C3 ::v116(){vfunc_called(this, "_ZN7S1346C34v116Ev");}
void  S1346C3 ::v117(){vfunc_called(this, "_ZN7S1346C34v117Ev");}
void  S1346C3 ::v118(){vfunc_called(this, "_ZN7S1346C34v118Ev");}
void  S1346C3 ::v119(){vfunc_called(this, "_ZN7S1346C34v119Ev");}
void  S1346C3 ::v120(){vfunc_called(this, "_ZN7S1346C34v120Ev");}
void  S1346C3 ::v121(){vfunc_called(this, "_ZN7S1346C34v121Ev");}
void  S1346C3 ::v122(){vfunc_called(this, "_ZN7S1346C34v122Ev");}
void  S1346C3 ::v123(){vfunc_called(this, "_ZN7S1346C34v123Ev");}
void  S1346C3 ::v124(){vfunc_called(this, "_ZN7S1346C34v124Ev");}
void  S1346C3 ::v125(){vfunc_called(this, "_ZN7S1346C34v125Ev");}
void  S1346C3 ::v126(){vfunc_called(this, "_ZN7S1346C34v126Ev");}
void  S1346C3 ::v127(){vfunc_called(this, "_ZN7S1346C34v127Ev");}
void  S1346C3 ::v128(){vfunc_called(this, "_ZN7S1346C34v128Ev");}
void  S1346C3 ::v129(){vfunc_called(this, "_ZN7S1346C34v129Ev");}
void  S1346C3 ::v130(){vfunc_called(this, "_ZN7S1346C34v130Ev");}
void  S1346C3 ::v131(){vfunc_called(this, "_ZN7S1346C34v131Ev");}
void  S1346C3 ::v132(){vfunc_called(this, "_ZN7S1346C34v132Ev");}
S1346C3 ::S1346C3(){ note_ctor("S1346C3", this);} // tgen

static void Test_S1346C3()
{
  extern Class_Descriptor cd_S1346C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1346C3, buf);
    S1346C3 *dp, &lv = *(dp=new (buf) S1346C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1346C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C3)");
    check_base_class_offset(lv, (S1346C4*), 0, "S1346C3");
    check_base_class_offset(lv, (S1346C6*), ABISELECT(96,60), "S1346C3");
    check_base_class_offset(lv, (S1346C7*), ABISELECT(104,64), "S1346C3");
    check_field_offset(lv, s1346c3f0, ABISELECT(112,68), "S1346C3.s1346c3f0");
    check_field_offset(lv, s1346c3f1, ABISELECT(120,72), "S1346C3.s1346c3f1");
    set_bf_and_test(lv, s1346c3f2, ABISELECT(136,84), 0, 1, 1, "S1346C3");
    set_bf_and_test(lv, s1346c3f3, ABISELECT(136,84), 1, 1, 1, "S1346C3");
    set_bf_and_test(lv, s1346c3f4, ABISELECT(136,84), 2, 1, 1, "S1346C3");
    set_bf_and_test(lv, s1346c3f5, ABISELECT(136,84), 3, 1, 1, "S1346C3");
    test_class_info(&lv, &cd_S1346C3);
    dp->~S1346C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C3(Test_S1346C3, "S1346C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1346C3C1Ev();
extern void _ZN7S1346C3D1Ev();
Name_Map name_map_S1346C3[] = {
  NSPAIR(_ZN7S1346C3C1Ev),
  NSPAIR(_ZN7S1346C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1346C4;
extern VTBL_ENTRY _ZTI7S1346C4[];
extern  VTBL_ENTRY _ZTV7S1346C4[];
extern Class_Descriptor cd_S1346C6;
extern VTBL_ENTRY _ZTI7S1346C6[];
extern  VTBL_ENTRY _ZTV7S1346C6[];
extern Class_Descriptor cd_S1346C7;
extern VTBL_ENTRY _ZTI7S1346C7[];
extern  VTBL_ENTRY _ZTV7S1346C7[];
static Base_Class bases_S1346C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1346C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1346C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1346C3[];
extern void _ZN7S1346C3D1Ev();
extern void _ZN7S1346C3D0Ev();
extern void _ZN7S1346C43v20Ev();
extern void _ZN7S1346C43v21Ev();
extern void _ZN7S1346C43v22Ev();
extern void _ZN7S1346C43v23Ev();
extern void _ZN7S1346C43v24Ev();
extern void _ZN7S1346C43v25Ev();
extern void _ZN7S1346C43v26Ev();
extern void _ZN7S1346C43v27Ev();
extern void _ZN7S1346C43v28Ev();
extern void _ZN7S1346C43v29Ev();
extern void _ZN7S1346C43v30Ev();
extern void _ZN7S1346C43v31Ev();
extern void _ZN7S1346C43v32Ev();
extern void _ZN7S1346C43v33Ev();
extern void _ZN7S1346C43v34Ev();
extern void _ZN7S1346C43v35Ev();
extern void _ZN7S1346C43v36Ev();
extern void _ZN7S1346C43v37Ev();
extern void _ZN7S1346C43v38Ev();
extern void _ZN7S1346C43v39Ev();
extern void _ZN7S1346C43v40Ev();
extern void _ZN7S1346C43v41Ev();
extern void _ZN7S1346C43v42Ev();
extern void _ZN7S1346C43v43Ev();
extern void _ZN7S1346C43v44Ev();
extern void _ZN7S1346C43v45Ev();
extern void _ZN7S1346C43v46Ev();
extern void _ZN7S1346C43v47Ev();
extern void _ZN7S1346C43v48Ev();
extern void _ZN7S1346C43v49Ev();
extern void _ZN7S1346C43v50Ev();
extern void _ZN7S1346C43v51Ev();
extern void _ZN7S1346C43v52Ev();
extern void _ZN7S1346C43v53Ev();
extern void _ZN7S1346C43v54Ev();
extern void _ZN7S1346C43v55Ev();
extern void _ZN7S1346C43v56Ev();
extern void _ZN7S1346C43v57Ev();
extern void _ZN7S1346C43v58Ev();
extern void _ZN7S1346C43v59Ev();
extern void _ZN7S1346C43v60Ev();
extern void _ZN7S1346C43v61Ev();
extern void _ZN7S1346C43v62Ev();
extern void _ZN7S1346C43v63Ev();
extern void _ZN7S1346C43v64Ev();
extern void _ZN7S1346C43v65Ev();
extern void _ZN7S1346C43v66Ev();
extern void _ZN7S1346C43v67Ev();
extern void _ZN7S1346C43v68Ev();
extern void _ZN7S1346C43v69Ev();
extern void _ZN7S1346C43v70Ev();
extern void _ZN7S1346C43v71Ev();
extern void _ZN7S1346C43v72Ev();
extern void _ZN7S1346C43v73Ev();
extern void _ZN7S1346C43v74Ev();
extern void _ZN7S1346C43v75Ev();
extern void _ZN7S1346C43v76Ev();
extern void _ZN7S1346C43v77Ev();
extern void _ZN7S1346C43v78Ev();
extern void _ZN7S1346C43v79Ev();
extern void _ZN7S1346C43v80Ev();
extern void _ZN7S1346C43v81Ev();
extern void _ZN7S1346C43v82Ev();
extern void _ZN7S1346C43v83Ev();
extern void _ZN7S1346C34v109Ev();
extern void _ZN7S1346C34v110Ev();
extern void _ZN7S1346C34v111Ev();
extern void _ZN7S1346C34v112Ev();
extern void _ZN7S1346C34v113Ev();
extern void _ZN7S1346C34v114Ev();
extern void _ZN7S1346C34v115Ev();
extern void _ZN7S1346C34v116Ev();
extern void _ZN7S1346C34v117Ev();
extern void _ZN7S1346C34v118Ev();
extern void _ZN7S1346C34v119Ev();
extern void _ZN7S1346C34v120Ev();
extern void _ZN7S1346C34v121Ev();
extern void _ZN7S1346C34v122Ev();
extern void _ZN7S1346C34v123Ev();
extern void _ZN7S1346C34v124Ev();
extern void _ZN7S1346C34v125Ev();
extern void _ZN7S1346C34v126Ev();
extern void _ZN7S1346C34v127Ev();
extern void _ZN7S1346C34v128Ev();
extern void _ZN7S1346C34v129Ev();
extern void _ZN7S1346C34v130Ev();
extern void _ZN7S1346C34v131Ev();
extern void _ZN7S1346C34v132Ev();
extern void _ZN7S1346C63v84Ev();
extern void _ZN7S1346C63v85Ev();
extern void _ZN7S1346C63v86Ev();
extern void _ZN7S1346C63v87Ev();
extern void _ZN7S1346C63v88Ev();
extern void _ZN7S1346C63v89Ev();
extern void _ZN7S1346C63v90Ev();
extern void _ZN7S1346C63v91Ev();
extern void _ZN7S1346C63v92Ev();
extern void _ZN7S1346C63v93Ev();
extern void _ZN7S1346C63v94Ev();
extern void _ZN7S1346C63v95Ev();
extern void _ZN7S1346C63v96Ev();
extern void _ZN7S1346C63v97Ev();
extern void _ZN7S1346C63v98Ev();
extern void _ZN7S1346C63v99Ev();
extern void _ZN7S1346C74v100Ev();
extern void _ZN7S1346C74v101Ev();
extern void _ZN7S1346C74v102Ev();
extern void _ZN7S1346C74v103Ev();
extern void _ZN7S1346C74v104Ev();
extern void _ZN7S1346C74v105Ev();
extern void _ZN7S1346C74v106Ev();
extern void _ZN7S1346C74v107Ev();
extern void _ZN7S1346C74v108Ev();
static  VTBL_ENTRY vtc_S1346C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C3[0]),
  (VTBL_ENTRY)&_ZN7S1346C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1346C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v132Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1346C3[0]),
  (VTBL_ENTRY)&_ZN7S1346C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v99Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1346C3[0]),
  (VTBL_ENTRY)&_ZN7S1346C74v100Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v101Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v108Ev,
};
extern VTBL_ENTRY _ZTI7S1346C3[];
extern  VTBL_ENTRY _ZTV7S1346C3[];
Class_Descriptor cd_S1346C3 = {  "S1346C3", // class name
  bases_S1346C3, 3,
  &(vtc_S1346C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1346C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1346C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C2  : S1346C3 {
  ::S3262C11_nt s1346c2f0;
  int s1346c2f1;
  virtual  ~S1346C2(); // _ZN7S1346C2D1Ev
  virtual void  v133(); // _ZN7S1346C24v133Ev
  virtual void  v134(); // _ZN7S1346C24v134Ev
  virtual void  v135(); // _ZN7S1346C24v135Ev
  virtual void  v136(); // _ZN7S1346C24v136Ev
  virtual void  v137(); // _ZN7S1346C24v137Ev
  virtual void  v138(); // _ZN7S1346C24v138Ev
  virtual void  v139(); // _ZN7S1346C24v139Ev
  virtual void  v140(); // _ZN7S1346C24v140Ev
  virtual void  v141(); // _ZN7S1346C24v141Ev
  virtual void  v142(); // _ZN7S1346C24v142Ev
  virtual void  v143(); // _ZN7S1346C24v143Ev
  virtual void  v144(); // _ZN7S1346C24v144Ev
  virtual void  v145(); // _ZN7S1346C24v145Ev
  virtual void  v146(); // _ZN7S1346C24v146Ev
  virtual void  v147(); // _ZN7S1346C24v147Ev
  virtual void  v148(); // _ZN7S1346C24v148Ev
  virtual void  v149(); // _ZN7S1346C24v149Ev
  virtual void  v150(); // _ZN7S1346C24v150Ev
  virtual void  v151(); // _ZN7S1346C24v151Ev
  virtual void  v152(); // _ZN7S1346C24v152Ev
  virtual void  v153(); // _ZN7S1346C24v153Ev
  virtual void  v154(); // _ZN7S1346C24v154Ev
  virtual void  v155(); // _ZN7S1346C24v155Ev
  virtual void  v156(); // _ZN7S1346C24v156Ev
  virtual void  v157(); // _ZN7S1346C24v157Ev
  virtual void  v158(); // _ZN7S1346C24v158Ev
  virtual void  v159(); // _ZN7S1346C24v159Ev
  S1346C2(); // tgen
};
//SIG(-1 S1346C2) C1{ BC2{ BC3{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107} BC6{ v108 v109 v110 v111 v112 v113 v114 v115 v116} vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1346C2 ::~S1346C2(){ note_dtor("S1346C2", this);}
void  S1346C2 ::v133(){vfunc_called(this, "_ZN7S1346C24v133Ev");}
void  S1346C2 ::v134(){vfunc_called(this, "_ZN7S1346C24v134Ev");}
void  S1346C2 ::v135(){vfunc_called(this, "_ZN7S1346C24v135Ev");}
void  S1346C2 ::v136(){vfunc_called(this, "_ZN7S1346C24v136Ev");}
void  S1346C2 ::v137(){vfunc_called(this, "_ZN7S1346C24v137Ev");}
void  S1346C2 ::v138(){vfunc_called(this, "_ZN7S1346C24v138Ev");}
void  S1346C2 ::v139(){vfunc_called(this, "_ZN7S1346C24v139Ev");}
void  S1346C2 ::v140(){vfunc_called(this, "_ZN7S1346C24v140Ev");}
void  S1346C2 ::v141(){vfunc_called(this, "_ZN7S1346C24v141Ev");}
void  S1346C2 ::v142(){vfunc_called(this, "_ZN7S1346C24v142Ev");}
void  S1346C2 ::v143(){vfunc_called(this, "_ZN7S1346C24v143Ev");}
void  S1346C2 ::v144(){vfunc_called(this, "_ZN7S1346C24v144Ev");}
void  S1346C2 ::v145(){vfunc_called(this, "_ZN7S1346C24v145Ev");}
void  S1346C2 ::v146(){vfunc_called(this, "_ZN7S1346C24v146Ev");}
void  S1346C2 ::v147(){vfunc_called(this, "_ZN7S1346C24v147Ev");}
void  S1346C2 ::v148(){vfunc_called(this, "_ZN7S1346C24v148Ev");}
void  S1346C2 ::v149(){vfunc_called(this, "_ZN7S1346C24v149Ev");}
void  S1346C2 ::v150(){vfunc_called(this, "_ZN7S1346C24v150Ev");}
void  S1346C2 ::v151(){vfunc_called(this, "_ZN7S1346C24v151Ev");}
void  S1346C2 ::v152(){vfunc_called(this, "_ZN7S1346C24v152Ev");}
void  S1346C2 ::v153(){vfunc_called(this, "_ZN7S1346C24v153Ev");}
void  S1346C2 ::v154(){vfunc_called(this, "_ZN7S1346C24v154Ev");}
void  S1346C2 ::v155(){vfunc_called(this, "_ZN7S1346C24v155Ev");}
void  S1346C2 ::v156(){vfunc_called(this, "_ZN7S1346C24v156Ev");}
void  S1346C2 ::v157(){vfunc_called(this, "_ZN7S1346C24v157Ev");}
void  S1346C2 ::v158(){vfunc_called(this, "_ZN7S1346C24v158Ev");}
void  S1346C2 ::v159(){vfunc_called(this, "_ZN7S1346C24v159Ev");}
S1346C2 ::S1346C2(){ note_ctor("S1346C2", this);} // tgen

static void Test_S1346C2()
{
  extern Class_Descriptor cd_S1346C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1346C2, buf);
    S1346C2 *dp, &lv = *(dp=new (buf) S1346C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1346C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C2)");
    check_base_class_offset(lv, (S1346C4*)(S1346C3*), 0, "S1346C2");
    check_base_class_offset(lv, (S1346C6*)(S1346C3*), ABISELECT(96,60), "S1346C2");
    check_base_class_offset(lv, (S1346C7*)(S1346C3*), ABISELECT(104,64), "S1346C2");
    check_base_class_offset(lv, (S1346C3*), 0, "S1346C2");
    check_field_offset(lv, s1346c2f0, ABISELECT(144,88), "S1346C2.s1346c2f0");
    check_field_offset(lv, s1346c2f1, ABISELECT(168,104), "S1346C2.s1346c2f1");
    test_class_info(&lv, &cd_S1346C2);
    dp->~S1346C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C2(Test_S1346C2, "S1346C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1346C2C1Ev();
extern void _ZN7S1346C2D1Ev();
Name_Map name_map_S1346C2[] = {
  NSPAIR(_ZN7S1346C2C1Ev),
  NSPAIR(_ZN7S1346C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1346C4;
extern VTBL_ENTRY _ZTI7S1346C4[];
extern  VTBL_ENTRY _ZTV7S1346C4[];
extern Class_Descriptor cd_S1346C6;
extern VTBL_ENTRY _ZTI7S1346C6[];
extern  VTBL_ENTRY _ZTV7S1346C6[];
extern Class_Descriptor cd_S1346C7;
extern VTBL_ENTRY _ZTI7S1346C7[];
extern  VTBL_ENTRY _ZTV7S1346C7[];
extern Class_Descriptor cd_S1346C3;
extern VTBL_ENTRY _ZTI7S1346C3[];
extern  VTBL_ENTRY _ZTV7S1346C3[];
static Base_Class bases_S1346C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C6,    ABISELECT(96,60), //bcp->offset
    119, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C7,    ABISELECT(104,64), //bcp->offset
    137, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1346C2[];
extern void _ZN7S1346C2D1Ev();
extern void _ZN7S1346C2D0Ev();
extern void _ZN7S1346C43v20Ev();
extern void _ZN7S1346C43v21Ev();
extern void _ZN7S1346C43v22Ev();
extern void _ZN7S1346C43v23Ev();
extern void _ZN7S1346C43v24Ev();
extern void _ZN7S1346C43v25Ev();
extern void _ZN7S1346C43v26Ev();
extern void _ZN7S1346C43v27Ev();
extern void _ZN7S1346C43v28Ev();
extern void _ZN7S1346C43v29Ev();
extern void _ZN7S1346C43v30Ev();
extern void _ZN7S1346C43v31Ev();
extern void _ZN7S1346C43v32Ev();
extern void _ZN7S1346C43v33Ev();
extern void _ZN7S1346C43v34Ev();
extern void _ZN7S1346C43v35Ev();
extern void _ZN7S1346C43v36Ev();
extern void _ZN7S1346C43v37Ev();
extern void _ZN7S1346C43v38Ev();
extern void _ZN7S1346C43v39Ev();
extern void _ZN7S1346C43v40Ev();
extern void _ZN7S1346C43v41Ev();
extern void _ZN7S1346C43v42Ev();
extern void _ZN7S1346C43v43Ev();
extern void _ZN7S1346C43v44Ev();
extern void _ZN7S1346C43v45Ev();
extern void _ZN7S1346C43v46Ev();
extern void _ZN7S1346C43v47Ev();
extern void _ZN7S1346C43v48Ev();
extern void _ZN7S1346C43v49Ev();
extern void _ZN7S1346C43v50Ev();
extern void _ZN7S1346C43v51Ev();
extern void _ZN7S1346C43v52Ev();
extern void _ZN7S1346C43v53Ev();
extern void _ZN7S1346C43v54Ev();
extern void _ZN7S1346C43v55Ev();
extern void _ZN7S1346C43v56Ev();
extern void _ZN7S1346C43v57Ev();
extern void _ZN7S1346C43v58Ev();
extern void _ZN7S1346C43v59Ev();
extern void _ZN7S1346C43v60Ev();
extern void _ZN7S1346C43v61Ev();
extern void _ZN7S1346C43v62Ev();
extern void _ZN7S1346C43v63Ev();
extern void _ZN7S1346C43v64Ev();
extern void _ZN7S1346C43v65Ev();
extern void _ZN7S1346C43v66Ev();
extern void _ZN7S1346C43v67Ev();
extern void _ZN7S1346C43v68Ev();
extern void _ZN7S1346C43v69Ev();
extern void _ZN7S1346C43v70Ev();
extern void _ZN7S1346C43v71Ev();
extern void _ZN7S1346C43v72Ev();
extern void _ZN7S1346C43v73Ev();
extern void _ZN7S1346C43v74Ev();
extern void _ZN7S1346C43v75Ev();
extern void _ZN7S1346C43v76Ev();
extern void _ZN7S1346C43v77Ev();
extern void _ZN7S1346C43v78Ev();
extern void _ZN7S1346C43v79Ev();
extern void _ZN7S1346C43v80Ev();
extern void _ZN7S1346C43v81Ev();
extern void _ZN7S1346C43v82Ev();
extern void _ZN7S1346C43v83Ev();
extern void _ZN7S1346C34v109Ev();
extern void _ZN7S1346C34v110Ev();
extern void _ZN7S1346C34v111Ev();
extern void _ZN7S1346C34v112Ev();
extern void _ZN7S1346C34v113Ev();
extern void _ZN7S1346C34v114Ev();
extern void _ZN7S1346C34v115Ev();
extern void _ZN7S1346C34v116Ev();
extern void _ZN7S1346C34v117Ev();
extern void _ZN7S1346C34v118Ev();
extern void _ZN7S1346C34v119Ev();
extern void _ZN7S1346C34v120Ev();
extern void _ZN7S1346C34v121Ev();
extern void _ZN7S1346C34v122Ev();
extern void _ZN7S1346C34v123Ev();
extern void _ZN7S1346C34v124Ev();
extern void _ZN7S1346C34v125Ev();
extern void _ZN7S1346C34v126Ev();
extern void _ZN7S1346C34v127Ev();
extern void _ZN7S1346C34v128Ev();
extern void _ZN7S1346C34v129Ev();
extern void _ZN7S1346C34v130Ev();
extern void _ZN7S1346C34v131Ev();
extern void _ZN7S1346C34v132Ev();
extern void _ZN7S1346C24v133Ev();
extern void _ZN7S1346C24v134Ev();
extern void _ZN7S1346C24v135Ev();
extern void _ZN7S1346C24v136Ev();
extern void _ZN7S1346C24v137Ev();
extern void _ZN7S1346C24v138Ev();
extern void _ZN7S1346C24v139Ev();
extern void _ZN7S1346C24v140Ev();
extern void _ZN7S1346C24v141Ev();
extern void _ZN7S1346C24v142Ev();
extern void _ZN7S1346C24v143Ev();
extern void _ZN7S1346C24v144Ev();
extern void _ZN7S1346C24v145Ev();
extern void _ZN7S1346C24v146Ev();
extern void _ZN7S1346C24v147Ev();
extern void _ZN7S1346C24v148Ev();
extern void _ZN7S1346C24v149Ev();
extern void _ZN7S1346C24v150Ev();
extern void _ZN7S1346C24v151Ev();
extern void _ZN7S1346C24v152Ev();
extern void _ZN7S1346C24v153Ev();
extern void _ZN7S1346C24v154Ev();
extern void _ZN7S1346C24v155Ev();
extern void _ZN7S1346C24v156Ev();
extern void _ZN7S1346C24v157Ev();
extern void _ZN7S1346C24v158Ev();
extern void _ZN7S1346C24v159Ev();
extern void _ZN7S1346C63v84Ev();
extern void _ZN7S1346C63v85Ev();
extern void _ZN7S1346C63v86Ev();
extern void _ZN7S1346C63v87Ev();
extern void _ZN7S1346C63v88Ev();
extern void _ZN7S1346C63v89Ev();
extern void _ZN7S1346C63v90Ev();
extern void _ZN7S1346C63v91Ev();
extern void _ZN7S1346C63v92Ev();
extern void _ZN7S1346C63v93Ev();
extern void _ZN7S1346C63v94Ev();
extern void _ZN7S1346C63v95Ev();
extern void _ZN7S1346C63v96Ev();
extern void _ZN7S1346C63v97Ev();
extern void _ZN7S1346C63v98Ev();
extern void _ZN7S1346C63v99Ev();
extern void _ZN7S1346C74v100Ev();
extern void _ZN7S1346C74v101Ev();
extern void _ZN7S1346C74v102Ev();
extern void _ZN7S1346C74v103Ev();
extern void _ZN7S1346C74v104Ev();
extern void _ZN7S1346C74v105Ev();
extern void _ZN7S1346C74v106Ev();
extern void _ZN7S1346C74v107Ev();
extern void _ZN7S1346C74v108Ev();
static  VTBL_ENTRY vtc_S1346C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C2[0]),
  (VTBL_ENTRY)&_ZN7S1346C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1346C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v149Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v150Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v151Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v152Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v153Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v154Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v155Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v156Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v157Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v158Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v159Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1346C2[0]),
  (VTBL_ENTRY)&_ZN7S1346C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v99Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1346C2[0]),
  (VTBL_ENTRY)&_ZN7S1346C74v100Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v101Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v108Ev,
};
extern VTBL_ENTRY _ZTI7S1346C2[];
extern  VTBL_ENTRY _ZTV7S1346C2[];
Class_Descriptor cd_S1346C2 = {  "S1346C2", // class name
  bases_S1346C2, 4,
  &(vtc_S1346C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1346C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1346C2),148, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1346C1  : S1346C2 {
  ::S79C44 s1346c1f0;
  unsigned int s1346c1f1:1;
  unsigned int s1346c1f2:1;
  virtual  ~S1346C1(); // _ZN7S1346C1D1Ev
  virtual void  v1(); // _ZN7S1346C12v1Ev
  virtual void  v2(); // _ZN7S1346C12v2Ev
  virtual void  v3(); // _ZN7S1346C12v3Ev
  virtual void  v4(); // _ZN7S1346C12v4Ev
  virtual void  v5(); // _ZN7S1346C12v5Ev
  virtual void  v6(); // _ZN7S1346C12v6Ev
  virtual void  v7(); // _ZN7S1346C12v7Ev
  virtual void  v8(); // _ZN7S1346C12v8Ev
  virtual void  v9(); // _ZN7S1346C12v9Ev
  virtual void  v10(); // _ZN7S1346C13v10Ev
  virtual void  v11(); // _ZN7S1346C13v11Ev
  virtual void  v12(); // _ZN7S1346C13v12Ev
  virtual void  v13(); // _ZN7S1346C13v13Ev
  virtual void  v14(); // _ZN7S1346C13v14Ev
  virtual void  v15(); // _ZN7S1346C13v15Ev
  virtual void  v16(); // _ZN7S1346C13v16Ev
  virtual void  v17(); // _ZN7S1346C13v17Ev
  virtual void  v18(); // _ZN7S1346C13v18Ev
  virtual void  v19(); // _ZN7S1346C13v19Ev
  S1346C1(); // tgen
};
//SIG(1 S1346C1) C1{ BC2{ BC3{ BC4{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99} BC7{ v100 v101 v102 v103 v104 v105 v106 v107 v108} vd v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC13 Fi:1 Fi:1}


 S1346C1 ::~S1346C1(){ note_dtor("S1346C1", this);}
void  S1346C1 ::v1(){vfunc_called(this, "_ZN7S1346C12v1Ev");}
void  S1346C1 ::v2(){vfunc_called(this, "_ZN7S1346C12v2Ev");}
void  S1346C1 ::v3(){vfunc_called(this, "_ZN7S1346C12v3Ev");}
void  S1346C1 ::v4(){vfunc_called(this, "_ZN7S1346C12v4Ev");}
void  S1346C1 ::v5(){vfunc_called(this, "_ZN7S1346C12v5Ev");}
void  S1346C1 ::v6(){vfunc_called(this, "_ZN7S1346C12v6Ev");}
void  S1346C1 ::v7(){vfunc_called(this, "_ZN7S1346C12v7Ev");}
void  S1346C1 ::v8(){vfunc_called(this, "_ZN7S1346C12v8Ev");}
void  S1346C1 ::v9(){vfunc_called(this, "_ZN7S1346C12v9Ev");}
void  S1346C1 ::v10(){vfunc_called(this, "_ZN7S1346C13v10Ev");}
void  S1346C1 ::v11(){vfunc_called(this, "_ZN7S1346C13v11Ev");}
void  S1346C1 ::v12(){vfunc_called(this, "_ZN7S1346C13v12Ev");}
void  S1346C1 ::v13(){vfunc_called(this, "_ZN7S1346C13v13Ev");}
void  S1346C1 ::v14(){vfunc_called(this, "_ZN7S1346C13v14Ev");}
void  S1346C1 ::v15(){vfunc_called(this, "_ZN7S1346C13v15Ev");}
void  S1346C1 ::v16(){vfunc_called(this, "_ZN7S1346C13v16Ev");}
void  S1346C1 ::v17(){vfunc_called(this, "_ZN7S1346C13v17Ev");}
void  S1346C1 ::v18(){vfunc_called(this, "_ZN7S1346C13v18Ev");}
void  S1346C1 ::v19(){vfunc_called(this, "_ZN7S1346C13v19Ev");}
S1346C1 ::S1346C1(){ note_ctor("S1346C1", this);} // tgen

static void Test_S1346C1()
{
  extern Class_Descriptor cd_S1346C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,32)];
    init_test(&cd_S1346C1, buf);
    S1346C1 *dp, &lv = *(dp=new (buf) S1346C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,124), "sizeof(S1346C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1346C1)");
    check_base_class_offset(lv, (S1346C4*)(S1346C3*)(S1346C2*), 0, "S1346C1");
    check_base_class_offset(lv, (S1346C6*)(S1346C3*)(S1346C2*), ABISELECT(96,60), "S1346C1");
    check_base_class_offset(lv, (S1346C7*)(S1346C3*)(S1346C2*), ABISELECT(104,64), "S1346C1");
    check_base_class_offset(lv, (S1346C3*)(S1346C2*), 0, "S1346C1");
    check_base_class_offset(lv, (S1346C2*), 0, "S1346C1");
    check_field_offset(lv, s1346c1f0, ABISELECT(176,108), "S1346C1.s1346c1f0");
    set_bf_and_test(lv, s1346c1f1, ABISELECT(192,120), 0, 1, 1, "S1346C1");
    set_bf_and_test(lv, s1346c1f2, ABISELECT(192,120), 1, 1, 1, "S1346C1");
    test_class_info(&lv, &cd_S1346C1);
    dp->~S1346C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1346C1(Test_S1346C1, "S1346C1", ABISELECT(200,124));

#else // __cplusplus

extern void _ZN7S1346C1C1Ev();
extern void _ZN7S1346C1D1Ev();
Name_Map name_map_S1346C1[] = {
  NSPAIR(_ZN7S1346C1C1Ev),
  NSPAIR(_ZN7S1346C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1346C4;
extern VTBL_ENTRY _ZTI7S1346C4[];
extern  VTBL_ENTRY _ZTV7S1346C4[];
extern Class_Descriptor cd_S1346C6;
extern VTBL_ENTRY _ZTI7S1346C6[];
extern  VTBL_ENTRY _ZTV7S1346C6[];
extern Class_Descriptor cd_S1346C7;
extern VTBL_ENTRY _ZTI7S1346C7[];
extern  VTBL_ENTRY _ZTV7S1346C7[];
extern Class_Descriptor cd_S1346C3;
extern VTBL_ENTRY _ZTI7S1346C3[];
extern  VTBL_ENTRY _ZTV7S1346C3[];
extern Class_Descriptor cd_S1346C2;
extern VTBL_ENTRY _ZTI7S1346C2[];
extern  VTBL_ENTRY _ZTV7S1346C2[];
static Base_Class bases_S1346C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1346C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C6,    ABISELECT(96,60), //bcp->offset
    138, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C7,    ABISELECT(104,64), //bcp->offset
    156, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1346C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1346C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1346C1[];
extern void _ZN7S1346C1D1Ev();
extern void _ZN7S1346C1D0Ev();
extern void _ZN7S1346C43v20Ev();
extern void _ZN7S1346C43v21Ev();
extern void _ZN7S1346C43v22Ev();
extern void _ZN7S1346C43v23Ev();
extern void _ZN7S1346C43v24Ev();
extern void _ZN7S1346C43v25Ev();
extern void _ZN7S1346C43v26Ev();
extern void _ZN7S1346C43v27Ev();
extern void _ZN7S1346C43v28Ev();
extern void _ZN7S1346C43v29Ev();
extern void _ZN7S1346C43v30Ev();
extern void _ZN7S1346C43v31Ev();
extern void _ZN7S1346C43v32Ev();
extern void _ZN7S1346C43v33Ev();
extern void _ZN7S1346C43v34Ev();
extern void _ZN7S1346C43v35Ev();
extern void _ZN7S1346C43v36Ev();
extern void _ZN7S1346C43v37Ev();
extern void _ZN7S1346C43v38Ev();
extern void _ZN7S1346C43v39Ev();
extern void _ZN7S1346C43v40Ev();
extern void _ZN7S1346C43v41Ev();
extern void _ZN7S1346C43v42Ev();
extern void _ZN7S1346C43v43Ev();
extern void _ZN7S1346C43v44Ev();
extern void _ZN7S1346C43v45Ev();
extern void _ZN7S1346C43v46Ev();
extern void _ZN7S1346C43v47Ev();
extern void _ZN7S1346C43v48Ev();
extern void _ZN7S1346C43v49Ev();
extern void _ZN7S1346C43v50Ev();
extern void _ZN7S1346C43v51Ev();
extern void _ZN7S1346C43v52Ev();
extern void _ZN7S1346C43v53Ev();
extern void _ZN7S1346C43v54Ev();
extern void _ZN7S1346C43v55Ev();
extern void _ZN7S1346C43v56Ev();
extern void _ZN7S1346C43v57Ev();
extern void _ZN7S1346C43v58Ev();
extern void _ZN7S1346C43v59Ev();
extern void _ZN7S1346C43v60Ev();
extern void _ZN7S1346C43v61Ev();
extern void _ZN7S1346C43v62Ev();
extern void _ZN7S1346C43v63Ev();
extern void _ZN7S1346C43v64Ev();
extern void _ZN7S1346C43v65Ev();
extern void _ZN7S1346C43v66Ev();
extern void _ZN7S1346C43v67Ev();
extern void _ZN7S1346C43v68Ev();
extern void _ZN7S1346C43v69Ev();
extern void _ZN7S1346C43v70Ev();
extern void _ZN7S1346C43v71Ev();
extern void _ZN7S1346C43v72Ev();
extern void _ZN7S1346C43v73Ev();
extern void _ZN7S1346C43v74Ev();
extern void _ZN7S1346C43v75Ev();
extern void _ZN7S1346C43v76Ev();
extern void _ZN7S1346C43v77Ev();
extern void _ZN7S1346C43v78Ev();
extern void _ZN7S1346C43v79Ev();
extern void _ZN7S1346C43v80Ev();
extern void _ZN7S1346C43v81Ev();
extern void _ZN7S1346C43v82Ev();
extern void _ZN7S1346C43v83Ev();
extern void _ZN7S1346C34v109Ev();
extern void _ZN7S1346C34v110Ev();
extern void _ZN7S1346C34v111Ev();
extern void _ZN7S1346C34v112Ev();
extern void _ZN7S1346C34v113Ev();
extern void _ZN7S1346C34v114Ev();
extern void _ZN7S1346C34v115Ev();
extern void _ZN7S1346C34v116Ev();
extern void _ZN7S1346C34v117Ev();
extern void _ZN7S1346C34v118Ev();
extern void _ZN7S1346C34v119Ev();
extern void _ZN7S1346C34v120Ev();
extern void _ZN7S1346C34v121Ev();
extern void _ZN7S1346C34v122Ev();
extern void _ZN7S1346C34v123Ev();
extern void _ZN7S1346C34v124Ev();
extern void _ZN7S1346C34v125Ev();
extern void _ZN7S1346C34v126Ev();
extern void _ZN7S1346C34v127Ev();
extern void _ZN7S1346C34v128Ev();
extern void _ZN7S1346C34v129Ev();
extern void _ZN7S1346C34v130Ev();
extern void _ZN7S1346C34v131Ev();
extern void _ZN7S1346C34v132Ev();
extern void _ZN7S1346C24v133Ev();
extern void _ZN7S1346C24v134Ev();
extern void _ZN7S1346C24v135Ev();
extern void _ZN7S1346C24v136Ev();
extern void _ZN7S1346C24v137Ev();
extern void _ZN7S1346C24v138Ev();
extern void _ZN7S1346C24v139Ev();
extern void _ZN7S1346C24v140Ev();
extern void _ZN7S1346C24v141Ev();
extern void _ZN7S1346C24v142Ev();
extern void _ZN7S1346C24v143Ev();
extern void _ZN7S1346C24v144Ev();
extern void _ZN7S1346C24v145Ev();
extern void _ZN7S1346C24v146Ev();
extern void _ZN7S1346C24v147Ev();
extern void _ZN7S1346C24v148Ev();
extern void _ZN7S1346C24v149Ev();
extern void _ZN7S1346C24v150Ev();
extern void _ZN7S1346C24v151Ev();
extern void _ZN7S1346C24v152Ev();
extern void _ZN7S1346C24v153Ev();
extern void _ZN7S1346C24v154Ev();
extern void _ZN7S1346C24v155Ev();
extern void _ZN7S1346C24v156Ev();
extern void _ZN7S1346C24v157Ev();
extern void _ZN7S1346C24v158Ev();
extern void _ZN7S1346C24v159Ev();
extern void _ZN7S1346C12v1Ev();
extern void _ZN7S1346C12v2Ev();
extern void _ZN7S1346C12v3Ev();
extern void _ZN7S1346C12v4Ev();
extern void _ZN7S1346C12v5Ev();
extern void _ZN7S1346C12v6Ev();
extern void _ZN7S1346C12v7Ev();
extern void _ZN7S1346C12v8Ev();
extern void _ZN7S1346C12v9Ev();
extern void _ZN7S1346C13v10Ev();
extern void _ZN7S1346C13v11Ev();
extern void _ZN7S1346C13v12Ev();
extern void _ZN7S1346C13v13Ev();
extern void _ZN7S1346C13v14Ev();
extern void _ZN7S1346C13v15Ev();
extern void _ZN7S1346C13v16Ev();
extern void _ZN7S1346C13v17Ev();
extern void _ZN7S1346C13v18Ev();
extern void _ZN7S1346C13v19Ev();
extern void _ZN7S1346C63v84Ev();
extern void _ZN7S1346C63v85Ev();
extern void _ZN7S1346C63v86Ev();
extern void _ZN7S1346C63v87Ev();
extern void _ZN7S1346C63v88Ev();
extern void _ZN7S1346C63v89Ev();
extern void _ZN7S1346C63v90Ev();
extern void _ZN7S1346C63v91Ev();
extern void _ZN7S1346C63v92Ev();
extern void _ZN7S1346C63v93Ev();
extern void _ZN7S1346C63v94Ev();
extern void _ZN7S1346C63v95Ev();
extern void _ZN7S1346C63v96Ev();
extern void _ZN7S1346C63v97Ev();
extern void _ZN7S1346C63v98Ev();
extern void _ZN7S1346C63v99Ev();
extern void _ZN7S1346C74v100Ev();
extern void _ZN7S1346C74v101Ev();
extern void _ZN7S1346C74v102Ev();
extern void _ZN7S1346C74v103Ev();
extern void _ZN7S1346C74v104Ev();
extern void _ZN7S1346C74v105Ev();
extern void _ZN7S1346C74v106Ev();
extern void _ZN7S1346C74v107Ev();
extern void _ZN7S1346C74v108Ev();
static  VTBL_ENTRY vtc_S1346C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1346C1[0]),
  (VTBL_ENTRY)&_ZN7S1346C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1346C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1346C43v83Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v122Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v123Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v124Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v125Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v126Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v127Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v128Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v129Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v130Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v131Ev,
  (VTBL_ENTRY)&_ZN7S1346C34v132Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v149Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v150Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v151Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v152Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v153Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v154Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v155Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v156Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v157Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v158Ev,
  (VTBL_ENTRY)&_ZN7S1346C24v159Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1346C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v15Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v16Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v17Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v18Ev,
  (VTBL_ENTRY)&_ZN7S1346C13v19Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1346C1[0]),
  (VTBL_ENTRY)&_ZN7S1346C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v88Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v89Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v90Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v91Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v92Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v93Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v94Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v95Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v96Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v97Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v98Ev,
  (VTBL_ENTRY)&_ZN7S1346C63v99Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1346C1[0]),
  (VTBL_ENTRY)&_ZN7S1346C74v100Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v101Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v102Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v103Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v104Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v105Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v106Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v107Ev,
  (VTBL_ENTRY)&_ZN7S1346C74v108Ev,
};
extern VTBL_ENTRY _ZTI7S1346C1[];
extern  VTBL_ENTRY _ZTV7S1346C1[];
Class_Descriptor cd_S1346C1 = {  "S1346C1", // class name
  bases_S1346C1, 5,
  &(vtc_S1346C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,124), // object size
  NSPAIRA(_ZTI7S1346C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1346C1),167, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C4  {
  int s1590c4f0;
  __tsi64 s1590c4f1;
  void *s1590c4f2[4];
  int s1590c4f3[2];
  void *s1590c4f4;
  ::S79C8_nt s1590c4f5;
  void *s1590c4f6[2];
  virtual  ~S1590C4(); // _ZN7S1590C4D1Ev
  virtual void  v9(); // _ZN7S1590C42v9Ev
  virtual void  v10(); // _ZN7S1590C43v10Ev
  virtual void  v11(); // _ZN7S1590C43v11Ev
  virtual void  v12(); // _ZN7S1590C43v12Ev
  virtual void  v13(); // _ZN7S1590C43v13Ev
  virtual void  v14(); // _ZN7S1590C43v14Ev
  virtual void  v15(); // _ZN7S1590C43v15Ev
  virtual void  v16(); // _ZN7S1590C43v16Ev
  virtual void  v17(); // _ZN7S1590C43v17Ev
  virtual void  v18(); // _ZN7S1590C43v18Ev
  virtual void  v19(); // _ZN7S1590C43v19Ev
  virtual void  v20(); // _ZN7S1590C43v20Ev
  virtual void  v21(); // _ZN7S1590C43v21Ev
  virtual void  v22(); // _ZN7S1590C43v22Ev
  virtual void  v23(); // _ZN7S1590C43v23Ev
  virtual void  v24(); // _ZN7S1590C43v24Ev
  virtual void  v25(); // _ZN7S1590C43v25Ev
  virtual void  v26(); // _ZN7S1590C43v26Ev
  virtual void  v27(); // _ZN7S1590C43v27Ev
  virtual void  v28(); // _ZN7S1590C43v28Ev
  virtual void  v29(); // _ZN7S1590C43v29Ev
  virtual void  v30(); // _ZN7S1590C43v30Ev
  virtual void  v31(); // _ZN7S1590C43v31Ev
  virtual void  v32(); // _ZN7S1590C43v32Ev
  virtual void  v33(); // _ZN7S1590C43v33Ev
  virtual void  v34(); // _ZN7S1590C43v34Ev
  virtual void  v35(); // _ZN7S1590C43v35Ev
  virtual void  v36(); // _ZN7S1590C43v36Ev
  virtual void  v37(); // _ZN7S1590C43v37Ev
  virtual void  v38(); // _ZN7S1590C43v38Ev
  virtual void  v39(); // _ZN7S1590C43v39Ev
  virtual void  v40(); // _ZN7S1590C43v40Ev
  virtual void  v41(); // _ZN7S1590C43v41Ev
  virtual void  v42(); // _ZN7S1590C43v42Ev
  virtual void  v43(); // _ZN7S1590C43v43Ev
  virtual void  v44(); // _ZN7S1590C43v44Ev
  virtual void  v45(); // _ZN7S1590C43v45Ev
  virtual void  v46(); // _ZN7S1590C43v46Ev
  virtual void  v47(); // _ZN7S1590C43v47Ev
  virtual void  v48(); // _ZN7S1590C43v48Ev
  virtual void  v49(); // _ZN7S1590C43v49Ev
  virtual void  v50(); // _ZN7S1590C43v50Ev
  virtual void  v51(); // _ZN7S1590C43v51Ev
  virtual void  v52(); // _ZN7S1590C43v52Ev
  virtual void  v53(); // _ZN7S1590C43v53Ev
  virtual void  v54(); // _ZN7S1590C43v54Ev
  virtual void  v55(); // _ZN7S1590C43v55Ev
  virtual void  v56(); // _ZN7S1590C43v56Ev
  virtual void  v57(); // _ZN7S1590C43v57Ev
  virtual void  v58(); // _ZN7S1590C43v58Ev
  virtual void  v59(); // _ZN7S1590C43v59Ev
  virtual void  v60(); // _ZN7S1590C43v60Ev
  virtual void  v61(); // _ZN7S1590C43v61Ev
  virtual void  v62(); // _ZN7S1590C43v62Ev
  virtual void  v63(); // _ZN7S1590C43v63Ev
  virtual void  v64(); // _ZN7S1590C43v64Ev
  virtual void  v65(); // _ZN7S1590C43v65Ev
  virtual void  v66(); // _ZN7S1590C43v66Ev
  virtual void  v67(); // _ZN7S1590C43v67Ev
  virtual void  v68(); // _ZN7S1590C43v68Ev
  virtual void  v69(); // _ZN7S1590C43v69Ev
  virtual void  v70(); // _ZN7S1590C43v70Ev
  virtual void  v71(); // _ZN7S1590C43v71Ev
  virtual void  v72(); // _ZN7S1590C43v72Ev
  S1590C4(); // tgen
};
//SIG(-1 S1590C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1590C4 ::~S1590C4(){ note_dtor("S1590C4", this);}
void  S1590C4 ::v9(){vfunc_called(this, "_ZN7S1590C42v9Ev");}
void  S1590C4 ::v10(){vfunc_called(this, "_ZN7S1590C43v10Ev");}
void  S1590C4 ::v11(){vfunc_called(this, "_ZN7S1590C43v11Ev");}
void  S1590C4 ::v12(){vfunc_called(this, "_ZN7S1590C43v12Ev");}
void  S1590C4 ::v13(){vfunc_called(this, "_ZN7S1590C43v13Ev");}
void  S1590C4 ::v14(){vfunc_called(this, "_ZN7S1590C43v14Ev");}
void  S1590C4 ::v15(){vfunc_called(this, "_ZN7S1590C43v15Ev");}
void  S1590C4 ::v16(){vfunc_called(this, "_ZN7S1590C43v16Ev");}
void  S1590C4 ::v17(){vfunc_called(this, "_ZN7S1590C43v17Ev");}
void  S1590C4 ::v18(){vfunc_called(this, "_ZN7S1590C43v18Ev");}
void  S1590C4 ::v19(){vfunc_called(this, "_ZN7S1590C43v19Ev");}
void  S1590C4 ::v20(){vfunc_called(this, "_ZN7S1590C43v20Ev");}
void  S1590C4 ::v21(){vfunc_called(this, "_ZN7S1590C43v21Ev");}
void  S1590C4 ::v22(){vfunc_called(this, "_ZN7S1590C43v22Ev");}
void  S1590C4 ::v23(){vfunc_called(this, "_ZN7S1590C43v23Ev");}
void  S1590C4 ::v24(){vfunc_called(this, "_ZN7S1590C43v24Ev");}
void  S1590C4 ::v25(){vfunc_called(this, "_ZN7S1590C43v25Ev");}
void  S1590C4 ::v26(){vfunc_called(this, "_ZN7S1590C43v26Ev");}
void  S1590C4 ::v27(){vfunc_called(this, "_ZN7S1590C43v27Ev");}
void  S1590C4 ::v28(){vfunc_called(this, "_ZN7S1590C43v28Ev");}
void  S1590C4 ::v29(){vfunc_called(this, "_ZN7S1590C43v29Ev");}
void  S1590C4 ::v30(){vfunc_called(this, "_ZN7S1590C43v30Ev");}
void  S1590C4 ::v31(){vfunc_called(this, "_ZN7S1590C43v31Ev");}
void  S1590C4 ::v32(){vfunc_called(this, "_ZN7S1590C43v32Ev");}
void  S1590C4 ::v33(){vfunc_called(this, "_ZN7S1590C43v33Ev");}
void  S1590C4 ::v34(){vfunc_called(this, "_ZN7S1590C43v34Ev");}
void  S1590C4 ::v35(){vfunc_called(this, "_ZN7S1590C43v35Ev");}
void  S1590C4 ::v36(){vfunc_called(this, "_ZN7S1590C43v36Ev");}
void  S1590C4 ::v37(){vfunc_called(this, "_ZN7S1590C43v37Ev");}
void  S1590C4 ::v38(){vfunc_called(this, "_ZN7S1590C43v38Ev");}
void  S1590C4 ::v39(){vfunc_called(this, "_ZN7S1590C43v39Ev");}
void  S1590C4 ::v40(){vfunc_called(this, "_ZN7S1590C43v40Ev");}
void  S1590C4 ::v41(){vfunc_called(this, "_ZN7S1590C43v41Ev");}
void  S1590C4 ::v42(){vfunc_called(this, "_ZN7S1590C43v42Ev");}
void  S1590C4 ::v43(){vfunc_called(this, "_ZN7S1590C43v43Ev");}
void  S1590C4 ::v44(){vfunc_called(this, "_ZN7S1590C43v44Ev");}
void  S1590C4 ::v45(){vfunc_called(this, "_ZN7S1590C43v45Ev");}
void  S1590C4 ::v46(){vfunc_called(this, "_ZN7S1590C43v46Ev");}
void  S1590C4 ::v47(){vfunc_called(this, "_ZN7S1590C43v47Ev");}
void  S1590C4 ::v48(){vfunc_called(this, "_ZN7S1590C43v48Ev");}
void  S1590C4 ::v49(){vfunc_called(this, "_ZN7S1590C43v49Ev");}
void  S1590C4 ::v50(){vfunc_called(this, "_ZN7S1590C43v50Ev");}
void  S1590C4 ::v51(){vfunc_called(this, "_ZN7S1590C43v51Ev");}
void  S1590C4 ::v52(){vfunc_called(this, "_ZN7S1590C43v52Ev");}
void  S1590C4 ::v53(){vfunc_called(this, "_ZN7S1590C43v53Ev");}
void  S1590C4 ::v54(){vfunc_called(this, "_ZN7S1590C43v54Ev");}
void  S1590C4 ::v55(){vfunc_called(this, "_ZN7S1590C43v55Ev");}
void  S1590C4 ::v56(){vfunc_called(this, "_ZN7S1590C43v56Ev");}
void  S1590C4 ::v57(){vfunc_called(this, "_ZN7S1590C43v57Ev");}
void  S1590C4 ::v58(){vfunc_called(this, "_ZN7S1590C43v58Ev");}
void  S1590C4 ::v59(){vfunc_called(this, "_ZN7S1590C43v59Ev");}
void  S1590C4 ::v60(){vfunc_called(this, "_ZN7S1590C43v60Ev");}
void  S1590C4 ::v61(){vfunc_called(this, "_ZN7S1590C43v61Ev");}
void  S1590C4 ::v62(){vfunc_called(this, "_ZN7S1590C43v62Ev");}
void  S1590C4 ::v63(){vfunc_called(this, "_ZN7S1590C43v63Ev");}
void  S1590C4 ::v64(){vfunc_called(this, "_ZN7S1590C43v64Ev");}
void  S1590C4 ::v65(){vfunc_called(this, "_ZN7S1590C43v65Ev");}
void  S1590C4 ::v66(){vfunc_called(this, "_ZN7S1590C43v66Ev");}
void  S1590C4 ::v67(){vfunc_called(this, "_ZN7S1590C43v67Ev");}
void  S1590C4 ::v68(){vfunc_called(this, "_ZN7S1590C43v68Ev");}
void  S1590C4 ::v69(){vfunc_called(this, "_ZN7S1590C43v69Ev");}
void  S1590C4 ::v70(){vfunc_called(this, "_ZN7S1590C43v70Ev");}
void  S1590C4 ::v71(){vfunc_called(this, "_ZN7S1590C43v71Ev");}
void  S1590C4 ::v72(){vfunc_called(this, "_ZN7S1590C43v72Ev");}
S1590C4 ::S1590C4(){ note_ctor("S1590C4", this);} // tgen

static void Test_S1590C4()
{
  extern Class_Descriptor cd_S1590C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1590C4, buf);
    S1590C4 *dp, &lv = *(dp=new (buf) S1590C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1590C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C4)");
    check_field_offset(lv, s1590c4f0, ABISELECT(8,4), "S1590C4.s1590c4f0");
    check_field_offset(lv, s1590c4f1, ABISELECT(16,8), "S1590C4.s1590c4f1");
    check_field_offset(lv, s1590c4f2, ABISELECT(24,16), "S1590C4.s1590c4f2");
    check_field_offset(lv, s1590c4f3, ABISELECT(56,32), "S1590C4.s1590c4f3");
    check_field_offset(lv, s1590c4f4, ABISELECT(64,40), "S1590C4.s1590c4f4");
    check_field_offset(lv, s1590c4f5, ABISELECT(72,44), "S1590C4.s1590c4f5");
    check_field_offset(lv, s1590c4f6, ABISELECT(80,52), "S1590C4.s1590c4f6");
    test_class_info(&lv, &cd_S1590C4);
    dp->~S1590C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C4(Test_S1590C4, "S1590C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1590C4C1Ev();
extern void _ZN7S1590C4D1Ev();
Name_Map name_map_S1590C4[] = {
  NSPAIR(_ZN7S1590C4C1Ev),
  NSPAIR(_ZN7S1590C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1590C4[];
extern void _ZN7S1590C4D1Ev();
extern void _ZN7S1590C4D0Ev();
extern void _ZN7S1590C42v9Ev();
extern void _ZN7S1590C43v10Ev();
extern void _ZN7S1590C43v11Ev();
extern void _ZN7S1590C43v12Ev();
extern void _ZN7S1590C43v13Ev();
extern void _ZN7S1590C43v14Ev();
extern void _ZN7S1590C43v15Ev();
extern void _ZN7S1590C43v16Ev();
extern void _ZN7S1590C43v17Ev();
extern void _ZN7S1590C43v18Ev();
extern void _ZN7S1590C43v19Ev();
extern void _ZN7S1590C43v20Ev();
extern void _ZN7S1590C43v21Ev();
extern void _ZN7S1590C43v22Ev();
extern void _ZN7S1590C43v23Ev();
extern void _ZN7S1590C43v24Ev();
extern void _ZN7S1590C43v25Ev();
extern void _ZN7S1590C43v26Ev();
extern void _ZN7S1590C43v27Ev();
extern void _ZN7S1590C43v28Ev();
extern void _ZN7S1590C43v29Ev();
extern void _ZN7S1590C43v30Ev();
extern void _ZN7S1590C43v31Ev();
extern void _ZN7S1590C43v32Ev();
extern void _ZN7S1590C43v33Ev();
extern void _ZN7S1590C43v34Ev();
extern void _ZN7S1590C43v35Ev();
extern void _ZN7S1590C43v36Ev();
extern void _ZN7S1590C43v37Ev();
extern void _ZN7S1590C43v38Ev();
extern void _ZN7S1590C43v39Ev();
extern void _ZN7S1590C43v40Ev();
extern void _ZN7S1590C43v41Ev();
extern void _ZN7S1590C43v42Ev();
extern void _ZN7S1590C43v43Ev();
extern void _ZN7S1590C43v44Ev();
extern void _ZN7S1590C43v45Ev();
extern void _ZN7S1590C43v46Ev();
extern void _ZN7S1590C43v47Ev();
extern void _ZN7S1590C43v48Ev();
extern void _ZN7S1590C43v49Ev();
extern void _ZN7S1590C43v50Ev();
extern void _ZN7S1590C43v51Ev();
extern void _ZN7S1590C43v52Ev();
extern void _ZN7S1590C43v53Ev();
extern void _ZN7S1590C43v54Ev();
extern void _ZN7S1590C43v55Ev();
extern void _ZN7S1590C43v56Ev();
extern void _ZN7S1590C43v57Ev();
extern void _ZN7S1590C43v58Ev();
extern void _ZN7S1590C43v59Ev();
extern void _ZN7S1590C43v60Ev();
extern void _ZN7S1590C43v61Ev();
extern void _ZN7S1590C43v62Ev();
extern void _ZN7S1590C43v63Ev();
extern void _ZN7S1590C43v64Ev();
extern void _ZN7S1590C43v65Ev();
extern void _ZN7S1590C43v66Ev();
extern void _ZN7S1590C43v67Ev();
extern void _ZN7S1590C43v68Ev();
extern void _ZN7S1590C43v69Ev();
extern void _ZN7S1590C43v70Ev();
extern void _ZN7S1590C43v71Ev();
extern void _ZN7S1590C43v72Ev();
static  VTBL_ENTRY vtc_S1590C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C4[0]),
  (VTBL_ENTRY)&_ZN7S1590C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1590C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1590C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1590C4[];
extern  VTBL_ENTRY _ZTV7S1590C4[];
Class_Descriptor cd_S1590C4 = {  "S1590C4", // class name
  0,0,//no base classes
  &(vtc_S1590C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1590C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1590C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C6  {
  virtual void  v73(); // _ZN7S1590C63v73Ev
  virtual void  v74(); // _ZN7S1590C63v74Ev
  virtual void  v75(); // _ZN7S1590C63v75Ev
  virtual void  v76(); // _ZN7S1590C63v76Ev
  virtual void  v77(); // _ZN7S1590C63v77Ev
  virtual void  v78(); // _ZN7S1590C63v78Ev
  virtual void  v79(); // _ZN7S1590C63v79Ev
  virtual void  v80(); // _ZN7S1590C63v80Ev
  virtual void  v81(); // _ZN7S1590C63v81Ev
  virtual void  v82(); // _ZN7S1590C63v82Ev
  virtual void  v83(); // _ZN7S1590C63v83Ev
  virtual void  v84(); // _ZN7S1590C63v84Ev
  virtual void  v85(); // _ZN7S1590C63v85Ev
  virtual void  v86(); // _ZN7S1590C63v86Ev
  virtual void  v87(); // _ZN7S1590C63v87Ev
  virtual void  v88(); // _ZN7S1590C63v88Ev
  ~S1590C6(); // tgen
  S1590C6(); // tgen
};
//SIG(-1 S1590C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1590C6 ::v73(){vfunc_called(this, "_ZN7S1590C63v73Ev");}
void  S1590C6 ::v74(){vfunc_called(this, "_ZN7S1590C63v74Ev");}
void  S1590C6 ::v75(){vfunc_called(this, "_ZN7S1590C63v75Ev");}
void  S1590C6 ::v76(){vfunc_called(this, "_ZN7S1590C63v76Ev");}
void  S1590C6 ::v77(){vfunc_called(this, "_ZN7S1590C63v77Ev");}
void  S1590C6 ::v78(){vfunc_called(this, "_ZN7S1590C63v78Ev");}
void  S1590C6 ::v79(){vfunc_called(this, "_ZN7S1590C63v79Ev");}
void  S1590C6 ::v80(){vfunc_called(this, "_ZN7S1590C63v80Ev");}
void  S1590C6 ::v81(){vfunc_called(this, "_ZN7S1590C63v81Ev");}
void  S1590C6 ::v82(){vfunc_called(this, "_ZN7S1590C63v82Ev");}
void  S1590C6 ::v83(){vfunc_called(this, "_ZN7S1590C63v83Ev");}
void  S1590C6 ::v84(){vfunc_called(this, "_ZN7S1590C63v84Ev");}
void  S1590C6 ::v85(){vfunc_called(this, "_ZN7S1590C63v85Ev");}
void  S1590C6 ::v86(){vfunc_called(this, "_ZN7S1590C63v86Ev");}
void  S1590C6 ::v87(){vfunc_called(this, "_ZN7S1590C63v87Ev");}
void  S1590C6 ::v88(){vfunc_called(this, "_ZN7S1590C63v88Ev");}
S1590C6 ::~S1590C6(){ note_dtor("S1590C6", this);} // tgen
S1590C6 ::S1590C6(){ note_ctor("S1590C6", this);} // tgen

static void Test_S1590C6()
{
  extern Class_Descriptor cd_S1590C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1590C6, buf);
    S1590C6 *dp, &lv = *(dp=new (buf) S1590C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1590C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C6)");
    test_class_info(&lv, &cd_S1590C6);
    dp->~S1590C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C6(Test_S1590C6, "S1590C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1590C6C1Ev();
extern void _ZN7S1590C6D1Ev();
Name_Map name_map_S1590C6[] = {
  NSPAIR(_ZN7S1590C6C1Ev),
  NSPAIR(_ZN7S1590C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1590C6[];
extern void _ZN7S1590C63v73Ev();
extern void _ZN7S1590C63v74Ev();
extern void _ZN7S1590C63v75Ev();
extern void _ZN7S1590C63v76Ev();
extern void _ZN7S1590C63v77Ev();
extern void _ZN7S1590C63v78Ev();
extern void _ZN7S1590C63v79Ev();
extern void _ZN7S1590C63v80Ev();
extern void _ZN7S1590C63v81Ev();
extern void _ZN7S1590C63v82Ev();
extern void _ZN7S1590C63v83Ev();
extern void _ZN7S1590C63v84Ev();
extern void _ZN7S1590C63v85Ev();
extern void _ZN7S1590C63v86Ev();
extern void _ZN7S1590C63v87Ev();
extern void _ZN7S1590C63v88Ev();
static  VTBL_ENTRY vtc_S1590C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C6[0]),
  (VTBL_ENTRY)&_ZN7S1590C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v88Ev,
};
extern VTBL_ENTRY _ZTI7S1590C6[];
extern  VTBL_ENTRY _ZTV7S1590C6[];
Class_Descriptor cd_S1590C6 = {  "S1590C6", // class name
  0,0,//no base classes
  &(vtc_S1590C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1590C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1590C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C7  {
  virtual void  v89(); // _ZN7S1590C73v89Ev
  virtual void  v90(); // _ZN7S1590C73v90Ev
  virtual void  v91(); // _ZN7S1590C73v91Ev
  virtual void  v92(); // _ZN7S1590C73v92Ev
  virtual void  v93(); // _ZN7S1590C73v93Ev
  virtual void  v94(); // _ZN7S1590C73v94Ev
  virtual void  v95(); // _ZN7S1590C73v95Ev
  virtual void  v96(); // _ZN7S1590C73v96Ev
  virtual void  v97(); // _ZN7S1590C73v97Ev
  ~S1590C7(); // tgen
  S1590C7(); // tgen
};
//SIG(-1 S1590C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1590C7 ::v89(){vfunc_called(this, "_ZN7S1590C73v89Ev");}
void  S1590C7 ::v90(){vfunc_called(this, "_ZN7S1590C73v90Ev");}
void  S1590C7 ::v91(){vfunc_called(this, "_ZN7S1590C73v91Ev");}
void  S1590C7 ::v92(){vfunc_called(this, "_ZN7S1590C73v92Ev");}
void  S1590C7 ::v93(){vfunc_called(this, "_ZN7S1590C73v93Ev");}
void  S1590C7 ::v94(){vfunc_called(this, "_ZN7S1590C73v94Ev");}
void  S1590C7 ::v95(){vfunc_called(this, "_ZN7S1590C73v95Ev");}
void  S1590C7 ::v96(){vfunc_called(this, "_ZN7S1590C73v96Ev");}
void  S1590C7 ::v97(){vfunc_called(this, "_ZN7S1590C73v97Ev");}
S1590C7 ::~S1590C7(){ note_dtor("S1590C7", this);} // tgen
S1590C7 ::S1590C7(){ note_ctor("S1590C7", this);} // tgen

static void Test_S1590C7()
{
  extern Class_Descriptor cd_S1590C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1590C7, buf);
    S1590C7 *dp, &lv = *(dp=new (buf) S1590C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1590C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C7)");
    test_class_info(&lv, &cd_S1590C7);
    dp->~S1590C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C7(Test_S1590C7, "S1590C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1590C7C1Ev();
extern void _ZN7S1590C7D1Ev();
Name_Map name_map_S1590C7[] = {
  NSPAIR(_ZN7S1590C7C1Ev),
  NSPAIR(_ZN7S1590C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1590C7[];
extern void _ZN7S1590C73v89Ev();
extern void _ZN7S1590C73v90Ev();
extern void _ZN7S1590C73v91Ev();
extern void _ZN7S1590C73v92Ev();
extern void _ZN7S1590C73v93Ev();
extern void _ZN7S1590C73v94Ev();
extern void _ZN7S1590C73v95Ev();
extern void _ZN7S1590C73v96Ev();
extern void _ZN7S1590C73v97Ev();
static  VTBL_ENTRY vtc_S1590C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C7[0]),
  (VTBL_ENTRY)&_ZN7S1590C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1590C7[];
extern  VTBL_ENTRY _ZTV7S1590C7[];
Class_Descriptor cd_S1590C7 = {  "S1590C7", // class name
  0,0,//no base classes
  &(vtc_S1590C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1590C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1590C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C3  : S1590C4 , S1590C6 , S1590C7 {
  void *s1590c3f0;
  ::S79C39_nt s1590c3f1;
  unsigned int s1590c3f2:1;
  unsigned int s1590c3f3:1;
  unsigned int s1590c3f4:1;
  unsigned int s1590c3f5:1;
  virtual  ~S1590C3(); // _ZN7S1590C3D1Ev
  virtual void  v98(); // _ZN7S1590C33v98Ev
  virtual void  v99(); // _ZN7S1590C33v99Ev
  virtual void  v100(); // _ZN7S1590C34v100Ev
  virtual void  v101(); // _ZN7S1590C34v101Ev
  virtual void  v102(); // _ZN7S1590C34v102Ev
  virtual void  v103(); // _ZN7S1590C34v103Ev
  virtual void  v104(); // _ZN7S1590C34v104Ev
  virtual void  v105(); // _ZN7S1590C34v105Ev
  virtual void  v106(); // _ZN7S1590C34v106Ev
  virtual void  v107(); // _ZN7S1590C34v107Ev
  virtual void  v108(); // _ZN7S1590C34v108Ev
  virtual void  v109(); // _ZN7S1590C34v109Ev
  virtual void  v110(); // _ZN7S1590C34v110Ev
  virtual void  v111(); // _ZN7S1590C34v111Ev
  virtual void  v112(); // _ZN7S1590C34v112Ev
  virtual void  v113(); // _ZN7S1590C34v113Ev
  virtual void  v114(); // _ZN7S1590C34v114Ev
  virtual void  v115(); // _ZN7S1590C34v115Ev
  virtual void  v116(); // _ZN7S1590C34v116Ev
  virtual void  v117(); // _ZN7S1590C34v117Ev
  virtual void  v118(); // _ZN7S1590C34v118Ev
  virtual void  v119(); // _ZN7S1590C34v119Ev
  virtual void  v120(); // _ZN7S1590C34v120Ev
  virtual void  v121(); // _ZN7S1590C34v121Ev
  S1590C3(); // tgen
};
//SIG(-1 S1590C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1590C3 ::~S1590C3(){ note_dtor("S1590C3", this);}
void  S1590C3 ::v98(){vfunc_called(this, "_ZN7S1590C33v98Ev");}
void  S1590C3 ::v99(){vfunc_called(this, "_ZN7S1590C33v99Ev");}
void  S1590C3 ::v100(){vfunc_called(this, "_ZN7S1590C34v100Ev");}
void  S1590C3 ::v101(){vfunc_called(this, "_ZN7S1590C34v101Ev");}
void  S1590C3 ::v102(){vfunc_called(this, "_ZN7S1590C34v102Ev");}
void  S1590C3 ::v103(){vfunc_called(this, "_ZN7S1590C34v103Ev");}
void  S1590C3 ::v104(){vfunc_called(this, "_ZN7S1590C34v104Ev");}
void  S1590C3 ::v105(){vfunc_called(this, "_ZN7S1590C34v105Ev");}
void  S1590C3 ::v106(){vfunc_called(this, "_ZN7S1590C34v106Ev");}
void  S1590C3 ::v107(){vfunc_called(this, "_ZN7S1590C34v107Ev");}
void  S1590C3 ::v108(){vfunc_called(this, "_ZN7S1590C34v108Ev");}
void  S1590C3 ::v109(){vfunc_called(this, "_ZN7S1590C34v109Ev");}
void  S1590C3 ::v110(){vfunc_called(this, "_ZN7S1590C34v110Ev");}
void  S1590C3 ::v111(){vfunc_called(this, "_ZN7S1590C34v111Ev");}
void  S1590C3 ::v112(){vfunc_called(this, "_ZN7S1590C34v112Ev");}
void  S1590C3 ::v113(){vfunc_called(this, "_ZN7S1590C34v113Ev");}
void  S1590C3 ::v114(){vfunc_called(this, "_ZN7S1590C34v114Ev");}
void  S1590C3 ::v115(){vfunc_called(this, "_ZN7S1590C34v115Ev");}
void  S1590C3 ::v116(){vfunc_called(this, "_ZN7S1590C34v116Ev");}
void  S1590C3 ::v117(){vfunc_called(this, "_ZN7S1590C34v117Ev");}
void  S1590C3 ::v118(){vfunc_called(this, "_ZN7S1590C34v118Ev");}
void  S1590C3 ::v119(){vfunc_called(this, "_ZN7S1590C34v119Ev");}
void  S1590C3 ::v120(){vfunc_called(this, "_ZN7S1590C34v120Ev");}
void  S1590C3 ::v121(){vfunc_called(this, "_ZN7S1590C34v121Ev");}
S1590C3 ::S1590C3(){ note_ctor("S1590C3", this);} // tgen

static void Test_S1590C3()
{
  extern Class_Descriptor cd_S1590C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1590C3, buf);
    S1590C3 *dp, &lv = *(dp=new (buf) S1590C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1590C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C3)");
    check_base_class_offset(lv, (S1590C4*), 0, "S1590C3");
    check_base_class_offset(lv, (S1590C6*), ABISELECT(96,60), "S1590C3");
    check_base_class_offset(lv, (S1590C7*), ABISELECT(104,64), "S1590C3");
    check_field_offset(lv, s1590c3f0, ABISELECT(112,68), "S1590C3.s1590c3f0");
    check_field_offset(lv, s1590c3f1, ABISELECT(120,72), "S1590C3.s1590c3f1");
    set_bf_and_test(lv, s1590c3f2, ABISELECT(136,84), 0, 1, 1, "S1590C3");
    set_bf_and_test(lv, s1590c3f3, ABISELECT(136,84), 1, 1, 1, "S1590C3");
    set_bf_and_test(lv, s1590c3f4, ABISELECT(136,84), 2, 1, 1, "S1590C3");
    set_bf_and_test(lv, s1590c3f5, ABISELECT(136,84), 3, 1, 1, "S1590C3");
    test_class_info(&lv, &cd_S1590C3);
    dp->~S1590C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C3(Test_S1590C3, "S1590C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1590C3C1Ev();
extern void _ZN7S1590C3D1Ev();
Name_Map name_map_S1590C3[] = {
  NSPAIR(_ZN7S1590C3C1Ev),
  NSPAIR(_ZN7S1590C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1590C4;
extern VTBL_ENTRY _ZTI7S1590C4[];
extern  VTBL_ENTRY _ZTV7S1590C4[];
extern Class_Descriptor cd_S1590C6;
extern VTBL_ENTRY _ZTI7S1590C6[];
extern  VTBL_ENTRY _ZTV7S1590C6[];
extern Class_Descriptor cd_S1590C7;
extern VTBL_ENTRY _ZTI7S1590C7[];
extern  VTBL_ENTRY _ZTV7S1590C7[];
static Base_Class bases_S1590C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1590C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1590C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1590C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1590C3[];
extern void _ZN7S1590C3D1Ev();
extern void _ZN7S1590C3D0Ev();
extern void _ZN7S1590C42v9Ev();
extern void _ZN7S1590C43v10Ev();
extern void _ZN7S1590C43v11Ev();
extern void _ZN7S1590C43v12Ev();
extern void _ZN7S1590C43v13Ev();
extern void _ZN7S1590C43v14Ev();
extern void _ZN7S1590C43v15Ev();
extern void _ZN7S1590C43v16Ev();
extern void _ZN7S1590C43v17Ev();
extern void _ZN7S1590C43v18Ev();
extern void _ZN7S1590C43v19Ev();
extern void _ZN7S1590C43v20Ev();
extern void _ZN7S1590C43v21Ev();
extern void _ZN7S1590C43v22Ev();
extern void _ZN7S1590C43v23Ev();
extern void _ZN7S1590C43v24Ev();
extern void _ZN7S1590C43v25Ev();
extern void _ZN7S1590C43v26Ev();
extern void _ZN7S1590C43v27Ev();
extern void _ZN7S1590C43v28Ev();
extern void _ZN7S1590C43v29Ev();
extern void _ZN7S1590C43v30Ev();
extern void _ZN7S1590C43v31Ev();
extern void _ZN7S1590C43v32Ev();
extern void _ZN7S1590C43v33Ev();
extern void _ZN7S1590C43v34Ev();
extern void _ZN7S1590C43v35Ev();
extern void _ZN7S1590C43v36Ev();
extern void _ZN7S1590C43v37Ev();
extern void _ZN7S1590C43v38Ev();
extern void _ZN7S1590C43v39Ev();
extern void _ZN7S1590C43v40Ev();
extern void _ZN7S1590C43v41Ev();
extern void _ZN7S1590C43v42Ev();
extern void _ZN7S1590C43v43Ev();
extern void _ZN7S1590C43v44Ev();
extern void _ZN7S1590C43v45Ev();
extern void _ZN7S1590C43v46Ev();
extern void _ZN7S1590C43v47Ev();
extern void _ZN7S1590C43v48Ev();
extern void _ZN7S1590C43v49Ev();
extern void _ZN7S1590C43v50Ev();
extern void _ZN7S1590C43v51Ev();
extern void _ZN7S1590C43v52Ev();
extern void _ZN7S1590C43v53Ev();
extern void _ZN7S1590C43v54Ev();
extern void _ZN7S1590C43v55Ev();
extern void _ZN7S1590C43v56Ev();
extern void _ZN7S1590C43v57Ev();
extern void _ZN7S1590C43v58Ev();
extern void _ZN7S1590C43v59Ev();
extern void _ZN7S1590C43v60Ev();
extern void _ZN7S1590C43v61Ev();
extern void _ZN7S1590C43v62Ev();
extern void _ZN7S1590C43v63Ev();
extern void _ZN7S1590C43v64Ev();
extern void _ZN7S1590C43v65Ev();
extern void _ZN7S1590C43v66Ev();
extern void _ZN7S1590C43v67Ev();
extern void _ZN7S1590C43v68Ev();
extern void _ZN7S1590C43v69Ev();
extern void _ZN7S1590C43v70Ev();
extern void _ZN7S1590C43v71Ev();
extern void _ZN7S1590C43v72Ev();
extern void _ZN7S1590C33v98Ev();
extern void _ZN7S1590C33v99Ev();
extern void _ZN7S1590C34v100Ev();
extern void _ZN7S1590C34v101Ev();
extern void _ZN7S1590C34v102Ev();
extern void _ZN7S1590C34v103Ev();
extern void _ZN7S1590C34v104Ev();
extern void _ZN7S1590C34v105Ev();
extern void _ZN7S1590C34v106Ev();
extern void _ZN7S1590C34v107Ev();
extern void _ZN7S1590C34v108Ev();
extern void _ZN7S1590C34v109Ev();
extern void _ZN7S1590C34v110Ev();
extern void _ZN7S1590C34v111Ev();
extern void _ZN7S1590C34v112Ev();
extern void _ZN7S1590C34v113Ev();
extern void _ZN7S1590C34v114Ev();
extern void _ZN7S1590C34v115Ev();
extern void _ZN7S1590C34v116Ev();
extern void _ZN7S1590C34v117Ev();
extern void _ZN7S1590C34v118Ev();
extern void _ZN7S1590C34v119Ev();
extern void _ZN7S1590C34v120Ev();
extern void _ZN7S1590C34v121Ev();
extern void _ZN7S1590C63v73Ev();
extern void _ZN7S1590C63v74Ev();
extern void _ZN7S1590C63v75Ev();
extern void _ZN7S1590C63v76Ev();
extern void _ZN7S1590C63v77Ev();
extern void _ZN7S1590C63v78Ev();
extern void _ZN7S1590C63v79Ev();
extern void _ZN7S1590C63v80Ev();
extern void _ZN7S1590C63v81Ev();
extern void _ZN7S1590C63v82Ev();
extern void _ZN7S1590C63v83Ev();
extern void _ZN7S1590C63v84Ev();
extern void _ZN7S1590C63v85Ev();
extern void _ZN7S1590C63v86Ev();
extern void _ZN7S1590C63v87Ev();
extern void _ZN7S1590C63v88Ev();
extern void _ZN7S1590C73v89Ev();
extern void _ZN7S1590C73v90Ev();
extern void _ZN7S1590C73v91Ev();
extern void _ZN7S1590C73v92Ev();
extern void _ZN7S1590C73v93Ev();
extern void _ZN7S1590C73v94Ev();
extern void _ZN7S1590C73v95Ev();
extern void _ZN7S1590C73v96Ev();
extern void _ZN7S1590C73v97Ev();
static  VTBL_ENTRY vtc_S1590C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C3[0]),
  (VTBL_ENTRY)&_ZN7S1590C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1590C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1590C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v121Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1590C3[0]),
  (VTBL_ENTRY)&_ZN7S1590C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1590C3[0]),
  (VTBL_ENTRY)&_ZN7S1590C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1590C3[];
extern  VTBL_ENTRY _ZTV7S1590C3[];
Class_Descriptor cd_S1590C3 = {  "S1590C3", // class name
  bases_S1590C3, 3,
  &(vtc_S1590C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1590C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1590C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C2  : S1590C3 {
  ::S3262C11_nt s1590c2f0;
  int s1590c2f1;
  virtual  ~S1590C2(); // _ZN7S1590C2D1Ev
  virtual void  v122(); // _ZN7S1590C24v122Ev
  virtual void  v123(); // _ZN7S1590C24v123Ev
  virtual void  v124(); // _ZN7S1590C24v124Ev
  virtual void  v125(); // _ZN7S1590C24v125Ev
  virtual void  v126(); // _ZN7S1590C24v126Ev
  virtual void  v127(); // _ZN7S1590C24v127Ev
  virtual void  v128(); // _ZN7S1590C24v128Ev
  virtual void  v129(); // _ZN7S1590C24v129Ev
  virtual void  v130(); // _ZN7S1590C24v130Ev
  virtual void  v131(); // _ZN7S1590C24v131Ev
  virtual void  v132(); // _ZN7S1590C24v132Ev
  virtual void  v133(); // _ZN7S1590C24v133Ev
  virtual void  v134(); // _ZN7S1590C24v134Ev
  virtual void  v135(); // _ZN7S1590C24v135Ev
  virtual void  v136(); // _ZN7S1590C24v136Ev
  virtual void  v137(); // _ZN7S1590C24v137Ev
  virtual void  v138(); // _ZN7S1590C24v138Ev
  virtual void  v139(); // _ZN7S1590C24v139Ev
  virtual void  v140(); // _ZN7S1590C24v140Ev
  virtual void  v141(); // _ZN7S1590C24v141Ev
  virtual void  v142(); // _ZN7S1590C24v142Ev
  virtual void  v143(); // _ZN7S1590C24v143Ev
  virtual void  v144(); // _ZN7S1590C24v144Ev
  virtual void  v145(); // _ZN7S1590C24v145Ev
  virtual void  v146(); // _ZN7S1590C24v146Ev
  virtual void  v147(); // _ZN7S1590C24v147Ev
  virtual void  v148(); // _ZN7S1590C24v148Ev
  S1590C2(); // tgen
};
//SIG(-1 S1590C2) C1{ BC2{ BC3{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107} BC6{ v108 v109 v110 v111 v112 v113 v114 v115 v116} vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1590C2 ::~S1590C2(){ note_dtor("S1590C2", this);}
void  S1590C2 ::v122(){vfunc_called(this, "_ZN7S1590C24v122Ev");}
void  S1590C2 ::v123(){vfunc_called(this, "_ZN7S1590C24v123Ev");}
void  S1590C2 ::v124(){vfunc_called(this, "_ZN7S1590C24v124Ev");}
void  S1590C2 ::v125(){vfunc_called(this, "_ZN7S1590C24v125Ev");}
void  S1590C2 ::v126(){vfunc_called(this, "_ZN7S1590C24v126Ev");}
void  S1590C2 ::v127(){vfunc_called(this, "_ZN7S1590C24v127Ev");}
void  S1590C2 ::v128(){vfunc_called(this, "_ZN7S1590C24v128Ev");}
void  S1590C2 ::v129(){vfunc_called(this, "_ZN7S1590C24v129Ev");}
void  S1590C2 ::v130(){vfunc_called(this, "_ZN7S1590C24v130Ev");}
void  S1590C2 ::v131(){vfunc_called(this, "_ZN7S1590C24v131Ev");}
void  S1590C2 ::v132(){vfunc_called(this, "_ZN7S1590C24v132Ev");}
void  S1590C2 ::v133(){vfunc_called(this, "_ZN7S1590C24v133Ev");}
void  S1590C2 ::v134(){vfunc_called(this, "_ZN7S1590C24v134Ev");}
void  S1590C2 ::v135(){vfunc_called(this, "_ZN7S1590C24v135Ev");}
void  S1590C2 ::v136(){vfunc_called(this, "_ZN7S1590C24v136Ev");}
void  S1590C2 ::v137(){vfunc_called(this, "_ZN7S1590C24v137Ev");}
void  S1590C2 ::v138(){vfunc_called(this, "_ZN7S1590C24v138Ev");}
void  S1590C2 ::v139(){vfunc_called(this, "_ZN7S1590C24v139Ev");}
void  S1590C2 ::v140(){vfunc_called(this, "_ZN7S1590C24v140Ev");}
void  S1590C2 ::v141(){vfunc_called(this, "_ZN7S1590C24v141Ev");}
void  S1590C2 ::v142(){vfunc_called(this, "_ZN7S1590C24v142Ev");}
void  S1590C2 ::v143(){vfunc_called(this, "_ZN7S1590C24v143Ev");}
void  S1590C2 ::v144(){vfunc_called(this, "_ZN7S1590C24v144Ev");}
void  S1590C2 ::v145(){vfunc_called(this, "_ZN7S1590C24v145Ev");}
void  S1590C2 ::v146(){vfunc_called(this, "_ZN7S1590C24v146Ev");}
void  S1590C2 ::v147(){vfunc_called(this, "_ZN7S1590C24v147Ev");}
void  S1590C2 ::v148(){vfunc_called(this, "_ZN7S1590C24v148Ev");}
S1590C2 ::S1590C2(){ note_ctor("S1590C2", this);} // tgen

static void Test_S1590C2()
{
  extern Class_Descriptor cd_S1590C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1590C2, buf);
    S1590C2 *dp, &lv = *(dp=new (buf) S1590C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1590C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C2)");
    check_base_class_offset(lv, (S1590C4*)(S1590C3*), 0, "S1590C2");
    check_base_class_offset(lv, (S1590C6*)(S1590C3*), ABISELECT(96,60), "S1590C2");
    check_base_class_offset(lv, (S1590C7*)(S1590C3*), ABISELECT(104,64), "S1590C2");
    check_base_class_offset(lv, (S1590C3*), 0, "S1590C2");
    check_field_offset(lv, s1590c2f0, ABISELECT(144,88), "S1590C2.s1590c2f0");
    check_field_offset(lv, s1590c2f1, ABISELECT(168,104), "S1590C2.s1590c2f1");
    test_class_info(&lv, &cd_S1590C2);
    dp->~S1590C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C2(Test_S1590C2, "S1590C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1590C2C1Ev();
extern void _ZN7S1590C2D1Ev();
Name_Map name_map_S1590C2[] = {
  NSPAIR(_ZN7S1590C2C1Ev),
  NSPAIR(_ZN7S1590C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1590C4;
extern VTBL_ENTRY _ZTI7S1590C4[];
extern  VTBL_ENTRY _ZTV7S1590C4[];
extern Class_Descriptor cd_S1590C6;
extern VTBL_ENTRY _ZTI7S1590C6[];
extern  VTBL_ENTRY _ZTV7S1590C6[];
extern Class_Descriptor cd_S1590C7;
extern VTBL_ENTRY _ZTI7S1590C7[];
extern  VTBL_ENTRY _ZTV7S1590C7[];
extern Class_Descriptor cd_S1590C3;
extern VTBL_ENTRY _ZTI7S1590C3[];
extern  VTBL_ENTRY _ZTV7S1590C3[];
static Base_Class bases_S1590C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1590C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C6,    ABISELECT(96,60), //bcp->offset
    119, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C7,    ABISELECT(104,64), //bcp->offset
    137, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1590C2[];
extern void _ZN7S1590C2D1Ev();
extern void _ZN7S1590C2D0Ev();
extern void _ZN7S1590C42v9Ev();
extern void _ZN7S1590C43v10Ev();
extern void _ZN7S1590C43v11Ev();
extern void _ZN7S1590C43v12Ev();
extern void _ZN7S1590C43v13Ev();
extern void _ZN7S1590C43v14Ev();
extern void _ZN7S1590C43v15Ev();
extern void _ZN7S1590C43v16Ev();
extern void _ZN7S1590C43v17Ev();
extern void _ZN7S1590C43v18Ev();
extern void _ZN7S1590C43v19Ev();
extern void _ZN7S1590C43v20Ev();
extern void _ZN7S1590C43v21Ev();
extern void _ZN7S1590C43v22Ev();
extern void _ZN7S1590C43v23Ev();
extern void _ZN7S1590C43v24Ev();
extern void _ZN7S1590C43v25Ev();
extern void _ZN7S1590C43v26Ev();
extern void _ZN7S1590C43v27Ev();
extern void _ZN7S1590C43v28Ev();
extern void _ZN7S1590C43v29Ev();
extern void _ZN7S1590C43v30Ev();
extern void _ZN7S1590C43v31Ev();
extern void _ZN7S1590C43v32Ev();
extern void _ZN7S1590C43v33Ev();
extern void _ZN7S1590C43v34Ev();
extern void _ZN7S1590C43v35Ev();
extern void _ZN7S1590C43v36Ev();
extern void _ZN7S1590C43v37Ev();
extern void _ZN7S1590C43v38Ev();
extern void _ZN7S1590C43v39Ev();
extern void _ZN7S1590C43v40Ev();
extern void _ZN7S1590C43v41Ev();
extern void _ZN7S1590C43v42Ev();
extern void _ZN7S1590C43v43Ev();
extern void _ZN7S1590C43v44Ev();
extern void _ZN7S1590C43v45Ev();
extern void _ZN7S1590C43v46Ev();
extern void _ZN7S1590C43v47Ev();
extern void _ZN7S1590C43v48Ev();
extern void _ZN7S1590C43v49Ev();
extern void _ZN7S1590C43v50Ev();
extern void _ZN7S1590C43v51Ev();
extern void _ZN7S1590C43v52Ev();
extern void _ZN7S1590C43v53Ev();
extern void _ZN7S1590C43v54Ev();
extern void _ZN7S1590C43v55Ev();
extern void _ZN7S1590C43v56Ev();
extern void _ZN7S1590C43v57Ev();
extern void _ZN7S1590C43v58Ev();
extern void _ZN7S1590C43v59Ev();
extern void _ZN7S1590C43v60Ev();
extern void _ZN7S1590C43v61Ev();
extern void _ZN7S1590C43v62Ev();
extern void _ZN7S1590C43v63Ev();
extern void _ZN7S1590C43v64Ev();
extern void _ZN7S1590C43v65Ev();
extern void _ZN7S1590C43v66Ev();
extern void _ZN7S1590C43v67Ev();
extern void _ZN7S1590C43v68Ev();
extern void _ZN7S1590C43v69Ev();
extern void _ZN7S1590C43v70Ev();
extern void _ZN7S1590C43v71Ev();
extern void _ZN7S1590C43v72Ev();
extern void _ZN7S1590C33v98Ev();
extern void _ZN7S1590C33v99Ev();
extern void _ZN7S1590C34v100Ev();
extern void _ZN7S1590C34v101Ev();
extern void _ZN7S1590C34v102Ev();
extern void _ZN7S1590C34v103Ev();
extern void _ZN7S1590C34v104Ev();
extern void _ZN7S1590C34v105Ev();
extern void _ZN7S1590C34v106Ev();
extern void _ZN7S1590C34v107Ev();
extern void _ZN7S1590C34v108Ev();
extern void _ZN7S1590C34v109Ev();
extern void _ZN7S1590C34v110Ev();
extern void _ZN7S1590C34v111Ev();
extern void _ZN7S1590C34v112Ev();
extern void _ZN7S1590C34v113Ev();
extern void _ZN7S1590C34v114Ev();
extern void _ZN7S1590C34v115Ev();
extern void _ZN7S1590C34v116Ev();
extern void _ZN7S1590C34v117Ev();
extern void _ZN7S1590C34v118Ev();
extern void _ZN7S1590C34v119Ev();
extern void _ZN7S1590C34v120Ev();
extern void _ZN7S1590C34v121Ev();
extern void _ZN7S1590C24v122Ev();
extern void _ZN7S1590C24v123Ev();
extern void _ZN7S1590C24v124Ev();
extern void _ZN7S1590C24v125Ev();
extern void _ZN7S1590C24v126Ev();
extern void _ZN7S1590C24v127Ev();
extern void _ZN7S1590C24v128Ev();
extern void _ZN7S1590C24v129Ev();
extern void _ZN7S1590C24v130Ev();
extern void _ZN7S1590C24v131Ev();
extern void _ZN7S1590C24v132Ev();
extern void _ZN7S1590C24v133Ev();
extern void _ZN7S1590C24v134Ev();
extern void _ZN7S1590C24v135Ev();
extern void _ZN7S1590C24v136Ev();
extern void _ZN7S1590C24v137Ev();
extern void _ZN7S1590C24v138Ev();
extern void _ZN7S1590C24v139Ev();
extern void _ZN7S1590C24v140Ev();
extern void _ZN7S1590C24v141Ev();
extern void _ZN7S1590C24v142Ev();
extern void _ZN7S1590C24v143Ev();
extern void _ZN7S1590C24v144Ev();
extern void _ZN7S1590C24v145Ev();
extern void _ZN7S1590C24v146Ev();
extern void _ZN7S1590C24v147Ev();
extern void _ZN7S1590C24v148Ev();
extern void _ZN7S1590C63v73Ev();
extern void _ZN7S1590C63v74Ev();
extern void _ZN7S1590C63v75Ev();
extern void _ZN7S1590C63v76Ev();
extern void _ZN7S1590C63v77Ev();
extern void _ZN7S1590C63v78Ev();
extern void _ZN7S1590C63v79Ev();
extern void _ZN7S1590C63v80Ev();
extern void _ZN7S1590C63v81Ev();
extern void _ZN7S1590C63v82Ev();
extern void _ZN7S1590C63v83Ev();
extern void _ZN7S1590C63v84Ev();
extern void _ZN7S1590C63v85Ev();
extern void _ZN7S1590C63v86Ev();
extern void _ZN7S1590C63v87Ev();
extern void _ZN7S1590C63v88Ev();
extern void _ZN7S1590C73v89Ev();
extern void _ZN7S1590C73v90Ev();
extern void _ZN7S1590C73v91Ev();
extern void _ZN7S1590C73v92Ev();
extern void _ZN7S1590C73v93Ev();
extern void _ZN7S1590C73v94Ev();
extern void _ZN7S1590C73v95Ev();
extern void _ZN7S1590C73v96Ev();
extern void _ZN7S1590C73v97Ev();
static  VTBL_ENTRY vtc_S1590C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C2[0]),
  (VTBL_ENTRY)&_ZN7S1590C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1590C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1590C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v148Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1590C2[0]),
  (VTBL_ENTRY)&_ZN7S1590C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1590C2[0]),
  (VTBL_ENTRY)&_ZN7S1590C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1590C2[];
extern  VTBL_ENTRY _ZTV7S1590C2[];
Class_Descriptor cd_S1590C2 = {  "S1590C2", // class name
  bases_S1590C2, 4,
  &(vtc_S1590C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1590C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1590C2),148, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1590C1  : S1590C2 {
  ::S79C8_nt s1590c1f0;
  virtual  ~S1590C1(); // _ZN7S1590C1D1Ev
  virtual void  v1(); // _ZN7S1590C12v1Ev
  virtual void  v2(); // _ZN7S1590C12v2Ev
  virtual void  v3(); // _ZN7S1590C12v3Ev
  virtual void  v4(); // _ZN7S1590C12v4Ev
  virtual void  v5(); // _ZN7S1590C12v5Ev
  virtual void  v6(); // _ZN7S1590C12v6Ev
  virtual void  v7(); // _ZN7S1590C12v7Ev
  virtual void  v8(); // _ZN7S1590C12v8Ev
  S1590C1(); // tgen
};
//SIG(1 S1590C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88} BC7{ v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 FC5}


 S1590C1 ::~S1590C1(){ note_dtor("S1590C1", this);}
void  S1590C1 ::v1(){vfunc_called(this, "_ZN7S1590C12v1Ev");}
void  S1590C1 ::v2(){vfunc_called(this, "_ZN7S1590C12v2Ev");}
void  S1590C1 ::v3(){vfunc_called(this, "_ZN7S1590C12v3Ev");}
void  S1590C1 ::v4(){vfunc_called(this, "_ZN7S1590C12v4Ev");}
void  S1590C1 ::v5(){vfunc_called(this, "_ZN7S1590C12v5Ev");}
void  S1590C1 ::v6(){vfunc_called(this, "_ZN7S1590C12v6Ev");}
void  S1590C1 ::v7(){vfunc_called(this, "_ZN7S1590C12v7Ev");}
void  S1590C1 ::v8(){vfunc_called(this, "_ZN7S1590C12v8Ev");}
S1590C1 ::S1590C1(){ note_ctor("S1590C1", this);} // tgen

static void Test_S1590C1()
{
  extern Class_Descriptor cd_S1590C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,30)];
    init_test(&cd_S1590C1, buf);
    S1590C1 *dp, &lv = *(dp=new (buf) S1590C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,116), "sizeof(S1590C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1590C1)");
    check_base_class_offset(lv, (S1590C4*)(S1590C3*)(S1590C2*), 0, "S1590C1");
    check_base_class_offset(lv, (S1590C6*)(S1590C3*)(S1590C2*), ABISELECT(96,60), "S1590C1");
    check_base_class_offset(lv, (S1590C7*)(S1590C3*)(S1590C2*), ABISELECT(104,64), "S1590C1");
    check_base_class_offset(lv, (S1590C3*)(S1590C2*), 0, "S1590C1");
    check_base_class_offset(lv, (S1590C2*), 0, "S1590C1");
    check_field_offset(lv, s1590c1f0, ABISELECT(172,108), "S1590C1.s1590c1f0");
    test_class_info(&lv, &cd_S1590C1);
    dp->~S1590C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1590C1(Test_S1590C1, "S1590C1", ABISELECT(184,116));

#else // __cplusplus

extern void _ZN7S1590C1C1Ev();
extern void _ZN7S1590C1D1Ev();
Name_Map name_map_S1590C1[] = {
  NSPAIR(_ZN7S1590C1C1Ev),
  NSPAIR(_ZN7S1590C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1590C4;
extern VTBL_ENTRY _ZTI7S1590C4[];
extern  VTBL_ENTRY _ZTV7S1590C4[];
extern Class_Descriptor cd_S1590C6;
extern VTBL_ENTRY _ZTI7S1590C6[];
extern  VTBL_ENTRY _ZTV7S1590C6[];
extern Class_Descriptor cd_S1590C7;
extern VTBL_ENTRY _ZTI7S1590C7[];
extern  VTBL_ENTRY _ZTV7S1590C7[];
extern Class_Descriptor cd_S1590C3;
extern VTBL_ENTRY _ZTI7S1590C3[];
extern  VTBL_ENTRY _ZTV7S1590C3[];
extern Class_Descriptor cd_S1590C2;
extern VTBL_ENTRY _ZTI7S1590C2[];
extern  VTBL_ENTRY _ZTV7S1590C2[];
static Base_Class bases_S1590C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1590C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C6,    ABISELECT(96,60), //bcp->offset
    127, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C7,    ABISELECT(104,64), //bcp->offset
    145, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1590C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1590C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1590C1[];
extern void _ZN7S1590C1D1Ev();
extern void _ZN7S1590C1D0Ev();
extern void _ZN7S1590C42v9Ev();
extern void _ZN7S1590C43v10Ev();
extern void _ZN7S1590C43v11Ev();
extern void _ZN7S1590C43v12Ev();
extern void _ZN7S1590C43v13Ev();
extern void _ZN7S1590C43v14Ev();
extern void _ZN7S1590C43v15Ev();
extern void _ZN7S1590C43v16Ev();
extern void _ZN7S1590C43v17Ev();
extern void _ZN7S1590C43v18Ev();
extern void _ZN7S1590C43v19Ev();
extern void _ZN7S1590C43v20Ev();
extern void _ZN7S1590C43v21Ev();
extern void _ZN7S1590C43v22Ev();
extern void _ZN7S1590C43v23Ev();
extern void _ZN7S1590C43v24Ev();
extern void _ZN7S1590C43v25Ev();
extern void _ZN7S1590C43v26Ev();
extern void _ZN7S1590C43v27Ev();
extern void _ZN7S1590C43v28Ev();
extern void _ZN7S1590C43v29Ev();
extern void _ZN7S1590C43v30Ev();
extern void _ZN7S1590C43v31Ev();
extern void _ZN7S1590C43v32Ev();
extern void _ZN7S1590C43v33Ev();
extern void _ZN7S1590C43v34Ev();
extern void _ZN7S1590C43v35Ev();
extern void _ZN7S1590C43v36Ev();
extern void _ZN7S1590C43v37Ev();
extern void _ZN7S1590C43v38Ev();
extern void _ZN7S1590C43v39Ev();
extern void _ZN7S1590C43v40Ev();
extern void _ZN7S1590C43v41Ev();
extern void _ZN7S1590C43v42Ev();
extern void _ZN7S1590C43v43Ev();
extern void _ZN7S1590C43v44Ev();
extern void _ZN7S1590C43v45Ev();
extern void _ZN7S1590C43v46Ev();
extern void _ZN7S1590C43v47Ev();
extern void _ZN7S1590C43v48Ev();
extern void _ZN7S1590C43v49Ev();
extern void _ZN7S1590C43v50Ev();
extern void _ZN7S1590C43v51Ev();
extern void _ZN7S1590C43v52Ev();
extern void _ZN7S1590C43v53Ev();
extern void _ZN7S1590C43v54Ev();
extern void _ZN7S1590C43v55Ev();
extern void _ZN7S1590C43v56Ev();
extern void _ZN7S1590C43v57Ev();
extern void _ZN7S1590C43v58Ev();
extern void _ZN7S1590C43v59Ev();
extern void _ZN7S1590C43v60Ev();
extern void _ZN7S1590C43v61Ev();
extern void _ZN7S1590C43v62Ev();
extern void _ZN7S1590C43v63Ev();
extern void _ZN7S1590C43v64Ev();
extern void _ZN7S1590C43v65Ev();
extern void _ZN7S1590C43v66Ev();
extern void _ZN7S1590C43v67Ev();
extern void _ZN7S1590C43v68Ev();
extern void _ZN7S1590C43v69Ev();
extern void _ZN7S1590C43v70Ev();
extern void _ZN7S1590C43v71Ev();
extern void _ZN7S1590C43v72Ev();
extern void _ZN7S1590C33v98Ev();
extern void _ZN7S1590C33v99Ev();
extern void _ZN7S1590C34v100Ev();
extern void _ZN7S1590C34v101Ev();
extern void _ZN7S1590C34v102Ev();
extern void _ZN7S1590C34v103Ev();
extern void _ZN7S1590C34v104Ev();
extern void _ZN7S1590C34v105Ev();
extern void _ZN7S1590C34v106Ev();
extern void _ZN7S1590C34v107Ev();
extern void _ZN7S1590C34v108Ev();
extern void _ZN7S1590C34v109Ev();
extern void _ZN7S1590C34v110Ev();
extern void _ZN7S1590C34v111Ev();
extern void _ZN7S1590C34v112Ev();
extern void _ZN7S1590C34v113Ev();
extern void _ZN7S1590C34v114Ev();
extern void _ZN7S1590C34v115Ev();
extern void _ZN7S1590C34v116Ev();
extern void _ZN7S1590C34v117Ev();
extern void _ZN7S1590C34v118Ev();
extern void _ZN7S1590C34v119Ev();
extern void _ZN7S1590C34v120Ev();
extern void _ZN7S1590C34v121Ev();
extern void _ZN7S1590C24v122Ev();
extern void _ZN7S1590C24v123Ev();
extern void _ZN7S1590C24v124Ev();
extern void _ZN7S1590C24v125Ev();
extern void _ZN7S1590C24v126Ev();
extern void _ZN7S1590C24v127Ev();
extern void _ZN7S1590C24v128Ev();
extern void _ZN7S1590C24v129Ev();
extern void _ZN7S1590C24v130Ev();
extern void _ZN7S1590C24v131Ev();
extern void _ZN7S1590C24v132Ev();
extern void _ZN7S1590C24v133Ev();
extern void _ZN7S1590C24v134Ev();
extern void _ZN7S1590C24v135Ev();
extern void _ZN7S1590C24v136Ev();
extern void _ZN7S1590C24v137Ev();
extern void _ZN7S1590C24v138Ev();
extern void _ZN7S1590C24v139Ev();
extern void _ZN7S1590C24v140Ev();
extern void _ZN7S1590C24v141Ev();
extern void _ZN7S1590C24v142Ev();
extern void _ZN7S1590C24v143Ev();
extern void _ZN7S1590C24v144Ev();
extern void _ZN7S1590C24v145Ev();
extern void _ZN7S1590C24v146Ev();
extern void _ZN7S1590C24v147Ev();
extern void _ZN7S1590C24v148Ev();
extern void _ZN7S1590C12v1Ev();
extern void _ZN7S1590C12v2Ev();
extern void _ZN7S1590C12v3Ev();
extern void _ZN7S1590C12v4Ev();
extern void _ZN7S1590C12v5Ev();
extern void _ZN7S1590C12v6Ev();
extern void _ZN7S1590C12v7Ev();
extern void _ZN7S1590C12v8Ev();
extern void _ZN7S1590C63v73Ev();
extern void _ZN7S1590C63v74Ev();
extern void _ZN7S1590C63v75Ev();
extern void _ZN7S1590C63v76Ev();
extern void _ZN7S1590C63v77Ev();
extern void _ZN7S1590C63v78Ev();
extern void _ZN7S1590C63v79Ev();
extern void _ZN7S1590C63v80Ev();
extern void _ZN7S1590C63v81Ev();
extern void _ZN7S1590C63v82Ev();
extern void _ZN7S1590C63v83Ev();
extern void _ZN7S1590C63v84Ev();
extern void _ZN7S1590C63v85Ev();
extern void _ZN7S1590C63v86Ev();
extern void _ZN7S1590C63v87Ev();
extern void _ZN7S1590C63v88Ev();
extern void _ZN7S1590C73v89Ev();
extern void _ZN7S1590C73v90Ev();
extern void _ZN7S1590C73v91Ev();
extern void _ZN7S1590C73v92Ev();
extern void _ZN7S1590C73v93Ev();
extern void _ZN7S1590C73v94Ev();
extern void _ZN7S1590C73v95Ev();
extern void _ZN7S1590C73v96Ev();
extern void _ZN7S1590C73v97Ev();
static  VTBL_ENTRY vtc_S1590C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1590C1[0]),
  (VTBL_ENTRY)&_ZN7S1590C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1590C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1590C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1590C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1590C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1590C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1590C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1590C12v8Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1590C1[0]),
  (VTBL_ENTRY)&_ZN7S1590C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1590C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1590C1[0]),
  (VTBL_ENTRY)&_ZN7S1590C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1590C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1590C1[];
extern  VTBL_ENTRY _ZTV7S1590C1[];
Class_Descriptor cd_S1590C1 = {  "S1590C1", // class name
  bases_S1590C1, 5,
  &(vtc_S1590C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,116), // object size
  NSPAIRA(_ZTI7S1590C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1590C1),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C4  {
  int s1591c4f0;
  __tsi64 s1591c4f1;
  void *s1591c4f2[4];
  int s1591c4f3[2];
  void *s1591c4f4;
  ::S79C8_nt s1591c4f5;
  void *s1591c4f6[2];
  virtual  ~S1591C4(); // _ZN7S1591C4D1Ev
  virtual void  v9(); // _ZN7S1591C42v9Ev
  virtual void  v10(); // _ZN7S1591C43v10Ev
  virtual void  v11(); // _ZN7S1591C43v11Ev
  virtual void  v12(); // _ZN7S1591C43v12Ev
  virtual void  v13(); // _ZN7S1591C43v13Ev
  virtual void  v14(); // _ZN7S1591C43v14Ev
  virtual void  v15(); // _ZN7S1591C43v15Ev
  virtual void  v16(); // _ZN7S1591C43v16Ev
  virtual void  v17(); // _ZN7S1591C43v17Ev
  virtual void  v18(); // _ZN7S1591C43v18Ev
  virtual void  v19(); // _ZN7S1591C43v19Ev
  virtual void  v20(); // _ZN7S1591C43v20Ev
  virtual void  v21(); // _ZN7S1591C43v21Ev
  virtual void  v22(); // _ZN7S1591C43v22Ev
  virtual void  v23(); // _ZN7S1591C43v23Ev
  virtual void  v24(); // _ZN7S1591C43v24Ev
  virtual void  v25(); // _ZN7S1591C43v25Ev
  virtual void  v26(); // _ZN7S1591C43v26Ev
  virtual void  v27(); // _ZN7S1591C43v27Ev
  virtual void  v28(); // _ZN7S1591C43v28Ev
  virtual void  v29(); // _ZN7S1591C43v29Ev
  virtual void  v30(); // _ZN7S1591C43v30Ev
  virtual void  v31(); // _ZN7S1591C43v31Ev
  virtual void  v32(); // _ZN7S1591C43v32Ev
  virtual void  v33(); // _ZN7S1591C43v33Ev
  virtual void  v34(); // _ZN7S1591C43v34Ev
  virtual void  v35(); // _ZN7S1591C43v35Ev
  virtual void  v36(); // _ZN7S1591C43v36Ev
  virtual void  v37(); // _ZN7S1591C43v37Ev
  virtual void  v38(); // _ZN7S1591C43v38Ev
  virtual void  v39(); // _ZN7S1591C43v39Ev
  virtual void  v40(); // _ZN7S1591C43v40Ev
  virtual void  v41(); // _ZN7S1591C43v41Ev
  virtual void  v42(); // _ZN7S1591C43v42Ev
  virtual void  v43(); // _ZN7S1591C43v43Ev
  virtual void  v44(); // _ZN7S1591C43v44Ev
  virtual void  v45(); // _ZN7S1591C43v45Ev
  virtual void  v46(); // _ZN7S1591C43v46Ev
  virtual void  v47(); // _ZN7S1591C43v47Ev
  virtual void  v48(); // _ZN7S1591C43v48Ev
  virtual void  v49(); // _ZN7S1591C43v49Ev
  virtual void  v50(); // _ZN7S1591C43v50Ev
  virtual void  v51(); // _ZN7S1591C43v51Ev
  virtual void  v52(); // _ZN7S1591C43v52Ev
  virtual void  v53(); // _ZN7S1591C43v53Ev
  virtual void  v54(); // _ZN7S1591C43v54Ev
  virtual void  v55(); // _ZN7S1591C43v55Ev
  virtual void  v56(); // _ZN7S1591C43v56Ev
  virtual void  v57(); // _ZN7S1591C43v57Ev
  virtual void  v58(); // _ZN7S1591C43v58Ev
  virtual void  v59(); // _ZN7S1591C43v59Ev
  virtual void  v60(); // _ZN7S1591C43v60Ev
  virtual void  v61(); // _ZN7S1591C43v61Ev
  virtual void  v62(); // _ZN7S1591C43v62Ev
  virtual void  v63(); // _ZN7S1591C43v63Ev
  virtual void  v64(); // _ZN7S1591C43v64Ev
  virtual void  v65(); // _ZN7S1591C43v65Ev
  virtual void  v66(); // _ZN7S1591C43v66Ev
  virtual void  v67(); // _ZN7S1591C43v67Ev
  virtual void  v68(); // _ZN7S1591C43v68Ev
  virtual void  v69(); // _ZN7S1591C43v69Ev
  virtual void  v70(); // _ZN7S1591C43v70Ev
  virtual void  v71(); // _ZN7S1591C43v71Ev
  virtual void  v72(); // _ZN7S1591C43v72Ev
  S1591C4(); // tgen
};
//SIG(-1 S1591C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1591C4 ::~S1591C4(){ note_dtor("S1591C4", this);}
void  S1591C4 ::v9(){vfunc_called(this, "_ZN7S1591C42v9Ev");}
void  S1591C4 ::v10(){vfunc_called(this, "_ZN7S1591C43v10Ev");}
void  S1591C4 ::v11(){vfunc_called(this, "_ZN7S1591C43v11Ev");}
void  S1591C4 ::v12(){vfunc_called(this, "_ZN7S1591C43v12Ev");}
void  S1591C4 ::v13(){vfunc_called(this, "_ZN7S1591C43v13Ev");}
void  S1591C4 ::v14(){vfunc_called(this, "_ZN7S1591C43v14Ev");}
void  S1591C4 ::v15(){vfunc_called(this, "_ZN7S1591C43v15Ev");}
void  S1591C4 ::v16(){vfunc_called(this, "_ZN7S1591C43v16Ev");}
void  S1591C4 ::v17(){vfunc_called(this, "_ZN7S1591C43v17Ev");}
void  S1591C4 ::v18(){vfunc_called(this, "_ZN7S1591C43v18Ev");}
void  S1591C4 ::v19(){vfunc_called(this, "_ZN7S1591C43v19Ev");}
void  S1591C4 ::v20(){vfunc_called(this, "_ZN7S1591C43v20Ev");}
void  S1591C4 ::v21(){vfunc_called(this, "_ZN7S1591C43v21Ev");}
void  S1591C4 ::v22(){vfunc_called(this, "_ZN7S1591C43v22Ev");}
void  S1591C4 ::v23(){vfunc_called(this, "_ZN7S1591C43v23Ev");}
void  S1591C4 ::v24(){vfunc_called(this, "_ZN7S1591C43v24Ev");}
void  S1591C4 ::v25(){vfunc_called(this, "_ZN7S1591C43v25Ev");}
void  S1591C4 ::v26(){vfunc_called(this, "_ZN7S1591C43v26Ev");}
void  S1591C4 ::v27(){vfunc_called(this, "_ZN7S1591C43v27Ev");}
void  S1591C4 ::v28(){vfunc_called(this, "_ZN7S1591C43v28Ev");}
void  S1591C4 ::v29(){vfunc_called(this, "_ZN7S1591C43v29Ev");}
void  S1591C4 ::v30(){vfunc_called(this, "_ZN7S1591C43v30Ev");}
void  S1591C4 ::v31(){vfunc_called(this, "_ZN7S1591C43v31Ev");}
void  S1591C4 ::v32(){vfunc_called(this, "_ZN7S1591C43v32Ev");}
void  S1591C4 ::v33(){vfunc_called(this, "_ZN7S1591C43v33Ev");}
void  S1591C4 ::v34(){vfunc_called(this, "_ZN7S1591C43v34Ev");}
void  S1591C4 ::v35(){vfunc_called(this, "_ZN7S1591C43v35Ev");}
void  S1591C4 ::v36(){vfunc_called(this, "_ZN7S1591C43v36Ev");}
void  S1591C4 ::v37(){vfunc_called(this, "_ZN7S1591C43v37Ev");}
void  S1591C4 ::v38(){vfunc_called(this, "_ZN7S1591C43v38Ev");}
void  S1591C4 ::v39(){vfunc_called(this, "_ZN7S1591C43v39Ev");}
void  S1591C4 ::v40(){vfunc_called(this, "_ZN7S1591C43v40Ev");}
void  S1591C4 ::v41(){vfunc_called(this, "_ZN7S1591C43v41Ev");}
void  S1591C4 ::v42(){vfunc_called(this, "_ZN7S1591C43v42Ev");}
void  S1591C4 ::v43(){vfunc_called(this, "_ZN7S1591C43v43Ev");}
void  S1591C4 ::v44(){vfunc_called(this, "_ZN7S1591C43v44Ev");}
void  S1591C4 ::v45(){vfunc_called(this, "_ZN7S1591C43v45Ev");}
void  S1591C4 ::v46(){vfunc_called(this, "_ZN7S1591C43v46Ev");}
void  S1591C4 ::v47(){vfunc_called(this, "_ZN7S1591C43v47Ev");}
void  S1591C4 ::v48(){vfunc_called(this, "_ZN7S1591C43v48Ev");}
void  S1591C4 ::v49(){vfunc_called(this, "_ZN7S1591C43v49Ev");}
void  S1591C4 ::v50(){vfunc_called(this, "_ZN7S1591C43v50Ev");}
void  S1591C4 ::v51(){vfunc_called(this, "_ZN7S1591C43v51Ev");}
void  S1591C4 ::v52(){vfunc_called(this, "_ZN7S1591C43v52Ev");}
void  S1591C4 ::v53(){vfunc_called(this, "_ZN7S1591C43v53Ev");}
void  S1591C4 ::v54(){vfunc_called(this, "_ZN7S1591C43v54Ev");}
void  S1591C4 ::v55(){vfunc_called(this, "_ZN7S1591C43v55Ev");}
void  S1591C4 ::v56(){vfunc_called(this, "_ZN7S1591C43v56Ev");}
void  S1591C4 ::v57(){vfunc_called(this, "_ZN7S1591C43v57Ev");}
void  S1591C4 ::v58(){vfunc_called(this, "_ZN7S1591C43v58Ev");}
void  S1591C4 ::v59(){vfunc_called(this, "_ZN7S1591C43v59Ev");}
void  S1591C4 ::v60(){vfunc_called(this, "_ZN7S1591C43v60Ev");}
void  S1591C4 ::v61(){vfunc_called(this, "_ZN7S1591C43v61Ev");}
void  S1591C4 ::v62(){vfunc_called(this, "_ZN7S1591C43v62Ev");}
void  S1591C4 ::v63(){vfunc_called(this, "_ZN7S1591C43v63Ev");}
void  S1591C4 ::v64(){vfunc_called(this, "_ZN7S1591C43v64Ev");}
void  S1591C4 ::v65(){vfunc_called(this, "_ZN7S1591C43v65Ev");}
void  S1591C4 ::v66(){vfunc_called(this, "_ZN7S1591C43v66Ev");}
void  S1591C4 ::v67(){vfunc_called(this, "_ZN7S1591C43v67Ev");}
void  S1591C4 ::v68(){vfunc_called(this, "_ZN7S1591C43v68Ev");}
void  S1591C4 ::v69(){vfunc_called(this, "_ZN7S1591C43v69Ev");}
void  S1591C4 ::v70(){vfunc_called(this, "_ZN7S1591C43v70Ev");}
void  S1591C4 ::v71(){vfunc_called(this, "_ZN7S1591C43v71Ev");}
void  S1591C4 ::v72(){vfunc_called(this, "_ZN7S1591C43v72Ev");}
S1591C4 ::S1591C4(){ note_ctor("S1591C4", this);} // tgen

static void Test_S1591C4()
{
  extern Class_Descriptor cd_S1591C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1591C4, buf);
    S1591C4 *dp, &lv = *(dp=new (buf) S1591C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1591C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C4)");
    check_field_offset(lv, s1591c4f0, ABISELECT(8,4), "S1591C4.s1591c4f0");
    check_field_offset(lv, s1591c4f1, ABISELECT(16,8), "S1591C4.s1591c4f1");
    check_field_offset(lv, s1591c4f2, ABISELECT(24,16), "S1591C4.s1591c4f2");
    check_field_offset(lv, s1591c4f3, ABISELECT(56,32), "S1591C4.s1591c4f3");
    check_field_offset(lv, s1591c4f4, ABISELECT(64,40), "S1591C4.s1591c4f4");
    check_field_offset(lv, s1591c4f5, ABISELECT(72,44), "S1591C4.s1591c4f5");
    check_field_offset(lv, s1591c4f6, ABISELECT(80,52), "S1591C4.s1591c4f6");
    test_class_info(&lv, &cd_S1591C4);
    dp->~S1591C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C4(Test_S1591C4, "S1591C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1591C4C1Ev();
extern void _ZN7S1591C4D1Ev();
Name_Map name_map_S1591C4[] = {
  NSPAIR(_ZN7S1591C4C1Ev),
  NSPAIR(_ZN7S1591C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1591C4[];
extern void _ZN7S1591C4D1Ev();
extern void _ZN7S1591C4D0Ev();
extern void _ZN7S1591C42v9Ev();
extern void _ZN7S1591C43v10Ev();
extern void _ZN7S1591C43v11Ev();
extern void _ZN7S1591C43v12Ev();
extern void _ZN7S1591C43v13Ev();
extern void _ZN7S1591C43v14Ev();
extern void _ZN7S1591C43v15Ev();
extern void _ZN7S1591C43v16Ev();
extern void _ZN7S1591C43v17Ev();
extern void _ZN7S1591C43v18Ev();
extern void _ZN7S1591C43v19Ev();
extern void _ZN7S1591C43v20Ev();
extern void _ZN7S1591C43v21Ev();
extern void _ZN7S1591C43v22Ev();
extern void _ZN7S1591C43v23Ev();
extern void _ZN7S1591C43v24Ev();
extern void _ZN7S1591C43v25Ev();
extern void _ZN7S1591C43v26Ev();
extern void _ZN7S1591C43v27Ev();
extern void _ZN7S1591C43v28Ev();
extern void _ZN7S1591C43v29Ev();
extern void _ZN7S1591C43v30Ev();
extern void _ZN7S1591C43v31Ev();
extern void _ZN7S1591C43v32Ev();
extern void _ZN7S1591C43v33Ev();
extern void _ZN7S1591C43v34Ev();
extern void _ZN7S1591C43v35Ev();
extern void _ZN7S1591C43v36Ev();
extern void _ZN7S1591C43v37Ev();
extern void _ZN7S1591C43v38Ev();
extern void _ZN7S1591C43v39Ev();
extern void _ZN7S1591C43v40Ev();
extern void _ZN7S1591C43v41Ev();
extern void _ZN7S1591C43v42Ev();
extern void _ZN7S1591C43v43Ev();
extern void _ZN7S1591C43v44Ev();
extern void _ZN7S1591C43v45Ev();
extern void _ZN7S1591C43v46Ev();
extern void _ZN7S1591C43v47Ev();
extern void _ZN7S1591C43v48Ev();
extern void _ZN7S1591C43v49Ev();
extern void _ZN7S1591C43v50Ev();
extern void _ZN7S1591C43v51Ev();
extern void _ZN7S1591C43v52Ev();
extern void _ZN7S1591C43v53Ev();
extern void _ZN7S1591C43v54Ev();
extern void _ZN7S1591C43v55Ev();
extern void _ZN7S1591C43v56Ev();
extern void _ZN7S1591C43v57Ev();
extern void _ZN7S1591C43v58Ev();
extern void _ZN7S1591C43v59Ev();
extern void _ZN7S1591C43v60Ev();
extern void _ZN7S1591C43v61Ev();
extern void _ZN7S1591C43v62Ev();
extern void _ZN7S1591C43v63Ev();
extern void _ZN7S1591C43v64Ev();
extern void _ZN7S1591C43v65Ev();
extern void _ZN7S1591C43v66Ev();
extern void _ZN7S1591C43v67Ev();
extern void _ZN7S1591C43v68Ev();
extern void _ZN7S1591C43v69Ev();
extern void _ZN7S1591C43v70Ev();
extern void _ZN7S1591C43v71Ev();
extern void _ZN7S1591C43v72Ev();
static  VTBL_ENTRY vtc_S1591C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C4[0]),
  (VTBL_ENTRY)&_ZN7S1591C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1591C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1591C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1591C4[];
extern  VTBL_ENTRY _ZTV7S1591C4[];
Class_Descriptor cd_S1591C4 = {  "S1591C4", // class name
  0,0,//no base classes
  &(vtc_S1591C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1591C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1591C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C6  {
  virtual void  v73(); // _ZN7S1591C63v73Ev
  virtual void  v74(); // _ZN7S1591C63v74Ev
  virtual void  v75(); // _ZN7S1591C63v75Ev
  virtual void  v76(); // _ZN7S1591C63v76Ev
  virtual void  v77(); // _ZN7S1591C63v77Ev
  virtual void  v78(); // _ZN7S1591C63v78Ev
  virtual void  v79(); // _ZN7S1591C63v79Ev
  virtual void  v80(); // _ZN7S1591C63v80Ev
  virtual void  v81(); // _ZN7S1591C63v81Ev
  virtual void  v82(); // _ZN7S1591C63v82Ev
  virtual void  v83(); // _ZN7S1591C63v83Ev
  virtual void  v84(); // _ZN7S1591C63v84Ev
  virtual void  v85(); // _ZN7S1591C63v85Ev
  virtual void  v86(); // _ZN7S1591C63v86Ev
  virtual void  v87(); // _ZN7S1591C63v87Ev
  virtual void  v88(); // _ZN7S1591C63v88Ev
  ~S1591C6(); // tgen
  S1591C6(); // tgen
};
//SIG(-1 S1591C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1591C6 ::v73(){vfunc_called(this, "_ZN7S1591C63v73Ev");}
void  S1591C6 ::v74(){vfunc_called(this, "_ZN7S1591C63v74Ev");}
void  S1591C6 ::v75(){vfunc_called(this, "_ZN7S1591C63v75Ev");}
void  S1591C6 ::v76(){vfunc_called(this, "_ZN7S1591C63v76Ev");}
void  S1591C6 ::v77(){vfunc_called(this, "_ZN7S1591C63v77Ev");}
void  S1591C6 ::v78(){vfunc_called(this, "_ZN7S1591C63v78Ev");}
void  S1591C6 ::v79(){vfunc_called(this, "_ZN7S1591C63v79Ev");}
void  S1591C6 ::v80(){vfunc_called(this, "_ZN7S1591C63v80Ev");}
void  S1591C6 ::v81(){vfunc_called(this, "_ZN7S1591C63v81Ev");}
void  S1591C6 ::v82(){vfunc_called(this, "_ZN7S1591C63v82Ev");}
void  S1591C6 ::v83(){vfunc_called(this, "_ZN7S1591C63v83Ev");}
void  S1591C6 ::v84(){vfunc_called(this, "_ZN7S1591C63v84Ev");}
void  S1591C6 ::v85(){vfunc_called(this, "_ZN7S1591C63v85Ev");}
void  S1591C6 ::v86(){vfunc_called(this, "_ZN7S1591C63v86Ev");}
void  S1591C6 ::v87(){vfunc_called(this, "_ZN7S1591C63v87Ev");}
void  S1591C6 ::v88(){vfunc_called(this, "_ZN7S1591C63v88Ev");}
S1591C6 ::~S1591C6(){ note_dtor("S1591C6", this);} // tgen
S1591C6 ::S1591C6(){ note_ctor("S1591C6", this);} // tgen

static void Test_S1591C6()
{
  extern Class_Descriptor cd_S1591C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1591C6, buf);
    S1591C6 *dp, &lv = *(dp=new (buf) S1591C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1591C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C6)");
    test_class_info(&lv, &cd_S1591C6);
    dp->~S1591C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C6(Test_S1591C6, "S1591C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1591C6C1Ev();
extern void _ZN7S1591C6D1Ev();
Name_Map name_map_S1591C6[] = {
  NSPAIR(_ZN7S1591C6C1Ev),
  NSPAIR(_ZN7S1591C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1591C6[];
extern void _ZN7S1591C63v73Ev();
extern void _ZN7S1591C63v74Ev();
extern void _ZN7S1591C63v75Ev();
extern void _ZN7S1591C63v76Ev();
extern void _ZN7S1591C63v77Ev();
extern void _ZN7S1591C63v78Ev();
extern void _ZN7S1591C63v79Ev();
extern void _ZN7S1591C63v80Ev();
extern void _ZN7S1591C63v81Ev();
extern void _ZN7S1591C63v82Ev();
extern void _ZN7S1591C63v83Ev();
extern void _ZN7S1591C63v84Ev();
extern void _ZN7S1591C63v85Ev();
extern void _ZN7S1591C63v86Ev();
extern void _ZN7S1591C63v87Ev();
extern void _ZN7S1591C63v88Ev();
static  VTBL_ENTRY vtc_S1591C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C6[0]),
  (VTBL_ENTRY)&_ZN7S1591C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v88Ev,
};
extern VTBL_ENTRY _ZTI7S1591C6[];
extern  VTBL_ENTRY _ZTV7S1591C6[];
Class_Descriptor cd_S1591C6 = {  "S1591C6", // class name
  0,0,//no base classes
  &(vtc_S1591C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1591C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1591C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C7  {
  virtual void  v89(); // _ZN7S1591C73v89Ev
  virtual void  v90(); // _ZN7S1591C73v90Ev
  virtual void  v91(); // _ZN7S1591C73v91Ev
  virtual void  v92(); // _ZN7S1591C73v92Ev
  virtual void  v93(); // _ZN7S1591C73v93Ev
  virtual void  v94(); // _ZN7S1591C73v94Ev
  virtual void  v95(); // _ZN7S1591C73v95Ev
  virtual void  v96(); // _ZN7S1591C73v96Ev
  virtual void  v97(); // _ZN7S1591C73v97Ev
  ~S1591C7(); // tgen
  S1591C7(); // tgen
};
//SIG(-1 S1591C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1591C7 ::v89(){vfunc_called(this, "_ZN7S1591C73v89Ev");}
void  S1591C7 ::v90(){vfunc_called(this, "_ZN7S1591C73v90Ev");}
void  S1591C7 ::v91(){vfunc_called(this, "_ZN7S1591C73v91Ev");}
void  S1591C7 ::v92(){vfunc_called(this, "_ZN7S1591C73v92Ev");}
void  S1591C7 ::v93(){vfunc_called(this, "_ZN7S1591C73v93Ev");}
void  S1591C7 ::v94(){vfunc_called(this, "_ZN7S1591C73v94Ev");}
void  S1591C7 ::v95(){vfunc_called(this, "_ZN7S1591C73v95Ev");}
void  S1591C7 ::v96(){vfunc_called(this, "_ZN7S1591C73v96Ev");}
void  S1591C7 ::v97(){vfunc_called(this, "_ZN7S1591C73v97Ev");}
S1591C7 ::~S1591C7(){ note_dtor("S1591C7", this);} // tgen
S1591C7 ::S1591C7(){ note_ctor("S1591C7", this);} // tgen

static void Test_S1591C7()
{
  extern Class_Descriptor cd_S1591C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1591C7, buf);
    S1591C7 *dp, &lv = *(dp=new (buf) S1591C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1591C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C7)");
    test_class_info(&lv, &cd_S1591C7);
    dp->~S1591C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C7(Test_S1591C7, "S1591C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1591C7C1Ev();
extern void _ZN7S1591C7D1Ev();
Name_Map name_map_S1591C7[] = {
  NSPAIR(_ZN7S1591C7C1Ev),
  NSPAIR(_ZN7S1591C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1591C7[];
extern void _ZN7S1591C73v89Ev();
extern void _ZN7S1591C73v90Ev();
extern void _ZN7S1591C73v91Ev();
extern void _ZN7S1591C73v92Ev();
extern void _ZN7S1591C73v93Ev();
extern void _ZN7S1591C73v94Ev();
extern void _ZN7S1591C73v95Ev();
extern void _ZN7S1591C73v96Ev();
extern void _ZN7S1591C73v97Ev();
static  VTBL_ENTRY vtc_S1591C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C7[0]),
  (VTBL_ENTRY)&_ZN7S1591C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1591C7[];
extern  VTBL_ENTRY _ZTV7S1591C7[];
Class_Descriptor cd_S1591C7 = {  "S1591C7", // class name
  0,0,//no base classes
  &(vtc_S1591C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1591C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1591C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C3  : S1591C4 , S1591C6 , S1591C7 {
  void *s1591c3f0;
  ::S79C39_nt s1591c3f1;
  unsigned int s1591c3f2:1;
  unsigned int s1591c3f3:1;
  unsigned int s1591c3f4:1;
  unsigned int s1591c3f5:1;
  virtual  ~S1591C3(); // _ZN7S1591C3D1Ev
  virtual void  v98(); // _ZN7S1591C33v98Ev
  virtual void  v99(); // _ZN7S1591C33v99Ev
  virtual void  v100(); // _ZN7S1591C34v100Ev
  virtual void  v101(); // _ZN7S1591C34v101Ev
  virtual void  v102(); // _ZN7S1591C34v102Ev
  virtual void  v103(); // _ZN7S1591C34v103Ev
  virtual void  v104(); // _ZN7S1591C34v104Ev
  virtual void  v105(); // _ZN7S1591C34v105Ev
  virtual void  v106(); // _ZN7S1591C34v106Ev
  virtual void  v107(); // _ZN7S1591C34v107Ev
  virtual void  v108(); // _ZN7S1591C34v108Ev
  virtual void  v109(); // _ZN7S1591C34v109Ev
  virtual void  v110(); // _ZN7S1591C34v110Ev
  virtual void  v111(); // _ZN7S1591C34v111Ev
  virtual void  v112(); // _ZN7S1591C34v112Ev
  virtual void  v113(); // _ZN7S1591C34v113Ev
  virtual void  v114(); // _ZN7S1591C34v114Ev
  virtual void  v115(); // _ZN7S1591C34v115Ev
  virtual void  v116(); // _ZN7S1591C34v116Ev
  virtual void  v117(); // _ZN7S1591C34v117Ev
  virtual void  v118(); // _ZN7S1591C34v118Ev
  virtual void  v119(); // _ZN7S1591C34v119Ev
  virtual void  v120(); // _ZN7S1591C34v120Ev
  virtual void  v121(); // _ZN7S1591C34v121Ev
  S1591C3(); // tgen
};
//SIG(-1 S1591C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1591C3 ::~S1591C3(){ note_dtor("S1591C3", this);}
void  S1591C3 ::v98(){vfunc_called(this, "_ZN7S1591C33v98Ev");}
void  S1591C3 ::v99(){vfunc_called(this, "_ZN7S1591C33v99Ev");}
void  S1591C3 ::v100(){vfunc_called(this, "_ZN7S1591C34v100Ev");}
void  S1591C3 ::v101(){vfunc_called(this, "_ZN7S1591C34v101Ev");}
void  S1591C3 ::v102(){vfunc_called(this, "_ZN7S1591C34v102Ev");}
void  S1591C3 ::v103(){vfunc_called(this, "_ZN7S1591C34v103Ev");}
void  S1591C3 ::v104(){vfunc_called(this, "_ZN7S1591C34v104Ev");}
void  S1591C3 ::v105(){vfunc_called(this, "_ZN7S1591C34v105Ev");}
void  S1591C3 ::v106(){vfunc_called(this, "_ZN7S1591C34v106Ev");}
void  S1591C3 ::v107(){vfunc_called(this, "_ZN7S1591C34v107Ev");}
void  S1591C3 ::v108(){vfunc_called(this, "_ZN7S1591C34v108Ev");}
void  S1591C3 ::v109(){vfunc_called(this, "_ZN7S1591C34v109Ev");}
void  S1591C3 ::v110(){vfunc_called(this, "_ZN7S1591C34v110Ev");}
void  S1591C3 ::v111(){vfunc_called(this, "_ZN7S1591C34v111Ev");}
void  S1591C3 ::v112(){vfunc_called(this, "_ZN7S1591C34v112Ev");}
void  S1591C3 ::v113(){vfunc_called(this, "_ZN7S1591C34v113Ev");}
void  S1591C3 ::v114(){vfunc_called(this, "_ZN7S1591C34v114Ev");}
void  S1591C3 ::v115(){vfunc_called(this, "_ZN7S1591C34v115Ev");}
void  S1591C3 ::v116(){vfunc_called(this, "_ZN7S1591C34v116Ev");}
void  S1591C3 ::v117(){vfunc_called(this, "_ZN7S1591C34v117Ev");}
void  S1591C3 ::v118(){vfunc_called(this, "_ZN7S1591C34v118Ev");}
void  S1591C3 ::v119(){vfunc_called(this, "_ZN7S1591C34v119Ev");}
void  S1591C3 ::v120(){vfunc_called(this, "_ZN7S1591C34v120Ev");}
void  S1591C3 ::v121(){vfunc_called(this, "_ZN7S1591C34v121Ev");}
S1591C3 ::S1591C3(){ note_ctor("S1591C3", this);} // tgen

static void Test_S1591C3()
{
  extern Class_Descriptor cd_S1591C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1591C3, buf);
    S1591C3 *dp, &lv = *(dp=new (buf) S1591C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1591C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C3)");
    check_base_class_offset(lv, (S1591C4*), 0, "S1591C3");
    check_base_class_offset(lv, (S1591C6*), ABISELECT(96,60), "S1591C3");
    check_base_class_offset(lv, (S1591C7*), ABISELECT(104,64), "S1591C3");
    check_field_offset(lv, s1591c3f0, ABISELECT(112,68), "S1591C3.s1591c3f0");
    check_field_offset(lv, s1591c3f1, ABISELECT(120,72), "S1591C3.s1591c3f1");
    set_bf_and_test(lv, s1591c3f2, ABISELECT(136,84), 0, 1, 1, "S1591C3");
    set_bf_and_test(lv, s1591c3f3, ABISELECT(136,84), 1, 1, 1, "S1591C3");
    set_bf_and_test(lv, s1591c3f4, ABISELECT(136,84), 2, 1, 1, "S1591C3");
    set_bf_and_test(lv, s1591c3f5, ABISELECT(136,84), 3, 1, 1, "S1591C3");
    test_class_info(&lv, &cd_S1591C3);
    dp->~S1591C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C3(Test_S1591C3, "S1591C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1591C3C1Ev();
extern void _ZN7S1591C3D1Ev();
Name_Map name_map_S1591C3[] = {
  NSPAIR(_ZN7S1591C3C1Ev),
  NSPAIR(_ZN7S1591C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1591C4;
extern VTBL_ENTRY _ZTI7S1591C4[];
extern  VTBL_ENTRY _ZTV7S1591C4[];
extern Class_Descriptor cd_S1591C6;
extern VTBL_ENTRY _ZTI7S1591C6[];
extern  VTBL_ENTRY _ZTV7S1591C6[];
extern Class_Descriptor cd_S1591C7;
extern VTBL_ENTRY _ZTI7S1591C7[];
extern  VTBL_ENTRY _ZTV7S1591C7[];
static Base_Class bases_S1591C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1591C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1591C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1591C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1591C3[];
extern void _ZN7S1591C3D1Ev();
extern void _ZN7S1591C3D0Ev();
extern void _ZN7S1591C42v9Ev();
extern void _ZN7S1591C43v10Ev();
extern void _ZN7S1591C43v11Ev();
extern void _ZN7S1591C43v12Ev();
extern void _ZN7S1591C43v13Ev();
extern void _ZN7S1591C43v14Ev();
extern void _ZN7S1591C43v15Ev();
extern void _ZN7S1591C43v16Ev();
extern void _ZN7S1591C43v17Ev();
extern void _ZN7S1591C43v18Ev();
extern void _ZN7S1591C43v19Ev();
extern void _ZN7S1591C43v20Ev();
extern void _ZN7S1591C43v21Ev();
extern void _ZN7S1591C43v22Ev();
extern void _ZN7S1591C43v23Ev();
extern void _ZN7S1591C43v24Ev();
extern void _ZN7S1591C43v25Ev();
extern void _ZN7S1591C43v26Ev();
extern void _ZN7S1591C43v27Ev();
extern void _ZN7S1591C43v28Ev();
extern void _ZN7S1591C43v29Ev();
extern void _ZN7S1591C43v30Ev();
extern void _ZN7S1591C43v31Ev();
extern void _ZN7S1591C43v32Ev();
extern void _ZN7S1591C43v33Ev();
extern void _ZN7S1591C43v34Ev();
extern void _ZN7S1591C43v35Ev();
extern void _ZN7S1591C43v36Ev();
extern void _ZN7S1591C43v37Ev();
extern void _ZN7S1591C43v38Ev();
extern void _ZN7S1591C43v39Ev();
extern void _ZN7S1591C43v40Ev();
extern void _ZN7S1591C43v41Ev();
extern void _ZN7S1591C43v42Ev();
extern void _ZN7S1591C43v43Ev();
extern void _ZN7S1591C43v44Ev();
extern void _ZN7S1591C43v45Ev();
extern void _ZN7S1591C43v46Ev();
extern void _ZN7S1591C43v47Ev();
extern void _ZN7S1591C43v48Ev();
extern void _ZN7S1591C43v49Ev();
extern void _ZN7S1591C43v50Ev();
extern void _ZN7S1591C43v51Ev();
extern void _ZN7S1591C43v52Ev();
extern void _ZN7S1591C43v53Ev();
extern void _ZN7S1591C43v54Ev();
extern void _ZN7S1591C43v55Ev();
extern void _ZN7S1591C43v56Ev();
extern void _ZN7S1591C43v57Ev();
extern void _ZN7S1591C43v58Ev();
extern void _ZN7S1591C43v59Ev();
extern void _ZN7S1591C43v60Ev();
extern void _ZN7S1591C43v61Ev();
extern void _ZN7S1591C43v62Ev();
extern void _ZN7S1591C43v63Ev();
extern void _ZN7S1591C43v64Ev();
extern void _ZN7S1591C43v65Ev();
extern void _ZN7S1591C43v66Ev();
extern void _ZN7S1591C43v67Ev();
extern void _ZN7S1591C43v68Ev();
extern void _ZN7S1591C43v69Ev();
extern void _ZN7S1591C43v70Ev();
extern void _ZN7S1591C43v71Ev();
extern void _ZN7S1591C43v72Ev();
extern void _ZN7S1591C33v98Ev();
extern void _ZN7S1591C33v99Ev();
extern void _ZN7S1591C34v100Ev();
extern void _ZN7S1591C34v101Ev();
extern void _ZN7S1591C34v102Ev();
extern void _ZN7S1591C34v103Ev();
extern void _ZN7S1591C34v104Ev();
extern void _ZN7S1591C34v105Ev();
extern void _ZN7S1591C34v106Ev();
extern void _ZN7S1591C34v107Ev();
extern void _ZN7S1591C34v108Ev();
extern void _ZN7S1591C34v109Ev();
extern void _ZN7S1591C34v110Ev();
extern void _ZN7S1591C34v111Ev();
extern void _ZN7S1591C34v112Ev();
extern void _ZN7S1591C34v113Ev();
extern void _ZN7S1591C34v114Ev();
extern void _ZN7S1591C34v115Ev();
extern void _ZN7S1591C34v116Ev();
extern void _ZN7S1591C34v117Ev();
extern void _ZN7S1591C34v118Ev();
extern void _ZN7S1591C34v119Ev();
extern void _ZN7S1591C34v120Ev();
extern void _ZN7S1591C34v121Ev();
extern void _ZN7S1591C63v73Ev();
extern void _ZN7S1591C63v74Ev();
extern void _ZN7S1591C63v75Ev();
extern void _ZN7S1591C63v76Ev();
extern void _ZN7S1591C63v77Ev();
extern void _ZN7S1591C63v78Ev();
extern void _ZN7S1591C63v79Ev();
extern void _ZN7S1591C63v80Ev();
extern void _ZN7S1591C63v81Ev();
extern void _ZN7S1591C63v82Ev();
extern void _ZN7S1591C63v83Ev();
extern void _ZN7S1591C63v84Ev();
extern void _ZN7S1591C63v85Ev();
extern void _ZN7S1591C63v86Ev();
extern void _ZN7S1591C63v87Ev();
extern void _ZN7S1591C63v88Ev();
extern void _ZN7S1591C73v89Ev();
extern void _ZN7S1591C73v90Ev();
extern void _ZN7S1591C73v91Ev();
extern void _ZN7S1591C73v92Ev();
extern void _ZN7S1591C73v93Ev();
extern void _ZN7S1591C73v94Ev();
extern void _ZN7S1591C73v95Ev();
extern void _ZN7S1591C73v96Ev();
extern void _ZN7S1591C73v97Ev();
static  VTBL_ENTRY vtc_S1591C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C3[0]),
  (VTBL_ENTRY)&_ZN7S1591C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1591C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1591C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v121Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1591C3[0]),
  (VTBL_ENTRY)&_ZN7S1591C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1591C3[0]),
  (VTBL_ENTRY)&_ZN7S1591C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1591C3[];
extern  VTBL_ENTRY _ZTV7S1591C3[];
Class_Descriptor cd_S1591C3 = {  "S1591C3", // class name
  bases_S1591C3, 3,
  &(vtc_S1591C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1591C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1591C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C2  : S1591C3 {
  ::S3262C11_nt s1591c2f0;
  int s1591c2f1;
  virtual  ~S1591C2(); // _ZN7S1591C2D1Ev
  virtual void  v122(); // _ZN7S1591C24v122Ev
  virtual void  v123(); // _ZN7S1591C24v123Ev
  virtual void  v124(); // _ZN7S1591C24v124Ev
  virtual void  v125(); // _ZN7S1591C24v125Ev
  virtual void  v126(); // _ZN7S1591C24v126Ev
  virtual void  v127(); // _ZN7S1591C24v127Ev
  virtual void  v128(); // _ZN7S1591C24v128Ev
  virtual void  v129(); // _ZN7S1591C24v129Ev
  virtual void  v130(); // _ZN7S1591C24v130Ev
  virtual void  v131(); // _ZN7S1591C24v131Ev
  virtual void  v132(); // _ZN7S1591C24v132Ev
  virtual void  v133(); // _ZN7S1591C24v133Ev
  virtual void  v134(); // _ZN7S1591C24v134Ev
  virtual void  v135(); // _ZN7S1591C24v135Ev
  virtual void  v136(); // _ZN7S1591C24v136Ev
  virtual void  v137(); // _ZN7S1591C24v137Ev
  virtual void  v138(); // _ZN7S1591C24v138Ev
  virtual void  v139(); // _ZN7S1591C24v139Ev
  virtual void  v140(); // _ZN7S1591C24v140Ev
  virtual void  v141(); // _ZN7S1591C24v141Ev
  virtual void  v142(); // _ZN7S1591C24v142Ev
  virtual void  v143(); // _ZN7S1591C24v143Ev
  virtual void  v144(); // _ZN7S1591C24v144Ev
  virtual void  v145(); // _ZN7S1591C24v145Ev
  virtual void  v146(); // _ZN7S1591C24v146Ev
  virtual void  v147(); // _ZN7S1591C24v147Ev
  virtual void  v148(); // _ZN7S1591C24v148Ev
  S1591C2(); // tgen
};
//SIG(-1 S1591C2) C1{ BC2{ BC3{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107} BC6{ v108 v109 v110 v111 v112 v113 v114 v115 v116} vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1591C2 ::~S1591C2(){ note_dtor("S1591C2", this);}
void  S1591C2 ::v122(){vfunc_called(this, "_ZN7S1591C24v122Ev");}
void  S1591C2 ::v123(){vfunc_called(this, "_ZN7S1591C24v123Ev");}
void  S1591C2 ::v124(){vfunc_called(this, "_ZN7S1591C24v124Ev");}
void  S1591C2 ::v125(){vfunc_called(this, "_ZN7S1591C24v125Ev");}
void  S1591C2 ::v126(){vfunc_called(this, "_ZN7S1591C24v126Ev");}
void  S1591C2 ::v127(){vfunc_called(this, "_ZN7S1591C24v127Ev");}
void  S1591C2 ::v128(){vfunc_called(this, "_ZN7S1591C24v128Ev");}
void  S1591C2 ::v129(){vfunc_called(this, "_ZN7S1591C24v129Ev");}
void  S1591C2 ::v130(){vfunc_called(this, "_ZN7S1591C24v130Ev");}
void  S1591C2 ::v131(){vfunc_called(this, "_ZN7S1591C24v131Ev");}
void  S1591C2 ::v132(){vfunc_called(this, "_ZN7S1591C24v132Ev");}
void  S1591C2 ::v133(){vfunc_called(this, "_ZN7S1591C24v133Ev");}
void  S1591C2 ::v134(){vfunc_called(this, "_ZN7S1591C24v134Ev");}
void  S1591C2 ::v135(){vfunc_called(this, "_ZN7S1591C24v135Ev");}
void  S1591C2 ::v136(){vfunc_called(this, "_ZN7S1591C24v136Ev");}
void  S1591C2 ::v137(){vfunc_called(this, "_ZN7S1591C24v137Ev");}
void  S1591C2 ::v138(){vfunc_called(this, "_ZN7S1591C24v138Ev");}
void  S1591C2 ::v139(){vfunc_called(this, "_ZN7S1591C24v139Ev");}
void  S1591C2 ::v140(){vfunc_called(this, "_ZN7S1591C24v140Ev");}
void  S1591C2 ::v141(){vfunc_called(this, "_ZN7S1591C24v141Ev");}
void  S1591C2 ::v142(){vfunc_called(this, "_ZN7S1591C24v142Ev");}
void  S1591C2 ::v143(){vfunc_called(this, "_ZN7S1591C24v143Ev");}
void  S1591C2 ::v144(){vfunc_called(this, "_ZN7S1591C24v144Ev");}
void  S1591C2 ::v145(){vfunc_called(this, "_ZN7S1591C24v145Ev");}
void  S1591C2 ::v146(){vfunc_called(this, "_ZN7S1591C24v146Ev");}
void  S1591C2 ::v147(){vfunc_called(this, "_ZN7S1591C24v147Ev");}
void  S1591C2 ::v148(){vfunc_called(this, "_ZN7S1591C24v148Ev");}
S1591C2 ::S1591C2(){ note_ctor("S1591C2", this);} // tgen

static void Test_S1591C2()
{
  extern Class_Descriptor cd_S1591C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1591C2, buf);
    S1591C2 *dp, &lv = *(dp=new (buf) S1591C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1591C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C2)");
    check_base_class_offset(lv, (S1591C4*)(S1591C3*), 0, "S1591C2");
    check_base_class_offset(lv, (S1591C6*)(S1591C3*), ABISELECT(96,60), "S1591C2");
    check_base_class_offset(lv, (S1591C7*)(S1591C3*), ABISELECT(104,64), "S1591C2");
    check_base_class_offset(lv, (S1591C3*), 0, "S1591C2");
    check_field_offset(lv, s1591c2f0, ABISELECT(144,88), "S1591C2.s1591c2f0");
    check_field_offset(lv, s1591c2f1, ABISELECT(168,104), "S1591C2.s1591c2f1");
    test_class_info(&lv, &cd_S1591C2);
    dp->~S1591C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C2(Test_S1591C2, "S1591C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1591C2C1Ev();
extern void _ZN7S1591C2D1Ev();
Name_Map name_map_S1591C2[] = {
  NSPAIR(_ZN7S1591C2C1Ev),
  NSPAIR(_ZN7S1591C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1591C4;
extern VTBL_ENTRY _ZTI7S1591C4[];
extern  VTBL_ENTRY _ZTV7S1591C4[];
extern Class_Descriptor cd_S1591C6;
extern VTBL_ENTRY _ZTI7S1591C6[];
extern  VTBL_ENTRY _ZTV7S1591C6[];
extern Class_Descriptor cd_S1591C7;
extern VTBL_ENTRY _ZTI7S1591C7[];
extern  VTBL_ENTRY _ZTV7S1591C7[];
extern Class_Descriptor cd_S1591C3;
extern VTBL_ENTRY _ZTI7S1591C3[];
extern  VTBL_ENTRY _ZTV7S1591C3[];
static Base_Class bases_S1591C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1591C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C6,    ABISELECT(96,60), //bcp->offset
    119, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C7,    ABISELECT(104,64), //bcp->offset
    137, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1591C2[];
extern void _ZN7S1591C2D1Ev();
extern void _ZN7S1591C2D0Ev();
extern void _ZN7S1591C42v9Ev();
extern void _ZN7S1591C43v10Ev();
extern void _ZN7S1591C43v11Ev();
extern void _ZN7S1591C43v12Ev();
extern void _ZN7S1591C43v13Ev();
extern void _ZN7S1591C43v14Ev();
extern void _ZN7S1591C43v15Ev();
extern void _ZN7S1591C43v16Ev();
extern void _ZN7S1591C43v17Ev();
extern void _ZN7S1591C43v18Ev();
extern void _ZN7S1591C43v19Ev();
extern void _ZN7S1591C43v20Ev();
extern void _ZN7S1591C43v21Ev();
extern void _ZN7S1591C43v22Ev();
extern void _ZN7S1591C43v23Ev();
extern void _ZN7S1591C43v24Ev();
extern void _ZN7S1591C43v25Ev();
extern void _ZN7S1591C43v26Ev();
extern void _ZN7S1591C43v27Ev();
extern void _ZN7S1591C43v28Ev();
extern void _ZN7S1591C43v29Ev();
extern void _ZN7S1591C43v30Ev();
extern void _ZN7S1591C43v31Ev();
extern void _ZN7S1591C43v32Ev();
extern void _ZN7S1591C43v33Ev();
extern void _ZN7S1591C43v34Ev();
extern void _ZN7S1591C43v35Ev();
extern void _ZN7S1591C43v36Ev();
extern void _ZN7S1591C43v37Ev();
extern void _ZN7S1591C43v38Ev();
extern void _ZN7S1591C43v39Ev();
extern void _ZN7S1591C43v40Ev();
extern void _ZN7S1591C43v41Ev();
extern void _ZN7S1591C43v42Ev();
extern void _ZN7S1591C43v43Ev();
extern void _ZN7S1591C43v44Ev();
extern void _ZN7S1591C43v45Ev();
extern void _ZN7S1591C43v46Ev();
extern void _ZN7S1591C43v47Ev();
extern void _ZN7S1591C43v48Ev();
extern void _ZN7S1591C43v49Ev();
extern void _ZN7S1591C43v50Ev();
extern void _ZN7S1591C43v51Ev();
extern void _ZN7S1591C43v52Ev();
extern void _ZN7S1591C43v53Ev();
extern void _ZN7S1591C43v54Ev();
extern void _ZN7S1591C43v55Ev();
extern void _ZN7S1591C43v56Ev();
extern void _ZN7S1591C43v57Ev();
extern void _ZN7S1591C43v58Ev();
extern void _ZN7S1591C43v59Ev();
extern void _ZN7S1591C43v60Ev();
extern void _ZN7S1591C43v61Ev();
extern void _ZN7S1591C43v62Ev();
extern void _ZN7S1591C43v63Ev();
extern void _ZN7S1591C43v64Ev();
extern void _ZN7S1591C43v65Ev();
extern void _ZN7S1591C43v66Ev();
extern void _ZN7S1591C43v67Ev();
extern void _ZN7S1591C43v68Ev();
extern void _ZN7S1591C43v69Ev();
extern void _ZN7S1591C43v70Ev();
extern void _ZN7S1591C43v71Ev();
extern void _ZN7S1591C43v72Ev();
extern void _ZN7S1591C33v98Ev();
extern void _ZN7S1591C33v99Ev();
extern void _ZN7S1591C34v100Ev();
extern void _ZN7S1591C34v101Ev();
extern void _ZN7S1591C34v102Ev();
extern void _ZN7S1591C34v103Ev();
extern void _ZN7S1591C34v104Ev();
extern void _ZN7S1591C34v105Ev();
extern void _ZN7S1591C34v106Ev();
extern void _ZN7S1591C34v107Ev();
extern void _ZN7S1591C34v108Ev();
extern void _ZN7S1591C34v109Ev();
extern void _ZN7S1591C34v110Ev();
extern void _ZN7S1591C34v111Ev();
extern void _ZN7S1591C34v112Ev();
extern void _ZN7S1591C34v113Ev();
extern void _ZN7S1591C34v114Ev();
extern void _ZN7S1591C34v115Ev();
extern void _ZN7S1591C34v116Ev();
extern void _ZN7S1591C34v117Ev();
extern void _ZN7S1591C34v118Ev();
extern void _ZN7S1591C34v119Ev();
extern void _ZN7S1591C34v120Ev();
extern void _ZN7S1591C34v121Ev();
extern void _ZN7S1591C24v122Ev();
extern void _ZN7S1591C24v123Ev();
extern void _ZN7S1591C24v124Ev();
extern void _ZN7S1591C24v125Ev();
extern void _ZN7S1591C24v126Ev();
extern void _ZN7S1591C24v127Ev();
extern void _ZN7S1591C24v128Ev();
extern void _ZN7S1591C24v129Ev();
extern void _ZN7S1591C24v130Ev();
extern void _ZN7S1591C24v131Ev();
extern void _ZN7S1591C24v132Ev();
extern void _ZN7S1591C24v133Ev();
extern void _ZN7S1591C24v134Ev();
extern void _ZN7S1591C24v135Ev();
extern void _ZN7S1591C24v136Ev();
extern void _ZN7S1591C24v137Ev();
extern void _ZN7S1591C24v138Ev();
extern void _ZN7S1591C24v139Ev();
extern void _ZN7S1591C24v140Ev();
extern void _ZN7S1591C24v141Ev();
extern void _ZN7S1591C24v142Ev();
extern void _ZN7S1591C24v143Ev();
extern void _ZN7S1591C24v144Ev();
extern void _ZN7S1591C24v145Ev();
extern void _ZN7S1591C24v146Ev();
extern void _ZN7S1591C24v147Ev();
extern void _ZN7S1591C24v148Ev();
extern void _ZN7S1591C63v73Ev();
extern void _ZN7S1591C63v74Ev();
extern void _ZN7S1591C63v75Ev();
extern void _ZN7S1591C63v76Ev();
extern void _ZN7S1591C63v77Ev();
extern void _ZN7S1591C63v78Ev();
extern void _ZN7S1591C63v79Ev();
extern void _ZN7S1591C63v80Ev();
extern void _ZN7S1591C63v81Ev();
extern void _ZN7S1591C63v82Ev();
extern void _ZN7S1591C63v83Ev();
extern void _ZN7S1591C63v84Ev();
extern void _ZN7S1591C63v85Ev();
extern void _ZN7S1591C63v86Ev();
extern void _ZN7S1591C63v87Ev();
extern void _ZN7S1591C63v88Ev();
extern void _ZN7S1591C73v89Ev();
extern void _ZN7S1591C73v90Ev();
extern void _ZN7S1591C73v91Ev();
extern void _ZN7S1591C73v92Ev();
extern void _ZN7S1591C73v93Ev();
extern void _ZN7S1591C73v94Ev();
extern void _ZN7S1591C73v95Ev();
extern void _ZN7S1591C73v96Ev();
extern void _ZN7S1591C73v97Ev();
static  VTBL_ENTRY vtc_S1591C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C2[0]),
  (VTBL_ENTRY)&_ZN7S1591C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1591C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1591C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v148Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1591C2[0]),
  (VTBL_ENTRY)&_ZN7S1591C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1591C2[0]),
  (VTBL_ENTRY)&_ZN7S1591C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1591C2[];
extern  VTBL_ENTRY _ZTV7S1591C2[];
Class_Descriptor cd_S1591C2 = {  "S1591C2", // class name
  bases_S1591C2, 4,
  &(vtc_S1591C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1591C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1591C2),148, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1591C1  : S1591C2 {
  virtual  ~S1591C1(); // _ZN7S1591C1D1Ev
  virtual void  v1(); // _ZN7S1591C12v1Ev
  virtual void  v2(); // _ZN7S1591C12v2Ev
  virtual void  v3(); // _ZN7S1591C12v3Ev
  virtual void  v4(); // _ZN7S1591C12v4Ev
  virtual void  v5(); // _ZN7S1591C12v5Ev
  virtual void  v6(); // _ZN7S1591C12v6Ev
  virtual void  v7(); // _ZN7S1591C12v7Ev
  virtual void  v8(); // _ZN7S1591C12v8Ev
  S1591C1(); // tgen
};
//SIG(1 S1591C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88} BC7{ v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S1591C1 ::~S1591C1(){ note_dtor("S1591C1", this);}
void  S1591C1 ::v1(){vfunc_called(this, "_ZN7S1591C12v1Ev");}
void  S1591C1 ::v2(){vfunc_called(this, "_ZN7S1591C12v2Ev");}
void  S1591C1 ::v3(){vfunc_called(this, "_ZN7S1591C12v3Ev");}
void  S1591C1 ::v4(){vfunc_called(this, "_ZN7S1591C12v4Ev");}
void  S1591C1 ::v5(){vfunc_called(this, "_ZN7S1591C12v5Ev");}
void  S1591C1 ::v6(){vfunc_called(this, "_ZN7S1591C12v6Ev");}
void  S1591C1 ::v7(){vfunc_called(this, "_ZN7S1591C12v7Ev");}
void  S1591C1 ::v8(){vfunc_called(this, "_ZN7S1591C12v8Ev");}
S1591C1 ::S1591C1(){ note_ctor("S1591C1", this);} // tgen

static void Test_S1591C1()
{
  extern Class_Descriptor cd_S1591C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1591C1, buf);
    S1591C1 *dp, &lv = *(dp=new (buf) S1591C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1591C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1591C1)");
    check_base_class_offset(lv, (S1591C4*)(S1591C3*)(S1591C2*), 0, "S1591C1");
    check_base_class_offset(lv, (S1591C6*)(S1591C3*)(S1591C2*), ABISELECT(96,60), "S1591C1");
    check_base_class_offset(lv, (S1591C7*)(S1591C3*)(S1591C2*), ABISELECT(104,64), "S1591C1");
    check_base_class_offset(lv, (S1591C3*)(S1591C2*), 0, "S1591C1");
    check_base_class_offset(lv, (S1591C2*), 0, "S1591C1");
    test_class_info(&lv, &cd_S1591C1);
    dp->~S1591C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1591C1(Test_S1591C1, "S1591C1", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1591C1C1Ev();
extern void _ZN7S1591C1D1Ev();
Name_Map name_map_S1591C1[] = {
  NSPAIR(_ZN7S1591C1C1Ev),
  NSPAIR(_ZN7S1591C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1591C4;
extern VTBL_ENTRY _ZTI7S1591C4[];
extern  VTBL_ENTRY _ZTV7S1591C4[];
extern Class_Descriptor cd_S1591C6;
extern VTBL_ENTRY _ZTI7S1591C6[];
extern  VTBL_ENTRY _ZTV7S1591C6[];
extern Class_Descriptor cd_S1591C7;
extern VTBL_ENTRY _ZTI7S1591C7[];
extern  VTBL_ENTRY _ZTV7S1591C7[];
extern Class_Descriptor cd_S1591C3;
extern VTBL_ENTRY _ZTI7S1591C3[];
extern  VTBL_ENTRY _ZTV7S1591C3[];
extern Class_Descriptor cd_S1591C2;
extern VTBL_ENTRY _ZTI7S1591C2[];
extern  VTBL_ENTRY _ZTV7S1591C2[];
static Base_Class bases_S1591C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1591C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C6,    ABISELECT(96,60), //bcp->offset
    127, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C7,    ABISELECT(104,64), //bcp->offset
    145, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1591C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1591C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1591C1[];
extern void _ZN7S1591C1D1Ev();
extern void _ZN7S1591C1D0Ev();
extern void _ZN7S1591C42v9Ev();
extern void _ZN7S1591C43v10Ev();
extern void _ZN7S1591C43v11Ev();
extern void _ZN7S1591C43v12Ev();
extern void _ZN7S1591C43v13Ev();
extern void _ZN7S1591C43v14Ev();
extern void _ZN7S1591C43v15Ev();
extern void _ZN7S1591C43v16Ev();
extern void _ZN7S1591C43v17Ev();
extern void _ZN7S1591C43v18Ev();
extern void _ZN7S1591C43v19Ev();
extern void _ZN7S1591C43v20Ev();
extern void _ZN7S1591C43v21Ev();
extern void _ZN7S1591C43v22Ev();
extern void _ZN7S1591C43v23Ev();
extern void _ZN7S1591C43v24Ev();
extern void _ZN7S1591C43v25Ev();
extern void _ZN7S1591C43v26Ev();
extern void _ZN7S1591C43v27Ev();
extern void _ZN7S1591C43v28Ev();
extern void _ZN7S1591C43v29Ev();
extern void _ZN7S1591C43v30Ev();
extern void _ZN7S1591C43v31Ev();
extern void _ZN7S1591C43v32Ev();
extern void _ZN7S1591C43v33Ev();
extern void _ZN7S1591C43v34Ev();
extern void _ZN7S1591C43v35Ev();
extern void _ZN7S1591C43v36Ev();
extern void _ZN7S1591C43v37Ev();
extern void _ZN7S1591C43v38Ev();
extern void _ZN7S1591C43v39Ev();
extern void _ZN7S1591C43v40Ev();
extern void _ZN7S1591C43v41Ev();
extern void _ZN7S1591C43v42Ev();
extern void _ZN7S1591C43v43Ev();
extern void _ZN7S1591C43v44Ev();
extern void _ZN7S1591C43v45Ev();
extern void _ZN7S1591C43v46Ev();
extern void _ZN7S1591C43v47Ev();
extern void _ZN7S1591C43v48Ev();
extern void _ZN7S1591C43v49Ev();
extern void _ZN7S1591C43v50Ev();
extern void _ZN7S1591C43v51Ev();
extern void _ZN7S1591C43v52Ev();
extern void _ZN7S1591C43v53Ev();
extern void _ZN7S1591C43v54Ev();
extern void _ZN7S1591C43v55Ev();
extern void _ZN7S1591C43v56Ev();
extern void _ZN7S1591C43v57Ev();
extern void _ZN7S1591C43v58Ev();
extern void _ZN7S1591C43v59Ev();
extern void _ZN7S1591C43v60Ev();
extern void _ZN7S1591C43v61Ev();
extern void _ZN7S1591C43v62Ev();
extern void _ZN7S1591C43v63Ev();
extern void _ZN7S1591C43v64Ev();
extern void _ZN7S1591C43v65Ev();
extern void _ZN7S1591C43v66Ev();
extern void _ZN7S1591C43v67Ev();
extern void _ZN7S1591C43v68Ev();
extern void _ZN7S1591C43v69Ev();
extern void _ZN7S1591C43v70Ev();
extern void _ZN7S1591C43v71Ev();
extern void _ZN7S1591C43v72Ev();
extern void _ZN7S1591C33v98Ev();
extern void _ZN7S1591C33v99Ev();
extern void _ZN7S1591C34v100Ev();
extern void _ZN7S1591C34v101Ev();
extern void _ZN7S1591C34v102Ev();
extern void _ZN7S1591C34v103Ev();
extern void _ZN7S1591C34v104Ev();
extern void _ZN7S1591C34v105Ev();
extern void _ZN7S1591C34v106Ev();
extern void _ZN7S1591C34v107Ev();
extern void _ZN7S1591C34v108Ev();
extern void _ZN7S1591C34v109Ev();
extern void _ZN7S1591C34v110Ev();
extern void _ZN7S1591C34v111Ev();
extern void _ZN7S1591C34v112Ev();
extern void _ZN7S1591C34v113Ev();
extern void _ZN7S1591C34v114Ev();
extern void _ZN7S1591C34v115Ev();
extern void _ZN7S1591C34v116Ev();
extern void _ZN7S1591C34v117Ev();
extern void _ZN7S1591C34v118Ev();
extern void _ZN7S1591C34v119Ev();
extern void _ZN7S1591C34v120Ev();
extern void _ZN7S1591C34v121Ev();
extern void _ZN7S1591C24v122Ev();
extern void _ZN7S1591C24v123Ev();
extern void _ZN7S1591C24v124Ev();
extern void _ZN7S1591C24v125Ev();
extern void _ZN7S1591C24v126Ev();
extern void _ZN7S1591C24v127Ev();
extern void _ZN7S1591C24v128Ev();
extern void _ZN7S1591C24v129Ev();
extern void _ZN7S1591C24v130Ev();
extern void _ZN7S1591C24v131Ev();
extern void _ZN7S1591C24v132Ev();
extern void _ZN7S1591C24v133Ev();
extern void _ZN7S1591C24v134Ev();
extern void _ZN7S1591C24v135Ev();
extern void _ZN7S1591C24v136Ev();
extern void _ZN7S1591C24v137Ev();
extern void _ZN7S1591C24v138Ev();
extern void _ZN7S1591C24v139Ev();
extern void _ZN7S1591C24v140Ev();
extern void _ZN7S1591C24v141Ev();
extern void _ZN7S1591C24v142Ev();
extern void _ZN7S1591C24v143Ev();
extern void _ZN7S1591C24v144Ev();
extern void _ZN7S1591C24v145Ev();
extern void _ZN7S1591C24v146Ev();
extern void _ZN7S1591C24v147Ev();
extern void _ZN7S1591C24v148Ev();
extern void _ZN7S1591C12v1Ev();
extern void _ZN7S1591C12v2Ev();
extern void _ZN7S1591C12v3Ev();
extern void _ZN7S1591C12v4Ev();
extern void _ZN7S1591C12v5Ev();
extern void _ZN7S1591C12v6Ev();
extern void _ZN7S1591C12v7Ev();
extern void _ZN7S1591C12v8Ev();
extern void _ZN7S1591C63v73Ev();
extern void _ZN7S1591C63v74Ev();
extern void _ZN7S1591C63v75Ev();
extern void _ZN7S1591C63v76Ev();
extern void _ZN7S1591C63v77Ev();
extern void _ZN7S1591C63v78Ev();
extern void _ZN7S1591C63v79Ev();
extern void _ZN7S1591C63v80Ev();
extern void _ZN7S1591C63v81Ev();
extern void _ZN7S1591C63v82Ev();
extern void _ZN7S1591C63v83Ev();
extern void _ZN7S1591C63v84Ev();
extern void _ZN7S1591C63v85Ev();
extern void _ZN7S1591C63v86Ev();
extern void _ZN7S1591C63v87Ev();
extern void _ZN7S1591C63v88Ev();
extern void _ZN7S1591C73v89Ev();
extern void _ZN7S1591C73v90Ev();
extern void _ZN7S1591C73v91Ev();
extern void _ZN7S1591C73v92Ev();
extern void _ZN7S1591C73v93Ev();
extern void _ZN7S1591C73v94Ev();
extern void _ZN7S1591C73v95Ev();
extern void _ZN7S1591C73v96Ev();
extern void _ZN7S1591C73v97Ev();
static  VTBL_ENTRY vtc_S1591C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1591C1[0]),
  (VTBL_ENTRY)&_ZN7S1591C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1591C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1591C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1591C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1591C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1591C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1591C24v148Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1591C12v8Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1591C1[0]),
  (VTBL_ENTRY)&_ZN7S1591C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1591C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1591C1[0]),
  (VTBL_ENTRY)&_ZN7S1591C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1591C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1591C1[];
extern  VTBL_ENTRY _ZTV7S1591C1[];
Class_Descriptor cd_S1591C1 = {  "S1591C1", // class name
  bases_S1591C1, 5,
  &(vtc_S1591C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1591C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1591C1),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C4  {
  int s1588c4f0;
  __tsi64 s1588c4f1;
  void *s1588c4f2[4];
  int s1588c4f3[2];
  void *s1588c4f4;
  ::S79C8_nt s1588c4f5;
  void *s1588c4f6[2];
  virtual  ~S1588C4(); // _ZN7S1588C4D1Ev
  virtual void  v9(); // _ZN7S1588C42v9Ev
  virtual void  v10(); // _ZN7S1588C43v10Ev
  virtual void  v11(); // _ZN7S1588C43v11Ev
  virtual void  v12(); // _ZN7S1588C43v12Ev
  virtual void  v13(); // _ZN7S1588C43v13Ev
  virtual void  v14(); // _ZN7S1588C43v14Ev
  virtual void  v15(); // _ZN7S1588C43v15Ev
  virtual void  v16(); // _ZN7S1588C43v16Ev
  virtual void  v17(); // _ZN7S1588C43v17Ev
  virtual void  v18(); // _ZN7S1588C43v18Ev
  virtual void  v19(); // _ZN7S1588C43v19Ev
  virtual void  v20(); // _ZN7S1588C43v20Ev
  virtual void  v21(); // _ZN7S1588C43v21Ev
  virtual void  v22(); // _ZN7S1588C43v22Ev
  virtual void  v23(); // _ZN7S1588C43v23Ev
  virtual void  v24(); // _ZN7S1588C43v24Ev
  virtual void  v25(); // _ZN7S1588C43v25Ev
  virtual void  v26(); // _ZN7S1588C43v26Ev
  virtual void  v27(); // _ZN7S1588C43v27Ev
  virtual void  v28(); // _ZN7S1588C43v28Ev
  virtual void  v29(); // _ZN7S1588C43v29Ev
  virtual void  v30(); // _ZN7S1588C43v30Ev
  virtual void  v31(); // _ZN7S1588C43v31Ev
  virtual void  v32(); // _ZN7S1588C43v32Ev
  virtual void  v33(); // _ZN7S1588C43v33Ev
  virtual void  v34(); // _ZN7S1588C43v34Ev
  virtual void  v35(); // _ZN7S1588C43v35Ev
  virtual void  v36(); // _ZN7S1588C43v36Ev
  virtual void  v37(); // _ZN7S1588C43v37Ev
  virtual void  v38(); // _ZN7S1588C43v38Ev
  virtual void  v39(); // _ZN7S1588C43v39Ev
  virtual void  v40(); // _ZN7S1588C43v40Ev
  virtual void  v41(); // _ZN7S1588C43v41Ev
  virtual void  v42(); // _ZN7S1588C43v42Ev
  virtual void  v43(); // _ZN7S1588C43v43Ev
  virtual void  v44(); // _ZN7S1588C43v44Ev
  virtual void  v45(); // _ZN7S1588C43v45Ev
  virtual void  v46(); // _ZN7S1588C43v46Ev
  virtual void  v47(); // _ZN7S1588C43v47Ev
  virtual void  v48(); // _ZN7S1588C43v48Ev
  virtual void  v49(); // _ZN7S1588C43v49Ev
  virtual void  v50(); // _ZN7S1588C43v50Ev
  virtual void  v51(); // _ZN7S1588C43v51Ev
  virtual void  v52(); // _ZN7S1588C43v52Ev
  virtual void  v53(); // _ZN7S1588C43v53Ev
  virtual void  v54(); // _ZN7S1588C43v54Ev
  virtual void  v55(); // _ZN7S1588C43v55Ev
  virtual void  v56(); // _ZN7S1588C43v56Ev
  virtual void  v57(); // _ZN7S1588C43v57Ev
  virtual void  v58(); // _ZN7S1588C43v58Ev
  virtual void  v59(); // _ZN7S1588C43v59Ev
  virtual void  v60(); // _ZN7S1588C43v60Ev
  virtual void  v61(); // _ZN7S1588C43v61Ev
  virtual void  v62(); // _ZN7S1588C43v62Ev
  virtual void  v63(); // _ZN7S1588C43v63Ev
  virtual void  v64(); // _ZN7S1588C43v64Ev
  virtual void  v65(); // _ZN7S1588C43v65Ev
  virtual void  v66(); // _ZN7S1588C43v66Ev
  virtual void  v67(); // _ZN7S1588C43v67Ev
  virtual void  v68(); // _ZN7S1588C43v68Ev
  virtual void  v69(); // _ZN7S1588C43v69Ev
  virtual void  v70(); // _ZN7S1588C43v70Ev
  virtual void  v71(); // _ZN7S1588C43v71Ev
  virtual void  v72(); // _ZN7S1588C43v72Ev
  S1588C4(); // tgen
};
//SIG(-1 S1588C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1588C4 ::~S1588C4(){ note_dtor("S1588C4", this);}
void  S1588C4 ::v9(){vfunc_called(this, "_ZN7S1588C42v9Ev");}
void  S1588C4 ::v10(){vfunc_called(this, "_ZN7S1588C43v10Ev");}
void  S1588C4 ::v11(){vfunc_called(this, "_ZN7S1588C43v11Ev");}
void  S1588C4 ::v12(){vfunc_called(this, "_ZN7S1588C43v12Ev");}
void  S1588C4 ::v13(){vfunc_called(this, "_ZN7S1588C43v13Ev");}
void  S1588C4 ::v14(){vfunc_called(this, "_ZN7S1588C43v14Ev");}
void  S1588C4 ::v15(){vfunc_called(this, "_ZN7S1588C43v15Ev");}
void  S1588C4 ::v16(){vfunc_called(this, "_ZN7S1588C43v16Ev");}
void  S1588C4 ::v17(){vfunc_called(this, "_ZN7S1588C43v17Ev");}
void  S1588C4 ::v18(){vfunc_called(this, "_ZN7S1588C43v18Ev");}
void  S1588C4 ::v19(){vfunc_called(this, "_ZN7S1588C43v19Ev");}
void  S1588C4 ::v20(){vfunc_called(this, "_ZN7S1588C43v20Ev");}
void  S1588C4 ::v21(){vfunc_called(this, "_ZN7S1588C43v21Ev");}
void  S1588C4 ::v22(){vfunc_called(this, "_ZN7S1588C43v22Ev");}
void  S1588C4 ::v23(){vfunc_called(this, "_ZN7S1588C43v23Ev");}
void  S1588C4 ::v24(){vfunc_called(this, "_ZN7S1588C43v24Ev");}
void  S1588C4 ::v25(){vfunc_called(this, "_ZN7S1588C43v25Ev");}
void  S1588C4 ::v26(){vfunc_called(this, "_ZN7S1588C43v26Ev");}
void  S1588C4 ::v27(){vfunc_called(this, "_ZN7S1588C43v27Ev");}
void  S1588C4 ::v28(){vfunc_called(this, "_ZN7S1588C43v28Ev");}
void  S1588C4 ::v29(){vfunc_called(this, "_ZN7S1588C43v29Ev");}
void  S1588C4 ::v30(){vfunc_called(this, "_ZN7S1588C43v30Ev");}
void  S1588C4 ::v31(){vfunc_called(this, "_ZN7S1588C43v31Ev");}
void  S1588C4 ::v32(){vfunc_called(this, "_ZN7S1588C43v32Ev");}
void  S1588C4 ::v33(){vfunc_called(this, "_ZN7S1588C43v33Ev");}
void  S1588C4 ::v34(){vfunc_called(this, "_ZN7S1588C43v34Ev");}
void  S1588C4 ::v35(){vfunc_called(this, "_ZN7S1588C43v35Ev");}
void  S1588C4 ::v36(){vfunc_called(this, "_ZN7S1588C43v36Ev");}
void  S1588C4 ::v37(){vfunc_called(this, "_ZN7S1588C43v37Ev");}
void  S1588C4 ::v38(){vfunc_called(this, "_ZN7S1588C43v38Ev");}
void  S1588C4 ::v39(){vfunc_called(this, "_ZN7S1588C43v39Ev");}
void  S1588C4 ::v40(){vfunc_called(this, "_ZN7S1588C43v40Ev");}
void  S1588C4 ::v41(){vfunc_called(this, "_ZN7S1588C43v41Ev");}
void  S1588C4 ::v42(){vfunc_called(this, "_ZN7S1588C43v42Ev");}
void  S1588C4 ::v43(){vfunc_called(this, "_ZN7S1588C43v43Ev");}
void  S1588C4 ::v44(){vfunc_called(this, "_ZN7S1588C43v44Ev");}
void  S1588C4 ::v45(){vfunc_called(this, "_ZN7S1588C43v45Ev");}
void  S1588C4 ::v46(){vfunc_called(this, "_ZN7S1588C43v46Ev");}
void  S1588C4 ::v47(){vfunc_called(this, "_ZN7S1588C43v47Ev");}
void  S1588C4 ::v48(){vfunc_called(this, "_ZN7S1588C43v48Ev");}
void  S1588C4 ::v49(){vfunc_called(this, "_ZN7S1588C43v49Ev");}
void  S1588C4 ::v50(){vfunc_called(this, "_ZN7S1588C43v50Ev");}
void  S1588C4 ::v51(){vfunc_called(this, "_ZN7S1588C43v51Ev");}
void  S1588C4 ::v52(){vfunc_called(this, "_ZN7S1588C43v52Ev");}
void  S1588C4 ::v53(){vfunc_called(this, "_ZN7S1588C43v53Ev");}
void  S1588C4 ::v54(){vfunc_called(this, "_ZN7S1588C43v54Ev");}
void  S1588C4 ::v55(){vfunc_called(this, "_ZN7S1588C43v55Ev");}
void  S1588C4 ::v56(){vfunc_called(this, "_ZN7S1588C43v56Ev");}
void  S1588C4 ::v57(){vfunc_called(this, "_ZN7S1588C43v57Ev");}
void  S1588C4 ::v58(){vfunc_called(this, "_ZN7S1588C43v58Ev");}
void  S1588C4 ::v59(){vfunc_called(this, "_ZN7S1588C43v59Ev");}
void  S1588C4 ::v60(){vfunc_called(this, "_ZN7S1588C43v60Ev");}
void  S1588C4 ::v61(){vfunc_called(this, "_ZN7S1588C43v61Ev");}
void  S1588C4 ::v62(){vfunc_called(this, "_ZN7S1588C43v62Ev");}
void  S1588C4 ::v63(){vfunc_called(this, "_ZN7S1588C43v63Ev");}
void  S1588C4 ::v64(){vfunc_called(this, "_ZN7S1588C43v64Ev");}
void  S1588C4 ::v65(){vfunc_called(this, "_ZN7S1588C43v65Ev");}
void  S1588C4 ::v66(){vfunc_called(this, "_ZN7S1588C43v66Ev");}
void  S1588C4 ::v67(){vfunc_called(this, "_ZN7S1588C43v67Ev");}
void  S1588C4 ::v68(){vfunc_called(this, "_ZN7S1588C43v68Ev");}
void  S1588C4 ::v69(){vfunc_called(this, "_ZN7S1588C43v69Ev");}
void  S1588C4 ::v70(){vfunc_called(this, "_ZN7S1588C43v70Ev");}
void  S1588C4 ::v71(){vfunc_called(this, "_ZN7S1588C43v71Ev");}
void  S1588C4 ::v72(){vfunc_called(this, "_ZN7S1588C43v72Ev");}
S1588C4 ::S1588C4(){ note_ctor("S1588C4", this);} // tgen

static void Test_S1588C4()
{
  extern Class_Descriptor cd_S1588C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1588C4, buf);
    S1588C4 *dp, &lv = *(dp=new (buf) S1588C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1588C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C4)");
    check_field_offset(lv, s1588c4f0, ABISELECT(8,4), "S1588C4.s1588c4f0");
    check_field_offset(lv, s1588c4f1, ABISELECT(16,8), "S1588C4.s1588c4f1");
    check_field_offset(lv, s1588c4f2, ABISELECT(24,16), "S1588C4.s1588c4f2");
    check_field_offset(lv, s1588c4f3, ABISELECT(56,32), "S1588C4.s1588c4f3");
    check_field_offset(lv, s1588c4f4, ABISELECT(64,40), "S1588C4.s1588c4f4");
    check_field_offset(lv, s1588c4f5, ABISELECT(72,44), "S1588C4.s1588c4f5");
    check_field_offset(lv, s1588c4f6, ABISELECT(80,52), "S1588C4.s1588c4f6");
    test_class_info(&lv, &cd_S1588C4);
    dp->~S1588C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C4(Test_S1588C4, "S1588C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1588C4C1Ev();
extern void _ZN7S1588C4D1Ev();
Name_Map name_map_S1588C4[] = {
  NSPAIR(_ZN7S1588C4C1Ev),
  NSPAIR(_ZN7S1588C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1588C4[];
extern void _ZN7S1588C4D1Ev();
extern void _ZN7S1588C4D0Ev();
extern void _ZN7S1588C42v9Ev();
extern void _ZN7S1588C43v10Ev();
extern void _ZN7S1588C43v11Ev();
extern void _ZN7S1588C43v12Ev();
extern void _ZN7S1588C43v13Ev();
extern void _ZN7S1588C43v14Ev();
extern void _ZN7S1588C43v15Ev();
extern void _ZN7S1588C43v16Ev();
extern void _ZN7S1588C43v17Ev();
extern void _ZN7S1588C43v18Ev();
extern void _ZN7S1588C43v19Ev();
extern void _ZN7S1588C43v20Ev();
extern void _ZN7S1588C43v21Ev();
extern void _ZN7S1588C43v22Ev();
extern void _ZN7S1588C43v23Ev();
extern void _ZN7S1588C43v24Ev();
extern void _ZN7S1588C43v25Ev();
extern void _ZN7S1588C43v26Ev();
extern void _ZN7S1588C43v27Ev();
extern void _ZN7S1588C43v28Ev();
extern void _ZN7S1588C43v29Ev();
extern void _ZN7S1588C43v30Ev();
extern void _ZN7S1588C43v31Ev();
extern void _ZN7S1588C43v32Ev();
extern void _ZN7S1588C43v33Ev();
extern void _ZN7S1588C43v34Ev();
extern void _ZN7S1588C43v35Ev();
extern void _ZN7S1588C43v36Ev();
extern void _ZN7S1588C43v37Ev();
extern void _ZN7S1588C43v38Ev();
extern void _ZN7S1588C43v39Ev();
extern void _ZN7S1588C43v40Ev();
extern void _ZN7S1588C43v41Ev();
extern void _ZN7S1588C43v42Ev();
extern void _ZN7S1588C43v43Ev();
extern void _ZN7S1588C43v44Ev();
extern void _ZN7S1588C43v45Ev();
extern void _ZN7S1588C43v46Ev();
extern void _ZN7S1588C43v47Ev();
extern void _ZN7S1588C43v48Ev();
extern void _ZN7S1588C43v49Ev();
extern void _ZN7S1588C43v50Ev();
extern void _ZN7S1588C43v51Ev();
extern void _ZN7S1588C43v52Ev();
extern void _ZN7S1588C43v53Ev();
extern void _ZN7S1588C43v54Ev();
extern void _ZN7S1588C43v55Ev();
extern void _ZN7S1588C43v56Ev();
extern void _ZN7S1588C43v57Ev();
extern void _ZN7S1588C43v58Ev();
extern void _ZN7S1588C43v59Ev();
extern void _ZN7S1588C43v60Ev();
extern void _ZN7S1588C43v61Ev();
extern void _ZN7S1588C43v62Ev();
extern void _ZN7S1588C43v63Ev();
extern void _ZN7S1588C43v64Ev();
extern void _ZN7S1588C43v65Ev();
extern void _ZN7S1588C43v66Ev();
extern void _ZN7S1588C43v67Ev();
extern void _ZN7S1588C43v68Ev();
extern void _ZN7S1588C43v69Ev();
extern void _ZN7S1588C43v70Ev();
extern void _ZN7S1588C43v71Ev();
extern void _ZN7S1588C43v72Ev();
static  VTBL_ENTRY vtc_S1588C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C4[0]),
  (VTBL_ENTRY)&_ZN7S1588C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1588C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1588C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1588C4[];
extern  VTBL_ENTRY _ZTV7S1588C4[];
Class_Descriptor cd_S1588C4 = {  "S1588C4", // class name
  0,0,//no base classes
  &(vtc_S1588C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1588C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1588C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C6  {
  virtual void  v73(); // _ZN7S1588C63v73Ev
  virtual void  v74(); // _ZN7S1588C63v74Ev
  virtual void  v75(); // _ZN7S1588C63v75Ev
  virtual void  v76(); // _ZN7S1588C63v76Ev
  virtual void  v77(); // _ZN7S1588C63v77Ev
  virtual void  v78(); // _ZN7S1588C63v78Ev
  virtual void  v79(); // _ZN7S1588C63v79Ev
  virtual void  v80(); // _ZN7S1588C63v80Ev
  virtual void  v81(); // _ZN7S1588C63v81Ev
  virtual void  v82(); // _ZN7S1588C63v82Ev
  virtual void  v83(); // _ZN7S1588C63v83Ev
  virtual void  v84(); // _ZN7S1588C63v84Ev
  virtual void  v85(); // _ZN7S1588C63v85Ev
  virtual void  v86(); // _ZN7S1588C63v86Ev
  virtual void  v87(); // _ZN7S1588C63v87Ev
  virtual void  v88(); // _ZN7S1588C63v88Ev
  ~S1588C6(); // tgen
  S1588C6(); // tgen
};
//SIG(-1 S1588C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1588C6 ::v73(){vfunc_called(this, "_ZN7S1588C63v73Ev");}
void  S1588C6 ::v74(){vfunc_called(this, "_ZN7S1588C63v74Ev");}
void  S1588C6 ::v75(){vfunc_called(this, "_ZN7S1588C63v75Ev");}
void  S1588C6 ::v76(){vfunc_called(this, "_ZN7S1588C63v76Ev");}
void  S1588C6 ::v77(){vfunc_called(this, "_ZN7S1588C63v77Ev");}
void  S1588C6 ::v78(){vfunc_called(this, "_ZN7S1588C63v78Ev");}
void  S1588C6 ::v79(){vfunc_called(this, "_ZN7S1588C63v79Ev");}
void  S1588C6 ::v80(){vfunc_called(this, "_ZN7S1588C63v80Ev");}
void  S1588C6 ::v81(){vfunc_called(this, "_ZN7S1588C63v81Ev");}
void  S1588C6 ::v82(){vfunc_called(this, "_ZN7S1588C63v82Ev");}
void  S1588C6 ::v83(){vfunc_called(this, "_ZN7S1588C63v83Ev");}
void  S1588C6 ::v84(){vfunc_called(this, "_ZN7S1588C63v84Ev");}
void  S1588C6 ::v85(){vfunc_called(this, "_ZN7S1588C63v85Ev");}
void  S1588C6 ::v86(){vfunc_called(this, "_ZN7S1588C63v86Ev");}
void  S1588C6 ::v87(){vfunc_called(this, "_ZN7S1588C63v87Ev");}
void  S1588C6 ::v88(){vfunc_called(this, "_ZN7S1588C63v88Ev");}
S1588C6 ::~S1588C6(){ note_dtor("S1588C6", this);} // tgen
S1588C6 ::S1588C6(){ note_ctor("S1588C6", this);} // tgen

static void Test_S1588C6()
{
  extern Class_Descriptor cd_S1588C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1588C6, buf);
    S1588C6 *dp, &lv = *(dp=new (buf) S1588C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1588C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C6)");
    test_class_info(&lv, &cd_S1588C6);
    dp->~S1588C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C6(Test_S1588C6, "S1588C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1588C6C1Ev();
extern void _ZN7S1588C6D1Ev();
Name_Map name_map_S1588C6[] = {
  NSPAIR(_ZN7S1588C6C1Ev),
  NSPAIR(_ZN7S1588C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1588C6[];
extern void _ZN7S1588C63v73Ev();
extern void _ZN7S1588C63v74Ev();
extern void _ZN7S1588C63v75Ev();
extern void _ZN7S1588C63v76Ev();
extern void _ZN7S1588C63v77Ev();
extern void _ZN7S1588C63v78Ev();
extern void _ZN7S1588C63v79Ev();
extern void _ZN7S1588C63v80Ev();
extern void _ZN7S1588C63v81Ev();
extern void _ZN7S1588C63v82Ev();
extern void _ZN7S1588C63v83Ev();
extern void _ZN7S1588C63v84Ev();
extern void _ZN7S1588C63v85Ev();
extern void _ZN7S1588C63v86Ev();
extern void _ZN7S1588C63v87Ev();
extern void _ZN7S1588C63v88Ev();
static  VTBL_ENTRY vtc_S1588C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C6[0]),
  (VTBL_ENTRY)&_ZN7S1588C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v88Ev,
};
extern VTBL_ENTRY _ZTI7S1588C6[];
extern  VTBL_ENTRY _ZTV7S1588C6[];
Class_Descriptor cd_S1588C6 = {  "S1588C6", // class name
  0,0,//no base classes
  &(vtc_S1588C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1588C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1588C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C7  {
  virtual void  v89(); // _ZN7S1588C73v89Ev
  virtual void  v90(); // _ZN7S1588C73v90Ev
  virtual void  v91(); // _ZN7S1588C73v91Ev
  virtual void  v92(); // _ZN7S1588C73v92Ev
  virtual void  v93(); // _ZN7S1588C73v93Ev
  virtual void  v94(); // _ZN7S1588C73v94Ev
  virtual void  v95(); // _ZN7S1588C73v95Ev
  virtual void  v96(); // _ZN7S1588C73v96Ev
  virtual void  v97(); // _ZN7S1588C73v97Ev
  ~S1588C7(); // tgen
  S1588C7(); // tgen
};
//SIG(-1 S1588C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1588C7 ::v89(){vfunc_called(this, "_ZN7S1588C73v89Ev");}
void  S1588C7 ::v90(){vfunc_called(this, "_ZN7S1588C73v90Ev");}
void  S1588C7 ::v91(){vfunc_called(this, "_ZN7S1588C73v91Ev");}
void  S1588C7 ::v92(){vfunc_called(this, "_ZN7S1588C73v92Ev");}
void  S1588C7 ::v93(){vfunc_called(this, "_ZN7S1588C73v93Ev");}
void  S1588C7 ::v94(){vfunc_called(this, "_ZN7S1588C73v94Ev");}
void  S1588C7 ::v95(){vfunc_called(this, "_ZN7S1588C73v95Ev");}
void  S1588C7 ::v96(){vfunc_called(this, "_ZN7S1588C73v96Ev");}
void  S1588C7 ::v97(){vfunc_called(this, "_ZN7S1588C73v97Ev");}
S1588C7 ::~S1588C7(){ note_dtor("S1588C7", this);} // tgen
S1588C7 ::S1588C7(){ note_ctor("S1588C7", this);} // tgen

static void Test_S1588C7()
{
  extern Class_Descriptor cd_S1588C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1588C7, buf);
    S1588C7 *dp, &lv = *(dp=new (buf) S1588C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1588C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C7)");
    test_class_info(&lv, &cd_S1588C7);
    dp->~S1588C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C7(Test_S1588C7, "S1588C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1588C7C1Ev();
extern void _ZN7S1588C7D1Ev();
Name_Map name_map_S1588C7[] = {
  NSPAIR(_ZN7S1588C7C1Ev),
  NSPAIR(_ZN7S1588C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1588C7[];
extern void _ZN7S1588C73v89Ev();
extern void _ZN7S1588C73v90Ev();
extern void _ZN7S1588C73v91Ev();
extern void _ZN7S1588C73v92Ev();
extern void _ZN7S1588C73v93Ev();
extern void _ZN7S1588C73v94Ev();
extern void _ZN7S1588C73v95Ev();
extern void _ZN7S1588C73v96Ev();
extern void _ZN7S1588C73v97Ev();
static  VTBL_ENTRY vtc_S1588C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C7[0]),
  (VTBL_ENTRY)&_ZN7S1588C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1588C7[];
extern  VTBL_ENTRY _ZTV7S1588C7[];
Class_Descriptor cd_S1588C7 = {  "S1588C7", // class name
  0,0,//no base classes
  &(vtc_S1588C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1588C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1588C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C3  : S1588C4 , S1588C6 , S1588C7 {
  void *s1588c3f0;
  ::S79C39_nt s1588c3f1;
  unsigned int s1588c3f2:1;
  unsigned int s1588c3f3:1;
  unsigned int s1588c3f4:1;
  unsigned int s1588c3f5:1;
  virtual  ~S1588C3(); // _ZN7S1588C3D1Ev
  virtual void  v98(); // _ZN7S1588C33v98Ev
  virtual void  v99(); // _ZN7S1588C33v99Ev
  virtual void  v100(); // _ZN7S1588C34v100Ev
  virtual void  v101(); // _ZN7S1588C34v101Ev
  virtual void  v102(); // _ZN7S1588C34v102Ev
  virtual void  v103(); // _ZN7S1588C34v103Ev
  virtual void  v104(); // _ZN7S1588C34v104Ev
  virtual void  v105(); // _ZN7S1588C34v105Ev
  virtual void  v106(); // _ZN7S1588C34v106Ev
  virtual void  v107(); // _ZN7S1588C34v107Ev
  virtual void  v108(); // _ZN7S1588C34v108Ev
  virtual void  v109(); // _ZN7S1588C34v109Ev
  virtual void  v110(); // _ZN7S1588C34v110Ev
  virtual void  v111(); // _ZN7S1588C34v111Ev
  virtual void  v112(); // _ZN7S1588C34v112Ev
  virtual void  v113(); // _ZN7S1588C34v113Ev
  virtual void  v114(); // _ZN7S1588C34v114Ev
  virtual void  v115(); // _ZN7S1588C34v115Ev
  virtual void  v116(); // _ZN7S1588C34v116Ev
  virtual void  v117(); // _ZN7S1588C34v117Ev
  virtual void  v118(); // _ZN7S1588C34v118Ev
  virtual void  v119(); // _ZN7S1588C34v119Ev
  virtual void  v120(); // _ZN7S1588C34v120Ev
  virtual void  v121(); // _ZN7S1588C34v121Ev
  S1588C3(); // tgen
};
//SIG(-1 S1588C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1588C3 ::~S1588C3(){ note_dtor("S1588C3", this);}
void  S1588C3 ::v98(){vfunc_called(this, "_ZN7S1588C33v98Ev");}
void  S1588C3 ::v99(){vfunc_called(this, "_ZN7S1588C33v99Ev");}
void  S1588C3 ::v100(){vfunc_called(this, "_ZN7S1588C34v100Ev");}
void  S1588C3 ::v101(){vfunc_called(this, "_ZN7S1588C34v101Ev");}
void  S1588C3 ::v102(){vfunc_called(this, "_ZN7S1588C34v102Ev");}
void  S1588C3 ::v103(){vfunc_called(this, "_ZN7S1588C34v103Ev");}
void  S1588C3 ::v104(){vfunc_called(this, "_ZN7S1588C34v104Ev");}
void  S1588C3 ::v105(){vfunc_called(this, "_ZN7S1588C34v105Ev");}
void  S1588C3 ::v106(){vfunc_called(this, "_ZN7S1588C34v106Ev");}
void  S1588C3 ::v107(){vfunc_called(this, "_ZN7S1588C34v107Ev");}
void  S1588C3 ::v108(){vfunc_called(this, "_ZN7S1588C34v108Ev");}
void  S1588C3 ::v109(){vfunc_called(this, "_ZN7S1588C34v109Ev");}
void  S1588C3 ::v110(){vfunc_called(this, "_ZN7S1588C34v110Ev");}
void  S1588C3 ::v111(){vfunc_called(this, "_ZN7S1588C34v111Ev");}
void  S1588C3 ::v112(){vfunc_called(this, "_ZN7S1588C34v112Ev");}
void  S1588C3 ::v113(){vfunc_called(this, "_ZN7S1588C34v113Ev");}
void  S1588C3 ::v114(){vfunc_called(this, "_ZN7S1588C34v114Ev");}
void  S1588C3 ::v115(){vfunc_called(this, "_ZN7S1588C34v115Ev");}
void  S1588C3 ::v116(){vfunc_called(this, "_ZN7S1588C34v116Ev");}
void  S1588C3 ::v117(){vfunc_called(this, "_ZN7S1588C34v117Ev");}
void  S1588C3 ::v118(){vfunc_called(this, "_ZN7S1588C34v118Ev");}
void  S1588C3 ::v119(){vfunc_called(this, "_ZN7S1588C34v119Ev");}
void  S1588C3 ::v120(){vfunc_called(this, "_ZN7S1588C34v120Ev");}
void  S1588C3 ::v121(){vfunc_called(this, "_ZN7S1588C34v121Ev");}
S1588C3 ::S1588C3(){ note_ctor("S1588C3", this);} // tgen

static void Test_S1588C3()
{
  extern Class_Descriptor cd_S1588C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1588C3, buf);
    S1588C3 *dp, &lv = *(dp=new (buf) S1588C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1588C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C3)");
    check_base_class_offset(lv, (S1588C4*), 0, "S1588C3");
    check_base_class_offset(lv, (S1588C6*), ABISELECT(96,60), "S1588C3");
    check_base_class_offset(lv, (S1588C7*), ABISELECT(104,64), "S1588C3");
    check_field_offset(lv, s1588c3f0, ABISELECT(112,68), "S1588C3.s1588c3f0");
    check_field_offset(lv, s1588c3f1, ABISELECT(120,72), "S1588C3.s1588c3f1");
    set_bf_and_test(lv, s1588c3f2, ABISELECT(136,84), 0, 1, 1, "S1588C3");
    set_bf_and_test(lv, s1588c3f3, ABISELECT(136,84), 1, 1, 1, "S1588C3");
    set_bf_and_test(lv, s1588c3f4, ABISELECT(136,84), 2, 1, 1, "S1588C3");
    set_bf_and_test(lv, s1588c3f5, ABISELECT(136,84), 3, 1, 1, "S1588C3");
    test_class_info(&lv, &cd_S1588C3);
    dp->~S1588C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C3(Test_S1588C3, "S1588C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1588C3C1Ev();
extern void _ZN7S1588C3D1Ev();
Name_Map name_map_S1588C3[] = {
  NSPAIR(_ZN7S1588C3C1Ev),
  NSPAIR(_ZN7S1588C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1588C4;
extern VTBL_ENTRY _ZTI7S1588C4[];
extern  VTBL_ENTRY _ZTV7S1588C4[];
extern Class_Descriptor cd_S1588C6;
extern VTBL_ENTRY _ZTI7S1588C6[];
extern  VTBL_ENTRY _ZTV7S1588C6[];
extern Class_Descriptor cd_S1588C7;
extern VTBL_ENTRY _ZTI7S1588C7[];
extern  VTBL_ENTRY _ZTV7S1588C7[];
static Base_Class bases_S1588C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1588C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1588C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1588C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1588C3[];
extern void _ZN7S1588C3D1Ev();
extern void _ZN7S1588C3D0Ev();
extern void _ZN7S1588C42v9Ev();
extern void _ZN7S1588C43v10Ev();
extern void _ZN7S1588C43v11Ev();
extern void _ZN7S1588C43v12Ev();
extern void _ZN7S1588C43v13Ev();
extern void _ZN7S1588C43v14Ev();
extern void _ZN7S1588C43v15Ev();
extern void _ZN7S1588C43v16Ev();
extern void _ZN7S1588C43v17Ev();
extern void _ZN7S1588C43v18Ev();
extern void _ZN7S1588C43v19Ev();
extern void _ZN7S1588C43v20Ev();
extern void _ZN7S1588C43v21Ev();
extern void _ZN7S1588C43v22Ev();
extern void _ZN7S1588C43v23Ev();
extern void _ZN7S1588C43v24Ev();
extern void _ZN7S1588C43v25Ev();
extern void _ZN7S1588C43v26Ev();
extern void _ZN7S1588C43v27Ev();
extern void _ZN7S1588C43v28Ev();
extern void _ZN7S1588C43v29Ev();
extern void _ZN7S1588C43v30Ev();
extern void _ZN7S1588C43v31Ev();
extern void _ZN7S1588C43v32Ev();
extern void _ZN7S1588C43v33Ev();
extern void _ZN7S1588C43v34Ev();
extern void _ZN7S1588C43v35Ev();
extern void _ZN7S1588C43v36Ev();
extern void _ZN7S1588C43v37Ev();
extern void _ZN7S1588C43v38Ev();
extern void _ZN7S1588C43v39Ev();
extern void _ZN7S1588C43v40Ev();
extern void _ZN7S1588C43v41Ev();
extern void _ZN7S1588C43v42Ev();
extern void _ZN7S1588C43v43Ev();
extern void _ZN7S1588C43v44Ev();
extern void _ZN7S1588C43v45Ev();
extern void _ZN7S1588C43v46Ev();
extern void _ZN7S1588C43v47Ev();
extern void _ZN7S1588C43v48Ev();
extern void _ZN7S1588C43v49Ev();
extern void _ZN7S1588C43v50Ev();
extern void _ZN7S1588C43v51Ev();
extern void _ZN7S1588C43v52Ev();
extern void _ZN7S1588C43v53Ev();
extern void _ZN7S1588C43v54Ev();
extern void _ZN7S1588C43v55Ev();
extern void _ZN7S1588C43v56Ev();
extern void _ZN7S1588C43v57Ev();
extern void _ZN7S1588C43v58Ev();
extern void _ZN7S1588C43v59Ev();
extern void _ZN7S1588C43v60Ev();
extern void _ZN7S1588C43v61Ev();
extern void _ZN7S1588C43v62Ev();
extern void _ZN7S1588C43v63Ev();
extern void _ZN7S1588C43v64Ev();
extern void _ZN7S1588C43v65Ev();
extern void _ZN7S1588C43v66Ev();
extern void _ZN7S1588C43v67Ev();
extern void _ZN7S1588C43v68Ev();
extern void _ZN7S1588C43v69Ev();
extern void _ZN7S1588C43v70Ev();
extern void _ZN7S1588C43v71Ev();
extern void _ZN7S1588C43v72Ev();
extern void _ZN7S1588C33v98Ev();
extern void _ZN7S1588C33v99Ev();
extern void _ZN7S1588C34v100Ev();
extern void _ZN7S1588C34v101Ev();
extern void _ZN7S1588C34v102Ev();
extern void _ZN7S1588C34v103Ev();
extern void _ZN7S1588C34v104Ev();
extern void _ZN7S1588C34v105Ev();
extern void _ZN7S1588C34v106Ev();
extern void _ZN7S1588C34v107Ev();
extern void _ZN7S1588C34v108Ev();
extern void _ZN7S1588C34v109Ev();
extern void _ZN7S1588C34v110Ev();
extern void _ZN7S1588C34v111Ev();
extern void _ZN7S1588C34v112Ev();
extern void _ZN7S1588C34v113Ev();
extern void _ZN7S1588C34v114Ev();
extern void _ZN7S1588C34v115Ev();
extern void _ZN7S1588C34v116Ev();
extern void _ZN7S1588C34v117Ev();
extern void _ZN7S1588C34v118Ev();
extern void _ZN7S1588C34v119Ev();
extern void _ZN7S1588C34v120Ev();
extern void _ZN7S1588C34v121Ev();
extern void _ZN7S1588C63v73Ev();
extern void _ZN7S1588C63v74Ev();
extern void _ZN7S1588C63v75Ev();
extern void _ZN7S1588C63v76Ev();
extern void _ZN7S1588C63v77Ev();
extern void _ZN7S1588C63v78Ev();
extern void _ZN7S1588C63v79Ev();
extern void _ZN7S1588C63v80Ev();
extern void _ZN7S1588C63v81Ev();
extern void _ZN7S1588C63v82Ev();
extern void _ZN7S1588C63v83Ev();
extern void _ZN7S1588C63v84Ev();
extern void _ZN7S1588C63v85Ev();
extern void _ZN7S1588C63v86Ev();
extern void _ZN7S1588C63v87Ev();
extern void _ZN7S1588C63v88Ev();
extern void _ZN7S1588C73v89Ev();
extern void _ZN7S1588C73v90Ev();
extern void _ZN7S1588C73v91Ev();
extern void _ZN7S1588C73v92Ev();
extern void _ZN7S1588C73v93Ev();
extern void _ZN7S1588C73v94Ev();
extern void _ZN7S1588C73v95Ev();
extern void _ZN7S1588C73v96Ev();
extern void _ZN7S1588C73v97Ev();
static  VTBL_ENTRY vtc_S1588C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C3[0]),
  (VTBL_ENTRY)&_ZN7S1588C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1588C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1588C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v121Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1588C3[0]),
  (VTBL_ENTRY)&_ZN7S1588C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1588C3[0]),
  (VTBL_ENTRY)&_ZN7S1588C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1588C3[];
extern  VTBL_ENTRY _ZTV7S1588C3[];
Class_Descriptor cd_S1588C3 = {  "S1588C3", // class name
  bases_S1588C3, 3,
  &(vtc_S1588C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1588C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1588C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C2  : S1588C3 {
  ::S3262C11_nt s1588c2f0;
  int s1588c2f1;
  virtual  ~S1588C2(); // _ZN7S1588C2D1Ev
  virtual void  v122(); // _ZN7S1588C24v122Ev
  virtual void  v123(); // _ZN7S1588C24v123Ev
  virtual void  v124(); // _ZN7S1588C24v124Ev
  virtual void  v125(); // _ZN7S1588C24v125Ev
  virtual void  v126(); // _ZN7S1588C24v126Ev
  virtual void  v127(); // _ZN7S1588C24v127Ev
  virtual void  v128(); // _ZN7S1588C24v128Ev
  virtual void  v129(); // _ZN7S1588C24v129Ev
  virtual void  v130(); // _ZN7S1588C24v130Ev
  virtual void  v131(); // _ZN7S1588C24v131Ev
  virtual void  v132(); // _ZN7S1588C24v132Ev
  virtual void  v133(); // _ZN7S1588C24v133Ev
  virtual void  v134(); // _ZN7S1588C24v134Ev
  virtual void  v135(); // _ZN7S1588C24v135Ev
  virtual void  v136(); // _ZN7S1588C24v136Ev
  virtual void  v137(); // _ZN7S1588C24v137Ev
  virtual void  v138(); // _ZN7S1588C24v138Ev
  virtual void  v139(); // _ZN7S1588C24v139Ev
  virtual void  v140(); // _ZN7S1588C24v140Ev
  virtual void  v141(); // _ZN7S1588C24v141Ev
  virtual void  v142(); // _ZN7S1588C24v142Ev
  virtual void  v143(); // _ZN7S1588C24v143Ev
  virtual void  v144(); // _ZN7S1588C24v144Ev
  virtual void  v145(); // _ZN7S1588C24v145Ev
  virtual void  v146(); // _ZN7S1588C24v146Ev
  virtual void  v147(); // _ZN7S1588C24v147Ev
  S1588C2(); // tgen
};
//SIG(-1 S1588C2) C1{ BC2{ BC3{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106} BC6{ v107 v108 v109 v110 v111 v112 v113 v114 v115} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1588C2 ::~S1588C2(){ note_dtor("S1588C2", this);}
void  S1588C2 ::v122(){vfunc_called(this, "_ZN7S1588C24v122Ev");}
void  S1588C2 ::v123(){vfunc_called(this, "_ZN7S1588C24v123Ev");}
void  S1588C2 ::v124(){vfunc_called(this, "_ZN7S1588C24v124Ev");}
void  S1588C2 ::v125(){vfunc_called(this, "_ZN7S1588C24v125Ev");}
void  S1588C2 ::v126(){vfunc_called(this, "_ZN7S1588C24v126Ev");}
void  S1588C2 ::v127(){vfunc_called(this, "_ZN7S1588C24v127Ev");}
void  S1588C2 ::v128(){vfunc_called(this, "_ZN7S1588C24v128Ev");}
void  S1588C2 ::v129(){vfunc_called(this, "_ZN7S1588C24v129Ev");}
void  S1588C2 ::v130(){vfunc_called(this, "_ZN7S1588C24v130Ev");}
void  S1588C2 ::v131(){vfunc_called(this, "_ZN7S1588C24v131Ev");}
void  S1588C2 ::v132(){vfunc_called(this, "_ZN7S1588C24v132Ev");}
void  S1588C2 ::v133(){vfunc_called(this, "_ZN7S1588C24v133Ev");}
void  S1588C2 ::v134(){vfunc_called(this, "_ZN7S1588C24v134Ev");}
void  S1588C2 ::v135(){vfunc_called(this, "_ZN7S1588C24v135Ev");}
void  S1588C2 ::v136(){vfunc_called(this, "_ZN7S1588C24v136Ev");}
void  S1588C2 ::v137(){vfunc_called(this, "_ZN7S1588C24v137Ev");}
void  S1588C2 ::v138(){vfunc_called(this, "_ZN7S1588C24v138Ev");}
void  S1588C2 ::v139(){vfunc_called(this, "_ZN7S1588C24v139Ev");}
void  S1588C2 ::v140(){vfunc_called(this, "_ZN7S1588C24v140Ev");}
void  S1588C2 ::v141(){vfunc_called(this, "_ZN7S1588C24v141Ev");}
void  S1588C2 ::v142(){vfunc_called(this, "_ZN7S1588C24v142Ev");}
void  S1588C2 ::v143(){vfunc_called(this, "_ZN7S1588C24v143Ev");}
void  S1588C2 ::v144(){vfunc_called(this, "_ZN7S1588C24v144Ev");}
void  S1588C2 ::v145(){vfunc_called(this, "_ZN7S1588C24v145Ev");}
void  S1588C2 ::v146(){vfunc_called(this, "_ZN7S1588C24v146Ev");}
void  S1588C2 ::v147(){vfunc_called(this, "_ZN7S1588C24v147Ev");}
S1588C2 ::S1588C2(){ note_ctor("S1588C2", this);} // tgen

static void Test_S1588C2()
{
  extern Class_Descriptor cd_S1588C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1588C2, buf);
    S1588C2 *dp, &lv = *(dp=new (buf) S1588C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1588C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C2)");
    check_base_class_offset(lv, (S1588C4*)(S1588C3*), 0, "S1588C2");
    check_base_class_offset(lv, (S1588C6*)(S1588C3*), ABISELECT(96,60), "S1588C2");
    check_base_class_offset(lv, (S1588C7*)(S1588C3*), ABISELECT(104,64), "S1588C2");
    check_base_class_offset(lv, (S1588C3*), 0, "S1588C2");
    check_field_offset(lv, s1588c2f0, ABISELECT(144,88), "S1588C2.s1588c2f0");
    check_field_offset(lv, s1588c2f1, ABISELECT(168,104), "S1588C2.s1588c2f1");
    test_class_info(&lv, &cd_S1588C2);
    dp->~S1588C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C2(Test_S1588C2, "S1588C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1588C2C1Ev();
extern void _ZN7S1588C2D1Ev();
Name_Map name_map_S1588C2[] = {
  NSPAIR(_ZN7S1588C2C1Ev),
  NSPAIR(_ZN7S1588C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1588C4;
extern VTBL_ENTRY _ZTI7S1588C4[];
extern  VTBL_ENTRY _ZTV7S1588C4[];
extern Class_Descriptor cd_S1588C6;
extern VTBL_ENTRY _ZTI7S1588C6[];
extern  VTBL_ENTRY _ZTV7S1588C6[];
extern Class_Descriptor cd_S1588C7;
extern VTBL_ENTRY _ZTI7S1588C7[];
extern  VTBL_ENTRY _ZTV7S1588C7[];
extern Class_Descriptor cd_S1588C3;
extern VTBL_ENTRY _ZTI7S1588C3[];
extern  VTBL_ENTRY _ZTV7S1588C3[];
static Base_Class bases_S1588C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1588C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C6,    ABISELECT(96,60), //bcp->offset
    118, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C7,    ABISELECT(104,64), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1588C2[];
extern void _ZN7S1588C2D1Ev();
extern void _ZN7S1588C2D0Ev();
extern void _ZN7S1588C42v9Ev();
extern void _ZN7S1588C43v10Ev();
extern void _ZN7S1588C43v11Ev();
extern void _ZN7S1588C43v12Ev();
extern void _ZN7S1588C43v13Ev();
extern void _ZN7S1588C43v14Ev();
extern void _ZN7S1588C43v15Ev();
extern void _ZN7S1588C43v16Ev();
extern void _ZN7S1588C43v17Ev();
extern void _ZN7S1588C43v18Ev();
extern void _ZN7S1588C43v19Ev();
extern void _ZN7S1588C43v20Ev();
extern void _ZN7S1588C43v21Ev();
extern void _ZN7S1588C43v22Ev();
extern void _ZN7S1588C43v23Ev();
extern void _ZN7S1588C43v24Ev();
extern void _ZN7S1588C43v25Ev();
extern void _ZN7S1588C43v26Ev();
extern void _ZN7S1588C43v27Ev();
extern void _ZN7S1588C43v28Ev();
extern void _ZN7S1588C43v29Ev();
extern void _ZN7S1588C43v30Ev();
extern void _ZN7S1588C43v31Ev();
extern void _ZN7S1588C43v32Ev();
extern void _ZN7S1588C43v33Ev();
extern void _ZN7S1588C43v34Ev();
extern void _ZN7S1588C43v35Ev();
extern void _ZN7S1588C43v36Ev();
extern void _ZN7S1588C43v37Ev();
extern void _ZN7S1588C43v38Ev();
extern void _ZN7S1588C43v39Ev();
extern void _ZN7S1588C43v40Ev();
extern void _ZN7S1588C43v41Ev();
extern void _ZN7S1588C43v42Ev();
extern void _ZN7S1588C43v43Ev();
extern void _ZN7S1588C43v44Ev();
extern void _ZN7S1588C43v45Ev();
extern void _ZN7S1588C43v46Ev();
extern void _ZN7S1588C43v47Ev();
extern void _ZN7S1588C43v48Ev();
extern void _ZN7S1588C43v49Ev();
extern void _ZN7S1588C43v50Ev();
extern void _ZN7S1588C43v51Ev();
extern void _ZN7S1588C43v52Ev();
extern void _ZN7S1588C43v53Ev();
extern void _ZN7S1588C43v54Ev();
extern void _ZN7S1588C43v55Ev();
extern void _ZN7S1588C43v56Ev();
extern void _ZN7S1588C43v57Ev();
extern void _ZN7S1588C43v58Ev();
extern void _ZN7S1588C43v59Ev();
extern void _ZN7S1588C43v60Ev();
extern void _ZN7S1588C43v61Ev();
extern void _ZN7S1588C43v62Ev();
extern void _ZN7S1588C43v63Ev();
extern void _ZN7S1588C43v64Ev();
extern void _ZN7S1588C43v65Ev();
extern void _ZN7S1588C43v66Ev();
extern void _ZN7S1588C43v67Ev();
extern void _ZN7S1588C43v68Ev();
extern void _ZN7S1588C43v69Ev();
extern void _ZN7S1588C43v70Ev();
extern void _ZN7S1588C43v71Ev();
extern void _ZN7S1588C43v72Ev();
extern void _ZN7S1588C33v98Ev();
extern void _ZN7S1588C33v99Ev();
extern void _ZN7S1588C34v100Ev();
extern void _ZN7S1588C34v101Ev();
extern void _ZN7S1588C34v102Ev();
extern void _ZN7S1588C34v103Ev();
extern void _ZN7S1588C34v104Ev();
extern void _ZN7S1588C34v105Ev();
extern void _ZN7S1588C34v106Ev();
extern void _ZN7S1588C34v107Ev();
extern void _ZN7S1588C34v108Ev();
extern void _ZN7S1588C34v109Ev();
extern void _ZN7S1588C34v110Ev();
extern void _ZN7S1588C34v111Ev();
extern void _ZN7S1588C34v112Ev();
extern void _ZN7S1588C34v113Ev();
extern void _ZN7S1588C34v114Ev();
extern void _ZN7S1588C34v115Ev();
extern void _ZN7S1588C34v116Ev();
extern void _ZN7S1588C34v117Ev();
extern void _ZN7S1588C34v118Ev();
extern void _ZN7S1588C34v119Ev();
extern void _ZN7S1588C34v120Ev();
extern void _ZN7S1588C34v121Ev();
extern void _ZN7S1588C24v122Ev();
extern void _ZN7S1588C24v123Ev();
extern void _ZN7S1588C24v124Ev();
extern void _ZN7S1588C24v125Ev();
extern void _ZN7S1588C24v126Ev();
extern void _ZN7S1588C24v127Ev();
extern void _ZN7S1588C24v128Ev();
extern void _ZN7S1588C24v129Ev();
extern void _ZN7S1588C24v130Ev();
extern void _ZN7S1588C24v131Ev();
extern void _ZN7S1588C24v132Ev();
extern void _ZN7S1588C24v133Ev();
extern void _ZN7S1588C24v134Ev();
extern void _ZN7S1588C24v135Ev();
extern void _ZN7S1588C24v136Ev();
extern void _ZN7S1588C24v137Ev();
extern void _ZN7S1588C24v138Ev();
extern void _ZN7S1588C24v139Ev();
extern void _ZN7S1588C24v140Ev();
extern void _ZN7S1588C24v141Ev();
extern void _ZN7S1588C24v142Ev();
extern void _ZN7S1588C24v143Ev();
extern void _ZN7S1588C24v144Ev();
extern void _ZN7S1588C24v145Ev();
extern void _ZN7S1588C24v146Ev();
extern void _ZN7S1588C24v147Ev();
extern void _ZN7S1588C63v73Ev();
extern void _ZN7S1588C63v74Ev();
extern void _ZN7S1588C63v75Ev();
extern void _ZN7S1588C63v76Ev();
extern void _ZN7S1588C63v77Ev();
extern void _ZN7S1588C63v78Ev();
extern void _ZN7S1588C63v79Ev();
extern void _ZN7S1588C63v80Ev();
extern void _ZN7S1588C63v81Ev();
extern void _ZN7S1588C63v82Ev();
extern void _ZN7S1588C63v83Ev();
extern void _ZN7S1588C63v84Ev();
extern void _ZN7S1588C63v85Ev();
extern void _ZN7S1588C63v86Ev();
extern void _ZN7S1588C63v87Ev();
extern void _ZN7S1588C63v88Ev();
extern void _ZN7S1588C73v89Ev();
extern void _ZN7S1588C73v90Ev();
extern void _ZN7S1588C73v91Ev();
extern void _ZN7S1588C73v92Ev();
extern void _ZN7S1588C73v93Ev();
extern void _ZN7S1588C73v94Ev();
extern void _ZN7S1588C73v95Ev();
extern void _ZN7S1588C73v96Ev();
extern void _ZN7S1588C73v97Ev();
static  VTBL_ENTRY vtc_S1588C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C2[0]),
  (VTBL_ENTRY)&_ZN7S1588C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1588C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1588C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v147Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1588C2[0]),
  (VTBL_ENTRY)&_ZN7S1588C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1588C2[0]),
  (VTBL_ENTRY)&_ZN7S1588C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1588C2[];
extern  VTBL_ENTRY _ZTV7S1588C2[];
Class_Descriptor cd_S1588C2 = {  "S1588C2", // class name
  bases_S1588C2, 4,
  &(vtc_S1588C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1588C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1588C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1588C1  : S1588C2 {
  ::S79C8_nt s1588c1f0;
  virtual  ~S1588C1(); // _ZN7S1588C1D1Ev
  virtual void  v1(); // _ZN7S1588C12v1Ev
  virtual void  v2(); // _ZN7S1588C12v2Ev
  virtual void  v3(); // _ZN7S1588C12v3Ev
  virtual void  v4(); // _ZN7S1588C12v4Ev
  virtual void  v5(); // _ZN7S1588C12v5Ev
  virtual void  v6(); // _ZN7S1588C12v6Ev
  virtual void  v7(); // _ZN7S1588C12v7Ev
  virtual void  v8(); // _ZN7S1588C12v8Ev
  S1588C1(); // tgen
};
//SIG(1 S1588C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88} BC7{ v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 FC5}


 S1588C1 ::~S1588C1(){ note_dtor("S1588C1", this);}
void  S1588C1 ::v1(){vfunc_called(this, "_ZN7S1588C12v1Ev");}
void  S1588C1 ::v2(){vfunc_called(this, "_ZN7S1588C12v2Ev");}
void  S1588C1 ::v3(){vfunc_called(this, "_ZN7S1588C12v3Ev");}
void  S1588C1 ::v4(){vfunc_called(this, "_ZN7S1588C12v4Ev");}
void  S1588C1 ::v5(){vfunc_called(this, "_ZN7S1588C12v5Ev");}
void  S1588C1 ::v6(){vfunc_called(this, "_ZN7S1588C12v6Ev");}
void  S1588C1 ::v7(){vfunc_called(this, "_ZN7S1588C12v7Ev");}
void  S1588C1 ::v8(){vfunc_called(this, "_ZN7S1588C12v8Ev");}
S1588C1 ::S1588C1(){ note_ctor("S1588C1", this);} // tgen

static void Test_S1588C1()
{
  extern Class_Descriptor cd_S1588C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,30)];
    init_test(&cd_S1588C1, buf);
    S1588C1 *dp, &lv = *(dp=new (buf) S1588C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,116), "sizeof(S1588C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1588C1)");
    check_base_class_offset(lv, (S1588C4*)(S1588C3*)(S1588C2*), 0, "S1588C1");
    check_base_class_offset(lv, (S1588C6*)(S1588C3*)(S1588C2*), ABISELECT(96,60), "S1588C1");
    check_base_class_offset(lv, (S1588C7*)(S1588C3*)(S1588C2*), ABISELECT(104,64), "S1588C1");
    check_base_class_offset(lv, (S1588C3*)(S1588C2*), 0, "S1588C1");
    check_base_class_offset(lv, (S1588C2*), 0, "S1588C1");
    check_field_offset(lv, s1588c1f0, ABISELECT(172,108), "S1588C1.s1588c1f0");
    test_class_info(&lv, &cd_S1588C1);
    dp->~S1588C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1588C1(Test_S1588C1, "S1588C1", ABISELECT(184,116));

#else // __cplusplus

extern void _ZN7S1588C1C1Ev();
extern void _ZN7S1588C1D1Ev();
Name_Map name_map_S1588C1[] = {
  NSPAIR(_ZN7S1588C1C1Ev),
  NSPAIR(_ZN7S1588C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1588C4;
extern VTBL_ENTRY _ZTI7S1588C4[];
extern  VTBL_ENTRY _ZTV7S1588C4[];
extern Class_Descriptor cd_S1588C6;
extern VTBL_ENTRY _ZTI7S1588C6[];
extern  VTBL_ENTRY _ZTV7S1588C6[];
extern Class_Descriptor cd_S1588C7;
extern VTBL_ENTRY _ZTI7S1588C7[];
extern  VTBL_ENTRY _ZTV7S1588C7[];
extern Class_Descriptor cd_S1588C3;
extern VTBL_ENTRY _ZTI7S1588C3[];
extern  VTBL_ENTRY _ZTV7S1588C3[];
extern Class_Descriptor cd_S1588C2;
extern VTBL_ENTRY _ZTI7S1588C2[];
extern  VTBL_ENTRY _ZTV7S1588C2[];
static Base_Class bases_S1588C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1588C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C6,    ABISELECT(96,60), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C7,    ABISELECT(104,64), //bcp->offset
    144, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1588C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1588C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1588C1[];
extern void _ZN7S1588C1D1Ev();
extern void _ZN7S1588C1D0Ev();
extern void _ZN7S1588C42v9Ev();
extern void _ZN7S1588C43v10Ev();
extern void _ZN7S1588C43v11Ev();
extern void _ZN7S1588C43v12Ev();
extern void _ZN7S1588C43v13Ev();
extern void _ZN7S1588C43v14Ev();
extern void _ZN7S1588C43v15Ev();
extern void _ZN7S1588C43v16Ev();
extern void _ZN7S1588C43v17Ev();
extern void _ZN7S1588C43v18Ev();
extern void _ZN7S1588C43v19Ev();
extern void _ZN7S1588C43v20Ev();
extern void _ZN7S1588C43v21Ev();
extern void _ZN7S1588C43v22Ev();
extern void _ZN7S1588C43v23Ev();
extern void _ZN7S1588C43v24Ev();
extern void _ZN7S1588C43v25Ev();
extern void _ZN7S1588C43v26Ev();
extern void _ZN7S1588C43v27Ev();
extern void _ZN7S1588C43v28Ev();
extern void _ZN7S1588C43v29Ev();
extern void _ZN7S1588C43v30Ev();
extern void _ZN7S1588C43v31Ev();
extern void _ZN7S1588C43v32Ev();
extern void _ZN7S1588C43v33Ev();
extern void _ZN7S1588C43v34Ev();
extern void _ZN7S1588C43v35Ev();
extern void _ZN7S1588C43v36Ev();
extern void _ZN7S1588C43v37Ev();
extern void _ZN7S1588C43v38Ev();
extern void _ZN7S1588C43v39Ev();
extern void _ZN7S1588C43v40Ev();
extern void _ZN7S1588C43v41Ev();
extern void _ZN7S1588C43v42Ev();
extern void _ZN7S1588C43v43Ev();
extern void _ZN7S1588C43v44Ev();
extern void _ZN7S1588C43v45Ev();
extern void _ZN7S1588C43v46Ev();
extern void _ZN7S1588C43v47Ev();
extern void _ZN7S1588C43v48Ev();
extern void _ZN7S1588C43v49Ev();
extern void _ZN7S1588C43v50Ev();
extern void _ZN7S1588C43v51Ev();
extern void _ZN7S1588C43v52Ev();
extern void _ZN7S1588C43v53Ev();
extern void _ZN7S1588C43v54Ev();
extern void _ZN7S1588C43v55Ev();
extern void _ZN7S1588C43v56Ev();
extern void _ZN7S1588C43v57Ev();
extern void _ZN7S1588C43v58Ev();
extern void _ZN7S1588C43v59Ev();
extern void _ZN7S1588C43v60Ev();
extern void _ZN7S1588C43v61Ev();
extern void _ZN7S1588C43v62Ev();
extern void _ZN7S1588C43v63Ev();
extern void _ZN7S1588C43v64Ev();
extern void _ZN7S1588C43v65Ev();
extern void _ZN7S1588C43v66Ev();
extern void _ZN7S1588C43v67Ev();
extern void _ZN7S1588C43v68Ev();
extern void _ZN7S1588C43v69Ev();
extern void _ZN7S1588C43v70Ev();
extern void _ZN7S1588C43v71Ev();
extern void _ZN7S1588C43v72Ev();
extern void _ZN7S1588C33v98Ev();
extern void _ZN7S1588C33v99Ev();
extern void _ZN7S1588C34v100Ev();
extern void _ZN7S1588C34v101Ev();
extern void _ZN7S1588C34v102Ev();
extern void _ZN7S1588C34v103Ev();
extern void _ZN7S1588C34v104Ev();
extern void _ZN7S1588C34v105Ev();
extern void _ZN7S1588C34v106Ev();
extern void _ZN7S1588C34v107Ev();
extern void _ZN7S1588C34v108Ev();
extern void _ZN7S1588C34v109Ev();
extern void _ZN7S1588C34v110Ev();
extern void _ZN7S1588C34v111Ev();
extern void _ZN7S1588C34v112Ev();
extern void _ZN7S1588C34v113Ev();
extern void _ZN7S1588C34v114Ev();
extern void _ZN7S1588C34v115Ev();
extern void _ZN7S1588C34v116Ev();
extern void _ZN7S1588C34v117Ev();
extern void _ZN7S1588C34v118Ev();
extern void _ZN7S1588C34v119Ev();
extern void _ZN7S1588C34v120Ev();
extern void _ZN7S1588C34v121Ev();
extern void _ZN7S1588C24v122Ev();
extern void _ZN7S1588C24v123Ev();
extern void _ZN7S1588C24v124Ev();
extern void _ZN7S1588C24v125Ev();
extern void _ZN7S1588C24v126Ev();
extern void _ZN7S1588C24v127Ev();
extern void _ZN7S1588C24v128Ev();
extern void _ZN7S1588C24v129Ev();
extern void _ZN7S1588C24v130Ev();
extern void _ZN7S1588C24v131Ev();
extern void _ZN7S1588C24v132Ev();
extern void _ZN7S1588C24v133Ev();
extern void _ZN7S1588C24v134Ev();
extern void _ZN7S1588C24v135Ev();
extern void _ZN7S1588C24v136Ev();
extern void _ZN7S1588C24v137Ev();
extern void _ZN7S1588C24v138Ev();
extern void _ZN7S1588C24v139Ev();
extern void _ZN7S1588C24v140Ev();
extern void _ZN7S1588C24v141Ev();
extern void _ZN7S1588C24v142Ev();
extern void _ZN7S1588C24v143Ev();
extern void _ZN7S1588C24v144Ev();
extern void _ZN7S1588C24v145Ev();
extern void _ZN7S1588C24v146Ev();
extern void _ZN7S1588C24v147Ev();
extern void _ZN7S1588C12v1Ev();
extern void _ZN7S1588C12v2Ev();
extern void _ZN7S1588C12v3Ev();
extern void _ZN7S1588C12v4Ev();
extern void _ZN7S1588C12v5Ev();
extern void _ZN7S1588C12v6Ev();
extern void _ZN7S1588C12v7Ev();
extern void _ZN7S1588C12v8Ev();
extern void _ZN7S1588C63v73Ev();
extern void _ZN7S1588C63v74Ev();
extern void _ZN7S1588C63v75Ev();
extern void _ZN7S1588C63v76Ev();
extern void _ZN7S1588C63v77Ev();
extern void _ZN7S1588C63v78Ev();
extern void _ZN7S1588C63v79Ev();
extern void _ZN7S1588C63v80Ev();
extern void _ZN7S1588C63v81Ev();
extern void _ZN7S1588C63v82Ev();
extern void _ZN7S1588C63v83Ev();
extern void _ZN7S1588C63v84Ev();
extern void _ZN7S1588C63v85Ev();
extern void _ZN7S1588C63v86Ev();
extern void _ZN7S1588C63v87Ev();
extern void _ZN7S1588C63v88Ev();
extern void _ZN7S1588C73v89Ev();
extern void _ZN7S1588C73v90Ev();
extern void _ZN7S1588C73v91Ev();
extern void _ZN7S1588C73v92Ev();
extern void _ZN7S1588C73v93Ev();
extern void _ZN7S1588C73v94Ev();
extern void _ZN7S1588C73v95Ev();
extern void _ZN7S1588C73v96Ev();
extern void _ZN7S1588C73v97Ev();
static  VTBL_ENTRY vtc_S1588C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1588C1[0]),
  (VTBL_ENTRY)&_ZN7S1588C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1588C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1588C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1588C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1588C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1588C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1588C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1588C12v8Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1588C1[0]),
  (VTBL_ENTRY)&_ZN7S1588C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1588C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1588C1[0]),
  (VTBL_ENTRY)&_ZN7S1588C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1588C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1588C1[];
extern  VTBL_ENTRY _ZTV7S1588C1[];
Class_Descriptor cd_S1588C1 = {  "S1588C1", // class name
  bases_S1588C1, 5,
  &(vtc_S1588C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,116), // object size
  NSPAIRA(_ZTI7S1588C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1588C1),155, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C4  {
  int s1589c4f0;
  __tsi64 s1589c4f1;
  void *s1589c4f2[4];
  int s1589c4f3[2];
  void *s1589c4f4;
  ::S79C8_nt s1589c4f5;
  void *s1589c4f6[2];
  virtual  ~S1589C4(); // _ZN7S1589C4D1Ev
  virtual void  v9(); // _ZN7S1589C42v9Ev
  virtual void  v10(); // _ZN7S1589C43v10Ev
  virtual void  v11(); // _ZN7S1589C43v11Ev
  virtual void  v12(); // _ZN7S1589C43v12Ev
  virtual void  v13(); // _ZN7S1589C43v13Ev
  virtual void  v14(); // _ZN7S1589C43v14Ev
  virtual void  v15(); // _ZN7S1589C43v15Ev
  virtual void  v16(); // _ZN7S1589C43v16Ev
  virtual void  v17(); // _ZN7S1589C43v17Ev
  virtual void  v18(); // _ZN7S1589C43v18Ev
  virtual void  v19(); // _ZN7S1589C43v19Ev
  virtual void  v20(); // _ZN7S1589C43v20Ev
  virtual void  v21(); // _ZN7S1589C43v21Ev
  virtual void  v22(); // _ZN7S1589C43v22Ev
  virtual void  v23(); // _ZN7S1589C43v23Ev
  virtual void  v24(); // _ZN7S1589C43v24Ev
  virtual void  v25(); // _ZN7S1589C43v25Ev
  virtual void  v26(); // _ZN7S1589C43v26Ev
  virtual void  v27(); // _ZN7S1589C43v27Ev
  virtual void  v28(); // _ZN7S1589C43v28Ev
  virtual void  v29(); // _ZN7S1589C43v29Ev
  virtual void  v30(); // _ZN7S1589C43v30Ev
  virtual void  v31(); // _ZN7S1589C43v31Ev
  virtual void  v32(); // _ZN7S1589C43v32Ev
  virtual void  v33(); // _ZN7S1589C43v33Ev
  virtual void  v34(); // _ZN7S1589C43v34Ev
  virtual void  v35(); // _ZN7S1589C43v35Ev
  virtual void  v36(); // _ZN7S1589C43v36Ev
  virtual void  v37(); // _ZN7S1589C43v37Ev
  virtual void  v38(); // _ZN7S1589C43v38Ev
  virtual void  v39(); // _ZN7S1589C43v39Ev
  virtual void  v40(); // _ZN7S1589C43v40Ev
  virtual void  v41(); // _ZN7S1589C43v41Ev
  virtual void  v42(); // _ZN7S1589C43v42Ev
  virtual void  v43(); // _ZN7S1589C43v43Ev
  virtual void  v44(); // _ZN7S1589C43v44Ev
  virtual void  v45(); // _ZN7S1589C43v45Ev
  virtual void  v46(); // _ZN7S1589C43v46Ev
  virtual void  v47(); // _ZN7S1589C43v47Ev
  virtual void  v48(); // _ZN7S1589C43v48Ev
  virtual void  v49(); // _ZN7S1589C43v49Ev
  virtual void  v50(); // _ZN7S1589C43v50Ev
  virtual void  v51(); // _ZN7S1589C43v51Ev
  virtual void  v52(); // _ZN7S1589C43v52Ev
  virtual void  v53(); // _ZN7S1589C43v53Ev
  virtual void  v54(); // _ZN7S1589C43v54Ev
  virtual void  v55(); // _ZN7S1589C43v55Ev
  virtual void  v56(); // _ZN7S1589C43v56Ev
  virtual void  v57(); // _ZN7S1589C43v57Ev
  virtual void  v58(); // _ZN7S1589C43v58Ev
  virtual void  v59(); // _ZN7S1589C43v59Ev
  virtual void  v60(); // _ZN7S1589C43v60Ev
  virtual void  v61(); // _ZN7S1589C43v61Ev
  virtual void  v62(); // _ZN7S1589C43v62Ev
  virtual void  v63(); // _ZN7S1589C43v63Ev
  virtual void  v64(); // _ZN7S1589C43v64Ev
  virtual void  v65(); // _ZN7S1589C43v65Ev
  virtual void  v66(); // _ZN7S1589C43v66Ev
  virtual void  v67(); // _ZN7S1589C43v67Ev
  virtual void  v68(); // _ZN7S1589C43v68Ev
  virtual void  v69(); // _ZN7S1589C43v69Ev
  virtual void  v70(); // _ZN7S1589C43v70Ev
  virtual void  v71(); // _ZN7S1589C43v71Ev
  virtual void  v72(); // _ZN7S1589C43v72Ev
  S1589C4(); // tgen
};
//SIG(-1 S1589C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1589C4 ::~S1589C4(){ note_dtor("S1589C4", this);}
void  S1589C4 ::v9(){vfunc_called(this, "_ZN7S1589C42v9Ev");}
void  S1589C4 ::v10(){vfunc_called(this, "_ZN7S1589C43v10Ev");}
void  S1589C4 ::v11(){vfunc_called(this, "_ZN7S1589C43v11Ev");}
void  S1589C4 ::v12(){vfunc_called(this, "_ZN7S1589C43v12Ev");}
void  S1589C4 ::v13(){vfunc_called(this, "_ZN7S1589C43v13Ev");}
void  S1589C4 ::v14(){vfunc_called(this, "_ZN7S1589C43v14Ev");}
void  S1589C4 ::v15(){vfunc_called(this, "_ZN7S1589C43v15Ev");}
void  S1589C4 ::v16(){vfunc_called(this, "_ZN7S1589C43v16Ev");}
void  S1589C4 ::v17(){vfunc_called(this, "_ZN7S1589C43v17Ev");}
void  S1589C4 ::v18(){vfunc_called(this, "_ZN7S1589C43v18Ev");}
void  S1589C4 ::v19(){vfunc_called(this, "_ZN7S1589C43v19Ev");}
void  S1589C4 ::v20(){vfunc_called(this, "_ZN7S1589C43v20Ev");}
void  S1589C4 ::v21(){vfunc_called(this, "_ZN7S1589C43v21Ev");}
void  S1589C4 ::v22(){vfunc_called(this, "_ZN7S1589C43v22Ev");}
void  S1589C4 ::v23(){vfunc_called(this, "_ZN7S1589C43v23Ev");}
void  S1589C4 ::v24(){vfunc_called(this, "_ZN7S1589C43v24Ev");}
void  S1589C4 ::v25(){vfunc_called(this, "_ZN7S1589C43v25Ev");}
void  S1589C4 ::v26(){vfunc_called(this, "_ZN7S1589C43v26Ev");}
void  S1589C4 ::v27(){vfunc_called(this, "_ZN7S1589C43v27Ev");}
void  S1589C4 ::v28(){vfunc_called(this, "_ZN7S1589C43v28Ev");}
void  S1589C4 ::v29(){vfunc_called(this, "_ZN7S1589C43v29Ev");}
void  S1589C4 ::v30(){vfunc_called(this, "_ZN7S1589C43v30Ev");}
void  S1589C4 ::v31(){vfunc_called(this, "_ZN7S1589C43v31Ev");}
void  S1589C4 ::v32(){vfunc_called(this, "_ZN7S1589C43v32Ev");}
void  S1589C4 ::v33(){vfunc_called(this, "_ZN7S1589C43v33Ev");}
void  S1589C4 ::v34(){vfunc_called(this, "_ZN7S1589C43v34Ev");}
void  S1589C4 ::v35(){vfunc_called(this, "_ZN7S1589C43v35Ev");}
void  S1589C4 ::v36(){vfunc_called(this, "_ZN7S1589C43v36Ev");}
void  S1589C4 ::v37(){vfunc_called(this, "_ZN7S1589C43v37Ev");}
void  S1589C4 ::v38(){vfunc_called(this, "_ZN7S1589C43v38Ev");}
void  S1589C4 ::v39(){vfunc_called(this, "_ZN7S1589C43v39Ev");}
void  S1589C4 ::v40(){vfunc_called(this, "_ZN7S1589C43v40Ev");}
void  S1589C4 ::v41(){vfunc_called(this, "_ZN7S1589C43v41Ev");}
void  S1589C4 ::v42(){vfunc_called(this, "_ZN7S1589C43v42Ev");}
void  S1589C4 ::v43(){vfunc_called(this, "_ZN7S1589C43v43Ev");}
void  S1589C4 ::v44(){vfunc_called(this, "_ZN7S1589C43v44Ev");}
void  S1589C4 ::v45(){vfunc_called(this, "_ZN7S1589C43v45Ev");}
void  S1589C4 ::v46(){vfunc_called(this, "_ZN7S1589C43v46Ev");}
void  S1589C4 ::v47(){vfunc_called(this, "_ZN7S1589C43v47Ev");}
void  S1589C4 ::v48(){vfunc_called(this, "_ZN7S1589C43v48Ev");}
void  S1589C4 ::v49(){vfunc_called(this, "_ZN7S1589C43v49Ev");}
void  S1589C4 ::v50(){vfunc_called(this, "_ZN7S1589C43v50Ev");}
void  S1589C4 ::v51(){vfunc_called(this, "_ZN7S1589C43v51Ev");}
void  S1589C4 ::v52(){vfunc_called(this, "_ZN7S1589C43v52Ev");}
void  S1589C4 ::v53(){vfunc_called(this, "_ZN7S1589C43v53Ev");}
void  S1589C4 ::v54(){vfunc_called(this, "_ZN7S1589C43v54Ev");}
void  S1589C4 ::v55(){vfunc_called(this, "_ZN7S1589C43v55Ev");}
void  S1589C4 ::v56(){vfunc_called(this, "_ZN7S1589C43v56Ev");}
void  S1589C4 ::v57(){vfunc_called(this, "_ZN7S1589C43v57Ev");}
void  S1589C4 ::v58(){vfunc_called(this, "_ZN7S1589C43v58Ev");}
void  S1589C4 ::v59(){vfunc_called(this, "_ZN7S1589C43v59Ev");}
void  S1589C4 ::v60(){vfunc_called(this, "_ZN7S1589C43v60Ev");}
void  S1589C4 ::v61(){vfunc_called(this, "_ZN7S1589C43v61Ev");}
void  S1589C4 ::v62(){vfunc_called(this, "_ZN7S1589C43v62Ev");}
void  S1589C4 ::v63(){vfunc_called(this, "_ZN7S1589C43v63Ev");}
void  S1589C4 ::v64(){vfunc_called(this, "_ZN7S1589C43v64Ev");}
void  S1589C4 ::v65(){vfunc_called(this, "_ZN7S1589C43v65Ev");}
void  S1589C4 ::v66(){vfunc_called(this, "_ZN7S1589C43v66Ev");}
void  S1589C4 ::v67(){vfunc_called(this, "_ZN7S1589C43v67Ev");}
void  S1589C4 ::v68(){vfunc_called(this, "_ZN7S1589C43v68Ev");}
void  S1589C4 ::v69(){vfunc_called(this, "_ZN7S1589C43v69Ev");}
void  S1589C4 ::v70(){vfunc_called(this, "_ZN7S1589C43v70Ev");}
void  S1589C4 ::v71(){vfunc_called(this, "_ZN7S1589C43v71Ev");}
void  S1589C4 ::v72(){vfunc_called(this, "_ZN7S1589C43v72Ev");}
S1589C4 ::S1589C4(){ note_ctor("S1589C4", this);} // tgen

static void Test_S1589C4()
{
  extern Class_Descriptor cd_S1589C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1589C4, buf);
    S1589C4 *dp, &lv = *(dp=new (buf) S1589C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1589C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C4)");
    check_field_offset(lv, s1589c4f0, ABISELECT(8,4), "S1589C4.s1589c4f0");
    check_field_offset(lv, s1589c4f1, ABISELECT(16,8), "S1589C4.s1589c4f1");
    check_field_offset(lv, s1589c4f2, ABISELECT(24,16), "S1589C4.s1589c4f2");
    check_field_offset(lv, s1589c4f3, ABISELECT(56,32), "S1589C4.s1589c4f3");
    check_field_offset(lv, s1589c4f4, ABISELECT(64,40), "S1589C4.s1589c4f4");
    check_field_offset(lv, s1589c4f5, ABISELECT(72,44), "S1589C4.s1589c4f5");
    check_field_offset(lv, s1589c4f6, ABISELECT(80,52), "S1589C4.s1589c4f6");
    test_class_info(&lv, &cd_S1589C4);
    dp->~S1589C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C4(Test_S1589C4, "S1589C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1589C4C1Ev();
extern void _ZN7S1589C4D1Ev();
Name_Map name_map_S1589C4[] = {
  NSPAIR(_ZN7S1589C4C1Ev),
  NSPAIR(_ZN7S1589C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1589C4[];
extern void _ZN7S1589C4D1Ev();
extern void _ZN7S1589C4D0Ev();
extern void _ZN7S1589C42v9Ev();
extern void _ZN7S1589C43v10Ev();
extern void _ZN7S1589C43v11Ev();
extern void _ZN7S1589C43v12Ev();
extern void _ZN7S1589C43v13Ev();
extern void _ZN7S1589C43v14Ev();
extern void _ZN7S1589C43v15Ev();
extern void _ZN7S1589C43v16Ev();
extern void _ZN7S1589C43v17Ev();
extern void _ZN7S1589C43v18Ev();
extern void _ZN7S1589C43v19Ev();
extern void _ZN7S1589C43v20Ev();
extern void _ZN7S1589C43v21Ev();
extern void _ZN7S1589C43v22Ev();
extern void _ZN7S1589C43v23Ev();
extern void _ZN7S1589C43v24Ev();
extern void _ZN7S1589C43v25Ev();
extern void _ZN7S1589C43v26Ev();
extern void _ZN7S1589C43v27Ev();
extern void _ZN7S1589C43v28Ev();
extern void _ZN7S1589C43v29Ev();
extern void _ZN7S1589C43v30Ev();
extern void _ZN7S1589C43v31Ev();
extern void _ZN7S1589C43v32Ev();
extern void _ZN7S1589C43v33Ev();
extern void _ZN7S1589C43v34Ev();
extern void _ZN7S1589C43v35Ev();
extern void _ZN7S1589C43v36Ev();
extern void _ZN7S1589C43v37Ev();
extern void _ZN7S1589C43v38Ev();
extern void _ZN7S1589C43v39Ev();
extern void _ZN7S1589C43v40Ev();
extern void _ZN7S1589C43v41Ev();
extern void _ZN7S1589C43v42Ev();
extern void _ZN7S1589C43v43Ev();
extern void _ZN7S1589C43v44Ev();
extern void _ZN7S1589C43v45Ev();
extern void _ZN7S1589C43v46Ev();
extern void _ZN7S1589C43v47Ev();
extern void _ZN7S1589C43v48Ev();
extern void _ZN7S1589C43v49Ev();
extern void _ZN7S1589C43v50Ev();
extern void _ZN7S1589C43v51Ev();
extern void _ZN7S1589C43v52Ev();
extern void _ZN7S1589C43v53Ev();
extern void _ZN7S1589C43v54Ev();
extern void _ZN7S1589C43v55Ev();
extern void _ZN7S1589C43v56Ev();
extern void _ZN7S1589C43v57Ev();
extern void _ZN7S1589C43v58Ev();
extern void _ZN7S1589C43v59Ev();
extern void _ZN7S1589C43v60Ev();
extern void _ZN7S1589C43v61Ev();
extern void _ZN7S1589C43v62Ev();
extern void _ZN7S1589C43v63Ev();
extern void _ZN7S1589C43v64Ev();
extern void _ZN7S1589C43v65Ev();
extern void _ZN7S1589C43v66Ev();
extern void _ZN7S1589C43v67Ev();
extern void _ZN7S1589C43v68Ev();
extern void _ZN7S1589C43v69Ev();
extern void _ZN7S1589C43v70Ev();
extern void _ZN7S1589C43v71Ev();
extern void _ZN7S1589C43v72Ev();
static  VTBL_ENTRY vtc_S1589C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C4[0]),
  (VTBL_ENTRY)&_ZN7S1589C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1589C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1589C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1589C4[];
extern  VTBL_ENTRY _ZTV7S1589C4[];
Class_Descriptor cd_S1589C4 = {  "S1589C4", // class name
  0,0,//no base classes
  &(vtc_S1589C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1589C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1589C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C6  {
  virtual void  v73(); // _ZN7S1589C63v73Ev
  virtual void  v74(); // _ZN7S1589C63v74Ev
  virtual void  v75(); // _ZN7S1589C63v75Ev
  virtual void  v76(); // _ZN7S1589C63v76Ev
  virtual void  v77(); // _ZN7S1589C63v77Ev
  virtual void  v78(); // _ZN7S1589C63v78Ev
  virtual void  v79(); // _ZN7S1589C63v79Ev
  virtual void  v80(); // _ZN7S1589C63v80Ev
  virtual void  v81(); // _ZN7S1589C63v81Ev
  virtual void  v82(); // _ZN7S1589C63v82Ev
  virtual void  v83(); // _ZN7S1589C63v83Ev
  virtual void  v84(); // _ZN7S1589C63v84Ev
  virtual void  v85(); // _ZN7S1589C63v85Ev
  virtual void  v86(); // _ZN7S1589C63v86Ev
  virtual void  v87(); // _ZN7S1589C63v87Ev
  virtual void  v88(); // _ZN7S1589C63v88Ev
  ~S1589C6(); // tgen
  S1589C6(); // tgen
};
//SIG(-1 S1589C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1589C6 ::v73(){vfunc_called(this, "_ZN7S1589C63v73Ev");}
void  S1589C6 ::v74(){vfunc_called(this, "_ZN7S1589C63v74Ev");}
void  S1589C6 ::v75(){vfunc_called(this, "_ZN7S1589C63v75Ev");}
void  S1589C6 ::v76(){vfunc_called(this, "_ZN7S1589C63v76Ev");}
void  S1589C6 ::v77(){vfunc_called(this, "_ZN7S1589C63v77Ev");}
void  S1589C6 ::v78(){vfunc_called(this, "_ZN7S1589C63v78Ev");}
void  S1589C6 ::v79(){vfunc_called(this, "_ZN7S1589C63v79Ev");}
void  S1589C6 ::v80(){vfunc_called(this, "_ZN7S1589C63v80Ev");}
void  S1589C6 ::v81(){vfunc_called(this, "_ZN7S1589C63v81Ev");}
void  S1589C6 ::v82(){vfunc_called(this, "_ZN7S1589C63v82Ev");}
void  S1589C6 ::v83(){vfunc_called(this, "_ZN7S1589C63v83Ev");}
void  S1589C6 ::v84(){vfunc_called(this, "_ZN7S1589C63v84Ev");}
void  S1589C6 ::v85(){vfunc_called(this, "_ZN7S1589C63v85Ev");}
void  S1589C6 ::v86(){vfunc_called(this, "_ZN7S1589C63v86Ev");}
void  S1589C6 ::v87(){vfunc_called(this, "_ZN7S1589C63v87Ev");}
void  S1589C6 ::v88(){vfunc_called(this, "_ZN7S1589C63v88Ev");}
S1589C6 ::~S1589C6(){ note_dtor("S1589C6", this);} // tgen
S1589C6 ::S1589C6(){ note_ctor("S1589C6", this);} // tgen

static void Test_S1589C6()
{
  extern Class_Descriptor cd_S1589C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1589C6, buf);
    S1589C6 *dp, &lv = *(dp=new (buf) S1589C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1589C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C6)");
    test_class_info(&lv, &cd_S1589C6);
    dp->~S1589C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C6(Test_S1589C6, "S1589C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1589C6C1Ev();
extern void _ZN7S1589C6D1Ev();
Name_Map name_map_S1589C6[] = {
  NSPAIR(_ZN7S1589C6C1Ev),
  NSPAIR(_ZN7S1589C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1589C6[];
extern void _ZN7S1589C63v73Ev();
extern void _ZN7S1589C63v74Ev();
extern void _ZN7S1589C63v75Ev();
extern void _ZN7S1589C63v76Ev();
extern void _ZN7S1589C63v77Ev();
extern void _ZN7S1589C63v78Ev();
extern void _ZN7S1589C63v79Ev();
extern void _ZN7S1589C63v80Ev();
extern void _ZN7S1589C63v81Ev();
extern void _ZN7S1589C63v82Ev();
extern void _ZN7S1589C63v83Ev();
extern void _ZN7S1589C63v84Ev();
extern void _ZN7S1589C63v85Ev();
extern void _ZN7S1589C63v86Ev();
extern void _ZN7S1589C63v87Ev();
extern void _ZN7S1589C63v88Ev();
static  VTBL_ENTRY vtc_S1589C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C6[0]),
  (VTBL_ENTRY)&_ZN7S1589C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v88Ev,
};
extern VTBL_ENTRY _ZTI7S1589C6[];
extern  VTBL_ENTRY _ZTV7S1589C6[];
Class_Descriptor cd_S1589C6 = {  "S1589C6", // class name
  0,0,//no base classes
  &(vtc_S1589C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1589C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1589C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C7  {
  virtual void  v89(); // _ZN7S1589C73v89Ev
  virtual void  v90(); // _ZN7S1589C73v90Ev
  virtual void  v91(); // _ZN7S1589C73v91Ev
  virtual void  v92(); // _ZN7S1589C73v92Ev
  virtual void  v93(); // _ZN7S1589C73v93Ev
  virtual void  v94(); // _ZN7S1589C73v94Ev
  virtual void  v95(); // _ZN7S1589C73v95Ev
  virtual void  v96(); // _ZN7S1589C73v96Ev
  virtual void  v97(); // _ZN7S1589C73v97Ev
  ~S1589C7(); // tgen
  S1589C7(); // tgen
};
//SIG(-1 S1589C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1589C7 ::v89(){vfunc_called(this, "_ZN7S1589C73v89Ev");}
void  S1589C7 ::v90(){vfunc_called(this, "_ZN7S1589C73v90Ev");}
void  S1589C7 ::v91(){vfunc_called(this, "_ZN7S1589C73v91Ev");}
void  S1589C7 ::v92(){vfunc_called(this, "_ZN7S1589C73v92Ev");}
void  S1589C7 ::v93(){vfunc_called(this, "_ZN7S1589C73v93Ev");}
void  S1589C7 ::v94(){vfunc_called(this, "_ZN7S1589C73v94Ev");}
void  S1589C7 ::v95(){vfunc_called(this, "_ZN7S1589C73v95Ev");}
void  S1589C7 ::v96(){vfunc_called(this, "_ZN7S1589C73v96Ev");}
void  S1589C7 ::v97(){vfunc_called(this, "_ZN7S1589C73v97Ev");}
S1589C7 ::~S1589C7(){ note_dtor("S1589C7", this);} // tgen
S1589C7 ::S1589C7(){ note_ctor("S1589C7", this);} // tgen

static void Test_S1589C7()
{
  extern Class_Descriptor cd_S1589C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1589C7, buf);
    S1589C7 *dp, &lv = *(dp=new (buf) S1589C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1589C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C7)");
    test_class_info(&lv, &cd_S1589C7);
    dp->~S1589C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C7(Test_S1589C7, "S1589C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1589C7C1Ev();
extern void _ZN7S1589C7D1Ev();
Name_Map name_map_S1589C7[] = {
  NSPAIR(_ZN7S1589C7C1Ev),
  NSPAIR(_ZN7S1589C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1589C7[];
extern void _ZN7S1589C73v89Ev();
extern void _ZN7S1589C73v90Ev();
extern void _ZN7S1589C73v91Ev();
extern void _ZN7S1589C73v92Ev();
extern void _ZN7S1589C73v93Ev();
extern void _ZN7S1589C73v94Ev();
extern void _ZN7S1589C73v95Ev();
extern void _ZN7S1589C73v96Ev();
extern void _ZN7S1589C73v97Ev();
static  VTBL_ENTRY vtc_S1589C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C7[0]),
  (VTBL_ENTRY)&_ZN7S1589C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1589C7[];
extern  VTBL_ENTRY _ZTV7S1589C7[];
Class_Descriptor cd_S1589C7 = {  "S1589C7", // class name
  0,0,//no base classes
  &(vtc_S1589C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1589C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1589C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C3  : S1589C4 , S1589C6 , S1589C7 {
  void *s1589c3f0;
  ::S79C39_nt s1589c3f1;
  unsigned int s1589c3f2:1;
  unsigned int s1589c3f3:1;
  unsigned int s1589c3f4:1;
  unsigned int s1589c3f5:1;
  virtual  ~S1589C3(); // _ZN7S1589C3D1Ev
  virtual void  v98(); // _ZN7S1589C33v98Ev
  virtual void  v99(); // _ZN7S1589C33v99Ev
  virtual void  v100(); // _ZN7S1589C34v100Ev
  virtual void  v101(); // _ZN7S1589C34v101Ev
  virtual void  v102(); // _ZN7S1589C34v102Ev
  virtual void  v103(); // _ZN7S1589C34v103Ev
  virtual void  v104(); // _ZN7S1589C34v104Ev
  virtual void  v105(); // _ZN7S1589C34v105Ev
  virtual void  v106(); // _ZN7S1589C34v106Ev
  virtual void  v107(); // _ZN7S1589C34v107Ev
  virtual void  v108(); // _ZN7S1589C34v108Ev
  virtual void  v109(); // _ZN7S1589C34v109Ev
  virtual void  v110(); // _ZN7S1589C34v110Ev
  virtual void  v111(); // _ZN7S1589C34v111Ev
  virtual void  v112(); // _ZN7S1589C34v112Ev
  virtual void  v113(); // _ZN7S1589C34v113Ev
  virtual void  v114(); // _ZN7S1589C34v114Ev
  virtual void  v115(); // _ZN7S1589C34v115Ev
  virtual void  v116(); // _ZN7S1589C34v116Ev
  virtual void  v117(); // _ZN7S1589C34v117Ev
  virtual void  v118(); // _ZN7S1589C34v118Ev
  virtual void  v119(); // _ZN7S1589C34v119Ev
  virtual void  v120(); // _ZN7S1589C34v120Ev
  virtual void  v121(); // _ZN7S1589C34v121Ev
  S1589C3(); // tgen
};
//SIG(-1 S1589C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1589C3 ::~S1589C3(){ note_dtor("S1589C3", this);}
void  S1589C3 ::v98(){vfunc_called(this, "_ZN7S1589C33v98Ev");}
void  S1589C3 ::v99(){vfunc_called(this, "_ZN7S1589C33v99Ev");}
void  S1589C3 ::v100(){vfunc_called(this, "_ZN7S1589C34v100Ev");}
void  S1589C3 ::v101(){vfunc_called(this, "_ZN7S1589C34v101Ev");}
void  S1589C3 ::v102(){vfunc_called(this, "_ZN7S1589C34v102Ev");}
void  S1589C3 ::v103(){vfunc_called(this, "_ZN7S1589C34v103Ev");}
void  S1589C3 ::v104(){vfunc_called(this, "_ZN7S1589C34v104Ev");}
void  S1589C3 ::v105(){vfunc_called(this, "_ZN7S1589C34v105Ev");}
void  S1589C3 ::v106(){vfunc_called(this, "_ZN7S1589C34v106Ev");}
void  S1589C3 ::v107(){vfunc_called(this, "_ZN7S1589C34v107Ev");}
void  S1589C3 ::v108(){vfunc_called(this, "_ZN7S1589C34v108Ev");}
void  S1589C3 ::v109(){vfunc_called(this, "_ZN7S1589C34v109Ev");}
void  S1589C3 ::v110(){vfunc_called(this, "_ZN7S1589C34v110Ev");}
void  S1589C3 ::v111(){vfunc_called(this, "_ZN7S1589C34v111Ev");}
void  S1589C3 ::v112(){vfunc_called(this, "_ZN7S1589C34v112Ev");}
void  S1589C3 ::v113(){vfunc_called(this, "_ZN7S1589C34v113Ev");}
void  S1589C3 ::v114(){vfunc_called(this, "_ZN7S1589C34v114Ev");}
void  S1589C3 ::v115(){vfunc_called(this, "_ZN7S1589C34v115Ev");}
void  S1589C3 ::v116(){vfunc_called(this, "_ZN7S1589C34v116Ev");}
void  S1589C3 ::v117(){vfunc_called(this, "_ZN7S1589C34v117Ev");}
void  S1589C3 ::v118(){vfunc_called(this, "_ZN7S1589C34v118Ev");}
void  S1589C3 ::v119(){vfunc_called(this, "_ZN7S1589C34v119Ev");}
void  S1589C3 ::v120(){vfunc_called(this, "_ZN7S1589C34v120Ev");}
void  S1589C3 ::v121(){vfunc_called(this, "_ZN7S1589C34v121Ev");}
S1589C3 ::S1589C3(){ note_ctor("S1589C3", this);} // tgen

static void Test_S1589C3()
{
  extern Class_Descriptor cd_S1589C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1589C3, buf);
    S1589C3 *dp, &lv = *(dp=new (buf) S1589C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1589C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C3)");
    check_base_class_offset(lv, (S1589C4*), 0, "S1589C3");
    check_base_class_offset(lv, (S1589C6*), ABISELECT(96,60), "S1589C3");
    check_base_class_offset(lv, (S1589C7*), ABISELECT(104,64), "S1589C3");
    check_field_offset(lv, s1589c3f0, ABISELECT(112,68), "S1589C3.s1589c3f0");
    check_field_offset(lv, s1589c3f1, ABISELECT(120,72), "S1589C3.s1589c3f1");
    set_bf_and_test(lv, s1589c3f2, ABISELECT(136,84), 0, 1, 1, "S1589C3");
    set_bf_and_test(lv, s1589c3f3, ABISELECT(136,84), 1, 1, 1, "S1589C3");
    set_bf_and_test(lv, s1589c3f4, ABISELECT(136,84), 2, 1, 1, "S1589C3");
    set_bf_and_test(lv, s1589c3f5, ABISELECT(136,84), 3, 1, 1, "S1589C3");
    test_class_info(&lv, &cd_S1589C3);
    dp->~S1589C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C3(Test_S1589C3, "S1589C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1589C3C1Ev();
extern void _ZN7S1589C3D1Ev();
Name_Map name_map_S1589C3[] = {
  NSPAIR(_ZN7S1589C3C1Ev),
  NSPAIR(_ZN7S1589C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1589C4;
extern VTBL_ENTRY _ZTI7S1589C4[];
extern  VTBL_ENTRY _ZTV7S1589C4[];
extern Class_Descriptor cd_S1589C6;
extern VTBL_ENTRY _ZTI7S1589C6[];
extern  VTBL_ENTRY _ZTV7S1589C6[];
extern Class_Descriptor cd_S1589C7;
extern VTBL_ENTRY _ZTI7S1589C7[];
extern  VTBL_ENTRY _ZTV7S1589C7[];
static Base_Class bases_S1589C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1589C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1589C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1589C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1589C3[];
extern void _ZN7S1589C3D1Ev();
extern void _ZN7S1589C3D0Ev();
extern void _ZN7S1589C42v9Ev();
extern void _ZN7S1589C43v10Ev();
extern void _ZN7S1589C43v11Ev();
extern void _ZN7S1589C43v12Ev();
extern void _ZN7S1589C43v13Ev();
extern void _ZN7S1589C43v14Ev();
extern void _ZN7S1589C43v15Ev();
extern void _ZN7S1589C43v16Ev();
extern void _ZN7S1589C43v17Ev();
extern void _ZN7S1589C43v18Ev();
extern void _ZN7S1589C43v19Ev();
extern void _ZN7S1589C43v20Ev();
extern void _ZN7S1589C43v21Ev();
extern void _ZN7S1589C43v22Ev();
extern void _ZN7S1589C43v23Ev();
extern void _ZN7S1589C43v24Ev();
extern void _ZN7S1589C43v25Ev();
extern void _ZN7S1589C43v26Ev();
extern void _ZN7S1589C43v27Ev();
extern void _ZN7S1589C43v28Ev();
extern void _ZN7S1589C43v29Ev();
extern void _ZN7S1589C43v30Ev();
extern void _ZN7S1589C43v31Ev();
extern void _ZN7S1589C43v32Ev();
extern void _ZN7S1589C43v33Ev();
extern void _ZN7S1589C43v34Ev();
extern void _ZN7S1589C43v35Ev();
extern void _ZN7S1589C43v36Ev();
extern void _ZN7S1589C43v37Ev();
extern void _ZN7S1589C43v38Ev();
extern void _ZN7S1589C43v39Ev();
extern void _ZN7S1589C43v40Ev();
extern void _ZN7S1589C43v41Ev();
extern void _ZN7S1589C43v42Ev();
extern void _ZN7S1589C43v43Ev();
extern void _ZN7S1589C43v44Ev();
extern void _ZN7S1589C43v45Ev();
extern void _ZN7S1589C43v46Ev();
extern void _ZN7S1589C43v47Ev();
extern void _ZN7S1589C43v48Ev();
extern void _ZN7S1589C43v49Ev();
extern void _ZN7S1589C43v50Ev();
extern void _ZN7S1589C43v51Ev();
extern void _ZN7S1589C43v52Ev();
extern void _ZN7S1589C43v53Ev();
extern void _ZN7S1589C43v54Ev();
extern void _ZN7S1589C43v55Ev();
extern void _ZN7S1589C43v56Ev();
extern void _ZN7S1589C43v57Ev();
extern void _ZN7S1589C43v58Ev();
extern void _ZN7S1589C43v59Ev();
extern void _ZN7S1589C43v60Ev();
extern void _ZN7S1589C43v61Ev();
extern void _ZN7S1589C43v62Ev();
extern void _ZN7S1589C43v63Ev();
extern void _ZN7S1589C43v64Ev();
extern void _ZN7S1589C43v65Ev();
extern void _ZN7S1589C43v66Ev();
extern void _ZN7S1589C43v67Ev();
extern void _ZN7S1589C43v68Ev();
extern void _ZN7S1589C43v69Ev();
extern void _ZN7S1589C43v70Ev();
extern void _ZN7S1589C43v71Ev();
extern void _ZN7S1589C43v72Ev();
extern void _ZN7S1589C33v98Ev();
extern void _ZN7S1589C33v99Ev();
extern void _ZN7S1589C34v100Ev();
extern void _ZN7S1589C34v101Ev();
extern void _ZN7S1589C34v102Ev();
extern void _ZN7S1589C34v103Ev();
extern void _ZN7S1589C34v104Ev();
extern void _ZN7S1589C34v105Ev();
extern void _ZN7S1589C34v106Ev();
extern void _ZN7S1589C34v107Ev();
extern void _ZN7S1589C34v108Ev();
extern void _ZN7S1589C34v109Ev();
extern void _ZN7S1589C34v110Ev();
extern void _ZN7S1589C34v111Ev();
extern void _ZN7S1589C34v112Ev();
extern void _ZN7S1589C34v113Ev();
extern void _ZN7S1589C34v114Ev();
extern void _ZN7S1589C34v115Ev();
extern void _ZN7S1589C34v116Ev();
extern void _ZN7S1589C34v117Ev();
extern void _ZN7S1589C34v118Ev();
extern void _ZN7S1589C34v119Ev();
extern void _ZN7S1589C34v120Ev();
extern void _ZN7S1589C34v121Ev();
extern void _ZN7S1589C63v73Ev();
extern void _ZN7S1589C63v74Ev();
extern void _ZN7S1589C63v75Ev();
extern void _ZN7S1589C63v76Ev();
extern void _ZN7S1589C63v77Ev();
extern void _ZN7S1589C63v78Ev();
extern void _ZN7S1589C63v79Ev();
extern void _ZN7S1589C63v80Ev();
extern void _ZN7S1589C63v81Ev();
extern void _ZN7S1589C63v82Ev();
extern void _ZN7S1589C63v83Ev();
extern void _ZN7S1589C63v84Ev();
extern void _ZN7S1589C63v85Ev();
extern void _ZN7S1589C63v86Ev();
extern void _ZN7S1589C63v87Ev();
extern void _ZN7S1589C63v88Ev();
extern void _ZN7S1589C73v89Ev();
extern void _ZN7S1589C73v90Ev();
extern void _ZN7S1589C73v91Ev();
extern void _ZN7S1589C73v92Ev();
extern void _ZN7S1589C73v93Ev();
extern void _ZN7S1589C73v94Ev();
extern void _ZN7S1589C73v95Ev();
extern void _ZN7S1589C73v96Ev();
extern void _ZN7S1589C73v97Ev();
static  VTBL_ENTRY vtc_S1589C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C3[0]),
  (VTBL_ENTRY)&_ZN7S1589C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1589C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1589C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v121Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1589C3[0]),
  (VTBL_ENTRY)&_ZN7S1589C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1589C3[0]),
  (VTBL_ENTRY)&_ZN7S1589C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1589C3[];
extern  VTBL_ENTRY _ZTV7S1589C3[];
Class_Descriptor cd_S1589C3 = {  "S1589C3", // class name
  bases_S1589C3, 3,
  &(vtc_S1589C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1589C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1589C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C2  : S1589C3 {
  ::S3262C11_nt s1589c2f0;
  int s1589c2f1;
  virtual  ~S1589C2(); // _ZN7S1589C2D1Ev
  virtual void  v122(); // _ZN7S1589C24v122Ev
  virtual void  v123(); // _ZN7S1589C24v123Ev
  virtual void  v124(); // _ZN7S1589C24v124Ev
  virtual void  v125(); // _ZN7S1589C24v125Ev
  virtual void  v126(); // _ZN7S1589C24v126Ev
  virtual void  v127(); // _ZN7S1589C24v127Ev
  virtual void  v128(); // _ZN7S1589C24v128Ev
  virtual void  v129(); // _ZN7S1589C24v129Ev
  virtual void  v130(); // _ZN7S1589C24v130Ev
  virtual void  v131(); // _ZN7S1589C24v131Ev
  virtual void  v132(); // _ZN7S1589C24v132Ev
  virtual void  v133(); // _ZN7S1589C24v133Ev
  virtual void  v134(); // _ZN7S1589C24v134Ev
  virtual void  v135(); // _ZN7S1589C24v135Ev
  virtual void  v136(); // _ZN7S1589C24v136Ev
  virtual void  v137(); // _ZN7S1589C24v137Ev
  virtual void  v138(); // _ZN7S1589C24v138Ev
  virtual void  v139(); // _ZN7S1589C24v139Ev
  virtual void  v140(); // _ZN7S1589C24v140Ev
  virtual void  v141(); // _ZN7S1589C24v141Ev
  virtual void  v142(); // _ZN7S1589C24v142Ev
  virtual void  v143(); // _ZN7S1589C24v143Ev
  virtual void  v144(); // _ZN7S1589C24v144Ev
  virtual void  v145(); // _ZN7S1589C24v145Ev
  virtual void  v146(); // _ZN7S1589C24v146Ev
  virtual void  v147(); // _ZN7S1589C24v147Ev
  S1589C2(); // tgen
};
//SIG(-1 S1589C2) C1{ BC2{ BC3{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106} BC6{ v107 v108 v109 v110 v111 v112 v113 v114 v115} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1589C2 ::~S1589C2(){ note_dtor("S1589C2", this);}
void  S1589C2 ::v122(){vfunc_called(this, "_ZN7S1589C24v122Ev");}
void  S1589C2 ::v123(){vfunc_called(this, "_ZN7S1589C24v123Ev");}
void  S1589C2 ::v124(){vfunc_called(this, "_ZN7S1589C24v124Ev");}
void  S1589C2 ::v125(){vfunc_called(this, "_ZN7S1589C24v125Ev");}
void  S1589C2 ::v126(){vfunc_called(this, "_ZN7S1589C24v126Ev");}
void  S1589C2 ::v127(){vfunc_called(this, "_ZN7S1589C24v127Ev");}
void  S1589C2 ::v128(){vfunc_called(this, "_ZN7S1589C24v128Ev");}
void  S1589C2 ::v129(){vfunc_called(this, "_ZN7S1589C24v129Ev");}
void  S1589C2 ::v130(){vfunc_called(this, "_ZN7S1589C24v130Ev");}
void  S1589C2 ::v131(){vfunc_called(this, "_ZN7S1589C24v131Ev");}
void  S1589C2 ::v132(){vfunc_called(this, "_ZN7S1589C24v132Ev");}
void  S1589C2 ::v133(){vfunc_called(this, "_ZN7S1589C24v133Ev");}
void  S1589C2 ::v134(){vfunc_called(this, "_ZN7S1589C24v134Ev");}
void  S1589C2 ::v135(){vfunc_called(this, "_ZN7S1589C24v135Ev");}
void  S1589C2 ::v136(){vfunc_called(this, "_ZN7S1589C24v136Ev");}
void  S1589C2 ::v137(){vfunc_called(this, "_ZN7S1589C24v137Ev");}
void  S1589C2 ::v138(){vfunc_called(this, "_ZN7S1589C24v138Ev");}
void  S1589C2 ::v139(){vfunc_called(this, "_ZN7S1589C24v139Ev");}
void  S1589C2 ::v140(){vfunc_called(this, "_ZN7S1589C24v140Ev");}
void  S1589C2 ::v141(){vfunc_called(this, "_ZN7S1589C24v141Ev");}
void  S1589C2 ::v142(){vfunc_called(this, "_ZN7S1589C24v142Ev");}
void  S1589C2 ::v143(){vfunc_called(this, "_ZN7S1589C24v143Ev");}
void  S1589C2 ::v144(){vfunc_called(this, "_ZN7S1589C24v144Ev");}
void  S1589C2 ::v145(){vfunc_called(this, "_ZN7S1589C24v145Ev");}
void  S1589C2 ::v146(){vfunc_called(this, "_ZN7S1589C24v146Ev");}
void  S1589C2 ::v147(){vfunc_called(this, "_ZN7S1589C24v147Ev");}
S1589C2 ::S1589C2(){ note_ctor("S1589C2", this);} // tgen

static void Test_S1589C2()
{
  extern Class_Descriptor cd_S1589C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1589C2, buf);
    S1589C2 *dp, &lv = *(dp=new (buf) S1589C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1589C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C2)");
    check_base_class_offset(lv, (S1589C4*)(S1589C3*), 0, "S1589C2");
    check_base_class_offset(lv, (S1589C6*)(S1589C3*), ABISELECT(96,60), "S1589C2");
    check_base_class_offset(lv, (S1589C7*)(S1589C3*), ABISELECT(104,64), "S1589C2");
    check_base_class_offset(lv, (S1589C3*), 0, "S1589C2");
    check_field_offset(lv, s1589c2f0, ABISELECT(144,88), "S1589C2.s1589c2f0");
    check_field_offset(lv, s1589c2f1, ABISELECT(168,104), "S1589C2.s1589c2f1");
    test_class_info(&lv, &cd_S1589C2);
    dp->~S1589C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C2(Test_S1589C2, "S1589C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1589C2C1Ev();
extern void _ZN7S1589C2D1Ev();
Name_Map name_map_S1589C2[] = {
  NSPAIR(_ZN7S1589C2C1Ev),
  NSPAIR(_ZN7S1589C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1589C4;
extern VTBL_ENTRY _ZTI7S1589C4[];
extern  VTBL_ENTRY _ZTV7S1589C4[];
extern Class_Descriptor cd_S1589C6;
extern VTBL_ENTRY _ZTI7S1589C6[];
extern  VTBL_ENTRY _ZTV7S1589C6[];
extern Class_Descriptor cd_S1589C7;
extern VTBL_ENTRY _ZTI7S1589C7[];
extern  VTBL_ENTRY _ZTV7S1589C7[];
extern Class_Descriptor cd_S1589C3;
extern VTBL_ENTRY _ZTI7S1589C3[];
extern  VTBL_ENTRY _ZTV7S1589C3[];
static Base_Class bases_S1589C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1589C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C6,    ABISELECT(96,60), //bcp->offset
    118, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C7,    ABISELECT(104,64), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1589C2[];
extern void _ZN7S1589C2D1Ev();
extern void _ZN7S1589C2D0Ev();
extern void _ZN7S1589C42v9Ev();
extern void _ZN7S1589C43v10Ev();
extern void _ZN7S1589C43v11Ev();
extern void _ZN7S1589C43v12Ev();
extern void _ZN7S1589C43v13Ev();
extern void _ZN7S1589C43v14Ev();
extern void _ZN7S1589C43v15Ev();
extern void _ZN7S1589C43v16Ev();
extern void _ZN7S1589C43v17Ev();
extern void _ZN7S1589C43v18Ev();
extern void _ZN7S1589C43v19Ev();
extern void _ZN7S1589C43v20Ev();
extern void _ZN7S1589C43v21Ev();
extern void _ZN7S1589C43v22Ev();
extern void _ZN7S1589C43v23Ev();
extern void _ZN7S1589C43v24Ev();
extern void _ZN7S1589C43v25Ev();
extern void _ZN7S1589C43v26Ev();
extern void _ZN7S1589C43v27Ev();
extern void _ZN7S1589C43v28Ev();
extern void _ZN7S1589C43v29Ev();
extern void _ZN7S1589C43v30Ev();
extern void _ZN7S1589C43v31Ev();
extern void _ZN7S1589C43v32Ev();
extern void _ZN7S1589C43v33Ev();
extern void _ZN7S1589C43v34Ev();
extern void _ZN7S1589C43v35Ev();
extern void _ZN7S1589C43v36Ev();
extern void _ZN7S1589C43v37Ev();
extern void _ZN7S1589C43v38Ev();
extern void _ZN7S1589C43v39Ev();
extern void _ZN7S1589C43v40Ev();
extern void _ZN7S1589C43v41Ev();
extern void _ZN7S1589C43v42Ev();
extern void _ZN7S1589C43v43Ev();
extern void _ZN7S1589C43v44Ev();
extern void _ZN7S1589C43v45Ev();
extern void _ZN7S1589C43v46Ev();
extern void _ZN7S1589C43v47Ev();
extern void _ZN7S1589C43v48Ev();
extern void _ZN7S1589C43v49Ev();
extern void _ZN7S1589C43v50Ev();
extern void _ZN7S1589C43v51Ev();
extern void _ZN7S1589C43v52Ev();
extern void _ZN7S1589C43v53Ev();
extern void _ZN7S1589C43v54Ev();
extern void _ZN7S1589C43v55Ev();
extern void _ZN7S1589C43v56Ev();
extern void _ZN7S1589C43v57Ev();
extern void _ZN7S1589C43v58Ev();
extern void _ZN7S1589C43v59Ev();
extern void _ZN7S1589C43v60Ev();
extern void _ZN7S1589C43v61Ev();
extern void _ZN7S1589C43v62Ev();
extern void _ZN7S1589C43v63Ev();
extern void _ZN7S1589C43v64Ev();
extern void _ZN7S1589C43v65Ev();
extern void _ZN7S1589C43v66Ev();
extern void _ZN7S1589C43v67Ev();
extern void _ZN7S1589C43v68Ev();
extern void _ZN7S1589C43v69Ev();
extern void _ZN7S1589C43v70Ev();
extern void _ZN7S1589C43v71Ev();
extern void _ZN7S1589C43v72Ev();
extern void _ZN7S1589C33v98Ev();
extern void _ZN7S1589C33v99Ev();
extern void _ZN7S1589C34v100Ev();
extern void _ZN7S1589C34v101Ev();
extern void _ZN7S1589C34v102Ev();
extern void _ZN7S1589C34v103Ev();
extern void _ZN7S1589C34v104Ev();
extern void _ZN7S1589C34v105Ev();
extern void _ZN7S1589C34v106Ev();
extern void _ZN7S1589C34v107Ev();
extern void _ZN7S1589C34v108Ev();
extern void _ZN7S1589C34v109Ev();
extern void _ZN7S1589C34v110Ev();
extern void _ZN7S1589C34v111Ev();
extern void _ZN7S1589C34v112Ev();
extern void _ZN7S1589C34v113Ev();
extern void _ZN7S1589C34v114Ev();
extern void _ZN7S1589C34v115Ev();
extern void _ZN7S1589C34v116Ev();
extern void _ZN7S1589C34v117Ev();
extern void _ZN7S1589C34v118Ev();
extern void _ZN7S1589C34v119Ev();
extern void _ZN7S1589C34v120Ev();
extern void _ZN7S1589C34v121Ev();
extern void _ZN7S1589C24v122Ev();
extern void _ZN7S1589C24v123Ev();
extern void _ZN7S1589C24v124Ev();
extern void _ZN7S1589C24v125Ev();
extern void _ZN7S1589C24v126Ev();
extern void _ZN7S1589C24v127Ev();
extern void _ZN7S1589C24v128Ev();
extern void _ZN7S1589C24v129Ev();
extern void _ZN7S1589C24v130Ev();
extern void _ZN7S1589C24v131Ev();
extern void _ZN7S1589C24v132Ev();
extern void _ZN7S1589C24v133Ev();
extern void _ZN7S1589C24v134Ev();
extern void _ZN7S1589C24v135Ev();
extern void _ZN7S1589C24v136Ev();
extern void _ZN7S1589C24v137Ev();
extern void _ZN7S1589C24v138Ev();
extern void _ZN7S1589C24v139Ev();
extern void _ZN7S1589C24v140Ev();
extern void _ZN7S1589C24v141Ev();
extern void _ZN7S1589C24v142Ev();
extern void _ZN7S1589C24v143Ev();
extern void _ZN7S1589C24v144Ev();
extern void _ZN7S1589C24v145Ev();
extern void _ZN7S1589C24v146Ev();
extern void _ZN7S1589C24v147Ev();
extern void _ZN7S1589C63v73Ev();
extern void _ZN7S1589C63v74Ev();
extern void _ZN7S1589C63v75Ev();
extern void _ZN7S1589C63v76Ev();
extern void _ZN7S1589C63v77Ev();
extern void _ZN7S1589C63v78Ev();
extern void _ZN7S1589C63v79Ev();
extern void _ZN7S1589C63v80Ev();
extern void _ZN7S1589C63v81Ev();
extern void _ZN7S1589C63v82Ev();
extern void _ZN7S1589C63v83Ev();
extern void _ZN7S1589C63v84Ev();
extern void _ZN7S1589C63v85Ev();
extern void _ZN7S1589C63v86Ev();
extern void _ZN7S1589C63v87Ev();
extern void _ZN7S1589C63v88Ev();
extern void _ZN7S1589C73v89Ev();
extern void _ZN7S1589C73v90Ev();
extern void _ZN7S1589C73v91Ev();
extern void _ZN7S1589C73v92Ev();
extern void _ZN7S1589C73v93Ev();
extern void _ZN7S1589C73v94Ev();
extern void _ZN7S1589C73v95Ev();
extern void _ZN7S1589C73v96Ev();
extern void _ZN7S1589C73v97Ev();
static  VTBL_ENTRY vtc_S1589C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C2[0]),
  (VTBL_ENTRY)&_ZN7S1589C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1589C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1589C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v147Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1589C2[0]),
  (VTBL_ENTRY)&_ZN7S1589C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1589C2[0]),
  (VTBL_ENTRY)&_ZN7S1589C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1589C2[];
extern  VTBL_ENTRY _ZTV7S1589C2[];
Class_Descriptor cd_S1589C2 = {  "S1589C2", // class name
  bases_S1589C2, 4,
  &(vtc_S1589C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1589C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1589C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1589C1  : S1589C2 {
  virtual  ~S1589C1(); // _ZN7S1589C1D1Ev
  virtual void  v1(); // _ZN7S1589C12v1Ev
  virtual void  v2(); // _ZN7S1589C12v2Ev
  virtual void  v3(); // _ZN7S1589C12v3Ev
  virtual void  v4(); // _ZN7S1589C12v4Ev
  virtual void  v5(); // _ZN7S1589C12v5Ev
  virtual void  v6(); // _ZN7S1589C12v6Ev
  virtual void  v7(); // _ZN7S1589C12v7Ev
  virtual void  v8(); // _ZN7S1589C12v8Ev
  S1589C1(); // tgen
};
//SIG(1 S1589C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88} BC7{ v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S1589C1 ::~S1589C1(){ note_dtor("S1589C1", this);}
void  S1589C1 ::v1(){vfunc_called(this, "_ZN7S1589C12v1Ev");}
void  S1589C1 ::v2(){vfunc_called(this, "_ZN7S1589C12v2Ev");}
void  S1589C1 ::v3(){vfunc_called(this, "_ZN7S1589C12v3Ev");}
void  S1589C1 ::v4(){vfunc_called(this, "_ZN7S1589C12v4Ev");}
void  S1589C1 ::v5(){vfunc_called(this, "_ZN7S1589C12v5Ev");}
void  S1589C1 ::v6(){vfunc_called(this, "_ZN7S1589C12v6Ev");}
void  S1589C1 ::v7(){vfunc_called(this, "_ZN7S1589C12v7Ev");}
void  S1589C1 ::v8(){vfunc_called(this, "_ZN7S1589C12v8Ev");}
S1589C1 ::S1589C1(){ note_ctor("S1589C1", this);} // tgen

static void Test_S1589C1()
{
  extern Class_Descriptor cd_S1589C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1589C1, buf);
    S1589C1 *dp, &lv = *(dp=new (buf) S1589C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1589C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1589C1)");
    check_base_class_offset(lv, (S1589C4*)(S1589C3*)(S1589C2*), 0, "S1589C1");
    check_base_class_offset(lv, (S1589C6*)(S1589C3*)(S1589C2*), ABISELECT(96,60), "S1589C1");
    check_base_class_offset(lv, (S1589C7*)(S1589C3*)(S1589C2*), ABISELECT(104,64), "S1589C1");
    check_base_class_offset(lv, (S1589C3*)(S1589C2*), 0, "S1589C1");
    check_base_class_offset(lv, (S1589C2*), 0, "S1589C1");
    test_class_info(&lv, &cd_S1589C1);
    dp->~S1589C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1589C1(Test_S1589C1, "S1589C1", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1589C1C1Ev();
extern void _ZN7S1589C1D1Ev();
Name_Map name_map_S1589C1[] = {
  NSPAIR(_ZN7S1589C1C1Ev),
  NSPAIR(_ZN7S1589C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1589C4;
extern VTBL_ENTRY _ZTI7S1589C4[];
extern  VTBL_ENTRY _ZTV7S1589C4[];
extern Class_Descriptor cd_S1589C6;
extern VTBL_ENTRY _ZTI7S1589C6[];
extern  VTBL_ENTRY _ZTV7S1589C6[];
extern Class_Descriptor cd_S1589C7;
extern VTBL_ENTRY _ZTI7S1589C7[];
extern  VTBL_ENTRY _ZTV7S1589C7[];
extern Class_Descriptor cd_S1589C3;
extern VTBL_ENTRY _ZTI7S1589C3[];
extern  VTBL_ENTRY _ZTV7S1589C3[];
extern Class_Descriptor cd_S1589C2;
extern VTBL_ENTRY _ZTI7S1589C2[];
extern  VTBL_ENTRY _ZTV7S1589C2[];
static Base_Class bases_S1589C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1589C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C6,    ABISELECT(96,60), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C7,    ABISELECT(104,64), //bcp->offset
    144, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1589C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1589C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1589C1[];
extern void _ZN7S1589C1D1Ev();
extern void _ZN7S1589C1D0Ev();
extern void _ZN7S1589C42v9Ev();
extern void _ZN7S1589C43v10Ev();
extern void _ZN7S1589C43v11Ev();
extern void _ZN7S1589C43v12Ev();
extern void _ZN7S1589C43v13Ev();
extern void _ZN7S1589C43v14Ev();
extern void _ZN7S1589C43v15Ev();
extern void _ZN7S1589C43v16Ev();
extern void _ZN7S1589C43v17Ev();
extern void _ZN7S1589C43v18Ev();
extern void _ZN7S1589C43v19Ev();
extern void _ZN7S1589C43v20Ev();
extern void _ZN7S1589C43v21Ev();
extern void _ZN7S1589C43v22Ev();
extern void _ZN7S1589C43v23Ev();
extern void _ZN7S1589C43v24Ev();
extern void _ZN7S1589C43v25Ev();
extern void _ZN7S1589C43v26Ev();
extern void _ZN7S1589C43v27Ev();
extern void _ZN7S1589C43v28Ev();
extern void _ZN7S1589C43v29Ev();
extern void _ZN7S1589C43v30Ev();
extern void _ZN7S1589C43v31Ev();
extern void _ZN7S1589C43v32Ev();
extern void _ZN7S1589C43v33Ev();
extern void _ZN7S1589C43v34Ev();
extern void _ZN7S1589C43v35Ev();
extern void _ZN7S1589C43v36Ev();
extern void _ZN7S1589C43v37Ev();
extern void _ZN7S1589C43v38Ev();
extern void _ZN7S1589C43v39Ev();
extern void _ZN7S1589C43v40Ev();
extern void _ZN7S1589C43v41Ev();
extern void _ZN7S1589C43v42Ev();
extern void _ZN7S1589C43v43Ev();
extern void _ZN7S1589C43v44Ev();
extern void _ZN7S1589C43v45Ev();
extern void _ZN7S1589C43v46Ev();
extern void _ZN7S1589C43v47Ev();
extern void _ZN7S1589C43v48Ev();
extern void _ZN7S1589C43v49Ev();
extern void _ZN7S1589C43v50Ev();
extern void _ZN7S1589C43v51Ev();
extern void _ZN7S1589C43v52Ev();
extern void _ZN7S1589C43v53Ev();
extern void _ZN7S1589C43v54Ev();
extern void _ZN7S1589C43v55Ev();
extern void _ZN7S1589C43v56Ev();
extern void _ZN7S1589C43v57Ev();
extern void _ZN7S1589C43v58Ev();
extern void _ZN7S1589C43v59Ev();
extern void _ZN7S1589C43v60Ev();
extern void _ZN7S1589C43v61Ev();
extern void _ZN7S1589C43v62Ev();
extern void _ZN7S1589C43v63Ev();
extern void _ZN7S1589C43v64Ev();
extern void _ZN7S1589C43v65Ev();
extern void _ZN7S1589C43v66Ev();
extern void _ZN7S1589C43v67Ev();
extern void _ZN7S1589C43v68Ev();
extern void _ZN7S1589C43v69Ev();
extern void _ZN7S1589C43v70Ev();
extern void _ZN7S1589C43v71Ev();
extern void _ZN7S1589C43v72Ev();
extern void _ZN7S1589C33v98Ev();
extern void _ZN7S1589C33v99Ev();
extern void _ZN7S1589C34v100Ev();
extern void _ZN7S1589C34v101Ev();
extern void _ZN7S1589C34v102Ev();
extern void _ZN7S1589C34v103Ev();
extern void _ZN7S1589C34v104Ev();
extern void _ZN7S1589C34v105Ev();
extern void _ZN7S1589C34v106Ev();
extern void _ZN7S1589C34v107Ev();
extern void _ZN7S1589C34v108Ev();
extern void _ZN7S1589C34v109Ev();
extern void _ZN7S1589C34v110Ev();
extern void _ZN7S1589C34v111Ev();
extern void _ZN7S1589C34v112Ev();
extern void _ZN7S1589C34v113Ev();
extern void _ZN7S1589C34v114Ev();
extern void _ZN7S1589C34v115Ev();
extern void _ZN7S1589C34v116Ev();
extern void _ZN7S1589C34v117Ev();
extern void _ZN7S1589C34v118Ev();
extern void _ZN7S1589C34v119Ev();
extern void _ZN7S1589C34v120Ev();
extern void _ZN7S1589C34v121Ev();
extern void _ZN7S1589C24v122Ev();
extern void _ZN7S1589C24v123Ev();
extern void _ZN7S1589C24v124Ev();
extern void _ZN7S1589C24v125Ev();
extern void _ZN7S1589C24v126Ev();
extern void _ZN7S1589C24v127Ev();
extern void _ZN7S1589C24v128Ev();
extern void _ZN7S1589C24v129Ev();
extern void _ZN7S1589C24v130Ev();
extern void _ZN7S1589C24v131Ev();
extern void _ZN7S1589C24v132Ev();
extern void _ZN7S1589C24v133Ev();
extern void _ZN7S1589C24v134Ev();
extern void _ZN7S1589C24v135Ev();
extern void _ZN7S1589C24v136Ev();
extern void _ZN7S1589C24v137Ev();
extern void _ZN7S1589C24v138Ev();
extern void _ZN7S1589C24v139Ev();
extern void _ZN7S1589C24v140Ev();
extern void _ZN7S1589C24v141Ev();
extern void _ZN7S1589C24v142Ev();
extern void _ZN7S1589C24v143Ev();
extern void _ZN7S1589C24v144Ev();
extern void _ZN7S1589C24v145Ev();
extern void _ZN7S1589C24v146Ev();
extern void _ZN7S1589C24v147Ev();
extern void _ZN7S1589C12v1Ev();
extern void _ZN7S1589C12v2Ev();
extern void _ZN7S1589C12v3Ev();
extern void _ZN7S1589C12v4Ev();
extern void _ZN7S1589C12v5Ev();
extern void _ZN7S1589C12v6Ev();
extern void _ZN7S1589C12v7Ev();
extern void _ZN7S1589C12v8Ev();
extern void _ZN7S1589C63v73Ev();
extern void _ZN7S1589C63v74Ev();
extern void _ZN7S1589C63v75Ev();
extern void _ZN7S1589C63v76Ev();
extern void _ZN7S1589C63v77Ev();
extern void _ZN7S1589C63v78Ev();
extern void _ZN7S1589C63v79Ev();
extern void _ZN7S1589C63v80Ev();
extern void _ZN7S1589C63v81Ev();
extern void _ZN7S1589C63v82Ev();
extern void _ZN7S1589C63v83Ev();
extern void _ZN7S1589C63v84Ev();
extern void _ZN7S1589C63v85Ev();
extern void _ZN7S1589C63v86Ev();
extern void _ZN7S1589C63v87Ev();
extern void _ZN7S1589C63v88Ev();
extern void _ZN7S1589C73v89Ev();
extern void _ZN7S1589C73v90Ev();
extern void _ZN7S1589C73v91Ev();
extern void _ZN7S1589C73v92Ev();
extern void _ZN7S1589C73v93Ev();
extern void _ZN7S1589C73v94Ev();
extern void _ZN7S1589C73v95Ev();
extern void _ZN7S1589C73v96Ev();
extern void _ZN7S1589C73v97Ev();
static  VTBL_ENTRY vtc_S1589C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1589C1[0]),
  (VTBL_ENTRY)&_ZN7S1589C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1589C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1589C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1589C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1589C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1589C34v121Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1589C24v147Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1589C12v8Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1589C1[0]),
  (VTBL_ENTRY)&_ZN7S1589C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v87Ev,
  (VTBL_ENTRY)&_ZN7S1589C63v88Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1589C1[0]),
  (VTBL_ENTRY)&_ZN7S1589C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v96Ev,
  (VTBL_ENTRY)&_ZN7S1589C73v97Ev,
};
extern VTBL_ENTRY _ZTI7S1589C1[];
extern  VTBL_ENTRY _ZTV7S1589C1[];
Class_Descriptor cd_S1589C1 = {  "S1589C1", // class name
  bases_S1589C1, 5,
  &(vtc_S1589C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1589C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1589C1),155, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C4  {
  int s1565c4f0;
  __tsi64 s1565c4f1;
  void *s1565c4f2[4];
  int s1565c4f3[2];
  void *s1565c4f4;
  ::S79C8_nt s1565c4f5;
  void *s1565c4f6[2];
  virtual  ~S1565C4(); // _ZN7S1565C4D1Ev
  virtual void  v8(); // _ZN7S1565C42v8Ev
  virtual void  v9(); // _ZN7S1565C42v9Ev
  virtual void  v10(); // _ZN7S1565C43v10Ev
  virtual void  v11(); // _ZN7S1565C43v11Ev
  virtual void  v12(); // _ZN7S1565C43v12Ev
  virtual void  v13(); // _ZN7S1565C43v13Ev
  virtual void  v14(); // _ZN7S1565C43v14Ev
  virtual void  v15(); // _ZN7S1565C43v15Ev
  virtual void  v16(); // _ZN7S1565C43v16Ev
  virtual void  v17(); // _ZN7S1565C43v17Ev
  virtual void  v18(); // _ZN7S1565C43v18Ev
  virtual void  v19(); // _ZN7S1565C43v19Ev
  virtual void  v20(); // _ZN7S1565C43v20Ev
  virtual void  v21(); // _ZN7S1565C43v21Ev
  virtual void  v22(); // _ZN7S1565C43v22Ev
  virtual void  v23(); // _ZN7S1565C43v23Ev
  virtual void  v24(); // _ZN7S1565C43v24Ev
  virtual void  v25(); // _ZN7S1565C43v25Ev
  virtual void  v26(); // _ZN7S1565C43v26Ev
  virtual void  v27(); // _ZN7S1565C43v27Ev
  virtual void  v28(); // _ZN7S1565C43v28Ev
  virtual void  v29(); // _ZN7S1565C43v29Ev
  virtual void  v30(); // _ZN7S1565C43v30Ev
  virtual void  v31(); // _ZN7S1565C43v31Ev
  virtual void  v32(); // _ZN7S1565C43v32Ev
  virtual void  v33(); // _ZN7S1565C43v33Ev
  virtual void  v34(); // _ZN7S1565C43v34Ev
  virtual void  v35(); // _ZN7S1565C43v35Ev
  virtual void  v36(); // _ZN7S1565C43v36Ev
  virtual void  v37(); // _ZN7S1565C43v37Ev
  virtual void  v38(); // _ZN7S1565C43v38Ev
  virtual void  v39(); // _ZN7S1565C43v39Ev
  virtual void  v40(); // _ZN7S1565C43v40Ev
  virtual void  v41(); // _ZN7S1565C43v41Ev
  virtual void  v42(); // _ZN7S1565C43v42Ev
  virtual void  v43(); // _ZN7S1565C43v43Ev
  virtual void  v44(); // _ZN7S1565C43v44Ev
  virtual void  v45(); // _ZN7S1565C43v45Ev
  virtual void  v46(); // _ZN7S1565C43v46Ev
  virtual void  v47(); // _ZN7S1565C43v47Ev
  virtual void  v48(); // _ZN7S1565C43v48Ev
  virtual void  v49(); // _ZN7S1565C43v49Ev
  virtual void  v50(); // _ZN7S1565C43v50Ev
  virtual void  v51(); // _ZN7S1565C43v51Ev
  virtual void  v52(); // _ZN7S1565C43v52Ev
  virtual void  v53(); // _ZN7S1565C43v53Ev
  virtual void  v54(); // _ZN7S1565C43v54Ev
  virtual void  v55(); // _ZN7S1565C43v55Ev
  virtual void  v56(); // _ZN7S1565C43v56Ev
  virtual void  v57(); // _ZN7S1565C43v57Ev
  virtual void  v58(); // _ZN7S1565C43v58Ev
  virtual void  v59(); // _ZN7S1565C43v59Ev
  virtual void  v60(); // _ZN7S1565C43v60Ev
  virtual void  v61(); // _ZN7S1565C43v61Ev
  virtual void  v62(); // _ZN7S1565C43v62Ev
  virtual void  v63(); // _ZN7S1565C43v63Ev
  virtual void  v64(); // _ZN7S1565C43v64Ev
  virtual void  v65(); // _ZN7S1565C43v65Ev
  virtual void  v66(); // _ZN7S1565C43v66Ev
  virtual void  v67(); // _ZN7S1565C43v67Ev
  virtual void  v68(); // _ZN7S1565C43v68Ev
  virtual void  v69(); // _ZN7S1565C43v69Ev
  virtual void  v70(); // _ZN7S1565C43v70Ev
  virtual void  v71(); // _ZN7S1565C43v71Ev
  S1565C4(); // tgen
};
//SIG(-1 S1565C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1565C4 ::~S1565C4(){ note_dtor("S1565C4", this);}
void  S1565C4 ::v8(){vfunc_called(this, "_ZN7S1565C42v8Ev");}
void  S1565C4 ::v9(){vfunc_called(this, "_ZN7S1565C42v9Ev");}
void  S1565C4 ::v10(){vfunc_called(this, "_ZN7S1565C43v10Ev");}
void  S1565C4 ::v11(){vfunc_called(this, "_ZN7S1565C43v11Ev");}
void  S1565C4 ::v12(){vfunc_called(this, "_ZN7S1565C43v12Ev");}
void  S1565C4 ::v13(){vfunc_called(this, "_ZN7S1565C43v13Ev");}
void  S1565C4 ::v14(){vfunc_called(this, "_ZN7S1565C43v14Ev");}
void  S1565C4 ::v15(){vfunc_called(this, "_ZN7S1565C43v15Ev");}
void  S1565C4 ::v16(){vfunc_called(this, "_ZN7S1565C43v16Ev");}
void  S1565C4 ::v17(){vfunc_called(this, "_ZN7S1565C43v17Ev");}
void  S1565C4 ::v18(){vfunc_called(this, "_ZN7S1565C43v18Ev");}
void  S1565C4 ::v19(){vfunc_called(this, "_ZN7S1565C43v19Ev");}
void  S1565C4 ::v20(){vfunc_called(this, "_ZN7S1565C43v20Ev");}
void  S1565C4 ::v21(){vfunc_called(this, "_ZN7S1565C43v21Ev");}
void  S1565C4 ::v22(){vfunc_called(this, "_ZN7S1565C43v22Ev");}
void  S1565C4 ::v23(){vfunc_called(this, "_ZN7S1565C43v23Ev");}
void  S1565C4 ::v24(){vfunc_called(this, "_ZN7S1565C43v24Ev");}
void  S1565C4 ::v25(){vfunc_called(this, "_ZN7S1565C43v25Ev");}
void  S1565C4 ::v26(){vfunc_called(this, "_ZN7S1565C43v26Ev");}
void  S1565C4 ::v27(){vfunc_called(this, "_ZN7S1565C43v27Ev");}
void  S1565C4 ::v28(){vfunc_called(this, "_ZN7S1565C43v28Ev");}
void  S1565C4 ::v29(){vfunc_called(this, "_ZN7S1565C43v29Ev");}
void  S1565C4 ::v30(){vfunc_called(this, "_ZN7S1565C43v30Ev");}
void  S1565C4 ::v31(){vfunc_called(this, "_ZN7S1565C43v31Ev");}
void  S1565C4 ::v32(){vfunc_called(this, "_ZN7S1565C43v32Ev");}
void  S1565C4 ::v33(){vfunc_called(this, "_ZN7S1565C43v33Ev");}
void  S1565C4 ::v34(){vfunc_called(this, "_ZN7S1565C43v34Ev");}
void  S1565C4 ::v35(){vfunc_called(this, "_ZN7S1565C43v35Ev");}
void  S1565C4 ::v36(){vfunc_called(this, "_ZN7S1565C43v36Ev");}
void  S1565C4 ::v37(){vfunc_called(this, "_ZN7S1565C43v37Ev");}
void  S1565C4 ::v38(){vfunc_called(this, "_ZN7S1565C43v38Ev");}
void  S1565C4 ::v39(){vfunc_called(this, "_ZN7S1565C43v39Ev");}
void  S1565C4 ::v40(){vfunc_called(this, "_ZN7S1565C43v40Ev");}
void  S1565C4 ::v41(){vfunc_called(this, "_ZN7S1565C43v41Ev");}
void  S1565C4 ::v42(){vfunc_called(this, "_ZN7S1565C43v42Ev");}
void  S1565C4 ::v43(){vfunc_called(this, "_ZN7S1565C43v43Ev");}
void  S1565C4 ::v44(){vfunc_called(this, "_ZN7S1565C43v44Ev");}
void  S1565C4 ::v45(){vfunc_called(this, "_ZN7S1565C43v45Ev");}
void  S1565C4 ::v46(){vfunc_called(this, "_ZN7S1565C43v46Ev");}
void  S1565C4 ::v47(){vfunc_called(this, "_ZN7S1565C43v47Ev");}
void  S1565C4 ::v48(){vfunc_called(this, "_ZN7S1565C43v48Ev");}
void  S1565C4 ::v49(){vfunc_called(this, "_ZN7S1565C43v49Ev");}
void  S1565C4 ::v50(){vfunc_called(this, "_ZN7S1565C43v50Ev");}
void  S1565C4 ::v51(){vfunc_called(this, "_ZN7S1565C43v51Ev");}
void  S1565C4 ::v52(){vfunc_called(this, "_ZN7S1565C43v52Ev");}
void  S1565C4 ::v53(){vfunc_called(this, "_ZN7S1565C43v53Ev");}
void  S1565C4 ::v54(){vfunc_called(this, "_ZN7S1565C43v54Ev");}
void  S1565C4 ::v55(){vfunc_called(this, "_ZN7S1565C43v55Ev");}
void  S1565C4 ::v56(){vfunc_called(this, "_ZN7S1565C43v56Ev");}
void  S1565C4 ::v57(){vfunc_called(this, "_ZN7S1565C43v57Ev");}
void  S1565C4 ::v58(){vfunc_called(this, "_ZN7S1565C43v58Ev");}
void  S1565C4 ::v59(){vfunc_called(this, "_ZN7S1565C43v59Ev");}
void  S1565C4 ::v60(){vfunc_called(this, "_ZN7S1565C43v60Ev");}
void  S1565C4 ::v61(){vfunc_called(this, "_ZN7S1565C43v61Ev");}
void  S1565C4 ::v62(){vfunc_called(this, "_ZN7S1565C43v62Ev");}
void  S1565C4 ::v63(){vfunc_called(this, "_ZN7S1565C43v63Ev");}
void  S1565C4 ::v64(){vfunc_called(this, "_ZN7S1565C43v64Ev");}
void  S1565C4 ::v65(){vfunc_called(this, "_ZN7S1565C43v65Ev");}
void  S1565C4 ::v66(){vfunc_called(this, "_ZN7S1565C43v66Ev");}
void  S1565C4 ::v67(){vfunc_called(this, "_ZN7S1565C43v67Ev");}
void  S1565C4 ::v68(){vfunc_called(this, "_ZN7S1565C43v68Ev");}
void  S1565C4 ::v69(){vfunc_called(this, "_ZN7S1565C43v69Ev");}
void  S1565C4 ::v70(){vfunc_called(this, "_ZN7S1565C43v70Ev");}
void  S1565C4 ::v71(){vfunc_called(this, "_ZN7S1565C43v71Ev");}
S1565C4 ::S1565C4(){ note_ctor("S1565C4", this);} // tgen

static void Test_S1565C4()
{
  extern Class_Descriptor cd_S1565C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1565C4, buf);
    S1565C4 *dp, &lv = *(dp=new (buf) S1565C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1565C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C4)");
    check_field_offset(lv, s1565c4f0, ABISELECT(8,4), "S1565C4.s1565c4f0");
    check_field_offset(lv, s1565c4f1, ABISELECT(16,8), "S1565C4.s1565c4f1");
    check_field_offset(lv, s1565c4f2, ABISELECT(24,16), "S1565C4.s1565c4f2");
    check_field_offset(lv, s1565c4f3, ABISELECT(56,32), "S1565C4.s1565c4f3");
    check_field_offset(lv, s1565c4f4, ABISELECT(64,40), "S1565C4.s1565c4f4");
    check_field_offset(lv, s1565c4f5, ABISELECT(72,44), "S1565C4.s1565c4f5");
    check_field_offset(lv, s1565c4f6, ABISELECT(80,52), "S1565C4.s1565c4f6");
    test_class_info(&lv, &cd_S1565C4);
    dp->~S1565C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C4(Test_S1565C4, "S1565C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1565C4C1Ev();
extern void _ZN7S1565C4D1Ev();
Name_Map name_map_S1565C4[] = {
  NSPAIR(_ZN7S1565C4C1Ev),
  NSPAIR(_ZN7S1565C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1565C4[];
extern void _ZN7S1565C4D1Ev();
extern void _ZN7S1565C4D0Ev();
extern void _ZN7S1565C42v8Ev();
extern void _ZN7S1565C42v9Ev();
extern void _ZN7S1565C43v10Ev();
extern void _ZN7S1565C43v11Ev();
extern void _ZN7S1565C43v12Ev();
extern void _ZN7S1565C43v13Ev();
extern void _ZN7S1565C43v14Ev();
extern void _ZN7S1565C43v15Ev();
extern void _ZN7S1565C43v16Ev();
extern void _ZN7S1565C43v17Ev();
extern void _ZN7S1565C43v18Ev();
extern void _ZN7S1565C43v19Ev();
extern void _ZN7S1565C43v20Ev();
extern void _ZN7S1565C43v21Ev();
extern void _ZN7S1565C43v22Ev();
extern void _ZN7S1565C43v23Ev();
extern void _ZN7S1565C43v24Ev();
extern void _ZN7S1565C43v25Ev();
extern void _ZN7S1565C43v26Ev();
extern void _ZN7S1565C43v27Ev();
extern void _ZN7S1565C43v28Ev();
extern void _ZN7S1565C43v29Ev();
extern void _ZN7S1565C43v30Ev();
extern void _ZN7S1565C43v31Ev();
extern void _ZN7S1565C43v32Ev();
extern void _ZN7S1565C43v33Ev();
extern void _ZN7S1565C43v34Ev();
extern void _ZN7S1565C43v35Ev();
extern void _ZN7S1565C43v36Ev();
extern void _ZN7S1565C43v37Ev();
extern void _ZN7S1565C43v38Ev();
extern void _ZN7S1565C43v39Ev();
extern void _ZN7S1565C43v40Ev();
extern void _ZN7S1565C43v41Ev();
extern void _ZN7S1565C43v42Ev();
extern void _ZN7S1565C43v43Ev();
extern void _ZN7S1565C43v44Ev();
extern void _ZN7S1565C43v45Ev();
extern void _ZN7S1565C43v46Ev();
extern void _ZN7S1565C43v47Ev();
extern void _ZN7S1565C43v48Ev();
extern void _ZN7S1565C43v49Ev();
extern void _ZN7S1565C43v50Ev();
extern void _ZN7S1565C43v51Ev();
extern void _ZN7S1565C43v52Ev();
extern void _ZN7S1565C43v53Ev();
extern void _ZN7S1565C43v54Ev();
extern void _ZN7S1565C43v55Ev();
extern void _ZN7S1565C43v56Ev();
extern void _ZN7S1565C43v57Ev();
extern void _ZN7S1565C43v58Ev();
extern void _ZN7S1565C43v59Ev();
extern void _ZN7S1565C43v60Ev();
extern void _ZN7S1565C43v61Ev();
extern void _ZN7S1565C43v62Ev();
extern void _ZN7S1565C43v63Ev();
extern void _ZN7S1565C43v64Ev();
extern void _ZN7S1565C43v65Ev();
extern void _ZN7S1565C43v66Ev();
extern void _ZN7S1565C43v67Ev();
extern void _ZN7S1565C43v68Ev();
extern void _ZN7S1565C43v69Ev();
extern void _ZN7S1565C43v70Ev();
extern void _ZN7S1565C43v71Ev();
static  VTBL_ENTRY vtc_S1565C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C4[0]),
  (VTBL_ENTRY)&_ZN7S1565C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1565C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1565C4[];
extern  VTBL_ENTRY _ZTV7S1565C4[];
Class_Descriptor cd_S1565C4 = {  "S1565C4", // class name
  0,0,//no base classes
  &(vtc_S1565C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1565C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1565C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C6  {
  virtual void  v72(); // _ZN7S1565C63v72Ev
  virtual void  v73(); // _ZN7S1565C63v73Ev
  virtual void  v74(); // _ZN7S1565C63v74Ev
  virtual void  v75(); // _ZN7S1565C63v75Ev
  virtual void  v76(); // _ZN7S1565C63v76Ev
  virtual void  v77(); // _ZN7S1565C63v77Ev
  virtual void  v78(); // _ZN7S1565C63v78Ev
  virtual void  v79(); // _ZN7S1565C63v79Ev
  virtual void  v80(); // _ZN7S1565C63v80Ev
  virtual void  v81(); // _ZN7S1565C63v81Ev
  virtual void  v82(); // _ZN7S1565C63v82Ev
  virtual void  v83(); // _ZN7S1565C63v83Ev
  virtual void  v84(); // _ZN7S1565C63v84Ev
  virtual void  v85(); // _ZN7S1565C63v85Ev
  virtual void  v86(); // _ZN7S1565C63v86Ev
  virtual void  v87(); // _ZN7S1565C63v87Ev
  ~S1565C6(); // tgen
  S1565C6(); // tgen
};
//SIG(-1 S1565C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1565C6 ::v72(){vfunc_called(this, "_ZN7S1565C63v72Ev");}
void  S1565C6 ::v73(){vfunc_called(this, "_ZN7S1565C63v73Ev");}
void  S1565C6 ::v74(){vfunc_called(this, "_ZN7S1565C63v74Ev");}
void  S1565C6 ::v75(){vfunc_called(this, "_ZN7S1565C63v75Ev");}
void  S1565C6 ::v76(){vfunc_called(this, "_ZN7S1565C63v76Ev");}
void  S1565C6 ::v77(){vfunc_called(this, "_ZN7S1565C63v77Ev");}
void  S1565C6 ::v78(){vfunc_called(this, "_ZN7S1565C63v78Ev");}
void  S1565C6 ::v79(){vfunc_called(this, "_ZN7S1565C63v79Ev");}
void  S1565C6 ::v80(){vfunc_called(this, "_ZN7S1565C63v80Ev");}
void  S1565C6 ::v81(){vfunc_called(this, "_ZN7S1565C63v81Ev");}
void  S1565C6 ::v82(){vfunc_called(this, "_ZN7S1565C63v82Ev");}
void  S1565C6 ::v83(){vfunc_called(this, "_ZN7S1565C63v83Ev");}
void  S1565C6 ::v84(){vfunc_called(this, "_ZN7S1565C63v84Ev");}
void  S1565C6 ::v85(){vfunc_called(this, "_ZN7S1565C63v85Ev");}
void  S1565C6 ::v86(){vfunc_called(this, "_ZN7S1565C63v86Ev");}
void  S1565C6 ::v87(){vfunc_called(this, "_ZN7S1565C63v87Ev");}
S1565C6 ::~S1565C6(){ note_dtor("S1565C6", this);} // tgen
S1565C6 ::S1565C6(){ note_ctor("S1565C6", this);} // tgen

static void Test_S1565C6()
{
  extern Class_Descriptor cd_S1565C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1565C6, buf);
    S1565C6 *dp, &lv = *(dp=new (buf) S1565C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1565C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C6)");
    test_class_info(&lv, &cd_S1565C6);
    dp->~S1565C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C6(Test_S1565C6, "S1565C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1565C6C1Ev();
extern void _ZN7S1565C6D1Ev();
Name_Map name_map_S1565C6[] = {
  NSPAIR(_ZN7S1565C6C1Ev),
  NSPAIR(_ZN7S1565C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1565C6[];
extern void _ZN7S1565C63v72Ev();
extern void _ZN7S1565C63v73Ev();
extern void _ZN7S1565C63v74Ev();
extern void _ZN7S1565C63v75Ev();
extern void _ZN7S1565C63v76Ev();
extern void _ZN7S1565C63v77Ev();
extern void _ZN7S1565C63v78Ev();
extern void _ZN7S1565C63v79Ev();
extern void _ZN7S1565C63v80Ev();
extern void _ZN7S1565C63v81Ev();
extern void _ZN7S1565C63v82Ev();
extern void _ZN7S1565C63v83Ev();
extern void _ZN7S1565C63v84Ev();
extern void _ZN7S1565C63v85Ev();
extern void _ZN7S1565C63v86Ev();
extern void _ZN7S1565C63v87Ev();
static  VTBL_ENTRY vtc_S1565C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C6[0]),
  (VTBL_ENTRY)&_ZN7S1565C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v87Ev,
};
extern VTBL_ENTRY _ZTI7S1565C6[];
extern  VTBL_ENTRY _ZTV7S1565C6[];
Class_Descriptor cd_S1565C6 = {  "S1565C6", // class name
  0,0,//no base classes
  &(vtc_S1565C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1565C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1565C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C7  {
  virtual void  v88(); // _ZN7S1565C73v88Ev
  virtual void  v89(); // _ZN7S1565C73v89Ev
  virtual void  v90(); // _ZN7S1565C73v90Ev
  virtual void  v91(); // _ZN7S1565C73v91Ev
  virtual void  v92(); // _ZN7S1565C73v92Ev
  virtual void  v93(); // _ZN7S1565C73v93Ev
  virtual void  v94(); // _ZN7S1565C73v94Ev
  virtual void  v95(); // _ZN7S1565C73v95Ev
  virtual void  v96(); // _ZN7S1565C73v96Ev
  ~S1565C7(); // tgen
  S1565C7(); // tgen
};
//SIG(-1 S1565C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1565C7 ::v88(){vfunc_called(this, "_ZN7S1565C73v88Ev");}
void  S1565C7 ::v89(){vfunc_called(this, "_ZN7S1565C73v89Ev");}
void  S1565C7 ::v90(){vfunc_called(this, "_ZN7S1565C73v90Ev");}
void  S1565C7 ::v91(){vfunc_called(this, "_ZN7S1565C73v91Ev");}
void  S1565C7 ::v92(){vfunc_called(this, "_ZN7S1565C73v92Ev");}
void  S1565C7 ::v93(){vfunc_called(this, "_ZN7S1565C73v93Ev");}
void  S1565C7 ::v94(){vfunc_called(this, "_ZN7S1565C73v94Ev");}
void  S1565C7 ::v95(){vfunc_called(this, "_ZN7S1565C73v95Ev");}
void  S1565C7 ::v96(){vfunc_called(this, "_ZN7S1565C73v96Ev");}
S1565C7 ::~S1565C7(){ note_dtor("S1565C7", this);} // tgen
S1565C7 ::S1565C7(){ note_ctor("S1565C7", this);} // tgen

static void Test_S1565C7()
{
  extern Class_Descriptor cd_S1565C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1565C7, buf);
    S1565C7 *dp, &lv = *(dp=new (buf) S1565C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1565C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C7)");
    test_class_info(&lv, &cd_S1565C7);
    dp->~S1565C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C7(Test_S1565C7, "S1565C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1565C7C1Ev();
extern void _ZN7S1565C7D1Ev();
Name_Map name_map_S1565C7[] = {
  NSPAIR(_ZN7S1565C7C1Ev),
  NSPAIR(_ZN7S1565C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1565C7[];
extern void _ZN7S1565C73v88Ev();
extern void _ZN7S1565C73v89Ev();
extern void _ZN7S1565C73v90Ev();
extern void _ZN7S1565C73v91Ev();
extern void _ZN7S1565C73v92Ev();
extern void _ZN7S1565C73v93Ev();
extern void _ZN7S1565C73v94Ev();
extern void _ZN7S1565C73v95Ev();
extern void _ZN7S1565C73v96Ev();
static  VTBL_ENTRY vtc_S1565C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C7[0]),
  (VTBL_ENTRY)&_ZN7S1565C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v96Ev,
};
extern VTBL_ENTRY _ZTI7S1565C7[];
extern  VTBL_ENTRY _ZTV7S1565C7[];
Class_Descriptor cd_S1565C7 = {  "S1565C7", // class name
  0,0,//no base classes
  &(vtc_S1565C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1565C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1565C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C3  : S1565C4 , S1565C6 , S1565C7 {
  void *s1565c3f0;
  ::S79C39_nt s1565c3f1;
  unsigned int s1565c3f2:1;
  unsigned int s1565c3f3:1;
  unsigned int s1565c3f4:1;
  unsigned int s1565c3f5:1;
  virtual  ~S1565C3(); // _ZN7S1565C3D1Ev
  virtual void  v97(); // _ZN7S1565C33v97Ev
  virtual void  v98(); // _ZN7S1565C33v98Ev
  virtual void  v99(); // _ZN7S1565C33v99Ev
  virtual void  v100(); // _ZN7S1565C34v100Ev
  virtual void  v101(); // _ZN7S1565C34v101Ev
  virtual void  v102(); // _ZN7S1565C34v102Ev
  virtual void  v103(); // _ZN7S1565C34v103Ev
  virtual void  v104(); // _ZN7S1565C34v104Ev
  virtual void  v105(); // _ZN7S1565C34v105Ev
  virtual void  v106(); // _ZN7S1565C34v106Ev
  virtual void  v107(); // _ZN7S1565C34v107Ev
  virtual void  v108(); // _ZN7S1565C34v108Ev
  virtual void  v109(); // _ZN7S1565C34v109Ev
  virtual void  v110(); // _ZN7S1565C34v110Ev
  virtual void  v111(); // _ZN7S1565C34v111Ev
  virtual void  v112(); // _ZN7S1565C34v112Ev
  virtual void  v113(); // _ZN7S1565C34v113Ev
  virtual void  v114(); // _ZN7S1565C34v114Ev
  virtual void  v115(); // _ZN7S1565C34v115Ev
  virtual void  v116(); // _ZN7S1565C34v116Ev
  virtual void  v117(); // _ZN7S1565C34v117Ev
  virtual void  v118(); // _ZN7S1565C34v118Ev
  virtual void  v119(); // _ZN7S1565C34v119Ev
  virtual void  v120(); // _ZN7S1565C34v120Ev
  S1565C3(); // tgen
};
//SIG(-1 S1565C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1565C3 ::~S1565C3(){ note_dtor("S1565C3", this);}
void  S1565C3 ::v97(){vfunc_called(this, "_ZN7S1565C33v97Ev");}
void  S1565C3 ::v98(){vfunc_called(this, "_ZN7S1565C33v98Ev");}
void  S1565C3 ::v99(){vfunc_called(this, "_ZN7S1565C33v99Ev");}
void  S1565C3 ::v100(){vfunc_called(this, "_ZN7S1565C34v100Ev");}
void  S1565C3 ::v101(){vfunc_called(this, "_ZN7S1565C34v101Ev");}
void  S1565C3 ::v102(){vfunc_called(this, "_ZN7S1565C34v102Ev");}
void  S1565C3 ::v103(){vfunc_called(this, "_ZN7S1565C34v103Ev");}
void  S1565C3 ::v104(){vfunc_called(this, "_ZN7S1565C34v104Ev");}
void  S1565C3 ::v105(){vfunc_called(this, "_ZN7S1565C34v105Ev");}
void  S1565C3 ::v106(){vfunc_called(this, "_ZN7S1565C34v106Ev");}
void  S1565C3 ::v107(){vfunc_called(this, "_ZN7S1565C34v107Ev");}
void  S1565C3 ::v108(){vfunc_called(this, "_ZN7S1565C34v108Ev");}
void  S1565C3 ::v109(){vfunc_called(this, "_ZN7S1565C34v109Ev");}
void  S1565C3 ::v110(){vfunc_called(this, "_ZN7S1565C34v110Ev");}
void  S1565C3 ::v111(){vfunc_called(this, "_ZN7S1565C34v111Ev");}
void  S1565C3 ::v112(){vfunc_called(this, "_ZN7S1565C34v112Ev");}
void  S1565C3 ::v113(){vfunc_called(this, "_ZN7S1565C34v113Ev");}
void  S1565C3 ::v114(){vfunc_called(this, "_ZN7S1565C34v114Ev");}
void  S1565C3 ::v115(){vfunc_called(this, "_ZN7S1565C34v115Ev");}
void  S1565C3 ::v116(){vfunc_called(this, "_ZN7S1565C34v116Ev");}
void  S1565C3 ::v117(){vfunc_called(this, "_ZN7S1565C34v117Ev");}
void  S1565C3 ::v118(){vfunc_called(this, "_ZN7S1565C34v118Ev");}
void  S1565C3 ::v119(){vfunc_called(this, "_ZN7S1565C34v119Ev");}
void  S1565C3 ::v120(){vfunc_called(this, "_ZN7S1565C34v120Ev");}
S1565C3 ::S1565C3(){ note_ctor("S1565C3", this);} // tgen

static void Test_S1565C3()
{
  extern Class_Descriptor cd_S1565C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1565C3, buf);
    S1565C3 *dp, &lv = *(dp=new (buf) S1565C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1565C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C3)");
    check_base_class_offset(lv, (S1565C4*), 0, "S1565C3");
    check_base_class_offset(lv, (S1565C6*), ABISELECT(96,60), "S1565C3");
    check_base_class_offset(lv, (S1565C7*), ABISELECT(104,64), "S1565C3");
    check_field_offset(lv, s1565c3f0, ABISELECT(112,68), "S1565C3.s1565c3f0");
    check_field_offset(lv, s1565c3f1, ABISELECT(120,72), "S1565C3.s1565c3f1");
    set_bf_and_test(lv, s1565c3f2, ABISELECT(136,84), 0, 1, 1, "S1565C3");
    set_bf_and_test(lv, s1565c3f3, ABISELECT(136,84), 1, 1, 1, "S1565C3");
    set_bf_and_test(lv, s1565c3f4, ABISELECT(136,84), 2, 1, 1, "S1565C3");
    set_bf_and_test(lv, s1565c3f5, ABISELECT(136,84), 3, 1, 1, "S1565C3");
    test_class_info(&lv, &cd_S1565C3);
    dp->~S1565C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C3(Test_S1565C3, "S1565C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1565C3C1Ev();
extern void _ZN7S1565C3D1Ev();
Name_Map name_map_S1565C3[] = {
  NSPAIR(_ZN7S1565C3C1Ev),
  NSPAIR(_ZN7S1565C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1565C4;
extern VTBL_ENTRY _ZTI7S1565C4[];
extern  VTBL_ENTRY _ZTV7S1565C4[];
extern Class_Descriptor cd_S1565C6;
extern VTBL_ENTRY _ZTI7S1565C6[];
extern  VTBL_ENTRY _ZTV7S1565C6[];
extern Class_Descriptor cd_S1565C7;
extern VTBL_ENTRY _ZTI7S1565C7[];
extern  VTBL_ENTRY _ZTV7S1565C7[];
static Base_Class bases_S1565C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1565C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1565C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1565C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1565C3[];
extern void _ZN7S1565C3D1Ev();
extern void _ZN7S1565C3D0Ev();
extern void _ZN7S1565C42v8Ev();
extern void _ZN7S1565C42v9Ev();
extern void _ZN7S1565C43v10Ev();
extern void _ZN7S1565C43v11Ev();
extern void _ZN7S1565C43v12Ev();
extern void _ZN7S1565C43v13Ev();
extern void _ZN7S1565C43v14Ev();
extern void _ZN7S1565C43v15Ev();
extern void _ZN7S1565C43v16Ev();
extern void _ZN7S1565C43v17Ev();
extern void _ZN7S1565C43v18Ev();
extern void _ZN7S1565C43v19Ev();
extern void _ZN7S1565C43v20Ev();
extern void _ZN7S1565C43v21Ev();
extern void _ZN7S1565C43v22Ev();
extern void _ZN7S1565C43v23Ev();
extern void _ZN7S1565C43v24Ev();
extern void _ZN7S1565C43v25Ev();
extern void _ZN7S1565C43v26Ev();
extern void _ZN7S1565C43v27Ev();
extern void _ZN7S1565C43v28Ev();
extern void _ZN7S1565C43v29Ev();
extern void _ZN7S1565C43v30Ev();
extern void _ZN7S1565C43v31Ev();
extern void _ZN7S1565C43v32Ev();
extern void _ZN7S1565C43v33Ev();
extern void _ZN7S1565C43v34Ev();
extern void _ZN7S1565C43v35Ev();
extern void _ZN7S1565C43v36Ev();
extern void _ZN7S1565C43v37Ev();
extern void _ZN7S1565C43v38Ev();
extern void _ZN7S1565C43v39Ev();
extern void _ZN7S1565C43v40Ev();
extern void _ZN7S1565C43v41Ev();
extern void _ZN7S1565C43v42Ev();
extern void _ZN7S1565C43v43Ev();
extern void _ZN7S1565C43v44Ev();
extern void _ZN7S1565C43v45Ev();
extern void _ZN7S1565C43v46Ev();
extern void _ZN7S1565C43v47Ev();
extern void _ZN7S1565C43v48Ev();
extern void _ZN7S1565C43v49Ev();
extern void _ZN7S1565C43v50Ev();
extern void _ZN7S1565C43v51Ev();
extern void _ZN7S1565C43v52Ev();
extern void _ZN7S1565C43v53Ev();
extern void _ZN7S1565C43v54Ev();
extern void _ZN7S1565C43v55Ev();
extern void _ZN7S1565C43v56Ev();
extern void _ZN7S1565C43v57Ev();
extern void _ZN7S1565C43v58Ev();
extern void _ZN7S1565C43v59Ev();
extern void _ZN7S1565C43v60Ev();
extern void _ZN7S1565C43v61Ev();
extern void _ZN7S1565C43v62Ev();
extern void _ZN7S1565C43v63Ev();
extern void _ZN7S1565C43v64Ev();
extern void _ZN7S1565C43v65Ev();
extern void _ZN7S1565C43v66Ev();
extern void _ZN7S1565C43v67Ev();
extern void _ZN7S1565C43v68Ev();
extern void _ZN7S1565C43v69Ev();
extern void _ZN7S1565C43v70Ev();
extern void _ZN7S1565C43v71Ev();
extern void _ZN7S1565C33v97Ev();
extern void _ZN7S1565C33v98Ev();
extern void _ZN7S1565C33v99Ev();
extern void _ZN7S1565C34v100Ev();
extern void _ZN7S1565C34v101Ev();
extern void _ZN7S1565C34v102Ev();
extern void _ZN7S1565C34v103Ev();
extern void _ZN7S1565C34v104Ev();
extern void _ZN7S1565C34v105Ev();
extern void _ZN7S1565C34v106Ev();
extern void _ZN7S1565C34v107Ev();
extern void _ZN7S1565C34v108Ev();
extern void _ZN7S1565C34v109Ev();
extern void _ZN7S1565C34v110Ev();
extern void _ZN7S1565C34v111Ev();
extern void _ZN7S1565C34v112Ev();
extern void _ZN7S1565C34v113Ev();
extern void _ZN7S1565C34v114Ev();
extern void _ZN7S1565C34v115Ev();
extern void _ZN7S1565C34v116Ev();
extern void _ZN7S1565C34v117Ev();
extern void _ZN7S1565C34v118Ev();
extern void _ZN7S1565C34v119Ev();
extern void _ZN7S1565C34v120Ev();
extern void _ZN7S1565C63v72Ev();
extern void _ZN7S1565C63v73Ev();
extern void _ZN7S1565C63v74Ev();
extern void _ZN7S1565C63v75Ev();
extern void _ZN7S1565C63v76Ev();
extern void _ZN7S1565C63v77Ev();
extern void _ZN7S1565C63v78Ev();
extern void _ZN7S1565C63v79Ev();
extern void _ZN7S1565C63v80Ev();
extern void _ZN7S1565C63v81Ev();
extern void _ZN7S1565C63v82Ev();
extern void _ZN7S1565C63v83Ev();
extern void _ZN7S1565C63v84Ev();
extern void _ZN7S1565C63v85Ev();
extern void _ZN7S1565C63v86Ev();
extern void _ZN7S1565C63v87Ev();
extern void _ZN7S1565C73v88Ev();
extern void _ZN7S1565C73v89Ev();
extern void _ZN7S1565C73v90Ev();
extern void _ZN7S1565C73v91Ev();
extern void _ZN7S1565C73v92Ev();
extern void _ZN7S1565C73v93Ev();
extern void _ZN7S1565C73v94Ev();
extern void _ZN7S1565C73v95Ev();
extern void _ZN7S1565C73v96Ev();
static  VTBL_ENTRY vtc_S1565C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C3[0]),
  (VTBL_ENTRY)&_ZN7S1565C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1565C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v120Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1565C3[0]),
  (VTBL_ENTRY)&_ZN7S1565C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v87Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1565C3[0]),
  (VTBL_ENTRY)&_ZN7S1565C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v96Ev,
};
extern VTBL_ENTRY _ZTI7S1565C3[];
extern  VTBL_ENTRY _ZTV7S1565C3[];
Class_Descriptor cd_S1565C3 = {  "S1565C3", // class name
  bases_S1565C3, 3,
  &(vtc_S1565C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1565C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1565C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C2  : S1565C3 {
  ::S3262C11_nt s1565c2f0;
  int s1565c2f1;
  virtual  ~S1565C2(); // _ZN7S1565C2D1Ev
  virtual void  v121(); // _ZN7S1565C24v121Ev
  virtual void  v122(); // _ZN7S1565C24v122Ev
  virtual void  v123(); // _ZN7S1565C24v123Ev
  virtual void  v124(); // _ZN7S1565C24v124Ev
  virtual void  v125(); // _ZN7S1565C24v125Ev
  virtual void  v126(); // _ZN7S1565C24v126Ev
  virtual void  v127(); // _ZN7S1565C24v127Ev
  virtual void  v128(); // _ZN7S1565C24v128Ev
  virtual void  v129(); // _ZN7S1565C24v129Ev
  virtual void  v130(); // _ZN7S1565C24v130Ev
  virtual void  v131(); // _ZN7S1565C24v131Ev
  virtual void  v132(); // _ZN7S1565C24v132Ev
  virtual void  v133(); // _ZN7S1565C24v133Ev
  virtual void  v134(); // _ZN7S1565C24v134Ev
  virtual void  v135(); // _ZN7S1565C24v135Ev
  virtual void  v136(); // _ZN7S1565C24v136Ev
  virtual void  v137(); // _ZN7S1565C24v137Ev
  virtual void  v138(); // _ZN7S1565C24v138Ev
  virtual void  v139(); // _ZN7S1565C24v139Ev
  virtual void  v140(); // _ZN7S1565C24v140Ev
  virtual void  v141(); // _ZN7S1565C24v141Ev
  virtual void  v142(); // _ZN7S1565C24v142Ev
  virtual void  v143(); // _ZN7S1565C24v143Ev
  virtual void  v144(); // _ZN7S1565C24v144Ev
  virtual void  v145(); // _ZN7S1565C24v145Ev
  virtual void  v146(); // _ZN7S1565C24v146Ev
  S1565C2(); // tgen
};
//SIG(-1 S1565C2) C1{ BC2{ BC3{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106} BC6{ v107 v108 v109 v110 v111 v112 v113 v114 v115} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1565C2 ::~S1565C2(){ note_dtor("S1565C2", this);}
void  S1565C2 ::v121(){vfunc_called(this, "_ZN7S1565C24v121Ev");}
void  S1565C2 ::v122(){vfunc_called(this, "_ZN7S1565C24v122Ev");}
void  S1565C2 ::v123(){vfunc_called(this, "_ZN7S1565C24v123Ev");}
void  S1565C2 ::v124(){vfunc_called(this, "_ZN7S1565C24v124Ev");}
void  S1565C2 ::v125(){vfunc_called(this, "_ZN7S1565C24v125Ev");}
void  S1565C2 ::v126(){vfunc_called(this, "_ZN7S1565C24v126Ev");}
void  S1565C2 ::v127(){vfunc_called(this, "_ZN7S1565C24v127Ev");}
void  S1565C2 ::v128(){vfunc_called(this, "_ZN7S1565C24v128Ev");}
void  S1565C2 ::v129(){vfunc_called(this, "_ZN7S1565C24v129Ev");}
void  S1565C2 ::v130(){vfunc_called(this, "_ZN7S1565C24v130Ev");}
void  S1565C2 ::v131(){vfunc_called(this, "_ZN7S1565C24v131Ev");}
void  S1565C2 ::v132(){vfunc_called(this, "_ZN7S1565C24v132Ev");}
void  S1565C2 ::v133(){vfunc_called(this, "_ZN7S1565C24v133Ev");}
void  S1565C2 ::v134(){vfunc_called(this, "_ZN7S1565C24v134Ev");}
void  S1565C2 ::v135(){vfunc_called(this, "_ZN7S1565C24v135Ev");}
void  S1565C2 ::v136(){vfunc_called(this, "_ZN7S1565C24v136Ev");}
void  S1565C2 ::v137(){vfunc_called(this, "_ZN7S1565C24v137Ev");}
void  S1565C2 ::v138(){vfunc_called(this, "_ZN7S1565C24v138Ev");}
void  S1565C2 ::v139(){vfunc_called(this, "_ZN7S1565C24v139Ev");}
void  S1565C2 ::v140(){vfunc_called(this, "_ZN7S1565C24v140Ev");}
void  S1565C2 ::v141(){vfunc_called(this, "_ZN7S1565C24v141Ev");}
void  S1565C2 ::v142(){vfunc_called(this, "_ZN7S1565C24v142Ev");}
void  S1565C2 ::v143(){vfunc_called(this, "_ZN7S1565C24v143Ev");}
void  S1565C2 ::v144(){vfunc_called(this, "_ZN7S1565C24v144Ev");}
void  S1565C2 ::v145(){vfunc_called(this, "_ZN7S1565C24v145Ev");}
void  S1565C2 ::v146(){vfunc_called(this, "_ZN7S1565C24v146Ev");}
S1565C2 ::S1565C2(){ note_ctor("S1565C2", this);} // tgen

static void Test_S1565C2()
{
  extern Class_Descriptor cd_S1565C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1565C2, buf);
    S1565C2 *dp, &lv = *(dp=new (buf) S1565C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1565C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C2)");
    check_base_class_offset(lv, (S1565C4*)(S1565C3*), 0, "S1565C2");
    check_base_class_offset(lv, (S1565C6*)(S1565C3*), ABISELECT(96,60), "S1565C2");
    check_base_class_offset(lv, (S1565C7*)(S1565C3*), ABISELECT(104,64), "S1565C2");
    check_base_class_offset(lv, (S1565C3*), 0, "S1565C2");
    check_field_offset(lv, s1565c2f0, ABISELECT(144,88), "S1565C2.s1565c2f0");
    check_field_offset(lv, s1565c2f1, ABISELECT(168,104), "S1565C2.s1565c2f1");
    test_class_info(&lv, &cd_S1565C2);
    dp->~S1565C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C2(Test_S1565C2, "S1565C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1565C2C1Ev();
extern void _ZN7S1565C2D1Ev();
Name_Map name_map_S1565C2[] = {
  NSPAIR(_ZN7S1565C2C1Ev),
  NSPAIR(_ZN7S1565C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1565C4;
extern VTBL_ENTRY _ZTI7S1565C4[];
extern  VTBL_ENTRY _ZTV7S1565C4[];
extern Class_Descriptor cd_S1565C6;
extern VTBL_ENTRY _ZTI7S1565C6[];
extern  VTBL_ENTRY _ZTV7S1565C6[];
extern Class_Descriptor cd_S1565C7;
extern VTBL_ENTRY _ZTI7S1565C7[];
extern  VTBL_ENTRY _ZTV7S1565C7[];
extern Class_Descriptor cd_S1565C3;
extern VTBL_ENTRY _ZTI7S1565C3[];
extern  VTBL_ENTRY _ZTV7S1565C3[];
static Base_Class bases_S1565C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1565C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C6,    ABISELECT(96,60), //bcp->offset
    118, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C7,    ABISELECT(104,64), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1565C2[];
extern void _ZN7S1565C2D1Ev();
extern void _ZN7S1565C2D0Ev();
extern void _ZN7S1565C42v8Ev();
extern void _ZN7S1565C42v9Ev();
extern void _ZN7S1565C43v10Ev();
extern void _ZN7S1565C43v11Ev();
extern void _ZN7S1565C43v12Ev();
extern void _ZN7S1565C43v13Ev();
extern void _ZN7S1565C43v14Ev();
extern void _ZN7S1565C43v15Ev();
extern void _ZN7S1565C43v16Ev();
extern void _ZN7S1565C43v17Ev();
extern void _ZN7S1565C43v18Ev();
extern void _ZN7S1565C43v19Ev();
extern void _ZN7S1565C43v20Ev();
extern void _ZN7S1565C43v21Ev();
extern void _ZN7S1565C43v22Ev();
extern void _ZN7S1565C43v23Ev();
extern void _ZN7S1565C43v24Ev();
extern void _ZN7S1565C43v25Ev();
extern void _ZN7S1565C43v26Ev();
extern void _ZN7S1565C43v27Ev();
extern void _ZN7S1565C43v28Ev();
extern void _ZN7S1565C43v29Ev();
extern void _ZN7S1565C43v30Ev();
extern void _ZN7S1565C43v31Ev();
extern void _ZN7S1565C43v32Ev();
extern void _ZN7S1565C43v33Ev();
extern void _ZN7S1565C43v34Ev();
extern void _ZN7S1565C43v35Ev();
extern void _ZN7S1565C43v36Ev();
extern void _ZN7S1565C43v37Ev();
extern void _ZN7S1565C43v38Ev();
extern void _ZN7S1565C43v39Ev();
extern void _ZN7S1565C43v40Ev();
extern void _ZN7S1565C43v41Ev();
extern void _ZN7S1565C43v42Ev();
extern void _ZN7S1565C43v43Ev();
extern void _ZN7S1565C43v44Ev();
extern void _ZN7S1565C43v45Ev();
extern void _ZN7S1565C43v46Ev();
extern void _ZN7S1565C43v47Ev();
extern void _ZN7S1565C43v48Ev();
extern void _ZN7S1565C43v49Ev();
extern void _ZN7S1565C43v50Ev();
extern void _ZN7S1565C43v51Ev();
extern void _ZN7S1565C43v52Ev();
extern void _ZN7S1565C43v53Ev();
extern void _ZN7S1565C43v54Ev();
extern void _ZN7S1565C43v55Ev();
extern void _ZN7S1565C43v56Ev();
extern void _ZN7S1565C43v57Ev();
extern void _ZN7S1565C43v58Ev();
extern void _ZN7S1565C43v59Ev();
extern void _ZN7S1565C43v60Ev();
extern void _ZN7S1565C43v61Ev();
extern void _ZN7S1565C43v62Ev();
extern void _ZN7S1565C43v63Ev();
extern void _ZN7S1565C43v64Ev();
extern void _ZN7S1565C43v65Ev();
extern void _ZN7S1565C43v66Ev();
extern void _ZN7S1565C43v67Ev();
extern void _ZN7S1565C43v68Ev();
extern void _ZN7S1565C43v69Ev();
extern void _ZN7S1565C43v70Ev();
extern void _ZN7S1565C43v71Ev();
extern void _ZN7S1565C33v97Ev();
extern void _ZN7S1565C33v98Ev();
extern void _ZN7S1565C33v99Ev();
extern void _ZN7S1565C34v100Ev();
extern void _ZN7S1565C34v101Ev();
extern void _ZN7S1565C34v102Ev();
extern void _ZN7S1565C34v103Ev();
extern void _ZN7S1565C34v104Ev();
extern void _ZN7S1565C34v105Ev();
extern void _ZN7S1565C34v106Ev();
extern void _ZN7S1565C34v107Ev();
extern void _ZN7S1565C34v108Ev();
extern void _ZN7S1565C34v109Ev();
extern void _ZN7S1565C34v110Ev();
extern void _ZN7S1565C34v111Ev();
extern void _ZN7S1565C34v112Ev();
extern void _ZN7S1565C34v113Ev();
extern void _ZN7S1565C34v114Ev();
extern void _ZN7S1565C34v115Ev();
extern void _ZN7S1565C34v116Ev();
extern void _ZN7S1565C34v117Ev();
extern void _ZN7S1565C34v118Ev();
extern void _ZN7S1565C34v119Ev();
extern void _ZN7S1565C34v120Ev();
extern void _ZN7S1565C24v121Ev();
extern void _ZN7S1565C24v122Ev();
extern void _ZN7S1565C24v123Ev();
extern void _ZN7S1565C24v124Ev();
extern void _ZN7S1565C24v125Ev();
extern void _ZN7S1565C24v126Ev();
extern void _ZN7S1565C24v127Ev();
extern void _ZN7S1565C24v128Ev();
extern void _ZN7S1565C24v129Ev();
extern void _ZN7S1565C24v130Ev();
extern void _ZN7S1565C24v131Ev();
extern void _ZN7S1565C24v132Ev();
extern void _ZN7S1565C24v133Ev();
extern void _ZN7S1565C24v134Ev();
extern void _ZN7S1565C24v135Ev();
extern void _ZN7S1565C24v136Ev();
extern void _ZN7S1565C24v137Ev();
extern void _ZN7S1565C24v138Ev();
extern void _ZN7S1565C24v139Ev();
extern void _ZN7S1565C24v140Ev();
extern void _ZN7S1565C24v141Ev();
extern void _ZN7S1565C24v142Ev();
extern void _ZN7S1565C24v143Ev();
extern void _ZN7S1565C24v144Ev();
extern void _ZN7S1565C24v145Ev();
extern void _ZN7S1565C24v146Ev();
extern void _ZN7S1565C63v72Ev();
extern void _ZN7S1565C63v73Ev();
extern void _ZN7S1565C63v74Ev();
extern void _ZN7S1565C63v75Ev();
extern void _ZN7S1565C63v76Ev();
extern void _ZN7S1565C63v77Ev();
extern void _ZN7S1565C63v78Ev();
extern void _ZN7S1565C63v79Ev();
extern void _ZN7S1565C63v80Ev();
extern void _ZN7S1565C63v81Ev();
extern void _ZN7S1565C63v82Ev();
extern void _ZN7S1565C63v83Ev();
extern void _ZN7S1565C63v84Ev();
extern void _ZN7S1565C63v85Ev();
extern void _ZN7S1565C63v86Ev();
extern void _ZN7S1565C63v87Ev();
extern void _ZN7S1565C73v88Ev();
extern void _ZN7S1565C73v89Ev();
extern void _ZN7S1565C73v90Ev();
extern void _ZN7S1565C73v91Ev();
extern void _ZN7S1565C73v92Ev();
extern void _ZN7S1565C73v93Ev();
extern void _ZN7S1565C73v94Ev();
extern void _ZN7S1565C73v95Ev();
extern void _ZN7S1565C73v96Ev();
static  VTBL_ENTRY vtc_S1565C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C2[0]),
  (VTBL_ENTRY)&_ZN7S1565C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1565C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v146Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1565C2[0]),
  (VTBL_ENTRY)&_ZN7S1565C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v87Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1565C2[0]),
  (VTBL_ENTRY)&_ZN7S1565C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v96Ev,
};
extern VTBL_ENTRY _ZTI7S1565C2[];
extern  VTBL_ENTRY _ZTV7S1565C2[];
Class_Descriptor cd_S1565C2 = {  "S1565C2", // class name
  bases_S1565C2, 4,
  &(vtc_S1565C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1565C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1565C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1565C1  : S1565C2 {
  virtual  ~S1565C1(); // _ZN7S1565C1D1Ev
  virtual void  v1(); // _ZN7S1565C12v1Ev
  virtual void  v2(); // _ZN7S1565C12v2Ev
  virtual void  v3(); // _ZN7S1565C12v3Ev
  virtual void  v4(); // _ZN7S1565C12v4Ev
  virtual void  v5(); // _ZN7S1565C12v5Ev
  virtual void  v6(); // _ZN7S1565C12v6Ev
  virtual void  v7(); // _ZN7S1565C12v7Ev
  S1565C1(); // tgen
};
//SIG(1 S1565C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} BC7{ v88 v89 v90 v91 v92 v93 v94 v95 v96} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 v6 v7}


 S1565C1 ::~S1565C1(){ note_dtor("S1565C1", this);}
void  S1565C1 ::v1(){vfunc_called(this, "_ZN7S1565C12v1Ev");}
void  S1565C1 ::v2(){vfunc_called(this, "_ZN7S1565C12v2Ev");}
void  S1565C1 ::v3(){vfunc_called(this, "_ZN7S1565C12v3Ev");}
void  S1565C1 ::v4(){vfunc_called(this, "_ZN7S1565C12v4Ev");}
void  S1565C1 ::v5(){vfunc_called(this, "_ZN7S1565C12v5Ev");}
void  S1565C1 ::v6(){vfunc_called(this, "_ZN7S1565C12v6Ev");}
void  S1565C1 ::v7(){vfunc_called(this, "_ZN7S1565C12v7Ev");}
S1565C1 ::S1565C1(){ note_ctor("S1565C1", this);} // tgen

static void Test_S1565C1()
{
  extern Class_Descriptor cd_S1565C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1565C1, buf);
    S1565C1 *dp, &lv = *(dp=new (buf) S1565C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1565C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1565C1)");
    check_base_class_offset(lv, (S1565C4*)(S1565C3*)(S1565C2*), 0, "S1565C1");
    check_base_class_offset(lv, (S1565C6*)(S1565C3*)(S1565C2*), ABISELECT(96,60), "S1565C1");
    check_base_class_offset(lv, (S1565C7*)(S1565C3*)(S1565C2*), ABISELECT(104,64), "S1565C1");
    check_base_class_offset(lv, (S1565C3*)(S1565C2*), 0, "S1565C1");
    check_base_class_offset(lv, (S1565C2*), 0, "S1565C1");
    test_class_info(&lv, &cd_S1565C1);
    dp->~S1565C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1565C1(Test_S1565C1, "S1565C1", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1565C1C1Ev();
extern void _ZN7S1565C1D1Ev();
Name_Map name_map_S1565C1[] = {
  NSPAIR(_ZN7S1565C1C1Ev),
  NSPAIR(_ZN7S1565C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1565C4;
extern VTBL_ENTRY _ZTI7S1565C4[];
extern  VTBL_ENTRY _ZTV7S1565C4[];
extern Class_Descriptor cd_S1565C6;
extern VTBL_ENTRY _ZTI7S1565C6[];
extern  VTBL_ENTRY _ZTV7S1565C6[];
extern Class_Descriptor cd_S1565C7;
extern VTBL_ENTRY _ZTI7S1565C7[];
extern  VTBL_ENTRY _ZTV7S1565C7[];
extern Class_Descriptor cd_S1565C3;
extern VTBL_ENTRY _ZTI7S1565C3[];
extern  VTBL_ENTRY _ZTV7S1565C3[];
extern Class_Descriptor cd_S1565C2;
extern VTBL_ENTRY _ZTI7S1565C2[];
extern  VTBL_ENTRY _ZTV7S1565C2[];
static Base_Class bases_S1565C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1565C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C6,    ABISELECT(96,60), //bcp->offset
    125, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C7,    ABISELECT(104,64), //bcp->offset
    143, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1565C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1565C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1565C1[];
extern void _ZN7S1565C1D1Ev();
extern void _ZN7S1565C1D0Ev();
extern void _ZN7S1565C42v8Ev();
extern void _ZN7S1565C42v9Ev();
extern void _ZN7S1565C43v10Ev();
extern void _ZN7S1565C43v11Ev();
extern void _ZN7S1565C43v12Ev();
extern void _ZN7S1565C43v13Ev();
extern void _ZN7S1565C43v14Ev();
extern void _ZN7S1565C43v15Ev();
extern void _ZN7S1565C43v16Ev();
extern void _ZN7S1565C43v17Ev();
extern void _ZN7S1565C43v18Ev();
extern void _ZN7S1565C43v19Ev();
extern void _ZN7S1565C43v20Ev();
extern void _ZN7S1565C43v21Ev();
extern void _ZN7S1565C43v22Ev();
extern void _ZN7S1565C43v23Ev();
extern void _ZN7S1565C43v24Ev();
extern void _ZN7S1565C43v25Ev();
extern void _ZN7S1565C43v26Ev();
extern void _ZN7S1565C43v27Ev();
extern void _ZN7S1565C43v28Ev();
extern void _ZN7S1565C43v29Ev();
extern void _ZN7S1565C43v30Ev();
extern void _ZN7S1565C43v31Ev();
extern void _ZN7S1565C43v32Ev();
extern void _ZN7S1565C43v33Ev();
extern void _ZN7S1565C43v34Ev();
extern void _ZN7S1565C43v35Ev();
extern void _ZN7S1565C43v36Ev();
extern void _ZN7S1565C43v37Ev();
extern void _ZN7S1565C43v38Ev();
extern void _ZN7S1565C43v39Ev();
extern void _ZN7S1565C43v40Ev();
extern void _ZN7S1565C43v41Ev();
extern void _ZN7S1565C43v42Ev();
extern void _ZN7S1565C43v43Ev();
extern void _ZN7S1565C43v44Ev();
extern void _ZN7S1565C43v45Ev();
extern void _ZN7S1565C43v46Ev();
extern void _ZN7S1565C43v47Ev();
extern void _ZN7S1565C43v48Ev();
extern void _ZN7S1565C43v49Ev();
extern void _ZN7S1565C43v50Ev();
extern void _ZN7S1565C43v51Ev();
extern void _ZN7S1565C43v52Ev();
extern void _ZN7S1565C43v53Ev();
extern void _ZN7S1565C43v54Ev();
extern void _ZN7S1565C43v55Ev();
extern void _ZN7S1565C43v56Ev();
extern void _ZN7S1565C43v57Ev();
extern void _ZN7S1565C43v58Ev();
extern void _ZN7S1565C43v59Ev();
extern void _ZN7S1565C43v60Ev();
extern void _ZN7S1565C43v61Ev();
extern void _ZN7S1565C43v62Ev();
extern void _ZN7S1565C43v63Ev();
extern void _ZN7S1565C43v64Ev();
extern void _ZN7S1565C43v65Ev();
extern void _ZN7S1565C43v66Ev();
extern void _ZN7S1565C43v67Ev();
extern void _ZN7S1565C43v68Ev();
extern void _ZN7S1565C43v69Ev();
extern void _ZN7S1565C43v70Ev();
extern void _ZN7S1565C43v71Ev();
extern void _ZN7S1565C33v97Ev();
extern void _ZN7S1565C33v98Ev();
extern void _ZN7S1565C33v99Ev();
extern void _ZN7S1565C34v100Ev();
extern void _ZN7S1565C34v101Ev();
extern void _ZN7S1565C34v102Ev();
extern void _ZN7S1565C34v103Ev();
extern void _ZN7S1565C34v104Ev();
extern void _ZN7S1565C34v105Ev();
extern void _ZN7S1565C34v106Ev();
extern void _ZN7S1565C34v107Ev();
extern void _ZN7S1565C34v108Ev();
extern void _ZN7S1565C34v109Ev();
extern void _ZN7S1565C34v110Ev();
extern void _ZN7S1565C34v111Ev();
extern void _ZN7S1565C34v112Ev();
extern void _ZN7S1565C34v113Ev();
extern void _ZN7S1565C34v114Ev();
extern void _ZN7S1565C34v115Ev();
extern void _ZN7S1565C34v116Ev();
extern void _ZN7S1565C34v117Ev();
extern void _ZN7S1565C34v118Ev();
extern void _ZN7S1565C34v119Ev();
extern void _ZN7S1565C34v120Ev();
extern void _ZN7S1565C24v121Ev();
extern void _ZN7S1565C24v122Ev();
extern void _ZN7S1565C24v123Ev();
extern void _ZN7S1565C24v124Ev();
extern void _ZN7S1565C24v125Ev();
extern void _ZN7S1565C24v126Ev();
extern void _ZN7S1565C24v127Ev();
extern void _ZN7S1565C24v128Ev();
extern void _ZN7S1565C24v129Ev();
extern void _ZN7S1565C24v130Ev();
extern void _ZN7S1565C24v131Ev();
extern void _ZN7S1565C24v132Ev();
extern void _ZN7S1565C24v133Ev();
extern void _ZN7S1565C24v134Ev();
extern void _ZN7S1565C24v135Ev();
extern void _ZN7S1565C24v136Ev();
extern void _ZN7S1565C24v137Ev();
extern void _ZN7S1565C24v138Ev();
extern void _ZN7S1565C24v139Ev();
extern void _ZN7S1565C24v140Ev();
extern void _ZN7S1565C24v141Ev();
extern void _ZN7S1565C24v142Ev();
extern void _ZN7S1565C24v143Ev();
extern void _ZN7S1565C24v144Ev();
extern void _ZN7S1565C24v145Ev();
extern void _ZN7S1565C24v146Ev();
extern void _ZN7S1565C12v1Ev();
extern void _ZN7S1565C12v2Ev();
extern void _ZN7S1565C12v3Ev();
extern void _ZN7S1565C12v4Ev();
extern void _ZN7S1565C12v5Ev();
extern void _ZN7S1565C12v6Ev();
extern void _ZN7S1565C12v7Ev();
extern void _ZN7S1565C63v72Ev();
extern void _ZN7S1565C63v73Ev();
extern void _ZN7S1565C63v74Ev();
extern void _ZN7S1565C63v75Ev();
extern void _ZN7S1565C63v76Ev();
extern void _ZN7S1565C63v77Ev();
extern void _ZN7S1565C63v78Ev();
extern void _ZN7S1565C63v79Ev();
extern void _ZN7S1565C63v80Ev();
extern void _ZN7S1565C63v81Ev();
extern void _ZN7S1565C63v82Ev();
extern void _ZN7S1565C63v83Ev();
extern void _ZN7S1565C63v84Ev();
extern void _ZN7S1565C63v85Ev();
extern void _ZN7S1565C63v86Ev();
extern void _ZN7S1565C63v87Ev();
extern void _ZN7S1565C73v88Ev();
extern void _ZN7S1565C73v89Ev();
extern void _ZN7S1565C73v90Ev();
extern void _ZN7S1565C73v91Ev();
extern void _ZN7S1565C73v92Ev();
extern void _ZN7S1565C73v93Ev();
extern void _ZN7S1565C73v94Ev();
extern void _ZN7S1565C73v95Ev();
extern void _ZN7S1565C73v96Ev();
static  VTBL_ENTRY vtc_S1565C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1565C1[0]),
  (VTBL_ENTRY)&_ZN7S1565C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1565C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1565C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1565C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1565C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v119Ev,
  (VTBL_ENTRY)&_ZN7S1565C34v120Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1565C24v146Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1565C12v7Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1565C1[0]),
  (VTBL_ENTRY)&_ZN7S1565C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v85Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v86Ev,
  (VTBL_ENTRY)&_ZN7S1565C63v87Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1565C1[0]),
  (VTBL_ENTRY)&_ZN7S1565C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v94Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v95Ev,
  (VTBL_ENTRY)&_ZN7S1565C73v96Ev,
};
extern VTBL_ENTRY _ZTI7S1565C1[];
extern  VTBL_ENTRY _ZTV7S1565C1[];
Class_Descriptor cd_S1565C1 = {  "S1565C1", // class name
  bases_S1565C1, 5,
  &(vtc_S1565C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1565C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1565C1),154, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C4  {
  int s1501c4f0;
  __tsi64 s1501c4f1;
  void *s1501c4f2[4];
  int s1501c4f3[2];
  void *s1501c4f4;
  ::S79C8_nt s1501c4f5;
  void *s1501c4f6[2];
  virtual  ~S1501C4(); // _ZN7S1501C4D1Ev
  virtual void  v6(); // _ZN7S1501C42v6Ev
  virtual void  v7(); // _ZN7S1501C42v7Ev
  virtual void  v8(); // _ZN7S1501C42v8Ev
  virtual void  v9(); // _ZN7S1501C42v9Ev
  virtual void  v10(); // _ZN7S1501C43v10Ev
  virtual void  v11(); // _ZN7S1501C43v11Ev
  virtual void  v12(); // _ZN7S1501C43v12Ev
  virtual void  v13(); // _ZN7S1501C43v13Ev
  virtual void  v14(); // _ZN7S1501C43v14Ev
  virtual void  v15(); // _ZN7S1501C43v15Ev
  virtual void  v16(); // _ZN7S1501C43v16Ev
  virtual void  v17(); // _ZN7S1501C43v17Ev
  virtual void  v18(); // _ZN7S1501C43v18Ev
  virtual void  v19(); // _ZN7S1501C43v19Ev
  virtual void  v20(); // _ZN7S1501C43v20Ev
  virtual void  v21(); // _ZN7S1501C43v21Ev
  virtual void  v22(); // _ZN7S1501C43v22Ev
  virtual void  v23(); // _ZN7S1501C43v23Ev
  virtual void  v24(); // _ZN7S1501C43v24Ev
  virtual void  v25(); // _ZN7S1501C43v25Ev
  virtual void  v26(); // _ZN7S1501C43v26Ev
  virtual void  v27(); // _ZN7S1501C43v27Ev
  virtual void  v28(); // _ZN7S1501C43v28Ev
  virtual void  v29(); // _ZN7S1501C43v29Ev
  virtual void  v30(); // _ZN7S1501C43v30Ev
  virtual void  v31(); // _ZN7S1501C43v31Ev
  virtual void  v32(); // _ZN7S1501C43v32Ev
  virtual void  v33(); // _ZN7S1501C43v33Ev
  virtual void  v34(); // _ZN7S1501C43v34Ev
  virtual void  v35(); // _ZN7S1501C43v35Ev
  virtual void  v36(); // _ZN7S1501C43v36Ev
  virtual void  v37(); // _ZN7S1501C43v37Ev
  virtual void  v38(); // _ZN7S1501C43v38Ev
  virtual void  v39(); // _ZN7S1501C43v39Ev
  virtual void  v40(); // _ZN7S1501C43v40Ev
  virtual void  v41(); // _ZN7S1501C43v41Ev
  virtual void  v42(); // _ZN7S1501C43v42Ev
  virtual void  v43(); // _ZN7S1501C43v43Ev
  virtual void  v44(); // _ZN7S1501C43v44Ev
  virtual void  v45(); // _ZN7S1501C43v45Ev
  virtual void  v46(); // _ZN7S1501C43v46Ev
  virtual void  v47(); // _ZN7S1501C43v47Ev
  virtual void  v48(); // _ZN7S1501C43v48Ev
  virtual void  v49(); // _ZN7S1501C43v49Ev
  virtual void  v50(); // _ZN7S1501C43v50Ev
  virtual void  v51(); // _ZN7S1501C43v51Ev
  virtual void  v52(); // _ZN7S1501C43v52Ev
  virtual void  v53(); // _ZN7S1501C43v53Ev
  virtual void  v54(); // _ZN7S1501C43v54Ev
  virtual void  v55(); // _ZN7S1501C43v55Ev
  virtual void  v56(); // _ZN7S1501C43v56Ev
  virtual void  v57(); // _ZN7S1501C43v57Ev
  virtual void  v58(); // _ZN7S1501C43v58Ev
  virtual void  v59(); // _ZN7S1501C43v59Ev
  virtual void  v60(); // _ZN7S1501C43v60Ev
  virtual void  v61(); // _ZN7S1501C43v61Ev
  virtual void  v62(); // _ZN7S1501C43v62Ev
  virtual void  v63(); // _ZN7S1501C43v63Ev
  virtual void  v64(); // _ZN7S1501C43v64Ev
  virtual void  v65(); // _ZN7S1501C43v65Ev
  virtual void  v66(); // _ZN7S1501C43v66Ev
  virtual void  v67(); // _ZN7S1501C43v67Ev
  virtual void  v68(); // _ZN7S1501C43v68Ev
  virtual void  v69(); // _ZN7S1501C43v69Ev
  S1501C4(); // tgen
};
//SIG(-1 S1501C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1501C4 ::~S1501C4(){ note_dtor("S1501C4", this);}
void  S1501C4 ::v6(){vfunc_called(this, "_ZN7S1501C42v6Ev");}
void  S1501C4 ::v7(){vfunc_called(this, "_ZN7S1501C42v7Ev");}
void  S1501C4 ::v8(){vfunc_called(this, "_ZN7S1501C42v8Ev");}
void  S1501C4 ::v9(){vfunc_called(this, "_ZN7S1501C42v9Ev");}
void  S1501C4 ::v10(){vfunc_called(this, "_ZN7S1501C43v10Ev");}
void  S1501C4 ::v11(){vfunc_called(this, "_ZN7S1501C43v11Ev");}
void  S1501C4 ::v12(){vfunc_called(this, "_ZN7S1501C43v12Ev");}
void  S1501C4 ::v13(){vfunc_called(this, "_ZN7S1501C43v13Ev");}
void  S1501C4 ::v14(){vfunc_called(this, "_ZN7S1501C43v14Ev");}
void  S1501C4 ::v15(){vfunc_called(this, "_ZN7S1501C43v15Ev");}
void  S1501C4 ::v16(){vfunc_called(this, "_ZN7S1501C43v16Ev");}
void  S1501C4 ::v17(){vfunc_called(this, "_ZN7S1501C43v17Ev");}
void  S1501C4 ::v18(){vfunc_called(this, "_ZN7S1501C43v18Ev");}
void  S1501C4 ::v19(){vfunc_called(this, "_ZN7S1501C43v19Ev");}
void  S1501C4 ::v20(){vfunc_called(this, "_ZN7S1501C43v20Ev");}
void  S1501C4 ::v21(){vfunc_called(this, "_ZN7S1501C43v21Ev");}
void  S1501C4 ::v22(){vfunc_called(this, "_ZN7S1501C43v22Ev");}
void  S1501C4 ::v23(){vfunc_called(this, "_ZN7S1501C43v23Ev");}
void  S1501C4 ::v24(){vfunc_called(this, "_ZN7S1501C43v24Ev");}
void  S1501C4 ::v25(){vfunc_called(this, "_ZN7S1501C43v25Ev");}
void  S1501C4 ::v26(){vfunc_called(this, "_ZN7S1501C43v26Ev");}
void  S1501C4 ::v27(){vfunc_called(this, "_ZN7S1501C43v27Ev");}
void  S1501C4 ::v28(){vfunc_called(this, "_ZN7S1501C43v28Ev");}
void  S1501C4 ::v29(){vfunc_called(this, "_ZN7S1501C43v29Ev");}
void  S1501C4 ::v30(){vfunc_called(this, "_ZN7S1501C43v30Ev");}
void  S1501C4 ::v31(){vfunc_called(this, "_ZN7S1501C43v31Ev");}
void  S1501C4 ::v32(){vfunc_called(this, "_ZN7S1501C43v32Ev");}
void  S1501C4 ::v33(){vfunc_called(this, "_ZN7S1501C43v33Ev");}
void  S1501C4 ::v34(){vfunc_called(this, "_ZN7S1501C43v34Ev");}
void  S1501C4 ::v35(){vfunc_called(this, "_ZN7S1501C43v35Ev");}
void  S1501C4 ::v36(){vfunc_called(this, "_ZN7S1501C43v36Ev");}
void  S1501C4 ::v37(){vfunc_called(this, "_ZN7S1501C43v37Ev");}
void  S1501C4 ::v38(){vfunc_called(this, "_ZN7S1501C43v38Ev");}
void  S1501C4 ::v39(){vfunc_called(this, "_ZN7S1501C43v39Ev");}
void  S1501C4 ::v40(){vfunc_called(this, "_ZN7S1501C43v40Ev");}
void  S1501C4 ::v41(){vfunc_called(this, "_ZN7S1501C43v41Ev");}
void  S1501C4 ::v42(){vfunc_called(this, "_ZN7S1501C43v42Ev");}
void  S1501C4 ::v43(){vfunc_called(this, "_ZN7S1501C43v43Ev");}
void  S1501C4 ::v44(){vfunc_called(this, "_ZN7S1501C43v44Ev");}
void  S1501C4 ::v45(){vfunc_called(this, "_ZN7S1501C43v45Ev");}
void  S1501C4 ::v46(){vfunc_called(this, "_ZN7S1501C43v46Ev");}
void  S1501C4 ::v47(){vfunc_called(this, "_ZN7S1501C43v47Ev");}
void  S1501C4 ::v48(){vfunc_called(this, "_ZN7S1501C43v48Ev");}
void  S1501C4 ::v49(){vfunc_called(this, "_ZN7S1501C43v49Ev");}
void  S1501C4 ::v50(){vfunc_called(this, "_ZN7S1501C43v50Ev");}
void  S1501C4 ::v51(){vfunc_called(this, "_ZN7S1501C43v51Ev");}
void  S1501C4 ::v52(){vfunc_called(this, "_ZN7S1501C43v52Ev");}
void  S1501C4 ::v53(){vfunc_called(this, "_ZN7S1501C43v53Ev");}
void  S1501C4 ::v54(){vfunc_called(this, "_ZN7S1501C43v54Ev");}
void  S1501C4 ::v55(){vfunc_called(this, "_ZN7S1501C43v55Ev");}
void  S1501C4 ::v56(){vfunc_called(this, "_ZN7S1501C43v56Ev");}
void  S1501C4 ::v57(){vfunc_called(this, "_ZN7S1501C43v57Ev");}
void  S1501C4 ::v58(){vfunc_called(this, "_ZN7S1501C43v58Ev");}
void  S1501C4 ::v59(){vfunc_called(this, "_ZN7S1501C43v59Ev");}
void  S1501C4 ::v60(){vfunc_called(this, "_ZN7S1501C43v60Ev");}
void  S1501C4 ::v61(){vfunc_called(this, "_ZN7S1501C43v61Ev");}
void  S1501C4 ::v62(){vfunc_called(this, "_ZN7S1501C43v62Ev");}
void  S1501C4 ::v63(){vfunc_called(this, "_ZN7S1501C43v63Ev");}
void  S1501C4 ::v64(){vfunc_called(this, "_ZN7S1501C43v64Ev");}
void  S1501C4 ::v65(){vfunc_called(this, "_ZN7S1501C43v65Ev");}
void  S1501C4 ::v66(){vfunc_called(this, "_ZN7S1501C43v66Ev");}
void  S1501C4 ::v67(){vfunc_called(this, "_ZN7S1501C43v67Ev");}
void  S1501C4 ::v68(){vfunc_called(this, "_ZN7S1501C43v68Ev");}
void  S1501C4 ::v69(){vfunc_called(this, "_ZN7S1501C43v69Ev");}
S1501C4 ::S1501C4(){ note_ctor("S1501C4", this);} // tgen

static void Test_S1501C4()
{
  extern Class_Descriptor cd_S1501C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1501C4, buf);
    S1501C4 *dp, &lv = *(dp=new (buf) S1501C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1501C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C4)");
    check_field_offset(lv, s1501c4f0, ABISELECT(8,4), "S1501C4.s1501c4f0");
    check_field_offset(lv, s1501c4f1, ABISELECT(16,8), "S1501C4.s1501c4f1");
    check_field_offset(lv, s1501c4f2, ABISELECT(24,16), "S1501C4.s1501c4f2");
    check_field_offset(lv, s1501c4f3, ABISELECT(56,32), "S1501C4.s1501c4f3");
    check_field_offset(lv, s1501c4f4, ABISELECT(64,40), "S1501C4.s1501c4f4");
    check_field_offset(lv, s1501c4f5, ABISELECT(72,44), "S1501C4.s1501c4f5");
    check_field_offset(lv, s1501c4f6, ABISELECT(80,52), "S1501C4.s1501c4f6");
    test_class_info(&lv, &cd_S1501C4);
    dp->~S1501C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C4(Test_S1501C4, "S1501C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1501C4C1Ev();
extern void _ZN7S1501C4D1Ev();
Name_Map name_map_S1501C4[] = {
  NSPAIR(_ZN7S1501C4C1Ev),
  NSPAIR(_ZN7S1501C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1501C4[];
extern void _ZN7S1501C4D1Ev();
extern void _ZN7S1501C4D0Ev();
extern void _ZN7S1501C42v6Ev();
extern void _ZN7S1501C42v7Ev();
extern void _ZN7S1501C42v8Ev();
extern void _ZN7S1501C42v9Ev();
extern void _ZN7S1501C43v10Ev();
extern void _ZN7S1501C43v11Ev();
extern void _ZN7S1501C43v12Ev();
extern void _ZN7S1501C43v13Ev();
extern void _ZN7S1501C43v14Ev();
extern void _ZN7S1501C43v15Ev();
extern void _ZN7S1501C43v16Ev();
extern void _ZN7S1501C43v17Ev();
extern void _ZN7S1501C43v18Ev();
extern void _ZN7S1501C43v19Ev();
extern void _ZN7S1501C43v20Ev();
extern void _ZN7S1501C43v21Ev();
extern void _ZN7S1501C43v22Ev();
extern void _ZN7S1501C43v23Ev();
extern void _ZN7S1501C43v24Ev();
extern void _ZN7S1501C43v25Ev();
extern void _ZN7S1501C43v26Ev();
extern void _ZN7S1501C43v27Ev();
extern void _ZN7S1501C43v28Ev();
extern void _ZN7S1501C43v29Ev();
extern void _ZN7S1501C43v30Ev();
extern void _ZN7S1501C43v31Ev();
extern void _ZN7S1501C43v32Ev();
extern void _ZN7S1501C43v33Ev();
extern void _ZN7S1501C43v34Ev();
extern void _ZN7S1501C43v35Ev();
extern void _ZN7S1501C43v36Ev();
extern void _ZN7S1501C43v37Ev();
extern void _ZN7S1501C43v38Ev();
extern void _ZN7S1501C43v39Ev();
extern void _ZN7S1501C43v40Ev();
extern void _ZN7S1501C43v41Ev();
extern void _ZN7S1501C43v42Ev();
extern void _ZN7S1501C43v43Ev();
extern void _ZN7S1501C43v44Ev();
extern void _ZN7S1501C43v45Ev();
extern void _ZN7S1501C43v46Ev();
extern void _ZN7S1501C43v47Ev();
extern void _ZN7S1501C43v48Ev();
extern void _ZN7S1501C43v49Ev();
extern void _ZN7S1501C43v50Ev();
extern void _ZN7S1501C43v51Ev();
extern void _ZN7S1501C43v52Ev();
extern void _ZN7S1501C43v53Ev();
extern void _ZN7S1501C43v54Ev();
extern void _ZN7S1501C43v55Ev();
extern void _ZN7S1501C43v56Ev();
extern void _ZN7S1501C43v57Ev();
extern void _ZN7S1501C43v58Ev();
extern void _ZN7S1501C43v59Ev();
extern void _ZN7S1501C43v60Ev();
extern void _ZN7S1501C43v61Ev();
extern void _ZN7S1501C43v62Ev();
extern void _ZN7S1501C43v63Ev();
extern void _ZN7S1501C43v64Ev();
extern void _ZN7S1501C43v65Ev();
extern void _ZN7S1501C43v66Ev();
extern void _ZN7S1501C43v67Ev();
extern void _ZN7S1501C43v68Ev();
extern void _ZN7S1501C43v69Ev();
static  VTBL_ENTRY vtc_S1501C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C4[0]),
  (VTBL_ENTRY)&_ZN7S1501C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1501C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1501C4[];
extern  VTBL_ENTRY _ZTV7S1501C4[];
Class_Descriptor cd_S1501C4 = {  "S1501C4", // class name
  0,0,//no base classes
  &(vtc_S1501C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1501C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1501C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C6  {
  virtual void  v70(); // _ZN7S1501C63v70Ev
  virtual void  v71(); // _ZN7S1501C63v71Ev
  virtual void  v72(); // _ZN7S1501C63v72Ev
  virtual void  v73(); // _ZN7S1501C63v73Ev
  virtual void  v74(); // _ZN7S1501C63v74Ev
  virtual void  v75(); // _ZN7S1501C63v75Ev
  virtual void  v76(); // _ZN7S1501C63v76Ev
  virtual void  v77(); // _ZN7S1501C63v77Ev
  virtual void  v78(); // _ZN7S1501C63v78Ev
  virtual void  v79(); // _ZN7S1501C63v79Ev
  virtual void  v80(); // _ZN7S1501C63v80Ev
  virtual void  v81(); // _ZN7S1501C63v81Ev
  virtual void  v82(); // _ZN7S1501C63v82Ev
  virtual void  v83(); // _ZN7S1501C63v83Ev
  virtual void  v84(); // _ZN7S1501C63v84Ev
  virtual void  v85(); // _ZN7S1501C63v85Ev
  ~S1501C6(); // tgen
  S1501C6(); // tgen
};
//SIG(-1 S1501C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1501C6 ::v70(){vfunc_called(this, "_ZN7S1501C63v70Ev");}
void  S1501C6 ::v71(){vfunc_called(this, "_ZN7S1501C63v71Ev");}
void  S1501C6 ::v72(){vfunc_called(this, "_ZN7S1501C63v72Ev");}
void  S1501C6 ::v73(){vfunc_called(this, "_ZN7S1501C63v73Ev");}
void  S1501C6 ::v74(){vfunc_called(this, "_ZN7S1501C63v74Ev");}
void  S1501C6 ::v75(){vfunc_called(this, "_ZN7S1501C63v75Ev");}
void  S1501C6 ::v76(){vfunc_called(this, "_ZN7S1501C63v76Ev");}
void  S1501C6 ::v77(){vfunc_called(this, "_ZN7S1501C63v77Ev");}
void  S1501C6 ::v78(){vfunc_called(this, "_ZN7S1501C63v78Ev");}
void  S1501C6 ::v79(){vfunc_called(this, "_ZN7S1501C63v79Ev");}
void  S1501C6 ::v80(){vfunc_called(this, "_ZN7S1501C63v80Ev");}
void  S1501C6 ::v81(){vfunc_called(this, "_ZN7S1501C63v81Ev");}
void  S1501C6 ::v82(){vfunc_called(this, "_ZN7S1501C63v82Ev");}
void  S1501C6 ::v83(){vfunc_called(this, "_ZN7S1501C63v83Ev");}
void  S1501C6 ::v84(){vfunc_called(this, "_ZN7S1501C63v84Ev");}
void  S1501C6 ::v85(){vfunc_called(this, "_ZN7S1501C63v85Ev");}
S1501C6 ::~S1501C6(){ note_dtor("S1501C6", this);} // tgen
S1501C6 ::S1501C6(){ note_ctor("S1501C6", this);} // tgen

static void Test_S1501C6()
{
  extern Class_Descriptor cd_S1501C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1501C6, buf);
    S1501C6 *dp, &lv = *(dp=new (buf) S1501C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1501C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C6)");
    test_class_info(&lv, &cd_S1501C6);
    dp->~S1501C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C6(Test_S1501C6, "S1501C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1501C6C1Ev();
extern void _ZN7S1501C6D1Ev();
Name_Map name_map_S1501C6[] = {
  NSPAIR(_ZN7S1501C6C1Ev),
  NSPAIR(_ZN7S1501C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1501C6[];
extern void _ZN7S1501C63v70Ev();
extern void _ZN7S1501C63v71Ev();
extern void _ZN7S1501C63v72Ev();
extern void _ZN7S1501C63v73Ev();
extern void _ZN7S1501C63v74Ev();
extern void _ZN7S1501C63v75Ev();
extern void _ZN7S1501C63v76Ev();
extern void _ZN7S1501C63v77Ev();
extern void _ZN7S1501C63v78Ev();
extern void _ZN7S1501C63v79Ev();
extern void _ZN7S1501C63v80Ev();
extern void _ZN7S1501C63v81Ev();
extern void _ZN7S1501C63v82Ev();
extern void _ZN7S1501C63v83Ev();
extern void _ZN7S1501C63v84Ev();
extern void _ZN7S1501C63v85Ev();
static  VTBL_ENTRY vtc_S1501C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C6[0]),
  (VTBL_ENTRY)&_ZN7S1501C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v85Ev,
};
extern VTBL_ENTRY _ZTI7S1501C6[];
extern  VTBL_ENTRY _ZTV7S1501C6[];
Class_Descriptor cd_S1501C6 = {  "S1501C6", // class name
  0,0,//no base classes
  &(vtc_S1501C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1501C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1501C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C7  {
  virtual void  v86(); // _ZN7S1501C73v86Ev
  virtual void  v87(); // _ZN7S1501C73v87Ev
  virtual void  v88(); // _ZN7S1501C73v88Ev
  virtual void  v89(); // _ZN7S1501C73v89Ev
  virtual void  v90(); // _ZN7S1501C73v90Ev
  virtual void  v91(); // _ZN7S1501C73v91Ev
  virtual void  v92(); // _ZN7S1501C73v92Ev
  virtual void  v93(); // _ZN7S1501C73v93Ev
  virtual void  v94(); // _ZN7S1501C73v94Ev
  ~S1501C7(); // tgen
  S1501C7(); // tgen
};
//SIG(-1 S1501C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1501C7 ::v86(){vfunc_called(this, "_ZN7S1501C73v86Ev");}
void  S1501C7 ::v87(){vfunc_called(this, "_ZN7S1501C73v87Ev");}
void  S1501C7 ::v88(){vfunc_called(this, "_ZN7S1501C73v88Ev");}
void  S1501C7 ::v89(){vfunc_called(this, "_ZN7S1501C73v89Ev");}
void  S1501C7 ::v90(){vfunc_called(this, "_ZN7S1501C73v90Ev");}
void  S1501C7 ::v91(){vfunc_called(this, "_ZN7S1501C73v91Ev");}
void  S1501C7 ::v92(){vfunc_called(this, "_ZN7S1501C73v92Ev");}
void  S1501C7 ::v93(){vfunc_called(this, "_ZN7S1501C73v93Ev");}
void  S1501C7 ::v94(){vfunc_called(this, "_ZN7S1501C73v94Ev");}
S1501C7 ::~S1501C7(){ note_dtor("S1501C7", this);} // tgen
S1501C7 ::S1501C7(){ note_ctor("S1501C7", this);} // tgen

static void Test_S1501C7()
{
  extern Class_Descriptor cd_S1501C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1501C7, buf);
    S1501C7 *dp, &lv = *(dp=new (buf) S1501C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1501C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C7)");
    test_class_info(&lv, &cd_S1501C7);
    dp->~S1501C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C7(Test_S1501C7, "S1501C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1501C7C1Ev();
extern void _ZN7S1501C7D1Ev();
Name_Map name_map_S1501C7[] = {
  NSPAIR(_ZN7S1501C7C1Ev),
  NSPAIR(_ZN7S1501C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1501C7[];
extern void _ZN7S1501C73v86Ev();
extern void _ZN7S1501C73v87Ev();
extern void _ZN7S1501C73v88Ev();
extern void _ZN7S1501C73v89Ev();
extern void _ZN7S1501C73v90Ev();
extern void _ZN7S1501C73v91Ev();
extern void _ZN7S1501C73v92Ev();
extern void _ZN7S1501C73v93Ev();
extern void _ZN7S1501C73v94Ev();
static  VTBL_ENTRY vtc_S1501C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C7[0]),
  (VTBL_ENTRY)&_ZN7S1501C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1501C7[];
extern  VTBL_ENTRY _ZTV7S1501C7[];
Class_Descriptor cd_S1501C7 = {  "S1501C7", // class name
  0,0,//no base classes
  &(vtc_S1501C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1501C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1501C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C3  : S1501C4 , S1501C6 , S1501C7 {
  void *s1501c3f0;
  ::S79C39_nt s1501c3f1;
  unsigned int s1501c3f2:1;
  unsigned int s1501c3f3:1;
  unsigned int s1501c3f4:1;
  unsigned int s1501c3f5:1;
  virtual  ~S1501C3(); // _ZN7S1501C3D1Ev
  virtual void  v95(); // _ZN7S1501C33v95Ev
  virtual void  v96(); // _ZN7S1501C33v96Ev
  virtual void  v97(); // _ZN7S1501C33v97Ev
  virtual void  v98(); // _ZN7S1501C33v98Ev
  virtual void  v99(); // _ZN7S1501C33v99Ev
  virtual void  v100(); // _ZN7S1501C34v100Ev
  virtual void  v101(); // _ZN7S1501C34v101Ev
  virtual void  v102(); // _ZN7S1501C34v102Ev
  virtual void  v103(); // _ZN7S1501C34v103Ev
  virtual void  v104(); // _ZN7S1501C34v104Ev
  virtual void  v105(); // _ZN7S1501C34v105Ev
  virtual void  v106(); // _ZN7S1501C34v106Ev
  virtual void  v107(); // _ZN7S1501C34v107Ev
  virtual void  v108(); // _ZN7S1501C34v108Ev
  virtual void  v109(); // _ZN7S1501C34v109Ev
  virtual void  v110(); // _ZN7S1501C34v110Ev
  virtual void  v111(); // _ZN7S1501C34v111Ev
  virtual void  v112(); // _ZN7S1501C34v112Ev
  virtual void  v113(); // _ZN7S1501C34v113Ev
  virtual void  v114(); // _ZN7S1501C34v114Ev
  virtual void  v115(); // _ZN7S1501C34v115Ev
  virtual void  v116(); // _ZN7S1501C34v116Ev
  virtual void  v117(); // _ZN7S1501C34v117Ev
  virtual void  v118(); // _ZN7S1501C34v118Ev
  S1501C3(); // tgen
};
//SIG(-1 S1501C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1501C3 ::~S1501C3(){ note_dtor("S1501C3", this);}
void  S1501C3 ::v95(){vfunc_called(this, "_ZN7S1501C33v95Ev");}
void  S1501C3 ::v96(){vfunc_called(this, "_ZN7S1501C33v96Ev");}
void  S1501C3 ::v97(){vfunc_called(this, "_ZN7S1501C33v97Ev");}
void  S1501C3 ::v98(){vfunc_called(this, "_ZN7S1501C33v98Ev");}
void  S1501C3 ::v99(){vfunc_called(this, "_ZN7S1501C33v99Ev");}
void  S1501C3 ::v100(){vfunc_called(this, "_ZN7S1501C34v100Ev");}
void  S1501C3 ::v101(){vfunc_called(this, "_ZN7S1501C34v101Ev");}
void  S1501C3 ::v102(){vfunc_called(this, "_ZN7S1501C34v102Ev");}
void  S1501C3 ::v103(){vfunc_called(this, "_ZN7S1501C34v103Ev");}
void  S1501C3 ::v104(){vfunc_called(this, "_ZN7S1501C34v104Ev");}
void  S1501C3 ::v105(){vfunc_called(this, "_ZN7S1501C34v105Ev");}
void  S1501C3 ::v106(){vfunc_called(this, "_ZN7S1501C34v106Ev");}
void  S1501C3 ::v107(){vfunc_called(this, "_ZN7S1501C34v107Ev");}
void  S1501C3 ::v108(){vfunc_called(this, "_ZN7S1501C34v108Ev");}
void  S1501C3 ::v109(){vfunc_called(this, "_ZN7S1501C34v109Ev");}
void  S1501C3 ::v110(){vfunc_called(this, "_ZN7S1501C34v110Ev");}
void  S1501C3 ::v111(){vfunc_called(this, "_ZN7S1501C34v111Ev");}
void  S1501C3 ::v112(){vfunc_called(this, "_ZN7S1501C34v112Ev");}
void  S1501C3 ::v113(){vfunc_called(this, "_ZN7S1501C34v113Ev");}
void  S1501C3 ::v114(){vfunc_called(this, "_ZN7S1501C34v114Ev");}
void  S1501C3 ::v115(){vfunc_called(this, "_ZN7S1501C34v115Ev");}
void  S1501C3 ::v116(){vfunc_called(this, "_ZN7S1501C34v116Ev");}
void  S1501C3 ::v117(){vfunc_called(this, "_ZN7S1501C34v117Ev");}
void  S1501C3 ::v118(){vfunc_called(this, "_ZN7S1501C34v118Ev");}
S1501C3 ::S1501C3(){ note_ctor("S1501C3", this);} // tgen

static void Test_S1501C3()
{
  extern Class_Descriptor cd_S1501C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1501C3, buf);
    S1501C3 *dp, &lv = *(dp=new (buf) S1501C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1501C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C3)");
    check_base_class_offset(lv, (S1501C4*), 0, "S1501C3");
    check_base_class_offset(lv, (S1501C6*), ABISELECT(96,60), "S1501C3");
    check_base_class_offset(lv, (S1501C7*), ABISELECT(104,64), "S1501C3");
    check_field_offset(lv, s1501c3f0, ABISELECT(112,68), "S1501C3.s1501c3f0");
    check_field_offset(lv, s1501c3f1, ABISELECT(120,72), "S1501C3.s1501c3f1");
    set_bf_and_test(lv, s1501c3f2, ABISELECT(136,84), 0, 1, 1, "S1501C3");
    set_bf_and_test(lv, s1501c3f3, ABISELECT(136,84), 1, 1, 1, "S1501C3");
    set_bf_and_test(lv, s1501c3f4, ABISELECT(136,84), 2, 1, 1, "S1501C3");
    set_bf_and_test(lv, s1501c3f5, ABISELECT(136,84), 3, 1, 1, "S1501C3");
    test_class_info(&lv, &cd_S1501C3);
    dp->~S1501C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C3(Test_S1501C3, "S1501C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1501C3C1Ev();
extern void _ZN7S1501C3D1Ev();
Name_Map name_map_S1501C3[] = {
  NSPAIR(_ZN7S1501C3C1Ev),
  NSPAIR(_ZN7S1501C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1501C4;
extern VTBL_ENTRY _ZTI7S1501C4[];
extern  VTBL_ENTRY _ZTV7S1501C4[];
extern Class_Descriptor cd_S1501C6;
extern VTBL_ENTRY _ZTI7S1501C6[];
extern  VTBL_ENTRY _ZTV7S1501C6[];
extern Class_Descriptor cd_S1501C7;
extern VTBL_ENTRY _ZTI7S1501C7[];
extern  VTBL_ENTRY _ZTV7S1501C7[];
static Base_Class bases_S1501C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1501C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1501C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1501C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1501C3[];
extern void _ZN7S1501C3D1Ev();
extern void _ZN7S1501C3D0Ev();
extern void _ZN7S1501C42v6Ev();
extern void _ZN7S1501C42v7Ev();
extern void _ZN7S1501C42v8Ev();
extern void _ZN7S1501C42v9Ev();
extern void _ZN7S1501C43v10Ev();
extern void _ZN7S1501C43v11Ev();
extern void _ZN7S1501C43v12Ev();
extern void _ZN7S1501C43v13Ev();
extern void _ZN7S1501C43v14Ev();
extern void _ZN7S1501C43v15Ev();
extern void _ZN7S1501C43v16Ev();
extern void _ZN7S1501C43v17Ev();
extern void _ZN7S1501C43v18Ev();
extern void _ZN7S1501C43v19Ev();
extern void _ZN7S1501C43v20Ev();
extern void _ZN7S1501C43v21Ev();
extern void _ZN7S1501C43v22Ev();
extern void _ZN7S1501C43v23Ev();
extern void _ZN7S1501C43v24Ev();
extern void _ZN7S1501C43v25Ev();
extern void _ZN7S1501C43v26Ev();
extern void _ZN7S1501C43v27Ev();
extern void _ZN7S1501C43v28Ev();
extern void _ZN7S1501C43v29Ev();
extern void _ZN7S1501C43v30Ev();
extern void _ZN7S1501C43v31Ev();
extern void _ZN7S1501C43v32Ev();
extern void _ZN7S1501C43v33Ev();
extern void _ZN7S1501C43v34Ev();
extern void _ZN7S1501C43v35Ev();
extern void _ZN7S1501C43v36Ev();
extern void _ZN7S1501C43v37Ev();
extern void _ZN7S1501C43v38Ev();
extern void _ZN7S1501C43v39Ev();
extern void _ZN7S1501C43v40Ev();
extern void _ZN7S1501C43v41Ev();
extern void _ZN7S1501C43v42Ev();
extern void _ZN7S1501C43v43Ev();
extern void _ZN7S1501C43v44Ev();
extern void _ZN7S1501C43v45Ev();
extern void _ZN7S1501C43v46Ev();
extern void _ZN7S1501C43v47Ev();
extern void _ZN7S1501C43v48Ev();
extern void _ZN7S1501C43v49Ev();
extern void _ZN7S1501C43v50Ev();
extern void _ZN7S1501C43v51Ev();
extern void _ZN7S1501C43v52Ev();
extern void _ZN7S1501C43v53Ev();
extern void _ZN7S1501C43v54Ev();
extern void _ZN7S1501C43v55Ev();
extern void _ZN7S1501C43v56Ev();
extern void _ZN7S1501C43v57Ev();
extern void _ZN7S1501C43v58Ev();
extern void _ZN7S1501C43v59Ev();
extern void _ZN7S1501C43v60Ev();
extern void _ZN7S1501C43v61Ev();
extern void _ZN7S1501C43v62Ev();
extern void _ZN7S1501C43v63Ev();
extern void _ZN7S1501C43v64Ev();
extern void _ZN7S1501C43v65Ev();
extern void _ZN7S1501C43v66Ev();
extern void _ZN7S1501C43v67Ev();
extern void _ZN7S1501C43v68Ev();
extern void _ZN7S1501C43v69Ev();
extern void _ZN7S1501C33v95Ev();
extern void _ZN7S1501C33v96Ev();
extern void _ZN7S1501C33v97Ev();
extern void _ZN7S1501C33v98Ev();
extern void _ZN7S1501C33v99Ev();
extern void _ZN7S1501C34v100Ev();
extern void _ZN7S1501C34v101Ev();
extern void _ZN7S1501C34v102Ev();
extern void _ZN7S1501C34v103Ev();
extern void _ZN7S1501C34v104Ev();
extern void _ZN7S1501C34v105Ev();
extern void _ZN7S1501C34v106Ev();
extern void _ZN7S1501C34v107Ev();
extern void _ZN7S1501C34v108Ev();
extern void _ZN7S1501C34v109Ev();
extern void _ZN7S1501C34v110Ev();
extern void _ZN7S1501C34v111Ev();
extern void _ZN7S1501C34v112Ev();
extern void _ZN7S1501C34v113Ev();
extern void _ZN7S1501C34v114Ev();
extern void _ZN7S1501C34v115Ev();
extern void _ZN7S1501C34v116Ev();
extern void _ZN7S1501C34v117Ev();
extern void _ZN7S1501C34v118Ev();
extern void _ZN7S1501C63v70Ev();
extern void _ZN7S1501C63v71Ev();
extern void _ZN7S1501C63v72Ev();
extern void _ZN7S1501C63v73Ev();
extern void _ZN7S1501C63v74Ev();
extern void _ZN7S1501C63v75Ev();
extern void _ZN7S1501C63v76Ev();
extern void _ZN7S1501C63v77Ev();
extern void _ZN7S1501C63v78Ev();
extern void _ZN7S1501C63v79Ev();
extern void _ZN7S1501C63v80Ev();
extern void _ZN7S1501C63v81Ev();
extern void _ZN7S1501C63v82Ev();
extern void _ZN7S1501C63v83Ev();
extern void _ZN7S1501C63v84Ev();
extern void _ZN7S1501C63v85Ev();
extern void _ZN7S1501C73v86Ev();
extern void _ZN7S1501C73v87Ev();
extern void _ZN7S1501C73v88Ev();
extern void _ZN7S1501C73v89Ev();
extern void _ZN7S1501C73v90Ev();
extern void _ZN7S1501C73v91Ev();
extern void _ZN7S1501C73v92Ev();
extern void _ZN7S1501C73v93Ev();
extern void _ZN7S1501C73v94Ev();
static  VTBL_ENTRY vtc_S1501C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C3[0]),
  (VTBL_ENTRY)&_ZN7S1501C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1501C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v118Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1501C3[0]),
  (VTBL_ENTRY)&_ZN7S1501C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1501C3[0]),
  (VTBL_ENTRY)&_ZN7S1501C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1501C3[];
extern  VTBL_ENTRY _ZTV7S1501C3[];
Class_Descriptor cd_S1501C3 = {  "S1501C3", // class name
  bases_S1501C3, 3,
  &(vtc_S1501C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1501C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1501C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C2  : S1501C3 {
  ::S3262C11_nt s1501c2f0;
  int s1501c2f1;
  virtual  ~S1501C2(); // _ZN7S1501C2D1Ev
  virtual void  v119(); // _ZN7S1501C24v119Ev
  virtual void  v120(); // _ZN7S1501C24v120Ev
  virtual void  v121(); // _ZN7S1501C24v121Ev
  virtual void  v122(); // _ZN7S1501C24v122Ev
  virtual void  v123(); // _ZN7S1501C24v123Ev
  virtual void  v124(); // _ZN7S1501C24v124Ev
  virtual void  v125(); // _ZN7S1501C24v125Ev
  virtual void  v126(); // _ZN7S1501C24v126Ev
  virtual void  v127(); // _ZN7S1501C24v127Ev
  virtual void  v128(); // _ZN7S1501C24v128Ev
  virtual void  v129(); // _ZN7S1501C24v129Ev
  virtual void  v130(); // _ZN7S1501C24v130Ev
  virtual void  v131(); // _ZN7S1501C24v131Ev
  virtual void  v132(); // _ZN7S1501C24v132Ev
  virtual void  v133(); // _ZN7S1501C24v133Ev
  virtual void  v134(); // _ZN7S1501C24v134Ev
  virtual void  v135(); // _ZN7S1501C24v135Ev
  virtual void  v136(); // _ZN7S1501C24v136Ev
  virtual void  v137(); // _ZN7S1501C24v137Ev
  virtual void  v138(); // _ZN7S1501C24v138Ev
  virtual void  v139(); // _ZN7S1501C24v139Ev
  virtual void  v140(); // _ZN7S1501C24v140Ev
  virtual void  v141(); // _ZN7S1501C24v141Ev
  virtual void  v142(); // _ZN7S1501C24v142Ev
  virtual void  v143(); // _ZN7S1501C24v143Ev
  virtual void  v144(); // _ZN7S1501C24v144Ev
  virtual void  v145(); // _ZN7S1501C24v145Ev
  S1501C2(); // tgen
};
//SIG(-1 S1501C2) C1{ BC2{ BC3{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107} BC6{ v108 v109 v110 v111 v112 v113 v114 v115 v116} vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1501C2 ::~S1501C2(){ note_dtor("S1501C2", this);}
void  S1501C2 ::v119(){vfunc_called(this, "_ZN7S1501C24v119Ev");}
void  S1501C2 ::v120(){vfunc_called(this, "_ZN7S1501C24v120Ev");}
void  S1501C2 ::v121(){vfunc_called(this, "_ZN7S1501C24v121Ev");}
void  S1501C2 ::v122(){vfunc_called(this, "_ZN7S1501C24v122Ev");}
void  S1501C2 ::v123(){vfunc_called(this, "_ZN7S1501C24v123Ev");}
void  S1501C2 ::v124(){vfunc_called(this, "_ZN7S1501C24v124Ev");}
void  S1501C2 ::v125(){vfunc_called(this, "_ZN7S1501C24v125Ev");}
void  S1501C2 ::v126(){vfunc_called(this, "_ZN7S1501C24v126Ev");}
void  S1501C2 ::v127(){vfunc_called(this, "_ZN7S1501C24v127Ev");}
void  S1501C2 ::v128(){vfunc_called(this, "_ZN7S1501C24v128Ev");}
void  S1501C2 ::v129(){vfunc_called(this, "_ZN7S1501C24v129Ev");}
void  S1501C2 ::v130(){vfunc_called(this, "_ZN7S1501C24v130Ev");}
void  S1501C2 ::v131(){vfunc_called(this, "_ZN7S1501C24v131Ev");}
void  S1501C2 ::v132(){vfunc_called(this, "_ZN7S1501C24v132Ev");}
void  S1501C2 ::v133(){vfunc_called(this, "_ZN7S1501C24v133Ev");}
void  S1501C2 ::v134(){vfunc_called(this, "_ZN7S1501C24v134Ev");}
void  S1501C2 ::v135(){vfunc_called(this, "_ZN7S1501C24v135Ev");}
void  S1501C2 ::v136(){vfunc_called(this, "_ZN7S1501C24v136Ev");}
void  S1501C2 ::v137(){vfunc_called(this, "_ZN7S1501C24v137Ev");}
void  S1501C2 ::v138(){vfunc_called(this, "_ZN7S1501C24v138Ev");}
void  S1501C2 ::v139(){vfunc_called(this, "_ZN7S1501C24v139Ev");}
void  S1501C2 ::v140(){vfunc_called(this, "_ZN7S1501C24v140Ev");}
void  S1501C2 ::v141(){vfunc_called(this, "_ZN7S1501C24v141Ev");}
void  S1501C2 ::v142(){vfunc_called(this, "_ZN7S1501C24v142Ev");}
void  S1501C2 ::v143(){vfunc_called(this, "_ZN7S1501C24v143Ev");}
void  S1501C2 ::v144(){vfunc_called(this, "_ZN7S1501C24v144Ev");}
void  S1501C2 ::v145(){vfunc_called(this, "_ZN7S1501C24v145Ev");}
S1501C2 ::S1501C2(){ note_ctor("S1501C2", this);} // tgen

static void Test_S1501C2()
{
  extern Class_Descriptor cd_S1501C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1501C2, buf);
    S1501C2 *dp, &lv = *(dp=new (buf) S1501C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1501C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C2)");
    check_base_class_offset(lv, (S1501C4*)(S1501C3*), 0, "S1501C2");
    check_base_class_offset(lv, (S1501C6*)(S1501C3*), ABISELECT(96,60), "S1501C2");
    check_base_class_offset(lv, (S1501C7*)(S1501C3*), ABISELECT(104,64), "S1501C2");
    check_base_class_offset(lv, (S1501C3*), 0, "S1501C2");
    check_field_offset(lv, s1501c2f0, ABISELECT(144,88), "S1501C2.s1501c2f0");
    check_field_offset(lv, s1501c2f1, ABISELECT(168,104), "S1501C2.s1501c2f1");
    test_class_info(&lv, &cd_S1501C2);
    dp->~S1501C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C2(Test_S1501C2, "S1501C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1501C2C1Ev();
extern void _ZN7S1501C2D1Ev();
Name_Map name_map_S1501C2[] = {
  NSPAIR(_ZN7S1501C2C1Ev),
  NSPAIR(_ZN7S1501C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1501C4;
extern VTBL_ENTRY _ZTI7S1501C4[];
extern  VTBL_ENTRY _ZTV7S1501C4[];
extern Class_Descriptor cd_S1501C6;
extern VTBL_ENTRY _ZTI7S1501C6[];
extern  VTBL_ENTRY _ZTV7S1501C6[];
extern Class_Descriptor cd_S1501C7;
extern VTBL_ENTRY _ZTI7S1501C7[];
extern  VTBL_ENTRY _ZTV7S1501C7[];
extern Class_Descriptor cd_S1501C3;
extern VTBL_ENTRY _ZTI7S1501C3[];
extern  VTBL_ENTRY _ZTV7S1501C3[];
static Base_Class bases_S1501C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1501C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C6,    ABISELECT(96,60), //bcp->offset
    119, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C7,    ABISELECT(104,64), //bcp->offset
    137, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1501C2[];
extern void _ZN7S1501C2D1Ev();
extern void _ZN7S1501C2D0Ev();
extern void _ZN7S1501C42v6Ev();
extern void _ZN7S1501C42v7Ev();
extern void _ZN7S1501C42v8Ev();
extern void _ZN7S1501C42v9Ev();
extern void _ZN7S1501C43v10Ev();
extern void _ZN7S1501C43v11Ev();
extern void _ZN7S1501C43v12Ev();
extern void _ZN7S1501C43v13Ev();
extern void _ZN7S1501C43v14Ev();
extern void _ZN7S1501C43v15Ev();
extern void _ZN7S1501C43v16Ev();
extern void _ZN7S1501C43v17Ev();
extern void _ZN7S1501C43v18Ev();
extern void _ZN7S1501C43v19Ev();
extern void _ZN7S1501C43v20Ev();
extern void _ZN7S1501C43v21Ev();
extern void _ZN7S1501C43v22Ev();
extern void _ZN7S1501C43v23Ev();
extern void _ZN7S1501C43v24Ev();
extern void _ZN7S1501C43v25Ev();
extern void _ZN7S1501C43v26Ev();
extern void _ZN7S1501C43v27Ev();
extern void _ZN7S1501C43v28Ev();
extern void _ZN7S1501C43v29Ev();
extern void _ZN7S1501C43v30Ev();
extern void _ZN7S1501C43v31Ev();
extern void _ZN7S1501C43v32Ev();
extern void _ZN7S1501C43v33Ev();
extern void _ZN7S1501C43v34Ev();
extern void _ZN7S1501C43v35Ev();
extern void _ZN7S1501C43v36Ev();
extern void _ZN7S1501C43v37Ev();
extern void _ZN7S1501C43v38Ev();
extern void _ZN7S1501C43v39Ev();
extern void _ZN7S1501C43v40Ev();
extern void _ZN7S1501C43v41Ev();
extern void _ZN7S1501C43v42Ev();
extern void _ZN7S1501C43v43Ev();
extern void _ZN7S1501C43v44Ev();
extern void _ZN7S1501C43v45Ev();
extern void _ZN7S1501C43v46Ev();
extern void _ZN7S1501C43v47Ev();
extern void _ZN7S1501C43v48Ev();
extern void _ZN7S1501C43v49Ev();
extern void _ZN7S1501C43v50Ev();
extern void _ZN7S1501C43v51Ev();
extern void _ZN7S1501C43v52Ev();
extern void _ZN7S1501C43v53Ev();
extern void _ZN7S1501C43v54Ev();
extern void _ZN7S1501C43v55Ev();
extern void _ZN7S1501C43v56Ev();
extern void _ZN7S1501C43v57Ev();
extern void _ZN7S1501C43v58Ev();
extern void _ZN7S1501C43v59Ev();
extern void _ZN7S1501C43v60Ev();
extern void _ZN7S1501C43v61Ev();
extern void _ZN7S1501C43v62Ev();
extern void _ZN7S1501C43v63Ev();
extern void _ZN7S1501C43v64Ev();
extern void _ZN7S1501C43v65Ev();
extern void _ZN7S1501C43v66Ev();
extern void _ZN7S1501C43v67Ev();
extern void _ZN7S1501C43v68Ev();
extern void _ZN7S1501C43v69Ev();
extern void _ZN7S1501C33v95Ev();
extern void _ZN7S1501C33v96Ev();
extern void _ZN7S1501C33v97Ev();
extern void _ZN7S1501C33v98Ev();
extern void _ZN7S1501C33v99Ev();
extern void _ZN7S1501C34v100Ev();
extern void _ZN7S1501C34v101Ev();
extern void _ZN7S1501C34v102Ev();
extern void _ZN7S1501C34v103Ev();
extern void _ZN7S1501C34v104Ev();
extern void _ZN7S1501C34v105Ev();
extern void _ZN7S1501C34v106Ev();
extern void _ZN7S1501C34v107Ev();
extern void _ZN7S1501C34v108Ev();
extern void _ZN7S1501C34v109Ev();
extern void _ZN7S1501C34v110Ev();
extern void _ZN7S1501C34v111Ev();
extern void _ZN7S1501C34v112Ev();
extern void _ZN7S1501C34v113Ev();
extern void _ZN7S1501C34v114Ev();
extern void _ZN7S1501C34v115Ev();
extern void _ZN7S1501C34v116Ev();
extern void _ZN7S1501C34v117Ev();
extern void _ZN7S1501C34v118Ev();
extern void _ZN7S1501C24v119Ev();
extern void _ZN7S1501C24v120Ev();
extern void _ZN7S1501C24v121Ev();
extern void _ZN7S1501C24v122Ev();
extern void _ZN7S1501C24v123Ev();
extern void _ZN7S1501C24v124Ev();
extern void _ZN7S1501C24v125Ev();
extern void _ZN7S1501C24v126Ev();
extern void _ZN7S1501C24v127Ev();
extern void _ZN7S1501C24v128Ev();
extern void _ZN7S1501C24v129Ev();
extern void _ZN7S1501C24v130Ev();
extern void _ZN7S1501C24v131Ev();
extern void _ZN7S1501C24v132Ev();
extern void _ZN7S1501C24v133Ev();
extern void _ZN7S1501C24v134Ev();
extern void _ZN7S1501C24v135Ev();
extern void _ZN7S1501C24v136Ev();
extern void _ZN7S1501C24v137Ev();
extern void _ZN7S1501C24v138Ev();
extern void _ZN7S1501C24v139Ev();
extern void _ZN7S1501C24v140Ev();
extern void _ZN7S1501C24v141Ev();
extern void _ZN7S1501C24v142Ev();
extern void _ZN7S1501C24v143Ev();
extern void _ZN7S1501C24v144Ev();
extern void _ZN7S1501C24v145Ev();
extern void _ZN7S1501C63v70Ev();
extern void _ZN7S1501C63v71Ev();
extern void _ZN7S1501C63v72Ev();
extern void _ZN7S1501C63v73Ev();
extern void _ZN7S1501C63v74Ev();
extern void _ZN7S1501C63v75Ev();
extern void _ZN7S1501C63v76Ev();
extern void _ZN7S1501C63v77Ev();
extern void _ZN7S1501C63v78Ev();
extern void _ZN7S1501C63v79Ev();
extern void _ZN7S1501C63v80Ev();
extern void _ZN7S1501C63v81Ev();
extern void _ZN7S1501C63v82Ev();
extern void _ZN7S1501C63v83Ev();
extern void _ZN7S1501C63v84Ev();
extern void _ZN7S1501C63v85Ev();
extern void _ZN7S1501C73v86Ev();
extern void _ZN7S1501C73v87Ev();
extern void _ZN7S1501C73v88Ev();
extern void _ZN7S1501C73v89Ev();
extern void _ZN7S1501C73v90Ev();
extern void _ZN7S1501C73v91Ev();
extern void _ZN7S1501C73v92Ev();
extern void _ZN7S1501C73v93Ev();
extern void _ZN7S1501C73v94Ev();
static  VTBL_ENTRY vtc_S1501C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C2[0]),
  (VTBL_ENTRY)&_ZN7S1501C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1501C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v120Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v145Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1501C2[0]),
  (VTBL_ENTRY)&_ZN7S1501C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1501C2[0]),
  (VTBL_ENTRY)&_ZN7S1501C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1501C2[];
extern  VTBL_ENTRY _ZTV7S1501C2[];
Class_Descriptor cd_S1501C2 = {  "S1501C2", // class name
  bases_S1501C2, 4,
  &(vtc_S1501C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1501C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1501C2),148, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1501C1  : S1501C2 {
  ::S79C8_nt s1501c1f0;
  virtual  ~S1501C1(); // _ZN7S1501C1D1Ev
  virtual void  v1(); // _ZN7S1501C12v1Ev
  virtual void  v2(); // _ZN7S1501C12v2Ev
  virtual void  v3(); // _ZN7S1501C12v3Ev
  virtual void  v4(); // _ZN7S1501C12v4Ev
  virtual void  v5(); // _ZN7S1501C12v5Ev
  S1501C1(); // tgen
};
//SIG(1 S1501C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85} BC7{ v86 v87 v88 v89 v90 v91 v92 v93 v94} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 FC5}


 S1501C1 ::~S1501C1(){ note_dtor("S1501C1", this);}
void  S1501C1 ::v1(){vfunc_called(this, "_ZN7S1501C12v1Ev");}
void  S1501C1 ::v2(){vfunc_called(this, "_ZN7S1501C12v2Ev");}
void  S1501C1 ::v3(){vfunc_called(this, "_ZN7S1501C12v3Ev");}
void  S1501C1 ::v4(){vfunc_called(this, "_ZN7S1501C12v4Ev");}
void  S1501C1 ::v5(){vfunc_called(this, "_ZN7S1501C12v5Ev");}
S1501C1 ::S1501C1(){ note_ctor("S1501C1", this);} // tgen

static void Test_S1501C1()
{
  extern Class_Descriptor cd_S1501C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,30)];
    init_test(&cd_S1501C1, buf);
    S1501C1 *dp, &lv = *(dp=new (buf) S1501C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,116), "sizeof(S1501C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1501C1)");
    check_base_class_offset(lv, (S1501C4*)(S1501C3*)(S1501C2*), 0, "S1501C1");
    check_base_class_offset(lv, (S1501C6*)(S1501C3*)(S1501C2*), ABISELECT(96,60), "S1501C1");
    check_base_class_offset(lv, (S1501C7*)(S1501C3*)(S1501C2*), ABISELECT(104,64), "S1501C1");
    check_base_class_offset(lv, (S1501C3*)(S1501C2*), 0, "S1501C1");
    check_base_class_offset(lv, (S1501C2*), 0, "S1501C1");
    check_field_offset(lv, s1501c1f0, ABISELECT(172,108), "S1501C1.s1501c1f0");
    test_class_info(&lv, &cd_S1501C1);
    dp->~S1501C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1501C1(Test_S1501C1, "S1501C1", ABISELECT(184,116));

#else // __cplusplus

extern void _ZN7S1501C1C1Ev();
extern void _ZN7S1501C1D1Ev();
Name_Map name_map_S1501C1[] = {
  NSPAIR(_ZN7S1501C1C1Ev),
  NSPAIR(_ZN7S1501C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1501C4;
extern VTBL_ENTRY _ZTI7S1501C4[];
extern  VTBL_ENTRY _ZTV7S1501C4[];
extern Class_Descriptor cd_S1501C6;
extern VTBL_ENTRY _ZTI7S1501C6[];
extern  VTBL_ENTRY _ZTV7S1501C6[];
extern Class_Descriptor cd_S1501C7;
extern VTBL_ENTRY _ZTI7S1501C7[];
extern  VTBL_ENTRY _ZTV7S1501C7[];
extern Class_Descriptor cd_S1501C3;
extern VTBL_ENTRY _ZTI7S1501C3[];
extern  VTBL_ENTRY _ZTV7S1501C3[];
extern Class_Descriptor cd_S1501C2;
extern VTBL_ENTRY _ZTI7S1501C2[];
extern  VTBL_ENTRY _ZTV7S1501C2[];
static Base_Class bases_S1501C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1501C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C6,    ABISELECT(96,60), //bcp->offset
    124, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C7,    ABISELECT(104,64), //bcp->offset
    142, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1501C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1501C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1501C1[];
extern void _ZN7S1501C1D1Ev();
extern void _ZN7S1501C1D0Ev();
extern void _ZN7S1501C42v6Ev();
extern void _ZN7S1501C42v7Ev();
extern void _ZN7S1501C42v8Ev();
extern void _ZN7S1501C42v9Ev();
extern void _ZN7S1501C43v10Ev();
extern void _ZN7S1501C43v11Ev();
extern void _ZN7S1501C43v12Ev();
extern void _ZN7S1501C43v13Ev();
extern void _ZN7S1501C43v14Ev();
extern void _ZN7S1501C43v15Ev();
extern void _ZN7S1501C43v16Ev();
extern void _ZN7S1501C43v17Ev();
extern void _ZN7S1501C43v18Ev();
extern void _ZN7S1501C43v19Ev();
extern void _ZN7S1501C43v20Ev();
extern void _ZN7S1501C43v21Ev();
extern void _ZN7S1501C43v22Ev();
extern void _ZN7S1501C43v23Ev();
extern void _ZN7S1501C43v24Ev();
extern void _ZN7S1501C43v25Ev();
extern void _ZN7S1501C43v26Ev();
extern void _ZN7S1501C43v27Ev();
extern void _ZN7S1501C43v28Ev();
extern void _ZN7S1501C43v29Ev();
extern void _ZN7S1501C43v30Ev();
extern void _ZN7S1501C43v31Ev();
extern void _ZN7S1501C43v32Ev();
extern void _ZN7S1501C43v33Ev();
extern void _ZN7S1501C43v34Ev();
extern void _ZN7S1501C43v35Ev();
extern void _ZN7S1501C43v36Ev();
extern void _ZN7S1501C43v37Ev();
extern void _ZN7S1501C43v38Ev();
extern void _ZN7S1501C43v39Ev();
extern void _ZN7S1501C43v40Ev();
extern void _ZN7S1501C43v41Ev();
extern void _ZN7S1501C43v42Ev();
extern void _ZN7S1501C43v43Ev();
extern void _ZN7S1501C43v44Ev();
extern void _ZN7S1501C43v45Ev();
extern void _ZN7S1501C43v46Ev();
extern void _ZN7S1501C43v47Ev();
extern void _ZN7S1501C43v48Ev();
extern void _ZN7S1501C43v49Ev();
extern void _ZN7S1501C43v50Ev();
extern void _ZN7S1501C43v51Ev();
extern void _ZN7S1501C43v52Ev();
extern void _ZN7S1501C43v53Ev();
extern void _ZN7S1501C43v54Ev();
extern void _ZN7S1501C43v55Ev();
extern void _ZN7S1501C43v56Ev();
extern void _ZN7S1501C43v57Ev();
extern void _ZN7S1501C43v58Ev();
extern void _ZN7S1501C43v59Ev();
extern void _ZN7S1501C43v60Ev();
extern void _ZN7S1501C43v61Ev();
extern void _ZN7S1501C43v62Ev();
extern void _ZN7S1501C43v63Ev();
extern void _ZN7S1501C43v64Ev();
extern void _ZN7S1501C43v65Ev();
extern void _ZN7S1501C43v66Ev();
extern void _ZN7S1501C43v67Ev();
extern void _ZN7S1501C43v68Ev();
extern void _ZN7S1501C43v69Ev();
extern void _ZN7S1501C33v95Ev();
extern void _ZN7S1501C33v96Ev();
extern void _ZN7S1501C33v97Ev();
extern void _ZN7S1501C33v98Ev();
extern void _ZN7S1501C33v99Ev();
extern void _ZN7S1501C34v100Ev();
extern void _ZN7S1501C34v101Ev();
extern void _ZN7S1501C34v102Ev();
extern void _ZN7S1501C34v103Ev();
extern void _ZN7S1501C34v104Ev();
extern void _ZN7S1501C34v105Ev();
extern void _ZN7S1501C34v106Ev();
extern void _ZN7S1501C34v107Ev();
extern void _ZN7S1501C34v108Ev();
extern void _ZN7S1501C34v109Ev();
extern void _ZN7S1501C34v110Ev();
extern void _ZN7S1501C34v111Ev();
extern void _ZN7S1501C34v112Ev();
extern void _ZN7S1501C34v113Ev();
extern void _ZN7S1501C34v114Ev();
extern void _ZN7S1501C34v115Ev();
extern void _ZN7S1501C34v116Ev();
extern void _ZN7S1501C34v117Ev();
extern void _ZN7S1501C34v118Ev();
extern void _ZN7S1501C24v119Ev();
extern void _ZN7S1501C24v120Ev();
extern void _ZN7S1501C24v121Ev();
extern void _ZN7S1501C24v122Ev();
extern void _ZN7S1501C24v123Ev();
extern void _ZN7S1501C24v124Ev();
extern void _ZN7S1501C24v125Ev();
extern void _ZN7S1501C24v126Ev();
extern void _ZN7S1501C24v127Ev();
extern void _ZN7S1501C24v128Ev();
extern void _ZN7S1501C24v129Ev();
extern void _ZN7S1501C24v130Ev();
extern void _ZN7S1501C24v131Ev();
extern void _ZN7S1501C24v132Ev();
extern void _ZN7S1501C24v133Ev();
extern void _ZN7S1501C24v134Ev();
extern void _ZN7S1501C24v135Ev();
extern void _ZN7S1501C24v136Ev();
extern void _ZN7S1501C24v137Ev();
extern void _ZN7S1501C24v138Ev();
extern void _ZN7S1501C24v139Ev();
extern void _ZN7S1501C24v140Ev();
extern void _ZN7S1501C24v141Ev();
extern void _ZN7S1501C24v142Ev();
extern void _ZN7S1501C24v143Ev();
extern void _ZN7S1501C24v144Ev();
extern void _ZN7S1501C24v145Ev();
extern void _ZN7S1501C12v1Ev();
extern void _ZN7S1501C12v2Ev();
extern void _ZN7S1501C12v3Ev();
extern void _ZN7S1501C12v4Ev();
extern void _ZN7S1501C12v5Ev();
extern void _ZN7S1501C63v70Ev();
extern void _ZN7S1501C63v71Ev();
extern void _ZN7S1501C63v72Ev();
extern void _ZN7S1501C63v73Ev();
extern void _ZN7S1501C63v74Ev();
extern void _ZN7S1501C63v75Ev();
extern void _ZN7S1501C63v76Ev();
extern void _ZN7S1501C63v77Ev();
extern void _ZN7S1501C63v78Ev();
extern void _ZN7S1501C63v79Ev();
extern void _ZN7S1501C63v80Ev();
extern void _ZN7S1501C63v81Ev();
extern void _ZN7S1501C63v82Ev();
extern void _ZN7S1501C63v83Ev();
extern void _ZN7S1501C63v84Ev();
extern void _ZN7S1501C63v85Ev();
extern void _ZN7S1501C73v86Ev();
extern void _ZN7S1501C73v87Ev();
extern void _ZN7S1501C73v88Ev();
extern void _ZN7S1501C73v89Ev();
extern void _ZN7S1501C73v90Ev();
extern void _ZN7S1501C73v91Ev();
extern void _ZN7S1501C73v92Ev();
extern void _ZN7S1501C73v93Ev();
extern void _ZN7S1501C73v94Ev();
static  VTBL_ENTRY vtc_S1501C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1501C1[0]),
  (VTBL_ENTRY)&_ZN7S1501C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1501C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1501C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1501C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1501C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1501C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v120Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1501C24v145Ev,
  (VTBL_ENTRY)&_ZN7S1501C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1501C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1501C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1501C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1501C12v5Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1501C1[0]),
  (VTBL_ENTRY)&_ZN7S1501C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1501C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1501C1[0]),
  (VTBL_ENTRY)&_ZN7S1501C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1501C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1501C1[];
extern  VTBL_ENTRY _ZTV7S1501C1[];
Class_Descriptor cd_S1501C1 = {  "S1501C1", // class name
  bases_S1501C1, 5,
  &(vtc_S1501C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,116), // object size
  NSPAIRA(_ZTI7S1501C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1501C1),153, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C4  {
  int s1500c4f0;
  __tsi64 s1500c4f1;
  void *s1500c4f2[4];
  int s1500c4f3[2];
  void *s1500c4f4;
  ::S79C8_nt s1500c4f5;
  void *s1500c4f6[2];
  virtual  ~S1500C4(); // _ZN7S1500C4D1Ev
  virtual void  v6(); // _ZN7S1500C42v6Ev
  virtual void  v7(); // _ZN7S1500C42v7Ev
  virtual void  v8(); // _ZN7S1500C42v8Ev
  virtual void  v9(); // _ZN7S1500C42v9Ev
  virtual void  v10(); // _ZN7S1500C43v10Ev
  virtual void  v11(); // _ZN7S1500C43v11Ev
  virtual void  v12(); // _ZN7S1500C43v12Ev
  virtual void  v13(); // _ZN7S1500C43v13Ev
  virtual void  v14(); // _ZN7S1500C43v14Ev
  virtual void  v15(); // _ZN7S1500C43v15Ev
  virtual void  v16(); // _ZN7S1500C43v16Ev
  virtual void  v17(); // _ZN7S1500C43v17Ev
  virtual void  v18(); // _ZN7S1500C43v18Ev
  virtual void  v19(); // _ZN7S1500C43v19Ev
  virtual void  v20(); // _ZN7S1500C43v20Ev
  virtual void  v21(); // _ZN7S1500C43v21Ev
  virtual void  v22(); // _ZN7S1500C43v22Ev
  virtual void  v23(); // _ZN7S1500C43v23Ev
  virtual void  v24(); // _ZN7S1500C43v24Ev
  virtual void  v25(); // _ZN7S1500C43v25Ev
  virtual void  v26(); // _ZN7S1500C43v26Ev
  virtual void  v27(); // _ZN7S1500C43v27Ev
  virtual void  v28(); // _ZN7S1500C43v28Ev
  virtual void  v29(); // _ZN7S1500C43v29Ev
  virtual void  v30(); // _ZN7S1500C43v30Ev
  virtual void  v31(); // _ZN7S1500C43v31Ev
  virtual void  v32(); // _ZN7S1500C43v32Ev
  virtual void  v33(); // _ZN7S1500C43v33Ev
  virtual void  v34(); // _ZN7S1500C43v34Ev
  virtual void  v35(); // _ZN7S1500C43v35Ev
  virtual void  v36(); // _ZN7S1500C43v36Ev
  virtual void  v37(); // _ZN7S1500C43v37Ev
  virtual void  v38(); // _ZN7S1500C43v38Ev
  virtual void  v39(); // _ZN7S1500C43v39Ev
  virtual void  v40(); // _ZN7S1500C43v40Ev
  virtual void  v41(); // _ZN7S1500C43v41Ev
  virtual void  v42(); // _ZN7S1500C43v42Ev
  virtual void  v43(); // _ZN7S1500C43v43Ev
  virtual void  v44(); // _ZN7S1500C43v44Ev
  virtual void  v45(); // _ZN7S1500C43v45Ev
  virtual void  v46(); // _ZN7S1500C43v46Ev
  virtual void  v47(); // _ZN7S1500C43v47Ev
  virtual void  v48(); // _ZN7S1500C43v48Ev
  virtual void  v49(); // _ZN7S1500C43v49Ev
  virtual void  v50(); // _ZN7S1500C43v50Ev
  virtual void  v51(); // _ZN7S1500C43v51Ev
  virtual void  v52(); // _ZN7S1500C43v52Ev
  virtual void  v53(); // _ZN7S1500C43v53Ev
  virtual void  v54(); // _ZN7S1500C43v54Ev
  virtual void  v55(); // _ZN7S1500C43v55Ev
  virtual void  v56(); // _ZN7S1500C43v56Ev
  virtual void  v57(); // _ZN7S1500C43v57Ev
  virtual void  v58(); // _ZN7S1500C43v58Ev
  virtual void  v59(); // _ZN7S1500C43v59Ev
  virtual void  v60(); // _ZN7S1500C43v60Ev
  virtual void  v61(); // _ZN7S1500C43v61Ev
  virtual void  v62(); // _ZN7S1500C43v62Ev
  virtual void  v63(); // _ZN7S1500C43v63Ev
  virtual void  v64(); // _ZN7S1500C43v64Ev
  virtual void  v65(); // _ZN7S1500C43v65Ev
  virtual void  v66(); // _ZN7S1500C43v66Ev
  virtual void  v67(); // _ZN7S1500C43v67Ev
  virtual void  v68(); // _ZN7S1500C43v68Ev
  virtual void  v69(); // _ZN7S1500C43v69Ev
  S1500C4(); // tgen
};
//SIG(-1 S1500C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1500C4 ::~S1500C4(){ note_dtor("S1500C4", this);}
void  S1500C4 ::v6(){vfunc_called(this, "_ZN7S1500C42v6Ev");}
void  S1500C4 ::v7(){vfunc_called(this, "_ZN7S1500C42v7Ev");}
void  S1500C4 ::v8(){vfunc_called(this, "_ZN7S1500C42v8Ev");}
void  S1500C4 ::v9(){vfunc_called(this, "_ZN7S1500C42v9Ev");}
void  S1500C4 ::v10(){vfunc_called(this, "_ZN7S1500C43v10Ev");}
void  S1500C4 ::v11(){vfunc_called(this, "_ZN7S1500C43v11Ev");}
void  S1500C4 ::v12(){vfunc_called(this, "_ZN7S1500C43v12Ev");}
void  S1500C4 ::v13(){vfunc_called(this, "_ZN7S1500C43v13Ev");}
void  S1500C4 ::v14(){vfunc_called(this, "_ZN7S1500C43v14Ev");}
void  S1500C4 ::v15(){vfunc_called(this, "_ZN7S1500C43v15Ev");}
void  S1500C4 ::v16(){vfunc_called(this, "_ZN7S1500C43v16Ev");}
void  S1500C4 ::v17(){vfunc_called(this, "_ZN7S1500C43v17Ev");}
void  S1500C4 ::v18(){vfunc_called(this, "_ZN7S1500C43v18Ev");}
void  S1500C4 ::v19(){vfunc_called(this, "_ZN7S1500C43v19Ev");}
void  S1500C4 ::v20(){vfunc_called(this, "_ZN7S1500C43v20Ev");}
void  S1500C4 ::v21(){vfunc_called(this, "_ZN7S1500C43v21Ev");}
void  S1500C4 ::v22(){vfunc_called(this, "_ZN7S1500C43v22Ev");}
void  S1500C4 ::v23(){vfunc_called(this, "_ZN7S1500C43v23Ev");}
void  S1500C4 ::v24(){vfunc_called(this, "_ZN7S1500C43v24Ev");}
void  S1500C4 ::v25(){vfunc_called(this, "_ZN7S1500C43v25Ev");}
void  S1500C4 ::v26(){vfunc_called(this, "_ZN7S1500C43v26Ev");}
void  S1500C4 ::v27(){vfunc_called(this, "_ZN7S1500C43v27Ev");}
void  S1500C4 ::v28(){vfunc_called(this, "_ZN7S1500C43v28Ev");}
void  S1500C4 ::v29(){vfunc_called(this, "_ZN7S1500C43v29Ev");}
void  S1500C4 ::v30(){vfunc_called(this, "_ZN7S1500C43v30Ev");}
void  S1500C4 ::v31(){vfunc_called(this, "_ZN7S1500C43v31Ev");}
void  S1500C4 ::v32(){vfunc_called(this, "_ZN7S1500C43v32Ev");}
void  S1500C4 ::v33(){vfunc_called(this, "_ZN7S1500C43v33Ev");}
void  S1500C4 ::v34(){vfunc_called(this, "_ZN7S1500C43v34Ev");}
void  S1500C4 ::v35(){vfunc_called(this, "_ZN7S1500C43v35Ev");}
void  S1500C4 ::v36(){vfunc_called(this, "_ZN7S1500C43v36Ev");}
void  S1500C4 ::v37(){vfunc_called(this, "_ZN7S1500C43v37Ev");}
void  S1500C4 ::v38(){vfunc_called(this, "_ZN7S1500C43v38Ev");}
void  S1500C4 ::v39(){vfunc_called(this, "_ZN7S1500C43v39Ev");}
void  S1500C4 ::v40(){vfunc_called(this, "_ZN7S1500C43v40Ev");}
void  S1500C4 ::v41(){vfunc_called(this, "_ZN7S1500C43v41Ev");}
void  S1500C4 ::v42(){vfunc_called(this, "_ZN7S1500C43v42Ev");}
void  S1500C4 ::v43(){vfunc_called(this, "_ZN7S1500C43v43Ev");}
void  S1500C4 ::v44(){vfunc_called(this, "_ZN7S1500C43v44Ev");}
void  S1500C4 ::v45(){vfunc_called(this, "_ZN7S1500C43v45Ev");}
void  S1500C4 ::v46(){vfunc_called(this, "_ZN7S1500C43v46Ev");}
void  S1500C4 ::v47(){vfunc_called(this, "_ZN7S1500C43v47Ev");}
void  S1500C4 ::v48(){vfunc_called(this, "_ZN7S1500C43v48Ev");}
void  S1500C4 ::v49(){vfunc_called(this, "_ZN7S1500C43v49Ev");}
void  S1500C4 ::v50(){vfunc_called(this, "_ZN7S1500C43v50Ev");}
void  S1500C4 ::v51(){vfunc_called(this, "_ZN7S1500C43v51Ev");}
void  S1500C4 ::v52(){vfunc_called(this, "_ZN7S1500C43v52Ev");}
void  S1500C4 ::v53(){vfunc_called(this, "_ZN7S1500C43v53Ev");}
void  S1500C4 ::v54(){vfunc_called(this, "_ZN7S1500C43v54Ev");}
void  S1500C4 ::v55(){vfunc_called(this, "_ZN7S1500C43v55Ev");}
void  S1500C4 ::v56(){vfunc_called(this, "_ZN7S1500C43v56Ev");}
void  S1500C4 ::v57(){vfunc_called(this, "_ZN7S1500C43v57Ev");}
void  S1500C4 ::v58(){vfunc_called(this, "_ZN7S1500C43v58Ev");}
void  S1500C4 ::v59(){vfunc_called(this, "_ZN7S1500C43v59Ev");}
void  S1500C4 ::v60(){vfunc_called(this, "_ZN7S1500C43v60Ev");}
void  S1500C4 ::v61(){vfunc_called(this, "_ZN7S1500C43v61Ev");}
void  S1500C4 ::v62(){vfunc_called(this, "_ZN7S1500C43v62Ev");}
void  S1500C4 ::v63(){vfunc_called(this, "_ZN7S1500C43v63Ev");}
void  S1500C4 ::v64(){vfunc_called(this, "_ZN7S1500C43v64Ev");}
void  S1500C4 ::v65(){vfunc_called(this, "_ZN7S1500C43v65Ev");}
void  S1500C4 ::v66(){vfunc_called(this, "_ZN7S1500C43v66Ev");}
void  S1500C4 ::v67(){vfunc_called(this, "_ZN7S1500C43v67Ev");}
void  S1500C4 ::v68(){vfunc_called(this, "_ZN7S1500C43v68Ev");}
void  S1500C4 ::v69(){vfunc_called(this, "_ZN7S1500C43v69Ev");}
S1500C4 ::S1500C4(){ note_ctor("S1500C4", this);} // tgen

static void Test_S1500C4()
{
  extern Class_Descriptor cd_S1500C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1500C4, buf);
    S1500C4 *dp, &lv = *(dp=new (buf) S1500C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1500C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C4)");
    check_field_offset(lv, s1500c4f0, ABISELECT(8,4), "S1500C4.s1500c4f0");
    check_field_offset(lv, s1500c4f1, ABISELECT(16,8), "S1500C4.s1500c4f1");
    check_field_offset(lv, s1500c4f2, ABISELECT(24,16), "S1500C4.s1500c4f2");
    check_field_offset(lv, s1500c4f3, ABISELECT(56,32), "S1500C4.s1500c4f3");
    check_field_offset(lv, s1500c4f4, ABISELECT(64,40), "S1500C4.s1500c4f4");
    check_field_offset(lv, s1500c4f5, ABISELECT(72,44), "S1500C4.s1500c4f5");
    check_field_offset(lv, s1500c4f6, ABISELECT(80,52), "S1500C4.s1500c4f6");
    test_class_info(&lv, &cd_S1500C4);
    dp->~S1500C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C4(Test_S1500C4, "S1500C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1500C4C1Ev();
extern void _ZN7S1500C4D1Ev();
Name_Map name_map_S1500C4[] = {
  NSPAIR(_ZN7S1500C4C1Ev),
  NSPAIR(_ZN7S1500C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1500C4[];
extern void _ZN7S1500C4D1Ev();
extern void _ZN7S1500C4D0Ev();
extern void _ZN7S1500C42v6Ev();
extern void _ZN7S1500C42v7Ev();
extern void _ZN7S1500C42v8Ev();
extern void _ZN7S1500C42v9Ev();
extern void _ZN7S1500C43v10Ev();
extern void _ZN7S1500C43v11Ev();
extern void _ZN7S1500C43v12Ev();
extern void _ZN7S1500C43v13Ev();
extern void _ZN7S1500C43v14Ev();
extern void _ZN7S1500C43v15Ev();
extern void _ZN7S1500C43v16Ev();
extern void _ZN7S1500C43v17Ev();
extern void _ZN7S1500C43v18Ev();
extern void _ZN7S1500C43v19Ev();
extern void _ZN7S1500C43v20Ev();
extern void _ZN7S1500C43v21Ev();
extern void _ZN7S1500C43v22Ev();
extern void _ZN7S1500C43v23Ev();
extern void _ZN7S1500C43v24Ev();
extern void _ZN7S1500C43v25Ev();
extern void _ZN7S1500C43v26Ev();
extern void _ZN7S1500C43v27Ev();
extern void _ZN7S1500C43v28Ev();
extern void _ZN7S1500C43v29Ev();
extern void _ZN7S1500C43v30Ev();
extern void _ZN7S1500C43v31Ev();
extern void _ZN7S1500C43v32Ev();
extern void _ZN7S1500C43v33Ev();
extern void _ZN7S1500C43v34Ev();
extern void _ZN7S1500C43v35Ev();
extern void _ZN7S1500C43v36Ev();
extern void _ZN7S1500C43v37Ev();
extern void _ZN7S1500C43v38Ev();
extern void _ZN7S1500C43v39Ev();
extern void _ZN7S1500C43v40Ev();
extern void _ZN7S1500C43v41Ev();
extern void _ZN7S1500C43v42Ev();
extern void _ZN7S1500C43v43Ev();
extern void _ZN7S1500C43v44Ev();
extern void _ZN7S1500C43v45Ev();
extern void _ZN7S1500C43v46Ev();
extern void _ZN7S1500C43v47Ev();
extern void _ZN7S1500C43v48Ev();
extern void _ZN7S1500C43v49Ev();
extern void _ZN7S1500C43v50Ev();
extern void _ZN7S1500C43v51Ev();
extern void _ZN7S1500C43v52Ev();
extern void _ZN7S1500C43v53Ev();
extern void _ZN7S1500C43v54Ev();
extern void _ZN7S1500C43v55Ev();
extern void _ZN7S1500C43v56Ev();
extern void _ZN7S1500C43v57Ev();
extern void _ZN7S1500C43v58Ev();
extern void _ZN7S1500C43v59Ev();
extern void _ZN7S1500C43v60Ev();
extern void _ZN7S1500C43v61Ev();
extern void _ZN7S1500C43v62Ev();
extern void _ZN7S1500C43v63Ev();
extern void _ZN7S1500C43v64Ev();
extern void _ZN7S1500C43v65Ev();
extern void _ZN7S1500C43v66Ev();
extern void _ZN7S1500C43v67Ev();
extern void _ZN7S1500C43v68Ev();
extern void _ZN7S1500C43v69Ev();
static  VTBL_ENTRY vtc_S1500C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C4[0]),
  (VTBL_ENTRY)&_ZN7S1500C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1500C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v69Ev,
};
extern VTBL_ENTRY _ZTI7S1500C4[];
extern  VTBL_ENTRY _ZTV7S1500C4[];
Class_Descriptor cd_S1500C4 = {  "S1500C4", // class name
  0,0,//no base classes
  &(vtc_S1500C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1500C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1500C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C6  {
  virtual void  v70(); // _ZN7S1500C63v70Ev
  virtual void  v71(); // _ZN7S1500C63v71Ev
  virtual void  v72(); // _ZN7S1500C63v72Ev
  virtual void  v73(); // _ZN7S1500C63v73Ev
  virtual void  v74(); // _ZN7S1500C63v74Ev
  virtual void  v75(); // _ZN7S1500C63v75Ev
  virtual void  v76(); // _ZN7S1500C63v76Ev
  virtual void  v77(); // _ZN7S1500C63v77Ev
  virtual void  v78(); // _ZN7S1500C63v78Ev
  virtual void  v79(); // _ZN7S1500C63v79Ev
  virtual void  v80(); // _ZN7S1500C63v80Ev
  virtual void  v81(); // _ZN7S1500C63v81Ev
  virtual void  v82(); // _ZN7S1500C63v82Ev
  virtual void  v83(); // _ZN7S1500C63v83Ev
  virtual void  v84(); // _ZN7S1500C63v84Ev
  virtual void  v85(); // _ZN7S1500C63v85Ev
  ~S1500C6(); // tgen
  S1500C6(); // tgen
};
//SIG(-1 S1500C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S1500C6 ::v70(){vfunc_called(this, "_ZN7S1500C63v70Ev");}
void  S1500C6 ::v71(){vfunc_called(this, "_ZN7S1500C63v71Ev");}
void  S1500C6 ::v72(){vfunc_called(this, "_ZN7S1500C63v72Ev");}
void  S1500C6 ::v73(){vfunc_called(this, "_ZN7S1500C63v73Ev");}
void  S1500C6 ::v74(){vfunc_called(this, "_ZN7S1500C63v74Ev");}
void  S1500C6 ::v75(){vfunc_called(this, "_ZN7S1500C63v75Ev");}
void  S1500C6 ::v76(){vfunc_called(this, "_ZN7S1500C63v76Ev");}
void  S1500C6 ::v77(){vfunc_called(this, "_ZN7S1500C63v77Ev");}
void  S1500C6 ::v78(){vfunc_called(this, "_ZN7S1500C63v78Ev");}
void  S1500C6 ::v79(){vfunc_called(this, "_ZN7S1500C63v79Ev");}
void  S1500C6 ::v80(){vfunc_called(this, "_ZN7S1500C63v80Ev");}
void  S1500C6 ::v81(){vfunc_called(this, "_ZN7S1500C63v81Ev");}
void  S1500C6 ::v82(){vfunc_called(this, "_ZN7S1500C63v82Ev");}
void  S1500C6 ::v83(){vfunc_called(this, "_ZN7S1500C63v83Ev");}
void  S1500C6 ::v84(){vfunc_called(this, "_ZN7S1500C63v84Ev");}
void  S1500C6 ::v85(){vfunc_called(this, "_ZN7S1500C63v85Ev");}
S1500C6 ::~S1500C6(){ note_dtor("S1500C6", this);} // tgen
S1500C6 ::S1500C6(){ note_ctor("S1500C6", this);} // tgen

static void Test_S1500C6()
{
  extern Class_Descriptor cd_S1500C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1500C6, buf);
    S1500C6 *dp, &lv = *(dp=new (buf) S1500C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1500C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C6)");
    test_class_info(&lv, &cd_S1500C6);
    dp->~S1500C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C6(Test_S1500C6, "S1500C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1500C6C1Ev();
extern void _ZN7S1500C6D1Ev();
Name_Map name_map_S1500C6[] = {
  NSPAIR(_ZN7S1500C6C1Ev),
  NSPAIR(_ZN7S1500C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1500C6[];
extern void _ZN7S1500C63v70Ev();
extern void _ZN7S1500C63v71Ev();
extern void _ZN7S1500C63v72Ev();
extern void _ZN7S1500C63v73Ev();
extern void _ZN7S1500C63v74Ev();
extern void _ZN7S1500C63v75Ev();
extern void _ZN7S1500C63v76Ev();
extern void _ZN7S1500C63v77Ev();
extern void _ZN7S1500C63v78Ev();
extern void _ZN7S1500C63v79Ev();
extern void _ZN7S1500C63v80Ev();
extern void _ZN7S1500C63v81Ev();
extern void _ZN7S1500C63v82Ev();
extern void _ZN7S1500C63v83Ev();
extern void _ZN7S1500C63v84Ev();
extern void _ZN7S1500C63v85Ev();
static  VTBL_ENTRY vtc_S1500C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C6[0]),
  (VTBL_ENTRY)&_ZN7S1500C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v85Ev,
};
extern VTBL_ENTRY _ZTI7S1500C6[];
extern  VTBL_ENTRY _ZTV7S1500C6[];
Class_Descriptor cd_S1500C6 = {  "S1500C6", // class name
  0,0,//no base classes
  &(vtc_S1500C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1500C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1500C6),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C7  {
  virtual void  v86(); // _ZN7S1500C73v86Ev
  virtual void  v87(); // _ZN7S1500C73v87Ev
  virtual void  v88(); // _ZN7S1500C73v88Ev
  virtual void  v89(); // _ZN7S1500C73v89Ev
  virtual void  v90(); // _ZN7S1500C73v90Ev
  virtual void  v91(); // _ZN7S1500C73v91Ev
  virtual void  v92(); // _ZN7S1500C73v92Ev
  virtual void  v93(); // _ZN7S1500C73v93Ev
  virtual void  v94(); // _ZN7S1500C73v94Ev
  ~S1500C7(); // tgen
  S1500C7(); // tgen
};
//SIG(-1 S1500C7) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S1500C7 ::v86(){vfunc_called(this, "_ZN7S1500C73v86Ev");}
void  S1500C7 ::v87(){vfunc_called(this, "_ZN7S1500C73v87Ev");}
void  S1500C7 ::v88(){vfunc_called(this, "_ZN7S1500C73v88Ev");}
void  S1500C7 ::v89(){vfunc_called(this, "_ZN7S1500C73v89Ev");}
void  S1500C7 ::v90(){vfunc_called(this, "_ZN7S1500C73v90Ev");}
void  S1500C7 ::v91(){vfunc_called(this, "_ZN7S1500C73v91Ev");}
void  S1500C7 ::v92(){vfunc_called(this, "_ZN7S1500C73v92Ev");}
void  S1500C7 ::v93(){vfunc_called(this, "_ZN7S1500C73v93Ev");}
void  S1500C7 ::v94(){vfunc_called(this, "_ZN7S1500C73v94Ev");}
S1500C7 ::~S1500C7(){ note_dtor("S1500C7", this);} // tgen
S1500C7 ::S1500C7(){ note_ctor("S1500C7", this);} // tgen

static void Test_S1500C7()
{
  extern Class_Descriptor cd_S1500C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1500C7, buf);
    S1500C7 *dp, &lv = *(dp=new (buf) S1500C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1500C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C7)");
    test_class_info(&lv, &cd_S1500C7);
    dp->~S1500C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C7(Test_S1500C7, "S1500C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1500C7C1Ev();
extern void _ZN7S1500C7D1Ev();
Name_Map name_map_S1500C7[] = {
  NSPAIR(_ZN7S1500C7C1Ev),
  NSPAIR(_ZN7S1500C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1500C7[];
extern void _ZN7S1500C73v86Ev();
extern void _ZN7S1500C73v87Ev();
extern void _ZN7S1500C73v88Ev();
extern void _ZN7S1500C73v89Ev();
extern void _ZN7S1500C73v90Ev();
extern void _ZN7S1500C73v91Ev();
extern void _ZN7S1500C73v92Ev();
extern void _ZN7S1500C73v93Ev();
extern void _ZN7S1500C73v94Ev();
static  VTBL_ENTRY vtc_S1500C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C7[0]),
  (VTBL_ENTRY)&_ZN7S1500C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1500C7[];
extern  VTBL_ENTRY _ZTV7S1500C7[];
Class_Descriptor cd_S1500C7 = {  "S1500C7", // class name
  0,0,//no base classes
  &(vtc_S1500C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1500C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1500C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C3  : S1500C4 , S1500C6 , S1500C7 {
  void *s1500c3f0;
  ::S79C39_nt s1500c3f1;
  unsigned int s1500c3f2:1;
  unsigned int s1500c3f3:1;
  unsigned int s1500c3f4:1;
  unsigned int s1500c3f5:1;
  virtual  ~S1500C3(); // _ZN7S1500C3D1Ev
  virtual void  v95(); // _ZN7S1500C33v95Ev
  virtual void  v96(); // _ZN7S1500C33v96Ev
  virtual void  v97(); // _ZN7S1500C33v97Ev
  virtual void  v98(); // _ZN7S1500C33v98Ev
  virtual void  v99(); // _ZN7S1500C33v99Ev
  virtual void  v100(); // _ZN7S1500C34v100Ev
  virtual void  v101(); // _ZN7S1500C34v101Ev
  virtual void  v102(); // _ZN7S1500C34v102Ev
  virtual void  v103(); // _ZN7S1500C34v103Ev
  virtual void  v104(); // _ZN7S1500C34v104Ev
  virtual void  v105(); // _ZN7S1500C34v105Ev
  virtual void  v106(); // _ZN7S1500C34v106Ev
  virtual void  v107(); // _ZN7S1500C34v107Ev
  virtual void  v108(); // _ZN7S1500C34v108Ev
  virtual void  v109(); // _ZN7S1500C34v109Ev
  virtual void  v110(); // _ZN7S1500C34v110Ev
  virtual void  v111(); // _ZN7S1500C34v111Ev
  virtual void  v112(); // _ZN7S1500C34v112Ev
  virtual void  v113(); // _ZN7S1500C34v113Ev
  virtual void  v114(); // _ZN7S1500C34v114Ev
  virtual void  v115(); // _ZN7S1500C34v115Ev
  virtual void  v116(); // _ZN7S1500C34v116Ev
  virtual void  v117(); // _ZN7S1500C34v117Ev
  virtual void  v118(); // _ZN7S1500C34v118Ev
  S1500C3(); // tgen
};
//SIG(-1 S1500C3) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S1500C3 ::~S1500C3(){ note_dtor("S1500C3", this);}
void  S1500C3 ::v95(){vfunc_called(this, "_ZN7S1500C33v95Ev");}
void  S1500C3 ::v96(){vfunc_called(this, "_ZN7S1500C33v96Ev");}
void  S1500C3 ::v97(){vfunc_called(this, "_ZN7S1500C33v97Ev");}
void  S1500C3 ::v98(){vfunc_called(this, "_ZN7S1500C33v98Ev");}
void  S1500C3 ::v99(){vfunc_called(this, "_ZN7S1500C33v99Ev");}
void  S1500C3 ::v100(){vfunc_called(this, "_ZN7S1500C34v100Ev");}
void  S1500C3 ::v101(){vfunc_called(this, "_ZN7S1500C34v101Ev");}
void  S1500C3 ::v102(){vfunc_called(this, "_ZN7S1500C34v102Ev");}
void  S1500C3 ::v103(){vfunc_called(this, "_ZN7S1500C34v103Ev");}
void  S1500C3 ::v104(){vfunc_called(this, "_ZN7S1500C34v104Ev");}
void  S1500C3 ::v105(){vfunc_called(this, "_ZN7S1500C34v105Ev");}
void  S1500C3 ::v106(){vfunc_called(this, "_ZN7S1500C34v106Ev");}
void  S1500C3 ::v107(){vfunc_called(this, "_ZN7S1500C34v107Ev");}
void  S1500C3 ::v108(){vfunc_called(this, "_ZN7S1500C34v108Ev");}
void  S1500C3 ::v109(){vfunc_called(this, "_ZN7S1500C34v109Ev");}
void  S1500C3 ::v110(){vfunc_called(this, "_ZN7S1500C34v110Ev");}
void  S1500C3 ::v111(){vfunc_called(this, "_ZN7S1500C34v111Ev");}
void  S1500C3 ::v112(){vfunc_called(this, "_ZN7S1500C34v112Ev");}
void  S1500C3 ::v113(){vfunc_called(this, "_ZN7S1500C34v113Ev");}
void  S1500C3 ::v114(){vfunc_called(this, "_ZN7S1500C34v114Ev");}
void  S1500C3 ::v115(){vfunc_called(this, "_ZN7S1500C34v115Ev");}
void  S1500C3 ::v116(){vfunc_called(this, "_ZN7S1500C34v116Ev");}
void  S1500C3 ::v117(){vfunc_called(this, "_ZN7S1500C34v117Ev");}
void  S1500C3 ::v118(){vfunc_called(this, "_ZN7S1500C34v118Ev");}
S1500C3 ::S1500C3(){ note_ctor("S1500C3", this);} // tgen

static void Test_S1500C3()
{
  extern Class_Descriptor cd_S1500C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S1500C3, buf);
    S1500C3 *dp, &lv = *(dp=new (buf) S1500C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S1500C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C3)");
    check_base_class_offset(lv, (S1500C4*), 0, "S1500C3");
    check_base_class_offset(lv, (S1500C6*), ABISELECT(96,60), "S1500C3");
    check_base_class_offset(lv, (S1500C7*), ABISELECT(104,64), "S1500C3");
    check_field_offset(lv, s1500c3f0, ABISELECT(112,68), "S1500C3.s1500c3f0");
    check_field_offset(lv, s1500c3f1, ABISELECT(120,72), "S1500C3.s1500c3f1");
    set_bf_and_test(lv, s1500c3f2, ABISELECT(136,84), 0, 1, 1, "S1500C3");
    set_bf_and_test(lv, s1500c3f3, ABISELECT(136,84), 1, 1, 1, "S1500C3");
    set_bf_and_test(lv, s1500c3f4, ABISELECT(136,84), 2, 1, 1, "S1500C3");
    set_bf_and_test(lv, s1500c3f5, ABISELECT(136,84), 3, 1, 1, "S1500C3");
    test_class_info(&lv, &cd_S1500C3);
    dp->~S1500C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C3(Test_S1500C3, "S1500C3", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S1500C3C1Ev();
extern void _ZN7S1500C3D1Ev();
Name_Map name_map_S1500C3[] = {
  NSPAIR(_ZN7S1500C3C1Ev),
  NSPAIR(_ZN7S1500C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1500C4;
extern VTBL_ENTRY _ZTI7S1500C4[];
extern  VTBL_ENTRY _ZTV7S1500C4[];
extern Class_Descriptor cd_S1500C6;
extern VTBL_ENTRY _ZTI7S1500C6[];
extern  VTBL_ENTRY _ZTV7S1500C6[];
extern Class_Descriptor cd_S1500C7;
extern VTBL_ENTRY _ZTI7S1500C7[];
extern  VTBL_ENTRY _ZTV7S1500C7[];
static Base_Class bases_S1500C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1500C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1500C6,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1500C7,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1500C3[];
extern void _ZN7S1500C3D1Ev();
extern void _ZN7S1500C3D0Ev();
extern void _ZN7S1500C42v6Ev();
extern void _ZN7S1500C42v7Ev();
extern void _ZN7S1500C42v8Ev();
extern void _ZN7S1500C42v9Ev();
extern void _ZN7S1500C43v10Ev();
extern void _ZN7S1500C43v11Ev();
extern void _ZN7S1500C43v12Ev();
extern void _ZN7S1500C43v13Ev();
extern void _ZN7S1500C43v14Ev();
extern void _ZN7S1500C43v15Ev();
extern void _ZN7S1500C43v16Ev();
extern void _ZN7S1500C43v17Ev();
extern void _ZN7S1500C43v18Ev();
extern void _ZN7S1500C43v19Ev();
extern void _ZN7S1500C43v20Ev();
extern void _ZN7S1500C43v21Ev();
extern void _ZN7S1500C43v22Ev();
extern void _ZN7S1500C43v23Ev();
extern void _ZN7S1500C43v24Ev();
extern void _ZN7S1500C43v25Ev();
extern void _ZN7S1500C43v26Ev();
extern void _ZN7S1500C43v27Ev();
extern void _ZN7S1500C43v28Ev();
extern void _ZN7S1500C43v29Ev();
extern void _ZN7S1500C43v30Ev();
extern void _ZN7S1500C43v31Ev();
extern void _ZN7S1500C43v32Ev();
extern void _ZN7S1500C43v33Ev();
extern void _ZN7S1500C43v34Ev();
extern void _ZN7S1500C43v35Ev();
extern void _ZN7S1500C43v36Ev();
extern void _ZN7S1500C43v37Ev();
extern void _ZN7S1500C43v38Ev();
extern void _ZN7S1500C43v39Ev();
extern void _ZN7S1500C43v40Ev();
extern void _ZN7S1500C43v41Ev();
extern void _ZN7S1500C43v42Ev();
extern void _ZN7S1500C43v43Ev();
extern void _ZN7S1500C43v44Ev();
extern void _ZN7S1500C43v45Ev();
extern void _ZN7S1500C43v46Ev();
extern void _ZN7S1500C43v47Ev();
extern void _ZN7S1500C43v48Ev();
extern void _ZN7S1500C43v49Ev();
extern void _ZN7S1500C43v50Ev();
extern void _ZN7S1500C43v51Ev();
extern void _ZN7S1500C43v52Ev();
extern void _ZN7S1500C43v53Ev();
extern void _ZN7S1500C43v54Ev();
extern void _ZN7S1500C43v55Ev();
extern void _ZN7S1500C43v56Ev();
extern void _ZN7S1500C43v57Ev();
extern void _ZN7S1500C43v58Ev();
extern void _ZN7S1500C43v59Ev();
extern void _ZN7S1500C43v60Ev();
extern void _ZN7S1500C43v61Ev();
extern void _ZN7S1500C43v62Ev();
extern void _ZN7S1500C43v63Ev();
extern void _ZN7S1500C43v64Ev();
extern void _ZN7S1500C43v65Ev();
extern void _ZN7S1500C43v66Ev();
extern void _ZN7S1500C43v67Ev();
extern void _ZN7S1500C43v68Ev();
extern void _ZN7S1500C43v69Ev();
extern void _ZN7S1500C33v95Ev();
extern void _ZN7S1500C33v96Ev();
extern void _ZN7S1500C33v97Ev();
extern void _ZN7S1500C33v98Ev();
extern void _ZN7S1500C33v99Ev();
extern void _ZN7S1500C34v100Ev();
extern void _ZN7S1500C34v101Ev();
extern void _ZN7S1500C34v102Ev();
extern void _ZN7S1500C34v103Ev();
extern void _ZN7S1500C34v104Ev();
extern void _ZN7S1500C34v105Ev();
extern void _ZN7S1500C34v106Ev();
extern void _ZN7S1500C34v107Ev();
extern void _ZN7S1500C34v108Ev();
extern void _ZN7S1500C34v109Ev();
extern void _ZN7S1500C34v110Ev();
extern void _ZN7S1500C34v111Ev();
extern void _ZN7S1500C34v112Ev();
extern void _ZN7S1500C34v113Ev();
extern void _ZN7S1500C34v114Ev();
extern void _ZN7S1500C34v115Ev();
extern void _ZN7S1500C34v116Ev();
extern void _ZN7S1500C34v117Ev();
extern void _ZN7S1500C34v118Ev();
extern void _ZN7S1500C63v70Ev();
extern void _ZN7S1500C63v71Ev();
extern void _ZN7S1500C63v72Ev();
extern void _ZN7S1500C63v73Ev();
extern void _ZN7S1500C63v74Ev();
extern void _ZN7S1500C63v75Ev();
extern void _ZN7S1500C63v76Ev();
extern void _ZN7S1500C63v77Ev();
extern void _ZN7S1500C63v78Ev();
extern void _ZN7S1500C63v79Ev();
extern void _ZN7S1500C63v80Ev();
extern void _ZN7S1500C63v81Ev();
extern void _ZN7S1500C63v82Ev();
extern void _ZN7S1500C63v83Ev();
extern void _ZN7S1500C63v84Ev();
extern void _ZN7S1500C63v85Ev();
extern void _ZN7S1500C73v86Ev();
extern void _ZN7S1500C73v87Ev();
extern void _ZN7S1500C73v88Ev();
extern void _ZN7S1500C73v89Ev();
extern void _ZN7S1500C73v90Ev();
extern void _ZN7S1500C73v91Ev();
extern void _ZN7S1500C73v92Ev();
extern void _ZN7S1500C73v93Ev();
extern void _ZN7S1500C73v94Ev();
static  VTBL_ENTRY vtc_S1500C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C3[0]),
  (VTBL_ENTRY)&_ZN7S1500C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1500C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v118Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1500C3[0]),
  (VTBL_ENTRY)&_ZN7S1500C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1500C3[0]),
  (VTBL_ENTRY)&_ZN7S1500C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1500C3[];
extern  VTBL_ENTRY _ZTV7S1500C3[];
Class_Descriptor cd_S1500C3 = {  "S1500C3", // class name
  bases_S1500C3, 3,
  &(vtc_S1500C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S1500C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1500C3),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C2  : S1500C3 {
  ::S3262C11_nt s1500c2f0;
  int s1500c2f1;
  virtual  ~S1500C2(); // _ZN7S1500C2D1Ev
  virtual void  v119(); // _ZN7S1500C24v119Ev
  virtual void  v120(); // _ZN7S1500C24v120Ev
  virtual void  v121(); // _ZN7S1500C24v121Ev
  virtual void  v122(); // _ZN7S1500C24v122Ev
  virtual void  v123(); // _ZN7S1500C24v123Ev
  virtual void  v124(); // _ZN7S1500C24v124Ev
  virtual void  v125(); // _ZN7S1500C24v125Ev
  virtual void  v126(); // _ZN7S1500C24v126Ev
  virtual void  v127(); // _ZN7S1500C24v127Ev
  virtual void  v128(); // _ZN7S1500C24v128Ev
  virtual void  v129(); // _ZN7S1500C24v129Ev
  virtual void  v130(); // _ZN7S1500C24v130Ev
  virtual void  v131(); // _ZN7S1500C24v131Ev
  virtual void  v132(); // _ZN7S1500C24v132Ev
  virtual void  v133(); // _ZN7S1500C24v133Ev
  virtual void  v134(); // _ZN7S1500C24v134Ev
  virtual void  v135(); // _ZN7S1500C24v135Ev
  virtual void  v136(); // _ZN7S1500C24v136Ev
  virtual void  v137(); // _ZN7S1500C24v137Ev
  virtual void  v138(); // _ZN7S1500C24v138Ev
  virtual void  v139(); // _ZN7S1500C24v139Ev
  virtual void  v140(); // _ZN7S1500C24v140Ev
  virtual void  v141(); // _ZN7S1500C24v141Ev
  virtual void  v142(); // _ZN7S1500C24v142Ev
  virtual void  v143(); // _ZN7S1500C24v143Ev
  virtual void  v144(); // _ZN7S1500C24v144Ev
  S1500C2(); // tgen
};
//SIG(-1 S1500C2) C1{ BC2{ BC3{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106} BC6{ v107 v108 v109 v110 v111 v112 v113 v114 v115} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC11{ m FC12{ BC13{ BC10}} Fc} Fi}


 S1500C2 ::~S1500C2(){ note_dtor("S1500C2", this);}
void  S1500C2 ::v119(){vfunc_called(this, "_ZN7S1500C24v119Ev");}
void  S1500C2 ::v120(){vfunc_called(this, "_ZN7S1500C24v120Ev");}
void  S1500C2 ::v121(){vfunc_called(this, "_ZN7S1500C24v121Ev");}
void  S1500C2 ::v122(){vfunc_called(this, "_ZN7S1500C24v122Ev");}
void  S1500C2 ::v123(){vfunc_called(this, "_ZN7S1500C24v123Ev");}
void  S1500C2 ::v124(){vfunc_called(this, "_ZN7S1500C24v124Ev");}
void  S1500C2 ::v125(){vfunc_called(this, "_ZN7S1500C24v125Ev");}
void  S1500C2 ::v126(){vfunc_called(this, "_ZN7S1500C24v126Ev");}
void  S1500C2 ::v127(){vfunc_called(this, "_ZN7S1500C24v127Ev");}
void  S1500C2 ::v128(){vfunc_called(this, "_ZN7S1500C24v128Ev");}
void  S1500C2 ::v129(){vfunc_called(this, "_ZN7S1500C24v129Ev");}
void  S1500C2 ::v130(){vfunc_called(this, "_ZN7S1500C24v130Ev");}
void  S1500C2 ::v131(){vfunc_called(this, "_ZN7S1500C24v131Ev");}
void  S1500C2 ::v132(){vfunc_called(this, "_ZN7S1500C24v132Ev");}
void  S1500C2 ::v133(){vfunc_called(this, "_ZN7S1500C24v133Ev");}
void  S1500C2 ::v134(){vfunc_called(this, "_ZN7S1500C24v134Ev");}
void  S1500C2 ::v135(){vfunc_called(this, "_ZN7S1500C24v135Ev");}
void  S1500C2 ::v136(){vfunc_called(this, "_ZN7S1500C24v136Ev");}
void  S1500C2 ::v137(){vfunc_called(this, "_ZN7S1500C24v137Ev");}
void  S1500C2 ::v138(){vfunc_called(this, "_ZN7S1500C24v138Ev");}
void  S1500C2 ::v139(){vfunc_called(this, "_ZN7S1500C24v139Ev");}
void  S1500C2 ::v140(){vfunc_called(this, "_ZN7S1500C24v140Ev");}
void  S1500C2 ::v141(){vfunc_called(this, "_ZN7S1500C24v141Ev");}
void  S1500C2 ::v142(){vfunc_called(this, "_ZN7S1500C24v142Ev");}
void  S1500C2 ::v143(){vfunc_called(this, "_ZN7S1500C24v143Ev");}
void  S1500C2 ::v144(){vfunc_called(this, "_ZN7S1500C24v144Ev");}
S1500C2 ::S1500C2(){ note_ctor("S1500C2", this);} // tgen

static void Test_S1500C2()
{
  extern Class_Descriptor cd_S1500C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,28)];
    init_test(&cd_S1500C2, buf);
    S1500C2 *dp, &lv = *(dp=new (buf) S1500C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,108), "sizeof(S1500C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C2)");
    check_base_class_offset(lv, (S1500C4*)(S1500C3*), 0, "S1500C2");
    check_base_class_offset(lv, (S1500C6*)(S1500C3*), ABISELECT(96,60), "S1500C2");
    check_base_class_offset(lv, (S1500C7*)(S1500C3*), ABISELECT(104,64), "S1500C2");
    check_base_class_offset(lv, (S1500C3*), 0, "S1500C2");
    check_field_offset(lv, s1500c2f0, ABISELECT(144,88), "S1500C2.s1500c2f0");
    check_field_offset(lv, s1500c2f1, ABISELECT(168,104), "S1500C2.s1500c2f1");
    test_class_info(&lv, &cd_S1500C2);
    dp->~S1500C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C2(Test_S1500C2, "S1500C2", ABISELECT(176,108));

#else // __cplusplus

extern void _ZN7S1500C2C1Ev();
extern void _ZN7S1500C2D1Ev();
Name_Map name_map_S1500C2[] = {
  NSPAIR(_ZN7S1500C2C1Ev),
  NSPAIR(_ZN7S1500C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1500C4;
extern VTBL_ENTRY _ZTI7S1500C4[];
extern  VTBL_ENTRY _ZTV7S1500C4[];
extern Class_Descriptor cd_S1500C6;
extern VTBL_ENTRY _ZTI7S1500C6[];
extern  VTBL_ENTRY _ZTV7S1500C6[];
extern Class_Descriptor cd_S1500C7;
extern VTBL_ENTRY _ZTI7S1500C7[];
extern  VTBL_ENTRY _ZTV7S1500C7[];
extern Class_Descriptor cd_S1500C3;
extern VTBL_ENTRY _ZTI7S1500C3[];
extern  VTBL_ENTRY _ZTV7S1500C3[];
static Base_Class bases_S1500C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1500C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C6,    ABISELECT(96,60), //bcp->offset
    118, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C7,    ABISELECT(104,64), //bcp->offset
    136, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1500C2[];
extern void _ZN7S1500C2D1Ev();
extern void _ZN7S1500C2D0Ev();
extern void _ZN7S1500C42v6Ev();
extern void _ZN7S1500C42v7Ev();
extern void _ZN7S1500C42v8Ev();
extern void _ZN7S1500C42v9Ev();
extern void _ZN7S1500C43v10Ev();
extern void _ZN7S1500C43v11Ev();
extern void _ZN7S1500C43v12Ev();
extern void _ZN7S1500C43v13Ev();
extern void _ZN7S1500C43v14Ev();
extern void _ZN7S1500C43v15Ev();
extern void _ZN7S1500C43v16Ev();
extern void _ZN7S1500C43v17Ev();
extern void _ZN7S1500C43v18Ev();
extern void _ZN7S1500C43v19Ev();
extern void _ZN7S1500C43v20Ev();
extern void _ZN7S1500C43v21Ev();
extern void _ZN7S1500C43v22Ev();
extern void _ZN7S1500C43v23Ev();
extern void _ZN7S1500C43v24Ev();
extern void _ZN7S1500C43v25Ev();
extern void _ZN7S1500C43v26Ev();
extern void _ZN7S1500C43v27Ev();
extern void _ZN7S1500C43v28Ev();
extern void _ZN7S1500C43v29Ev();
extern void _ZN7S1500C43v30Ev();
extern void _ZN7S1500C43v31Ev();
extern void _ZN7S1500C43v32Ev();
extern void _ZN7S1500C43v33Ev();
extern void _ZN7S1500C43v34Ev();
extern void _ZN7S1500C43v35Ev();
extern void _ZN7S1500C43v36Ev();
extern void _ZN7S1500C43v37Ev();
extern void _ZN7S1500C43v38Ev();
extern void _ZN7S1500C43v39Ev();
extern void _ZN7S1500C43v40Ev();
extern void _ZN7S1500C43v41Ev();
extern void _ZN7S1500C43v42Ev();
extern void _ZN7S1500C43v43Ev();
extern void _ZN7S1500C43v44Ev();
extern void _ZN7S1500C43v45Ev();
extern void _ZN7S1500C43v46Ev();
extern void _ZN7S1500C43v47Ev();
extern void _ZN7S1500C43v48Ev();
extern void _ZN7S1500C43v49Ev();
extern void _ZN7S1500C43v50Ev();
extern void _ZN7S1500C43v51Ev();
extern void _ZN7S1500C43v52Ev();
extern void _ZN7S1500C43v53Ev();
extern void _ZN7S1500C43v54Ev();
extern void _ZN7S1500C43v55Ev();
extern void _ZN7S1500C43v56Ev();
extern void _ZN7S1500C43v57Ev();
extern void _ZN7S1500C43v58Ev();
extern void _ZN7S1500C43v59Ev();
extern void _ZN7S1500C43v60Ev();
extern void _ZN7S1500C43v61Ev();
extern void _ZN7S1500C43v62Ev();
extern void _ZN7S1500C43v63Ev();
extern void _ZN7S1500C43v64Ev();
extern void _ZN7S1500C43v65Ev();
extern void _ZN7S1500C43v66Ev();
extern void _ZN7S1500C43v67Ev();
extern void _ZN7S1500C43v68Ev();
extern void _ZN7S1500C43v69Ev();
extern void _ZN7S1500C33v95Ev();
extern void _ZN7S1500C33v96Ev();
extern void _ZN7S1500C33v97Ev();
extern void _ZN7S1500C33v98Ev();
extern void _ZN7S1500C33v99Ev();
extern void _ZN7S1500C34v100Ev();
extern void _ZN7S1500C34v101Ev();
extern void _ZN7S1500C34v102Ev();
extern void _ZN7S1500C34v103Ev();
extern void _ZN7S1500C34v104Ev();
extern void _ZN7S1500C34v105Ev();
extern void _ZN7S1500C34v106Ev();
extern void _ZN7S1500C34v107Ev();
extern void _ZN7S1500C34v108Ev();
extern void _ZN7S1500C34v109Ev();
extern void _ZN7S1500C34v110Ev();
extern void _ZN7S1500C34v111Ev();
extern void _ZN7S1500C34v112Ev();
extern void _ZN7S1500C34v113Ev();
extern void _ZN7S1500C34v114Ev();
extern void _ZN7S1500C34v115Ev();
extern void _ZN7S1500C34v116Ev();
extern void _ZN7S1500C34v117Ev();
extern void _ZN7S1500C34v118Ev();
extern void _ZN7S1500C24v119Ev();
extern void _ZN7S1500C24v120Ev();
extern void _ZN7S1500C24v121Ev();
extern void _ZN7S1500C24v122Ev();
extern void _ZN7S1500C24v123Ev();
extern void _ZN7S1500C24v124Ev();
extern void _ZN7S1500C24v125Ev();
extern void _ZN7S1500C24v126Ev();
extern void _ZN7S1500C24v127Ev();
extern void _ZN7S1500C24v128Ev();
extern void _ZN7S1500C24v129Ev();
extern void _ZN7S1500C24v130Ev();
extern void _ZN7S1500C24v131Ev();
extern void _ZN7S1500C24v132Ev();
extern void _ZN7S1500C24v133Ev();
extern void _ZN7S1500C24v134Ev();
extern void _ZN7S1500C24v135Ev();
extern void _ZN7S1500C24v136Ev();
extern void _ZN7S1500C24v137Ev();
extern void _ZN7S1500C24v138Ev();
extern void _ZN7S1500C24v139Ev();
extern void _ZN7S1500C24v140Ev();
extern void _ZN7S1500C24v141Ev();
extern void _ZN7S1500C24v142Ev();
extern void _ZN7S1500C24v143Ev();
extern void _ZN7S1500C24v144Ev();
extern void _ZN7S1500C63v70Ev();
extern void _ZN7S1500C63v71Ev();
extern void _ZN7S1500C63v72Ev();
extern void _ZN7S1500C63v73Ev();
extern void _ZN7S1500C63v74Ev();
extern void _ZN7S1500C63v75Ev();
extern void _ZN7S1500C63v76Ev();
extern void _ZN7S1500C63v77Ev();
extern void _ZN7S1500C63v78Ev();
extern void _ZN7S1500C63v79Ev();
extern void _ZN7S1500C63v80Ev();
extern void _ZN7S1500C63v81Ev();
extern void _ZN7S1500C63v82Ev();
extern void _ZN7S1500C63v83Ev();
extern void _ZN7S1500C63v84Ev();
extern void _ZN7S1500C63v85Ev();
extern void _ZN7S1500C73v86Ev();
extern void _ZN7S1500C73v87Ev();
extern void _ZN7S1500C73v88Ev();
extern void _ZN7S1500C73v89Ev();
extern void _ZN7S1500C73v90Ev();
extern void _ZN7S1500C73v91Ev();
extern void _ZN7S1500C73v92Ev();
extern void _ZN7S1500C73v93Ev();
extern void _ZN7S1500C73v94Ev();
static  VTBL_ENTRY vtc_S1500C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C2[0]),
  (VTBL_ENTRY)&_ZN7S1500C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1500C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v120Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v144Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1500C2[0]),
  (VTBL_ENTRY)&_ZN7S1500C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1500C2[0]),
  (VTBL_ENTRY)&_ZN7S1500C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1500C2[];
extern  VTBL_ENTRY _ZTV7S1500C2[];
Class_Descriptor cd_S1500C2 = {  "S1500C2", // class name
  bases_S1500C2, 4,
  &(vtc_S1500C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,108), // object size
  NSPAIRA(_ZTI7S1500C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1500C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1500C1  : S1500C2 {
  ::S79C8_nt s1500c1f0;
  virtual  ~S1500C1(); // _ZN7S1500C1D1Ev
  virtual void  v1(); // _ZN7S1500C12v1Ev
  virtual void  v2(); // _ZN7S1500C12v2Ev
  virtual void  v3(); // _ZN7S1500C12v3Ev
  virtual void  v4(); // _ZN7S1500C12v4Ev
  virtual void  v5(); // _ZN7S1500C12v5Ev
  S1500C1(); // tgen
};
//SIG(1 S1500C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85} BC7{ v86 v87 v88 v89 v90 v91 v92 v93 v94} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC12{ m FC13{ BC14{ BC11}} Fc} Fi} vd v1 v2 v3 v4 v5 FC5}


 S1500C1 ::~S1500C1(){ note_dtor("S1500C1", this);}
void  S1500C1 ::v1(){vfunc_called(this, "_ZN7S1500C12v1Ev");}
void  S1500C1 ::v2(){vfunc_called(this, "_ZN7S1500C12v2Ev");}
void  S1500C1 ::v3(){vfunc_called(this, "_ZN7S1500C12v3Ev");}
void  S1500C1 ::v4(){vfunc_called(this, "_ZN7S1500C12v4Ev");}
void  S1500C1 ::v5(){vfunc_called(this, "_ZN7S1500C12v5Ev");}
S1500C1 ::S1500C1(){ note_ctor("S1500C1", this);} // tgen

static void Test_S1500C1()
{
  extern Class_Descriptor cd_S1500C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,30)];
    init_test(&cd_S1500C1, buf);
    S1500C1 *dp, &lv = *(dp=new (buf) S1500C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,116), "sizeof(S1500C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1500C1)");
    check_base_class_offset(lv, (S1500C4*)(S1500C3*)(S1500C2*), 0, "S1500C1");
    check_base_class_offset(lv, (S1500C6*)(S1500C3*)(S1500C2*), ABISELECT(96,60), "S1500C1");
    check_base_class_offset(lv, (S1500C7*)(S1500C3*)(S1500C2*), ABISELECT(104,64), "S1500C1");
    check_base_class_offset(lv, (S1500C3*)(S1500C2*), 0, "S1500C1");
    check_base_class_offset(lv, (S1500C2*), 0, "S1500C1");
    check_field_offset(lv, s1500c1f0, ABISELECT(172,108), "S1500C1.s1500c1f0");
    test_class_info(&lv, &cd_S1500C1);
    dp->~S1500C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1500C1(Test_S1500C1, "S1500C1", ABISELECT(184,116));

#else // __cplusplus

extern void _ZN7S1500C1C1Ev();
extern void _ZN7S1500C1D1Ev();
Name_Map name_map_S1500C1[] = {
  NSPAIR(_ZN7S1500C1C1Ev),
  NSPAIR(_ZN7S1500C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1500C4;
extern VTBL_ENTRY _ZTI7S1500C4[];
extern  VTBL_ENTRY _ZTV7S1500C4[];
extern Class_Descriptor cd_S1500C6;
extern VTBL_ENTRY _ZTI7S1500C6[];
extern  VTBL_ENTRY _ZTV7S1500C6[];
extern Class_Descriptor cd_S1500C7;
extern VTBL_ENTRY _ZTI7S1500C7[];
extern  VTBL_ENTRY _ZTV7S1500C7[];
extern Class_Descriptor cd_S1500C3;
extern VTBL_ENTRY _ZTI7S1500C3[];
extern  VTBL_ENTRY _ZTV7S1500C3[];
extern Class_Descriptor cd_S1500C2;
extern VTBL_ENTRY _ZTI7S1500C2[];
extern  VTBL_ENTRY _ZTV7S1500C2[];
static Base_Class bases_S1500C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1500C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C6,    ABISELECT(96,60), //bcp->offset
    123, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C7,    ABISELECT(104,64), //bcp->offset
    141, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1500C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1500C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1500C1[];
extern void _ZN7S1500C1D1Ev();
extern void _ZN7S1500C1D0Ev();
extern void _ZN7S1500C42v6Ev();
extern void _ZN7S1500C42v7Ev();
extern void _ZN7S1500C42v8Ev();
extern void _ZN7S1500C42v9Ev();
extern void _ZN7S1500C43v10Ev();
extern void _ZN7S1500C43v11Ev();
extern void _ZN7S1500C43v12Ev();
extern void _ZN7S1500C43v13Ev();
extern void _ZN7S1500C43v14Ev();
extern void _ZN7S1500C43v15Ev();
extern void _ZN7S1500C43v16Ev();
extern void _ZN7S1500C43v17Ev();
extern void _ZN7S1500C43v18Ev();
extern void _ZN7S1500C43v19Ev();
extern void _ZN7S1500C43v20Ev();
extern void _ZN7S1500C43v21Ev();
extern void _ZN7S1500C43v22Ev();
extern void _ZN7S1500C43v23Ev();
extern void _ZN7S1500C43v24Ev();
extern void _ZN7S1500C43v25Ev();
extern void _ZN7S1500C43v26Ev();
extern void _ZN7S1500C43v27Ev();
extern void _ZN7S1500C43v28Ev();
extern void _ZN7S1500C43v29Ev();
extern void _ZN7S1500C43v30Ev();
extern void _ZN7S1500C43v31Ev();
extern void _ZN7S1500C43v32Ev();
extern void _ZN7S1500C43v33Ev();
extern void _ZN7S1500C43v34Ev();
extern void _ZN7S1500C43v35Ev();
extern void _ZN7S1500C43v36Ev();
extern void _ZN7S1500C43v37Ev();
extern void _ZN7S1500C43v38Ev();
extern void _ZN7S1500C43v39Ev();
extern void _ZN7S1500C43v40Ev();
extern void _ZN7S1500C43v41Ev();
extern void _ZN7S1500C43v42Ev();
extern void _ZN7S1500C43v43Ev();
extern void _ZN7S1500C43v44Ev();
extern void _ZN7S1500C43v45Ev();
extern void _ZN7S1500C43v46Ev();
extern void _ZN7S1500C43v47Ev();
extern void _ZN7S1500C43v48Ev();
extern void _ZN7S1500C43v49Ev();
extern void _ZN7S1500C43v50Ev();
extern void _ZN7S1500C43v51Ev();
extern void _ZN7S1500C43v52Ev();
extern void _ZN7S1500C43v53Ev();
extern void _ZN7S1500C43v54Ev();
extern void _ZN7S1500C43v55Ev();
extern void _ZN7S1500C43v56Ev();
extern void _ZN7S1500C43v57Ev();
extern void _ZN7S1500C43v58Ev();
extern void _ZN7S1500C43v59Ev();
extern void _ZN7S1500C43v60Ev();
extern void _ZN7S1500C43v61Ev();
extern void _ZN7S1500C43v62Ev();
extern void _ZN7S1500C43v63Ev();
extern void _ZN7S1500C43v64Ev();
extern void _ZN7S1500C43v65Ev();
extern void _ZN7S1500C43v66Ev();
extern void _ZN7S1500C43v67Ev();
extern void _ZN7S1500C43v68Ev();
extern void _ZN7S1500C43v69Ev();
extern void _ZN7S1500C33v95Ev();
extern void _ZN7S1500C33v96Ev();
extern void _ZN7S1500C33v97Ev();
extern void _ZN7S1500C33v98Ev();
extern void _ZN7S1500C33v99Ev();
extern void _ZN7S1500C34v100Ev();
extern void _ZN7S1500C34v101Ev();
extern void _ZN7S1500C34v102Ev();
extern void _ZN7S1500C34v103Ev();
extern void _ZN7S1500C34v104Ev();
extern void _ZN7S1500C34v105Ev();
extern void _ZN7S1500C34v106Ev();
extern void _ZN7S1500C34v107Ev();
extern void _ZN7S1500C34v108Ev();
extern void _ZN7S1500C34v109Ev();
extern void _ZN7S1500C34v110Ev();
extern void _ZN7S1500C34v111Ev();
extern void _ZN7S1500C34v112Ev();
extern void _ZN7S1500C34v113Ev();
extern void _ZN7S1500C34v114Ev();
extern void _ZN7S1500C34v115Ev();
extern void _ZN7S1500C34v116Ev();
extern void _ZN7S1500C34v117Ev();
extern void _ZN7S1500C34v118Ev();
extern void _ZN7S1500C24v119Ev();
extern void _ZN7S1500C24v120Ev();
extern void _ZN7S1500C24v121Ev();
extern void _ZN7S1500C24v122Ev();
extern void _ZN7S1500C24v123Ev();
extern void _ZN7S1500C24v124Ev();
extern void _ZN7S1500C24v125Ev();
extern void _ZN7S1500C24v126Ev();
extern void _ZN7S1500C24v127Ev();
extern void _ZN7S1500C24v128Ev();
extern void _ZN7S1500C24v129Ev();
extern void _ZN7S1500C24v130Ev();
extern void _ZN7S1500C24v131Ev();
extern void _ZN7S1500C24v132Ev();
extern void _ZN7S1500C24v133Ev();
extern void _ZN7S1500C24v134Ev();
extern void _ZN7S1500C24v135Ev();
extern void _ZN7S1500C24v136Ev();
extern void _ZN7S1500C24v137Ev();
extern void _ZN7S1500C24v138Ev();
extern void _ZN7S1500C24v139Ev();
extern void _ZN7S1500C24v140Ev();
extern void _ZN7S1500C24v141Ev();
extern void _ZN7S1500C24v142Ev();
extern void _ZN7S1500C24v143Ev();
extern void _ZN7S1500C24v144Ev();
extern void _ZN7S1500C12v1Ev();
extern void _ZN7S1500C12v2Ev();
extern void _ZN7S1500C12v3Ev();
extern void _ZN7S1500C12v4Ev();
extern void _ZN7S1500C12v5Ev();
extern void _ZN7S1500C63v70Ev();
extern void _ZN7S1500C63v71Ev();
extern void _ZN7S1500C63v72Ev();
extern void _ZN7S1500C63v73Ev();
extern void _ZN7S1500C63v74Ev();
extern void _ZN7S1500C63v75Ev();
extern void _ZN7S1500C63v76Ev();
extern void _ZN7S1500C63v77Ev();
extern void _ZN7S1500C63v78Ev();
extern void _ZN7S1500C63v79Ev();
extern void _ZN7S1500C63v80Ev();
extern void _ZN7S1500C63v81Ev();
extern void _ZN7S1500C63v82Ev();
extern void _ZN7S1500C63v83Ev();
extern void _ZN7S1500C63v84Ev();
extern void _ZN7S1500C63v85Ev();
extern void _ZN7S1500C73v86Ev();
extern void _ZN7S1500C73v87Ev();
extern void _ZN7S1500C73v88Ev();
extern void _ZN7S1500C73v89Ev();
extern void _ZN7S1500C73v90Ev();
extern void _ZN7S1500C73v91Ev();
extern void _ZN7S1500C73v92Ev();
extern void _ZN7S1500C73v93Ev();
extern void _ZN7S1500C73v94Ev();
static  VTBL_ENTRY vtc_S1500C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1500C1[0]),
  (VTBL_ENTRY)&_ZN7S1500C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1500C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1500C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1500C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1500C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v102Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v103Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v104Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v105Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v106Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v107Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v108Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v109Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v110Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v111Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v112Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v113Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v114Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v115Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v116Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v117Ev,
  (VTBL_ENTRY)&_ZN7S1500C34v118Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v120Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v121Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v122Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v123Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v124Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v125Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v126Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v127Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v128Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v129Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v130Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v131Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v132Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v133Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v134Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v135Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v136Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v137Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v138Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v139Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v140Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v141Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v142Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v143Ev,
  (VTBL_ENTRY)&_ZN7S1500C24v144Ev,
  (VTBL_ENTRY)&_ZN7S1500C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1500C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1500C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1500C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1500C12v5Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1500C1[0]),
  (VTBL_ENTRY)&_ZN7S1500C63v70Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v71Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v72Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v73Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v74Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v75Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v76Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v77Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v78Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v79Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v80Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v81Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v82Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v83Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v84Ev,
  (VTBL_ENTRY)&_ZN7S1500C63v85Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1500C1[0]),
  (VTBL_ENTRY)&_ZN7S1500C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v87Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v88Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v89Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v90Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v91Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v92Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v93Ev,
  (VTBL_ENTRY)&_ZN7S1500C73v94Ev,
};
extern VTBL_ENTRY _ZTI7S1500C1[];
extern  VTBL_ENTRY _ZTV7S1500C1[];
Class_Descriptor cd_S1500C1 = {  "S1500C1", // class name
  bases_S1500C1, 5,
  &(vtc_S1500C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,116), // object size
  NSPAIRA(_ZTI7S1500C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1500C1),152, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3043C3  {
  int s3043c3f0;
  __tsi64 s3043c3f1;
  void *s3043c3f2[4];
  int s3043c3f3[2];
  void *s3043c3f4;
  ::S79C8_nt s3043c3f5;
  void *s3043c3f6[2];
  virtual  ~S3043C3(); // _ZN7S3043C3D1Ev
  virtual void  v17(); // _ZN7S3043C33v17Ev
  virtual void  v18(); // _ZN7S3043C33v18Ev
  virtual void  v19(); // _ZN7S3043C33v19Ev
  virtual void  v20(); // _ZN7S3043C33v20Ev
  virtual void  v21(); // _ZN7S3043C33v21Ev
  virtual void  v22(); // _ZN7S3043C33v22Ev
  virtual void  v23(); // _ZN7S3043C33v23Ev
  virtual void  v24(); // _ZN7S3043C33v24Ev
  virtual void  v25(); // _ZN7S3043C33v25Ev
  virtual void  v26(); // _ZN7S3043C33v26Ev
  virtual void  v27(); // _ZN7S3043C33v27Ev
  virtual void  v28(); // _ZN7S3043C33v28Ev
  virtual void  v29(); // _ZN7S3043C33v29Ev
  virtual void  v30(); // _ZN7S3043C33v30Ev
  virtual void  v31(); // _ZN7S3043C33v31Ev
  virtual void  v32(); // _ZN7S3043C33v32Ev
  virtual void  v33(); // _ZN7S3043C33v33Ev
  virtual void  v34(); // _ZN7S3043C33v34Ev
  virtual void  v35(); // _ZN7S3043C33v35Ev
  virtual void  v36(); // _ZN7S3043C33v36Ev
  virtual void  v37(); // _ZN7S3043C33v37Ev
  virtual void  v38(); // _ZN7S3043C33v38Ev
  virtual void  v39(); // _ZN7S3043C33v39Ev
  virtual void  v40(); // _ZN7S3043C33v40Ev
  virtual void  v41(); // _ZN7S3043C33v41Ev
  virtual void  v42(); // _ZN7S3043C33v42Ev
  virtual void  v43(); // _ZN7S3043C33v43Ev
  virtual void  v44(); // _ZN7S3043C33v44Ev
  virtual void  v45(); // _ZN7S3043C33v45Ev
  virtual void  v46(); // _ZN7S3043C33v46Ev
  virtual void  v47(); // _ZN7S3043C33v47Ev
  virtual void  v48(); // _ZN7S3043C33v48Ev
  virtual void  v49(); // _ZN7S3043C33v49Ev
  virtual void  v50(); // _ZN7S3043C33v50Ev
  virtual void  v51(); // _ZN7S3043C33v51Ev
  virtual void  v52(); // _ZN7S3043C33v52Ev
  virtual void  v53(); // _ZN7S3043C33v53Ev
  virtual void  v54(); // _ZN7S3043C33v54Ev
  virtual void  v55(); // _ZN7S3043C33v55Ev
  virtual void  v56(); // _ZN7S3043C33v56Ev
  virtual void  v57(); // _ZN7S3043C33v57Ev
  virtual void  v58(); // _ZN7S3043C33v58Ev
  virtual void  v59(); // _ZN7S3043C33v59Ev
  virtual void  v60(); // _ZN7S3043C33v60Ev
  virtual void  v61(); // _ZN7S3043C33v61Ev
  virtual void  v62(); // _ZN7S3043C33v62Ev
  virtual void  v63(); // _ZN7S3043C33v63Ev
  virtual void  v64(); // _ZN7S3043C33v64Ev
  virtual void  v65(); // _ZN7S3043C33v65Ev
  virtual void  v66(); // _ZN7S3043C33v66Ev
  virtual void  v67(); // _ZN7S3043C33v67Ev
  virtual void  v68(); // _ZN7S3043C33v68Ev
  virtual void  v69(); // _ZN7S3043C33v69Ev
  virtual void  v70(); // _ZN7S3043C33v70Ev
  virtual void  v71(); // _ZN7S3043C33v71Ev
  virtual void  v72(); // _ZN7S3043C33v72Ev
  virtual void  v73(); // _ZN7S3043C33v73Ev
  virtual void  v74(); // _ZN7S3043C33v74Ev
  virtual void  v75(); // _ZN7S3043C33v75Ev
  virtual void  v76(); // _ZN7S3043C33v76Ev
  virtual void  v77(); // _ZN7S3043C33v77Ev
  virtual void  v78(); // _ZN7S3043C33v78Ev
  virtual void  v79(); // _ZN7S3043C33v79Ev
  virtual void  v80(); // _ZN7S3043C33v80Ev
  S3043C3(); // tgen
};
//SIG(-1 S3043C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3043C3 ::~S3043C3(){ note_dtor("S3043C3", this);}
void  S3043C3 ::v17(){vfunc_called(this, "_ZN7S3043C33v17Ev");}
void  S3043C3 ::v18(){vfunc_called(this, "_ZN7S3043C33v18Ev");}
void  S3043C3 ::v19(){vfunc_called(this, "_ZN7S3043C33v19Ev");}
void  S3043C3 ::v20(){vfunc_called(this, "_ZN7S3043C33v20Ev");}
void  S3043C3 ::v21(){vfunc_called(this, "_ZN7S3043C33v21Ev");}
void  S3043C3 ::v22(){vfunc_called(this, "_ZN7S3043C33v22Ev");}
void  S3043C3 ::v23(){vfunc_called(this, "_ZN7S3043C33v23Ev");}
void  S3043C3 ::v24(){vfunc_called(this, "_ZN7S3043C33v24Ev");}
void  S3043C3 ::v25(){vfunc_called(this, "_ZN7S3043C33v25Ev");}
void  S3043C3 ::v26(){vfunc_called(this, "_ZN7S3043C33v26Ev");}
void  S3043C3 ::v27(){vfunc_called(this, "_ZN7S3043C33v27Ev");}
void  S3043C3 ::v28(){vfunc_called(this, "_ZN7S3043C33v28Ev");}
void  S3043C3 ::v29(){vfunc_called(this, "_ZN7S3043C33v29Ev");}
void  S3043C3 ::v30(){vfunc_called(this, "_ZN7S3043C33v30Ev");}
void  S3043C3 ::v31(){vfunc_called(this, "_ZN7S3043C33v31Ev");}
void  S3043C3 ::v32(){vfunc_called(this, "_ZN7S3043C33v32Ev");}
void  S3043C3 ::v33(){vfunc_called(this, "_ZN7S3043C33v33Ev");}
void  S3043C3 ::v34(){vfunc_called(this, "_ZN7S3043C33v34Ev");}
void  S3043C3 ::v35(){vfunc_called(this, "_ZN7S3043C33v35Ev");}
void  S3043C3 ::v36(){vfunc_called(this, "_ZN7S3043C33v36Ev");}
void  S3043C3 ::v37(){vfunc_called(this, "_ZN7S3043C33v37Ev");}
void  S3043C3 ::v38(){vfunc_called(this, "_ZN7S3043C33v38Ev");}
void  S3043C3 ::v39(){vfunc_called(this, "_ZN7S3043C33v39Ev");}
void  S3043C3 ::v40(){vfunc_called(this, "_ZN7S3043C33v40Ev");}
void  S3043C3 ::v41(){vfunc_called(this, "_ZN7S3043C33v41Ev");}
void  S3043C3 ::v42(){vfunc_called(this, "_ZN7S3043C33v42Ev");}
void  S3043C3 ::v43(){vfunc_called(this, "_ZN7S3043C33v43Ev");}
void  S3043C3 ::v44(){vfunc_called(this, "_ZN7S3043C33v44Ev");}
void  S3043C3 ::v45(){vfunc_called(this, "_ZN7S3043C33v45Ev");}
void  S3043C3 ::v46(){vfunc_called(this, "_ZN7S3043C33v46Ev");}
void  S3043C3 ::v47(){vfunc_called(this, "_ZN7S3043C33v47Ev");}
void  S3043C3 ::v48(){vfunc_called(this, "_ZN7S3043C33v48Ev");}
void  S3043C3 ::v49(){vfunc_called(this, "_ZN7S3043C33v49Ev");}
void  S3043C3 ::v50(){vfunc_called(this, "_ZN7S3043C33v50Ev");}
void  S3043C3 ::v51(){vfunc_called(this, "_ZN7S3043C33v51Ev");}
void  S3043C3 ::v52(){vfunc_called(this, "_ZN7S3043C33v52Ev");}
void  S3043C3 ::v53(){vfunc_called(this, "_ZN7S3043C33v53Ev");}
void  S3043C3 ::v54(){vfunc_called(this, "_ZN7S3043C33v54Ev");}
void  S3043C3 ::v55(){vfunc_called(this, "_ZN7S3043C33v55Ev");}
void  S3043C3 ::v56(){vfunc_called(this, "_ZN7S3043C33v56Ev");}
void  S3043C3 ::v57(){vfunc_called(this, "_ZN7S3043C33v57Ev");}
void  S3043C3 ::v58(){vfunc_called(this, "_ZN7S3043C33v58Ev");}
void  S3043C3 ::v59(){vfunc_called(this, "_ZN7S3043C33v59Ev");}
void  S3043C3 ::v60(){vfunc_called(this, "_ZN7S3043C33v60Ev");}
void  S3043C3 ::v61(){vfunc_called(this, "_ZN7S3043C33v61Ev");}
void  S3043C3 ::v62(){vfunc_called(this, "_ZN7S3043C33v62Ev");}
void  S3043C3 ::v63(){vfunc_called(this, "_ZN7S3043C33v63Ev");}
void  S3043C3 ::v64(){vfunc_called(this, "_ZN7S3043C33v64Ev");}
void  S3043C3 ::v65(){vfunc_called(this, "_ZN7S3043C33v65Ev");}
void  S3043C3 ::v66(){vfunc_called(this, "_ZN7S3043C33v66Ev");}
void  S3043C3 ::v67(){vfunc_called(this, "_ZN7S3043C33v67Ev");}
void  S3043C3 ::v68(){vfunc_called(this, "_ZN7S3043C33v68Ev");}
void  S3043C3 ::v69(){vfunc_called(this, "_ZN7S3043C33v69Ev");}
void  S3043C3 ::v70(){vfunc_called(this, "_ZN7S3043C33v70Ev");}
void  S3043C3 ::v71(){vfunc_called(this, "_ZN7S3043C33v71Ev");}
void  S3043C3 ::v72(){vfunc_called(this, "_ZN7S3043C33v72Ev");}
void  S3043C3 ::v73(){vfunc_called(this, "_ZN7S3043C33v73Ev");}
void  S3043C3 ::v74(){vfunc_called(this, "_ZN7S3043C33v74Ev");}
void  S3043C3 ::v75(){vfunc_called(this, "_ZN7S3043C33v75Ev");}
void  S3043C3 ::v76(){vfunc_called(this, "_ZN7S3043C33v76Ev");}
void  S3043C3 ::v77(){vfunc_called(this, "_ZN7S3043C33v77Ev");}
void  S3043C3 ::v78(){vfunc_called(this, "_ZN7S3043C33v78Ev");}
void  S3043C3 ::v79(){vfunc_called(this, "_ZN7S3043C33v79Ev");}
void  S3043C3 ::v80(){vfunc_called(this, "_ZN7S3043C33v80Ev");}
S3043C3 ::S3043C3(){ note_ctor("S3043C3", this);} // tgen

static void Test_S3043C3()
{
  extern Class_Descriptor cd_S3043C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3043C3, buf);
    S3043C3 *dp, &lv = *(dp=new (buf) S3043C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3043C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3043C3)");
    check_field_offset(lv, s3043c3f0, ABISELECT(8,4), "S3043C3.s3043c3f0");
    check_field_offset(lv, s3043c3f1, ABISELECT(16,8), "S3043C3.s3043c3f1");
    check_field_offset(lv, s3043c3f2, ABISELECT(24,16), "S3043C3.s3043c3f2");
    check_field_offset(lv, s3043c3f3, ABISELECT(56,32), "S3043C3.s3043c3f3");
    check_field_offset(lv, s3043c3f4, ABISELECT(64,40), "S3043C3.s3043c3f4");
    check_field_offset(lv, s3043c3f5, ABISELECT(72,44), "S3043C3.s3043c3f5");
    check_field_offset(lv, s3043c3f6, ABISELECT(80,52), "S3043C3.s3043c3f6");
    test_class_info(&lv, &cd_S3043C3);
    dp->~S3043C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3043C3(Test_S3043C3, "S3043C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3043C3C1Ev();
extern void _ZN7S3043C3D1Ev();
Name_Map name_map_S3043C3[] = {
  NSPAIR(_ZN7S3043C3C1Ev),
  NSPAIR(_ZN7S3043C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3043C3[];
extern void _ZN7S3043C3D1Ev();
extern void _ZN7S3043C3D0Ev();
extern void _ZN7S3043C33v17Ev();
extern void _ZN7S3043C33v18Ev();
extern void _ZN7S3043C33v19Ev();
extern void _ZN7S3043C33v20Ev();
extern void _ZN7S3043C33v21Ev();
extern void _ZN7S3043C33v22Ev();
extern void _ZN7S3043C33v23Ev();
extern void _ZN7S3043C33v24Ev();
extern void _ZN7S3043C33v25Ev();
extern void _ZN7S3043C33v26Ev();
extern void _ZN7S3043C33v27Ev();
extern void _ZN7S3043C33v28Ev();
extern void _ZN7S3043C33v29Ev();
extern void _ZN7S3043C33v30Ev();
extern void _ZN7S3043C33v31Ev();
extern void _ZN7S3043C33v32Ev();
extern void _ZN7S3043C33v33Ev();
extern void _ZN7S3043C33v34Ev();
extern void _ZN7S3043C33v35Ev();
extern void _ZN7S3043C33v36Ev();
extern void _ZN7S3043C33v37Ev();
extern void _ZN7S3043C33v38Ev();
extern void _ZN7S3043C33v39Ev();
extern void _ZN7S3043C33v40Ev();
extern void _ZN7S3043C33v41Ev();
extern void _ZN7S3043C33v42Ev();
extern void _ZN7S3043C33v43Ev();
extern void _ZN7S3043C33v44Ev();
extern void _ZN7S3043C33v45Ev();
extern void _ZN7S3043C33v46Ev();
extern void _ZN7S3043C33v47Ev();
extern void _ZN7S3043C33v48Ev();
extern void _ZN7S3043C33v49Ev();
extern void _ZN7S3043C33v50Ev();
extern void _ZN7S3043C33v51Ev();
extern void _ZN7S3043C33v52Ev();
extern void _ZN7S3043C33v53Ev();
extern void _ZN7S3043C33v54Ev();
extern void _ZN7S3043C33v55Ev();
extern void _ZN7S3043C33v56Ev();
extern void _ZN7S3043C33v57Ev();
extern void _ZN7S3043C33v58Ev();
extern void _ZN7S3043C33v59Ev();
extern void _ZN7S3043C33v60Ev();
extern void _ZN7S3043C33v61Ev();
extern void _ZN7S3043C33v62Ev();
extern void _ZN7S3043C33v63Ev();
extern void _ZN7S3043C33v64Ev();
extern void _ZN7S3043C33v65Ev();
extern void _ZN7S3043C33v66Ev();
extern void _ZN7S3043C33v67Ev();
extern void _ZN7S3043C33v68Ev();
extern void _ZN7S3043C33v69Ev();
extern void _ZN7S3043C33v70Ev();
extern void _ZN7S3043C33v71Ev();
extern void _ZN7S3043C33v72Ev();
extern void _ZN7S3043C33v73Ev();
extern void _ZN7S3043C33v74Ev();
extern void _ZN7S3043C33v75Ev();
extern void _ZN7S3043C33v76Ev();
extern void _ZN7S3043C33v77Ev();
extern void _ZN7S3043C33v78Ev();
extern void _ZN7S3043C33v79Ev();
extern void _ZN7S3043C33v80Ev();
static  VTBL_ENTRY vtc_S3043C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3043C3[0]),
  (VTBL_ENTRY)&_ZN7S3043C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3043C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v80Ev,
};
extern VTBL_ENTRY _ZTI7S3043C3[];
extern  VTBL_ENTRY _ZTV7S3043C3[];
Class_Descriptor cd_S3043C3 = {  "S3043C3", // class name
  0,0,//no base classes
  &(vtc_S3043C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3043C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3043C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3043C5  {
  virtual void  v81(); // _ZN7S3043C53v81Ev
  virtual void  v82(); // _ZN7S3043C53v82Ev
  virtual void  v83(); // _ZN7S3043C53v83Ev
  virtual void  v84(); // _ZN7S3043C53v84Ev
  virtual void  v85(); // _ZN7S3043C53v85Ev
  virtual void  v86(); // _ZN7S3043C53v86Ev
  virtual void  v87(); // _ZN7S3043C53v87Ev
  virtual void  v88(); // _ZN7S3043C53v88Ev
  virtual void  v89(); // _ZN7S3043C53v89Ev
  virtual void  v90(); // _ZN7S3043C53v90Ev
  virtual void  v91(); // _ZN7S3043C53v91Ev
  virtual void  v92(); // _ZN7S3043C53v92Ev
  virtual void  v93(); // _ZN7S3043C53v93Ev
  virtual void  v94(); // _ZN7S3043C53v94Ev
  virtual void  v95(); // _ZN7S3043C53v95Ev
  virtual void  v96(); // _ZN7S3043C53v96Ev
  ~S3043C5(); // tgen
  S3043C5(); // tgen
};
//SIG(-1 S3043C5) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S3043C5 ::v81(){vfunc_called(this, "_ZN7S3043C53v81Ev");}
void  S3043C5 ::v82(){vfunc_called(this, "_ZN7S3043C53v82Ev");}
void  S3043C5 ::v83(){vfunc_called(this, "_ZN7S3043C53v83Ev");}
void  S3043C5 ::v84(){vfunc_called(this, "_ZN7S3043C53v84Ev");}
void  S3043C5 ::v85(){vfunc_called(this, "_ZN7S3043C53v85Ev");}
void  S3043C5 ::v86(){vfunc_called(this, "_ZN7S3043C53v86Ev");}
void  S3043C5 ::v87(){vfunc_called(this, "_ZN7S3043C53v87Ev");}
void  S3043C5 ::v88(){vfunc_called(this, "_ZN7S3043C53v88Ev");}
void  S3043C5 ::v89(){vfunc_called(this, "_ZN7S3043C53v89Ev");}
void  S3043C5 ::v90(){vfunc_called(this, "_ZN7S3043C53v90Ev");}
void  S3043C5 ::v91(){vfunc_called(this, "_ZN7S3043C53v91Ev");}
void  S3043C5 ::v92(){vfunc_called(this, "_ZN7S3043C53v92Ev");}
void  S3043C5 ::v93(){vfunc_called(this, "_ZN7S3043C53v93Ev");}
void  S3043C5 ::v94(){vfunc_called(this, "_ZN7S3043C53v94Ev");}
void  S3043C5 ::v95(){vfunc_called(this, "_ZN7S3043C53v95Ev");}
void  S3043C5 ::v96(){vfunc_called(this, "_ZN7S3043C53v96Ev");}
S3043C5 ::~S3043C5(){ note_dtor("S3043C5", this);} // tgen
S3043C5 ::S3043C5(){ note_ctor("S3043C5", this);} // tgen

static void Test_S3043C5()
{
  extern Class_Descriptor cd_S3043C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3043C5, buf);
    S3043C5 *dp, &lv = *(dp=new (buf) S3043C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3043C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3043C5)");
    test_class_info(&lv, &cd_S3043C5);
    dp->~S3043C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3043C5(Test_S3043C5, "S3043C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3043C5C1Ev();
extern void _ZN7S3043C5D1Ev();
Name_Map name_map_S3043C5[] = {
  NSPAIR(_ZN7S3043C5C1Ev),
  NSPAIR(_ZN7S3043C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3043C5[];
extern void _ZN7S3043C53v81Ev();
extern void _ZN7S3043C53v82Ev();
extern void _ZN7S3043C53v83Ev();
extern void _ZN7S3043C53v84Ev();
extern void _ZN7S3043C53v85Ev();
extern void _ZN7S3043C53v86Ev();
extern void _ZN7S3043C53v87Ev();
extern void _ZN7S3043C53v88Ev();
extern void _ZN7S3043C53v89Ev();
extern void _ZN7S3043C53v90Ev();
extern void _ZN7S3043C53v91Ev();
extern void _ZN7S3043C53v92Ev();
extern void _ZN7S3043C53v93Ev();
extern void _ZN7S3043C53v94Ev();
extern void _ZN7S3043C53v95Ev();
extern void _ZN7S3043C53v96Ev();
static  VTBL_ENTRY vtc_S3043C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3043C5[0]),
  (VTBL_ENTRY)&_ZN7S3043C53v81Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v82Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v83Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v84Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v85Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v86Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v87Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v88Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v89Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v90Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v91Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v92Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v93Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v94Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v95Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v96Ev,
};
extern VTBL_ENTRY _ZTI7S3043C5[];
extern  VTBL_ENTRY _ZTV7S3043C5[];
Class_Descriptor cd_S3043C5 = {  "S3043C5", // class name
  0,0,//no base classes
  &(vtc_S3043C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3043C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3043C5),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3043C6  {
  virtual void  v97(); // _ZN7S3043C63v97Ev
  virtual void  v98(); // _ZN7S3043C63v98Ev
  virtual void  v99(); // _ZN7S3043C63v99Ev
  virtual void  v100(); // _ZN7S3043C64v100Ev
  virtual void  v101(); // _ZN7S3043C64v101Ev
  virtual void  v102(); // _ZN7S3043C64v102Ev
  virtual void  v103(); // _ZN7S3043C64v103Ev
  virtual void  v104(); // _ZN7S3043C64v104Ev
  virtual void  v105(); // _ZN7S3043C64v105Ev
  ~S3043C6(); // tgen
  S3043C6(); // tgen
};
//SIG(-1 S3043C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S3043C6 ::v97(){vfunc_called(this, "_ZN7S3043C63v97Ev");}
void  S3043C6 ::v98(){vfunc_called(this, "_ZN7S3043C63v98Ev");}
void  S3043C6 ::v99(){vfunc_called(this, "_ZN7S3043C63v99Ev");}
void  S3043C6 ::v100(){vfunc_called(this, "_ZN7S3043C64v100Ev");}
void  S3043C6 ::v101(){vfunc_called(this, "_ZN7S3043C64v101Ev");}
void  S3043C6 ::v102(){vfunc_called(this, "_ZN7S3043C64v102Ev");}
void  S3043C6 ::v103(){vfunc_called(this, "_ZN7S3043C64v103Ev");}
void  S3043C6 ::v104(){vfunc_called(this, "_ZN7S3043C64v104Ev");}
void  S3043C6 ::v105(){vfunc_called(this, "_ZN7S3043C64v105Ev");}
S3043C6 ::~S3043C6(){ note_dtor("S3043C6", this);} // tgen
S3043C6 ::S3043C6(){ note_ctor("S3043C6", this);} // tgen

static void Test_S3043C6()
{
  extern Class_Descriptor cd_S3043C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3043C6, buf);
    S3043C6 *dp, &lv = *(dp=new (buf) S3043C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3043C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3043C6)");
    test_class_info(&lv, &cd_S3043C6);
    dp->~S3043C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3043C6(Test_S3043C6, "S3043C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3043C6C1Ev();
extern void _ZN7S3043C6D1Ev();
Name_Map name_map_S3043C6[] = {
  NSPAIR(_ZN7S3043C6C1Ev),
  NSPAIR(_ZN7S3043C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3043C6[];
extern void _ZN7S3043C63v97Ev();
extern void _ZN7S3043C63v98Ev();
extern void _ZN7S3043C63v99Ev();
extern void _ZN7S3043C64v100Ev();
extern void _ZN7S3043C64v101Ev();
extern void _ZN7S3043C64v102Ev();
extern void _ZN7S3043C64v103Ev();
extern void _ZN7S3043C64v104Ev();
extern void _ZN7S3043C64v105Ev();
static  VTBL_ENTRY vtc_S3043C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3043C6[0]),
  (VTBL_ENTRY)&_ZN7S3043C63v97Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v98Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v99Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v100Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v101Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v102Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v103Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v104Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v105Ev,
};
extern VTBL_ENTRY _ZTI7S3043C6[];
extern  VTBL_ENTRY _ZTV7S3043C6[];
Class_Descriptor cd_S3043C6 = {  "S3043C6", // class name
  0,0,//no base classes
  &(vtc_S3043C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3043C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3043C6),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3043C2  : S3043C3 , S3043C5 , S3043C6 {
  void *s3043c2f0;
  ::S79C39_nt s3043c2f1;
  unsigned int s3043c2f2:1;
  unsigned int s3043c2f3:1;
  unsigned int s3043c2f4:1;
  unsigned int s3043c2f5:1;
  virtual  ~S3043C2(); // _ZN7S3043C2D1Ev
  virtual void  v106(); // _ZN7S3043C24v106Ev
  virtual void  v107(); // _ZN7S3043C24v107Ev
  virtual void  v108(); // _ZN7S3043C24v108Ev
  virtual void  v109(); // _ZN7S3043C24v109Ev
  virtual void  v110(); // _ZN7S3043C24v110Ev
  virtual void  v111(); // _ZN7S3043C24v111Ev
  virtual void  v112(); // _ZN7S3043C24v112Ev
  virtual void  v113(); // _ZN7S3043C24v113Ev
  virtual void  v114(); // _ZN7S3043C24v114Ev
  virtual void  v115(); // _ZN7S3043C24v115Ev
  virtual void  v116(); // _ZN7S3043C24v116Ev
  virtual void  v117(); // _ZN7S3043C24v117Ev
  virtual void  v118(); // _ZN7S3043C24v118Ev
  virtual void  v119(); // _ZN7S3043C24v119Ev
  virtual void  v120(); // _ZN7S3043C24v120Ev
  virtual void  v121(); // _ZN7S3043C24v121Ev
  virtual void  v122(); // _ZN7S3043C24v122Ev
  virtual void  v123(); // _ZN7S3043C24v123Ev
  virtual void  v124(); // _ZN7S3043C24v124Ev
  virtual void  v125(); // _ZN7S3043C24v125Ev
  virtual void  v126(); // _ZN7S3043C24v126Ev
  virtual void  v127(); // _ZN7S3043C24v127Ev
  virtual void  v128(); // _ZN7S3043C24v128Ev
  virtual void  v129(); // _ZN7S3043C24v129Ev
  S3043C2(); // tgen
};
//SIG(-1 S3043C2) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S3043C2 ::~S3043C2(){ note_dtor("S3043C2", this);}
void  S3043C2 ::v106(){vfunc_called(this, "_ZN7S3043C24v106Ev");}
void  S3043C2 ::v107(){vfunc_called(this, "_ZN7S3043C24v107Ev");}
void  S3043C2 ::v108(){vfunc_called(this, "_ZN7S3043C24v108Ev");}
void  S3043C2 ::v109(){vfunc_called(this, "_ZN7S3043C24v109Ev");}
void  S3043C2 ::v110(){vfunc_called(this, "_ZN7S3043C24v110Ev");}
void  S3043C2 ::v111(){vfunc_called(this, "_ZN7S3043C24v111Ev");}
void  S3043C2 ::v112(){vfunc_called(this, "_ZN7S3043C24v112Ev");}
void  S3043C2 ::v113(){vfunc_called(this, "_ZN7S3043C24v113Ev");}
void  S3043C2 ::v114(){vfunc_called(this, "_ZN7S3043C24v114Ev");}
void  S3043C2 ::v115(){vfunc_called(this, "_ZN7S3043C24v115Ev");}
void  S3043C2 ::v116(){vfunc_called(this, "_ZN7S3043C24v116Ev");}
void  S3043C2 ::v117(){vfunc_called(this, "_ZN7S3043C24v117Ev");}
void  S3043C2 ::v118(){vfunc_called(this, "_ZN7S3043C24v118Ev");}
void  S3043C2 ::v119(){vfunc_called(this, "_ZN7S3043C24v119Ev");}
void  S3043C2 ::v120(){vfunc_called(this, "_ZN7S3043C24v120Ev");}
void  S3043C2 ::v121(){vfunc_called(this, "_ZN7S3043C24v121Ev");}
void  S3043C2 ::v122(){vfunc_called(this, "_ZN7S3043C24v122Ev");}
void  S3043C2 ::v123(){vfunc_called(this, "_ZN7S3043C24v123Ev");}
void  S3043C2 ::v124(){vfunc_called(this, "_ZN7S3043C24v124Ev");}
void  S3043C2 ::v125(){vfunc_called(this, "_ZN7S3043C24v125Ev");}
void  S3043C2 ::v126(){vfunc_called(this, "_ZN7S3043C24v126Ev");}
void  S3043C2 ::v127(){vfunc_called(this, "_ZN7S3043C24v127Ev");}
void  S3043C2 ::v128(){vfunc_called(this, "_ZN7S3043C24v128Ev");}
void  S3043C2 ::v129(){vfunc_called(this, "_ZN7S3043C24v129Ev");}
S3043C2 ::S3043C2(){ note_ctor("S3043C2", this);} // tgen

static void Test_S3043C2()
{
  extern Class_Descriptor cd_S3043C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S3043C2, buf);
    S3043C2 *dp, &lv = *(dp=new (buf) S3043C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S3043C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3043C2)");
    check_base_class_offset(lv, (S3043C3*), 0, "S3043C2");
    check_base_class_offset(lv, (S3043C5*), ABISELECT(96,60), "S3043C2");
    check_base_class_offset(lv, (S3043C6*), ABISELECT(104,64), "S3043C2");
    check_field_offset(lv, s3043c2f0, ABISELECT(112,68), "S3043C2.s3043c2f0");
    check_field_offset(lv, s3043c2f1, ABISELECT(120,72), "S3043C2.s3043c2f1");
    set_bf_and_test(lv, s3043c2f2, ABISELECT(136,84), 0, 1, 1, "S3043C2");
    set_bf_and_test(lv, s3043c2f3, ABISELECT(136,84), 1, 1, 1, "S3043C2");
    set_bf_and_test(lv, s3043c2f4, ABISELECT(136,84), 2, 1, 1, "S3043C2");
    set_bf_and_test(lv, s3043c2f5, ABISELECT(136,84), 3, 1, 1, "S3043C2");
    test_class_info(&lv, &cd_S3043C2);
    dp->~S3043C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3043C2(Test_S3043C2, "S3043C2", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S3043C2C1Ev();
extern void _ZN7S3043C2D1Ev();
Name_Map name_map_S3043C2[] = {
  NSPAIR(_ZN7S3043C2C1Ev),
  NSPAIR(_ZN7S3043C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3043C3;
extern VTBL_ENTRY _ZTI7S3043C3[];
extern  VTBL_ENTRY _ZTV7S3043C3[];
extern Class_Descriptor cd_S3043C5;
extern VTBL_ENTRY _ZTI7S3043C5[];
extern  VTBL_ENTRY _ZTV7S3043C5[];
extern Class_Descriptor cd_S3043C6;
extern VTBL_ENTRY _ZTI7S3043C6[];
extern  VTBL_ENTRY _ZTV7S3043C6[];
static Base_Class bases_S3043C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3043C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3043C5,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3043C6,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3043C2[];
extern void _ZN7S3043C2D1Ev();
extern void _ZN7S3043C2D0Ev();
extern void _ZN7S3043C33v17Ev();
extern void _ZN7S3043C33v18Ev();
extern void _ZN7S3043C33v19Ev();
extern void _ZN7S3043C33v20Ev();
extern void _ZN7S3043C33v21Ev();
extern void _ZN7S3043C33v22Ev();
extern void _ZN7S3043C33v23Ev();
extern void _ZN7S3043C33v24Ev();
extern void _ZN7S3043C33v25Ev();
extern void _ZN7S3043C33v26Ev();
extern void _ZN7S3043C33v27Ev();
extern void _ZN7S3043C33v28Ev();
extern void _ZN7S3043C33v29Ev();
extern void _ZN7S3043C33v30Ev();
extern void _ZN7S3043C33v31Ev();
extern void _ZN7S3043C33v32Ev();
extern void _ZN7S3043C33v33Ev();
extern void _ZN7S3043C33v34Ev();
extern void _ZN7S3043C33v35Ev();
extern void _ZN7S3043C33v36Ev();
extern void _ZN7S3043C33v37Ev();
extern void _ZN7S3043C33v38Ev();
extern void _ZN7S3043C33v39Ev();
extern void _ZN7S3043C33v40Ev();
extern void _ZN7S3043C33v41Ev();
extern void _ZN7S3043C33v42Ev();
extern void _ZN7S3043C33v43Ev();
extern void _ZN7S3043C33v44Ev();
extern void _ZN7S3043C33v45Ev();
extern void _ZN7S3043C33v46Ev();
extern void _ZN7S3043C33v47Ev();
extern void _ZN7S3043C33v48Ev();
extern void _ZN7S3043C33v49Ev();
extern void _ZN7S3043C33v50Ev();
extern void _ZN7S3043C33v51Ev();
extern void _ZN7S3043C33v52Ev();
extern void _ZN7S3043C33v53Ev();
extern void _ZN7S3043C33v54Ev();
extern void _ZN7S3043C33v55Ev();
extern void _ZN7S3043C33v56Ev();
extern void _ZN7S3043C33v57Ev();
extern void _ZN7S3043C33v58Ev();
extern void _ZN7S3043C33v59Ev();
extern void _ZN7S3043C33v60Ev();
extern void _ZN7S3043C33v61Ev();
extern void _ZN7S3043C33v62Ev();
extern void _ZN7S3043C33v63Ev();
extern void _ZN7S3043C33v64Ev();
extern void _ZN7S3043C33v65Ev();
extern void _ZN7S3043C33v66Ev();
extern void _ZN7S3043C33v67Ev();
extern void _ZN7S3043C33v68Ev();
extern void _ZN7S3043C33v69Ev();
extern void _ZN7S3043C33v70Ev();
extern void _ZN7S3043C33v71Ev();
extern void _ZN7S3043C33v72Ev();
extern void _ZN7S3043C33v73Ev();
extern void _ZN7S3043C33v74Ev();
extern void _ZN7S3043C33v75Ev();
extern void _ZN7S3043C33v76Ev();
extern void _ZN7S3043C33v77Ev();
extern void _ZN7S3043C33v78Ev();
extern void _ZN7S3043C33v79Ev();
extern void _ZN7S3043C33v80Ev();
extern void _ZN7S3043C24v106Ev();
extern void _ZN7S3043C24v107Ev();
extern void _ZN7S3043C24v108Ev();
extern void _ZN7S3043C24v109Ev();
extern void _ZN7S3043C24v110Ev();
extern void _ZN7S3043C24v111Ev();
extern void _ZN7S3043C24v112Ev();
extern void _ZN7S3043C24v113Ev();
extern void _ZN7S3043C24v114Ev();
extern void _ZN7S3043C24v115Ev();
extern void _ZN7S3043C24v116Ev();
extern void _ZN7S3043C24v117Ev();
extern void _ZN7S3043C24v118Ev();
extern void _ZN7S3043C24v119Ev();
extern void _ZN7S3043C24v120Ev();
extern void _ZN7S3043C24v121Ev();
extern void _ZN7S3043C24v122Ev();
extern void _ZN7S3043C24v123Ev();
extern void _ZN7S3043C24v124Ev();
extern void _ZN7S3043C24v125Ev();
extern void _ZN7S3043C24v126Ev();
extern void _ZN7S3043C24v127Ev();
extern void _ZN7S3043C24v128Ev();
extern void _ZN7S3043C24v129Ev();
extern void _ZN7S3043C53v81Ev();
extern void _ZN7S3043C53v82Ev();
extern void _ZN7S3043C53v83Ev();
extern void _ZN7S3043C53v84Ev();
extern void _ZN7S3043C53v85Ev();
extern void _ZN7S3043C53v86Ev();
extern void _ZN7S3043C53v87Ev();
extern void _ZN7S3043C53v88Ev();
extern void _ZN7S3043C53v89Ev();
extern void _ZN7S3043C53v90Ev();
extern void _ZN7S3043C53v91Ev();
extern void _ZN7S3043C53v92Ev();
extern void _ZN7S3043C53v93Ev();
extern void _ZN7S3043C53v94Ev();
extern void _ZN7S3043C53v95Ev();
extern void _ZN7S3043C53v96Ev();
extern void _ZN7S3043C63v97Ev();
extern void _ZN7S3043C63v98Ev();
extern void _ZN7S3043C63v99Ev();
extern void _ZN7S3043C64v100Ev();
extern void _ZN7S3043C64v101Ev();
extern void _ZN7S3043C64v102Ev();
extern void _ZN7S3043C64v103Ev();
extern void _ZN7S3043C64v104Ev();
extern void _ZN7S3043C64v105Ev();
static  VTBL_ENTRY vtc_S3043C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3043C2[0]),
  (VTBL_ENTRY)&_ZN7S3043C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3043C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v129Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3043C2[0]),
  (VTBL_ENTRY)&_ZN7S3043C53v81Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v82Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v83Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v84Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v85Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v86Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v87Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v88Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v89Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v90Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v91Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v92Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v93Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v94Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v95Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v96Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S3043C2[0]),
  (VTBL_ENTRY)&_ZN7S3043C63v97Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v98Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v99Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v100Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v101Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v102Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v103Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v104Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v105Ev,
};
extern VTBL_ENTRY _ZTI7S3043C2[];
extern  VTBL_ENTRY _ZTV7S3043C2[];
Class_Descriptor cd_S3043C2 = {  "S3043C2", // class name
  bases_S3043C2, 3,
  &(vtc_S3043C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,88), // object size
  NSPAIRA(_ZTI7S3043C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S3043C2),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3043C1  : S3043C2 {
  ::S79C44 s3043c1f0;
  ::S79C40 s3043c1f1;
  void *s3043c1f2;
  virtual  ~S3043C1(); // _ZN7S3043C1D1Ev
  virtual void  v1(); // _ZN7S3043C12v1Ev
  virtual void  v2(); // _ZN7S3043C12v2Ev
  virtual void  v3(); // _ZN7S3043C12v3Ev
  virtual void  v4(); // _ZN7S3043C12v4Ev
  virtual void  v5(); // _ZN7S3043C12v5Ev
  virtual void  v6(); // _ZN7S3043C12v6Ev
  virtual void  v7(); // _ZN7S3043C12v7Ev
  virtual void  v8(); // _ZN7S3043C12v8Ev
  virtual void  v9(); // _ZN7S3043C12v9Ev
  virtual void  v10(); // _ZN7S3043C13v10Ev
  virtual void  v11(); // _ZN7S3043C13v11Ev
  virtual void  v12(); // _ZN7S3043C13v12Ev
  virtual void  v13(); // _ZN7S3043C13v13Ev
  virtual void  v14(); // _ZN7S3043C13v14Ev
  virtual void  v15(); // _ZN7S3043C13v15Ev
  virtual void  v16(); // _ZN7S3043C13v16Ev
  S3043C1(); // tgen
};
//SIG(1 S3043C1) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96} BC6{ v97 v98 v99 v100 v101 v102 v103 v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC11{ BC12{ BC10}} FC8 Fp}


 S3043C1 ::~S3043C1(){ note_dtor("S3043C1", this);}
void  S3043C1 ::v1(){vfunc_called(this, "_ZN7S3043C12v1Ev");}
void  S3043C1 ::v2(){vfunc_called(this, "_ZN7S3043C12v2Ev");}
void  S3043C1 ::v3(){vfunc_called(this, "_ZN7S3043C12v3Ev");}
void  S3043C1 ::v4(){vfunc_called(this, "_ZN7S3043C12v4Ev");}
void  S3043C1 ::v5(){vfunc_called(this, "_ZN7S3043C12v5Ev");}
void  S3043C1 ::v6(){vfunc_called(this, "_ZN7S3043C12v6Ev");}
void  S3043C1 ::v7(){vfunc_called(this, "_ZN7S3043C12v7Ev");}
void  S3043C1 ::v8(){vfunc_called(this, "_ZN7S3043C12v8Ev");}
void  S3043C1 ::v9(){vfunc_called(this, "_ZN7S3043C12v9Ev");}
void  S3043C1 ::v10(){vfunc_called(this, "_ZN7S3043C13v10Ev");}
void  S3043C1 ::v11(){vfunc_called(this, "_ZN7S3043C13v11Ev");}
void  S3043C1 ::v12(){vfunc_called(this, "_ZN7S3043C13v12Ev");}
void  S3043C1 ::v13(){vfunc_called(this, "_ZN7S3043C13v13Ev");}
void  S3043C1 ::v14(){vfunc_called(this, "_ZN7S3043C13v14Ev");}
void  S3043C1 ::v15(){vfunc_called(this, "_ZN7S3043C13v15Ev");}
void  S3043C1 ::v16(){vfunc_called(this, "_ZN7S3043C13v16Ev");}
S3043C1 ::S3043C1(){ note_ctor("S3043C1", this);} // tgen

static void Test_S3043C1()
{
  extern Class_Descriptor cd_S3043C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,30)];
    init_test(&cd_S3043C1, buf);
    S3043C1 *dp, &lv = *(dp=new (buf) S3043C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,116), "sizeof(S3043C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3043C1)");
    check_base_class_offset(lv, (S3043C3*)(S3043C2*), 0, "S3043C1");
    check_base_class_offset(lv, (S3043C5*)(S3043C2*), ABISELECT(96,60), "S3043C1");
    check_base_class_offset(lv, (S3043C6*)(S3043C2*), ABISELECT(104,64), "S3043C1");
    check_base_class_offset(lv, (S3043C2*), 0, "S3043C1");
    check_field_offset(lv, s3043c1f0, ABISELECT(144,88), "S3043C1.s3043c1f0");
    check_field_offset(lv, s3043c1f1, ABISELECT(160,100), "S3043C1.s3043c1f1");
    check_field_offset(lv, s3043c1f2, ABISELECT(176,112), "S3043C1.s3043c1f2");
    test_class_info(&lv, &cd_S3043C1);
    dp->~S3043C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3043C1(Test_S3043C1, "S3043C1", ABISELECT(184,116));

#else // __cplusplus

extern void _ZN7S3043C1C1Ev();
extern void _ZN7S3043C1D1Ev();
Name_Map name_map_S3043C1[] = {
  NSPAIR(_ZN7S3043C1C1Ev),
  NSPAIR(_ZN7S3043C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3043C3;
extern VTBL_ENTRY _ZTI7S3043C3[];
extern  VTBL_ENTRY _ZTV7S3043C3[];
extern Class_Descriptor cd_S3043C5;
extern VTBL_ENTRY _ZTI7S3043C5[];
extern  VTBL_ENTRY _ZTV7S3043C5[];
extern Class_Descriptor cd_S3043C6;
extern VTBL_ENTRY _ZTI7S3043C6[];
extern  VTBL_ENTRY _ZTV7S3043C6[];
extern Class_Descriptor cd_S3043C2;
extern VTBL_ENTRY _ZTI7S3043C2[];
extern  VTBL_ENTRY _ZTV7S3043C2[];
static Base_Class bases_S3043C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3043C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3043C5,    ABISELECT(96,60), //bcp->offset
    108, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3043C6,    ABISELECT(104,64), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3043C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3043C1[];
extern void _ZN7S3043C1D1Ev();
extern void _ZN7S3043C1D0Ev();
extern void _ZN7S3043C33v17Ev();
extern void _ZN7S3043C33v18Ev();
extern void _ZN7S3043C33v19Ev();
extern void _ZN7S3043C33v20Ev();
extern void _ZN7S3043C33v21Ev();
extern void _ZN7S3043C33v22Ev();
extern void _ZN7S3043C33v23Ev();
extern void _ZN7S3043C33v24Ev();
extern void _ZN7S3043C33v25Ev();
extern void _ZN7S3043C33v26Ev();
extern void _ZN7S3043C33v27Ev();
extern void _ZN7S3043C33v28Ev();
extern void _ZN7S3043C33v29Ev();
extern void _ZN7S3043C33v30Ev();
extern void _ZN7S3043C33v31Ev();
extern void _ZN7S3043C33v32Ev();
extern void _ZN7S3043C33v33Ev();
extern void _ZN7S3043C33v34Ev();
extern void _ZN7S3043C33v35Ev();
extern void _ZN7S3043C33v36Ev();
extern void _ZN7S3043C33v37Ev();
extern void _ZN7S3043C33v38Ev();
extern void _ZN7S3043C33v39Ev();
extern void _ZN7S3043C33v40Ev();
extern void _ZN7S3043C33v41Ev();
extern void _ZN7S3043C33v42Ev();
extern void _ZN7S3043C33v43Ev();
extern void _ZN7S3043C33v44Ev();
extern void _ZN7S3043C33v45Ev();
extern void _ZN7S3043C33v46Ev();
extern void _ZN7S3043C33v47Ev();
extern void _ZN7S3043C33v48Ev();
extern void _ZN7S3043C33v49Ev();
extern void _ZN7S3043C33v50Ev();
extern void _ZN7S3043C33v51Ev();
extern void _ZN7S3043C33v52Ev();
extern void _ZN7S3043C33v53Ev();
extern void _ZN7S3043C33v54Ev();
extern void _ZN7S3043C33v55Ev();
extern void _ZN7S3043C33v56Ev();
extern void _ZN7S3043C33v57Ev();
extern void _ZN7S3043C33v58Ev();
extern void _ZN7S3043C33v59Ev();
extern void _ZN7S3043C33v60Ev();
extern void _ZN7S3043C33v61Ev();
extern void _ZN7S3043C33v62Ev();
extern void _ZN7S3043C33v63Ev();
extern void _ZN7S3043C33v64Ev();
extern void _ZN7S3043C33v65Ev();
extern void _ZN7S3043C33v66Ev();
extern void _ZN7S3043C33v67Ev();
extern void _ZN7S3043C33v68Ev();
extern void _ZN7S3043C33v69Ev();
extern void _ZN7S3043C33v70Ev();
extern void _ZN7S3043C33v71Ev();
extern void _ZN7S3043C33v72Ev();
extern void _ZN7S3043C33v73Ev();
extern void _ZN7S3043C33v74Ev();
extern void _ZN7S3043C33v75Ev();
extern void _ZN7S3043C33v76Ev();
extern void _ZN7S3043C33v77Ev();
extern void _ZN7S3043C33v78Ev();
extern void _ZN7S3043C33v79Ev();
extern void _ZN7S3043C33v80Ev();
extern void _ZN7S3043C24v106Ev();
extern void _ZN7S3043C24v107Ev();
extern void _ZN7S3043C24v108Ev();
extern void _ZN7S3043C24v109Ev();
extern void _ZN7S3043C24v110Ev();
extern void _ZN7S3043C24v111Ev();
extern void _ZN7S3043C24v112Ev();
extern void _ZN7S3043C24v113Ev();
extern void _ZN7S3043C24v114Ev();
extern void _ZN7S3043C24v115Ev();
extern void _ZN7S3043C24v116Ev();
extern void _ZN7S3043C24v117Ev();
extern void _ZN7S3043C24v118Ev();
extern void _ZN7S3043C24v119Ev();
extern void _ZN7S3043C24v120Ev();
extern void _ZN7S3043C24v121Ev();
extern void _ZN7S3043C24v122Ev();
extern void _ZN7S3043C24v123Ev();
extern void _ZN7S3043C24v124Ev();
extern void _ZN7S3043C24v125Ev();
extern void _ZN7S3043C24v126Ev();
extern void _ZN7S3043C24v127Ev();
extern void _ZN7S3043C24v128Ev();
extern void _ZN7S3043C24v129Ev();
extern void _ZN7S3043C12v1Ev();
extern void _ZN7S3043C12v2Ev();
extern void _ZN7S3043C12v3Ev();
extern void _ZN7S3043C12v4Ev();
extern void _ZN7S3043C12v5Ev();
extern void _ZN7S3043C12v6Ev();
extern void _ZN7S3043C12v7Ev();
extern void _ZN7S3043C12v8Ev();
extern void _ZN7S3043C12v9Ev();
extern void _ZN7S3043C13v10Ev();
extern void _ZN7S3043C13v11Ev();
extern void _ZN7S3043C13v12Ev();
extern void _ZN7S3043C13v13Ev();
extern void _ZN7S3043C13v14Ev();
extern void _ZN7S3043C13v15Ev();
extern void _ZN7S3043C13v16Ev();
extern void _ZN7S3043C53v81Ev();
extern void _ZN7S3043C53v82Ev();
extern void _ZN7S3043C53v83Ev();
extern void _ZN7S3043C53v84Ev();
extern void _ZN7S3043C53v85Ev();
extern void _ZN7S3043C53v86Ev();
extern void _ZN7S3043C53v87Ev();
extern void _ZN7S3043C53v88Ev();
extern void _ZN7S3043C53v89Ev();
extern void _ZN7S3043C53v90Ev();
extern void _ZN7S3043C53v91Ev();
extern void _ZN7S3043C53v92Ev();
extern void _ZN7S3043C53v93Ev();
extern void _ZN7S3043C53v94Ev();
extern void _ZN7S3043C53v95Ev();
extern void _ZN7S3043C53v96Ev();
extern void _ZN7S3043C63v97Ev();
extern void _ZN7S3043C63v98Ev();
extern void _ZN7S3043C63v99Ev();
extern void _ZN7S3043C64v100Ev();
extern void _ZN7S3043C64v101Ev();
extern void _ZN7S3043C64v102Ev();
extern void _ZN7S3043C64v103Ev();
extern void _ZN7S3043C64v104Ev();
extern void _ZN7S3043C64v105Ev();
static  VTBL_ENTRY vtc_S3043C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3043C1[0]),
  (VTBL_ENTRY)&_ZN7S3043C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3043C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v79Ev,
  (VTBL_ENTRY)&_ZN7S3043C33v80Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v106Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v107Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v108Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v109Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v110Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v111Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v112Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v113Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v114Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v115Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v116Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v117Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v118Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v119Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v120Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v121Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v122Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v123Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v124Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v125Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v126Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v127Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v128Ev,
  (VTBL_ENTRY)&_ZN7S3043C24v129Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3043C12v9Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v10Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v11Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v12Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v13Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v14Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v15Ev,
  (VTBL_ENTRY)&_ZN7S3043C13v16Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3043C1[0]),
  (VTBL_ENTRY)&_ZN7S3043C53v81Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v82Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v83Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v84Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v85Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v86Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v87Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v88Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v89Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v90Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v91Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v92Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v93Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v94Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v95Ev,
  (VTBL_ENTRY)&_ZN7S3043C53v96Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S3043C1[0]),
  (VTBL_ENTRY)&_ZN7S3043C63v97Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v98Ev,
  (VTBL_ENTRY)&_ZN7S3043C63v99Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v100Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v101Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v102Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v103Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v104Ev,
  (VTBL_ENTRY)&_ZN7S3043C64v105Ev,
};
extern VTBL_ENTRY _ZTI7S3043C1[];
extern  VTBL_ENTRY _ZTV7S3043C1[];
Class_Descriptor cd_S3043C1 = {  "S3043C1", // class name
  bases_S3043C1, 4,
  &(vtc_S3043C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,116), // object size
  NSPAIRA(_ZTI7S3043C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3043C1),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3038C3  {
  int s3038c3f0;
  __tsi64 s3038c3f1;
  void *s3038c3f2[4];
  int s3038c3f3[2];
  void *s3038c3f4;
  ::S79C8_nt s3038c3f5;
  void *s3038c3f6[2];
  virtual  ~S3038C3(); // _ZN7S3038C3D1Ev
  virtual void  v16(); // _ZN7S3038C33v16Ev
  virtual void  v17(); // _ZN7S3038C33v17Ev
  virtual void  v18(); // _ZN7S3038C33v18Ev
  virtual void  v19(); // _ZN7S3038C33v19Ev
  virtual void  v20(); // _ZN7S3038C33v20Ev
  virtual void  v21(); // _ZN7S3038C33v21Ev
  virtual void  v22(); // _ZN7S3038C33v22Ev
  virtual void  v23(); // _ZN7S3038C33v23Ev
  virtual void  v24(); // _ZN7S3038C33v24Ev
  virtual void  v25(); // _ZN7S3038C33v25Ev
  virtual void  v26(); // _ZN7S3038C33v26Ev
  virtual void  v27(); // _ZN7S3038C33v27Ev
  virtual void  v28(); // _ZN7S3038C33v28Ev
  virtual void  v29(); // _ZN7S3038C33v29Ev
  virtual void  v30(); // _ZN7S3038C33v30Ev
  virtual void  v31(); // _ZN7S3038C33v31Ev
  virtual void  v32(); // _ZN7S3038C33v32Ev
  virtual void  v33(); // _ZN7S3038C33v33Ev
  virtual void  v34(); // _ZN7S3038C33v34Ev
  virtual void  v35(); // _ZN7S3038C33v35Ev
  virtual void  v36(); // _ZN7S3038C33v36Ev
  virtual void  v37(); // _ZN7S3038C33v37Ev
  virtual void  v38(); // _ZN7S3038C33v38Ev
  virtual void  v39(); // _ZN7S3038C33v39Ev
  virtual void  v40(); // _ZN7S3038C33v40Ev
  virtual void  v41(); // _ZN7S3038C33v41Ev
  virtual void  v42(); // _ZN7S3038C33v42Ev
  virtual void  v43(); // _ZN7S3038C33v43Ev
  virtual void  v44(); // _ZN7S3038C33v44Ev
  virtual void  v45(); // _ZN7S3038C33v45Ev
  virtual void  v46(); // _ZN7S3038C33v46Ev
  virtual void  v47(); // _ZN7S3038C33v47Ev
  virtual void  v48(); // _ZN7S3038C33v48Ev
  virtual void  v49(); // _ZN7S3038C33v49Ev
  virtual void  v50(); // _ZN7S3038C33v50Ev
  virtual void  v51(); // _ZN7S3038C33v51Ev
  virtual void  v52(); // _ZN7S3038C33v52Ev
  virtual void  v53(); // _ZN7S3038C33v53Ev
  virtual void  v54(); // _ZN7S3038C33v54Ev
  virtual void  v55(); // _ZN7S3038C33v55Ev
  virtual void  v56(); // _ZN7S3038C33v56Ev
  virtual void  v57(); // _ZN7S3038C33v57Ev
  virtual void  v58(); // _ZN7S3038C33v58Ev
  virtual void  v59(); // _ZN7S3038C33v59Ev
  virtual void  v60(); // _ZN7S3038C33v60Ev
  virtual void  v61(); // _ZN7S3038C33v61Ev
  virtual void  v62(); // _ZN7S3038C33v62Ev
  virtual void  v63(); // _ZN7S3038C33v63Ev
  virtual void  v64(); // _ZN7S3038C33v64Ev
  virtual void  v65(); // _ZN7S3038C33v65Ev
  virtual void  v66(); // _ZN7S3038C33v66Ev
  virtual void  v67(); // _ZN7S3038C33v67Ev
  virtual void  v68(); // _ZN7S3038C33v68Ev
  virtual void  v69(); // _ZN7S3038C33v69Ev
  virtual void  v70(); // _ZN7S3038C33v70Ev
  virtual void  v71(); // _ZN7S3038C33v71Ev
  virtual void  v72(); // _ZN7S3038C33v72Ev
  virtual void  v73(); // _ZN7S3038C33v73Ev
  virtual void  v74(); // _ZN7S3038C33v74Ev
  virtual void  v75(); // _ZN7S3038C33v75Ev
  virtual void  v76(); // _ZN7S3038C33v76Ev
  virtual void  v77(); // _ZN7S3038C33v77Ev
  virtual void  v78(); // _ZN7S3038C33v78Ev
  virtual void  v79(); // _ZN7S3038C33v79Ev
  S3038C3(); // tgen
};
//SIG(-1 S3038C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3038C3 ::~S3038C3(){ note_dtor("S3038C3", this);}
void  S3038C3 ::v16(){vfunc_called(this, "_ZN7S3038C33v16Ev");}
void  S3038C3 ::v17(){vfunc_called(this, "_ZN7S3038C33v17Ev");}
void  S3038C3 ::v18(){vfunc_called(this, "_ZN7S3038C33v18Ev");}
void  S3038C3 ::v19(){vfunc_called(this, "_ZN7S3038C33v19Ev");}
void  S3038C3 ::v20(){vfunc_called(this, "_ZN7S3038C33v20Ev");}
void  S3038C3 ::v21(){vfunc_called(this, "_ZN7S3038C33v21Ev");}
void  S3038C3 ::v22(){vfunc_called(this, "_ZN7S3038C33v22Ev");}
void  S3038C3 ::v23(){vfunc_called(this, "_ZN7S3038C33v23Ev");}
void  S3038C3 ::v24(){vfunc_called(this, "_ZN7S3038C33v24Ev");}
void  S3038C3 ::v25(){vfunc_called(this, "_ZN7S3038C33v25Ev");}
void  S3038C3 ::v26(){vfunc_called(this, "_ZN7S3038C33v26Ev");}
void  S3038C3 ::v27(){vfunc_called(this, "_ZN7S3038C33v27Ev");}
void  S3038C3 ::v28(){vfunc_called(this, "_ZN7S3038C33v28Ev");}
void  S3038C3 ::v29(){vfunc_called(this, "_ZN7S3038C33v29Ev");}
void  S3038C3 ::v30(){vfunc_called(this, "_ZN7S3038C33v30Ev");}
void  S3038C3 ::v31(){vfunc_called(this, "_ZN7S3038C33v31Ev");}
void  S3038C3 ::v32(){vfunc_called(this, "_ZN7S3038C33v32Ev");}
void  S3038C3 ::v33(){vfunc_called(this, "_ZN7S3038C33v33Ev");}
void  S3038C3 ::v34(){vfunc_called(this, "_ZN7S3038C33v34Ev");}
void  S3038C3 ::v35(){vfunc_called(this, "_ZN7S3038C33v35Ev");}
void  S3038C3 ::v36(){vfunc_called(this, "_ZN7S3038C33v36Ev");}
void  S3038C3 ::v37(){vfunc_called(this, "_ZN7S3038C33v37Ev");}
void  S3038C3 ::v38(){vfunc_called(this, "_ZN7S3038C33v38Ev");}
void  S3038C3 ::v39(){vfunc_called(this, "_ZN7S3038C33v39Ev");}
void  S3038C3 ::v40(){vfunc_called(this, "_ZN7S3038C33v40Ev");}
void  S3038C3 ::v41(){vfunc_called(this, "_ZN7S3038C33v41Ev");}
void  S3038C3 ::v42(){vfunc_called(this, "_ZN7S3038C33v42Ev");}
void  S3038C3 ::v43(){vfunc_called(this, "_ZN7S3038C33v43Ev");}
void  S3038C3 ::v44(){vfunc_called(this, "_ZN7S3038C33v44Ev");}
void  S3038C3 ::v45(){vfunc_called(this, "_ZN7S3038C33v45Ev");}
void  S3038C3 ::v46(){vfunc_called(this, "_ZN7S3038C33v46Ev");}
void  S3038C3 ::v47(){vfunc_called(this, "_ZN7S3038C33v47Ev");}
void  S3038C3 ::v48(){vfunc_called(this, "_ZN7S3038C33v48Ev");}
void  S3038C3 ::v49(){vfunc_called(this, "_ZN7S3038C33v49Ev");}
void  S3038C3 ::v50(){vfunc_called(this, "_ZN7S3038C33v50Ev");}
void  S3038C3 ::v51(){vfunc_called(this, "_ZN7S3038C33v51Ev");}
void  S3038C3 ::v52(){vfunc_called(this, "_ZN7S3038C33v52Ev");}
void  S3038C3 ::v53(){vfunc_called(this, "_ZN7S3038C33v53Ev");}
void  S3038C3 ::v54(){vfunc_called(this, "_ZN7S3038C33v54Ev");}
void  S3038C3 ::v55(){vfunc_called(this, "_ZN7S3038C33v55Ev");}
void  S3038C3 ::v56(){vfunc_called(this, "_ZN7S3038C33v56Ev");}
void  S3038C3 ::v57(){vfunc_called(this, "_ZN7S3038C33v57Ev");}
void  S3038C3 ::v58(){vfunc_called(this, "_ZN7S3038C33v58Ev");}
void  S3038C3 ::v59(){vfunc_called(this, "_ZN7S3038C33v59Ev");}
void  S3038C3 ::v60(){vfunc_called(this, "_ZN7S3038C33v60Ev");}
void  S3038C3 ::v61(){vfunc_called(this, "_ZN7S3038C33v61Ev");}
void  S3038C3 ::v62(){vfunc_called(this, "_ZN7S3038C33v62Ev");}
void  S3038C3 ::v63(){vfunc_called(this, "_ZN7S3038C33v63Ev");}
void  S3038C3 ::v64(){vfunc_called(this, "_ZN7S3038C33v64Ev");}
void  S3038C3 ::v65(){vfunc_called(this, "_ZN7S3038C33v65Ev");}
void  S3038C3 ::v66(){vfunc_called(this, "_ZN7S3038C33v66Ev");}
void  S3038C3 ::v67(){vfunc_called(this, "_ZN7S3038C33v67Ev");}
void  S3038C3 ::v68(){vfunc_called(this, "_ZN7S3038C33v68Ev");}
void  S3038C3 ::v69(){vfunc_called(this, "_ZN7S3038C33v69Ev");}
void  S3038C3 ::v70(){vfunc_called(this, "_ZN7S3038C33v70Ev");}
void  S3038C3 ::v71(){vfunc_called(this, "_ZN7S3038C33v71Ev");}
void  S3038C3 ::v72(){vfunc_called(this, "_ZN7S3038C33v72Ev");}
void  S3038C3 ::v73(){vfunc_called(this, "_ZN7S3038C33v73Ev");}
void  S3038C3 ::v74(){vfunc_called(this, "_ZN7S3038C33v74Ev");}
void  S3038C3 ::v75(){vfunc_called(this, "_ZN7S3038C33v75Ev");}
void  S3038C3 ::v76(){vfunc_called(this, "_ZN7S3038C33v76Ev");}
void  S3038C3 ::v77(){vfunc_called(this, "_ZN7S3038C33v77Ev");}
void  S3038C3 ::v78(){vfunc_called(this, "_ZN7S3038C33v78Ev");}
void  S3038C3 ::v79(){vfunc_called(this, "_ZN7S3038C33v79Ev");}
S3038C3 ::S3038C3(){ note_ctor("S3038C3", this);} // tgen

static void Test_S3038C3()
{
  extern Class_Descriptor cd_S3038C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3038C3, buf);
    S3038C3 *dp, &lv = *(dp=new (buf) S3038C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3038C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3038C3)");
    check_field_offset(lv, s3038c3f0, ABISELECT(8,4), "S3038C3.s3038c3f0");
    check_field_offset(lv, s3038c3f1, ABISELECT(16,8), "S3038C3.s3038c3f1");
    check_field_offset(lv, s3038c3f2, ABISELECT(24,16), "S3038C3.s3038c3f2");
    check_field_offset(lv, s3038c3f3, ABISELECT(56,32), "S3038C3.s3038c3f3");
    check_field_offset(lv, s3038c3f4, ABISELECT(64,40), "S3038C3.s3038c3f4");
    check_field_offset(lv, s3038c3f5, ABISELECT(72,44), "S3038C3.s3038c3f5");
    check_field_offset(lv, s3038c3f6, ABISELECT(80,52), "S3038C3.s3038c3f6");
    test_class_info(&lv, &cd_S3038C3);
    dp->~S3038C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3038C3(Test_S3038C3, "S3038C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3038C3C1Ev();
extern void _ZN7S3038C3D1Ev();
Name_Map name_map_S3038C3[] = {
  NSPAIR(_ZN7S3038C3C1Ev),
  NSPAIR(_ZN7S3038C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3038C3[];
extern void _ZN7S3038C3D1Ev();
extern void _ZN7S3038C3D0Ev();
extern void _ZN7S3038C33v16Ev();
extern void _ZN7S3038C33v17Ev();
extern void _ZN7S3038C33v18Ev();
extern void _ZN7S3038C33v19Ev();
extern void _ZN7S3038C33v20Ev();
extern void _ZN7S3038C33v21Ev();
extern void _ZN7S3038C33v22Ev();
extern void _ZN7S3038C33v23Ev();
extern void _ZN7S3038C33v24Ev();
extern void _ZN7S3038C33v25Ev();
extern void _ZN7S3038C33v26Ev();
extern void _ZN7S3038C33v27Ev();
extern void _ZN7S3038C33v28Ev();
extern void _ZN7S3038C33v29Ev();
extern void _ZN7S3038C33v30Ev();
extern void _ZN7S3038C33v31Ev();
extern void _ZN7S3038C33v32Ev();
extern void _ZN7S3038C33v33Ev();
extern void _ZN7S3038C33v34Ev();
extern void _ZN7S3038C33v35Ev();
extern void _ZN7S3038C33v36Ev();
extern void _ZN7S3038C33v37Ev();
extern void _ZN7S3038C33v38Ev();
extern void _ZN7S3038C33v39Ev();
extern void _ZN7S3038C33v40Ev();
extern void _ZN7S3038C33v41Ev();
extern void _ZN7S3038C33v42Ev();
extern void _ZN7S3038C33v43Ev();
extern void _ZN7S3038C33v44Ev();
extern void _ZN7S3038C33v45Ev();
extern void _ZN7S3038C33v46Ev();
extern void _ZN7S3038C33v47Ev();
extern void _ZN7S3038C33v48Ev();
extern void _ZN7S3038C33v49Ev();
extern void _ZN7S3038C33v50Ev();
extern void _ZN7S3038C33v51Ev();
extern void _ZN7S3038C33v52Ev();
extern void _ZN7S3038C33v53Ev();
extern void _ZN7S3038C33v54Ev();
extern void _ZN7S3038C33v55Ev();
extern void _ZN7S3038C33v56Ev();
extern void _ZN7S3038C33v57Ev();
extern void _ZN7S3038C33v58Ev();
extern void _ZN7S3038C33v59Ev();
extern void _ZN7S3038C33v60Ev();
extern void _ZN7S3038C33v61Ev();
extern void _ZN7S3038C33v62Ev();
extern void _ZN7S3038C33v63Ev();
extern void _ZN7S3038C33v64Ev();
extern void _ZN7S3038C33v65Ev();
extern void _ZN7S3038C33v66Ev();
extern void _ZN7S3038C33v67Ev();
extern void _ZN7S3038C33v68Ev();
extern void _ZN7S3038C33v69Ev();
extern void _ZN7S3038C33v70Ev();
extern void _ZN7S3038C33v71Ev();
extern void _ZN7S3038C33v72Ev();
extern void _ZN7S3038C33v73Ev();
extern void _ZN7S3038C33v74Ev();
extern void _ZN7S3038C33v75Ev();
extern void _ZN7S3038C33v76Ev();
extern void _ZN7S3038C33v77Ev();
extern void _ZN7S3038C33v78Ev();
extern void _ZN7S3038C33v79Ev();
static  VTBL_ENTRY vtc_S3038C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3038C3[0]),
  (VTBL_ENTRY)&_ZN7S3038C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3038C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v74Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v75Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v76Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v77Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v78Ev,
  (VTBL_ENTRY)&_ZN7S3038C33v79Ev,
};
extern VTBL_ENTRY _ZTI7S3038C3[];
extern  VTBL_ENTRY _ZTV7S3038C3[];
Class_Descriptor cd_S3038C3 = {  "S3038C3", // class name
  0,0,//no base classes
  &(vtc_S3038C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3038C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3038C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3038C5  {
  virtual void  v80(); // _ZN7S3038C53v80Ev
  virtual void  v81(); // _ZN7S3038C53v81Ev
  virtual void  v82(); // _ZN7S3038C53v82Ev
  virtual void  v83(); // _ZN7S3038C53v83Ev
  virtual void  v84(); // _ZN7S3038C53v84Ev
  virtual void  v85(); // _ZN7S3038C53v85Ev
  virtual void  v86(); // _ZN7S3038C53v86Ev
  virtual void  v87(); // _ZN7S3038C53v87Ev
  virtual void  v88(); // _ZN7S3038C53v88Ev
  virtual void  v89(); // _ZN7S3038C53v89Ev
  virtual void  v90(); // _ZN7S3038C53v90Ev
  virtual void  v91(); // _ZN7S3038C53v91Ev
  virtual void  v92(); // _ZN7S3038C53v92Ev
  virtual void  v93(); // _ZN7S3038C53v93Ev
  virtual void  v94(); // _ZN7S3038C53v94Ev
  virtual void  v95(); // _ZN7S3038C53v95Ev
  ~S3038C5(); // tgen
  S3038C5(); // tgen
};
//SIG(-1 S3038C5) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16}


void  S3038C5 ::v80(){vfunc_called(this, "_ZN7S3038C53v80Ev");}
void  S3038C5 ::v81(){vfunc_called(this, "_ZN7S3038C53v81Ev");}
void  S3038C5 ::v82(){vfunc_called(this, "_ZN7S3038C53v82Ev");}
void  S3038C5 ::v83(){vfunc_called(this, "_ZN7S3038C53v83Ev");}
void  S3038C5 ::v84(){vfunc_called(this, "_ZN7S3038C53v84Ev");}
void  S3038C5 ::v85(){vfunc_called(this, "_ZN7S3038C53v85Ev");}
void  S3038C5 ::v86(){vfunc_called(this, "_ZN7S3038C53v86Ev");}
void  S3038C5 ::v87(){vfunc_called(this, "_ZN7S3038C53v87Ev");}
void  S3038C5 ::v88(){vfunc_called(this, "_ZN7S3038C53v88Ev");}
void  S3038C5 ::v89(){vfunc_called(this, "_ZN7S3038C53v89Ev");}
void  S3038C5 ::v90(){vfunc_called(this, "_ZN7S3038C53v90Ev");}
void  S3038C5 ::v91(){vfunc_called(this, "_ZN7S3038C53v91Ev");}
void  S3038C5 ::v92(){vfunc_called(this, "_ZN7S3038C53v92Ev");}
void  S3038C5 ::v93(){vfunc_called(this, "_ZN7S3038C53v93Ev");}
void  S3038C5 ::v94(){vfunc_called(this, "_ZN7S3038C53v94Ev");}
void  S3038C5 ::v95(){vfunc_called(this, "_ZN7S3038C53v95Ev");}
S3038C5 ::~S3038C5(){ note_dtor("S3038C5", this);} // tgen
S3038C5 ::S3038C5(){ note_ctor("S3038C5", this);} // tgen

static void Test_S3038C5()
{
  extern Class_Descriptor cd_S3038C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3038C5, buf);
    S3038C5 *dp, &lv = *(dp=new (buf) S3038C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3038C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3038C5)");
    test_class_info(&lv, &cd_S3038C5);
    dp->~S3038C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3038C5(Test_S3038C5, "S3038C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3038C5C1Ev();
extern void _ZN7S3038C5D1Ev();
Name_Map name_map_S3038C5[] = {
  NSPAIR(_ZN7S3038C5C1Ev),
  NSPAIR(_ZN7S3038C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3038C5[];
extern void _ZN7S3038C53v80Ev();
extern void _ZN7S3038C53v81Ev();
extern void _ZN7S3038C53v82Ev();
extern void _ZN7S3038C53v83Ev();
extern void _ZN7S3038C53v84Ev();
extern void _ZN7S3038C53v85Ev();
extern void _ZN7S3038C53v86Ev();
extern void _ZN7S3038C53v87Ev();
extern void _ZN7S3038C53v88Ev();
extern void _ZN7S3038C53v89Ev();
extern void _ZN7S3038C53v90Ev();
extern void _ZN7S3038C53v91Ev();
extern void _ZN7S3038C53v92Ev();
extern void _ZN7S3038C53v93Ev();
extern void _ZN7S3038C53v94Ev();
extern void _ZN7S3038C53v95Ev();
static  VTBL_ENTRY vtc_S3038C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3038C5[0]),
  (VTBL_ENTRY)&_ZN7S3038C53v80Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v81Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v82Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v83Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v84Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v85Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v86Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v87Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v88Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v89Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v90Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v91Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v92Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v93Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v94Ev,
  (VTBL_ENTRY)&_ZN7S3038C53v95Ev,
};
extern VTBL_ENTRY _ZTI7S3038C5[];
extern  VTBL_ENTRY _ZTV7S3038C5[];
Class_Descriptor cd_S3038C5 = {  "S3038C5", // class name
  0,0,//no base classes
  &(vtc_S3038C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3038C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3038C5),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3038C6  {
  virtual void  v96(); // _ZN7S3038C63v96Ev
  virtual void  v97(); // _ZN7S3038C63v97Ev
  virtual void  v98(); // _ZN7S3038C63v98Ev
  virtual void  v99(); // _ZN7S3038C63v99Ev
  virtual void  v100(); // _ZN7S3038C64v100Ev
  virtual void  v101(); // _ZN7S3038C64v101Ev
  virtual void  v102(); // _ZN7S3038C64v102Ev
  virtual void  v103(); // _ZN7S3038C64v103Ev
  virtual void  v104(); // _ZN7S3038C64v104Ev
  ~S3038C6(); // tgen
  S3038C6(); // tgen
};
//SIG(-1 S3038C6) C1{ v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S3038C6 ::v96(){vfunc_called(this, "_ZN7S3038C63v96Ev");}
void  S3038C6 ::v97(){vfunc_called(this, "_ZN7S3038C63v97Ev");}
void  S3038C6 ::v98(){vfunc_called(this, "_ZN7S3038C63v98Ev");}
void  S3038C6 ::v99(){vfunc_called(this, "_ZN7S3038C63v99Ev");}
void  S3038C6 ::v100(){vfunc_called(this, "_ZN7S3038C64v100Ev");}
void  S3038C6 ::v101(){vfunc_called(this, "_ZN7S3038C64v101Ev");}
void  S3038C6 ::v102(){vfunc_called(this, "_ZN7S3038C64v102Ev");}
void  S3038C6 ::v103(){vfunc_called(this, "_ZN7S3038C64v103Ev");}
void  S3038C6 ::v104(){vfunc_called(this, "_ZN7S3038C64v104Ev");}
S3038C6 ::~S3038C6(){ note_dtor("S3038C6", this);} // tgen
S3038C6 ::S3038C6(){ note_ctor("S3038C6", this);} // tgen

static void Test_S3038C6()
{
  extern Class_Descriptor cd_S3038C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3038C6, buf);
    S3038C6 *dp, &lv = *(dp=new (buf) S3038C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3038C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3038C6)");
    test_class_info(&lv, &cd_S3038C6);
    dp->~S3038C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3038C6(Test_S3038C6, "S3038C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3038C6C1Ev();
extern void _ZN7S3038C6D1Ev();
Name_Map name_map_S3038C6[] = {
  NSPAIR(_ZN7S3038C6C1Ev),
  NSPAIR(_ZN7S3038C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3038C6[];
extern void _ZN7S3038C63v96Ev();
extern void _ZN7S3038C63v97Ev();
extern void _ZN7S3038C63v98Ev();
extern void _ZN7S3038C63v99Ev();
extern void _ZN7S3038C64v100Ev();
extern void _ZN7S3038C64v101Ev();
extern void _ZN7S3038C64v102Ev();
extern void _ZN7S3038C64v103Ev();
extern void _ZN7S3038C64v104Ev();
static  VTBL_ENTRY vtc_S3038C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3038C6[0]),
  (VTBL_ENTRY)&_ZN7S3038C63v96Ev,
  (VTBL_ENTRY)&_ZN7S3038C63v97Ev,
  (VTBL_ENTRY)&_ZN7S3038C63v98Ev,
  (VTBL_ENTRY)&_ZN7S3038C63v99Ev,
  (VTBL_ENTRY)&_ZN7S3038C64v100Ev,
  (VTBL_ENTRY)&_ZN7S3038C64v101Ev,
  (VTBL_ENTRY)&_ZN7S3038C64v102Ev,
  (VTBL_ENTRY)&_ZN7S3038C64v103Ev,
  (VTBL_ENTRY)&_ZN7S3038C64v104Ev,
};
extern VTBL_ENTRY _ZTI7S3038C6[];
extern  VTBL_ENTRY _ZTV7S3038C6[];
Class_Descriptor cd_S3038C6 = {  "S3038C6", // class name
  0,0,//no base classes
  &(vtc_S3038C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3038C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3038C6),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3038C2  : S3038C3 , S3038C5 , S3038C6 {
  void *s3038c2f0;
  ::S79C39_nt s3038c2f1;
  unsigned int s3038c2f2:1;
  unsigned int s3038c2f3:1;
  unsigned int s3038c2f4:1;
  unsigned int s3038c2f5:1;
  virtual  ~S3038C2(); // _ZN7S3038C2D1Ev
  virtual void  v105(); // _ZN7S3038C24v105Ev
  virtual void  v106(); // _ZN7S3038C24v106Ev
  virtual void  v107(); // _ZN7S3038C24v107Ev
  virtual void  v108(); // _ZN7S3038C24v108Ev
  virtual void  v109(); // _ZN7S3038C24v109Ev
  virtual void  v110(); // _ZN7S3038C24v110Ev
  virtual void  v111(); // _ZN7S3038C24v111Ev
  virtual void  v112(); // _ZN7S3038C24v112Ev
  virtual void  v113(); // _ZN7S3038C24v113Ev
  virtual void  v114(); // _ZN7S3038C24v114Ev
  virtual void  v115(); // _ZN7S3038C24v115Ev
  virtual void  v116(); // _ZN7S3038C24v116Ev
  virtual void  v117(); // _ZN7S3038C24v117Ev
  virtual void  v118(); // _ZN7S3038C24v118Ev
  virtual void  v119(); // _ZN7S3038C24v119Ev
  virtual void  v120(); // _ZN7S3038C24v120Ev
  virtual void  v121(); // _ZN7S3038C24v121Ev
  virtual void  v122(); // _ZN7S3038C24v122Ev
  virtual void  v123(); // _ZN7S3038C24v123Ev
  virtual void  v124(); // _ZN7S3038C24v124Ev
  virtual void  v125(); // _ZN7S3038C24v125Ev
  virtual void  v126(); // _ZN7S3038C24v126Ev
  virtual void  v127(); // _ZN7S3038C24v127Ev
  virtual void  v128(); // _ZN7S3038C24v128Ev
  S3038C2(); // tgen
};
//SIG(-1 S3038C2) C1{ BC2{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} BC5{ v105 v106 v107 v108 v109 v110 v111 v112 v113} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fi:1 Fi:1 Fi:1 Fi:1}


 S3038C2 ::~S3038C2(){ note_dtor("S3038C2", this);}
void  S3038C2 ::v105(){vfunc_called(this, "_ZN7S3038C24v105Ev");}
void  S3038C2 ::v106(){vfunc_called(this, "_ZN7S3038C24v106Ev");}
void  S3038C2 ::v107(){vfunc_called(this, "_ZN7S3038C24v107Ev");}
void  S3038C2 ::v108(){vfunc_called(this, "_ZN7S3038C24v108Ev");}
void  S3038C2 ::v109(){vfunc_called(this, "_ZN7S3038C24v109Ev");}
void  S3038C2 ::v110(){vfunc_called(this, "_ZN7S3038C24v110Ev");}
void  S3038C2 ::v111(){vfunc_called(this, "_ZN7S3038C24v111Ev");}
void  S3038C2 ::v112(){vfunc_called(this, "_ZN7S3038C24v112Ev");}
void  S3038C2 ::v113(){vfunc_called(this, "_ZN7S3038C24v113Ev");}
void  S3038C2 ::v114(){vfunc_called(this, "_ZN7S3038C24v114Ev");}
void  S3038C2 ::v115(){vfunc_called(this, "_ZN7S3038C24v115Ev");}
void  S3038C2 ::v116(){vfunc_called(this, "_ZN7S3038C24v116Ev");}
void  S3038C2 ::v117(){vfunc_called(this, "_ZN7S3038C24v117Ev");}
void  S3038C2 ::v118(){vfunc_called(this, "_ZN7S3038C24v118Ev");}
void  S3038C2 ::v119(){vfunc_called(this, "_ZN7S3038C24v119Ev");}
void  S3038C2 ::v120(){vfunc_called(this, "_ZN7S3038C24v120Ev");}
void  S3038C2 ::v121(){vfunc_called(this, "_ZN7S3038C24v121Ev");}
void  S3038C2 ::v122(){vfunc_called(this, "_ZN7S3038C24v122Ev");}
void  S3038C2 ::v123(){vfunc_called(this, "_ZN7S3038C24v123Ev");}
void  S3038C2 ::v124(){vfunc_called(this, "_ZN7S3038C24v124Ev");}
void  S3038C2 ::v125(){vfunc_called(this, "_ZN7S3038C24v125Ev");}
void  S3038C2 ::v126(){vfunc_called(this, "_ZN7S3038C24v126Ev");}
void  S3038C2 ::v127(){vfunc_called(this, "_ZN7S3038C24v127Ev");}
void  S3038C2 ::v128(){vfunc_called(this, "_ZN7S3038C24v128Ev");}
S3038C2 ::S3038C2(){ note_ctor("S3038C2", this);} // tgen

static void Test_S3038C2()
{
  extern Class_Descriptor cd_S3038C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,23)];
    init_test(&cd_S3038C2, buf);
    S3038C2 *dp, &lv = *(dp=new (buf) S3038C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,88), "sizeof(S3038C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3038C2)");
    check_base_class_offset(lv, (S3038C3*), 0, "S3038C2");
    check_base_class_offset(lv, (S3038C5*), ABISELECT(96,60), "S3038C2");
    check_base_class_offset(lv, (S3038C6*), ABISELECT(104,64), "S3038C2");
    check_field_offset(lv, s3038c2f0, ABISELECT(112,68), "S3038C2.s3038c2f0");
    check_field_offset(lv, s3038c2f1, ABISELECT(120,72), "S3038C2.s3038c2f1");
    set_bf_and_test(lv, s3038c2f2, ABISELECT(136,84), 0, 1, 1, "S3038C2");
    set_bf_and_test(lv, s3038c2f3, ABISELECT(136,84), 1, 1, 1, "S3038C2");
    set_bf_and_test(lv, s3038c2f4, ABISELECT(136,84), 2, 1, 1, "S3038C2");
    set_bf_and_test(lv, s3038c2f5, ABISELECT(136,84), 3, 1, 1, "S3038C2");
    test_class_info(&lv, &cd_S3038C2);
    dp->~S3038C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3038C2(Test_S3038C2, "S3038C2", ABISELECT(144,88));

#else // __cplusplus

extern void _ZN7S3038C2C1Ev();
extern void _ZN7S3038C2D1Ev();
Name_Map name_map_S3038C2[] = {
  NSPAIR(_ZN7S3038C2C1Ev),
  NSPAIR(_ZN7S3038C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3038C3;
extern VTBL_ENTRY _ZTI7S3038C3[];
extern  VTBL_ENTRY _ZTV7S3038C3[];
extern Class_Descriptor cd_S3038C5;
extern VTBL_ENTRY _ZTI7S3038C5[];
extern  VTBL_ENTRY _ZTV7S3038C5[];
extern Class_Descriptor cd_S3038C6;
extern VTBL_ENTRY _ZTI7S3038C6[];
extern  VTBL_ENTRY _ZTV7S3038C6[];
static Base_Class bases_S3038C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3038C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3038C5,    ABISELECT(96,60), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3038C6,    ABISELECT(104,64), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3038C2[];
extern void _ZN7S3038C2D1Ev();
extern void _ZN7S3038C2D0Ev();
extern v