// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S708C6_nt  {
  int s708c6f0[2];
  void  mf708c6(); // _ZN9S708C6_nt7mf708c6Ev
};
//SIG(-1 S708C6_nt) C1{ m Fi[2]}


void  S708C6_nt ::mf708c6(){}

//skip512 S708C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C5_nt  {
  int s708c5f0;
  __tsi64 s708c5f1;
  void *s708c5f2[4];
  int s708c5f3[2];
  void *s708c5f4;
  ::S708C6_nt s708c5f5;
  void *s708c5f6[2];
  virtual  ~S708C5_nt(); // _ZN9S708C5_ntD1Ev
  virtual void  v9(); // _ZN9S708C5_nt2v9Ev
  virtual void  v10(); // _ZN9S708C5_nt3v10Ev
  virtual void  v11(); // _ZN9S708C5_nt3v11Ev
  virtual void  v12(); // _ZN9S708C5_nt3v12Ev
  virtual void  v13(); // _ZN9S708C5_nt3v13Ev
  virtual void  v14(); // _ZN9S708C5_nt3v14Ev
  virtual void  v15(); // _ZN9S708C5_nt3v15Ev
  virtual void  v16(); // _ZN9S708C5_nt3v16Ev
  virtual void  v17(); // _ZN9S708C5_nt3v17Ev
  virtual void  v18(); // _ZN9S708C5_nt3v18Ev
  virtual void  v19(); // _ZN9S708C5_nt3v19Ev
  virtual void  v20(); // _ZN9S708C5_nt3v20Ev
  virtual void  v21(); // _ZN9S708C5_nt3v21Ev
  virtual void  v22(); // _ZN9S708C5_nt3v22Ev
  virtual void  v23(); // _ZN9S708C5_nt3v23Ev
  virtual void  v24(); // _ZN9S708C5_nt3v24Ev
  virtual void  v25(); // _ZN9S708C5_nt3v25Ev
  virtual void  v26(); // _ZN9S708C5_nt3v26Ev
  virtual void  v27(); // _ZN9S708C5_nt3v27Ev
  virtual void  v28(); // _ZN9S708C5_nt3v28Ev
  virtual void  v29(); // _ZN9S708C5_nt3v29Ev
  virtual void  v30(); // _ZN9S708C5_nt3v30Ev
  virtual void  v31(); // _ZN9S708C5_nt3v31Ev
  virtual void  v32(); // _ZN9S708C5_nt3v32Ev
  virtual void  v33(); // _ZN9S708C5_nt3v33Ev
  virtual void  v34(); // _ZN9S708C5_nt3v34Ev
  virtual void  v35(); // _ZN9S708C5_nt3v35Ev
  virtual void  v36(); // _ZN9S708C5_nt3v36Ev
  virtual void  v37(); // _ZN9S708C5_nt3v37Ev
  virtual void  v38(); // _ZN9S708C5_nt3v38Ev
  virtual void  v39(); // _ZN9S708C5_nt3v39Ev
  virtual void  v40(); // _ZN9S708C5_nt3v40Ev
  virtual void  v41(); // _ZN9S708C5_nt3v41Ev
  virtual void  v42(); // _ZN9S708C5_nt3v42Ev
  virtual void  v43(); // _ZN9S708C5_nt3v43Ev
  virtual void  v44(); // _ZN9S708C5_nt3v44Ev
  virtual void  v45(); // _ZN9S708C5_nt3v45Ev
  virtual void  v46(); // _ZN9S708C5_nt3v46Ev
  virtual void  v47(); // _ZN9S708C5_nt3v47Ev
  virtual void  v48(); // _ZN9S708C5_nt3v48Ev
  virtual void  v49(); // _ZN9S708C5_nt3v49Ev
  virtual void  v50(); // _ZN9S708C5_nt3v50Ev
  virtual void  v51(); // _ZN9S708C5_nt3v51Ev
  virtual void  v52(); // _ZN9S708C5_nt3v52Ev
  virtual void  v53(); // _ZN9S708C5_nt3v53Ev
  virtual void  v54(); // _ZN9S708C5_nt3v54Ev
  virtual void  v55(); // _ZN9S708C5_nt3v55Ev
  virtual void  v56(); // _ZN9S708C5_nt3v56Ev
  virtual void  v57(); // _ZN9S708C5_nt3v57Ev
  virtual void  v58(); // _ZN9S708C5_nt3v58Ev
  virtual void  v59(); // _ZN9S708C5_nt3v59Ev
  virtual void  v60(); // _ZN9S708C5_nt3v60Ev
  virtual void  v61(); // _ZN9S708C5_nt3v61Ev
  virtual void  v62(); // _ZN9S708C5_nt3v62Ev
  virtual void  v63(); // _ZN9S708C5_nt3v63Ev
  virtual void  v64(); // _ZN9S708C5_nt3v64Ev
  virtual void  v65(); // _ZN9S708C5_nt3v65Ev
  virtual void  v66(); // _ZN9S708C5_nt3v66Ev
  virtual void  v67(); // _ZN9S708C5_nt3v67Ev
  virtual void  v68(); // _ZN9S708C5_nt3v68Ev
  virtual void  v69(); // _ZN9S708C5_nt3v69Ev
  virtual void  v70(); // _ZN9S708C5_nt3v70Ev
  virtual void  v71(); // _ZN9S708C5_nt3v71Ev
  virtual void  v72(); // _ZN9S708C5_nt3v72Ev
  S708C5_nt(); // tgen
};
//SIG(-1 S708C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S708C5_nt ::~S708C5_nt(){ note_dtor("S708C5_nt", this);}
void  S708C5_nt ::v9(){vfunc_called(this, "_ZN9S708C5_nt2v9Ev");}
void  S708C5_nt ::v10(){vfunc_called(this, "_ZN9S708C5_nt3v10Ev");}
void  S708C5_nt ::v11(){vfunc_called(this, "_ZN9S708C5_nt3v11Ev");}
void  S708C5_nt ::v12(){vfunc_called(this, "_ZN9S708C5_nt3v12Ev");}
void  S708C5_nt ::v13(){vfunc_called(this, "_ZN9S708C5_nt3v13Ev");}
void  S708C5_nt ::v14(){vfunc_called(this, "_ZN9S708C5_nt3v14Ev");}
void  S708C5_nt ::v15(){vfunc_called(this, "_ZN9S708C5_nt3v15Ev");}
void  S708C5_nt ::v16(){vfunc_called(this, "_ZN9S708C5_nt3v16Ev");}
void  S708C5_nt ::v17(){vfunc_called(this, "_ZN9S708C5_nt3v17Ev");}
void  S708C5_nt ::v18(){vfunc_called(this, "_ZN9S708C5_nt3v18Ev");}
void  S708C5_nt ::v19(){vfunc_called(this, "_ZN9S708C5_nt3v19Ev");}
void  S708C5_nt ::v20(){vfunc_called(this, "_ZN9S708C5_nt3v20Ev");}
void  S708C5_nt ::v21(){vfunc_called(this, "_ZN9S708C5_nt3v21Ev");}
void  S708C5_nt ::v22(){vfunc_called(this, "_ZN9S708C5_nt3v22Ev");}
void  S708C5_nt ::v23(){vfunc_called(this, "_ZN9S708C5_nt3v23Ev");}
void  S708C5_nt ::v24(){vfunc_called(this, "_ZN9S708C5_nt3v24Ev");}
void  S708C5_nt ::v25(){vfunc_called(this, "_ZN9S708C5_nt3v25Ev");}
void  S708C5_nt ::v26(){vfunc_called(this, "_ZN9S708C5_nt3v26Ev");}
void  S708C5_nt ::v27(){vfunc_called(this, "_ZN9S708C5_nt3v27Ev");}
void  S708C5_nt ::v28(){vfunc_called(this, "_ZN9S708C5_nt3v28Ev");}
void  S708C5_nt ::v29(){vfunc_called(this, "_ZN9S708C5_nt3v29Ev");}
void  S708C5_nt ::v30(){vfunc_called(this, "_ZN9S708C5_nt3v30Ev");}
void  S708C5_nt ::v31(){vfunc_called(this, "_ZN9S708C5_nt3v31Ev");}
void  S708C5_nt ::v32(){vfunc_called(this, "_ZN9S708C5_nt3v32Ev");}
void  S708C5_nt ::v33(){vfunc_called(this, "_ZN9S708C5_nt3v33Ev");}
void  S708C5_nt ::v34(){vfunc_called(this, "_ZN9S708C5_nt3v34Ev");}
void  S708C5_nt ::v35(){vfunc_called(this, "_ZN9S708C5_nt3v35Ev");}
void  S708C5_nt ::v36(){vfunc_called(this, "_ZN9S708C5_nt3v36Ev");}
void  S708C5_nt ::v37(){vfunc_called(this, "_ZN9S708C5_nt3v37Ev");}
void  S708C5_nt ::v38(){vfunc_called(this, "_ZN9S708C5_nt3v38Ev");}
void  S708C5_nt ::v39(){vfunc_called(this, "_ZN9S708C5_nt3v39Ev");}
void  S708C5_nt ::v40(){vfunc_called(this, "_ZN9S708C5_nt3v40Ev");}
void  S708C5_nt ::v41(){vfunc_called(this, "_ZN9S708C5_nt3v41Ev");}
void  S708C5_nt ::v42(){vfunc_called(this, "_ZN9S708C5_nt3v42Ev");}
void  S708C5_nt ::v43(){vfunc_called(this, "_ZN9S708C5_nt3v43Ev");}
void  S708C5_nt ::v44(){vfunc_called(this, "_ZN9S708C5_nt3v44Ev");}
void  S708C5_nt ::v45(){vfunc_called(this, "_ZN9S708C5_nt3v45Ev");}
void  S708C5_nt ::v46(){vfunc_called(this, "_ZN9S708C5_nt3v46Ev");}
void  S708C5_nt ::v47(){vfunc_called(this, "_ZN9S708C5_nt3v47Ev");}
void  S708C5_nt ::v48(){vfunc_called(this, "_ZN9S708C5_nt3v48Ev");}
void  S708C5_nt ::v49(){vfunc_called(this, "_ZN9S708C5_nt3v49Ev");}
void  S708C5_nt ::v50(){vfunc_called(this, "_ZN9S708C5_nt3v50Ev");}
void  S708C5_nt ::v51(){vfunc_called(this, "_ZN9S708C5_nt3v51Ev");}
void  S708C5_nt ::v52(){vfunc_called(this, "_ZN9S708C5_nt3v52Ev");}
void  S708C5_nt ::v53(){vfunc_called(this, "_ZN9S708C5_nt3v53Ev");}
void  S708C5_nt ::v54(){vfunc_called(this, "_ZN9S708C5_nt3v54Ev");}
void  S708C5_nt ::v55(){vfunc_called(this, "_ZN9S708C5_nt3v55Ev");}
void  S708C5_nt ::v56(){vfunc_called(this, "_ZN9S708C5_nt3v56Ev");}
void  S708C5_nt ::v57(){vfunc_called(this, "_ZN9S708C5_nt3v57Ev");}
void  S708C5_nt ::v58(){vfunc_called(this, "_ZN9S708C5_nt3v58Ev");}
void  S708C5_nt ::v59(){vfunc_called(this, "_ZN9S708C5_nt3v59Ev");}
void  S708C5_nt ::v60(){vfunc_called(this, "_ZN9S708C5_nt3v60Ev");}
void  S708C5_nt ::v61(){vfunc_called(this, "_ZN9S708C5_nt3v61Ev");}
void  S708C5_nt ::v62(){vfunc_called(this, "_ZN9S708C5_nt3v62Ev");}
void  S708C5_nt ::v63(){vfunc_called(this, "_ZN9S708C5_nt3v63Ev");}
void  S708C5_nt ::v64(){vfunc_called(this, "_ZN9S708C5_nt3v64Ev");}
void  S708C5_nt ::v65(){vfunc_called(this, "_ZN9S708C5_nt3v65Ev");}
void  S708C5_nt ::v66(){vfunc_called(this, "_ZN9S708C5_nt3v66Ev");}
void  S708C5_nt ::v67(){vfunc_called(this, "_ZN9S708C5_nt3v67Ev");}
void  S708C5_nt ::v68(){vfunc_called(this, "_ZN9S708C5_nt3v68Ev");}
void  S708C5_nt ::v69(){vfunc_called(this, "_ZN9S708C5_nt3v69Ev");}
void  S708C5_nt ::v70(){vfunc_called(this, "_ZN9S708C5_nt3v70Ev");}
void  S708C5_nt ::v71(){vfunc_called(this, "_ZN9S708C5_nt3v71Ev");}
void  S708C5_nt ::v72(){vfunc_called(this, "_ZN9S708C5_nt3v72Ev");}
S708C5_nt ::S708C5_nt(){ note_ctor("S708C5_nt", this);} // tgen

//skip512 S708C5_nt

#else // __cplusplus

extern void _ZN9S708C5_ntC1Ev();
extern void _ZN9S708C5_ntD1Ev();
Name_Map name_map_S708C5_nt[] = {
  NSPAIR(_ZN9S708C5_ntC1Ev),
  NSPAIR(_ZN9S708C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S708C5_nt[];
extern void _ZN9S708C5_ntD1Ev();
extern void _ZN9S708C5_ntD0Ev();
extern void _ZN9S708C5_nt2v9Ev();
extern void _ZN9S708C5_nt3v10Ev();
extern void _ZN9S708C5_nt3v11Ev();
extern void _ZN9S708C5_nt3v12Ev();
extern void _ZN9S708C5_nt3v13Ev();
extern void _ZN9S708C5_nt3v14Ev();
extern void _ZN9S708C5_nt3v15Ev();
extern void _ZN9S708C5_nt3v16Ev();
extern void _ZN9S708C5_nt3v17Ev();
extern void _ZN9S708C5_nt3v18Ev();
extern void _ZN9S708C5_nt3v19Ev();
extern void _ZN9S708C5_nt3v20Ev();
extern void _ZN9S708C5_nt3v21Ev();
extern void _ZN9S708C5_nt3v22Ev();
extern void _ZN9S708C5_nt3v23Ev();
extern void _ZN9S708C5_nt3v24Ev();
extern void _ZN9S708C5_nt3v25Ev();
extern void _ZN9S708C5_nt3v26Ev();
extern void _ZN9S708C5_nt3v27Ev();
extern void _ZN9S708C5_nt3v28Ev();
extern void _ZN9S708C5_nt3v29Ev();
extern void _ZN9S708C5_nt3v30Ev();
extern void _ZN9S708C5_nt3v31Ev();
extern void _ZN9S708C5_nt3v32Ev();
extern void _ZN9S708C5_nt3v33Ev();
extern void _ZN9S708C5_nt3v34Ev();
extern void _ZN9S708C5_nt3v35Ev();
extern void _ZN9S708C5_nt3v36Ev();
extern void _ZN9S708C5_nt3v37Ev();
extern void _ZN9S708C5_nt3v38Ev();
extern void _ZN9S708C5_nt3v39Ev();
extern void _ZN9S708C5_nt3v40Ev();
extern void _ZN9S708C5_nt3v41Ev();
extern void _ZN9S708C5_nt3v42Ev();
extern void _ZN9S708C5_nt3v43Ev();
extern void _ZN9S708C5_nt3v44Ev();
extern void _ZN9S708C5_nt3v45Ev();
extern void _ZN9S708C5_nt3v46Ev();
extern void _ZN9S708C5_nt3v47Ev();
extern void _ZN9S708C5_nt3v48Ev();
extern void _ZN9S708C5_nt3v49Ev();
extern void _ZN9S708C5_nt3v50Ev();
extern void _ZN9S708C5_nt3v51Ev();
extern void _ZN9S708C5_nt3v52Ev();
extern void _ZN9S708C5_nt3v53Ev();
extern void _ZN9S708C5_nt3v54Ev();
extern void _ZN9S708C5_nt3v55Ev();
extern void _ZN9S708C5_nt3v56Ev();
extern void _ZN9S708C5_nt3v57Ev();
extern void _ZN9S708C5_nt3v58Ev();
extern void _ZN9S708C5_nt3v59Ev();
extern void _ZN9S708C5_nt3v60Ev();
extern void _ZN9S708C5_nt3v61Ev();
extern void _ZN9S708C5_nt3v62Ev();
extern void _ZN9S708C5_nt3v63Ev();
extern void _ZN9S708C5_nt3v64Ev();
extern void _ZN9S708C5_nt3v65Ev();
extern void _ZN9S708C5_nt3v66Ev();
extern void _ZN9S708C5_nt3v67Ev();
extern void _ZN9S708C5_nt3v68Ev();
extern void _ZN9S708C5_nt3v69Ev();
extern void _ZN9S708C5_nt3v70Ev();
extern void _ZN9S708C5_nt3v71Ev();
extern void _ZN9S708C5_nt3v72Ev();
static  VTBL_ENTRY vtc_S708C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S708C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S708C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S708C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v72Ev,
};
extern VTBL_ENTRY _ZTI9S708C5_nt[];
VTBL_ENTRY *P__ZTI9S708C5_nt = _ZTI9S708C5_nt; 
extern  VTBL_ENTRY _ZTV9S708C5_nt[];
Class_Descriptor cd_S708C5_nt = {  "S708C5_nt", // class name
  0,0,//no base classes
  &(vtc_S708C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S708C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S708C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C4_nt  : S708C5_nt {
  virtual  ~S708C4_nt(); // _ZN9S708C4_ntD1Ev
  virtual void  v73(); // _ZN9S708C4_nt3v73Ev
  virtual void  v74(); // _ZN9S708C4_nt3v74Ev
  S708C4_nt(); // tgen
};
//SIG(-1 S708C4_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S708C4_nt ::~S708C4_nt(){ note_dtor("S708C4_nt", this);}
void  S708C4_nt ::v73(){vfunc_called(this, "_ZN9S708C4_nt3v73Ev");}
void  S708C4_nt ::v74(){vfunc_called(this, "_ZN9S708C4_nt3v74Ev");}
S708C4_nt ::S708C4_nt(){ note_ctor("S708C4_nt", this);} // tgen

//skip512 S708C4_nt

#else // __cplusplus

extern void _ZN9S708C4_ntC1Ev();
extern void _ZN9S708C4_ntD1Ev();
Name_Map name_map_S708C4_nt[] = {
  NSPAIR(_ZN9S708C4_ntC1Ev),
  NSPAIR(_ZN9S708C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S708C5_nt;
extern VTBL_ENTRY _ZTI9S708C5_nt[];
extern  VTBL_ENTRY _ZTV9S708C5_nt[];
static Base_Class bases_S708C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S708C4_nt[];
extern void _ZN9S708C4_ntD1Ev();
extern void _ZN9S708C4_ntD0Ev();
extern void _ZN9S708C5_nt2v9Ev();
extern void _ZN9S708C5_nt3v10Ev();
extern void _ZN9S708C5_nt3v11Ev();
extern void _ZN9S708C5_nt3v12Ev();
extern void _ZN9S708C5_nt3v13Ev();
extern void _ZN9S708C5_nt3v14Ev();
extern void _ZN9S708C5_nt3v15Ev();
extern void _ZN9S708C5_nt3v16Ev();
extern void _ZN9S708C5_nt3v17Ev();
extern void _ZN9S708C5_nt3v18Ev();
extern void _ZN9S708C5_nt3v19Ev();
extern void _ZN9S708C5_nt3v20Ev();
extern void _ZN9S708C5_nt3v21Ev();
extern void _ZN9S708C5_nt3v22Ev();
extern void _ZN9S708C5_nt3v23Ev();
extern void _ZN9S708C5_nt3v24Ev();
extern void _ZN9S708C5_nt3v25Ev();
extern void _ZN9S708C5_nt3v26Ev();
extern void _ZN9S708C5_nt3v27Ev();
extern void _ZN9S708C5_nt3v28Ev();
extern void _ZN9S708C5_nt3v29Ev();
extern void _ZN9S708C5_nt3v30Ev();
extern void _ZN9S708C5_nt3v31Ev();
extern void _ZN9S708C5_nt3v32Ev();
extern void _ZN9S708C5_nt3v33Ev();
extern void _ZN9S708C5_nt3v34Ev();
extern void _ZN9S708C5_nt3v35Ev();
extern void _ZN9S708C5_nt3v36Ev();
extern void _ZN9S708C5_nt3v37Ev();
extern void _ZN9S708C5_nt3v38Ev();
extern void _ZN9S708C5_nt3v39Ev();
extern void _ZN9S708C5_nt3v40Ev();
extern void _ZN9S708C5_nt3v41Ev();
extern void _ZN9S708C5_nt3v42Ev();
extern void _ZN9S708C5_nt3v43Ev();
extern void _ZN9S708C5_nt3v44Ev();
extern void _ZN9S708C5_nt3v45Ev();
extern void _ZN9S708C5_nt3v46Ev();
extern void _ZN9S708C5_nt3v47Ev();
extern void _ZN9S708C5_nt3v48Ev();
extern void _ZN9S708C5_nt3v49Ev();
extern void _ZN9S708C5_nt3v50Ev();
extern void _ZN9S708C5_nt3v51Ev();
extern void _ZN9S708C5_nt3v52Ev();
extern void _ZN9S708C5_nt3v53Ev();
extern void _ZN9S708C5_nt3v54Ev();
extern void _ZN9S708C5_nt3v55Ev();
extern void _ZN9S708C5_nt3v56Ev();
extern void _ZN9S708C5_nt3v57Ev();
extern void _ZN9S708C5_nt3v58Ev();
extern void _ZN9S708C5_nt3v59Ev();
extern void _ZN9S708C5_nt3v60Ev();
extern void _ZN9S708C5_nt3v61Ev();
extern void _ZN9S708C5_nt3v62Ev();
extern void _ZN9S708C5_nt3v63Ev();
extern void _ZN9S708C5_nt3v64Ev();
extern void _ZN9S708C5_nt3v65Ev();
extern void _ZN9S708C5_nt3v66Ev();
extern void _ZN9S708C5_nt3v67Ev();
extern void _ZN9S708C5_nt3v68Ev();
extern void _ZN9S708C5_nt3v69Ev();
extern void _ZN9S708C5_nt3v70Ev();
extern void _ZN9S708C5_nt3v71Ev();
extern void _ZN9S708C5_nt3v72Ev();
extern void _ZN9S708C4_nt3v73Ev();
extern void _ZN9S708C4_nt3v74Ev();
static  VTBL_ENTRY vtc_S708C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S708C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S708C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S708C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v74Ev,
};
extern VTBL_ENTRY _ZTI9S708C4_nt[];
VTBL_ENTRY *P__ZTI9S708C4_nt = _ZTI9S708C4_nt; 
extern  VTBL_ENTRY _ZTV9S708C4_nt[];
Class_Descriptor cd_S708C4_nt = {  "S708C4_nt", // class name
  bases_S708C4_nt, 1,
  &(vtc_S708C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S708C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S708C4_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C7_nt  {
  int s708c7f0[4];
  char s708c7f1[9];
  void  mf708c7(); // _ZN9S708C7_nt7mf708c7Ev
};
//SIG(-1 S708C7_nt) C1{ m Fi[4] Fc[9]}


void  S708C7_nt ::mf708c7(){}

//skip512 S708C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C10_nt  {
  void *s708c10f0;
  int s708c10f1[2];
  void  mf708c10(); // _ZN10S708C10_nt8mf708c10Ev
};
//SIG(-1 S708C10_nt) C1{ m Fp Fi[2]}


void  S708C10_nt ::mf708c10(){}

//skip512 S708C10_nt

#else // __cplusplus

Class_Descriptor cd_S708C10_nt = {  "S708C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C9_nt  : S708C10_nt {
};
//SIG(-1 S708C9_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S708C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C9_nt = {  "S708C9_nt", // class name
  bases_S708C9_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C8_nt  : S708C9_nt {
};
//SIG(-1 S708C8_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S708C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C9_nt;
static Base_Class bases_S708C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C14  : S708C10_nt {
};
//SIG(-1 S708C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C14()
{
  extern Class_Descriptor cd_S708C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C14, buf);
    S708C14 &lv = *(new (buf) S708C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C14)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C14");
    test_class_info(&lv, &cd_S708C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C14(Test_S708C14, "S708C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C14 = {  "S708C14", // class name
  bases_S708C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C13  : S708C14 {
};
//SIG(-1 S708C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S708C13()
{
  extern Class_Descriptor cd_S708C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C13, buf);
    S708C13 &lv = *(new (buf) S708C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C13)");
    check_base_class_offset(lv, (S708C10_nt*)(S708C14*), 0, "S708C13");
    check_base_class_offset(lv, (S708C14*), 0, "S708C13");
    test_class_info(&lv, &cd_S708C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C13(Test_S708C13, "S708C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C14;
static Base_Class bases_S708C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C13 = {  "S708C13", // class name
  bases_S708C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C18  : S708C10_nt {
};
//SIG(-1 S708C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C18()
{
  extern Class_Descriptor cd_S708C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C18, buf);
    S708C18 &lv = *(new (buf) S708C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C18)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C18");
    test_class_info(&lv, &cd_S708C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C18(Test_S708C18, "S708C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C18 = {  "S708C18", // class name
  bases_S708C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C17  : S708C18 {
};
//SIG(-1 S708C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S708C17()
{
  extern Class_Descriptor cd_S708C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C17, buf);
    S708C17 &lv = *(new (buf) S708C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C17)");
    check_base_class_offset(lv, (S708C10_nt*)(S708C18*), 0, "S708C17");
    check_base_class_offset(lv, (S708C18*), 0, "S708C17");
    test_class_info(&lv, &cd_S708C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C17(Test_S708C17, "S708C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C18;
static Base_Class bases_S708C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C17 = {  "S708C17", // class name
  bases_S708C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C19_nt  {
  void *s708c19f0;
  ::S708C6_nt s708c19f1;
  void  mf708c19(); // _ZN10S708C19_nt8mf708c19Ev
};
//SIG(-1 S708C19_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S708C19_nt ::mf708c19(){}

//skip512 S708C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C3_nt  : S708C4_nt {
  ::S708C7_nt s708c3f0;
  int s708c3f1;
  unsigned int s708c3f2:1;
  unsigned int s708c3f3:1;
  unsigned int s708c3f4:1;
  unsigned int s708c3f5:1;
  ::S708C8_nt s708c3f6;
  ::S708C8_nt s708c3f7;
  void *s708c3f8;
  ::S708C13 s708c3f9;
  ::S708C13 s708c3f10;
  ::S708C13 s708c3f11;
  ::S708C17 s708c3f12;
  char s708c3f13;
  int s708c3f14;
  void *s708c3f15;
  ::S708C6_nt s708c3f16;
  ::S708C6_nt s708c3f17;
  ::S708C6_nt s708c3f18;
  ::S708C6_nt s708c3f19;
  ::S708C6_nt s708c3f20;
  ::S708C6_nt s708c3f21;
  ::S708C19_nt s708c3f22;
  ::S708C19_nt s708c3f23;
  ::S708C19_nt s708c3f24;
  ::S708C19_nt s708c3f25;
  ::S708C19_nt s708c3f26;
  ::S708C19_nt s708c3f27;
  ::S708C19_nt s708c3f28;
  ::S708C19_nt s708c3f29;
  ::S708C19_nt s708c3f30;
  ::S708C19_nt s708c3f31;
  virtual  ~S708C3_nt(); // _ZN9S708C3_ntD1Ev
  virtual void  v75(); // _ZN9S708C3_nt3v75Ev
  virtual void  v76(); // _ZN9S708C3_nt3v76Ev
  virtual void  v77(); // _ZN9S708C3_nt3v77Ev
  virtual void  v78(); // _ZN9S708C3_nt3v78Ev
  virtual void  v79(); // _ZN9S708C3_nt3v79Ev
  virtual void  v80(); // _ZN9S708C3_nt3v80Ev
  virtual void  v81(); // _ZN9S708C3_nt3v81Ev
  virtual void  v82(); // _ZN9S708C3_nt3v82Ev
  virtual void  v83(); // _ZN9S708C3_nt3v83Ev
  virtual void  v84(); // _ZN9S708C3_nt3v84Ev
  virtual void  v85(); // _ZN9S708C3_nt3v85Ev
  virtual void  v86(); // _ZN9S708C3_nt3v86Ev
  virtual void  v87(); // _ZN9S708C3_nt3v87Ev
  virtual void  v88(); // _ZN9S708C3_nt3v88Ev
  virtual void  v89(); // _ZN9S708C3_nt3v89Ev
  virtual void  v90(); // _ZN9S708C3_nt3v90Ev
  virtual void  v91(); // _ZN9S708C3_nt3v91Ev
  virtual void  v92(); // _ZN9S708C3_nt3v92Ev
  virtual void  v93(); // _ZN9S708C3_nt3v93Ev
  virtual void  v94(); // _ZN9S708C3_nt3v94Ev
  virtual void  v95(); // _ZN9S708C3_nt3v95Ev
  virtual void  v96(); // _ZN9S708C3_nt3v96Ev
  virtual void  v97(); // _ZN9S708C3_nt3v97Ev
  virtual void  v98(); // _ZN9S708C3_nt3v98Ev
  virtual void  v99(); // _ZN9S708C3_nt3v99Ev
  virtual void  v100(); // _ZN9S708C3_nt4v100Ev
  virtual void  v101(); // _ZN9S708C3_nt4v101Ev
  virtual void  v102(); // _ZN9S708C3_nt4v102Ev
  virtual void  v103(); // _ZN9S708C3_nt4v103Ev
  virtual void  v104(); // _ZN9S708C3_nt4v104Ev
  virtual void  v105(); // _ZN9S708C3_nt4v105Ev
  virtual void  v106(); // _ZN9S708C3_nt4v106Ev
  virtual void  v107(); // _ZN9S708C3_nt4v107Ev
  virtual void  v108(); // _ZN9S708C3_nt4v108Ev
  virtual void  v109(); // _ZN9S708C3_nt4v109Ev
  virtual void  v110(); // _ZN9S708C3_nt4v110Ev
  virtual void  v111(); // _ZN9S708C3_nt4v111Ev
  virtual void  v112(); // _ZN9S708C3_nt4v112Ev
  virtual void  v113(); // _ZN9S708C3_nt4v113Ev
  virtual void  v114(); // _ZN9S708C3_nt4v114Ev
  virtual void  v115(); // _ZN9S708C3_nt4v115Ev
  virtual void  v116(); // _ZN9S708C3_nt4v116Ev
  virtual void  v117(); // _ZN9S708C3_nt4v117Ev
  virtual void  v118(); // _ZN9S708C3_nt4v118Ev
  virtual void  v119(); // _ZN9S708C3_nt4v119Ev
  virtual void  v120(); // _ZN9S708C3_nt4v120Ev
  virtual void  v121(); // _ZN9S708C3_nt4v121Ev
  virtual void  v122(); // _ZN9S708C3_nt4v122Ev
  virtual void  v123(); // _ZN9S708C3_nt4v123Ev
  virtual void  v124(); // _ZN9S708C3_nt4v124Ev
  virtual void  v125(); // _ZN9S708C3_nt4v125Ev
  virtual void  v126(); // _ZN9S708C3_nt4v126Ev
  virtual void  v127(); // _ZN9S708C3_nt4v127Ev
  virtual void  v128(); // _ZN9S708C3_nt4v128Ev
  virtual void  v129(); // _ZN9S708C3_nt4v129Ev
  virtual void  v130(); // _ZN9S708C3_nt4v130Ev
  virtual void  v131(); // _ZN9S708C3_nt4v131Ev
  virtual void  v132(); // _ZN9S708C3_nt4v132Ev
  virtual void  v133(); // _ZN9S708C3_nt4v133Ev
  virtual void  v134(); // _ZN9S708C3_nt4v134Ev
  virtual void  v135(); // _ZN9S708C3_nt4v135Ev
  virtual void  v136(); // _ZN9S708C3_nt4v136Ev
  virtual void  v137(); // _ZN9S708C3_nt4v137Ev
  virtual void  v138(); // _ZN9S708C3_nt4v138Ev
  virtual void  v139(); // _ZN9S708C3_nt4v139Ev
  virtual void  v140(); // _ZN9S708C3_nt4v140Ev
  virtual void  v141(); // _ZN9S708C3_nt4v141Ev
  virtual void  v142(); // _ZN9S708C3_nt4v142Ev
  virtual void  v143(); // _ZN9S708C3_nt4v143Ev
  virtual void  v144(); // _ZN9S708C3_nt4v144Ev
  virtual void  v145(); // _ZN9S708C3_nt4v145Ev
  virtual void  v146(); // _ZN9S708C3_nt4v146Ev
  virtual void  v147(); // _ZN9S708C3_nt4v147Ev
  virtual void  v148(); // _ZN9S708C3_nt4v148Ev
  virtual void  v149(); // _ZN9S708C3_nt4v149Ev
  virtual void  v150(); // _ZN9S708C3_nt4v150Ev
  S708C3_nt(); // tgen
};
//SIG(-1 S708C3_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S708C3_nt ::~S708C3_nt(){ note_dtor("S708C3_nt", this);}
void  S708C3_nt ::v75(){vfunc_called(this, "_ZN9S708C3_nt3v75Ev");}
void  S708C3_nt ::v76(){vfunc_called(this, "_ZN9S708C3_nt3v76Ev");}
void  S708C3_nt ::v77(){vfunc_called(this, "_ZN9S708C3_nt3v77Ev");}
void  S708C3_nt ::v78(){vfunc_called(this, "_ZN9S708C3_nt3v78Ev");}
void  S708C3_nt ::v79(){vfunc_called(this, "_ZN9S708C3_nt3v79Ev");}
void  S708C3_nt ::v80(){vfunc_called(this, "_ZN9S708C3_nt3v80Ev");}
void  S708C3_nt ::v81(){vfunc_called(this, "_ZN9S708C3_nt3v81Ev");}
void  S708C3_nt ::v82(){vfunc_called(this, "_ZN9S708C3_nt3v82Ev");}
void  S708C3_nt ::v83(){vfunc_called(this, "_ZN9S708C3_nt3v83Ev");}
void  S708C3_nt ::v84(){vfunc_called(this, "_ZN9S708C3_nt3v84Ev");}
void  S708C3_nt ::v85(){vfunc_called(this, "_ZN9S708C3_nt3v85Ev");}
void  S708C3_nt ::v86(){vfunc_called(this, "_ZN9S708C3_nt3v86Ev");}
void  S708C3_nt ::v87(){vfunc_called(this, "_ZN9S708C3_nt3v87Ev");}
void  S708C3_nt ::v88(){vfunc_called(this, "_ZN9S708C3_nt3v88Ev");}
void  S708C3_nt ::v89(){vfunc_called(this, "_ZN9S708C3_nt3v89Ev");}
void  S708C3_nt ::v90(){vfunc_called(this, "_ZN9S708C3_nt3v90Ev");}
void  S708C3_nt ::v91(){vfunc_called(this, "_ZN9S708C3_nt3v91Ev");}
void  S708C3_nt ::v92(){vfunc_called(this, "_ZN9S708C3_nt3v92Ev");}
void  S708C3_nt ::v93(){vfunc_called(this, "_ZN9S708C3_nt3v93Ev");}
void  S708C3_nt ::v94(){vfunc_called(this, "_ZN9S708C3_nt3v94Ev");}
void  S708C3_nt ::v95(){vfunc_called(this, "_ZN9S708C3_nt3v95Ev");}
void  S708C3_nt ::v96(){vfunc_called(this, "_ZN9S708C3_nt3v96Ev");}
void  S708C3_nt ::v97(){vfunc_called(this, "_ZN9S708C3_nt3v97Ev");}
void  S708C3_nt ::v98(){vfunc_called(this, "_ZN9S708C3_nt3v98Ev");}
void  S708C3_nt ::v99(){vfunc_called(this, "_ZN9S708C3_nt3v99Ev");}
void  S708C3_nt ::v100(){vfunc_called(this, "_ZN9S708C3_nt4v100Ev");}
void  S708C3_nt ::v101(){vfunc_called(this, "_ZN9S708C3_nt4v101Ev");}
void  S708C3_nt ::v102(){vfunc_called(this, "_ZN9S708C3_nt4v102Ev");}
void  S708C3_nt ::v103(){vfunc_called(this, "_ZN9S708C3_nt4v103Ev");}
void  S708C3_nt ::v104(){vfunc_called(this, "_ZN9S708C3_nt4v104Ev");}
void  S708C3_nt ::v105(){vfunc_called(this, "_ZN9S708C3_nt4v105Ev");}
void  S708C3_nt ::v106(){vfunc_called(this, "_ZN9S708C3_nt4v106Ev");}
void  S708C3_nt ::v107(){vfunc_called(this, "_ZN9S708C3_nt4v107Ev");}
void  S708C3_nt ::v108(){vfunc_called(this, "_ZN9S708C3_nt4v108Ev");}
void  S708C3_nt ::v109(){vfunc_called(this, "_ZN9S708C3_nt4v109Ev");}
void  S708C3_nt ::v110(){vfunc_called(this, "_ZN9S708C3_nt4v110Ev");}
void  S708C3_nt ::v111(){vfunc_called(this, "_ZN9S708C3_nt4v111Ev");}
void  S708C3_nt ::v112(){vfunc_called(this, "_ZN9S708C3_nt4v112Ev");}
void  S708C3_nt ::v113(){vfunc_called(this, "_ZN9S708C3_nt4v113Ev");}
void  S708C3_nt ::v114(){vfunc_called(this, "_ZN9S708C3_nt4v114Ev");}
void  S708C3_nt ::v115(){vfunc_called(this, "_ZN9S708C3_nt4v115Ev");}
void  S708C3_nt ::v116(){vfunc_called(this, "_ZN9S708C3_nt4v116Ev");}
void  S708C3_nt ::v117(){vfunc_called(this, "_ZN9S708C3_nt4v117Ev");}
void  S708C3_nt ::v118(){vfunc_called(this, "_ZN9S708C3_nt4v118Ev");}
void  S708C3_nt ::v119(){vfunc_called(this, "_ZN9S708C3_nt4v119Ev");}
void  S708C3_nt ::v120(){vfunc_called(this, "_ZN9S708C3_nt4v120Ev");}
void  S708C3_nt ::v121(){vfunc_called(this, "_ZN9S708C3_nt4v121Ev");}
void  S708C3_nt ::v122(){vfunc_called(this, "_ZN9S708C3_nt4v122Ev");}
void  S708C3_nt ::v123(){vfunc_called(this, "_ZN9S708C3_nt4v123Ev");}
void  S708C3_nt ::v124(){vfunc_called(this, "_ZN9S708C3_nt4v124Ev");}
void  S708C3_nt ::v125(){vfunc_called(this, "_ZN9S708C3_nt4v125Ev");}
void  S708C3_nt ::v126(){vfunc_called(this, "_ZN9S708C3_nt4v126Ev");}
void  S708C3_nt ::v127(){vfunc_called(this, "_ZN9S708C3_nt4v127Ev");}
void  S708C3_nt ::v128(){vfunc_called(this, "_ZN9S708C3_nt4v128Ev");}
void  S708C3_nt ::v129(){vfunc_called(this, "_ZN9S708C3_nt4v129Ev");}
void  S708C3_nt ::v130(){vfunc_called(this, "_ZN9S708C3_nt4v130Ev");}
void  S708C3_nt ::v131(){vfunc_called(this, "_ZN9S708C3_nt4v131Ev");}
void  S708C3_nt ::v132(){vfunc_called(this, "_ZN9S708C3_nt4v132Ev");}
void  S708C3_nt ::v133(){vfunc_called(this, "_ZN9S708C3_nt4v133Ev");}
void  S708C3_nt ::v134(){vfunc_called(this, "_ZN9S708C3_nt4v134Ev");}
void  S708C3_nt ::v135(){vfunc_called(this, "_ZN9S708C3_nt4v135Ev");}
void  S708C3_nt ::v136(){vfunc_called(this, "_ZN9S708C3_nt4v136Ev");}
void  S708C3_nt ::v137(){vfunc_called(this, "_ZN9S708C3_nt4v137Ev");}
void  S708C3_nt ::v138(){vfunc_called(this, "_ZN9S708C3_nt4v138Ev");}
void  S708C3_nt ::v139(){vfunc_called(this, "_ZN9S708C3_nt4v139Ev");}
void  S708C3_nt ::v140(){vfunc_called(this, "_ZN9S708C3_nt4v140Ev");}
void  S708C3_nt ::v141(){vfunc_called(this, "_ZN9S708C3_nt4v141Ev");}
void  S708C3_nt ::v142(){vfunc_called(this, "_ZN9S708C3_nt4v142Ev");}
void  S708C3_nt ::v143(){vfunc_called(this, "_ZN9S708C3_nt4v143Ev");}
void  S708C3_nt ::v144(){vfunc_called(this, "_ZN9S708C3_nt4v144Ev");}
void  S708C3_nt ::v145(){vfunc_called(this, "_ZN9S708C3_nt4v145Ev");}
void  S708C3_nt ::v146(){vfunc_called(this, "_ZN9S708C3_nt4v146Ev");}
void  S708C3_nt ::v147(){vfunc_called(this, "_ZN9S708C3_nt4v147Ev");}
void  S708C3_nt ::v148(){vfunc_called(this, "_ZN9S708C3_nt4v148Ev");}
void  S708C3_nt ::v149(){vfunc_called(this, "_ZN9S708C3_nt4v149Ev");}
void  S708C3_nt ::v150(){vfunc_called(this, "_ZN9S708C3_nt4v150Ev");}
S708C3_nt ::S708C3_nt(){ note_ctor("S708C3_nt", this);} // tgen

//skip512 S708C3_nt

#else // __cplusplus

extern void _ZN9S708C3_ntC1Ev();
extern void _ZN9S708C3_ntD1Ev();
Name_Map name_map_S708C3_nt[] = {
  NSPAIR(_ZN9S708C3_ntC1Ev),
  NSPAIR(_ZN9S708C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S708C5_nt;
extern VTBL_ENTRY _ZTI9S708C5_nt[];
extern  VTBL_ENTRY _ZTV9S708C5_nt[];
extern Class_Descriptor cd_S708C4_nt;
extern VTBL_ENTRY _ZTI9S708C4_nt[];
extern  VTBL_ENTRY _ZTV9S708C4_nt[];
static Base_Class bases_S708C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S708C3_nt[];
extern void _ZN9S708C3_ntD1Ev();
extern void _ZN9S708C3_ntD0Ev();
extern void _ZN9S708C5_nt2v9Ev();
extern void _ZN9S708C5_nt3v10Ev();
extern void _ZN9S708C5_nt3v11Ev();
extern void _ZN9S708C5_nt3v12Ev();
extern void _ZN9S708C5_nt3v13Ev();
extern void _ZN9S708C5_nt3v14Ev();
extern void _ZN9S708C5_nt3v15Ev();
extern void _ZN9S708C5_nt3v16Ev();
extern void _ZN9S708C5_nt3v17Ev();
extern void _ZN9S708C5_nt3v18Ev();
extern void _ZN9S708C5_nt3v19Ev();
extern void _ZN9S708C5_nt3v20Ev();
extern void _ZN9S708C5_nt3v21Ev();
extern void _ZN9S708C5_nt3v22Ev();
extern void _ZN9S708C5_nt3v23Ev();
extern void _ZN9S708C5_nt3v24Ev();
extern void _ZN9S708C5_nt3v25Ev();
extern void _ZN9S708C5_nt3v26Ev();
extern void _ZN9S708C5_nt3v27Ev();
extern void _ZN9S708C5_nt3v28Ev();
extern void _ZN9S708C5_nt3v29Ev();
extern void _ZN9S708C5_nt3v30Ev();
extern void _ZN9S708C5_nt3v31Ev();
extern void _ZN9S708C5_nt3v32Ev();
extern void _ZN9S708C5_nt3v33Ev();
extern void _ZN9S708C5_nt3v34Ev();
extern void _ZN9S708C5_nt3v35Ev();
extern void _ZN9S708C5_nt3v36Ev();
extern void _ZN9S708C5_nt3v37Ev();
extern void _ZN9S708C5_nt3v38Ev();
extern void _ZN9S708C5_nt3v39Ev();
extern void _ZN9S708C5_nt3v40Ev();
extern void _ZN9S708C5_nt3v41Ev();
extern void _ZN9S708C5_nt3v42Ev();
extern void _ZN9S708C5_nt3v43Ev();
extern void _ZN9S708C5_nt3v44Ev();
extern void _ZN9S708C5_nt3v45Ev();
extern void _ZN9S708C5_nt3v46Ev();
extern void _ZN9S708C5_nt3v47Ev();
extern void _ZN9S708C5_nt3v48Ev();
extern void _ZN9S708C5_nt3v49Ev();
extern void _ZN9S708C5_nt3v50Ev();
extern void _ZN9S708C5_nt3v51Ev();
extern void _ZN9S708C5_nt3v52Ev();
extern void _ZN9S708C5_nt3v53Ev();
extern void _ZN9S708C5_nt3v54Ev();
extern void _ZN9S708C5_nt3v55Ev();
extern void _ZN9S708C5_nt3v56Ev();
extern void _ZN9S708C5_nt3v57Ev();
extern void _ZN9S708C5_nt3v58Ev();
extern void _ZN9S708C5_nt3v59Ev();
extern void _ZN9S708C5_nt3v60Ev();
extern void _ZN9S708C5_nt3v61Ev();
extern void _ZN9S708C5_nt3v62Ev();
extern void _ZN9S708C5_nt3v63Ev();
extern void _ZN9S708C5_nt3v64Ev();
extern void _ZN9S708C5_nt3v65Ev();
extern void _ZN9S708C5_nt3v66Ev();
extern void _ZN9S708C5_nt3v67Ev();
extern void _ZN9S708C5_nt3v68Ev();
extern void _ZN9S708C5_nt3v69Ev();
extern void _ZN9S708C5_nt3v70Ev();
extern void _ZN9S708C5_nt3v71Ev();
extern void _ZN9S708C5_nt3v72Ev();
extern void _ZN9S708C4_nt3v73Ev();
extern void _ZN9S708C4_nt3v74Ev();
extern void _ZN9S708C3_nt3v75Ev();
extern void _ZN9S708C3_nt3v76Ev();
extern void _ZN9S708C3_nt3v77Ev();
extern void _ZN9S708C3_nt3v78Ev();
extern void _ZN9S708C3_nt3v79Ev();
extern void _ZN9S708C3_nt3v80Ev();
extern void _ZN9S708C3_nt3v81Ev();
extern void _ZN9S708C3_nt3v82Ev();
extern void _ZN9S708C3_nt3v83Ev();
extern void _ZN9S708C3_nt3v84Ev();
extern void _ZN9S708C3_nt3v85Ev();
extern void _ZN9S708C3_nt3v86Ev();
extern void _ZN9S708C3_nt3v87Ev();
extern void _ZN9S708C3_nt3v88Ev();
extern void _ZN9S708C3_nt3v89Ev();
extern void _ZN9S708C3_nt3v90Ev();
extern void _ZN9S708C3_nt3v91Ev();
extern void _ZN9S708C3_nt3v92Ev();
extern void _ZN9S708C3_nt3v93Ev();
extern void _ZN9S708C3_nt3v94Ev();
extern void _ZN9S708C3_nt3v95Ev();
extern void _ZN9S708C3_nt3v96Ev();
extern void _ZN9S708C3_nt3v97Ev();
extern void _ZN9S708C3_nt3v98Ev();
extern void _ZN9S708C3_nt3v99Ev();
extern void _ZN9S708C3_nt4v100Ev();
extern void _ZN9S708C3_nt4v101Ev();
extern void _ZN9S708C3_nt4v102Ev();
extern void _ZN9S708C3_nt4v103Ev();
extern void _ZN9S708C3_nt4v104Ev();
extern void _ZN9S708C3_nt4v105Ev();
extern void _ZN9S708C3_nt4v106Ev();
extern void _ZN9S708C3_nt4v107Ev();
extern void _ZN9S708C3_nt4v108Ev();
extern void _ZN9S708C3_nt4v109Ev();
extern void _ZN9S708C3_nt4v110Ev();
extern void _ZN9S708C3_nt4v111Ev();
extern void _ZN9S708C3_nt4v112Ev();
extern void _ZN9S708C3_nt4v113Ev();
extern void _ZN9S708C3_nt4v114Ev();
extern void _ZN9S708C3_nt4v115Ev();
extern void _ZN9S708C3_nt4v116Ev();
extern void _ZN9S708C3_nt4v117Ev();
extern void _ZN9S708C3_nt4v118Ev();
extern void _ZN9S708C3_nt4v119Ev();
extern void _ZN9S708C3_nt4v120Ev();
extern void _ZN9S708C3_nt4v121Ev();
extern void _ZN9S708C3_nt4v122Ev();
extern void _ZN9S708C3_nt4v123Ev();
extern void _ZN9S708C3_nt4v124Ev();
extern void _ZN9S708C3_nt4v125Ev();
extern void _ZN9S708C3_nt4v126Ev();
extern void _ZN9S708C3_nt4v127Ev();
extern void _ZN9S708C3_nt4v128Ev();
extern void _ZN9S708C3_nt4v129Ev();
extern void _ZN9S708C3_nt4v130Ev();
extern void _ZN9S708C3_nt4v131Ev();
extern void _ZN9S708C3_nt4v132Ev();
extern void _ZN9S708C3_nt4v133Ev();
extern void _ZN9S708C3_nt4v134Ev();
extern void _ZN9S708C3_nt4v135Ev();
extern void _ZN9S708C3_nt4v136Ev();
extern void _ZN9S708C3_nt4v137Ev();
extern void _ZN9S708C3_nt4v138Ev();
extern void _ZN9S708C3_nt4v139Ev();
extern void _ZN9S708C3_nt4v140Ev();
extern void _ZN9S708C3_nt4v141Ev();
extern void _ZN9S708C3_nt4v142Ev();
extern void _ZN9S708C3_nt4v143Ev();
extern void _ZN9S708C3_nt4v144Ev();
extern void _ZN9S708C3_nt4v145Ev();
extern void _ZN9S708C3_nt4v146Ev();
extern void _ZN9S708C3_nt4v147Ev();
extern void _ZN9S708C3_nt4v148Ev();
extern void _ZN9S708C3_nt4v149Ev();
extern void _ZN9S708C3_nt4v150Ev();
static  VTBL_ENTRY vtc_S708C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S708C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S708C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S708C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v150Ev,
};
extern VTBL_ENTRY _ZTI9S708C3_nt[];
VTBL_ENTRY *P__ZTI9S708C3_nt = _ZTI9S708C3_nt; 
extern  VTBL_ENTRY _ZTV9S708C3_nt[];
Class_Descriptor cd_S708C3_nt = {  "S708C3_nt", // class name
  bases_S708C3_nt, 2,
  &(vtc_S708C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S708C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S708C3_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C21_nt  {
  int s708c21f0[4];
  void  mf708c21(); // _ZN10S708C21_nt8mf708c21Ev
};
//SIG(-1 S708C21_nt) C1{ m Fi[4]}


void  S708C21_nt ::mf708c21(){}

//skip512 S708C21_nt

#else // __cplusplus

Class_Descriptor cd_S708C21_nt = {  "S708C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C20_nt  : S708C21_nt {
};
//SIG(-1 S708C20_nt) C1{ BC2{ m Fi[4]}}



//skip512 S708C20_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C21_nt;
static Base_Class bases_S708C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C22_nt  {
  ::S708C6_nt s708c22f0;
  void *s708c22f1;
  ::S708C20_nt s708c22f2;
  void *s708c22f3;
  void  mf708c22(); // _ZN10S708C22_nt8mf708c22Ev
};
//SIG(-1 S708C22_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S708C22_nt ::mf708c22(){}

//skip512 S708C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C24_nt  {
  void *s708c24f0[8];
  char s708c24f1[4];
  void  mf708c24(); // _ZN10S708C24_nt8mf708c24Ev
};
//SIG(-1 S708C24_nt) C1{ m Fp[8] Fc[4]}


void  S708C24_nt ::mf708c24(){}

//skip512 S708C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C26_nt  {
  int s708c26f0[4];
  char s708c26f1[4];
  void  mf708c26(); // _ZN10S708C26_nt8mf708c26Ev
};
//SIG(-1 S708C26_nt) C1{ m Fi[4] Fc[4]}


void  S708C26_nt ::mf708c26(){}

//skip512 S708C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C25_nt  {
  void *s708c25f0[5];
  ::S708C26_nt s708c25f1;
  unsigned int s708c25f2:1;
  unsigned int s708c25f3:1;
  int s708c25f4;
  char s708c25f5[8];
  void  mf708c25(); // _ZN10S708C25_nt8mf708c25Ev
};
//SIG(-1 S708C25_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S708C25_nt ::mf708c25(){}

//skip512 S708C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C29_nt  {
  int s708c29f0[3];
  void  mf708c29(); // _ZN10S708C29_nt8mf708c29Ev
};
//SIG(-1 S708C29_nt) C1{ m Fi[3]}


void  S708C29_nt ::mf708c29(){}

//skip512 S708C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C30_nt  {
  void  mf708c30(); // _ZN10S708C30_nt8mf708c30Ev
};
//SIG(-1 S708C30_nt) C1{ m}


void  S708C30_nt ::mf708c30(){}

//skip512 S708C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C32_nt  {
  int s708c32f0[2];
  char s708c32f1[2];
  void  mf708c32(); // _ZN10S708C32_nt8mf708c32Ev
};
//SIG(-1 S708C32_nt) C1{ m Fi[2] Fc[2]}


void  S708C32_nt ::mf708c32(){}

//skip512 S708C32_nt

#else // __cplusplus

Class_Descriptor cd_S708C32_nt = {  "S708C32_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C31_nt  : S708C32_nt {
  int s708c31f0;
};
//SIG(-1 S708C31_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S708C31_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C32_nt;
static Base_Class bases_S708C31_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C32_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C28_nt  {
  ::S708C29_nt s708c28f0;
  ::S708C30_nt s708c28f1;
  ::S708C31_nt s708c28f2;
  char s708c28f3;
  void  mf708c28(); // _ZN10S708C28_nt8mf708c28Ev
};
//SIG(-1 S708C28_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S708C28_nt ::mf708c28(){}

//skip512 S708C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C36_nt  {
  void *s708c36f0[2];
  void  mf708c36(); // _ZN10S708C36_nt8mf708c36Ev
};
//SIG(-1 S708C36_nt) C1{ m Fp[2]}


void  S708C36_nt ::mf708c36(){}

//skip512 S708C36_nt

#else // __cplusplus

Class_Descriptor cd_S708C36_nt = {  "S708C36_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C35_nt  : S708C36_nt {
};
//SIG(-1 S708C35_nt) C1{ BC2{ m Fp[2]}}



//skip512 S708C35_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C36_nt;
static Base_Class bases_S708C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C39  : S708C10_nt {
};
//SIG(-1 S708C39) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C39()
{
  extern Class_Descriptor cd_S708C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C39, buf);
    S708C39 &lv = *(new (buf) S708C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C39)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C39");
    test_class_info(&lv, &cd_S708C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C39(Test_S708C39, "S708C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C39 = {  "S708C39", // class name
  bases_S708C39, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C38  : S708C39 {
};
//SIG(-1 S708C38) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S708C38()
{
  extern Class_Descriptor cd_S708C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C38, buf);
    S708C38 &lv = *(new (buf) S708C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C38)");
    check_base_class_offset(lv, (S708C10_nt*)(S708C39*), 0, "S708C38");
    check_base_class_offset(lv, (S708C39*), 0, "S708C38");
    test_class_info(&lv, &cd_S708C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C38(Test_S708C38, "S708C38", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C39;
static Base_Class bases_S708C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C38 = {  "S708C38", // class name
  bases_S708C38, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C37_nt  : S708C38 {
};
//SIG(-1 S708C37_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S708C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C39;
extern Class_Descriptor cd_S708C38;
static Base_Class bases_S708C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S708C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C34_nt  {
  ::S708C35_nt s708c34f0;
  char s708c34f1;
  ::S708C37_nt s708c34f2;
  int s708c34f3;
  ::S708C6_nt s708c34f4;
  ::S708C6_nt s708c34f5;
  void *s708c34f6;
  void  mf708c34(); // _ZN10S708C34_nt8mf708c34Ev
};
//SIG(-1 S708C34_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S708C34_nt ::mf708c34(){}

//skip512 S708C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C43  : S708C10_nt {
};
//SIG(-1 S708C43) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C43()
{
  extern Class_Descriptor cd_S708C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C43, buf);
    S708C43 &lv = *(new (buf) S708C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C43)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C43");
    test_class_info(&lv, &cd_S708C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C43(Test_S708C43, "S708C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C43 = {  "S708C43", // class name
  bases_S708C43, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C42  : S708C43 {
};
//SIG(-1 S708C42) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S708C42()
{
  extern Class_Descriptor cd_S708C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C42, buf);
    S708C42 &lv = *(new (buf) S708C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C42)");
    check_base_class_offset(lv, (S708C10_nt*)(S708C43*), 0, "S708C42");
    check_base_class_offset(lv, (S708C43*), 0, "S708C42");
    test_class_info(&lv, &cd_S708C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C42(Test_S708C42, "S708C42", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C43;
static Base_Class bases_S708C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C42 = {  "S708C42", // class name
  bases_S708C42, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C2_nt  : S708C3_nt {
  ::S708C20_nt s708c2f0;
  ::S708C6_nt s708c2f1;
  void *s708c2f2[2];
  ::S708C22_nt s708c2f3;
  ::S708C24_nt s708c2f4;
  int s708c2f5;
  ::S708C25_nt s708c2f6;
  int s708c2f7[4];
  ::S708C6_nt s708c2f8[4];
  ::S708C28_nt s708c2f9;
  ::S708C29_nt s708c2f10;
  int s708c2f11;
  ::S708C34_nt s708c2f12;
  ::S708C34_nt s708c2f13;
  void *s708c2f14;
  ::S708C29_nt s708c2f15;
  ::S708C17 s708c2f16;
  ::S708C42 s708c2f17;
  unsigned int s708c2f18:1;
  unsigned int s708c2f19:1;
  unsigned int s708c2f20:1;
  ::S708C30_nt s708c2f21;
  ::S708C19_nt s708c2f22;
  ::S708C19_nt s708c2f23;
  ::S708C19_nt s708c2f24;
  ::S708C19_nt s708c2f25;
  ::S708C19_nt s708c2f26;
  ::S708C19_nt s708c2f27;
  ::S708C19_nt s708c2f28;
  ::S708C19_nt s708c2f29;
  ::S708C19_nt s708c2f30;
  ::S708C19_nt s708c2f31;
  ::S708C19_nt s708c2f32;
  ::S708C19_nt s708c2f33;
  ::S708C19_nt s708c2f34;
  virtual  ~S708C2_nt(); // _ZN9S708C2_ntD1Ev
  virtual void  v151(); // _ZN9S708C2_nt4v151Ev
  virtual void  v152(); // _ZN9S708C2_nt4v152Ev
  virtual void  v153(); // _ZN9S708C2_nt4v153Ev
  virtual void  v154(); // _ZN9S708C2_nt4v154Ev
  virtual void  v155(); // _ZN9S708C2_nt4v155Ev
  virtual void  v156(); // _ZN9S708C2_nt4v156Ev
  virtual void  v157(); // _ZN9S708C2_nt4v157Ev
  virtual void  v158(); // _ZN9S708C2_nt4v158Ev
  virtual void  v159(); // _ZN9S708C2_nt4v159Ev
  virtual void  v160(); // _ZN9S708C2_nt4v160Ev
  virtual void  v161(); // _ZN9S708C2_nt4v161Ev
  virtual void  v162(); // _ZN9S708C2_nt4v162Ev
  virtual void  v163(); // _ZN9S708C2_nt4v163Ev
  virtual void  v164(); // _ZN9S708C2_nt4v164Ev
  virtual void  v165(); // _ZN9S708C2_nt4v165Ev
  virtual void  v166(); // _ZN9S708C2_nt4v166Ev
  virtual void  v167(); // _ZN9S708C2_nt4v167Ev
  virtual void  v168(); // _ZN9S708C2_nt4v168Ev
  virtual void  v169(); // _ZN9S708C2_nt4v169Ev
  virtual void  v170(); // _ZN9S708C2_nt4v170Ev
  virtual void  v171(); // _ZN9S708C2_nt4v171Ev
  virtual void  v172(); // _ZN9S708C2_nt4v172Ev
  virtual void  v173(); // _ZN9S708C2_nt4v173Ev
  virtual void  v174(); // _ZN9S708C2_nt4v174Ev
  virtual void  v175(); // _ZN9S708C2_nt4v175Ev
  virtual void  v176(); // _ZN9S708C2_nt4v176Ev
  virtual void  v177(); // _ZN9S708C2_nt4v177Ev
  virtual void  v178(); // _ZN9S708C2_nt4v178Ev
  virtual void  v179(); // _ZN9S708C2_nt4v179Ev
  virtual void  v180(); // _ZN9S708C2_nt4v180Ev
  virtual void  v181(); // _ZN9S708C2_nt4v181Ev
  virtual void  v182(); // _ZN9S708C2_nt4v182Ev
  virtual void  v183(); // _ZN9S708C2_nt4v183Ev
  virtual void  v184(); // _ZN9S708C2_nt4v184Ev
  virtual void  v185(); // _ZN9S708C2_nt4v185Ev
  virtual void  v186(); // _ZN9S708C2_nt4v186Ev
  virtual void  v187(); // _ZN9S708C2_nt4v187Ev
  virtual void  v188(); // _ZN9S708C2_nt4v188Ev
  virtual void  v189(); // _ZN9S708C2_nt4v189Ev
  virtual void  v190(); // _ZN9S708C2_nt4v190Ev
  virtual void  v191(); // _ZN9S708C2_nt4v191Ev
  virtual void  v192(); // _ZN9S708C2_nt4v192Ev
  virtual void  v193(); // _ZN9S708C2_nt4v193Ev
  virtual void  v194(); // _ZN9S708C2_nt4v194Ev
  virtual void  v195(); // _ZN9S708C2_nt4v195Ev
  virtual void  v196(); // _ZN9S708C2_nt4v196Ev
  virtual void  v197(); // _ZN9S708C2_nt4v197Ev
  virtual void  v198(); // _ZN9S708C2_nt4v198Ev
  virtual void  v199(); // _ZN9S708C2_nt4v199Ev
  virtual void  v200(); // _ZN9S708C2_nt4v200Ev
  virtual void  v201(); // _ZN9S708C2_nt4v201Ev
  virtual void  v202(); // _ZN9S708C2_nt4v202Ev
  virtual void  v203(); // _ZN9S708C2_nt4v203Ev
  virtual void  v204(); // _ZN9S708C2_nt4v204Ev
  virtual void  v205(); // _ZN9S708C2_nt4v205Ev
  virtual void  v206(); // _ZN9S708C2_nt4v206Ev
  virtual void  v207(); // _ZN9S708C2_nt4v207Ev
  virtual void  v208(); // _ZN9S708C2_nt4v208Ev
  virtual void  v209(); // _ZN9S708C2_nt4v209Ev
  virtual void  v210(); // _ZN9S708C2_nt4v210Ev
  virtual void  v211(); // _ZN9S708C2_nt4v211Ev
  virtual void  v212(); // _ZN9S708C2_nt4v212Ev
  virtual void  v213(); // _ZN9S708C2_nt4v213Ev
  virtual void  v214(); // _ZN9S708C2_nt4v214Ev
  virtual void  v215(); // _ZN9S708C2_nt4v215Ev
  virtual void  v216(); // _ZN9S708C2_nt4v216Ev
  virtual void  v217(); // _ZN9S708C2_nt4v217Ev
  virtual void  v218(); // _ZN9S708C2_nt4v218Ev
  virtual void  v219(); // _ZN9S708C2_nt4v219Ev
  S708C2_nt(); // tgen
};
//SIG(-1 S708C2_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S708C2_nt ::~S708C2_nt(){ note_dtor("S708C2_nt", this);}
void  S708C2_nt ::v151(){vfunc_called(this, "_ZN9S708C2_nt4v151Ev");}
void  S708C2_nt ::v152(){vfunc_called(this, "_ZN9S708C2_nt4v152Ev");}
void  S708C2_nt ::v153(){vfunc_called(this, "_ZN9S708C2_nt4v153Ev");}
void  S708C2_nt ::v154(){vfunc_called(this, "_ZN9S708C2_nt4v154Ev");}
void  S708C2_nt ::v155(){vfunc_called(this, "_ZN9S708C2_nt4v155Ev");}
void  S708C2_nt ::v156(){vfunc_called(this, "_ZN9S708C2_nt4v156Ev");}
void  S708C2_nt ::v157(){vfunc_called(this, "_ZN9S708C2_nt4v157Ev");}
void  S708C2_nt ::v158(){vfunc_called(this, "_ZN9S708C2_nt4v158Ev");}
void  S708C2_nt ::v159(){vfunc_called(this, "_ZN9S708C2_nt4v159Ev");}
void  S708C2_nt ::v160(){vfunc_called(this, "_ZN9S708C2_nt4v160Ev");}
void  S708C2_nt ::v161(){vfunc_called(this, "_ZN9S708C2_nt4v161Ev");}
void  S708C2_nt ::v162(){vfunc_called(this, "_ZN9S708C2_nt4v162Ev");}
void  S708C2_nt ::v163(){vfunc_called(this, "_ZN9S708C2_nt4v163Ev");}
void  S708C2_nt ::v164(){vfunc_called(this, "_ZN9S708C2_nt4v164Ev");}
void  S708C2_nt ::v165(){vfunc_called(this, "_ZN9S708C2_nt4v165Ev");}
void  S708C2_nt ::v166(){vfunc_called(this, "_ZN9S708C2_nt4v166Ev");}
void  S708C2_nt ::v167(){vfunc_called(this, "_ZN9S708C2_nt4v167Ev");}
void  S708C2_nt ::v168(){vfunc_called(this, "_ZN9S708C2_nt4v168Ev");}
void  S708C2_nt ::v169(){vfunc_called(this, "_ZN9S708C2_nt4v169Ev");}
void  S708C2_nt ::v170(){vfunc_called(this, "_ZN9S708C2_nt4v170Ev");}
void  S708C2_nt ::v171(){vfunc_called(this, "_ZN9S708C2_nt4v171Ev");}
void  S708C2_nt ::v172(){vfunc_called(this, "_ZN9S708C2_nt4v172Ev");}
void  S708C2_nt ::v173(){vfunc_called(this, "_ZN9S708C2_nt4v173Ev");}
void  S708C2_nt ::v174(){vfunc_called(this, "_ZN9S708C2_nt4v174Ev");}
void  S708C2_nt ::v175(){vfunc_called(this, "_ZN9S708C2_nt4v175Ev");}
void  S708C2_nt ::v176(){vfunc_called(this, "_ZN9S708C2_nt4v176Ev");}
void  S708C2_nt ::v177(){vfunc_called(this, "_ZN9S708C2_nt4v177Ev");}
void  S708C2_nt ::v178(){vfunc_called(this, "_ZN9S708C2_nt4v178Ev");}
void  S708C2_nt ::v179(){vfunc_called(this, "_ZN9S708C2_nt4v179Ev");}
void  S708C2_nt ::v180(){vfunc_called(this, "_ZN9S708C2_nt4v180Ev");}
void  S708C2_nt ::v181(){vfunc_called(this, "_ZN9S708C2_nt4v181Ev");}
void  S708C2_nt ::v182(){vfunc_called(this, "_ZN9S708C2_nt4v182Ev");}
void  S708C2_nt ::v183(){vfunc_called(this, "_ZN9S708C2_nt4v183Ev");}
void  S708C2_nt ::v184(){vfunc_called(this, "_ZN9S708C2_nt4v184Ev");}
void  S708C2_nt ::v185(){vfunc_called(this, "_ZN9S708C2_nt4v185Ev");}
void  S708C2_nt ::v186(){vfunc_called(this, "_ZN9S708C2_nt4v186Ev");}
void  S708C2_nt ::v187(){vfunc_called(this, "_ZN9S708C2_nt4v187Ev");}
void  S708C2_nt ::v188(){vfunc_called(this, "_ZN9S708C2_nt4v188Ev");}
void  S708C2_nt ::v189(){vfunc_called(this, "_ZN9S708C2_nt4v189Ev");}
void  S708C2_nt ::v190(){vfunc_called(this, "_ZN9S708C2_nt4v190Ev");}
void  S708C2_nt ::v191(){vfunc_called(this, "_ZN9S708C2_nt4v191Ev");}
void  S708C2_nt ::v192(){vfunc_called(this, "_ZN9S708C2_nt4v192Ev");}
void  S708C2_nt ::v193(){vfunc_called(this, "_ZN9S708C2_nt4v193Ev");}
void  S708C2_nt ::v194(){vfunc_called(this, "_ZN9S708C2_nt4v194Ev");}
void  S708C2_nt ::v195(){vfunc_called(this, "_ZN9S708C2_nt4v195Ev");}
void  S708C2_nt ::v196(){vfunc_called(this, "_ZN9S708C2_nt4v196Ev");}
void  S708C2_nt ::v197(){vfunc_called(this, "_ZN9S708C2_nt4v197Ev");}
void  S708C2_nt ::v198(){vfunc_called(this, "_ZN9S708C2_nt4v198Ev");}
void  S708C2_nt ::v199(){vfunc_called(this, "_ZN9S708C2_nt4v199Ev");}
void  S708C2_nt ::v200(){vfunc_called(this, "_ZN9S708C2_nt4v200Ev");}
void  S708C2_nt ::v201(){vfunc_called(this, "_ZN9S708C2_nt4v201Ev");}
void  S708C2_nt ::v202(){vfunc_called(this, "_ZN9S708C2_nt4v202Ev");}
void  S708C2_nt ::v203(){vfunc_called(this, "_ZN9S708C2_nt4v203Ev");}
void  S708C2_nt ::v204(){vfunc_called(this, "_ZN9S708C2_nt4v204Ev");}
void  S708C2_nt ::v205(){vfunc_called(this, "_ZN9S708C2_nt4v205Ev");}
void  S708C2_nt ::v206(){vfunc_called(this, "_ZN9S708C2_nt4v206Ev");}
void  S708C2_nt ::v207(){vfunc_called(this, "_ZN9S708C2_nt4v207Ev");}
void  S708C2_nt ::v208(){vfunc_called(this, "_ZN9S708C2_nt4v208Ev");}
void  S708C2_nt ::v209(){vfunc_called(this, "_ZN9S708C2_nt4v209Ev");}
void  S708C2_nt ::v210(){vfunc_called(this, "_ZN9S708C2_nt4v210Ev");}
void  S708C2_nt ::v211(){vfunc_called(this, "_ZN9S708C2_nt4v211Ev");}
void  S708C2_nt ::v212(){vfunc_called(this, "_ZN9S708C2_nt4v212Ev");}
void  S708C2_nt ::v213(){vfunc_called(this, "_ZN9S708C2_nt4v213Ev");}
void  S708C2_nt ::v214(){vfunc_called(this, "_ZN9S708C2_nt4v214Ev");}
void  S708C2_nt ::v215(){vfunc_called(this, "_ZN9S708C2_nt4v215Ev");}
void  S708C2_nt ::v216(){vfunc_called(this, "_ZN9S708C2_nt4v216Ev");}
void  S708C2_nt ::v217(){vfunc_called(this, "_ZN9S708C2_nt4v217Ev");}
void  S708C2_nt ::v218(){vfunc_called(this, "_ZN9S708C2_nt4v218Ev");}
void  S708C2_nt ::v219(){vfunc_called(this, "_ZN9S708C2_nt4v219Ev");}
S708C2_nt ::S708C2_nt(){ note_ctor("S708C2_nt", this);} // tgen

//skip512 S708C2_nt

#else // __cplusplus

extern void _ZN9S708C2_ntC1Ev();
extern void _ZN9S708C2_ntD1Ev();
Name_Map name_map_S708C2_nt[] = {
  NSPAIR(_ZN9S708C2_ntC1Ev),
  NSPAIR(_ZN9S708C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S708C5_nt;
extern VTBL_ENTRY _ZTI9S708C5_nt[];
extern  VTBL_ENTRY _ZTV9S708C5_nt[];
extern Class_Descriptor cd_S708C4_nt;
extern VTBL_ENTRY _ZTI9S708C4_nt[];
extern  VTBL_ENTRY _ZTV9S708C4_nt[];
extern Class_Descriptor cd_S708C3_nt;
extern VTBL_ENTRY _ZTI9S708C3_nt[];
extern  VTBL_ENTRY _ZTV9S708C3_nt[];
static Base_Class bases_S708C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S708C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S708C2_nt[];
extern void _ZN9S708C2_ntD1Ev();
extern void _ZN9S708C2_ntD0Ev();
extern void _ZN9S708C5_nt2v9Ev();
extern void _ZN9S708C5_nt3v10Ev();
extern void _ZN9S708C5_nt3v11Ev();
extern void _ZN9S708C5_nt3v12Ev();
extern void _ZN9S708C5_nt3v13Ev();
extern void _ZN9S708C5_nt3v14Ev();
extern void _ZN9S708C5_nt3v15Ev();
extern void _ZN9S708C5_nt3v16Ev();
extern void _ZN9S708C5_nt3v17Ev();
extern void _ZN9S708C5_nt3v18Ev();
extern void _ZN9S708C5_nt3v19Ev();
extern void _ZN9S708C5_nt3v20Ev();
extern void _ZN9S708C5_nt3v21Ev();
extern void _ZN9S708C5_nt3v22Ev();
extern void _ZN9S708C5_nt3v23Ev();
extern void _ZN9S708C5_nt3v24Ev();
extern void _ZN9S708C5_nt3v25Ev();
extern void _ZN9S708C5_nt3v26Ev();
extern void _ZN9S708C5_nt3v27Ev();
extern void _ZN9S708C5_nt3v28Ev();
extern void _ZN9S708C5_nt3v29Ev();
extern void _ZN9S708C5_nt3v30Ev();
extern void _ZN9S708C5_nt3v31Ev();
extern void _ZN9S708C5_nt3v32Ev();
extern void _ZN9S708C5_nt3v33Ev();
extern void _ZN9S708C5_nt3v34Ev();
extern void _ZN9S708C5_nt3v35Ev();
extern void _ZN9S708C5_nt3v36Ev();
extern void _ZN9S708C5_nt3v37Ev();
extern void _ZN9S708C5_nt3v38Ev();
extern void _ZN9S708C5_nt3v39Ev();
extern void _ZN9S708C5_nt3v40Ev();
extern void _ZN9S708C5_nt3v41Ev();
extern void _ZN9S708C5_nt3v42Ev();
extern void _ZN9S708C5_nt3v43Ev();
extern void _ZN9S708C5_nt3v44Ev();
extern void _ZN9S708C5_nt3v45Ev();
extern void _ZN9S708C5_nt3v46Ev();
extern void _ZN9S708C5_nt3v47Ev();
extern void _ZN9S708C5_nt3v48Ev();
extern void _ZN9S708C5_nt3v49Ev();
extern void _ZN9S708C5_nt3v50Ev();
extern void _ZN9S708C5_nt3v51Ev();
extern void _ZN9S708C5_nt3v52Ev();
extern void _ZN9S708C5_nt3v53Ev();
extern void _ZN9S708C5_nt3v54Ev();
extern void _ZN9S708C5_nt3v55Ev();
extern void _ZN9S708C5_nt3v56Ev();
extern void _ZN9S708C5_nt3v57Ev();
extern void _ZN9S708C5_nt3v58Ev();
extern void _ZN9S708C5_nt3v59Ev();
extern void _ZN9S708C5_nt3v60Ev();
extern void _ZN9S708C5_nt3v61Ev();
extern void _ZN9S708C5_nt3v62Ev();
extern void _ZN9S708C5_nt3v63Ev();
extern void _ZN9S708C5_nt3v64Ev();
extern void _ZN9S708C5_nt3v65Ev();
extern void _ZN9S708C5_nt3v66Ev();
extern void _ZN9S708C5_nt3v67Ev();
extern void _ZN9S708C5_nt3v68Ev();
extern void _ZN9S708C5_nt3v69Ev();
extern void _ZN9S708C5_nt3v70Ev();
extern void _ZN9S708C5_nt3v71Ev();
extern void _ZN9S708C5_nt3v72Ev();
extern void _ZN9S708C4_nt3v73Ev();
extern void _ZN9S708C4_nt3v74Ev();
extern void _ZN9S708C3_nt3v75Ev();
extern void _ZN9S708C3_nt3v76Ev();
extern void _ZN9S708C3_nt3v77Ev();
extern void _ZN9S708C3_nt3v78Ev();
extern void _ZN9S708C3_nt3v79Ev();
extern void _ZN9S708C3_nt3v80Ev();
extern void _ZN9S708C3_nt3v81Ev();
extern void _ZN9S708C3_nt3v82Ev();
extern void _ZN9S708C3_nt3v83Ev();
extern void _ZN9S708C3_nt3v84Ev();
extern void _ZN9S708C3_nt3v85Ev();
extern void _ZN9S708C3_nt3v86Ev();
extern void _ZN9S708C3_nt3v87Ev();
extern void _ZN9S708C3_nt3v88Ev();
extern void _ZN9S708C3_nt3v89Ev();
extern void _ZN9S708C3_nt3v90Ev();
extern void _ZN9S708C3_nt3v91Ev();
extern void _ZN9S708C3_nt3v92Ev();
extern void _ZN9S708C3_nt3v93Ev();
extern void _ZN9S708C3_nt3v94Ev();
extern void _ZN9S708C3_nt3v95Ev();
extern void _ZN9S708C3_nt3v96Ev();
extern void _ZN9S708C3_nt3v97Ev();
extern void _ZN9S708C3_nt3v98Ev();
extern void _ZN9S708C3_nt3v99Ev();
extern void _ZN9S708C3_nt4v100Ev();
extern void _ZN9S708C3_nt4v101Ev();
extern void _ZN9S708C3_nt4v102Ev();
extern void _ZN9S708C3_nt4v103Ev();
extern void _ZN9S708C3_nt4v104Ev();
extern void _ZN9S708C3_nt4v105Ev();
extern void _ZN9S708C3_nt4v106Ev();
extern void _ZN9S708C3_nt4v107Ev();
extern void _ZN9S708C3_nt4v108Ev();
extern void _ZN9S708C3_nt4v109Ev();
extern void _ZN9S708C3_nt4v110Ev();
extern void _ZN9S708C3_nt4v111Ev();
extern void _ZN9S708C3_nt4v112Ev();
extern void _ZN9S708C3_nt4v113Ev();
extern void _ZN9S708C3_nt4v114Ev();
extern void _ZN9S708C3_nt4v115Ev();
extern void _ZN9S708C3_nt4v116Ev();
extern void _ZN9S708C3_nt4v117Ev();
extern void _ZN9S708C3_nt4v118Ev();
extern void _ZN9S708C3_nt4v119Ev();
extern void _ZN9S708C3_nt4v120Ev();
extern void _ZN9S708C3_nt4v121Ev();
extern void _ZN9S708C3_nt4v122Ev();
extern void _ZN9S708C3_nt4v123Ev();
extern void _ZN9S708C3_nt4v124Ev();
extern void _ZN9S708C3_nt4v125Ev();
extern void _ZN9S708C3_nt4v126Ev();
extern void _ZN9S708C3_nt4v127Ev();
extern void _ZN9S708C3_nt4v128Ev();
extern void _ZN9S708C3_nt4v129Ev();
extern void _ZN9S708C3_nt4v130Ev();
extern void _ZN9S708C3_nt4v131Ev();
extern void _ZN9S708C3_nt4v132Ev();
extern void _ZN9S708C3_nt4v133Ev();
extern void _ZN9S708C3_nt4v134Ev();
extern void _ZN9S708C3_nt4v135Ev();
extern void _ZN9S708C3_nt4v136Ev();
extern void _ZN9S708C3_nt4v137Ev();
extern void _ZN9S708C3_nt4v138Ev();
extern void _ZN9S708C3_nt4v139Ev();
extern void _ZN9S708C3_nt4v140Ev();
extern void _ZN9S708C3_nt4v141Ev();
extern void _ZN9S708C3_nt4v142Ev();
extern void _ZN9S708C3_nt4v143Ev();
extern void _ZN9S708C3_nt4v144Ev();
extern void _ZN9S708C3_nt4v145Ev();
extern void _ZN9S708C3_nt4v146Ev();
extern void _ZN9S708C3_nt4v147Ev();
extern void _ZN9S708C3_nt4v148Ev();
extern void _ZN9S708C3_nt4v149Ev();
extern void _ZN9S708C3_nt4v150Ev();
extern void _ZN9S708C2_nt4v151Ev();
extern void _ZN9S708C2_nt4v152Ev();
extern void _ZN9S708C2_nt4v153Ev();
extern void _ZN9S708C2_nt4v154Ev();
extern void _ZN9S708C2_nt4v155Ev();
extern void _ZN9S708C2_nt4v156Ev();
extern void _ZN9S708C2_nt4v157Ev();
extern void _ZN9S708C2_nt4v158Ev();
extern void _ZN9S708C2_nt4v159Ev();
extern void _ZN9S708C2_nt4v160Ev();
extern void _ZN9S708C2_nt4v161Ev();
extern void _ZN9S708C2_nt4v162Ev();
extern void _ZN9S708C2_nt4v163Ev();
extern void _ZN9S708C2_nt4v164Ev();
extern void _ZN9S708C2_nt4v165Ev();
extern void _ZN9S708C2_nt4v166Ev();
extern void _ZN9S708C2_nt4v167Ev();
extern void _ZN9S708C2_nt4v168Ev();
extern void _ZN9S708C2_nt4v169Ev();
extern void _ZN9S708C2_nt4v170Ev();
extern void _ZN9S708C2_nt4v171Ev();
extern void _ZN9S708C2_nt4v172Ev();
extern void _ZN9S708C2_nt4v173Ev();
extern void _ZN9S708C2_nt4v174Ev();
extern void _ZN9S708C2_nt4v175Ev();
extern void _ZN9S708C2_nt4v176Ev();
extern void _ZN9S708C2_nt4v177Ev();
extern void _ZN9S708C2_nt4v178Ev();
extern void _ZN9S708C2_nt4v179Ev();
extern void _ZN9S708C2_nt4v180Ev();
extern void _ZN9S708C2_nt4v181Ev();
extern void _ZN9S708C2_nt4v182Ev();
extern void _ZN9S708C2_nt4v183Ev();
extern void _ZN9S708C2_nt4v184Ev();
extern void _ZN9S708C2_nt4v185Ev();
extern void _ZN9S708C2_nt4v186Ev();
extern void _ZN9S708C2_nt4v187Ev();
extern void _ZN9S708C2_nt4v188Ev();
extern void _ZN9S708C2_nt4v189Ev();
extern void _ZN9S708C2_nt4v190Ev();
extern void _ZN9S708C2_nt4v191Ev();
extern void _ZN9S708C2_nt4v192Ev();
extern void _ZN9S708C2_nt4v193Ev();
extern void _ZN9S708C2_nt4v194Ev();
extern void _ZN9S708C2_nt4v195Ev();
extern void _ZN9S708C2_nt4v196Ev();
extern void _ZN9S708C2_nt4v197Ev();
extern void _ZN9S708C2_nt4v198Ev();
extern void _ZN9S708C2_nt4v199Ev();
extern void _ZN9S708C2_nt4v200Ev();
extern void _ZN9S708C2_nt4v201Ev();
extern void _ZN9S708C2_nt4v202Ev();
extern void _ZN9S708C2_nt4v203Ev();
extern void _ZN9S708C2_nt4v204Ev();
extern void _ZN9S708C2_nt4v205Ev();
extern void _ZN9S708C2_nt4v206Ev();
extern void _ZN9S708C2_nt4v207Ev();
extern void _ZN9S708C2_nt4v208Ev();
extern void _ZN9S708C2_nt4v209Ev();
extern void _ZN9S708C2_nt4v210Ev();
extern void _ZN9S708C2_nt4v211Ev();
extern void _ZN9S708C2_nt4v212Ev();
extern void _ZN9S708C2_nt4v213Ev();
extern void _ZN9S708C2_nt4v214Ev();
extern void _ZN9S708C2_nt4v215Ev();
extern void _ZN9S708C2_nt4v216Ev();
extern void _ZN9S708C2_nt4v217Ev();
extern void _ZN9S708C2_nt4v218Ev();
extern void _ZN9S708C2_nt4v219Ev();
static  VTBL_ENTRY vtc_S708C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S708C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S708C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S708C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v219Ev,
};
extern VTBL_ENTRY _ZTI9S708C2_nt[];
VTBL_ENTRY *P__ZTI9S708C2_nt = _ZTI9S708C2_nt; 
extern  VTBL_ENTRY _ZTV9S708C2_nt[];
Class_Descriptor cd_S708C2_nt = {  "S708C2_nt", // class name
  bases_S708C2_nt, 3,
  &(vtc_S708C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S708C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S708C2_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C47  : S708C10_nt {
};
//SIG(-1 S708C47) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C47()
{
  extern Class_Descriptor cd_S708C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C47, buf);
    S708C47 &lv = *(new (buf) S708C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C47)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C47");
    test_class_info(&lv, &cd_S708C47);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C47(Test_S708C47, "S708C47", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C47 = {  "S708C47", // class name
  bases_S708C47, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C46_nt  {
  ::S708C47 s708c46f0;
  void *s708c46f1;
  int s708c46f2;
  void  mf708c46(); // _ZN10S708C46_nt8mf708c46Ev
};
//SIG(-1 S708C46_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S708C46_nt ::mf708c46(){}

//skip512 S708C46_nt

#else // __cplusplus

Class_Descriptor cd_S708C46_nt = {  "S708C46_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C45_nt  : S708C46_nt {
};
//SIG(-1 S708C45_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S708C45_nt

#else // __cplusplus

extern Class_Descriptor cd_S708C46_nt;
static Base_Class bases_S708C45_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C46_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C51  : S708C10_nt {
};
//SIG(-1 S708C51) C1{ BC2{ m Fp Fi[2]}}



static void Test_S708C51()
{
  extern Class_Descriptor cd_S708C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C51, buf);
    S708C51 &lv = *(new (buf) S708C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C51)");
    check_base_class_offset(lv, (S708C10_nt*), 0, "S708C51");
    test_class_info(&lv, &cd_S708C51);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C51(Test_S708C51, "S708C51", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
static Base_Class bases_S708C51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C51 = {  "S708C51", // class name
  bases_S708C51, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C50  : S708C51 {
};
//SIG(-1 S708C50) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S708C50()
{
  extern Class_Descriptor cd_S708C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S708C50, buf);
    S708C50 &lv = *(new (buf) S708C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S708C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C50)");
    check_base_class_offset(lv, (S708C10_nt*)(S708C51*), 0, "S708C50");
    check_base_class_offset(lv, (S708C51*), 0, "S708C50");
    test_class_info(&lv, &cd_S708C50);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C50(Test_S708C50, "S708C50", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S708C10_nt;
extern Class_Descriptor cd_S708C51;
static Base_Class bases_S708C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C51,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S708C50 = {  "S708C50", // class name
  bases_S708C50, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S708C1  : S708C2_nt {
  void *s708c1f0;
  int s708c1f1;
  ::S708C45_nt s708c1f2;
  int s708c1f3[3];
  ::S708C42 s708c1f4;
  ::S708C50 s708c1f5;
  ::S708C50 s708c1f6;
  ::S708C50 s708c1f7;
  ::S708C45_nt s708c1f8;
  virtual  ~S708C1(); // _ZN6S708C1D1Ev
  virtual void  v1(); // _ZN6S708C12v1Ev
  virtual void  v2(); // _ZN6S708C12v2Ev
  virtual void  v3(); // _ZN6S708C12v3Ev
  virtual void  v4(); // _ZN6S708C12v4Ev
  virtual void  v5(); // _ZN6S708C12v5Ev
  virtual void  v6(); // _ZN6S708C12v6Ev
  virtual void  v7(); // _ZN6S708C12v7Ev
  virtual void  v8(); // _ZN6S708C12v8Ev
  S708C1(); // tgen
};
//SIG(1 S708C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp Fi FC35{ BC36{ m FC37{ BC10} Fp Fi}} Fi[3] FC33 FC38{ BC39{ BC10}} FC38 FC38 FC35}


 S708C1 ::~S708C1(){ note_dtor("S708C1", this);}
void  S708C1 ::v1(){vfunc_called(this, "_ZN6S708C12v1Ev");}
void  S708C1 ::v2(){vfunc_called(this, "_ZN6S708C12v2Ev");}
void  S708C1 ::v3(){vfunc_called(this, "_ZN6S708C12v3Ev");}
void  S708C1 ::v4(){vfunc_called(this, "_ZN6S708C12v4Ev");}
void  S708C1 ::v5(){vfunc_called(this, "_ZN6S708C12v5Ev");}
void  S708C1 ::v6(){vfunc_called(this, "_ZN6S708C12v6Ev");}
void  S708C1 ::v7(){vfunc_called(this, "_ZN6S708C12v7Ev");}
void  S708C1 ::v8(){vfunc_called(this, "_ZN6S708C12v8Ev");}
S708C1 ::S708C1(){ note_ctor("S708C1", this);} // tgen

static void Test_S708C1()
{
  extern Class_Descriptor cd_S708C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(174,255)];
    init_test(&cd_S708C1, buf);
    S708C1 *dp, &lv = *(dp=new (buf) S708C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1384,1016), "sizeof(S708C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S708C1)");
    check_base_class_offset(lv, (S708C5_nt*)(S708C4_nt*)(S708C3_nt*)(S708C2_nt*), 0, "S708C1");
    check_base_class_offset(lv, (S708C4_nt*)(S708C3_nt*)(S708C2_nt*), 0, "S708C1");
    check_base_class_offset(lv, (S708C3_nt*)(S708C2_nt*), 0, "S708C1");
    check_base_class_offset(lv, (S708C2_nt*), 0, "S708C1");
    check_field_offset(lv, s708c1f0, ABISELECT(1224,908), "S708C1.s708c1f0");
    check_field_offset(lv, s708c1f1, ABISELECT(1232,912), "S708C1.s708c1f1");
    check_field_offset(lv, s708c1f2, ABISELECT(1240,916), "S708C1.s708c1f2");
    check_field_offset(lv, s708c1f3, ABISELECT(1272,936), "S708C1.s708c1f3");
    check_field_offset(lv, s708c1f4, ABISELECT(1288,948), "S708C1.s708c1f4");
    check_field_offset(lv, s708c1f5, ABISELECT(1304,960), "S708C1.s708c1f5");
    check_field_offset(lv, s708c1f6, ABISELECT(1320,972), "S708C1.s708c1f6");
    check_field_offset(lv, s708c1f7, ABISELECT(1336,984), "S708C1.s708c1f7");
    check_field_offset(lv, s708c1f8, ABISELECT(1352,996), "S708C1.s708c1f8");
    test_class_info(&lv, &cd_S708C1);
    dp->~S708C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS708C1(Test_S708C1, "S708C1", ABISELECT(1384,1016));

#else // __cplusplus

extern void _ZN6S708C1C1Ev();
extern void _ZN6S708C1D1Ev();
Name_Map name_map_S708C1[] = {
  NSPAIR(_ZN6S708C1C1Ev),
  NSPAIR(_ZN6S708C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S708C5_nt;
extern VTBL_ENTRY _ZTI9S708C5_nt[];
extern  VTBL_ENTRY _ZTV9S708C5_nt[];
extern Class_Descriptor cd_S708C4_nt;
extern VTBL_ENTRY _ZTI9S708C4_nt[];
extern  VTBL_ENTRY _ZTV9S708C4_nt[];
extern Class_Descriptor cd_S708C3_nt;
extern VTBL_ENTRY _ZTI9S708C3_nt[];
extern  VTBL_ENTRY _ZTV9S708C3_nt[];
extern Class_Descriptor cd_S708C2_nt;
extern VTBL_ENTRY _ZTI9S708C2_nt[];
extern  VTBL_ENTRY _ZTV9S708C2_nt[];
static Base_Class bases_S708C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S708C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S708C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S708C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S708C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S708C1[];
extern void _ZN6S708C1D1Ev();
extern void _ZN6S708C1D0Ev();
extern void _ZN9S708C5_nt2v9Ev();
extern void _ZN9S708C5_nt3v10Ev();
extern void _ZN9S708C5_nt3v11Ev();
extern void _ZN9S708C5_nt3v12Ev();
extern void _ZN9S708C5_nt3v13Ev();
extern void _ZN9S708C5_nt3v14Ev();
extern void _ZN9S708C5_nt3v15Ev();
extern void _ZN9S708C5_nt3v16Ev();
extern void _ZN9S708C5_nt3v17Ev();
extern void _ZN9S708C5_nt3v18Ev();
extern void _ZN9S708C5_nt3v19Ev();
extern void _ZN9S708C5_nt3v20Ev();
extern void _ZN9S708C5_nt3v21Ev();
extern void _ZN9S708C5_nt3v22Ev();
extern void _ZN9S708C5_nt3v23Ev();
extern void _ZN9S708C5_nt3v24Ev();
extern void _ZN9S708C5_nt3v25Ev();
extern void _ZN9S708C5_nt3v26Ev();
extern void _ZN9S708C5_nt3v27Ev();
extern void _ZN9S708C5_nt3v28Ev();
extern void _ZN9S708C5_nt3v29Ev();
extern void _ZN9S708C5_nt3v30Ev();
extern void _ZN9S708C5_nt3v31Ev();
extern void _ZN9S708C5_nt3v32Ev();
extern void _ZN9S708C5_nt3v33Ev();
extern void _ZN9S708C5_nt3v34Ev();
extern void _ZN9S708C5_nt3v35Ev();
extern void _ZN9S708C5_nt3v36Ev();
extern void _ZN9S708C5_nt3v37Ev();
extern void _ZN9S708C5_nt3v38Ev();
extern void _ZN9S708C5_nt3v39Ev();
extern void _ZN9S708C5_nt3v40Ev();
extern void _ZN9S708C5_nt3v41Ev();
extern void _ZN9S708C5_nt3v42Ev();
extern void _ZN9S708C5_nt3v43Ev();
extern void _ZN9S708C5_nt3v44Ev();
extern void _ZN9S708C5_nt3v45Ev();
extern void _ZN9S708C5_nt3v46Ev();
extern void _ZN9S708C5_nt3v47Ev();
extern void _ZN9S708C5_nt3v48Ev();
extern void _ZN9S708C5_nt3v49Ev();
extern void _ZN9S708C5_nt3v50Ev();
extern void _ZN9S708C5_nt3v51Ev();
extern void _ZN9S708C5_nt3v52Ev();
extern void _ZN9S708C5_nt3v53Ev();
extern void _ZN9S708C5_nt3v54Ev();
extern void _ZN9S708C5_nt3v55Ev();
extern void _ZN9S708C5_nt3v56Ev();
extern void _ZN9S708C5_nt3v57Ev();
extern void _ZN9S708C5_nt3v58Ev();
extern void _ZN9S708C5_nt3v59Ev();
extern void _ZN9S708C5_nt3v60Ev();
extern void _ZN9S708C5_nt3v61Ev();
extern void _ZN9S708C5_nt3v62Ev();
extern void _ZN9S708C5_nt3v63Ev();
extern void _ZN9S708C5_nt3v64Ev();
extern void _ZN9S708C5_nt3v65Ev();
extern void _ZN9S708C5_nt3v66Ev();
extern void _ZN9S708C5_nt3v67Ev();
extern void _ZN9S708C5_nt3v68Ev();
extern void _ZN9S708C5_nt3v69Ev();
extern void _ZN9S708C5_nt3v70Ev();
extern void _ZN9S708C5_nt3v71Ev();
extern void _ZN9S708C5_nt3v72Ev();
extern void _ZN9S708C4_nt3v73Ev();
extern void _ZN9S708C4_nt3v74Ev();
extern void _ZN9S708C3_nt3v75Ev();
extern void _ZN9S708C3_nt3v76Ev();
extern void _ZN9S708C3_nt3v77Ev();
extern void _ZN9S708C3_nt3v78Ev();
extern void _ZN9S708C3_nt3v79Ev();
extern void _ZN9S708C3_nt3v80Ev();
extern void _ZN9S708C3_nt3v81Ev();
extern void _ZN9S708C3_nt3v82Ev();
extern void _ZN9S708C3_nt3v83Ev();
extern void _ZN9S708C3_nt3v84Ev();
extern void _ZN9S708C3_nt3v85Ev();
extern void _ZN9S708C3_nt3v86Ev();
extern void _ZN9S708C3_nt3v87Ev();
extern void _ZN9S708C3_nt3v88Ev();
extern void _ZN9S708C3_nt3v89Ev();
extern void _ZN9S708C3_nt3v90Ev();
extern void _ZN9S708C3_nt3v91Ev();
extern void _ZN9S708C3_nt3v92Ev();
extern void _ZN9S708C3_nt3v93Ev();
extern void _ZN9S708C3_nt3v94Ev();
extern void _ZN9S708C3_nt3v95Ev();
extern void _ZN9S708C3_nt3v96Ev();
extern void _ZN9S708C3_nt3v97Ev();
extern void _ZN9S708C3_nt3v98Ev();
extern void _ZN9S708C3_nt3v99Ev();
extern void _ZN9S708C3_nt4v100Ev();
extern void _ZN9S708C3_nt4v101Ev();
extern void _ZN9S708C3_nt4v102Ev();
extern void _ZN9S708C3_nt4v103Ev();
extern void _ZN9S708C3_nt4v104Ev();
extern void _ZN9S708C3_nt4v105Ev();
extern void _ZN9S708C3_nt4v106Ev();
extern void _ZN9S708C3_nt4v107Ev();
extern void _ZN9S708C3_nt4v108Ev();
extern void _ZN9S708C3_nt4v109Ev();
extern void _ZN9S708C3_nt4v110Ev();
extern void _ZN9S708C3_nt4v111Ev();
extern void _ZN9S708C3_nt4v112Ev();
extern void _ZN9S708C3_nt4v113Ev();
extern void _ZN9S708C3_nt4v114Ev();
extern void _ZN9S708C3_nt4v115Ev();
extern void _ZN9S708C3_nt4v116Ev();
extern void _ZN9S708C3_nt4v117Ev();
extern void _ZN9S708C3_nt4v118Ev();
extern void _ZN9S708C3_nt4v119Ev();
extern void _ZN9S708C3_nt4v120Ev();
extern void _ZN9S708C3_nt4v121Ev();
extern void _ZN9S708C3_nt4v122Ev();
extern void _ZN9S708C3_nt4v123Ev();
extern void _ZN9S708C3_nt4v124Ev();
extern void _ZN9S708C3_nt4v125Ev();
extern void _ZN9S708C3_nt4v126Ev();
extern void _ZN9S708C3_nt4v127Ev();
extern void _ZN9S708C3_nt4v128Ev();
extern void _ZN9S708C3_nt4v129Ev();
extern void _ZN9S708C3_nt4v130Ev();
extern void _ZN9S708C3_nt4v131Ev();
extern void _ZN9S708C3_nt4v132Ev();
extern void _ZN9S708C3_nt4v133Ev();
extern void _ZN9S708C3_nt4v134Ev();
extern void _ZN9S708C3_nt4v135Ev();
extern void _ZN9S708C3_nt4v136Ev();
extern void _ZN9S708C3_nt4v137Ev();
extern void _ZN9S708C3_nt4v138Ev();
extern void _ZN9S708C3_nt4v139Ev();
extern void _ZN9S708C3_nt4v140Ev();
extern void _ZN9S708C3_nt4v141Ev();
extern void _ZN9S708C3_nt4v142Ev();
extern void _ZN9S708C3_nt4v143Ev();
extern void _ZN9S708C3_nt4v144Ev();
extern void _ZN9S708C3_nt4v145Ev();
extern void _ZN9S708C3_nt4v146Ev();
extern void _ZN9S708C3_nt4v147Ev();
extern void _ZN9S708C3_nt4v148Ev();
extern void _ZN9S708C3_nt4v149Ev();
extern void _ZN9S708C3_nt4v150Ev();
extern void _ZN9S708C2_nt4v151Ev();
extern void _ZN9S708C2_nt4v152Ev();
extern void _ZN9S708C2_nt4v153Ev();
extern void _ZN9S708C2_nt4v154Ev();
extern void _ZN9S708C2_nt4v155Ev();
extern void _ZN9S708C2_nt4v156Ev();
extern void _ZN9S708C2_nt4v157Ev();
extern void _ZN9S708C2_nt4v158Ev();
extern void _ZN9S708C2_nt4v159Ev();
extern void _ZN9S708C2_nt4v160Ev();
extern void _ZN9S708C2_nt4v161Ev();
extern void _ZN9S708C2_nt4v162Ev();
extern void _ZN9S708C2_nt4v163Ev();
extern void _ZN9S708C2_nt4v164Ev();
extern void _ZN9S708C2_nt4v165Ev();
extern void _ZN9S708C2_nt4v166Ev();
extern void _ZN9S708C2_nt4v167Ev();
extern void _ZN9S708C2_nt4v168Ev();
extern void _ZN9S708C2_nt4v169Ev();
extern void _ZN9S708C2_nt4v170Ev();
extern void _ZN9S708C2_nt4v171Ev();
extern void _ZN9S708C2_nt4v172Ev();
extern void _ZN9S708C2_nt4v173Ev();
extern void _ZN9S708C2_nt4v174Ev();
extern void _ZN9S708C2_nt4v175Ev();
extern void _ZN9S708C2_nt4v176Ev();
extern void _ZN9S708C2_nt4v177Ev();
extern void _ZN9S708C2_nt4v178Ev();
extern void _ZN9S708C2_nt4v179Ev();
extern void _ZN9S708C2_nt4v180Ev();
extern void _ZN9S708C2_nt4v181Ev();
extern void _ZN9S708C2_nt4v182Ev();
extern void _ZN9S708C2_nt4v183Ev();
extern void _ZN9S708C2_nt4v184Ev();
extern void _ZN9S708C2_nt4v185Ev();
extern void _ZN9S708C2_nt4v186Ev();
extern void _ZN9S708C2_nt4v187Ev();
extern void _ZN9S708C2_nt4v188Ev();
extern void _ZN9S708C2_nt4v189Ev();
extern void _ZN9S708C2_nt4v190Ev();
extern void _ZN9S708C2_nt4v191Ev();
extern void _ZN9S708C2_nt4v192Ev();
extern void _ZN9S708C2_nt4v193Ev();
extern void _ZN9S708C2_nt4v194Ev();
extern void _ZN9S708C2_nt4v195Ev();
extern void _ZN9S708C2_nt4v196Ev();
extern void _ZN9S708C2_nt4v197Ev();
extern void _ZN9S708C2_nt4v198Ev();
extern void _ZN9S708C2_nt4v199Ev();
extern void _ZN9S708C2_nt4v200Ev();
extern void _ZN9S708C2_nt4v201Ev();
extern void _ZN9S708C2_nt4v202Ev();
extern void _ZN9S708C2_nt4v203Ev();
extern void _ZN9S708C2_nt4v204Ev();
extern void _ZN9S708C2_nt4v205Ev();
extern void _ZN9S708C2_nt4v206Ev();
extern void _ZN9S708C2_nt4v207Ev();
extern void _ZN9S708C2_nt4v208Ev();
extern void _ZN9S708C2_nt4v209Ev();
extern void _ZN9S708C2_nt4v210Ev();
extern void _ZN9S708C2_nt4v211Ev();
extern void _ZN9S708C2_nt4v212Ev();
extern void _ZN9S708C2_nt4v213Ev();
extern void _ZN9S708C2_nt4v214Ev();
extern void _ZN9S708C2_nt4v215Ev();
extern void _ZN9S708C2_nt4v216Ev();
extern void _ZN9S708C2_nt4v217Ev();
extern void _ZN9S708C2_nt4v218Ev();
extern void _ZN9S708C2_nt4v219Ev();
extern void _ZN6S708C12v1Ev();
extern void _ZN6S708C12v2Ev();
extern void _ZN6S708C12v3Ev();
extern void _ZN6S708C12v4Ev();
extern void _ZN6S708C12v5Ev();
extern void _ZN6S708C12v6Ev();
extern void _ZN6S708C12v7Ev();
extern void _ZN6S708C12v8Ev();
static  VTBL_ENTRY vtc_S708C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S708C1[0]),
  (VTBL_ENTRY)&_ZN6S708C1D1Ev,
  (VTBL_ENTRY)&_ZN6S708C1D0Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S708C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S708C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S708C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S708C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN6S708C12v1Ev,
  (VTBL_ENTRY)&_ZN6S708C12v2Ev,
  (VTBL_ENTRY)&_ZN6S708C12v3Ev,
  (VTBL_ENTRY)&_ZN6S708C12v4Ev,
  (VTBL_ENTRY)&_ZN6S708C12v5Ev,
  (VTBL_ENTRY)&_ZN6S708C12v6Ev,
  (VTBL_ENTRY)&_ZN6S708C12v7Ev,
  (VTBL_ENTRY)&_ZN6S708C12v8Ev,
};
extern VTBL_ENTRY _ZTI6S708C1[];
extern  VTBL_ENTRY _ZTV6S708C1[];
Class_Descriptor cd_S708C1 = {  "S708C1", // class name
  bases_S708C1, 4,
  &(vtc_S708C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1384,1016), // object size
  NSPAIRA(_ZTI6S708C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S708C1),223, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C8_nt  {
  void  mf2123c8(); // _ZN10S2123C8_nt8mf2123c8Ev
};
//SIG(-1 S2123C8_nt) C1{ m}


void  S2123C8_nt ::mf2123c8(){}

//skip512 S2123C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S2123C8_nt[];
VTBL_ENTRY *P__ZTI10S2123C8_nt = _ZTI10S2123C8_nt; 
Class_Descriptor cd_S2123C8_nt = {  "S2123C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S2123C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C6_nt  {
  void *s2123c6f0;
  int s2123c6f1;
  ::S708C30_nt s2123c6f2;
  ::S2123C8_nt s2123c6f3;
  void  mf2123c6(); // _ZN10S2123C6_nt8mf2123c6Ev
};
//SIG(-1 S2123C6_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2123C6_nt ::mf2123c6(){}

//skip512 S2123C6_nt

#else // __cplusplus

Class_Descriptor cd_S2123C6_nt = {  "S2123C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C5_nt  : S2123C6_nt {
};
//SIG(-1 S2123C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S2123C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2123C6_nt;
static Base_Class bases_S2123C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2123C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C4_nt  {
  void *s2123c4f0;
  int s2123c4f1;
  ::S2123C5_nt s2123c4f2;
  ::S2123C5_nt s2123c4f3;
  int s2123c4f4;
  virtual  ~S2123C4_nt(); // _ZN10S2123C4_ntD1Ev
  virtual void  v2(); // _ZN10S2123C4_nt2v2Ev
  virtual void  v3(); // _ZN10S2123C4_nt2v3Ev
  virtual void  v4(); // _ZN10S2123C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2123C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2123C4_nt2v6Ev
  virtual void  v7(); // _ZN10S2123C4_nt2v7Ev
  virtual void  v8(); // _ZN10S2123C4_nt2v8Ev
  virtual void  v9(); // _ZN10S2123C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2123C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2123C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2123C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2123C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2123C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2123C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2123C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2123C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2123C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2123C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2123C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2123C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2123C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2123C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2123C4_nt3v24Ev
  S2123C4_nt(); // tgen
};
//SIG(-1 S2123C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S2123C4_nt ::~S2123C4_nt(){ note_dtor("S2123C4_nt", this);}
void  S2123C4_nt ::v2(){vfunc_called(this, "_ZN10S2123C4_nt2v2Ev");}
void  S2123C4_nt ::v3(){vfunc_called(this, "_ZN10S2123C4_nt2v3Ev");}
void  S2123C4_nt ::v4(){vfunc_called(this, "_ZN10S2123C4_nt2v4Ev");}
void  S2123C4_nt ::v5(){vfunc_called(this, "_ZN10S2123C4_nt2v5Ev");}
void  S2123C4_nt ::v6(){vfunc_called(this, "_ZN10S2123C4_nt2v6Ev");}
void  S2123C4_nt ::v7(){vfunc_called(this, "_ZN10S2123C4_nt2v7Ev");}
void  S2123C4_nt ::v8(){vfunc_called(this, "_ZN10S2123C4_nt2v8Ev");}
void  S2123C4_nt ::v9(){vfunc_called(this, "_ZN10S2123C4_nt2v9Ev");}
void  S2123C4_nt ::v10(){vfunc_called(this, "_ZN10S2123C4_nt3v10Ev");}
void  S2123C4_nt ::v11(){vfunc_called(this, "_ZN10S2123C4_nt3v11Ev");}
void  S2123C4_nt ::v12(){vfunc_called(this, "_ZN10S2123C4_nt3v12Ev");}
void  S2123C4_nt ::v13(){vfunc_called(this, "_ZN10S2123C4_nt3v13Ev");}
void  S2123C4_nt ::v14(){vfunc_called(this, "_ZN10S2123C4_nt3v14Ev");}
void  S2123C4_nt ::v15(){vfunc_called(this, "_ZN10S2123C4_nt3v15Ev");}
void  S2123C4_nt ::v16(){vfunc_called(this, "_ZN10S2123C4_nt3v16Ev");}
void  S2123C4_nt ::v17(){vfunc_called(this, "_ZN10S2123C4_nt3v17Ev");}
void  S2123C4_nt ::v18(){vfunc_called(this, "_ZN10S2123C4_nt3v18Ev");}
void  S2123C4_nt ::v19(){vfunc_called(this, "_ZN10S2123C4_nt3v19Ev");}
void  S2123C4_nt ::v20(){vfunc_called(this, "_ZN10S2123C4_nt3v20Ev");}
void  S2123C4_nt ::v21(){vfunc_called(this, "_ZN10S2123C4_nt3v21Ev");}
void  S2123C4_nt ::v22(){vfunc_called(this, "_ZN10S2123C4_nt3v22Ev");}
void  S2123C4_nt ::v23(){vfunc_called(this, "_ZN10S2123C4_nt3v23Ev");}
void  S2123C4_nt ::v24(){vfunc_called(this, "_ZN10S2123C4_nt3v24Ev");}
S2123C4_nt ::S2123C4_nt(){ note_ctor("S2123C4_nt", this);} // tgen

//skip512 S2123C4_nt

#else // __cplusplus

extern void _ZN10S2123C4_ntC1Ev();
extern void _ZN10S2123C4_ntD1Ev();
Name_Map name_map_S2123C4_nt[] = {
  NSPAIR(_ZN10S2123C4_ntC1Ev),
  NSPAIR(_ZN10S2123C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2123C4_nt[];
extern void _ZN10S2123C4_ntD1Ev();
extern void _ZN10S2123C4_ntD0Ev();
extern void _ZN10S2123C4_nt2v2Ev();
extern void _ZN10S2123C4_nt2v3Ev();
extern void _ZN10S2123C4_nt2v4Ev();
extern void _ZN10S2123C4_nt2v5Ev();
extern void _ZN10S2123C4_nt2v6Ev();
extern void _ZN10S2123C4_nt2v7Ev();
extern void _ZN10S2123C4_nt2v8Ev();
extern void _ZN10S2123C4_nt2v9Ev();
extern void _ZN10S2123C4_nt3v10Ev();
extern void _ZN10S2123C4_nt3v11Ev();
extern void _ZN10S2123C4_nt3v12Ev();
extern void _ZN10S2123C4_nt3v13Ev();
extern void _ZN10S2123C4_nt3v14Ev();
extern void _ZN10S2123C4_nt3v15Ev();
extern void _ZN10S2123C4_nt3v16Ev();
extern void _ZN10S2123C4_nt3v17Ev();
extern void _ZN10S2123C4_nt3v18Ev();
extern void _ZN10S2123C4_nt3v19Ev();
extern void _ZN10S2123C4_nt3v20Ev();
extern void _ZN10S2123C4_nt3v21Ev();
extern void _ZN10S2123C4_nt3v22Ev();
extern void _ZN10S2123C4_nt3v23Ev();
extern void _ZN10S2123C4_nt3v24Ev();
static  VTBL_ENTRY vtc_S2123C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2123C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2123C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI10S2123C4_nt[];
VTBL_ENTRY *P__ZTI10S2123C4_nt = _ZTI10S2123C4_nt; 
extern  VTBL_ENTRY _ZTV10S2123C4_nt[];
Class_Descriptor cd_S2123C4_nt = {  "S2123C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2123C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2123C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2123C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C14_nt  {
  __tsi64 s2123c14f0[2];
  void  mf2123c14(); // _ZN11S2123C14_nt9mf2123c14Ev
};
//SIG(-1 S2123C14_nt) C1{ m FL[2]}


void  S2123C14_nt ::mf2123c14(){}

//skip512 S2123C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C13_nt  {
  ::S2123C14_nt s2123c13f0;
  void  mf2123c13(); // _ZN11S2123C13_nt9mf2123c13Ev
};
//SIG(-1 S2123C13_nt) C1{ m FC2{ m FL[2]}}


void  S2123C13_nt ::mf2123c13(){}

//skip512 S2123C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C17_nt  {
  ::S2123C13_nt s2123c17f0;
  void  mf2123c17(); // _ZN11S2123C17_nt9mf2123c17Ev
};
//SIG(-1 S2123C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2123C17_nt ::mf2123c17(){}

//skip512 S2123C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C18_nt  {
  ::S2123C13_nt s2123c18f0;
  ::S2123C13_nt s2123c18f1;
  ::S2123C13_nt s2123c18f2;
  ::S2123C13_nt s2123c18f3;
  void  mf2123c18(); // _ZN11S2123C18_nt9mf2123c18Ev
};
//SIG(-1 S2123C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2123C18_nt ::mf2123c18(){}

//skip512 S2123C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C20_nt  {
  void *s2123c20f0;
  int s2123c20f1;
  ::S2123C8_nt s2123c20f2;
  void  mf2123c20(); // _ZN11S2123C20_nt9mf2123c20Ev
};
//SIG(-1 S2123C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2123C20_nt ::mf2123c20(){}

//skip512 S2123C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C19_nt  {
  ::S2123C20_nt s2123c19f0;
  int s2123c19f1;
  void  mf2123c19(); // _ZN11S2123C19_nt9mf2123c19Ev
};
//SIG(-1 S2123C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2123C19_nt ::mf2123c19(){}

//skip512 S2123C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C23  {
  void  mf2123c23(); // _ZN8S2123C239mf2123c23Ev
};
//SIG(-1 S2123C23) C1{ m}


void  S2123C23 ::mf2123c23(){}

static void Test_S2123C23()
{
  {
    init_simple_test("S2123C23");
    S2123C23 lv;
    check2(sizeof(lv), 1, "sizeof(S2123C23)");
    check2(__alignof__(lv), 1, "__alignof__(S2123C23)");
  }
}
static Arrange_To_Call_Me vS2123C23(Test_S2123C23, "S2123C23", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2123C23[];
VTBL_ENTRY *P__ZTI8S2123C23 = _ZTI8S2123C23; 
Class_Descriptor cd_S2123C23 = {  "S2123C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2123C23),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C22  {
  void *s2123c22f0;
  int s2123c22f1;
  ::S2123C23 s2123c22f2;
  ::S2123C23 s2123c22f3;
  void  mf2123c22(); // _ZN8S2123C229mf2123c22Ev
};
//SIG(-1 S2123C22) C1{ m Fp Fi FC2{ m} FC2}


void  S2123C22 ::mf2123c22(){}

static void Test_S2123C22()
{
  {
    init_simple_test("S2123C22");
    S2123C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2123C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C22)");
    check_field_offset(lv, s2123c22f0, 0, "S2123C22.s2123c22f0");
    check_field_offset(lv, s2123c22f1, ABISELECT(8,4), "S2123C22.s2123c22f1");
    check_field_offset(lv, s2123c22f2, ABISELECT(12,8), "S2123C22.s2123c22f2");
    check_field_offset(lv, s2123c22f3, ABISELECT(13,9), "S2123C22.s2123c22f3");
  }
}
static Arrange_To_Call_Me vS2123C22(Test_S2123C22, "S2123C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C27  {
  void  mf2123c27(); // _ZN8S2123C279mf2123c27Ev
};
//SIG(-1 S2123C27) C1{ m}


void  S2123C27 ::mf2123c27(){}

static void Test_S2123C27()
{
  {
    init_simple_test("S2123C27");
    S2123C27 lv;
    check2(sizeof(lv), 1, "sizeof(S2123C27)");
    check2(__alignof__(lv), 1, "__alignof__(S2123C27)");
  }
}
static Arrange_To_Call_Me vS2123C27(Test_S2123C27, "S2123C27", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2123C27[];
VTBL_ENTRY *P__ZTI8S2123C27 = _ZTI8S2123C27; 
Class_Descriptor cd_S2123C27 = {  "S2123C27", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2123C27),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C26  {
  void *s2123c26f0;
  int s2123c26f1;
  ::S2123C27 s2123c26f2;
  ::S2123C27 s2123c26f3;
  void  mf2123c26(); // _ZN8S2123C269mf2123c26Ev
};
//SIG(-1 S2123C26) C1{ m Fp Fi FC2{ m} FC2}


void  S2123C26 ::mf2123c26(){}

static void Test_S2123C26()
{
  {
    init_simple_test("S2123C26");
    S2123C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2123C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C26)");
    check_field_offset(lv, s2123c26f0, 0, "S2123C26.s2123c26f0");
    check_field_offset(lv, s2123c26f1, ABISELECT(8,4), "S2123C26.s2123c26f1");
    check_field_offset(lv, s2123c26f2, ABISELECT(12,8), "S2123C26.s2123c26f2");
    check_field_offset(lv, s2123c26f3, ABISELECT(13,9), "S2123C26.s2123c26f3");
  }
}
static Arrange_To_Call_Me vS2123C26(Test_S2123C26, "S2123C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2123C26 = {  "S2123C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C25  : S2123C26 {
};
//SIG(-1 S2123C25) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S2123C25()
{
  extern Class_Descriptor cd_S2123C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2123C25, buf);
    S2123C25 &lv = *(new (buf) S2123C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2123C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C25)");
    check_base_class_offset(lv, (S2123C26*), 0, "S2123C25");
    test_class_info(&lv, &cd_S2123C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2123C25(Test_S2123C25, "S2123C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2123C26;
static Base_Class bases_S2123C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2123C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2123C25 = {  "S2123C25", // class name
  bases_S2123C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C30  {
  void  mf2123c30(); // _ZN8S2123C309mf2123c30Ev
};
//SIG(-1 S2123C30) C1{ m}


void  S2123C30 ::mf2123c30(){}

static void Test_S2123C30()
{
  {
    init_simple_test("S2123C30");
    S2123C30 lv;
    check2(sizeof(lv), 1, "sizeof(S2123C30)");
    check2(__alignof__(lv), 1, "__alignof__(S2123C30)");
  }
}
static Arrange_To_Call_Me vS2123C30(Test_S2123C30, "S2123C30", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2123C30[];
VTBL_ENTRY *P__ZTI8S2123C30 = _ZTI8S2123C30; 
Class_Descriptor cd_S2123C30 = {  "S2123C30", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S2123C30),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C29_nt  {
  void *s2123c29f0;
  int s2123c29f1[2];
  ::S2123C30 s2123c29f2;
  void  mf2123c29(); // _ZN11S2123C29_nt9mf2123c29Ev
};
//SIG(-1 S2123C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2123C29_nt ::mf2123c29(){}

//skip512 S2123C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C37  {
  void *s2123c37f0;
  int s2123c37f1[2];
  ::S2123C30 s2123c37f2;
  void  mf2123c37(); // _ZN8S2123C379mf2123c37Ev
};
//SIG(-1 S2123C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2123C37 ::mf2123c37(){}

static void Test_S2123C37()
{
  {
    init_simple_test("S2123C37");
    S2123C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2123C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C37)");
    check_field_offset(lv, s2123c37f0, 0, "S2123C37.s2123c37f0");
    check_field_offset(lv, s2123c37f1, ABISELECT(8,4), "S2123C37.s2123c37f1");
    check_field_offset(lv, s2123c37f2, ABISELECT(16,12), "S2123C37.s2123c37f2");
  }
}
static Arrange_To_Call_Me vS2123C37(Test_S2123C37, "S2123C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C3_nt  : S2123C4_nt {
  ::S2123C13_nt s2123c3f0;
  ::S2123C13_nt s2123c3f1;
  ::S2123C13_nt s2123c3f2;
  ::S2123C13_nt s2123c3f3;
  ::S2123C17_nt s2123c3f4;
  ::S2123C18_nt s2123c3f5;
  ::S2123C18_nt s2123c3f6;
  ::S2123C13_nt s2123c3f7;
  ::S2123C13_nt s2123c3f8;
  ::S2123C13_nt s2123c3f9;
  void *s2123c3f10;
  ::S2123C17_nt s2123c3f11;
  ::S2123C19_nt s2123c3f12;
  int s2123c3f13;
  void *s2123c3f14[7];
  ::S2123C22 s2123c3f15;
  int s2123c3f16:8;
  int s2123c3f17:8;
  int s2123c3f18:16;
  int s2123c3f19:16;
  int s2123c3f20:8;
  int s2123c3f21:8;
  int s2123c3f22:8;
  int s2123c3f23:32;
  int s2123c3f24:8;
  int s2123c3f25:4;
  int s2123c3f26:4;
  int s2123c3f27:4;
  int s2123c3f28:4;
  int s2123c3f29:4;
  int s2123c3f30:4;
  int s2123c3f31:4;
  int s2123c3f32:4;
  int s2123c3f33:4;
  int s2123c3f34:4;
  unsigned char s2123c3f35:1;
  unsigned char s2123c3f36:1;
  unsigned char s2123c3f37:1;
  unsigned char s2123c3f38:1;
  unsigned char s2123c3f39:1;
  unsigned char s2123c3f40:1;
  unsigned char s2123c3f41:1;
  unsigned char s2123c3f42:1;
  unsigned char s2123c3f43:1;
  unsigned char s2123c3f44:1;
  unsigned char s2123c3f45:1;
  unsigned char s2123c3f46:1;
  unsigned char s2123c3f47:1;
  unsigned char s2123c3f48:1;
  unsigned char s2123c3f49:1;
  unsigned char s2123c3f50:1;
  unsigned char s2123c3f51:1;
  unsigned char s2123c3f52:1;
  unsigned char s2123c3f53:1;
  unsigned char s2123c3f54:1;
  unsigned char s2123c3f55:1;
  unsigned char s2123c3f56:1;
  unsigned char s2123c3f57:1;
  unsigned char s2123c3f58:1;
  unsigned char s2123c3f59:1;
  unsigned char s2123c3f60:1;
  unsigned char s2123c3f61:1;
  unsigned char s2123c3f62:1;
  unsigned char s2123c3f63:1;
  unsigned char s2123c3f64:1;
  unsigned char s2123c3f65:1;
  unsigned char s2123c3f66:1;
  unsigned char s2123c3f67:1;
  unsigned char s2123c3f68:1;
  unsigned char s2123c3f69:1;
  unsigned char s2123c3f70:1;
  unsigned char s2123c3f71:1;
  unsigned char s2123c3f72:1;
  unsigned char s2123c3f73:1;
  unsigned char s2123c3f74:1;
  unsigned char s2123c3f75:1;
  int s2123c3f76[7];
  void *s2123c3f77[6];
  int s2123c3f78:8;
  int s2123c3f79:8;
  int s2123c3f80:8;
  int s2123c3f81:8;
  int s2123c3f82:8;
  int s2123c3f83:8;
  ::S2123C25 s2123c3f84;
  void *s2123c3f85[4];
  int s2123c3f86:8;
  int s2123c3f87:8;
  int s2123c3f88:8;
  int s2123c3f89:8;
  int s2123c3f90:8;
  int s2123c3f91:16;
  int s2123c3f92:16;
  int s2123c3f93:16;
  int s2123c3f94:4;
  int s2123c3f95:4;
  int s2123c3f96:4;
  int s2123c3f97:4;
  int s2123c3f98:4;
  int s2123c3f99:4;
  int s2123c3f100:4;
  int s2123c3f101:4;
  int s2123c3f102:4;
  int s2123c3f103:4;
  int s2123c3f104:4;
  int s2123c3f105:4;
  int s2123c3f106:8;
  int s2123c3f107:8;
  int s2123c3f108:8;
  void *s2123c3f109[7];
  ::S2123C29_nt s2123c3f110;
  void *s2123c3f111[2];
  int s2123c3f112:16;
  int s2123c3f113:16;
  ::S2123C25 s2123c3f114;
  ::S2123C29_nt s2123c3f115;
  ::S2123C37 s2123c3f116;
  void *s2123c3f117[2];
  int s2123c3f118:24;
  int s2123c3f119:8;
  void *s2123c3f120;
  virtual  ~S2123C3_nt(); // _ZN10S2123C3_ntD1Ev
  virtual void  v25(); // _ZN10S2123C3_nt3v25Ev
  virtual void  v26(); // _ZN10S2123C3_nt3v26Ev
  virtual void  v27(); // _ZN10S2123C3_nt3v27Ev
  virtual void  v28(); // _ZN10S2123C3_nt3v28Ev
  virtual void  v29(); // _ZN10S2123C3_nt3v29Ev
  virtual void  v30(); // _ZN10S2123C3_nt3v30Ev
  virtual void  v31(); // _ZN10S2123C3_nt3v31Ev
  virtual void  v32(); // _ZN10S2123C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2123C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2123C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2123C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2123C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2123C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2123C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2123C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2123C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2123C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2123C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2123C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2123C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2123C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2123C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2123C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2123C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2123C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2123C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2123C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2123C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2123C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2123C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2123C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2123C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2123C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2123C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2123C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2123C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2123C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2123C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2123C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2123C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2123C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2123C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2123C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2123C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2123C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2123C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2123C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2123C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2123C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2123C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2123C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2123C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2123C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2123C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2123C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2123C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2123C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2123C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2123C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2123C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2123C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2123C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2123C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2123C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2123C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2123C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2123C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2123C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2123C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2123C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2123C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2123C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2123C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2123C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2123C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2123C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2123C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2123C3_nt4v102Ev
  S2123C3_nt(); // tgen
};
//SIG(-1 S2123C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S2123C3_nt ::~S2123C3_nt(){ note_dtor("S2123C3_nt", this);}
void  S2123C3_nt ::v25(){vfunc_called(this, "_ZN10S2123C3_nt3v25Ev");}
void  S2123C3_nt ::v26(){vfunc_called(this, "_ZN10S2123C3_nt3v26Ev");}
void  S2123C3_nt ::v27(){vfunc_called(this, "_ZN10S2123C3_nt3v27Ev");}
void  S2123C3_nt ::v28(){vfunc_called(this, "_ZN10S2123C3_nt3v28Ev");}
void  S2123C3_nt ::v29(){vfunc_called(this, "_ZN10S2123C3_nt3v29Ev");}
void  S2123C3_nt ::v30(){vfunc_called(this, "_ZN10S2123C3_nt3v30Ev");}
void  S2123C3_nt ::v31(){vfunc_called(this, "_ZN10S2123C3_nt3v31Ev");}
void  S2123C3_nt ::v32(){vfunc_called(this, "_ZN10S2123C3_nt3v32Ev");}
void  S2123C3_nt ::v33(){vfunc_called(this, "_ZN10S2123C3_nt3v33Ev");}
void  S2123C3_nt ::v34(){vfunc_called(this, "_ZN10S2123C3_nt3v34Ev");}
void  S2123C3_nt ::v35(){vfunc_called(this, "_ZN10S2123C3_nt3v35Ev");}
void  S2123C3_nt ::v36(){vfunc_called(this, "_ZN10S2123C3_nt3v36Ev");}
void  S2123C3_nt ::v37(){vfunc_called(this, "_ZN10S2123C3_nt3v37Ev");}
void  S2123C3_nt ::v38(){vfunc_called(this, "_ZN10S2123C3_nt3v38Ev");}
void  S2123C3_nt ::v39(){vfunc_called(this, "_ZN10S2123C3_nt3v39Ev");}
void  S2123C3_nt ::v40(){vfunc_called(this, "_ZN10S2123C3_nt3v40Ev");}
void  S2123C3_nt ::v41(){vfunc_called(this, "_ZN10S2123C3_nt3v41Ev");}
void  S2123C3_nt ::v42(){vfunc_called(this, "_ZN10S2123C3_nt3v42Ev");}
void  S2123C3_nt ::v43(){vfunc_called(this, "_ZN10S2123C3_nt3v43Ev");}
void  S2123C3_nt ::v44(){vfunc_called(this, "_ZN10S2123C3_nt3v44Ev");}
void  S2123C3_nt ::v45(){vfunc_called(this, "_ZN10S2123C3_nt3v45Ev");}
void  S2123C3_nt ::v46(){vfunc_called(this, "_ZN10S2123C3_nt3v46Ev");}
void  S2123C3_nt ::v47(){vfunc_called(this, "_ZN10S2123C3_nt3v47Ev");}
void  S2123C3_nt ::v48(){vfunc_called(this, "_ZN10S2123C3_nt3v48Ev");}
void  S2123C3_nt ::v49(){vfunc_called(this, "_ZN10S2123C3_nt3v49Ev");}
void  S2123C3_nt ::v50(){vfunc_called(this, "_ZN10S2123C3_nt3v50Ev");}
void  S2123C3_nt ::v51(){vfunc_called(this, "_ZN10S2123C3_nt3v51Ev");}
void  S2123C3_nt ::v52(){vfunc_called(this, "_ZN10S2123C3_nt3v52Ev");}
void  S2123C3_nt ::v53(){vfunc_called(this, "_ZN10S2123C3_nt3v53Ev");}
void  S2123C3_nt ::v54(){vfunc_called(this, "_ZN10S2123C3_nt3v54Ev");}
void  S2123C3_nt ::v55(){vfunc_called(this, "_ZN10S2123C3_nt3v55Ev");}
void  S2123C3_nt ::v56(){vfunc_called(this, "_ZN10S2123C3_nt3v56Ev");}
void  S2123C3_nt ::v57(){vfunc_called(this, "_ZN10S2123C3_nt3v57Ev");}
void  S2123C3_nt ::v58(){vfunc_called(this, "_ZN10S2123C3_nt3v58Ev");}
void  S2123C3_nt ::v59(){vfunc_called(this, "_ZN10S2123C3_nt3v59Ev");}
void  S2123C3_nt ::v60(){vfunc_called(this, "_ZN10S2123C3_nt3v60Ev");}
void  S2123C3_nt ::v61(){vfunc_called(this, "_ZN10S2123C3_nt3v61Ev");}
void  S2123C3_nt ::v62(){vfunc_called(this, "_ZN10S2123C3_nt3v62Ev");}
void  S2123C3_nt ::v63(){vfunc_called(this, "_ZN10S2123C3_nt3v63Ev");}
void  S2123C3_nt ::v64(){vfunc_called(this, "_ZN10S2123C3_nt3v64Ev");}
void  S2123C3_nt ::v65(){vfunc_called(this, "_ZN10S2123C3_nt3v65Ev");}
void  S2123C3_nt ::v66(){vfunc_called(this, "_ZN10S2123C3_nt3v66Ev");}
void  S2123C3_nt ::v67(){vfunc_called(this, "_ZN10S2123C3_nt3v67Ev");}
void  S2123C3_nt ::v68(){vfunc_called(this, "_ZN10S2123C3_nt3v68Ev");}
void  S2123C3_nt ::v69(){vfunc_called(this, "_ZN10S2123C3_nt3v69Ev");}
void  S2123C3_nt ::v70(){vfunc_called(this, "_ZN10S2123C3_nt3v70Ev");}
void  S2123C3_nt ::v71(){vfunc_called(this, "_ZN10S2123C3_nt3v71Ev");}
void  S2123C3_nt ::v72(){vfunc_called(this, "_ZN10S2123C3_nt3v72Ev");}
void  S2123C3_nt ::v73(){vfunc_called(this, "_ZN10S2123C3_nt3v73Ev");}
void  S2123C3_nt ::v74(){vfunc_called(this, "_ZN10S2123C3_nt3v74Ev");}
void  S2123C3_nt ::v75(){vfunc_called(this, "_ZN10S2123C3_nt3v75Ev");}
void  S2123C3_nt ::v76(){vfunc_called(this, "_ZN10S2123C3_nt3v76Ev");}
void  S2123C3_nt ::v77(){vfunc_called(this, "_ZN10S2123C3_nt3v77Ev");}
void  S2123C3_nt ::v78(){vfunc_called(this, "_ZN10S2123C3_nt3v78Ev");}
void  S2123C3_nt ::v79(){vfunc_called(this, "_ZN10S2123C3_nt3v79Ev");}
void  S2123C3_nt ::v80(){vfunc_called(this, "_ZN10S2123C3_nt3v80Ev");}
void  S2123C3_nt ::v81(){vfunc_called(this, "_ZN10S2123C3_nt3v81Ev");}
void  S2123C3_nt ::v82(){vfunc_called(this, "_ZN10S2123C3_nt3v82Ev");}
void  S2123C3_nt ::v83(){vfunc_called(this, "_ZN10S2123C3_nt3v83Ev");}
void  S2123C3_nt ::v84(){vfunc_called(this, "_ZN10S2123C3_nt3v84Ev");}
void  S2123C3_nt ::v85(){vfunc_called(this, "_ZN10S2123C3_nt3v85Ev");}
void  S2123C3_nt ::v86(){vfunc_called(this, "_ZN10S2123C3_nt3v86Ev");}
void  S2123C3_nt ::v87(){vfunc_called(this, "_ZN10S2123C3_nt3v87Ev");}
void  S2123C3_nt ::v88(){vfunc_called(this, "_ZN10S2123C3_nt3v88Ev");}
void  S2123C3_nt ::v89(){vfunc_called(this, "_ZN10S2123C3_nt3v89Ev");}
void  S2123C3_nt ::v90(){vfunc_called(this, "_ZN10S2123C3_nt3v90Ev");}
void  S2123C3_nt ::v91(){vfunc_called(this, "_ZN10S2123C3_nt3v91Ev");}
void  S2123C3_nt ::v92(){vfunc_called(this, "_ZN10S2123C3_nt3v92Ev");}
void  S2123C3_nt ::v93(){vfunc_called(this, "_ZN10S2123C3_nt3v93Ev");}
void  S2123C3_nt ::v94(){vfunc_called(this, "_ZN10S2123C3_nt3v94Ev");}
void  S2123C3_nt ::v95(){vfunc_called(this, "_ZN10S2123C3_nt3v95Ev");}
void  S2123C3_nt ::v96(){vfunc_called(this, "_ZN10S2123C3_nt3v96Ev");}
void  S2123C3_nt ::v97(){vfunc_called(this, "_ZN10S2123C3_nt3v97Ev");}
void  S2123C3_nt ::v98(){vfunc_called(this, "_ZN10S2123C3_nt3v98Ev");}
void  S2123C3_nt ::v99(){vfunc_called(this, "_ZN10S2123C3_nt3v99Ev");}
void  S2123C3_nt ::v100(){vfunc_called(this, "_ZN10S2123C3_nt4v100Ev");}
void  S2123C3_nt ::v101(){vfunc_called(this, "_ZN10S2123C3_nt4v101Ev");}
void  S2123C3_nt ::v102(){vfunc_called(this, "_ZN10S2123C3_nt4v102Ev");}
S2123C3_nt ::S2123C3_nt(){ note_ctor("S2123C3_nt", this);} // tgen

//skip512 S2123C3_nt

#else // __cplusplus

extern void _ZN10S2123C3_ntC1Ev();
extern void _ZN10S2123C3_ntD1Ev();
Name_Map name_map_S2123C3_nt[] = {
  NSPAIR(_ZN10S2123C3_ntC1Ev),
  NSPAIR(_ZN10S2123C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2123C4_nt;
extern VTBL_ENTRY _ZTI10S2123C4_nt[];
extern  VTBL_ENTRY _ZTV10S2123C4_nt[];
static Base_Class bases_S2123C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2123C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2123C3_nt[];
extern void _ZN10S2123C3_ntD1Ev();
extern void _ZN10S2123C3_ntD0Ev();
extern void _ZN10S2123C4_nt2v2Ev();
extern void _ZN10S2123C4_nt2v3Ev();
extern void _ZN10S2123C4_nt2v4Ev();
extern void _ZN10S2123C4_nt2v5Ev();
extern void _ZN10S2123C4_nt2v6Ev();
extern void _ZN10S2123C4_nt2v7Ev();
extern void _ZN10S2123C4_nt2v8Ev();
extern void _ZN10S2123C4_nt2v9Ev();
extern void _ZN10S2123C4_nt3v10Ev();
extern void _ZN10S2123C4_nt3v11Ev();
extern void _ZN10S2123C4_nt3v12Ev();
extern void _ZN10S2123C4_nt3v13Ev();
extern void _ZN10S2123C4_nt3v14Ev();
extern void _ZN10S2123C4_nt3v15Ev();
extern void _ZN10S2123C4_nt3v16Ev();
extern void _ZN10S2123C4_nt3v17Ev();
extern void _ZN10S2123C4_nt3v18Ev();
extern void _ZN10S2123C4_nt3v19Ev();
extern void _ZN10S2123C4_nt3v20Ev();
extern void _ZN10S2123C4_nt3v21Ev();
extern void _ZN10S2123C4_nt3v22Ev();
extern void _ZN10S2123C4_nt3v23Ev();
extern void _ZN10S2123C4_nt3v24Ev();
extern void _ZN10S2123C3_nt3v25Ev();
extern void _ZN10S2123C3_nt3v26Ev();
extern void _ZN10S2123C3_nt3v27Ev();
extern void _ZN10S2123C3_nt3v28Ev();
extern void _ZN10S2123C3_nt3v29Ev();
extern void _ZN10S2123C3_nt3v30Ev();
extern void _ZN10S2123C3_nt3v31Ev();
extern void _ZN10S2123C3_nt3v32Ev();
extern void _ZN10S2123C3_nt3v33Ev();
extern void _ZN10S2123C3_nt3v34Ev();
extern void _ZN10S2123C3_nt3v35Ev();
extern void _ZN10S2123C3_nt3v36Ev();
extern void _ZN10S2123C3_nt3v37Ev();
extern void _ZN10S2123C3_nt3v38Ev();
extern void _ZN10S2123C3_nt3v39Ev();
extern void _ZN10S2123C3_nt3v40Ev();
extern void _ZN10S2123C3_nt3v41Ev();
extern void _ZN10S2123C3_nt3v42Ev();
extern void _ZN10S2123C3_nt3v43Ev();
extern void _ZN10S2123C3_nt3v44Ev();
extern void _ZN10S2123C3_nt3v45Ev();
extern void _ZN10S2123C3_nt3v46Ev();
extern void _ZN10S2123C3_nt3v47Ev();
extern void _ZN10S2123C3_nt3v48Ev();
extern void _ZN10S2123C3_nt3v49Ev();
extern void _ZN10S2123C3_nt3v50Ev();
extern void _ZN10S2123C3_nt3v51Ev();
extern void _ZN10S2123C3_nt3v52Ev();
extern void _ZN10S2123C3_nt3v53Ev();
extern void _ZN10S2123C3_nt3v54Ev();
extern void _ZN10S2123C3_nt3v55Ev();
extern void _ZN10S2123C3_nt3v56Ev();
extern void _ZN10S2123C3_nt3v57Ev();
extern void _ZN10S2123C3_nt3v58Ev();
extern void _ZN10S2123C3_nt3v59Ev();
extern void _ZN10S2123C3_nt3v60Ev();
extern void _ZN10S2123C3_nt3v61Ev();
extern void _ZN10S2123C3_nt3v62Ev();
extern void _ZN10S2123C3_nt3v63Ev();
extern void _ZN10S2123C3_nt3v64Ev();
extern void _ZN10S2123C3_nt3v65Ev();
extern void _ZN10S2123C3_nt3v66Ev();
extern void _ZN10S2123C3_nt3v67Ev();
extern void _ZN10S2123C3_nt3v68Ev();
extern void _ZN10S2123C3_nt3v69Ev();
extern void _ZN10S2123C3_nt3v70Ev();
extern void _ZN10S2123C3_nt3v71Ev();
extern void _ZN10S2123C3_nt3v72Ev();
extern void _ZN10S2123C3_nt3v73Ev();
extern void _ZN10S2123C3_nt3v74Ev();
extern void _ZN10S2123C3_nt3v75Ev();
extern void _ZN10S2123C3_nt3v76Ev();
extern void _ZN10S2123C3_nt3v77Ev();
extern void _ZN10S2123C3_nt3v78Ev();
extern void _ZN10S2123C3_nt3v79Ev();
extern void _ZN10S2123C3_nt3v80Ev();
extern void _ZN10S2123C3_nt3v81Ev();
extern void _ZN10S2123C3_nt3v82Ev();
extern void _ZN10S2123C3_nt3v83Ev();
extern void _ZN10S2123C3_nt3v84Ev();
extern void _ZN10S2123C3_nt3v85Ev();
extern void _ZN10S2123C3_nt3v86Ev();
extern void _ZN10S2123C3_nt3v87Ev();
extern void _ZN10S2123C3_nt3v88Ev();
extern void _ZN10S2123C3_nt3v89Ev();
extern void _ZN10S2123C3_nt3v90Ev();
extern void _ZN10S2123C3_nt3v91Ev();
extern void _ZN10S2123C3_nt3v92Ev();
extern void _ZN10S2123C3_nt3v93Ev();
extern void _ZN10S2123C3_nt3v94Ev();
extern void _ZN10S2123C3_nt3v95Ev();
extern void _ZN10S2123C3_nt3v96Ev();
extern void _ZN10S2123C3_nt3v97Ev();
extern void _ZN10S2123C3_nt3v98Ev();
extern void _ZN10S2123C3_nt3v99Ev();
extern void _ZN10S2123C3_nt4v100Ev();
extern void _ZN10S2123C3_nt4v101Ev();
extern void _ZN10S2123C3_nt4v102Ev();
static  VTBL_ENTRY vtc_S2123C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2123C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2123C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v102Ev,
};
extern VTBL_ENTRY _ZTI10S2123C3_nt[];
VTBL_ENTRY *P__ZTI10S2123C3_nt = _ZTI10S2123C3_nt; 
extern  VTBL_ENTRY _ZTV10S2123C3_nt[];
Class_Descriptor cd_S2123C3_nt = {  "S2123C3_nt", // class name
  bases_S2123C3_nt, 1,
  &(vtc_S2123C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2123C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2123C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C2  : S2123C3_nt {
  virtual  ~S2123C2(); // _ZN7S2123C2D1Ev
  virtual void  v103(); // _ZN7S2123C24v103Ev
  virtual void  v104(); // _ZN7S2123C24v104Ev
  virtual void  v105(); // _ZN7S2123C24v105Ev
  virtual void  v106(); // _ZN7S2123C24v106Ev
  virtual void  v107(); // _ZN7S2123C24v107Ev
  virtual void  v108(); // _ZN7S2123C24v108Ev
  virtual void  v109(); // _ZN7S2123C24v109Ev
  virtual void  v110(); // _ZN7S2123C24v110Ev
  S2123C2(); // tgen
};
//SIG(-1 S2123C2) C1{ BC2{ BC3{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S2123C2 ::~S2123C2(){ note_dtor("S2123C2", this);}
void  S2123C2 ::v103(){vfunc_called(this, "_ZN7S2123C24v103Ev");}
void  S2123C2 ::v104(){vfunc_called(this, "_ZN7S2123C24v104Ev");}
void  S2123C2 ::v105(){vfunc_called(this, "_ZN7S2123C24v105Ev");}
void  S2123C2 ::v106(){vfunc_called(this, "_ZN7S2123C24v106Ev");}
void  S2123C2 ::v107(){vfunc_called(this, "_ZN7S2123C24v107Ev");}
void  S2123C2 ::v108(){vfunc_called(this, "_ZN7S2123C24v108Ev");}
void  S2123C2 ::v109(){vfunc_called(this, "_ZN7S2123C24v109Ev");}
void  S2123C2 ::v110(){vfunc_called(this, "_ZN7S2123C24v110Ev");}
S2123C2 ::S2123C2(){ note_ctor("S2123C2", this);} // tgen

static void Test_S2123C2()
{
  extern Class_Descriptor cd_S2123C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S2123C2, buf);
    S2123C2 *dp, &lv = *(dp=new (buf) S2123C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S2123C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C2)");
    check_base_class_offset(lv, (S2123C4_nt*)(S2123C3_nt*), 0, "S2123C2");
    check_base_class_offset(lv, (S2123C3_nt*), 0, "S2123C2");
    test_class_info(&lv, &cd_S2123C2);
    dp->~S2123C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2123C2(Test_S2123C2, "S2123C2", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S2123C2C1Ev();
extern void _ZN7S2123C2D1Ev();
Name_Map name_map_S2123C2[] = {
  NSPAIR(_ZN7S2123C2C1Ev),
  NSPAIR(_ZN7S2123C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2123C4_nt;
extern VTBL_ENTRY _ZTI10S2123C4_nt[];
extern  VTBL_ENTRY _ZTV10S2123C4_nt[];
extern Class_Descriptor cd_S2123C3_nt;
extern VTBL_ENTRY _ZTI10S2123C3_nt[];
extern  VTBL_ENTRY _ZTV10S2123C3_nt[];
static Base_Class bases_S2123C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2123C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2123C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2123C2[];
extern void _ZN7S2123C2D1Ev();
extern void _ZN7S2123C2D0Ev();
extern void _ZN10S2123C4_nt2v2Ev();
extern void _ZN10S2123C4_nt2v3Ev();
extern void _ZN10S2123C4_nt2v4Ev();
extern void _ZN10S2123C4_nt2v5Ev();
extern void _ZN10S2123C4_nt2v6Ev();
extern void _ZN10S2123C4_nt2v7Ev();
extern void _ZN10S2123C4_nt2v8Ev();
extern void _ZN10S2123C4_nt2v9Ev();
extern void _ZN10S2123C4_nt3v10Ev();
extern void _ZN10S2123C4_nt3v11Ev();
extern void _ZN10S2123C4_nt3v12Ev();
extern void _ZN10S2123C4_nt3v13Ev();
extern void _ZN10S2123C4_nt3v14Ev();
extern void _ZN10S2123C4_nt3v15Ev();
extern void _ZN10S2123C4_nt3v16Ev();
extern void _ZN10S2123C4_nt3v17Ev();
extern void _ZN10S2123C4_nt3v18Ev();
extern void _ZN10S2123C4_nt3v19Ev();
extern void _ZN10S2123C4_nt3v20Ev();
extern void _ZN10S2123C4_nt3v21Ev();
extern void _ZN10S2123C4_nt3v22Ev();
extern void _ZN10S2123C4_nt3v23Ev();
extern void _ZN10S2123C4_nt3v24Ev();
extern void _ZN10S2123C3_nt3v25Ev();
extern void _ZN10S2123C3_nt3v26Ev();
extern void _ZN10S2123C3_nt3v27Ev();
extern void _ZN10S2123C3_nt3v28Ev();
extern void _ZN10S2123C3_nt3v29Ev();
extern void _ZN10S2123C3_nt3v30Ev();
extern void _ZN10S2123C3_nt3v31Ev();
extern void _ZN10S2123C3_nt3v32Ev();
extern void _ZN10S2123C3_nt3v33Ev();
extern void _ZN10S2123C3_nt3v34Ev();
extern void _ZN10S2123C3_nt3v35Ev();
extern void _ZN10S2123C3_nt3v36Ev();
extern void _ZN10S2123C3_nt3v37Ev();
extern void _ZN10S2123C3_nt3v38Ev();
extern void _ZN10S2123C3_nt3v39Ev();
extern void _ZN10S2123C3_nt3v40Ev();
extern void _ZN10S2123C3_nt3v41Ev();
extern void _ZN10S2123C3_nt3v42Ev();
extern void _ZN10S2123C3_nt3v43Ev();
extern void _ZN10S2123C3_nt3v44Ev();
extern void _ZN10S2123C3_nt3v45Ev();
extern void _ZN10S2123C3_nt3v46Ev();
extern void _ZN10S2123C3_nt3v47Ev();
extern void _ZN10S2123C3_nt3v48Ev();
extern void _ZN10S2123C3_nt3v49Ev();
extern void _ZN10S2123C3_nt3v50Ev();
extern void _ZN10S2123C3_nt3v51Ev();
extern void _ZN10S2123C3_nt3v52Ev();
extern void _ZN10S2123C3_nt3v53Ev();
extern void _ZN10S2123C3_nt3v54Ev();
extern void _ZN10S2123C3_nt3v55Ev();
extern void _ZN10S2123C3_nt3v56Ev();
extern void _ZN10S2123C3_nt3v57Ev();
extern void _ZN10S2123C3_nt3v58Ev();
extern void _ZN10S2123C3_nt3v59Ev();
extern void _ZN10S2123C3_nt3v60Ev();
extern void _ZN10S2123C3_nt3v61Ev();
extern void _ZN10S2123C3_nt3v62Ev();
extern void _ZN10S2123C3_nt3v63Ev();
extern void _ZN10S2123C3_nt3v64Ev();
extern void _ZN10S2123C3_nt3v65Ev();
extern void _ZN10S2123C3_nt3v66Ev();
extern void _ZN10S2123C3_nt3v67Ev();
extern void _ZN10S2123C3_nt3v68Ev();
extern void _ZN10S2123C3_nt3v69Ev();
extern void _ZN10S2123C3_nt3v70Ev();
extern void _ZN10S2123C3_nt3v71Ev();
extern void _ZN10S2123C3_nt3v72Ev();
extern void _ZN10S2123C3_nt3v73Ev();
extern void _ZN10S2123C3_nt3v74Ev();
extern void _ZN10S2123C3_nt3v75Ev();
extern void _ZN10S2123C3_nt3v76Ev();
extern void _ZN10S2123C3_nt3v77Ev();
extern void _ZN10S2123C3_nt3v78Ev();
extern void _ZN10S2123C3_nt3v79Ev();
extern void _ZN10S2123C3_nt3v80Ev();
extern void _ZN10S2123C3_nt3v81Ev();
extern void _ZN10S2123C3_nt3v82Ev();
extern void _ZN10S2123C3_nt3v83Ev();
extern void _ZN10S2123C3_nt3v84Ev();
extern void _ZN10S2123C3_nt3v85Ev();
extern void _ZN10S2123C3_nt3v86Ev();
extern void _ZN10S2123C3_nt3v87Ev();
extern void _ZN10S2123C3_nt3v88Ev();
extern void _ZN10S2123C3_nt3v89Ev();
extern void _ZN10S2123C3_nt3v90Ev();
extern void _ZN10S2123C3_nt3v91Ev();
extern void _ZN10S2123C3_nt3v92Ev();
extern void _ZN10S2123C3_nt3v93Ev();
extern void _ZN10S2123C3_nt3v94Ev();
extern void _ZN10S2123C3_nt3v95Ev();
extern void _ZN10S2123C3_nt3v96Ev();
extern void _ZN10S2123C3_nt3v97Ev();
extern void _ZN10S2123C3_nt3v98Ev();
extern void _ZN10S2123C3_nt3v99Ev();
extern void _ZN10S2123C3_nt4v100Ev();
extern void _ZN10S2123C3_nt4v101Ev();
extern void _ZN10S2123C3_nt4v102Ev();
extern void _ZN7S2123C24v103Ev();
extern void _ZN7S2123C24v104Ev();
extern void _ZN7S2123C24v105Ev();
extern void _ZN7S2123C24v106Ev();
extern void _ZN7S2123C24v107Ev();
extern void _ZN7S2123C24v108Ev();
extern void _ZN7S2123C24v109Ev();
extern void _ZN7S2123C24v110Ev();
static  VTBL_ENTRY vtc_S2123C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2123C2[0]),
  (VTBL_ENTRY)&_ZN7S2123C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2123C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v103Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v104Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v105Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v106Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v107Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v108Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v109Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S2123C2[];
extern  VTBL_ENTRY _ZTV7S2123C2[];
Class_Descriptor cd_S2123C2 = {  "S2123C2", // class name
  bases_S2123C2, 2,
  &(vtc_S2123C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S2123C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2123C2),113, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2123C1  : S2123C2 {
  virtual  ~S2123C1(); // _ZN7S2123C1D1Ev
  virtual void  v1(); // _ZN7S2123C12v1Ev
  S2123C1(); // tgen
};
//SIG(1 S2123C1) C1{ BC2{ BC3{ BC4{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC5 Fi} vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9 FC11{ m FC9} FC12{ m FC9 FC9 FC9 FC9} FC12 FC9 FC9 FC9 Fp FC11 FC13{ m FC14{ m Fp Fi FC8} Fi} Fi Fp[7] FC15{ m Fp Fi FC16{ m} FC16} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC19{ m} FC19}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC17 FC20 FC22{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp} vd v103 v104 v105 v106 v107 v108 v109 v110} vd v1}


 S2123C1 ::~S2123C1(){ note_dtor("S2123C1", this);}
void  S2123C1 ::v1(){vfunc_called(this, "_ZN7S2123C12v1Ev");}
S2123C1 ::S2123C1(){ note_ctor("S2123C1", this);} // tgen

static void Test_S2123C1()
{
  extern Class_Descriptor cd_S2123C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S2123C1, buf);
    S2123C1 *dp, &lv = *(dp=new (buf) S2123C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S2123C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2123C1)");
    check_base_class_offset(lv, (S2123C4_nt*)(S2123C3_nt*)(S2123C2*), 0, "S2123C1");
    check_base_class_offset(lv, (S2123C3_nt*)(S2123C2*), 0, "S2123C1");
    check_base_class_offset(lv, (S2123C2*), 0, "S2123C1");
    test_class_info(&lv, &cd_S2123C1);
    dp->~S2123C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2123C1(Test_S2123C1, "S2123C1", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S2123C1C1Ev();
extern void _ZN7S2123C1D1Ev();
Name_Map name_map_S2123C1[] = {
  NSPAIR(_ZN7S2123C1C1Ev),
  NSPAIR(_ZN7S2123C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2123C4_nt;
extern VTBL_ENTRY _ZTI10S2123C4_nt[];
extern  VTBL_ENTRY _ZTV10S2123C4_nt[];
extern Class_Descriptor cd_S2123C3_nt;
extern VTBL_ENTRY _ZTI10S2123C3_nt[];
extern  VTBL_ENTRY _ZTV10S2123C3_nt[];
extern Class_Descriptor cd_S2123C2;
extern VTBL_ENTRY _ZTI7S2123C2[];
extern  VTBL_ENTRY _ZTV7S2123C2[];
static Base_Class bases_S2123C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2123C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2123C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2123C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2123C1[];
extern void _ZN7S2123C1D1Ev();
extern void _ZN7S2123C1D0Ev();
extern void _ZN10S2123C4_nt2v2Ev();
extern void _ZN10S2123C4_nt2v3Ev();
extern void _ZN10S2123C4_nt2v4Ev();
extern void _ZN10S2123C4_nt2v5Ev();
extern void _ZN10S2123C4_nt2v6Ev();
extern void _ZN10S2123C4_nt2v7Ev();
extern void _ZN10S2123C4_nt2v8Ev();
extern void _ZN10S2123C4_nt2v9Ev();
extern void _ZN10S2123C4_nt3v10Ev();
extern void _ZN10S2123C4_nt3v11Ev();
extern void _ZN10S2123C4_nt3v12Ev();
extern void _ZN10S2123C4_nt3v13Ev();
extern void _ZN10S2123C4_nt3v14Ev();
extern void _ZN10S2123C4_nt3v15Ev();
extern void _ZN10S2123C4_nt3v16Ev();
extern void _ZN10S2123C4_nt3v17Ev();
extern void _ZN10S2123C4_nt3v18Ev();
extern void _ZN10S2123C4_nt3v19Ev();
extern void _ZN10S2123C4_nt3v20Ev();
extern void _ZN10S2123C4_nt3v21Ev();
extern void _ZN10S2123C4_nt3v22Ev();
extern void _ZN10S2123C4_nt3v23Ev();
extern void _ZN10S2123C4_nt3v24Ev();
extern void _ZN10S2123C3_nt3v25Ev();
extern void _ZN10S2123C3_nt3v26Ev();
extern void _ZN10S2123C3_nt3v27Ev();
extern void _ZN10S2123C3_nt3v28Ev();
extern void _ZN10S2123C3_nt3v29Ev();
extern void _ZN10S2123C3_nt3v30Ev();
extern void _ZN10S2123C3_nt3v31Ev();
extern void _ZN10S2123C3_nt3v32Ev();
extern void _ZN10S2123C3_nt3v33Ev();
extern void _ZN10S2123C3_nt3v34Ev();
extern void _ZN10S2123C3_nt3v35Ev();
extern void _ZN10S2123C3_nt3v36Ev();
extern void _ZN10S2123C3_nt3v37Ev();
extern void _ZN10S2123C3_nt3v38Ev();
extern void _ZN10S2123C3_nt3v39Ev();
extern void _ZN10S2123C3_nt3v40Ev();
extern void _ZN10S2123C3_nt3v41Ev();
extern void _ZN10S2123C3_nt3v42Ev();
extern void _ZN10S2123C3_nt3v43Ev();
extern void _ZN10S2123C3_nt3v44Ev();
extern void _ZN10S2123C3_nt3v45Ev();
extern void _ZN10S2123C3_nt3v46Ev();
extern void _ZN10S2123C3_nt3v47Ev();
extern void _ZN10S2123C3_nt3v48Ev();
extern void _ZN10S2123C3_nt3v49Ev();
extern void _ZN10S2123C3_nt3v50Ev();
extern void _ZN10S2123C3_nt3v51Ev();
extern void _ZN10S2123C3_nt3v52Ev();
extern void _ZN10S2123C3_nt3v53Ev();
extern void _ZN10S2123C3_nt3v54Ev();
extern void _ZN10S2123C3_nt3v55Ev();
extern void _ZN10S2123C3_nt3v56Ev();
extern void _ZN10S2123C3_nt3v57Ev();
extern void _ZN10S2123C3_nt3v58Ev();
extern void _ZN10S2123C3_nt3v59Ev();
extern void _ZN10S2123C3_nt3v60Ev();
extern void _ZN10S2123C3_nt3v61Ev();
extern void _ZN10S2123C3_nt3v62Ev();
extern void _ZN10S2123C3_nt3v63Ev();
extern void _ZN10S2123C3_nt3v64Ev();
extern void _ZN10S2123C3_nt3v65Ev();
extern void _ZN10S2123C3_nt3v66Ev();
extern void _ZN10S2123C3_nt3v67Ev();
extern void _ZN10S2123C3_nt3v68Ev();
extern void _ZN10S2123C3_nt3v69Ev();
extern void _ZN10S2123C3_nt3v70Ev();
extern void _ZN10S2123C3_nt3v71Ev();
extern void _ZN10S2123C3_nt3v72Ev();
extern void _ZN10S2123C3_nt3v73Ev();
extern void _ZN10S2123C3_nt3v74Ev();
extern void _ZN10S2123C3_nt3v75Ev();
extern void _ZN10S2123C3_nt3v76Ev();
extern void _ZN10S2123C3_nt3v77Ev();
extern void _ZN10S2123C3_nt3v78Ev();
extern void _ZN10S2123C3_nt3v79Ev();
extern void _ZN10S2123C3_nt3v80Ev();
extern void _ZN10S2123C3_nt3v81Ev();
extern void _ZN10S2123C3_nt3v82Ev();
extern void _ZN10S2123C3_nt3v83Ev();
extern void _ZN10S2123C3_nt3v84Ev();
extern void _ZN10S2123C3_nt3v85Ev();
extern void _ZN10S2123C3_nt3v86Ev();
extern void _ZN10S2123C3_nt3v87Ev();
extern void _ZN10S2123C3_nt3v88Ev();
extern void _ZN10S2123C3_nt3v89Ev();
extern void _ZN10S2123C3_nt3v90Ev();
extern void _ZN10S2123C3_nt3v91Ev();
extern void _ZN10S2123C3_nt3v92Ev();
extern void _ZN10S2123C3_nt3v93Ev();
extern void _ZN10S2123C3_nt3v94Ev();
extern void _ZN10S2123C3_nt3v95Ev();
extern void _ZN10S2123C3_nt3v96Ev();
extern void _ZN10S2123C3_nt3v97Ev();
extern void _ZN10S2123C3_nt3v98Ev();
extern void _ZN10S2123C3_nt3v99Ev();
extern void _ZN10S2123C3_nt4v100Ev();
extern void _ZN10S2123C3_nt4v101Ev();
extern void _ZN10S2123C3_nt4v102Ev();
extern void _ZN7S2123C24v103Ev();
extern void _ZN7S2123C24v104Ev();
extern void _ZN7S2123C24v105Ev();
extern void _ZN7S2123C24v106Ev();
extern void _ZN7S2123C24v107Ev();
extern void _ZN7S2123C24v108Ev();
extern void _ZN7S2123C24v109Ev();
extern void _ZN7S2123C24v110Ev();
extern void _ZN7S2123C12v1Ev();
static  VTBL_ENTRY vtc_S2123C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2123C1[0]),
  (VTBL_ENTRY)&_ZN7S2123C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2123C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2123C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2123C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v103Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v104Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v105Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v106Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v107Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v108Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v109Ev,
  (VTBL_ENTRY)&_ZN7S2123C24v110Ev,
  (VTBL_ENTRY)&_ZN7S2123C12v1Ev,
};
extern VTBL_ENTRY _ZTI7S2123C1[];
extern  VTBL_ENTRY _ZTV7S2123C1[];
Class_Descriptor cd_S2123C1 = {  "S2123C1", // class name
  bases_S2123C1, 3,
  &(vtc_S2123C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S2123C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2123C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C5  {
  __tsi64 s468c5f0;
  void *s468c5f1;
  char s468c5f2:6;
  long double s468c5f3;
  char s468c5f4[7];
  __tsi64 s468c5f5;
  char s468c5f6[9];
  long double s468c5f7[8];
  void *s468c5f8;
  short s468c5f9;
  void *s468c5f10[7];
  int s468c5f11;
  void *s468c5f12;
  virtual void  v1(); // _ZN6S468C52v1Ev
  virtual void  v2(); // _ZN6S468C52v2Ev
  ~S468C5(); // tgen
  S468C5(); // tgen
};
//SIG(-1 S468C5) C1{ v1 v2 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}


void  S468C5 ::v1(){vfunc_called(this, "_ZN6S468C52v1Ev");}
void  S468C5 ::v2(){vfunc_called(this, "_ZN6S468C52v2Ev");}
S468C5 ::~S468C5(){ note_dtor("S468C5", this);} // tgen
S468C5 ::S468C5(){ note_ctor("S468C5", this);} // tgen

static void Test_S468C5()
{
  extern Class_Descriptor cd_S468C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,51)];
    init_test(&cd_S468C5, buf);
    S468C5 *dp, &lv = *(dp=new (buf) S468C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,200), "sizeof(S468C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C5)");
    check_field_offset(lv, s468c5f0, ABISELECT(8,4), "S468C5.s468c5f0");
    check_field_offset(lv, s468c5f1, ABISELECT(16,12), "S468C5.s468c5f1");
    set_bf_and_test(lv, s468c5f2, ABISELECT(24,16), 0, 6, 1, "S468C5");
    set_bf_and_test(lv, s468c5f2, ABISELECT(24,16), 0, 6, hide_sll(1LL<<5), "S468C5");
    check_field_offset(lv, s468c5f3, ABISELECT(32,20), "S468C5.s468c5f3");
    check_field_offset(lv, s468c5f4, ABISELECT(48,32), "S468C5.s468c5f4");
    check_field_offset(lv, s468c5f5, ABISELECT(56,40), "S468C5.s468c5f5");
    check_field_offset(lv, s468c5f6, ABISELECT(64,48), "S468C5.s468c5f6");
    check_field_offset(lv, s468c5f7, ABISELECT(80,60), "S468C5.s468c5f7");
    check_field_offset(lv, s468c5f8, ABISELECT(208,156), "S468C5.s468c5f8");
    check_field_offset(lv, s468c5f9, ABISELECT(216,160), "S468C5.s468c5f9");
    check_field_offset(lv, s468c5f10, ABISELECT(224,164), "S468C5.s468c5f10");
    check_field_offset(lv, s468c5f11, ABISELECT(280,192), "S468C5.s468c5f11");
    check_field_offset(lv, s468c5f12, ABISELECT(288,196), "S468C5.s468c5f12");
    test_class_info(&lv, &cd_S468C5);
    dp->~S468C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C5(Test_S468C5, "S468C5", ABISELECT(304,200));

#else // __cplusplus

extern void _ZN6S468C5C1Ev();
extern void _ZN6S468C5D1Ev();
Name_Map name_map_S468C5[] = {
  NSPAIR(_ZN6S468C5C1Ev),
  NSPAIR(_ZN6S468C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S468C5[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY vtc_S468C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S468C5[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
Class_Descriptor cd_S468C5 = {  "S468C5", // class name
  0,0,//no base classes
  &(vtc_S468C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,200), // object size
  NSPAIRA(_ZTI6S468C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S468C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C7  {
  void *s468c7f0;
  __tsi64 s468c7f1;
  void *s468c7f2[7];
  void  mf468c7(); // _ZN6S468C77mf468c7Ev
  virtual  ~S468C7(); // _ZN6S468C7D1Ev
  S468C7(); // tgen
};
//SIG(-1 S468C7) C1{ vd m Fp FL Fp[7]}


void  S468C7 ::mf468c7(){}
 S468C7 ::~S468C7(){ note_dtor("S468C7", this);}
S468C7 ::S468C7(){ note_ctor("S468C7", this);} // tgen

static void Test_S468C7()
{
  extern Class_Descriptor cd_S468C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,12)];
    init_test(&cd_S468C7, buf);
    S468C7 *dp, &lv = *(dp=new (buf) S468C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,44), "sizeof(S468C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S468C7)");
    check_field_offset(lv, s468c7f0, ABISELECT(8,4), "S468C7.s468c7f0");
    check_field_offset(lv, s468c7f1, ABISELECT(16,8), "S468C7.s468c7f1");
    check_field_offset(lv, s468c7f2, ABISELECT(24,16), "S468C7.s468c7f2");
    test_class_info(&lv, &cd_S468C7);
    dp->~S468C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C7(Test_S468C7, "S468C7", ABISELECT(80,44));

#else // __cplusplus

extern void _ZN6S468C7C1Ev();
extern void _ZN6S468C7D1Ev();
Name_Map name_map_S468C7[] = {
  NSPAIR(_ZN6S468C7C1Ev),
  NSPAIR(_ZN6S468C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S468C7[];
extern void _ZN6S468C7D1Ev();
extern void _ZN6S468C7D0Ev();
static  VTBL_ENTRY vtc_S468C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S468C7[0]),
  (VTBL_ENTRY)&_ZN6S468C7D1Ev,
  (VTBL_ENTRY)&_ZN6S468C7D0Ev,
};
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
Class_Descriptor cd_S468C7 = {  "S468C7", // class name
  0,0,//no base classes
  &(vtc_S468C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,44), // object size
  NSPAIRA(_ZTI6S468C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S468C7),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C6  {
  ::S468C5 s468c6f0[8];
  ::S468C5 s468c6f1[2];
  void *s468c6f2;
  int s468c6f3;
  ::S468C7 s468c6f4;
  ::S468C5 s468c6f5[5];
  void *s468c6f6[5];
  ::S468C5 s468c6f7[5];
  virtual void  v3(); // _ZN6S468C62v3Ev
  ~S468C6(); // tgen
  S468C6(); // tgen
};
//SIG(-1 S468C6) C1{ v1 FC2{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC2[2] Fp Fi FC3{ vd m Fp FL Fp[7]} FC2[5] Fp[5] FC2[5]}


void  S468C6 ::v3(){vfunc_called(this, "_ZN6S468C62v3Ev");}
S468C6 ::~S468C6(){ note_dtor("S468C6", this);} // tgen
S468C6 ::S468C6(){ note_ctor("S468C6", this);} // tgen

static void Test_S468C6()
{
  extern Class_Descriptor cd_S468C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(391,1020)];
    init_test(&cd_S468C6, buf);
    S468C6 *dp, &lv = *(dp=new (buf) S468C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6240,4076), "sizeof(S468C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C6)");
    check_field_offset(lv, s468c6f0, ABISELECT(16,4), "S468C6.s468c6f0");
    check_field_offset(lv, s468c6f1, ABISELECT(2448,1604), "S468C6.s468c6f1");
    check_field_offset(lv, s468c6f2, ABISELECT(3056,2004), "S468C6.s468c6f2");
    check_field_offset(lv, s468c6f3, ABISELECT(3064,2008), "S468C6.s468c6f3");
    check_field_offset(lv, s468c6f4, ABISELECT(3072,2012), "S468C6.s468c6f4");
    check_field_offset(lv, s468c6f5, ABISELECT(3152,2056), "S468C6.s468c6f5");
    check_field_offset(lv, s468c6f6, ABISELECT(4672,3056), "S468C6.s468c6f6");
    check_field_offset(lv, s468c6f7, ABISELECT(4720,3076), "S468C6.s468c6f7");
    test_class_info(&lv, &cd_S468C6);
    dp->~S468C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C6(Test_S468C6, "S468C6", ABISELECT(6240,4076));

#else // __cplusplus

extern void _ZN6S468C6C1Ev();
extern void _ZN6S468C6D1Ev();
Name_Map name_map_S468C6[] = {
  NSPAIR(_ZN6S468C6C1Ev),
  NSPAIR(_ZN6S468C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S468C6[];
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY vtc_S468C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S468C6[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
Class_Descriptor cd_S468C6 = {  "S468C6", // class name
  0,0,//no base classes
  &(vtc_S468C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6240,4076), // object size
  NSPAIRA(_ZTI6S468C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S468C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C8  {
  char s468c8f0;
  __tsi64 s468c8f1[10];
  long double s468c8f2;
  ::S468C5 s468c8f3;
  void *s468c8f4;
  short s468c8f5;
  void *s468c8f6;
  int s468c8f7;
  virtual void  v4(); // _ZN6S468C82v4Ev
  virtual void  v5(); // _ZN6S468C82v5Ev
  ~S468C8(); // tgen
  S468C8(); // tgen
};
//SIG(-1 S468C8) C1{ v1 v2 Fc FL[10] FD FC2{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi}


void  S468C8 ::v4(){vfunc_called(this, "_ZN6S468C82v4Ev");}
void  S468C8 ::v5(){vfunc_called(this, "_ZN6S468C82v5Ev");}
S468C8 ::~S468C8(){ note_dtor("S468C8", this);} // tgen
S468C8 ::S468C8(){ note_ctor("S468C8", this);} // tgen

static void Test_S468C8()
{
  extern Class_Descriptor cd_S468C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(29,80)];
    init_test(&cd_S468C8, buf);
    S468C8 *dp, &lv = *(dp=new (buf) S468C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,316), "sizeof(S468C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C8)");
    check_field_offset(lv, s468c8f0, ABISELECT(8,4), "S468C8.s468c8f0");
    check_field_offset(lv, s468c8f1, ABISELECT(16,8), "S468C8.s468c8f1");
    check_field_offset(lv, s468c8f2, ABISELECT(96,88), "S468C8.s468c8f2");
    check_field_offset(lv, s468c8f3, ABISELECT(112,100), "S468C8.s468c8f3");
    check_field_offset(lv, s468c8f4, ABISELECT(416,300), "S468C8.s468c8f4");
    check_field_offset(lv, s468c8f5, ABISELECT(424,304), "S468C8.s468c8f5");
    check_field_offset(lv, s468c8f6, ABISELECT(432,308), "S468C8.s468c8f6");
    check_field_offset(lv, s468c8f7, ABISELECT(440,312), "S468C8.s468c8f7");
    test_class_info(&lv, &cd_S468C8);
    dp->~S468C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C8(Test_S468C8, "S468C8", ABISELECT(448,316));

#else // __cplusplus

extern void _ZN6S468C8C1Ev();
extern void _ZN6S468C8D1Ev();
Name_Map name_map_S468C8[] = {
  NSPAIR(_ZN6S468C8C1Ev),
  NSPAIR(_ZN6S468C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S468C8[];
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY vtc_S468C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S468C8[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
Class_Descriptor cd_S468C8 = {  "S468C8", // class name
  0,0,//no base classes
  &(vtc_S468C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(448,316), // object size
  NSPAIRA(_ZTI6S468C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S468C8),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C4  : S468C5 , virtual S468C6 , S468C7 , virtual S468C8 {
  __tsi64 s468c4f0:2;
  long double s468c4f1[7];
  void *s468c4f2;
  ::S468C6 s468c4f3;
  void *s468c4f4;
  int s468c4f5;
  void *s468c4f6[2];
  ::S468C7 s468c4f7;
  ::S468C5 s468c4f8;
  long double s468c4f9[8];
  virtual void  v6(); // _ZN6S468C42v6Ev
  ~S468C4(); // tgen
  S468C4(); // tgen
};
//SIG(-1 S468C4) C1{ BC2{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC3{ v4 FC2[8] FC2[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC2[5] Fp[5] FC2[5]} BC4 VBC5{ v5 v6 Fc FL[10] FD FC2 Fp Fs Fp Fi} v1 FL:2 FD[7] Fp FC3 Fp Fi Fp[2] FC4 FC2 FD[8]}


void  S468C4 ::v6(){vfunc_called(this, "_ZN6S468C42v6Ev");}
S468C4 ::~S468C4(){ note_dtor("S468C4", this);} // tgen
S468C4 ::S468C4(){ note_ctor("S468C4", this);} // tgen

static void Test_S468C4()
{
  extern Class_Descriptor cd_S468C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(875,2291)];
    init_test(&cd_S468C4, buf);
    S468C4 *dp, &lv = *(dp=new (buf) S468C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13984,9160), "sizeof(S468C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C4)");
    check_base_class_offset(lv, (S468C5*), 0, "S468C4");
    check_base_class_offset(lv, (S468C6*), ABISELECT(7296,4768), "S468C4");
    check_base_class_offset(lv, (S468C7*), ABISELECT(296,200), "S468C4");
    check_base_class_offset(lv, (S468C8*), ABISELECT(13536,8844), "S468C4");
    set_bf_and_test(lv, s468c4f0, ABISELECT(376,244), 0, 2, 1, "S468C4");
    set_bf_and_test(lv, s468c4f0, ABISELECT(376,244), 0, 2, hide_sll(1LL<<1), "S468C4");
    check_field_offset(lv, s468c4f1, ABISELECT(384,248), "S468C4.s468c4f1");
    check_field_offset(lv, s468c4f2, ABISELECT(496,332), "S468C4.s468c4f2");
    check_field_offset(lv, s468c4f3, ABISELECT(512,336), "S468C4.s468c4f3");
    check_field_offset(lv, s468c4f4, ABISELECT(6752,4412), "S468C4.s468c4f4");
    check_field_offset(lv, s468c4f5, ABISELECT(6760,4416), "S468C4.s468c4f5");
    check_field_offset(lv, s468c4f6, ABISELECT(6768,4420), "S468C4.s468c4f6");
    check_field_offset(lv, s468c4f7, ABISELECT(6784,4428), "S468C4.s468c4f7");
    check_field_offset(lv, s468c4f8, ABISELECT(6864,4472), "S468C4.s468c4f8");
    check_field_offset(lv, s468c4f9, ABISELECT(7168,4672), "S468C4.s468c4f9");
    test_class_info(&lv, &cd_S468C4);
    dp->~S468C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C4(Test_S468C4, "S468C4", ABISELECT(13984,9160));

#else // __cplusplus

extern void _ZN6S468C4C1Ev();
extern void _ZN6S468C4D1Ev();
Name_Map name_map_S468C4[] = {
  NSPAIR(_ZN6S468C4C1Ev),
  NSPAIR(_ZN6S468C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
static Base_Class bases_S468C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C6,    ABISELECT(7296,4768), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C8,    ABISELECT(13536,8844), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S468C4[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
extern void ABISELECT(_ZThn296_N6S468C4D1Ev,_ZThn200_N6S468C4D1Ev)();
extern void ABISELECT(_ZThn296_N6S468C4D0Ev,_ZThn200_N6S468C4D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY vtc_S468C4[] = {
  ABISELECT(13536,8844),
  ABISELECT(7296,4768),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C4D1Ev,_ZThn200_N6S468C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C4D0Ev,_ZThn200_N6S468C4D0Ev),
  0,
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-13536,-8844),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern VTBL_ENTRY _ZTV6S468C4[];
static  VTT_ENTRY vtt_S468C4[] = {
  {&(_ZTV6S468C4[4]),  4,23},
  {&(_ZTV6S468C4[16]),  16,23},
  {&(_ZTV6S468C4[21]),  21,23},
};
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
Class_Descriptor cd_S468C4 = {  "S468C4", // class name
  bases_S468C4, 4,
  &(vtc_S468C4[0]), // expected_vtbl_contents
  &(vtt_S468C4[0]), // expected_vtt_contents
  ABISELECT(13984,9160), // object size
  NSPAIRA(_ZTI6S468C4),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV6S468C4),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S468C4),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C3  : S468C4 , S468C8 , S468C7 , S468C6 , virtual S468C5 {
  ::S468C7 s468c3f0;
  int s468c3f1;
  void *s468c3f2[2];
  __tsi64 s468c3f3[2];
  int s468c3f4[2];
  void *s468c3f5;
  int s468c3f6;
  ::S468C8 s468c3f7;
  int s468c3f8;
  virtual  ~S468C3(); // _ZN6S468C3D2Ev
  virtual void  v7(); // _ZN6S468C32v7Ev
  virtual void  v8(); // _ZN6S468C32v8Ev
  S468C3(); // tgen
};
//SIG(-1 S468C3) C1{ BC2{ BC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC4{ v5 FC3[8] FC3[2] Fp Fi FC5{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC5 VBC6{ v6 v7 Fc FL[10] FD FC3 Fp Fs Fp Fi} v8 FL:2 FD[7] Fp FC4 Fp Fi Fp[2] FC5 FC3 FD[8]} BC6 BC5 BC4 VBC3 vd v1 v2 FC5 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}


 S468C3 ::~S468C3(){ note_dtor("S468C3", this);}
void  S468C3 ::v7(){vfunc_called(this, "_ZN6S468C32v7Ev");}
void  S468C3 ::v8(){vfunc_called(this, "_ZN6S468C32v8Ev");}
S468C3 ::S468C3(){ note_ctor("S468C3", this);} // tgen

static void Test_S468C3()
{
  extern Class_Descriptor cd_S468C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1355,3552)];
    init_test(&cd_S468C3, buf);
    S468C3 *dp, &lv = *(dp=new (buf) S468C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(21664,14204), "sizeof(S468C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C3)");
    check_base_class_offset(lv, (S468C5*)(S468C4*), 0, "S468C3");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(14672,9612), "S468C3");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(296,200), "S468C3");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(20912,13688), "S468C3");
    check_base_class_offset(lv, (S468C4*), 0, "S468C3");
    /*is_ambiguous_... S468C3::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*), ABISELECT(7296,4768), "S468C3");
    /*is_ambiguous_... S468C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), ABISELECT(7744,5084), "S468C3");
    /*is_ambiguous_... S468C3::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*), ABISELECT(7824,5128), "S468C3");
    /*is_ambiguous_... S468C3::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*), ABISELECT(21360,14004), "S468C3");
    check_field_offset(lv, s468c3f0, ABISELECT(14064,9204), "S468C3.s468c3f0");
    check_field_offset(lv, s468c3f1, ABISELECT(14144,9248), "S468C3.s468c3f1");
    check_field_offset(lv, s468c3f2, ABISELECT(14152,9252), "S468C3.s468c3f2");
    check_field_offset(lv, s468c3f3, ABISELECT(14168,9260), "S468C3.s468c3f3");
    check_field_offset(lv, s468c3f4, ABISELECT(14184,9276), "S468C3.s468c3f4");
    check_field_offset(lv, s468c3f5, ABISELECT(14192,9284), "S468C3.s468c3f5");
    check_field_offset(lv, s468c3f6, ABISELECT(14200,9288), "S468C3.s468c3f6");
    check_field_offset(lv, s468c3f7, ABISELECT(14208,9292), "S468C3.s468c3f7");
    check_field_offset(lv, s468c3f8, ABISELECT(14656,9608), "S468C3.s468c3f8");
    test_class_info(&lv, &cd_S468C3);
    dp->~S468C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C3(Test_S468C3, "S468C3", ABISELECT(21664,14204));

#else // __cplusplus

extern void _ZN6S468C3C1Ev();
extern void _ZN6S468C3D2Ev();
Name_Map name_map_S468C3[] = {
  NSPAIR(_ZN6S468C3C1Ev),
  NSPAIR(_ZN6S468C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
static Base_Class bases_S468C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(14672,9612), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(20912,13688), //bcp->offset
    31, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C8,    ABISELECT(7296,4768), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C6,    ABISELECT(7824,5128), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(21360,14004), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S468C3[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C3D1Ev();
extern void _ZN6S468C3D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
extern void ABISELECT(_ZThn296_N6S468C3D1Ev,_ZThn200_N6S468C3D1Ev)();
extern void ABISELECT(_ZThn296_N6S468C3D0Ev,_ZThn200_N6S468C3D0Ev)();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S468C3D1Ev,_ZThn5084_N6S468C3D1Ev)();
extern void ABISELECT(_ZThn7744_N6S468C3D0Ev,_ZThn5084_N6S468C3D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY vtc_S468C3[] = {
  ABISELECT(21360,14004),
  ABISELECT(20912,13688),
  ABISELECT(14672,9612),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C3D1Ev,
  (VTBL_ENTRY)&_ZN6S468C3D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C3D1Ev,_ZThn200_N6S468C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C3D0Ev,_ZThn200_N6S468C3D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C3D1Ev,_ZThn5084_N6S468C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C3D0Ev,_ZThn5084_N6S468C3D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-20912,-13688),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  0,
  0,
  ABISELECT(-21360,-14004),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern VTBL_ENTRY _ZTV6S468C3[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__6S468C3[] = {
  ABISELECT(20912,13688),
  ABISELECT(14672,9612),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__6S468C3[] = {
  0,
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__6S468C3[] = {
  0,
  0,
  ABISELECT(-20912,-13688),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C3[] = {
  {&(_ZTV6S468C3[5]),  5,43},
  {&(_tg__ZTV6S468C4__6S468C3[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__6S468C3[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__6S468C3[4]),  4,6},
  {&(_ZTV6S468C3[30]),  30,43},
  {&(_ZTV6S468C3[35]),  35,43},
  {&(_ZTV6S468C3[41]),  41,43},
};
extern VTBL_ENTRY _ZTI6S468C3[];
extern  VTBL_ENTRY _ZTV6S468C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C3[];
Class_Descriptor cd_S468C3 = {  "S468C3", // class name
  bases_S468C3, 9,
  &(vtc_S468C3[0]), // expected_vtbl_contents
  &(vtt_S468C3[0]), // expected_vtt_contents
  ABISELECT(21664,14204), // object size
  NSPAIRA(_ZTI6S468C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV6S468C3),43, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S468C3),7, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S468C10  {
  __tsi64 s468c10f0;
  long double s468c10f1[10];
  long double s468c10f2;
  short  :0;
  void  mf468c10(); // _ZN7S468C108mf468c10Ev
};
//SIG(1 S468C10) U1{ m FL FD[10] FD Fs:0}

#endif // __cplusplus
#ifdef __cplusplus

struct  S468C9  {
  int s468c9f0;
  ::S468C5 s468c9f1;
  int s468c9f2[2];
  ::S468C10 s468c9f3;
  long double s468c9f4;
  int s468c9f5;
  int s468c9f6;
  ::S468C8 s468c9f7;
  __tsi64 s468c9f8;
  int s468c9f9;
  ::S468C8 s468c9f10;
  virtual  ~S468C9(); // _ZN6S468C9D1Ev
  virtual void  v9(); // _ZN6S468C92v9Ev
  virtual void  v10(); // _ZN6S468C93v10Ev
  S468C9(); // tgen
};
//SIG(-1 S468C9) C1{ vd v1 v2 Fi FC2{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fi[2] FU3{ m FL FD[10] FD Fs:0} FD Fi Fi FC4{ v5 v6 Fc FL[10] FD FC2 Fp Fs Fp Fi} FL Fi FC4}


 S468C9 ::~S468C9(){ note_dtor("S468C9", this);}
void  S468C9 ::v9(){vfunc_called(this, "_ZN6S468C92v9Ev");}
void  S468C9 ::v10(){vfunc_called(this, "_ZN6S468C93v10Ev");}
S468C9 ::S468C9(){ note_ctor("S468C9", this);} // tgen

static void Test_S468C9()
{
  extern Class_Descriptor cd_S468C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(91,251)];
    init_test(&cd_S468C9, buf);
    S468C9 *dp, &lv = *(dp=new (buf) S468C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1440,1000), "sizeof(S468C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C9)");
    check_field_offset(lv, s468c9f0, ABISELECT(8,4), "S468C9.s468c9f0");
    check_field_offset(lv, s468c9f1, ABISELECT(16,8), "S468C9.s468c9f1");
    check_field_offset(lv, s468c9f2, ABISELECT(320,208), "S468C9.s468c9f2");
    check_field_offset(lv, s468c9f3, ABISELECT(336,216), "S468C9.s468c9f3");
    check_field_offset(lv, s468c9f4, ABISELECT(496,336), "S468C9.s468c9f4");
    check_field_offset(lv, s468c9f5, ABISELECT(512,348), "S468C9.s468c9f5");
    check_field_offset(lv, s468c9f6, ABISELECT(516,352), "S468C9.s468c9f6");
    check_field_offset(lv, s468c9f7, ABISELECT(528,356), "S468C9.s468c9f7");
    check_field_offset(lv, s468c9f8, ABISELECT(976,672), "S468C9.s468c9f8");
    check_field_offset(lv, s468c9f9, ABISELECT(984,680), "S468C9.s468c9f9");
    check_field_offset(lv, s468c9f10, ABISELECT(992,684), "S468C9.s468c9f10");
    test_class_info(&lv, &cd_S468C9);
    dp->~S468C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C9(Test_S468C9, "S468C9", ABISELECT(1440,1000));

#else // __cplusplus

extern void _ZN6S468C9C1Ev();
extern void _ZN6S468C9D1Ev();
Name_Map name_map_S468C9[] = {
  NSPAIR(_ZN6S468C9C1Ev),
  NSPAIR(_ZN6S468C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S468C9[];
extern void _ZN6S468C9D1Ev();
extern void _ZN6S468C9D0Ev();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
static  VTBL_ENTRY vtc_S468C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S468C9[0]),
  (VTBL_ENTRY)&_ZN6S468C9D1Ev,
  (VTBL_ENTRY)&_ZN6S468C9D0Ev,
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
};
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
Class_Descriptor cd_S468C9 = {  "S468C9", // class name
  0,0,//no base classes
  &(vtc_S468C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1440,1000), // object size
  NSPAIRA(_ZTI6S468C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S468C9),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C13  : virtual S468C6 , virtual S468C8 , virtual S468C4 , S468C7 {
  void *s468c13f0;
  ::S468C7 s468c13f1;
  ::S468C5 s468c13f2;
  short s468c13f3;
  ~S468C13(); // tgen
  S468C13(); // tgen
};
//SIG(-1 S468C13) C1{ VBC2{ v1 FC3{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} VBC5{ v2 v3 Fc FL[10] FD FC3 Fp Fs Fp Fi} VBC6{ BC3 VBC2 BC4 VBC5 v6 FL:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} BC4 Fp FC4 FC3 Fs}


S468C13 ::~S468C13(){ note_dtor("S468C13", this);} // tgen
S468C13 ::S468C13(){ note_ctor("S468C13", this);} // tgen

static void Test_S468C13()
{
  extern Class_Descriptor cd_S468C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(906,2365)];
    init_test(&cd_S468C13, buf);
    S468C13 *dp, &lv = *(dp=new (buf) S468C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14480,9456), "sizeof(S468C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C13)");
    check_base_class_offset(lv, (S468C6*), ABISELECT(496,296), "S468C13");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(496,296), "S468C13");
    check_base_class_offset(lv, (S468C8*), ABISELECT(6736,4372), "S468C13");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(6736,4372), "S468C13");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(7184,4688), "S468C13");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(7480,4888), "S468C13");
    check_base_class_offset(lv, (S468C4*), ABISELECT(7184,4688), "S468C13");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), 0, "S468C13");
    check_field_offset(lv, s468c13f0, ABISELECT(80,44), "S468C13.s468c13f0");
    check_field_offset(lv, s468c13f1, ABISELECT(88,48), "S468C13.s468c13f1");
    check_field_offset(lv, s468c13f2, ABISELECT(176,92), "S468C13.s468c13f2");
    check_field_offset(lv, s468c13f3, ABISELECT(480,292), "S468C13.s468c13f3");
    test_class_info(&lv, &cd_S468C13);
    dp->~S468C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C13(Test_S468C13, "S468C13", ABISELECT(14480,9456));

#else // __cplusplus

extern void _ZN7S468C13C1Ev();
extern void _ZN7S468C13D1Ev();
Name_Map name_map_S468C13[] = {
  NSPAIR(_ZN7S468C13C1Ev),
  NSPAIR(_ZN7S468C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
static Base_Class bases_S468C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    ABISELECT(496,296), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C8,    ABISELECT(6736,4372), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C5,    ABISELECT(7184,4688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7480,4888), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(7184,4688), //bcp->offset
    17, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C13[];
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZThn7184_N7S468C13D1Ev,_ZThn4688_N7S468C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
extern void ABISELECT(_ZThn7184_N7S468C13D0Ev,_ZThn4688_N7S468C13D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY vtc_S468C13[] = {
  ABISELECT(7184,4688),
  ABISELECT(6736,4372),
  ABISELECT(496,296),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
  0,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-6736,-4372),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-7184,-4688),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-7184,-4688),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
  ABISELECT(-7480,-4888),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern VTBL_ENTRY _ZTV7S468C13[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C13[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C13[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C13[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C13[] = {
  {&(_ZTV7S468C13[5]),  5,34},
  {&(_ZTV7S468C13[10]),  10,34},
  {&(_ZTV7S468C13[15]),  15,34},
  {&(_ZTV7S468C13[25]),  25,34},
  {&(_ZTV7S468C13[32]),  32,34},
  {&(_tg__ZTV6S468C4__7S468C13[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C13[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C13[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7184_N7S468C13D0Ev,_ZThn4688_N7S468C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7184_N7S468C13D1Ev,_ZThn4688_N7S468C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C13 = {  "S468C13", // class name
  bases_S468C13, 6,
  &(vtc_S468C13[0]), // expected_vtbl_contents
  &(vtt_S468C13[0]), // expected_vtt_contents
  ABISELECT(14480,9456), // object size
  NSPAIRA(_ZTI7S468C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S468C13),34, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C13),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C12  : S468C13 , S468C5 , S468C9 {
  ::S468C3 s468c12f0;
  ~S468C12(); // tgen
  S468C12(); // tgen
};
//SIG(-1 S468C12) C1{ BC2{ VBC3{ v1 FC4{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC4[2] Fp Fi FC5{ vd m Fp FL Fp[7]} FC4[5] Fp[5] FC4[5]} VBC6{ v2 v3 Fc FL[10] FD FC4 Fp Fs Fp Fi} VBC7{ BC4 VBC3 BC5 VBC6 v6 FL:2 FD[7] Fp FC3 Fp Fi Fp[2] FC5 FC4 FD[8]} BC5 Fp FC5 FC4 Fs} BC4 BC8{ vd v7 v8 Fi FC4 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC6 FL Fi FC6} FC10{ BC7 BC6 BC5 BC3 VBC4 vd v9 v10 FC5 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}}


S468C12 ::~S468C12(){ note_dtor("S468C12", this);} // tgen
S468C12 ::S468C12(){ note_ctor("S468C12", this);} // tgen

static void Test_S468C12()
{
  extern Class_Descriptor cd_S468C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2369,6216)];
    init_test(&cd_S468C12, buf);
    S468C12 *dp, &lv = *(dp=new (buf) S468C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(37888,24860), "sizeof(S468C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C12)");
    check_base_class_offset(lv, (S468C6*)(S468C13*), ABISELECT(23904,15700), "S468C12");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(23904,15700), "S468C12");
    check_base_class_offset(lv, (S468C8*)(S468C13*), ABISELECT(30144,19776), "S468C12");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(30144,19776), "S468C12");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(30592,20092), "S468C12");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(30888,20292), "S468C12");
    check_base_class_offset(lv, (S468C4*)(S468C13*), ABISELECT(30592,20092), "S468C12");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*), 0, "S468C12");
    check_base_class_offset(lv, (S468C13*), 0, "S468C12");
    /*is_ambiguous_... S468C12::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*), ABISELECT(496,296), "S468C12");
    check_base_class_offset(lv, (S468C9*), ABISELECT(800,496), "S468C12");
    check_field_offset(lv, s468c12f0, ABISELECT(2240,1496), "S468C12.s468c12f0");
    test_class_info(&lv, &cd_S468C12);
    dp->~S468C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C12(Test_S468C12, "S468C12", ABISELECT(37888,24860));

#else // __cplusplus

extern void _ZN7S468C12C1Ev();
extern void _ZN7S468C12D1Ev();
Name_Map name_map_S468C12[] = {
  NSPAIR(_ZN7S468C12C1Ev),
  NSPAIR(_ZN7S468C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
static Base_Class bases_S468C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    ABISELECT(23904,15700), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C8,    ABISELECT(30144,19776), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C5,    ABISELECT(30592,20092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(30888,20292), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(30592,20092), //bcp->offset
    27, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(496,296), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C9,    ABISELECT(800,496), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C12[];
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZThn800_N7S468C12D1Ev,_ZThn496_N7S468C12D1Ev)();
extern void ABISELECT(_ZThn800_N7S468C12D0Ev,_ZThn496_N7S468C12D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZThn30592_N7S468C12D1Ev,_ZThn20092_N7S468C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
extern void ABISELECT(_ZThn30592_N7S468C12D0Ev,_ZThn20092_N7S468C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY vtc_S468C12[] = {
  ABISELECT(30592,20092),
  ABISELECT(30144,19776),
  ABISELECT(23904,15700),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-800,-496),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S468C12D1Ev,_ZThn496_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S468C12D0Ev,_ZThn496_N7S468C12D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  0,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-30144,-19776),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-30592,-20092),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-30592,-20092),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
  ABISELECT(-30888,-20292),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
extern VTBL_ENTRY _ZTV7S468C12[];
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C13__7S468C12[] = {
  ABISELECT(30592,20092),
  ABISELECT(30144,19776),
  ABISELECT(23904,15700),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C13__7S468C12[] = {
  0,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C13__7S468C12[] = {
  0,
  0,
  ABISELECT(-30144,-19776),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZThn30592_N7S468C13D1Ev,_ZThn20092_N7S468C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
extern void ABISELECT(_ZThn30592_N7S468C13D0Ev,_ZThn20092_N7S468C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C13__7S468C12[] = {
  ABISELECT(-30592,-20092),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-30592,-20092),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C13__7S468C12[] = {
  ABISELECT(-30888,-20292),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C12[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C12[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C12[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C12[] = {
  {&(_ZTV7S468C12[5]),  5,44},
  {&(_tg__ZTV7S468C13__7S468C12[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C13__7S468C12[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C13__7S468C12[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C13__7S468C12[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C13__7S468C12[2]),  2,4},
  {&(_ZTV7S468C12[20]),  20,44},
  {&(_ZTV7S468C12[25]),  25,44},
  {&(_ZTV7S468C12[35]),  35,44},
  {&(_ZTV7S468C12[42]),  42,44},
  {&(_tg__ZTV6S468C4__7S468C12[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C12[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S468C13D0Ev,_ZThn20092_N7S468C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S468C13D1Ev,_ZThn20092_N7S468C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S468C12D0Ev,_ZThn20092_N7S468C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S468C12D1Ev,_ZThn20092_N7S468C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C12 = {  "S468C12", // class name
  bases_S468C12, 9,
  &(vtc_S468C12[0]), // expected_vtbl_contents
  &(vtt_S468C12[0]), // expected_vtt_contents
  ABISELECT(37888,24860), // object size
  NSPAIRA(_ZTI7S468C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S468C12),44, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C12),13, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C14_nt  {
  char s468c14f0;
  void  mf468c14(); // _ZN10S468C14_nt8mf468c14Ev
};
//SIG(-1 S468C14_nt) C1{ m Fc}


void  S468C14_nt ::mf468c14(){}

//skip512 S468C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C11  : S468C12 , virtual S468C5 , S468C7 , S468C9 {
  ::S468C14_nt s468c11f0;
  int s468c11f1;
  int s468c11f2;
  int s468c11f3:6;
  ::S468C14_nt s468c11f4;
  int s468c11f5;
  ~S468C11(); // tgen
  S468C11(); // tgen
};
//SIG(-1 S468C11) C1{ BC2{ BC3{ VBC4{ v1 FC5{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC5[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} VBC7{ v2 v3 Fc FL[10] FD FC5 Fp Fs Fp Fi} VBC8{ BC5 VBC4 BC6 VBC7 v6 FL:2 FD[7] Fp FC4 Fp Fi Fp[2] FC6 FC5 FD[8]} BC6 Fp FC6 FC5 Fs} BC5 BC9{ vd v7 v8 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} FC11{ BC8 BC7 BC6 BC4 VBC5 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi}} VBC5 BC6 BC9 FC12{ m Fc} Fi Fi Fi:6 FC12 Fi}


S468C11 ::~S468C11(){ note_dtor("S468C11", this);} // tgen
S468C11 ::S468C11(){ note_ctor("S468C11", this);} // tgen

static void Test_S468C11()
{
  extern Class_Descriptor cd_S468C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2485,6532)];
    init_test(&cd_S468C11, buf);
    S468C11 *dp, &lv = *(dp=new (buf) S468C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(39744,26124), "sizeof(S468C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C11)");
    check_base_class_offset(lv, (S468C6*)(S468C13*)(S468C12*), ABISELECT(25456,16764), "S468C11");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(25456,16764), "S468C11");
    check_base_class_offset(lv, (S468C8*)(S468C13*)(S468C12*), ABISELECT(31696,20840), "S468C11");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(31696,20840), "S468C11");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(32144,21156), "S468C11");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(32440,21356), "S468C11");
    check_base_class_offset(lv, (S468C4*)(S468C13*)(S468C12*), ABISELECT(32144,21156), "S468C11");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*)(S468C12*), 0, "S468C11");
    check_base_class_offset(lv, (S468C13*)(S468C12*), 0, "S468C11");
    /*is_ambiguous_... S468C12::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C12*), ABISELECT(496,296), "S468C11");
    check_base_class_offset(lv, (S468C9*)(S468C12*), ABISELECT(800,496), "S468C11");
    check_base_class_offset(lv, (S468C12*), 0, "S468C11");
    /*is_ambiguous_... S468C11::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*), ABISELECT(39440,25924), "S468C11");
    /*is_ambiguous_... S468C11::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), ABISELECT(23904,15700), "S468C11");
    /*is_ambiguous_... S468C11::S468C9 */ AMB_check_base_class_offset(lv, (S468C9*), ABISELECT(23984,15744), "S468C11");
    check_field_offset(lv, s468c11f0, ABISELECT(25424,16744), "S468C11.s468c11f0");
    check_field_offset(lv, s468c11f1, ABISELECT(25428,16748), "S468C11.s468c11f1");
    check_field_offset(lv, s468c11f2, ABISELECT(25432,16752), "S468C11.s468c11f2");
    set_bf_and_test(lv, s468c11f3, ABISELECT(25436,16756), 0, 6, 1, "S468C11");
    set_bf_and_test(lv, s468c11f3, ABISELECT(25436,16756), 0, 6, hide_sll(1LL<<5), "S468C11");
    check_field_offset(lv, s468c11f4, ABISELECT(25437,16757), "S468C11.s468c11f4");
    check_field_offset(lv, s468c11f5, ABISELECT(25440,16760), "S468C11.s468c11f5");
    test_class_info(&lv, &cd_S468C11);
    dp->~S468C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C11(Test_S468C11, "S468C11", ABISELECT(39744,26124));

#else // __cplusplus

extern void _ZN7S468C11C1Ev();
extern void _ZN7S468C11D1Ev();
Name_Map name_map_S468C11[] = {
  NSPAIR(_ZN7S468C11C1Ev),
  NSPAIR(_ZN7S468C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C12;
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
static Base_Class bases_S468C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    ABISELECT(25456,16764), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C8,    ABISELECT(31696,20840), //bcp->offset
    32, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C5,    ABISELECT(32144,21156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(32440,21356), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(32144,21156), //bcp->offset
    38, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(496,296), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(800,496), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(39440,25924), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(23904,15700), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C9,    ABISELECT(23984,15744), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C11[];
extern void _ZN7S468C11D1Ev();
extern void _ZN7S468C11D0Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZThn800_N7S468C11D1Ev,_ZThn496_N7S468C11D1Ev)();
extern void ABISELECT(_ZThn800_N7S468C11D0Ev,_ZThn496_N7S468C11D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void ABISELECT(_ZThn23904_N7S468C11D1Ev,_ZThn15700_N7S468C11D1Ev)();
extern void ABISELECT(_ZThn23904_N7S468C11D0Ev,_ZThn15700_N7S468C11D0Ev)();
extern void ABISELECT(_ZThn23984_N7S468C11D1Ev,_ZThn15744_N7S468C11D1Ev)();
extern void ABISELECT(_ZThn23984_N7S468C11D0Ev,_ZThn15744_N7S468C11D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C11D1Ev,_ZTv0_n32_N7S468C11D1Ev)();
extern void ABISELECT(_ZThn32144_N7S468C11D1Ev,_ZThn21156_N7S468C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C11D0Ev,_ZTv0_n32_N7S468C11D0Ev)();
extern void ABISELECT(_ZThn32144_N7S468C11D0Ev,_ZThn21156_N7S468C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C11D1Ev,_ZTvn200_n32_N7S468C11D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C11D0Ev,_ZTvn200_n32_N7S468C11D0Ev)();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY vtc_S468C11[] = {
  ABISELECT(39440,25924),
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN7S468C11D1Ev,
  (VTBL_ENTRY)&_ZN7S468C11D0Ev,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-800,-496),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S468C11D1Ev,_ZThn496_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S468C11D0Ev,_ZThn496_N7S468C11D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn23904_N7S468C11D1Ev,_ZThn15700_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn23904_N7S468C11D0Ev,_ZThn15700_N7S468C11D0Ev),
  ABISELECT(-23984,-15744),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn23984_N7S468C11D1Ev,_ZThn15744_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn23984_N7S468C11D0Ev,_ZThn15744_N7S468C11D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C11D1Ev,_ZTv0_n32_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C11D0Ev,_ZTv0_n32_N7S468C11D0Ev),
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C11D1Ev,_ZTvn200_n32_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C11D0Ev,_ZTvn200_n32_N7S468C11D0Ev),
  0,
  0,
  ABISELECT(-39440,-25924),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S468C11[];
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C12__7S468C11[] = {
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
};
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C137S468C12__7S468C11[] = {
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C137S468C12__7S468C11[] = {
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C137S468C12__7S468C11[] = {
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZThn32144_N7S468C13D1Ev,_ZThn21156_N7S468C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
extern void ABISELECT(_ZThn32144_N7S468C13D0Ev,_ZThn21156_N7S468C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C137S468C12__7S468C11[] = {
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C137S468C12__7S468C11[] = {
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C12__7S468C11[] = {
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C12__7S468C11[] = {
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZThn32144_N7S468C12D1Ev,_ZThn21156_N7S468C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
extern void ABISELECT(_ZThn32144_N7S468C12D0Ev,_ZThn21156_N7S468C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C12__7S468C11[] = {
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C12__7S468C11[] = {
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C11[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C11[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C11[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C11[] = {
  {&(_ZTV7S468C11[6]),  6,61},
  {&(_tg__ZTV7S468C12__7S468C11[5]),  5,7},
  {&(_tg__ZTV7S468C137S468C12__7S468C11[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C137S468C12__7S468C11[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C137S468C12__7S468C11[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C137S468C12__7S468C11[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C137S468C12__7S468C11[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C12__7S468C11[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C12__7S468C11[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C12__7S468C11[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C12__7S468C11[2]),  2,4},
  {&(_ZTV7S468C11[31]),  31,61},
  {&(_ZTV7S468C11[36]),  36,61},
  {&(_ZTV7S468C11[46]),  46,61},
  {&(_ZTV7S468C11[53]),  53,61},
  {&(_ZTV7S468C11[59]),  59,61},
  {&(_tg__ZTV6S468C4__7S468C11[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C11[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C11[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S468C11[];
extern  VTBL_ENTRY _ZTV7S468C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C11[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C12D0Ev,_ZThn21156_N7S468C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C12D1Ev,_ZThn21156_N7S468C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C13D0Ev,_ZThn21156_N7S468C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C13D1Ev,_ZThn21156_N7S468C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C11D0Ev,_ZTv0_n32_N7S468C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C11D0Ev,_ZThn21156_N7S468C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C11D1Ev,_ZTv0_n32_N7S468C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S468C11D1Ev,_ZThn21156_N7S468C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C11 = {  "S468C11", // class name
  bases_S468C11, 13,
  &(vtc_S468C11[0]), // expected_vtbl_contents
  &(vtt_S468C11[0]), // expected_vtt_contents
  ABISELECT(39744,26124), // object size
  NSPAIRA(_ZTI7S468C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S468C11),61, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C11),19, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C2  : S468C3 , S468C4 , virtual S468C9 {
  void *s468c2f0;
  long double s468c2f1;
  long double s468c2f2;
  ::S468C11 s468c2f3;
  virtual  ~S468C2(); // _ZN6S468C2D2Ev
  virtual void  v11(); // _ZN6S468C23v11Ev
  S468C2(); // tgen
};
//SIG(-1 S468C2) C1{ BC2{ BC3{ BC4{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC5{ v4 FC4[8] FC4[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC4[5] Fp[5] FC4[5]} BC6 VBC7{ v5 v6 Fc FL[10] FD FC4 Fp Fs Fp Fi} v7 FL:2 FD[7] Fp FC5 Fp Fi Fp[2] FC6 FC4 FD[8]} BC7 BC6 BC5 VBC4 vd v8 v9 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi} BC3 VBC8{ vd v10 v11 Fi FC4 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} vd v1 Fp FD FD FC10{ BC11{ BC12{ VBC5 VBC7 VBC3 BC6 Fp FC6 FC4 Fs} BC4 BC8 FC2} VBC4 BC6 BC8 FC13{ m Fc} Fi Fi Fi:6 FC13 Fi}}


 S468C2 ::~S468C2(){ note_dtor("S468C2", this);}
void  S468C2 ::v11(){vfunc_called(this, "_ZN6S468C23v11Ev");}
S468C2 ::S468C2(){ note_ctor("S468C2", this);} // tgen

static void Test_S468C2()
{
  extern Class_Descriptor cd_S468C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4388,11532)];
    init_test(&cd_S468C2, buf);
    S468C2 *dp, &lv = *(dp=new (buf) S468C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(70192,46124), "sizeof(S468C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C2)");
    check_base_class_offset(lv, (S468C5*)(S468C4*)(S468C3*), 0, "S468C2");
    check_base_class_offset(lv, (S468C6*)(S468C4*)(S468C3*), ABISELECT(61760,40532), "S468C2");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(61760,40532), "S468C2");
    check_base_class_offset(lv, (S468C7*)(S468C4*)(S468C3*), ABISELECT(296,200), "S468C2");
    check_base_class_offset(lv, (S468C8*)(S468C4*)(S468C3*), ABISELECT(68000,44608), "S468C2");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(68000,44608), "S468C2");
    check_base_class_offset(lv, (S468C4*)(S468C3*), 0, "S468C2");
    /*is_ambiguous_... S468C3::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C3*), ABISELECT(7296,4768), "S468C2");
    /*is_ambiguous_... S468C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C3*), ABISELECT(7744,5084), "S468C2");
    /*is_ambiguous_... S468C3::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C3*), ABISELECT(7824,5128), "S468C2");
    /*is_ambiguous_... S468C3::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C3*), ABISELECT(68448,44924), "S468C2");
    check_base_class_offset(lv, (S468C3*), 0, "S468C2");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(14672,9612), "S468C2");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(14968,9812), "S468C2");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C4*), ABISELECT(14672,9612), "S468C2");
    check_base_class_offset(lv, (S468C9*), ABISELECT(68752,45124), "S468C2");
    check_field_offset(lv, s468c2f0, ABISELECT(21968,14380), "S468C2.s468c2f0");
    check_field_offset(lv, s468c2f1, ABISELECT(21984,14384), "S468C2.s468c2f1");
    check_field_offset(lv, s468c2f2, ABISELECT(22000,14396), "S468C2.s468c2f2");
    check_field_offset(lv, s468c2f3, ABISELECT(22016,14408), "S468C2.s468c2f3");
    test_class_info(&lv, &cd_S468C2);
    dp->~S468C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C2(Test_S468C2, "S468C2", ABISELECT(70192,46124));

#else // __cplusplus

extern void _ZN6S468C2C1Ev();
extern void _ZN6S468C2D2Ev();
Name_Map name_map_S468C2[] = {
  NSPAIR(_ZN6S468C2C1Ev),
  NSPAIR(_ZN6S468C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C3;
extern VTBL_ENTRY _ZTI6S468C3[];
extern  VTBL_ENTRY _ZTV6S468C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C3[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
static Base_Class bases_S468C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(61760,40532), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(68000,44608), //bcp->offset
    46, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(7296,4768), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(7824,5128), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(68448,44924), //bcp->offset
    52, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S468C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(14672,9612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(14968,9812), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(14672,9612), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C9,    ABISELECT(68752,45124), //bcp->offset
    58, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S468C2[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C2D1Ev();
extern void _ZN6S468C2D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
extern void _ZN6S468C23v11Ev();
extern void ABISELECT(_ZThn296_N6S468C2D1Ev,_ZThn200_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn296_N6S468C2D0Ev,_ZThn200_N6S468C2D0Ev)();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S468C2D1Ev,_ZThn5084_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn7744_N6S468C2D0Ev,_ZThn5084_N6S468C2D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S468C2D1Ev,_ZThn9612_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn14672_N6S468C2D0Ev,_ZThn9612_N6S468C2D0Ev)();
extern void ABISELECT(_ZThn14968_N6S468C2D1Ev,_ZThn9812_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn14968_N6S468C2D0Ev,_ZThn9812_N6S468C2D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn68752_N6S468C2D1Ev,_ZThn45124_N6S468C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev)();
extern void ABISELECT(_ZThn68752_N6S468C2D0Ev,_ZThn45124_N6S468C2D0Ev)() __attribute__((weak));
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
static  VTBL_ENTRY vtc_S468C2[] = {
  ABISELECT(68752,45124),
  ABISELECT(68448,44924),
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C2D1Ev,
  (VTBL_ENTRY)&_ZN6S468C2D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
  (VTBL_ENTRY)&_ZN6S468C23v11Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C2D1Ev,_ZThn200_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C2D0Ev,_ZThn200_N6S468C2D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C2D1Ev,_ZThn5084_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C2D0Ev,_ZThn5084_N6S468C2D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  ABISELECT(53328,34996),
  ABISELECT(47088,30920),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C2D1Ev,_ZThn9612_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C2D0Ev,_ZThn9612_N6S468C2D0Ev),
  ABISELECT(-14968,-9812),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S468C2D1Ev,_ZThn9812_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S468C2D0Ev,_ZThn9812_N6S468C2D0Ev),
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  0,
  0,
  ABISELECT(-68448,-44924),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  0,
  0,
  ABISELECT(-68752,-45124),
  ABISELECT(-68752,-45124),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
};
extern VTBL_ENTRY _ZTV6S468C2[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C3D1Ev();
extern void _ZN6S468C3D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
static  VTBL_ENTRY _tg__ZTV6S468C3__6S468C2[] = {
  ABISELECT(68448,44924),
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C3D1Ev,
  (VTBL_ENTRY)&_ZN6S468C3D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C46S468C3__6S468C2[] = {
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C46S468C3__6S468C2[] = {
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C46S468C3__6S468C2[] = {
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C3__6S468C2[] = {
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C3__6S468C2[] = {
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__A1__6S468C3__6S468C2[] = {
  0,
  0,
  ABISELECT(-68448,-44924),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__A1__6S468C2[] = {
  ABISELECT(53328,34996),
  ABISELECT(47088,30920),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__A1__6S468C2[] = {
  0,
  ABISELECT(-47088,-30920),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__A1__6S468C2[] = {
  0,
  0,
  ABISELECT(-53328,-34996),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C2[] = {
  {&(_ZTV6S468C2[6]),  6,67},
  {&(_tg__ZTV6S468C3__6S468C2[5]),  5,12},
  {&(_tg__ZTV6S468C46S468C3__6S468C2[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C46S468C3__6S468C2[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C46S468C3__6S468C2[4]),  4,6},
  {&(_tg__ZTV6S468C6__6S468C3__6S468C2[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C3__6S468C2[4]),  4,6},
  {&(_tg__ZTV6S468C5__A1__6S468C3__6S468C2[4]),  4,6},
  {&(_tg__ZTV6S468C4__A1__6S468C2[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__A1__6S468C2[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__A1__6S468C2[4]),  4,6},
  {&(_ZTV6S468C2[45]),  45,67},
  {&(_ZTV6S468C2[50]),  50,67},
  {&(_ZTV6S468C2[56]),  56,67},
  {&(_ZTV6S468C2[33]),  33,67},
  {&(_ZTV6S468C2[63]),  63,67},
};
extern VTBL_ENTRY _ZTI6S468C2[];
extern  VTBL_ENTRY _ZTV6S468C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C2[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn68752_N6S468C2D0Ev,_ZThn45124_N6S468C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn68752_N6S468C2D1Ev,_ZThn45124_N6S468C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C2 = {  "S468C2", // class name
  bases_S468C2, 14,
  &(vtc_S468C2[0]), // expected_vtbl_contents
  &(vtt_S468C2[0]), // expected_vtt_contents
  ABISELECT(70192,46124), // object size
  NSPAIRA(_ZTI6S468C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S468C2),67, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S468C2),16, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C15  : S468C7 , S468C8 , S468C4 {
  void *s468c15f0;
  ::S468C4 s468c15f1;
  char s468c15f2[7];
  ::S468C9 s468c15f3;
  int s468c15f4;
  char s468c15f5[4];
  void *s468c15f6;
  ::S468C4 s468c15f7;
  int s468c15f8;
  int s468c15f9[7];
  int s468c15f10;
  ~S468C15(); // tgen
  S468C15(); // tgen
};
//SIG(-1 S468C15) C1{ BC2{ vd m Fp FL Fp[7]} BC3{ v1 v2 Fc FL[10] FD FC4{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi} BC5{ BC4 VBC6{ v5 FC4[8] FC4[2] Fp Fi FC2 FC4[5] Fp[5] FC4[5]} BC2 VBC3 v6 FL:2 FD[7] Fp FC6 Fp Fi Fp[2] FC2 FC4 FD[8]} Fp FC5 Fc[7] FC7{ vd v7 v8 Fi FC4 Fi[2] FU8{ m FL FD[10] FD Fs:0} FD Fi Fi FC3 FL Fi FC3} Fi Fc[4] Fp FC5 Fi Fi[7] Fi}


S468C15 ::~S468C15(){ note_dtor("S468C15", this);} // tgen
S468C15 ::S468C15(){ note_ctor("S468C15", this);} // tgen

static void Test_S468C15()
{
  extern Class_Descriptor cd_S468C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2752,7226)];
    init_test(&cd_S468C15, buf);
    S468C15 *dp, &lv = *(dp=new (buf) S468C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(44016,28900), "sizeof(S468C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C15)");
    /*is_ambiguous_... S468C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), 0, "S468C15");
    /*is_ambiguous_... S468C15::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*), ABISELECT(80,44), "S468C15");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(528,360), "S468C15");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(37328,24508), "S468C15");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(824,560), "S468C15");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(43568,28584), "S468C15");
    check_base_class_offset(lv, (S468C4*), ABISELECT(528,360), "S468C15");
    check_field_offset(lv, s468c15f0, ABISELECT(7824,5128), "S468C15.s468c15f0");
    check_field_offset(lv, s468c15f1, ABISELECT(7840,5132), "S468C15.s468c15f1");
    check_field_offset(lv, s468c15f2, ABISELECT(21824,14292), "S468C15.s468c15f2");
    check_field_offset(lv, s468c15f3, ABISELECT(21840,14300), "S468C15.s468c15f3");
    check_field_offset(lv, s468c15f4, ABISELECT(23280,15300), "S468C15.s468c15f4");
    check_field_offset(lv, s468c15f5, ABISELECT(23284,15304), "S468C15.s468c15f5");
    check_field_offset(lv, s468c15f6, ABISELECT(23288,15308), "S468C15.s468c15f6");
    check_field_offset(lv, s468c15f7, ABISELECT(23296,15312), "S468C15.s468c15f7");
    check_field_offset(lv, s468c15f8, ABISELECT(37280,24472), "S468C15.s468c15f8");
    check_field_offset(lv, s468c15f9, ABISELECT(37284,24476), "S468C15.s468c15f9");
    check_field_offset(lv, s468c15f10, ABISELECT(37312,24504), "S468C15.s468c15f10");
    test_class_info(&lv, &cd_S468C15);
    dp->~S468C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C15(Test_S468C15, "S468C15", ABISELECT(44016,28900));

#else // __cplusplus

extern void _ZN7S468C15C1Ev();
extern void _ZN7S468C15D1Ev();
Name_Map name_map_S468C15[] = {
  NSPAIR(_ZN7S468C15C1Ev),
  NSPAIR(_ZN7S468C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
static Base_Class bases_S468C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C8,    ABISELECT(80,44), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(528,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(37328,24508), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(824,560), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(43568,28584), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C4,    ABISELECT(528,360), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C15[];
extern void _ZN7S468C15D1Ev();
extern void _ZN7S468C15D0Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev)();
extern void ABISELECT(_ZThn824_N7S468C15D1Ev,_ZThn560_N7S468C15D1Ev)();
extern void ABISELECT(_ZThn824_N7S468C15D0Ev,_ZThn560_N7S468C15D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY vtc_S468C15[] = {
  ABISELECT(43568,28584),
  ABISELECT(37328,24508),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN7S468C15D1Ev,
  (VTBL_ENTRY)&_ZN7S468C15D0Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(43040,28224),
  ABISELECT(36800,24148),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev),
  ABISELECT(-824,-560),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S468C15D1Ev,_ZThn560_N7S468C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S468C15D0Ev,_ZThn560_N7S468C15D0Ev),
  0,
  ABISELECT(-37328,-24508),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-43568,-28584),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern VTBL_ENTRY _ZTV7S468C15[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C15[] = {
  ABISELECT(43040,28224),
  ABISELECT(36800,24148),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C15[] = {
  0,
  ABISELECT(-36800,-24148),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C15[] = {
  0,
  0,
  ABISELECT(-43040,-28224),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C15[] = {
  {&(_ZTV7S468C15[4]),  4,33},
  {&(_tg__ZTV6S468C4__7S468C15[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C15[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C15[4]),  4,6},
  {&(_ZTV7S468C15[14]),  14,33},
  {&(_ZTV7S468C15[26]),  26,33},
  {&(_ZTV7S468C15[31]),  31,33},
};
extern VTBL_ENTRY _ZTI7S468C15[];
extern  VTBL_ENTRY _ZTV7S468C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C15[];
Class_Descriptor cd_S468C15 = {  "S468C15", // class name
  bases_S468C15, 7,
  &(vtc_S468C15[0]), // expected_vtbl_contents
  &(vtt_S468C15[0]), // expected_vtt_contents
  ABISELECT(44016,28900), // object size
  NSPAIRA(_ZTI7S468C15),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S468C15),33, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C15),7, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C19  : S468C6 , S468C7 , virtual S468C5 {
  int s468c19f0;
  short s468c19f1;
  unsigned short s468c19f2:1;
  void *s468c19f3;
  long s468c19f4;
  ::S468C6 s468c19f5;
  int s468c19f6[2];
  char s468c19f7[3];
  int s468c19f8;
  virtual  ~S468C19(); // _ZN7S468C19D2Ev
  virtual void  v12(); // _ZN7S468C193v12Ev
  S468C19(); // tgen
};
//SIG(-1 S468C19) C1{ BC2{ v2 FC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC4 VBC3 vd v1 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi}


 S468C19 ::~S468C19(){ note_dtor("S468C19", this);}
void  S468C19 ::v12(){vfunc_called(this, "_ZN7S468C193v12Ev");}
S468C19 ::S468C19(){ note_ctor("S468C19", this);} // tgen

static void Test_S468C19()
{
  extern Class_Descriptor cd_S468C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(808,2108)];
    init_test(&cd_S468C19, buf);
    S468C19 *dp, &lv = *(dp=new (buf) S468C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12912,8428), "sizeof(S468C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C19)");
    check_base_class_offset(lv, (S468C6*), 0, "S468C19");
    check_base_class_offset(lv, (S468C7*), ABISELECT(6240,4076), "S468C19");
    check_base_class_offset(lv, (S468C5*), ABISELECT(12608,8228), "S468C19");
    check_field_offset(lv, s468c19f0, ABISELECT(6320,4120), "S468C19.s468c19f0");
    check_field_offset(lv, s468c19f1, ABISELECT(6324,4124), "S468C19.s468c19f1");
    set_bf_and_test(lv, s468c19f2, ABISELECT(6326,4126), 0, 1, 1, "S468C19");
    check_field_offset(lv, s468c19f3, ABISELECT(6328,4128), "S468C19.s468c19f3");
    check_field_offset(lv, s468c19f4, ABISELECT(6336,4132), "S468C19.s468c19f4");
    check_field_offset(lv, s468c19f5, ABISELECT(6352,4136), "S468C19.s468c19f5");
    check_field_offset(lv, s468c19f6, ABISELECT(12592,8212), "S468C19.s468c19f6");
    check_field_offset(lv, s468c19f7, ABISELECT(12600,8220), "S468C19.s468c19f7");
    check_field_offset(lv, s468c19f8, ABISELECT(12604,8224), "S468C19.s468c19f8");
    test_class_info(&lv, &cd_S468C19);
    dp->~S468C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C19(Test_S468C19, "S468C19", ABISELECT(12912,8428));

#else // __cplusplus

extern void _ZN7S468C19C1Ev();
extern void _ZN7S468C19D2Ev();
Name_Map name_map_S468C19[] = {
  NSPAIR(_ZN7S468C19C1Ev),
  NSPAIR(_ZN7S468C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
static Base_Class bases_S468C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(6240,4076), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(12608,8228), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S468C19[];
extern void _ZN6S468C62v3Ev();
extern void _ZN7S468C19D1Ev();
extern void _ZN7S468C19D0Ev();
extern void _ZN7S468C193v12Ev();
extern void ABISELECT(_ZThn6240_N7S468C19D1Ev,_ZThn4076_N7S468C19D1Ev)();
extern void ABISELECT(_ZThn6240_N7S468C19D0Ev,_ZThn4076_N7S468C19D0Ev)();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY vtc_S468C19[] = {
  ABISELECT(12608,8228),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&_ZN7S468C19D1Ev,
  (VTBL_ENTRY)&_ZN7S468C19D0Ev,
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C19D1Ev,_ZThn4076_N7S468C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C19D0Ev,_ZThn4076_N7S468C19D0Ev),
  0,
  0,
  ABISELECT(-12608,-8228),
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S468C19[];
static  VTT_ENTRY vtt_S468C19[] = {
  {&(_ZTV7S468C19[3]),  3,17},
  {&(_ZTV7S468C19[15]),  15,17},
};
extern VTBL_ENTRY _ZTI7S468C19[];
extern  VTBL_ENTRY _ZTV7S468C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C19[];
Class_Descriptor cd_S468C19 = {  "S468C19", // class name
  bases_S468C19, 3,
  &(vtc_S468C19[0]), // expected_vtbl_contents
  &(vtt_S468C19[0]), // expected_vtt_contents
  ABISELECT(12912,8428), // object size
  NSPAIRA(_ZTI7S468C19),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S468C19),17, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C19),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C18  : S468C6 , virtual S468C5 , virtual S468C19 , S468C12 {
  void *s468c18f0;
  virtual  ~S468C18(); // _ZN7S468C18D2Ev
  S468C18(); // tgen
};
//SIG(-1 S468C18) C1{ BC2{ v1 FC3{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} VBC3 VBC5{ BC2 BC4 VBC3 vd v4 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi} BC6{ BC7{ VBC2 VBC8{ v5 v6 Fc FL[10] FD FC3 Fp Fs Fp Fi} VBC9{ BC3 VBC2 BC4 VBC8 v7 FL:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} BC4 Fp FC4 FC3 Fs} BC3 BC10{ vd v8 v9 Fi FC3 Fi[2] FU11{ m FL FD[10] FD Fs:0} FD Fi Fi FC8 FL Fi FC8} FC12{ BC9 BC8 BC4 BC2 VBC3 vd v10 v11 FC4 Fi Fp[2] FL[2] Fi[2] Fp Fi FC8 Fi}} vd Fp}


 S468C18 ::~S468C18(){ note_dtor("S468C18", this);}
S468C18 ::S468C18(){ note_ctor("S468C18", this);} // tgen

static void Test_S468C18()
{
  extern Class_Descriptor cd_S468C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3567,9343)];
    init_test(&cd_S468C18, buf);
    S468C18 *dp, &lv = *(dp=new (buf) S468C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(57056,37368), "sizeof(S468C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C18)");
    /*is_ambiguous_... S468C18::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*), 0, "S468C18");
    /*is_ambiguous_... S468C18::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*), ABISELECT(30160,19780), "S468C18");
    check_base_class_offset(lv, (S468C5*)(S468C19*), ABISELECT(30160,19780), "S468C18");
    check_base_class_offset(lv, (S468C6*)(S468C19*), ABISELECT(30464,19980), "S468C18");
    check_base_class_offset(lv, (S468C7*)(S468C19*), ABISELECT(36704,24056), "S468C18");
    check_base_class_offset(lv, (S468C19*), ABISELECT(30464,19980), "S468C18");
    check_base_class_offset(lv, (S468C6*)(S468C13*)(S468C12*), ABISELECT(43072,28208), "S468C18");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(43072,28208), "S468C18");
    check_base_class_offset(lv, (S468C8*)(S468C13*)(S468C12*), ABISELECT(49312,32284), "S468C18");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(49312,32284), "S468C18");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(49760,32600), "S468C18");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(50056,32800), "S468C18");
    check_base_class_offset(lv, (S468C4*)(S468C13*)(S468C12*), ABISELECT(49760,32600), "S468C18");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*)(S468C12*), ABISELECT(6240,4076), "S468C18");
    check_base_class_offset(lv, (S468C13*)(S468C12*), ABISELECT(6240,4076), "S468C18");
    /*is_ambiguous_... S468C12::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C12*), ABISELECT(6736,4372), "S468C18");
    check_base_class_offset(lv, (S468C9*)(S468C12*), ABISELECT(7040,4572), "S468C18");
    check_base_class_offset(lv, (S468C12*), ABISELECT(6240,4076), "S468C18");
    check_field_offset(lv, s468c18f0, ABISELECT(30144,19776), "S468C18.s468c18f0");
    test_class_info(&lv, &cd_S468C18);
    dp->~S468C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C18(Test_S468C18, "S468C18", ABISELECT(57056,37368));

#else // __cplusplus

extern void _ZN7S468C18C1Ev();
extern void _ZN7S468C18D2Ev();
Name_Map name_map_S468C18[] = {
  NSPAIR(_ZN7S468C18C1Ev),
  NSPAIR(_ZN7S468C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C19;
extern VTBL_ENTRY _ZTI7S468C19[];
extern  VTBL_ENTRY _ZTV7S468C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C19[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C12;
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
static Base_Class bases_S468C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C5,    ABISELECT(30160,19780), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C6,    ABISELECT(30464,19980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(36704,24056), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C19,    ABISELECT(30464,19980), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C6,    ABISELECT(43072,28208), //bcp->offset
    47, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S468C8,    ABISELECT(49312,32284), //bcp->offset
    51, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S468C5,    ABISELECT(49760,32600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(50056,32800), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(49760,32600), //bcp->offset
    57, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(6240,4076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S468C13,    ABISELECT(6240,4076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(6736,4372), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(7040,4572), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S468C12,    ABISELECT(6240,4076), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C18[];
extern void _ZN6S468C62v3Ev();
extern void _ZN7S468C18D1Ev();
extern void _ZN7S468C18D0Ev();
extern void ABISELECT(_ZThn6240_N7S468C18D1Ev,_ZThn4076_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn6240_N7S468C18D0Ev,_ZThn4076_N7S468C18D0Ev)();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZThn7040_N7S468C18D1Ev,_ZThn4572_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn7040_N7S468C18D0Ev,_ZThn4572_N7S468C18D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn30464_N7S468C18D1Ev,_ZThn19980_N7S468C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev)();
extern void ABISELECT(_ZThn30464_N7S468C18D0Ev,_ZThn19980_N7S468C18D0Ev)() __attribute__((weak));
extern void _ZN7S468C193v12Ev();
extern void ABISELECT(_ZTvn6240_n40_N7S468C18D1Ev,_ZTvn4076_n20_N7S468C18D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S468C18D0Ev,_ZTvn4076_n20_N7S468C18D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn49760_N7S468C18D1Ev,_ZThn32600_N7S468C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev)();
extern void ABISELECT(_ZThn49760_N7S468C18D0Ev,_ZThn32600_N7S468C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C18D1Ev,_ZTvn200_n32_N7S468C18D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C18D0Ev,_ZTvn200_n32_N7S468C18D0Ev)();
static  VTBL_ENTRY vtc_S468C18[] = {
  ABISELECT(49760,32600),
  ABISELECT(49312,32284),
  ABISELECT(43072,28208),
  ABISELECT(30464,19980),
  ABISELECT(30160,19780),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&_ZN7S468C18D1Ev,
  (VTBL_ENTRY)&_ZN7S468C18D0Ev,
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C18D1Ev,_ZThn4076_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C18D0Ev,_ZThn4076_N7S468C18D0Ev),
  ABISELECT(-6736,-4372),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-7040,-4572),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7040_N7S468C18D1Ev,_ZThn4572_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7040_N7S468C18D0Ev,_ZThn4572_N7S468C18D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  0,
  0,
  ABISELECT(-30160,-19780),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  0,
  ABISELECT(-30464,-19980),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-30464,-19980),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev),
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
  ABISELECT(-36704,-24056),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C18D1Ev,_ZTvn4076_n20_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C18D0Ev,_ZTvn4076_n20_N7S468C18D0Ev),
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-49312,-32284),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-49760,-32600),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-49760,-32600),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev),
  ABISELECT(-50056,-32800),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C18D1Ev,_ZTvn200_n32_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C18D0Ev,_ZTvn200_n32_N7S468C18D0Ev),
};
extern VTBL_ENTRY _ZTV7S468C18[];
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C12__7S468C18[] = {
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
};
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C137S468C12__7S468C18[] = {
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C137S468C12__7S468C18[] = {
  0,
  ABISELECT(-36832,-24132),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C137S468C12__7S468C18[] = {
  0,
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZThn43520_N7S468C13D1Ev,_ZThn28524_N7S468C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
extern void ABISELECT(_ZThn43520_N7S468C13D0Ev,_ZThn28524_N7S468C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C137S468C12__7S468C18[] = {
  ABISELECT(-43520,-28524),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-43520,-28524),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C137S468C12__7S468C18[] = {
  ABISELECT(-43816,-28724),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C12__7S468C18[] = {
  0,
  ABISELECT(-36832,-24132),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C12__7S468C18[] = {
  0,
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZThn43520_N7S468C12D1Ev,_ZThn28524_N7S468C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
extern void ABISELECT(_ZThn43520_N7S468C12D0Ev,_ZThn28524_N7S468C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C12__7S468C18[] = {
  ABISELECT(-43520,-28524),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-43520,-28524),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C12__7S468C18[] = {
  ABISELECT(-43816,-28724),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
extern void _ZN6S468C62v3Ev();
extern void _ZN7S468C19D1Ev();
extern void _ZN7S468C19D0Ev();
extern void _ZN7S468C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S468C19__7S468C18[] = {
  ABISELECT(-304,-200),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&_ZN7S468C19D1Ev,
  (VTBL_ENTRY)&_ZN7S468C19D0Ev,
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__7S468C19__7S468C18[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C18[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C18[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C18[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C18[] = {
  {&(_ZTV7S468C18[7]),  7,74},
  {&(_tg__ZTV7S468C12__7S468C18[5]),  5,7},
  {&(_tg__ZTV7S468C137S468C12__7S468C18[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C137S468C12__7S468C18[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C137S468C12__7S468C18[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C137S468C12__7S468C18[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C137S468C12__7S468C18[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C12__7S468C18[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C12__7S468C18[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C12__7S468C18[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C12__7S468C18[2]),  2,4},
  {&(_ZTV7S468C18[31]),  31,74},
  {&(_ZTV7S468C18[39]),  39,74},
  {&(_ZTV7S468C18[45]),  45,74},
  {&(_ZTV7S468C18[15]),  15,74},
  {&(_ZTV7S468C18[50]),  50,74},
  {&(_ZTV7S468C18[55]),  55,74},
  {&(_ZTV7S468C18[65]),  65,74},
  {&(_ZTV7S468C18[72]),  72,74},
  {&(_tg__ZTV7S468C19__7S468C18[3]),  3,7},
  {&(_tg__ZTV6S468C5__7S468C19__7S468C18[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C18[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C18[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C18[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S468C18[];
extern  VTBL_ENTRY _ZTV7S468C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C18[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S468C12D0Ev,_ZThn28524_N7S468C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S468C12D1Ev,_ZThn28524_N7S468C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S468C13D0Ev,_ZThn28524_N7S468C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S468C13D1Ev,_ZThn28524_N7S468C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn49760_N7S468C18D0Ev,_ZThn32600_N7S468C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn49760_N7S468C18D1Ev,_ZThn32600_N7S468C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30464_N7S468C18D0Ev,_ZThn19980_N7S468C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30464_N7S468C18D1Ev,_ZThn19980_N7S468C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C18 = {  "S468C18", // class name
  bases_S468C18, 15,
  &(vtc_S468C18[0]), // expected_vtbl_contents
  &(vtt_S468C18[0]), // expected_vtt_contents
  ABISELECT(57056,37368), // object size
  NSPAIRA(_ZTI7S468C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S468C18),74, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C18),24, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C20_nt  {
};
//SIG(-1 S468C20_nt) C1{}



//skip512 S468C20_nt

#else // __cplusplus

Class_Descriptor cd_S468C20_nt = {  "S468C20_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C17  : virtual S468C6 , S468C15 , S468C18 {
  void *s468c17f0;
  int s468c17f1[4];
  ::S468C20_nt s468c17f2;
  ::S468C12 s468c17f3;
  ::S468C14_nt s468c17f4;
  int s468c17f5;
  int s468c17f6:24;
  ::S468C14_nt s468c17f7;
  int s468c17f8;
  ::S468C20_nt s468c17f9;
  ~S468C17(); // tgen
  S468C17(); // tgen
};
//SIG(-1 S468C17) C1{ VBC2{ v1 FC3{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC5{ BC4 BC6{ v2 v3 Fc FL[10] FD FC3 Fp Fs Fp Fi} BC7{ BC3 VBC2 BC4 VBC6 v6 FL:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} Fp FC7 Fc[7] FC8{ vd v8 v9 Fi FC3 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC6 FL Fi FC6} Fi Fc[4] Fp FC7 Fi Fi[7] Fi} BC10{ BC2 VBC3 VBC11{ BC2 BC4 VBC3 vd v7 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi} BC12{ BC13{ VBC2 VBC6 VBC7 BC4 Fp FC4 FC3 Fs} BC3 BC8 FC14{ BC7 BC6 BC4 BC2 VBC3 vd v10 v11 FC4 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}} vd Fp} Fp Fi[4] FC15{} FC12 FC16{ m Fc} Fi Fi:24 FC16 Fi FC15}


S468C17 ::~S468C17(){ note_dtor("S468C17", this);} // tgen
S468C17 ::S468C17(){ note_ctor("S468C17", this);} // tgen

static void Test_S468C17()
{
  extern Class_Descriptor cd_S468C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(8272,21696)];
    init_test(&cd_S468C17, buf);
    S468C17 *dp, &lv = *(dp=new (buf) S468C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(132336,86780), "sizeof(S468C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C17)");
    /*is_ambiguous_... S468C17::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*), ABISELECT(105440,69192), "S468C17");
    check_base_class_offset(lv, (S468C6*)(S468C4*)(S468C15*), ABISELECT(105440,69192), "S468C17");
    check_base_class_offset(lv, (S468C6*)(S468C13*)(S468C12*)(S468C18*), ABISELECT(105440,69192), "S468C17");
    /*is_ambiguous_... S468C17::S468C4 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(105440,69192), "S468C17");
    /*is_ambiguous_... S468C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C15*), 0, "S468C17");
    /*is_ambiguous_... S468C15::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C15*), ABISELECT(80,44), "S468C17");
    check_base_class_offset(lv, (S468C5*)(S468C4*)(S468C15*), ABISELECT(528,360), "S468C17");
    check_base_class_offset(lv, (S468C7*)(S468C4*)(S468C15*), ABISELECT(824,560), "S468C17");
    check_base_class_offset(lv, (S468C8*)(S468C4*)(S468C15*), ABISELECT(111680,73268), "S468C17");
    check_base_class_offset(lv, (S468C8*)(S468C13*)(S468C12*)(S468C18*), ABISELECT(111680,73268), "S468C17");
    /*is_ambiguous_... S468C17::S468C4 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(111680,73268), "S468C17");
    check_base_class_offset(lv, (S468C4*)(S468C15*), ABISELECT(528,360), "S468C17");
    check_base_class_offset(lv, (S468C15*), 0, "S468C17");
    /*is_ambiguous_... S468C18::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C18*), ABISELECT(37328,24508), "S468C17");
    /*is_ambiguous_... S468C18::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C18*), ABISELECT(112128,73584), "S468C17");
    check_base_class_offset(lv, (S468C5*)(S468C19*), ABISELECT(112128,73584), "S468C17");
    check_base_class_offset(lv, (S468C6*)(S468C19*), ABISELECT(112432,73784), "S468C17");
    check_base_class_offset(lv, (S468C7*)(S468C19*), ABISELECT(118672,77860), "S468C17");
    check_base_class_offset(lv, (S468C19*)(S468C18*), ABISELECT(112432,73784), "S468C17");
    /*is_ambiguous_... S468C17::S468C4 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(125040,82012), "S468C17");
    /*is_ambiguous_... S468C17::S468C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(125336,82212), "S468C17");
    check_base_class_offset(lv, (S468C4*)(S468C13*)(S468C12*)(S468C18*), ABISELECT(125040,82012), "S468C17");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*)(S468C12*)(S468C18*), ABISELECT(43568,28584), "S468C17");
    check_base_class_offset(lv, (S468C13*)(S468C12*)(S468C18*), ABISELECT(43568,28584), "S468C17");
    /*is_ambiguous_... S468C12::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C12*)(S468C18*), ABISELECT(44064,28880), "S468C17");
    check_base_class_offset(lv, (S468C9*)(S468C12*)(S468C18*), ABISELECT(44368,29080), "S468C17");
    check_base_class_offset(lv, (S468C12*)(S468C18*), ABISELECT(43568,28584), "S468C17");
    check_base_class_offset(lv, (S468C18*), ABISELECT(37328,24508), "S468C17");
    check_field_offset(lv, s468c17f0, ABISELECT(67480,44288), "S468C17.s468c17f0");
    check_field_offset(lv, s468c17f1, ABISELECT(67488,44292), "S468C17.s468c17f1");
    check_field_offset(lv, s468c17f2, ABISELECT(67504,44308), "S468C17.s468c17f2");
    check_field_offset(lv, s468c17f3, ABISELECT(67520,44312), "S468C17.s468c17f3");
    check_field_offset(lv, s468c17f4, ABISELECT(105408,69172), "S468C17.s468c17f4");
    check_field_offset(lv, s468c17f5, ABISELECT(105412,69176), "S468C17.s468c17f5");
    set_bf_and_test(lv, s468c17f6, ABISELECT(105416,69180), 0, 24, 1, "S468C17");
    set_bf_and_test(lv, s468c17f6, ABISELECT(105416,69180), 0, 24, hide_sll(1LL<<23), "S468C17");
    check_field_offset(lv, s468c17f7, ABISELECT(105419,69183), "S468C17.s468c17f7");
    check_field_offset(lv, s468c17f8, ABISELECT(105420,69184), "S468C17.s468c17f8");
    check_field_offset(lv, s468c17f9, ABISELECT(105424,69188), "S468C17.s468c17f9");
    test_class_info(&lv, &cd_S468C17);
    dp->~S468C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C17(Test_S468C17, "S468C17", ABISELECT(132336,86780));

#else // __cplusplus

extern void _ZN7S468C17C1Ev();
extern void _ZN7S468C17D1Ev();
Name_Map name_map_S468C17[] = {
  NSPAIR(_ZN7S468C17C1Ev),
  NSPAIR(_ZN7S468C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C15;
extern VTBL_ENTRY _ZTI7S468C15[];
extern  VTBL_ENTRY _ZTV7S468C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C15[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C19;
extern VTBL_ENTRY _ZTI7S468C19[];
extern  VTBL_ENTRY _ZTV7S468C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C19[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C12;
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
extern Class_Descriptor cd_S468C18;
extern VTBL_ENTRY _ZTI7S468C18[];
extern  VTBL_ENTRY _ZTV7S468C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C18[];
static Base_Class bases_S468C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C6,    ABISELECT(105440,69192), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(80,44), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(528,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(824,560), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(111680,73268), //bcp->offset
    57, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C4,    ABISELECT(528,360), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S468C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C6,    ABISELECT(37328,24508), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(112128,73584), //bcp->offset
    63, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S468C6,    ABISELECT(112432,73784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(118672,77860), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C19,    ABISELECT(112432,73784), //bcp->offset
    69, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S468C5,    ABISELECT(125040,82012), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(125336,82212), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(125040,82012), //bcp->offset
    83, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(43568,28584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S468C13,    ABISELECT(43568,28584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(44064,28880), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(44368,29080), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C12,    ABISELECT(43568,28584), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S468C18,    ABISELECT(37328,24508), //bcp->offset
    26, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S468C17[];
extern void _ZN7S468C17D1Ev();
extern void _ZN7S468C17D0Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn528_N7S468C17D1Ev,_ZThn360_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn528_N7S468C17D0Ev,_ZThn360_N7S468C17D0Ev)();
extern void ABISELECT(_ZThn824_N7S468C17D1Ev,_ZThn560_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn824_N7S468C17D0Ev,_ZThn560_N7S468C17D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void ABISELECT(_ZThn37328_N7S468C17D1Ev,_ZThn24508_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn37328_N7S468C17D0Ev,_ZThn24508_N7S468C17D0Ev)();
extern void ABISELECT(_ZThn43568_N7S468C17D1Ev,_ZThn28584_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn43568_N7S468C17D0Ev,_ZThn28584_N7S468C17D0Ev)();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZThn44368_N7S468C17D1Ev,_ZThn29080_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn44368_N7S468C17D0Ev,_ZThn29080_N7S468C17D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S468C17D1Ev,_ZTv0_n20_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn112432_N7S468C17D1Ev,_ZThn73784_N7S468C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S468C17D0Ev,_ZTv0_n20_N7S468C17D0Ev)();
extern void ABISELECT(_ZThn112432_N7S468C17D0Ev,_ZThn73784_N7S468C17D0Ev)() __attribute__((weak));
extern void _ZN7S468C193v12Ev();
extern void ABISELECT(_ZTvn6240_n40_N7S468C17D1Ev,_ZTvn4076_n20_N7S468C17D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S468C17D0Ev,_ZTvn4076_n20_N7S468C17D0Ev)();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C17D1Ev,_ZTv0_n32_N7S468C17D1Ev)();
extern void ABISELECT(_ZThn125040_N7S468C17D1Ev,_ZThn82012_N7S468C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C17D0Ev,_ZTv0_n32_N7S468C17D0Ev)();
extern void ABISELECT(_ZThn125040_N7S468C17D0Ev,_ZThn82012_N7S468C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C17D1Ev,_ZTvn200_n32_N7S468C17D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C17D0Ev,_ZTvn200_n32_N7S468C17D0Ev)();
static  VTBL_ENTRY vtc_S468C17[] = {
  ABISELECT(125040,82012),
  ABISELECT(112432,73784),
  ABISELECT(112128,73584),
  ABISELECT(111680,73268),
  ABISELECT(105440,69192),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN7S468C17D1Ev,
  (VTBL_ENTRY)&_ZN7S468C17D0Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C17D1Ev,_ZThn360_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C17D0Ev,_ZThn360_N7S468C17D0Ev),
  ABISELECT(-824,-560),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S468C17D1Ev,_ZThn560_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S468C17D0Ev,_ZThn560_N7S468C17D0Ev),
  ABISELECT(87712,57504),
  ABISELECT(74352,48760),
  ABISELECT(68112,44684),
  ABISELECT(75104,49276),
  ABISELECT(74800,49076),
  ABISELECT(-37328,-24508),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn37328_N7S468C17D1Ev,_ZThn24508_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn37328_N7S468C17D0Ev,_ZThn24508_N7S468C17D0Ev),
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  ABISELECT(-43568,-28584),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn43568_N7S468C17D1Ev,_ZThn28584_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn43568_N7S468C17D0Ev,_ZThn28584_N7S468C17D0Ev),
  ABISELECT(-44064,-28880),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-44368,-29080),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn44368_N7S468C17D1Ev,_ZThn29080_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn44368_N7S468C17D0Ev,_ZThn29080_N7S468C17D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  0,
  ABISELECT(-105440,-69192),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-111680,-73268),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  0,
  0,
  ABISELECT(-112128,-73584),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  0,
  ABISELECT(-112432,-73784),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-112432,-73784),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C17D1Ev,_ZTv0_n20_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C17D0Ev,_ZTv0_n20_N7S468C17D0Ev),
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
  ABISELECT(-118672,-77860),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C17D1Ev,_ZTvn4076_n20_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C17D0Ev,_ZTvn4076_n20_N7S468C17D0Ev),
  ABISELECT(-125040,-82012),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-125040,-82012),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C17D1Ev,_ZTv0_n32_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C17D0Ev,_ZTv0_n32_N7S468C17D0Ev),
  ABISELECT(-125336,-82212),
  (VTBL_ENTRY)&(_ZTI7S468C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C17D1Ev,_ZTvn200_n32_N7S468C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C17D0Ev,_ZTvn200_n32_N7S468C17D0Ev),
};
extern VTBL_ENTRY _ZTV7S468C17[];
extern void _ZN7S468C15D1Ev();
extern void _ZN7S468C15D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C15__7S468C17[] = {
  ABISELECT(111680,73268),
  ABISELECT(105440,69192),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN7S468C15D1Ev,
  (VTBL_ENTRY)&_ZN7S468C15D0Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C47S468C15__7S468C17[] = {
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C47S468C15__7S468C17[] = {
  0,
  ABISELECT(-104912,-68832),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C47S468C15__7S468C17[] = {
  0,
  0,
  ABISELECT(-111152,-72908),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C15__7S468C17[] = {
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C15__7S468C17[] = {
  0,
  ABISELECT(-105440,-69192),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__A1__7S468C15__7S468C17[] = {
  0,
  0,
  ABISELECT(-111680,-73268),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C62v3Ev();
extern void _ZN7S468C18D1Ev();
extern void _ZN7S468C18D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C18__7S468C17[] = {
  ABISELECT(87712,57504),
  ABISELECT(74352,48760),
  ABISELECT(68112,44684),
  ABISELECT(75104,49276),
  ABISELECT(74800,49076),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&_ZN7S468C18D1Ev,
  (VTBL_ENTRY)&_ZN7S468C18D0Ev,
};
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C127S468C18__7S468C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
};
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C137S468C127S468C18__7S468C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C137S468C127S468C18__7S468C17[] = {
  0,
  ABISELECT(-61872,-40608),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C137S468C127S468C18__7S468C17[] = {
  0,
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZThn81472_N7S468C13D1Ev,_ZThn53428_N7S468C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
extern void ABISELECT(_ZThn81472_N7S468C13D0Ev,_ZThn53428_N7S468C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C137S468C127S468C18__7S468C17[] = {
  ABISELECT(-81472,-53428),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-81472,-53428),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C137S468C127S468C18__7S468C17[] = {
  ABISELECT(-81768,-53628),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C127S468C18__7S468C17[] = {
  0,
  ABISELECT(-61872,-40608),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C127S468C18__7S468C17[] = {
  0,
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZThn81472_N7S468C12D1Ev,_ZThn53428_N7S468C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
extern void ABISELECT(_ZThn81472_N7S468C12D0Ev,_ZThn53428_N7S468C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C127S468C18__7S468C17[] = {
  ABISELECT(-81472,-53428),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-81472,-53428),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C127S468C18__7S468C17[] = {
  ABISELECT(-81768,-53628),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__7S468C18__7S468C17[] = {
  0,
  0,
  ABISELECT(-74800,-49076),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn75104_N7S468C18D1Ev,_ZThn49276_N7S468C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev)();
extern void ABISELECT(_ZThn75104_N7S468C18D0Ev,_ZThn49276_N7S468C18D0Ev)() __attribute__((weak));
extern void _ZN7S468C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S468C19__7S468C18__7S468C17[] = {
  0,
  ABISELECT(-75104,-49276),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-75104,-49276),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev),
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
};
extern void ABISELECT(_ZTvn6240_n40_N7S468C18D1Ev,_ZTvn4076_n20_N7S468C18D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S468C18D0Ev,_ZTvn4076_n20_N7S468C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C77S468C19__7S468C18__7S468C17[] = {
  ABISELECT(-81344,-53352),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C18D1Ev,_ZTvn4076_n20_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S468C18D0Ev,_ZTvn4076_n20_N7S468C18D0Ev),
};
extern void ABISELECT(_ZThn6240_N7S468C18D1Ev,_ZThn4076_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn6240_N7S468C18D0Ev,_ZThn4076_N7S468C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S468C12__7S468C18__7S468C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C18D1Ev,_ZThn4076_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S468C18D0Ev,_ZThn4076_N7S468C18D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__A2__7S468C18__7S468C17[] = {
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C18__7S468C17[] = {
  0,
  0,
  ABISELECT(-74352,-48760),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev)();
extern void ABISELECT(_ZThn87712_N7S468C18D1Ev,_ZThn57504_N7S468C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev)();
extern void ABISELECT(_ZThn87712_N7S468C18D0Ev,_ZThn57504_N7S468C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C18__7S468C17[] = {
  ABISELECT(-87712,-57504),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-87712,-57504),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C18D1Ev,_ZTvn200_n32_N7S468C18D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C18D0Ev,_ZTvn200_n32_N7S468C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__A1__7S468C18__7S468C17[] = {
  ABISELECT(-88008,-57704),
  (VTBL_ENTRY)&(_ZTI7S468C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C18D1Ev,_ZTvn200_n32_N7S468C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C18D0Ev,_ZTvn200_n32_N7S468C18D0Ev),
};
extern void _ZN6S468C62v3Ev();
extern void _ZN7S468C19D1Ev();
extern void _ZN7S468C19D0Ev();
extern void _ZN7S468C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S468C19__7S468C17[] = {
  ABISELECT(-304,-200),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  (VTBL_ENTRY)&_ZN7S468C19D1Ev,
  (VTBL_ENTRY)&_ZN7S468C19D0Ev,
  (VTBL_ENTRY)&_ZN7S468C193v12Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__7S468C19__7S468C17[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S468C19[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__A1__7S468C17[] = {
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__A1__7S468C17[] = {
  0,
  ABISELECT(19600,12820),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__A1__7S468C17[] = {
  0,
  0,
  ABISELECT(13360,8744),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C17[] = {
  {&(_ZTV7S468C17[7]),  7,100},
  {&(_tg__ZTV7S468C15__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C47S468C15__7S468C17[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C47S468C15__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C47S468C15__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C15__7S468C17[4]),  4,9},
  {&(_tg__ZTV6S468C6__7S468C15__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__A1__7S468C15__7S468C17[4]),  4,6},
  {&(_tg__ZTV7S468C18__7S468C17[7]),  7,10},
  {&(_tg__ZTV7S468C127S468C18__7S468C17[5]),  5,7},
  {&(_tg__ZTV7S468C137S468C127S468C18__7S468C17[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C137S468C127S468C18__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C137S468C127S468C18__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C137S468C127S468C18__7S468C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C137S468C127S468C18__7S468C17[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C127S468C18__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C127S468C18__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C127S468C18__7S468C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C127S468C18__7S468C17[2]),  2,4},
  {&(_tg__ZTV6S468C5__7S468C18__7S468C17[4]),  4,6},
  {&(_tg__ZTV7S468C19__7S468C18__7S468C17[6]),  6,10},
  {&(_tg__ZTV6S468C77S468C19__7S468C18__7S468C17[2]),  2,4},
  {&(_tg__ZTV7S468C12__7S468C18__7S468C17[5]),  5,7},
  {&(_tg__ZTV6S468C6__A2__7S468C18__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C18__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C18__7S468C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__A1__7S468C18__7S468C17[2]),  2,4},
  {&(_ZTV7S468C17[56]),  56,100},
  {&(_ZTV7S468C17[17]),  17,100},
  {&(_ZTV7S468C17[61]),  61,100},
  {&(_ZTV7S468C17[33]),  33,100},
  {&(_ZTV7S468C17[67]),  67,100},
  {&(_ZTV7S468C17[75]),  75,100},
  {&(_ZTV7S468C17[81]),  81,100},
  {&(_ZTV7S468C17[41]),  41,100},
  {&(_ZTV7S468C17[91]),  91,100},
  {&(_ZTV7S468C17[98]),  98,100},
  {&(_tg__ZTV7S468C19__7S468C17[3]),  3,7},
  {&(_tg__ZTV6S468C5__7S468C19__7S468C17[4]),  4,6},
  {&(_tg__ZTV6S468C4__A1__7S468C17[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__A1__7S468C17[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__A1__7S468C17[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S468C17[];
extern  VTBL_ENTRY _ZTV7S468C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C17[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C18D0Ev,_ZTv0_n32_N7S468C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn87712_N7S468C18D0Ev,_ZThn57504_N7S468C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C18D1Ev,_ZTv0_n32_N7S468C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn87712_N7S468C18D1Ev,_ZThn57504_N7S468C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C18D0Ev,_ZTv0_n20_N7S468C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn75104_N7S468C18D0Ev,_ZThn49276_N7S468C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C18D1Ev,_ZTv0_n20_N7S468C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn75104_N7S468C18D1Ev,_ZThn49276_N7S468C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S468C12D0Ev,_ZThn53428_N7S468C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S468C12D1Ev,_ZThn53428_N7S468C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S468C13D0Ev,_ZThn53428_N7S468C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S468C13D1Ev,_ZThn53428_N7S468C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C17D0Ev,_ZTv0_n32_N7S468C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn125040_N7S468C17D0Ev,_ZThn82012_N7S468C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C17D1Ev,_ZTv0_n32_N7S468C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn125040_N7S468C17D1Ev,_ZThn82012_N7S468C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C17D0Ev,_ZTv0_n20_N7S468C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112432_N7S468C17D0Ev,_ZThn73784_N7S468C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S468C17D1Ev,_ZTv0_n20_N7S468C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112432_N7S468C17D1Ev,_ZThn73784_N7S468C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C17 = {  "S468C17", // class name
  bases_S468C17, 22,
  &(vtc_S468C17[0]), // expected_vtbl_contents
  &(vtt_S468C17[0]), // expected_vtt_contents
  ABISELECT(132336,86780), // object size
  NSPAIRA(_ZTI7S468C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S468C17),100, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C17),42, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C16  {
  ::S468C12 s468c16f0;
  ::S468C17 s468c16f1;
  int s468c16f2;
  ::S468C5 s468c16f3;
  ::S468C14_nt s468c16f4;
  void *s468c16f5;
  int s468c16f6:15;
  int s468c16f7;
  int s468c16f8;
  void  mf468c16(); // _ZN7S468C168mf468c16Ev
};
//SIG(-1 S468C16) C1{ m FC2{ BC3{ VBC4{ v1 FC5{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC5[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} VBC7{ v2 v3 Fc FL[10] FD FC5 Fp Fs Fp Fi} VBC8{ BC5 VBC4 BC6 VBC7 v6 FL:2 FD[7] Fp FC4 Fp Fi Fp[2] FC6 FC5 FD[8]} BC6 Fp FC6 FC5 Fs} BC5 BC9{ vd v7 v8 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} FC11{ BC8 BC7 BC6 BC4 VBC5 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi}} FC12{ VBC4 BC13{ BC6 BC7 BC8 Fp FC8 Fc[7] FC9 Fi Fc[4] Fp FC8 Fi Fi[7] Fi} BC14{ BC4 VBC5 VBC15{ BC4 BC6 VBC5 vd v11 Fi Fs Fs:1 Fp Fl FC4 Fi[2] Fc[3] Fi} BC2 vd Fp} Fp Fi[4] FC16{} FC2 FC17{ m Fc} Fi Fi:24 FC17 Fi FC16} Fi FC5 FC17 Fp Fi:15 Fi Fi}


void  S468C16 ::mf468c16(){}

static void Test_S468C16()
{
  {
    init_simple_test("S468C16");
    static S468C16 lv;
    check2(sizeof(lv), ABISELECT(170576,111864), "sizeof(S468C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C16)");
    check_field_offset(lv, s468c16f0, 0, "S468C16.s468c16f0");
    check_field_offset(lv, s468c16f1, ABISELECT(37888,24860), "S468C16.s468c16f1");
    check_field_offset(lv, s468c16f2, ABISELECT(170224,111640), "S468C16.s468c16f2");
    check_field_offset(lv, s468c16f3, ABISELECT(170240,111644), "S468C16.s468c16f3");
    check_field_offset(lv, s468c16f4, ABISELECT(170544,111844), "S468C16.s468c16f4");
    check_field_offset(lv, s468c16f5, ABISELECT(170552,111848), "S468C16.s468c16f5");
    set_bf_and_test(lv, s468c16f6, ABISELECT(170560,111852), 0, 15, 1, "S468C16");
    set_bf_and_test(lv, s468c16f6, ABISELECT(170560,111852), 0, 15, hide_sll(1LL<<14), "S468C16");
    check_field_offset(lv, s468c16f7, ABISELECT(170564,111856), "S468C16.s468c16f7");
    check_field_offset(lv, s468c16f8, ABISELECT(170568,111860), "S468C16.s468c16f8");
  }
}
static Arrange_To_Call_Me vS468C16(Test_S468C16, "S468C16", ABISELECT(170576,111864));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S468C16[];
VTBL_ENTRY *P__ZTI7S468C16 = _ZTI7S468C16; 
Class_Descriptor cd_S468C16 = {  "S468C16", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(170576,111864), // object size
  NSPAIRA(_ZTI7S468C16),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C21  : virtual S468C8 , virtual S468C4 , virtual S468C5 , virtual S468C11 , virtual S468C12 {
  void *s468c21f0;
  ::S468C5 s468c21f1;
  void *s468c21f2;
  void *s468c21f3;
  int s468c21f4;
  ::S468C5 s468c21f5;
  short s468c21f6;
  int s468c21f7;
  char s468c21f8[10];
  void *s468c21f9;
  int s468c21f10;
  long s468c21f11[4];
  void *s468c21f12;
  virtual  ~S468C21(); // _ZN7S468C21D2Ev
  S468C21(); // tgen
};
//SIG(-1 S468C21) C1{ VBC2{ v1 v2 Fc FL[10] FD FC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi} VBC4{ BC3 VBC5{ v5 FC3[8] FC3[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC6 VBC2 v6 FL:2 FD[7] Fp FC5 Fp Fi Fp[2] FC6 FC3 FD[8]} VBC3 VBC7{ BC8{ BC9{ VBC5 VBC2 VBC4 BC6 Fp FC6 FC3 Fs} BC3 BC10{ vd v7 v8 Fi FC3 Fi[2] FU11{ m FL FD[10] FD Fs:0} FD Fi Fi FC2 FL Fi FC2} FC12{ BC4 BC2 BC6 BC5 VBC3 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC2 Fi}} VBC3 BC6 BC10 FC13{ m Fc} Fi Fi Fi:6 FC13 Fi} VBC8 vd Fp FC3 Fp Fp Fi FC3 Fs Fi Fc[10] Fp Fi Fl[4] Fp}


 S468C21 ::~S468C21(){ note_dtor("S468C21", this);}
S468C21 ::S468C21(){ note_ctor("S468C21", this);} // tgen

static void Test_S468C21()
{
  extern Class_Descriptor cd_S468C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4025,10574)];
    init_test(&cd_S468C21, buf);
    S468C21 *dp, &lv = *(dp=new (buf) S468C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64384,42292), "sizeof(S468C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C21)");
    check_base_class_offset(lv, (S468C8*), ABISELECT(736,468), "S468C21");
    check_base_class_offset(lv, (S468C8*)(S468C4*), ABISELECT(736,468), "S468C21");
    check_base_class_offset(lv, (S468C8*)(S468C13*)(S468C12*)(S468C11*), ABISELECT(736,468), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C13*)(S468C12*), ABISELECT(736,468), "S468C21");
    check_base_class_offset(lv, (S468C5*)(S468C4*), ABISELECT(1184,784), "S468C21");
    check_base_class_offset(lv, (S468C6*)(S468C4*), ABISELECT(8480,5552), "S468C21");
    check_base_class_offset(lv, (S468C6*)(S468C13*)(S468C12*)(S468C11*), ABISELECT(8480,5552), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C13*)(S468C12*), ABISELECT(8480,5552), "S468C21");
    check_base_class_offset(lv, (S468C7*)(S468C4*), ABISELECT(1480,984), "S468C21");
    check_base_class_offset(lv, (S468C4*), ABISELECT(1184,784), "S468C21");
    check_base_class_offset(lv, (S468C4*)(S468C13*)(S468C12*)(S468C11*), ABISELECT(1184,784), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C4*)(S468C13*)(S468C12*), ABISELECT(1184,784), "S468C21");
    /*is_ambiguous_... S468C21::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*), ABISELECT(14720,9628), "S468C21");
    /*is_ambiguous_... S468C11::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C11*), ABISELECT(14720,9628), "S468C21");
    /*is_ambiguous_... S468C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*)(S468C12*)(S468C11*), ABISELECT(15024,9828), "S468C21");
    check_base_class_offset(lv, (S468C13*)(S468C12*)(S468C11*), ABISELECT(15024,9828), "S468C21");
    /*is_ambiguous_... S468C12::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C12*)(S468C11*), ABISELECT(15520,10124), "S468C21");
    check_base_class_offset(lv, (S468C9*)(S468C12*)(S468C11*), ABISELECT(15824,10324), "S468C21");
    check_base_class_offset(lv, (S468C12*)(S468C11*), ABISELECT(15024,9828), "S468C21");
    /*is_ambiguous_... S468C11::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C11*), ABISELECT(38928,25528), "S468C21");
    /*is_ambiguous_... S468C11::S468C9 */ AMB_check_base_class_offset(lv, (S468C9*)(S468C11*), ABISELECT(39008,25572), "S468C21");
    check_base_class_offset(lv, (S468C11*), ABISELECT(15024,9828), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C13*)(S468C12*), ABISELECT(40480,26592), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C13*)(S468C12*), ABISELECT(40480,26592), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C12*), ABISELECT(40976,26888), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C9*)(S468C12*), ABISELECT(41280,27088), "S468C21");
    /*is_ambiguous_... S468C21::S468C12 */ AMB_check_base_class_offset(lv, (S468C12*), ABISELECT(40480,26592), "S468C21");
    check_field_offset(lv, s468c21f0, ABISELECT(8,4), "S468C21.s468c21f0");
    check_field_offset(lv, s468c21f1, ABISELECT(16,8), "S468C21.s468c21f1");
    check_field_offset(lv, s468c21f2, ABISELECT(320,208), "S468C21.s468c21f2");
    check_field_offset(lv, s468c21f3, ABISELECT(328,212), "S468C21.s468c21f3");
    check_field_offset(lv, s468c21f4, ABISELECT(336,216), "S468C21.s468c21f4");
    check_field_offset(lv, s468c21f5, ABISELECT(352,220), "S468C21.s468c21f5");
    check_field_offset(lv, s468c21f6, ABISELECT(656,420), "S468C21.s468c21f6");
    check_field_offset(lv, s468c21f7, ABISELECT(660,424), "S468C21.s468c21f7");
    check_field_offset(lv, s468c21f8, ABISELECT(664,428), "S468C21.s468c21f8");
    check_field_offset(lv, s468c21f9, ABISELECT(680,440), "S468C21.s468c21f9");
    check_field_offset(lv, s468c21f10, ABISELECT(688,444), "S468C21.s468c21f10");
    check_field_offset(lv, s468c21f11, ABISELECT(696,448), "S468C21.s468c21f11");
    check_field_offset(lv, s468c21f12, ABISELECT(728,464), "S468C21.s468c21f12");
    test_class_info(&lv, &cd_S468C21);
    dp->~S468C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C21(Test_S468C21, "S468C21", ABISELECT(64384,42292));

#else // __cplusplus

extern void _ZN7S468C21C1Ev();
extern void _ZN7S468C21D2Ev();
Name_Map name_map_S468C21[] = {
  NSPAIR(_ZN7S468C21C1Ev),
  NSPAIR(_ZN7S468C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C12;
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C11;
extern VTBL_ENTRY _ZTI7S468C11[];
extern  VTBL_ENTRY _ZTV7S468C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C11[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C13;
extern VTBL_ENTRY _ZTI7S468C13[];
extern  VTBL_ENTRY _ZTV7S468C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C13[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C12;
extern VTBL_ENTRY _ZTI7S468C12[];
extern  VTBL_ENTRY _ZTV7S468C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C12[];
static Base_Class bases_S468C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C8,    ABISELECT(736,468), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C5,    ABISELECT(1184,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(8480,5552), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(1480,984), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(1184,784), //bcp->offset
    16, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C5,    ABISELECT(14720,9628), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S468C13,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(15520,10124), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(15824,10324), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S468C12,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(38928,25528), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(39008,25572), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S468C11,    ABISELECT(15024,9828), //bcp->offset
    43, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(40480,26592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S468C13,    ABISELECT(40480,26592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(40976,26888), //bcp->offset
    88, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(41280,27088), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S468C12,    ABISELECT(40480,26592), //bcp->offset
    76, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S468C21[];
extern void _ZN7S468C21D1Ev();
extern void _ZN7S468C21D0Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C21D1Ev,_ZTv0_n32_N7S468C21D1Ev)();
extern void ABISELECT(_ZThn1184_N7S468C21D1Ev,_ZThn784_N7S468C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S468C21D0Ev,_ZTv0_n32_N7S468C21D0Ev)();
extern void ABISELECT(_ZThn1184_N7S468C21D0Ev,_ZThn784_N7S468C21D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S468C21D1Ev,_ZTvn200_n32_N7S468C21D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C21D0Ev,_ZTvn200_n32_N7S468C21D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZTv0_n56_N7S468C21D1Ev,_ZTv0_n28_N7S468C21D1Ev)();
extern void ABISELECT(_ZThn15024_N7S468C21D1Ev,_ZThn9828_N7S468C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S468C21D0Ev,_ZTv0_n28_N7S468C21D0Ev)();
extern void ABISELECT(_ZThn15024_N7S468C21D0Ev,_ZThn9828_N7S468C21D0Ev)() __attribute__((weak));
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZTvn800_n56_N7S468C21D1Ev,_ZTvn496_n28_N7S468C21D1Ev)();
extern void ABISELECT(_ZTvn800_n56_N7S468C21D0Ev,_ZTvn496_n28_N7S468C21D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void ABISELECT(_ZTvn23904_n56_N7S468C21D1Ev,_ZTvn15700_n28_N7S468C21D1Ev)();
extern void ABISELECT(_ZTvn23904_n56_N7S468C21D0Ev,_ZTvn15700_n28_N7S468C21D0Ev)();
extern void ABISELECT(_ZTvn23984_n56_N7S468C21D1Ev,_ZTvn15744_n28_N7S468C21D1Ev)();
extern void ABISELECT(_ZTvn23984_n56_N7S468C21D0Ev,_ZTvn15744_n28_N7S468C21D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void ABISELECT(_ZTv0_n48_N7S468C21D1Ev,_ZTv0_n24_N7S468C21D1Ev)();
extern void ABISELECT(_ZThn40480_N7S468C21D1Ev,_ZThn26592_N7S468C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S468C21D0Ev,_ZTv0_n24_N7S468C21D0Ev)();
extern void ABISELECT(_ZThn40480_N7S468C21D0Ev,_ZThn26592_N7S468C21D0Ev)() __attribute__((weak));
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZTvn800_n48_N7S468C21D1Ev,_ZTvn496_n24_N7S468C21D1Ev)();
extern void ABISELECT(_ZTvn800_n48_N7S468C21D0Ev,_ZTvn496_n24_N7S468C21D0Ev)();
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
static  VTBL_ENTRY vtc_S468C21[] = {
  ABISELECT(40480,26592),
  ABISELECT(15024,9828),
  ABISELECT(14720,9628),
  ABISELECT(8480,5552),
  ABISELECT(1184,784),
  ABISELECT(736,468),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN7S468C21D1Ev,
  (VTBL_ENTRY)&_ZN7S468C21D0Ev,
  0,
  0,
  ABISELECT(-736,-468),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-1184,-784),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(-1184,-784),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C21D1Ev,_ZTv0_n32_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C21D0Ev,_ZTv0_n32_N7S468C21D0Ev),
  ABISELECT(-1480,-984),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C21D1Ev,_ZTvn200_n32_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C21D0Ev,_ZTvn200_n32_N7S468C21D0Ev),
  0,
  ABISELECT(-8480,-5552),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-14720,-9628),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(800,496),
  ABISELECT(800,496),
  ABISELECT(496,296),
  ABISELECT(496,296),
  ABISELECT(-15024,-9828),
  ABISELECT(-304,-200),
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  ABISELECT(-15024,-9828),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S468C21D1Ev,_ZTv0_n28_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S468C21D0Ev,_ZTv0_n28_N7S468C21D0Ev),
  ABISELECT(-15520,-10124),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-15824,-10324),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n56_N7S468C21D1Ev,_ZTvn496_n28_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n56_N7S468C21D0Ev,_ZTvn496_n28_N7S468C21D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  ABISELECT(-38928,-25528),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23904_n56_N7S468C21D1Ev,_ZTvn15700_n28_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23904_n56_N7S468C21D0Ev,_ZTvn15700_n28_N7S468C21D0Ev),
  ABISELECT(-39008,-25572),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23984_n56_N7S468C21D1Ev,_ZTvn15744_n28_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23984_n56_N7S468C21D0Ev,_ZTvn15744_n28_N7S468C21D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  ABISELECT(800,496),
  ABISELECT(800,496),
  ABISELECT(496,296),
  ABISELECT(496,296),
  ABISELECT(-40480,-26592),
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  ABISELECT(-40480,-26592),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S468C21D1Ev,_ZTv0_n24_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S468C21D0Ev,_ZTv0_n24_N7S468C21D0Ev),
  ABISELECT(-40976,-26888),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  ABISELECT(-41280,-27088),
  (VTBL_ENTRY)&(_ZTI7S468C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n48_N7S468C21D1Ev,_ZTvn496_n24_N7S468C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n48_N7S468C21D0Ev,_ZTvn496_n24_N7S468C21D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
};
extern VTBL_ENTRY _ZTV7S468C21[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C21[] = {
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C4__7S468C21[] = {
  0,
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C4__7S468C21[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN7S468C11D1Ev();
extern void _ZN7S468C11D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C11__7S468C21[] = {
  ABISELECT(-304,-200),
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN7S468C11D1Ev,
  (VTBL_ENTRY)&_ZN7S468C11D0Ev,
};
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C127S468C11__7S468C21[] = {
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
};
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C137S468C127S468C11__7S468C21[] = {
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C137S468C127S468C11__7S468C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C137S468C127S468C11__7S468C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C137S468C127S468C11__7S468C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C137S468C127S468C11__7S468C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C127S468C11__7S468C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C127S468C11__7S468C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C127S468C11__7S468C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C127S468C11__7S468C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C11__7S468C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C11__7S468C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C11D1Ev,_ZTv0_n32_N7S468C11D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S468C11D0Ev,_ZTv0_n32_N7S468C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C11__7S468C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C11D1Ev,_ZTv0_n32_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C11D0Ev,_ZTv0_n32_N7S468C11D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C11D1Ev,_ZTvn200_n32_N7S468C11D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C11D0Ev,_ZTvn200_n32_N7S468C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C11__7S468C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C11D1Ev,_ZTvn200_n32_N7S468C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C11D0Ev,_ZTvn200_n32_N7S468C11D0Ev),
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__A2__7S468C11__7S468C21[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S468C11[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN7S468C12D1Ev();
extern void _ZN7S468C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C12__A1__7S468C21[] = {
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN7S468C12D1Ev,
  (VTBL_ENTRY)&_ZN7S468C12D0Ev,
};
extern void _ZN7S468C13D1Ev();
extern void _ZN7S468C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C137S468C12__A1__7S468C21[] = {
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN7S468C13D1Ev,
  (VTBL_ENTRY)&_ZN7S468C13D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C137S468C12__A1__7S468C21[] = {
  0,
  ABISELECT(32000,21040),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C137S468C12__A1__7S468C21[] = {
  0,
  0,
  ABISELECT(39744,26124),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C137S468C12__A1__7S468C21[] = {
  ABISELECT(39296,25808),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(39296,25808),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D1Ev,_ZTv0_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C13D0Ev,_ZTv0_n32_N7S468C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C137S468C12__A1__7S468C21[] = {
  ABISELECT(39000,25608),
  (VTBL_ENTRY)&(_ZTI7S468C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D1Ev,_ZTvn200_n32_N7S468C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C13D0Ev,_ZTvn200_n32_N7S468C13D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C12__A1__7S468C21[] = {
  0,
  ABISELECT(32000,21040),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__7S468C12__A1__7S468C21[] = {
  0,
  0,
  ABISELECT(39744,26124),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C12__A1__7S468C21[] = {
  ABISELECT(39296,25808),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(39296,25808),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D1Ev,_ZTv0_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S468C12D0Ev,_ZTv0_n32_N7S468C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S468C4__7S468C12__A1__7S468C21[] = {
  ABISELECT(39000,25608),
  (VTBL_ENTRY)&(_ZTI7S468C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D1Ev,_ZTvn200_n32_N7S468C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S468C12D0Ev,_ZTvn200_n32_N7S468C12D0Ev),
};
static  VTT_ENTRY vtt_S468C21[] = {
  {&(_ZTV7S468C21[8]),  8,98},
  {&(_ZTV7S468C21[14]),  14,98},
  {&(_ZTV7S468C21[24]),  24,98},
  {&(_ZTV7S468C21[36]),  36,98},
  {&(_ZTV7S468C21[31]),  31,98},
  {&(_ZTV7S468C21[41]),  41,98},
  {&(_ZTV7S468C21[54]),  54,98},
  {&(_ZTV7S468C21[58]),  58,98},
  {&(_ZTV7S468C21[62]),  62,98},
  {&(_ZTV7S468C21[68]),  68,98},
  {&(_ZTV7S468C21[72]),  72,98},
  {&(_ZTV7S468C21[86]),  86,98},
  {&(_ZTV7S468C21[90]),  90,98},
  {&(_ZTV7S468C21[94]),  94,98},
  {&(_tg__ZTV6S468C4__7S468C21[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C4__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C4__7S468C21[4]),  4,6},
  {&(_tg__ZTV7S468C11__7S468C21[6]),  6,8},
  {&(_tg__ZTV7S468C127S468C11__7S468C21[5]),  5,7},
  {&(_tg__ZTV7S468C137S468C127S468C11__7S468C21[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C137S468C127S468C11__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C137S468C127S468C11__7S468C21[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C137S468C127S468C11__7S468C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C137S468C127S468C11__7S468C21[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C127S468C11__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C127S468C11__7S468C21[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C127S468C11__7S468C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C127S468C11__7S468C21[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C11__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C11__7S468C21[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C11__7S468C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C11__7S468C21[2]),  2,4},
  {&(_tg__ZTV6S468C5__A2__7S468C11__7S468C21[4]),  4,6},
  {&(_tg__ZTV7S468C12__A1__7S468C21[5]),  5,7},
  {&(_tg__ZTV7S468C137S468C12__A1__7S468C21[5]),  5,7},
  {&(_tg__ZTV6S468C6__7S468C137S468C12__A1__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C137S468C12__A1__7S468C21[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C137S468C12__A1__7S468C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C137S468C12__A1__7S468C21[2]),  2,4},
  {&(_tg__ZTV6S468C6__7S468C12__A1__7S468C21[3]),  3,4},
  {&(_tg__ZTV6S468C8__7S468C12__A1__7S468C21[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C12__A1__7S468C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S468C4__7S468C12__A1__7S468C21[2]),  2,4},
};
extern VTBL_ENTRY _ZTI7S468C21[];
extern  VTBL_ENTRY _ZTV7S468C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C21[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S468C21D0Ev,_ZTv0_n24_N7S468C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40480_N7S468C21D0Ev,_ZThn26592_N7S468C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S468C21D1Ev,_ZTv0_n24_N7S468C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40480_N7S468C21D1Ev,_ZThn26592_N7S468C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S468C21D0Ev,_ZTv0_n28_N7S468C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15024_N7S468C21D0Ev,_ZThn9828_N7S468C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S468C21D1Ev,_ZTv0_n28_N7S468C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15024_N7S468C21D1Ev,_ZThn9828_N7S468C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C21D0Ev,_ZTv0_n32_N7S468C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N7S468C21D0Ev,_ZThn784_N7S468C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S468C21D1Ev,_ZTv0_n32_N7S468C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N7S468C21D1Ev,_ZThn784_N7S468C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C21 = {  "S468C21", // class name
  bases_S468C21, 19,
  &(vtc_S468C21[0]), // expected_vtbl_contents
  &(vtt_S468C21[0]), // expected_vtt_contents
  ABISELECT(64384,42292), // object size
  NSPAIRA(_ZTI7S468C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S468C21),98, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S468C21),43, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S468C1  : S468C2 , virtual S468C15 , S468C16 {
  __tsi64 s468c1f0;
  void *s468c1f1;
  long double s468c1f2;
  long double s468c1f3[6];
  int s468c1f4;
  int s468c1f5;
  long double s468c1f6;
  ::S468C21 s468c1f7;
  ::S468C14_nt s468c1f8[5];
  ::S468C12 s468c1f9;
  ::S468C12 s468c1f10;
  int s468c1f11;
  ::S468C14_nt s468c1f12;
  ~S468C1(); // tgen
  S468C1(); // tgen
};
//SIG(1 S468C1) C1{ BC2{ BC3{ BC4{ BC5{ v1 v2 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC6{ v3 FC5[8] FC5[2] Fp Fi FC7{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} BC7 VBC8{ v4 v5 Fc FL[10] FD FC5 Fp Fs Fp Fi} v6 FL:2 FD[7] Fp FC6 Fp Fi Fp[2] FC7 FC5 FD[8]} BC8 BC7 BC6 VBC5 vd v7 v8 FC7 Fi Fp[2] FL[2] Fi[2] Fp Fi FC8 Fi} BC4 VBC9{ vd v9 v10 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC8 FL Fi FC8} vd v11 Fp FD FD FC11{ BC12{ BC13{ VBC6 VBC8 VBC4 BC7 Fp FC7 FC5 Fs} BC5 BC9 FC3} VBC5 BC7 BC9 FC14{ m Fc} Fi Fi Fi:6 FC14 Fi}} VBC15{ BC7 BC8 BC4 Fp FC4 Fc[7] FC9 Fi Fc[4] Fp FC4 Fi Fi[7] Fi} BC16{ m FC12 FC17{ VBC6 BC15 BC18{ BC6 VBC5 VBC19{ BC6 BC7 VBC5 vd v12 Fi Fs Fs:1 Fp Fl FC6 Fi[2] Fc[3] Fi} BC12 vd Fp} Fp Fi[4] FC20{} FC12 FC14 Fi Fi:24 FC14 Fi FC20} Fi FC5 FC14 Fp Fi:15 Fi Fi} FL Fp FD FD[6] Fi Fi FD FC21{ VBC8 VBC4 VBC5 VBC11 VBC12 vd Fp FC5 Fp Fp Fi FC5 Fs Fi Fc[10] Fp Fi Fl[4] Fp} FC14[5] FC12 FC12 Fi FC14}


S468C1 ::~S468C1(){ note_dtor("S468C1", this);} // tgen
S468C1 ::S468C1(){ note_ctor("S468C1", this);} // tgen

static void Test_S468C1()
{
  extern Class_Descriptor cd_S468C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26154,68661)];
    init_test(&cd_S468C1, buf);
    S468C1 *dp, &lv = *(dp=new (buf) S468C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(418448,274640), "sizeof(S468C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S468C1)");
    check_base_class_offset(lv, (S468C5*)(S468C4*)(S468C3*)(S468C2*), 0, "S468C1");
    check_base_class_offset(lv, (S468C6*)(S468C4*)(S468C3*)(S468C2*), ABISELECT(372688,244540), "S468C1");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C4*)(S468C2*), ABISELECT(372688,244540), "S468C1");
    check_base_class_offset(lv, (S468C6*)(S468C4*)(S468C15*), ABISELECT(372688,244540), "S468C1");
    check_base_class_offset(lv, (S468C7*)(S468C4*)(S468C3*)(S468C2*), ABISELECT(296,200), "S468C1");
    check_base_class_offset(lv, (S468C8*)(S468C4*)(S468C3*)(S468C2*), ABISELECT(378928,248616), "S468C1");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C4*)(S468C2*), ABISELECT(378928,248616), "S468C1");
    check_base_class_offset(lv, (S468C8*)(S468C4*)(S468C15*), ABISELECT(378928,248616), "S468C1");
    check_base_class_offset(lv, (S468C4*)(S468C3*)(S468C2*), 0, "S468C1");
    /*is_ambiguous_... S468C3::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C3*)(S468C2*), ABISELECT(7296,4768), "S468C1");
    /*is_ambiguous_... S468C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C3*)(S468C2*), ABISELECT(7744,5084), "S468C1");
    /*is_ambiguous_... S468C3::S468C6 */ AMB_check_base_class_offset(lv, (S468C6*)(S468C3*)(S468C2*), ABISELECT(7824,5128), "S468C1");
    /*is_ambiguous_... S468C3::S468C5 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C3*)(S468C2*), ABISELECT(379376,248932), "S468C1");
    check_base_class_offset(lv, (S468C3*)(S468C2*), 0, "S468C1");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C5*)(S468C4*)(S468C2*), ABISELECT(14672,9612), "S468C1");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C4*)(S468C2*), ABISELECT(14968,9812), "S468C1");
    /*is_ambiguous_... S468C2::S468C4 */ AMB_check_base_class_offset(lv, (S468C4*)(S468C2*), ABISELECT(14672,9612), "S468C1");
    check_base_class_offset(lv, (S468C9*)(S468C2*), ABISELECT(379680,249132), "S468C1");
    check_base_class_offset(lv, (S468C2*), 0, "S468C1");
    /*is_ambiguous_... S468C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S468C15*), ABISELECT(381120,250132), "S468C1");
    /*is_ambiguous_... S468C15::S468C8 */ AMB_check_base_class_offset(lv, (S468C8*)(S468C15*), ABISELECT(381200,250176), "S468C1");
    check_base_class_offset(lv, (S468C5*)(S468C4*)(S468C15*), ABISELECT(381648,250492), "S468C1");
    check_base_class_offset(lv, (S468C7*)(S468C4*)(S468C15*), ABISELECT(381944,250692), "S468C1");
    check_base_class_offset(lv, (S468C4*)(S468C15*), ABISELECT(381648,250492), "S468C1");
    check_base_class_offset(lv, (S468C15*), ABISELECT(381120,250132), "S468C1");
    check_base_class_offset(lv, (S468C16*), ABISELECT(61760,40532), "S468C1");
    check_field_offset(lv, s468c1f0, ABISELECT(232336,152396), "S468C1.s468c1f0");
    check_field_offset(lv, s468c1f1, ABISELECT(232344,152404), "S468C1.s468c1f1");
    check_field_offset(lv, s468c1f2, ABISELECT(232352,152408), "S468C1.s468c1f2");
    check_field_offset(lv, s468c1f3, ABISELECT(232368,152420), "S468C1.s468c1f3");
    check_field_offset(lv, s468c1f4, ABISELECT(232464,152492), "S468C1.s468c1f4");
    check_field_offset(lv, s468c1f5, ABISELECT(232468,152496), "S468C1.s468c1f5");
    check_field_offset(lv, s468c1f6, ABISELECT(232480,152500), "S468C1.s468c1f6");
    check_field_offset(lv, s468c1f7, ABISELECT(232496,152512), "S468C1.s468c1f7");
    check_field_offset(lv, s468c1f8, ABISELECT(296880,194804), "S468C1.s468c1f8");
    check_field_offset(lv, s468c1f9, ABISELECT(296896,194812), "S468C1.s468c1f9");
    check_field_offset(lv, s468c1f10, ABISELECT(334784,219672), "S468C1.s468c1f10");
    check_field_offset(lv, s468c1f11, ABISELECT(372672,244532), "S468C1.s468c1f11");
    check_field_offset(lv, s468c1f12, ABISELECT(372676,244536), "S468C1.s468c1f12");
    test_class_info(&lv, &cd_S468C1);
    dp->~S468C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS468C1(Test_S468C1, "S468C1", ABISELECT(418448,274640));

#else // __cplusplus

extern void _ZN6S468C1C1Ev();
extern void _ZN6S468C1D1Ev();
Name_Map name_map_S468C1[] = {
  NSPAIR(_ZN6S468C1C1Ev),
  NSPAIR(_ZN6S468C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C6;
extern VTBL_ENTRY _ZTI6S468C6[];
extern  VTBL_ENTRY _ZTV6S468C6[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C3;
extern VTBL_ENTRY _ZTI6S468C3[];
extern  VTBL_ENTRY _ZTV6S468C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C3[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C9;
extern VTBL_ENTRY _ZTI6S468C9[];
extern  VTBL_ENTRY _ZTV6S468C9[];
extern Class_Descriptor cd_S468C2;
extern VTBL_ENTRY _ZTI6S468C2[];
extern  VTBL_ENTRY _ZTV6S468C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C2[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C8;
extern VTBL_ENTRY _ZTI6S468C8[];
extern  VTBL_ENTRY _ZTV6S468C8[];
extern Class_Descriptor cd_S468C5;
extern VTBL_ENTRY _ZTI6S468C5[];
extern  VTBL_ENTRY _ZTV6S468C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S468C4;
extern VTBL_ENTRY _ZTI6S468C4[];
extern  VTBL_ENTRY _ZTV6S468C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C4[];
extern Class_Descriptor cd_S468C15;
extern VTBL_ENTRY _ZTI7S468C15[];
extern  VTBL_ENTRY _ZTV7S468C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S468C15[];
extern Class_Descriptor cd_S468C16;
extern VTBL_ENTRY _ZTI7S468C16[];
static Base_Class bases_S468C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(372688,244540), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(378928,248616), //bcp->offset
    47, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(7296,4768), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C6,    ABISELECT(7824,5128), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(379376,248932), //bcp->offset
    53, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S468C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(14672,9612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(14968,9812), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(14672,9612), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S468C9,    ABISELECT(379680,249132), //bcp->offset
    59, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S468C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(381120,250132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C8,    ABISELECT(381200,250176), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C5,    ABISELECT(381648,250492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(381944,250692), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S468C4,    ABISELECT(381648,250492), //bcp->offset
    84, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S468C15,    ABISELECT(381120,250132), //bcp->offset
    68, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C16,    ABISELECT(61760,40532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S468C1[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C1D1Ev();
extern void _ZN6S468C1D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
extern void _ZN6S468C23v11Ev();
extern void ABISELECT(_ZThn296_N6S468C1D1Ev,_ZThn200_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn296_N6S468C1D0Ev,_ZThn200_N6S468C1D0Ev)();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S468C1D1Ev,_ZThn5084_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn7744_N6S468C1D0Ev,_ZThn5084_N6S468C1D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S468C1D1Ev,_ZThn9612_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn14672_N6S468C1D0Ev,_ZThn9612_N6S468C1D0Ev)();
extern void ABISELECT(_ZThn14968_N6S468C1D1Ev,_ZThn9812_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn14968_N6S468C1D0Ev,_ZThn9812_N6S468C1D0Ev)();
extern void _ZN6S468C62v3Ev();
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void ABISELECT(_ZTv0_n24_N6S468C1D1Ev,_ZTv0_n12_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn379680_N6S468C1D1Ev,_ZThn249132_N6S468C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S468C1D0Ev,_ZTv0_n12_N6S468C1D0Ev)();
extern void ABISELECT(_ZThn379680_N6S468C1D0Ev,_ZThn249132_N6S468C1D0Ev)() __attribute__((weak));
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
extern void ABISELECT(_ZTv0_n40_N6S468C1D1Ev,_ZTv0_n20_N6S468C1D1Ev)();
extern void ABISELECT(_ZThn381120_N6S468C1D1Ev,_ZThn250132_N6S468C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6S468C1D0Ev,_ZTv0_n20_N6S468C1D0Ev)();
extern void ABISELECT(_ZThn381120_N6S468C1D0Ev,_ZThn250132_N6S468C1D0Ev)() __attribute__((weak));
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZTvn528_n40_N6S468C1D1Ev,_ZTvn360_n20_N6S468C1D1Ev)();
extern void ABISELECT(_ZTvn528_n40_N6S468C1D0Ev,_ZTvn360_n20_N6S468C1D0Ev)();
extern void ABISELECT(_ZTvn824_n40_N6S468C1D1Ev,_ZTvn560_n20_N6S468C1D1Ev)();
extern void ABISELECT(_ZTvn824_n40_N6S468C1D0Ev,_ZTvn560_n20_N6S468C1D0Ev)();
static  VTBL_ENTRY vtc_S468C1[] = {
  ABISELECT(381120,250132),
  ABISELECT(379680,249132),
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C1D1Ev,
  (VTBL_ENTRY)&_ZN6S468C1D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
  (VTBL_ENTRY)&_ZN6S468C23v11Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C1D1Ev,_ZThn200_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S468C1D0Ev,_ZThn200_N6S468C1D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C1D1Ev,_ZThn5084_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S468C1D0Ev,_ZThn5084_N6S468C1D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C1D1Ev,_ZThn9612_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C1D0Ev,_ZThn9612_N6S468C1D0Ev),
  ABISELECT(-14968,-9812),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S468C1D1Ev,_ZThn9812_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S468C1D0Ev,_ZThn9812_N6S468C1D0Ev),
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  0,
  0,
  ABISELECT(-379680,-249132),
  ABISELECT(-379680,-249132),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C1D1Ev,_ZTv0_n12_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C1D0Ev,_ZTv0_n12_N6S468C1D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
  ABISELECT(528,360),
  ABISELECT(528,360),
  ABISELECT(528,360),
  ABISELECT(80,44),
  ABISELECT(80,44),
  ABISELECT(-381120,-250132),
  ABISELECT(-2192,-1516),
  ABISELECT(-8432,-5592),
  ABISELECT(-381120,-250132),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6S468C1D1Ev,_ZTv0_n20_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6S468C1D0Ev,_ZTv0_n20_N6S468C1D0Ev),
  ABISELECT(-381200,-250176),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  ABISELECT(-381648,-250492),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn528_n40_N6S468C1D1Ev,_ZTvn360_n20_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn528_n40_N6S468C1D0Ev,_ZTvn360_n20_N6S468C1D0Ev),
  ABISELECT(-381944,-250692),
  (VTBL_ENTRY)&(_ZTI6S468C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn824_n40_N6S468C1D1Ev,_ZTvn560_n20_N6S468C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn824_n40_N6S468C1D0Ev,_ZTvn560_n20_N6S468C1D0Ev),
};
extern VTBL_ENTRY _ZTV6S468C1[];
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C2D1Ev();
extern void _ZN6S468C2D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
extern void _ZN6S468C23v11Ev();
static  VTBL_ENTRY _tg__ZTV6S468C2__6S468C1[] = {
  ABISELECT(379680,249132),
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C2D1Ev,
  (VTBL_ENTRY)&_ZN6S468C2D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
  (VTBL_ENTRY)&_ZN6S468C23v11Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C3D1Ev();
extern void _ZN6S468C3D0Ev();
extern void _ZN6S468C32v7Ev();
extern void _ZN6S468C32v8Ev();
static  VTBL_ENTRY _tg__ZTV6S468C36S468C2__6S468C1[] = {
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C3D1Ev,
  (VTBL_ENTRY)&_ZN6S468C3D0Ev,
  (VTBL_ENTRY)&_ZN6S468C32v7Ev,
  (VTBL_ENTRY)&_ZN6S468C32v8Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C46S468C36S468C2__6S468C1[] = {
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C46S468C36S468C2__6S468C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C46S468C36S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C36S468C2__6S468C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C36S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__A1__6S468C36S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S468C3[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C46S468C2__A1__6S468C1[] = {
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C46S468C2__A1__6S468C1[] = {
  0,
  ABISELECT(-358016,-234928),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C46S468C2__A1__6S468C1[] = {
  0,
  0,
  ABISELECT(-364256,-239004),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C2__6S468C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S468C5__A1__6S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S468C2D1Ev,_ZThn9612_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn14672_N6S468C2D0Ev,_ZThn9612_N6S468C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__A1__6S468C2__6S468C1[] = {
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C2D1Ev,_ZThn9612_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S468C2D0Ev,_ZThn9612_N6S468C2D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev)();
extern void ABISELECT(_ZThn379680_N6S468C2D1Ev,_ZThn249132_N6S468C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev)();
extern void ABISELECT(_ZThn379680_N6S468C2D0Ev,_ZThn249132_N6S468C2D0Ev)() __attribute__((weak));
extern void _ZN6S468C92v9Ev();
extern void _ZN6S468C93v10Ev();
static  VTBL_ENTRY _tg__ZTV6S468C9__6S468C2__6S468C1[] = {
  0,
  0,
  ABISELECT(-379680,-249132),
  ABISELECT(-379680,-249132),
  (VTBL_ENTRY)&(_ZTI6S468C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev),
  (VTBL_ENTRY)&_ZN6S468C92v9Ev,
  (VTBL_ENTRY)&_ZN6S468C93v10Ev,
};
extern void _ZN7S468C15D1Ev();
extern void _ZN7S468C15D0Ev();
static  VTBL_ENTRY _tg__ZTV7S468C15__6S468C1[] = {
  ABISELECT(-2192,-1516),
  ABISELECT(-8432,-5592),
  0,
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN7S468C15D1Ev,
  (VTBL_ENTRY)&_ZN7S468C15D0Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void _ZN6S468C4D1Ev();
extern void _ZN6S468C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S468C47S468C15__A2__6S468C1[] = {
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  0,
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&_ZN6S468C4D1Ev,
  (VTBL_ENTRY)&_ZN6S468C4D0Ev,
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__6S468C47S468C15__A2__6S468C1[] = {
  0,
  ABISELECT(8960,5952),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__6S468C47S468C15__A2__6S468C1[] = {
  0,
  0,
  ABISELECT(2720,1876),
  (VTBL_ENTRY)&(_ZTI6S468C4[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
extern void _ZN6S468C52v1Ev();
extern void _ZN6S468C52v2Ev();
extern void _ZN6S468C42v6Ev();
extern void ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C4__7S468C15__6S468C1[] = {
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C52v1Ev,
  (VTBL_ENTRY)&_ZN6S468C52v2Ev,
  (VTBL_ENTRY)&_ZN6S468C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D1Ev,_ZThn360_N7S468C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S468C15D0Ev,_ZThn360_N7S468C15D0Ev),
};
extern void _ZN6S468C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S468C6__7S468C15__6S468C1[] = {
  0,
  ABISELECT(8432,5592),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C62v3Ev,
};
extern void _ZN6S468C82v4Ev();
extern void _ZN6S468C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S468C8__A1__7S468C15__6S468C1[] = {
  0,
  0,
  ABISELECT(2192,1516),
  (VTBL_ENTRY)&(_ZTI7S468C15[0]),
  (VTBL_ENTRY)&_ZN6S468C82v4Ev,
  (VTBL_ENTRY)&_ZN6S468C82v5Ev,
};
static  VTT_ENTRY vtt_S468C1[] = {
  {&(_ZTV6S468C1[7]),  7,97},
  {&(_tg__ZTV6S468C2__6S468C1[6]),  6,14},
  {&(_tg__ZTV6S468C36S468C2__6S468C1[5]),  5,12},
  {&(_tg__ZTV6S468C46S468C36S468C2__6S468C1[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C46S468C36S468C2__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C46S468C36S468C2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C6__6S468C36S468C2__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C36S468C2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C5__A1__6S468C36S468C2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C46S468C2__A1__6S468C1[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C46S468C2__A1__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C46S468C2__A1__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C6__6S468C2__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C5__A1__6S468C2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C4__A1__6S468C2__6S468C1[4]),  4,9},
  {&(_tg__ZTV6S468C9__6S468C2__6S468C1[5]),  5,9},
  {&(_ZTV6S468C1[46]),  46,97},
  {&(_ZTV6S468C1[51]),  51,97},
  {&(_ZTV6S468C1[57]),  57,97},
  {&(_ZTV6S468C1[34]),  34,97},
  {&(_ZTV6S468C1[64]),  64,97},
  {&(_ZTV6S468C1[78]),  78,97},
  {&(_ZTV6S468C1[82]),  82,97},
  {&(_ZTV6S468C1[88]),  88,97},
  {&(_ZTV6S468C1[95]),  95,97},
  {&(_tg__ZTV7S468C15__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C47S468C15__A2__6S468C1[4]),  4,9},
  {&(_tg__ZTV6S468C6__6S468C47S468C15__A2__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__6S468C47S468C15__A2__6S468C1[4]),  4,6},
  {&(_tg__ZTV6S468C4__7S468C15__6S468C1[4]),  4,9},
  {&(_tg__ZTV6S468C6__7S468C15__6S468C1[3]),  3,4},
  {&(_tg__ZTV6S468C8__A1__7S468C15__6S468C1[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6S468C1[];
extern  VTBL_ENTRY _ZTV6S468C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S468C1[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C2D0Ev,_ZTv0_n12_N6S468C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S468C2D0Ev,_ZThn249132_N6S468C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C2D1Ev,_ZTv0_n12_N6S468C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S468C2D1Ev,_ZThn249132_N6S468C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6S468C1D0Ev,_ZTv0_n20_N6S468C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn381120_N6S468C1D0Ev,_ZThn250132_N6S468C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6S468C1D1Ev,_ZTv0_n20_N6S468C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn381120_N6S468C1D1Ev,_ZThn250132_N6S468C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C1D0Ev,_ZTv0_n12_N6S468C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S468C1D0Ev,_ZThn249132_N6S468C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S468C1D1Ev,_ZTv0_n12_N6S468C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S468C1D1Ev,_ZThn249132_N6S468C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S468C1 = {  "S468C1", // class name
  bases_S468C1, 22,
  &(vtc_S468C1[0]), // expected_vtbl_contents
  &(vtt_S468C1[0]), // expected_vtt_contents
  ABISELECT(418448,274640), // object size
  NSPAIRA(_ZTI6S468C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S468C1),97, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S468C1),33, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C5  {
  __tsi64 s467c5f0;
  void *s467c5f1;
  char s467c5f2:6;
  long double s467c5f3;
  char s467c5f4[7];
  __tsi64 s467c5f5;
  char s467c5f6[9];
  long double s467c5f7[8];
  void *s467c5f8;
  short s467c5f9;
  void *s467c5f10[7];
  int s467c5f11;
  void *s467c5f12;
  virtual void  v1(); // _ZN6S467C52v1Ev
  virtual void  v2(); // _ZN6S467C52v2Ev
  ~S467C5(); // tgen
  S467C5(); // tgen
};
//SIG(-1 S467C5) C1{ v1 v2 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}


void  S467C5 ::v1(){vfunc_called(this, "_ZN6S467C52v1Ev");}
void  S467C5 ::v2(){vfunc_called(this, "_ZN6S467C52v2Ev");}
S467C5 ::~S467C5(){ note_dtor("S467C5", this);} // tgen
S467C5 ::S467C5(){ note_ctor("S467C5", this);} // tgen

static void Test_S467C5()
{
  extern Class_Descriptor cd_S467C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,51)];
    init_test(&cd_S467C5, buf);
    S467C5 *dp, &lv = *(dp=new (buf) S467C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,200), "sizeof(S467C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C5)");
    check_field_offset(lv, s467c5f0, ABISELECT(8,4), "S467C5.s467c5f0");
    check_field_offset(lv, s467c5f1, ABISELECT(16,12), "S467C5.s467c5f1");
    set_bf_and_test(lv, s467c5f2, ABISELECT(24,16), 0, 6, 1, "S467C5");
    set_bf_and_test(lv, s467c5f2, ABISELECT(24,16), 0, 6, hide_sll(1LL<<5), "S467C5");
    check_field_offset(lv, s467c5f3, ABISELECT(32,20), "S467C5.s467c5f3");
    check_field_offset(lv, s467c5f4, ABISELECT(48,32), "S467C5.s467c5f4");
    check_field_offset(lv, s467c5f5, ABISELECT(56,40), "S467C5.s467c5f5");
    check_field_offset(lv, s467c5f6, ABISELECT(64,48), "S467C5.s467c5f6");
    check_field_offset(lv, s467c5f7, ABISELECT(80,60), "S467C5.s467c5f7");
    check_field_offset(lv, s467c5f8, ABISELECT(208,156), "S467C5.s467c5f8");
    check_field_offset(lv, s467c5f9, ABISELECT(216,160), "S467C5.s467c5f9");
    check_field_offset(lv, s467c5f10, ABISELECT(224,164), "S467C5.s467c5f10");
    check_field_offset(lv, s467c5f11, ABISELECT(280,192), "S467C5.s467c5f11");
    check_field_offset(lv, s467c5f12, ABISELECT(288,196), "S467C5.s467c5f12");
    test_class_info(&lv, &cd_S467C5);
    dp->~S467C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C5(Test_S467C5, "S467C5", ABISELECT(304,200));

#else // __cplusplus

extern void _ZN6S467C5C1Ev();
extern void _ZN6S467C5D1Ev();
Name_Map name_map_S467C5[] = {
  NSPAIR(_ZN6S467C5C1Ev),
  NSPAIR(_ZN6S467C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S467C5[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY vtc_S467C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S467C5[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
Class_Descriptor cd_S467C5 = {  "S467C5", // class name
  0,0,//no base classes
  &(vtc_S467C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,200), // object size
  NSPAIRA(_ZTI6S467C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S467C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C6  {
  ::S467C5 s467c6f0[8];
  ::S467C5 s467c6f1[2];
  void *s467c6f2;
  int s467c6f3;
  ::S468C7 s467c6f4;
  ::S467C5 s467c6f5[5];
  void *s467c6f6[5];
  ::S467C5 s467c6f7[5];
  virtual void  v3(); // _ZN6S467C62v3Ev
  ~S467C6(); // tgen
  S467C6(); // tgen
};
//SIG(-1 S467C6) C1{ v1 FC2{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC2[2] Fp Fi FC3{ vd m Fp FL Fp[7]} FC2[5] Fp[5] FC2[5]}


void  S467C6 ::v3(){vfunc_called(this, "_ZN6S467C62v3Ev");}
S467C6 ::~S467C6(){ note_dtor("S467C6", this);} // tgen
S467C6 ::S467C6(){ note_ctor("S467C6", this);} // tgen

static void Test_S467C6()
{
  extern Class_Descriptor cd_S467C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(391,1020)];
    init_test(&cd_S467C6, buf);
    S467C6 *dp, &lv = *(dp=new (buf) S467C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6240,4076), "sizeof(S467C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C6)");
    check_field_offset(lv, s467c6f0, ABISELECT(16,4), "S467C6.s467c6f0");
    check_field_offset(lv, s467c6f1, ABISELECT(2448,1604), "S467C6.s467c6f1");
    check_field_offset(lv, s467c6f2, ABISELECT(3056,2004), "S467C6.s467c6f2");
    check_field_offset(lv, s467c6f3, ABISELECT(3064,2008), "S467C6.s467c6f3");
    check_field_offset(lv, s467c6f4, ABISELECT(3072,2012), "S467C6.s467c6f4");
    check_field_offset(lv, s467c6f5, ABISELECT(3152,2056), "S467C6.s467c6f5");
    check_field_offset(lv, s467c6f6, ABISELECT(4672,3056), "S467C6.s467c6f6");
    check_field_offset(lv, s467c6f7, ABISELECT(4720,3076), "S467C6.s467c6f7");
    test_class_info(&lv, &cd_S467C6);
    dp->~S467C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C6(Test_S467C6, "S467C6", ABISELECT(6240,4076));

#else // __cplusplus

extern void _ZN6S467C6C1Ev();
extern void _ZN6S467C6D1Ev();
Name_Map name_map_S467C6[] = {
  NSPAIR(_ZN6S467C6C1Ev),
  NSPAIR(_ZN6S467C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S467C6[];
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY vtc_S467C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S467C6[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
Class_Descriptor cd_S467C6 = {  "S467C6", // class name
  0,0,//no base classes
  &(vtc_S467C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6240,4076), // object size
  NSPAIRA(_ZTI6S467C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S467C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C8  {
  char s467c8f0;
  __tsi64 s467c8f1[10];
  long double s467c8f2;
  ::S467C5 s467c8f3;
  void *s467c8f4;
  short s467c8f5;
  void *s467c8f6;
  int s467c8f7;
  virtual void  v4(); // _ZN6S467C82v4Ev
  virtual void  v5(); // _ZN6S467C82v5Ev
  ~S467C8(); // tgen
  S467C8(); // tgen
};
//SIG(-1 S467C8) C1{ v1 v2 Fc FL[10] FD FC2{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi}


void  S467C8 ::v4(){vfunc_called(this, "_ZN6S467C82v4Ev");}
void  S467C8 ::v5(){vfunc_called(this, "_ZN6S467C82v5Ev");}
S467C8 ::~S467C8(){ note_dtor("S467C8", this);} // tgen
S467C8 ::S467C8(){ note_ctor("S467C8", this);} // tgen

static void Test_S467C8()
{
  extern Class_Descriptor cd_S467C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(29,80)];
    init_test(&cd_S467C8, buf);
    S467C8 *dp, &lv = *(dp=new (buf) S467C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,316), "sizeof(S467C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C8)");
    check_field_offset(lv, s467c8f0, ABISELECT(8,4), "S467C8.s467c8f0");
    check_field_offset(lv, s467c8f1, ABISELECT(16,8), "S467C8.s467c8f1");
    check_field_offset(lv, s467c8f2, ABISELECT(96,88), "S467C8.s467c8f2");
    check_field_offset(lv, s467c8f3, ABISELECT(112,100), "S467C8.s467c8f3");
    check_field_offset(lv, s467c8f4, ABISELECT(416,300), "S467C8.s467c8f4");
    check_field_offset(lv, s467c8f5, ABISELECT(424,304), "S467C8.s467c8f5");
    check_field_offset(lv, s467c8f6, ABISELECT(432,308), "S467C8.s467c8f6");
    check_field_offset(lv, s467c8f7, ABISELECT(440,312), "S467C8.s467c8f7");
    test_class_info(&lv, &cd_S467C8);
    dp->~S467C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C8(Test_S467C8, "S467C8", ABISELECT(448,316));

#else // __cplusplus

extern void _ZN6S467C8C1Ev();
extern void _ZN6S467C8D1Ev();
Name_Map name_map_S467C8[] = {
  NSPAIR(_ZN6S467C8C1Ev),
  NSPAIR(_ZN6S467C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S467C8[];
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY vtc_S467C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S467C8[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
Class_Descriptor cd_S467C8 = {  "S467C8", // class name
  0,0,//no base classes
  &(vtc_S467C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(448,316), // object size
  NSPAIRA(_ZTI6S467C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S467C8),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C4  : S467C5 , virtual S467C6 , S468C7 , virtual S467C8 {
  int s467c4f0:2;
  long double s467c4f1[7];
  void *s467c4f2;
  ::S467C6 s467c4f3;
  void *s467c4f4;
  int s467c4f5;
  void *s467c4f6[2];
  ::S468C7 s467c4f7;
  ::S467C5 s467c4f8;
  long double s467c4f9[8];
  virtual void  v6(); // _ZN6S467C42v6Ev
  ~S467C4(); // tgen
  S467C4(); // tgen
};
//SIG(-1 S467C4) C1{ BC2{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC3{ v4 FC2[8] FC2[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC2[5] Fp[5] FC2[5]} BC4 VBC5{ v5 v6 Fc FL[10] FD FC2 Fp Fs Fp Fi} v1 Fi:2 FD[7] Fp FC3 Fp Fi Fp[2] FC4 FC2 FD[8]}


void  S467C4 ::v6(){vfunc_called(this, "_ZN6S467C42v6Ev");}
S467C4 ::~S467C4(){ note_dtor("S467C4", this);} // tgen
S467C4 ::S467C4(){ note_ctor("S467C4", this);} // tgen

static void Test_S467C4()
{
  extern Class_Descriptor cd_S467C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(875,2291)];
    init_test(&cd_S467C4, buf);
    S467C4 *dp, &lv = *(dp=new (buf) S467C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13984,9160), "sizeof(S467C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C4)");
    check_base_class_offset(lv, (S467C5*), 0, "S467C4");
    check_base_class_offset(lv, (S467C6*), ABISELECT(7296,4768), "S467C4");
    check_base_class_offset(lv, (S468C7*), ABISELECT(296,200), "S467C4");
    check_base_class_offset(lv, (S467C8*), ABISELECT(13536,8844), "S467C4");
    set_bf_and_test(lv, s467c4f0, ABISELECT(376,244), 0, 2, 1, "S467C4");
    set_bf_and_test(lv, s467c4f0, ABISELECT(376,244), 0, 2, hide_sll(1LL<<1), "S467C4");
    check_field_offset(lv, s467c4f1, ABISELECT(384,248), "S467C4.s467c4f1");
    check_field_offset(lv, s467c4f2, ABISELECT(496,332), "S467C4.s467c4f2");
    check_field_offset(lv, s467c4f3, ABISELECT(512,336), "S467C4.s467c4f3");
    check_field_offset(lv, s467c4f4, ABISELECT(6752,4412), "S467C4.s467c4f4");
    check_field_offset(lv, s467c4f5, ABISELECT(6760,4416), "S467C4.s467c4f5");
    check_field_offset(lv, s467c4f6, ABISELECT(6768,4420), "S467C4.s467c4f6");
    check_field_offset(lv, s467c4f7, ABISELECT(6784,4428), "S467C4.s467c4f7");
    check_field_offset(lv, s467c4f8, ABISELECT(6864,4472), "S467C4.s467c4f8");
    check_field_offset(lv, s467c4f9, ABISELECT(7168,4672), "S467C4.s467c4f9");
    test_class_info(&lv, &cd_S467C4);
    dp->~S467C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C4(Test_S467C4, "S467C4", ABISELECT(13984,9160));

#else // __cplusplus

extern void _ZN6S467C4C1Ev();
extern void _ZN6S467C4D1Ev();
Name_Map name_map_S467C4[] = {
  NSPAIR(_ZN6S467C4C1Ev),
  NSPAIR(_ZN6S467C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
static Base_Class bases_S467C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C6,    ABISELECT(7296,4768), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C8,    ABISELECT(13536,8844), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S467C4[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
extern void ABISELECT(_ZThn296_N6S467C4D1Ev,_ZThn200_N6S467C4D1Ev)();
extern void ABISELECT(_ZThn296_N6S467C4D0Ev,_ZThn200_N6S467C4D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY vtc_S467C4[] = {
  ABISELECT(13536,8844),
  ABISELECT(7296,4768),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C4D1Ev,_ZThn200_N6S467C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C4D0Ev,_ZThn200_N6S467C4D0Ev),
  0,
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-13536,-8844),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern VTBL_ENTRY _ZTV6S467C4[];
static  VTT_ENTRY vtt_S467C4[] = {
  {&(_ZTV6S467C4[4]),  4,23},
  {&(_ZTV6S467C4[16]),  16,23},
  {&(_ZTV6S467C4[21]),  21,23},
};
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
Class_Descriptor cd_S467C4 = {  "S467C4", // class name
  bases_S467C4, 4,
  &(vtc_S467C4[0]), // expected_vtbl_contents
  &(vtt_S467C4[0]), // expected_vtt_contents
  ABISELECT(13984,9160), // object size
  NSPAIRA(_ZTI6S467C4),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV6S467C4),23, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S467C4),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C3  : S467C4 , S467C8 , S468C7 , S467C6 , virtual S467C5 {
  ::S468C7 s467c3f0;
  int s467c3f1;
  void *s467c3f2[2];
  __tsi64 s467c3f3[2];
  int s467c3f4[2];
  void *s467c3f5;
  int s467c3f6;
  ::S467C8 s467c3f7;
  int s467c3f8;
  virtual  ~S467C3(); // _ZN6S467C3D2Ev
  virtual void  v7(); // _ZN6S467C32v7Ev
  virtual void  v8(); // _ZN6S467C32v8Ev
  S467C3(); // tgen
};
//SIG(-1 S467C3) C1{ BC2{ BC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC4{ v5 FC3[8] FC3[2] Fp Fi FC5{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC5 VBC6{ v6 v7 Fc FL[10] FD FC3 Fp Fs Fp Fi} v8 Fi:2 FD[7] Fp FC4 Fp Fi Fp[2] FC5 FC3 FD[8]} BC6 BC5 BC4 VBC3 vd v1 v2 FC5 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}


 S467C3 ::~S467C3(){ note_dtor("S467C3", this);}
void  S467C3 ::v7(){vfunc_called(this, "_ZN6S467C32v7Ev");}
void  S467C3 ::v8(){vfunc_called(this, "_ZN6S467C32v8Ev");}
S467C3 ::S467C3(){ note_ctor("S467C3", this);} // tgen

static void Test_S467C3()
{
  extern Class_Descriptor cd_S467C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1355,3552)];
    init_test(&cd_S467C3, buf);
    S467C3 *dp, &lv = *(dp=new (buf) S467C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(21664,14204), "sizeof(S467C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C3)");
    check_base_class_offset(lv, (S467C5*)(S467C4*), 0, "S467C3");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(14672,9612), "S467C3");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(296,200), "S467C3");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(20912,13688), "S467C3");
    check_base_class_offset(lv, (S467C4*), 0, "S467C3");
    /*is_ambiguous_... S467C3::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*), ABISELECT(7296,4768), "S467C3");
    /*is_ambiguous_... S467C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), ABISELECT(7744,5084), "S467C3");
    /*is_ambiguous_... S467C3::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*), ABISELECT(7824,5128), "S467C3");
    /*is_ambiguous_... S467C3::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*), ABISELECT(21360,14004), "S467C3");
    check_field_offset(lv, s467c3f0, ABISELECT(14064,9204), "S467C3.s467c3f0");
    check_field_offset(lv, s467c3f1, ABISELECT(14144,9248), "S467C3.s467c3f1");
    check_field_offset(lv, s467c3f2, ABISELECT(14152,9252), "S467C3.s467c3f2");
    check_field_offset(lv, s467c3f3, ABISELECT(14168,9260), "S467C3.s467c3f3");
    check_field_offset(lv, s467c3f4, ABISELECT(14184,9276), "S467C3.s467c3f4");
    check_field_offset(lv, s467c3f5, ABISELECT(14192,9284), "S467C3.s467c3f5");
    check_field_offset(lv, s467c3f6, ABISELECT(14200,9288), "S467C3.s467c3f6");
    check_field_offset(lv, s467c3f7, ABISELECT(14208,9292), "S467C3.s467c3f7");
    check_field_offset(lv, s467c3f8, ABISELECT(14656,9608), "S467C3.s467c3f8");
    test_class_info(&lv, &cd_S467C3);
    dp->~S467C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C3(Test_S467C3, "S467C3", ABISELECT(21664,14204));

#else // __cplusplus

extern void _ZN6S467C3C1Ev();
extern void _ZN6S467C3D2Ev();
Name_Map name_map_S467C3[] = {
  NSPAIR(_ZN6S467C3C1Ev),
  NSPAIR(_ZN6S467C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
static Base_Class bases_S467C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(14672,9612), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(20912,13688), //bcp->offset
    31, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C8,    ABISELECT(7296,4768), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C6,    ABISELECT(7824,5128), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(21360,14004), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S467C3[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C3D1Ev();
extern void _ZN6S467C3D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
extern void ABISELECT(_ZThn296_N6S467C3D1Ev,_ZThn200_N6S467C3D1Ev)();
extern void ABISELECT(_ZThn296_N6S467C3D0Ev,_ZThn200_N6S467C3D0Ev)();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S467C3D1Ev,_ZThn5084_N6S467C3D1Ev)();
extern void ABISELECT(_ZThn7744_N6S467C3D0Ev,_ZThn5084_N6S467C3D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY vtc_S467C3[] = {
  ABISELECT(21360,14004),
  ABISELECT(20912,13688),
  ABISELECT(14672,9612),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C3D1Ev,
  (VTBL_ENTRY)&_ZN6S467C3D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C3D1Ev,_ZThn200_N6S467C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C3D0Ev,_ZThn200_N6S467C3D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C3D1Ev,_ZThn5084_N6S467C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C3D0Ev,_ZThn5084_N6S467C3D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-20912,-13688),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  0,
  0,
  ABISELECT(-21360,-14004),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern VTBL_ENTRY _ZTV6S467C3[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__6S467C3[] = {
  ABISELECT(20912,13688),
  ABISELECT(14672,9612),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__6S467C3[] = {
  0,
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__6S467C3[] = {
  0,
  0,
  ABISELECT(-20912,-13688),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C3[] = {
  {&(_ZTV6S467C3[5]),  5,43},
  {&(_tg__ZTV6S467C4__6S467C3[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__6S467C3[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__6S467C3[4]),  4,6},
  {&(_ZTV6S467C3[30]),  30,43},
  {&(_ZTV6S467C3[35]),  35,43},
  {&(_ZTV6S467C3[41]),  41,43},
};
extern VTBL_ENTRY _ZTI6S467C3[];
extern  VTBL_ENTRY _ZTV6S467C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C3[];
Class_Descriptor cd_S467C3 = {  "S467C3", // class name
  bases_S467C3, 9,
  &(vtc_S467C3[0]), // expected_vtbl_contents
  &(vtt_S467C3[0]), // expected_vtt_contents
  ABISELECT(21664,14204), // object size
  NSPAIRA(_ZTI6S467C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV6S467C3),43, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S467C3),7, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C9  {
  int s467c9f0;
  ::S467C5 s467c9f1;
  int s467c9f2[2];
  ::S468C10 s467c9f3;
  long double s467c9f4;
  int s467c9f5;
  int s467c9f6;
  ::S467C8 s467c9f7;
  __tsi64 s467c9f8;
  int s467c9f9;
  ::S467C8 s467c9f10;
  virtual  ~S467C9(); // _ZN6S467C9D1Ev
  virtual void  v9(); // _ZN6S467C92v9Ev
  virtual void  v10(); // _ZN6S467C93v10Ev
  S467C9(); // tgen
};
//SIG(-1 S467C9) C1{ vd v1 v2 Fi FC2{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fi[2] FU3{ m FL FD[10] FD Fs:0} FD Fi Fi FC4{ v5 v6 Fc FL[10] FD FC2 Fp Fs Fp Fi} FL Fi FC4}


 S467C9 ::~S467C9(){ note_dtor("S467C9", this);}
void  S467C9 ::v9(){vfunc_called(this, "_ZN6S467C92v9Ev");}
void  S467C9 ::v10(){vfunc_called(this, "_ZN6S467C93v10Ev");}
S467C9 ::S467C9(){ note_ctor("S467C9", this);} // tgen

static void Test_S467C9()
{
  extern Class_Descriptor cd_S467C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(91,251)];
    init_test(&cd_S467C9, buf);
    S467C9 *dp, &lv = *(dp=new (buf) S467C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1440,1000), "sizeof(S467C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C9)");
    check_field_offset(lv, s467c9f0, ABISELECT(8,4), "S467C9.s467c9f0");
    check_field_offset(lv, s467c9f1, ABISELECT(16,8), "S467C9.s467c9f1");
    check_field_offset(lv, s467c9f2, ABISELECT(320,208), "S467C9.s467c9f2");
    check_field_offset(lv, s467c9f3, ABISELECT(336,216), "S467C9.s467c9f3");
    check_field_offset(lv, s467c9f4, ABISELECT(496,336), "S467C9.s467c9f4");
    check_field_offset(lv, s467c9f5, ABISELECT(512,348), "S467C9.s467c9f5");
    check_field_offset(lv, s467c9f6, ABISELECT(516,352), "S467C9.s467c9f6");
    check_field_offset(lv, s467c9f7, ABISELECT(528,356), "S467C9.s467c9f7");
    check_field_offset(lv, s467c9f8, ABISELECT(976,672), "S467C9.s467c9f8");
    check_field_offset(lv, s467c9f9, ABISELECT(984,680), "S467C9.s467c9f9");
    check_field_offset(lv, s467c9f10, ABISELECT(992,684), "S467C9.s467c9f10");
    test_class_info(&lv, &cd_S467C9);
    dp->~S467C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C9(Test_S467C9, "S467C9", ABISELECT(1440,1000));

#else // __cplusplus

extern void _ZN6S467C9C1Ev();
extern void _ZN6S467C9D1Ev();
Name_Map name_map_S467C9[] = {
  NSPAIR(_ZN6S467C9C1Ev),
  NSPAIR(_ZN6S467C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S467C9[];
extern void _ZN6S467C9D1Ev();
extern void _ZN6S467C9D0Ev();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
static  VTBL_ENTRY vtc_S467C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S467C9[0]),
  (VTBL_ENTRY)&_ZN6S467C9D1Ev,
  (VTBL_ENTRY)&_ZN6S467C9D0Ev,
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
};
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
Class_Descriptor cd_S467C9 = {  "S467C9", // class name
  0,0,//no base classes
  &(vtc_S467C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1440,1000), // object size
  NSPAIRA(_ZTI6S467C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S467C9),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C13  : virtual S467C6 , virtual S467C8 , virtual S467C4 , S468C7 {
  void *s467c13f0;
  ::S468C7 s467c13f1;
  ::S467C5 s467c13f2;
  short s467c13f3;
  ~S467C13(); // tgen
  S467C13(); // tgen
};
//SIG(-1 S467C13) C1{ VBC2{ v1 FC3{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} VBC5{ v2 v3 Fc FL[10] FD FC3 Fp Fs Fp Fi} VBC6{ BC3 VBC2 BC4 VBC5 v6 Fi:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} BC4 Fp FC4 FC3 Fs}


S467C13 ::~S467C13(){ note_dtor("S467C13", this);} // tgen
S467C13 ::S467C13(){ note_ctor("S467C13", this);} // tgen

static void Test_S467C13()
{
  extern Class_Descriptor cd_S467C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(906,2365)];
    init_test(&cd_S467C13, buf);
    S467C13 *dp, &lv = *(dp=new (buf) S467C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14480,9456), "sizeof(S467C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C13)");
    check_base_class_offset(lv, (S467C6*), ABISELECT(496,296), "S467C13");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(496,296), "S467C13");
    check_base_class_offset(lv, (S467C8*), ABISELECT(6736,4372), "S467C13");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(6736,4372), "S467C13");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(7184,4688), "S467C13");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(7480,4888), "S467C13");
    check_base_class_offset(lv, (S467C4*), ABISELECT(7184,4688), "S467C13");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), 0, "S467C13");
    check_field_offset(lv, s467c13f0, ABISELECT(80,44), "S467C13.s467c13f0");
    check_field_offset(lv, s467c13f1, ABISELECT(88,48), "S467C13.s467c13f1");
    check_field_offset(lv, s467c13f2, ABISELECT(176,92), "S467C13.s467c13f2");
    check_field_offset(lv, s467c13f3, ABISELECT(480,292), "S467C13.s467c13f3");
    test_class_info(&lv, &cd_S467C13);
    dp->~S467C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C13(Test_S467C13, "S467C13", ABISELECT(14480,9456));

#else // __cplusplus

extern void _ZN7S467C13C1Ev();
extern void _ZN7S467C13D1Ev();
Name_Map name_map_S467C13[] = {
  NSPAIR(_ZN7S467C13C1Ev),
  NSPAIR(_ZN7S467C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
static Base_Class bases_S467C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    ABISELECT(496,296), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C8,    ABISELECT(6736,4372), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C5,    ABISELECT(7184,4688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7480,4888), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(7184,4688), //bcp->offset
    17, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C13[];
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZThn7184_N7S467C13D1Ev,_ZThn4688_N7S467C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
extern void ABISELECT(_ZThn7184_N7S467C13D0Ev,_ZThn4688_N7S467C13D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY vtc_S467C13[] = {
  ABISELECT(7184,4688),
  ABISELECT(6736,4372),
  ABISELECT(496,296),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
  0,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-6736,-4372),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-7184,-4688),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-7184,-4688),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
  ABISELECT(-7480,-4888),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern VTBL_ENTRY _ZTV7S467C13[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C13[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C13[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C13[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C13[] = {
  {&(_ZTV7S467C13[5]),  5,34},
  {&(_ZTV7S467C13[10]),  10,34},
  {&(_ZTV7S467C13[15]),  15,34},
  {&(_ZTV7S467C13[25]),  25,34},
  {&(_ZTV7S467C13[32]),  32,34},
  {&(_tg__ZTV6S467C4__7S467C13[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C13[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C13[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7184_N7S467C13D0Ev,_ZThn4688_N7S467C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7184_N7S467C13D1Ev,_ZThn4688_N7S467C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C13 = {  "S467C13", // class name
  bases_S467C13, 6,
  &(vtc_S467C13[0]), // expected_vtbl_contents
  &(vtt_S467C13[0]), // expected_vtt_contents
  ABISELECT(14480,9456), // object size
  NSPAIRA(_ZTI7S467C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S467C13),34, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C13),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C12  : S467C13 , S467C5 , S467C9 {
  ::S467C3 s467c12f0;
  ~S467C12(); // tgen
  S467C12(); // tgen
};
//SIG(-1 S467C12) C1{ BC2{ VBC3{ v1 FC4{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC4[2] Fp Fi FC5{ vd m Fp FL Fp[7]} FC4[5] Fp[5] FC4[5]} VBC6{ v2 v3 Fc FL[10] FD FC4 Fp Fs Fp Fi} VBC7{ BC4 VBC3 BC5 VBC6 v6 Fi:2 FD[7] Fp FC3 Fp Fi Fp[2] FC5 FC4 FD[8]} BC5 Fp FC5 FC4 Fs} BC4 BC8{ vd v7 v8 Fi FC4 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC6 FL Fi FC6} FC10{ BC7 BC6 BC5 BC3 VBC4 vd v9 v10 FC5 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}}


S467C12 ::~S467C12(){ note_dtor("S467C12", this);} // tgen
S467C12 ::S467C12(){ note_ctor("S467C12", this);} // tgen

static void Test_S467C12()
{
  extern Class_Descriptor cd_S467C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2369,6216)];
    init_test(&cd_S467C12, buf);
    S467C12 *dp, &lv = *(dp=new (buf) S467C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(37888,24860), "sizeof(S467C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C12)");
    check_base_class_offset(lv, (S467C6*)(S467C13*), ABISELECT(23904,15700), "S467C12");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(23904,15700), "S467C12");
    check_base_class_offset(lv, (S467C8*)(S467C13*), ABISELECT(30144,19776), "S467C12");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(30144,19776), "S467C12");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(30592,20092), "S467C12");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(30888,20292), "S467C12");
    check_base_class_offset(lv, (S467C4*)(S467C13*), ABISELECT(30592,20092), "S467C12");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*), 0, "S467C12");
    check_base_class_offset(lv, (S467C13*), 0, "S467C12");
    /*is_ambiguous_... S467C12::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*), ABISELECT(496,296), "S467C12");
    check_base_class_offset(lv, (S467C9*), ABISELECT(800,496), "S467C12");
    check_field_offset(lv, s467c12f0, ABISELECT(2240,1496), "S467C12.s467c12f0");
    test_class_info(&lv, &cd_S467C12);
    dp->~S467C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C12(Test_S467C12, "S467C12", ABISELECT(37888,24860));

#else // __cplusplus

extern void _ZN7S467C12C1Ev();
extern void _ZN7S467C12D1Ev();
Name_Map name_map_S467C12[] = {
  NSPAIR(_ZN7S467C12C1Ev),
  NSPAIR(_ZN7S467C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
static Base_Class bases_S467C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    ABISELECT(23904,15700), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C8,    ABISELECT(30144,19776), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C5,    ABISELECT(30592,20092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(30888,20292), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(30592,20092), //bcp->offset
    27, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S467C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(496,296), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C9,    ABISELECT(800,496), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C12[];
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZThn800_N7S467C12D1Ev,_ZThn496_N7S467C12D1Ev)();
extern void ABISELECT(_ZThn800_N7S467C12D0Ev,_ZThn496_N7S467C12D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZThn30592_N7S467C12D1Ev,_ZThn20092_N7S467C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
extern void ABISELECT(_ZThn30592_N7S467C12D0Ev,_ZThn20092_N7S467C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY vtc_S467C12[] = {
  ABISELECT(30592,20092),
  ABISELECT(30144,19776),
  ABISELECT(23904,15700),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-800,-496),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S467C12D1Ev,_ZThn496_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S467C12D0Ev,_ZThn496_N7S467C12D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  0,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-30144,-19776),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-30592,-20092),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-30592,-20092),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
  ABISELECT(-30888,-20292),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
extern VTBL_ENTRY _ZTV7S467C12[];
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C13__7S467C12[] = {
  ABISELECT(30592,20092),
  ABISELECT(30144,19776),
  ABISELECT(23904,15700),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C13__7S467C12[] = {
  0,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C13__7S467C12[] = {
  0,
  0,
  ABISELECT(-30144,-19776),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZThn30592_N7S467C13D1Ev,_ZThn20092_N7S467C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
extern void ABISELECT(_ZThn30592_N7S467C13D0Ev,_ZThn20092_N7S467C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C13__7S467C12[] = {
  ABISELECT(-30592,-20092),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-30592,-20092),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C13__7S467C12[] = {
  ABISELECT(-30888,-20292),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C12[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C12[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C12[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C12[] = {
  {&(_ZTV7S467C12[5]),  5,44},
  {&(_tg__ZTV7S467C13__7S467C12[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C13__7S467C12[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C13__7S467C12[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C13__7S467C12[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C13__7S467C12[2]),  2,4},
  {&(_ZTV7S467C12[20]),  20,44},
  {&(_ZTV7S467C12[25]),  25,44},
  {&(_ZTV7S467C12[35]),  35,44},
  {&(_ZTV7S467C12[42]),  42,44},
  {&(_tg__ZTV6S467C4__7S467C12[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C12[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S467C13D0Ev,_ZThn20092_N7S467C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S467C13D1Ev,_ZThn20092_N7S467C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S467C12D0Ev,_ZThn20092_N7S467C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30592_N7S467C12D1Ev,_ZThn20092_N7S467C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C12 = {  "S467C12", // class name
  bases_S467C12, 9,
  &(vtc_S467C12[0]), // expected_vtbl_contents
  &(vtt_S467C12[0]), // expected_vtt_contents
  ABISELECT(37888,24860), // object size
  NSPAIRA(_ZTI7S467C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S467C12),44, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C12),13, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C11  : S467C12 , virtual S467C5 , S468C7 , S467C9 {
  ::S468C14_nt s467c11f0;
  int s467c11f1;
  int s467c11f2;
  int s467c11f3:6;
  ::S468C14_nt s467c11f4;
  int s467c11f5;
  ~S467C11(); // tgen
  S467C11(); // tgen
};
//SIG(-1 S467C11) C1{ BC2{ BC3{ VBC4{ v1 FC5{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC5[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} VBC7{ v2 v3 Fc FL[10] FD FC5 Fp Fs Fp Fi} VBC8{ BC5 VBC4 BC6 VBC7 v6 Fi:2 FD[7] Fp FC4 Fp Fi Fp[2] FC6 FC5 FD[8]} BC6 Fp FC6 FC5 Fs} BC5 BC9{ vd v7 v8 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} FC11{ BC8 BC7 BC6 BC4 VBC5 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi}} VBC5 BC6 BC9 FC12{ m Fc} Fi Fi Fi:6 FC12 Fi}


S467C11 ::~S467C11(){ note_dtor("S467C11", this);} // tgen
S467C11 ::S467C11(){ note_ctor("S467C11", this);} // tgen

static void Test_S467C11()
{
  extern Class_Descriptor cd_S467C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2485,6532)];
    init_test(&cd_S467C11, buf);
    S467C11 *dp, &lv = *(dp=new (buf) S467C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(39744,26124), "sizeof(S467C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C11)");
    check_base_class_offset(lv, (S467C6*)(S467C13*)(S467C12*), ABISELECT(25456,16764), "S467C11");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(25456,16764), "S467C11");
    check_base_class_offset(lv, (S467C8*)(S467C13*)(S467C12*), ABISELECT(31696,20840), "S467C11");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(31696,20840), "S467C11");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(32144,21156), "S467C11");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(32440,21356), "S467C11");
    check_base_class_offset(lv, (S467C4*)(S467C13*)(S467C12*), ABISELECT(32144,21156), "S467C11");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*)(S467C12*), 0, "S467C11");
    check_base_class_offset(lv, (S467C13*)(S467C12*), 0, "S467C11");
    /*is_ambiguous_... S467C12::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C12*), ABISELECT(496,296), "S467C11");
    check_base_class_offset(lv, (S467C9*)(S467C12*), ABISELECT(800,496), "S467C11");
    check_base_class_offset(lv, (S467C12*), 0, "S467C11");
    /*is_ambiguous_... S467C11::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*), ABISELECT(39440,25924), "S467C11");
    /*is_ambiguous_... S467C11::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), ABISELECT(23904,15700), "S467C11");
    /*is_ambiguous_... S467C11::S467C9 */ AMB_check_base_class_offset(lv, (S467C9*), ABISELECT(23984,15744), "S467C11");
    check_field_offset(lv, s467c11f0, ABISELECT(25424,16744), "S467C11.s467c11f0");
    check_field_offset(lv, s467c11f1, ABISELECT(25428,16748), "S467C11.s467c11f1");
    check_field_offset(lv, s467c11f2, ABISELECT(25432,16752), "S467C11.s467c11f2");
    set_bf_and_test(lv, s467c11f3, ABISELECT(25436,16756), 0, 6, 1, "S467C11");
    set_bf_and_test(lv, s467c11f3, ABISELECT(25436,16756), 0, 6, hide_sll(1LL<<5), "S467C11");
    check_field_offset(lv, s467c11f4, ABISELECT(25437,16757), "S467C11.s467c11f4");
    check_field_offset(lv, s467c11f5, ABISELECT(25440,16760), "S467C11.s467c11f5");
    test_class_info(&lv, &cd_S467C11);
    dp->~S467C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C11(Test_S467C11, "S467C11", ABISELECT(39744,26124));

#else // __cplusplus

extern void _ZN7S467C11C1Ev();
extern void _ZN7S467C11D1Ev();
Name_Map name_map_S467C11[] = {
  NSPAIR(_ZN7S467C11C1Ev),
  NSPAIR(_ZN7S467C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C12;
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
static Base_Class bases_S467C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    ABISELECT(25456,16764), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C8,    ABISELECT(31696,20840), //bcp->offset
    32, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C5,    ABISELECT(32144,21156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(32440,21356), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(32144,21156), //bcp->offset
    38, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S467C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(496,296), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(800,496), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(39440,25924), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(23904,15700), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C9,    ABISELECT(23984,15744), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C11[];
extern void _ZN7S467C11D1Ev();
extern void _ZN7S467C11D0Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZThn800_N7S467C11D1Ev,_ZThn496_N7S467C11D1Ev)();
extern void ABISELECT(_ZThn800_N7S467C11D0Ev,_ZThn496_N7S467C11D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void ABISELECT(_ZThn23904_N7S467C11D1Ev,_ZThn15700_N7S467C11D1Ev)();
extern void ABISELECT(_ZThn23904_N7S467C11D0Ev,_ZThn15700_N7S467C11D0Ev)();
extern void ABISELECT(_ZThn23984_N7S467C11D1Ev,_ZThn15744_N7S467C11D1Ev)();
extern void ABISELECT(_ZThn23984_N7S467C11D0Ev,_ZThn15744_N7S467C11D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C11D1Ev,_ZTv0_n32_N7S467C11D1Ev)();
extern void ABISELECT(_ZThn32144_N7S467C11D1Ev,_ZThn21156_N7S467C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C11D0Ev,_ZTv0_n32_N7S467C11D0Ev)();
extern void ABISELECT(_ZThn32144_N7S467C11D0Ev,_ZThn21156_N7S467C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C11D1Ev,_ZTvn200_n32_N7S467C11D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C11D0Ev,_ZTvn200_n32_N7S467C11D0Ev)();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY vtc_S467C11[] = {
  ABISELECT(39440,25924),
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN7S467C11D1Ev,
  (VTBL_ENTRY)&_ZN7S467C11D0Ev,
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-800,-496),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S467C11D1Ev,_ZThn496_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn800_N7S467C11D0Ev,_ZThn496_N7S467C11D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  ABISELECT(-23904,-15700),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn23904_N7S467C11D1Ev,_ZThn15700_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn23904_N7S467C11D0Ev,_ZThn15700_N7S467C11D0Ev),
  ABISELECT(-23984,-15744),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn23984_N7S467C11D1Ev,_ZThn15744_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn23984_N7S467C11D0Ev,_ZThn15744_N7S467C11D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C11D1Ev,_ZTv0_n32_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C11D0Ev,_ZTv0_n32_N7S467C11D0Ev),
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C11D1Ev,_ZTvn200_n32_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C11D0Ev,_ZTvn200_n32_N7S467C11D0Ev),
  0,
  0,
  ABISELECT(-39440,-25924),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S467C11[];
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C12__7S467C11[] = {
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
};
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C137S467C12__7S467C11[] = {
  ABISELECT(32144,21156),
  ABISELECT(31696,20840),
  ABISELECT(25456,16764),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C137S467C12__7S467C11[] = {
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C137S467C12__7S467C11[] = {
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZThn32144_N7S467C13D1Ev,_ZThn21156_N7S467C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
extern void ABISELECT(_ZThn32144_N7S467C13D0Ev,_ZThn21156_N7S467C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C137S467C12__7S467C11[] = {
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C137S467C12__7S467C11[] = {
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C12__7S467C11[] = {
  0,
  ABISELECT(-25456,-16764),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C12__7S467C11[] = {
  0,
  0,
  ABISELECT(-31696,-20840),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZThn32144_N7S467C12D1Ev,_ZThn21156_N7S467C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
extern void ABISELECT(_ZThn32144_N7S467C12D0Ev,_ZThn21156_N7S467C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C12__7S467C11[] = {
  ABISELECT(-32144,-21156),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-32144,-21156),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C12__7S467C11[] = {
  ABISELECT(-32440,-21356),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C11[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C11[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C11[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C11[] = {
  {&(_ZTV7S467C11[6]),  6,61},
  {&(_tg__ZTV7S467C12__7S467C11[5]),  5,7},
  {&(_tg__ZTV7S467C137S467C12__7S467C11[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C137S467C12__7S467C11[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C137S467C12__7S467C11[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C137S467C12__7S467C11[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C137S467C12__7S467C11[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C12__7S467C11[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C12__7S467C11[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C12__7S467C11[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C12__7S467C11[2]),  2,4},
  {&(_ZTV7S467C11[31]),  31,61},
  {&(_ZTV7S467C11[36]),  36,61},
  {&(_ZTV7S467C11[46]),  46,61},
  {&(_ZTV7S467C11[53]),  53,61},
  {&(_ZTV7S467C11[59]),  59,61},
  {&(_tg__ZTV6S467C4__7S467C11[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C11[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C11[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S467C11[];
extern  VTBL_ENTRY _ZTV7S467C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C11[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C12D0Ev,_ZThn21156_N7S467C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C12D1Ev,_ZThn21156_N7S467C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C13D0Ev,_ZThn21156_N7S467C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C13D1Ev,_ZThn21156_N7S467C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C11D0Ev,_ZTv0_n32_N7S467C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C11D0Ev,_ZThn21156_N7S467C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C11D1Ev,_ZTv0_n32_N7S467C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32144_N7S467C11D1Ev,_ZThn21156_N7S467C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C11 = {  "S467C11", // class name
  bases_S467C11, 13,
  &(vtc_S467C11[0]), // expected_vtbl_contents
  &(vtt_S467C11[0]), // expected_vtt_contents
  ABISELECT(39744,26124), // object size
  NSPAIRA(_ZTI7S467C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S467C11),61, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C11),19, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C2  : S467C3 , S467C4 , virtual S467C9 {
  void *s467c2f0;
  long double s467c2f1;
  long double s467c2f2;
  ::S467C11 s467c2f3;
  virtual  ~S467C2(); // _ZN6S467C2D2Ev
  virtual void  v11(); // _ZN6S467C23v11Ev
  S467C2(); // tgen
};
//SIG(-1 S467C2) C1{ BC2{ BC3{ BC4{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC5{ v4 FC4[8] FC4[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC4[5] Fp[5] FC4[5]} BC6 VBC7{ v5 v6 Fc FL[10] FD FC4 Fp Fs Fp Fi} v7 Fi:2 FD[7] Fp FC5 Fp Fi Fp[2] FC6 FC4 FD[8]} BC7 BC6 BC5 VBC4 vd v8 v9 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi} BC3 VBC8{ vd v10 v11 Fi FC4 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} vd v1 Fp FD FD FC10{ BC11{ BC12{ VBC5 VBC7 VBC3 BC6 Fp FC6 FC4 Fs} BC4 BC8 FC2} VBC4 BC6 BC8 FC13{ m Fc} Fi Fi Fi:6 FC13 Fi}}


 S467C2 ::~S467C2(){ note_dtor("S467C2", this);}
void  S467C2 ::v11(){vfunc_called(this, "_ZN6S467C23v11Ev");}
S467C2 ::S467C2(){ note_ctor("S467C2", this);} // tgen

static void Test_S467C2()
{
  extern Class_Descriptor cd_S467C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4388,11532)];
    init_test(&cd_S467C2, buf);
    S467C2 *dp, &lv = *(dp=new (buf) S467C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(70192,46124), "sizeof(S467C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C2)");
    check_base_class_offset(lv, (S467C5*)(S467C4*)(S467C3*), 0, "S467C2");
    check_base_class_offset(lv, (S467C6*)(S467C4*)(S467C3*), ABISELECT(61760,40532), "S467C2");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(61760,40532), "S467C2");
    check_base_class_offset(lv, (S468C7*)(S467C4*)(S467C3*), ABISELECT(296,200), "S467C2");
    check_base_class_offset(lv, (S467C8*)(S467C4*)(S467C3*), ABISELECT(68000,44608), "S467C2");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(68000,44608), "S467C2");
    check_base_class_offset(lv, (S467C4*)(S467C3*), 0, "S467C2");
    /*is_ambiguous_... S467C3::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C3*), ABISELECT(7296,4768), "S467C2");
    /*is_ambiguous_... S467C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C3*), ABISELECT(7744,5084), "S467C2");
    /*is_ambiguous_... S467C3::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C3*), ABISELECT(7824,5128), "S467C2");
    /*is_ambiguous_... S467C3::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C3*), ABISELECT(68448,44924), "S467C2");
    check_base_class_offset(lv, (S467C3*), 0, "S467C2");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(14672,9612), "S467C2");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(14968,9812), "S467C2");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C4*), ABISELECT(14672,9612), "S467C2");
    check_base_class_offset(lv, (S467C9*), ABISELECT(68752,45124), "S467C2");
    check_field_offset(lv, s467c2f0, ABISELECT(21968,14380), "S467C2.s467c2f0");
    check_field_offset(lv, s467c2f1, ABISELECT(21984,14384), "S467C2.s467c2f1");
    check_field_offset(lv, s467c2f2, ABISELECT(22000,14396), "S467C2.s467c2f2");
    check_field_offset(lv, s467c2f3, ABISELECT(22016,14408), "S467C2.s467c2f3");
    test_class_info(&lv, &cd_S467C2);
    dp->~S467C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C2(Test_S467C2, "S467C2", ABISELECT(70192,46124));

#else // __cplusplus

extern void _ZN6S467C2C1Ev();
extern void _ZN6S467C2D2Ev();
Name_Map name_map_S467C2[] = {
  NSPAIR(_ZN6S467C2C1Ev),
  NSPAIR(_ZN6S467C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C3;
extern VTBL_ENTRY _ZTI6S467C3[];
extern  VTBL_ENTRY _ZTV6S467C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C3[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
static Base_Class bases_S467C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(61760,40532), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(68000,44608), //bcp->offset
    46, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(7296,4768), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(7824,5128), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(68448,44924), //bcp->offset
    52, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S467C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(14672,9612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(14968,9812), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(14672,9612), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C9,    ABISELECT(68752,45124), //bcp->offset
    58, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI6S467C2[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C2D1Ev();
extern void _ZN6S467C2D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
extern void _ZN6S467C23v11Ev();
extern void ABISELECT(_ZThn296_N6S467C2D1Ev,_ZThn200_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn296_N6S467C2D0Ev,_ZThn200_N6S467C2D0Ev)();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S467C2D1Ev,_ZThn5084_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn7744_N6S467C2D0Ev,_ZThn5084_N6S467C2D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S467C2D1Ev,_ZThn9612_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn14672_N6S467C2D0Ev,_ZThn9612_N6S467C2D0Ev)();
extern void ABISELECT(_ZThn14968_N6S467C2D1Ev,_ZThn9812_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn14968_N6S467C2D0Ev,_ZThn9812_N6S467C2D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn68752_N6S467C2D1Ev,_ZThn45124_N6S467C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev)();
extern void ABISELECT(_ZThn68752_N6S467C2D0Ev,_ZThn45124_N6S467C2D0Ev)() __attribute__((weak));
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
static  VTBL_ENTRY vtc_S467C2[] = {
  ABISELECT(68752,45124),
  ABISELECT(68448,44924),
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C2D1Ev,
  (VTBL_ENTRY)&_ZN6S467C2D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
  (VTBL_ENTRY)&_ZN6S467C23v11Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C2D1Ev,_ZThn200_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C2D0Ev,_ZThn200_N6S467C2D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C2D1Ev,_ZThn5084_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C2D0Ev,_ZThn5084_N6S467C2D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  ABISELECT(53328,34996),
  ABISELECT(47088,30920),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C2D1Ev,_ZThn9612_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C2D0Ev,_ZThn9612_N6S467C2D0Ev),
  ABISELECT(-14968,-9812),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S467C2D1Ev,_ZThn9812_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S467C2D0Ev,_ZThn9812_N6S467C2D0Ev),
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  0,
  0,
  ABISELECT(-68448,-44924),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  0,
  0,
  ABISELECT(-68752,-45124),
  ABISELECT(-68752,-45124),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
};
extern VTBL_ENTRY _ZTV6S467C2[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C3D1Ev();
extern void _ZN6S467C3D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
static  VTBL_ENTRY _tg__ZTV6S467C3__6S467C2[] = {
  ABISELECT(68448,44924),
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C3D1Ev,
  (VTBL_ENTRY)&_ZN6S467C3D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C46S467C3__6S467C2[] = {
  ABISELECT(68000,44608),
  ABISELECT(61760,40532),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C46S467C3__6S467C2[] = {
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C46S467C3__6S467C2[] = {
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C3__6S467C2[] = {
  0,
  ABISELECT(-61760,-40532),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C3__6S467C2[] = {
  0,
  0,
  ABISELECT(-68000,-44608),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__A1__6S467C3__6S467C2[] = {
  0,
  0,
  ABISELECT(-68448,-44924),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__A1__6S467C2[] = {
  ABISELECT(53328,34996),
  ABISELECT(47088,30920),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__A1__6S467C2[] = {
  0,
  ABISELECT(-47088,-30920),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__A1__6S467C2[] = {
  0,
  0,
  ABISELECT(-53328,-34996),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C2[] = {
  {&(_ZTV6S467C2[6]),  6,67},
  {&(_tg__ZTV6S467C3__6S467C2[5]),  5,12},
  {&(_tg__ZTV6S467C46S467C3__6S467C2[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C46S467C3__6S467C2[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C46S467C3__6S467C2[4]),  4,6},
  {&(_tg__ZTV6S467C6__6S467C3__6S467C2[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C3__6S467C2[4]),  4,6},
  {&(_tg__ZTV6S467C5__A1__6S467C3__6S467C2[4]),  4,6},
  {&(_tg__ZTV6S467C4__A1__6S467C2[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__A1__6S467C2[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__A1__6S467C2[4]),  4,6},
  {&(_ZTV6S467C2[45]),  45,67},
  {&(_ZTV6S467C2[50]),  50,67},
  {&(_ZTV6S467C2[56]),  56,67},
  {&(_ZTV6S467C2[33]),  33,67},
  {&(_ZTV6S467C2[63]),  63,67},
};
extern VTBL_ENTRY _ZTI6S467C2[];
extern  VTBL_ENTRY _ZTV6S467C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C2[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn68752_N6S467C2D0Ev,_ZThn45124_N6S467C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn68752_N6S467C2D1Ev,_ZThn45124_N6S467C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C2 = {  "S467C2", // class name
  bases_S467C2, 14,
  &(vtc_S467C2[0]), // expected_vtbl_contents
  &(vtt_S467C2[0]), // expected_vtt_contents
  ABISELECT(70192,46124), // object size
  NSPAIRA(_ZTI6S467C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S467C2),67, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S467C2),16, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C15  : S468C7 , S467C8 , S467C4 {
  void *s467c15f0;
  ::S467C4 s467c15f1;
  char s467c15f2[7];
  ::S467C9 s467c15f3;
  int s467c15f4;
  char s467c15f5[4];
  void *s467c15f6;
  ::S467C4 s467c15f7;
  int s467c15f8;
  int s467c15f9[7];
  int s467c15f10;
  ~S467C15(); // tgen
  S467C15(); // tgen
};
//SIG(-1 S467C15) C1{ BC2{ vd m Fp FL Fp[7]} BC3{ v1 v2 Fc FL[10] FD FC4{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi} BC5{ BC4 VBC6{ v5 FC4[8] FC4[2] Fp Fi FC2 FC4[5] Fp[5] FC4[5]} BC2 VBC3 v6 Fi:2 FD[7] Fp FC6 Fp Fi Fp[2] FC2 FC4 FD[8]} Fp FC5 Fc[7] FC7{ vd v7 v8 Fi FC4 Fi[2] FU8{ m FL FD[10] FD Fs:0} FD Fi Fi FC3 FL Fi FC3} Fi Fc[4] Fp FC5 Fi Fi[7] Fi}


S467C15 ::~S467C15(){ note_dtor("S467C15", this);} // tgen
S467C15 ::S467C15(){ note_ctor("S467C15", this);} // tgen

static void Test_S467C15()
{
  extern Class_Descriptor cd_S467C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2752,7226)];
    init_test(&cd_S467C15, buf);
    S467C15 *dp, &lv = *(dp=new (buf) S467C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(44016,28900), "sizeof(S467C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C15)");
    /*is_ambiguous_... S467C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*), 0, "S467C15");
    /*is_ambiguous_... S467C15::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*), ABISELECT(80,44), "S467C15");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(528,360), "S467C15");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(37328,24508), "S467C15");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(824,560), "S467C15");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(43568,28584), "S467C15");
    check_base_class_offset(lv, (S467C4*), ABISELECT(528,360), "S467C15");
    check_field_offset(lv, s467c15f0, ABISELECT(7824,5128), "S467C15.s467c15f0");
    check_field_offset(lv, s467c15f1, ABISELECT(7840,5132), "S467C15.s467c15f1");
    check_field_offset(lv, s467c15f2, ABISELECT(21824,14292), "S467C15.s467c15f2");
    check_field_offset(lv, s467c15f3, ABISELECT(21840,14300), "S467C15.s467c15f3");
    check_field_offset(lv, s467c15f4, ABISELECT(23280,15300), "S467C15.s467c15f4");
    check_field_offset(lv, s467c15f5, ABISELECT(23284,15304), "S467C15.s467c15f5");
    check_field_offset(lv, s467c15f6, ABISELECT(23288,15308), "S467C15.s467c15f6");
    check_field_offset(lv, s467c15f7, ABISELECT(23296,15312), "S467C15.s467c15f7");
    check_field_offset(lv, s467c15f8, ABISELECT(37280,24472), "S467C15.s467c15f8");
    check_field_offset(lv, s467c15f9, ABISELECT(37284,24476), "S467C15.s467c15f9");
    check_field_offset(lv, s467c15f10, ABISELECT(37312,24504), "S467C15.s467c15f10");
    test_class_info(&lv, &cd_S467C15);
    dp->~S467C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C15(Test_S467C15, "S467C15", ABISELECT(44016,28900));

#else // __cplusplus

extern void _ZN7S467C15C1Ev();
extern void _ZN7S467C15D1Ev();
Name_Map name_map_S467C15[] = {
  NSPAIR(_ZN7S467C15C1Ev),
  NSPAIR(_ZN7S467C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
static Base_Class bases_S467C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C8,    ABISELECT(80,44), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(528,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(37328,24508), //bcp->offset
    23, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(824,560), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(43568,28584), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S467C4,    ABISELECT(528,360), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C15[];
extern void _ZN7S467C15D1Ev();
extern void _ZN7S467C15D0Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev)();
extern void ABISELECT(_ZThn824_N7S467C15D1Ev,_ZThn560_N7S467C15D1Ev)();
extern void ABISELECT(_ZThn824_N7S467C15D0Ev,_ZThn560_N7S467C15D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY vtc_S467C15[] = {
  ABISELECT(43568,28584),
  ABISELECT(37328,24508),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN7S467C15D1Ev,
  (VTBL_ENTRY)&_ZN7S467C15D0Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(43040,28224),
  ABISELECT(36800,24148),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev),
  ABISELECT(-824,-560),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S467C15D1Ev,_ZThn560_N7S467C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S467C15D0Ev,_ZThn560_N7S467C15D0Ev),
  0,
  ABISELECT(-37328,-24508),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-43568,-28584),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern VTBL_ENTRY _ZTV7S467C15[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C15[] = {
  ABISELECT(43040,28224),
  ABISELECT(36800,24148),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C15[] = {
  0,
  ABISELECT(-36800,-24148),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C15[] = {
  0,
  0,
  ABISELECT(-43040,-28224),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C15[] = {
  {&(_ZTV7S467C15[4]),  4,33},
  {&(_tg__ZTV6S467C4__7S467C15[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C15[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C15[4]),  4,6},
  {&(_ZTV7S467C15[14]),  14,33},
  {&(_ZTV7S467C15[26]),  26,33},
  {&(_ZTV7S467C15[31]),  31,33},
};
extern VTBL_ENTRY _ZTI7S467C15[];
extern  VTBL_ENTRY _ZTV7S467C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C15[];
Class_Descriptor cd_S467C15 = {  "S467C15", // class name
  bases_S467C15, 7,
  &(vtc_S467C15[0]), // expected_vtbl_contents
  &(vtt_S467C15[0]), // expected_vtt_contents
  ABISELECT(44016,28900), // object size
  NSPAIRA(_ZTI7S467C15),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S467C15),33, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C15),7, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C19  : S467C6 , S468C7 , virtual S467C5 {
  int s467c19f0;
  short s467c19f1;
  unsigned short s467c19f2:1;
  void *s467c19f3;
  long s467c19f4;
  ::S467C6 s467c19f5;
  int s467c19f6[2];
  char s467c19f7[3];
  int s467c19f8;
  virtual  ~S467C19(); // _ZN7S467C19D2Ev
  virtual void  v12(); // _ZN7S467C193v12Ev
  S467C19(); // tgen
};
//SIG(-1 S467C19) C1{ BC2{ v2 FC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC4 VBC3 vd v1 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi}


 S467C19 ::~S467C19(){ note_dtor("S467C19", this);}
void  S467C19 ::v12(){vfunc_called(this, "_ZN7S467C193v12Ev");}
S467C19 ::S467C19(){ note_ctor("S467C19", this);} // tgen

static void Test_S467C19()
{
  extern Class_Descriptor cd_S467C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(808,2108)];
    init_test(&cd_S467C19, buf);
    S467C19 *dp, &lv = *(dp=new (buf) S467C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12912,8428), "sizeof(S467C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C19)");
    check_base_class_offset(lv, (S467C6*), 0, "S467C19");
    check_base_class_offset(lv, (S468C7*), ABISELECT(6240,4076), "S467C19");
    check_base_class_offset(lv, (S467C5*), ABISELECT(12608,8228), "S467C19");
    check_field_offset(lv, s467c19f0, ABISELECT(6320,4120), "S467C19.s467c19f0");
    check_field_offset(lv, s467c19f1, ABISELECT(6324,4124), "S467C19.s467c19f1");
    set_bf_and_test(lv, s467c19f2, ABISELECT(6326,4126), 0, 1, 1, "S467C19");
    check_field_offset(lv, s467c19f3, ABISELECT(6328,4128), "S467C19.s467c19f3");
    check_field_offset(lv, s467c19f4, ABISELECT(6336,4132), "S467C19.s467c19f4");
    check_field_offset(lv, s467c19f5, ABISELECT(6352,4136), "S467C19.s467c19f5");
    check_field_offset(lv, s467c19f6, ABISELECT(12592,8212), "S467C19.s467c19f6");
    check_field_offset(lv, s467c19f7, ABISELECT(12600,8220), "S467C19.s467c19f7");
    check_field_offset(lv, s467c19f8, ABISELECT(12604,8224), "S467C19.s467c19f8");
    test_class_info(&lv, &cd_S467C19);
    dp->~S467C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C19(Test_S467C19, "S467C19", ABISELECT(12912,8428));

#else // __cplusplus

extern void _ZN7S467C19C1Ev();
extern void _ZN7S467C19D2Ev();
Name_Map name_map_S467C19[] = {
  NSPAIR(_ZN7S467C19C1Ev),
  NSPAIR(_ZN7S467C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
static Base_Class bases_S467C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(6240,4076), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(12608,8228), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S467C19[];
extern void _ZN6S467C62v3Ev();
extern void _ZN7S467C19D1Ev();
extern void _ZN7S467C19D0Ev();
extern void _ZN7S467C193v12Ev();
extern void ABISELECT(_ZThn6240_N7S467C19D1Ev,_ZThn4076_N7S467C19D1Ev)();
extern void ABISELECT(_ZThn6240_N7S467C19D0Ev,_ZThn4076_N7S467C19D0Ev)();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY vtc_S467C19[] = {
  ABISELECT(12608,8228),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&_ZN7S467C19D1Ev,
  (VTBL_ENTRY)&_ZN7S467C19D0Ev,
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C19D1Ev,_ZThn4076_N7S467C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C19D0Ev,_ZThn4076_N7S467C19D0Ev),
  0,
  0,
  ABISELECT(-12608,-8228),
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S467C19[];
static  VTT_ENTRY vtt_S467C19[] = {
  {&(_ZTV7S467C19[3]),  3,17},
  {&(_ZTV7S467C19[15]),  15,17},
};
extern VTBL_ENTRY _ZTI7S467C19[];
extern  VTBL_ENTRY _ZTV7S467C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C19[];
Class_Descriptor cd_S467C19 = {  "S467C19", // class name
  bases_S467C19, 3,
  &(vtc_S467C19[0]), // expected_vtbl_contents
  &(vtt_S467C19[0]), // expected_vtt_contents
  ABISELECT(12912,8428), // object size
  NSPAIRA(_ZTI7S467C19),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S467C19),17, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C19),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C18  : S467C6 , virtual S467C5 , virtual S467C19 , S467C12 {
  void *s467c18f0;
  virtual  ~S467C18(); // _ZN7S467C18D2Ev
  S467C18(); // tgen
};
//SIG(-1 S467C18) C1{ BC2{ v1 FC3{ v2 v3 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} VBC3 VBC5{ BC2 BC4 VBC3 vd v4 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi} BC6{ BC7{ VBC2 VBC8{ v5 v6 Fc FL[10] FD FC3 Fp Fs Fp Fi} VBC9{ BC3 VBC2 BC4 VBC8 v7 Fi:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} BC4 Fp FC4 FC3 Fs} BC3 BC10{ vd v8 v9 Fi FC3 Fi[2] FU11{ m FL FD[10] FD Fs:0} FD Fi Fi FC8 FL Fi FC8} FC12{ BC9 BC8 BC4 BC2 VBC3 vd v10 v11 FC4 Fi Fp[2] FL[2] Fi[2] Fp Fi FC8 Fi}} vd Fp}


 S467C18 ::~S467C18(){ note_dtor("S467C18", this);}
S467C18 ::S467C18(){ note_ctor("S467C18", this);} // tgen

static void Test_S467C18()
{
  extern Class_Descriptor cd_S467C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3567,9343)];
    init_test(&cd_S467C18, buf);
    S467C18 *dp, &lv = *(dp=new (buf) S467C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(57056,37368), "sizeof(S467C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C18)");
    /*is_ambiguous_... S467C18::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*), 0, "S467C18");
    /*is_ambiguous_... S467C18::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*), ABISELECT(30160,19780), "S467C18");
    check_base_class_offset(lv, (S467C5*)(S467C19*), ABISELECT(30160,19780), "S467C18");
    check_base_class_offset(lv, (S467C6*)(S467C19*), ABISELECT(30464,19980), "S467C18");
    check_base_class_offset(lv, (S468C7*)(S467C19*), ABISELECT(36704,24056), "S467C18");
    check_base_class_offset(lv, (S467C19*), ABISELECT(30464,19980), "S467C18");
    check_base_class_offset(lv, (S467C6*)(S467C13*)(S467C12*), ABISELECT(43072,28208), "S467C18");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(43072,28208), "S467C18");
    check_base_class_offset(lv, (S467C8*)(S467C13*)(S467C12*), ABISELECT(49312,32284), "S467C18");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(49312,32284), "S467C18");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(49760,32600), "S467C18");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(50056,32800), "S467C18");
    check_base_class_offset(lv, (S467C4*)(S467C13*)(S467C12*), ABISELECT(49760,32600), "S467C18");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*)(S467C12*), ABISELECT(6240,4076), "S467C18");
    check_base_class_offset(lv, (S467C13*)(S467C12*), ABISELECT(6240,4076), "S467C18");
    /*is_ambiguous_... S467C12::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C12*), ABISELECT(6736,4372), "S467C18");
    check_base_class_offset(lv, (S467C9*)(S467C12*), ABISELECT(7040,4572), "S467C18");
    check_base_class_offset(lv, (S467C12*), ABISELECT(6240,4076), "S467C18");
    check_field_offset(lv, s467c18f0, ABISELECT(30144,19776), "S467C18.s467c18f0");
    test_class_info(&lv, &cd_S467C18);
    dp->~S467C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C18(Test_S467C18, "S467C18", ABISELECT(57056,37368));

#else // __cplusplus

extern void _ZN7S467C18C1Ev();
extern void _ZN7S467C18D2Ev();
Name_Map name_map_S467C18[] = {
  NSPAIR(_ZN7S467C18C1Ev),
  NSPAIR(_ZN7S467C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C19;
extern VTBL_ENTRY _ZTI7S467C19[];
extern  VTBL_ENTRY _ZTV7S467C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C19[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C12;
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
static Base_Class bases_S467C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C5,    ABISELECT(30160,19780), //bcp->offset
    27, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C6,    ABISELECT(30464,19980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(36704,24056), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C19,    ABISELECT(30464,19980), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C6,    ABISELECT(43072,28208), //bcp->offset
    47, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S467C8,    ABISELECT(49312,32284), //bcp->offset
    51, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S467C5,    ABISELECT(49760,32600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(50056,32800), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(49760,32600), //bcp->offset
    57, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(6240,4076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S467C13,    ABISELECT(6240,4076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(6736,4372), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(7040,4572), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S467C12,    ABISELECT(6240,4076), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C18[];
extern void _ZN6S467C62v3Ev();
extern void _ZN7S467C18D1Ev();
extern void _ZN7S467C18D0Ev();
extern void ABISELECT(_ZThn6240_N7S467C18D1Ev,_ZThn4076_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn6240_N7S467C18D0Ev,_ZThn4076_N7S467C18D0Ev)();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZThn7040_N7S467C18D1Ev,_ZThn4572_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn7040_N7S467C18D0Ev,_ZThn4572_N7S467C18D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn30464_N7S467C18D1Ev,_ZThn19980_N7S467C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev)();
extern void ABISELECT(_ZThn30464_N7S467C18D0Ev,_ZThn19980_N7S467C18D0Ev)() __attribute__((weak));
extern void _ZN7S467C193v12Ev();
extern void ABISELECT(_ZTvn6240_n40_N7S467C18D1Ev,_ZTvn4076_n20_N7S467C18D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S467C18D0Ev,_ZTvn4076_n20_N7S467C18D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn49760_N7S467C18D1Ev,_ZThn32600_N7S467C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev)();
extern void ABISELECT(_ZThn49760_N7S467C18D0Ev,_ZThn32600_N7S467C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C18D1Ev,_ZTvn200_n32_N7S467C18D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C18D0Ev,_ZTvn200_n32_N7S467C18D0Ev)();
static  VTBL_ENTRY vtc_S467C18[] = {
  ABISELECT(49760,32600),
  ABISELECT(49312,32284),
  ABISELECT(43072,28208),
  ABISELECT(30464,19980),
  ABISELECT(30160,19780),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&_ZN7S467C18D1Ev,
  (VTBL_ENTRY)&_ZN7S467C18D0Ev,
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C18D1Ev,_ZThn4076_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C18D0Ev,_ZThn4076_N7S467C18D0Ev),
  ABISELECT(-6736,-4372),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-7040,-4572),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7040_N7S467C18D1Ev,_ZThn4572_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7040_N7S467C18D0Ev,_ZThn4572_N7S467C18D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  0,
  0,
  ABISELECT(-30160,-19780),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  0,
  ABISELECT(-30464,-19980),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-30464,-19980),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev),
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
  ABISELECT(-36704,-24056),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C18D1Ev,_ZTvn4076_n20_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C18D0Ev,_ZTvn4076_n20_N7S467C18D0Ev),
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-49312,-32284),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-49760,-32600),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-49760,-32600),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev),
  ABISELECT(-50056,-32800),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C18D1Ev,_ZTvn200_n32_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C18D0Ev,_ZTvn200_n32_N7S467C18D0Ev),
};
extern VTBL_ENTRY _ZTV7S467C18[];
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C12__7S467C18[] = {
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
};
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C137S467C12__7S467C18[] = {
  ABISELECT(43520,28524),
  ABISELECT(43072,28208),
  ABISELECT(36832,24132),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C137S467C12__7S467C18[] = {
  0,
  ABISELECT(-36832,-24132),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C137S467C12__7S467C18[] = {
  0,
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZThn43520_N7S467C13D1Ev,_ZThn28524_N7S467C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
extern void ABISELECT(_ZThn43520_N7S467C13D0Ev,_ZThn28524_N7S467C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C137S467C12__7S467C18[] = {
  ABISELECT(-43520,-28524),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-43520,-28524),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C137S467C12__7S467C18[] = {
  ABISELECT(-43816,-28724),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C12__7S467C18[] = {
  0,
  ABISELECT(-36832,-24132),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C12__7S467C18[] = {
  0,
  0,
  ABISELECT(-43072,-28208),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZThn43520_N7S467C12D1Ev,_ZThn28524_N7S467C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
extern void ABISELECT(_ZThn43520_N7S467C12D0Ev,_ZThn28524_N7S467C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C12__7S467C18[] = {
  ABISELECT(-43520,-28524),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  ABISELECT(-43520,-28524),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C12__7S467C18[] = {
  ABISELECT(-43816,-28724),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
extern void _ZN6S467C62v3Ev();
extern void _ZN7S467C19D1Ev();
extern void _ZN7S467C19D0Ev();
extern void _ZN7S467C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S467C19__7S467C18[] = {
  ABISELECT(-304,-200),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&_ZN7S467C19D1Ev,
  (VTBL_ENTRY)&_ZN7S467C19D0Ev,
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__7S467C19__7S467C18[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C18[] = {
  ABISELECT(-448,-316),
  ABISELECT(-6688,-4392),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C18[] = {
  0,
  ABISELECT(6688,4392),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C18[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C18[] = {
  {&(_ZTV7S467C18[7]),  7,74},
  {&(_tg__ZTV7S467C12__7S467C18[5]),  5,7},
  {&(_tg__ZTV7S467C137S467C12__7S467C18[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C137S467C12__7S467C18[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C137S467C12__7S467C18[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C137S467C12__7S467C18[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C137S467C12__7S467C18[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C12__7S467C18[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C12__7S467C18[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C12__7S467C18[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C12__7S467C18[2]),  2,4},
  {&(_ZTV7S467C18[31]),  31,74},
  {&(_ZTV7S467C18[39]),  39,74},
  {&(_ZTV7S467C18[45]),  45,74},
  {&(_ZTV7S467C18[15]),  15,74},
  {&(_ZTV7S467C18[50]),  50,74},
  {&(_ZTV7S467C18[55]),  55,74},
  {&(_ZTV7S467C18[65]),  65,74},
  {&(_ZTV7S467C18[72]),  72,74},
  {&(_tg__ZTV7S467C19__7S467C18[3]),  3,7},
  {&(_tg__ZTV6S467C5__7S467C19__7S467C18[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C18[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C18[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C18[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S467C18[];
extern  VTBL_ENTRY _ZTV7S467C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C18[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S467C12D0Ev,_ZThn28524_N7S467C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S467C12D1Ev,_ZThn28524_N7S467C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S467C13D0Ev,_ZThn28524_N7S467C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn43520_N7S467C13D1Ev,_ZThn28524_N7S467C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn49760_N7S467C18D0Ev,_ZThn32600_N7S467C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn49760_N7S467C18D1Ev,_ZThn32600_N7S467C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30464_N7S467C18D0Ev,_ZThn19980_N7S467C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn30464_N7S467C18D1Ev,_ZThn19980_N7S467C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C18 = {  "S467C18", // class name
  bases_S467C18, 15,
  &(vtc_S467C18[0]), // expected_vtbl_contents
  &(vtt_S467C18[0]), // expected_vtt_contents
  ABISELECT(57056,37368), // object size
  NSPAIRA(_ZTI7S467C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S467C18),74, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C18),24, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C17  : virtual S467C6 , S467C15 , S467C18 {
  void *s467c17f0;
  int s467c17f1[4];
  ::S468C20_nt s467c17f2;
  ::S467C12 s467c17f3;
  ::S468C14_nt s467c17f4;
  int s467c17f5;
  int s467c17f6:24;
  ::S468C14_nt s467c17f7;
  int s467c17f8;
  ::S468C20_nt s467c17f9;
  ~S467C17(); // tgen
  S467C17(); // tgen
};
//SIG(-1 S467C17) C1{ VBC2{ v1 FC3{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC3[2] Fp Fi FC4{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC5{ BC4 BC6{ v2 v3 Fc FL[10] FD FC3 Fp Fs Fp Fi} BC7{ BC3 VBC2 BC4 VBC6 v6 Fi:2 FD[7] Fp FC2 Fp Fi Fp[2] FC4 FC3 FD[8]} Fp FC7 Fc[7] FC8{ vd v8 v9 Fi FC3 Fi[2] FU9{ m FL FD[10] FD Fs:0} FD Fi Fi FC6 FL Fi FC6} Fi Fc[4] Fp FC7 Fi Fi[7] Fi} BC10{ BC2 VBC3 VBC11{ BC2 BC4 VBC3 vd v7 Fi Fs Fs:1 Fp Fl FC2 Fi[2] Fc[3] Fi} BC12{ BC13{ VBC2 VBC6 VBC7 BC4 Fp FC4 FC3 Fs} BC3 BC8 FC14{ BC7 BC6 BC4 BC2 VBC3 vd v10 v11 FC4 Fi Fp[2] FL[2] Fi[2] Fp Fi FC6 Fi}} vd Fp} Fp Fi[4] FC15{} FC12 FC16{ m Fc} Fi Fi:24 FC16 Fi FC15}


S467C17 ::~S467C17(){ note_dtor("S467C17", this);} // tgen
S467C17 ::S467C17(){ note_ctor("S467C17", this);} // tgen

static void Test_S467C17()
{
  extern Class_Descriptor cd_S467C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(8272,21696)];
    init_test(&cd_S467C17, buf);
    S467C17 *dp, &lv = *(dp=new (buf) S467C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(132336,86780), "sizeof(S467C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C17)");
    /*is_ambiguous_... S467C17::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*), ABISELECT(105440,69192), "S467C17");
    check_base_class_offset(lv, (S467C6*)(S467C4*)(S467C15*), ABISELECT(105440,69192), "S467C17");
    check_base_class_offset(lv, (S467C6*)(S467C13*)(S467C12*)(S467C18*), ABISELECT(105440,69192), "S467C17");
    /*is_ambiguous_... S467C17::S467C4 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(105440,69192), "S467C17");
    /*is_ambiguous_... S467C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C15*), 0, "S467C17");
    /*is_ambiguous_... S467C15::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C15*), ABISELECT(80,44), "S467C17");
    check_base_class_offset(lv, (S467C5*)(S467C4*)(S467C15*), ABISELECT(528,360), "S467C17");
    check_base_class_offset(lv, (S468C7*)(S467C4*)(S467C15*), ABISELECT(824,560), "S467C17");
    check_base_class_offset(lv, (S467C8*)(S467C4*)(S467C15*), ABISELECT(111680,73268), "S467C17");
    check_base_class_offset(lv, (S467C8*)(S467C13*)(S467C12*)(S467C18*), ABISELECT(111680,73268), "S467C17");
    /*is_ambiguous_... S467C17::S467C4 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(111680,73268), "S467C17");
    check_base_class_offset(lv, (S467C4*)(S467C15*), ABISELECT(528,360), "S467C17");
    check_base_class_offset(lv, (S467C15*), 0, "S467C17");
    /*is_ambiguous_... S467C18::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C18*), ABISELECT(37328,24508), "S467C17");
    /*is_ambiguous_... S467C18::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C18*), ABISELECT(112128,73584), "S467C17");
    check_base_class_offset(lv, (S467C5*)(S467C19*), ABISELECT(112128,73584), "S467C17");
    check_base_class_offset(lv, (S467C6*)(S467C19*), ABISELECT(112432,73784), "S467C17");
    check_base_class_offset(lv, (S468C7*)(S467C19*), ABISELECT(118672,77860), "S467C17");
    check_base_class_offset(lv, (S467C19*)(S467C18*), ABISELECT(112432,73784), "S467C17");
    /*is_ambiguous_... S467C17::S467C4 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(125040,82012), "S467C17");
    /*is_ambiguous_... S467C17::S467C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(125336,82212), "S467C17");
    check_base_class_offset(lv, (S467C4*)(S467C13*)(S467C12*)(S467C18*), ABISELECT(125040,82012), "S467C17");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*)(S467C12*)(S467C18*), ABISELECT(43568,28584), "S467C17");
    check_base_class_offset(lv, (S467C13*)(S467C12*)(S467C18*), ABISELECT(43568,28584), "S467C17");
    /*is_ambiguous_... S467C12::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C12*)(S467C18*), ABISELECT(44064,28880), "S467C17");
    check_base_class_offset(lv, (S467C9*)(S467C12*)(S467C18*), ABISELECT(44368,29080), "S467C17");
    check_base_class_offset(lv, (S467C12*)(S467C18*), ABISELECT(43568,28584), "S467C17");
    check_base_class_offset(lv, (S467C18*), ABISELECT(37328,24508), "S467C17");
    check_field_offset(lv, s467c17f0, ABISELECT(67480,44288), "S467C17.s467c17f0");
    check_field_offset(lv, s467c17f1, ABISELECT(67488,44292), "S467C17.s467c17f1");
    check_field_offset(lv, s467c17f2, ABISELECT(67504,44308), "S467C17.s467c17f2");
    check_field_offset(lv, s467c17f3, ABISELECT(67520,44312), "S467C17.s467c17f3");
    check_field_offset(lv, s467c17f4, ABISELECT(105408,69172), "S467C17.s467c17f4");
    check_field_offset(lv, s467c17f5, ABISELECT(105412,69176), "S467C17.s467c17f5");
    set_bf_and_test(lv, s467c17f6, ABISELECT(105416,69180), 0, 24, 1, "S467C17");
    set_bf_and_test(lv, s467c17f6, ABISELECT(105416,69180), 0, 24, hide_sll(1LL<<23), "S467C17");
    check_field_offset(lv, s467c17f7, ABISELECT(105419,69183), "S467C17.s467c17f7");
    check_field_offset(lv, s467c17f8, ABISELECT(105420,69184), "S467C17.s467c17f8");
    check_field_offset(lv, s467c17f9, ABISELECT(105424,69188), "S467C17.s467c17f9");
    test_class_info(&lv, &cd_S467C17);
    dp->~S467C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C17(Test_S467C17, "S467C17", ABISELECT(132336,86780));

#else // __cplusplus

extern void _ZN7S467C17C1Ev();
extern void _ZN7S467C17D1Ev();
Name_Map name_map_S467C17[] = {
  NSPAIR(_ZN7S467C17C1Ev),
  NSPAIR(_ZN7S467C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C15;
extern VTBL_ENTRY _ZTI7S467C15[];
extern  VTBL_ENTRY _ZTV7S467C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C15[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C19;
extern VTBL_ENTRY _ZTI7S467C19[];
extern  VTBL_ENTRY _ZTV7S467C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C19[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C12;
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
extern Class_Descriptor cd_S467C18;
extern VTBL_ENTRY _ZTI7S467C18[];
extern  VTBL_ENTRY _ZTV7S467C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C18[];
static Base_Class bases_S467C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C6,    ABISELECT(105440,69192), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(80,44), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(528,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(824,560), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(111680,73268), //bcp->offset
    57, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S467C4,    ABISELECT(528,360), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S467C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S467C6,    ABISELECT(37328,24508), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(112128,73584), //bcp->offset
    63, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S467C6,    ABISELECT(112432,73784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(118672,77860), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S467C19,    ABISELECT(112432,73784), //bcp->offset
    69, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S467C5,    ABISELECT(125040,82012), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(125336,82212), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(125040,82012), //bcp->offset
    83, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(43568,28584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S467C13,    ABISELECT(43568,28584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(44064,28880), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(44368,29080), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C12,    ABISELECT(43568,28584), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S467C18,    ABISELECT(37328,24508), //bcp->offset
    26, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S467C17[];
extern void _ZN7S467C17D1Ev();
extern void _ZN7S467C17D0Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn528_N7S467C17D1Ev,_ZThn360_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn528_N7S467C17D0Ev,_ZThn360_N7S467C17D0Ev)();
extern void ABISELECT(_ZThn824_N7S467C17D1Ev,_ZThn560_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn824_N7S467C17D0Ev,_ZThn560_N7S467C17D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void ABISELECT(_ZThn37328_N7S467C17D1Ev,_ZThn24508_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn37328_N7S467C17D0Ev,_ZThn24508_N7S467C17D0Ev)();
extern void ABISELECT(_ZThn43568_N7S467C17D1Ev,_ZThn28584_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn43568_N7S467C17D0Ev,_ZThn28584_N7S467C17D0Ev)();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZThn44368_N7S467C17D1Ev,_ZThn29080_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn44368_N7S467C17D0Ev,_ZThn29080_N7S467C17D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S467C17D1Ev,_ZTv0_n20_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn112432_N7S467C17D1Ev,_ZThn73784_N7S467C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S467C17D0Ev,_ZTv0_n20_N7S467C17D0Ev)();
extern void ABISELECT(_ZThn112432_N7S467C17D0Ev,_ZThn73784_N7S467C17D0Ev)() __attribute__((weak));
extern void _ZN7S467C193v12Ev();
extern void ABISELECT(_ZTvn6240_n40_N7S467C17D1Ev,_ZTvn4076_n20_N7S467C17D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S467C17D0Ev,_ZTvn4076_n20_N7S467C17D0Ev)();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C17D1Ev,_ZTv0_n32_N7S467C17D1Ev)();
extern void ABISELECT(_ZThn125040_N7S467C17D1Ev,_ZThn82012_N7S467C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C17D0Ev,_ZTv0_n32_N7S467C17D0Ev)();
extern void ABISELECT(_ZThn125040_N7S467C17D0Ev,_ZThn82012_N7S467C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C17D1Ev,_ZTvn200_n32_N7S467C17D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C17D0Ev,_ZTvn200_n32_N7S467C17D0Ev)();
static  VTBL_ENTRY vtc_S467C17[] = {
  ABISELECT(125040,82012),
  ABISELECT(112432,73784),
  ABISELECT(112128,73584),
  ABISELECT(111680,73268),
  ABISELECT(105440,69192),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN7S467C17D1Ev,
  (VTBL_ENTRY)&_ZN7S467C17D0Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C17D1Ev,_ZThn360_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C17D0Ev,_ZThn360_N7S467C17D0Ev),
  ABISELECT(-824,-560),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S467C17D1Ev,_ZThn560_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn824_N7S467C17D0Ev,_ZThn560_N7S467C17D0Ev),
  ABISELECT(87712,57504),
  ABISELECT(74352,48760),
  ABISELECT(68112,44684),
  ABISELECT(75104,49276),
  ABISELECT(74800,49076),
  ABISELECT(-37328,-24508),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn37328_N7S467C17D1Ev,_ZThn24508_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn37328_N7S467C17D0Ev,_ZThn24508_N7S467C17D0Ev),
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  ABISELECT(-43568,-28584),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn43568_N7S467C17D1Ev,_ZThn28584_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn43568_N7S467C17D0Ev,_ZThn28584_N7S467C17D0Ev),
  ABISELECT(-44064,-28880),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-44368,-29080),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn44368_N7S467C17D1Ev,_ZThn29080_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn44368_N7S467C17D0Ev,_ZThn29080_N7S467C17D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  0,
  ABISELECT(-105440,-69192),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-111680,-73268),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  0,
  0,
  ABISELECT(-112128,-73584),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  0,
  ABISELECT(-112432,-73784),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-112432,-73784),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C17D1Ev,_ZTv0_n20_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C17D0Ev,_ZTv0_n20_N7S467C17D0Ev),
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
  ABISELECT(-118672,-77860),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C17D1Ev,_ZTvn4076_n20_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C17D0Ev,_ZTvn4076_n20_N7S467C17D0Ev),
  ABISELECT(-125040,-82012),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-125040,-82012),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C17D1Ev,_ZTv0_n32_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C17D0Ev,_ZTv0_n32_N7S467C17D0Ev),
  ABISELECT(-125336,-82212),
  (VTBL_ENTRY)&(_ZTI7S467C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C17D1Ev,_ZTvn200_n32_N7S467C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C17D0Ev,_ZTvn200_n32_N7S467C17D0Ev),
};
extern VTBL_ENTRY _ZTV7S467C17[];
extern void _ZN7S467C15D1Ev();
extern void _ZN7S467C15D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C15__7S467C17[] = {
  ABISELECT(111680,73268),
  ABISELECT(105440,69192),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN7S467C15D1Ev,
  (VTBL_ENTRY)&_ZN7S467C15D0Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C47S467C15__7S467C17[] = {
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C47S467C15__7S467C17[] = {
  0,
  ABISELECT(-104912,-68832),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C47S467C15__7S467C17[] = {
  0,
  0,
  ABISELECT(-111152,-72908),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C15__7S467C17[] = {
  ABISELECT(111152,72908),
  ABISELECT(104912,68832),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C15__7S467C17[] = {
  0,
  ABISELECT(-105440,-69192),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__A1__7S467C15__7S467C17[] = {
  0,
  0,
  ABISELECT(-111680,-73268),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C62v3Ev();
extern void _ZN7S467C18D1Ev();
extern void _ZN7S467C18D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C18__7S467C17[] = {
  ABISELECT(87712,57504),
  ABISELECT(74352,48760),
  ABISELECT(68112,44684),
  ABISELECT(75104,49276),
  ABISELECT(74800,49076),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&_ZN7S467C18D1Ev,
  (VTBL_ENTRY)&_ZN7S467C18D0Ev,
};
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C127S467C18__7S467C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
};
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C137S467C127S467C18__7S467C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C137S467C127S467C18__7S467C17[] = {
  0,
  ABISELECT(-61872,-40608),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C137S467C127S467C18__7S467C17[] = {
  0,
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZThn81472_N7S467C13D1Ev,_ZThn53428_N7S467C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
extern void ABISELECT(_ZThn81472_N7S467C13D0Ev,_ZThn53428_N7S467C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C137S467C127S467C18__7S467C17[] = {
  ABISELECT(-81472,-53428),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-81472,-53428),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C137S467C127S467C18__7S467C17[] = {
  ABISELECT(-81768,-53628),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C127S467C18__7S467C17[] = {
  0,
  ABISELECT(-61872,-40608),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C127S467C18__7S467C17[] = {
  0,
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZThn81472_N7S467C12D1Ev,_ZThn53428_N7S467C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
extern void ABISELECT(_ZThn81472_N7S467C12D0Ev,_ZThn53428_N7S467C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C127S467C18__7S467C17[] = {
  ABISELECT(-81472,-53428),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-81472,-53428),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C127S467C18__7S467C17[] = {
  ABISELECT(-81768,-53628),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__7S467C18__7S467C17[] = {
  0,
  0,
  ABISELECT(-74800,-49076),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn75104_N7S467C18D1Ev,_ZThn49276_N7S467C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev)();
extern void ABISELECT(_ZThn75104_N7S467C18D0Ev,_ZThn49276_N7S467C18D0Ev)() __attribute__((weak));
extern void _ZN7S467C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S467C19__7S467C18__7S467C17[] = {
  0,
  ABISELECT(-75104,-49276),
  0,
  ABISELECT(-304,-200),
  ABISELECT(-75104,-49276),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev),
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
};
extern void ABISELECT(_ZTvn6240_n40_N7S467C18D1Ev,_ZTvn4076_n20_N7S467C18D1Ev)();
extern void ABISELECT(_ZTvn6240_n40_N7S467C18D0Ev,_ZTvn4076_n20_N7S467C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C77S467C19__7S467C18__7S467C17[] = {
  ABISELECT(-81344,-53352),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C18D1Ev,_ZTvn4076_n20_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn6240_n40_N7S467C18D0Ev,_ZTvn4076_n20_N7S467C18D0Ev),
};
extern void ABISELECT(_ZThn6240_N7S467C18D1Ev,_ZThn4076_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn6240_N7S467C18D0Ev,_ZThn4076_N7S467C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV7S467C12__7S467C18__7S467C17[] = {
  ABISELECT(81472,53428),
  ABISELECT(68112,44684),
  ABISELECT(61872,40608),
  ABISELECT(-6240,-4076),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C18D1Ev,_ZThn4076_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6240_N7S467C18D0Ev,_ZThn4076_N7S467C18D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__A2__7S467C18__7S467C17[] = {
  0,
  ABISELECT(-68112,-44684),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C18__7S467C17[] = {
  0,
  0,
  ABISELECT(-74352,-48760),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev)();
extern void ABISELECT(_ZThn87712_N7S467C18D1Ev,_ZThn57504_N7S467C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev)();
extern void ABISELECT(_ZThn87712_N7S467C18D0Ev,_ZThn57504_N7S467C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C18__7S467C17[] = {
  ABISELECT(-87712,-57504),
  0,
  0,
  0,
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  ABISELECT(-87712,-57504),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C18D1Ev,_ZTvn200_n32_N7S467C18D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C18D0Ev,_ZTvn200_n32_N7S467C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__A1__7S467C18__7S467C17[] = {
  ABISELECT(-88008,-57704),
  (VTBL_ENTRY)&(_ZTI7S467C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C18D1Ev,_ZTvn200_n32_N7S467C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C18D0Ev,_ZTvn200_n32_N7S467C18D0Ev),
};
extern void _ZN6S467C62v3Ev();
extern void _ZN7S467C19D1Ev();
extern void _ZN7S467C19D0Ev();
extern void _ZN7S467C193v12Ev();
static  VTBL_ENTRY _tg__ZTV7S467C19__7S467C17[] = {
  ABISELECT(-304,-200),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  (VTBL_ENTRY)&_ZN7S467C19D1Ev,
  (VTBL_ENTRY)&_ZN7S467C19D0Ev,
  (VTBL_ENTRY)&_ZN7S467C193v12Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__7S467C19__7S467C17[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S467C19[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__A1__7S467C17[] = {
  ABISELECT(-13360,-8744),
  ABISELECT(-19600,-12820),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__A1__7S467C17[] = {
  0,
  ABISELECT(19600,12820),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__A1__7S467C17[] = {
  0,
  0,
  ABISELECT(13360,8744),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C17[] = {
  {&(_ZTV7S467C17[7]),  7,100},
  {&(_tg__ZTV7S467C15__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C47S467C15__7S467C17[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C47S467C15__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C47S467C15__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C15__7S467C17[4]),  4,9},
  {&(_tg__ZTV6S467C6__7S467C15__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__A1__7S467C15__7S467C17[4]),  4,6},
  {&(_tg__ZTV7S467C18__7S467C17[7]),  7,10},
  {&(_tg__ZTV7S467C127S467C18__7S467C17[5]),  5,7},
  {&(_tg__ZTV7S467C137S467C127S467C18__7S467C17[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C137S467C127S467C18__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C137S467C127S467C18__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C137S467C127S467C18__7S467C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C137S467C127S467C18__7S467C17[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C127S467C18__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C127S467C18__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C127S467C18__7S467C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C127S467C18__7S467C17[2]),  2,4},
  {&(_tg__ZTV6S467C5__7S467C18__7S467C17[4]),  4,6},
  {&(_tg__ZTV7S467C19__7S467C18__7S467C17[6]),  6,10},
  {&(_tg__ZTV6S468C77S467C19__7S467C18__7S467C17[2]),  2,4},
  {&(_tg__ZTV7S467C12__7S467C18__7S467C17[5]),  5,7},
  {&(_tg__ZTV6S467C6__A2__7S467C18__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C18__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C18__7S467C17[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__A1__7S467C18__7S467C17[2]),  2,4},
  {&(_ZTV7S467C17[56]),  56,100},
  {&(_ZTV7S467C17[17]),  17,100},
  {&(_ZTV7S467C17[61]),  61,100},
  {&(_ZTV7S467C17[33]),  33,100},
  {&(_ZTV7S467C17[67]),  67,100},
  {&(_ZTV7S467C17[75]),  75,100},
  {&(_ZTV7S467C17[81]),  81,100},
  {&(_ZTV7S467C17[41]),  41,100},
  {&(_ZTV7S467C17[91]),  91,100},
  {&(_ZTV7S467C17[98]),  98,100},
  {&(_tg__ZTV7S467C19__7S467C17[3]),  3,7},
  {&(_tg__ZTV6S467C5__7S467C19__7S467C17[4]),  4,6},
  {&(_tg__ZTV6S467C4__A1__7S467C17[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__A1__7S467C17[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__A1__7S467C17[4]),  4,6},
};
extern VTBL_ENTRY _ZTI7S467C17[];
extern  VTBL_ENTRY _ZTV7S467C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C17[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C18D0Ev,_ZTv0_n32_N7S467C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn87712_N7S467C18D0Ev,_ZThn57504_N7S467C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C18D1Ev,_ZTv0_n32_N7S467C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn87712_N7S467C18D1Ev,_ZThn57504_N7S467C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C18D0Ev,_ZTv0_n20_N7S467C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn75104_N7S467C18D0Ev,_ZThn49276_N7S467C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C18D1Ev,_ZTv0_n20_N7S467C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn75104_N7S467C18D1Ev,_ZThn49276_N7S467C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S467C12D0Ev,_ZThn53428_N7S467C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S467C12D1Ev,_ZThn53428_N7S467C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S467C13D0Ev,_ZThn53428_N7S467C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn81472_N7S467C13D1Ev,_ZThn53428_N7S467C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C17D0Ev,_ZTv0_n32_N7S467C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn125040_N7S467C17D0Ev,_ZThn82012_N7S467C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C17D1Ev,_ZTv0_n32_N7S467C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn125040_N7S467C17D1Ev,_ZThn82012_N7S467C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C17D0Ev,_ZTv0_n20_N7S467C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112432_N7S467C17D0Ev,_ZThn73784_N7S467C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S467C17D1Ev,_ZTv0_n20_N7S467C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112432_N7S467C17D1Ev,_ZThn73784_N7S467C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C17 = {  "S467C17", // class name
  bases_S467C17, 22,
  &(vtc_S467C17[0]), // expected_vtbl_contents
  &(vtt_S467C17[0]), // expected_vtt_contents
  ABISELECT(132336,86780), // object size
  NSPAIRA(_ZTI7S467C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S467C17),100, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C17),42, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C16  {
  ::S467C12 s467c16f0;
  ::S467C17 s467c16f1;
  int s467c16f2;
  ::S467C5 s467c16f3;
  ::S468C14_nt s467c16f4;
  void *s467c16f5;
  int s467c16f6:15;
  int s467c16f7;
  int s467c16f8;
  void  mf467c16(); // _ZN7S467C168mf467c16Ev
};
//SIG(-1 S467C16) C1{ m FC2{ BC3{ VBC4{ v1 FC5{ v4 v5 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp}[8] FC5[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} VBC7{ v2 v3 Fc FL[10] FD FC5 Fp Fs Fp Fi} VBC8{ BC5 VBC4 BC6 VBC7 v6 Fi:2 FD[7] Fp FC4 Fp Fi Fp[2] FC6 FC5 FD[8]} BC6 Fp FC6 FC5 Fs} BC5 BC9{ vd v7 v8 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC7 FL Fi FC7} FC11{ BC8 BC7 BC6 BC4 VBC5 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC7 Fi}} FC12{ VBC4 BC13{ BC6 BC7 BC8 Fp FC8 Fc[7] FC9 Fi Fc[4] Fp FC8 Fi Fi[7] Fi} BC14{ BC4 VBC5 VBC15{ BC4 BC6 VBC5 vd v11 Fi Fs Fs:1 Fp Fl FC4 Fi[2] Fc[3] Fi} BC2 vd Fp} Fp Fi[4] FC16{} FC2 FC17{ m Fc} Fi Fi:24 FC17 Fi FC16} Fi FC5 FC17 Fp Fi:15 Fi Fi}


void  S467C16 ::mf467c16(){}

static void Test_S467C16()
{
  {
    init_simple_test("S467C16");
    static S467C16 lv;
    check2(sizeof(lv), ABISELECT(170576,111864), "sizeof(S467C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C16)");
    check_field_offset(lv, s467c16f0, 0, "S467C16.s467c16f0");
    check_field_offset(lv, s467c16f1, ABISELECT(37888,24860), "S467C16.s467c16f1");
    check_field_offset(lv, s467c16f2, ABISELECT(170224,111640), "S467C16.s467c16f2");
    check_field_offset(lv, s467c16f3, ABISELECT(170240,111644), "S467C16.s467c16f3");
    check_field_offset(lv, s467c16f4, ABISELECT(170544,111844), "S467C16.s467c16f4");
    check_field_offset(lv, s467c16f5, ABISELECT(170552,111848), "S467C16.s467c16f5");
    set_bf_and_test(lv, s467c16f6, ABISELECT(170560,111852), 0, 15, 1, "S467C16");
    set_bf_and_test(lv, s467c16f6, ABISELECT(170560,111852), 0, 15, hide_sll(1LL<<14), "S467C16");
    check_field_offset(lv, s467c16f7, ABISELECT(170564,111856), "S467C16.s467c16f7");
    check_field_offset(lv, s467c16f8, ABISELECT(170568,111860), "S467C16.s467c16f8");
  }
}
static Arrange_To_Call_Me vS467C16(Test_S467C16, "S467C16", ABISELECT(170576,111864));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S467C16[];
VTBL_ENTRY *P__ZTI7S467C16 = _ZTI7S467C16; 
Class_Descriptor cd_S467C16 = {  "S467C16", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(170576,111864), // object size
  NSPAIRA(_ZTI7S467C16),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C21  : virtual S467C8 , virtual S467C4 , virtual S467C5 , virtual S467C11 , virtual S467C12 {
  void *s467c21f0;
  ::S467C5 s467c21f1;
  void *s467c21f2;
  void *s467c21f3;
  int s467c21f4;
  ::S467C5 s467c21f5;
  short s467c21f6;
  int s467c21f7;
  char s467c21f8[10];
  void *s467c21f9;
  int s467c21f10;
  long s467c21f11[4];
  void *s467c21f12;
  virtual  ~S467C21(); // _ZN7S467C21D2Ev
  S467C21(); // tgen
};
//SIG(-1 S467C21) C1{ VBC2{ v1 v2 Fc FL[10] FD FC3{ v3 v4 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} Fp Fs Fp Fi} VBC4{ BC3 VBC5{ v5 FC3[8] FC3[2] Fp Fi FC6{ vd m Fp FL Fp[7]} FC3[5] Fp[5] FC3[5]} BC6 VBC2 v6 Fi:2 FD[7] Fp FC5 Fp Fi Fp[2] FC6 FC3 FD[8]} VBC3 VBC7{ BC8{ BC9{ VBC5 VBC2 VBC4 BC6 Fp FC6 FC3 Fs} BC3 BC10{ vd v7 v8 Fi FC3 Fi[2] FU11{ m FL FD[10] FD Fs:0} FD Fi Fi FC2 FL Fi FC2} FC12{ BC4 BC2 BC6 BC5 VBC3 vd v9 v10 FC6 Fi Fp[2] FL[2] Fi[2] Fp Fi FC2 Fi}} VBC3 BC6 BC10 FC13{ m Fc} Fi Fi Fi:6 FC13 Fi} VBC8 vd Fp FC3 Fp Fp Fi FC3 Fs Fi Fc[10] Fp Fi Fl[4] Fp}


 S467C21 ::~S467C21(){ note_dtor("S467C21", this);}
S467C21 ::S467C21(){ note_ctor("S467C21", this);} // tgen

static void Test_S467C21()
{
  extern Class_Descriptor cd_S467C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4025,10574)];
    init_test(&cd_S467C21, buf);
    S467C21 *dp, &lv = *(dp=new (buf) S467C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64384,42292), "sizeof(S467C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C21)");
    check_base_class_offset(lv, (S467C8*), ABISELECT(736,468), "S467C21");
    check_base_class_offset(lv, (S467C8*)(S467C4*), ABISELECT(736,468), "S467C21");
    check_base_class_offset(lv, (S467C8*)(S467C13*)(S467C12*)(S467C11*), ABISELECT(736,468), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C13*)(S467C12*), ABISELECT(736,468), "S467C21");
    check_base_class_offset(lv, (S467C5*)(S467C4*), ABISELECT(1184,784), "S467C21");
    check_base_class_offset(lv, (S467C6*)(S467C4*), ABISELECT(8480,5552), "S467C21");
    check_base_class_offset(lv, (S467C6*)(S467C13*)(S467C12*)(S467C11*), ABISELECT(8480,5552), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C13*)(S467C12*), ABISELECT(8480,5552), "S467C21");
    check_base_class_offset(lv, (S468C7*)(S467C4*), ABISELECT(1480,984), "S467C21");
    check_base_class_offset(lv, (S467C4*), ABISELECT(1184,784), "S467C21");
    check_base_class_offset(lv, (S467C4*)(S467C13*)(S467C12*)(S467C11*), ABISELECT(1184,784), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C4*)(S467C13*)(S467C12*), ABISELECT(1184,784), "S467C21");
    /*is_ambiguous_... S467C21::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*), ABISELECT(14720,9628), "S467C21");
    /*is_ambiguous_... S467C11::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C11*), ABISELECT(14720,9628), "S467C21");
    /*is_ambiguous_... S467C13::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*)(S467C12*)(S467C11*), ABISELECT(15024,9828), "S467C21");
    check_base_class_offset(lv, (S467C13*)(S467C12*)(S467C11*), ABISELECT(15024,9828), "S467C21");
    /*is_ambiguous_... S467C12::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C12*)(S467C11*), ABISELECT(15520,10124), "S467C21");
    check_base_class_offset(lv, (S467C9*)(S467C12*)(S467C11*), ABISELECT(15824,10324), "S467C21");
    check_base_class_offset(lv, (S467C12*)(S467C11*), ABISELECT(15024,9828), "S467C21");
    /*is_ambiguous_... S467C11::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C11*), ABISELECT(38928,25528), "S467C21");
    /*is_ambiguous_... S467C11::S467C9 */ AMB_check_base_class_offset(lv, (S467C9*)(S467C11*), ABISELECT(39008,25572), "S467C21");
    check_base_class_offset(lv, (S467C11*), ABISELECT(15024,9828), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C13*)(S467C12*), ABISELECT(40480,26592), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C13*)(S467C12*), ABISELECT(40480,26592), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C12*), ABISELECT(40976,26888), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C9*)(S467C12*), ABISELECT(41280,27088), "S467C21");
    /*is_ambiguous_... S467C21::S467C12 */ AMB_check_base_class_offset(lv, (S467C12*), ABISELECT(40480,26592), "S467C21");
    check_field_offset(lv, s467c21f0, ABISELECT(8,4), "S467C21.s467c21f0");
    check_field_offset(lv, s467c21f1, ABISELECT(16,8), "S467C21.s467c21f1");
    check_field_offset(lv, s467c21f2, ABISELECT(320,208), "S467C21.s467c21f2");
    check_field_offset(lv, s467c21f3, ABISELECT(328,212), "S467C21.s467c21f3");
    check_field_offset(lv, s467c21f4, ABISELECT(336,216), "S467C21.s467c21f4");
    check_field_offset(lv, s467c21f5, ABISELECT(352,220), "S467C21.s467c21f5");
    check_field_offset(lv, s467c21f6, ABISELECT(656,420), "S467C21.s467c21f6");
    check_field_offset(lv, s467c21f7, ABISELECT(660,424), "S467C21.s467c21f7");
    check_field_offset(lv, s467c21f8, ABISELECT(664,428), "S467C21.s467c21f8");
    check_field_offset(lv, s467c21f9, ABISELECT(680,440), "S467C21.s467c21f9");
    check_field_offset(lv, s467c21f10, ABISELECT(688,444), "S467C21.s467c21f10");
    check_field_offset(lv, s467c21f11, ABISELECT(696,448), "S467C21.s467c21f11");
    check_field_offset(lv, s467c21f12, ABISELECT(728,464), "S467C21.s467c21f12");
    test_class_info(&lv, &cd_S467C21);
    dp->~S467C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C21(Test_S467C21, "S467C21", ABISELECT(64384,42292));

#else // __cplusplus

extern void _ZN7S467C21C1Ev();
extern void _ZN7S467C21D2Ev();
Name_Map name_map_S467C21[] = {
  NSPAIR(_ZN7S467C21C1Ev),
  NSPAIR(_ZN7S467C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C12;
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C11;
extern VTBL_ENTRY _ZTI7S467C11[];
extern  VTBL_ENTRY _ZTV7S467C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C11[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C13;
extern VTBL_ENTRY _ZTI7S467C13[];
extern  VTBL_ENTRY _ZTV7S467C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C13[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C12;
extern VTBL_ENTRY _ZTI7S467C12[];
extern  VTBL_ENTRY _ZTV7S467C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C12[];
static Base_Class bases_S467C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C8,    ABISELECT(736,468), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C5,    ABISELECT(1184,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(8480,5552), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(1480,984), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(1184,784), //bcp->offset
    16, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C5,    ABISELECT(14720,9628), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S467C13,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(15520,10124), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(15824,10324), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S467C12,    ABISELECT(15024,9828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(38928,25528), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(39008,25572), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S467C11,    ABISELECT(15024,9828), //bcp->offset
    43, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S468C7,    ABISELECT(40480,26592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S467C13,    ABISELECT(40480,26592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(40976,26888), //bcp->offset
    88, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(41280,27088), //bcp->offset
    92, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S467C12,    ABISELECT(40480,26592), //bcp->offset
    76, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S467C21[];
extern void _ZN7S467C21D1Ev();
extern void _ZN7S467C21D0Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C21D1Ev,_ZTv0_n32_N7S467C21D1Ev)();
extern void ABISELECT(_ZThn1184_N7S467C21D1Ev,_ZThn784_N7S467C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S467C21D0Ev,_ZTv0_n32_N7S467C21D0Ev)();
extern void ABISELECT(_ZThn1184_N7S467C21D0Ev,_ZThn784_N7S467C21D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn296_n64_N7S467C21D1Ev,_ZTvn200_n32_N7S467C21D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C21D0Ev,_ZTvn200_n32_N7S467C21D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZTv0_n56_N7S467C21D1Ev,_ZTv0_n28_N7S467C21D1Ev)();
extern void ABISELECT(_ZThn15024_N7S467C21D1Ev,_ZThn9828_N7S467C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S467C21D0Ev,_ZTv0_n28_N7S467C21D0Ev)();
extern void ABISELECT(_ZThn15024_N7S467C21D0Ev,_ZThn9828_N7S467C21D0Ev)() __attribute__((weak));
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZTvn800_n56_N7S467C21D1Ev,_ZTvn496_n28_N7S467C21D1Ev)();
extern void ABISELECT(_ZTvn800_n56_N7S467C21D0Ev,_ZTvn496_n28_N7S467C21D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void ABISELECT(_ZTvn23904_n56_N7S467C21D1Ev,_ZTvn15700_n28_N7S467C21D1Ev)();
extern void ABISELECT(_ZTvn23904_n56_N7S467C21D0Ev,_ZTvn15700_n28_N7S467C21D0Ev)();
extern void ABISELECT(_ZTvn23984_n56_N7S467C21D1Ev,_ZTvn15744_n28_N7S467C21D1Ev)();
extern void ABISELECT(_ZTvn23984_n56_N7S467C21D0Ev,_ZTvn15744_n28_N7S467C21D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void ABISELECT(_ZTv0_n48_N7S467C21D1Ev,_ZTv0_n24_N7S467C21D1Ev)();
extern void ABISELECT(_ZThn40480_N7S467C21D1Ev,_ZThn26592_N7S467C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S467C21D0Ev,_ZTv0_n24_N7S467C21D0Ev)();
extern void ABISELECT(_ZThn40480_N7S467C21D0Ev,_ZThn26592_N7S467C21D0Ev)() __attribute__((weak));
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZTvn800_n48_N7S467C21D1Ev,_ZTvn496_n24_N7S467C21D1Ev)();
extern void ABISELECT(_ZTvn800_n48_N7S467C21D0Ev,_ZTvn496_n24_N7S467C21D0Ev)();
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
static  VTBL_ENTRY vtc_S467C21[] = {
  ABISELECT(40480,26592),
  ABISELECT(15024,9828),
  ABISELECT(14720,9628),
  ABISELECT(8480,5552),
  ABISELECT(1184,784),
  ABISELECT(736,468),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN7S467C21D1Ev,
  (VTBL_ENTRY)&_ZN7S467C21D0Ev,
  0,
  0,
  ABISELECT(-736,-468),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-1184,-784),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(-1184,-784),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C21D1Ev,_ZTv0_n32_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C21D0Ev,_ZTv0_n32_N7S467C21D0Ev),
  ABISELECT(-1480,-984),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C21D1Ev,_ZTvn200_n32_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C21D0Ev,_ZTvn200_n32_N7S467C21D0Ev),
  0,
  ABISELECT(-8480,-5552),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-14720,-9628),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(800,496),
  ABISELECT(800,496),
  ABISELECT(496,296),
  ABISELECT(496,296),
  ABISELECT(-15024,-9828),
  ABISELECT(-304,-200),
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  ABISELECT(-15024,-9828),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S467C21D1Ev,_ZTv0_n28_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S467C21D0Ev,_ZTv0_n28_N7S467C21D0Ev),
  ABISELECT(-15520,-10124),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-15824,-10324),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n56_N7S467C21D1Ev,_ZTvn496_n28_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n56_N7S467C21D0Ev,_ZTvn496_n28_N7S467C21D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  ABISELECT(-38928,-25528),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23904_n56_N7S467C21D1Ev,_ZTvn15700_n28_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23904_n56_N7S467C21D0Ev,_ZTvn15700_n28_N7S467C21D0Ev),
  ABISELECT(-39008,-25572),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23984_n56_N7S467C21D1Ev,_ZTvn15744_n28_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn23984_n56_N7S467C21D0Ev,_ZTvn15744_n28_N7S467C21D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  ABISELECT(800,496),
  ABISELECT(800,496),
  ABISELECT(496,296),
  ABISELECT(496,296),
  ABISELECT(-40480,-26592),
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  ABISELECT(-40480,-26592),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S467C21D1Ev,_ZTv0_n24_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S467C21D0Ev,_ZTv0_n24_N7S467C21D0Ev),
  ABISELECT(-40976,-26888),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  ABISELECT(-41280,-27088),
  (VTBL_ENTRY)&(_ZTI7S467C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n48_N7S467C21D1Ev,_ZTvn496_n24_N7S467C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn800_n48_N7S467C21D0Ev,_ZTvn496_n24_N7S467C21D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
};
extern VTBL_ENTRY _ZTV7S467C21[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C21[] = {
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C4__7S467C21[] = {
  0,
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C4__7S467C21[] = {
  0,
  0,
  ABISELECT(448,316),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN7S467C11D1Ev();
extern void _ZN7S467C11D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C11__7S467C21[] = {
  ABISELECT(-304,-200),
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN7S467C11D1Ev,
  (VTBL_ENTRY)&_ZN7S467C11D0Ev,
};
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C127S467C11__7S467C21[] = {
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
};
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C137S467C127S467C11__7S467C21[] = {
  ABISELECT(-13840,-9044),
  ABISELECT(-14288,-9360),
  ABISELECT(-6544,-4276),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C137S467C127S467C11__7S467C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C137S467C127S467C11__7S467C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C137S467C127S467C11__7S467C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C137S467C127S467C11__7S467C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C127S467C11__7S467C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C127S467C11__7S467C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C127S467C11__7S467C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C127S467C11__7S467C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C11__7S467C21[] = {
  0,
  ABISELECT(6544,4276),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C11__7S467C21[] = {
  0,
  0,
  ABISELECT(14288,9360),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C11D1Ev,_ZTv0_n32_N7S467C11D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S467C11D0Ev,_ZTv0_n32_N7S467C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C11__7S467C21[] = {
  ABISELECT(13840,9044),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(13840,9044),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C11D1Ev,_ZTv0_n32_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C11D0Ev,_ZTv0_n32_N7S467C11D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C11D1Ev,_ZTvn200_n32_N7S467C11D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C11D0Ev,_ZTvn200_n32_N7S467C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C11__7S467C21[] = {
  ABISELECT(13544,8844),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C11D1Ev,_ZTvn200_n32_N7S467C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C11D0Ev,_ZTvn200_n32_N7S467C11D0Ev),
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__A2__7S467C11__7S467C21[] = {
  0,
  0,
  ABISELECT(304,200),
  (VTBL_ENTRY)&(_ZTI7S467C11[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN7S467C12D1Ev();
extern void _ZN7S467C12D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C12__A1__7S467C21[] = {
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN7S467C12D1Ev,
  (VTBL_ENTRY)&_ZN7S467C12D0Ev,
};
extern void _ZN7S467C13D1Ev();
extern void _ZN7S467C13D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C137S467C12__A1__7S467C21[] = {
  ABISELECT(-39296,-25808),
  ABISELECT(-39744,-26124),
  ABISELECT(-32000,-21040),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN7S467C13D1Ev,
  (VTBL_ENTRY)&_ZN7S467C13D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C137S467C12__A1__7S467C21[] = {
  0,
  ABISELECT(32000,21040),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C137S467C12__A1__7S467C21[] = {
  0,
  0,
  ABISELECT(39744,26124),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C137S467C12__A1__7S467C21[] = {
  ABISELECT(39296,25808),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(39296,25808),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D1Ev,_ZTv0_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C13D0Ev,_ZTv0_n32_N7S467C13D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C137S467C12__A1__7S467C21[] = {
  ABISELECT(39000,25608),
  (VTBL_ENTRY)&(_ZTI7S467C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D1Ev,_ZTvn200_n32_N7S467C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C13D0Ev,_ZTvn200_n32_N7S467C13D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C12__A1__7S467C21[] = {
  0,
  ABISELECT(32000,21040),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__7S467C12__A1__7S467C21[] = {
  0,
  0,
  ABISELECT(39744,26124),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C12__A1__7S467C21[] = {
  ABISELECT(39296,25808),
  0,
  0,
  0,
  ABISELECT(-448,-316),
  ABISELECT(7296,4768),
  ABISELECT(39296,25808),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D1Ev,_ZTv0_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S467C12D0Ev,_ZTv0_n32_N7S467C12D0Ev),
};
extern void ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev)();
extern void ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S468C76S467C4__7S467C12__A1__7S467C21[] = {
  ABISELECT(39000,25608),
  (VTBL_ENTRY)&(_ZTI7S467C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D1Ev,_ZTvn200_n32_N7S467C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn296_n64_N7S467C12D0Ev,_ZTvn200_n32_N7S467C12D0Ev),
};
static  VTT_ENTRY vtt_S467C21[] = {
  {&(_ZTV7S467C21[8]),  8,98},
  {&(_ZTV7S467C21[14]),  14,98},
  {&(_ZTV7S467C21[24]),  24,98},
  {&(_ZTV7S467C21[36]),  36,98},
  {&(_ZTV7S467C21[31]),  31,98},
  {&(_ZTV7S467C21[41]),  41,98},
  {&(_ZTV7S467C21[54]),  54,98},
  {&(_ZTV7S467C21[58]),  58,98},
  {&(_ZTV7S467C21[62]),  62,98},
  {&(_ZTV7S467C21[68]),  68,98},
  {&(_ZTV7S467C21[72]),  72,98},
  {&(_ZTV7S467C21[86]),  86,98},
  {&(_ZTV7S467C21[90]),  90,98},
  {&(_ZTV7S467C21[94]),  94,98},
  {&(_tg__ZTV6S467C4__7S467C21[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C4__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C4__7S467C21[4]),  4,6},
  {&(_tg__ZTV7S467C11__7S467C21[6]),  6,8},
  {&(_tg__ZTV7S467C127S467C11__7S467C21[5]),  5,7},
  {&(_tg__ZTV7S467C137S467C127S467C11__7S467C21[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C137S467C127S467C11__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C137S467C127S467C11__7S467C21[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C137S467C127S467C11__7S467C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C137S467C127S467C11__7S467C21[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C127S467C11__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C127S467C11__7S467C21[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C127S467C11__7S467C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C127S467C11__7S467C21[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C11__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C11__7S467C21[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C11__7S467C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C11__7S467C21[2]),  2,4},
  {&(_tg__ZTV6S467C5__A2__7S467C11__7S467C21[4]),  4,6},
  {&(_tg__ZTV7S467C12__A1__7S467C21[5]),  5,7},
  {&(_tg__ZTV7S467C137S467C12__A1__7S467C21[5]),  5,7},
  {&(_tg__ZTV6S467C6__7S467C137S467C12__A1__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C137S467C12__A1__7S467C21[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C137S467C12__A1__7S467C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C137S467C12__A1__7S467C21[2]),  2,4},
  {&(_tg__ZTV6S467C6__7S467C12__A1__7S467C21[3]),  3,4},
  {&(_tg__ZTV6S467C8__7S467C12__A1__7S467C21[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C12__A1__7S467C21[8]),  8,13},
  {&(_tg__ZTV6S468C76S467C4__7S467C12__A1__7S467C21[2]),  2,4},
};
extern VTBL_ENTRY _ZTI7S467C21[];
extern  VTBL_ENTRY _ZTV7S467C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C21[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S467C21D0Ev,_ZTv0_n24_N7S467C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40480_N7S467C21D0Ev,_ZThn26592_N7S467C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S467C21D1Ev,_ZTv0_n24_N7S467C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40480_N7S467C21D1Ev,_ZThn26592_N7S467C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S467C21D0Ev,_ZTv0_n28_N7S467C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15024_N7S467C21D0Ev,_ZThn9828_N7S467C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S467C21D1Ev,_ZTv0_n28_N7S467C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15024_N7S467C21D1Ev,_ZThn9828_N7S467C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C21D0Ev,_ZTv0_n32_N7S467C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N7S467C21D0Ev,_ZThn784_N7S467C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S467C21D1Ev,_ZTv0_n32_N7S467C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N7S467C21D1Ev,_ZThn784_N7S467C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C21 = {  "S467C21", // class name
  bases_S467C21, 19,
  &(vtc_S467C21[0]), // expected_vtbl_contents
  &(vtt_S467C21[0]), // expected_vtt_contents
  ABISELECT(64384,42292), // object size
  NSPAIRA(_ZTI7S467C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV7S467C21),98, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S467C21),43, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S467C1  : S467C2 , virtual S467C15 , S467C16 {
  __tsi64 s467c1f0;
  void *s467c1f1;
  long double s467c1f2;
  long double s467c1f3[6];
  int s467c1f4;
  int s467c1f5;
  long double s467c1f6;
  ::S467C21 s467c1f7;
  ::S468C14_nt s467c1f8[5];
  ::S467C12 s467c1f9;
  ::S467C12 s467c1f10;
  int s467c1f11;
  ::S468C14_nt s467c1f12;
  ~S467C1(); // tgen
  S467C1(); // tgen
};
//SIG(1 S467C1) C1{ BC2{ BC3{ BC4{ BC5{ v1 v2 FL Fp Fc:6 FD Fc[7] FL Fc[9] FD[8] Fp Fs Fp[7] Fi Fp} VBC6{ v3 FC5[8] FC5[2] Fp Fi FC7{ vd m Fp FL Fp[7]} FC5[5] Fp[5] FC5[5]} BC7 VBC8{ v4 v5 Fc FL[10] FD FC5 Fp Fs Fp Fi} v6 Fi:2 FD[7] Fp FC6 Fp Fi Fp[2] FC7 FC5 FD[8]} BC8 BC7 BC6 VBC5 vd v7 v8 FC7 Fi Fp[2] FL[2] Fi[2] Fp Fi FC8 Fi} BC4 VBC9{ vd v9 v10 Fi FC5 Fi[2] FU10{ m FL FD[10] FD Fs:0} FD Fi Fi FC8 FL Fi FC8} vd v11 Fp FD FD FC11{ BC12{ BC13{ VBC6 VBC8 VBC4 BC7 Fp FC7 FC5 Fs} BC5 BC9 FC3} VBC5 BC7 BC9 FC14{ m Fc} Fi Fi Fi:6 FC14 Fi}} VBC15{ BC7 BC8 BC4 Fp FC4 Fc[7] FC9 Fi Fc[4] Fp FC4 Fi Fi[7] Fi} BC16{ m FC12 FC17{ VBC6 BC15 BC18{ BC6 VBC5 VBC19{ BC6 BC7 VBC5 vd v12 Fi Fs Fs:1 Fp Fl FC6 Fi[2] Fc[3] Fi} BC12 vd Fp} Fp Fi[4] FC20{} FC12 FC14 Fi Fi:24 FC14 Fi FC20} Fi FC5 FC14 Fp Fi:15 Fi Fi} FL Fp FD FD[6] Fi Fi FD FC21{ VBC8 VBC4 VBC5 VBC11 VBC12 vd Fp FC5 Fp Fp Fi FC5 Fs Fi Fc[10] Fp Fi Fl[4] Fp} FC14[5] FC12 FC12 Fi FC14}


S467C1 ::~S467C1(){ note_dtor("S467C1", this);} // tgen
S467C1 ::S467C1(){ note_ctor("S467C1", this);} // tgen

static void Test_S467C1()
{
  extern Class_Descriptor cd_S467C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26154,68661)];
    init_test(&cd_S467C1, buf);
    S467C1 *dp, &lv = *(dp=new (buf) S467C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(418448,274640), "sizeof(S467C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S467C1)");
    check_base_class_offset(lv, (S467C5*)(S467C4*)(S467C3*)(S467C2*), 0, "S467C1");
    check_base_class_offset(lv, (S467C6*)(S467C4*)(S467C3*)(S467C2*), ABISELECT(372688,244540), "S467C1");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C4*)(S467C2*), ABISELECT(372688,244540), "S467C1");
    check_base_class_offset(lv, (S467C6*)(S467C4*)(S467C15*), ABISELECT(372688,244540), "S467C1");
    check_base_class_offset(lv, (S468C7*)(S467C4*)(S467C3*)(S467C2*), ABISELECT(296,200), "S467C1");
    check_base_class_offset(lv, (S467C8*)(S467C4*)(S467C3*)(S467C2*), ABISELECT(378928,248616), "S467C1");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C4*)(S467C2*), ABISELECT(378928,248616), "S467C1");
    check_base_class_offset(lv, (S467C8*)(S467C4*)(S467C15*), ABISELECT(378928,248616), "S467C1");
    check_base_class_offset(lv, (S467C4*)(S467C3*)(S467C2*), 0, "S467C1");
    /*is_ambiguous_... S467C3::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C3*)(S467C2*), ABISELECT(7296,4768), "S467C1");
    /*is_ambiguous_... S467C3::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C3*)(S467C2*), ABISELECT(7744,5084), "S467C1");
    /*is_ambiguous_... S467C3::S467C6 */ AMB_check_base_class_offset(lv, (S467C6*)(S467C3*)(S467C2*), ABISELECT(7824,5128), "S467C1");
    /*is_ambiguous_... S467C3::S467C5 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C3*)(S467C2*), ABISELECT(379376,248932), "S467C1");
    check_base_class_offset(lv, (S467C3*)(S467C2*), 0, "S467C1");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C5*)(S467C4*)(S467C2*), ABISELECT(14672,9612), "S467C1");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C4*)(S467C2*), ABISELECT(14968,9812), "S467C1");
    /*is_ambiguous_... S467C2::S467C4 */ AMB_check_base_class_offset(lv, (S467C4*)(S467C2*), ABISELECT(14672,9612), "S467C1");
    check_base_class_offset(lv, (S467C9*)(S467C2*), ABISELECT(379680,249132), "S467C1");
    check_base_class_offset(lv, (S467C2*), 0, "S467C1");
    /*is_ambiguous_... S467C15::S468C7 */ AMB_check_base_class_offset(lv, (S468C7*)(S467C15*), ABISELECT(381120,250132), "S467C1");
    /*is_ambiguous_... S467C15::S467C8 */ AMB_check_base_class_offset(lv, (S467C8*)(S467C15*), ABISELECT(381200,250176), "S467C1");
    check_base_class_offset(lv, (S467C5*)(S467C4*)(S467C15*), ABISELECT(381648,250492), "S467C1");
    check_base_class_offset(lv, (S468C7*)(S467C4*)(S467C15*), ABISELECT(381944,250692), "S467C1");
    check_base_class_offset(lv, (S467C4*)(S467C15*), ABISELECT(381648,250492), "S467C1");
    check_base_class_offset(lv, (S467C15*), ABISELECT(381120,250132), "S467C1");
    check_base_class_offset(lv, (S467C16*), ABISELECT(61760,40532), "S467C1");
    check_field_offset(lv, s467c1f0, ABISELECT(232336,152396), "S467C1.s467c1f0");
    check_field_offset(lv, s467c1f1, ABISELECT(232344,152404), "S467C1.s467c1f1");
    check_field_offset(lv, s467c1f2, ABISELECT(232352,152408), "S467C1.s467c1f2");
    check_field_offset(lv, s467c1f3, ABISELECT(232368,152420), "S467C1.s467c1f3");
    check_field_offset(lv, s467c1f4, ABISELECT(232464,152492), "S467C1.s467c1f4");
    check_field_offset(lv, s467c1f5, ABISELECT(232468,152496), "S467C1.s467c1f5");
    check_field_offset(lv, s467c1f6, ABISELECT(232480,152500), "S467C1.s467c1f6");
    check_field_offset(lv, s467c1f7, ABISELECT(232496,152512), "S467C1.s467c1f7");
    check_field_offset(lv, s467c1f8, ABISELECT(296880,194804), "S467C1.s467c1f8");
    check_field_offset(lv, s467c1f9, ABISELECT(296896,194812), "S467C1.s467c1f9");
    check_field_offset(lv, s467c1f10, ABISELECT(334784,219672), "S467C1.s467c1f10");
    check_field_offset(lv, s467c1f11, ABISELECT(372672,244532), "S467C1.s467c1f11");
    check_field_offset(lv, s467c1f12, ABISELECT(372676,244536), "S467C1.s467c1f12");
    test_class_info(&lv, &cd_S467C1);
    dp->~S467C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS467C1(Test_S467C1, "S467C1", ABISELECT(418448,274640));

#else // __cplusplus

extern void _ZN6S467C1C1Ev();
extern void _ZN6S467C1D1Ev();
Name_Map name_map_S467C1[] = {
  NSPAIR(_ZN6S467C1C1Ev),
  NSPAIR(_ZN6S467C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C6;
extern VTBL_ENTRY _ZTI6S467C6[];
extern  VTBL_ENTRY _ZTV6S467C6[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S467C3;
extern VTBL_ENTRY _ZTI6S467C3[];
extern  VTBL_ENTRY _ZTV6S467C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C3[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C9;
extern VTBL_ENTRY _ZTI6S467C9[];
extern  VTBL_ENTRY _ZTV6S467C9[];
extern Class_Descriptor cd_S467C2;
extern VTBL_ENTRY _ZTI6S467C2[];
extern  VTBL_ENTRY _ZTV6S467C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C2[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C8;
extern VTBL_ENTRY _ZTI6S467C8[];
extern  VTBL_ENTRY _ZTV6S467C8[];
extern Class_Descriptor cd_S467C5;
extern VTBL_ENTRY _ZTI6S467C5[];
extern  VTBL_ENTRY _ZTV6S467C5[];
extern Class_Descriptor cd_S468C7;
extern VTBL_ENTRY _ZTI6S468C7[];
extern  VTBL_ENTRY _ZTV6S468C7[];
extern Class_Descriptor cd_S467C4;
extern VTBL_ENTRY _ZTI6S467C4[];
extern  VTBL_ENTRY _ZTV6S467C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C4[];
extern Class_Descriptor cd_S467C15;
extern VTBL_ENTRY _ZTI7S467C15[];
extern  VTBL_ENTRY _ZTV7S467C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S467C15[];
extern Class_Descriptor cd_S467C16;
extern VTBL_ENTRY _ZTI7S467C16[];
static Base_Class bases_S467C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S467C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(372688,244540), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S468C7,    ABISELECT(296,200), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(378928,248616), //bcp->offset
    47, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S467C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(7296,4768), //bcp->offset
    19, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(7744,5084), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C6,    ABISELECT(7824,5128), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(379376,248932), //bcp->offset
    53, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S467C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(14672,9612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(14968,9812), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(14672,9612), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S467C9,    ABISELECT(379680,249132), //bcp->offset
    59, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S467C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S468C7,    ABISELECT(381120,250132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C8,    ABISELECT(381200,250176), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C5,    ABISELECT(381648,250492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S468C7,    ABISELECT(381944,250692), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S467C4,    ABISELECT(381648,250492), //bcp->offset
    84, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S467C15,    ABISELECT(381120,250132), //bcp->offset
    68, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S467C16,    ABISELECT(61760,40532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S467C1[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C1D1Ev();
extern void _ZN6S467C1D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
extern void _ZN6S467C23v11Ev();
extern void ABISELECT(_ZThn296_N6S467C1D1Ev,_ZThn200_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn296_N6S467C1D0Ev,_ZThn200_N6S467C1D0Ev)();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void ABISELECT(_ZThn7744_N6S467C1D1Ev,_ZThn5084_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn7744_N6S467C1D0Ev,_ZThn5084_N6S467C1D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S467C1D1Ev,_ZThn9612_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn14672_N6S467C1D0Ev,_ZThn9612_N6S467C1D0Ev)();
extern void ABISELECT(_ZThn14968_N6S467C1D1Ev,_ZThn9812_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn14968_N6S467C1D0Ev,_ZThn9812_N6S467C1D0Ev)();
extern void _ZN6S467C62v3Ev();
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void ABISELECT(_ZTv0_n24_N6S467C1D1Ev,_ZTv0_n12_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn379680_N6S467C1D1Ev,_ZThn249132_N6S467C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S467C1D0Ev,_ZTv0_n12_N6S467C1D0Ev)();
extern void ABISELECT(_ZThn379680_N6S467C1D0Ev,_ZThn249132_N6S467C1D0Ev)() __attribute__((weak));
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
extern void ABISELECT(_ZTv0_n40_N6S467C1D1Ev,_ZTv0_n20_N6S467C1D1Ev)();
extern void ABISELECT(_ZThn381120_N6S467C1D1Ev,_ZThn250132_N6S467C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N6S467C1D0Ev,_ZTv0_n20_N6S467C1D0Ev)();
extern void ABISELECT(_ZThn381120_N6S467C1D0Ev,_ZThn250132_N6S467C1D0Ev)() __attribute__((weak));
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZTvn528_n40_N6S467C1D1Ev,_ZTvn360_n20_N6S467C1D1Ev)();
extern void ABISELECT(_ZTvn528_n40_N6S467C1D0Ev,_ZTvn360_n20_N6S467C1D0Ev)();
extern void ABISELECT(_ZTvn824_n40_N6S467C1D1Ev,_ZTvn560_n20_N6S467C1D1Ev)();
extern void ABISELECT(_ZTvn824_n40_N6S467C1D0Ev,_ZTvn560_n20_N6S467C1D0Ev)();
static  VTBL_ENTRY vtc_S467C1[] = {
  ABISELECT(381120,250132),
  ABISELECT(379680,249132),
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C1D1Ev,
  (VTBL_ENTRY)&_ZN6S467C1D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
  (VTBL_ENTRY)&_ZN6S467C23v11Ev,
  ABISELECT(-296,-200),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C1D1Ev,_ZThn200_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N6S467C1D0Ev,_ZThn200_N6S467C1D0Ev),
  ABISELECT(-7296,-4768),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-7744,-5084),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C1D1Ev,_ZThn5084_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7744_N6S467C1D0Ev,_ZThn5084_N6S467C1D0Ev),
  ABISELECT(-7824,-5128),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C1D1Ev,_ZThn9612_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C1D0Ev,_ZThn9612_N6S467C1D0Ev),
  ABISELECT(-14968,-9812),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S467C1D1Ev,_ZThn9812_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14968_N6S467C1D0Ev,_ZThn9812_N6S467C1D0Ev),
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  0,
  0,
  ABISELECT(-379680,-249132),
  ABISELECT(-379680,-249132),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C1D1Ev,_ZTv0_n12_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C1D0Ev,_ZTv0_n12_N6S467C1D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
  ABISELECT(528,360),
  ABISELECT(528,360),
  ABISELECT(528,360),
  ABISELECT(80,44),
  ABISELECT(80,44),
  ABISELECT(-381120,-250132),
  ABISELECT(-2192,-1516),
  ABISELECT(-8432,-5592),
  ABISELECT(-381120,-250132),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6S467C1D1Ev,_ZTv0_n20_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N6S467C1D0Ev,_ZTv0_n20_N6S467C1D0Ev),
  ABISELECT(-381200,-250176),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  ABISELECT(-381648,-250492),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn528_n40_N6S467C1D1Ev,_ZTvn360_n20_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn528_n40_N6S467C1D0Ev,_ZTvn360_n20_N6S467C1D0Ev),
  ABISELECT(-381944,-250692),
  (VTBL_ENTRY)&(_ZTI6S467C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn824_n40_N6S467C1D1Ev,_ZTvn560_n20_N6S467C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn824_n40_N6S467C1D0Ev,_ZTvn560_n20_N6S467C1D0Ev),
};
extern VTBL_ENTRY _ZTV6S467C1[];
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C2D1Ev();
extern void _ZN6S467C2D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
extern void _ZN6S467C23v11Ev();
static  VTBL_ENTRY _tg__ZTV6S467C2__6S467C1[] = {
  ABISELECT(379680,249132),
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C2D1Ev,
  (VTBL_ENTRY)&_ZN6S467C2D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
  (VTBL_ENTRY)&_ZN6S467C23v11Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C3D1Ev();
extern void _ZN6S467C3D0Ev();
extern void _ZN6S467C32v7Ev();
extern void _ZN6S467C32v8Ev();
static  VTBL_ENTRY _tg__ZTV6S467C36S467C2__6S467C1[] = {
  ABISELECT(379376,248932),
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C3D1Ev,
  (VTBL_ENTRY)&_ZN6S467C3D0Ev,
  (VTBL_ENTRY)&_ZN6S467C32v7Ev,
  (VTBL_ENTRY)&_ZN6S467C32v8Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C46S467C36S467C2__6S467C1[] = {
  ABISELECT(378928,248616),
  ABISELECT(372688,244540),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C46S467C36S467C2__6S467C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C46S467C36S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C36S467C2__6S467C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C36S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__A1__6S467C36S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S467C3[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C46S467C2__A1__6S467C1[] = {
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C46S467C2__A1__6S467C1[] = {
  0,
  ABISELECT(-358016,-234928),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C46S467C2__A1__6S467C1[] = {
  0,
  0,
  ABISELECT(-364256,-239004),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C2__6S467C1[] = {
  0,
  ABISELECT(-372688,-244540),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-378928,-248616),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
static  VTBL_ENTRY _tg__ZTV6S467C5__A1__6S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-379376,-248932),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn14672_N6S467C2D1Ev,_ZThn9612_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn14672_N6S467C2D0Ev,_ZThn9612_N6S467C2D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__A1__6S467C2__6S467C1[] = {
  ABISELECT(364256,239004),
  ABISELECT(358016,234928),
  ABISELECT(-14672,-9612),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C2D1Ev,_ZThn9612_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn14672_N6S467C2D0Ev,_ZThn9612_N6S467C2D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev)();
extern void ABISELECT(_ZThn379680_N6S467C2D1Ev,_ZThn249132_N6S467C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev)();
extern void ABISELECT(_ZThn379680_N6S467C2D0Ev,_ZThn249132_N6S467C2D0Ev)() __attribute__((weak));
extern void _ZN6S467C92v9Ev();
extern void _ZN6S467C93v10Ev();
static  VTBL_ENTRY _tg__ZTV6S467C9__6S467C2__6S467C1[] = {
  0,
  0,
  ABISELECT(-379680,-249132),
  ABISELECT(-379680,-249132),
  (VTBL_ENTRY)&(_ZTI6S467C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev),
  (VTBL_ENTRY)&_ZN6S467C92v9Ev,
  (VTBL_ENTRY)&_ZN6S467C93v10Ev,
};
extern void _ZN7S467C15D1Ev();
extern void _ZN7S467C15D0Ev();
static  VTBL_ENTRY _tg__ZTV7S467C15__6S467C1[] = {
  ABISELECT(-2192,-1516),
  ABISELECT(-8432,-5592),
  0,
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN7S467C15D1Ev,
  (VTBL_ENTRY)&_ZN7S467C15D0Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void _ZN6S467C4D1Ev();
extern void _ZN6S467C4D0Ev();
static  VTBL_ENTRY _tg__ZTV6S467C47S467C15__A2__6S467C1[] = {
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  0,
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&_ZN6S467C4D1Ev,
  (VTBL_ENTRY)&_ZN6S467C4D0Ev,
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__6S467C47S467C15__A2__6S467C1[] = {
  0,
  ABISELECT(8960,5952),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__6S467C47S467C15__A2__6S467C1[] = {
  0,
  0,
  ABISELECT(2720,1876),
  (VTBL_ENTRY)&(_ZTI6S467C4[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
extern void _ZN6S467C52v1Ev();
extern void _ZN6S467C52v2Ev();
extern void _ZN6S467C42v6Ev();
extern void ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev)();
extern void ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV6S467C4__7S467C15__6S467C1[] = {
  ABISELECT(-2720,-1876),
  ABISELECT(-8960,-5952),
  ABISELECT(-528,-360),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C52v1Ev,
  (VTBL_ENTRY)&_ZN6S467C52v2Ev,
  (VTBL_ENTRY)&_ZN6S467C42v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D1Ev,_ZThn360_N7S467C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn528_N7S467C15D0Ev,_ZThn360_N7S467C15D0Ev),
};
extern void _ZN6S467C62v3Ev();
static  VTBL_ENTRY _tg__ZTV6S467C6__7S467C15__6S467C1[] = {
  0,
  ABISELECT(8432,5592),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C62v3Ev,
};
extern void _ZN6S467C82v4Ev();
extern void _ZN6S467C82v5Ev();
static  VTBL_ENTRY _tg__ZTV6S467C8__A1__7S467C15__6S467C1[] = {
  0,
  0,
  ABISELECT(2192,1516),
  (VTBL_ENTRY)&(_ZTI7S467C15[0]),
  (VTBL_ENTRY)&_ZN6S467C82v4Ev,
  (VTBL_ENTRY)&_ZN6S467C82v5Ev,
};
static  VTT_ENTRY vtt_S467C1[] = {
  {&(_ZTV6S467C1[7]),  7,97},
  {&(_tg__ZTV6S467C2__6S467C1[6]),  6,14},
  {&(_tg__ZTV6S467C36S467C2__6S467C1[5]),  5,12},
  {&(_tg__ZTV6S467C46S467C36S467C2__6S467C1[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C46S467C36S467C2__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C46S467C36S467C2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C6__6S467C36S467C2__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C36S467C2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C5__A1__6S467C36S467C2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C46S467C2__A1__6S467C1[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C46S467C2__A1__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C46S467C2__A1__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C6__6S467C2__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C5__A1__6S467C2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C4__A1__6S467C2__6S467C1[4]),  4,9},
  {&(_tg__ZTV6S467C9__6S467C2__6S467C1[5]),  5,9},
  {&(_ZTV6S467C1[46]),  46,97},
  {&(_ZTV6S467C1[51]),  51,97},
  {&(_ZTV6S467C1[57]),  57,97},
  {&(_ZTV6S467C1[34]),  34,97},
  {&(_ZTV6S467C1[64]),  64,97},
  {&(_ZTV6S467C1[78]),  78,97},
  {&(_ZTV6S467C1[82]),  82,97},
  {&(_ZTV6S467C1[88]),  88,97},
  {&(_ZTV6S467C1[95]),  95,97},
  {&(_tg__ZTV7S467C15__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C47S467C15__A2__6S467C1[4]),  4,9},
  {&(_tg__ZTV6S467C6__6S467C47S467C15__A2__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__6S467C47S467C15__A2__6S467C1[4]),  4,6},
  {&(_tg__ZTV6S467C4__7S467C15__6S467C1[4]),  4,9},
  {&(_tg__ZTV6S467C6__7S467C15__6S467C1[3]),  3,4},
  {&(_tg__ZTV6S467C8__A1__7S467C15__6S467C1[4]),  4,6},
};
extern VTBL_ENTRY _ZTI6S467C1[];
extern  VTBL_ENTRY _ZTV6S467C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT6S467C1[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C2D0Ev,_ZTv0_n12_N6S467C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S467C2D0Ev,_ZThn249132_N6S467C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C2D1Ev,_ZTv0_n12_N6S467C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S467C2D1Ev,_ZThn249132_N6S467C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6S467C1D0Ev,_ZTv0_n20_N6S467C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn381120_N6S467C1D0Ev,_ZThn250132_N6S467C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N6S467C1D1Ev,_ZTv0_n20_N6S467C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn381120_N6S467C1D1Ev,_ZThn250132_N6S467C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C1D0Ev,_ZTv0_n12_N6S467C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S467C1D0Ev,_ZThn249132_N6S467C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N6S467C1D1Ev,_ZTv0_n12_N6S467C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn379680_N6S467C1D1Ev,_ZThn249132_N6S467C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S467C1 = {  "S467C1", // class name
  bases_S467C1, 22,
  &(vtc_S467C1[0]), // expected_vtbl_contents
  &(vtt_S467C1[0]), // expected_vtt_contents
  ABISELECT(418448,274640), // object size
  NSPAIRA(_ZTI6S467C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S467C1),97, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT6S467C1),33, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C3  {
  long double s7394c3f0[2];
  char s7394c3f1[8];
  void  mf7394c3(); // _ZN7S7394C38mf7394c3Ev
};
//SIG(-1 S7394C3) C1{ m FD[2] Fc[8]}


void  S7394C3 ::mf7394c3(){}

static void Test_S7394C3()
{
  {
    init_simple_test("S7394C3");
    S7394C3 lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S7394C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C3)");
    check_field_offset(lv, s7394c3f0, 0, "S7394C3.s7394c3f0");
    check_field_offset(lv, s7394c3f1, ABISELECT(32,24), "S7394C3.s7394c3f1");
  }
}
static Arrange_To_Call_Me vS7394C3(Test_S7394C3, "S7394C3", ABISELECT(48,32));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S7394C3[];
VTBL_ENTRY *P__ZTI7S7394C3 = _ZTI7S7394C3; 
Class_Descriptor cd_S7394C3 = {  "S7394C3", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S7394C3),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C2  : virtual S7394C3 {
  __tsi64 s7394c2f0[4];
  ::S7394C3 s7394c2f1;
  int s7394c2f2;
  ::S7394C3 s7394c2f3;
  __tsi64 s7394c2f4;
  void *s7394c2f5;
  ::S7394C3 s7394c2f6;
  void *s7394c2f7[4];
  ~S7394C2(); // tgen
  S7394C2(); // tgen
};
//SIG(-1 S7394C2) C1{ VBC2{ m FD[2] Fc[8]} FL[4] FC2 Fi FC2 FL Fp FC2 Fp[4]}


S7394C2 ::~S7394C2(){ note_dtor("S7394C2", this);} // tgen
S7394C2 ::S7394C2(){ note_ctor("S7394C2", this);} // tgen

static void Test_S7394C2()
{
  extern Class_Descriptor cd_S7394C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,50)];
    init_test(&cd_S7394C2, buf);
    S7394C2 *dp, &lv = *(dp=new (buf) S7394C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,196), "sizeof(S7394C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C2)");
    check_base_class_offset(lv, (S7394C3*), ABISELECT(256,164), "S7394C2");
    check_field_offset(lv, s7394c2f0, ABISELECT(8,4), "S7394C2.s7394c2f0");
    check_field_offset(lv, s7394c2f1, ABISELECT(48,36), "S7394C2.s7394c2f1");
    check_field_offset(lv, s7394c2f2, ABISELECT(96,68), "S7394C2.s7394c2f2");
    check_field_offset(lv, s7394c2f3, ABISELECT(112,72), "S7394C2.s7394c2f3");
    check_field_offset(lv, s7394c2f4, ABISELECT(160,104), "S7394C2.s7394c2f4");
    check_field_offset(lv, s7394c2f5, ABISELECT(168,112), "S7394C2.s7394c2f5");
    check_field_offset(lv, s7394c2f6, ABISELECT(176,116), "S7394C2.s7394c2f6");
    check_field_offset(lv, s7394c2f7, ABISELECT(224,148), "S7394C2.s7394c2f7");
    test_class_info(&lv, &cd_S7394C2);
    dp->~S7394C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C2(Test_S7394C2, "S7394C2", ABISELECT(304,196));

#else // __cplusplus

extern void _ZN7S7394C2C1Ev();
extern void _ZN7S7394C2D1Ev();
Name_Map name_map_S7394C2[] = {
  NSPAIR(_ZN7S7394C2C1Ev),
  NSPAIR(_ZN7S7394C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
static Base_Class bases_S7394C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(256,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7394C2[];
static  VTBL_ENTRY vtc_S7394C2[] = {
  ABISELECT(256,164),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern VTBL_ENTRY _ZTV7S7394C2[];
static  VTT_ENTRY vtt_S7394C2[] = {
  {&(_ZTV7S7394C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
Class_Descriptor cd_S7394C2 = {  "S7394C2", // class name
  bases_S7394C2, 1,
  &(vtc_S7394C2[0]), // expected_vtbl_contents
  &(vtt_S7394C2[0]), // expected_vtt_contents
  ABISELECT(304,196), // object size
  NSPAIRA(_ZTI7S7394C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7394C2),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7394C2),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S7394C6  {
  long double s7394c6f0;
  __tsi64 s7394c6f1;
  long double s7394c6f2;
  __tsi64 s7394c6f3;
  int s7394c6f4;
  void  mf7394c6(); // _ZN7S7394C68mf7394c6Ev
};
//SIG(1 S7394C6) U1{ m FD FL FD FL Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S7394C5  {
  ::S7394C2 s7394c5f0;
  void *s7394c5f1;
  __tsi64 s7394c5f2;
  int s7394c5f3;
  void *s7394c5f4;
  ::S7394C6 s7394c5f5[8];
  char s7394c5f6;
  void *s7394c5f7;
  virtual  ~S7394C5(); // _ZN7S7394C5D1Ev
  virtual void  v1(); // _ZN7S7394C52v1Ev
  virtual void  v2(); // _ZN7S7394C52v2Ev
  S7394C5(); // tgen
};
//SIG(-1 S7394C5) C1{ vd v1 v2 FC2{ VBC3{ m FD[2] Fc[8]} FL[4] FC3 Fi FC3 FL Fp FC3 Fp[4]} Fp FL Fi Fp FU4{ m FD FL FD FL Fi}[8] Fc Fp}


 S7394C5 ::~S7394C5(){ note_dtor("S7394C5", this);}
void  S7394C5 ::v1(){vfunc_called(this, "_ZN7S7394C52v1Ev");}
void  S7394C5 ::v2(){vfunc_called(this, "_ZN7S7394C52v2Ev");}
S7394C5 ::S7394C5(){ note_ctor("S7394C5", this);} // tgen

static void Test_S7394C5()
{
  extern Class_Descriptor cd_S7394C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(32,82)];
    init_test(&cd_S7394C5, buf);
    S7394C5 *dp, &lv = *(dp=new (buf) S7394C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,324), "sizeof(S7394C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C5)");
    check_field_offset(lv, s7394c5f0, ABISELECT(16,4), "S7394C5.s7394c5f0");
    check_field_offset(lv, s7394c5f1, ABISELECT(320,200), "S7394C5.s7394c5f1");
    check_field_offset(lv, s7394c5f2, ABISELECT(328,204), "S7394C5.s7394c5f2");
    check_field_offset(lv, s7394c5f3, ABISELECT(336,212), "S7394C5.s7394c5f3");
    check_field_offset(lv, s7394c5f4, ABISELECT(344,216), "S7394C5.s7394c5f4");
    check_field_offset(lv, s7394c5f5, ABISELECT(352,220), "S7394C5.s7394c5f5");
    check_field_offset(lv, s7394c5f6, ABISELECT(480,316), "S7394C5.s7394c5f6");
    check_field_offset(lv, s7394c5f7, ABISELECT(488,320), "S7394C5.s7394c5f7");
    test_class_info(&lv, &cd_S7394C5);
    dp->~S7394C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C5(Test_S7394C5, "S7394C5", ABISELECT(496,324));

#else // __cplusplus

extern void _ZN7S7394C5C1Ev();
extern void _ZN7S7394C5D1Ev();
Name_Map name_map_S7394C5[] = {
  NSPAIR(_ZN7S7394C5C1Ev),
  NSPAIR(_ZN7S7394C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7394C5[];
extern void _ZN7S7394C5D1Ev();
extern void _ZN7S7394C5D0Ev();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C5[0]),
  (VTBL_ENTRY)&_ZN7S7394C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C5D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
Class_Descriptor cd_S7394C5 = {  "S7394C5", // class name
  0,0,//no base classes
  &(vtc_S7394C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(496,324), // object size
  NSPAIRA(_ZTI7S7394C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7394C5),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C8  : S7394C3 , S7394C2 , virtual S7394C5 {
  void *s7394c8f0[4];
  __tsi64 s7394c8f1;
  void *s7394c8f2[3];
  ::S7394C6 s7394c8f3;
  ::S7394C5 s7394c8f4;
  long double s7394c8f5;
  short  :0;
  ::S7394C3 s7394c8f7;
  long double s7394c8f8;
  void *s7394c8f9;
  virtual  ~S7394C8(); // _ZN7S7394C8D2Ev
  virtual void  v3(); // _ZN7S7394C82v3Ev
  S7394C8(); // tgen
};
//SIG(-1 S7394C8) C1{ BC2{ m FD[2] Fc[8]} BC3{ VBC2 FL[4] FC2 Fi FC2 FL Fp FC2 Fp[4]} VBC4{ vd v2 v3 FC3 Fp FL Fi Fp FU5{ m FD FL FD FL Fi}[8] Fc Fp} vd v1 Fp[4] FL Fp[3] FU5 FC4 FD Fs:0 FC2 FD Fp}


 S7394C8 ::~S7394C8(){ note_dtor("S7394C8", this);}
void  S7394C8 ::v3(){vfunc_called(this, "_ZN7S7394C82v3Ev");}
S7394C8 ::S7394C8(){ note_ctor("S7394C8", this);} // tgen

static void Test_S7394C8()
{
  extern Class_Descriptor cd_S7394C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(96,247)];
    init_test(&cd_S7394C8, buf);
    S7394C8 *dp, &lv = *(dp=new (buf) S7394C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1520,984), "sizeof(S7394C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C8)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*), ABISELECT(256,164), "S7394C8");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*), ABISELECT(976,628), "S7394C8");
    check_base_class_offset(lv, (S7394C2*), 0, "S7394C8");
    check_base_class_offset(lv, (S7394C5*), ABISELECT(1024,660), "S7394C8");
    check_field_offset(lv, s7394c8f0, ABISELECT(304,196), "S7394C8.s7394c8f0");
    check_field_offset(lv, s7394c8f1, ABISELECT(336,212), "S7394C8.s7394c8f1");
    check_field_offset(lv, s7394c8f2, ABISELECT(344,220), "S7394C8.s7394c8f2");
    check_field_offset(lv, s7394c8f3, ABISELECT(368,232), "S7394C8.s7394c8f3");
    check_field_offset(lv, s7394c8f4, ABISELECT(384,244), "S7394C8.s7394c8f4");
    check_field_offset(lv, s7394c8f5, ABISELECT(880,568), "S7394C8.s7394c8f5");
    check_field_offset(lv, s7394c8f7, ABISELECT(896,580), "S7394C8.s7394c8f7");
    check_field_offset(lv, s7394c8f8, ABISELECT(944,612), "S7394C8.s7394c8f8");
    check_field_offset(lv, s7394c8f9, ABISELECT(960,624), "S7394C8.s7394c8f9");
    test_class_info(&lv, &cd_S7394C8);
    dp->~S7394C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C8(Test_S7394C8, "S7394C8", ABISELECT(1520,984));

#else // __cplusplus

extern void _ZN7S7394C8C1Ev();
extern void _ZN7S7394C8D2Ev();
Name_Map name_map_S7394C8[] = {
  NSPAIR(_ZN7S7394C8C1Ev),
  NSPAIR(_ZN7S7394C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
static Base_Class bases_S7394C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(256,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C3,    ABISELECT(976,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C5,    ABISELECT(1024,660), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7394C8[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C8[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S7394C8[];
static  VTBL_ENTRY _tg__ZTV7S7394C2__7S7394C8[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
static  VTT_ENTRY vtt_S7394C8[] = {
  {&(_ZTV7S7394C8[4]),  4,16},
  {&(_tg__ZTV7S7394C2__7S7394C8[3]),  3,3},
  {&(_ZTV7S7394C8[12]),  12,16},
};
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C8 = {  "S7394C8", // class name
  bases_S7394C8, 4,
  &(vtc_S7394C8[0]), // expected_vtbl_contents
  &(vtt_S7394C8[0]), // expected_vtt_contents
  ABISELECT(1520,984), // object size
  NSPAIRA(_ZTI7S7394C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7394C8),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7394C8),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C9  {
  __tsi64 s7394c9f0[4];
  unsigned char s7394c9f1:1;
  __tsi64 s7394c9f2[2];
  __tsi64 s7394c9f3:4;
  void  mf7394c9(); // _ZN7S7394C98mf7394c9Ev
};
//SIG(-1 S7394C9) C1{ m FL[4] Fc:1 FL[2] FL:4}


void  S7394C9 ::mf7394c9(){}

static void Test_S7394C9()
{
  {
    init_simple_test("S7394C9");
    static S7394C9 lv;
    check2(sizeof(lv), ABISELECT(64,56), "sizeof(S7394C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7394C9)");
    check_field_offset(lv, s7394c9f0, 0, "S7394C9.s7394c9f0");
    set_bf_and_test(lv, s7394c9f1, 32, 0, 1, 1, "S7394C9");
    check_field_offset(lv, s7394c9f2, ABISELECT(40,36), "S7394C9.s7394c9f2");
    set_bf_and_test(lv, s7394c9f3, ABISELECT(56,52), 0, 4, 1, "S7394C9");
    set_bf_and_test(lv, s7394c9f3, ABISELECT(56,52), 0, 4, hide_sll(1LL<<3), "S7394C9");
  }
}
static Arrange_To_Call_Me vS7394C9(Test_S7394C9, "S7394C9", ABISELECT(64,56));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S7394C9[];
VTBL_ENTRY *P__ZTI7S7394C9 = _ZTI7S7394C9; 
Class_Descriptor cd_S7394C9 = {  "S7394C9", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(64,56), // object size
  NSPAIRA(_ZTI7S7394C9),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C7  : virtual S7394C8 , S7394C9 {
  long double s7394c7f0;
  __tsi64 s7394c7f1;
  __tsi64 s7394c7f2:13;
  virtual  ~S7394C7(); // _ZN7S7394C7D2Ev
  S7394C7(); // tgen
};
//SIG(-1 S7394C7) C1{ VBC2{ BC3{ m FD[2] Fc[8]} BC4{ VBC3 FL[4] FC3 Fi FC3 FL Fp FC3 Fp[4]} VBC5{ vd v1 v2 FC4 Fp FL Fi Fp FU6{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU6 FC5 FD Fs:0 FC3 FD Fp} BC7{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13}


 S7394C7 ::~S7394C7(){ note_dtor("S7394C7", this);}
S7394C7 ::S7394C7(){ note_ctor("S7394C7", this);} // tgen

static void Test_S7394C7()
{
  extern Class_Descriptor cd_S7394C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(103,268)];
    init_test(&cd_S7394C7, buf);
    S7394C7 *dp, &lv = *(dp=new (buf) S7394C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1632,1068), "sizeof(S7394C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C7)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(368,248), "S7394C7");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(1088,712), "S7394C7");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(112,84), "S7394C7");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(1136,744), "S7394C7");
    check_base_class_offset(lv, (S7394C8*), ABISELECT(112,84), "S7394C7");
    check_base_class_offset(lv, (S7394C9*), ABISELECT(8,4), "S7394C7");
    check_field_offset(lv, s7394c7f0, ABISELECT(80,60), "S7394C7.s7394c7f0");
    check_field_offset(lv, s7394c7f1, ABISELECT(96,72), "S7394C7.s7394c7f1");
    set_bf_and_test(lv, s7394c7f2, ABISELECT(104,80), 0, 13, 1, "S7394C7");
    set_bf_and_test(lv, s7394c7f2, ABISELECT(104,80), 0, 13, hide_sll(1LL<<12), "S7394C7");
    test_class_info(&lv, &cd_S7394C7);
    dp->~S7394C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C7(Test_S7394C7, "S7394C7", ABISELECT(1632,1068));

#else // __cplusplus

extern void _ZN7S7394C7C1Ev();
extern void _ZN7S7394C7D2Ev();
Name_Map name_map_S7394C7[] = {
  NSPAIR(_ZN7S7394C7C1Ev),
  NSPAIR(_ZN7S7394C7D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
static Base_Class bases_S7394C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(368,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(1088,712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(112,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(1136,744), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(112,84), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C9,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7394C7[];
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C7[] = {
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
  0,
  ABISELECT(-112,-84),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-1136,-744),
  ABISELECT(-1136,-744),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S7394C7[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__7S7394C7[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__7S7394C7[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C7[] = {
  {&(_ZTV7S7394C7[5]),  5,25},
  {&(_ZTV7S7394C7[13]),  13,25},
  {&(_ZTV7S7394C7[21]),  21,25},
  {&(_tg__ZTV7S7394C8__7S7394C7[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__7S7394C7[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__7S7394C7[5]),  5,9},
};
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C7 = {  "S7394C7", // class name
  bases_S7394C7, 6,
  &(vtc_S7394C7[0]), // expected_vtbl_contents
  &(vtt_S7394C7[0]), // expected_vtt_contents
  ABISELECT(1632,1068), // object size
  NSPAIRA(_ZTI7S7394C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7394C7),25, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7394C7),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C11  : virtual S7394C8 {
  short s7394c11f0;
  __tsi64 s7394c11f1;
  ::S7394C5 s7394c11f2;
  ::S7394C3 s7394c11f3[5];
  ::S7394C8 s7394c11f4[8];
  ::S7394C2 s7394c11f5[5];
  ::S7394C2 s7394c11f6;
  void *s7394c11f7;
  __tsi64 s7394c11f8;
  __tsi64 s7394c11f9;
  int s7394c11f10[2];
  virtual  ~S7394C11(); // _ZN8S7394C11D2Ev
  virtual void  v6(); // _ZN8S7394C112v6Ev
  S7394C11(); // tgen
};
//SIG(-1 S7394C11) C1{ VBC2{ BC3{ m FD[2] Fc[8]} BC4{ VBC3 FL[4] FC3 Fi FC3 FL Fp FC3 Fp[4]} VBC5{ vd v2 v3 FC4 Fp FL Fi Fp FU6{ m FD FL FD FL Fi}[8] Fc Fp} vd v4 Fp[4] FL Fp[3] FU6 FC5 FD Fs:0 FC3 FD Fp} vd v1 Fs FL FC5 FC3[5] FC2[8] FC4[5] FC4 Fp FL FL Fi[2]}


 S7394C11 ::~S7394C11(){ note_dtor("S7394C11", this);}
void  S7394C11 ::v6(){vfunc_called(this, "_ZN8S7394C112v6Ev");}
S7394C11 ::S7394C11(){ note_ctor("S7394C11", this);} // tgen

static void Test_S7394C11()
{
  extern Class_Descriptor cd_S7394C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1020,2641)];
    init_test(&cd_S7394C11, buf);
    S7394C11 *dp, &lv = *(dp=new (buf) S7394C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16304,10560), "sizeof(S7394C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C11)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(15040,9740), "S7394C11");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(15760,10204), "S7394C11");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(14784,9576), "S7394C11");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(15808,10236), "S7394C11");
    check_base_class_offset(lv, (S7394C8*), ABISELECT(14784,9576), "S7394C11");
    check_field_offset(lv, s7394c11f0, ABISELECT(8,4), "S7394C11.s7394c11f0");
    check_field_offset(lv, s7394c11f1, ABISELECT(16,8), "S7394C11.s7394c11f1");
    check_field_offset(lv, s7394c11f2, ABISELECT(32,16), "S7394C11.s7394c11f2");
    check_field_offset(lv, s7394c11f3, ABISELECT(528,340), "S7394C11.s7394c11f3");
    check_field_offset(lv, s7394c11f4, ABISELECT(768,500), "S7394C11.s7394c11f4");
    check_field_offset(lv, s7394c11f5, ABISELECT(12928,8372), "S7394C11.s7394c11f5");
    check_field_offset(lv, s7394c11f6, ABISELECT(14448,9352), "S7394C11.s7394c11f6");
    check_field_offset(lv, s7394c11f7, ABISELECT(14752,9548), "S7394C11.s7394c11f7");
    check_field_offset(lv, s7394c11f8, ABISELECT(14760,9552), "S7394C11.s7394c11f8");
    check_field_offset(lv, s7394c11f9, ABISELECT(14768,9560), "S7394C11.s7394c11f9");
    check_field_offset(lv, s7394c11f10, ABISELECT(14776,9568), "S7394C11.s7394c11f10");
    test_class_info(&lv, &cd_S7394C11);
    dp->~S7394C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C11(Test_S7394C11, "S7394C11", ABISELECT(16304,10560));

#else // __cplusplus

extern void _ZN8S7394C11C1Ev();
extern void _ZN8S7394C11D2Ev();
Name_Map name_map_S7394C11[] = {
  NSPAIR(_ZN8S7394C11C1Ev),
  NSPAIR(_ZN8S7394C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
static Base_Class bases_S7394C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(15040,9740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(15760,10204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(14784,9576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(15808,10236), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(14784,9576), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C11[];
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C11[] = {
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  0,
  ABISELECT(-14784,-9576),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-14784,-9576),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-15808,-10236),
  ABISELECT(-15808,-10236),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV8S7394C11[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C11[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C11[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C11[] = {
  {&(_ZTV8S7394C11[5]),  5,26},
  {&(_ZTV8S7394C11[14]),  14,26},
  {&(_ZTV8S7394C11[22]),  22,26},
  {&(_tg__ZTV7S7394C8__8S7394C11[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C11[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C11[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C11 = {  "S7394C11", // class name
  bases_S7394C11, 5,
  &(vtc_S7394C11[0]), // expected_vtbl_contents
  &(vtt_S7394C11[0]), // expected_vtt_contents
  ABISELECT(16304,10560), // object size
  NSPAIRA(_ZTI8S7394C11),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7394C11),26, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C11),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C10  : virtual S7394C7 , S7394C8 , virtual S7394C11 , virtual S7394C2 {
  __tsi64 s7394c10f0;
  long double s7394c10f1;
  void *s7394c10f2[6];
  virtual  ~S7394C10(); // _ZN8S7394C10D2Ev
  S7394C10(); // tgen
};
//SIG(-1 S7394C10) C1{ VBC2{ VBC3{ BC4{ m FD[2] Fc[8]} BC5{ VBC4 FL[4] FC4 Fi FC4 FL Fp FC4 Fp[4]} VBC6{ vd v1 v2 FC5 Fp FL Fi Fp FU7{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU7 FC6 FD Fs:0 FC4 FD Fp} BC8{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} BC3 VBC9{ VBC3 vd v4 Fs FL FC6 FC4[5] FC3[8] FC5[5] FC5 Fp FL FL Fi[2]} VBC5 vd FL FD Fp[6]}


 S7394C10 ::~S7394C10(){ note_dtor("S7394C10", this);}
S7394C10 ::S7394C10(){ note_ctor("S7394C10", this);} // tgen

static void Test_S7394C10()
{
  extern Class_Descriptor cd_S7394C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1108,2871)];
    init_test(&cd_S7394C10, buf);
    S7394C10 *dp, &lv = *(dp=new (buf) S7394C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17712,11480), "sizeof(S7394C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C10)");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(1408,920), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(2128,1384), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(2128,1384), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*), ABISELECT(2128,1384), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(1152,756), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(2176,1416), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(2176,1416), "S7394C10");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(1152,756), "S7394C10");
    check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(1152,756), "S7394C10");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(1048,676), "S7394C10");
    check_base_class_offset(lv, (S7394C7*), ABISELECT(1040,672), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(256,164), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), 0, "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C8*), 0, "S7394C10");
    check_base_class_offset(lv, (S7394C11*), ABISELECT(2672,1740), "S7394C10");
    /*is_ambiguous_... S7394C10::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C2*), ABISELECT(17456,11316), "S7394C10");
    check_field_offset(lv, s7394c10f0, ABISELECT(968,628), "S7394C10.s7394c10f0");
    check_field_offset(lv, s7394c10f1, ABISELECT(976,636), "S7394C10.s7394c10f1");
    check_field_offset(lv, s7394c10f2, ABISELECT(992,648), "S7394C10.s7394c10f2");
    test_class_info(&lv, &cd_S7394C10);
    dp->~S7394C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C10(Test_S7394C10, "S7394C10", ABISELECT(17712,11480));

#else // __cplusplus

extern void _ZN8S7394C10C1Ev();
extern void _ZN8S7394C10D2Ev();
Name_Map name_map_S7394C10[] = {
  NSPAIR(_ZN8S7394C10C1Ev),
  NSPAIR(_ZN8S7394C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
static Base_Class bases_S7394C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(1408,920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(2128,1384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(1152,756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(2176,1416), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(1152,756), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(1048,676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(1040,672), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C3,    ABISELECT(256,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7394C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7394C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C11,    ABISELECT(2672,1740), //bcp->offset
    37, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C2,    ABISELECT(17456,11316), //bcp->offset
    47, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C10[];
extern void _ZN8S7394C10D1Ev();
extern void _ZN8S7394C10D0Ev();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn1040_N8S7394C10D1Ev,_ZThn672_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn1040_N8S7394C10D0Ev,_ZThn672_N8S7394C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn1152_N8S7394C10D1Ev,_ZThn756_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn1152_N8S7394C10D0Ev,_ZThn756_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn2176_N8S7394C10D1Ev,_ZThn1416_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn2176_N8S7394C10D0Ev,_ZThn1416_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn2672_N8S7394C10D1Ev,_ZThn1740_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn2672_N8S7394C10D0Ev,_ZThn1740_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY vtc_S7394C10[] = {
  ABISELECT(17456,11316),
  ABISELECT(2672,1740),
  ABISELECT(1152,756),
  ABISELECT(1040,672),
  ABISELECT(2176,1416),
  ABISELECT(2128,1384),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&_ZN8S7394C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C10D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(-1040,-672),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-1040,-672),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
  0,
  ABISELECT(-1152,-756),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-1152,-756),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-2176,-1416),
  ABISELECT(-2176,-1416),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  0,
  ABISELECT(-2672,-1740),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  ABISELECT(-2672,-1740),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  ABISELECT(-15328,-9932),
  ABISELECT(-17456,-11316),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
};
extern VTBL_ENTRY _ZTV8S7394C10[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__A__8S7394C10[] = {
  ABISELECT(2176,1416),
  ABISELECT(2128,1384),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__A1__8S7394C10[] = {
  ABISELECT(2128,1384),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn2176_N7S7394C8D1Ev,_ZThn1416_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn2176_N7S7394C8D0Ev,_ZThn1416_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__A__8S7394C10[] = {
  0,
  0,
  ABISELECT(-2176,-1416),
  ABISELECT(-2176,-1416),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C10[] = {
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__8S7394C10[] = {
  0,
  ABISELECT(-112,-84),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__8S7394C10[] = {
  0,
  0,
  ABISELECT(-1136,-744),
  ABISELECT(-1136,-744),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C10[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C10[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C10[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C10[] = {
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C10[] = {
  0,
  ABISELECT(1520,984),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(1520,984),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C10[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C10[] = {
  ABISELECT(-15328,-9932),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
static  VTT_ENTRY vtt_S7394C10[] = {
  {&(_ZTV8S7394C10[8]),  8,50},
  {&(_tg__ZTV7S7394C8__A__8S7394C10[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__A1__8S7394C10[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__A__8S7394C10[5]),  5,9},
  {&(_ZTV8S7394C10[17]),  17,50},
  {&(_ZTV8S7394C10[25]),  25,50},
  {&(_ZTV8S7394C10[33]),  33,50},
  {&(_ZTV8S7394C10[44]),  44,50},
  {&(_ZTV8S7394C10[50]),  50,50},
  {&(_tg__ZTV7S7394C7__8S7394C10[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__8S7394C10[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__8S7394C10[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C10[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C10[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C10[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C10[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C10[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C10[5]),  5,9},
  {&(_tg__ZTV7S7394C2__A2__8S7394C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S7394C10[];
extern  VTBL_ENTRY _ZTV8S7394C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C10[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S7394C8D0Ev,_ZThn1416_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S7394C8D1Ev,_ZThn1416_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S7394C10D0Ev,_ZThn1416_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S7394C10D1Ev,_ZThn1416_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S7394C10D0Ev,_ZThn756_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S7394C10D1Ev,_ZThn756_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2672_N8S7394C10D0Ev,_ZThn1740_N8S7394C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S7394C10D0Ev,_ZThn672_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2672_N8S7394C10D1Ev,_ZThn1740_N8S7394C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S7394C10D1Ev,_ZThn672_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C10 = {  "S7394C10", // class name
  bases_S7394C10, 12,
  &(vtc_S7394C10[0]), // expected_vtbl_contents
  &(vtt_S7394C10[0]), // expected_vtt_contents
  ABISELECT(17712,11480), // object size
  NSPAIRA(_ZTI8S7394C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7394C10),50, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C10),19, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C4  : S7394C5 , virtual S7394C7 {
  __tsi64 s7394c4f0;
  ::S7394C10 s7394c4f1;
  virtual void  v4(); // _ZN7S7394C42v4Ev
  ~S7394C4(); // tgen
  S7394C4(); // tgen
};
//SIG(-1 S7394C4) C1{ BC2{ vd v2 v3 FC3{ VBC4{ m FD[2] Fc[8]} FL[4] FC4 Fi FC4 FL Fp FC4 Fp[4]} Fp FL Fi Fp FU5{ m FD FL FD FL Fi}[8] Fc Fp} VBC6{ VBC7{ BC4 BC3 VBC2 vd v4 Fp[4] FL Fp[3] FU5 FC2 FD Fs:0 FC4 FD Fp} BC8{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} v1 FL FC9{ VBC6 BC7 VBC10{ VBC7 vd v5 Fs FL FC2 FC4[5] FC7[8] FC3[5] FC3 Fp FL FL Fi[2]} VBC3 vd FL FD Fp[6]}}


void  S7394C4 ::v4(){vfunc_called(this, "_ZN7S7394C42v4Ev");}
S7394C4 ::~S7394C4(){ note_dtor("S7394C4", this);} // tgen
S7394C4 ::S7394C4(){ note_ctor("S7394C4", this);} // tgen

static void Test_S7394C4()
{
  extern Class_Descriptor cd_S7394C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1242,3221)];
    init_test(&cd_S7394C4, buf);
    S7394C4 *dp, &lv = *(dp=new (buf) S7394C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(19856,12880), "sizeof(S7394C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C4)");
    /*is_ambiguous_... S7394C4::S7394C5 */ AMB_check_base_class_offset(lv, (S7394C5*), 0, "S7394C4");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(18592,12060), "S7394C4");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(19312,12524), "S7394C4");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(18336,11896), "S7394C4");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(19360,12556), "S7394C4");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(18336,11896), "S7394C4");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(18232,11816), "S7394C4");
    check_base_class_offset(lv, (S7394C7*), ABISELECT(18224,11812), "S7394C4");
    check_field_offset(lv, s7394c4f0, ABISELECT(496,324), "S7394C4.s7394c4f0");
    check_field_offset(lv, s7394c4f1, ABISELECT(512,332), "S7394C4.s7394c4f1");
    test_class_info(&lv, &cd_S7394C4);
    dp->~S7394C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C4(Test_S7394C4, "S7394C4", ABISELECT(19856,12880));

#else // __cplusplus

extern void _ZN7S7394C4C1Ev();
extern void _ZN7S7394C4D1Ev();
Name_Map name_map_S7394C4[] = {
  NSPAIR(_ZN7S7394C4C1Ev),
  NSPAIR(_ZN7S7394C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
static Base_Class bases_S7394C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C3,    ABISELECT(18592,12060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(19312,12524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(18336,11896), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(19360,12556), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(18336,11896), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(18232,11816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(18224,11812), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7394C4[];
extern void _ZN7S7394C4D1Ev();
extern void _ZN7S7394C4D0Ev();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void _ZN7S7394C42v4Ev();
extern void ABISELECT(_ZTv0_n48_N7S7394C4D1Ev,_ZTv0_n24_N7S7394C4D1Ev)();
extern void ABISELECT(_ZThn18224_N7S7394C4D1Ev,_ZThn11812_N7S7394C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N7S7394C4D0Ev,_ZTv0_n24_N7S7394C4D0Ev)();
extern void ABISELECT(_ZThn18224_N7S7394C4D0Ev,_ZThn11812_N7S7394C4D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C4D1Ev,_ZTv0_n20_N7S7394C4D1Ev)();
extern void ABISELECT(_ZThn18336_N7S7394C4D1Ev,_ZThn11896_N7S7394C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C4D0Ev,_ZTv0_n20_N7S7394C4D0Ev)();
extern void ABISELECT(_ZThn18336_N7S7394C4D0Ev,_ZThn11896_N7S7394C4D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N7S7394C4D1Ev,_ZTv0_n12_N7S7394C4D1Ev)();
extern void ABISELECT(_ZThn19360_N7S7394C4D1Ev,_ZThn12556_N7S7394C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C4D0Ev,_ZTv0_n12_N7S7394C4D0Ev)();
extern void ABISELECT(_ZThn19360_N7S7394C4D0Ev,_ZThn12556_N7S7394C4D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C4[] = {
  ABISELECT(19360,12556),
  ABISELECT(19312,12524),
  ABISELECT(18336,11896),
  ABISELECT(18224,11812),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C4[0]),
  (VTBL_ENTRY)&_ZN7S7394C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C4D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  (VTBL_ENTRY)&_ZN7S7394C42v4Ev,
  ABISELECT(-18224,-11812),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-18224,-11812),
  (VTBL_ENTRY)&(_ZTI7S7394C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7394C4D1Ev,_ZTv0_n24_N7S7394C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N7S7394C4D0Ev,_ZTv0_n24_N7S7394C4D0Ev),
  0,
  ABISELECT(-18336,-11896),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-18336,-11896),
  (VTBL_ENTRY)&(_ZTI7S7394C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C4D1Ev,_ZTv0_n20_N7S7394C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C4D0Ev,_ZTv0_n20_N7S7394C4D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-19360,-12556),
  ABISELECT(-19360,-12556),
  (VTBL_ENTRY)&(_ZTI7S7394C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C4D1Ev,_ZTv0_n12_N7S7394C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C4D0Ev,_ZTv0_n12_N7S7394C4D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV7S7394C4[];
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__7S7394C4[] = {
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__7S7394C4[] = {
  0,
  ABISELECT(-112,-84),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__7S7394C4[] = {
  0,
  0,
  ABISELECT(-1136,-744),
  ABISELECT(-1136,-744),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C4[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__7S7394C4[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__7S7394C4[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C4[] = {
  {&(_ZTV7S7394C4[6]),  6,37},
  {&(_ZTV7S7394C4[17]),  17,37},
  {&(_ZTV7S7394C4[25]),  25,37},
  {&(_ZTV7S7394C4[33]),  33,37},
  {&(_tg__ZTV7S7394C7__7S7394C4[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__7S7394C4[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__7S7394C4[5]),  5,9},
  {&(_tg__ZTV7S7394C8__7S7394C4[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__7S7394C4[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__7S7394C4[5]),  5,9},
};
extern VTBL_ENTRY _ZTI7S7394C4[];
extern  VTBL_ENTRY _ZTV7S7394C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C4[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C4D0Ev,_ZTv0_n12_N7S7394C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19360_N7S7394C4D0Ev,_ZThn12556_N7S7394C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C4D1Ev,_ZTv0_n12_N7S7394C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19360_N7S7394C4D1Ev,_ZThn12556_N7S7394C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C4D0Ev,_ZTv0_n20_N7S7394C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18336_N7S7394C4D0Ev,_ZThn11896_N7S7394C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C4D1Ev,_ZTv0_n20_N7S7394C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18336_N7S7394C4D1Ev,_ZThn11896_N7S7394C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7394C4D0Ev,_ZTv0_n24_N7S7394C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18224_N7S7394C4D0Ev,_ZThn11812_N7S7394C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N7S7394C4D1Ev,_ZTv0_n24_N7S7394C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18224_N7S7394C4D1Ev,_ZThn11812_N7S7394C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C4 = {  "S7394C4", // class name
  bases_S7394C4, 8,
  &(vtc_S7394C4[0]), // expected_vtbl_contents
  &(vtt_S7394C4[0]), // expected_vtt_contents
  ABISELECT(19856,12880), // object size
  NSPAIRA(_ZTI7S7394C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S7394C4),37, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7394C4),10, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C14  : virtual S7394C7 {
  ::S7394C5 s7394c14f0;
  int s7394c14f1;
  int s7394c14f2;
  ::S7394C6 s7394c14f3;
  virtual  ~S7394C14(); // _ZN8S7394C14D2Ev
  virtual void  v5(); // _ZN8S7394C142v5Ev
  S7394C14(); // tgen
};
//SIG(-1 S7394C14) C1{ VBC2{ VBC3{ BC4{ m FD[2] Fc[8]} BC5{ VBC4 FL[4] FC4 Fi FC4 FL Fp FC4 Fp[4]} VBC6{ vd v2 v3 FC5 Fp FL Fi Fp FU7{ m FD FL FD FL Fi}[8] Fc Fp} vd v4 Fp[4] FL Fp[3] FU7 FC6 FD Fs:0 FC4 FD Fp} BC8{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} vd v1 FC6 Fi Fi FU7}


 S7394C14 ::~S7394C14(){ note_dtor("S7394C14", this);}
void  S7394C14 ::v5(){vfunc_called(this, "_ZN8S7394C142v5Ev");}
S7394C14 ::S7394C14(){ note_ctor("S7394C14", this);} // tgen

static void Test_S7394C14()
{
  extern Class_Descriptor cd_S7394C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(137,355)];
    init_test(&cd_S7394C14, buf);
    S7394C14 *dp, &lv = *(dp=new (buf) S7394C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2176,1416), "sizeof(S7394C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C14)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(912,596), "S7394C14");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(1632,1060), "S7394C14");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(656,432), "S7394C14");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(1680,1092), "S7394C14");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(656,432), "S7394C14");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(552,352), "S7394C14");
    check_base_class_offset(lv, (S7394C7*), ABISELECT(544,348), "S7394C14");
    check_field_offset(lv, s7394c14f0, ABISELECT(16,4), "S7394C14.s7394c14f0");
    check_field_offset(lv, s7394c14f1, ABISELECT(512,328), "S7394C14.s7394c14f1");
    check_field_offset(lv, s7394c14f2, ABISELECT(516,332), "S7394C14.s7394c14f2");
    check_field_offset(lv, s7394c14f3, ABISELECT(528,336), "S7394C14.s7394c14f3");
    test_class_info(&lv, &cd_S7394C14);
    dp->~S7394C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C14(Test_S7394C14, "S7394C14", ABISELECT(2176,1416));

#else // __cplusplus

extern void _ZN8S7394C14C1Ev();
extern void _ZN8S7394C14D2Ev();
Name_Map name_map_S7394C14[] = {
  NSPAIR(_ZN8S7394C14C1Ev),
  NSPAIR(_ZN8S7394C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
static Base_Class bases_S7394C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(912,596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(1632,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(656,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(1680,1092), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(656,432), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(552,352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(544,348), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C14[];
extern void _ZN8S7394C14D1Ev();
extern void _ZN8S7394C14D0Ev();
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn544_N8S7394C14D1Ev,_ZThn348_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn544_N8S7394C14D0Ev,_ZThn348_N8S7394C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn656_N8S7394C14D1Ev,_ZThn432_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn656_N8S7394C14D0Ev,_ZThn432_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn1680_N8S7394C14D1Ev,_ZThn1092_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn1680_N8S7394C14D0Ev,_ZThn1092_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C14[] = {
  ABISELECT(1680,1092),
  ABISELECT(1632,1060),
  ABISELECT(656,432),
  ABISELECT(544,348),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&_ZN8S7394C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(-544,-348),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-544,-348),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev),
  0,
  ABISELECT(-656,-432),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-656,-432),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-1680,-1092),
  ABISELECT(-1680,-1092),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV8S7394C14[];
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C14[] = {
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__8S7394C14[] = {
  0,
  ABISELECT(-112,-84),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__8S7394C14[] = {
  0,
  0,
  ABISELECT(-1136,-744),
  ABISELECT(-1136,-744),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C14[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C14[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C14[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C14[] = {
  {&(_ZTV8S7394C14[6]),  6,35},
  {&(_ZTV8S7394C14[15]),  15,35},
  {&(_ZTV8S7394C14[23]),  23,35},
  {&(_ZTV8S7394C14[31]),  31,35},
  {&(_tg__ZTV7S7394C7__8S7394C14[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__8S7394C14[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__8S7394C14[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C14[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C14[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C14[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S7394C14D0Ev,_ZThn1092_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S7394C14D1Ev,_ZThn1092_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S7394C14D0Ev,_ZThn432_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S7394C14D1Ev,_ZThn432_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7394C14D0Ev,_ZThn348_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7394C14D1Ev,_ZThn348_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C14 = {  "S7394C14", // class name
  bases_S7394C14, 7,
  &(vtc_S7394C14[0]), // expected_vtbl_contents
  &(vtt_S7394C14[0]), // expected_vtt_contents
  ABISELECT(2176,1416), // object size
  NSPAIRA(_ZTI8S7394C14),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7394C14),35, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C14),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C15  : S7394C8 {
  ::S7394C2 s7394c15f0;
  void *s7394c15f1[5];
  int s7394c15f2;
  __tsi64 s7394c15f3[9];
  ::S468C20_nt s7394c15f4;
  __tsi64 s7394c15f5[6];
  char  :0;
  __tsi64 s7394c15f7;
  long double s7394c15f8;
  ::S7394C6 s7394c15f9;
  ::S7394C3 s7394c15f10;
  int s7394c15f11;
  int s7394c15f12;
  long s7394c15f13;
  virtual  ~S7394C15(); // _ZN8S7394C15D2Ev
  S7394C15(); // tgen
};
//SIG(-1 S7394C15) C1{ BC2{ BC3{ m FD[2] Fc[8]} BC4{ VBC3 FL[4] FC3 Fi FC3 FL Fp FC3 Fp[4]} VBC5{ vd v1 v2 FC4 Fp FL Fi Fp FU6{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU6 FC5 FD Fs:0 FC3 FD Fp} vd FC4 Fp[5] Fi FL[9] FC7{} FL[6] Fc:0 FL FD FU6 FC3 Fi Fi Fl}


 S7394C15 ::~S7394C15(){ note_dtor("S7394C15", this);}
S7394C15 ::S7394C15(){ note_ctor("S7394C15", this);} // tgen

static void Test_S7394C15()
{
  extern Class_Descriptor cd_S7394C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(133,352)];
    init_test(&cd_S7394C15, buf);
    S7394C15 *dp, &lv = *(dp=new (buf) S7394C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2112,1404), "sizeof(S7394C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C15)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(256,164), "S7394C15");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(1568,1048), "S7394C15");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), 0, "S7394C15");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(1616,1080), "S7394C15");
    check_base_class_offset(lv, (S7394C8*), 0, "S7394C15");
    check_field_offset(lv, s7394c15f0, ABISELECT(976,628), "S7394C15.s7394c15f0");
    check_field_offset(lv, s7394c15f1, ABISELECT(1280,824), "S7394C15.s7394c15f1");
    check_field_offset(lv, s7394c15f2, ABISELECT(1320,844), "S7394C15.s7394c15f2");
    check_field_offset(lv, s7394c15f3, ABISELECT(1328,848), "S7394C15.s7394c15f3");
    check_field_offset(lv, s7394c15f4, ABISELECT(1400,920), "S7394C15.s7394c15f4");
    check_field_offset(lv, s7394c15f5, ABISELECT(1408,924), "S7394C15.s7394c15f5");
    check_field_offset(lv, s7394c15f7, ABISELECT(1456,972), "S7394C15.s7394c15f7");
    check_field_offset(lv, s7394c15f8, ABISELECT(1472,980), "S7394C15.s7394c15f8");
    check_field_offset(lv, s7394c15f9, ABISELECT(1488,992), "S7394C15.s7394c15f9");
    check_field_offset(lv, s7394c15f10, ABISELECT(1504,1004), "S7394C15.s7394c15f10");
    check_field_offset(lv, s7394c15f11, ABISELECT(1552,1036), "S7394C15.s7394c15f11");
    check_field_offset(lv, s7394c15f12, ABISELECT(1556,1040), "S7394C15.s7394c15f12");
    check_field_offset(lv, s7394c15f13, ABISELECT(1560,1044), "S7394C15.s7394c15f13");
    test_class_info(&lv, &cd_S7394C15);
    dp->~S7394C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C15(Test_S7394C15, "S7394C15", ABISELECT(2112,1404));

#else // __cplusplus

extern void _ZN8S7394C15C1Ev();
extern void _ZN8S7394C15D2Ev();
Name_Map name_map_S7394C15[] = {
  NSPAIR(_ZN8S7394C15C1Ev),
  NSPAIR(_ZN8S7394C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
static Base_Class bases_S7394C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(256,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(1568,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(1616,1080), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C15[];
extern void _ZN8S7394C15D1Ev();
extern void _ZN8S7394C15D0Ev();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev)();
extern void ABISELECT(_ZThn1616_N8S7394C15D1Ev,_ZThn1080_N8S7394C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev)();
extern void ABISELECT(_ZThn1616_N8S7394C15D0Ev,_ZThn1080_N8S7394C15D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C15[] = {
  ABISELECT(1616,1080),
  ABISELECT(1568,1048),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&_ZN8S7394C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C15D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-1616,-1080),
  ABISELECT(-1616,-1080),
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV8S7394C15[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C15[] = {
  ABISELECT(1616,1080),
  ABISELECT(1568,1048),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C15[] = {
  ABISELECT(1568,1048),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1616_N7S7394C8D1Ev,_ZThn1080_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1616_N7S7394C8D0Ev,_ZThn1080_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C15[] = {
  0,
  0,
  ABISELECT(-1616,-1080),
  ABISELECT(-1616,-1080),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C15[] = {
  {&(_ZTV8S7394C15[4]),  4,16},
  {&(_tg__ZTV7S7394C8__8S7394C15[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C15[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C15[5]),  5,9},
  {&(_ZTV8S7394C15[12]),  12,16},
};
extern VTBL_ENTRY _ZTI8S7394C15[];
extern  VTBL_ENTRY _ZTV8S7394C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C15[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N7S7394C8D0Ev,_ZThn1080_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N7S7394C8D1Ev,_ZThn1080_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N8S7394C15D0Ev,_ZThn1080_N8S7394C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N8S7394C15D1Ev,_ZThn1080_N8S7394C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C15 = {  "S7394C15", // class name
  bases_S7394C15, 5,
  &(vtc_S7394C15[0]), // expected_vtbl_contents
  &(vtt_S7394C15[0]), // expected_vtt_contents
  ABISELECT(2112,1404), // object size
  NSPAIRA(_ZTI8S7394C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7394C15),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C15),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C13  : virtual S7394C14 , virtual S7394C15 , virtual S7394C11 {
  int s7394c13f0;
  int s7394c13f1;
  ::S7394C11 s7394c13f2;
  __tsi64 s7394c13f3;
  int s7394c13f4;
  long double s7394c13f5;
  void *s7394c13f6;
  int s7394c13f7;
  virtual void  v7(); // _ZN8S7394C132v7Ev
  ~S7394C13(); // tgen
  S7394C13(); // tgen
};
//SIG(-1 S7394C13) C1{ VBC2{ VBC3{ VBC4{ BC5{ m FD[2] Fc[8]} BC6{ VBC5 FL[4] FC5 Fi FC5 FL Fp FC5 Fp[4]} VBC7{ vd v2 v3 FC6 Fp FL Fi Fp FU8{ m FD FL FD FL Fi}[8] Fc Fp} vd v4 Fp[4] FL Fp[3] FU8 FC7 FD Fs:0 FC5 FD Fp} BC9{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} vd v5 FC7 Fi Fi FU8} VBC10{ BC4 vd FC6 Fp[5] Fi FL[9] FC11{} FL[6] Fc:0 FL FD FU8 FC5 Fi Fi Fl} VBC12{ VBC4 vd v6 Fs FL FC7 FC5[5] FC4[8] FC6[5] FC6 Fp FL FL Fi[2]} v1 Fi Fi FC12 FL Fi FD Fp Fi}


void  S7394C13 ::v7(){vfunc_called(this, "_ZN8S7394C132v7Ev");}
S7394C13 ::~S7394C13(){ note_dtor("S7394C13", this);} // tgen
S7394C13 ::S7394C13(){ note_ctor("S7394C13", this);} // tgen

static void Test_S7394C13()
{
  extern Class_Descriptor cd_S7394C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2182,5662)];
    init_test(&cd_S7394C13, buf);
    S7394C13 *dp, &lv = *(dp=new (buf) S7394C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(34896,22644), "sizeof(S7394C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C13)");
    /*is_ambiguous_... S7394C13::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(17280,11200), "S7394C13");
    /*is_ambiguous_... S7394C13::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(18000,11664), "S7394C13");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(18000,11664), "S7394C13");
    /*is_ambiguous_... S7394C13::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(17024,11036), "S7394C13");
    /*is_ambiguous_... S7394C13::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(18048,11696), "S7394C13");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C15*), ABISELECT(18048,11696), "S7394C13");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(17024,11036), "S7394C13");
    check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(17024,11036), "S7394C13");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(16920,10956), "S7394C13");
    check_base_class_offset(lv, (S7394C7*)(S7394C14*), ABISELECT(16912,10952), "S7394C13");
    check_base_class_offset(lv, (S7394C14*), ABISELECT(16368,10604), "S7394C13");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C15*), ABISELECT(18800,12184), "S7394C13");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(18544,12020), "S7394C13");
    check_base_class_offset(lv, (S7394C8*)(S7394C15*), ABISELECT(18544,12020), "S7394C13");
    check_base_class_offset(lv, (S7394C15*), ABISELECT(18544,12020), "S7394C13");
    check_base_class_offset(lv, (S7394C11*), ABISELECT(20112,13068), "S7394C13");
    check_field_offset(lv, s7394c13f0, ABISELECT(8,4), "S7394C13.s7394c13f0");
    check_field_offset(lv, s7394c13f1, ABISELECT(12,8), "S7394C13.s7394c13f1");
    check_field_offset(lv, s7394c13f2, ABISELECT(16,12), "S7394C13.s7394c13f2");
    check_field_offset(lv, s7394c13f3, ABISELECT(16320,10572), "S7394C13.s7394c13f3");
    check_field_offset(lv, s7394c13f4, ABISELECT(16328,10580), "S7394C13.s7394c13f4");
    check_field_offset(lv, s7394c13f5, ABISELECT(16336,10584), "S7394C13.s7394c13f5");
    check_field_offset(lv, s7394c13f6, ABISELECT(16352,10596), "S7394C13.s7394c13f6");
    check_field_offset(lv, s7394c13f7, ABISELECT(16360,10600), "S7394C13.s7394c13f7");
    test_class_info(&lv, &cd_S7394C13);
    dp->~S7394C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C13(Test_S7394C13, "S7394C13", ABISELECT(34896,22644));

#else // __cplusplus

extern void _ZN8S7394C13C1Ev();
extern void _ZN8S7394C13D1Ev();
Name_Map name_map_S7394C13[] = {
  NSPAIR(_ZN8S7394C13C1Ev),
  NSPAIR(_ZN8S7394C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C15;
extern VTBL_ENTRY _ZTI8S7394C15[];
extern  VTBL_ENTRY _ZTV8S7394C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C15[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
static Base_Class bases_S7394C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(17280,11200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(18000,11664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(17024,11036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(18048,11696), //bcp->offset
    40, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(17024,11036), //bcp->offset
    31, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(16920,10956), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(16912,10952), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S7394C14,    ABISELECT(16368,10604), //bcp->offset
    12, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C3,    ABISELECT(18800,12184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(18544,12020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(18544,12020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7394C15,    ABISELECT(18544,12020), //bcp->offset
    49, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C11,    ABISELECT(20112,13068), //bcp->offset
    58, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C13[];
extern void _ZN8S7394C132v7Ev();
extern void _ZN8S7394C13D1Ev();
extern void _ZN8S7394C13D0Ev();
extern void ABISELECT(_ZTv0_n56_N8S7394C13D1Ev,_ZTv0_n28_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn16368_N8S7394C13D1Ev,_ZThn10604_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C13D0Ev,_ZTv0_n28_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn16368_N8S7394C13D0Ev,_ZThn10604_N8S7394C13D0Ev)() __attribute__((weak));
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C13D1Ev,_ZTv0_n24_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn16912_N8S7394C13D1Ev,_ZThn10952_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C13D0Ev,_ZTv0_n24_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn16912_N8S7394C13D0Ev,_ZThn10952_N8S7394C13D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C13D1Ev,_ZTv0_n20_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn17024_N8S7394C13D1Ev,_ZThn11036_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C13D0Ev,_ZTv0_n20_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn17024_N8S7394C13D0Ev,_ZThn11036_N8S7394C13D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C13D1Ev,_ZTv0_n12_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn18048_N8S7394C13D1Ev,_ZThn11696_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C13D0Ev,_ZTv0_n12_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn18048_N8S7394C13D0Ev,_ZThn11696_N8S7394C13D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C13D1Ev,_ZTv0_n20_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn18544_N8S7394C13D1Ev,_ZThn12020_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C13D0Ev,_ZTv0_n20_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn18544_N8S7394C13D0Ev,_ZThn12020_N8S7394C13D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C13D1Ev,_ZTv0_n24_N8S7394C13D1Ev)();
extern void ABISELECT(_ZThn20112_N8S7394C13D1Ev,_ZThn13068_N8S7394C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C13D0Ev,_ZTv0_n24_N8S7394C13D0Ev)();
extern void ABISELECT(_ZThn20112_N8S7394C13D0Ev,_ZThn13068_N8S7394C13D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY vtc_S7394C13[] = {
  ABISELECT(20112,13068),
  ABISELECT(18544,12020),
  ABISELECT(18048,11696),
  ABISELECT(18000,11664),
  ABISELECT(17024,11036),
  ABISELECT(16912,10952),
  ABISELECT(16368,10604),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&_ZN8S7394C132v7Ev,
  (VTBL_ENTRY)&_ZN8S7394C13D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C13D0Ev,
  0,
  ABISELECT(-16368,-10604),
  ABISELECT(1680,1092),
  ABISELECT(1632,1060),
  ABISELECT(656,432),
  ABISELECT(544,348),
  ABISELECT(-16368,-10604),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C13D1Ev,_ZTv0_n28_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C13D0Ev,_ZTv0_n28_N8S7394C13D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(-16912,-10952),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-16912,-10952),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C13D1Ev,_ZTv0_n24_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C13D0Ev,_ZTv0_n24_N8S7394C13D0Ev),
  0,
  ABISELECT(-17024,-11036),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-17024,-11036),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C13D1Ev,_ZTv0_n20_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C13D0Ev,_ZTv0_n20_N8S7394C13D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-18048,-11696),
  ABISELECT(-18048,-11696),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C13D1Ev,_ZTv0_n12_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C13D0Ev,_ZTv0_n12_N8S7394C13D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  0,
  ABISELECT(-18544,-12020),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-18544,-12020),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C13D1Ev,_ZTv0_n20_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C13D0Ev,_ZTv0_n20_N8S7394C13D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  ABISELECT(-20112,-13068),
  ABISELECT(-2064,-1372),
  ABISELECT(-2112,-1404),
  ABISELECT(-3088,-2032),
  ABISELECT(-20112,-13068),
  (VTBL_ENTRY)&(_ZTI8S7394C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C13D1Ev,_ZTv0_n24_N8S7394C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C13D0Ev,_ZTv0_n24_N8S7394C13D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern VTBL_ENTRY _ZTV8S7394C13[];
extern void _ZN8S7394C14D1Ev();
extern void _ZN8S7394C14D0Ev();
extern void _ZN8S7394C142v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C14__8S7394C13[] = {
  ABISELECT(1680,1092),
  ABISELECT(1632,1060),
  ABISELECT(656,432),
  ABISELECT(544,348),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&_ZN8S7394C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn544_N8S7394C14D1Ev,_ZThn348_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn544_N8S7394C14D0Ev,_ZThn348_N8S7394C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C14__8S7394C13[] = {
  ABISELECT(-544,-348),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-544,-348),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn656_N8S7394C14D1Ev,_ZThn432_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn656_N8S7394C14D0Ev,_ZThn432_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C14__8S7394C13[] = {
  0,
  ABISELECT(-656,-432),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-656,-432),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn1680_N8S7394C14D1Ev,_ZThn1092_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn1680_N8S7394C14D0Ev,_ZThn1092_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C14__8S7394C13[] = {
  0,
  0,
  ABISELECT(-1680,-1092),
  ABISELECT(-1680,-1092),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C13[] = {
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__8S7394C13[] = {
  0,
  ABISELECT(-112,-84),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__8S7394C13[] = {
  0,
  0,
  ABISELECT(-1136,-744),
  ABISELECT(-1136,-744),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C13[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C13[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C13[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C15D1Ev();
extern void _ZN8S7394C15D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C15__8S7394C13[] = {
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&_ZN8S7394C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C15D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C88S7394C15__A1__8S7394C13[] = {
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C88S7394C15__A1__8S7394C13[] = {
  ABISELECT(-544,-356),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C88S7394C15__A1__8S7394C13[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C15__8S7394C13[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C13[] = {
  ABISELECT(-2064,-1372),
  ABISELECT(-2112,-1404),
  ABISELECT(-3088,-2032),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C13[] = {
  0,
  ABISELECT(3088,2032),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(3088,2032),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C13[] = {
  0,
  0,
  ABISELECT(2064,1372),
  ABISELECT(2064,1372),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C13[] = {
  {&(_ZTV8S7394C13[9]),  9,68},
  {&(_ZTV8S7394C13[20]),  20,68},
  {&(_ZTV8S7394C13[29]),  29,68},
  {&(_ZTV8S7394C13[37]),  37,68},
  {&(_ZTV8S7394C13[45]),  45,68},
  {&(_ZTV8S7394C13[55]),  55,68},
  {&(_ZTV8S7394C13[65]),  65,68},
  {&(_tg__ZTV8S7394C14__8S7394C13[6]),  6,9},
  {&(_tg__ZTV7S7394C7__8S7394C14__8S7394C13[6]),  6,8},
  {&(_tg__ZTV7S7394C8__8S7394C14__8S7394C13[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C14__8S7394C13[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C13[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__8S7394C13[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__8S7394C13[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C13[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C13[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C13[5]),  5,9},
  {&(_tg__ZTV8S7394C15__8S7394C13[4]),  4,7},
  {&(_tg__ZTV7S7394C88S7394C15__A1__8S7394C13[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C88S7394C15__A1__8S7394C13[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C88S7394C15__A1__8S7394C13[5]),  5,9},
  {&(_tg__ZTV7S7394C5__8S7394C15__8S7394C13[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C13[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C13[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C13[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S7394C13[];
extern  VTBL_ENTRY _ZTV8S7394C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C13[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D0Ev,_ZThn744_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N7S7394C7D1Ev,_ZThn744_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D0Ev,_ZThn84_N7S7394C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N7S7394C7D1Ev,_ZThn84_N7S7394C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S7394C14D0Ev,_ZThn1092_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S7394C14D1Ev,_ZThn1092_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S7394C14D0Ev,_ZThn432_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S7394C14D1Ev,_ZThn432_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7394C14D0Ev,_ZThn348_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn544_N8S7394C14D1Ev,_ZThn348_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C13D0Ev,_ZTv0_n12_N8S7394C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18048_N8S7394C13D0Ev,_ZThn11696_N8S7394C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C13D1Ev,_ZTv0_n12_N8S7394C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18048_N8S7394C13D1Ev,_ZThn11696_N8S7394C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C13D0Ev,_ZTv0_n20_N8S7394C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18544_N8S7394C13D0Ev,_ZThn12020_N8S7394C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17024_N8S7394C13D0Ev,_ZThn11036_N8S7394C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C13D1Ev,_ZTv0_n20_N8S7394C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18544_N8S7394C13D1Ev,_ZThn12020_N8S7394C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17024_N8S7394C13D1Ev,_ZThn11036_N8S7394C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C13D0Ev,_ZTv0_n24_N8S7394C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20112_N8S7394C13D0Ev,_ZThn13068_N8S7394C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16912_N8S7394C13D0Ev,_ZThn10952_N8S7394C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C13D1Ev,_ZTv0_n24_N8S7394C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20112_N8S7394C13D1Ev,_ZThn13068_N8S7394C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16912_N8S7394C13D1Ev,_ZThn10952_N8S7394C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C13D0Ev,_ZTv0_n28_N8S7394C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16368_N8S7394C13D0Ev,_ZThn10604_N8S7394C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C13D1Ev,_ZTv0_n28_N8S7394C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16368_N8S7394C13D1Ev,_ZThn10604_N8S7394C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C13 = {  "S7394C13", // class name
  bases_S7394C13, 13,
  &(vtc_S7394C13[0]), // expected_vtbl_contents
  &(vtt_S7394C13[0]), // expected_vtt_contents
  ABISELECT(34896,22644), // object size
  NSPAIRA(_ZTI8S7394C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7394C13),68, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C13),25, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C18  : virtual S7394C11 {
  char  :0;
  __tsi64 s7394c18f1:64;
  int s7394c18f2;
  virtual  ~S7394C18(); // _ZN8S7394C18D2Ev
  S7394C18(); // tgen
};
//SIG(-1 S7394C18) C1{ VBC2{ VBC3{ BC4{ m FD[2] Fc[8]} BC5{ VBC4 FL[4] FC4 Fi FC4 FL Fp FC4 Fp[4]} VBC6{ vd v1 v2 FC5 Fp FL Fi Fp FU7{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU7 FC6 FD Fs:0 FC4 FD Fp} vd v4 Fs FL FC6 FC4[5] FC3[8] FC5[5] FC5 Fp FL FL Fi[2]} vd Fc:0 FL:64 Fi}


 S7394C18 ::~S7394C18(){ note_dtor("S7394C18", this);}
S7394C18 ::S7394C18(){ note_ctor("S7394C18", this);} // tgen

static void Test_S7394C18()
{
  extern Class_Descriptor cd_S7394C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1022,2645)];
    init_test(&cd_S7394C18, buf);
    S7394C18 *dp, &lv = *(dp=new (buf) S7394C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16336,10576), "sizeof(S7394C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C18)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(15072,9756), "S7394C18");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(15792,10220), "S7394C18");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(14816,9592), "S7394C18");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(15840,10252), "S7394C18");
    check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(14816,9592), "S7394C18");
    check_base_class_offset(lv, (S7394C11*), ABISELECT(32,16), "S7394C18");
    set_bf_and_test(lv, s7394c18f1, ABISELECT(8,4), 0, 64, 1, "S7394C18");
    set_bf_and_test(lv, s7394c18f1, ABISELECT(8,4), 0, 64, hide_sll(1LL<<63), "S7394C18");
    check_field_offset(lv, s7394c18f2, ABISELECT(16,12), "S7394C18.s7394c18f2");
    test_class_info(&lv, &cd_S7394C18);
    dp->~S7394C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C18(Test_S7394C18, "S7394C18", ABISELECT(16336,10576));

#else // __cplusplus

extern void _ZN8S7394C18C1Ev();
extern void _ZN8S7394C18D2Ev();
Name_Map name_map_S7394C18[] = {
  NSPAIR(_ZN8S7394C18C1Ev),
  NSPAIR(_ZN8S7394C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
static Base_Class bases_S7394C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(15072,9756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(15792,10220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(14816,9592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(15840,10252), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(14816,9592), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7394C11,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C18[];
extern void _ZN8S7394C18D1Ev();
extern void _ZN8S7394C18D0Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn32_N8S7394C18D1Ev,_ZThn16_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn32_N8S7394C18D0Ev,_ZThn16_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn14816_N8S7394C18D1Ev,_ZThn9592_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn14816_N8S7394C18D0Ev,_ZThn9592_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn15840_N8S7394C18D1Ev,_ZThn10252_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn15840_N8S7394C18D0Ev,_ZThn10252_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY vtc_S7394C18[] = {
  ABISELECT(15840,10252),
  ABISELECT(15792,10220),
  ABISELECT(14816,9592),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&_ZN8S7394C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C18D0Ev,
  0,
  ABISELECT(-32,-16),
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  0,
  ABISELECT(-14816,-9592),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-14816,-9592),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-15840,-10252),
  ABISELECT(-15840,-10252),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern VTBL_ENTRY _ZTV8S7394C18[];
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C18[] = {
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C18[] = {
  0,
  ABISELECT(-14784,-9576),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-14784,-9576),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C18[] = {
  0,
  0,
  ABISELECT(-15808,-10236),
  ABISELECT(-15808,-10236),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C18[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C18[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C18[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C18[] = {
  {&(_ZTV8S7394C18[6]),  6,36},
  {&(_ZTV8S7394C18[15]),  15,36},
  {&(_ZTV8S7394C18[24]),  24,36},
  {&(_ZTV8S7394C18[32]),  32,36},
  {&(_tg__ZTV8S7394C11__8S7394C18[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C18[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C18[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C18[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C18[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C18[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15840_N8S7394C18D0Ev,_ZThn10252_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15840_N8S7394C18D1Ev,_ZThn10252_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14816_N8S7394C18D0Ev,_ZThn9592_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14816_N8S7394C18D1Ev,_ZThn9592_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7394C18D0Ev,_ZThn16_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S7394C18D1Ev,_ZThn16_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C18 = {  "S7394C18", // class name
  bases_S7394C18, 6,
  &(vtc_S7394C18[0]), // expected_vtbl_contents
  &(vtt_S7394C18[0]), // expected_vtt_contents
  ABISELECT(16336,10576), // object size
  NSPAIRA(_ZTI8S7394C18),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7394C18),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C18),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C19  : virtual S7394C18 , S7394C10 , S7394C14 {
  int s7394c19f0;
  int s7394c19f1;
  ::S7394C2 s7394c19f2;
  ::S7394C3 s7394c19f3;
  int s7394c19f4;
  __tsi64 s7394c19f5;
  int s7394c19f6;
  __tsi64 s7394c19f7[3];
  __tsi64 s7394c19f8;
  __tsi64 s7394c19f9;
  __tsi64 s7394c19f10:25;
  virtual  ~S7394C19(); // _ZN8S7394C19D2Ev
  S7394C19(); // tgen
};
//SIG(-1 S7394C19) C1{ VBC2{ VBC3{ VBC4{ BC5{ m FD[2] Fc[8]} BC6{ VBC5 FL[4] FC5 Fi FC5 FL Fp FC5 Fp[4]} VBC7{ vd v1 v2 FC6 Fp FL Fi Fp FU8{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU8 FC7 FD Fs:0 FC5 FD Fp} vd v4 Fs FL FC7 FC5[5] FC4[8] FC6[5] FC6 Fp FL FL Fi[2]} vd Fc:0 FL:64 Fi} BC9{ VBC10{ VBC4 BC11{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} BC4 VBC3 VBC6 vd FL FD Fp[6]} BC12{ VBC10 vd v5 FC7 Fi Fi FU8} vd Fi Fi FC6 FC5 Fi FL Fi FL[3] FL FL FL:25}


 S7394C19 ::~S7394C19(){ note_dtor("S7394C19", this);}
S7394C19 ::S7394C19(){ note_ctor("S7394C19", this);} // tgen

static void Test_S7394C19()
{
  extern Class_Descriptor cd_S7394C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1171,3036)];
    init_test(&cd_S7394C19, buf);
    S7394C19 *dp, &lv = *(dp=new (buf) S7394C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(18720,12140), "sizeof(S7394C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C19)");
    /*is_ambiguous_... S7394C19::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(17088,11072), "S7394C19");
    /*is_ambiguous_... S7394C19::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(17808,11536), "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C10*), ABISELECT(17808,11536), "S7394C19");
    /*is_ambiguous_... S7394C19::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*), ABISELECT(17808,11536), "S7394C19");
    /*is_ambiguous_... S7394C19::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(16832,10908), "S7394C19");
    /*is_ambiguous_... S7394C19::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(17856,11568), "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C10*), ABISELECT(17856,11568), "S7394C19");
    check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(16832,10908), "S7394C19");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(16832,10908), "S7394C19");
    check_base_class_offset(lv, (S7394C11*)(S7394C18*), ABISELECT(2048,1332), "S7394C19");
    check_base_class_offset(lv, (S7394C11*)(S7394C10*), ABISELECT(2048,1332), "S7394C19");
    check_base_class_offset(lv, (S7394C18*), ABISELECT(2024,1316), "S7394C19");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(18360,11896), "S7394C19");
    check_base_class_offset(lv, (S7394C7*)(S7394C10*), ABISELECT(18352,11892), "S7394C19");
    check_base_class_offset(lv, (S7394C7*)(S7394C14*), ABISELECT(18352,11892), "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C10*), ABISELECT(256,164), "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C10*), 0, "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C10*), 0, "S7394C19");
    /*is_ambiguous_... S7394C10::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C10*), ABISELECT(18464,11976), "S7394C19");
    check_base_class_offset(lv, (S7394C10*), 0, "S7394C19");
    check_base_class_offset(lv, (S7394C14*), ABISELECT(1040,672), "S7394C19");
    check_field_offset(lv, s7394c19f0, ABISELECT(1584,1020), "S7394C19.s7394c19f0");
    check_field_offset(lv, s7394c19f1, ABISELECT(1588,1024), "S7394C19.s7394c19f1");
    check_field_offset(lv, s7394c19f2, ABISELECT(1600,1028), "S7394C19.s7394c19f2");
    check_field_offset(lv, s7394c19f3, ABISELECT(1904,1224), "S7394C19.s7394c19f3");
    check_field_offset(lv, s7394c19f4, ABISELECT(1952,1256), "S7394C19.s7394c19f4");
    check_field_offset(lv, s7394c19f5, ABISELECT(1960,1260), "S7394C19.s7394c19f5");
    check_field_offset(lv, s7394c19f6, ABISELECT(1968,1268), "S7394C19.s7394c19f6");
    check_field_offset(lv, s7394c19f7, ABISELECT(1976,1272), "S7394C19.s7394c19f7");
    check_field_offset(lv, s7394c19f8, ABISELECT(2000,1296), "S7394C19.s7394c19f8");
    check_field_offset(lv, s7394c19f9, ABISELECT(2008,1304), "S7394C19.s7394c19f9");
    set_bf_and_test(lv, s7394c19f10, ABISELECT(2016,1312), 0, 25, 1, "S7394C19");
    set_bf_and_test(lv, s7394c19f10, ABISELECT(2016,1312), 0, 25, hide_sll(1LL<<24), "S7394C19");
    test_class_info(&lv, &cd_S7394C19);
    dp->~S7394C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C19(Test_S7394C19, "S7394C19", ABISELECT(18720,12140));

#else // __cplusplus

extern void _ZN8S7394C19C1Ev();
extern void _ZN8S7394C19D2Ev();
Name_Map name_map_S7394C19[] = {
  NSPAIR(_ZN8S7394C19C1Ev),
  NSPAIR(_ZN8S7394C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C18;
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C10;
extern VTBL_ENTRY _ZTI8S7394C10[];
extern  VTBL_ENTRY _ZTV8S7394C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C10[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
static Base_Class bases_S7394C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(17088,11072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(17808,11536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(16832,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(17856,11568), //bcp->offset
    49, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(16832,10908), //bcp->offset
    40, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7394C11,    ABISELECT(2048,1332), //bcp->offset
    30, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C18,    ABISELECT(2024,1316), //bcp->offset
    21, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C9,    ABISELECT(18360,11896), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(18352,11892), //bcp->offset
    58, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7394C3,    ABISELECT(256,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7394C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7394C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(18464,11976), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7394C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C14,    ABISELECT(1040,672), //bcp->offset
    12, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C19[];
extern void _ZN8S7394C19D1Ev();
extern void _ZN8S7394C19D0Ev();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZThn1040_N8S7394C19D1Ev,_ZThn672_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn1040_N8S7394C19D0Ev,_ZThn672_N8S7394C19D0Ev)();
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn2024_N8S7394C19D1Ev,_ZThn1316_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn2024_N8S7394C19D0Ev,_ZThn1316_N8S7394C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn2048_N8S7394C19D1Ev,_ZThn1332_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn2048_N8S7394C19D0Ev,_ZThn1332_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn16832_N8S7394C19D1Ev,_ZThn10908_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn16832_N8S7394C19D0Ev,_ZThn10908_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn17856_N8S7394C19D1Ev,_ZThn11568_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn17856_N8S7394C19D0Ev,_ZThn11568_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn18352_N8S7394C19D1Ev,_ZThn11892_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn18352_N8S7394C19D0Ev,_ZThn11892_N8S7394C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7394C19[] = {
  ABISELECT(2024,1316),
  ABISELECT(18464,11976),
  ABISELECT(2048,1332),
  ABISELECT(16832,10908),
  ABISELECT(18352,11892),
  ABISELECT(17856,11568),
  ABISELECT(17808,11536),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&_ZN8S7394C19D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C19D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(16816,10896),
  ABISELECT(16768,10864),
  ABISELECT(15792,10236),
  ABISELECT(17312,11220),
  ABISELECT(-1040,-672),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1040_N8S7394C19D1Ev,_ZThn672_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1040_N8S7394C19D0Ev,_ZThn672_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(-2024,-1316),
  ABISELECT(15832,10252),
  ABISELECT(15784,10220),
  ABISELECT(14808,9592),
  ABISELECT(24,16),
  ABISELECT(-2024,-1316),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev),
  0,
  ABISELECT(-2048,-1332),
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  ABISELECT(-2048,-1332),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  0,
  ABISELECT(-16832,-10908),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-16832,-10908),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-17856,-11568),
  ABISELECT(-17856,-11568),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  ABISELECT(-18352,-11892),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  ABISELECT(-18352,-11892),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev),
  ABISELECT(-656,-440),
  ABISELECT(-18464,-11976),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
};
extern VTBL_ENTRY _ZTV8S7394C19[];
extern void _ZN8S7394C10D1Ev();
extern void _ZN8S7394C10D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C10__8S7394C19[] = {
  ABISELECT(18464,11976),
  ABISELECT(2048,1332),
  ABISELECT(16832,10908),
  ABISELECT(18352,11892),
  ABISELECT(17856,11568),
  ABISELECT(17808,11536),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&_ZN8S7394C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C10D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C88S7394C10__A1__8S7394C19[] = {
  ABISELECT(17856,11568),
  ABISELECT(17808,11536),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C88S7394C10__A1__8S7394C19[] = {
  ABISELECT(17808,11536),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn17856_N7S7394C8D1Ev,_ZThn11568_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn17856_N7S7394C8D0Ev,_ZThn11568_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C88S7394C10__A1__8S7394C19[] = {
  0,
  0,
  ABISELECT(-17856,-11568),
  ABISELECT(-17856,-11568),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn18352_N8S7394C10D1Ev,_ZThn11892_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn18352_N8S7394C10D0Ev,_ZThn11892_N8S7394C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C10__8S7394C19[] = {
  ABISELECT(-18352,-11892),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  ABISELECT(-18352,-11892),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn16832_N8S7394C10D1Ev,_ZThn10908_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn16832_N8S7394C10D0Ev,_ZThn10908_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C10__8S7394C19[] = {
  0,
  ABISELECT(-16832,-10908),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-16832,-10908),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn17856_N8S7394C10D1Ev,_ZThn11568_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn17856_N8S7394C10D0Ev,_ZThn11568_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C10__8S7394C19[] = {
  0,
  0,
  ABISELECT(-17856,-11568),
  ABISELECT(-17856,-11568),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn2048_N8S7394C10D1Ev,_ZThn1332_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn2048_N8S7394C10D0Ev,_ZThn1332_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C10__8S7394C19[] = {
  0,
  ABISELECT(-2048,-1332),
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  ABISELECT(-2048,-1332),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C10__8S7394C19[] = {
  ABISELECT(-656,-440),
  ABISELECT(-18464,-11976),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
};
extern void _ZN8S7394C14D1Ev();
extern void _ZN8S7394C14D0Ev();
extern void _ZN8S7394C142v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C14__8S7394C19[] = {
  ABISELECT(16816,10896),
  ABISELECT(16768,10864),
  ABISELECT(15792,10236),
  ABISELECT(17312,11220),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&_ZN8S7394C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn17312_N8S7394C14D1Ev,_ZThn11220_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn17312_N8S7394C14D0Ev,_ZThn11220_N8S7394C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C14__8S7394C19[] = {
  ABISELECT(-17312,-11220),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  ABISELECT(-17312,-11220),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn15792_N8S7394C14D1Ev,_ZThn10236_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn15792_N8S7394C14D0Ev,_ZThn10236_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C14__8S7394C19[] = {
  0,
  ABISELECT(-15792,-10236),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-15792,-10236),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn16816_N8S7394C14D1Ev,_ZThn10896_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn16816_N8S7394C14D0Ev,_ZThn10896_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C14__8S7394C19[] = {
  0,
  0,
  ABISELECT(-16816,-10896),
  ABISELECT(-16816,-10896),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C18D1Ev();
extern void _ZN8S7394C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C18__8S7394C19[] = {
  ABISELECT(15832,10252),
  ABISELECT(15784,10220),
  ABISELECT(14808,9592),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&_ZN8S7394C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C18D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn24_N8S7394C18D1Ev,_ZThn16_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn24_N8S7394C18D0Ev,_ZThn16_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C18__8S7394C19[] = {
  0,
  ABISELECT(-24,-16),
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn14808_N8S7394C18D1Ev,_ZThn9592_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn14808_N8S7394C18D0Ev,_ZThn9592_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C18__8S7394C19[] = {
  0,
  ABISELECT(-14808,-9592),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-14808,-9592),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn15832_N8S7394C18D1Ev,_ZThn10252_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn15832_N8S7394C18D0Ev,_ZThn10252_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C18__8S7394C19[] = {
  0,
  0,
  ABISELECT(-15832,-10252),
  ABISELECT(-15832,-10252),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C19[] = {
  ABISELECT(15808,10236),
  ABISELECT(15760,10204),
  ABISELECT(14784,9576),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C19[] = {
  0,
  ABISELECT(-14784,-9576),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-14784,-9576),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C19[] = {
  0,
  0,
  ABISELECT(-15808,-10236),
  ABISELECT(-15808,-10236),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C19[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C19[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C19[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C19[] = {
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__8S7394C19[] = {
  0,
  ABISELECT(1520,984),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(1520,984),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__8S7394C19[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C19[] = {
  ABISELECT(-656,-440),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
static  VTT_ENTRY vtt_S7394C19[] = {
  {&(_ZTV8S7394C19[9]),  9,69},
  {&(_tg__ZTV8S7394C10__8S7394C19[8]),  8,11},
  {&(_tg__ZTV7S7394C88S7394C10__A1__8S7394C19[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C88S7394C10__A1__8S7394C19[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C88S7394C10__A1__8S7394C19[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C10__8S7394C19[6]),  6,8},
  {&(_tg__ZTV7S7394C8__8S7394C10__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C10__8S7394C19[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C10__8S7394C19[7]),  7,10},
  {&(_tg__ZTV7S7394C2__A2__8S7394C10__8S7394C19[3]),  3,3},
  {&(_tg__ZTV8S7394C14__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C7__8S7394C14__8S7394C19[6]),  6,8},
  {&(_tg__ZTV7S7394C8__8S7394C14__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C14__8S7394C19[5]),  5,9},
  {&(_ZTV8S7394C19[28]),  28,69},
  {&(_ZTV8S7394C19[37]),  37,69},
  {&(_ZTV8S7394C19[46]),  46,69},
  {&(_ZTV8S7394C19[54]),  54,69},
  {&(_ZTV8S7394C19[64]),  64,69},
  {&(_ZTV8S7394C19[69]),  69,69},
  {&(_ZTV8S7394C19[18]),  18,69},
  {&(_tg__ZTV8S7394C18__8S7394C19[6]),  6,8},
  {&(_tg__ZTV8S7394C11__8S7394C18__8S7394C19[7]),  7,10},
  {&(_tg__ZTV7S7394C8__8S7394C18__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C18__8S7394C19[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C19[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C19[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C19[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C19[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C19[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C19[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__8S7394C19[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__8S7394C19[5]),  5,9},
  {&(_tg__ZTV7S7394C2__A2__8S7394C19[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S7394C19[];
extern  VTBL_ENTRY _ZTV8S7394C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C19[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D0Ev,_ZThn10236_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15808_N8S7394C11D1Ev,_ZThn10236_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15832_N8S7394C18D0Ev,_ZThn10252_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15832_N8S7394C18D1Ev,_ZThn10252_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14808_N8S7394C18D0Ev,_ZThn9592_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14808_N8S7394C18D1Ev,_ZThn9592_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7394C18D0Ev,_ZThn16_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S7394C18D1Ev,_ZThn16_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16816_N8S7394C14D0Ev,_ZThn10896_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16816_N8S7394C14D1Ev,_ZThn10896_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15792_N8S7394C14D0Ev,_ZThn10236_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15792_N8S7394C14D1Ev,_ZThn10236_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17312_N8S7394C14D0Ev,_ZThn11220_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17312_N8S7394C14D1Ev,_ZThn11220_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N8S7394C10D0Ev,_ZThn11568_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N8S7394C10D1Ev,_ZThn11568_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16832_N8S7394C10D0Ev,_ZThn10908_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16832_N8S7394C10D1Ev,_ZThn10908_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N8S7394C10D0Ev,_ZThn1332_N8S7394C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn18352_N8S7394C10D0Ev,_ZThn11892_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N8S7394C10D1Ev,_ZThn1332_N8S7394C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn18352_N8S7394C10D1Ev,_ZThn11892_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N7S7394C8D0Ev,_ZThn11568_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N7S7394C8D1Ev,_ZThn11568_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N8S7394C19D0Ev,_ZThn11568_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17856_N8S7394C19D1Ev,_ZThn11568_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16832_N8S7394C19D0Ev,_ZThn10908_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16832_N8S7394C19D1Ev,_ZThn10908_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18352_N8S7394C19D0Ev,_ZThn11892_N8S7394C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N8S7394C19D0Ev,_ZThn1332_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18352_N8S7394C19D1Ev,_ZThn11892_N8S7394C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N8S7394C19D1Ev,_ZThn1332_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2024_N8S7394C19D0Ev,_ZThn1316_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2024_N8S7394C19D1Ev,_ZThn1316_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C19 = {  "S7394C19", // class name
  bases_S7394C19, 15,
  &(vtc_S7394C19[0]), // expected_vtbl_contents
  &(vtt_S7394C19[0]), // expected_vtt_contents
  ABISELECT(18720,12140), // object size
  NSPAIRA(_ZTI8S7394C19),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7394C19),69, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C19),35, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C20  : S7394C5 {
  void *s7394c20f0;
  int s7394c20f1;
  ::S7394C7 s7394c20f2;
  virtual void  v8(); // _ZN8S7394C202v8Ev
  ~S7394C20(); // tgen
  S7394C20(); // tgen
};
//SIG(-1 S7394C20) C1{ BC2{ vd v2 v3 FC3{ VBC4{ m FD[2] Fc[8]} FL[4] FC4 Fi FC4 FL Fp FC4 Fp[4]} Fp FL Fi Fp FU5{ m FD FL FD FL Fi}[8] Fc Fp} v1 Fp Fi FC6{ VBC7{ BC4 BC3 VBC2 vd v4 Fp[4] FL Fp[3] FU5 FC2 FD Fs:0 FC4 FD Fp} BC8{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13}}


void  S7394C20 ::v8(){vfunc_called(this, "_ZN8S7394C202v8Ev");}
S7394C20 ::~S7394C20(){ note_dtor("S7394C20", this);} // tgen
S7394C20 ::S7394C20(){ note_ctor("S7394C20", this);} // tgen

static void Test_S7394C20()
{
  extern Class_Descriptor cd_S7394C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(135,351)];
    init_test(&cd_S7394C20, buf);
    S7394C20 *dp, &lv = *(dp=new (buf) S7394C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2144,1400), "sizeof(S7394C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C20)");
    check_base_class_offset(lv, (S7394C5*), 0, "S7394C20");
    check_field_offset(lv, s7394c20f0, ABISELECT(496,324), "S7394C20.s7394c20f0");
    check_field_offset(lv, s7394c20f1, ABISELECT(504,328), "S7394C20.s7394c20f1");
    check_field_offset(lv, s7394c20f2, ABISELECT(512,332), "S7394C20.s7394c20f2");
    test_class_info(&lv, &cd_S7394C20);
    dp->~S7394C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C20(Test_S7394C20, "S7394C20", ABISELECT(2144,1400));

#else // __cplusplus

extern void _ZN8S7394C20C1Ev();
extern void _ZN8S7394C20D1Ev();
Name_Map name_map_S7394C20[] = {
  NSPAIR(_ZN8S7394C20C1Ev),
  NSPAIR(_ZN8S7394C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
static Base_Class bases_S7394C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C20[];
extern void _ZN8S7394C20D1Ev();
extern void _ZN8S7394C20D0Ev();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void _ZN8S7394C202v8Ev();
static  VTBL_ENTRY vtc_S7394C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C20[0]),
  (VTBL_ENTRY)&_ZN8S7394C20D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C20D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  (VTBL_ENTRY)&_ZN8S7394C202v8Ev,
};
extern VTBL_ENTRY _ZTI8S7394C20[];
extern  VTBL_ENTRY _ZTV8S7394C20[];
Class_Descriptor cd_S7394C20 = {  "S7394C20", // class name
  bases_S7394C20, 1,
  &(vtc_S7394C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2144,1400), // object size
  NSPAIRA(_ZTI8S7394C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7394C20),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C21  : virtual S7394C8 , virtual S7394C11 {
  long s7394c21f0;
  int s7394c21f1;
  int s7394c21f2;
  __tsi64 s7394c21f3;
  char s7394c21f4:8;
  __tsi64 s7394c21f5;
  ::S7394C2 s7394c21f6;
  ::S7394C5 s7394c21f7;
  virtual  ~S7394C21(); // _ZN8S7394C21D2Ev
  virtual void  v9(); // _ZN8S7394C212v9Ev
  S7394C21(); // tgen
};
//SIG(1 S7394C21) C1{ VBC2{ BC3{ m FD[2] Fc[8]} BC4{ VBC3 FL[4] FC3 Fi FC3 FL Fp FC3 Fp[4]} VBC5{ vd v2 v3 FC4 Fp FL Fi Fp FU6{ m FD FL FD FL Fi}[8] Fc Fp} vd v4 Fp[4] FL Fp[3] FU6 FC5 FD Fs:0 FC3 FD Fp} VBC7{ VBC2 vd v5 Fs FL FC5 FC3[5] FC2[8] FC4[5] FC4 Fp FL FL Fi[2]} vd v1 Fl Fi Fi FL Fc:8 FL FC4 FC5}


 S7394C21 ::~S7394C21(){ note_dtor("S7394C21", this);}
void  S7394C21 ::v9(){vfunc_called(this, "_ZN8S7394C212v9Ev");}
S7394C21 ::S7394C21(){ note_ctor("S7394C21", this);} // tgen

static void Test_S7394C21()
{
  extern Class_Descriptor cd_S7394C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1073,2780)];
    init_test(&cd_S7394C21, buf);
    S7394C21 *dp, &lv = *(dp=new (buf) S7394C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17152,11116), "sizeof(S7394C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C21)");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(1104,720), "S7394C21");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(1824,1184), "S7394C21");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(848,556), "S7394C21");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(1872,1216), "S7394C21");
    check_base_class_offset(lv, (S7394C8*), ABISELECT(848,556), "S7394C21");
    check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(848,556), "S7394C21");
    check_base_class_offset(lv, (S7394C11*), ABISELECT(2368,1540), "S7394C21");
    check_field_offset(lv, s7394c21f0, ABISELECT(8,4), "S7394C21.s7394c21f0");
    check_field_offset(lv, s7394c21f1, ABISELECT(16,8), "S7394C21.s7394c21f1");
    check_field_offset(lv, s7394c21f2, ABISELECT(20,12), "S7394C21.s7394c21f2");
    check_field_offset(lv, s7394c21f3, ABISELECT(24,16), "S7394C21.s7394c21f3");
    set_bf_and_test(lv, s7394c21f4, ABISELECT(32,24), 0, 8, 1, "S7394C21");
    set_bf_and_test(lv, s7394c21f4, ABISELECT(32,24), 0, 8, hide_sll(1LL<<7), "S7394C21");
    check_field_offset(lv, s7394c21f5, ABISELECT(40,28), "S7394C21.s7394c21f5");
    check_field_offset(lv, s7394c21f6, ABISELECT(48,36), "S7394C21.s7394c21f6");
    check_field_offset(lv, s7394c21f7, ABISELECT(352,232), "S7394C21.s7394c21f7");
    test_class_info(&lv, &cd_S7394C21);
    dp->~S7394C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C21(Test_S7394C21, "S7394C21", ABISELECT(17152,11116));

#else // __cplusplus

extern void _ZN8S7394C21C1Ev();
extern void _ZN8S7394C21D2Ev();
Name_Map name_map_S7394C21[] = {
  NSPAIR(_ZN8S7394C21C1Ev),
  NSPAIR(_ZN8S7394C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
static Base_Class bases_S7394C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(1104,720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(1824,1184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(848,556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(1872,1216), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(848,556), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C11,    ABISELECT(2368,1540), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C21[];
extern void _ZN8S7394C21D1Ev();
extern void _ZN8S7394C21D0Ev();
extern void _ZN8S7394C212v9Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C21D1Ev,_ZTv0_n20_N8S7394C21D1Ev)();
extern void ABISELECT(_ZThn848_N8S7394C21D1Ev,_ZThn556_N8S7394C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C21D0Ev,_ZTv0_n20_N8S7394C21D0Ev)();
extern void ABISELECT(_ZThn848_N8S7394C21D0Ev,_ZThn556_N8S7394C21D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C21D1Ev,_ZTv0_n12_N8S7394C21D1Ev)();
extern void ABISELECT(_ZThn1872_N8S7394C21D1Ev,_ZThn1216_N8S7394C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C21D0Ev,_ZTv0_n12_N8S7394C21D0Ev)();
extern void ABISELECT(_ZThn1872_N8S7394C21D0Ev,_ZThn1216_N8S7394C21D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C21D1Ev,_ZTv0_n24_N8S7394C21D1Ev)();
extern void ABISELECT(_ZThn2368_N8S7394C21D1Ev,_ZThn1540_N8S7394C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C21D0Ev,_ZTv0_n24_N8S7394C21D0Ev)();
extern void ABISELECT(_ZThn2368_N8S7394C21D0Ev,_ZThn1540_N8S7394C21D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY vtc_S7394C21[] = {
  ABISELECT(2368,1540),
  ABISELECT(1872,1216),
  ABISELECT(1824,1184),
  ABISELECT(848,556),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C21[0]),
  (VTBL_ENTRY)&_ZN8S7394C21D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C21D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C212v9Ev,
  0,
  ABISELECT(-848,-556),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-848,-556),
  (VTBL_ENTRY)&(_ZTI8S7394C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C21D1Ev,_ZTv0_n20_N8S7394C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C21D0Ev,_ZTv0_n20_N8S7394C21D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-1872,-1216),
  ABISELECT(-1872,-1216),
  (VTBL_ENTRY)&(_ZTI8S7394C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C21D1Ev,_ZTv0_n12_N8S7394C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C21D0Ev,_ZTv0_n12_N8S7394C21D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  0,
  ABISELECT(-2368,-1540),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  ABISELECT(-2368,-1540),
  (VTBL_ENTRY)&(_ZTI8S7394C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C21D1Ev,_ZTv0_n24_N8S7394C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C21D0Ev,_ZTv0_n24_N8S7394C21D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern VTBL_ENTRY _ZTV8S7394C21[];
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C21[] = {
  ABISELECT(1024,660),
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C21[] = {
  ABISELECT(976,628),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C21[] = {
  0,
  0,
  ABISELECT(-1024,-660),
  ABISELECT(-1024,-660),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C21[] = {
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-1520,-984),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C21[] = {
  0,
  ABISELECT(1520,984),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(1520,984),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C21[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTT_ENTRY vtt_S7394C21[] = {
  {&(_ZTV8S7394C21[6]),  6,37},
  {&(_ZTV8S7394C21[15]),  15,37},
  {&(_ZTV8S7394C21[23]),  23,37},
  {&(_ZTV8S7394C21[34]),  34,37},
  {&(_tg__ZTV7S7394C8__8S7394C21[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C21[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C21[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C21[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C21[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C21[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S7394C21[];
extern  VTBL_ENTRY _ZTV8S7394C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C21[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D0Ev,_ZThn660_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1024_N7S7394C8D1Ev,_ZThn660_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C21D0Ev,_ZTv0_n24_N8S7394C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2368_N8S7394C21D0Ev,_ZThn1540_N8S7394C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C21D1Ev,_ZTv0_n24_N8S7394C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2368_N8S7394C21D1Ev,_ZThn1540_N8S7394C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C21D0Ev,_ZTv0_n12_N8S7394C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1872_N8S7394C21D0Ev,_ZThn1216_N8S7394C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C21D1Ev,_ZTv0_n12_N8S7394C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1872_N8S7394C21D1Ev,_ZThn1216_N8S7394C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C21D0Ev,_ZTv0_n20_N8S7394C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S7394C21D0Ev,_ZThn556_N8S7394C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C21D1Ev,_ZTv0_n20_N8S7394C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S7394C21D1Ev,_ZThn556_N8S7394C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C21 = {  "S7394C21", // class name
  bases_S7394C21, 6,
  &(vtc_S7394C21[0]), // expected_vtbl_contents
  &(vtt_S7394C21[0]), // expected_vtt_contents
  ABISELECT(17152,11116), // object size
  NSPAIRA(_ZTI8S7394C21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7394C21),37, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C21),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C17  : virtual S7394C3 , S7394C18 , S7394C19 , S7394C11 , S7394C15 {
  __tsi64 s7394c17f0;
  int s7394c17f1;
  __tsi64 s7394c17f2;
  int s7394c17f3;
  char s7394c17f4;
  ::S7394C20 s7394c17f5;
  void *s7394c17f6;
  __tsi64 s7394c17f7[6];
  __tsi64 s7394c17f8;
  __tsi64 s7394c17f9[10];
  ::S7394C21 s7394c17f10[5];
  int s7394c17f11;
  virtual  ~S7394C17(); // _ZN8S7394C17D2Ev
  S7394C17(); // tgen
};
//SIG(-1 S7394C17) C1{ VBC2{ m FD[2] Fc[8]} BC3{ VBC4{ VBC5{ BC2 BC6{ VBC2 FL[4] FC2 Fi FC2 FL Fp FC2 Fp[4]} VBC7{ vd v1 v2 FC6 Fp FL Fi Fp FU8{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU8 FC7 FD Fs:0 FC2 FD Fp} vd v4 Fs FL FC7 FC2[5] FC5[8] FC6[5] FC6 Fp FL FL Fi[2]} vd Fc:0 FL:64 Fi} BC9{ VBC3 BC10{ VBC11{ VBC5 BC12{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} BC5 VBC4 VBC6 vd FL FD Fp[6]} BC13{ VBC11 vd v5 FC7 Fi Fi FU8} vd Fi Fi FC6 FC2 Fi FL Fi FL[3] FL FL FL:25} BC4 BC14{ BC5 vd FC6 Fp[5] Fi FL[9] FC15{} FL[6] Fc:0 FL FD FU8 FC2 Fi Fi Fl} vd FL Fi FL Fi Fc FC16{ BC7 v6 Fp Fi FC11} Fp FL[6] FL FL[10] FC17{ VBC5 VBC4 vd v7 Fl Fi Fi FL Fc:8 FL FC6 FC7}[5] Fi}


 S7394C17 ::~S7394C17(){ note_dtor("S7394C17", this);}
S7394C17 ::S7394C17(){ note_ctor("S7394C17", this);} // tgen

static void Test_S7394C17()
{
  extern Class_Descriptor cd_S7394C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7702,19984)];
    init_test(&cd_S7394C17, buf);
    S7394C17 *dp, &lv = *(dp=new (buf) S7394C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(123216,79932), "sizeof(S7394C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C17)");
    /*is_ambiguous_... S7394C17::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*), ABISELECT(106512,69108), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(106512,69108), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(106512,69108), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*), ABISELECT(106512,69108), "S7394C17");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(106512,69108), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(121600,78880), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(121344,78716), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(122320,79344), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(122320,79344), "S7394C17");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C15*), ABISELECT(122320,79344), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(121344,78716), "S7394C17");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(121344,78716), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(121344,78716), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C18*), ABISELECT(106560,69140), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C18*), ABISELECT(106560,69140), "S7394C17");
    check_base_class_offset(lv, (S7394C11*)(S7394C10*)(S7394C19*), ABISELECT(106560,69140), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C18*), 0, "S7394C17");
    check_base_class_offset(lv, (S7394C18*)(S7394C19*), ABISELECT(122816,79668), "S7394C17");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(122856,79688), "S7394C17");
    check_base_class_offset(lv, (S7394C7*)(S7394C10*)(S7394C19*), ABISELECT(122848,79684), "S7394C17");
    check_base_class_offset(lv, (S7394C7*)(S7394C14*)(S7394C19*), ABISELECT(122848,79684), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(288,180), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(32,16), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(32,16), "S7394C17");
    /*is_ambiguous_... S7394C10::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C10*)(S7394C19*), ABISELECT(122960,79768), "S7394C17");
    check_base_class_offset(lv, (S7394C10*)(S7394C19*), ABISELECT(32,16), "S7394C17");
    check_base_class_offset(lv, (S7394C14*)(S7394C19*), ABISELECT(1072,688), "S7394C17");
    check_base_class_offset(lv, (S7394C19*), ABISELECT(32,16), "S7394C17");
    /*is_ambiguous_... S7394C17::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C11*), ABISELECT(2064,1332), "S7394C17");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C15*), ABISELECT(17104,11072), "S7394C17");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(16848,10908), "S7394C17");
    check_base_class_offset(lv, (S7394C8*)(S7394C15*), ABISELECT(16848,10908), "S7394C17");
    check_base_class_offset(lv, (S7394C15*), ABISELECT(16848,10908), "S7394C17");
    check_field_offset(lv, s7394c17f0, ABISELECT(18416,11956), "S7394C17.s7394c17f0");
    check_field_offset(lv, s7394c17f1, ABISELECT(18424,11964), "S7394C17.s7394c17f1");
    check_field_offset(lv, s7394c17f2, ABISELECT(18432,11968), "S7394C17.s7394c17f2");
    check_field_offset(lv, s7394c17f3, ABISELECT(18440,11976), "S7394C17.s7394c17f3");
    check_field_offset(lv, s7394c17f4, ABISELECT(18444,11980), "S7394C17.s7394c17f4");
    check_field_offset(lv, s7394c17f5, ABISELECT(18448,11984), "S7394C17.s7394c17f5");
    check_field_offset(lv, s7394c17f6, ABISELECT(20592,13384), "S7394C17.s7394c17f6");
    check_field_offset(lv, s7394c17f7, ABISELECT(20600,13388), "S7394C17.s7394c17f7");
    check_field_offset(lv, s7394c17f8, ABISELECT(20648,13436), "S7394C17.s7394c17f8");
    check_field_offset(lv, s7394c17f9, ABISELECT(20656,13444), "S7394C17.s7394c17f9");
    check_field_offset(lv, s7394c17f10, ABISELECT(20736,13524), "S7394C17.s7394c17f10");
    check_field_offset(lv, s7394c17f11, ABISELECT(106496,69104), "S7394C17.s7394c17f11");
    test_class_info(&lv, &cd_S7394C17);
    dp->~S7394C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C17(Test_S7394C17, "S7394C17", ABISELECT(123216,79932));

#else // __cplusplus

extern void _ZN8S7394C17C1Ev();
extern void _ZN8S7394C17D2Ev();
Name_Map name_map_S7394C17[] = {
  NSPAIR(_ZN8S7394C17C1Ev),
  NSPAIR(_ZN8S7394C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C18;
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
extern Class_Descriptor cd_S7394C18;
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C10;
extern VTBL_ENTRY _ZTI8S7394C10[];
extern  VTBL_ENTRY _ZTV8S7394C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C10[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
extern Class_Descriptor cd_S7394C19;
extern VTBL_ENTRY _ZTI8S7394C19[];
extern  VTBL_ENTRY _ZTV8S7394C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C19[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C15;
extern VTBL_ENTRY _ZTI8S7394C15[];
extern  VTBL_ENTRY _ZTV8S7394C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C15[];
static Base_Class bases_S7394C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(106512,69108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C3,    ABISELECT(121600,78880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(121344,78716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(122320,79344), //bcp->offset
    66, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(121344,78716), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7394C11,    ABISELECT(106560,69140), //bcp->offset
    47, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C18,    ABISELECT(122816,79668), //bcp->offset
    75, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(122856,79688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(122848,79684), //bcp->offset
    84, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7394C3,    ABISELECT(288,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(122960,79768), //bcp->offset
    92, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S7394C10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7394C14,    ABISELECT(1072,688), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S7394C19,    ABISELECT(32,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C11,    ABISELECT(2064,1332), //bcp->offset
    32, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C3,    ABISELECT(17104,11072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(16848,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(16848,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7394C15,    ABISELECT(16848,10908), //bcp->offset
    40, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C17[];
extern void _ZN8S7394C17D1Ev();
extern void _ZN8S7394C17D0Ev();
extern void ABISELECT(_ZThn32_N8S7394C17D1Ev,_ZThn16_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn32_N8S7394C17D0Ev,_ZThn16_N8S7394C17D0Ev)();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZThn1072_N8S7394C17D1Ev,_ZThn688_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn1072_N8S7394C17D0Ev,_ZThn688_N8S7394C17D0Ev)();
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZThn2064_N8S7394C17D1Ev,_ZThn1332_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn2064_N8S7394C17D0Ev,_ZThn1332_N8S7394C17D0Ev)();
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZThn16848_N8S7394C17D1Ev,_ZThn10908_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn16848_N8S7394C17D0Ev,_ZThn10908_N8S7394C17D0Ev)();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C17D1Ev,_ZTv0_n24_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn106560_N8S7394C17D1Ev,_ZThn69140_N8S7394C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C17D0Ev,_ZTv0_n24_N8S7394C17D0Ev)();
extern void ABISELECT(_ZThn106560_N8S7394C17D0Ev,_ZThn69140_N8S7394C17D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C17D1Ev,_ZTv0_n20_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn121344_N8S7394C17D1Ev,_ZThn78716_N8S7394C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C17D0Ev,_ZTv0_n20_N8S7394C17D0Ev)();
extern void ABISELECT(_ZThn121344_N8S7394C17D0Ev,_ZThn78716_N8S7394C17D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C17D1Ev,_ZTv0_n12_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn122320_N8S7394C17D1Ev,_ZThn79344_N8S7394C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C17D0Ev,_ZTv0_n12_N8S7394C17D0Ev)();
extern void ABISELECT(_ZThn122320_N8S7394C17D0Ev,_ZThn79344_N8S7394C17D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n56_N8S7394C17D1Ev,_ZTv0_n28_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C17D1Ev,_ZThn79668_N8S7394C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C17D0Ev,_ZTv0_n28_N8S7394C17D0Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C17D0Ev,_ZThn79668_N8S7394C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C17D1Ev,_ZTv0_n24_N8S7394C17D1Ev)();
extern void ABISELECT(_ZThn122848_N8S7394C17D1Ev,_ZThn79684_N8S7394C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C17D0Ev,_ZTv0_n24_N8S7394C17D0Ev)();
extern void ABISELECT(_ZThn122848_N8S7394C17D0Ev,_ZThn79684_N8S7394C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7394C17[] = {
  ABISELECT(122960,79768),
  ABISELECT(122848,79684),
  ABISELECT(122816,79668),
  ABISELECT(122320,79344),
  ABISELECT(106512,69108),
  ABISELECT(121344,78716),
  ABISELECT(106560,69140),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&_ZN8S7394C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C17D0Ev,
  ABISELECT(122784,79652),
  ABISELECT(122928,79752),
  ABISELECT(106528,69124),
  ABISELECT(121312,78700),
  ABISELECT(122816,79668),
  ABISELECT(122288,79328),
  ABISELECT(106480,69092),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7394C17D1Ev,_ZThn16_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7394C17D0Ev,_ZThn16_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(121248,78656),
  ABISELECT(105440,68420),
  ABISELECT(120272,78028),
  ABISELECT(121776,78996),
  ABISELECT(-1072,-688),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1072_N8S7394C17D1Ev,_ZThn688_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1072_N8S7394C17D0Ev,_ZThn688_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(120256,78012),
  ABISELECT(104448,67776),
  ABISELECT(119280,77384),
  ABISELECT(-2064,-1332),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N8S7394C17D1Ev,_ZThn1332_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N8S7394C17D0Ev,_ZThn1332_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  ABISELECT(105472,68436),
  ABISELECT(89664,58200),
  ABISELECT(-16848,-10908),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16848_N8S7394C17D1Ev,_ZThn10908_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16848_N8S7394C17D0Ev,_ZThn10908_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  ABISELECT(-106560,-69140),
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  ABISELECT(-106560,-69140),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C17D1Ev,_ZTv0_n24_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C17D0Ev,_ZTv0_n24_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  0,
  ABISELECT(-121344,-78716),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-121344,-78716),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C17D1Ev,_ZTv0_n20_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C17D0Ev,_ZTv0_n20_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-122320,-79344),
  ABISELECT(-122320,-79344),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C17D1Ev,_ZTv0_n12_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C17D0Ev,_ZTv0_n12_N8S7394C17D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  ABISELECT(-122816,-79668),
  ABISELECT(-496,-324),
  ABISELECT(-16304,-10560),
  ABISELECT(-1472,-952),
  ABISELECT(-16256,-10528),
  ABISELECT(-122816,-79668),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C17D1Ev,_ZTv0_n28_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C17D0Ev,_ZTv0_n28_N8S7394C17D0Ev),
  ABISELECT(-122848,-79684),
  ABISELECT(-528,-340),
  ABISELECT(-16336,-10576),
  ABISELECT(-1504,-968),
  ABISELECT(-122848,-79684),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C17D1Ev,_ZTv0_n24_N8S7394C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C17D0Ev,_ZTv0_n24_N8S7394C17D0Ev),
  ABISELECT(-16448,-10660),
  ABISELECT(-122960,-79768),
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
};
extern VTBL_ENTRY _ZTV8S7394C17[];
extern void _ZN8S7394C18D1Ev();
extern void _ZN8S7394C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C18__A__8S7394C17[] = {
  ABISELECT(122320,79344),
  ABISELECT(106512,69108),
  ABISELECT(121344,78716),
  ABISELECT(106560,69140),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&_ZN8S7394C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C18D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn106560_N8S7394C18D1Ev,_ZThn69140_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn106560_N8S7394C18D0Ev,_ZThn69140_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C18__A__8S7394C17[] = {
  0,
  ABISELECT(-106560,-69140),
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  ABISELECT(-106560,-69140),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn121344_N8S7394C18D1Ev,_ZThn78716_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn121344_N8S7394C18D0Ev,_ZThn78716_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C18__A__8S7394C17[] = {
  0,
  ABISELECT(-121344,-78716),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-121344,-78716),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn122320_N8S7394C18D1Ev,_ZThn79344_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn122320_N8S7394C18D0Ev,_ZThn79344_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C18__A__8S7394C17[] = {
  0,
  0,
  ABISELECT(-122320,-79344),
  ABISELECT(-122320,-79344),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C19D1Ev();
extern void _ZN8S7394C19D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C19__8S7394C17[] = {
  ABISELECT(122784,79652),
  ABISELECT(122928,79752),
  ABISELECT(106528,69124),
  ABISELECT(121312,78700),
  ABISELECT(122816,79668),
  ABISELECT(122288,79328),
  ABISELECT(106480,69092),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&_ZN8S7394C19D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C19D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN8S7394C10D1Ev();
extern void _ZN8S7394C10D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C108S7394C19__8S7394C17[] = {
  ABISELECT(122928,79752),
  ABISELECT(106528,69124),
  ABISELECT(121312,78700),
  ABISELECT(122816,79668),
  ABISELECT(122288,79328),
  ABISELECT(106480,69092),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&_ZN8S7394C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C10D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C88S7394C108S7394C19__A1__8S7394C17[] = {
  ABISELECT(122288,79328),
  ABISELECT(106480,69092),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C88S7394C108S7394C19__A1__8S7394C17[] = {
  ABISELECT(106480,69092),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn122288_N7S7394C8D1Ev,_ZThn79328_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn122288_N7S7394C8D0Ev,_ZThn79328_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C88S7394C108S7394C19__A1__8S7394C17[] = {
  0,
  0,
  ABISELECT(-122288,-79328),
  ABISELECT(-122288,-79328),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C10D1Ev,_ZThn79668_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C10D0Ev,_ZThn79668_N8S7394C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C108S7394C19__8S7394C17[] = {
  ABISELECT(-122816,-79668),
  ABISELECT(-528,-340),
  ABISELECT(-16336,-10576),
  ABISELECT(-1504,-968),
  ABISELECT(-122816,-79668),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn121312_N8S7394C10D1Ev,_ZThn78700_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn121312_N8S7394C10D0Ev,_ZThn78700_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C108S7394C19__8S7394C17[] = {
  0,
  ABISELECT(-121312,-78700),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-121312,-78700),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn122288_N8S7394C10D1Ev,_ZThn79328_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn122288_N8S7394C10D0Ev,_ZThn79328_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C108S7394C19__8S7394C17[] = {
  0,
  0,
  ABISELECT(-122288,-79328),
  ABISELECT(-122288,-79328),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn106528_N8S7394C10D1Ev,_ZThn69124_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn106528_N8S7394C10D0Ev,_ZThn69124_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C108S7394C19__8S7394C17[] = {
  0,
  ABISELECT(-106528,-69124),
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  ABISELECT(-106528,-69124),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C108S7394C19__8S7394C17[] = {
  ABISELECT(-16448,-10660),
  ABISELECT(-122928,-79752),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
};
extern void _ZN8S7394C14D1Ev();
extern void _ZN8S7394C14D0Ev();
extern void _ZN8S7394C142v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C148S7394C19__8S7394C17[] = {
  ABISELECT(121248,78656),
  ABISELECT(105440,68420),
  ABISELECT(120272,78028),
  ABISELECT(121776,78996),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&_ZN8S7394C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn121776_N8S7394C14D1Ev,_ZThn78996_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn121776_N8S7394C14D0Ev,_ZThn78996_N8S7394C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C148S7394C19__8S7394C17[] = {
  ABISELECT(-121776,-78996),
  ABISELECT(-528,-340),
  ABISELECT(-16336,-10576),
  ABISELECT(-1504,-968),
  ABISELECT(-121776,-78996),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn120272_N8S7394C14D1Ev,_ZThn78028_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn120272_N8S7394C14D0Ev,_ZThn78028_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C148S7394C19__8S7394C17[] = {
  0,
  ABISELECT(-120272,-78028),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-120272,-78028),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn121248_N8S7394C14D1Ev,_ZThn78656_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn121248_N8S7394C14D0Ev,_ZThn78656_N8S7394C14D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C148S7394C19__8S7394C17[] = {
  0,
  0,
  ABISELECT(-121248,-78656),
  ABISELECT(-121248,-78656),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn122784_N8S7394C19D1Ev,_ZThn79652_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn122784_N8S7394C19D0Ev,_ZThn79652_N8S7394C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S7394C18__8S7394C19__8S7394C17[] = {
  ABISELECT(-122784,-79652),
  ABISELECT(-496,-324),
  ABISELECT(-16304,-10560),
  ABISELECT(-1472,-952),
  ABISELECT(-16256,-10528),
  ABISELECT(-122784,-79652),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev),
};
extern void ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn106528_N8S7394C19D1Ev,_ZThn69124_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn106528_N8S7394C19D0Ev,_ZThn69124_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C19__8S7394C17[] = {
  0,
  ABISELECT(-106528,-69124),
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  ABISELECT(-106528,-69124),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn121312_N8S7394C19D1Ev,_ZThn78700_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn121312_N8S7394C19D0Ev,_ZThn78700_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C19__8S7394C17[] = {
  0,
  ABISELECT(-121312,-78700),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-121312,-78700),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn122288_N8S7394C19D1Ev,_ZThn79328_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn122288_N8S7394C19D0Ev,_ZThn79328_N8S7394C19D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C19__8S7394C17[] = {
  0,
  0,
  ABISELECT(-122288,-79328),
  ABISELECT(-122288,-79328),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C19D1Ev,_ZThn79668_N8S7394C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev)();
extern void ABISELECT(_ZThn122816_N8S7394C19D0Ev,_ZThn79668_N8S7394C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C19__8S7394C17[] = {
  ABISELECT(-122816,-79668),
  ABISELECT(-528,-340),
  ABISELECT(-16336,-10576),
  ABISELECT(-1504,-968),
  ABISELECT(-122816,-79668),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C19__8S7394C17[] = {
  ABISELECT(-16448,-10660),
  ABISELECT(-122928,-79752),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
};
extern void ABISELECT(_ZThn1040_N8S7394C19D1Ev,_ZThn672_N8S7394C19D1Ev)();
extern void ABISELECT(_ZThn1040_N8S7394C19D0Ev,_ZThn672_N8S7394C19D0Ev)();
extern void _ZN8S7394C142v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C14__8S7394C19__8S7394C17[] = {
  ABISELECT(121248,78656),
  ABISELECT(105440,68420),
  ABISELECT(120272,78028),
  ABISELECT(121776,78996),
  ABISELECT(-1040,-672),
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1040_N8S7394C19D1Ev,_ZThn672_N8S7394C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1040_N8S7394C19D0Ev,_ZThn672_N8S7394C19D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__A__8S7394C17[] = {
  ABISELECT(120256,78012),
  ABISELECT(104448,67776),
  ABISELECT(119280,77384),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn119280_N8S7394C11D1Ev,_ZThn77384_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn119280_N8S7394C11D0Ev,_ZThn77384_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__A__8S7394C17[] = {
  0,
  ABISELECT(-119280,-77384),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-119280,-77384),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn120256_N8S7394C11D1Ev,_ZThn78012_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn120256_N8S7394C11D0Ev,_ZThn78012_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__A__8S7394C17[] = {
  0,
  0,
  ABISELECT(-120256,-78012),
  ABISELECT(-120256,-78012),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C15D1Ev();
extern void _ZN8S7394C15D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C15__8S7394C17[] = {
  ABISELECT(105472,68436),
  ABISELECT(89664,58200),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&_ZN8S7394C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C15D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C88S7394C15__A2__8S7394C17[] = {
  ABISELECT(105472,68436),
  ABISELECT(89664,58200),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C88S7394C15__A3__8S7394C17[] = {
  ABISELECT(89664,58200),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn105472_N7S7394C8D1Ev,_ZThn68436_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn105472_N7S7394C8D0Ev,_ZThn68436_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C88S7394C15__A2__8S7394C17[] = {
  0,
  0,
  ABISELECT(-105472,-68436),
  ABISELECT(-105472,-68436),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev)();
extern void ABISELECT(_ZThn105472_N8S7394C15D1Ev,_ZThn68436_N8S7394C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev)();
extern void ABISELECT(_ZThn105472_N8S7394C15D0Ev,_ZThn68436_N8S7394C15D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C15__8S7394C17[] = {
  0,
  0,
  ABISELECT(-105472,-68436),
  ABISELECT(-105472,-68436),
  (VTBL_ENTRY)&(_ZTI8S7394C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C11D1Ev();
extern void _ZN8S7394C11D0Ev();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C17[] = {
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&_ZN8S7394C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C11D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C11__8S7394C17[] = {
  0,
  ABISELECT(-14784,-9576),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(-14784,-9576),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev)();
extern void ABISELECT(_ZThn15760_N8S7394C11D1Ev,_ZThn10204_N8S7394C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev)();
extern void ABISELECT(_ZThn15760_N8S7394C11D0Ev,_ZThn10204_N8S7394C11D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C11__8S7394C17[] = {
  0,
  0,
  ABISELECT(-15760,-10204),
  ABISELECT(-15760,-10204),
  (VTBL_ENTRY)&(_ZTI8S7394C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C17[] = {
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C8__8S7394C17[] = {
  ABISELECT(-14832,-9608),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn976_N7S7394C8D1Ev,_ZThn628_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn976_N7S7394C8D0Ev,_ZThn628_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C8__8S7394C17[] = {
  0,
  0,
  ABISELECT(-976,-628),
  ABISELECT(-976,-628),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C18D1Ev();
extern void _ZN8S7394C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C18__A1__8S7394C17[] = {
  ABISELECT(-496,-324),
  ABISELECT(-16304,-10560),
  ABISELECT(-1472,-952),
  ABISELECT(-16256,-10528),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&_ZN8S7394C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C18D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev)();
extern void ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev)();
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C18__A1__8S7394C17[] = {
  0,
  ABISELECT(16256,10528),
  ABISELECT(15760,10204),
  ABISELECT(-48,-32),
  ABISELECT(14784,9576),
  ABISELECT(16256,10528),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C18__A1__8S7394C17[] = {
  0,
  ABISELECT(1472,952),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(1472,952),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C18__A1__8S7394C17[] = {
  0,
  0,
  ABISELECT(496,324),
  ABISELECT(496,324),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN7S7394C7D1Ev();
extern void _ZN7S7394C7D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C17[] = {
  ABISELECT(-528,-340),
  ABISELECT(-16336,-10576),
  ABISELECT(-1504,-968),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&_ZN7S7394C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C7D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev)();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__7S7394C7__8S7394C17[] = {
  0,
  ABISELECT(1504,968),
  ABISELECT(976,628),
  ABISELECT(-14832,-9608),
  ABISELECT(1504,968),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D1Ev,_ZTv0_n20_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S7394C7D0Ev,_ZTv0_n20_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev)();
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C7__8S7394C17[] = {
  0,
  0,
  ABISELECT(528,340),
  ABISELECT(528,340),
  (VTBL_ENTRY)&(_ZTI7S7394C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D1Ev,_ZTv0_n12_N7S7394C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C7D0Ev,_ZTv0_n12_N7S7394C7D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C17[] = {
  ABISELECT(-16448,-10660),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
static  VTT_ENTRY vtt_S7394C17[] = {
  {&(_ZTV8S7394C17[9]),  9,95},
  {&(_tg__ZTV8S7394C18__A__8S7394C17[6]),  6,8},
  {&(_tg__ZTV8S7394C11__8S7394C18__A__8S7394C17[7]),  7,10},
  {&(_tg__ZTV7S7394C8__8S7394C18__A__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C18__A__8S7394C17[5]),  5,9},
  {&(_tg__ZTV8S7394C19__8S7394C17[9]),  9,12},
  {&(_tg__ZTV8S7394C108S7394C19__8S7394C17[8]),  8,11},
  {&(_tg__ZTV7S7394C88S7394C108S7394C19__A1__8S7394C17[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C88S7394C108S7394C19__A1__8S7394C17[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C88S7394C108S7394C19__A1__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C108S7394C19__8S7394C17[6]),  6,8},
  {&(_tg__ZTV7S7394C8__8S7394C108S7394C19__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C108S7394C19__8S7394C17[5]),  5,9},
  {&(_tg__ZTV8S7394C11__8S7394C108S7394C19__8S7394C17[7]),  7,10},
  {&(_tg__ZTV7S7394C2__A2__8S7394C108S7394C19__8S7394C17[3]),  3,3},
  {&(_tg__ZTV8S7394C148S7394C19__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C7__8S7394C148S7394C19__8S7394C17[6]),  6,8},
  {&(_tg__ZTV7S7394C8__8S7394C148S7394C19__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C148S7394C19__8S7394C17[5]),  5,9},
  {&(_tg__ZTV8S7394C18__8S7394C19__8S7394C17[7]),  7,9},
  {&(_tg__ZTV8S7394C11__8S7394C19__8S7394C17[7]),  7,10},
  {&(_tg__ZTV7S7394C8__8S7394C19__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C19__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C19__8S7394C17[6]),  6,8},
  {&(_tg__ZTV7S7394C2__A2__8S7394C19__8S7394C17[3]),  3,3},
  {&(_tg__ZTV8S7394C14__8S7394C19__8S7394C17[6]),  6,9},
  {&(_tg__ZTV8S7394C11__A__8S7394C17[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__A__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__A__8S7394C17[5]),  5,9},
  {&(_tg__ZTV8S7394C15__8S7394C17[4]),  4,7},
  {&(_tg__ZTV7S7394C88S7394C15__A2__8S7394C17[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C88S7394C15__A3__8S7394C17[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C88S7394C15__A2__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C5__8S7394C15__8S7394C17[5]),  5,9},
  {&(_ZTV8S7394C17[54]),  54,95},
  {&(_ZTV8S7394C17[63]),  63,95},
  {&(_ZTV8S7394C17[71]),  71,95},
  {&(_ZTV8S7394C17[20]),  20,95},
  {&(_ZTV8S7394C17[82]),  82,95},
  {&(_ZTV8S7394C17[90]),  90,95},
  {&(_ZTV8S7394C17[95]),  95,95},
  {&(_ZTV8S7394C17[29]),  29,95},
  {&(_ZTV8S7394C17[37]),  37,95},
  {&(_ZTV8S7394C17[44]),  44,95},
  {&(_tg__ZTV8S7394C11__8S7394C17[5]),  5,8},
  {&(_tg__ZTV7S7394C8__8S7394C11__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C11__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C8__8S7394C17[4]),  4,7},
  {&(_tg__ZTV7S7394C27S7394C8__8S7394C17[3]),  3,3},
  {&(_tg__ZTV7S7394C5__7S7394C8__8S7394C17[5]),  5,9},
  {&(_tg__ZTV8S7394C18__A1__8S7394C17[6]),  6,8},
  {&(_tg__ZTV8S7394C11__8S7394C18__A1__8S7394C17[7]),  7,10},
  {&(_tg__ZTV7S7394C8__8S7394C18__A1__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__8S7394C18__A1__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C7__8S7394C17[5]),  5,7},
  {&(_tg__ZTV7S7394C8__7S7394C7__8S7394C17[6]),  6,9},
  {&(_tg__ZTV7S7394C5__7S7394C7__8S7394C17[5]),  5,9},
  {&(_tg__ZTV7S7394C2__A2__8S7394C17[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S7394C17[];
extern  VTBL_ENTRY _ZTV8S7394C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C17[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C15D0Ev,_ZTv0_n12_N8S7394C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn105472_N8S7394C15D0Ev,_ZThn68436_N8S7394C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C15D1Ev,_ZTv0_n12_N8S7394C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn105472_N8S7394C15D1Ev,_ZThn68436_N8S7394C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D0Ev,_ZTv0_n12_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15760_N8S7394C11D0Ev,_ZThn10204_N8S7394C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120256_N8S7394C11D0Ev,_ZThn78012_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C11D1Ev,_ZTv0_n12_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15760_N8S7394C11D1Ev,_ZThn10204_N8S7394C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120256_N8S7394C11D1Ev,_ZThn78012_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D0Ev,_ZTv0_n20_N8S7394C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D0Ev,_ZThn9576_N8S7394C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn119280_N8S7394C11D0Ev,_ZThn77384_N8S7394C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C11D1Ev,_ZTv0_n20_N8S7394C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14784_N8S7394C11D1Ev,_ZThn9576_N8S7394C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn119280_N8S7394C11D1Ev,_ZThn77384_N8S7394C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C19D0Ev,_ZTv0_n12_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N8S7394C19D0Ev,_ZThn79328_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C19D1Ev,_ZTv0_n12_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N8S7394C19D1Ev,_ZThn79328_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C19D0Ev,_ZTv0_n20_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121312_N8S7394C19D0Ev,_ZThn78700_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C19D1Ev,_ZTv0_n20_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121312_N8S7394C19D1Ev,_ZThn78700_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C19D0Ev,_ZTv0_n24_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C19D0Ev,_ZThn79668_N8S7394C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn106528_N8S7394C19D0Ev,_ZThn69124_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C19D1Ev,_ZTv0_n24_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C19D1Ev,_ZThn79668_N8S7394C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn106528_N8S7394C19D1Ev,_ZThn69124_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C19D0Ev,_ZTv0_n28_N8S7394C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122784_N8S7394C19D0Ev,_ZThn79652_N8S7394C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C19D1Ev,_ZTv0_n28_N8S7394C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122784_N8S7394C19D1Ev,_ZThn79652_N8S7394C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D0Ev,_ZTv0_n12_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121248_N8S7394C14D0Ev,_ZThn78656_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C14D1Ev,_ZTv0_n12_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121248_N8S7394C14D1Ev,_ZThn78656_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D0Ev,_ZTv0_n20_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120272_N8S7394C14D0Ev,_ZThn78028_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C14D1Ev,_ZTv0_n20_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120272_N8S7394C14D1Ev,_ZThn78028_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121776_N8S7394C14D0Ev,_ZThn78996_N8S7394C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121776_N8S7394C14D1Ev,_ZThn78996_N8S7394C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N8S7394C10D0Ev,_ZThn79328_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N8S7394C10D1Ev,_ZThn79328_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121312_N8S7394C10D0Ev,_ZThn78700_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121312_N8S7394C10D1Ev,_ZThn78700_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn106528_N8S7394C10D0Ev,_ZThn69124_N8S7394C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C10D0Ev,_ZThn79668_N8S7394C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn106528_N8S7394C10D1Ev,_ZThn69124_N8S7394C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C10D1Ev,_ZThn79668_N8S7394C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn976_N7S7394C8D0Ev,_ZThn628_N7S7394C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn105472_N7S7394C8D0Ev,_ZThn68436_N7S7394C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N7S7394C8D0Ev,_ZThn79328_N7S7394C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn976_N7S7394C8D1Ev,_ZThn628_N7S7394C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn105472_N7S7394C8D1Ev,_ZThn68436_N7S7394C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn122288_N7S7394C8D1Ev,_ZThn79328_N7S7394C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122320_N8S7394C18D0Ev,_ZThn79344_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122320_N8S7394C18D1Ev,_ZThn79344_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121344_N8S7394C18D0Ev,_ZThn78716_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121344_N8S7394C18D1Ev,_ZThn78716_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn106560_N8S7394C18D0Ev,_ZThn69140_N8S7394C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn106560_N8S7394C18D1Ev,_ZThn69140_N8S7394C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C17D0Ev,_ZTv0_n28_N8S7394C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C17D0Ev,_ZThn79668_N8S7394C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7394C17D1Ev,_ZTv0_n28_N8S7394C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122816_N8S7394C17D1Ev,_ZThn79668_N8S7394C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C17D0Ev,_ZTv0_n12_N8S7394C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122320_N8S7394C17D0Ev,_ZThn79344_N8S7394C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7394C17D1Ev,_ZTv0_n12_N8S7394C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122320_N8S7394C17D1Ev,_ZThn79344_N8S7394C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C17D0Ev,_ZTv0_n20_N8S7394C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121344_N8S7394C17D0Ev,_ZThn78716_N8S7394C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S7394C17D1Ev,_ZTv0_n20_N8S7394C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn121344_N8S7394C17D1Ev,_ZThn78716_N8S7394C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C17D0Ev,_ZTv0_n24_N8S7394C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122848_N8S7394C17D0Ev,_ZThn79684_N8S7394C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn106560_N8S7394C17D0Ev,_ZThn69140_N8S7394C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S7394C17D1Ev,_ZTv0_n24_N8S7394C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn122848_N8S7394C17D1Ev,_ZThn79684_N8S7394C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn106560_N8S7394C17D1Ev,_ZThn69140_N8S7394C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7394C17 = {  "S7394C17", // class name
  bases_S7394C17, 22,
  &(vtc_S7394C17[0]), // expected_vtbl_contents
  &(vtt_S7394C17[0]), // expected_vtt_contents
  ABISELECT(123216,79932), // object size
  NSPAIRA(_ZTI8S7394C17),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S7394C17),95, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7394C17),58, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7394C12  : virtual S7394C13 , virtual S7394C2 , S7394C17 , S7394C19 {
  __tsi64 s7394c12f0:4;
  long double s7394c12f1;
  __tsi64 s7394c12f2;
  ::S7394C3 s7394c12f3;
  int s7394c12f4[9];
  virtual  ~S7394C12(); // _ZN8S7394C12D2Ev
  S7394C12(); // tgen
};
//SIG(-1 S7394C12) C1{ VBC2{ VBC3{ VBC4{ VBC5{ BC6{ m FD[2] Fc[8]} BC7{ VBC6 FL[4] FC6 Fi FC6 FL Fp FC6 Fp[4]} VBC8{ vd v1 v2 FC7 Fp FL Fi Fp FU9{ m FD FL FD FL Fi}[8] Fc Fp} vd v3 Fp[4] FL Fp[3] FU9 FC8 FD Fs:0 FC6 FD Fp} BC10{ m FL[4] Fc:1 FL[2] FL:4} vd FD FL FL:13} vd v4 FC8 Fi Fi FU9} VBC11{ BC5 vd FC7 Fp[5] Fi FL[9] FC12{} FL[6] Fc:0 FL FD FU9 FC6 Fi Fi Fl} VBC13{ VBC5 vd v5 Fs FL FC8 FC6[5] FC5[8] FC7[5] FC7 Fp FL FL Fi[2]} v6 Fi Fi FC13 FL Fi FD Fp Fi} VBC7 BC14{ VBC6 BC15{ VBC13 vd Fc:0 FL:64 Fi} BC16{ VBC15 BC17{ VBC4 BC5 VBC13 VBC7 vd FL FD Fp[6]} BC3 vd Fi Fi FC7 FC6 Fi FL Fi FL[3] FL FL FL:25} BC13 BC11 vd FL Fi FL Fi Fc FC18{ BC8 v7 Fp Fi FC4} Fp FL[6] FL FL[10] FC19{ VBC5 VBC13 vd v8 Fl Fi Fi FL Fc:8 FL FC7 FC8}[5] Fi} BC16 vd FL:4 FD FL FC6 Fi[9]}


 S7394C12 ::~S7394C12(){ note_dtor("S7394C12", this);}
S7394C12 ::S7394C12(){ note_ctor("S7394C12", this);} // tgen

static void Test_S7394C12()
{
  extern Class_Descriptor cd_S7394C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(8992,23336)];
    init_test(&cd_S7394C12, buf);
    S7394C12 *dp, &lv = *(dp=new (buf) S7394C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(143856,93340), "sizeof(S7394C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7394C12)");
    /*is_ambiguous_... S7394C12::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*), ABISELECT(125952,81716), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C15 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C17::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C17*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(126672,82180), "S7394C12");
    check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C15*)(S7394C17*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(126672,82180), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*), ABISELECT(125696,81552), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*), ABISELECT(126720,82212), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C15 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C15*), ABISELECT(126720,82212), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(126720,82212), "S7394C12");
    check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C15*)(S7394C17*), ABISELECT(126720,82212), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C5*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(126720,82212), "S7394C12");
    check_base_class_offset(lv, (S7394C8*)(S7394C7*), ABISELECT(125696,81552), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C11*), ABISELECT(125696,81552), "S7394C12");
    /*is_ambiguous_... S7394C17::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C11*)(S7394C17*), ABISELECT(125696,81552), "S7394C12");
    check_base_class_offset(lv, (S7394C9*)(S7394C7*), ABISELECT(125592,81472), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C14 */ AMB_check_base_class_offset(lv, (S7394C7*)(S7394C14*), ABISELECT(125584,81468), "S7394C12");
    check_base_class_offset(lv, (S7394C7*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(125584,81468), "S7394C12");
    check_base_class_offset(lv, (S7394C7*)(S7394C14*)(S7394C19*)(S7394C17*), ABISELECT(125584,81468), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C7*)(S7394C10*)(S7394C19*), ABISELECT(125584,81468), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C7*)(S7394C14*)(S7394C19*), ABISELECT(125584,81468), "S7394C12");
    check_base_class_offset(lv, (S7394C14*)(S7394C13*), ABISELECT(125040,81120), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C15 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C15*), ABISELECT(127472,82700), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C15 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C15*), ABISELECT(127216,82536), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C15 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C15*), ABISELECT(127216,82536), "S7394C12");
    check_base_class_offset(lv, (S7394C15*)(S7394C13*), ABISELECT(127216,82536), "S7394C12");
    check_base_class_offset(lv, (S7394C11*)(S7394C13*), ABISELECT(128784,83584), "S7394C12");
    /*is_ambiguous_... S7394C17::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C18*)(S7394C17*), ABISELECT(128784,83584), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C18*), ABISELECT(128784,83584), "S7394C12");
    check_base_class_offset(lv, (S7394C11*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(128784,83584), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C10*)(S7394C19*), ABISELECT(128784,83584), "S7394C12");
    check_base_class_offset(lv, (S7394C13*), ABISELECT(108672,70516), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C2*), ABISELECT(143568,93160), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C2 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(143568,93160), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C10*)(S7394C19*), ABISELECT(143568,93160), "S7394C12");
    /*is_ambiguous_... S7394C17::S7394C18 */ AMB_check_base_class_offset(lv, (S7394C18*)(S7394C17*), 0, "S7394C12");
    check_base_class_offset(lv, (S7394C18*)(S7394C19*)(S7394C17*), ABISELECT(143824,93324), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C18*)(S7394C19*), ABISELECT(143824,93324), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(288,180), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(32,16), "S7394C12");
    /*is_ambiguous_... S7394C10::S7394C8 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(32,16), "S7394C12");
    check_base_class_offset(lv, (S7394C10*)(S7394C19*)(S7394C17*), ABISELECT(32,16), "S7394C12");
    check_base_class_offset(lv, (S7394C14*)(S7394C19*)(S7394C17*), ABISELECT(1072,688), "S7394C12");
    check_base_class_offset(lv, (S7394C19*)(S7394C17*), ABISELECT(32,16), "S7394C12");
    /*is_ambiguous_... S7394C17::S7394C11 */ AMB_check_base_class_offset(lv, (S7394C11*)(S7394C17*), ABISELECT(2064,1332), "S7394C12");
    /*is_ambiguous_... S7394C8::S7394C3 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C15*)(S7394C17*), ABISELECT(17104,11072), "S7394C12");
    check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C15*)(S7394C17*), ABISELECT(16848,10908), "S7394C12");
    check_base_class_offset(lv, (S7394C8*)(S7394C15*)(S7394C17*), ABISELECT(16848,10908), "S7394C12");
    check_base_class_offset(lv, (S7394C15*)(S7394C17*), ABISELECT(16848,10908), "S7394C12");
    check_base_class_offset(lv, (S7394C17*), 0, "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C3*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(106768,69272), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C2*)(S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(106512,69108), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C8*)(S7394C10*)(S7394C19*), ABISELECT(106512,69108), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C10*)(S7394C19*), ABISELECT(106512,69108), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C14*)(S7394C19*), ABISELECT(107552,69780), "S7394C12");
    /*is_ambiguous_... S7394C12::S7394C19 */ AMB_check_base_class_offset(lv, (S7394C19*), ABISELECT(106512,69108), "S7394C12");
    set_bf_and_test(lv, s7394c12f0, ABISELECT(108532,70424), 0, 4, 1, "S7394C12");
    set_bf_and_test(lv, s7394c12f0, ABISELECT(108532,70424), 0, 4, hide_sll(1LL<<3), "S7394C12");
    check_field_offset(lv, s7394c12f1, ABISELECT(108544,70428), "S7394C12.s7394c12f1");
    check_field_offset(lv, s7394c12f2, ABISELECT(108560,70440), "S7394C12.s7394c12f2");
    check_field_offset(lv, s7394c12f3, ABISELECT(108576,70448), "S7394C12.s7394c12f3");
    check_field_offset(lv, s7394c12f4, ABISELECT(108624,70480), "S7394C12.s7394c12f4");
    test_class_info(&lv, &cd_S7394C12);
    dp->~S7394C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7394C12(Test_S7394C12, "S7394C12", ABISELECT(143856,93340));

#else // __cplusplus

extern void _ZN8S7394C12C1Ev();
extern void _ZN8S7394C12D2Ev();
Name_Map name_map_S7394C12[] = {
  NSPAIR(_ZN8S7394C12C1Ev),
  NSPAIR(_ZN8S7394C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C5;
extern VTBL_ENTRY _ZTI7S7394C5[];
extern  VTBL_ENTRY _ZTV7S7394C5[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C9;
extern VTBL_ENTRY _ZTI7S7394C9[];
extern Class_Descriptor cd_S7394C7;
extern VTBL_ENTRY _ZTI7S7394C7[];
extern  VTBL_ENTRY _ZTV7S7394C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C7[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C15;
extern VTBL_ENTRY _ZTI8S7394C15[];
extern  VTBL_ENTRY _ZTV8S7394C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C15[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C13;
extern VTBL_ENTRY _ZTI8S7394C13[];
extern  VTBL_ENTRY _ZTV8S7394C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C13[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C18;
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
extern Class_Descriptor cd_S7394C18;
extern VTBL_ENTRY _ZTI8S7394C18[];
extern  VTBL_ENTRY _ZTV8S7394C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C18[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C10;
extern VTBL_ENTRY _ZTI8S7394C10[];
extern  VTBL_ENTRY _ZTV8S7394C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C10[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
extern Class_Descriptor cd_S7394C19;
extern VTBL_ENTRY _ZTI8S7394C19[];
extern  VTBL_ENTRY _ZTV8S7394C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C19[];
extern Class_Descriptor cd_S7394C11;
extern VTBL_ENTRY _ZTI8S7394C11[];
extern  VTBL_ENTRY _ZTV8S7394C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C11[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C15;
extern VTBL_ENTRY _ZTI8S7394C15[];
extern  VTBL_ENTRY _ZTV8S7394C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C15[];
extern Class_Descriptor cd_S7394C17;
extern VTBL_ENTRY _ZTI8S7394C17[];
extern  VTBL_ENTRY _ZTV8S7394C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C17[];
extern Class_Descriptor cd_S7394C3;
extern VTBL_ENTRY _ZTI7S7394C3[];
extern Class_Descriptor cd_S7394C2;
extern VTBL_ENTRY _ZTI7S7394C2[];
extern  VTBL_ENTRY _ZTV7S7394C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C2[];
extern Class_Descriptor cd_S7394C8;
extern VTBL_ENTRY _ZTI7S7394C8[];
extern  VTBL_ENTRY _ZTV7S7394C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7394C8[];
extern Class_Descriptor cd_S7394C10;
extern VTBL_ENTRY _ZTI8S7394C10[];
extern  VTBL_ENTRY _ZTV8S7394C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C10[];
extern Class_Descriptor cd_S7394C14;
extern VTBL_ENTRY _ZTI8S7394C14[];
extern  VTBL_ENTRY _ZTV8S7394C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C14[];
extern Class_Descriptor cd_S7394C19;
extern VTBL_ENTRY _ZTI8S7394C19[];
extern  VTBL_ENTRY _ZTV8S7394C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7394C19[];
static Base_Class bases_S7394C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7394C3,    ABISELECT(125952,81716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(126672,82180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7394C2,    ABISELECT(125696,81552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S7394C5,    ABISELECT(126720,82212), //bcp->offset
    113, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    71, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7394C8,    ABISELECT(125696,81552), //bcp->offset
    104, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    70, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7394C9,    ABISELECT(125592,81472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S7394C7,    ABISELECT(125584,81468), //bcp->offset
    96, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    69, //bcp->index_in_construction_vtbl_array
    93, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S7394C14,    ABISELECT(125040,81120), //bcp->offset
    85, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    68, //bcp->index_in_construction_vtbl_array
    89, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7394C3,    ABISELECT(127472,82700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(127216,82536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    101, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(127216,82536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    100, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7394C15,    ABISELECT(127216,82536), //bcp->offset
    122, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    72, //bcp->index_in_construction_vtbl_array
    99, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7394C11,    ABISELECT(128784,83584), //bcp->offset
    131, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    73, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7394C13,    ABISELECT(108672,70516), //bcp->offset
    71, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    67, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C2,    ABISELECT(143568,93160), //bcp->offset
    141, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    74, //bcp->index_in_construction_vtbl_array
    107, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7394C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S7394C18,    ABISELECT(143824,93324), //bcp->offset
    144, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    76, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S7394C3,    ABISELECT(288,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7394C10,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7394C14,    ABISELECT(1072,688), //bcp->offset
    26, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    77, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S7394C19,    ABISELECT(32,16), //bcp->offset
    14, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    75, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S7394C11,    ABISELECT(2064,1332), //bcp->offset
    35, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    78, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S7394C3,    ABISELECT(17104,11072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(16848,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(16848,10908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S7394C15,    ABISELECT(16848,10908), //bcp->offset
    43, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    79, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S7394C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7394C3,    ABISELECT(106768,69272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7394C2,    ABISELECT(106512,69108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S7394C8,    ABISELECT(106512,69108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S7394C10,    ABISELECT(106512,69108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7394C14,    ABISELECT(107552,69780), //bcp->offset
    62, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    81, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S7394C19,    ABISELECT(106512,69108), //bcp->offset
    50, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    80, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7394C12[];
extern void _ZN8S7394C12D1Ev();
extern void _ZN8S7394C12D0Ev();
extern void ABISELECT(_ZThn32_N8S7394C12D1Ev,_ZThn16_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S7394C12D0Ev,_ZThn16_N8S7394C12D0Ev)();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZThn1072_N8S7394C12D1Ev,_ZThn688_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn1072_N8S7394C12D0Ev,_ZThn688_N8S7394C12D0Ev)();
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZThn2064_N8S7394C12D1Ev,_ZThn1332_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn2064_N8S7394C12D0Ev,_ZThn1332_N8S7394C12D0Ev)();
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZThn16848_N8S7394C12D1Ev,_ZThn10908_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn16848_N8S7394C12D0Ev,_ZThn10908_N8S7394C12D0Ev)();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZThn106512_N8S7394C12D1Ev,_ZThn69108_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn106512_N8S7394C12D0Ev,_ZThn69108_N8S7394C12D0Ev)();
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZThn107552_N8S7394C12D1Ev,_ZThn69780_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn107552_N8S7394C12D0Ev,_ZThn69780_N8S7394C12D0Ev)();
extern void _ZN8S7394C142v5Ev();
extern void _ZN8S7394C132v7Ev();
extern void ABISELECT(_ZTv0_n88_N8S7394C12D1Ev,_ZTv0_n44_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn108672_N8S7394C12D1Ev,_ZThn70516_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S7394C12D0Ev,_ZTv0_n44_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn108672_N8S7394C12D0Ev,_ZThn70516_N8S7394C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C12D1Ev,_ZTv0_n28_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn125040_N8S7394C12D1Ev,_ZThn81120_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C12D0Ev,_ZTv0_n28_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn125040_N8S7394C12D0Ev,_ZThn81120_N8S7394C12D0Ev)() __attribute__((weak));
extern void _ZN8S7394C142v5Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C12D1Ev,_ZTv0_n24_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn125584_N8S7394C12D1Ev,_ZThn81468_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C12D0Ev,_ZTv0_n24_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn125584_N8S7394C12D0Ev,_ZThn81468_N8S7394C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C12D1Ev,_ZTv0_n20_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn125696_N8S7394C12D1Ev,_ZThn81552_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C12D0Ev,_ZTv0_n20_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn125696_N8S7394C12D0Ev,_ZThn81552_N8S7394C12D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S7394C12D1Ev,_ZTv0_n12_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn126720_N8S7394C12D1Ev,_ZThn82212_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C12D0Ev,_ZTv0_n12_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn126720_N8S7394C12D0Ev,_ZThn82212_N8S7394C12D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S7394C12D1Ev,_ZTv0_n20_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn127216_N8S7394C12D1Ev,_ZThn82536_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C12D0Ev,_ZTv0_n20_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn127216_N8S7394C12D0Ev,_ZThn82536_N8S7394C12D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S7394C12D1Ev,_ZTv0_n24_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn128784_N8S7394C12D1Ev,_ZThn83584_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C12D0Ev,_ZTv0_n24_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn128784_N8S7394C12D0Ev,_ZThn83584_N8S7394C12D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
extern void ABISELECT(_ZTv0_n56_N8S7394C12D1Ev,_ZTv0_n28_N8S7394C12D1Ev)();
extern void ABISELECT(_ZThn143824_N8S7394C12D1Ev,_ZThn93324_N8S7394C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7394C12D0Ev,_ZTv0_n28_N8S7394C12D0Ev)();
extern void ABISELECT(_ZThn143824_N8S7394C12D0Ev,_ZThn93324_N8S7394C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7394C12[] = {
  ABISELECT(127216,82536),
  ABISELECT(125040,81120),
  ABISELECT(108672,70516),
  ABISELECT(143568,93160),
  ABISELECT(125584,81468),
  ABISELECT(143824,93324),
  ABISELECT(126720,82212),
  ABISELECT(126672,82180),
  ABISELECT(125696,81552),
  ABISELECT(128784,83584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&_ZN8S7394C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C12D0Ev,
  ABISELECT(143792,93308),
  ABISELECT(143536,93144),
  ABISELECT(128752,83568),
  ABISELECT(125664,81536),
  ABISELECT(125552,81452),
  ABISELECT(126688,82196),
  ABISELECT(126640,82164),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7394C12D1Ev,_ZThn16_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S7394C12D0Ev,_ZThn16_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(125648,81524),
  ABISELECT(125600,81492),
  ABISELECT(124624,80864),
  ABISELECT(124512,80780),
  ABISELECT(-1072,-688),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1072_N8S7394C12D1Ev,_ZThn688_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1072_N8S7394C12D0Ev,_ZThn688_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(124656,80880),
  ABISELECT(124608,80848),
  ABISELECT(123632,80220),
  ABISELECT(-2064,-1332),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N8S7394C12D1Ev,_ZThn1332_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N8S7394C12D0Ev,_ZThn1332_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  ABISELECT(109872,71304),
  ABISELECT(109824,71272),
  ABISELECT(-16848,-10908),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16848_N8S7394C12D1Ev,_ZThn10908_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16848_N8S7394C12D0Ev,_ZThn10908_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(37312,24216),
  ABISELECT(37056,24052),
  ABISELECT(22272,14476),
  ABISELECT(19184,12444),
  ABISELECT(19072,12360),
  ABISELECT(20208,13104),
  ABISELECT(20160,13072),
  ABISELECT(-106512,-69108),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn106512_N8S7394C12D1Ev,_ZThn69108_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn106512_N8S7394C12D0Ev,_ZThn69108_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  ABISELECT(19168,12432),
  ABISELECT(19120,12400),
  ABISELECT(18144,11772),
  ABISELECT(18032,11688),
  ABISELECT(-107552,-69780),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn107552_N8S7394C12D1Ev,_ZThn69780_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn107552_N8S7394C12D0Ev,_ZThn69780_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(-108672,-70516),
  0,
  ABISELECT(20112,13068),
  ABISELECT(18544,12020),
  ABISELECT(18048,11696),
  ABISELECT(18000,11664),
  ABISELECT(17024,11036),
  ABISELECT(16912,10952),
  ABISELECT(16368,10604),
  ABISELECT(-108672,-70516),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&_ZN8S7394C132v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S7394C12D1Ev,_ZTv0_n44_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S7394C12D0Ev,_ZTv0_n44_N8S7394C12D0Ev),
  0,
  ABISELECT(-125040,-81120),
  ABISELECT(1680,1092),
  ABISELECT(1632,1060),
  ABISELECT(656,432),
  ABISELECT(544,348),
  ABISELECT(-125040,-81120),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C12D1Ev,_ZTv0_n28_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C12D0Ev,_ZTv0_n28_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
  ABISELECT(-125584,-81468),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-125584,-81468),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C12D1Ev,_ZTv0_n24_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C12D0Ev,_ZTv0_n24_N8S7394C12D0Ev),
  0,
  ABISELECT(-125696,-81552),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-125696,-81552),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C12D1Ev,_ZTv0_n20_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C12D0Ev,_ZTv0_n20_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  0,
  ABISELECT(-126720,-82212),
  ABISELECT(-126720,-82212),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C12D1Ev,_ZTv0_n12_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C12D0Ev,_ZTv0_n12_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
  0,
  ABISELECT(-127216,-82536),
  ABISELECT(-496,-324),
  ABISELECT(-544,-356),
  ABISELECT(-127216,-82536),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C12D1Ev,_ZTv0_n20_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C12D0Ev,_ZTv0_n20_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
  0,
  ABISELECT(-128784,-83584),
  ABISELECT(-2064,-1372),
  ABISELECT(-2112,-1404),
  ABISELECT(-3088,-2032),
  ABISELECT(-128784,-83584),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C12D1Ev,_ZTv0_n24_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C12D0Ev,_ZTv0_n24_N8S7394C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
  ABISELECT(-16896,-10980),
  ABISELECT(-143568,-93160),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  ABISELECT(-143824,-93324),
  ABISELECT(-17104,-11112),
  ABISELECT(-17152,-11144),
  ABISELECT(-18128,-11772),
  ABISELECT(-15040,-9740),
  ABISELECT(-143824,-93324),
  (VTBL_ENTRY)&(_ZTI8S7394C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C12D1Ev,_ZTv0_n28_N8S7394C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7394C12D0Ev,_ZTv0_n28_N8S7394C12D0Ev),
};
extern VTBL_ENTRY _ZTV8S7394C12[];
extern void _ZN8S7394C17D1Ev();
extern void _ZN8S7394C17D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C17__8S7394C12[] = {
  ABISELECT(143568,93160),
  ABISELECT(125584,81468),
  ABISELECT(143824,93324),
  ABISELECT(126720,82212),
  ABISELECT(126672,82180),
  ABISELECT(125696,81552),
  ABISELECT(128784,83584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C17[0]),
  (VTBL_ENTRY)&_ZN8S7394C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C17D0Ev,
};
extern void _ZN8S7394C18D1Ev();
extern void _ZN8S7394C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C188S7394C17__8S7394C12[] = {
  ABISELECT(126720,82212),
  ABISELECT(126672,82180),
  ABISELECT(125696,81552),
  ABISELECT(128784,83584),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&_ZN8S7394C18D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C18D0Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn128784_N8S7394C18D1Ev,_ZThn83584_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn128784_N8S7394C18D0Ev,_ZThn83584_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C188S7394C17__8S7394C12[] = {
  0,
  ABISELECT(-128784,-83584),
  ABISELECT(-2064,-1372),
  ABISELECT(-2112,-1404),
  ABISELECT(-3088,-2032),
  ABISELECT(-128784,-83584),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D1Ev,_ZTv0_n24_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C18D0Ev,_ZTv0_n24_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn125696_N8S7394C18D1Ev,_ZThn81552_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn125696_N8S7394C18D0Ev,_ZThn81552_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C188S7394C17__8S7394C12[] = {
  0,
  ABISELECT(-125696,-81552),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-125696,-81552),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D1Ev,_ZTv0_n20_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C18D0Ev,_ZTv0_n20_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev)();
extern void ABISELECT(_ZThn126720_N8S7394C18D1Ev,_ZThn82212_N8S7394C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev)();
extern void ABISELECT(_ZThn126720_N8S7394C18D0Ev,_ZThn82212_N8S7394C18D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C188S7394C17__8S7394C12[] = {
  0,
  0,
  ABISELECT(-126720,-82212),
  ABISELECT(-126720,-82212),
  (VTBL_ENTRY)&(_ZTI8S7394C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D1Ev,_ZTv0_n12_N8S7394C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C18D0Ev,_ZTv0_n12_N8S7394C18D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void _ZN8S7394C19D1Ev();
extern void _ZN8S7394C19D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C198S7394C17__8S7394C12[] = {
  ABISELECT(143792,93308),
  ABISELECT(143536,93144),
  ABISELECT(128752,83568),
  ABISELECT(125664,81536),
  ABISELECT(125552,81452),
  ABISELECT(126688,82196),
  ABISELECT(126640,82164),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C19[0]),
  (VTBL_ENTRY)&_ZN8S7394C19D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C19D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN8S7394C10D1Ev();
extern void _ZN8S7394C10D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C108S7394C198S7394C17__8S7394C12[] = {
  ABISELECT(143536,93144),
  ABISELECT(128752,83568),
  ABISELECT(125664,81536),
  ABISELECT(125552,81452),
  ABISELECT(126688,82196),
  ABISELECT(126640,82164),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&_ZN8S7394C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C10D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void _ZN7S7394C8D1Ev();
extern void _ZN7S7394C8D0Ev();
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C88S7394C108S7394C198S7394C17__A2__8S7394C12[] = {
  ABISELECT(126688,82196),
  ABISELECT(126640,82164),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&_ZN7S7394C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7394C8D0Ev,
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C27S7394C88S7394C108S7394C198S7394C17__A3__8S7394C12[] = {
  ABISELECT(126640,82164),
  0,
  (VTBL_ENTRY)&(_ZTI7S7394C2[0]),
};
extern void ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev)();
extern void ABISELECT(_ZThn126688_N7S7394C8D1Ev,_ZThn82196_N7S7394C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev)();
extern void ABISELECT(_ZThn126688_N7S7394C8D0Ev,_ZThn82196_N7S7394C8D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__7S7394C88S7394C108S7394C198S7394C17__A2__8S7394C12[] = {
  0,
  0,
  ABISELECT(-126688,-82196),
  ABISELECT(-126688,-82196),
  (VTBL_ENTRY)&(_ZTI7S7394C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D1Ev,_ZTv0_n12_N7S7394C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7394C8D0Ev,_ZTv0_n12_N7S7394C8D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn125552_N8S7394C10D1Ev,_ZThn81452_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn125552_N8S7394C10D0Ev,_ZThn81452_N8S7394C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C108S7394C198S7394C17__8S7394C12[] = {
  ABISELECT(-125552,-81452),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-125552,-81452),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn125664_N8S7394C10D1Ev,_ZThn81536_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn125664_N8S7394C10D0Ev,_ZThn81536_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C82v3Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C8__8S7394C108S7394C198S7394C17__8S7394C12[] = {
  0,
  ABISELECT(-125664,-81536),
  ABISELECT(1024,660),
  ABISELECT(976,628),
  ABISELECT(-125664,-81536),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D1Ev,_ZTv0_n20_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S7394C10D0Ev,_ZTv0_n20_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C82v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn126688_N8S7394C10D1Ev,_ZThn82196_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn126688_N8S7394C10D0Ev,_ZThn82196_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN7S7394C52v1Ev();
extern void _ZN7S7394C52v2Ev();
static  VTBL_ENTRY _tg__ZTV7S7394C5__8S7394C108S7394C198S7394C17__8S7394C12[] = {
  0,
  0,
  ABISELECT(-126688,-82196),
  ABISELECT(-126688,-82196),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D1Ev,_ZTv0_n12_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7394C10D0Ev,_ZTv0_n12_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7394C52v1Ev,
  (VTBL_ENTRY)&_ZN7S7394C52v2Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev)();
extern void ABISELECT(_ZThn128752_N8S7394C10D1Ev,_ZThn83568_N8S7394C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev)();
extern void ABISELECT(_ZThn128752_N8S7394C10D0Ev,_ZThn83568_N8S7394C10D0Ev)() __attribute__((weak));
extern void _ZN8S7394C112v6Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C11__8S7394C108S7394C198S7394C17__8S7394C12[] = {
  0,
  ABISELECT(-128752,-83568),
  ABISELECT(-2064,-1372),
  ABISELECT(-2112,-1404),
  ABISELECT(-3088,-2032),
  ABISELECT(-128752,-83568),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D1Ev,_ZTv0_n24_N8S7394C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C10D0Ev,_ZTv0_n24_N8S7394C10D0Ev),
  (VTBL_ENTRY)&_ZN8S7394C112v6Ev,
};
static  VTBL_ENTRY _tg__ZTV7S7394C2__A2__8S7394C108S7394C198S7394C17__8S7394C12[] = {
  ABISELECT(-16896,-10980),
  ABISELECT(-143536,-93144),
  (VTBL_ENTRY)&(_ZTI8S7394C10[0]),
};
extern void _ZN8S7394C14D1Ev();
extern void _ZN8S7394C14D0Ev();
extern void _ZN8S7394C142v5Ev();
static  VTBL_ENTRY _tg__ZTV8S7394C148S7394C198S7394C17__A1__8S7394C12[] = {
  ABISELECT(125648,81524),
  ABISELECT(125600,81492),
  ABISELECT(124624,80864),
  ABISELECT(124512,80780),
  0,
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&_ZN8S7394C14D1Ev,
  (VTBL_ENTRY)&_ZN8S7394C14D0Ev,
  (VTBL_ENTRY)&_ZN8S7394C142v5Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev)();
extern void ABISELECT(_ZThn124512_N8S7394C14D1Ev,_ZThn80780_N8S7394C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S7394C14D0Ev,_ZTv0_n24_N8S7394C14D0Ev)();
extern void ABISELECT(_ZThn124512_N8S7394C14D0Ev,_ZThn80780_N8S7394C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7394C7__8S7394C148S7394C198S7394C17__A1__8S7394C12[] = {
  ABISELECT(-124512,-80780),
  ABISELECT(1136,744),
  ABISELECT(1088,712),
  ABISELECT(112,84),
  ABISELECT(-124512,-80780),
  (VTBL_ENTRY)&(_ZTI8S7394C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S7394C14D1Ev,_ZTv0_n24_N8S7394C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48