// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S80C8_nt  {
  int s80c8f0[2];
  void  mf80c8(); // _ZN8S80C8_nt6mf80c8Ev
};
//SIG(-1 S80C8_nt) C1{ m Fi[2]}


void  S80C8_nt ::mf80c8(){}

//skip512 S80C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C7_nt  {
  int s80c7f0;
  __tsi64 s80c7f1;
  void *s80c7f2[4];
  int s80c7f3[2];
  void *s80c7f4;
  ::S80C8_nt s80c7f5;
  void *s80c7f6[2];
  virtual  ~S80C7_nt(); // _ZN8S80C7_ntD1Ev
  virtual void  v4(); // _ZN8S80C7_nt2v4Ev
  virtual void  v5(); // _ZN8S80C7_nt2v5Ev
  virtual void  v6(); // _ZN8S80C7_nt2v6Ev
  virtual void  v7(); // _ZN8S80C7_nt2v7Ev
  virtual void  v8(); // _ZN8S80C7_nt2v8Ev
  virtual void  v9(); // _ZN8S80C7_nt2v9Ev
  virtual void  v10(); // _ZN8S80C7_nt3v10Ev
  virtual void  v11(); // _ZN8S80C7_nt3v11Ev
  virtual void  v12(); // _ZN8S80C7_nt3v12Ev
  virtual void  v13(); // _ZN8S80C7_nt3v13Ev
  virtual void  v14(); // _ZN8S80C7_nt3v14Ev
  virtual void  v15(); // _ZN8S80C7_nt3v15Ev
  virtual void  v16(); // _ZN8S80C7_nt3v16Ev
  virtual void  v17(); // _ZN8S80C7_nt3v17Ev
  virtual void  v18(); // _ZN8S80C7_nt3v18Ev
  virtual void  v19(); // _ZN8S80C7_nt3v19Ev
  virtual void  v20(); // _ZN8S80C7_nt3v20Ev
  virtual void  v21(); // _ZN8S80C7_nt3v21Ev
  virtual void  v22(); // _ZN8S80C7_nt3v22Ev
  virtual void  v23(); // _ZN8S80C7_nt3v23Ev
  virtual void  v24(); // _ZN8S80C7_nt3v24Ev
  virtual void  v25(); // _ZN8S80C7_nt3v25Ev
  virtual void  v26(); // _ZN8S80C7_nt3v26Ev
  virtual void  v27(); // _ZN8S80C7_nt3v27Ev
  virtual void  v28(); // _ZN8S80C7_nt3v28Ev
  virtual void  v29(); // _ZN8S80C7_nt3v29Ev
  virtual void  v30(); // _ZN8S80C7_nt3v30Ev
  virtual void  v31(); // _ZN8S80C7_nt3v31Ev
  virtual void  v32(); // _ZN8S80C7_nt3v32Ev
  virtual void  v33(); // _ZN8S80C7_nt3v33Ev
  virtual void  v34(); // _ZN8S80C7_nt3v34Ev
  virtual void  v35(); // _ZN8S80C7_nt3v35Ev
  virtual void  v36(); // _ZN8S80C7_nt3v36Ev
  virtual void  v37(); // _ZN8S80C7_nt3v37Ev
  virtual void  v38(); // _ZN8S80C7_nt3v38Ev
  virtual void  v39(); // _ZN8S80C7_nt3v39Ev
  virtual void  v40(); // _ZN8S80C7_nt3v40Ev
  virtual void  v41(); // _ZN8S80C7_nt3v41Ev
  virtual void  v42(); // _ZN8S80C7_nt3v42Ev
  virtual void  v43(); // _ZN8S80C7_nt3v43Ev
  virtual void  v44(); // _ZN8S80C7_nt3v44Ev
  virtual void  v45(); // _ZN8S80C7_nt3v45Ev
  virtual void  v46(); // _ZN8S80C7_nt3v46Ev
  virtual void  v47(); // _ZN8S80C7_nt3v47Ev
  virtual void  v48(); // _ZN8S80C7_nt3v48Ev
  virtual void  v49(); // _ZN8S80C7_nt3v49Ev
  virtual void  v50(); // _ZN8S80C7_nt3v50Ev
  virtual void  v51(); // _ZN8S80C7_nt3v51Ev
  virtual void  v52(); // _ZN8S80C7_nt3v52Ev
  virtual void  v53(); // _ZN8S80C7_nt3v53Ev
  virtual void  v54(); // _ZN8S80C7_nt3v54Ev
  virtual void  v55(); // _ZN8S80C7_nt3v55Ev
  virtual void  v56(); // _ZN8S80C7_nt3v56Ev
  virtual void  v57(); // _ZN8S80C7_nt3v57Ev
  virtual void  v58(); // _ZN8S80C7_nt3v58Ev
  virtual void  v59(); // _ZN8S80C7_nt3v59Ev
  virtual void  v60(); // _ZN8S80C7_nt3v60Ev
  virtual void  v61(); // _ZN8S80C7_nt3v61Ev
  virtual void  v62(); // _ZN8S80C7_nt3v62Ev
  virtual void  v63(); // _ZN8S80C7_nt3v63Ev
  virtual void  v64(); // _ZN8S80C7_nt3v64Ev
  virtual void  v65(); // _ZN8S80C7_nt3v65Ev
  virtual void  v66(); // _ZN8S80C7_nt3v66Ev
  virtual void  v67(); // _ZN8S80C7_nt3v67Ev
  S80C7_nt(); // tgen
};
//SIG(-1 S80C7_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S80C7_nt ::~S80C7_nt(){ note_dtor("S80C7_nt", this);}
void  S80C7_nt ::v4(){vfunc_called(this, "_ZN8S80C7_nt2v4Ev");}
void  S80C7_nt ::v5(){vfunc_called(this, "_ZN8S80C7_nt2v5Ev");}
void  S80C7_nt ::v6(){vfunc_called(this, "_ZN8S80C7_nt2v6Ev");}
void  S80C7_nt ::v7(){vfunc_called(this, "_ZN8S80C7_nt2v7Ev");}
void  S80C7_nt ::v8(){vfunc_called(this, "_ZN8S80C7_nt2v8Ev");}
void  S80C7_nt ::v9(){vfunc_called(this, "_ZN8S80C7_nt2v9Ev");}
void  S80C7_nt ::v10(){vfunc_called(this, "_ZN8S80C7_nt3v10Ev");}
void  S80C7_nt ::v11(){vfunc_called(this, "_ZN8S80C7_nt3v11Ev");}
void  S80C7_nt ::v12(){vfunc_called(this, "_ZN8S80C7_nt3v12Ev");}
void  S80C7_nt ::v13(){vfunc_called(this, "_ZN8S80C7_nt3v13Ev");}
void  S80C7_nt ::v14(){vfunc_called(this, "_ZN8S80C7_nt3v14Ev");}
void  S80C7_nt ::v15(){vfunc_called(this, "_ZN8S80C7_nt3v15Ev");}
void  S80C7_nt ::v16(){vfunc_called(this, "_ZN8S80C7_nt3v16Ev");}
void  S80C7_nt ::v17(){vfunc_called(this, "_ZN8S80C7_nt3v17Ev");}
void  S80C7_nt ::v18(){vfunc_called(this, "_ZN8S80C7_nt3v18Ev");}
void  S80C7_nt ::v19(){vfunc_called(this, "_ZN8S80C7_nt3v19Ev");}
void  S80C7_nt ::v20(){vfunc_called(this, "_ZN8S80C7_nt3v20Ev");}
void  S80C7_nt ::v21(){vfunc_called(this, "_ZN8S80C7_nt3v21Ev");}
void  S80C7_nt ::v22(){vfunc_called(this, "_ZN8S80C7_nt3v22Ev");}
void  S80C7_nt ::v23(){vfunc_called(this, "_ZN8S80C7_nt3v23Ev");}
void  S80C7_nt ::v24(){vfunc_called(this, "_ZN8S80C7_nt3v24Ev");}
void  S80C7_nt ::v25(){vfunc_called(this, "_ZN8S80C7_nt3v25Ev");}
void  S80C7_nt ::v26(){vfunc_called(this, "_ZN8S80C7_nt3v26Ev");}
void  S80C7_nt ::v27(){vfunc_called(this, "_ZN8S80C7_nt3v27Ev");}
void  S80C7_nt ::v28(){vfunc_called(this, "_ZN8S80C7_nt3v28Ev");}
void  S80C7_nt ::v29(){vfunc_called(this, "_ZN8S80C7_nt3v29Ev");}
void  S80C7_nt ::v30(){vfunc_called(this, "_ZN8S80C7_nt3v30Ev");}
void  S80C7_nt ::v31(){vfunc_called(this, "_ZN8S80C7_nt3v31Ev");}
void  S80C7_nt ::v32(){vfunc_called(this, "_ZN8S80C7_nt3v32Ev");}
void  S80C7_nt ::v33(){vfunc_called(this, "_ZN8S80C7_nt3v33Ev");}
void  S80C7_nt ::v34(){vfunc_called(this, "_ZN8S80C7_nt3v34Ev");}
void  S80C7_nt ::v35(){vfunc_called(this, "_ZN8S80C7_nt3v35Ev");}
void  S80C7_nt ::v36(){vfunc_called(this, "_ZN8S80C7_nt3v36Ev");}
void  S80C7_nt ::v37(){vfunc_called(this, "_ZN8S80C7_nt3v37Ev");}
void  S80C7_nt ::v38(){vfunc_called(this, "_ZN8S80C7_nt3v38Ev");}
void  S80C7_nt ::v39(){vfunc_called(this, "_ZN8S80C7_nt3v39Ev");}
void  S80C7_nt ::v40(){vfunc_called(this, "_ZN8S80C7_nt3v40Ev");}
void  S80C7_nt ::v41(){vfunc_called(this, "_ZN8S80C7_nt3v41Ev");}
void  S80C7_nt ::v42(){vfunc_called(this, "_ZN8S80C7_nt3v42Ev");}
void  S80C7_nt ::v43(){vfunc_called(this, "_ZN8S80C7_nt3v43Ev");}
void  S80C7_nt ::v44(){vfunc_called(this, "_ZN8S80C7_nt3v44Ev");}
void  S80C7_nt ::v45(){vfunc_called(this, "_ZN8S80C7_nt3v45Ev");}
void  S80C7_nt ::v46(){vfunc_called(this, "_ZN8S80C7_nt3v46Ev");}
void  S80C7_nt ::v47(){vfunc_called(this, "_ZN8S80C7_nt3v47Ev");}
void  S80C7_nt ::v48(){vfunc_called(this, "_ZN8S80C7_nt3v48Ev");}
void  S80C7_nt ::v49(){vfunc_called(this, "_ZN8S80C7_nt3v49Ev");}
void  S80C7_nt ::v50(){vfunc_called(this, "_ZN8S80C7_nt3v50Ev");}
void  S80C7_nt ::v51(){vfunc_called(this, "_ZN8S80C7_nt3v51Ev");}
void  S80C7_nt ::v52(){vfunc_called(this, "_ZN8S80C7_nt3v52Ev");}
void  S80C7_nt ::v53(){vfunc_called(this, "_ZN8S80C7_nt3v53Ev");}
void  S80C7_nt ::v54(){vfunc_called(this, "_ZN8S80C7_nt3v54Ev");}
void  S80C7_nt ::v55(){vfunc_called(this, "_ZN8S80C7_nt3v55Ev");}
void  S80C7_nt ::v56(){vfunc_called(this, "_ZN8S80C7_nt3v56Ev");}
void  S80C7_nt ::v57(){vfunc_called(this, "_ZN8S80C7_nt3v57Ev");}
void  S80C7_nt ::v58(){vfunc_called(this, "_ZN8S80C7_nt3v58Ev");}
void  S80C7_nt ::v59(){vfunc_called(this, "_ZN8S80C7_nt3v59Ev");}
void  S80C7_nt ::v60(){vfunc_called(this, "_ZN8S80C7_nt3v60Ev");}
void  S80C7_nt ::v61(){vfunc_called(this, "_ZN8S80C7_nt3v61Ev");}
void  S80C7_nt ::v62(){vfunc_called(this, "_ZN8S80C7_nt3v62Ev");}
void  S80C7_nt ::v63(){vfunc_called(this, "_ZN8S80C7_nt3v63Ev");}
void  S80C7_nt ::v64(){vfunc_called(this, "_ZN8S80C7_nt3v64Ev");}
void  S80C7_nt ::v65(){vfunc_called(this, "_ZN8S80C7_nt3v65Ev");}
void  S80C7_nt ::v66(){vfunc_called(this, "_ZN8S80C7_nt3v66Ev");}
void  S80C7_nt ::v67(){vfunc_called(this, "_ZN8S80C7_nt3v67Ev");}
S80C7_nt ::S80C7_nt(){ note_ctor("S80C7_nt", this);} // tgen

//skip512 S80C7_nt

#else // __cplusplus

extern void _ZN8S80C7_ntC1Ev();
extern void _ZN8S80C7_ntD1Ev();
Name_Map name_map_S80C7_nt[] = {
  NSPAIR(_ZN8S80C7_ntC1Ev),
  NSPAIR(_ZN8S80C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern void _ZN8S80C7_ntD1Ev();
extern void _ZN8S80C7_ntD0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
static  VTBL_ENTRY vtc_S80C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S80C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S80C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S80C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI8S80C7_nt[];
VTBL_ENTRY *P__ZTI8S80C7_nt = _ZTI8S80C7_nt; 
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
Class_Descriptor cd_S80C7_nt = {  "S80C7_nt", // class name
  0,0,//no base classes
  &(vtc_S80C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S80C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S80C7_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C6_nt  : S80C7_nt {
  virtual  ~S80C6_nt(); // _ZN8S80C6_ntD1Ev
  virtual void  v68(); // _ZN8S80C6_nt3v68Ev
  virtual void  v69(); // _ZN8S80C6_nt3v69Ev
  S80C6_nt(); // tgen
};
//SIG(-1 S80C6_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S80C6_nt ::~S80C6_nt(){ note_dtor("S80C6_nt", this);}
void  S80C6_nt ::v68(){vfunc_called(this, "_ZN8S80C6_nt3v68Ev");}
void  S80C6_nt ::v69(){vfunc_called(this, "_ZN8S80C6_nt3v69Ev");}
S80C6_nt ::S80C6_nt(){ note_ctor("S80C6_nt", this);} // tgen

//skip512 S80C6_nt

#else // __cplusplus

extern void _ZN8S80C6_ntC1Ev();
extern void _ZN8S80C6_ntD1Ev();
Name_Map name_map_S80C6_nt[] = {
  NSPAIR(_ZN8S80C6_ntC1Ev),
  NSPAIR(_ZN8S80C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
static Base_Class bases_S80C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern void _ZN8S80C6_ntD1Ev();
extern void _ZN8S80C6_ntD0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
static  VTBL_ENTRY vtc_S80C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S80C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S80C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S80C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI8S80C6_nt[];
VTBL_ENTRY *P__ZTI8S80C6_nt = _ZTI8S80C6_nt; 
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
Class_Descriptor cd_S80C6_nt = {  "S80C6_nt", // class name
  bases_S80C6_nt, 1,
  &(vtc_S80C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S80C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S80C6_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C9_nt  {
  int s80c9f0[4];
  char s80c9f1[9];
  void  mf80c9(); // _ZN8S80C9_nt6mf80c9Ev
};
//SIG(-1 S80C9_nt) C1{ m Fi[4] Fc[9]}


void  S80C9_nt ::mf80c9(){}

//skip512 S80C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C12_nt  {
  void *s80c12f0;
  int s80c12f1[2];
  void  mf80c12(); // _ZN9S80C12_nt7mf80c12Ev
};
//SIG(-1 S80C12_nt) C1{ m Fp Fi[2]}


void  S80C12_nt ::mf80c12(){}

//skip512 S80C12_nt

#else // __cplusplus

Class_Descriptor cd_S80C12_nt = {  "S80C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C11_nt  : S80C12_nt {
};
//SIG(-1 S80C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S80C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C11_nt = {  "S80C11_nt", // class name
  bases_S80C11_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C10_nt  : S80C11_nt {
};
//SIG(-1 S80C10_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S80C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C11_nt;
static Base_Class bases_S80C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C16  : S80C12_nt {
};
//SIG(-1 S80C16) C1{ BC2{ m Fp Fi[2]}}



static void Test_S80C16()
{
  extern Class_Descriptor cd_S80C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C16, buf);
    S80C16 &lv = *(new (buf) S80C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C16)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S80C16");
    test_class_info(&lv, &cd_S80C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C16(Test_S80C16, "S80C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C16 = {  "S80C16", // class name
  bases_S80C16, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C15  : S80C16 {
};
//SIG(-1 S80C15) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S80C15()
{
  extern Class_Descriptor cd_S80C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C15, buf);
    S80C15 &lv = *(new (buf) S80C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C15)");
    check_base_class_offset(lv, (S80C12_nt*)(S80C16*), 0, "S80C15");
    check_base_class_offset(lv, (S80C16*), 0, "S80C15");
    test_class_info(&lv, &cd_S80C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C15(Test_S80C15, "S80C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C16;
static Base_Class bases_S80C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C15 = {  "S80C15", // class name
  bases_S80C15, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C20  : S80C12_nt {
};
//SIG(-1 S80C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S80C20()
{
  extern Class_Descriptor cd_S80C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C20, buf);
    S80C20 &lv = *(new (buf) S80C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C20)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S80C20");
    test_class_info(&lv, &cd_S80C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C20(Test_S80C20, "S80C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C20 = {  "S80C20", // class name
  bases_S80C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C19  : S80C20 {
};
//SIG(-1 S80C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S80C19()
{
  extern Class_Descriptor cd_S80C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C19, buf);
    S80C19 &lv = *(new (buf) S80C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C19)");
    check_base_class_offset(lv, (S80C12_nt*)(S80C20*), 0, "S80C19");
    check_base_class_offset(lv, (S80C20*), 0, "S80C19");
    test_class_info(&lv, &cd_S80C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C19(Test_S80C19, "S80C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C20;
static Base_Class bases_S80C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C19 = {  "S80C19", // class name
  bases_S80C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C21_nt  {
  void *s80c21f0;
  ::S80C8_nt s80c21f1;
  void  mf80c21(); // _ZN9S80C21_nt7mf80c21Ev
};
//SIG(-1 S80C21_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S80C21_nt ::mf80c21(){}

//skip512 S80C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C5_nt  : S80C6_nt {
  ::S80C9_nt s80c5f0;
  int s80c5f1;
  unsigned int s80c5f2:1;
  unsigned int s80c5f3:1;
  unsigned int s80c5f4:1;
  unsigned int s80c5f5:1;
  ::S80C10_nt s80c5f6;
  ::S80C10_nt s80c5f7;
  void *s80c5f8;
  ::S80C15 s80c5f9;
  ::S80C15 s80c5f10;
  ::S80C15 s80c5f11;
  ::S80C19 s80c5f12;
  char s80c5f13;
  int s80c5f14;
  void *s80c5f15;
  ::S80C8_nt s80c5f16;
  ::S80C8_nt s80c5f17;
  ::S80C8_nt s80c5f18;
  ::S80C8_nt s80c5f19;
  ::S80C8_nt s80c5f20;
  ::S80C8_nt s80c5f21;
  ::S80C21_nt s80c5f22;
  ::S80C21_nt s80c5f23;
  ::S80C21_nt s80c5f24;
  ::S80C21_nt s80c5f25;
  ::S80C21_nt s80c5f26;
  ::S80C21_nt s80c5f27;
  ::S80C21_nt s80c5f28;
  ::S80C21_nt s80c5f29;
  ::S80C21_nt s80c5f30;
  ::S80C21_nt s80c5f31;
  virtual  ~S80C5_nt(); // _ZN8S80C5_ntD1Ev
  virtual void  v70(); // _ZN8S80C5_nt3v70Ev
  virtual void  v71(); // _ZN8S80C5_nt3v71Ev
  virtual void  v72(); // _ZN8S80C5_nt3v72Ev
  virtual void  v73(); // _ZN8S80C5_nt3v73Ev
  virtual void  v74(); // _ZN8S80C5_nt3v74Ev
  virtual void  v75(); // _ZN8S80C5_nt3v75Ev
  virtual void  v76(); // _ZN8S80C5_nt3v76Ev
  virtual void  v77(); // _ZN8S80C5_nt3v77Ev
  virtual void  v78(); // _ZN8S80C5_nt3v78Ev
  virtual void  v79(); // _ZN8S80C5_nt3v79Ev
  virtual void  v80(); // _ZN8S80C5_nt3v80Ev
  virtual void  v81(); // _ZN8S80C5_nt3v81Ev
  virtual void  v82(); // _ZN8S80C5_nt3v82Ev
  virtual void  v83(); // _ZN8S80C5_nt3v83Ev
  virtual void  v84(); // _ZN8S80C5_nt3v84Ev
  virtual void  v85(); // _ZN8S80C5_nt3v85Ev
  virtual void  v86(); // _ZN8S80C5_nt3v86Ev
  virtual void  v87(); // _ZN8S80C5_nt3v87Ev
  virtual void  v88(); // _ZN8S80C5_nt3v88Ev
  virtual void  v89(); // _ZN8S80C5_nt3v89Ev
  virtual void  v90(); // _ZN8S80C5_nt3v90Ev
  virtual void  v91(); // _ZN8S80C5_nt3v91Ev
  virtual void  v92(); // _ZN8S80C5_nt3v92Ev
  virtual void  v93(); // _ZN8S80C5_nt3v93Ev
  virtual void  v94(); // _ZN8S80C5_nt3v94Ev
  virtual void  v95(); // _ZN8S80C5_nt3v95Ev
  virtual void  v96(); // _ZN8S80C5_nt3v96Ev
  virtual void  v97(); // _ZN8S80C5_nt3v97Ev
  virtual void  v98(); // _ZN8S80C5_nt3v98Ev
  virtual void  v99(); // _ZN8S80C5_nt3v99Ev
  virtual void  v100(); // _ZN8S80C5_nt4v100Ev
  virtual void  v101(); // _ZN8S80C5_nt4v101Ev
  virtual void  v102(); // _ZN8S80C5_nt4v102Ev
  virtual void  v103(); // _ZN8S80C5_nt4v103Ev
  virtual void  v104(); // _ZN8S80C5_nt4v104Ev
  virtual void  v105(); // _ZN8S80C5_nt4v105Ev
  virtual void  v106(); // _ZN8S80C5_nt4v106Ev
  virtual void  v107(); // _ZN8S80C5_nt4v107Ev
  virtual void  v108(); // _ZN8S80C5_nt4v108Ev
  virtual void  v109(); // _ZN8S80C5_nt4v109Ev
  virtual void  v110(); // _ZN8S80C5_nt4v110Ev
  virtual void  v111(); // _ZN8S80C5_nt4v111Ev
  virtual void  v112(); // _ZN8S80C5_nt4v112Ev
  virtual void  v113(); // _ZN8S80C5_nt4v113Ev
  virtual void  v114(); // _ZN8S80C5_nt4v114Ev
  virtual void  v115(); // _ZN8S80C5_nt4v115Ev
  virtual void  v116(); // _ZN8S80C5_nt4v116Ev
  virtual void  v117(); // _ZN8S80C5_nt4v117Ev
  virtual void  v118(); // _ZN8S80C5_nt4v118Ev
  virtual void  v119(); // _ZN8S80C5_nt4v119Ev
  virtual void  v120(); // _ZN8S80C5_nt4v120Ev
  virtual void  v121(); // _ZN8S80C5_nt4v121Ev
  virtual void  v122(); // _ZN8S80C5_nt4v122Ev
  virtual void  v123(); // _ZN8S80C5_nt4v123Ev
  virtual void  v124(); // _ZN8S80C5_nt4v124Ev
  virtual void  v125(); // _ZN8S80C5_nt4v125Ev
  virtual void  v126(); // _ZN8S80C5_nt4v126Ev
  virtual void  v127(); // _ZN8S80C5_nt4v127Ev
  virtual void  v128(); // _ZN8S80C5_nt4v128Ev
  virtual void  v129(); // _ZN8S80C5_nt4v129Ev
  virtual void  v130(); // _ZN8S80C5_nt4v130Ev
  virtual void  v131(); // _ZN8S80C5_nt4v131Ev
  virtual void  v132(); // _ZN8S80C5_nt4v132Ev
  virtual void  v133(); // _ZN8S80C5_nt4v133Ev
  virtual void  v134(); // _ZN8S80C5_nt4v134Ev
  virtual void  v135(); // _ZN8S80C5_nt4v135Ev
  virtual void  v136(); // _ZN8S80C5_nt4v136Ev
  virtual void  v137(); // _ZN8S80C5_nt4v137Ev
  virtual void  v138(); // _ZN8S80C5_nt4v138Ev
  virtual void  v139(); // _ZN8S80C5_nt4v139Ev
  virtual void  v140(); // _ZN8S80C5_nt4v140Ev
  virtual void  v141(); // _ZN8S80C5_nt4v141Ev
  virtual void  v142(); // _ZN8S80C5_nt4v142Ev
  virtual void  v143(); // _ZN8S80C5_nt4v143Ev
  virtual void  v144(); // _ZN8S80C5_nt4v144Ev
  virtual void  v145(); // _ZN8S80C5_nt4v145Ev
  S80C5_nt(); // tgen
};
//SIG(-1 S80C5_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S80C5_nt ::~S80C5_nt(){ note_dtor("S80C5_nt", this);}
void  S80C5_nt ::v70(){vfunc_called(this, "_ZN8S80C5_nt3v70Ev");}
void  S80C5_nt ::v71(){vfunc_called(this, "_ZN8S80C5_nt3v71Ev");}
void  S80C5_nt ::v72(){vfunc_called(this, "_ZN8S80C5_nt3v72Ev");}
void  S80C5_nt ::v73(){vfunc_called(this, "_ZN8S80C5_nt3v73Ev");}
void  S80C5_nt ::v74(){vfunc_called(this, "_ZN8S80C5_nt3v74Ev");}
void  S80C5_nt ::v75(){vfunc_called(this, "_ZN8S80C5_nt3v75Ev");}
void  S80C5_nt ::v76(){vfunc_called(this, "_ZN8S80C5_nt3v76Ev");}
void  S80C5_nt ::v77(){vfunc_called(this, "_ZN8S80C5_nt3v77Ev");}
void  S80C5_nt ::v78(){vfunc_called(this, "_ZN8S80C5_nt3v78Ev");}
void  S80C5_nt ::v79(){vfunc_called(this, "_ZN8S80C5_nt3v79Ev");}
void  S80C5_nt ::v80(){vfunc_called(this, "_ZN8S80C5_nt3v80Ev");}
void  S80C5_nt ::v81(){vfunc_called(this, "_ZN8S80C5_nt3v81Ev");}
void  S80C5_nt ::v82(){vfunc_called(this, "_ZN8S80C5_nt3v82Ev");}
void  S80C5_nt ::v83(){vfunc_called(this, "_ZN8S80C5_nt3v83Ev");}
void  S80C5_nt ::v84(){vfunc_called(this, "_ZN8S80C5_nt3v84Ev");}
void  S80C5_nt ::v85(){vfunc_called(this, "_ZN8S80C5_nt3v85Ev");}
void  S80C5_nt ::v86(){vfunc_called(this, "_ZN8S80C5_nt3v86Ev");}
void  S80C5_nt ::v87(){vfunc_called(this, "_ZN8S80C5_nt3v87Ev");}
void  S80C5_nt ::v88(){vfunc_called(this, "_ZN8S80C5_nt3v88Ev");}
void  S80C5_nt ::v89(){vfunc_called(this, "_ZN8S80C5_nt3v89Ev");}
void  S80C5_nt ::v90(){vfunc_called(this, "_ZN8S80C5_nt3v90Ev");}
void  S80C5_nt ::v91(){vfunc_called(this, "_ZN8S80C5_nt3v91Ev");}
void  S80C5_nt ::v92(){vfunc_called(this, "_ZN8S80C5_nt3v92Ev");}
void  S80C5_nt ::v93(){vfunc_called(this, "_ZN8S80C5_nt3v93Ev");}
void  S80C5_nt ::v94(){vfunc_called(this, "_ZN8S80C5_nt3v94Ev");}
void  S80C5_nt ::v95(){vfunc_called(this, "_ZN8S80C5_nt3v95Ev");}
void  S80C5_nt ::v96(){vfunc_called(this, "_ZN8S80C5_nt3v96Ev");}
void  S80C5_nt ::v97(){vfunc_called(this, "_ZN8S80C5_nt3v97Ev");}
void  S80C5_nt ::v98(){vfunc_called(this, "_ZN8S80C5_nt3v98Ev");}
void  S80C5_nt ::v99(){vfunc_called(this, "_ZN8S80C5_nt3v99Ev");}
void  S80C5_nt ::v100(){vfunc_called(this, "_ZN8S80C5_nt4v100Ev");}
void  S80C5_nt ::v101(){vfunc_called(this, "_ZN8S80C5_nt4v101Ev");}
void  S80C5_nt ::v102(){vfunc_called(this, "_ZN8S80C5_nt4v102Ev");}
void  S80C5_nt ::v103(){vfunc_called(this, "_ZN8S80C5_nt4v103Ev");}
void  S80C5_nt ::v104(){vfunc_called(this, "_ZN8S80C5_nt4v104Ev");}
void  S80C5_nt ::v105(){vfunc_called(this, "_ZN8S80C5_nt4v105Ev");}
void  S80C5_nt ::v106(){vfunc_called(this, "_ZN8S80C5_nt4v106Ev");}
void  S80C5_nt ::v107(){vfunc_called(this, "_ZN8S80C5_nt4v107Ev");}
void  S80C5_nt ::v108(){vfunc_called(this, "_ZN8S80C5_nt4v108Ev");}
void  S80C5_nt ::v109(){vfunc_called(this, "_ZN8S80C5_nt4v109Ev");}
void  S80C5_nt ::v110(){vfunc_called(this, "_ZN8S80C5_nt4v110Ev");}
void  S80C5_nt ::v111(){vfunc_called(this, "_ZN8S80C5_nt4v111Ev");}
void  S80C5_nt ::v112(){vfunc_called(this, "_ZN8S80C5_nt4v112Ev");}
void  S80C5_nt ::v113(){vfunc_called(this, "_ZN8S80C5_nt4v113Ev");}
void  S80C5_nt ::v114(){vfunc_called(this, "_ZN8S80C5_nt4v114Ev");}
void  S80C5_nt ::v115(){vfunc_called(this, "_ZN8S80C5_nt4v115Ev");}
void  S80C5_nt ::v116(){vfunc_called(this, "_ZN8S80C5_nt4v116Ev");}
void  S80C5_nt ::v117(){vfunc_called(this, "_ZN8S80C5_nt4v117Ev");}
void  S80C5_nt ::v118(){vfunc_called(this, "_ZN8S80C5_nt4v118Ev");}
void  S80C5_nt ::v119(){vfunc_called(this, "_ZN8S80C5_nt4v119Ev");}
void  S80C5_nt ::v120(){vfunc_called(this, "_ZN8S80C5_nt4v120Ev");}
void  S80C5_nt ::v121(){vfunc_called(this, "_ZN8S80C5_nt4v121Ev");}
void  S80C5_nt ::v122(){vfunc_called(this, "_ZN8S80C5_nt4v122Ev");}
void  S80C5_nt ::v123(){vfunc_called(this, "_ZN8S80C5_nt4v123Ev");}
void  S80C5_nt ::v124(){vfunc_called(this, "_ZN8S80C5_nt4v124Ev");}
void  S80C5_nt ::v125(){vfunc_called(this, "_ZN8S80C5_nt4v125Ev");}
void  S80C5_nt ::v126(){vfunc_called(this, "_ZN8S80C5_nt4v126Ev");}
void  S80C5_nt ::v127(){vfunc_called(this, "_ZN8S80C5_nt4v127Ev");}
void  S80C5_nt ::v128(){vfunc_called(this, "_ZN8S80C5_nt4v128Ev");}
void  S80C5_nt ::v129(){vfunc_called(this, "_ZN8S80C5_nt4v129Ev");}
void  S80C5_nt ::v130(){vfunc_called(this, "_ZN8S80C5_nt4v130Ev");}
void  S80C5_nt ::v131(){vfunc_called(this, "_ZN8S80C5_nt4v131Ev");}
void  S80C5_nt ::v132(){vfunc_called(this, "_ZN8S80C5_nt4v132Ev");}
void  S80C5_nt ::v133(){vfunc_called(this, "_ZN8S80C5_nt4v133Ev");}
void  S80C5_nt ::v134(){vfunc_called(this, "_ZN8S80C5_nt4v134Ev");}
void  S80C5_nt ::v135(){vfunc_called(this, "_ZN8S80C5_nt4v135Ev");}
void  S80C5_nt ::v136(){vfunc_called(this, "_ZN8S80C5_nt4v136Ev");}
void  S80C5_nt ::v137(){vfunc_called(this, "_ZN8S80C5_nt4v137Ev");}
void  S80C5_nt ::v138(){vfunc_called(this, "_ZN8S80C5_nt4v138Ev");}
void  S80C5_nt ::v139(){vfunc_called(this, "_ZN8S80C5_nt4v139Ev");}
void  S80C5_nt ::v140(){vfunc_called(this, "_ZN8S80C5_nt4v140Ev");}
void  S80C5_nt ::v141(){vfunc_called(this, "_ZN8S80C5_nt4v141Ev");}
void  S80C5_nt ::v142(){vfunc_called(this, "_ZN8S80C5_nt4v142Ev");}
void  S80C5_nt ::v143(){vfunc_called(this, "_ZN8S80C5_nt4v143Ev");}
void  S80C5_nt ::v144(){vfunc_called(this, "_ZN8S80C5_nt4v144Ev");}
void  S80C5_nt ::v145(){vfunc_called(this, "_ZN8S80C5_nt4v145Ev");}
S80C5_nt ::S80C5_nt(){ note_ctor("S80C5_nt", this);} // tgen

//skip512 S80C5_nt

#else // __cplusplus

extern void _ZN8S80C5_ntC1Ev();
extern void _ZN8S80C5_ntD1Ev();
Name_Map name_map_S80C5_nt[] = {
  NSPAIR(_ZN8S80C5_ntC1Ev),
  NSPAIR(_ZN8S80C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
extern Class_Descriptor cd_S80C6_nt;
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
static Base_Class bases_S80C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S80C5_nt[];
extern void _ZN8S80C5_ntD1Ev();
extern void _ZN8S80C5_ntD0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
extern void _ZN8S80C5_nt3v70Ev();
extern void _ZN8S80C5_nt3v71Ev();
extern void _ZN8S80C5_nt3v72Ev();
extern void _ZN8S80C5_nt3v73Ev();
extern void _ZN8S80C5_nt3v74Ev();
extern void _ZN8S80C5_nt3v75Ev();
extern void _ZN8S80C5_nt3v76Ev();
extern void _ZN8S80C5_nt3v77Ev();
extern void _ZN8S80C5_nt3v78Ev();
extern void _ZN8S80C5_nt3v79Ev();
extern void _ZN8S80C5_nt3v80Ev();
extern void _ZN8S80C5_nt3v81Ev();
extern void _ZN8S80C5_nt3v82Ev();
extern void _ZN8S80C5_nt3v83Ev();
extern void _ZN8S80C5_nt3v84Ev();
extern void _ZN8S80C5_nt3v85Ev();
extern void _ZN8S80C5_nt3v86Ev();
extern void _ZN8S80C5_nt3v87Ev();
extern void _ZN8S80C5_nt3v88Ev();
extern void _ZN8S80C5_nt3v89Ev();
extern void _ZN8S80C5_nt3v90Ev();
extern void _ZN8S80C5_nt3v91Ev();
extern void _ZN8S80C5_nt3v92Ev();
extern void _ZN8S80C5_nt3v93Ev();
extern void _ZN8S80C5_nt3v94Ev();
extern void _ZN8S80C5_nt3v95Ev();
extern void _ZN8S80C5_nt3v96Ev();
extern void _ZN8S80C5_nt3v97Ev();
extern void _ZN8S80C5_nt3v98Ev();
extern void _ZN8S80C5_nt3v99Ev();
extern void _ZN8S80C5_nt4v100Ev();
extern void _ZN8S80C5_nt4v101Ev();
extern void _ZN8S80C5_nt4v102Ev();
extern void _ZN8S80C5_nt4v103Ev();
extern void _ZN8S80C5_nt4v104Ev();
extern void _ZN8S80C5_nt4v105Ev();
extern void _ZN8S80C5_nt4v106Ev();
extern void _ZN8S80C5_nt4v107Ev();
extern void _ZN8S80C5_nt4v108Ev();
extern void _ZN8S80C5_nt4v109Ev();
extern void _ZN8S80C5_nt4v110Ev();
extern void _ZN8S80C5_nt4v111Ev();
extern void _ZN8S80C5_nt4v112Ev();
extern void _ZN8S80C5_nt4v113Ev();
extern void _ZN8S80C5_nt4v114Ev();
extern void _ZN8S80C5_nt4v115Ev();
extern void _ZN8S80C5_nt4v116Ev();
extern void _ZN8S80C5_nt4v117Ev();
extern void _ZN8S80C5_nt4v118Ev();
extern void _ZN8S80C5_nt4v119Ev();
extern void _ZN8S80C5_nt4v120Ev();
extern void _ZN8S80C5_nt4v121Ev();
extern void _ZN8S80C5_nt4v122Ev();
extern void _ZN8S80C5_nt4v123Ev();
extern void _ZN8S80C5_nt4v124Ev();
extern void _ZN8S80C5_nt4v125Ev();
extern void _ZN8S80C5_nt4v126Ev();
extern void _ZN8S80C5_nt4v127Ev();
extern void _ZN8S80C5_nt4v128Ev();
extern void _ZN8S80C5_nt4v129Ev();
extern void _ZN8S80C5_nt4v130Ev();
extern void _ZN8S80C5_nt4v131Ev();
extern void _ZN8S80C5_nt4v132Ev();
extern void _ZN8S80C5_nt4v133Ev();
extern void _ZN8S80C5_nt4v134Ev();
extern void _ZN8S80C5_nt4v135Ev();
extern void _ZN8S80C5_nt4v136Ev();
extern void _ZN8S80C5_nt4v137Ev();
extern void _ZN8S80C5_nt4v138Ev();
extern void _ZN8S80C5_nt4v139Ev();
extern void _ZN8S80C5_nt4v140Ev();
extern void _ZN8S80C5_nt4v141Ev();
extern void _ZN8S80C5_nt4v142Ev();
extern void _ZN8S80C5_nt4v143Ev();
extern void _ZN8S80C5_nt4v144Ev();
extern void _ZN8S80C5_nt4v145Ev();
static  VTBL_ENTRY vtc_S80C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S80C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S80C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S80C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v145Ev,
};
extern VTBL_ENTRY _ZTI8S80C5_nt[];
VTBL_ENTRY *P__ZTI8S80C5_nt = _ZTI8S80C5_nt; 
extern  VTBL_ENTRY _ZTV8S80C5_nt[];
Class_Descriptor cd_S80C5_nt = {  "S80C5_nt", // class name
  bases_S80C5_nt, 2,
  &(vtc_S80C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI8S80C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S80C5_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C26  : S80C12_nt {
};
//SIG(-1 S80C26) C1{ BC2{ m Fp Fi[2]}}



static void Test_S80C26()
{
  extern Class_Descriptor cd_S80C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C26, buf);
    S80C26 &lv = *(new (buf) S80C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C26)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S80C26");
    test_class_info(&lv, &cd_S80C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C26(Test_S80C26, "S80C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C26 = {  "S80C26", // class name
  bases_S80C26, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C25  {
  ::S80C26 s80c25f0;
  void *s80c25f1;
  int s80c25f2;
  void  mf80c25(); // _ZN6S80C257mf80c25Ev
};
//SIG(-1 S80C25) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S80C25 ::mf80c25(){}

static void Test_S80C25()
{
  {
    init_simple_test("S80C25");
    S80C25 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S80C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C25)");
    check_field_offset(lv, s80c25f0, 0, "S80C25.s80c25f0");
    check_field_offset(lv, s80c25f1, ABISELECT(16,12), "S80C25.s80c25f1");
    check_field_offset(lv, s80c25f2, ABISELECT(24,16), "S80C25.s80c25f2");
  }
}
static Arrange_To_Call_Me vS80C25(Test_S80C25, "S80C25", ABISELECT(32,20));

#else // __cplusplus

Class_Descriptor cd_S80C25 = {  "S80C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C24  : S80C25 {
};
//SIG(-1 S80C24) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



static void Test_S80C24()
{
  extern Class_Descriptor cd_S80C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S80C24, buf);
    S80C24 &lv = *(new (buf) S80C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S80C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C24)");
    check_base_class_offset(lv, (S80C25*), 0, "S80C24");
    test_class_info(&lv, &cd_S80C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C24(Test_S80C24, "S80C24", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S80C25;
static Base_Class bases_S80C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C24 = {  "S80C24", // class name
  bases_S80C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C4  : S80C5_nt {
  ::S80C8_nt s80c4f0;
  void *s80c4f1[9];
  ::S80C19 s80c4f2;
  ::S80C10_nt s80c4f3;
  ::S80C24 s80c4f4;
  int s80c4f5;
  unsigned int s80c4f6:1;
  unsigned int s80c4f7:1;
  unsigned int s80c4f8:1;
  unsigned int s80c4f9:1;
  unsigned int s80c4f10:1;
  unsigned int s80c4f11:1;
  unsigned int s80c4f12:1;
  unsigned int s80c4f13:1;
  unsigned int s80c4f14:1;
  unsigned int s80c4f15:1;
  unsigned int s80c4f16:1;
  unsigned int s80c4f17:1;
  unsigned int s80c4f18:1;
  unsigned int s80c4f19:1;
  unsigned int s80c4f20:1;
  unsigned int s80c4f21:1;
  unsigned int s80c4f22:1;
  unsigned int s80c4f23:1;
  unsigned int s80c4f24:1;
  unsigned int s80c4f25:1;
  unsigned int s80c4f26:1;
  unsigned int s80c4f27:1;
  void *s80c4f28;
  char s80c4f29[2];
  ::S80C8_nt s80c4f30;
  ::S80C8_nt s80c4f31;
  ::S80C8_nt s80c4f32;
  void *s80c4f33;
  ::S80C21_nt s80c4f34;
  ::S80C21_nt s80c4f35;
  ::S80C21_nt s80c4f36;
  ::S80C21_nt s80c4f37;
  ::S80C21_nt s80c4f38;
  virtual  ~S80C4(); // _ZN5S80C4D1Ev
  virtual void  v146(); // _ZN5S80C44v146Ev
  virtual void  v147(); // _ZN5S80C44v147Ev
  virtual void  v148(); // _ZN5S80C44v148Ev
  virtual void  v149(); // _ZN5S80C44v149Ev
  virtual void  v150(); // _ZN5S80C44v150Ev
  virtual void  v151(); // _ZN5S80C44v151Ev
  virtual void  v152(); // _ZN5S80C44v152Ev
  virtual void  v153(); // _ZN5S80C44v153Ev
  virtual void  v154(); // _ZN5S80C44v154Ev
  virtual void  v155(); // _ZN5S80C44v155Ev
  virtual void  v156(); // _ZN5S80C44v156Ev
  virtual void  v157(); // _ZN5S80C44v157Ev
  virtual void  v158(); // _ZN5S80C44v158Ev
  virtual void  v159(); // _ZN5S80C44v159Ev
  virtual void  v160(); // _ZN5S80C44v160Ev
  virtual void  v161(); // _ZN5S80C44v161Ev
  virtual void  v162(); // _ZN5S80C44v162Ev
  virtual void  v163(); // _ZN5S80C44v163Ev
  virtual void  v164(); // _ZN5S80C44v164Ev
  virtual void  v165(); // _ZN5S80C44v165Ev
  virtual void  v166(); // _ZN5S80C44v166Ev
  virtual void  v167(); // _ZN5S80C44v167Ev
  virtual void  v168(); // _ZN5S80C44v168Ev
  virtual void  v169(); // _ZN5S80C44v169Ev
  virtual void  v170(); // _ZN5S80C44v170Ev
  virtual void  v171(); // _ZN5S80C44v171Ev
  virtual void  v172(); // _ZN5S80C44v172Ev
  virtual void  v173(); // _ZN5S80C44v173Ev
  virtual void  v174(); // _ZN5S80C44v174Ev
  virtual void  v175(); // _ZN5S80C44v175Ev
  virtual void  v176(); // _ZN5S80C44v176Ev
  virtual void  v177(); // _ZN5S80C44v177Ev
  virtual void  v178(); // _ZN5S80C44v178Ev
  virtual void  v179(); // _ZN5S80C44v179Ev
  virtual void  v180(); // _ZN5S80C44v180Ev
  virtual void  v181(); // _ZN5S80C44v181Ev
  virtual void  v182(); // _ZN5S80C44v182Ev
  virtual void  v183(); // _ZN5S80C44v183Ev
  virtual void  v184(); // _ZN5S80C44v184Ev
  S80C4(); // tgen
};
//SIG(-1 S80C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC12 FC7 FC15{ BC16{ m FC17{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC5 FC5 FC5 Fp FC14 FC14 FC14 FC14 FC14}


 S80C4 ::~S80C4(){ note_dtor("S80C4", this);}
void  S80C4 ::v146(){vfunc_called(this, "_ZN5S80C44v146Ev");}
void  S80C4 ::v147(){vfunc_called(this, "_ZN5S80C44v147Ev");}
void  S80C4 ::v148(){vfunc_called(this, "_ZN5S80C44v148Ev");}
void  S80C4 ::v149(){vfunc_called(this, "_ZN5S80C44v149Ev");}
void  S80C4 ::v150(){vfunc_called(this, "_ZN5S80C44v150Ev");}
void  S80C4 ::v151(){vfunc_called(this, "_ZN5S80C44v151Ev");}
void  S80C4 ::v152(){vfunc_called(this, "_ZN5S80C44v152Ev");}
void  S80C4 ::v153(){vfunc_called(this, "_ZN5S80C44v153Ev");}
void  S80C4 ::v154(){vfunc_called(this, "_ZN5S80C44v154Ev");}
void  S80C4 ::v155(){vfunc_called(this, "_ZN5S80C44v155Ev");}
void  S80C4 ::v156(){vfunc_called(this, "_ZN5S80C44v156Ev");}
void  S80C4 ::v157(){vfunc_called(this, "_ZN5S80C44v157Ev");}
void  S80C4 ::v158(){vfunc_called(this, "_ZN5S80C44v158Ev");}
void  S80C4 ::v159(){vfunc_called(this, "_ZN5S80C44v159Ev");}
void  S80C4 ::v160(){vfunc_called(this, "_ZN5S80C44v160Ev");}
void  S80C4 ::v161(){vfunc_called(this, "_ZN5S80C44v161Ev");}
void  S80C4 ::v162(){vfunc_called(this, "_ZN5S80C44v162Ev");}
void  S80C4 ::v163(){vfunc_called(this, "_ZN5S80C44v163Ev");}
void  S80C4 ::v164(){vfunc_called(this, "_ZN5S80C44v164Ev");}
void  S80C4 ::v165(){vfunc_called(this, "_ZN5S80C44v165Ev");}
void  S80C4 ::v166(){vfunc_called(this, "_ZN5S80C44v166Ev");}
void  S80C4 ::v167(){vfunc_called(this, "_ZN5S80C44v167Ev");}
void  S80C4 ::v168(){vfunc_called(this, "_ZN5S80C44v168Ev");}
void  S80C4 ::v169(){vfunc_called(this, "_ZN5S80C44v169Ev");}
void  S80C4 ::v170(){vfunc_called(this, "_ZN5S80C44v170Ev");}
void  S80C4 ::v171(){vfunc_called(this, "_ZN5S80C44v171Ev");}
void  S80C4 ::v172(){vfunc_called(this, "_ZN5S80C44v172Ev");}
void  S80C4 ::v173(){vfunc_called(this, "_ZN5S80C44v173Ev");}
void  S80C4 ::v174(){vfunc_called(this, "_ZN5S80C44v174Ev");}
void  S80C4 ::v175(){vfunc_called(this, "_ZN5S80C44v175Ev");}
void  S80C4 ::v176(){vfunc_called(this, "_ZN5S80C44v176Ev");}
void  S80C4 ::v177(){vfunc_called(this, "_ZN5S80C44v177Ev");}
void  S80C4 ::v178(){vfunc_called(this, "_ZN5S80C44v178Ev");}
void  S80C4 ::v179(){vfunc_called(this, "_ZN5S80C44v179Ev");}
void  S80C4 ::v180(){vfunc_called(this, "_ZN5S80C44v180Ev");}
void  S80C4 ::v181(){vfunc_called(this, "_ZN5S80C44v181Ev");}
void  S80C4 ::v182(){vfunc_called(this, "_ZN5S80C44v182Ev");}
void  S80C4 ::v183(){vfunc_called(this, "_ZN5S80C44v183Ev");}
void  S80C4 ::v184(){vfunc_called(this, "_ZN5S80C44v184Ev");}
S80C4 ::S80C4(){ note_ctor("S80C4", this);} // tgen

static void Test_S80C4()
{
  extern Class_Descriptor cd_S80C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S80C4, buf);
    S80C4 *dp, &lv = *(dp=new (buf) S80C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S80C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C4)");
    check_base_class_offset(lv, (S80C7_nt*)(S80C6_nt*)(S80C5_nt*), 0, "S80C4");
    check_base_class_offset(lv, (S80C6_nt*)(S80C5_nt*), 0, "S80C4");
    check_base_class_offset(lv, (S80C5_nt*), 0, "S80C4");
    check_field_offset(lv, s80c4f0, ABISELECT(464,352), "S80C4.s80c4f0");
    check_field_offset(lv, s80c4f1, ABISELECT(472,360), "S80C4.s80c4f1");
    check_field_offset(lv, s80c4f2, ABISELECT(544,396), "S80C4.s80c4f2");
    check_field_offset(lv, s80c4f3, ABISELECT(560,408), "S80C4.s80c4f3");
    check_field_offset(lv, s80c4f4, ABISELECT(576,420), "S80C4.s80c4f4");
    check_field_offset(lv, s80c4f5, ABISELECT(608,440), "S80C4.s80c4f5");
    set_bf_and_test(lv, s80c4f6, ABISELECT(612,444), 0, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f7, ABISELECT(612,444), 1, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f8, ABISELECT(612,444), 2, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f9, ABISELECT(612,444), 3, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f10, ABISELECT(612,444), 4, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f11, ABISELECT(612,444), 5, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f12, ABISELECT(612,444), 6, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f13, ABISELECT(612,444), 7, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f14, ABISELECT(613,445), 0, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f15, ABISELECT(613,445), 1, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f16, ABISELECT(613,445), 2, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f17, ABISELECT(613,445), 3, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f18, ABISELECT(613,445), 4, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f19, ABISELECT(613,445), 5, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f20, ABISELECT(613,445), 6, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f21, ABISELECT(613,445), 7, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f22, ABISELECT(614,446), 0, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f23, ABISELECT(614,446), 1, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f24, ABISELECT(614,446), 2, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f25, ABISELECT(614,446), 3, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f26, ABISELECT(614,446), 4, 1, 1, "S80C4");
    set_bf_and_test(lv, s80c4f27, ABISELECT(614,446), 5, 1, 1, "S80C4");
    check_field_offset(lv, s80c4f28, ABISELECT(616,448), "S80C4.s80c4f28");
    check_field_offset(lv, s80c4f29, ABISELECT(624,452), "S80C4.s80c4f29");
    check_field_offset(lv, s80c4f30, ABISELECT(628,456), "S80C4.s80c4f30");
    check_field_offset(lv, s80c4f31, ABISELECT(636,464), "S80C4.s80c4f31");
    check_field_offset(lv, s80c4f32, ABISELECT(644,472), "S80C4.s80c4f32");
    check_field_offset(lv, s80c4f33, ABISELECT(656,480), "S80C4.s80c4f33");
    check_field_offset(lv, s80c4f34, ABISELECT(664,484), "S80C4.s80c4f34");
    check_field_offset(lv, s80c4f35, ABISELECT(680,496), "S80C4.s80c4f35");
    check_field_offset(lv, s80c4f36, ABISELECT(696,508), "S80C4.s80c4f36");
    check_field_offset(lv, s80c4f37, ABISELECT(712,520), "S80C4.s80c4f37");
    check_field_offset(lv, s80c4f38, ABISELECT(728,532), "S80C4.s80c4f38");
    test_class_info(&lv, &cd_S80C4);
    dp->~S80C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C4(Test_S80C4, "S80C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN5S80C4C1Ev();
extern void _ZN5S80C4D1Ev();
Name_Map name_map_S80C4[] = {
  NSPAIR(_ZN5S80C4C1Ev),
  NSPAIR(_ZN5S80C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
extern Class_Descriptor cd_S80C6_nt;
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
extern Class_Descriptor cd_S80C5_nt;
extern VTBL_ENTRY _ZTI8S80C5_nt[];
extern  VTBL_ENTRY _ZTV8S80C5_nt[];
static Base_Class bases_S80C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S80C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S80C4[];
extern void _ZN5S80C4D1Ev();
extern void _ZN5S80C4D0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
extern void _ZN8S80C5_nt3v70Ev();
extern void _ZN8S80C5_nt3v71Ev();
extern void _ZN8S80C5_nt3v72Ev();
extern void _ZN8S80C5_nt3v73Ev();
extern void _ZN8S80C5_nt3v74Ev();
extern void _ZN8S80C5_nt3v75Ev();
extern void _ZN8S80C5_nt3v76Ev();
extern void _ZN8S80C5_nt3v77Ev();
extern void _ZN8S80C5_nt3v78Ev();
extern void _ZN8S80C5_nt3v79Ev();
extern void _ZN8S80C5_nt3v80Ev();
extern void _ZN8S80C5_nt3v81Ev();
extern void _ZN8S80C5_nt3v82Ev();
extern void _ZN8S80C5_nt3v83Ev();
extern void _ZN8S80C5_nt3v84Ev();
extern void _ZN8S80C5_nt3v85Ev();
extern void _ZN8S80C5_nt3v86Ev();
extern void _ZN8S80C5_nt3v87Ev();
extern void _ZN8S80C5_nt3v88Ev();
extern void _ZN8S80C5_nt3v89Ev();
extern void _ZN8S80C5_nt3v90Ev();
extern void _ZN8S80C5_nt3v91Ev();
extern void _ZN8S80C5_nt3v92Ev();
extern void _ZN8S80C5_nt3v93Ev();
extern void _ZN8S80C5_nt3v94Ev();
extern void _ZN8S80C5_nt3v95Ev();
extern void _ZN8S80C5_nt3v96Ev();
extern void _ZN8S80C5_nt3v97Ev();
extern void _ZN8S80C5_nt3v98Ev();
extern void _ZN8S80C5_nt3v99Ev();
extern void _ZN8S80C5_nt4v100Ev();
extern void _ZN8S80C5_nt4v101Ev();
extern void _ZN8S80C5_nt4v102Ev();
extern void _ZN8S80C5_nt4v103Ev();
extern void _ZN8S80C5_nt4v104Ev();
extern void _ZN8S80C5_nt4v105Ev();
extern void _ZN8S80C5_nt4v106Ev();
extern void _ZN8S80C5_nt4v107Ev();
extern void _ZN8S80C5_nt4v108Ev();
extern void _ZN8S80C5_nt4v109Ev();
extern void _ZN8S80C5_nt4v110Ev();
extern void _ZN8S80C5_nt4v111Ev();
extern void _ZN8S80C5_nt4v112Ev();
extern void _ZN8S80C5_nt4v113Ev();
extern void _ZN8S80C5_nt4v114Ev();
extern void _ZN8S80C5_nt4v115Ev();
extern void _ZN8S80C5_nt4v116Ev();
extern void _ZN8S80C5_nt4v117Ev();
extern void _ZN8S80C5_nt4v118Ev();
extern void _ZN8S80C5_nt4v119Ev();
extern void _ZN8S80C5_nt4v120Ev();
extern void _ZN8S80C5_nt4v121Ev();
extern void _ZN8S80C5_nt4v122Ev();
extern void _ZN8S80C5_nt4v123Ev();
extern void _ZN8S80C5_nt4v124Ev();
extern void _ZN8S80C5_nt4v125Ev();
extern void _ZN8S80C5_nt4v126Ev();
extern void _ZN8S80C5_nt4v127Ev();
extern void _ZN8S80C5_nt4v128Ev();
extern void _ZN8S80C5_nt4v129Ev();
extern void _ZN8S80C5_nt4v130Ev();
extern void _ZN8S80C5_nt4v131Ev();
extern void _ZN8S80C5_nt4v132Ev();
extern void _ZN8S80C5_nt4v133Ev();
extern void _ZN8S80C5_nt4v134Ev();
extern void _ZN8S80C5_nt4v135Ev();
extern void _ZN8S80C5_nt4v136Ev();
extern void _ZN8S80C5_nt4v137Ev();
extern void _ZN8S80C5_nt4v138Ev();
extern void _ZN8S80C5_nt4v139Ev();
extern void _ZN8S80C5_nt4v140Ev();
extern void _ZN8S80C5_nt4v141Ev();
extern void _ZN8S80C5_nt4v142Ev();
extern void _ZN8S80C5_nt4v143Ev();
extern void _ZN8S80C5_nt4v144Ev();
extern void _ZN8S80C5_nt4v145Ev();
extern void _ZN5S80C44v146Ev();
extern void _ZN5S80C44v147Ev();
extern void _ZN5S80C44v148Ev();
extern void _ZN5S80C44v149Ev();
extern void _ZN5S80C44v150Ev();
extern void _ZN5S80C44v151Ev();
extern void _ZN5S80C44v152Ev();
extern void _ZN5S80C44v153Ev();
extern void _ZN5S80C44v154Ev();
extern void _ZN5S80C44v155Ev();
extern void _ZN5S80C44v156Ev();
extern void _ZN5S80C44v157Ev();
extern void _ZN5S80C44v158Ev();
extern void _ZN5S80C44v159Ev();
extern void _ZN5S80C44v160Ev();
extern void _ZN5S80C44v161Ev();
extern void _ZN5S80C44v162Ev();
extern void _ZN5S80C44v163Ev();
extern void _ZN5S80C44v164Ev();
extern void _ZN5S80C44v165Ev();
extern void _ZN5S80C44v166Ev();
extern void _ZN5S80C44v167Ev();
extern void _ZN5S80C44v168Ev();
extern void _ZN5S80C44v169Ev();
extern void _ZN5S80C44v170Ev();
extern void _ZN5S80C44v171Ev();
extern void _ZN5S80C44v172Ev();
extern void _ZN5S80C44v173Ev();
extern void _ZN5S80C44v174Ev();
extern void _ZN5S80C44v175Ev();
extern void _ZN5S80C44v176Ev();
extern void _ZN5S80C44v177Ev();
extern void _ZN5S80C44v178Ev();
extern void _ZN5S80C44v179Ev();
extern void _ZN5S80C44v180Ev();
extern void _ZN5S80C44v181Ev();
extern void _ZN5S80C44v182Ev();
extern void _ZN5S80C44v183Ev();
extern void _ZN5S80C44v184Ev();
static  VTBL_ENTRY vtc_S80C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S80C4[0]),
  (VTBL_ENTRY)&_ZN5S80C4D1Ev,
  (VTBL_ENTRY)&_ZN5S80C4D0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN5S80C44v146Ev,
  (VTBL_ENTRY)&_ZN5S80C44v147Ev,
  (VTBL_ENTRY)&_ZN5S80C44v148Ev,
  (VTBL_ENTRY)&_ZN5S80C44v149Ev,
  (VTBL_ENTRY)&_ZN5S80C44v150Ev,
  (VTBL_ENTRY)&_ZN5S80C44v151Ev,
  (VTBL_ENTRY)&_ZN5S80C44v152Ev,
  (VTBL_ENTRY)&_ZN5S80C44v153Ev,
  (VTBL_ENTRY)&_ZN5S80C44v154Ev,
  (VTBL_ENTRY)&_ZN5S80C44v155Ev,
  (VTBL_ENTRY)&_ZN5S80C44v156Ev,
  (VTBL_ENTRY)&_ZN5S80C44v157Ev,
  (VTBL_ENTRY)&_ZN5S80C44v158Ev,
  (VTBL_ENTRY)&_ZN5S80C44v159Ev,
  (VTBL_ENTRY)&_ZN5S80C44v160Ev,
  (VTBL_ENTRY)&_ZN5S80C44v161Ev,
  (VTBL_ENTRY)&_ZN5S80C44v162Ev,
  (VTBL_ENTRY)&_ZN5S80C44v163Ev,
  (VTBL_ENTRY)&_ZN5S80C44v164Ev,
  (VTBL_ENTRY)&_ZN5S80C44v165Ev,
  (VTBL_ENTRY)&_ZN5S80C44v166Ev,
  (VTBL_ENTRY)&_ZN5S80C44v167Ev,
  (VTBL_ENTRY)&_ZN5S80C44v168Ev,
  (VTBL_ENTRY)&_ZN5S80C44v169Ev,
  (VTBL_ENTRY)&_ZN5S80C44v170Ev,
  (VTBL_ENTRY)&_ZN5S80C44v171Ev,
  (VTBL_ENTRY)&_ZN5S80C44v172Ev,
  (VTBL_ENTRY)&_ZN5S80C44v173Ev,
  (VTBL_ENTRY)&_ZN5S80C44v174Ev,
  (VTBL_ENTRY)&_ZN5S80C44v175Ev,
  (VTBL_ENTRY)&_ZN5S80C44v176Ev,
  (VTBL_ENTRY)&_ZN5S80C44v177Ev,
  (VTBL_ENTRY)&_ZN5S80C44v178Ev,
  (VTBL_ENTRY)&_ZN5S80C44v179Ev,
  (VTBL_ENTRY)&_ZN5S80C44v180Ev,
  (VTBL_ENTRY)&_ZN5S80C44v181Ev,
  (VTBL_ENTRY)&_ZN5S80C44v182Ev,
  (VTBL_ENTRY)&_ZN5S80C44v183Ev,
  (VTBL_ENTRY)&_ZN5S80C44v184Ev,
};
extern VTBL_ENTRY _ZTI5S80C4[];
extern  VTBL_ENTRY _ZTV5S80C4[];
Class_Descriptor cd_S80C4 = {  "S80C4", // class name
  bases_S80C4, 3,
  &(vtc_S80C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI5S80C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S80C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C3  : S80C4 {
  unsigned int s80c3f0:1;
  unsigned int s80c3f1:1;
  unsigned int s80c3f2:1;
  unsigned int s80c3f3:1;
  unsigned int s80c3f4:1;
  unsigned int s80c3f5:1;
  void *s80c3f6[8];
  ::S80C21_nt s80c3f7;
  ::S80C21_nt s80c3f8;
  ::S80C21_nt s80c3f9;
  virtual  ~S80C3(); // _ZN5S80C3D1Ev
  virtual void  v185(); // _ZN5S80C34v185Ev
  virtual void  v186(); // _ZN5S80C34v186Ev
  virtual void  v187(); // _ZN5S80C34v187Ev
  virtual void  v188(); // _ZN5S80C34v188Ev
  virtual void  v189(); // _ZN5S80C34v189Ev
  virtual void  v190(); // _ZN5S80C34v190Ev
  virtual void  v191(); // _ZN5S80C34v191Ev
  virtual void  v192(); // _ZN5S80C34v192Ev
  virtual void  v193(); // _ZN5S80C34v193Ev
  virtual void  v194(); // _ZN5S80C34v194Ev
  virtual void  v195(); // _ZN5S80C34v195Ev
  virtual void  v196(); // _ZN5S80C34v196Ev
  virtual void  v197(); // _ZN5S80C34v197Ev
  virtual void  v198(); // _ZN5S80C34v198Ev
  virtual void  v199(); // _ZN5S80C34v199Ev
  virtual void  v200(); // _ZN5S80C34v200Ev
  virtual void  v201(); // _ZN5S80C34v201Ev
  virtual void  v202(); // _ZN5S80C34v202Ev
  virtual void  v203(); // _ZN5S80C34v203Ev
  virtual void  v204(); // _ZN5S80C34v204Ev
  virtual void  v205(); // _ZN5S80C34v205Ev
  virtual void  v206(); // _ZN5S80C34v206Ev
  virtual void  v207(); // _ZN5S80C34v207Ev
  S80C3(); // tgen
};
//SIG(-1 S80C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC13 FC8 FC16{ BC17{ m FC18{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC6 FC6 FC6 Fp FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC15 FC15 FC15}


 S80C3 ::~S80C3(){ note_dtor("S80C3", this);}
void  S80C3 ::v185(){vfunc_called(this, "_ZN5S80C34v185Ev");}
void  S80C3 ::v186(){vfunc_called(this, "_ZN5S80C34v186Ev");}
void  S80C3 ::v187(){vfunc_called(this, "_ZN5S80C34v187Ev");}
void  S80C3 ::v188(){vfunc_called(this, "_ZN5S80C34v188Ev");}
void  S80C3 ::v189(){vfunc_called(this, "_ZN5S80C34v189Ev");}
void  S80C3 ::v190(){vfunc_called(this, "_ZN5S80C34v190Ev");}
void  S80C3 ::v191(){vfunc_called(this, "_ZN5S80C34v191Ev");}
void  S80C3 ::v192(){vfunc_called(this, "_ZN5S80C34v192Ev");}
void  S80C3 ::v193(){vfunc_called(this, "_ZN5S80C34v193Ev");}
void  S80C3 ::v194(){vfunc_called(this, "_ZN5S80C34v194Ev");}
void  S80C3 ::v195(){vfunc_called(this, "_ZN5S80C34v195Ev");}
void  S80C3 ::v196(){vfunc_called(this, "_ZN5S80C34v196Ev");}
void  S80C3 ::v197(){vfunc_called(this, "_ZN5S80C34v197Ev");}
void  S80C3 ::v198(){vfunc_called(this, "_ZN5S80C34v198Ev");}
void  S80C3 ::v199(){vfunc_called(this, "_ZN5S80C34v199Ev");}
void  S80C3 ::v200(){vfunc_called(this, "_ZN5S80C34v200Ev");}
void  S80C3 ::v201(){vfunc_called(this, "_ZN5S80C34v201Ev");}
void  S80C3 ::v202(){vfunc_called(this, "_ZN5S80C34v202Ev");}
void  S80C3 ::v203(){vfunc_called(this, "_ZN5S80C34v203Ev");}
void  S80C3 ::v204(){vfunc_called(this, "_ZN5S80C34v204Ev");}
void  S80C3 ::v205(){vfunc_called(this, "_ZN5S80C34v205Ev");}
void  S80C3 ::v206(){vfunc_called(this, "_ZN5S80C34v206Ev");}
void  S80C3 ::v207(){vfunc_called(this, "_ZN5S80C34v207Ev");}
S80C3 ::S80C3(){ note_ctor("S80C3", this);} // tgen

static void Test_S80C3()
{
  extern Class_Descriptor cd_S80C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S80C3, buf);
    S80C3 *dp, &lv = *(dp=new (buf) S80C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S80C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C3)");
    check_base_class_offset(lv, (S80C7_nt*)(S80C6_nt*)(S80C5_nt*)(S80C4*), 0, "S80C3");
    check_base_class_offset(lv, (S80C6_nt*)(S80C5_nt*)(S80C4*), 0, "S80C3");
    check_base_class_offset(lv, (S80C5_nt*)(S80C4*), 0, "S80C3");
    check_base_class_offset(lv, (S80C4*), 0, "S80C3");
    set_bf_and_test(lv, s80c3f0, ABISELECT(744,544), 0, 1, 1, "S80C3");
    set_bf_and_test(lv, s80c3f1, ABISELECT(744,544), 1, 1, 1, "S80C3");
    set_bf_and_test(lv, s80c3f2, ABISELECT(744,544), 2, 1, 1, "S80C3");
    set_bf_and_test(lv, s80c3f3, ABISELECT(744,544), 3, 1, 1, "S80C3");
    set_bf_and_test(lv, s80c3f4, ABISELECT(744,544), 4, 1, 1, "S80C3");
    set_bf_and_test(lv, s80c3f5, ABISELECT(744,544), 5, 1, 1, "S80C3");
    check_field_offset(lv, s80c3f6, ABISELECT(752,548), "S80C3.s80c3f6");
    check_field_offset(lv, s80c3f7, ABISELECT(816,580), "S80C3.s80c3f7");
    check_field_offset(lv, s80c3f8, ABISELECT(832,592), "S80C3.s80c3f8");
    check_field_offset(lv, s80c3f9, ABISELECT(848,604), "S80C3.s80c3f9");
    test_class_info(&lv, &cd_S80C3);
    dp->~S80C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C3(Test_S80C3, "S80C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN5S80C3C1Ev();
extern void _ZN5S80C3D1Ev();
Name_Map name_map_S80C3[] = {
  NSPAIR(_ZN5S80C3C1Ev),
  NSPAIR(_ZN5S80C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
extern Class_Descriptor cd_S80C6_nt;
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
extern Class_Descriptor cd_S80C5_nt;
extern VTBL_ENTRY _ZTI8S80C5_nt[];
extern  VTBL_ENTRY _ZTV8S80C5_nt[];
extern Class_Descriptor cd_S80C4;
extern VTBL_ENTRY _ZTI5S80C4[];
extern  VTBL_ENTRY _ZTV5S80C4[];
static Base_Class bases_S80C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S80C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S80C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S80C3[];
extern void _ZN5S80C3D1Ev();
extern void _ZN5S80C3D0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
extern void _ZN8S80C5_nt3v70Ev();
extern void _ZN8S80C5_nt3v71Ev();
extern void _ZN8S80C5_nt3v72Ev();
extern void _ZN8S80C5_nt3v73Ev();
extern void _ZN8S80C5_nt3v74Ev();
extern void _ZN8S80C5_nt3v75Ev();
extern void _ZN8S80C5_nt3v76Ev();
extern void _ZN8S80C5_nt3v77Ev();
extern void _ZN8S80C5_nt3v78Ev();
extern void _ZN8S80C5_nt3v79Ev();
extern void _ZN8S80C5_nt3v80Ev();
extern void _ZN8S80C5_nt3v81Ev();
extern void _ZN8S80C5_nt3v82Ev();
extern void _ZN8S80C5_nt3v83Ev();
extern void _ZN8S80C5_nt3v84Ev();
extern void _ZN8S80C5_nt3v85Ev();
extern void _ZN8S80C5_nt3v86Ev();
extern void _ZN8S80C5_nt3v87Ev();
extern void _ZN8S80C5_nt3v88Ev();
extern void _ZN8S80C5_nt3v89Ev();
extern void _ZN8S80C5_nt3v90Ev();
extern void _ZN8S80C5_nt3v91Ev();
extern void _ZN8S80C5_nt3v92Ev();
extern void _ZN8S80C5_nt3v93Ev();
extern void _ZN8S80C5_nt3v94Ev();
extern void _ZN8S80C5_nt3v95Ev();
extern void _ZN8S80C5_nt3v96Ev();
extern void _ZN8S80C5_nt3v97Ev();
extern void _ZN8S80C5_nt3v98Ev();
extern void _ZN8S80C5_nt3v99Ev();
extern void _ZN8S80C5_nt4v100Ev();
extern void _ZN8S80C5_nt4v101Ev();
extern void _ZN8S80C5_nt4v102Ev();
extern void _ZN8S80C5_nt4v103Ev();
extern void _ZN8S80C5_nt4v104Ev();
extern void _ZN8S80C5_nt4v105Ev();
extern void _ZN8S80C5_nt4v106Ev();
extern void _ZN8S80C5_nt4v107Ev();
extern void _ZN8S80C5_nt4v108Ev();
extern void _ZN8S80C5_nt4v109Ev();
extern void _ZN8S80C5_nt4v110Ev();
extern void _ZN8S80C5_nt4v111Ev();
extern void _ZN8S80C5_nt4v112Ev();
extern void _ZN8S80C5_nt4v113Ev();
extern void _ZN8S80C5_nt4v114Ev();
extern void _ZN8S80C5_nt4v115Ev();
extern void _ZN8S80C5_nt4v116Ev();
extern void _ZN8S80C5_nt4v117Ev();
extern void _ZN8S80C5_nt4v118Ev();
extern void _ZN8S80C5_nt4v119Ev();
extern void _ZN8S80C5_nt4v120Ev();
extern void _ZN8S80C5_nt4v121Ev();
extern void _ZN8S80C5_nt4v122Ev();
extern void _ZN8S80C5_nt4v123Ev();
extern void _ZN8S80C5_nt4v124Ev();
extern void _ZN8S80C5_nt4v125Ev();
extern void _ZN8S80C5_nt4v126Ev();
extern void _ZN8S80C5_nt4v127Ev();
extern void _ZN8S80C5_nt4v128Ev();
extern void _ZN8S80C5_nt4v129Ev();
extern void _ZN8S80C5_nt4v130Ev();
extern void _ZN8S80C5_nt4v131Ev();
extern void _ZN8S80C5_nt4v132Ev();
extern void _ZN8S80C5_nt4v133Ev();
extern void _ZN8S80C5_nt4v134Ev();
extern void _ZN8S80C5_nt4v135Ev();
extern void _ZN8S80C5_nt4v136Ev();
extern void _ZN8S80C5_nt4v137Ev();
extern void _ZN8S80C5_nt4v138Ev();
extern void _ZN8S80C5_nt4v139Ev();
extern void _ZN8S80C5_nt4v140Ev();
extern void _ZN8S80C5_nt4v141Ev();
extern void _ZN8S80C5_nt4v142Ev();
extern void _ZN8S80C5_nt4v143Ev();
extern void _ZN8S80C5_nt4v144Ev();
extern void _ZN8S80C5_nt4v145Ev();
extern void _ZN5S80C44v146Ev();
extern void _ZN5S80C44v147Ev();
extern void _ZN5S80C44v148Ev();
extern void _ZN5S80C44v149Ev();
extern void _ZN5S80C44v150Ev();
extern void _ZN5S80C44v151Ev();
extern void _ZN5S80C44v152Ev();
extern void _ZN5S80C44v153Ev();
extern void _ZN5S80C44v154Ev();
extern void _ZN5S80C44v155Ev();
extern void _ZN5S80C44v156Ev();
extern void _ZN5S80C44v157Ev();
extern void _ZN5S80C44v158Ev();
extern void _ZN5S80C44v159Ev();
extern void _ZN5S80C44v160Ev();
extern void _ZN5S80C44v161Ev();
extern void _ZN5S80C44v162Ev();
extern void _ZN5S80C44v163Ev();
extern void _ZN5S80C44v164Ev();
extern void _ZN5S80C44v165Ev();
extern void _ZN5S80C44v166Ev();
extern void _ZN5S80C44v167Ev();
extern void _ZN5S80C44v168Ev();
extern void _ZN5S80C44v169Ev();
extern void _ZN5S80C44v170Ev();
extern void _ZN5S80C44v171Ev();
extern void _ZN5S80C44v172Ev();
extern void _ZN5S80C44v173Ev();
extern void _ZN5S80C44v174Ev();
extern void _ZN5S80C44v175Ev();
extern void _ZN5S80C44v176Ev();
extern void _ZN5S80C44v177Ev();
extern void _ZN5S80C44v178Ev();
extern void _ZN5S80C44v179Ev();
extern void _ZN5S80C44v180Ev();
extern void _ZN5S80C44v181Ev();
extern void _ZN5S80C44v182Ev();
extern void _ZN5S80C44v183Ev();
extern void _ZN5S80C44v184Ev();
extern void _ZN5S80C34v185Ev();
extern void _ZN5S80C34v186Ev();
extern void _ZN5S80C34v187Ev();
extern void _ZN5S80C34v188Ev();
extern void _ZN5S80C34v189Ev();
extern void _ZN5S80C34v190Ev();
extern void _ZN5S80C34v191Ev();
extern void _ZN5S80C34v192Ev();
extern void _ZN5S80C34v193Ev();
extern void _ZN5S80C34v194Ev();
extern void _ZN5S80C34v195Ev();
extern void _ZN5S80C34v196Ev();
extern void _ZN5S80C34v197Ev();
extern void _ZN5S80C34v198Ev();
extern void _ZN5S80C34v199Ev();
extern void _ZN5S80C34v200Ev();
extern void _ZN5S80C34v201Ev();
extern void _ZN5S80C34v202Ev();
extern void _ZN5S80C34v203Ev();
extern void _ZN5S80C34v204Ev();
extern void _ZN5S80C34v205Ev();
extern void _ZN5S80C34v206Ev();
extern void _ZN5S80C34v207Ev();
static  VTBL_ENTRY vtc_S80C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S80C3[0]),
  (VTBL_ENTRY)&_ZN5S80C3D1Ev,
  (VTBL_ENTRY)&_ZN5S80C3D0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN5S80C44v146Ev,
  (VTBL_ENTRY)&_ZN5S80C44v147Ev,
  (VTBL_ENTRY)&_ZN5S80C44v148Ev,
  (VTBL_ENTRY)&_ZN5S80C44v149Ev,
  (VTBL_ENTRY)&_ZN5S80C44v150Ev,
  (VTBL_ENTRY)&_ZN5S80C44v151Ev,
  (VTBL_ENTRY)&_ZN5S80C44v152Ev,
  (VTBL_ENTRY)&_ZN5S80C44v153Ev,
  (VTBL_ENTRY)&_ZN5S80C44v154Ev,
  (VTBL_ENTRY)&_ZN5S80C44v155Ev,
  (VTBL_ENTRY)&_ZN5S80C44v156Ev,
  (VTBL_ENTRY)&_ZN5S80C44v157Ev,
  (VTBL_ENTRY)&_ZN5S80C44v158Ev,
  (VTBL_ENTRY)&_ZN5S80C44v159Ev,
  (VTBL_ENTRY)&_ZN5S80C44v160Ev,
  (VTBL_ENTRY)&_ZN5S80C44v161Ev,
  (VTBL_ENTRY)&_ZN5S80C44v162Ev,
  (VTBL_ENTRY)&_ZN5S80C44v163Ev,
  (VTBL_ENTRY)&_ZN5S80C44v164Ev,
  (VTBL_ENTRY)&_ZN5S80C44v165Ev,
  (VTBL_ENTRY)&_ZN5S80C44v166Ev,
  (VTBL_ENTRY)&_ZN5S80C44v167Ev,
  (VTBL_ENTRY)&_ZN5S80C44v168Ev,
  (VTBL_ENTRY)&_ZN5S80C44v169Ev,
  (VTBL_ENTRY)&_ZN5S80C44v170Ev,
  (VTBL_ENTRY)&_ZN5S80C44v171Ev,
  (VTBL_ENTRY)&_ZN5S80C44v172Ev,
  (VTBL_ENTRY)&_ZN5S80C44v173Ev,
  (VTBL_ENTRY)&_ZN5S80C44v174Ev,
  (VTBL_ENTRY)&_ZN5S80C44v175Ev,
  (VTBL_ENTRY)&_ZN5S80C44v176Ev,
  (VTBL_ENTRY)&_ZN5S80C44v177Ev,
  (VTBL_ENTRY)&_ZN5S80C44v178Ev,
  (VTBL_ENTRY)&_ZN5S80C44v179Ev,
  (VTBL_ENTRY)&_ZN5S80C44v180Ev,
  (VTBL_ENTRY)&_ZN5S80C44v181Ev,
  (VTBL_ENTRY)&_ZN5S80C44v182Ev,
  (VTBL_ENTRY)&_ZN5S80C44v183Ev,
  (VTBL_ENTRY)&_ZN5S80C44v184Ev,
  (VTBL_ENTRY)&_ZN5S80C34v185Ev,
  (VTBL_ENTRY)&_ZN5S80C34v186Ev,
  (VTBL_ENTRY)&_ZN5S80C34v187Ev,
  (VTBL_ENTRY)&_ZN5S80C34v188Ev,
  (VTBL_ENTRY)&_ZN5S80C34v189Ev,
  (VTBL_ENTRY)&_ZN5S80C34v190Ev,
  (VTBL_ENTRY)&_ZN5S80C34v191Ev,
  (VTBL_ENTRY)&_ZN5S80C34v192Ev,
  (VTBL_ENTRY)&_ZN5S80C34v193Ev,
  (VTBL_ENTRY)&_ZN5S80C34v194Ev,
  (VTBL_ENTRY)&_ZN5S80C34v195Ev,
  (VTBL_ENTRY)&_ZN5S80C34v196Ev,
  (VTBL_ENTRY)&_ZN5S80C34v197Ev,
  (VTBL_ENTRY)&_ZN5S80C34v198Ev,
  (VTBL_ENTRY)&_ZN5S80C34v199Ev,
  (VTBL_ENTRY)&_ZN5S80C34v200Ev,
  (VTBL_ENTRY)&_ZN5S80C34v201Ev,
  (VTBL_ENTRY)&_ZN5S80C34v202Ev,
  (VTBL_ENTRY)&_ZN5S80C34v203Ev,
  (VTBL_ENTRY)&_ZN5S80C34v204Ev,
  (VTBL_ENTRY)&_ZN5S80C34v205Ev,
  (VTBL_ENTRY)&_ZN5S80C34v206Ev,
  (VTBL_ENTRY)&_ZN5S80C34v207Ev,
};
extern VTBL_ENTRY _ZTI5S80C3[];
extern  VTBL_ENTRY _ZTV5S80C3[];
Class_Descriptor cd_S80C3 = {  "S80C3", // class name
  bases_S80C3, 4,
  &(vtc_S80C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI5S80C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S80C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C30  : S80C12_nt {
};
//SIG(-1 S80C30) C1{ BC2{ m Fp Fi[2]}}



static void Test_S80C30()
{
  extern Class_Descriptor cd_S80C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C30, buf);
    S80C30 &lv = *(new (buf) S80C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C30)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S80C30");
    test_class_info(&lv, &cd_S80C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C30(Test_S80C30, "S80C30", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C30 = {  "S80C30", // class name
  bases_S80C30, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C29  : S80C30 {
};
//SIG(-1 S80C29) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S80C29()
{
  extern Class_Descriptor cd_S80C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C29, buf);
    S80C29 &lv = *(new (buf) S80C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C29)");
    check_base_class_offset(lv, (S80C12_nt*)(S80C30*), 0, "S80C29");
    check_base_class_offset(lv, (S80C30*), 0, "S80C29");
    test_class_info(&lv, &cd_S80C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C29(Test_S80C29, "S80C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C30;
static Base_Class bases_S80C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C29 = {  "S80C29", // class name
  bases_S80C29, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C28_nt  : S80C29 {
};
//SIG(-1 S80C28_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S80C28_nt

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C30;
extern Class_Descriptor cd_S80C29;
static Base_Class bases_S80C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S80C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C2  : S80C3 {
  void *s80c2f0[2];
  int s80c2f1[2];
  char s80c2f2;
  void *s80c2f3;
  unsigned int s80c2f4:1;
  unsigned int s80c2f5:1;
  ::S80C28_nt s80c2f6;
  virtual  ~S80C2(); // _ZN5S80C2D1Ev
  virtual void  v208(); // _ZN5S80C24v208Ev
  virtual void  v209(); // _ZN5S80C24v209Ev
  virtual void  v210(); // _ZN5S80C24v210Ev
  virtual void  v211(); // _ZN5S80C24v211Ev
  virtual void  v212(); // _ZN5S80C24v212Ev
  virtual void  v213(); // _ZN5S80C24v213Ev
  virtual void  v214(); // _ZN5S80C24v214Ev
  virtual void  v215(); // _ZN5S80C24v215Ev
  S80C2(); // tgen
};
//SIG(-1 S80C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 FC7 Fp[9] FC14 FC9 FC17{ BC18{ m FC19{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC7 FC7 FC7 Fp FC16 FC16 FC16 FC16 FC16} vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC16 FC16 FC16} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC20{ BC21{ BC22{ BC11}}}}


 S80C2 ::~S80C2(){ note_dtor("S80C2", this);}
void  S80C2 ::v208(){vfunc_called(this, "_ZN5S80C24v208Ev");}
void  S80C2 ::v209(){vfunc_called(this, "_ZN5S80C24v209Ev");}
void  S80C2 ::v210(){vfunc_called(this, "_ZN5S80C24v210Ev");}
void  S80C2 ::v211(){vfunc_called(this, "_ZN5S80C24v211Ev");}
void  S80C2 ::v212(){vfunc_called(this, "_ZN5S80C24v212Ev");}
void  S80C2 ::v213(){vfunc_called(this, "_ZN5S80C24v213Ev");}
void  S80C2 ::v214(){vfunc_called(this, "_ZN5S80C24v214Ev");}
void  S80C2 ::v215(){vfunc_called(this, "_ZN5S80C24v215Ev");}
S80C2 ::S80C2(){ note_ctor("S80C2", this);} // tgen

static void Test_S80C2()
{
  extern Class_Descriptor cd_S80C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,165)];
    init_test(&cd_S80C2, buf);
    S80C2 *dp, &lv = *(dp=new (buf) S80C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,656), "sizeof(S80C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C2)");
    check_base_class_offset(lv, (S80C7_nt*)(S80C6_nt*)(S80C5_nt*)(S80C4*)(S80C3*), 0, "S80C2");
    check_base_class_offset(lv, (S80C6_nt*)(S80C5_nt*)(S80C4*)(S80C3*), 0, "S80C2");
    check_base_class_offset(lv, (S80C5_nt*)(S80C4*)(S80C3*), 0, "S80C2");
    check_base_class_offset(lv, (S80C4*)(S80C3*), 0, "S80C2");
    check_base_class_offset(lv, (S80C3*), 0, "S80C2");
    check_field_offset(lv, s80c2f0, ABISELECT(864,616), "S80C2.s80c2f0");
    check_field_offset(lv, s80c2f1, ABISELECT(880,624), "S80C2.s80c2f1");
    check_field_offset(lv, s80c2f2, ABISELECT(888,632), "S80C2.s80c2f2");
    check_field_offset(lv, s80c2f3, ABISELECT(896,636), "S80C2.s80c2f3");
    set_bf_and_test(lv, s80c2f4, ABISELECT(904,640), 0, 1, 1, "S80C2");
    set_bf_and_test(lv, s80c2f5, ABISELECT(904,640), 1, 1, 1, "S80C2");
    check_field_offset(lv, s80c2f6, ABISELECT(912,644), "S80C2.s80c2f6");
    test_class_info(&lv, &cd_S80C2);
    dp->~S80C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C2(Test_S80C2, "S80C2", ABISELECT(928,656));

#else // __cplusplus

extern void _ZN5S80C2C1Ev();
extern void _ZN5S80C2D1Ev();
Name_Map name_map_S80C2[] = {
  NSPAIR(_ZN5S80C2C1Ev),
  NSPAIR(_ZN5S80C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
extern Class_Descriptor cd_S80C6_nt;
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
extern Class_Descriptor cd_S80C5_nt;
extern VTBL_ENTRY _ZTI8S80C5_nt[];
extern  VTBL_ENTRY _ZTV8S80C5_nt[];
extern Class_Descriptor cd_S80C4;
extern VTBL_ENTRY _ZTI5S80C4[];
extern  VTBL_ENTRY _ZTV5S80C4[];
extern Class_Descriptor cd_S80C3;
extern VTBL_ENTRY _ZTI5S80C3[];
extern  VTBL_ENTRY _ZTV5S80C3[];
static Base_Class bases_S80C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S80C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S80C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S80C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S80C2[];
extern void _ZN5S80C2D1Ev();
extern void _ZN5S80C2D0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
extern void _ZN8S80C5_nt3v70Ev();
extern void _ZN8S80C5_nt3v71Ev();
extern void _ZN8S80C5_nt3v72Ev();
extern void _ZN8S80C5_nt3v73Ev();
extern void _ZN8S80C5_nt3v74Ev();
extern void _ZN8S80C5_nt3v75Ev();
extern void _ZN8S80C5_nt3v76Ev();
extern void _ZN8S80C5_nt3v77Ev();
extern void _ZN8S80C5_nt3v78Ev();
extern void _ZN8S80C5_nt3v79Ev();
extern void _ZN8S80C5_nt3v80Ev();
extern void _ZN8S80C5_nt3v81Ev();
extern void _ZN8S80C5_nt3v82Ev();
extern void _ZN8S80C5_nt3v83Ev();
extern void _ZN8S80C5_nt3v84Ev();
extern void _ZN8S80C5_nt3v85Ev();
extern void _ZN8S80C5_nt3v86Ev();
extern void _ZN8S80C5_nt3v87Ev();
extern void _ZN8S80C5_nt3v88Ev();
extern void _ZN8S80C5_nt3v89Ev();
extern void _ZN8S80C5_nt3v90Ev();
extern void _ZN8S80C5_nt3v91Ev();
extern void _ZN8S80C5_nt3v92Ev();
extern void _ZN8S80C5_nt3v93Ev();
extern void _ZN8S80C5_nt3v94Ev();
extern void _ZN8S80C5_nt3v95Ev();
extern void _ZN8S80C5_nt3v96Ev();
extern void _ZN8S80C5_nt3v97Ev();
extern void _ZN8S80C5_nt3v98Ev();
extern void _ZN8S80C5_nt3v99Ev();
extern void _ZN8S80C5_nt4v100Ev();
extern void _ZN8S80C5_nt4v101Ev();
extern void _ZN8S80C5_nt4v102Ev();
extern void _ZN8S80C5_nt4v103Ev();
extern void _ZN8S80C5_nt4v104Ev();
extern void _ZN8S80C5_nt4v105Ev();
extern void _ZN8S80C5_nt4v106Ev();
extern void _ZN8S80C5_nt4v107Ev();
extern void _ZN8S80C5_nt4v108Ev();
extern void _ZN8S80C5_nt4v109Ev();
extern void _ZN8S80C5_nt4v110Ev();
extern void _ZN8S80C5_nt4v111Ev();
extern void _ZN8S80C5_nt4v112Ev();
extern void _ZN8S80C5_nt4v113Ev();
extern void _ZN8S80C5_nt4v114Ev();
extern void _ZN8S80C5_nt4v115Ev();
extern void _ZN8S80C5_nt4v116Ev();
extern void _ZN8S80C5_nt4v117Ev();
extern void _ZN8S80C5_nt4v118Ev();
extern void _ZN8S80C5_nt4v119Ev();
extern void _ZN8S80C5_nt4v120Ev();
extern void _ZN8S80C5_nt4v121Ev();
extern void _ZN8S80C5_nt4v122Ev();
extern void _ZN8S80C5_nt4v123Ev();
extern void _ZN8S80C5_nt4v124Ev();
extern void _ZN8S80C5_nt4v125Ev();
extern void _ZN8S80C5_nt4v126Ev();
extern void _ZN8S80C5_nt4v127Ev();
extern void _ZN8S80C5_nt4v128Ev();
extern void _ZN8S80C5_nt4v129Ev();
extern void _ZN8S80C5_nt4v130Ev();
extern void _ZN8S80C5_nt4v131Ev();
extern void _ZN8S80C5_nt4v132Ev();
extern void _ZN8S80C5_nt4v133Ev();
extern void _ZN8S80C5_nt4v134Ev();
extern void _ZN8S80C5_nt4v135Ev();
extern void _ZN8S80C5_nt4v136Ev();
extern void _ZN8S80C5_nt4v137Ev();
extern void _ZN8S80C5_nt4v138Ev();
extern void _ZN8S80C5_nt4v139Ev();
extern void _ZN8S80C5_nt4v140Ev();
extern void _ZN8S80C5_nt4v141Ev();
extern void _ZN8S80C5_nt4v142Ev();
extern void _ZN8S80C5_nt4v143Ev();
extern void _ZN8S80C5_nt4v144Ev();
extern void _ZN8S80C5_nt4v145Ev();
extern void _ZN5S80C44v146Ev();
extern void _ZN5S80C44v147Ev();
extern void _ZN5S80C44v148Ev();
extern void _ZN5S80C44v149Ev();
extern void _ZN5S80C44v150Ev();
extern void _ZN5S80C44v151Ev();
extern void _ZN5S80C44v152Ev();
extern void _ZN5S80C44v153Ev();
extern void _ZN5S80C44v154Ev();
extern void _ZN5S80C44v155Ev();
extern void _ZN5S80C44v156Ev();
extern void _ZN5S80C44v157Ev();
extern void _ZN5S80C44v158Ev();
extern void _ZN5S80C44v159Ev();
extern void _ZN5S80C44v160Ev();
extern void _ZN5S80C44v161Ev();
extern void _ZN5S80C44v162Ev();
extern void _ZN5S80C44v163Ev();
extern void _ZN5S80C44v164Ev();
extern void _ZN5S80C44v165Ev();
extern void _ZN5S80C44v166Ev();
extern void _ZN5S80C44v167Ev();
extern void _ZN5S80C44v168Ev();
extern void _ZN5S80C44v169Ev();
extern void _ZN5S80C44v170Ev();
extern void _ZN5S80C44v171Ev();
extern void _ZN5S80C44v172Ev();
extern void _ZN5S80C44v173Ev();
extern void _ZN5S80C44v174Ev();
extern void _ZN5S80C44v175Ev();
extern void _ZN5S80C44v176Ev();
extern void _ZN5S80C44v177Ev();
extern void _ZN5S80C44v178Ev();
extern void _ZN5S80C44v179Ev();
extern void _ZN5S80C44v180Ev();
extern void _ZN5S80C44v181Ev();
extern void _ZN5S80C44v182Ev();
extern void _ZN5S80C44v183Ev();
extern void _ZN5S80C44v184Ev();
extern void _ZN5S80C34v185Ev();
extern void _ZN5S80C34v186Ev();
extern void _ZN5S80C34v187Ev();
extern void _ZN5S80C34v188Ev();
extern void _ZN5S80C34v189Ev();
extern void _ZN5S80C34v190Ev();
extern void _ZN5S80C34v191Ev();
extern void _ZN5S80C34v192Ev();
extern void _ZN5S80C34v193Ev();
extern void _ZN5S80C34v194Ev();
extern void _ZN5S80C34v195Ev();
extern void _ZN5S80C34v196Ev();
extern void _ZN5S80C34v197Ev();
extern void _ZN5S80C34v198Ev();
extern void _ZN5S80C34v199Ev();
extern void _ZN5S80C34v200Ev();
extern void _ZN5S80C34v201Ev();
extern void _ZN5S80C34v202Ev();
extern void _ZN5S80C34v203Ev();
extern void _ZN5S80C34v204Ev();
extern void _ZN5S80C34v205Ev();
extern void _ZN5S80C34v206Ev();
extern void _ZN5S80C34v207Ev();
extern void _ZN5S80C24v208Ev();
extern void _ZN5S80C24v209Ev();
extern void _ZN5S80C24v210Ev();
extern void _ZN5S80C24v211Ev();
extern void _ZN5S80C24v212Ev();
extern void _ZN5S80C24v213Ev();
extern void _ZN5S80C24v214Ev();
extern void _ZN5S80C24v215Ev();
static  VTBL_ENTRY vtc_S80C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S80C2[0]),
  (VTBL_ENTRY)&_ZN5S80C2D1Ev,
  (VTBL_ENTRY)&_ZN5S80C2D0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN5S80C44v146Ev,
  (VTBL_ENTRY)&_ZN5S80C44v147Ev,
  (VTBL_ENTRY)&_ZN5S80C44v148Ev,
  (VTBL_ENTRY)&_ZN5S80C44v149Ev,
  (VTBL_ENTRY)&_ZN5S80C44v150Ev,
  (VTBL_ENTRY)&_ZN5S80C44v151Ev,
  (VTBL_ENTRY)&_ZN5S80C44v152Ev,
  (VTBL_ENTRY)&_ZN5S80C44v153Ev,
  (VTBL_ENTRY)&_ZN5S80C44v154Ev,
  (VTBL_ENTRY)&_ZN5S80C44v155Ev,
  (VTBL_ENTRY)&_ZN5S80C44v156Ev,
  (VTBL_ENTRY)&_ZN5S80C44v157Ev,
  (VTBL_ENTRY)&_ZN5S80C44v158Ev,
  (VTBL_ENTRY)&_ZN5S80C44v159Ev,
  (VTBL_ENTRY)&_ZN5S80C44v160Ev,
  (VTBL_ENTRY)&_ZN5S80C44v161Ev,
  (VTBL_ENTRY)&_ZN5S80C44v162Ev,
  (VTBL_ENTRY)&_ZN5S80C44v163Ev,
  (VTBL_ENTRY)&_ZN5S80C44v164Ev,
  (VTBL_ENTRY)&_ZN5S80C44v165Ev,
  (VTBL_ENTRY)&_ZN5S80C44v166Ev,
  (VTBL_ENTRY)&_ZN5S80C44v167Ev,
  (VTBL_ENTRY)&_ZN5S80C44v168Ev,
  (VTBL_ENTRY)&_ZN5S80C44v169Ev,
  (VTBL_ENTRY)&_ZN5S80C44v170Ev,
  (VTBL_ENTRY)&_ZN5S80C44v171Ev,
  (VTBL_ENTRY)&_ZN5S80C44v172Ev,
  (VTBL_ENTRY)&_ZN5S80C44v173Ev,
  (VTBL_ENTRY)&_ZN5S80C44v174Ev,
  (VTBL_ENTRY)&_ZN5S80C44v175Ev,
  (VTBL_ENTRY)&_ZN5S80C44v176Ev,
  (VTBL_ENTRY)&_ZN5S80C44v177Ev,
  (VTBL_ENTRY)&_ZN5S80C44v178Ev,
  (VTBL_ENTRY)&_ZN5S80C44v179Ev,
  (VTBL_ENTRY)&_ZN5S80C44v180Ev,
  (VTBL_ENTRY)&_ZN5S80C44v181Ev,
  (VTBL_ENTRY)&_ZN5S80C44v182Ev,
  (VTBL_ENTRY)&_ZN5S80C44v183Ev,
  (VTBL_ENTRY)&_ZN5S80C44v184Ev,
  (VTBL_ENTRY)&_ZN5S80C34v185Ev,
  (VTBL_ENTRY)&_ZN5S80C34v186Ev,
  (VTBL_ENTRY)&_ZN5S80C34v187Ev,
  (VTBL_ENTRY)&_ZN5S80C34v188Ev,
  (VTBL_ENTRY)&_ZN5S80C34v189Ev,
  (VTBL_ENTRY)&_ZN5S80C34v190Ev,
  (VTBL_ENTRY)&_ZN5S80C34v191Ev,
  (VTBL_ENTRY)&_ZN5S80C34v192Ev,
  (VTBL_ENTRY)&_ZN5S80C34v193Ev,
  (VTBL_ENTRY)&_ZN5S80C34v194Ev,
  (VTBL_ENTRY)&_ZN5S80C34v195Ev,
  (VTBL_ENTRY)&_ZN5S80C34v196Ev,
  (VTBL_ENTRY)&_ZN5S80C34v197Ev,
  (VTBL_ENTRY)&_ZN5S80C34v198Ev,
  (VTBL_ENTRY)&_ZN5S80C34v199Ev,
  (VTBL_ENTRY)&_ZN5S80C34v200Ev,
  (VTBL_ENTRY)&_ZN5S80C34v201Ev,
  (VTBL_ENTRY)&_ZN5S80C34v202Ev,
  (VTBL_ENTRY)&_ZN5S80C34v203Ev,
  (VTBL_ENTRY)&_ZN5S80C34v204Ev,
  (VTBL_ENTRY)&_ZN5S80C34v205Ev,
  (VTBL_ENTRY)&_ZN5S80C34v206Ev,
  (VTBL_ENTRY)&_ZN5S80C34v207Ev,
  (VTBL_ENTRY)&_ZN5S80C24v208Ev,
  (VTBL_ENTRY)&_ZN5S80C24v209Ev,
  (VTBL_ENTRY)&_ZN5S80C24v210Ev,
  (VTBL_ENTRY)&_ZN5S80C24v211Ev,
  (VTBL_ENTRY)&_ZN5S80C24v212Ev,
  (VTBL_ENTRY)&_ZN5S80C24v213Ev,
  (VTBL_ENTRY)&_ZN5S80C24v214Ev,
  (VTBL_ENTRY)&_ZN5S80C24v215Ev,
};
extern VTBL_ENTRY _ZTI5S80C2[];
extern  VTBL_ENTRY _ZTV5S80C2[];
Class_Descriptor cd_S80C2 = {  "S80C2", // class name
  bases_S80C2, 5,
  &(vtc_S80C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,656), // object size
  NSPAIRA(_ZTI5S80C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S80C2),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C32  : S80C12_nt {
};
//SIG(-1 S80C32) C1{ BC2{ m Fp Fi[2]}}



static void Test_S80C32()
{
  extern Class_Descriptor cd_S80C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C32, buf);
    S80C32 &lv = *(new (buf) S80C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C32)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S80C32");
    test_class_info(&lv, &cd_S80C32);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C32(Test_S80C32, "S80C32", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S80C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C32 = {  "S80C32", // class name
  bases_S80C32, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C31  : S80C32 {
};
//SIG(-1 S80C31) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S80C31()
{
  extern Class_Descriptor cd_S80C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S80C31, buf);
    S80C31 &lv = *(new (buf) S80C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S80C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C31)");
    check_base_class_offset(lv, (S80C12_nt*)(S80C32*), 0, "S80C31");
    check_base_class_offset(lv, (S80C32*), 0, "S80C31");
    test_class_info(&lv, &cd_S80C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C31(Test_S80C31, "S80C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S80C32;
static Base_Class bases_S80C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S80C31 = {  "S80C31", // class name
  bases_S80C31, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C34_nt  {
  ::S80C28_nt s80c34f0;
  ::S80C28_nt s80c34f1;
  ::S80C28_nt s80c34f2;
  ::S80C28_nt s80c34f3;
  ::S80C28_nt s80c34f4;
  ::S80C28_nt s80c34f5;
  ::S80C28_nt s80c34f6;
  ::S80C28_nt s80c34f7;
  unsigned int s80c34f8:1;
  unsigned int s80c34f9:1;
  ::S80C28_nt s80c34f10;
  ::S80C28_nt s80c34f11;
  ::S80C28_nt s80c34f12;
  void  mf80c34(); // _ZN9S80C34_nt7mf80c34Ev
};
//SIG(-1 S80C34_nt) C1{ m FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi:1 Fi:1 FC2 FC2 FC2}


void  S80C34_nt ::mf80c34(){}

//skip512 S80C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C35_nt  {
  int s80c35f0[7];
  ::S80C28_nt s80c35f1;
  void  mf80c35(); // _ZN9S80C35_nt7mf80c35Ev
};
//SIG(-1 S80C35_nt) C1{ m Fi[7] FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}}}


void  S80C35_nt ::mf80c35(){}

//skip512 S80C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C33_nt  {
  ::S80C28_nt s80c33f0;
  ::S80C28_nt s80c33f1;
  ::S80C28_nt s80c33f2;
  ::S80C28_nt s80c33f3;
  ::S80C28_nt s80c33f4;
  ::S80C34_nt s80c33f5;
  ::S80C35_nt s80c33f6;
  ::S80C28_nt s80c33f7;
  unsigned int s80c33f8:1;
  unsigned int s80c33f9:1;
  void  mf80c33(); // _ZN9S80C33_nt7mf80c33Ev
};
//SIG(-1 S80C33_nt) C1{ m FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} FC2 FC2 FC2 FC2 FC6{ m FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi:1 Fi:1 FC2 FC2 FC2} FC7{ m Fi[7] FC2} FC2 Fi:1 Fi:1}


void  S80C33_nt ::mf80c33(){}

//skip512 S80C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C36_nt  {
  int s80c36f0[3];
  void  mf80c36(); // _ZN9S80C36_nt7mf80c36Ev
};
//SIG(-1 S80C36_nt) C1{ m Fi[3]}


void  S80C36_nt ::mf80c36(){}

//skip512 S80C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S80C1  : S80C2 {
  void *s80c1f0[6];
  ::S80C31 s80c1f1;
  void *s80c1f2[2];
  ::S80C28_nt s80c1f3;
  ::S80C28_nt s80c1f4;
  ::S80C33_nt s80c1f5;
  unsigned int s80c1f6:1;
  unsigned int s80c1f7:1;
  unsigned int s80c1f8:1;
  ::S80C34_nt s80c1f9;
  void *s80c1f10;
  int s80c1f11;
  ::S80C36_nt s80c1f12;
  ::S80C36_nt s80c1f13;
  int s80c1f14;
  virtual  ~S80C1(); // _ZN5S80C1D1Ev
  virtual void  v1(); // _ZN5S80C12v1Ev
  virtual void  v2(); // _ZN5S80C12v2Ev
  virtual void  v3(); // _ZN5S80C12v3Ev
  S80C1(); // tgen
};
//SIG(1 S80C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC10 Fp FC13{ BC14{ BC12}} FC13 FC13 FC15{ BC16{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC17{ m Fp FC8} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 FC8 Fp[9] FC15 FC10 FC18{ BC19{ m FC20{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC8 FC8 FC8 Fp FC17 FC17 FC17 FC17 FC17} vd v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC17 FC17 FC17} vd v208 v209 v210 v211 v212 v213 v214 v215 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC21{ BC22{ BC23{ BC12}}}} vd v1 v2 v3 Fp[6] FC24{ BC25{ BC12}} Fp[2] FC21 FC21 FC26{ m FC21 FC21 FC21 FC21 FC21 FC27{ m FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 Fi:1 Fi:1 FC21 FC21 FC21} FC28{ m Fi[7] FC21} FC21 Fi:1 Fi:1} Fi:1 Fi:1 Fi:1 FC27 Fp Fi FC29{ m Fi[3]} FC29 Fi}


 S80C1 ::~S80C1(){ note_dtor("S80C1", this);}
void  S80C1 ::v1(){vfunc_called(this, "_ZN5S80C12v1Ev");}
void  S80C1 ::v2(){vfunc_called(this, "_ZN5S80C12v2Ev");}
void  S80C1 ::v3(){vfunc_called(this, "_ZN5S80C12v3Ev");}
S80C1 ::S80C1(){ note_ctor("S80C1", this);} // tgen

static void Test_S80C1()
{
  extern Class_Descriptor cd_S80C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(202,289)];
    init_test(&cd_S80C1, buf);
    S80C1 *dp, &lv = *(dp=new (buf) S80C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1608,1152), "sizeof(S80C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S80C1)");
    check_base_class_offset(lv, (S80C7_nt*)(S80C6_nt*)(S80C5_nt*)(S80C4*)(S80C3*)(S80C2*), 0, "S80C1");
    check_base_class_offset(lv, (S80C6_nt*)(S80C5_nt*)(S80C4*)(S80C3*)(S80C2*), 0, "S80C1");
    check_base_class_offset(lv, (S80C5_nt*)(S80C4*)(S80C3*)(S80C2*), 0, "S80C1");
    check_base_class_offset(lv, (S80C4*)(S80C3*)(S80C2*), 0, "S80C1");
    check_base_class_offset(lv, (S80C3*)(S80C2*), 0, "S80C1");
    check_base_class_offset(lv, (S80C2*), 0, "S80C1");
    check_field_offset(lv, s80c1f0, ABISELECT(928,656), "S80C1.s80c1f0");
    check_field_offset(lv, s80c1f1, ABISELECT(976,680), "S80C1.s80c1f1");
    check_field_offset(lv, s80c1f2, ABISELECT(992,692), "S80C1.s80c1f2");
    check_field_offset(lv, s80c1f3, ABISELECT(1008,700), "S80C1.s80c1f3");
    check_field_offset(lv, s80c1f4, ABISELECT(1024,712), "S80C1.s80c1f4");
    check_field_offset(lv, s80c1f5, ABISELECT(1040,724), "S80C1.s80c1f5");
    set_bf_and_test(lv, s80c1f6, ABISELECT(1376,976), 0, 1, 1, "S80C1");
    set_bf_and_test(lv, s80c1f7, ABISELECT(1376,976), 1, 1, 1, "S80C1");
    set_bf_and_test(lv, s80c1f8, ABISELECT(1376,976), 2, 1, 1, "S80C1");
    check_field_offset(lv, s80c1f9, ABISELECT(1384,980), "S80C1.s80c1f9");
    check_field_offset(lv, s80c1f10, ABISELECT(1568,1116), "S80C1.s80c1f10");
    check_field_offset(lv, s80c1f11, ABISELECT(1576,1120), "S80C1.s80c1f11");
    check_field_offset(lv, s80c1f12, ABISELECT(1580,1124), "S80C1.s80c1f12");
    check_field_offset(lv, s80c1f13, ABISELECT(1592,1136), "S80C1.s80c1f13");
    check_field_offset(lv, s80c1f14, ABISELECT(1604,1148), "S80C1.s80c1f14");
    test_class_info(&lv, &cd_S80C1);
    dp->~S80C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS80C1(Test_S80C1, "S80C1", ABISELECT(1608,1152));

#else // __cplusplus

extern void _ZN5S80C1C1Ev();
extern void _ZN5S80C1D1Ev();
Name_Map name_map_S80C1[] = {
  NSPAIR(_ZN5S80C1C1Ev),
  NSPAIR(_ZN5S80C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S80C7_nt;
extern VTBL_ENTRY _ZTI8S80C7_nt[];
extern  VTBL_ENTRY _ZTV8S80C7_nt[];
extern Class_Descriptor cd_S80C6_nt;
extern VTBL_ENTRY _ZTI8S80C6_nt[];
extern  VTBL_ENTRY _ZTV8S80C6_nt[];
extern Class_Descriptor cd_S80C5_nt;
extern VTBL_ENTRY _ZTI8S80C5_nt[];
extern  VTBL_ENTRY _ZTV8S80C5_nt[];
extern Class_Descriptor cd_S80C4;
extern VTBL_ENTRY _ZTI5S80C4[];
extern  VTBL_ENTRY _ZTV5S80C4[];
extern Class_Descriptor cd_S80C3;
extern VTBL_ENTRY _ZTI5S80C3[];
extern  VTBL_ENTRY _ZTV5S80C3[];
extern Class_Descriptor cd_S80C2;
extern VTBL_ENTRY _ZTI5S80C2[];
extern  VTBL_ENTRY _ZTV5S80C2[];
static Base_Class bases_S80C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S80C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S80C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S80C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S80C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S80C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S80C1[];
extern void _ZN5S80C1D1Ev();
extern void _ZN5S80C1D0Ev();
extern void _ZN8S80C7_nt2v4Ev();
extern void _ZN8S80C7_nt2v5Ev();
extern void _ZN8S80C7_nt2v6Ev();
extern void _ZN8S80C7_nt2v7Ev();
extern void _ZN8S80C7_nt2v8Ev();
extern void _ZN8S80C7_nt2v9Ev();
extern void _ZN8S80C7_nt3v10Ev();
extern void _ZN8S80C7_nt3v11Ev();
extern void _ZN8S80C7_nt3v12Ev();
extern void _ZN8S80C7_nt3v13Ev();
extern void _ZN8S80C7_nt3v14Ev();
extern void _ZN8S80C7_nt3v15Ev();
extern void _ZN8S80C7_nt3v16Ev();
extern void _ZN8S80C7_nt3v17Ev();
extern void _ZN8S80C7_nt3v18Ev();
extern void _ZN8S80C7_nt3v19Ev();
extern void _ZN8S80C7_nt3v20Ev();
extern void _ZN8S80C7_nt3v21Ev();
extern void _ZN8S80C7_nt3v22Ev();
extern void _ZN8S80C7_nt3v23Ev();
extern void _ZN8S80C7_nt3v24Ev();
extern void _ZN8S80C7_nt3v25Ev();
extern void _ZN8S80C7_nt3v26Ev();
extern void _ZN8S80C7_nt3v27Ev();
extern void _ZN8S80C7_nt3v28Ev();
extern void _ZN8S80C7_nt3v29Ev();
extern void _ZN8S80C7_nt3v30Ev();
extern void _ZN8S80C7_nt3v31Ev();
extern void _ZN8S80C7_nt3v32Ev();
extern void _ZN8S80C7_nt3v33Ev();
extern void _ZN8S80C7_nt3v34Ev();
extern void _ZN8S80C7_nt3v35Ev();
extern void _ZN8S80C7_nt3v36Ev();
extern void _ZN8S80C7_nt3v37Ev();
extern void _ZN8S80C7_nt3v38Ev();
extern void _ZN8S80C7_nt3v39Ev();
extern void _ZN8S80C7_nt3v40Ev();
extern void _ZN8S80C7_nt3v41Ev();
extern void _ZN8S80C7_nt3v42Ev();
extern void _ZN8S80C7_nt3v43Ev();
extern void _ZN8S80C7_nt3v44Ev();
extern void _ZN8S80C7_nt3v45Ev();
extern void _ZN8S80C7_nt3v46Ev();
extern void _ZN8S80C7_nt3v47Ev();
extern void _ZN8S80C7_nt3v48Ev();
extern void _ZN8S80C7_nt3v49Ev();
extern void _ZN8S80C7_nt3v50Ev();
extern void _ZN8S80C7_nt3v51Ev();
extern void _ZN8S80C7_nt3v52Ev();
extern void _ZN8S80C7_nt3v53Ev();
extern void _ZN8S80C7_nt3v54Ev();
extern void _ZN8S80C7_nt3v55Ev();
extern void _ZN8S80C7_nt3v56Ev();
extern void _ZN8S80C7_nt3v57Ev();
extern void _ZN8S80C7_nt3v58Ev();
extern void _ZN8S80C7_nt3v59Ev();
extern void _ZN8S80C7_nt3v60Ev();
extern void _ZN8S80C7_nt3v61Ev();
extern void _ZN8S80C7_nt3v62Ev();
extern void _ZN8S80C7_nt3v63Ev();
extern void _ZN8S80C7_nt3v64Ev();
extern void _ZN8S80C7_nt3v65Ev();
extern void _ZN8S80C7_nt3v66Ev();
extern void _ZN8S80C7_nt3v67Ev();
extern void _ZN8S80C6_nt3v68Ev();
extern void _ZN8S80C6_nt3v69Ev();
extern void _ZN8S80C5_nt3v70Ev();
extern void _ZN8S80C5_nt3v71Ev();
extern void _ZN8S80C5_nt3v72Ev();
extern void _ZN8S80C5_nt3v73Ev();
extern void _ZN8S80C5_nt3v74Ev();
extern void _ZN8S80C5_nt3v75Ev();
extern void _ZN8S80C5_nt3v76Ev();
extern void _ZN8S80C5_nt3v77Ev();
extern void _ZN8S80C5_nt3v78Ev();
extern void _ZN8S80C5_nt3v79Ev();
extern void _ZN8S80C5_nt3v80Ev();
extern void _ZN8S80C5_nt3v81Ev();
extern void _ZN8S80C5_nt3v82Ev();
extern void _ZN8S80C5_nt3v83Ev();
extern void _ZN8S80C5_nt3v84Ev();
extern void _ZN8S80C5_nt3v85Ev();
extern void _ZN8S80C5_nt3v86Ev();
extern void _ZN8S80C5_nt3v87Ev();
extern void _ZN8S80C5_nt3v88Ev();
extern void _ZN8S80C5_nt3v89Ev();
extern void _ZN8S80C5_nt3v90Ev();
extern void _ZN8S80C5_nt3v91Ev();
extern void _ZN8S80C5_nt3v92Ev();
extern void _ZN8S80C5_nt3v93Ev();
extern void _ZN8S80C5_nt3v94Ev();
extern void _ZN8S80C5_nt3v95Ev();
extern void _ZN8S80C5_nt3v96Ev();
extern void _ZN8S80C5_nt3v97Ev();
extern void _ZN8S80C5_nt3v98Ev();
extern void _ZN8S80C5_nt3v99Ev();
extern void _ZN8S80C5_nt4v100Ev();
extern void _ZN8S80C5_nt4v101Ev();
extern void _ZN8S80C5_nt4v102Ev();
extern void _ZN8S80C5_nt4v103Ev();
extern void _ZN8S80C5_nt4v104Ev();
extern void _ZN8S80C5_nt4v105Ev();
extern void _ZN8S80C5_nt4v106Ev();
extern void _ZN8S80C5_nt4v107Ev();
extern void _ZN8S80C5_nt4v108Ev();
extern void _ZN8S80C5_nt4v109Ev();
extern void _ZN8S80C5_nt4v110Ev();
extern void _ZN8S80C5_nt4v111Ev();
extern void _ZN8S80C5_nt4v112Ev();
extern void _ZN8S80C5_nt4v113Ev();
extern void _ZN8S80C5_nt4v114Ev();
extern void _ZN8S80C5_nt4v115Ev();
extern void _ZN8S80C5_nt4v116Ev();
extern void _ZN8S80C5_nt4v117Ev();
extern void _ZN8S80C5_nt4v118Ev();
extern void _ZN8S80C5_nt4v119Ev();
extern void _ZN8S80C5_nt4v120Ev();
extern void _ZN8S80C5_nt4v121Ev();
extern void _ZN8S80C5_nt4v122Ev();
extern void _ZN8S80C5_nt4v123Ev();
extern void _ZN8S80C5_nt4v124Ev();
extern void _ZN8S80C5_nt4v125Ev();
extern void _ZN8S80C5_nt4v126Ev();
extern void _ZN8S80C5_nt4v127Ev();
extern void _ZN8S80C5_nt4v128Ev();
extern void _ZN8S80C5_nt4v129Ev();
extern void _ZN8S80C5_nt4v130Ev();
extern void _ZN8S80C5_nt4v131Ev();
extern void _ZN8S80C5_nt4v132Ev();
extern void _ZN8S80C5_nt4v133Ev();
extern void _ZN8S80C5_nt4v134Ev();
extern void _ZN8S80C5_nt4v135Ev();
extern void _ZN8S80C5_nt4v136Ev();
extern void _ZN8S80C5_nt4v137Ev();
extern void _ZN8S80C5_nt4v138Ev();
extern void _ZN8S80C5_nt4v139Ev();
extern void _ZN8S80C5_nt4v140Ev();
extern void _ZN8S80C5_nt4v141Ev();
extern void _ZN8S80C5_nt4v142Ev();
extern void _ZN8S80C5_nt4v143Ev();
extern void _ZN8S80C5_nt4v144Ev();
extern void _ZN8S80C5_nt4v145Ev();
extern void _ZN5S80C44v146Ev();
extern void _ZN5S80C44v147Ev();
extern void _ZN5S80C44v148Ev();
extern void _ZN5S80C44v149Ev();
extern void _ZN5S80C44v150Ev();
extern void _ZN5S80C44v151Ev();
extern void _ZN5S80C44v152Ev();
extern void _ZN5S80C44v153Ev();
extern void _ZN5S80C44v154Ev();
extern void _ZN5S80C44v155Ev();
extern void _ZN5S80C44v156Ev();
extern void _ZN5S80C44v157Ev();
extern void _ZN5S80C44v158Ev();
extern void _ZN5S80C44v159Ev();
extern void _ZN5S80C44v160Ev();
extern void _ZN5S80C44v161Ev();
extern void _ZN5S80C44v162Ev();
extern void _ZN5S80C44v163Ev();
extern void _ZN5S80C44v164Ev();
extern void _ZN5S80C44v165Ev();
extern void _ZN5S80C44v166Ev();
extern void _ZN5S80C44v167Ev();
extern void _ZN5S80C44v168Ev();
extern void _ZN5S80C44v169Ev();
extern void _ZN5S80C44v170Ev();
extern void _ZN5S80C44v171Ev();
extern void _ZN5S80C44v172Ev();
extern void _ZN5S80C44v173Ev();
extern void _ZN5S80C44v174Ev();
extern void _ZN5S80C44v175Ev();
extern void _ZN5S80C44v176Ev();
extern void _ZN5S80C44v177Ev();
extern void _ZN5S80C44v178Ev();
extern void _ZN5S80C44v179Ev();
extern void _ZN5S80C44v180Ev();
extern void _ZN5S80C44v181Ev();
extern void _ZN5S80C44v182Ev();
extern void _ZN5S80C44v183Ev();
extern void _ZN5S80C44v184Ev();
extern void _ZN5S80C34v185Ev();
extern void _ZN5S80C34v186Ev();
extern void _ZN5S80C34v187Ev();
extern void _ZN5S80C34v188Ev();
extern void _ZN5S80C34v189Ev();
extern void _ZN5S80C34v190Ev();
extern void _ZN5S80C34v191Ev();
extern void _ZN5S80C34v192Ev();
extern void _ZN5S80C34v193Ev();
extern void _ZN5S80C34v194Ev();
extern void _ZN5S80C34v195Ev();
extern void _ZN5S80C34v196Ev();
extern void _ZN5S80C34v197Ev();
extern void _ZN5S80C34v198Ev();
extern void _ZN5S80C34v199Ev();
extern void _ZN5S80C34v200Ev();
extern void _ZN5S80C34v201Ev();
extern void _ZN5S80C34v202Ev();
extern void _ZN5S80C34v203Ev();
extern void _ZN5S80C34v204Ev();
extern void _ZN5S80C34v205Ev();
extern void _ZN5S80C34v206Ev();
extern void _ZN5S80C34v207Ev();
extern void _ZN5S80C24v208Ev();
extern void _ZN5S80C24v209Ev();
extern void _ZN5S80C24v210Ev();
extern void _ZN5S80C24v211Ev();
extern void _ZN5S80C24v212Ev();
extern void _ZN5S80C24v213Ev();
extern void _ZN5S80C24v214Ev();
extern void _ZN5S80C24v215Ev();
extern void _ZN5S80C12v1Ev();
extern void _ZN5S80C12v2Ev();
extern void _ZN5S80C12v3Ev();
static  VTBL_ENTRY vtc_S80C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S80C1[0]),
  (VTBL_ENTRY)&_ZN5S80C1D1Ev,
  (VTBL_ENTRY)&_ZN5S80C1D0Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S80C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S80C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S80C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN5S80C44v146Ev,
  (VTBL_ENTRY)&_ZN5S80C44v147Ev,
  (VTBL_ENTRY)&_ZN5S80C44v148Ev,
  (VTBL_ENTRY)&_ZN5S80C44v149Ev,
  (VTBL_ENTRY)&_ZN5S80C44v150Ev,
  (VTBL_ENTRY)&_ZN5S80C44v151Ev,
  (VTBL_ENTRY)&_ZN5S80C44v152Ev,
  (VTBL_ENTRY)&_ZN5S80C44v153Ev,
  (VTBL_ENTRY)&_ZN5S80C44v154Ev,
  (VTBL_ENTRY)&_ZN5S80C44v155Ev,
  (VTBL_ENTRY)&_ZN5S80C44v156Ev,
  (VTBL_ENTRY)&_ZN5S80C44v157Ev,
  (VTBL_ENTRY)&_ZN5S80C44v158Ev,
  (VTBL_ENTRY)&_ZN5S80C44v159Ev,
  (VTBL_ENTRY)&_ZN5S80C44v160Ev,
  (VTBL_ENTRY)&_ZN5S80C44v161Ev,
  (VTBL_ENTRY)&_ZN5S80C44v162Ev,
  (VTBL_ENTRY)&_ZN5S80C44v163Ev,
  (VTBL_ENTRY)&_ZN5S80C44v164Ev,
  (VTBL_ENTRY)&_ZN5S80C44v165Ev,
  (VTBL_ENTRY)&_ZN5S80C44v166Ev,
  (VTBL_ENTRY)&_ZN5S80C44v167Ev,
  (VTBL_ENTRY)&_ZN5S80C44v168Ev,
  (VTBL_ENTRY)&_ZN5S80C44v169Ev,
  (VTBL_ENTRY)&_ZN5S80C44v170Ev,
  (VTBL_ENTRY)&_ZN5S80C44v171Ev,
  (VTBL_ENTRY)&_ZN5S80C44v172Ev,
  (VTBL_ENTRY)&_ZN5S80C44v173Ev,
  (VTBL_ENTRY)&_ZN5S80C44v174Ev,
  (VTBL_ENTRY)&_ZN5S80C44v175Ev,
  (VTBL_ENTRY)&_ZN5S80C44v176Ev,
  (VTBL_ENTRY)&_ZN5S80C44v177Ev,
  (VTBL_ENTRY)&_ZN5S80C44v178Ev,
  (VTBL_ENTRY)&_ZN5S80C44v179Ev,
  (VTBL_ENTRY)&_ZN5S80C44v180Ev,
  (VTBL_ENTRY)&_ZN5S80C44v181Ev,
  (VTBL_ENTRY)&_ZN5S80C44v182Ev,
  (VTBL_ENTRY)&_ZN5S80C44v183Ev,
  (VTBL_ENTRY)&_ZN5S80C44v184Ev,
  (VTBL_ENTRY)&_ZN5S80C34v185Ev,
  (VTBL_ENTRY)&_ZN5S80C34v186Ev,
  (VTBL_ENTRY)&_ZN5S80C34v187Ev,
  (VTBL_ENTRY)&_ZN5S80C34v188Ev,
  (VTBL_ENTRY)&_ZN5S80C34v189Ev,
  (VTBL_ENTRY)&_ZN5S80C34v190Ev,
  (VTBL_ENTRY)&_ZN5S80C34v191Ev,
  (VTBL_ENTRY)&_ZN5S80C34v192Ev,
  (VTBL_ENTRY)&_ZN5S80C34v193Ev,
  (VTBL_ENTRY)&_ZN5S80C34v194Ev,
  (VTBL_ENTRY)&_ZN5S80C34v195Ev,
  (VTBL_ENTRY)&_ZN5S80C34v196Ev,
  (VTBL_ENTRY)&_ZN5S80C34v197Ev,
  (VTBL_ENTRY)&_ZN5S80C34v198Ev,
  (VTBL_ENTRY)&_ZN5S80C34v199Ev,
  (VTBL_ENTRY)&_ZN5S80C34v200Ev,
  (VTBL_ENTRY)&_ZN5S80C34v201Ev,
  (VTBL_ENTRY)&_ZN5S80C34v202Ev,
  (VTBL_ENTRY)&_ZN5S80C34v203Ev,
  (VTBL_ENTRY)&_ZN5S80C34v204Ev,
  (VTBL_ENTRY)&_ZN5S80C34v205Ev,
  (VTBL_ENTRY)&_ZN5S80C34v206Ev,
  (VTBL_ENTRY)&_ZN5S80C34v207Ev,
  (VTBL_ENTRY)&_ZN5S80C24v208Ev,
  (VTBL_ENTRY)&_ZN5S80C24v209Ev,
  (VTBL_ENTRY)&_ZN5S80C24v210Ev,
  (VTBL_ENTRY)&_ZN5S80C24v211Ev,
  (VTBL_ENTRY)&_ZN5S80C24v212Ev,
  (VTBL_ENTRY)&_ZN5S80C24v213Ev,
  (VTBL_ENTRY)&_ZN5S80C24v214Ev,
  (VTBL_ENTRY)&_ZN5S80C24v215Ev,
  (VTBL_ENTRY)&_ZN5S80C12v1Ev,
  (VTBL_ENTRY)&_ZN5S80C12v2Ev,
  (VTBL_ENTRY)&_ZN5S80C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S80C1[];
extern  VTBL_ENTRY _ZTV5S80C1[];
Class_Descriptor cd_S80C1 = {  "S80C1", // class name
  bases_S80C1, 6,
  &(vtc_S80C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1608,1152), // object size
  NSPAIRA(_ZTI5S80C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S80C1),219, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C7  {
  int s85c7f0;
  __tsi64 s85c7f1;
  void *s85c7f2[4];
  int s85c7f3[2];
  void *s85c7f4;
  ::S80C8_nt s85c7f5;
  void *s85c7f6[2];
  virtual  ~S85C7(); // _ZN5S85C7D1Ev
  virtual void  v4(); // _ZN5S85C72v4Ev
  virtual void  v5(); // _ZN5S85C72v5Ev
  virtual void  v6(); // _ZN5S85C72v6Ev
  virtual void  v7(); // _ZN5S85C72v7Ev
  virtual void  v8(); // _ZN5S85C72v8Ev
  virtual void  v9(); // _ZN5S85C72v9Ev
  virtual void  v10(); // _ZN5S85C73v10Ev
  virtual void  v11(); // _ZN5S85C73v11Ev
  virtual void  v12(); // _ZN5S85C73v12Ev
  virtual void  v13(); // _ZN5S85C73v13Ev
  virtual void  v14(); // _ZN5S85C73v14Ev
  virtual void  v15(); // _ZN5S85C73v15Ev
  virtual void  v16(); // _ZN5S85C73v16Ev
  virtual void  v17(); // _ZN5S85C73v17Ev
  virtual void  v18(); // _ZN5S85C73v18Ev
  virtual void  v19(); // _ZN5S85C73v19Ev
  virtual void  v20(); // _ZN5S85C73v20Ev
  virtual void  v21(); // _ZN5S85C73v21Ev
  virtual void  v22(); // _ZN5S85C73v22Ev
  virtual void  v23(); // _ZN5S85C73v23Ev
  virtual void  v24(); // _ZN5S85C73v24Ev
  virtual void  v25(); // _ZN5S85C73v25Ev
  virtual void  v26(); // _ZN5S85C73v26Ev
  virtual void  v27(); // _ZN5S85C73v27Ev
  virtual void  v28(); // _ZN5S85C73v28Ev
  virtual void  v29(); // _ZN5S85C73v29Ev
  virtual void  v30(); // _ZN5S85C73v30Ev
  virtual void  v31(); // _ZN5S85C73v31Ev
  virtual void  v32(); // _ZN5S85C73v32Ev
  virtual void  v33(); // _ZN5S85C73v33Ev
  virtual void  v34(); // _ZN5S85C73v34Ev
  virtual void  v35(); // _ZN5S85C73v35Ev
  virtual void  v36(); // _ZN5S85C73v36Ev
  virtual void  v37(); // _ZN5S85C73v37Ev
  virtual void  v38(); // _ZN5S85C73v38Ev
  virtual void  v39(); // _ZN5S85C73v39Ev
  virtual void  v40(); // _ZN5S85C73v40Ev
  virtual void  v41(); // _ZN5S85C73v41Ev
  virtual void  v42(); // _ZN5S85C73v42Ev
  virtual void  v43(); // _ZN5S85C73v43Ev
  virtual void  v44(); // _ZN5S85C73v44Ev
  virtual void  v45(); // _ZN5S85C73v45Ev
  virtual void  v46(); // _ZN5S85C73v46Ev
  virtual void  v47(); // _ZN5S85C73v47Ev
  virtual void  v48(); // _ZN5S85C73v48Ev
  virtual void  v49(); // _ZN5S85C73v49Ev
  virtual void  v50(); // _ZN5S85C73v50Ev
  virtual void  v51(); // _ZN5S85C73v51Ev
  virtual void  v52(); // _ZN5S85C73v52Ev
  virtual void  v53(); // _ZN5S85C73v53Ev
  virtual void  v54(); // _ZN5S85C73v54Ev
  virtual void  v55(); // _ZN5S85C73v55Ev
  virtual void  v56(); // _ZN5S85C73v56Ev
  virtual void  v57(); // _ZN5S85C73v57Ev
  virtual void  v58(); // _ZN5S85C73v58Ev
  virtual void  v59(); // _ZN5S85C73v59Ev
  virtual void  v60(); // _ZN5S85C73v60Ev
  virtual void  v61(); // _ZN5S85C73v61Ev
  virtual void  v62(); // _ZN5S85C73v62Ev
  virtual void  v63(); // _ZN5S85C73v63Ev
  virtual void  v64(); // _ZN5S85C73v64Ev
  virtual void  v65(); // _ZN5S85C73v65Ev
  virtual void  v66(); // _ZN5S85C73v66Ev
  virtual void  v67(); // _ZN5S85C73v67Ev
  S85C7(); // tgen
};
//SIG(-1 S85C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S85C7 ::~S85C7(){ note_dtor("S85C7", this);}
void  S85C7 ::v4(){vfunc_called(this, "_ZN5S85C72v4Ev");}
void  S85C7 ::v5(){vfunc_called(this, "_ZN5S85C72v5Ev");}
void  S85C7 ::v6(){vfunc_called(this, "_ZN5S85C72v6Ev");}
void  S85C7 ::v7(){vfunc_called(this, "_ZN5S85C72v7Ev");}
void  S85C7 ::v8(){vfunc_called(this, "_ZN5S85C72v8Ev");}
void  S85C7 ::v9(){vfunc_called(this, "_ZN5S85C72v9Ev");}
void  S85C7 ::v10(){vfunc_called(this, "_ZN5S85C73v10Ev");}
void  S85C7 ::v11(){vfunc_called(this, "_ZN5S85C73v11Ev");}
void  S85C7 ::v12(){vfunc_called(this, "_ZN5S85C73v12Ev");}
void  S85C7 ::v13(){vfunc_called(this, "_ZN5S85C73v13Ev");}
void  S85C7 ::v14(){vfunc_called(this, "_ZN5S85C73v14Ev");}
void  S85C7 ::v15(){vfunc_called(this, "_ZN5S85C73v15Ev");}
void  S85C7 ::v16(){vfunc_called(this, "_ZN5S85C73v16Ev");}
void  S85C7 ::v17(){vfunc_called(this, "_ZN5S85C73v17Ev");}
void  S85C7 ::v18(){vfunc_called(this, "_ZN5S85C73v18Ev");}
void  S85C7 ::v19(){vfunc_called(this, "_ZN5S85C73v19Ev");}
void  S85C7 ::v20(){vfunc_called(this, "_ZN5S85C73v20Ev");}
void  S85C7 ::v21(){vfunc_called(this, "_ZN5S85C73v21Ev");}
void  S85C7 ::v22(){vfunc_called(this, "_ZN5S85C73v22Ev");}
void  S85C7 ::v23(){vfunc_called(this, "_ZN5S85C73v23Ev");}
void  S85C7 ::v24(){vfunc_called(this, "_ZN5S85C73v24Ev");}
void  S85C7 ::v25(){vfunc_called(this, "_ZN5S85C73v25Ev");}
void  S85C7 ::v26(){vfunc_called(this, "_ZN5S85C73v26Ev");}
void  S85C7 ::v27(){vfunc_called(this, "_ZN5S85C73v27Ev");}
void  S85C7 ::v28(){vfunc_called(this, "_ZN5S85C73v28Ev");}
void  S85C7 ::v29(){vfunc_called(this, "_ZN5S85C73v29Ev");}
void  S85C7 ::v30(){vfunc_called(this, "_ZN5S85C73v30Ev");}
void  S85C7 ::v31(){vfunc_called(this, "_ZN5S85C73v31Ev");}
void  S85C7 ::v32(){vfunc_called(this, "_ZN5S85C73v32Ev");}
void  S85C7 ::v33(){vfunc_called(this, "_ZN5S85C73v33Ev");}
void  S85C7 ::v34(){vfunc_called(this, "_ZN5S85C73v34Ev");}
void  S85C7 ::v35(){vfunc_called(this, "_ZN5S85C73v35Ev");}
void  S85C7 ::v36(){vfunc_called(this, "_ZN5S85C73v36Ev");}
void  S85C7 ::v37(){vfunc_called(this, "_ZN5S85C73v37Ev");}
void  S85C7 ::v38(){vfunc_called(this, "_ZN5S85C73v38Ev");}
void  S85C7 ::v39(){vfunc_called(this, "_ZN5S85C73v39Ev");}
void  S85C7 ::v40(){vfunc_called(this, "_ZN5S85C73v40Ev");}
void  S85C7 ::v41(){vfunc_called(this, "_ZN5S85C73v41Ev");}
void  S85C7 ::v42(){vfunc_called(this, "_ZN5S85C73v42Ev");}
void  S85C7 ::v43(){vfunc_called(this, "_ZN5S85C73v43Ev");}
void  S85C7 ::v44(){vfunc_called(this, "_ZN5S85C73v44Ev");}
void  S85C7 ::v45(){vfunc_called(this, "_ZN5S85C73v45Ev");}
void  S85C7 ::v46(){vfunc_called(this, "_ZN5S85C73v46Ev");}
void  S85C7 ::v47(){vfunc_called(this, "_ZN5S85C73v47Ev");}
void  S85C7 ::v48(){vfunc_called(this, "_ZN5S85C73v48Ev");}
void  S85C7 ::v49(){vfunc_called(this, "_ZN5S85C73v49Ev");}
void  S85C7 ::v50(){vfunc_called(this, "_ZN5S85C73v50Ev");}
void  S85C7 ::v51(){vfunc_called(this, "_ZN5S85C73v51Ev");}
void  S85C7 ::v52(){vfunc_called(this, "_ZN5S85C73v52Ev");}
void  S85C7 ::v53(){vfunc_called(this, "_ZN5S85C73v53Ev");}
void  S85C7 ::v54(){vfunc_called(this, "_ZN5S85C73v54Ev");}
void  S85C7 ::v55(){vfunc_called(this, "_ZN5S85C73v55Ev");}
void  S85C7 ::v56(){vfunc_called(this, "_ZN5S85C73v56Ev");}
void  S85C7 ::v57(){vfunc_called(this, "_ZN5S85C73v57Ev");}
void  S85C7 ::v58(){vfunc_called(this, "_ZN5S85C73v58Ev");}
void  S85C7 ::v59(){vfunc_called(this, "_ZN5S85C73v59Ev");}
void  S85C7 ::v60(){vfunc_called(this, "_ZN5S85C73v60Ev");}
void  S85C7 ::v61(){vfunc_called(this, "_ZN5S85C73v61Ev");}
void  S85C7 ::v62(){vfunc_called(this, "_ZN5S85C73v62Ev");}
void  S85C7 ::v63(){vfunc_called(this, "_ZN5S85C73v63Ev");}
void  S85C7 ::v64(){vfunc_called(this, "_ZN5S85C73v64Ev");}
void  S85C7 ::v65(){vfunc_called(this, "_ZN5S85C73v65Ev");}
void  S85C7 ::v66(){vfunc_called(this, "_ZN5S85C73v66Ev");}
void  S85C7 ::v67(){vfunc_called(this, "_ZN5S85C73v67Ev");}
S85C7 ::S85C7(){ note_ctor("S85C7", this);} // tgen

static void Test_S85C7()
{
  extern Class_Descriptor cd_S85C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S85C7, buf);
    S85C7 *dp, &lv = *(dp=new (buf) S85C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S85C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C7)");
    check_field_offset(lv, s85c7f0, ABISELECT(8,4), "S85C7.s85c7f0");
    check_field_offset(lv, s85c7f1, ABISELECT(16,8), "S85C7.s85c7f1");
    check_field_offset(lv, s85c7f2, ABISELECT(24,16), "S85C7.s85c7f2");
    check_field_offset(lv, s85c7f3, ABISELECT(56,32), "S85C7.s85c7f3");
    check_field_offset(lv, s85c7f4, ABISELECT(64,40), "S85C7.s85c7f4");
    check_field_offset(lv, s85c7f5, ABISELECT(72,44), "S85C7.s85c7f5");
    check_field_offset(lv, s85c7f6, ABISELECT(80,52), "S85C7.s85c7f6");
    test_class_info(&lv, &cd_S85C7);
    dp->~S85C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C7(Test_S85C7, "S85C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S85C7C1Ev();
extern void _ZN5S85C7D1Ev();
Name_Map name_map_S85C7[] = {
  NSPAIR(_ZN5S85C7C1Ev),
  NSPAIR(_ZN5S85C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S85C7[];
extern void _ZN5S85C7D1Ev();
extern void _ZN5S85C7D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
static  VTBL_ENTRY vtc_S85C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C7[0]),
  (VTBL_ENTRY)&_ZN5S85C7D1Ev,
  (VTBL_ENTRY)&_ZN5S85C7D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
Class_Descriptor cd_S85C7 = {  "S85C7", // class name
  0,0,//no base classes
  &(vtc_S85C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S85C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S85C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C6  : S85C7 {
  virtual  ~S85C6(); // _ZN5S85C6D1Ev
  virtual void  v68(); // _ZN5S85C63v68Ev
  virtual void  v69(); // _ZN5S85C63v69Ev
  S85C6(); // tgen
};
//SIG(-1 S85C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S85C6 ::~S85C6(){ note_dtor("S85C6", this);}
void  S85C6 ::v68(){vfunc_called(this, "_ZN5S85C63v68Ev");}
void  S85C6 ::v69(){vfunc_called(this, "_ZN5S85C63v69Ev");}
S85C6 ::S85C6(){ note_ctor("S85C6", this);} // tgen

static void Test_S85C6()
{
  extern Class_Descriptor cd_S85C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S85C6, buf);
    S85C6 *dp, &lv = *(dp=new (buf) S85C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S85C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C6)");
    check_base_class_offset(lv, (S85C7*), 0, "S85C6");
    test_class_info(&lv, &cd_S85C6);
    dp->~S85C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C6(Test_S85C6, "S85C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S85C6C1Ev();
extern void _ZN5S85C6D1Ev();
Name_Map name_map_S85C6[] = {
  NSPAIR(_ZN5S85C6C1Ev),
  NSPAIR(_ZN5S85C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
static Base_Class bases_S85C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C6[];
extern void _ZN5S85C6D1Ev();
extern void _ZN5S85C6D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
static  VTBL_ENTRY vtc_S85C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C6[0]),
  (VTBL_ENTRY)&_ZN5S85C6D1Ev,
  (VTBL_ENTRY)&_ZN5S85C6D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
};
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
Class_Descriptor cd_S85C6 = {  "S85C6", // class name
  bases_S85C6, 1,
  &(vtc_S85C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S85C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C5  : S85C6 {
  ::S80C9_nt s85c5f0;
  int s85c5f1;
  unsigned int s85c5f2:1;
  unsigned int s85c5f3:1;
  unsigned int s85c5f4:1;
  unsigned int s85c5f5:1;
  ::S80C31 s85c5f6;
  ::S80C29 s85c5f7;
  void *s85c5f8;
  ::S80C19 s85c5f9;
  ::S80C19 s85c5f10;
  ::S80C15 s85c5f11;
  ::S80C10_nt s85c5f12;
  char s85c5f13;
  int s85c5f14;
  void *s85c5f15;
  ::S80C8_nt s85c5f16;
  ::S80C8_nt s85c5f17;
  ::S80C8_nt s85c5f18;
  ::S80C8_nt s85c5f19;
  ::S80C8_nt s85c5f20;
  ::S80C8_nt s85c5f21;
  ::S80C21_nt s85c5f22;
  ::S80C21_nt s85c5f23;
  ::S80C21_nt s85c5f24;
  ::S80C21_nt s85c5f25;
  ::S80C21_nt s85c5f26;
  ::S80C21_nt s85c5f27;
  ::S80C21_nt s85c5f28;
  ::S80C21_nt s85c5f29;
  ::S80C21_nt s85c5f30;
  ::S80C21_nt s85c5f31;
  virtual  ~S85C5(); // _ZN5S85C5D1Ev
  virtual void  v70(); // _ZN5S85C53v70Ev
  virtual void  v71(); // _ZN5S85C53v71Ev
  virtual void  v72(); // _ZN5S85C53v72Ev
  virtual void  v73(); // _ZN5S85C53v73Ev
  virtual void  v74(); // _ZN5S85C53v74Ev
  virtual void  v75(); // _ZN5S85C53v75Ev
  virtual void  v76(); // _ZN5S85C53v76Ev
  virtual void  v77(); // _ZN5S85C53v77Ev
  virtual void  v78(); // _ZN5S85C53v78Ev
  virtual void  v79(); // _ZN5S85C53v79Ev
  virtual void  v80(); // _ZN5S85C53v80Ev
  virtual void  v81(); // _ZN5S85C53v81Ev
  virtual void  v82(); // _ZN5S85C53v82Ev
  virtual void  v83(); // _ZN5S85C53v83Ev
  virtual void  v84(); // _ZN5S85C53v84Ev
  virtual void  v85(); // _ZN5S85C53v85Ev
  virtual void  v86(); // _ZN5S85C53v86Ev
  virtual void  v87(); // _ZN5S85C53v87Ev
  virtual void  v88(); // _ZN5S85C53v88Ev
  virtual void  v89(); // _ZN5S85C53v89Ev
  virtual void  v90(); // _ZN5S85C53v90Ev
  virtual void  v91(); // _ZN5S85C53v91Ev
  virtual void  v92(); // _ZN5S85C53v92Ev
  virtual void  v93(); // _ZN5S85C53v93Ev
  virtual void  v94(); // _ZN5S85C53v94Ev
  virtual void  v95(); // _ZN5S85C53v95Ev
  virtual void  v96(); // _ZN5S85C53v96Ev
  virtual void  v97(); // _ZN5S85C53v97Ev
  virtual void  v98(); // _ZN5S85C53v98Ev
  virtual void  v99(); // _ZN5S85C53v99Ev
  virtual void  v100(); // _ZN5S85C54v100Ev
  virtual void  v101(); // _ZN5S85C54v101Ev
  virtual void  v102(); // _ZN5S85C54v102Ev
  virtual void  v103(); // _ZN5S85C54v103Ev
  virtual void  v104(); // _ZN5S85C54v104Ev
  virtual void  v105(); // _ZN5S85C54v105Ev
  virtual void  v106(); // _ZN5S85C54v106Ev
  virtual void  v107(); // _ZN5S85C54v107Ev
  virtual void  v108(); // _ZN5S85C54v108Ev
  virtual void  v109(); // _ZN5S85C54v109Ev
  virtual void  v110(); // _ZN5S85C54v110Ev
  virtual void  v111(); // _ZN5S85C54v111Ev
  virtual void  v112(); // _ZN5S85C54v112Ev
  virtual void  v113(); // _ZN5S85C54v113Ev
  virtual void  v114(); // _ZN5S85C54v114Ev
  virtual void  v115(); // _ZN5S85C54v115Ev
  virtual void  v116(); // _ZN5S85C54v116Ev
  virtual void  v117(); // _ZN5S85C54v117Ev
  virtual void  v118(); // _ZN5S85C54v118Ev
  virtual void  v119(); // _ZN5S85C54v119Ev
  virtual void  v120(); // _ZN5S85C54v120Ev
  virtual void  v121(); // _ZN5S85C54v121Ev
  virtual void  v122(); // _ZN5S85C54v122Ev
  virtual void  v123(); // _ZN5S85C54v123Ev
  virtual void  v124(); // _ZN5S85C54v124Ev
  virtual void  v125(); // _ZN5S85C54v125Ev
  virtual void  v126(); // _ZN5S85C54v126Ev
  virtual void  v127(); // _ZN5S85C54v127Ev
  virtual void  v128(); // _ZN5S85C54v128Ev
  virtual void  v129(); // _ZN5S85C54v129Ev
  virtual void  v130(); // _ZN5S85C54v130Ev
  virtual void  v131(); // _ZN5S85C54v131Ev
  virtual void  v132(); // _ZN5S85C54v132Ev
  virtual void  v133(); // _ZN5S85C54v133Ev
  virtual void  v134(); // _ZN5S85C54v134Ev
  virtual void  v135(); // _ZN5S85C54v135Ev
  virtual void  v136(); // _ZN5S85C54v136Ev
  virtual void  v137(); // _ZN5S85C54v137Ev
  virtual void  v138(); // _ZN5S85C54v138Ev
  virtual void  v139(); // _ZN5S85C54v139Ev
  virtual void  v140(); // _ZN5S85C54v140Ev
  virtual void  v141(); // _ZN5S85C54v141Ev
  virtual void  v142(); // _ZN5S85C54v142Ev
  virtual void  v143(); // _ZN5S85C54v143Ev
  virtual void  v144(); // _ZN5S85C54v144Ev
  virtual void  v145(); // _ZN5S85C54v145Ev
  S85C5(); // tgen
};
//SIG(-1 S85C5) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC4} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S85C5 ::~S85C5(){ note_dtor("S85C5", this);}
void  S85C5 ::v70(){vfunc_called(this, "_ZN5S85C53v70Ev");}
void  S85C5 ::v71(){vfunc_called(this, "_ZN5S85C53v71Ev");}
void  S85C5 ::v72(){vfunc_called(this, "_ZN5S85C53v72Ev");}
void  S85C5 ::v73(){vfunc_called(this, "_ZN5S85C53v73Ev");}
void  S85C5 ::v74(){vfunc_called(this, "_ZN5S85C53v74Ev");}
void  S85C5 ::v75(){vfunc_called(this, "_ZN5S85C53v75Ev");}
void  S85C5 ::v76(){vfunc_called(this, "_ZN5S85C53v76Ev");}
void  S85C5 ::v77(){vfunc_called(this, "_ZN5S85C53v77Ev");}
void  S85C5 ::v78(){vfunc_called(this, "_ZN5S85C53v78Ev");}
void  S85C5 ::v79(){vfunc_called(this, "_ZN5S85C53v79Ev");}
void  S85C5 ::v80(){vfunc_called(this, "_ZN5S85C53v80Ev");}
void  S85C5 ::v81(){vfunc_called(this, "_ZN5S85C53v81Ev");}
void  S85C5 ::v82(){vfunc_called(this, "_ZN5S85C53v82Ev");}
void  S85C5 ::v83(){vfunc_called(this, "_ZN5S85C53v83Ev");}
void  S85C5 ::v84(){vfunc_called(this, "_ZN5S85C53v84Ev");}
void  S85C5 ::v85(){vfunc_called(this, "_ZN5S85C53v85Ev");}
void  S85C5 ::v86(){vfunc_called(this, "_ZN5S85C53v86Ev");}
void  S85C5 ::v87(){vfunc_called(this, "_ZN5S85C53v87Ev");}
void  S85C5 ::v88(){vfunc_called(this, "_ZN5S85C53v88Ev");}
void  S85C5 ::v89(){vfunc_called(this, "_ZN5S85C53v89Ev");}
void  S85C5 ::v90(){vfunc_called(this, "_ZN5S85C53v90Ev");}
void  S85C5 ::v91(){vfunc_called(this, "_ZN5S85C53v91Ev");}
void  S85C5 ::v92(){vfunc_called(this, "_ZN5S85C53v92Ev");}
void  S85C5 ::v93(){vfunc_called(this, "_ZN5S85C53v93Ev");}
void  S85C5 ::v94(){vfunc_called(this, "_ZN5S85C53v94Ev");}
void  S85C5 ::v95(){vfunc_called(this, "_ZN5S85C53v95Ev");}
void  S85C5 ::v96(){vfunc_called(this, "_ZN5S85C53v96Ev");}
void  S85C5 ::v97(){vfunc_called(this, "_ZN5S85C53v97Ev");}
void  S85C5 ::v98(){vfunc_called(this, "_ZN5S85C53v98Ev");}
void  S85C5 ::v99(){vfunc_called(this, "_ZN5S85C53v99Ev");}
void  S85C5 ::v100(){vfunc_called(this, "_ZN5S85C54v100Ev");}
void  S85C5 ::v101(){vfunc_called(this, "_ZN5S85C54v101Ev");}
void  S85C5 ::v102(){vfunc_called(this, "_ZN5S85C54v102Ev");}
void  S85C5 ::v103(){vfunc_called(this, "_ZN5S85C54v103Ev");}
void  S85C5 ::v104(){vfunc_called(this, "_ZN5S85C54v104Ev");}
void  S85C5 ::v105(){vfunc_called(this, "_ZN5S85C54v105Ev");}
void  S85C5 ::v106(){vfunc_called(this, "_ZN5S85C54v106Ev");}
void  S85C5 ::v107(){vfunc_called(this, "_ZN5S85C54v107Ev");}
void  S85C5 ::v108(){vfunc_called(this, "_ZN5S85C54v108Ev");}
void  S85C5 ::v109(){vfunc_called(this, "_ZN5S85C54v109Ev");}
void  S85C5 ::v110(){vfunc_called(this, "_ZN5S85C54v110Ev");}
void  S85C5 ::v111(){vfunc_called(this, "_ZN5S85C54v111Ev");}
void  S85C5 ::v112(){vfunc_called(this, "_ZN5S85C54v112Ev");}
void  S85C5 ::v113(){vfunc_called(this, "_ZN5S85C54v113Ev");}
void  S85C5 ::v114(){vfunc_called(this, "_ZN5S85C54v114Ev");}
void  S85C5 ::v115(){vfunc_called(this, "_ZN5S85C54v115Ev");}
void  S85C5 ::v116(){vfunc_called(this, "_ZN5S85C54v116Ev");}
void  S85C5 ::v117(){vfunc_called(this, "_ZN5S85C54v117Ev");}
void  S85C5 ::v118(){vfunc_called(this, "_ZN5S85C54v118Ev");}
void  S85C5 ::v119(){vfunc_called(this, "_ZN5S85C54v119Ev");}
void  S85C5 ::v120(){vfunc_called(this, "_ZN5S85C54v120Ev");}
void  S85C5 ::v121(){vfunc_called(this, "_ZN5S85C54v121Ev");}
void  S85C5 ::v122(){vfunc_called(this, "_ZN5S85C54v122Ev");}
void  S85C5 ::v123(){vfunc_called(this, "_ZN5S85C54v123Ev");}
void  S85C5 ::v124(){vfunc_called(this, "_ZN5S85C54v124Ev");}
void  S85C5 ::v125(){vfunc_called(this, "_ZN5S85C54v125Ev");}
void  S85C5 ::v126(){vfunc_called(this, "_ZN5S85C54v126Ev");}
void  S85C5 ::v127(){vfunc_called(this, "_ZN5S85C54v127Ev");}
void  S85C5 ::v128(){vfunc_called(this, "_ZN5S85C54v128Ev");}
void  S85C5 ::v129(){vfunc_called(this, "_ZN5S85C54v129Ev");}
void  S85C5 ::v130(){vfunc_called(this, "_ZN5S85C54v130Ev");}
void  S85C5 ::v131(){vfunc_called(this, "_ZN5S85C54v131Ev");}
void  S85C5 ::v132(){vfunc_called(this, "_ZN5S85C54v132Ev");}
void  S85C5 ::v133(){vfunc_called(this, "_ZN5S85C54v133Ev");}
void  S85C5 ::v134(){vfunc_called(this, "_ZN5S85C54v134Ev");}
void  S85C5 ::v135(){vfunc_called(this, "_ZN5S85C54v135Ev");}
void  S85C5 ::v136(){vfunc_called(this, "_ZN5S85C54v136Ev");}
void  S85C5 ::v137(){vfunc_called(this, "_ZN5S85C54v137Ev");}
void  S85C5 ::v138(){vfunc_called(this, "_ZN5S85C54v138Ev");}
void  S85C5 ::v139(){vfunc_called(this, "_ZN5S85C54v139Ev");}
void  S85C5 ::v140(){vfunc_called(this, "_ZN5S85C54v140Ev");}
void  S85C5 ::v141(){vfunc_called(this, "_ZN5S85C54v141Ev");}
void  S85C5 ::v142(){vfunc_called(this, "_ZN5S85C54v142Ev");}
void  S85C5 ::v143(){vfunc_called(this, "_ZN5S85C54v143Ev");}
void  S85C5 ::v144(){vfunc_called(this, "_ZN5S85C54v144Ev");}
void  S85C5 ::v145(){vfunc_called(this, "_ZN5S85C54v145Ev");}
S85C5 ::S85C5(){ note_ctor("S85C5", this);} // tgen

static void Test_S85C5()
{
  extern Class_Descriptor cd_S85C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S85C5, buf);
    S85C5 *dp, &lv = *(dp=new (buf) S85C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S85C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C5)");
    check_base_class_offset(lv, (S85C7*)(S85C6*), 0, "S85C5");
    check_base_class_offset(lv, (S85C6*), 0, "S85C5");
    check_field_offset(lv, s85c5f0, ABISELECT(96,60), "S85C5.s85c5f0");
    check_field_offset(lv, s85c5f1, ABISELECT(124,88), "S85C5.s85c5f1");
    set_bf_and_test(lv, s85c5f2, ABISELECT(128,92), 0, 1, 1, "S85C5");
    set_bf_and_test(lv, s85c5f3, ABISELECT(128,92), 1, 1, 1, "S85C5");
    set_bf_and_test(lv, s85c5f4, ABISELECT(128,92), 2, 1, 1, "S85C5");
    set_bf_and_test(lv, s85c5f5, ABISELECT(128,92), 3, 1, 1, "S85C5");
    check_field_offset(lv, s85c5f6, ABISELECT(136,96), "S85C5.s85c5f6");
    check_field_offset(lv, s85c5f7, ABISELECT(152,108), "S85C5.s85c5f7");
    check_field_offset(lv, s85c5f8, ABISELECT(168,120), "S85C5.s85c5f8");
    check_field_offset(lv, s85c5f9, ABISELECT(176,124), "S85C5.s85c5f9");
    check_field_offset(lv, s85c5f10, ABISELECT(192,136), "S85C5.s85c5f10");
    check_field_offset(lv, s85c5f11, ABISELECT(208,148), "S85C5.s85c5f11");
    check_field_offset(lv, s85c5f12, ABISELECT(224,160), "S85C5.s85c5f12");
    check_field_offset(lv, s85c5f13, ABISELECT(240,172), "S85C5.s85c5f13");
    check_field_offset(lv, s85c5f14, ABISELECT(244,176), "S85C5.s85c5f14");
    check_field_offset(lv, s85c5f15, ABISELECT(248,180), "S85C5.s85c5f15");
    check_field_offset(lv, s85c5f16, ABISELECT(256,184), "S85C5.s85c5f16");
    check_field_offset(lv, s85c5f17, ABISELECT(264,192), "S85C5.s85c5f17");
    check_field_offset(lv, s85c5f18, ABISELECT(272,200), "S85C5.s85c5f18");
    check_field_offset(lv, s85c5f19, ABISELECT(280,208), "S85C5.s85c5f19");
    check_field_offset(lv, s85c5f20, ABISELECT(288,216), "S85C5.s85c5f20");
    check_field_offset(lv, s85c5f21, ABISELECT(296,224), "S85C5.s85c5f21");
    check_field_offset(lv, s85c5f22, ABISELECT(304,232), "S85C5.s85c5f22");
    check_field_offset(lv, s85c5f23, ABISELECT(320,244), "S85C5.s85c5f23");
    check_field_offset(lv, s85c5f24, ABISELECT(336,256), "S85C5.s85c5f24");
    check_field_offset(lv, s85c5f25, ABISELECT(352,268), "S85C5.s85c5f25");
    check_field_offset(lv, s85c5f26, ABISELECT(368,280), "S85C5.s85c5f26");
    check_field_offset(lv, s85c5f27, ABISELECT(384,292), "S85C5.s85c5f27");
    check_field_offset(lv, s85c5f28, ABISELECT(400,304), "S85C5.s85c5f28");
    check_field_offset(lv, s85c5f29, ABISELECT(416,316), "S85C5.s85c5f29");
    check_field_offset(lv, s85c5f30, ABISELECT(432,328), "S85C5.s85c5f30");
    check_field_offset(lv, s85c5f31, ABISELECT(448,340), "S85C5.s85c5f31");
    test_class_info(&lv, &cd_S85C5);
    dp->~S85C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C5(Test_S85C5, "S85C5", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN5S85C5C1Ev();
extern void _ZN5S85C5D1Ev();
Name_Map name_map_S85C5[] = {
  NSPAIR(_ZN5S85C5C1Ev),
  NSPAIR(_ZN5S85C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
extern Class_Descriptor cd_S85C6;
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
static Base_Class bases_S85C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C5[];
extern void _ZN5S85C5D1Ev();
extern void _ZN5S85C5D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
extern void _ZN5S85C53v70Ev();
extern void _ZN5S85C53v71Ev();
extern void _ZN5S85C53v72Ev();
extern void _ZN5S85C53v73Ev();
extern void _ZN5S85C53v74Ev();
extern void _ZN5S85C53v75Ev();
extern void _ZN5S85C53v76Ev();
extern void _ZN5S85C53v77Ev();
extern void _ZN5S85C53v78Ev();
extern void _ZN5S85C53v79Ev();
extern void _ZN5S85C53v80Ev();
extern void _ZN5S85C53v81Ev();
extern void _ZN5S85C53v82Ev();
extern void _ZN5S85C53v83Ev();
extern void _ZN5S85C53v84Ev();
extern void _ZN5S85C53v85Ev();
extern void _ZN5S85C53v86Ev();
extern void _ZN5S85C53v87Ev();
extern void _ZN5S85C53v88Ev();
extern void _ZN5S85C53v89Ev();
extern void _ZN5S85C53v90Ev();
extern void _ZN5S85C53v91Ev();
extern void _ZN5S85C53v92Ev();
extern void _ZN5S85C53v93Ev();
extern void _ZN5S85C53v94Ev();
extern void _ZN5S85C53v95Ev();
extern void _ZN5S85C53v96Ev();
extern void _ZN5S85C53v97Ev();
extern void _ZN5S85C53v98Ev();
extern void _ZN5S85C53v99Ev();
extern void _ZN5S85C54v100Ev();
extern void _ZN5S85C54v101Ev();
extern void _ZN5S85C54v102Ev();
extern void _ZN5S85C54v103Ev();
extern void _ZN5S85C54v104Ev();
extern void _ZN5S85C54v105Ev();
extern void _ZN5S85C54v106Ev();
extern void _ZN5S85C54v107Ev();
extern void _ZN5S85C54v108Ev();
extern void _ZN5S85C54v109Ev();
extern void _ZN5S85C54v110Ev();
extern void _ZN5S85C54v111Ev();
extern void _ZN5S85C54v112Ev();
extern void _ZN5S85C54v113Ev();
extern void _ZN5S85C54v114Ev();
extern void _ZN5S85C54v115Ev();
extern void _ZN5S85C54v116Ev();
extern void _ZN5S85C54v117Ev();
extern void _ZN5S85C54v118Ev();
extern void _ZN5S85C54v119Ev();
extern void _ZN5S85C54v120Ev();
extern void _ZN5S85C54v121Ev();
extern void _ZN5S85C54v122Ev();
extern void _ZN5S85C54v123Ev();
extern void _ZN5S85C54v124Ev();
extern void _ZN5S85C54v125Ev();
extern void _ZN5S85C54v126Ev();
extern void _ZN5S85C54v127Ev();
extern void _ZN5S85C54v128Ev();
extern void _ZN5S85C54v129Ev();
extern void _ZN5S85C54v130Ev();
extern void _ZN5S85C54v131Ev();
extern void _ZN5S85C54v132Ev();
extern void _ZN5S85C54v133Ev();
extern void _ZN5S85C54v134Ev();
extern void _ZN5S85C54v135Ev();
extern void _ZN5S85C54v136Ev();
extern void _ZN5S85C54v137Ev();
extern void _ZN5S85C54v138Ev();
extern void _ZN5S85C54v139Ev();
extern void _ZN5S85C54v140Ev();
extern void _ZN5S85C54v141Ev();
extern void _ZN5S85C54v142Ev();
extern void _ZN5S85C54v143Ev();
extern void _ZN5S85C54v144Ev();
extern void _ZN5S85C54v145Ev();
static  VTBL_ENTRY vtc_S85C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C5[0]),
  (VTBL_ENTRY)&_ZN5S85C5D1Ev,
  (VTBL_ENTRY)&_ZN5S85C5D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
  (VTBL_ENTRY)&_ZN5S85C53v70Ev,
  (VTBL_ENTRY)&_ZN5S85C53v71Ev,
  (VTBL_ENTRY)&_ZN5S85C53v72Ev,
  (VTBL_ENTRY)&_ZN5S85C53v73Ev,
  (VTBL_ENTRY)&_ZN5S85C53v74Ev,
  (VTBL_ENTRY)&_ZN5S85C53v75Ev,
  (VTBL_ENTRY)&_ZN5S85C53v76Ev,
  (VTBL_ENTRY)&_ZN5S85C53v77Ev,
  (VTBL_ENTRY)&_ZN5S85C53v78Ev,
  (VTBL_ENTRY)&_ZN5S85C53v79Ev,
  (VTBL_ENTRY)&_ZN5S85C53v80Ev,
  (VTBL_ENTRY)&_ZN5S85C53v81Ev,
  (VTBL_ENTRY)&_ZN5S85C53v82Ev,
  (VTBL_ENTRY)&_ZN5S85C53v83Ev,
  (VTBL_ENTRY)&_ZN5S85C53v84Ev,
  (VTBL_ENTRY)&_ZN5S85C53v85Ev,
  (VTBL_ENTRY)&_ZN5S85C53v86Ev,
  (VTBL_ENTRY)&_ZN5S85C53v87Ev,
  (VTBL_ENTRY)&_ZN5S85C53v88Ev,
  (VTBL_ENTRY)&_ZN5S85C53v89Ev,
  (VTBL_ENTRY)&_ZN5S85C53v90Ev,
  (VTBL_ENTRY)&_ZN5S85C53v91Ev,
  (VTBL_ENTRY)&_ZN5S85C53v92Ev,
  (VTBL_ENTRY)&_ZN5S85C53v93Ev,
  (VTBL_ENTRY)&_ZN5S85C53v94Ev,
  (VTBL_ENTRY)&_ZN5S85C53v95Ev,
  (VTBL_ENTRY)&_ZN5S85C53v96Ev,
  (VTBL_ENTRY)&_ZN5S85C53v97Ev,
  (VTBL_ENTRY)&_ZN5S85C53v98Ev,
  (VTBL_ENTRY)&_ZN5S85C53v99Ev,
  (VTBL_ENTRY)&_ZN5S85C54v100Ev,
  (VTBL_ENTRY)&_ZN5S85C54v101Ev,
  (VTBL_ENTRY)&_ZN5S85C54v102Ev,
  (VTBL_ENTRY)&_ZN5S85C54v103Ev,
  (VTBL_ENTRY)&_ZN5S85C54v104Ev,
  (VTBL_ENTRY)&_ZN5S85C54v105Ev,
  (VTBL_ENTRY)&_ZN5S85C54v106Ev,
  (VTBL_ENTRY)&_ZN5S85C54v107Ev,
  (VTBL_ENTRY)&_ZN5S85C54v108Ev,
  (VTBL_ENTRY)&_ZN5S85C54v109Ev,
  (VTBL_ENTRY)&_ZN5S85C54v110Ev,
  (VTBL_ENTRY)&_ZN5S85C54v111Ev,
  (VTBL_ENTRY)&_ZN5S85C54v112Ev,
  (VTBL_ENTRY)&_ZN5S85C54v113Ev,
  (VTBL_ENTRY)&_ZN5S85C54v114Ev,
  (VTBL_ENTRY)&_ZN5S85C54v115Ev,
  (VTBL_ENTRY)&_ZN5S85C54v116Ev,
  (VTBL_ENTRY)&_ZN5S85C54v117Ev,
  (VTBL_ENTRY)&_ZN5S85C54v118Ev,
  (VTBL_ENTRY)&_ZN5S85C54v119Ev,
  (VTBL_ENTRY)&_ZN5S85C54v120Ev,
  (VTBL_ENTRY)&_ZN5S85C54v121Ev,
  (VTBL_ENTRY)&_ZN5S85C54v122Ev,
  (VTBL_ENTRY)&_ZN5S85C54v123Ev,
  (VTBL_ENTRY)&_ZN5S85C54v124Ev,
  (VTBL_ENTRY)&_ZN5S85C54v125Ev,
  (VTBL_ENTRY)&_ZN5S85C54v126Ev,
  (VTBL_ENTRY)&_ZN5S85C54v127Ev,
  (VTBL_ENTRY)&_ZN5S85C54v128Ev,
  (VTBL_ENTRY)&_ZN5S85C54v129Ev,
  (VTBL_ENTRY)&_ZN5S85C54v130Ev,
  (VTBL_ENTRY)&_ZN5S85C54v131Ev,
  (VTBL_ENTRY)&_ZN5S85C54v132Ev,
  (VTBL_ENTRY)&_ZN5S85C54v133Ev,
  (VTBL_ENTRY)&_ZN5S85C54v134Ev,
  (VTBL_ENTRY)&_ZN5S85C54v135Ev,
  (VTBL_ENTRY)&_ZN5S85C54v136Ev,
  (VTBL_ENTRY)&_ZN5S85C54v137Ev,
  (VTBL_ENTRY)&_ZN5S85C54v138Ev,
  (VTBL_ENTRY)&_ZN5S85C54v139Ev,
  (VTBL_ENTRY)&_ZN5S85C54v140Ev,
  (VTBL_ENTRY)&_ZN5S85C54v141Ev,
  (VTBL_ENTRY)&_ZN5S85C54v142Ev,
  (VTBL_ENTRY)&_ZN5S85C54v143Ev,
  (VTBL_ENTRY)&_ZN5S85C54v144Ev,
  (VTBL_ENTRY)&_ZN5S85C54v145Ev,
};
extern VTBL_ENTRY _ZTI5S85C5[];
extern  VTBL_ENTRY _ZTV5S85C5[];
Class_Descriptor cd_S85C5 = {  "S85C5", // class name
  bases_S85C5, 2,
  &(vtc_S85C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI5S85C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C5),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C23  : S80C12_nt {
};
//SIG(-1 S85C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S85C23()
{
  extern Class_Descriptor cd_S85C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S85C23, buf);
    S85C23 &lv = *(new (buf) S85C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S85C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C23)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S85C23");
    test_class_info(&lv, &cd_S85C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C23(Test_S85C23, "S85C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S85C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S85C23 = {  "S85C23", // class name
  bases_S85C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C22_nt  : S85C23 {
};
//SIG(-1 S85C22_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S85C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S85C23;
static Base_Class bases_S85C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C27_nt  {
  int s85c27f0[2];
  void  mf85c27(); // _ZN9S85C27_nt7mf85c27Ev
};
//SIG(-1 S85C27_nt) C1{ m Fi[2]}


void  S85C27_nt ::mf85c27(){}

//skip512 S85C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C4  : S85C5 {
  ::S80C8_nt s85c4f0;
  void *s85c4f1[9];
  ::S85C22_nt s85c4f2;
  ::S80C31 s85c4f3;
  ::S80C24 s85c4f4;
  int s85c4f5;
  unsigned int s85c4f6:1;
  unsigned int s85c4f7:1;
  unsigned int s85c4f8:1;
  unsigned int s85c4f9:1;
  unsigned int s85c4f10:1;
  unsigned int s85c4f11:1;
  unsigned int s85c4f12:1;
  unsigned int s85c4f13:1;
  unsigned int s85c4f14:1;
  unsigned int s85c4f15:1;
  unsigned int s85c4f16:1;
  unsigned int s85c4f17:1;
  unsigned int s85c4f18:1;
  unsigned int s85c4f19:1;
  unsigned int s85c4f20:1;
  unsigned int s85c4f21:1;
  unsigned int s85c4f22:1;
  unsigned int s85c4f23:1;
  unsigned int s85c4f24:1;
  unsigned int s85c4f25:1;
  unsigned int s85c4f26:1;
  unsigned int s85c4f27:1;
  void *s85c4f28;
  char s85c4f29[2];
  ::S85C27_nt s85c4f30;
  ::S80C8_nt s85c4f31;
  ::S80C8_nt s85c4f32;
  void *s85c4f33;
  ::S80C21_nt s85c4f34;
  ::S80C21_nt s85c4f35;
  ::S80C21_nt s85c4f36;
  ::S80C21_nt s85c4f37;
  ::S80C21_nt s85c4f38;
  virtual  ~S85C4(); // _ZN5S85C4D1Ev
  virtual void  v146(); // _ZN5S85C44v146Ev
  virtual void  v147(); // _ZN5S85C44v147Ev
  virtual void  v148(); // _ZN5S85C44v148Ev
  virtual void  v149(); // _ZN5S85C44v149Ev
  virtual void  v150(); // _ZN5S85C44v150Ev
  virtual void  v151(); // _ZN5S85C44v151Ev
  virtual void  v152(); // _ZN5S85C44v152Ev
  virtual void  v153(); // _ZN5S85C44v153Ev
  virtual void  v154(); // _ZN5S85C44v154Ev
  virtual void  v155(); // _ZN5S85C44v155Ev
  virtual void  v156(); // _ZN5S85C44v156Ev
  virtual void  v157(); // _ZN5S85C44v157Ev
  virtual void  v158(); // _ZN5S85C44v158Ev
  virtual void  v159(); // _ZN5S85C44v159Ev
  virtual void  v160(); // _ZN5S85C44v160Ev
  virtual void  v161(); // _ZN5S85C44v161Ev
  virtual void  v162(); // _ZN5S85C44v162Ev
  virtual void  v163(); // _ZN5S85C44v163Ev
  virtual void  v164(); // _ZN5S85C44v164Ev
  virtual void  v165(); // _ZN5S85C44v165Ev
  virtual void  v166(); // _ZN5S85C44v166Ev
  virtual void  v167(); // _ZN5S85C44v167Ev
  virtual void  v168(); // _ZN5S85C44v168Ev
  virtual void  v169(); // _ZN5S85C44v169Ev
  virtual void  v170(); // _ZN5S85C44v170Ev
  virtual void  v171(); // _ZN5S85C44v171Ev
  virtual void  v172(); // _ZN5S85C44v172Ev
  virtual void  v173(); // _ZN5S85C44v173Ev
  virtual void  v174(); // _ZN5S85C44v174Ev
  virtual void  v175(); // _ZN5S85C44v175Ev
  virtual void  v176(); // _ZN5S85C44v176Ev
  virtual void  v177(); // _ZN5S85C44v177Ev
  virtual void  v178(); // _ZN5S85C44v178Ev
  virtual void  v179(); // _ZN5S85C44v179Ev
  virtual void  v180(); // _ZN5S85C44v180Ev
  virtual void  v181(); // _ZN5S85C44v181Ev
  virtual void  v182(); // _ZN5S85C44v182Ev
  virtual void  v183(); // _ZN5S85C44v183Ev
  virtual void  v184(); // _ZN5S85C44v184Ev
  S85C4(); // tgen
};
//SIG(-1 S85C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC5} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC19{ BC20{ BC9}} FC7 FC21{ BC22{ m FC23{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC24{ m Fi[2]} FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S85C4 ::~S85C4(){ note_dtor("S85C4", this);}
void  S85C4 ::v146(){vfunc_called(this, "_ZN5S85C44v146Ev");}
void  S85C4 ::v147(){vfunc_called(this, "_ZN5S85C44v147Ev");}
void  S85C4 ::v148(){vfunc_called(this, "_ZN5S85C44v148Ev");}
void  S85C4 ::v149(){vfunc_called(this, "_ZN5S85C44v149Ev");}
void  S85C4 ::v150(){vfunc_called(this, "_ZN5S85C44v150Ev");}
void  S85C4 ::v151(){vfunc_called(this, "_ZN5S85C44v151Ev");}
void  S85C4 ::v152(){vfunc_called(this, "_ZN5S85C44v152Ev");}
void  S85C4 ::v153(){vfunc_called(this, "_ZN5S85C44v153Ev");}
void  S85C4 ::v154(){vfunc_called(this, "_ZN5S85C44v154Ev");}
void  S85C4 ::v155(){vfunc_called(this, "_ZN5S85C44v155Ev");}
void  S85C4 ::v156(){vfunc_called(this, "_ZN5S85C44v156Ev");}
void  S85C4 ::v157(){vfunc_called(this, "_ZN5S85C44v157Ev");}
void  S85C4 ::v158(){vfunc_called(this, "_ZN5S85C44v158Ev");}
void  S85C4 ::v159(){vfunc_called(this, "_ZN5S85C44v159Ev");}
void  S85C4 ::v160(){vfunc_called(this, "_ZN5S85C44v160Ev");}
void  S85C4 ::v161(){vfunc_called(this, "_ZN5S85C44v161Ev");}
void  S85C4 ::v162(){vfunc_called(this, "_ZN5S85C44v162Ev");}
void  S85C4 ::v163(){vfunc_called(this, "_ZN5S85C44v163Ev");}
void  S85C4 ::v164(){vfunc_called(this, "_ZN5S85C44v164Ev");}
void  S85C4 ::v165(){vfunc_called(this, "_ZN5S85C44v165Ev");}
void  S85C4 ::v166(){vfunc_called(this, "_ZN5S85C44v166Ev");}
void  S85C4 ::v167(){vfunc_called(this, "_ZN5S85C44v167Ev");}
void  S85C4 ::v168(){vfunc_called(this, "_ZN5S85C44v168Ev");}
void  S85C4 ::v169(){vfunc_called(this, "_ZN5S85C44v169Ev");}
void  S85C4 ::v170(){vfunc_called(this, "_ZN5S85C44v170Ev");}
void  S85C4 ::v171(){vfunc_called(this, "_ZN5S85C44v171Ev");}
void  S85C4 ::v172(){vfunc_called(this, "_ZN5S85C44v172Ev");}
void  S85C4 ::v173(){vfunc_called(this, "_ZN5S85C44v173Ev");}
void  S85C4 ::v174(){vfunc_called(this, "_ZN5S85C44v174Ev");}
void  S85C4 ::v175(){vfunc_called(this, "_ZN5S85C44v175Ev");}
void  S85C4 ::v176(){vfunc_called(this, "_ZN5S85C44v176Ev");}
void  S85C4 ::v177(){vfunc_called(this, "_ZN5S85C44v177Ev");}
void  S85C4 ::v178(){vfunc_called(this, "_ZN5S85C44v178Ev");}
void  S85C4 ::v179(){vfunc_called(this, "_ZN5S85C44v179Ev");}
void  S85C4 ::v180(){vfunc_called(this, "_ZN5S85C44v180Ev");}
void  S85C4 ::v181(){vfunc_called(this, "_ZN5S85C44v181Ev");}
void  S85C4 ::v182(){vfunc_called(this, "_ZN5S85C44v182Ev");}
void  S85C4 ::v183(){vfunc_called(this, "_ZN5S85C44v183Ev");}
void  S85C4 ::v184(){vfunc_called(this, "_ZN5S85C44v184Ev");}
S85C4 ::S85C4(){ note_ctor("S85C4", this);} // tgen

static void Test_S85C4()
{
  extern Class_Descriptor cd_S85C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S85C4, buf);
    S85C4 *dp, &lv = *(dp=new (buf) S85C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S85C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C4)");
    check_base_class_offset(lv, (S85C7*)(S85C6*)(S85C5*), 0, "S85C4");
    check_base_class_offset(lv, (S85C6*)(S85C5*), 0, "S85C4");
    check_base_class_offset(lv, (S85C5*), 0, "S85C4");
    check_field_offset(lv, s85c4f0, ABISELECT(464,352), "S85C4.s85c4f0");
    check_field_offset(lv, s85c4f1, ABISELECT(472,360), "S85C4.s85c4f1");
    check_field_offset(lv, s85c4f2, ABISELECT(544,396), "S85C4.s85c4f2");
    check_field_offset(lv, s85c4f3, ABISELECT(560,408), "S85C4.s85c4f3");
    check_field_offset(lv, s85c4f4, ABISELECT(576,420), "S85C4.s85c4f4");
    check_field_offset(lv, s85c4f5, ABISELECT(608,440), "S85C4.s85c4f5");
    set_bf_and_test(lv, s85c4f6, ABISELECT(612,444), 0, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f7, ABISELECT(612,444), 1, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f8, ABISELECT(612,444), 2, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f9, ABISELECT(612,444), 3, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f10, ABISELECT(612,444), 4, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f11, ABISELECT(612,444), 5, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f12, ABISELECT(612,444), 6, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f13, ABISELECT(612,444), 7, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f14, ABISELECT(613,445), 0, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f15, ABISELECT(613,445), 1, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f16, ABISELECT(613,445), 2, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f17, ABISELECT(613,445), 3, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f18, ABISELECT(613,445), 4, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f19, ABISELECT(613,445), 5, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f20, ABISELECT(613,445), 6, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f21, ABISELECT(613,445), 7, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f22, ABISELECT(614,446), 0, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f23, ABISELECT(614,446), 1, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f24, ABISELECT(614,446), 2, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f25, ABISELECT(614,446), 3, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f26, ABISELECT(614,446), 4, 1, 1, "S85C4");
    set_bf_and_test(lv, s85c4f27, ABISELECT(614,446), 5, 1, 1, "S85C4");
    check_field_offset(lv, s85c4f28, ABISELECT(616,448), "S85C4.s85c4f28");
    check_field_offset(lv, s85c4f29, ABISELECT(624,452), "S85C4.s85c4f29");
    check_field_offset(lv, s85c4f30, ABISELECT(628,456), "S85C4.s85c4f30");
    check_field_offset(lv, s85c4f31, ABISELECT(636,464), "S85C4.s85c4f31");
    check_field_offset(lv, s85c4f32, ABISELECT(644,472), "S85C4.s85c4f32");
    check_field_offset(lv, s85c4f33, ABISELECT(656,480), "S85C4.s85c4f33");
    check_field_offset(lv, s85c4f34, ABISELECT(664,484), "S85C4.s85c4f34");
    check_field_offset(lv, s85c4f35, ABISELECT(680,496), "S85C4.s85c4f35");
    check_field_offset(lv, s85c4f36, ABISELECT(696,508), "S85C4.s85c4f36");
    check_field_offset(lv, s85c4f37, ABISELECT(712,520), "S85C4.s85c4f37");
    check_field_offset(lv, s85c4f38, ABISELECT(728,532), "S85C4.s85c4f38");
    test_class_info(&lv, &cd_S85C4);
    dp->~S85C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C4(Test_S85C4, "S85C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN5S85C4C1Ev();
extern void _ZN5S85C4D1Ev();
Name_Map name_map_S85C4[] = {
  NSPAIR(_ZN5S85C4C1Ev),
  NSPAIR(_ZN5S85C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
extern Class_Descriptor cd_S85C6;
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
extern Class_Descriptor cd_S85C5;
extern VTBL_ENTRY _ZTI5S85C5[];
extern  VTBL_ENTRY _ZTV5S85C5[];
static Base_Class bases_S85C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S85C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C4[];
extern void _ZN5S85C4D1Ev();
extern void _ZN5S85C4D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
extern void _ZN5S85C53v70Ev();
extern void _ZN5S85C53v71Ev();
extern void _ZN5S85C53v72Ev();
extern void _ZN5S85C53v73Ev();
extern void _ZN5S85C53v74Ev();
extern void _ZN5S85C53v75Ev();
extern void _ZN5S85C53v76Ev();
extern void _ZN5S85C53v77Ev();
extern void _ZN5S85C53v78Ev();
extern void _ZN5S85C53v79Ev();
extern void _ZN5S85C53v80Ev();
extern void _ZN5S85C53v81Ev();
extern void _ZN5S85C53v82Ev();
extern void _ZN5S85C53v83Ev();
extern void _ZN5S85C53v84Ev();
extern void _ZN5S85C53v85Ev();
extern void _ZN5S85C53v86Ev();
extern void _ZN5S85C53v87Ev();
extern void _ZN5S85C53v88Ev();
extern void _ZN5S85C53v89Ev();
extern void _ZN5S85C53v90Ev();
extern void _ZN5S85C53v91Ev();
extern void _ZN5S85C53v92Ev();
extern void _ZN5S85C53v93Ev();
extern void _ZN5S85C53v94Ev();
extern void _ZN5S85C53v95Ev();
extern void _ZN5S85C53v96Ev();
extern void _ZN5S85C53v97Ev();
extern void _ZN5S85C53v98Ev();
extern void _ZN5S85C53v99Ev();
extern void _ZN5S85C54v100Ev();
extern void _ZN5S85C54v101Ev();
extern void _ZN5S85C54v102Ev();
extern void _ZN5S85C54v103Ev();
extern void _ZN5S85C54v104Ev();
extern void _ZN5S85C54v105Ev();
extern void _ZN5S85C54v106Ev();
extern void _ZN5S85C54v107Ev();
extern void _ZN5S85C54v108Ev();
extern void _ZN5S85C54v109Ev();
extern void _ZN5S85C54v110Ev();
extern void _ZN5S85C54v111Ev();
extern void _ZN5S85C54v112Ev();
extern void _ZN5S85C54v113Ev();
extern void _ZN5S85C54v114Ev();
extern void _ZN5S85C54v115Ev();
extern void _ZN5S85C54v116Ev();
extern void _ZN5S85C54v117Ev();
extern void _ZN5S85C54v118Ev();
extern void _ZN5S85C54v119Ev();
extern void _ZN5S85C54v120Ev();
extern void _ZN5S85C54v121Ev();
extern void _ZN5S85C54v122Ev();
extern void _ZN5S85C54v123Ev();
extern void _ZN5S85C54v124Ev();
extern void _ZN5S85C54v125Ev();
extern void _ZN5S85C54v126Ev();
extern void _ZN5S85C54v127Ev();
extern void _ZN5S85C54v128Ev();
extern void _ZN5S85C54v129Ev();
extern void _ZN5S85C54v130Ev();
extern void _ZN5S85C54v131Ev();
extern void _ZN5S85C54v132Ev();
extern void _ZN5S85C54v133Ev();
extern void _ZN5S85C54v134Ev();
extern void _ZN5S85C54v135Ev();
extern void _ZN5S85C54v136Ev();
extern void _ZN5S85C54v137Ev();
extern void _ZN5S85C54v138Ev();
extern void _ZN5S85C54v139Ev();
extern void _ZN5S85C54v140Ev();
extern void _ZN5S85C54v141Ev();
extern void _ZN5S85C54v142Ev();
extern void _ZN5S85C54v143Ev();
extern void _ZN5S85C54v144Ev();
extern void _ZN5S85C54v145Ev();
extern void _ZN5S85C44v146Ev();
extern void _ZN5S85C44v147Ev();
extern void _ZN5S85C44v148Ev();
extern void _ZN5S85C44v149Ev();
extern void _ZN5S85C44v150Ev();
extern void _ZN5S85C44v151Ev();
extern void _ZN5S85C44v152Ev();
extern void _ZN5S85C44v153Ev();
extern void _ZN5S85C44v154Ev();
extern void _ZN5S85C44v155Ev();
extern void _ZN5S85C44v156Ev();
extern void _ZN5S85C44v157Ev();
extern void _ZN5S85C44v158Ev();
extern void _ZN5S85C44v159Ev();
extern void _ZN5S85C44v160Ev();
extern void _ZN5S85C44v161Ev();
extern void _ZN5S85C44v162Ev();
extern void _ZN5S85C44v163Ev();
extern void _ZN5S85C44v164Ev();
extern void _ZN5S85C44v165Ev();
extern void _ZN5S85C44v166Ev();
extern void _ZN5S85C44v167Ev();
extern void _ZN5S85C44v168Ev();
extern void _ZN5S85C44v169Ev();
extern void _ZN5S85C44v170Ev();
extern void _ZN5S85C44v171Ev();
extern void _ZN5S85C44v172Ev();
extern void _ZN5S85C44v173Ev();
extern void _ZN5S85C44v174Ev();
extern void _ZN5S85C44v175Ev();
extern void _ZN5S85C44v176Ev();
extern void _ZN5S85C44v177Ev();
extern void _ZN5S85C44v178Ev();
extern void _ZN5S85C44v179Ev();
extern void _ZN5S85C44v180Ev();
extern void _ZN5S85C44v181Ev();
extern void _ZN5S85C44v182Ev();
extern void _ZN5S85C44v183Ev();
extern void _ZN5S85C44v184Ev();
static  VTBL_ENTRY vtc_S85C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C4[0]),
  (VTBL_ENTRY)&_ZN5S85C4D1Ev,
  (VTBL_ENTRY)&_ZN5S85C4D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
  (VTBL_ENTRY)&_ZN5S85C53v70Ev,
  (VTBL_ENTRY)&_ZN5S85C53v71Ev,
  (VTBL_ENTRY)&_ZN5S85C53v72Ev,
  (VTBL_ENTRY)&_ZN5S85C53v73Ev,
  (VTBL_ENTRY)&_ZN5S85C53v74Ev,
  (VTBL_ENTRY)&_ZN5S85C53v75Ev,
  (VTBL_ENTRY)&_ZN5S85C53v76Ev,
  (VTBL_ENTRY)&_ZN5S85C53v77Ev,
  (VTBL_ENTRY)&_ZN5S85C53v78Ev,
  (VTBL_ENTRY)&_ZN5S85C53v79Ev,
  (VTBL_ENTRY)&_ZN5S85C53v80Ev,
  (VTBL_ENTRY)&_ZN5S85C53v81Ev,
  (VTBL_ENTRY)&_ZN5S85C53v82Ev,
  (VTBL_ENTRY)&_ZN5S85C53v83Ev,
  (VTBL_ENTRY)&_ZN5S85C53v84Ev,
  (VTBL_ENTRY)&_ZN5S85C53v85Ev,
  (VTBL_ENTRY)&_ZN5S85C53v86Ev,
  (VTBL_ENTRY)&_ZN5S85C53v87Ev,
  (VTBL_ENTRY)&_ZN5S85C53v88Ev,
  (VTBL_ENTRY)&_ZN5S85C53v89Ev,
  (VTBL_ENTRY)&_ZN5S85C53v90Ev,
  (VTBL_ENTRY)&_ZN5S85C53v91Ev,
  (VTBL_ENTRY)&_ZN5S85C53v92Ev,
  (VTBL_ENTRY)&_ZN5S85C53v93Ev,
  (VTBL_ENTRY)&_ZN5S85C53v94Ev,
  (VTBL_ENTRY)&_ZN5S85C53v95Ev,
  (VTBL_ENTRY)&_ZN5S85C53v96Ev,
  (VTBL_ENTRY)&_ZN5S85C53v97Ev,
  (VTBL_ENTRY)&_ZN5S85C53v98Ev,
  (VTBL_ENTRY)&_ZN5S85C53v99Ev,
  (VTBL_ENTRY)&_ZN5S85C54v100Ev,
  (VTBL_ENTRY)&_ZN5S85C54v101Ev,
  (VTBL_ENTRY)&_ZN5S85C54v102Ev,
  (VTBL_ENTRY)&_ZN5S85C54v103Ev,
  (VTBL_ENTRY)&_ZN5S85C54v104Ev,
  (VTBL_ENTRY)&_ZN5S85C54v105Ev,
  (VTBL_ENTRY)&_ZN5S85C54v106Ev,
  (VTBL_ENTRY)&_ZN5S85C54v107Ev,
  (VTBL_ENTRY)&_ZN5S85C54v108Ev,
  (VTBL_ENTRY)&_ZN5S85C54v109Ev,
  (VTBL_ENTRY)&_ZN5S85C54v110Ev,
  (VTBL_ENTRY)&_ZN5S85C54v111Ev,
  (VTBL_ENTRY)&_ZN5S85C54v112Ev,
  (VTBL_ENTRY)&_ZN5S85C54v113Ev,
  (VTBL_ENTRY)&_ZN5S85C54v114Ev,
  (VTBL_ENTRY)&_ZN5S85C54v115Ev,
  (VTBL_ENTRY)&_ZN5S85C54v116Ev,
  (VTBL_ENTRY)&_ZN5S85C54v117Ev,
  (VTBL_ENTRY)&_ZN5S85C54v118Ev,
  (VTBL_ENTRY)&_ZN5S85C54v119Ev,
  (VTBL_ENTRY)&_ZN5S85C54v120Ev,
  (VTBL_ENTRY)&_ZN5S85C54v121Ev,
  (VTBL_ENTRY)&_ZN5S85C54v122Ev,
  (VTBL_ENTRY)&_ZN5S85C54v123Ev,
  (VTBL_ENTRY)&_ZN5S85C54v124Ev,
  (VTBL_ENTRY)&_ZN5S85C54v125Ev,
  (VTBL_ENTRY)&_ZN5S85C54v126Ev,
  (VTBL_ENTRY)&_ZN5S85C54v127Ev,
  (VTBL_ENTRY)&_ZN5S85C54v128Ev,
  (VTBL_ENTRY)&_ZN5S85C54v129Ev,
  (VTBL_ENTRY)&_ZN5S85C54v130Ev,
  (VTBL_ENTRY)&_ZN5S85C54v131Ev,
  (VTBL_ENTRY)&_ZN5S85C54v132Ev,
  (VTBL_ENTRY)&_ZN5S85C54v133Ev,
  (VTBL_ENTRY)&_ZN5S85C54v134Ev,
  (VTBL_ENTRY)&_ZN5S85C54v135Ev,
  (VTBL_ENTRY)&_ZN5S85C54v136Ev,
  (VTBL_ENTRY)&_ZN5S85C54v137Ev,
  (VTBL_ENTRY)&_ZN5S85C54v138Ev,
  (VTBL_ENTRY)&_ZN5S85C54v139Ev,
  (VTBL_ENTRY)&_ZN5S85C54v140Ev,
  (VTBL_ENTRY)&_ZN5S85C54v141Ev,
  (VTBL_ENTRY)&_ZN5S85C54v142Ev,
  (VTBL_ENTRY)&_ZN5S85C54v143Ev,
  (VTBL_ENTRY)&_ZN5S85C54v144Ev,
  (VTBL_ENTRY)&_ZN5S85C54v145Ev,
  (VTBL_ENTRY)&_ZN5S85C44v146Ev,
  (VTBL_ENTRY)&_ZN5S85C44v147Ev,
  (VTBL_ENTRY)&_ZN5S85C44v148Ev,
  (VTBL_ENTRY)&_ZN5S85C44v149Ev,
  (VTBL_ENTRY)&_ZN5S85C44v150Ev,
  (VTBL_ENTRY)&_ZN5S85C44v151Ev,
  (VTBL_ENTRY)&_ZN5S85C44v152Ev,
  (VTBL_ENTRY)&_ZN5S85C44v153Ev,
  (VTBL_ENTRY)&_ZN5S85C44v154Ev,
  (VTBL_ENTRY)&_ZN5S85C44v155Ev,
  (VTBL_ENTRY)&_ZN5S85C44v156Ev,
  (VTBL_ENTRY)&_ZN5S85C44v157Ev,
  (VTBL_ENTRY)&_ZN5S85C44v158Ev,
  (VTBL_ENTRY)&_ZN5S85C44v159Ev,
  (VTBL_ENTRY)&_ZN5S85C44v160Ev,
  (VTBL_ENTRY)&_ZN5S85C44v161Ev,
  (VTBL_ENTRY)&_ZN5S85C44v162Ev,
  (VTBL_ENTRY)&_ZN5S85C44v163Ev,
  (VTBL_ENTRY)&_ZN5S85C44v164Ev,
  (VTBL_ENTRY)&_ZN5S85C44v165Ev,
  (VTBL_ENTRY)&_ZN5S85C44v166Ev,
  (VTBL_ENTRY)&_ZN5S85C44v167Ev,
  (VTBL_ENTRY)&_ZN5S85C44v168Ev,
  (VTBL_ENTRY)&_ZN5S85C44v169Ev,
  (VTBL_ENTRY)&_ZN5S85C44v170Ev,
  (VTBL_ENTRY)&_ZN5S85C44v171Ev,
  (VTBL_ENTRY)&_ZN5S85C44v172Ev,
  (VTBL_ENTRY)&_ZN5S85C44v173Ev,
  (VTBL_ENTRY)&_ZN5S85C44v174Ev,
  (VTBL_ENTRY)&_ZN5S85C44v175Ev,
  (VTBL_ENTRY)&_ZN5S85C44v176Ev,
  (VTBL_ENTRY)&_ZN5S85C44v177Ev,
  (VTBL_ENTRY)&_ZN5S85C44v178Ev,
  (VTBL_ENTRY)&_ZN5S85C44v179Ev,
  (VTBL_ENTRY)&_ZN5S85C44v180Ev,
  (VTBL_ENTRY)&_ZN5S85C44v181Ev,
  (VTBL_ENTRY)&_ZN5S85C44v182Ev,
  (VTBL_ENTRY)&_ZN5S85C44v183Ev,
  (VTBL_ENTRY)&_ZN5S85C44v184Ev,
};
extern VTBL_ENTRY _ZTI5S85C4[];
extern  VTBL_ENTRY _ZTV5S85C4[];
Class_Descriptor cd_S85C4 = {  "S85C4", // class name
  bases_S85C4, 3,
  &(vtc_S85C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI5S85C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C3  : S85C4 {
  unsigned int s85c3f0:1;
  unsigned int s85c3f1:1;
  unsigned int s85c3f2:1;
  unsigned int s85c3f3:1;
  unsigned int s85c3f4:1;
  unsigned int s85c3f5:1;
  void *s85c3f6[8];
  ::S80C21_nt s85c3f7;
  ::S80C21_nt s85c3f8;
  ::S80C21_nt s85c3f9;
  virtual  ~S85C3(); // _ZN5S85C3D1Ev
  virtual void  v185(); // _ZN5S85C34v185Ev
  virtual void  v186(); // _ZN5S85C34v186Ev
  virtual void  v187(); // _ZN5S85C34v187Ev
  virtual void  v188(); // _ZN5S85C34v188Ev
  virtual void  v189(); // _ZN5S85C34v189Ev
  virtual void  v190(); // _ZN5S85C34v190Ev
  virtual void  v191(); // _ZN5S85C34v191Ev
  virtual void  v192(); // _ZN5S85C34v192Ev
  virtual void  v193(); // _ZN5S85C34v193Ev
  virtual void  v194(); // _ZN5S85C34v194Ev
  virtual void  v195(); // _ZN5S85C34v195Ev
  virtual void  v196(); // _ZN5S85C34v196Ev
  virtual void  v197(); // _ZN5S85C34v197Ev
  virtual void  v198(); // _ZN5S85C34v198Ev
  virtual void  v199(); // _ZN5S85C34v199Ev
  virtual void  v200(); // _ZN5S85C34v200Ev
  virtual void  v201(); // _ZN5S85C34v201Ev
  virtual void  v202(); // _ZN5S85C34v202Ev
  virtual void  v203(); // _ZN5S85C34v203Ev
  virtual void  v204(); // _ZN5S85C34v204Ev
  virtual void  v205(); // _ZN5S85C34v205Ev
  virtual void  v206(); // _ZN5S85C34v206Ev
  virtual void  v207(); // _ZN5S85C34v207Ev
  S85C3(); // tgen
};
//SIG(-1 S85C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC6} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC20{ BC21{ BC10}} FC8 FC22{ BC23{ m FC24{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC25{ m Fi[2]} FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S85C3 ::~S85C3(){ note_dtor("S85C3", this);}
void  S85C3 ::v185(){vfunc_called(this, "_ZN5S85C34v185Ev");}
void  S85C3 ::v186(){vfunc_called(this, "_ZN5S85C34v186Ev");}
void  S85C3 ::v187(){vfunc_called(this, "_ZN5S85C34v187Ev");}
void  S85C3 ::v188(){vfunc_called(this, "_ZN5S85C34v188Ev");}
void  S85C3 ::v189(){vfunc_called(this, "_ZN5S85C34v189Ev");}
void  S85C3 ::v190(){vfunc_called(this, "_ZN5S85C34v190Ev");}
void  S85C3 ::v191(){vfunc_called(this, "_ZN5S85C34v191Ev");}
void  S85C3 ::v192(){vfunc_called(this, "_ZN5S85C34v192Ev");}
void  S85C3 ::v193(){vfunc_called(this, "_ZN5S85C34v193Ev");}
void  S85C3 ::v194(){vfunc_called(this, "_ZN5S85C34v194Ev");}
void  S85C3 ::v195(){vfunc_called(this, "_ZN5S85C34v195Ev");}
void  S85C3 ::v196(){vfunc_called(this, "_ZN5S85C34v196Ev");}
void  S85C3 ::v197(){vfunc_called(this, "_ZN5S85C34v197Ev");}
void  S85C3 ::v198(){vfunc_called(this, "_ZN5S85C34v198Ev");}
void  S85C3 ::v199(){vfunc_called(this, "_ZN5S85C34v199Ev");}
void  S85C3 ::v200(){vfunc_called(this, "_ZN5S85C34v200Ev");}
void  S85C3 ::v201(){vfunc_called(this, "_ZN5S85C34v201Ev");}
void  S85C3 ::v202(){vfunc_called(this, "_ZN5S85C34v202Ev");}
void  S85C3 ::v203(){vfunc_called(this, "_ZN5S85C34v203Ev");}
void  S85C3 ::v204(){vfunc_called(this, "_ZN5S85C34v204Ev");}
void  S85C3 ::v205(){vfunc_called(this, "_ZN5S85C34v205Ev");}
void  S85C3 ::v206(){vfunc_called(this, "_ZN5S85C34v206Ev");}
void  S85C3 ::v207(){vfunc_called(this, "_ZN5S85C34v207Ev");}
S85C3 ::S85C3(){ note_ctor("S85C3", this);} // tgen

static void Test_S85C3()
{
  extern Class_Descriptor cd_S85C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S85C3, buf);
    S85C3 *dp, &lv = *(dp=new (buf) S85C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S85C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C3)");
    check_base_class_offset(lv, (S85C7*)(S85C6*)(S85C5*)(S85C4*), 0, "S85C3");
    check_base_class_offset(lv, (S85C6*)(S85C5*)(S85C4*), 0, "S85C3");
    check_base_class_offset(lv, (S85C5*)(S85C4*), 0, "S85C3");
    check_base_class_offset(lv, (S85C4*), 0, "S85C3");
    set_bf_and_test(lv, s85c3f0, ABISELECT(744,544), 0, 1, 1, "S85C3");
    set_bf_and_test(lv, s85c3f1, ABISELECT(744,544), 1, 1, 1, "S85C3");
    set_bf_and_test(lv, s85c3f2, ABISELECT(744,544), 2, 1, 1, "S85C3");
    set_bf_and_test(lv, s85c3f3, ABISELECT(744,544), 3, 1, 1, "S85C3");
    set_bf_and_test(lv, s85c3f4, ABISELECT(744,544), 4, 1, 1, "S85C3");
    set_bf_and_test(lv, s85c3f5, ABISELECT(744,544), 5, 1, 1, "S85C3");
    check_field_offset(lv, s85c3f6, ABISELECT(752,548), "S85C3.s85c3f6");
    check_field_offset(lv, s85c3f7, ABISELECT(816,580), "S85C3.s85c3f7");
    check_field_offset(lv, s85c3f8, ABISELECT(832,592), "S85C3.s85c3f8");
    check_field_offset(lv, s85c3f9, ABISELECT(848,604), "S85C3.s85c3f9");
    test_class_info(&lv, &cd_S85C3);
    dp->~S85C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C3(Test_S85C3, "S85C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN5S85C3C1Ev();
extern void _ZN5S85C3D1Ev();
Name_Map name_map_S85C3[] = {
  NSPAIR(_ZN5S85C3C1Ev),
  NSPAIR(_ZN5S85C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
extern Class_Descriptor cd_S85C6;
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
extern Class_Descriptor cd_S85C5;
extern VTBL_ENTRY _ZTI5S85C5[];
extern  VTBL_ENTRY _ZTV5S85C5[];
extern Class_Descriptor cd_S85C4;
extern VTBL_ENTRY _ZTI5S85C4[];
extern  VTBL_ENTRY _ZTV5S85C4[];
static Base_Class bases_S85C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S85C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S85C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C3[];
extern void _ZN5S85C3D1Ev();
extern void _ZN5S85C3D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
extern void _ZN5S85C53v70Ev();
extern void _ZN5S85C53v71Ev();
extern void _ZN5S85C53v72Ev();
extern void _ZN5S85C53v73Ev();
extern void _ZN5S85C53v74Ev();
extern void _ZN5S85C53v75Ev();
extern void _ZN5S85C53v76Ev();
extern void _ZN5S85C53v77Ev();
extern void _ZN5S85C53v78Ev();
extern void _ZN5S85C53v79Ev();
extern void _ZN5S85C53v80Ev();
extern void _ZN5S85C53v81Ev();
extern void _ZN5S85C53v82Ev();
extern void _ZN5S85C53v83Ev();
extern void _ZN5S85C53v84Ev();
extern void _ZN5S85C53v85Ev();
extern void _ZN5S85C53v86Ev();
extern void _ZN5S85C53v87Ev();
extern void _ZN5S85C53v88Ev();
extern void _ZN5S85C53v89Ev();
extern void _ZN5S85C53v90Ev();
extern void _ZN5S85C53v91Ev();
extern void _ZN5S85C53v92Ev();
extern void _ZN5S85C53v93Ev();
extern void _ZN5S85C53v94Ev();
extern void _ZN5S85C53v95Ev();
extern void _ZN5S85C53v96Ev();
extern void _ZN5S85C53v97Ev();
extern void _ZN5S85C53v98Ev();
extern void _ZN5S85C53v99Ev();
extern void _ZN5S85C54v100Ev();
extern void _ZN5S85C54v101Ev();
extern void _ZN5S85C54v102Ev();
extern void _ZN5S85C54v103Ev();
extern void _ZN5S85C54v104Ev();
extern void _ZN5S85C54v105Ev();
extern void _ZN5S85C54v106Ev();
extern void _ZN5S85C54v107Ev();
extern void _ZN5S85C54v108Ev();
extern void _ZN5S85C54v109Ev();
extern void _ZN5S85C54v110Ev();
extern void _ZN5S85C54v111Ev();
extern void _ZN5S85C54v112Ev();
extern void _ZN5S85C54v113Ev();
extern void _ZN5S85C54v114Ev();
extern void _ZN5S85C54v115Ev();
extern void _ZN5S85C54v116Ev();
extern void _ZN5S85C54v117Ev();
extern void _ZN5S85C54v118Ev();
extern void _ZN5S85C54v119Ev();
extern void _ZN5S85C54v120Ev();
extern void _ZN5S85C54v121Ev();
extern void _ZN5S85C54v122Ev();
extern void _ZN5S85C54v123Ev();
extern void _ZN5S85C54v124Ev();
extern void _ZN5S85C54v125Ev();
extern void _ZN5S85C54v126Ev();
extern void _ZN5S85C54v127Ev();
extern void _ZN5S85C54v128Ev();
extern void _ZN5S85C54v129Ev();
extern void _ZN5S85C54v130Ev();
extern void _ZN5S85C54v131Ev();
extern void _ZN5S85C54v132Ev();
extern void _ZN5S85C54v133Ev();
extern void _ZN5S85C54v134Ev();
extern void _ZN5S85C54v135Ev();
extern void _ZN5S85C54v136Ev();
extern void _ZN5S85C54v137Ev();
extern void _ZN5S85C54v138Ev();
extern void _ZN5S85C54v139Ev();
extern void _ZN5S85C54v140Ev();
extern void _ZN5S85C54v141Ev();
extern void _ZN5S85C54v142Ev();
extern void _ZN5S85C54v143Ev();
extern void _ZN5S85C54v144Ev();
extern void _ZN5S85C54v145Ev();
extern void _ZN5S85C44v146Ev();
extern void _ZN5S85C44v147Ev();
extern void _ZN5S85C44v148Ev();
extern void _ZN5S85C44v149Ev();
extern void _ZN5S85C44v150Ev();
extern void _ZN5S85C44v151Ev();
extern void _ZN5S85C44v152Ev();
extern void _ZN5S85C44v153Ev();
extern void _ZN5S85C44v154Ev();
extern void _ZN5S85C44v155Ev();
extern void _ZN5S85C44v156Ev();
extern void _ZN5S85C44v157Ev();
extern void _ZN5S85C44v158Ev();
extern void _ZN5S85C44v159Ev();
extern void _ZN5S85C44v160Ev();
extern void _ZN5S85C44v161Ev();
extern void _ZN5S85C44v162Ev();
extern void _ZN5S85C44v163Ev();
extern void _ZN5S85C44v164Ev();
extern void _ZN5S85C44v165Ev();
extern void _ZN5S85C44v166Ev();
extern void _ZN5S85C44v167Ev();
extern void _ZN5S85C44v168Ev();
extern void _ZN5S85C44v169Ev();
extern void _ZN5S85C44v170Ev();
extern void _ZN5S85C44v171Ev();
extern void _ZN5S85C44v172Ev();
extern void _ZN5S85C44v173Ev();
extern void _ZN5S85C44v174Ev();
extern void _ZN5S85C44v175Ev();
extern void _ZN5S85C44v176Ev();
extern void _ZN5S85C44v177Ev();
extern void _ZN5S85C44v178Ev();
extern void _ZN5S85C44v179Ev();
extern void _ZN5S85C44v180Ev();
extern void _ZN5S85C44v181Ev();
extern void _ZN5S85C44v182Ev();
extern void _ZN5S85C44v183Ev();
extern void _ZN5S85C44v184Ev();
extern void _ZN5S85C34v185Ev();
extern void _ZN5S85C34v186Ev();
extern void _ZN5S85C34v187Ev();
extern void _ZN5S85C34v188Ev();
extern void _ZN5S85C34v189Ev();
extern void _ZN5S85C34v190Ev();
extern void _ZN5S85C34v191Ev();
extern void _ZN5S85C34v192Ev();
extern void _ZN5S85C34v193Ev();
extern void _ZN5S85C34v194Ev();
extern void _ZN5S85C34v195Ev();
extern void _ZN5S85C34v196Ev();
extern void _ZN5S85C34v197Ev();
extern void _ZN5S85C34v198Ev();
extern void _ZN5S85C34v199Ev();
extern void _ZN5S85C34v200Ev();
extern void _ZN5S85C34v201Ev();
extern void _ZN5S85C34v202Ev();
extern void _ZN5S85C34v203Ev();
extern void _ZN5S85C34v204Ev();
extern void _ZN5S85C34v205Ev();
extern void _ZN5S85C34v206Ev();
extern void _ZN5S85C34v207Ev();
static  VTBL_ENTRY vtc_S85C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C3[0]),
  (VTBL_ENTRY)&_ZN5S85C3D1Ev,
  (VTBL_ENTRY)&_ZN5S85C3D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
  (VTBL_ENTRY)&_ZN5S85C53v70Ev,
  (VTBL_ENTRY)&_ZN5S85C53v71Ev,
  (VTBL_ENTRY)&_ZN5S85C53v72Ev,
  (VTBL_ENTRY)&_ZN5S85C53v73Ev,
  (VTBL_ENTRY)&_ZN5S85C53v74Ev,
  (VTBL_ENTRY)&_ZN5S85C53v75Ev,
  (VTBL_ENTRY)&_ZN5S85C53v76Ev,
  (VTBL_ENTRY)&_ZN5S85C53v77Ev,
  (VTBL_ENTRY)&_ZN5S85C53v78Ev,
  (VTBL_ENTRY)&_ZN5S85C53v79Ev,
  (VTBL_ENTRY)&_ZN5S85C53v80Ev,
  (VTBL_ENTRY)&_ZN5S85C53v81Ev,
  (VTBL_ENTRY)&_ZN5S85C53v82Ev,
  (VTBL_ENTRY)&_ZN5S85C53v83Ev,
  (VTBL_ENTRY)&_ZN5S85C53v84Ev,
  (VTBL_ENTRY)&_ZN5S85C53v85Ev,
  (VTBL_ENTRY)&_ZN5S85C53v86Ev,
  (VTBL_ENTRY)&_ZN5S85C53v87Ev,
  (VTBL_ENTRY)&_ZN5S85C53v88Ev,
  (VTBL_ENTRY)&_ZN5S85C53v89Ev,
  (VTBL_ENTRY)&_ZN5S85C53v90Ev,
  (VTBL_ENTRY)&_ZN5S85C53v91Ev,
  (VTBL_ENTRY)&_ZN5S85C53v92Ev,
  (VTBL_ENTRY)&_ZN5S85C53v93Ev,
  (VTBL_ENTRY)&_ZN5S85C53v94Ev,
  (VTBL_ENTRY)&_ZN5S85C53v95Ev,
  (VTBL_ENTRY)&_ZN5S85C53v96Ev,
  (VTBL_ENTRY)&_ZN5S85C53v97Ev,
  (VTBL_ENTRY)&_ZN5S85C53v98Ev,
  (VTBL_ENTRY)&_ZN5S85C53v99Ev,
  (VTBL_ENTRY)&_ZN5S85C54v100Ev,
  (VTBL_ENTRY)&_ZN5S85C54v101Ev,
  (VTBL_ENTRY)&_ZN5S85C54v102Ev,
  (VTBL_ENTRY)&_ZN5S85C54v103Ev,
  (VTBL_ENTRY)&_ZN5S85C54v104Ev,
  (VTBL_ENTRY)&_ZN5S85C54v105Ev,
  (VTBL_ENTRY)&_ZN5S85C54v106Ev,
  (VTBL_ENTRY)&_ZN5S85C54v107Ev,
  (VTBL_ENTRY)&_ZN5S85C54v108Ev,
  (VTBL_ENTRY)&_ZN5S85C54v109Ev,
  (VTBL_ENTRY)&_ZN5S85C54v110Ev,
  (VTBL_ENTRY)&_ZN5S85C54v111Ev,
  (VTBL_ENTRY)&_ZN5S85C54v112Ev,
  (VTBL_ENTRY)&_ZN5S85C54v113Ev,
  (VTBL_ENTRY)&_ZN5S85C54v114Ev,
  (VTBL_ENTRY)&_ZN5S85C54v115Ev,
  (VTBL_ENTRY)&_ZN5S85C54v116Ev,
  (VTBL_ENTRY)&_ZN5S85C54v117Ev,
  (VTBL_ENTRY)&_ZN5S85C54v118Ev,
  (VTBL_ENTRY)&_ZN5S85C54v119Ev,
  (VTBL_ENTRY)&_ZN5S85C54v120Ev,
  (VTBL_ENTRY)&_ZN5S85C54v121Ev,
  (VTBL_ENTRY)&_ZN5S85C54v122Ev,
  (VTBL_ENTRY)&_ZN5S85C54v123Ev,
  (VTBL_ENTRY)&_ZN5S85C54v124Ev,
  (VTBL_ENTRY)&_ZN5S85C54v125Ev,
  (VTBL_ENTRY)&_ZN5S85C54v126Ev,
  (VTBL_ENTRY)&_ZN5S85C54v127Ev,
  (VTBL_ENTRY)&_ZN5S85C54v128Ev,
  (VTBL_ENTRY)&_ZN5S85C54v129Ev,
  (VTBL_ENTRY)&_ZN5S85C54v130Ev,
  (VTBL_ENTRY)&_ZN5S85C54v131Ev,
  (VTBL_ENTRY)&_ZN5S85C54v132Ev,
  (VTBL_ENTRY)&_ZN5S85C54v133Ev,
  (VTBL_ENTRY)&_ZN5S85C54v134Ev,
  (VTBL_ENTRY)&_ZN5S85C54v135Ev,
  (VTBL_ENTRY)&_ZN5S85C54v136Ev,
  (VTBL_ENTRY)&_ZN5S85C54v137Ev,
  (VTBL_ENTRY)&_ZN5S85C54v138Ev,
  (VTBL_ENTRY)&_ZN5S85C54v139Ev,
  (VTBL_ENTRY)&_ZN5S85C54v140Ev,
  (VTBL_ENTRY)&_ZN5S85C54v141Ev,
  (VTBL_ENTRY)&_ZN5S85C54v142Ev,
  (VTBL_ENTRY)&_ZN5S85C54v143Ev,
  (VTBL_ENTRY)&_ZN5S85C54v144Ev,
  (VTBL_ENTRY)&_ZN5S85C54v145Ev,
  (VTBL_ENTRY)&_ZN5S85C44v146Ev,
  (VTBL_ENTRY)&_ZN5S85C44v147Ev,
  (VTBL_ENTRY)&_ZN5S85C44v148Ev,
  (VTBL_ENTRY)&_ZN5S85C44v149Ev,
  (VTBL_ENTRY)&_ZN5S85C44v150Ev,
  (VTBL_ENTRY)&_ZN5S85C44v151Ev,
  (VTBL_ENTRY)&_ZN5S85C44v152Ev,
  (VTBL_ENTRY)&_ZN5S85C44v153Ev,
  (VTBL_ENTRY)&_ZN5S85C44v154Ev,
  (VTBL_ENTRY)&_ZN5S85C44v155Ev,
  (VTBL_ENTRY)&_ZN5S85C44v156Ev,
  (VTBL_ENTRY)&_ZN5S85C44v157Ev,
  (VTBL_ENTRY)&_ZN5S85C44v158Ev,
  (VTBL_ENTRY)&_ZN5S85C44v159Ev,
  (VTBL_ENTRY)&_ZN5S85C44v160Ev,
  (VTBL_ENTRY)&_ZN5S85C44v161Ev,
  (VTBL_ENTRY)&_ZN5S85C44v162Ev,
  (VTBL_ENTRY)&_ZN5S85C44v163Ev,
  (VTBL_ENTRY)&_ZN5S85C44v164Ev,
  (VTBL_ENTRY)&_ZN5S85C44v165Ev,
  (VTBL_ENTRY)&_ZN5S85C44v166Ev,
  (VTBL_ENTRY)&_ZN5S85C44v167Ev,
  (VTBL_ENTRY)&_ZN5S85C44v168Ev,
  (VTBL_ENTRY)&_ZN5S85C44v169Ev,
  (VTBL_ENTRY)&_ZN5S85C44v170Ev,
  (VTBL_ENTRY)&_ZN5S85C44v171Ev,
  (VTBL_ENTRY)&_ZN5S85C44v172Ev,
  (VTBL_ENTRY)&_ZN5S85C44v173Ev,
  (VTBL_ENTRY)&_ZN5S85C44v174Ev,
  (VTBL_ENTRY)&_ZN5S85C44v175Ev,
  (VTBL_ENTRY)&_ZN5S85C44v176Ev,
  (VTBL_ENTRY)&_ZN5S85C44v177Ev,
  (VTBL_ENTRY)&_ZN5S85C44v178Ev,
  (VTBL_ENTRY)&_ZN5S85C44v179Ev,
  (VTBL_ENTRY)&_ZN5S85C44v180Ev,
  (VTBL_ENTRY)&_ZN5S85C44v181Ev,
  (VTBL_ENTRY)&_ZN5S85C44v182Ev,
  (VTBL_ENTRY)&_ZN5S85C44v183Ev,
  (VTBL_ENTRY)&_ZN5S85C44v184Ev,
  (VTBL_ENTRY)&_ZN5S85C34v185Ev,
  (VTBL_ENTRY)&_ZN5S85C34v186Ev,
  (VTBL_ENTRY)&_ZN5S85C34v187Ev,
  (VTBL_ENTRY)&_ZN5S85C34v188Ev,
  (VTBL_ENTRY)&_ZN5S85C34v189Ev,
  (VTBL_ENTRY)&_ZN5S85C34v190Ev,
  (VTBL_ENTRY)&_ZN5S85C34v191Ev,
  (VTBL_ENTRY)&_ZN5S85C34v192Ev,
  (VTBL_ENTRY)&_ZN5S85C34v193Ev,
  (VTBL_ENTRY)&_ZN5S85C34v194Ev,
  (VTBL_ENTRY)&_ZN5S85C34v195Ev,
  (VTBL_ENTRY)&_ZN5S85C34v196Ev,
  (VTBL_ENTRY)&_ZN5S85C34v197Ev,
  (VTBL_ENTRY)&_ZN5S85C34v198Ev,
  (VTBL_ENTRY)&_ZN5S85C34v199Ev,
  (VTBL_ENTRY)&_ZN5S85C34v200Ev,
  (VTBL_ENTRY)&_ZN5S85C34v201Ev,
  (VTBL_ENTRY)&_ZN5S85C34v202Ev,
  (VTBL_ENTRY)&_ZN5S85C34v203Ev,
  (VTBL_ENTRY)&_ZN5S85C34v204Ev,
  (VTBL_ENTRY)&_ZN5S85C34v205Ev,
  (VTBL_ENTRY)&_ZN5S85C34v206Ev,
  (VTBL_ENTRY)&_ZN5S85C34v207Ev,
};
extern VTBL_ENTRY _ZTI5S85C3[];
extern  VTBL_ENTRY _ZTV5S85C3[];
Class_Descriptor cd_S85C3 = {  "S85C3", // class name
  bases_S85C3, 4,
  &(vtc_S85C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI5S85C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C2  : S85C3 {
  virtual  ~S85C2(); // _ZN5S85C2D1Ev
  virtual void  v208(); // _ZN5S85C24v208Ev
  virtual void  v209(); // _ZN5S85C24v209Ev
  S85C2(); // tgen
};
//SIG(-1 S85C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v67 v68} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC7} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 FC7 Fp[9] FC21{ BC22{ BC11}} FC9 FC23{ BC24{ m FC25{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC26{ m Fi[2]} FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2}


 S85C2 ::~S85C2(){ note_dtor("S85C2", this);}
void  S85C2 ::v208(){vfunc_called(this, "_ZN5S85C24v208Ev");}
void  S85C2 ::v209(){vfunc_called(this, "_ZN5S85C24v209Ev");}
S85C2 ::S85C2(){ note_ctor("S85C2", this);} // tgen

static void Test_S85C2()
{
  extern Class_Descriptor cd_S85C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S85C2, buf);
    S85C2 *dp, &lv = *(dp=new (buf) S85C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S85C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C2)");
    check_base_class_offset(lv, (S85C7*)(S85C6*)(S85C5*)(S85C4*)(S85C3*), 0, "S85C2");
    check_base_class_offset(lv, (S85C6*)(S85C5*)(S85C4*)(S85C3*), 0, "S85C2");
    check_base_class_offset(lv, (S85C5*)(S85C4*)(S85C3*), 0, "S85C2");
    check_base_class_offset(lv, (S85C4*)(S85C3*), 0, "S85C2");
    check_base_class_offset(lv, (S85C3*), 0, "S85C2");
    test_class_info(&lv, &cd_S85C2);
    dp->~S85C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C2(Test_S85C2, "S85C2", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN5S85C2C1Ev();
extern void _ZN5S85C2D1Ev();
Name_Map name_map_S85C2[] = {
  NSPAIR(_ZN5S85C2C1Ev),
  NSPAIR(_ZN5S85C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
extern Class_Descriptor cd_S85C6;
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
extern Class_Descriptor cd_S85C5;
extern VTBL_ENTRY _ZTI5S85C5[];
extern  VTBL_ENTRY _ZTV5S85C5[];
extern Class_Descriptor cd_S85C4;
extern VTBL_ENTRY _ZTI5S85C4[];
extern  VTBL_ENTRY _ZTV5S85C4[];
extern Class_Descriptor cd_S85C3;
extern VTBL_ENTRY _ZTI5S85C3[];
extern  VTBL_ENTRY _ZTV5S85C3[];
static Base_Class bases_S85C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S85C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S85C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S85C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C2[];
extern void _ZN5S85C2D1Ev();
extern void _ZN5S85C2D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
extern void _ZN5S85C53v70Ev();
extern void _ZN5S85C53v71Ev();
extern void _ZN5S85C53v72Ev();
extern void _ZN5S85C53v73Ev();
extern void _ZN5S85C53v74Ev();
extern void _ZN5S85C53v75Ev();
extern void _ZN5S85C53v76Ev();
extern void _ZN5S85C53v77Ev();
extern void _ZN5S85C53v78Ev();
extern void _ZN5S85C53v79Ev();
extern void _ZN5S85C53v80Ev();
extern void _ZN5S85C53v81Ev();
extern void _ZN5S85C53v82Ev();
extern void _ZN5S85C53v83Ev();
extern void _ZN5S85C53v84Ev();
extern void _ZN5S85C53v85Ev();
extern void _ZN5S85C53v86Ev();
extern void _ZN5S85C53v87Ev();
extern void _ZN5S85C53v88Ev();
extern void _ZN5S85C53v89Ev();
extern void _ZN5S85C53v90Ev();
extern void _ZN5S85C53v91Ev();
extern void _ZN5S85C53v92Ev();
extern void _ZN5S85C53v93Ev();
extern void _ZN5S85C53v94Ev();
extern void _ZN5S85C53v95Ev();
extern void _ZN5S85C53v96Ev();
extern void _ZN5S85C53v97Ev();
extern void _ZN5S85C53v98Ev();
extern void _ZN5S85C53v99Ev();
extern void _ZN5S85C54v100Ev();
extern void _ZN5S85C54v101Ev();
extern void _ZN5S85C54v102Ev();
extern void _ZN5S85C54v103Ev();
extern void _ZN5S85C54v104Ev();
extern void _ZN5S85C54v105Ev();
extern void _ZN5S85C54v106Ev();
extern void _ZN5S85C54v107Ev();
extern void _ZN5S85C54v108Ev();
extern void _ZN5S85C54v109Ev();
extern void _ZN5S85C54v110Ev();
extern void _ZN5S85C54v111Ev();
extern void _ZN5S85C54v112Ev();
extern void _ZN5S85C54v113Ev();
extern void _ZN5S85C54v114Ev();
extern void _ZN5S85C54v115Ev();
extern void _ZN5S85C54v116Ev();
extern void _ZN5S85C54v117Ev();
extern void _ZN5S85C54v118Ev();
extern void _ZN5S85C54v119Ev();
extern void _ZN5S85C54v120Ev();
extern void _ZN5S85C54v121Ev();
extern void _ZN5S85C54v122Ev();
extern void _ZN5S85C54v123Ev();
extern void _ZN5S85C54v124Ev();
extern void _ZN5S85C54v125Ev();
extern void _ZN5S85C54v126Ev();
extern void _ZN5S85C54v127Ev();
extern void _ZN5S85C54v128Ev();
extern void _ZN5S85C54v129Ev();
extern void _ZN5S85C54v130Ev();
extern void _ZN5S85C54v131Ev();
extern void _ZN5S85C54v132Ev();
extern void _ZN5S85C54v133Ev();
extern void _ZN5S85C54v134Ev();
extern void _ZN5S85C54v135Ev();
extern void _ZN5S85C54v136Ev();
extern void _ZN5S85C54v137Ev();
extern void _ZN5S85C54v138Ev();
extern void _ZN5S85C54v139Ev();
extern void _ZN5S85C54v140Ev();
extern void _ZN5S85C54v141Ev();
extern void _ZN5S85C54v142Ev();
extern void _ZN5S85C54v143Ev();
extern void _ZN5S85C54v144Ev();
extern void _ZN5S85C54v145Ev();
extern void _ZN5S85C44v146Ev();
extern void _ZN5S85C44v147Ev();
extern void _ZN5S85C44v148Ev();
extern void _ZN5S85C44v149Ev();
extern void _ZN5S85C44v150Ev();
extern void _ZN5S85C44v151Ev();
extern void _ZN5S85C44v152Ev();
extern void _ZN5S85C44v153Ev();
extern void _ZN5S85C44v154Ev();
extern void _ZN5S85C44v155Ev();
extern void _ZN5S85C44v156Ev();
extern void _ZN5S85C44v157Ev();
extern void _ZN5S85C44v158Ev();
extern void _ZN5S85C44v159Ev();
extern void _ZN5S85C44v160Ev();
extern void _ZN5S85C44v161Ev();
extern void _ZN5S85C44v162Ev();
extern void _ZN5S85C44v163Ev();
extern void _ZN5S85C44v164Ev();
extern void _ZN5S85C44v165Ev();
extern void _ZN5S85C44v166Ev();
extern void _ZN5S85C44v167Ev();
extern void _ZN5S85C44v168Ev();
extern void _ZN5S85C44v169Ev();
extern void _ZN5S85C44v170Ev();
extern void _ZN5S85C44v171Ev();
extern void _ZN5S85C44v172Ev();
extern void _ZN5S85C44v173Ev();
extern void _ZN5S85C44v174Ev();
extern void _ZN5S85C44v175Ev();
extern void _ZN5S85C44v176Ev();
extern void _ZN5S85C44v177Ev();
extern void _ZN5S85C44v178Ev();
extern void _ZN5S85C44v179Ev();
extern void _ZN5S85C44v180Ev();
extern void _ZN5S85C44v181Ev();
extern void _ZN5S85C44v182Ev();
extern void _ZN5S85C44v183Ev();
extern void _ZN5S85C44v184Ev();
extern void _ZN5S85C34v185Ev();
extern void _ZN5S85C34v186Ev();
extern void _ZN5S85C34v187Ev();
extern void _ZN5S85C34v188Ev();
extern void _ZN5S85C34v189Ev();
extern void _ZN5S85C34v190Ev();
extern void _ZN5S85C34v191Ev();
extern void _ZN5S85C34v192Ev();
extern void _ZN5S85C34v193Ev();
extern void _ZN5S85C34v194Ev();
extern void _ZN5S85C34v195Ev();
extern void _ZN5S85C34v196Ev();
extern void _ZN5S85C34v197Ev();
extern void _ZN5S85C34v198Ev();
extern void _ZN5S85C34v199Ev();
extern void _ZN5S85C34v200Ev();
extern void _ZN5S85C34v201Ev();
extern void _ZN5S85C34v202Ev();
extern void _ZN5S85C34v203Ev();
extern void _ZN5S85C34v204Ev();
extern void _ZN5S85C34v205Ev();
extern void _ZN5S85C34v206Ev();
extern void _ZN5S85C34v207Ev();
extern void _ZN5S85C24v208Ev();
extern void _ZN5S85C24v209Ev();
static  VTBL_ENTRY vtc_S85C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C2[0]),
  (VTBL_ENTRY)&_ZN5S85C2D1Ev,
  (VTBL_ENTRY)&_ZN5S85C2D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
  (VTBL_ENTRY)&_ZN5S85C53v70Ev,
  (VTBL_ENTRY)&_ZN5S85C53v71Ev,
  (VTBL_ENTRY)&_ZN5S85C53v72Ev,
  (VTBL_ENTRY)&_ZN5S85C53v73Ev,
  (VTBL_ENTRY)&_ZN5S85C53v74Ev,
  (VTBL_ENTRY)&_ZN5S85C53v75Ev,
  (VTBL_ENTRY)&_ZN5S85C53v76Ev,
  (VTBL_ENTRY)&_ZN5S85C53v77Ev,
  (VTBL_ENTRY)&_ZN5S85C53v78Ev,
  (VTBL_ENTRY)&_ZN5S85C53v79Ev,
  (VTBL_ENTRY)&_ZN5S85C53v80Ev,
  (VTBL_ENTRY)&_ZN5S85C53v81Ev,
  (VTBL_ENTRY)&_ZN5S85C53v82Ev,
  (VTBL_ENTRY)&_ZN5S85C53v83Ev,
  (VTBL_ENTRY)&_ZN5S85C53v84Ev,
  (VTBL_ENTRY)&_ZN5S85C53v85Ev,
  (VTBL_ENTRY)&_ZN5S85C53v86Ev,
  (VTBL_ENTRY)&_ZN5S85C53v87Ev,
  (VTBL_ENTRY)&_ZN5S85C53v88Ev,
  (VTBL_ENTRY)&_ZN5S85C53v89Ev,
  (VTBL_ENTRY)&_ZN5S85C53v90Ev,
  (VTBL_ENTRY)&_ZN5S85C53v91Ev,
  (VTBL_ENTRY)&_ZN5S85C53v92Ev,
  (VTBL_ENTRY)&_ZN5S85C53v93Ev,
  (VTBL_ENTRY)&_ZN5S85C53v94Ev,
  (VTBL_ENTRY)&_ZN5S85C53v95Ev,
  (VTBL_ENTRY)&_ZN5S85C53v96Ev,
  (VTBL_ENTRY)&_ZN5S85C53v97Ev,
  (VTBL_ENTRY)&_ZN5S85C53v98Ev,
  (VTBL_ENTRY)&_ZN5S85C53v99Ev,
  (VTBL_ENTRY)&_ZN5S85C54v100Ev,
  (VTBL_ENTRY)&_ZN5S85C54v101Ev,
  (VTBL_ENTRY)&_ZN5S85C54v102Ev,
  (VTBL_ENTRY)&_ZN5S85C54v103Ev,
  (VTBL_ENTRY)&_ZN5S85C54v104Ev,
  (VTBL_ENTRY)&_ZN5S85C54v105Ev,
  (VTBL_ENTRY)&_ZN5S85C54v106Ev,
  (VTBL_ENTRY)&_ZN5S85C54v107Ev,
  (VTBL_ENTRY)&_ZN5S85C54v108Ev,
  (VTBL_ENTRY)&_ZN5S85C54v109Ev,
  (VTBL_ENTRY)&_ZN5S85C54v110Ev,
  (VTBL_ENTRY)&_ZN5S85C54v111Ev,
  (VTBL_ENTRY)&_ZN5S85C54v112Ev,
  (VTBL_ENTRY)&_ZN5S85C54v113Ev,
  (VTBL_ENTRY)&_ZN5S85C54v114Ev,
  (VTBL_ENTRY)&_ZN5S85C54v115Ev,
  (VTBL_ENTRY)&_ZN5S85C54v116Ev,
  (VTBL_ENTRY)&_ZN5S85C54v117Ev,
  (VTBL_ENTRY)&_ZN5S85C54v118Ev,
  (VTBL_ENTRY)&_ZN5S85C54v119Ev,
  (VTBL_ENTRY)&_ZN5S85C54v120Ev,
  (VTBL_ENTRY)&_ZN5S85C54v121Ev,
  (VTBL_ENTRY)&_ZN5S85C54v122Ev,
  (VTBL_ENTRY)&_ZN5S85C54v123Ev,
  (VTBL_ENTRY)&_ZN5S85C54v124Ev,
  (VTBL_ENTRY)&_ZN5S85C54v125Ev,
  (VTBL_ENTRY)&_ZN5S85C54v126Ev,
  (VTBL_ENTRY)&_ZN5S85C54v127Ev,
  (VTBL_ENTRY)&_ZN5S85C54v128Ev,
  (VTBL_ENTRY)&_ZN5S85C54v129Ev,
  (VTBL_ENTRY)&_ZN5S85C54v130Ev,
  (VTBL_ENTRY)&_ZN5S85C54v131Ev,
  (VTBL_ENTRY)&_ZN5S85C54v132Ev,
  (VTBL_ENTRY)&_ZN5S85C54v133Ev,
  (VTBL_ENTRY)&_ZN5S85C54v134Ev,
  (VTBL_ENTRY)&_ZN5S85C54v135Ev,
  (VTBL_ENTRY)&_ZN5S85C54v136Ev,
  (VTBL_ENTRY)&_ZN5S85C54v137Ev,
  (VTBL_ENTRY)&_ZN5S85C54v138Ev,
  (VTBL_ENTRY)&_ZN5S85C54v139Ev,
  (VTBL_ENTRY)&_ZN5S85C54v140Ev,
  (VTBL_ENTRY)&_ZN5S85C54v141Ev,
  (VTBL_ENTRY)&_ZN5S85C54v142Ev,
  (VTBL_ENTRY)&_ZN5S85C54v143Ev,
  (VTBL_ENTRY)&_ZN5S85C54v144Ev,
  (VTBL_ENTRY)&_ZN5S85C54v145Ev,
  (VTBL_ENTRY)&_ZN5S85C44v146Ev,
  (VTBL_ENTRY)&_ZN5S85C44v147Ev,
  (VTBL_ENTRY)&_ZN5S85C44v148Ev,
  (VTBL_ENTRY)&_ZN5S85C44v149Ev,
  (VTBL_ENTRY)&_ZN5S85C44v150Ev,
  (VTBL_ENTRY)&_ZN5S85C44v151Ev,
  (VTBL_ENTRY)&_ZN5S85C44v152Ev,
  (VTBL_ENTRY)&_ZN5S85C44v153Ev,
  (VTBL_ENTRY)&_ZN5S85C44v154Ev,
  (VTBL_ENTRY)&_ZN5S85C44v155Ev,
  (VTBL_ENTRY)&_ZN5S85C44v156Ev,
  (VTBL_ENTRY)&_ZN5S85C44v157Ev,
  (VTBL_ENTRY)&_ZN5S85C44v158Ev,
  (VTBL_ENTRY)&_ZN5S85C44v159Ev,
  (VTBL_ENTRY)&_ZN5S85C44v160Ev,
  (VTBL_ENTRY)&_ZN5S85C44v161Ev,
  (VTBL_ENTRY)&_ZN5S85C44v162Ev,
  (VTBL_ENTRY)&_ZN5S85C44v163Ev,
  (VTBL_ENTRY)&_ZN5S85C44v164Ev,
  (VTBL_ENTRY)&_ZN5S85C44v165Ev,
  (VTBL_ENTRY)&_ZN5S85C44v166Ev,
  (VTBL_ENTRY)&_ZN5S85C44v167Ev,
  (VTBL_ENTRY)&_ZN5S85C44v168Ev,
  (VTBL_ENTRY)&_ZN5S85C44v169Ev,
  (VTBL_ENTRY)&_ZN5S85C44v170Ev,
  (VTBL_ENTRY)&_ZN5S85C44v171Ev,
  (VTBL_ENTRY)&_ZN5S85C44v172Ev,
  (VTBL_ENTRY)&_ZN5S85C44v173Ev,
  (VTBL_ENTRY)&_ZN5S85C44v174Ev,
  (VTBL_ENTRY)&_ZN5S85C44v175Ev,
  (VTBL_ENTRY)&_ZN5S85C44v176Ev,
  (VTBL_ENTRY)&_ZN5S85C44v177Ev,
  (VTBL_ENTRY)&_ZN5S85C44v178Ev,
  (VTBL_ENTRY)&_ZN5S85C44v179Ev,
  (VTBL_ENTRY)&_ZN5S85C44v180Ev,
  (VTBL_ENTRY)&_ZN5S85C44v181Ev,
  (VTBL_ENTRY)&_ZN5S85C44v182Ev,
  (VTBL_ENTRY)&_ZN5S85C44v183Ev,
  (VTBL_ENTRY)&_ZN5S85C44v184Ev,
  (VTBL_ENTRY)&_ZN5S85C34v185Ev,
  (VTBL_ENTRY)&_ZN5S85C34v186Ev,
  (VTBL_ENTRY)&_ZN5S85C34v187Ev,
  (VTBL_ENTRY)&_ZN5S85C34v188Ev,
  (VTBL_ENTRY)&_ZN5S85C34v189Ev,
  (VTBL_ENTRY)&_ZN5S85C34v190Ev,
  (VTBL_ENTRY)&_ZN5S85C34v191Ev,
  (VTBL_ENTRY)&_ZN5S85C34v192Ev,
  (VTBL_ENTRY)&_ZN5S85C34v193Ev,
  (VTBL_ENTRY)&_ZN5S85C34v194Ev,
  (VTBL_ENTRY)&_ZN5S85C34v195Ev,
  (VTBL_ENTRY)&_ZN5S85C34v196Ev,
  (VTBL_ENTRY)&_ZN5S85C34v197Ev,
  (VTBL_ENTRY)&_ZN5S85C34v198Ev,
  (VTBL_ENTRY)&_ZN5S85C34v199Ev,
  (VTBL_ENTRY)&_ZN5S85C34v200Ev,
  (VTBL_ENTRY)&_ZN5S85C34v201Ev,
  (VTBL_ENTRY)&_ZN5S85C34v202Ev,
  (VTBL_ENTRY)&_ZN5S85C34v203Ev,
  (VTBL_ENTRY)&_ZN5S85C34v204Ev,
  (VTBL_ENTRY)&_ZN5S85C34v205Ev,
  (VTBL_ENTRY)&_ZN5S85C34v206Ev,
  (VTBL_ENTRY)&_ZN5S85C34v207Ev,
  (VTBL_ENTRY)&_ZN5S85C24v208Ev,
  (VTBL_ENTRY)&_ZN5S85C24v209Ev,
};
extern VTBL_ENTRY _ZTI5S85C2[];
extern  VTBL_ENTRY _ZTV5S85C2[];
Class_Descriptor cd_S85C2 = {  "S85C2", // class name
  bases_S85C2, 5,
  &(vtc_S85C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI5S85C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C2),210, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C34_nt  {
  int s85c34f0[4];
  void  mf85c34(); // _ZN9S85C34_nt7mf85c34Ev
};
//SIG(-1 S85C34_nt) C1{ m Fi[4]}


void  S85C34_nt ::mf85c34(){}

//skip512 S85C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C36  : S80C12_nt {
};
//SIG(-1 S85C36) C1{ BC2{ m Fp Fi[2]}}



static void Test_S85C36()
{
  extern Class_Descriptor cd_S85C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S85C36, buf);
    S85C36 &lv = *(new (buf) S85C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S85C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C36)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S85C36");
    test_class_info(&lv, &cd_S85C36);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C36(Test_S85C36, "S85C36", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S85C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S85C36 = {  "S85C36", // class name
  bases_S85C36, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C35  : S85C36 {
};
//SIG(-1 S85C35) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S85C35()
{
  extern Class_Descriptor cd_S85C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S85C35, buf);
    S85C35 &lv = *(new (buf) S85C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S85C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C35)");
    check_base_class_offset(lv, (S80C12_nt*)(S85C36*), 0, "S85C35");
    check_base_class_offset(lv, (S85C36*), 0, "S85C35");
    test_class_info(&lv, &cd_S85C35);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C35(Test_S85C35, "S85C35", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S85C36;
static Base_Class bases_S85C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S85C35 = {  "S85C35", // class name
  bases_S85C35, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C28  {
  int s85c28f0;
  ::S80C28_nt s85c28f1;
  ::S80C28_nt s85c28f2;
  ::S80C28_nt s85c28f3;
  ::S80C28_nt s85c28f4;
  ::S85C22_nt s85c28f5;
  ::S85C22_nt s85c28f6;
  ::S85C22_nt s85c28f7;
  ::S85C22_nt s85c28f8;
  char s85c28f9;
  ::S80C28_nt s85c28f10;
  ::S80C8_nt s85c28f11;
  ::S80C8_nt s85c28f12;
  int s85c28f13;
  void *s85c28f14;
  unsigned int s85c28f15:1;
  ::S85C34_nt s85c28f16;
  ::S80C28_nt s85c28f17;
  void *s85c28f18;
  ::S80C28_nt s85c28f19;
  ::S85C35 s85c28f20;
  void *s85c28f21;
  void  mf85c28(); // _ZN6S85C287mf85c28Ev
};
//SIG(-1 S85C28) C1{ m Fi FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} FC2 FC2 FC2 FC6{ BC7{ BC5}} FC6 FC6 FC6 Fc FC2 FC8{ m Fi[2]} FC8 Fi Fp Fi:1 FC9{ m Fi[4]} FC2 Fp FC2 FC10{ BC11{ BC5}} Fp}


void  S85C28 ::mf85c28(){}

static void Test_S85C28()
{
  {
    init_simple_test("S85C28");
    static S85C28 lv;
    check2(sizeof(lv), ABISELECT(280,204), "sizeof(S85C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C28)");
    check_field_offset(lv, s85c28f0, 0, "S85C28.s85c28f0");
    check_field_offset(lv, s85c28f1, ABISELECT(8,4), "S85C28.s85c28f1");
    check_field_offset(lv, s85c28f2, ABISELECT(24,16), "S85C28.s85c28f2");
    check_field_offset(lv, s85c28f3, ABISELECT(40,28), "S85C28.s85c28f3");
    check_field_offset(lv, s85c28f4, ABISELECT(56,40), "S85C28.s85c28f4");
    check_field_offset(lv, s85c28f5, ABISELECT(72,52), "S85C28.s85c28f5");
    check_field_offset(lv, s85c28f6, ABISELECT(88,64), "S85C28.s85c28f6");
    check_field_offset(lv, s85c28f7, ABISELECT(104,76), "S85C28.s85c28f7");
    check_field_offset(lv, s85c28f8, ABISELECT(120,88), "S85C28.s85c28f8");
    check_field_offset(lv, s85c28f9, ABISELECT(136,100), "S85C28.s85c28f9");
    check_field_offset(lv, s85c28f10, ABISELECT(144,104), "S85C28.s85c28f10");
    check_field_offset(lv, s85c28f11, ABISELECT(160,116), "S85C28.s85c28f11");
    check_field_offset(lv, s85c28f12, ABISELECT(168,124), "S85C28.s85c28f12");
    check_field_offset(lv, s85c28f13, ABISELECT(176,132), "S85C28.s85c28f13");
    check_field_offset(lv, s85c28f14, ABISELECT(184,136), "S85C28.s85c28f14");
    set_bf_and_test(lv, s85c28f15, ABISELECT(192,140), 0, 1, 1, "S85C28");
    check_field_offset(lv, s85c28f16, ABISELECT(196,144), "S85C28.s85c28f16");
    check_field_offset(lv, s85c28f17, ABISELECT(216,160), "S85C28.s85c28f17");
    check_field_offset(lv, s85c28f18, ABISELECT(232,172), "S85C28.s85c28f18");
    check_field_offset(lv, s85c28f19, ABISELECT(240,176), "S85C28.s85c28f19");
    check_field_offset(lv, s85c28f20, ABISELECT(256,188), "S85C28.s85c28f20");
    check_field_offset(lv, s85c28f21, ABISELECT(272,200), "S85C28.s85c28f21");
  }
}
static Arrange_To_Call_Me vS85C28(Test_S85C28, "S85C28", ABISELECT(280,204));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S85C1  : S85C2 {
  void *s85c1f0[19];
  ::S85C28 s85c1f1;
  unsigned int s85c1f2:1;
  int s85c1f3[2];
  void *s85c1f4[2];
  virtual  ~S85C1(); // _ZN5S85C1D1Ev
  virtual void  v1(); // _ZN5S85C12v1Ev
  virtual void  v2(); // _ZN5S85C12v2Ev
  virtual void  v3(); // _ZN5S85C12v3Ev
  S85C1(); // tgen
};
//SIG(1 S85C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC8} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 FC8 Fp[9] FC22{ BC23{ BC12}} FC10 FC24{ BC25{ m FC26{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC27{ m Fi[2]} FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v208 v209} vd v1 v2 v3 Fp[19] FC28{ m Fi FC29{ BC13} FC29 FC29 FC29 FC22 FC22 FC22 FC22 Fc FC29 FC8 FC8 Fi Fp Fi:1 FC30{ m Fi[4]} FC29 Fp FC29 FC31{ BC32{ BC12}} Fp} Fi:1 Fi[2] Fp[2]}


 S85C1 ::~S85C1(){ note_dtor("S85C1", this);}
void  S85C1 ::v1(){vfunc_called(this, "_ZN5S85C12v1Ev");}
void  S85C1 ::v2(){vfunc_called(this, "_ZN5S85C12v2Ev");}
void  S85C1 ::v3(){vfunc_called(this, "_ZN5S85C12v3Ev");}
S85C1 ::S85C1(){ note_ctor("S85C1", this);} // tgen

static void Test_S85C1()
{
  extern Class_Descriptor cd_S85C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(167,230)];
    init_test(&cd_S85C1, buf);
    S85C1 *dp, &lv = *(dp=new (buf) S85C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1328,916), "sizeof(S85C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S85C1)");
    check_base_class_offset(lv, (S85C7*)(S85C6*)(S85C5*)(S85C4*)(S85C3*)(S85C2*), 0, "S85C1");
    check_base_class_offset(lv, (S85C6*)(S85C5*)(S85C4*)(S85C3*)(S85C2*), 0, "S85C1");
    check_base_class_offset(lv, (S85C5*)(S85C4*)(S85C3*)(S85C2*), 0, "S85C1");
    check_base_class_offset(lv, (S85C4*)(S85C3*)(S85C2*), 0, "S85C1");
    check_base_class_offset(lv, (S85C3*)(S85C2*), 0, "S85C1");
    check_base_class_offset(lv, (S85C2*), 0, "S85C1");
    check_field_offset(lv, s85c1f0, ABISELECT(864,616), "S85C1.s85c1f0");
    check_field_offset(lv, s85c1f1, ABISELECT(1016,692), "S85C1.s85c1f1");
    set_bf_and_test(lv, s85c1f2, ABISELECT(1296,896), 0, 1, 1, "S85C1");
    check_field_offset(lv, s85c1f3, ABISELECT(1300,900), "S85C1.s85c1f3");
    check_field_offset(lv, s85c1f4, ABISELECT(1312,908), "S85C1.s85c1f4");
    test_class_info(&lv, &cd_S85C1);
    dp->~S85C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS85C1(Test_S85C1, "S85C1", ABISELECT(1328,916));

#else // __cplusplus

extern void _ZN5S85C1C1Ev();
extern void _ZN5S85C1D1Ev();
Name_Map name_map_S85C1[] = {
  NSPAIR(_ZN5S85C1C1Ev),
  NSPAIR(_ZN5S85C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S85C7;
extern VTBL_ENTRY _ZTI5S85C7[];
extern  VTBL_ENTRY _ZTV5S85C7[];
extern Class_Descriptor cd_S85C6;
extern VTBL_ENTRY _ZTI5S85C6[];
extern  VTBL_ENTRY _ZTV5S85C6[];
extern Class_Descriptor cd_S85C5;
extern VTBL_ENTRY _ZTI5S85C5[];
extern  VTBL_ENTRY _ZTV5S85C5[];
extern Class_Descriptor cd_S85C4;
extern VTBL_ENTRY _ZTI5S85C4[];
extern  VTBL_ENTRY _ZTV5S85C4[];
extern Class_Descriptor cd_S85C3;
extern VTBL_ENTRY _ZTI5S85C3[];
extern  VTBL_ENTRY _ZTV5S85C3[];
extern Class_Descriptor cd_S85C2;
extern VTBL_ENTRY _ZTI5S85C2[];
extern  VTBL_ENTRY _ZTV5S85C2[];
static Base_Class bases_S85C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S85C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S85C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S85C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S85C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S85C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S85C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S85C1[];
extern void _ZN5S85C1D1Ev();
extern void _ZN5S85C1D0Ev();
extern void _ZN5S85C72v4Ev();
extern void _ZN5S85C72v5Ev();
extern void _ZN5S85C72v6Ev();
extern void _ZN5S85C72v7Ev();
extern void _ZN5S85C72v8Ev();
extern void _ZN5S85C72v9Ev();
extern void _ZN5S85C73v10Ev();
extern void _ZN5S85C73v11Ev();
extern void _ZN5S85C73v12Ev();
extern void _ZN5S85C73v13Ev();
extern void _ZN5S85C73v14Ev();
extern void _ZN5S85C73v15Ev();
extern void _ZN5S85C73v16Ev();
extern void _ZN5S85C73v17Ev();
extern void _ZN5S85C73v18Ev();
extern void _ZN5S85C73v19Ev();
extern void _ZN5S85C73v20Ev();
extern void _ZN5S85C73v21Ev();
extern void _ZN5S85C73v22Ev();
extern void _ZN5S85C73v23Ev();
extern void _ZN5S85C73v24Ev();
extern void _ZN5S85C73v25Ev();
extern void _ZN5S85C73v26Ev();
extern void _ZN5S85C73v27Ev();
extern void _ZN5S85C73v28Ev();
extern void _ZN5S85C73v29Ev();
extern void _ZN5S85C73v30Ev();
extern void _ZN5S85C73v31Ev();
extern void _ZN5S85C73v32Ev();
extern void _ZN5S85C73v33Ev();
extern void _ZN5S85C73v34Ev();
extern void _ZN5S85C73v35Ev();
extern void _ZN5S85C73v36Ev();
extern void _ZN5S85C73v37Ev();
extern void _ZN5S85C73v38Ev();
extern void _ZN5S85C73v39Ev();
extern void _ZN5S85C73v40Ev();
extern void _ZN5S85C73v41Ev();
extern void _ZN5S85C73v42Ev();
extern void _ZN5S85C73v43Ev();
extern void _ZN5S85C73v44Ev();
extern void _ZN5S85C73v45Ev();
extern void _ZN5S85C73v46Ev();
extern void _ZN5S85C73v47Ev();
extern void _ZN5S85C73v48Ev();
extern void _ZN5S85C73v49Ev();
extern void _ZN5S85C73v50Ev();
extern void _ZN5S85C73v51Ev();
extern void _ZN5S85C73v52Ev();
extern void _ZN5S85C73v53Ev();
extern void _ZN5S85C73v54Ev();
extern void _ZN5S85C73v55Ev();
extern void _ZN5S85C73v56Ev();
extern void _ZN5S85C73v57Ev();
extern void _ZN5S85C73v58Ev();
extern void _ZN5S85C73v59Ev();
extern void _ZN5S85C73v60Ev();
extern void _ZN5S85C73v61Ev();
extern void _ZN5S85C73v62Ev();
extern void _ZN5S85C73v63Ev();
extern void _ZN5S85C73v64Ev();
extern void _ZN5S85C73v65Ev();
extern void _ZN5S85C73v66Ev();
extern void _ZN5S85C73v67Ev();
extern void _ZN5S85C63v68Ev();
extern void _ZN5S85C63v69Ev();
extern void _ZN5S85C53v70Ev();
extern void _ZN5S85C53v71Ev();
extern void _ZN5S85C53v72Ev();
extern void _ZN5S85C53v73Ev();
extern void _ZN5S85C53v74Ev();
extern void _ZN5S85C53v75Ev();
extern void _ZN5S85C53v76Ev();
extern void _ZN5S85C53v77Ev();
extern void _ZN5S85C53v78Ev();
extern void _ZN5S85C53v79Ev();
extern void _ZN5S85C53v80Ev();
extern void _ZN5S85C53v81Ev();
extern void _ZN5S85C53v82Ev();
extern void _ZN5S85C53v83Ev();
extern void _ZN5S85C53v84Ev();
extern void _ZN5S85C53v85Ev();
extern void _ZN5S85C53v86Ev();
extern void _ZN5S85C53v87Ev();
extern void _ZN5S85C53v88Ev();
extern void _ZN5S85C53v89Ev();
extern void _ZN5S85C53v90Ev();
extern void _ZN5S85C53v91Ev();
extern void _ZN5S85C53v92Ev();
extern void _ZN5S85C53v93Ev();
extern void _ZN5S85C53v94Ev();
extern void _ZN5S85C53v95Ev();
extern void _ZN5S85C53v96Ev();
extern void _ZN5S85C53v97Ev();
extern void _ZN5S85C53v98Ev();
extern void _ZN5S85C53v99Ev();
extern void _ZN5S85C54v100Ev();
extern void _ZN5S85C54v101Ev();
extern void _ZN5S85C54v102Ev();
extern void _ZN5S85C54v103Ev();
extern void _ZN5S85C54v104Ev();
extern void _ZN5S85C54v105Ev();
extern void _ZN5S85C54v106Ev();
extern void _ZN5S85C54v107Ev();
extern void _ZN5S85C54v108Ev();
extern void _ZN5S85C54v109Ev();
extern void _ZN5S85C54v110Ev();
extern void _ZN5S85C54v111Ev();
extern void _ZN5S85C54v112Ev();
extern void _ZN5S85C54v113Ev();
extern void _ZN5S85C54v114Ev();
extern void _ZN5S85C54v115Ev();
extern void _ZN5S85C54v116Ev();
extern void _ZN5S85C54v117Ev();
extern void _ZN5S85C54v118Ev();
extern void _ZN5S85C54v119Ev();
extern void _ZN5S85C54v120Ev();
extern void _ZN5S85C54v121Ev();
extern void _ZN5S85C54v122Ev();
extern void _ZN5S85C54v123Ev();
extern void _ZN5S85C54v124Ev();
extern void _ZN5S85C54v125Ev();
extern void _ZN5S85C54v126Ev();
extern void _ZN5S85C54v127Ev();
extern void _ZN5S85C54v128Ev();
extern void _ZN5S85C54v129Ev();
extern void _ZN5S85C54v130Ev();
extern void _ZN5S85C54v131Ev();
extern void _ZN5S85C54v132Ev();
extern void _ZN5S85C54v133Ev();
extern void _ZN5S85C54v134Ev();
extern void _ZN5S85C54v135Ev();
extern void _ZN5S85C54v136Ev();
extern void _ZN5S85C54v137Ev();
extern void _ZN5S85C54v138Ev();
extern void _ZN5S85C54v139Ev();
extern void _ZN5S85C54v140Ev();
extern void _ZN5S85C54v141Ev();
extern void _ZN5S85C54v142Ev();
extern void _ZN5S85C54v143Ev();
extern void _ZN5S85C54v144Ev();
extern void _ZN5S85C54v145Ev();
extern void _ZN5S85C44v146Ev();
extern void _ZN5S85C44v147Ev();
extern void _ZN5S85C44v148Ev();
extern void _ZN5S85C44v149Ev();
extern void _ZN5S85C44v150Ev();
extern void _ZN5S85C44v151Ev();
extern void _ZN5S85C44v152Ev();
extern void _ZN5S85C44v153Ev();
extern void _ZN5S85C44v154Ev();
extern void _ZN5S85C44v155Ev();
extern void _ZN5S85C44v156Ev();
extern void _ZN5S85C44v157Ev();
extern void _ZN5S85C44v158Ev();
extern void _ZN5S85C44v159Ev();
extern void _ZN5S85C44v160Ev();
extern void _ZN5S85C44v161Ev();
extern void _ZN5S85C44v162Ev();
extern void _ZN5S85C44v163Ev();
extern void _ZN5S85C44v164Ev();
extern void _ZN5S85C44v165Ev();
extern void _ZN5S85C44v166Ev();
extern void _ZN5S85C44v167Ev();
extern void _ZN5S85C44v168Ev();
extern void _ZN5S85C44v169Ev();
extern void _ZN5S85C44v170Ev();
extern void _ZN5S85C44v171Ev();
extern void _ZN5S85C44v172Ev();
extern void _ZN5S85C44v173Ev();
extern void _ZN5S85C44v174Ev();
extern void _ZN5S85C44v175Ev();
extern void _ZN5S85C44v176Ev();
extern void _ZN5S85C44v177Ev();
extern void _ZN5S85C44v178Ev();
extern void _ZN5S85C44v179Ev();
extern void _ZN5S85C44v180Ev();
extern void _ZN5S85C44v181Ev();
extern void _ZN5S85C44v182Ev();
extern void _ZN5S85C44v183Ev();
extern void _ZN5S85C44v184Ev();
extern void _ZN5S85C34v185Ev();
extern void _ZN5S85C34v186Ev();
extern void _ZN5S85C34v187Ev();
extern void _ZN5S85C34v188Ev();
extern void _ZN5S85C34v189Ev();
extern void _ZN5S85C34v190Ev();
extern void _ZN5S85C34v191Ev();
extern void _ZN5S85C34v192Ev();
extern void _ZN5S85C34v193Ev();
extern void _ZN5S85C34v194Ev();
extern void _ZN5S85C34v195Ev();
extern void _ZN5S85C34v196Ev();
extern void _ZN5S85C34v197Ev();
extern void _ZN5S85C34v198Ev();
extern void _ZN5S85C34v199Ev();
extern void _ZN5S85C34v200Ev();
extern void _ZN5S85C34v201Ev();
extern void _ZN5S85C34v202Ev();
extern void _ZN5S85C34v203Ev();
extern void _ZN5S85C34v204Ev();
extern void _ZN5S85C34v205Ev();
extern void _ZN5S85C34v206Ev();
extern void _ZN5S85C34v207Ev();
extern void _ZN5S85C24v208Ev();
extern void _ZN5S85C24v209Ev();
extern void _ZN5S85C12v1Ev();
extern void _ZN5S85C12v2Ev();
extern void _ZN5S85C12v3Ev();
static  VTBL_ENTRY vtc_S85C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S85C1[0]),
  (VTBL_ENTRY)&_ZN5S85C1D1Ev,
  (VTBL_ENTRY)&_ZN5S85C1D0Ev,
  (VTBL_ENTRY)&_ZN5S85C72v4Ev,
  (VTBL_ENTRY)&_ZN5S85C72v5Ev,
  (VTBL_ENTRY)&_ZN5S85C72v6Ev,
  (VTBL_ENTRY)&_ZN5S85C72v7Ev,
  (VTBL_ENTRY)&_ZN5S85C72v8Ev,
  (VTBL_ENTRY)&_ZN5S85C72v9Ev,
  (VTBL_ENTRY)&_ZN5S85C73v10Ev,
  (VTBL_ENTRY)&_ZN5S85C73v11Ev,
  (VTBL_ENTRY)&_ZN5S85C73v12Ev,
  (VTBL_ENTRY)&_ZN5S85C73v13Ev,
  (VTBL_ENTRY)&_ZN5S85C73v14Ev,
  (VTBL_ENTRY)&_ZN5S85C73v15Ev,
  (VTBL_ENTRY)&_ZN5S85C73v16Ev,
  (VTBL_ENTRY)&_ZN5S85C73v17Ev,
  (VTBL_ENTRY)&_ZN5S85C73v18Ev,
  (VTBL_ENTRY)&_ZN5S85C73v19Ev,
  (VTBL_ENTRY)&_ZN5S85C73v20Ev,
  (VTBL_ENTRY)&_ZN5S85C73v21Ev,
  (VTBL_ENTRY)&_ZN5S85C73v22Ev,
  (VTBL_ENTRY)&_ZN5S85C73v23Ev,
  (VTBL_ENTRY)&_ZN5S85C73v24Ev,
  (VTBL_ENTRY)&_ZN5S85C73v25Ev,
  (VTBL_ENTRY)&_ZN5S85C73v26Ev,
  (VTBL_ENTRY)&_ZN5S85C73v27Ev,
  (VTBL_ENTRY)&_ZN5S85C73v28Ev,
  (VTBL_ENTRY)&_ZN5S85C73v29Ev,
  (VTBL_ENTRY)&_ZN5S85C73v30Ev,
  (VTBL_ENTRY)&_ZN5S85C73v31Ev,
  (VTBL_ENTRY)&_ZN5S85C73v32Ev,
  (VTBL_ENTRY)&_ZN5S85C73v33Ev,
  (VTBL_ENTRY)&_ZN5S85C73v34Ev,
  (VTBL_ENTRY)&_ZN5S85C73v35Ev,
  (VTBL_ENTRY)&_ZN5S85C73v36Ev,
  (VTBL_ENTRY)&_ZN5S85C73v37Ev,
  (VTBL_ENTRY)&_ZN5S85C73v38Ev,
  (VTBL_ENTRY)&_ZN5S85C73v39Ev,
  (VTBL_ENTRY)&_ZN5S85C73v40Ev,
  (VTBL_ENTRY)&_ZN5S85C73v41Ev,
  (VTBL_ENTRY)&_ZN5S85C73v42Ev,
  (VTBL_ENTRY)&_ZN5S85C73v43Ev,
  (VTBL_ENTRY)&_ZN5S85C73v44Ev,
  (VTBL_ENTRY)&_ZN5S85C73v45Ev,
  (VTBL_ENTRY)&_ZN5S85C73v46Ev,
  (VTBL_ENTRY)&_ZN5S85C73v47Ev,
  (VTBL_ENTRY)&_ZN5S85C73v48Ev,
  (VTBL_ENTRY)&_ZN5S85C73v49Ev,
  (VTBL_ENTRY)&_ZN5S85C73v50Ev,
  (VTBL_ENTRY)&_ZN5S85C73v51Ev,
  (VTBL_ENTRY)&_ZN5S85C73v52Ev,
  (VTBL_ENTRY)&_ZN5S85C73v53Ev,
  (VTBL_ENTRY)&_ZN5S85C73v54Ev,
  (VTBL_ENTRY)&_ZN5S85C73v55Ev,
  (VTBL_ENTRY)&_ZN5S85C73v56Ev,
  (VTBL_ENTRY)&_ZN5S85C73v57Ev,
  (VTBL_ENTRY)&_ZN5S85C73v58Ev,
  (VTBL_ENTRY)&_ZN5S85C73v59Ev,
  (VTBL_ENTRY)&_ZN5S85C73v60Ev,
  (VTBL_ENTRY)&_ZN5S85C73v61Ev,
  (VTBL_ENTRY)&_ZN5S85C73v62Ev,
  (VTBL_ENTRY)&_ZN5S85C73v63Ev,
  (VTBL_ENTRY)&_ZN5S85C73v64Ev,
  (VTBL_ENTRY)&_ZN5S85C73v65Ev,
  (VTBL_ENTRY)&_ZN5S85C73v66Ev,
  (VTBL_ENTRY)&_ZN5S85C73v67Ev,
  (VTBL_ENTRY)&_ZN5S85C63v68Ev,
  (VTBL_ENTRY)&_ZN5S85C63v69Ev,
  (VTBL_ENTRY)&_ZN5S85C53v70Ev,
  (VTBL_ENTRY)&_ZN5S85C53v71Ev,
  (VTBL_ENTRY)&_ZN5S85C53v72Ev,
  (VTBL_ENTRY)&_ZN5S85C53v73Ev,
  (VTBL_ENTRY)&_ZN5S85C53v74Ev,
  (VTBL_ENTRY)&_ZN5S85C53v75Ev,
  (VTBL_ENTRY)&_ZN5S85C53v76Ev,
  (VTBL_ENTRY)&_ZN5S85C53v77Ev,
  (VTBL_ENTRY)&_ZN5S85C53v78Ev,
  (VTBL_ENTRY)&_ZN5S85C53v79Ev,
  (VTBL_ENTRY)&_ZN5S85C53v80Ev,
  (VTBL_ENTRY)&_ZN5S85C53v81Ev,
  (VTBL_ENTRY)&_ZN5S85C53v82Ev,
  (VTBL_ENTRY)&_ZN5S85C53v83Ev,
  (VTBL_ENTRY)&_ZN5S85C53v84Ev,
  (VTBL_ENTRY)&_ZN5S85C53v85Ev,
  (VTBL_ENTRY)&_ZN5S85C53v86Ev,
  (VTBL_ENTRY)&_ZN5S85C53v87Ev,
  (VTBL_ENTRY)&_ZN5S85C53v88Ev,
  (VTBL_ENTRY)&_ZN5S85C53v89Ev,
  (VTBL_ENTRY)&_ZN5S85C53v90Ev,
  (VTBL_ENTRY)&_ZN5S85C53v91Ev,
  (VTBL_ENTRY)&_ZN5S85C53v92Ev,
  (VTBL_ENTRY)&_ZN5S85C53v93Ev,
  (VTBL_ENTRY)&_ZN5S85C53v94Ev,
  (VTBL_ENTRY)&_ZN5S85C53v95Ev,
  (VTBL_ENTRY)&_ZN5S85C53v96Ev,
  (VTBL_ENTRY)&_ZN5S85C53v97Ev,
  (VTBL_ENTRY)&_ZN5S85C53v98Ev,
  (VTBL_ENTRY)&_ZN5S85C53v99Ev,
  (VTBL_ENTRY)&_ZN5S85C54v100Ev,
  (VTBL_ENTRY)&_ZN5S85C54v101Ev,
  (VTBL_ENTRY)&_ZN5S85C54v102Ev,
  (VTBL_ENTRY)&_ZN5S85C54v103Ev,
  (VTBL_ENTRY)&_ZN5S85C54v104Ev,
  (VTBL_ENTRY)&_ZN5S85C54v105Ev,
  (VTBL_ENTRY)&_ZN5S85C54v106Ev,
  (VTBL_ENTRY)&_ZN5S85C54v107Ev,
  (VTBL_ENTRY)&_ZN5S85C54v108Ev,
  (VTBL_ENTRY)&_ZN5S85C54v109Ev,
  (VTBL_ENTRY)&_ZN5S85C54v110Ev,
  (VTBL_ENTRY)&_ZN5S85C54v111Ev,
  (VTBL_ENTRY)&_ZN5S85C54v112Ev,
  (VTBL_ENTRY)&_ZN5S85C54v113Ev,
  (VTBL_ENTRY)&_ZN5S85C54v114Ev,
  (VTBL_ENTRY)&_ZN5S85C54v115Ev,
  (VTBL_ENTRY)&_ZN5S85C54v116Ev,
  (VTBL_ENTRY)&_ZN5S85C54v117Ev,
  (VTBL_ENTRY)&_ZN5S85C54v118Ev,
  (VTBL_ENTRY)&_ZN5S85C54v119Ev,
  (VTBL_ENTRY)&_ZN5S85C54v120Ev,
  (VTBL_ENTRY)&_ZN5S85C54v121Ev,
  (VTBL_ENTRY)&_ZN5S85C54v122Ev,
  (VTBL_ENTRY)&_ZN5S85C54v123Ev,
  (VTBL_ENTRY)&_ZN5S85C54v124Ev,
  (VTBL_ENTRY)&_ZN5S85C54v125Ev,
  (VTBL_ENTRY)&_ZN5S85C54v126Ev,
  (VTBL_ENTRY)&_ZN5S85C54v127Ev,
  (VTBL_ENTRY)&_ZN5S85C54v128Ev,
  (VTBL_ENTRY)&_ZN5S85C54v129Ev,
  (VTBL_ENTRY)&_ZN5S85C54v130Ev,
  (VTBL_ENTRY)&_ZN5S85C54v131Ev,
  (VTBL_ENTRY)&_ZN5S85C54v132Ev,
  (VTBL_ENTRY)&_ZN5S85C54v133Ev,
  (VTBL_ENTRY)&_ZN5S85C54v134Ev,
  (VTBL_ENTRY)&_ZN5S85C54v135Ev,
  (VTBL_ENTRY)&_ZN5S85C54v136Ev,
  (VTBL_ENTRY)&_ZN5S85C54v137Ev,
  (VTBL_ENTRY)&_ZN5S85C54v138Ev,
  (VTBL_ENTRY)&_ZN5S85C54v139Ev,
  (VTBL_ENTRY)&_ZN5S85C54v140Ev,
  (VTBL_ENTRY)&_ZN5S85C54v141Ev,
  (VTBL_ENTRY)&_ZN5S85C54v142Ev,
  (VTBL_ENTRY)&_ZN5S85C54v143Ev,
  (VTBL_ENTRY)&_ZN5S85C54v144Ev,
  (VTBL_ENTRY)&_ZN5S85C54v145Ev,
  (VTBL_ENTRY)&_ZN5S85C44v146Ev,
  (VTBL_ENTRY)&_ZN5S85C44v147Ev,
  (VTBL_ENTRY)&_ZN5S85C44v148Ev,
  (VTBL_ENTRY)&_ZN5S85C44v149Ev,
  (VTBL_ENTRY)&_ZN5S85C44v150Ev,
  (VTBL_ENTRY)&_ZN5S85C44v151Ev,
  (VTBL_ENTRY)&_ZN5S85C44v152Ev,
  (VTBL_ENTRY)&_ZN5S85C44v153Ev,
  (VTBL_ENTRY)&_ZN5S85C44v154Ev,
  (VTBL_ENTRY)&_ZN5S85C44v155Ev,
  (VTBL_ENTRY)&_ZN5S85C44v156Ev,
  (VTBL_ENTRY)&_ZN5S85C44v157Ev,
  (VTBL_ENTRY)&_ZN5S85C44v158Ev,
  (VTBL_ENTRY)&_ZN5S85C44v159Ev,
  (VTBL_ENTRY)&_ZN5S85C44v160Ev,
  (VTBL_ENTRY)&_ZN5S85C44v161Ev,
  (VTBL_ENTRY)&_ZN5S85C44v162Ev,
  (VTBL_ENTRY)&_ZN5S85C44v163Ev,
  (VTBL_ENTRY)&_ZN5S85C44v164Ev,
  (VTBL_ENTRY)&_ZN5S85C44v165Ev,
  (VTBL_ENTRY)&_ZN5S85C44v166Ev,
  (VTBL_ENTRY)&_ZN5S85C44v167Ev,
  (VTBL_ENTRY)&_ZN5S85C44v168Ev,
  (VTBL_ENTRY)&_ZN5S85C44v169Ev,
  (VTBL_ENTRY)&_ZN5S85C44v170Ev,
  (VTBL_ENTRY)&_ZN5S85C44v171Ev,
  (VTBL_ENTRY)&_ZN5S85C44v172Ev,
  (VTBL_ENTRY)&_ZN5S85C44v173Ev,
  (VTBL_ENTRY)&_ZN5S85C44v174Ev,
  (VTBL_ENTRY)&_ZN5S85C44v175Ev,
  (VTBL_ENTRY)&_ZN5S85C44v176Ev,
  (VTBL_ENTRY)&_ZN5S85C44v177Ev,
  (VTBL_ENTRY)&_ZN5S85C44v178Ev,
  (VTBL_ENTRY)&_ZN5S85C44v179Ev,
  (VTBL_ENTRY)&_ZN5S85C44v180Ev,
  (VTBL_ENTRY)&_ZN5S85C44v181Ev,
  (VTBL_ENTRY)&_ZN5S85C44v182Ev,
  (VTBL_ENTRY)&_ZN5S85C44v183Ev,
  (VTBL_ENTRY)&_ZN5S85C44v184Ev,
  (VTBL_ENTRY)&_ZN5S85C34v185Ev,
  (VTBL_ENTRY)&_ZN5S85C34v186Ev,
  (VTBL_ENTRY)&_ZN5S85C34v187Ev,
  (VTBL_ENTRY)&_ZN5S85C34v188Ev,
  (VTBL_ENTRY)&_ZN5S85C34v189Ev,
  (VTBL_ENTRY)&_ZN5S85C34v190Ev,
  (VTBL_ENTRY)&_ZN5S85C34v191Ev,
  (VTBL_ENTRY)&_ZN5S85C34v192Ev,
  (VTBL_ENTRY)&_ZN5S85C34v193Ev,
  (VTBL_ENTRY)&_ZN5S85C34v194Ev,
  (VTBL_ENTRY)&_ZN5S85C34v195Ev,
  (VTBL_ENTRY)&_ZN5S85C34v196Ev,
  (VTBL_ENTRY)&_ZN5S85C34v197Ev,
  (VTBL_ENTRY)&_ZN5S85C34v198Ev,
  (VTBL_ENTRY)&_ZN5S85C34v199Ev,
  (VTBL_ENTRY)&_ZN5S85C34v200Ev,
  (VTBL_ENTRY)&_ZN5S85C34v201Ev,
  (VTBL_ENTRY)&_ZN5S85C34v202Ev,
  (VTBL_ENTRY)&_ZN5S85C34v203Ev,
  (VTBL_ENTRY)&_ZN5S85C34v204Ev,
  (VTBL_ENTRY)&_ZN5S85C34v205Ev,
  (VTBL_ENTRY)&_ZN5S85C34v206Ev,
  (VTBL_ENTRY)&_ZN5S85C34v207Ev,
  (VTBL_ENTRY)&_ZN5S85C24v208Ev,
  (VTBL_ENTRY)&_ZN5S85C24v209Ev,
  (VTBL_ENTRY)&_ZN5S85C12v1Ev,
  (VTBL_ENTRY)&_ZN5S85C12v2Ev,
  (VTBL_ENTRY)&_ZN5S85C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S85C1[];
extern  VTBL_ENTRY _ZTV5S85C1[];
Class_Descriptor cd_S85C1 = {  "S85C1", // class name
  bases_S85C1, 6,
  &(vtc_S85C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1328,916), // object size
  NSPAIRA(_ZTI5S85C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S85C1),213, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C8  {
  int s37c8f0;
  __tsi64 s37c8f1;
  void *s37c8f2[4];
  int s37c8f3[2];
  void *s37c8f4;
  ::S85C27_nt s37c8f5;
  void *s37c8f6[2];
  virtual  ~S37C8(); // _ZN5S37C8D1Ev
  virtual void  v4(); // _ZN5S37C82v4Ev
  virtual void  v5(); // _ZN5S37C82v5Ev
  virtual void  v6(); // _ZN5S37C82v6Ev
  virtual void  v7(); // _ZN5S37C82v7Ev
  virtual void  v8(); // _ZN5S37C82v8Ev
  virtual void  v9(); // _ZN5S37C82v9Ev
  virtual void  v10(); // _ZN5S37C83v10Ev
  virtual void  v11(); // _ZN5S37C83v11Ev
  virtual void  v12(); // _ZN5S37C83v12Ev
  virtual void  v13(); // _ZN5S37C83v13Ev
  virtual void  v14(); // _ZN5S37C83v14Ev
  virtual void  v15(); // _ZN5S37C83v15Ev
  virtual void  v16(); // _ZN5S37C83v16Ev
  virtual void  v17(); // _ZN5S37C83v17Ev
  virtual void  v18(); // _ZN5S37C83v18Ev
  virtual void  v19(); // _ZN5S37C83v19Ev
  virtual void  v20(); // _ZN5S37C83v20Ev
  virtual void  v21(); // _ZN5S37C83v21Ev
  virtual void  v22(); // _ZN5S37C83v22Ev
  virtual void  v23(); // _ZN5S37C83v23Ev
  virtual void  v24(); // _ZN5S37C83v24Ev
  virtual void  v25(); // _ZN5S37C83v25Ev
  virtual void  v26(); // _ZN5S37C83v26Ev
  virtual void  v27(); // _ZN5S37C83v27Ev
  virtual void  v28(); // _ZN5S37C83v28Ev
  virtual void  v29(); // _ZN5S37C83v29Ev
  virtual void  v30(); // _ZN5S37C83v30Ev
  virtual void  v31(); // _ZN5S37C83v31Ev
  virtual void  v32(); // _ZN5S37C83v32Ev
  virtual void  v33(); // _ZN5S37C83v33Ev
  virtual void  v34(); // _ZN5S37C83v34Ev
  virtual void  v35(); // _ZN5S37C83v35Ev
  virtual void  v36(); // _ZN5S37C83v36Ev
  virtual void  v37(); // _ZN5S37C83v37Ev
  virtual void  v38(); // _ZN5S37C83v38Ev
  virtual void  v39(); // _ZN5S37C83v39Ev
  virtual void  v40(); // _ZN5S37C83v40Ev
  virtual void  v41(); // _ZN5S37C83v41Ev
  virtual void  v42(); // _ZN5S37C83v42Ev
  virtual void  v43(); // _ZN5S37C83v43Ev
  virtual void  v44(); // _ZN5S37C83v44Ev
  virtual void  v45(); // _ZN5S37C83v45Ev
  virtual void  v46(); // _ZN5S37C83v46Ev
  virtual void  v47(); // _ZN5S37C83v47Ev
  virtual void  v48(); // _ZN5S37C83v48Ev
  virtual void  v49(); // _ZN5S37C83v49Ev
  virtual void  v50(); // _ZN5S37C83v50Ev
  virtual void  v51(); // _ZN5S37C83v51Ev
  virtual void  v52(); // _ZN5S37C83v52Ev
  virtual void  v53(); // _ZN5S37C83v53Ev
  virtual void  v54(); // _ZN5S37C83v54Ev
  virtual void  v55(); // _ZN5S37C83v55Ev
  virtual void  v56(); // _ZN5S37C83v56Ev
  virtual void  v57(); // _ZN5S37C83v57Ev
  virtual void  v58(); // _ZN5S37C83v58Ev
  virtual void  v59(); // _ZN5S37C83v59Ev
  virtual void  v60(); // _ZN5S37C83v60Ev
  virtual void  v61(); // _ZN5S37C83v61Ev
  virtual void  v62(); // _ZN5S37C83v62Ev
  virtual void  v63(); // _ZN5S37C83v63Ev
  virtual void  v64(); // _ZN5S37C83v64Ev
  virtual void  v65(); // _ZN5S37C83v65Ev
  virtual void  v66(); // _ZN5S37C83v66Ev
  virtual void  v67(); // _ZN5S37C83v67Ev
  S37C8(); // tgen
};
//SIG(-1 S37C8) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S37C8 ::~S37C8(){ note_dtor("S37C8", this);}
void  S37C8 ::v4(){vfunc_called(this, "_ZN5S37C82v4Ev");}
void  S37C8 ::v5(){vfunc_called(this, "_ZN5S37C82v5Ev");}
void  S37C8 ::v6(){vfunc_called(this, "_ZN5S37C82v6Ev");}
void  S37C8 ::v7(){vfunc_called(this, "_ZN5S37C82v7Ev");}
void  S37C8 ::v8(){vfunc_called(this, "_ZN5S37C82v8Ev");}
void  S37C8 ::v9(){vfunc_called(this, "_ZN5S37C82v9Ev");}
void  S37C8 ::v10(){vfunc_called(this, "_ZN5S37C83v10Ev");}
void  S37C8 ::v11(){vfunc_called(this, "_ZN5S37C83v11Ev");}
void  S37C8 ::v12(){vfunc_called(this, "_ZN5S37C83v12Ev");}
void  S37C8 ::v13(){vfunc_called(this, "_ZN5S37C83v13Ev");}
void  S37C8 ::v14(){vfunc_called(this, "_ZN5S37C83v14Ev");}
void  S37C8 ::v15(){vfunc_called(this, "_ZN5S37C83v15Ev");}
void  S37C8 ::v16(){vfunc_called(this, "_ZN5S37C83v16Ev");}
void  S37C8 ::v17(){vfunc_called(this, "_ZN5S37C83v17Ev");}
void  S37C8 ::v18(){vfunc_called(this, "_ZN5S37C83v18Ev");}
void  S37C8 ::v19(){vfunc_called(this, "_ZN5S37C83v19Ev");}
void  S37C8 ::v20(){vfunc_called(this, "_ZN5S37C83v20Ev");}
void  S37C8 ::v21(){vfunc_called(this, "_ZN5S37C83v21Ev");}
void  S37C8 ::v22(){vfunc_called(this, "_ZN5S37C83v22Ev");}
void  S37C8 ::v23(){vfunc_called(this, "_ZN5S37C83v23Ev");}
void  S37C8 ::v24(){vfunc_called(this, "_ZN5S37C83v24Ev");}
void  S37C8 ::v25(){vfunc_called(this, "_ZN5S37C83v25Ev");}
void  S37C8 ::v26(){vfunc_called(this, "_ZN5S37C83v26Ev");}
void  S37C8 ::v27(){vfunc_called(this, "_ZN5S37C83v27Ev");}
void  S37C8 ::v28(){vfunc_called(this, "_ZN5S37C83v28Ev");}
void  S37C8 ::v29(){vfunc_called(this, "_ZN5S37C83v29Ev");}
void  S37C8 ::v30(){vfunc_called(this, "_ZN5S37C83v30Ev");}
void  S37C8 ::v31(){vfunc_called(this, "_ZN5S37C83v31Ev");}
void  S37C8 ::v32(){vfunc_called(this, "_ZN5S37C83v32Ev");}
void  S37C8 ::v33(){vfunc_called(this, "_ZN5S37C83v33Ev");}
void  S37C8 ::v34(){vfunc_called(this, "_ZN5S37C83v34Ev");}
void  S37C8 ::v35(){vfunc_called(this, "_ZN5S37C83v35Ev");}
void  S37C8 ::v36(){vfunc_called(this, "_ZN5S37C83v36Ev");}
void  S37C8 ::v37(){vfunc_called(this, "_ZN5S37C83v37Ev");}
void  S37C8 ::v38(){vfunc_called(this, "_ZN5S37C83v38Ev");}
void  S37C8 ::v39(){vfunc_called(this, "_ZN5S37C83v39Ev");}
void  S37C8 ::v40(){vfunc_called(this, "_ZN5S37C83v40Ev");}
void  S37C8 ::v41(){vfunc_called(this, "_ZN5S37C83v41Ev");}
void  S37C8 ::v42(){vfunc_called(this, "_ZN5S37C83v42Ev");}
void  S37C8 ::v43(){vfunc_called(this, "_ZN5S37C83v43Ev");}
void  S37C8 ::v44(){vfunc_called(this, "_ZN5S37C83v44Ev");}
void  S37C8 ::v45(){vfunc_called(this, "_ZN5S37C83v45Ev");}
void  S37C8 ::v46(){vfunc_called(this, "_ZN5S37C83v46Ev");}
void  S37C8 ::v47(){vfunc_called(this, "_ZN5S37C83v47Ev");}
void  S37C8 ::v48(){vfunc_called(this, "_ZN5S37C83v48Ev");}
void  S37C8 ::v49(){vfunc_called(this, "_ZN5S37C83v49Ev");}
void  S37C8 ::v50(){vfunc_called(this, "_ZN5S37C83v50Ev");}
void  S37C8 ::v51(){vfunc_called(this, "_ZN5S37C83v51Ev");}
void  S37C8 ::v52(){vfunc_called(this, "_ZN5S37C83v52Ev");}
void  S37C8 ::v53(){vfunc_called(this, "_ZN5S37C83v53Ev");}
void  S37C8 ::v54(){vfunc_called(this, "_ZN5S37C83v54Ev");}
void  S37C8 ::v55(){vfunc_called(this, "_ZN5S37C83v55Ev");}
void  S37C8 ::v56(){vfunc_called(this, "_ZN5S37C83v56Ev");}
void  S37C8 ::v57(){vfunc_called(this, "_ZN5S37C83v57Ev");}
void  S37C8 ::v58(){vfunc_called(this, "_ZN5S37C83v58Ev");}
void  S37C8 ::v59(){vfunc_called(this, "_ZN5S37C83v59Ev");}
void  S37C8 ::v60(){vfunc_called(this, "_ZN5S37C83v60Ev");}
void  S37C8 ::v61(){vfunc_called(this, "_ZN5S37C83v61Ev");}
void  S37C8 ::v62(){vfunc_called(this, "_ZN5S37C83v62Ev");}
void  S37C8 ::v63(){vfunc_called(this, "_ZN5S37C83v63Ev");}
void  S37C8 ::v64(){vfunc_called(this, "_ZN5S37C83v64Ev");}
void  S37C8 ::v65(){vfunc_called(this, "_ZN5S37C83v65Ev");}
void  S37C8 ::v66(){vfunc_called(this, "_ZN5S37C83v66Ev");}
void  S37C8 ::v67(){vfunc_called(this, "_ZN5S37C83v67Ev");}
S37C8 ::S37C8(){ note_ctor("S37C8", this);} // tgen

static void Test_S37C8()
{
  extern Class_Descriptor cd_S37C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S37C8, buf);
    S37C8 *dp, &lv = *(dp=new (buf) S37C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S37C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C8)");
    check_field_offset(lv, s37c8f0, ABISELECT(8,4), "S37C8.s37c8f0");
    check_field_offset(lv, s37c8f1, ABISELECT(16,8), "S37C8.s37c8f1");
    check_field_offset(lv, s37c8f2, ABISELECT(24,16), "S37C8.s37c8f2");
    check_field_offset(lv, s37c8f3, ABISELECT(56,32), "S37C8.s37c8f3");
    check_field_offset(lv, s37c8f4, ABISELECT(64,40), "S37C8.s37c8f4");
    check_field_offset(lv, s37c8f5, ABISELECT(72,44), "S37C8.s37c8f5");
    check_field_offset(lv, s37c8f6, ABISELECT(80,52), "S37C8.s37c8f6");
    test_class_info(&lv, &cd_S37C8);
    dp->~S37C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C8(Test_S37C8, "S37C8", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S37C8C1Ev();
extern void _ZN5S37C8D1Ev();
Name_Map name_map_S37C8[] = {
  NSPAIR(_ZN5S37C8C1Ev),
  NSPAIR(_ZN5S37C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S37C8[];
extern void _ZN5S37C8D1Ev();
extern void _ZN5S37C8D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
static  VTBL_ENTRY vtc_S37C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C8[0]),
  (VTBL_ENTRY)&_ZN5S37C8D1Ev,
  (VTBL_ENTRY)&_ZN5S37C8D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
};
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
Class_Descriptor cd_S37C8 = {  "S37C8", // class name
  0,0,//no base classes
  &(vtc_S37C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S37C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S37C8),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C7  : S37C8 {
  virtual  ~S37C7(); // _ZN5S37C7D1Ev
  virtual void  v68(); // _ZN5S37C73v68Ev
  virtual void  v69(); // _ZN5S37C73v69Ev
  S37C7(); // tgen
};
//SIG(-1 S37C7) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S37C7 ::~S37C7(){ note_dtor("S37C7", this);}
void  S37C7 ::v68(){vfunc_called(this, "_ZN5S37C73v68Ev");}
void  S37C7 ::v69(){vfunc_called(this, "_ZN5S37C73v69Ev");}
S37C7 ::S37C7(){ note_ctor("S37C7", this);} // tgen

static void Test_S37C7()
{
  extern Class_Descriptor cd_S37C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S37C7, buf);
    S37C7 *dp, &lv = *(dp=new (buf) S37C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S37C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C7)");
    check_base_class_offset(lv, (S37C8*), 0, "S37C7");
    test_class_info(&lv, &cd_S37C7);
    dp->~S37C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C7(Test_S37C7, "S37C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S37C7C1Ev();
extern void _ZN5S37C7D1Ev();
Name_Map name_map_S37C7[] = {
  NSPAIR(_ZN5S37C7C1Ev),
  NSPAIR(_ZN5S37C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
static Base_Class bases_S37C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C7[];
extern void _ZN5S37C7D1Ev();
extern void _ZN5S37C7D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
static  VTBL_ENTRY vtc_S37C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C7[0]),
  (VTBL_ENTRY)&_ZN5S37C7D1Ev,
  (VTBL_ENTRY)&_ZN5S37C7D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
};
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
Class_Descriptor cd_S37C7 = {  "S37C7", // class name
  bases_S37C7, 1,
  &(vtc_S37C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S37C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C7),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C6  : S37C7 {
  ::S80C9_nt s37c6f0;
  int s37c6f1;
  unsigned int s37c6f2:1;
  unsigned int s37c6f3:1;
  unsigned int s37c6f4:1;
  unsigned int s37c6f5:1;
  ::S85C35 s37c6f6;
  ::S85C22_nt s37c6f7;
  void *s37c6f8;
  ::S80C31 s37c6f9;
  ::S80C31 s37c6f10;
  ::S80C29 s37c6f11;
  ::S80C19 s37c6f12;
  char s37c6f13;
  int s37c6f14;
  void *s37c6f15;
  ::S85C27_nt s37c6f16;
  ::S85C27_nt s37c6f17;
  ::S85C27_nt s37c6f18;
  ::S85C27_nt s37c6f19;
  ::S85C27_nt s37c6f20;
  ::S85C27_nt s37c6f21;
  ::S80C21_nt s37c6f22;
  ::S80C21_nt s37c6f23;
  ::S80C21_nt s37c6f24;
  ::S80C21_nt s37c6f25;
  ::S80C21_nt s37c6f26;
  ::S80C21_nt s37c6f27;
  ::S80C21_nt s37c6f28;
  ::S80C21_nt s37c6f29;
  ::S80C21_nt s37c6f30;
  ::S80C21_nt s37c6f31;
  virtual  ~S37C6(); // _ZN5S37C6D1Ev
  virtual void  v70(); // _ZN5S37C63v70Ev
  virtual void  v71(); // _ZN5S37C63v71Ev
  virtual void  v72(); // _ZN5S37C63v72Ev
  virtual void  v73(); // _ZN5S37C63v73Ev
  virtual void  v74(); // _ZN5S37C63v74Ev
  virtual void  v75(); // _ZN5S37C63v75Ev
  virtual void  v76(); // _ZN5S37C63v76Ev
  virtual void  v77(); // _ZN5S37C63v77Ev
  virtual void  v78(); // _ZN5S37C63v78Ev
  virtual void  v79(); // _ZN5S37C63v79Ev
  virtual void  v80(); // _ZN5S37C63v80Ev
  virtual void  v81(); // _ZN5S37C63v81Ev
  virtual void  v82(); // _ZN5S37C63v82Ev
  virtual void  v83(); // _ZN5S37C63v83Ev
  virtual void  v84(); // _ZN5S37C63v84Ev
  virtual void  v85(); // _ZN5S37C63v85Ev
  virtual void  v86(); // _ZN5S37C63v86Ev
  virtual void  v87(); // _ZN5S37C63v87Ev
  virtual void  v88(); // _ZN5S37C63v88Ev
  virtual void  v89(); // _ZN5S37C63v89Ev
  virtual void  v90(); // _ZN5S37C63v90Ev
  virtual void  v91(); // _ZN5S37C63v91Ev
  virtual void  v92(); // _ZN5S37C63v92Ev
  virtual void  v93(); // _ZN5S37C63v93Ev
  virtual void  v94(); // _ZN5S37C63v94Ev
  virtual void  v95(); // _ZN5S37C63v95Ev
  virtual void  v96(); // _ZN5S37C63v96Ev
  virtual void  v97(); // _ZN5S37C63v97Ev
  virtual void  v98(); // _ZN5S37C63v98Ev
  virtual void  v99(); // _ZN5S37C63v99Ev
  virtual void  v100(); // _ZN5S37C64v100Ev
  virtual void  v101(); // _ZN5S37C64v101Ev
  virtual void  v102(); // _ZN5S37C64v102Ev
  virtual void  v103(); // _ZN5S37C64v103Ev
  virtual void  v104(); // _ZN5S37C64v104Ev
  virtual void  v105(); // _ZN5S37C64v105Ev
  virtual void  v106(); // _ZN5S37C64v106Ev
  virtual void  v107(); // _ZN5S37C64v107Ev
  virtual void  v108(); // _ZN5S37C64v108Ev
  virtual void  v109(); // _ZN5S37C64v109Ev
  virtual void  v110(); // _ZN5S37C64v110Ev
  virtual void  v111(); // _ZN5S37C64v111Ev
  virtual void  v112(); // _ZN5S37C64v112Ev
  virtual void  v113(); // _ZN5S37C64v113Ev
  virtual void  v114(); // _ZN5S37C64v114Ev
  virtual void  v115(); // _ZN5S37C64v115Ev
  virtual void  v116(); // _ZN5S37C64v116Ev
  virtual void  v117(); // _ZN5S37C64v117Ev
  virtual void  v118(); // _ZN5S37C64v118Ev
  virtual void  v119(); // _ZN5S37C64v119Ev
  virtual void  v120(); // _ZN5S37C64v120Ev
  virtual void  v121(); // _ZN5S37C64v121Ev
  virtual void  v122(); // _ZN5S37C64v122Ev
  virtual void  v123(); // _ZN5S37C64v123Ev
  virtual void  v124(); // _ZN5S37C64v124Ev
  virtual void  v125(); // _ZN5S37C64v125Ev
  virtual void  v126(); // _ZN5S37C64v126Ev
  virtual void  v127(); // _ZN5S37C64v127Ev
  virtual void  v128(); // _ZN5S37C64v128Ev
  virtual void  v129(); // _ZN5S37C64v129Ev
  virtual void  v130(); // _ZN5S37C64v130Ev
  virtual void  v131(); // _ZN5S37C64v131Ev
  virtual void  v132(); // _ZN5S37C64v132Ev
  virtual void  v133(); // _ZN5S37C64v133Ev
  virtual void  v134(); // _ZN5S37C64v134Ev
  virtual void  v135(); // _ZN5S37C64v135Ev
  virtual void  v136(); // _ZN5S37C64v136Ev
  virtual void  v137(); // _ZN5S37C64v137Ev
  virtual void  v138(); // _ZN5S37C64v138Ev
  virtual void  v139(); // _ZN5S37C64v139Ev
  virtual void  v140(); // _ZN5S37C64v140Ev
  virtual void  v141(); // _ZN5S37C64v141Ev
  virtual void  v142(); // _ZN5S37C64v142Ev
  virtual void  v143(); // _ZN5S37C64v143Ev
  virtual void  v144(); // _ZN5S37C64v144Ev
  virtual void  v145(); // _ZN5S37C64v145Ev
  S37C6(); // tgen
};
//SIG(-1 S37C6) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC18{ m Fi[2]}} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S37C6 ::~S37C6(){ note_dtor("S37C6", this);}
void  S37C6 ::v70(){vfunc_called(this, "_ZN5S37C63v70Ev");}
void  S37C6 ::v71(){vfunc_called(this, "_ZN5S37C63v71Ev");}
void  S37C6 ::v72(){vfunc_called(this, "_ZN5S37C63v72Ev");}
void  S37C6 ::v73(){vfunc_called(this, "_ZN5S37C63v73Ev");}
void  S37C6 ::v74(){vfunc_called(this, "_ZN5S37C63v74Ev");}
void  S37C6 ::v75(){vfunc_called(this, "_ZN5S37C63v75Ev");}
void  S37C6 ::v76(){vfunc_called(this, "_ZN5S37C63v76Ev");}
void  S37C6 ::v77(){vfunc_called(this, "_ZN5S37C63v77Ev");}
void  S37C6 ::v78(){vfunc_called(this, "_ZN5S37C63v78Ev");}
void  S37C6 ::v79(){vfunc_called(this, "_ZN5S37C63v79Ev");}
void  S37C6 ::v80(){vfunc_called(this, "_ZN5S37C63v80Ev");}
void  S37C6 ::v81(){vfunc_called(this, "_ZN5S37C63v81Ev");}
void  S37C6 ::v82(){vfunc_called(this, "_ZN5S37C63v82Ev");}
void  S37C6 ::v83(){vfunc_called(this, "_ZN5S37C63v83Ev");}
void  S37C6 ::v84(){vfunc_called(this, "_ZN5S37C63v84Ev");}
void  S37C6 ::v85(){vfunc_called(this, "_ZN5S37C63v85Ev");}
void  S37C6 ::v86(){vfunc_called(this, "_ZN5S37C63v86Ev");}
void  S37C6 ::v87(){vfunc_called(this, "_ZN5S37C63v87Ev");}
void  S37C6 ::v88(){vfunc_called(this, "_ZN5S37C63v88Ev");}
void  S37C6 ::v89(){vfunc_called(this, "_ZN5S37C63v89Ev");}
void  S37C6 ::v90(){vfunc_called(this, "_ZN5S37C63v90Ev");}
void  S37C6 ::v91(){vfunc_called(this, "_ZN5S37C63v91Ev");}
void  S37C6 ::v92(){vfunc_called(this, "_ZN5S37C63v92Ev");}
void  S37C6 ::v93(){vfunc_called(this, "_ZN5S37C63v93Ev");}
void  S37C6 ::v94(){vfunc_called(this, "_ZN5S37C63v94Ev");}
void  S37C6 ::v95(){vfunc_called(this, "_ZN5S37C63v95Ev");}
void  S37C6 ::v96(){vfunc_called(this, "_ZN5S37C63v96Ev");}
void  S37C6 ::v97(){vfunc_called(this, "_ZN5S37C63v97Ev");}
void  S37C6 ::v98(){vfunc_called(this, "_ZN5S37C63v98Ev");}
void  S37C6 ::v99(){vfunc_called(this, "_ZN5S37C63v99Ev");}
void  S37C6 ::v100(){vfunc_called(this, "_ZN5S37C64v100Ev");}
void  S37C6 ::v101(){vfunc_called(this, "_ZN5S37C64v101Ev");}
void  S37C6 ::v102(){vfunc_called(this, "_ZN5S37C64v102Ev");}
void  S37C6 ::v103(){vfunc_called(this, "_ZN5S37C64v103Ev");}
void  S37C6 ::v104(){vfunc_called(this, "_ZN5S37C64v104Ev");}
void  S37C6 ::v105(){vfunc_called(this, "_ZN5S37C64v105Ev");}
void  S37C6 ::v106(){vfunc_called(this, "_ZN5S37C64v106Ev");}
void  S37C6 ::v107(){vfunc_called(this, "_ZN5S37C64v107Ev");}
void  S37C6 ::v108(){vfunc_called(this, "_ZN5S37C64v108Ev");}
void  S37C6 ::v109(){vfunc_called(this, "_ZN5S37C64v109Ev");}
void  S37C6 ::v110(){vfunc_called(this, "_ZN5S37C64v110Ev");}
void  S37C6 ::v111(){vfunc_called(this, "_ZN5S37C64v111Ev");}
void  S37C6 ::v112(){vfunc_called(this, "_ZN5S37C64v112Ev");}
void  S37C6 ::v113(){vfunc_called(this, "_ZN5S37C64v113Ev");}
void  S37C6 ::v114(){vfunc_called(this, "_ZN5S37C64v114Ev");}
void  S37C6 ::v115(){vfunc_called(this, "_ZN5S37C64v115Ev");}
void  S37C6 ::v116(){vfunc_called(this, "_ZN5S37C64v116Ev");}
void  S37C6 ::v117(){vfunc_called(this, "_ZN5S37C64v117Ev");}
void  S37C6 ::v118(){vfunc_called(this, "_ZN5S37C64v118Ev");}
void  S37C6 ::v119(){vfunc_called(this, "_ZN5S37C64v119Ev");}
void  S37C6 ::v120(){vfunc_called(this, "_ZN5S37C64v120Ev");}
void  S37C6 ::v121(){vfunc_called(this, "_ZN5S37C64v121Ev");}
void  S37C6 ::v122(){vfunc_called(this, "_ZN5S37C64v122Ev");}
void  S37C6 ::v123(){vfunc_called(this, "_ZN5S37C64v123Ev");}
void  S37C6 ::v124(){vfunc_called(this, "_ZN5S37C64v124Ev");}
void  S37C6 ::v125(){vfunc_called(this, "_ZN5S37C64v125Ev");}
void  S37C6 ::v126(){vfunc_called(this, "_ZN5S37C64v126Ev");}
void  S37C6 ::v127(){vfunc_called(this, "_ZN5S37C64v127Ev");}
void  S37C6 ::v128(){vfunc_called(this, "_ZN5S37C64v128Ev");}
void  S37C6 ::v129(){vfunc_called(this, "_ZN5S37C64v129Ev");}
void  S37C6 ::v130(){vfunc_called(this, "_ZN5S37C64v130Ev");}
void  S37C6 ::v131(){vfunc_called(this, "_ZN5S37C64v131Ev");}
void  S37C6 ::v132(){vfunc_called(this, "_ZN5S37C64v132Ev");}
void  S37C6 ::v133(){vfunc_called(this, "_ZN5S37C64v133Ev");}
void  S37C6 ::v134(){vfunc_called(this, "_ZN5S37C64v134Ev");}
void  S37C6 ::v135(){vfunc_called(this, "_ZN5S37C64v135Ev");}
void  S37C6 ::v136(){vfunc_called(this, "_ZN5S37C64v136Ev");}
void  S37C6 ::v137(){vfunc_called(this, "_ZN5S37C64v137Ev");}
void  S37C6 ::v138(){vfunc_called(this, "_ZN5S37C64v138Ev");}
void  S37C6 ::v139(){vfunc_called(this, "_ZN5S37C64v139Ev");}
void  S37C6 ::v140(){vfunc_called(this, "_ZN5S37C64v140Ev");}
void  S37C6 ::v141(){vfunc_called(this, "_ZN5S37C64v141Ev");}
void  S37C6 ::v142(){vfunc_called(this, "_ZN5S37C64v142Ev");}
void  S37C6 ::v143(){vfunc_called(this, "_ZN5S37C64v143Ev");}
void  S37C6 ::v144(){vfunc_called(this, "_ZN5S37C64v144Ev");}
void  S37C6 ::v145(){vfunc_called(this, "_ZN5S37C64v145Ev");}
S37C6 ::S37C6(){ note_ctor("S37C6", this);} // tgen

static void Test_S37C6()
{
  extern Class_Descriptor cd_S37C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S37C6, buf);
    S37C6 *dp, &lv = *(dp=new (buf) S37C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S37C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C6)");
    check_base_class_offset(lv, (S37C8*)(S37C7*), 0, "S37C6");
    check_base_class_offset(lv, (S37C7*), 0, "S37C6");
    check_field_offset(lv, s37c6f0, ABISELECT(96,60), "S37C6.s37c6f0");
    check_field_offset(lv, s37c6f1, ABISELECT(124,88), "S37C6.s37c6f1");
    set_bf_and_test(lv, s37c6f2, ABISELECT(128,92), 0, 1, 1, "S37C6");
    set_bf_and_test(lv, s37c6f3, ABISELECT(128,92), 1, 1, 1, "S37C6");
    set_bf_and_test(lv, s37c6f4, ABISELECT(128,92), 2, 1, 1, "S37C6");
    set_bf_and_test(lv, s37c6f5, ABISELECT(128,92), 3, 1, 1, "S37C6");
    check_field_offset(lv, s37c6f6, ABISELECT(136,96), "S37C6.s37c6f6");
    check_field_offset(lv, s37c6f7, ABISELECT(152,108), "S37C6.s37c6f7");
    check_field_offset(lv, s37c6f8, ABISELECT(168,120), "S37C6.s37c6f8");
    check_field_offset(lv, s37c6f9, ABISELECT(176,124), "S37C6.s37c6f9");
    check_field_offset(lv, s37c6f10, ABISELECT(192,136), "S37C6.s37c6f10");
    check_field_offset(lv, s37c6f11, ABISELECT(208,148), "S37C6.s37c6f11");
    check_field_offset(lv, s37c6f12, ABISELECT(224,160), "S37C6.s37c6f12");
    check_field_offset(lv, s37c6f13, ABISELECT(240,172), "S37C6.s37c6f13");
    check_field_offset(lv, s37c6f14, ABISELECT(244,176), "S37C6.s37c6f14");
    check_field_offset(lv, s37c6f15, ABISELECT(248,180), "S37C6.s37c6f15");
    check_field_offset(lv, s37c6f16, ABISELECT(256,184), "S37C6.s37c6f16");
    check_field_offset(lv, s37c6f17, ABISELECT(264,192), "S37C6.s37c6f17");
    check_field_offset(lv, s37c6f18, ABISELECT(272,200), "S37C6.s37c6f18");
    check_field_offset(lv, s37c6f19, ABISELECT(280,208), "S37C6.s37c6f19");
    check_field_offset(lv, s37c6f20, ABISELECT(288,216), "S37C6.s37c6f20");
    check_field_offset(lv, s37c6f21, ABISELECT(296,224), "S37C6.s37c6f21");
    check_field_offset(lv, s37c6f22, ABISELECT(304,232), "S37C6.s37c6f22");
    check_field_offset(lv, s37c6f23, ABISELECT(320,244), "S37C6.s37c6f23");
    check_field_offset(lv, s37c6f24, ABISELECT(336,256), "S37C6.s37c6f24");
    check_field_offset(lv, s37c6f25, ABISELECT(352,268), "S37C6.s37c6f25");
    check_field_offset(lv, s37c6f26, ABISELECT(368,280), "S37C6.s37c6f26");
    check_field_offset(lv, s37c6f27, ABISELECT(384,292), "S37C6.s37c6f27");
    check_field_offset(lv, s37c6f28, ABISELECT(400,304), "S37C6.s37c6f28");
    check_field_offset(lv, s37c6f29, ABISELECT(416,316), "S37C6.s37c6f29");
    check_field_offset(lv, s37c6f30, ABISELECT(432,328), "S37C6.s37c6f30");
    check_field_offset(lv, s37c6f31, ABISELECT(448,340), "S37C6.s37c6f31");
    test_class_info(&lv, &cd_S37C6);
    dp->~S37C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C6(Test_S37C6, "S37C6", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN5S37C6C1Ev();
extern void _ZN5S37C6D1Ev();
Name_Map name_map_S37C6[] = {
  NSPAIR(_ZN5S37C6C1Ev),
  NSPAIR(_ZN5S37C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
static Base_Class bases_S37C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C6[];
extern void _ZN5S37C6D1Ev();
extern void _ZN5S37C6D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
static  VTBL_ENTRY vtc_S37C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C6[0]),
  (VTBL_ENTRY)&_ZN5S37C6D1Ev,
  (VTBL_ENTRY)&_ZN5S37C6D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
};
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
Class_Descriptor cd_S37C6 = {  "S37C6", // class name
  bases_S37C6, 2,
  &(vtc_S37C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI5S37C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C6),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C5  : S37C6 {
  ::S85C27_nt s37c5f0;
  void *s37c5f1[9];
  ::S80C15 s37c5f2;
  ::S85C35 s37c5f3;
  ::S80C24 s37c5f4;
  int s37c5f5;
  unsigned int s37c5f6:1;
  unsigned int s37c5f7:1;
  unsigned int s37c5f8:1;
  unsigned int s37c5f9:1;
  unsigned int s37c5f10:1;
  unsigned int s37c5f11:1;
  unsigned int s37c5f12:1;
  unsigned int s37c5f13:1;
  unsigned int s37c5f14:1;
  unsigned int s37c5f15:1;
  unsigned int s37c5f16:1;
  unsigned int s37c5f17:1;
  unsigned int s37c5f18:1;
  unsigned int s37c5f19:1;
  unsigned int s37c5f20:1;
  unsigned int s37c5f21:1;
  unsigned int s37c5f22:1;
  unsigned int s37c5f23:1;
  unsigned int s37c5f24:1;
  unsigned int s37c5f25:1;
  unsigned int s37c5f26:1;
  unsigned int s37c5f27:1;
  void *s37c5f28;
  char s37c5f29[2];
  ::S80C8_nt s37c5f30;
  ::S85C27_nt s37c5f31;
  ::S85C27_nt s37c5f32;
  void *s37c5f33;
  ::S80C21_nt s37c5f34;
  ::S80C21_nt s37c5f35;
  ::S80C21_nt s37c5f36;
  ::S80C21_nt s37c5f37;
  ::S80C21_nt s37c5f38;
  virtual  ~S37C5(); // _ZN5S37C5D1Ev
  virtual void  v146(); // _ZN5S37C54v146Ev
  virtual void  v147(); // _ZN5S37C54v147Ev
  virtual void  v148(); // _ZN5S37C54v148Ev
  virtual void  v149(); // _ZN5S37C54v149Ev
  virtual void  v150(); // _ZN5S37C54v150Ev
  virtual void  v151(); // _ZN5S37C54v151Ev
  virtual void  v152(); // _ZN5S37C54v152Ev
  virtual void  v153(); // _ZN5S37C54v153Ev
  virtual void  v154(); // _ZN5S37C54v154Ev
  virtual void  v155(); // _ZN5S37C54v155Ev
  virtual void  v156(); // _ZN5S37C54v156Ev
  virtual void  v157(); // _ZN5S37C54v157Ev
  virtual void  v158(); // _ZN5S37C54v158Ev
  virtual void  v159(); // _ZN5S37C54v159Ev
  virtual void  v160(); // _ZN5S37C54v160Ev
  virtual void  v161(); // _ZN5S37C54v161Ev
  virtual void  v162(); // _ZN5S37C54v162Ev
  virtual void  v163(); // _ZN5S37C54v163Ev
  virtual void  v164(); // _ZN5S37C54v164Ev
  virtual void  v165(); // _ZN5S37C54v165Ev
  virtual void  v166(); // _ZN5S37C54v166Ev
  virtual void  v167(); // _ZN5S37C54v167Ev
  virtual void  v168(); // _ZN5S37C54v168Ev
  virtual void  v169(); // _ZN5S37C54v169Ev
  virtual void  v170(); // _ZN5S37C54v170Ev
  virtual void  v171(); // _ZN5S37C54v171Ev
  virtual void  v172(); // _ZN5S37C54v172Ev
  virtual void  v173(); // _ZN5S37C54v173Ev
  virtual void  v174(); // _ZN5S37C54v174Ev
  virtual void  v175(); // _ZN5S37C54v175Ev
  virtual void  v176(); // _ZN5S37C54v176Ev
  virtual void  v177(); // _ZN5S37C54v177Ev
  virtual void  v178(); // _ZN5S37C54v178Ev
  virtual void  v179(); // _ZN5S37C54v179Ev
  virtual void  v180(); // _ZN5S37C54v180Ev
  virtual void  v181(); // _ZN5S37C54v181Ev
  virtual void  v182(); // _ZN5S37C54v182Ev
  virtual void  v183(); // _ZN5S37C54v183Ev
  virtual void  v184(); // _ZN5S37C54v184Ev
  S37C5(); // tgen
};
//SIG(-1 S37C5) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC19{ m Fi[2]}} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC20{ BC21{ BC9}} FC7 FC22{ BC23{ m FC24{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC19 FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S37C5 ::~S37C5(){ note_dtor("S37C5", this);}
void  S37C5 ::v146(){vfunc_called(this, "_ZN5S37C54v146Ev");}
void  S37C5 ::v147(){vfunc_called(this, "_ZN5S37C54v147Ev");}
void  S37C5 ::v148(){vfunc_called(this, "_ZN5S37C54v148Ev");}
void  S37C5 ::v149(){vfunc_called(this, "_ZN5S37C54v149Ev");}
void  S37C5 ::v150(){vfunc_called(this, "_ZN5S37C54v150Ev");}
void  S37C5 ::v151(){vfunc_called(this, "_ZN5S37C54v151Ev");}
void  S37C5 ::v152(){vfunc_called(this, "_ZN5S37C54v152Ev");}
void  S37C5 ::v153(){vfunc_called(this, "_ZN5S37C54v153Ev");}
void  S37C5 ::v154(){vfunc_called(this, "_ZN5S37C54v154Ev");}
void  S37C5 ::v155(){vfunc_called(this, "_ZN5S37C54v155Ev");}
void  S37C5 ::v156(){vfunc_called(this, "_ZN5S37C54v156Ev");}
void  S37C5 ::v157(){vfunc_called(this, "_ZN5S37C54v157Ev");}
void  S37C5 ::v158(){vfunc_called(this, "_ZN5S37C54v158Ev");}
void  S37C5 ::v159(){vfunc_called(this, "_ZN5S37C54v159Ev");}
void  S37C5 ::v160(){vfunc_called(this, "_ZN5S37C54v160Ev");}
void  S37C5 ::v161(){vfunc_called(this, "_ZN5S37C54v161Ev");}
void  S37C5 ::v162(){vfunc_called(this, "_ZN5S37C54v162Ev");}
void  S37C5 ::v163(){vfunc_called(this, "_ZN5S37C54v163Ev");}
void  S37C5 ::v164(){vfunc_called(this, "_ZN5S37C54v164Ev");}
void  S37C5 ::v165(){vfunc_called(this, "_ZN5S37C54v165Ev");}
void  S37C5 ::v166(){vfunc_called(this, "_ZN5S37C54v166Ev");}
void  S37C5 ::v167(){vfunc_called(this, "_ZN5S37C54v167Ev");}
void  S37C5 ::v168(){vfunc_called(this, "_ZN5S37C54v168Ev");}
void  S37C5 ::v169(){vfunc_called(this, "_ZN5S37C54v169Ev");}
void  S37C5 ::v170(){vfunc_called(this, "_ZN5S37C54v170Ev");}
void  S37C5 ::v171(){vfunc_called(this, "_ZN5S37C54v171Ev");}
void  S37C5 ::v172(){vfunc_called(this, "_ZN5S37C54v172Ev");}
void  S37C5 ::v173(){vfunc_called(this, "_ZN5S37C54v173Ev");}
void  S37C5 ::v174(){vfunc_called(this, "_ZN5S37C54v174Ev");}
void  S37C5 ::v175(){vfunc_called(this, "_ZN5S37C54v175Ev");}
void  S37C5 ::v176(){vfunc_called(this, "_ZN5S37C54v176Ev");}
void  S37C5 ::v177(){vfunc_called(this, "_ZN5S37C54v177Ev");}
void  S37C5 ::v178(){vfunc_called(this, "_ZN5S37C54v178Ev");}
void  S37C5 ::v179(){vfunc_called(this, "_ZN5S37C54v179Ev");}
void  S37C5 ::v180(){vfunc_called(this, "_ZN5S37C54v180Ev");}
void  S37C5 ::v181(){vfunc_called(this, "_ZN5S37C54v181Ev");}
void  S37C5 ::v182(){vfunc_called(this, "_ZN5S37C54v182Ev");}
void  S37C5 ::v183(){vfunc_called(this, "_ZN5S37C54v183Ev");}
void  S37C5 ::v184(){vfunc_called(this, "_ZN5S37C54v184Ev");}
S37C5 ::S37C5(){ note_ctor("S37C5", this);} // tgen

static void Test_S37C5()
{
  extern Class_Descriptor cd_S37C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S37C5, buf);
    S37C5 *dp, &lv = *(dp=new (buf) S37C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S37C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C5)");
    check_base_class_offset(lv, (S37C8*)(S37C7*)(S37C6*), 0, "S37C5");
    check_base_class_offset(lv, (S37C7*)(S37C6*), 0, "S37C5");
    check_base_class_offset(lv, (S37C6*), 0, "S37C5");
    check_field_offset(lv, s37c5f0, ABISELECT(464,352), "S37C5.s37c5f0");
    check_field_offset(lv, s37c5f1, ABISELECT(472,360), "S37C5.s37c5f1");
    check_field_offset(lv, s37c5f2, ABISELECT(544,396), "S37C5.s37c5f2");
    check_field_offset(lv, s37c5f3, ABISELECT(560,408), "S37C5.s37c5f3");
    check_field_offset(lv, s37c5f4, ABISELECT(576,420), "S37C5.s37c5f4");
    check_field_offset(lv, s37c5f5, ABISELECT(608,440), "S37C5.s37c5f5");
    set_bf_and_test(lv, s37c5f6, ABISELECT(612,444), 0, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f7, ABISELECT(612,444), 1, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f8, ABISELECT(612,444), 2, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f9, ABISELECT(612,444), 3, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f10, ABISELECT(612,444), 4, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f11, ABISELECT(612,444), 5, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f12, ABISELECT(612,444), 6, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f13, ABISELECT(612,444), 7, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f14, ABISELECT(613,445), 0, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f15, ABISELECT(613,445), 1, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f16, ABISELECT(613,445), 2, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f17, ABISELECT(613,445), 3, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f18, ABISELECT(613,445), 4, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f19, ABISELECT(613,445), 5, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f20, ABISELECT(613,445), 6, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f21, ABISELECT(613,445), 7, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f22, ABISELECT(614,446), 0, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f23, ABISELECT(614,446), 1, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f24, ABISELECT(614,446), 2, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f25, ABISELECT(614,446), 3, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f26, ABISELECT(614,446), 4, 1, 1, "S37C5");
    set_bf_and_test(lv, s37c5f27, ABISELECT(614,446), 5, 1, 1, "S37C5");
    check_field_offset(lv, s37c5f28, ABISELECT(616,448), "S37C5.s37c5f28");
    check_field_offset(lv, s37c5f29, ABISELECT(624,452), "S37C5.s37c5f29");
    check_field_offset(lv, s37c5f30, ABISELECT(628,456), "S37C5.s37c5f30");
    check_field_offset(lv, s37c5f31, ABISELECT(636,464), "S37C5.s37c5f31");
    check_field_offset(lv, s37c5f32, ABISELECT(644,472), "S37C5.s37c5f32");
    check_field_offset(lv, s37c5f33, ABISELECT(656,480), "S37C5.s37c5f33");
    check_field_offset(lv, s37c5f34, ABISELECT(664,484), "S37C5.s37c5f34");
    check_field_offset(lv, s37c5f35, ABISELECT(680,496), "S37C5.s37c5f35");
    check_field_offset(lv, s37c5f36, ABISELECT(696,508), "S37C5.s37c5f36");
    check_field_offset(lv, s37c5f37, ABISELECT(712,520), "S37C5.s37c5f37");
    check_field_offset(lv, s37c5f38, ABISELECT(728,532), "S37C5.s37c5f38");
    test_class_info(&lv, &cd_S37C5);
    dp->~S37C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C5(Test_S37C5, "S37C5", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN5S37C5C1Ev();
extern void _ZN5S37C5D1Ev();
Name_Map name_map_S37C5[] = {
  NSPAIR(_ZN5S37C5C1Ev),
  NSPAIR(_ZN5S37C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
extern Class_Descriptor cd_S37C6;
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
static Base_Class bases_S37C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S37C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C5[];
extern void _ZN5S37C5D1Ev();
extern void _ZN5S37C5D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
extern void _ZN5S37C54v146Ev();
extern void _ZN5S37C54v147Ev();
extern void _ZN5S37C54v148Ev();
extern void _ZN5S37C54v149Ev();
extern void _ZN5S37C54v150Ev();
extern void _ZN5S37C54v151Ev();
extern void _ZN5S37C54v152Ev();
extern void _ZN5S37C54v153Ev();
extern void _ZN5S37C54v154Ev();
extern void _ZN5S37C54v155Ev();
extern void _ZN5S37C54v156Ev();
extern void _ZN5S37C54v157Ev();
extern void _ZN5S37C54v158Ev();
extern void _ZN5S37C54v159Ev();
extern void _ZN5S37C54v160Ev();
extern void _ZN5S37C54v161Ev();
extern void _ZN5S37C54v162Ev();
extern void _ZN5S37C54v163Ev();
extern void _ZN5S37C54v164Ev();
extern void _ZN5S37C54v165Ev();
extern void _ZN5S37C54v166Ev();
extern void _ZN5S37C54v167Ev();
extern void _ZN5S37C54v168Ev();
extern void _ZN5S37C54v169Ev();
extern void _ZN5S37C54v170Ev();
extern void _ZN5S37C54v171Ev();
extern void _ZN5S37C54v172Ev();
extern void _ZN5S37C54v173Ev();
extern void _ZN5S37C54v174Ev();
extern void _ZN5S37C54v175Ev();
extern void _ZN5S37C54v176Ev();
extern void _ZN5S37C54v177Ev();
extern void _ZN5S37C54v178Ev();
extern void _ZN5S37C54v179Ev();
extern void _ZN5S37C54v180Ev();
extern void _ZN5S37C54v181Ev();
extern void _ZN5S37C54v182Ev();
extern void _ZN5S37C54v183Ev();
extern void _ZN5S37C54v184Ev();
static  VTBL_ENTRY vtc_S37C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C5[0]),
  (VTBL_ENTRY)&_ZN5S37C5D1Ev,
  (VTBL_ENTRY)&_ZN5S37C5D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
  (VTBL_ENTRY)&_ZN5S37C54v146Ev,
  (VTBL_ENTRY)&_ZN5S37C54v147Ev,
  (VTBL_ENTRY)&_ZN5S37C54v148Ev,
  (VTBL_ENTRY)&_ZN5S37C54v149Ev,
  (VTBL_ENTRY)&_ZN5S37C54v150Ev,
  (VTBL_ENTRY)&_ZN5S37C54v151Ev,
  (VTBL_ENTRY)&_ZN5S37C54v152Ev,
  (VTBL_ENTRY)&_ZN5S37C54v153Ev,
  (VTBL_ENTRY)&_ZN5S37C54v154Ev,
  (VTBL_ENTRY)&_ZN5S37C54v155Ev,
  (VTBL_ENTRY)&_ZN5S37C54v156Ev,
  (VTBL_ENTRY)&_ZN5S37C54v157Ev,
  (VTBL_ENTRY)&_ZN5S37C54v158Ev,
  (VTBL_ENTRY)&_ZN5S37C54v159Ev,
  (VTBL_ENTRY)&_ZN5S37C54v160Ev,
  (VTBL_ENTRY)&_ZN5S37C54v161Ev,
  (VTBL_ENTRY)&_ZN5S37C54v162Ev,
  (VTBL_ENTRY)&_ZN5S37C54v163Ev,
  (VTBL_ENTRY)&_ZN5S37C54v164Ev,
  (VTBL_ENTRY)&_ZN5S37C54v165Ev,
  (VTBL_ENTRY)&_ZN5S37C54v166Ev,
  (VTBL_ENTRY)&_ZN5S37C54v167Ev,
  (VTBL_ENTRY)&_ZN5S37C54v168Ev,
  (VTBL_ENTRY)&_ZN5S37C54v169Ev,
  (VTBL_ENTRY)&_ZN5S37C54v170Ev,
  (VTBL_ENTRY)&_ZN5S37C54v171Ev,
  (VTBL_ENTRY)&_ZN5S37C54v172Ev,
  (VTBL_ENTRY)&_ZN5S37C54v173Ev,
  (VTBL_ENTRY)&_ZN5S37C54v174Ev,
  (VTBL_ENTRY)&_ZN5S37C54v175Ev,
  (VTBL_ENTRY)&_ZN5S37C54v176Ev,
  (VTBL_ENTRY)&_ZN5S37C54v177Ev,
  (VTBL_ENTRY)&_ZN5S37C54v178Ev,
  (VTBL_ENTRY)&_ZN5S37C54v179Ev,
  (VTBL_ENTRY)&_ZN5S37C54v180Ev,
  (VTBL_ENTRY)&_ZN5S37C54v181Ev,
  (VTBL_ENTRY)&_ZN5S37C54v182Ev,
  (VTBL_ENTRY)&_ZN5S37C54v183Ev,
  (VTBL_ENTRY)&_ZN5S37C54v184Ev,
};
extern VTBL_ENTRY _ZTI5S37C5[];
extern  VTBL_ENTRY _ZTV5S37C5[];
Class_Descriptor cd_S37C5 = {  "S37C5", // class name
  bases_S37C5, 3,
  &(vtc_S37C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI5S37C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C5),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C4  : S37C5 {
  unsigned int s37c4f0:1;
  unsigned int s37c4f1:1;
  unsigned int s37c4f2:1;
  unsigned int s37c4f3:1;
  unsigned int s37c4f4:1;
  unsigned int s37c4f5:1;
  void *s37c4f6[8];
  ::S80C21_nt s37c4f7;
  ::S80C21_nt s37c4f8;
  ::S80C21_nt s37c4f9;
  virtual  ~S37C4(); // _ZN5S37C4D1Ev
  virtual void  v185(); // _ZN5S37C44v185Ev
  virtual void  v186(); // _ZN5S37C44v186Ev
  virtual void  v187(); // _ZN5S37C44v187Ev
  virtual void  v188(); // _ZN5S37C44v188Ev
  virtual void  v189(); // _ZN5S37C44v189Ev
  virtual void  v190(); // _ZN5S37C44v190Ev
  virtual void  v191(); // _ZN5S37C44v191Ev
  virtual void  v192(); // _ZN5S37C44v192Ev
  virtual void  v193(); // _ZN5S37C44v193Ev
  virtual void  v194(); // _ZN5S37C44v194Ev
  virtual void  v195(); // _ZN5S37C44v195Ev
  virtual void  v196(); // _ZN5S37C44v196Ev
  virtual void  v197(); // _ZN5S37C44v197Ev
  virtual void  v198(); // _ZN5S37C44v198Ev
  virtual void  v199(); // _ZN5S37C44v199Ev
  virtual void  v200(); // _ZN5S37C44v200Ev
  virtual void  v201(); // _ZN5S37C44v201Ev
  virtual void  v202(); // _ZN5S37C44v202Ev
  virtual void  v203(); // _ZN5S37C44v203Ev
  virtual void  v204(); // _ZN5S37C44v204Ev
  virtual void  v205(); // _ZN5S37C44v205Ev
  virtual void  v206(); // _ZN5S37C44v206Ev
  virtual void  v207(); // _ZN5S37C44v207Ev
  S37C4(); // tgen
};
//SIG(-1 S37C4) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC20{ m Fi[2]}} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC21{ BC22{ BC10}} FC8 FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC20 FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S37C4 ::~S37C4(){ note_dtor("S37C4", this);}
void  S37C4 ::v185(){vfunc_called(this, "_ZN5S37C44v185Ev");}
void  S37C4 ::v186(){vfunc_called(this, "_ZN5S37C44v186Ev");}
void  S37C4 ::v187(){vfunc_called(this, "_ZN5S37C44v187Ev");}
void  S37C4 ::v188(){vfunc_called(this, "_ZN5S37C44v188Ev");}
void  S37C4 ::v189(){vfunc_called(this, "_ZN5S37C44v189Ev");}
void  S37C4 ::v190(){vfunc_called(this, "_ZN5S37C44v190Ev");}
void  S37C4 ::v191(){vfunc_called(this, "_ZN5S37C44v191Ev");}
void  S37C4 ::v192(){vfunc_called(this, "_ZN5S37C44v192Ev");}
void  S37C4 ::v193(){vfunc_called(this, "_ZN5S37C44v193Ev");}
void  S37C4 ::v194(){vfunc_called(this, "_ZN5S37C44v194Ev");}
void  S37C4 ::v195(){vfunc_called(this, "_ZN5S37C44v195Ev");}
void  S37C4 ::v196(){vfunc_called(this, "_ZN5S37C44v196Ev");}
void  S37C4 ::v197(){vfunc_called(this, "_ZN5S37C44v197Ev");}
void  S37C4 ::v198(){vfunc_called(this, "_ZN5S37C44v198Ev");}
void  S37C4 ::v199(){vfunc_called(this, "_ZN5S37C44v199Ev");}
void  S37C4 ::v200(){vfunc_called(this, "_ZN5S37C44v200Ev");}
void  S37C4 ::v201(){vfunc_called(this, "_ZN5S37C44v201Ev");}
void  S37C4 ::v202(){vfunc_called(this, "_ZN5S37C44v202Ev");}
void  S37C4 ::v203(){vfunc_called(this, "_ZN5S37C44v203Ev");}
void  S37C4 ::v204(){vfunc_called(this, "_ZN5S37C44v204Ev");}
void  S37C4 ::v205(){vfunc_called(this, "_ZN5S37C44v205Ev");}
void  S37C4 ::v206(){vfunc_called(this, "_ZN5S37C44v206Ev");}
void  S37C4 ::v207(){vfunc_called(this, "_ZN5S37C44v207Ev");}
S37C4 ::S37C4(){ note_ctor("S37C4", this);} // tgen

static void Test_S37C4()
{
  extern Class_Descriptor cd_S37C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S37C4, buf);
    S37C4 *dp, &lv = *(dp=new (buf) S37C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S37C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C4)");
    check_base_class_offset(lv, (S37C8*)(S37C7*)(S37C6*)(S37C5*), 0, "S37C4");
    check_base_class_offset(lv, (S37C7*)(S37C6*)(S37C5*), 0, "S37C4");
    check_base_class_offset(lv, (S37C6*)(S37C5*), 0, "S37C4");
    check_base_class_offset(lv, (S37C5*), 0, "S37C4");
    set_bf_and_test(lv, s37c4f0, ABISELECT(744,544), 0, 1, 1, "S37C4");
    set_bf_and_test(lv, s37c4f1, ABISELECT(744,544), 1, 1, 1, "S37C4");
    set_bf_and_test(lv, s37c4f2, ABISELECT(744,544), 2, 1, 1, "S37C4");
    set_bf_and_test(lv, s37c4f3, ABISELECT(744,544), 3, 1, 1, "S37C4");
    set_bf_and_test(lv, s37c4f4, ABISELECT(744,544), 4, 1, 1, "S37C4");
    set_bf_and_test(lv, s37c4f5, ABISELECT(744,544), 5, 1, 1, "S37C4");
    check_field_offset(lv, s37c4f6, ABISELECT(752,548), "S37C4.s37c4f6");
    check_field_offset(lv, s37c4f7, ABISELECT(816,580), "S37C4.s37c4f7");
    check_field_offset(lv, s37c4f8, ABISELECT(832,592), "S37C4.s37c4f8");
    check_field_offset(lv, s37c4f9, ABISELECT(848,604), "S37C4.s37c4f9");
    test_class_info(&lv, &cd_S37C4);
    dp->~S37C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C4(Test_S37C4, "S37C4", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN5S37C4C1Ev();
extern void _ZN5S37C4D1Ev();
Name_Map name_map_S37C4[] = {
  NSPAIR(_ZN5S37C4C1Ev),
  NSPAIR(_ZN5S37C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
extern Class_Descriptor cd_S37C6;
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
extern Class_Descriptor cd_S37C5;
extern VTBL_ENTRY _ZTI5S37C5[];
extern  VTBL_ENTRY _ZTV5S37C5[];
static Base_Class bases_S37C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S37C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S37C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C4[];
extern void _ZN5S37C4D1Ev();
extern void _ZN5S37C4D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
extern void _ZN5S37C54v146Ev();
extern void _ZN5S37C54v147Ev();
extern void _ZN5S37C54v148Ev();
extern void _ZN5S37C54v149Ev();
extern void _ZN5S37C54v150Ev();
extern void _ZN5S37C54v151Ev();
extern void _ZN5S37C54v152Ev();
extern void _ZN5S37C54v153Ev();
extern void _ZN5S37C54v154Ev();
extern void _ZN5S37C54v155Ev();
extern void _ZN5S37C54v156Ev();
extern void _ZN5S37C54v157Ev();
extern void _ZN5S37C54v158Ev();
extern void _ZN5S37C54v159Ev();
extern void _ZN5S37C54v160Ev();
extern void _ZN5S37C54v161Ev();
extern void _ZN5S37C54v162Ev();
extern void _ZN5S37C54v163Ev();
extern void _ZN5S37C54v164Ev();
extern void _ZN5S37C54v165Ev();
extern void _ZN5S37C54v166Ev();
extern void _ZN5S37C54v167Ev();
extern void _ZN5S37C54v168Ev();
extern void _ZN5S37C54v169Ev();
extern void _ZN5S37C54v170Ev();
extern void _ZN5S37C54v171Ev();
extern void _ZN5S37C54v172Ev();
extern void _ZN5S37C54v173Ev();
extern void _ZN5S37C54v174Ev();
extern void _ZN5S37C54v175Ev();
extern void _ZN5S37C54v176Ev();
extern void _ZN5S37C54v177Ev();
extern void _ZN5S37C54v178Ev();
extern void _ZN5S37C54v179Ev();
extern void _ZN5S37C54v180Ev();
extern void _ZN5S37C54v181Ev();
extern void _ZN5S37C54v182Ev();
extern void _ZN5S37C54v183Ev();
extern void _ZN5S37C54v184Ev();
extern void _ZN5S37C44v185Ev();
extern void _ZN5S37C44v186Ev();
extern void _ZN5S37C44v187Ev();
extern void _ZN5S37C44v188Ev();
extern void _ZN5S37C44v189Ev();
extern void _ZN5S37C44v190Ev();
extern void _ZN5S37C44v191Ev();
extern void _ZN5S37C44v192Ev();
extern void _ZN5S37C44v193Ev();
extern void _ZN5S37C44v194Ev();
extern void _ZN5S37C44v195Ev();
extern void _ZN5S37C44v196Ev();
extern void _ZN5S37C44v197Ev();
extern void _ZN5S37C44v198Ev();
extern void _ZN5S37C44v199Ev();
extern void _ZN5S37C44v200Ev();
extern void _ZN5S37C44v201Ev();
extern void _ZN5S37C44v202Ev();
extern void _ZN5S37C44v203Ev();
extern void _ZN5S37C44v204Ev();
extern void _ZN5S37C44v205Ev();
extern void _ZN5S37C44v206Ev();
extern void _ZN5S37C44v207Ev();
static  VTBL_ENTRY vtc_S37C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C4[0]),
  (VTBL_ENTRY)&_ZN5S37C4D1Ev,
  (VTBL_ENTRY)&_ZN5S37C4D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
  (VTBL_ENTRY)&_ZN5S37C54v146Ev,
  (VTBL_ENTRY)&_ZN5S37C54v147Ev,
  (VTBL_ENTRY)&_ZN5S37C54v148Ev,
  (VTBL_ENTRY)&_ZN5S37C54v149Ev,
  (VTBL_ENTRY)&_ZN5S37C54v150Ev,
  (VTBL_ENTRY)&_ZN5S37C54v151Ev,
  (VTBL_ENTRY)&_ZN5S37C54v152Ev,
  (VTBL_ENTRY)&_ZN5S37C54v153Ev,
  (VTBL_ENTRY)&_ZN5S37C54v154Ev,
  (VTBL_ENTRY)&_ZN5S37C54v155Ev,
  (VTBL_ENTRY)&_ZN5S37C54v156Ev,
  (VTBL_ENTRY)&_ZN5S37C54v157Ev,
  (VTBL_ENTRY)&_ZN5S37C54v158Ev,
  (VTBL_ENTRY)&_ZN5S37C54v159Ev,
  (VTBL_ENTRY)&_ZN5S37C54v160Ev,
  (VTBL_ENTRY)&_ZN5S37C54v161Ev,
  (VTBL_ENTRY)&_ZN5S37C54v162Ev,
  (VTBL_ENTRY)&_ZN5S37C54v163Ev,
  (VTBL_ENTRY)&_ZN5S37C54v164Ev,
  (VTBL_ENTRY)&_ZN5S37C54v165Ev,
  (VTBL_ENTRY)&_ZN5S37C54v166Ev,
  (VTBL_ENTRY)&_ZN5S37C54v167Ev,
  (VTBL_ENTRY)&_ZN5S37C54v168Ev,
  (VTBL_ENTRY)&_ZN5S37C54v169Ev,
  (VTBL_ENTRY)&_ZN5S37C54v170Ev,
  (VTBL_ENTRY)&_ZN5S37C54v171Ev,
  (VTBL_ENTRY)&_ZN5S37C54v172Ev,
  (VTBL_ENTRY)&_ZN5S37C54v173Ev,
  (VTBL_ENTRY)&_ZN5S37C54v174Ev,
  (VTBL_ENTRY)&_ZN5S37C54v175Ev,
  (VTBL_ENTRY)&_ZN5S37C54v176Ev,
  (VTBL_ENTRY)&_ZN5S37C54v177Ev,
  (VTBL_ENTRY)&_ZN5S37C54v178Ev,
  (VTBL_ENTRY)&_ZN5S37C54v179Ev,
  (VTBL_ENTRY)&_ZN5S37C54v180Ev,
  (VTBL_ENTRY)&_ZN5S37C54v181Ev,
  (VTBL_ENTRY)&_ZN5S37C54v182Ev,
  (VTBL_ENTRY)&_ZN5S37C54v183Ev,
  (VTBL_ENTRY)&_ZN5S37C54v184Ev,
  (VTBL_ENTRY)&_ZN5S37C44v185Ev,
  (VTBL_ENTRY)&_ZN5S37C44v186Ev,
  (VTBL_ENTRY)&_ZN5S37C44v187Ev,
  (VTBL_ENTRY)&_ZN5S37C44v188Ev,
  (VTBL_ENTRY)&_ZN5S37C44v189Ev,
  (VTBL_ENTRY)&_ZN5S37C44v190Ev,
  (VTBL_ENTRY)&_ZN5S37C44v191Ev,
  (VTBL_ENTRY)&_ZN5S37C44v192Ev,
  (VTBL_ENTRY)&_ZN5S37C44v193Ev,
  (VTBL_ENTRY)&_ZN5S37C44v194Ev,
  (VTBL_ENTRY)&_ZN5S37C44v195Ev,
  (VTBL_ENTRY)&_ZN5S37C44v196Ev,
  (VTBL_ENTRY)&_ZN5S37C44v197Ev,
  (VTBL_ENTRY)&_ZN5S37C44v198Ev,
  (VTBL_ENTRY)&_ZN5S37C44v199Ev,
  (VTBL_ENTRY)&_ZN5S37C44v200Ev,
  (VTBL_ENTRY)&_ZN5S37C44v201Ev,
  (VTBL_ENTRY)&_ZN5S37C44v202Ev,
  (VTBL_ENTRY)&_ZN5S37C44v203Ev,
  (VTBL_ENTRY)&_ZN5S37C44v204Ev,
  (VTBL_ENTRY)&_ZN5S37C44v205Ev,
  (VTBL_ENTRY)&_ZN5S37C44v206Ev,
  (VTBL_ENTRY)&_ZN5S37C44v207Ev,
};
extern VTBL_ENTRY _ZTI5S37C4[];
extern  VTBL_ENTRY _ZTV5S37C4[];
Class_Descriptor cd_S37C4 = {  "S37C4", // class name
  bases_S37C4, 4,
  &(vtc_S37C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI5S37C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C4),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C3  : S37C4 {
  void *s37c3f0[2];
  int s37c3f1[2];
  char s37c3f2;
  void *s37c3f3;
  unsigned int s37c3f4:1;
  unsigned int s37c3f5:1;
  ::S80C28_nt s37c3f6;
  virtual  ~S37C3(); // _ZN5S37C3D1Ev
  virtual void  v208(); // _ZN5S37C34v208Ev
  virtual void  v209(); // _ZN5S37C34v209Ev
  virtual void  v210(); // _ZN5S37C34v210Ev
  virtual void  v211(); // _ZN5S37C34v211Ev
  virtual void  v212(); // _ZN5S37C34v212Ev
  virtual void  v213(); // _ZN5S37C34v213Ev
  virtual void  v214(); // _ZN5S37C34v214Ev
  virtual void  v215(); // _ZN5S37C34v215Ev
  S37C3(); // tgen
};
//SIG(-1 S37C3) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC21{ m Fi[2]}} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 FC7 Fp[9] FC22{ BC23{ BC11}} FC9 FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC21 FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC27{ BC16}}


 S37C3 ::~S37C3(){ note_dtor("S37C3", this);}
void  S37C3 ::v208(){vfunc_called(this, "_ZN5S37C34v208Ev");}
void  S37C3 ::v209(){vfunc_called(this, "_ZN5S37C34v209Ev");}
void  S37C3 ::v210(){vfunc_called(this, "_ZN5S37C34v210Ev");}
void  S37C3 ::v211(){vfunc_called(this, "_ZN5S37C34v211Ev");}
void  S37C3 ::v212(){vfunc_called(this, "_ZN5S37C34v212Ev");}
void  S37C3 ::v213(){vfunc_called(this, "_ZN5S37C34v213Ev");}
void  S37C3 ::v214(){vfunc_called(this, "_ZN5S37C34v214Ev");}
void  S37C3 ::v215(){vfunc_called(this, "_ZN5S37C34v215Ev");}
S37C3 ::S37C3(){ note_ctor("S37C3", this);} // tgen

static void Test_S37C3()
{
  extern Class_Descriptor cd_S37C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,165)];
    init_test(&cd_S37C3, buf);
    S37C3 *dp, &lv = *(dp=new (buf) S37C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,656), "sizeof(S37C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C3)");
    check_base_class_offset(lv, (S37C8*)(S37C7*)(S37C6*)(S37C5*)(S37C4*), 0, "S37C3");
    check_base_class_offset(lv, (S37C7*)(S37C6*)(S37C5*)(S37C4*), 0, "S37C3");
    check_base_class_offset(lv, (S37C6*)(S37C5*)(S37C4*), 0, "S37C3");
    check_base_class_offset(lv, (S37C5*)(S37C4*), 0, "S37C3");
    check_base_class_offset(lv, (S37C4*), 0, "S37C3");
    check_field_offset(lv, s37c3f0, ABISELECT(864,616), "S37C3.s37c3f0");
    check_field_offset(lv, s37c3f1, ABISELECT(880,624), "S37C3.s37c3f1");
    check_field_offset(lv, s37c3f2, ABISELECT(888,632), "S37C3.s37c3f2");
    check_field_offset(lv, s37c3f3, ABISELECT(896,636), "S37C3.s37c3f3");
    set_bf_and_test(lv, s37c3f4, ABISELECT(904,640), 0, 1, 1, "S37C3");
    set_bf_and_test(lv, s37c3f5, ABISELECT(904,640), 1, 1, 1, "S37C3");
    check_field_offset(lv, s37c3f6, ABISELECT(912,644), "S37C3.s37c3f6");
    test_class_info(&lv, &cd_S37C3);
    dp->~S37C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C3(Test_S37C3, "S37C3", ABISELECT(928,656));

#else // __cplusplus

extern void _ZN5S37C3C1Ev();
extern void _ZN5S37C3D1Ev();
Name_Map name_map_S37C3[] = {
  NSPAIR(_ZN5S37C3C1Ev),
  NSPAIR(_ZN5S37C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
extern Class_Descriptor cd_S37C6;
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
extern Class_Descriptor cd_S37C5;
extern VTBL_ENTRY _ZTI5S37C5[];
extern  VTBL_ENTRY _ZTV5S37C5[];
extern Class_Descriptor cd_S37C4;
extern VTBL_ENTRY _ZTI5S37C4[];
extern  VTBL_ENTRY _ZTV5S37C4[];
static Base_Class bases_S37C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S37C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S37C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S37C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C3[];
extern void _ZN5S37C3D1Ev();
extern void _ZN5S37C3D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
extern void _ZN5S37C54v146Ev();
extern void _ZN5S37C54v147Ev();
extern void _ZN5S37C54v148Ev();
extern void _ZN5S37C54v149Ev();
extern void _ZN5S37C54v150Ev();
extern void _ZN5S37C54v151Ev();
extern void _ZN5S37C54v152Ev();
extern void _ZN5S37C54v153Ev();
extern void _ZN5S37C54v154Ev();
extern void _ZN5S37C54v155Ev();
extern void _ZN5S37C54v156Ev();
extern void _ZN5S37C54v157Ev();
extern void _ZN5S37C54v158Ev();
extern void _ZN5S37C54v159Ev();
extern void _ZN5S37C54v160Ev();
extern void _ZN5S37C54v161Ev();
extern void _ZN5S37C54v162Ev();
extern void _ZN5S37C54v163Ev();
extern void _ZN5S37C54v164Ev();
extern void _ZN5S37C54v165Ev();
extern void _ZN5S37C54v166Ev();
extern void _ZN5S37C54v167Ev();
extern void _ZN5S37C54v168Ev();
extern void _ZN5S37C54v169Ev();
extern void _ZN5S37C54v170Ev();
extern void _ZN5S37C54v171Ev();
extern void _ZN5S37C54v172Ev();
extern void _ZN5S37C54v173Ev();
extern void _ZN5S37C54v174Ev();
extern void _ZN5S37C54v175Ev();
extern void _ZN5S37C54v176Ev();
extern void _ZN5S37C54v177Ev();
extern void _ZN5S37C54v178Ev();
extern void _ZN5S37C54v179Ev();
extern void _ZN5S37C54v180Ev();
extern void _ZN5S37C54v181Ev();
extern void _ZN5S37C54v182Ev();
extern void _ZN5S37C54v183Ev();
extern void _ZN5S37C54v184Ev();
extern void _ZN5S37C44v185Ev();
extern void _ZN5S37C44v186Ev();
extern void _ZN5S37C44v187Ev();
extern void _ZN5S37C44v188Ev();
extern void _ZN5S37C44v189Ev();
extern void _ZN5S37C44v190Ev();
extern void _ZN5S37C44v191Ev();
extern void _ZN5S37C44v192Ev();
extern void _ZN5S37C44v193Ev();
extern void _ZN5S37C44v194Ev();
extern void _ZN5S37C44v195Ev();
extern void _ZN5S37C44v196Ev();
extern void _ZN5S37C44v197Ev();
extern void _ZN5S37C44v198Ev();
extern void _ZN5S37C44v199Ev();
extern void _ZN5S37C44v200Ev();
extern void _ZN5S37C44v201Ev();
extern void _ZN5S37C44v202Ev();
extern void _ZN5S37C44v203Ev();
extern void _ZN5S37C44v204Ev();
extern void _ZN5S37C44v205Ev();
extern void _ZN5S37C44v206Ev();
extern void _ZN5S37C44v207Ev();
extern void _ZN5S37C34v208Ev();
extern void _ZN5S37C34v209Ev();
extern void _ZN5S37C34v210Ev();
extern void _ZN5S37C34v211Ev();
extern void _ZN5S37C34v212Ev();
extern void _ZN5S37C34v213Ev();
extern void _ZN5S37C34v214Ev();
extern void _ZN5S37C34v215Ev();
static  VTBL_ENTRY vtc_S37C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C3[0]),
  (VTBL_ENTRY)&_ZN5S37C3D1Ev,
  (VTBL_ENTRY)&_ZN5S37C3D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
  (VTBL_ENTRY)&_ZN5S37C54v146Ev,
  (VTBL_ENTRY)&_ZN5S37C54v147Ev,
  (VTBL_ENTRY)&_ZN5S37C54v148Ev,
  (VTBL_ENTRY)&_ZN5S37C54v149Ev,
  (VTBL_ENTRY)&_ZN5S37C54v150Ev,
  (VTBL_ENTRY)&_ZN5S37C54v151Ev,
  (VTBL_ENTRY)&_ZN5S37C54v152Ev,
  (VTBL_ENTRY)&_ZN5S37C54v153Ev,
  (VTBL_ENTRY)&_ZN5S37C54v154Ev,
  (VTBL_ENTRY)&_ZN5S37C54v155Ev,
  (VTBL_ENTRY)&_ZN5S37C54v156Ev,
  (VTBL_ENTRY)&_ZN5S37C54v157Ev,
  (VTBL_ENTRY)&_ZN5S37C54v158Ev,
  (VTBL_ENTRY)&_ZN5S37C54v159Ev,
  (VTBL_ENTRY)&_ZN5S37C54v160Ev,
  (VTBL_ENTRY)&_ZN5S37C54v161Ev,
  (VTBL_ENTRY)&_ZN5S37C54v162Ev,
  (VTBL_ENTRY)&_ZN5S37C54v163Ev,
  (VTBL_ENTRY)&_ZN5S37C54v164Ev,
  (VTBL_ENTRY)&_ZN5S37C54v165Ev,
  (VTBL_ENTRY)&_ZN5S37C54v166Ev,
  (VTBL_ENTRY)&_ZN5S37C54v167Ev,
  (VTBL_ENTRY)&_ZN5S37C54v168Ev,
  (VTBL_ENTRY)&_ZN5S37C54v169Ev,
  (VTBL_ENTRY)&_ZN5S37C54v170Ev,
  (VTBL_ENTRY)&_ZN5S37C54v171Ev,
  (VTBL_ENTRY)&_ZN5S37C54v172Ev,
  (VTBL_ENTRY)&_ZN5S37C54v173Ev,
  (VTBL_ENTRY)&_ZN5S37C54v174Ev,
  (VTBL_ENTRY)&_ZN5S37C54v175Ev,
  (VTBL_ENTRY)&_ZN5S37C54v176Ev,
  (VTBL_ENTRY)&_ZN5S37C54v177Ev,
  (VTBL_ENTRY)&_ZN5S37C54v178Ev,
  (VTBL_ENTRY)&_ZN5S37C54v179Ev,
  (VTBL_ENTRY)&_ZN5S37C54v180Ev,
  (VTBL_ENTRY)&_ZN5S37C54v181Ev,
  (VTBL_ENTRY)&_ZN5S37C54v182Ev,
  (VTBL_ENTRY)&_ZN5S37C54v183Ev,
  (VTBL_ENTRY)&_ZN5S37C54v184Ev,
  (VTBL_ENTRY)&_ZN5S37C44v185Ev,
  (VTBL_ENTRY)&_ZN5S37C44v186Ev,
  (VTBL_ENTRY)&_ZN5S37C44v187Ev,
  (VTBL_ENTRY)&_ZN5S37C44v188Ev,
  (VTBL_ENTRY)&_ZN5S37C44v189Ev,
  (VTBL_ENTRY)&_ZN5S37C44v190Ev,
  (VTBL_ENTRY)&_ZN5S37C44v191Ev,
  (VTBL_ENTRY)&_ZN5S37C44v192Ev,
  (VTBL_ENTRY)&_ZN5S37C44v193Ev,
  (VTBL_ENTRY)&_ZN5S37C44v194Ev,
  (VTBL_ENTRY)&_ZN5S37C44v195Ev,
  (VTBL_ENTRY)&_ZN5S37C44v196Ev,
  (VTBL_ENTRY)&_ZN5S37C44v197Ev,
  (VTBL_ENTRY)&_ZN5S37C44v198Ev,
  (VTBL_ENTRY)&_ZN5S37C44v199Ev,
  (VTBL_ENTRY)&_ZN5S37C44v200Ev,
  (VTBL_ENTRY)&_ZN5S37C44v201Ev,
  (VTBL_ENTRY)&_ZN5S37C44v202Ev,
  (VTBL_ENTRY)&_ZN5S37C44v203Ev,
  (VTBL_ENTRY)&_ZN5S37C44v204Ev,
  (VTBL_ENTRY)&_ZN5S37C44v205Ev,
  (VTBL_ENTRY)&_ZN5S37C44v206Ev,
  (VTBL_ENTRY)&_ZN5S37C44v207Ev,
  (VTBL_ENTRY)&_ZN5S37C34v208Ev,
  (VTBL_ENTRY)&_ZN5S37C34v209Ev,
  (VTBL_ENTRY)&_ZN5S37C34v210Ev,
  (VTBL_ENTRY)&_ZN5S37C34v211Ev,
  (VTBL_ENTRY)&_ZN5S37C34v212Ev,
  (VTBL_ENTRY)&_ZN5S37C34v213Ev,
  (VTBL_ENTRY)&_ZN5S37C34v214Ev,
  (VTBL_ENTRY)&_ZN5S37C34v215Ev,
};
extern VTBL_ENTRY _ZTI5S37C3[];
extern  VTBL_ENTRY _ZTV5S37C3[];
Class_Descriptor cd_S37C3 = {  "S37C3", // class name
  bases_S37C3, 5,
  &(vtc_S37C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,656), // object size
  NSPAIRA(_ZTI5S37C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C3),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C2  : S37C3 {
  void *s37c2f0[2];
  unsigned int s37c2f1:1;
  ::S80C10_nt s37c2f2;
  virtual  ~S37C2(); // _ZN5S37C2D1Ev
  virtual void  v216(); // _ZN5S37C24v216Ev
  virtual void  v217(); // _ZN5S37C24v217Ev
  S37C2(); // tgen
};
//SIG(-1 S37C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v67 v68} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC22{ m Fi[2]}} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 FC8 Fp[9] FC23{ BC24{ BC12}} FC10 FC25{ BC26{ m FC27{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC22 FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v207 v208 v209 v210 v211 v212 v213 v214 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC28{ BC17}} vd v1 v2 Fp[2] Fi:1 FC29{ BC30{ BC12}}}


 S37C2 ::~S37C2(){ note_dtor("S37C2", this);}
void  S37C2 ::v216(){vfunc_called(this, "_ZN5S37C24v216Ev");}
void  S37C2 ::v217(){vfunc_called(this, "_ZN5S37C24v217Ev");}
S37C2 ::S37C2(){ note_ctor("S37C2", this);} // tgen

static void Test_S37C2()
{
  extern Class_Descriptor cd_S37C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(122,171)];
    init_test(&cd_S37C2, buf);
    S37C2 *dp, &lv = *(dp=new (buf) S37C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(968,680), "sizeof(S37C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C2)");
    check_base_class_offset(lv, (S37C8*)(S37C7*)(S37C6*)(S37C5*)(S37C4*)(S37C3*), 0, "S37C2");
    check_base_class_offset(lv, (S37C7*)(S37C6*)(S37C5*)(S37C4*)(S37C3*), 0, "S37C2");
    check_base_class_offset(lv, (S37C6*)(S37C5*)(S37C4*)(S37C3*), 0, "S37C2");
    check_base_class_offset(lv, (S37C5*)(S37C4*)(S37C3*), 0, "S37C2");
    check_base_class_offset(lv, (S37C4*)(S37C3*), 0, "S37C2");
    check_base_class_offset(lv, (S37C3*), 0, "S37C2");
    check_field_offset(lv, s37c2f0, ABISELECT(928,656), "S37C2.s37c2f0");
    set_bf_and_test(lv, s37c2f1, ABISELECT(944,664), 0, 1, 1, "S37C2");
    check_field_offset(lv, s37c2f2, ABISELECT(952,668), "S37C2.s37c2f2");
    test_class_info(&lv, &cd_S37C2);
    dp->~S37C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C2(Test_S37C2, "S37C2", ABISELECT(968,680));

#else // __cplusplus

extern void _ZN5S37C2C1Ev();
extern void _ZN5S37C2D1Ev();
Name_Map name_map_S37C2[] = {
  NSPAIR(_ZN5S37C2C1Ev),
  NSPAIR(_ZN5S37C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
extern Class_Descriptor cd_S37C6;
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
extern Class_Descriptor cd_S37C5;
extern VTBL_ENTRY _ZTI5S37C5[];
extern  VTBL_ENTRY _ZTV5S37C5[];
extern Class_Descriptor cd_S37C4;
extern VTBL_ENTRY _ZTI5S37C4[];
extern  VTBL_ENTRY _ZTV5S37C4[];
extern Class_Descriptor cd_S37C3;
extern VTBL_ENTRY _ZTI5S37C3[];
extern  VTBL_ENTRY _ZTV5S37C3[];
static Base_Class bases_S37C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S37C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S37C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S37C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S37C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C2[];
extern void _ZN5S37C2D1Ev();
extern void _ZN5S37C2D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
extern void _ZN5S37C54v146Ev();
extern void _ZN5S37C54v147Ev();
extern void _ZN5S37C54v148Ev();
extern void _ZN5S37C54v149Ev();
extern void _ZN5S37C54v150Ev();
extern void _ZN5S37C54v151Ev();
extern void _ZN5S37C54v152Ev();
extern void _ZN5S37C54v153Ev();
extern void _ZN5S37C54v154Ev();
extern void _ZN5S37C54v155Ev();
extern void _ZN5S37C54v156Ev();
extern void _ZN5S37C54v157Ev();
extern void _ZN5S37C54v158Ev();
extern void _ZN5S37C54v159Ev();
extern void _ZN5S37C54v160Ev();
extern void _ZN5S37C54v161Ev();
extern void _ZN5S37C54v162Ev();
extern void _ZN5S37C54v163Ev();
extern void _ZN5S37C54v164Ev();
extern void _ZN5S37C54v165Ev();
extern void _ZN5S37C54v166Ev();
extern void _ZN5S37C54v167Ev();
extern void _ZN5S37C54v168Ev();
extern void _ZN5S37C54v169Ev();
extern void _ZN5S37C54v170Ev();
extern void _ZN5S37C54v171Ev();
extern void _ZN5S37C54v172Ev();
extern void _ZN5S37C54v173Ev();
extern void _ZN5S37C54v174Ev();
extern void _ZN5S37C54v175Ev();
extern void _ZN5S37C54v176Ev();
extern void _ZN5S37C54v177Ev();
extern void _ZN5S37C54v178Ev();
extern void _ZN5S37C54v179Ev();
extern void _ZN5S37C54v180Ev();
extern void _ZN5S37C54v181Ev();
extern void _ZN5S37C54v182Ev();
extern void _ZN5S37C54v183Ev();
extern void _ZN5S37C54v184Ev();
extern void _ZN5S37C44v185Ev();
extern void _ZN5S37C44v186Ev();
extern void _ZN5S37C44v187Ev();
extern void _ZN5S37C44v188Ev();
extern void _ZN5S37C44v189Ev();
extern void _ZN5S37C44v190Ev();
extern void _ZN5S37C44v191Ev();
extern void _ZN5S37C44v192Ev();
extern void _ZN5S37C44v193Ev();
extern void _ZN5S37C44v194Ev();
extern void _ZN5S37C44v195Ev();
extern void _ZN5S37C44v196Ev();
extern void _ZN5S37C44v197Ev();
extern void _ZN5S37C44v198Ev();
extern void _ZN5S37C44v199Ev();
extern void _ZN5S37C44v200Ev();
extern void _ZN5S37C44v201Ev();
extern void _ZN5S37C44v202Ev();
extern void _ZN5S37C44v203Ev();
extern void _ZN5S37C44v204Ev();
extern void _ZN5S37C44v205Ev();
extern void _ZN5S37C44v206Ev();
extern void _ZN5S37C44v207Ev();
extern void _ZN5S37C34v208Ev();
extern void _ZN5S37C34v209Ev();
extern void _ZN5S37C34v210Ev();
extern void _ZN5S37C34v211Ev();
extern void _ZN5S37C34v212Ev();
extern void _ZN5S37C34v213Ev();
extern void _ZN5S37C34v214Ev();
extern void _ZN5S37C34v215Ev();
extern void _ZN5S37C24v216Ev();
extern void _ZN5S37C24v217Ev();
static  VTBL_ENTRY vtc_S37C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C2[0]),
  (VTBL_ENTRY)&_ZN5S37C2D1Ev,
  (VTBL_ENTRY)&_ZN5S37C2D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
  (VTBL_ENTRY)&_ZN5S37C54v146Ev,
  (VTBL_ENTRY)&_ZN5S37C54v147Ev,
  (VTBL_ENTRY)&_ZN5S37C54v148Ev,
  (VTBL_ENTRY)&_ZN5S37C54v149Ev,
  (VTBL_ENTRY)&_ZN5S37C54v150Ev,
  (VTBL_ENTRY)&_ZN5S37C54v151Ev,
  (VTBL_ENTRY)&_ZN5S37C54v152Ev,
  (VTBL_ENTRY)&_ZN5S37C54v153Ev,
  (VTBL_ENTRY)&_ZN5S37C54v154Ev,
  (VTBL_ENTRY)&_ZN5S37C54v155Ev,
  (VTBL_ENTRY)&_ZN5S37C54v156Ev,
  (VTBL_ENTRY)&_ZN5S37C54v157Ev,
  (VTBL_ENTRY)&_ZN5S37C54v158Ev,
  (VTBL_ENTRY)&_ZN5S37C54v159Ev,
  (VTBL_ENTRY)&_ZN5S37C54v160Ev,
  (VTBL_ENTRY)&_ZN5S37C54v161Ev,
  (VTBL_ENTRY)&_ZN5S37C54v162Ev,
  (VTBL_ENTRY)&_ZN5S37C54v163Ev,
  (VTBL_ENTRY)&_ZN5S37C54v164Ev,
  (VTBL_ENTRY)&_ZN5S37C54v165Ev,
  (VTBL_ENTRY)&_ZN5S37C54v166Ev,
  (VTBL_ENTRY)&_ZN5S37C54v167Ev,
  (VTBL_ENTRY)&_ZN5S37C54v168Ev,
  (VTBL_ENTRY)&_ZN5S37C54v169Ev,
  (VTBL_ENTRY)&_ZN5S37C54v170Ev,
  (VTBL_ENTRY)&_ZN5S37C54v171Ev,
  (VTBL_ENTRY)&_ZN5S37C54v172Ev,
  (VTBL_ENTRY)&_ZN5S37C54v173Ev,
  (VTBL_ENTRY)&_ZN5S37C54v174Ev,
  (VTBL_ENTRY)&_ZN5S37C54v175Ev,
  (VTBL_ENTRY)&_ZN5S37C54v176Ev,
  (VTBL_ENTRY)&_ZN5S37C54v177Ev,
  (VTBL_ENTRY)&_ZN5S37C54v178Ev,
  (VTBL_ENTRY)&_ZN5S37C54v179Ev,
  (VTBL_ENTRY)&_ZN5S37C54v180Ev,
  (VTBL_ENTRY)&_ZN5S37C54v181Ev,
  (VTBL_ENTRY)&_ZN5S37C54v182Ev,
  (VTBL_ENTRY)&_ZN5S37C54v183Ev,
  (VTBL_ENTRY)&_ZN5S37C54v184Ev,
  (VTBL_ENTRY)&_ZN5S37C44v185Ev,
  (VTBL_ENTRY)&_ZN5S37C44v186Ev,
  (VTBL_ENTRY)&_ZN5S37C44v187Ev,
  (VTBL_ENTRY)&_ZN5S37C44v188Ev,
  (VTBL_ENTRY)&_ZN5S37C44v189Ev,
  (VTBL_ENTRY)&_ZN5S37C44v190Ev,
  (VTBL_ENTRY)&_ZN5S37C44v191Ev,
  (VTBL_ENTRY)&_ZN5S37C44v192Ev,
  (VTBL_ENTRY)&_ZN5S37C44v193Ev,
  (VTBL_ENTRY)&_ZN5S37C44v194Ev,
  (VTBL_ENTRY)&_ZN5S37C44v195Ev,
  (VTBL_ENTRY)&_ZN5S37C44v196Ev,
  (VTBL_ENTRY)&_ZN5S37C44v197Ev,
  (VTBL_ENTRY)&_ZN5S37C44v198Ev,
  (VTBL_ENTRY)&_ZN5S37C44v199Ev,
  (VTBL_ENTRY)&_ZN5S37C44v200Ev,
  (VTBL_ENTRY)&_ZN5S37C44v201Ev,
  (VTBL_ENTRY)&_ZN5S37C44v202Ev,
  (VTBL_ENTRY)&_ZN5S37C44v203Ev,
  (VTBL_ENTRY)&_ZN5S37C44v204Ev,
  (VTBL_ENTRY)&_ZN5S37C44v205Ev,
  (VTBL_ENTRY)&_ZN5S37C44v206Ev,
  (VTBL_ENTRY)&_ZN5S37C44v207Ev,
  (VTBL_ENTRY)&_ZN5S37C34v208Ev,
  (VTBL_ENTRY)&_ZN5S37C34v209Ev,
  (VTBL_ENTRY)&_ZN5S37C34v210Ev,
  (VTBL_ENTRY)&_ZN5S37C34v211Ev,
  (VTBL_ENTRY)&_ZN5S37C34v212Ev,
  (VTBL_ENTRY)&_ZN5S37C34v213Ev,
  (VTBL_ENTRY)&_ZN5S37C34v214Ev,
  (VTBL_ENTRY)&_ZN5S37C34v215Ev,
  (VTBL_ENTRY)&_ZN5S37C24v216Ev,
  (VTBL_ENTRY)&_ZN5S37C24v217Ev,
};
extern VTBL_ENTRY _ZTI5S37C2[];
extern  VTBL_ENTRY _ZTV5S37C2[];
Class_Descriptor cd_S37C2 = {  "S37C2", // class name
  bases_S37C2, 6,
  &(vtc_S37C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(968,680), // object size
  NSPAIRA(_ZTI5S37C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C2),218, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C35  : S80C12_nt {
};
//SIG(-1 S37C35) C1{ BC2{ m Fp Fi[2]}}



static void Test_S37C35()
{
  extern Class_Descriptor cd_S37C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S37C35, buf);
    S37C35 &lv = *(new (buf) S37C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S37C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C35)");
    check_base_class_offset(lv, (S80C12_nt*), 0, "S37C35");
    test_class_info(&lv, &cd_S37C35);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C35(Test_S37C35, "S37C35", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
static Base_Class bases_S37C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S37C35 = {  "S37C35", // class name
  bases_S37C35, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C34_nt  : S37C35 {
};
//SIG(-1 S37C34_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S37C34_nt

#else // __cplusplus

extern Class_Descriptor cd_S80C12_nt;
extern Class_Descriptor cd_S37C35;
static Base_Class bases_S37C34_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S80C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S37C1  : S37C2 {
  ::S80C28_nt s37c1f0;
  void *s37c1f1[6];
  char s37c1f2;
  unsigned int s37c1f3:1;
  unsigned int s37c1f4:1;
  unsigned int s37c1f5:1;
  ::S37C34_nt s37c1f6;
  virtual  ~S37C1(); // _ZN5S37C1D1Ev
  virtual void  v1(); // _ZN5S37C12v1Ev
  virtual void  v2(); // _ZN5S37C12v2Ev
  virtual void  v3(); // _ZN5S37C12v3Ev
  S37C1(); // tgen
};
//SIG(1 S37C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ BC8{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC9{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC10{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC13{ m Fp Fi[2]}}} FC14{ BC15{ BC13}} Fp FC16{ BC17{ BC13}} FC16 FC18{ BC19{ BC13}} FC20{ BC21{ BC13}} Fc Fi Fp FC9 FC9 FC9 FC9 FC9 FC9 FC22{ m Fp FC23{ m Fi[2]}} FC22 FC22 FC22 FC22 FC22 FC22 FC22 FC22 FC22} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 FC9 Fp[9] FC24{ BC25{ BC13}} FC11 FC26{ BC27{ m FC28{ BC13} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC23 FC9 FC9 Fp FC22 FC22 FC22 FC22 FC22} vd v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC22 FC22 FC22} vd v208 v209 v210 v211 v212 v213 v214 v215 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC29{ BC18}} vd v216 v217 Fp[2] Fi:1 FC30{ BC31{ BC13}}} vd v1 v2 v3 FC29 Fp[6] Fc Fi:1 Fi:1 Fi:1 FC32{ BC33{ BC13}}}


 S37C1 ::~S37C1(){ note_dtor("S37C1", this);}
void  S37C1 ::v1(){vfunc_called(this, "_ZN5S37C12v1Ev");}
void  S37C1 ::v2(){vfunc_called(this, "_ZN5S37C12v2Ev");}
void  S37C1 ::v3(){vfunc_called(this, "_ZN5S37C12v3Ev");}
S37C1 ::S37C1(){ note_ctor("S37C1", this);} // tgen

static void Test_S37C1()
{
  extern Class_Descriptor cd_S37C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(133,184)];
    init_test(&cd_S37C1, buf);
    S37C1 *dp, &lv = *(dp=new (buf) S37C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1056,732), "sizeof(S37C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S37C1)");
    check_base_class_offset(lv, (S37C8*)(S37C7*)(S37C6*)(S37C5*)(S37C4*)(S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C7*)(S37C6*)(S37C5*)(S37C4*)(S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C6*)(S37C5*)(S37C4*)(S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C5*)(S37C4*)(S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C4*)(S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C3*)(S37C2*), 0, "S37C1");
    check_base_class_offset(lv, (S37C2*), 0, "S37C1");
    check_field_offset(lv, s37c1f0, ABISELECT(968,680), "S37C1.s37c1f0");
    check_field_offset(lv, s37c1f1, ABISELECT(984,692), "S37C1.s37c1f1");
    check_field_offset(lv, s37c1f2, ABISELECT(1032,716), "S37C1.s37c1f2");
    set_bf_and_test(lv, s37c1f3, ABISELECT(1033,717), 0, 1, 1, "S37C1");
    set_bf_and_test(lv, s37c1f4, ABISELECT(1033,717), 1, 1, 1, "S37C1");
    set_bf_and_test(lv, s37c1f5, ABISELECT(1033,717), 2, 1, 1, "S37C1");
    check_field_offset(lv, s37c1f6, ABISELECT(1040,720), "S37C1.s37c1f6");
    test_class_info(&lv, &cd_S37C1);
    dp->~S37C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS37C1(Test_S37C1, "S37C1", ABISELECT(1056,732));

#else // __cplusplus

extern void _ZN5S37C1C1Ev();
extern void _ZN5S37C1D1Ev();
Name_Map name_map_S37C1[] = {
  NSPAIR(_ZN5S37C1C1Ev),
  NSPAIR(_ZN5S37C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S37C8;
extern VTBL_ENTRY _ZTI5S37C8[];
extern  VTBL_ENTRY _ZTV5S37C8[];
extern Class_Descriptor cd_S37C7;
extern VTBL_ENTRY _ZTI5S37C7[];
extern  VTBL_ENTRY _ZTV5S37C7[];
extern Class_Descriptor cd_S37C6;
extern VTBL_ENTRY _ZTI5S37C6[];
extern  VTBL_ENTRY _ZTV5S37C6[];
extern Class_Descriptor cd_S37C5;
extern VTBL_ENTRY _ZTI5S37C5[];
extern  VTBL_ENTRY _ZTV5S37C5[];
extern Class_Descriptor cd_S37C4;
extern VTBL_ENTRY _ZTI5S37C4[];
extern  VTBL_ENTRY _ZTV5S37C4[];
extern Class_Descriptor cd_S37C3;
extern VTBL_ENTRY _ZTI5S37C3[];
extern  VTBL_ENTRY _ZTV5S37C3[];
extern Class_Descriptor cd_S37C2;
extern VTBL_ENTRY _ZTI5S37C2[];
extern  VTBL_ENTRY _ZTV5S37C2[];
static Base_Class bases_S37C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S37C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S37C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S37C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S37C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S37C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S37C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S37C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S37C1[];
extern void _ZN5S37C1D1Ev();
extern void _ZN5S37C1D0Ev();
extern void _ZN5S37C82v4Ev();
extern void _ZN5S37C82v5Ev();
extern void _ZN5S37C82v6Ev();
extern void _ZN5S37C82v7Ev();
extern void _ZN5S37C82v8Ev();
extern void _ZN5S37C82v9Ev();
extern void _ZN5S37C83v10Ev();
extern void _ZN5S37C83v11Ev();
extern void _ZN5S37C83v12Ev();
extern void _ZN5S37C83v13Ev();
extern void _ZN5S37C83v14Ev();
extern void _ZN5S37C83v15Ev();
extern void _ZN5S37C83v16Ev();
extern void _ZN5S37C83v17Ev();
extern void _ZN5S37C83v18Ev();
extern void _ZN5S37C83v19Ev();
extern void _ZN5S37C83v20Ev();
extern void _ZN5S37C83v21Ev();
extern void _ZN5S37C83v22Ev();
extern void _ZN5S37C83v23Ev();
extern void _ZN5S37C83v24Ev();
extern void _ZN5S37C83v25Ev();
extern void _ZN5S37C83v26Ev();
extern void _ZN5S37C83v27Ev();
extern void _ZN5S37C83v28Ev();
extern void _ZN5S37C83v29Ev();
extern void _ZN5S37C83v30Ev();
extern void _ZN5S37C83v31Ev();
extern void _ZN5S37C83v32Ev();
extern void _ZN5S37C83v33Ev();
extern void _ZN5S37C83v34Ev();
extern void _ZN5S37C83v35Ev();
extern void _ZN5S37C83v36Ev();
extern void _ZN5S37C83v37Ev();
extern void _ZN5S37C83v38Ev();
extern void _ZN5S37C83v39Ev();
extern void _ZN5S37C83v40Ev();
extern void _ZN5S37C83v41Ev();
extern void _ZN5S37C83v42Ev();
extern void _ZN5S37C83v43Ev();
extern void _ZN5S37C83v44Ev();
extern void _ZN5S37C83v45Ev();
extern void _ZN5S37C83v46Ev();
extern void _ZN5S37C83v47Ev();
extern void _ZN5S37C83v48Ev();
extern void _ZN5S37C83v49Ev();
extern void _ZN5S37C83v50Ev();
extern void _ZN5S37C83v51Ev();
extern void _ZN5S37C83v52Ev();
extern void _ZN5S37C83v53Ev();
extern void _ZN5S37C83v54Ev();
extern void _ZN5S37C83v55Ev();
extern void _ZN5S37C83v56Ev();
extern void _ZN5S37C83v57Ev();
extern void _ZN5S37C83v58Ev();
extern void _ZN5S37C83v59Ev();
extern void _ZN5S37C83v60Ev();
extern void _ZN5S37C83v61Ev();
extern void _ZN5S37C83v62Ev();
extern void _ZN5S37C83v63Ev();
extern void _ZN5S37C83v64Ev();
extern void _ZN5S37C83v65Ev();
extern void _ZN5S37C83v66Ev();
extern void _ZN5S37C83v67Ev();
extern void _ZN5S37C73v68Ev();
extern void _ZN5S37C73v69Ev();
extern void _ZN5S37C63v70Ev();
extern void _ZN5S37C63v71Ev();
extern void _ZN5S37C63v72Ev();
extern void _ZN5S37C63v73Ev();
extern void _ZN5S37C63v74Ev();
extern void _ZN5S37C63v75Ev();
extern void _ZN5S37C63v76Ev();
extern void _ZN5S37C63v77Ev();
extern void _ZN5S37C63v78Ev();
extern void _ZN5S37C63v79Ev();
extern void _ZN5S37C63v80Ev();
extern void _ZN5S37C63v81Ev();
extern void _ZN5S37C63v82Ev();
extern void _ZN5S37C63v83Ev();
extern void _ZN5S37C63v84Ev();
extern void _ZN5S37C63v85Ev();
extern void _ZN5S37C63v86Ev();
extern void _ZN5S37C63v87Ev();
extern void _ZN5S37C63v88Ev();
extern void _ZN5S37C63v89Ev();
extern void _ZN5S37C63v90Ev();
extern void _ZN5S37C63v91Ev();
extern void _ZN5S37C63v92Ev();
extern void _ZN5S37C63v93Ev();
extern void _ZN5S37C63v94Ev();
extern void _ZN5S37C63v95Ev();
extern void _ZN5S37C63v96Ev();
extern void _ZN5S37C63v97Ev();
extern void _ZN5S37C63v98Ev();
extern void _ZN5S37C63v99Ev();
extern void _ZN5S37C64v100Ev();
extern void _ZN5S37C64v101Ev();
extern void _ZN5S37C64v102Ev();
extern void _ZN5S37C64v103Ev();
extern void _ZN5S37C64v104Ev();
extern void _ZN5S37C64v105Ev();
extern void _ZN5S37C64v106Ev();
extern void _ZN5S37C64v107Ev();
extern void _ZN5S37C64v108Ev();
extern void _ZN5S37C64v109Ev();
extern void _ZN5S37C64v110Ev();
extern void _ZN5S37C64v111Ev();
extern void _ZN5S37C64v112Ev();
extern void _ZN5S37C64v113Ev();
extern void _ZN5S37C64v114Ev();
extern void _ZN5S37C64v115Ev();
extern void _ZN5S37C64v116Ev();
extern void _ZN5S37C64v117Ev();
extern void _ZN5S37C64v118Ev();
extern void _ZN5S37C64v119Ev();
extern void _ZN5S37C64v120Ev();
extern void _ZN5S37C64v121Ev();
extern void _ZN5S37C64v122Ev();
extern void _ZN5S37C64v123Ev();
extern void _ZN5S37C64v124Ev();
extern void _ZN5S37C64v125Ev();
extern void _ZN5S37C64v126Ev();
extern void _ZN5S37C64v127Ev();
extern void _ZN5S37C64v128Ev();
extern void _ZN5S37C64v129Ev();
extern void _ZN5S37C64v130Ev();
extern void _ZN5S37C64v131Ev();
extern void _ZN5S37C64v132Ev();
extern void _ZN5S37C64v133Ev();
extern void _ZN5S37C64v134Ev();
extern void _ZN5S37C64v135Ev();
extern void _ZN5S37C64v136Ev();
extern void _ZN5S37C64v137Ev();
extern void _ZN5S37C64v138Ev();
extern void _ZN5S37C64v139Ev();
extern void _ZN5S37C64v140Ev();
extern void _ZN5S37C64v141Ev();
extern void _ZN5S37C64v142Ev();
extern void _ZN5S37C64v143Ev();
extern void _ZN5S37C64v144Ev();
extern void _ZN5S37C64v145Ev();
extern void _ZN5S37C54v146Ev();
extern void _ZN5S37C54v147Ev();
extern void _ZN5S37C54v148Ev();
extern void _ZN5S37C54v149Ev();
extern void _ZN5S37C54v150Ev();
extern void _ZN5S37C54v151Ev();
extern void _ZN5S37C54v152Ev();
extern void _ZN5S37C54v153Ev();
extern void _ZN5S37C54v154Ev();
extern void _ZN5S37C54v155Ev();
extern void _ZN5S37C54v156Ev();
extern void _ZN5S37C54v157Ev();
extern void _ZN5S37C54v158Ev();
extern void _ZN5S37C54v159Ev();
extern void _ZN5S37C54v160Ev();
extern void _ZN5S37C54v161Ev();
extern void _ZN5S37C54v162Ev();
extern void _ZN5S37C54v163Ev();
extern void _ZN5S37C54v164Ev();
extern void _ZN5S37C54v165Ev();
extern void _ZN5S37C54v166Ev();
extern void _ZN5S37C54v167Ev();
extern void _ZN5S37C54v168Ev();
extern void _ZN5S37C54v169Ev();
extern void _ZN5S37C54v170Ev();
extern void _ZN5S37C54v171Ev();
extern void _ZN5S37C54v172Ev();
extern void _ZN5S37C54v173Ev();
extern void _ZN5S37C54v174Ev();
extern void _ZN5S37C54v175Ev();
extern void _ZN5S37C54v176Ev();
extern void _ZN5S37C54v177Ev();
extern void _ZN5S37C54v178Ev();
extern void _ZN5S37C54v179Ev();
extern void _ZN5S37C54v180Ev();
extern void _ZN5S37C54v181Ev();
extern void _ZN5S37C54v182Ev();
extern void _ZN5S37C54v183Ev();
extern void _ZN5S37C54v184Ev();
extern void _ZN5S37C44v185Ev();
extern void _ZN5S37C44v186Ev();
extern void _ZN5S37C44v187Ev();
extern void _ZN5S37C44v188Ev();
extern void _ZN5S37C44v189Ev();
extern void _ZN5S37C44v190Ev();
extern void _ZN5S37C44v191Ev();
extern void _ZN5S37C44v192Ev();
extern void _ZN5S37C44v193Ev();
extern void _ZN5S37C44v194Ev();
extern void _ZN5S37C44v195Ev();
extern void _ZN5S37C44v196Ev();
extern void _ZN5S37C44v197Ev();
extern void _ZN5S37C44v198Ev();
extern void _ZN5S37C44v199Ev();
extern void _ZN5S37C44v200Ev();
extern void _ZN5S37C44v201Ev();
extern void _ZN5S37C44v202Ev();
extern void _ZN5S37C44v203Ev();
extern void _ZN5S37C44v204Ev();
extern void _ZN5S37C44v205Ev();
extern void _ZN5S37C44v206Ev();
extern void _ZN5S37C44v207Ev();
extern void _ZN5S37C34v208Ev();
extern void _ZN5S37C34v209Ev();
extern void _ZN5S37C34v210Ev();
extern void _ZN5S37C34v211Ev();
extern void _ZN5S37C34v212Ev();
extern void _ZN5S37C34v213Ev();
extern void _ZN5S37C34v214Ev();
extern void _ZN5S37C34v215Ev();
extern void _ZN5S37C24v216Ev();
extern void _ZN5S37C24v217Ev();
extern void _ZN5S37C12v1Ev();
extern void _ZN5S37C12v2Ev();
extern void _ZN5S37C12v3Ev();
static  VTBL_ENTRY vtc_S37C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S37C1[0]),
  (VTBL_ENTRY)&_ZN5S37C1D1Ev,
  (VTBL_ENTRY)&_ZN5S37C1D0Ev,
  (VTBL_ENTRY)&_ZN5S37C82v4Ev,
  (VTBL_ENTRY)&_ZN5S37C82v5Ev,
  (VTBL_ENTRY)&_ZN5S37C82v6Ev,
  (VTBL_ENTRY)&_ZN5S37C82v7Ev,
  (VTBL_ENTRY)&_ZN5S37C82v8Ev,
  (VTBL_ENTRY)&_ZN5S37C82v9Ev,
  (VTBL_ENTRY)&_ZN5S37C83v10Ev,
  (VTBL_ENTRY)&_ZN5S37C83v11Ev,
  (VTBL_ENTRY)&_ZN5S37C83v12Ev,
  (VTBL_ENTRY)&_ZN5S37C83v13Ev,
  (VTBL_ENTRY)&_ZN5S37C83v14Ev,
  (VTBL_ENTRY)&_ZN5S37C83v15Ev,
  (VTBL_ENTRY)&_ZN5S37C83v16Ev,
  (VTBL_ENTRY)&_ZN5S37C83v17Ev,
  (VTBL_ENTRY)&_ZN5S37C83v18Ev,
  (VTBL_ENTRY)&_ZN5S37C83v19Ev,
  (VTBL_ENTRY)&_ZN5S37C83v20Ev,
  (VTBL_ENTRY)&_ZN5S37C83v21Ev,
  (VTBL_ENTRY)&_ZN5S37C83v22Ev,
  (VTBL_ENTRY)&_ZN5S37C83v23Ev,
  (VTBL_ENTRY)&_ZN5S37C83v24Ev,
  (VTBL_ENTRY)&_ZN5S37C83v25Ev,
  (VTBL_ENTRY)&_ZN5S37C83v26Ev,
  (VTBL_ENTRY)&_ZN5S37C83v27Ev,
  (VTBL_ENTRY)&_ZN5S37C83v28Ev,
  (VTBL_ENTRY)&_ZN5S37C83v29Ev,
  (VTBL_ENTRY)&_ZN5S37C83v30Ev,
  (VTBL_ENTRY)&_ZN5S37C83v31Ev,
  (VTBL_ENTRY)&_ZN5S37C83v32Ev,
  (VTBL_ENTRY)&_ZN5S37C83v33Ev,
  (VTBL_ENTRY)&_ZN5S37C83v34Ev,
  (VTBL_ENTRY)&_ZN5S37C83v35Ev,
  (VTBL_ENTRY)&_ZN5S37C83v36Ev,
  (VTBL_ENTRY)&_ZN5S37C83v37Ev,
  (VTBL_ENTRY)&_ZN5S37C83v38Ev,
  (VTBL_ENTRY)&_ZN5S37C83v39Ev,
  (VTBL_ENTRY)&_ZN5S37C83v40Ev,
  (VTBL_ENTRY)&_ZN5S37C83v41Ev,
  (VTBL_ENTRY)&_ZN5S37C83v42Ev,
  (VTBL_ENTRY)&_ZN5S37C83v43Ev,
  (VTBL_ENTRY)&_ZN5S37C83v44Ev,
  (VTBL_ENTRY)&_ZN5S37C83v45Ev,
  (VTBL_ENTRY)&_ZN5S37C83v46Ev,
  (VTBL_ENTRY)&_ZN5S37C83v47Ev,
  (VTBL_ENTRY)&_ZN5S37C83v48Ev,
  (VTBL_ENTRY)&_ZN5S37C83v49Ev,
  (VTBL_ENTRY)&_ZN5S37C83v50Ev,
  (VTBL_ENTRY)&_ZN5S37C83v51Ev,
  (VTBL_ENTRY)&_ZN5S37C83v52Ev,
  (VTBL_ENTRY)&_ZN5S37C83v53Ev,
  (VTBL_ENTRY)&_ZN5S37C83v54Ev,
  (VTBL_ENTRY)&_ZN5S37C83v55Ev,
  (VTBL_ENTRY)&_ZN5S37C83v56Ev,
  (VTBL_ENTRY)&_ZN5S37C83v57Ev,
  (VTBL_ENTRY)&_ZN5S37C83v58Ev,
  (VTBL_ENTRY)&_ZN5S37C83v59Ev,
  (VTBL_ENTRY)&_ZN5S37C83v60Ev,
  (VTBL_ENTRY)&_ZN5S37C83v61Ev,
  (VTBL_ENTRY)&_ZN5S37C83v62Ev,
  (VTBL_ENTRY)&_ZN5S37C83v63Ev,
  (VTBL_ENTRY)&_ZN5S37C83v64Ev,
  (VTBL_ENTRY)&_ZN5S37C83v65Ev,
  (VTBL_ENTRY)&_ZN5S37C83v66Ev,
  (VTBL_ENTRY)&_ZN5S37C83v67Ev,
  (VTBL_ENTRY)&_ZN5S37C73v68Ev,
  (VTBL_ENTRY)&_ZN5S37C73v69Ev,
  (VTBL_ENTRY)&_ZN5S37C63v70Ev,
  (VTBL_ENTRY)&_ZN5S37C63v71Ev,
  (VTBL_ENTRY)&_ZN5S37C63v72Ev,
  (VTBL_ENTRY)&_ZN5S37C63v73Ev,
  (VTBL_ENTRY)&_ZN5S37C63v74Ev,
  (VTBL_ENTRY)&_ZN5S37C63v75Ev,
  (VTBL_ENTRY)&_ZN5S37C63v76Ev,
  (VTBL_ENTRY)&_ZN5S37C63v77Ev,
  (VTBL_ENTRY)&_ZN5S37C63v78Ev,
  (VTBL_ENTRY)&_ZN5S37C63v79Ev,
  (VTBL_ENTRY)&_ZN5S37C63v80Ev,
  (VTBL_ENTRY)&_ZN5S37C63v81Ev,
  (VTBL_ENTRY)&_ZN5S37C63v82Ev,
  (VTBL_ENTRY)&_ZN5S37C63v83Ev,
  (VTBL_ENTRY)&_ZN5S37C63v84Ev,
  (VTBL_ENTRY)&_ZN5S37C63v85Ev,
  (VTBL_ENTRY)&_ZN5S37C63v86Ev,
  (VTBL_ENTRY)&_ZN5S37C63v87Ev,
  (VTBL_ENTRY)&_ZN5S37C63v88Ev,
  (VTBL_ENTRY)&_ZN5S37C63v89Ev,
  (VTBL_ENTRY)&_ZN5S37C63v90Ev,
  (VTBL_ENTRY)&_ZN5S37C63v91Ev,
  (VTBL_ENTRY)&_ZN5S37C63v92Ev,
  (VTBL_ENTRY)&_ZN5S37C63v93Ev,
  (VTBL_ENTRY)&_ZN5S37C63v94Ev,
  (VTBL_ENTRY)&_ZN5S37C63v95Ev,
  (VTBL_ENTRY)&_ZN5S37C63v96Ev,
  (VTBL_ENTRY)&_ZN5S37C63v97Ev,
  (VTBL_ENTRY)&_ZN5S37C63v98Ev,
  (VTBL_ENTRY)&_ZN5S37C63v99Ev,
  (VTBL_ENTRY)&_ZN5S37C64v100Ev,
  (VTBL_ENTRY)&_ZN5S37C64v101Ev,
  (VTBL_ENTRY)&_ZN5S37C64v102Ev,
  (VTBL_ENTRY)&_ZN5S37C64v103Ev,
  (VTBL_ENTRY)&_ZN5S37C64v104Ev,
  (VTBL_ENTRY)&_ZN5S37C64v105Ev,
  (VTBL_ENTRY)&_ZN5S37C64v106Ev,
  (VTBL_ENTRY)&_ZN5S37C64v107Ev,
  (VTBL_ENTRY)&_ZN5S37C64v108Ev,
  (VTBL_ENTRY)&_ZN5S37C64v109Ev,
  (VTBL_ENTRY)&_ZN5S37C64v110Ev,
  (VTBL_ENTRY)&_ZN5S37C64v111Ev,
  (VTBL_ENTRY)&_ZN5S37C64v112Ev,
  (VTBL_ENTRY)&_ZN5S37C64v113Ev,
  (VTBL_ENTRY)&_ZN5S37C64v114Ev,
  (VTBL_ENTRY)&_ZN5S37C64v115Ev,
  (VTBL_ENTRY)&_ZN5S37C64v116Ev,
  (VTBL_ENTRY)&_ZN5S37C64v117Ev,
  (VTBL_ENTRY)&_ZN5S37C64v118Ev,
  (VTBL_ENTRY)&_ZN5S37C64v119Ev,
  (VTBL_ENTRY)&_ZN5S37C64v120Ev,
  (VTBL_ENTRY)&_ZN5S37C64v121Ev,
  (VTBL_ENTRY)&_ZN5S37C64v122Ev,
  (VTBL_ENTRY)&_ZN5S37C64v123Ev,
  (VTBL_ENTRY)&_ZN5S37C64v124Ev,
  (VTBL_ENTRY)&_ZN5S37C64v125Ev,
  (VTBL_ENTRY)&_ZN5S37C64v126Ev,
  (VTBL_ENTRY)&_ZN5S37C64v127Ev,
  (VTBL_ENTRY)&_ZN5S37C64v128Ev,
  (VTBL_ENTRY)&_ZN5S37C64v129Ev,
  (VTBL_ENTRY)&_ZN5S37C64v130Ev,
  (VTBL_ENTRY)&_ZN5S37C64v131Ev,
  (VTBL_ENTRY)&_ZN5S37C64v132Ev,
  (VTBL_ENTRY)&_ZN5S37C64v133Ev,
  (VTBL_ENTRY)&_ZN5S37C64v134Ev,
  (VTBL_ENTRY)&_ZN5S37C64v135Ev,
  (VTBL_ENTRY)&_ZN5S37C64v136Ev,
  (VTBL_ENTRY)&_ZN5S37C64v137Ev,
  (VTBL_ENTRY)&_ZN5S37C64v138Ev,
  (VTBL_ENTRY)&_ZN5S37C64v139Ev,
  (VTBL_ENTRY)&_ZN5S37C64v140Ev,
  (VTBL_ENTRY)&_ZN5S37C64v141Ev,
  (VTBL_ENTRY)&_ZN5S37C64v142Ev,
  (VTBL_ENTRY)&_ZN5S37C64v143Ev,
  (VTBL_ENTRY)&_ZN5S37C64v144Ev,
  (VTBL_ENTRY)&_ZN5S37C64v145Ev,
  (VTBL_ENTRY)&_ZN5S37C54v146Ev,
  (VTBL_ENTRY)&_ZN5S37C54v147Ev,
  (VTBL_ENTRY)&_ZN5S37C54v148Ev,
  (VTBL_ENTRY)&_ZN5S37C54v149Ev,
  (VTBL_ENTRY)&_ZN5S37C54v150Ev,
  (VTBL_ENTRY)&_ZN5S37C54v151Ev,
  (VTBL_ENTRY)&_ZN5S37C54v152Ev,
  (VTBL_ENTRY)&_ZN5S37C54v153Ev,
  (VTBL_ENTRY)&_ZN5S37C54v154Ev,
  (VTBL_ENTRY)&_ZN5S37C54v155Ev,
  (VTBL_ENTRY)&_ZN5S37C54v156Ev,
  (VTBL_ENTRY)&_ZN5S37C54v157Ev,
  (VTBL_ENTRY)&_ZN5S37C54v158Ev,
  (VTBL_ENTRY)&_ZN5S37C54v159Ev,
  (VTBL_ENTRY)&_ZN5S37C54v160Ev,
  (VTBL_ENTRY)&_ZN5S37C54v161Ev,
  (VTBL_ENTRY)&_ZN5S37C54v162Ev,
  (VTBL_ENTRY)&_ZN5S37C54v163Ev,
  (VTBL_ENTRY)&_ZN5S37C54v164Ev,
  (VTBL_ENTRY)&_ZN5S37C54v165Ev,
  (VTBL_ENTRY)&_ZN5S37C54v166Ev,
  (VTBL_ENTRY)&_ZN5S37C54v167Ev,
  (VTBL_ENTRY)&_ZN5S37C54v168Ev,
  (VTBL_ENTRY)&_ZN5S37C54v169Ev,
  (VTBL_ENTRY)&_ZN5S37C54v170Ev,
  (VTBL_ENTRY)&_ZN5S37C54v171Ev,
  (VTBL_ENTRY)&_ZN5S37C54v172Ev,
  (VTBL_ENTRY)&_ZN5S37C54v173Ev,
  (VTBL_ENTRY)&_ZN5S37C54v174Ev,
  (VTBL_ENTRY)&_ZN5S37C54v175Ev,
  (VTBL_ENTRY)&_ZN5S37C54v176Ev,
  (VTBL_ENTRY)&_ZN5S37C54v177Ev,
  (VTBL_ENTRY)&_ZN5S37C54v178Ev,
  (VTBL_ENTRY)&_ZN5S37C54v179Ev,
  (VTBL_ENTRY)&_ZN5S37C54v180Ev,
  (VTBL_ENTRY)&_ZN5S37C54v181Ev,
  (VTBL_ENTRY)&_ZN5S37C54v182Ev,
  (VTBL_ENTRY)&_ZN5S37C54v183Ev,
  (VTBL_ENTRY)&_ZN5S37C54v184Ev,
  (VTBL_ENTRY)&_ZN5S37C44v185Ev,
  (VTBL_ENTRY)&_ZN5S37C44v186Ev,
  (VTBL_ENTRY)&_ZN5S37C44v187Ev,
  (VTBL_ENTRY)&_ZN5S37C44v188Ev,
  (VTBL_ENTRY)&_ZN5S37C44v189Ev,
  (VTBL_ENTRY)&_ZN5S37C44v190Ev,
  (VTBL_ENTRY)&_ZN5S37C44v191Ev,
  (VTBL_ENTRY)&_ZN5S37C44v192Ev,
  (VTBL_ENTRY)&_ZN5S37C44v193Ev,
  (VTBL_ENTRY)&_ZN5S37C44v194Ev,
  (VTBL_ENTRY)&_ZN5S37C44v195Ev,
  (VTBL_ENTRY)&_ZN5S37C44v196Ev,
  (VTBL_ENTRY)&_ZN5S37C44v197Ev,
  (VTBL_ENTRY)&_ZN5S37C44v198Ev,
  (VTBL_ENTRY)&_ZN5S37C44v199Ev,
  (VTBL_ENTRY)&_ZN5S37C44v200Ev,
  (VTBL_ENTRY)&_ZN5S37C44v201Ev,
  (VTBL_ENTRY)&_ZN5S37C44v202Ev,
  (VTBL_ENTRY)&_ZN5S37C44v203Ev,
  (VTBL_ENTRY)&_ZN5S37C44v204Ev,
  (VTBL_ENTRY)&_ZN5S37C44v205Ev,
  (VTBL_ENTRY)&_ZN5S37C44v206Ev,
  (VTBL_ENTRY)&_ZN5S37C44v207Ev,
  (VTBL_ENTRY)&_ZN5S37C34v208Ev,
  (VTBL_ENTRY)&_ZN5S37C34v209Ev,
  (VTBL_ENTRY)&_ZN5S37C34v210Ev,
  (VTBL_ENTRY)&_ZN5S37C34v211Ev,
  (VTBL_ENTRY)&_ZN5S37C34v212Ev,
  (VTBL_ENTRY)&_ZN5S37C34v213Ev,
  (VTBL_ENTRY)&_ZN5S37C34v214Ev,
  (VTBL_ENTRY)&_ZN5S37C34v215Ev,
  (VTBL_ENTRY)&_ZN5S37C24v216Ev,
  (VTBL_ENTRY)&_ZN5S37C24v217Ev,
  (VTBL_ENTRY)&_ZN5S37C12v1Ev,
  (VTBL_ENTRY)&_ZN5S37C12v2Ev,
  (VTBL_ENTRY)&_ZN5S37C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S37C1[];
extern  VTBL_ENTRY _ZTV5S37C1[];
Class_Descriptor cd_S37C1 = {  "S37C1", // class name
  bases_S37C1, 7,
  &(vtc_S37C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1056,732), // object size
  NSPAIRA(_ZTI5S37C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S37C1),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C7  {
  int s106c7f0;
  __tsi64 s106c7f1;
  void *s106c7f2[4];
  int s106c7f3[2];
  void *s106c7f4;
  ::S85C27_nt s106c7f5;
  void *s106c7f6[2];
  virtual  ~S106C7(); // _ZN6S106C7D1Ev
  virtual void  v6(); // _ZN6S106C72v6Ev
  virtual void  v7(); // _ZN6S106C72v7Ev
  virtual void  v8(); // _ZN6S106C72v8Ev
  virtual void  v9(); // _ZN6S106C72v9Ev
  virtual void  v10(); // _ZN6S106C73v10Ev
  virtual void  v11(); // _ZN6S106C73v11Ev
  virtual void  v12(); // _ZN6S106C73v12Ev
  virtual void  v13(); // _ZN6S106C73v13Ev
  virtual void  v14(); // _ZN6S106C73v14Ev
  virtual void  v15(); // _ZN6S106C73v15Ev
  virtual void  v16(); // _ZN6S106C73v16Ev
  virtual void  v17(); // _ZN6S106C73v17Ev
  virtual void  v18(); // _ZN6S106C73v18Ev
  virtual void  v19(); // _ZN6S106C73v19Ev
  virtual void  v20(); // _ZN6S106C73v20Ev
  virtual void  v21(); // _ZN6S106C73v21Ev
  virtual void  v22(); // _ZN6S106C73v22Ev
  virtual void  v23(); // _ZN6S106C73v23Ev
  virtual void  v24(); // _ZN6S106C73v24Ev
  virtual void  v25(); // _ZN6S106C73v25Ev
  virtual void  v26(); // _ZN6S106C73v26Ev
  virtual void  v27(); // _ZN6S106C73v27Ev
  virtual void  v28(); // _ZN6S106C73v28Ev
  virtual void  v29(); // _ZN6S106C73v29Ev
  virtual void  v30(); // _ZN6S106C73v30Ev
  virtual void  v31(); // _ZN6S106C73v31Ev
  virtual void  v32(); // _ZN6S106C73v32Ev
  virtual void  v33(); // _ZN6S106C73v33Ev
  virtual void  v34(); // _ZN6S106C73v34Ev
  virtual void  v35(); // _ZN6S106C73v35Ev
  virtual void  v36(); // _ZN6S106C73v36Ev
  virtual void  v37(); // _ZN6S106C73v37Ev
  virtual void  v38(); // _ZN6S106C73v38Ev
  virtual void  v39(); // _ZN6S106C73v39Ev
  virtual void  v40(); // _ZN6S106C73v40Ev
  virtual void  v41(); // _ZN6S106C73v41Ev
  virtual void  v42(); // _ZN6S106C73v42Ev
  virtual void  v43(); // _ZN6S106C73v43Ev
  virtual void  v44(); // _ZN6S106C73v44Ev
  virtual void  v45(); // _ZN6S106C73v45Ev
  virtual void  v46(); // _ZN6S106C73v46Ev
  virtual void  v47(); // _ZN6S106C73v47Ev
  virtual void  v48(); // _ZN6S106C73v48Ev
  virtual void  v49(); // _ZN6S106C73v49Ev
  virtual void  v50(); // _ZN6S106C73v50Ev
  virtual void  v51(); // _ZN6S106C73v51Ev
  virtual void  v52(); // _ZN6S106C73v52Ev
  virtual void  v53(); // _ZN6S106C73v53Ev
  virtual void  v54(); // _ZN6S106C73v54Ev
  virtual void  v55(); // _ZN6S106C73v55Ev
  virtual void  v56(); // _ZN6S106C73v56Ev
  virtual void  v57(); // _ZN6S106C73v57Ev
  virtual void  v58(); // _ZN6S106C73v58Ev
  virtual void  v59(); // _ZN6S106C73v59Ev
  virtual void  v60(); // _ZN6S106C73v60Ev
  virtual void  v61(); // _ZN6S106C73v61Ev
  virtual void  v62(); // _ZN6S106C73v62Ev
  virtual void  v63(); // _ZN6S106C73v63Ev
  virtual void  v64(); // _ZN6S106C73v64Ev
  virtual void  v65(); // _ZN6S106C73v65Ev
  virtual void  v66(); // _ZN6S106C73v66Ev
  virtual void  v67(); // _ZN6S106C73v67Ev
  virtual void  v68(); // _ZN6S106C73v68Ev
  virtual void  v69(); // _ZN6S106C73v69Ev
  S106C7(); // tgen
};
//SIG(-1 S106C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S106C7 ::~S106C7(){ note_dtor("S106C7", this);}
void  S106C7 ::v6(){vfunc_called(this, "_ZN6S106C72v6Ev");}
void  S106C7 ::v7(){vfunc_called(this, "_ZN6S106C72v7Ev");}
void  S106C7 ::v8(){vfunc_called(this, "_ZN6S106C72v8Ev");}
void  S106C7 ::v9(){vfunc_called(this, "_ZN6S106C72v9Ev");}
void  S106C7 ::v10(){vfunc_called(this, "_ZN6S106C73v10Ev");}
void  S106C7 ::v11(){vfunc_called(this, "_ZN6S106C73v11Ev");}
void  S106C7 ::v12(){vfunc_called(this, "_ZN6S106C73v12Ev");}
void  S106C7 ::v13(){vfunc_called(this, "_ZN6S106C73v13Ev");}
void  S106C7 ::v14(){vfunc_called(this, "_ZN6S106C73v14Ev");}
void  S106C7 ::v15(){vfunc_called(this, "_ZN6S106C73v15Ev");}
void  S106C7 ::v16(){vfunc_called(this, "_ZN6S106C73v16Ev");}
void  S106C7 ::v17(){vfunc_called(this, "_ZN6S106C73v17Ev");}
void  S106C7 ::v18(){vfunc_called(this, "_ZN6S106C73v18Ev");}
void  S106C7 ::v19(){vfunc_called(this, "_ZN6S106C73v19Ev");}
void  S106C7 ::v20(){vfunc_called(this, "_ZN6S106C73v20Ev");}
void  S106C7 ::v21(){vfunc_called(this, "_ZN6S106C73v21Ev");}
void  S106C7 ::v22(){vfunc_called(this, "_ZN6S106C73v22Ev");}
void  S106C7 ::v23(){vfunc_called(this, "_ZN6S106C73v23Ev");}
void  S106C7 ::v24(){vfunc_called(this, "_ZN6S106C73v24Ev");}
void  S106C7 ::v25(){vfunc_called(this, "_ZN6S106C73v25Ev");}
void  S106C7 ::v26(){vfunc_called(this, "_ZN6S106C73v26Ev");}
void  S106C7 ::v27(){vfunc_called(this, "_ZN6S106C73v27Ev");}
void  S106C7 ::v28(){vfunc_called(this, "_ZN6S106C73v28Ev");}
void  S106C7 ::v29(){vfunc_called(this, "_ZN6S106C73v29Ev");}
void  S106C7 ::v30(){vfunc_called(this, "_ZN6S106C73v30Ev");}
void  S106C7 ::v31(){vfunc_called(this, "_ZN6S106C73v31Ev");}
void  S106C7 ::v32(){vfunc_called(this, "_ZN6S106C73v32Ev");}
void  S106C7 ::v33(){vfunc_called(this, "_ZN6S106C73v33Ev");}
void  S106C7 ::v34(){vfunc_called(this, "_ZN6S106C73v34Ev");}
void  S106C7 ::v35(){vfunc_called(this, "_ZN6S106C73v35Ev");}
void  S106C7 ::v36(){vfunc_called(this, "_ZN6S106C73v36Ev");}
void  S106C7 ::v37(){vfunc_called(this, "_ZN6S106C73v37Ev");}
void  S106C7 ::v38(){vfunc_called(this, "_ZN6S106C73v38Ev");}
void  S106C7 ::v39(){vfunc_called(this, "_ZN6S106C73v39Ev");}
void  S106C7 ::v40(){vfunc_called(this, "_ZN6S106C73v40Ev");}
void  S106C7 ::v41(){vfunc_called(this, "_ZN6S106C73v41Ev");}
void  S106C7 ::v42(){vfunc_called(this, "_ZN6S106C73v42Ev");}
void  S106C7 ::v43(){vfunc_called(this, "_ZN6S106C73v43Ev");}
void  S106C7 ::v44(){vfunc_called(this, "_ZN6S106C73v44Ev");}
void  S106C7 ::v45(){vfunc_called(this, "_ZN6S106C73v45Ev");}
void  S106C7 ::v46(){vfunc_called(this, "_ZN6S106C73v46Ev");}
void  S106C7 ::v47(){vfunc_called(this, "_ZN6S106C73v47Ev");}
void  S106C7 ::v48(){vfunc_called(this, "_ZN6S106C73v48Ev");}
void  S106C7 ::v49(){vfunc_called(this, "_ZN6S106C73v49Ev");}
void  S106C7 ::v50(){vfunc_called(this, "_ZN6S106C73v50Ev");}
void  S106C7 ::v51(){vfunc_called(this, "_ZN6S106C73v51Ev");}
void  S106C7 ::v52(){vfunc_called(this, "_ZN6S106C73v52Ev");}
void  S106C7 ::v53(){vfunc_called(this, "_ZN6S106C73v53Ev");}
void  S106C7 ::v54(){vfunc_called(this, "_ZN6S106C73v54Ev");}
void  S106C7 ::v55(){vfunc_called(this, "_ZN6S106C73v55Ev");}
void  S106C7 ::v56(){vfunc_called(this, "_ZN6S106C73v56Ev");}
void  S106C7 ::v57(){vfunc_called(this, "_ZN6S106C73v57Ev");}
void  S106C7 ::v58(){vfunc_called(this, "_ZN6S106C73v58Ev");}
void  S106C7 ::v59(){vfunc_called(this, "_ZN6S106C73v59Ev");}
void  S106C7 ::v60(){vfunc_called(this, "_ZN6S106C73v60Ev");}
void  S106C7 ::v61(){vfunc_called(this, "_ZN6S106C73v61Ev");}
void  S106C7 ::v62(){vfunc_called(this, "_ZN6S106C73v62Ev");}
void  S106C7 ::v63(){vfunc_called(this, "_ZN6S106C73v63Ev");}
void  S106C7 ::v64(){vfunc_called(this, "_ZN6S106C73v64Ev");}
void  S106C7 ::v65(){vfunc_called(this, "_ZN6S106C73v65Ev");}
void  S106C7 ::v66(){vfunc_called(this, "_ZN6S106C73v66Ev");}
void  S106C7 ::v67(){vfunc_called(this, "_ZN6S106C73v67Ev");}
void  S106C7 ::v68(){vfunc_called(this, "_ZN6S106C73v68Ev");}
void  S106C7 ::v69(){vfunc_called(this, "_ZN6S106C73v69Ev");}
S106C7 ::S106C7(){ note_ctor("S106C7", this);} // tgen

static void Test_S106C7()
{
  extern Class_Descriptor cd_S106C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S106C7, buf);
    S106C7 *dp, &lv = *(dp=new (buf) S106C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S106C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C7)");
    check_field_offset(lv, s106c7f0, ABISELECT(8,4), "S106C7.s106c7f0");
    check_field_offset(lv, s106c7f1, ABISELECT(16,8), "S106C7.s106c7f1");
    check_field_offset(lv, s106c7f2, ABISELECT(24,16), "S106C7.s106c7f2");
    check_field_offset(lv, s106c7f3, ABISELECT(56,32), "S106C7.s106c7f3");
    check_field_offset(lv, s106c7f4, ABISELECT(64,40), "S106C7.s106c7f4");
    check_field_offset(lv, s106c7f5, ABISELECT(72,44), "S106C7.s106c7f5");
    check_field_offset(lv, s106c7f6, ABISELECT(80,52), "S106C7.s106c7f6");
    test_class_info(&lv, &cd_S106C7);
    dp->~S106C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C7(Test_S106C7, "S106C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S106C7C1Ev();
extern void _ZN6S106C7D1Ev();
Name_Map name_map_S106C7[] = {
  NSPAIR(_ZN6S106C7C1Ev),
  NSPAIR(_ZN6S106C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S106C7[];
extern void _ZN6S106C7D1Ev();
extern void _ZN6S106C7D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
static  VTBL_ENTRY vtc_S106C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C7[0]),
  (VTBL_ENTRY)&_ZN6S106C7D1Ev,
  (VTBL_ENTRY)&_ZN6S106C7D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
};
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
Class_Descriptor cd_S106C7 = {  "S106C7", // class name
  0,0,//no base classes
  &(vtc_S106C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S106C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S106C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C6  : S106C7 {
  virtual  ~S106C6(); // _ZN6S106C6D1Ev
  virtual void  v70(); // _ZN6S106C63v70Ev
  virtual void  v71(); // _ZN6S106C63v71Ev
  S106C6(); // tgen
};
//SIG(-1 S106C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S106C6 ::~S106C6(){ note_dtor("S106C6", this);}
void  S106C6 ::v70(){vfunc_called(this, "_ZN6S106C63v70Ev");}
void  S106C6 ::v71(){vfunc_called(this, "_ZN6S106C63v71Ev");}
S106C6 ::S106C6(){ note_ctor("S106C6", this);} // tgen

static void Test_S106C6()
{
  extern Class_Descriptor cd_S106C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S106C6, buf);
    S106C6 *dp, &lv = *(dp=new (buf) S106C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S106C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C6)");
    check_base_class_offset(lv, (S106C7*), 0, "S106C6");
    test_class_info(&lv, &cd_S106C6);
    dp->~S106C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C6(Test_S106C6, "S106C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S106C6C1Ev();
extern void _ZN6S106C6D1Ev();
Name_Map name_map_S106C6[] = {
  NSPAIR(_ZN6S106C6C1Ev),
  NSPAIR(_ZN6S106C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
static Base_Class bases_S106C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C6[];
extern void _ZN6S106C6D1Ev();
extern void _ZN6S106C6D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
static  VTBL_ENTRY vtc_S106C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C6[0]),
  (VTBL_ENTRY)&_ZN6S106C6D1Ev,
  (VTBL_ENTRY)&_ZN6S106C6D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
};
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
Class_Descriptor cd_S106C6 = {  "S106C6", // class name
  bases_S106C6, 1,
  &(vtc_S106C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S106C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C5  : S106C6 {
  ::S80C9_nt s106c5f0;
  int s106c5f1;
  unsigned int s106c5f2:1;
  unsigned int s106c5f3:1;
  unsigned int s106c5f4:1;
  unsigned int s106c5f5:1;
  ::S85C35 s106c5f6;
  ::S85C22_nt s106c5f7;
  void *s106c5f8;
  ::S80C31 s106c5f9;
  ::S80C31 s106c5f10;
  ::S80C29 s106c5f11;
  ::S80C19 s106c5f12;
  char s106c5f13;
  int s106c5f14;
  void *s106c5f15;
  ::S85C27_nt s106c5f16;
  ::S85C27_nt s106c5f17;
  ::S85C27_nt s106c5f18;
  ::S85C27_nt s106c5f19;
  ::S85C27_nt s106c5f20;
  ::S85C27_nt s106c5f21;
  ::S80C21_nt s106c5f22;
  ::S80C21_nt s106c5f23;
  ::S80C21_nt s106c5f24;
  ::S80C21_nt s106c5f25;
  ::S80C21_nt s106c5f26;
  ::S80C21_nt s106c5f27;
  ::S80C21_nt s106c5f28;
  ::S80C21_nt s106c5f29;
  ::S80C21_nt s106c5f30;
  ::S80C21_nt s106c5f31;
  virtual  ~S106C5(); // _ZN6S106C5D1Ev
  virtual void  v72(); // _ZN6S106C53v72Ev
  virtual void  v73(); // _ZN6S106C53v73Ev
  virtual void  v74(); // _ZN6S106C53v74Ev
  virtual void  v75(); // _ZN6S106C53v75Ev
  virtual void  v76(); // _ZN6S106C53v76Ev
  virtual void  v77(); // _ZN6S106C53v77Ev
  virtual void  v78(); // _ZN6S106C53v78Ev
  virtual void  v79(); // _ZN6S106C53v79Ev
  virtual void  v80(); // _ZN6S106C53v80Ev
  virtual void  v81(); // _ZN6S106C53v81Ev
  virtual void  v82(); // _ZN6S106C53v82Ev
  virtual void  v83(); // _ZN6S106C53v83Ev
  virtual void  v84(); // _ZN6S106C53v84Ev
  virtual void  v85(); // _ZN6S106C53v85Ev
  virtual void  v86(); // _ZN6S106C53v86Ev
  virtual void  v87(); // _ZN6S106C53v87Ev
  virtual void  v88(); // _ZN6S106C53v88Ev
  virtual void  v89(); // _ZN6S106C53v89Ev
  virtual void  v90(); // _ZN6S106C53v90Ev
  virtual void  v91(); // _ZN6S106C53v91Ev
  virtual void  v92(); // _ZN6S106C53v92Ev
  virtual void  v93(); // _ZN6S106C53v93Ev
  virtual void  v94(); // _ZN6S106C53v94Ev
  virtual void  v95(); // _ZN6S106C53v95Ev
  virtual void  v96(); // _ZN6S106C53v96Ev
  virtual void  v97(); // _ZN6S106C53v97Ev
  virtual void  v98(); // _ZN6S106C53v98Ev
  virtual void  v99(); // _ZN6S106C53v99Ev
  virtual void  v100(); // _ZN6S106C54v100Ev
  virtual void  v101(); // _ZN6S106C54v101Ev
  virtual void  v102(); // _ZN6S106C54v102Ev
  virtual void  v103(); // _ZN6S106C54v103Ev
  virtual void  v104(); // _ZN6S106C54v104Ev
  virtual void  v105(); // _ZN6S106C54v105Ev
  virtual void  v106(); // _ZN6S106C54v106Ev
  virtual void  v107(); // _ZN6S106C54v107Ev
  virtual void  v108(); // _ZN6S106C54v108Ev
  virtual void  v109(); // _ZN6S106C54v109Ev
  virtual void  v110(); // _ZN6S106C54v110Ev
  virtual void  v111(); // _ZN6S106C54v111Ev
  virtual void  v112(); // _ZN6S106C54v112Ev
  virtual void  v113(); // _ZN6S106C54v113Ev
  virtual void  v114(); // _ZN6S106C54v114Ev
  virtual void  v115(); // _ZN6S106C54v115Ev
  virtual void  v116(); // _ZN6S106C54v116Ev
  virtual void  v117(); // _ZN6S106C54v117Ev
  virtual void  v118(); // _ZN6S106C54v118Ev
  virtual void  v119(); // _ZN6S106C54v119Ev
  virtual void  v120(); // _ZN6S106C54v120Ev
  virtual void  v121(); // _ZN6S106C54v121Ev
  virtual void  v122(); // _ZN6S106C54v122Ev
  virtual void  v123(); // _ZN6S106C54v123Ev
  virtual void  v124(); // _ZN6S106C54v124Ev
  virtual void  v125(); // _ZN6S106C54v125Ev
  virtual void  v126(); // _ZN6S106C54v126Ev
  virtual void  v127(); // _ZN6S106C54v127Ev
  virtual void  v128(); // _ZN6S106C54v128Ev
  virtual void  v129(); // _ZN6S106C54v129Ev
  virtual void  v130(); // _ZN6S106C54v130Ev
  virtual void  v131(); // _ZN6S106C54v131Ev
  virtual void  v132(); // _ZN6S106C54v132Ev
  virtual void  v133(); // _ZN6S106C54v133Ev
  virtual void  v134(); // _ZN6S106C54v134Ev
  virtual void  v135(); // _ZN6S106C54v135Ev
  virtual void  v136(); // _ZN6S106C54v136Ev
  virtual void  v137(); // _ZN6S106C54v137Ev
  virtual void  v138(); // _ZN6S106C54v138Ev
  virtual void  v139(); // _ZN6S106C54v139Ev
  virtual void  v140(); // _ZN6S106C54v140Ev
  virtual void  v141(); // _ZN6S106C54v141Ev
  virtual void  v142(); // _ZN6S106C54v142Ev
  virtual void  v143(); // _ZN6S106C54v143Ev
  virtual void  v144(); // _ZN6S106C54v144Ev
  virtual void  v145(); // _ZN6S106C54v145Ev
  virtual void  v146(); // _ZN6S106C54v146Ev
  virtual void  v147(); // _ZN6S106C54v147Ev
  S106C5(); // tgen
};
//SIG(-1 S106C5) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC18{ m Fi[2]}} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S106C5 ::~S106C5(){ note_dtor("S106C5", this);}
void  S106C5 ::v72(){vfunc_called(this, "_ZN6S106C53v72Ev");}
void  S106C5 ::v73(){vfunc_called(this, "_ZN6S106C53v73Ev");}
void  S106C5 ::v74(){vfunc_called(this, "_ZN6S106C53v74Ev");}
void  S106C5 ::v75(){vfunc_called(this, "_ZN6S106C53v75Ev");}
void  S106C5 ::v76(){vfunc_called(this, "_ZN6S106C53v76Ev");}
void  S106C5 ::v77(){vfunc_called(this, "_ZN6S106C53v77Ev");}
void  S106C5 ::v78(){vfunc_called(this, "_ZN6S106C53v78Ev");}
void  S106C5 ::v79(){vfunc_called(this, "_ZN6S106C53v79Ev");}
void  S106C5 ::v80(){vfunc_called(this, "_ZN6S106C53v80Ev");}
void  S106C5 ::v81(){vfunc_called(this, "_ZN6S106C53v81Ev");}
void  S106C5 ::v82(){vfunc_called(this, "_ZN6S106C53v82Ev");}
void  S106C5 ::v83(){vfunc_called(this, "_ZN6S106C53v83Ev");}
void  S106C5 ::v84(){vfunc_called(this, "_ZN6S106C53v84Ev");}
void  S106C5 ::v85(){vfunc_called(this, "_ZN6S106C53v85Ev");}
void  S106C5 ::v86(){vfunc_called(this, "_ZN6S106C53v86Ev");}
void  S106C5 ::v87(){vfunc_called(this, "_ZN6S106C53v87Ev");}
void  S106C5 ::v88(){vfunc_called(this, "_ZN6S106C53v88Ev");}
void  S106C5 ::v89(){vfunc_called(this, "_ZN6S106C53v89Ev");}
void  S106C5 ::v90(){vfunc_called(this, "_ZN6S106C53v90Ev");}
void  S106C5 ::v91(){vfunc_called(this, "_ZN6S106C53v91Ev");}
void  S106C5 ::v92(){vfunc_called(this, "_ZN6S106C53v92Ev");}
void  S106C5 ::v93(){vfunc_called(this, "_ZN6S106C53v93Ev");}
void  S106C5 ::v94(){vfunc_called(this, "_ZN6S106C53v94Ev");}
void  S106C5 ::v95(){vfunc_called(this, "_ZN6S106C53v95Ev");}
void  S106C5 ::v96(){vfunc_called(this, "_ZN6S106C53v96Ev");}
void  S106C5 ::v97(){vfunc_called(this, "_ZN6S106C53v97Ev");}
void  S106C5 ::v98(){vfunc_called(this, "_ZN6S106C53v98Ev");}
void  S106C5 ::v99(){vfunc_called(this, "_ZN6S106C53v99Ev");}
void  S106C5 ::v100(){vfunc_called(this, "_ZN6S106C54v100Ev");}
void  S106C5 ::v101(){vfunc_called(this, "_ZN6S106C54v101Ev");}
void  S106C5 ::v102(){vfunc_called(this, "_ZN6S106C54v102Ev");}
void  S106C5 ::v103(){vfunc_called(this, "_ZN6S106C54v103Ev");}
void  S106C5 ::v104(){vfunc_called(this, "_ZN6S106C54v104Ev");}
void  S106C5 ::v105(){vfunc_called(this, "_ZN6S106C54v105Ev");}
void  S106C5 ::v106(){vfunc_called(this, "_ZN6S106C54v106Ev");}
void  S106C5 ::v107(){vfunc_called(this, "_ZN6S106C54v107Ev");}
void  S106C5 ::v108(){vfunc_called(this, "_ZN6S106C54v108Ev");}
void  S106C5 ::v109(){vfunc_called(this, "_ZN6S106C54v109Ev");}
void  S106C5 ::v110(){vfunc_called(this, "_ZN6S106C54v110Ev");}
void  S106C5 ::v111(){vfunc_called(this, "_ZN6S106C54v111Ev");}
void  S106C5 ::v112(){vfunc_called(this, "_ZN6S106C54v112Ev");}
void  S106C5 ::v113(){vfunc_called(this, "_ZN6S106C54v113Ev");}
void  S106C5 ::v114(){vfunc_called(this, "_ZN6S106C54v114Ev");}
void  S106C5 ::v115(){vfunc_called(this, "_ZN6S106C54v115Ev");}
void  S106C5 ::v116(){vfunc_called(this, "_ZN6S106C54v116Ev");}
void  S106C5 ::v117(){vfunc_called(this, "_ZN6S106C54v117Ev");}
void  S106C5 ::v118(){vfunc_called(this, "_ZN6S106C54v118Ev");}
void  S106C5 ::v119(){vfunc_called(this, "_ZN6S106C54v119Ev");}
void  S106C5 ::v120(){vfunc_called(this, "_ZN6S106C54v120Ev");}
void  S106C5 ::v121(){vfunc_called(this, "_ZN6S106C54v121Ev");}
void  S106C5 ::v122(){vfunc_called(this, "_ZN6S106C54v122Ev");}
void  S106C5 ::v123(){vfunc_called(this, "_ZN6S106C54v123Ev");}
void  S106C5 ::v124(){vfunc_called(this, "_ZN6S106C54v124Ev");}
void  S106C5 ::v125(){vfunc_called(this, "_ZN6S106C54v125Ev");}
void  S106C5 ::v126(){vfunc_called(this, "_ZN6S106C54v126Ev");}
void  S106C5 ::v127(){vfunc_called(this, "_ZN6S106C54v127Ev");}
void  S106C5 ::v128(){vfunc_called(this, "_ZN6S106C54v128Ev");}
void  S106C5 ::v129(){vfunc_called(this, "_ZN6S106C54v129Ev");}
void  S106C5 ::v130(){vfunc_called(this, "_ZN6S106C54v130Ev");}
void  S106C5 ::v131(){vfunc_called(this, "_ZN6S106C54v131Ev");}
void  S106C5 ::v132(){vfunc_called(this, "_ZN6S106C54v132Ev");}
void  S106C5 ::v133(){vfunc_called(this, "_ZN6S106C54v133Ev");}
void  S106C5 ::v134(){vfunc_called(this, "_ZN6S106C54v134Ev");}
void  S106C5 ::v135(){vfunc_called(this, "_ZN6S106C54v135Ev");}
void  S106C5 ::v136(){vfunc_called(this, "_ZN6S106C54v136Ev");}
void  S106C5 ::v137(){vfunc_called(this, "_ZN6S106C54v137Ev");}
void  S106C5 ::v138(){vfunc_called(this, "_ZN6S106C54v138Ev");}
void  S106C5 ::v139(){vfunc_called(this, "_ZN6S106C54v139Ev");}
void  S106C5 ::v140(){vfunc_called(this, "_ZN6S106C54v140Ev");}
void  S106C5 ::v141(){vfunc_called(this, "_ZN6S106C54v141Ev");}
void  S106C5 ::v142(){vfunc_called(this, "_ZN6S106C54v142Ev");}
void  S106C5 ::v143(){vfunc_called(this, "_ZN6S106C54v143Ev");}
void  S106C5 ::v144(){vfunc_called(this, "_ZN6S106C54v144Ev");}
void  S106C5 ::v145(){vfunc_called(this, "_ZN6S106C54v145Ev");}
void  S106C5 ::v146(){vfunc_called(this, "_ZN6S106C54v146Ev");}
void  S106C5 ::v147(){vfunc_called(this, "_ZN6S106C54v147Ev");}
S106C5 ::S106C5(){ note_ctor("S106C5", this);} // tgen

static void Test_S106C5()
{
  extern Class_Descriptor cd_S106C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S106C5, buf);
    S106C5 *dp, &lv = *(dp=new (buf) S106C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S106C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C5)");
    check_base_class_offset(lv, (S106C7*)(S106C6*), 0, "S106C5");
    check_base_class_offset(lv, (S106C6*), 0, "S106C5");
    check_field_offset(lv, s106c5f0, ABISELECT(96,60), "S106C5.s106c5f0");
    check_field_offset(lv, s106c5f1, ABISELECT(124,88), "S106C5.s106c5f1");
    set_bf_and_test(lv, s106c5f2, ABISELECT(128,92), 0, 1, 1, "S106C5");
    set_bf_and_test(lv, s106c5f3, ABISELECT(128,92), 1, 1, 1, "S106C5");
    set_bf_and_test(lv, s106c5f4, ABISELECT(128,92), 2, 1, 1, "S106C5");
    set_bf_and_test(lv, s106c5f5, ABISELECT(128,92), 3, 1, 1, "S106C5");
    check_field_offset(lv, s106c5f6, ABISELECT(136,96), "S106C5.s106c5f6");
    check_field_offset(lv, s106c5f7, ABISELECT(152,108), "S106C5.s106c5f7");
    check_field_offset(lv, s106c5f8, ABISELECT(168,120), "S106C5.s106c5f8");
    check_field_offset(lv, s106c5f9, ABISELECT(176,124), "S106C5.s106c5f9");
    check_field_offset(lv, s106c5f10, ABISELECT(192,136), "S106C5.s106c5f10");
    check_field_offset(lv, s106c5f11, ABISELECT(208,148), "S106C5.s106c5f11");
    check_field_offset(lv, s106c5f12, ABISELECT(224,160), "S106C5.s106c5f12");
    check_field_offset(lv, s106c5f13, ABISELECT(240,172), "S106C5.s106c5f13");
    check_field_offset(lv, s106c5f14, ABISELECT(244,176), "S106C5.s106c5f14");
    check_field_offset(lv, s106c5f15, ABISELECT(248,180), "S106C5.s106c5f15");
    check_field_offset(lv, s106c5f16, ABISELECT(256,184), "S106C5.s106c5f16");
    check_field_offset(lv, s106c5f17, ABISELECT(264,192), "S106C5.s106c5f17");
    check_field_offset(lv, s106c5f18, ABISELECT(272,200), "S106C5.s106c5f18");
    check_field_offset(lv, s106c5f19, ABISELECT(280,208), "S106C5.s106c5f19");
    check_field_offset(lv, s106c5f20, ABISELECT(288,216), "S106C5.s106c5f20");
    check_field_offset(lv, s106c5f21, ABISELECT(296,224), "S106C5.s106c5f21");
    check_field_offset(lv, s106c5f22, ABISELECT(304,232), "S106C5.s106c5f22");
    check_field_offset(lv, s106c5f23, ABISELECT(320,244), "S106C5.s106c5f23");
    check_field_offset(lv, s106c5f24, ABISELECT(336,256), "S106C5.s106c5f24");
    check_field_offset(lv, s106c5f25, ABISELECT(352,268), "S106C5.s106c5f25");
    check_field_offset(lv, s106c5f26, ABISELECT(368,280), "S106C5.s106c5f26");
    check_field_offset(lv, s106c5f27, ABISELECT(384,292), "S106C5.s106c5f27");
    check_field_offset(lv, s106c5f28, ABISELECT(400,304), "S106C5.s106c5f28");
    check_field_offset(lv, s106c5f29, ABISELECT(416,316), "S106C5.s106c5f29");
    check_field_offset(lv, s106c5f30, ABISELECT(432,328), "S106C5.s106c5f30");
    check_field_offset(lv, s106c5f31, ABISELECT(448,340), "S106C5.s106c5f31");
    test_class_info(&lv, &cd_S106C5);
    dp->~S106C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C5(Test_S106C5, "S106C5", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN6S106C5C1Ev();
extern void _ZN6S106C5D1Ev();
Name_Map name_map_S106C5[] = {
  NSPAIR(_ZN6S106C5C1Ev),
  NSPAIR(_ZN6S106C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
extern Class_Descriptor cd_S106C6;
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
static Base_Class bases_S106C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S106C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C5[];
extern void _ZN6S106C5D1Ev();
extern void _ZN6S106C5D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
extern void _ZN6S106C53v72Ev();
extern void _ZN6S106C53v73Ev();
extern void _ZN6S106C53v74Ev();
extern void _ZN6S106C53v75Ev();
extern void _ZN6S106C53v76Ev();
extern void _ZN6S106C53v77Ev();
extern void _ZN6S106C53v78Ev();
extern void _ZN6S106C53v79Ev();
extern void _ZN6S106C53v80Ev();
extern void _ZN6S106C53v81Ev();
extern void _ZN6S106C53v82Ev();
extern void _ZN6S106C53v83Ev();
extern void _ZN6S106C53v84Ev();
extern void _ZN6S106C53v85Ev();
extern void _ZN6S106C53v86Ev();
extern void _ZN6S106C53v87Ev();
extern void _ZN6S106C53v88Ev();
extern void _ZN6S106C53v89Ev();
extern void _ZN6S106C53v90Ev();
extern void _ZN6S106C53v91Ev();
extern void _ZN6S106C53v92Ev();
extern void _ZN6S106C53v93Ev();
extern void _ZN6S106C53v94Ev();
extern void _ZN6S106C53v95Ev();
extern void _ZN6S106C53v96Ev();
extern void _ZN6S106C53v97Ev();
extern void _ZN6S106C53v98Ev();
extern void _ZN6S106C53v99Ev();
extern void _ZN6S106C54v100Ev();
extern void _ZN6S106C54v101Ev();
extern void _ZN6S106C54v102Ev();
extern void _ZN6S106C54v103Ev();
extern void _ZN6S106C54v104Ev();
extern void _ZN6S106C54v105Ev();
extern void _ZN6S106C54v106Ev();
extern void _ZN6S106C54v107Ev();
extern void _ZN6S106C54v108Ev();
extern void _ZN6S106C54v109Ev();
extern void _ZN6S106C54v110Ev();
extern void _ZN6S106C54v111Ev();
extern void _ZN6S106C54v112Ev();
extern void _ZN6S106C54v113Ev();
extern void _ZN6S106C54v114Ev();
extern void _ZN6S106C54v115Ev();
extern void _ZN6S106C54v116Ev();
extern void _ZN6S106C54v117Ev();
extern void _ZN6S106C54v118Ev();
extern void _ZN6S106C54v119Ev();
extern void _ZN6S106C54v120Ev();
extern void _ZN6S106C54v121Ev();
extern void _ZN6S106C54v122Ev();
extern void _ZN6S106C54v123Ev();
extern void _ZN6S106C54v124Ev();
extern void _ZN6S106C54v125Ev();
extern void _ZN6S106C54v126Ev();
extern void _ZN6S106C54v127Ev();
extern void _ZN6S106C54v128Ev();
extern void _ZN6S106C54v129Ev();
extern void _ZN6S106C54v130Ev();
extern void _ZN6S106C54v131Ev();
extern void _ZN6S106C54v132Ev();
extern void _ZN6S106C54v133Ev();
extern void _ZN6S106C54v134Ev();
extern void _ZN6S106C54v135Ev();
extern void _ZN6S106C54v136Ev();
extern void _ZN6S106C54v137Ev();
extern void _ZN6S106C54v138Ev();
extern void _ZN6S106C54v139Ev();
extern void _ZN6S106C54v140Ev();
extern void _ZN6S106C54v141Ev();
extern void _ZN6S106C54v142Ev();
extern void _ZN6S106C54v143Ev();
extern void _ZN6S106C54v144Ev();
extern void _ZN6S106C54v145Ev();
extern void _ZN6S106C54v146Ev();
extern void _ZN6S106C54v147Ev();
static  VTBL_ENTRY vtc_S106C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C5[0]),
  (VTBL_ENTRY)&_ZN6S106C5D1Ev,
  (VTBL_ENTRY)&_ZN6S106C5D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
  (VTBL_ENTRY)&_ZN6S106C53v72Ev,
  (VTBL_ENTRY)&_ZN6S106C53v73Ev,
  (VTBL_ENTRY)&_ZN6S106C53v74Ev,
  (VTBL_ENTRY)&_ZN6S106C53v75Ev,
  (VTBL_ENTRY)&_ZN6S106C53v76Ev,
  (VTBL_ENTRY)&_ZN6S106C53v77Ev,
  (VTBL_ENTRY)&_ZN6S106C53v78Ev,
  (VTBL_ENTRY)&_ZN6S106C53v79Ev,
  (VTBL_ENTRY)&_ZN6S106C53v80Ev,
  (VTBL_ENTRY)&_ZN6S106C53v81Ev,
  (VTBL_ENTRY)&_ZN6S106C53v82Ev,
  (VTBL_ENTRY)&_ZN6S106C53v83Ev,
  (VTBL_ENTRY)&_ZN6S106C53v84Ev,
  (VTBL_ENTRY)&_ZN6S106C53v85Ev,
  (VTBL_ENTRY)&_ZN6S106C53v86Ev,
  (VTBL_ENTRY)&_ZN6S106C53v87Ev,
  (VTBL_ENTRY)&_ZN6S106C53v88Ev,
  (VTBL_ENTRY)&_ZN6S106C53v89Ev,
  (VTBL_ENTRY)&_ZN6S106C53v90Ev,
  (VTBL_ENTRY)&_ZN6S106C53v91Ev,
  (VTBL_ENTRY)&_ZN6S106C53v92Ev,
  (VTBL_ENTRY)&_ZN6S106C53v93Ev,
  (VTBL_ENTRY)&_ZN6S106C53v94Ev,
  (VTBL_ENTRY)&_ZN6S106C53v95Ev,
  (VTBL_ENTRY)&_ZN6S106C53v96Ev,
  (VTBL_ENTRY)&_ZN6S106C53v97Ev,
  (VTBL_ENTRY)&_ZN6S106C53v98Ev,
  (VTBL_ENTRY)&_ZN6S106C53v99Ev,
  (VTBL_ENTRY)&_ZN6S106C54v100Ev,
  (VTBL_ENTRY)&_ZN6S106C54v101Ev,
  (VTBL_ENTRY)&_ZN6S106C54v102Ev,
  (VTBL_ENTRY)&_ZN6S106C54v103Ev,
  (VTBL_ENTRY)&_ZN6S106C54v104Ev,
  (VTBL_ENTRY)&_ZN6S106C54v105Ev,
  (VTBL_ENTRY)&_ZN6S106C54v106Ev,
  (VTBL_ENTRY)&_ZN6S106C54v107Ev,
  (VTBL_ENTRY)&_ZN6S106C54v108Ev,
  (VTBL_ENTRY)&_ZN6S106C54v109Ev,
  (VTBL_ENTRY)&_ZN6S106C54v110Ev,
  (VTBL_ENTRY)&_ZN6S106C54v111Ev,
  (VTBL_ENTRY)&_ZN6S106C54v112Ev,
  (VTBL_ENTRY)&_ZN6S106C54v113Ev,
  (VTBL_ENTRY)&_ZN6S106C54v114Ev,
  (VTBL_ENTRY)&_ZN6S106C54v115Ev,
  (VTBL_ENTRY)&_ZN6S106C54v116Ev,
  (VTBL_ENTRY)&_ZN6S106C54v117Ev,
  (VTBL_ENTRY)&_ZN6S106C54v118Ev,
  (VTBL_ENTRY)&_ZN6S106C54v119Ev,
  (VTBL_ENTRY)&_ZN6S106C54v120Ev,
  (VTBL_ENTRY)&_ZN6S106C54v121Ev,
  (VTBL_ENTRY)&_ZN6S106C54v122Ev,
  (VTBL_ENTRY)&_ZN6S106C54v123Ev,
  (VTBL_ENTRY)&_ZN6S106C54v124Ev,
  (VTBL_ENTRY)&_ZN6S106C54v125Ev,
  (VTBL_ENTRY)&_ZN6S106C54v126Ev,
  (VTBL_ENTRY)&_ZN6S106C54v127Ev,
  (VTBL_ENTRY)&_ZN6S106C54v128Ev,
  (VTBL_ENTRY)&_ZN6S106C54v129Ev,
  (VTBL_ENTRY)&_ZN6S106C54v130Ev,
  (VTBL_ENTRY)&_ZN6S106C54v131Ev,
  (VTBL_ENTRY)&_ZN6S106C54v132Ev,
  (VTBL_ENTRY)&_ZN6S106C54v133Ev,
  (VTBL_ENTRY)&_ZN6S106C54v134Ev,
  (VTBL_ENTRY)&_ZN6S106C54v135Ev,
  (VTBL_ENTRY)&_ZN6S106C54v136Ev,
  (VTBL_ENTRY)&_ZN6S106C54v137Ev,
  (VTBL_ENTRY)&_ZN6S106C54v138Ev,
  (VTBL_ENTRY)&_ZN6S106C54v139Ev,
  (VTBL_ENTRY)&_ZN6S106C54v140Ev,
  (VTBL_ENTRY)&_ZN6S106C54v141Ev,
  (VTBL_ENTRY)&_ZN6S106C54v142Ev,
  (VTBL_ENTRY)&_ZN6S106C54v143Ev,
  (VTBL_ENTRY)&_ZN6S106C54v144Ev,
  (VTBL_ENTRY)&_ZN6S106C54v145Ev,
  (VTBL_ENTRY)&_ZN6S106C54v146Ev,
  (VTBL_ENTRY)&_ZN6S106C54v147Ev,
};
extern VTBL_ENTRY _ZTI6S106C5[];
extern  VTBL_ENTRY _ZTV6S106C5[];
Class_Descriptor cd_S106C5 = {  "S106C5", // class name
  bases_S106C5, 2,
  &(vtc_S106C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI6S106C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C5),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C4  : S106C5 {
  ::S85C27_nt s106c4f0;
  void *s106c4f1[9];
  ::S80C15 s106c4f2;
  ::S85C35 s106c4f3;
  ::S80C24 s106c4f4;
  int s106c4f5;
  unsigned int s106c4f6:1;
  unsigned int s106c4f7:1;
  unsigned int s106c4f8:1;
  unsigned int s106c4f9:1;
  unsigned int s106c4f10:1;
  unsigned int s106c4f11:1;
  unsigned int s106c4f12:1;
  unsigned int s106c4f13:1;
  unsigned int s106c4f14:1;
  unsigned int s106c4f15:1;
  unsigned int s106c4f16:1;
  unsigned int s106c4f17:1;
  unsigned int s106c4f18:1;
  unsigned int s106c4f19:1;
  unsigned int s106c4f20:1;
  unsigned int s106c4f21:1;
  unsigned int s106c4f22:1;
  unsigned int s106c4f23:1;
  unsigned int s106c4f24:1;
  unsigned int s106c4f25:1;
  unsigned int s106c4f26:1;
  unsigned int s106c4f27:1;
  void *s106c4f28;
  char s106c4f29[2];
  ::S80C8_nt s106c4f30;
  ::S85C27_nt s106c4f31;
  ::S85C27_nt s106c4f32;
  void *s106c4f33;
  ::S80C21_nt s106c4f34;
  ::S80C21_nt s106c4f35;
  ::S80C21_nt s106c4f36;
  ::S80C21_nt s106c4f37;
  ::S80C21_nt s106c4f38;
  virtual  ~S106C4(); // _ZN6S106C4D1Ev
  virtual void  v148(); // _ZN6S106C44v148Ev
  virtual void  v149(); // _ZN6S106C44v149Ev
  virtual void  v150(); // _ZN6S106C44v150Ev
  virtual void  v151(); // _ZN6S106C44v151Ev
  virtual void  v152(); // _ZN6S106C44v152Ev
  virtual void  v153(); // _ZN6S106C44v153Ev
  virtual void  v154(); // _ZN6S106C44v154Ev
  virtual void  v155(); // _ZN6S106C44v155Ev
  virtual void  v156(); // _ZN6S106C44v156Ev
  virtual void  v157(); // _ZN6S106C44v157Ev
  virtual void  v158(); // _ZN6S106C44v158Ev
  virtual void  v159(); // _ZN6S106C44v159Ev
  virtual void  v160(); // _ZN6S106C44v160Ev
  virtual void  v161(); // _ZN6S106C44v161Ev
  virtual void  v162(); // _ZN6S106C44v162Ev
  virtual void  v163(); // _ZN6S106C44v163Ev
  virtual void  v164(); // _ZN6S106C44v164Ev
  virtual void  v165(); // _ZN6S106C44v165Ev
  virtual void  v166(); // _ZN6S106C44v166Ev
  virtual void  v167(); // _ZN6S106C44v167Ev
  virtual void  v168(); // _ZN6S106C44v168Ev
  virtual void  v169(); // _ZN6S106C44v169Ev
  virtual void  v170(); // _ZN6S106C44v170Ev
  virtual void  v171(); // _ZN6S106C44v171Ev
  virtual void  v172(); // _ZN6S106C44v172Ev
  virtual void  v173(); // _ZN6S106C44v173Ev
  virtual void  v174(); // _ZN6S106C44v174Ev
  virtual void  v175(); // _ZN6S106C44v175Ev
  virtual void  v176(); // _ZN6S106C44v176Ev
  virtual void  v177(); // _ZN6S106C44v177Ev
  virtual void  v178(); // _ZN6S106C44v178Ev
  virtual void  v179(); // _ZN6S106C44v179Ev
  virtual void  v180(); // _ZN6S106C44v180Ev
  virtual void  v181(); // _ZN6S106C44v181Ev
  virtual void  v182(); // _ZN6S106C44v182Ev
  virtual void  v183(); // _ZN6S106C44v183Ev
  virtual void  v184(); // _ZN6S106C44v184Ev
  virtual void  v185(); // _ZN6S106C44v185Ev
  virtual void  v186(); // _ZN6S106C44v186Ev
  S106C4(); // tgen
};
//SIG(-1 S106C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC19{ m Fi[2]}} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC20{ BC21{ BC9}} FC7 FC22{ BC23{ m FC24{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC19 FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S106C4 ::~S106C4(){ note_dtor("S106C4", this);}
void  S106C4 ::v148(){vfunc_called(this, "_ZN6S106C44v148Ev");}
void  S106C4 ::v149(){vfunc_called(this, "_ZN6S106C44v149Ev");}
void  S106C4 ::v150(){vfunc_called(this, "_ZN6S106C44v150Ev");}
void  S106C4 ::v151(){vfunc_called(this, "_ZN6S106C44v151Ev");}
void  S106C4 ::v152(){vfunc_called(this, "_ZN6S106C44v152Ev");}
void  S106C4 ::v153(){vfunc_called(this, "_ZN6S106C44v153Ev");}
void  S106C4 ::v154(){vfunc_called(this, "_ZN6S106C44v154Ev");}
void  S106C4 ::v155(){vfunc_called(this, "_ZN6S106C44v155Ev");}
void  S106C4 ::v156(){vfunc_called(this, "_ZN6S106C44v156Ev");}
void  S106C4 ::v157(){vfunc_called(this, "_ZN6S106C44v157Ev");}
void  S106C4 ::v158(){vfunc_called(this, "_ZN6S106C44v158Ev");}
void  S106C4 ::v159(){vfunc_called(this, "_ZN6S106C44v159Ev");}
void  S106C4 ::v160(){vfunc_called(this, "_ZN6S106C44v160Ev");}
void  S106C4 ::v161(){vfunc_called(this, "_ZN6S106C44v161Ev");}
void  S106C4 ::v162(){vfunc_called(this, "_ZN6S106C44v162Ev");}
void  S106C4 ::v163(){vfunc_called(this, "_ZN6S106C44v163Ev");}
void  S106C4 ::v164(){vfunc_called(this, "_ZN6S106C44v164Ev");}
void  S106C4 ::v165(){vfunc_called(this, "_ZN6S106C44v165Ev");}
void  S106C4 ::v166(){vfunc_called(this, "_ZN6S106C44v166Ev");}
void  S106C4 ::v167(){vfunc_called(this, "_ZN6S106C44v167Ev");}
void  S106C4 ::v168(){vfunc_called(this, "_ZN6S106C44v168Ev");}
void  S106C4 ::v169(){vfunc_called(this, "_ZN6S106C44v169Ev");}
void  S106C4 ::v170(){vfunc_called(this, "_ZN6S106C44v170Ev");}
void  S106C4 ::v171(){vfunc_called(this, "_ZN6S106C44v171Ev");}
void  S106C4 ::v172(){vfunc_called(this, "_ZN6S106C44v172Ev");}
void  S106C4 ::v173(){vfunc_called(this, "_ZN6S106C44v173Ev");}
void  S106C4 ::v174(){vfunc_called(this, "_ZN6S106C44v174Ev");}
void  S106C4 ::v175(){vfunc_called(this, "_ZN6S106C44v175Ev");}
void  S106C4 ::v176(){vfunc_called(this, "_ZN6S106C44v176Ev");}
void  S106C4 ::v177(){vfunc_called(this, "_ZN6S106C44v177Ev");}
void  S106C4 ::v178(){vfunc_called(this, "_ZN6S106C44v178Ev");}
void  S106C4 ::v179(){vfunc_called(this, "_ZN6S106C44v179Ev");}
void  S106C4 ::v180(){vfunc_called(this, "_ZN6S106C44v180Ev");}
void  S106C4 ::v181(){vfunc_called(this, "_ZN6S106C44v181Ev");}
void  S106C4 ::v182(){vfunc_called(this, "_ZN6S106C44v182Ev");}
void  S106C4 ::v183(){vfunc_called(this, "_ZN6S106C44v183Ev");}
void  S106C4 ::v184(){vfunc_called(this, "_ZN6S106C44v184Ev");}
void  S106C4 ::v185(){vfunc_called(this, "_ZN6S106C44v185Ev");}
void  S106C4 ::v186(){vfunc_called(this, "_ZN6S106C44v186Ev");}
S106C4 ::S106C4(){ note_ctor("S106C4", this);} // tgen

static void Test_S106C4()
{
  extern Class_Descriptor cd_S106C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S106C4, buf);
    S106C4 *dp, &lv = *(dp=new (buf) S106C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S106C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C4)");
    check_base_class_offset(lv, (S106C7*)(S106C6*)(S106C5*), 0, "S106C4");
    check_base_class_offset(lv, (S106C6*)(S106C5*), 0, "S106C4");
    check_base_class_offset(lv, (S106C5*), 0, "S106C4");
    check_field_offset(lv, s106c4f0, ABISELECT(464,352), "S106C4.s106c4f0");
    check_field_offset(lv, s106c4f1, ABISELECT(472,360), "S106C4.s106c4f1");
    check_field_offset(lv, s106c4f2, ABISELECT(544,396), "S106C4.s106c4f2");
    check_field_offset(lv, s106c4f3, ABISELECT(560,408), "S106C4.s106c4f3");
    check_field_offset(lv, s106c4f4, ABISELECT(576,420), "S106C4.s106c4f4");
    check_field_offset(lv, s106c4f5, ABISELECT(608,440), "S106C4.s106c4f5");
    set_bf_and_test(lv, s106c4f6, ABISELECT(612,444), 0, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f7, ABISELECT(612,444), 1, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f8, ABISELECT(612,444), 2, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f9, ABISELECT(612,444), 3, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f10, ABISELECT(612,444), 4, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f11, ABISELECT(612,444), 5, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f12, ABISELECT(612,444), 6, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f13, ABISELECT(612,444), 7, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f14, ABISELECT(613,445), 0, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f15, ABISELECT(613,445), 1, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f16, ABISELECT(613,445), 2, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f17, ABISELECT(613,445), 3, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f18, ABISELECT(613,445), 4, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f19, ABISELECT(613,445), 5, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f20, ABISELECT(613,445), 6, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f21, ABISELECT(613,445), 7, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f22, ABISELECT(614,446), 0, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f23, ABISELECT(614,446), 1, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f24, ABISELECT(614,446), 2, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f25, ABISELECT(614,446), 3, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f26, ABISELECT(614,446), 4, 1, 1, "S106C4");
    set_bf_and_test(lv, s106c4f27, ABISELECT(614,446), 5, 1, 1, "S106C4");
    check_field_offset(lv, s106c4f28, ABISELECT(616,448), "S106C4.s106c4f28");
    check_field_offset(lv, s106c4f29, ABISELECT(624,452), "S106C4.s106c4f29");
    check_field_offset(lv, s106c4f30, ABISELECT(628,456), "S106C4.s106c4f30");
    check_field_offset(lv, s106c4f31, ABISELECT(636,464), "S106C4.s106c4f31");
    check_field_offset(lv, s106c4f32, ABISELECT(644,472), "S106C4.s106c4f32");
    check_field_offset(lv, s106c4f33, ABISELECT(656,480), "S106C4.s106c4f33");
    check_field_offset(lv, s106c4f34, ABISELECT(664,484), "S106C4.s106c4f34");
    check_field_offset(lv, s106c4f35, ABISELECT(680,496), "S106C4.s106c4f35");
    check_field_offset(lv, s106c4f36, ABISELECT(696,508), "S106C4.s106c4f36");
    check_field_offset(lv, s106c4f37, ABISELECT(712,520), "S106C4.s106c4f37");
    check_field_offset(lv, s106c4f38, ABISELECT(728,532), "S106C4.s106c4f38");
    test_class_info(&lv, &cd_S106C4);
    dp->~S106C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C4(Test_S106C4, "S106C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN6S106C4C1Ev();
extern void _ZN6S106C4D1Ev();
Name_Map name_map_S106C4[] = {
  NSPAIR(_ZN6S106C4C1Ev),
  NSPAIR(_ZN6S106C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
extern Class_Descriptor cd_S106C6;
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
extern Class_Descriptor cd_S106C5;
extern VTBL_ENTRY _ZTI6S106C5[];
extern  VTBL_ENTRY _ZTV6S106C5[];
static Base_Class bases_S106C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S106C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S106C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C4[];
extern void _ZN6S106C4D1Ev();
extern void _ZN6S106C4D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
extern void _ZN6S106C53v72Ev();
extern void _ZN6S106C53v73Ev();
extern void _ZN6S106C53v74Ev();
extern void _ZN6S106C53v75Ev();
extern void _ZN6S106C53v76Ev();
extern void _ZN6S106C53v77Ev();
extern void _ZN6S106C53v78Ev();
extern void _ZN6S106C53v79Ev();
extern void _ZN6S106C53v80Ev();
extern void _ZN6S106C53v81Ev();
extern void _ZN6S106C53v82Ev();
extern void _ZN6S106C53v83Ev();
extern void _ZN6S106C53v84Ev();
extern void _ZN6S106C53v85Ev();
extern void _ZN6S106C53v86Ev();
extern void _ZN6S106C53v87Ev();
extern void _ZN6S106C53v88Ev();
extern void _ZN6S106C53v89Ev();
extern void _ZN6S106C53v90Ev();
extern void _ZN6S106C53v91Ev();
extern void _ZN6S106C53v92Ev();
extern void _ZN6S106C53v93Ev();
extern void _ZN6S106C53v94Ev();
extern void _ZN6S106C53v95Ev();
extern void _ZN6S106C53v96Ev();
extern void _ZN6S106C53v97Ev();
extern void _ZN6S106C53v98Ev();
extern void _ZN6S106C53v99Ev();
extern void _ZN6S106C54v100Ev();
extern void _ZN6S106C54v101Ev();
extern void _ZN6S106C54v102Ev();
extern void _ZN6S106C54v103Ev();
extern void _ZN6S106C54v104Ev();
extern void _ZN6S106C54v105Ev();
extern void _ZN6S106C54v106Ev();
extern void _ZN6S106C54v107Ev();
extern void _ZN6S106C54v108Ev();
extern void _ZN6S106C54v109Ev();
extern void _ZN6S106C54v110Ev();
extern void _ZN6S106C54v111Ev();
extern void _ZN6S106C54v112Ev();
extern void _ZN6S106C54v113Ev();
extern void _ZN6S106C54v114Ev();
extern void _ZN6S106C54v115Ev();
extern void _ZN6S106C54v116Ev();
extern void _ZN6S106C54v117Ev();
extern void _ZN6S106C54v118Ev();
extern void _ZN6S106C54v119Ev();
extern void _ZN6S106C54v120Ev();
extern void _ZN6S106C54v121Ev();
extern void _ZN6S106C54v122Ev();
extern void _ZN6S106C54v123Ev();
extern void _ZN6S106C54v124Ev();
extern void _ZN6S106C54v125Ev();
extern void _ZN6S106C54v126Ev();
extern void _ZN6S106C54v127Ev();
extern void _ZN6S106C54v128Ev();
extern void _ZN6S106C54v129Ev();
extern void _ZN6S106C54v130Ev();
extern void _ZN6S106C54v131Ev();
extern void _ZN6S106C54v132Ev();
extern void _ZN6S106C54v133Ev();
extern void _ZN6S106C54v134Ev();
extern void _ZN6S106C54v135Ev();
extern void _ZN6S106C54v136Ev();
extern void _ZN6S106C54v137Ev();
extern void _ZN6S106C54v138Ev();
extern void _ZN6S106C54v139Ev();
extern void _ZN6S106C54v140Ev();
extern void _ZN6S106C54v141Ev();
extern void _ZN6S106C54v142Ev();
extern void _ZN6S106C54v143Ev();
extern void _ZN6S106C54v144Ev();
extern void _ZN6S106C54v145Ev();
extern void _ZN6S106C54v146Ev();
extern void _ZN6S106C54v147Ev();
extern void _ZN6S106C44v148Ev();
extern void _ZN6S106C44v149Ev();
extern void _ZN6S106C44v150Ev();
extern void _ZN6S106C44v151Ev();
extern void _ZN6S106C44v152Ev();
extern void _ZN6S106C44v153Ev();
extern void _ZN6S106C44v154Ev();
extern void _ZN6S106C44v155Ev();
extern void _ZN6S106C44v156Ev();
extern void _ZN6S106C44v157Ev();
extern void _ZN6S106C44v158Ev();
extern void _ZN6S106C44v159Ev();
extern void _ZN6S106C44v160Ev();
extern void _ZN6S106C44v161Ev();
extern void _ZN6S106C44v162Ev();
extern void _ZN6S106C44v163Ev();
extern void _ZN6S106C44v164Ev();
extern void _ZN6S106C44v165Ev();
extern void _ZN6S106C44v166Ev();
extern void _ZN6S106C44v167Ev();
extern void _ZN6S106C44v168Ev();
extern void _ZN6S106C44v169Ev();
extern void _ZN6S106C44v170Ev();
extern void _ZN6S106C44v171Ev();
extern void _ZN6S106C44v172Ev();
extern void _ZN6S106C44v173Ev();
extern void _ZN6S106C44v174Ev();
extern void _ZN6S106C44v175Ev();
extern void _ZN6S106C44v176Ev();
extern void _ZN6S106C44v177Ev();
extern void _ZN6S106C44v178Ev();
extern void _ZN6S106C44v179Ev();
extern void _ZN6S106C44v180Ev();
extern void _ZN6S106C44v181Ev();
extern void _ZN6S106C44v182Ev();
extern void _ZN6S106C44v183Ev();
extern void _ZN6S106C44v184Ev();
extern void _ZN6S106C44v185Ev();
extern void _ZN6S106C44v186Ev();
static  VTBL_ENTRY vtc_S106C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C4[0]),
  (VTBL_ENTRY)&_ZN6S106C4D1Ev,
  (VTBL_ENTRY)&_ZN6S106C4D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
  (VTBL_ENTRY)&_ZN6S106C53v72Ev,
  (VTBL_ENTRY)&_ZN6S106C53v73Ev,
  (VTBL_ENTRY)&_ZN6S106C53v74Ev,
  (VTBL_ENTRY)&_ZN6S106C53v75Ev,
  (VTBL_ENTRY)&_ZN6S106C53v76Ev,
  (VTBL_ENTRY)&_ZN6S106C53v77Ev,
  (VTBL_ENTRY)&_ZN6S106C53v78Ev,
  (VTBL_ENTRY)&_ZN6S106C53v79Ev,
  (VTBL_ENTRY)&_ZN6S106C53v80Ev,
  (VTBL_ENTRY)&_ZN6S106C53v81Ev,
  (VTBL_ENTRY)&_ZN6S106C53v82Ev,
  (VTBL_ENTRY)&_ZN6S106C53v83Ev,
  (VTBL_ENTRY)&_ZN6S106C53v84Ev,
  (VTBL_ENTRY)&_ZN6S106C53v85Ev,
  (VTBL_ENTRY)&_ZN6S106C53v86Ev,
  (VTBL_ENTRY)&_ZN6S106C53v87Ev,
  (VTBL_ENTRY)&_ZN6S106C53v88Ev,
  (VTBL_ENTRY)&_ZN6S106C53v89Ev,
  (VTBL_ENTRY)&_ZN6S106C53v90Ev,
  (VTBL_ENTRY)&_ZN6S106C53v91Ev,
  (VTBL_ENTRY)&_ZN6S106C53v92Ev,
  (VTBL_ENTRY)&_ZN6S106C53v93Ev,
  (VTBL_ENTRY)&_ZN6S106C53v94Ev,
  (VTBL_ENTRY)&_ZN6S106C53v95Ev,
  (VTBL_ENTRY)&_ZN6S106C53v96Ev,
  (VTBL_ENTRY)&_ZN6S106C53v97Ev,
  (VTBL_ENTRY)&_ZN6S106C53v98Ev,
  (VTBL_ENTRY)&_ZN6S106C53v99Ev,
  (VTBL_ENTRY)&_ZN6S106C54v100Ev,
  (VTBL_ENTRY)&_ZN6S106C54v101Ev,
  (VTBL_ENTRY)&_ZN6S106C54v102Ev,
  (VTBL_ENTRY)&_ZN6S106C54v103Ev,
  (VTBL_ENTRY)&_ZN6S106C54v104Ev,
  (VTBL_ENTRY)&_ZN6S106C54v105Ev,
  (VTBL_ENTRY)&_ZN6S106C54v106Ev,
  (VTBL_ENTRY)&_ZN6S106C54v107Ev,
  (VTBL_ENTRY)&_ZN6S106C54v108Ev,
  (VTBL_ENTRY)&_ZN6S106C54v109Ev,
  (VTBL_ENTRY)&_ZN6S106C54v110Ev,
  (VTBL_ENTRY)&_ZN6S106C54v111Ev,
  (VTBL_ENTRY)&_ZN6S106C54v112Ev,
  (VTBL_ENTRY)&_ZN6S106C54v113Ev,
  (VTBL_ENTRY)&_ZN6S106C54v114Ev,
  (VTBL_ENTRY)&_ZN6S106C54v115Ev,
  (VTBL_ENTRY)&_ZN6S106C54v116Ev,
  (VTBL_ENTRY)&_ZN6S106C54v117Ev,
  (VTBL_ENTRY)&_ZN6S106C54v118Ev,
  (VTBL_ENTRY)&_ZN6S106C54v119Ev,
  (VTBL_ENTRY)&_ZN6S106C54v120Ev,
  (VTBL_ENTRY)&_ZN6S106C54v121Ev,
  (VTBL_ENTRY)&_ZN6S106C54v122Ev,
  (VTBL_ENTRY)&_ZN6S106C54v123Ev,
  (VTBL_ENTRY)&_ZN6S106C54v124Ev,
  (VTBL_ENTRY)&_ZN6S106C54v125Ev,
  (VTBL_ENTRY)&_ZN6S106C54v126Ev,
  (VTBL_ENTRY)&_ZN6S106C54v127Ev,
  (VTBL_ENTRY)&_ZN6S106C54v128Ev,
  (VTBL_ENTRY)&_ZN6S106C54v129Ev,
  (VTBL_ENTRY)&_ZN6S106C54v130Ev,
  (VTBL_ENTRY)&_ZN6S106C54v131Ev,
  (VTBL_ENTRY)&_ZN6S106C54v132Ev,
  (VTBL_ENTRY)&_ZN6S106C54v133Ev,
  (VTBL_ENTRY)&_ZN6S106C54v134Ev,
  (VTBL_ENTRY)&_ZN6S106C54v135Ev,
  (VTBL_ENTRY)&_ZN6S106C54v136Ev,
  (VTBL_ENTRY)&_ZN6S106C54v137Ev,
  (VTBL_ENTRY)&_ZN6S106C54v138Ev,
  (VTBL_ENTRY)&_ZN6S106C54v139Ev,
  (VTBL_ENTRY)&_ZN6S106C54v140Ev,
  (VTBL_ENTRY)&_ZN6S106C54v141Ev,
  (VTBL_ENTRY)&_ZN6S106C54v142Ev,
  (VTBL_ENTRY)&_ZN6S106C54v143Ev,
  (VTBL_ENTRY)&_ZN6S106C54v144Ev,
  (VTBL_ENTRY)&_ZN6S106C54v145Ev,
  (VTBL_ENTRY)&_ZN6S106C54v146Ev,
  (VTBL_ENTRY)&_ZN6S106C54v147Ev,
  (VTBL_ENTRY)&_ZN6S106C44v148Ev,
  (VTBL_ENTRY)&_ZN6S106C44v149Ev,
  (VTBL_ENTRY)&_ZN6S106C44v150Ev,
  (VTBL_ENTRY)&_ZN6S106C44v151Ev,
  (VTBL_ENTRY)&_ZN6S106C44v152Ev,
  (VTBL_ENTRY)&_ZN6S106C44v153Ev,
  (VTBL_ENTRY)&_ZN6S106C44v154Ev,
  (VTBL_ENTRY)&_ZN6S106C44v155Ev,
  (VTBL_ENTRY)&_ZN6S106C44v156Ev,
  (VTBL_ENTRY)&_ZN6S106C44v157Ev,
  (VTBL_ENTRY)&_ZN6S106C44v158Ev,
  (VTBL_ENTRY)&_ZN6S106C44v159Ev,
  (VTBL_ENTRY)&_ZN6S106C44v160Ev,
  (VTBL_ENTRY)&_ZN6S106C44v161Ev,
  (VTBL_ENTRY)&_ZN6S106C44v162Ev,
  (VTBL_ENTRY)&_ZN6S106C44v163Ev,
  (VTBL_ENTRY)&_ZN6S106C44v164Ev,
  (VTBL_ENTRY)&_ZN6S106C44v165Ev,
  (VTBL_ENTRY)&_ZN6S106C44v166Ev,
  (VTBL_ENTRY)&_ZN6S106C44v167Ev,
  (VTBL_ENTRY)&_ZN6S106C44v168Ev,
  (VTBL_ENTRY)&_ZN6S106C44v169Ev,
  (VTBL_ENTRY)&_ZN6S106C44v170Ev,
  (VTBL_ENTRY)&_ZN6S106C44v171Ev,
  (VTBL_ENTRY)&_ZN6S106C44v172Ev,
  (VTBL_ENTRY)&_ZN6S106C44v173Ev,
  (VTBL_ENTRY)&_ZN6S106C44v174Ev,
  (VTBL_ENTRY)&_ZN6S106C44v175Ev,
  (VTBL_ENTRY)&_ZN6S106C44v176Ev,
  (VTBL_ENTRY)&_ZN6S106C44v177Ev,
  (VTBL_ENTRY)&_ZN6S106C44v178Ev,
  (VTBL_ENTRY)&_ZN6S106C44v179Ev,
  (VTBL_ENTRY)&_ZN6S106C44v180Ev,
  (VTBL_ENTRY)&_ZN6S106C44v181Ev,
  (VTBL_ENTRY)&_ZN6S106C44v182Ev,
  (VTBL_ENTRY)&_ZN6S106C44v183Ev,
  (VTBL_ENTRY)&_ZN6S106C44v184Ev,
  (VTBL_ENTRY)&_ZN6S106C44v185Ev,
  (VTBL_ENTRY)&_ZN6S106C44v186Ev,
};
extern VTBL_ENTRY _ZTI6S106C4[];
extern  VTBL_ENTRY _ZTV6S106C4[];
Class_Descriptor cd_S106C4 = {  "S106C4", // class name
  bases_S106C4, 3,
  &(vtc_S106C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI6S106C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C3  : S106C4 {
  unsigned int s106c3f0:1;
  unsigned int s106c3f1:1;
  unsigned int s106c3f2:1;
  unsigned int s106c3f3:1;
  unsigned int s106c3f4:1;
  unsigned int s106c3f5:1;
  void *s106c3f6[8];
  ::S80C21_nt s106c3f7;
  ::S80C21_nt s106c3f8;
  ::S80C21_nt s106c3f9;
  virtual  ~S106C3(); // _ZN6S106C3D1Ev
  virtual void  v187(); // _ZN6S106C34v187Ev
  virtual void  v188(); // _ZN6S106C34v188Ev
  virtual void  v189(); // _ZN6S106C34v189Ev
  virtual void  v190(); // _ZN6S106C34v190Ev
  virtual void  v191(); // _ZN6S106C34v191Ev
  virtual void  v192(); // _ZN6S106C34v192Ev
  virtual void  v193(); // _ZN6S106C34v193Ev
  virtual void  v194(); // _ZN6S106C34v194Ev
  virtual void  v195(); // _ZN6S106C34v195Ev
  virtual void  v196(); // _ZN6S106C34v196Ev
  virtual void  v197(); // _ZN6S106C34v197Ev
  virtual void  v198(); // _ZN6S106C34v198Ev
  virtual void  v199(); // _ZN6S106C34v199Ev
  virtual void  v200(); // _ZN6S106C34v200Ev
  virtual void  v201(); // _ZN6S106C34v201Ev
  virtual void  v202(); // _ZN6S106C34v202Ev
  virtual void  v203(); // _ZN6S106C34v203Ev
  virtual void  v204(); // _ZN6S106C34v204Ev
  virtual void  v205(); // _ZN6S106C34v205Ev
  virtual void  v206(); // _ZN6S106C34v206Ev
  virtual void  v207(); // _ZN6S106C34v207Ev
  virtual void  v208(); // _ZN6S106C34v208Ev
  virtual void  v209(); // _ZN6S106C34v209Ev
  S106C3(); // tgen
};
//SIG(-1 S106C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC20{ m Fi[2]}} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC21{ BC22{ BC10}} FC8 FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC20 FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S106C3 ::~S106C3(){ note_dtor("S106C3", this);}
void  S106C3 ::v187(){vfunc_called(this, "_ZN6S106C34v187Ev");}
void  S106C3 ::v188(){vfunc_called(this, "_ZN6S106C34v188Ev");}
void  S106C3 ::v189(){vfunc_called(this, "_ZN6S106C34v189Ev");}
void  S106C3 ::v190(){vfunc_called(this, "_ZN6S106C34v190Ev");}
void  S106C3 ::v191(){vfunc_called(this, "_ZN6S106C34v191Ev");}
void  S106C3 ::v192(){vfunc_called(this, "_ZN6S106C34v192Ev");}
void  S106C3 ::v193(){vfunc_called(this, "_ZN6S106C34v193Ev");}
void  S106C3 ::v194(){vfunc_called(this, "_ZN6S106C34v194Ev");}
void  S106C3 ::v195(){vfunc_called(this, "_ZN6S106C34v195Ev");}
void  S106C3 ::v196(){vfunc_called(this, "_ZN6S106C34v196Ev");}
void  S106C3 ::v197(){vfunc_called(this, "_ZN6S106C34v197Ev");}
void  S106C3 ::v198(){vfunc_called(this, "_ZN6S106C34v198Ev");}
void  S106C3 ::v199(){vfunc_called(this, "_ZN6S106C34v199Ev");}
void  S106C3 ::v200(){vfunc_called(this, "_ZN6S106C34v200Ev");}
void  S106C3 ::v201(){vfunc_called(this, "_ZN6S106C34v201Ev");}
void  S106C3 ::v202(){vfunc_called(this, "_ZN6S106C34v202Ev");}
void  S106C3 ::v203(){vfunc_called(this, "_ZN6S106C34v203Ev");}
void  S106C3 ::v204(){vfunc_called(this, "_ZN6S106C34v204Ev");}
void  S106C3 ::v205(){vfunc_called(this, "_ZN6S106C34v205Ev");}
void  S106C3 ::v206(){vfunc_called(this, "_ZN6S106C34v206Ev");}
void  S106C3 ::v207(){vfunc_called(this, "_ZN6S106C34v207Ev");}
void  S106C3 ::v208(){vfunc_called(this, "_ZN6S106C34v208Ev");}
void  S106C3 ::v209(){vfunc_called(this, "_ZN6S106C34v209Ev");}
S106C3 ::S106C3(){ note_ctor("S106C3", this);} // tgen

static void Test_S106C3()
{
  extern Class_Descriptor cd_S106C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S106C3, buf);
    S106C3 *dp, &lv = *(dp=new (buf) S106C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S106C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C3)");
    check_base_class_offset(lv, (S106C7*)(S106C6*)(S106C5*)(S106C4*), 0, "S106C3");
    check_base_class_offset(lv, (S106C6*)(S106C5*)(S106C4*), 0, "S106C3");
    check_base_class_offset(lv, (S106C5*)(S106C4*), 0, "S106C3");
    check_base_class_offset(lv, (S106C4*), 0, "S106C3");
    set_bf_and_test(lv, s106c3f0, ABISELECT(744,544), 0, 1, 1, "S106C3");
    set_bf_and_test(lv, s106c3f1, ABISELECT(744,544), 1, 1, 1, "S106C3");
    set_bf_and_test(lv, s106c3f2, ABISELECT(744,544), 2, 1, 1, "S106C3");
    set_bf_and_test(lv, s106c3f3, ABISELECT(744,544), 3, 1, 1, "S106C3");
    set_bf_and_test(lv, s106c3f4, ABISELECT(744,544), 4, 1, 1, "S106C3");
    set_bf_and_test(lv, s106c3f5, ABISELECT(744,544), 5, 1, 1, "S106C3");
    check_field_offset(lv, s106c3f6, ABISELECT(752,548), "S106C3.s106c3f6");
    check_field_offset(lv, s106c3f7, ABISELECT(816,580), "S106C3.s106c3f7");
    check_field_offset(lv, s106c3f8, ABISELECT(832,592), "S106C3.s106c3f8");
    check_field_offset(lv, s106c3f9, ABISELECT(848,604), "S106C3.s106c3f9");
    test_class_info(&lv, &cd_S106C3);
    dp->~S106C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C3(Test_S106C3, "S106C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN6S106C3C1Ev();
extern void _ZN6S106C3D1Ev();
Name_Map name_map_S106C3[] = {
  NSPAIR(_ZN6S106C3C1Ev),
  NSPAIR(_ZN6S106C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
extern Class_Descriptor cd_S106C6;
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
extern Class_Descriptor cd_S106C5;
extern VTBL_ENTRY _ZTI6S106C5[];
extern  VTBL_ENTRY _ZTV6S106C5[];
extern Class_Descriptor cd_S106C4;
extern VTBL_ENTRY _ZTI6S106C4[];
extern  VTBL_ENTRY _ZTV6S106C4[];
static Base_Class bases_S106C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S106C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S106C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S106C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C3[];
extern void _ZN6S106C3D1Ev();
extern void _ZN6S106C3D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
extern void _ZN6S106C53v72Ev();
extern void _ZN6S106C53v73Ev();
extern void _ZN6S106C53v74Ev();
extern void _ZN6S106C53v75Ev();
extern void _ZN6S106C53v76Ev();
extern void _ZN6S106C53v77Ev();
extern void _ZN6S106C53v78Ev();
extern void _ZN6S106C53v79Ev();
extern void _ZN6S106C53v80Ev();
extern void _ZN6S106C53v81Ev();
extern void _ZN6S106C53v82Ev();
extern void _ZN6S106C53v83Ev();
extern void _ZN6S106C53v84Ev();
extern void _ZN6S106C53v85Ev();
extern void _ZN6S106C53v86Ev();
extern void _ZN6S106C53v87Ev();
extern void _ZN6S106C53v88Ev();
extern void _ZN6S106C53v89Ev();
extern void _ZN6S106C53v90Ev();
extern void _ZN6S106C53v91Ev();
extern void _ZN6S106C53v92Ev();
extern void _ZN6S106C53v93Ev();
extern void _ZN6S106C53v94Ev();
extern void _ZN6S106C53v95Ev();
extern void _ZN6S106C53v96Ev();
extern void _ZN6S106C53v97Ev();
extern void _ZN6S106C53v98Ev();
extern void _ZN6S106C53v99Ev();
extern void _ZN6S106C54v100Ev();
extern void _ZN6S106C54v101Ev();
extern void _ZN6S106C54v102Ev();
extern void _ZN6S106C54v103Ev();
extern void _ZN6S106C54v104Ev();
extern void _ZN6S106C54v105Ev();
extern void _ZN6S106C54v106Ev();
extern void _ZN6S106C54v107Ev();
extern void _ZN6S106C54v108Ev();
extern void _ZN6S106C54v109Ev();
extern void _ZN6S106C54v110Ev();
extern void _ZN6S106C54v111Ev();
extern void _ZN6S106C54v112Ev();
extern void _ZN6S106C54v113Ev();
extern void _ZN6S106C54v114Ev();
extern void _ZN6S106C54v115Ev();
extern void _ZN6S106C54v116Ev();
extern void _ZN6S106C54v117Ev();
extern void _ZN6S106C54v118Ev();
extern void _ZN6S106C54v119Ev();
extern void _ZN6S106C54v120Ev();
extern void _ZN6S106C54v121Ev();
extern void _ZN6S106C54v122Ev();
extern void _ZN6S106C54v123Ev();
extern void _ZN6S106C54v124Ev();
extern void _ZN6S106C54v125Ev();
extern void _ZN6S106C54v126Ev();
extern void _ZN6S106C54v127Ev();
extern void _ZN6S106C54v128Ev();
extern void _ZN6S106C54v129Ev();
extern void _ZN6S106C54v130Ev();
extern void _ZN6S106C54v131Ev();
extern void _ZN6S106C54v132Ev();
extern void _ZN6S106C54v133Ev();
extern void _ZN6S106C54v134Ev();
extern void _ZN6S106C54v135Ev();
extern void _ZN6S106C54v136Ev();
extern void _ZN6S106C54v137Ev();
extern void _ZN6S106C54v138Ev();
extern void _ZN6S106C54v139Ev();
extern void _ZN6S106C54v140Ev();
extern void _ZN6S106C54v141Ev();
extern void _ZN6S106C54v142Ev();
extern void _ZN6S106C54v143Ev();
extern void _ZN6S106C54v144Ev();
extern void _ZN6S106C54v145Ev();
extern void _ZN6S106C54v146Ev();
extern void _ZN6S106C54v147Ev();
extern void _ZN6S106C44v148Ev();
extern void _ZN6S106C44v149Ev();
extern void _ZN6S106C44v150Ev();
extern void _ZN6S106C44v151Ev();
extern void _ZN6S106C44v152Ev();
extern void _ZN6S106C44v153Ev();
extern void _ZN6S106C44v154Ev();
extern void _ZN6S106C44v155Ev();
extern void _ZN6S106C44v156Ev();
extern void _ZN6S106C44v157Ev();
extern void _ZN6S106C44v158Ev();
extern void _ZN6S106C44v159Ev();
extern void _ZN6S106C44v160Ev();
extern void _ZN6S106C44v161Ev();
extern void _ZN6S106C44v162Ev();
extern void _ZN6S106C44v163Ev();
extern void _ZN6S106C44v164Ev();
extern void _ZN6S106C44v165Ev();
extern void _ZN6S106C44v166Ev();
extern void _ZN6S106C44v167Ev();
extern void _ZN6S106C44v168Ev();
extern void _ZN6S106C44v169Ev();
extern void _ZN6S106C44v170Ev();
extern void _ZN6S106C44v171Ev();
extern void _ZN6S106C44v172Ev();
extern void _ZN6S106C44v173Ev();
extern void _ZN6S106C44v174Ev();
extern void _ZN6S106C44v175Ev();
extern void _ZN6S106C44v176Ev();
extern void _ZN6S106C44v177Ev();
extern void _ZN6S106C44v178Ev();
extern void _ZN6S106C44v179Ev();
extern void _ZN6S106C44v180Ev();
extern void _ZN6S106C44v181Ev();
extern void _ZN6S106C44v182Ev();
extern void _ZN6S106C44v183Ev();
extern void _ZN6S106C44v184Ev();
extern void _ZN6S106C44v185Ev();
extern void _ZN6S106C44v186Ev();
extern void _ZN6S106C34v187Ev();
extern void _ZN6S106C34v188Ev();
extern void _ZN6S106C34v189Ev();
extern void _ZN6S106C34v190Ev();
extern void _ZN6S106C34v191Ev();
extern void _ZN6S106C34v192Ev();
extern void _ZN6S106C34v193Ev();
extern void _ZN6S106C34v194Ev();
extern void _ZN6S106C34v195Ev();
extern void _ZN6S106C34v196Ev();
extern void _ZN6S106C34v197Ev();
extern void _ZN6S106C34v198Ev();
extern void _ZN6S106C34v199Ev();
extern void _ZN6S106C34v200Ev();
extern void _ZN6S106C34v201Ev();
extern void _ZN6S106C34v202Ev();
extern void _ZN6S106C34v203Ev();
extern void _ZN6S106C34v204Ev();
extern void _ZN6S106C34v205Ev();
extern void _ZN6S106C34v206Ev();
extern void _ZN6S106C34v207Ev();
extern void _ZN6S106C34v208Ev();
extern void _ZN6S106C34v209Ev();
static  VTBL_ENTRY vtc_S106C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C3[0]),
  (VTBL_ENTRY)&_ZN6S106C3D1Ev,
  (VTBL_ENTRY)&_ZN6S106C3D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
  (VTBL_ENTRY)&_ZN6S106C53v72Ev,
  (VTBL_ENTRY)&_ZN6S106C53v73Ev,
  (VTBL_ENTRY)&_ZN6S106C53v74Ev,
  (VTBL_ENTRY)&_ZN6S106C53v75Ev,
  (VTBL_ENTRY)&_ZN6S106C53v76Ev,
  (VTBL_ENTRY)&_ZN6S106C53v77Ev,
  (VTBL_ENTRY)&_ZN6S106C53v78Ev,
  (VTBL_ENTRY)&_ZN6S106C53v79Ev,
  (VTBL_ENTRY)&_ZN6S106C53v80Ev,
  (VTBL_ENTRY)&_ZN6S106C53v81Ev,
  (VTBL_ENTRY)&_ZN6S106C53v82Ev,
  (VTBL_ENTRY)&_ZN6S106C53v83Ev,
  (VTBL_ENTRY)&_ZN6S106C53v84Ev,
  (VTBL_ENTRY)&_ZN6S106C53v85Ev,
  (VTBL_ENTRY)&_ZN6S106C53v86Ev,
  (VTBL_ENTRY)&_ZN6S106C53v87Ev,
  (VTBL_ENTRY)&_ZN6S106C53v88Ev,
  (VTBL_ENTRY)&_ZN6S106C53v89Ev,
  (VTBL_ENTRY)&_ZN6S106C53v90Ev,
  (VTBL_ENTRY)&_ZN6S106C53v91Ev,
  (VTBL_ENTRY)&_ZN6S106C53v92Ev,
  (VTBL_ENTRY)&_ZN6S106C53v93Ev,
  (VTBL_ENTRY)&_ZN6S106C53v94Ev,
  (VTBL_ENTRY)&_ZN6S106C53v95Ev,
  (VTBL_ENTRY)&_ZN6S106C53v96Ev,
  (VTBL_ENTRY)&_ZN6S106C53v97Ev,
  (VTBL_ENTRY)&_ZN6S106C53v98Ev,
  (VTBL_ENTRY)&_ZN6S106C53v99Ev,
  (VTBL_ENTRY)&_ZN6S106C54v100Ev,
  (VTBL_ENTRY)&_ZN6S106C54v101Ev,
  (VTBL_ENTRY)&_ZN6S106C54v102Ev,
  (VTBL_ENTRY)&_ZN6S106C54v103Ev,
  (VTBL_ENTRY)&_ZN6S106C54v104Ev,
  (VTBL_ENTRY)&_ZN6S106C54v105Ev,
  (VTBL_ENTRY)&_ZN6S106C54v106Ev,
  (VTBL_ENTRY)&_ZN6S106C54v107Ev,
  (VTBL_ENTRY)&_ZN6S106C54v108Ev,
  (VTBL_ENTRY)&_ZN6S106C54v109Ev,
  (VTBL_ENTRY)&_ZN6S106C54v110Ev,
  (VTBL_ENTRY)&_ZN6S106C54v111Ev,
  (VTBL_ENTRY)&_ZN6S106C54v112Ev,
  (VTBL_ENTRY)&_ZN6S106C54v113Ev,
  (VTBL_ENTRY)&_ZN6S106C54v114Ev,
  (VTBL_ENTRY)&_ZN6S106C54v115Ev,
  (VTBL_ENTRY)&_ZN6S106C54v116Ev,
  (VTBL_ENTRY)&_ZN6S106C54v117Ev,
  (VTBL_ENTRY)&_ZN6S106C54v118Ev,
  (VTBL_ENTRY)&_ZN6S106C54v119Ev,
  (VTBL_ENTRY)&_ZN6S106C54v120Ev,
  (VTBL_ENTRY)&_ZN6S106C54v121Ev,
  (VTBL_ENTRY)&_ZN6S106C54v122Ev,
  (VTBL_ENTRY)&_ZN6S106C54v123Ev,
  (VTBL_ENTRY)&_ZN6S106C54v124Ev,
  (VTBL_ENTRY)&_ZN6S106C54v125Ev,
  (VTBL_ENTRY)&_ZN6S106C54v126Ev,
  (VTBL_ENTRY)&_ZN6S106C54v127Ev,
  (VTBL_ENTRY)&_ZN6S106C54v128Ev,
  (VTBL_ENTRY)&_ZN6S106C54v129Ev,
  (VTBL_ENTRY)&_ZN6S106C54v130Ev,
  (VTBL_ENTRY)&_ZN6S106C54v131Ev,
  (VTBL_ENTRY)&_ZN6S106C54v132Ev,
  (VTBL_ENTRY)&_ZN6S106C54v133Ev,
  (VTBL_ENTRY)&_ZN6S106C54v134Ev,
  (VTBL_ENTRY)&_ZN6S106C54v135Ev,
  (VTBL_ENTRY)&_ZN6S106C54v136Ev,
  (VTBL_ENTRY)&_ZN6S106C54v137Ev,
  (VTBL_ENTRY)&_ZN6S106C54v138Ev,
  (VTBL_ENTRY)&_ZN6S106C54v139Ev,
  (VTBL_ENTRY)&_ZN6S106C54v140Ev,
  (VTBL_ENTRY)&_ZN6S106C54v141Ev,
  (VTBL_ENTRY)&_ZN6S106C54v142Ev,
  (VTBL_ENTRY)&_ZN6S106C54v143Ev,
  (VTBL_ENTRY)&_ZN6S106C54v144Ev,
  (VTBL_ENTRY)&_ZN6S106C54v145Ev,
  (VTBL_ENTRY)&_ZN6S106C54v146Ev,
  (VTBL_ENTRY)&_ZN6S106C54v147Ev,
  (VTBL_ENTRY)&_ZN6S106C44v148Ev,
  (VTBL_ENTRY)&_ZN6S106C44v149Ev,
  (VTBL_ENTRY)&_ZN6S106C44v150Ev,
  (VTBL_ENTRY)&_ZN6S106C44v151Ev,
  (VTBL_ENTRY)&_ZN6S106C44v152Ev,
  (VTBL_ENTRY)&_ZN6S106C44v153Ev,
  (VTBL_ENTRY)&_ZN6S106C44v154Ev,
  (VTBL_ENTRY)&_ZN6S106C44v155Ev,
  (VTBL_ENTRY)&_ZN6S106C44v156Ev,
  (VTBL_ENTRY)&_ZN6S106C44v157Ev,
  (VTBL_ENTRY)&_ZN6S106C44v158Ev,
  (VTBL_ENTRY)&_ZN6S106C44v159Ev,
  (VTBL_ENTRY)&_ZN6S106C44v160Ev,
  (VTBL_ENTRY)&_ZN6S106C44v161Ev,
  (VTBL_ENTRY)&_ZN6S106C44v162Ev,
  (VTBL_ENTRY)&_ZN6S106C44v163Ev,
  (VTBL_ENTRY)&_ZN6S106C44v164Ev,
  (VTBL_ENTRY)&_ZN6S106C44v165Ev,
  (VTBL_ENTRY)&_ZN6S106C44v166Ev,
  (VTBL_ENTRY)&_ZN6S106C44v167Ev,
  (VTBL_ENTRY)&_ZN6S106C44v168Ev,
  (VTBL_ENTRY)&_ZN6S106C44v169Ev,
  (VTBL_ENTRY)&_ZN6S106C44v170Ev,
  (VTBL_ENTRY)&_ZN6S106C44v171Ev,
  (VTBL_ENTRY)&_ZN6S106C44v172Ev,
  (VTBL_ENTRY)&_ZN6S106C44v173Ev,
  (VTBL_ENTRY)&_ZN6S106C44v174Ev,
  (VTBL_ENTRY)&_ZN6S106C44v175Ev,
  (VTBL_ENTRY)&_ZN6S106C44v176Ev,
  (VTBL_ENTRY)&_ZN6S106C44v177Ev,
  (VTBL_ENTRY)&_ZN6S106C44v178Ev,
  (VTBL_ENTRY)&_ZN6S106C44v179Ev,
  (VTBL_ENTRY)&_ZN6S106C44v180Ev,
  (VTBL_ENTRY)&_ZN6S106C44v181Ev,
  (VTBL_ENTRY)&_ZN6S106C44v182Ev,
  (VTBL_ENTRY)&_ZN6S106C44v183Ev,
  (VTBL_ENTRY)&_ZN6S106C44v184Ev,
  (VTBL_ENTRY)&_ZN6S106C44v185Ev,
  (VTBL_ENTRY)&_ZN6S106C44v186Ev,
  (VTBL_ENTRY)&_ZN6S106C34v187Ev,
  (VTBL_ENTRY)&_ZN6S106C34v188Ev,
  (VTBL_ENTRY)&_ZN6S106C34v189Ev,
  (VTBL_ENTRY)&_ZN6S106C34v190Ev,
  (VTBL_ENTRY)&_ZN6S106C34v191Ev,
  (VTBL_ENTRY)&_ZN6S106C34v192Ev,
  (VTBL_ENTRY)&_ZN6S106C34v193Ev,
  (VTBL_ENTRY)&_ZN6S106C34v194Ev,
  (VTBL_ENTRY)&_ZN6S106C34v195Ev,
  (VTBL_ENTRY)&_ZN6S106C34v196Ev,
  (VTBL_ENTRY)&_ZN6S106C34v197Ev,
  (VTBL_ENTRY)&_ZN6S106C34v198Ev,
  (VTBL_ENTRY)&_ZN6S106C34v199Ev,
  (VTBL_ENTRY)&_ZN6S106C34v200Ev,
  (VTBL_ENTRY)&_ZN6S106C34v201Ev,
  (VTBL_ENTRY)&_ZN6S106C34v202Ev,
  (VTBL_ENTRY)&_ZN6S106C34v203Ev,
  (VTBL_ENTRY)&_ZN6S106C34v204Ev,
  (VTBL_ENTRY)&_ZN6S106C34v205Ev,
  (VTBL_ENTRY)&_ZN6S106C34v206Ev,
  (VTBL_ENTRY)&_ZN6S106C34v207Ev,
  (VTBL_ENTRY)&_ZN6S106C34v208Ev,
  (VTBL_ENTRY)&_ZN6S106C34v209Ev,
};
extern VTBL_ENTRY _ZTI6S106C3[];
extern  VTBL_ENTRY _ZTV6S106C3[];
Class_Descriptor cd_S106C3 = {  "S106C3", // class name
  bases_S106C3, 4,
  &(vtc_S106C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI6S106C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C2  : S106C3 {
  void *s106c2f0[2];
  int s106c2f1[2];
  char s106c2f2;
  void *s106c2f3;
  unsigned int s106c2f4:1;
  unsigned int s106c2f5:1;
  ::S80C28_nt s106c2f6;
  virtual  ~S106C2(); // _ZN6S106C2D1Ev
  virtual void  v210(); // _ZN6S106C24v210Ev
  virtual void  v211(); // _ZN6S106C24v211Ev
  virtual void  v212(); // _ZN6S106C24v212Ev
  virtual void  v213(); // _ZN6S106C24v213Ev
  virtual void  v214(); // _ZN6S106C24v214Ev
  virtual void  v215(); // _ZN6S106C24v215Ev
  virtual void  v216(); // _ZN6S106C24v216Ev
  virtual void  v217(); // _ZN6S106C24v217Ev
  S106C2(); // tgen
};
//SIG(-1 S106C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC21{ m Fi[2]}} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 FC7 Fp[9] FC22{ BC23{ BC11}} FC9 FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC21 FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC27{ BC16}}


 S106C2 ::~S106C2(){ note_dtor("S106C2", this);}
void  S106C2 ::v210(){vfunc_called(this, "_ZN6S106C24v210Ev");}
void  S106C2 ::v211(){vfunc_called(this, "_ZN6S106C24v211Ev");}
void  S106C2 ::v212(){vfunc_called(this, "_ZN6S106C24v212Ev");}
void  S106C2 ::v213(){vfunc_called(this, "_ZN6S106C24v213Ev");}
void  S106C2 ::v214(){vfunc_called(this, "_ZN6S106C24v214Ev");}
void  S106C2 ::v215(){vfunc_called(this, "_ZN6S106C24v215Ev");}
void  S106C2 ::v216(){vfunc_called(this, "_ZN6S106C24v216Ev");}
void  S106C2 ::v217(){vfunc_called(this, "_ZN6S106C24v217Ev");}
S106C2 ::S106C2(){ note_ctor("S106C2", this);} // tgen

static void Test_S106C2()
{
  extern Class_Descriptor cd_S106C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,165)];
    init_test(&cd_S106C2, buf);
    S106C2 *dp, &lv = *(dp=new (buf) S106C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,656), "sizeof(S106C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C2)");
    check_base_class_offset(lv, (S106C7*)(S106C6*)(S106C5*)(S106C4*)(S106C3*), 0, "S106C2");
    check_base_class_offset(lv, (S106C6*)(S106C5*)(S106C4*)(S106C3*), 0, "S106C2");
    check_base_class_offset(lv, (S106C5*)(S106C4*)(S106C3*), 0, "S106C2");
    check_base_class_offset(lv, (S106C4*)(S106C3*), 0, "S106C2");
    check_base_class_offset(lv, (S106C3*), 0, "S106C2");
    check_field_offset(lv, s106c2f0, ABISELECT(864,616), "S106C2.s106c2f0");
    check_field_offset(lv, s106c2f1, ABISELECT(880,624), "S106C2.s106c2f1");
    check_field_offset(lv, s106c2f2, ABISELECT(888,632), "S106C2.s106c2f2");
    check_field_offset(lv, s106c2f3, ABISELECT(896,636), "S106C2.s106c2f3");
    set_bf_and_test(lv, s106c2f4, ABISELECT(904,640), 0, 1, 1, "S106C2");
    set_bf_and_test(lv, s106c2f5, ABISELECT(904,640), 1, 1, 1, "S106C2");
    check_field_offset(lv, s106c2f6, ABISELECT(912,644), "S106C2.s106c2f6");
    test_class_info(&lv, &cd_S106C2);
    dp->~S106C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C2(Test_S106C2, "S106C2", ABISELECT(928,656));

#else // __cplusplus

extern void _ZN6S106C2C1Ev();
extern void _ZN6S106C2D1Ev();
Name_Map name_map_S106C2[] = {
  NSPAIR(_ZN6S106C2C1Ev),
  NSPAIR(_ZN6S106C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
extern Class_Descriptor cd_S106C6;
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
extern Class_Descriptor cd_S106C5;
extern VTBL_ENTRY _ZTI6S106C5[];
extern  VTBL_ENTRY _ZTV6S106C5[];
extern Class_Descriptor cd_S106C4;
extern VTBL_ENTRY _ZTI6S106C4[];
extern  VTBL_ENTRY _ZTV6S106C4[];
extern Class_Descriptor cd_S106C3;
extern VTBL_ENTRY _ZTI6S106C3[];
extern  VTBL_ENTRY _ZTV6S106C3[];
static Base_Class bases_S106C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S106C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S106C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S106C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S106C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C2[];
extern void _ZN6S106C2D1Ev();
extern void _ZN6S106C2D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
extern void _ZN6S106C53v72Ev();
extern void _ZN6S106C53v73Ev();
extern void _ZN6S106C53v74Ev();
extern void _ZN6S106C53v75Ev();
extern void _ZN6S106C53v76Ev();
extern void _ZN6S106C53v77Ev();
extern void _ZN6S106C53v78Ev();
extern void _ZN6S106C53v79Ev();
extern void _ZN6S106C53v80Ev();
extern void _ZN6S106C53v81Ev();
extern void _ZN6S106C53v82Ev();
extern void _ZN6S106C53v83Ev();
extern void _ZN6S106C53v84Ev();
extern void _ZN6S106C53v85Ev();
extern void _ZN6S106C53v86Ev();
extern void _ZN6S106C53v87Ev();
extern void _ZN6S106C53v88Ev();
extern void _ZN6S106C53v89Ev();
extern void _ZN6S106C53v90Ev();
extern void _ZN6S106C53v91Ev();
extern void _ZN6S106C53v92Ev();
extern void _ZN6S106C53v93Ev();
extern void _ZN6S106C53v94Ev();
extern void _ZN6S106C53v95Ev();
extern void _ZN6S106C53v96Ev();
extern void _ZN6S106C53v97Ev();
extern void _ZN6S106C53v98Ev();
extern void _ZN6S106C53v99Ev();
extern void _ZN6S106C54v100Ev();
extern void _ZN6S106C54v101Ev();
extern void _ZN6S106C54v102Ev();
extern void _ZN6S106C54v103Ev();
extern void _ZN6S106C54v104Ev();
extern void _ZN6S106C54v105Ev();
extern void _ZN6S106C54v106Ev();
extern void _ZN6S106C54v107Ev();
extern void _ZN6S106C54v108Ev();
extern void _ZN6S106C54v109Ev();
extern void _ZN6S106C54v110Ev();
extern void _ZN6S106C54v111Ev();
extern void _ZN6S106C54v112Ev();
extern void _ZN6S106C54v113Ev();
extern void _ZN6S106C54v114Ev();
extern void _ZN6S106C54v115Ev();
extern void _ZN6S106C54v116Ev();
extern void _ZN6S106C54v117Ev();
extern void _ZN6S106C54v118Ev();
extern void _ZN6S106C54v119Ev();
extern void _ZN6S106C54v120Ev();
extern void _ZN6S106C54v121Ev();
extern void _ZN6S106C54v122Ev();
extern void _ZN6S106C54v123Ev();
extern void _ZN6S106C54v124Ev();
extern void _ZN6S106C54v125Ev();
extern void _ZN6S106C54v126Ev();
extern void _ZN6S106C54v127Ev();
extern void _ZN6S106C54v128Ev();
extern void _ZN6S106C54v129Ev();
extern void _ZN6S106C54v130Ev();
extern void _ZN6S106C54v131Ev();
extern void _ZN6S106C54v132Ev();
extern void _ZN6S106C54v133Ev();
extern void _ZN6S106C54v134Ev();
extern void _ZN6S106C54v135Ev();
extern void _ZN6S106C54v136Ev();
extern void _ZN6S106C54v137Ev();
extern void _ZN6S106C54v138Ev();
extern void _ZN6S106C54v139Ev();
extern void _ZN6S106C54v140Ev();
extern void _ZN6S106C54v141Ev();
extern void _ZN6S106C54v142Ev();
extern void _ZN6S106C54v143Ev();
extern void _ZN6S106C54v144Ev();
extern void _ZN6S106C54v145Ev();
extern void _ZN6S106C54v146Ev();
extern void _ZN6S106C54v147Ev();
extern void _ZN6S106C44v148Ev();
extern void _ZN6S106C44v149Ev();
extern void _ZN6S106C44v150Ev();
extern void _ZN6S106C44v151Ev();
extern void _ZN6S106C44v152Ev();
extern void _ZN6S106C44v153Ev();
extern void _ZN6S106C44v154Ev();
extern void _ZN6S106C44v155Ev();
extern void _ZN6S106C44v156Ev();
extern void _ZN6S106C44v157Ev();
extern void _ZN6S106C44v158Ev();
extern void _ZN6S106C44v159Ev();
extern void _ZN6S106C44v160Ev();
extern void _ZN6S106C44v161Ev();
extern void _ZN6S106C44v162Ev();
extern void _ZN6S106C44v163Ev();
extern void _ZN6S106C44v164Ev();
extern void _ZN6S106C44v165Ev();
extern void _ZN6S106C44v166Ev();
extern void _ZN6S106C44v167Ev();
extern void _ZN6S106C44v168Ev();
extern void _ZN6S106C44v169Ev();
extern void _ZN6S106C44v170Ev();
extern void _ZN6S106C44v171Ev();
extern void _ZN6S106C44v172Ev();
extern void _ZN6S106C44v173Ev();
extern void _ZN6S106C44v174Ev();
extern void _ZN6S106C44v175Ev();
extern void _ZN6S106C44v176Ev();
extern void _ZN6S106C44v177Ev();
extern void _ZN6S106C44v178Ev();
extern void _ZN6S106C44v179Ev();
extern void _ZN6S106C44v180Ev();
extern void _ZN6S106C44v181Ev();
extern void _ZN6S106C44v182Ev();
extern void _ZN6S106C44v183Ev();
extern void _ZN6S106C44v184Ev();
extern void _ZN6S106C44v185Ev();
extern void _ZN6S106C44v186Ev();
extern void _ZN6S106C34v187Ev();
extern void _ZN6S106C34v188Ev();
extern void _ZN6S106C34v189Ev();
extern void _ZN6S106C34v190Ev();
extern void _ZN6S106C34v191Ev();
extern void _ZN6S106C34v192Ev();
extern void _ZN6S106C34v193Ev();
extern void _ZN6S106C34v194Ev();
extern void _ZN6S106C34v195Ev();
extern void _ZN6S106C34v196Ev();
extern void _ZN6S106C34v197Ev();
extern void _ZN6S106C34v198Ev();
extern void _ZN6S106C34v199Ev();
extern void _ZN6S106C34v200Ev();
extern void _ZN6S106C34v201Ev();
extern void _ZN6S106C34v202Ev();
extern void _ZN6S106C34v203Ev();
extern void _ZN6S106C34v204Ev();
extern void _ZN6S106C34v205Ev();
extern void _ZN6S106C34v206Ev();
extern void _ZN6S106C34v207Ev();
extern void _ZN6S106C34v208Ev();
extern void _ZN6S106C34v209Ev();
extern void _ZN6S106C24v210Ev();
extern void _ZN6S106C24v211Ev();
extern void _ZN6S106C24v212Ev();
extern void _ZN6S106C24v213Ev();
extern void _ZN6S106C24v214Ev();
extern void _ZN6S106C24v215Ev();
extern void _ZN6S106C24v216Ev();
extern void _ZN6S106C24v217Ev();
static  VTBL_ENTRY vtc_S106C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C2[0]),
  (VTBL_ENTRY)&_ZN6S106C2D1Ev,
  (VTBL_ENTRY)&_ZN6S106C2D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
  (VTBL_ENTRY)&_ZN6S106C53v72Ev,
  (VTBL_ENTRY)&_ZN6S106C53v73Ev,
  (VTBL_ENTRY)&_ZN6S106C53v74Ev,
  (VTBL_ENTRY)&_ZN6S106C53v75Ev,
  (VTBL_ENTRY)&_ZN6S106C53v76Ev,
  (VTBL_ENTRY)&_ZN6S106C53v77Ev,
  (VTBL_ENTRY)&_ZN6S106C53v78Ev,
  (VTBL_ENTRY)&_ZN6S106C53v79Ev,
  (VTBL_ENTRY)&_ZN6S106C53v80Ev,
  (VTBL_ENTRY)&_ZN6S106C53v81Ev,
  (VTBL_ENTRY)&_ZN6S106C53v82Ev,
  (VTBL_ENTRY)&_ZN6S106C53v83Ev,
  (VTBL_ENTRY)&_ZN6S106C53v84Ev,
  (VTBL_ENTRY)&_ZN6S106C53v85Ev,
  (VTBL_ENTRY)&_ZN6S106C53v86Ev,
  (VTBL_ENTRY)&_ZN6S106C53v87Ev,
  (VTBL_ENTRY)&_ZN6S106C53v88Ev,
  (VTBL_ENTRY)&_ZN6S106C53v89Ev,
  (VTBL_ENTRY)&_ZN6S106C53v90Ev,
  (VTBL_ENTRY)&_ZN6S106C53v91Ev,
  (VTBL_ENTRY)&_ZN6S106C53v92Ev,
  (VTBL_ENTRY)&_ZN6S106C53v93Ev,
  (VTBL_ENTRY)&_ZN6S106C53v94Ev,
  (VTBL_ENTRY)&_ZN6S106C53v95Ev,
  (VTBL_ENTRY)&_ZN6S106C53v96Ev,
  (VTBL_ENTRY)&_ZN6S106C53v97Ev,
  (VTBL_ENTRY)&_ZN6S106C53v98Ev,
  (VTBL_ENTRY)&_ZN6S106C53v99Ev,
  (VTBL_ENTRY)&_ZN6S106C54v100Ev,
  (VTBL_ENTRY)&_ZN6S106C54v101Ev,
  (VTBL_ENTRY)&_ZN6S106C54v102Ev,
  (VTBL_ENTRY)&_ZN6S106C54v103Ev,
  (VTBL_ENTRY)&_ZN6S106C54v104Ev,
  (VTBL_ENTRY)&_ZN6S106C54v105Ev,
  (VTBL_ENTRY)&_ZN6S106C54v106Ev,
  (VTBL_ENTRY)&_ZN6S106C54v107Ev,
  (VTBL_ENTRY)&_ZN6S106C54v108Ev,
  (VTBL_ENTRY)&_ZN6S106C54v109Ev,
  (VTBL_ENTRY)&_ZN6S106C54v110Ev,
  (VTBL_ENTRY)&_ZN6S106C54v111Ev,
  (VTBL_ENTRY)&_ZN6S106C54v112Ev,
  (VTBL_ENTRY)&_ZN6S106C54v113Ev,
  (VTBL_ENTRY)&_ZN6S106C54v114Ev,
  (VTBL_ENTRY)&_ZN6S106C54v115Ev,
  (VTBL_ENTRY)&_ZN6S106C54v116Ev,
  (VTBL_ENTRY)&_ZN6S106C54v117Ev,
  (VTBL_ENTRY)&_ZN6S106C54v118Ev,
  (VTBL_ENTRY)&_ZN6S106C54v119Ev,
  (VTBL_ENTRY)&_ZN6S106C54v120Ev,
  (VTBL_ENTRY)&_ZN6S106C54v121Ev,
  (VTBL_ENTRY)&_ZN6S106C54v122Ev,
  (VTBL_ENTRY)&_ZN6S106C54v123Ev,
  (VTBL_ENTRY)&_ZN6S106C54v124Ev,
  (VTBL_ENTRY)&_ZN6S106C54v125Ev,
  (VTBL_ENTRY)&_ZN6S106C54v126Ev,
  (VTBL_ENTRY)&_ZN6S106C54v127Ev,
  (VTBL_ENTRY)&_ZN6S106C54v128Ev,
  (VTBL_ENTRY)&_ZN6S106C54v129Ev,
  (VTBL_ENTRY)&_ZN6S106C54v130Ev,
  (VTBL_ENTRY)&_ZN6S106C54v131Ev,
  (VTBL_ENTRY)&_ZN6S106C54v132Ev,
  (VTBL_ENTRY)&_ZN6S106C54v133Ev,
  (VTBL_ENTRY)&_ZN6S106C54v134Ev,
  (VTBL_ENTRY)&_ZN6S106C54v135Ev,
  (VTBL_ENTRY)&_ZN6S106C54v136Ev,
  (VTBL_ENTRY)&_ZN6S106C54v137Ev,
  (VTBL_ENTRY)&_ZN6S106C54v138Ev,
  (VTBL_ENTRY)&_ZN6S106C54v139Ev,
  (VTBL_ENTRY)&_ZN6S106C54v140Ev,
  (VTBL_ENTRY)&_ZN6S106C54v141Ev,
  (VTBL_ENTRY)&_ZN6S106C54v142Ev,
  (VTBL_ENTRY)&_ZN6S106C54v143Ev,
  (VTBL_ENTRY)&_ZN6S106C54v144Ev,
  (VTBL_ENTRY)&_ZN6S106C54v145Ev,
  (VTBL_ENTRY)&_ZN6S106C54v146Ev,
  (VTBL_ENTRY)&_ZN6S106C54v147Ev,
  (VTBL_ENTRY)&_ZN6S106C44v148Ev,
  (VTBL_ENTRY)&_ZN6S106C44v149Ev,
  (VTBL_ENTRY)&_ZN6S106C44v150Ev,
  (VTBL_ENTRY)&_ZN6S106C44v151Ev,
  (VTBL_ENTRY)&_ZN6S106C44v152Ev,
  (VTBL_ENTRY)&_ZN6S106C44v153Ev,
  (VTBL_ENTRY)&_ZN6S106C44v154Ev,
  (VTBL_ENTRY)&_ZN6S106C44v155Ev,
  (VTBL_ENTRY)&_ZN6S106C44v156Ev,
  (VTBL_ENTRY)&_ZN6S106C44v157Ev,
  (VTBL_ENTRY)&_ZN6S106C44v158Ev,
  (VTBL_ENTRY)&_ZN6S106C44v159Ev,
  (VTBL_ENTRY)&_ZN6S106C44v160Ev,
  (VTBL_ENTRY)&_ZN6S106C44v161Ev,
  (VTBL_ENTRY)&_ZN6S106C44v162Ev,
  (VTBL_ENTRY)&_ZN6S106C44v163Ev,
  (VTBL_ENTRY)&_ZN6S106C44v164Ev,
  (VTBL_ENTRY)&_ZN6S106C44v165Ev,
  (VTBL_ENTRY)&_ZN6S106C44v166Ev,
  (VTBL_ENTRY)&_ZN6S106C44v167Ev,
  (VTBL_ENTRY)&_ZN6S106C44v168Ev,
  (VTBL_ENTRY)&_ZN6S106C44v169Ev,
  (VTBL_ENTRY)&_ZN6S106C44v170Ev,
  (VTBL_ENTRY)&_ZN6S106C44v171Ev,
  (VTBL_ENTRY)&_ZN6S106C44v172Ev,
  (VTBL_ENTRY)&_ZN6S106C44v173Ev,
  (VTBL_ENTRY)&_ZN6S106C44v174Ev,
  (VTBL_ENTRY)&_ZN6S106C44v175Ev,
  (VTBL_ENTRY)&_ZN6S106C44v176Ev,
  (VTBL_ENTRY)&_ZN6S106C44v177Ev,
  (VTBL_ENTRY)&_ZN6S106C44v178Ev,
  (VTBL_ENTRY)&_ZN6S106C44v179Ev,
  (VTBL_ENTRY)&_ZN6S106C44v180Ev,
  (VTBL_ENTRY)&_ZN6S106C44v181Ev,
  (VTBL_ENTRY)&_ZN6S106C44v182Ev,
  (VTBL_ENTRY)&_ZN6S106C44v183Ev,
  (VTBL_ENTRY)&_ZN6S106C44v184Ev,
  (VTBL_ENTRY)&_ZN6S106C44v185Ev,
  (VTBL_ENTRY)&_ZN6S106C44v186Ev,
  (VTBL_ENTRY)&_ZN6S106C34v187Ev,
  (VTBL_ENTRY)&_ZN6S106C34v188Ev,
  (VTBL_ENTRY)&_ZN6S106C34v189Ev,
  (VTBL_ENTRY)&_ZN6S106C34v190Ev,
  (VTBL_ENTRY)&_ZN6S106C34v191Ev,
  (VTBL_ENTRY)&_ZN6S106C34v192Ev,
  (VTBL_ENTRY)&_ZN6S106C34v193Ev,
  (VTBL_ENTRY)&_ZN6S106C34v194Ev,
  (VTBL_ENTRY)&_ZN6S106C34v195Ev,
  (VTBL_ENTRY)&_ZN6S106C34v196Ev,
  (VTBL_ENTRY)&_ZN6S106C34v197Ev,
  (VTBL_ENTRY)&_ZN6S106C34v198Ev,
  (VTBL_ENTRY)&_ZN6S106C34v199Ev,
  (VTBL_ENTRY)&_ZN6S106C34v200Ev,
  (VTBL_ENTRY)&_ZN6S106C34v201Ev,
  (VTBL_ENTRY)&_ZN6S106C34v202Ev,
  (VTBL_ENTRY)&_ZN6S106C34v203Ev,
  (VTBL_ENTRY)&_ZN6S106C34v204Ev,
  (VTBL_ENTRY)&_ZN6S106C34v205Ev,
  (VTBL_ENTRY)&_ZN6S106C34v206Ev,
  (VTBL_ENTRY)&_ZN6S106C34v207Ev,
  (VTBL_ENTRY)&_ZN6S106C34v208Ev,
  (VTBL_ENTRY)&_ZN6S106C34v209Ev,
  (VTBL_ENTRY)&_ZN6S106C24v210Ev,
  (VTBL_ENTRY)&_ZN6S106C24v211Ev,
  (VTBL_ENTRY)&_ZN6S106C24v212Ev,
  (VTBL_ENTRY)&_ZN6S106C24v213Ev,
  (VTBL_ENTRY)&_ZN6S106C24v214Ev,
  (VTBL_ENTRY)&_ZN6S106C24v215Ev,
  (VTBL_ENTRY)&_ZN6S106C24v216Ev,
  (VTBL_ENTRY)&_ZN6S106C24v217Ev,
};
extern VTBL_ENTRY _ZTI6S106C2[];
extern  VTBL_ENTRY _ZTV6S106C2[];
Class_Descriptor cd_S106C2 = {  "S106C2", // class name
  bases_S106C2, 5,
  &(vtc_S106C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,656), // object size
  NSPAIRA(_ZTI6S106C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C2),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S106C1  : S106C2 {
  int s106c1f0[3];
  unsigned int s106c1f1:1;
  int s106c1f2;
  ::S80C10_nt s106c1f3;
  int s106c1f4[2];
  void *s106c1f5[15];
  int s106c1f6[4];
  ::S37C34_nt s106c1f7;
  virtual  ~S106C1(); // _ZN6S106C1D1Ev
  virtual void  v1(); // _ZN6S106C12v1Ev
  virtual void  v2(); // _ZN6S106C12v2Ev
  virtual void  v3(); // _ZN6S106C12v3Ev
  virtual void  v4(); // _ZN6S106C12v4Ev
  virtual void  v5(); // _ZN6S106C12v5Ev
  S106C1(); // tgen
};
//SIG(1 S106C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC22{ m Fi[2]}} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 FC8 Fp[9] FC23{ BC24{ BC12}} FC10 FC25{ BC26{ m FC27{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC22 FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v210 v211 v212 v213 v214 v215 v216 v217 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC28{ BC17}} vd v1 v2 v3 v4 v5 Fi[3] Fi:1 Fi FC29{ BC30{ BC12}} Fi[2] Fp[15] Fi[4] FC31{ BC32{ BC12}}}


 S106C1 ::~S106C1(){ note_dtor("S106C1", this);}
void  S106C1 ::v1(){vfunc_called(this, "_ZN6S106C12v1Ev");}
void  S106C1 ::v2(){vfunc_called(this, "_ZN6S106C12v2Ev");}
void  S106C1 ::v3(){vfunc_called(this, "_ZN6S106C12v3Ev");}
void  S106C1 ::v4(){vfunc_called(this, "_ZN6S106C12v4Ev");}
void  S106C1 ::v5(){vfunc_called(this, "_ZN6S106C12v5Ev");}
S106C1 ::S106C1(){ note_ctor("S106C1", this);} // tgen

static void Test_S106C1()
{
  extern Class_Descriptor cd_S106C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(142,197)];
    init_test(&cd_S106C1, buf);
    S106C1 *dp, &lv = *(dp=new (buf) S106C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1128,784), "sizeof(S106C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S106C1)");
    check_base_class_offset(lv, (S106C7*)(S106C6*)(S106C5*)(S106C4*)(S106C3*)(S106C2*), 0, "S106C1");
    check_base_class_offset(lv, (S106C6*)(S106C5*)(S106C4*)(S106C3*)(S106C2*), 0, "S106C1");
    check_base_class_offset(lv, (S106C5*)(S106C4*)(S106C3*)(S106C2*), 0, "S106C1");
    check_base_class_offset(lv, (S106C4*)(S106C3*)(S106C2*), 0, "S106C1");
    check_base_class_offset(lv, (S106C3*)(S106C2*), 0, "S106C1");
    check_base_class_offset(lv, (S106C2*), 0, "S106C1");
    check_field_offset(lv, s106c1f0, ABISELECT(928,656), "S106C1.s106c1f0");
    set_bf_and_test(lv, s106c1f1, ABISELECT(940,668), 0, 1, 1, "S106C1");
    check_field_offset(lv, s106c1f2, ABISELECT(944,672), "S106C1.s106c1f2");
    check_field_offset(lv, s106c1f3, ABISELECT(952,676), "S106C1.s106c1f3");
    check_field_offset(lv, s106c1f4, ABISELECT(968,688), "S106C1.s106c1f4");
    check_field_offset(lv, s106c1f5, ABISELECT(976,696), "S106C1.s106c1f5");
    check_field_offset(lv, s106c1f6, ABISELECT(1096,756), "S106C1.s106c1f6");
    check_field_offset(lv, s106c1f7, ABISELECT(1112,772), "S106C1.s106c1f7");
    test_class_info(&lv, &cd_S106C1);
    dp->~S106C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS106C1(Test_S106C1, "S106C1", ABISELECT(1128,784));

#else // __cplusplus

extern void _ZN6S106C1C1Ev();
extern void _ZN6S106C1D1Ev();
Name_Map name_map_S106C1[] = {
  NSPAIR(_ZN6S106C1C1Ev),
  NSPAIR(_ZN6S106C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S106C7;
extern VTBL_ENTRY _ZTI6S106C7[];
extern  VTBL_ENTRY _ZTV6S106C7[];
extern Class_Descriptor cd_S106C6;
extern VTBL_ENTRY _ZTI6S106C6[];
extern  VTBL_ENTRY _ZTV6S106C6[];
extern Class_Descriptor cd_S106C5;
extern VTBL_ENTRY _ZTI6S106C5[];
extern  VTBL_ENTRY _ZTV6S106C5[];
extern Class_Descriptor cd_S106C4;
extern VTBL_ENTRY _ZTI6S106C4[];
extern  VTBL_ENTRY _ZTV6S106C4[];
extern Class_Descriptor cd_S106C3;
extern VTBL_ENTRY _ZTI6S106C3[];
extern  VTBL_ENTRY _ZTV6S106C3[];
extern Class_Descriptor cd_S106C2;
extern VTBL_ENTRY _ZTI6S106C2[];
extern  VTBL_ENTRY _ZTV6S106C2[];
static Base_Class bases_S106C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S106C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S106C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S106C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S106C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S106C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S106C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S106C1[];
extern void _ZN6S106C1D1Ev();
extern void _ZN6S106C1D0Ev();
extern void _ZN6S106C72v6Ev();
extern void _ZN6S106C72v7Ev();
extern void _ZN6S106C72v8Ev();
extern void _ZN6S106C72v9Ev();
extern void _ZN6S106C73v10Ev();
extern void _ZN6S106C73v11Ev();
extern void _ZN6S106C73v12Ev();
extern void _ZN6S106C73v13Ev();
extern void _ZN6S106C73v14Ev();
extern void _ZN6S106C73v15Ev();
extern void _ZN6S106C73v16Ev();
extern void _ZN6S106C73v17Ev();
extern void _ZN6S106C73v18Ev();
extern void _ZN6S106C73v19Ev();
extern void _ZN6S106C73v20Ev();
extern void _ZN6S106C73v21Ev();
extern void _ZN6S106C73v22Ev();
extern void _ZN6S106C73v23Ev();
extern void _ZN6S106C73v24Ev();
extern void _ZN6S106C73v25Ev();
extern void _ZN6S106C73v26Ev();
extern void _ZN6S106C73v27Ev();
extern void _ZN6S106C73v28Ev();
extern void _ZN6S106C73v29Ev();
extern void _ZN6S106C73v30Ev();
extern void _ZN6S106C73v31Ev();
extern void _ZN6S106C73v32Ev();
extern void _ZN6S106C73v33Ev();
extern void _ZN6S106C73v34Ev();
extern void _ZN6S106C73v35Ev();
extern void _ZN6S106C73v36Ev();
extern void _ZN6S106C73v37Ev();
extern void _ZN6S106C73v38Ev();
extern void _ZN6S106C73v39Ev();
extern void _ZN6S106C73v40Ev();
extern void _ZN6S106C73v41Ev();
extern void _ZN6S106C73v42Ev();
extern void _ZN6S106C73v43Ev();
extern void _ZN6S106C73v44Ev();
extern void _ZN6S106C73v45Ev();
extern void _ZN6S106C73v46Ev();
extern void _ZN6S106C73v47Ev();
extern void _ZN6S106C73v48Ev();
extern void _ZN6S106C73v49Ev();
extern void _ZN6S106C73v50Ev();
extern void _ZN6S106C73v51Ev();
extern void _ZN6S106C73v52Ev();
extern void _ZN6S106C73v53Ev();
extern void _ZN6S106C73v54Ev();
extern void _ZN6S106C73v55Ev();
extern void _ZN6S106C73v56Ev();
extern void _ZN6S106C73v57Ev();
extern void _ZN6S106C73v58Ev();
extern void _ZN6S106C73v59Ev();
extern void _ZN6S106C73v60Ev();
extern void _ZN6S106C73v61Ev();
extern void _ZN6S106C73v62Ev();
extern void _ZN6S106C73v63Ev();
extern void _ZN6S106C73v64Ev();
extern void _ZN6S106C73v65Ev();
extern void _ZN6S106C73v66Ev();
extern void _ZN6S106C73v67Ev();
extern void _ZN6S106C73v68Ev();
extern void _ZN6S106C73v69Ev();
extern void _ZN6S106C63v70Ev();
extern void _ZN6S106C63v71Ev();
extern void _ZN6S106C53v72Ev();
extern void _ZN6S106C53v73Ev();
extern void _ZN6S106C53v74Ev();
extern void _ZN6S106C53v75Ev();
extern void _ZN6S106C53v76Ev();
extern void _ZN6S106C53v77Ev();
extern void _ZN6S106C53v78Ev();
extern void _ZN6S106C53v79Ev();
extern void _ZN6S106C53v80Ev();
extern void _ZN6S106C53v81Ev();
extern void _ZN6S106C53v82Ev();
extern void _ZN6S106C53v83Ev();
extern void _ZN6S106C53v84Ev();
extern void _ZN6S106C53v85Ev();
extern void _ZN6S106C53v86Ev();
extern void _ZN6S106C53v87Ev();
extern void _ZN6S106C53v88Ev();
extern void _ZN6S106C53v89Ev();
extern void _ZN6S106C53v90Ev();
extern void _ZN6S106C53v91Ev();
extern void _ZN6S106C53v92Ev();
extern void _ZN6S106C53v93Ev();
extern void _ZN6S106C53v94Ev();
extern void _ZN6S106C53v95Ev();
extern void _ZN6S106C53v96Ev();
extern void _ZN6S106C53v97Ev();
extern void _ZN6S106C53v98Ev();
extern void _ZN6S106C53v99Ev();
extern void _ZN6S106C54v100Ev();
extern void _ZN6S106C54v101Ev();
extern void _ZN6S106C54v102Ev();
extern void _ZN6S106C54v103Ev();
extern void _ZN6S106C54v104Ev();
extern void _ZN6S106C54v105Ev();
extern void _ZN6S106C54v106Ev();
extern void _ZN6S106C54v107Ev();
extern void _ZN6S106C54v108Ev();
extern void _ZN6S106C54v109Ev();
extern void _ZN6S106C54v110Ev();
extern void _ZN6S106C54v111Ev();
extern void _ZN6S106C54v112Ev();
extern void _ZN6S106C54v113Ev();
extern void _ZN6S106C54v114Ev();
extern void _ZN6S106C54v115Ev();
extern void _ZN6S106C54v116Ev();
extern void _ZN6S106C54v117Ev();
extern void _ZN6S106C54v118Ev();
extern void _ZN6S106C54v119Ev();
extern void _ZN6S106C54v120Ev();
extern void _ZN6S106C54v121Ev();
extern void _ZN6S106C54v122Ev();
extern void _ZN6S106C54v123Ev();
extern void _ZN6S106C54v124Ev();
extern void _ZN6S106C54v125Ev();
extern void _ZN6S106C54v126Ev();
extern void _ZN6S106C54v127Ev();
extern void _ZN6S106C54v128Ev();
extern void _ZN6S106C54v129Ev();
extern void _ZN6S106C54v130Ev();
extern void _ZN6S106C54v131Ev();
extern void _ZN6S106C54v132Ev();
extern void _ZN6S106C54v133Ev();
extern void _ZN6S106C54v134Ev();
extern void _ZN6S106C54v135Ev();
extern void _ZN6S106C54v136Ev();
extern void _ZN6S106C54v137Ev();
extern void _ZN6S106C54v138Ev();
extern void _ZN6S106C54v139Ev();
extern void _ZN6S106C54v140Ev();
extern void _ZN6S106C54v141Ev();
extern void _ZN6S106C54v142Ev();
extern void _ZN6S106C54v143Ev();
extern void _ZN6S106C54v144Ev();
extern void _ZN6S106C54v145Ev();
extern void _ZN6S106C54v146Ev();
extern void _ZN6S106C54v147Ev();
extern void _ZN6S106C44v148Ev();
extern void _ZN6S106C44v149Ev();
extern void _ZN6S106C44v150Ev();
extern void _ZN6S106C44v151Ev();
extern void _ZN6S106C44v152Ev();
extern void _ZN6S106C44v153Ev();
extern void _ZN6S106C44v154Ev();
extern void _ZN6S106C44v155Ev();
extern void _ZN6S106C44v156Ev();
extern void _ZN6S106C44v157Ev();
extern void _ZN6S106C44v158Ev();
extern void _ZN6S106C44v159Ev();
extern void _ZN6S106C44v160Ev();
extern void _ZN6S106C44v161Ev();
extern void _ZN6S106C44v162Ev();
extern void _ZN6S106C44v163Ev();
extern void _ZN6S106C44v164Ev();
extern void _ZN6S106C44v165Ev();
extern void _ZN6S106C44v166Ev();
extern void _ZN6S106C44v167Ev();
extern void _ZN6S106C44v168Ev();
extern void _ZN6S106C44v169Ev();
extern void _ZN6S106C44v170Ev();
extern void _ZN6S106C44v171Ev();
extern void _ZN6S106C44v172Ev();
extern void _ZN6S106C44v173Ev();
extern void _ZN6S106C44v174Ev();
extern void _ZN6S106C44v175Ev();
extern void _ZN6S106C44v176Ev();
extern void _ZN6S106C44v177Ev();
extern void _ZN6S106C44v178Ev();
extern void _ZN6S106C44v179Ev();
extern void _ZN6S106C44v180Ev();
extern void _ZN6S106C44v181Ev();
extern void _ZN6S106C44v182Ev();
extern void _ZN6S106C44v183Ev();
extern void _ZN6S106C44v184Ev();
extern void _ZN6S106C44v185Ev();
extern void _ZN6S106C44v186Ev();
extern void _ZN6S106C34v187Ev();
extern void _ZN6S106C34v188Ev();
extern void _ZN6S106C34v189Ev();
extern void _ZN6S106C34v190Ev();
extern void _ZN6S106C34v191Ev();
extern void _ZN6S106C34v192Ev();
extern void _ZN6S106C34v193Ev();
extern void _ZN6S106C34v194Ev();
extern void _ZN6S106C34v195Ev();
extern void _ZN6S106C34v196Ev();
extern void _ZN6S106C34v197Ev();
extern void _ZN6S106C34v198Ev();
extern void _ZN6S106C34v199Ev();
extern void _ZN6S106C34v200Ev();
extern void _ZN6S106C34v201Ev();
extern void _ZN6S106C34v202Ev();
extern void _ZN6S106C34v203Ev();
extern void _ZN6S106C34v204Ev();
extern void _ZN6S106C34v205Ev();
extern void _ZN6S106C34v206Ev();
extern void _ZN6S106C34v207Ev();
extern void _ZN6S106C34v208Ev();
extern void _ZN6S106C34v209Ev();
extern void _ZN6S106C24v210Ev();
extern void _ZN6S106C24v211Ev();
extern void _ZN6S106C24v212Ev();
extern void _ZN6S106C24v213Ev();
extern void _ZN6S106C24v214Ev();
extern void _ZN6S106C24v215Ev();
extern void _ZN6S106C24v216Ev();
extern void _ZN6S106C24v217Ev();
extern void _ZN6S106C12v1Ev();
extern void _ZN6S106C12v2Ev();
extern void _ZN6S106C12v3Ev();
extern void _ZN6S106C12v4Ev();
extern void _ZN6S106C12v5Ev();
static  VTBL_ENTRY vtc_S106C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S106C1[0]),
  (VTBL_ENTRY)&_ZN6S106C1D1Ev,
  (VTBL_ENTRY)&_ZN6S106C1D0Ev,
  (VTBL_ENTRY)&_ZN6S106C72v6Ev,
  (VTBL_ENTRY)&_ZN6S106C72v7Ev,
  (VTBL_ENTRY)&_ZN6S106C72v8Ev,
  (VTBL_ENTRY)&_ZN6S106C72v9Ev,
  (VTBL_ENTRY)&_ZN6S106C73v10Ev,
  (VTBL_ENTRY)&_ZN6S106C73v11Ev,
  (VTBL_ENTRY)&_ZN6S106C73v12Ev,
  (VTBL_ENTRY)&_ZN6S106C73v13Ev,
  (VTBL_ENTRY)&_ZN6S106C73v14Ev,
  (VTBL_ENTRY)&_ZN6S106C73v15Ev,
  (VTBL_ENTRY)&_ZN6S106C73v16Ev,
  (VTBL_ENTRY)&_ZN6S106C73v17Ev,
  (VTBL_ENTRY)&_ZN6S106C73v18Ev,
  (VTBL_ENTRY)&_ZN6S106C73v19Ev,
  (VTBL_ENTRY)&_ZN6S106C73v20Ev,
  (VTBL_ENTRY)&_ZN6S106C73v21Ev,
  (VTBL_ENTRY)&_ZN6S106C73v22Ev,
  (VTBL_ENTRY)&_ZN6S106C73v23Ev,
  (VTBL_ENTRY)&_ZN6S106C73v24Ev,
  (VTBL_ENTRY)&_ZN6S106C73v25Ev,
  (VTBL_ENTRY)&_ZN6S106C73v26Ev,
  (VTBL_ENTRY)&_ZN6S106C73v27Ev,
  (VTBL_ENTRY)&_ZN6S106C73v28Ev,
  (VTBL_ENTRY)&_ZN6S106C73v29Ev,
  (VTBL_ENTRY)&_ZN6S106C73v30Ev,
  (VTBL_ENTRY)&_ZN6S106C73v31Ev,
  (VTBL_ENTRY)&_ZN6S106C73v32Ev,
  (VTBL_ENTRY)&_ZN6S106C73v33Ev,
  (VTBL_ENTRY)&_ZN6S106C73v34Ev,
  (VTBL_ENTRY)&_ZN6S106C73v35Ev,
  (VTBL_ENTRY)&_ZN6S106C73v36Ev,
  (VTBL_ENTRY)&_ZN6S106C73v37Ev,
  (VTBL_ENTRY)&_ZN6S106C73v38Ev,
  (VTBL_ENTRY)&_ZN6S106C73v39Ev,
  (VTBL_ENTRY)&_ZN6S106C73v40Ev,
  (VTBL_ENTRY)&_ZN6S106C73v41Ev,
  (VTBL_ENTRY)&_ZN6S106C73v42Ev,
  (VTBL_ENTRY)&_ZN6S106C73v43Ev,
  (VTBL_ENTRY)&_ZN6S106C73v44Ev,
  (VTBL_ENTRY)&_ZN6S106C73v45Ev,
  (VTBL_ENTRY)&_ZN6S106C73v46Ev,
  (VTBL_ENTRY)&_ZN6S106C73v47Ev,
  (VTBL_ENTRY)&_ZN6S106C73v48Ev,
  (VTBL_ENTRY)&_ZN6S106C73v49Ev,
  (VTBL_ENTRY)&_ZN6S106C73v50Ev,
  (VTBL_ENTRY)&_ZN6S106C73v51Ev,
  (VTBL_ENTRY)&_ZN6S106C73v52Ev,
  (VTBL_ENTRY)&_ZN6S106C73v53Ev,
  (VTBL_ENTRY)&_ZN6S106C73v54Ev,
  (VTBL_ENTRY)&_ZN6S106C73v55Ev,
  (VTBL_ENTRY)&_ZN6S106C73v56Ev,
  (VTBL_ENTRY)&_ZN6S106C73v57Ev,
  (VTBL_ENTRY)&_ZN6S106C73v58Ev,
  (VTBL_ENTRY)&_ZN6S106C73v59Ev,
  (VTBL_ENTRY)&_ZN6S106C73v60Ev,
  (VTBL_ENTRY)&_ZN6S106C73v61Ev,
  (VTBL_ENTRY)&_ZN6S106C73v62Ev,
  (VTBL_ENTRY)&_ZN6S106C73v63Ev,
  (VTBL_ENTRY)&_ZN6S106C73v64Ev,
  (VTBL_ENTRY)&_ZN6S106C73v65Ev,
  (VTBL_ENTRY)&_ZN6S106C73v66Ev,
  (VTBL_ENTRY)&_ZN6S106C73v67Ev,
  (VTBL_ENTRY)&_ZN6S106C73v68Ev,
  (VTBL_ENTRY)&_ZN6S106C73v69Ev,
  (VTBL_ENTRY)&_ZN6S106C63v70Ev,
  (VTBL_ENTRY)&_ZN6S106C63v71Ev,
  (VTBL_ENTRY)&_ZN6S106C53v72Ev,
  (VTBL_ENTRY)&_ZN6S106C53v73Ev,
  (VTBL_ENTRY)&_ZN6S106C53v74Ev,
  (VTBL_ENTRY)&_ZN6S106C53v75Ev,
  (VTBL_ENTRY)&_ZN6S106C53v76Ev,
  (VTBL_ENTRY)&_ZN6S106C53v77Ev,
  (VTBL_ENTRY)&_ZN6S106C53v78Ev,
  (VTBL_ENTRY)&_ZN6S106C53v79Ev,
  (VTBL_ENTRY)&_ZN6S106C53v80Ev,
  (VTBL_ENTRY)&_ZN6S106C53v81Ev,
  (VTBL_ENTRY)&_ZN6S106C53v82Ev,
  (VTBL_ENTRY)&_ZN6S106C53v83Ev,
  (VTBL_ENTRY)&_ZN6S106C53v84Ev,
  (VTBL_ENTRY)&_ZN6S106C53v85Ev,
  (VTBL_ENTRY)&_ZN6S106C53v86Ev,
  (VTBL_ENTRY)&_ZN6S106C53v87Ev,
  (VTBL_ENTRY)&_ZN6S106C53v88Ev,
  (VTBL_ENTRY)&_ZN6S106C53v89Ev,
  (VTBL_ENTRY)&_ZN6S106C53v90Ev,
  (VTBL_ENTRY)&_ZN6S106C53v91Ev,
  (VTBL_ENTRY)&_ZN6S106C53v92Ev,
  (VTBL_ENTRY)&_ZN6S106C53v93Ev,
  (VTBL_ENTRY)&_ZN6S106C53v94Ev,
  (VTBL_ENTRY)&_ZN6S106C53v95Ev,
  (VTBL_ENTRY)&_ZN6S106C53v96Ev,
  (VTBL_ENTRY)&_ZN6S106C53v97Ev,
  (VTBL_ENTRY)&_ZN6S106C53v98Ev,
  (VTBL_ENTRY)&_ZN6S106C53v99Ev,
  (VTBL_ENTRY)&_ZN6S106C54v100Ev,
  (VTBL_ENTRY)&_ZN6S106C54v101Ev,
  (VTBL_ENTRY)&_ZN6S106C54v102Ev,
  (VTBL_ENTRY)&_ZN6S106C54v103Ev,
  (VTBL_ENTRY)&_ZN6S106C54v104Ev,
  (VTBL_ENTRY)&_ZN6S106C54v105Ev,
  (VTBL_ENTRY)&_ZN6S106C54v106Ev,
  (VTBL_ENTRY)&_ZN6S106C54v107Ev,
  (VTBL_ENTRY)&_ZN6S106C54v108Ev,
  (VTBL_ENTRY)&_ZN6S106C54v109Ev,
  (VTBL_ENTRY)&_ZN6S106C54v110Ev,
  (VTBL_ENTRY)&_ZN6S106C54v111Ev,
  (VTBL_ENTRY)&_ZN6S106C54v112Ev,
  (VTBL_ENTRY)&_ZN6S106C54v113Ev,
  (VTBL_ENTRY)&_ZN6S106C54v114Ev,
  (VTBL_ENTRY)&_ZN6S106C54v115Ev,
  (VTBL_ENTRY)&_ZN6S106C54v116Ev,
  (VTBL_ENTRY)&_ZN6S106C54v117Ev,
  (VTBL_ENTRY)&_ZN6S106C54v118Ev,
  (VTBL_ENTRY)&_ZN6S106C54v119Ev,
  (VTBL_ENTRY)&_ZN6S106C54v120Ev,
  (VTBL_ENTRY)&_ZN6S106C54v121Ev,
  (VTBL_ENTRY)&_ZN6S106C54v122Ev,
  (VTBL_ENTRY)&_ZN6S106C54v123Ev,
  (VTBL_ENTRY)&_ZN6S106C54v124Ev,
  (VTBL_ENTRY)&_ZN6S106C54v125Ev,
  (VTBL_ENTRY)&_ZN6S106C54v126Ev,
  (VTBL_ENTRY)&_ZN6S106C54v127Ev,
  (VTBL_ENTRY)&_ZN6S106C54v128Ev,
  (VTBL_ENTRY)&_ZN6S106C54v129Ev,
  (VTBL_ENTRY)&_ZN6S106C54v130Ev,
  (VTBL_ENTRY)&_ZN6S106C54v131Ev,
  (VTBL_ENTRY)&_ZN6S106C54v132Ev,
  (VTBL_ENTRY)&_ZN6S106C54v133Ev,
  (VTBL_ENTRY)&_ZN6S106C54v134Ev,
  (VTBL_ENTRY)&_ZN6S106C54v135Ev,
  (VTBL_ENTRY)&_ZN6S106C54v136Ev,
  (VTBL_ENTRY)&_ZN6S106C54v137Ev,
  (VTBL_ENTRY)&_ZN6S106C54v138Ev,
  (VTBL_ENTRY)&_ZN6S106C54v139Ev,
  (VTBL_ENTRY)&_ZN6S106C54v140Ev,
  (VTBL_ENTRY)&_ZN6S106C54v141Ev,
  (VTBL_ENTRY)&_ZN6S106C54v142Ev,
  (VTBL_ENTRY)&_ZN6S106C54v143Ev,
  (VTBL_ENTRY)&_ZN6S106C54v144Ev,
  (VTBL_ENTRY)&_ZN6S106C54v145Ev,
  (VTBL_ENTRY)&_ZN6S106C54v146Ev,
  (VTBL_ENTRY)&_ZN6S106C54v147Ev,
  (VTBL_ENTRY)&_ZN6S106C44v148Ev,
  (VTBL_ENTRY)&_ZN6S106C44v149Ev,
  (VTBL_ENTRY)&_ZN6S106C44v150Ev,
  (VTBL_ENTRY)&_ZN6S106C44v151Ev,
  (VTBL_ENTRY)&_ZN6S106C44v152Ev,
  (VTBL_ENTRY)&_ZN6S106C44v153Ev,
  (VTBL_ENTRY)&_ZN6S106C44v154Ev,
  (VTBL_ENTRY)&_ZN6S106C44v155Ev,
  (VTBL_ENTRY)&_ZN6S106C44v156Ev,
  (VTBL_ENTRY)&_ZN6S106C44v157Ev,
  (VTBL_ENTRY)&_ZN6S106C44v158Ev,
  (VTBL_ENTRY)&_ZN6S106C44v159Ev,
  (VTBL_ENTRY)&_ZN6S106C44v160Ev,
  (VTBL_ENTRY)&_ZN6S106C44v161Ev,
  (VTBL_ENTRY)&_ZN6S106C44v162Ev,
  (VTBL_ENTRY)&_ZN6S106C44v163Ev,
  (VTBL_ENTRY)&_ZN6S106C44v164Ev,
  (VTBL_ENTRY)&_ZN6S106C44v165Ev,
  (VTBL_ENTRY)&_ZN6S106C44v166Ev,
  (VTBL_ENTRY)&_ZN6S106C44v167Ev,
  (VTBL_ENTRY)&_ZN6S106C44v168Ev,
  (VTBL_ENTRY)&_ZN6S106C44v169Ev,
  (VTBL_ENTRY)&_ZN6S106C44v170Ev,
  (VTBL_ENTRY)&_ZN6S106C44v171Ev,
  (VTBL_ENTRY)&_ZN6S106C44v172Ev,
  (VTBL_ENTRY)&_ZN6S106C44v173Ev,
  (VTBL_ENTRY)&_ZN6S106C44v174Ev,
  (VTBL_ENTRY)&_ZN6S106C44v175Ev,
  (VTBL_ENTRY)&_ZN6S106C44v176Ev,
  (VTBL_ENTRY)&_ZN6S106C44v177Ev,
  (VTBL_ENTRY)&_ZN6S106C44v178Ev,
  (VTBL_ENTRY)&_ZN6S106C44v179Ev,
  (VTBL_ENTRY)&_ZN6S106C44v180Ev,
  (VTBL_ENTRY)&_ZN6S106C44v181Ev,
  (VTBL_ENTRY)&_ZN6S106C44v182Ev,
  (VTBL_ENTRY)&_ZN6S106C44v183Ev,
  (VTBL_ENTRY)&_ZN6S106C44v184Ev,
  (VTBL_ENTRY)&_ZN6S106C44v185Ev,
  (VTBL_ENTRY)&_ZN6S106C44v186Ev,
  (VTBL_ENTRY)&_ZN6S106C34v187Ev,
  (VTBL_ENTRY)&_ZN6S106C34v188Ev,
  (VTBL_ENTRY)&_ZN6S106C34v189Ev,
  (VTBL_ENTRY)&_ZN6S106C34v190Ev,
  (VTBL_ENTRY)&_ZN6S106C34v191Ev,
  (VTBL_ENTRY)&_ZN6S106C34v192Ev,
  (VTBL_ENTRY)&_ZN6S106C34v193Ev,
  (VTBL_ENTRY)&_ZN6S106C34v194Ev,
  (VTBL_ENTRY)&_ZN6S106C34v195Ev,
  (VTBL_ENTRY)&_ZN6S106C34v196Ev,
  (VTBL_ENTRY)&_ZN6S106C34v197Ev,
  (VTBL_ENTRY)&_ZN6S106C34v198Ev,
  (VTBL_ENTRY)&_ZN6S106C34v199Ev,
  (VTBL_ENTRY)&_ZN6S106C34v200Ev,
  (VTBL_ENTRY)&_ZN6S106C34v201Ev,
  (VTBL_ENTRY)&_ZN6S106C34v202Ev,
  (VTBL_ENTRY)&_ZN6S106C34v203Ev,
  (VTBL_ENTRY)&_ZN6S106C34v204Ev,
  (VTBL_ENTRY)&_ZN6S106C34v205Ev,
  (VTBL_ENTRY)&_ZN6S106C34v206Ev,
  (VTBL_ENTRY)&_ZN6S106C34v207Ev,
  (VTBL_ENTRY)&_ZN6S106C34v208Ev,
  (VTBL_ENTRY)&_ZN6S106C34v209Ev,
  (VTBL_ENTRY)&_ZN6S106C24v210Ev,
  (VTBL_ENTRY)&_ZN6S106C24v211Ev,
  (VTBL_ENTRY)&_ZN6S106C24v212Ev,
  (VTBL_ENTRY)&_ZN6S106C24v213Ev,
  (VTBL_ENTRY)&_ZN6S106C24v214Ev,
  (VTBL_ENTRY)&_ZN6S106C24v215Ev,
  (VTBL_ENTRY)&_ZN6S106C24v216Ev,
  (VTBL_ENTRY)&_ZN6S106C24v217Ev,
  (VTBL_ENTRY)&_ZN6S106C12v1Ev,
  (VTBL_ENTRY)&_ZN6S106C12v2Ev,
  (VTBL_ENTRY)&_ZN6S106C12v3Ev,
  (VTBL_ENTRY)&_ZN6S106C12v4Ev,
  (VTBL_ENTRY)&_ZN6S106C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S106C1[];
extern  VTBL_ENTRY _ZTV6S106C1[];
Class_Descriptor cd_S106C1 = {  "S106C1", // class name
  bases_S106C1, 6,
  &(vtc_S106C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1128,784), // object size
  NSPAIRA(_ZTI6S106C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S106C1),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C7  {
  int s101c7f0;
  __tsi64 s101c7f1;
  void *s101c7f2[4];
  int s101c7f3[2];
  void *s101c7f4;
  ::S85C27_nt s101c7f5;
  void *s101c7f6[2];
  virtual  ~S101C7(); // _ZN6S101C7D1Ev
  virtual void  v5(); // _ZN6S101C72v5Ev
  virtual void  v6(); // _ZN6S101C72v6Ev
  virtual void  v7(); // _ZN6S101C72v7Ev
  virtual void  v8(); // _ZN6S101C72v8Ev
  virtual void  v9(); // _ZN6S101C72v9Ev
  virtual void  v10(); // _ZN6S101C73v10Ev
  virtual void  v11(); // _ZN6S101C73v11Ev
  virtual void  v12(); // _ZN6S101C73v12Ev
  virtual void  v13(); // _ZN6S101C73v13Ev
  virtual void  v14(); // _ZN6S101C73v14Ev
  virtual void  v15(); // _ZN6S101C73v15Ev
  virtual void  v16(); // _ZN6S101C73v16Ev
  virtual void  v17(); // _ZN6S101C73v17Ev
  virtual void  v18(); // _ZN6S101C73v18Ev
  virtual void  v19(); // _ZN6S101C73v19Ev
  virtual void  v20(); // _ZN6S101C73v20Ev
  virtual void  v21(); // _ZN6S101C73v21Ev
  virtual void  v22(); // _ZN6S101C73v22Ev
  virtual void  v23(); // _ZN6S101C73v23Ev
  virtual void  v24(); // _ZN6S101C73v24Ev
  virtual void  v25(); // _ZN6S101C73v25Ev
  virtual void  v26(); // _ZN6S101C73v26Ev
  virtual void  v27(); // _ZN6S101C73v27Ev
  virtual void  v28(); // _ZN6S101C73v28Ev
  virtual void  v29(); // _ZN6S101C73v29Ev
  virtual void  v30(); // _ZN6S101C73v30Ev
  virtual void  v31(); // _ZN6S101C73v31Ev
  virtual void  v32(); // _ZN6S101C73v32Ev
  virtual void  v33(); // _ZN6S101C73v33Ev
  virtual void  v34(); // _ZN6S101C73v34Ev
  virtual void  v35(); // _ZN6S101C73v35Ev
  virtual void  v36(); // _ZN6S101C73v36Ev
  virtual void  v37(); // _ZN6S101C73v37Ev
  virtual void  v38(); // _ZN6S101C73v38Ev
  virtual void  v39(); // _ZN6S101C73v39Ev
  virtual void  v40(); // _ZN6S101C73v40Ev
  virtual void  v41(); // _ZN6S101C73v41Ev
  virtual void  v42(); // _ZN6S101C73v42Ev
  virtual void  v43(); // _ZN6S101C73v43Ev
  virtual void  v44(); // _ZN6S101C73v44Ev
  virtual void  v45(); // _ZN6S101C73v45Ev
  virtual void  v46(); // _ZN6S101C73v46Ev
  virtual void  v47(); // _ZN6S101C73v47Ev
  virtual void  v48(); // _ZN6S101C73v48Ev
  virtual void  v49(); // _ZN6S101C73v49Ev
  virtual void  v50(); // _ZN6S101C73v50Ev
  virtual void  v51(); // _ZN6S101C73v51Ev
  virtual void  v52(); // _ZN6S101C73v52Ev
  virtual void  v53(); // _ZN6S101C73v53Ev
  virtual void  v54(); // _ZN6S101C73v54Ev
  virtual void  v55(); // _ZN6S101C73v55Ev
  virtual void  v56(); // _ZN6S101C73v56Ev
  virtual void  v57(); // _ZN6S101C73v57Ev
  virtual void  v58(); // _ZN6S101C73v58Ev
  virtual void  v59(); // _ZN6S101C73v59Ev
  virtual void  v60(); // _ZN6S101C73v60Ev
  virtual void  v61(); // _ZN6S101C73v61Ev
  virtual void  v62(); // _ZN6S101C73v62Ev
  virtual void  v63(); // _ZN6S101C73v63Ev
  virtual void  v64(); // _ZN6S101C73v64Ev
  virtual void  v65(); // _ZN6S101C73v65Ev
  virtual void  v66(); // _ZN6S101C73v66Ev
  virtual void  v67(); // _ZN6S101C73v67Ev
  virtual void  v68(); // _ZN6S101C73v68Ev
  S101C7(); // tgen
};
//SIG(-1 S101C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S101C7 ::~S101C7(){ note_dtor("S101C7", this);}
void  S101C7 ::v5(){vfunc_called(this, "_ZN6S101C72v5Ev");}
void  S101C7 ::v6(){vfunc_called(this, "_ZN6S101C72v6Ev");}
void  S101C7 ::v7(){vfunc_called(this, "_ZN6S101C72v7Ev");}
void  S101C7 ::v8(){vfunc_called(this, "_ZN6S101C72v8Ev");}
void  S101C7 ::v9(){vfunc_called(this, "_ZN6S101C72v9Ev");}
void  S101C7 ::v10(){vfunc_called(this, "_ZN6S101C73v10Ev");}
void  S101C7 ::v11(){vfunc_called(this, "_ZN6S101C73v11Ev");}
void  S101C7 ::v12(){vfunc_called(this, "_ZN6S101C73v12Ev");}
void  S101C7 ::v13(){vfunc_called(this, "_ZN6S101C73v13Ev");}
void  S101C7 ::v14(){vfunc_called(this, "_ZN6S101C73v14Ev");}
void  S101C7 ::v15(){vfunc_called(this, "_ZN6S101C73v15Ev");}
void  S101C7 ::v16(){vfunc_called(this, "_ZN6S101C73v16Ev");}
void  S101C7 ::v17(){vfunc_called(this, "_ZN6S101C73v17Ev");}
void  S101C7 ::v18(){vfunc_called(this, "_ZN6S101C73v18Ev");}
void  S101C7 ::v19(){vfunc_called(this, "_ZN6S101C73v19Ev");}
void  S101C7 ::v20(){vfunc_called(this, "_ZN6S101C73v20Ev");}
void  S101C7 ::v21(){vfunc_called(this, "_ZN6S101C73v21Ev");}
void  S101C7 ::v22(){vfunc_called(this, "_ZN6S101C73v22Ev");}
void  S101C7 ::v23(){vfunc_called(this, "_ZN6S101C73v23Ev");}
void  S101C7 ::v24(){vfunc_called(this, "_ZN6S101C73v24Ev");}
void  S101C7 ::v25(){vfunc_called(this, "_ZN6S101C73v25Ev");}
void  S101C7 ::v26(){vfunc_called(this, "_ZN6S101C73v26Ev");}
void  S101C7 ::v27(){vfunc_called(this, "_ZN6S101C73v27Ev");}
void  S101C7 ::v28(){vfunc_called(this, "_ZN6S101C73v28Ev");}
void  S101C7 ::v29(){vfunc_called(this, "_ZN6S101C73v29Ev");}
void  S101C7 ::v30(){vfunc_called(this, "_ZN6S101C73v30Ev");}
void  S101C7 ::v31(){vfunc_called(this, "_ZN6S101C73v31Ev");}
void  S101C7 ::v32(){vfunc_called(this, "_ZN6S101C73v32Ev");}
void  S101C7 ::v33(){vfunc_called(this, "_ZN6S101C73v33Ev");}
void  S101C7 ::v34(){vfunc_called(this, "_ZN6S101C73v34Ev");}
void  S101C7 ::v35(){vfunc_called(this, "_ZN6S101C73v35Ev");}
void  S101C7 ::v36(){vfunc_called(this, "_ZN6S101C73v36Ev");}
void  S101C7 ::v37(){vfunc_called(this, "_ZN6S101C73v37Ev");}
void  S101C7 ::v38(){vfunc_called(this, "_ZN6S101C73v38Ev");}
void  S101C7 ::v39(){vfunc_called(this, "_ZN6S101C73v39Ev");}
void  S101C7 ::v40(){vfunc_called(this, "_ZN6S101C73v40Ev");}
void  S101C7 ::v41(){vfunc_called(this, "_ZN6S101C73v41Ev");}
void  S101C7 ::v42(){vfunc_called(this, "_ZN6S101C73v42Ev");}
void  S101C7 ::v43(){vfunc_called(this, "_ZN6S101C73v43Ev");}
void  S101C7 ::v44(){vfunc_called(this, "_ZN6S101C73v44Ev");}
void  S101C7 ::v45(){vfunc_called(this, "_ZN6S101C73v45Ev");}
void  S101C7 ::v46(){vfunc_called(this, "_ZN6S101C73v46Ev");}
void  S101C7 ::v47(){vfunc_called(this, "_ZN6S101C73v47Ev");}
void  S101C7 ::v48(){vfunc_called(this, "_ZN6S101C73v48Ev");}
void  S101C7 ::v49(){vfunc_called(this, "_ZN6S101C73v49Ev");}
void  S101C7 ::v50(){vfunc_called(this, "_ZN6S101C73v50Ev");}
void  S101C7 ::v51(){vfunc_called(this, "_ZN6S101C73v51Ev");}
void  S101C7 ::v52(){vfunc_called(this, "_ZN6S101C73v52Ev");}
void  S101C7 ::v53(){vfunc_called(this, "_ZN6S101C73v53Ev");}
void  S101C7 ::v54(){vfunc_called(this, "_ZN6S101C73v54Ev");}
void  S101C7 ::v55(){vfunc_called(this, "_ZN6S101C73v55Ev");}
void  S101C7 ::v56(){vfunc_called(this, "_ZN6S101C73v56Ev");}
void  S101C7 ::v57(){vfunc_called(this, "_ZN6S101C73v57Ev");}
void  S101C7 ::v58(){vfunc_called(this, "_ZN6S101C73v58Ev");}
void  S101C7 ::v59(){vfunc_called(this, "_ZN6S101C73v59Ev");}
void  S101C7 ::v60(){vfunc_called(this, "_ZN6S101C73v60Ev");}
void  S101C7 ::v61(){vfunc_called(this, "_ZN6S101C73v61Ev");}
void  S101C7 ::v62(){vfunc_called(this, "_ZN6S101C73v62Ev");}
void  S101C7 ::v63(){vfunc_called(this, "_ZN6S101C73v63Ev");}
void  S101C7 ::v64(){vfunc_called(this, "_ZN6S101C73v64Ev");}
void  S101C7 ::v65(){vfunc_called(this, "_ZN6S101C73v65Ev");}
void  S101C7 ::v66(){vfunc_called(this, "_ZN6S101C73v66Ev");}
void  S101C7 ::v67(){vfunc_called(this, "_ZN6S101C73v67Ev");}
void  S101C7 ::v68(){vfunc_called(this, "_ZN6S101C73v68Ev");}
S101C7 ::S101C7(){ note_ctor("S101C7", this);} // tgen

static void Test_S101C7()
{
  extern Class_Descriptor cd_S101C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S101C7, buf);
    S101C7 *dp, &lv = *(dp=new (buf) S101C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S101C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C7)");
    check_field_offset(lv, s101c7f0, ABISELECT(8,4), "S101C7.s101c7f0");
    check_field_offset(lv, s101c7f1, ABISELECT(16,8), "S101C7.s101c7f1");
    check_field_offset(lv, s101c7f2, ABISELECT(24,16), "S101C7.s101c7f2");
    check_field_offset(lv, s101c7f3, ABISELECT(56,32), "S101C7.s101c7f3");
    check_field_offset(lv, s101c7f4, ABISELECT(64,40), "S101C7.s101c7f4");
    check_field_offset(lv, s101c7f5, ABISELECT(72,44), "S101C7.s101c7f5");
    check_field_offset(lv, s101c7f6, ABISELECT(80,52), "S101C7.s101c7f6");
    test_class_info(&lv, &cd_S101C7);
    dp->~S101C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C7(Test_S101C7, "S101C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S101C7C1Ev();
extern void _ZN6S101C7D1Ev();
Name_Map name_map_S101C7[] = {
  NSPAIR(_ZN6S101C7C1Ev),
  NSPAIR(_ZN6S101C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S101C7[];
extern void _ZN6S101C7D1Ev();
extern void _ZN6S101C7D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
static  VTBL_ENTRY vtc_S101C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C7[0]),
  (VTBL_ENTRY)&_ZN6S101C7D1Ev,
  (VTBL_ENTRY)&_ZN6S101C7D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
};
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
Class_Descriptor cd_S101C7 = {  "S101C7", // class name
  0,0,//no base classes
  &(vtc_S101C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S101C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S101C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C6  : S101C7 {
  virtual  ~S101C6(); // _ZN6S101C6D1Ev
  virtual void  v69(); // _ZN6S101C63v69Ev
  virtual void  v70(); // _ZN6S101C63v70Ev
  S101C6(); // tgen
};
//SIG(-1 S101C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S101C6 ::~S101C6(){ note_dtor("S101C6", this);}
void  S101C6 ::v69(){vfunc_called(this, "_ZN6S101C63v69Ev");}
void  S101C6 ::v70(){vfunc_called(this, "_ZN6S101C63v70Ev");}
S101C6 ::S101C6(){ note_ctor("S101C6", this);} // tgen

static void Test_S101C6()
{
  extern Class_Descriptor cd_S101C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S101C6, buf);
    S101C6 *dp, &lv = *(dp=new (buf) S101C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S101C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C6)");
    check_base_class_offset(lv, (S101C7*), 0, "S101C6");
    test_class_info(&lv, &cd_S101C6);
    dp->~S101C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C6(Test_S101C6, "S101C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S101C6C1Ev();
extern void _ZN6S101C6D1Ev();
Name_Map name_map_S101C6[] = {
  NSPAIR(_ZN6S101C6C1Ev),
  NSPAIR(_ZN6S101C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
static Base_Class bases_S101C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C6[];
extern void _ZN6S101C6D1Ev();
extern void _ZN6S101C6D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
static  VTBL_ENTRY vtc_S101C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C6[0]),
  (VTBL_ENTRY)&_ZN6S101C6D1Ev,
  (VTBL_ENTRY)&_ZN6S101C6D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
};
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
Class_Descriptor cd_S101C6 = {  "S101C6", // class name
  bases_S101C6, 1,
  &(vtc_S101C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S101C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C5  : S101C6 {
  ::S80C9_nt s101c5f0;
  int s101c5f1;
  unsigned int s101c5f2:1;
  unsigned int s101c5f3:1;
  unsigned int s101c5f4:1;
  unsigned int s101c5f5:1;
  ::S85C35 s101c5f6;
  ::S85C22_nt s101c5f7;
  void *s101c5f8;
  ::S80C31 s101c5f9;
  ::S80C31 s101c5f10;
  ::S80C29 s101c5f11;
  ::S80C19 s101c5f12;
  char s101c5f13;
  int s101c5f14;
  void *s101c5f15;
  ::S85C27_nt s101c5f16;
  ::S85C27_nt s101c5f17;
  ::S85C27_nt s101c5f18;
  ::S85C27_nt s101c5f19;
  ::S85C27_nt s101c5f20;
  ::S85C27_nt s101c5f21;
  ::S80C21_nt s101c5f22;
  ::S80C21_nt s101c5f23;
  ::S80C21_nt s101c5f24;
  ::S80C21_nt s101c5f25;
  ::S80C21_nt s101c5f26;
  ::S80C21_nt s101c5f27;
  ::S80C21_nt s101c5f28;
  ::S80C21_nt s101c5f29;
  ::S80C21_nt s101c5f30;
  ::S80C21_nt s101c5f31;
  virtual  ~S101C5(); // _ZN6S101C5D1Ev
  virtual void  v71(); // _ZN6S101C53v71Ev
  virtual void  v72(); // _ZN6S101C53v72Ev
  virtual void  v73(); // _ZN6S101C53v73Ev
  virtual void  v74(); // _ZN6S101C53v74Ev
  virtual void  v75(); // _ZN6S101C53v75Ev
  virtual void  v76(); // _ZN6S101C53v76Ev
  virtual void  v77(); // _ZN6S101C53v77Ev
  virtual void  v78(); // _ZN6S101C53v78Ev
  virtual void  v79(); // _ZN6S101C53v79Ev
  virtual void  v80(); // _ZN6S101C53v80Ev
  virtual void  v81(); // _ZN6S101C53v81Ev
  virtual void  v82(); // _ZN6S101C53v82Ev
  virtual void  v83(); // _ZN6S101C53v83Ev
  virtual void  v84(); // _ZN6S101C53v84Ev
  virtual void  v85(); // _ZN6S101C53v85Ev
  virtual void  v86(); // _ZN6S101C53v86Ev
  virtual void  v87(); // _ZN6S101C53v87Ev
  virtual void  v88(); // _ZN6S101C53v88Ev
  virtual void  v89(); // _ZN6S101C53v89Ev
  virtual void  v90(); // _ZN6S101C53v90Ev
  virtual void  v91(); // _ZN6S101C53v91Ev
  virtual void  v92(); // _ZN6S101C53v92Ev
  virtual void  v93(); // _ZN6S101C53v93Ev
  virtual void  v94(); // _ZN6S101C53v94Ev
  virtual void  v95(); // _ZN6S101C53v95Ev
  virtual void  v96(); // _ZN6S101C53v96Ev
  virtual void  v97(); // _ZN6S101C53v97Ev
  virtual void  v98(); // _ZN6S101C53v98Ev
  virtual void  v99(); // _ZN6S101C53v99Ev
  virtual void  v100(); // _ZN6S101C54v100Ev
  virtual void  v101(); // _ZN6S101C54v101Ev
  virtual void  v102(); // _ZN6S101C54v102Ev
  virtual void  v103(); // _ZN6S101C54v103Ev
  virtual void  v104(); // _ZN6S101C54v104Ev
  virtual void  v105(); // _ZN6S101C54v105Ev
  virtual void  v106(); // _ZN6S101C54v106Ev
  virtual void  v107(); // _ZN6S101C54v107Ev
  virtual void  v108(); // _ZN6S101C54v108Ev
  virtual void  v109(); // _ZN6S101C54v109Ev
  virtual void  v110(); // _ZN6S101C54v110Ev
  virtual void  v111(); // _ZN6S101C54v111Ev
  virtual void  v112(); // _ZN6S101C54v112Ev
  virtual void  v113(); // _ZN6S101C54v113Ev
  virtual void  v114(); // _ZN6S101C54v114Ev
  virtual void  v115(); // _ZN6S101C54v115Ev
  virtual void  v116(); // _ZN6S101C54v116Ev
  virtual void  v117(); // _ZN6S101C54v117Ev
  virtual void  v118(); // _ZN6S101C54v118Ev
  virtual void  v119(); // _ZN6S101C54v119Ev
  virtual void  v120(); // _ZN6S101C54v120Ev
  virtual void  v121(); // _ZN6S101C54v121Ev
  virtual void  v122(); // _ZN6S101C54v122Ev
  virtual void  v123(); // _ZN6S101C54v123Ev
  virtual void  v124(); // _ZN6S101C54v124Ev
  virtual void  v125(); // _ZN6S101C54v125Ev
  virtual void  v126(); // _ZN6S101C54v126Ev
  virtual void  v127(); // _ZN6S101C54v127Ev
  virtual void  v128(); // _ZN6S101C54v128Ev
  virtual void  v129(); // _ZN6S101C54v129Ev
  virtual void  v130(); // _ZN6S101C54v130Ev
  virtual void  v131(); // _ZN6S101C54v131Ev
  virtual void  v132(); // _ZN6S101C54v132Ev
  virtual void  v133(); // _ZN6S101C54v133Ev
  virtual void  v134(); // _ZN6S101C54v134Ev
  virtual void  v135(); // _ZN6S101C54v135Ev
  virtual void  v136(); // _ZN6S101C54v136Ev
  virtual void  v137(); // _ZN6S101C54v137Ev
  virtual void  v138(); // _ZN6S101C54v138Ev
  virtual void  v139(); // _ZN6S101C54v139Ev
  virtual void  v140(); // _ZN6S101C54v140Ev
  virtual void  v141(); // _ZN6S101C54v141Ev
  virtual void  v142(); // _ZN6S101C54v142Ev
  virtual void  v143(); // _ZN6S101C54v143Ev
  virtual void  v144(); // _ZN6S101C54v144Ev
  virtual void  v145(); // _ZN6S101C54v145Ev
  virtual void  v146(); // _ZN6S101C54v146Ev
  S101C5(); // tgen
};
//SIG(-1 S101C5) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC18{ m Fi[2]}} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S101C5 ::~S101C5(){ note_dtor("S101C5", this);}
void  S101C5 ::v71(){vfunc_called(this, "_ZN6S101C53v71Ev");}
void  S101C5 ::v72(){vfunc_called(this, "_ZN6S101C53v72Ev");}
void  S101C5 ::v73(){vfunc_called(this, "_ZN6S101C53v73Ev");}
void  S101C5 ::v74(){vfunc_called(this, "_ZN6S101C53v74Ev");}
void  S101C5 ::v75(){vfunc_called(this, "_ZN6S101C53v75Ev");}
void  S101C5 ::v76(){vfunc_called(this, "_ZN6S101C53v76Ev");}
void  S101C5 ::v77(){vfunc_called(this, "_ZN6S101C53v77Ev");}
void  S101C5 ::v78(){vfunc_called(this, "_ZN6S101C53v78Ev");}
void  S101C5 ::v79(){vfunc_called(this, "_ZN6S101C53v79Ev");}
void  S101C5 ::v80(){vfunc_called(this, "_ZN6S101C53v80Ev");}
void  S101C5 ::v81(){vfunc_called(this, "_ZN6S101C53v81Ev");}
void  S101C5 ::v82(){vfunc_called(this, "_ZN6S101C53v82Ev");}
void  S101C5 ::v83(){vfunc_called(this, "_ZN6S101C53v83Ev");}
void  S101C5 ::v84(){vfunc_called(this, "_ZN6S101C53v84Ev");}
void  S101C5 ::v85(){vfunc_called(this, "_ZN6S101C53v85Ev");}
void  S101C5 ::v86(){vfunc_called(this, "_ZN6S101C53v86Ev");}
void  S101C5 ::v87(){vfunc_called(this, "_ZN6S101C53v87Ev");}
void  S101C5 ::v88(){vfunc_called(this, "_ZN6S101C53v88Ev");}
void  S101C5 ::v89(){vfunc_called(this, "_ZN6S101C53v89Ev");}
void  S101C5 ::v90(){vfunc_called(this, "_ZN6S101C53v90Ev");}
void  S101C5 ::v91(){vfunc_called(this, "_ZN6S101C53v91Ev");}
void  S101C5 ::v92(){vfunc_called(this, "_ZN6S101C53v92Ev");}
void  S101C5 ::v93(){vfunc_called(this, "_ZN6S101C53v93Ev");}
void  S101C5 ::v94(){vfunc_called(this, "_ZN6S101C53v94Ev");}
void  S101C5 ::v95(){vfunc_called(this, "_ZN6S101C53v95Ev");}
void  S101C5 ::v96(){vfunc_called(this, "_ZN6S101C53v96Ev");}
void  S101C5 ::v97(){vfunc_called(this, "_ZN6S101C53v97Ev");}
void  S101C5 ::v98(){vfunc_called(this, "_ZN6S101C53v98Ev");}
void  S101C5 ::v99(){vfunc_called(this, "_ZN6S101C53v99Ev");}
void  S101C5 ::v100(){vfunc_called(this, "_ZN6S101C54v100Ev");}
void  S101C5 ::v101(){vfunc_called(this, "_ZN6S101C54v101Ev");}
void  S101C5 ::v102(){vfunc_called(this, "_ZN6S101C54v102Ev");}
void  S101C5 ::v103(){vfunc_called(this, "_ZN6S101C54v103Ev");}
void  S101C5 ::v104(){vfunc_called(this, "_ZN6S101C54v104Ev");}
void  S101C5 ::v105(){vfunc_called(this, "_ZN6S101C54v105Ev");}
void  S101C5 ::v106(){vfunc_called(this, "_ZN6S101C54v106Ev");}
void  S101C5 ::v107(){vfunc_called(this, "_ZN6S101C54v107Ev");}
void  S101C5 ::v108(){vfunc_called(this, "_ZN6S101C54v108Ev");}
void  S101C5 ::v109(){vfunc_called(this, "_ZN6S101C54v109Ev");}
void  S101C5 ::v110(){vfunc_called(this, "_ZN6S101C54v110Ev");}
void  S101C5 ::v111(){vfunc_called(this, "_ZN6S101C54v111Ev");}
void  S101C5 ::v112(){vfunc_called(this, "_ZN6S101C54v112Ev");}
void  S101C5 ::v113(){vfunc_called(this, "_ZN6S101C54v113Ev");}
void  S101C5 ::v114(){vfunc_called(this, "_ZN6S101C54v114Ev");}
void  S101C5 ::v115(){vfunc_called(this, "_ZN6S101C54v115Ev");}
void  S101C5 ::v116(){vfunc_called(this, "_ZN6S101C54v116Ev");}
void  S101C5 ::v117(){vfunc_called(this, "_ZN6S101C54v117Ev");}
void  S101C5 ::v118(){vfunc_called(this, "_ZN6S101C54v118Ev");}
void  S101C5 ::v119(){vfunc_called(this, "_ZN6S101C54v119Ev");}
void  S101C5 ::v120(){vfunc_called(this, "_ZN6S101C54v120Ev");}
void  S101C5 ::v121(){vfunc_called(this, "_ZN6S101C54v121Ev");}
void  S101C5 ::v122(){vfunc_called(this, "_ZN6S101C54v122Ev");}
void  S101C5 ::v123(){vfunc_called(this, "_ZN6S101C54v123Ev");}
void  S101C5 ::v124(){vfunc_called(this, "_ZN6S101C54v124Ev");}
void  S101C5 ::v125(){vfunc_called(this, "_ZN6S101C54v125Ev");}
void  S101C5 ::v126(){vfunc_called(this, "_ZN6S101C54v126Ev");}
void  S101C5 ::v127(){vfunc_called(this, "_ZN6S101C54v127Ev");}
void  S101C5 ::v128(){vfunc_called(this, "_ZN6S101C54v128Ev");}
void  S101C5 ::v129(){vfunc_called(this, "_ZN6S101C54v129Ev");}
void  S101C5 ::v130(){vfunc_called(this, "_ZN6S101C54v130Ev");}
void  S101C5 ::v131(){vfunc_called(this, "_ZN6S101C54v131Ev");}
void  S101C5 ::v132(){vfunc_called(this, "_ZN6S101C54v132Ev");}
void  S101C5 ::v133(){vfunc_called(this, "_ZN6S101C54v133Ev");}
void  S101C5 ::v134(){vfunc_called(this, "_ZN6S101C54v134Ev");}
void  S101C5 ::v135(){vfunc_called(this, "_ZN6S101C54v135Ev");}
void  S101C5 ::v136(){vfunc_called(this, "_ZN6S101C54v136Ev");}
void  S101C5 ::v137(){vfunc_called(this, "_ZN6S101C54v137Ev");}
void  S101C5 ::v138(){vfunc_called(this, "_ZN6S101C54v138Ev");}
void  S101C5 ::v139(){vfunc_called(this, "_ZN6S101C54v139Ev");}
void  S101C5 ::v140(){vfunc_called(this, "_ZN6S101C54v140Ev");}
void  S101C5 ::v141(){vfunc_called(this, "_ZN6S101C54v141Ev");}
void  S101C5 ::v142(){vfunc_called(this, "_ZN6S101C54v142Ev");}
void  S101C5 ::v143(){vfunc_called(this, "_ZN6S101C54v143Ev");}
void  S101C5 ::v144(){vfunc_called(this, "_ZN6S101C54v144Ev");}
void  S101C5 ::v145(){vfunc_called(this, "_ZN6S101C54v145Ev");}
void  S101C5 ::v146(){vfunc_called(this, "_ZN6S101C54v146Ev");}
S101C5 ::S101C5(){ note_ctor("S101C5", this);} // tgen

static void Test_S101C5()
{
  extern Class_Descriptor cd_S101C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S101C5, buf);
    S101C5 *dp, &lv = *(dp=new (buf) S101C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S101C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C5)");
    check_base_class_offset(lv, (S101C7*)(S101C6*), 0, "S101C5");
    check_base_class_offset(lv, (S101C6*), 0, "S101C5");
    check_field_offset(lv, s101c5f0, ABISELECT(96,60), "S101C5.s101c5f0");
    check_field_offset(lv, s101c5f1, ABISELECT(124,88), "S101C5.s101c5f1");
    set_bf_and_test(lv, s101c5f2, ABISELECT(128,92), 0, 1, 1, "S101C5");
    set_bf_and_test(lv, s101c5f3, ABISELECT(128,92), 1, 1, 1, "S101C5");
    set_bf_and_test(lv, s101c5f4, ABISELECT(128,92), 2, 1, 1, "S101C5");
    set_bf_and_test(lv, s101c5f5, ABISELECT(128,92), 3, 1, 1, "S101C5");
    check_field_offset(lv, s101c5f6, ABISELECT(136,96), "S101C5.s101c5f6");
    check_field_offset(lv, s101c5f7, ABISELECT(152,108), "S101C5.s101c5f7");
    check_field_offset(lv, s101c5f8, ABISELECT(168,120), "S101C5.s101c5f8");
    check_field_offset(lv, s101c5f9, ABISELECT(176,124), "S101C5.s101c5f9");
    check_field_offset(lv, s101c5f10, ABISELECT(192,136), "S101C5.s101c5f10");
    check_field_offset(lv, s101c5f11, ABISELECT(208,148), "S101C5.s101c5f11");
    check_field_offset(lv, s101c5f12, ABISELECT(224,160), "S101C5.s101c5f12");
    check_field_offset(lv, s101c5f13, ABISELECT(240,172), "S101C5.s101c5f13");
    check_field_offset(lv, s101c5f14, ABISELECT(244,176), "S101C5.s101c5f14");
    check_field_offset(lv, s101c5f15, ABISELECT(248,180), "S101C5.s101c5f15");
    check_field_offset(lv, s101c5f16, ABISELECT(256,184), "S101C5.s101c5f16");
    check_field_offset(lv, s101c5f17, ABISELECT(264,192), "S101C5.s101c5f17");
    check_field_offset(lv, s101c5f18, ABISELECT(272,200), "S101C5.s101c5f18");
    check_field_offset(lv, s101c5f19, ABISELECT(280,208), "S101C5.s101c5f19");
    check_field_offset(lv, s101c5f20, ABISELECT(288,216), "S101C5.s101c5f20");
    check_field_offset(lv, s101c5f21, ABISELECT(296,224), "S101C5.s101c5f21");
    check_field_offset(lv, s101c5f22, ABISELECT(304,232), "S101C5.s101c5f22");
    check_field_offset(lv, s101c5f23, ABISELECT(320,244), "S101C5.s101c5f23");
    check_field_offset(lv, s101c5f24, ABISELECT(336,256), "S101C5.s101c5f24");
    check_field_offset(lv, s101c5f25, ABISELECT(352,268), "S101C5.s101c5f25");
    check_field_offset(lv, s101c5f26, ABISELECT(368,280), "S101C5.s101c5f26");
    check_field_offset(lv, s101c5f27, ABISELECT(384,292), "S101C5.s101c5f27");
    check_field_offset(lv, s101c5f28, ABISELECT(400,304), "S101C5.s101c5f28");
    check_field_offset(lv, s101c5f29, ABISELECT(416,316), "S101C5.s101c5f29");
    check_field_offset(lv, s101c5f30, ABISELECT(432,328), "S101C5.s101c5f30");
    check_field_offset(lv, s101c5f31, ABISELECT(448,340), "S101C5.s101c5f31");
    test_class_info(&lv, &cd_S101C5);
    dp->~S101C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C5(Test_S101C5, "S101C5", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN6S101C5C1Ev();
extern void _ZN6S101C5D1Ev();
Name_Map name_map_S101C5[] = {
  NSPAIR(_ZN6S101C5C1Ev),
  NSPAIR(_ZN6S101C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
extern Class_Descriptor cd_S101C6;
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
static Base_Class bases_S101C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S101C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C5[];
extern void _ZN6S101C5D1Ev();
extern void _ZN6S101C5D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
extern void _ZN6S101C53v71Ev();
extern void _ZN6S101C53v72Ev();
extern void _ZN6S101C53v73Ev();
extern void _ZN6S101C53v74Ev();
extern void _ZN6S101C53v75Ev();
extern void _ZN6S101C53v76Ev();
extern void _ZN6S101C53v77Ev();
extern void _ZN6S101C53v78Ev();
extern void _ZN6S101C53v79Ev();
extern void _ZN6S101C53v80Ev();
extern void _ZN6S101C53v81Ev();
extern void _ZN6S101C53v82Ev();
extern void _ZN6S101C53v83Ev();
extern void _ZN6S101C53v84Ev();
extern void _ZN6S101C53v85Ev();
extern void _ZN6S101C53v86Ev();
extern void _ZN6S101C53v87Ev();
extern void _ZN6S101C53v88Ev();
extern void _ZN6S101C53v89Ev();
extern void _ZN6S101C53v90Ev();
extern void _ZN6S101C53v91Ev();
extern void _ZN6S101C53v92Ev();
extern void _ZN6S101C53v93Ev();
extern void _ZN6S101C53v94Ev();
extern void _ZN6S101C53v95Ev();
extern void _ZN6S101C53v96Ev();
extern void _ZN6S101C53v97Ev();
extern void _ZN6S101C53v98Ev();
extern void _ZN6S101C53v99Ev();
extern void _ZN6S101C54v100Ev();
extern void _ZN6S101C54v101Ev();
extern void _ZN6S101C54v102Ev();
extern void _ZN6S101C54v103Ev();
extern void _ZN6S101C54v104Ev();
extern void _ZN6S101C54v105Ev();
extern void _ZN6S101C54v106Ev();
extern void _ZN6S101C54v107Ev();
extern void _ZN6S101C54v108Ev();
extern void _ZN6S101C54v109Ev();
extern void _ZN6S101C54v110Ev();
extern void _ZN6S101C54v111Ev();
extern void _ZN6S101C54v112Ev();
extern void _ZN6S101C54v113Ev();
extern void _ZN6S101C54v114Ev();
extern void _ZN6S101C54v115Ev();
extern void _ZN6S101C54v116Ev();
extern void _ZN6S101C54v117Ev();
extern void _ZN6S101C54v118Ev();
extern void _ZN6S101C54v119Ev();
extern void _ZN6S101C54v120Ev();
extern void _ZN6S101C54v121Ev();
extern void _ZN6S101C54v122Ev();
extern void _ZN6S101C54v123Ev();
extern void _ZN6S101C54v124Ev();
extern void _ZN6S101C54v125Ev();
extern void _ZN6S101C54v126Ev();
extern void _ZN6S101C54v127Ev();
extern void _ZN6S101C54v128Ev();
extern void _ZN6S101C54v129Ev();
extern void _ZN6S101C54v130Ev();
extern void _ZN6S101C54v131Ev();
extern void _ZN6S101C54v132Ev();
extern void _ZN6S101C54v133Ev();
extern void _ZN6S101C54v134Ev();
extern void _ZN6S101C54v135Ev();
extern void _ZN6S101C54v136Ev();
extern void _ZN6S101C54v137Ev();
extern void _ZN6S101C54v138Ev();
extern void _ZN6S101C54v139Ev();
extern void _ZN6S101C54v140Ev();
extern void _ZN6S101C54v141Ev();
extern void _ZN6S101C54v142Ev();
extern void _ZN6S101C54v143Ev();
extern void _ZN6S101C54v144Ev();
extern void _ZN6S101C54v145Ev();
extern void _ZN6S101C54v146Ev();
static  VTBL_ENTRY vtc_S101C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C5[0]),
  (VTBL_ENTRY)&_ZN6S101C5D1Ev,
  (VTBL_ENTRY)&_ZN6S101C5D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
  (VTBL_ENTRY)&_ZN6S101C53v71Ev,
  (VTBL_ENTRY)&_ZN6S101C53v72Ev,
  (VTBL_ENTRY)&_ZN6S101C53v73Ev,
  (VTBL_ENTRY)&_ZN6S101C53v74Ev,
  (VTBL_ENTRY)&_ZN6S101C53v75Ev,
  (VTBL_ENTRY)&_ZN6S101C53v76Ev,
  (VTBL_ENTRY)&_ZN6S101C53v77Ev,
  (VTBL_ENTRY)&_ZN6S101C53v78Ev,
  (VTBL_ENTRY)&_ZN6S101C53v79Ev,
  (VTBL_ENTRY)&_ZN6S101C53v80Ev,
  (VTBL_ENTRY)&_ZN6S101C53v81Ev,
  (VTBL_ENTRY)&_ZN6S101C53v82Ev,
  (VTBL_ENTRY)&_ZN6S101C53v83Ev,
  (VTBL_ENTRY)&_ZN6S101C53v84Ev,
  (VTBL_ENTRY)&_ZN6S101C53v85Ev,
  (VTBL_ENTRY)&_ZN6S101C53v86Ev,
  (VTBL_ENTRY)&_ZN6S101C53v87Ev,
  (VTBL_ENTRY)&_ZN6S101C53v88Ev,
  (VTBL_ENTRY)&_ZN6S101C53v89Ev,
  (VTBL_ENTRY)&_ZN6S101C53v90Ev,
  (VTBL_ENTRY)&_ZN6S101C53v91Ev,
  (VTBL_ENTRY)&_ZN6S101C53v92Ev,
  (VTBL_ENTRY)&_ZN6S101C53v93Ev,
  (VTBL_ENTRY)&_ZN6S101C53v94Ev,
  (VTBL_ENTRY)&_ZN6S101C53v95Ev,
  (VTBL_ENTRY)&_ZN6S101C53v96Ev,
  (VTBL_ENTRY)&_ZN6S101C53v97Ev,
  (VTBL_ENTRY)&_ZN6S101C53v98Ev,
  (VTBL_ENTRY)&_ZN6S101C53v99Ev,
  (VTBL_ENTRY)&_ZN6S101C54v100Ev,
  (VTBL_ENTRY)&_ZN6S101C54v101Ev,
  (VTBL_ENTRY)&_ZN6S101C54v102Ev,
  (VTBL_ENTRY)&_ZN6S101C54v103Ev,
  (VTBL_ENTRY)&_ZN6S101C54v104Ev,
  (VTBL_ENTRY)&_ZN6S101C54v105Ev,
  (VTBL_ENTRY)&_ZN6S101C54v106Ev,
  (VTBL_ENTRY)&_ZN6S101C54v107Ev,
  (VTBL_ENTRY)&_ZN6S101C54v108Ev,
  (VTBL_ENTRY)&_ZN6S101C54v109Ev,
  (VTBL_ENTRY)&_ZN6S101C54v110Ev,
  (VTBL_ENTRY)&_ZN6S101C54v111Ev,
  (VTBL_ENTRY)&_ZN6S101C54v112Ev,
  (VTBL_ENTRY)&_ZN6S101C54v113Ev,
  (VTBL_ENTRY)&_ZN6S101C54v114Ev,
  (VTBL_ENTRY)&_ZN6S101C54v115Ev,
  (VTBL_ENTRY)&_ZN6S101C54v116Ev,
  (VTBL_ENTRY)&_ZN6S101C54v117Ev,
  (VTBL_ENTRY)&_ZN6S101C54v118Ev,
  (VTBL_ENTRY)&_ZN6S101C54v119Ev,
  (VTBL_ENTRY)&_ZN6S101C54v120Ev,
  (VTBL_ENTRY)&_ZN6S101C54v121Ev,
  (VTBL_ENTRY)&_ZN6S101C54v122Ev,
  (VTBL_ENTRY)&_ZN6S101C54v123Ev,
  (VTBL_ENTRY)&_ZN6S101C54v124Ev,
  (VTBL_ENTRY)&_ZN6S101C54v125Ev,
  (VTBL_ENTRY)&_ZN6S101C54v126Ev,
  (VTBL_ENTRY)&_ZN6S101C54v127Ev,
  (VTBL_ENTRY)&_ZN6S101C54v128Ev,
  (VTBL_ENTRY)&_ZN6S101C54v129Ev,
  (VTBL_ENTRY)&_ZN6S101C54v130Ev,
  (VTBL_ENTRY)&_ZN6S101C54v131Ev,
  (VTBL_ENTRY)&_ZN6S101C54v132Ev,
  (VTBL_ENTRY)&_ZN6S101C54v133Ev,
  (VTBL_ENTRY)&_ZN6S101C54v134Ev,
  (VTBL_ENTRY)&_ZN6S101C54v135Ev,
  (VTBL_ENTRY)&_ZN6S101C54v136Ev,
  (VTBL_ENTRY)&_ZN6S101C54v137Ev,
  (VTBL_ENTRY)&_ZN6S101C54v138Ev,
  (VTBL_ENTRY)&_ZN6S101C54v139Ev,
  (VTBL_ENTRY)&_ZN6S101C54v140Ev,
  (VTBL_ENTRY)&_ZN6S101C54v141Ev,
  (VTBL_ENTRY)&_ZN6S101C54v142Ev,
  (VTBL_ENTRY)&_ZN6S101C54v143Ev,
  (VTBL_ENTRY)&_ZN6S101C54v144Ev,
  (VTBL_ENTRY)&_ZN6S101C54v145Ev,
  (VTBL_ENTRY)&_ZN6S101C54v146Ev,
};
extern VTBL_ENTRY _ZTI6S101C5[];
extern  VTBL_ENTRY _ZTV6S101C5[];
Class_Descriptor cd_S101C5 = {  "S101C5", // class name
  bases_S101C5, 2,
  &(vtc_S101C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI6S101C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C5),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C4  : S101C5 {
  ::S85C27_nt s101c4f0;
  void *s101c4f1[9];
  ::S80C15 s101c4f2;
  ::S85C35 s101c4f3;
  ::S80C24 s101c4f4;
  int s101c4f5;
  unsigned int s101c4f6:1;
  unsigned int s101c4f7:1;
  unsigned int s101c4f8:1;
  unsigned int s101c4f9:1;
  unsigned int s101c4f10:1;
  unsigned int s101c4f11:1;
  unsigned int s101c4f12:1;
  unsigned int s101c4f13:1;
  unsigned int s101c4f14:1;
  unsigned int s101c4f15:1;
  unsigned int s101c4f16:1;
  unsigned int s101c4f17:1;
  unsigned int s101c4f18:1;
  unsigned int s101c4f19:1;
  unsigned int s101c4f20:1;
  unsigned int s101c4f21:1;
  unsigned int s101c4f22:1;
  unsigned int s101c4f23:1;
  unsigned int s101c4f24:1;
  unsigned int s101c4f25:1;
  unsigned int s101c4f26:1;
  unsigned int s101c4f27:1;
  void *s101c4f28;
  char s101c4f29[2];
  ::S80C8_nt s101c4f30;
  ::S85C27_nt s101c4f31;
  ::S85C27_nt s101c4f32;
  void *s101c4f33;
  ::S80C21_nt s101c4f34;
  ::S80C21_nt s101c4f35;
  ::S80C21_nt s101c4f36;
  ::S80C21_nt s101c4f37;
  ::S80C21_nt s101c4f38;
  virtual  ~S101C4(); // _ZN6S101C4D1Ev
  virtual void  v147(); // _ZN6S101C44v147Ev
  virtual void  v148(); // _ZN6S101C44v148Ev
  virtual void  v149(); // _ZN6S101C44v149Ev
  virtual void  v150(); // _ZN6S101C44v150Ev
  virtual void  v151(); // _ZN6S101C44v151Ev
  virtual void  v152(); // _ZN6S101C44v152Ev
  virtual void  v153(); // _ZN6S101C44v153Ev
  virtual void  v154(); // _ZN6S101C44v154Ev
  virtual void  v155(); // _ZN6S101C44v155Ev
  virtual void  v156(); // _ZN6S101C44v156Ev
  virtual void  v157(); // _ZN6S101C44v157Ev
  virtual void  v158(); // _ZN6S101C44v158Ev
  virtual void  v159(); // _ZN6S101C44v159Ev
  virtual void  v160(); // _ZN6S101C44v160Ev
  virtual void  v161(); // _ZN6S101C44v161Ev
  virtual void  v162(); // _ZN6S101C44v162Ev
  virtual void  v163(); // _ZN6S101C44v163Ev
  virtual void  v164(); // _ZN6S101C44v164Ev
  virtual void  v165(); // _ZN6S101C44v165Ev
  virtual void  v166(); // _ZN6S101C44v166Ev
  virtual void  v167(); // _ZN6S101C44v167Ev
  virtual void  v168(); // _ZN6S101C44v168Ev
  virtual void  v169(); // _ZN6S101C44v169Ev
  virtual void  v170(); // _ZN6S101C44v170Ev
  virtual void  v171(); // _ZN6S101C44v171Ev
  virtual void  v172(); // _ZN6S101C44v172Ev
  virtual void  v173(); // _ZN6S101C44v173Ev
  virtual void  v174(); // _ZN6S101C44v174Ev
  virtual void  v175(); // _ZN6S101C44v175Ev
  virtual void  v176(); // _ZN6S101C44v176Ev
  virtual void  v177(); // _ZN6S101C44v177Ev
  virtual void  v178(); // _ZN6S101C44v178Ev
  virtual void  v179(); // _ZN6S101C44v179Ev
  virtual void  v180(); // _ZN6S101C44v180Ev
  virtual void  v181(); // _ZN6S101C44v181Ev
  virtual void  v182(); // _ZN6S101C44v182Ev
  virtual void  v183(); // _ZN6S101C44v183Ev
  virtual void  v184(); // _ZN6S101C44v184Ev
  virtual void  v185(); // _ZN6S101C44v185Ev
  S101C4(); // tgen
};
//SIG(-1 S101C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC19{ m Fi[2]}} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC20{ BC21{ BC9}} FC7 FC22{ BC23{ m FC24{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC19 FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S101C4 ::~S101C4(){ note_dtor("S101C4", this);}
void  S101C4 ::v147(){vfunc_called(this, "_ZN6S101C44v147Ev");}
void  S101C4 ::v148(){vfunc_called(this, "_ZN6S101C44v148Ev");}
void  S101C4 ::v149(){vfunc_called(this, "_ZN6S101C44v149Ev");}
void  S101C4 ::v150(){vfunc_called(this, "_ZN6S101C44v150Ev");}
void  S101C4 ::v151(){vfunc_called(this, "_ZN6S101C44v151Ev");}
void  S101C4 ::v152(){vfunc_called(this, "_ZN6S101C44v152Ev");}
void  S101C4 ::v153(){vfunc_called(this, "_ZN6S101C44v153Ev");}
void  S101C4 ::v154(){vfunc_called(this, "_ZN6S101C44v154Ev");}
void  S101C4 ::v155(){vfunc_called(this, "_ZN6S101C44v155Ev");}
void  S101C4 ::v156(){vfunc_called(this, "_ZN6S101C44v156Ev");}
void  S101C4 ::v157(){vfunc_called(this, "_ZN6S101C44v157Ev");}
void  S101C4 ::v158(){vfunc_called(this, "_ZN6S101C44v158Ev");}
void  S101C4 ::v159(){vfunc_called(this, "_ZN6S101C44v159Ev");}
void  S101C4 ::v160(){vfunc_called(this, "_ZN6S101C44v160Ev");}
void  S101C4 ::v161(){vfunc_called(this, "_ZN6S101C44v161Ev");}
void  S101C4 ::v162(){vfunc_called(this, "_ZN6S101C44v162Ev");}
void  S101C4 ::v163(){vfunc_called(this, "_ZN6S101C44v163Ev");}
void  S101C4 ::v164(){vfunc_called(this, "_ZN6S101C44v164Ev");}
void  S101C4 ::v165(){vfunc_called(this, "_ZN6S101C44v165Ev");}
void  S101C4 ::v166(){vfunc_called(this, "_ZN6S101C44v166Ev");}
void  S101C4 ::v167(){vfunc_called(this, "_ZN6S101C44v167Ev");}
void  S101C4 ::v168(){vfunc_called(this, "_ZN6S101C44v168Ev");}
void  S101C4 ::v169(){vfunc_called(this, "_ZN6S101C44v169Ev");}
void  S101C4 ::v170(){vfunc_called(this, "_ZN6S101C44v170Ev");}
void  S101C4 ::v171(){vfunc_called(this, "_ZN6S101C44v171Ev");}
void  S101C4 ::v172(){vfunc_called(this, "_ZN6S101C44v172Ev");}
void  S101C4 ::v173(){vfunc_called(this, "_ZN6S101C44v173Ev");}
void  S101C4 ::v174(){vfunc_called(this, "_ZN6S101C44v174Ev");}
void  S101C4 ::v175(){vfunc_called(this, "_ZN6S101C44v175Ev");}
void  S101C4 ::v176(){vfunc_called(this, "_ZN6S101C44v176Ev");}
void  S101C4 ::v177(){vfunc_called(this, "_ZN6S101C44v177Ev");}
void  S101C4 ::v178(){vfunc_called(this, "_ZN6S101C44v178Ev");}
void  S101C4 ::v179(){vfunc_called(this, "_ZN6S101C44v179Ev");}
void  S101C4 ::v180(){vfunc_called(this, "_ZN6S101C44v180Ev");}
void  S101C4 ::v181(){vfunc_called(this, "_ZN6S101C44v181Ev");}
void  S101C4 ::v182(){vfunc_called(this, "_ZN6S101C44v182Ev");}
void  S101C4 ::v183(){vfunc_called(this, "_ZN6S101C44v183Ev");}
void  S101C4 ::v184(){vfunc_called(this, "_ZN6S101C44v184Ev");}
void  S101C4 ::v185(){vfunc_called(this, "_ZN6S101C44v185Ev");}
S101C4 ::S101C4(){ note_ctor("S101C4", this);} // tgen

static void Test_S101C4()
{
  extern Class_Descriptor cd_S101C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S101C4, buf);
    S101C4 *dp, &lv = *(dp=new (buf) S101C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S101C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C4)");
    check_base_class_offset(lv, (S101C7*)(S101C6*)(S101C5*), 0, "S101C4");
    check_base_class_offset(lv, (S101C6*)(S101C5*), 0, "S101C4");
    check_base_class_offset(lv, (S101C5*), 0, "S101C4");
    check_field_offset(lv, s101c4f0, ABISELECT(464,352), "S101C4.s101c4f0");
    check_field_offset(lv, s101c4f1, ABISELECT(472,360), "S101C4.s101c4f1");
    check_field_offset(lv, s101c4f2, ABISELECT(544,396), "S101C4.s101c4f2");
    check_field_offset(lv, s101c4f3, ABISELECT(560,408), "S101C4.s101c4f3");
    check_field_offset(lv, s101c4f4, ABISELECT(576,420), "S101C4.s101c4f4");
    check_field_offset(lv, s101c4f5, ABISELECT(608,440), "S101C4.s101c4f5");
    set_bf_and_test(lv, s101c4f6, ABISELECT(612,444), 0, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f7, ABISELECT(612,444), 1, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f8, ABISELECT(612,444), 2, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f9, ABISELECT(612,444), 3, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f10, ABISELECT(612,444), 4, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f11, ABISELECT(612,444), 5, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f12, ABISELECT(612,444), 6, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f13, ABISELECT(612,444), 7, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f14, ABISELECT(613,445), 0, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f15, ABISELECT(613,445), 1, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f16, ABISELECT(613,445), 2, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f17, ABISELECT(613,445), 3, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f18, ABISELECT(613,445), 4, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f19, ABISELECT(613,445), 5, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f20, ABISELECT(613,445), 6, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f21, ABISELECT(613,445), 7, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f22, ABISELECT(614,446), 0, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f23, ABISELECT(614,446), 1, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f24, ABISELECT(614,446), 2, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f25, ABISELECT(614,446), 3, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f26, ABISELECT(614,446), 4, 1, 1, "S101C4");
    set_bf_and_test(lv, s101c4f27, ABISELECT(614,446), 5, 1, 1, "S101C4");
    check_field_offset(lv, s101c4f28, ABISELECT(616,448), "S101C4.s101c4f28");
    check_field_offset(lv, s101c4f29, ABISELECT(624,452), "S101C4.s101c4f29");
    check_field_offset(lv, s101c4f30, ABISELECT(628,456), "S101C4.s101c4f30");
    check_field_offset(lv, s101c4f31, ABISELECT(636,464), "S101C4.s101c4f31");
    check_field_offset(lv, s101c4f32, ABISELECT(644,472), "S101C4.s101c4f32");
    check_field_offset(lv, s101c4f33, ABISELECT(656,480), "S101C4.s101c4f33");
    check_field_offset(lv, s101c4f34, ABISELECT(664,484), "S101C4.s101c4f34");
    check_field_offset(lv, s101c4f35, ABISELECT(680,496), "S101C4.s101c4f35");
    check_field_offset(lv, s101c4f36, ABISELECT(696,508), "S101C4.s101c4f36");
    check_field_offset(lv, s101c4f37, ABISELECT(712,520), "S101C4.s101c4f37");
    check_field_offset(lv, s101c4f38, ABISELECT(728,532), "S101C4.s101c4f38");
    test_class_info(&lv, &cd_S101C4);
    dp->~S101C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C4(Test_S101C4, "S101C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN6S101C4C1Ev();
extern void _ZN6S101C4D1Ev();
Name_Map name_map_S101C4[] = {
  NSPAIR(_ZN6S101C4C1Ev),
  NSPAIR(_ZN6S101C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
extern Class_Descriptor cd_S101C6;
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
extern Class_Descriptor cd_S101C5;
extern VTBL_ENTRY _ZTI6S101C5[];
extern  VTBL_ENTRY _ZTV6S101C5[];
static Base_Class bases_S101C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S101C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S101C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C4[];
extern void _ZN6S101C4D1Ev();
extern void _ZN6S101C4D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
extern void _ZN6S101C53v71Ev();
extern void _ZN6S101C53v72Ev();
extern void _ZN6S101C53v73Ev();
extern void _ZN6S101C53v74Ev();
extern void _ZN6S101C53v75Ev();
extern void _ZN6S101C53v76Ev();
extern void _ZN6S101C53v77Ev();
extern void _ZN6S101C53v78Ev();
extern void _ZN6S101C53v79Ev();
extern void _ZN6S101C53v80Ev();
extern void _ZN6S101C53v81Ev();
extern void _ZN6S101C53v82Ev();
extern void _ZN6S101C53v83Ev();
extern void _ZN6S101C53v84Ev();
extern void _ZN6S101C53v85Ev();
extern void _ZN6S101C53v86Ev();
extern void _ZN6S101C53v87Ev();
extern void _ZN6S101C53v88Ev();
extern void _ZN6S101C53v89Ev();
extern void _ZN6S101C53v90Ev();
extern void _ZN6S101C53v91Ev();
extern void _ZN6S101C53v92Ev();
extern void _ZN6S101C53v93Ev();
extern void _ZN6S101C53v94Ev();
extern void _ZN6S101C53v95Ev();
extern void _ZN6S101C53v96Ev();
extern void _ZN6S101C53v97Ev();
extern void _ZN6S101C53v98Ev();
extern void _ZN6S101C53v99Ev();
extern void _ZN6S101C54v100Ev();
extern void _ZN6S101C54v101Ev();
extern void _ZN6S101C54v102Ev();
extern void _ZN6S101C54v103Ev();
extern void _ZN6S101C54v104Ev();
extern void _ZN6S101C54v105Ev();
extern void _ZN6S101C54v106Ev();
extern void _ZN6S101C54v107Ev();
extern void _ZN6S101C54v108Ev();
extern void _ZN6S101C54v109Ev();
extern void _ZN6S101C54v110Ev();
extern void _ZN6S101C54v111Ev();
extern void _ZN6S101C54v112Ev();
extern void _ZN6S101C54v113Ev();
extern void _ZN6S101C54v114Ev();
extern void _ZN6S101C54v115Ev();
extern void _ZN6S101C54v116Ev();
extern void _ZN6S101C54v117Ev();
extern void _ZN6S101C54v118Ev();
extern void _ZN6S101C54v119Ev();
extern void _ZN6S101C54v120Ev();
extern void _ZN6S101C54v121Ev();
extern void _ZN6S101C54v122Ev();
extern void _ZN6S101C54v123Ev();
extern void _ZN6S101C54v124Ev();
extern void _ZN6S101C54v125Ev();
extern void _ZN6S101C54v126Ev();
extern void _ZN6S101C54v127Ev();
extern void _ZN6S101C54v128Ev();
extern void _ZN6S101C54v129Ev();
extern void _ZN6S101C54v130Ev();
extern void _ZN6S101C54v131Ev();
extern void _ZN6S101C54v132Ev();
extern void _ZN6S101C54v133Ev();
extern void _ZN6S101C54v134Ev();
extern void _ZN6S101C54v135Ev();
extern void _ZN6S101C54v136Ev();
extern void _ZN6S101C54v137Ev();
extern void _ZN6S101C54v138Ev();
extern void _ZN6S101C54v139Ev();
extern void _ZN6S101C54v140Ev();
extern void _ZN6S101C54v141Ev();
extern void _ZN6S101C54v142Ev();
extern void _ZN6S101C54v143Ev();
extern void _ZN6S101C54v144Ev();
extern void _ZN6S101C54v145Ev();
extern void _ZN6S101C54v146Ev();
extern void _ZN6S101C44v147Ev();
extern void _ZN6S101C44v148Ev();
extern void _ZN6S101C44v149Ev();
extern void _ZN6S101C44v150Ev();
extern void _ZN6S101C44v151Ev();
extern void _ZN6S101C44v152Ev();
extern void _ZN6S101C44v153Ev();
extern void _ZN6S101C44v154Ev();
extern void _ZN6S101C44v155Ev();
extern void _ZN6S101C44v156Ev();
extern void _ZN6S101C44v157Ev();
extern void _ZN6S101C44v158Ev();
extern void _ZN6S101C44v159Ev();
extern void _ZN6S101C44v160Ev();
extern void _ZN6S101C44v161Ev();
extern void _ZN6S101C44v162Ev();
extern void _ZN6S101C44v163Ev();
extern void _ZN6S101C44v164Ev();
extern void _ZN6S101C44v165Ev();
extern void _ZN6S101C44v166Ev();
extern void _ZN6S101C44v167Ev();
extern void _ZN6S101C44v168Ev();
extern void _ZN6S101C44v169Ev();
extern void _ZN6S101C44v170Ev();
extern void _ZN6S101C44v171Ev();
extern void _ZN6S101C44v172Ev();
extern void _ZN6S101C44v173Ev();
extern void _ZN6S101C44v174Ev();
extern void _ZN6S101C44v175Ev();
extern void _ZN6S101C44v176Ev();
extern void _ZN6S101C44v177Ev();
extern void _ZN6S101C44v178Ev();
extern void _ZN6S101C44v179Ev();
extern void _ZN6S101C44v180Ev();
extern void _ZN6S101C44v181Ev();
extern void _ZN6S101C44v182Ev();
extern void _ZN6S101C44v183Ev();
extern void _ZN6S101C44v184Ev();
extern void _ZN6S101C44v185Ev();
static  VTBL_ENTRY vtc_S101C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C4[0]),
  (VTBL_ENTRY)&_ZN6S101C4D1Ev,
  (VTBL_ENTRY)&_ZN6S101C4D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
  (VTBL_ENTRY)&_ZN6S101C53v71Ev,
  (VTBL_ENTRY)&_ZN6S101C53v72Ev,
  (VTBL_ENTRY)&_ZN6S101C53v73Ev,
  (VTBL_ENTRY)&_ZN6S101C53v74Ev,
  (VTBL_ENTRY)&_ZN6S101C53v75Ev,
  (VTBL_ENTRY)&_ZN6S101C53v76Ev,
  (VTBL_ENTRY)&_ZN6S101C53v77Ev,
  (VTBL_ENTRY)&_ZN6S101C53v78Ev,
  (VTBL_ENTRY)&_ZN6S101C53v79Ev,
  (VTBL_ENTRY)&_ZN6S101C53v80Ev,
  (VTBL_ENTRY)&_ZN6S101C53v81Ev,
  (VTBL_ENTRY)&_ZN6S101C53v82Ev,
  (VTBL_ENTRY)&_ZN6S101C53v83Ev,
  (VTBL_ENTRY)&_ZN6S101C53v84Ev,
  (VTBL_ENTRY)&_ZN6S101C53v85Ev,
  (VTBL_ENTRY)&_ZN6S101C53v86Ev,
  (VTBL_ENTRY)&_ZN6S101C53v87Ev,
  (VTBL_ENTRY)&_ZN6S101C53v88Ev,
  (VTBL_ENTRY)&_ZN6S101C53v89Ev,
  (VTBL_ENTRY)&_ZN6S101C53v90Ev,
  (VTBL_ENTRY)&_ZN6S101C53v91Ev,
  (VTBL_ENTRY)&_ZN6S101C53v92Ev,
  (VTBL_ENTRY)&_ZN6S101C53v93Ev,
  (VTBL_ENTRY)&_ZN6S101C53v94Ev,
  (VTBL_ENTRY)&_ZN6S101C53v95Ev,
  (VTBL_ENTRY)&_ZN6S101C53v96Ev,
  (VTBL_ENTRY)&_ZN6S101C53v97Ev,
  (VTBL_ENTRY)&_ZN6S101C53v98Ev,
  (VTBL_ENTRY)&_ZN6S101C53v99Ev,
  (VTBL_ENTRY)&_ZN6S101C54v100Ev,
  (VTBL_ENTRY)&_ZN6S101C54v101Ev,
  (VTBL_ENTRY)&_ZN6S101C54v102Ev,
  (VTBL_ENTRY)&_ZN6S101C54v103Ev,
  (VTBL_ENTRY)&_ZN6S101C54v104Ev,
  (VTBL_ENTRY)&_ZN6S101C54v105Ev,
  (VTBL_ENTRY)&_ZN6S101C54v106Ev,
  (VTBL_ENTRY)&_ZN6S101C54v107Ev,
  (VTBL_ENTRY)&_ZN6S101C54v108Ev,
  (VTBL_ENTRY)&_ZN6S101C54v109Ev,
  (VTBL_ENTRY)&_ZN6S101C54v110Ev,
  (VTBL_ENTRY)&_ZN6S101C54v111Ev,
  (VTBL_ENTRY)&_ZN6S101C54v112Ev,
  (VTBL_ENTRY)&_ZN6S101C54v113Ev,
  (VTBL_ENTRY)&_ZN6S101C54v114Ev,
  (VTBL_ENTRY)&_ZN6S101C54v115Ev,
  (VTBL_ENTRY)&_ZN6S101C54v116Ev,
  (VTBL_ENTRY)&_ZN6S101C54v117Ev,
  (VTBL_ENTRY)&_ZN6S101C54v118Ev,
  (VTBL_ENTRY)&_ZN6S101C54v119Ev,
  (VTBL_ENTRY)&_ZN6S101C54v120Ev,
  (VTBL_ENTRY)&_ZN6S101C54v121Ev,
  (VTBL_ENTRY)&_ZN6S101C54v122Ev,
  (VTBL_ENTRY)&_ZN6S101C54v123Ev,
  (VTBL_ENTRY)&_ZN6S101C54v124Ev,
  (VTBL_ENTRY)&_ZN6S101C54v125Ev,
  (VTBL_ENTRY)&_ZN6S101C54v126Ev,
  (VTBL_ENTRY)&_ZN6S101C54v127Ev,
  (VTBL_ENTRY)&_ZN6S101C54v128Ev,
  (VTBL_ENTRY)&_ZN6S101C54v129Ev,
  (VTBL_ENTRY)&_ZN6S101C54v130Ev,
  (VTBL_ENTRY)&_ZN6S101C54v131Ev,
  (VTBL_ENTRY)&_ZN6S101C54v132Ev,
  (VTBL_ENTRY)&_ZN6S101C54v133Ev,
  (VTBL_ENTRY)&_ZN6S101C54v134Ev,
  (VTBL_ENTRY)&_ZN6S101C54v135Ev,
  (VTBL_ENTRY)&_ZN6S101C54v136Ev,
  (VTBL_ENTRY)&_ZN6S101C54v137Ev,
  (VTBL_ENTRY)&_ZN6S101C54v138Ev,
  (VTBL_ENTRY)&_ZN6S101C54v139Ev,
  (VTBL_ENTRY)&_ZN6S101C54v140Ev,
  (VTBL_ENTRY)&_ZN6S101C54v141Ev,
  (VTBL_ENTRY)&_ZN6S101C54v142Ev,
  (VTBL_ENTRY)&_ZN6S101C54v143Ev,
  (VTBL_ENTRY)&_ZN6S101C54v144Ev,
  (VTBL_ENTRY)&_ZN6S101C54v145Ev,
  (VTBL_ENTRY)&_ZN6S101C54v146Ev,
  (VTBL_ENTRY)&_ZN6S101C44v147Ev,
  (VTBL_ENTRY)&_ZN6S101C44v148Ev,
  (VTBL_ENTRY)&_ZN6S101C44v149Ev,
  (VTBL_ENTRY)&_ZN6S101C44v150Ev,
  (VTBL_ENTRY)&_ZN6S101C44v151Ev,
  (VTBL_ENTRY)&_ZN6S101C44v152Ev,
  (VTBL_ENTRY)&_ZN6S101C44v153Ev,
  (VTBL_ENTRY)&_ZN6S101C44v154Ev,
  (VTBL_ENTRY)&_ZN6S101C44v155Ev,
  (VTBL_ENTRY)&_ZN6S101C44v156Ev,
  (VTBL_ENTRY)&_ZN6S101C44v157Ev,
  (VTBL_ENTRY)&_ZN6S101C44v158Ev,
  (VTBL_ENTRY)&_ZN6S101C44v159Ev,
  (VTBL_ENTRY)&_ZN6S101C44v160Ev,
  (VTBL_ENTRY)&_ZN6S101C44v161Ev,
  (VTBL_ENTRY)&_ZN6S101C44v162Ev,
  (VTBL_ENTRY)&_ZN6S101C44v163Ev,
  (VTBL_ENTRY)&_ZN6S101C44v164Ev,
  (VTBL_ENTRY)&_ZN6S101C44v165Ev,
  (VTBL_ENTRY)&_ZN6S101C44v166Ev,
  (VTBL_ENTRY)&_ZN6S101C44v167Ev,
  (VTBL_ENTRY)&_ZN6S101C44v168Ev,
  (VTBL_ENTRY)&_ZN6S101C44v169Ev,
  (VTBL_ENTRY)&_ZN6S101C44v170Ev,
  (VTBL_ENTRY)&_ZN6S101C44v171Ev,
  (VTBL_ENTRY)&_ZN6S101C44v172Ev,
  (VTBL_ENTRY)&_ZN6S101C44v173Ev,
  (VTBL_ENTRY)&_ZN6S101C44v174Ev,
  (VTBL_ENTRY)&_ZN6S101C44v175Ev,
  (VTBL_ENTRY)&_ZN6S101C44v176Ev,
  (VTBL_ENTRY)&_ZN6S101C44v177Ev,
  (VTBL_ENTRY)&_ZN6S101C44v178Ev,
  (VTBL_ENTRY)&_ZN6S101C44v179Ev,
  (VTBL_ENTRY)&_ZN6S101C44v180Ev,
  (VTBL_ENTRY)&_ZN6S101C44v181Ev,
  (VTBL_ENTRY)&_ZN6S101C44v182Ev,
  (VTBL_ENTRY)&_ZN6S101C44v183Ev,
  (VTBL_ENTRY)&_ZN6S101C44v184Ev,
  (VTBL_ENTRY)&_ZN6S101C44v185Ev,
};
extern VTBL_ENTRY _ZTI6S101C4[];
extern  VTBL_ENTRY _ZTV6S101C4[];
Class_Descriptor cd_S101C4 = {  "S101C4", // class name
  bases_S101C4, 3,
  &(vtc_S101C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI6S101C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C3  : S101C4 {
  unsigned int s101c3f0:1;
  unsigned int s101c3f1:1;
  unsigned int s101c3f2:1;
  unsigned int s101c3f3:1;
  unsigned int s101c3f4:1;
  unsigned int s101c3f5:1;
  void *s101c3f6[8];
  ::S80C21_nt s101c3f7;
  ::S80C21_nt s101c3f8;
  ::S80C21_nt s101c3f9;
  virtual  ~S101C3(); // _ZN6S101C3D1Ev
  virtual void  v186(); // _ZN6S101C34v186Ev
  virtual void  v187(); // _ZN6S101C34v187Ev
  virtual void  v188(); // _ZN6S101C34v188Ev
  virtual void  v189(); // _ZN6S101C34v189Ev
  virtual void  v190(); // _ZN6S101C34v190Ev
  virtual void  v191(); // _ZN6S101C34v191Ev
  virtual void  v192(); // _ZN6S101C34v192Ev
  virtual void  v193(); // _ZN6S101C34v193Ev
  virtual void  v194(); // _ZN6S101C34v194Ev
  virtual void  v195(); // _ZN6S101C34v195Ev
  virtual void  v196(); // _ZN6S101C34v196Ev
  virtual void  v197(); // _ZN6S101C34v197Ev
  virtual void  v198(); // _ZN6S101C34v198Ev
  virtual void  v199(); // _ZN6S101C34v199Ev
  virtual void  v200(); // _ZN6S101C34v200Ev
  virtual void  v201(); // _ZN6S101C34v201Ev
  virtual void  v202(); // _ZN6S101C34v202Ev
  virtual void  v203(); // _ZN6S101C34v203Ev
  virtual void  v204(); // _ZN6S101C34v204Ev
  virtual void  v205(); // _ZN6S101C34v205Ev
  virtual void  v206(); // _ZN6S101C34v206Ev
  virtual void  v207(); // _ZN6S101C34v207Ev
  virtual void  v208(); // _ZN6S101C34v208Ev
  S101C3(); // tgen
};
//SIG(-1 S101C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC20{ m Fi[2]}} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC21{ BC22{ BC10}} FC8 FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC20 FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S101C3 ::~S101C3(){ note_dtor("S101C3", this);}
void  S101C3 ::v186(){vfunc_called(this, "_ZN6S101C34v186Ev");}
void  S101C3 ::v187(){vfunc_called(this, "_ZN6S101C34v187Ev");}
void  S101C3 ::v188(){vfunc_called(this, "_ZN6S101C34v188Ev");}
void  S101C3 ::v189(){vfunc_called(this, "_ZN6S101C34v189Ev");}
void  S101C3 ::v190(){vfunc_called(this, "_ZN6S101C34v190Ev");}
void  S101C3 ::v191(){vfunc_called(this, "_ZN6S101C34v191Ev");}
void  S101C3 ::v192(){vfunc_called(this, "_ZN6S101C34v192Ev");}
void  S101C3 ::v193(){vfunc_called(this, "_ZN6S101C34v193Ev");}
void  S101C3 ::v194(){vfunc_called(this, "_ZN6S101C34v194Ev");}
void  S101C3 ::v195(){vfunc_called(this, "_ZN6S101C34v195Ev");}
void  S101C3 ::v196(){vfunc_called(this, "_ZN6S101C34v196Ev");}
void  S101C3 ::v197(){vfunc_called(this, "_ZN6S101C34v197Ev");}
void  S101C3 ::v198(){vfunc_called(this, "_ZN6S101C34v198Ev");}
void  S101C3 ::v199(){vfunc_called(this, "_ZN6S101C34v199Ev");}
void  S101C3 ::v200(){vfunc_called(this, "_ZN6S101C34v200Ev");}
void  S101C3 ::v201(){vfunc_called(this, "_ZN6S101C34v201Ev");}
void  S101C3 ::v202(){vfunc_called(this, "_ZN6S101C34v202Ev");}
void  S101C3 ::v203(){vfunc_called(this, "_ZN6S101C34v203Ev");}
void  S101C3 ::v204(){vfunc_called(this, "_ZN6S101C34v204Ev");}
void  S101C3 ::v205(){vfunc_called(this, "_ZN6S101C34v205Ev");}
void  S101C3 ::v206(){vfunc_called(this, "_ZN6S101C34v206Ev");}
void  S101C3 ::v207(){vfunc_called(this, "_ZN6S101C34v207Ev");}
void  S101C3 ::v208(){vfunc_called(this, "_ZN6S101C34v208Ev");}
S101C3 ::S101C3(){ note_ctor("S101C3", this);} // tgen

static void Test_S101C3()
{
  extern Class_Descriptor cd_S101C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S101C3, buf);
    S101C3 *dp, &lv = *(dp=new (buf) S101C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S101C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C3)");
    check_base_class_offset(lv, (S101C7*)(S101C6*)(S101C5*)(S101C4*), 0, "S101C3");
    check_base_class_offset(lv, (S101C6*)(S101C5*)(S101C4*), 0, "S101C3");
    check_base_class_offset(lv, (S101C5*)(S101C4*), 0, "S101C3");
    check_base_class_offset(lv, (S101C4*), 0, "S101C3");
    set_bf_and_test(lv, s101c3f0, ABISELECT(744,544), 0, 1, 1, "S101C3");
    set_bf_and_test(lv, s101c3f1, ABISELECT(744,544), 1, 1, 1, "S101C3");
    set_bf_and_test(lv, s101c3f2, ABISELECT(744,544), 2, 1, 1, "S101C3");
    set_bf_and_test(lv, s101c3f3, ABISELECT(744,544), 3, 1, 1, "S101C3");
    set_bf_and_test(lv, s101c3f4, ABISELECT(744,544), 4, 1, 1, "S101C3");
    set_bf_and_test(lv, s101c3f5, ABISELECT(744,544), 5, 1, 1, "S101C3");
    check_field_offset(lv, s101c3f6, ABISELECT(752,548), "S101C3.s101c3f6");
    check_field_offset(lv, s101c3f7, ABISELECT(816,580), "S101C3.s101c3f7");
    check_field_offset(lv, s101c3f8, ABISELECT(832,592), "S101C3.s101c3f8");
    check_field_offset(lv, s101c3f9, ABISELECT(848,604), "S101C3.s101c3f9");
    test_class_info(&lv, &cd_S101C3);
    dp->~S101C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C3(Test_S101C3, "S101C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN6S101C3C1Ev();
extern void _ZN6S101C3D1Ev();
Name_Map name_map_S101C3[] = {
  NSPAIR(_ZN6S101C3C1Ev),
  NSPAIR(_ZN6S101C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
extern Class_Descriptor cd_S101C6;
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
extern Class_Descriptor cd_S101C5;
extern VTBL_ENTRY _ZTI6S101C5[];
extern  VTBL_ENTRY _ZTV6S101C5[];
extern Class_Descriptor cd_S101C4;
extern VTBL_ENTRY _ZTI6S101C4[];
extern  VTBL_ENTRY _ZTV6S101C4[];
static Base_Class bases_S101C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S101C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S101C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S101C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C3[];
extern void _ZN6S101C3D1Ev();
extern void _ZN6S101C3D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
extern void _ZN6S101C53v71Ev();
extern void _ZN6S101C53v72Ev();
extern void _ZN6S101C53v73Ev();
extern void _ZN6S101C53v74Ev();
extern void _ZN6S101C53v75Ev();
extern void _ZN6S101C53v76Ev();
extern void _ZN6S101C53v77Ev();
extern void _ZN6S101C53v78Ev();
extern void _ZN6S101C53v79Ev();
extern void _ZN6S101C53v80Ev();
extern void _ZN6S101C53v81Ev();
extern void _ZN6S101C53v82Ev();
extern void _ZN6S101C53v83Ev();
extern void _ZN6S101C53v84Ev();
extern void _ZN6S101C53v85Ev();
extern void _ZN6S101C53v86Ev();
extern void _ZN6S101C53v87Ev();
extern void _ZN6S101C53v88Ev();
extern void _ZN6S101C53v89Ev();
extern void _ZN6S101C53v90Ev();
extern void _ZN6S101C53v91Ev();
extern void _ZN6S101C53v92Ev();
extern void _ZN6S101C53v93Ev();
extern void _ZN6S101C53v94Ev();
extern void _ZN6S101C53v95Ev();
extern void _ZN6S101C53v96Ev();
extern void _ZN6S101C53v97Ev();
extern void _ZN6S101C53v98Ev();
extern void _ZN6S101C53v99Ev();
extern void _ZN6S101C54v100Ev();
extern void _ZN6S101C54v101Ev();
extern void _ZN6S101C54v102Ev();
extern void _ZN6S101C54v103Ev();
extern void _ZN6S101C54v104Ev();
extern void _ZN6S101C54v105Ev();
extern void _ZN6S101C54v106Ev();
extern void _ZN6S101C54v107Ev();
extern void _ZN6S101C54v108Ev();
extern void _ZN6S101C54v109Ev();
extern void _ZN6S101C54v110Ev();
extern void _ZN6S101C54v111Ev();
extern void _ZN6S101C54v112Ev();
extern void _ZN6S101C54v113Ev();
extern void _ZN6S101C54v114Ev();
extern void _ZN6S101C54v115Ev();
extern void _ZN6S101C54v116Ev();
extern void _ZN6S101C54v117Ev();
extern void _ZN6S101C54v118Ev();
extern void _ZN6S101C54v119Ev();
extern void _ZN6S101C54v120Ev();
extern void _ZN6S101C54v121Ev();
extern void _ZN6S101C54v122Ev();
extern void _ZN6S101C54v123Ev();
extern void _ZN6S101C54v124Ev();
extern void _ZN6S101C54v125Ev();
extern void _ZN6S101C54v126Ev();
extern void _ZN6S101C54v127Ev();
extern void _ZN6S101C54v128Ev();
extern void _ZN6S101C54v129Ev();
extern void _ZN6S101C54v130Ev();
extern void _ZN6S101C54v131Ev();
extern void _ZN6S101C54v132Ev();
extern void _ZN6S101C54v133Ev();
extern void _ZN6S101C54v134Ev();
extern void _ZN6S101C54v135Ev();
extern void _ZN6S101C54v136Ev();
extern void _ZN6S101C54v137Ev();
extern void _ZN6S101C54v138Ev();
extern void _ZN6S101C54v139Ev();
extern void _ZN6S101C54v140Ev();
extern void _ZN6S101C54v141Ev();
extern void _ZN6S101C54v142Ev();
extern void _ZN6S101C54v143Ev();
extern void _ZN6S101C54v144Ev();
extern void _ZN6S101C54v145Ev();
extern void _ZN6S101C54v146Ev();
extern void _ZN6S101C44v147Ev();
extern void _ZN6S101C44v148Ev();
extern void _ZN6S101C44v149Ev();
extern void _ZN6S101C44v150Ev();
extern void _ZN6S101C44v151Ev();
extern void _ZN6S101C44v152Ev();
extern void _ZN6S101C44v153Ev();
extern void _ZN6S101C44v154Ev();
extern void _ZN6S101C44v155Ev();
extern void _ZN6S101C44v156Ev();
extern void _ZN6S101C44v157Ev();
extern void _ZN6S101C44v158Ev();
extern void _ZN6S101C44v159Ev();
extern void _ZN6S101C44v160Ev();
extern void _ZN6S101C44v161Ev();
extern void _ZN6S101C44v162Ev();
extern void _ZN6S101C44v163Ev();
extern void _ZN6S101C44v164Ev();
extern void _ZN6S101C44v165Ev();
extern void _ZN6S101C44v166Ev();
extern void _ZN6S101C44v167Ev();
extern void _ZN6S101C44v168Ev();
extern void _ZN6S101C44v169Ev();
extern void _ZN6S101C44v170Ev();
extern void _ZN6S101C44v171Ev();
extern void _ZN6S101C44v172Ev();
extern void _ZN6S101C44v173Ev();
extern void _ZN6S101C44v174Ev();
extern void _ZN6S101C44v175Ev();
extern void _ZN6S101C44v176Ev();
extern void _ZN6S101C44v177Ev();
extern void _ZN6S101C44v178Ev();
extern void _ZN6S101C44v179Ev();
extern void _ZN6S101C44v180Ev();
extern void _ZN6S101C44v181Ev();
extern void _ZN6S101C44v182Ev();
extern void _ZN6S101C44v183Ev();
extern void _ZN6S101C44v184Ev();
extern void _ZN6S101C44v185Ev();
extern void _ZN6S101C34v186Ev();
extern void _ZN6S101C34v187Ev();
extern void _ZN6S101C34v188Ev();
extern void _ZN6S101C34v189Ev();
extern void _ZN6S101C34v190Ev();
extern void _ZN6S101C34v191Ev();
extern void _ZN6S101C34v192Ev();
extern void _ZN6S101C34v193Ev();
extern void _ZN6S101C34v194Ev();
extern void _ZN6S101C34v195Ev();
extern void _ZN6S101C34v196Ev();
extern void _ZN6S101C34v197Ev();
extern void _ZN6S101C34v198Ev();
extern void _ZN6S101C34v199Ev();
extern void _ZN6S101C34v200Ev();
extern void _ZN6S101C34v201Ev();
extern void _ZN6S101C34v202Ev();
extern void _ZN6S101C34v203Ev();
extern void _ZN6S101C34v204Ev();
extern void _ZN6S101C34v205Ev();
extern void _ZN6S101C34v206Ev();
extern void _ZN6S101C34v207Ev();
extern void _ZN6S101C34v208Ev();
static  VTBL_ENTRY vtc_S101C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C3[0]),
  (VTBL_ENTRY)&_ZN6S101C3D1Ev,
  (VTBL_ENTRY)&_ZN6S101C3D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
  (VTBL_ENTRY)&_ZN6S101C53v71Ev,
  (VTBL_ENTRY)&_ZN6S101C53v72Ev,
  (VTBL_ENTRY)&_ZN6S101C53v73Ev,
  (VTBL_ENTRY)&_ZN6S101C53v74Ev,
  (VTBL_ENTRY)&_ZN6S101C53v75Ev,
  (VTBL_ENTRY)&_ZN6S101C53v76Ev,
  (VTBL_ENTRY)&_ZN6S101C53v77Ev,
  (VTBL_ENTRY)&_ZN6S101C53v78Ev,
  (VTBL_ENTRY)&_ZN6S101C53v79Ev,
  (VTBL_ENTRY)&_ZN6S101C53v80Ev,
  (VTBL_ENTRY)&_ZN6S101C53v81Ev,
  (VTBL_ENTRY)&_ZN6S101C53v82Ev,
  (VTBL_ENTRY)&_ZN6S101C53v83Ev,
  (VTBL_ENTRY)&_ZN6S101C53v84Ev,
  (VTBL_ENTRY)&_ZN6S101C53v85Ev,
  (VTBL_ENTRY)&_ZN6S101C53v86Ev,
  (VTBL_ENTRY)&_ZN6S101C53v87Ev,
  (VTBL_ENTRY)&_ZN6S101C53v88Ev,
  (VTBL_ENTRY)&_ZN6S101C53v89Ev,
  (VTBL_ENTRY)&_ZN6S101C53v90Ev,
  (VTBL_ENTRY)&_ZN6S101C53v91Ev,
  (VTBL_ENTRY)&_ZN6S101C53v92Ev,
  (VTBL_ENTRY)&_ZN6S101C53v93Ev,
  (VTBL_ENTRY)&_ZN6S101C53v94Ev,
  (VTBL_ENTRY)&_ZN6S101C53v95Ev,
  (VTBL_ENTRY)&_ZN6S101C53v96Ev,
  (VTBL_ENTRY)&_ZN6S101C53v97Ev,
  (VTBL_ENTRY)&_ZN6S101C53v98Ev,
  (VTBL_ENTRY)&_ZN6S101C53v99Ev,
  (VTBL_ENTRY)&_ZN6S101C54v100Ev,
  (VTBL_ENTRY)&_ZN6S101C54v101Ev,
  (VTBL_ENTRY)&_ZN6S101C54v102Ev,
  (VTBL_ENTRY)&_ZN6S101C54v103Ev,
  (VTBL_ENTRY)&_ZN6S101C54v104Ev,
  (VTBL_ENTRY)&_ZN6S101C54v105Ev,
  (VTBL_ENTRY)&_ZN6S101C54v106Ev,
  (VTBL_ENTRY)&_ZN6S101C54v107Ev,
  (VTBL_ENTRY)&_ZN6S101C54v108Ev,
  (VTBL_ENTRY)&_ZN6S101C54v109Ev,
  (VTBL_ENTRY)&_ZN6S101C54v110Ev,
  (VTBL_ENTRY)&_ZN6S101C54v111Ev,
  (VTBL_ENTRY)&_ZN6S101C54v112Ev,
  (VTBL_ENTRY)&_ZN6S101C54v113Ev,
  (VTBL_ENTRY)&_ZN6S101C54v114Ev,
  (VTBL_ENTRY)&_ZN6S101C54v115Ev,
  (VTBL_ENTRY)&_ZN6S101C54v116Ev,
  (VTBL_ENTRY)&_ZN6S101C54v117Ev,
  (VTBL_ENTRY)&_ZN6S101C54v118Ev,
  (VTBL_ENTRY)&_ZN6S101C54v119Ev,
  (VTBL_ENTRY)&_ZN6S101C54v120Ev,
  (VTBL_ENTRY)&_ZN6S101C54v121Ev,
  (VTBL_ENTRY)&_ZN6S101C54v122Ev,
  (VTBL_ENTRY)&_ZN6S101C54v123Ev,
  (VTBL_ENTRY)&_ZN6S101C54v124Ev,
  (VTBL_ENTRY)&_ZN6S101C54v125Ev,
  (VTBL_ENTRY)&_ZN6S101C54v126Ev,
  (VTBL_ENTRY)&_ZN6S101C54v127Ev,
  (VTBL_ENTRY)&_ZN6S101C54v128Ev,
  (VTBL_ENTRY)&_ZN6S101C54v129Ev,
  (VTBL_ENTRY)&_ZN6S101C54v130Ev,
  (VTBL_ENTRY)&_ZN6S101C54v131Ev,
  (VTBL_ENTRY)&_ZN6S101C54v132Ev,
  (VTBL_ENTRY)&_ZN6S101C54v133Ev,
  (VTBL_ENTRY)&_ZN6S101C54v134Ev,
  (VTBL_ENTRY)&_ZN6S101C54v135Ev,
  (VTBL_ENTRY)&_ZN6S101C54v136Ev,
  (VTBL_ENTRY)&_ZN6S101C54v137Ev,
  (VTBL_ENTRY)&_ZN6S101C54v138Ev,
  (VTBL_ENTRY)&_ZN6S101C54v139Ev,
  (VTBL_ENTRY)&_ZN6S101C54v140Ev,
  (VTBL_ENTRY)&_ZN6S101C54v141Ev,
  (VTBL_ENTRY)&_ZN6S101C54v142Ev,
  (VTBL_ENTRY)&_ZN6S101C54v143Ev,
  (VTBL_ENTRY)&_ZN6S101C54v144Ev,
  (VTBL_ENTRY)&_ZN6S101C54v145Ev,
  (VTBL_ENTRY)&_ZN6S101C54v146Ev,
  (VTBL_ENTRY)&_ZN6S101C44v147Ev,
  (VTBL_ENTRY)&_ZN6S101C44v148Ev,
  (VTBL_ENTRY)&_ZN6S101C44v149Ev,
  (VTBL_ENTRY)&_ZN6S101C44v150Ev,
  (VTBL_ENTRY)&_ZN6S101C44v151Ev,
  (VTBL_ENTRY)&_ZN6S101C44v152Ev,
  (VTBL_ENTRY)&_ZN6S101C44v153Ev,
  (VTBL_ENTRY)&_ZN6S101C44v154Ev,
  (VTBL_ENTRY)&_ZN6S101C44v155Ev,
  (VTBL_ENTRY)&_ZN6S101C44v156Ev,
  (VTBL_ENTRY)&_ZN6S101C44v157Ev,
  (VTBL_ENTRY)&_ZN6S101C44v158Ev,
  (VTBL_ENTRY)&_ZN6S101C44v159Ev,
  (VTBL_ENTRY)&_ZN6S101C44v160Ev,
  (VTBL_ENTRY)&_ZN6S101C44v161Ev,
  (VTBL_ENTRY)&_ZN6S101C44v162Ev,
  (VTBL_ENTRY)&_ZN6S101C44v163Ev,
  (VTBL_ENTRY)&_ZN6S101C44v164Ev,
  (VTBL_ENTRY)&_ZN6S101C44v165Ev,
  (VTBL_ENTRY)&_ZN6S101C44v166Ev,
  (VTBL_ENTRY)&_ZN6S101C44v167Ev,
  (VTBL_ENTRY)&_ZN6S101C44v168Ev,
  (VTBL_ENTRY)&_ZN6S101C44v169Ev,
  (VTBL_ENTRY)&_ZN6S101C44v170Ev,
  (VTBL_ENTRY)&_ZN6S101C44v171Ev,
  (VTBL_ENTRY)&_ZN6S101C44v172Ev,
  (VTBL_ENTRY)&_ZN6S101C44v173Ev,
  (VTBL_ENTRY)&_ZN6S101C44v174Ev,
  (VTBL_ENTRY)&_ZN6S101C44v175Ev,
  (VTBL_ENTRY)&_ZN6S101C44v176Ev,
  (VTBL_ENTRY)&_ZN6S101C44v177Ev,
  (VTBL_ENTRY)&_ZN6S101C44v178Ev,
  (VTBL_ENTRY)&_ZN6S101C44v179Ev,
  (VTBL_ENTRY)&_ZN6S101C44v180Ev,
  (VTBL_ENTRY)&_ZN6S101C44v181Ev,
  (VTBL_ENTRY)&_ZN6S101C44v182Ev,
  (VTBL_ENTRY)&_ZN6S101C44v183Ev,
  (VTBL_ENTRY)&_ZN6S101C44v184Ev,
  (VTBL_ENTRY)&_ZN6S101C44v185Ev,
  (VTBL_ENTRY)&_ZN6S101C34v186Ev,
  (VTBL_ENTRY)&_ZN6S101C34v187Ev,
  (VTBL_ENTRY)&_ZN6S101C34v188Ev,
  (VTBL_ENTRY)&_ZN6S101C34v189Ev,
  (VTBL_ENTRY)&_ZN6S101C34v190Ev,
  (VTBL_ENTRY)&_ZN6S101C34v191Ev,
  (VTBL_ENTRY)&_ZN6S101C34v192Ev,
  (VTBL_ENTRY)&_ZN6S101C34v193Ev,
  (VTBL_ENTRY)&_ZN6S101C34v194Ev,
  (VTBL_ENTRY)&_ZN6S101C34v195Ev,
  (VTBL_ENTRY)&_ZN6S101C34v196Ev,
  (VTBL_ENTRY)&_ZN6S101C34v197Ev,
  (VTBL_ENTRY)&_ZN6S101C34v198Ev,
  (VTBL_ENTRY)&_ZN6S101C34v199Ev,
  (VTBL_ENTRY)&_ZN6S101C34v200Ev,
  (VTBL_ENTRY)&_ZN6S101C34v201Ev,
  (VTBL_ENTRY)&_ZN6S101C34v202Ev,
  (VTBL_ENTRY)&_ZN6S101C34v203Ev,
  (VTBL_ENTRY)&_ZN6S101C34v204Ev,
  (VTBL_ENTRY)&_ZN6S101C34v205Ev,
  (VTBL_ENTRY)&_ZN6S101C34v206Ev,
  (VTBL_ENTRY)&_ZN6S101C34v207Ev,
  (VTBL_ENTRY)&_ZN6S101C34v208Ev,
};
extern VTBL_ENTRY _ZTI6S101C3[];
extern  VTBL_ENTRY _ZTV6S101C3[];
Class_Descriptor cd_S101C3 = {  "S101C3", // class name
  bases_S101C3, 4,
  &(vtc_S101C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI6S101C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C2  : S101C3 {
  void *s101c2f0[2];
  int s101c2f1[2];
  char s101c2f2;
  void *s101c2f3;
  unsigned int s101c2f4:1;
  unsigned int s101c2f5:1;
  ::S80C28_nt s101c2f6;
  virtual  ~S101C2(); // _ZN6S101C2D1Ev
  virtual void  v209(); // _ZN6S101C24v209Ev
  virtual void  v210(); // _ZN6S101C24v210Ev
  virtual void  v211(); // _ZN6S101C24v211Ev
  virtual void  v212(); // _ZN6S101C24v212Ev
  virtual void  v213(); // _ZN6S101C24v213Ev
  virtual void  v214(); // _ZN6S101C24v214Ev
  virtual void  v215(); // _ZN6S101C24v215Ev
  virtual void  v216(); // _ZN6S101C24v216Ev
  S101C2(); // tgen
};
//SIG(-1 S101C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC21{ m Fi[2]}} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 FC7 Fp[9] FC22{ BC23{ BC11}} FC9 FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC21 FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC27{ BC16}}


 S101C2 ::~S101C2(){ note_dtor("S101C2", this);}
void  S101C2 ::v209(){vfunc_called(this, "_ZN6S101C24v209Ev");}
void  S101C2 ::v210(){vfunc_called(this, "_ZN6S101C24v210Ev");}
void  S101C2 ::v211(){vfunc_called(this, "_ZN6S101C24v211Ev");}
void  S101C2 ::v212(){vfunc_called(this, "_ZN6S101C24v212Ev");}
void  S101C2 ::v213(){vfunc_called(this, "_ZN6S101C24v213Ev");}
void  S101C2 ::v214(){vfunc_called(this, "_ZN6S101C24v214Ev");}
void  S101C2 ::v215(){vfunc_called(this, "_ZN6S101C24v215Ev");}
void  S101C2 ::v216(){vfunc_called(this, "_ZN6S101C24v216Ev");}
S101C2 ::S101C2(){ note_ctor("S101C2", this);} // tgen

static void Test_S101C2()
{
  extern Class_Descriptor cd_S101C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,165)];
    init_test(&cd_S101C2, buf);
    S101C2 *dp, &lv = *(dp=new (buf) S101C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,656), "sizeof(S101C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C2)");
    check_base_class_offset(lv, (S101C7*)(S101C6*)(S101C5*)(S101C4*)(S101C3*), 0, "S101C2");
    check_base_class_offset(lv, (S101C6*)(S101C5*)(S101C4*)(S101C3*), 0, "S101C2");
    check_base_class_offset(lv, (S101C5*)(S101C4*)(S101C3*), 0, "S101C2");
    check_base_class_offset(lv, (S101C4*)(S101C3*), 0, "S101C2");
    check_base_class_offset(lv, (S101C3*), 0, "S101C2");
    check_field_offset(lv, s101c2f0, ABISELECT(864,616), "S101C2.s101c2f0");
    check_field_offset(lv, s101c2f1, ABISELECT(880,624), "S101C2.s101c2f1");
    check_field_offset(lv, s101c2f2, ABISELECT(888,632), "S101C2.s101c2f2");
    check_field_offset(lv, s101c2f3, ABISELECT(896,636), "S101C2.s101c2f3");
    set_bf_and_test(lv, s101c2f4, ABISELECT(904,640), 0, 1, 1, "S101C2");
    set_bf_and_test(lv, s101c2f5, ABISELECT(904,640), 1, 1, 1, "S101C2");
    check_field_offset(lv, s101c2f6, ABISELECT(912,644), "S101C2.s101c2f6");
    test_class_info(&lv, &cd_S101C2);
    dp->~S101C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C2(Test_S101C2, "S101C2", ABISELECT(928,656));

#else // __cplusplus

extern void _ZN6S101C2C1Ev();
extern void _ZN6S101C2D1Ev();
Name_Map name_map_S101C2[] = {
  NSPAIR(_ZN6S101C2C1Ev),
  NSPAIR(_ZN6S101C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
extern Class_Descriptor cd_S101C6;
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
extern Class_Descriptor cd_S101C5;
extern VTBL_ENTRY _ZTI6S101C5[];
extern  VTBL_ENTRY _ZTV6S101C5[];
extern Class_Descriptor cd_S101C4;
extern VTBL_ENTRY _ZTI6S101C4[];
extern  VTBL_ENTRY _ZTV6S101C4[];
extern Class_Descriptor cd_S101C3;
extern VTBL_ENTRY _ZTI6S101C3[];
extern  VTBL_ENTRY _ZTV6S101C3[];
static Base_Class bases_S101C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S101C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S101C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S101C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S101C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C2[];
extern void _ZN6S101C2D1Ev();
extern void _ZN6S101C2D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
extern void _ZN6S101C53v71Ev();
extern void _ZN6S101C53v72Ev();
extern void _ZN6S101C53v73Ev();
extern void _ZN6S101C53v74Ev();
extern void _ZN6S101C53v75Ev();
extern void _ZN6S101C53v76Ev();
extern void _ZN6S101C53v77Ev();
extern void _ZN6S101C53v78Ev();
extern void _ZN6S101C53v79Ev();
extern void _ZN6S101C53v80Ev();
extern void _ZN6S101C53v81Ev();
extern void _ZN6S101C53v82Ev();
extern void _ZN6S101C53v83Ev();
extern void _ZN6S101C53v84Ev();
extern void _ZN6S101C53v85Ev();
extern void _ZN6S101C53v86Ev();
extern void _ZN6S101C53v87Ev();
extern void _ZN6S101C53v88Ev();
extern void _ZN6S101C53v89Ev();
extern void _ZN6S101C53v90Ev();
extern void _ZN6S101C53v91Ev();
extern void _ZN6S101C53v92Ev();
extern void _ZN6S101C53v93Ev();
extern void _ZN6S101C53v94Ev();
extern void _ZN6S101C53v95Ev();
extern void _ZN6S101C53v96Ev();
extern void _ZN6S101C53v97Ev();
extern void _ZN6S101C53v98Ev();
extern void _ZN6S101C53v99Ev();
extern void _ZN6S101C54v100Ev();
extern void _ZN6S101C54v101Ev();
extern void _ZN6S101C54v102Ev();
extern void _ZN6S101C54v103Ev();
extern void _ZN6S101C54v104Ev();
extern void _ZN6S101C54v105Ev();
extern void _ZN6S101C54v106Ev();
extern void _ZN6S101C54v107Ev();
extern void _ZN6S101C54v108Ev();
extern void _ZN6S101C54v109Ev();
extern void _ZN6S101C54v110Ev();
extern void _ZN6S101C54v111Ev();
extern void _ZN6S101C54v112Ev();
extern void _ZN6S101C54v113Ev();
extern void _ZN6S101C54v114Ev();
extern void _ZN6S101C54v115Ev();
extern void _ZN6S101C54v116Ev();
extern void _ZN6S101C54v117Ev();
extern void _ZN6S101C54v118Ev();
extern void _ZN6S101C54v119Ev();
extern void _ZN6S101C54v120Ev();
extern void _ZN6S101C54v121Ev();
extern void _ZN6S101C54v122Ev();
extern void _ZN6S101C54v123Ev();
extern void _ZN6S101C54v124Ev();
extern void _ZN6S101C54v125Ev();
extern void _ZN6S101C54v126Ev();
extern void _ZN6S101C54v127Ev();
extern void _ZN6S101C54v128Ev();
extern void _ZN6S101C54v129Ev();
extern void _ZN6S101C54v130Ev();
extern void _ZN6S101C54v131Ev();
extern void _ZN6S101C54v132Ev();
extern void _ZN6S101C54v133Ev();
extern void _ZN6S101C54v134Ev();
extern void _ZN6S101C54v135Ev();
extern void _ZN6S101C54v136Ev();
extern void _ZN6S101C54v137Ev();
extern void _ZN6S101C54v138Ev();
extern void _ZN6S101C54v139Ev();
extern void _ZN6S101C54v140Ev();
extern void _ZN6S101C54v141Ev();
extern void _ZN6S101C54v142Ev();
extern void _ZN6S101C54v143Ev();
extern void _ZN6S101C54v144Ev();
extern void _ZN6S101C54v145Ev();
extern void _ZN6S101C54v146Ev();
extern void _ZN6S101C44v147Ev();
extern void _ZN6S101C44v148Ev();
extern void _ZN6S101C44v149Ev();
extern void _ZN6S101C44v150Ev();
extern void _ZN6S101C44v151Ev();
extern void _ZN6S101C44v152Ev();
extern void _ZN6S101C44v153Ev();
extern void _ZN6S101C44v154Ev();
extern void _ZN6S101C44v155Ev();
extern void _ZN6S101C44v156Ev();
extern void _ZN6S101C44v157Ev();
extern void _ZN6S101C44v158Ev();
extern void _ZN6S101C44v159Ev();
extern void _ZN6S101C44v160Ev();
extern void _ZN6S101C44v161Ev();
extern void _ZN6S101C44v162Ev();
extern void _ZN6S101C44v163Ev();
extern void _ZN6S101C44v164Ev();
extern void _ZN6S101C44v165Ev();
extern void _ZN6S101C44v166Ev();
extern void _ZN6S101C44v167Ev();
extern void _ZN6S101C44v168Ev();
extern void _ZN6S101C44v169Ev();
extern void _ZN6S101C44v170Ev();
extern void _ZN6S101C44v171Ev();
extern void _ZN6S101C44v172Ev();
extern void _ZN6S101C44v173Ev();
extern void _ZN6S101C44v174Ev();
extern void _ZN6S101C44v175Ev();
extern void _ZN6S101C44v176Ev();
extern void _ZN6S101C44v177Ev();
extern void _ZN6S101C44v178Ev();
extern void _ZN6S101C44v179Ev();
extern void _ZN6S101C44v180Ev();
extern void _ZN6S101C44v181Ev();
extern void _ZN6S101C44v182Ev();
extern void _ZN6S101C44v183Ev();
extern void _ZN6S101C44v184Ev();
extern void _ZN6S101C44v185Ev();
extern void _ZN6S101C34v186Ev();
extern void _ZN6S101C34v187Ev();
extern void _ZN6S101C34v188Ev();
extern void _ZN6S101C34v189Ev();
extern void _ZN6S101C34v190Ev();
extern void _ZN6S101C34v191Ev();
extern void _ZN6S101C34v192Ev();
extern void _ZN6S101C34v193Ev();
extern void _ZN6S101C34v194Ev();
extern void _ZN6S101C34v195Ev();
extern void _ZN6S101C34v196Ev();
extern void _ZN6S101C34v197Ev();
extern void _ZN6S101C34v198Ev();
extern void _ZN6S101C34v199Ev();
extern void _ZN6S101C34v200Ev();
extern void _ZN6S101C34v201Ev();
extern void _ZN6S101C34v202Ev();
extern void _ZN6S101C34v203Ev();
extern void _ZN6S101C34v204Ev();
extern void _ZN6S101C34v205Ev();
extern void _ZN6S101C34v206Ev();
extern void _ZN6S101C34v207Ev();
extern void _ZN6S101C34v208Ev();
extern void _ZN6S101C24v209Ev();
extern void _ZN6S101C24v210Ev();
extern void _ZN6S101C24v211Ev();
extern void _ZN6S101C24v212Ev();
extern void _ZN6S101C24v213Ev();
extern void _ZN6S101C24v214Ev();
extern void _ZN6S101C24v215Ev();
extern void _ZN6S101C24v216Ev();
static  VTBL_ENTRY vtc_S101C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C2[0]),
  (VTBL_ENTRY)&_ZN6S101C2D1Ev,
  (VTBL_ENTRY)&_ZN6S101C2D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
  (VTBL_ENTRY)&_ZN6S101C53v71Ev,
  (VTBL_ENTRY)&_ZN6S101C53v72Ev,
  (VTBL_ENTRY)&_ZN6S101C53v73Ev,
  (VTBL_ENTRY)&_ZN6S101C53v74Ev,
  (VTBL_ENTRY)&_ZN6S101C53v75Ev,
  (VTBL_ENTRY)&_ZN6S101C53v76Ev,
  (VTBL_ENTRY)&_ZN6S101C53v77Ev,
  (VTBL_ENTRY)&_ZN6S101C53v78Ev,
  (VTBL_ENTRY)&_ZN6S101C53v79Ev,
  (VTBL_ENTRY)&_ZN6S101C53v80Ev,
  (VTBL_ENTRY)&_ZN6S101C53v81Ev,
  (VTBL_ENTRY)&_ZN6S101C53v82Ev,
  (VTBL_ENTRY)&_ZN6S101C53v83Ev,
  (VTBL_ENTRY)&_ZN6S101C53v84Ev,
  (VTBL_ENTRY)&_ZN6S101C53v85Ev,
  (VTBL_ENTRY)&_ZN6S101C53v86Ev,
  (VTBL_ENTRY)&_ZN6S101C53v87Ev,
  (VTBL_ENTRY)&_ZN6S101C53v88Ev,
  (VTBL_ENTRY)&_ZN6S101C53v89Ev,
  (VTBL_ENTRY)&_ZN6S101C53v90Ev,
  (VTBL_ENTRY)&_ZN6S101C53v91Ev,
  (VTBL_ENTRY)&_ZN6S101C53v92Ev,
  (VTBL_ENTRY)&_ZN6S101C53v93Ev,
  (VTBL_ENTRY)&_ZN6S101C53v94Ev,
  (VTBL_ENTRY)&_ZN6S101C53v95Ev,
  (VTBL_ENTRY)&_ZN6S101C53v96Ev,
  (VTBL_ENTRY)&_ZN6S101C53v97Ev,
  (VTBL_ENTRY)&_ZN6S101C53v98Ev,
  (VTBL_ENTRY)&_ZN6S101C53v99Ev,
  (VTBL_ENTRY)&_ZN6S101C54v100Ev,
  (VTBL_ENTRY)&_ZN6S101C54v101Ev,
  (VTBL_ENTRY)&_ZN6S101C54v102Ev,
  (VTBL_ENTRY)&_ZN6S101C54v103Ev,
  (VTBL_ENTRY)&_ZN6S101C54v104Ev,
  (VTBL_ENTRY)&_ZN6S101C54v105Ev,
  (VTBL_ENTRY)&_ZN6S101C54v106Ev,
  (VTBL_ENTRY)&_ZN6S101C54v107Ev,
  (VTBL_ENTRY)&_ZN6S101C54v108Ev,
  (VTBL_ENTRY)&_ZN6S101C54v109Ev,
  (VTBL_ENTRY)&_ZN6S101C54v110Ev,
  (VTBL_ENTRY)&_ZN6S101C54v111Ev,
  (VTBL_ENTRY)&_ZN6S101C54v112Ev,
  (VTBL_ENTRY)&_ZN6S101C54v113Ev,
  (VTBL_ENTRY)&_ZN6S101C54v114Ev,
  (VTBL_ENTRY)&_ZN6S101C54v115Ev,
  (VTBL_ENTRY)&_ZN6S101C54v116Ev,
  (VTBL_ENTRY)&_ZN6S101C54v117Ev,
  (VTBL_ENTRY)&_ZN6S101C54v118Ev,
  (VTBL_ENTRY)&_ZN6S101C54v119Ev,
  (VTBL_ENTRY)&_ZN6S101C54v120Ev,
  (VTBL_ENTRY)&_ZN6S101C54v121Ev,
  (VTBL_ENTRY)&_ZN6S101C54v122Ev,
  (VTBL_ENTRY)&_ZN6S101C54v123Ev,
  (VTBL_ENTRY)&_ZN6S101C54v124Ev,
  (VTBL_ENTRY)&_ZN6S101C54v125Ev,
  (VTBL_ENTRY)&_ZN6S101C54v126Ev,
  (VTBL_ENTRY)&_ZN6S101C54v127Ev,
  (VTBL_ENTRY)&_ZN6S101C54v128Ev,
  (VTBL_ENTRY)&_ZN6S101C54v129Ev,
  (VTBL_ENTRY)&_ZN6S101C54v130Ev,
  (VTBL_ENTRY)&_ZN6S101C54v131Ev,
  (VTBL_ENTRY)&_ZN6S101C54v132Ev,
  (VTBL_ENTRY)&_ZN6S101C54v133Ev,
  (VTBL_ENTRY)&_ZN6S101C54v134Ev,
  (VTBL_ENTRY)&_ZN6S101C54v135Ev,
  (VTBL_ENTRY)&_ZN6S101C54v136Ev,
  (VTBL_ENTRY)&_ZN6S101C54v137Ev,
  (VTBL_ENTRY)&_ZN6S101C54v138Ev,
  (VTBL_ENTRY)&_ZN6S101C54v139Ev,
  (VTBL_ENTRY)&_ZN6S101C54v140Ev,
  (VTBL_ENTRY)&_ZN6S101C54v141Ev,
  (VTBL_ENTRY)&_ZN6S101C54v142Ev,
  (VTBL_ENTRY)&_ZN6S101C54v143Ev,
  (VTBL_ENTRY)&_ZN6S101C54v144Ev,
  (VTBL_ENTRY)&_ZN6S101C54v145Ev,
  (VTBL_ENTRY)&_ZN6S101C54v146Ev,
  (VTBL_ENTRY)&_ZN6S101C44v147Ev,
  (VTBL_ENTRY)&_ZN6S101C44v148Ev,
  (VTBL_ENTRY)&_ZN6S101C44v149Ev,
  (VTBL_ENTRY)&_ZN6S101C44v150Ev,
  (VTBL_ENTRY)&_ZN6S101C44v151Ev,
  (VTBL_ENTRY)&_ZN6S101C44v152Ev,
  (VTBL_ENTRY)&_ZN6S101C44v153Ev,
  (VTBL_ENTRY)&_ZN6S101C44v154Ev,
  (VTBL_ENTRY)&_ZN6S101C44v155Ev,
  (VTBL_ENTRY)&_ZN6S101C44v156Ev,
  (VTBL_ENTRY)&_ZN6S101C44v157Ev,
  (VTBL_ENTRY)&_ZN6S101C44v158Ev,
  (VTBL_ENTRY)&_ZN6S101C44v159Ev,
  (VTBL_ENTRY)&_ZN6S101C44v160Ev,
  (VTBL_ENTRY)&_ZN6S101C44v161Ev,
  (VTBL_ENTRY)&_ZN6S101C44v162Ev,
  (VTBL_ENTRY)&_ZN6S101C44v163Ev,
  (VTBL_ENTRY)&_ZN6S101C44v164Ev,
  (VTBL_ENTRY)&_ZN6S101C44v165Ev,
  (VTBL_ENTRY)&_ZN6S101C44v166Ev,
  (VTBL_ENTRY)&_ZN6S101C44v167Ev,
  (VTBL_ENTRY)&_ZN6S101C44v168Ev,
  (VTBL_ENTRY)&_ZN6S101C44v169Ev,
  (VTBL_ENTRY)&_ZN6S101C44v170Ev,
  (VTBL_ENTRY)&_ZN6S101C44v171Ev,
  (VTBL_ENTRY)&_ZN6S101C44v172Ev,
  (VTBL_ENTRY)&_ZN6S101C44v173Ev,
  (VTBL_ENTRY)&_ZN6S101C44v174Ev,
  (VTBL_ENTRY)&_ZN6S101C44v175Ev,
  (VTBL_ENTRY)&_ZN6S101C44v176Ev,
  (VTBL_ENTRY)&_ZN6S101C44v177Ev,
  (VTBL_ENTRY)&_ZN6S101C44v178Ev,
  (VTBL_ENTRY)&_ZN6S101C44v179Ev,
  (VTBL_ENTRY)&_ZN6S101C44v180Ev,
  (VTBL_ENTRY)&_ZN6S101C44v181Ev,
  (VTBL_ENTRY)&_ZN6S101C44v182Ev,
  (VTBL_ENTRY)&_ZN6S101C44v183Ev,
  (VTBL_ENTRY)&_ZN6S101C44v184Ev,
  (VTBL_ENTRY)&_ZN6S101C44v185Ev,
  (VTBL_ENTRY)&_ZN6S101C34v186Ev,
  (VTBL_ENTRY)&_ZN6S101C34v187Ev,
  (VTBL_ENTRY)&_ZN6S101C34v188Ev,
  (VTBL_ENTRY)&_ZN6S101C34v189Ev,
  (VTBL_ENTRY)&_ZN6S101C34v190Ev,
  (VTBL_ENTRY)&_ZN6S101C34v191Ev,
  (VTBL_ENTRY)&_ZN6S101C34v192Ev,
  (VTBL_ENTRY)&_ZN6S101C34v193Ev,
  (VTBL_ENTRY)&_ZN6S101C34v194Ev,
  (VTBL_ENTRY)&_ZN6S101C34v195Ev,
  (VTBL_ENTRY)&_ZN6S101C34v196Ev,
  (VTBL_ENTRY)&_ZN6S101C34v197Ev,
  (VTBL_ENTRY)&_ZN6S101C34v198Ev,
  (VTBL_ENTRY)&_ZN6S101C34v199Ev,
  (VTBL_ENTRY)&_ZN6S101C34v200Ev,
  (VTBL_ENTRY)&_ZN6S101C34v201Ev,
  (VTBL_ENTRY)&_ZN6S101C34v202Ev,
  (VTBL_ENTRY)&_ZN6S101C34v203Ev,
  (VTBL_ENTRY)&_ZN6S101C34v204Ev,
  (VTBL_ENTRY)&_ZN6S101C34v205Ev,
  (VTBL_ENTRY)&_ZN6S101C34v206Ev,
  (VTBL_ENTRY)&_ZN6S101C34v207Ev,
  (VTBL_ENTRY)&_ZN6S101C34v208Ev,
  (VTBL_ENTRY)&_ZN6S101C24v209Ev,
  (VTBL_ENTRY)&_ZN6S101C24v210Ev,
  (VTBL_ENTRY)&_ZN6S101C24v211Ev,
  (VTBL_ENTRY)&_ZN6S101C24v212Ev,
  (VTBL_ENTRY)&_ZN6S101C24v213Ev,
  (VTBL_ENTRY)&_ZN6S101C24v214Ev,
  (VTBL_ENTRY)&_ZN6S101C24v215Ev,
  (VTBL_ENTRY)&_ZN6S101C24v216Ev,
};
extern VTBL_ENTRY _ZTI6S101C2[];
extern  VTBL_ENTRY _ZTV6S101C2[];
Class_Descriptor cd_S101C2 = {  "S101C2", // class name
  bases_S101C2, 5,
  &(vtc_S101C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,656), // object size
  NSPAIRA(_ZTI6S101C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C2),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S101C1  : S101C2 {
  void *s101c1f0[6];
  ::S85C22_nt s101c1f1;
  int s101c1f2;
  ::S80C10_nt s101c1f3;
  void *s101c1f4[4];
  char s101c1f5;
  int s101c1f6;
  ::S80C21_nt s101c1f7;
  virtual  ~S101C1(); // _ZN6S101C1D1Ev
  virtual void  v1(); // _ZN6S101C12v1Ev
  virtual void  v2(); // _ZN6S101C12v2Ev
  virtual void  v3(); // _ZN6S101C12v3Ev
  virtual void  v4(); // _ZN6S101C12v4Ev
  S101C1(); // tgen
};
//SIG(1 S101C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v69 v70} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC22{ m Fi[2]}} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 FC8 Fp[9] FC23{ BC24{ BC12}} FC10 FC25{ BC26{ m FC27{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC22 FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v209 v210 v211 v212 v213 v214 v215 v216 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC28{ BC17}} vd v1 v2 v3 v4 Fp[6] FC13 Fi FC29{ BC30{ BC12}} Fp[4] Fc Fi FC21}


 S101C1 ::~S101C1(){ note_dtor("S101C1", this);}
void  S101C1 ::v1(){vfunc_called(this, "_ZN6S101C12v1Ev");}
void  S101C1 ::v2(){vfunc_called(this, "_ZN6S101C12v2Ev");}
void  S101C1 ::v3(){vfunc_called(this, "_ZN6S101C12v3Ev");}
void  S101C1 ::v4(){vfunc_called(this, "_ZN6S101C12v4Ev");}
S101C1 ::S101C1(){ note_ctor("S101C1", this);} // tgen

static void Test_S101C1()
{
  extern Class_Descriptor cd_S101C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(135,187)];
    init_test(&cd_S101C1, buf);
    S101C1 *dp, &lv = *(dp=new (buf) S101C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1072,744), "sizeof(S101C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S101C1)");
    check_base_class_offset(lv, (S101C7*)(S101C6*)(S101C5*)(S101C4*)(S101C3*)(S101C2*), 0, "S101C1");
    check_base_class_offset(lv, (S101C6*)(S101C5*)(S101C4*)(S101C3*)(S101C2*), 0, "S101C1");
    check_base_class_offset(lv, (S101C5*)(S101C4*)(S101C3*)(S101C2*), 0, "S101C1");
    check_base_class_offset(lv, (S101C4*)(S101C3*)(S101C2*), 0, "S101C1");
    check_base_class_offset(lv, (S101C3*)(S101C2*), 0, "S101C1");
    check_base_class_offset(lv, (S101C2*), 0, "S101C1");
    check_field_offset(lv, s101c1f0, ABISELECT(928,656), "S101C1.s101c1f0");
    check_field_offset(lv, s101c1f1, ABISELECT(976,680), "S101C1.s101c1f1");
    check_field_offset(lv, s101c1f2, ABISELECT(992,692), "S101C1.s101c1f2");
    check_field_offset(lv, s101c1f3, ABISELECT(1000,696), "S101C1.s101c1f3");
    check_field_offset(lv, s101c1f4, ABISELECT(1016,708), "S101C1.s101c1f4");
    check_field_offset(lv, s101c1f5, ABISELECT(1048,724), "S101C1.s101c1f5");
    check_field_offset(lv, s101c1f6, ABISELECT(1052,728), "S101C1.s101c1f6");
    check_field_offset(lv, s101c1f7, ABISELECT(1056,732), "S101C1.s101c1f7");
    test_class_info(&lv, &cd_S101C1);
    dp->~S101C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS101C1(Test_S101C1, "S101C1", ABISELECT(1072,744));

#else // __cplusplus

extern void _ZN6S101C1C1Ev();
extern void _ZN6S101C1D1Ev();
Name_Map name_map_S101C1[] = {
  NSPAIR(_ZN6S101C1C1Ev),
  NSPAIR(_ZN6S101C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S101C7;
extern VTBL_ENTRY _ZTI6S101C7[];
extern  VTBL_ENTRY _ZTV6S101C7[];
extern Class_Descriptor cd_S101C6;
extern VTBL_ENTRY _ZTI6S101C6[];
extern  VTBL_ENTRY _ZTV6S101C6[];
extern Class_Descriptor cd_S101C5;
extern VTBL_ENTRY _ZTI6S101C5[];
extern  VTBL_ENTRY _ZTV6S101C5[];
extern Class_Descriptor cd_S101C4;
extern VTBL_ENTRY _ZTI6S101C4[];
extern  VTBL_ENTRY _ZTV6S101C4[];
extern Class_Descriptor cd_S101C3;
extern VTBL_ENTRY _ZTI6S101C3[];
extern  VTBL_ENTRY _ZTV6S101C3[];
extern Class_Descriptor cd_S101C2;
extern VTBL_ENTRY _ZTI6S101C2[];
extern  VTBL_ENTRY _ZTV6S101C2[];
static Base_Class bases_S101C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S101C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S101C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S101C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S101C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S101C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S101C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S101C1[];
extern void _ZN6S101C1D1Ev();
extern void _ZN6S101C1D0Ev();
extern void _ZN6S101C72v5Ev();
extern void _ZN6S101C72v6Ev();
extern void _ZN6S101C72v7Ev();
extern void _ZN6S101C72v8Ev();
extern void _ZN6S101C72v9Ev();
extern void _ZN6S101C73v10Ev();
extern void _ZN6S101C73v11Ev();
extern void _ZN6S101C73v12Ev();
extern void _ZN6S101C73v13Ev();
extern void _ZN6S101C73v14Ev();
extern void _ZN6S101C73v15Ev();
extern void _ZN6S101C73v16Ev();
extern void _ZN6S101C73v17Ev();
extern void _ZN6S101C73v18Ev();
extern void _ZN6S101C73v19Ev();
extern void _ZN6S101C73v20Ev();
extern void _ZN6S101C73v21Ev();
extern void _ZN6S101C73v22Ev();
extern void _ZN6S101C73v23Ev();
extern void _ZN6S101C73v24Ev();
extern void _ZN6S101C73v25Ev();
extern void _ZN6S101C73v26Ev();
extern void _ZN6S101C73v27Ev();
extern void _ZN6S101C73v28Ev();
extern void _ZN6S101C73v29Ev();
extern void _ZN6S101C73v30Ev();
extern void _ZN6S101C73v31Ev();
extern void _ZN6S101C73v32Ev();
extern void _ZN6S101C73v33Ev();
extern void _ZN6S101C73v34Ev();
extern void _ZN6S101C73v35Ev();
extern void _ZN6S101C73v36Ev();
extern void _ZN6S101C73v37Ev();
extern void _ZN6S101C73v38Ev();
extern void _ZN6S101C73v39Ev();
extern void _ZN6S101C73v40Ev();
extern void _ZN6S101C73v41Ev();
extern void _ZN6S101C73v42Ev();
extern void _ZN6S101C73v43Ev();
extern void _ZN6S101C73v44Ev();
extern void _ZN6S101C73v45Ev();
extern void _ZN6S101C73v46Ev();
extern void _ZN6S101C73v47Ev();
extern void _ZN6S101C73v48Ev();
extern void _ZN6S101C73v49Ev();
extern void _ZN6S101C73v50Ev();
extern void _ZN6S101C73v51Ev();
extern void _ZN6S101C73v52Ev();
extern void _ZN6S101C73v53Ev();
extern void _ZN6S101C73v54Ev();
extern void _ZN6S101C73v55Ev();
extern void _ZN6S101C73v56Ev();
extern void _ZN6S101C73v57Ev();
extern void _ZN6S101C73v58Ev();
extern void _ZN6S101C73v59Ev();
extern void _ZN6S101C73v60Ev();
extern void _ZN6S101C73v61Ev();
extern void _ZN6S101C73v62Ev();
extern void _ZN6S101C73v63Ev();
extern void _ZN6S101C73v64Ev();
extern void _ZN6S101C73v65Ev();
extern void _ZN6S101C73v66Ev();
extern void _ZN6S101C73v67Ev();
extern void _ZN6S101C73v68Ev();
extern void _ZN6S101C63v69Ev();
extern void _ZN6S101C63v70Ev();
extern void _ZN6S101C53v71Ev();
extern void _ZN6S101C53v72Ev();
extern void _ZN6S101C53v73Ev();
extern void _ZN6S101C53v74Ev();
extern void _ZN6S101C53v75Ev();
extern void _ZN6S101C53v76Ev();
extern void _ZN6S101C53v77Ev();
extern void _ZN6S101C53v78Ev();
extern void _ZN6S101C53v79Ev();
extern void _ZN6S101C53v80Ev();
extern void _ZN6S101C53v81Ev();
extern void _ZN6S101C53v82Ev();
extern void _ZN6S101C53v83Ev();
extern void _ZN6S101C53v84Ev();
extern void _ZN6S101C53v85Ev();
extern void _ZN6S101C53v86Ev();
extern void _ZN6S101C53v87Ev();
extern void _ZN6S101C53v88Ev();
extern void _ZN6S101C53v89Ev();
extern void _ZN6S101C53v90Ev();
extern void _ZN6S101C53v91Ev();
extern void _ZN6S101C53v92Ev();
extern void _ZN6S101C53v93Ev();
extern void _ZN6S101C53v94Ev();
extern void _ZN6S101C53v95Ev();
extern void _ZN6S101C53v96Ev();
extern void _ZN6S101C53v97Ev();
extern void _ZN6S101C53v98Ev();
extern void _ZN6S101C53v99Ev();
extern void _ZN6S101C54v100Ev();
extern void _ZN6S101C54v101Ev();
extern void _ZN6S101C54v102Ev();
extern void _ZN6S101C54v103Ev();
extern void _ZN6S101C54v104Ev();
extern void _ZN6S101C54v105Ev();
extern void _ZN6S101C54v106Ev();
extern void _ZN6S101C54v107Ev();
extern void _ZN6S101C54v108Ev();
extern void _ZN6S101C54v109Ev();
extern void _ZN6S101C54v110Ev();
extern void _ZN6S101C54v111Ev();
extern void _ZN6S101C54v112Ev();
extern void _ZN6S101C54v113Ev();
extern void _ZN6S101C54v114Ev();
extern void _ZN6S101C54v115Ev();
extern void _ZN6S101C54v116Ev();
extern void _ZN6S101C54v117Ev();
extern void _ZN6S101C54v118Ev();
extern void _ZN6S101C54v119Ev();
extern void _ZN6S101C54v120Ev();
extern void _ZN6S101C54v121Ev();
extern void _ZN6S101C54v122Ev();
extern void _ZN6S101C54v123Ev();
extern void _ZN6S101C54v124Ev();
extern void _ZN6S101C54v125Ev();
extern void _ZN6S101C54v126Ev();
extern void _ZN6S101C54v127Ev();
extern void _ZN6S101C54v128Ev();
extern void _ZN6S101C54v129Ev();
extern void _ZN6S101C54v130Ev();
extern void _ZN6S101C54v131Ev();
extern void _ZN6S101C54v132Ev();
extern void _ZN6S101C54v133Ev();
extern void _ZN6S101C54v134Ev();
extern void _ZN6S101C54v135Ev();
extern void _ZN6S101C54v136Ev();
extern void _ZN6S101C54v137Ev();
extern void _ZN6S101C54v138Ev();
extern void _ZN6S101C54v139Ev();
extern void _ZN6S101C54v140Ev();
extern void _ZN6S101C54v141Ev();
extern void _ZN6S101C54v142Ev();
extern void _ZN6S101C54v143Ev();
extern void _ZN6S101C54v144Ev();
extern void _ZN6S101C54v145Ev();
extern void _ZN6S101C54v146Ev();
extern void _ZN6S101C44v147Ev();
extern void _ZN6S101C44v148Ev();
extern void _ZN6S101C44v149Ev();
extern void _ZN6S101C44v150Ev();
extern void _ZN6S101C44v151Ev();
extern void _ZN6S101C44v152Ev();
extern void _ZN6S101C44v153Ev();
extern void _ZN6S101C44v154Ev();
extern void _ZN6S101C44v155Ev();
extern void _ZN6S101C44v156Ev();
extern void _ZN6S101C44v157Ev();
extern void _ZN6S101C44v158Ev();
extern void _ZN6S101C44v159Ev();
extern void _ZN6S101C44v160Ev();
extern void _ZN6S101C44v161Ev();
extern void _ZN6S101C44v162Ev();
extern void _ZN6S101C44v163Ev();
extern void _ZN6S101C44v164Ev();
extern void _ZN6S101C44v165Ev();
extern void _ZN6S101C44v166Ev();
extern void _ZN6S101C44v167Ev();
extern void _ZN6S101C44v168Ev();
extern void _ZN6S101C44v169Ev();
extern void _ZN6S101C44v170Ev();
extern void _ZN6S101C44v171Ev();
extern void _ZN6S101C44v172Ev();
extern void _ZN6S101C44v173Ev();
extern void _ZN6S101C44v174Ev();
extern void _ZN6S101C44v175Ev();
extern void _ZN6S101C44v176Ev();
extern void _ZN6S101C44v177Ev();
extern void _ZN6S101C44v178Ev();
extern void _ZN6S101C44v179Ev();
extern void _ZN6S101C44v180Ev();
extern void _ZN6S101C44v181Ev();
extern void _ZN6S101C44v182Ev();
extern void _ZN6S101C44v183Ev();
extern void _ZN6S101C44v184Ev();
extern void _ZN6S101C44v185Ev();
extern void _ZN6S101C34v186Ev();
extern void _ZN6S101C34v187Ev();
extern void _ZN6S101C34v188Ev();
extern void _ZN6S101C34v189Ev();
extern void _ZN6S101C34v190Ev();
extern void _ZN6S101C34v191Ev();
extern void _ZN6S101C34v192Ev();
extern void _ZN6S101C34v193Ev();
extern void _ZN6S101C34v194Ev();
extern void _ZN6S101C34v195Ev();
extern void _ZN6S101C34v196Ev();
extern void _ZN6S101C34v197Ev();
extern void _ZN6S101C34v198Ev();
extern void _ZN6S101C34v199Ev();
extern void _ZN6S101C34v200Ev();
extern void _ZN6S101C34v201Ev();
extern void _ZN6S101C34v202Ev();
extern void _ZN6S101C34v203Ev();
extern void _ZN6S101C34v204Ev();
extern void _ZN6S101C34v205Ev();
extern void _ZN6S101C34v206Ev();
extern void _ZN6S101C34v207Ev();
extern void _ZN6S101C34v208Ev();
extern void _ZN6S101C24v209Ev();
extern void _ZN6S101C24v210Ev();
extern void _ZN6S101C24v211Ev();
extern void _ZN6S101C24v212Ev();
extern void _ZN6S101C24v213Ev();
extern void _ZN6S101C24v214Ev();
extern void _ZN6S101C24v215Ev();
extern void _ZN6S101C24v216Ev();
extern void _ZN6S101C12v1Ev();
extern void _ZN6S101C12v2Ev();
extern void _ZN6S101C12v3Ev();
extern void _ZN6S101C12v4Ev();
static  VTBL_ENTRY vtc_S101C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S101C1[0]),
  (VTBL_ENTRY)&_ZN6S101C1D1Ev,
  (VTBL_ENTRY)&_ZN6S101C1D0Ev,
  (VTBL_ENTRY)&_ZN6S101C72v5Ev,
  (VTBL_ENTRY)&_ZN6S101C72v6Ev,
  (VTBL_ENTRY)&_ZN6S101C72v7Ev,
  (VTBL_ENTRY)&_ZN6S101C72v8Ev,
  (VTBL_ENTRY)&_ZN6S101C72v9Ev,
  (VTBL_ENTRY)&_ZN6S101C73v10Ev,
  (VTBL_ENTRY)&_ZN6S101C73v11Ev,
  (VTBL_ENTRY)&_ZN6S101C73v12Ev,
  (VTBL_ENTRY)&_ZN6S101C73v13Ev,
  (VTBL_ENTRY)&_ZN6S101C73v14Ev,
  (VTBL_ENTRY)&_ZN6S101C73v15Ev,
  (VTBL_ENTRY)&_ZN6S101C73v16Ev,
  (VTBL_ENTRY)&_ZN6S101C73v17Ev,
  (VTBL_ENTRY)&_ZN6S101C73v18Ev,
  (VTBL_ENTRY)&_ZN6S101C73v19Ev,
  (VTBL_ENTRY)&_ZN6S101C73v20Ev,
  (VTBL_ENTRY)&_ZN6S101C73v21Ev,
  (VTBL_ENTRY)&_ZN6S101C73v22Ev,
  (VTBL_ENTRY)&_ZN6S101C73v23Ev,
  (VTBL_ENTRY)&_ZN6S101C73v24Ev,
  (VTBL_ENTRY)&_ZN6S101C73v25Ev,
  (VTBL_ENTRY)&_ZN6S101C73v26Ev,
  (VTBL_ENTRY)&_ZN6S101C73v27Ev,
  (VTBL_ENTRY)&_ZN6S101C73v28Ev,
  (VTBL_ENTRY)&_ZN6S101C73v29Ev,
  (VTBL_ENTRY)&_ZN6S101C73v30Ev,
  (VTBL_ENTRY)&_ZN6S101C73v31Ev,
  (VTBL_ENTRY)&_ZN6S101C73v32Ev,
  (VTBL_ENTRY)&_ZN6S101C73v33Ev,
  (VTBL_ENTRY)&_ZN6S101C73v34Ev,
  (VTBL_ENTRY)&_ZN6S101C73v35Ev,
  (VTBL_ENTRY)&_ZN6S101C73v36Ev,
  (VTBL_ENTRY)&_ZN6S101C73v37Ev,
  (VTBL_ENTRY)&_ZN6S101C73v38Ev,
  (VTBL_ENTRY)&_ZN6S101C73v39Ev,
  (VTBL_ENTRY)&_ZN6S101C73v40Ev,
  (VTBL_ENTRY)&_ZN6S101C73v41Ev,
  (VTBL_ENTRY)&_ZN6S101C73v42Ev,
  (VTBL_ENTRY)&_ZN6S101C73v43Ev,
  (VTBL_ENTRY)&_ZN6S101C73v44Ev,
  (VTBL_ENTRY)&_ZN6S101C73v45Ev,
  (VTBL_ENTRY)&_ZN6S101C73v46Ev,
  (VTBL_ENTRY)&_ZN6S101C73v47Ev,
  (VTBL_ENTRY)&_ZN6S101C73v48Ev,
  (VTBL_ENTRY)&_ZN6S101C73v49Ev,
  (VTBL_ENTRY)&_ZN6S101C73v50Ev,
  (VTBL_ENTRY)&_ZN6S101C73v51Ev,
  (VTBL_ENTRY)&_ZN6S101C73v52Ev,
  (VTBL_ENTRY)&_ZN6S101C73v53Ev,
  (VTBL_ENTRY)&_ZN6S101C73v54Ev,
  (VTBL_ENTRY)&_ZN6S101C73v55Ev,
  (VTBL_ENTRY)&_ZN6S101C73v56Ev,
  (VTBL_ENTRY)&_ZN6S101C73v57Ev,
  (VTBL_ENTRY)&_ZN6S101C73v58Ev,
  (VTBL_ENTRY)&_ZN6S101C73v59Ev,
  (VTBL_ENTRY)&_ZN6S101C73v60Ev,
  (VTBL_ENTRY)&_ZN6S101C73v61Ev,
  (VTBL_ENTRY)&_ZN6S101C73v62Ev,
  (VTBL_ENTRY)&_ZN6S101C73v63Ev,
  (VTBL_ENTRY)&_ZN6S101C73v64Ev,
  (VTBL_ENTRY)&_ZN6S101C73v65Ev,
  (VTBL_ENTRY)&_ZN6S101C73v66Ev,
  (VTBL_ENTRY)&_ZN6S101C73v67Ev,
  (VTBL_ENTRY)&_ZN6S101C73v68Ev,
  (VTBL_ENTRY)&_ZN6S101C63v69Ev,
  (VTBL_ENTRY)&_ZN6S101C63v70Ev,
  (VTBL_ENTRY)&_ZN6S101C53v71Ev,
  (VTBL_ENTRY)&_ZN6S101C53v72Ev,
  (VTBL_ENTRY)&_ZN6S101C53v73Ev,
  (VTBL_ENTRY)&_ZN6S101C53v74Ev,
  (VTBL_ENTRY)&_ZN6S101C53v75Ev,
  (VTBL_ENTRY)&_ZN6S101C53v76Ev,
  (VTBL_ENTRY)&_ZN6S101C53v77Ev,
  (VTBL_ENTRY)&_ZN6S101C53v78Ev,
  (VTBL_ENTRY)&_ZN6S101C53v79Ev,
  (VTBL_ENTRY)&_ZN6S101C53v80Ev,
  (VTBL_ENTRY)&_ZN6S101C53v81Ev,
  (VTBL_ENTRY)&_ZN6S101C53v82Ev,
  (VTBL_ENTRY)&_ZN6S101C53v83Ev,
  (VTBL_ENTRY)&_ZN6S101C53v84Ev,
  (VTBL_ENTRY)&_ZN6S101C53v85Ev,
  (VTBL_ENTRY)&_ZN6S101C53v86Ev,
  (VTBL_ENTRY)&_ZN6S101C53v87Ev,
  (VTBL_ENTRY)&_ZN6S101C53v88Ev,
  (VTBL_ENTRY)&_ZN6S101C53v89Ev,
  (VTBL_ENTRY)&_ZN6S101C53v90Ev,
  (VTBL_ENTRY)&_ZN6S101C53v91Ev,
  (VTBL_ENTRY)&_ZN6S101C53v92Ev,
  (VTBL_ENTRY)&_ZN6S101C53v93Ev,
  (VTBL_ENTRY)&_ZN6S101C53v94Ev,
  (VTBL_ENTRY)&_ZN6S101C53v95Ev,
  (VTBL_ENTRY)&_ZN6S101C53v96Ev,
  (VTBL_ENTRY)&_ZN6S101C53v97Ev,
  (VTBL_ENTRY)&_ZN6S101C53v98Ev,
  (VTBL_ENTRY)&_ZN6S101C53v99Ev,
  (VTBL_ENTRY)&_ZN6S101C54v100Ev,
  (VTBL_ENTRY)&_ZN6S101C54v101Ev,
  (VTBL_ENTRY)&_ZN6S101C54v102Ev,
  (VTBL_ENTRY)&_ZN6S101C54v103Ev,
  (VTBL_ENTRY)&_ZN6S101C54v104Ev,
  (VTBL_ENTRY)&_ZN6S101C54v105Ev,
  (VTBL_ENTRY)&_ZN6S101C54v106Ev,
  (VTBL_ENTRY)&_ZN6S101C54v107Ev,
  (VTBL_ENTRY)&_ZN6S101C54v108Ev,
  (VTBL_ENTRY)&_ZN6S101C54v109Ev,
  (VTBL_ENTRY)&_ZN6S101C54v110Ev,
  (VTBL_ENTRY)&_ZN6S101C54v111Ev,
  (VTBL_ENTRY)&_ZN6S101C54v112Ev,
  (VTBL_ENTRY)&_ZN6S101C54v113Ev,
  (VTBL_ENTRY)&_ZN6S101C54v114Ev,
  (VTBL_ENTRY)&_ZN6S101C54v115Ev,
  (VTBL_ENTRY)&_ZN6S101C54v116Ev,
  (VTBL_ENTRY)&_ZN6S101C54v117Ev,
  (VTBL_ENTRY)&_ZN6S101C54v118Ev,
  (VTBL_ENTRY)&_ZN6S101C54v119Ev,
  (VTBL_ENTRY)&_ZN6S101C54v120Ev,
  (VTBL_ENTRY)&_ZN6S101C54v121Ev,
  (VTBL_ENTRY)&_ZN6S101C54v122Ev,
  (VTBL_ENTRY)&_ZN6S101C54v123Ev,
  (VTBL_ENTRY)&_ZN6S101C54v124Ev,
  (VTBL_ENTRY)&_ZN6S101C54v125Ev,
  (VTBL_ENTRY)&_ZN6S101C54v126Ev,
  (VTBL_ENTRY)&_ZN6S101C54v127Ev,
  (VTBL_ENTRY)&_ZN6S101C54v128Ev,
  (VTBL_ENTRY)&_ZN6S101C54v129Ev,
  (VTBL_ENTRY)&_ZN6S101C54v130Ev,
  (VTBL_ENTRY)&_ZN6S101C54v131Ev,
  (VTBL_ENTRY)&_ZN6S101C54v132Ev,
  (VTBL_ENTRY)&_ZN6S101C54v133Ev,
  (VTBL_ENTRY)&_ZN6S101C54v134Ev,
  (VTBL_ENTRY)&_ZN6S101C54v135Ev,
  (VTBL_ENTRY)&_ZN6S101C54v136Ev,
  (VTBL_ENTRY)&_ZN6S101C54v137Ev,
  (VTBL_ENTRY)&_ZN6S101C54v138Ev,
  (VTBL_ENTRY)&_ZN6S101C54v139Ev,
  (VTBL_ENTRY)&_ZN6S101C54v140Ev,
  (VTBL_ENTRY)&_ZN6S101C54v141Ev,
  (VTBL_ENTRY)&_ZN6S101C54v142Ev,
  (VTBL_ENTRY)&_ZN6S101C54v143Ev,
  (VTBL_ENTRY)&_ZN6S101C54v144Ev,
  (VTBL_ENTRY)&_ZN6S101C54v145Ev,
  (VTBL_ENTRY)&_ZN6S101C54v146Ev,
  (VTBL_ENTRY)&_ZN6S101C44v147Ev,
  (VTBL_ENTRY)&_ZN6S101C44v148Ev,
  (VTBL_ENTRY)&_ZN6S101C44v149Ev,
  (VTBL_ENTRY)&_ZN6S101C44v150Ev,
  (VTBL_ENTRY)&_ZN6S101C44v151Ev,
  (VTBL_ENTRY)&_ZN6S101C44v152Ev,
  (VTBL_ENTRY)&_ZN6S101C44v153Ev,
  (VTBL_ENTRY)&_ZN6S101C44v154Ev,
  (VTBL_ENTRY)&_ZN6S101C44v155Ev,
  (VTBL_ENTRY)&_ZN6S101C44v156Ev,
  (VTBL_ENTRY)&_ZN6S101C44v157Ev,
  (VTBL_ENTRY)&_ZN6S101C44v158Ev,
  (VTBL_ENTRY)&_ZN6S101C44v159Ev,
  (VTBL_ENTRY)&_ZN6S101C44v160Ev,
  (VTBL_ENTRY)&_ZN6S101C44v161Ev,
  (VTBL_ENTRY)&_ZN6S101C44v162Ev,
  (VTBL_ENTRY)&_ZN6S101C44v163Ev,
  (VTBL_ENTRY)&_ZN6S101C44v164Ev,
  (VTBL_ENTRY)&_ZN6S101C44v165Ev,
  (VTBL_ENTRY)&_ZN6S101C44v166Ev,
  (VTBL_ENTRY)&_ZN6S101C44v167Ev,
  (VTBL_ENTRY)&_ZN6S101C44v168Ev,
  (VTBL_ENTRY)&_ZN6S101C44v169Ev,
  (VTBL_ENTRY)&_ZN6S101C44v170Ev,
  (VTBL_ENTRY)&_ZN6S101C44v171Ev,
  (VTBL_ENTRY)&_ZN6S101C44v172Ev,
  (VTBL_ENTRY)&_ZN6S101C44v173Ev,
  (VTBL_ENTRY)&_ZN6S101C44v174Ev,
  (VTBL_ENTRY)&_ZN6S101C44v175Ev,
  (VTBL_ENTRY)&_ZN6S101C44v176Ev,
  (VTBL_ENTRY)&_ZN6S101C44v177Ev,
  (VTBL_ENTRY)&_ZN6S101C44v178Ev,
  (VTBL_ENTRY)&_ZN6S101C44v179Ev,
  (VTBL_ENTRY)&_ZN6S101C44v180Ev,
  (VTBL_ENTRY)&_ZN6S101C44v181Ev,
  (VTBL_ENTRY)&_ZN6S101C44v182Ev,
  (VTBL_ENTRY)&_ZN6S101C44v183Ev,
  (VTBL_ENTRY)&_ZN6S101C44v184Ev,
  (VTBL_ENTRY)&_ZN6S101C44v185Ev,
  (VTBL_ENTRY)&_ZN6S101C34v186Ev,
  (VTBL_ENTRY)&_ZN6S101C34v187Ev,
  (VTBL_ENTRY)&_ZN6S101C34v188Ev,
  (VTBL_ENTRY)&_ZN6S101C34v189Ev,
  (VTBL_ENTRY)&_ZN6S101C34v190Ev,
  (VTBL_ENTRY)&_ZN6S101C34v191Ev,
  (VTBL_ENTRY)&_ZN6S101C34v192Ev,
  (VTBL_ENTRY)&_ZN6S101C34v193Ev,
  (VTBL_ENTRY)&_ZN6S101C34v194Ev,
  (VTBL_ENTRY)&_ZN6S101C34v195Ev,
  (VTBL_ENTRY)&_ZN6S101C34v196Ev,
  (VTBL_ENTRY)&_ZN6S101C34v197Ev,
  (VTBL_ENTRY)&_ZN6S101C34v198Ev,
  (VTBL_ENTRY)&_ZN6S101C34v199Ev,
  (VTBL_ENTRY)&_ZN6S101C34v200Ev,
  (VTBL_ENTRY)&_ZN6S101C34v201Ev,
  (VTBL_ENTRY)&_ZN6S101C34v202Ev,
  (VTBL_ENTRY)&_ZN6S101C34v203Ev,
  (VTBL_ENTRY)&_ZN6S101C34v204Ev,
  (VTBL_ENTRY)&_ZN6S101C34v205Ev,
  (VTBL_ENTRY)&_ZN6S101C34v206Ev,
  (VTBL_ENTRY)&_ZN6S101C34v207Ev,
  (VTBL_ENTRY)&_ZN6S101C34v208Ev,
  (VTBL_ENTRY)&_ZN6S101C24v209Ev,
  (VTBL_ENTRY)&_ZN6S101C24v210Ev,
  (VTBL_ENTRY)&_ZN6S101C24v211Ev,
  (VTBL_ENTRY)&_ZN6S101C24v212Ev,
  (VTBL_ENTRY)&_ZN6S101C24v213Ev,
  (VTBL_ENTRY)&_ZN6S101C24v214Ev,
  (VTBL_ENTRY)&_ZN6S101C24v215Ev,
  (VTBL_ENTRY)&_ZN6S101C24v216Ev,
  (VTBL_ENTRY)&_ZN6S101C12v1Ev,
  (VTBL_ENTRY)&_ZN6S101C12v2Ev,
  (VTBL_ENTRY)&_ZN6S101C12v3Ev,
  (VTBL_ENTRY)&_ZN6S101C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S101C1[];
extern  VTBL_ENTRY _ZTV6S101C1[];
Class_Descriptor cd_S101C1 = {  "S101C1", // class name
  bases_S101C1, 6,
  &(vtc_S101C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1072,744), // object size
  NSPAIRA(_ZTI6S101C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S101C1),220, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C7  {
  int s105c7f0;
  __tsi64 s105c7f1;
  void *s105c7f2[4];
  int s105c7f3[2];
  void *s105c7f4;
  ::S85C27_nt s105c7f5;
  void *s105c7f6[2];
  virtual  ~S105C7(); // _ZN6S105C7D1Ev
  virtual void  v6(); // _ZN6S105C72v6Ev
  virtual void  v7(); // _ZN6S105C72v7Ev
  virtual void  v8(); // _ZN6S105C72v8Ev
  virtual void  v9(); // _ZN6S105C72v9Ev
  virtual void  v10(); // _ZN6S105C73v10Ev
  virtual void  v11(); // _ZN6S105C73v11Ev
  virtual void  v12(); // _ZN6S105C73v12Ev
  virtual void  v13(); // _ZN6S105C73v13Ev
  virtual void  v14(); // _ZN6S105C73v14Ev
  virtual void  v15(); // _ZN6S105C73v15Ev
  virtual void  v16(); // _ZN6S105C73v16Ev
  virtual void  v17(); // _ZN6S105C73v17Ev
  virtual void  v18(); // _ZN6S105C73v18Ev
  virtual void  v19(); // _ZN6S105C73v19Ev
  virtual void  v20(); // _ZN6S105C73v20Ev
  virtual void  v21(); // _ZN6S105C73v21Ev
  virtual void  v22(); // _ZN6S105C73v22Ev
  virtual void  v23(); // _ZN6S105C73v23Ev
  virtual void  v24(); // _ZN6S105C73v24Ev
  virtual void  v25(); // _ZN6S105C73v25Ev
  virtual void  v26(); // _ZN6S105C73v26Ev
  virtual void  v27(); // _ZN6S105C73v27Ev
  virtual void  v28(); // _ZN6S105C73v28Ev
  virtual void  v29(); // _ZN6S105C73v29Ev
  virtual void  v30(); // _ZN6S105C73v30Ev
  virtual void  v31(); // _ZN6S105C73v31Ev
  virtual void  v32(); // _ZN6S105C73v32Ev
  virtual void  v33(); // _ZN6S105C73v33Ev
  virtual void  v34(); // _ZN6S105C73v34Ev
  virtual void  v35(); // _ZN6S105C73v35Ev
  virtual void  v36(); // _ZN6S105C73v36Ev
  virtual void  v37(); // _ZN6S105C73v37Ev
  virtual void  v38(); // _ZN6S105C73v38Ev
  virtual void  v39(); // _ZN6S105C73v39Ev
  virtual void  v40(); // _ZN6S105C73v40Ev
  virtual void  v41(); // _ZN6S105C73v41Ev
  virtual void  v42(); // _ZN6S105C73v42Ev
  virtual void  v43(); // _ZN6S105C73v43Ev
  virtual void  v44(); // _ZN6S105C73v44Ev
  virtual void  v45(); // _ZN6S105C73v45Ev
  virtual void  v46(); // _ZN6S105C73v46Ev
  virtual void  v47(); // _ZN6S105C73v47Ev
  virtual void  v48(); // _ZN6S105C73v48Ev
  virtual void  v49(); // _ZN6S105C73v49Ev
  virtual void  v50(); // _ZN6S105C73v50Ev
  virtual void  v51(); // _ZN6S105C73v51Ev
  virtual void  v52(); // _ZN6S105C73v52Ev
  virtual void  v53(); // _ZN6S105C73v53Ev
  virtual void  v54(); // _ZN6S105C73v54Ev
  virtual void  v55(); // _ZN6S105C73v55Ev
  virtual void  v56(); // _ZN6S105C73v56Ev
  virtual void  v57(); // _ZN6S105C73v57Ev
  virtual void  v58(); // _ZN6S105C73v58Ev
  virtual void  v59(); // _ZN6S105C73v59Ev
  virtual void  v60(); // _ZN6S105C73v60Ev
  virtual void  v61(); // _ZN6S105C73v61Ev
  virtual void  v62(); // _ZN6S105C73v62Ev
  virtual void  v63(); // _ZN6S105C73v63Ev
  virtual void  v64(); // _ZN6S105C73v64Ev
  virtual void  v65(); // _ZN6S105C73v65Ev
  virtual void  v66(); // _ZN6S105C73v66Ev
  virtual void  v67(); // _ZN6S105C73v67Ev
  virtual void  v68(); // _ZN6S105C73v68Ev
  virtual void  v69(); // _ZN6S105C73v69Ev
  S105C7(); // tgen
};
//SIG(-1 S105C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S105C7 ::~S105C7(){ note_dtor("S105C7", this);}
void  S105C7 ::v6(){vfunc_called(this, "_ZN6S105C72v6Ev");}
void  S105C7 ::v7(){vfunc_called(this, "_ZN6S105C72v7Ev");}
void  S105C7 ::v8(){vfunc_called(this, "_ZN6S105C72v8Ev");}
void  S105C7 ::v9(){vfunc_called(this, "_ZN6S105C72v9Ev");}
void  S105C7 ::v10(){vfunc_called(this, "_ZN6S105C73v10Ev");}
void  S105C7 ::v11(){vfunc_called(this, "_ZN6S105C73v11Ev");}
void  S105C7 ::v12(){vfunc_called(this, "_ZN6S105C73v12Ev");}
void  S105C7 ::v13(){vfunc_called(this, "_ZN6S105C73v13Ev");}
void  S105C7 ::v14(){vfunc_called(this, "_ZN6S105C73v14Ev");}
void  S105C7 ::v15(){vfunc_called(this, "_ZN6S105C73v15Ev");}
void  S105C7 ::v16(){vfunc_called(this, "_ZN6S105C73v16Ev");}
void  S105C7 ::v17(){vfunc_called(this, "_ZN6S105C73v17Ev");}
void  S105C7 ::v18(){vfunc_called(this, "_ZN6S105C73v18Ev");}
void  S105C7 ::v19(){vfunc_called(this, "_ZN6S105C73v19Ev");}
void  S105C7 ::v20(){vfunc_called(this, "_ZN6S105C73v20Ev");}
void  S105C7 ::v21(){vfunc_called(this, "_ZN6S105C73v21Ev");}
void  S105C7 ::v22(){vfunc_called(this, "_ZN6S105C73v22Ev");}
void  S105C7 ::v23(){vfunc_called(this, "_ZN6S105C73v23Ev");}
void  S105C7 ::v24(){vfunc_called(this, "_ZN6S105C73v24Ev");}
void  S105C7 ::v25(){vfunc_called(this, "_ZN6S105C73v25Ev");}
void  S105C7 ::v26(){vfunc_called(this, "_ZN6S105C73v26Ev");}
void  S105C7 ::v27(){vfunc_called(this, "_ZN6S105C73v27Ev");}
void  S105C7 ::v28(){vfunc_called(this, "_ZN6S105C73v28Ev");}
void  S105C7 ::v29(){vfunc_called(this, "_ZN6S105C73v29Ev");}
void  S105C7 ::v30(){vfunc_called(this, "_ZN6S105C73v30Ev");}
void  S105C7 ::v31(){vfunc_called(this, "_ZN6S105C73v31Ev");}
void  S105C7 ::v32(){vfunc_called(this, "_ZN6S105C73v32Ev");}
void  S105C7 ::v33(){vfunc_called(this, "_ZN6S105C73v33Ev");}
void  S105C7 ::v34(){vfunc_called(this, "_ZN6S105C73v34Ev");}
void  S105C7 ::v35(){vfunc_called(this, "_ZN6S105C73v35Ev");}
void  S105C7 ::v36(){vfunc_called(this, "_ZN6S105C73v36Ev");}
void  S105C7 ::v37(){vfunc_called(this, "_ZN6S105C73v37Ev");}
void  S105C7 ::v38(){vfunc_called(this, "_ZN6S105C73v38Ev");}
void  S105C7 ::v39(){vfunc_called(this, "_ZN6S105C73v39Ev");}
void  S105C7 ::v40(){vfunc_called(this, "_ZN6S105C73v40Ev");}
void  S105C7 ::v41(){vfunc_called(this, "_ZN6S105C73v41Ev");}
void  S105C7 ::v42(){vfunc_called(this, "_ZN6S105C73v42Ev");}
void  S105C7 ::v43(){vfunc_called(this, "_ZN6S105C73v43Ev");}
void  S105C7 ::v44(){vfunc_called(this, "_ZN6S105C73v44Ev");}
void  S105C7 ::v45(){vfunc_called(this, "_ZN6S105C73v45Ev");}
void  S105C7 ::v46(){vfunc_called(this, "_ZN6S105C73v46Ev");}
void  S105C7 ::v47(){vfunc_called(this, "_ZN6S105C73v47Ev");}
void  S105C7 ::v48(){vfunc_called(this, "_ZN6S105C73v48Ev");}
void  S105C7 ::v49(){vfunc_called(this, "_ZN6S105C73v49Ev");}
void  S105C7 ::v50(){vfunc_called(this, "_ZN6S105C73v50Ev");}
void  S105C7 ::v51(){vfunc_called(this, "_ZN6S105C73v51Ev");}
void  S105C7 ::v52(){vfunc_called(this, "_ZN6S105C73v52Ev");}
void  S105C7 ::v53(){vfunc_called(this, "_ZN6S105C73v53Ev");}
void  S105C7 ::v54(){vfunc_called(this, "_ZN6S105C73v54Ev");}
void  S105C7 ::v55(){vfunc_called(this, "_ZN6S105C73v55Ev");}
void  S105C7 ::v56(){vfunc_called(this, "_ZN6S105C73v56Ev");}
void  S105C7 ::v57(){vfunc_called(this, "_ZN6S105C73v57Ev");}
void  S105C7 ::v58(){vfunc_called(this, "_ZN6S105C73v58Ev");}
void  S105C7 ::v59(){vfunc_called(this, "_ZN6S105C73v59Ev");}
void  S105C7 ::v60(){vfunc_called(this, "_ZN6S105C73v60Ev");}
void  S105C7 ::v61(){vfunc_called(this, "_ZN6S105C73v61Ev");}
void  S105C7 ::v62(){vfunc_called(this, "_ZN6S105C73v62Ev");}
void  S105C7 ::v63(){vfunc_called(this, "_ZN6S105C73v63Ev");}
void  S105C7 ::v64(){vfunc_called(this, "_ZN6S105C73v64Ev");}
void  S105C7 ::v65(){vfunc_called(this, "_ZN6S105C73v65Ev");}
void  S105C7 ::v66(){vfunc_called(this, "_ZN6S105C73v66Ev");}
void  S105C7 ::v67(){vfunc_called(this, "_ZN6S105C73v67Ev");}
void  S105C7 ::v68(){vfunc_called(this, "_ZN6S105C73v68Ev");}
void  S105C7 ::v69(){vfunc_called(this, "_ZN6S105C73v69Ev");}
S105C7 ::S105C7(){ note_ctor("S105C7", this);} // tgen

static void Test_S105C7()
{
  extern Class_Descriptor cd_S105C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S105C7, buf);
    S105C7 *dp, &lv = *(dp=new (buf) S105C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S105C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C7)");
    check_field_offset(lv, s105c7f0, ABISELECT(8,4), "S105C7.s105c7f0");
    check_field_offset(lv, s105c7f1, ABISELECT(16,8), "S105C7.s105c7f1");
    check_field_offset(lv, s105c7f2, ABISELECT(24,16), "S105C7.s105c7f2");
    check_field_offset(lv, s105c7f3, ABISELECT(56,32), "S105C7.s105c7f3");
    check_field_offset(lv, s105c7f4, ABISELECT(64,40), "S105C7.s105c7f4");
    check_field_offset(lv, s105c7f5, ABISELECT(72,44), "S105C7.s105c7f5");
    check_field_offset(lv, s105c7f6, ABISELECT(80,52), "S105C7.s105c7f6");
    test_class_info(&lv, &cd_S105C7);
    dp->~S105C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C7(Test_S105C7, "S105C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S105C7C1Ev();
extern void _ZN6S105C7D1Ev();
Name_Map name_map_S105C7[] = {
  NSPAIR(_ZN6S105C7C1Ev),
  NSPAIR(_ZN6S105C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S105C7[];
extern void _ZN6S105C7D1Ev();
extern void _ZN6S105C7D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
static  VTBL_ENTRY vtc_S105C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C7[0]),
  (VTBL_ENTRY)&_ZN6S105C7D1Ev,
  (VTBL_ENTRY)&_ZN6S105C7D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
};
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
Class_Descriptor cd_S105C7 = {  "S105C7", // class name
  0,0,//no base classes
  &(vtc_S105C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S105C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S105C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C6  : S105C7 {
  virtual  ~S105C6(); // _ZN6S105C6D1Ev
  virtual void  v70(); // _ZN6S105C63v70Ev
  virtual void  v71(); // _ZN6S105C63v71Ev
  S105C6(); // tgen
};
//SIG(-1 S105C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S105C6 ::~S105C6(){ note_dtor("S105C6", this);}
void  S105C6 ::v70(){vfunc_called(this, "_ZN6S105C63v70Ev");}
void  S105C6 ::v71(){vfunc_called(this, "_ZN6S105C63v71Ev");}
S105C6 ::S105C6(){ note_ctor("S105C6", this);} // tgen

static void Test_S105C6()
{
  extern Class_Descriptor cd_S105C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S105C6, buf);
    S105C6 *dp, &lv = *(dp=new (buf) S105C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S105C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C6)");
    check_base_class_offset(lv, (S105C7*), 0, "S105C6");
    test_class_info(&lv, &cd_S105C6);
    dp->~S105C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C6(Test_S105C6, "S105C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S105C6C1Ev();
extern void _ZN6S105C6D1Ev();
Name_Map name_map_S105C6[] = {
  NSPAIR(_ZN6S105C6C1Ev),
  NSPAIR(_ZN6S105C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
static Base_Class bases_S105C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C6[];
extern void _ZN6S105C6D1Ev();
extern void _ZN6S105C6D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
static  VTBL_ENTRY vtc_S105C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C6[0]),
  (VTBL_ENTRY)&_ZN6S105C6D1Ev,
  (VTBL_ENTRY)&_ZN6S105C6D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
};
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
Class_Descriptor cd_S105C6 = {  "S105C6", // class name
  bases_S105C6, 1,
  &(vtc_S105C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S105C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C5  : S105C6 {
  ::S80C9_nt s105c5f0;
  int s105c5f1;
  unsigned int s105c5f2:1;
  unsigned int s105c5f3:1;
  unsigned int s105c5f4:1;
  unsigned int s105c5f5:1;
  ::S85C35 s105c5f6;
  ::S85C22_nt s105c5f7;
  void *s105c5f8;
  ::S80C31 s105c5f9;
  ::S80C31 s105c5f10;
  ::S80C29 s105c5f11;
  ::S80C19 s105c5f12;
  char s105c5f13;
  int s105c5f14;
  void *s105c5f15;
  ::S85C27_nt s105c5f16;
  ::S85C27_nt s105c5f17;
  ::S85C27_nt s105c5f18;
  ::S85C27_nt s105c5f19;
  ::S85C27_nt s105c5f20;
  ::S85C27_nt s105c5f21;
  ::S80C21_nt s105c5f22;
  ::S80C21_nt s105c5f23;
  ::S80C21_nt s105c5f24;
  ::S80C21_nt s105c5f25;
  ::S80C21_nt s105c5f26;
  ::S80C21_nt s105c5f27;
  ::S80C21_nt s105c5f28;
  ::S80C21_nt s105c5f29;
  ::S80C21_nt s105c5f30;
  ::S80C21_nt s105c5f31;
  virtual  ~S105C5(); // _ZN6S105C5D1Ev
  virtual void  v72(); // _ZN6S105C53v72Ev
  virtual void  v73(); // _ZN6S105C53v73Ev
  virtual void  v74(); // _ZN6S105C53v74Ev
  virtual void  v75(); // _ZN6S105C53v75Ev
  virtual void  v76(); // _ZN6S105C53v76Ev
  virtual void  v77(); // _ZN6S105C53v77Ev
  virtual void  v78(); // _ZN6S105C53v78Ev
  virtual void  v79(); // _ZN6S105C53v79Ev
  virtual void  v80(); // _ZN6S105C53v80Ev
  virtual void  v81(); // _ZN6S105C53v81Ev
  virtual void  v82(); // _ZN6S105C53v82Ev
  virtual void  v83(); // _ZN6S105C53v83Ev
  virtual void  v84(); // _ZN6S105C53v84Ev
  virtual void  v85(); // _ZN6S105C53v85Ev
  virtual void  v86(); // _ZN6S105C53v86Ev
  virtual void  v87(); // _ZN6S105C53v87Ev
  virtual void  v88(); // _ZN6S105C53v88Ev
  virtual void  v89(); // _ZN6S105C53v89Ev
  virtual void  v90(); // _ZN6S105C53v90Ev
  virtual void  v91(); // _ZN6S105C53v91Ev
  virtual void  v92(); // _ZN6S105C53v92Ev
  virtual void  v93(); // _ZN6S105C53v93Ev
  virtual void  v94(); // _ZN6S105C53v94Ev
  virtual void  v95(); // _ZN6S105C53v95Ev
  virtual void  v96(); // _ZN6S105C53v96Ev
  virtual void  v97(); // _ZN6S105C53v97Ev
  virtual void  v98(); // _ZN6S105C53v98Ev
  virtual void  v99(); // _ZN6S105C53v99Ev
  virtual void  v100(); // _ZN6S105C54v100Ev
  virtual void  v101(); // _ZN6S105C54v101Ev
  virtual void  v102(); // _ZN6S105C54v102Ev
  virtual void  v103(); // _ZN6S105C54v103Ev
  virtual void  v104(); // _ZN6S105C54v104Ev
  virtual void  v105(); // _ZN6S105C54v105Ev
  virtual void  v106(); // _ZN6S105C54v106Ev
  virtual void  v107(); // _ZN6S105C54v107Ev
  virtual void  v108(); // _ZN6S105C54v108Ev
  virtual void  v109(); // _ZN6S105C54v109Ev
  virtual void  v110(); // _ZN6S105C54v110Ev
  virtual void  v111(); // _ZN6S105C54v111Ev
  virtual void  v112(); // _ZN6S105C54v112Ev
  virtual void  v113(); // _ZN6S105C54v113Ev
  virtual void  v114(); // _ZN6S105C54v114Ev
  virtual void  v115(); // _ZN6S105C54v115Ev
  virtual void  v116(); // _ZN6S105C54v116Ev
  virtual void  v117(); // _ZN6S105C54v117Ev
  virtual void  v118(); // _ZN6S105C54v118Ev
  virtual void  v119(); // _ZN6S105C54v119Ev
  virtual void  v120(); // _ZN6S105C54v120Ev
  virtual void  v121(); // _ZN6S105C54v121Ev
  virtual void  v122(); // _ZN6S105C54v122Ev
  virtual void  v123(); // _ZN6S105C54v123Ev
  virtual void  v124(); // _ZN6S105C54v124Ev
  virtual void  v125(); // _ZN6S105C54v125Ev
  virtual void  v126(); // _ZN6S105C54v126Ev
  virtual void  v127(); // _ZN6S105C54v127Ev
  virtual void  v128(); // _ZN6S105C54v128Ev
  virtual void  v129(); // _ZN6S105C54v129Ev
  virtual void  v130(); // _ZN6S105C54v130Ev
  virtual void  v131(); // _ZN6S105C54v131Ev
  virtual void  v132(); // _ZN6S105C54v132Ev
  virtual void  v133(); // _ZN6S105C54v133Ev
  virtual void  v134(); // _ZN6S105C54v134Ev
  virtual void  v135(); // _ZN6S105C54v135Ev
  virtual void  v136(); // _ZN6S105C54v136Ev
  virtual void  v137(); // _ZN6S105C54v137Ev
  virtual void  v138(); // _ZN6S105C54v138Ev
  virtual void  v139(); // _ZN6S105C54v139Ev
  virtual void  v140(); // _ZN6S105C54v140Ev
  virtual void  v141(); // _ZN6S105C54v141Ev
  virtual void  v142(); // _ZN6S105C54v142Ev
  virtual void  v143(); // _ZN6S105C54v143Ev
  virtual void  v144(); // _ZN6S105C54v144Ev
  virtual void  v145(); // _ZN6S105C54v145Ev
  virtual void  v146(); // _ZN6S105C54v146Ev
  virtual void  v147(); // _ZN6S105C54v147Ev
  S105C5(); // tgen
};
//SIG(-1 S105C5) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC18{ m Fi[2]}} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S105C5 ::~S105C5(){ note_dtor("S105C5", this);}
void  S105C5 ::v72(){vfunc_called(this, "_ZN6S105C53v72Ev");}
void  S105C5 ::v73(){vfunc_called(this, "_ZN6S105C53v73Ev");}
void  S105C5 ::v74(){vfunc_called(this, "_ZN6S105C53v74Ev");}
void  S105C5 ::v75(){vfunc_called(this, "_ZN6S105C53v75Ev");}
void  S105C5 ::v76(){vfunc_called(this, "_ZN6S105C53v76Ev");}
void  S105C5 ::v77(){vfunc_called(this, "_ZN6S105C53v77Ev");}
void  S105C5 ::v78(){vfunc_called(this, "_ZN6S105C53v78Ev");}
void  S105C5 ::v79(){vfunc_called(this, "_ZN6S105C53v79Ev");}
void  S105C5 ::v80(){vfunc_called(this, "_ZN6S105C53v80Ev");}
void  S105C5 ::v81(){vfunc_called(this, "_ZN6S105C53v81Ev");}
void  S105C5 ::v82(){vfunc_called(this, "_ZN6S105C53v82Ev");}
void  S105C5 ::v83(){vfunc_called(this, "_ZN6S105C53v83Ev");}
void  S105C5 ::v84(){vfunc_called(this, "_ZN6S105C53v84Ev");}
void  S105C5 ::v85(){vfunc_called(this, "_ZN6S105C53v85Ev");}
void  S105C5 ::v86(){vfunc_called(this, "_ZN6S105C53v86Ev");}
void  S105C5 ::v87(){vfunc_called(this, "_ZN6S105C53v87Ev");}
void  S105C5 ::v88(){vfunc_called(this, "_ZN6S105C53v88Ev");}
void  S105C5 ::v89(){vfunc_called(this, "_ZN6S105C53v89Ev");}
void  S105C5 ::v90(){vfunc_called(this, "_ZN6S105C53v90Ev");}
void  S105C5 ::v91(){vfunc_called(this, "_ZN6S105C53v91Ev");}
void  S105C5 ::v92(){vfunc_called(this, "_ZN6S105C53v92Ev");}
void  S105C5 ::v93(){vfunc_called(this, "_ZN6S105C53v93Ev");}
void  S105C5 ::v94(){vfunc_called(this, "_ZN6S105C53v94Ev");}
void  S105C5 ::v95(){vfunc_called(this, "_ZN6S105C53v95Ev");}
void  S105C5 ::v96(){vfunc_called(this, "_ZN6S105C53v96Ev");}
void  S105C5 ::v97(){vfunc_called(this, "_ZN6S105C53v97Ev");}
void  S105C5 ::v98(){vfunc_called(this, "_ZN6S105C53v98Ev");}
void  S105C5 ::v99(){vfunc_called(this, "_ZN6S105C53v99Ev");}
void  S105C5 ::v100(){vfunc_called(this, "_ZN6S105C54v100Ev");}
void  S105C5 ::v101(){vfunc_called(this, "_ZN6S105C54v101Ev");}
void  S105C5 ::v102(){vfunc_called(this, "_ZN6S105C54v102Ev");}
void  S105C5 ::v103(){vfunc_called(this, "_ZN6S105C54v103Ev");}
void  S105C5 ::v104(){vfunc_called(this, "_ZN6S105C54v104Ev");}
void  S105C5 ::v105(){vfunc_called(this, "_ZN6S105C54v105Ev");}
void  S105C5 ::v106(){vfunc_called(this, "_ZN6S105C54v106Ev");}
void  S105C5 ::v107(){vfunc_called(this, "_ZN6S105C54v107Ev");}
void  S105C5 ::v108(){vfunc_called(this, "_ZN6S105C54v108Ev");}
void  S105C5 ::v109(){vfunc_called(this, "_ZN6S105C54v109Ev");}
void  S105C5 ::v110(){vfunc_called(this, "_ZN6S105C54v110Ev");}
void  S105C5 ::v111(){vfunc_called(this, "_ZN6S105C54v111Ev");}
void  S105C5 ::v112(){vfunc_called(this, "_ZN6S105C54v112Ev");}
void  S105C5 ::v113(){vfunc_called(this, "_ZN6S105C54v113Ev");}
void  S105C5 ::v114(){vfunc_called(this, "_ZN6S105C54v114Ev");}
void  S105C5 ::v115(){vfunc_called(this, "_ZN6S105C54v115Ev");}
void  S105C5 ::v116(){vfunc_called(this, "_ZN6S105C54v116Ev");}
void  S105C5 ::v117(){vfunc_called(this, "_ZN6S105C54v117Ev");}
void  S105C5 ::v118(){vfunc_called(this, "_ZN6S105C54v118Ev");}
void  S105C5 ::v119(){vfunc_called(this, "_ZN6S105C54v119Ev");}
void  S105C5 ::v120(){vfunc_called(this, "_ZN6S105C54v120Ev");}
void  S105C5 ::v121(){vfunc_called(this, "_ZN6S105C54v121Ev");}
void  S105C5 ::v122(){vfunc_called(this, "_ZN6S105C54v122Ev");}
void  S105C5 ::v123(){vfunc_called(this, "_ZN6S105C54v123Ev");}
void  S105C5 ::v124(){vfunc_called(this, "_ZN6S105C54v124Ev");}
void  S105C5 ::v125(){vfunc_called(this, "_ZN6S105C54v125Ev");}
void  S105C5 ::v126(){vfunc_called(this, "_ZN6S105C54v126Ev");}
void  S105C5 ::v127(){vfunc_called(this, "_ZN6S105C54v127Ev");}
void  S105C5 ::v128(){vfunc_called(this, "_ZN6S105C54v128Ev");}
void  S105C5 ::v129(){vfunc_called(this, "_ZN6S105C54v129Ev");}
void  S105C5 ::v130(){vfunc_called(this, "_ZN6S105C54v130Ev");}
void  S105C5 ::v131(){vfunc_called(this, "_ZN6S105C54v131Ev");}
void  S105C5 ::v132(){vfunc_called(this, "_ZN6S105C54v132Ev");}
void  S105C5 ::v133(){vfunc_called(this, "_ZN6S105C54v133Ev");}
void  S105C5 ::v134(){vfunc_called(this, "_ZN6S105C54v134Ev");}
void  S105C5 ::v135(){vfunc_called(this, "_ZN6S105C54v135Ev");}
void  S105C5 ::v136(){vfunc_called(this, "_ZN6S105C54v136Ev");}
void  S105C5 ::v137(){vfunc_called(this, "_ZN6S105C54v137Ev");}
void  S105C5 ::v138(){vfunc_called(this, "_ZN6S105C54v138Ev");}
void  S105C5 ::v139(){vfunc_called(this, "_ZN6S105C54v139Ev");}
void  S105C5 ::v140(){vfunc_called(this, "_ZN6S105C54v140Ev");}
void  S105C5 ::v141(){vfunc_called(this, "_ZN6S105C54v141Ev");}
void  S105C5 ::v142(){vfunc_called(this, "_ZN6S105C54v142Ev");}
void  S105C5 ::v143(){vfunc_called(this, "_ZN6S105C54v143Ev");}
void  S105C5 ::v144(){vfunc_called(this, "_ZN6S105C54v144Ev");}
void  S105C5 ::v145(){vfunc_called(this, "_ZN6S105C54v145Ev");}
void  S105C5 ::v146(){vfunc_called(this, "_ZN6S105C54v146Ev");}
void  S105C5 ::v147(){vfunc_called(this, "_ZN6S105C54v147Ev");}
S105C5 ::S105C5(){ note_ctor("S105C5", this);} // tgen

static void Test_S105C5()
{
  extern Class_Descriptor cd_S105C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S105C5, buf);
    S105C5 *dp, &lv = *(dp=new (buf) S105C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S105C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C5)");
    check_base_class_offset(lv, (S105C7*)(S105C6*), 0, "S105C5");
    check_base_class_offset(lv, (S105C6*), 0, "S105C5");
    check_field_offset(lv, s105c5f0, ABISELECT(96,60), "S105C5.s105c5f0");
    check_field_offset(lv, s105c5f1, ABISELECT(124,88), "S105C5.s105c5f1");
    set_bf_and_test(lv, s105c5f2, ABISELECT(128,92), 0, 1, 1, "S105C5");
    set_bf_and_test(lv, s105c5f3, ABISELECT(128,92), 1, 1, 1, "S105C5");
    set_bf_and_test(lv, s105c5f4, ABISELECT(128,92), 2, 1, 1, "S105C5");
    set_bf_and_test(lv, s105c5f5, ABISELECT(128,92), 3, 1, 1, "S105C5");
    check_field_offset(lv, s105c5f6, ABISELECT(136,96), "S105C5.s105c5f6");
    check_field_offset(lv, s105c5f7, ABISELECT(152,108), "S105C5.s105c5f7");
    check_field_offset(lv, s105c5f8, ABISELECT(168,120), "S105C5.s105c5f8");
    check_field_offset(lv, s105c5f9, ABISELECT(176,124), "S105C5.s105c5f9");
    check_field_offset(lv, s105c5f10, ABISELECT(192,136), "S105C5.s105c5f10");
    check_field_offset(lv, s105c5f11, ABISELECT(208,148), "S105C5.s105c5f11");
    check_field_offset(lv, s105c5f12, ABISELECT(224,160), "S105C5.s105c5f12");
    check_field_offset(lv, s105c5f13, ABISELECT(240,172), "S105C5.s105c5f13");
    check_field_offset(lv, s105c5f14, ABISELECT(244,176), "S105C5.s105c5f14");
    check_field_offset(lv, s105c5f15, ABISELECT(248,180), "S105C5.s105c5f15");
    check_field_offset(lv, s105c5f16, ABISELECT(256,184), "S105C5.s105c5f16");
    check_field_offset(lv, s105c5f17, ABISELECT(264,192), "S105C5.s105c5f17");
    check_field_offset(lv, s105c5f18, ABISELECT(272,200), "S105C5.s105c5f18");
    check_field_offset(lv, s105c5f19, ABISELECT(280,208), "S105C5.s105c5f19");
    check_field_offset(lv, s105c5f20, ABISELECT(288,216), "S105C5.s105c5f20");
    check_field_offset(lv, s105c5f21, ABISELECT(296,224), "S105C5.s105c5f21");
    check_field_offset(lv, s105c5f22, ABISELECT(304,232), "S105C5.s105c5f22");
    check_field_offset(lv, s105c5f23, ABISELECT(320,244), "S105C5.s105c5f23");
    check_field_offset(lv, s105c5f24, ABISELECT(336,256), "S105C5.s105c5f24");
    check_field_offset(lv, s105c5f25, ABISELECT(352,268), "S105C5.s105c5f25");
    check_field_offset(lv, s105c5f26, ABISELECT(368,280), "S105C5.s105c5f26");
    check_field_offset(lv, s105c5f27, ABISELECT(384,292), "S105C5.s105c5f27");
    check_field_offset(lv, s105c5f28, ABISELECT(400,304), "S105C5.s105c5f28");
    check_field_offset(lv, s105c5f29, ABISELECT(416,316), "S105C5.s105c5f29");
    check_field_offset(lv, s105c5f30, ABISELECT(432,328), "S105C5.s105c5f30");
    check_field_offset(lv, s105c5f31, ABISELECT(448,340), "S105C5.s105c5f31");
    test_class_info(&lv, &cd_S105C5);
    dp->~S105C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C5(Test_S105C5, "S105C5", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN6S105C5C1Ev();
extern void _ZN6S105C5D1Ev();
Name_Map name_map_S105C5[] = {
  NSPAIR(_ZN6S105C5C1Ev),
  NSPAIR(_ZN6S105C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
extern Class_Descriptor cd_S105C6;
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
static Base_Class bases_S105C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S105C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C5[];
extern void _ZN6S105C5D1Ev();
extern void _ZN6S105C5D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
extern void _ZN6S105C53v72Ev();
extern void _ZN6S105C53v73Ev();
extern void _ZN6S105C53v74Ev();
extern void _ZN6S105C53v75Ev();
extern void _ZN6S105C53v76Ev();
extern void _ZN6S105C53v77Ev();
extern void _ZN6S105C53v78Ev();
extern void _ZN6S105C53v79Ev();
extern void _ZN6S105C53v80Ev();
extern void _ZN6S105C53v81Ev();
extern void _ZN6S105C53v82Ev();
extern void _ZN6S105C53v83Ev();
extern void _ZN6S105C53v84Ev();
extern void _ZN6S105C53v85Ev();
extern void _ZN6S105C53v86Ev();
extern void _ZN6S105C53v87Ev();
extern void _ZN6S105C53v88Ev();
extern void _ZN6S105C53v89Ev();
extern void _ZN6S105C53v90Ev();
extern void _ZN6S105C53v91Ev();
extern void _ZN6S105C53v92Ev();
extern void _ZN6S105C53v93Ev();
extern void _ZN6S105C53v94Ev();
extern void _ZN6S105C53v95Ev();
extern void _ZN6S105C53v96Ev();
extern void _ZN6S105C53v97Ev();
extern void _ZN6S105C53v98Ev();
extern void _ZN6S105C53v99Ev();
extern void _ZN6S105C54v100Ev();
extern void _ZN6S105C54v101Ev();
extern void _ZN6S105C54v102Ev();
extern void _ZN6S105C54v103Ev();
extern void _ZN6S105C54v104Ev();
extern void _ZN6S105C54v105Ev();
extern void _ZN6S105C54v106Ev();
extern void _ZN6S105C54v107Ev();
extern void _ZN6S105C54v108Ev();
extern void _ZN6S105C54v109Ev();
extern void _ZN6S105C54v110Ev();
extern void _ZN6S105C54v111Ev();
extern void _ZN6S105C54v112Ev();
extern void _ZN6S105C54v113Ev();
extern void _ZN6S105C54v114Ev();
extern void _ZN6S105C54v115Ev();
extern void _ZN6S105C54v116Ev();
extern void _ZN6S105C54v117Ev();
extern void _ZN6S105C54v118Ev();
extern void _ZN6S105C54v119Ev();
extern void _ZN6S105C54v120Ev();
extern void _ZN6S105C54v121Ev();
extern void _ZN6S105C54v122Ev();
extern void _ZN6S105C54v123Ev();
extern void _ZN6S105C54v124Ev();
extern void _ZN6S105C54v125Ev();
extern void _ZN6S105C54v126Ev();
extern void _ZN6S105C54v127Ev();
extern void _ZN6S105C54v128Ev();
extern void _ZN6S105C54v129Ev();
extern void _ZN6S105C54v130Ev();
extern void _ZN6S105C54v131Ev();
extern void _ZN6S105C54v132Ev();
extern void _ZN6S105C54v133Ev();
extern void _ZN6S105C54v134Ev();
extern void _ZN6S105C54v135Ev();
extern void _ZN6S105C54v136Ev();
extern void _ZN6S105C54v137Ev();
extern void _ZN6S105C54v138Ev();
extern void _ZN6S105C54v139Ev();
extern void _ZN6S105C54v140Ev();
extern void _ZN6S105C54v141Ev();
extern void _ZN6S105C54v142Ev();
extern void _ZN6S105C54v143Ev();
extern void _ZN6S105C54v144Ev();
extern void _ZN6S105C54v145Ev();
extern void _ZN6S105C54v146Ev();
extern void _ZN6S105C54v147Ev();
static  VTBL_ENTRY vtc_S105C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C5[0]),
  (VTBL_ENTRY)&_ZN6S105C5D1Ev,
  (VTBL_ENTRY)&_ZN6S105C5D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
  (VTBL_ENTRY)&_ZN6S105C53v72Ev,
  (VTBL_ENTRY)&_ZN6S105C53v73Ev,
  (VTBL_ENTRY)&_ZN6S105C53v74Ev,
  (VTBL_ENTRY)&_ZN6S105C53v75Ev,
  (VTBL_ENTRY)&_ZN6S105C53v76Ev,
  (VTBL_ENTRY)&_ZN6S105C53v77Ev,
  (VTBL_ENTRY)&_ZN6S105C53v78Ev,
  (VTBL_ENTRY)&_ZN6S105C53v79Ev,
  (VTBL_ENTRY)&_ZN6S105C53v80Ev,
  (VTBL_ENTRY)&_ZN6S105C53v81Ev,
  (VTBL_ENTRY)&_ZN6S105C53v82Ev,
  (VTBL_ENTRY)&_ZN6S105C53v83Ev,
  (VTBL_ENTRY)&_ZN6S105C53v84Ev,
  (VTBL_ENTRY)&_ZN6S105C53v85Ev,
  (VTBL_ENTRY)&_ZN6S105C53v86Ev,
  (VTBL_ENTRY)&_ZN6S105C53v87Ev,
  (VTBL_ENTRY)&_ZN6S105C53v88Ev,
  (VTBL_ENTRY)&_ZN6S105C53v89Ev,
  (VTBL_ENTRY)&_ZN6S105C53v90Ev,
  (VTBL_ENTRY)&_ZN6S105C53v91Ev,
  (VTBL_ENTRY)&_ZN6S105C53v92Ev,
  (VTBL_ENTRY)&_ZN6S105C53v93Ev,
  (VTBL_ENTRY)&_ZN6S105C53v94Ev,
  (VTBL_ENTRY)&_ZN6S105C53v95Ev,
  (VTBL_ENTRY)&_ZN6S105C53v96Ev,
  (VTBL_ENTRY)&_ZN6S105C53v97Ev,
  (VTBL_ENTRY)&_ZN6S105C53v98Ev,
  (VTBL_ENTRY)&_ZN6S105C53v99Ev,
  (VTBL_ENTRY)&_ZN6S105C54v100Ev,
  (VTBL_ENTRY)&_ZN6S105C54v101Ev,
  (VTBL_ENTRY)&_ZN6S105C54v102Ev,
  (VTBL_ENTRY)&_ZN6S105C54v103Ev,
  (VTBL_ENTRY)&_ZN6S105C54v104Ev,
  (VTBL_ENTRY)&_ZN6S105C54v105Ev,
  (VTBL_ENTRY)&_ZN6S105C54v106Ev,
  (VTBL_ENTRY)&_ZN6S105C54v107Ev,
  (VTBL_ENTRY)&_ZN6S105C54v108Ev,
  (VTBL_ENTRY)&_ZN6S105C54v109Ev,
  (VTBL_ENTRY)&_ZN6S105C54v110Ev,
  (VTBL_ENTRY)&_ZN6S105C54v111Ev,
  (VTBL_ENTRY)&_ZN6S105C54v112Ev,
  (VTBL_ENTRY)&_ZN6S105C54v113Ev,
  (VTBL_ENTRY)&_ZN6S105C54v114Ev,
  (VTBL_ENTRY)&_ZN6S105C54v115Ev,
  (VTBL_ENTRY)&_ZN6S105C54v116Ev,
  (VTBL_ENTRY)&_ZN6S105C54v117Ev,
  (VTBL_ENTRY)&_ZN6S105C54v118Ev,
  (VTBL_ENTRY)&_ZN6S105C54v119Ev,
  (VTBL_ENTRY)&_ZN6S105C54v120Ev,
  (VTBL_ENTRY)&_ZN6S105C54v121Ev,
  (VTBL_ENTRY)&_ZN6S105C54v122Ev,
  (VTBL_ENTRY)&_ZN6S105C54v123Ev,
  (VTBL_ENTRY)&_ZN6S105C54v124Ev,
  (VTBL_ENTRY)&_ZN6S105C54v125Ev,
  (VTBL_ENTRY)&_ZN6S105C54v126Ev,
  (VTBL_ENTRY)&_ZN6S105C54v127Ev,
  (VTBL_ENTRY)&_ZN6S105C54v128Ev,
  (VTBL_ENTRY)&_ZN6S105C54v129Ev,
  (VTBL_ENTRY)&_ZN6S105C54v130Ev,
  (VTBL_ENTRY)&_ZN6S105C54v131Ev,
  (VTBL_ENTRY)&_ZN6S105C54v132Ev,
  (VTBL_ENTRY)&_ZN6S105C54v133Ev,
  (VTBL_ENTRY)&_ZN6S105C54v134Ev,
  (VTBL_ENTRY)&_ZN6S105C54v135Ev,
  (VTBL_ENTRY)&_ZN6S105C54v136Ev,
  (VTBL_ENTRY)&_ZN6S105C54v137Ev,
  (VTBL_ENTRY)&_ZN6S105C54v138Ev,
  (VTBL_ENTRY)&_ZN6S105C54v139Ev,
  (VTBL_ENTRY)&_ZN6S105C54v140Ev,
  (VTBL_ENTRY)&_ZN6S105C54v141Ev,
  (VTBL_ENTRY)&_ZN6S105C54v142Ev,
  (VTBL_ENTRY)&_ZN6S105C54v143Ev,
  (VTBL_ENTRY)&_ZN6S105C54v144Ev,
  (VTBL_ENTRY)&_ZN6S105C54v145Ev,
  (VTBL_ENTRY)&_ZN6S105C54v146Ev,
  (VTBL_ENTRY)&_ZN6S105C54v147Ev,
};
extern VTBL_ENTRY _ZTI6S105C5[];
extern  VTBL_ENTRY _ZTV6S105C5[];
Class_Descriptor cd_S105C5 = {  "S105C5", // class name
  bases_S105C5, 2,
  &(vtc_S105C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI6S105C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C5),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C4  : S105C5 {
  ::S85C27_nt s105c4f0;
  void *s105c4f1[9];
  ::S80C15 s105c4f2;
  ::S85C35 s105c4f3;
  ::S80C24 s105c4f4;
  int s105c4f5;
  unsigned int s105c4f6:1;
  unsigned int s105c4f7:1;
  unsigned int s105c4f8:1;
  unsigned int s105c4f9:1;
  unsigned int s105c4f10:1;
  unsigned int s105c4f11:1;
  unsigned int s105c4f12:1;
  unsigned int s105c4f13:1;
  unsigned int s105c4f14:1;
  unsigned int s105c4f15:1;
  unsigned int s105c4f16:1;
  unsigned int s105c4f17:1;
  unsigned int s105c4f18:1;
  unsigned int s105c4f19:1;
  unsigned int s105c4f20:1;
  unsigned int s105c4f21:1;
  unsigned int s105c4f22:1;
  unsigned int s105c4f23:1;
  unsigned int s105c4f24:1;
  unsigned int s105c4f25:1;
  unsigned int s105c4f26:1;
  unsigned int s105c4f27:1;
  void *s105c4f28;
  char s105c4f29[2];
  ::S80C8_nt s105c4f30;
  ::S85C27_nt s105c4f31;
  ::S85C27_nt s105c4f32;
  void *s105c4f33;
  ::S80C21_nt s105c4f34;
  ::S80C21_nt s105c4f35;
  ::S80C21_nt s105c4f36;
  ::S80C21_nt s105c4f37;
  ::S80C21_nt s105c4f38;
  virtual  ~S105C4(); // _ZN6S105C4D1Ev
  virtual void  v148(); // _ZN6S105C44v148Ev
  virtual void  v149(); // _ZN6S105C44v149Ev
  virtual void  v150(); // _ZN6S105C44v150Ev
  virtual void  v151(); // _ZN6S105C44v151Ev
  virtual void  v152(); // _ZN6S105C44v152Ev
  virtual void  v153(); // _ZN6S105C44v153Ev
  virtual void  v154(); // _ZN6S105C44v154Ev
  virtual void  v155(); // _ZN6S105C44v155Ev
  virtual void  v156(); // _ZN6S105C44v156Ev
  virtual void  v157(); // _ZN6S105C44v157Ev
  virtual void  v158(); // _ZN6S105C44v158Ev
  virtual void  v159(); // _ZN6S105C44v159Ev
  virtual void  v160(); // _ZN6S105C44v160Ev
  virtual void  v161(); // _ZN6S105C44v161Ev
  virtual void  v162(); // _ZN6S105C44v162Ev
  virtual void  v163(); // _ZN6S105C44v163Ev
  virtual void  v164(); // _ZN6S105C44v164Ev
  virtual void  v165(); // _ZN6S105C44v165Ev
  virtual void  v166(); // _ZN6S105C44v166Ev
  virtual void  v167(); // _ZN6S105C44v167Ev
  virtual void  v168(); // _ZN6S105C44v168Ev
  virtual void  v169(); // _ZN6S105C44v169Ev
  virtual void  v170(); // _ZN6S105C44v170Ev
  virtual void  v171(); // _ZN6S105C44v171Ev
  virtual void  v172(); // _ZN6S105C44v172Ev
  virtual void  v173(); // _ZN6S105C44v173Ev
  virtual void  v174(); // _ZN6S105C44v174Ev
  virtual void  v175(); // _ZN6S105C44v175Ev
  virtual void  v176(); // _ZN6S105C44v176Ev
  virtual void  v177(); // _ZN6S105C44v177Ev
  virtual void  v178(); // _ZN6S105C44v178Ev
  virtual void  v179(); // _ZN6S105C44v179Ev
  virtual void  v180(); // _ZN6S105C44v180Ev
  virtual void  v181(); // _ZN6S105C44v181Ev
  virtual void  v182(); // _ZN6S105C44v182Ev
  virtual void  v183(); // _ZN6S105C44v183Ev
  virtual void  v184(); // _ZN6S105C44v184Ev
  virtual void  v185(); // _ZN6S105C44v185Ev
  virtual void  v186(); // _ZN6S105C44v186Ev
  S105C4(); // tgen
};
//SIG(-1 S105C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC19{ m Fi[2]}} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC20{ BC21{ BC9}} FC7 FC22{ BC23{ m FC24{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC19 FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S105C4 ::~S105C4(){ note_dtor("S105C4", this);}
void  S105C4 ::v148(){vfunc_called(this, "_ZN6S105C44v148Ev");}
void  S105C4 ::v149(){vfunc_called(this, "_ZN6S105C44v149Ev");}
void  S105C4 ::v150(){vfunc_called(this, "_ZN6S105C44v150Ev");}
void  S105C4 ::v151(){vfunc_called(this, "_ZN6S105C44v151Ev");}
void  S105C4 ::v152(){vfunc_called(this, "_ZN6S105C44v152Ev");}
void  S105C4 ::v153(){vfunc_called(this, "_ZN6S105C44v153Ev");}
void  S105C4 ::v154(){vfunc_called(this, "_ZN6S105C44v154Ev");}
void  S105C4 ::v155(){vfunc_called(this, "_ZN6S105C44v155Ev");}
void  S105C4 ::v156(){vfunc_called(this, "_ZN6S105C44v156Ev");}
void  S105C4 ::v157(){vfunc_called(this, "_ZN6S105C44v157Ev");}
void  S105C4 ::v158(){vfunc_called(this, "_ZN6S105C44v158Ev");}
void  S105C4 ::v159(){vfunc_called(this, "_ZN6S105C44v159Ev");}
void  S105C4 ::v160(){vfunc_called(this, "_ZN6S105C44v160Ev");}
void  S105C4 ::v161(){vfunc_called(this, "_ZN6S105C44v161Ev");}
void  S105C4 ::v162(){vfunc_called(this, "_ZN6S105C44v162Ev");}
void  S105C4 ::v163(){vfunc_called(this, "_ZN6S105C44v163Ev");}
void  S105C4 ::v164(){vfunc_called(this, "_ZN6S105C44v164Ev");}
void  S105C4 ::v165(){vfunc_called(this, "_ZN6S105C44v165Ev");}
void  S105C4 ::v166(){vfunc_called(this, "_ZN6S105C44v166Ev");}
void  S105C4 ::v167(){vfunc_called(this, "_ZN6S105C44v167Ev");}
void  S105C4 ::v168(){vfunc_called(this, "_ZN6S105C44v168Ev");}
void  S105C4 ::v169(){vfunc_called(this, "_ZN6S105C44v169Ev");}
void  S105C4 ::v170(){vfunc_called(this, "_ZN6S105C44v170Ev");}
void  S105C4 ::v171(){vfunc_called(this, "_ZN6S105C44v171Ev");}
void  S105C4 ::v172(){vfunc_called(this, "_ZN6S105C44v172Ev");}
void  S105C4 ::v173(){vfunc_called(this, "_ZN6S105C44v173Ev");}
void  S105C4 ::v174(){vfunc_called(this, "_ZN6S105C44v174Ev");}
void  S105C4 ::v175(){vfunc_called(this, "_ZN6S105C44v175Ev");}
void  S105C4 ::v176(){vfunc_called(this, "_ZN6S105C44v176Ev");}
void  S105C4 ::v177(){vfunc_called(this, "_ZN6S105C44v177Ev");}
void  S105C4 ::v178(){vfunc_called(this, "_ZN6S105C44v178Ev");}
void  S105C4 ::v179(){vfunc_called(this, "_ZN6S105C44v179Ev");}
void  S105C4 ::v180(){vfunc_called(this, "_ZN6S105C44v180Ev");}
void  S105C4 ::v181(){vfunc_called(this, "_ZN6S105C44v181Ev");}
void  S105C4 ::v182(){vfunc_called(this, "_ZN6S105C44v182Ev");}
void  S105C4 ::v183(){vfunc_called(this, "_ZN6S105C44v183Ev");}
void  S105C4 ::v184(){vfunc_called(this, "_ZN6S105C44v184Ev");}
void  S105C4 ::v185(){vfunc_called(this, "_ZN6S105C44v185Ev");}
void  S105C4 ::v186(){vfunc_called(this, "_ZN6S105C44v186Ev");}
S105C4 ::S105C4(){ note_ctor("S105C4", this);} // tgen

static void Test_S105C4()
{
  extern Class_Descriptor cd_S105C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S105C4, buf);
    S105C4 *dp, &lv = *(dp=new (buf) S105C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S105C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C4)");
    check_base_class_offset(lv, (S105C7*)(S105C6*)(S105C5*), 0, "S105C4");
    check_base_class_offset(lv, (S105C6*)(S105C5*), 0, "S105C4");
    check_base_class_offset(lv, (S105C5*), 0, "S105C4");
    check_field_offset(lv, s105c4f0, ABISELECT(464,352), "S105C4.s105c4f0");
    check_field_offset(lv, s105c4f1, ABISELECT(472,360), "S105C4.s105c4f1");
    check_field_offset(lv, s105c4f2, ABISELECT(544,396), "S105C4.s105c4f2");
    check_field_offset(lv, s105c4f3, ABISELECT(560,408), "S105C4.s105c4f3");
    check_field_offset(lv, s105c4f4, ABISELECT(576,420), "S105C4.s105c4f4");
    check_field_offset(lv, s105c4f5, ABISELECT(608,440), "S105C4.s105c4f5");
    set_bf_and_test(lv, s105c4f6, ABISELECT(612,444), 0, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f7, ABISELECT(612,444), 1, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f8, ABISELECT(612,444), 2, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f9, ABISELECT(612,444), 3, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f10, ABISELECT(612,444), 4, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f11, ABISELECT(612,444), 5, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f12, ABISELECT(612,444), 6, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f13, ABISELECT(612,444), 7, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f14, ABISELECT(613,445), 0, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f15, ABISELECT(613,445), 1, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f16, ABISELECT(613,445), 2, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f17, ABISELECT(613,445), 3, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f18, ABISELECT(613,445), 4, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f19, ABISELECT(613,445), 5, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f20, ABISELECT(613,445), 6, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f21, ABISELECT(613,445), 7, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f22, ABISELECT(614,446), 0, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f23, ABISELECT(614,446), 1, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f24, ABISELECT(614,446), 2, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f25, ABISELECT(614,446), 3, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f26, ABISELECT(614,446), 4, 1, 1, "S105C4");
    set_bf_and_test(lv, s105c4f27, ABISELECT(614,446), 5, 1, 1, "S105C4");
    check_field_offset(lv, s105c4f28, ABISELECT(616,448), "S105C4.s105c4f28");
    check_field_offset(lv, s105c4f29, ABISELECT(624,452), "S105C4.s105c4f29");
    check_field_offset(lv, s105c4f30, ABISELECT(628,456), "S105C4.s105c4f30");
    check_field_offset(lv, s105c4f31, ABISELECT(636,464), "S105C4.s105c4f31");
    check_field_offset(lv, s105c4f32, ABISELECT(644,472), "S105C4.s105c4f32");
    check_field_offset(lv, s105c4f33, ABISELECT(656,480), "S105C4.s105c4f33");
    check_field_offset(lv, s105c4f34, ABISELECT(664,484), "S105C4.s105c4f34");
    check_field_offset(lv, s105c4f35, ABISELECT(680,496), "S105C4.s105c4f35");
    check_field_offset(lv, s105c4f36, ABISELECT(696,508), "S105C4.s105c4f36");
    check_field_offset(lv, s105c4f37, ABISELECT(712,520), "S105C4.s105c4f37");
    check_field_offset(lv, s105c4f38, ABISELECT(728,532), "S105C4.s105c4f38");
    test_class_info(&lv, &cd_S105C4);
    dp->~S105C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C4(Test_S105C4, "S105C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN6S105C4C1Ev();
extern void _ZN6S105C4D1Ev();
Name_Map name_map_S105C4[] = {
  NSPAIR(_ZN6S105C4C1Ev),
  NSPAIR(_ZN6S105C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
extern Class_Descriptor cd_S105C6;
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
extern Class_Descriptor cd_S105C5;
extern VTBL_ENTRY _ZTI6S105C5[];
extern  VTBL_ENTRY _ZTV6S105C5[];
static Base_Class bases_S105C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S105C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S105C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C4[];
extern void _ZN6S105C4D1Ev();
extern void _ZN6S105C4D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
extern void _ZN6S105C53v72Ev();
extern void _ZN6S105C53v73Ev();
extern void _ZN6S105C53v74Ev();
extern void _ZN6S105C53v75Ev();
extern void _ZN6S105C53v76Ev();
extern void _ZN6S105C53v77Ev();
extern void _ZN6S105C53v78Ev();
extern void _ZN6S105C53v79Ev();
extern void _ZN6S105C53v80Ev();
extern void _ZN6S105C53v81Ev();
extern void _ZN6S105C53v82Ev();
extern void _ZN6S105C53v83Ev();
extern void _ZN6S105C53v84Ev();
extern void _ZN6S105C53v85Ev();
extern void _ZN6S105C53v86Ev();
extern void _ZN6S105C53v87Ev();
extern void _ZN6S105C53v88Ev();
extern void _ZN6S105C53v89Ev();
extern void _ZN6S105C53v90Ev();
extern void _ZN6S105C53v91Ev();
extern void _ZN6S105C53v92Ev();
extern void _ZN6S105C53v93Ev();
extern void _ZN6S105C53v94Ev();
extern void _ZN6S105C53v95Ev();
extern void _ZN6S105C53v96Ev();
extern void _ZN6S105C53v97Ev();
extern void _ZN6S105C53v98Ev();
extern void _ZN6S105C53v99Ev();
extern void _ZN6S105C54v100Ev();
extern void _ZN6S105C54v101Ev();
extern void _ZN6S105C54v102Ev();
extern void _ZN6S105C54v103Ev();
extern void _ZN6S105C54v104Ev();
extern void _ZN6S105C54v105Ev();
extern void _ZN6S105C54v106Ev();
extern void _ZN6S105C54v107Ev();
extern void _ZN6S105C54v108Ev();
extern void _ZN6S105C54v109Ev();
extern void _ZN6S105C54v110Ev();
extern void _ZN6S105C54v111Ev();
extern void _ZN6S105C54v112Ev();
extern void _ZN6S105C54v113Ev();
extern void _ZN6S105C54v114Ev();
extern void _ZN6S105C54v115Ev();
extern void _ZN6S105C54v116Ev();
extern void _ZN6S105C54v117Ev();
extern void _ZN6S105C54v118Ev();
extern void _ZN6S105C54v119Ev();
extern void _ZN6S105C54v120Ev();
extern void _ZN6S105C54v121Ev();
extern void _ZN6S105C54v122Ev();
extern void _ZN6S105C54v123Ev();
extern void _ZN6S105C54v124Ev();
extern void _ZN6S105C54v125Ev();
extern void _ZN6S105C54v126Ev();
extern void _ZN6S105C54v127Ev();
extern void _ZN6S105C54v128Ev();
extern void _ZN6S105C54v129Ev();
extern void _ZN6S105C54v130Ev();
extern void _ZN6S105C54v131Ev();
extern void _ZN6S105C54v132Ev();
extern void _ZN6S105C54v133Ev();
extern void _ZN6S105C54v134Ev();
extern void _ZN6S105C54v135Ev();
extern void _ZN6S105C54v136Ev();
extern void _ZN6S105C54v137Ev();
extern void _ZN6S105C54v138Ev();
extern void _ZN6S105C54v139Ev();
extern void _ZN6S105C54v140Ev();
extern void _ZN6S105C54v141Ev();
extern void _ZN6S105C54v142Ev();
extern void _ZN6S105C54v143Ev();
extern void _ZN6S105C54v144Ev();
extern void _ZN6S105C54v145Ev();
extern void _ZN6S105C54v146Ev();
extern void _ZN6S105C54v147Ev();
extern void _ZN6S105C44v148Ev();
extern void _ZN6S105C44v149Ev();
extern void _ZN6S105C44v150Ev();
extern void _ZN6S105C44v151Ev();
extern void _ZN6S105C44v152Ev();
extern void _ZN6S105C44v153Ev();
extern void _ZN6S105C44v154Ev();
extern void _ZN6S105C44v155Ev();
extern void _ZN6S105C44v156Ev();
extern void _ZN6S105C44v157Ev();
extern void _ZN6S105C44v158Ev();
extern void _ZN6S105C44v159Ev();
extern void _ZN6S105C44v160Ev();
extern void _ZN6S105C44v161Ev();
extern void _ZN6S105C44v162Ev();
extern void _ZN6S105C44v163Ev();
extern void _ZN6S105C44v164Ev();
extern void _ZN6S105C44v165Ev();
extern void _ZN6S105C44v166Ev();
extern void _ZN6S105C44v167Ev();
extern void _ZN6S105C44v168Ev();
extern void _ZN6S105C44v169Ev();
extern void _ZN6S105C44v170Ev();
extern void _ZN6S105C44v171Ev();
extern void _ZN6S105C44v172Ev();
extern void _ZN6S105C44v173Ev();
extern void _ZN6S105C44v174Ev();
extern void _ZN6S105C44v175Ev();
extern void _ZN6S105C44v176Ev();
extern void _ZN6S105C44v177Ev();
extern void _ZN6S105C44v178Ev();
extern void _ZN6S105C44v179Ev();
extern void _ZN6S105C44v180Ev();
extern void _ZN6S105C44v181Ev();
extern void _ZN6S105C44v182Ev();
extern void _ZN6S105C44v183Ev();
extern void _ZN6S105C44v184Ev();
extern void _ZN6S105C44v185Ev();
extern void _ZN6S105C44v186Ev();
static  VTBL_ENTRY vtc_S105C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C4[0]),
  (VTBL_ENTRY)&_ZN6S105C4D1Ev,
  (VTBL_ENTRY)&_ZN6S105C4D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
  (VTBL_ENTRY)&_ZN6S105C53v72Ev,
  (VTBL_ENTRY)&_ZN6S105C53v73Ev,
  (VTBL_ENTRY)&_ZN6S105C53v74Ev,
  (VTBL_ENTRY)&_ZN6S105C53v75Ev,
  (VTBL_ENTRY)&_ZN6S105C53v76Ev,
  (VTBL_ENTRY)&_ZN6S105C53v77Ev,
  (VTBL_ENTRY)&_ZN6S105C53v78Ev,
  (VTBL_ENTRY)&_ZN6S105C53v79Ev,
  (VTBL_ENTRY)&_ZN6S105C53v80Ev,
  (VTBL_ENTRY)&_ZN6S105C53v81Ev,
  (VTBL_ENTRY)&_ZN6S105C53v82Ev,
  (VTBL_ENTRY)&_ZN6S105C53v83Ev,
  (VTBL_ENTRY)&_ZN6S105C53v84Ev,
  (VTBL_ENTRY)&_ZN6S105C53v85Ev,
  (VTBL_ENTRY)&_ZN6S105C53v86Ev,
  (VTBL_ENTRY)&_ZN6S105C53v87Ev,
  (VTBL_ENTRY)&_ZN6S105C53v88Ev,
  (VTBL_ENTRY)&_ZN6S105C53v89Ev,
  (VTBL_ENTRY)&_ZN6S105C53v90Ev,
  (VTBL_ENTRY)&_ZN6S105C53v91Ev,
  (VTBL_ENTRY)&_ZN6S105C53v92Ev,
  (VTBL_ENTRY)&_ZN6S105C53v93Ev,
  (VTBL_ENTRY)&_ZN6S105C53v94Ev,
  (VTBL_ENTRY)&_ZN6S105C53v95Ev,
  (VTBL_ENTRY)&_ZN6S105C53v96Ev,
  (VTBL_ENTRY)&_ZN6S105C53v97Ev,
  (VTBL_ENTRY)&_ZN6S105C53v98Ev,
  (VTBL_ENTRY)&_ZN6S105C53v99Ev,
  (VTBL_ENTRY)&_ZN6S105C54v100Ev,
  (VTBL_ENTRY)&_ZN6S105C54v101Ev,
  (VTBL_ENTRY)&_ZN6S105C54v102Ev,
  (VTBL_ENTRY)&_ZN6S105C54v103Ev,
  (VTBL_ENTRY)&_ZN6S105C54v104Ev,
  (VTBL_ENTRY)&_ZN6S105C54v105Ev,
  (VTBL_ENTRY)&_ZN6S105C54v106Ev,
  (VTBL_ENTRY)&_ZN6S105C54v107Ev,
  (VTBL_ENTRY)&_ZN6S105C54v108Ev,
  (VTBL_ENTRY)&_ZN6S105C54v109Ev,
  (VTBL_ENTRY)&_ZN6S105C54v110Ev,
  (VTBL_ENTRY)&_ZN6S105C54v111Ev,
  (VTBL_ENTRY)&_ZN6S105C54v112Ev,
  (VTBL_ENTRY)&_ZN6S105C54v113Ev,
  (VTBL_ENTRY)&_ZN6S105C54v114Ev,
  (VTBL_ENTRY)&_ZN6S105C54v115Ev,
  (VTBL_ENTRY)&_ZN6S105C54v116Ev,
  (VTBL_ENTRY)&_ZN6S105C54v117Ev,
  (VTBL_ENTRY)&_ZN6S105C54v118Ev,
  (VTBL_ENTRY)&_ZN6S105C54v119Ev,
  (VTBL_ENTRY)&_ZN6S105C54v120Ev,
  (VTBL_ENTRY)&_ZN6S105C54v121Ev,
  (VTBL_ENTRY)&_ZN6S105C54v122Ev,
  (VTBL_ENTRY)&_ZN6S105C54v123Ev,
  (VTBL_ENTRY)&_ZN6S105C54v124Ev,
  (VTBL_ENTRY)&_ZN6S105C54v125Ev,
  (VTBL_ENTRY)&_ZN6S105C54v126Ev,
  (VTBL_ENTRY)&_ZN6S105C54v127Ev,
  (VTBL_ENTRY)&_ZN6S105C54v128Ev,
  (VTBL_ENTRY)&_ZN6S105C54v129Ev,
  (VTBL_ENTRY)&_ZN6S105C54v130Ev,
  (VTBL_ENTRY)&_ZN6S105C54v131Ev,
  (VTBL_ENTRY)&_ZN6S105C54v132Ev,
  (VTBL_ENTRY)&_ZN6S105C54v133Ev,
  (VTBL_ENTRY)&_ZN6S105C54v134Ev,
  (VTBL_ENTRY)&_ZN6S105C54v135Ev,
  (VTBL_ENTRY)&_ZN6S105C54v136Ev,
  (VTBL_ENTRY)&_ZN6S105C54v137Ev,
  (VTBL_ENTRY)&_ZN6S105C54v138Ev,
  (VTBL_ENTRY)&_ZN6S105C54v139Ev,
  (VTBL_ENTRY)&_ZN6S105C54v140Ev,
  (VTBL_ENTRY)&_ZN6S105C54v141Ev,
  (VTBL_ENTRY)&_ZN6S105C54v142Ev,
  (VTBL_ENTRY)&_ZN6S105C54v143Ev,
  (VTBL_ENTRY)&_ZN6S105C54v144Ev,
  (VTBL_ENTRY)&_ZN6S105C54v145Ev,
  (VTBL_ENTRY)&_ZN6S105C54v146Ev,
  (VTBL_ENTRY)&_ZN6S105C54v147Ev,
  (VTBL_ENTRY)&_ZN6S105C44v148Ev,
  (VTBL_ENTRY)&_ZN6S105C44v149Ev,
  (VTBL_ENTRY)&_ZN6S105C44v150Ev,
  (VTBL_ENTRY)&_ZN6S105C44v151Ev,
  (VTBL_ENTRY)&_ZN6S105C44v152Ev,
  (VTBL_ENTRY)&_ZN6S105C44v153Ev,
  (VTBL_ENTRY)&_ZN6S105C44v154Ev,
  (VTBL_ENTRY)&_ZN6S105C44v155Ev,
  (VTBL_ENTRY)&_ZN6S105C44v156Ev,
  (VTBL_ENTRY)&_ZN6S105C44v157Ev,
  (VTBL_ENTRY)&_ZN6S105C44v158Ev,
  (VTBL_ENTRY)&_ZN6S105C44v159Ev,
  (VTBL_ENTRY)&_ZN6S105C44v160Ev,
  (VTBL_ENTRY)&_ZN6S105C44v161Ev,
  (VTBL_ENTRY)&_ZN6S105C44v162Ev,
  (VTBL_ENTRY)&_ZN6S105C44v163Ev,
  (VTBL_ENTRY)&_ZN6S105C44v164Ev,
  (VTBL_ENTRY)&_ZN6S105C44v165Ev,
  (VTBL_ENTRY)&_ZN6S105C44v166Ev,
  (VTBL_ENTRY)&_ZN6S105C44v167Ev,
  (VTBL_ENTRY)&_ZN6S105C44v168Ev,
  (VTBL_ENTRY)&_ZN6S105C44v169Ev,
  (VTBL_ENTRY)&_ZN6S105C44v170Ev,
  (VTBL_ENTRY)&_ZN6S105C44v171Ev,
  (VTBL_ENTRY)&_ZN6S105C44v172Ev,
  (VTBL_ENTRY)&_ZN6S105C44v173Ev,
  (VTBL_ENTRY)&_ZN6S105C44v174Ev,
  (VTBL_ENTRY)&_ZN6S105C44v175Ev,
  (VTBL_ENTRY)&_ZN6S105C44v176Ev,
  (VTBL_ENTRY)&_ZN6S105C44v177Ev,
  (VTBL_ENTRY)&_ZN6S105C44v178Ev,
  (VTBL_ENTRY)&_ZN6S105C44v179Ev,
  (VTBL_ENTRY)&_ZN6S105C44v180Ev,
  (VTBL_ENTRY)&_ZN6S105C44v181Ev,
  (VTBL_ENTRY)&_ZN6S105C44v182Ev,
  (VTBL_ENTRY)&_ZN6S105C44v183Ev,
  (VTBL_ENTRY)&_ZN6S105C44v184Ev,
  (VTBL_ENTRY)&_ZN6S105C44v185Ev,
  (VTBL_ENTRY)&_ZN6S105C44v186Ev,
};
extern VTBL_ENTRY _ZTI6S105C4[];
extern  VTBL_ENTRY _ZTV6S105C4[];
Class_Descriptor cd_S105C4 = {  "S105C4", // class name
  bases_S105C4, 3,
  &(vtc_S105C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI6S105C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C3  : S105C4 {
  unsigned int s105c3f0:1;
  unsigned int s105c3f1:1;
  unsigned int s105c3f2:1;
  unsigned int s105c3f3:1;
  unsigned int s105c3f4:1;
  unsigned int s105c3f5:1;
  void *s105c3f6[8];
  ::S80C21_nt s105c3f7;
  ::S80C21_nt s105c3f8;
  ::S80C21_nt s105c3f9;
  virtual  ~S105C3(); // _ZN6S105C3D1Ev
  virtual void  v187(); // _ZN6S105C34v187Ev
  virtual void  v188(); // _ZN6S105C34v188Ev
  virtual void  v189(); // _ZN6S105C34v189Ev
  virtual void  v190(); // _ZN6S105C34v190Ev
  virtual void  v191(); // _ZN6S105C34v191Ev
  virtual void  v192(); // _ZN6S105C34v192Ev
  virtual void  v193(); // _ZN6S105C34v193Ev
  virtual void  v194(); // _ZN6S105C34v194Ev
  virtual void  v195(); // _ZN6S105C34v195Ev
  virtual void  v196(); // _ZN6S105C34v196Ev
  virtual void  v197(); // _ZN6S105C34v197Ev
  virtual void  v198(); // _ZN6S105C34v198Ev
  virtual void  v199(); // _ZN6S105C34v199Ev
  virtual void  v200(); // _ZN6S105C34v200Ev
  virtual void  v201(); // _ZN6S105C34v201Ev
  virtual void  v202(); // _ZN6S105C34v202Ev
  virtual void  v203(); // _ZN6S105C34v203Ev
  virtual void  v204(); // _ZN6S105C34v204Ev
  virtual void  v205(); // _ZN6S105C34v205Ev
  virtual void  v206(); // _ZN6S105C34v206Ev
  virtual void  v207(); // _ZN6S105C34v207Ev
  virtual void  v208(); // _ZN6S105C34v208Ev
  virtual void  v209(); // _ZN6S105C34v209Ev
  S105C3(); // tgen
};
//SIG(-1 S105C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC20{ m Fi[2]}} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC21{ BC22{ BC10}} FC8 FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC20 FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S105C3 ::~S105C3(){ note_dtor("S105C3", this);}
void  S105C3 ::v187(){vfunc_called(this, "_ZN6S105C34v187Ev");}
void  S105C3 ::v188(){vfunc_called(this, "_ZN6S105C34v188Ev");}
void  S105C3 ::v189(){vfunc_called(this, "_ZN6S105C34v189Ev");}
void  S105C3 ::v190(){vfunc_called(this, "_ZN6S105C34v190Ev");}
void  S105C3 ::v191(){vfunc_called(this, "_ZN6S105C34v191Ev");}
void  S105C3 ::v192(){vfunc_called(this, "_ZN6S105C34v192Ev");}
void  S105C3 ::v193(){vfunc_called(this, "_ZN6S105C34v193Ev");}
void  S105C3 ::v194(){vfunc_called(this, "_ZN6S105C34v194Ev");}
void  S105C3 ::v195(){vfunc_called(this, "_ZN6S105C34v195Ev");}
void  S105C3 ::v196(){vfunc_called(this, "_ZN6S105C34v196Ev");}
void  S105C3 ::v197(){vfunc_called(this, "_ZN6S105C34v197Ev");}
void  S105C3 ::v198(){vfunc_called(this, "_ZN6S105C34v198Ev");}
void  S105C3 ::v199(){vfunc_called(this, "_ZN6S105C34v199Ev");}
void  S105C3 ::v200(){vfunc_called(this, "_ZN6S105C34v200Ev");}
void  S105C3 ::v201(){vfunc_called(this, "_ZN6S105C34v201Ev");}
void  S105C3 ::v202(){vfunc_called(this, "_ZN6S105C34v202Ev");}
void  S105C3 ::v203(){vfunc_called(this, "_ZN6S105C34v203Ev");}
void  S105C3 ::v204(){vfunc_called(this, "_ZN6S105C34v204Ev");}
void  S105C3 ::v205(){vfunc_called(this, "_ZN6S105C34v205Ev");}
void  S105C3 ::v206(){vfunc_called(this, "_ZN6S105C34v206Ev");}
void  S105C3 ::v207(){vfunc_called(this, "_ZN6S105C34v207Ev");}
void  S105C3 ::v208(){vfunc_called(this, "_ZN6S105C34v208Ev");}
void  S105C3 ::v209(){vfunc_called(this, "_ZN6S105C34v209Ev");}
S105C3 ::S105C3(){ note_ctor("S105C3", this);} // tgen

static void Test_S105C3()
{
  extern Class_Descriptor cd_S105C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S105C3, buf);
    S105C3 *dp, &lv = *(dp=new (buf) S105C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S105C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C3)");
    check_base_class_offset(lv, (S105C7*)(S105C6*)(S105C5*)(S105C4*), 0, "S105C3");
    check_base_class_offset(lv, (S105C6*)(S105C5*)(S105C4*), 0, "S105C3");
    check_base_class_offset(lv, (S105C5*)(S105C4*), 0, "S105C3");
    check_base_class_offset(lv, (S105C4*), 0, "S105C3");
    set_bf_and_test(lv, s105c3f0, ABISELECT(744,544), 0, 1, 1, "S105C3");
    set_bf_and_test(lv, s105c3f1, ABISELECT(744,544), 1, 1, 1, "S105C3");
    set_bf_and_test(lv, s105c3f2, ABISELECT(744,544), 2, 1, 1, "S105C3");
    set_bf_and_test(lv, s105c3f3, ABISELECT(744,544), 3, 1, 1, "S105C3");
    set_bf_and_test(lv, s105c3f4, ABISELECT(744,544), 4, 1, 1, "S105C3");
    set_bf_and_test(lv, s105c3f5, ABISELECT(744,544), 5, 1, 1, "S105C3");
    check_field_offset(lv, s105c3f6, ABISELECT(752,548), "S105C3.s105c3f6");
    check_field_offset(lv, s105c3f7, ABISELECT(816,580), "S105C3.s105c3f7");
    check_field_offset(lv, s105c3f8, ABISELECT(832,592), "S105C3.s105c3f8");
    check_field_offset(lv, s105c3f9, ABISELECT(848,604), "S105C3.s105c3f9");
    test_class_info(&lv, &cd_S105C3);
    dp->~S105C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C3(Test_S105C3, "S105C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN6S105C3C1Ev();
extern void _ZN6S105C3D1Ev();
Name_Map name_map_S105C3[] = {
  NSPAIR(_ZN6S105C3C1Ev),
  NSPAIR(_ZN6S105C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
extern Class_Descriptor cd_S105C6;
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
extern Class_Descriptor cd_S105C5;
extern VTBL_ENTRY _ZTI6S105C5[];
extern  VTBL_ENTRY _ZTV6S105C5[];
extern Class_Descriptor cd_S105C4;
extern VTBL_ENTRY _ZTI6S105C4[];
extern  VTBL_ENTRY _ZTV6S105C4[];
static Base_Class bases_S105C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S105C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S105C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S105C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C3[];
extern void _ZN6S105C3D1Ev();
extern void _ZN6S105C3D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
extern void _ZN6S105C53v72Ev();
extern void _ZN6S105C53v73Ev();
extern void _ZN6S105C53v74Ev();
extern void _ZN6S105C53v75Ev();
extern void _ZN6S105C53v76Ev();
extern void _ZN6S105C53v77Ev();
extern void _ZN6S105C53v78Ev();
extern void _ZN6S105C53v79Ev();
extern void _ZN6S105C53v80Ev();
extern void _ZN6S105C53v81Ev();
extern void _ZN6S105C53v82Ev();
extern void _ZN6S105C53v83Ev();
extern void _ZN6S105C53v84Ev();
extern void _ZN6S105C53v85Ev();
extern void _ZN6S105C53v86Ev();
extern void _ZN6S105C53v87Ev();
extern void _ZN6S105C53v88Ev();
extern void _ZN6S105C53v89Ev();
extern void _ZN6S105C53v90Ev();
extern void _ZN6S105C53v91Ev();
extern void _ZN6S105C53v92Ev();
extern void _ZN6S105C53v93Ev();
extern void _ZN6S105C53v94Ev();
extern void _ZN6S105C53v95Ev();
extern void _ZN6S105C53v96Ev();
extern void _ZN6S105C53v97Ev();
extern void _ZN6S105C53v98Ev();
extern void _ZN6S105C53v99Ev();
extern void _ZN6S105C54v100Ev();
extern void _ZN6S105C54v101Ev();
extern void _ZN6S105C54v102Ev();
extern void _ZN6S105C54v103Ev();
extern void _ZN6S105C54v104Ev();
extern void _ZN6S105C54v105Ev();
extern void _ZN6S105C54v106Ev();
extern void _ZN6S105C54v107Ev();
extern void _ZN6S105C54v108Ev();
extern void _ZN6S105C54v109Ev();
extern void _ZN6S105C54v110Ev();
extern void _ZN6S105C54v111Ev();
extern void _ZN6S105C54v112Ev();
extern void _ZN6S105C54v113Ev();
extern void _ZN6S105C54v114Ev();
extern void _ZN6S105C54v115Ev();
extern void _ZN6S105C54v116Ev();
extern void _ZN6S105C54v117Ev();
extern void _ZN6S105C54v118Ev();
extern void _ZN6S105C54v119Ev();
extern void _ZN6S105C54v120Ev();
extern void _ZN6S105C54v121Ev();
extern void _ZN6S105C54v122Ev();
extern void _ZN6S105C54v123Ev();
extern void _ZN6S105C54v124Ev();
extern void _ZN6S105C54v125Ev();
extern void _ZN6S105C54v126Ev();
extern void _ZN6S105C54v127Ev();
extern void _ZN6S105C54v128Ev();
extern void _ZN6S105C54v129Ev();
extern void _ZN6S105C54v130Ev();
extern void _ZN6S105C54v131Ev();
extern void _ZN6S105C54v132Ev();
extern void _ZN6S105C54v133Ev();
extern void _ZN6S105C54v134Ev();
extern void _ZN6S105C54v135Ev();
extern void _ZN6S105C54v136Ev();
extern void _ZN6S105C54v137Ev();
extern void _ZN6S105C54v138Ev();
extern void _ZN6S105C54v139Ev();
extern void _ZN6S105C54v140Ev();
extern void _ZN6S105C54v141Ev();
extern void _ZN6S105C54v142Ev();
extern void _ZN6S105C54v143Ev();
extern void _ZN6S105C54v144Ev();
extern void _ZN6S105C54v145Ev();
extern void _ZN6S105C54v146Ev();
extern void _ZN6S105C54v147Ev();
extern void _ZN6S105C44v148Ev();
extern void _ZN6S105C44v149Ev();
extern void _ZN6S105C44v150Ev();
extern void _ZN6S105C44v151Ev();
extern void _ZN6S105C44v152Ev();
extern void _ZN6S105C44v153Ev();
extern void _ZN6S105C44v154Ev();
extern void _ZN6S105C44v155Ev();
extern void _ZN6S105C44v156Ev();
extern void _ZN6S105C44v157Ev();
extern void _ZN6S105C44v158Ev();
extern void _ZN6S105C44v159Ev();
extern void _ZN6S105C44v160Ev();
extern void _ZN6S105C44v161Ev();
extern void _ZN6S105C44v162Ev();
extern void _ZN6S105C44v163Ev();
extern void _ZN6S105C44v164Ev();
extern void _ZN6S105C44v165Ev();
extern void _ZN6S105C44v166Ev();
extern void _ZN6S105C44v167Ev();
extern void _ZN6S105C44v168Ev();
extern void _ZN6S105C44v169Ev();
extern void _ZN6S105C44v170Ev();
extern void _ZN6S105C44v171Ev();
extern void _ZN6S105C44v172Ev();
extern void _ZN6S105C44v173Ev();
extern void _ZN6S105C44v174Ev();
extern void _ZN6S105C44v175Ev();
extern void _ZN6S105C44v176Ev();
extern void _ZN6S105C44v177Ev();
extern void _ZN6S105C44v178Ev();
extern void _ZN6S105C44v179Ev();
extern void _ZN6S105C44v180Ev();
extern void _ZN6S105C44v181Ev();
extern void _ZN6S105C44v182Ev();
extern void _ZN6S105C44v183Ev();
extern void _ZN6S105C44v184Ev();
extern void _ZN6S105C44v185Ev();
extern void _ZN6S105C44v186Ev();
extern void _ZN6S105C34v187Ev();
extern void _ZN6S105C34v188Ev();
extern void _ZN6S105C34v189Ev();
extern void _ZN6S105C34v190Ev();
extern void _ZN6S105C34v191Ev();
extern void _ZN6S105C34v192Ev();
extern void _ZN6S105C34v193Ev();
extern void _ZN6S105C34v194Ev();
extern void _ZN6S105C34v195Ev();
extern void _ZN6S105C34v196Ev();
extern void _ZN6S105C34v197Ev();
extern void _ZN6S105C34v198Ev();
extern void _ZN6S105C34v199Ev();
extern void _ZN6S105C34v200Ev();
extern void _ZN6S105C34v201Ev();
extern void _ZN6S105C34v202Ev();
extern void _ZN6S105C34v203Ev();
extern void _ZN6S105C34v204Ev();
extern void _ZN6S105C34v205Ev();
extern void _ZN6S105C34v206Ev();
extern void _ZN6S105C34v207Ev();
extern void _ZN6S105C34v208Ev();
extern void _ZN6S105C34v209Ev();
static  VTBL_ENTRY vtc_S105C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C3[0]),
  (VTBL_ENTRY)&_ZN6S105C3D1Ev,
  (VTBL_ENTRY)&_ZN6S105C3D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
  (VTBL_ENTRY)&_ZN6S105C53v72Ev,
  (VTBL_ENTRY)&_ZN6S105C53v73Ev,
  (VTBL_ENTRY)&_ZN6S105C53v74Ev,
  (VTBL_ENTRY)&_ZN6S105C53v75Ev,
  (VTBL_ENTRY)&_ZN6S105C53v76Ev,
  (VTBL_ENTRY)&_ZN6S105C53v77Ev,
  (VTBL_ENTRY)&_ZN6S105C53v78Ev,
  (VTBL_ENTRY)&_ZN6S105C53v79Ev,
  (VTBL_ENTRY)&_ZN6S105C53v80Ev,
  (VTBL_ENTRY)&_ZN6S105C53v81Ev,
  (VTBL_ENTRY)&_ZN6S105C53v82Ev,
  (VTBL_ENTRY)&_ZN6S105C53v83Ev,
  (VTBL_ENTRY)&_ZN6S105C53v84Ev,
  (VTBL_ENTRY)&_ZN6S105C53v85Ev,
  (VTBL_ENTRY)&_ZN6S105C53v86Ev,
  (VTBL_ENTRY)&_ZN6S105C53v87Ev,
  (VTBL_ENTRY)&_ZN6S105C53v88Ev,
  (VTBL_ENTRY)&_ZN6S105C53v89Ev,
  (VTBL_ENTRY)&_ZN6S105C53v90Ev,
  (VTBL_ENTRY)&_ZN6S105C53v91Ev,
  (VTBL_ENTRY)&_ZN6S105C53v92Ev,
  (VTBL_ENTRY)&_ZN6S105C53v93Ev,
  (VTBL_ENTRY)&_ZN6S105C53v94Ev,
  (VTBL_ENTRY)&_ZN6S105C53v95Ev,
  (VTBL_ENTRY)&_ZN6S105C53v96Ev,
  (VTBL_ENTRY)&_ZN6S105C53v97Ev,
  (VTBL_ENTRY)&_ZN6S105C53v98Ev,
  (VTBL_ENTRY)&_ZN6S105C53v99Ev,
  (VTBL_ENTRY)&_ZN6S105C54v100Ev,
  (VTBL_ENTRY)&_ZN6S105C54v101Ev,
  (VTBL_ENTRY)&_ZN6S105C54v102Ev,
  (VTBL_ENTRY)&_ZN6S105C54v103Ev,
  (VTBL_ENTRY)&_ZN6S105C54v104Ev,
  (VTBL_ENTRY)&_ZN6S105C54v105Ev,
  (VTBL_ENTRY)&_ZN6S105C54v106Ev,
  (VTBL_ENTRY)&_ZN6S105C54v107Ev,
  (VTBL_ENTRY)&_ZN6S105C54v108Ev,
  (VTBL_ENTRY)&_ZN6S105C54v109Ev,
  (VTBL_ENTRY)&_ZN6S105C54v110Ev,
  (VTBL_ENTRY)&_ZN6S105C54v111Ev,
  (VTBL_ENTRY)&_ZN6S105C54v112Ev,
  (VTBL_ENTRY)&_ZN6S105C54v113Ev,
  (VTBL_ENTRY)&_ZN6S105C54v114Ev,
  (VTBL_ENTRY)&_ZN6S105C54v115Ev,
  (VTBL_ENTRY)&_ZN6S105C54v116Ev,
  (VTBL_ENTRY)&_ZN6S105C54v117Ev,
  (VTBL_ENTRY)&_ZN6S105C54v118Ev,
  (VTBL_ENTRY)&_ZN6S105C54v119Ev,
  (VTBL_ENTRY)&_ZN6S105C54v120Ev,
  (VTBL_ENTRY)&_ZN6S105C54v121Ev,
  (VTBL_ENTRY)&_ZN6S105C54v122Ev,
  (VTBL_ENTRY)&_ZN6S105C54v123Ev,
  (VTBL_ENTRY)&_ZN6S105C54v124Ev,
  (VTBL_ENTRY)&_ZN6S105C54v125Ev,
  (VTBL_ENTRY)&_ZN6S105C54v126Ev,
  (VTBL_ENTRY)&_ZN6S105C54v127Ev,
  (VTBL_ENTRY)&_ZN6S105C54v128Ev,
  (VTBL_ENTRY)&_ZN6S105C54v129Ev,
  (VTBL_ENTRY)&_ZN6S105C54v130Ev,
  (VTBL_ENTRY)&_ZN6S105C54v131Ev,
  (VTBL_ENTRY)&_ZN6S105C54v132Ev,
  (VTBL_ENTRY)&_ZN6S105C54v133Ev,
  (VTBL_ENTRY)&_ZN6S105C54v134Ev,
  (VTBL_ENTRY)&_ZN6S105C54v135Ev,
  (VTBL_ENTRY)&_ZN6S105C54v136Ev,
  (VTBL_ENTRY)&_ZN6S105C54v137Ev,
  (VTBL_ENTRY)&_ZN6S105C54v138Ev,
  (VTBL_ENTRY)&_ZN6S105C54v139Ev,
  (VTBL_ENTRY)&_ZN6S105C54v140Ev,
  (VTBL_ENTRY)&_ZN6S105C54v141Ev,
  (VTBL_ENTRY)&_ZN6S105C54v142Ev,
  (VTBL_ENTRY)&_ZN6S105C54v143Ev,
  (VTBL_ENTRY)&_ZN6S105C54v144Ev,
  (VTBL_ENTRY)&_ZN6S105C54v145Ev,
  (VTBL_ENTRY)&_ZN6S105C54v146Ev,
  (VTBL_ENTRY)&_ZN6S105C54v147Ev,
  (VTBL_ENTRY)&_ZN6S105C44v148Ev,
  (VTBL_ENTRY)&_ZN6S105C44v149Ev,
  (VTBL_ENTRY)&_ZN6S105C44v150Ev,
  (VTBL_ENTRY)&_ZN6S105C44v151Ev,
  (VTBL_ENTRY)&_ZN6S105C44v152Ev,
  (VTBL_ENTRY)&_ZN6S105C44v153Ev,
  (VTBL_ENTRY)&_ZN6S105C44v154Ev,
  (VTBL_ENTRY)&_ZN6S105C44v155Ev,
  (VTBL_ENTRY)&_ZN6S105C44v156Ev,
  (VTBL_ENTRY)&_ZN6S105C44v157Ev,
  (VTBL_ENTRY)&_ZN6S105C44v158Ev,
  (VTBL_ENTRY)&_ZN6S105C44v159Ev,
  (VTBL_ENTRY)&_ZN6S105C44v160Ev,
  (VTBL_ENTRY)&_ZN6S105C44v161Ev,
  (VTBL_ENTRY)&_ZN6S105C44v162Ev,
  (VTBL_ENTRY)&_ZN6S105C44v163Ev,
  (VTBL_ENTRY)&_ZN6S105C44v164Ev,
  (VTBL_ENTRY)&_ZN6S105C44v165Ev,
  (VTBL_ENTRY)&_ZN6S105C44v166Ev,
  (VTBL_ENTRY)&_ZN6S105C44v167Ev,
  (VTBL_ENTRY)&_ZN6S105C44v168Ev,
  (VTBL_ENTRY)&_ZN6S105C44v169Ev,
  (VTBL_ENTRY)&_ZN6S105C44v170Ev,
  (VTBL_ENTRY)&_ZN6S105C44v171Ev,
  (VTBL_ENTRY)&_ZN6S105C44v172Ev,
  (VTBL_ENTRY)&_ZN6S105C44v173Ev,
  (VTBL_ENTRY)&_ZN6S105C44v174Ev,
  (VTBL_ENTRY)&_ZN6S105C44v175Ev,
  (VTBL_ENTRY)&_ZN6S105C44v176Ev,
  (VTBL_ENTRY)&_ZN6S105C44v177Ev,
  (VTBL_ENTRY)&_ZN6S105C44v178Ev,
  (VTBL_ENTRY)&_ZN6S105C44v179Ev,
  (VTBL_ENTRY)&_ZN6S105C44v180Ev,
  (VTBL_ENTRY)&_ZN6S105C44v181Ev,
  (VTBL_ENTRY)&_ZN6S105C44v182Ev,
  (VTBL_ENTRY)&_ZN6S105C44v183Ev,
  (VTBL_ENTRY)&_ZN6S105C44v184Ev,
  (VTBL_ENTRY)&_ZN6S105C44v185Ev,
  (VTBL_ENTRY)&_ZN6S105C44v186Ev,
  (VTBL_ENTRY)&_ZN6S105C34v187Ev,
  (VTBL_ENTRY)&_ZN6S105C34v188Ev,
  (VTBL_ENTRY)&_ZN6S105C34v189Ev,
  (VTBL_ENTRY)&_ZN6S105C34v190Ev,
  (VTBL_ENTRY)&_ZN6S105C34v191Ev,
  (VTBL_ENTRY)&_ZN6S105C34v192Ev,
  (VTBL_ENTRY)&_ZN6S105C34v193Ev,
  (VTBL_ENTRY)&_ZN6S105C34v194Ev,
  (VTBL_ENTRY)&_ZN6S105C34v195Ev,
  (VTBL_ENTRY)&_ZN6S105C34v196Ev,
  (VTBL_ENTRY)&_ZN6S105C34v197Ev,
  (VTBL_ENTRY)&_ZN6S105C34v198Ev,
  (VTBL_ENTRY)&_ZN6S105C34v199Ev,
  (VTBL_ENTRY)&_ZN6S105C34v200Ev,
  (VTBL_ENTRY)&_ZN6S105C34v201Ev,
  (VTBL_ENTRY)&_ZN6S105C34v202Ev,
  (VTBL_ENTRY)&_ZN6S105C34v203Ev,
  (VTBL_ENTRY)&_ZN6S105C34v204Ev,
  (VTBL_ENTRY)&_ZN6S105C34v205Ev,
  (VTBL_ENTRY)&_ZN6S105C34v206Ev,
  (VTBL_ENTRY)&_ZN6S105C34v207Ev,
  (VTBL_ENTRY)&_ZN6S105C34v208Ev,
  (VTBL_ENTRY)&_ZN6S105C34v209Ev,
};
extern VTBL_ENTRY _ZTI6S105C3[];
extern  VTBL_ENTRY _ZTV6S105C3[];
Class_Descriptor cd_S105C3 = {  "S105C3", // class name
  bases_S105C3, 4,
  &(vtc_S105C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI6S105C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C2  : S105C3 {
  void *s105c2f0[2];
  int s105c2f1[2];
  char s105c2f2;
  void *s105c2f3;
  unsigned int s105c2f4:1;
  unsigned int s105c2f5:1;
  ::S80C28_nt s105c2f6;
  virtual  ~S105C2(); // _ZN6S105C2D1Ev
  virtual void  v210(); // _ZN6S105C24v210Ev
  virtual void  v211(); // _ZN6S105C24v211Ev
  virtual void  v212(); // _ZN6S105C24v212Ev
  virtual void  v213(); // _ZN6S105C24v213Ev
  virtual void  v214(); // _ZN6S105C24v214Ev
  virtual void  v215(); // _ZN6S105C24v215Ev
  virtual void  v216(); // _ZN6S105C24v216Ev
  virtual void  v217(); // _ZN6S105C24v217Ev
  S105C2(); // tgen
};
//SIG(-1 S105C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC21{ m Fi[2]}} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 FC7 Fp[9] FC22{ BC23{ BC11}} FC9 FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC21 FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC27{ BC16}}


 S105C2 ::~S105C2(){ note_dtor("S105C2", this);}
void  S105C2 ::v210(){vfunc_called(this, "_ZN6S105C24v210Ev");}
void  S105C2 ::v211(){vfunc_called(this, "_ZN6S105C24v211Ev");}
void  S105C2 ::v212(){vfunc_called(this, "_ZN6S105C24v212Ev");}
void  S105C2 ::v213(){vfunc_called(this, "_ZN6S105C24v213Ev");}
void  S105C2 ::v214(){vfunc_called(this, "_ZN6S105C24v214Ev");}
void  S105C2 ::v215(){vfunc_called(this, "_ZN6S105C24v215Ev");}
void  S105C2 ::v216(){vfunc_called(this, "_ZN6S105C24v216Ev");}
void  S105C2 ::v217(){vfunc_called(this, "_ZN6S105C24v217Ev");}
S105C2 ::S105C2(){ note_ctor("S105C2", this);} // tgen

static void Test_S105C2()
{
  extern Class_Descriptor cd_S105C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(117,165)];
    init_test(&cd_S105C2, buf);
    S105C2 *dp, &lv = *(dp=new (buf) S105C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,656), "sizeof(S105C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C2)");
    check_base_class_offset(lv, (S105C7*)(S105C6*)(S105C5*)(S105C4*)(S105C3*), 0, "S105C2");
    check_base_class_offset(lv, (S105C6*)(S105C5*)(S105C4*)(S105C3*), 0, "S105C2");
    check_base_class_offset(lv, (S105C5*)(S105C4*)(S105C3*), 0, "S105C2");
    check_base_class_offset(lv, (S105C4*)(S105C3*), 0, "S105C2");
    check_base_class_offset(lv, (S105C3*), 0, "S105C2");
    check_field_offset(lv, s105c2f0, ABISELECT(864,616), "S105C2.s105c2f0");
    check_field_offset(lv, s105c2f1, ABISELECT(880,624), "S105C2.s105c2f1");
    check_field_offset(lv, s105c2f2, ABISELECT(888,632), "S105C2.s105c2f2");
    check_field_offset(lv, s105c2f3, ABISELECT(896,636), "S105C2.s105c2f3");
    set_bf_and_test(lv, s105c2f4, ABISELECT(904,640), 0, 1, 1, "S105C2");
    set_bf_and_test(lv, s105c2f5, ABISELECT(904,640), 1, 1, 1, "S105C2");
    check_field_offset(lv, s105c2f6, ABISELECT(912,644), "S105C2.s105c2f6");
    test_class_info(&lv, &cd_S105C2);
    dp->~S105C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C2(Test_S105C2, "S105C2", ABISELECT(928,656));

#else // __cplusplus

extern void _ZN6S105C2C1Ev();
extern void _ZN6S105C2D1Ev();
Name_Map name_map_S105C2[] = {
  NSPAIR(_ZN6S105C2C1Ev),
  NSPAIR(_ZN6S105C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
extern Class_Descriptor cd_S105C6;
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
extern Class_Descriptor cd_S105C5;
extern VTBL_ENTRY _ZTI6S105C5[];
extern  VTBL_ENTRY _ZTV6S105C5[];
extern Class_Descriptor cd_S105C4;
extern VTBL_ENTRY _ZTI6S105C4[];
extern  VTBL_ENTRY _ZTV6S105C4[];
extern Class_Descriptor cd_S105C3;
extern VTBL_ENTRY _ZTI6S105C3[];
extern  VTBL_ENTRY _ZTV6S105C3[];
static Base_Class bases_S105C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S105C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S105C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S105C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S105C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C2[];
extern void _ZN6S105C2D1Ev();
extern void _ZN6S105C2D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
extern void _ZN6S105C53v72Ev();
extern void _ZN6S105C53v73Ev();
extern void _ZN6S105C53v74Ev();
extern void _ZN6S105C53v75Ev();
extern void _ZN6S105C53v76Ev();
extern void _ZN6S105C53v77Ev();
extern void _ZN6S105C53v78Ev();
extern void _ZN6S105C53v79Ev();
extern void _ZN6S105C53v80Ev();
extern void _ZN6S105C53v81Ev();
extern void _ZN6S105C53v82Ev();
extern void _ZN6S105C53v83Ev();
extern void _ZN6S105C53v84Ev();
extern void _ZN6S105C53v85Ev();
extern void _ZN6S105C53v86Ev();
extern void _ZN6S105C53v87Ev();
extern void _ZN6S105C53v88Ev();
extern void _ZN6S105C53v89Ev();
extern void _ZN6S105C53v90Ev();
extern void _ZN6S105C53v91Ev();
extern void _ZN6S105C53v92Ev();
extern void _ZN6S105C53v93Ev();
extern void _ZN6S105C53v94Ev();
extern void _ZN6S105C53v95Ev();
extern void _ZN6S105C53v96Ev();
extern void _ZN6S105C53v97Ev();
extern void _ZN6S105C53v98Ev();
extern void _ZN6S105C53v99Ev();
extern void _ZN6S105C54v100Ev();
extern void _ZN6S105C54v101Ev();
extern void _ZN6S105C54v102Ev();
extern void _ZN6S105C54v103Ev();
extern void _ZN6S105C54v104Ev();
extern void _ZN6S105C54v105Ev();
extern void _ZN6S105C54v106Ev();
extern void _ZN6S105C54v107Ev();
extern void _ZN6S105C54v108Ev();
extern void _ZN6S105C54v109Ev();
extern void _ZN6S105C54v110Ev();
extern void _ZN6S105C54v111Ev();
extern void _ZN6S105C54v112Ev();
extern void _ZN6S105C54v113Ev();
extern void _ZN6S105C54v114Ev();
extern void _ZN6S105C54v115Ev();
extern void _ZN6S105C54v116Ev();
extern void _ZN6S105C54v117Ev();
extern void _ZN6S105C54v118Ev();
extern void _ZN6S105C54v119Ev();
extern void _ZN6S105C54v120Ev();
extern void _ZN6S105C54v121Ev();
extern void _ZN6S105C54v122Ev();
extern void _ZN6S105C54v123Ev();
extern void _ZN6S105C54v124Ev();
extern void _ZN6S105C54v125Ev();
extern void _ZN6S105C54v126Ev();
extern void _ZN6S105C54v127Ev();
extern void _ZN6S105C54v128Ev();
extern void _ZN6S105C54v129Ev();
extern void _ZN6S105C54v130Ev();
extern void _ZN6S105C54v131Ev();
extern void _ZN6S105C54v132Ev();
extern void _ZN6S105C54v133Ev();
extern void _ZN6S105C54v134Ev();
extern void _ZN6S105C54v135Ev();
extern void _ZN6S105C54v136Ev();
extern void _ZN6S105C54v137Ev();
extern void _ZN6S105C54v138Ev();
extern void _ZN6S105C54v139Ev();
extern void _ZN6S105C54v140Ev();
extern void _ZN6S105C54v141Ev();
extern void _ZN6S105C54v142Ev();
extern void _ZN6S105C54v143Ev();
extern void _ZN6S105C54v144Ev();
extern void _ZN6S105C54v145Ev();
extern void _ZN6S105C54v146Ev();
extern void _ZN6S105C54v147Ev();
extern void _ZN6S105C44v148Ev();
extern void _ZN6S105C44v149Ev();
extern void _ZN6S105C44v150Ev();
extern void _ZN6S105C44v151Ev();
extern void _ZN6S105C44v152Ev();
extern void _ZN6S105C44v153Ev();
extern void _ZN6S105C44v154Ev();
extern void _ZN6S105C44v155Ev();
extern void _ZN6S105C44v156Ev();
extern void _ZN6S105C44v157Ev();
extern void _ZN6S105C44v158Ev();
extern void _ZN6S105C44v159Ev();
extern void _ZN6S105C44v160Ev();
extern void _ZN6S105C44v161Ev();
extern void _ZN6S105C44v162Ev();
extern void _ZN6S105C44v163Ev();
extern void _ZN6S105C44v164Ev();
extern void _ZN6S105C44v165Ev();
extern void _ZN6S105C44v166Ev();
extern void _ZN6S105C44v167Ev();
extern void _ZN6S105C44v168Ev();
extern void _ZN6S105C44v169Ev();
extern void _ZN6S105C44v170Ev();
extern void _ZN6S105C44v171Ev();
extern void _ZN6S105C44v172Ev();
extern void _ZN6S105C44v173Ev();
extern void _ZN6S105C44v174Ev();
extern void _ZN6S105C44v175Ev();
extern void _ZN6S105C44v176Ev();
extern void _ZN6S105C44v177Ev();
extern void _ZN6S105C44v178Ev();
extern void _ZN6S105C44v179Ev();
extern void _ZN6S105C44v180Ev();
extern void _ZN6S105C44v181Ev();
extern void _ZN6S105C44v182Ev();
extern void _ZN6S105C44v183Ev();
extern void _ZN6S105C44v184Ev();
extern void _ZN6S105C44v185Ev();
extern void _ZN6S105C44v186Ev();
extern void _ZN6S105C34v187Ev();
extern void _ZN6S105C34v188Ev();
extern void _ZN6S105C34v189Ev();
extern void _ZN6S105C34v190Ev();
extern void _ZN6S105C34v191Ev();
extern void _ZN6S105C34v192Ev();
extern void _ZN6S105C34v193Ev();
extern void _ZN6S105C34v194Ev();
extern void _ZN6S105C34v195Ev();
extern void _ZN6S105C34v196Ev();
extern void _ZN6S105C34v197Ev();
extern void _ZN6S105C34v198Ev();
extern void _ZN6S105C34v199Ev();
extern void _ZN6S105C34v200Ev();
extern void _ZN6S105C34v201Ev();
extern void _ZN6S105C34v202Ev();
extern void _ZN6S105C34v203Ev();
extern void _ZN6S105C34v204Ev();
extern void _ZN6S105C34v205Ev();
extern void _ZN6S105C34v206Ev();
extern void _ZN6S105C34v207Ev();
extern void _ZN6S105C34v208Ev();
extern void _ZN6S105C34v209Ev();
extern void _ZN6S105C24v210Ev();
extern void _ZN6S105C24v211Ev();
extern void _ZN6S105C24v212Ev();
extern void _ZN6S105C24v213Ev();
extern void _ZN6S105C24v214Ev();
extern void _ZN6S105C24v215Ev();
extern void _ZN6S105C24v216Ev();
extern void _ZN6S105C24v217Ev();
static  VTBL_ENTRY vtc_S105C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C2[0]),
  (VTBL_ENTRY)&_ZN6S105C2D1Ev,
  (VTBL_ENTRY)&_ZN6S105C2D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
  (VTBL_ENTRY)&_ZN6S105C53v72Ev,
  (VTBL_ENTRY)&_ZN6S105C53v73Ev,
  (VTBL_ENTRY)&_ZN6S105C53v74Ev,
  (VTBL_ENTRY)&_ZN6S105C53v75Ev,
  (VTBL_ENTRY)&_ZN6S105C53v76Ev,
  (VTBL_ENTRY)&_ZN6S105C53v77Ev,
  (VTBL_ENTRY)&_ZN6S105C53v78Ev,
  (VTBL_ENTRY)&_ZN6S105C53v79Ev,
  (VTBL_ENTRY)&_ZN6S105C53v80Ev,
  (VTBL_ENTRY)&_ZN6S105C53v81Ev,
  (VTBL_ENTRY)&_ZN6S105C53v82Ev,
  (VTBL_ENTRY)&_ZN6S105C53v83Ev,
  (VTBL_ENTRY)&_ZN6S105C53v84Ev,
  (VTBL_ENTRY)&_ZN6S105C53v85Ev,
  (VTBL_ENTRY)&_ZN6S105C53v86Ev,
  (VTBL_ENTRY)&_ZN6S105C53v87Ev,
  (VTBL_ENTRY)&_ZN6S105C53v88Ev,
  (VTBL_ENTRY)&_ZN6S105C53v89Ev,
  (VTBL_ENTRY)&_ZN6S105C53v90Ev,
  (VTBL_ENTRY)&_ZN6S105C53v91Ev,
  (VTBL_ENTRY)&_ZN6S105C53v92Ev,
  (VTBL_ENTRY)&_ZN6S105C53v93Ev,
  (VTBL_ENTRY)&_ZN6S105C53v94Ev,
  (VTBL_ENTRY)&_ZN6S105C53v95Ev,
  (VTBL_ENTRY)&_ZN6S105C53v96Ev,
  (VTBL_ENTRY)&_ZN6S105C53v97Ev,
  (VTBL_ENTRY)&_ZN6S105C53v98Ev,
  (VTBL_ENTRY)&_ZN6S105C53v99Ev,
  (VTBL_ENTRY)&_ZN6S105C54v100Ev,
  (VTBL_ENTRY)&_ZN6S105C54v101Ev,
  (VTBL_ENTRY)&_ZN6S105C54v102Ev,
  (VTBL_ENTRY)&_ZN6S105C54v103Ev,
  (VTBL_ENTRY)&_ZN6S105C54v104Ev,
  (VTBL_ENTRY)&_ZN6S105C54v105Ev,
  (VTBL_ENTRY)&_ZN6S105C54v106Ev,
  (VTBL_ENTRY)&_ZN6S105C54v107Ev,
  (VTBL_ENTRY)&_ZN6S105C54v108Ev,
  (VTBL_ENTRY)&_ZN6S105C54v109Ev,
  (VTBL_ENTRY)&_ZN6S105C54v110Ev,
  (VTBL_ENTRY)&_ZN6S105C54v111Ev,
  (VTBL_ENTRY)&_ZN6S105C54v112Ev,
  (VTBL_ENTRY)&_ZN6S105C54v113Ev,
  (VTBL_ENTRY)&_ZN6S105C54v114Ev,
  (VTBL_ENTRY)&_ZN6S105C54v115Ev,
  (VTBL_ENTRY)&_ZN6S105C54v116Ev,
  (VTBL_ENTRY)&_ZN6S105C54v117Ev,
  (VTBL_ENTRY)&_ZN6S105C54v118Ev,
  (VTBL_ENTRY)&_ZN6S105C54v119Ev,
  (VTBL_ENTRY)&_ZN6S105C54v120Ev,
  (VTBL_ENTRY)&_ZN6S105C54v121Ev,
  (VTBL_ENTRY)&_ZN6S105C54v122Ev,
  (VTBL_ENTRY)&_ZN6S105C54v123Ev,
  (VTBL_ENTRY)&_ZN6S105C54v124Ev,
  (VTBL_ENTRY)&_ZN6S105C54v125Ev,
  (VTBL_ENTRY)&_ZN6S105C54v126Ev,
  (VTBL_ENTRY)&_ZN6S105C54v127Ev,
  (VTBL_ENTRY)&_ZN6S105C54v128Ev,
  (VTBL_ENTRY)&_ZN6S105C54v129Ev,
  (VTBL_ENTRY)&_ZN6S105C54v130Ev,
  (VTBL_ENTRY)&_ZN6S105C54v131Ev,
  (VTBL_ENTRY)&_ZN6S105C54v132Ev,
  (VTBL_ENTRY)&_ZN6S105C54v133Ev,
  (VTBL_ENTRY)&_ZN6S105C54v134Ev,
  (VTBL_ENTRY)&_ZN6S105C54v135Ev,
  (VTBL_ENTRY)&_ZN6S105C54v136Ev,
  (VTBL_ENTRY)&_ZN6S105C54v137Ev,
  (VTBL_ENTRY)&_ZN6S105C54v138Ev,
  (VTBL_ENTRY)&_ZN6S105C54v139Ev,
  (VTBL_ENTRY)&_ZN6S105C54v140Ev,
  (VTBL_ENTRY)&_ZN6S105C54v141Ev,
  (VTBL_ENTRY)&_ZN6S105C54v142Ev,
  (VTBL_ENTRY)&_ZN6S105C54v143Ev,
  (VTBL_ENTRY)&_ZN6S105C54v144Ev,
  (VTBL_ENTRY)&_ZN6S105C54v145Ev,
  (VTBL_ENTRY)&_ZN6S105C54v146Ev,
  (VTBL_ENTRY)&_ZN6S105C54v147Ev,
  (VTBL_ENTRY)&_ZN6S105C44v148Ev,
  (VTBL_ENTRY)&_ZN6S105C44v149Ev,
  (VTBL_ENTRY)&_ZN6S105C44v150Ev,
  (VTBL_ENTRY)&_ZN6S105C44v151Ev,
  (VTBL_ENTRY)&_ZN6S105C44v152Ev,
  (VTBL_ENTRY)&_ZN6S105C44v153Ev,
  (VTBL_ENTRY)&_ZN6S105C44v154Ev,
  (VTBL_ENTRY)&_ZN6S105C44v155Ev,
  (VTBL_ENTRY)&_ZN6S105C44v156Ev,
  (VTBL_ENTRY)&_ZN6S105C44v157Ev,
  (VTBL_ENTRY)&_ZN6S105C44v158Ev,
  (VTBL_ENTRY)&_ZN6S105C44v159Ev,
  (VTBL_ENTRY)&_ZN6S105C44v160Ev,
  (VTBL_ENTRY)&_ZN6S105C44v161Ev,
  (VTBL_ENTRY)&_ZN6S105C44v162Ev,
  (VTBL_ENTRY)&_ZN6S105C44v163Ev,
  (VTBL_ENTRY)&_ZN6S105C44v164Ev,
  (VTBL_ENTRY)&_ZN6S105C44v165Ev,
  (VTBL_ENTRY)&_ZN6S105C44v166Ev,
  (VTBL_ENTRY)&_ZN6S105C44v167Ev,
  (VTBL_ENTRY)&_ZN6S105C44v168Ev,
  (VTBL_ENTRY)&_ZN6S105C44v169Ev,
  (VTBL_ENTRY)&_ZN6S105C44v170Ev,
  (VTBL_ENTRY)&_ZN6S105C44v171Ev,
  (VTBL_ENTRY)&_ZN6S105C44v172Ev,
  (VTBL_ENTRY)&_ZN6S105C44v173Ev,
  (VTBL_ENTRY)&_ZN6S105C44v174Ev,
  (VTBL_ENTRY)&_ZN6S105C44v175Ev,
  (VTBL_ENTRY)&_ZN6S105C44v176Ev,
  (VTBL_ENTRY)&_ZN6S105C44v177Ev,
  (VTBL_ENTRY)&_ZN6S105C44v178Ev,
  (VTBL_ENTRY)&_ZN6S105C44v179Ev,
  (VTBL_ENTRY)&_ZN6S105C44v180Ev,
  (VTBL_ENTRY)&_ZN6S105C44v181Ev,
  (VTBL_ENTRY)&_ZN6S105C44v182Ev,
  (VTBL_ENTRY)&_ZN6S105C44v183Ev,
  (VTBL_ENTRY)&_ZN6S105C44v184Ev,
  (VTBL_ENTRY)&_ZN6S105C44v185Ev,
  (VTBL_ENTRY)&_ZN6S105C44v186Ev,
  (VTBL_ENTRY)&_ZN6S105C34v187Ev,
  (VTBL_ENTRY)&_ZN6S105C34v188Ev,
  (VTBL_ENTRY)&_ZN6S105C34v189Ev,
  (VTBL_ENTRY)&_ZN6S105C34v190Ev,
  (VTBL_ENTRY)&_ZN6S105C34v191Ev,
  (VTBL_ENTRY)&_ZN6S105C34v192Ev,
  (VTBL_ENTRY)&_ZN6S105C34v193Ev,
  (VTBL_ENTRY)&_ZN6S105C34v194Ev,
  (VTBL_ENTRY)&_ZN6S105C34v195Ev,
  (VTBL_ENTRY)&_ZN6S105C34v196Ev,
  (VTBL_ENTRY)&_ZN6S105C34v197Ev,
  (VTBL_ENTRY)&_ZN6S105C34v198Ev,
  (VTBL_ENTRY)&_ZN6S105C34v199Ev,
  (VTBL_ENTRY)&_ZN6S105C34v200Ev,
  (VTBL_ENTRY)&_ZN6S105C34v201Ev,
  (VTBL_ENTRY)&_ZN6S105C34v202Ev,
  (VTBL_ENTRY)&_ZN6S105C34v203Ev,
  (VTBL_ENTRY)&_ZN6S105C34v204Ev,
  (VTBL_ENTRY)&_ZN6S105C34v205Ev,
  (VTBL_ENTRY)&_ZN6S105C34v206Ev,
  (VTBL_ENTRY)&_ZN6S105C34v207Ev,
  (VTBL_ENTRY)&_ZN6S105C34v208Ev,
  (VTBL_ENTRY)&_ZN6S105C34v209Ev,
  (VTBL_ENTRY)&_ZN6S105C24v210Ev,
  (VTBL_ENTRY)&_ZN6S105C24v211Ev,
  (VTBL_ENTRY)&_ZN6S105C24v212Ev,
  (VTBL_ENTRY)&_ZN6S105C24v213Ev,
  (VTBL_ENTRY)&_ZN6S105C24v214Ev,
  (VTBL_ENTRY)&_ZN6S105C24v215Ev,
  (VTBL_ENTRY)&_ZN6S105C24v216Ev,
  (VTBL_ENTRY)&_ZN6S105C24v217Ev,
};
extern VTBL_ENTRY _ZTI6S105C2[];
extern  VTBL_ENTRY _ZTV6S105C2[];
Class_Descriptor cd_S105C2 = {  "S105C2", // class name
  bases_S105C2, 5,
  &(vtc_S105C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(928,656), // object size
  NSPAIRA(_ZTI6S105C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C2),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S105C1  : S105C2 {
  ::S80C10_nt s105c1f0;
  void *s105c1f1[2];
  virtual  ~S105C1(); // _ZN6S105C1D1Ev
  virtual void  v1(); // _ZN6S105C12v1Ev
  virtual void  v2(); // _ZN6S105C12v2Ev
  virtual void  v3(); // _ZN6S105C12v3Ev
  virtual void  v4(); // _ZN6S105C12v4Ev
  virtual void  v5(); // _ZN6S105C12v5Ev
  S105C1(); // tgen
};
//SIG(1 S105C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC22{ m Fi[2]}} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 FC8 Fp[9] FC23{ BC24{ BC12}} FC10 FC25{ BC26{ m FC27{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC22 FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v210 v211 v212 v213 v214 v215 v216 v217 Fp[2] Fi[2] Fc Fp Fi:1 Fi:1 FC28{ BC17}} vd v1 v2 v3 v4 v5 FC29{ BC30{ BC12}} Fp[2]}


 S105C1 ::~S105C1(){ note_dtor("S105C1", this);}
void  S105C1 ::v1(){vfunc_called(this, "_ZN6S105C12v1Ev");}
void  S105C1 ::v2(){vfunc_called(this, "_ZN6S105C12v2Ev");}
void  S105C1 ::v3(){vfunc_called(this, "_ZN6S105C12v3Ev");}
void  S105C1 ::v4(){vfunc_called(this, "_ZN6S105C12v4Ev");}
void  S105C1 ::v5(){vfunc_called(this, "_ZN6S105C12v5Ev");}
S105C1 ::S105C1(){ note_ctor("S105C1", this);} // tgen

static void Test_S105C1()
{
  extern Class_Descriptor cd_S105C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,170)];
    init_test(&cd_S105C1, buf);
    S105C1 *dp, &lv = *(dp=new (buf) S105C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,676), "sizeof(S105C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S105C1)");
    check_base_class_offset(lv, (S105C7*)(S105C6*)(S105C5*)(S105C4*)(S105C3*)(S105C2*), 0, "S105C1");
    check_base_class_offset(lv, (S105C6*)(S105C5*)(S105C4*)(S105C3*)(S105C2*), 0, "S105C1");
    check_base_class_offset(lv, (S105C5*)(S105C4*)(S105C3*)(S105C2*), 0, "S105C1");
    check_base_class_offset(lv, (S105C4*)(S105C3*)(S105C2*), 0, "S105C1");
    check_base_class_offset(lv, (S105C3*)(S105C2*), 0, "S105C1");
    check_base_class_offset(lv, (S105C2*), 0, "S105C1");
    check_field_offset(lv, s105c1f0, ABISELECT(928,656), "S105C1.s105c1f0");
    check_field_offset(lv, s105c1f1, ABISELECT(944,668), "S105C1.s105c1f1");
    test_class_info(&lv, &cd_S105C1);
    dp->~S105C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS105C1(Test_S105C1, "S105C1", ABISELECT(960,676));

#else // __cplusplus

extern void _ZN6S105C1C1Ev();
extern void _ZN6S105C1D1Ev();
Name_Map name_map_S105C1[] = {
  NSPAIR(_ZN6S105C1C1Ev),
  NSPAIR(_ZN6S105C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S105C7;
extern VTBL_ENTRY _ZTI6S105C7[];
extern  VTBL_ENTRY _ZTV6S105C7[];
extern Class_Descriptor cd_S105C6;
extern VTBL_ENTRY _ZTI6S105C6[];
extern  VTBL_ENTRY _ZTV6S105C6[];
extern Class_Descriptor cd_S105C5;
extern VTBL_ENTRY _ZTI6S105C5[];
extern  VTBL_ENTRY _ZTV6S105C5[];
extern Class_Descriptor cd_S105C4;
extern VTBL_ENTRY _ZTI6S105C4[];
extern  VTBL_ENTRY _ZTV6S105C4[];
extern Class_Descriptor cd_S105C3;
extern VTBL_ENTRY _ZTI6S105C3[];
extern  VTBL_ENTRY _ZTV6S105C3[];
extern Class_Descriptor cd_S105C2;
extern VTBL_ENTRY _ZTI6S105C2[];
extern  VTBL_ENTRY _ZTV6S105C2[];
static Base_Class bases_S105C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S105C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S105C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S105C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S105C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S105C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S105C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S105C1[];
extern void _ZN6S105C1D1Ev();
extern void _ZN6S105C1D0Ev();
extern void _ZN6S105C72v6Ev();
extern void _ZN6S105C72v7Ev();
extern void _ZN6S105C72v8Ev();
extern void _ZN6S105C72v9Ev();
extern void _ZN6S105C73v10Ev();
extern void _ZN6S105C73v11Ev();
extern void _ZN6S105C73v12Ev();
extern void _ZN6S105C73v13Ev();
extern void _ZN6S105C73v14Ev();
extern void _ZN6S105C73v15Ev();
extern void _ZN6S105C73v16Ev();
extern void _ZN6S105C73v17Ev();
extern void _ZN6S105C73v18Ev();
extern void _ZN6S105C73v19Ev();
extern void _ZN6S105C73v20Ev();
extern void _ZN6S105C73v21Ev();
extern void _ZN6S105C73v22Ev();
extern void _ZN6S105C73v23Ev();
extern void _ZN6S105C73v24Ev();
extern void _ZN6S105C73v25Ev();
extern void _ZN6S105C73v26Ev();
extern void _ZN6S105C73v27Ev();
extern void _ZN6S105C73v28Ev();
extern void _ZN6S105C73v29Ev();
extern void _ZN6S105C73v30Ev();
extern void _ZN6S105C73v31Ev();
extern void _ZN6S105C73v32Ev();
extern void _ZN6S105C73v33Ev();
extern void _ZN6S105C73v34Ev();
extern void _ZN6S105C73v35Ev();
extern void _ZN6S105C73v36Ev();
extern void _ZN6S105C73v37Ev();
extern void _ZN6S105C73v38Ev();
extern void _ZN6S105C73v39Ev();
extern void _ZN6S105C73v40Ev();
extern void _ZN6S105C73v41Ev();
extern void _ZN6S105C73v42Ev();
extern void _ZN6S105C73v43Ev();
extern void _ZN6S105C73v44Ev();
extern void _ZN6S105C73v45Ev();
extern void _ZN6S105C73v46Ev();
extern void _ZN6S105C73v47Ev();
extern void _ZN6S105C73v48Ev();
extern void _ZN6S105C73v49Ev();
extern void _ZN6S105C73v50Ev();
extern void _ZN6S105C73v51Ev();
extern void _ZN6S105C73v52Ev();
extern void _ZN6S105C73v53Ev();
extern void _ZN6S105C73v54Ev();
extern void _ZN6S105C73v55Ev();
extern void _ZN6S105C73v56Ev();
extern void _ZN6S105C73v57Ev();
extern void _ZN6S105C73v58Ev();
extern void _ZN6S105C73v59Ev();
extern void _ZN6S105C73v60Ev();
extern void _ZN6S105C73v61Ev();
extern void _ZN6S105C73v62Ev();
extern void _ZN6S105C73v63Ev();
extern void _ZN6S105C73v64Ev();
extern void _ZN6S105C73v65Ev();
extern void _ZN6S105C73v66Ev();
extern void _ZN6S105C73v67Ev();
extern void _ZN6S105C73v68Ev();
extern void _ZN6S105C73v69Ev();
extern void _ZN6S105C63v70Ev();
extern void _ZN6S105C63v71Ev();
extern void _ZN6S105C53v72Ev();
extern void _ZN6S105C53v73Ev();
extern void _ZN6S105C53v74Ev();
extern void _ZN6S105C53v75Ev();
extern void _ZN6S105C53v76Ev();
extern void _ZN6S105C53v77Ev();
extern void _ZN6S105C53v78Ev();
extern void _ZN6S105C53v79Ev();
extern void _ZN6S105C53v80Ev();
extern void _ZN6S105C53v81Ev();
extern void _ZN6S105C53v82Ev();
extern void _ZN6S105C53v83Ev();
extern void _ZN6S105C53v84Ev();
extern void _ZN6S105C53v85Ev();
extern void _ZN6S105C53v86Ev();
extern void _ZN6S105C53v87Ev();
extern void _ZN6S105C53v88Ev();
extern void _ZN6S105C53v89Ev();
extern void _ZN6S105C53v90Ev();
extern void _ZN6S105C53v91Ev();
extern void _ZN6S105C53v92Ev();
extern void _ZN6S105C53v93Ev();
extern void _ZN6S105C53v94Ev();
extern void _ZN6S105C53v95Ev();
extern void _ZN6S105C53v96Ev();
extern void _ZN6S105C53v97Ev();
extern void _ZN6S105C53v98Ev();
extern void _ZN6S105C53v99Ev();
extern void _ZN6S105C54v100Ev();
extern void _ZN6S105C54v101Ev();
extern void _ZN6S105C54v102Ev();
extern void _ZN6S105C54v103Ev();
extern void _ZN6S105C54v104Ev();
extern void _ZN6S105C54v105Ev();
extern void _ZN6S105C54v106Ev();
extern void _ZN6S105C54v107Ev();
extern void _ZN6S105C54v108Ev();
extern void _ZN6S105C54v109Ev();
extern void _ZN6S105C54v110Ev();
extern void _ZN6S105C54v111Ev();
extern void _ZN6S105C54v112Ev();
extern void _ZN6S105C54v113Ev();
extern void _ZN6S105C54v114Ev();
extern void _ZN6S105C54v115Ev();
extern void _ZN6S105C54v116Ev();
extern void _ZN6S105C54v117Ev();
extern void _ZN6S105C54v118Ev();
extern void _ZN6S105C54v119Ev();
extern void _ZN6S105C54v120Ev();
extern void _ZN6S105C54v121Ev();
extern void _ZN6S105C54v122Ev();
extern void _ZN6S105C54v123Ev();
extern void _ZN6S105C54v124Ev();
extern void _ZN6S105C54v125Ev();
extern void _ZN6S105C54v126Ev();
extern void _ZN6S105C54v127Ev();
extern void _ZN6S105C54v128Ev();
extern void _ZN6S105C54v129Ev();
extern void _ZN6S105C54v130Ev();
extern void _ZN6S105C54v131Ev();
extern void _ZN6S105C54v132Ev();
extern void _ZN6S105C54v133Ev();
extern void _ZN6S105C54v134Ev();
extern void _ZN6S105C54v135Ev();
extern void _ZN6S105C54v136Ev();
extern void _ZN6S105C54v137Ev();
extern void _ZN6S105C54v138Ev();
extern void _ZN6S105C54v139Ev();
extern void _ZN6S105C54v140Ev();
extern void _ZN6S105C54v141Ev();
extern void _ZN6S105C54v142Ev();
extern void _ZN6S105C54v143Ev();
extern void _ZN6S105C54v144Ev();
extern void _ZN6S105C54v145Ev();
extern void _ZN6S105C54v146Ev();
extern void _ZN6S105C54v147Ev();
extern void _ZN6S105C44v148Ev();
extern void _ZN6S105C44v149Ev();
extern void _ZN6S105C44v150Ev();
extern void _ZN6S105C44v151Ev();
extern void _ZN6S105C44v152Ev();
extern void _ZN6S105C44v153Ev();
extern void _ZN6S105C44v154Ev();
extern void _ZN6S105C44v155Ev();
extern void _ZN6S105C44v156Ev();
extern void _ZN6S105C44v157Ev();
extern void _ZN6S105C44v158Ev();
extern void _ZN6S105C44v159Ev();
extern void _ZN6S105C44v160Ev();
extern void _ZN6S105C44v161Ev();
extern void _ZN6S105C44v162Ev();
extern void _ZN6S105C44v163Ev();
extern void _ZN6S105C44v164Ev();
extern void _ZN6S105C44v165Ev();
extern void _ZN6S105C44v166Ev();
extern void _ZN6S105C44v167Ev();
extern void _ZN6S105C44v168Ev();
extern void _ZN6S105C44v169Ev();
extern void _ZN6S105C44v170Ev();
extern void _ZN6S105C44v171Ev();
extern void _ZN6S105C44v172Ev();
extern void _ZN6S105C44v173Ev();
extern void _ZN6S105C44v174Ev();
extern void _ZN6S105C44v175Ev();
extern void _ZN6S105C44v176Ev();
extern void _ZN6S105C44v177Ev();
extern void _ZN6S105C44v178Ev();
extern void _ZN6S105C44v179Ev();
extern void _ZN6S105C44v180Ev();
extern void _ZN6S105C44v181Ev();
extern void _ZN6S105C44v182Ev();
extern void _ZN6S105C44v183Ev();
extern void _ZN6S105C44v184Ev();
extern void _ZN6S105C44v185Ev();
extern void _ZN6S105C44v186Ev();
extern void _ZN6S105C34v187Ev();
extern void _ZN6S105C34v188Ev();
extern void _ZN6S105C34v189Ev();
extern void _ZN6S105C34v190Ev();
extern void _ZN6S105C34v191Ev();
extern void _ZN6S105C34v192Ev();
extern void _ZN6S105C34v193Ev();
extern void _ZN6S105C34v194Ev();
extern void _ZN6S105C34v195Ev();
extern void _ZN6S105C34v196Ev();
extern void _ZN6S105C34v197Ev();
extern void _ZN6S105C34v198Ev();
extern void _ZN6S105C34v199Ev();
extern void _ZN6S105C34v200Ev();
extern void _ZN6S105C34v201Ev();
extern void _ZN6S105C34v202Ev();
extern void _ZN6S105C34v203Ev();
extern void _ZN6S105C34v204Ev();
extern void _ZN6S105C34v205Ev();
extern void _ZN6S105C34v206Ev();
extern void _ZN6S105C34v207Ev();
extern void _ZN6S105C34v208Ev();
extern void _ZN6S105C34v209Ev();
extern void _ZN6S105C24v210Ev();
extern void _ZN6S105C24v211Ev();
extern void _ZN6S105C24v212Ev();
extern void _ZN6S105C24v213Ev();
extern void _ZN6S105C24v214Ev();
extern void _ZN6S105C24v215Ev();
extern void _ZN6S105C24v216Ev();
extern void _ZN6S105C24v217Ev();
extern void _ZN6S105C12v1Ev();
extern void _ZN6S105C12v2Ev();
extern void _ZN6S105C12v3Ev();
extern void _ZN6S105C12v4Ev();
extern void _ZN6S105C12v5Ev();
static  VTBL_ENTRY vtc_S105C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S105C1[0]),
  (VTBL_ENTRY)&_ZN6S105C1D1Ev,
  (VTBL_ENTRY)&_ZN6S105C1D0Ev,
  (VTBL_ENTRY)&_ZN6S105C72v6Ev,
  (VTBL_ENTRY)&_ZN6S105C72v7Ev,
  (VTBL_ENTRY)&_ZN6S105C72v8Ev,
  (VTBL_ENTRY)&_ZN6S105C72v9Ev,
  (VTBL_ENTRY)&_ZN6S105C73v10Ev,
  (VTBL_ENTRY)&_ZN6S105C73v11Ev,
  (VTBL_ENTRY)&_ZN6S105C73v12Ev,
  (VTBL_ENTRY)&_ZN6S105C73v13Ev,
  (VTBL_ENTRY)&_ZN6S105C73v14Ev,
  (VTBL_ENTRY)&_ZN6S105C73v15Ev,
  (VTBL_ENTRY)&_ZN6S105C73v16Ev,
  (VTBL_ENTRY)&_ZN6S105C73v17Ev,
  (VTBL_ENTRY)&_ZN6S105C73v18Ev,
  (VTBL_ENTRY)&_ZN6S105C73v19Ev,
  (VTBL_ENTRY)&_ZN6S105C73v20Ev,
  (VTBL_ENTRY)&_ZN6S105C73v21Ev,
  (VTBL_ENTRY)&_ZN6S105C73v22Ev,
  (VTBL_ENTRY)&_ZN6S105C73v23Ev,
  (VTBL_ENTRY)&_ZN6S105C73v24Ev,
  (VTBL_ENTRY)&_ZN6S105C73v25Ev,
  (VTBL_ENTRY)&_ZN6S105C73v26Ev,
  (VTBL_ENTRY)&_ZN6S105C73v27Ev,
  (VTBL_ENTRY)&_ZN6S105C73v28Ev,
  (VTBL_ENTRY)&_ZN6S105C73v29Ev,
  (VTBL_ENTRY)&_ZN6S105C73v30Ev,
  (VTBL_ENTRY)&_ZN6S105C73v31Ev,
  (VTBL_ENTRY)&_ZN6S105C73v32Ev,
  (VTBL_ENTRY)&_ZN6S105C73v33Ev,
  (VTBL_ENTRY)&_ZN6S105C73v34Ev,
  (VTBL_ENTRY)&_ZN6S105C73v35Ev,
  (VTBL_ENTRY)&_ZN6S105C73v36Ev,
  (VTBL_ENTRY)&_ZN6S105C73v37Ev,
  (VTBL_ENTRY)&_ZN6S105C73v38Ev,
  (VTBL_ENTRY)&_ZN6S105C73v39Ev,
  (VTBL_ENTRY)&_ZN6S105C73v40Ev,
  (VTBL_ENTRY)&_ZN6S105C73v41Ev,
  (VTBL_ENTRY)&_ZN6S105C73v42Ev,
  (VTBL_ENTRY)&_ZN6S105C73v43Ev,
  (VTBL_ENTRY)&_ZN6S105C73v44Ev,
  (VTBL_ENTRY)&_ZN6S105C73v45Ev,
  (VTBL_ENTRY)&_ZN6S105C73v46Ev,
  (VTBL_ENTRY)&_ZN6S105C73v47Ev,
  (VTBL_ENTRY)&_ZN6S105C73v48Ev,
  (VTBL_ENTRY)&_ZN6S105C73v49Ev,
  (VTBL_ENTRY)&_ZN6S105C73v50Ev,
  (VTBL_ENTRY)&_ZN6S105C73v51Ev,
  (VTBL_ENTRY)&_ZN6S105C73v52Ev,
  (VTBL_ENTRY)&_ZN6S105C73v53Ev,
  (VTBL_ENTRY)&_ZN6S105C73v54Ev,
  (VTBL_ENTRY)&_ZN6S105C73v55Ev,
  (VTBL_ENTRY)&_ZN6S105C73v56Ev,
  (VTBL_ENTRY)&_ZN6S105C73v57Ev,
  (VTBL_ENTRY)&_ZN6S105C73v58Ev,
  (VTBL_ENTRY)&_ZN6S105C73v59Ev,
  (VTBL_ENTRY)&_ZN6S105C73v60Ev,
  (VTBL_ENTRY)&_ZN6S105C73v61Ev,
  (VTBL_ENTRY)&_ZN6S105C73v62Ev,
  (VTBL_ENTRY)&_ZN6S105C73v63Ev,
  (VTBL_ENTRY)&_ZN6S105C73v64Ev,
  (VTBL_ENTRY)&_ZN6S105C73v65Ev,
  (VTBL_ENTRY)&_ZN6S105C73v66Ev,
  (VTBL_ENTRY)&_ZN6S105C73v67Ev,
  (VTBL_ENTRY)&_ZN6S105C73v68Ev,
  (VTBL_ENTRY)&_ZN6S105C73v69Ev,
  (VTBL_ENTRY)&_ZN6S105C63v70Ev,
  (VTBL_ENTRY)&_ZN6S105C63v71Ev,
  (VTBL_ENTRY)&_ZN6S105C53v72Ev,
  (VTBL_ENTRY)&_ZN6S105C53v73Ev,
  (VTBL_ENTRY)&_ZN6S105C53v74Ev,
  (VTBL_ENTRY)&_ZN6S105C53v75Ev,
  (VTBL_ENTRY)&_ZN6S105C53v76Ev,
  (VTBL_ENTRY)&_ZN6S105C53v77Ev,
  (VTBL_ENTRY)&_ZN6S105C53v78Ev,
  (VTBL_ENTRY)&_ZN6S105C53v79Ev,
  (VTBL_ENTRY)&_ZN6S105C53v80Ev,
  (VTBL_ENTRY)&_ZN6S105C53v81Ev,
  (VTBL_ENTRY)&_ZN6S105C53v82Ev,
  (VTBL_ENTRY)&_ZN6S105C53v83Ev,
  (VTBL_ENTRY)&_ZN6S105C53v84Ev,
  (VTBL_ENTRY)&_ZN6S105C53v85Ev,
  (VTBL_ENTRY)&_ZN6S105C53v86Ev,
  (VTBL_ENTRY)&_ZN6S105C53v87Ev,
  (VTBL_ENTRY)&_ZN6S105C53v88Ev,
  (VTBL_ENTRY)&_ZN6S105C53v89Ev,
  (VTBL_ENTRY)&_ZN6S105C53v90Ev,
  (VTBL_ENTRY)&_ZN6S105C53v91Ev,
  (VTBL_ENTRY)&_ZN6S105C53v92Ev,
  (VTBL_ENTRY)&_ZN6S105C53v93Ev,
  (VTBL_ENTRY)&_ZN6S105C53v94Ev,
  (VTBL_ENTRY)&_ZN6S105C53v95Ev,
  (VTBL_ENTRY)&_ZN6S105C53v96Ev,
  (VTBL_ENTRY)&_ZN6S105C53v97Ev,
  (VTBL_ENTRY)&_ZN6S105C53v98Ev,
  (VTBL_ENTRY)&_ZN6S105C53v99Ev,
  (VTBL_ENTRY)&_ZN6S105C54v100Ev,
  (VTBL_ENTRY)&_ZN6S105C54v101Ev,
  (VTBL_ENTRY)&_ZN6S105C54v102Ev,
  (VTBL_ENTRY)&_ZN6S105C54v103Ev,
  (VTBL_ENTRY)&_ZN6S105C54v104Ev,
  (VTBL_ENTRY)&_ZN6S105C54v105Ev,
  (VTBL_ENTRY)&_ZN6S105C54v106Ev,
  (VTBL_ENTRY)&_ZN6S105C54v107Ev,
  (VTBL_ENTRY)&_ZN6S105C54v108Ev,
  (VTBL_ENTRY)&_ZN6S105C54v109Ev,
  (VTBL_ENTRY)&_ZN6S105C54v110Ev,
  (VTBL_ENTRY)&_ZN6S105C54v111Ev,
  (VTBL_ENTRY)&_ZN6S105C54v112Ev,
  (VTBL_ENTRY)&_ZN6S105C54v113Ev,
  (VTBL_ENTRY)&_ZN6S105C54v114Ev,
  (VTBL_ENTRY)&_ZN6S105C54v115Ev,
  (VTBL_ENTRY)&_ZN6S105C54v116Ev,
  (VTBL_ENTRY)&_ZN6S105C54v117Ev,
  (VTBL_ENTRY)&_ZN6S105C54v118Ev,
  (VTBL_ENTRY)&_ZN6S105C54v119Ev,
  (VTBL_ENTRY)&_ZN6S105C54v120Ev,
  (VTBL_ENTRY)&_ZN6S105C54v121Ev,
  (VTBL_ENTRY)&_ZN6S105C54v122Ev,
  (VTBL_ENTRY)&_ZN6S105C54v123Ev,
  (VTBL_ENTRY)&_ZN6S105C54v124Ev,
  (VTBL_ENTRY)&_ZN6S105C54v125Ev,
  (VTBL_ENTRY)&_ZN6S105C54v126Ev,
  (VTBL_ENTRY)&_ZN6S105C54v127Ev,
  (VTBL_ENTRY)&_ZN6S105C54v128Ev,
  (VTBL_ENTRY)&_ZN6S105C54v129Ev,
  (VTBL_ENTRY)&_ZN6S105C54v130Ev,
  (VTBL_ENTRY)&_ZN6S105C54v131Ev,
  (VTBL_ENTRY)&_ZN6S105C54v132Ev,
  (VTBL_ENTRY)&_ZN6S105C54v133Ev,
  (VTBL_ENTRY)&_ZN6S105C54v134Ev,
  (VTBL_ENTRY)&_ZN6S105C54v135Ev,
  (VTBL_ENTRY)&_ZN6S105C54v136Ev,
  (VTBL_ENTRY)&_ZN6S105C54v137Ev,
  (VTBL_ENTRY)&_ZN6S105C54v138Ev,
  (VTBL_ENTRY)&_ZN6S105C54v139Ev,
  (VTBL_ENTRY)&_ZN6S105C54v140Ev,
  (VTBL_ENTRY)&_ZN6S105C54v141Ev,
  (VTBL_ENTRY)&_ZN6S105C54v142Ev,
  (VTBL_ENTRY)&_ZN6S105C54v143Ev,
  (VTBL_ENTRY)&_ZN6S105C54v144Ev,
  (VTBL_ENTRY)&_ZN6S105C54v145Ev,
  (VTBL_ENTRY)&_ZN6S105C54v146Ev,
  (VTBL_ENTRY)&_ZN6S105C54v147Ev,
  (VTBL_ENTRY)&_ZN6S105C44v148Ev,
  (VTBL_ENTRY)&_ZN6S105C44v149Ev,
  (VTBL_ENTRY)&_ZN6S105C44v150Ev,
  (VTBL_ENTRY)&_ZN6S105C44v151Ev,
  (VTBL_ENTRY)&_ZN6S105C44v152Ev,
  (VTBL_ENTRY)&_ZN6S105C44v153Ev,
  (VTBL_ENTRY)&_ZN6S105C44v154Ev,
  (VTBL_ENTRY)&_ZN6S105C44v155Ev,
  (VTBL_ENTRY)&_ZN6S105C44v156Ev,
  (VTBL_ENTRY)&_ZN6S105C44v157Ev,
  (VTBL_ENTRY)&_ZN6S105C44v158Ev,
  (VTBL_ENTRY)&_ZN6S105C44v159Ev,
  (VTBL_ENTRY)&_ZN6S105C44v160Ev,
  (VTBL_ENTRY)&_ZN6S105C44v161Ev,
  (VTBL_ENTRY)&_ZN6S105C44v162Ev,
  (VTBL_ENTRY)&_ZN6S105C44v163Ev,
  (VTBL_ENTRY)&_ZN6S105C44v164Ev,
  (VTBL_ENTRY)&_ZN6S105C44v165Ev,
  (VTBL_ENTRY)&_ZN6S105C44v166Ev,
  (VTBL_ENTRY)&_ZN6S105C44v167Ev,
  (VTBL_ENTRY)&_ZN6S105C44v168Ev,
  (VTBL_ENTRY)&_ZN6S105C44v169Ev,
  (VTBL_ENTRY)&_ZN6S105C44v170Ev,
  (VTBL_ENTRY)&_ZN6S105C44v171Ev,
  (VTBL_ENTRY)&_ZN6S105C44v172Ev,
  (VTBL_ENTRY)&_ZN6S105C44v173Ev,
  (VTBL_ENTRY)&_ZN6S105C44v174Ev,
  (VTBL_ENTRY)&_ZN6S105C44v175Ev,
  (VTBL_ENTRY)&_ZN6S105C44v176Ev,
  (VTBL_ENTRY)&_ZN6S105C44v177Ev,
  (VTBL_ENTRY)&_ZN6S105C44v178Ev,
  (VTBL_ENTRY)&_ZN6S105C44v179Ev,
  (VTBL_ENTRY)&_ZN6S105C44v180Ev,
  (VTBL_ENTRY)&_ZN6S105C44v181Ev,
  (VTBL_ENTRY)&_ZN6S105C44v182Ev,
  (VTBL_ENTRY)&_ZN6S105C44v183Ev,
  (VTBL_ENTRY)&_ZN6S105C44v184Ev,
  (VTBL_ENTRY)&_ZN6S105C44v185Ev,
  (VTBL_ENTRY)&_ZN6S105C44v186Ev,
  (VTBL_ENTRY)&_ZN6S105C34v187Ev,
  (VTBL_ENTRY)&_ZN6S105C34v188Ev,
  (VTBL_ENTRY)&_ZN6S105C34v189Ev,
  (VTBL_ENTRY)&_ZN6S105C34v190Ev,
  (VTBL_ENTRY)&_ZN6S105C34v191Ev,
  (VTBL_ENTRY)&_ZN6S105C34v192Ev,
  (VTBL_ENTRY)&_ZN6S105C34v193Ev,
  (VTBL_ENTRY)&_ZN6S105C34v194Ev,
  (VTBL_ENTRY)&_ZN6S105C34v195Ev,
  (VTBL_ENTRY)&_ZN6S105C34v196Ev,
  (VTBL_ENTRY)&_ZN6S105C34v197Ev,
  (VTBL_ENTRY)&_ZN6S105C34v198Ev,
  (VTBL_ENTRY)&_ZN6S105C34v199Ev,
  (VTBL_ENTRY)&_ZN6S105C34v200Ev,
  (VTBL_ENTRY)&_ZN6S105C34v201Ev,
  (VTBL_ENTRY)&_ZN6S105C34v202Ev,
  (VTBL_ENTRY)&_ZN6S105C34v203Ev,
  (VTBL_ENTRY)&_ZN6S105C34v204Ev,
  (VTBL_ENTRY)&_ZN6S105C34v205Ev,
  (VTBL_ENTRY)&_ZN6S105C34v206Ev,
  (VTBL_ENTRY)&_ZN6S105C34v207Ev,
  (VTBL_ENTRY)&_ZN6S105C34v208Ev,
  (VTBL_ENTRY)&_ZN6S105C34v209Ev,
  (VTBL_ENTRY)&_ZN6S105C24v210Ev,
  (VTBL_ENTRY)&_ZN6S105C24v211Ev,
  (VTBL_ENTRY)&_ZN6S105C24v212Ev,
  (VTBL_ENTRY)&_ZN6S105C24v213Ev,
  (VTBL_ENTRY)&_ZN6S105C24v214Ev,
  (VTBL_ENTRY)&_ZN6S105C24v215Ev,
  (VTBL_ENTRY)&_ZN6S105C24v216Ev,
  (VTBL_ENTRY)&_ZN6S105C24v217Ev,
  (VTBL_ENTRY)&_ZN6S105C12v1Ev,
  (VTBL_ENTRY)&_ZN6S105C12v2Ev,
  (VTBL_ENTRY)&_ZN6S105C12v3Ev,
  (VTBL_ENTRY)&_ZN6S105C12v4Ev,
  (VTBL_ENTRY)&_ZN6S105C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S105C1[];
extern  VTBL_ENTRY _ZTV6S105C1[];
Class_Descriptor cd_S105C1 = {  "S105C1", // class name
  bases_S105C1, 6,
  &(vtc_S105C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(960,676), // object size
  NSPAIRA(_ZTI6S105C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S105C1),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C7  {
  int s81c7f0;
  __tsi64 s81c7f1;
  void *s81c7f2[4];
  int s81c7f3[2];
  void *s81c7f4;
  ::S85C27_nt s81c7f5;
  void *s81c7f6[2];
  virtual  ~S81C7(); // _ZN5S81C7D1Ev
  virtual void  v4(); // _ZN5S81C72v4Ev
  virtual void  v5(); // _ZN5S81C72v5Ev
  virtual void  v6(); // _ZN5S81C72v6Ev
  virtual void  v7(); // _ZN5S81C72v7Ev
  virtual void  v8(); // _ZN5S81C72v8Ev
  virtual void  v9(); // _ZN5S81C72v9Ev
  virtual void  v10(); // _ZN5S81C73v10Ev
  virtual void  v11(); // _ZN5S81C73v11Ev
  virtual void  v12(); // _ZN5S81C73v12Ev
  virtual void  v13(); // _ZN5S81C73v13Ev
  virtual void  v14(); // _ZN5S81C73v14Ev
  virtual void  v15(); // _ZN5S81C73v15Ev
  virtual void  v16(); // _ZN5S81C73v16Ev
  virtual void  v17(); // _ZN5S81C73v17Ev
  virtual void  v18(); // _ZN5S81C73v18Ev
  virtual void  v19(); // _ZN5S81C73v19Ev
  virtual void  v20(); // _ZN5S81C73v20Ev
  virtual void  v21(); // _ZN5S81C73v21Ev
  virtual void  v22(); // _ZN5S81C73v22Ev
  virtual void  v23(); // _ZN5S81C73v23Ev
  virtual void  v24(); // _ZN5S81C73v24Ev
  virtual void  v25(); // _ZN5S81C73v25Ev
  virtual void  v26(); // _ZN5S81C73v26Ev
  virtual void  v27(); // _ZN5S81C73v27Ev
  virtual void  v28(); // _ZN5S81C73v28Ev
  virtual void  v29(); // _ZN5S81C73v29Ev
  virtual void  v30(); // _ZN5S81C73v30Ev
  virtual void  v31(); // _ZN5S81C73v31Ev
  virtual void  v32(); // _ZN5S81C73v32Ev
  virtual void  v33(); // _ZN5S81C73v33Ev
  virtual void  v34(); // _ZN5S81C73v34Ev
  virtual void  v35(); // _ZN5S81C73v35Ev
  virtual void  v36(); // _ZN5S81C73v36Ev
  virtual void  v37(); // _ZN5S81C73v37Ev
  virtual void  v38(); // _ZN5S81C73v38Ev
  virtual void  v39(); // _ZN5S81C73v39Ev
  virtual void  v40(); // _ZN5S81C73v40Ev
  virtual void  v41(); // _ZN5S81C73v41Ev
  virtual void  v42(); // _ZN5S81C73v42Ev
  virtual void  v43(); // _ZN5S81C73v43Ev
  virtual void  v44(); // _ZN5S81C73v44Ev
  virtual void  v45(); // _ZN5S81C73v45Ev
  virtual void  v46(); // _ZN5S81C73v46Ev
  virtual void  v47(); // _ZN5S81C73v47Ev
  virtual void  v48(); // _ZN5S81C73v48Ev
  virtual void  v49(); // _ZN5S81C73v49Ev
  virtual void  v50(); // _ZN5S81C73v50Ev
  virtual void  v51(); // _ZN5S81C73v51Ev
  virtual void  v52(); // _ZN5S81C73v52Ev
  virtual void  v53(); // _ZN5S81C73v53Ev
  virtual void  v54(); // _ZN5S81C73v54Ev
  virtual void  v55(); // _ZN5S81C73v55Ev
  virtual void  v56(); // _ZN5S81C73v56Ev
  virtual void  v57(); // _ZN5S81C73v57Ev
  virtual void  v58(); // _ZN5S81C73v58Ev
  virtual void  v59(); // _ZN5S81C73v59Ev
  virtual void  v60(); // _ZN5S81C73v60Ev
  virtual void  v61(); // _ZN5S81C73v61Ev
  virtual void  v62(); // _ZN5S81C73v62Ev
  virtual void  v63(); // _ZN5S81C73v63Ev
  virtual void  v64(); // _ZN5S81C73v64Ev
  virtual void  v65(); // _ZN5S81C73v65Ev
  virtual void  v66(); // _ZN5S81C73v66Ev
  virtual void  v67(); // _ZN5S81C73v67Ev
  S81C7(); // tgen
};
//SIG(-1 S81C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S81C7 ::~S81C7(){ note_dtor("S81C7", this);}
void  S81C7 ::v4(){vfunc_called(this, "_ZN5S81C72v4Ev");}
void  S81C7 ::v5(){vfunc_called(this, "_ZN5S81C72v5Ev");}
void  S81C7 ::v6(){vfunc_called(this, "_ZN5S81C72v6Ev");}
void  S81C7 ::v7(){vfunc_called(this, "_ZN5S81C72v7Ev");}
void  S81C7 ::v8(){vfunc_called(this, "_ZN5S81C72v8Ev");}
void  S81C7 ::v9(){vfunc_called(this, "_ZN5S81C72v9Ev");}
void  S81C7 ::v10(){vfunc_called(this, "_ZN5S81C73v10Ev");}
void  S81C7 ::v11(){vfunc_called(this, "_ZN5S81C73v11Ev");}
void  S81C7 ::v12(){vfunc_called(this, "_ZN5S81C73v12Ev");}
void  S81C7 ::v13(){vfunc_called(this, "_ZN5S81C73v13Ev");}
void  S81C7 ::v14(){vfunc_called(this, "_ZN5S81C73v14Ev");}
void  S81C7 ::v15(){vfunc_called(this, "_ZN5S81C73v15Ev");}
void  S81C7 ::v16(){vfunc_called(this, "_ZN5S81C73v16Ev");}
void  S81C7 ::v17(){vfunc_called(this, "_ZN5S81C73v17Ev");}
void  S81C7 ::v18(){vfunc_called(this, "_ZN5S81C73v18Ev");}
void  S81C7 ::v19(){vfunc_called(this, "_ZN5S81C73v19Ev");}
void  S81C7 ::v20(){vfunc_called(this, "_ZN5S81C73v20Ev");}
void  S81C7 ::v21(){vfunc_called(this, "_ZN5S81C73v21Ev");}
void  S81C7 ::v22(){vfunc_called(this, "_ZN5S81C73v22Ev");}
void  S81C7 ::v23(){vfunc_called(this, "_ZN5S81C73v23Ev");}
void  S81C7 ::v24(){vfunc_called(this, "_ZN5S81C73v24Ev");}
void  S81C7 ::v25(){vfunc_called(this, "_ZN5S81C73v25Ev");}
void  S81C7 ::v26(){vfunc_called(this, "_ZN5S81C73v26Ev");}
void  S81C7 ::v27(){vfunc_called(this, "_ZN5S81C73v27Ev");}
void  S81C7 ::v28(){vfunc_called(this, "_ZN5S81C73v28Ev");}
void  S81C7 ::v29(){vfunc_called(this, "_ZN5S81C73v29Ev");}
void  S81C7 ::v30(){vfunc_called(this, "_ZN5S81C73v30Ev");}
void  S81C7 ::v31(){vfunc_called(this, "_ZN5S81C73v31Ev");}
void  S81C7 ::v32(){vfunc_called(this, "_ZN5S81C73v32Ev");}
void  S81C7 ::v33(){vfunc_called(this, "_ZN5S81C73v33Ev");}
void  S81C7 ::v34(){vfunc_called(this, "_ZN5S81C73v34Ev");}
void  S81C7 ::v35(){vfunc_called(this, "_ZN5S81C73v35Ev");}
void  S81C7 ::v36(){vfunc_called(this, "_ZN5S81C73v36Ev");}
void  S81C7 ::v37(){vfunc_called(this, "_ZN5S81C73v37Ev");}
void  S81C7 ::v38(){vfunc_called(this, "_ZN5S81C73v38Ev");}
void  S81C7 ::v39(){vfunc_called(this, "_ZN5S81C73v39Ev");}
void  S81C7 ::v40(){vfunc_called(this, "_ZN5S81C73v40Ev");}
void  S81C7 ::v41(){vfunc_called(this, "_ZN5S81C73v41Ev");}
void  S81C7 ::v42(){vfunc_called(this, "_ZN5S81C73v42Ev");}
void  S81C7 ::v43(){vfunc_called(this, "_ZN5S81C73v43Ev");}
void  S81C7 ::v44(){vfunc_called(this, "_ZN5S81C73v44Ev");}
void  S81C7 ::v45(){vfunc_called(this, "_ZN5S81C73v45Ev");}
void  S81C7 ::v46(){vfunc_called(this, "_ZN5S81C73v46Ev");}
void  S81C7 ::v47(){vfunc_called(this, "_ZN5S81C73v47Ev");}
void  S81C7 ::v48(){vfunc_called(this, "_ZN5S81C73v48Ev");}
void  S81C7 ::v49(){vfunc_called(this, "_ZN5S81C73v49Ev");}
void  S81C7 ::v50(){vfunc_called(this, "_ZN5S81C73v50Ev");}
void  S81C7 ::v51(){vfunc_called(this, "_ZN5S81C73v51Ev");}
void  S81C7 ::v52(){vfunc_called(this, "_ZN5S81C73v52Ev");}
void  S81C7 ::v53(){vfunc_called(this, "_ZN5S81C73v53Ev");}
void  S81C7 ::v54(){vfunc_called(this, "_ZN5S81C73v54Ev");}
void  S81C7 ::v55(){vfunc_called(this, "_ZN5S81C73v55Ev");}
void  S81C7 ::v56(){vfunc_called(this, "_ZN5S81C73v56Ev");}
void  S81C7 ::v57(){vfunc_called(this, "_ZN5S81C73v57Ev");}
void  S81C7 ::v58(){vfunc_called(this, "_ZN5S81C73v58Ev");}
void  S81C7 ::v59(){vfunc_called(this, "_ZN5S81C73v59Ev");}
void  S81C7 ::v60(){vfunc_called(this, "_ZN5S81C73v60Ev");}
void  S81C7 ::v61(){vfunc_called(this, "_ZN5S81C73v61Ev");}
void  S81C7 ::v62(){vfunc_called(this, "_ZN5S81C73v62Ev");}
void  S81C7 ::v63(){vfunc_called(this, "_ZN5S81C73v63Ev");}
void  S81C7 ::v64(){vfunc_called(this, "_ZN5S81C73v64Ev");}
void  S81C7 ::v65(){vfunc_called(this, "_ZN5S81C73v65Ev");}
void  S81C7 ::v66(){vfunc_called(this, "_ZN5S81C73v66Ev");}
void  S81C7 ::v67(){vfunc_called(this, "_ZN5S81C73v67Ev");}
S81C7 ::S81C7(){ note_ctor("S81C7", this);} // tgen

static void Test_S81C7()
{
  extern Class_Descriptor cd_S81C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S81C7, buf);
    S81C7 *dp, &lv = *(dp=new (buf) S81C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S81C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C7)");
    check_field_offset(lv, s81c7f0, ABISELECT(8,4), "S81C7.s81c7f0");
    check_field_offset(lv, s81c7f1, ABISELECT(16,8), "S81C7.s81c7f1");
    check_field_offset(lv, s81c7f2, ABISELECT(24,16), "S81C7.s81c7f2");
    check_field_offset(lv, s81c7f3, ABISELECT(56,32), "S81C7.s81c7f3");
    check_field_offset(lv, s81c7f4, ABISELECT(64,40), "S81C7.s81c7f4");
    check_field_offset(lv, s81c7f5, ABISELECT(72,44), "S81C7.s81c7f5");
    check_field_offset(lv, s81c7f6, ABISELECT(80,52), "S81C7.s81c7f6");
    test_class_info(&lv, &cd_S81C7);
    dp->~S81C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C7(Test_S81C7, "S81C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S81C7C1Ev();
extern void _ZN5S81C7D1Ev();
Name_Map name_map_S81C7[] = {
  NSPAIR(_ZN5S81C7C1Ev),
  NSPAIR(_ZN5S81C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S81C7[];
extern void _ZN5S81C7D1Ev();
extern void _ZN5S81C7D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
static  VTBL_ENTRY vtc_S81C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C7[0]),
  (VTBL_ENTRY)&_ZN5S81C7D1Ev,
  (VTBL_ENTRY)&_ZN5S81C7D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
Class_Descriptor cd_S81C7 = {  "S81C7", // class name
  0,0,//no base classes
  &(vtc_S81C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S81C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S81C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C6  : S81C7 {
  virtual  ~S81C6(); // _ZN5S81C6D1Ev
  virtual void  v68(); // _ZN5S81C63v68Ev
  virtual void  v69(); // _ZN5S81C63v69Ev
  S81C6(); // tgen
};
//SIG(-1 S81C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S81C6 ::~S81C6(){ note_dtor("S81C6", this);}
void  S81C6 ::v68(){vfunc_called(this, "_ZN5S81C63v68Ev");}
void  S81C6 ::v69(){vfunc_called(this, "_ZN5S81C63v69Ev");}
S81C6 ::S81C6(){ note_ctor("S81C6", this);} // tgen

static void Test_S81C6()
{
  extern Class_Descriptor cd_S81C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S81C6, buf);
    S81C6 *dp, &lv = *(dp=new (buf) S81C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S81C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C6)");
    check_base_class_offset(lv, (S81C7*), 0, "S81C6");
    test_class_info(&lv, &cd_S81C6);
    dp->~S81C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C6(Test_S81C6, "S81C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S81C6C1Ev();
extern void _ZN5S81C6D1Ev();
Name_Map name_map_S81C6[] = {
  NSPAIR(_ZN5S81C6C1Ev),
  NSPAIR(_ZN5S81C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
static Base_Class bases_S81C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C6[];
extern void _ZN5S81C6D1Ev();
extern void _ZN5S81C6D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
static  VTBL_ENTRY vtc_S81C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C6[0]),
  (VTBL_ENTRY)&_ZN5S81C6D1Ev,
  (VTBL_ENTRY)&_ZN5S81C6D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
};
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
Class_Descriptor cd_S81C6 = {  "S81C6", // class name
  bases_S81C6, 1,
  &(vtc_S81C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S81C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C5  : S81C6 {
  ::S80C9_nt s81c5f0;
  int s81c5f1;
  unsigned int s81c5f2:1;
  unsigned int s81c5f3:1;
  unsigned int s81c5f4:1;
  unsigned int s81c5f5:1;
  ::S85C35 s81c5f6;
  ::S85C22_nt s81c5f7;
  void *s81c5f8;
  ::S80C31 s81c5f9;
  ::S80C31 s81c5f10;
  ::S80C29 s81c5f11;
  ::S80C19 s81c5f12;
  char s81c5f13;
  int s81c5f14;
  void *s81c5f15;
  ::S85C27_nt s81c5f16;
  ::S85C27_nt s81c5f17;
  ::S85C27_nt s81c5f18;
  ::S85C27_nt s81c5f19;
  ::S85C27_nt s81c5f20;
  ::S85C27_nt s81c5f21;
  ::S80C21_nt s81c5f22;
  ::S80C21_nt s81c5f23;
  ::S80C21_nt s81c5f24;
  ::S80C21_nt s81c5f25;
  ::S80C21_nt s81c5f26;
  ::S80C21_nt s81c5f27;
  ::S80C21_nt s81c5f28;
  ::S80C21_nt s81c5f29;
  ::S80C21_nt s81c5f30;
  ::S80C21_nt s81c5f31;
  virtual  ~S81C5(); // _ZN5S81C5D1Ev
  virtual void  v70(); // _ZN5S81C53v70Ev
  virtual void  v71(); // _ZN5S81C53v71Ev
  virtual void  v72(); // _ZN5S81C53v72Ev
  virtual void  v73(); // _ZN5S81C53v73Ev
  virtual void  v74(); // _ZN5S81C53v74Ev
  virtual void  v75(); // _ZN5S81C53v75Ev
  virtual void  v76(); // _ZN5S81C53v76Ev
  virtual void  v77(); // _ZN5S81C53v77Ev
  virtual void  v78(); // _ZN5S81C53v78Ev
  virtual void  v79(); // _ZN5S81C53v79Ev
  virtual void  v80(); // _ZN5S81C53v80Ev
  virtual void  v81(); // _ZN5S81C53v81Ev
  virtual void  v82(); // _ZN5S81C53v82Ev
  virtual void  v83(); // _ZN5S81C53v83Ev
  virtual void  v84(); // _ZN5S81C53v84Ev
  virtual void  v85(); // _ZN5S81C53v85Ev
  virtual void  v86(); // _ZN5S81C53v86Ev
  virtual void  v87(); // _ZN5S81C53v87Ev
  virtual void  v88(); // _ZN5S81C53v88Ev
  virtual void  v89(); // _ZN5S81C53v89Ev
  virtual void  v90(); // _ZN5S81C53v90Ev
  virtual void  v91(); // _ZN5S81C53v91Ev
  virtual void  v92(); // _ZN5S81C53v92Ev
  virtual void  v93(); // _ZN5S81C53v93Ev
  virtual void  v94(); // _ZN5S81C53v94Ev
  virtual void  v95(); // _ZN5S81C53v95Ev
  virtual void  v96(); // _ZN5S81C53v96Ev
  virtual void  v97(); // _ZN5S81C53v97Ev
  virtual void  v98(); // _ZN5S81C53v98Ev
  virtual void  v99(); // _ZN5S81C53v99Ev
  virtual void  v100(); // _ZN5S81C54v100Ev
  virtual void  v101(); // _ZN5S81C54v101Ev
  virtual void  v102(); // _ZN5S81C54v102Ev
  virtual void  v103(); // _ZN5S81C54v103Ev
  virtual void  v104(); // _ZN5S81C54v104Ev
  virtual void  v105(); // _ZN5S81C54v105Ev
  virtual void  v106(); // _ZN5S81C54v106Ev
  virtual void  v107(); // _ZN5S81C54v107Ev
  virtual void  v108(); // _ZN5S81C54v108Ev
  virtual void  v109(); // _ZN5S81C54v109Ev
  virtual void  v110(); // _ZN5S81C54v110Ev
  virtual void  v111(); // _ZN5S81C54v111Ev
  virtual void  v112(); // _ZN5S81C54v112Ev
  virtual void  v113(); // _ZN5S81C54v113Ev
  virtual void  v114(); // _ZN5S81C54v114Ev
  virtual void  v115(); // _ZN5S81C54v115Ev
  virtual void  v116(); // _ZN5S81C54v116Ev
  virtual void  v117(); // _ZN5S81C54v117Ev
  virtual void  v118(); // _ZN5S81C54v118Ev
  virtual void  v119(); // _ZN5S81C54v119Ev
  virtual void  v120(); // _ZN5S81C54v120Ev
  virtual void  v121(); // _ZN5S81C54v121Ev
  virtual void  v122(); // _ZN5S81C54v122Ev
  virtual void  v123(); // _ZN5S81C54v123Ev
  virtual void  v124(); // _ZN5S81C54v124Ev
  virtual void  v125(); // _ZN5S81C54v125Ev
  virtual void  v126(); // _ZN5S81C54v126Ev
  virtual void  v127(); // _ZN5S81C54v127Ev
  virtual void  v128(); // _ZN5S81C54v128Ev
  virtual void  v129(); // _ZN5S81C54v129Ev
  virtual void  v130(); // _ZN5S81C54v130Ev
  virtual void  v131(); // _ZN5S81C54v131Ev
  virtual void  v132(); // _ZN5S81C54v132Ev
  virtual void  v133(); // _ZN5S81C54v133Ev
  virtual void  v134(); // _ZN5S81C54v134Ev
  virtual void  v135(); // _ZN5S81C54v135Ev
  virtual void  v136(); // _ZN5S81C54v136Ev
  virtual void  v137(); // _ZN5S81C54v137Ev
  virtual void  v138(); // _ZN5S81C54v138Ev
  virtual void  v139(); // _ZN5S81C54v139Ev
  virtual void  v140(); // _ZN5S81C54v140Ev
  virtual void  v141(); // _ZN5S81C54v141Ev
  virtual void  v142(); // _ZN5S81C54v142Ev
  virtual void  v143(); // _ZN5S81C54v143Ev
  virtual void  v144(); // _ZN5S81C54v144Ev
  virtual void  v145(); // _ZN5S81C54v145Ev
  S81C5(); // tgen
};
//SIG(-1 S81C5) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} Fp FC11{ BC12{ BC8}} FC11 FC13{ BC14{ BC8}} FC15{ BC16{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC17{ m Fp FC18{ m Fi[2]}} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17}


 S81C5 ::~S81C5(){ note_dtor("S81C5", this);}
void  S81C5 ::v70(){vfunc_called(this, "_ZN5S81C53v70Ev");}
void  S81C5 ::v71(){vfunc_called(this, "_ZN5S81C53v71Ev");}
void  S81C5 ::v72(){vfunc_called(this, "_ZN5S81C53v72Ev");}
void  S81C5 ::v73(){vfunc_called(this, "_ZN5S81C53v73Ev");}
void  S81C5 ::v74(){vfunc_called(this, "_ZN5S81C53v74Ev");}
void  S81C5 ::v75(){vfunc_called(this, "_ZN5S81C53v75Ev");}
void  S81C5 ::v76(){vfunc_called(this, "_ZN5S81C53v76Ev");}
void  S81C5 ::v77(){vfunc_called(this, "_ZN5S81C53v77Ev");}
void  S81C5 ::v78(){vfunc_called(this, "_ZN5S81C53v78Ev");}
void  S81C5 ::v79(){vfunc_called(this, "_ZN5S81C53v79Ev");}
void  S81C5 ::v80(){vfunc_called(this, "_ZN5S81C53v80Ev");}
void  S81C5 ::v81(){vfunc_called(this, "_ZN5S81C53v81Ev");}
void  S81C5 ::v82(){vfunc_called(this, "_ZN5S81C53v82Ev");}
void  S81C5 ::v83(){vfunc_called(this, "_ZN5S81C53v83Ev");}
void  S81C5 ::v84(){vfunc_called(this, "_ZN5S81C53v84Ev");}
void  S81C5 ::v85(){vfunc_called(this, "_ZN5S81C53v85Ev");}
void  S81C5 ::v86(){vfunc_called(this, "_ZN5S81C53v86Ev");}
void  S81C5 ::v87(){vfunc_called(this, "_ZN5S81C53v87Ev");}
void  S81C5 ::v88(){vfunc_called(this, "_ZN5S81C53v88Ev");}
void  S81C5 ::v89(){vfunc_called(this, "_ZN5S81C53v89Ev");}
void  S81C5 ::v90(){vfunc_called(this, "_ZN5S81C53v90Ev");}
void  S81C5 ::v91(){vfunc_called(this, "_ZN5S81C53v91Ev");}
void  S81C5 ::v92(){vfunc_called(this, "_ZN5S81C53v92Ev");}
void  S81C5 ::v93(){vfunc_called(this, "_ZN5S81C53v93Ev");}
void  S81C5 ::v94(){vfunc_called(this, "_ZN5S81C53v94Ev");}
void  S81C5 ::v95(){vfunc_called(this, "_ZN5S81C53v95Ev");}
void  S81C5 ::v96(){vfunc_called(this, "_ZN5S81C53v96Ev");}
void  S81C5 ::v97(){vfunc_called(this, "_ZN5S81C53v97Ev");}
void  S81C5 ::v98(){vfunc_called(this, "_ZN5S81C53v98Ev");}
void  S81C5 ::v99(){vfunc_called(this, "_ZN5S81C53v99Ev");}
void  S81C5 ::v100(){vfunc_called(this, "_ZN5S81C54v100Ev");}
void  S81C5 ::v101(){vfunc_called(this, "_ZN5S81C54v101Ev");}
void  S81C5 ::v102(){vfunc_called(this, "_ZN5S81C54v102Ev");}
void  S81C5 ::v103(){vfunc_called(this, "_ZN5S81C54v103Ev");}
void  S81C5 ::v104(){vfunc_called(this, "_ZN5S81C54v104Ev");}
void  S81C5 ::v105(){vfunc_called(this, "_ZN5S81C54v105Ev");}
void  S81C5 ::v106(){vfunc_called(this, "_ZN5S81C54v106Ev");}
void  S81C5 ::v107(){vfunc_called(this, "_ZN5S81C54v107Ev");}
void  S81C5 ::v108(){vfunc_called(this, "_ZN5S81C54v108Ev");}
void  S81C5 ::v109(){vfunc_called(this, "_ZN5S81C54v109Ev");}
void  S81C5 ::v110(){vfunc_called(this, "_ZN5S81C54v110Ev");}
void  S81C5 ::v111(){vfunc_called(this, "_ZN5S81C54v111Ev");}
void  S81C5 ::v112(){vfunc_called(this, "_ZN5S81C54v112Ev");}
void  S81C5 ::v113(){vfunc_called(this, "_ZN5S81C54v113Ev");}
void  S81C5 ::v114(){vfunc_called(this, "_ZN5S81C54v114Ev");}
void  S81C5 ::v115(){vfunc_called(this, "_ZN5S81C54v115Ev");}
void  S81C5 ::v116(){vfunc_called(this, "_ZN5S81C54v116Ev");}
void  S81C5 ::v117(){vfunc_called(this, "_ZN5S81C54v117Ev");}
void  S81C5 ::v118(){vfunc_called(this, "_ZN5S81C54v118Ev");}
void  S81C5 ::v119(){vfunc_called(this, "_ZN5S81C54v119Ev");}
void  S81C5 ::v120(){vfunc_called(this, "_ZN5S81C54v120Ev");}
void  S81C5 ::v121(){vfunc_called(this, "_ZN5S81C54v121Ev");}
void  S81C5 ::v122(){vfunc_called(this, "_ZN5S81C54v122Ev");}
void  S81C5 ::v123(){vfunc_called(this, "_ZN5S81C54v123Ev");}
void  S81C5 ::v124(){vfunc_called(this, "_ZN5S81C54v124Ev");}
void  S81C5 ::v125(){vfunc_called(this, "_ZN5S81C54v125Ev");}
void  S81C5 ::v126(){vfunc_called(this, "_ZN5S81C54v126Ev");}
void  S81C5 ::v127(){vfunc_called(this, "_ZN5S81C54v127Ev");}
void  S81C5 ::v128(){vfunc_called(this, "_ZN5S81C54v128Ev");}
void  S81C5 ::v129(){vfunc_called(this, "_ZN5S81C54v129Ev");}
void  S81C5 ::v130(){vfunc_called(this, "_ZN5S81C54v130Ev");}
void  S81C5 ::v131(){vfunc_called(this, "_ZN5S81C54v131Ev");}
void  S81C5 ::v132(){vfunc_called(this, "_ZN5S81C54v132Ev");}
void  S81C5 ::v133(){vfunc_called(this, "_ZN5S81C54v133Ev");}
void  S81C5 ::v134(){vfunc_called(this, "_ZN5S81C54v134Ev");}
void  S81C5 ::v135(){vfunc_called(this, "_ZN5S81C54v135Ev");}
void  S81C5 ::v136(){vfunc_called(this, "_ZN5S81C54v136Ev");}
void  S81C5 ::v137(){vfunc_called(this, "_ZN5S81C54v137Ev");}
void  S81C5 ::v138(){vfunc_called(this, "_ZN5S81C54v138Ev");}
void  S81C5 ::v139(){vfunc_called(this, "_ZN5S81C54v139Ev");}
void  S81C5 ::v140(){vfunc_called(this, "_ZN5S81C54v140Ev");}
void  S81C5 ::v141(){vfunc_called(this, "_ZN5S81C54v141Ev");}
void  S81C5 ::v142(){vfunc_called(this, "_ZN5S81C54v142Ev");}
void  S81C5 ::v143(){vfunc_called(this, "_ZN5S81C54v143Ev");}
void  S81C5 ::v144(){vfunc_called(this, "_ZN5S81C54v144Ev");}
void  S81C5 ::v145(){vfunc_called(this, "_ZN5S81C54v145Ev");}
S81C5 ::S81C5(){ note_ctor("S81C5", this);} // tgen

static void Test_S81C5()
{
  extern Class_Descriptor cd_S81C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(59,89)];
    init_test(&cd_S81C5, buf);
    S81C5 *dp, &lv = *(dp=new (buf) S81C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,352), "sizeof(S81C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C5)");
    check_base_class_offset(lv, (S81C7*)(S81C6*), 0, "S81C5");
    check_base_class_offset(lv, (S81C6*), 0, "S81C5");
    check_field_offset(lv, s81c5f0, ABISELECT(96,60), "S81C5.s81c5f0");
    check_field_offset(lv, s81c5f1, ABISELECT(124,88), "S81C5.s81c5f1");
    set_bf_and_test(lv, s81c5f2, ABISELECT(128,92), 0, 1, 1, "S81C5");
    set_bf_and_test(lv, s81c5f3, ABISELECT(128,92), 1, 1, 1, "S81C5");
    set_bf_and_test(lv, s81c5f4, ABISELECT(128,92), 2, 1, 1, "S81C5");
    set_bf_and_test(lv, s81c5f5, ABISELECT(128,92), 3, 1, 1, "S81C5");
    check_field_offset(lv, s81c5f6, ABISELECT(136,96), "S81C5.s81c5f6");
    check_field_offset(lv, s81c5f7, ABISELECT(152,108), "S81C5.s81c5f7");
    check_field_offset(lv, s81c5f8, ABISELECT(168,120), "S81C5.s81c5f8");
    check_field_offset(lv, s81c5f9, ABISELECT(176,124), "S81C5.s81c5f9");
    check_field_offset(lv, s81c5f10, ABISELECT(192,136), "S81C5.s81c5f10");
    check_field_offset(lv, s81c5f11, ABISELECT(208,148), "S81C5.s81c5f11");
    check_field_offset(lv, s81c5f12, ABISELECT(224,160), "S81C5.s81c5f12");
    check_field_offset(lv, s81c5f13, ABISELECT(240,172), "S81C5.s81c5f13");
    check_field_offset(lv, s81c5f14, ABISELECT(244,176), "S81C5.s81c5f14");
    check_field_offset(lv, s81c5f15, ABISELECT(248,180), "S81C5.s81c5f15");
    check_field_offset(lv, s81c5f16, ABISELECT(256,184), "S81C5.s81c5f16");
    check_field_offset(lv, s81c5f17, ABISELECT(264,192), "S81C5.s81c5f17");
    check_field_offset(lv, s81c5f18, ABISELECT(272,200), "S81C5.s81c5f18");
    check_field_offset(lv, s81c5f19, ABISELECT(280,208), "S81C5.s81c5f19");
    check_field_offset(lv, s81c5f20, ABISELECT(288,216), "S81C5.s81c5f20");
    check_field_offset(lv, s81c5f21, ABISELECT(296,224), "S81C5.s81c5f21");
    check_field_offset(lv, s81c5f22, ABISELECT(304,232), "S81C5.s81c5f22");
    check_field_offset(lv, s81c5f23, ABISELECT(320,244), "S81C5.s81c5f23");
    check_field_offset(lv, s81c5f24, ABISELECT(336,256), "S81C5.s81c5f24");
    check_field_offset(lv, s81c5f25, ABISELECT(352,268), "S81C5.s81c5f25");
    check_field_offset(lv, s81c5f26, ABISELECT(368,280), "S81C5.s81c5f26");
    check_field_offset(lv, s81c5f27, ABISELECT(384,292), "S81C5.s81c5f27");
    check_field_offset(lv, s81c5f28, ABISELECT(400,304), "S81C5.s81c5f28");
    check_field_offset(lv, s81c5f29, ABISELECT(416,316), "S81C5.s81c5f29");
    check_field_offset(lv, s81c5f30, ABISELECT(432,328), "S81C5.s81c5f30");
    check_field_offset(lv, s81c5f31, ABISELECT(448,340), "S81C5.s81c5f31");
    test_class_info(&lv, &cd_S81C5);
    dp->~S81C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C5(Test_S81C5, "S81C5", ABISELECT(464,352));

#else // __cplusplus

extern void _ZN5S81C5C1Ev();
extern void _ZN5S81C5D1Ev();
Name_Map name_map_S81C5[] = {
  NSPAIR(_ZN5S81C5C1Ev),
  NSPAIR(_ZN5S81C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
extern Class_Descriptor cd_S81C6;
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
static Base_Class bases_S81C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S81C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C5[];
extern void _ZN5S81C5D1Ev();
extern void _ZN5S81C5D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
extern void _ZN5S81C53v70Ev();
extern void _ZN5S81C53v71Ev();
extern void _ZN5S81C53v72Ev();
extern void _ZN5S81C53v73Ev();
extern void _ZN5S81C53v74Ev();
extern void _ZN5S81C53v75Ev();
extern void _ZN5S81C53v76Ev();
extern void _ZN5S81C53v77Ev();
extern void _ZN5S81C53v78Ev();
extern void _ZN5S81C53v79Ev();
extern void _ZN5S81C53v80Ev();
extern void _ZN5S81C53v81Ev();
extern void _ZN5S81C53v82Ev();
extern void _ZN5S81C53v83Ev();
extern void _ZN5S81C53v84Ev();
extern void _ZN5S81C53v85Ev();
extern void _ZN5S81C53v86Ev();
extern void _ZN5S81C53v87Ev();
extern void _ZN5S81C53v88Ev();
extern void _ZN5S81C53v89Ev();
extern void _ZN5S81C53v90Ev();
extern void _ZN5S81C53v91Ev();
extern void _ZN5S81C53v92Ev();
extern void _ZN5S81C53v93Ev();
extern void _ZN5S81C53v94Ev();
extern void _ZN5S81C53v95Ev();
extern void _ZN5S81C53v96Ev();
extern void _ZN5S81C53v97Ev();
extern void _ZN5S81C53v98Ev();
extern void _ZN5S81C53v99Ev();
extern void _ZN5S81C54v100Ev();
extern void _ZN5S81C54v101Ev();
extern void _ZN5S81C54v102Ev();
extern void _ZN5S81C54v103Ev();
extern void _ZN5S81C54v104Ev();
extern void _ZN5S81C54v105Ev();
extern void _ZN5S81C54v106Ev();
extern void _ZN5S81C54v107Ev();
extern void _ZN5S81C54v108Ev();
extern void _ZN5S81C54v109Ev();
extern void _ZN5S81C54v110Ev();
extern void _ZN5S81C54v111Ev();
extern void _ZN5S81C54v112Ev();
extern void _ZN5S81C54v113Ev();
extern void _ZN5S81C54v114Ev();
extern void _ZN5S81C54v115Ev();
extern void _ZN5S81C54v116Ev();
extern void _ZN5S81C54v117Ev();
extern void _ZN5S81C54v118Ev();
extern void _ZN5S81C54v119Ev();
extern void _ZN5S81C54v120Ev();
extern void _ZN5S81C54v121Ev();
extern void _ZN5S81C54v122Ev();
extern void _ZN5S81C54v123Ev();
extern void _ZN5S81C54v124Ev();
extern void _ZN5S81C54v125Ev();
extern void _ZN5S81C54v126Ev();
extern void _ZN5S81C54v127Ev();
extern void _ZN5S81C54v128Ev();
extern void _ZN5S81C54v129Ev();
extern void _ZN5S81C54v130Ev();
extern void _ZN5S81C54v131Ev();
extern void _ZN5S81C54v132Ev();
extern void _ZN5S81C54v133Ev();
extern void _ZN5S81C54v134Ev();
extern void _ZN5S81C54v135Ev();
extern void _ZN5S81C54v136Ev();
extern void _ZN5S81C54v137Ev();
extern void _ZN5S81C54v138Ev();
extern void _ZN5S81C54v139Ev();
extern void _ZN5S81C54v140Ev();
extern void _ZN5S81C54v141Ev();
extern void _ZN5S81C54v142Ev();
extern void _ZN5S81C54v143Ev();
extern void _ZN5S81C54v144Ev();
extern void _ZN5S81C54v145Ev();
static  VTBL_ENTRY vtc_S81C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C5[0]),
  (VTBL_ENTRY)&_ZN5S81C5D1Ev,
  (VTBL_ENTRY)&_ZN5S81C5D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
  (VTBL_ENTRY)&_ZN5S81C53v70Ev,
  (VTBL_ENTRY)&_ZN5S81C53v71Ev,
  (VTBL_ENTRY)&_ZN5S81C53v72Ev,
  (VTBL_ENTRY)&_ZN5S81C53v73Ev,
  (VTBL_ENTRY)&_ZN5S81C53v74Ev,
  (VTBL_ENTRY)&_ZN5S81C53v75Ev,
  (VTBL_ENTRY)&_ZN5S81C53v76Ev,
  (VTBL_ENTRY)&_ZN5S81C53v77Ev,
  (VTBL_ENTRY)&_ZN5S81C53v78Ev,
  (VTBL_ENTRY)&_ZN5S81C53v79Ev,
  (VTBL_ENTRY)&_ZN5S81C53v80Ev,
  (VTBL_ENTRY)&_ZN5S81C53v81Ev,
  (VTBL_ENTRY)&_ZN5S81C53v82Ev,
  (VTBL_ENTRY)&_ZN5S81C53v83Ev,
  (VTBL_ENTRY)&_ZN5S81C53v84Ev,
  (VTBL_ENTRY)&_ZN5S81C53v85Ev,
  (VTBL_ENTRY)&_ZN5S81C53v86Ev,
  (VTBL_ENTRY)&_ZN5S81C53v87Ev,
  (VTBL_ENTRY)&_ZN5S81C53v88Ev,
  (VTBL_ENTRY)&_ZN5S81C53v89Ev,
  (VTBL_ENTRY)&_ZN5S81C53v90Ev,
  (VTBL_ENTRY)&_ZN5S81C53v91Ev,
  (VTBL_ENTRY)&_ZN5S81C53v92Ev,
  (VTBL_ENTRY)&_ZN5S81C53v93Ev,
  (VTBL_ENTRY)&_ZN5S81C53v94Ev,
  (VTBL_ENTRY)&_ZN5S81C53v95Ev,
  (VTBL_ENTRY)&_ZN5S81C53v96Ev,
  (VTBL_ENTRY)&_ZN5S81C53v97Ev,
  (VTBL_ENTRY)&_ZN5S81C53v98Ev,
  (VTBL_ENTRY)&_ZN5S81C53v99Ev,
  (VTBL_ENTRY)&_ZN5S81C54v100Ev,
  (VTBL_ENTRY)&_ZN5S81C54v101Ev,
  (VTBL_ENTRY)&_ZN5S81C54v102Ev,
  (VTBL_ENTRY)&_ZN5S81C54v103Ev,
  (VTBL_ENTRY)&_ZN5S81C54v104Ev,
  (VTBL_ENTRY)&_ZN5S81C54v105Ev,
  (VTBL_ENTRY)&_ZN5S81C54v106Ev,
  (VTBL_ENTRY)&_ZN5S81C54v107Ev,
  (VTBL_ENTRY)&_ZN5S81C54v108Ev,
  (VTBL_ENTRY)&_ZN5S81C54v109Ev,
  (VTBL_ENTRY)&_ZN5S81C54v110Ev,
  (VTBL_ENTRY)&_ZN5S81C54v111Ev,
  (VTBL_ENTRY)&_ZN5S81C54v112Ev,
  (VTBL_ENTRY)&_ZN5S81C54v113Ev,
  (VTBL_ENTRY)&_ZN5S81C54v114Ev,
  (VTBL_ENTRY)&_ZN5S81C54v115Ev,
  (VTBL_ENTRY)&_ZN5S81C54v116Ev,
  (VTBL_ENTRY)&_ZN5S81C54v117Ev,
  (VTBL_ENTRY)&_ZN5S81C54v118Ev,
  (VTBL_ENTRY)&_ZN5S81C54v119Ev,
  (VTBL_ENTRY)&_ZN5S81C54v120Ev,
  (VTBL_ENTRY)&_ZN5S81C54v121Ev,
  (VTBL_ENTRY)&_ZN5S81C54v122Ev,
  (VTBL_ENTRY)&_ZN5S81C54v123Ev,
  (VTBL_ENTRY)&_ZN5S81C54v124Ev,
  (VTBL_ENTRY)&_ZN5S81C54v125Ev,
  (VTBL_ENTRY)&_ZN5S81C54v126Ev,
  (VTBL_ENTRY)&_ZN5S81C54v127Ev,
  (VTBL_ENTRY)&_ZN5S81C54v128Ev,
  (VTBL_ENTRY)&_ZN5S81C54v129Ev,
  (VTBL_ENTRY)&_ZN5S81C54v130Ev,
  (VTBL_ENTRY)&_ZN5S81C54v131Ev,
  (VTBL_ENTRY)&_ZN5S81C54v132Ev,
  (VTBL_ENTRY)&_ZN5S81C54v133Ev,
  (VTBL_ENTRY)&_ZN5S81C54v134Ev,
  (VTBL_ENTRY)&_ZN5S81C54v135Ev,
  (VTBL_ENTRY)&_ZN5S81C54v136Ev,
  (VTBL_ENTRY)&_ZN5S81C54v137Ev,
  (VTBL_ENTRY)&_ZN5S81C54v138Ev,
  (VTBL_ENTRY)&_ZN5S81C54v139Ev,
  (VTBL_ENTRY)&_ZN5S81C54v140Ev,
  (VTBL_ENTRY)&_ZN5S81C54v141Ev,
  (VTBL_ENTRY)&_ZN5S81C54v142Ev,
  (VTBL_ENTRY)&_ZN5S81C54v143Ev,
  (VTBL_ENTRY)&_ZN5S81C54v144Ev,
  (VTBL_ENTRY)&_ZN5S81C54v145Ev,
};
extern VTBL_ENTRY _ZTI5S81C5[];
extern  VTBL_ENTRY _ZTV5S81C5[];
Class_Descriptor cd_S81C5 = {  "S81C5", // class name
  bases_S81C5, 2,
  &(vtc_S81C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI5S81C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C5),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C4  : S81C5 {
  ::S85C27_nt s81c4f0;
  void *s81c4f1[9];
  ::S80C15 s81c4f2;
  ::S85C35 s81c4f3;
  ::S80C24 s81c4f4;
  int s81c4f5;
  unsigned int s81c4f6:1;
  unsigned int s81c4f7:1;
  unsigned int s81c4f8:1;
  unsigned int s81c4f9:1;
  unsigned int s81c4f10:1;
  unsigned int s81c4f11:1;
  unsigned int s81c4f12:1;
  unsigned int s81c4f13:1;
  unsigned int s81c4f14:1;
  unsigned int s81c4f15:1;
  unsigned int s81c4f16:1;
  unsigned int s81c4f17:1;
  unsigned int s81c4f18:1;
  unsigned int s81c4f19:1;
  unsigned int s81c4f20:1;
  unsigned int s81c4f21:1;
  unsigned int s81c4f22:1;
  unsigned int s81c4f23:1;
  unsigned int s81c4f24:1;
  unsigned int s81c4f25:1;
  unsigned int s81c4f26:1;
  unsigned int s81c4f27:1;
  void *s81c4f28;
  char s81c4f29[2];
  ::S80C8_nt s81c4f30;
  ::S85C27_nt s81c4f31;
  ::S85C27_nt s81c4f32;
  void *s81c4f33;
  ::S80C21_nt s81c4f34;
  ::S80C21_nt s81c4f35;
  ::S80C21_nt s81c4f36;
  ::S80C21_nt s81c4f37;
  ::S80C21_nt s81c4f38;
  virtual  ~S81C4(); // _ZN5S81C4D1Ev
  virtual void  v146(); // _ZN5S81C44v146Ev
  virtual void  v147(); // _ZN5S81C44v147Ev
  virtual void  v148(); // _ZN5S81C44v148Ev
  virtual void  v149(); // _ZN5S81C44v149Ev
  virtual void  v150(); // _ZN5S81C44v150Ev
  virtual void  v151(); // _ZN5S81C44v151Ev
  virtual void  v152(); // _ZN5S81C44v152Ev
  virtual void  v153(); // _ZN5S81C44v153Ev
  virtual void  v154(); // _ZN5S81C44v154Ev
  virtual void  v155(); // _ZN5S81C44v155Ev
  virtual void  v156(); // _ZN5S81C44v156Ev
  virtual void  v157(); // _ZN5S81C44v157Ev
  virtual void  v158(); // _ZN5S81C44v158Ev
  virtual void  v159(); // _ZN5S81C44v159Ev
  virtual void  v160(); // _ZN5S81C44v160Ev
  virtual void  v161(); // _ZN5S81C44v161Ev
  virtual void  v162(); // _ZN5S81C44v162Ev
  virtual void  v163(); // _ZN5S81C44v163Ev
  virtual void  v164(); // _ZN5S81C44v164Ev
  virtual void  v165(); // _ZN5S81C44v165Ev
  virtual void  v166(); // _ZN5S81C44v166Ev
  virtual void  v167(); // _ZN5S81C44v167Ev
  virtual void  v168(); // _ZN5S81C44v168Ev
  virtual void  v169(); // _ZN5S81C44v169Ev
  virtual void  v170(); // _ZN5S81C44v170Ev
  virtual void  v171(); // _ZN5S81C44v171Ev
  virtual void  v172(); // _ZN5S81C44v172Ev
  virtual void  v173(); // _ZN5S81C44v173Ev
  virtual void  v174(); // _ZN5S81C44v174Ev
  virtual void  v175(); // _ZN5S81C44v175Ev
  virtual void  v176(); // _ZN5S81C44v176Ev
  virtual void  v177(); // _ZN5S81C44v177Ev
  virtual void  v178(); // _ZN5S81C44v178Ev
  virtual void  v179(); // _ZN5S81C44v179Ev
  virtual void  v180(); // _ZN5S81C44v180Ev
  virtual void  v181(); // _ZN5S81C44v181Ev
  virtual void  v182(); // _ZN5S81C44v182Ev
  virtual void  v183(); // _ZN5S81C44v183Ev
  virtual void  v184(); // _ZN5S81C44v184Ev
  S81C4(); // tgen
};
//SIG(-1 S81C4) C1{ BC2{ BC3{ BC4{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} Fp FC12{ BC13{ BC9}} FC12 FC14{ BC15{ BC9}} FC16{ BC17{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC18{ m Fp FC19{ m Fi[2]}} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 FC5 Fp[9] FC20{ BC21{ BC9}} FC7 FC22{ BC23{ m FC24{ BC9} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC19 FC5 FC5 Fp FC18 FC18 FC18 FC18 FC18}


 S81C4 ::~S81C4(){ note_dtor("S81C4", this);}
void  S81C4 ::v146(){vfunc_called(this, "_ZN5S81C44v146Ev");}
void  S81C4 ::v147(){vfunc_called(this, "_ZN5S81C44v147Ev");}
void  S81C4 ::v148(){vfunc_called(this, "_ZN5S81C44v148Ev");}
void  S81C4 ::v149(){vfunc_called(this, "_ZN5S81C44v149Ev");}
void  S81C4 ::v150(){vfunc_called(this, "_ZN5S81C44v150Ev");}
void  S81C4 ::v151(){vfunc_called(this, "_ZN5S81C44v151Ev");}
void  S81C4 ::v152(){vfunc_called(this, "_ZN5S81C44v152Ev");}
void  S81C4 ::v153(){vfunc_called(this, "_ZN5S81C44v153Ev");}
void  S81C4 ::v154(){vfunc_called(this, "_ZN5S81C44v154Ev");}
void  S81C4 ::v155(){vfunc_called(this, "_ZN5S81C44v155Ev");}
void  S81C4 ::v156(){vfunc_called(this, "_ZN5S81C44v156Ev");}
void  S81C4 ::v157(){vfunc_called(this, "_ZN5S81C44v157Ev");}
void  S81C4 ::v158(){vfunc_called(this, "_ZN5S81C44v158Ev");}
void  S81C4 ::v159(){vfunc_called(this, "_ZN5S81C44v159Ev");}
void  S81C4 ::v160(){vfunc_called(this, "_ZN5S81C44v160Ev");}
void  S81C4 ::v161(){vfunc_called(this, "_ZN5S81C44v161Ev");}
void  S81C4 ::v162(){vfunc_called(this, "_ZN5S81C44v162Ev");}
void  S81C4 ::v163(){vfunc_called(this, "_ZN5S81C44v163Ev");}
void  S81C4 ::v164(){vfunc_called(this, "_ZN5S81C44v164Ev");}
void  S81C4 ::v165(){vfunc_called(this, "_ZN5S81C44v165Ev");}
void  S81C4 ::v166(){vfunc_called(this, "_ZN5S81C44v166Ev");}
void  S81C4 ::v167(){vfunc_called(this, "_ZN5S81C44v167Ev");}
void  S81C4 ::v168(){vfunc_called(this, "_ZN5S81C44v168Ev");}
void  S81C4 ::v169(){vfunc_called(this, "_ZN5S81C44v169Ev");}
void  S81C4 ::v170(){vfunc_called(this, "_ZN5S81C44v170Ev");}
void  S81C4 ::v171(){vfunc_called(this, "_ZN5S81C44v171Ev");}
void  S81C4 ::v172(){vfunc_called(this, "_ZN5S81C44v172Ev");}
void  S81C4 ::v173(){vfunc_called(this, "_ZN5S81C44v173Ev");}
void  S81C4 ::v174(){vfunc_called(this, "_ZN5S81C44v174Ev");}
void  S81C4 ::v175(){vfunc_called(this, "_ZN5S81C44v175Ev");}
void  S81C4 ::v176(){vfunc_called(this, "_ZN5S81C44v176Ev");}
void  S81C4 ::v177(){vfunc_called(this, "_ZN5S81C44v177Ev");}
void  S81C4 ::v178(){vfunc_called(this, "_ZN5S81C44v178Ev");}
void  S81C4 ::v179(){vfunc_called(this, "_ZN5S81C44v179Ev");}
void  S81C4 ::v180(){vfunc_called(this, "_ZN5S81C44v180Ev");}
void  S81C4 ::v181(){vfunc_called(this, "_ZN5S81C44v181Ev");}
void  S81C4 ::v182(){vfunc_called(this, "_ZN5S81C44v182Ev");}
void  S81C4 ::v183(){vfunc_called(this, "_ZN5S81C44v183Ev");}
void  S81C4 ::v184(){vfunc_called(this, "_ZN5S81C44v184Ev");}
S81C4 ::S81C4(){ note_ctor("S81C4", this);} // tgen

static void Test_S81C4()
{
  extern Class_Descriptor cd_S81C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,137)];
    init_test(&cd_S81C4, buf);
    S81C4 *dp, &lv = *(dp=new (buf) S81C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,544), "sizeof(S81C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C4)");
    check_base_class_offset(lv, (S81C7*)(S81C6*)(S81C5*), 0, "S81C4");
    check_base_class_offset(lv, (S81C6*)(S81C5*), 0, "S81C4");
    check_base_class_offset(lv, (S81C5*), 0, "S81C4");
    check_field_offset(lv, s81c4f0, ABISELECT(464,352), "S81C4.s81c4f0");
    check_field_offset(lv, s81c4f1, ABISELECT(472,360), "S81C4.s81c4f1");
    check_field_offset(lv, s81c4f2, ABISELECT(544,396), "S81C4.s81c4f2");
    check_field_offset(lv, s81c4f3, ABISELECT(560,408), "S81C4.s81c4f3");
    check_field_offset(lv, s81c4f4, ABISELECT(576,420), "S81C4.s81c4f4");
    check_field_offset(lv, s81c4f5, ABISELECT(608,440), "S81C4.s81c4f5");
    set_bf_and_test(lv, s81c4f6, ABISELECT(612,444), 0, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f7, ABISELECT(612,444), 1, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f8, ABISELECT(612,444), 2, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f9, ABISELECT(612,444), 3, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f10, ABISELECT(612,444), 4, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f11, ABISELECT(612,444), 5, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f12, ABISELECT(612,444), 6, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f13, ABISELECT(612,444), 7, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f14, ABISELECT(613,445), 0, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f15, ABISELECT(613,445), 1, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f16, ABISELECT(613,445), 2, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f17, ABISELECT(613,445), 3, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f18, ABISELECT(613,445), 4, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f19, ABISELECT(613,445), 5, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f20, ABISELECT(613,445), 6, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f21, ABISELECT(613,445), 7, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f22, ABISELECT(614,446), 0, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f23, ABISELECT(614,446), 1, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f24, ABISELECT(614,446), 2, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f25, ABISELECT(614,446), 3, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f26, ABISELECT(614,446), 4, 1, 1, "S81C4");
    set_bf_and_test(lv, s81c4f27, ABISELECT(614,446), 5, 1, 1, "S81C4");
    check_field_offset(lv, s81c4f28, ABISELECT(616,448), "S81C4.s81c4f28");
    check_field_offset(lv, s81c4f29, ABISELECT(624,452), "S81C4.s81c4f29");
    check_field_offset(lv, s81c4f30, ABISELECT(628,456), "S81C4.s81c4f30");
    check_field_offset(lv, s81c4f31, ABISELECT(636,464), "S81C4.s81c4f31");
    check_field_offset(lv, s81c4f32, ABISELECT(644,472), "S81C4.s81c4f32");
    check_field_offset(lv, s81c4f33, ABISELECT(656,480), "S81C4.s81c4f33");
    check_field_offset(lv, s81c4f34, ABISELECT(664,484), "S81C4.s81c4f34");
    check_field_offset(lv, s81c4f35, ABISELECT(680,496), "S81C4.s81c4f35");
    check_field_offset(lv, s81c4f36, ABISELECT(696,508), "S81C4.s81c4f36");
    check_field_offset(lv, s81c4f37, ABISELECT(712,520), "S81C4.s81c4f37");
    check_field_offset(lv, s81c4f38, ABISELECT(728,532), "S81C4.s81c4f38");
    test_class_info(&lv, &cd_S81C4);
    dp->~S81C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C4(Test_S81C4, "S81C4", ABISELECT(744,544));

#else // __cplusplus

extern void _ZN5S81C4C1Ev();
extern void _ZN5S81C4D1Ev();
Name_Map name_map_S81C4[] = {
  NSPAIR(_ZN5S81C4C1Ev),
  NSPAIR(_ZN5S81C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
extern Class_Descriptor cd_S81C6;
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
extern Class_Descriptor cd_S81C5;
extern VTBL_ENTRY _ZTI5S81C5[];
extern  VTBL_ENTRY _ZTV5S81C5[];
static Base_Class bases_S81C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S81C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S81C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C4[];
extern void _ZN5S81C4D1Ev();
extern void _ZN5S81C4D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
extern void _ZN5S81C53v70Ev();
extern void _ZN5S81C53v71Ev();
extern void _ZN5S81C53v72Ev();
extern void _ZN5S81C53v73Ev();
extern void _ZN5S81C53v74Ev();
extern void _ZN5S81C53v75Ev();
extern void _ZN5S81C53v76Ev();
extern void _ZN5S81C53v77Ev();
extern void _ZN5S81C53v78Ev();
extern void _ZN5S81C53v79Ev();
extern void _ZN5S81C53v80Ev();
extern void _ZN5S81C53v81Ev();
extern void _ZN5S81C53v82Ev();
extern void _ZN5S81C53v83Ev();
extern void _ZN5S81C53v84Ev();
extern void _ZN5S81C53v85Ev();
extern void _ZN5S81C53v86Ev();
extern void _ZN5S81C53v87Ev();
extern void _ZN5S81C53v88Ev();
extern void _ZN5S81C53v89Ev();
extern void _ZN5S81C53v90Ev();
extern void _ZN5S81C53v91Ev();
extern void _ZN5S81C53v92Ev();
extern void _ZN5S81C53v93Ev();
extern void _ZN5S81C53v94Ev();
extern void _ZN5S81C53v95Ev();
extern void _ZN5S81C53v96Ev();
extern void _ZN5S81C53v97Ev();
extern void _ZN5S81C53v98Ev();
extern void _ZN5S81C53v99Ev();
extern void _ZN5S81C54v100Ev();
extern void _ZN5S81C54v101Ev();
extern void _ZN5S81C54v102Ev();
extern void _ZN5S81C54v103Ev();
extern void _ZN5S81C54v104Ev();
extern void _ZN5S81C54v105Ev();
extern void _ZN5S81C54v106Ev();
extern void _ZN5S81C54v107Ev();
extern void _ZN5S81C54v108Ev();
extern void _ZN5S81C54v109Ev();
extern void _ZN5S81C54v110Ev();
extern void _ZN5S81C54v111Ev();
extern void _ZN5S81C54v112Ev();
extern void _ZN5S81C54v113Ev();
extern void _ZN5S81C54v114Ev();
extern void _ZN5S81C54v115Ev();
extern void _ZN5S81C54v116Ev();
extern void _ZN5S81C54v117Ev();
extern void _ZN5S81C54v118Ev();
extern void _ZN5S81C54v119Ev();
extern void _ZN5S81C54v120Ev();
extern void _ZN5S81C54v121Ev();
extern void _ZN5S81C54v122Ev();
extern void _ZN5S81C54v123Ev();
extern void _ZN5S81C54v124Ev();
extern void _ZN5S81C54v125Ev();
extern void _ZN5S81C54v126Ev();
extern void _ZN5S81C54v127Ev();
extern void _ZN5S81C54v128Ev();
extern void _ZN5S81C54v129Ev();
extern void _ZN5S81C54v130Ev();
extern void _ZN5S81C54v131Ev();
extern void _ZN5S81C54v132Ev();
extern void _ZN5S81C54v133Ev();
extern void _ZN5S81C54v134Ev();
extern void _ZN5S81C54v135Ev();
extern void _ZN5S81C54v136Ev();
extern void _ZN5S81C54v137Ev();
extern void _ZN5S81C54v138Ev();
extern void _ZN5S81C54v139Ev();
extern void _ZN5S81C54v140Ev();
extern void _ZN5S81C54v141Ev();
extern void _ZN5S81C54v142Ev();
extern void _ZN5S81C54v143Ev();
extern void _ZN5S81C54v144Ev();
extern void _ZN5S81C54v145Ev();
extern void _ZN5S81C44v146Ev();
extern void _ZN5S81C44v147Ev();
extern void _ZN5S81C44v148Ev();
extern void _ZN5S81C44v149Ev();
extern void _ZN5S81C44v150Ev();
extern void _ZN5S81C44v151Ev();
extern void _ZN5S81C44v152Ev();
extern void _ZN5S81C44v153Ev();
extern void _ZN5S81C44v154Ev();
extern void _ZN5S81C44v155Ev();
extern void _ZN5S81C44v156Ev();
extern void _ZN5S81C44v157Ev();
extern void _ZN5S81C44v158Ev();
extern void _ZN5S81C44v159Ev();
extern void _ZN5S81C44v160Ev();
extern void _ZN5S81C44v161Ev();
extern void _ZN5S81C44v162Ev();
extern void _ZN5S81C44v163Ev();
extern void _ZN5S81C44v164Ev();
extern void _ZN5S81C44v165Ev();
extern void _ZN5S81C44v166Ev();
extern void _ZN5S81C44v167Ev();
extern void _ZN5S81C44v168Ev();
extern void _ZN5S81C44v169Ev();
extern void _ZN5S81C44v170Ev();
extern void _ZN5S81C44v171Ev();
extern void _ZN5S81C44v172Ev();
extern void _ZN5S81C44v173Ev();
extern void _ZN5S81C44v174Ev();
extern void _ZN5S81C44v175Ev();
extern void _ZN5S81C44v176Ev();
extern void _ZN5S81C44v177Ev();
extern void _ZN5S81C44v178Ev();
extern void _ZN5S81C44v179Ev();
extern void _ZN5S81C44v180Ev();
extern void _ZN5S81C44v181Ev();
extern void _ZN5S81C44v182Ev();
extern void _ZN5S81C44v183Ev();
extern void _ZN5S81C44v184Ev();
static  VTBL_ENTRY vtc_S81C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C4[0]),
  (VTBL_ENTRY)&_ZN5S81C4D1Ev,
  (VTBL_ENTRY)&_ZN5S81C4D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
  (VTBL_ENTRY)&_ZN5S81C53v70Ev,
  (VTBL_ENTRY)&_ZN5S81C53v71Ev,
  (VTBL_ENTRY)&_ZN5S81C53v72Ev,
  (VTBL_ENTRY)&_ZN5S81C53v73Ev,
  (VTBL_ENTRY)&_ZN5S81C53v74Ev,
  (VTBL_ENTRY)&_ZN5S81C53v75Ev,
  (VTBL_ENTRY)&_ZN5S81C53v76Ev,
  (VTBL_ENTRY)&_ZN5S81C53v77Ev,
  (VTBL_ENTRY)&_ZN5S81C53v78Ev,
  (VTBL_ENTRY)&_ZN5S81C53v79Ev,
  (VTBL_ENTRY)&_ZN5S81C53v80Ev,
  (VTBL_ENTRY)&_ZN5S81C53v81Ev,
  (VTBL_ENTRY)&_ZN5S81C53v82Ev,
  (VTBL_ENTRY)&_ZN5S81C53v83Ev,
  (VTBL_ENTRY)&_ZN5S81C53v84Ev,
  (VTBL_ENTRY)&_ZN5S81C53v85Ev,
  (VTBL_ENTRY)&_ZN5S81C53v86Ev,
  (VTBL_ENTRY)&_ZN5S81C53v87Ev,
  (VTBL_ENTRY)&_ZN5S81C53v88Ev,
  (VTBL_ENTRY)&_ZN5S81C53v89Ev,
  (VTBL_ENTRY)&_ZN5S81C53v90Ev,
  (VTBL_ENTRY)&_ZN5S81C53v91Ev,
  (VTBL_ENTRY)&_ZN5S81C53v92Ev,
  (VTBL_ENTRY)&_ZN5S81C53v93Ev,
  (VTBL_ENTRY)&_ZN5S81C53v94Ev,
  (VTBL_ENTRY)&_ZN5S81C53v95Ev,
  (VTBL_ENTRY)&_ZN5S81C53v96Ev,
  (VTBL_ENTRY)&_ZN5S81C53v97Ev,
  (VTBL_ENTRY)&_ZN5S81C53v98Ev,
  (VTBL_ENTRY)&_ZN5S81C53v99Ev,
  (VTBL_ENTRY)&_ZN5S81C54v100Ev,
  (VTBL_ENTRY)&_ZN5S81C54v101Ev,
  (VTBL_ENTRY)&_ZN5S81C54v102Ev,
  (VTBL_ENTRY)&_ZN5S81C54v103Ev,
  (VTBL_ENTRY)&_ZN5S81C54v104Ev,
  (VTBL_ENTRY)&_ZN5S81C54v105Ev,
  (VTBL_ENTRY)&_ZN5S81C54v106Ev,
  (VTBL_ENTRY)&_ZN5S81C54v107Ev,
  (VTBL_ENTRY)&_ZN5S81C54v108Ev,
  (VTBL_ENTRY)&_ZN5S81C54v109Ev,
  (VTBL_ENTRY)&_ZN5S81C54v110Ev,
  (VTBL_ENTRY)&_ZN5S81C54v111Ev,
  (VTBL_ENTRY)&_ZN5S81C54v112Ev,
  (VTBL_ENTRY)&_ZN5S81C54v113Ev,
  (VTBL_ENTRY)&_ZN5S81C54v114Ev,
  (VTBL_ENTRY)&_ZN5S81C54v115Ev,
  (VTBL_ENTRY)&_ZN5S81C54v116Ev,
  (VTBL_ENTRY)&_ZN5S81C54v117Ev,
  (VTBL_ENTRY)&_ZN5S81C54v118Ev,
  (VTBL_ENTRY)&_ZN5S81C54v119Ev,
  (VTBL_ENTRY)&_ZN5S81C54v120Ev,
  (VTBL_ENTRY)&_ZN5S81C54v121Ev,
  (VTBL_ENTRY)&_ZN5S81C54v122Ev,
  (VTBL_ENTRY)&_ZN5S81C54v123Ev,
  (VTBL_ENTRY)&_ZN5S81C54v124Ev,
  (VTBL_ENTRY)&_ZN5S81C54v125Ev,
  (VTBL_ENTRY)&_ZN5S81C54v126Ev,
  (VTBL_ENTRY)&_ZN5S81C54v127Ev,
  (VTBL_ENTRY)&_ZN5S81C54v128Ev,
  (VTBL_ENTRY)&_ZN5S81C54v129Ev,
  (VTBL_ENTRY)&_ZN5S81C54v130Ev,
  (VTBL_ENTRY)&_ZN5S81C54v131Ev,
  (VTBL_ENTRY)&_ZN5S81C54v132Ev,
  (VTBL_ENTRY)&_ZN5S81C54v133Ev,
  (VTBL_ENTRY)&_ZN5S81C54v134Ev,
  (VTBL_ENTRY)&_ZN5S81C54v135Ev,
  (VTBL_ENTRY)&_ZN5S81C54v136Ev,
  (VTBL_ENTRY)&_ZN5S81C54v137Ev,
  (VTBL_ENTRY)&_ZN5S81C54v138Ev,
  (VTBL_ENTRY)&_ZN5S81C54v139Ev,
  (VTBL_ENTRY)&_ZN5S81C54v140Ev,
  (VTBL_ENTRY)&_ZN5S81C54v141Ev,
  (VTBL_ENTRY)&_ZN5S81C54v142Ev,
  (VTBL_ENTRY)&_ZN5S81C54v143Ev,
  (VTBL_ENTRY)&_ZN5S81C54v144Ev,
  (VTBL_ENTRY)&_ZN5S81C54v145Ev,
  (VTBL_ENTRY)&_ZN5S81C44v146Ev,
  (VTBL_ENTRY)&_ZN5S81C44v147Ev,
  (VTBL_ENTRY)&_ZN5S81C44v148Ev,
  (VTBL_ENTRY)&_ZN5S81C44v149Ev,
  (VTBL_ENTRY)&_ZN5S81C44v150Ev,
  (VTBL_ENTRY)&_ZN5S81C44v151Ev,
  (VTBL_ENTRY)&_ZN5S81C44v152Ev,
  (VTBL_ENTRY)&_ZN5S81C44v153Ev,
  (VTBL_ENTRY)&_ZN5S81C44v154Ev,
  (VTBL_ENTRY)&_ZN5S81C44v155Ev,
  (VTBL_ENTRY)&_ZN5S81C44v156Ev,
  (VTBL_ENTRY)&_ZN5S81C44v157Ev,
  (VTBL_ENTRY)&_ZN5S81C44v158Ev,
  (VTBL_ENTRY)&_ZN5S81C44v159Ev,
  (VTBL_ENTRY)&_ZN5S81C44v160Ev,
  (VTBL_ENTRY)&_ZN5S81C44v161Ev,
  (VTBL_ENTRY)&_ZN5S81C44v162Ev,
  (VTBL_ENTRY)&_ZN5S81C44v163Ev,
  (VTBL_ENTRY)&_ZN5S81C44v164Ev,
  (VTBL_ENTRY)&_ZN5S81C44v165Ev,
  (VTBL_ENTRY)&_ZN5S81C44v166Ev,
  (VTBL_ENTRY)&_ZN5S81C44v167Ev,
  (VTBL_ENTRY)&_ZN5S81C44v168Ev,
  (VTBL_ENTRY)&_ZN5S81C44v169Ev,
  (VTBL_ENTRY)&_ZN5S81C44v170Ev,
  (VTBL_ENTRY)&_ZN5S81C44v171Ev,
  (VTBL_ENTRY)&_ZN5S81C44v172Ev,
  (VTBL_ENTRY)&_ZN5S81C44v173Ev,
  (VTBL_ENTRY)&_ZN5S81C44v174Ev,
  (VTBL_ENTRY)&_ZN5S81C44v175Ev,
  (VTBL_ENTRY)&_ZN5S81C44v176Ev,
  (VTBL_ENTRY)&_ZN5S81C44v177Ev,
  (VTBL_ENTRY)&_ZN5S81C44v178Ev,
  (VTBL_ENTRY)&_ZN5S81C44v179Ev,
  (VTBL_ENTRY)&_ZN5S81C44v180Ev,
  (VTBL_ENTRY)&_ZN5S81C44v181Ev,
  (VTBL_ENTRY)&_ZN5S81C44v182Ev,
  (VTBL_ENTRY)&_ZN5S81C44v183Ev,
  (VTBL_ENTRY)&_ZN5S81C44v184Ev,
};
extern VTBL_ENTRY _ZTI5S81C4[];
extern  VTBL_ENTRY _ZTV5S81C4[];
Class_Descriptor cd_S81C4 = {  "S81C4", // class name
  bases_S81C4, 3,
  &(vtc_S81C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,544), // object size
  NSPAIRA(_ZTI5S81C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C4),185, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C3  : S81C4 {
  unsigned int s81c3f0:1;
  unsigned int s81c3f1:1;
  unsigned int s81c3f2:1;
  unsigned int s81c3f3:1;
  unsigned int s81c3f4:1;
  unsigned int s81c3f5:1;
  void *s81c3f6[8];
  ::S80C21_nt s81c3f7;
  ::S80C21_nt s81c3f8;
  ::S80C21_nt s81c3f9;
  virtual  ~S81C3(); // _ZN5S81C3D1Ev
  virtual void  v185(); // _ZN5S81C34v185Ev
  virtual void  v186(); // _ZN5S81C34v186Ev
  virtual void  v187(); // _ZN5S81C34v187Ev
  virtual void  v188(); // _ZN5S81C34v188Ev
  virtual void  v189(); // _ZN5S81C34v189Ev
  virtual void  v190(); // _ZN5S81C34v190Ev
  virtual void  v191(); // _ZN5S81C34v191Ev
  virtual void  v192(); // _ZN5S81C34v192Ev
  virtual void  v193(); // _ZN5S81C34v193Ev
  virtual void  v194(); // _ZN5S81C34v194Ev
  virtual void  v195(); // _ZN5S81C34v195Ev
  virtual void  v196(); // _ZN5S81C34v196Ev
  virtual void  v197(); // _ZN5S81C34v197Ev
  virtual void  v198(); // _ZN5S81C34v198Ev
  virtual void  v199(); // _ZN5S81C34v199Ev
  virtual void  v200(); // _ZN5S81C34v200Ev
  virtual void  v201(); // _ZN5S81C34v201Ev
  virtual void  v202(); // _ZN5S81C34v202Ev
  virtual void  v203(); // _ZN5S81C34v203Ev
  virtual void  v204(); // _ZN5S81C34v204Ev
  virtual void  v205(); // _ZN5S81C34v205Ev
  virtual void  v206(); // _ZN5S81C34v206Ev
  virtual void  v207(); // _ZN5S81C34v207Ev
  S81C3(); // tgen
};
//SIG(-1 S81C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ BC12{ BC10}} Fp FC13{ BC14{ BC10}} FC13 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC19{ m Fp FC20{ m Fi[2]}} FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19 FC19} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 FC6 Fp[9] FC21{ BC22{ BC10}} FC8 FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC20 FC6 FC6 Fp FC19 FC19 FC19 FC19 FC19} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC19 FC19 FC19}


 S81C3 ::~S81C3(){ note_dtor("S81C3", this);}
void  S81C3 ::v185(){vfunc_called(this, "_ZN5S81C34v185Ev");}
void  S81C3 ::v186(){vfunc_called(this, "_ZN5S81C34v186Ev");}
void  S81C3 ::v187(){vfunc_called(this, "_ZN5S81C34v187Ev");}
void  S81C3 ::v188(){vfunc_called(this, "_ZN5S81C34v188Ev");}
void  S81C3 ::v189(){vfunc_called(this, "_ZN5S81C34v189Ev");}
void  S81C3 ::v190(){vfunc_called(this, "_ZN5S81C34v190Ev");}
void  S81C3 ::v191(){vfunc_called(this, "_ZN5S81C34v191Ev");}
void  S81C3 ::v192(){vfunc_called(this, "_ZN5S81C34v192Ev");}
void  S81C3 ::v193(){vfunc_called(this, "_ZN5S81C34v193Ev");}
void  S81C3 ::v194(){vfunc_called(this, "_ZN5S81C34v194Ev");}
void  S81C3 ::v195(){vfunc_called(this, "_ZN5S81C34v195Ev");}
void  S81C3 ::v196(){vfunc_called(this, "_ZN5S81C34v196Ev");}
void  S81C3 ::v197(){vfunc_called(this, "_ZN5S81C34v197Ev");}
void  S81C3 ::v198(){vfunc_called(this, "_ZN5S81C34v198Ev");}
void  S81C3 ::v199(){vfunc_called(this, "_ZN5S81C34v199Ev");}
void  S81C3 ::v200(){vfunc_called(this, "_ZN5S81C34v200Ev");}
void  S81C3 ::v201(){vfunc_called(this, "_ZN5S81C34v201Ev");}
void  S81C3 ::v202(){vfunc_called(this, "_ZN5S81C34v202Ev");}
void  S81C3 ::v203(){vfunc_called(this, "_ZN5S81C34v203Ev");}
void  S81C3 ::v204(){vfunc_called(this, "_ZN5S81C34v204Ev");}
void  S81C3 ::v205(){vfunc_called(this, "_ZN5S81C34v205Ev");}
void  S81C3 ::v206(){vfunc_called(this, "_ZN5S81C34v206Ev");}
void  S81C3 ::v207(){vfunc_called(this, "_ZN5S81C34v207Ev");}
S81C3 ::S81C3(){ note_ctor("S81C3", this);} // tgen

static void Test_S81C3()
{
  extern Class_Descriptor cd_S81C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,155)];
    init_test(&cd_S81C3, buf);
    S81C3 *dp, &lv = *(dp=new (buf) S81C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,616), "sizeof(S81C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C3)");
    check_base_class_offset(lv, (S81C7*)(S81C6*)(S81C5*)(S81C4*), 0, "S81C3");
    check_base_class_offset(lv, (S81C6*)(S81C5*)(S81C4*), 0, "S81C3");
    check_base_class_offset(lv, (S81C5*)(S81C4*), 0, "S81C3");
    check_base_class_offset(lv, (S81C4*), 0, "S81C3");
    set_bf_and_test(lv, s81c3f0, ABISELECT(744,544), 0, 1, 1, "S81C3");
    set_bf_and_test(lv, s81c3f1, ABISELECT(744,544), 1, 1, 1, "S81C3");
    set_bf_and_test(lv, s81c3f2, ABISELECT(744,544), 2, 1, 1, "S81C3");
    set_bf_and_test(lv, s81c3f3, ABISELECT(744,544), 3, 1, 1, "S81C3");
    set_bf_and_test(lv, s81c3f4, ABISELECT(744,544), 4, 1, 1, "S81C3");
    set_bf_and_test(lv, s81c3f5, ABISELECT(744,544), 5, 1, 1, "S81C3");
    check_field_offset(lv, s81c3f6, ABISELECT(752,548), "S81C3.s81c3f6");
    check_field_offset(lv, s81c3f7, ABISELECT(816,580), "S81C3.s81c3f7");
    check_field_offset(lv, s81c3f8, ABISELECT(832,592), "S81C3.s81c3f8");
    check_field_offset(lv, s81c3f9, ABISELECT(848,604), "S81C3.s81c3f9");
    test_class_info(&lv, &cd_S81C3);
    dp->~S81C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C3(Test_S81C3, "S81C3", ABISELECT(864,616));

#else // __cplusplus

extern void _ZN5S81C3C1Ev();
extern void _ZN5S81C3D1Ev();
Name_Map name_map_S81C3[] = {
  NSPAIR(_ZN5S81C3C1Ev),
  NSPAIR(_ZN5S81C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
extern Class_Descriptor cd_S81C6;
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
extern Class_Descriptor cd_S81C5;
extern VTBL_ENTRY _ZTI5S81C5[];
extern  VTBL_ENTRY _ZTV5S81C5[];
extern Class_Descriptor cd_S81C4;
extern VTBL_ENTRY _ZTI5S81C4[];
extern  VTBL_ENTRY _ZTV5S81C4[];
static Base_Class bases_S81C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S81C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S81C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S81C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C3[];
extern void _ZN5S81C3D1Ev();
extern void _ZN5S81C3D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
extern void _ZN5S81C53v70Ev();
extern void _ZN5S81C53v71Ev();
extern void _ZN5S81C53v72Ev();
extern void _ZN5S81C53v73Ev();
extern void _ZN5S81C53v74Ev();
extern void _ZN5S81C53v75Ev();
extern void _ZN5S81C53v76Ev();
extern void _ZN5S81C53v77Ev();
extern void _ZN5S81C53v78Ev();
extern void _ZN5S81C53v79Ev();
extern void _ZN5S81C53v80Ev();
extern void _ZN5S81C53v81Ev();
extern void _ZN5S81C53v82Ev();
extern void _ZN5S81C53v83Ev();
extern void _ZN5S81C53v84Ev();
extern void _ZN5S81C53v85Ev();
extern void _ZN5S81C53v86Ev();
extern void _ZN5S81C53v87Ev();
extern void _ZN5S81C53v88Ev();
extern void _ZN5S81C53v89Ev();
extern void _ZN5S81C53v90Ev();
extern void _ZN5S81C53v91Ev();
extern void _ZN5S81C53v92Ev();
extern void _ZN5S81C53v93Ev();
extern void _ZN5S81C53v94Ev();
extern void _ZN5S81C53v95Ev();
extern void _ZN5S81C53v96Ev();
extern void _ZN5S81C53v97Ev();
extern void _ZN5S81C53v98Ev();
extern void _ZN5S81C53v99Ev();
extern void _ZN5S81C54v100Ev();
extern void _ZN5S81C54v101Ev();
extern void _ZN5S81C54v102Ev();
extern void _ZN5S81C54v103Ev();
extern void _ZN5S81C54v104Ev();
extern void _ZN5S81C54v105Ev();
extern void _ZN5S81C54v106Ev();
extern void _ZN5S81C54v107Ev();
extern void _ZN5S81C54v108Ev();
extern void _ZN5S81C54v109Ev();
extern void _ZN5S81C54v110Ev();
extern void _ZN5S81C54v111Ev();
extern void _ZN5S81C54v112Ev();
extern void _ZN5S81C54v113Ev();
extern void _ZN5S81C54v114Ev();
extern void _ZN5S81C54v115Ev();
extern void _ZN5S81C54v116Ev();
extern void _ZN5S81C54v117Ev();
extern void _ZN5S81C54v118Ev();
extern void _ZN5S81C54v119Ev();
extern void _ZN5S81C54v120Ev();
extern void _ZN5S81C54v121Ev();
extern void _ZN5S81C54v122Ev();
extern void _ZN5S81C54v123Ev();
extern void _ZN5S81C54v124Ev();
extern void _ZN5S81C54v125Ev();
extern void _ZN5S81C54v126Ev();
extern void _ZN5S81C54v127Ev();
extern void _ZN5S81C54v128Ev();
extern void _ZN5S81C54v129Ev();
extern void _ZN5S81C54v130Ev();
extern void _ZN5S81C54v131Ev();
extern void _ZN5S81C54v132Ev();
extern void _ZN5S81C54v133Ev();
extern void _ZN5S81C54v134Ev();
extern void _ZN5S81C54v135Ev();
extern void _ZN5S81C54v136Ev();
extern void _ZN5S81C54v137Ev();
extern void _ZN5S81C54v138Ev();
extern void _ZN5S81C54v139Ev();
extern void _ZN5S81C54v140Ev();
extern void _ZN5S81C54v141Ev();
extern void _ZN5S81C54v142Ev();
extern void _ZN5S81C54v143Ev();
extern void _ZN5S81C54v144Ev();
extern void _ZN5S81C54v145Ev();
extern void _ZN5S81C44v146Ev();
extern void _ZN5S81C44v147Ev();
extern void _ZN5S81C44v148Ev();
extern void _ZN5S81C44v149Ev();
extern void _ZN5S81C44v150Ev();
extern void _ZN5S81C44v151Ev();
extern void _ZN5S81C44v152Ev();
extern void _ZN5S81C44v153Ev();
extern void _ZN5S81C44v154Ev();
extern void _ZN5S81C44v155Ev();
extern void _ZN5S81C44v156Ev();
extern void _ZN5S81C44v157Ev();
extern void _ZN5S81C44v158Ev();
extern void _ZN5S81C44v159Ev();
extern void _ZN5S81C44v160Ev();
extern void _ZN5S81C44v161Ev();
extern void _ZN5S81C44v162Ev();
extern void _ZN5S81C44v163Ev();
extern void _ZN5S81C44v164Ev();
extern void _ZN5S81C44v165Ev();
extern void _ZN5S81C44v166Ev();
extern void _ZN5S81C44v167Ev();
extern void _ZN5S81C44v168Ev();
extern void _ZN5S81C44v169Ev();
extern void _ZN5S81C44v170Ev();
extern void _ZN5S81C44v171Ev();
extern void _ZN5S81C44v172Ev();
extern void _ZN5S81C44v173Ev();
extern void _ZN5S81C44v174Ev();
extern void _ZN5S81C44v175Ev();
extern void _ZN5S81C44v176Ev();
extern void _ZN5S81C44v177Ev();
extern void _ZN5S81C44v178Ev();
extern void _ZN5S81C44v179Ev();
extern void _ZN5S81C44v180Ev();
extern void _ZN5S81C44v181Ev();
extern void _ZN5S81C44v182Ev();
extern void _ZN5S81C44v183Ev();
extern void _ZN5S81C44v184Ev();
extern void _ZN5S81C34v185Ev();
extern void _ZN5S81C34v186Ev();
extern void _ZN5S81C34v187Ev();
extern void _ZN5S81C34v188Ev();
extern void _ZN5S81C34v189Ev();
extern void _ZN5S81C34v190Ev();
extern void _ZN5S81C34v191Ev();
extern void _ZN5S81C34v192Ev();
extern void _ZN5S81C34v193Ev();
extern void _ZN5S81C34v194Ev();
extern void _ZN5S81C34v195Ev();
extern void _ZN5S81C34v196Ev();
extern void _ZN5S81C34v197Ev();
extern void _ZN5S81C34v198Ev();
extern void _ZN5S81C34v199Ev();
extern void _ZN5S81C34v200Ev();
extern void _ZN5S81C34v201Ev();
extern void _ZN5S81C34v202Ev();
extern void _ZN5S81C34v203Ev();
extern void _ZN5S81C34v204Ev();
extern void _ZN5S81C34v205Ev();
extern void _ZN5S81C34v206Ev();
extern void _ZN5S81C34v207Ev();
static  VTBL_ENTRY vtc_S81C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C3[0]),
  (VTBL_ENTRY)&_ZN5S81C3D1Ev,
  (VTBL_ENTRY)&_ZN5S81C3D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
  (VTBL_ENTRY)&_ZN5S81C53v70Ev,
  (VTBL_ENTRY)&_ZN5S81C53v71Ev,
  (VTBL_ENTRY)&_ZN5S81C53v72Ev,
  (VTBL_ENTRY)&_ZN5S81C53v73Ev,
  (VTBL_ENTRY)&_ZN5S81C53v74Ev,
  (VTBL_ENTRY)&_ZN5S81C53v75Ev,
  (VTBL_ENTRY)&_ZN5S81C53v76Ev,
  (VTBL_ENTRY)&_ZN5S81C53v77Ev,
  (VTBL_ENTRY)&_ZN5S81C53v78Ev,
  (VTBL_ENTRY)&_ZN5S81C53v79Ev,
  (VTBL_ENTRY)&_ZN5S81C53v80Ev,
  (VTBL_ENTRY)&_ZN5S81C53v81Ev,
  (VTBL_ENTRY)&_ZN5S81C53v82Ev,
  (VTBL_ENTRY)&_ZN5S81C53v83Ev,
  (VTBL_ENTRY)&_ZN5S81C53v84Ev,
  (VTBL_ENTRY)&_ZN5S81C53v85Ev,
  (VTBL_ENTRY)&_ZN5S81C53v86Ev,
  (VTBL_ENTRY)&_ZN5S81C53v87Ev,
  (VTBL_ENTRY)&_ZN5S81C53v88Ev,
  (VTBL_ENTRY)&_ZN5S81C53v89Ev,
  (VTBL_ENTRY)&_ZN5S81C53v90Ev,
  (VTBL_ENTRY)&_ZN5S81C53v91Ev,
  (VTBL_ENTRY)&_ZN5S81C53v92Ev,
  (VTBL_ENTRY)&_ZN5S81C53v93Ev,
  (VTBL_ENTRY)&_ZN5S81C53v94Ev,
  (VTBL_ENTRY)&_ZN5S81C53v95Ev,
  (VTBL_ENTRY)&_ZN5S81C53v96Ev,
  (VTBL_ENTRY)&_ZN5S81C53v97Ev,
  (VTBL_ENTRY)&_ZN5S81C53v98Ev,
  (VTBL_ENTRY)&_ZN5S81C53v99Ev,
  (VTBL_ENTRY)&_ZN5S81C54v100Ev,
  (VTBL_ENTRY)&_ZN5S81C54v101Ev,
  (VTBL_ENTRY)&_ZN5S81C54v102Ev,
  (VTBL_ENTRY)&_ZN5S81C54v103Ev,
  (VTBL_ENTRY)&_ZN5S81C54v104Ev,
  (VTBL_ENTRY)&_ZN5S81C54v105Ev,
  (VTBL_ENTRY)&_ZN5S81C54v106Ev,
  (VTBL_ENTRY)&_ZN5S81C54v107Ev,
  (VTBL_ENTRY)&_ZN5S81C54v108Ev,
  (VTBL_ENTRY)&_ZN5S81C54v109Ev,
  (VTBL_ENTRY)&_ZN5S81C54v110Ev,
  (VTBL_ENTRY)&_ZN5S81C54v111Ev,
  (VTBL_ENTRY)&_ZN5S81C54v112Ev,
  (VTBL_ENTRY)&_ZN5S81C54v113Ev,
  (VTBL_ENTRY)&_ZN5S81C54v114Ev,
  (VTBL_ENTRY)&_ZN5S81C54v115Ev,
  (VTBL_ENTRY)&_ZN5S81C54v116Ev,
  (VTBL_ENTRY)&_ZN5S81C54v117Ev,
  (VTBL_ENTRY)&_ZN5S81C54v118Ev,
  (VTBL_ENTRY)&_ZN5S81C54v119Ev,
  (VTBL_ENTRY)&_ZN5S81C54v120Ev,
  (VTBL_ENTRY)&_ZN5S81C54v121Ev,
  (VTBL_ENTRY)&_ZN5S81C54v122Ev,
  (VTBL_ENTRY)&_ZN5S81C54v123Ev,
  (VTBL_ENTRY)&_ZN5S81C54v124Ev,
  (VTBL_ENTRY)&_ZN5S81C54v125Ev,
  (VTBL_ENTRY)&_ZN5S81C54v126Ev,
  (VTBL_ENTRY)&_ZN5S81C54v127Ev,
  (VTBL_ENTRY)&_ZN5S81C54v128Ev,
  (VTBL_ENTRY)&_ZN5S81C54v129Ev,
  (VTBL_ENTRY)&_ZN5S81C54v130Ev,
  (VTBL_ENTRY)&_ZN5S81C54v131Ev,
  (VTBL_ENTRY)&_ZN5S81C54v132Ev,
  (VTBL_ENTRY)&_ZN5S81C54v133Ev,
  (VTBL_ENTRY)&_ZN5S81C54v134Ev,
  (VTBL_ENTRY)&_ZN5S81C54v135Ev,
  (VTBL_ENTRY)&_ZN5S81C54v136Ev,
  (VTBL_ENTRY)&_ZN5S81C54v137Ev,
  (VTBL_ENTRY)&_ZN5S81C54v138Ev,
  (VTBL_ENTRY)&_ZN5S81C54v139Ev,
  (VTBL_ENTRY)&_ZN5S81C54v140Ev,
  (VTBL_ENTRY)&_ZN5S81C54v141Ev,
  (VTBL_ENTRY)&_ZN5S81C54v142Ev,
  (VTBL_ENTRY)&_ZN5S81C54v143Ev,
  (VTBL_ENTRY)&_ZN5S81C54v144Ev,
  (VTBL_ENTRY)&_ZN5S81C54v145Ev,
  (VTBL_ENTRY)&_ZN5S81C44v146Ev,
  (VTBL_ENTRY)&_ZN5S81C44v147Ev,
  (VTBL_ENTRY)&_ZN5S81C44v148Ev,
  (VTBL_ENTRY)&_ZN5S81C44v149Ev,
  (VTBL_ENTRY)&_ZN5S81C44v150Ev,
  (VTBL_ENTRY)&_ZN5S81C44v151Ev,
  (VTBL_ENTRY)&_ZN5S81C44v152Ev,
  (VTBL_ENTRY)&_ZN5S81C44v153Ev,
  (VTBL_ENTRY)&_ZN5S81C44v154Ev,
  (VTBL_ENTRY)&_ZN5S81C44v155Ev,
  (VTBL_ENTRY)&_ZN5S81C44v156Ev,
  (VTBL_ENTRY)&_ZN5S81C44v157Ev,
  (VTBL_ENTRY)&_ZN5S81C44v158Ev,
  (VTBL_ENTRY)&_ZN5S81C44v159Ev,
  (VTBL_ENTRY)&_ZN5S81C44v160Ev,
  (VTBL_ENTRY)&_ZN5S81C44v161Ev,
  (VTBL_ENTRY)&_ZN5S81C44v162Ev,
  (VTBL_ENTRY)&_ZN5S81C44v163Ev,
  (VTBL_ENTRY)&_ZN5S81C44v164Ev,
  (VTBL_ENTRY)&_ZN5S81C44v165Ev,
  (VTBL_ENTRY)&_ZN5S81C44v166Ev,
  (VTBL_ENTRY)&_ZN5S81C44v167Ev,
  (VTBL_ENTRY)&_ZN5S81C44v168Ev,
  (VTBL_ENTRY)&_ZN5S81C44v169Ev,
  (VTBL_ENTRY)&_ZN5S81C44v170Ev,
  (VTBL_ENTRY)&_ZN5S81C44v171Ev,
  (VTBL_ENTRY)&_ZN5S81C44v172Ev,
  (VTBL_ENTRY)&_ZN5S81C44v173Ev,
  (VTBL_ENTRY)&_ZN5S81C44v174Ev,
  (VTBL_ENTRY)&_ZN5S81C44v175Ev,
  (VTBL_ENTRY)&_ZN5S81C44v176Ev,
  (VTBL_ENTRY)&_ZN5S81C44v177Ev,
  (VTBL_ENTRY)&_ZN5S81C44v178Ev,
  (VTBL_ENTRY)&_ZN5S81C44v179Ev,
  (VTBL_ENTRY)&_ZN5S81C44v180Ev,
  (VTBL_ENTRY)&_ZN5S81C44v181Ev,
  (VTBL_ENTRY)&_ZN5S81C44v182Ev,
  (VTBL_ENTRY)&_ZN5S81C44v183Ev,
  (VTBL_ENTRY)&_ZN5S81C44v184Ev,
  (VTBL_ENTRY)&_ZN5S81C34v185Ev,
  (VTBL_ENTRY)&_ZN5S81C34v186Ev,
  (VTBL_ENTRY)&_ZN5S81C34v187Ev,
  (VTBL_ENTRY)&_ZN5S81C34v188Ev,
  (VTBL_ENTRY)&_ZN5S81C34v189Ev,
  (VTBL_ENTRY)&_ZN5S81C34v190Ev,
  (VTBL_ENTRY)&_ZN5S81C34v191Ev,
  (VTBL_ENTRY)&_ZN5S81C34v192Ev,
  (VTBL_ENTRY)&_ZN5S81C34v193Ev,
  (VTBL_ENTRY)&_ZN5S81C34v194Ev,
  (VTBL_ENTRY)&_ZN5S81C34v195Ev,
  (VTBL_ENTRY)&_ZN5S81C34v196Ev,
  (VTBL_ENTRY)&_ZN5S81C34v197Ev,
  (VTBL_ENTRY)&_ZN5S81C34v198Ev,
  (VTBL_ENTRY)&_ZN5S81C34v199Ev,
  (VTBL_ENTRY)&_ZN5S81C34v200Ev,
  (VTBL_ENTRY)&_ZN5S81C34v201Ev,
  (VTBL_ENTRY)&_ZN5S81C34v202Ev,
  (VTBL_ENTRY)&_ZN5S81C34v203Ev,
  (VTBL_ENTRY)&_ZN5S81C34v204Ev,
  (VTBL_ENTRY)&_ZN5S81C34v205Ev,
  (VTBL_ENTRY)&_ZN5S81C34v206Ev,
  (VTBL_ENTRY)&_ZN5S81C34v207Ev,
};
extern VTBL_ENTRY _ZTI5S81C3[];
extern  VTBL_ENTRY _ZTV5S81C3[];
Class_Descriptor cd_S81C3 = {  "S81C3", // class name
  bases_S81C3, 4,
  &(vtc_S81C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,616), // object size
  NSPAIRA(_ZTI5S81C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C3),208, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C2  : S81C3 {
  unsigned int s81c2f0:1;
  void *s81c2f1[5];
  ::S80C10_nt s81c2f2;
  ::S37C34_nt s81c2f3;
  unsigned int s81c2f4:1;
  unsigned int s81c2f5:1;
  int s81c2f6[8];
  ::S80C21_nt s81c2f7;
  ::S80C21_nt s81c2f8;
  ::S80C21_nt s81c2f9;
  virtual  ~S81C2(); // _ZN5S81C2D1Ev
  virtual void  v208(); // _ZN5S81C24v208Ev
  virtual void  v209(); // _ZN5S81C24v209Ev
  virtual void  v210(); // _ZN5S81C24v210Ev
  virtual void  v211(); // _ZN5S81C24v211Ev
  virtual void  v212(); // _ZN5S81C24v212Ev
  virtual void  v213(); // _ZN5S81C24v213Ev
  S81C2(); // tgen
};
//SIG(-1 S81C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v71 v72} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ BC13{ BC11}} Fp FC14{ BC15{ BC11}} FC14 FC16{ BC17{ BC11}} FC18{ BC19{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC20{ m Fp FC21{ m Fi[2]}} FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20} vd v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 FC7 Fp[9] FC22{ BC23{ BC11}} FC9 FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC21 FC7 FC7 Fp FC20 FC20 FC20 FC20 FC20} vd v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC20 FC20 FC20} vd v1 v2 v3 v4 v5 v6 Fi:1 Fp[5] FC27{ BC28{ BC11}} FC29{ BC30{ BC11}} Fi:1 Fi:1 Fi[8] FC20 FC20 FC20}


 S81C2 ::~S81C2(){ note_dtor("S81C2", this);}
void  S81C2 ::v208(){vfunc_called(this, "_ZN5S81C24v208Ev");}
void  S81C2 ::v209(){vfunc_called(this, "_ZN5S81C24v209Ev");}
void  S81C2 ::v210(){vfunc_called(this, "_ZN5S81C24v210Ev");}
void  S81C2 ::v211(){vfunc_called(this, "_ZN5S81C24v211Ev");}
void  S81C2 ::v212(){vfunc_called(this, "_ZN5S81C24v212Ev");}
void  S81C2 ::v213(){vfunc_called(this, "_ZN5S81C24v213Ev");}
S81C2 ::S81C2(){ note_ctor("S81C2", this);} // tgen

static void Test_S81C2()
{
  extern Class_Descriptor cd_S81C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(130,185)];
    init_test(&cd_S81C2, buf);
    S81C2 *dp, &lv = *(dp=new (buf) S81C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1032,736), "sizeof(S81C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C2)");
    check_base_class_offset(lv, (S81C7*)(S81C6*)(S81C5*)(S81C4*)(S81C3*), 0, "S81C2");
    check_base_class_offset(lv, (S81C6*)(S81C5*)(S81C4*)(S81C3*), 0, "S81C2");
    check_base_class_offset(lv, (S81C5*)(S81C4*)(S81C3*), 0, "S81C2");
    check_base_class_offset(lv, (S81C4*)(S81C3*), 0, "S81C2");
    check_base_class_offset(lv, (S81C3*), 0, "S81C2");
    set_bf_and_test(lv, s81c2f0, ABISELECT(864,616), 0, 1, 1, "S81C2");
    check_field_offset(lv, s81c2f1, ABISELECT(872,620), "S81C2.s81c2f1");
    check_field_offset(lv, s81c2f2, ABISELECT(912,640), "S81C2.s81c2f2");
    check_field_offset(lv, s81c2f3, ABISELECT(928,652), "S81C2.s81c2f3");
    set_bf_and_test(lv, s81c2f4, ABISELECT(944,664), 0, 1, 1, "S81C2");
    set_bf_and_test(lv, s81c2f5, ABISELECT(944,664), 1, 1, 1, "S81C2");
    check_field_offset(lv, s81c2f6, ABISELECT(948,668), "S81C2.s81c2f6");
    check_field_offset(lv, s81c2f7, ABISELECT(984,700), "S81C2.s81c2f7");
    check_field_offset(lv, s81c2f8, ABISELECT(1000,712), "S81C2.s81c2f8");
    check_field_offset(lv, s81c2f9, ABISELECT(1016,724), "S81C2.s81c2f9");
    test_class_info(&lv, &cd_S81C2);
    dp->~S81C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C2(Test_S81C2, "S81C2", ABISELECT(1032,736));

#else // __cplusplus

extern void _ZN5S81C2C1Ev();
extern void _ZN5S81C2D1Ev();
Name_Map name_map_S81C2[] = {
  NSPAIR(_ZN5S81C2C1Ev),
  NSPAIR(_ZN5S81C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
extern Class_Descriptor cd_S81C6;
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
extern Class_Descriptor cd_S81C5;
extern VTBL_ENTRY _ZTI5S81C5[];
extern  VTBL_ENTRY _ZTV5S81C5[];
extern Class_Descriptor cd_S81C4;
extern VTBL_ENTRY _ZTI5S81C4[];
extern  VTBL_ENTRY _ZTV5S81C4[];
extern Class_Descriptor cd_S81C3;
extern VTBL_ENTRY _ZTI5S81C3[];
extern  VTBL_ENTRY _ZTV5S81C3[];
static Base_Class bases_S81C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S81C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S81C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S81C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S81C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C2[];
extern void _ZN5S81C2D1Ev();
extern void _ZN5S81C2D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
extern void _ZN5S81C53v70Ev();
extern void _ZN5S81C53v71Ev();
extern void _ZN5S81C53v72Ev();
extern void _ZN5S81C53v73Ev();
extern void _ZN5S81C53v74Ev();
extern void _ZN5S81C53v75Ev();
extern void _ZN5S81C53v76Ev();
extern void _ZN5S81C53v77Ev();
extern void _ZN5S81C53v78Ev();
extern void _ZN5S81C53v79Ev();
extern void _ZN5S81C53v80Ev();
extern void _ZN5S81C53v81Ev();
extern void _ZN5S81C53v82Ev();
extern void _ZN5S81C53v83Ev();
extern void _ZN5S81C53v84Ev();
extern void _ZN5S81C53v85Ev();
extern void _ZN5S81C53v86Ev();
extern void _ZN5S81C53v87Ev();
extern void _ZN5S81C53v88Ev();
extern void _ZN5S81C53v89Ev();
extern void _ZN5S81C53v90Ev();
extern void _ZN5S81C53v91Ev();
extern void _ZN5S81C53v92Ev();
extern void _ZN5S81C53v93Ev();
extern void _ZN5S81C53v94Ev();
extern void _ZN5S81C53v95Ev();
extern void _ZN5S81C53v96Ev();
extern void _ZN5S81C53v97Ev();
extern void _ZN5S81C53v98Ev();
extern void _ZN5S81C53v99Ev();
extern void _ZN5S81C54v100Ev();
extern void _ZN5S81C54v101Ev();
extern void _ZN5S81C54v102Ev();
extern void _ZN5S81C54v103Ev();
extern void _ZN5S81C54v104Ev();
extern void _ZN5S81C54v105Ev();
extern void _ZN5S81C54v106Ev();
extern void _ZN5S81C54v107Ev();
extern void _ZN5S81C54v108Ev();
extern void _ZN5S81C54v109Ev();
extern void _ZN5S81C54v110Ev();
extern void _ZN5S81C54v111Ev();
extern void _ZN5S81C54v112Ev();
extern void _ZN5S81C54v113Ev();
extern void _ZN5S81C54v114Ev();
extern void _ZN5S81C54v115Ev();
extern void _ZN5S81C54v116Ev();
extern void _ZN5S81C54v117Ev();
extern void _ZN5S81C54v118Ev();
extern void _ZN5S81C54v119Ev();
extern void _ZN5S81C54v120Ev();
extern void _ZN5S81C54v121Ev();
extern void _ZN5S81C54v122Ev();
extern void _ZN5S81C54v123Ev();
extern void _ZN5S81C54v124Ev();
extern void _ZN5S81C54v125Ev();
extern void _ZN5S81C54v126Ev();
extern void _ZN5S81C54v127Ev();
extern void _ZN5S81C54v128Ev();
extern void _ZN5S81C54v129Ev();
extern void _ZN5S81C54v130Ev();
extern void _ZN5S81C54v131Ev();
extern void _ZN5S81C54v132Ev();
extern void _ZN5S81C54v133Ev();
extern void _ZN5S81C54v134Ev();
extern void _ZN5S81C54v135Ev();
extern void _ZN5S81C54v136Ev();
extern void _ZN5S81C54v137Ev();
extern void _ZN5S81C54v138Ev();
extern void _ZN5S81C54v139Ev();
extern void _ZN5S81C54v140Ev();
extern void _ZN5S81C54v141Ev();
extern void _ZN5S81C54v142Ev();
extern void _ZN5S81C54v143Ev();
extern void _ZN5S81C54v144Ev();
extern void _ZN5S81C54v145Ev();
extern void _ZN5S81C44v146Ev();
extern void _ZN5S81C44v147Ev();
extern void _ZN5S81C44v148Ev();
extern void _ZN5S81C44v149Ev();
extern void _ZN5S81C44v150Ev();
extern void _ZN5S81C44v151Ev();
extern void _ZN5S81C44v152Ev();
extern void _ZN5S81C44v153Ev();
extern void _ZN5S81C44v154Ev();
extern void _ZN5S81C44v155Ev();
extern void _ZN5S81C44v156Ev();
extern void _ZN5S81C44v157Ev();
extern void _ZN5S81C44v158Ev();
extern void _ZN5S81C44v159Ev();
extern void _ZN5S81C44v160Ev();
extern void _ZN5S81C44v161Ev();
extern void _ZN5S81C44v162Ev();
extern void _ZN5S81C44v163Ev();
extern void _ZN5S81C44v164Ev();
extern void _ZN5S81C44v165Ev();
extern void _ZN5S81C44v166Ev();
extern void _ZN5S81C44v167Ev();
extern void _ZN5S81C44v168Ev();
extern void _ZN5S81C44v169Ev();
extern void _ZN5S81C44v170Ev();
extern void _ZN5S81C44v171Ev();
extern void _ZN5S81C44v172Ev();
extern void _ZN5S81C44v173Ev();
extern void _ZN5S81C44v174Ev();
extern void _ZN5S81C44v175Ev();
extern void _ZN5S81C44v176Ev();
extern void _ZN5S81C44v177Ev();
extern void _ZN5S81C44v178Ev();
extern void _ZN5S81C44v179Ev();
extern void _ZN5S81C44v180Ev();
extern void _ZN5S81C44v181Ev();
extern void _ZN5S81C44v182Ev();
extern void _ZN5S81C44v183Ev();
extern void _ZN5S81C44v184Ev();
extern void _ZN5S81C34v185Ev();
extern void _ZN5S81C34v186Ev();
extern void _ZN5S81C34v187Ev();
extern void _ZN5S81C34v188Ev();
extern void _ZN5S81C34v189Ev();
extern void _ZN5S81C34v190Ev();
extern void _ZN5S81C34v191Ev();
extern void _ZN5S81C34v192Ev();
extern void _ZN5S81C34v193Ev();
extern void _ZN5S81C34v194Ev();
extern void _ZN5S81C34v195Ev();
extern void _ZN5S81C34v196Ev();
extern void _ZN5S81C34v197Ev();
extern void _ZN5S81C34v198Ev();
extern void _ZN5S81C34v199Ev();
extern void _ZN5S81C34v200Ev();
extern void _ZN5S81C34v201Ev();
extern void _ZN5S81C34v202Ev();
extern void _ZN5S81C34v203Ev();
extern void _ZN5S81C34v204Ev();
extern void _ZN5S81C34v205Ev();
extern void _ZN5S81C34v206Ev();
extern void _ZN5S81C34v207Ev();
extern void _ZN5S81C24v208Ev();
extern void _ZN5S81C24v209Ev();
extern void _ZN5S81C24v210Ev();
extern void _ZN5S81C24v211Ev();
extern void _ZN5S81C24v212Ev();
extern void _ZN5S81C24v213Ev();
static  VTBL_ENTRY vtc_S81C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C2[0]),
  (VTBL_ENTRY)&_ZN5S81C2D1Ev,
  (VTBL_ENTRY)&_ZN5S81C2D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
  (VTBL_ENTRY)&_ZN5S81C53v70Ev,
  (VTBL_ENTRY)&_ZN5S81C53v71Ev,
  (VTBL_ENTRY)&_ZN5S81C53v72Ev,
  (VTBL_ENTRY)&_ZN5S81C53v73Ev,
  (VTBL_ENTRY)&_ZN5S81C53v74Ev,
  (VTBL_ENTRY)&_ZN5S81C53v75Ev,
  (VTBL_ENTRY)&_ZN5S81C53v76Ev,
  (VTBL_ENTRY)&_ZN5S81C53v77Ev,
  (VTBL_ENTRY)&_ZN5S81C53v78Ev,
  (VTBL_ENTRY)&_ZN5S81C53v79Ev,
  (VTBL_ENTRY)&_ZN5S81C53v80Ev,
  (VTBL_ENTRY)&_ZN5S81C53v81Ev,
  (VTBL_ENTRY)&_ZN5S81C53v82Ev,
  (VTBL_ENTRY)&_ZN5S81C53v83Ev,
  (VTBL_ENTRY)&_ZN5S81C53v84Ev,
  (VTBL_ENTRY)&_ZN5S81C53v85Ev,
  (VTBL_ENTRY)&_ZN5S81C53v86Ev,
  (VTBL_ENTRY)&_ZN5S81C53v87Ev,
  (VTBL_ENTRY)&_ZN5S81C53v88Ev,
  (VTBL_ENTRY)&_ZN5S81C53v89Ev,
  (VTBL_ENTRY)&_ZN5S81C53v90Ev,
  (VTBL_ENTRY)&_ZN5S81C53v91Ev,
  (VTBL_ENTRY)&_ZN5S81C53v92Ev,
  (VTBL_ENTRY)&_ZN5S81C53v93Ev,
  (VTBL_ENTRY)&_ZN5S81C53v94Ev,
  (VTBL_ENTRY)&_ZN5S81C53v95Ev,
  (VTBL_ENTRY)&_ZN5S81C53v96Ev,
  (VTBL_ENTRY)&_ZN5S81C53v97Ev,
  (VTBL_ENTRY)&_ZN5S81C53v98Ev,
  (VTBL_ENTRY)&_ZN5S81C53v99Ev,
  (VTBL_ENTRY)&_ZN5S81C54v100Ev,
  (VTBL_ENTRY)&_ZN5S81C54v101Ev,
  (VTBL_ENTRY)&_ZN5S81C54v102Ev,
  (VTBL_ENTRY)&_ZN5S81C54v103Ev,
  (VTBL_ENTRY)&_ZN5S81C54v104Ev,
  (VTBL_ENTRY)&_ZN5S81C54v105Ev,
  (VTBL_ENTRY)&_ZN5S81C54v106Ev,
  (VTBL_ENTRY)&_ZN5S81C54v107Ev,
  (VTBL_ENTRY)&_ZN5S81C54v108Ev,
  (VTBL_ENTRY)&_ZN5S81C54v109Ev,
  (VTBL_ENTRY)&_ZN5S81C54v110Ev,
  (VTBL_ENTRY)&_ZN5S81C54v111Ev,
  (VTBL_ENTRY)&_ZN5S81C54v112Ev,
  (VTBL_ENTRY)&_ZN5S81C54v113Ev,
  (VTBL_ENTRY)&_ZN5S81C54v114Ev,
  (VTBL_ENTRY)&_ZN5S81C54v115Ev,
  (VTBL_ENTRY)&_ZN5S81C54v116Ev,
  (VTBL_ENTRY)&_ZN5S81C54v117Ev,
  (VTBL_ENTRY)&_ZN5S81C54v118Ev,
  (VTBL_ENTRY)&_ZN5S81C54v119Ev,
  (VTBL_ENTRY)&_ZN5S81C54v120Ev,
  (VTBL_ENTRY)&_ZN5S81C54v121Ev,
  (VTBL_ENTRY)&_ZN5S81C54v122Ev,
  (VTBL_ENTRY)&_ZN5S81C54v123Ev,
  (VTBL_ENTRY)&_ZN5S81C54v124Ev,
  (VTBL_ENTRY)&_ZN5S81C54v125Ev,
  (VTBL_ENTRY)&_ZN5S81C54v126Ev,
  (VTBL_ENTRY)&_ZN5S81C54v127Ev,
  (VTBL_ENTRY)&_ZN5S81C54v128Ev,
  (VTBL_ENTRY)&_ZN5S81C54v129Ev,
  (VTBL_ENTRY)&_ZN5S81C54v130Ev,
  (VTBL_ENTRY)&_ZN5S81C54v131Ev,
  (VTBL_ENTRY)&_ZN5S81C54v132Ev,
  (VTBL_ENTRY)&_ZN5S81C54v133Ev,
  (VTBL_ENTRY)&_ZN5S81C54v134Ev,
  (VTBL_ENTRY)&_ZN5S81C54v135Ev,
  (VTBL_ENTRY)&_ZN5S81C54v136Ev,
  (VTBL_ENTRY)&_ZN5S81C54v137Ev,
  (VTBL_ENTRY)&_ZN5S81C54v138Ev,
  (VTBL_ENTRY)&_ZN5S81C54v139Ev,
  (VTBL_ENTRY)&_ZN5S81C54v140Ev,
  (VTBL_ENTRY)&_ZN5S81C54v141Ev,
  (VTBL_ENTRY)&_ZN5S81C54v142Ev,
  (VTBL_ENTRY)&_ZN5S81C54v143Ev,
  (VTBL_ENTRY)&_ZN5S81C54v144Ev,
  (VTBL_ENTRY)&_ZN5S81C54v145Ev,
  (VTBL_ENTRY)&_ZN5S81C44v146Ev,
  (VTBL_ENTRY)&_ZN5S81C44v147Ev,
  (VTBL_ENTRY)&_ZN5S81C44v148Ev,
  (VTBL_ENTRY)&_ZN5S81C44v149Ev,
  (VTBL_ENTRY)&_ZN5S81C44v150Ev,
  (VTBL_ENTRY)&_ZN5S81C44v151Ev,
  (VTBL_ENTRY)&_ZN5S81C44v152Ev,
  (VTBL_ENTRY)&_ZN5S81C44v153Ev,
  (VTBL_ENTRY)&_ZN5S81C44v154Ev,
  (VTBL_ENTRY)&_ZN5S81C44v155Ev,
  (VTBL_ENTRY)&_ZN5S81C44v156Ev,
  (VTBL_ENTRY)&_ZN5S81C44v157Ev,
  (VTBL_ENTRY)&_ZN5S81C44v158Ev,
  (VTBL_ENTRY)&_ZN5S81C44v159Ev,
  (VTBL_ENTRY)&_ZN5S81C44v160Ev,
  (VTBL_ENTRY)&_ZN5S81C44v161Ev,
  (VTBL_ENTRY)&_ZN5S81C44v162Ev,
  (VTBL_ENTRY)&_ZN5S81C44v163Ev,
  (VTBL_ENTRY)&_ZN5S81C44v164Ev,
  (VTBL_ENTRY)&_ZN5S81C44v165Ev,
  (VTBL_ENTRY)&_ZN5S81C44v166Ev,
  (VTBL_ENTRY)&_ZN5S81C44v167Ev,
  (VTBL_ENTRY)&_ZN5S81C44v168Ev,
  (VTBL_ENTRY)&_ZN5S81C44v169Ev,
  (VTBL_ENTRY)&_ZN5S81C44v170Ev,
  (VTBL_ENTRY)&_ZN5S81C44v171Ev,
  (VTBL_ENTRY)&_ZN5S81C44v172Ev,
  (VTBL_ENTRY)&_ZN5S81C44v173Ev,
  (VTBL_ENTRY)&_ZN5S81C44v174Ev,
  (VTBL_ENTRY)&_ZN5S81C44v175Ev,
  (VTBL_ENTRY)&_ZN5S81C44v176Ev,
  (VTBL_ENTRY)&_ZN5S81C44v177Ev,
  (VTBL_ENTRY)&_ZN5S81C44v178Ev,
  (VTBL_ENTRY)&_ZN5S81C44v179Ev,
  (VTBL_ENTRY)&_ZN5S81C44v180Ev,
  (VTBL_ENTRY)&_ZN5S81C44v181Ev,
  (VTBL_ENTRY)&_ZN5S81C44v182Ev,
  (VTBL_ENTRY)&_ZN5S81C44v183Ev,
  (VTBL_ENTRY)&_ZN5S81C44v184Ev,
  (VTBL_ENTRY)&_ZN5S81C34v185Ev,
  (VTBL_ENTRY)&_ZN5S81C34v186Ev,
  (VTBL_ENTRY)&_ZN5S81C34v187Ev,
  (VTBL_ENTRY)&_ZN5S81C34v188Ev,
  (VTBL_ENTRY)&_ZN5S81C34v189Ev,
  (VTBL_ENTRY)&_ZN5S81C34v190Ev,
  (VTBL_ENTRY)&_ZN5S81C34v191Ev,
  (VTBL_ENTRY)&_ZN5S81C34v192Ev,
  (VTBL_ENTRY)&_ZN5S81C34v193Ev,
  (VTBL_ENTRY)&_ZN5S81C34v194Ev,
  (VTBL_ENTRY)&_ZN5S81C34v195Ev,
  (VTBL_ENTRY)&_ZN5S81C34v196Ev,
  (VTBL_ENTRY)&_ZN5S81C34v197Ev,
  (VTBL_ENTRY)&_ZN5S81C34v198Ev,
  (VTBL_ENTRY)&_ZN5S81C34v199Ev,
  (VTBL_ENTRY)&_ZN5S81C34v200Ev,
  (VTBL_ENTRY)&_ZN5S81C34v201Ev,
  (VTBL_ENTRY)&_ZN5S81C34v202Ev,
  (VTBL_ENTRY)&_ZN5S81C34v203Ev,
  (VTBL_ENTRY)&_ZN5S81C34v204Ev,
  (VTBL_ENTRY)&_ZN5S81C34v205Ev,
  (VTBL_ENTRY)&_ZN5S81C34v206Ev,
  (VTBL_ENTRY)&_ZN5S81C34v207Ev,
  (VTBL_ENTRY)&_ZN5S81C24v208Ev,
  (VTBL_ENTRY)&_ZN5S81C24v209Ev,
  (VTBL_ENTRY)&_ZN5S81C24v210Ev,
  (VTBL_ENTRY)&_ZN5S81C24v211Ev,
  (VTBL_ENTRY)&_ZN5S81C24v212Ev,
  (VTBL_ENTRY)&_ZN5S81C24v213Ev,
};
extern VTBL_ENTRY _ZTI5S81C2[];
extern  VTBL_ENTRY _ZTV5S81C2[];
Class_Descriptor cd_S81C2 = {  "S81C2", // class name
  bases_S81C2, 5,
  &(vtc_S81C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1032,736), // object size
  NSPAIRA(_ZTI5S81C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C2),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S81C1  : S81C2 {
  void *s81c1f0;
  unsigned int s81c1f1:1;
  virtual  ~S81C1(); // _ZN5S81C1D1Ev
  virtual void  v1(); // _ZN5S81C12v1Ev
  virtual void  v2(); // _ZN5S81C12v2Ev
  virtual void  v3(); // _ZN5S81C12v3Ev
  S81C1(); // tgen
};
//SIG(1 S81C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC13{ BC14{ BC12}} Fp FC15{ BC16{ BC12}} FC15 FC17{ BC18{ BC12}} FC19{ BC20{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC21{ m Fp FC22{ m Fi[2]}} FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21 FC21} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 FC8 Fp[9] FC23{ BC24{ BC12}} FC10 FC25{ BC26{ m FC27{ BC12} Fp Fi}} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fc[2] FC22 FC8 FC8 Fp FC21 FC21 FC21 FC21 FC21} vd v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[8] FC21 FC21 FC21} vd v208 v209 v210 v211 v212 v213 Fi:1 Fp[5] FC28{ BC29{ BC12}} FC30{ BC31{ BC12}} Fi:1 Fi:1 Fi[8] FC21 FC21 FC21} vd v1 v2 v3 Fp Fi:1}


 S81C1 ::~S81C1(){ note_dtor("S81C1", this);}
void  S81C1 ::v1(){vfunc_called(this, "_ZN5S81C12v1Ev");}
void  S81C1 ::v2(){vfunc_called(this, "_ZN5S81C12v2Ev");}
void  S81C1 ::v3(){vfunc_called(this, "_ZN5S81C12v3Ev");}
S81C1 ::S81C1(){ note_ctor("S81C1", this);} // tgen

static void Test_S81C1()
{
  extern Class_Descriptor cd_S81C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(132,187)];
    init_test(&cd_S81C1, buf);
    S81C1 *dp, &lv = *(dp=new (buf) S81C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1048,744), "sizeof(S81C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S81C1)");
    check_base_class_offset(lv, (S81C7*)(S81C6*)(S81C5*)(S81C4*)(S81C3*)(S81C2*), 0, "S81C1");
    check_base_class_offset(lv, (S81C6*)(S81C5*)(S81C4*)(S81C3*)(S81C2*), 0, "S81C1");
    check_base_class_offset(lv, (S81C5*)(S81C4*)(S81C3*)(S81C2*), 0, "S81C1");
    check_base_class_offset(lv, (S81C4*)(S81C3*)(S81C2*), 0, "S81C1");
    check_base_class_offset(lv, (S81C3*)(S81C2*), 0, "S81C1");
    check_base_class_offset(lv, (S81C2*), 0, "S81C1");
    check_field_offset(lv, s81c1f0, ABISELECT(1032,736), "S81C1.s81c1f0");
    set_bf_and_test(lv, s81c1f1, ABISELECT(1040,740), 0, 1, 1, "S81C1");
    test_class_info(&lv, &cd_S81C1);
    dp->~S81C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS81C1(Test_S81C1, "S81C1", ABISELECT(1048,744));

#else // __cplusplus

extern void _ZN5S81C1C1Ev();
extern void _ZN5S81C1D1Ev();
Name_Map name_map_S81C1[] = {
  NSPAIR(_ZN5S81C1C1Ev),
  NSPAIR(_ZN5S81C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S81C7;
extern VTBL_ENTRY _ZTI5S81C7[];
extern  VTBL_ENTRY _ZTV5S81C7[];
extern Class_Descriptor cd_S81C6;
extern VTBL_ENTRY _ZTI5S81C6[];
extern  VTBL_ENTRY _ZTV5S81C6[];
extern Class_Descriptor cd_S81C5;
extern VTBL_ENTRY _ZTI5S81C5[];
extern  VTBL_ENTRY _ZTV5S81C5[];
extern Class_Descriptor cd_S81C4;
extern VTBL_ENTRY _ZTI5S81C4[];
extern  VTBL_ENTRY _ZTV5S81C4[];
extern Class_Descriptor cd_S81C3;
extern VTBL_ENTRY _ZTI5S81C3[];
extern  VTBL_ENTRY _ZTV5S81C3[];
extern Class_Descriptor cd_S81C2;
extern VTBL_ENTRY _ZTI5S81C2[];
extern  VTBL_ENTRY _ZTV5S81C2[];
static Base_Class bases_S81C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S81C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S81C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S81C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S81C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S81C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S81C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S81C1[];
extern void _ZN5S81C1D1Ev();
extern void _ZN5S81C1D0Ev();
extern void _ZN5S81C72v4Ev();
extern void _ZN5S81C72v5Ev();
extern void _ZN5S81C72v6Ev();
extern void _ZN5S81C72v7Ev();
extern void _ZN5S81C72v8Ev();
extern void _ZN5S81C72v9Ev();
extern void _ZN5S81C73v10Ev();
extern void _ZN5S81C73v11Ev();
extern void _ZN5S81C73v12Ev();
extern void _ZN5S81C73v13Ev();
extern void _ZN5S81C73v14Ev();
extern void _ZN5S81C73v15Ev();
extern void _ZN5S81C73v16Ev();
extern void _ZN5S81C73v17Ev();
extern void _ZN5S81C73v18Ev();
extern void _ZN5S81C73v19Ev();
extern void _ZN5S81C73v20Ev();
extern void _ZN5S81C73v21Ev();
extern void _ZN5S81C73v22Ev();
extern void _ZN5S81C73v23Ev();
extern void _ZN5S81C73v24Ev();
extern void _ZN5S81C73v25Ev();
extern void _ZN5S81C73v26Ev();
extern void _ZN5S81C73v27Ev();
extern void _ZN5S81C73v28Ev();
extern void _ZN5S81C73v29Ev();
extern void _ZN5S81C73v30Ev();
extern void _ZN5S81C73v31Ev();
extern void _ZN5S81C73v32Ev();
extern void _ZN5S81C73v33Ev();
extern void _ZN5S81C73v34Ev();
extern void _ZN5S81C73v35Ev();
extern void _ZN5S81C73v36Ev();
extern void _ZN5S81C73v37Ev();
extern void _ZN5S81C73v38Ev();
extern void _ZN5S81C73v39Ev();
extern void _ZN5S81C73v40Ev();
extern void _ZN5S81C73v41Ev();
extern void _ZN5S81C73v42Ev();
extern void _ZN5S81C73v43Ev();
extern void _ZN5S81C73v44Ev();
extern void _ZN5S81C73v45Ev();
extern void _ZN5S81C73v46Ev();
extern void _ZN5S81C73v47Ev();
extern void _ZN5S81C73v48Ev();
extern void _ZN5S81C73v49Ev();
extern void _ZN5S81C73v50Ev();
extern void _ZN5S81C73v51Ev();
extern void _ZN5S81C73v52Ev();
extern void _ZN5S81C73v53Ev();
extern void _ZN5S81C73v54Ev();
extern void _ZN5S81C73v55Ev();
extern void _ZN5S81C73v56Ev();
extern void _ZN5S81C73v57Ev();
extern void _ZN5S81C73v58Ev();
extern void _ZN5S81C73v59Ev();
extern void _ZN5S81C73v60Ev();
extern void _ZN5S81C73v61Ev();
extern void _ZN5S81C73v62Ev();
extern void _ZN5S81C73v63Ev();
extern void _ZN5S81C73v64Ev();
extern void _ZN5S81C73v65Ev();
extern void _ZN5S81C73v66Ev();
extern void _ZN5S81C73v67Ev();
extern void _ZN5S81C63v68Ev();
extern void _ZN5S81C63v69Ev();
extern void _ZN5S81C53v70Ev();
extern void _ZN5S81C53v71Ev();
extern void _ZN5S81C53v72Ev();
extern void _ZN5S81C53v73Ev();
extern void _ZN5S81C53v74Ev();
extern void _ZN5S81C53v75Ev();
extern void _ZN5S81C53v76Ev();
extern void _ZN5S81C53v77Ev();
extern void _ZN5S81C53v78Ev();
extern void _ZN5S81C53v79Ev();
extern void _ZN5S81C53v80Ev();
extern void _ZN5S81C53v81Ev();
extern void _ZN5S81C53v82Ev();
extern void _ZN5S81C53v83Ev();
extern void _ZN5S81C53v84Ev();
extern void _ZN5S81C53v85Ev();
extern void _ZN5S81C53v86Ev();
extern void _ZN5S81C53v87Ev();
extern void _ZN5S81C53v88Ev();
extern void _ZN5S81C53v89Ev();
extern void _ZN5S81C53v90Ev();
extern void _ZN5S81C53v91Ev();
extern void _ZN5S81C53v92Ev();
extern void _ZN5S81C53v93Ev();
extern void _ZN5S81C53v94Ev();
extern void _ZN5S81C53v95Ev();
extern void _ZN5S81C53v96Ev();
extern void _ZN5S81C53v97Ev();
extern void _ZN5S81C53v98Ev();
extern void _ZN5S81C53v99Ev();
extern void _ZN5S81C54v100Ev();
extern void _ZN5S81C54v101Ev();
extern void _ZN5S81C54v102Ev();
extern void _ZN5S81C54v103Ev();
extern void _ZN5S81C54v104Ev();
extern void _ZN5S81C54v105Ev();
extern void _ZN5S81C54v106Ev();
extern void _ZN5S81C54v107Ev();
extern void _ZN5S81C54v108Ev();
extern void _ZN5S81C54v109Ev();
extern void _ZN5S81C54v110Ev();
extern void _ZN5S81C54v111Ev();
extern void _ZN5S81C54v112Ev();
extern void _ZN5S81C54v113Ev();
extern void _ZN5S81C54v114Ev();
extern void _ZN5S81C54v115Ev();
extern void _ZN5S81C54v116Ev();
extern void _ZN5S81C54v117Ev();
extern void _ZN5S81C54v118Ev();
extern void _ZN5S81C54v119Ev();
extern void _ZN5S81C54v120Ev();
extern void _ZN5S81C54v121Ev();
extern void _ZN5S81C54v122Ev();
extern void _ZN5S81C54v123Ev();
extern void _ZN5S81C54v124Ev();
extern void _ZN5S81C54v125Ev();
extern void _ZN5S81C54v126Ev();
extern void _ZN5S81C54v127Ev();
extern void _ZN5S81C54v128Ev();
extern void _ZN5S81C54v129Ev();
extern void _ZN5S81C54v130Ev();
extern void _ZN5S81C54v131Ev();
extern void _ZN5S81C54v132Ev();
extern void _ZN5S81C54v133Ev();
extern void _ZN5S81C54v134Ev();
extern void _ZN5S81C54v135Ev();
extern void _ZN5S81C54v136Ev();
extern void _ZN5S81C54v137Ev();
extern void _ZN5S81C54v138Ev();
extern void _ZN5S81C54v139Ev();
extern void _ZN5S81C54v140Ev();
extern void _ZN5S81C54v141Ev();
extern void _ZN5S81C54v142Ev();
extern void _ZN5S81C54v143Ev();
extern void _ZN5S81C54v144Ev();
extern void _ZN5S81C54v145Ev();
extern void _ZN5S81C44v146Ev();
extern void _ZN5S81C44v147Ev();
extern void _ZN5S81C44v148Ev();
extern void _ZN5S81C44v149Ev();
extern void _ZN5S81C44v150Ev();
extern void _ZN5S81C44v151Ev();
extern void _ZN5S81C44v152Ev();
extern void _ZN5S81C44v153Ev();
extern void _ZN5S81C44v154Ev();
extern void _ZN5S81C44v155Ev();
extern void _ZN5S81C44v156Ev();
extern void _ZN5S81C44v157Ev();
extern void _ZN5S81C44v158Ev();
extern void _ZN5S81C44v159Ev();
extern void _ZN5S81C44v160Ev();
extern void _ZN5S81C44v161Ev();
extern void _ZN5S81C44v162Ev();
extern void _ZN5S81C44v163Ev();
extern void _ZN5S81C44v164Ev();
extern void _ZN5S81C44v165Ev();
extern void _ZN5S81C44v166Ev();
extern void _ZN5S81C44v167Ev();
extern void _ZN5S81C44v168Ev();
extern void _ZN5S81C44v169Ev();
extern void _ZN5S81C44v170Ev();
extern void _ZN5S81C44v171Ev();
extern void _ZN5S81C44v172Ev();
extern void _ZN5S81C44v173Ev();
extern void _ZN5S81C44v174Ev();
extern void _ZN5S81C44v175Ev();
extern void _ZN5S81C44v176Ev();
extern void _ZN5S81C44v177Ev();
extern void _ZN5S81C44v178Ev();
extern void _ZN5S81C44v179Ev();
extern void _ZN5S81C44v180Ev();
extern void _ZN5S81C44v181Ev();
extern void _ZN5S81C44v182Ev();
extern void _ZN5S81C44v183Ev();
extern void _ZN5S81C44v184Ev();
extern void _ZN5S81C34v185Ev();
extern void _ZN5S81C34v186Ev();
extern void _ZN5S81C34v187Ev();
extern void _ZN5S81C34v188Ev();
extern void _ZN5S81C34v189Ev();
extern void _ZN5S81C34v190Ev();
extern void _ZN5S81C34v191Ev();
extern void _ZN5S81C34v192Ev();
extern void _ZN5S81C34v193Ev();
extern void _ZN5S81C34v194Ev();
extern void _ZN5S81C34v195Ev();
extern void _ZN5S81C34v196Ev();
extern void _ZN5S81C34v197Ev();
extern void _ZN5S81C34v198Ev();
extern void _ZN5S81C34v199Ev();
extern void _ZN5S81C34v200Ev();
extern void _ZN5S81C34v201Ev();
extern void _ZN5S81C34v202Ev();
extern void _ZN5S81C34v203Ev();
extern void _ZN5S81C34v204Ev();
extern void _ZN5S81C34v205Ev();
extern void _ZN5S81C34v206Ev();
extern void _ZN5S81C34v207Ev();
extern void _ZN5S81C24v208Ev();
extern void _ZN5S81C24v209Ev();
extern void _ZN5S81C24v210Ev();
extern void _ZN5S81C24v211Ev();
extern void _ZN5S81C24v212Ev();
extern void _ZN5S81C24v213Ev();
extern void _ZN5S81C12v1Ev();
extern void _ZN5S81C12v2Ev();
extern void _ZN5S81C12v3Ev();
static  VTBL_ENTRY vtc_S81C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S81C1[0]),
  (VTBL_ENTRY)&_ZN5S81C1D1Ev,
  (VTBL_ENTRY)&_ZN5S81C1D0Ev,
  (VTBL_ENTRY)&_ZN5S81C72v4Ev,
  (VTBL_ENTRY)&_ZN5S81C72v5Ev,
  (VTBL_ENTRY)&_ZN5S81C72v6Ev,
  (VTBL_ENTRY)&_ZN5S81C72v7Ev,
  (VTBL_ENTRY)&_ZN5S81C72v8Ev,
  (VTBL_ENTRY)&_ZN5S81C72v9Ev,
  (VTBL_ENTRY)&_ZN5S81C73v10Ev,
  (VTBL_ENTRY)&_ZN5S81C73v11Ev,
  (VTBL_ENTRY)&_ZN5S81C73v12Ev,
  (VTBL_ENTRY)&_ZN5S81C73v13Ev,
  (VTBL_ENTRY)&_ZN5S81C73v14Ev,
  (VTBL_ENTRY)&_ZN5S81C73v15Ev,
  (VTBL_ENTRY)&_ZN5S81C73v16Ev,
  (VTBL_ENTRY)&_ZN5S81C73v17Ev,
  (VTBL_ENTRY)&_ZN5S81C73v18Ev,
  (VTBL_ENTRY)&_ZN5S81C73v19Ev,
  (VTBL_ENTRY)&_ZN5S81C73v20Ev,
  (VTBL_ENTRY)&_ZN5S81C73v21Ev,
  (VTBL_ENTRY)&_ZN5S81C73v22Ev,
  (VTBL_ENTRY)&_ZN5S81C73v23Ev,
  (VTBL_ENTRY)&_ZN5S81C73v24Ev,
  (VTBL_ENTRY)&_ZN5S81C73v25Ev,
  (VTBL_ENTRY)&_ZN5S81C73v26Ev,
  (VTBL_ENTRY)&_ZN5S81C73v27Ev,
  (VTBL_ENTRY)&_ZN5S81C73v28Ev,
  (VTBL_ENTRY)&_ZN5S81C73v29Ev,
  (VTBL_ENTRY)&_ZN5S81C73v30Ev,
  (VTBL_ENTRY)&_ZN5S81C73v31Ev,
  (VTBL_ENTRY)&_ZN5S81C73v32Ev,
  (VTBL_ENTRY)&_ZN5S81C73v33Ev,
  (VTBL_ENTRY)&_ZN5S81C73v34Ev,
  (VTBL_ENTRY)&_ZN5S81C73v35Ev,
  (VTBL_ENTRY)&_ZN5S81C73v36Ev,
  (VTBL_ENTRY)&_ZN5S81C73v37Ev,
  (VTBL_ENTRY)&_ZN5S81C73v38Ev,
  (VTBL_ENTRY)&_ZN5S81C73v39Ev,
  (VTBL_ENTRY)&_ZN5S81C73v40Ev,
  (VTBL_ENTRY)&_ZN5S81C73v41Ev,
  (VTBL_ENTRY)&_ZN5S81C73v42Ev,
  (VTBL_ENTRY)&_ZN5S81C73v43Ev,
  (VTBL_ENTRY)&_ZN5S81C73v44Ev,
  (VTBL_ENTRY)&_ZN5S81C73v45Ev,
  (VTBL_ENTRY)&_ZN5S81C73v46Ev,
  (VTBL_ENTRY)&_ZN5S81C73v47Ev,
  (VTBL_ENTRY)&_ZN5S81C73v48Ev,
  (VTBL_ENTRY)&_ZN5S81C73v49Ev,
  (VTBL_ENTRY)&_ZN5S81C73v50Ev,
  (VTBL_ENTRY)&_ZN5S81C73v51Ev,
  (VTBL_ENTRY)&_ZN5S81C73v52Ev,
  (VTBL_ENTRY)&_ZN5S81C73v53Ev,
  (VTBL_ENTRY)&_ZN5S81C73v54Ev,
  (VTBL_ENTRY)&_ZN5S81C73v55Ev,
  (VTBL_ENTRY)&_ZN5S81C73v56Ev,
  (VTBL_ENTRY)&_ZN5S81C73v57Ev,
  (VTBL_ENTRY)&_ZN5S81C73v58Ev,
  (VTBL_ENTRY)&_ZN5S81C73v59Ev,
  (VTBL_ENTRY)&_ZN5S81C73v60Ev,
  (VTBL_ENTRY)&_ZN5S81C73v61Ev,
  (VTBL_ENTRY)&_ZN5S81C73v62Ev,
  (VTBL_ENTRY)&_ZN5S81C73v63Ev,
  (VTBL_ENTRY)&_ZN5S81C73v64Ev,
  (VTBL_ENTRY)&_ZN5S81C73v65Ev,
  (VTBL_ENTRY)&_ZN5S81C73v66Ev,
  (VTBL_ENTRY)&_ZN5S81C73v67Ev,
  (VTBL_ENTRY)&_ZN5S81C63v68Ev,
  (VTBL_ENTRY)&_ZN5S81C63v69Ev,
  (VTBL_ENTRY)&_ZN5S81C53v70Ev,
  (VTBL_ENTRY)&_ZN5S81C53v71Ev,
  (VTBL_ENTRY)&_ZN5S81C53v72Ev,
  (VTBL_ENTRY)&_ZN5S81C53v73Ev,
  (VTBL_ENTRY)&_ZN5S81C53v74Ev,
  (VTBL_ENTRY)&_ZN5S81C53v75Ev,
  (VTBL_ENTRY)&_ZN5S81C53v76Ev,
  (VTBL_ENTRY)&_ZN5S81C53v77Ev,
  (VTBL_ENTRY)&_ZN5S81C53v78Ev,
  (VTBL_ENTRY)&_ZN5S81C53v79Ev,
  (VTBL_ENTRY)&_ZN5S81C53v80Ev,
  (VTBL_ENTRY)&_ZN5S81C53v81Ev,
  (VTBL_ENTRY)&_ZN5S81C53v82Ev,
  (VTBL_ENTRY)&_ZN5S81C53v83Ev,
  (VTBL_ENTRY)&_ZN5S81C53v84Ev,
  (VTBL_ENTRY)&_ZN5S81C53v85Ev,
  (VTBL_ENTRY)&_ZN5S81C53v86Ev,
  (VTBL_ENTRY)&_ZN5S81C53v87Ev,
  (VTBL_ENTRY)&_ZN5S81C53v88Ev,
  (VTBL_ENTRY)&_ZN5S81C53v89Ev,
  (VTBL_ENTRY)&_ZN5S81C53v90Ev,
  (VTBL_ENTRY)&_ZN5S81C53v91Ev,
  (VTBL_ENTRY)&_ZN5S81C53v92Ev,
  (VTBL_ENTRY)&_ZN5S81C53v93Ev,
  (VTBL_ENTRY)&_ZN5S81C53v94Ev,
  (VTBL_ENTRY)&_ZN5S81C53v95Ev,
  (VTBL_ENTRY)&_ZN5S81C53v96Ev,
  (VTBL_ENTRY)&_ZN5S81C53v97Ev,
  (VTBL_ENTRY)&_ZN5S81C53v98Ev,
  (VTBL_ENTRY)&_ZN5S81C53v99Ev,
  (VTBL_ENTRY)&_ZN5S81C54v100Ev,
  (VTBL_ENTRY)&_ZN5S81C54v101Ev,
  (VTBL_ENTRY)&_ZN5S81C54v102Ev,
  (VTBL_ENTRY)&_ZN5S81C54v103Ev,
  (VTBL_ENTRY)&_ZN5S81C54v104Ev,
  (VTBL_ENTRY)&_ZN5S81C54v105Ev,
  (VTBL_ENTRY)&_ZN5S81C54v106Ev,
  (VTBL_ENTRY)&_ZN5S81C54v107Ev,
  (VTBL_ENTRY)&_ZN5S81C54v108Ev,
  (VTBL_ENTRY)&_ZN5S81C54v109Ev,
  (VTBL_ENTRY)&_ZN5S81C54v110Ev,
  (VTBL_ENTRY)&_ZN5S81C54v111Ev,
  (VTBL_ENTRY)&_ZN5S81C54v112Ev,
  (VTBL_ENTRY)&_ZN5S81C54v113Ev,
  (VTBL_ENTRY)&_ZN5S81C54v114Ev,
  (VTBL_ENTRY)&_ZN5S81C54v115Ev,
  (VTBL_ENTRY)&_ZN5S81C54v116Ev,
  (VTBL_ENTRY)&_ZN5S81C54v117Ev,
  (VTBL_ENTRY)&_ZN5S81C54v118Ev,
  (VTBL_ENTRY)&_ZN5S81C54v119Ev,
  (VTBL_ENTRY)&_ZN5S81C54v120Ev,
  (VTBL_ENTRY)&_ZN5S81C54v121Ev,
  (VTBL_ENTRY)&_ZN5S81C54v122Ev,
  (VTBL_ENTRY)&_ZN5S81C54v123Ev,
  (VTBL_ENTRY)&_ZN5S81C54v124Ev,
  (VTBL_ENTRY)&_ZN5S81C54v125Ev,
  (VTBL_ENTRY)&_ZN5S81C54v126Ev,
  (VTBL_ENTRY)&_ZN5S81C54v127Ev,
  (VTBL_ENTRY)&_ZN5S81C54v128Ev,
  (VTBL_ENTRY)&_ZN5S81C54v129Ev,
  (VTBL_ENTRY)&_ZN5S81C54v130Ev,
  (VTBL_ENTRY)&_ZN5S81C54v131Ev,
  (VTBL_ENTRY)&_ZN5S81C54v132Ev,
  (VTBL_ENTRY)&_ZN5S81C54v133Ev,
  (VTBL_ENTRY)&_ZN5S81C54v134Ev,
  (VTBL_ENTRY)&_ZN5S81C54v135Ev,
  (VTBL_ENTRY)&_ZN5S81C54v136Ev,
  (VTBL_ENTRY)&_ZN5S81C54v137Ev,
  (VTBL_ENTRY)&_ZN5S81C54v138Ev,
  (VTBL_ENTRY)&_ZN5S81C54v139Ev,
  (VTBL_ENTRY)&_ZN5S81C54v140Ev,
  (VTBL_ENTRY)&_ZN5S81C54v141Ev,
  (VTBL_ENTRY)&_ZN5S81C54v142Ev,
  (VTBL_ENTRY)&_ZN5S81C54v143Ev,
  (VTBL_ENTRY)&_ZN5S81C54v144Ev,
  (VTBL_ENTRY)&_ZN5S81C54v145Ev,
  (VTBL_ENTRY)&_ZN5S81C44v146Ev,
  (VTBL_ENTRY)&_ZN5S81C44v147Ev,
  (VTBL_ENTRY)&_ZN5S81C44v148Ev,
  (VTBL_ENTRY)&_ZN5S81C44v149Ev,
  (VTBL_ENTRY)&_ZN5S81C44v150Ev,
  (VTBL_ENTRY)&_ZN5S81C44v151Ev,
  (VTBL_ENTRY)&_ZN5S81C44v152Ev,
  (VTBL_ENTRY)&_ZN5S81C44v153Ev,
  (VTBL_ENTRY)&_ZN5S81C44v154Ev,
  (VTBL_ENTRY)&_ZN5S81C44v155Ev,
  (VTBL_ENTRY)&_ZN5S81C44v156Ev,
  (VTBL_ENTRY)&_ZN5S81C44v157Ev,
  (VTBL_ENTRY)&_ZN5S81C44v158Ev,
  (VTBL_ENTRY)&_ZN5S81C44v159Ev,
  (VTBL_ENTRY)&_ZN5S81C44v160Ev,
  (VTBL_ENTRY)&_ZN5S81C44v161Ev,
  (VTBL_ENTRY)&_ZN5S81C44v162Ev,
  (VTBL_ENTRY)&_ZN5S81C44v163Ev,
  (VTBL_ENTRY)&_ZN5S81C44v164Ev,
  (VTBL_ENTRY)&_ZN5S81C44v165Ev,
  (VTBL_ENTRY)&_ZN5S81C44v166Ev,
  (VTBL_ENTRY)&_ZN5S81C44v167Ev,
  (VTBL_ENTRY)&_ZN5S81C44v168Ev,
  (VTBL_ENTRY)&_ZN5S81C44v169Ev,
  (VTBL_ENTRY)&_ZN5S81C44v170Ev,
  (VTBL_ENTRY)&_ZN5S81C44v171Ev,
  (VTBL_ENTRY)&_ZN5S81C44v172Ev,
  (VTBL_ENTRY)&_ZN5S81C44v173Ev,
  (VTBL_ENTRY)&_ZN5S81C44v174Ev,
  (VTBL_ENTRY)&_ZN5S81C44v175Ev,
  (VTBL_ENTRY)&_ZN5S81C44v176Ev,
  (VTBL_ENTRY)&_ZN5S81C44v177Ev,
  (VTBL_ENTRY)&_ZN5S81C44v178Ev,
  (VTBL_ENTRY)&_ZN5S81C44v179Ev,
  (VTBL_ENTRY)&_ZN5S81C44v180Ev,
  (VTBL_ENTRY)&_ZN5S81C44v181Ev,
  (VTBL_ENTRY)&_ZN5S81C44v182Ev,
  (VTBL_ENTRY)&_ZN5S81C44v183Ev,
  (VTBL_ENTRY)&_ZN5S81C44v184Ev,
  (VTBL_ENTRY)&_ZN5S81C34v185Ev,
  (VTBL_ENTRY)&_ZN5S81C34v186Ev,
  (VTBL_ENTRY)&_ZN5S81C34v187Ev,
  (VTBL_ENTRY)&_ZN5S81C34v188Ev,
  (VTBL_ENTRY)&_ZN5S81C34v189Ev,
  (VTBL_ENTRY)&_ZN5S81C34v190Ev,
  (VTBL_ENTRY)&_ZN5S81C34v191Ev,
  (VTBL_ENTRY)&_ZN5S81C34v192Ev,
  (VTBL_ENTRY)&_ZN5S81C34v193Ev,
  (VTBL_ENTRY)&_ZN5S81C34v194Ev,
  (VTBL_ENTRY)&_ZN5S81C34v195Ev,
  (VTBL_ENTRY)&_ZN5S81C34v196Ev,
  (VTBL_ENTRY)&_ZN5S81C34v197Ev,
  (VTBL_ENTRY)&_ZN5S81C34v198Ev,
  (VTBL_ENTRY)&_ZN5S81C34v199Ev,
  (VTBL_ENTRY)&_ZN5S81C34v200Ev,
  (VTBL_ENTRY)&_ZN5S81C34v201Ev,
  (VTBL_ENTRY)&_ZN5S81C34v202Ev,
  (VTBL_ENTRY)&_ZN5S81C34v203Ev,
  (VTBL_ENTRY)&_ZN5S81C34v204Ev,
  (VTBL_ENTRY)&_ZN5S81C34v205Ev,
  (VTBL_ENTRY)&_ZN5S81C34v206Ev,
  (VTBL_ENTRY)&_ZN5S81C34v207Ev,
  (VTBL_ENTRY)&_ZN5S81C24v208Ev,
  (VTBL_ENTRY)&_ZN5S81C24v209Ev,
  (VTBL_ENTRY)&_ZN5S81C24v210Ev,
  (VTBL_ENTRY)&_ZN5S81C24v211Ev,
  (VTBL_ENTRY)&_ZN5S81C24v212Ev,
  (VTBL_ENTRY)&_ZN5S81C24v213Ev,
  (VTBL_ENTRY)&_ZN5S81C12v1Ev,
  (VTBL_ENTRY)&_ZN5S81C12v2Ev,
  (VTBL_ENTRY)&_ZN5S81C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S81C1[];
extern  VTBL_ENTRY _ZTV5S81C1[];
Class_Descriptor cd_S81C1 = {  "S81C1", // class name
  bases_S81C1, 6,
  &(vtc_S81C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1048,744), // object size
  NSPAIRA(_ZTI5S81C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S81C1),217, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S102C7  {
  int s102c7f0;
  __tsi64 s102c7f1;
  void *s102c7f2[4];
  int s102c7f3[2];
  void *s102c7f4;
  ::S85C27_nt s102c7f5;
  void *s102c7f6[2];
  virtual  ~S102C7(); // _ZN6S102C7D1Ev
  virtual void  v5(); // _ZN6S102C72v5Ev
  virtual void  v6(); // _ZN6S102C72v6Ev
  virtual void  v7(); // _ZN6S102C72v7Ev
  virtual void  v8(); // _ZN6S102C72v8Ev
  virtual void  v9(); // _ZN6S102C72v9Ev
  virtual void  v10(); // _ZN6S102C73v10Ev
  virtual void  v11(); // _ZN6S102C73v11Ev
  virtual void  v12(); // _ZN6S102C73v12Ev
  virtual void  v13(); // _ZN6S102C73v13Ev
  virtual void  v14(); // _ZN6S102C73v14Ev
  virtual void  v15(); // _ZN6S102C73v15Ev
  virtual void  v16(); // _ZN6S102C73v16Ev
  virtual void  v17(); // _ZN6S102C73v17Ev
  virtual void  v18(); // _ZN6S102C73v18Ev
  virtual void  v19(); // _ZN6S102C73v19Ev
  virtual void  v20(); // _ZN6S102C73v20Ev
  virtual void  v21(); // _ZN6S102C73v21Ev
  virtual void  v22(); // _ZN6S102C73v22Ev
  virtual void  v23(); // _ZN6S102C73v23Ev
  virtual void  v24(); // _ZN6S102C73v24Ev
  virtual void  v25(); // _ZN6S102C73v25Ev
  virtual void  v26(); // _ZN6S102C73v26Ev
  virtual void  v27(); // _ZN6S102C73v27Ev
  virtual void  v28(); // _ZN6S102C73v28Ev
  virtual void  v29(); // _ZN6S102C73v29Ev
  virtual void  v30(); // _ZN6S102C73v30Ev
  virtual void  v31(); // _ZN6S102C73v31Ev
  virtual void  v32(); // _ZN6S102C73v32Ev
  virtual void  v33(); // _ZN6S102C73v33Ev
  virtual void  v34(); // _ZN6S102C73v34Ev
  virtual void  v35(); // _ZN6S102C73v35Ev
  virtual void  v36(); // _ZN6S102C73v36Ev
  virtual void  v37(); // _ZN6S102C73v37Ev
  virtual void  v38(); // _ZN6S102C73v38Ev
  virtual void  v39(); // _ZN6S102C73v39Ev
  virtual void  v40(); // _ZN6S102C73v40Ev
  virtual void  v41(); // _ZN6S102C73v41Ev
  virtual void  v42(); // _ZN6S102C73v42Ev
  virtual void  v43(); // _ZN6S102C73v43Ev
  virtual void  v44(); // _ZN6S102C73v44Ev
  virtual void  v45(); // _ZN6S102C73v45Ev
  virtual void  v46(); // _ZN6S102C73v46Ev
  virtual void  v47(); // _ZN6S102C73v47Ev
  virtual void  v48(); // _ZN6S102C73v48Ev
  virtual void  v49(); // _ZN6S102C73v49Ev
  virtual void  v50(); // _ZN6S102C73v50Ev
  virtual void  v51(); // _ZN6S102C73v51Ev
  virtual void  v52(); // _ZN6S102C73v52Ev
  virtual void  v53(); // _ZN6S102C73v53Ev
  virtual void  v54(); // _ZN6S102C73v54Ev
  virtual void  v55(); // _ZN6S102C73v55Ev
  virtual void  v56(); // _ZN6S102C73v56Ev
  virtual void  v57(); // _ZN6S102C73v57Ev
  virtual void  v58(); // _ZN6S102C73v58Ev
  virtual void  v59(); // _ZN6S102C73v59Ev
  virtual void  v60(); // _ZN6S102C73v60Ev
  virtual void  v61(); // _ZN6S102C73v61Ev
  virtual void  v62(); // _ZN6S102C73v62Ev
  virtual void  v63(); // _ZN6S102C73v63Ev
  virtual void  v64(); // _ZN6S102C73v64Ev
  virtual void  v65(); // _ZN6S102C73v65Ev
  virtual void  v66(); // _ZN6S102C73v66Ev
  virtual void  v67(); // _ZN6S102C73v67Ev
  virtual void  v68(); // _ZN6S102C73v68Ev
  S102C7(); // tgen
};
//SIG(-1 S102C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S102C7 ::~S102C7(){ note_dtor("S102C7", this);}
void  S102C7 ::v5(){vfunc_called(this, "_ZN6S102C72v5Ev");}
void  S102C7 ::v6(){vfunc_called(this, "_ZN6S102C72v6Ev");}
void  S102C7 ::v7(){vfunc_called(this, "_ZN6S102C72v7Ev");}
void 