// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S78C8_nt  {
  int s78c8f0[2];
  void  mf78c8(); // _ZN8S78C8_nt6mf78c8Ev
};
//SIG(-1 S78C8_nt) C1{ m Fi[2]}


void  S78C8_nt ::mf78c8(){}

//skip512 S78C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C7_nt  {
  int s78c7f0;
  __tsi64 s78c7f1;
  void *s78c7f2[4];
  int s78c7f3[2];
  void *s78c7f4;
  ::S78C8_nt s78c7f5;
  void *s78c7f6[2];
  virtual  ~S78C7_nt(); // _ZN8S78C7_ntD1Ev
  virtual void  v4(); // _ZN8S78C7_nt2v4Ev
  virtual void  v5(); // _ZN8S78C7_nt2v5Ev
  virtual void  v6(); // _ZN8S78C7_nt2v6Ev
  virtual void  v7(); // _ZN8S78C7_nt2v7Ev
  virtual void  v8(); // _ZN8S78C7_nt2v8Ev
  virtual void  v9(); // _ZN8S78C7_nt2v9Ev
  virtual void  v10(); // _ZN8S78C7_nt3v10Ev
  virtual void  v11(); // _ZN8S78C7_nt3v11Ev
  virtual void  v12(); // _ZN8S78C7_nt3v12Ev
  virtual void  v13(); // _ZN8S78C7_nt3v13Ev
  virtual void  v14(); // _ZN8S78C7_nt3v14Ev
  virtual void  v15(); // _ZN8S78C7_nt3v15Ev
  virtual void  v16(); // _ZN8S78C7_nt3v16Ev
  virtual void  v17(); // _ZN8S78C7_nt3v17Ev
  virtual void  v18(); // _ZN8S78C7_nt3v18Ev
  virtual void  v19(); // _ZN8S78C7_nt3v19Ev
  virtual void  v20(); // _ZN8S78C7_nt3v20Ev
  virtual void  v21(); // _ZN8S78C7_nt3v21Ev
  virtual void  v22(); // _ZN8S78C7_nt3v22Ev
  virtual void  v23(); // _ZN8S78C7_nt3v23Ev
  virtual void  v24(); // _ZN8S78C7_nt3v24Ev
  virtual void  v25(); // _ZN8S78C7_nt3v25Ev
  virtual void  v26(); // _ZN8S78C7_nt3v26Ev
  virtual void  v27(); // _ZN8S78C7_nt3v27Ev
  virtual void  v28(); // _ZN8S78C7_nt3v28Ev
  virtual void  v29(); // _ZN8S78C7_nt3v29Ev
  virtual void  v30(); // _ZN8S78C7_nt3v30Ev
  virtual void  v31(); // _ZN8S78C7_nt3v31Ev
  virtual void  v32(); // _ZN8S78C7_nt3v32Ev
  virtual void  v33(); // _ZN8S78C7_nt3v33Ev
  virtual void  v34(); // _ZN8S78C7_nt3v34Ev
  virtual void  v35(); // _ZN8S78C7_nt3v35Ev
  virtual void  v36(); // _ZN8S78C7_nt3v36Ev
  virtual void  v37(); // _ZN8S78C7_nt3v37Ev
  virtual void  v38(); // _ZN8S78C7_nt3v38Ev
  virtual void  v39(); // _ZN8S78C7_nt3v39Ev
  virtual void  v40(); // _ZN8S78C7_nt3v40Ev
  virtual void  v41(); // _ZN8S78C7_nt3v41Ev
  virtual void  v42(); // _ZN8S78C7_nt3v42Ev
  virtual void  v43(); // _ZN8S78C7_nt3v43Ev
  virtual void  v44(); // _ZN8S78C7_nt3v44Ev
  virtual void  v45(); // _ZN8S78C7_nt3v45Ev
  virtual void  v46(); // _ZN8S78C7_nt3v46Ev
  virtual void  v47(); // _ZN8S78C7_nt3v47Ev
  virtual void  v48(); // _ZN8S78C7_nt3v48Ev
  virtual void  v49(); // _ZN8S78C7_nt3v49Ev
  virtual void  v50(); // _ZN8S78C7_nt3v50Ev
  virtual void  v51(); // _ZN8S78C7_nt3v51Ev
  virtual void  v52(); // _ZN8S78C7_nt3v52Ev
  virtual void  v53(); // _ZN8S78C7_nt3v53Ev
  virtual void  v54(); // _ZN8S78C7_nt3v54Ev
  virtual void  v55(); // _ZN8S78C7_nt3v55Ev
  virtual void  v56(); // _ZN8S78C7_nt3v56Ev
  virtual void  v57(); // _ZN8S78C7_nt3v57Ev
  virtual void  v58(); // _ZN8S78C7_nt3v58Ev
  virtual void  v59(); // _ZN8S78C7_nt3v59Ev
  virtual void  v60(); // _ZN8S78C7_nt3v60Ev
  virtual void  v61(); // _ZN8S78C7_nt3v61Ev
  virtual void  v62(); // _ZN8S78C7_nt3v62Ev
  virtual void  v63(); // _ZN8S78C7_nt3v63Ev
  virtual void  v64(); // _ZN8S78C7_nt3v64Ev
  virtual void  v65(); // _ZN8S78C7_nt3v65Ev
  virtual void  v66(); // _ZN8S78C7_nt3v66Ev
  virtual void  v67(); // _ZN8S78C7_nt3v67Ev
  S78C7_nt(); // tgen
};
//SIG(-1 S78C7_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S78C7_nt ::~S78C7_nt(){ note_dtor("S78C7_nt", this);}
void  S78C7_nt ::v4(){vfunc_called(this, "_ZN8S78C7_nt2v4Ev");}
void  S78C7_nt ::v5(){vfunc_called(this, "_ZN8S78C7_nt2v5Ev");}
void  S78C7_nt ::v6(){vfunc_called(this, "_ZN8S78C7_nt2v6Ev");}
void  S78C7_nt ::v7(){vfunc_called(this, "_ZN8S78C7_nt2v7Ev");}
void  S78C7_nt ::v8(){vfunc_called(this, "_ZN8S78C7_nt2v8Ev");}
void  S78C7_nt ::v9(){vfunc_called(this, "_ZN8S78C7_nt2v9Ev");}
void  S78C7_nt ::v10(){vfunc_called(this, "_ZN8S78C7_nt3v10Ev");}
void  S78C7_nt ::v11(){vfunc_called(this, "_ZN8S78C7_nt3v11Ev");}
void  S78C7_nt ::v12(){vfunc_called(this, "_ZN8S78C7_nt3v12Ev");}
void  S78C7_nt ::v13(){vfunc_called(this, "_ZN8S78C7_nt3v13Ev");}
void  S78C7_nt ::v14(){vfunc_called(this, "_ZN8S78C7_nt3v14Ev");}
void  S78C7_nt ::v15(){vfunc_called(this, "_ZN8S78C7_nt3v15Ev");}
void  S78C7_nt ::v16(){vfunc_called(this, "_ZN8S78C7_nt3v16Ev");}
void  S78C7_nt ::v17(){vfunc_called(this, "_ZN8S78C7_nt3v17Ev");}
void  S78C7_nt ::v18(){vfunc_called(this, "_ZN8S78C7_nt3v18Ev");}
void  S78C7_nt ::v19(){vfunc_called(this, "_ZN8S78C7_nt3v19Ev");}
void  S78C7_nt ::v20(){vfunc_called(this, "_ZN8S78C7_nt3v20Ev");}
void  S78C7_nt ::v21(){vfunc_called(this, "_ZN8S78C7_nt3v21Ev");}
void  S78C7_nt ::v22(){vfunc_called(this, "_ZN8S78C7_nt3v22Ev");}
void  S78C7_nt ::v23(){vfunc_called(this, "_ZN8S78C7_nt3v23Ev");}
void  S78C7_nt ::v24(){vfunc_called(this, "_ZN8S78C7_nt3v24Ev");}
void  S78C7_nt ::v25(){vfunc_called(this, "_ZN8S78C7_nt3v25Ev");}
void  S78C7_nt ::v26(){vfunc_called(this, "_ZN8S78C7_nt3v26Ev");}
void  S78C7_nt ::v27(){vfunc_called(this, "_ZN8S78C7_nt3v27Ev");}
void  S78C7_nt ::v28(){vfunc_called(this, "_ZN8S78C7_nt3v28Ev");}
void  S78C7_nt ::v29(){vfunc_called(this, "_ZN8S78C7_nt3v29Ev");}
void  S78C7_nt ::v30(){vfunc_called(this, "_ZN8S78C7_nt3v30Ev");}
void  S78C7_nt ::v31(){vfunc_called(this, "_ZN8S78C7_nt3v31Ev");}
void  S78C7_nt ::v32(){vfunc_called(this, "_ZN8S78C7_nt3v32Ev");}
void  S78C7_nt ::v33(){vfunc_called(this, "_ZN8S78C7_nt3v33Ev");}
void  S78C7_nt ::v34(){vfunc_called(this, "_ZN8S78C7_nt3v34Ev");}
void  S78C7_nt ::v35(){vfunc_called(this, "_ZN8S78C7_nt3v35Ev");}
void  S78C7_nt ::v36(){vfunc_called(this, "_ZN8S78C7_nt3v36Ev");}
void  S78C7_nt ::v37(){vfunc_called(this, "_ZN8S78C7_nt3v37Ev");}
void  S78C7_nt ::v38(){vfunc_called(this, "_ZN8S78C7_nt3v38Ev");}
void  S78C7_nt ::v39(){vfunc_called(this, "_ZN8S78C7_nt3v39Ev");}
void  S78C7_nt ::v40(){vfunc_called(this, "_ZN8S78C7_nt3v40Ev");}
void  S78C7_nt ::v41(){vfunc_called(this, "_ZN8S78C7_nt3v41Ev");}
void  S78C7_nt ::v42(){vfunc_called(this, "_ZN8S78C7_nt3v42Ev");}
void  S78C7_nt ::v43(){vfunc_called(this, "_ZN8S78C7_nt3v43Ev");}
void  S78C7_nt ::v44(){vfunc_called(this, "_ZN8S78C7_nt3v44Ev");}
void  S78C7_nt ::v45(){vfunc_called(this, "_ZN8S78C7_nt3v45Ev");}
void  S78C7_nt ::v46(){vfunc_called(this, "_ZN8S78C7_nt3v46Ev");}
void  S78C7_nt ::v47(){vfunc_called(this, "_ZN8S78C7_nt3v47Ev");}
void  S78C7_nt ::v48(){vfunc_called(this, "_ZN8S78C7_nt3v48Ev");}
void  S78C7_nt ::v49(){vfunc_called(this, "_ZN8S78C7_nt3v49Ev");}
void  S78C7_nt ::v50(){vfunc_called(this, "_ZN8S78C7_nt3v50Ev");}
void  S78C7_nt ::v51(){vfunc_called(this, "_ZN8S78C7_nt3v51Ev");}
void  S78C7_nt ::v52(){vfunc_called(this, "_ZN8S78C7_nt3v52Ev");}
void  S78C7_nt ::v53(){vfunc_called(this, "_ZN8S78C7_nt3v53Ev");}
void  S78C7_nt ::v54(){vfunc_called(this, "_ZN8S78C7_nt3v54Ev");}
void  S78C7_nt ::v55(){vfunc_called(this, "_ZN8S78C7_nt3v55Ev");}
void  S78C7_nt ::v56(){vfunc_called(this, "_ZN8S78C7_nt3v56Ev");}
void  S78C7_nt ::v57(){vfunc_called(this, "_ZN8S78C7_nt3v57Ev");}
void  S78C7_nt ::v58(){vfunc_called(this, "_ZN8S78C7_nt3v58Ev");}
void  S78C7_nt ::v59(){vfunc_called(this, "_ZN8S78C7_nt3v59Ev");}
void  S78C7_nt ::v60(){vfunc_called(this, "_ZN8S78C7_nt3v60Ev");}
void  S78C7_nt ::v61(){vfunc_called(this, "_ZN8S78C7_nt3v61Ev");}
void  S78C7_nt ::v62(){vfunc_called(this, "_ZN8S78C7_nt3v62Ev");}
void  S78C7_nt ::v63(){vfunc_called(this, "_ZN8S78C7_nt3v63Ev");}
void  S78C7_nt ::v64(){vfunc_called(this, "_ZN8S78C7_nt3v64Ev");}
void  S78C7_nt ::v65(){vfunc_called(this, "_ZN8S78C7_nt3v65Ev");}
void  S78C7_nt ::v66(){vfunc_called(this, "_ZN8S78C7_nt3v66Ev");}
void  S78C7_nt ::v67(){vfunc_called(this, "_ZN8S78C7_nt3v67Ev");}
S78C7_nt ::S78C7_nt(){ note_ctor("S78C7_nt", this);} // tgen

//skip512 S78C7_nt

#else // __cplusplus

extern void _ZN8S78C7_ntC1Ev();
extern void _ZN8S78C7_ntD1Ev();
Name_Map name_map_S78C7_nt[] = {
  NSPAIR(_ZN8S78C7_ntC1Ev),
  NSPAIR(_ZN8S78C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern void _ZN8S78C7_ntD1Ev();
extern void _ZN8S78C7_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
static  VTBL_ENTRY vtc_S78C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI8S78C7_nt[];
VTBL_ENTRY *P__ZTI8S78C7_nt = _ZTI8S78C7_nt; 
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
Class_Descriptor cd_S78C7_nt = {  "S78C7_nt", // class name
  0,0,//no base classes
  &(vtc_S78C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S78C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S78C7_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C6_nt  : S78C7_nt {
  virtual  ~S78C6_nt(); // _ZN8S78C6_ntD1Ev
  virtual void  v68(); // _ZN8S78C6_nt3v68Ev
  virtual void  v69(); // _ZN8S78C6_nt3v69Ev
  S78C6_nt(); // tgen
};
//SIG(-1 S78C6_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S78C6_nt ::~S78C6_nt(){ note_dtor("S78C6_nt", this);}
void  S78C6_nt ::v68(){vfunc_called(this, "_ZN8S78C6_nt3v68Ev");}
void  S78C6_nt ::v69(){vfunc_called(this, "_ZN8S78C6_nt3v69Ev");}
S78C6_nt ::S78C6_nt(){ note_ctor("S78C6_nt", this);} // tgen

//skip512 S78C6_nt

#else // __cplusplus

extern void _ZN8S78C6_ntC1Ev();
extern void _ZN8S78C6_ntD1Ev();
Name_Map name_map_S78C6_nt[] = {
  NSPAIR(_ZN8S78C6_ntC1Ev),
  NSPAIR(_ZN8S78C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
static Base_Class bases_S78C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern void _ZN8S78C6_ntD1Ev();
extern void _ZN8S78C6_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
static  VTBL_ENTRY vtc_S78C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI8S78C6_nt[];
VTBL_ENTRY *P__ZTI8S78C6_nt = _ZTI8S78C6_nt; 
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
Class_Descriptor cd_S78C6_nt = {  "S78C6_nt", // class name
  bases_S78C6_nt, 1,
  &(vtc_S78C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S78C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S78C6_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C9_nt  {
  int s78c9f0[4];
  char s78c9f1[9];
  void  mf78c9(); // _ZN8S78C9_nt6mf78c9Ev
};
//SIG(-1 S78C9_nt) C1{ m Fi[4] Fc[9]}


void  S78C9_nt ::mf78c9(){}

//skip512 S78C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C12_nt  {
  void *s78c12f0;
  int s78c12f1[2];
  void  mf78c12(); // _ZN9S78C12_nt7mf78c12Ev
};
//SIG(-1 S78C12_nt) C1{ m Fp Fi[2]}


void  S78C12_nt ::mf78c12(){}

//skip512 S78C12_nt

#else // __cplusplus

Class_Descriptor cd_S78C12_nt = {  "S78C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C11_nt  : S78C12_nt {
};
//SIG(-1 S78C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S78C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C11_nt = {  "S78C11_nt", // class name
  bases_S78C11_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C10_nt  : S78C11_nt {
};
//SIG(-1 S78C10_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S78C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C11_nt;
static Base_Class bases_S78C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C16  : S78C12_nt {
};
//SIG(-1 S78C16) C1{ BC2{ m Fp Fi[2]}}



static void Test_S78C16()
{
  extern Class_Descriptor cd_S78C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C16, buf);
    S78C16 &lv = *(new (buf) S78C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C16)");
    check_base_class_offset(lv, (S78C12_nt*), 0, "S78C16");
    test_class_info(&lv, &cd_S78C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C16(Test_S78C16, "S78C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C16 = {  "S78C16", // class name
  bases_S78C16, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C15  : S78C16 {
};
//SIG(-1 S78C15) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S78C15()
{
  extern Class_Descriptor cd_S78C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C15, buf);
    S78C15 &lv = *(new (buf) S78C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C15)");
    check_base_class_offset(lv, (S78C12_nt*)(S78C16*), 0, "S78C15");
    check_base_class_offset(lv, (S78C16*), 0, "S78C15");
    test_class_info(&lv, &cd_S78C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C15(Test_S78C15, "S78C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C16;
static Base_Class bases_S78C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C15 = {  "S78C15", // class name
  bases_S78C15, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C20  : S78C12_nt {
};
//SIG(-1 S78C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S78C20()
{
  extern Class_Descriptor cd_S78C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C20, buf);
    S78C20 &lv = *(new (buf) S78C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C20)");
    check_base_class_offset(lv, (S78C12_nt*), 0, "S78C20");
    test_class_info(&lv, &cd_S78C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C20(Test_S78C20, "S78C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C20 = {  "S78C20", // class name
  bases_S78C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C19  : S78C20 {
};
//SIG(-1 S78C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S78C19()
{
  extern Class_Descriptor cd_S78C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C19, buf);
    S78C19 &lv = *(new (buf) S78C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C19)");
    check_base_class_offset(lv, (S78C12_nt*)(S78C20*), 0, "S78C19");
    check_base_class_offset(lv, (S78C20*), 0, "S78C19");
    test_class_info(&lv, &cd_S78C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C19(Test_S78C19, "S78C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C20;
static Base_Class bases_S78C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C19 = {  "S78C19", // class name
  bases_S78C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C21_nt  {
  void *s78c21f0;
  ::S78C8_nt s78c21f1;
  void  mf78c21(); // _ZN9S78C21_nt7mf78c21Ev
};
//SIG(-1 S78C21_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S78C21_nt ::mf78c21(){}

//skip512 S78C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C5_nt  : S78C6_nt {
  ::S78C9_nt s78c5f0;
  int s78c5f1;
  unsigned int s78c5f2:1;
  unsigned int s78c5f3:1;
  unsigned int s78c5f4:1;
  unsigned int s78c5f5:1;
  ::S78C10_nt s78c5f6;
  ::S78C10_nt s78c5f7;
  void *s78c5f8;
  ::S78C15 s78c5f9;
  ::S78C15 s78c5f10;
  ::S78C15 s78c5f11;
  ::S78C19 s78c5f12;
  char s78c5f13;
  int s78c5f14;
  void *s78c5f15;
  ::S78C8_nt s78c5f16;
  ::S78C8_nt s78c5f17;
  ::S78C8_nt s78c5f18;
  ::S78C8_nt s78c5f19;
  ::S78C8_nt s78c5f20;
  ::S78C8_nt s78c5f21;
  ::S78C21_nt s78c5f22;
  ::S78C21_nt s78c5f23;
  ::S78C21_nt s78c5f24;
  ::S78C21_nt s78c5f25;
  ::S78C21_nt s78c5f26;
  ::S78C21_nt s78c5f27;
  ::S78C21_nt s78c5f28;
  ::S78C21_nt s78c5f29;
  ::S78C21_nt s78c5f30;
  ::S78C21_nt s78c5f31;
  virtual  ~S78C5_nt(); // _ZN8S78C5_ntD1Ev
  virtual void  v70(); // _ZN8S78C5_nt3v70Ev
  virtual void  v71(); // _ZN8S78C5_nt3v71Ev
  virtual void  v72(); // _ZN8S78C5_nt3v72Ev
  virtual void  v73(); // _ZN8S78C5_nt3v73Ev
  virtual void  v74(); // _ZN8S78C5_nt3v74Ev
  virtual void  v75(); // _ZN8S78C5_nt3v75Ev
  virtual void  v76(); // _ZN8S78C5_nt3v76Ev
  virtual void  v77(); // _ZN8S78C5_nt3v77Ev
  virtual void  v78(); // _ZN8S78C5_nt3v78Ev
  virtual void  v79(); // _ZN8S78C5_nt3v79Ev
  virtual void  v80(); // _ZN8S78C5_nt3v80Ev
  virtual void  v81(); // _ZN8S78C5_nt3v81Ev
  virtual void  v82(); // _ZN8S78C5_nt3v82Ev
  virtual void  v83(); // _ZN8S78C5_nt3v83Ev
  virtual void  v84(); // _ZN8S78C5_nt3v84Ev
  virtual void  v85(); // _ZN8S78C5_nt3v85Ev
  virtual void  v86(); // _ZN8S78C5_nt3v86Ev
  virtual void  v87(); // _ZN8S78C5_nt3v87Ev
  virtual void  v88(); // _ZN8S78C5_nt3v88Ev
  virtual void  v89(); // _ZN8S78C5_nt3v89Ev
  virtual void  v90(); // _ZN8S78C5_nt3v90Ev
  virtual void  v91(); // _ZN8S78C5_nt3v91Ev
  virtual void  v92(); // _ZN8S78C5_nt3v92Ev
  virtual void  v93(); // _ZN8S78C5_nt3v93Ev
  virtual void  v94(); // _ZN8S78C5_nt3v94Ev
  virtual void  v95(); // _ZN8S78C5_nt3v95Ev
  virtual void  v96(); // _ZN8S78C5_nt3v96Ev
  virtual void  v97(); // _ZN8S78C5_nt3v97Ev
  virtual void  v98(); // _ZN8S78C5_nt3v98Ev
  virtual void  v99(); // _ZN8S78C5_nt3v99Ev
  virtual void  v100(); // _ZN8S78C5_nt4v100Ev
  virtual void  v101(); // _ZN8S78C5_nt4v101Ev
  virtual void  v102(); // _ZN8S78C5_nt4v102Ev
  virtual void  v103(); // _ZN8S78C5_nt4v103Ev
  virtual void  v104(); // _ZN8S78C5_nt4v104Ev
  virtual void  v105(); // _ZN8S78C5_nt4v105Ev
  virtual void  v106(); // _ZN8S78C5_nt4v106Ev
  virtual void  v107(); // _ZN8S78C5_nt4v107Ev
  virtual void  v108(); // _ZN8S78C5_nt4v108Ev
  virtual void  v109(); // _ZN8S78C5_nt4v109Ev
  virtual void  v110(); // _ZN8S78C5_nt4v110Ev
  virtual void  v111(); // _ZN8S78C5_nt4v111Ev
  virtual void  v112(); // _ZN8S78C5_nt4v112Ev
  virtual void  v113(); // _ZN8S78C5_nt4v113Ev
  virtual void  v114(); // _ZN8S78C5_nt4v114Ev
  virtual void  v115(); // _ZN8S78C5_nt4v115Ev
  virtual void  v116(); // _ZN8S78C5_nt4v116Ev
  virtual void  v117(); // _ZN8S78C5_nt4v117Ev
  virtual void  v118(); // _ZN8S78C5_nt4v118Ev
  virtual void  v119(); // _ZN8S78C5_nt4v119Ev
  virtual void  v120(); // _ZN8S78C5_nt4v120Ev
  virtual void  v121(); // _ZN8S78C5_nt4v121Ev
  virtual void  v122(); // _ZN8S78C5_nt4v122Ev
  virtual void  v123(); // _ZN8S78C5_nt4v123Ev
  virtual void  v124(); // _ZN8S78C5_nt4v124Ev
  virtual void  v125(); // _ZN8S78C5_nt4v125Ev
  virtual void  v126(); // _ZN8S78C5_nt4v126Ev
  virtual void  v127(); // _ZN8S78C5_nt4v127Ev
  virtual void  v128(); // _ZN8S78C5_nt4v128Ev
  virtual void  v129(); // _ZN8S78C5_nt4v129Ev
  virtual void  v130(); // _ZN8S78C5_nt4v130Ev
  virtual void  v131(); // _ZN8S78C5_nt4v131Ev
  virtual void  v132(); // _ZN8S78C5_nt4v132Ev
  virtual void  v133(); // _ZN8S78C5_nt4v133Ev
  virtual void  v134(); // _ZN8S78C5_nt4v134Ev
  virtual void  v135(); // _ZN8S78C5_nt4v135Ev
  virtual void  v136(); // _ZN8S78C5_nt4v136Ev
  virtual void  v137(); // _ZN8S78C5_nt4v137Ev
  virtual void  v138(); // _ZN8S78C5_nt4v138Ev
  virtual void  v139(); // _ZN8S78C5_nt4v139Ev
  virtual void  v140(); // _ZN8S78C5_nt4v140Ev
  virtual void  v141(); // _ZN8S78C5_nt4v141Ev
  virtual void  v142(); // _ZN8S78C5_nt4v142Ev
  virtual void  v143(); // _ZN8S78C5_nt4v143Ev
  virtual void  v144(); // _ZN8S78C5_nt4v144Ev
  virtual void  v145(); // _ZN8S78C5_nt4v145Ev
  S78C5_nt(); // tgen
};
//SIG(-1 S78C5_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S78C5_nt ::~S78C5_nt(){ note_dtor("S78C5_nt", this);}
void  S78C5_nt ::v70(){vfunc_called(this, "_ZN8S78C5_nt3v70Ev");}
void  S78C5_nt ::v71(){vfunc_called(this, "_ZN8S78C5_nt3v71Ev");}
void  S78C5_nt ::v72(){vfunc_called(this, "_ZN8S78C5_nt3v72Ev");}
void  S78C5_nt ::v73(){vfunc_called(this, "_ZN8S78C5_nt3v73Ev");}
void  S78C5_nt ::v74(){vfunc_called(this, "_ZN8S78C5_nt3v74Ev");}
void  S78C5_nt ::v75(){vfunc_called(this, "_ZN8S78C5_nt3v75Ev");}
void  S78C5_nt ::v76(){vfunc_called(this, "_ZN8S78C5_nt3v76Ev");}
void  S78C5_nt ::v77(){vfunc_called(this, "_ZN8S78C5_nt3v77Ev");}
void  S78C5_nt ::v78(){vfunc_called(this, "_ZN8S78C5_nt3v78Ev");}
void  S78C5_nt ::v79(){vfunc_called(this, "_ZN8S78C5_nt3v79Ev");}
void  S78C5_nt ::v80(){vfunc_called(this, "_ZN8S78C5_nt3v80Ev");}
void  S78C5_nt ::v81(){vfunc_called(this, "_ZN8S78C5_nt3v81Ev");}
void  S78C5_nt ::v82(){vfunc_called(this, "_ZN8S78C5_nt3v82Ev");}
void  S78C5_nt ::v83(){vfunc_called(this, "_ZN8S78C5_nt3v83Ev");}
void  S78C5_nt ::v84(){vfunc_called(this, "_ZN8S78C5_nt3v84Ev");}
void  S78C5_nt ::v85(){vfunc_called(this, "_ZN8S78C5_nt3v85Ev");}
void  S78C5_nt ::v86(){vfunc_called(this, "_ZN8S78C5_nt3v86Ev");}
void  S78C5_nt ::v87(){vfunc_called(this, "_ZN8S78C5_nt3v87Ev");}
void  S78C5_nt ::v88(){vfunc_called(this, "_ZN8S78C5_nt3v88Ev");}
void  S78C5_nt ::v89(){vfunc_called(this, "_ZN8S78C5_nt3v89Ev");}
void  S78C5_nt ::v90(){vfunc_called(this, "_ZN8S78C5_nt3v90Ev");}
void  S78C5_nt ::v91(){vfunc_called(this, "_ZN8S78C5_nt3v91Ev");}
void  S78C5_nt ::v92(){vfunc_called(this, "_ZN8S78C5_nt3v92Ev");}
void  S78C5_nt ::v93(){vfunc_called(this, "_ZN8S78C5_nt3v93Ev");}
void  S78C5_nt ::v94(){vfunc_called(this, "_ZN8S78C5_nt3v94Ev");}
void  S78C5_nt ::v95(){vfunc_called(this, "_ZN8S78C5_nt3v95Ev");}
void  S78C5_nt ::v96(){vfunc_called(this, "_ZN8S78C5_nt3v96Ev");}
void  S78C5_nt ::v97(){vfunc_called(this, "_ZN8S78C5_nt3v97Ev");}
void  S78C5_nt ::v98(){vfunc_called(this, "_ZN8S78C5_nt3v98Ev");}
void  S78C5_nt ::v99(){vfunc_called(this, "_ZN8S78C5_nt3v99Ev");}
void  S78C5_nt ::v100(){vfunc_called(this, "_ZN8S78C5_nt4v100Ev");}
void  S78C5_nt ::v101(){vfunc_called(this, "_ZN8S78C5_nt4v101Ev");}
void  S78C5_nt ::v102(){vfunc_called(this, "_ZN8S78C5_nt4v102Ev");}
void  S78C5_nt ::v103(){vfunc_called(this, "_ZN8S78C5_nt4v103Ev");}
void  S78C5_nt ::v104(){vfunc_called(this, "_ZN8S78C5_nt4v104Ev");}
void  S78C5_nt ::v105(){vfunc_called(this, "_ZN8S78C5_nt4v105Ev");}
void  S78C5_nt ::v106(){vfunc_called(this, "_ZN8S78C5_nt4v106Ev");}
void  S78C5_nt ::v107(){vfunc_called(this, "_ZN8S78C5_nt4v107Ev");}
void  S78C5_nt ::v108(){vfunc_called(this, "_ZN8S78C5_nt4v108Ev");}
void  S78C5_nt ::v109(){vfunc_called(this, "_ZN8S78C5_nt4v109Ev");}
void  S78C5_nt ::v110(){vfunc_called(this, "_ZN8S78C5_nt4v110Ev");}
void  S78C5_nt ::v111(){vfunc_called(this, "_ZN8S78C5_nt4v111Ev");}
void  S78C5_nt ::v112(){vfunc_called(this, "_ZN8S78C5_nt4v112Ev");}
void  S78C5_nt ::v113(){vfunc_called(this, "_ZN8S78C5_nt4v113Ev");}
void  S78C5_nt ::v114(){vfunc_called(this, "_ZN8S78C5_nt4v114Ev");}
void  S78C5_nt ::v115(){vfunc_called(this, "_ZN8S78C5_nt4v115Ev");}
void  S78C5_nt ::v116(){vfunc_called(this, "_ZN8S78C5_nt4v116Ev");}
void  S78C5_nt ::v117(){vfunc_called(this, "_ZN8S78C5_nt4v117Ev");}
void  S78C5_nt ::v118(){vfunc_called(this, "_ZN8S78C5_nt4v118Ev");}
void  S78C5_nt ::v119(){vfunc_called(this, "_ZN8S78C5_nt4v119Ev");}
void  S78C5_nt ::v120(){vfunc_called(this, "_ZN8S78C5_nt4v120Ev");}
void  S78C5_nt ::v121(){vfunc_called(this, "_ZN8S78C5_nt4v121Ev");}
void  S78C5_nt ::v122(){vfunc_called(this, "_ZN8S78C5_nt4v122Ev");}
void  S78C5_nt ::v123(){vfunc_called(this, "_ZN8S78C5_nt4v123Ev");}
void  S78C5_nt ::v124(){vfunc_called(this, "_ZN8S78C5_nt4v124Ev");}
void  S78C5_nt ::v125(){vfunc_called(this, "_ZN8S78C5_nt4v125Ev");}
void  S78C5_nt ::v126(){vfunc_called(this, "_ZN8S78C5_nt4v126Ev");}
void  S78C5_nt ::v127(){vfunc_called(this, "_ZN8S78C5_nt4v127Ev");}
void  S78C5_nt ::v128(){vfunc_called(this, "_ZN8S78C5_nt4v128Ev");}
void  S78C5_nt ::v129(){vfunc_called(this, "_ZN8S78C5_nt4v129Ev");}
void  S78C5_nt ::v130(){vfunc_called(this, "_ZN8S78C5_nt4v130Ev");}
void  S78C5_nt ::v131(){vfunc_called(this, "_ZN8S78C5_nt4v131Ev");}
void  S78C5_nt ::v132(){vfunc_called(this, "_ZN8S78C5_nt4v132Ev");}
void  S78C5_nt ::v133(){vfunc_called(this, "_ZN8S78C5_nt4v133Ev");}
void  S78C5_nt ::v134(){vfunc_called(this, "_ZN8S78C5_nt4v134Ev");}
void  S78C5_nt ::v135(){vfunc_called(this, "_ZN8S78C5_nt4v135Ev");}
void  S78C5_nt ::v136(){vfunc_called(this, "_ZN8S78C5_nt4v136Ev");}
void  S78C5_nt ::v137(){vfunc_called(this, "_ZN8S78C5_nt4v137Ev");}
void  S78C5_nt ::v138(){vfunc_called(this, "_ZN8S78C5_nt4v138Ev");}
void  S78C5_nt ::v139(){vfunc_called(this, "_ZN8S78C5_nt4v139Ev");}
void  S78C5_nt ::v140(){vfunc_called(this, "_ZN8S78C5_nt4v140Ev");}
void  S78C5_nt ::v141(){vfunc_called(this, "_ZN8S78C5_nt4v141Ev");}
void  S78C5_nt ::v142(){vfunc_called(this, "_ZN8S78C5_nt4v142Ev");}
void  S78C5_nt ::v143(){vfunc_called(this, "_ZN8S78C5_nt4v143Ev");}
void  S78C5_nt ::v144(){vfunc_called(this, "_ZN8S78C5_nt4v144Ev");}
void  S78C5_nt ::v145(){vfunc_called(this, "_ZN8S78C5_nt4v145Ev");}
S78C5_nt ::S78C5_nt(){ note_ctor("S78C5_nt", this);} // tgen

//skip512 S78C5_nt

#else // __cplusplus

extern void _ZN8S78C5_ntC1Ev();
extern void _ZN8S78C5_ntD1Ev();
Name_Map name_map_S78C5_nt[] = {
  NSPAIR(_ZN8S78C5_ntC1Ev),
  NSPAIR(_ZN8S78C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
extern Class_Descriptor cd_S78C6_nt;
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
static Base_Class bases_S78C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S78C5_nt[];
extern void _ZN8S78C5_ntD1Ev();
extern void _ZN8S78C5_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
extern void _ZN8S78C5_nt3v70Ev();
extern void _ZN8S78C5_nt3v71Ev();
extern void _ZN8S78C5_nt3v72Ev();
extern void _ZN8S78C5_nt3v73Ev();
extern void _ZN8S78C5_nt3v74Ev();
extern void _ZN8S78C5_nt3v75Ev();
extern void _ZN8S78C5_nt3v76Ev();
extern void _ZN8S78C5_nt3v77Ev();
extern void _ZN8S78C5_nt3v78Ev();
extern void _ZN8S78C5_nt3v79Ev();
extern void _ZN8S78C5_nt3v80Ev();
extern void _ZN8S78C5_nt3v81Ev();
extern void _ZN8S78C5_nt3v82Ev();
extern void _ZN8S78C5_nt3v83Ev();
extern void _ZN8S78C5_nt3v84Ev();
extern void _ZN8S78C5_nt3v85Ev();
extern void _ZN8S78C5_nt3v86Ev();
extern void _ZN8S78C5_nt3v87Ev();
extern void _ZN8S78C5_nt3v88Ev();
extern void _ZN8S78C5_nt3v89Ev();
extern void _ZN8S78C5_nt3v90Ev();
extern void _ZN8S78C5_nt3v91Ev();
extern void _ZN8S78C5_nt3v92Ev();
extern void _ZN8S78C5_nt3v93Ev();
extern void _ZN8S78C5_nt3v94Ev();
extern void _ZN8S78C5_nt3v95Ev();
extern void _ZN8S78C5_nt3v96Ev();
extern void _ZN8S78C5_nt3v97Ev();
extern void _ZN8S78C5_nt3v98Ev();
extern void _ZN8S78C5_nt3v99Ev();
extern void _ZN8S78C5_nt4v100Ev();
extern void _ZN8S78C5_nt4v101Ev();
extern void _ZN8S78C5_nt4v102Ev();
extern void _ZN8S78C5_nt4v103Ev();
extern void _ZN8S78C5_nt4v104Ev();
extern void _ZN8S78C5_nt4v105Ev();
extern void _ZN8S78C5_nt4v106Ev();
extern void _ZN8S78C5_nt4v107Ev();
extern void _ZN8S78C5_nt4v108Ev();
extern void _ZN8S78C5_nt4v109Ev();
extern void _ZN8S78C5_nt4v110Ev();
extern void _ZN8S78C5_nt4v111Ev();
extern void _ZN8S78C5_nt4v112Ev();
extern void _ZN8S78C5_nt4v113Ev();
extern void _ZN8S78C5_nt4v114Ev();
extern void _ZN8S78C5_nt4v115Ev();
extern void _ZN8S78C5_nt4v116Ev();
extern void _ZN8S78C5_nt4v117Ev();
extern void _ZN8S78C5_nt4v118Ev();
extern void _ZN8S78C5_nt4v119Ev();
extern void _ZN8S78C5_nt4v120Ev();
extern void _ZN8S78C5_nt4v121Ev();
extern void _ZN8S78C5_nt4v122Ev();
extern void _ZN8S78C5_nt4v123Ev();
extern void _ZN8S78C5_nt4v124Ev();
extern void _ZN8S78C5_nt4v125Ev();
extern void _ZN8S78C5_nt4v126Ev();
extern void _ZN8S78C5_nt4v127Ev();
extern void _ZN8S78C5_nt4v128Ev();
extern void _ZN8S78C5_nt4v129Ev();
extern void _ZN8S78C5_nt4v130Ev();
extern void _ZN8S78C5_nt4v131Ev();
extern void _ZN8S78C5_nt4v132Ev();
extern void _ZN8S78C5_nt4v133Ev();
extern void _ZN8S78C5_nt4v134Ev();
extern void _ZN8S78C5_nt4v135Ev();
extern void _ZN8S78C5_nt4v136Ev();
extern void _ZN8S78C5_nt4v137Ev();
extern void _ZN8S78C5_nt4v138Ev();
extern void _ZN8S78C5_nt4v139Ev();
extern void _ZN8S78C5_nt4v140Ev();
extern void _ZN8S78C5_nt4v141Ev();
extern void _ZN8S78C5_nt4v142Ev();
extern void _ZN8S78C5_nt4v143Ev();
extern void _ZN8S78C5_nt4v144Ev();
extern void _ZN8S78C5_nt4v145Ev();
static  VTBL_ENTRY vtc_S78C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v145Ev,
};
extern VTBL_ENTRY _ZTI8S78C5_nt[];
VTBL_ENTRY *P__ZTI8S78C5_nt = _ZTI8S78C5_nt; 
extern  VTBL_ENTRY _ZTV8S78C5_nt[];
Class_Descriptor cd_S78C5_nt = {  "S78C5_nt", // class name
  bases_S78C5_nt, 2,
  &(vtc_S78C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI8S78C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S78C5_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C23_nt  {
  int s78c23f0[4];
  void  mf78c23(); // _ZN9S78C23_nt7mf78c23Ev
};
//SIG(-1 S78C23_nt) C1{ m Fi[4]}


void  S78C23_nt ::mf78c23(){}

//skip512 S78C23_nt

#else // __cplusplus

Class_Descriptor cd_S78C23_nt = {  "S78C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C22_nt  : S78C23_nt {
};
//SIG(-1 S78C22_nt) C1{ BC2{ m Fi[4]}}



//skip512 S78C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C23_nt;
static Base_Class bases_S78C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C24_nt  {
  ::S78C8_nt s78c24f0;
  void *s78c24f1;
  ::S78C22_nt s78c24f2;
  void *s78c24f3;
  void  mf78c24(); // _ZN9S78C24_nt7mf78c24Ev
};
//SIG(-1 S78C24_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S78C24_nt ::mf78c24(){}

//skip512 S78C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C26_nt  {
  void *s78c26f0[8];
  char s78c26f1[4];
  void  mf78c26(); // _ZN9S78C26_nt7mf78c26Ev
};
//SIG(-1 S78C26_nt) C1{ m Fp[8] Fc[4]}


void  S78C26_nt ::mf78c26(){}

//skip512 S78C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C28_nt  {
  int s78c28f0[4];
  char s78c28f1[4];
  void  mf78c28(); // _ZN9S78C28_nt7mf78c28Ev
};
//SIG(-1 S78C28_nt) C1{ m Fi[4] Fc[4]}


void  S78C28_nt ::mf78c28(){}

//skip512 S78C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C27_nt  {
  void *s78c27f0[5];
  ::S78C28_nt s78c27f1;
  unsigned int s78c27f2:1;
  unsigned int s78c27f3:1;
  int s78c27f4;
  char s78c27f5[8];
  void  mf78c27(); // _ZN9S78C27_nt7mf78c27Ev
};
//SIG(-1 S78C27_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S78C27_nt ::mf78c27(){}

//skip512 S78C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C31_nt  {
  int s78c31f0[3];
  void  mf78c31(); // _ZN9S78C31_nt7mf78c31Ev
};
//SIG(-1 S78C31_nt) C1{ m Fi[3]}


void  S78C31_nt ::mf78c31(){}

//skip512 S78C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C32_nt  {
  void  mf78c32(); // _ZN9S78C32_nt7mf78c32Ev
};
//SIG(-1 S78C32_nt) C1{ m}


void  S78C32_nt ::mf78c32(){}

//skip512 S78C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C34_nt  {
  int s78c34f0[2];
  char s78c34f1[2];
  void  mf78c34(); // _ZN9S78C34_nt7mf78c34Ev
};
//SIG(-1 S78C34_nt) C1{ m Fi[2] Fc[2]}


void  S78C34_nt ::mf78c34(){}

//skip512 S78C34_nt

#else // __cplusplus

Class_Descriptor cd_S78C34_nt = {  "S78C34_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C33_nt  : S78C34_nt {
  int s78c33f0;
};
//SIG(-1 S78C33_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S78C33_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C34_nt;
static Base_Class bases_S78C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C30_nt  {
  ::S78C31_nt s78c30f0;
  ::S78C32_nt s78c30f1;
  ::S78C33_nt s78c30f2;
  char s78c30f3;
  void  mf78c30(); // _ZN9S78C30_nt7mf78c30Ev
};
//SIG(-1 S78C30_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S78C30_nt ::mf78c30(){}

//skip512 S78C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C38_nt  {
  void *s78c38f0[2];
  void  mf78c38(); // _ZN9S78C38_nt7mf78c38Ev
};
//SIG(-1 S78C38_nt) C1{ m Fp[2]}


void  S78C38_nt ::mf78c38(){}

//skip512 S78C38_nt

#else // __cplusplus

Class_Descriptor cd_S78C38_nt = {  "S78C38_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C37_nt  : S78C38_nt {
};
//SIG(-1 S78C37_nt) C1{ BC2{ m Fp[2]}}



//skip512 S78C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C38_nt;
static Base_Class bases_S78C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C41  : S78C12_nt {
};
//SIG(-1 S78C41) C1{ BC2{ m Fp Fi[2]}}



static void Test_S78C41()
{
  extern Class_Descriptor cd_S78C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C41, buf);
    S78C41 &lv = *(new (buf) S78C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C41)");
    check_base_class_offset(lv, (S78C12_nt*), 0, "S78C41");
    test_class_info(&lv, &cd_S78C41);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C41(Test_S78C41, "S78C41", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C41 = {  "S78C41", // class name
  bases_S78C41, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C40  : S78C41 {
};
//SIG(-1 S78C40) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S78C40()
{
  extern Class_Descriptor cd_S78C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C40, buf);
    S78C40 &lv = *(new (buf) S78C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C40)");
    check_base_class_offset(lv, (S78C12_nt*)(S78C41*), 0, "S78C40");
    check_base_class_offset(lv, (S78C41*), 0, "S78C40");
    test_class_info(&lv, &cd_S78C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C40(Test_S78C40, "S78C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C41;
static Base_Class bases_S78C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C40 = {  "S78C40", // class name
  bases_S78C40, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C39_nt  : S78C40 {
};
//SIG(-1 S78C39_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S78C39_nt

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C41;
extern Class_Descriptor cd_S78C40;
static Base_Class bases_S78C39_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S78C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C36_nt  {
  ::S78C37_nt s78c36f0;
  char s78c36f1;
  ::S78C39_nt s78c36f2;
  int s78c36f3;
  ::S78C8_nt s78c36f4;
  ::S78C8_nt s78c36f5;
  void *s78c36f6;
  void  mf78c36(); // _ZN9S78C36_nt7mf78c36Ev
};
//SIG(-1 S78C36_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S78C36_nt ::mf78c36(){}

//skip512 S78C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C45  : S78C12_nt {
};
//SIG(-1 S78C45) C1{ BC2{ m Fp Fi[2]}}



static void Test_S78C45()
{
  extern Class_Descriptor cd_S78C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C45, buf);
    S78C45 &lv = *(new (buf) S78C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C45)");
    check_base_class_offset(lv, (S78C12_nt*), 0, "S78C45");
    test_class_info(&lv, &cd_S78C45);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C45(Test_S78C45, "S78C45", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C45 = {  "S78C45", // class name
  bases_S78C45, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C44  : S78C45 {
};
//SIG(-1 S78C44) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S78C44()
{
  extern Class_Descriptor cd_S78C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C44, buf);
    S78C44 &lv = *(new (buf) S78C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C44)");
    check_base_class_offset(lv, (S78C12_nt*)(S78C45*), 0, "S78C44");
    check_base_class_offset(lv, (S78C45*), 0, "S78C44");
    test_class_info(&lv, &cd_S78C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C44(Test_S78C44, "S78C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C45;
static Base_Class bases_S78C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C45,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C44 = {  "S78C44", // class name
  bases_S78C44, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C4_nt  : S78C5_nt {
  ::S78C22_nt s78c4f0;
  ::S78C8_nt s78c4f1;
  void *s78c4f2[2];
  ::S78C24_nt s78c4f3;
  ::S78C26_nt s78c4f4;
  int s78c4f5;
  ::S78C27_nt s78c4f6;
  int s78c4f7[4];
  ::S78C8_nt s78c4f8[4];
  ::S78C30_nt s78c4f9;
  ::S78C31_nt s78c4f10;
  int s78c4f11;
  ::S78C36_nt s78c4f12;
  ::S78C36_nt s78c4f13;
  void *s78c4f14;
  ::S78C31_nt s78c4f15;
  ::S78C19 s78c4f16;
  ::S78C44 s78c4f17;
  unsigned int s78c4f18:1;
  unsigned int s78c4f19:1;
  unsigned int s78c4f20:1;
  ::S78C32_nt s78c4f21;
  ::S78C21_nt s78c4f22;
  ::S78C21_nt s78c4f23;
  ::S78C21_nt s78c4f24;
  ::S78C21_nt s78c4f25;
  ::S78C21_nt s78c4f26;
  ::S78C21_nt s78c4f27;
  ::S78C21_nt s78c4f28;
  ::S78C21_nt s78c4f29;
  ::S78C21_nt s78c4f30;
  ::S78C21_nt s78c4f31;
  ::S78C21_nt s78c4f32;
  ::S78C21_nt s78c4f33;
  ::S78C21_nt s78c4f34;
  virtual  ~S78C4_nt(); // _ZN8S78C4_ntD1Ev
  virtual void  v146(); // _ZN8S78C4_nt4v146Ev
  virtual void  v147(); // _ZN8S78C4_nt4v147Ev
  virtual void  v148(); // _ZN8S78C4_nt4v148Ev
  virtual void  v149(); // _ZN8S78C4_nt4v149Ev
  virtual void  v150(); // _ZN8S78C4_nt4v150Ev
  virtual void  v151(); // _ZN8S78C4_nt4v151Ev
  virtual void  v152(); // _ZN8S78C4_nt4v152Ev
  virtual void  v153(); // _ZN8S78C4_nt4v153Ev
  virtual void  v154(); // _ZN8S78C4_nt4v154Ev
  virtual void  v155(); // _ZN8S78C4_nt4v155Ev
  virtual void  v156(); // _ZN8S78C4_nt4v156Ev
  virtual void  v157(); // _ZN8S78C4_nt4v157Ev
  virtual void  v158(); // _ZN8S78C4_nt4v158Ev
  virtual void  v159(); // _ZN8S78C4_nt4v159Ev
  virtual void  v160(); // _ZN8S78C4_nt4v160Ev
  virtual void  v161(); // _ZN8S78C4_nt4v161Ev
  virtual void  v162(); // _ZN8S78C4_nt4v162Ev
  virtual void  v163(); // _ZN8S78C4_nt4v163Ev
  virtual void  v164(); // _ZN8S78C4_nt4v164Ev
  virtual void  v165(); // _ZN8S78C4_nt4v165Ev
  virtual void  v166(); // _ZN8S78C4_nt4v166Ev
  virtual void  v167(); // _ZN8S78C4_nt4v167Ev
  virtual void  v168(); // _ZN8S78C4_nt4v168Ev
  virtual void  v169(); // _ZN8S78C4_nt4v169Ev
  virtual void  v170(); // _ZN8S78C4_nt4v170Ev
  virtual void  v171(); // _ZN8S78C4_nt4v171Ev
  virtual void  v172(); // _ZN8S78C4_nt4v172Ev
  virtual void  v173(); // _ZN8S78C4_nt4v173Ev
  virtual void  v174(); // _ZN8S78C4_nt4v174Ev
  virtual void  v175(); // _ZN8S78C4_nt4v175Ev
  virtual void  v176(); // _ZN8S78C4_nt4v176Ev
  virtual void  v177(); // _ZN8S78C4_nt4v177Ev
  virtual void  v178(); // _ZN8S78C4_nt4v178Ev
  virtual void  v179(); // _ZN8S78C4_nt4v179Ev
  virtual void  v180(); // _ZN8S78C4_nt4v180Ev
  virtual void  v181(); // _ZN8S78C4_nt4v181Ev
  virtual void  v182(); // _ZN8S78C4_nt4v182Ev
  virtual void  v183(); // _ZN8S78C4_nt4v183Ev
  virtual void  v184(); // _ZN8S78C4_nt4v184Ev
  virtual void  v185(); // _ZN8S78C4_nt4v185Ev
  virtual void  v186(); // _ZN8S78C4_nt4v186Ev
  virtual void  v187(); // _ZN8S78C4_nt4v187Ev
  virtual void  v188(); // _ZN8S78C4_nt4v188Ev
  virtual void  v189(); // _ZN8S78C4_nt4v189Ev
  virtual void  v190(); // _ZN8S78C4_nt4v190Ev
  virtual void  v191(); // _ZN8S78C4_nt4v191Ev
  virtual void  v192(); // _ZN8S78C4_nt4v192Ev
  virtual void  v193(); // _ZN8S78C4_nt4v193Ev
  virtual void  v194(); // _ZN8S78C4_nt4v194Ev
  virtual void  v195(); // _ZN8S78C4_nt4v195Ev
  virtual void  v196(); // _ZN8S78C4_nt4v196Ev
  virtual void  v197(); // _ZN8S78C4_nt4v197Ev
  virtual void  v198(); // _ZN8S78C4_nt4v198Ev
  virtual void  v199(); // _ZN8S78C4_nt4v199Ev
  virtual void  v200(); // _ZN8S78C4_nt4v200Ev
  virtual void  v201(); // _ZN8S78C4_nt4v201Ev
  virtual void  v202(); // _ZN8S78C4_nt4v202Ev
  virtual void  v203(); // _ZN8S78C4_nt4v203Ev
  virtual void  v204(); // _ZN8S78C4_nt4v204Ev
  virtual void  v205(); // _ZN8S78C4_nt4v205Ev
  virtual void  v206(); // _ZN8S78C4_nt4v206Ev
  virtual void  v207(); // _ZN8S78C4_nt4v207Ev
  virtual void  v208(); // _ZN8S78C4_nt4v208Ev
  virtual void  v209(); // _ZN8S78C4_nt4v209Ev
  virtual void  v210(); // _ZN8S78C4_nt4v210Ev
  virtual void  v211(); // _ZN8S78C4_nt4v211Ev
  virtual void  v212(); // _ZN8S78C4_nt4v212Ev
  virtual void  v213(); // _ZN8S78C4_nt4v213Ev
  virtual void  v214(); // _ZN8S78C4_nt4v214Ev
  S78C4_nt(); // tgen
};
//SIG(-1 S78C4_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S78C4_nt ::~S78C4_nt(){ note_dtor("S78C4_nt", this);}
void  S78C4_nt ::v146(){vfunc_called(this, "_ZN8S78C4_nt4v146Ev");}
void  S78C4_nt ::v147(){vfunc_called(this, "_ZN8S78C4_nt4v147Ev");}
void  S78C4_nt ::v148(){vfunc_called(this, "_ZN8S78C4_nt4v148Ev");}
void  S78C4_nt ::v149(){vfunc_called(this, "_ZN8S78C4_nt4v149Ev");}
void  S78C4_nt ::v150(){vfunc_called(this, "_ZN8S78C4_nt4v150Ev");}
void  S78C4_nt ::v151(){vfunc_called(this, "_ZN8S78C4_nt4v151Ev");}
void  S78C4_nt ::v152(){vfunc_called(this, "_ZN8S78C4_nt4v152Ev");}
void  S78C4_nt ::v153(){vfunc_called(this, "_ZN8S78C4_nt4v153Ev");}
void  S78C4_nt ::v154(){vfunc_called(this, "_ZN8S78C4_nt4v154Ev");}
void  S78C4_nt ::v155(){vfunc_called(this, "_ZN8S78C4_nt4v155Ev");}
void  S78C4_nt ::v156(){vfunc_called(this, "_ZN8S78C4_nt4v156Ev");}
void  S78C4_nt ::v157(){vfunc_called(this, "_ZN8S78C4_nt4v157Ev");}
void  S78C4_nt ::v158(){vfunc_called(this, "_ZN8S78C4_nt4v158Ev");}
void  S78C4_nt ::v159(){vfunc_called(this, "_ZN8S78C4_nt4v159Ev");}
void  S78C4_nt ::v160(){vfunc_called(this, "_ZN8S78C4_nt4v160Ev");}
void  S78C4_nt ::v161(){vfunc_called(this, "_ZN8S78C4_nt4v161Ev");}
void  S78C4_nt ::v162(){vfunc_called(this, "_ZN8S78C4_nt4v162Ev");}
void  S78C4_nt ::v163(){vfunc_called(this, "_ZN8S78C4_nt4v163Ev");}
void  S78C4_nt ::v164(){vfunc_called(this, "_ZN8S78C4_nt4v164Ev");}
void  S78C4_nt ::v165(){vfunc_called(this, "_ZN8S78C4_nt4v165Ev");}
void  S78C4_nt ::v166(){vfunc_called(this, "_ZN8S78C4_nt4v166Ev");}
void  S78C4_nt ::v167(){vfunc_called(this, "_ZN8S78C4_nt4v167Ev");}
void  S78C4_nt ::v168(){vfunc_called(this, "_ZN8S78C4_nt4v168Ev");}
void  S78C4_nt ::v169(){vfunc_called(this, "_ZN8S78C4_nt4v169Ev");}
void  S78C4_nt ::v170(){vfunc_called(this, "_ZN8S78C4_nt4v170Ev");}
void  S78C4_nt ::v171(){vfunc_called(this, "_ZN8S78C4_nt4v171Ev");}
void  S78C4_nt ::v172(){vfunc_called(this, "_ZN8S78C4_nt4v172Ev");}
void  S78C4_nt ::v173(){vfunc_called(this, "_ZN8S78C4_nt4v173Ev");}
void  S78C4_nt ::v174(){vfunc_called(this, "_ZN8S78C4_nt4v174Ev");}
void  S78C4_nt ::v175(){vfunc_called(this, "_ZN8S78C4_nt4v175Ev");}
void  S78C4_nt ::v176(){vfunc_called(this, "_ZN8S78C4_nt4v176Ev");}
void  S78C4_nt ::v177(){vfunc_called(this, "_ZN8S78C4_nt4v177Ev");}
void  S78C4_nt ::v178(){vfunc_called(this, "_ZN8S78C4_nt4v178Ev");}
void  S78C4_nt ::v179(){vfunc_called(this, "_ZN8S78C4_nt4v179Ev");}
void  S78C4_nt ::v180(){vfunc_called(this, "_ZN8S78C4_nt4v180Ev");}
void  S78C4_nt ::v181(){vfunc_called(this, "_ZN8S78C4_nt4v181Ev");}
void  S78C4_nt ::v182(){vfunc_called(this, "_ZN8S78C4_nt4v182Ev");}
void  S78C4_nt ::v183(){vfunc_called(this, "_ZN8S78C4_nt4v183Ev");}
void  S78C4_nt ::v184(){vfunc_called(this, "_ZN8S78C4_nt4v184Ev");}
void  S78C4_nt ::v185(){vfunc_called(this, "_ZN8S78C4_nt4v185Ev");}
void  S78C4_nt ::v186(){vfunc_called(this, "_ZN8S78C4_nt4v186Ev");}
void  S78C4_nt ::v187(){vfunc_called(this, "_ZN8S78C4_nt4v187Ev");}
void  S78C4_nt ::v188(){vfunc_called(this, "_ZN8S78C4_nt4v188Ev");}
void  S78C4_nt ::v189(){vfunc_called(this, "_ZN8S78C4_nt4v189Ev");}
void  S78C4_nt ::v190(){vfunc_called(this, "_ZN8S78C4_nt4v190Ev");}
void  S78C4_nt ::v191(){vfunc_called(this, "_ZN8S78C4_nt4v191Ev");}
void  S78C4_nt ::v192(){vfunc_called(this, "_ZN8S78C4_nt4v192Ev");}
void  S78C4_nt ::v193(){vfunc_called(this, "_ZN8S78C4_nt4v193Ev");}
void  S78C4_nt ::v194(){vfunc_called(this, "_ZN8S78C4_nt4v194Ev");}
void  S78C4_nt ::v195(){vfunc_called(this, "_ZN8S78C4_nt4v195Ev");}
void  S78C4_nt ::v196(){vfunc_called(this, "_ZN8S78C4_nt4v196Ev");}
void  S78C4_nt ::v197(){vfunc_called(this, "_ZN8S78C4_nt4v197Ev");}
void  S78C4_nt ::v198(){vfunc_called(this, "_ZN8S78C4_nt4v198Ev");}
void  S78C4_nt ::v199(){vfunc_called(this, "_ZN8S78C4_nt4v199Ev");}
void  S78C4_nt ::v200(){vfunc_called(this, "_ZN8S78C4_nt4v200Ev");}
void  S78C4_nt ::v201(){vfunc_called(this, "_ZN8S78C4_nt4v201Ev");}
void  S78C4_nt ::v202(){vfunc_called(this, "_ZN8S78C4_nt4v202Ev");}
void  S78C4_nt ::v203(){vfunc_called(this, "_ZN8S78C4_nt4v203Ev");}
void  S78C4_nt ::v204(){vfunc_called(this, "_ZN8S78C4_nt4v204Ev");}
void  S78C4_nt ::v205(){vfunc_called(this, "_ZN8S78C4_nt4v205Ev");}
void  S78C4_nt ::v206(){vfunc_called(this, "_ZN8S78C4_nt4v206Ev");}
void  S78C4_nt ::v207(){vfunc_called(this, "_ZN8S78C4_nt4v207Ev");}
void  S78C4_nt ::v208(){vfunc_called(this, "_ZN8S78C4_nt4v208Ev");}
void  S78C4_nt ::v209(){vfunc_called(this, "_ZN8S78C4_nt4v209Ev");}
void  S78C4_nt ::v210(){vfunc_called(this, "_ZN8S78C4_nt4v210Ev");}
void  S78C4_nt ::v211(){vfunc_called(this, "_ZN8S78C4_nt4v211Ev");}
void  S78C4_nt ::v212(){vfunc_called(this, "_ZN8S78C4_nt4v212Ev");}
void  S78C4_nt ::v213(){vfunc_called(this, "_ZN8S78C4_nt4v213Ev");}
void  S78C4_nt ::v214(){vfunc_called(this, "_ZN8S78C4_nt4v214Ev");}
S78C4_nt ::S78C4_nt(){ note_ctor("S78C4_nt", this);} // tgen

//skip512 S78C4_nt

#else // __cplusplus

extern void _ZN8S78C4_ntC1Ev();
extern void _ZN8S78C4_ntD1Ev();
Name_Map name_map_S78C4_nt[] = {
  NSPAIR(_ZN8S78C4_ntC1Ev),
  NSPAIR(_ZN8S78C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
extern Class_Descriptor cd_S78C6_nt;
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
extern Class_Descriptor cd_S78C5_nt;
extern VTBL_ENTRY _ZTI8S78C5_nt[];
extern  VTBL_ENTRY _ZTV8S78C5_nt[];
static Base_Class bases_S78C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S78C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S78C4_nt[];
extern void _ZN8S78C4_ntD1Ev();
extern void _ZN8S78C4_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
extern void _ZN8S78C5_nt3v70Ev();
extern void _ZN8S78C5_nt3v71Ev();
extern void _ZN8S78C5_nt3v72Ev();
extern void _ZN8S78C5_nt3v73Ev();
extern void _ZN8S78C5_nt3v74Ev();
extern void _ZN8S78C5_nt3v75Ev();
extern void _ZN8S78C5_nt3v76Ev();
extern void _ZN8S78C5_nt3v77Ev();
extern void _ZN8S78C5_nt3v78Ev();
extern void _ZN8S78C5_nt3v79Ev();
extern void _ZN8S78C5_nt3v80Ev();
extern void _ZN8S78C5_nt3v81Ev();
extern void _ZN8S78C5_nt3v82Ev();
extern void _ZN8S78C5_nt3v83Ev();
extern void _ZN8S78C5_nt3v84Ev();
extern void _ZN8S78C5_nt3v85Ev();
extern void _ZN8S78C5_nt3v86Ev();
extern void _ZN8S78C5_nt3v87Ev();
extern void _ZN8S78C5_nt3v88Ev();
extern void _ZN8S78C5_nt3v89Ev();
extern void _ZN8S78C5_nt3v90Ev();
extern void _ZN8S78C5_nt3v91Ev();
extern void _ZN8S78C5_nt3v92Ev();
extern void _ZN8S78C5_nt3v93Ev();
extern void _ZN8S78C5_nt3v94Ev();
extern void _ZN8S78C5_nt3v95Ev();
extern void _ZN8S78C5_nt3v96Ev();
extern void _ZN8S78C5_nt3v97Ev();
extern void _ZN8S78C5_nt3v98Ev();
extern void _ZN8S78C5_nt3v99Ev();
extern void _ZN8S78C5_nt4v100Ev();
extern void _ZN8S78C5_nt4v101Ev();
extern void _ZN8S78C5_nt4v102Ev();
extern void _ZN8S78C5_nt4v103Ev();
extern void _ZN8S78C5_nt4v104Ev();
extern void _ZN8S78C5_nt4v105Ev();
extern void _ZN8S78C5_nt4v106Ev();
extern void _ZN8S78C5_nt4v107Ev();
extern void _ZN8S78C5_nt4v108Ev();
extern void _ZN8S78C5_nt4v109Ev();
extern void _ZN8S78C5_nt4v110Ev();
extern void _ZN8S78C5_nt4v111Ev();
extern void _ZN8S78C5_nt4v112Ev();
extern void _ZN8S78C5_nt4v113Ev();
extern void _ZN8S78C5_nt4v114Ev();
extern void _ZN8S78C5_nt4v115Ev();
extern void _ZN8S78C5_nt4v116Ev();
extern void _ZN8S78C5_nt4v117Ev();
extern void _ZN8S78C5_nt4v118Ev();
extern void _ZN8S78C5_nt4v119Ev();
extern void _ZN8S78C5_nt4v120Ev();
extern void _ZN8S78C5_nt4v121Ev();
extern void _ZN8S78C5_nt4v122Ev();
extern void _ZN8S78C5_nt4v123Ev();
extern void _ZN8S78C5_nt4v124Ev();
extern void _ZN8S78C5_nt4v125Ev();
extern void _ZN8S78C5_nt4v126Ev();
extern void _ZN8S78C5_nt4v127Ev();
extern void _ZN8S78C5_nt4v128Ev();
extern void _ZN8S78C5_nt4v129Ev();
extern void _ZN8S78C5_nt4v130Ev();
extern void _ZN8S78C5_nt4v131Ev();
extern void _ZN8S78C5_nt4v132Ev();
extern void _ZN8S78C5_nt4v133Ev();
extern void _ZN8S78C5_nt4v134Ev();
extern void _ZN8S78C5_nt4v135Ev();
extern void _ZN8S78C5_nt4v136Ev();
extern void _ZN8S78C5_nt4v137Ev();
extern void _ZN8S78C5_nt4v138Ev();
extern void _ZN8S78C5_nt4v139Ev();
extern void _ZN8S78C5_nt4v140Ev();
extern void _ZN8S78C5_nt4v141Ev();
extern void _ZN8S78C5_nt4v142Ev();
extern void _ZN8S78C5_nt4v143Ev();
extern void _ZN8S78C5_nt4v144Ev();
extern void _ZN8S78C5_nt4v145Ev();
extern void _ZN8S78C4_nt4v146Ev();
extern void _ZN8S78C4_nt4v147Ev();
extern void _ZN8S78C4_nt4v148Ev();
extern void _ZN8S78C4_nt4v149Ev();
extern void _ZN8S78C4_nt4v150Ev();
extern void _ZN8S78C4_nt4v151Ev();
extern void _ZN8S78C4_nt4v152Ev();
extern void _ZN8S78C4_nt4v153Ev();
extern void _ZN8S78C4_nt4v154Ev();
extern void _ZN8S78C4_nt4v155Ev();
extern void _ZN8S78C4_nt4v156Ev();
extern void _ZN8S78C4_nt4v157Ev();
extern void _ZN8S78C4_nt4v158Ev();
extern void _ZN8S78C4_nt4v159Ev();
extern void _ZN8S78C4_nt4v160Ev();
extern void _ZN8S78C4_nt4v161Ev();
extern void _ZN8S78C4_nt4v162Ev();
extern void _ZN8S78C4_nt4v163Ev();
extern void _ZN8S78C4_nt4v164Ev();
extern void _ZN8S78C4_nt4v165Ev();
extern void _ZN8S78C4_nt4v166Ev();
extern void _ZN8S78C4_nt4v167Ev();
extern void _ZN8S78C4_nt4v168Ev();
extern void _ZN8S78C4_nt4v169Ev();
extern void _ZN8S78C4_nt4v170Ev();
extern void _ZN8S78C4_nt4v171Ev();
extern void _ZN8S78C4_nt4v172Ev();
extern void _ZN8S78C4_nt4v173Ev();
extern void _ZN8S78C4_nt4v174Ev();
extern void _ZN8S78C4_nt4v175Ev();
extern void _ZN8S78C4_nt4v176Ev();
extern void _ZN8S78C4_nt4v177Ev();
extern void _ZN8S78C4_nt4v178Ev();
extern void _ZN8S78C4_nt4v179Ev();
extern void _ZN8S78C4_nt4v180Ev();
extern void _ZN8S78C4_nt4v181Ev();
extern void _ZN8S78C4_nt4v182Ev();
extern void _ZN8S78C4_nt4v183Ev();
extern void _ZN8S78C4_nt4v184Ev();
extern void _ZN8S78C4_nt4v185Ev();
extern void _ZN8S78C4_nt4v186Ev();
extern void _ZN8S78C4_nt4v187Ev();
extern void _ZN8S78C4_nt4v188Ev();
extern void _ZN8S78C4_nt4v189Ev();
extern void _ZN8S78C4_nt4v190Ev();
extern void _ZN8S78C4_nt4v191Ev();
extern void _ZN8S78C4_nt4v192Ev();
extern void _ZN8S78C4_nt4v193Ev();
extern void _ZN8S78C4_nt4v194Ev();
extern void _ZN8S78C4_nt4v195Ev();
extern void _ZN8S78C4_nt4v196Ev();
extern void _ZN8S78C4_nt4v197Ev();
extern void _ZN8S78C4_nt4v198Ev();
extern void _ZN8S78C4_nt4v199Ev();
extern void _ZN8S78C4_nt4v200Ev();
extern void _ZN8S78C4_nt4v201Ev();
extern void _ZN8S78C4_nt4v202Ev();
extern void _ZN8S78C4_nt4v203Ev();
extern void _ZN8S78C4_nt4v204Ev();
extern void _ZN8S78C4_nt4v205Ev();
extern void _ZN8S78C4_nt4v206Ev();
extern void _ZN8S78C4_nt4v207Ev();
extern void _ZN8S78C4_nt4v208Ev();
extern void _ZN8S78C4_nt4v209Ev();
extern void _ZN8S78C4_nt4v210Ev();
extern void _ZN8S78C4_nt4v211Ev();
extern void _ZN8S78C4_nt4v212Ev();
extern void _ZN8S78C4_nt4v213Ev();
extern void _ZN8S78C4_nt4v214Ev();
static  VTBL_ENTRY vtc_S78C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C4_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v214Ev,
};
extern VTBL_ENTRY _ZTI8S78C4_nt[];
VTBL_ENTRY *P__ZTI8S78C4_nt = _ZTI8S78C4_nt; 
extern  VTBL_ENTRY _ZTV8S78C4_nt[];
Class_Descriptor cd_S78C4_nt = {  "S78C4_nt", // class name
  bases_S78C4_nt, 3,
  &(vtc_S78C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI8S78C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S78C4_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C3_nt  : S78C4_nt {
  unsigned int s78c3f0:1;
  void *s78c3f1;
  virtual  ~S78C3_nt(); // _ZN8S78C3_ntD1Ev
  virtual void  v215(); // _ZN8S78C3_nt4v215Ev
  virtual void  v216(); // _ZN8S78C3_nt4v216Ev
  virtual void  v217(); // _ZN8S78C3_nt4v217Ev
  virtual void  v218(); // _ZN8S78C3_nt4v218Ev
  virtual void  v219(); // _ZN8S78C3_nt4v219Ev
  virtual void  v220(); // _ZN8S78C3_nt4v220Ev
  S78C3_nt(); // tgen
};
//SIG(-1 S78C3_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 Fi:1 Fp}


 S78C3_nt ::~S78C3_nt(){ note_dtor("S78C3_nt", this);}
void  S78C3_nt ::v215(){vfunc_called(this, "_ZN8S78C3_nt4v215Ev");}
void  S78C3_nt ::v216(){vfunc_called(this, "_ZN8S78C3_nt4v216Ev");}
void  S78C3_nt ::v217(){vfunc_called(this, "_ZN8S78C3_nt4v217Ev");}
void  S78C3_nt ::v218(){vfunc_called(this, "_ZN8S78C3_nt4v218Ev");}
void  S78C3_nt ::v219(){vfunc_called(this, "_ZN8S78C3_nt4v219Ev");}
void  S78C3_nt ::v220(){vfunc_called(this, "_ZN8S78C3_nt4v220Ev");}
S78C3_nt ::S78C3_nt(){ note_ctor("S78C3_nt", this);} // tgen

//skip512 S78C3_nt

#else // __cplusplus

extern void _ZN8S78C3_ntC1Ev();
extern void _ZN8S78C3_ntD1Ev();
Name_Map name_map_S78C3_nt[] = {
  NSPAIR(_ZN8S78C3_ntC1Ev),
  NSPAIR(_ZN8S78C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
extern Class_Descriptor cd_S78C6_nt;
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
extern Class_Descriptor cd_S78C5_nt;
extern VTBL_ENTRY _ZTI8S78C5_nt[];
extern  VTBL_ENTRY _ZTV8S78C5_nt[];
extern Class_Descriptor cd_S78C4_nt;
extern VTBL_ENTRY _ZTI8S78C4_nt[];
extern  VTBL_ENTRY _ZTV8S78C4_nt[];
static Base_Class bases_S78C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S78C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S78C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S78C3_nt[];
extern void _ZN8S78C3_ntD1Ev();
extern void _ZN8S78C3_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
extern void _ZN8S78C5_nt3v70Ev();
extern void _ZN8S78C5_nt3v71Ev();
extern void _ZN8S78C5_nt3v72Ev();
extern void _ZN8S78C5_nt3v73Ev();
extern void _ZN8S78C5_nt3v74Ev();
extern void _ZN8S78C5_nt3v75Ev();
extern void _ZN8S78C5_nt3v76Ev();
extern void _ZN8S78C5_nt3v77Ev();
extern void _ZN8S78C5_nt3v78Ev();
extern void _ZN8S78C5_nt3v79Ev();
extern void _ZN8S78C5_nt3v80Ev();
extern void _ZN8S78C5_nt3v81Ev();
extern void _ZN8S78C5_nt3v82Ev();
extern void _ZN8S78C5_nt3v83Ev();
extern void _ZN8S78C5_nt3v84Ev();
extern void _ZN8S78C5_nt3v85Ev();
extern void _ZN8S78C5_nt3v86Ev();
extern void _ZN8S78C5_nt3v87Ev();
extern void _ZN8S78C5_nt3v88Ev();
extern void _ZN8S78C5_nt3v89Ev();
extern void _ZN8S78C5_nt3v90Ev();
extern void _ZN8S78C5_nt3v91Ev();
extern void _ZN8S78C5_nt3v92Ev();
extern void _ZN8S78C5_nt3v93Ev();
extern void _ZN8S78C5_nt3v94Ev();
extern void _ZN8S78C5_nt3v95Ev();
extern void _ZN8S78C5_nt3v96Ev();
extern void _ZN8S78C5_nt3v97Ev();
extern void _ZN8S78C5_nt3v98Ev();
extern void _ZN8S78C5_nt3v99Ev();
extern void _ZN8S78C5_nt4v100Ev();
extern void _ZN8S78C5_nt4v101Ev();
extern void _ZN8S78C5_nt4v102Ev();
extern void _ZN8S78C5_nt4v103Ev();
extern void _ZN8S78C5_nt4v104Ev();
extern void _ZN8S78C5_nt4v105Ev();
extern void _ZN8S78C5_nt4v106Ev();
extern void _ZN8S78C5_nt4v107Ev();
extern void _ZN8S78C5_nt4v108Ev();
extern void _ZN8S78C5_nt4v109Ev();
extern void _ZN8S78C5_nt4v110Ev();
extern void _ZN8S78C5_nt4v111Ev();
extern void _ZN8S78C5_nt4v112Ev();
extern void _ZN8S78C5_nt4v113Ev();
extern void _ZN8S78C5_nt4v114Ev();
extern void _ZN8S78C5_nt4v115Ev();
extern void _ZN8S78C5_nt4v116Ev();
extern void _ZN8S78C5_nt4v117Ev();
extern void _ZN8S78C5_nt4v118Ev();
extern void _ZN8S78C5_nt4v119Ev();
extern void _ZN8S78C5_nt4v120Ev();
extern void _ZN8S78C5_nt4v121Ev();
extern void _ZN8S78C5_nt4v122Ev();
extern void _ZN8S78C5_nt4v123Ev();
extern void _ZN8S78C5_nt4v124Ev();
extern void _ZN8S78C5_nt4v125Ev();
extern void _ZN8S78C5_nt4v126Ev();
extern void _ZN8S78C5_nt4v127Ev();
extern void _ZN8S78C5_nt4v128Ev();
extern void _ZN8S78C5_nt4v129Ev();
extern void _ZN8S78C5_nt4v130Ev();
extern void _ZN8S78C5_nt4v131Ev();
extern void _ZN8S78C5_nt4v132Ev();
extern void _ZN8S78C5_nt4v133Ev();
extern void _ZN8S78C5_nt4v134Ev();
extern void _ZN8S78C5_nt4v135Ev();
extern void _ZN8S78C5_nt4v136Ev();
extern void _ZN8S78C5_nt4v137Ev();
extern void _ZN8S78C5_nt4v138Ev();
extern void _ZN8S78C5_nt4v139Ev();
extern void _ZN8S78C5_nt4v140Ev();
extern void _ZN8S78C5_nt4v141Ev();
extern void _ZN8S78C5_nt4v142Ev();
extern void _ZN8S78C5_nt4v143Ev();
extern void _ZN8S78C5_nt4v144Ev();
extern void _ZN8S78C5_nt4v145Ev();
extern void _ZN8S78C4_nt4v146Ev();
extern void _ZN8S78C4_nt4v147Ev();
extern void _ZN8S78C4_nt4v148Ev();
extern void _ZN8S78C4_nt4v149Ev();
extern void _ZN8S78C4_nt4v150Ev();
extern void _ZN8S78C4_nt4v151Ev();
extern void _ZN8S78C4_nt4v152Ev();
extern void _ZN8S78C4_nt4v153Ev();
extern void _ZN8S78C4_nt4v154Ev();
extern void _ZN8S78C4_nt4v155Ev();
extern void _ZN8S78C4_nt4v156Ev();
extern void _ZN8S78C4_nt4v157Ev();
extern void _ZN8S78C4_nt4v158Ev();
extern void _ZN8S78C4_nt4v159Ev();
extern void _ZN8S78C4_nt4v160Ev();
extern void _ZN8S78C4_nt4v161Ev();
extern void _ZN8S78C4_nt4v162Ev();
extern void _ZN8S78C4_nt4v163Ev();
extern void _ZN8S78C4_nt4v164Ev();
extern void _ZN8S78C4_nt4v165Ev();
extern void _ZN8S78C4_nt4v166Ev();
extern void _ZN8S78C4_nt4v167Ev();
extern void _ZN8S78C4_nt4v168Ev();
extern void _ZN8S78C4_nt4v169Ev();
extern void _ZN8S78C4_nt4v170Ev();
extern void _ZN8S78C4_nt4v171Ev();
extern void _ZN8S78C4_nt4v172Ev();
extern void _ZN8S78C4_nt4v173Ev();
extern void _ZN8S78C4_nt4v174Ev();
extern void _ZN8S78C4_nt4v175Ev();
extern void _ZN8S78C4_nt4v176Ev();
extern void _ZN8S78C4_nt4v177Ev();
extern void _ZN8S78C4_nt4v178Ev();
extern void _ZN8S78C4_nt4v179Ev();
extern void _ZN8S78C4_nt4v180Ev();
extern void _ZN8S78C4_nt4v181Ev();
extern void _ZN8S78C4_nt4v182Ev();
extern void _ZN8S78C4_nt4v183Ev();
extern void _ZN8S78C4_nt4v184Ev();
extern void _ZN8S78C4_nt4v185Ev();
extern void _ZN8S78C4_nt4v186Ev();
extern void _ZN8S78C4_nt4v187Ev();
extern void _ZN8S78C4_nt4v188Ev();
extern void _ZN8S78C4_nt4v189Ev();
extern void _ZN8S78C4_nt4v190Ev();
extern void _ZN8S78C4_nt4v191Ev();
extern void _ZN8S78C4_nt4v192Ev();
extern void _ZN8S78C4_nt4v193Ev();
extern void _ZN8S78C4_nt4v194Ev();
extern void _ZN8S78C4_nt4v195Ev();
extern void _ZN8S78C4_nt4v196Ev();
extern void _ZN8S78C4_nt4v197Ev();
extern void _ZN8S78C4_nt4v198Ev();
extern void _ZN8S78C4_nt4v199Ev();
extern void _ZN8S78C4_nt4v200Ev();
extern void _ZN8S78C4_nt4v201Ev();
extern void _ZN8S78C4_nt4v202Ev();
extern void _ZN8S78C4_nt4v203Ev();
extern void _ZN8S78C4_nt4v204Ev();
extern void _ZN8S78C4_nt4v205Ev();
extern void _ZN8S78C4_nt4v206Ev();
extern void _ZN8S78C4_nt4v207Ev();
extern void _ZN8S78C4_nt4v208Ev();
extern void _ZN8S78C4_nt4v209Ev();
extern void _ZN8S78C4_nt4v210Ev();
extern void _ZN8S78C4_nt4v211Ev();
extern void _ZN8S78C4_nt4v212Ev();
extern void _ZN8S78C4_nt4v213Ev();
extern void _ZN8S78C4_nt4v214Ev();
extern void _ZN8S78C3_nt4v215Ev();
extern void _ZN8S78C3_nt4v216Ev();
extern void _ZN8S78C3_nt4v217Ev();
extern void _ZN8S78C3_nt4v218Ev();
extern void _ZN8S78C3_nt4v219Ev();
extern void _ZN8S78C3_nt4v220Ev();
static  VTBL_ENTRY vtc_S78C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C3_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v220Ev,
};
extern VTBL_ENTRY _ZTI8S78C3_nt[];
VTBL_ENTRY *P__ZTI8S78C3_nt = _ZTI8S78C3_nt; 
extern  VTBL_ENTRY _ZTV8S78C3_nt[];
Class_Descriptor cd_S78C3_nt = {  "S78C3_nt", // class name
  bases_S78C3_nt, 4,
  &(vtc_S78C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1240,916), // object size
  NSPAIRA(_ZTI8S78C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S78C3_nt),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C2_nt  : S78C3_nt {
  unsigned int s78c2f0:1;
  void *s78c2f1;
  int s78c2f2[5];
  ::S78C21_nt s78c2f3;
  virtual  ~S78C2_nt(); // _ZN8S78C2_ntD1Ev
  virtual void  v221(); // _ZN8S78C2_nt4v221Ev
  virtual void  v222(); // _ZN8S78C2_nt4v222Ev
  virtual void  v223(); // _ZN8S78C2_nt4v223Ev
  S78C2_nt(); // tgen
};
//SIG(-1 S78C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC17{ BC18{ m Fi[4]}} FC7 Fp[2] FC19{ m FC7 Fp FC17 Fp} FC20{ m Fp[8] Fc[4]} Fi FC21{ m Fp[5] FC22{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC7[4] FC23{ m FC24{ m Fi[3]} FC25{ m} FC26{ BC27{ m Fi[2] Fc[2]} Fi} Fc} FC24 Fi FC28{ m FC29{ BC30{ m Fp[2]}} Fc FC31{ BC32{ BC33{ BC11}}} Fi FC7 FC7 Fp} FC28 Fp FC24 FC14 FC34{ BC35{ BC11}} Fi:1 Fi:1 Fi:1 FC25 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v215 v216 v217 v218 v219 v220 Fi:1 Fp} vd v1 v2 v3 Fi:1 Fp Fi[5] FC16}


 S78C2_nt ::~S78C2_nt(){ note_dtor("S78C2_nt", this);}
void  S78C2_nt ::v221(){vfunc_called(this, "_ZN8S78C2_nt4v221Ev");}
void  S78C2_nt ::v222(){vfunc_called(this, "_ZN8S78C2_nt4v222Ev");}
void  S78C2_nt ::v223(){vfunc_called(this, "_ZN8S78C2_nt4v223Ev");}
S78C2_nt ::S78C2_nt(){ note_ctor("S78C2_nt", this);} // tgen

//skip512 S78C2_nt

#else // __cplusplus

extern void _ZN8S78C2_ntC1Ev();
extern void _ZN8S78C2_ntD1Ev();
Name_Map name_map_S78C2_nt[] = {
  NSPAIR(_ZN8S78C2_ntC1Ev),
  NSPAIR(_ZN8S78C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
extern Class_Descriptor cd_S78C6_nt;
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
extern Class_Descriptor cd_S78C5_nt;
extern VTBL_ENTRY _ZTI8S78C5_nt[];
extern  VTBL_ENTRY _ZTV8S78C5_nt[];
extern Class_Descriptor cd_S78C4_nt;
extern VTBL_ENTRY _ZTI8S78C4_nt[];
extern  VTBL_ENTRY _ZTV8S78C4_nt[];
extern Class_Descriptor cd_S78C3_nt;
extern VTBL_ENTRY _ZTI8S78C3_nt[];
extern  VTBL_ENTRY _ZTV8S78C3_nt[];
static Base_Class bases_S78C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S78C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S78C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S78C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S78C2_nt[];
extern void _ZN8S78C2_ntD1Ev();
extern void _ZN8S78C2_ntD0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
extern void _ZN8S78C5_nt3v70Ev();
extern void _ZN8S78C5_nt3v71Ev();
extern void _ZN8S78C5_nt3v72Ev();
extern void _ZN8S78C5_nt3v73Ev();
extern void _ZN8S78C5_nt3v74Ev();
extern void _ZN8S78C5_nt3v75Ev();
extern void _ZN8S78C5_nt3v76Ev();
extern void _ZN8S78C5_nt3v77Ev();
extern void _ZN8S78C5_nt3v78Ev();
extern void _ZN8S78C5_nt3v79Ev();
extern void _ZN8S78C5_nt3v80Ev();
extern void _ZN8S78C5_nt3v81Ev();
extern void _ZN8S78C5_nt3v82Ev();
extern void _ZN8S78C5_nt3v83Ev();
extern void _ZN8S78C5_nt3v84Ev();
extern void _ZN8S78C5_nt3v85Ev();
extern void _ZN8S78C5_nt3v86Ev();
extern void _ZN8S78C5_nt3v87Ev();
extern void _ZN8S78C5_nt3v88Ev();
extern void _ZN8S78C5_nt3v89Ev();
extern void _ZN8S78C5_nt3v90Ev();
extern void _ZN8S78C5_nt3v91Ev();
extern void _ZN8S78C5_nt3v92Ev();
extern void _ZN8S78C5_nt3v93Ev();
extern void _ZN8S78C5_nt3v94Ev();
extern void _ZN8S78C5_nt3v95Ev();
extern void _ZN8S78C5_nt3v96Ev();
extern void _ZN8S78C5_nt3v97Ev();
extern void _ZN8S78C5_nt3v98Ev();
extern void _ZN8S78C5_nt3v99Ev();
extern void _ZN8S78C5_nt4v100Ev();
extern void _ZN8S78C5_nt4v101Ev();
extern void _ZN8S78C5_nt4v102Ev();
extern void _ZN8S78C5_nt4v103Ev();
extern void _ZN8S78C5_nt4v104Ev();
extern void _ZN8S78C5_nt4v105Ev();
extern void _ZN8S78C5_nt4v106Ev();
extern void _ZN8S78C5_nt4v107Ev();
extern void _ZN8S78C5_nt4v108Ev();
extern void _ZN8S78C5_nt4v109Ev();
extern void _ZN8S78C5_nt4v110Ev();
extern void _ZN8S78C5_nt4v111Ev();
extern void _ZN8S78C5_nt4v112Ev();
extern void _ZN8S78C5_nt4v113Ev();
extern void _ZN8S78C5_nt4v114Ev();
extern void _ZN8S78C5_nt4v115Ev();
extern void _ZN8S78C5_nt4v116Ev();
extern void _ZN8S78C5_nt4v117Ev();
extern void _ZN8S78C5_nt4v118Ev();
extern void _ZN8S78C5_nt4v119Ev();
extern void _ZN8S78C5_nt4v120Ev();
extern void _ZN8S78C5_nt4v121Ev();
extern void _ZN8S78C5_nt4v122Ev();
extern void _ZN8S78C5_nt4v123Ev();
extern void _ZN8S78C5_nt4v124Ev();
extern void _ZN8S78C5_nt4v125Ev();
extern void _ZN8S78C5_nt4v126Ev();
extern void _ZN8S78C5_nt4v127Ev();
extern void _ZN8S78C5_nt4v128Ev();
extern void _ZN8S78C5_nt4v129Ev();
extern void _ZN8S78C5_nt4v130Ev();
extern void _ZN8S78C5_nt4v131Ev();
extern void _ZN8S78C5_nt4v132Ev();
extern void _ZN8S78C5_nt4v133Ev();
extern void _ZN8S78C5_nt4v134Ev();
extern void _ZN8S78C5_nt4v135Ev();
extern void _ZN8S78C5_nt4v136Ev();
extern void _ZN8S78C5_nt4v137Ev();
extern void _ZN8S78C5_nt4v138Ev();
extern void _ZN8S78C5_nt4v139Ev();
extern void _ZN8S78C5_nt4v140Ev();
extern void _ZN8S78C5_nt4v141Ev();
extern void _ZN8S78C5_nt4v142Ev();
extern void _ZN8S78C5_nt4v143Ev();
extern void _ZN8S78C5_nt4v144Ev();
extern void _ZN8S78C5_nt4v145Ev();
extern void _ZN8S78C4_nt4v146Ev();
extern void _ZN8S78C4_nt4v147Ev();
extern void _ZN8S78C4_nt4v148Ev();
extern void _ZN8S78C4_nt4v149Ev();
extern void _ZN8S78C4_nt4v150Ev();
extern void _ZN8S78C4_nt4v151Ev();
extern void _ZN8S78C4_nt4v152Ev();
extern void _ZN8S78C4_nt4v153Ev();
extern void _ZN8S78C4_nt4v154Ev();
extern void _ZN8S78C4_nt4v155Ev();
extern void _ZN8S78C4_nt4v156Ev();
extern void _ZN8S78C4_nt4v157Ev();
extern void _ZN8S78C4_nt4v158Ev();
extern void _ZN8S78C4_nt4v159Ev();
extern void _ZN8S78C4_nt4v160Ev();
extern void _ZN8S78C4_nt4v161Ev();
extern void _ZN8S78C4_nt4v162Ev();
extern void _ZN8S78C4_nt4v163Ev();
extern void _ZN8S78C4_nt4v164Ev();
extern void _ZN8S78C4_nt4v165Ev();
extern void _ZN8S78C4_nt4v166Ev();
extern void _ZN8S78C4_nt4v167Ev();
extern void _ZN8S78C4_nt4v168Ev();
extern void _ZN8S78C4_nt4v169Ev();
extern void _ZN8S78C4_nt4v170Ev();
extern void _ZN8S78C4_nt4v171Ev();
extern void _ZN8S78C4_nt4v172Ev();
extern void _ZN8S78C4_nt4v173Ev();
extern void _ZN8S78C4_nt4v174Ev();
extern void _ZN8S78C4_nt4v175Ev();
extern void _ZN8S78C4_nt4v176Ev();
extern void _ZN8S78C4_nt4v177Ev();
extern void _ZN8S78C4_nt4v178Ev();
extern void _ZN8S78C4_nt4v179Ev();
extern void _ZN8S78C4_nt4v180Ev();
extern void _ZN8S78C4_nt4v181Ev();
extern void _ZN8S78C4_nt4v182Ev();
extern void _ZN8S78C4_nt4v183Ev();
extern void _ZN8S78C4_nt4v184Ev();
extern void _ZN8S78C4_nt4v185Ev();
extern void _ZN8S78C4_nt4v186Ev();
extern void _ZN8S78C4_nt4v187Ev();
extern void _ZN8S78C4_nt4v188Ev();
extern void _ZN8S78C4_nt4v189Ev();
extern void _ZN8S78C4_nt4v190Ev();
extern void _ZN8S78C4_nt4v191Ev();
extern void _ZN8S78C4_nt4v192Ev();
extern void _ZN8S78C4_nt4v193Ev();
extern void _ZN8S78C4_nt4v194Ev();
extern void _ZN8S78C4_nt4v195Ev();
extern void _ZN8S78C4_nt4v196Ev();
extern void _ZN8S78C4_nt4v197Ev();
extern void _ZN8S78C4_nt4v198Ev();
extern void _ZN8S78C4_nt4v199Ev();
extern void _ZN8S78C4_nt4v200Ev();
extern void _ZN8S78C4_nt4v201Ev();
extern void _ZN8S78C4_nt4v202Ev();
extern void _ZN8S78C4_nt4v203Ev();
extern void _ZN8S78C4_nt4v204Ev();
extern void _ZN8S78C4_nt4v205Ev();
extern void _ZN8S78C4_nt4v206Ev();
extern void _ZN8S78C4_nt4v207Ev();
extern void _ZN8S78C4_nt4v208Ev();
extern void _ZN8S78C4_nt4v209Ev();
extern void _ZN8S78C4_nt4v210Ev();
extern void _ZN8S78C4_nt4v211Ev();
extern void _ZN8S78C4_nt4v212Ev();
extern void _ZN8S78C4_nt4v213Ev();
extern void _ZN8S78C4_nt4v214Ev();
extern void _ZN8S78C3_nt4v215Ev();
extern void _ZN8S78C3_nt4v216Ev();
extern void _ZN8S78C3_nt4v217Ev();
extern void _ZN8S78C3_nt4v218Ev();
extern void _ZN8S78C3_nt4v219Ev();
extern void _ZN8S78C3_nt4v220Ev();
extern void _ZN8S78C2_nt4v221Ev();
extern void _ZN8S78C2_nt4v222Ev();
extern void _ZN8S78C2_nt4v223Ev();
static  VTBL_ENTRY vtc_S78C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S78C2_nt[0]),
  (VTBL_ENTRY)&_ZN8S78C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S78C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v223Ev,
};
extern VTBL_ENTRY _ZTI8S78C2_nt[];
VTBL_ENTRY *P__ZTI8S78C2_nt = _ZTI8S78C2_nt; 
extern  VTBL_ENTRY _ZTV8S78C2_nt[];
Class_Descriptor cd_S78C2_nt = {  "S78C2_nt", // class name
  bases_S78C2_nt, 5,
  &(vtc_S78C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1296,956), // object size
  NSPAIRA(_ZTI8S78C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S78C2_nt),224, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C50  : S78C12_nt {
};
//SIG(-1 S78C50) C1{ BC2{ m Fp Fi[2]}}



static void Test_S78C50()
{
  extern Class_Descriptor cd_S78C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C50, buf);
    S78C50 &lv = *(new (buf) S78C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C50)");
    check_base_class_offset(lv, (S78C12_nt*), 0, "S78C50");
    test_class_info(&lv, &cd_S78C50);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C50(Test_S78C50, "S78C50", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
static Base_Class bases_S78C50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C50 = {  "S78C50", // class name
  bases_S78C50, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C49  : S78C50 {
};
//SIG(-1 S78C49) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S78C49()
{
  extern Class_Descriptor cd_S78C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S78C49, buf);
    S78C49 &lv = *(new (buf) S78C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S78C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C49)");
    check_base_class_offset(lv, (S78C12_nt*)(S78C50*), 0, "S78C49");
    check_base_class_offset(lv, (S78C50*), 0, "S78C49");
    test_class_info(&lv, &cd_S78C49);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C49(Test_S78C49, "S78C49", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S78C12_nt;
extern Class_Descriptor cd_S78C50;
static Base_Class bases_S78C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S78C49 = {  "S78C49", // class name
  bases_S78C49, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S78C1  : S78C2_nt {
  ::S78C44 s78c1f0;
  int s78c1f1[8];
  ::S78C49 s78c1f2;
  int s78c1f3[3];
  unsigned int s78c1f4:1;
  unsigned int s78c1f5:1;
  int s78c1f6[9];
  ::S78C21_nt s78c1f7;
  ::S78C21_nt s78c1f8;
  ::S78C21_nt s78c1f9;
  virtual  ~S78C1(); // _ZN5S78C1D1Ev
  virtual void  v1(); // _ZN5S78C12v1Ev
  virtual void  v2(); // _ZN5S78C12v2Ev
  virtual void  v3(); // _ZN5S78C12v3Ev
  S78C1(); // tgen
};
//SIG(1 S78C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 FC9{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC12{ m Fp Fi[2]}}} FC10 Fp FC13{ BC14{ BC12}} FC13 FC13 FC15{ BC16{ BC12}} Fc Fi Fp FC8 FC8 FC8 FC8 FC8 FC8 FC17{ m Fp FC8} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17} vd v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC18{ BC19{ m Fi[4]}} FC8 Fp[2] FC20{ m FC8 Fp FC18 Fp} FC21{ m Fp[8] Fc[4]} Fi FC22{ m Fp[5] FC23{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC8[4] FC24{ m FC25{ m Fi[3]} FC26{ m} FC27{ BC28{ m Fi[2] Fc[2]} Fi} Fc} FC25 Fi FC29{ m FC30{ BC31{ m Fp[2]}} Fc FC32{ BC33{ BC34{ BC12}}} Fi FC8 FC8 Fp} FC29 Fp FC25 FC15 FC35{ BC36{ BC12}} Fi:1 Fi:1 Fi:1 FC26 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17} vd v215 v216 v217 v218 v219 v220 Fi:1 Fp} vd v221 v222 v223 Fi:1 Fp Fi[5] FC17} vd v1 v2 v3 FC35 Fi[8] FC37{ BC38{ BC12}} Fi[3] Fi:1 Fi:1 Fi[9] FC17 FC17 FC17}


 S78C1 ::~S78C1(){ note_dtor("S78C1", this);}
void  S78C1 ::v1(){vfunc_called(this, "_ZN5S78C12v1Ev");}
void  S78C1 ::v2(){vfunc_called(this, "_ZN5S78C12v2Ev");}
void  S78C1 ::v3(){vfunc_called(this, "_ZN5S78C12v3Ev");}
S78C1 ::S78C1(){ note_ctor("S78C1", this);} // tgen

static void Test_S78C1()
{
  extern Class_Descriptor cd_S78C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(184,276)];
    init_test(&cd_S78C1, buf);
    S78C1 *dp, &lv = *(dp=new (buf) S78C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1464,1100), "sizeof(S78C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S78C1)");
    check_base_class_offset(lv, (S78C7_nt*)(S78C6_nt*)(S78C5_nt*)(S78C4_nt*)(S78C3_nt*)(S78C2_nt*), 0, "S78C1");
    check_base_class_offset(lv, (S78C6_nt*)(S78C5_nt*)(S78C4_nt*)(S78C3_nt*)(S78C2_nt*), 0, "S78C1");
    check_base_class_offset(lv, (S78C5_nt*)(S78C4_nt*)(S78C3_nt*)(S78C2_nt*), 0, "S78C1");
    check_base_class_offset(lv, (S78C4_nt*)(S78C3_nt*)(S78C2_nt*), 0, "S78C1");
    check_base_class_offset(lv, (S78C3_nt*)(S78C2_nt*), 0, "S78C1");
    check_base_class_offset(lv, (S78C2_nt*), 0, "S78C1");
    check_field_offset(lv, s78c1f0, ABISELECT(1296,956), "S78C1.s78c1f0");
    check_field_offset(lv, s78c1f1, ABISELECT(1312,968), "S78C1.s78c1f1");
    check_field_offset(lv, s78c1f2, ABISELECT(1344,1000), "S78C1.s78c1f2");
    check_field_offset(lv, s78c1f3, ABISELECT(1360,1012), "S78C1.s78c1f3");
    set_bf_and_test(lv, s78c1f4, ABISELECT(1372,1024), 0, 1, 1, "S78C1");
    set_bf_and_test(lv, s78c1f5, ABISELECT(1372,1024), 1, 1, 1, "S78C1");
    check_field_offset(lv, s78c1f6, ABISELECT(1376,1028), "S78C1.s78c1f6");
    check_field_offset(lv, s78c1f7, ABISELECT(1416,1064), "S78C1.s78c1f7");
    check_field_offset(lv, s78c1f8, ABISELECT(1432,1076), "S78C1.s78c1f8");
    check_field_offset(lv, s78c1f9, ABISELECT(1448,1088), "S78C1.s78c1f9");
    test_class_info(&lv, &cd_S78C1);
    dp->~S78C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS78C1(Test_S78C1, "S78C1", ABISELECT(1464,1100));

#else // __cplusplus

extern void _ZN5S78C1C1Ev();
extern void _ZN5S78C1D1Ev();
Name_Map name_map_S78C1[] = {
  NSPAIR(_ZN5S78C1C1Ev),
  NSPAIR(_ZN5S78C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S78C7_nt;
extern VTBL_ENTRY _ZTI8S78C7_nt[];
extern  VTBL_ENTRY _ZTV8S78C7_nt[];
extern Class_Descriptor cd_S78C6_nt;
extern VTBL_ENTRY _ZTI8S78C6_nt[];
extern  VTBL_ENTRY _ZTV8S78C6_nt[];
extern Class_Descriptor cd_S78C5_nt;
extern VTBL_ENTRY _ZTI8S78C5_nt[];
extern  VTBL_ENTRY _ZTV8S78C5_nt[];
extern Class_Descriptor cd_S78C4_nt;
extern VTBL_ENTRY _ZTI8S78C4_nt[];
extern  VTBL_ENTRY _ZTV8S78C4_nt[];
extern Class_Descriptor cd_S78C3_nt;
extern VTBL_ENTRY _ZTI8S78C3_nt[];
extern  VTBL_ENTRY _ZTV8S78C3_nt[];
extern Class_Descriptor cd_S78C2_nt;
extern VTBL_ENTRY _ZTI8S78C2_nt[];
extern  VTBL_ENTRY _ZTV8S78C2_nt[];
static Base_Class bases_S78C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S78C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S78C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S78C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S78C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S78C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S78C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S78C1[];
extern void _ZN5S78C1D1Ev();
extern void _ZN5S78C1D0Ev();
extern void _ZN8S78C7_nt2v4Ev();
extern void _ZN8S78C7_nt2v5Ev();
extern void _ZN8S78C7_nt2v6Ev();
extern void _ZN8S78C7_nt2v7Ev();
extern void _ZN8S78C7_nt2v8Ev();
extern void _ZN8S78C7_nt2v9Ev();
extern void _ZN8S78C7_nt3v10Ev();
extern void _ZN8S78C7_nt3v11Ev();
extern void _ZN8S78C7_nt3v12Ev();
extern void _ZN8S78C7_nt3v13Ev();
extern void _ZN8S78C7_nt3v14Ev();
extern void _ZN8S78C7_nt3v15Ev();
extern void _ZN8S78C7_nt3v16Ev();
extern void _ZN8S78C7_nt3v17Ev();
extern void _ZN8S78C7_nt3v18Ev();
extern void _ZN8S78C7_nt3v19Ev();
extern void _ZN8S78C7_nt3v20Ev();
extern void _ZN8S78C7_nt3v21Ev();
extern void _ZN8S78C7_nt3v22Ev();
extern void _ZN8S78C7_nt3v23Ev();
extern void _ZN8S78C7_nt3v24Ev();
extern void _ZN8S78C7_nt3v25Ev();
extern void _ZN8S78C7_nt3v26Ev();
extern void _ZN8S78C7_nt3v27Ev();
extern void _ZN8S78C7_nt3v28Ev();
extern void _ZN8S78C7_nt3v29Ev();
extern void _ZN8S78C7_nt3v30Ev();
extern void _ZN8S78C7_nt3v31Ev();
extern void _ZN8S78C7_nt3v32Ev();
extern void _ZN8S78C7_nt3v33Ev();
extern void _ZN8S78C7_nt3v34Ev();
extern void _ZN8S78C7_nt3v35Ev();
extern void _ZN8S78C7_nt3v36Ev();
extern void _ZN8S78C7_nt3v37Ev();
extern void _ZN8S78C7_nt3v38Ev();
extern void _ZN8S78C7_nt3v39Ev();
extern void _ZN8S78C7_nt3v40Ev();
extern void _ZN8S78C7_nt3v41Ev();
extern void _ZN8S78C7_nt3v42Ev();
extern void _ZN8S78C7_nt3v43Ev();
extern void _ZN8S78C7_nt3v44Ev();
extern void _ZN8S78C7_nt3v45Ev();
extern void _ZN8S78C7_nt3v46Ev();
extern void _ZN8S78C7_nt3v47Ev();
extern void _ZN8S78C7_nt3v48Ev();
extern void _ZN8S78C7_nt3v49Ev();
extern void _ZN8S78C7_nt3v50Ev();
extern void _ZN8S78C7_nt3v51Ev();
extern void _ZN8S78C7_nt3v52Ev();
extern void _ZN8S78C7_nt3v53Ev();
extern void _ZN8S78C7_nt3v54Ev();
extern void _ZN8S78C7_nt3v55Ev();
extern void _ZN8S78C7_nt3v56Ev();
extern void _ZN8S78C7_nt3v57Ev();
extern void _ZN8S78C7_nt3v58Ev();
extern void _ZN8S78C7_nt3v59Ev();
extern void _ZN8S78C7_nt3v60Ev();
extern void _ZN8S78C7_nt3v61Ev();
extern void _ZN8S78C7_nt3v62Ev();
extern void _ZN8S78C7_nt3v63Ev();
extern void _ZN8S78C7_nt3v64Ev();
extern void _ZN8S78C7_nt3v65Ev();
extern void _ZN8S78C7_nt3v66Ev();
extern void _ZN8S78C7_nt3v67Ev();
extern void _ZN8S78C6_nt3v68Ev();
extern void _ZN8S78C6_nt3v69Ev();
extern void _ZN8S78C5_nt3v70Ev();
extern void _ZN8S78C5_nt3v71Ev();
extern void _ZN8S78C5_nt3v72Ev();
extern void _ZN8S78C5_nt3v73Ev();
extern void _ZN8S78C5_nt3v74Ev();
extern void _ZN8S78C5_nt3v75Ev();
extern void _ZN8S78C5_nt3v76Ev();
extern void _ZN8S78C5_nt3v77Ev();
extern void _ZN8S78C5_nt3v78Ev();
extern void _ZN8S78C5_nt3v79Ev();
extern void _ZN8S78C5_nt3v80Ev();
extern void _ZN8S78C5_nt3v81Ev();
extern void _ZN8S78C5_nt3v82Ev();
extern void _ZN8S78C5_nt3v83Ev();
extern void _ZN8S78C5_nt3v84Ev();
extern void _ZN8S78C5_nt3v85Ev();
extern void _ZN8S78C5_nt3v86Ev();
extern void _ZN8S78C5_nt3v87Ev();
extern void _ZN8S78C5_nt3v88Ev();
extern void _ZN8S78C5_nt3v89Ev();
extern void _ZN8S78C5_nt3v90Ev();
extern void _ZN8S78C5_nt3v91Ev();
extern void _ZN8S78C5_nt3v92Ev();
extern void _ZN8S78C5_nt3v93Ev();
extern void _ZN8S78C5_nt3v94Ev();
extern void _ZN8S78C5_nt3v95Ev();
extern void _ZN8S78C5_nt3v96Ev();
extern void _ZN8S78C5_nt3v97Ev();
extern void _ZN8S78C5_nt3v98Ev();
extern void _ZN8S78C5_nt3v99Ev();
extern void _ZN8S78C5_nt4v100Ev();
extern void _ZN8S78C5_nt4v101Ev();
extern void _ZN8S78C5_nt4v102Ev();
extern void _ZN8S78C5_nt4v103Ev();
extern void _ZN8S78C5_nt4v104Ev();
extern void _ZN8S78C5_nt4v105Ev();
extern void _ZN8S78C5_nt4v106Ev();
extern void _ZN8S78C5_nt4v107Ev();
extern void _ZN8S78C5_nt4v108Ev();
extern void _ZN8S78C5_nt4v109Ev();
extern void _ZN8S78C5_nt4v110Ev();
extern void _ZN8S78C5_nt4v111Ev();
extern void _ZN8S78C5_nt4v112Ev();
extern void _ZN8S78C5_nt4v113Ev();
extern void _ZN8S78C5_nt4v114Ev();
extern void _ZN8S78C5_nt4v115Ev();
extern void _ZN8S78C5_nt4v116Ev();
extern void _ZN8S78C5_nt4v117Ev();
extern void _ZN8S78C5_nt4v118Ev();
extern void _ZN8S78C5_nt4v119Ev();
extern void _ZN8S78C5_nt4v120Ev();
extern void _ZN8S78C5_nt4v121Ev();
extern void _ZN8S78C5_nt4v122Ev();
extern void _ZN8S78C5_nt4v123Ev();
extern void _ZN8S78C5_nt4v124Ev();
extern void _ZN8S78C5_nt4v125Ev();
extern void _ZN8S78C5_nt4v126Ev();
extern void _ZN8S78C5_nt4v127Ev();
extern void _ZN8S78C5_nt4v128Ev();
extern void _ZN8S78C5_nt4v129Ev();
extern void _ZN8S78C5_nt4v130Ev();
extern void _ZN8S78C5_nt4v131Ev();
extern void _ZN8S78C5_nt4v132Ev();
extern void _ZN8S78C5_nt4v133Ev();
extern void _ZN8S78C5_nt4v134Ev();
extern void _ZN8S78C5_nt4v135Ev();
extern void _ZN8S78C5_nt4v136Ev();
extern void _ZN8S78C5_nt4v137Ev();
extern void _ZN8S78C5_nt4v138Ev();
extern void _ZN8S78C5_nt4v139Ev();
extern void _ZN8S78C5_nt4v140Ev();
extern void _ZN8S78C5_nt4v141Ev();
extern void _ZN8S78C5_nt4v142Ev();
extern void _ZN8S78C5_nt4v143Ev();
extern void _ZN8S78C5_nt4v144Ev();
extern void _ZN8S78C5_nt4v145Ev();
extern void _ZN8S78C4_nt4v146Ev();
extern void _ZN8S78C4_nt4v147Ev();
extern void _ZN8S78C4_nt4v148Ev();
extern void _ZN8S78C4_nt4v149Ev();
extern void _ZN8S78C4_nt4v150Ev();
extern void _ZN8S78C4_nt4v151Ev();
extern void _ZN8S78C4_nt4v152Ev();
extern void _ZN8S78C4_nt4v153Ev();
extern void _ZN8S78C4_nt4v154Ev();
extern void _ZN8S78C4_nt4v155Ev();
extern void _ZN8S78C4_nt4v156Ev();
extern void _ZN8S78C4_nt4v157Ev();
extern void _ZN8S78C4_nt4v158Ev();
extern void _ZN8S78C4_nt4v159Ev();
extern void _ZN8S78C4_nt4v160Ev();
extern void _ZN8S78C4_nt4v161Ev();
extern void _ZN8S78C4_nt4v162Ev();
extern void _ZN8S78C4_nt4v163Ev();
extern void _ZN8S78C4_nt4v164Ev();
extern void _ZN8S78C4_nt4v165Ev();
extern void _ZN8S78C4_nt4v166Ev();
extern void _ZN8S78C4_nt4v167Ev();
extern void _ZN8S78C4_nt4v168Ev();
extern void _ZN8S78C4_nt4v169Ev();
extern void _ZN8S78C4_nt4v170Ev();
extern void _ZN8S78C4_nt4v171Ev();
extern void _ZN8S78C4_nt4v172Ev();
extern void _ZN8S78C4_nt4v173Ev();
extern void _ZN8S78C4_nt4v174Ev();
extern void _ZN8S78C4_nt4v175Ev();
extern void _ZN8S78C4_nt4v176Ev();
extern void _ZN8S78C4_nt4v177Ev();
extern void _ZN8S78C4_nt4v178Ev();
extern void _ZN8S78C4_nt4v179Ev();
extern void _ZN8S78C4_nt4v180Ev();
extern void _ZN8S78C4_nt4v181Ev();
extern void _ZN8S78C4_nt4v182Ev();
extern void _ZN8S78C4_nt4v183Ev();
extern void _ZN8S78C4_nt4v184Ev();
extern void _ZN8S78C4_nt4v185Ev();
extern void _ZN8S78C4_nt4v186Ev();
extern void _ZN8S78C4_nt4v187Ev();
extern void _ZN8S78C4_nt4v188Ev();
extern void _ZN8S78C4_nt4v189Ev();
extern void _ZN8S78C4_nt4v190Ev();
extern void _ZN8S78C4_nt4v191Ev();
extern void _ZN8S78C4_nt4v192Ev();
extern void _ZN8S78C4_nt4v193Ev();
extern void _ZN8S78C4_nt4v194Ev();
extern void _ZN8S78C4_nt4v195Ev();
extern void _ZN8S78C4_nt4v196Ev();
extern void _ZN8S78C4_nt4v197Ev();
extern void _ZN8S78C4_nt4v198Ev();
extern void _ZN8S78C4_nt4v199Ev();
extern void _ZN8S78C4_nt4v200Ev();
extern void _ZN8S78C4_nt4v201Ev();
extern void _ZN8S78C4_nt4v202Ev();
extern void _ZN8S78C4_nt4v203Ev();
extern void _ZN8S78C4_nt4v204Ev();
extern void _ZN8S78C4_nt4v205Ev();
extern void _ZN8S78C4_nt4v206Ev();
extern void _ZN8S78C4_nt4v207Ev();
extern void _ZN8S78C4_nt4v208Ev();
extern void _ZN8S78C4_nt4v209Ev();
extern void _ZN8S78C4_nt4v210Ev();
extern void _ZN8S78C4_nt4v211Ev();
extern void _ZN8S78C4_nt4v212Ev();
extern void _ZN8S78C4_nt4v213Ev();
extern void _ZN8S78C4_nt4v214Ev();
extern void _ZN8S78C3_nt4v215Ev();
extern void _ZN8S78C3_nt4v216Ev();
extern void _ZN8S78C3_nt4v217Ev();
extern void _ZN8S78C3_nt4v218Ev();
extern void _ZN8S78C3_nt4v219Ev();
extern void _ZN8S78C3_nt4v220Ev();
extern void _ZN8S78C2_nt4v221Ev();
extern void _ZN8S78C2_nt4v222Ev();
extern void _ZN8S78C2_nt4v223Ev();
extern void _ZN5S78C12v1Ev();
extern void _ZN5S78C12v2Ev();
extern void _ZN5S78C12v3Ev();
static  VTBL_ENTRY vtc_S78C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S78C1[0]),
  (VTBL_ENTRY)&_ZN5S78C1D1Ev,
  (VTBL_ENTRY)&_ZN5S78C1D0Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v4Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S78C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S78C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v121Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v122Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v123Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v124Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v125Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v126Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v127Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v128Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v129Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v130Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v131Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v132Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v133Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v134Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v135Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v136Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v137Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v138Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v139Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v140Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v141Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v142Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v143Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v144Ev,
  (VTBL_ENTRY)&_ZN8S78C5_nt4v145Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN8S78C4_nt4v214Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v216Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v217Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v218Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v219Ev,
  (VTBL_ENTRY)&_ZN8S78C3_nt4v220Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN8S78C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN5S78C12v1Ev,
  (VTBL_ENTRY)&_ZN5S78C12v2Ev,
  (VTBL_ENTRY)&_ZN5S78C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S78C1[];
extern  VTBL_ENTRY _ZTV5S78C1[];
Class_Descriptor cd_S78C1 = {  "S78C1", // class name
  bases_S78C1, 6,
  &(vtc_S78C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1464,1100), // object size
  NSPAIRA(_ZTI5S78C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S78C1),227, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C7_nt  {
  void  mf5328c7(); // _ZN10S5328C7_nt8mf5328c7Ev
};
//SIG(-1 S5328C7_nt) C1{ m}


void  S5328C7_nt ::mf5328c7(){}

//skip512 S5328C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C5_nt  {
  void *s5328c5f0;
  int s5328c5f1;
  ::S78C32_nt s5328c5f2;
  ::S5328C7_nt s5328c5f3;
  void  mf5328c5(); // _ZN10S5328C5_nt8mf5328c5Ev
};
//SIG(-1 S5328C5_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S5328C5_nt ::mf5328c5(){}

//skip512 S5328C5_nt

#else // __cplusplus

Class_Descriptor cd_S5328C5_nt = {  "S5328C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C4_nt  : S5328C5_nt {
};
//SIG(-1 S5328C4_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S5328C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S5328C5_nt;
static Base_Class bases_S5328C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5328C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C3_nt  {
  void *s5328c3f0;
  int s5328c3f1;
  ::S5328C4_nt s5328c3f2;
  ::S5328C4_nt s5328c3f3;
  int s5328c3f4;
  virtual  ~S5328C3_nt(); // _ZN10S5328C3_ntD1Ev
  virtual void  v6(); // _ZN10S5328C3_nt2v6Ev
  virtual void  v7(); // _ZN10S5328C3_nt2v7Ev
  virtual void  v8(); // _ZN10S5328C3_nt2v8Ev
  virtual void  v9(); // _ZN10S5328C3_nt2v9Ev
  virtual void  v10(); // _ZN10S5328C3_nt3v10Ev
  virtual void  v11(); // _ZN10S5328C3_nt3v11Ev
  virtual void  v12(); // _ZN10S5328C3_nt3v12Ev
  virtual void  v13(); // _ZN10S5328C3_nt3v13Ev
  virtual void  v14(); // _ZN10S5328C3_nt3v14Ev
  virtual void  v15(); // _ZN10S5328C3_nt3v15Ev
  virtual void  v16(); // _ZN10S5328C3_nt3v16Ev
  virtual void  v17(); // _ZN10S5328C3_nt3v17Ev
  virtual void  v18(); // _ZN10S5328C3_nt3v18Ev
  virtual void  v19(); // _ZN10S5328C3_nt3v19Ev
  virtual void  v20(); // _ZN10S5328C3_nt3v20Ev
  virtual void  v21(); // _ZN10S5328C3_nt3v21Ev
  virtual void  v22(); // _ZN10S5328C3_nt3v22Ev
  virtual void  v23(); // _ZN10S5328C3_nt3v23Ev
  virtual void  v24(); // _ZN10S5328C3_nt3v24Ev
  virtual void  v25(); // _ZN10S5328C3_nt3v25Ev
  virtual void  v26(); // _ZN10S5328C3_nt3v26Ev
  virtual void  v27(); // _ZN10S5328C3_nt3v27Ev
  virtual void  v28(); // _ZN10S5328C3_nt3v28Ev
  S5328C3_nt(); // tgen
};
//SIG(-1 S5328C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S5328C3_nt ::~S5328C3_nt(){ note_dtor("S5328C3_nt", this);}
void  S5328C3_nt ::v6(){vfunc_called(this, "_ZN10S5328C3_nt2v6Ev");}
void  S5328C3_nt ::v7(){vfunc_called(this, "_ZN10S5328C3_nt2v7Ev");}
void  S5328C3_nt ::v8(){vfunc_called(this, "_ZN10S5328C3_nt2v8Ev");}
void  S5328C3_nt ::v9(){vfunc_called(this, "_ZN10S5328C3_nt2v9Ev");}
void  S5328C3_nt ::v10(){vfunc_called(this, "_ZN10S5328C3_nt3v10Ev");}
void  S5328C3_nt ::v11(){vfunc_called(this, "_ZN10S5328C3_nt3v11Ev");}
void  S5328C3_nt ::v12(){vfunc_called(this, "_ZN10S5328C3_nt3v12Ev");}
void  S5328C3_nt ::v13(){vfunc_called(this, "_ZN10S5328C3_nt3v13Ev");}
void  S5328C3_nt ::v14(){vfunc_called(this, "_ZN10S5328C3_nt3v14Ev");}
void  S5328C3_nt ::v15(){vfunc_called(this, "_ZN10S5328C3_nt3v15Ev");}
void  S5328C3_nt ::v16(){vfunc_called(this, "_ZN10S5328C3_nt3v16Ev");}
void  S5328C3_nt ::v17(){vfunc_called(this, "_ZN10S5328C3_nt3v17Ev");}
void  S5328C3_nt ::v18(){vfunc_called(this, "_ZN10S5328C3_nt3v18Ev");}
void  S5328C3_nt ::v19(){vfunc_called(this, "_ZN10S5328C3_nt3v19Ev");}
void  S5328C3_nt ::v20(){vfunc_called(this, "_ZN10S5328C3_nt3v20Ev");}
void  S5328C3_nt ::v21(){vfunc_called(this, "_ZN10S5328C3_nt3v21Ev");}
void  S5328C3_nt ::v22(){vfunc_called(this, "_ZN10S5328C3_nt3v22Ev");}
void  S5328C3_nt ::v23(){vfunc_called(this, "_ZN10S5328C3_nt3v23Ev");}
void  S5328C3_nt ::v24(){vfunc_called(this, "_ZN10S5328C3_nt3v24Ev");}
void  S5328C3_nt ::v25(){vfunc_called(this, "_ZN10S5328C3_nt3v25Ev");}
void  S5328C3_nt ::v26(){vfunc_called(this, "_ZN10S5328C3_nt3v26Ev");}
void  S5328C3_nt ::v27(){vfunc_called(this, "_ZN10S5328C3_nt3v27Ev");}
void  S5328C3_nt ::v28(){vfunc_called(this, "_ZN10S5328C3_nt3v28Ev");}
S5328C3_nt ::S5328C3_nt(){ note_ctor("S5328C3_nt", this);} // tgen

//skip512 S5328C3_nt

#else // __cplusplus

extern void _ZN10S5328C3_ntC1Ev();
extern void _ZN10S5328C3_ntD1Ev();
Name_Map name_map_S5328C3_nt[] = {
  NSPAIR(_ZN10S5328C3_ntC1Ev),
  NSPAIR(_ZN10S5328C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S5328C3_nt[];
extern void _ZN10S5328C3_ntD1Ev();
extern void _ZN10S5328C3_ntD0Ev();
extern void _ZN10S5328C3_nt2v6Ev();
extern void _ZN10S5328C3_nt2v7Ev();
extern void _ZN10S5328C3_nt2v8Ev();
extern void _ZN10S5328C3_nt2v9Ev();
extern void _ZN10S5328C3_nt3v10Ev();
extern void _ZN10S5328C3_nt3v11Ev();
extern void _ZN10S5328C3_nt3v12Ev();
extern void _ZN10S5328C3_nt3v13Ev();
extern void _ZN10S5328C3_nt3v14Ev();
extern void _ZN10S5328C3_nt3v15Ev();
extern void _ZN10S5328C3_nt3v16Ev();
extern void _ZN10S5328C3_nt3v17Ev();
extern void _ZN10S5328C3_nt3v18Ev();
extern void _ZN10S5328C3_nt3v19Ev();
extern void _ZN10S5328C3_nt3v20Ev();
extern void _ZN10S5328C3_nt3v21Ev();
extern void _ZN10S5328C3_nt3v22Ev();
extern void _ZN10S5328C3_nt3v23Ev();
extern void _ZN10S5328C3_nt3v24Ev();
extern void _ZN10S5328C3_nt3v25Ev();
extern void _ZN10S5328C3_nt3v26Ev();
extern void _ZN10S5328C3_nt3v27Ev();
extern void _ZN10S5328C3_nt3v28Ev();
static  VTBL_ENTRY vtc_S5328C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5328C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S5328C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v28Ev,
};
extern VTBL_ENTRY _ZTI10S5328C3_nt[];
VTBL_ENTRY *P__ZTI10S5328C3_nt = _ZTI10S5328C3_nt; 
extern  VTBL_ENTRY _ZTV10S5328C3_nt[];
Class_Descriptor cd_S5328C3_nt = {  "S5328C3_nt", // class name
  0,0,//no base classes
  &(vtc_S5328C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S5328C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S5328C3_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C13_nt  {
  __tsi64 s5328c13f0[2];
  void  mf5328c13(); // _ZN11S5328C13_nt9mf5328c13Ev
};
//SIG(-1 S5328C13_nt) C1{ m FL[2]}


void  S5328C13_nt ::mf5328c13(){}

//skip512 S5328C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C12_nt  {
  ::S5328C13_nt s5328c12f0;
  void  mf5328c12(); // _ZN11S5328C12_nt9mf5328c12Ev
};
//SIG(-1 S5328C12_nt) C1{ m FC2{ m FL[2]}}


void  S5328C12_nt ::mf5328c12(){}

//skip512 S5328C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C16_nt  {
  ::S5328C12_nt s5328c16f0;
  void  mf5328c16(); // _ZN11S5328C16_nt9mf5328c16Ev
};
//SIG(-1 S5328C16_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S5328C16_nt ::mf5328c16(){}

//skip512 S5328C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C17_nt  {
  ::S5328C12_nt s5328c17f0;
  ::S5328C12_nt s5328c17f1;
  ::S5328C12_nt s5328c17f2;
  ::S5328C12_nt s5328c17f3;
  void  mf5328c17(); // _ZN11S5328C17_nt9mf5328c17Ev
};
//SIG(-1 S5328C17_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S5328C17_nt ::mf5328c17(){}

//skip512 S5328C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C19_nt  {
  void *s5328c19f0;
  int s5328c19f1;
  ::S5328C7_nt s5328c19f2;
  void  mf5328c19(); // _ZN11S5328C19_nt9mf5328c19Ev
};
//SIG(-1 S5328C19_nt) C1{ m Fp Fi FC2{ m}}


void  S5328C19_nt ::mf5328c19(){}

//skip512 S5328C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C18_nt  {
  ::S5328C19_nt s5328c18f0;
  int s5328c18f1;
  void  mf5328c18(); // _ZN11S5328C18_nt9mf5328c18Ev
};
//SIG(-1 S5328C18_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S5328C18_nt ::mf5328c18(){}

//skip512 S5328C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C22  {
  void  mf5328c22(); // _ZN8S5328C229mf5328c22Ev
};
//SIG(-1 S5328C22) C1{ m}


void  S5328C22 ::mf5328c22(){}

static void Test_S5328C22()
{
  {
    init_simple_test("S5328C22");
    S5328C22 lv;
    check2(sizeof(lv), 1, "sizeof(S5328C22)");
    check2(__alignof__(lv), 1, "__alignof__(S5328C22)");
  }
}
static Arrange_To_Call_Me vS5328C22(Test_S5328C22, "S5328C22", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5328C22[];
VTBL_ENTRY *P__ZTI8S5328C22 = _ZTI8S5328C22; 
Class_Descriptor cd_S5328C22 = {  "S5328C22", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5328C22),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C21  {
  void *s5328c21f0;
  int s5328c21f1;
  ::S5328C22 s5328c21f2;
  ::S5328C22 s5328c21f3;
  void  mf5328c21(); // _ZN8S5328C219mf5328c21Ev
};
//SIG(-1 S5328C21) C1{ m Fp Fi FC2{ m} FC2}


void  S5328C21 ::mf5328c21(){}

static void Test_S5328C21()
{
  {
    init_simple_test("S5328C21");
    S5328C21 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5328C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5328C21)");
    check_field_offset(lv, s5328c21f0, 0, "S5328C21.s5328c21f0");
    check_field_offset(lv, s5328c21f1, ABISELECT(8,4), "S5328C21.s5328c21f1");
    check_field_offset(lv, s5328c21f2, ABISELECT(12,8), "S5328C21.s5328c21f2");
    check_field_offset(lv, s5328c21f3, ABISELECT(13,9), "S5328C21.s5328c21f3");
  }
}
static Arrange_To_Call_Me vS5328C21(Test_S5328C21, "S5328C21", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C26  {
  void  mf5328c26(); // _ZN8S5328C269mf5328c26Ev
};
//SIG(-1 S5328C26) C1{ m}


void  S5328C26 ::mf5328c26(){}

static void Test_S5328C26()
{
  {
    init_simple_test("S5328C26");
    S5328C26 lv;
    check2(sizeof(lv), 1, "sizeof(S5328C26)");
    check2(__alignof__(lv), 1, "__alignof__(S5328C26)");
  }
}
static Arrange_To_Call_Me vS5328C26(Test_S5328C26, "S5328C26", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5328C26[];
VTBL_ENTRY *P__ZTI8S5328C26 = _ZTI8S5328C26; 
Class_Descriptor cd_S5328C26 = {  "S5328C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5328C26),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C25  {
  void *s5328c25f0;
  int s5328c25f1;
  ::S5328C26 s5328c25f2;
  ::S5328C26 s5328c25f3;
  void  mf5328c25(); // _ZN8S5328C259mf5328c25Ev
};
//SIG(-1 S5328C25) C1{ m Fp Fi FC2{ m} FC2}


void  S5328C25 ::mf5328c25(){}

static void Test_S5328C25()
{
  {
    init_simple_test("S5328C25");
    S5328C25 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5328C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5328C25)");
    check_field_offset(lv, s5328c25f0, 0, "S5328C25.s5328c25f0");
    check_field_offset(lv, s5328c25f1, ABISELECT(8,4), "S5328C25.s5328c25f1");
    check_field_offset(lv, s5328c25f2, ABISELECT(12,8), "S5328C25.s5328c25f2");
    check_field_offset(lv, s5328c25f3, ABISELECT(13,9), "S5328C25.s5328c25f3");
  }
}
static Arrange_To_Call_Me vS5328C25(Test_S5328C25, "S5328C25", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S5328C25 = {  "S5328C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C24  : S5328C25 {
};
//SIG(-1 S5328C24) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S5328C24()
{
  extern Class_Descriptor cd_S5328C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S5328C24, buf);
    S5328C24 &lv = *(new (buf) S5328C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5328C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5328C24)");
    check_base_class_offset(lv, (S5328C25*), 0, "S5328C24");
    test_class_info(&lv, &cd_S5328C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5328C24(Test_S5328C24, "S5328C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S5328C25;
static Base_Class bases_S5328C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5328C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5328C24 = {  "S5328C24", // class name
  bases_S5328C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C29  {
  void  mf5328c29(); // _ZN8S5328C299mf5328c29Ev
};
//SIG(-1 S5328C29) C1{ m}


void  S5328C29 ::mf5328c29(){}

static void Test_S5328C29()
{
  {
    init_simple_test("S5328C29");
    S5328C29 lv;
    check2(sizeof(lv), 1, "sizeof(S5328C29)");
    check2(__alignof__(lv), 1, "__alignof__(S5328C29)");
  }
}
static Arrange_To_Call_Me vS5328C29(Test_S5328C29, "S5328C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5328C29[];
VTBL_ENTRY *P__ZTI8S5328C29 = _ZTI8S5328C29; 
Class_Descriptor cd_S5328C29 = {  "S5328C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5328C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C28_nt  {
  void *s5328c28f0;
  int s5328c28f1[2];
  ::S5328C29 s5328c28f2;
  void  mf5328c28(); // _ZN11S5328C28_nt9mf5328c28Ev
};
//SIG(-1 S5328C28_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S5328C28_nt ::mf5328c28(){}

//skip512 S5328C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C36  {
  void *s5328c36f0;
  int s5328c36f1[2];
  ::S5328C29 s5328c36f2;
  void  mf5328c36(); // _ZN8S5328C369mf5328c36Ev
};
//SIG(-1 S5328C36) C1{ m Fp Fi[2] FC2{ m}}


void  S5328C36 ::mf5328c36(){}

static void Test_S5328C36()
{
  {
    init_simple_test("S5328C36");
    S5328C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S5328C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5328C36)");
    check_field_offset(lv, s5328c36f0, 0, "S5328C36.s5328c36f0");
    check_field_offset(lv, s5328c36f1, ABISELECT(8,4), "S5328C36.s5328c36f1");
    check_field_offset(lv, s5328c36f2, ABISELECT(16,12), "S5328C36.s5328c36f2");
  }
}
static Arrange_To_Call_Me vS5328C36(Test_S5328C36, "S5328C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C2_nt  : S5328C3_nt {
  ::S5328C12_nt s5328c2f0;
  ::S5328C12_nt s5328c2f1;
  ::S5328C12_nt s5328c2f2;
  ::S5328C12_nt s5328c2f3;
  ::S5328C16_nt s5328c2f4;
  ::S5328C17_nt s5328c2f5;
  ::S5328C17_nt s5328c2f6;
  ::S5328C12_nt s5328c2f7;
  ::S5328C12_nt s5328c2f8;
  ::S5328C12_nt s5328c2f9;
  void *s5328c2f10;
  ::S5328C16_nt s5328c2f11;
  ::S5328C18_nt s5328c2f12;
  int s5328c2f13;
  void *s5328c2f14[7];
  ::S5328C21 s5328c2f15;
  int s5328c2f16:8;
  int s5328c2f17:8;
  int s5328c2f18:16;
  int s5328c2f19:16;
  int s5328c2f20:8;
  int s5328c2f21:8;
  int s5328c2f22:8;
  int s5328c2f23:32;
  int s5328c2f24:8;
  int s5328c2f25:4;
  int s5328c2f26:4;
  int s5328c2f27:4;
  int s5328c2f28:4;
  int s5328c2f29:4;
  int s5328c2f30:4;
  int s5328c2f31:4;
  int s5328c2f32:4;
  int s5328c2f33:4;
  int s5328c2f34:4;
  unsigned char s5328c2f35:1;
  unsigned char s5328c2f36:1;
  unsigned char s5328c2f37:1;
  unsigned char s5328c2f38:1;
  unsigned char s5328c2f39:1;
  unsigned char s5328c2f40:1;
  unsigned char s5328c2f41:1;
  unsigned char s5328c2f42:1;
  unsigned char s5328c2f43:1;
  unsigned char s5328c2f44:1;
  unsigned char s5328c2f45:1;
  unsigned char s5328c2f46:1;
  unsigned char s5328c2f47:1;
  unsigned char s5328c2f48:1;
  unsigned char s5328c2f49:1;
  unsigned char s5328c2f50:1;
  unsigned char s5328c2f51:1;
  unsigned char s5328c2f52:1;
  unsigned char s5328c2f53:1;
  unsigned char s5328c2f54:1;
  unsigned char s5328c2f55:1;
  unsigned char s5328c2f56:1;
  unsigned char s5328c2f57:1;
  unsigned char s5328c2f58:1;
  unsigned char s5328c2f59:1;
  unsigned char s5328c2f60:1;
  unsigned char s5328c2f61:1;
  unsigned char s5328c2f62:1;
  unsigned char s5328c2f63:1;
  unsigned char s5328c2f64:1;
  unsigned char s5328c2f65:1;
  unsigned char s5328c2f66:1;
  unsigned char s5328c2f67:1;
  unsigned char s5328c2f68:1;
  unsigned char s5328c2f69:1;
  unsigned char s5328c2f70:1;
  unsigned char s5328c2f71:1;
  unsigned char s5328c2f72:1;
  unsigned char s5328c2f73:1;
  unsigned char s5328c2f74:1;
  unsigned char s5328c2f75:1;
  int s5328c2f76[7];
  void *s5328c2f77[6];
  int s5328c2f78:8;
  int s5328c2f79:8;
  int s5328c2f80:8;
  int s5328c2f81:8;
  int s5328c2f82:8;
  int s5328c2f83:8;
  ::S5328C24 s5328c2f84;
  void *s5328c2f85[4];
  int s5328c2f86:8;
  int s5328c2f87:8;
  int s5328c2f88:8;
  int s5328c2f89:8;
  int s5328c2f90:8;
  int s5328c2f91:16;
  int s5328c2f92:16;
  int s5328c2f93:16;
  int s5328c2f94:4;
  int s5328c2f95:4;
  int s5328c2f96:4;
  int s5328c2f97:4;
  int s5328c2f98:4;
  int s5328c2f99:4;
  int s5328c2f100:4;
  int s5328c2f101:4;
  int s5328c2f102:4;
  int s5328c2f103:4;
  int s5328c2f104:4;
  int s5328c2f105:4;
  int s5328c2f106:8;
  int s5328c2f107:8;
  int s5328c2f108:8;
  void *s5328c2f109[7];
  ::S5328C28_nt s5328c2f110;
  void *s5328c2f111[2];
  int s5328c2f112:16;
  int s5328c2f113:16;
  ::S5328C24 s5328c2f114;
  ::S5328C28_nt s5328c2f115;
  ::S5328C36 s5328c2f116;
  void *s5328c2f117[2];
  int s5328c2f118:24;
  int s5328c2f119:8;
  void *s5328c2f120;
  virtual  ~S5328C2_nt(); // _ZN10S5328C2_ntD1Ev
  virtual void  v29(); // _ZN10S5328C2_nt3v29Ev
  virtual void  v30(); // _ZN10S5328C2_nt3v30Ev
  virtual void  v31(); // _ZN10S5328C2_nt3v31Ev
  virtual void  v32(); // _ZN10S5328C2_nt3v32Ev
  virtual void  v33(); // _ZN10S5328C2_nt3v33Ev
  virtual void  v34(); // _ZN10S5328C2_nt3v34Ev
  virtual void  v35(); // _ZN10S5328C2_nt3v35Ev
  virtual void  v36(); // _ZN10S5328C2_nt3v36Ev
  virtual void  v37(); // _ZN10S5328C2_nt3v37Ev
  virtual void  v38(); // _ZN10S5328C2_nt3v38Ev
  virtual void  v39(); // _ZN10S5328C2_nt3v39Ev
  virtual void  v40(); // _ZN10S5328C2_nt3v40Ev
  virtual void  v41(); // _ZN10S5328C2_nt3v41Ev
  virtual void  v42(); // _ZN10S5328C2_nt3v42Ev
  virtual void  v43(); // _ZN10S5328C2_nt3v43Ev
  virtual void  v44(); // _ZN10S5328C2_nt3v44Ev
  virtual void  v45(); // _ZN10S5328C2_nt3v45Ev
  virtual void  v46(); // _ZN10S5328C2_nt3v46Ev
  virtual void  v47(); // _ZN10S5328C2_nt3v47Ev
  virtual void  v48(); // _ZN10S5328C2_nt3v48Ev
  virtual void  v49(); // _ZN10S5328C2_nt3v49Ev
  virtual void  v50(); // _ZN10S5328C2_nt3v50Ev
  virtual void  v51(); // _ZN10S5328C2_nt3v51Ev
  virtual void  v52(); // _ZN10S5328C2_nt3v52Ev
  virtual void  v53(); // _ZN10S5328C2_nt3v53Ev
  virtual void  v54(); // _ZN10S5328C2_nt3v54Ev
  virtual void  v55(); // _ZN10S5328C2_nt3v55Ev
  virtual void  v56(); // _ZN10S5328C2_nt3v56Ev
  virtual void  v57(); // _ZN10S5328C2_nt3v57Ev
  virtual void  v58(); // _ZN10S5328C2_nt3v58Ev
  virtual void  v59(); // _ZN10S5328C2_nt3v59Ev
  virtual void  v60(); // _ZN10S5328C2_nt3v60Ev
  virtual void  v61(); // _ZN10S5328C2_nt3v61Ev
  virtual void  v62(); // _ZN10S5328C2_nt3v62Ev
  virtual void  v63(); // _ZN10S5328C2_nt3v63Ev
  virtual void  v64(); // _ZN10S5328C2_nt3v64Ev
  virtual void  v65(); // _ZN10S5328C2_nt3v65Ev
  virtual void  v66(); // _ZN10S5328C2_nt3v66Ev
  virtual void  v67(); // _ZN10S5328C2_nt3v67Ev
  virtual void  v68(); // _ZN10S5328C2_nt3v68Ev
  virtual void  v69(); // _ZN10S5328C2_nt3v69Ev
  virtual void  v70(); // _ZN10S5328C2_nt3v70Ev
  virtual void  v71(); // _ZN10S5328C2_nt3v71Ev
  virtual void  v72(); // _ZN10S5328C2_nt3v72Ev
  virtual void  v73(); // _ZN10S5328C2_nt3v73Ev
  virtual void  v74(); // _ZN10S5328C2_nt3v74Ev
  virtual void  v75(); // _ZN10S5328C2_nt3v75Ev
  virtual void  v76(); // _ZN10S5328C2_nt3v76Ev
  virtual void  v77(); // _ZN10S5328C2_nt3v77Ev
  virtual void  v78(); // _ZN10S5328C2_nt3v78Ev
  virtual void  v79(); // _ZN10S5328C2_nt3v79Ev
  virtual void  v80(); // _ZN10S5328C2_nt3v80Ev
  virtual void  v81(); // _ZN10S5328C2_nt3v81Ev
  virtual void  v82(); // _ZN10S5328C2_nt3v82Ev
  virtual void  v83(); // _ZN10S5328C2_nt3v83Ev
  virtual void  v84(); // _ZN10S5328C2_nt3v84Ev
  virtual void  v85(); // _ZN10S5328C2_nt3v85Ev
  virtual void  v86(); // _ZN10S5328C2_nt3v86Ev
  virtual void  v87(); // _ZN10S5328C2_nt3v87Ev
  virtual void  v88(); // _ZN10S5328C2_nt3v88Ev
  virtual void  v89(); // _ZN10S5328C2_nt3v89Ev
  virtual void  v90(); // _ZN10S5328C2_nt3v90Ev
  virtual void  v91(); // _ZN10S5328C2_nt3v91Ev
  virtual void  v92(); // _ZN10S5328C2_nt3v92Ev
  virtual void  v93(); // _ZN10S5328C2_nt3v93Ev
  virtual void  v94(); // _ZN10S5328C2_nt3v94Ev
  virtual void  v95(); // _ZN10S5328C2_nt3v95Ev
  virtual void  v96(); // _ZN10S5328C2_nt3v96Ev
  virtual void  v97(); // _ZN10S5328C2_nt3v97Ev
  virtual void  v98(); // _ZN10S5328C2_nt3v98Ev
  virtual void  v99(); // _ZN10S5328C2_nt3v99Ev
  virtual void  v100(); // _ZN10S5328C2_nt4v100Ev
  virtual void  v101(); // _ZN10S5328C2_nt4v101Ev
  virtual void  v102(); // _ZN10S5328C2_nt4v102Ev
  virtual void  v103(); // _ZN10S5328C2_nt4v103Ev
  virtual void  v104(); // _ZN10S5328C2_nt4v104Ev
  virtual void  v105(); // _ZN10S5328C2_nt4v105Ev
  virtual void  v106(); // _ZN10S5328C2_nt4v106Ev
  S5328C2_nt(); // tgen
};
//SIG(-1 S5328C2_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S5328C2_nt ::~S5328C2_nt(){ note_dtor("S5328C2_nt", this);}
void  S5328C2_nt ::v29(){vfunc_called(this, "_ZN10S5328C2_nt3v29Ev");}
void  S5328C2_nt ::v30(){vfunc_called(this, "_ZN10S5328C2_nt3v30Ev");}
void  S5328C2_nt ::v31(){vfunc_called(this, "_ZN10S5328C2_nt3v31Ev");}
void  S5328C2_nt ::v32(){vfunc_called(this, "_ZN10S5328C2_nt3v32Ev");}
void  S5328C2_nt ::v33(){vfunc_called(this, "_ZN10S5328C2_nt3v33Ev");}
void  S5328C2_nt ::v34(){vfunc_called(this, "_ZN10S5328C2_nt3v34Ev");}
void  S5328C2_nt ::v35(){vfunc_called(this, "_ZN10S5328C2_nt3v35Ev");}
void  S5328C2_nt ::v36(){vfunc_called(this, "_ZN10S5328C2_nt3v36Ev");}
void  S5328C2_nt ::v37(){vfunc_called(this, "_ZN10S5328C2_nt3v37Ev");}
void  S5328C2_nt ::v38(){vfunc_called(this, "_ZN10S5328C2_nt3v38Ev");}
void  S5328C2_nt ::v39(){vfunc_called(this, "_ZN10S5328C2_nt3v39Ev");}
void  S5328C2_nt ::v40(){vfunc_called(this, "_ZN10S5328C2_nt3v40Ev");}
void  S5328C2_nt ::v41(){vfunc_called(this, "_ZN10S5328C2_nt3v41Ev");}
void  S5328C2_nt ::v42(){vfunc_called(this, "_ZN10S5328C2_nt3v42Ev");}
void  S5328C2_nt ::v43(){vfunc_called(this, "_ZN10S5328C2_nt3v43Ev");}
void  S5328C2_nt ::v44(){vfunc_called(this, "_ZN10S5328C2_nt3v44Ev");}
void  S5328C2_nt ::v45(){vfunc_called(this, "_ZN10S5328C2_nt3v45Ev");}
void  S5328C2_nt ::v46(){vfunc_called(this, "_ZN10S5328C2_nt3v46Ev");}
void  S5328C2_nt ::v47(){vfunc_called(this, "_ZN10S5328C2_nt3v47Ev");}
void  S5328C2_nt ::v48(){vfunc_called(this, "_ZN10S5328C2_nt3v48Ev");}
void  S5328C2_nt ::v49(){vfunc_called(this, "_ZN10S5328C2_nt3v49Ev");}
void  S5328C2_nt ::v50(){vfunc_called(this, "_ZN10S5328C2_nt3v50Ev");}
void  S5328C2_nt ::v51(){vfunc_called(this, "_ZN10S5328C2_nt3v51Ev");}
void  S5328C2_nt ::v52(){vfunc_called(this, "_ZN10S5328C2_nt3v52Ev");}
void  S5328C2_nt ::v53(){vfunc_called(this, "_ZN10S5328C2_nt3v53Ev");}
void  S5328C2_nt ::v54(){vfunc_called(this, "_ZN10S5328C2_nt3v54Ev");}
void  S5328C2_nt ::v55(){vfunc_called(this, "_ZN10S5328C2_nt3v55Ev");}
void  S5328C2_nt ::v56(){vfunc_called(this, "_ZN10S5328C2_nt3v56Ev");}
void  S5328C2_nt ::v57(){vfunc_called(this, "_ZN10S5328C2_nt3v57Ev");}
void  S5328C2_nt ::v58(){vfunc_called(this, "_ZN10S5328C2_nt3v58Ev");}
void  S5328C2_nt ::v59(){vfunc_called(this, "_ZN10S5328C2_nt3v59Ev");}
void  S5328C2_nt ::v60(){vfunc_called(this, "_ZN10S5328C2_nt3v60Ev");}
void  S5328C2_nt ::v61(){vfunc_called(this, "_ZN10S5328C2_nt3v61Ev");}
void  S5328C2_nt ::v62(){vfunc_called(this, "_ZN10S5328C2_nt3v62Ev");}
void  S5328C2_nt ::v63(){vfunc_called(this, "_ZN10S5328C2_nt3v63Ev");}
void  S5328C2_nt ::v64(){vfunc_called(this, "_ZN10S5328C2_nt3v64Ev");}
void  S5328C2_nt ::v65(){vfunc_called(this, "_ZN10S5328C2_nt3v65Ev");}
void  S5328C2_nt ::v66(){vfunc_called(this, "_ZN10S5328C2_nt3v66Ev");}
void  S5328C2_nt ::v67(){vfunc_called(this, "_ZN10S5328C2_nt3v67Ev");}
void  S5328C2_nt ::v68(){vfunc_called(this, "_ZN10S5328C2_nt3v68Ev");}
void  S5328C2_nt ::v69(){vfunc_called(this, "_ZN10S5328C2_nt3v69Ev");}
void  S5328C2_nt ::v70(){vfunc_called(this, "_ZN10S5328C2_nt3v70Ev");}
void  S5328C2_nt ::v71(){vfunc_called(this, "_ZN10S5328C2_nt3v71Ev");}
void  S5328C2_nt ::v72(){vfunc_called(this, "_ZN10S5328C2_nt3v72Ev");}
void  S5328C2_nt ::v73(){vfunc_called(this, "_ZN10S5328C2_nt3v73Ev");}
void  S5328C2_nt ::v74(){vfunc_called(this, "_ZN10S5328C2_nt3v74Ev");}
void  S5328C2_nt ::v75(){vfunc_called(this, "_ZN10S5328C2_nt3v75Ev");}
void  S5328C2_nt ::v76(){vfunc_called(this, "_ZN10S5328C2_nt3v76Ev");}
void  S5328C2_nt ::v77(){vfunc_called(this, "_ZN10S5328C2_nt3v77Ev");}
void  S5328C2_nt ::v78(){vfunc_called(this, "_ZN10S5328C2_nt3v78Ev");}
void  S5328C2_nt ::v79(){vfunc_called(this, "_ZN10S5328C2_nt3v79Ev");}
void  S5328C2_nt ::v80(){vfunc_called(this, "_ZN10S5328C2_nt3v80Ev");}
void  S5328C2_nt ::v81(){vfunc_called(this, "_ZN10S5328C2_nt3v81Ev");}
void  S5328C2_nt ::v82(){vfunc_called(this, "_ZN10S5328C2_nt3v82Ev");}
void  S5328C2_nt ::v83(){vfunc_called(this, "_ZN10S5328C2_nt3v83Ev");}
void  S5328C2_nt ::v84(){vfunc_called(this, "_ZN10S5328C2_nt3v84Ev");}
void  S5328C2_nt ::v85(){vfunc_called(this, "_ZN10S5328C2_nt3v85Ev");}
void  S5328C2_nt ::v86(){vfunc_called(this, "_ZN10S5328C2_nt3v86Ev");}
void  S5328C2_nt ::v87(){vfunc_called(this, "_ZN10S5328C2_nt3v87Ev");}
void  S5328C2_nt ::v88(){vfunc_called(this, "_ZN10S5328C2_nt3v88Ev");}
void  S5328C2_nt ::v89(){vfunc_called(this, "_ZN10S5328C2_nt3v89Ev");}
void  S5328C2_nt ::v90(){vfunc_called(this, "_ZN10S5328C2_nt3v90Ev");}
void  S5328C2_nt ::v91(){vfunc_called(this, "_ZN10S5328C2_nt3v91Ev");}
void  S5328C2_nt ::v92(){vfunc_called(this, "_ZN10S5328C2_nt3v92Ev");}
void  S5328C2_nt ::v93(){vfunc_called(this, "_ZN10S5328C2_nt3v93Ev");}
void  S5328C2_nt ::v94(){vfunc_called(this, "_ZN10S5328C2_nt3v94Ev");}
void  S5328C2_nt ::v95(){vfunc_called(this, "_ZN10S5328C2_nt3v95Ev");}
void  S5328C2_nt ::v96(){vfunc_called(this, "_ZN10S5328C2_nt3v96Ev");}
void  S5328C2_nt ::v97(){vfunc_called(this, "_ZN10S5328C2_nt3v97Ev");}
void  S5328C2_nt ::v98(){vfunc_called(this, "_ZN10S5328C2_nt3v98Ev");}
void  S5328C2_nt ::v99(){vfunc_called(this, "_ZN10S5328C2_nt3v99Ev");}
void  S5328C2_nt ::v100(){vfunc_called(this, "_ZN10S5328C2_nt4v100Ev");}
void  S5328C2_nt ::v101(){vfunc_called(this, "_ZN10S5328C2_nt4v101Ev");}
void  S5328C2_nt ::v102(){vfunc_called(this, "_ZN10S5328C2_nt4v102Ev");}
void  S5328C2_nt ::v103(){vfunc_called(this, "_ZN10S5328C2_nt4v103Ev");}
void  S5328C2_nt ::v104(){vfunc_called(this, "_ZN10S5328C2_nt4v104Ev");}
void  S5328C2_nt ::v105(){vfunc_called(this, "_ZN10S5328C2_nt4v105Ev");}
void  S5328C2_nt ::v106(){vfunc_called(this, "_ZN10S5328C2_nt4v106Ev");}
S5328C2_nt ::S5328C2_nt(){ note_ctor("S5328C2_nt", this);} // tgen

//skip512 S5328C2_nt

#else // __cplusplus

extern void _ZN10S5328C2_ntC1Ev();
extern void _ZN10S5328C2_ntD1Ev();
Name_Map name_map_S5328C2_nt[] = {
  NSPAIR(_ZN10S5328C2_ntC1Ev),
  NSPAIR(_ZN10S5328C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5328C3_nt;
extern VTBL_ENTRY _ZTI10S5328C3_nt[];
extern  VTBL_ENTRY _ZTV10S5328C3_nt[];
static Base_Class bases_S5328C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5328C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S5328C2_nt[];
extern void _ZN10S5328C2_ntD1Ev();
extern void _ZN10S5328C2_ntD0Ev();
extern void _ZN10S5328C3_nt2v6Ev();
extern void _ZN10S5328C3_nt2v7Ev();
extern void _ZN10S5328C3_nt2v8Ev();
extern void _ZN10S5328C3_nt2v9Ev();
extern void _ZN10S5328C3_nt3v10Ev();
extern void _ZN10S5328C3_nt3v11Ev();
extern void _ZN10S5328C3_nt3v12Ev();
extern void _ZN10S5328C3_nt3v13Ev();
extern void _ZN10S5328C3_nt3v14Ev();
extern void _ZN10S5328C3_nt3v15Ev();
extern void _ZN10S5328C3_nt3v16Ev();
extern void _ZN10S5328C3_nt3v17Ev();
extern void _ZN10S5328C3_nt3v18Ev();
extern void _ZN10S5328C3_nt3v19Ev();
extern void _ZN10S5328C3_nt3v20Ev();
extern void _ZN10S5328C3_nt3v21Ev();
extern void _ZN10S5328C3_nt3v22Ev();
extern void _ZN10S5328C3_nt3v23Ev();
extern void _ZN10S5328C3_nt3v24Ev();
extern void _ZN10S5328C3_nt3v25Ev();
extern void _ZN10S5328C3_nt3v26Ev();
extern void _ZN10S5328C3_nt3v27Ev();
extern void _ZN10S5328C3_nt3v28Ev();
extern void _ZN10S5328C2_nt3v29Ev();
extern void _ZN10S5328C2_nt3v30Ev();
extern void _ZN10S5328C2_nt3v31Ev();
extern void _ZN10S5328C2_nt3v32Ev();
extern void _ZN10S5328C2_nt3v33Ev();
extern void _ZN10S5328C2_nt3v34Ev();
extern void _ZN10S5328C2_nt3v35Ev();
extern void _ZN10S5328C2_nt3v36Ev();
extern void _ZN10S5328C2_nt3v37Ev();
extern void _ZN10S5328C2_nt3v38Ev();
extern void _ZN10S5328C2_nt3v39Ev();
extern void _ZN10S5328C2_nt3v40Ev();
extern void _ZN10S5328C2_nt3v41Ev();
extern void _ZN10S5328C2_nt3v42Ev();
extern void _ZN10S5328C2_nt3v43Ev();
extern void _ZN10S5328C2_nt3v44Ev();
extern void _ZN10S5328C2_nt3v45Ev();
extern void _ZN10S5328C2_nt3v46Ev();
extern void _ZN10S5328C2_nt3v47Ev();
extern void _ZN10S5328C2_nt3v48Ev();
extern void _ZN10S5328C2_nt3v49Ev();
extern void _ZN10S5328C2_nt3v50Ev();
extern void _ZN10S5328C2_nt3v51Ev();
extern void _ZN10S5328C2_nt3v52Ev();
extern void _ZN10S5328C2_nt3v53Ev();
extern void _ZN10S5328C2_nt3v54Ev();
extern void _ZN10S5328C2_nt3v55Ev();
extern void _ZN10S5328C2_nt3v56Ev();
extern void _ZN10S5328C2_nt3v57Ev();
extern void _ZN10S5328C2_nt3v58Ev();
extern void _ZN10S5328C2_nt3v59Ev();
extern void _ZN10S5328C2_nt3v60Ev();
extern void _ZN10S5328C2_nt3v61Ev();
extern void _ZN10S5328C2_nt3v62Ev();
extern void _ZN10S5328C2_nt3v63Ev();
extern void _ZN10S5328C2_nt3v64Ev();
extern void _ZN10S5328C2_nt3v65Ev();
extern void _ZN10S5328C2_nt3v66Ev();
extern void _ZN10S5328C2_nt3v67Ev();
extern void _ZN10S5328C2_nt3v68Ev();
extern void _ZN10S5328C2_nt3v69Ev();
extern void _ZN10S5328C2_nt3v70Ev();
extern void _ZN10S5328C2_nt3v71Ev();
extern void _ZN10S5328C2_nt3v72Ev();
extern void _ZN10S5328C2_nt3v73Ev();
extern void _ZN10S5328C2_nt3v74Ev();
extern void _ZN10S5328C2_nt3v75Ev();
extern void _ZN10S5328C2_nt3v76Ev();
extern void _ZN10S5328C2_nt3v77Ev();
extern void _ZN10S5328C2_nt3v78Ev();
extern void _ZN10S5328C2_nt3v79Ev();
extern void _ZN10S5328C2_nt3v80Ev();
extern void _ZN10S5328C2_nt3v81Ev();
extern void _ZN10S5328C2_nt3v82Ev();
extern void _ZN10S5328C2_nt3v83Ev();
extern void _ZN10S5328C2_nt3v84Ev();
extern void _ZN10S5328C2_nt3v85Ev();
extern void _ZN10S5328C2_nt3v86Ev();
extern void _ZN10S5328C2_nt3v87Ev();
extern void _ZN10S5328C2_nt3v88Ev();
extern void _ZN10S5328C2_nt3v89Ev();
extern void _ZN10S5328C2_nt3v90Ev();
extern void _ZN10S5328C2_nt3v91Ev();
extern void _ZN10S5328C2_nt3v92Ev();
extern void _ZN10S5328C2_nt3v93Ev();
extern void _ZN10S5328C2_nt3v94Ev();
extern void _ZN10S5328C2_nt3v95Ev();
extern void _ZN10S5328C2_nt3v96Ev();
extern void _ZN10S5328C2_nt3v97Ev();
extern void _ZN10S5328C2_nt3v98Ev();
extern void _ZN10S5328C2_nt3v99Ev();
extern void _ZN10S5328C2_nt4v100Ev();
extern void _ZN10S5328C2_nt4v101Ev();
extern void _ZN10S5328C2_nt4v102Ev();
extern void _ZN10S5328C2_nt4v103Ev();
extern void _ZN10S5328C2_nt4v104Ev();
extern void _ZN10S5328C2_nt4v105Ev();
extern void _ZN10S5328C2_nt4v106Ev();
static  VTBL_ENTRY vtc_S5328C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5328C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S5328C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v106Ev,
};
extern VTBL_ENTRY _ZTI10S5328C2_nt[];
VTBL_ENTRY *P__ZTI10S5328C2_nt = _ZTI10S5328C2_nt; 
extern  VTBL_ENTRY _ZTV10S5328C2_nt[];
Class_Descriptor cd_S5328C2_nt = {  "S5328C2_nt", // class name
  bases_S5328C2_nt, 1,
  &(vtc_S5328C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S5328C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S5328C2_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5328C1  : S5328C2_nt {
  ::S5328C12_nt s5328c1f0;
  ::S5328C12_nt s5328c1f1;
  char s5328c1f2[2];
  virtual  ~S5328C1(); // _ZN7S5328C1D1Ev
  virtual void  v1(); // _ZN7S5328C12v1Ev
  virtual void  v2(); // _ZN7S5328C12v2Ev
  virtual void  v3(); // _ZN7S5328C12v3Ev
  virtual void  v4(); // _ZN7S5328C12v4Ev
  virtual void  v5(); // _ZN7S5328C12v5Ev
  S5328C1(); // tgen
};
//SIG(1 S5328C1) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 FC8 FC8 Fc[2]}


 S5328C1 ::~S5328C1(){ note_dtor("S5328C1", this);}
void  S5328C1 ::v1(){vfunc_called(this, "_ZN7S5328C12v1Ev");}
void  S5328C1 ::v2(){vfunc_called(this, "_ZN7S5328C12v2Ev");}
void  S5328C1 ::v3(){vfunc_called(this, "_ZN7S5328C12v3Ev");}
void  S5328C1 ::v4(){vfunc_called(this, "_ZN7S5328C12v4Ev");}
void  S5328C1 ::v5(){vfunc_called(this, "_ZN7S5328C12v5Ev");}
S5328C1 ::S5328C1(){ note_ctor("S5328C1", this);} // tgen

static void Test_S5328C1()
{
  extern Class_Descriptor cd_S5328C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(110,168)];
    init_test(&cd_S5328C1, buf);
    S5328C1 *dp, &lv = *(dp=new (buf) S5328C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(872,668), "sizeof(S5328C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5328C1)");
    check_base_class_offset(lv, (S5328C3_nt*)(S5328C2_nt*), 0, "S5328C1");
    check_base_class_offset(lv, (S5328C2_nt*), 0, "S5328C1");
    check_field_offset(lv, s5328c1f0, ABISELECT(832,632), "S5328C1.s5328c1f0");
    check_field_offset(lv, s5328c1f1, ABISELECT(848,648), "S5328C1.s5328c1f1");
    check_field_offset(lv, s5328c1f2, ABISELECT(864,664), "S5328C1.s5328c1f2");
    test_class_info(&lv, &cd_S5328C1);
    dp->~S5328C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5328C1(Test_S5328C1, "S5328C1", ABISELECT(872,668));

#else // __cplusplus

extern void _ZN7S5328C1C1Ev();
extern void _ZN7S5328C1D1Ev();
Name_Map name_map_S5328C1[] = {
  NSPAIR(_ZN7S5328C1C1Ev),
  NSPAIR(_ZN7S5328C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5328C3_nt;
extern VTBL_ENTRY _ZTI10S5328C3_nt[];
extern  VTBL_ENTRY _ZTV10S5328C3_nt[];
extern Class_Descriptor cd_S5328C2_nt;
extern VTBL_ENTRY _ZTI10S5328C2_nt[];
extern  VTBL_ENTRY _ZTV10S5328C2_nt[];
static Base_Class bases_S5328C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5328C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5328C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S5328C1[];
extern void _ZN7S5328C1D1Ev();
extern void _ZN7S5328C1D0Ev();
extern void _ZN10S5328C3_nt2v6Ev();
extern void _ZN10S5328C3_nt2v7Ev();
extern void _ZN10S5328C3_nt2v8Ev();
extern void _ZN10S5328C3_nt2v9Ev();
extern void _ZN10S5328C3_nt3v10Ev();
extern void _ZN10S5328C3_nt3v11Ev();
extern void _ZN10S5328C3_nt3v12Ev();
extern void _ZN10S5328C3_nt3v13Ev();
extern void _ZN10S5328C3_nt3v14Ev();
extern void _ZN10S5328C3_nt3v15Ev();
extern void _ZN10S5328C3_nt3v16Ev();
extern void _ZN10S5328C3_nt3v17Ev();
extern void _ZN10S5328C3_nt3v18Ev();
extern void _ZN10S5328C3_nt3v19Ev();
extern void _ZN10S5328C3_nt3v20Ev();
extern void _ZN10S5328C3_nt3v21Ev();
extern void _ZN10S5328C3_nt3v22Ev();
extern void _ZN10S5328C3_nt3v23Ev();
extern void _ZN10S5328C3_nt3v24Ev();
extern void _ZN10S5328C3_nt3v25Ev();
extern void _ZN10S5328C3_nt3v26Ev();
extern void _ZN10S5328C3_nt3v27Ev();
extern void _ZN10S5328C3_nt3v28Ev();
extern void _ZN10S5328C2_nt3v29Ev();
extern void _ZN10S5328C2_nt3v30Ev();
extern void _ZN10S5328C2_nt3v31Ev();
extern void _ZN10S5328C2_nt3v32Ev();
extern void _ZN10S5328C2_nt3v33Ev();
extern void _ZN10S5328C2_nt3v34Ev();
extern void _ZN10S5328C2_nt3v35Ev();
extern void _ZN10S5328C2_nt3v36Ev();
extern void _ZN10S5328C2_nt3v37Ev();
extern void _ZN10S5328C2_nt3v38Ev();
extern void _ZN10S5328C2_nt3v39Ev();
extern void _ZN10S5328C2_nt3v40Ev();
extern void _ZN10S5328C2_nt3v41Ev();
extern void _ZN10S5328C2_nt3v42Ev();
extern void _ZN10S5328C2_nt3v43Ev();
extern void _ZN10S5328C2_nt3v44Ev();
extern void _ZN10S5328C2_nt3v45Ev();
extern void _ZN10S5328C2_nt3v46Ev();
extern void _ZN10S5328C2_nt3v47Ev();
extern void _ZN10S5328C2_nt3v48Ev();
extern void _ZN10S5328C2_nt3v49Ev();
extern void _ZN10S5328C2_nt3v50Ev();
extern void _ZN10S5328C2_nt3v51Ev();
extern void _ZN10S5328C2_nt3v52Ev();
extern void _ZN10S5328C2_nt3v53Ev();
extern void _ZN10S5328C2_nt3v54Ev();
extern void _ZN10S5328C2_nt3v55Ev();
extern void _ZN10S5328C2_nt3v56Ev();
extern void _ZN10S5328C2_nt3v57Ev();
extern void _ZN10S5328C2_nt3v58Ev();
extern void _ZN10S5328C2_nt3v59Ev();
extern void _ZN10S5328C2_nt3v60Ev();
extern void _ZN10S5328C2_nt3v61Ev();
extern void _ZN10S5328C2_nt3v62Ev();
extern void _ZN10S5328C2_nt3v63Ev();
extern void _ZN10S5328C2_nt3v64Ev();
extern void _ZN10S5328C2_nt3v65Ev();
extern void _ZN10S5328C2_nt3v66Ev();
extern void _ZN10S5328C2_nt3v67Ev();
extern void _ZN10S5328C2_nt3v68Ev();
extern void _ZN10S5328C2_nt3v69Ev();
extern void _ZN10S5328C2_nt3v70Ev();
extern void _ZN10S5328C2_nt3v71Ev();
extern void _ZN10S5328C2_nt3v72Ev();
extern void _ZN10S5328C2_nt3v73Ev();
extern void _ZN10S5328C2_nt3v74Ev();
extern void _ZN10S5328C2_nt3v75Ev();
extern void _ZN10S5328C2_nt3v76Ev();
extern void _ZN10S5328C2_nt3v77Ev();
extern void _ZN10S5328C2_nt3v78Ev();
extern void _ZN10S5328C2_nt3v79Ev();
extern void _ZN10S5328C2_nt3v80Ev();
extern void _ZN10S5328C2_nt3v81Ev();
extern void _ZN10S5328C2_nt3v82Ev();
extern void _ZN10S5328C2_nt3v83Ev();
extern void _ZN10S5328C2_nt3v84Ev();
extern void _ZN10S5328C2_nt3v85Ev();
extern void _ZN10S5328C2_nt3v86Ev();
extern void _ZN10S5328C2_nt3v87Ev();
extern void _ZN10S5328C2_nt3v88Ev();
extern void _ZN10S5328C2_nt3v89Ev();
extern void _ZN10S5328C2_nt3v90Ev();
extern void _ZN10S5328C2_nt3v91Ev();
extern void _ZN10S5328C2_nt3v92Ev();
extern void _ZN10S5328C2_nt3v93Ev();
extern void _ZN10S5328C2_nt3v94Ev();
extern void _ZN10S5328C2_nt3v95Ev();
extern void _ZN10S5328C2_nt3v96Ev();
extern void _ZN10S5328C2_nt3v97Ev();
extern void _ZN10S5328C2_nt3v98Ev();
extern void _ZN10S5328C2_nt3v99Ev();
extern void _ZN10S5328C2_nt4v100Ev();
extern void _ZN10S5328C2_nt4v101Ev();
extern void _ZN10S5328C2_nt4v102Ev();
extern void _ZN10S5328C2_nt4v103Ev();
extern void _ZN10S5328C2_nt4v104Ev();
extern void _ZN10S5328C2_nt4v105Ev();
extern void _ZN10S5328C2_nt4v106Ev();
extern void _ZN7S5328C12v1Ev();
extern void _ZN7S5328C12v2Ev();
extern void _ZN7S5328C12v3Ev();
extern void _ZN7S5328C12v4Ev();
extern void _ZN7S5328C12v5Ev();
static  VTBL_ENTRY vtc_S5328C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5328C1[0]),
  (VTBL_ENTRY)&_ZN7S5328C1D1Ev,
  (VTBL_ENTRY)&_ZN7S5328C1D0Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5328C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S5328C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN7S5328C12v1Ev,
  (VTBL_ENTRY)&_ZN7S5328C12v2Ev,
  (VTBL_ENTRY)&_ZN7S5328C12v3Ev,
  (VTBL_ENTRY)&_ZN7S5328C12v4Ev,
  (VTBL_ENTRY)&_ZN7S5328C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S5328C1[];
extern  VTBL_ENTRY _ZTV7S5328C1[];
Class_Descriptor cd_S5328C1 = {  "S5328C1", // class name
  bases_S5328C1, 2,
  &(vtc_S5328C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(872,668), // object size
  NSPAIRA(_ZTI7S5328C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S5328C1),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C2_nt  {
  void *s10882c2f0;
  short s10882c2f1;
  void *s10882c2f2;
  short s10882c2f3[2];
};
//SIG(-1 S10882C2_nt) C1{ Fp Fs Fp Fs[2]}



//skip512 S10882C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C9_nt  {
  void *s10882c9f0;
  void *s10882c9f1;
  void *s10882c9f2[2];
  long s10882c9f3;
  long s10882c9f4;
  long s10882c9f5;
  long s10882c9f6[5];
  long s10882c9f7;
  short s10882c9f8;
  char s10882c9f9;
  char s10882c9f10;
  char s10882c9f11;
};
//SIG(-1 S10882C9_nt) C1{ Fp[4] Fl[9] Fs Fc[3]}



//skip512 S10882C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C8_nt  {
  short s10882c8f0;
  short s10882c8f1;
  short s10882c8f2;
  ::S10882C9_nt s10882c8f3;
  char s10882c8f4;
};
//SIG(-1 S10882C8_nt) C1{ Fs[3] FC2{ Fp[4] Fl[9] Fs Fc[3]} Fc}



//skip512 S10882C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C10_nt  {
  short s10882c10f0;
  short s10882c10f1;
  short s10882c10f2;
};
//SIG(-1 S10882C10_nt) C1{ Fs[3]}



//skip512 S10882C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C7_nt  {
  void *s10882c7f0;
  ::S10882C8_nt s10882c7f1;
  ::S10882C10_nt s10882c7f2;
};
//SIG(-1 S10882C7_nt) C1{ Fp FC2{ Fs[3] FC3{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC4{ Fs[3]}}



//skip512 S10882C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C6_nt  {
  short s10882c6f0;
  ::S10882C7_nt s10882c6f1;
};
//SIG(1 S10882C6_nt) C1{ Fs FC2{ Fp FC3{ Fs[3] FC4{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC5{ Fs[3]}}}



//skip512 S10882C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C5_nt  {
  short s10882c5f0;
  short s10882c5f1;
  long s10882c5f2;
  ::S10882C6_nt s10882c5f3[2];
  char s10882c5f4;
  char s10882c5f5;
  char s10882c5f6;
  void *s10882c5f7;
};
//SIG(1 S10882C5_nt) C1{ Fs[2] Fl FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[2] Fc[3] Fp}



//skip512 S10882C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C13_nt  {
  short s10882c13f0;
  short s10882c13f1;
};
//SIG(-1 S10882C13_nt) C1{ Fs[2]}



//skip512 S10882C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C12  {
  char s10882c12f0;
  char s10882c12f1;
  void *s10882c12f2;
  void *s10882c12f3;
  void *s10882c12f4[2];
  ::S10882C13_nt s10882c12f5[3];
  void *s10882c12f6;
};
//SIG(1 S10882C12) C1{ Fc[2] Fp[4] FC2{ Fs[2]}[3] Fp}



static void Test_S10882C12()
{
  {
    init_simple_test("S10882C12");
    S10882C12 lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S10882C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C12)");
    check_field_offset(lv, s10882c12f0, 0, "S10882C12.s10882c12f0");
    check_field_offset(lv, s10882c12f1, 1, "S10882C12.s10882c12f1");
    check_field_offset(lv, s10882c12f2, ABISELECT(8,4), "S10882C12.s10882c12f2");
    check_field_offset(lv, s10882c12f3, ABISELECT(16,8), "S10882C12.s10882c12f3");
    check_field_offset(lv, s10882c12f4, ABISELECT(24,12), "S10882C12.s10882c12f4");
    check_field_offset(lv, s10882c12f5, ABISELECT(40,20), "S10882C12.s10882c12f5");
    check_field_offset(lv, s10882c12f6, ABISELECT(56,32), "S10882C12.s10882c12f6");
  }
}
static Arrange_To_Call_Me vS10882C12(Test_S10882C12, "S10882C12", ABISELECT(64,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C11  {
  ::S10882C12 s10882c11f0[12];
  void *s10882c11f1[3];
  short s10882c11f2;
  short s10882c11f3[41];
};
//SIG(-1 S10882C11) C1{ FC2{ Fc[2] Fp[4] FC3{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]}



static void Test_S10882C11()
{
  {
    init_simple_test("S10882C11");
    S10882C11 lv;
    check2(sizeof(lv), ABISELECT(880,528), "sizeof(S10882C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C11)");
    check_field_offset(lv, s10882c11f0, 0, "S10882C11.s10882c11f0");
    check_field_offset(lv, s10882c11f1, ABISELECT(768,432), "S10882C11.s10882c11f1");
    check_field_offset(lv, s10882c11f2, ABISELECT(792,444), "S10882C11.s10882c11f2");
    check_field_offset(lv, s10882c11f3, ABISELECT(794,446), "S10882C11.s10882c11f3");
  }
}
static Arrange_To_Call_Me vS10882C11(Test_S10882C11, "S10882C11", ABISELECT(880,528));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C14_nt  {
  short s10882c14f0;
  short s10882c14f1;
  short s10882c14f2;
  short s10882c14f3;
  short s10882c14f4;
  short s10882c14f5;
  short s10882c14f6;
  short s10882c14f7;
  short s10882c14f8;
};
//SIG(-1 S10882C14_nt) C1{ Fs[9]}



//skip512 S10882C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C15_nt  {
  void *s10882c15f0;
  char s10882c15f1;
  char s10882c15f2;
  char s10882c15f3;
};
//SIG(-1 S10882C15_nt) C1{ Fp Fc[3]}



//skip512 S10882C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C4  {
  ::S10882C5_nt s10882c4f0[101];
  short s10882c4f1;
  short s10882c4f2;
  void *s10882c4f3;
  char s10882c4f4;
  ::S10882C11 s10882c4f5;
  ::S10882C11 s10882c4f6;
  ::S10882C14_nt s10882c4f7;
  ::S10882C15_nt s10882c4f8;
  short s10882c4f9;
};
//SIG(1 S10882C4) C1{ FC2{ Fs[2] Fl FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC7{ Fs[3]}}}[2] Fc[3] Fp}[101] Fs[2] Fp Fc FC8{ FC9{ Fc[2] Fp[4] FC10{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC8 FC11{ Fs[9]} FC12{ Fp Fc[3]} Fs}



static void Test_S10882C4()
{
  {
    init_simple_test("S10882C4");
    S10882C4 lv;
    check2(sizeof(lv), ABISELECT(35768,20492), "sizeof(S10882C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C4)");
    check_field_offset(lv, s10882c4f0, 0, "S10882C4.s10882c4f0");
    check_field_offset(lv, s10882c4f1, ABISELECT(33936,19392), "S10882C4.s10882c4f1");
    check_field_offset(lv, s10882c4f2, ABISELECT(33938,19394), "S10882C4.s10882c4f2");
    check_field_offset(lv, s10882c4f3, ABISELECT(33944,19396), "S10882C4.s10882c4f3");
    check_field_offset(lv, s10882c4f4, ABISELECT(33952,19400), "S10882C4.s10882c4f4");
    check_field_offset(lv, s10882c4f5, ABISELECT(33960,19404), "S10882C4.s10882c4f5");
    check_field_offset(lv, s10882c4f6, ABISELECT(34840,19932), "S10882C4.s10882c4f6");
    check_field_offset(lv, s10882c4f7, ABISELECT(35720,20460), "S10882C4.s10882c4f7");
    check_field_offset(lv, s10882c4f8, ABISELECT(35744,20480), "S10882C4.s10882c4f8");
    check_field_offset(lv, s10882c4f9, ABISELECT(35760,20488), "S10882C4.s10882c4f9");
  }
}
static Arrange_To_Call_Me vS10882C4(Test_S10882C4, "S10882C4", ABISELECT(35768,20492));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C18_nt  {
  void *s10882c18f0;
  void *s10882c18f1;
  char s10882c18f2;
  char s10882c18f3;
};
//SIG(-1 S10882C18_nt) C1{ Fp[2] Fc[2]}



//skip512 S10882C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C16  {
  void *s10882c16f0;
  ::S10882C10_nt s10882c16f1[41];
  short s10882c16f2;
  void *s10882c16f3;
  ::S10882C6_nt s10882c16f4[301];
  short s10882c16f5;
  short s10882c16f6[301];
  short s10882c16f7;
  ::S10882C11 s10882c16f8;
  ::S10882C11 s10882c16f9;
  ::S10882C11 s10882c16f10;
  ::S10882C14_nt s10882c16f11;
  ::S10882C18_nt s10882c16f12;
};
//SIG(1 S10882C16) C1{ Fp FC2{ Fs[3]}[41] Fs Fp FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC2}}[301] Fs[303] FC7{ FC8{ Fc[2] Fp[4] FC9{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC7 FC7 FC10{ Fs[9]} FC11{ Fp[2] Fc[2]}}



static void Test_S10882C16()
{
  {
    init_simple_test("S10882C16");
    S10882C16 lv;
    check2(sizeof(lv), ABISELECT(49312,28968), "sizeof(S10882C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C16)");
    check_field_offset(lv, s10882c16f0, 0, "S10882C16.s10882c16f0");
    check_field_offset(lv, s10882c16f1, ABISELECT(8,4), "S10882C16.s10882c16f1");
    check_field_offset(lv, s10882c16f2, ABISELECT(254,250), "S10882C16.s10882c16f2");
    check_field_offset(lv, s10882c16f3, ABISELECT(256,252), "S10882C16.s10882c16f3");
    check_field_offset(lv, s10882c16f4, ABISELECT(264,256), "S10882C16.s10882c16f4");
    check_field_offset(lv, s10882c16f5, ABISELECT(46016,26744), "S10882C16.s10882c16f5");
    check_field_offset(lv, s10882c16f6, ABISELECT(46018,26746), "S10882C16.s10882c16f6");
    check_field_offset(lv, s10882c16f7, ABISELECT(46620,27348), "S10882C16.s10882c16f7");
    check_field_offset(lv, s10882c16f8, ABISELECT(46624,27352), "S10882C16.s10882c16f8");
    check_field_offset(lv, s10882c16f9, ABISELECT(47504,27880), "S10882C16.s10882c16f9");
    check_field_offset(lv, s10882c16f10, ABISELECT(48384,28408), "S10882C16.s10882c16f10");
    check_field_offset(lv, s10882c16f11, ABISELECT(49264,28936), "S10882C16.s10882c16f11");
    check_field_offset(lv, s10882c16f12, ABISELECT(49288,28956), "S10882C16.s10882c16f12");
  }
}
static Arrange_To_Call_Me vS10882C16(Test_S10882C16, "S10882C16", ABISELECT(49312,28968));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S10882C3  {
  ::S10882C4 s10882c3f0;
  ::S10882C16 s10882c3f1;
};
//SIG(1 S10882C3) U1{ FC2{ FC3{ Fs Fs Fl FC4{ Fs FC5{ Fp FC6{ Fs Fs Fs FC7{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC8{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC9{ FC10{ Fc Fc Fp Fp Fp[2] FC11{ Fs Fs}[3] Fp}[12] Fp[3] Fs Fs[41]} FC9 FC12{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC13{ Fp Fc Fc Fc} Fs} FC14{ Fp FC8[41] Fs Fp FC4[301] Fs Fs[301] Fs FC9 FC9 FC9 FC12 FC15{ Fp Fp Fc Fc}}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S10882C20_nt  {
  void *s10882c20f0;
  ::S10882C6_nt s10882c20f1[6];
  char s10882c20f2;
  char s10882c20f3;
};
//SIG(1 S10882C20_nt) C1{ Fp FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[6] Fc[2]}



//skip512 S10882C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C19_nt  {
  ::S10882C20_nt s10882c19f0[40];
  short s10882c19f1;
};
//SIG(-1 S10882C19_nt) C1{ FC2{ Fp FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC7{ Fs[3]}}}[6] Fc[2]}[40] Fs}



//skip512 S10882C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C23_nt  {
  void *s10882c23f0;
  short s10882c23f1;
  short s10882c23f2;
  void *s10882c23f3;
  short s10882c23f4;
  short s10882c23f5;
  void *s10882c23f6;
  short s10882c23f7;
};
//SIG(-1 S10882C23_nt) C1{ Fp Fs[2] Fp Fs[2] Fp Fs}



//skip512 S10882C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C22_nt  {
  char s10882c22f0;
  char s10882c22f1;
  void *s10882c22f2;
  ::S10882C23_nt s10882c22f3;
  void *s10882c22f4;
  short s10882c22f5;
  short s10882c22f6;
  void *s10882c22f7;
  void *s10882c22f8;
  char s10882c22f9;
  char s10882c22f10;
};
//SIG(-1 S10882C22_nt) C1{ Fc[2] Fp FC2{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]}



//skip512 S10882C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C24  {
  short s10882c24f0;
  ::S10882C13_nt s10882c24f1;
  short s10882c24f2;
  short s10882c24f3;
  ::S10882C9_nt s10882c24f4;
};
//SIG(1 S10882C24) C1{ Fs FC2{ Fs[2]} Fs[2] FC3{ Fp[4] Fl[9] Fs Fc[3]}}



static void Test_S10882C24()
{
  {
    init_simple_test("S10882C24");
    S10882C24 lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S10882C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C24)");
    check_field_offset(lv, s10882c24f0, 0, "S10882C24.s10882c24f0");
    check_field_offset(lv, s10882c24f1, 2, "S10882C24.s10882c24f1");
    check_field_offset(lv, s10882c24f2, 6, "S10882C24.s10882c24f2");
    check_field_offset(lv, s10882c24f3, 8, "S10882C24.s10882c24f3");
    check_field_offset(lv, s10882c24f4, ABISELECT(16,12), "S10882C24.s10882c24f4");
  }
}
static Arrange_To_Call_Me vS10882C24(Test_S10882C24, "S10882C24", ABISELECT(128,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C21  {
  ::S10882C22_nt s10882c21f0;
  ::S10882C24 s10882c21f1[12];
};
//SIG(-1 S10882C21) C1{ FC2{ Fc[2] Fp FC3{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]} FC4{ Fs FC5{ Fs[2]} Fs[2] FC6{ Fp[4] Fl[9] Fs Fc[3]}}[12]}



static void Test_S10882C21()
{
  {
    init_simple_test("S10882C21");
    S10882C21 lv;
    check2(sizeof(lv), ABISELECT(1640,916), "sizeof(S10882C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C21)");
    check_field_offset(lv, s10882c21f0, 0, "S10882C21.s10882c21f0");
    check_field_offset(lv, s10882c21f1, ABISELECT(104,52), "S10882C21.s10882c21f1");
  }
}
static Arrange_To_Call_Me vS10882C21(Test_S10882C21, "S10882C21", ABISELECT(1640,916));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C25_nt  {
  short s10882c25f0;
  char s10882c25f1;
  short s10882c25f2;
  short s10882c25f3;
  char s10882c25f4;
  char s10882c25f5;
  char s10882c25f6;
  char s10882c25f7;
  char s10882c25f8;
};
//SIG(-1 S10882C25_nt) C1{ Fs Fc Fs[2] Fc[5]}



//skip512 S10882C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C27_nt  {
  short s10882c27f0;
  short s10882c27f1;
  char s10882c27f2;
  char s10882c27f3;
  char s10882c27f4;
  short s10882c27f5[41];
  short s10882c27f6[41];
  short s10882c27f7[41];
  long s10882c27f8;
  short s10882c27f9;
  char s10882c27f10;
};
//SIG(-1 S10882C27_nt) C1{ Fs[2] Fc[3] Fs[123] Fl Fs Fc}



//skip512 S10882C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C26_nt  {
  ::S10882C27_nt s10882c26f0[5];
  ::S10882C27_nt s10882c26f1;
  char s10882c26f2;
  char s10882c26f3;
};
//SIG(-1 S10882C26_nt) C1{ FC2{ Fs[2] Fc[3] Fs[123] Fl Fs Fc}[5] FC2 Fc[2]}



//skip512 S10882C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C29_nt  {
  short s10882c29f0[12341];
  short s10882c29f1;
};
//SIG(1 S10882C29_nt) C1{ Fs[12342]}



//skip512 S10882C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C30_nt  {
  short s10882c30f0[2091];
  short s10882c30f1;
};
//SIG(1 S10882C30_nt) C1{ Fs[2092]}



//skip512 S10882C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S10882C28_nt  {
  ::S10882C29_nt s10882c28f0;
  ::S10882C30_nt s10882c28f1;
};
//SIG(1 S10882C28_nt) U1{ FC2{ Fs[12341] Fs} FC3{ Fs[2091] Fs}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S10882C32_nt  {
  short s10882c32f0;
  short s10882c32f1;
  short s10882c32f2;
  char s10882c32f3;
  char s10882c32f4;
};
//SIG(-1 S10882C32_nt) C1{ Fs[3] Fc[2]}



//skip512 S10882C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C33_nt  {
  ::S10882C6_nt s10882c33f0[2];
  short s10882c33f1;
  ::S10882C6_nt s10882c33f2[40];
  short s10882c33f3;
};
//SIG(-1 S10882C33_nt) C1{ FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[2] Fs FC2[40] Fs}



//skip512 S10882C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C31  {
  void *s10882c31f0;
  ::S10882C11 s10882c31f1;
  char s10882c31f2;
  ::S10882C21 s10882c31f3;
  void *s10882c31f4;
  short s10882c31f5;
  short s10882c31f6;
  short s10882c31f7;
  short s10882c31f8;
  ::S10882C32_nt s10882c31f9;
  ::S10882C33_nt s10882c31f10;
  short s10882c31f11;
  short s10882c31f12;
  short s10882c31f13;
};
//SIG(-1 S10882C31) C1{ Fp FC2{ FC3{ Fc[2] Fp[4] FC4{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fc FC5{ FC6{ Fc[2] Fp FC7{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]} FC8{ Fs FC4 Fs[2] FC9{ Fp[4] Fl[9] Fs Fc[3]}}[12]} Fp Fs[4] FC10{ Fs[3] Fc[2]} FC11{ FC12{ Fs FC13{ Fp FC14{ Fs[3] FC9 Fc} FC15{ Fs[3]}}}[2] Fs FC12[40] Fs} Fs[3]}



static void Test_S10882C31()
{
  {
    init_simple_test("S10882C31");
    S10882C31 lv;
    check2(sizeof(lv), ABISELECT(8968,5184), "sizeof(S10882C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C31)");
    check_field_offset(lv, s10882c31f0, 0, "S10882C31.s10882c31f0");
    check_field_offset(lv, s10882c31f1, ABISELECT(8,4), "S10882C31.s10882c31f1");
    check_field_offset(lv, s10882c31f2, ABISELECT(888,532), "S10882C31.s10882c31f2");
    check_field_offset(lv, s10882c31f3, ABISELECT(896,536), "S10882C31.s10882c31f3");
    check_field_offset(lv, s10882c31f4, ABISELECT(2536,1452), "S10882C31.s10882c31f4");
    check_field_offset(lv, s10882c31f5, ABISELECT(2544,1456), "S10882C31.s10882c31f5");
    check_field_offset(lv, s10882c31f6, ABISELECT(2546,1458), "S10882C31.s10882c31f6");
    check_field_offset(lv, s10882c31f7, ABISELECT(2548,1460), "S10882C31.s10882c31f7");
    check_field_offset(lv, s10882c31f8, ABISELECT(2550,1462), "S10882C31.s10882c31f8");
    check_field_offset(lv, s10882c31f9, ABISELECT(2552,1464), "S10882C31.s10882c31f9");
    check_field_offset(lv, s10882c31f10, ABISELECT(2560,1472), "S10882C31.s10882c31f10");
    check_field_offset(lv, s10882c31f11, ABISELECT(8960,5176), "S10882C31.s10882c31f11");
    check_field_offset(lv, s10882c31f12, ABISELECT(8962,5178), "S10882C31.s10882c31f12");
    check_field_offset(lv, s10882c31f13, ABISELECT(8964,5180), "S10882C31.s10882c31f13");
  }
}
static Arrange_To_Call_Me vS10882C31(Test_S10882C31, "S10882C31", ABISELECT(8968,5184));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C34_nt  {
  short s10882c34f0;
  short s10882c34f1;
  void *s10882c34f2;
  void *s10882c34f3;
  void *s10882c34f4;
  void *s10882c34f5;
};
//SIG(-1 S10882C34_nt) C1{ Fs[2] Fp[4]}



//skip512 S10882C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C35_nt  {
  short s10882c35f0[16];
  short s10882c35f1[2];
  void *s10882c35f2;
};
//SIG(-1 S10882C35_nt) C1{ Fs[18] Fp}



//skip512 S10882C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C36_nt  {
  char s10882c36f0;
  short s10882c36f1;
  short s10882c36f2;
  short s10882c36f3;
};
//SIG(-1 S10882C36_nt) C1{ Fc Fs[3]}



//skip512 S10882C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10882C1  {
  char s10882c1f0[4];
  ::S10882C2_nt s10882c1f1;
  ::S10882C3 s10882c1f2;
  ::S10882C19_nt s10882c1f3;
  ::S10882C21 s10882c1f4[40];
  ::S10882C25_nt s10882c1f5;
  short s10882c1f6[41];
  short s10882c1f7[41];
  ::S10882C26_nt s10882c1f8;
  long s10882c1f9[24];
  ::S10882C6_nt s10882c1f10[50];
  long s10882c1f11;
  ::S10882C28_nt s10882c1f12;
  ::S10882C31 s10882c1f13;
  char s10882c1f14;
  char s10882c1f15[12];
  ::S10882C34_nt s10882c1f16;
  ::S10882C11 s10882c1f17;
  ::S10882C11 s10882c1f18;
  ::S10882C35_nt s10882c1f19;
  ::S10882C36_nt s10882c1f20;
  short s10882c1f21[41];
};
//SIG(1 S10882C1) C1{ Fc[4] FC2{ Fp Fs Fp Fs[2]} FU3{ FC4{ FC5{ Fs Fs Fl FC6{ Fs FC7{ Fp FC8{ Fs Fs Fs FC9{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC10{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC11{ FC12{ Fc Fc Fp Fp Fp[2] FC13{ Fs Fs}[3] Fp}[12] Fp[3] Fs Fs[41]} FC11 FC14{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC15{ Fp Fc Fc Fc} Fs} FC16{ Fp FC10[41] Fs Fp FC6[301] Fs Fs[301] Fs FC11 FC11 FC11 FC14 FC17{ Fp Fp Fc Fc}}} FC18{ FC19{ Fp FC6[6] Fc Fc}[40] Fs} FC20{ FC21{ Fc Fc Fp FC22{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC23{ Fs FC13 Fs Fs FC9}[12]}[40] FC24{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC25{ FC26{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC26 Fc Fc} Fl[24] FC6[50] Fl FU27{ FC28{ Fs[12341] Fs} FC29{ Fs[2091] Fs}} FC30{ Fp FC11 Fc FC20 Fp Fs Fs Fs Fs FC31{ Fs Fs Fs Fc Fc} FC32{ FC6[2] Fs FC6[40] Fs} Fs Fs Fs} Fc Fc[12] FC33{ Fs Fs Fp Fp Fp Fp} FC11 FC11 FC34{ Fs[16] Fs[2] Fp} FC35{ Fc Fs Fs Fs} Fs[41]}



static void Test_S10882C1()
{
  {
    init_simple_test("S10882C1");
    S10882C1 lv;
    check2(sizeof(lv), ABISELECT(197320,124432), "sizeof(S10882C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10882C1)");
    check_field_offset(lv, s10882c1f0, 0, "S10882C1.s10882c1f0");
    check_field_offset(lv, s10882c1f1, ABISELECT(8,4), "S10882C1.s10882c1f1");
    check_field_offset(lv, s10882c1f2, ABISELECT(40,20), "S10882C1.s10882c1f2");
    check_field_offset(lv, s10882c1f3, ABISELECT(49352,28988), "S10882C1.s10882c1f3");
    check_field_offset(lv, s10882c1f4, ABISELECT(86480,50432), "S10882C1.s10882c1f4");
    check_field_offset(lv, s10882c1f5, ABISELECT(152080,87072), "S10882C1.s10882c1f5");
    check_field_offset(lv, s10882c1f6, ABISELECT(152094,87086), "S10882C1.s10882c1f6");
    check_field_offset(lv, s10882c1f7, ABISELECT(152176,87168), "S10882C1.s10882c1f7");
    check_field_offset(lv, s10882c1f8, ABISELECT(152264,87252), "S10882C1.s10882c1f8");
    check_field_offset(lv, s10882c1f9, ABISELECT(153904,88840), "S10882C1.s10882c1f9");
    check_field_offset(lv, s10882c1f10, ABISELECT(154096,88936), "S10882C1.s10882c1f10");
    check_field_offset(lv, s10882c1f11, ABISELECT(161696,93336), "S10882C1.s10882c1f11");
    check_field_offset(lv, s10882c1f12, ABISELECT(161704,93340), "S10882C1.s10882c1f12");
    check_field_offset(lv, s10882c1f13, ABISELECT(186392,118024), "S10882C1.s10882c1f13");
    check_field_offset(lv, s10882c1f14, ABISELECT(195360,123208), "S10882C1.s10882c1f14");
    check_field_offset(lv, s10882c1f15, ABISELECT(195361,123209), "S10882C1.s10882c1f15");
    check_field_offset(lv, s10882c1f16, ABISELECT(195376,123224), "S10882C1.s10882c1f16");
    check_field_offset(lv, s10882c1f17, ABISELECT(195416,123244), "S10882C1.s10882c1f17");
    check_field_offset(lv, s10882c1f18, ABISELECT(196296,123772), "S10882C1.s10882c1f18");
    check_field_offset(lv, s10882c1f19, ABISELECT(197176,124300), "S10882C1.s10882c1f19");
    check_field_offset(lv, s10882c1f20, ABISELECT(197224,124340), "S10882C1.s10882c1f20");
    check_field_offset(lv, s10882c1f21, ABISELECT(197232,124348), "S10882C1.s10882c1f21");
  }
}
static Arrange_To_Call_Me vS10882C1(Test_S10882C1, "S10882C1", ABISELECT(197320,124432));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C6  {
  int s265c6f0;
  __tsi64 s265c6f1;
  void *s265c6f2[4];
  int s265c6f3[2];
  void *s265c6f4;
  ::S78C8_nt s265c6f5;
  void *s265c6f6[2];
  virtual  ~S265C6(); // _ZN6S265C6D1Ev
  virtual void  v6(); // _ZN6S265C62v6Ev
  virtual void  v7(); // _ZN6S265C62v7Ev
  virtual void  v8(); // _ZN6S265C62v8Ev
  virtual void  v9(); // _ZN6S265C62v9Ev
  virtual void  v10(); // _ZN6S265C63v10Ev
  virtual void  v11(); // _ZN6S265C63v11Ev
  virtual void  v12(); // _ZN6S265C63v12Ev
  virtual void  v13(); // _ZN6S265C63v13Ev
  virtual void  v14(); // _ZN6S265C63v14Ev
  virtual void  v15(); // _ZN6S265C63v15Ev
  virtual void  v16(); // _ZN6S265C63v16Ev
  virtual void  v17(); // _ZN6S265C63v17Ev
  virtual void  v18(); // _ZN6S265C63v18Ev
  virtual void  v19(); // _ZN6S265C63v19Ev
  virtual void  v20(); // _ZN6S265C63v20Ev
  virtual void  v21(); // _ZN6S265C63v21Ev
  virtual void  v22(); // _ZN6S265C63v22Ev
  virtual void  v23(); // _ZN6S265C63v23Ev
  virtual void  v24(); // _ZN6S265C63v24Ev
  virtual void  v25(); // _ZN6S265C63v25Ev
  virtual void  v26(); // _ZN6S265C63v26Ev
  virtual void  v27(); // _ZN6S265C63v27Ev
  virtual void  v28(); // _ZN6S265C63v28Ev
  virtual void  v29(); // _ZN6S265C63v29Ev
  virtual void  v30(); // _ZN6S265C63v30Ev
  virtual void  v31(); // _ZN6S265C63v31Ev
  virtual void  v32(); // _ZN6S265C63v32Ev
  virtual void  v33(); // _ZN6S265C63v33Ev
  virtual void  v34(); // _ZN6S265C63v34Ev
  virtual void  v35(); // _ZN6S265C63v35Ev
  virtual void  v36(); // _ZN6S265C63v36Ev
  virtual void  v37(); // _ZN6S265C63v37Ev
  virtual void  v38(); // _ZN6S265C63v38Ev
  virtual void  v39(); // _ZN6S265C63v39Ev
  virtual void  v40(); // _ZN6S265C63v40Ev
  virtual void  v41(); // _ZN6S265C63v41Ev
  virtual void  v42(); // _ZN6S265C63v42Ev
  virtual void  v43(); // _ZN6S265C63v43Ev
  virtual void  v44(); // _ZN6S265C63v44Ev
  virtual void  v45(); // _ZN6S265C63v45Ev
  virtual void  v46(); // _ZN6S265C63v46Ev
  virtual void  v47(); // _ZN6S265C63v47Ev
  virtual void  v48(); // _ZN6S265C63v48Ev
  virtual void  v49(); // _ZN6S265C63v49Ev
  virtual void  v50(); // _ZN6S265C63v50Ev
  virtual void  v51(); // _ZN6S265C63v51Ev
  virtual void  v52(); // _ZN6S265C63v52Ev
  virtual void  v53(); // _ZN6S265C63v53Ev
  virtual void  v54(); // _ZN6S265C63v54Ev
  virtual void  v55(); // _ZN6S265C63v55Ev
  virtual void  v56(); // _ZN6S265C63v56Ev
  virtual void  v57(); // _ZN6S265C63v57Ev
  virtual void  v58(); // _ZN6S265C63v58Ev
  virtual void  v59(); // _ZN6S265C63v59Ev
  virtual void  v60(); // _ZN6S265C63v60Ev
  virtual void  v61(); // _ZN6S265C63v61Ev
  virtual void  v62(); // _ZN6S265C63v62Ev
  virtual void  v63(); // _ZN6S265C63v63Ev
  virtual void  v64(); // _ZN6S265C63v64Ev
  virtual void  v65(); // _ZN6S265C63v65Ev
  virtual void  v66(); // _ZN6S265C63v66Ev
  virtual void  v67(); // _ZN6S265C63v67Ev
  virtual void  v68(); // _ZN6S265C63v68Ev
  virtual void  v69(); // _ZN6S265C63v69Ev
  S265C6(); // tgen
};
//SIG(-1 S265C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S265C6 ::~S265C6(){ note_dtor("S265C6", this);}
void  S265C6 ::v6(){vfunc_called(this, "_ZN6S265C62v6Ev");}
void  S265C6 ::v7(){vfunc_called(this, "_ZN6S265C62v7Ev");}
void  S265C6 ::v8(){vfunc_called(this, "_ZN6S265C62v8Ev");}
void  S265C6 ::v9(){vfunc_called(this, "_ZN6S265C62v9Ev");}
void  S265C6 ::v10(){vfunc_called(this, "_ZN6S265C63v10Ev");}
void  S265C6 ::v11(){vfunc_called(this, "_ZN6S265C63v11Ev");}
void  S265C6 ::v12(){vfunc_called(this, "_ZN6S265C63v12Ev");}
void  S265C6 ::v13(){vfunc_called(this, "_ZN6S265C63v13Ev");}
void  S265C6 ::v14(){vfunc_called(this, "_ZN6S265C63v14Ev");}
void  S265C6 ::v15(){vfunc_called(this, "_ZN6S265C63v15Ev");}
void  S265C6 ::v16(){vfunc_called(this, "_ZN6S265C63v16Ev");}
void  S265C6 ::v17(){vfunc_called(this, "_ZN6S265C63v17Ev");}
void  S265C6 ::v18(){vfunc_called(this, "_ZN6S265C63v18Ev");}
void  S265C6 ::v19(){vfunc_called(this, "_ZN6S265C63v19Ev");}
void  S265C6 ::v20(){vfunc_called(this, "_ZN6S265C63v20Ev");}
void  S265C6 ::v21(){vfunc_called(this, "_ZN6S265C63v21Ev");}
void  S265C6 ::v22(){vfunc_called(this, "_ZN6S265C63v22Ev");}
void  S265C6 ::v23(){vfunc_called(this, "_ZN6S265C63v23Ev");}
void  S265C6 ::v24(){vfunc_called(this, "_ZN6S265C63v24Ev");}
void  S265C6 ::v25(){vfunc_called(this, "_ZN6S265C63v25Ev");}
void  S265C6 ::v26(){vfunc_called(this, "_ZN6S265C63v26Ev");}
void  S265C6 ::v27(){vfunc_called(this, "_ZN6S265C63v27Ev");}
void  S265C6 ::v28(){vfunc_called(this, "_ZN6S265C63v28Ev");}
void  S265C6 ::v29(){vfunc_called(this, "_ZN6S265C63v29Ev");}
void  S265C6 ::v30(){vfunc_called(this, "_ZN6S265C63v30Ev");}
void  S265C6 ::v31(){vfunc_called(this, "_ZN6S265C63v31Ev");}
void  S265C6 ::v32(){vfunc_called(this, "_ZN6S265C63v32Ev");}
void  S265C6 ::v33(){vfunc_called(this, "_ZN6S265C63v33Ev");}
void  S265C6 ::v34(){vfunc_called(this, "_ZN6S265C63v34Ev");}
void  S265C6 ::v35(){vfunc_called(this, "_ZN6S265C63v35Ev");}
void  S265C6 ::v36(){vfunc_called(this, "_ZN6S265C63v36Ev");}
void  S265C6 ::v37(){vfunc_called(this, "_ZN6S265C63v37Ev");}
void  S265C6 ::v38(){vfunc_called(this, "_ZN6S265C63v38Ev");}
void  S265C6 ::v39(){vfunc_called(this, "_ZN6S265C63v39Ev");}
void  S265C6 ::v40(){vfunc_called(this, "_ZN6S265C63v40Ev");}
void  S265C6 ::v41(){vfunc_called(this, "_ZN6S265C63v41Ev");}
void  S265C6 ::v42(){vfunc_called(this, "_ZN6S265C63v42Ev");}
void  S265C6 ::v43(){vfunc_called(this, "_ZN6S265C63v43Ev");}
void  S265C6 ::v44(){vfunc_called(this, "_ZN6S265C63v44Ev");}
void  S265C6 ::v45(){vfunc_called(this, "_ZN6S265C63v45Ev");}
void  S265C6 ::v46(){vfunc_called(this, "_ZN6S265C63v46Ev");}
void  S265C6 ::v47(){vfunc_called(this, "_ZN6S265C63v47Ev");}
void  S265C6 ::v48(){vfunc_called(this, "_ZN6S265C63v48Ev");}
void  S265C6 ::v49(){vfunc_called(this, "_ZN6S265C63v49Ev");}
void  S265C6 ::v50(){vfunc_called(this, "_ZN6S265C63v50Ev");}
void  S265C6 ::v51(){vfunc_called(this, "_ZN6S265C63v51Ev");}
void  S265C6 ::v52(){vfunc_called(this, "_ZN6S265C63v52Ev");}
void  S265C6 ::v53(){vfunc_called(this, "_ZN6S265C63v53Ev");}
void  S265C6 ::v54(){vfunc_called(this, "_ZN6S265C63v54Ev");}
void  S265C6 ::v55(){vfunc_called(this, "_ZN6S265C63v55Ev");}
void  S265C6 ::v56(){vfunc_called(this, "_ZN6S265C63v56Ev");}
void  S265C6 ::v57(){vfunc_called(this, "_ZN6S265C63v57Ev");}
void  S265C6 ::v58(){vfunc_called(this, "_ZN6S265C63v58Ev");}
void  S265C6 ::v59(){vfunc_called(this, "_ZN6S265C63v59Ev");}
void  S265C6 ::v60(){vfunc_called(this, "_ZN6S265C63v60Ev");}
void  S265C6 ::v61(){vfunc_called(this, "_ZN6S265C63v61Ev");}
void  S265C6 ::v62(){vfunc_called(this, "_ZN6S265C63v62Ev");}
void  S265C6 ::v63(){vfunc_called(this, "_ZN6S265C63v63Ev");}
void  S265C6 ::v64(){vfunc_called(this, "_ZN6S265C63v64Ev");}
void  S265C6 ::v65(){vfunc_called(this, "_ZN6S265C63v65Ev");}
void  S265C6 ::v66(){vfunc_called(this, "_ZN6S265C63v66Ev");}
void  S265C6 ::v67(){vfunc_called(this, "_ZN6S265C63v67Ev");}
void  S265C6 ::v68(){vfunc_called(this, "_ZN6S265C63v68Ev");}
void  S265C6 ::v69(){vfunc_called(this, "_ZN6S265C63v69Ev");}
S265C6 ::S265C6(){ note_ctor("S265C6", this);} // tgen

static void Test_S265C6()
{
  extern Class_Descriptor cd_S265C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S265C6, buf);
    S265C6 *dp, &lv = *(dp=new (buf) S265C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S265C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S265C6)");
    check_field_offset(lv, s265c6f0, ABISELECT(8,4), "S265C6.s265c6f0");
    check_field_offset(lv, s265c6f1, ABISELECT(16,8), "S265C6.s265c6f1");
    check_field_offset(lv, s265c6f2, ABISELECT(24,16), "S265C6.s265c6f2");
    check_field_offset(lv, s265c6f3, ABISELECT(56,32), "S265C6.s265c6f3");
    check_field_offset(lv, s265c6f4, ABISELECT(64,40), "S265C6.s265c6f4");
    check_field_offset(lv, s265c6f5, ABISELECT(72,44), "S265C6.s265c6f5");
    check_field_offset(lv, s265c6f6, ABISELECT(80,52), "S265C6.s265c6f6");
    test_class_info(&lv, &cd_S265C6);
    dp->~S265C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS265C6(Test_S265C6, "S265C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S265C6C1Ev();
extern void _ZN6S265C6D1Ev();
Name_Map name_map_S265C6[] = {
  NSPAIR(_ZN6S265C6C1Ev),
  NSPAIR(_ZN6S265C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S265C6[];
extern void _ZN6S265C6D1Ev();
extern void _ZN6S265C6D0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
static  VTBL_ENTRY vtc_S265C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S265C6[0]),
  (VTBL_ENTRY)&_ZN6S265C6D1Ev,
  (VTBL_ENTRY)&_ZN6S265C6D0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
};
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
Class_Descriptor cd_S265C6 = {  "S265C6", // class name
  0,0,//no base classes
  &(vtc_S265C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S265C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S265C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C5_nt  : S265C6 {
  int s265c5f0[2];
  void *s265c5f1;
  int s265c5f2[2];
  ::S78C39_nt s265c5f3;
  ::S78C39_nt s265c5f4;
  ::S5328C29 s265c5f5;
  ::S78C39_nt s265c5f6;
  unsigned int s265c5f7:1;
  unsigned int s265c5f8:1;
  unsigned int s265c5f9:1;
  unsigned int s265c5f10:1;
  unsigned int s265c5f11:1;
  int s265c5f12[2];
  virtual  ~S265C5_nt(); // _ZN9S265C5_ntD1Ev
  virtual void  v70(); // _ZN9S265C5_nt3v70Ev
  virtual void  v71(); // _ZN9S265C5_nt3v71Ev
  virtual void  v72(); // _ZN9S265C5_nt3v72Ev
  virtual void  v73(); // _ZN9S265C5_nt3v73Ev
  virtual void  v74(); // _ZN9S265C5_nt3v74Ev
  virtual void  v75(); // _ZN9S265C5_nt3v75Ev
  virtual void  v76(); // _ZN9S265C5_nt3v76Ev
  virtual void  v77(); // _ZN9S265C5_nt3v77Ev
  virtual void  v78(); // _ZN9S265C5_nt3v78Ev
  virtual void  v79(); // _ZN9S265C5_nt3v79Ev
  virtual void  v80(); // _ZN9S265C5_nt3v80Ev
  virtual void  v81(); // _ZN9S265C5_nt3v81Ev
  virtual void  v82(); // _ZN9S265C5_nt3v82Ev
  virtual void  v83(); // _ZN9S265C5_nt3v83Ev
  virtual void  v84(); // _ZN9S265C5_nt3v84Ev
  virtual void  v85(); // _ZN9S265C5_nt3v85Ev
  virtual void  v86(); // _ZN9S265C5_nt3v86Ev
  virtual void  v87(); // _ZN9S265C5_nt3v87Ev
  virtual void  v88(); // _ZN9S265C5_nt3v88Ev
  virtual void  v89(); // _ZN9S265C5_nt3v89Ev
  virtual void  v90(); // _ZN9S265C5_nt3v90Ev
  virtual void  v91(); // _ZN9S265C5_nt3v91Ev
  S265C5_nt(); // tgen
};
//SIG(-1 S265C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S265C5_nt ::~S265C5_nt(){ note_dtor("S265C5_nt", this);}
void  S265C5_nt ::v70(){vfunc_called(this, "_ZN9S265C5_nt3v70Ev");}
void  S265C5_nt ::v71(){vfunc_called(this, "_ZN9S265C5_nt3v71Ev");}
void  S265C5_nt ::v72(){vfunc_called(this, "_ZN9S265C5_nt3v72Ev");}
void  S265C5_nt ::v73(){vfunc_called(this, "_ZN9S265C5_nt3v73Ev");}
void  S265C5_nt ::v74(){vfunc_called(this, "_ZN9S265C5_nt3v74Ev");}
void  S265C5_nt ::v75(){vfunc_called(this, "_ZN9S265C5_nt3v75Ev");}
void  S265C5_nt ::v76(){vfunc_called(this, "_ZN9S265C5_nt3v76Ev");}
void  S265C5_nt ::v77(){vfunc_called(this, "_ZN9S265C5_nt3v77Ev");}
void  S265C5_nt ::v78(){vfunc_called(this, "_ZN9S265C5_nt3v78Ev");}
void  S265C5_nt ::v79(){vfunc_called(this, "_ZN9S265C5_nt3v79Ev");}
void  S265C5_nt ::v80(){vfunc_called(this, "_ZN9S265C5_nt3v80Ev");}
void  S265C5_nt ::v81(){vfunc_called(this, "_ZN9S265C5_nt3v81Ev");}
void  S265C5_nt ::v82(){vfunc_called(this, "_ZN9S265C5_nt3v82Ev");}
void  S265C5_nt ::v83(){vfunc_called(this, "_ZN9S265C5_nt3v83Ev");}
void  S265C5_nt ::v84(){vfunc_called(this, "_ZN9S265C5_nt3v84Ev");}
void  S265C5_nt ::v85(){vfunc_called(this, "_ZN9S265C5_nt3v85Ev");}
void  S265C5_nt ::v86(){vfunc_called(this, "_ZN9S265C5_nt3v86Ev");}
void  S265C5_nt ::v87(){vfunc_called(this, "_ZN9S265C5_nt3v87Ev");}
void  S265C5_nt ::v88(){vfunc_called(this, "_ZN9S265C5_nt3v88Ev");}
void  S265C5_nt ::v89(){vfunc_called(this, "_ZN9S265C5_nt3v89Ev");}
void  S265C5_nt ::v90(){vfunc_called(this, "_ZN9S265C5_nt3v90Ev");}
void  S265C5_nt ::v91(){vfunc_called(this, "_ZN9S265C5_nt3v91Ev");}
S265C5_nt ::S265C5_nt(){ note_ctor("S265C5_nt", this);} // tgen

//skip512 S265C5_nt

#else // __cplusplus

extern void _ZN9S265C5_ntC1Ev();
extern void _ZN9S265C5_ntD1Ev();
Name_Map name_map_S265C5_nt[] = {
  NSPAIR(_ZN9S265C5_ntC1Ev),
  NSPAIR(_ZN9S265C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S265C6;
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
static Base_Class bases_S265C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S265C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S265C5_nt[];
extern void _ZN9S265C5_ntD1Ev();
extern void _ZN9S265C5_ntD0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
extern void _ZN9S265C5_nt3v70Ev();
extern void _ZN9S265C5_nt3v71Ev();
extern void _ZN9S265C5_nt3v72Ev();
extern void _ZN9S265C5_nt3v73Ev();
extern void _ZN9S265C5_nt3v74Ev();
extern void _ZN9S265C5_nt3v75Ev();
extern void _ZN9S265C5_nt3v76Ev();
extern void _ZN9S265C5_nt3v77Ev();
extern void _ZN9S265C5_nt3v78Ev();
extern void _ZN9S265C5_nt3v79Ev();
extern void _ZN9S265C5_nt3v80Ev();
extern void _ZN9S265C5_nt3v81Ev();
extern void _ZN9S265C5_nt3v82Ev();
extern void _ZN9S265C5_nt3v83Ev();
extern void _ZN9S265C5_nt3v84Ev();
extern void _ZN9S265C5_nt3v85Ev();
extern void _ZN9S265C5_nt3v86Ev();
extern void _ZN9S265C5_nt3v87Ev();
extern void _ZN9S265C5_nt3v88Ev();
extern void _ZN9S265C5_nt3v89Ev();
extern void _ZN9S265C5_nt3v90Ev();
extern void _ZN9S265C5_nt3v91Ev();
static  VTBL_ENTRY vtc_S265C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S265C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S265C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S265C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v91Ev,
};
extern VTBL_ENTRY _ZTI9S265C5_nt[];
VTBL_ENTRY *P__ZTI9S265C5_nt = _ZTI9S265C5_nt; 
extern  VTBL_ENTRY _ZTV9S265C5_nt[];
Class_Descriptor cd_S265C5_nt = {  "S265C5_nt", // class name
  bases_S265C5_nt, 1,
  &(vtc_S265C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S265C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S265C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C4_nt  : S265C5_nt {
  unsigned int s265c4f0:1;
  unsigned int s265c4f1:1;
  unsigned int s265c4f2:1;
  ::S78C49 s265c4f3;
  ::S78C44 s265c4f4;
  ::S78C40 s265c4f5;
  ::S78C19 s265c4f6;
  int s265c4f7[3];
  virtual  ~S265C4_nt(); // _ZN9S265C4_ntD1Ev
  virtual void  v92(); // _ZN9S265C4_nt3v92Ev
  virtual void  v93(); // _ZN9S265C4_nt3v93Ev
  virtual void  v94(); // _ZN9S265C4_nt3v94Ev
  virtual void  v95(); // _ZN9S265C4_nt3v95Ev
  virtual void  v96(); // _ZN9S265C4_nt3v96Ev
  virtual void  v97(); // _ZN9S265C4_nt3v97Ev
  virtual void  v98(); // _ZN9S265C4_nt3v98Ev
  virtual void  v99(); // _ZN9S265C4_nt3v99Ev
  virtual void  v100(); // _ZN9S265C4_nt4v100Ev
  virtual void  v101(); // _ZN9S265C4_nt4v101Ev
  virtual void  v102(); // _ZN9S265C4_nt4v102Ev
  virtual void  v103(); // _ZN9S265C4_nt4v103Ev
  virtual void  v104(); // _ZN9S265C4_nt4v104Ev
  virtual void  v105(); // _ZN9S265C4_nt4v105Ev
  virtual void  v106(); // _ZN9S265C4_nt4v106Ev
  virtual void  v107(); // _ZN9S265C4_nt4v107Ev
  virtual void  v108(); // _ZN9S265C4_nt4v108Ev
  virtual void  v109(); // _ZN9S265C4_nt4v109Ev
  virtual void  v110(); // _ZN9S265C4_nt4v110Ev
  virtual void  v111(); // _ZN9S265C4_nt4v111Ev
  S265C4_nt(); // tgen
};
//SIG(-1 S265C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC6 FC14{ BC15{ BC8}} Fi[3]}


 S265C4_nt ::~S265C4_nt(){ note_dtor("S265C4_nt", this);}
void  S265C4_nt ::v92(){vfunc_called(this, "_ZN9S265C4_nt3v92Ev");}
void  S265C4_nt ::v93(){vfunc_called(this, "_ZN9S265C4_nt3v93Ev");}
void  S265C4_nt ::v94(){vfunc_called(this, "_ZN9S265C4_nt3v94Ev");}
void  S265C4_nt ::v95(){vfunc_called(this, "_ZN9S265C4_nt3v95Ev");}
void  S265C4_nt ::v96(){vfunc_called(this, "_ZN9S265C4_nt3v96Ev");}
void  S265C4_nt ::v97(){vfunc_called(this, "_ZN9S265C4_nt3v97Ev");}
void  S265C4_nt ::v98(){vfunc_called(this, "_ZN9S265C4_nt3v98Ev");}
void  S265C4_nt ::v99(){vfunc_called(this, "_ZN9S265C4_nt3v99Ev");}
void  S265C4_nt ::v100(){vfunc_called(this, "_ZN9S265C4_nt4v100Ev");}
void  S265C4_nt ::v101(){vfunc_called(this, "_ZN9S265C4_nt4v101Ev");}
void  S265C4_nt ::v102(){vfunc_called(this, "_ZN9S265C4_nt4v102Ev");}
void  S265C4_nt ::v103(){vfunc_called(this, "_ZN9S265C4_nt4v103Ev");}
void  S265C4_nt ::v104(){vfunc_called(this, "_ZN9S265C4_nt4v104Ev");}
void  S265C4_nt ::v105(){vfunc_called(this, "_ZN9S265C4_nt4v105Ev");}
void  S265C4_nt ::v106(){vfunc_called(this, "_ZN9S265C4_nt4v106Ev");}
void  S265C4_nt ::v107(){vfunc_called(this, "_ZN9S265C4_nt4v107Ev");}
void  S265C4_nt ::v108(){vfunc_called(this, "_ZN9S265C4_nt4v108Ev");}
void  S265C4_nt ::v109(){vfunc_called(this, "_ZN9S265C4_nt4v109Ev");}
void  S265C4_nt ::v110(){vfunc_called(this, "_ZN9S265C4_nt4v110Ev");}
void  S265C4_nt ::v111(){vfunc_called(this, "_ZN9S265C4_nt4v111Ev");}
S265C4_nt ::S265C4_nt(){ note_ctor("S265C4_nt", this);} // tgen

//skip512 S265C4_nt

#else // __cplusplus

extern void _ZN9S265C4_ntC1Ev();
extern void _ZN9S265C4_ntD1Ev();
Name_Map name_map_S265C4_nt[] = {
  NSPAIR(_ZN9S265C4_ntC1Ev),
  NSPAIR(_ZN9S265C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S265C6;
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
extern Class_Descriptor cd_S265C5_nt;
extern VTBL_ENTRY _ZTI9S265C5_nt[];
extern  VTBL_ENTRY _ZTV9S265C5_nt[];
static Base_Class bases_S265C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S265C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S265C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S265C4_nt[];
extern void _ZN9S265C4_ntD1Ev();
extern void _ZN9S265C4_ntD0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
extern void _ZN9S265C5_nt3v70Ev();
extern void _ZN9S265C5_nt3v71Ev();
extern void _ZN9S265C5_nt3v72Ev();
extern void _ZN9S265C5_nt3v73Ev();
extern void _ZN9S265C5_nt3v74Ev();
extern void _ZN9S265C5_nt3v75Ev();
extern void _ZN9S265C5_nt3v76Ev();
extern void _ZN9S265C5_nt3v77Ev();
extern void _ZN9S265C5_nt3v78Ev();
extern void _ZN9S265C5_nt3v79Ev();
extern void _ZN9S265C5_nt3v80Ev();
extern void _ZN9S265C5_nt3v81Ev();
extern void _ZN9S265C5_nt3v82Ev();
extern void _ZN9S265C5_nt3v83Ev();
extern void _ZN9S265C5_nt3v84Ev();
extern void _ZN9S265C5_nt3v85Ev();
extern void _ZN9S265C5_nt3v86Ev();
extern void _ZN9S265C5_nt3v87Ev();
extern void _ZN9S265C5_nt3v88Ev();
extern void _ZN9S265C5_nt3v89Ev();
extern void _ZN9S265C5_nt3v90Ev();
extern void _ZN9S265C5_nt3v91Ev();
extern void _ZN9S265C4_nt3v92Ev();
extern void _ZN9S265C4_nt3v93Ev();
extern void _ZN9S265C4_nt3v94Ev();
extern void _ZN9S265C4_nt3v95Ev();
extern void _ZN9S265C4_nt3v96Ev();
extern void _ZN9S265C4_nt3v97Ev();
extern void _ZN9S265C4_nt3v98Ev();
extern void _ZN9S265C4_nt3v99Ev();
extern void _ZN9S265C4_nt4v100Ev();
extern void _ZN9S265C4_nt4v101Ev();
extern void _ZN9S265C4_nt4v102Ev();
extern void _ZN9S265C4_nt4v103Ev();
extern void _ZN9S265C4_nt4v104Ev();
extern void _ZN9S265C4_nt4v105Ev();
extern void _ZN9S265C4_nt4v106Ev();
extern void _ZN9S265C4_nt4v107Ev();
extern void _ZN9S265C4_nt4v108Ev();
extern void _ZN9S265C4_nt4v109Ev();
extern void _ZN9S265C4_nt4v110Ev();
extern void _ZN9S265C4_nt4v111Ev();
static  VTBL_ENTRY vtc_S265C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S265C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S265C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S265C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v111Ev,
};
extern VTBL_ENTRY _ZTI9S265C4_nt[];
VTBL_ENTRY *P__ZTI9S265C4_nt = _ZTI9S265C4_nt; 
extern  VTBL_ENTRY _ZTV9S265C4_nt[];
Class_Descriptor cd_S265C4_nt = {  "S265C4_nt", // class name
  bases_S265C4_nt, 2,
  &(vtc_S265C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S265C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S265C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C3_nt  : S265C4_nt {
  ::S78C8_nt s265c3f0;
  unsigned int s265c3f1:1;
  ::S78C15 s265c3f2;
  virtual  ~S265C3_nt(); // _ZN9S265C3_ntD1Ev
  virtual void  v112(); // _ZN9S265C3_nt4v112Ev
  virtual void  v113(); // _ZN9S265C3_nt4v113Ev
  virtual void  v114(); // _ZN9S265C3_nt4v114Ev
  virtual void  v115(); // _ZN9S265C3_nt4v115Ev
  S265C3_nt(); // tgen
};
//SIG(-1 S265C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC7 FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S265C3_nt ::~S265C3_nt(){ note_dtor("S265C3_nt", this);}
void  S265C3_nt ::v112(){vfunc_called(this, "_ZN9S265C3_nt4v112Ev");}
void  S265C3_nt ::v113(){vfunc_called(this, "_ZN9S265C3_nt4v113Ev");}
void  S265C3_nt ::v114(){vfunc_called(this, "_ZN9S265C3_nt4v114Ev");}
void  S265C3_nt ::v115(){vfunc_called(this, "_ZN9S265C3_nt4v115Ev");}
S265C3_nt ::S265C3_nt(){ note_ctor("S265C3_nt", this);} // tgen

//skip512 S265C3_nt

#else // __cplusplus

extern void _ZN9S265C3_ntC1Ev();
extern void _ZN9S265C3_ntD1Ev();
Name_Map name_map_S265C3_nt[] = {
  NSPAIR(_ZN9S265C3_ntC1Ev),
  NSPAIR(_ZN9S265C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S265C6;
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
extern Class_Descriptor cd_S265C5_nt;
extern VTBL_ENTRY _ZTI9S265C5_nt[];
extern  VTBL_ENTRY _ZTV9S265C5_nt[];
extern Class_Descriptor cd_S265C4_nt;
extern VTBL_ENTRY _ZTI9S265C4_nt[];
extern  VTBL_ENTRY _ZTV9S265C4_nt[];
static Base_Class bases_S265C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S265C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S265C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S265C3_nt[];
extern void _ZN9S265C3_ntD1Ev();
extern void _ZN9S265C3_ntD0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
extern void _ZN9S265C5_nt3v70Ev();
extern void _ZN9S265C5_nt3v71Ev();
extern void _ZN9S265C5_nt3v72Ev();
extern void _ZN9S265C5_nt3v73Ev();
extern void _ZN9S265C5_nt3v74Ev();
extern void _ZN9S265C5_nt3v75Ev();
extern void _ZN9S265C5_nt3v76Ev();
extern void _ZN9S265C5_nt3v77Ev();
extern void _ZN9S265C5_nt3v78Ev();
extern void _ZN9S265C5_nt3v79Ev();
extern void _ZN9S265C5_nt3v80Ev();
extern void _ZN9S265C5_nt3v81Ev();
extern void _ZN9S265C5_nt3v82Ev();
extern void _ZN9S265C5_nt3v83Ev();
extern void _ZN9S265C5_nt3v84Ev();
extern void _ZN9S265C5_nt3v85Ev();
extern void _ZN9S265C5_nt3v86Ev();
extern void _ZN9S265C5_nt3v87Ev();
extern void _ZN9S265C5_nt3v88Ev();
extern void _ZN9S265C5_nt3v89Ev();
extern void _ZN9S265C5_nt3v90Ev();
extern void _ZN9S265C5_nt3v91Ev();
extern void _ZN9S265C4_nt3v92Ev();
extern void _ZN9S265C4_nt3v93Ev();
extern void _ZN9S265C4_nt3v94Ev();
extern void _ZN9S265C4_nt3v95Ev();
extern void _ZN9S265C4_nt3v96Ev();
extern void _ZN9S265C4_nt3v97Ev();
extern void _ZN9S265C4_nt3v98Ev();
extern void _ZN9S265C4_nt3v99Ev();
extern void _ZN9S265C4_nt4v100Ev();
extern void _ZN9S265C4_nt4v101Ev();
extern void _ZN9S265C4_nt4v102Ev();
extern void _ZN9S265C4_nt4v103Ev();
extern void _ZN9S265C4_nt4v104Ev();
extern void _ZN9S265C4_nt4v105Ev();
extern void _ZN9S265C4_nt4v106Ev();
extern void _ZN9S265C4_nt4v107Ev();
extern void _ZN9S265C4_nt4v108Ev();
extern void _ZN9S265C4_nt4v109Ev();
extern void _ZN9S265C4_nt4v110Ev();
extern void _ZN9S265C4_nt4v111Ev();
extern void _ZN9S265C3_nt4v112Ev();
extern void _ZN9S265C3_nt4v113Ev();
extern void _ZN9S265C3_nt4v114Ev();
extern void _ZN9S265C3_nt4v115Ev();
static  VTBL_ENTRY vtc_S265C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S265C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S265C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S265C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v115Ev,
};
extern VTBL_ENTRY _ZTI9S265C3_nt[];
VTBL_ENTRY *P__ZTI9S265C3_nt = _ZTI9S265C3_nt; 
extern  VTBL_ENTRY _ZTV9S265C3_nt[];
Class_Descriptor cd_S265C3_nt = {  "S265C3_nt", // class name
  bases_S265C3_nt, 3,
  &(vtc_S265C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S265C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S265C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C2_nt  : S265C3_nt {
  int s265c2f0;
  unsigned int s265c2f1:1;
  virtual  ~S265C2_nt(); // _ZN9S265C2_ntD1Ev
  virtual void  v116(); // _ZN9S265C2_nt4v116Ev
  virtual void  v117(); // _ZN9S265C2_nt4v117Ev
  virtual void  v118(); // _ZN9S265C2_nt4v118Ev
  virtual void  v119(); // _ZN9S265C2_nt4v119Ev
  virtual void  v120(); // _ZN9S265C2_nt4v120Ev
  virtual void  v121(); // _ZN9S265C2_nt4v121Ev
  virtual void  v122(); // _ZN9S265C2_nt4v122Ev
  virtual void  v123(); // _ZN9S265C2_nt4v123Ev
  S265C2_nt(); // tgen
};
//SIG(-1 S265C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC8 FC16{ BC17{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S265C2_nt ::~S265C2_nt(){ note_dtor("S265C2_nt", this);}
void  S265C2_nt ::v116(){vfunc_called(this, "_ZN9S265C2_nt4v116Ev");}
void  S265C2_nt ::v117(){vfunc_called(this, "_ZN9S265C2_nt4v117Ev");}
void  S265C2_nt ::v118(){vfunc_called(this, "_ZN9S265C2_nt4v118Ev");}
void  S265C2_nt ::v119(){vfunc_called(this, "_ZN9S265C2_nt4v119Ev");}
void  S265C2_nt ::v120(){vfunc_called(this, "_ZN9S265C2_nt4v120Ev");}
void  S265C2_nt ::v121(){vfunc_called(this, "_ZN9S265C2_nt4v121Ev");}
void  S265C2_nt ::v122(){vfunc_called(this, "_ZN9S265C2_nt4v122Ev");}
void  S265C2_nt ::v123(){vfunc_called(this, "_ZN9S265C2_nt4v123Ev");}
S265C2_nt ::S265C2_nt(){ note_ctor("S265C2_nt", this);} // tgen

//skip512 S265C2_nt

#else // __cplusplus

extern void _ZN9S265C2_ntC1Ev();
extern void _ZN9S265C2_ntD1Ev();
Name_Map name_map_S265C2_nt[] = {
  NSPAIR(_ZN9S265C2_ntC1Ev),
  NSPAIR(_ZN9S265C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S265C6;
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
extern Class_Descriptor cd_S265C5_nt;
extern VTBL_ENTRY _ZTI9S265C5_nt[];
extern  VTBL_ENTRY _ZTV9S265C5_nt[];
extern Class_Descriptor cd_S265C4_nt;
extern VTBL_ENTRY _ZTI9S265C4_nt[];
extern  VTBL_ENTRY _ZTV9S265C4_nt[];
extern Class_Descriptor cd_S265C3_nt;
extern VTBL_ENTRY _ZTI9S265C3_nt[];
extern  VTBL_ENTRY _ZTV9S265C3_nt[];
static Base_Class bases_S265C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S265C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S265C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S265C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S265C2_nt[];
extern void _ZN9S265C2_ntD1Ev();
extern void _ZN9S265C2_ntD0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
extern void _ZN9S265C5_nt3v70Ev();
extern void _ZN9S265C5_nt3v71Ev();
extern void _ZN9S265C5_nt3v72Ev();
extern void _ZN9S265C5_nt3v73Ev();
extern void _ZN9S265C5_nt3v74Ev();
extern void _ZN9S265C5_nt3v75Ev();
extern void _ZN9S265C5_nt3v76Ev();
extern void _ZN9S265C5_nt3v77Ev();
extern void _ZN9S265C5_nt3v78Ev();
extern void _ZN9S265C5_nt3v79Ev();
extern void _ZN9S265C5_nt3v80Ev();
extern void _ZN9S265C5_nt3v81Ev();
extern void _ZN9S265C5_nt3v82Ev();
extern void _ZN9S265C5_nt3v83Ev();
extern void _ZN9S265C5_nt3v84Ev();
extern void _ZN9S265C5_nt3v85Ev();
extern void _ZN9S265C5_nt3v86Ev();
extern void _ZN9S265C5_nt3v87Ev();
extern void _ZN9S265C5_nt3v88Ev();
extern void _ZN9S265C5_nt3v89Ev();
extern void _ZN9S265C5_nt3v90Ev();
extern void _ZN9S265C5_nt3v91Ev();
extern void _ZN9S265C4_nt3v92Ev();
extern void _ZN9S265C4_nt3v93Ev();
extern void _ZN9S265C4_nt3v94Ev();
extern void _ZN9S265C4_nt3v95Ev();
extern void _ZN9S265C4_nt3v96Ev();
extern void _ZN9S265C4_nt3v97Ev();
extern void _ZN9S265C4_nt3v98Ev();
extern void _ZN9S265C4_nt3v99Ev();
extern void _ZN9S265C4_nt4v100Ev();
extern void _ZN9S265C4_nt4v101Ev();
extern void _ZN9S265C4_nt4v102Ev();
extern void _ZN9S265C4_nt4v103Ev();
extern void _ZN9S265C4_nt4v104Ev();
extern void _ZN9S265C4_nt4v105Ev();
extern void _ZN9S265C4_nt4v106Ev();
extern void _ZN9S265C4_nt4v107Ev();
extern void _ZN9S265C4_nt4v108Ev();
extern void _ZN9S265C4_nt4v109Ev();
extern void _ZN9S265C4_nt4v110Ev();
extern void _ZN9S265C4_nt4v111Ev();
extern void _ZN9S265C3_nt4v112Ev();
extern void _ZN9S265C3_nt4v113Ev();
extern void _ZN9S265C3_nt4v114Ev();
extern void _ZN9S265C3_nt4v115Ev();
extern void _ZN9S265C2_nt4v116Ev();
extern void _ZN9S265C2_nt4v117Ev();
extern void _ZN9S265C2_nt4v118Ev();
extern void _ZN9S265C2_nt4v119Ev();
extern void _ZN9S265C2_nt4v120Ev();
extern void _ZN9S265C2_nt4v121Ev();
extern void _ZN9S265C2_nt4v122Ev();
extern void _ZN9S265C2_nt4v123Ev();
static  VTBL_ENTRY vtc_S265C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S265C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S265C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S265C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v123Ev,
};
extern VTBL_ENTRY _ZTI9S265C2_nt[];
VTBL_ENTRY *P__ZTI9S265C2_nt = _ZTI9S265C2_nt; 
extern  VTBL_ENTRY _ZTV9S265C2_nt[];
Class_Descriptor cd_S265C2_nt = {  "S265C2_nt", // class name
  bases_S265C2_nt, 4,
  &(vtc_S265C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI9S265C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S265C2_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S265C1  : S265C2_nt {
  int s265c1f0;
  unsigned int s265c1f1:1;
  unsigned int s265c1f2:1;
  unsigned int s265c1f3:1;
  int s265c1f4;
  ::S78C39_nt s265c1f5;
  virtual  ~S265C1(); // _ZN6S265C1D1Ev
  virtual void  v1(); // _ZN6S265C12v1Ev
  virtual void  v2(); // _ZN6S265C12v2Ev
  virtual void  v3(); // _ZN6S265C12v3Ev
  virtual void  v4(); // _ZN6S265C12v4Ev
  virtual void  v5(); // _ZN6S265C12v5Ev
  S265C1(); // tgen
};
//SIG(1 S265C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC9 FC17{ BC18{ BC11}} Fi[3]} vd v112 v113 v114 v115 FC7 Fi:1 FC19{ BC20{ BC11}}} vd v116 v117 v118 v119 v120 v121 v122 v123 Fi Fi:1} vd v1 v2 v3 v4 v5 Fi Fi:1 Fi:1 Fi:1 Fi FC8}


 S265C1 ::~S265C1(){ note_dtor("S265C1", this);}
void  S265C1 ::v1(){vfunc_called(this, "_ZN6S265C12v1Ev");}
void  S265C1 ::v2(){vfunc_called(this, "_ZN6S265C12v2Ev");}
void  S265C1 ::v3(){vfunc_called(this, "_ZN6S265C12v3Ev");}
void  S265C1 ::v4(){vfunc_called(this, "_ZN6S265C12v4Ev");}
void  S265C1 ::v5(){vfunc_called(this, "_ZN6S265C12v5Ev");}
S265C1 ::S265C1(){ note_ctor("S265C1", this);} // tgen

static void Test_S265C1()
{
  extern Class_Descriptor cd_S265C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,64)];
    init_test(&cd_S265C1, buf);
    S265C1 *dp, &lv = *(dp=new (buf) S265C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S265C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S265C1)");
    check_base_class_offset(lv, (S265C6*)(S265C5_nt*)(S265C4_nt*)(S265C3_nt*)(S265C2_nt*), 0, "S265C1");
    check_base_class_offset(lv, (S265C5_nt*)(S265C4_nt*)(S265C3_nt*)(S265C2_nt*), 0, "S265C1");
    check_base_class_offset(lv, (S265C4_nt*)(S265C3_nt*)(S265C2_nt*), 0, "S265C1");
    check_base_class_offset(lv, (S265C3_nt*)(S265C2_nt*), 0, "S265C1");
    check_base_class_offset(lv, (S265C2_nt*), 0, "S265C1");
    check_field_offset(lv, s265c1f0, ABISELECT(304,228), "S265C1.s265c1f0");
    set_bf_and_test(lv, s265c1f1, ABISELECT(308,232), 0, 1, 1, "S265C1");
    set_bf_and_test(lv, s265c1f2, ABISELECT(308,232), 1, 1, 1, "S265C1");
    set_bf_and_test(lv, s265c1f3, ABISELECT(308,232), 2, 1, 1, "S265C1");
    check_field_offset(lv, s265c1f4, ABISELECT(312,236), "S265C1.s265c1f4");
    check_field_offset(lv, s265c1f5, ABISELECT(320,240), "S265C1.s265c1f5");
    test_class_info(&lv, &cd_S265C1);
    dp->~S265C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS265C1(Test_S265C1, "S265C1", ABISELECT(336,252));

#else // __cplusplus

extern void _ZN6S265C1C1Ev();
extern void _ZN6S265C1D1Ev();
Name_Map name_map_S265C1[] = {
  NSPAIR(_ZN6S265C1C1Ev),
  NSPAIR(_ZN6S265C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S265C6;
extern VTBL_ENTRY _ZTI6S265C6[];
extern  VTBL_ENTRY _ZTV6S265C6[];
extern Class_Descriptor cd_S265C5_nt;
extern VTBL_ENTRY _ZTI9S265C5_nt[];
extern  VTBL_ENTRY _ZTV9S265C5_nt[];
extern Class_Descriptor cd_S265C4_nt;
extern VTBL_ENTRY _ZTI9S265C4_nt[];
extern  VTBL_ENTRY _ZTV9S265C4_nt[];
extern Class_Descriptor cd_S265C3_nt;
extern VTBL_ENTRY _ZTI9S265C3_nt[];
extern  VTBL_ENTRY _ZTV9S265C3_nt[];
extern Class_Descriptor cd_S265C2_nt;
extern VTBL_ENTRY _ZTI9S265C2_nt[];
extern  VTBL_ENTRY _ZTV9S265C2_nt[];
static Base_Class bases_S265C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S265C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S265C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S265C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S265C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S265C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S265C1[];
extern void _ZN6S265C1D1Ev();
extern void _ZN6S265C1D0Ev();
extern void _ZN6S265C62v6Ev();
extern void _ZN6S265C62v7Ev();
extern void _ZN6S265C62v8Ev();
extern void _ZN6S265C62v9Ev();
extern void _ZN6S265C63v10Ev();
extern void _ZN6S265C63v11Ev();
extern void _ZN6S265C63v12Ev();
extern void _ZN6S265C63v13Ev();
extern void _ZN6S265C63v14Ev();
extern void _ZN6S265C63v15Ev();
extern void _ZN6S265C63v16Ev();
extern void _ZN6S265C63v17Ev();
extern void _ZN6S265C63v18Ev();
extern void _ZN6S265C63v19Ev();
extern void _ZN6S265C63v20Ev();
extern void _ZN6S265C63v21Ev();
extern void _ZN6S265C63v22Ev();
extern void _ZN6S265C63v23Ev();
extern void _ZN6S265C63v24Ev();
extern void _ZN6S265C63v25Ev();
extern void _ZN6S265C63v26Ev();
extern void _ZN6S265C63v27Ev();
extern void _ZN6S265C63v28Ev();
extern void _ZN6S265C63v29Ev();
extern void _ZN6S265C63v30Ev();
extern void _ZN6S265C63v31Ev();
extern void _ZN6S265C63v32Ev();
extern void _ZN6S265C63v33Ev();
extern void _ZN6S265C63v34Ev();
extern void _ZN6S265C63v35Ev();
extern void _ZN6S265C63v36Ev();
extern void _ZN6S265C63v37Ev();
extern void _ZN6S265C63v38Ev();
extern void _ZN6S265C63v39Ev();
extern void _ZN6S265C63v40Ev();
extern void _ZN6S265C63v41Ev();
extern void _ZN6S265C63v42Ev();
extern void _ZN6S265C63v43Ev();
extern void _ZN6S265C63v44Ev();
extern void _ZN6S265C63v45Ev();
extern void _ZN6S265C63v46Ev();
extern void _ZN6S265C63v47Ev();
extern void _ZN6S265C63v48Ev();
extern void _ZN6S265C63v49Ev();
extern void _ZN6S265C63v50Ev();
extern void _ZN6S265C63v51Ev();
extern void _ZN6S265C63v52Ev();
extern void _ZN6S265C63v53Ev();
extern void _ZN6S265C63v54Ev();
extern void _ZN6S265C63v55Ev();
extern void _ZN6S265C63v56Ev();
extern void _ZN6S265C63v57Ev();
extern void _ZN6S265C63v58Ev();
extern void _ZN6S265C63v59Ev();
extern void _ZN6S265C63v60Ev();
extern void _ZN6S265C63v61Ev();
extern void _ZN6S265C63v62Ev();
extern void _ZN6S265C63v63Ev();
extern void _ZN6S265C63v64Ev();
extern void _ZN6S265C63v65Ev();
extern void _ZN6S265C63v66Ev();
extern void _ZN6S265C63v67Ev();
extern void _ZN6S265C63v68Ev();
extern void _ZN6S265C63v69Ev();
extern void _ZN9S265C5_nt3v70Ev();
extern void _ZN9S265C5_nt3v71Ev();
extern void _ZN9S265C5_nt3v72Ev();
extern void _ZN9S265C5_nt3v73Ev();
extern void _ZN9S265C5_nt3v74Ev();
extern void _ZN9S265C5_nt3v75Ev();
extern void _ZN9S265C5_nt3v76Ev();
extern void _ZN9S265C5_nt3v77Ev();
extern void _ZN9S265C5_nt3v78Ev();
extern void _ZN9S265C5_nt3v79Ev();
extern void _ZN9S265C5_nt3v80Ev();
extern void _ZN9S265C5_nt3v81Ev();
extern void _ZN9S265C5_nt3v82Ev();
extern void _ZN9S265C5_nt3v83Ev();
extern void _ZN9S265C5_nt3v84Ev();
extern void _ZN9S265C5_nt3v85Ev();
extern void _ZN9S265C5_nt3v86Ev();
extern void _ZN9S265C5_nt3v87Ev();
extern void _ZN9S265C5_nt3v88Ev();
extern void _ZN9S265C5_nt3v89Ev();
extern void _ZN9S265C5_nt3v90Ev();
extern void _ZN9S265C5_nt3v91Ev();
extern void _ZN9S265C4_nt3v92Ev();
extern void _ZN9S265C4_nt3v93Ev();
extern void _ZN9S265C4_nt3v94Ev();
extern void _ZN9S265C4_nt3v95Ev();
extern void _ZN9S265C4_nt3v96Ev();
extern void _ZN9S265C4_nt3v97Ev();
extern void _ZN9S265C4_nt3v98Ev();
extern void _ZN9S265C4_nt3v99Ev();
extern void _ZN9S265C4_nt4v100Ev();
extern void _ZN9S265C4_nt4v101Ev();
extern void _ZN9S265C4_nt4v102Ev();
extern void _ZN9S265C4_nt4v103Ev();
extern void _ZN9S265C4_nt4v104Ev();
extern void _ZN9S265C4_nt4v105Ev();
extern void _ZN9S265C4_nt4v106Ev();
extern void _ZN9S265C4_nt4v107Ev();
extern void _ZN9S265C4_nt4v108Ev();
extern void _ZN9S265C4_nt4v109Ev();
extern void _ZN9S265C4_nt4v110Ev();
extern void _ZN9S265C4_nt4v111Ev();
extern void _ZN9S265C3_nt4v112Ev();
extern void _ZN9S265C3_nt4v113Ev();
extern void _ZN9S265C3_nt4v114Ev();
extern void _ZN9S265C3_nt4v115Ev();
extern void _ZN9S265C2_nt4v116Ev();
extern void _ZN9S265C2_nt4v117Ev();
extern void _ZN9S265C2_nt4v118Ev();
extern void _ZN9S265C2_nt4v119Ev();
extern void _ZN9S265C2_nt4v120Ev();
extern void _ZN9S265C2_nt4v121Ev();
extern void _ZN9S265C2_nt4v122Ev();
extern void _ZN9S265C2_nt4v123Ev();
extern void _ZN6S265C12v1Ev();
extern void _ZN6S265C12v2Ev();
extern void _ZN6S265C12v3Ev();
extern void _ZN6S265C12v4Ev();
extern void _ZN6S265C12v5Ev();
static  VTBL_ENTRY vtc_S265C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S265C1[0]),
  (VTBL_ENTRY)&_ZN6S265C1D1Ev,
  (VTBL_ENTRY)&_ZN6S265C1D0Ev,
  (VTBL_ENTRY)&_ZN6S265C62v6Ev,
  (VTBL_ENTRY)&_ZN6S265C62v7Ev,
  (VTBL_ENTRY)&_ZN6S265C62v8Ev,
  (VTBL_ENTRY)&_ZN6S265C62v9Ev,
  (VTBL_ENTRY)&_ZN6S265C63v10Ev,
  (VTBL_ENTRY)&_ZN6S265C63v11Ev,
  (VTBL_ENTRY)&_ZN6S265C63v12Ev,
  (VTBL_ENTRY)&_ZN6S265C63v13Ev,
  (VTBL_ENTRY)&_ZN6S265C63v14Ev,
  (VTBL_ENTRY)&_ZN6S265C63v15Ev,
  (VTBL_ENTRY)&_ZN6S265C63v16Ev,
  (VTBL_ENTRY)&_ZN6S265C63v17Ev,
  (VTBL_ENTRY)&_ZN6S265C63v18Ev,
  (VTBL_ENTRY)&_ZN6S265C63v19Ev,
  (VTBL_ENTRY)&_ZN6S265C63v20Ev,
  (VTBL_ENTRY)&_ZN6S265C63v21Ev,
  (VTBL_ENTRY)&_ZN6S265C63v22Ev,
  (VTBL_ENTRY)&_ZN6S265C63v23Ev,
  (VTBL_ENTRY)&_ZN6S265C63v24Ev,
  (VTBL_ENTRY)&_ZN6S265C63v25Ev,
  (VTBL_ENTRY)&_ZN6S265C63v26Ev,
  (VTBL_ENTRY)&_ZN6S265C63v27Ev,
  (VTBL_ENTRY)&_ZN6S265C63v28Ev,
  (VTBL_ENTRY)&_ZN6S265C63v29Ev,
  (VTBL_ENTRY)&_ZN6S265C63v30Ev,
  (VTBL_ENTRY)&_ZN6S265C63v31Ev,
  (VTBL_ENTRY)&_ZN6S265C63v32Ev,
  (VTBL_ENTRY)&_ZN6S265C63v33Ev,
  (VTBL_ENTRY)&_ZN6S265C63v34Ev,
  (VTBL_ENTRY)&_ZN6S265C63v35Ev,
  (VTBL_ENTRY)&_ZN6S265C63v36Ev,
  (VTBL_ENTRY)&_ZN6S265C63v37Ev,
  (VTBL_ENTRY)&_ZN6S265C63v38Ev,
  (VTBL_ENTRY)&_ZN6S265C63v39Ev,
  (VTBL_ENTRY)&_ZN6S265C63v40Ev,
  (VTBL_ENTRY)&_ZN6S265C63v41Ev,
  (VTBL_ENTRY)&_ZN6S265C63v42Ev,
  (VTBL_ENTRY)&_ZN6S265C63v43Ev,
  (VTBL_ENTRY)&_ZN6S265C63v44Ev,
  (VTBL_ENTRY)&_ZN6S265C63v45Ev,
  (VTBL_ENTRY)&_ZN6S265C63v46Ev,
  (VTBL_ENTRY)&_ZN6S265C63v47Ev,
  (VTBL_ENTRY)&_ZN6S265C63v48Ev,
  (VTBL_ENTRY)&_ZN6S265C63v49Ev,
  (VTBL_ENTRY)&_ZN6S265C63v50Ev,
  (VTBL_ENTRY)&_ZN6S265C63v51Ev,
  (VTBL_ENTRY)&_ZN6S265C63v52Ev,
  (VTBL_ENTRY)&_ZN6S265C63v53Ev,
  (VTBL_ENTRY)&_ZN6S265C63v54Ev,
  (VTBL_ENTRY)&_ZN6S265C63v55Ev,
  (VTBL_ENTRY)&_ZN6S265C63v56Ev,
  (VTBL_ENTRY)&_ZN6S265C63v57Ev,
  (VTBL_ENTRY)&_ZN6S265C63v58Ev,
  (VTBL_ENTRY)&_ZN6S265C63v59Ev,
  (VTBL_ENTRY)&_ZN6S265C63v60Ev,
  (VTBL_ENTRY)&_ZN6S265C63v61Ev,
  (VTBL_ENTRY)&_ZN6S265C63v62Ev,
  (VTBL_ENTRY)&_ZN6S265C63v63Ev,
  (VTBL_ENTRY)&_ZN6S265C63v64Ev,
  (VTBL_ENTRY)&_ZN6S265C63v65Ev,
  (VTBL_ENTRY)&_ZN6S265C63v66Ev,
  (VTBL_ENTRY)&_ZN6S265C63v67Ev,
  (VTBL_ENTRY)&_ZN6S265C63v68Ev,
  (VTBL_ENTRY)&_ZN6S265C63v69Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S265C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S265C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S265C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S265C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN6S265C12v1Ev,
  (VTBL_ENTRY)&_ZN6S265C12v2Ev,
  (VTBL_ENTRY)&_ZN6S265C12v3Ev,
  (VTBL_ENTRY)&_ZN6S265C12v4Ev,
  (VTBL_ENTRY)&_ZN6S265C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S265C1[];
extern  VTBL_ENTRY _ZTV6S265C1[];
Class_Descriptor cd_S265C1 = {  "S265C1", // class name
  bases_S265C1, 5,
  &(vtc_S265C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,252), // object size
  NSPAIRA(_ZTI6S265C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S265C1),127, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C6  {
  int s202c6f0;
  __tsi64 s202c6f1;
  void *s202c6f2[4];
  int s202c6f3[2];
  void *s202c6f4;
  ::S78C8_nt s202c6f5;
  void *s202c6f6[2];
  virtual  ~S202C6(); // _ZN6S202C6D1Ev
  virtual void  v4(); // _ZN6S202C62v4Ev
  virtual void  v5(); // _ZN6S202C62v5Ev
  virtual void  v6(); // _ZN6S202C62v6Ev
  virtual void  v7(); // _ZN6S202C62v7Ev
  virtual void  v8(); // _ZN6S202C62v8Ev
  virtual void  v9(); // _ZN6S202C62v9Ev
  virtual void  v10(); // _ZN6S202C63v10Ev
  virtual void  v11(); // _ZN6S202C63v11Ev
  virtual void  v12(); // _ZN6S202C63v12Ev
  virtual void  v13(); // _ZN6S202C63v13Ev
  virtual void  v14(); // _ZN6S202C63v14Ev
  virtual void  v15(); // _ZN6S202C63v15Ev
  virtual void  v16(); // _ZN6S202C63v16Ev
  virtual void  v17(); // _ZN6S202C63v17Ev
  virtual void  v18(); // _ZN6S202C63v18Ev
  virtual void  v19(); // _ZN6S202C63v19Ev
  virtual void  v20(); // _ZN6S202C63v20Ev
  virtual void  v21(); // _ZN6S202C63v21Ev
  virtual void  v22(); // _ZN6S202C63v22Ev
  virtual void  v23(); // _ZN6S202C63v23Ev
  virtual void  v24(); // _ZN6S202C63v24Ev
  virtual void  v25(); // _ZN6S202C63v25Ev
  virtual void  v26(); // _ZN6S202C63v26Ev
  virtual void  v27(); // _ZN6S202C63v27Ev
  virtual void  v28(); // _ZN6S202C63v28Ev
  virtual void  v29(); // _ZN6S202C63v29Ev
  virtual void  v30(); // _ZN6S202C63v30Ev
  virtual void  v31(); // _ZN6S202C63v31Ev
  virtual void  v32(); // _ZN6S202C63v32Ev
  virtual void  v33(); // _ZN6S202C63v33Ev
  virtual void  v34(); // _ZN6S202C63v34Ev
  virtual void  v35(); // _ZN6S202C63v35Ev
  virtual void  v36(); // _ZN6S202C63v36Ev
  virtual void  v37(); // _ZN6S202C63v37Ev
  virtual void  v38(); // _ZN6S202C63v38Ev
  virtual void  v39(); // _ZN6S202C63v39Ev
  virtual void  v40(); // _ZN6S202C63v40Ev
  virtual void  v41(); // _ZN6S202C63v41Ev
  virtual void  v42(); // _ZN6S202C63v42Ev
  virtual void  v43(); // _ZN6S202C63v43Ev
  virtual void  v44(); // _ZN6S202C63v44Ev
  virtual void  v45(); // _ZN6S202C63v45Ev
  virtual void  v46(); // _ZN6S202C63v46Ev
  virtual void  v47(); // _ZN6S202C63v47Ev
  virtual void  v48(); // _ZN6S202C63v48Ev
  virtual void  v49(); // _ZN6S202C63v49Ev
  virtual void  v50(); // _ZN6S202C63v50Ev
  virtual void  v51(); // _ZN6S202C63v51Ev
  virtual void  v52(); // _ZN6S202C63v52Ev
  virtual void  v53(); // _ZN6S202C63v53Ev
  virtual void  v54(); // _ZN6S202C63v54Ev
  virtual void  v55(); // _ZN6S202C63v55Ev
  virtual void  v56(); // _ZN6S202C63v56Ev
  virtual void  v57(); // _ZN6S202C63v57Ev
  virtual void  v58(); // _ZN6S202C63v58Ev
  virtual void  v59(); // _ZN6S202C63v59Ev
  virtual void  v60(); // _ZN6S202C63v60Ev
  virtual void  v61(); // _ZN6S202C63v61Ev
  virtual void  v62(); // _ZN6S202C63v62Ev
  virtual void  v63(); // _ZN6S202C63v63Ev
  virtual void  v64(); // _ZN6S202C63v64Ev
  virtual void  v65(); // _ZN6S202C63v65Ev
  virtual void  v66(); // _ZN6S202C63v66Ev
  virtual void  v67(); // _ZN6S202C63v67Ev
  S202C6(); // tgen
};
//SIG(-1 S202C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S202C6 ::~S202C6(){ note_dtor("S202C6", this);}
void  S202C6 ::v4(){vfunc_called(this, "_ZN6S202C62v4Ev");}
void  S202C6 ::v5(){vfunc_called(this, "_ZN6S202C62v5Ev");}
void  S202C6 ::v6(){vfunc_called(this, "_ZN6S202C62v6Ev");}
void  S202C6 ::v7(){vfunc_called(this, "_ZN6S202C62v7Ev");}
void  S202C6 ::v8(){vfunc_called(this, "_ZN6S202C62v8Ev");}
void  S202C6 ::v9(){vfunc_called(this, "_ZN6S202C62v9Ev");}
void  S202C6 ::v10(){vfunc_called(this, "_ZN6S202C63v10Ev");}
void  S202C6 ::v11(){vfunc_called(this, "_ZN6S202C63v11Ev");}
void  S202C6 ::v12(){vfunc_called(this, "_ZN6S202C63v12Ev");}
void  S202C6 ::v13(){vfunc_called(this, "_ZN6S202C63v13Ev");}
void  S202C6 ::v14(){vfunc_called(this, "_ZN6S202C63v14Ev");}
void  S202C6 ::v15(){vfunc_called(this, "_ZN6S202C63v15Ev");}
void  S202C6 ::v16(){vfunc_called(this, "_ZN6S202C63v16Ev");}
void  S202C6 ::v17(){vfunc_called(this, "_ZN6S202C63v17Ev");}
void  S202C6 ::v18(){vfunc_called(this, "_ZN6S202C63v18Ev");}
void  S202C6 ::v19(){vfunc_called(this, "_ZN6S202C63v19Ev");}
void  S202C6 ::v20(){vfunc_called(this, "_ZN6S202C63v20Ev");}
void  S202C6 ::v21(){vfunc_called(this, "_ZN6S202C63v21Ev");}
void  S202C6 ::v22(){vfunc_called(this, "_ZN6S202C63v22Ev");}
void  S202C6 ::v23(){vfunc_called(this, "_ZN6S202C63v23Ev");}
void  S202C6 ::v24(){vfunc_called(this, "_ZN6S202C63v24Ev");}
void  S202C6 ::v25(){vfunc_called(this, "_ZN6S202C63v25Ev");}
void  S202C6 ::v26(){vfunc_called(this, "_ZN6S202C63v26Ev");}
void  S202C6 ::v27(){vfunc_called(this, "_ZN6S202C63v27Ev");}
void  S202C6 ::v28(){vfunc_called(this, "_ZN6S202C63v28Ev");}
void  S202C6 ::v29(){vfunc_called(this, "_ZN6S202C63v29Ev");}
void  S202C6 ::v30(){vfunc_called(this, "_ZN6S202C63v30Ev");}
void  S202C6 ::v31(){vfunc_called(this, "_ZN6S202C63v31Ev");}
void  S202C6 ::v32(){vfunc_called(this, "_ZN6S202C63v32Ev");}
void  S202C6 ::v33(){vfunc_called(this, "_ZN6S202C63v33Ev");}
void  S202C6 ::v34(){vfunc_called(this, "_ZN6S202C63v34Ev");}
void  S202C6 ::v35(){vfunc_called(this, "_ZN6S202C63v35Ev");}
void  S202C6 ::v36(){vfunc_called(this, "_ZN6S202C63v36Ev");}
void  S202C6 ::v37(){vfunc_called(this, "_ZN6S202C63v37Ev");}
void  S202C6 ::v38(){vfunc_called(this, "_ZN6S202C63v38Ev");}
void  S202C6 ::v39(){vfunc_called(this, "_ZN6S202C63v39Ev");}
void  S202C6 ::v40(){vfunc_called(this, "_ZN6S202C63v40Ev");}
void  S202C6 ::v41(){vfunc_called(this, "_ZN6S202C63v41Ev");}
void  S202C6 ::v42(){vfunc_called(this, "_ZN6S202C63v42Ev");}
void  S202C6 ::v43(){vfunc_called(this, "_ZN6S202C63v43Ev");}
void  S202C6 ::v44(){vfunc_called(this, "_ZN6S202C63v44Ev");}
void  S202C6 ::v45(){vfunc_called(this, "_ZN6S202C63v45Ev");}
void  S202C6 ::v46(){vfunc_called(this, "_ZN6S202C63v46Ev");}
void  S202C6 ::v47(){vfunc_called(this, "_ZN6S202C63v47Ev");}
void  S202C6 ::v48(){vfunc_called(this, "_ZN6S202C63v48Ev");}
void  S202C6 ::v49(){vfunc_called(this, "_ZN6S202C63v49Ev");}
void  S202C6 ::v50(){vfunc_called(this, "_ZN6S202C63v50Ev");}
void  S202C6 ::v51(){vfunc_called(this, "_ZN6S202C63v51Ev");}
void  S202C6 ::v52(){vfunc_called(this, "_ZN6S202C63v52Ev");}
void  S202C6 ::v53(){vfunc_called(this, "_ZN6S202C63v53Ev");}
void  S202C6 ::v54(){vfunc_called(this, "_ZN6S202C63v54Ev");}
void  S202C6 ::v55(){vfunc_called(this, "_ZN6S202C63v55Ev");}
void  S202C6 ::v56(){vfunc_called(this, "_ZN6S202C63v56Ev");}
void  S202C6 ::v57(){vfunc_called(this, "_ZN6S202C63v57Ev");}
void  S202C6 ::v58(){vfunc_called(this, "_ZN6S202C63v58Ev");}
void  S202C6 ::v59(){vfunc_called(this, "_ZN6S202C63v59Ev");}
void  S202C6 ::v60(){vfunc_called(this, "_ZN6S202C63v60Ev");}
void  S202C6 ::v61(){vfunc_called(this, "_ZN6S202C63v61Ev");}
void  S202C6 ::v62(){vfunc_called(this, "_ZN6S202C63v62Ev");}
void  S202C6 ::v63(){vfunc_called(this, "_ZN6S202C63v63Ev");}
void  S202C6 ::v64(){vfunc_called(this, "_ZN6S202C63v64Ev");}
void  S202C6 ::v65(){vfunc_called(this, "_ZN6S202C63v65Ev");}
void  S202C6 ::v66(){vfunc_called(this, "_ZN6S202C63v66Ev");}
void  S202C6 ::v67(){vfunc_called(this, "_ZN6S202C63v67Ev");}
S202C6 ::S202C6(){ note_ctor("S202C6", this);} // tgen

static void Test_S202C6()
{
  extern Class_Descriptor cd_S202C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S202C6, buf);
    S202C6 *dp, &lv = *(dp=new (buf) S202C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S202C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C6)");
    check_field_offset(lv, s202c6f0, ABISELECT(8,4), "S202C6.s202c6f0");
    check_field_offset(lv, s202c6f1, ABISELECT(16,8), "S202C6.s202c6f1");
    check_field_offset(lv, s202c6f2, ABISELECT(24,16), "S202C6.s202c6f2");
    check_field_offset(lv, s202c6f3, ABISELECT(56,32), "S202C6.s202c6f3");
    check_field_offset(lv, s202c6f4, ABISELECT(64,40), "S202C6.s202c6f4");
    check_field_offset(lv, s202c6f5, ABISELECT(72,44), "S202C6.s202c6f5");
    check_field_offset(lv, s202c6f6, ABISELECT(80,52), "S202C6.s202c6f6");
    test_class_info(&lv, &cd_S202C6);
    dp->~S202C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C6(Test_S202C6, "S202C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S202C6C1Ev();
extern void _ZN6S202C6D1Ev();
Name_Map name_map_S202C6[] = {
  NSPAIR(_ZN6S202C6C1Ev),
  NSPAIR(_ZN6S202C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S202C6[];
extern void _ZN6S202C6D1Ev();
extern void _ZN6S202C6D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
static  VTBL_ENTRY vtc_S202C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C6[0]),
  (VTBL_ENTRY)&_ZN6S202C6D1Ev,
  (VTBL_ENTRY)&_ZN6S202C6D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
Class_Descriptor cd_S202C6 = {  "S202C6", // class name
  0,0,//no base classes
  &(vtc_S202C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S202C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S202C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C5  : S202C6 {
  int s202c5f0[2];
  void *s202c5f1;
  int s202c5f2[2];
  ::S78C39_nt s202c5f3;
  ::S78C39_nt s202c5f4;
  ::S5328C29 s202c5f5;
  ::S78C39_nt s202c5f6;
  unsigned int s202c5f7:1;
  unsigned int s202c5f8:1;
  unsigned int s202c5f9:1;
  unsigned int s202c5f10:1;
  unsigned int s202c5f11:1;
  int s202c5f12[2];
  virtual  ~S202C5(); // _ZN6S202C5D1Ev
  virtual void  v68(); // _ZN6S202C53v68Ev
  virtual void  v69(); // _ZN6S202C53v69Ev
  virtual void  v70(); // _ZN6S202C53v70Ev
  virtual void  v71(); // _ZN6S202C53v71Ev
  virtual void  v72(); // _ZN6S202C53v72Ev
  virtual void  v73(); // _ZN6S202C53v73Ev
  virtual void  v74(); // _ZN6S202C53v74Ev
  virtual void  v75(); // _ZN6S202C53v75Ev
  virtual void  v76(); // _ZN6S202C53v76Ev
  virtual void  v77(); // _ZN6S202C53v77Ev
  virtual void  v78(); // _ZN6S202C53v78Ev
  virtual void  v79(); // _ZN6S202C53v79Ev
  virtual void  v80(); // _ZN6S202C53v80Ev
  virtual void  v81(); // _ZN6S202C53v81Ev
  virtual void  v82(); // _ZN6S202C53v82Ev
  virtual void  v83(); // _ZN6S202C53v83Ev
  virtual void  v84(); // _ZN6S202C53v84Ev
  virtual void  v85(); // _ZN6S202C53v85Ev
  virtual void  v86(); // _ZN6S202C53v86Ev
  virtual void  v87(); // _ZN6S202C53v87Ev
  virtual void  v88(); // _ZN6S202C53v88Ev
  virtual void  v89(); // _ZN6S202C53v89Ev
  S202C5(); // tgen
};
//SIG(-1 S202C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S202C5 ::~S202C5(){ note_dtor("S202C5", this);}
void  S202C5 ::v68(){vfunc_called(this, "_ZN6S202C53v68Ev");}
void  S202C5 ::v69(){vfunc_called(this, "_ZN6S202C53v69Ev");}
void  S202C5 ::v70(){vfunc_called(this, "_ZN6S202C53v70Ev");}
void  S202C5 ::v71(){vfunc_called(this, "_ZN6S202C53v71Ev");}
void  S202C5 ::v72(){vfunc_called(this, "_ZN6S202C53v72Ev");}
void  S202C5 ::v73(){vfunc_called(this, "_ZN6S202C53v73Ev");}
void  S202C5 ::v74(){vfunc_called(this, "_ZN6S202C53v74Ev");}
void  S202C5 ::v75(){vfunc_called(this, "_ZN6S202C53v75Ev");}
void  S202C5 ::v76(){vfunc_called(this, "_ZN6S202C53v76Ev");}
void  S202C5 ::v77(){vfunc_called(this, "_ZN6S202C53v77Ev");}
void  S202C5 ::v78(){vfunc_called(this, "_ZN6S202C53v78Ev");}
void  S202C5 ::v79(){vfunc_called(this, "_ZN6S202C53v79Ev");}
void  S202C5 ::v80(){vfunc_called(this, "_ZN6S202C53v80Ev");}
void  S202C5 ::v81(){vfunc_called(this, "_ZN6S202C53v81Ev");}
void  S202C5 ::v82(){vfunc_called(this, "_ZN6S202C53v82Ev");}
void  S202C5 ::v83(){vfunc_called(this, "_ZN6S202C53v83Ev");}
void  S202C5 ::v84(){vfunc_called(this, "_ZN6S202C53v84Ev");}
void  S202C5 ::v85(){vfunc_called(this, "_ZN6S202C53v85Ev");}
void  S202C5 ::v86(){vfunc_called(this, "_ZN6S202C53v86Ev");}
void  S202C5 ::v87(){vfunc_called(this, "_ZN6S202C53v87Ev");}
void  S202C5 ::v88(){vfunc_called(this, "_ZN6S202C53v88Ev");}
void  S202C5 ::v89(){vfunc_called(this, "_ZN6S202C53v89Ev");}
S202C5 ::S202C5(){ note_ctor("S202C5", this);} // tgen

static void Test_S202C5()
{
  extern Class_Descriptor cd_S202C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S202C5, buf);
    S202C5 *dp, &lv = *(dp=new (buf) S202C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S202C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C5)");
    check_base_class_offset(lv, (S202C6*), 0, "S202C5");
    check_field_offset(lv, s202c5f0, ABISELECT(96,60), "S202C5.s202c5f0");
    check_field_offset(lv, s202c5f1, ABISELECT(104,68), "S202C5.s202c5f1");
    check_field_offset(lv, s202c5f2, ABISELECT(112,72), "S202C5.s202c5f2");
    check_field_offset(lv, s202c5f3, ABISELECT(120,80), "S202C5.s202c5f3");
    check_field_offset(lv, s202c5f4, ABISELECT(136,92), "S202C5.s202c5f4");
    check_field_offset(lv, s202c5f5, ABISELECT(152,104), "S202C5.s202c5f5");
    check_field_offset(lv, s202c5f6, ABISELECT(160,108), "S202C5.s202c5f6");
    set_bf_and_test(lv, s202c5f7, ABISELECT(176,120), 0, 1, 1, "S202C5");
    set_bf_and_test(lv, s202c5f8, ABISELECT(176,120), 1, 1, 1, "S202C5");
    set_bf_and_test(lv, s202c5f9, ABISELECT(176,120), 2, 1, 1, "S202C5");
    set_bf_and_test(lv, s202c5f10, ABISELECT(176,120), 3, 1, 1, "S202C5");
    set_bf_and_test(lv, s202c5f11, ABISELECT(176,120), 4, 1, 1, "S202C5");
    check_field_offset(lv, s202c5f12, ABISELECT(180,124), "S202C5.s202c5f12");
    test_class_info(&lv, &cd_S202C5);
    dp->~S202C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C5(Test_S202C5, "S202C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S202C5C1Ev();
extern void _ZN6S202C5D1Ev();
Name_Map name_map_S202C5[] = {
  NSPAIR(_ZN6S202C5C1Ev),
  NSPAIR(_ZN6S202C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S202C6;
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
static Base_Class bases_S202C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S202C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S202C5[];
extern void _ZN6S202C5D1Ev();
extern void _ZN6S202C5D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
extern void _ZN6S202C53v68Ev();
extern void _ZN6S202C53v69Ev();
extern void _ZN6S202C53v70Ev();
extern void _ZN6S202C53v71Ev();
extern void _ZN6S202C53v72Ev();
extern void _ZN6S202C53v73Ev();
extern void _ZN6S202C53v74Ev();
extern void _ZN6S202C53v75Ev();
extern void _ZN6S202C53v76Ev();
extern void _ZN6S202C53v77Ev();
extern void _ZN6S202C53v78Ev();
extern void _ZN6S202C53v79Ev();
extern void _ZN6S202C53v80Ev();
extern void _ZN6S202C53v81Ev();
extern void _ZN6S202C53v82Ev();
extern void _ZN6S202C53v83Ev();
extern void _ZN6S202C53v84Ev();
extern void _ZN6S202C53v85Ev();
extern void _ZN6S202C53v86Ev();
extern void _ZN6S202C53v87Ev();
extern void _ZN6S202C53v88Ev();
extern void _ZN6S202C53v89Ev();
static  VTBL_ENTRY vtc_S202C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C5[0]),
  (VTBL_ENTRY)&_ZN6S202C5D1Ev,
  (VTBL_ENTRY)&_ZN6S202C5D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
  (VTBL_ENTRY)&_ZN6S202C53v68Ev,
  (VTBL_ENTRY)&_ZN6S202C53v69Ev,
  (VTBL_ENTRY)&_ZN6S202C53v70Ev,
  (VTBL_ENTRY)&_ZN6S202C53v71Ev,
  (VTBL_ENTRY)&_ZN6S202C53v72Ev,
  (VTBL_ENTRY)&_ZN6S202C53v73Ev,
  (VTBL_ENTRY)&_ZN6S202C53v74Ev,
  (VTBL_ENTRY)&_ZN6S202C53v75Ev,
  (VTBL_ENTRY)&_ZN6S202C53v76Ev,
  (VTBL_ENTRY)&_ZN6S202C53v77Ev,
  (VTBL_ENTRY)&_ZN6S202C53v78Ev,
  (VTBL_ENTRY)&_ZN6S202C53v79Ev,
  (VTBL_ENTRY)&_ZN6S202C53v80Ev,
  (VTBL_ENTRY)&_ZN6S202C53v81Ev,
  (VTBL_ENTRY)&_ZN6S202C53v82Ev,
  (VTBL_ENTRY)&_ZN6S202C53v83Ev,
  (VTBL_ENTRY)&_ZN6S202C53v84Ev,
  (VTBL_ENTRY)&_ZN6S202C53v85Ev,
  (VTBL_ENTRY)&_ZN6S202C53v86Ev,
  (VTBL_ENTRY)&_ZN6S202C53v87Ev,
  (VTBL_ENTRY)&_ZN6S202C53v88Ev,
  (VTBL_ENTRY)&_ZN6S202C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S202C5[];
extern  VTBL_ENTRY _ZTV6S202C5[];
Class_Descriptor cd_S202C5 = {  "S202C5", // class name
  bases_S202C5, 1,
  &(vtc_S202C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S202C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S202C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C4  : S202C5 {
  unsigned int s202c4f0:1;
  unsigned int s202c4f1:1;
  unsigned int s202c4f2:1;
  ::S78C49 s202c4f3;
  ::S78C44 s202c4f4;
  ::S78C40 s202c4f5;
  ::S78C19 s202c4f6;
  int s202c4f7[3];
  virtual  ~S202C4(); // _ZN6S202C4D1Ev
  virtual void  v90(); // _ZN6S202C43v90Ev
  virtual void  v91(); // _ZN6S202C43v91Ev
  virtual void  v92(); // _ZN6S202C43v92Ev
  virtual void  v93(); // _ZN6S202C43v93Ev
  virtual void  v94(); // _ZN6S202C43v94Ev
  virtual void  v95(); // _ZN6S202C43v95Ev
  virtual void  v96(); // _ZN6S202C43v96Ev
  virtual void  v97(); // _ZN6S202C43v97Ev
  virtual void  v98(); // _ZN6S202C43v98Ev
  virtual void  v99(); // _ZN6S202C43v99Ev
  virtual void  v100(); // _ZN6S202C44v100Ev
  virtual void  v101(); // _ZN6S202C44v101Ev
  virtual void  v102(); // _ZN6S202C44v102Ev
  virtual void  v103(); // _ZN6S202C44v103Ev
  virtual void  v104(); // _ZN6S202C44v104Ev
  virtual void  v105(); // _ZN6S202C44v105Ev
  virtual void  v106(); // _ZN6S202C44v106Ev
  virtual void  v107(); // _ZN6S202C44v107Ev
  virtual void  v108(); // _ZN6S202C44v108Ev
  virtual void  v109(); // _ZN6S202C44v109Ev
  S202C4(); // tgen
};
//SIG(-1 S202C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC6 FC14{ BC15{ BC8}} Fi[3]}


 S202C4 ::~S202C4(){ note_dtor("S202C4", this);}
void  S202C4 ::v90(){vfunc_called(this, "_ZN6S202C43v90Ev");}
void  S202C4 ::v91(){vfunc_called(this, "_ZN6S202C43v91Ev");}
void  S202C4 ::v92(){vfunc_called(this, "_ZN6S202C43v92Ev");}
void  S202C4 ::v93(){vfunc_called(this, "_ZN6S202C43v93Ev");}
void  S202C4 ::v94(){vfunc_called(this, "_ZN6S202C43v94Ev");}
void  S202C4 ::v95(){vfunc_called(this, "_ZN6S202C43v95Ev");}
void  S202C4 ::v96(){vfunc_called(this, "_ZN6S202C43v96Ev");}
void  S202C4 ::v97(){vfunc_called(this, "_ZN6S202C43v97Ev");}
void  S202C4 ::v98(){vfunc_called(this, "_ZN6S202C43v98Ev");}
void  S202C4 ::v99(){vfunc_called(this, "_ZN6S202C43v99Ev");}
void  S202C4 ::v100(){vfunc_called(this, "_ZN6S202C44v100Ev");}
void  S202C4 ::v101(){vfunc_called(this, "_ZN6S202C44v101Ev");}
void  S202C4 ::v102(){vfunc_called(this, "_ZN6S202C44v102Ev");}
void  S202C4 ::v103(){vfunc_called(this, "_ZN6S202C44v103Ev");}
void  S202C4 ::v104(){vfunc_called(this, "_ZN6S202C44v104Ev");}
void  S202C4 ::v105(){vfunc_called(this, "_ZN6S202C44v105Ev");}
void  S202C4 ::v106(){vfunc_called(this, "_ZN6S202C44v106Ev");}
void  S202C4 ::v107(){vfunc_called(this, "_ZN6S202C44v107Ev");}
void  S202C4 ::v108(){vfunc_called(this, "_ZN6S202C44v108Ev");}
void  S202C4 ::v109(){vfunc_called(this, "_ZN6S202C44v109Ev");}
S202C4 ::S202C4(){ note_ctor("S202C4", this);} // tgen

static void Test_S202C4()
{
  extern Class_Descriptor cd_S202C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S202C4, buf);
    S202C4 *dp, &lv = *(dp=new (buf) S202C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S202C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C4)");
    check_base_class_offset(lv, (S202C6*)(S202C5*), 0, "S202C4");
    check_base_class_offset(lv, (S202C5*), 0, "S202C4");
    set_bf_and_test(lv, s202c4f0, ABISELECT(188,132), 0, 1, 1, "S202C4");
    set_bf_and_test(lv, s202c4f1, ABISELECT(188,132), 1, 1, 1, "S202C4");
    set_bf_and_test(lv, s202c4f2, ABISELECT(188,132), 2, 1, 1, "S202C4");
    check_field_offset(lv, s202c4f3, ABISELECT(192,136), "S202C4.s202c4f3");
    check_field_offset(lv, s202c4f4, ABISELECT(208,148), "S202C4.s202c4f4");
    check_field_offset(lv, s202c4f5, ABISELECT(224,160), "S202C4.s202c4f5");
    check_field_offset(lv, s202c4f6, ABISELECT(240,172), "S202C4.s202c4f6");
    check_field_offset(lv, s202c4f7, ABISELECT(256,184), "S202C4.s202c4f7");
    test_class_info(&lv, &cd_S202C4);
    dp->~S202C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C4(Test_S202C4, "S202C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S202C4C1Ev();
extern void _ZN6S202C4D1Ev();
Name_Map name_map_S202C4[] = {
  NSPAIR(_ZN6S202C4C1Ev),
  NSPAIR(_ZN6S202C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S202C6;
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
extern Class_Descriptor cd_S202C5;
extern VTBL_ENTRY _ZTI6S202C5[];
extern  VTBL_ENTRY _ZTV6S202C5[];
static Base_Class bases_S202C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S202C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S202C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S202C4[];
extern void _ZN6S202C4D1Ev();
extern void _ZN6S202C4D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
extern void _ZN6S202C53v68Ev();
extern void _ZN6S202C53v69Ev();
extern void _ZN6S202C53v70Ev();
extern void _ZN6S202C53v71Ev();
extern void _ZN6S202C53v72Ev();
extern void _ZN6S202C53v73Ev();
extern void _ZN6S202C53v74Ev();
extern void _ZN6S202C53v75Ev();
extern void _ZN6S202C53v76Ev();
extern void _ZN6S202C53v77Ev();
extern void _ZN6S202C53v78Ev();
extern void _ZN6S202C53v79Ev();
extern void _ZN6S202C53v80Ev();
extern void _ZN6S202C53v81Ev();
extern void _ZN6S202C53v82Ev();
extern void _ZN6S202C53v83Ev();
extern void _ZN6S202C53v84Ev();
extern void _ZN6S202C53v85Ev();
extern void _ZN6S202C53v86Ev();
extern void _ZN6S202C53v87Ev();
extern void _ZN6S202C53v88Ev();
extern void _ZN6S202C53v89Ev();
extern void _ZN6S202C43v90Ev();
extern void _ZN6S202C43v91Ev();
extern void _ZN6S202C43v92Ev();
extern void _ZN6S202C43v93Ev();
extern void _ZN6S202C43v94Ev();
extern void _ZN6S202C43v95Ev();
extern void _ZN6S202C43v96Ev();
extern void _ZN6S202C43v97Ev();
extern void _ZN6S202C43v98Ev();
extern void _ZN6S202C43v99Ev();
extern void _ZN6S202C44v100Ev();
extern void _ZN6S202C44v101Ev();
extern void _ZN6S202C44v102Ev();
extern void _ZN6S202C44v103Ev();
extern void _ZN6S202C44v104Ev();
extern void _ZN6S202C44v105Ev();
extern void _ZN6S202C44v106Ev();
extern void _ZN6S202C44v107Ev();
extern void _ZN6S202C44v108Ev();
extern void _ZN6S202C44v109Ev();
static  VTBL_ENTRY vtc_S202C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C4[0]),
  (VTBL_ENTRY)&_ZN6S202C4D1Ev,
  (VTBL_ENTRY)&_ZN6S202C4D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
  (VTBL_ENTRY)&_ZN6S202C53v68Ev,
  (VTBL_ENTRY)&_ZN6S202C53v69Ev,
  (VTBL_ENTRY)&_ZN6S202C53v70Ev,
  (VTBL_ENTRY)&_ZN6S202C53v71Ev,
  (VTBL_ENTRY)&_ZN6S202C53v72Ev,
  (VTBL_ENTRY)&_ZN6S202C53v73Ev,
  (VTBL_ENTRY)&_ZN6S202C53v74Ev,
  (VTBL_ENTRY)&_ZN6S202C53v75Ev,
  (VTBL_ENTRY)&_ZN6S202C53v76Ev,
  (VTBL_ENTRY)&_ZN6S202C53v77Ev,
  (VTBL_ENTRY)&_ZN6S202C53v78Ev,
  (VTBL_ENTRY)&_ZN6S202C53v79Ev,
  (VTBL_ENTRY)&_ZN6S202C53v80Ev,
  (VTBL_ENTRY)&_ZN6S202C53v81Ev,
  (VTBL_ENTRY)&_ZN6S202C53v82Ev,
  (VTBL_ENTRY)&_ZN6S202C53v83Ev,
  (VTBL_ENTRY)&_ZN6S202C53v84Ev,
  (VTBL_ENTRY)&_ZN6S202C53v85Ev,
  (VTBL_ENTRY)&_ZN6S202C53v86Ev,
  (VTBL_ENTRY)&_ZN6S202C53v87Ev,
  (VTBL_ENTRY)&_ZN6S202C53v88Ev,
  (VTBL_ENTRY)&_ZN6S202C53v89Ev,
  (VTBL_ENTRY)&_ZN6S202C43v90Ev,
  (VTBL_ENTRY)&_ZN6S202C43v91Ev,
  (VTBL_ENTRY)&_ZN6S202C43v92Ev,
  (VTBL_ENTRY)&_ZN6S202C43v93Ev,
  (VTBL_ENTRY)&_ZN6S202C43v94Ev,
  (VTBL_ENTRY)&_ZN6S202C43v95Ev,
  (VTBL_ENTRY)&_ZN6S202C43v96Ev,
  (VTBL_ENTRY)&_ZN6S202C43v97Ev,
  (VTBL_ENTRY)&_ZN6S202C43v98Ev,
  (VTBL_ENTRY)&_ZN6S202C43v99Ev,
  (VTBL_ENTRY)&_ZN6S202C44v100Ev,
  (VTBL_ENTRY)&_ZN6S202C44v101Ev,
  (VTBL_ENTRY)&_ZN6S202C44v102Ev,
  (VTBL_ENTRY)&_ZN6S202C44v103Ev,
  (VTBL_ENTRY)&_ZN6S202C44v104Ev,
  (VTBL_ENTRY)&_ZN6S202C44v105Ev,
  (VTBL_ENTRY)&_ZN6S202C44v106Ev,
  (VTBL_ENTRY)&_ZN6S202C44v107Ev,
  (VTBL_ENTRY)&_ZN6S202C44v108Ev,
  (VTBL_ENTRY)&_ZN6S202C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S202C4[];
extern  VTBL_ENTRY _ZTV6S202C4[];
Class_Descriptor cd_S202C4 = {  "S202C4", // class name
  bases_S202C4, 2,
  &(vtc_S202C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S202C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S202C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C3  : S202C4 {
  ::S78C8_nt s202c3f0;
  unsigned int s202c3f1:1;
  ::S78C15 s202c3f2;
  virtual  ~S202C3(); // _ZN6S202C3D1Ev
  virtual void  v110(); // _ZN6S202C34v110Ev
  virtual void  v111(); // _ZN6S202C34v111Ev
  virtual void  v112(); // _ZN6S202C34v112Ev
  virtual void  v113(); // _ZN6S202C34v113Ev
  S202C3(); // tgen
};
//SIG(-1 S202C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC7 FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S202C3 ::~S202C3(){ note_dtor("S202C3", this);}
void  S202C3 ::v110(){vfunc_called(this, "_ZN6S202C34v110Ev");}
void  S202C3 ::v111(){vfunc_called(this, "_ZN6S202C34v111Ev");}
void  S202C3 ::v112(){vfunc_called(this, "_ZN6S202C34v112Ev");}
void  S202C3 ::v113(){vfunc_called(this, "_ZN6S202C34v113Ev");}
S202C3 ::S202C3(){ note_ctor("S202C3", this);} // tgen

static void Test_S202C3()
{
  extern Class_Descriptor cd_S202C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S202C3, buf);
    S202C3 *dp, &lv = *(dp=new (buf) S202C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S202C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C3)");
    check_base_class_offset(lv, (S202C6*)(S202C5*)(S202C4*), 0, "S202C3");
    check_base_class_offset(lv, (S202C5*)(S202C4*), 0, "S202C3");
    check_base_class_offset(lv, (S202C4*), 0, "S202C3");
    check_field_offset(lv, s202c3f0, ABISELECT(268,196), "S202C3.s202c3f0");
    set_bf_and_test(lv, s202c3f1, ABISELECT(276,204), 0, 1, 1, "S202C3");
    check_field_offset(lv, s202c3f2, ABISELECT(280,208), "S202C3.s202c3f2");
    test_class_info(&lv, &cd_S202C3);
    dp->~S202C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C3(Test_S202C3, "S202C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S202C3C1Ev();
extern void _ZN6S202C3D1Ev();
Name_Map name_map_S202C3[] = {
  NSPAIR(_ZN6S202C3C1Ev),
  NSPAIR(_ZN6S202C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S202C6;
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
extern Class_Descriptor cd_S202C5;
extern VTBL_ENTRY _ZTI6S202C5[];
extern  VTBL_ENTRY _ZTV6S202C5[];
extern Class_Descriptor cd_S202C4;
extern VTBL_ENTRY _ZTI6S202C4[];
extern  VTBL_ENTRY _ZTV6S202C4[];
static Base_Class bases_S202C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S202C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S202C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S202C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S202C3[];
extern void _ZN6S202C3D1Ev();
extern void _ZN6S202C3D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
extern void _ZN6S202C53v68Ev();
extern void _ZN6S202C53v69Ev();
extern void _ZN6S202C53v70Ev();
extern void _ZN6S202C53v71Ev();
extern void _ZN6S202C53v72Ev();
extern void _ZN6S202C53v73Ev();
extern void _ZN6S202C53v74Ev();
extern void _ZN6S202C53v75Ev();
extern void _ZN6S202C53v76Ev();
extern void _ZN6S202C53v77Ev();
extern void _ZN6S202C53v78Ev();
extern void _ZN6S202C53v79Ev();
extern void _ZN6S202C53v80Ev();
extern void _ZN6S202C53v81Ev();
extern void _ZN6S202C53v82Ev();
extern void _ZN6S202C53v83Ev();
extern void _ZN6S202C53v84Ev();
extern void _ZN6S202C53v85Ev();
extern void _ZN6S202C53v86Ev();
extern void _ZN6S202C53v87Ev();
extern void _ZN6S202C53v88Ev();
extern void _ZN6S202C53v89Ev();
extern void _ZN6S202C43v90Ev();
extern void _ZN6S202C43v91Ev();
extern void _ZN6S202C43v92Ev();
extern void _ZN6S202C43v93Ev();
extern void _ZN6S202C43v94Ev();
extern void _ZN6S202C43v95Ev();
extern void _ZN6S202C43v96Ev();
extern void _ZN6S202C43v97Ev();
extern void _ZN6S202C43v98Ev();
extern void _ZN6S202C43v99Ev();
extern void _ZN6S202C44v100Ev();
extern void _ZN6S202C44v101Ev();
extern void _ZN6S202C44v102Ev();
extern void _ZN6S202C44v103Ev();
extern void _ZN6S202C44v104Ev();
extern void _ZN6S202C44v105Ev();
extern void _ZN6S202C44v106Ev();
extern void _ZN6S202C44v107Ev();
extern void _ZN6S202C44v108Ev();
extern void _ZN6S202C44v109Ev();
extern void _ZN6S202C34v110Ev();
extern void _ZN6S202C34v111Ev();
extern void _ZN6S202C34v112Ev();
extern void _ZN6S202C34v113Ev();
static  VTBL_ENTRY vtc_S202C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C3[0]),
  (VTBL_ENTRY)&_ZN6S202C3D1Ev,
  (VTBL_ENTRY)&_ZN6S202C3D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
  (VTBL_ENTRY)&_ZN6S202C53v68Ev,
  (VTBL_ENTRY)&_ZN6S202C53v69Ev,
  (VTBL_ENTRY)&_ZN6S202C53v70Ev,
  (VTBL_ENTRY)&_ZN6S202C53v71Ev,
  (VTBL_ENTRY)&_ZN6S202C53v72Ev,
  (VTBL_ENTRY)&_ZN6S202C53v73Ev,
  (VTBL_ENTRY)&_ZN6S202C53v74Ev,
  (VTBL_ENTRY)&_ZN6S202C53v75Ev,
  (VTBL_ENTRY)&_ZN6S202C53v76Ev,
  (VTBL_ENTRY)&_ZN6S202C53v77Ev,
  (VTBL_ENTRY)&_ZN6S202C53v78Ev,
  (VTBL_ENTRY)&_ZN6S202C53v79Ev,
  (VTBL_ENTRY)&_ZN6S202C53v80Ev,
  (VTBL_ENTRY)&_ZN6S202C53v81Ev,
  (VTBL_ENTRY)&_ZN6S202C53v82Ev,
  (VTBL_ENTRY)&_ZN6S202C53v83Ev,
  (VTBL_ENTRY)&_ZN6S202C53v84Ev,
  (VTBL_ENTRY)&_ZN6S202C53v85Ev,
  (VTBL_ENTRY)&_ZN6S202C53v86Ev,
  (VTBL_ENTRY)&_ZN6S202C53v87Ev,
  (VTBL_ENTRY)&_ZN6S202C53v88Ev,
  (VTBL_ENTRY)&_ZN6S202C53v89Ev,
  (VTBL_ENTRY)&_ZN6S202C43v90Ev,
  (VTBL_ENTRY)&_ZN6S202C43v91Ev,
  (VTBL_ENTRY)&_ZN6S202C43v92Ev,
  (VTBL_ENTRY)&_ZN6S202C43v93Ev,
  (VTBL_ENTRY)&_ZN6S202C43v94Ev,
  (VTBL_ENTRY)&_ZN6S202C43v95Ev,
  (VTBL_ENTRY)&_ZN6S202C43v96Ev,
  (VTBL_ENTRY)&_ZN6S202C43v97Ev,
  (VTBL_ENTRY)&_ZN6S202C43v98Ev,
  (VTBL_ENTRY)&_ZN6S202C43v99Ev,
  (VTBL_ENTRY)&_ZN6S202C44v100Ev,
  (VTBL_ENTRY)&_ZN6S202C44v101Ev,
  (VTBL_ENTRY)&_ZN6S202C44v102Ev,
  (VTBL_ENTRY)&_ZN6S202C44v103Ev,
  (VTBL_ENTRY)&_ZN6S202C44v104Ev,
  (VTBL_ENTRY)&_ZN6S202C44v105Ev,
  (VTBL_ENTRY)&_ZN6S202C44v106Ev,
  (VTBL_ENTRY)&_ZN6S202C44v107Ev,
  (VTBL_ENTRY)&_ZN6S202C44v108Ev,
  (VTBL_ENTRY)&_ZN6S202C44v109Ev,
  (VTBL_ENTRY)&_ZN6S202C34v110Ev,
  (VTBL_ENTRY)&_ZN6S202C34v111Ev,
  (VTBL_ENTRY)&_ZN6S202C34v112Ev,
  (VTBL_ENTRY)&_ZN6S202C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S202C3[];
extern  VTBL_ENTRY _ZTV6S202C3[];
Class_Descriptor cd_S202C3 = {  "S202C3", // class name
  bases_S202C3, 3,
  &(vtc_S202C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S202C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S202C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C2  : S202C3 {
  int s202c2f0;
  unsigned int s202c2f1:1;
  virtual  ~S202C2(); // _ZN6S202C2D1Ev
  virtual void  v114(); // _ZN6S202C24v114Ev
  virtual void  v115(); // _ZN6S202C24v115Ev
  virtual void  v116(); // _ZN6S202C24v116Ev
  virtual void  v117(); // _ZN6S202C24v117Ev
  virtual void  v118(); // _ZN6S202C24v118Ev
  virtual void  v119(); // _ZN6S202C24v119Ev
  virtual void  v120(); // _ZN6S202C24v120Ev
  virtual void  v121(); // _ZN6S202C24v121Ev
  S202C2(); // tgen
};
//SIG(-1 S202C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC8 FC16{ BC17{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S202C2 ::~S202C2(){ note_dtor("S202C2", this);}
void  S202C2 ::v114(){vfunc_called(this, "_ZN6S202C24v114Ev");}
void  S202C2 ::v115(){vfunc_called(this, "_ZN6S202C24v115Ev");}
void  S202C2 ::v116(){vfunc_called(this, "_ZN6S202C24v116Ev");}
void  S202C2 ::v117(){vfunc_called(this, "_ZN6S202C24v117Ev");}
void  S202C2 ::v118(){vfunc_called(this, "_ZN6S202C24v118Ev");}
void  S202C2 ::v119(){vfunc_called(this, "_ZN6S202C24v119Ev");}
void  S202C2 ::v120(){vfunc_called(this, "_ZN6S202C24v120Ev");}
void  S202C2 ::v121(){vfunc_called(this, "_ZN6S202C24v121Ev");}
S202C2 ::S202C2(){ note_ctor("S202C2", this);} // tgen

static void Test_S202C2()
{
  extern Class_Descriptor cd_S202C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S202C2, buf);
    S202C2 *dp, &lv = *(dp=new (buf) S202C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S202C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C2)");
    check_base_class_offset(lv, (S202C6*)(S202C5*)(S202C4*)(S202C3*), 0, "S202C2");
    check_base_class_offset(lv, (S202C5*)(S202C4*)(S202C3*), 0, "S202C2");
    check_base_class_offset(lv, (S202C4*)(S202C3*), 0, "S202C2");
    check_base_class_offset(lv, (S202C3*), 0, "S202C2");
    check_field_offset(lv, s202c2f0, ABISELECT(296,220), "S202C2.s202c2f0");
    set_bf_and_test(lv, s202c2f1, ABISELECT(300,224), 0, 1, 1, "S202C2");
    test_class_info(&lv, &cd_S202C2);
    dp->~S202C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C2(Test_S202C2, "S202C2", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN6S202C2C1Ev();
extern void _ZN6S202C2D1Ev();
Name_Map name_map_S202C2[] = {
  NSPAIR(_ZN6S202C2C1Ev),
  NSPAIR(_ZN6S202C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S202C6;
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
extern Class_Descriptor cd_S202C5;
extern VTBL_ENTRY _ZTI6S202C5[];
extern  VTBL_ENTRY _ZTV6S202C5[];
extern Class_Descriptor cd_S202C4;
extern VTBL_ENTRY _ZTI6S202C4[];
extern  VTBL_ENTRY _ZTV6S202C4[];
extern Class_Descriptor cd_S202C3;
extern VTBL_ENTRY _ZTI6S202C3[];
extern  VTBL_ENTRY _ZTV6S202C3[];
static Base_Class bases_S202C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S202C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S202C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S202C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S202C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S202C2[];
extern void _ZN6S202C2D1Ev();
extern void _ZN6S202C2D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
extern void _ZN6S202C53v68Ev();
extern void _ZN6S202C53v69Ev();
extern void _ZN6S202C53v70Ev();
extern void _ZN6S202C53v71Ev();
extern void _ZN6S202C53v72Ev();
extern void _ZN6S202C53v73Ev();
extern void _ZN6S202C53v74Ev();
extern void _ZN6S202C53v75Ev();
extern void _ZN6S202C53v76Ev();
extern void _ZN6S202C53v77Ev();
extern void _ZN6S202C53v78Ev();
extern void _ZN6S202C53v79Ev();
extern void _ZN6S202C53v80Ev();
extern void _ZN6S202C53v81Ev();
extern void _ZN6S202C53v82Ev();
extern void _ZN6S202C53v83Ev();
extern void _ZN6S202C53v84Ev();
extern void _ZN6S202C53v85Ev();
extern void _ZN6S202C53v86Ev();
extern void _ZN6S202C53v87Ev();
extern void _ZN6S202C53v88Ev();
extern void _ZN6S202C53v89Ev();
extern void _ZN6S202C43v90Ev();
extern void _ZN6S202C43v91Ev();
extern void _ZN6S202C43v92Ev();
extern void _ZN6S202C43v93Ev();
extern void _ZN6S202C43v94Ev();
extern void _ZN6S202C43v95Ev();
extern void _ZN6S202C43v96Ev();
extern void _ZN6S202C43v97Ev();
extern void _ZN6S202C43v98Ev();
extern void _ZN6S202C43v99Ev();
extern void _ZN6S202C44v100Ev();
extern void _ZN6S202C44v101Ev();
extern void _ZN6S202C44v102Ev();
extern void _ZN6S202C44v103Ev();
extern void _ZN6S202C44v104Ev();
extern void _ZN6S202C44v105Ev();
extern void _ZN6S202C44v106Ev();
extern void _ZN6S202C44v107Ev();
extern void _ZN6S202C44v108Ev();
extern void _ZN6S202C44v109Ev();
extern void _ZN6S202C34v110Ev();
extern void _ZN6S202C34v111Ev();
extern void _ZN6S202C34v112Ev();
extern void _ZN6S202C34v113Ev();
extern void _ZN6S202C24v114Ev();
extern void _ZN6S202C24v115Ev();
extern void _ZN6S202C24v116Ev();
extern void _ZN6S202C24v117Ev();
extern void _ZN6S202C24v118Ev();
extern void _ZN6S202C24v119Ev();
extern void _ZN6S202C24v120Ev();
extern void _ZN6S202C24v121Ev();
static  VTBL_ENTRY vtc_S202C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C2[0]),
  (VTBL_ENTRY)&_ZN6S202C2D1Ev,
  (VTBL_ENTRY)&_ZN6S202C2D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
  (VTBL_ENTRY)&_ZN6S202C53v68Ev,
  (VTBL_ENTRY)&_ZN6S202C53v69Ev,
  (VTBL_ENTRY)&_ZN6S202C53v70Ev,
  (VTBL_ENTRY)&_ZN6S202C53v71Ev,
  (VTBL_ENTRY)&_ZN6S202C53v72Ev,
  (VTBL_ENTRY)&_ZN6S202C53v73Ev,
  (VTBL_ENTRY)&_ZN6S202C53v74Ev,
  (VTBL_ENTRY)&_ZN6S202C53v75Ev,
  (VTBL_ENTRY)&_ZN6S202C53v76Ev,
  (VTBL_ENTRY)&_ZN6S202C53v77Ev,
  (VTBL_ENTRY)&_ZN6S202C53v78Ev,
  (VTBL_ENTRY)&_ZN6S202C53v79Ev,
  (VTBL_ENTRY)&_ZN6S202C53v80Ev,
  (VTBL_ENTRY)&_ZN6S202C53v81Ev,
  (VTBL_ENTRY)&_ZN6S202C53v82Ev,
  (VTBL_ENTRY)&_ZN6S202C53v83Ev,
  (VTBL_ENTRY)&_ZN6S202C53v84Ev,
  (VTBL_ENTRY)&_ZN6S202C53v85Ev,
  (VTBL_ENTRY)&_ZN6S202C53v86Ev,
  (VTBL_ENTRY)&_ZN6S202C53v87Ev,
  (VTBL_ENTRY)&_ZN6S202C53v88Ev,
  (VTBL_ENTRY)&_ZN6S202C53v89Ev,
  (VTBL_ENTRY)&_ZN6S202C43v90Ev,
  (VTBL_ENTRY)&_ZN6S202C43v91Ev,
  (VTBL_ENTRY)&_ZN6S202C43v92Ev,
  (VTBL_ENTRY)&_ZN6S202C43v93Ev,
  (VTBL_ENTRY)&_ZN6S202C43v94Ev,
  (VTBL_ENTRY)&_ZN6S202C43v95Ev,
  (VTBL_ENTRY)&_ZN6S202C43v96Ev,
  (VTBL_ENTRY)&_ZN6S202C43v97Ev,
  (VTBL_ENTRY)&_ZN6S202C43v98Ev,
  (VTBL_ENTRY)&_ZN6S202C43v99Ev,
  (VTBL_ENTRY)&_ZN6S202C44v100Ev,
  (VTBL_ENTRY)&_ZN6S202C44v101Ev,
  (VTBL_ENTRY)&_ZN6S202C44v102Ev,
  (VTBL_ENTRY)&_ZN6S202C44v103Ev,
  (VTBL_ENTRY)&_ZN6S202C44v104Ev,
  (VTBL_ENTRY)&_ZN6S202C44v105Ev,
  (VTBL_ENTRY)&_ZN6S202C44v106Ev,
  (VTBL_ENTRY)&_ZN6S202C44v107Ev,
  (VTBL_ENTRY)&_ZN6S202C44v108Ev,
  (VTBL_ENTRY)&_ZN6S202C44v109Ev,
  (VTBL_ENTRY)&_ZN6S202C34v110Ev,
  (VTBL_ENTRY)&_ZN6S202C34v111Ev,
  (VTBL_ENTRY)&_ZN6S202C34v112Ev,
  (VTBL_ENTRY)&_ZN6S202C34v113Ev,
  (VTBL_ENTRY)&_ZN6S202C24v114Ev,
  (VTBL_ENTRY)&_ZN6S202C24v115Ev,
  (VTBL_ENTRY)&_ZN6S202C24v116Ev,
  (VTBL_ENTRY)&_ZN6S202C24v117Ev,
  (VTBL_ENTRY)&_ZN6S202C24v118Ev,
  (VTBL_ENTRY)&_ZN6S202C24v119Ev,
  (VTBL_ENTRY)&_ZN6S202C24v120Ev,
  (VTBL_ENTRY)&_ZN6S202C24v121Ev,
};
extern VTBL_ENTRY _ZTI6S202C2[];
extern  VTBL_ENTRY _ZTV6S202C2[];
Class_Descriptor cd_S202C2 = {  "S202C2", // class name
  bases_S202C2, 4,
  &(vtc_S202C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI6S202C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S202C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S202C1  : S202C2 {
  int s202c1f0;
  char s202c1f1;
  virtual  ~S202C1(); // _ZN6S202C1D1Ev
  virtual void  v1(); // _ZN6S202C12v1Ev
  virtual void  v2(); // _ZN6S202C12v2Ev
  virtual void  v3(); // _ZN6S202C12v3Ev
  S202C1(); // tgen
};
//SIG(1 S202C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC9 FC17{ BC18{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC19{ BC20{ BC11}}} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 Fi Fc}


 S202C1 ::~S202C1(){ note_dtor("S202C1", this);}
void  S202C1 ::v1(){vfunc_called(this, "_ZN6S202C12v1Ev");}
void  S202C1 ::v2(){vfunc_called(this, "_ZN6S202C12v2Ev");}
void  S202C1 ::v3(){vfunc_called(this, "_ZN6S202C12v3Ev");}
S202C1 ::S202C1(){ note_ctor("S202C1", this);} // tgen

static void Test_S202C1()
{
  extern Class_Descriptor cd_S202C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,60)];
    init_test(&cd_S202C1, buf);
    S202C1 *dp, &lv = *(dp=new (buf) S202C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,236), "sizeof(S202C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S202C1)");
    check_base_class_offset(lv, (S202C6*)(S202C5*)(S202C4*)(S202C3*)(S202C2*), 0, "S202C1");
    check_base_class_offset(lv, (S202C5*)(S202C4*)(S202C3*)(S202C2*), 0, "S202C1");
    check_base_class_offset(lv, (S202C4*)(S202C3*)(S202C2*), 0, "S202C1");
    check_base_class_offset(lv, (S202C3*)(S202C2*), 0, "S202C1");
    check_base_class_offset(lv, (S202C2*), 0, "S202C1");
    check_field_offset(lv, s202c1f0, ABISELECT(304,228), "S202C1.s202c1f0");
    check_field_offset(lv, s202c1f1, ABISELECT(308,232), "S202C1.s202c1f1");
    test_class_info(&lv, &cd_S202C1);
    dp->~S202C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS202C1(Test_S202C1, "S202C1", ABISELECT(312,236));

#else // __cplusplus

extern void _ZN6S202C1C1Ev();
extern void _ZN6S202C1D1Ev();
Name_Map name_map_S202C1[] = {
  NSPAIR(_ZN6S202C1C1Ev),
  NSPAIR(_ZN6S202C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S202C6;
extern VTBL_ENTRY _ZTI6S202C6[];
extern  VTBL_ENTRY _ZTV6S202C6[];
extern Class_Descriptor cd_S202C5;
extern VTBL_ENTRY _ZTI6S202C5[];
extern  VTBL_ENTRY _ZTV6S202C5[];
extern Class_Descriptor cd_S202C4;
extern VTBL_ENTRY _ZTI6S202C4[];
extern  VTBL_ENTRY _ZTV6S202C4[];
extern Class_Descriptor cd_S202C3;
extern VTBL_ENTRY _ZTI6S202C3[];
extern  VTBL_ENTRY _ZTV6S202C3[];
extern Class_Descriptor cd_S202C2;
extern VTBL_ENTRY _ZTI6S202C2[];
extern  VTBL_ENTRY _ZTV6S202C2[];
static Base_Class bases_S202C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S202C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S202C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S202C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S202C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S202C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S202C1[];
extern void _ZN6S202C1D1Ev();
extern void _ZN6S202C1D0Ev();
extern void _ZN6S202C62v4Ev();
extern void _ZN6S202C62v5Ev();
extern void _ZN6S202C62v6Ev();
extern void _ZN6S202C62v7Ev();
extern void _ZN6S202C62v8Ev();
extern void _ZN6S202C62v9Ev();
extern void _ZN6S202C63v10Ev();
extern void _ZN6S202C63v11Ev();
extern void _ZN6S202C63v12Ev();
extern void _ZN6S202C63v13Ev();
extern void _ZN6S202C63v14Ev();
extern void _ZN6S202C63v15Ev();
extern void _ZN6S202C63v16Ev();
extern void _ZN6S202C63v17Ev();
extern void _ZN6S202C63v18Ev();
extern void _ZN6S202C63v19Ev();
extern void _ZN6S202C63v20Ev();
extern void _ZN6S202C63v21Ev();
extern void _ZN6S202C63v22Ev();
extern void _ZN6S202C63v23Ev();
extern void _ZN6S202C63v24Ev();
extern void _ZN6S202C63v25Ev();
extern void _ZN6S202C63v26Ev();
extern void _ZN6S202C63v27Ev();
extern void _ZN6S202C63v28Ev();
extern void _ZN6S202C63v29Ev();
extern void _ZN6S202C63v30Ev();
extern void _ZN6S202C63v31Ev();
extern void _ZN6S202C63v32Ev();
extern void _ZN6S202C63v33Ev();
extern void _ZN6S202C63v34Ev();
extern void _ZN6S202C63v35Ev();
extern void _ZN6S202C63v36Ev();
extern void _ZN6S202C63v37Ev();
extern void _ZN6S202C63v38Ev();
extern void _ZN6S202C63v39Ev();
extern void _ZN6S202C63v40Ev();
extern void _ZN6S202C63v41Ev();
extern void _ZN6S202C63v42Ev();
extern void _ZN6S202C63v43Ev();
extern void _ZN6S202C63v44Ev();
extern void _ZN6S202C63v45Ev();
extern void _ZN6S202C63v46Ev();
extern void _ZN6S202C63v47Ev();
extern void _ZN6S202C63v48Ev();
extern void _ZN6S202C63v49Ev();
extern void _ZN6S202C63v50Ev();
extern void _ZN6S202C63v51Ev();
extern void _ZN6S202C63v52Ev();
extern void _ZN6S202C63v53Ev();
extern void _ZN6S202C63v54Ev();
extern void _ZN6S202C63v55Ev();
extern void _ZN6S202C63v56Ev();
extern void _ZN6S202C63v57Ev();
extern void _ZN6S202C63v58Ev();
extern void _ZN6S202C63v59Ev();
extern void _ZN6S202C63v60Ev();
extern void _ZN6S202C63v61Ev();
extern void _ZN6S202C63v62Ev();
extern void _ZN6S202C63v63Ev();
extern void _ZN6S202C63v64Ev();
extern void _ZN6S202C63v65Ev();
extern void _ZN6S202C63v66Ev();
extern void _ZN6S202C63v67Ev();
extern void _ZN6S202C53v68Ev();
extern void _ZN6S202C53v69Ev();
extern void _ZN6S202C53v70Ev();
extern void _ZN6S202C53v71Ev();
extern void _ZN6S202C53v72Ev();
extern void _ZN6S202C53v73Ev();
extern void _ZN6S202C53v74Ev();
extern void _ZN6S202C53v75Ev();
extern void _ZN6S202C53v76Ev();
extern void _ZN6S202C53v77Ev();
extern void _ZN6S202C53v78Ev();
extern void _ZN6S202C53v79Ev();
extern void _ZN6S202C53v80Ev();
extern void _ZN6S202C53v81Ev();
extern void _ZN6S202C53v82Ev();
extern void _ZN6S202C53v83Ev();
extern void _ZN6S202C53v84Ev();
extern void _ZN6S202C53v85Ev();
extern void _ZN6S202C53v86Ev();
extern void _ZN6S202C53v87Ev();
extern void _ZN6S202C53v88Ev();
extern void _ZN6S202C53v89Ev();
extern void _ZN6S202C43v90Ev();
extern void _ZN6S202C43v91Ev();
extern void _ZN6S202C43v92Ev();
extern void _ZN6S202C43v93Ev();
extern void _ZN6S202C43v94Ev();
extern void _ZN6S202C43v95Ev();
extern void _ZN6S202C43v96Ev();
extern void _ZN6S202C43v97Ev();
extern void _ZN6S202C43v98Ev();
extern void _ZN6S202C43v99Ev();
extern void _ZN6S202C44v100Ev();
extern void _ZN6S202C44v101Ev();
extern void _ZN6S202C44v102Ev();
extern void _ZN6S202C44v103Ev();
extern void _ZN6S202C44v104Ev();
extern void _ZN6S202C44v105Ev();
extern void _ZN6S202C44v106Ev();
extern void _ZN6S202C44v107Ev();
extern void _ZN6S202C44v108Ev();
extern void _ZN6S202C44v109Ev();
extern void _ZN6S202C34v110Ev();
extern void _ZN6S202C34v111Ev();
extern void _ZN6S202C34v112Ev();
extern void _ZN6S202C34v113Ev();
extern void _ZN6S202C24v114Ev();
extern void _ZN6S202C24v115Ev();
extern void _ZN6S202C24v116Ev();
extern void _ZN6S202C24v117Ev();
extern void _ZN6S202C24v118Ev();
extern void _ZN6S202C24v119Ev();
extern void _ZN6S202C24v120Ev();
extern void _ZN6S202C24v121Ev();
extern void _ZN6S202C12v1Ev();
extern void _ZN6S202C12v2Ev();
extern void _ZN6S202C12v3Ev();
static  VTBL_ENTRY vtc_S202C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S202C1[0]),
  (VTBL_ENTRY)&_ZN6S202C1D1Ev,
  (VTBL_ENTRY)&_ZN6S202C1D0Ev,
  (VTBL_ENTRY)&_ZN6S202C62v4Ev,
  (VTBL_ENTRY)&_ZN6S202C62v5Ev,
  (VTBL_ENTRY)&_ZN6S202C62v6Ev,
  (VTBL_ENTRY)&_ZN6S202C62v7Ev,
  (VTBL_ENTRY)&_ZN6S202C62v8Ev,
  (VTBL_ENTRY)&_ZN6S202C62v9Ev,
  (VTBL_ENTRY)&_ZN6S202C63v10Ev,
  (VTBL_ENTRY)&_ZN6S202C63v11Ev,
  (VTBL_ENTRY)&_ZN6S202C63v12Ev,
  (VTBL_ENTRY)&_ZN6S202C63v13Ev,
  (VTBL_ENTRY)&_ZN6S202C63v14Ev,
  (VTBL_ENTRY)&_ZN6S202C63v15Ev,
  (VTBL_ENTRY)&_ZN6S202C63v16Ev,
  (VTBL_ENTRY)&_ZN6S202C63v17Ev,
  (VTBL_ENTRY)&_ZN6S202C63v18Ev,
  (VTBL_ENTRY)&_ZN6S202C63v19Ev,
  (VTBL_ENTRY)&_ZN6S202C63v20Ev,
  (VTBL_ENTRY)&_ZN6S202C63v21Ev,
  (VTBL_ENTRY)&_ZN6S202C63v22Ev,
  (VTBL_ENTRY)&_ZN6S202C63v23Ev,
  (VTBL_ENTRY)&_ZN6S202C63v24Ev,
  (VTBL_ENTRY)&_ZN6S202C63v25Ev,
  (VTBL_ENTRY)&_ZN6S202C63v26Ev,
  (VTBL_ENTRY)&_ZN6S202C63v27Ev,
  (VTBL_ENTRY)&_ZN6S202C63v28Ev,
  (VTBL_ENTRY)&_ZN6S202C63v29Ev,
  (VTBL_ENTRY)&_ZN6S202C63v30Ev,
  (VTBL_ENTRY)&_ZN6S202C63v31Ev,
  (VTBL_ENTRY)&_ZN6S202C63v32Ev,
  (VTBL_ENTRY)&_ZN6S202C63v33Ev,
  (VTBL_ENTRY)&_ZN6S202C63v34Ev,
  (VTBL_ENTRY)&_ZN6S202C63v35Ev,
  (VTBL_ENTRY)&_ZN6S202C63v36Ev,
  (VTBL_ENTRY)&_ZN6S202C63v37Ev,
  (VTBL_ENTRY)&_ZN6S202C63v38Ev,
  (VTBL_ENTRY)&_ZN6S202C63v39Ev,
  (VTBL_ENTRY)&_ZN6S202C63v40Ev,
  (VTBL_ENTRY)&_ZN6S202C63v41Ev,
  (VTBL_ENTRY)&_ZN6S202C63v42Ev,
  (VTBL_ENTRY)&_ZN6S202C63v43Ev,
  (VTBL_ENTRY)&_ZN6S202C63v44Ev,
  (VTBL_ENTRY)&_ZN6S202C63v45Ev,
  (VTBL_ENTRY)&_ZN6S202C63v46Ev,
  (VTBL_ENTRY)&_ZN6S202C63v47Ev,
  (VTBL_ENTRY)&_ZN6S202C63v48Ev,
  (VTBL_ENTRY)&_ZN6S202C63v49Ev,
  (VTBL_ENTRY)&_ZN6S202C63v50Ev,
  (VTBL_ENTRY)&_ZN6S202C63v51Ev,
  (VTBL_ENTRY)&_ZN6S202C63v52Ev,
  (VTBL_ENTRY)&_ZN6S202C63v53Ev,
  (VTBL_ENTRY)&_ZN6S202C63v54Ev,
  (VTBL_ENTRY)&_ZN6S202C63v55Ev,
  (VTBL_ENTRY)&_ZN6S202C63v56Ev,
  (VTBL_ENTRY)&_ZN6S202C63v57Ev,
  (VTBL_ENTRY)&_ZN6S202C63v58Ev,
  (VTBL_ENTRY)&_ZN6S202C63v59Ev,
  (VTBL_ENTRY)&_ZN6S202C63v60Ev,
  (VTBL_ENTRY)&_ZN6S202C63v61Ev,
  (VTBL_ENTRY)&_ZN6S202C63v62Ev,
  (VTBL_ENTRY)&_ZN6S202C63v63Ev,
  (VTBL_ENTRY)&_ZN6S202C63v64Ev,
  (VTBL_ENTRY)&_ZN6S202C63v65Ev,
  (VTBL_ENTRY)&_ZN6S202C63v66Ev,
  (VTBL_ENTRY)&_ZN6S202C63v67Ev,
  (VTBL_ENTRY)&_ZN6S202C53v68Ev,
  (VTBL_ENTRY)&_ZN6S202C53v69Ev,
  (VTBL_ENTRY)&_ZN6S202C53v70Ev,
  (VTBL_ENTRY)&_ZN6S202C53v71Ev,
  (VTBL_ENTRY)&_ZN6S202C53v72Ev,
  (VTBL_ENTRY)&_ZN6S202C53v73Ev,
  (VTBL_ENTRY)&_ZN6S202C53v74Ev,
  (VTBL_ENTRY)&_ZN6S202C53v75Ev,
  (VTBL_ENTRY)&_ZN6S202C53v76Ev,
  (VTBL_ENTRY)&_ZN6S202C53v77Ev,
  (VTBL_ENTRY)&_ZN6S202C53v78Ev,
  (VTBL_ENTRY)&_ZN6S202C53v79Ev,
  (VTBL_ENTRY)&_ZN6S202C53v80Ev,
  (VTBL_ENTRY)&_ZN6S202C53v81Ev,
  (VTBL_ENTRY)&_ZN6S202C53v82Ev,
  (VTBL_ENTRY)&_ZN6S202C53v83Ev,
  (VTBL_ENTRY)&_ZN6S202C53v84Ev,
  (VTBL_ENTRY)&_ZN6S202C53v85Ev,
  (VTBL_ENTRY)&_ZN6S202C53v86Ev,
  (VTBL_ENTRY)&_ZN6S202C53v87Ev,
  (VTBL_ENTRY)&_ZN6S202C53v88Ev,
  (VTBL_ENTRY)&_ZN6S202C53v89Ev,
  (VTBL_ENTRY)&_ZN6S202C43v90Ev,
  (VTBL_ENTRY)&_ZN6S202C43v91Ev,
  (VTBL_ENTRY)&_ZN6S202C43v92Ev,
  (VTBL_ENTRY)&_ZN6S202C43v93Ev,
  (VTBL_ENTRY)&_ZN6S202C43v94Ev,
  (VTBL_ENTRY)&_ZN6S202C43v95Ev,
  (VTBL_ENTRY)&_ZN6S202C43v96Ev,
  (VTBL_ENTRY)&_ZN6S202C43v97Ev,
  (VTBL_ENTRY)&_ZN6S202C43v98Ev,
  (VTBL_ENTRY)&_ZN6S202C43v99Ev,
  (VTBL_ENTRY)&_ZN6S202C44v100Ev,
  (VTBL_ENTRY)&_ZN6S202C44v101Ev,
  (VTBL_ENTRY)&_ZN6S202C44v102Ev,
  (VTBL_ENTRY)&_ZN6S202C44v103Ev,
  (VTBL_ENTRY)&_ZN6S202C44v104Ev,
  (VTBL_ENTRY)&_ZN6S202C44v105Ev,
  (VTBL_ENTRY)&_ZN6S202C44v106Ev,
  (VTBL_ENTRY)&_ZN6S202C44v107Ev,
  (VTBL_ENTRY)&_ZN6S202C44v108Ev,
  (VTBL_ENTRY)&_ZN6S202C44v109Ev,
  (VTBL_ENTRY)&_ZN6S202C34v110Ev,
  (VTBL_ENTRY)&_ZN6S202C34v111Ev,
  (VTBL_ENTRY)&_ZN6S202C34v112Ev,
  (VTBL_ENTRY)&_ZN6S202C34v113Ev,
  (VTBL_ENTRY)&_ZN6S202C24v114Ev,
  (VTBL_ENTRY)&_ZN6S202C24v115Ev,
  (VTBL_ENTRY)&_ZN6S202C24v116Ev,
  (VTBL_ENTRY)&_ZN6S202C24v117Ev,
  (VTBL_ENTRY)&_ZN6S202C24v118Ev,
  (VTBL_ENTRY)&_ZN6S202C24v119Ev,
  (VTBL_ENTRY)&_ZN6S202C24v120Ev,
  (VTBL_ENTRY)&_ZN6S202C24v121Ev,
  (VTBL_ENTRY)&_ZN6S202C12v1Ev,
  (VTBL_ENTRY)&_ZN6S202C12v2Ev,
  (VTBL_ENTRY)&_ZN6S202C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S202C1[];
extern  VTBL_ENTRY _ZTV6S202C1[];
Class_Descriptor cd_S202C1 = {  "S202C1", // class name
  bases_S202C1, 5,
  &(vtc_S202C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,236), // object size
  NSPAIRA(_ZTI6S202C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S202C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S634C5  {
  int s634c5f0;
  __tsi64 s634c5f1;
  void *s634c5f2[4];
  int s634c5f3[2];
  void *s634c5f4;
  ::S78C8_nt s634c5f5;
  void *s634c5f6[2];
  virtual  ~S634C5(); // _ZN6S634C5D1Ev
  virtual void  v5(); // _ZN6S634C52v5Ev
  virtual void  v6(); // _ZN6S634C52v6Ev
  virtual void  v7(); // _ZN6S634C52v7Ev
  virtual void  v8(); // _ZN6S634C52v8Ev
  virtual void  v9(); // _ZN6S634C52v9Ev
  virtual void  v10(); // _ZN6S634C53v10Ev
  virtual void  v11(); // _ZN6S634C53v11Ev
  virtual void  v12(); // _ZN6S634C53v12Ev
  virtual void  v13(); // _ZN6S634C53v13Ev
  virtual void  v14(); // _ZN6S634C53v14Ev
  virtual void  v15(); // _ZN6S634C53v15Ev
  virtual void  v16(); // _ZN6S634C53v16Ev
  virtual void  v17(); // _ZN6S634C53v17Ev
  virtual void  v18(); // _ZN6S634C53v18Ev
  virtual void  v19(); // _ZN6S634C53v19Ev
  virtual void  v20(); // _ZN6S634C53v20Ev
  virtual void  v21(); // _ZN6S634C53v21Ev
  virtual void  v22(); // _ZN6S634C53v22Ev
  virtual void  v23(); // _ZN6S634C53v23Ev
  virtual void  v24(); // _ZN6S634C53v24Ev
  virtual void  v25(); // _ZN6S634C53v25Ev
  virtual void  v26(); // _ZN6S634C53v26Ev
  virtual void  v27(); // _ZN6S634C53v27Ev
  virtual void  v28(); // _ZN6S634C53v28Ev
  virtual void  v29(); // _ZN6S634C53v29Ev
  virtual void  v30(); // _ZN6S634C53v30Ev
  virtual void  v31(); // _ZN6S634C53v31Ev
  virtual void  v32(); // _ZN6S634C53v32Ev
  virtual void  v33(); // _ZN6S634C53v33Ev
  virtual void  v34(); // _ZN6S634C53v34Ev
  virtual void  v35(); // _ZN6S634C53v35Ev
  virtual void  v36(); // _ZN6S634C53v36Ev
  virtual void  v37(); // _ZN6S634C53v37Ev
  virtual void  v38(); // _ZN6S634C53v38Ev
  virtual void  v39(); // _ZN6S634C53v39Ev
  virtual void  v40(); // _ZN6S634C53v40Ev
  virtual void  v41(); // _ZN6S634C53v41Ev
  virtual void  v42(); // _ZN6S634C53v42Ev
  virtual void  v43(); // _ZN6S634C53v43Ev
  virtual void  v44(); // _ZN6S634C53v44Ev
  virtual void  v45(); // _ZN6S634C53v45Ev
  virtual void  v46(); // _ZN6S634C53v46Ev
  virtual void  v47(); // _ZN6S634C53v47Ev
  virtual void  v48(); // _ZN6S634C53v48Ev
  virtual void  v49(); // _ZN6S634C53v49Ev
  virtual void  v50(); // _ZN6S634C53v50Ev
  virtual void  v51(); // _ZN6S634C53v51Ev
  virtual void  v52(); // _ZN6S634C53v52Ev
  virtual void  v53(); // _ZN6S634C53v53Ev
  virtual void  v54(); // _ZN6S634C53v54Ev
  virtual void  v55(); // _ZN6S634C53v55Ev
  virtual void  v56(); // _ZN6S634C53v56Ev
  virtual void  v57(); // _ZN6S634C53v57Ev
  virtual void  v58(); // _ZN6S634C53v58Ev
  virtual void  v59(); // _ZN6S634C53v59Ev
  virtual void  v60(); // _ZN6S634C53v60Ev
  virtual void  v61(); // _ZN6S634C53v61Ev
  virtual void  v62(); // _ZN6S634C53v62Ev
  virtual void  v63(); // _ZN6S634C53v63Ev
  virtual void  v64(); // _ZN6S634C53v64Ev
  virtual void  v65(); // _ZN6S634C53v65Ev
  virtual void  v66(); // _ZN6S634C53v66Ev
  virtual void  v67(); // _ZN6S634C53v67Ev
  virtual void  v68(); // _ZN6S634C53v68Ev
  S634C5(); // tgen
};
//SIG(-1 S634C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S634C5 ::~S634C5(){ note_dtor("S634C5", this);}
void  S634C5 ::v5(){vfunc_called(this, "_ZN6S634C52v5Ev");}
void  S634C5 ::v6(){vfunc_called(this, "_ZN6S634C52v6Ev");}
void  S634C5 ::v7(){vfunc_called(this, "_ZN6S634C52v7Ev");}
void  S634C5 ::v8(){vfunc_called(this, "_ZN6S634C52v8Ev");}
void  S634C5 ::v9(){vfunc_called(this, "_ZN6S634C52v9Ev");}
void  S634C5 ::v10(){vfunc_called(this, "_ZN6S634C53v10Ev");}
void  S634C5 ::v11(){vfunc_called(this, "_ZN6S634C53v11Ev");}
void  S634C5 ::v12(){vfunc_called(this, "_ZN6S634C53v12Ev");}
void  S634C5 ::v13(){vfunc_called(this, "_ZN6S634C53v13Ev");}
void  S634C5 ::v14(){vfunc_called(this, "_ZN6S634C53v14Ev");}
void  S634C5 ::v15(){vfunc_called(this, "_ZN6S634C53v15Ev");}
void  S634C5 ::v16(){vfunc_called(this, "_ZN6S634C53v16Ev");}
void  S634C5 ::v17(){vfunc_called(this, "_ZN6S634C53v17Ev");}
void  S634C5 ::v18(){vfunc_called(this, "_ZN6S634C53v18Ev");}
void  S634C5 ::v19(){vfunc_called(this, "_ZN6S634C53v19Ev");}
void  S634C5 ::v20(){vfunc_called(this, "_ZN6S634C53v20Ev");}
void  S634C5 ::v21(){vfunc_called(this, "_ZN6S634C53v21Ev");}
void  S634C5 ::v22(){vfunc_called(this, "_ZN6S634C53v22Ev");}
void  S634C5 ::v23(){vfunc_called(this, "_ZN6S634C53v23Ev");}
void  S634C5 ::v24(){vfunc_called(this, "_ZN6S634C53v24Ev");}
void  S634C5 ::v25(){vfunc_called(this, "_ZN6S634C53v25Ev");}
void  S634C5 ::v26(){vfunc_called(this, "_ZN6S634C53v26Ev");}
void  S634C5 ::v27(){vfunc_called(this, "_ZN6S634C53v27Ev");}
void  S634C5 ::v28(){vfunc_called(this, "_ZN6S634C53v28Ev");}
void  S634C5 ::v29(){vfunc_called(this, "_ZN6S634C53v29Ev");}
void  S634C5 ::v30(){vfunc_called(this, "_ZN6S634C53v30Ev");}
void  S634C5 ::v31(){vfunc_called(this, "_ZN6S634C53v31Ev");}
void  S634C5 ::v32(){vfunc_called(this, "_ZN6S634C53v32Ev");}
void  S634C5 ::v33(){vfunc_called(this, "_ZN6S634C53v33Ev");}
void  S634C5 ::v34(){vfunc_called(this, "_ZN6S634C53v34Ev");}
void  S634C5 ::v35(){vfunc_called(this, "_ZN6S634C53v35Ev");}
void  S634C5 ::v36(){vfunc_called(this, "_ZN6S634C53v36Ev");}
void  S634C5 ::v37(){vfunc_called(this, "_ZN6S634C53v37Ev");}
void  S634C5 ::v38(){vfunc_called(this, "_ZN6S634C53v38Ev");}
void  S634C5 ::v39(){vfunc_called(this, "_ZN6S634C53v39Ev");}
void  S634C5 ::v40(){vfunc_called(this, "_ZN6S634C53v40Ev");}
void  S634C5 ::v41(){vfunc_called(this, "_ZN6S634C53v41Ev");}
void  S634C5 ::v42(){vfunc_called(this, "_ZN6S634C53v42Ev");}
void  S634C5 ::v43(){vfunc_called(this, "_ZN6S634C53v43Ev");}
void  S634C5 ::v44(){vfunc_called(this, "_ZN6S634C53v44Ev");}
void  S634C5 ::v45(){vfunc_called(this, "_ZN6S634C53v45Ev");}
void  S634C5 ::v46(){vfunc_called(this, "_ZN6S634C53v46Ev");}
void  S634C5 ::v47(){vfunc_called(this, "_ZN6S634C53v47Ev");}
void  S634C5 ::v48(){vfunc_called(this, "_ZN6S634C53v48Ev");}
void  S634C5 ::v49(){vfunc_called(this, "_ZN6S634C53v49Ev");}
void  S634C5 ::v50(){vfunc_called(this, "_ZN6S634C53v50Ev");}
void  S634C5 ::v51(){vfunc_called(this, "_ZN6S634C53v51Ev");}
void  S634C5 ::v52(){vfunc_called(this, "_ZN6S634C53v52Ev");}
void  S634C5 ::v53(){vfunc_called(this, "_ZN6S634C53v53Ev");}
void  S634C5 ::v54(){vfunc_called(this, "_ZN6S634C53v54Ev");}
void  S634C5 ::v55(){vfunc_called(this, "_ZN6S634C53v55Ev");}
void  S634C5 ::v56(){vfunc_called(this, "_ZN6S634C53v56Ev");}
void  S634C5 ::v57(){vfunc_called(this, "_ZN6S634C53v57Ev");}
void  S634C5 ::v58(){vfunc_called(this, "_ZN6S634C53v58Ev");}
void  S634C5 ::v59(){vfunc_called(this, "_ZN6S634C53v59Ev");}
void  S634C5 ::v60(){vfunc_called(this, "_ZN6S634C53v60Ev");}
void  S634C5 ::v61(){vfunc_called(this, "_ZN6S634C53v61Ev");}
void  S634C5 ::v62(){vfunc_called(this, "_ZN6S634C53v62Ev");}
void  S634C5 ::v63(){vfunc_called(this, "_ZN6S634C53v63Ev");}
void  S634C5 ::v64(){vfunc_called(this, "_ZN6S634C53v64Ev");}
void  S634C5 ::v65(){vfunc_called(this, "_ZN6S634C53v65Ev");}
void  S634C5 ::v66(){vfunc_called(this, "_ZN6S634C53v66Ev");}
void  S634C5 ::v67(){vfunc_called(this, "_ZN6S634C53v67Ev");}
void  S634C5 ::v68(){vfunc_called(this, "_ZN6S634C53v68Ev");}
S634C5 ::S634C5(){ note_ctor("S634C5", this);} // tgen

static void Test_S634C5()
{
  extern Class_Descriptor cd_S634C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S634C5, buf);
    S634C5 *dp, &lv = *(dp=new (buf) S634C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S634C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S634C5)");
    check_field_offset(lv, s634c5f0, ABISELECT(8,4), "S634C5.s634c5f0");
    check_field_offset(lv, s634c5f1, ABISELECT(16,8), "S634C5.s634c5f1");
    check_field_offset(lv, s634c5f2, ABISELECT(24,16), "S634C5.s634c5f2");
    check_field_offset(lv, s634c5f3, ABISELECT(56,32), "S634C5.s634c5f3");
    check_field_offset(lv, s634c5f4, ABISELECT(64,40), "S634C5.s634c5f4");
    check_field_offset(lv, s634c5f5, ABISELECT(72,44), "S634C5.s634c5f5");
    check_field_offset(lv, s634c5f6, ABISELECT(80,52), "S634C5.s634c5f6");
    test_class_info(&lv, &cd_S634C5);
    dp->~S634C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS634C5(Test_S634C5, "S634C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S634C5C1Ev();
extern void _ZN6S634C5D1Ev();
Name_Map name_map_S634C5[] = {
  NSPAIR(_ZN6S634C5C1Ev),
  NSPAIR(_ZN6S634C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S634C5[];
extern void _ZN6S634C5D1Ev();
extern void _ZN6S634C5D0Ev();
extern void _ZN6S634C52v5Ev();
extern void _ZN6S634C52v6Ev();
extern void _ZN6S634C52v7Ev();
extern void _ZN6S634C52v8Ev();
extern void _ZN6S634C52v9Ev();
extern void _ZN6S634C53v10Ev();
extern void _ZN6S634C53v11Ev();
extern void _ZN6S634C53v12Ev();
extern void _ZN6S634C53v13Ev();
extern void _ZN6S634C53v14Ev();
extern void _ZN6S634C53v15Ev();
extern void _ZN6S634C53v16Ev();
extern void _ZN6S634C53v17Ev();
extern void _ZN6S634C53v18Ev();
extern void _ZN6S634C53v19Ev();
extern void _ZN6S634C53v20Ev();
extern void _ZN6S634C53v21Ev();
extern void _ZN6S634C53v22Ev();
extern void _ZN6S634C53v23Ev();
extern void _ZN6S634C53v24Ev();
extern void _ZN6S634C53v25Ev();
extern void _ZN6S634C53v26Ev();
extern void _ZN6S634C53v27Ev();
extern void _ZN6S634C53v28Ev();
extern void _ZN6S634C53v29Ev();
extern void _ZN6S634C53v30Ev();
extern void _ZN6S634C53v31Ev();
extern void _ZN6S634C53v32Ev();
extern void _ZN6S634C53v33Ev();
extern void _ZN6S634C53v34Ev();
extern void _ZN6S634C53v35Ev();
extern void _ZN6S634C53v36Ev();
extern void _ZN6S634C53v37Ev();
extern void _ZN6S634C53v38Ev();
extern void _ZN6S634C53v39Ev();
extern void _ZN6S634C53v40Ev();
extern void _ZN6S634C53v41Ev();
extern void _ZN6S634C53v42Ev();
extern void _ZN6S634C53v43Ev();
extern void _ZN6S634C53v44Ev();
extern void _ZN6S634C53v45Ev();
extern void _ZN6S634C53v46Ev();
extern void _ZN6S634C53v47Ev();
extern void _ZN6S634C53v48Ev();
extern void _ZN6S634C53v49Ev();
extern void _ZN6S634C53v50Ev();
extern void _ZN6S634C53v51Ev();
extern void _ZN6S634C53v52Ev();
extern void _ZN6S634C53v53Ev();
extern void _ZN6S634C53v54Ev();
extern void _ZN6S634C53v55Ev();
extern void _ZN6S634C53v56Ev();
extern void _ZN6S634C53v57Ev();
extern void _ZN6S634C53v58Ev();
extern void _ZN6S634C53v59Ev();
extern void _ZN6S634C53v60Ev();
extern void _ZN6S634C53v61Ev();
extern void _ZN6S634C53v62Ev();
extern void _ZN6S634C53v63Ev();
extern void _ZN6S634C53v64Ev();
extern void _ZN6S634C53v65Ev();
extern void _ZN6S634C53v66Ev();
extern void _ZN6S634C53v67Ev();
extern void _ZN6S634C53v68Ev();
static  VTBL_ENTRY vtc_S634C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S634C5[0]),
  (VTBL_ENTRY)&_ZN6S634C5D1Ev,
  (VTBL_ENTRY)&_ZN6S634C5D0Ev,
  (VTBL_ENTRY)&_ZN6S634C52v5Ev,
  (VTBL_ENTRY)&_ZN6S634C52v6Ev,
  (VTBL_ENTRY)&_ZN6S634C52v7Ev,
  (VTBL_ENTRY)&_ZN6S634C52v8Ev,
  (VTBL_ENTRY)&_ZN6S634C52v9Ev,
  (VTBL_ENTRY)&_ZN6S634C53v10Ev,
  (VTBL_ENTRY)&_ZN6S634C53v11Ev,
  (VTBL_ENTRY)&_ZN6S634C53v12Ev,
  (VTBL_ENTRY)&_ZN6S634C53v13Ev,
  (VTBL_ENTRY)&_ZN6S634C53v14Ev,
  (VTBL_ENTRY)&_ZN6S634C53v15Ev,
  (VTBL_ENTRY)&_ZN6S634C53v16Ev,
  (VTBL_ENTRY)&_ZN6S634C53v17Ev,
  (VTBL_ENTRY)&_ZN6S634C53v18Ev,
  (VTBL_ENTRY)&_ZN6S634C53v19Ev,
  (VTBL_ENTRY)&_ZN6S634C53v20Ev,
  (VTBL_ENTRY)&_ZN6S634C53v21Ev,
  (VTBL_ENTRY)&_ZN6S634C53v22Ev,
  (VTBL_ENTRY)&_ZN6S634C53v23Ev,
  (VTBL_ENTRY)&_ZN6S634C53v24Ev,
  (VTBL_ENTRY)&_ZN6S634C53v25Ev,
  (VTBL_ENTRY)&_ZN6S634C53v26Ev,
  (VTBL_ENTRY)&_ZN6S634C53v27Ev,
  (VTBL_ENTRY)&_ZN6S634C53v28Ev,
  (VTBL_ENTRY)&_ZN6S634C53v29Ev,
  (VTBL_ENTRY)&_ZN6S634C53v30Ev,
  (VTBL_ENTRY)&_ZN6S634C53v31Ev,
  (VTBL_ENTRY)&_ZN6S634C53v32Ev,
  (VTBL_ENTRY)&_ZN6S634C53v33Ev,
  (VTBL_ENTRY)&_ZN6S634C53v34Ev,
  (VTBL_ENTRY)&_ZN6S634C53v35Ev,
  (VTBL_ENTRY)&_ZN6S634C53v36Ev,
  (VTBL_ENTRY)&_ZN6S634C53v37Ev,
  (VTBL_ENTRY)&_ZN6S634C53v38Ev,
  (VTBL_ENTRY)&_ZN6S634C53v39Ev,
  (VTBL_ENTRY)&_ZN6S634C53v40Ev,
  (VTBL_ENTRY)&_ZN6S634C53v41Ev,
  (VTBL_ENTRY)&_ZN6S634C53v42Ev,
  (VTBL_ENTRY)&_ZN6S634C53v43Ev,
  (VTBL_ENTRY)&_ZN6S634C53v44Ev,
  (VTBL_ENTRY)&_ZN6S634C53v45Ev,
  (VTBL_ENTRY)&_ZN6S634C53v46Ev,
  (VTBL_ENTRY)&_ZN6S634C53v47Ev,
  (VTBL_ENTRY)&_ZN6S634C53v48Ev,
  (VTBL_ENTRY)&_ZN6S634C53v49Ev,
  (VTBL_ENTRY)&_ZN6S634C53v50Ev,
  (VTBL_ENTRY)&_ZN6S634C53v51Ev,
  (VTBL_ENTRY)&_ZN6S634C53v52Ev,
  (VTBL_ENTRY)&_ZN6S634C53v53Ev,
  (VTBL_ENTRY)&_ZN6S634C53v54Ev,
  (VTBL_ENTRY)&_ZN6S634C53v55Ev,
  (VTBL_ENTRY)&_ZN6S634C53v56Ev,
  (VTBL_ENTRY)&_ZN6S634C53v57Ev,
  (VTBL_ENTRY)&_ZN6S634C53v58Ev,
  (VTBL_ENTRY)&_ZN6S634C53v59Ev,
  (VTBL_ENTRY)&_ZN6S634C53v60Ev,
  (VTBL_ENTRY)&_ZN6S634C53v61Ev,
  (VTBL_ENTRY)&_ZN6S634C53v62Ev,
  (VTBL_ENTRY)&_ZN6S634C53v63Ev,
  (VTBL_ENTRY)&_ZN6S634C53v64Ev,
  (VTBL_ENTRY)&_ZN6S634C53v65Ev,
  (VTBL_ENTRY)&_ZN6S634C53v66Ev,
  (VTBL_ENTRY)&_ZN6S634C53v67Ev,
  (VTBL_ENTRY)&_ZN6S634C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S634C5[];
extern  VTBL_ENTRY _ZTV6S634C5[];
Class_Descriptor cd_S634C5 = {  "S634C5", // class name
  0,0,//no base classes
  &(vtc_S634C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S634C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S634C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S634C4  : S634C5 {
  int s634c4f0[2];
  void *s634c4f1;
  int s634c4f2[2];
  ::S78C39_nt s634c4f3;
  ::S78C39_nt s634c4f4;
  ::S5328C29 s634c4f5;
  ::S78C39_nt s634c4f6;
  unsigned int s634c4f7:1;
  unsigned int s634c4f8:1;
  unsigned int s634c4f9:1;
  unsigned int s634c4f10:1;
  unsigned int s634c4f11:1;
  int s634c4f12[2];
  virtual  ~S634C4(); // _ZN6S634C4D1Ev
  virtual void  v69(); // _ZN6S634C43v69Ev
  virtual void  v70(); // _ZN6S634C43v70Ev
  virtual void  v71(); // _ZN6S634C43v71Ev
  virtual void  v72(); // _ZN6S634C43v72Ev
  virtual void  v73(); // _ZN6S634C43v73Ev
  virtual void  v74(); // _ZN6S634C43v74Ev
  virtual void  v75(); // _ZN6S634C43v75Ev
  virtual void  v76(); // _ZN6S634C43v76Ev
  virtual void  v77(); // _ZN6S634C43v77Ev
  virtual void  v78(); // _ZN6S634C43v78Ev
  virtual void  v79(); // _ZN6S634C43v79Ev
  virtual void  v80(); // _ZN6S634C43v80Ev
  virtual void  v81(); // _ZN6S634C43v81Ev
  virtual void  v82(); // _ZN6S634C43v82Ev
  virtual void  v83(); // _ZN6S634C43v83Ev
  virtual void  v84(); // _ZN6S634C43v84Ev
  virtual void  v85(); // _ZN6S634C43v85Ev
  virtual void  v86(); // _ZN6S634C43v86Ev
  virtual void  v87(); // _ZN6S634C43v87Ev
  virtual void  v88(); // _ZN6S634C43v88Ev
  virtual void  v89(); // _ZN6S634C43v89Ev
  virtual void  v90(); // _ZN6S634C43v90Ev
  S634C4(); // tgen
};
//SIG(-1 S634C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S634C4 ::~S634C4(){ note_dtor("S634C4", this);}
void  S634C4 ::v69(){vfunc_called(this, "_ZN6S634C43v69Ev");}
void  S634C4 ::v70(){vfunc_called(this, "_ZN6S634C43v70Ev");}
void  S634C4 ::v71(){vfunc_called(this, "_ZN6S634C43v71Ev");}
void  S634C4 ::v72(){vfunc_called(this, "_ZN6S634C43v72Ev");}
void  S634C4 ::v73(){vfunc_called(this, "_ZN6S634C43v73Ev");}
void  S634C4 ::v74(){vfunc_called(this, "_ZN6S634C43v74Ev");}
void  S634C4 ::v75(){vfunc_called(this, "_ZN6S634C43v75Ev");}
void  S634C4 ::v76(){vfunc_called(this, "_ZN6S634C43v76Ev");}
void  S634C4 ::v77(){vfunc_called(this, "_ZN6S634C43v77Ev");}
void  S634C4 ::v78(){vfunc_called(this, "_ZN6S634C43v78Ev");}
void  S634C4 ::v79(){vfunc_called(this, "_ZN6S634C43v79Ev");}
void  S634C4 ::v80(){vfunc_called(this, "_ZN6S634C43v80Ev");}
void  S634C4 ::v81(){vfunc_called(this, "_ZN6S634C43v81Ev");}
void  S634C4 ::v82(){vfunc_called(this, "_ZN6S634C43v82Ev");}
void  S634C4 ::v83(){vfunc_called(this, "_ZN6S634C43v83Ev");}
void  S634C4 ::v84(){vfunc_called(this, "_ZN6S634C43v84Ev");}
void  S634C4 ::v85(){vfunc_called(this, "_ZN6S634C43v85Ev");}
void  S634C4 ::v86(){vfunc_called(this, "_ZN6S634C43v86Ev");}
void  S634C4 ::v87(){vfunc_called(this, "_ZN6S634C43v87Ev");}
void  S634C4 ::v88(){vfunc_called(this, "_ZN6S634C43v88Ev");}
void  S634C4 ::v89(){vfunc_called(this, "_ZN6S634C43v89Ev");}
void  S634C4 ::v90(){vfunc_called(this, "_ZN6S634C43v90Ev");}
S634C4 ::S634C4(){ note_ctor("S634C4", this);} // tgen

static void Test_S634C4()
{
  extern Class_Descriptor cd_S634C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S634C4, buf);
    S634C4 *dp, &lv = *(dp=new (buf) S634C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S634C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S634C4)");
    check_base_class_offset(lv, (S634C5*), 0, "S634C4");
    check_field_offset(lv, s634c4f0, ABISELECT(96,60), "S634C4.s634c4f0");
    check_field_offset(lv, s634c4f1, ABISELECT(104,68), "S634C4.s634c4f1");
    check_field_offset(lv, s634c4f2, ABISELECT(112,72), "S634C4.s634c4f2");
    check_field_offset(lv, s634c4f3, ABISELECT(120,80), "S634C4.s634c4f3");
    check_field_offset(lv, s634c4f4, ABISELECT(136,92), "S634C4.s634c4f4");
    check_field_offset(lv, s634c4f5, ABISELECT(152,104), "S634C4.s634c4f5");
    check_field_offset(lv, s634c4f6, ABISELECT(160,108), "S634C4.s634c4f6");
    set_bf_and_test(lv, s634c4f7, ABISELECT(176,120), 0, 1, 1, "S634C4");
    set_bf_and_test(lv, s634c4f8, ABISELECT(176,120), 1, 1, 1, "S634C4");
    set_bf_and_test(lv, s634c4f9, ABISELECT(176,120), 2, 1, 1, "S634C4");
    set_bf_and_test(lv, s634c4f10, ABISELECT(176,120), 3, 1, 1, "S634C4");
    set_bf_and_test(lv, s634c4f11, ABISELECT(176,120), 4, 1, 1, "S634C4");
    check_field_offset(lv, s634c4f12, ABISELECT(180,124), "S634C4.s634c4f12");
    test_class_info(&lv, &cd_S634C4);
    dp->~S634C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS634C4(Test_S634C4, "S634C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S634C4C1Ev();
extern void _ZN6S634C4D1Ev();
Name_Map name_map_S634C4[] = {
  NSPAIR(_ZN6S634C4C1Ev),
  NSPAIR(_ZN6S634C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S634C5;
extern VTBL_ENTRY _ZTI6S634C5[];
extern  VTBL_ENTRY _ZTV6S634C5[];
static Base_Class bases_S634C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S634C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S634C4[];
extern void _ZN6S634C4D1Ev();
extern void _ZN6S634C4D0Ev();
extern void _ZN6S634C52v5Ev();
extern void _ZN6S634C52v6Ev();
extern void _ZN6S634C52v7Ev();
extern void _ZN6S634C52v8Ev();
extern void _ZN6S634C52v9Ev();
extern void _ZN6S634C53v10Ev();
extern void _ZN6S634C53v11Ev();
extern void _ZN6S634C53v12Ev();
extern void _ZN6S634C53v13Ev();
extern void _ZN6S634C53v14Ev();
extern void _ZN6S634C53v15Ev();
extern void _ZN6S634C53v16Ev();
extern void _ZN6S634C53v17Ev();
extern void _ZN6S634C53v18Ev();
extern void _ZN6S634C53v19Ev();
extern void _ZN6S634C53v20Ev();
extern void _ZN6S634C53v21Ev();
extern void _ZN6S634C53v22Ev();
extern void _ZN6S634C53v23Ev();
extern void _ZN6S634C53v24Ev();
extern void _ZN6S634C53v25Ev();
extern void _ZN6S634C53v26Ev();
extern void _ZN6S634C53v27Ev();
extern void _ZN6S634C53v28Ev();
extern void _ZN6S634C53v29Ev();
extern void _ZN6S634C53v30Ev();
extern void _ZN6S634C53v31Ev();
extern void _ZN6S634C53v32Ev();
extern void _ZN6S634C53v33Ev();
extern void _ZN6S634C53v34Ev();
extern void _ZN6S634C53v35Ev();
extern void _ZN6S634C53v36Ev();
extern void _ZN6S634C53v37Ev();
extern void _ZN6S634C53v38Ev();
extern void _ZN6S634C53v39Ev();
extern void _ZN6S634C53v40Ev();
extern void _ZN6S634C53v41Ev();
extern void _ZN6S634C53v42Ev();
extern void _ZN6S634C53v43Ev();
extern void _ZN6S634C53v44Ev();
extern void _ZN6S634C53v45Ev();
extern void _ZN6S634C53v46Ev();
extern void _ZN6S634C53v47Ev();
extern void _ZN6S634C53v48Ev();
extern void _ZN6S634C53v49Ev();
extern void _ZN6S634C53v50Ev();
extern void _ZN6S634C53v51Ev();
extern void _ZN6S634C53v52Ev();
extern void _ZN6S634C53v53Ev();
extern void _ZN6S634C53v54Ev();
extern void _ZN6S634C53v55Ev();
extern void _ZN6S634C53v56Ev();
extern void _ZN6S634C53v57Ev();
extern void _ZN6S634C53v58Ev();
extern void _ZN6S634C53v59Ev();
extern void _ZN6S634C53v60Ev();
extern void _ZN6S634C53v61Ev();
extern void _ZN6S634C53v62Ev();
extern void _ZN6S634C53v63Ev();
extern void _ZN6S634C53v64Ev();
extern void _ZN6S634C53v65Ev();
extern void _ZN6S634C53v66Ev();
extern void _ZN6S634C53v67Ev();
extern void _ZN6S634C53v68Ev();
extern void _ZN6S634C43v69Ev();
extern void _ZN6S634C43v70Ev();
extern void _ZN6S634C43v71Ev();
extern void _ZN6S634C43v72Ev();
extern void _ZN6S634C43v73Ev();
extern void _ZN6S634C43v74Ev();
extern void _ZN6S634C43v75Ev();
extern void _ZN6S634C43v76Ev();
extern void _ZN6S634C43v77Ev();
extern void _ZN6S634C43v78Ev();
extern void _ZN6S634C43v79Ev();
extern void _ZN6S634C43v80Ev();
extern void _ZN6S634C43v81Ev();
extern void _ZN6S634C43v82Ev();
extern void _ZN6S634C43v83Ev();
extern void _ZN6S634C43v84Ev();
extern void _ZN6S634C43v85Ev();
extern void _ZN6S634C43v86Ev();
extern void _ZN6S634C43v87Ev();
extern void _ZN6S634C43v88Ev();
extern void _ZN6S634C43v89Ev();
extern void _ZN6S634C43v90Ev();
static  VTBL_ENTRY vtc_S634C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S634C4[0]),
  (VTBL_ENTRY)&_ZN6S634C4D1Ev,
  (VTBL_ENTRY)&_ZN6S634C4D0Ev,
  (VTBL_ENTRY)&_ZN6S634C52v5Ev,
  (VTBL_ENTRY)&_ZN6S634C52v6Ev,
  (VTBL_ENTRY)&_ZN6S634C52v7Ev,
  (VTBL_ENTRY)&_ZN6S634C52v8Ev,
  (VTBL_ENTRY)&_ZN6S634C52v9Ev,
  (VTBL_ENTRY)&_ZN6S634C53v10Ev,
  (VTBL_ENTRY)&_ZN6S634C53v11Ev,
  (VTBL_ENTRY)&_ZN6S634C53v12Ev,
  (VTBL_ENTRY)&_ZN6S634C53v13Ev,
  (VTBL_ENTRY)&_ZN6S634C53v14Ev,
  (VTBL_ENTRY)&_ZN6S634C53v15Ev,
  (VTBL_ENTRY)&_ZN6S634C53v16Ev,
  (VTBL_ENTRY)&_ZN6S634C53v17Ev,
  (VTBL_ENTRY)&_ZN6S634C53v18Ev,
  (VTBL_ENTRY)&_ZN6S634C53v19Ev,
  (VTBL_ENTRY)&_ZN6S634C53v20Ev,
  (VTBL_ENTRY)&_ZN6S634C53v21Ev,
  (VTBL_ENTRY)&_ZN6S634C53v22Ev,
  (VTBL_ENTRY)&_ZN6S634C53v23Ev,
  (VTBL_ENTRY)&_ZN6S634C53v24Ev,
  (VTBL_ENTRY)&_ZN6S634C53v25Ev,
  (VTBL_ENTRY)&_ZN6S634C53v26Ev,
  (VTBL_ENTRY)&_ZN6S634C53v27Ev,
  (VTBL_ENTRY)&_ZN6S634C53v28Ev,
  (VTBL_ENTRY)&_ZN6S634C53v29Ev,
  (VTBL_ENTRY)&_ZN6S634C53v30Ev,
  (VTBL_ENTRY)&_ZN6S634C53v31Ev,
  (VTBL_ENTRY)&_ZN6S634C53v32Ev,
  (VTBL_ENTRY)&_ZN6S634C53v33Ev,
  (VTBL_ENTRY)&_ZN6S634C53v34Ev,
  (VTBL_ENTRY)&_ZN6S634C53v35Ev,
  (VTBL_ENTRY)&_ZN6S634C53v36Ev,
  (VTBL_ENTRY)&_ZN6S634C53v37Ev,
  (VTBL_ENTRY)&_ZN6S634C53v38Ev,
  (VTBL_ENTRY)&_ZN6S634C53v39Ev,
  (VTBL_ENTRY)&_ZN6S634C53v40Ev,
  (VTBL_ENTRY)&_ZN6S634C53v41Ev,
  (VTBL_ENTRY)&_ZN6S634C53v42Ev,
  (VTBL_ENTRY)&_ZN6S634C53v43Ev,
  (VTBL_ENTRY)&_ZN6S634C53v44Ev,
  (VTBL_ENTRY)&_ZN6S634C53v45Ev,
  (VTBL_ENTRY)&_ZN6S634C53v46Ev,
  (VTBL_ENTRY)&_ZN6S634C53v47Ev,
  (VTBL_ENTRY)&_ZN6S634C53v48Ev,
  (VTBL_ENTRY)&_ZN6S634C53v49Ev,
  (VTBL_ENTRY)&_ZN6S634C53v50Ev,
  (VTBL_ENTRY)&_ZN6S634C53v51Ev,
  (VTBL_ENTRY)&_ZN6S634C53v52Ev,
  (VTBL_ENTRY)&_ZN6S634C53v53Ev,
  (VTBL_ENTRY)&_ZN6S634C53v54Ev,
  (VTBL_ENTRY)&_ZN6S634C53v55Ev,
  (VTBL_ENTRY)&_ZN6S634C53v56Ev,
  (VTBL_ENTRY)&_ZN6S634C53v57Ev,
  (VTBL_ENTRY)&_ZN6S634C53v58Ev,
  (VTBL_ENTRY)&_ZN6S634C53v59Ev,
  (VTBL_ENTRY)&_ZN6S634C53v60Ev,
  (VTBL_ENTRY)&_ZN6S634C53v61Ev,
  (VTBL_ENTRY)&_ZN6S634C53v62Ev,
  (VTBL_ENTRY)&_ZN6S634C53v63Ev,
  (VTBL_ENTRY)&_ZN6S634C53v64Ev,
  (VTBL_ENTRY)&_ZN6S634C53v65Ev,
  (VTBL_ENTRY)&_ZN6S634C53v66Ev,
  (VTBL_ENTRY)&_ZN6S634C53v67Ev,
  (VTBL_ENTRY)&_ZN6S634C53v68Ev,
  (VTBL_ENTRY)&_ZN6S634C43v69Ev,
  (VTBL_ENTRY)&_ZN6S634C43v70Ev,
  (VTBL_ENTRY)&_ZN6S634C43v71Ev,
  (VTBL_ENTRY)&_ZN6S634C43v72Ev,
  (VTBL_ENTRY)&_ZN6S634C43v73Ev,
  (VTBL_ENTRY)&_ZN6S634C43v74Ev,
  (VTBL_ENTRY)&_ZN6S634C43v75Ev,
  (VTBL_ENTRY)&_ZN6S634C43v76Ev,
  (VTBL_ENTRY)&_ZN6S634C43v77Ev,
  (VTBL_ENTRY)&_ZN6S634C43v78Ev,
  (VTBL_ENTRY)&_ZN6S634C43v79Ev,
  (VTBL_ENTRY)&_ZN6S634C43v80Ev,
  (VTBL_ENTRY)&_ZN6S634C43v81Ev,
  (VTBL_ENTRY)&_ZN6S634C43v82Ev,
  (VTBL_ENTRY)&_ZN6S634C43v83Ev,
  (VTBL_ENTRY)&_ZN6S634C43v84Ev,
  (VTBL_ENTRY)&_ZN6S634C43v85Ev,
  (VTBL_ENTRY)&_ZN6S634C43v86Ev,
  (VTBL_ENTRY)&_ZN6S634C43v87Ev,
  (VTBL_ENTRY)&_ZN6S634C43v88Ev,
  (VTBL_ENTRY)&_ZN6S634C43v89Ev,
  (VTBL_ENTRY)&_ZN6S634C43v90Ev,
};
extern VTBL_ENTRY _ZTI6S634C4[];
extern  VTBL_ENTRY _ZTV6S634C4[];
Class_Descriptor cd_S634C4 = {  "S634C4", // class name
  bases_S634C4, 1,
  &(vtc_S634C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S634C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S634C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S634C3  : S634C4 {
  unsigned int s634c3f0:1;
  unsigned int s634c3f1:1;
  unsigned int s634c3f2:1;
  ::S78C49 s634c3f3;
  ::S78C44 s634c3f4;
  ::S78C40 s634c3f5;
  ::S78C19 s634c3f6;
  int s634c3f7[3];
  virtual  ~S634C3(); // _ZN6S634C3D1Ev
  virtual void  v91(); // _ZN6S634C33v91Ev
  virtual void  v92(); // _ZN6S634C33v92Ev
  virtual void  v93(); // _ZN6S634C33v93Ev
  virtual void  v94(); // _ZN6S634C33v94Ev
  virtual void  v95(); // _ZN6S634C33v95Ev
  virtual void  v96(); // _ZN6S634C33v96Ev
  virtual void  v97(); // _ZN6S634C33v97Ev
  virtual void  v98(); // _ZN6S634C33v98Ev
  virtual void  v99(); // _ZN6S634C33v99Ev
  virtual void  v100(); // _ZN6S634C34v100Ev
  virtual void  v101(); // _ZN6S634C34v101Ev
  virtual void  v102(); // _ZN6S634C34v102Ev
  virtual void  v103(); // _ZN6S634C34v103Ev
  virtual void  v104(); // _ZN6S634C34v104Ev
  virtual void  v105(); // _ZN6S634C34v105Ev
  virtual void  v106(); // _ZN6S634C34v106Ev
  virtual void  v107(); // _ZN6S634C34v107Ev
  virtual void  v108(); // _ZN6S634C34v108Ev
  virtual void  v109(); // _ZN6S634C34v109Ev
  virtual void  v110(); // _ZN6S634C34v110Ev
  S634C3(); // tgen
};
//SIG(-1 S634C3) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC6 FC14{ BC15{ BC8}} Fi[3]}


 S634C3 ::~S634C3(){ note_dtor("S634C3", this);}
void  S634C3 ::v91(){vfunc_called(this, "_ZN6S634C33v91Ev");}
void  S634C3 ::v92(){vfunc_called(this, "_ZN6S634C33v92Ev");}
void  S634C3 ::v93(){vfunc_called(this, "_ZN6S634C33v93Ev");}
void  S634C3 ::v94(){vfunc_called(this, "_ZN6S634C33v94Ev");}
void  S634C3 ::v95(){vfunc_called(this, "_ZN6S634C33v95Ev");}
void  S634C3 ::v96(){vfunc_called(this, "_ZN6S634C33v96Ev");}
void  S634C3 ::v97(){vfunc_called(this, "_ZN6S634C33v97Ev");}
void  S634C3 ::v98(){vfunc_called(this, "_ZN6S634C33v98Ev");}
void  S634C3 ::v99(){vfunc_called(this, "_ZN6S634C33v99Ev");}
void  S634C3 ::v100(){vfunc_called(this, "_ZN6S634C34v100Ev");}
void  S634C3 ::v101(){vfunc_called(this, "_ZN6S634C34v101Ev");}
void  S634C3 ::v102(){vfunc_called(this, "_ZN6S634C34v102Ev");}
void  S634C3 ::v103(){vfunc_called(this, "_ZN6S634C34v103Ev");}
void  S634C3 ::v104(){vfunc_called(this, "_ZN6S634C34v104Ev");}
void  S634C3 ::v105(){vfunc_called(this, "_ZN6S634C34v105Ev");}
void  S634C3 ::v106(){vfunc_called(this, "_ZN6S634C34v106Ev");}
void  S634C3 ::v107(){vfunc_called(this, "_ZN6S634C34v107Ev");}
void  S634C3 ::v108(){vfunc_called(this, "_ZN6S634C34v108Ev");}
void  S634C3 ::v109(){vfunc_called(this, "_ZN6S634C34v109Ev");}
void  S634C3 ::v110(){vfunc_called(this, "_ZN6S634C34v110Ev");}
S634C3 ::S634C3(){ note_ctor("S634C3", this);} // tgen

static void Test_S634C3()
{
  extern Class_Descriptor cd_S634C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S634C3, buf);
    S634C3 *dp, &lv = *(dp=new (buf) S634C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S634C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S634C3)");
    check_base_class_offset(lv, (S634C5*)(S634C4*), 0, "S634C3");
    check_base_class_offset(lv, (S634C4*), 0, "S634C3");
    set_bf_and_test(lv, s634c3f0, ABISELECT(188,132), 0, 1, 1, "S634C3");
    set_bf_and_test(lv, s634c3f1, ABISELECT(188,132), 1, 1, 1, "S634C3");
    set_bf_and_test(lv, s634c3f2, ABISELECT(188,132), 2, 1, 1, "S634C3");
    check_field_offset(lv, s634c3f3, ABISELECT(192,136), "S634C3.s634c3f3");
    check_field_offset(lv, s634c3f4, ABISELECT(208,148), "S634C3.s634c3f4");
    check_field_offset(lv, s634c3f5, ABISELECT(224,160), "S634C3.s634c3f5");
    check_field_offset(lv, s634c3f6, ABISELECT(240,172), "S634C3.s634c3f6");
    check_field_offset(lv, s634c3f7, ABISELECT(256,184), "S634C3.s634c3f7");
    test_class_info(&lv, &cd_S634C3);
    dp->~S634C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS634C3(Test_S634C3, "S634C3", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S634C3C1Ev();
extern void _ZN6S634C3D1Ev();
Name_Map name_map_S634C3[] = {
  NSPAIR(_ZN6S634C3C1Ev),
  NSPAIR(_ZN6S634C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S634C5;
extern VTBL_ENTRY _ZTI6S634C5[];
extern  VTBL_ENTRY _ZTV6S634C5[];
extern Class_Descriptor cd_S634C4;
extern VTBL_ENTRY _ZTI6S634C4[];
extern  VTBL_ENTRY _ZTV6S634C4[];
static Base_Class bases_S634C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S634C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S634C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S634C3[];
extern void _ZN6S634C3D1Ev();
extern void _ZN6S634C3D0Ev();
extern void _ZN6S634C52v5Ev();
extern void _ZN6S634C52v6Ev();
extern void _ZN6S634C52v7Ev();
extern void _ZN6S634C52v8Ev();
extern void _ZN6S634C52v9Ev();
extern void _ZN6S634C53v10Ev();
extern void _ZN6S634C53v11Ev();
extern void _ZN6S634C53v12Ev();
extern void _ZN6S634C53v13Ev();
extern void _ZN6S634C53v14Ev();
extern void _ZN6S634C53v15Ev();
extern void _ZN6S634C53v16Ev();
extern void _ZN6S634C53v17Ev();
extern void _ZN6S634C53v18Ev();
extern void _ZN6S634C53v19Ev();
extern void _ZN6S634C53v20Ev();
extern void _ZN6S634C53v21Ev();
extern void _ZN6S634C53v22Ev();
extern void _ZN6S634C53v23Ev();
extern void _ZN6S634C53v24Ev();
extern void _ZN6S634C53v25Ev();
extern void _ZN6S634C53v26Ev();
extern void _ZN6S634C53v27Ev();
extern void _ZN6S634C53v28Ev();
extern void _ZN6S634C53v29Ev();
extern void _ZN6S634C53v30Ev();
extern void _ZN6S634C53v31Ev();
extern void _ZN6S634C53v32Ev();
extern void _ZN6S634C53v33Ev();
extern void _ZN6S634C53v34Ev();
extern void _ZN6S634C53v35Ev();
extern void _ZN6S634C53v36Ev();
extern void _ZN6S634C53v37Ev();
extern void _ZN6S634C53v38Ev();
extern void _ZN6S634C53v39Ev();
extern void _ZN6S634C53v40Ev();
extern void _ZN6S634C53v41Ev();
extern void _ZN6S634C53v42Ev();
extern void _ZN6S634C53v43Ev();
extern void _ZN6S634C53v44Ev();
extern void _ZN6S634C53v45Ev();
extern void _ZN6S634C53v46Ev();
extern void _ZN6S634C53v47Ev();
extern void _ZN6S634C53v48Ev();
extern void _ZN6S634C53v49Ev();
extern void _ZN6S634C53v50Ev();
extern void _ZN6S634C53v51Ev();
extern void _ZN6S634C53v52Ev();
extern void _ZN6S634C53v53Ev();
extern void _ZN6S634C53v54Ev();
extern void _ZN6S634C53v55Ev();
extern void _ZN6S634C53v56Ev();
extern void _ZN6S634C53v57Ev();
extern void _ZN6S634C53v58Ev();
extern void _ZN6S634C53v59Ev();
extern void _ZN6S634C53v60Ev();
extern void _ZN6S634C53v61Ev();
extern void _ZN6S634C53v62Ev();
extern void _ZN6S634C53v63Ev();
extern void _ZN6S634C53v64Ev();
extern void _ZN6S634C53v65Ev();
extern void _ZN6S634C53v66Ev();
extern void _ZN6S634C53v67Ev();
extern void _ZN6S634C53v68Ev();
extern void _ZN6S634C43v69Ev();
extern void _ZN6S634C43v70Ev();
extern void _ZN6S634C43v71Ev();
extern void _ZN6S634C43v72Ev();
extern void _ZN6S634C43v73Ev();
extern void _ZN6S634C43v74Ev();
extern void _ZN6S634C43v75Ev();
extern void _ZN6S634C43v76Ev();
extern void _ZN6S634C43v77Ev();
extern void _ZN6S634C43v78Ev();
extern void _ZN6S634C43v79Ev();
extern void _ZN6S634C43v80Ev();
extern void _ZN6S634C43v81Ev();
extern void _ZN6S634C43v82Ev();
extern void _ZN6S634C43v83Ev();
extern void _ZN6S634C43v84Ev();
extern void _ZN6S634C43v85Ev();
extern void _ZN6S634C43v86Ev();
extern void _ZN6S634C43v87Ev();
extern void _ZN6S634C43v88Ev();
extern void _ZN6S634C43v89Ev();
extern void _ZN6S634C43v90Ev();
extern void _ZN6S634C33v91Ev();
extern void _ZN6S634C33v92Ev();
extern void _ZN6S634C33v93Ev();
extern void _ZN6S634C33v94Ev();
extern void _ZN6S634C33v95Ev();
extern void _ZN6S634C33v96Ev();
extern void _ZN6S634C33v97Ev();
extern void _ZN6S634C33v98Ev();
extern void _ZN6S634C33v99Ev();
extern void _ZN6S634C34v100Ev();
extern void _ZN6S634C34v101Ev();
extern void _ZN6S634C34v102Ev();
extern void _ZN6S634C34v103Ev();
extern void _ZN6S634C34v104Ev();
extern void _ZN6S634C34v105Ev();
extern void _ZN6S634C34v106Ev();
extern void _ZN6S634C34v107Ev();
extern void _ZN6S634C34v108Ev();
extern void _ZN6S634C34v109Ev();
extern void _ZN6S634C34v110Ev();
static  VTBL_ENTRY vtc_S634C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S634C3[0]),
  (VTBL_ENTRY)&_ZN6S634C3D1Ev,
  (VTBL_ENTRY)&_ZN6S634C3D0Ev,
  (VTBL_ENTRY)&_ZN6S634C52v5Ev,
  (VTBL_ENTRY)&_ZN6S634C52v6Ev,
  (VTBL_ENTRY)&_ZN6S634C52v7Ev,
  (VTBL_ENTRY)&_ZN6S634C52v8Ev,
  (VTBL_ENTRY)&_ZN6S634C52v9Ev,
  (VTBL_ENTRY)&_ZN6S634C53v10Ev,
  (VTBL_ENTRY)&_ZN6S634C53v11Ev,
  (VTBL_ENTRY)&_ZN6S634C53v12Ev,
  (VTBL_ENTRY)&_ZN6S634C53v13Ev,
  (VTBL_ENTRY)&_ZN6S634C53v14Ev,
  (VTBL_ENTRY)&_ZN6S634C53v15Ev,
  (VTBL_ENTRY)&_ZN6S634C53v16Ev,
  (VTBL_ENTRY)&_ZN6S634C53v17Ev,
  (VTBL_ENTRY)&_ZN6S634C53v18Ev,
  (VTBL_ENTRY)&_ZN6S634C53v19Ev,
  (VTBL_ENTRY)&_ZN6S634C53v20Ev,
  (VTBL_ENTRY)&_ZN6S634C53v21Ev,
  (VTBL_ENTRY)&_ZN6S634C53v22Ev,
  (VTBL_ENTRY)&_ZN6S634C53v23Ev,
  (VTBL_ENTRY)&_ZN6S634C53v24Ev,
  (VTBL_ENTRY)&_ZN6S634C53v25Ev,
  (VTBL_ENTRY)&_ZN6S634C53v26Ev,
  (VTBL_ENTRY)&_ZN6S634C53v27Ev,
  (VTBL_ENTRY)&_ZN6S634C53v28Ev,
  (VTBL_ENTRY)&_ZN6S634C53v29Ev,
  (VTBL_ENTRY)&_ZN6S634C53v30Ev,
  (VTBL_ENTRY)&_ZN6S634C53v31Ev,
  (VTBL_ENTRY)&_ZN6S634C53v32Ev,
  (VTBL_ENTRY)&_ZN6S634C53v33Ev,
  (VTBL_ENTRY)&_ZN6S634C53v34Ev,
  (VTBL_ENTRY)&_ZN6S634C53v35Ev,
  (VTBL_ENTRY)&_ZN6S634C53v36Ev,
  (VTBL_ENTRY)&_ZN6S634C53v37Ev,
  (VTBL_ENTRY)&_ZN6S634C53v38Ev,
  (VTBL_ENTRY)&_ZN6S634C53v39Ev,
  (VTBL_ENTRY)&_ZN6S634C53v40Ev,
  (VTBL_ENTRY)&_ZN6S634C53v41Ev,
  (VTBL_ENTRY)&_ZN6S634C53v42Ev,
  (VTBL_ENTRY)&_ZN6S634C53v43Ev,
  (VTBL_ENTRY)&_ZN6S634C53v44Ev,
  (VTBL_ENTRY)&_ZN6S634C53v45Ev,
  (VTBL_ENTRY)&_ZN6S634C53v46Ev,
  (VTBL_ENTRY)&_ZN6S634C53v47Ev,
  (VTBL_ENTRY)&_ZN6S634C53v48Ev,
  (VTBL_ENTRY)&_ZN6S634C53v49Ev,
  (VTBL_ENTRY)&_ZN6S634C53v50Ev,
  (VTBL_ENTRY)&_ZN6S634C53v51Ev,
  (VTBL_ENTRY)&_ZN6S634C53v52Ev,
  (VTBL_ENTRY)&_ZN6S634C53v53Ev,
  (VTBL_ENTRY)&_ZN6S634C53v54Ev,
  (VTBL_ENTRY)&_ZN6S634C53v55Ev,
  (VTBL_ENTRY)&_ZN6S634C53v56Ev,
  (VTBL_ENTRY)&_ZN6S634C53v57Ev,
  (VTBL_ENTRY)&_ZN6S634C53v58Ev,
  (VTBL_ENTRY)&_ZN6S634C53v59Ev,
  (VTBL_ENTRY)&_ZN6S634C53v60Ev,
  (VTBL_ENTRY)&_ZN6S634C53v61Ev,
  (VTBL_ENTRY)&_ZN6S634C53v62Ev,
  (VTBL_ENTRY)&_ZN6S634C53v63Ev,
  (VTBL_ENTRY)&_ZN6S634C53v64Ev,
  (VTBL_ENTRY)&_ZN6S634C53v65Ev,
  (VTBL_ENTRY)&_ZN6S634C53v66Ev,
  (VTBL_ENTRY)&_ZN6S634C53v67Ev,
  (VTBL_ENTRY)&_ZN6S634C53v68Ev,
  (VTBL_ENTRY)&_ZN6S634C43v69Ev,
  (VTBL_ENTRY)&_ZN6S634C43v70Ev,
  (VTBL_ENTRY)&_ZN6S634C43v71Ev,
  (VTBL_ENTRY)&_ZN6S634C43v72Ev,
  (VTBL_ENTRY)&_ZN6S634C43v73Ev,
  (VTBL_ENTRY)&_ZN6S634C43v74Ev,
  (VTBL_ENTRY)&_ZN6S634C43v75Ev,
  (VTBL_ENTRY)&_ZN6S634C43v76Ev,
  (VTBL_ENTRY)&_ZN6S634C43v77Ev,
  (VTBL_ENTRY)&_ZN6S634C43v78Ev,
  (VTBL_ENTRY)&_ZN6S634C43v79Ev,
  (VTBL_ENTRY)&_ZN6S634C43v80Ev,
  (VTBL_ENTRY)&_ZN6S634C43v81Ev,
  (VTBL_ENTRY)&_ZN6S634C43v82Ev,
  (VTBL_ENTRY)&_ZN6S634C43v83Ev,
  (VTBL_ENTRY)&_ZN6S634C43v84Ev,
  (VTBL_ENTRY)&_ZN6S634C43v85Ev,
  (VTBL_ENTRY)&_ZN6S634C43v86Ev,
  (VTBL_ENTRY)&_ZN6S634C43v87Ev,
  (VTBL_ENTRY)&_ZN6S634C43v88Ev,
  (VTBL_ENTRY)&_ZN6S634C43v89Ev,
  (VTBL_ENTRY)&_ZN6S634C43v90Ev,
  (VTBL_ENTRY)&_ZN6S634C33v91Ev,
  (VTBL_ENTRY)&_ZN6S634C33v92Ev,
  (VTBL_ENTRY)&_ZN6S634C33v93Ev,
  (VTBL_ENTRY)&_ZN6S634C33v94Ev,
  (VTBL_ENTRY)&_ZN6S634C33v95Ev,
  (VTBL_ENTRY)&_ZN6S634C33v96Ev,
  (VTBL_ENTRY)&_ZN6S634C33v97Ev,
  (VTBL_ENTRY)&_ZN6S634C33v98Ev,
  (VTBL_ENTRY)&_ZN6S634C33v99Ev,
  (VTBL_ENTRY)&_ZN6S634C34v100Ev,
  (VTBL_ENTRY)&_ZN6S634C34v101Ev,
  (VTBL_ENTRY)&_ZN6S634C34v102Ev,
  (VTBL_ENTRY)&_ZN6S634C34v103Ev,
  (VTBL_ENTRY)&_ZN6S634C34v104Ev,
  (VTBL_ENTRY)&_ZN6S634C34v105Ev,
  (VTBL_ENTRY)&_ZN6S634C34v106Ev,
  (VTBL_ENTRY)&_ZN6S634C34v107Ev,
  (VTBL_ENTRY)&_ZN6S634C34v108Ev,
  (VTBL_ENTRY)&_ZN6S634C34v109Ev,
  (VTBL_ENTRY)&_ZN6S634C34v110Ev,
};
extern VTBL_ENTRY _ZTI6S634C3[];
extern  VTBL_ENTRY _ZTV6S634C3[];
Class_Descriptor cd_S634C3 = {  "S634C3", // class name
  bases_S634C3, 2,
  &(vtc_S634C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S634C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S634C3),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S634C2  : S634C3 {
  ::S78C8_nt s634c2f0;
  unsigned int s634c2f1:1;
  ::S78C15 s634c2f2;
  virtual  ~S634C2(); // _ZN6S634C2D1Ev
  virtual void  v111(); // _ZN6S634C24v111Ev
  virtual void  v112(); // _ZN6S634C24v112Ev
  virtual void  v113(); // _ZN6S634C24v113Ev
  virtual void  v114(); // _ZN6S634C24v114Ev
  S634C2(); // tgen
};
//SIG(-1 S634C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC7 FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S634C2 ::~S634C2(){ note_dtor("S634C2", this);}
void  S634C2 ::v111(){vfunc_called(this, "_ZN6S634C24v111Ev");}
void  S634C2 ::v112(){vfunc_called(this, "_ZN6S634C24v112Ev");}
void  S634C2 ::v113(){vfunc_called(this, "_ZN6S634C24v113Ev");}
void  S634C2 ::v114(){vfunc_called(this, "_ZN6S634C24v114Ev");}
S634C2 ::S634C2(){ note_ctor("S634C2", this);} // tgen

static void Test_S634C2()
{
  extern Class_Descriptor cd_S634C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S634C2, buf);
    S634C2 *dp, &lv = *(dp=new (buf) S634C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S634C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S634C2)");
    check_base_class_offset(lv, (S634C5*)(S634C4*)(S634C3*), 0, "S634C2");
    check_base_class_offset(lv, (S634C4*)(S634C3*), 0, "S634C2");
    check_base_class_offset(lv, (S634C3*), 0, "S634C2");
    check_field_offset(lv, s634c2f0, ABISELECT(268,196), "S634C2.s634c2f0");
    set_bf_and_test(lv, s634c2f1, ABISELECT(276,204), 0, 1, 1, "S634C2");
    check_field_offset(lv, s634c2f2, ABISELECT(280,208), "S634C2.s634c2f2");
    test_class_info(&lv, &cd_S634C2);
    dp->~S634C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS634C2(Test_S634C2, "S634C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S634C2C1Ev();
extern void _ZN6S634C2D1Ev();
Name_Map name_map_S634C2[] = {
  NSPAIR(_ZN6S634C2C1Ev),
  NSPAIR(_ZN6S634C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S634C5;
extern VTBL_ENTRY _ZTI6S634C5[];
extern  VTBL_ENTRY _ZTV6S634C5[];
extern Class_Descriptor cd_S634C4;
extern VTBL_ENTRY _ZTI6S634C4[];
extern  VTBL_ENTRY _ZTV6S634C4[];
extern Class_Descriptor cd_S634C3;
extern VTBL_ENTRY _ZTI6S634C3[];
extern  VTBL_ENTRY _ZTV6S634C3[];
static Base_Class bases_S634C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S634C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S634C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S634C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S634C2[];
extern void _ZN6S634C2D1Ev();
extern void _ZN6S634C2D0Ev();
extern void _ZN6S634C52v5Ev();
extern void _ZN6S634C52v6Ev();
extern void _ZN6S634C52v7Ev();
extern void _ZN6S634C52v8Ev();
extern void _ZN6S634C52v9Ev();
extern void _ZN6S634C53v10Ev();
extern void _ZN6S634C53v11Ev();
extern void _ZN6S634C53v12Ev();
extern void _ZN6S634C53v13Ev();
extern void _ZN6S634C53v14Ev();
extern void _ZN6S634C53v15Ev();
extern void _ZN6S634C53v16Ev();
extern void _ZN6S634C53v17Ev();
extern void _ZN6S634C53v18Ev();
extern void _ZN6S634C53v19Ev();
extern void _ZN6S634C53v20Ev();
extern void _ZN6S634C53v21Ev();
extern void _ZN6S634C53v22Ev();
extern void _ZN6S634C53v23Ev();
extern void _ZN6S634C53v24Ev();
extern void _ZN6S634C53v25Ev();
extern void _ZN6S634C53v26Ev();
extern void _ZN6S634C53v27Ev();
extern void _ZN6S634C53v28Ev();
extern void _ZN6S634C53v29Ev();
extern void _ZN6S634C53v30Ev();
extern void _ZN6S634C53v31Ev();
extern void _ZN6S634C53v32Ev();
extern void _ZN6S634C53v33Ev();
extern void _ZN6S634C53v34Ev();
extern void _ZN6S634C53v35Ev();
extern void _ZN6S634C53v36Ev();
extern void _ZN6S634C53v37Ev();
extern void _ZN6S634C53v38Ev();
extern void _ZN6S634C53v39Ev();
extern void _ZN6S634C53v40Ev();
extern void _ZN6S634C53v41Ev();
extern void _ZN6S634C53v42Ev();
extern void _ZN6S634C53v43Ev();
extern void _ZN6S634C53v44Ev();
extern void _ZN6S634C53v45Ev();
extern void _ZN6S634C53v46Ev();
extern void _ZN6S634C53v47Ev();
extern void _ZN6S634C53v48Ev();
extern void _ZN6S634C53v49Ev();
extern void _ZN6S634C53v50Ev();
extern void _ZN6S634C53v51Ev();
extern void _ZN6S634C53v52Ev();
extern void _ZN6S634C53v53Ev();
extern void _ZN6S634C53v54Ev();
extern void _ZN6S634C53v55Ev();
extern void _ZN6S634C53v56Ev();
extern void _ZN6S634C53v57Ev();
extern void _ZN6S634C53v58Ev();
extern void _ZN6S634C53v59Ev();
extern void _ZN6S634C53v60Ev();
extern void _ZN6S634C53v61Ev();
extern void _ZN6S634C53v62Ev();
extern void _ZN6S634C53v63Ev();
extern void _ZN6S634C53v64Ev();
extern void _ZN6S634C53v65Ev();
extern void _ZN6S634C53v66Ev();
extern void _ZN6S634C53v67Ev();
extern void _ZN6S634C53v68Ev();
extern void _ZN6S634C43v69Ev();
extern void _ZN6S634C43v70Ev();
extern void _ZN6S634C43v71Ev();
extern void _ZN6S634C43v72Ev();
extern void _ZN6S634C43v73Ev();
extern void _ZN6S634C43v74Ev();
extern void _ZN6S634C43v75Ev();
extern void _ZN6S634C43v76Ev();
extern void _ZN6S634C43v77Ev();
extern void _ZN6S634C43v78Ev();
extern void _ZN6S634C43v79Ev();
extern void _ZN6S634C43v80Ev();
extern void _ZN6S634C43v81Ev();
extern void _ZN6S634C43v82Ev();
extern void _ZN6S634C43v83Ev();
extern void _ZN6S634C43v84Ev();
extern void _ZN6S634C43v85Ev();
extern void _ZN6S634C43v86Ev();
extern void _ZN6S634C43v87Ev();
extern void _ZN6S634C43v88Ev();
extern void _ZN6S634C43v89Ev();
extern void _ZN6S634C43v90Ev();
extern void _ZN6S634C33v91Ev();
extern void _ZN6S634C33v92Ev();
extern void _ZN6S634C33v93Ev();
extern void _ZN6S634C33v94Ev();
extern void _ZN6S634C33v95Ev();
extern void _ZN6S634C33v96Ev();
extern void _ZN6S634C33v97Ev();
extern void _ZN6S634C33v98Ev();
extern void _ZN6S634C33v99Ev();
extern void _ZN6S634C34v100Ev();
extern void _ZN6S634C34v101Ev();
extern void _ZN6S634C34v102Ev();
extern void _ZN6S634C34v103Ev();
extern void _ZN6S634C34v104Ev();
extern void _ZN6S634C34v105Ev();
extern void _ZN6S634C34v106Ev();
extern void _ZN6S634C34v107Ev();
extern void _ZN6S634C34v108Ev();
extern void _ZN6S634C34v109Ev();
extern void _ZN6S634C34v110Ev();
extern void _ZN6S634C24v111Ev();
extern void _ZN6S634C24v112Ev();
extern void _ZN6S634C24v113Ev();
extern void _ZN6S634C24v114Ev();
static  VTBL_ENTRY vtc_S634C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S634C2[0]),
  (VTBL_ENTRY)&_ZN6S634C2D1Ev,
  (VTBL_ENTRY)&_ZN6S634C2D0Ev,
  (VTBL_ENTRY)&_ZN6S634C52v5Ev,
  (VTBL_ENTRY)&_ZN6S634C52v6Ev,
  (VTBL_ENTRY)&_ZN6S634C52v7Ev,
  (VTBL_ENTRY)&_ZN6S634C52v8Ev,
  (VTBL_ENTRY)&_ZN6S634C52v9Ev,
  (VTBL_ENTRY)&_ZN6S634C53v10Ev,
  (VTBL_ENTRY)&_ZN6S634C53v11Ev,
  (VTBL_ENTRY)&_ZN6S634C53v12Ev,
  (VTBL_ENTRY)&_ZN6S634C53v13Ev,
  (VTBL_ENTRY)&_ZN6S634C53v14Ev,
  (VTBL_ENTRY)&_ZN6S634C53v15Ev,
  (VTBL_ENTRY)&_ZN6S634C53v16Ev,
  (VTBL_ENTRY)&_ZN6S634C53v17Ev,
  (VTBL_ENTRY)&_ZN6S634C53v18Ev,
  (VTBL_ENTRY)&_ZN6S634C53v19Ev,
  (VTBL_ENTRY)&_ZN6S634C53v20Ev,
  (VTBL_ENTRY)&_ZN6S634C53v21Ev,
  (VTBL_ENTRY)&_ZN6S634C53v22Ev,
  (VTBL_ENTRY)&_ZN6S634C53v23Ev,
  (VTBL_ENTRY)&_ZN6S634C53v24Ev,
  (VTBL_ENTRY)&_ZN6S634C53v25Ev,
  (VTBL_ENTRY)&_ZN6S634C53v26Ev,
  (VTBL_ENTRY)&_ZN6S634C53v27Ev,
  (VTBL_ENTRY)&_ZN6S634C53v28Ev,
  (VTBL_ENTRY)&_ZN6S634C53v29Ev,
  (VTBL_ENTRY)&_ZN6S634C53v30Ev,
  (VTBL_ENTRY)&_ZN6S634C53v31Ev,
  (VTBL_ENTRY)&_ZN6S634C53v32Ev,
  (VTBL_ENTRY)&_ZN6S634C53v33Ev,
  (VTBL_ENTRY)&_ZN6S634C53v34Ev,
  (VTBL_ENTRY)&_ZN6S634C53v35Ev,
  (VTBL_ENTRY)&_ZN6S634C53v36Ev,
  (VTBL_ENTRY)&_ZN6S634C53v37Ev,
  (VTBL_ENTRY)&_ZN6S634C53v38Ev,
  (VTBL_ENTRY)&_ZN6S634C53v39Ev,
  (VTBL_ENTRY)&_ZN6S634C53v40Ev,
  (VTBL_ENTRY)&_ZN6S634C53v41Ev,
  (VTBL_ENTRY)&_ZN6S634C53v42Ev,
  (VTBL_ENTRY)&_ZN6S634C53v43Ev,
  (VTBL_ENTRY)&_ZN6S634C53v44Ev,
  (VTBL_ENTRY)&_ZN6S634C53v45Ev,
  (VTBL_ENTRY)&_ZN6S634C53v46Ev,
  (VTBL_ENTRY)&_ZN6S634C53v47Ev,
  (VTBL_ENTRY)&_ZN6S634C53v48Ev,
  (VTBL_ENTRY)&_ZN6S634C53v49Ev,
  (VTBL_ENTRY)&_ZN6S634C53v50Ev,
  (VTBL_ENTRY)&_ZN6S634C53v51Ev,
  (VTBL_ENTRY)&_ZN6S634C53v52Ev,
  (VTBL_ENTRY)&_ZN6S634C53v53Ev,
  (VTBL_ENTRY)&_ZN6S634C53v54Ev,
  (VTBL_ENTRY)&_ZN6S634C53v55Ev,
  (VTBL_ENTRY)&_ZN6S634C53v56Ev,
  (VTBL_ENTRY)&_ZN6S634C53v57Ev,
  (VTBL_ENTRY)&_ZN6S634C53v58Ev,
  (VTBL_ENTRY)&_ZN6S634C53v59Ev,
  (VTBL_ENTRY)&_ZN6S634C53v60Ev,
  (VTBL_ENTRY)&_ZN6S634C53v61Ev,
  (VTBL_ENTRY)&_ZN6S634C53v62Ev,
  (VTBL_ENTRY)&_ZN6S634C53v63Ev,
  (VTBL_ENTRY)&_ZN6S634C53v64Ev,
  (VTBL_ENTRY)&_ZN6S634C53v65Ev,
  (VTBL_ENTRY)&_ZN6S634C53v66Ev,
  (VTBL_ENTRY)&_ZN6S634C53v67Ev,
  (VTBL_ENTRY)&_ZN6S634C53v68Ev,
  (VTBL_ENTRY)&_ZN6S634C43v69Ev,
  (VTBL_ENTRY)&_ZN6S634C43v70Ev,
  (VTBL_ENTRY)&_ZN6S634C43v71Ev,
  (VTBL_ENTRY)&_ZN6S634C43v72Ev,
  (VTBL_ENTRY)&_ZN6S634C43v73Ev,
  (VTBL_ENTRY)&_ZN6S634C43v74Ev,
  (VTBL_ENTRY)&_ZN6S634C43v75Ev,
  (VTBL_ENTRY)&_ZN6S634C43v76Ev,
  (VTBL_ENTRY)&_ZN6S634C43v77Ev,
  (VTBL_ENTRY)&_ZN6S634C43v78Ev,
  (VTBL_ENTRY)&_ZN6S634C43v79Ev,
  (VTBL_ENTRY)&_ZN6S634C43v80Ev,
  (VTBL_ENTRY)&_ZN6S634C43v81Ev,
  (VTBL_ENTRY)&_ZN6S634C43v82Ev,
  (VTBL_ENTRY)&_ZN6S634C43v83Ev,
  (VTBL_ENTRY)&_ZN6S634C43v84Ev,
  (VTBL_ENTRY)&_ZN6S634C43v85Ev,
  (VTBL_ENTRY)&_ZN6S634C43v86Ev,
  (VTBL_ENTRY)&_ZN6S634C43v87Ev,
  (VTBL_ENTRY)&_ZN6S634C43v88Ev,
  (VTBL_ENTRY)&_ZN6S634C43v89Ev,
  (VTBL_ENTRY)&_ZN6S634C43v90Ev,
  (VTBL_ENTRY)&_ZN6S634C33v91Ev,
  (VTBL_ENTRY)&_ZN6S634C33v92Ev,
  (VTBL_ENTRY)&_ZN6S634C33v93Ev,
  (VTBL_ENTRY)&_ZN6S634C33v94Ev,
  (VTBL_ENTRY)&_ZN6S634C33v95Ev,
  (VTBL_ENTRY)&_ZN6S634C33v96Ev,
  (VTBL_ENTRY)&_ZN6S634C33v97Ev,
  (VTBL_ENTRY)&_ZN6S634C33v98Ev,
  (VTBL_ENTRY)&_ZN6S634C33v99Ev,
  (VTBL_ENTRY)&_ZN6S634C34v100Ev,
  (VTBL_ENTRY)&_ZN6S634C34v101Ev,
  (VTBL_ENTRY)&_ZN6S634C34v102Ev,
  (VTBL_ENTRY)&_ZN6S634C34v103Ev,
  (VTBL_ENTRY)&_ZN6S634C34v104Ev,
  (VTBL_ENTRY)&_ZN6S634C34v105Ev,
  (VTBL_ENTRY)&_ZN6S634C34v106Ev,
  (VTBL_ENTRY)&_ZN6S634C34v107Ev,
  (VTBL_ENTRY)&_ZN6S634C34v108Ev,
  (VTBL_ENTRY)&_ZN6S634C34v109Ev,
  (VTBL_ENTRY)&_ZN6S634C34v110Ev,
  (VTBL_ENTRY)&_ZN6S634C24v111Ev,
  (VTBL_ENTRY)&_ZN6S634C24v112Ev,
  (VTBL_ENTRY)&_ZN6S634C24v113Ev,
  (VTBL_ENTRY)&_ZN6S634C24v114Ev,
};
extern VTBL_ENTRY _ZTI6S634C2[];
extern  VTBL_ENTRY _ZTV6S634C2[];
Class_Descriptor cd_S634C2 = {  "S634C2", // class name
  bases_S634C2, 3,
  &(vtc_S634C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S634C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S634C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S634C1  : S634C2 {
  unsigned int s634c1f0:1;
  unsigned int s634c1f1:1;
  virtual  ~S634C1(); // _ZN6S634C1D1Ev
  virtual void  v1(); // _ZN6S634C12v1Ev
  virtual void  v2(); // _ZN6S634C12v2Ev
  virtual void  v3(); // _ZN6S634C12v3Ev
  virtual void  v4(); // _ZN6S634C12v4Ev
  S634C1(); // tgen
};
//SIG(1 S634C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC8 FC16{ BC17{ BC10}} Fi[3]} vd v111 v112 v113 v114 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 Fi:1 Fi:1}


 S634C1 ::~S634C1(){ note_dtor("S634C1", this);}
void  S634C1 ::v1(){vfunc_called(this, "_ZN6S634C12v1Ev");}
void  S634C1 ::v2(){vfunc_called(this, "_ZN6S634C12v2Ev");}
void  S634C1 ::v3(){vfunc_called(this, "_ZN6S634C12v3Ev");}
void  S634C1 ::v4(){vfunc_called(this, "_ZN6S634C12v4Ev");}
S634C1 ::S634C1(){ note_ctor("S634C1", this);} // tgen

static void Test_S634C1()
{
  extern Class_Descriptor cd_S634C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,57)];
    init_test(&cd_S634C1, buf);
    S634C1 *dp, &lv = *(dp=new (buf) S634C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,224), "sizeof(S634C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S634C1)");
    check_base_class_offset(lv, (S634C5*)(S634C4*)(S634C3*)(S634C2*), 0, "S634C1");
    check_base_class_offset(lv, (S634C4*)(S634C3*)(S634C2*), 0, "S634C1");
    check_base_class_offset(lv, (S634C3*)(S634C2*), 0, "S634C1");
    check_base_class_offset(lv, (S634C2*), 0, "S634C1");
    set_bf_and_test(lv, s634c1f0, ABISELECT(296,220), 0, 1, 1, "S634C1");
    set_bf_and_test(lv, s634c1f1, ABISELECT(296,220), 1, 1, 1, "S634C1");
    test_class_info(&lv, &cd_S634C1);
    dp->~S634C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS634C1(Test_S634C1, "S634C1", ABISELECT(304,224));

#else // __cplusplus

extern void _ZN6S634C1C1Ev();
extern void _ZN6S634C1D1Ev();
Name_Map name_map_S634C1[] = {
  NSPAIR(_ZN6S634C1C1Ev),
  NSPAIR(_ZN6S634C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S634C5;
extern VTBL_ENTRY _ZTI6S634C5[];
extern  VTBL_ENTRY _ZTV6S634C5[];
extern Class_Descriptor cd_S634C4;
extern VTBL_ENTRY _ZTI6S634C4[];
extern  VTBL_ENTRY _ZTV6S634C4[];
extern Class_Descriptor cd_S634C3;
extern VTBL_ENTRY _ZTI6S634C3[];
extern  VTBL_ENTRY _ZTV6S634C3[];
extern Class_Descriptor cd_S634C2;
extern VTBL_ENTRY _ZTI6S634C2[];
extern  VTBL_ENTRY _ZTV6S634C2[];
static Base_Class bases_S634C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S634C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S634C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S634C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S634C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S634C1[];
extern void _ZN6S634C1D1Ev();
extern void _ZN6S634C1D0Ev();
extern void _ZN6S634C52v5Ev();
extern void _ZN6S634C52v6Ev();
extern void _ZN6S634C52v7Ev();
extern void _ZN6S634C52v8Ev();
extern void _ZN6S634C52v9Ev();
extern void _ZN6S634C53v10Ev();
extern void _ZN6S634C53v11Ev();
extern void _ZN6S634C53v12Ev();
extern void _ZN6S634C53v13Ev();
extern void _ZN6S634C53v14Ev();
extern void _ZN6S634C53v15Ev();
extern void _ZN6S634C53v16Ev();
extern void _ZN6S634C53v17Ev();
extern void _ZN6S634C53v18Ev();
extern void _ZN6S634C53v19Ev();
extern void _ZN6S634C53v20Ev();
extern void _ZN6S634C53v21Ev();
extern void _ZN6S634C53v22Ev();
extern void _ZN6S634C53v23Ev();
extern void _ZN6S634C53v24Ev();
extern void _ZN6S634C53v25Ev();
extern void _ZN6S634C53v26Ev();
extern void _ZN6S634C53v27Ev();
extern void _ZN6S634C53v28Ev();
extern void _ZN6S634C53v29Ev();
extern void _ZN6S634C53v30Ev();
extern void _ZN6S634C53v31Ev();
extern void _ZN6S634C53v32Ev();
extern void _ZN6S634C53v33Ev();
extern void _ZN6S634C53v34Ev();
extern void _ZN6S634C53v35Ev();
extern void _ZN6S634C53v36Ev();
extern void _ZN6S634C53v37Ev();
extern void _ZN6S634C53v38Ev();
extern void _ZN6S634C53v39Ev();
extern void _ZN6S634C53v40Ev();
extern void _ZN6S634C53v41Ev();
extern void _ZN6S634C53v42Ev();
extern void _ZN6S634C53v43Ev();
extern void _ZN6S634C53v44Ev();
extern void _ZN6S634C53v45Ev();
extern void _ZN6S634C53v46Ev();
extern void _ZN6S634C53v47Ev();
extern void _ZN6S634C53v48Ev();
extern void _ZN6S634C53v49Ev();
extern void _ZN6S634C53v50Ev();
extern void _ZN6S634C53v51Ev();
extern void _ZN6S634C53v52Ev();
extern void _ZN6S634C53v53Ev();
extern void _ZN6S634C53v54Ev();
extern void _ZN6S634C53v55Ev();
extern void _ZN6S634C53v56Ev();
extern void _ZN6S634C53v57Ev();
extern void _ZN6S634C53v58Ev();
extern void _ZN6S634C53v59Ev();
extern void _ZN6S634C53v60Ev();
extern void _ZN6S634C53v61Ev();
extern void _ZN6S634C53v62Ev();
extern void _ZN6S634C53v63Ev();
extern void _ZN6S634C53v64Ev();
extern void _ZN6S634C53v65Ev();
extern void _ZN6S634C53v66Ev();
extern void _ZN6S634C53v67Ev();
extern void _ZN6S634C53v68Ev();
extern void _ZN6S634C43v69Ev();
extern void _ZN6S634C43v70Ev();
extern void _ZN6S634C43v71Ev();
extern void _ZN6S634C43v72Ev();
extern void _ZN6S634C43v73Ev();
extern void _ZN6S634C43v74Ev();
extern void _ZN6S634C43v75Ev();
extern void _ZN6S634C43v76Ev();
extern void _ZN6S634C43v77Ev();
extern void _ZN6S634C43v78Ev();
extern void _ZN6S634C43v79Ev();
extern void _ZN6S634C43v80Ev();
extern void _ZN6S634C43v81Ev();
extern void _ZN6S634C43v82Ev();
extern void _ZN6S634C43v83Ev();
extern void _ZN6S634C43v84Ev();
extern void _ZN6S634C43v85Ev();
extern void _ZN6S634C43v86Ev();
extern void _ZN6S634C43v87Ev();
extern void _ZN6S634C43v88Ev();
extern void _ZN6S634C43v89Ev();
extern void _ZN6S634C43v90Ev();
extern void _ZN6S634C33v91Ev();
extern void _ZN6S634C33v92Ev();
extern void _ZN6S634C33v93Ev();
extern void _ZN6S634C33v94Ev();
extern void _ZN6S634C33v95Ev();
extern void _ZN6S634C33v96Ev();
extern void _ZN6S634C33v97Ev();
extern void _ZN6S634C33v98Ev();
extern void _ZN6S634C33v99Ev();
extern void _ZN6S634C34v100Ev();
extern void _ZN6S634C34v101Ev();
extern void _ZN6S634C34v102Ev();
extern void _ZN6S634C34v103Ev();
extern void _ZN6S634C34v104Ev();
extern void _ZN6S634C34v105Ev();
extern void _ZN6S634C34v106Ev();
extern void _ZN6S634C34v107Ev();
extern void _ZN6S634C34v108Ev();
extern void _ZN6S634C34v109Ev();
extern void _ZN6S634C34v110Ev();
extern void _ZN6S634C24v111Ev();
extern void _ZN6S634C24v112Ev();
extern void _ZN6S634C24v113Ev();
extern void _ZN6S634C24v114Ev();
extern void _ZN6S634C12v1Ev();
extern void _ZN6S634C12v2Ev();
extern void _ZN6S634C12v3Ev();
extern void _ZN6S634C12v4Ev();
static  VTBL_ENTRY vtc_S634C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S634C1[0]),
  (VTBL_ENTRY)&_ZN6S634C1D1Ev,
  (VTBL_ENTRY)&_ZN6S634C1D0Ev,
  (VTBL_ENTRY)&_ZN6S634C52v5Ev,
  (VTBL_ENTRY)&_ZN6S634C52v6Ev,
  (VTBL_ENTRY)&_ZN6S634C52v7Ev,
  (VTBL_ENTRY)&_ZN6S634C52v8Ev,
  (VTBL_ENTRY)&_ZN6S634C52v9Ev,
  (VTBL_ENTRY)&_ZN6S634C53v10Ev,
  (VTBL_ENTRY)&_ZN6S634C53v11Ev,
  (VTBL_ENTRY)&_ZN6S634C53v12Ev,
  (VTBL_ENTRY)&_ZN6S634C53v13Ev,
  (VTBL_ENTRY)&_ZN6S634C53v14Ev,
  (VTBL_ENTRY)&_ZN6S634C53v15Ev,
  (VTBL_ENTRY)&_ZN6S634C53v16Ev,
  (VTBL_ENTRY)&_ZN6S634C53v17Ev,
  (VTBL_ENTRY)&_ZN6S634C53v18Ev,
  (VTBL_ENTRY)&_ZN6S634C53v19Ev,
  (VTBL_ENTRY)&_ZN6S634C53v20Ev,
  (VTBL_ENTRY)&_ZN6S634C53v21Ev,
  (VTBL_ENTRY)&_ZN6S634C53v22Ev,
  (VTBL_ENTRY)&_ZN6S634C53v23Ev,
  (VTBL_ENTRY)&_ZN6S634C53v24Ev,
  (VTBL_ENTRY)&_ZN6S634C53v25Ev,
  (VTBL_ENTRY)&_ZN6S634C53v26Ev,
  (VTBL_ENTRY)&_ZN6S634C53v27Ev,
  (VTBL_ENTRY)&_ZN6S634C53v28Ev,
  (VTBL_ENTRY)&_ZN6S634C53v29Ev,
  (VTBL_ENTRY)&_ZN6S634C53v30Ev,
  (VTBL_ENTRY)&_ZN6S634C53v31Ev,
  (VTBL_ENTRY)&_ZN6S634C53v32Ev,
  (VTBL_ENTRY)&_ZN6S634C53v33Ev,
  (VTBL_ENTRY)&_ZN6S634C53v34Ev,
  (VTBL_ENTRY)&_ZN6S634C53v35Ev,
  (VTBL_ENTRY)&_ZN6S634C53v36Ev,
  (VTBL_ENTRY)&_ZN6S634C53v37Ev,
  (VTBL_ENTRY)&_ZN6S634C53v38Ev,
  (VTBL_ENTRY)&_ZN6S634C53v39Ev,
  (VTBL_ENTRY)&_ZN6S634C53v40Ev,
  (VTBL_ENTRY)&_ZN6S634C53v41Ev,
  (VTBL_ENTRY)&_ZN6S634C53v42Ev,
  (VTBL_ENTRY)&_ZN6S634C53v43Ev,
  (VTBL_ENTRY)&_ZN6S634C53v44Ev,
  (VTBL_ENTRY)&_ZN6S634C53v45Ev,
  (VTBL_ENTRY)&_ZN6S634C53v46Ev,
  (VTBL_ENTRY)&_ZN6S634C53v47Ev,
  (VTBL_ENTRY)&_ZN6S634C53v48Ev,
  (VTBL_ENTRY)&_ZN6S634C53v49Ev,
  (VTBL_ENTRY)&_ZN6S634C53v50Ev,
  (VTBL_ENTRY)&_ZN6S634C53v51Ev,
  (VTBL_ENTRY)&_ZN6S634C53v52Ev,
  (VTBL_ENTRY)&_ZN6S634C53v53Ev,
  (VTBL_ENTRY)&_ZN6S634C53v54Ev,
  (VTBL_ENTRY)&_ZN6S634C53v55Ev,
  (VTBL_ENTRY)&_ZN6S634C53v56Ev,
  (VTBL_ENTRY)&_ZN6S634C53v57Ev,
  (VTBL_ENTRY)&_ZN6S634C53v58Ev,
  (VTBL_ENTRY)&_ZN6S634C53v59Ev,
  (VTBL_ENTRY)&_ZN6S634C53v60Ev,
  (VTBL_ENTRY)&_ZN6S634C53v61Ev,
  (VTBL_ENTRY)&_ZN6S634C53v62Ev,
  (VTBL_ENTRY)&_ZN6S634C53v63Ev,
  (VTBL_ENTRY)&_ZN6S634C53v64Ev,
  (VTBL_ENTRY)&_ZN6S634C53v65Ev,
  (VTBL_ENTRY)&_ZN6S634C53v66Ev,
  (VTBL_ENTRY)&_ZN6S634C53v67Ev,
  (VTBL_ENTRY)&_ZN6S634C53v68Ev,
  (VTBL_ENTRY)&_ZN6S634C43v69Ev,
  (VTBL_ENTRY)&_ZN6S634C43v70Ev,
  (VTBL_ENTRY)&_ZN6S634C43v71Ev,
  (VTBL_ENTRY)&_ZN6S634C43v72Ev,
  (VTBL_ENTRY)&_ZN6S634C43v73Ev,
  (VTBL_ENTRY)&_ZN6S634C43v74Ev,
  (VTBL_ENTRY)&_ZN6S634C43v75Ev,
  (VTBL_ENTRY)&_ZN6S634C43v76Ev,
  (VTBL_ENTRY)&_ZN6S634C43v77Ev,
  (VTBL_ENTRY)&_ZN6S634C43v78Ev,
  (VTBL_ENTRY)&_ZN6S634C43v79Ev,
  (VTBL_ENTRY)&_ZN6S634C43v80Ev,
  (VTBL_ENTRY)&_ZN6S634C43v81Ev,
  (VTBL_ENTRY)&_ZN6S634C43v82Ev,
  (VTBL_ENTRY)&_ZN6S634C43v83Ev,
  (VTBL_ENTRY)&_ZN6S634C43v84Ev,
  (VTBL_ENTRY)&_ZN6S634C43v85Ev,
  (VTBL_ENTRY)&_ZN6S634C43v86Ev,
  (VTBL_ENTRY)&_ZN6S634C43v87Ev,
  (VTBL_ENTRY)&_ZN6S634C43v88Ev,
  (VTBL_ENTRY)&_ZN6S634C43v89Ev,
  (VTBL_ENTRY)&_ZN6S634C43v90Ev,
  (VTBL_ENTRY)&_ZN6S634C33v91Ev,
  (VTBL_ENTRY)&_ZN6S634C33v92Ev,
  (VTBL_ENTRY)&_ZN6S634C33v93Ev,
  (VTBL_ENTRY)&_ZN6S634C33v94Ev,
  (VTBL_ENTRY)&_ZN6S634C33v95Ev,
  (VTBL_ENTRY)&_ZN6S634C33v96Ev,
  (VTBL_ENTRY)&_ZN6S634C33v97Ev,
  (VTBL_ENTRY)&_ZN6S634C33v98Ev,
  (VTBL_ENTRY)&_ZN6S634C33v99Ev,
  (VTBL_ENTRY)&_ZN6S634C34v100Ev,
  (VTBL_ENTRY)&_ZN6S634C34v101Ev,
  (VTBL_ENTRY)&_ZN6S634C34v102Ev,
  (VTBL_ENTRY)&_ZN6S634C34v103Ev,
  (VTBL_ENTRY)&_ZN6S634C34v104Ev,
  (VTBL_ENTRY)&_ZN6S634C34v105Ev,
  (VTBL_ENTRY)&_ZN6S634C34v106Ev,
  (VTBL_ENTRY)&_ZN6S634C34v107Ev,
  (VTBL_ENTRY)&_ZN6S634C34v108Ev,
  (VTBL_ENTRY)&_ZN6S634C34v109Ev,
  (VTBL_ENTRY)&_ZN6S634C34v110Ev,
  (VTBL_ENTRY)&_ZN6S634C24v111Ev,
  (VTBL_ENTRY)&_ZN6S634C24v112Ev,
  (VTBL_ENTRY)&_ZN6S634C24v113Ev,
  (VTBL_ENTRY)&_ZN6S634C24v114Ev,
  (VTBL_ENTRY)&_ZN6S634C12v1Ev,
  (VTBL_ENTRY)&_ZN6S634C12v2Ev,
  (VTBL_ENTRY)&_ZN6S634C12v3Ev,
  (VTBL_ENTRY)&_ZN6S634C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S634C1[];
extern  VTBL_ENTRY _ZTV6S634C1[];
Class_Descriptor cd_S634C1 = {  "S634C1", // class name
  bases_S634C1, 4,
  &(vtc_S634C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,224), // object size
  NSPAIRA(_ZTI6S634C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S634C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C4  {
  long s19012c4f0;
  __tsi64 s19012c4f1;
  void *s19012c4f2[3];
  void  mf19012c4(); // _ZN8S19012C49mf19012c4Ev
};
//SIG(-1 S19012C4) C1{ m Fl FL Fp[3]}


void  S19012C4 ::mf19012c4(){}

static void Test_S19012C4()
{
  {
    init_simple_test("S19012C4");
    S19012C4 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S19012C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19012C4)");
    check_field_offset(lv, s19012c4f0, 0, "S19012C4.s19012c4f0");
    check_field_offset(lv, s19012c4f1, ABISELECT(8,4), "S19012C4.s19012c4f1");
    check_field_offset(lv, s19012c4f2, ABISELECT(16,12), "S19012C4.s19012c4f2");
  }
}
static Arrange_To_Call_Me vS19012C4(Test_S19012C4, "S19012C4", ABISELECT(40,24));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S19012C4[];
VTBL_ENTRY *P__ZTI8S19012C4 = _ZTI8S19012C4; 
Class_Descriptor cd_S19012C4 = {  "S19012C4", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S19012C4),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C3  : S19012C4 {
  ::S19012C4 s19012c3f0;
  ::S19012C4 s19012c3f1;
  ::S19012C4 s19012c3f2[3];
  void *s19012c3f3;
  virtual  ~S19012C3(); // _ZN8S19012C3D1Ev
  virtual void  v1(); // _ZN8S19012C32v1Ev
  virtual void  v2(); // _ZN8S19012C32v2Ev
  virtual void  v3(); // _ZN8S19012C32v3Ev
  S19012C3(); // tgen
};
//SIG(-1 S19012C3) C1{ BC2{ m Fl FL Fp[3]} vd v1 v2 v3 FC2 FC2 FC2[3] Fp}


 S19012C3 ::~S19012C3(){ note_dtor("S19012C3", this);}
void  S19012C3 ::v1(){vfunc_called(this, "_ZN8S19012C32v1Ev");}
void  S19012C3 ::v2(){vfunc_called(this, "_ZN8S19012C32v2Ev");}
void  S19012C3 ::v3(){vfunc_called(this, "_ZN8S19012C32v3Ev");}
S19012C3 ::S19012C3(){ note_ctor("S19012C3", this);} // tgen

static void Test_S19012C3()
{
  extern Class_Descriptor cd_S19012C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,39)];
    init_test(&cd_S19012C3, buf);
    S19012C3 *dp, &lv = *(dp=new (buf) S19012C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,152), "sizeof(S19012C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19012C3)");
    check_base_class_offset(lv, (S19012C4*), ABISELECT(8,4), "S19012C3");
    check_field_offset(lv, s19012c3f0, ABISELECT(48,28), "S19012C3.s19012c3f0");
    check_field_offset(lv, s19012c3f1, ABISELECT(88,52), "S19012C3.s19012c3f1");
    check_field_offset(lv, s19012c3f2, ABISELECT(128,76), "S19012C3.s19012c3f2");
    check_field_offset(lv, s19012c3f3, ABISELECT(248,148), "S19012C3.s19012c3f3");
    test_class_info(&lv, &cd_S19012C3);
    dp->~S19012C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C3(Test_S19012C3, "S19012C3", ABISELECT(256,152));

#else // __cplusplus

extern void _ZN8S19012C3C1Ev();
extern void _ZN8S19012C3D1Ev();
Name_Map name_map_S19012C3[] = {
  NSPAIR(_ZN8S19012C3C1Ev),
  NSPAIR(_ZN8S19012C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19012C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C3[];
extern void _ZN8S19012C3D1Ev();
extern void _ZN8S19012C3D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C3[0]),
  (VTBL_ENTRY)&_ZN8S19012C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
Class_Descriptor cd_S19012C3 = {  "S19012C3", // class name
  bases_S19012C3, 1,
  &(vtc_S19012C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,152), // object size
  NSPAIRA(_ZTI8S19012C3),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19012C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19012C5_nt  {
  void  mf19012c5(); // _ZN11S19012C5_nt9mf19012c5Ev
};
//SIG(1 S19012C5_nt) U1{ m}

#endif // __cplusplus
#ifdef __cplusplus

union  S19012C6  {
  int s19012c6f0;
  __tsi64 s19012c6f1;
  long double s19012c6f2[7];
  void *s19012c6f3;
  void *s19012c6f4;
  long double s19012c6f5;
  void *s19012c6f6;
  __tsi64 s19012c6f7[7];
  char s19012c6f8;
  void  mf19012c6(); // _ZN8S19012C69mf19012c6Ev
};
//SIG(1 S19012C6) U1{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19012C2  : S19012C3 {
  ::S19012C4 s19012c2f0;
  int s19012c2f1;
  ::S19012C4 s19012c2f2;
  void *s19012c2f3;
  ::S19012C5_nt s19012c2f4;
  ::S19012C6 s19012c2f5;
  ::S19012C6 s19012c2f6;
  ~S19012C2(); // tgen
  S19012C2(); // tgen
};
//SIG(-1 S19012C2) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v1 v2 v3 FC3 FC3 FC3[3] Fp} FC3 Fi FC3 Fp FU4{ m} FU5{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU5}


S19012C2 ::~S19012C2(){ note_dtor("S19012C2", this);} // tgen
S19012C2 ::S19012C2(){ note_ctor("S19012C2", this);} // tgen

static void Test_S19012C2()
{
  extern Class_Descriptor cd_S19012C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(38,96)];
    init_test(&cd_S19012C2, buf);
    S19012C2 *dp, &lv = *(dp=new (buf) S19012C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(592,380), "sizeof(S19012C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C2)");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(8,4), "S19012C2");
    check_base_class_offset(lv, (S19012C3*), 0, "S19012C2");
    check_field_offset(lv, s19012c2f0, ABISELECT(256,152), "S19012C2.s19012c2f0");
    check_field_offset(lv, s19012c2f1, ABISELECT(296,176), "S19012C2.s19012c2f1");
    check_field_offset(lv, s19012c2f2, ABISELECT(304,180), "S19012C2.s19012c2f2");
    check_field_offset(lv, s19012c2f3, ABISELECT(344,204), "S19012C2.s19012c2f3");
    check_field_offset(lv, s19012c2f4, ABISELECT(352,208), "S19012C2.s19012c2f4");
    check_field_offset(lv, s19012c2f5, ABISELECT(368,212), "S19012C2.s19012c2f5");
    check_field_offset(lv, s19012c2f6, ABISELECT(480,296), "S19012C2.s19012c2f6");
    test_class_info(&lv, &cd_S19012C2);
    dp->~S19012C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C2(Test_S19012C2, "S19012C2", ABISELECT(592,380));

#else // __cplusplus

extern void _ZN8S19012C2C1Ev();
extern void _ZN8S19012C2D1Ev();
Name_Map name_map_S19012C2[] = {
  NSPAIR(_ZN8S19012C2C1Ev),
  NSPAIR(_ZN8S19012C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
static Base_Class bases_S19012C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C2[];
extern void _ZN8S19012C2D1Ev();
extern void _ZN8S19012C2D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C2[0]),
  (VTBL_ENTRY)&_ZN8S19012C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
Class_Descriptor cd_S19012C2 = {  "S19012C2", // class name
  bases_S19012C2, 2,
  &(vtc_S19012C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(592,380), // object size
  NSPAIRA(_ZTI8S19012C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19012C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C11_nt  {
};
//SIG(-1 S19012C11_nt) C1{}



//skip512 S19012C11_nt

#else // __cplusplus

Class_Descriptor cd_S19012C11_nt = {  "S19012C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C10  : S19012C3 , virtual S19012C4 {
  short s19012c10f0;
  long double s19012c10f1;
  void *s19012c10f2[2];
  __tsi64 s19012c10f3;
  ::S19012C4 s19012c10f4;
  void *s19012c10f5[6];
  int s19012c10f6;
  void *s19012c10f7;
  ::S19012C11_nt s19012c10f8[10];
  ::S19012C11_nt s19012c10f9[4];
  int s19012c10f10;
  virtual  ~S19012C10(); // _ZN9S19012C10D2Ev
  S19012C10(); // tgen
};
//SIG(-1 S19012C10) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v1 v2 v3 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC4{}[10] FC4[4] Fi}


 S19012C10 ::~S19012C10(){ note_dtor("S19012C10", this);}
S19012C10 ::S19012C10(){ note_ctor("S19012C10", this);} // tgen

static void Test_S19012C10()
{
  extern Class_Descriptor cd_S19012C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(31,72)];
    init_test(&cd_S19012C10, buf);
    S19012C10 *dp, &lv = *(dp=new (buf) S19012C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,284), "sizeof(S19012C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C10)");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(8,4), "S19012C10");
    check_base_class_offset(lv, (S19012C3*), 0, "S19012C10");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(440,260), "S19012C10");
    check_field_offset(lv, s19012c10f0, ABISELECT(256,152), "S19012C10.s19012c10f0");
    check_field_offset(lv, s19012c10f1, ABISELECT(272,156), "S19012C10.s19012c10f1");
    check_field_offset(lv, s19012c10f2, ABISELECT(288,168), "S19012C10.s19012c10f2");
    check_field_offset(lv, s19012c10f3, ABISELECT(304,176), "S19012C10.s19012c10f3");
    check_field_offset(lv, s19012c10f4, ABISELECT(312,184), "S19012C10.s19012c10f4");
    check_field_offset(lv, s19012c10f5, ABISELECT(352,208), "S19012C10.s19012c10f5");
    check_field_offset(lv, s19012c10f6, ABISELECT(400,232), "S19012C10.s19012c10f6");
    check_field_offset(lv, s19012c10f7, ABISELECT(408,236), "S19012C10.s19012c10f7");
    check_field_offset(lv, s19012c10f8, ABISELECT(416,240), "S19012C10.s19012c10f8");
    check_field_offset(lv, s19012c10f9, ABISELECT(426,250), "S19012C10.s19012c10f9");
    check_field_offset(lv, s19012c10f10, ABISELECT(432,256), "S19012C10.s19012c10f10");
    test_class_info(&lv, &cd_S19012C10);
    dp->~S19012C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C10(Test_S19012C10, "S19012C10", ABISELECT(480,284));

#else // __cplusplus

extern void _ZN9S19012C10C1Ev();
extern void _ZN9S19012C10D2Ev();
Name_Map name_map_S19012C10[] = {
  NSPAIR(_ZN9S19012C10C1Ev),
  NSPAIR(_ZN9S19012C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19012C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(440,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C10[];
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C10[] = {
  ABISELECT(440,260),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C10[];
static  VTT_ENTRY vtt_S19012C10[] = {
  {&(_ZTV9S19012C10[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
Class_Descriptor cd_S19012C10 = {  "S19012C10", // class name
  bases_S19012C10, 3,
  &(vtc_S19012C10[0]), // expected_vtbl_contents
  &(vtt_S19012C10[0]), // expected_vtt_contents
  ABISELECT(480,284), // object size
  NSPAIRA(_ZTI9S19012C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19012C10),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C10),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C9  : virtual S19012C4 , S19012C10 , S19012C2 {
  long double s19012c9f0;
  char s19012c9f1[8];
  ::S19012C6 s19012c9f2;
  int s19012c9f3;
  int s19012c9f4;
  ::S19012C11_nt s19012c9f5;
  long double s19012c9f6;
  long double s19012c9f7;
  virtual  ~S19012C9(); // _ZN8S19012C9D2Ev
  virtual void  v4(); // _ZN8S19012C92v4Ev
  virtual void  v5(); // _ZN8S19012C92v5Ev
  S19012C9(); // tgen
};
//SIG(-1 S19012C9) C1{ VBC2{ m Fl FL Fp[3]} BC3{ BC4{ BC2 vd v3 v4 v5 FC2 FC2 FC2[3] Fp} VBC2 vd Fs FD Fp[2] FL FC2 Fp[6] Fi Fp FC5{}[10] FC5[4] Fi} BC6{ BC4 FC2 Fi FC2 Fp FU7{ m} FU8{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU8} vd v1 v2 FD Fc[8] FU8 Fi Fi FC5 FD FD}


 S19012C9 ::~S19012C9(){ note_dtor("S19012C9", this);}
void  S19012C9 ::v4(){vfunc_called(this, "_ZN8S19012C92v4Ev");}
void  S19012C9 ::v5(){vfunc_called(this, "_ZN8S19012C92v5Ev");}
S19012C9 ::S19012C9(){ note_ctor("S19012C9", this);} // tgen

static void Test_S19012C9()
{
  extern Class_Descriptor cd_S19012C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(81,202)];
    init_test(&cd_S19012C9, buf);
    S19012C9 *dp, &lv = *(dp=new (buf) S19012C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1280,804), "sizeof(S19012C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C9)");
    /*is_ambiguous_... S19012C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(1232,780), "S19012C9");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(1232,780), "S19012C9");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(8,4), "S19012C9");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*), 0, "S19012C9");
    check_base_class_offset(lv, (S19012C10*), 0, "S19012C9");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(456,264), "S19012C9");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(448,260), "S19012C9");
    check_base_class_offset(lv, (S19012C2*), ABISELECT(448,260), "S19012C9");
    check_field_offset(lv, s19012c9f0, ABISELECT(1040,640), "S19012C9.s19012c9f0");
    check_field_offset(lv, s19012c9f1, ABISELECT(1056,652), "S19012C9.s19012c9f1");
    check_field_offset(lv, s19012c9f2, ABISELECT(1072,660), "S19012C9.s19012c9f2");
    check_field_offset(lv, s19012c9f3, ABISELECT(1184,744), "S19012C9.s19012c9f3");
    check_field_offset(lv, s19012c9f4, ABISELECT(1188,748), "S19012C9.s19012c9f4");
    check_field_offset(lv, s19012c9f5, ABISELECT(1192,752), "S19012C9.s19012c9f5");
    check_field_offset(lv, s19012c9f6, ABISELECT(1200,756), "S19012C9.s19012c9f6");
    check_field_offset(lv, s19012c9f7, ABISELECT(1216,768), "S19012C9.s19012c9f7");
    test_class_info(&lv, &cd_S19012C9);
    dp->~S19012C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C9(Test_S19012C9, "S19012C9", ABISELECT(1280,804));

#else // __cplusplus

extern void _ZN8S19012C9C1Ev();
extern void _ZN8S19012C9D2Ev();
Name_Map name_map_S19012C9[] = {
  NSPAIR(_ZN8S19012C9C1Ev),
  NSPAIR(_ZN8S19012C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
static Base_Class bases_S19012C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(448,260), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C9[];
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void ABISELECT(_ZThn448_N8S19012C9D1Ev,_ZThn260_N8S19012C9D1Ev)();
extern void ABISELECT(_ZThn448_N8S19012C9D0Ev,_ZThn260_N8S19012C9D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C9[] = {
  ABISELECT(1232,780),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C9D1Ev,_ZThn260_N8S19012C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C9D0Ev,_ZThn260_N8S19012C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19012C9[];
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__8S19012C9[] = {
  ABISELECT(1232,780),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C9[] = {
  {&(_ZTV8S19012C9[3]),  3,17},
  {&(_tg__ZTV9S19012C10__8S19012C9[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
Class_Descriptor cd_S19012C9 = {  "S19012C9", // class name
  bases_S19012C9, 7,
  &(vtc_S19012C9[0]), // expected_vtbl_contents
  &(vtt_S19012C9[0]), // expected_vtt_contents
  ABISELECT(1280,804), // object size
  NSPAIRA(_ZTI8S19012C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19012C9),17, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19012C9),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C8  : virtual S19012C2 , virtual S19012C4 , S19012C9 , S19012C10 {
  ::S19012C5_nt s19012c8f0;
  char s19012c8f1;
  virtual  ~S19012C8(); // _ZN8S19012C8D2Ev
  virtual void  v6(); // _ZN8S19012C82v6Ev
  S19012C8(); // tgen
};
//SIG(-1 S19012C8) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v2 v3 v4 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC4 BC7{ VBC4 BC8{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC9{}[10] FC9[4] Fi} BC2 vd v5 v6 FD Fc[8] FU6 Fi Fi FC9 FD FD} BC8 vd v1 FU5 Fc}


 S19012C8 ::~S19012C8(){ note_dtor("S19012C8", this);}
void  S19012C8 ::v6(){vfunc_called(this, "_ZN8S19012C82v6Ev");}
S19012C8 ::S19012C8(){ note_ctor("S19012C8", this);} // tgen

static void Test_S19012C8()
{
  extern Class_Descriptor cd_S19012C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(146,363)];
    init_test(&cd_S19012C8, buf);
    S19012C8 *dp, &lv = *(dp=new (buf) S19012C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2320,1448), "sizeof(S19012C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C8)");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(1688,1048), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(1680,1044), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*), ABISELECT(1680,1044), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(2272,1424), "S19012C8");
    /*is_ambiguous_... S19012C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*), ABISELECT(2272,1424), "S19012C8");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*), ABISELECT(2272,1424), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(2272,1424), "S19012C8");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*), ABISELECT(8,4), "S19012C8");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*), 0, "S19012C8");
    check_base_class_offset(lv, (S19012C10*)(S19012C9*), 0, "S19012C8");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*), ABISELECT(456,264), "S19012C8");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*), ABISELECT(448,260), "S19012C8");
    check_base_class_offset(lv, (S19012C2*)(S19012C9*), ABISELECT(448,260), "S19012C8");
    check_base_class_offset(lv, (S19012C9*), 0, "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(1240,784), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*), ABISELECT(1232,780), "S19012C8");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C10*), ABISELECT(1232,780), "S19012C8");
    check_field_offset(lv, s19012c8f0, ABISELECT(1668,1040), "S19012C8.s19012c8f0");
    check_field_offset(lv, s19012c8f1, ABISELECT(1669,1041), "S19012C8.s19012c8f1");
    test_class_info(&lv, &cd_S19012C8);
    dp->~S19012C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C8(Test_S19012C8, "S19012C8", ABISELECT(2320,1448));

#else // __cplusplus

extern void _ZN8S19012C8C1Ev();
extern void _ZN8S19012C8D2Ev();
Name_Map name_map_S19012C8[] = {
  NSPAIR(_ZN8S19012C8C1Ev),
  NSPAIR(_ZN8S19012C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
static Base_Class bases_S19012C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(1688,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1680,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(1680,1044), //bcp->offset
    27, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(2272,1424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(448,260), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(1232,780), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C8[];
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZThn448_N8S19012C8D1Ev,_ZThn260_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S19012C8D0Ev,_ZThn260_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C8D1Ev,_ZThn1044_N8S19012C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C8D0Ev,_ZThn1044_N8S19012C8D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C8[] = {
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C8D1Ev,_ZThn260_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C8D0Ev,_ZThn260_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(1040,644),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1680,-1044),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19012C8[];
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C9__8S19012C8[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C9__8S19012C8[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8[] = {
  ABISELECT(1040,644),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C8[] = {
  {&(_ZTV8S19012C8[4]),  4,38},
  {&(_tg__ZTV8S19012C9__8S19012C8[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C9__8S19012C8[3]),  3,8},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8[3]),  3,8},
  {&(_ZTV8S19012C8[33]),  33,38},
  {&(_ZTV8S19012C8[22]),  22,38},
};
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19012C8D0Ev,_ZThn1044_N8S19012C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19012C8D1Ev,_ZThn1044_N8S19012C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C8 = {  "S19012C8", // class name
  bases_S19012C8, 14,
  &(vtc_S19012C8[0]), // expected_vtbl_contents
  &(vtt_S19012C8[0]), // expected_vtt_contents
  ABISELECT(2320,1448), // object size
  NSPAIRA(_ZTI8S19012C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19012C8),38, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19012C8),6, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C13  : S19012C4 {
  ::S19012C6 s19012c13f0;
  char s19012c13f1[5];
  long double s19012c13f2;
  virtual  ~S19012C13(); // _ZN9S19012C13D1Ev
  virtual void  v7(); // _ZN9S19012C132v7Ev
  S19012C13(); // tgen
};
//SIG(-1 S19012C13) C1{ BC2{ m Fl FL Fp[3]} vd v1 FU3{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD}


 S19012C13 ::~S19012C13(){ note_dtor("S19012C13", this);}
void  S19012C13 ::v7(){vfunc_called(this, "_ZN9S19012C132v7Ev");}
S19012C13 ::S19012C13(){ note_ctor("S19012C13", this);} // tgen

static void Test_S19012C13()
{
  extern Class_Descriptor cd_S19012C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,34)];
    init_test(&cd_S19012C13, buf);
    S19012C13 *dp, &lv = *(dp=new (buf) S19012C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S19012C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C13)");
    check_base_class_offset(lv, (S19012C4*), ABISELECT(8,4), "S19012C13");
    check_field_offset(lv, s19012c13f0, ABISELECT(48,28), "S19012C13.s19012c13f0");
    check_field_offset(lv, s19012c13f1, ABISELECT(160,112), "S19012C13.s19012c13f1");
    check_field_offset(lv, s19012c13f2, ABISELECT(176,120), "S19012C13.s19012c13f2");
    test_class_info(&lv, &cd_S19012C13);
    dp->~S19012C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C13(Test_S19012C13, "S19012C13", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN9S19012C13C1Ev();
extern void _ZN9S19012C13D1Ev();
Name_Map name_map_S19012C13[] = {
  NSPAIR(_ZN9S19012C13C1Ev),
  NSPAIR(_ZN9S19012C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19012C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C13[];
extern void _ZN9S19012C13D1Ev();
extern void _ZN9S19012C13D0Ev();
extern void _ZN9S19012C132v7Ev();
static  VTBL_ENTRY vtc_S19012C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C13[0]),
  (VTBL_ENTRY)&_ZN9S19012C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
};
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
Class_Descriptor cd_S19012C13 = {  "S19012C13", // class name
  bases_S19012C13, 1,
  &(vtc_S19012C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S19012C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19012C13),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C15  : virtual S19012C2 , virtual S19012C4 , S19012C10 , virtual S19012C3 , S19012C13 {
  int s19012c15f0;
  ::S19012C11_nt s19012c15f1;
  ::S19012C11_nt s19012c15f2;
  ::S19012C11_nt s19012c15f3;
  ::S19012C11_nt s19012c15f4;
  int s19012c15f5;
  virtual void  v10(); // _ZN9S19012C153v10Ev
  virtual void  v11(); // _ZN9S19012C153v11Ev
  ~S19012C15(); // tgen
  S19012C15(); // tgen
};
//SIG(-1 S19012C15) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v3 v4 v5 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC4 BC7{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC8{}[10] FC8[4] Fi} VBC3 BC9{ BC4 vd v6 FU6 Fc[5] FD} v1 v2 Fi FC8 FC8 FC8 FC8 Fi}


void  S19012C15 ::v10(){vfunc_called(this, "_ZN9S19012C153v10Ev");}
void  S19012C15 ::v11(){vfunc_called(this, "_ZN9S19012C153v11Ev");}
S19012C15 ::~S19012C15(){ note_dtor("S19012C15", this);} // tgen
S19012C15 ::S19012C15(){ note_ctor("S19012C15", this);} // tgen

static void Test_S19012C15()
{
  extern Class_Descriptor cd_S19012C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(98,241)];
    init_test(&cd_S19012C15, buf);
    S19012C15 *dp, &lv = *(dp=new (buf) S19012C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1552,960), "sizeof(S19012C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C15)");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(664,408), "S19012C15");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(656,404), "S19012C15");
    check_base_class_offset(lv, (S19012C2*), ABISELECT(656,404), "S19012C15");
    /*is_ambiguous_... S19012C15::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(1248,784), "S19012C15");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(1248,784), "S19012C15");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(8,4), "S19012C15");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*), 0, "S19012C15");
    check_base_class_offset(lv, (S19012C10*), 0, "S19012C15");
    /*is_ambiguous_... S19012C15::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(1296,812), "S19012C15");
    /*is_ambiguous_... S19012C15::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*), ABISELECT(1288,808), "S19012C15");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(456,264), "S19012C15");
    check_base_class_offset(lv, (S19012C13*), ABISELECT(448,260), "S19012C15");
    check_field_offset(lv, s19012c15f0, ABISELECT(640,392), "S19012C15.s19012c15f0");
    check_field_offset(lv, s19012c15f1, ABISELECT(644,396), "S19012C15.s19012c15f1");
    check_field_offset(lv, s19012c15f2, ABISELECT(645,397), "S19012C15.s19012c15f2");
    check_field_offset(lv, s19012c15f3, ABISELECT(646,398), "S19012C15.s19012c15f3");
    check_field_offset(lv, s19012c15f4, ABISELECT(647,399), "S19012C15.s19012c15f4");
    check_field_offset(lv, s19012c15f5, ABISELECT(648,400), "S19012C15.s19012c15f5");
    test_class_info(&lv, &cd_S19012C15);
    dp->~S19012C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C15(Test_S19012C15, "S19012C15", ABISELECT(1552,960));

#else // __cplusplus

extern void _ZN9S19012C15C1Ev();
extern void _ZN9S19012C15D1Ev();
Name_Map name_map_S19012C15[] = {
  NSPAIR(_ZN9S19012C15C1Ev),
  NSPAIR(_ZN9S19012C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
static Base_Class bases_S19012C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(664,408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(656,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(656,404), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(1248,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1296,812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1288,808), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(448,260), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C15[];
extern void _ZN9S19012C15D1Ev();
extern void _ZN9S19012C15D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN9S19012C153v10Ev();
extern void _ZN9S19012C153v11Ev();
extern void ABISELECT(_ZThn448_N9S19012C15D1Ev,_ZThn260_N9S19012C15D1Ev)();
extern void ABISELECT(_ZThn448_N9S19012C15D0Ev,_ZThn260_N9S19012C15D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev)();
extern void ABISELECT(_ZThn656_N9S19012C15D1Ev,_ZThn404_N9S19012C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev)();
extern void ABISELECT(_ZThn656_N9S19012C15D0Ev,_ZThn404_N9S19012C15D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev)();
extern void ABISELECT(_ZThn1288_N9S19012C15D1Ev,_ZThn808_N9S19012C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev)();
extern void ABISELECT(_ZThn1288_N9S19012C15D0Ev,_ZThn808_N9S19012C15D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C15[] = {
  ABISELECT(1288,808),
  ABISELECT(656,404),
  ABISELECT(1248,784),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&_ZN9S19012C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v11Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19012C15D1Ev,_ZThn260_N9S19012C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19012C15D0Ev,_ZThn260_N9S19012C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-656,-404),
  ABISELECT(-656,-404),
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1288,-808),
  ABISELECT(-1288,-808),
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C15[];
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__9S19012C15[] = {
  ABISELECT(1248,784),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C15[] = {
  {&(_ZTV9S19012C15[5]),  5,39},
  {&(_tg__ZTV9S19012C10__9S19012C15[3]),  3,8},
  {&(_ZTV9S19012C15[23]),  23,39},
  {&(_ZTV9S19012C15[34]),  34,39},
};
extern VTBL_ENTRY _ZTI9S19012C15[];
extern  VTBL_ENTRY _ZTV9S19012C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C15[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1288_N9S19012C15D0Ev,_ZThn808_N9S19012C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19012C15D0Ev,_ZThn404_N9S19012C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1288_N9S19012C15D1Ev,_ZThn808_N9S19012C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19012C15D1Ev,_ZThn404_N9S19012C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C15 = {  "S19012C15", // class name
  bases_S19012C15, 11,
  &(vtc_S19012C15[0]), // expected_vtbl_contents
  &(vtt_S19012C15[0]), // expected_vtt_contents
  ABISELECT(1552,960), // object size
  NSPAIRA(_ZTI9S19012C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19012C15),39, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C15),4, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C14  : S19012C13 , virtual S19012C2 , S19012C15 , S19012C4 {
  int s19012c14f0;
  int s19012c14f1;
  int s19012c14f2;
  char s19012c14f3:6;
  ::S19012C6 s19012c14f4;
  long s19012c14f5;
  long s19012c14f6;
  char s19012c14f7;
  __tsi64 s19012c14f8;
  ::S19012C11_nt s19012c14f9;
  virtual void  v9(); // _ZN9S19012C142v9Ev
  ~S19012C14(); // tgen
  S19012C14(); // tgen
};
//SIG(-1 S19012C14) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v2 FU4{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD} VBC5{ BC6{ BC3 vd v3 v4 v5 FC3 FC3 FC3[3] Fp} FC3 Fi FC3 Fp FU7{ m} FU4 FU4} BC8{ VBC5 VBC3 BC9{ BC6 VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} VBC6 BC2 v6 v7 Fi FC10 FC10 FC10 FC10 Fi} BC3 v1 Fi Fi Fi Fc:6 FU4 Fl Fl Fc FL FC10}


void  S19012C14 ::v9(){vfunc_called(this, "_ZN9S19012C142v9Ev");}
S19012C14 ::~S19012C14(){ note_dtor("S19012C14", this);} // tgen
S19012C14 ::S19012C14(){ note_ctor("S19012C14", this);} // tgen

static void Test_S19012C14()
{
  extern Class_Descriptor cd_S19012C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(124,311)];
    init_test(&cd_S19012C14, buf);
    S19012C14 *dp, &lv = *(dp=new (buf) S19012C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1968,1240), "sizeof(S19012C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C14)");
    /*is_ambiguous_... S19012C14::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(8,4), "S19012C14");
    /*is_ambiguous_... S19012C14::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C13*), 0, "S19012C14");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(1080,688), "S19012C14");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(1072,684), "S19012C14");
    check_base_class_offset(lv, (S19012C2*), ABISELECT(1072,684), "S19012C14");
    check_base_class_offset(lv, (S19012C2*)(S19012C15*), ABISELECT(1072,684), "S19012C14");
    /*is_ambiguous_... S19012C15::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C15*), ABISELECT(1664,1064), "S19012C14");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C15*), ABISELECT(1664,1064), "S19012C14");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C15*), ABISELECT(200,136), "S19012C14");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C15*), ABISELECT(192,132), "S19012C14");
    check_base_class_offset(lv, (S19012C10*)(S19012C15*), ABISELECT(192,132), "S19012C14");
    /*is_ambiguous_... S19012C14::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(1712,1092), "S19012C14");
    /*is_ambiguous_... S19012C15::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C15*), ABISELECT(1704,1088), "S19012C14");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*)(S19012C15*), ABISELECT(648,396), "S19012C14");
    check_base_class_offset(lv, (S19012C13*)(S19012C15*), ABISELECT(640,392), "S19012C14");
    check_base_class_offset(lv, (S19012C15*), ABISELECT(192,132), "S19012C14");
    /*is_ambiguous_... S19012C14::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(848,536), "S19012C14");
    check_field_offset(lv, s19012c14f0, ABISELECT(888,560), "S19012C14.s19012c14f0");
    check_field_offset(lv, s19012c14f1, ABISELECT(892,564), "S19012C14.s19012c14f1");
    check_field_offset(lv, s19012c14f2, ABISELECT(896,568), "S19012C14.s19012c14f2");
    set_bf_and_test(lv, s19012c14f3, ABISELECT(900,572), 0, 6, 1, "S19012C14");
    set_bf_and_test(lv, s19012c14f3, ABISELECT(900,572), 0, 6, hide_sll(1LL<<5), "S19012C14");
    check_field_offset(lv, s19012c14f4, ABISELECT(912,576), "S19012C14.s19012c14f4");
    check_field_offset(lv, s19012c14f5, ABISELECT(1024,660), "S19012C14.s19012c14f5");
    check_field_offset(lv, s19012c14f6, ABISELECT(1032,664), "S19012C14.s19012c14f6");
    check_field_offset(lv, s19012c14f7, ABISELECT(1040,668), "S19012C14.s19012c14f7");
    check_field_offset(lv, s19012c14f8, ABISELECT(1048,672), "S19012C14.s19012c14f8");
    check_field_offset(lv, s19012c14f9, ABISELECT(1056,680), "S19012C14.s19012c14f9");
    test_class_info(&lv, &cd_S19012C14);
    dp->~S19012C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C14(Test_S19012C14, "S19012C14", ABISELECT(1968,1240));

#else // __cplusplus

extern void _ZN9S19012C14C1Ev();
extern void _ZN9S19012C14D1Ev();
Name_Map name_map_S19012C14[] = {
  NSPAIR(_ZN9S19012C14C1Ev),
  NSPAIR(_ZN9S19012C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C15;
extern VTBL_ENTRY _ZTI9S19012C15[];
extern  VTBL_ENTRY _ZTV9S19012C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C15[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19012C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1080,688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1072,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(1072,684), //bcp->offset
    26, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(1664,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(200,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(192,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(192,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1712,1092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1704,1088), //bcp->offset
    37, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(648,396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(640,392), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C15,    ABISELECT(192,132), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(848,536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C14[];
extern void _ZN9S19012C14D1Ev();
extern void _ZN9S19012C14D0Ev();
extern void _ZN9S19012C132v7Ev();
extern void _ZN9S19012C142v9Ev();
extern void ABISELECT(_ZThn192_N9S19012C14D1Ev,_ZThn132_N9S19012C14D1Ev)();
extern void ABISELECT(_ZThn192_N9S19012C14D0Ev,_ZThn132_N9S19012C14D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN9S19012C153v10Ev();
extern void _ZN9S19012C153v11Ev();
extern void ABISELECT(_ZThn640_N9S19012C14D1Ev,_ZThn392_N9S19012C14D1Ev)();
extern void ABISELECT(_ZThn640_N9S19012C14D0Ev,_ZThn392_N9S19012C14D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C14D1Ev,_ZTv0_n12_N9S19012C14D1Ev)();
extern void ABISELECT(_ZThn1072_N9S19012C14D1Ev,_ZThn684_N9S19012C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C14D0Ev,_ZTv0_n12_N9S19012C14D0Ev)();
extern void ABISELECT(_ZThn1072_N9S19012C14D0Ev,_ZThn684_N9S19012C14D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C14D1Ev,_ZTv0_n12_N9S19012C14D1Ev)();
extern void ABISELECT(_ZThn1704_N9S19012C14D1Ev,_ZThn1088_N9S19012C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C14D0Ev,_ZTv0_n12_N9S19012C14D0Ev)();
extern void ABISELECT(_ZThn1704_N9S19012C14D0Ev,_ZThn1088_N9S19012C14D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C14[] = {
  ABISELECT(1704,1088),
  ABISELECT(1664,1064),
  ABISELECT(1072,684),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C14[0]),
  (VTBL_ENTRY)&_ZN9S19012C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C14D0Ev,
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  (VTBL_ENTRY)&_ZN9S19012C142v9Ev,
  ABISELECT(1512,956),
  ABISELECT(880,552),
  ABISELECT(1472,932),
  ABISELECT(-192,-132),
  (VTBL_ENTRY)&(_ZTI9S19012C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S19012C14D1Ev,_ZThn132_N9S19012C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S19012C14D0Ev,_ZThn132_N9S19012C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v11Ev,
  ABISELECT(-640,-392),
  (VTBL_ENTRY)&(_ZTI9S19012C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19012C14D1Ev,_ZThn392_N9S19012C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19012C14D0Ev,_ZThn392_N9S19012C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-1072,-684),
  ABISELECT(-1072,-684),
  (VTBL_ENTRY)&(_ZTI9S19012C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C14D1Ev,_ZTv0_n12_N9S19012C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C14D0Ev,_ZTv0_n12_N9S19012C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1704,-1088),
  ABISELECT(-1704,-1088),
  (VTBL_ENTRY)&(_ZTI9S19012C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C14D1Ev,_ZTv0_n12_N9S19012C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C14D0Ev,_ZTv0_n12_N9S19012C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C14[];
extern void _ZN9S19012C15D1Ev();
extern void _ZN9S19012C15D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN9S19012C153v10Ev();
extern void _ZN9S19012C153v11Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C15__9S19012C14[] = {
  ABISELECT(1512,956),
  ABISELECT(880,552),
  ABISELECT(1472,932),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&_ZN9S19012C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19012C153v11Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C109S19012C15__9S19012C14[] = {
  ABISELECT(1472,932),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev)();
extern void ABISELECT(_ZThn880_N9S19012C15D1Ev,_ZThn552_N9S19012C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev)();
extern void ABISELECT(_ZThn880_N9S19012C15D0Ev,_ZThn552_N9S19012C15D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__9S19012C15__9S19012C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-552),
  ABISELECT(-880,-552),
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev)();
extern void ABISELECT(_ZThn1512_N9S19012C15D1Ev,_ZThn956_N9S19012C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev)();
extern void ABISELECT(_ZThn1512_N9S19012C15D0Ev,_ZThn956_N9S19012C15D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C3__A2__9S19012C15__9S19012C14[] = {
  0,
  0,
  0,
  ABISELECT(-1512,-956),
  ABISELECT(-1512,-956),
  (VTBL_ENTRY)&(_ZTI9S19012C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C14[] = {
  {&(_ZTV9S19012C14[5]),  5,48},
  {&(_tg__ZTV9S19012C15__9S19012C14[5]),  5,12},
  {&(_tg__ZTV9S19012C109S19012C15__9S19012C14[3]),  3,8},
  {&(_tg__ZTV8S19012C2__9S19012C15__9S19012C14[6]),  6,11},
  {&(_tg__ZTV8S19012C3__A2__9S19012C15__9S19012C14[6]),  6,11},
  {&(_ZTV9S19012C14[32]),  32,48},
  {&(_ZTV9S19012C14[14]),  14,48},
  {&(_ZTV9S19012C14[43]),  43,48},
};
extern VTBL_ENTRY _ZTI9S19012C14[];
extern  VTBL_ENTRY _ZTV9S19012C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C14[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C15D0Ev,_ZTv0_n12_N9S19012C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1512_N9S19012C15D0Ev,_ZThn956_N9S19012C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19012C15D0Ev,_ZThn552_N9S19012C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C15D1Ev,_ZTv0_n12_N9S19012C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1512_N9S19012C15D1Ev,_ZThn956_N9S19012C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19012C15D1Ev,_ZThn552_N9S19012C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C14D0Ev,_ZTv0_n12_N9S19012C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1704_N9S19012C14D0Ev,_ZThn1088_N9S19012C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19012C14D0Ev,_ZThn684_N9S19012C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C14D1Ev,_ZTv0_n12_N9S19012C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1704_N9S19012C14D1Ev,_ZThn1088_N9S19012C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19012C14D1Ev,_ZThn684_N9S19012C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C14 = {  "S19012C14", // class name
  bases_S19012C14, 15,
  &(vtc_S19012C14[0]), // expected_vtbl_contents
  &(vtt_S19012C14[0]), // expected_vtt_contents
  ABISELECT(1968,1240), // object size
  NSPAIRA(_ZTI9S19012C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19012C14),48, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C14),8, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C12  : virtual S19012C8 , S19012C3 , S19012C13 , S19012C4 , S19012C2 {
  char s19012c12f0:3;
  ::S19012C5_nt s19012c12f1;
  int s19012c12f2;
  __tsi64 s19012c12f3:36;
  __tsi64 s19012c12f4;
  void *s19012c12f5[4];
  long s19012c12f6;
  ::S19012C14 s19012c12f7;
  int s19012c12f8:5;
  ::S19012C14 s19012c12f9;
  virtual  ~S19012C12(); // _ZN9S19012C12D2Ev
  S19012C12(); // tgen
};
//SIG(-1 S19012C12) C1{ VBC2{ VBC3{ BC4{ BC5{ m Fl FL Fp[3]} vd v1 v2 v3 FC5 FC5 FC5[3] Fp} FC5 Fi FC5 Fp FU6{ m} FU7{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU7} VBC5 BC8{ VBC5 BC9{ BC4 VBC5 vd Fs FD Fp[2] FL FC5 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} BC3 vd v4 v5 FD Fc[8] FU7 Fi Fi FC10 FD FD} BC9 vd v6 FU6 Fc} BC4 BC11{ BC5 vd v7 FU7 Fc[5] FD} BC5 BC3 vd Fc:3 FU6 Fi FL:36 FL Fp[4] Fl FC12{ BC11 VBC3 BC13{ VBC3 VBC5 BC9 VBC4 BC11 v9 v10 Fi FC10 FC10 FC10 FC10 Fi} BC5 v8 Fi Fi Fi Fc:6 FU7 Fl Fl Fc FL FC10} Fi:5 FC12}


 S19012C12 ::~S19012C12(){ note_dtor("S19012C12", this);}
S19012C12 ::S19012C12(){ note_ctor("S19012C12", this);} // tgen

static void Test_S19012C12()
{
  extern Class_Descriptor cd_S19012C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(465,1167)];
    init_test(&cd_S19012C12, buf);
    S19012C12 *dp, &lv = *(dp=new (buf) S19012C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7424,4664), "sizeof(S19012C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C12)");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(6792,4264), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(6784,4260), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*), ABISELECT(6784,4260), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*), ABISELECT(7376,4640), "S19012C12");
    /*is_ambiguous_... S19012C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*), ABISELECT(7376,4640), "S19012C12");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7376,4640), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*), ABISELECT(7376,4640), "S19012C12");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(5112,3220), "S19012C12");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(5104,3216), "S19012C12");
    check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(5104,3216), "S19012C12");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(5560,3480), "S19012C12");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(5552,3476), "S19012C12");
    check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(5552,3476), "S19012C12");
    check_base_class_offset(lv, (S19012C9*)(S19012C8*), ABISELECT(5104,3216), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(6344,4000), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(6336,3996), "S19012C12");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*), ABISELECT(6336,3996), "S19012C12");
    check_base_class_offset(lv, (S19012C8*), ABISELECT(5104,3216), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(8,4), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*), 0, "S19012C12");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(264,156), "S19012C12");
    check_base_class_offset(lv, (S19012C13*), ABISELECT(256,152), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(448,284), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(504,312), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(496,308), "S19012C12");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*), ABISELECT(496,308), "S19012C12");
    set_bf_and_test(lv, s19012c12f0, ABISELECT(1088,688), 0, 3, 1, "S19012C12");
    set_bf_and_test(lv, s19012c12f0, ABISELECT(1088,688), 0, 3, hide_sll(1LL<<2), "S19012C12");
    check_field_offset(lv, s19012c12f1, ABISELECT(1089,689), "S19012C12.s19012c12f1");
    check_field_offset(lv, s19012c12f2, ABISELECT(1092,692), "S19012C12.s19012c12f2");
    set_bf_and_test(lv, s19012c12f3, ABISELECT(1096,696), 0, 36, 1, "S19012C12");
    set_bf_and_test(lv, s19012c12f3, ABISELECT(1096,696), 0, 36, hide_sll(1LL<<35), "S19012C12");
    check_field_offset(lv, s19012c12f4, ABISELECT(1104,704), "S19012C12.s19012c12f4");
    check_field_offset(lv, s19012c12f5, ABISELECT(1112,712), "S19012C12.s19012c12f5");
    check_field_offset(lv, s19012c12f6, ABISELECT(1144,728), "S19012C12.s19012c12f6");
    check_field_offset(lv, s19012c12f7, ABISELECT(1152,732), "S19012C12.s19012c12f7");
    set_bf_and_test(lv, s19012c12f8, ABISELECT(3120,1972), 0, 5, 1, "S19012C12");
    set_bf_and_test(lv, s19012c12f8, ABISELECT(3120,1972), 0, 5, hide_sll(1LL<<4), "S19012C12");
    check_field_offset(lv, s19012c12f9, ABISELECT(3136,1976), "S19012C12.s19012c12f9");
    test_class_info(&lv, &cd_S19012C12);
    dp->~S19012C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C12(Test_S19012C12, "S19012C12", ABISELECT(7424,4664));

#else // __cplusplus

extern void _ZN9S19012C12C1Ev();
extern void _ZN9S19012C12D2Ev();
Name_Map name_map_S19012C12[] = {
  NSPAIR(_ZN9S19012C12C1Ev),
  NSPAIR(_ZN9S19012C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
static Base_Class bases_S19012C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(6792,4264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(6784,4260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(6784,4260), //bcp->offset
    56, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7376,4640), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(5112,3220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(5104,3216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(5104,3216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(5560,3480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(5552,3476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(5552,3476), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(5104,3216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(6344,4000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(6336,3996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(6336,3996), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(5104,3216), //bcp->offset
    22, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(264,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(256,152), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(448,284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(504,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(496,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(496,308), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C12[];
extern void _ZN9S19012C12D1Ev();
extern void _ZN9S19012C12D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn256_N9S19012C12D1Ev,_ZThn152_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn256_N9S19012C12D0Ev,_ZThn152_N9S19012C12D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZThn496_N9S19012C12D1Ev,_ZThn308_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn496_N9S19012C12D0Ev,_ZThn308_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn5104_N9S19012C12D1Ev,_ZThn3216_N9S19012C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev)();
extern void ABISELECT(_ZThn5104_N9S19012C12D0Ev,_ZThn3216_N9S19012C12D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn6784_N9S19012C12D1Ev,_ZThn4260_N9S19012C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev)();
extern void ABISELECT(_ZThn6784_N9S19012C12D0Ev,_ZThn4260_N9S19012C12D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C12[] = {
  ABISELECT(7376,4640),
  ABISELECT(6784,4260),
  ABISELECT(5104,3216),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&_ZN9S19012C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N9S19012C12D1Ev,_ZThn152_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N9S19012C12D0Ev,_ZThn152_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-496,-308),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn496_N9S19012C12D1Ev,_ZThn308_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn496_N9S19012C12D0Ev,_ZThn308_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-5104,-3216),
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  ABISELECT(-5104,-3216),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-5552,-3476),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(1040,644),
  ABISELECT(-6336,-3996),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-6784,-4260),
  ABISELECT(-6784,-4260),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C12[];
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__9S19012C12[] = {
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C8__9S19012C12[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C8__9S19012C12[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A1__9S19012C12[] = {
  ABISELECT(1040,644),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C8D1Ev,_ZThn1044_N8S19012C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C8D0Ev,_ZThn1044_N8S19012C8D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C8__9S19012C12[] = {
  0,
  0,
  0,
  ABISELECT(-1680,-1044),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8__9S19012C12[] = {
  ABISELECT(1040,644),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C12[] = {
  {&(_ZTV9S19012C12[5]),  5,67},
  {&(_ZTV9S19012C12[33]),  33,67},
  {&(_ZTV9S19012C12[62]),  62,67},
  {&(_ZTV9S19012C12[43]),  43,67},
  {&(_ZTV9S19012C12[51]),  51,67},
  {&(_tg__ZTV8S19012C8__9S19012C12[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C8__9S19012C12[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C8__9S19012C12[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C8__A1__9S19012C12[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C8__9S19012C12[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8__9S19012C12[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19012C12[];
extern  VTBL_ENTRY _ZTV9S19012C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C12[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19012C8D0Ev,_ZThn1044_N8S19012C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19012C8D1Ev,_ZThn1044_N8S19012C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6784_N9S19012C12D0Ev,_ZThn4260_N9S19012C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6784_N9S19012C12D1Ev,_ZThn4260_N9S19012C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5104_N9S19012C12D0Ev,_ZThn3216_N9S19012C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5104_N9S19012C12D1Ev,_ZThn3216_N9S19012C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C12 = {  "S19012C12", // class name
  bases_S19012C12, 23,
  &(vtc_S19012C12[0]), // expected_vtbl_contents
  &(vtt_S19012C12[0]), // expected_vtt_contents
  ABISELECT(7424,4664), // object size
  NSPAIRA(_ZTI9S19012C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19012C12),67, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C12),11, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C7  : S19012C8 , S19012C12 {
  char s19012c7f0;
  char s19012c7f1:6;
  __tsi64 s19012c7f2[3];
  ::S19012C3 s19012c7f3;
  char s19012c7f4[6];
  long s19012c7f5;
  ~S19012C7(); // tgen
  S19012C7(); // tgen
};
//SIG(-1 S19012C7) C1{ BC2{ VBC3{ BC4{ BC5{ m Fl FL Fp[3]} vd v1 v2 v3 FC5 FC5 FC5[3] Fp} FC5 Fi FC5 Fp FU6{ m} FU7{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU7} VBC5 BC8{ VBC5 BC9{ BC4 VBC5 vd Fs FD Fp[2] FL FC5 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} BC3 vd v4 v5 FD Fc[8] FU7 Fi Fi FC10 FD FD} BC9 vd v6 FU6 Fc} BC11{ VBC2 BC4 BC12{ BC5 vd v7 FU7 Fc[5] FD} BC5 BC3 vd Fc:3 FU6 Fi FL:36 FL Fp[4] Fl FC13{ BC12 VBC3 BC14{ VBC3 VBC5 BC9 VBC4 BC12 v9 v10 Fi FC10 FC10 FC10 FC10 Fi} BC5 v8 Fi Fi Fi Fc:6 FU7 Fl Fl Fc FL FC10} Fi:5 FC13} Fc Fc:6 FL[3] FC4 Fc[6] Fl}


S19012C7 ::~S19012C7(){ note_dtor("S19012C7", this);} // tgen
S19012C7 ::S19012C7(){ note_ctor("S19012C7", this);} // tgen

static void Test_S19012C7()
{
  extern Class_Descriptor cd_S19012C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(589,1476)];
    init_test(&cd_S19012C7, buf);
    S19012C7 *dp, &lv = *(dp=new (buf) S19012C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9408,5900), "sizeof(S19012C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C7)");
    /*is_ambiguous_... S19012C7::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(7096,4456), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(7088,4452), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*), ABISELECT(7088,4452), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*), ABISELECT(7088,4452), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*), ABISELECT(7680,4832), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(8,4), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), 0, "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*), 0, "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(456,264), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(448,260), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(448,260), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C9*)(S19012C8*), 0, "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(1240,784), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(1232,780), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*), ABISELECT(1232,780), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C8*), 0, "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7736,4860), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7728,4856), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7728,4856), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(8184,5120), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(8176,5116), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(8176,5116), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C9*)(S19012C8*), ABISELECT(7728,4856), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(8968,5640), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(8960,5636), "S19012C7");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*), ABISELECT(8960,5636), "S19012C7");
    check_base_class_offset(lv, (S19012C8*)(S19012C12*), ABISELECT(7728,4856), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C12*), ABISELECT(1688,1048), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C12*), ABISELECT(1680,1044), "S19012C7");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*)(S19012C12*), ABISELECT(1944,1200), "S19012C7");
    check_base_class_offset(lv, (S19012C13*)(S19012C12*), ABISELECT(1936,1196), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C12*), ABISELECT(2128,1328), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C12*), ABISELECT(2184,1356), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C12*), ABISELECT(2176,1352), "S19012C7");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C12*), ABISELECT(2176,1352), "S19012C7");
    check_base_class_offset(lv, (S19012C12*), ABISELECT(1680,1044), "S19012C7");
    check_field_offset(lv, s19012c7f0, ABISELECT(6784,4260), "S19012C7.s19012c7f0");
    set_bf_and_test(lv, s19012c7f1, ABISELECT(6785,4261), 0, 6, 1, "S19012C7");
    set_bf_and_test(lv, s19012c7f1, ABISELECT(6785,4261), 0, 6, hide_sll(1LL<<5), "S19012C7");
    check_field_offset(lv, s19012c7f2, ABISELECT(6792,4264), "S19012C7.s19012c7f2");
    check_field_offset(lv, s19012c7f3, ABISELECT(6816,4288), "S19012C7.s19012c7f3");
    check_field_offset(lv, s19012c7f4, ABISELECT(7072,4440), "S19012C7.s19012c7f4");
    check_field_offset(lv, s19012c7f5, ABISELECT(7080,4448), "S19012C7.s19012c7f5");
    test_class_info(&lv, &cd_S19012C7);
    dp->~S19012C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C7(Test_S19012C7, "S19012C7", ABISELECT(9408,5900));

#else // __cplusplus

extern void _ZN8S19012C7C1Ev();
extern void _ZN8S19012C7D1Ev();
Name_Map name_map_S19012C7[] = {
  NSPAIR(_ZN8S19012C7C1Ev),
  NSPAIR(_ZN8S19012C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C12;
extern VTBL_ENTRY _ZTI9S19012C12[];
extern  VTBL_ENTRY _ZTV9S19012C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C12[];
static Base_Class bases_S19012C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7096,4456), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(7088,4452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(7088,4452), //bcp->offset
    50, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7680,4832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(448,260), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(1232,780), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7736,4860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(7728,4856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(7728,4856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8184,5120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(8176,5116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(8176,5116), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(7728,4856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8968,5640), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(8960,5636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(8960,5636), //bcp->offset
    87, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(7728,4856), //bcp->offset
    61, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(1688,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1680,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1944,1200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(1936,1196), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2128,1328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2184,1356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(2176,1352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(2176,1352), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C12,    ABISELECT(1680,1044), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C7[];
extern void _ZN8S19012C7D1Ev();
extern void _ZN8S19012C7D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZThn448_N8S19012C7D1Ev,_ZThn260_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn448_N8S19012C7D0Ev,_ZThn260_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19012C7D1Ev,_ZThn780_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C7D0Ev,_ZThn780_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1680_N8S19012C7D1Ev,_ZThn1044_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C7D0Ev,_ZThn1044_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1936_N8S19012C7D1Ev,_ZThn1196_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn1936_N8S19012C7D0Ev,_ZThn1196_N8S19012C7D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZThn2176_N8S19012C7D1Ev,_ZThn1352_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn2176_N8S19012C7D0Ev,_ZThn1352_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19012C7D1Ev,_ZTv0_n12_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn7088_N8S19012C7D1Ev,_ZThn4452_N8S19012C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C7D0Ev,_ZTv0_n12_N8S19012C7D0Ev)();
extern void ABISELECT(_ZThn7088_N8S19012C7D0Ev,_ZThn4452_N8S19012C7D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn7728_N8S19012C7D1Ev,_ZThn4856_N8S19012C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev)();
extern void ABISELECT(_ZThn7728_N8S19012C7D0Ev,_ZThn4856_N8S19012C7D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZTvn448_n40_N8S19012C7D1Ev,_ZTvn260_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S19012C7D0Ev,_ZTvn260_n20_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1232_n40_N8S19012C7D1Ev,_ZTvn780_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N8S19012C7D0Ev,_ZTvn780_n20_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C7[] = {
  ABISELECT(7728,4856),
  ABISELECT(7088,4452),
  ABISELECT(7680,4832),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&_ZN8S19012C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C7D1Ev,_ZThn260_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C7D0Ev,_ZThn260_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(6448,4052),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C7D1Ev,_ZThn780_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C7D0Ev,_ZThn780_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(6000,3788),
  ABISELECT(5408,3408),
  ABISELECT(6048,3812),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19012C7D1Ev,_ZThn1044_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19012C7D0Ev,_ZThn1044_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-1936,-1196),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N8S19012C7D1Ev,_ZThn1196_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N8S19012C7D0Ev,_ZThn1196_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-2176,-1352),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S19012C7D1Ev,_ZThn1352_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S19012C7D0Ev,_ZThn1352_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-7088,-4452),
  ABISELECT(-7088,-4452),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C7D1Ev,_ZTv0_n12_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C7D0Ev,_ZTv0_n12_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-7728,-4856),
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  ABISELECT(-7728,-4856),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-8176,-5116),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C7D1Ev,_ZTvn260_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C7D0Ev,_ZTvn260_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-1280,-804),
  ABISELECT(-8960,-5636),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C7D1Ev,_ZTvn780_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C7D0Ev,_ZTvn780_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19012C7[];
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__A__8S19012C7[] = {
  ABISELECT(7088,4452),
  ABISELECT(7680,4832),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C8__8S19012C7[] = {
  ABISELECT(7680,4832),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C8__8S19012C7[] = {
  ABISELECT(7680,4832),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A1__8S19012C7[] = {
  ABISELECT(6448,4052),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn7088_N8S19012C8D1Ev,_ZThn4452_N8S19012C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void ABISELECT(_ZThn7088_N8S19012C8D0Ev,_ZThn4452_N8S19012C8D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C8__A__8S19012C7[] = {
  0,
  0,
  0,
  ABISELECT(-7088,-4452),
  ABISELECT(-7088,-4452),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8__A__8S19012C7[] = {
  ABISELECT(6448,4052),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C12D1Ev();
extern void _ZN9S19012C12D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C12__8S19012C7[] = {
  ABISELECT(6000,3788),
  ABISELECT(5408,3408),
  ABISELECT(6048,3812),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&_ZN9S19012C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn6048_N9S19012C12D1Ev,_ZThn3812_N9S19012C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev)();
extern void ABISELECT(_ZThn6048_N9S19012C12D0Ev,_ZThn3812_N9S19012C12D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__9S19012C12__8S19012C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-6048,-3812),
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  ABISELECT(-6048,-3812),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn5408_N9S19012C12D1Ev,_ZThn3408_N9S19012C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev)();
extern void ABISELECT(_ZThn5408_N9S19012C12D0Ev,_ZThn3408_N9S19012C12D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__9S19012C12__8S19012C7[] = {
  0,
  0,
  0,
  ABISELECT(-5408,-3408),
  ABISELECT(-5408,-3408),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C28S19012C98S19012C8__A1__9S19012C12__8S19012C7[] = {
  ABISELECT(-6496,-4072),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A1__9S19012C12__8S19012C7[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-7280,-4592),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__A1__8S19012C7[] = {
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C8__A1__8S19012C7[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C8__A2__8S19012C7[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A3__8S19012C7[] = {
  ABISELECT(-1280,-804),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C8__A1__8S19012C7[] = {
  0,
  0,
  0,
  ABISELECT(640,404),
  ABISELECT(640,404),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8__A1__8S19012C7[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C7[] = {
  {&(_ZTV8S19012C7[5]),  5,95},
  {&(_tg__ZTV8S19012C8__A__8S19012C7[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C8__8S19012C7[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C8__8S19012C7[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C8__A1__8S19012C7[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C8__A__8S19012C7[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8__A__8S19012C7[3]),  3,8},
  {&(_tg__ZTV9S19012C12__8S19012C7[5]),  5,10},
  {&(_tg__ZTV8S19012C8__9S19012C12__8S19012C7[11]),  11,19},
  {&(_tg__ZTV8S19012C2__9S19012C12__8S19012C7[6]),  6,11},
  {&(_tg__ZTV8S19012C28S19012C98S19012C8__A1__9S19012C12__8S19012C7[2]),  2,7},
  {&(_tg__ZTV9S19012C108S19012C8__A1__9S19012C12__8S19012C7[3]),  3,8},
  {&(_ZTV8S19012C7[56]),  56,95},
  {&(_ZTV8S19012C7[23]),  23,95},
  {&(_ZTV8S19012C7[33]),  33,95},
  {&(_ZTV8S19012C7[72]),  72,95},
  {&(_ZTV8S19012C7[82]),  82,95},
  {&(_ZTV8S19012C7[90]),  90,95},
  {&(_tg__ZTV8S19012C8__A1__8S19012C7[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C8__A1__8S19012C7[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C8__A2__8S19012C7[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C8__A3__8S19012C7[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C8__A1__8S19012C7[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8__A1__8S19012C7[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S19012C7[];
extern  VTBL_ENTRY _ZTV8S19012C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C7[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5408_N9S19012C12D0Ev,_ZThn3408_N9S19012C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5408_N9S19012C12D1Ev,_ZThn3408_N9S19012C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6048_N9S19012C12D0Ev,_ZThn3812_N9S19012C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6048_N9S19012C12D1Ev,_ZThn3812_N9S19012C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19012C8D0Ev,_ZThn4452_N8S19012C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19012C8D1Ev,_ZThn4452_N8S19012C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7728_N8S19012C7D0Ev,_ZThn4856_N8S19012C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7728_N8S19012C7D1Ev,_ZThn4856_N8S19012C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C7D0Ev,_ZTv0_n12_N8S19012C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19012C7D0Ev,_ZThn4452_N8S19012C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C7D1Ev,_ZTv0_n12_N8S19012C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19012C7D1Ev,_ZThn4452_N8S19012C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C7 = {  "S19012C7", // class name
  bases_S19012C7, 35,
  &(vtc_S19012C7[0]), // expected_vtbl_contents
  &(vtt_S19012C7[0]), // expected_vtt_contents
  ABISELECT(9408,5900), // object size
  NSPAIRA(_ZTI8S19012C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19012C7),95, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19012C7),24, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C17  : virtual S19012C13 , virtual S19012C10 {
  long s19012c17f0;
  char s19012c17f1;
  char s19012c17f2;
  long s19012c17f3;
  ::S19012C4 s19012c17f4;
  void *s19012c17f5;
  short s19012c17f6;
  long s19012c17f7;
  long s19012c17f8;
  char s19012c17f9;
  virtual void  v8(); // _ZN9S19012C172v8Ev
  ~S19012C17(); // tgen
  S19012C17(); // tgen
};
//SIG(-1 S19012C17) C1{ VBC2{ BC3{ m Fl FL Fp[3]} vd v2 FU4{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD} VBC5{ BC6{ BC3 vd v3 v4 v5 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC7{}[10] FC7[4] Fi} v1 Fl Fc Fc Fl FC3 Fp Fs Fl Fl Fc}


void  S19012C17 ::v8(){vfunc_called(this, "_ZN9S19012C172v8Ev");}
S19012C17 ::~S19012C17(){ note_dtor("S19012C17", this);} // tgen
S19012C17 ::S19012C17(){ note_ctor("S19012C17", this);} // tgen

static void Test_S19012C17()
{
  extern Class_Descriptor cd_S19012C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(50,120)];
    init_test(&cd_S19012C17, buf);
    S19012C17 *dp, &lv = *(dp=new (buf) S19012C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,476), "sizeof(S19012C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C17)");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(120,64), "S19012C17");
    check_base_class_offset(lv, (S19012C13*), ABISELECT(112,60), "S19012C17");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(312,196), "S19012C17");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*), ABISELECT(304,192), "S19012C17");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(744,452), "S19012C17");
    check_base_class_offset(lv, (S19012C10*), ABISELECT(304,192), "S19012C17");
    check_field_offset(lv, s19012c17f0, ABISELECT(8,4), "S19012C17.s19012c17f0");
    check_field_offset(lv, s19012c17f1, ABISELECT(16,8), "S19012C17.s19012c17f1");
    check_field_offset(lv, s19012c17f2, ABISELECT(17,9), "S19012C17.s19012c17f2");
    check_field_offset(lv, s19012c17f3, ABISELECT(24,12), "S19012C17.s19012c17f3");
    check_field_offset(lv, s19012c17f4, ABISELECT(32,16), "S19012C17.s19012c17f4");
    check_field_offset(lv, s19012c17f5, ABISELECT(72,40), "S19012C17.s19012c17f5");
    check_field_offset(lv, s19012c17f6, ABISELECT(80,44), "S19012C17.s19012c17f6");
    check_field_offset(lv, s19012c17f7, ABISELECT(88,48), "S19012C17.s19012c17f7");
    check_field_offset(lv, s19012c17f8, ABISELECT(96,52), "S19012C17.s19012c17f8");
    check_field_offset(lv, s19012c17f9, ABISELECT(104,56), "S19012C17.s19012c17f9");
    test_class_info(&lv, &cd_S19012C17);
    dp->~S19012C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C17(Test_S19012C17, "S19012C17", ABISELECT(784,476));

#else // __cplusplus

extern void _ZN9S19012C17C1Ev();
extern void _ZN9S19012C17D1Ev();
Name_Map name_map_S19012C17[] = {
  NSPAIR(_ZN9S19012C17C1Ev),
  NSPAIR(_ZN9S19012C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
static Base_Class bases_S19012C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(120,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(112,60), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(312,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(304,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(744,452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19012C10,    ABISELECT(304,192), //bcp->offset
    15, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C17[];
extern void _ZN9S19012C172v8Ev();
extern void _ZN9S19012C17D1Ev();
extern void _ZN9S19012C17D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev)() __attribute__((weak));
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev)();
extern void ABISELECT(_ZThn304_N9S19012C17D1Ev,_ZThn192_N9S19012C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev)();
extern void ABISELECT(_ZThn304_N9S19012C17D0Ev,_ZThn192_N9S19012C17D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C17[] = {
  ABISELECT(744,452),
  ABISELECT(304,192),
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D0Ev,
  0,
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-304,-192),
  ABISELECT(440,260),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C17[];
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__9S19012C17[] = {
  ABISELECT(440,260),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C17[] = {
  {&(_ZTV9S19012C17[5]),  5,27},
  {&(_ZTV9S19012C17[12]),  12,27},
  {&(_ZTV9S19012C17[22]),  22,27},
  {&(_tg__ZTV9S19012C10__9S19012C17[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19012C17[];
extern  VTBL_ENTRY _ZTV9S19012C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C17[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19012C17D0Ev,_ZThn192_N9S19012C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19012C17D1Ev,_ZThn192_N9S19012C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C17 = {  "S19012C17", // class name
  bases_S19012C17, 6,
  &(vtc_S19012C17[0]), // expected_vtbl_contents
  &(vtt_S19012C17[0]), // expected_vtt_contents
  ABISELECT(784,476), // object size
  NSPAIRA(_ZTI9S19012C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19012C17),27, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C17),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C16  : S19012C9 , S19012C13 , S19012C2 , virtual S19012C17 , S19012C8 {
  long s19012c16f0;
  char s19012c16f1;
  void *s19012c16f2;
  void *s19012c16f3;
  void *s19012c16f4;
  ::S19012C6 s19012c16f5;
  char s19012c16f6;
  char s19012c16f7;
  void *s19012c16f8;
  __tsi64 s19012c16f9:6;
  int s19012c16f10;
  ::S19012C11_nt s19012c16f11;
  ::S19012C11_nt s19012c16f12;
  ::S19012C10 s19012c16f13[7];
  ::S19012C11_nt s19012c16f14;
  ~S19012C16(); // tgen
  S19012C16(); // tgen
};
//SIG(-1 S19012C16) C1{ BC2{ VBC3{ m Fl FL Fp[3]} BC4{ BC5{ BC3 vd v1 v2 v3 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC6{}[10] FC6[4] Fi} BC7{ BC5 FC3 Fi FC3 Fp FU8{ m} FU9{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU9} vd v4 v5 FD Fc[8] FU9 Fi Fi FC6 FD FD} BC10{ BC3 vd v6 FU9 Fc[5] FD} BC7 VBC11{ VBC10 VBC4 v7 Fl Fc Fc Fl FC3 Fp Fs Fl Fl Fc} BC12{ VBC7 VBC3 BC2 BC4 vd v8 FU8 Fc} Fl Fc Fp Fp Fp FU9 Fc Fc Fp FL:6 Fi FC6 FC6 FC4[7] FC6}


S19012C16 ::~S19012C16(){ note_dtor("S19012C16", this);} // tgen
S19012C16 ::S19012C16(){ note_ctor("S19012C16", this);} // tgen

static void Test_S19012C16()
{
  extern Class_Descriptor cd_S19012C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(540,1328)];
    init_test(&cd_S19012C16, buf);
    S19012C16 *dp, &lv = *(dp=new (buf) S19012C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8624,5308), "sizeof(S19012C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C16)");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*), ABISELECT(7240,4452), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*), ABISELECT(8,4), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*), 0, "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*), 0, "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*), ABISELECT(456,264), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*), ABISELECT(448,260), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*), ABISELECT(448,260), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C9*), 0, "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(1240,784), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C13*), ABISELECT(1232,780), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(1432,916), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(1424,912), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*), ABISELECT(1424,912), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(7400,4540), "S19012C16");
    check_base_class_offset(lv, (S19012C13*)(S19012C17*), ABISELECT(7392,4536), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(7592,4672), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*), ABISELECT(7584,4668), "S19012C16");
    check_base_class_offset(lv, (S19012C10*)(S19012C17*), ABISELECT(7584,4668), "S19012C16");
    check_base_class_offset(lv, (S19012C17*), ABISELECT(7280,4476), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(8040,4932), "S19012C16");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(8032,4928), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*), ABISELECT(8032,4928), "S19012C16");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(2024,1296), "S19012C16");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(2016,1292), "S19012C16");
    check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(2016,1292), "S19012C16");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(2472,1556), "S19012C16");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(2464,1552), "S19012C16");
    check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(2464,1552), "S19012C16");
    check_base_class_offset(lv, (S19012C9*)(S19012C8*), ABISELECT(2016,1292), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(3256,2076), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(3248,2072), "S19012C16");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*), ABISELECT(3248,2072), "S19012C16");
    check_base_class_offset(lv, (S19012C8*), ABISELECT(2016,1292), "S19012C16");
    check_field_offset(lv, s19012c16f0, ABISELECT(3688,2336), "S19012C16.s19012c16f0");
    check_field_offset(lv, s19012c16f1, ABISELECT(3696,2340), "S19012C16.s19012c16f1");
    check_field_offset(lv, s19012c16f2, ABISELECT(3704,2344), "S19012C16.s19012c16f2");
    check_field_offset(lv, s19012c16f3, ABISELECT(3712,2348), "S19012C16.s19012c16f3");
    check_field_offset(lv, s19012c16f4, ABISELECT(3720,2352), "S19012C16.s19012c16f4");
    check_field_offset(lv, s19012c16f5, ABISELECT(3728,2356), "S19012C16.s19012c16f5");
    check_field_offset(lv, s19012c16f6, ABISELECT(3840,2440), "S19012C16.s19012c16f6");
    check_field_offset(lv, s19012c16f7, ABISELECT(3841,2441), "S19012C16.s19012c16f7");
    check_field_offset(lv, s19012c16f8, ABISELECT(3848,2444), "S19012C16.s19012c16f8");
    set_bf_and_test(lv, s19012c16f9, ABISELECT(3856,2448), 0, 6, 1, "S19012C16");
    set_bf_and_test(lv, s19012c16f9, ABISELECT(3856,2448), 0, 6, hide_sll(1LL<<5), "S19012C16");
    check_field_offset(lv, s19012c16f10, ABISELECT(3860,2452), "S19012C16.s19012c16f10");
    check_field_offset(lv, s19012c16f11, ABISELECT(3864,2456), "S19012C16.s19012c16f11");
    check_field_offset(lv, s19012c16f12, ABISELECT(3865,2457), "S19012C16.s19012c16f12");
    check_field_offset(lv, s19012c16f13, ABISELECT(3872,2460), "S19012C16.s19012c16f13");
    check_field_offset(lv, s19012c16f14, ABISELECT(7232,4448), "S19012C16.s19012c16f14");
    test_class_info(&lv, &cd_S19012C16);
    dp->~S19012C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C16(Test_S19012C16, "S19012C16", ABISELECT(8624,5308));

#else // __cplusplus

extern void _ZN9S19012C16C1Ev();
extern void _ZN9S19012C16D1Ev();
Name_Map name_map_S19012C16[] = {
  NSPAIR(_ZN9S19012C16C1Ev),
  NSPAIR(_ZN9S19012C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C17;
extern VTBL_ENTRY _ZTI9S19012C17[];
extern  VTBL_ENTRY _ZTV9S19012C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C17[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
static Base_Class bases_S19012C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7240,4452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(448,260), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19012C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(1232,780), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1432,916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1424,912), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(1424,912), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7400,4540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(7392,4536), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7592,4672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(7584,4668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(7584,4668), //bcp->offset
    77, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19012C17,    ABISELECT(7280,4476), //bcp->offset
    60, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8040,4932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(8032,4928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(8032,4928), //bcp->offset
    89, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(2024,1296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2472,1556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(2464,1552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(2464,1552), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(3256,2076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(3248,2072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(3248,2072), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(2016,1292), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19012C16[];
extern void _ZN9S19012C16D1Ev();
extern void _ZN9S19012C16D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void ABISELECT(_ZThn448_N9S19012C16D1Ev,_ZThn260_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn448_N9S19012C16D0Ev,_ZThn260_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1232_N9S19012C16D1Ev,_ZThn780_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn1232_N9S19012C16D0Ev,_ZThn780_N9S19012C16D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZThn1424_N9S19012C16D1Ev,_ZThn912_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn1424_N9S19012C16D0Ev,_ZThn912_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn2016_N9S19012C16D1Ev,_ZThn1292_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn2016_N9S19012C16D0Ev,_ZThn1292_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZThn2464_N9S19012C16D1Ev,_ZThn1552_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn2464_N9S19012C16D0Ev,_ZThn1552_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn3248_N9S19012C16D1Ev,_ZThn2072_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn3248_N9S19012C16D0Ev,_ZThn2072_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN9S19012C172v8Ev();
extern void ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn7280_N9S19012C16D1Ev,_ZThn4476_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn7280_N9S19012C16D0Ev,_ZThn4476_N9S19012C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn7392_N9S19012C16D1Ev,_ZThn4536_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn7392_N9S19012C16D0Ev,_ZThn4536_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn7584_N9S19012C16D1Ev,_ZThn4668_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn7584_N9S19012C16D0Ev,_ZThn4668_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn8032_N9S19012C16D1Ev,_ZThn4928_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn8032_N9S19012C16D0Ev,_ZThn4928_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C16[] = {
  ABISELECT(8032,4928),
  ABISELECT(7584,4668),
  ABISELECT(7392,4536),
  ABISELECT(7280,4476),
  ABISELECT(7240,4452),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&_ZN9S19012C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C16D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19012C16D1Ev,_ZThn260_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19012C16D0Ev,_ZThn260_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N9S19012C16D1Ev,_ZThn780_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N9S19012C16D0Ev,_ZThn780_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-1424,-912),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N9S19012C16D1Ev,_ZThn912_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N9S19012C16D0Ev,_ZThn912_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(6016,3636),
  ABISELECT(5224,3160),
  ABISELECT(-2016,-1292),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19012C16D1Ev,_ZThn1292_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19012C16D0Ev,_ZThn1292_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-2464,-1552),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N9S19012C16D1Ev,_ZThn1552_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N9S19012C16D0Ev,_ZThn1552_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(3992,2380),
  ABISELECT(-3248,-2072),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19012C16D1Ev,_ZThn2072_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19012C16D0Ev,_ZThn2072_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-7280,-4476),
  0,
  ABISELECT(-40,-24),
  ABISELECT(304,192),
  ABISELECT(112,60),
  ABISELECT(-7280,-4476),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev),
  0,
  ABISELECT(-7392,-4536),
  ABISELECT(-7392,-4536),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-7584,-4668),
  ABISELECT(-344,-216),
  ABISELECT(-7584,-4668),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-8032,-4928),
  ABISELECT(-8032,-4928),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19012C16[];
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C9__9S19012C16[] = {
  ABISELECT(7240,4452),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C9__9S19012C16[] = {
  ABISELECT(7240,4452),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__9S19012C16[] = {
  ABISELECT(6016,3636),
  ABISELECT(5224,3160),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C8__A1__9S19012C16[] = {
  ABISELECT(5224,3160),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C8__A2__9S19012C16[] = {
  ABISELECT(5224,3160),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A3__9S19012C16[] = {
  ABISELECT(3992,2380),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn6016_N8S19012C8D1Ev,_ZThn3636_N8S19012C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void ABISELECT(_ZThn6016_N8S19012C8D0Ev,_ZThn3636_N8S19012C8D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C8__9S19012C16[] = {
  0,
  0,
  0,
  ABISELECT(-6016,-3636),
  ABISELECT(-6016,-3636),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8__9S19012C16[] = {
  ABISELECT(3992,2380),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C172v8Ev();
extern void _ZN9S19012C17D1Ev();
extern void _ZN9S19012C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C17__9S19012C16[] = {
  ABISELECT(-40,-24),
  ABISELECT(304,192),
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev)() __attribute__((weak));
extern void _ZN9S19012C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C13__9S19012C17__9S19012C16[] = {
  0,
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev)();
extern void ABISELECT(_ZThn304_N9S19012C17D1Ev,_ZThn192_N9S19012C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev)();
extern void ABISELECT(_ZThn304_N9S19012C17D0Ev,_ZThn192_N9S19012C17D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__9S19012C17__9S19012C16[] = {
  0,
  0,
  0,
  ABISELECT(-304,-192),
  ABISELECT(-344,-216),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__9S19012C16[] = {
  ABISELECT(-344,-216),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C16[] = {
  {&(_ZTV9S19012C16[7]),  7,100},
  {&(_tg__ZTV8S19012C9__9S19012C16[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C9__9S19012C16[3]),  3,8},
  {&(_tg__ZTV8S19012C8__9S19012C16[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C8__A1__9S19012C16[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C8__A2__9S19012C16[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C8__A3__9S19012C16[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C8__9S19012C16[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8__9S19012C16[3]),  3,8},
  {&(_ZTV9S19012C16[67]),  67,100},
  {&(_ZTV9S19012C16[74]),  74,100},
  {&(_ZTV9S19012C16[84]),  84,100},
  {&(_ZTV9S19012C16[37]),  37,100},
  {&(_ZTV9S19012C16[95]),  95,100},
  {&(_ZTV9S19012C16[55]),  55,100},
  {&(_tg__ZTV9S19012C17__9S19012C16[5]),  5,8},
  {&(_tg__ZTV9S19012C13__9S19012C17__9S19012C16[4]),  4,7},
  {&(_tg__ZTV9S19012C10__9S19012C17__9S19012C16[7]),  7,12},
  {&(_tg__ZTV9S19012C10__A1__9S19012C16[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19012C16[];
extern  VTBL_ENTRY _ZTV9S19012C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C16[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19012C17D0Ev,_ZThn192_N9S19012C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19012C17D1Ev,_ZThn192_N9S19012C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6016_N8S19012C8D0Ev,_ZThn3636_N8S19012C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6016_N8S19012C8D1Ev,_ZThn3636_N8S19012C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7584_N9S19012C16D0Ev,_ZThn4668_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7584_N9S19012C16D1Ev,_ZThn4668_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8032_N9S19012C16D0Ev,_ZThn4928_N9S19012C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7392_N9S19012C16D0Ev,_ZThn4536_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8032_N9S19012C16D1Ev,_ZThn4928_N9S19012C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7392_N9S19012C16D1Ev,_ZThn4536_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7280_N9S19012C16D0Ev,_ZThn4476_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7280_N9S19012C16D1Ev,_ZThn4476_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C16 = {  "S19012C16", // class name
  bases_S19012C16, 33,
  &(vtc_S19012C16[0]), // expected_vtbl_contents
  &(vtt_S19012C16[0]), // expected_vtt_contents
  ABISELECT(8624,5308), // object size
  NSPAIRA(_ZTI9S19012C16),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19012C16),100, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19012C16),19, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19012C1  : virtual S19012C2 , virtual S19012C7 , virtual S19012C13 , S19012C16 , S19012C3 {
  void *s19012c1f0;
  long s19012c1f1;
  ::S19012C11_nt s19012c1f2;
  __tsi64 s19012c1f3;
  char s19012c1f4;
  int s19012c1f5;
  void *s19012c1f6;
  void *s19012c1f7;
  long s19012c1f8;
  virtual  ~S19012C1(); // _ZN8S19012C1D2Ev
  S19012C1(); // tgen
};
//SIG(1 S19012C1) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v1 v2 v3 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC7{ BC8{ VBC2 VBC4 BC9{ VBC4 BC10{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC11{}[10] FC11[4] Fi} BC2 vd v4 v5 FD Fc[8] FU6 Fi Fi FC11 FD FD} BC10 vd v6 FU5 Fc} BC12{ VBC8 BC3 BC13{ BC4 vd v7 FU6 Fc[5] FD} BC4 BC2 vd Fc:3 FU5 Fi FL:36 FL Fp[4] Fl FC14{ BC13 VBC2 BC15{ VBC2 VBC4 BC10 VBC3 BC13 v10 v11 Fi FC11 FC11 FC11 FC11 Fi} BC4 v9 Fi Fi Fi Fc:6 FU6 Fl Fl Fc FL FC11} Fi:5 FC14} Fc Fc:6 FL[3] FC3 Fc[6] Fl} VBC13 BC16{ BC9 BC13 BC2 VBC17{ VBC13 VBC10 v8 Fl Fc Fc Fl FC4 Fp Fs Fl Fl Fc} BC8 Fl Fc Fp Fp Fp FU6 Fc Fc Fp FL:6 Fi FC11 FC11 FC10[7] FC11} BC3 vd Fp Fl FC11 FL Fc Fi Fp Fp Fl}


 S19012C1 ::~S19012C1(){ note_dtor("S19012C1", this);}
S19012C1 ::S19012C1(){ note_ctor("S19012C1", this);} // tgen

static void Test_S19012C1()
{
  extern Class_Descriptor cd_S19012C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1109,2750)];
    init_test(&cd_S19012C1, buf);
    S19012C1 *dp, &lv = *(dp=new (buf) S19012C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17728,10996), "sizeof(S19012C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19012C1)");
    /*is_ambiguous_... S19012C1::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*), ABISELECT(7576,4648), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*), ABISELECT(7568,4644), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*), ABISELECT(7568,4644), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*)(S19012C7*), ABISELECT(7568,4644), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*), ABISELECT(7568,4644), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C8*)(S19012C16*), ABISELECT(7568,4644), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*)(S19012C7*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*)(S19012C7*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C8*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C10*)(S19012C8*)(S19012C16*), ABISELECT(15248,9476), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8168,5028), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8160,5024), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8160,5024), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8616,5288), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8608,5284), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8608,5284), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C9*)(S19012C8*)(S19012C7*), ABISELECT(8160,5024), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*)(S19012C7*), ABISELECT(9400,5808), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*)(S19012C7*), ABISELECT(9392,5804), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*)(S19012C7*), ABISELECT(9392,5804), "S19012C1");
    /*is_ambiguous_... S19012C7::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C8*)(S19012C7*), ABISELECT(8160,5024), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(15304,9504), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(15296,9500), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*), ABISELECT(15296,9500), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(15752,9764), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(15744,9760), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*), ABISELECT(15744,9760), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C9*)(S19012C8*), ABISELECT(15296,9500), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(16536,10284), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*), ABISELECT(16528,10280), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C8 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*), ABISELECT(16528,10280), "S19012C1");
    check_base_class_offset(lv, (S19012C8*)(S19012C12*)(S19012C7*), ABISELECT(15296,9500), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C12*)(S19012C7*), ABISELECT(9848,6072), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C12*)(S19012C7*), ABISELECT(9840,6068), "S19012C1");
    check_base_class_offset(lv, (S19012C4*)(S19012C13*)(S19012C12*)(S19012C7*), ABISELECT(10104,6224), "S19012C1");
    check_base_class_offset(lv, (S19012C13*)(S19012C12*)(S19012C7*), ABISELECT(10096,6220), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C12*)(S19012C7*), ABISELECT(10288,6352), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C12*)(S19012C7*), ABISELECT(10344,6380), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C12*)(S19012C7*), ABISELECT(10336,6376), "S19012C1");
    /*is_ambiguous_... S19012C12::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C12*)(S19012C7*), ABISELECT(10336,6376), "S19012C1");
    check_base_class_offset(lv, (S19012C12*)(S19012C7*), ABISELECT(9840,6068), "S19012C1");
    check_base_class_offset(lv, (S19012C7*), ABISELECT(8160,5024), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C13*), ABISELECT(16984,10548), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C13*), ABISELECT(16976,10544), "S19012C1");
    check_base_class_offset(lv, (S19012C13*)(S19012C17*), ABISELECT(16976,10544), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C16*), ABISELECT(8,4), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C16*), 0, "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C16*), 0, "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C16*), ABISELECT(456,264), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C16*), ABISELECT(448,260), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C16*), ABISELECT(448,260), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C9 */ AMB_check_base_class_offset(lv, (S19012C9*)(S19012C16*), 0, "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C13*)(S19012C16*), ABISELECT(1240,784), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C13 */ AMB_check_base_class_offset(lv, (S19012C13*)(S19012C16*), ABISELECT(1232,780), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C16*), ABISELECT(1432,916), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C16*), ABISELECT(1424,912), "S19012C1");
    /*is_ambiguous_... S19012C16::S19012C2 */ AMB_check_base_class_offset(lv, (S19012C2*)(S19012C16*), ABISELECT(1424,912), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*), ABISELECT(17288,10740), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*), ABISELECT(17280,10736), "S19012C1");
    check_base_class_offset(lv, (S19012C10*)(S19012C17*), ABISELECT(17280,10736), "S19012C1");
    check_base_class_offset(lv, (S19012C17*)(S19012C16*), ABISELECT(17168,10676), "S19012C1");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2024,1296), "S19012C1");
    check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2016,1292), "S19012C1");
    check_base_class_offset(lv, (S19012C10*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2016,1292), "S19012C1");
    check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2472,1556), "S19012C1");
    check_base_class_offset(lv, (S19012C3*)(S19012C2*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2464,1552), "S19012C1");
    check_base_class_offset(lv, (S19012C2*)(S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2464,1552), "S19012C1");
    check_base_class_offset(lv, (S19012C9*)(S19012C8*)(S19012C16*), ABISELECT(2016,1292), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*)(S19012C10*)(S19012C8*)(S19012C16*), ABISELECT(3256,2076), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C3*)(S19012C10*)(S19012C8*)(S19012C16*), ABISELECT(3248,2072), "S19012C1");
    /*is_ambiguous_... S19012C8::S19012C10 */ AMB_check_base_class_offset(lv, (S19012C10*)(S19012C8*)(S19012C16*), ABISELECT(3248,2072), "S19012C1");
    check_base_class_offset(lv, (S19012C8*)(S19012C16*), ABISELECT(2016,1292), "S19012C1");
    check_base_class_offset(lv, (S19012C16*), 0, "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19012C3*), ABISELECT(7248,4456), "S19012C1");
    /*is_ambiguous_... S19012C1::S19012C3 */ AMB_check_base_class_offset(lv, (S19012C3*), ABISELECT(7240,4452), "S19012C1");
    check_field_offset(lv, s19012c1f0, ABISELECT(7496,4604), "S19012C1.s19012c1f0");
    check_field_offset(lv, s19012c1f1, ABISELECT(7504,4608), "S19012C1.s19012c1f1");
    check_field_offset(lv, s19012c1f2, ABISELECT(7512,4612), "S19012C1.s19012c1f2");
    check_field_offset(lv, s19012c1f3, ABISELECT(7520,4616), "S19012C1.s19012c1f3");
    check_field_offset(lv, s19012c1f4, ABISELECT(7528,4624), "S19012C1.s19012c1f4");
    check_field_offset(lv, s19012c1f5, ABISELECT(7532,4628), "S19012C1.s19012c1f5");
    check_field_offset(lv, s19012c1f6, ABISELECT(7536,4632), "S19012C1.s19012c1f6");
    check_field_offset(lv, s19012c1f7, ABISELECT(7544,4636), "S19012C1.s19012c1f7");
    check_field_offset(lv, s19012c1f8, ABISELECT(7552,4640), "S19012C1.s19012c1f8");
    test_class_info(&lv, &cd_S19012C1);
    dp->~S19012C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19012C1(Test_S19012C1, "S19012C1", ABISELECT(17728,10996));

#else // __cplusplus

extern void _ZN8S19012C1C1Ev();
extern void _ZN8S19012C1D2Ev();
Name_Map name_map_S19012C1[] = {
  NSPAIR(_ZN8S19012C1C1Ev),
  NSPAIR(_ZN8S19012C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C12;
extern VTBL_ENTRY _ZTI9S19012C12[];
extern  VTBL_ENTRY _ZTV9S19012C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C12[];
extern Class_Descriptor cd_S19012C7;
extern VTBL_ENTRY _ZTI8S19012C7[];
extern  VTBL_ENTRY _ZTV8S19012C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C7[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C13;
extern VTBL_ENTRY _ZTI9S19012C13[];
extern  VTBL_ENTRY _ZTV9S19012C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C17;
extern VTBL_ENTRY _ZTI9S19012C17[];
extern  VTBL_ENTRY _ZTV9S19012C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C17[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C2;
extern VTBL_ENTRY _ZTI8S19012C2[];
extern  VTBL_ENTRY _ZTV8S19012C2[];
extern Class_Descriptor cd_S19012C9;
extern VTBL_ENTRY _ZTI8S19012C9[];
extern  VTBL_ENTRY _ZTV8S19012C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
extern Class_Descriptor cd_S19012C10;
extern VTBL_ENTRY _ZTI9S19012C10[];
extern  VTBL_ENTRY _ZTV9S19012C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C10[];
extern Class_Descriptor cd_S19012C8;
extern VTBL_ENTRY _ZTI8S19012C8[];
extern  VTBL_ENTRY _ZTV8S19012C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C8[];
extern Class_Descriptor cd_S19012C16;
extern VTBL_ENTRY _ZTI9S19012C16[];
extern  VTBL_ENTRY _ZTV9S19012C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19012C16[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C3;
extern VTBL_ENTRY _ZTI8S19012C3[];
extern  VTBL_ENTRY _ZTV8S19012C3[];
static Base_Class bases_S19012C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7576,4648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(7568,4644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(7568,4644), //bcp->offset
    69, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(15248,9476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8168,5028), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(8160,5024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(8160,5024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8616,5288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(8608,5284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(8608,5284), //bcp->offset
    101, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(8160,5024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(9400,5808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(9392,5804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(9392,5804), //bcp->offset
    108, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(8160,5024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(15304,9504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(15296,9500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(15296,9500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(15752,9764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(15744,9760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(15744,9760), //bcp->offset
    157, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(15296,9500), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(16536,10284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(16528,10280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(16528,10280), //bcp->offset
    164, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(15296,9500), //bcp->offset
    138, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(9848,6072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(9840,6068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10104,6224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(10096,6220), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10288,6352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10344,6380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(10336,6376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(10336,6376), //bcp->offset
    131, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C12,    ABISELECT(9840,6068), //bcp->offset
    116, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19012C7,    ABISELECT(8160,5024), //bcp->offset
    80, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(16984,10548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(16976,10544), //bcp->offset
    172, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S19012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(448,260), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19012C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S19012C13,    ABISELECT(1232,780), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1432,916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(1424,912), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(1424,912), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(17288,10740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(17280,10736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(17280,10736), //bcp->offset
    189, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    53, //immediately_derived
  0, 1},
  {&cd_S19012C17,    ABISELECT(17168,10676), //bcp->offset
    179, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    65, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(2024,1296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2472,1556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(2464,1552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19012C2,    ABISELECT(2464,1552), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19012C9,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(3256,2076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(3248,2072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19012C10,    ABISELECT(3248,2072), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19012C8,    ABISELECT(2016,1292), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7248,4456), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S19012C3,    ABISELECT(7240,4452), //bcp->offset
    62, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19012C1[];
extern void _ZN8S19012C1D1Ev();
extern void _ZN8S19012C1D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void ABISELECT(_ZThn448_N8S19012C1D1Ev,_ZThn260_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn448_N8S19012C1D0Ev,_ZThn260_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19012C1D1Ev,_ZThn780_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C1D0Ev,_ZThn780_N8S19012C1D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZThn1424_N8S19012C1D1Ev,_ZThn912_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn1424_N8S19012C1D0Ev,_ZThn912_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn2016_N8S19012C1D1Ev,_ZThn1292_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn2016_N8S19012C1D0Ev,_ZThn1292_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZThn2464_N8S19012C1D1Ev,_ZThn1552_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn2464_N8S19012C1D0Ev,_ZThn1552_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn3248_N8S19012C1D1Ev,_ZThn2072_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn3248_N8S19012C1D0Ev,_ZThn2072_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZThn7240_N8S19012C1D1Ev,_ZThn4452_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn7240_N8S19012C1D0Ev,_ZThn4452_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19012C1D1Ev,_ZTv0_n12_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn7568_N8S19012C1D1Ev,_ZThn4644_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C1D0Ev,_ZTv0_n12_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn7568_N8S19012C1D0Ev,_ZThn4644_N8S19012C1D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19012C1D1Ev,_ZTv0_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn8160_N8S19012C1D1Ev,_ZThn5024_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19012C1D0Ev,_ZTv0_n24_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn8160_N8S19012C1D0Ev,_ZThn5024_N8S19012C1D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZTvn448_n48_N8S19012C1D1Ev,_ZTvn260_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn448_n48_N8S19012C1D0Ev,_ZTvn260_n24_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1232_n48_N8S19012C1D1Ev,_ZTvn780_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn1232_n48_N8S19012C1D0Ev,_ZTvn780_n24_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1680_n48_N8S19012C1D1Ev,_ZTvn1044_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn1680_n48_N8S19012C1D0Ev,_ZTvn1044_n24_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1936_n48_N8S19012C1D1Ev,_ZTvn1196_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn1936_n48_N8S19012C1D0Ev,_ZTvn1196_n24_N8S19012C1D0Ev)();
extern void _ZN9S19012C132v7Ev();
extern void ABISELECT(_ZTvn2176_n48_N8S19012C1D1Ev,_ZTvn1352_n24_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn2176_n48_N8S19012C1D0Ev,_ZTvn1352_n24_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19012C1D1Ev,_ZTv0_n20_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn15296_N8S19012C1D1Ev,_ZThn9500_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19012C1D0Ev,_ZTv0_n20_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn15296_N8S19012C1D0Ev,_ZThn9500_N8S19012C1D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
extern void ABISELECT(_ZTvn448_n40_N8S19012C1D1Ev,_ZTvn260_n20_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S19012C1D0Ev,_ZTvn260_n20_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTvn1232_n40_N8S19012C1D1Ev,_ZTvn780_n20_N8S19012C1D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N8S19012C1D0Ev,_ZTvn780_n20_N8S19012C1D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19012C1D1Ev,_ZTv0_n12_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn16976_N8S19012C1D1Ev,_ZThn10544_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C1D0Ev,_ZTv0_n12_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn16976_N8S19012C1D0Ev,_ZThn10544_N8S19012C1D0Ev)() __attribute__((weak));
extern void _ZN9S19012C132v7Ev();
extern void _ZN9S19012C172v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S19012C1D1Ev,_ZTv0_n28_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn17168_N8S19012C1D1Ev,_ZThn10676_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19012C1D0Ev,_ZTv0_n28_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn17168_N8S19012C1D0Ev,_ZThn10676_N8S19012C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19012C1D1Ev,_ZTv0_n16_N8S19012C1D1Ev)();
extern void ABISELECT(_ZThn17280_N8S19012C1D1Ev,_ZThn10736_N8S19012C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19012C1D0Ev,_ZTv0_n16_N8S19012C1D0Ev)();
extern void ABISELECT(_ZThn17280_N8S19012C1D0Ev,_ZThn10736_N8S19012C1D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY vtc_S19012C1[] = {
  ABISELECT(15296,9500),
  ABISELECT(8160,5024),
  ABISELECT(7568,4644),
  ABISELECT(17280,10736),
  ABISELECT(16976,10544),
  ABISELECT(17168,10676),
  ABISELECT(15248,9476),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&_ZN8S19012C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C1D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C1D1Ev,_ZThn260_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19012C1D0Ev,_ZThn260_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C1D1Ev,_ZThn780_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C1D0Ev,_ZThn780_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-1424,-912),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N8S19012C1D1Ev,_ZThn912_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N8S19012C1D0Ev,_ZThn912_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(5552,3352),
  ABISELECT(13232,8184),
  ABISELECT(-2016,-1292),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N8S19012C1D1Ev,_ZThn1292_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N8S19012C1D0Ev,_ZThn1292_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-2464,-1552),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N8S19012C1D1Ev,_ZThn1552_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N8S19012C1D0Ev,_ZThn1552_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(12000,7404),
  ABISELECT(-3248,-2072),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N8S19012C1D1Ev,_ZThn2072_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N8S19012C1D0Ev,_ZThn2072_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-7240,-4452),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn7240_N8S19012C1D1Ev,_ZThn4452_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn7240_N8S19012C1D0Ev,_ZThn4452_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-7568,-4644),
  ABISELECT(-7568,-4644),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C1D1Ev,_ZTv0_n12_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C1D0Ev,_ZTv0_n12_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(1936,1196),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-8160,-5024),
  ABISELECT(7136,4476),
  ABISELECT(-592,-380),
  ABISELECT(7088,4452),
  ABISELECT(-8160,-5024),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19012C1D1Ev,_ZTv0_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19012C1D0Ev,_ZTv0_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-8608,-5284),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n48_N8S19012C1D1Ev,_ZTvn260_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n48_N8S19012C1D0Ev,_ZTvn260_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(5856,3672),
  ABISELECT(-9392,-5804),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n48_N8S19012C1D1Ev,_ZTvn780_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n48_N8S19012C1D0Ev,_ZTvn780_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(5408,3408),
  ABISELECT(-2272,-1424),
  ABISELECT(5456,3432),
  ABISELECT(-9840,-6068),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1680_n48_N8S19012C1D1Ev,_ZTvn1044_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1680_n48_N8S19012C1D0Ev,_ZTvn1044_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-10096,-6220),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1936_n48_N8S19012C1D1Ev,_ZTvn1196_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1936_n48_N8S19012C1D0Ev,_ZTvn1196_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-10336,-6376),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2176_n48_N8S19012C1D1Ev,_ZTvn1352_n24_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2176_n48_N8S19012C1D0Ev,_ZTvn1352_n24_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-15296,-9500),
  ABISELECT(-7728,-4856),
  ABISELECT(-48,-24),
  ABISELECT(-15296,-9500),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C1D1Ev,_ZTv0_n20_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C1D0Ev,_ZTv0_n20_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
  ABISELECT(-15744,-9760),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C1D1Ev,_ZTvn260_n20_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C1D0Ev,_ZTvn260_n20_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  ABISELECT(-1280,-804),
  ABISELECT(-16528,-10280),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C1D1Ev,_ZTvn780_n20_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C1D0Ev,_ZTvn780_n20_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  0,
  ABISELECT(-16976,-10544),
  ABISELECT(-16976,-10544),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C1D1Ev,_ZTv0_n12_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C1D0Ev,_ZTv0_n12_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
  ABISELECT(-17168,-10676),
  0,
  ABISELECT(-1920,-1200),
  ABISELECT(112,60),
  ABISELECT(-192,-132),
  ABISELECT(-17168,-10676),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19012C1D1Ev,_ZTv0_n28_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19012C1D0Ev,_ZTv0_n28_N8S19012C1D0Ev),
  0,
  0,
  0,
  ABISELECT(-17280,-10736),
  ABISELECT(-2032,-1260),
  ABISELECT(-17280,-10736),
  (VTBL_ENTRY)&(_ZTI8S19012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19012C1D1Ev,_ZTv0_n16_N8S19012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19012C1D0Ev,_ZTv0_n16_N8S19012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19012C1[];
extern void _ZN9S19012C16D1Ev();
extern void _ZN9S19012C16D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C16__8S19012C1[] = {
  ABISELECT(7568,4644),
  ABISELECT(17280,10736),
  ABISELECT(16976,10544),
  ABISELECT(17168,10676),
  ABISELECT(15248,9476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&_ZN9S19012C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C16D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C99S19012C16__A2__8S19012C1[] = {
  ABISELECT(15248,9476),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C99S19012C16__A4__8S19012C1[] = {
  ABISELECT(15248,9476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C89S19012C16__A2__8S19012C1[] = {
  ABISELECT(5552,3352),
  ABISELECT(13232,8184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C89S19012C16__A3__8S19012C1[] = {
  ABISELECT(13232,8184),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C89S19012C16__A6__8S19012C1[] = {
  ABISELECT(13232,8184),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C89S19012C16__A7__8S19012C1[] = {
  ABISELECT(12000,7404),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn5552_N8S19012C8D1Ev,_ZThn3352_N8S19012C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void ABISELECT(_ZThn5552_N8S19012C8D0Ev,_ZThn3352_N8S19012C8D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C89S19012C16__A2__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(-5552,-3352),
  ABISELECT(-5552,-3352),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C89S19012C16__A2__8S19012C1[] = {
  ABISELECT(12000,7404),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C172v8Ev();
extern void ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn17168_N9S19012C16D1Ev,_ZThn10676_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn17168_N9S19012C16D0Ev,_ZThn10676_N9S19012C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19012C17__9S19012C16__8S19012C1[] = {
  ABISELECT(-17168,-10676),
  0,
  ABISELECT(-1920,-1200),
  ABISELECT(112,60),
  ABISELECT(-192,-132),
  ABISELECT(-17168,-10676),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn16976_N9S19012C16D1Ev,_ZThn10544_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn16976_N9S19012C16D0Ev,_ZThn10544_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN9S19012C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C13__A1__9S19012C16__8S19012C1[] = {
  0,
  ABISELECT(-16976,-10544),
  ABISELECT(-16976,-10544),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn17280_N9S19012C16D1Ev,_ZThn10736_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn17280_N9S19012C16D0Ev,_ZThn10736_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__9S19012C16__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(-17280,-10736),
  ABISELECT(-2032,-1260),
  ABISELECT(-17280,-10736),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn2016_N9S19012C16D1Ev,_ZThn1292_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn2016_N9S19012C16D0Ev,_ZThn1292_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__9S19012C16__8S19012C1[] = {
  ABISELECT(5552,3352),
  ABISELECT(13232,8184),
  ABISELECT(-2016,-1292),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19012C16D1Ev,_ZThn1292_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19012C16D0Ev,_ZThn1292_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn7568_N9S19012C16D1Ev,_ZThn4644_N9S19012C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev)();
extern void ABISELECT(_ZThn7568_N9S19012C16D0Ev,_ZThn4644_N9S19012C16D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__A2__9S19012C16__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(-7568,-4644),
  ABISELECT(-7568,-4644),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn3248_N9S19012C16D1Ev,_ZThn2072_N9S19012C16D1Ev)();
extern void ABISELECT(_ZThn3248_N9S19012C16D0Ev,_ZThn2072_N9S19012C16D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A3__9S19012C16__8S19012C1[] = {
  ABISELECT(12000,7404),
  ABISELECT(-3248,-2072),
  (VTBL_ENTRY)&(_ZTI9S19012C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19012C16D1Ev,_ZThn2072_N9S19012C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19012C16D0Ev,_ZThn2072_N9S19012C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN8S19012C7D1Ev();
extern void _ZN8S19012C7D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C7__8S19012C1[] = {
  ABISELECT(7136,4476),
  ABISELECT(-592,-380),
  ABISELECT(7088,4452),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&_ZN8S19012C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C88S19012C7__8S19012C1[] = {
  ABISELECT(-592,-380),
  ABISELECT(7088,4452),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C88S19012C7__8S19012C1[] = {
  ABISELECT(7088,4452),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C88S19012C7__8S19012C1[] = {
  ABISELECT(7088,4452),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C88S19012C7__A1__8S19012C1[] = {
  ABISELECT(5856,3672),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C88S19012C7__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(592,380),
  ABISELECT(592,380),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C88S19012C7__8S19012C1[] = {
  ABISELECT(5856,3672),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C12D1Ev();
extern void _ZN9S19012C12D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C128S19012C7__8S19012C1[] = {
  ABISELECT(5408,3408),
  ABISELECT(-2272,-1424),
  ABISELECT(5456,3432),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&_ZN9S19012C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZThn5456_N9S19012C12D1Ev,_ZThn3432_N9S19012C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev)();
extern void ABISELECT(_ZThn5456_N9S19012C12D0Ev,_ZThn3432_N9S19012C12D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__9S19012C128S19012C7__8S19012C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-5456,-3432),
  ABISELECT(-7728,-4856),
  ABISELECT(-48,-24),
  ABISELECT(-5456,-3432),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__9S19012C128S19012C7__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(2272,1424),
  ABISELECT(2272,1424),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D1Ev,_ZTv0_n12_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C12D0Ev,_ZTv0_n12_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C28S19012C98S19012C8__A1__9S19012C128S19012C7__8S19012C1[] = {
  ABISELECT(-5904,-3692),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D1Ev,_ZTvn260_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19012C12D0Ev,_ZTvn260_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A1__9S19012C128S19012C7__8S19012C1[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-6688,-4212),
  (VTBL_ENTRY)&(_ZTI9S19012C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D1Ev,_ZTvn780_n20_N9S19012C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19012C12D0Ev,_ZTvn780_n20_N9S19012C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C7D1Ev,_ZTv0_n12_N8S19012C7D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19012C7D0Ev,_ZTv0_n12_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C7__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(592,380),
  ABISELECT(592,380),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C7D1Ev,_ZTv0_n12_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C7D0Ev,_ZTv0_n12_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C7D1Ev,_ZThn780_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C7D0Ev,_ZThn780_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A1__8S19012C7__8S19012C1[] = {
  ABISELECT(5856,3672),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C7D1Ev,_ZThn780_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C7D0Ev,_ZThn780_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1680_N8S19012C7D1Ev,_ZThn1044_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19012C7D0Ev,_ZThn1044_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C12__8S19012C7__8S19012C1[] = {
  ABISELECT(5408,3408),
  ABISELECT(-2272,-1424),
  ABISELECT(5456,3432),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19012C7D1Ev,_ZThn1044_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19012C7D0Ev,_ZThn1044_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZThn7136_N8S19012C7D1Ev,_ZThn4476_N8S19012C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev)();
extern void ABISELECT(_ZThn7136_N8S19012C7D0Ev,_ZThn4476_N8S19012C7D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__A1__8S19012C7__8S19012C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-7136,-4476),
  ABISELECT(-7728,-4856),
  ABISELECT(-48,-24),
  ABISELECT(-7136,-4476),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void ABISELECT(_ZTvn448_n40_N8S19012C7D1Ev,_ZTvn260_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S19012C7D0Ev,_ZTvn260_n20_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C28S19012C98S19012C8__A2__8S19012C7__8S19012C1[] = {
  ABISELECT(-7584,-4736),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C7D1Ev,_ZTvn260_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19012C7D0Ev,_ZTvn260_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTvn1232_n40_N8S19012C7D1Ev,_ZTvn780_n20_N8S19012C7D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N8S19012C7D0Ev,_ZTvn780_n20_N8S19012C7D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A3__8S19012C7__8S19012C1[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-8368,-5256),
  (VTBL_ENTRY)&(_ZTI8S19012C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C7D1Ev,_ZTvn780_n20_N8S19012C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19012C7D0Ev,_ZTvn780_n20_N8S19012C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN8S19012C8D1Ev();
extern void _ZN8S19012C8D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
extern void _ZN8S19012C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C8__A1__8S19012C1[] = {
  ABISELECT(-7728,-4856),
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&_ZN8S19012C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19012C82v6Ev,
};
extern void _ZN8S19012C9D1Ev();
extern void _ZN8S19012C9D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
extern void _ZN8S19012C92v4Ev();
extern void _ZN8S19012C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C98S19012C8__A1__8S19012C1[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19012C9[0]),
  (VTBL_ENTRY)&_ZN8S19012C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19012C92v5Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C98S19012C8__A2__8S19012C1[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C108S19012C8__A3__8S19012C1[] = {
  ABISELECT(-1280,-804),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19012C2__8S19012C8__A1__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(7728,4856),
  ABISELECT(7728,4856),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev)();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A1__8S19012C8__A1__8S19012C1[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19012C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D1Ev,_ZThn780_N8S19012C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19012C8D0Ev,_ZThn780_N8S19012C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C172v8Ev();
extern void _ZN9S19012C17D1Ev();
extern void _ZN9S19012C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C17__8S19012C1[] = {
  ABISELECT(-1920,-1200),
  ABISELECT(112,60),
  ABISELECT(-192,-132),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&_ZN9S19012C172v8Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev)();
extern void _ZN9S19012C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C13__9S19012C17__8S19012C1[] = {
  0,
  ABISELECT(192,132),
  ABISELECT(192,132),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D1Ev,_ZTv0_n12_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19012C17D0Ev,_ZTv0_n12_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19012C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev)();
extern void ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev)() __attribute__((weak));
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__9S19012C17__8S19012C1[] = {
  0,
  0,
  0,
  ABISELECT(-112,-60),
  ABISELECT(-2032,-1260),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S19012C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
extern void _ZN9S19012C10D1Ev();
extern void _ZN9S19012C10D0Ev();
extern void _ZN8S19012C32v1Ev();
extern void _ZN8S19012C32v2Ev();
extern void _ZN8S19012C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19012C10__A5__8S19012C1[] = {
  ABISELECT(-2032,-1260),
  0,
  (VTBL_ENTRY)&(_ZTI9S19012C10[0]),
  (VTBL_ENTRY)&_ZN9S19012C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19012C32v3Ev,
};
static  VTT_ENTRY vtt_S19012C1[] = {
  {&(_ZTV8S19012C1[9]),  9,201},
  {&(_tg__ZTV9S19012C16__8S19012C1[7]),  7,14},
  {&(_tg__ZTV8S19012C99S19012C16__A2__8S19012C1[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C99S19012C16__A4__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C89S19012C16__A2__8S19012C1[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C89S19012C16__A3__8S19012C1[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C89S19012C16__A6__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C89S19012C16__A7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C89S19012C16__A2__8S19012C1[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C89S19012C16__A2__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C17__9S19012C16__8S19012C1[7]),  7,10},
  {&(_tg__ZTV9S19012C13__A1__9S19012C16__8S19012C1[4]),  4,7},
  {&(_tg__ZTV9S19012C10__A1__9S19012C16__8S19012C1[7]),  7,12},
  {&(_tg__ZTV8S19012C8__9S19012C16__8S19012C1[4]),  4,12},
  {&(_tg__ZTV8S19012C2__A2__9S19012C16__8S19012C1[6]),  6,11},
  {&(_tg__ZTV9S19012C108S19012C8__A3__9S19012C16__8S19012C1[3]),  3,8},
  {&(_ZTV8S19012C1[75]),  75,201},
  {&(_ZTV8S19012C1[93]),  93,201},
  {&(_ZTV8S19012C1[103]),  103,201},
  {&(_ZTV8S19012C1[111]),  111,201},
  {&(_ZTV8S19012C1[121]),  121,201},
  {&(_ZTV8S19012C1[149]),  149,201},
  {&(_ZTV8S19012C1[159]),  159,201},
  {&(_ZTV8S19012C1[167]),  167,201},
  {&(_ZTV8S19012C1[128]),  128,201},
  {&(_ZTV8S19012C1[133]),  133,201},
  {&(_ZTV8S19012C1[176]),  176,201},
  {&(_ZTV8S19012C1[186]),  186,201},
  {&(_ZTV8S19012C1[196]),  196,201},
  {&(_ZTV8S19012C1[39]),  39,201},
  {&(_ZTV8S19012C1[57]),  57,201},
  {&(_tg__ZTV8S19012C7__8S19012C1[5]),  5,13},
  {&(_tg__ZTV8S19012C88S19012C7__8S19012C1[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C88S19012C7__8S19012C1[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C88S19012C7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C88S19012C7__A1__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C88S19012C7__8S19012C1[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C88S19012C7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C128S19012C7__8S19012C1[5]),  5,10},
  {&(_tg__ZTV8S19012C8__9S19012C128S19012C7__8S19012C1[11]),  11,19},
  {&(_tg__ZTV8S19012C2__9S19012C128S19012C7__8S19012C1[6]),  6,11},
  {&(_tg__ZTV8S19012C28S19012C98S19012C8__A1__9S19012C128S19012C7__8S19012C1[2]),  2,7},
  {&(_tg__ZTV9S19012C108S19012C8__A1__9S19012C128S19012C7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C7__8S19012C1[6]),  6,11},
  {&(_tg__ZTV9S19012C108S19012C8__A1__8S19012C7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C12__8S19012C7__8S19012C1[5]),  5,10},
  {&(_tg__ZTV8S19012C8__A1__8S19012C7__8S19012C1[11]),  11,19},
  {&(_tg__ZTV8S19012C28S19012C98S19012C8__A2__8S19012C7__8S19012C1[2]),  2,7},
  {&(_tg__ZTV9S19012C108S19012C8__A3__8S19012C7__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C8__A1__8S19012C1[4]),  4,12},
  {&(_tg__ZTV8S19012C98S19012C8__A1__8S19012C1[3]),  3,10},
  {&(_tg__ZTV9S19012C108S19012C98S19012C8__A2__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C108S19012C8__A3__8S19012C1[3]),  3,8},
  {&(_tg__ZTV8S19012C2__8S19012C8__A1__8S19012C1[6]),  6,11},
  {&(_tg__ZTV9S19012C10__A1__8S19012C8__A1__8S19012C1[3]),  3,8},
  {&(_tg__ZTV9S19012C17__8S19012C1[5]),  5,8},
  {&(_tg__ZTV9S19012C13__9S19012C17__8S19012C1[4]),  4,7},
  {&(_tg__ZTV9S19012C10__9S19012C17__8S19012C1[7]),  7,12},
  {&(_tg__ZTV9S19012C10__A5__8S19012C1[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S19012C1[];
extern  VTBL_ENTRY _ZTV8S19012C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19012C1[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D0Ev,_ZTv0_n16_N9S19012C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D0Ev,_ZThn60_N9S19012C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C17D1Ev,_ZTv0_n16_N9S19012C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19012C17D1Ev,_ZThn60_N9S19012C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C7D0Ev,_ZTv0_n20_N8S19012C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7136_N8S19012C7D0Ev,_ZThn4476_N8S19012C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C7D1Ev,_ZTv0_n20_N8S19012C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7136_N8S19012C7D1Ev,_ZThn4476_N8S19012C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D0Ev,_ZTv0_n20_N9S19012C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5456_N9S19012C12D0Ev,_ZThn3432_N9S19012C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19012C12D1Ev,_ZTv0_n20_N9S19012C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5456_N9S19012C12D1Ev,_ZThn3432_N9S19012C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C16D0Ev,_ZTv0_n16_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17280_N9S19012C16D0Ev,_ZThn10736_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19012C16D1Ev,_ZTv0_n16_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17280_N9S19012C16D1Ev,_ZThn10736_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C16D0Ev,_ZTv0_n12_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7568_N9S19012C16D0Ev,_ZThn4644_N9S19012C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16976_N9S19012C16D0Ev,_ZThn10544_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19012C16D1Ev,_ZTv0_n12_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7568_N9S19012C16D1Ev,_ZThn4644_N9S19012C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16976_N9S19012C16D1Ev,_ZThn10544_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19012C16D0Ev,_ZTv0_n28_N9S19012C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17168_N9S19012C16D0Ev,_ZThn10676_N9S19012C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19012C16D1Ev,_ZTv0_n28_N9S19012C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17168_N9S19012C16D1Ev,_ZThn10676_N9S19012C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D0Ev,_ZTv0_n12_N8S19012C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5552_N8S19012C8D0Ev,_ZThn3352_N8S19012C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C8D1Ev,_ZTv0_n12_N8S19012C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5552_N8S19012C8D1Ev,_ZThn3352_N8S19012C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19012C1D0Ev,_ZTv0_n16_N8S19012C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17280_N8S19012C1D0Ev,_ZThn10736_N8S19012C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19012C1D1Ev,_ZTv0_n16_N8S19012C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17280_N8S19012C1D1Ev,_ZThn10736_N8S19012C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19012C1D0Ev,_ZTv0_n28_N8S19012C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17168_N8S19012C1D0Ev,_ZThn10676_N8S19012C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19012C1D1Ev,_ZTv0_n28_N8S19012C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17168_N8S19012C1D1Ev,_ZThn10676_N8S19012C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C1D0Ev,_ZTv0_n20_N8S19012C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15296_N8S19012C1D0Ev,_ZThn9500_N8S19012C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19012C1D1Ev,_ZTv0_n20_N8S19012C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15296_N8S19012C1D1Ev,_ZThn9500_N8S19012C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19012C1D0Ev,_ZTv0_n24_N8S19012C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8160_N8S19012C1D0Ev,_ZThn5024_N8S19012C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19012C1D1Ev,_ZTv0_n24_N8S19012C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8160_N8S19012C1D1Ev,_ZThn5024_N8S19012C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C1D0Ev,_ZTv0_n12_N8S19012C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16976_N8S19012C1D0Ev,_ZThn10544_N8S19012C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7568_N8S19012C1D0Ev,_ZThn4644_N8S19012C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19012C1D1Ev,_ZTv0_n12_N8S19012C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16976_N8S19012C1D1Ev,_ZThn10544_N8S19012C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7568_N8S19012C1D1Ev,_ZThn4644_N8S19012C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19012C1 = {  "S19012C1", // class name
  bases_S19012C1, 68,
  &(vtc_S19012C1[0]), // expected_vtbl_contents
  &(vtt_S19012C1[0]), // expected_vtt_contents
  ABISELECT(17728,10996), // object size
  NSPAIRA(_ZTI8S19012C1),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19012C1),201, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19012C1),59, //virtual table table var
  46, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C3  : S19012C4 {
  ::S19012C4 s19011c3f0;
  ::S19012C4 s19011c3f1;
  ::S19012C4 s19011c3f2[3];
  void *s19011c3f3;
  virtual  ~S19011C3(); // _ZN8S19011C3D1Ev
  virtual void  v1(); // _ZN8S19011C32v1Ev
  virtual void  v2(); // _ZN8S19011C32v2Ev
  virtual void  v3(); // _ZN8S19011C32v3Ev
  S19011C3(); // tgen
};
//SIG(-1 S19011C3) C1{ BC2{ m Fl FL Fp[3]} vd v1 v2 v3 FC2 FC2 FC2[3] Fp}


 S19011C3 ::~S19011C3(){ note_dtor("S19011C3", this);}
void  S19011C3 ::v1(){vfunc_called(this, "_ZN8S19011C32v1Ev");}
void  S19011C3 ::v2(){vfunc_called(this, "_ZN8S19011C32v2Ev");}
void  S19011C3 ::v3(){vfunc_called(this, "_ZN8S19011C32v3Ev");}
S19011C3 ::S19011C3(){ note_ctor("S19011C3", this);} // tgen

static void Test_S19011C3()
{
  extern Class_Descriptor cd_S19011C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,39)];
    init_test(&cd_S19011C3, buf);
    S19011C3 *dp, &lv = *(dp=new (buf) S19011C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,152), "sizeof(S19011C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19011C3)");
    check_base_class_offset(lv, (S19012C4*), ABISELECT(8,4), "S19011C3");
    check_field_offset(lv, s19011c3f0, ABISELECT(48,28), "S19011C3.s19011c3f0");
    check_field_offset(lv, s19011c3f1, ABISELECT(88,52), "S19011C3.s19011c3f1");
    check_field_offset(lv, s19011c3f2, ABISELECT(128,76), "S19011C3.s19011c3f2");
    check_field_offset(lv, s19011c3f3, ABISELECT(248,148), "S19011C3.s19011c3f3");
    test_class_info(&lv, &cd_S19011C3);
    dp->~S19011C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C3(Test_S19011C3, "S19011C3", ABISELECT(256,152));

#else // __cplusplus

extern void _ZN8S19011C3C1Ev();
extern void _ZN8S19011C3D1Ev();
Name_Map name_map_S19011C3[] = {
  NSPAIR(_ZN8S19011C3C1Ev),
  NSPAIR(_ZN8S19011C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19011C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C3[];
extern void _ZN8S19011C3D1Ev();
extern void _ZN8S19011C3D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C3[0]),
  (VTBL_ENTRY)&_ZN8S19011C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
Class_Descriptor cd_S19011C3 = {  "S19011C3", // class name
  bases_S19011C3, 1,
  &(vtc_S19011C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,152), // object size
  NSPAIRA(_ZTI8S19011C3),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19011C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C2  : S19011C3 {
  ::S19012C4 s19011c2f0;
  int s19011c2f1;
  ::S19012C4 s19011c2f2;
  void *s19011c2f3;
  ::S19012C5_nt s19011c2f4;
  ::S19012C6 s19011c2f5;
  ::S19012C6 s19011c2f6;
  ~S19011C2(); // tgen
  S19011C2(); // tgen
};
//SIG(-1 S19011C2) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v1 v2 v3 FC3 FC3 FC3[3] Fp} FC3 Fi FC3 Fp FU4{ m} FU5{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU5}


S19011C2 ::~S19011C2(){ note_dtor("S19011C2", this);} // tgen
S19011C2 ::S19011C2(){ note_ctor("S19011C2", this);} // tgen

static void Test_S19011C2()
{
  extern Class_Descriptor cd_S19011C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(38,96)];
    init_test(&cd_S19011C2, buf);
    S19011C2 *dp, &lv = *(dp=new (buf) S19011C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(592,380), "sizeof(S19011C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C2)");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(8,4), "S19011C2");
    check_base_class_offset(lv, (S19011C3*), 0, "S19011C2");
    check_field_offset(lv, s19011c2f0, ABISELECT(256,152), "S19011C2.s19011c2f0");
    check_field_offset(lv, s19011c2f1, ABISELECT(296,176), "S19011C2.s19011c2f1");
    check_field_offset(lv, s19011c2f2, ABISELECT(304,180), "S19011C2.s19011c2f2");
    check_field_offset(lv, s19011c2f3, ABISELECT(344,204), "S19011C2.s19011c2f3");
    check_field_offset(lv, s19011c2f4, ABISELECT(352,208), "S19011C2.s19011c2f4");
    check_field_offset(lv, s19011c2f5, ABISELECT(368,212), "S19011C2.s19011c2f5");
    check_field_offset(lv, s19011c2f6, ABISELECT(480,296), "S19011C2.s19011c2f6");
    test_class_info(&lv, &cd_S19011C2);
    dp->~S19011C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C2(Test_S19011C2, "S19011C2", ABISELECT(592,380));

#else // __cplusplus

extern void _ZN8S19011C2C1Ev();
extern void _ZN8S19011C2D1Ev();
Name_Map name_map_S19011C2[] = {
  NSPAIR(_ZN8S19011C2C1Ev),
  NSPAIR(_ZN8S19011C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
static Base_Class bases_S19011C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C2[];
extern void _ZN8S19011C2D1Ev();
extern void _ZN8S19011C2D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C2[0]),
  (VTBL_ENTRY)&_ZN8S19011C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
Class_Descriptor cd_S19011C2 = {  "S19011C2", // class name
  bases_S19011C2, 2,
  &(vtc_S19011C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(592,380), // object size
  NSPAIRA(_ZTI8S19011C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19011C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C10  : S19011C3 , virtual S19012C4 {
  short s19011c10f0;
  long double s19011c10f1;
  void *s19011c10f2[2];
  __tsi64 s19011c10f3;
  ::S19012C4 s19011c10f4;
  void *s19011c10f5[6];
  int s19011c10f6;
  void *s19011c10f7;
  ::S19012C11_nt s19011c10f8[10];
  ::S19012C11_nt s19011c10f9[4];
  int s19011c10f10;
  virtual  ~S19011C10(); // _ZN9S19011C10D2Ev
  S19011C10(); // tgen
};
//SIG(-1 S19011C10) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v1 v2 v3 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC4{}[10] FC4[4] Fi}


 S19011C10 ::~S19011C10(){ note_dtor("S19011C10", this);}
S19011C10 ::S19011C10(){ note_ctor("S19011C10", this);} // tgen

static void Test_S19011C10()
{
  extern Class_Descriptor cd_S19011C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(31,72)];
    init_test(&cd_S19011C10, buf);
    S19011C10 *dp, &lv = *(dp=new (buf) S19011C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,284), "sizeof(S19011C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C10)");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(8,4), "S19011C10");
    check_base_class_offset(lv, (S19011C3*), 0, "S19011C10");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(440,260), "S19011C10");
    check_field_offset(lv, s19011c10f0, ABISELECT(256,152), "S19011C10.s19011c10f0");
    check_field_offset(lv, s19011c10f1, ABISELECT(272,156), "S19011C10.s19011c10f1");
    check_field_offset(lv, s19011c10f2, ABISELECT(288,168), "S19011C10.s19011c10f2");
    check_field_offset(lv, s19011c10f3, ABISELECT(304,176), "S19011C10.s19011c10f3");
    check_field_offset(lv, s19011c10f4, ABISELECT(312,184), "S19011C10.s19011c10f4");
    check_field_offset(lv, s19011c10f5, ABISELECT(352,208), "S19011C10.s19011c10f5");
    check_field_offset(lv, s19011c10f6, ABISELECT(400,232), "S19011C10.s19011c10f6");
    check_field_offset(lv, s19011c10f7, ABISELECT(408,236), "S19011C10.s19011c10f7");
    check_field_offset(lv, s19011c10f8, ABISELECT(416,240), "S19011C10.s19011c10f8");
    check_field_offset(lv, s19011c10f9, ABISELECT(426,250), "S19011C10.s19011c10f9");
    check_field_offset(lv, s19011c10f10, ABISELECT(432,256), "S19011C10.s19011c10f10");
    test_class_info(&lv, &cd_S19011C10);
    dp->~S19011C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C10(Test_S19011C10, "S19011C10", ABISELECT(480,284));

#else // __cplusplus

extern void _ZN9S19011C10C1Ev();
extern void _ZN9S19011C10D2Ev();
Name_Map name_map_S19011C10[] = {
  NSPAIR(_ZN9S19011C10C1Ev),
  NSPAIR(_ZN9S19011C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19011C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(440,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C10[];
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C10[] = {
  ABISELECT(440,260),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C10[];
static  VTT_ENTRY vtt_S19011C10[] = {
  {&(_ZTV9S19011C10[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
Class_Descriptor cd_S19011C10 = {  "S19011C10", // class name
  bases_S19011C10, 3,
  &(vtc_S19011C10[0]), // expected_vtbl_contents
  &(vtt_S19011C10[0]), // expected_vtt_contents
  ABISELECT(480,284), // object size
  NSPAIRA(_ZTI9S19011C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19011C10),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C10),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C9  : virtual S19012C4 , S19011C10 , S19011C2 {
  long double s19011c9f0;
  char s19011c9f1[8];
  ::S19012C6 s19011c9f2;
  int s19011c9f3;
  int s19011c9f4;
  ::S19012C11_nt s19011c9f5;
  long double s19011c9f6;
  long double s19011c9f7;
  virtual  ~S19011C9(); // _ZN8S19011C9D2Ev
  virtual void  v4(); // _ZN8S19011C92v4Ev
  virtual void  v5(); // _ZN8S19011C92v5Ev
  S19011C9(); // tgen
};
//SIG(-1 S19011C9) C1{ VBC2{ m Fl FL Fp[3]} BC3{ BC4{ BC2 vd v3 v4 v5 FC2 FC2 FC2[3] Fp} VBC2 vd Fs FD Fp[2] FL FC2 Fp[6] Fi Fp FC5{}[10] FC5[4] Fi} BC6{ BC4 FC2 Fi FC2 Fp FU7{ m} FU8{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU8} vd v1 v2 FD Fc[8] FU8 Fi Fi FC5 FD FD}


 S19011C9 ::~S19011C9(){ note_dtor("S19011C9", this);}
void  S19011C9 ::v4(){vfunc_called(this, "_ZN8S19011C92v4Ev");}
void  S19011C9 ::v5(){vfunc_called(this, "_ZN8S19011C92v5Ev");}
S19011C9 ::S19011C9(){ note_ctor("S19011C9", this);} // tgen

static void Test_S19011C9()
{
  extern Class_Descriptor cd_S19011C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(81,202)];
    init_test(&cd_S19011C9, buf);
    S19011C9 *dp, &lv = *(dp=new (buf) S19011C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1280,804), "sizeof(S19011C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C9)");
    /*is_ambiguous_... S19011C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(1232,780), "S19011C9");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(1232,780), "S19011C9");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(8,4), "S19011C9");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*), 0, "S19011C9");
    check_base_class_offset(lv, (S19011C10*), 0, "S19011C9");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(456,264), "S19011C9");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(448,260), "S19011C9");
    check_base_class_offset(lv, (S19011C2*), ABISELECT(448,260), "S19011C9");
    check_field_offset(lv, s19011c9f0, ABISELECT(1040,640), "S19011C9.s19011c9f0");
    check_field_offset(lv, s19011c9f1, ABISELECT(1056,652), "S19011C9.s19011c9f1");
    check_field_offset(lv, s19011c9f2, ABISELECT(1072,660), "S19011C9.s19011c9f2");
    check_field_offset(lv, s19011c9f3, ABISELECT(1184,744), "S19011C9.s19011c9f3");
    check_field_offset(lv, s19011c9f4, ABISELECT(1188,748), "S19011C9.s19011c9f4");
    check_field_offset(lv, s19011c9f5, ABISELECT(1192,752), "S19011C9.s19011c9f5");
    check_field_offset(lv, s19011c9f6, ABISELECT(1200,756), "S19011C9.s19011c9f6");
    check_field_offset(lv, s19011c9f7, ABISELECT(1216,768), "S19011C9.s19011c9f7");
    test_class_info(&lv, &cd_S19011C9);
    dp->~S19011C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C9(Test_S19011C9, "S19011C9", ABISELECT(1280,804));

#else // __cplusplus

extern void _ZN8S19011C9C1Ev();
extern void _ZN8S19011C9D2Ev();
Name_Map name_map_S19011C9[] = {
  NSPAIR(_ZN8S19011C9C1Ev),
  NSPAIR(_ZN8S19011C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
static Base_Class bases_S19011C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(448,260), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C9[];
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void ABISELECT(_ZThn448_N8S19011C9D1Ev,_ZThn260_N8S19011C9D1Ev)();
extern void ABISELECT(_ZThn448_N8S19011C9D0Ev,_ZThn260_N8S19011C9D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C9[] = {
  ABISELECT(1232,780),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C9D1Ev,_ZThn260_N8S19011C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C9D0Ev,_ZThn260_N8S19011C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19011C9[];
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__8S19011C9[] = {
  ABISELECT(1232,780),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C9[] = {
  {&(_ZTV8S19011C9[3]),  3,17},
  {&(_tg__ZTV9S19011C10__8S19011C9[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
Class_Descriptor cd_S19011C9 = {  "S19011C9", // class name
  bases_S19011C9, 7,
  &(vtc_S19011C9[0]), // expected_vtbl_contents
  &(vtt_S19011C9[0]), // expected_vtt_contents
  ABISELECT(1280,804), // object size
  NSPAIRA(_ZTI8S19011C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19011C9),17, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19011C9),2, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C8  : virtual S19011C2 , virtual S19012C4 , S19011C9 , S19011C10 {
  ::S19012C5_nt s19011c8f0;
  char s19011c8f1;
  virtual  ~S19011C8(); // _ZN8S19011C8D2Ev
  virtual void  v6(); // _ZN8S19011C82v6Ev
  S19011C8(); // tgen
};
//SIG(-1 S19011C8) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v2 v3 v4 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC4 BC7{ VBC4 BC8{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC9{}[10] FC9[4] Fi} BC2 vd v5 v6 FD Fc[8] FU6 Fi Fi FC9 FD FD} BC8 vd v1 FU5 Fc}


 S19011C8 ::~S19011C8(){ note_dtor("S19011C8", this);}
void  S19011C8 ::v6(){vfunc_called(this, "_ZN8S19011C82v6Ev");}
S19011C8 ::S19011C8(){ note_ctor("S19011C8", this);} // tgen

static void Test_S19011C8()
{
  extern Class_Descriptor cd_S19011C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(146,363)];
    init_test(&cd_S19011C8, buf);
    S19011C8 *dp, &lv = *(dp=new (buf) S19011C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2320,1448), "sizeof(S19011C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C8)");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(1688,1048), "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(1680,1044), "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*), ABISELECT(1680,1044), "S19011C8");
    /*is_ambiguous_... S19011C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(2272,1424), "S19011C8");
    /*is_ambiguous_... S19011C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*), ABISELECT(2272,1424), "S19011C8");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*), ABISELECT(2272,1424), "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(2272,1424), "S19011C8");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*), ABISELECT(8,4), "S19011C8");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*), 0, "S19011C8");
    check_base_class_offset(lv, (S19011C10*)(S19011C9*), 0, "S19011C8");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*), ABISELECT(456,264), "S19011C8");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*), ABISELECT(448,260), "S19011C8");
    check_base_class_offset(lv, (S19011C2*)(S19011C9*), ABISELECT(448,260), "S19011C8");
    check_base_class_offset(lv, (S19011C9*), 0, "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(1240,784), "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*), ABISELECT(1232,780), "S19011C8");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C10*), ABISELECT(1232,780), "S19011C8");
    check_field_offset(lv, s19011c8f0, ABISELECT(1668,1040), "S19011C8.s19011c8f0");
    check_field_offset(lv, s19011c8f1, ABISELECT(1669,1041), "S19011C8.s19011c8f1");
    test_class_info(&lv, &cd_S19011C8);
    dp->~S19011C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C8(Test_S19011C8, "S19011C8", ABISELECT(2320,1448));

#else // __cplusplus

extern void _ZN8S19011C8C1Ev();
extern void _ZN8S19011C8D2Ev();
Name_Map name_map_S19011C8[] = {
  NSPAIR(_ZN8S19011C8C1Ev),
  NSPAIR(_ZN8S19011C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
static Base_Class bases_S19011C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(1688,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1680,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(1680,1044), //bcp->offset
    27, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(2272,1424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(448,260), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(1232,780), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C8[];
extern void _ZN8S19011C8D1Ev();
extern void _ZN8S19011C8D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZThn448_N8S19011C8D1Ev,_ZThn260_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S19011C8D0Ev,_ZThn260_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19011C8D1Ev,_ZThn1044_N8S19011C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev)();
extern void ABISELECT(_ZThn1680_N8S19011C8D0Ev,_ZThn1044_N8S19011C8D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C8[] = {
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&_ZN8S19011C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C8D1Ev,_ZThn260_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C8D0Ev,_ZThn260_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(1040,644),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1680,-1044),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19011C8[];
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C9__8S19011C8[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C9__8S19011C8[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__8S19011C8[] = {
  ABISELECT(1040,644),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C8[] = {
  {&(_ZTV8S19011C8[4]),  4,38},
  {&(_tg__ZTV8S19011C9__8S19011C8[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C9__8S19011C8[3]),  3,8},
  {&(_tg__ZTV9S19011C10__A1__8S19011C8[3]),  3,8},
  {&(_ZTV8S19011C8[33]),  33,38},
  {&(_ZTV8S19011C8[22]),  22,38},
};
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19011C8D0Ev,_ZThn1044_N8S19011C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19011C8D1Ev,_ZThn1044_N8S19011C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C8 = {  "S19011C8", // class name
  bases_S19011C8, 14,
  &(vtc_S19011C8[0]), // expected_vtbl_contents
  &(vtt_S19011C8[0]), // expected_vtt_contents
  ABISELECT(2320,1448), // object size
  NSPAIRA(_ZTI8S19011C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19011C8),38, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19011C8),6, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C13  : S19012C4 {
  ::S19012C6 s19011c13f0;
  char s19011c13f1[5];
  long double s19011c13f2;
  virtual  ~S19011C13(); // _ZN9S19011C13D1Ev
  virtual void  v7(); // _ZN9S19011C132v7Ev
  S19011C13(); // tgen
};
//SIG(-1 S19011C13) C1{ BC2{ m Fl FL Fp[3]} vd v1 FU3{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD}


 S19011C13 ::~S19011C13(){ note_dtor("S19011C13", this);}
void  S19011C13 ::v7(){vfunc_called(this, "_ZN9S19011C132v7Ev");}
S19011C13 ::S19011C13(){ note_ctor("S19011C13", this);} // tgen

static void Test_S19011C13()
{
  extern Class_Descriptor cd_S19011C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,34)];
    init_test(&cd_S19011C13, buf);
    S19011C13 *dp, &lv = *(dp=new (buf) S19011C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S19011C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C13)");
    check_base_class_offset(lv, (S19012C4*), ABISELECT(8,4), "S19011C13");
    check_field_offset(lv, s19011c13f0, ABISELECT(48,28), "S19011C13.s19011c13f0");
    check_field_offset(lv, s19011c13f1, ABISELECT(160,112), "S19011C13.s19011c13f1");
    check_field_offset(lv, s19011c13f2, ABISELECT(176,120), "S19011C13.s19011c13f2");
    test_class_info(&lv, &cd_S19011C13);
    dp->~S19011C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C13(Test_S19011C13, "S19011C13", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN9S19011C13C1Ev();
extern void _ZN9S19011C13D1Ev();
Name_Map name_map_S19011C13[] = {
  NSPAIR(_ZN9S19011C13C1Ev),
  NSPAIR(_ZN9S19011C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19011C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C13[];
extern void _ZN9S19011C13D1Ev();
extern void _ZN9S19011C13D0Ev();
extern void _ZN9S19011C132v7Ev();
static  VTBL_ENTRY vtc_S19011C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C13[0]),
  (VTBL_ENTRY)&_ZN9S19011C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
};
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
Class_Descriptor cd_S19011C13 = {  "S19011C13", // class name
  bases_S19011C13, 1,
  &(vtc_S19011C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S19011C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19011C13),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C15  : virtual S19011C2 , virtual S19012C4 , S19011C10 , virtual S19011C3 , S19011C13 {
  int s19011c15f0;
  ::S19012C11_nt s19011c15f1;
  ::S19012C11_nt s19011c15f2;
  ::S19012C11_nt s19011c15f3;
  ::S19012C11_nt s19011c15f4;
  int s19011c15f5;
  virtual void  v10(); // _ZN9S19011C153v10Ev
  virtual void  v11(); // _ZN9S19011C153v11Ev
  ~S19011C15(); // tgen
  S19011C15(); // tgen
};
//SIG(-1 S19011C15) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v3 v4 v5 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC4 BC7{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC8{}[10] FC8[4] Fi} VBC3 BC9{ BC4 vd v6 FU6 Fc[5] FD} v1 v2 Fi FC8 FC8 FC8 FC8 Fi}


void  S19011C15 ::v10(){vfunc_called(this, "_ZN9S19011C153v10Ev");}
void  S19011C15 ::v11(){vfunc_called(this, "_ZN9S19011C153v11Ev");}
S19011C15 ::~S19011C15(){ note_dtor("S19011C15", this);} // tgen
S19011C15 ::S19011C15(){ note_ctor("S19011C15", this);} // tgen

static void Test_S19011C15()
{
  extern Class_Descriptor cd_S19011C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(98,241)];
    init_test(&cd_S19011C15, buf);
    S19011C15 *dp, &lv = *(dp=new (buf) S19011C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1552,960), "sizeof(S19011C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C15)");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(664,408), "S19011C15");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(656,404), "S19011C15");
    check_base_class_offset(lv, (S19011C2*), ABISELECT(656,404), "S19011C15");
    /*is_ambiguous_... S19011C15::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(1248,784), "S19011C15");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(1248,784), "S19011C15");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(8,4), "S19011C15");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*), 0, "S19011C15");
    check_base_class_offset(lv, (S19011C10*), 0, "S19011C15");
    /*is_ambiguous_... S19011C15::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(1296,812), "S19011C15");
    /*is_ambiguous_... S19011C15::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*), ABISELECT(1288,808), "S19011C15");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(456,264), "S19011C15");
    check_base_class_offset(lv, (S19011C13*), ABISELECT(448,260), "S19011C15");
    check_field_offset(lv, s19011c15f0, ABISELECT(640,392), "S19011C15.s19011c15f0");
    check_field_offset(lv, s19011c15f1, ABISELECT(644,396), "S19011C15.s19011c15f1");
    check_field_offset(lv, s19011c15f2, ABISELECT(645,397), "S19011C15.s19011c15f2");
    check_field_offset(lv, s19011c15f3, ABISELECT(646,398), "S19011C15.s19011c15f3");
    check_field_offset(lv, s19011c15f4, ABISELECT(647,399), "S19011C15.s19011c15f4");
    check_field_offset(lv, s19011c15f5, ABISELECT(648,400), "S19011C15.s19011c15f5");
    test_class_info(&lv, &cd_S19011C15);
    dp->~S19011C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C15(Test_S19011C15, "S19011C15", ABISELECT(1552,960));

#else // __cplusplus

extern void _ZN9S19011C15C1Ev();
extern void _ZN9S19011C15D1Ev();
Name_Map name_map_S19011C15[] = {
  NSPAIR(_ZN9S19011C15C1Ev),
  NSPAIR(_ZN9S19011C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
static Base_Class bases_S19011C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(664,408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(656,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(656,404), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(1248,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1296,812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1288,808), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(448,260), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C15[];
extern void _ZN9S19011C15D1Ev();
extern void _ZN9S19011C15D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN9S19011C153v10Ev();
extern void _ZN9S19011C153v11Ev();
extern void ABISELECT(_ZThn448_N9S19011C15D1Ev,_ZThn260_N9S19011C15D1Ev)();
extern void ABISELECT(_ZThn448_N9S19011C15D0Ev,_ZThn260_N9S19011C15D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev)();
extern void ABISELECT(_ZThn656_N9S19011C15D1Ev,_ZThn404_N9S19011C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev)();
extern void ABISELECT(_ZThn656_N9S19011C15D0Ev,_ZThn404_N9S19011C15D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev)();
extern void ABISELECT(_ZThn1288_N9S19011C15D1Ev,_ZThn808_N9S19011C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev)();
extern void ABISELECT(_ZThn1288_N9S19011C15D0Ev,_ZThn808_N9S19011C15D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C15[] = {
  ABISELECT(1288,808),
  ABISELECT(656,404),
  ABISELECT(1248,784),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&_ZN9S19011C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v11Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19011C15D1Ev,_ZThn260_N9S19011C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19011C15D0Ev,_ZThn260_N9S19011C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-656,-404),
  ABISELECT(-656,-404),
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1288,-808),
  ABISELECT(-1288,-808),
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C15[];
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__9S19011C15[] = {
  ABISELECT(1248,784),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C15[] = {
  {&(_ZTV9S19011C15[5]),  5,39},
  {&(_tg__ZTV9S19011C10__9S19011C15[3]),  3,8},
  {&(_ZTV9S19011C15[23]),  23,39},
  {&(_ZTV9S19011C15[34]),  34,39},
};
extern VTBL_ENTRY _ZTI9S19011C15[];
extern  VTBL_ENTRY _ZTV9S19011C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C15[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1288_N9S19011C15D0Ev,_ZThn808_N9S19011C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19011C15D0Ev,_ZThn404_N9S19011C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1288_N9S19011C15D1Ev,_ZThn808_N9S19011C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19011C15D1Ev,_ZThn404_N9S19011C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C15 = {  "S19011C15", // class name
  bases_S19011C15, 11,
  &(vtc_S19011C15[0]), // expected_vtbl_contents
  &(vtt_S19011C15[0]), // expected_vtt_contents
  ABISELECT(1552,960), // object size
  NSPAIRA(_ZTI9S19011C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19011C15),39, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C15),4, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C14  : S19011C13 , virtual S19011C2 , S19011C15 , S19012C4 {
  int s19011c14f0;
  int s19011c14f1;
  int s19011c14f2;
  char s19011c14f3:6;
  ::S19012C6 s19011c14f4;
  long s19011c14f5;
  __tsi64 s19011c14f6;
  char s19011c14f7;
  __tsi64 s19011c14f8;
  ::S19012C11_nt s19011c14f9;
  virtual void  v9(); // _ZN9S19011C142v9Ev
  ~S19011C14(); // tgen
  S19011C14(); // tgen
};
//SIG(-1 S19011C14) C1{ BC2{ BC3{ m Fl FL Fp[3]} vd v2 FU4{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD} VBC5{ BC6{ BC3 vd v3 v4 v5 FC3 FC3 FC3[3] Fp} FC3 Fi FC3 Fp FU7{ m} FU4 FU4} BC8{ VBC5 VBC3 BC9{ BC6 VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} VBC6 BC2 v6 v7 Fi FC10 FC10 FC10 FC10 Fi} BC3 v1 Fi Fi Fi Fc:6 FU4 Fl FL Fc FL FC10}


void  S19011C14 ::v9(){vfunc_called(this, "_ZN9S19011C142v9Ev");}
S19011C14 ::~S19011C14(){ note_dtor("S19011C14", this);} // tgen
S19011C14 ::S19011C14(){ note_ctor("S19011C14", this);} // tgen

static void Test_S19011C14()
{
  extern Class_Descriptor cd_S19011C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(124,312)];
    init_test(&cd_S19011C14, buf);
    S19011C14 *dp, &lv = *(dp=new (buf) S19011C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1968,1244), "sizeof(S19011C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C14)");
    /*is_ambiguous_... S19011C14::S19011C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(8,4), "S19011C14");
    /*is_ambiguous_... S19011C14::S19011C13 */ AMB_check_base_class_offset(lv, (S19011C13*), 0, "S19011C14");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(1080,692), "S19011C14");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(1072,688), "S19011C14");
    check_base_class_offset(lv, (S19011C2*), ABISELECT(1072,688), "S19011C14");
    check_base_class_offset(lv, (S19011C2*)(S19011C15*), ABISELECT(1072,688), "S19011C14");
    /*is_ambiguous_... S19011C15::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C15*), ABISELECT(1664,1068), "S19011C14");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C15*), ABISELECT(1664,1068), "S19011C14");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C15*), ABISELECT(200,136), "S19011C14");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C15*), ABISELECT(192,132), "S19011C14");
    check_base_class_offset(lv, (S19011C10*)(S19011C15*), ABISELECT(192,132), "S19011C14");
    /*is_ambiguous_... S19011C14::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(1712,1096), "S19011C14");
    /*is_ambiguous_... S19011C15::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C15*), ABISELECT(1704,1092), "S19011C14");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*)(S19011C15*), ABISELECT(648,396), "S19011C14");
    check_base_class_offset(lv, (S19011C13*)(S19011C15*), ABISELECT(640,392), "S19011C14");
    check_base_class_offset(lv, (S19011C15*), ABISELECT(192,132), "S19011C14");
    /*is_ambiguous_... S19011C14::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(848,536), "S19011C14");
    check_field_offset(lv, s19011c14f0, ABISELECT(888,560), "S19011C14.s19011c14f0");
    check_field_offset(lv, s19011c14f1, ABISELECT(892,564), "S19011C14.s19011c14f1");
    check_field_offset(lv, s19011c14f2, ABISELECT(896,568), "S19011C14.s19011c14f2");
    set_bf_and_test(lv, s19011c14f3, ABISELECT(900,572), 0, 6, 1, "S19011C14");
    set_bf_and_test(lv, s19011c14f3, ABISELECT(900,572), 0, 6, hide_sll(1LL<<5), "S19011C14");
    check_field_offset(lv, s19011c14f4, ABISELECT(912,576), "S19011C14.s19011c14f4");
    check_field_offset(lv, s19011c14f5, ABISELECT(1024,660), "S19011C14.s19011c14f5");
    check_field_offset(lv, s19011c14f6, ABISELECT(1032,664), "S19011C14.s19011c14f6");
    check_field_offset(lv, s19011c14f7, ABISELECT(1040,672), "S19011C14.s19011c14f7");
    check_field_offset(lv, s19011c14f8, ABISELECT(1048,676), "S19011C14.s19011c14f8");
    check_field_offset(lv, s19011c14f9, ABISELECT(1056,684), "S19011C14.s19011c14f9");
    test_class_info(&lv, &cd_S19011C14);
    dp->~S19011C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C14(Test_S19011C14, "S19011C14", ABISELECT(1968,1244));

#else // __cplusplus

extern void _ZN9S19011C14C1Ev();
extern void _ZN9S19011C14D1Ev();
Name_Map name_map_S19011C14[] = {
  NSPAIR(_ZN9S19011C14C1Ev),
  NSPAIR(_ZN9S19011C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19011C15;
extern VTBL_ENTRY _ZTI9S19011C15[];
extern  VTBL_ENTRY _ZTV9S19011C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C15[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
static Base_Class bases_S19011C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1080,692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1072,688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(1072,688), //bcp->offset
    26, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(1664,1068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(200,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(192,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(192,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1712,1096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1704,1092), //bcp->offset
    37, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(648,396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(640,392), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19011C15,    ABISELECT(192,132), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(848,536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C14[];
extern void _ZN9S19011C14D1Ev();
extern void _ZN9S19011C14D0Ev();
extern void _ZN9S19011C132v7Ev();
extern void _ZN9S19011C142v9Ev();
extern void ABISELECT(_ZThn192_N9S19011C14D1Ev,_ZThn132_N9S19011C14D1Ev)();
extern void ABISELECT(_ZThn192_N9S19011C14D0Ev,_ZThn132_N9S19011C14D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN9S19011C153v10Ev();
extern void _ZN9S19011C153v11Ev();
extern void ABISELECT(_ZThn640_N9S19011C14D1Ev,_ZThn392_N9S19011C14D1Ev)();
extern void ABISELECT(_ZThn640_N9S19011C14D0Ev,_ZThn392_N9S19011C14D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C14D1Ev,_ZTv0_n12_N9S19011C14D1Ev)();
extern void ABISELECT(_ZThn1072_N9S19011C14D1Ev,_ZThn688_N9S19011C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C14D0Ev,_ZTv0_n12_N9S19011C14D0Ev)();
extern void ABISELECT(_ZThn1072_N9S19011C14D0Ev,_ZThn688_N9S19011C14D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C14D1Ev,_ZTv0_n12_N9S19011C14D1Ev)();
extern void ABISELECT(_ZThn1704_N9S19011C14D1Ev,_ZThn1092_N9S19011C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C14D0Ev,_ZTv0_n12_N9S19011C14D0Ev)();
extern void ABISELECT(_ZThn1704_N9S19011C14D0Ev,_ZThn1092_N9S19011C14D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C14[] = {
  ABISELECT(1704,1092),
  ABISELECT(1664,1068),
  ABISELECT(1072,688),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C14[0]),
  (VTBL_ENTRY)&_ZN9S19011C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C14D0Ev,
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  (VTBL_ENTRY)&_ZN9S19011C142v9Ev,
  ABISELECT(1512,960),
  ABISELECT(880,556),
  ABISELECT(1472,936),
  ABISELECT(-192,-132),
  (VTBL_ENTRY)&(_ZTI9S19011C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S19011C14D1Ev,_ZThn132_N9S19011C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S19011C14D0Ev,_ZThn132_N9S19011C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v11Ev,
  ABISELECT(-640,-392),
  (VTBL_ENTRY)&(_ZTI9S19011C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19011C14D1Ev,_ZThn392_N9S19011C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19011C14D0Ev,_ZThn392_N9S19011C14D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-1072,-688),
  ABISELECT(-1072,-688),
  (VTBL_ENTRY)&(_ZTI9S19011C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C14D1Ev,_ZTv0_n12_N9S19011C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C14D0Ev,_ZTv0_n12_N9S19011C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-1704,-1092),
  ABISELECT(-1704,-1092),
  (VTBL_ENTRY)&(_ZTI9S19011C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C14D1Ev,_ZTv0_n12_N9S19011C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C14D0Ev,_ZTv0_n12_N9S19011C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C14[];
extern void _ZN9S19011C15D1Ev();
extern void _ZN9S19011C15D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN9S19011C153v10Ev();
extern void _ZN9S19011C153v11Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C15__9S19011C14[] = {
  ABISELECT(1512,960),
  ABISELECT(880,556),
  ABISELECT(1472,936),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&_ZN9S19011C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19011C153v11Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C109S19011C15__9S19011C14[] = {
  ABISELECT(1472,936),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev)();
extern void ABISELECT(_ZThn880_N9S19011C15D1Ev,_ZThn556_N9S19011C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev)();
extern void ABISELECT(_ZThn880_N9S19011C15D0Ev,_ZThn556_N9S19011C15D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__9S19011C15__9S19011C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-556),
  ABISELECT(-880,-556),
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev)();
extern void ABISELECT(_ZThn1512_N9S19011C15D1Ev,_ZThn960_N9S19011C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev)();
extern void ABISELECT(_ZThn1512_N9S19011C15D0Ev,_ZThn960_N9S19011C15D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C3__A2__9S19011C15__9S19011C14[] = {
  0,
  0,
  0,
  ABISELECT(-1512,-960),
  ABISELECT(-1512,-960),
  (VTBL_ENTRY)&(_ZTI9S19011C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C14[] = {
  {&(_ZTV9S19011C14[5]),  5,48},
  {&(_tg__ZTV9S19011C15__9S19011C14[5]),  5,12},
  {&(_tg__ZTV9S19011C109S19011C15__9S19011C14[3]),  3,8},
  {&(_tg__ZTV8S19011C2__9S19011C15__9S19011C14[6]),  6,11},
  {&(_tg__ZTV8S19011C3__A2__9S19011C15__9S19011C14[6]),  6,11},
  {&(_ZTV9S19011C14[32]),  32,48},
  {&(_ZTV9S19011C14[14]),  14,48},
  {&(_ZTV9S19011C14[43]),  43,48},
};
extern VTBL_ENTRY _ZTI9S19011C14[];
extern  VTBL_ENTRY _ZTV9S19011C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C14[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C15D0Ev,_ZTv0_n12_N9S19011C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1512_N9S19011C15D0Ev,_ZThn960_N9S19011C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19011C15D0Ev,_ZThn556_N9S19011C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C15D1Ev,_ZTv0_n12_N9S19011C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1512_N9S19011C15D1Ev,_ZThn960_N9S19011C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19011C15D1Ev,_ZThn556_N9S19011C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C14D0Ev,_ZTv0_n12_N9S19011C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1704_N9S19011C14D0Ev,_ZThn1092_N9S19011C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19011C14D0Ev,_ZThn688_N9S19011C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C14D1Ev,_ZTv0_n12_N9S19011C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1704_N9S19011C14D1Ev,_ZThn1092_N9S19011C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19011C14D1Ev,_ZThn688_N9S19011C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C14 = {  "S19011C14", // class name
  bases_S19011C14, 15,
  &(vtc_S19011C14[0]), // expected_vtbl_contents
  &(vtt_S19011C14[0]), // expected_vtt_contents
  ABISELECT(1968,1244), // object size
  NSPAIRA(_ZTI9S19011C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19011C14),48, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C14),8, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C12  : virtual S19011C8 , S19011C3 , S19011C13 , S19012C4 , S19011C2 {
  char s19011c12f0:3;
  ::S19012C5_nt s19011c12f1;
  int s19011c12f2;
  __tsi64 s19011c12f3:36;
  __tsi64 s19011c12f4;
  void *s19011c12f5[4];
  __tsi64 s19011c12f6;
  ::S19011C14 s19011c12f7;
  int s19011c12f8:5;
  ::S19011C14 s19011c12f9;
  virtual  ~S19011C12(); // _ZN9S19011C12D2Ev
  S19011C12(); // tgen
};
//SIG(-1 S19011C12) C1{ VBC2{ VBC3{ BC4{ BC5{ m Fl FL Fp[3]} vd v1 v2 v3 FC5 FC5 FC5[3] Fp} FC5 Fi FC5 Fp FU6{ m} FU7{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU7} VBC5 BC8{ VBC5 BC9{ BC4 VBC5 vd Fs FD Fp[2] FL FC5 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} BC3 vd v4 v5 FD Fc[8] FU7 Fi Fi FC10 FD FD} BC9 vd v6 FU6 Fc} BC4 BC11{ BC5 vd v7 FU7 Fc[5] FD} BC5 BC3 vd Fc:3 FU6 Fi FL:36 FL Fp[4] FL FC12{ BC11 VBC3 BC13{ VBC3 VBC5 BC9 VBC4 BC11 v9 v10 Fi FC10 FC10 FC10 FC10 Fi} BC5 v8 Fi Fi Fi Fc:6 FU7 Fl FL Fc FL FC10} Fi:5 FC12}


 S19011C12 ::~S19011C12(){ note_dtor("S19011C12", this);}
S19011C12 ::S19011C12(){ note_ctor("S19011C12", this);} // tgen

static void Test_S19011C12()
{
  extern Class_Descriptor cd_S19011C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(465,1170)];
    init_test(&cd_S19011C12, buf);
    S19011C12 *dp, &lv = *(dp=new (buf) S19011C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7424,4676), "sizeof(S19011C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C12)");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(6792,4276), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(6784,4272), "S19011C12");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*), ABISELECT(6784,4272), "S19011C12");
    /*is_ambiguous_... S19011C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*), ABISELECT(7376,4652), "S19011C12");
    /*is_ambiguous_... S19011C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*), ABISELECT(7376,4652), "S19011C12");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7376,4652), "S19011C12");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*), ABISELECT(7376,4652), "S19011C12");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(5112,3232), "S19011C12");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(5104,3228), "S19011C12");
    check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(5104,3228), "S19011C12");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(5560,3492), "S19011C12");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(5552,3488), "S19011C12");
    check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(5552,3488), "S19011C12");
    check_base_class_offset(lv, (S19011C9*)(S19011C8*), ABISELECT(5104,3228), "S19011C12");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(6344,4012), "S19011C12");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(6336,4008), "S19011C12");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*), ABISELECT(6336,4008), "S19011C12");
    check_base_class_offset(lv, (S19011C8*), ABISELECT(5104,3228), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(8,4), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*), 0, "S19011C12");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(264,156), "S19011C12");
    check_base_class_offset(lv, (S19011C13*), ABISELECT(256,152), "S19011C12");
    /*is_ambiguous_... S19011C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*), ABISELECT(448,284), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(504,312), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(496,308), "S19011C12");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*), ABISELECT(496,308), "S19011C12");
    set_bf_and_test(lv, s19011c12f0, ABISELECT(1088,688), 0, 3, 1, "S19011C12");
    set_bf_and_test(lv, s19011c12f0, ABISELECT(1088,688), 0, 3, hide_sll(1LL<<2), "S19011C12");
    check_field_offset(lv, s19011c12f1, ABISELECT(1089,689), "S19011C12.s19011c12f1");
    check_field_offset(lv, s19011c12f2, ABISELECT(1092,692), "S19011C12.s19011c12f2");
    set_bf_and_test(lv, s19011c12f3, ABISELECT(1096,696), 0, 36, 1, "S19011C12");
    set_bf_and_test(lv, s19011c12f3, ABISELECT(1096,696), 0, 36, hide_sll(1LL<<35), "S19011C12");
    check_field_offset(lv, s19011c12f4, ABISELECT(1104,704), "S19011C12.s19011c12f4");
    check_field_offset(lv, s19011c12f5, ABISELECT(1112,712), "S19011C12.s19011c12f5");
    check_field_offset(lv, s19011c12f6, ABISELECT(1144,728), "S19011C12.s19011c12f6");
    check_field_offset(lv, s19011c12f7, ABISELECT(1152,736), "S19011C12.s19011c12f7");
    set_bf_and_test(lv, s19011c12f8, ABISELECT(3120,1980), 0, 5, 1, "S19011C12");
    set_bf_and_test(lv, s19011c12f8, ABISELECT(3120,1980), 0, 5, hide_sll(1LL<<4), "S19011C12");
    check_field_offset(lv, s19011c12f9, ABISELECT(3136,1984), "S19011C12.s19011c12f9");
    test_class_info(&lv, &cd_S19011C12);
    dp->~S19011C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C12(Test_S19011C12, "S19011C12", ABISELECT(7424,4676));

#else // __cplusplus

extern void _ZN9S19011C12C1Ev();
extern void _ZN9S19011C12D2Ev();
Name_Map name_map_S19011C12[] = {
  NSPAIR(_ZN9S19011C12C1Ev),
  NSPAIR(_ZN9S19011C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
static Base_Class bases_S19011C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(6792,4276), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(6784,4272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(6784,4272), //bcp->offset
    56, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7376,4652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(5112,3232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(5104,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(5104,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(5560,3492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(5552,3488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(5552,3488), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(5104,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(6344,4012), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(6336,4008), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(6336,4008), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(5104,3228), //bcp->offset
    22, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(264,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(256,152), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(448,284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(504,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(496,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(496,308), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C12[];
extern void _ZN9S19011C12D1Ev();
extern void _ZN9S19011C12D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn256_N9S19011C12D1Ev,_ZThn152_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn256_N9S19011C12D0Ev,_ZThn152_N9S19011C12D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZThn496_N9S19011C12D1Ev,_ZThn308_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn496_N9S19011C12D0Ev,_ZThn308_N9S19011C12D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn5104_N9S19011C12D1Ev,_ZThn3228_N9S19011C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev)();
extern void ABISELECT(_ZThn5104_N9S19011C12D0Ev,_ZThn3228_N9S19011C12D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZTvn448_n40_N9S19011C12D1Ev,_ZTvn260_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S19011C12D0Ev,_ZTvn260_n20_N9S19011C12D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTvn1232_n40_N9S19011C12D1Ev,_ZTvn780_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N9S19011C12D0Ev,_ZTvn780_n20_N9S19011C12D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn6784_N9S19011C12D1Ev,_ZThn4272_N9S19011C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev)();
extern void ABISELECT(_ZThn6784_N9S19011C12D0Ev,_ZThn4272_N9S19011C12D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C12[] = {
  ABISELECT(7376,4652),
  ABISELECT(6784,4272),
  ABISELECT(5104,3228),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&_ZN9S19011C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N9S19011C12D1Ev,_ZThn152_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N9S19011C12D0Ev,_ZThn152_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  ABISELECT(-496,-308),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn496_N9S19011C12D1Ev,_ZThn308_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn496_N9S19011C12D0Ev,_ZThn308_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-5104,-3228),
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  ABISELECT(-5104,-3228),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
  ABISELECT(-5552,-3488),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19011C12D1Ev,_ZTvn260_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19011C12D0Ev,_ZTvn260_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(1040,644),
  ABISELECT(-6336,-4008),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19011C12D1Ev,_ZTvn780_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19011C12D0Ev,_ZTvn780_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-6784,-4272),
  ABISELECT(-6784,-4272),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C12[];
extern void _ZN8S19011C8D1Ev();
extern void _ZN8S19011C8D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C8__9S19011C12[] = {
  ABISELECT(1680,1044),
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&_ZN8S19011C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
};
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C98S19011C8__9S19011C12[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C98S19011C8__9S19011C12[] = {
  ABISELECT(2272,1424),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C8__A1__9S19011C12[] = {
  ABISELECT(1040,644),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19011C8D1Ev,_ZThn1044_N8S19011C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev)();
extern void ABISELECT(_ZThn1680_N8S19011C8D0Ev,_ZThn1044_N8S19011C8D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__8S19011C8__9S19011C12[] = {
  0,
  0,
  0,
  ABISELECT(-1680,-1044),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__8S19011C8__9S19011C12[] = {
  ABISELECT(1040,644),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C12[] = {
  {&(_ZTV9S19011C12[5]),  5,67},
  {&(_ZTV9S19011C12[33]),  33,67},
  {&(_ZTV9S19011C12[62]),  62,67},
  {&(_ZTV9S19011C12[43]),  43,67},
  {&(_ZTV9S19011C12[51]),  51,67},
  {&(_tg__ZTV8S19011C8__9S19011C12[4]),  4,12},
  {&(_tg__ZTV8S19011C98S19011C8__9S19011C12[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C98S19011C8__9S19011C12[3]),  3,8},
  {&(_tg__ZTV9S19011C108S19011C8__A1__9S19011C12[3]),  3,8},
  {&(_tg__ZTV8S19011C2__8S19011C8__9S19011C12[6]),  6,11},
  {&(_tg__ZTV9S19011C10__A1__8S19011C8__9S19011C12[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19011C12[];
extern  VTBL_ENTRY _ZTV9S19011C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C12[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19011C8D0Ev,_ZThn1044_N8S19011C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1680_N8S19011C8D1Ev,_ZThn1044_N8S19011C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6784_N9S19011C12D0Ev,_ZThn4272_N9S19011C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6784_N9S19011C12D1Ev,_ZThn4272_N9S19011C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5104_N9S19011C12D0Ev,_ZThn3228_N9S19011C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5104_N9S19011C12D1Ev,_ZThn3228_N9S19011C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C12 = {  "S19011C12", // class name
  bases_S19011C12, 23,
  &(vtc_S19011C12[0]), // expected_vtbl_contents
  &(vtt_S19011C12[0]), // expected_vtt_contents
  ABISELECT(7424,4676), // object size
  NSPAIRA(_ZTI9S19011C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19011C12),67, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C12),11, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C7  : S19011C8 , S19011C12 {
  char s19011c7f0;
  char s19011c7f1:6;
  __tsi64 s19011c7f2[3];
  ::S19011C3 s19011c7f3;
  char s19011c7f4[6];
  __tsi64 s19011c7f5;
  ~S19011C7(); // tgen
  S19011C7(); // tgen
};
//SIG(-1 S19011C7) C1{ BC2{ VBC3{ BC4{ BC5{ m Fl FL Fp[3]} vd v1 v2 v3 FC5 FC5 FC5[3] Fp} FC5 Fi FC5 Fp FU6{ m} FU7{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU7} VBC5 BC8{ VBC5 BC9{ BC4 VBC5 vd Fs FD Fp[2] FL FC5 Fp[6] Fi Fp FC10{}[10] FC10[4] Fi} BC3 vd v4 v5 FD Fc[8] FU7 Fi Fi FC10 FD FD} BC9 vd v6 FU6 Fc} BC11{ VBC2 BC4 BC12{ BC5 vd v7 FU7 Fc[5] FD} BC5 BC3 vd Fc:3 FU6 Fi FL:36 FL Fp[4] FL FC13{ BC12 VBC3 BC14{ VBC3 VBC5 BC9 VBC4 BC12 v9 v10 Fi FC10 FC10 FC10 FC10 Fi} BC5 v8 Fi Fi Fi Fc:6 FU7 Fl FL Fc FL FC10} Fi:5 FC13} Fc Fc:6 FL[3] FC4 Fc[6] FL}


S19011C7 ::~S19011C7(){ note_dtor("S19011C7", this);} // tgen
S19011C7 ::S19011C7(){ note_ctor("S19011C7", this);} // tgen

static void Test_S19011C7()
{
  extern Class_Descriptor cd_S19011C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(589,1480)];
    init_test(&cd_S19011C7, buf);
    S19011C7 *dp, &lv = *(dp=new (buf) S19011C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9408,5916), "sizeof(S19011C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C7)");
    /*is_ambiguous_... S19011C7::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(7096,4472), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(7088,4468), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*), ABISELECT(7088,4468), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*), ABISELECT(7088,4468), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*), ABISELECT(7680,4848), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(8,4), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), 0, "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*), 0, "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(456,264), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(448,260), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(448,260), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C9*)(S19011C8*), 0, "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(1240,784), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(1232,780), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*), ABISELECT(1232,780), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C8*), 0, "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7736,4876), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7728,4872), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7728,4872), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(8184,5136), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(8176,5132), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(8176,5132), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C9*)(S19011C8*), ABISELECT(7728,4872), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(8968,5656), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(8960,5652), "S19011C7");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*), ABISELECT(8960,5652), "S19011C7");
    check_base_class_offset(lv, (S19011C8*)(S19011C12*), ABISELECT(7728,4872), "S19011C7");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C12*), ABISELECT(1688,1048), "S19011C7");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C12*), ABISELECT(1680,1044), "S19011C7");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*)(S19011C12*), ABISELECT(1944,1200), "S19011C7");
    check_base_class_offset(lv, (S19011C13*)(S19011C12*), ABISELECT(1936,1196), "S19011C7");
    /*is_ambiguous_... S19011C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C12*), ABISELECT(2128,1328), "S19011C7");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C12*), ABISELECT(2184,1356), "S19011C7");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C12*), ABISELECT(2176,1352), "S19011C7");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C12*), ABISELECT(2176,1352), "S19011C7");
    check_base_class_offset(lv, (S19011C12*), ABISELECT(1680,1044), "S19011C7");
    check_field_offset(lv, s19011c7f0, ABISELECT(6784,4272), "S19011C7.s19011c7f0");
    set_bf_and_test(lv, s19011c7f1, ABISELECT(6785,4273), 0, 6, 1, "S19011C7");
    set_bf_and_test(lv, s19011c7f1, ABISELECT(6785,4273), 0, 6, hide_sll(1LL<<5), "S19011C7");
    check_field_offset(lv, s19011c7f2, ABISELECT(6792,4276), "S19011C7.s19011c7f2");
    check_field_offset(lv, s19011c7f3, ABISELECT(6816,4300), "S19011C7.s19011c7f3");
    check_field_offset(lv, s19011c7f4, ABISELECT(7072,4452), "S19011C7.s19011c7f4");
    check_field_offset(lv, s19011c7f5, ABISELECT(7080,4460), "S19011C7.s19011c7f5");
    test_class_info(&lv, &cd_S19011C7);
    dp->~S19011C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C7(Test_S19011C7, "S19011C7", ABISELECT(9408,5916));

#else // __cplusplus

extern void _ZN8S19011C7C1Ev();
extern void _ZN8S19011C7D1Ev();
Name_Map name_map_S19011C7[] = {
  NSPAIR(_ZN8S19011C7C1Ev),
  NSPAIR(_ZN8S19011C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C12;
extern VTBL_ENTRY _ZTI9S19011C12[];
extern  VTBL_ENTRY _ZTV9S19011C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C12[];
static Base_Class bases_S19011C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7096,4472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(7088,4468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(7088,4468), //bcp->offset
    50, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7680,4848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(448,260), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1232,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(1232,780), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19011C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7736,4876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(7728,4872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(7728,4872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8184,5136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(8176,5132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(8176,5132), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(7728,4872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8968,5656), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(8960,5652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(8960,5652), //bcp->offset
    87, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(7728,4872), //bcp->offset
    61, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(1688,1048), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1680,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1944,1200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(1936,1196), //bcp->offset
    38, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2128,1328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2184,1356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(2176,1352), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(2176,1352), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19011C12,    ABISELECT(1680,1044), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C7[];
extern void _ZN8S19011C7D1Ev();
extern void _ZN8S19011C7D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZThn448_N8S19011C7D1Ev,_ZThn260_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn448_N8S19011C7D0Ev,_ZThn260_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19011C7D1Ev,_ZThn780_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C7D0Ev,_ZThn780_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1680_N8S19011C7D1Ev,_ZThn1044_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19011C7D0Ev,_ZThn1044_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1936_N8S19011C7D1Ev,_ZThn1196_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn1936_N8S19011C7D0Ev,_ZThn1196_N8S19011C7D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZThn2176_N8S19011C7D1Ev,_ZThn1352_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn2176_N8S19011C7D0Ev,_ZThn1352_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N8S19011C7D1Ev,_ZTv0_n12_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn7088_N8S19011C7D1Ev,_ZThn4468_N8S19011C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19011C7D0Ev,_ZTv0_n12_N8S19011C7D0Ev)();
extern void ABISELECT(_ZThn7088_N8S19011C7D0Ev,_ZThn4468_N8S19011C7D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19011C7D1Ev,_ZTv0_n20_N8S19011C7D1Ev)();
extern void ABISELECT(_ZThn7728_N8S19011C7D1Ev,_ZThn4872_N8S19011C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19011C7D0Ev,_ZTv0_n20_N8S19011C7D0Ev)();
extern void ABISELECT(_ZThn7728_N8S19011C7D0Ev,_ZThn4872_N8S19011C7D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZTvn448_n40_N8S19011C7D1Ev,_ZTvn260_n20_N8S19011C7D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S19011C7D0Ev,_ZTvn260_n20_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTvn1232_n40_N8S19011C7D1Ev,_ZTvn780_n20_N8S19011C7D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N8S19011C7D0Ev,_ZTvn780_n20_N8S19011C7D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C7[] = {
  ABISELECT(7728,4872),
  ABISELECT(7088,4468),
  ABISELECT(7680,4848),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&_ZN8S19011C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C7D1Ev,_ZThn260_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S19011C7D0Ev,_ZThn260_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(6448,4068),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C7D1Ev,_ZThn780_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C7D0Ev,_ZThn780_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(6000,3804),
  ABISELECT(5408,3424),
  ABISELECT(6048,3828),
  ABISELECT(-1680,-1044),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19011C7D1Ev,_ZThn1044_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19011C7D0Ev,_ZThn1044_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(-1936,-1196),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N8S19011C7D1Ev,_ZThn1196_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N8S19011C7D0Ev,_ZThn1196_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  ABISELECT(-2176,-1352),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S19011C7D1Ev,_ZThn1352_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S19011C7D0Ev,_ZThn1352_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-7088,-4468),
  ABISELECT(-7088,-4468),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C7D1Ev,_ZTv0_n12_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C7D0Ev,_ZTv0_n12_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-7728,-4872),
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  ABISELECT(-7728,-4872),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19011C7D1Ev,_ZTv0_n20_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19011C7D0Ev,_ZTv0_n20_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
  ABISELECT(-8176,-5132),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19011C7D1Ev,_ZTvn260_n20_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S19011C7D0Ev,_ZTvn260_n20_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(-1280,-804),
  ABISELECT(-8960,-5652),
  (VTBL_ENTRY)&(_ZTI8S19011C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19011C7D1Ev,_ZTvn780_n20_N8S19011C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N8S19011C7D0Ev,_ZTvn780_n20_N8S19011C7D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV8S19011C7[];
extern void _ZN8S19011C8D1Ev();
extern void _ZN8S19011C8D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C8__A__8S19011C7[] = {
  ABISELECT(7088,4468),
  ABISELECT(7680,4848),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&_ZN8S19011C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
};
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C98S19011C8__8S19011C7[] = {
  ABISELECT(7680,4848),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C98S19011C8__8S19011C7[] = {
  ABISELECT(7680,4848),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C8__A1__8S19011C7[] = {
  ABISELECT(6448,4068),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn7088_N8S19011C8D1Ev,_ZThn4468_N8S19011C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev)();
extern void ABISELECT(_ZThn7088_N8S19011C8D0Ev,_ZThn4468_N8S19011C8D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__8S19011C8__A__8S19011C7[] = {
  0,
  0,
  0,
  ABISELECT(-7088,-4468),
  ABISELECT(-7088,-4468),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__8S19011C8__A__8S19011C7[] = {
  ABISELECT(6448,4068),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C12D1Ev();
extern void _ZN9S19011C12D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C12__8S19011C7[] = {
  ABISELECT(6000,3804),
  ABISELECT(5408,3424),
  ABISELECT(6048,3828),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&_ZN9S19011C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn6048_N9S19011C12D1Ev,_ZThn3828_N9S19011C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev)();
extern void ABISELECT(_ZThn6048_N9S19011C12D0Ev,_ZThn3828_N9S19011C12D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C8__9S19011C12__8S19011C7[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-6048,-3828),
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  ABISELECT(-6048,-3828),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev)();
extern void ABISELECT(_ZThn5408_N9S19011C12D1Ev,_ZThn3424_N9S19011C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev)();
extern void ABISELECT(_ZThn5408_N9S19011C12D0Ev,_ZThn3424_N9S19011C12D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__9S19011C12__8S19011C7[] = {
  0,
  0,
  0,
  ABISELECT(-5408,-3424),
  ABISELECT(-5408,-3424),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTvn448_n40_N9S19011C12D1Ev,_ZTvn260_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S19011C12D0Ev,_ZTvn260_n20_N9S19011C12D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C28S19011C98S19011C8__A1__9S19011C12__8S19011C7[] = {
  ABISELECT(-6496,-4088),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19011C12D1Ev,_ZTvn260_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S19011C12D0Ev,_ZTvn260_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTvn1232_n40_N9S19011C12D1Ev,_ZTvn780_n20_N9S19011C12D1Ev)();
extern void ABISELECT(_ZTvn1232_n40_N9S19011C12D0Ev,_ZTvn780_n20_N9S19011C12D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C8__A1__9S19011C12__8S19011C7[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-7280,-4608),
  (VTBL_ENTRY)&(_ZTI9S19011C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19011C12D1Ev,_ZTvn780_n20_N9S19011C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1232_n40_N9S19011C12D0Ev,_ZTvn780_n20_N9S19011C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN8S19011C8D1Ev();
extern void _ZN8S19011C8D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C8__A1__8S19011C7[] = {
  ABISELECT(-640,-404),
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&_ZN8S19011C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
};
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C98S19011C8__A1__8S19011C7[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C98S19011C8__A2__8S19011C7[] = {
  ABISELECT(-48,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C8__A3__8S19011C7[] = {
  ABISELECT(-1280,-804),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__8S19011C8__A1__8S19011C7[] = {
  0,
  0,
  0,
  ABISELECT(640,404),
  ABISELECT(640,404),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__8S19011C8__A1__8S19011C7[] = {
  ABISELECT(-1280,-804),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C7[] = {
  {&(_ZTV8S19011C7[5]),  5,95},
  {&(_tg__ZTV8S19011C8__A__8S19011C7[4]),  4,12},
  {&(_tg__ZTV8S19011C98S19011C8__8S19011C7[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C98S19011C8__8S19011C7[3]),  3,8},
  {&(_tg__ZTV9S19011C108S19011C8__A1__8S19011C7[3]),  3,8},
  {&(_tg__ZTV8S19011C2__8S19011C8__A__8S19011C7[6]),  6,11},
  {&(_tg__ZTV9S19011C10__A1__8S19011C8__A__8S19011C7[3]),  3,8},
  {&(_tg__ZTV9S19011C12__8S19011C7[5]),  5,10},
  {&(_tg__ZTV8S19011C8__9S19011C12__8S19011C7[11]),  11,19},
  {&(_tg__ZTV8S19011C2__9S19011C12__8S19011C7[6]),  6,11},
  {&(_tg__ZTV8S19011C28S19011C98S19011C8__A1__9S19011C12__8S19011C7[2]),  2,7},
  {&(_tg__ZTV9S19011C108S19011C8__A1__9S19011C12__8S19011C7[3]),  3,8},
  {&(_ZTV8S19011C7[56]),  56,95},
  {&(_ZTV8S19011C7[23]),  23,95},
  {&(_ZTV8S19011C7[33]),  33,95},
  {&(_ZTV8S19011C7[72]),  72,95},
  {&(_ZTV8S19011C7[82]),  82,95},
  {&(_ZTV8S19011C7[90]),  90,95},
  {&(_tg__ZTV8S19011C8__A1__8S19011C7[4]),  4,12},
  {&(_tg__ZTV8S19011C98S19011C8__A1__8S19011C7[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C98S19011C8__A2__8S19011C7[3]),  3,8},
  {&(_tg__ZTV9S19011C108S19011C8__A3__8S19011C7[3]),  3,8},
  {&(_tg__ZTV8S19011C2__8S19011C8__A1__8S19011C7[6]),  6,11},
  {&(_tg__ZTV9S19011C10__A1__8S19011C8__A1__8S19011C7[3]),  3,8},
};
extern VTBL_ENTRY _ZTI8S19011C7[];
extern  VTBL_ENTRY _ZTV8S19011C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C7[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C12D0Ev,_ZTv0_n12_N9S19011C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5408_N9S19011C12D0Ev,_ZThn3424_N9S19011C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C12D1Ev,_ZTv0_n12_N9S19011C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5408_N9S19011C12D1Ev,_ZThn3424_N9S19011C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19011C12D0Ev,_ZTv0_n20_N9S19011C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6048_N9S19011C12D0Ev,_ZThn3828_N9S19011C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19011C12D1Ev,_ZTv0_n20_N9S19011C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6048_N9S19011C12D1Ev,_ZThn3828_N9S19011C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19011C8D0Ev,_ZThn4468_N8S19011C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19011C8D1Ev,_ZThn4468_N8S19011C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19011C7D0Ev,_ZTv0_n20_N8S19011C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7728_N8S19011C7D0Ev,_ZThn4872_N8S19011C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19011C7D1Ev,_ZTv0_n20_N8S19011C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7728_N8S19011C7D1Ev,_ZThn4872_N8S19011C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C7D0Ev,_ZTv0_n12_N8S19011C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19011C7D0Ev,_ZThn4468_N8S19011C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C7D1Ev,_ZTv0_n12_N8S19011C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7088_N8S19011C7D1Ev,_ZThn4468_N8S19011C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C7 = {  "S19011C7", // class name
  bases_S19011C7, 35,
  &(vtc_S19011C7[0]), // expected_vtbl_contents
  &(vtt_S19011C7[0]), // expected_vtt_contents
  ABISELECT(9408,5916), // object size
  NSPAIRA(_ZTI8S19011C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19011C7),95, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19011C7),24, //virtual table table var
  23, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C17  : virtual S19011C13 , virtual S19011C10 {
  __tsi64 s19011c17f0;
  char s19011c17f1;
  char s19011c17f2;
  __tsi64 s19011c17f3;
  ::S19012C4 s19011c17f4;
  void *s19011c17f5;
  short s19011c17f6;
  __tsi64 s19011c17f7;
  __tsi64 s19011c17f8;
  char s19011c17f9;
  virtual void  v8(); // _ZN9S19011C172v8Ev
  ~S19011C17(); // tgen
  S19011C17(); // tgen
};
//SIG(-1 S19011C17) C1{ VBC2{ BC3{ m Fl FL Fp[3]} vd v2 FU4{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} Fc[5] FD} VBC5{ BC6{ BC3 vd v3 v4 v5 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC7{}[10] FC7[4] Fi} v1 FL Fc Fc FL FC3 Fp Fs FL FL Fc}


void  S19011C17 ::v8(){vfunc_called(this, "_ZN9S19011C172v8Ev");}
S19011C17 ::~S19011C17(){ note_dtor("S19011C17", this);} // tgen
S19011C17 ::S19011C17(){ note_ctor("S19011C17", this);} // tgen

static void Test_S19011C17()
{
  extern Class_Descriptor cd_S19011C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(50,124)];
    init_test(&cd_S19011C17, buf);
    S19011C17 *dp, &lv = *(dp=new (buf) S19011C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,492), "sizeof(S19011C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C17)");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(120,80), "S19011C17");
    check_base_class_offset(lv, (S19011C13*), ABISELECT(112,76), "S19011C17");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(312,212), "S19011C17");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*), ABISELECT(304,208), "S19011C17");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(744,468), "S19011C17");
    check_base_class_offset(lv, (S19011C10*), ABISELECT(304,208), "S19011C17");
    check_field_offset(lv, s19011c17f0, ABISELECT(8,4), "S19011C17.s19011c17f0");
    check_field_offset(lv, s19011c17f1, ABISELECT(16,12), "S19011C17.s19011c17f1");
    check_field_offset(lv, s19011c17f2, ABISELECT(17,13), "S19011C17.s19011c17f2");
    check_field_offset(lv, s19011c17f3, ABISELECT(24,16), "S19011C17.s19011c17f3");
    check_field_offset(lv, s19011c17f4, ABISELECT(32,24), "S19011C17.s19011c17f4");
    check_field_offset(lv, s19011c17f5, ABISELECT(72,48), "S19011C17.s19011c17f5");
    check_field_offset(lv, s19011c17f6, ABISELECT(80,52), "S19011C17.s19011c17f6");
    check_field_offset(lv, s19011c17f7, ABISELECT(88,56), "S19011C17.s19011c17f7");
    check_field_offset(lv, s19011c17f8, ABISELECT(96,64), "S19011C17.s19011c17f8");
    check_field_offset(lv, s19011c17f9, ABISELECT(104,72), "S19011C17.s19011c17f9");
    test_class_info(&lv, &cd_S19011C17);
    dp->~S19011C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C17(Test_S19011C17, "S19011C17", ABISELECT(784,492));

#else // __cplusplus

extern void _ZN9S19011C17C1Ev();
extern void _ZN9S19011C17D1Ev();
Name_Map name_map_S19011C17[] = {
  NSPAIR(_ZN9S19011C17C1Ev),
  NSPAIR(_ZN9S19011C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
static Base_Class bases_S19011C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(120,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(112,76), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(312,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(744,468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19011C10,    ABISELECT(304,208), //bcp->offset
    15, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C17[];
extern void _ZN9S19011C172v8Ev();
extern void _ZN9S19011C17D1Ev();
extern void _ZN9S19011C17D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev)();
extern void ABISELECT(_ZThn112_N9S19011C17D1Ev,_ZThn76_N9S19011C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev)();
extern void ABISELECT(_ZThn112_N9S19011C17D0Ev,_ZThn76_N9S19011C17D0Ev)() __attribute__((weak));
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev)();
extern void ABISELECT(_ZThn304_N9S19011C17D1Ev,_ZThn208_N9S19011C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev)();
extern void ABISELECT(_ZThn304_N9S19011C17D0Ev,_ZThn208_N9S19011C17D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C17[] = {
  ABISELECT(744,468),
  ABISELECT(304,208),
  ABISELECT(112,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&_ZN9S19011C172v8Ev,
  (VTBL_ENTRY)&_ZN9S19011C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C17D0Ev,
  0,
  ABISELECT(-112,-76),
  ABISELECT(-112,-76),
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-304,-208),
  ABISELECT(440,260),
  ABISELECT(-304,-208),
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C17[];
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__9S19011C17[] = {
  ABISELECT(440,260),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C17[] = {
  {&(_ZTV9S19011C17[5]),  5,27},
  {&(_ZTV9S19011C17[12]),  12,27},
  {&(_ZTV9S19011C17[22]),  22,27},
  {&(_tg__ZTV9S19011C10__9S19011C17[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19011C17[];
extern  VTBL_ENTRY _ZTV9S19011C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C17[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19011C17D0Ev,_ZThn208_N9S19011C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19011C17D1Ev,_ZThn208_N9S19011C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19011C17D0Ev,_ZThn76_N9S19011C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19011C17D1Ev,_ZThn76_N9S19011C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C17 = {  "S19011C17", // class name
  bases_S19011C17, 6,
  &(vtc_S19011C17[0]), // expected_vtbl_contents
  &(vtt_S19011C17[0]), // expected_vtt_contents
  ABISELECT(784,492), // object size
  NSPAIRA(_ZTI9S19011C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19011C17),27, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C17),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C16  : S19011C9 , S19011C13 , S19011C2 , virtual S19011C17 , S19011C8 {
  __tsi64 s19011c16f0;
  char s19011c16f1;
  void *s19011c16f2;
  void *s19011c16f3;
  void *s19011c16f4;
  ::S19012C6 s19011c16f5;
  char s19011c16f6;
  char s19011c16f7;
  void *s19011c16f8;
  int s19011c16f9:6;
  int s19011c16f10;
  ::S19012C11_nt s19011c16f11;
  ::S19012C11_nt s19011c16f12;
  ::S19011C10 s19011c16f13[7];
  ::S19012C11_nt s19011c16f14;
  ~S19011C16(); // tgen
  S19011C16(); // tgen
};
//SIG(-1 S19011C16) C1{ BC2{ VBC3{ m Fl FL Fp[3]} BC4{ BC5{ BC3 vd v1 v2 v3 FC3 FC3 FC3[3] Fp} VBC3 vd Fs FD Fp[2] FL FC3 Fp[6] Fi Fp FC6{}[10] FC6[4] Fi} BC7{ BC5 FC3 Fi FC3 Fp FU8{ m} FU9{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU9} vd v4 v5 FD Fc[8] FU9 Fi Fi FC6 FD FD} BC10{ BC3 vd v6 FU9 Fc[5] FD} BC7 VBC11{ VBC10 VBC4 v7 FL Fc Fc FL FC3 Fp Fs FL FL Fc} BC12{ VBC7 VBC3 BC2 BC4 vd v8 FU8 Fc} FL Fc Fp Fp Fp FU9 Fc Fc Fp Fi:6 Fi FC6 FC6 FC4[7] FC6}


S19011C16 ::~S19011C16(){ note_dtor("S19011C16", this);} // tgen
S19011C16 ::S19011C16(){ note_ctor("S19011C16", this);} // tgen

static void Test_S19011C16()
{
  extern Class_Descriptor cd_S19011C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(540,1333)];
    init_test(&cd_S19011C16, buf);
    S19011C16 *dp, &lv = *(dp=new (buf) S19011C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8624,5328), "sizeof(S19011C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C16)");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*), ABISELECT(7240,4456), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*), ABISELECT(8,4), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*), 0, "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*), 0, "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*), ABISELECT(456,264), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*), ABISELECT(448,260), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*), ABISELECT(448,260), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C9*), 0, "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(1240,784), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C13 */ AMB_check_base_class_offset(lv, (S19011C13*), ABISELECT(1232,780), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(1432,916), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(1424,912), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*), ABISELECT(1424,912), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(7400,4560), "S19011C16");
    check_base_class_offset(lv, (S19011C13*)(S19011C17*), ABISELECT(7392,4556), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(7592,4692), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*), ABISELECT(7584,4688), "S19011C16");
    check_base_class_offset(lv, (S19011C10*)(S19011C17*), ABISELECT(7584,4688), "S19011C16");
    check_base_class_offset(lv, (S19011C17*), ABISELECT(7280,4480), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(8040,4952), "S19011C16");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(8032,4948), "S19011C16");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*), ABISELECT(8032,4948), "S19011C16");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(2024,1296), "S19011C16");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(2016,1292), "S19011C16");
    check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(2016,1292), "S19011C16");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(2472,1556), "S19011C16");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(2464,1552), "S19011C16");
    check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(2464,1552), "S19011C16");
    check_base_class_offset(lv, (S19011C9*)(S19011C8*), ABISELECT(2016,1292), "S19011C16");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(3256,2076), "S19011C16");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(3248,2072), "S19011C16");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*), ABISELECT(3248,2072), "S19011C16");
    check_base_class_offset(lv, (S19011C8*), ABISELECT(2016,1292), "S19011C16");
    check_field_offset(lv, s19011c16f0, ABISELECT(3688,2336), "S19011C16.s19011c16f0");
    check_field_offset(lv, s19011c16f1, ABISELECT(3696,2344), "S19011C16.s19011c16f1");
    check_field_offset(lv, s19011c16f2, ABISELECT(3704,2348), "S19011C16.s19011c16f2");
    check_field_offset(lv, s19011c16f3, ABISELECT(3712,2352), "S19011C16.s19011c16f3");
    check_field_offset(lv, s19011c16f4, ABISELECT(3720,2356), "S19011C16.s19011c16f4");
    check_field_offset(lv, s19011c16f5, ABISELECT(3728,2360), "S19011C16.s19011c16f5");
    check_field_offset(lv, s19011c16f6, ABISELECT(3840,2444), "S19011C16.s19011c16f6");
    check_field_offset(lv, s19011c16f7, ABISELECT(3841,2445), "S19011C16.s19011c16f7");
    check_field_offset(lv, s19011c16f8, ABISELECT(3848,2448), "S19011C16.s19011c16f8");
    set_bf_and_test(lv, s19011c16f9, ABISELECT(3856,2452), 0, 6, 1, "S19011C16");
    set_bf_and_test(lv, s19011c16f9, ABISELECT(3856,2452), 0, 6, hide_sll(1LL<<5), "S19011C16");
    check_field_offset(lv, s19011c16f10, ABISELECT(3860,2456), "S19011C16.s19011c16f10");
    check_field_offset(lv, s19011c16f11, ABISELECT(3864,2460), "S19011C16.s19011c16f11");
    check_field_offset(lv, s19011c16f12, ABISELECT(3865,2461), "S19011C16.s19011c16f12");
    check_field_offset(lv, s19011c16f13, ABISELECT(3872,2464), "S19011C16.s19011c16f13");
    check_field_offset(lv, s19011c16f14, ABISELECT(7232,4452), "S19011C16.s19011c16f14");
    test_class_info(&lv, &cd_S19011C16);
    dp->~S19011C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C16(Test_S19011C16, "S19011C16", ABISELECT(8624,5328));

#else // __cplusplus

extern void _ZN9S19011C16C1Ev();
extern void _ZN9S19011C16D1Ev();
Name_Map name_map_S19011C16[] = {
  NSPAIR(_ZN9S19011C16C1Ev),
  NSPAIR(_ZN9S19011C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C17;
extern VTBL_ENTRY _ZTI9S19011C17[];
extern  VTBL_ENTRY _ZTV9S19011C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C17[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
static Base_Class bases_S19011C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7240,4456), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(448,260), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19011C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(1232,780), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(1432,916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1424,912), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(1424,912), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7400,4560), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(7392,4556), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(7592,4692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(7584,4688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(7584,4688), //bcp->offset
    77, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19011C17,    ABISELECT(7280,4480), //bcp->offset
    60, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8040,4952), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(8032,4948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(8032,4948), //bcp->offset
    89, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(2024,1296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2472,1556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(2464,1552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(2464,1552), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(3256,2076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(3248,2072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(3248,2072), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(2016,1292), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19011C16[];
extern void _ZN9S19011C16D1Ev();
extern void _ZN9S19011C16D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void ABISELECT(_ZThn448_N9S19011C16D1Ev,_ZThn260_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn448_N9S19011C16D0Ev,_ZThn260_N9S19011C16D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1232_N9S19011C16D1Ev,_ZThn780_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn1232_N9S19011C16D0Ev,_ZThn780_N9S19011C16D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZThn1424_N9S19011C16D1Ev,_ZThn912_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn1424_N9S19011C16D0Ev,_ZThn912_N9S19011C16D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn2016_N9S19011C16D1Ev,_ZThn1292_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn2016_N9S19011C16D0Ev,_ZThn1292_N9S19011C16D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZThn2464_N9S19011C16D1Ev,_ZThn1552_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn2464_N9S19011C16D0Ev,_ZThn1552_N9S19011C16D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn3248_N9S19011C16D1Ev,_ZThn2072_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn3248_N9S19011C16D0Ev,_ZThn2072_N9S19011C16D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN9S19011C172v8Ev();
extern void ABISELECT(_ZTv0_n56_N9S19011C16D1Ev,_ZTv0_n28_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn7280_N9S19011C16D1Ev,_ZThn4480_N9S19011C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19011C16D0Ev,_ZTv0_n28_N9S19011C16D0Ev)();
extern void ABISELECT(_ZThn7280_N9S19011C16D0Ev,_ZThn4480_N9S19011C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C16D1Ev,_ZTv0_n12_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn7392_N9S19011C16D1Ev,_ZThn4556_N9S19011C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C16D0Ev,_ZTv0_n12_N9S19011C16D0Ev)();
extern void ABISELECT(_ZThn7392_N9S19011C16D0Ev,_ZThn4556_N9S19011C16D0Ev)() __attribute__((weak));
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZTv0_n32_N9S19011C16D1Ev,_ZTv0_n16_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn7584_N9S19011C16D1Ev,_ZThn4688_N9S19011C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19011C16D0Ev,_ZTv0_n16_N9S19011C16D0Ev)();
extern void ABISELECT(_ZThn7584_N9S19011C16D0Ev,_ZThn4688_N9S19011C16D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19011C16D1Ev,_ZTv0_n12_N9S19011C16D1Ev)();
extern void ABISELECT(_ZThn8032_N9S19011C16D1Ev,_ZThn4948_N9S19011C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C16D0Ev,_ZTv0_n12_N9S19011C16D0Ev)();
extern void ABISELECT(_ZThn8032_N9S19011C16D0Ev,_ZThn4948_N9S19011C16D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY vtc_S19011C16[] = {
  ABISELECT(8032,4948),
  ABISELECT(7584,4688),
  ABISELECT(7392,4556),
  ABISELECT(7280,4480),
  ABISELECT(7240,4456),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&_ZN9S19011C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C16D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  ABISELECT(-448,-260),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19011C16D1Ev,_ZThn260_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19011C16D0Ev,_ZThn260_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N9S19011C16D1Ev,_ZThn780_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N9S19011C16D0Ev,_ZThn780_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  ABISELECT(-1424,-912),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N9S19011C16D1Ev,_ZThn912_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1424_N9S19011C16D0Ev,_ZThn912_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(6016,3656),
  ABISELECT(5224,3164),
  ABISELECT(-2016,-1292),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19011C16D1Ev,_ZThn1292_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2016_N9S19011C16D0Ev,_ZThn1292_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
  ABISELECT(-2464,-1552),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N9S19011C16D1Ev,_ZThn1552_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2464_N9S19011C16D0Ev,_ZThn1552_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(3992,2384),
  ABISELECT(-3248,-2072),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19011C16D1Ev,_ZThn2072_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3248_N9S19011C16D0Ev,_ZThn2072_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  ABISELECT(-7280,-4480),
  0,
  ABISELECT(-40,-24),
  ABISELECT(304,208),
  ABISELECT(112,76),
  ABISELECT(-7280,-4480),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&_ZN9S19011C172v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19011C16D1Ev,_ZTv0_n28_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19011C16D0Ev,_ZTv0_n28_N9S19011C16D0Ev),
  0,
  ABISELECT(-7392,-4556),
  ABISELECT(-7392,-4556),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C16D1Ev,_ZTv0_n12_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C16D0Ev,_ZTv0_n12_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
  0,
  0,
  0,
  ABISELECT(-7584,-4688),
  ABISELECT(-344,-232),
  ABISELECT(-7584,-4688),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C16D1Ev,_ZTv0_n16_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C16D0Ev,_ZTv0_n16_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  0,
  0,
  0,
  ABISELECT(-8032,-4948),
  ABISELECT(-8032,-4948),
  (VTBL_ENTRY)&(_ZTI9S19011C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C16D1Ev,_ZTv0_n12_N9S19011C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C16D0Ev,_ZTv0_n12_N9S19011C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern VTBL_ENTRY _ZTV9S19011C16[];
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C9__9S19011C16[] = {
  ABISELECT(7240,4456),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C9__9S19011C16[] = {
  ABISELECT(7240,4456),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN8S19011C8D1Ev();
extern void _ZN8S19011C8D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C8__9S19011C16[] = {
  ABISELECT(6016,3656),
  ABISELECT(5224,3164),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&_ZN8S19011C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
  (VTBL_ENTRY)&_ZN8S19011C82v6Ev,
};
extern void _ZN8S19011C9D1Ev();
extern void _ZN8S19011C9D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C98S19011C8__A1__9S19011C16[] = {
  ABISELECT(5224,3164),
  0,
  (VTBL_ENTRY)&(_ZTI8S19011C9[0]),
  (VTBL_ENTRY)&_ZN8S19011C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19011C9D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v4Ev,
  (VTBL_ENTRY)&_ZN8S19011C92v5Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C98S19011C8__A2__9S19011C16[] = {
  ABISELECT(5224,3164),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C108S19011C8__A3__9S19011C16[] = {
  ABISELECT(3992,2384),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn6016_N8S19011C8D1Ev,_ZThn3656_N8S19011C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev)();
extern void ABISELECT(_ZThn6016_N8S19011C8D0Ev,_ZThn3656_N8S19011C8D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19011C2__8S19011C8__9S19011C16[] = {
  0,
  0,
  0,
  ABISELECT(-6016,-3656),
  ABISELECT(-6016,-3656),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__8S19011C8__9S19011C16[] = {
  ABISELECT(3992,2384),
  ABISELECT(-1232,-780),
  (VTBL_ENTRY)&(_ZTI8S19011C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D1Ev,_ZThn780_N8S19011C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1232_N8S19011C8D0Ev,_ZThn780_N8S19011C8D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C172v8Ev();
extern void _ZN9S19011C17D1Ev();
extern void _ZN9S19011C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C17__9S19011C16[] = {
  ABISELECT(-40,-24),
  ABISELECT(304,208),
  ABISELECT(112,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&_ZN9S19011C172v8Ev,
  (VTBL_ENTRY)&_ZN9S19011C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev)();
extern void ABISELECT(_ZThn112_N9S19011C17D1Ev,_ZThn76_N9S19011C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev)();
extern void ABISELECT(_ZThn112_N9S19011C17D0Ev,_ZThn76_N9S19011C17D0Ev)() __attribute__((weak));
extern void _ZN9S19011C132v7Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C13__9S19011C17__9S19011C16[] = {
  0,
  ABISELECT(-112,-76),
  ABISELECT(-112,-76),
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19011C132v7Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev)();
extern void ABISELECT(_ZThn304_N9S19011C17D1Ev,_ZThn208_N9S19011C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev)();
extern void ABISELECT(_ZThn304_N9S19011C17D0Ev,_ZThn208_N9S19011C17D0Ev)() __attribute__((weak));
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__9S19011C17__9S19011C16[] = {
  0,
  0,
  0,
  ABISELECT(-304,-208),
  ABISELECT(-344,-232),
  ABISELECT(-304,-208),
  (VTBL_ENTRY)&(_ZTI9S19011C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
extern void _ZN9S19011C10D1Ev();
extern void _ZN9S19011C10D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19011C10__A1__9S19011C16[] = {
  ABISELECT(-344,-232),
  0,
  (VTBL_ENTRY)&(_ZTI9S19011C10[0]),
  (VTBL_ENTRY)&_ZN9S19011C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19011C10D0Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v1Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v2Ev,
  (VTBL_ENTRY)&_ZN8S19011C32v3Ev,
};
static  VTT_ENTRY vtt_S19011C16[] = {
  {&(_ZTV9S19011C16[7]),  7,100},
  {&(_tg__ZTV8S19011C9__9S19011C16[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C9__9S19011C16[3]),  3,8},
  {&(_tg__ZTV8S19011C8__9S19011C16[4]),  4,12},
  {&(_tg__ZTV8S19011C98S19011C8__A1__9S19011C16[3]),  3,10},
  {&(_tg__ZTV9S19011C108S19011C98S19011C8__A2__9S19011C16[3]),  3,8},
  {&(_tg__ZTV9S19011C108S19011C8__A3__9S19011C16[3]),  3,8},
  {&(_tg__ZTV8S19011C2__8S19011C8__9S19011C16[6]),  6,11},
  {&(_tg__ZTV9S19011C10__A1__8S19011C8__9S19011C16[3]),  3,8},
  {&(_ZTV9S19011C16[67]),  67,100},
  {&(_ZTV9S19011C16[74]),  74,100},
  {&(_ZTV9S19011C16[84]),  84,100},
  {&(_ZTV9S19011C16[37]),  37,100},
  {&(_ZTV9S19011C16[95]),  95,100},
  {&(_ZTV9S19011C16[55]),  55,100},
  {&(_tg__ZTV9S19011C17__9S19011C16[5]),  5,8},
  {&(_tg__ZTV9S19011C13__9S19011C17__9S19011C16[4]),  4,7},
  {&(_tg__ZTV9S19011C10__9S19011C17__9S19011C16[7]),  7,12},
  {&(_tg__ZTV9S19011C10__A1__9S19011C16[3]),  3,8},
};
extern VTBL_ENTRY _ZTI9S19011C16[];
extern  VTBL_ENTRY _ZTV9S19011C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C16[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C17D0Ev,_ZTv0_n16_N9S19011C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19011C17D0Ev,_ZThn208_N9S19011C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C17D1Ev,_ZTv0_n16_N9S19011C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N9S19011C17D1Ev,_ZThn208_N9S19011C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C17D0Ev,_ZTv0_n12_N9S19011C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19011C17D0Ev,_ZThn76_N9S19011C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C17D1Ev,_ZTv0_n12_N9S19011C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S19011C17D1Ev,_ZThn76_N9S19011C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D0Ev,_ZTv0_n12_N8S19011C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6016_N8S19011C8D0Ev,_ZThn3656_N8S19011C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19011C8D1Ev,_ZTv0_n12_N8S19011C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6016_N8S19011C8D1Ev,_ZThn3656_N8S19011C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C16D0Ev,_ZTv0_n16_N9S19011C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7584_N9S19011C16D0Ev,_ZThn4688_N9S19011C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19011C16D1Ev,_ZTv0_n16_N9S19011C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7584_N9S19011C16D1Ev,_ZThn4688_N9S19011C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C16D0Ev,_ZTv0_n12_N9S19011C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8032_N9S19011C16D0Ev,_ZThn4948_N9S19011C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7392_N9S19011C16D0Ev,_ZThn4556_N9S19011C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19011C16D1Ev,_ZTv0_n12_N9S19011C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8032_N9S19011C16D1Ev,_ZThn4948_N9S19011C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7392_N9S19011C16D1Ev,_ZThn4556_N9S19011C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19011C16D0Ev,_ZTv0_n28_N9S19011C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7280_N9S19011C16D0Ev,_ZThn4480_N9S19011C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19011C16D1Ev,_ZTv0_n28_N9S19011C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7280_N9S19011C16D1Ev,_ZThn4480_N9S19011C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19011C16 = {  "S19011C16", // class name
  bases_S19011C16, 33,
  &(vtc_S19011C16[0]), // expected_vtbl_contents
  &(vtt_S19011C16[0]), // expected_vtt_contents
  ABISELECT(8624,5328), // object size
  NSPAIRA(_ZTI9S19011C16),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19011C16),100, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19011C16),19, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19011C1  : virtual S19011C2 , virtual S19011C7 , virtual S19011C13 , S19011C16 , S19011C3 {
  void *s19011c1f0;
  __tsi64 s19011c1f1;
  ::S19012C11_nt s19011c1f2;
  __tsi64 s19011c1f3;
  char s19011c1f4;
  int s19011c1f5;
  void *s19011c1f6;
  void *s19011c1f7;
  __tsi64 s19011c1f8;
  virtual  ~S19011C1(); // _ZN8S19011C1D2Ev
  S19011C1(); // tgen
};
//SIG(1 S19011C1) C1{ VBC2{ BC3{ BC4{ m Fl FL Fp[3]} vd v1 v2 v3 FC4 FC4 FC4[3] Fp} FC4 Fi FC4 Fp FU5{ m} FU6{ m Fi FL FD[7] Fp Fp FD Fp FL[7] Fc} FU6} VBC7{ BC8{ VBC2 VBC4 BC9{ VBC4 BC10{ BC3 VBC4 vd Fs FD Fp[2] FL FC4 Fp[6] Fi Fp FC11{}[10] FC11[4] Fi} BC2 vd v4 v5 FD Fc[8] FU6 Fi Fi FC11 FD FD} BC10 vd v6 FU5 Fc} BC12{ VBC8 BC3 BC13{ BC4 vd v7 FU6 Fc[5] FD} BC4 BC2 vd Fc:3 FU5 Fi FL:36 FL Fp[4] FL FC14{ BC13 VBC2 BC15{ VBC2 VBC4 BC10 VBC3 BC13 v10 v11 Fi FC11 FC11 FC11 FC11 Fi} BC4 v9 Fi Fi Fi Fc:6 FU6 Fl FL Fc FL FC11} Fi:5 FC14} Fc Fc:6 FL[3] FC3 Fc[6] FL} VBC13 BC16{ BC9 BC13 BC2 VBC17{ VBC13 VBC10 v8 FL Fc Fc FL FC4 Fp Fs FL FL Fc} BC8 FL Fc Fp Fp Fp FU6 Fc Fc Fp Fi:6 Fi FC11 FC11 FC10[7] FC11} BC3 vd Fp FL FC11 FL Fc Fi Fp Fp FL}


 S19011C1 ::~S19011C1(){ note_dtor("S19011C1", this);}
S19011C1 ::S19011C1(){ note_ctor("S19011C1", this);} // tgen

static void Test_S19011C1()
{
  extern Class_Descriptor cd_S19011C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1109,2761)];
    init_test(&cd_S19011C1, buf);
    S19011C1 *dp, &lv = *(dp=new (buf) S19011C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(17728,11040), "sizeof(S19011C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19011C1)");
    /*is_ambiguous_... S19011C1::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*), ABISELECT(7576,4660), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*), ABISELECT(7568,4656), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*), ABISELECT(7568,4656), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*)(S19011C7*), ABISELECT(7568,4656), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*), ABISELECT(7568,4656), "S19011C1");
    /*is_ambiguous_... S19011C8::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C8*)(S19011C16*), ABISELECT(7568,4656), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*)(S19011C7*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*)(S19011C7*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C8::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C8*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C9::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C10::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C10*)(S19011C8*)(S19011C16*), ABISELECT(15248,9504), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8168,5040), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8160,5036), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8160,5036), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8616,5300), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8608,5296), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8608,5296), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C9*)(S19011C8*)(S19011C7*), ABISELECT(8160,5036), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*)(S19011C7*), ABISELECT(9400,5820), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*)(S19011C7*), ABISELECT(9392,5816), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*)(S19011C7*), ABISELECT(9392,5816), "S19011C1");
    /*is_ambiguous_... S19011C7::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C8*)(S19011C7*), ABISELECT(8160,5036), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(15304,9532), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(15296,9528), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*), ABISELECT(15296,9528), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(15752,9792), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(15744,9788), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*), ABISELECT(15744,9788), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C9*)(S19011C8*), ABISELECT(15296,9528), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(16536,10312), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*), ABISELECT(16528,10308), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C8 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*), ABISELECT(16528,10308), "S19011C1");
    check_base_class_offset(lv, (S19011C8*)(S19011C12*)(S19011C7*), ABISELECT(15296,9528), "S19011C1");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C12*)(S19011C7*), ABISELECT(9848,6084), "S19011C1");
    /*is_ambiguous_... S19011C12::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C12*)(S19011C7*), ABISELECT(9840,6080), "S19011C1");
    check_base_class_offset(lv, (S19012C4*)(S19011C13*)(S19011C12*)(S19011C7*), ABISELECT(10104,6236), "S19011C1");
    check_base_class_offset(lv, (S19011C13*)(S19011C12*)(S19011C7*), ABISELECT(10096,6232), "S19011C1");
    /*is_ambiguous_... S19011C12::S19012C4 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C12*)(S19011C7*), ABISELECT(10288,6364), "S19011C1");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C12*)(S19011C7*), ABISELECT(10344,6392), "S19011C1");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C12*)(S19011C7*), ABISELECT(10336,6388), "S19011C1");
    /*is_ambiguous_... S19011C12::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C12*)(S19011C7*), ABISELECT(10336,6388), "S19011C1");
    check_base_class_offset(lv, (S19011C12*)(S19011C7*), ABISELECT(9840,6080), "S19011C1");
    check_base_class_offset(lv, (S19011C7*), ABISELECT(8160,5036), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C13*), ABISELECT(16984,10576), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C13 */ AMB_check_base_class_offset(lv, (S19011C13*), ABISELECT(16976,10572), "S19011C1");
    check_base_class_offset(lv, (S19011C13*)(S19011C17*), ABISELECT(16976,10572), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C16*), ABISELECT(8,4), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C16*), 0, "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C16*), 0, "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C16*), ABISELECT(456,264), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C16*), ABISELECT(448,260), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C16*), ABISELECT(448,260), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C9 */ AMB_check_base_class_offset(lv, (S19011C9*)(S19011C16*), 0, "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C13 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C13*)(S19011C16*), ABISELECT(1240,784), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C13 */ AMB_check_base_class_offset(lv, (S19011C13*)(S19011C16*), ABISELECT(1232,780), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C16*), ABISELECT(1432,916), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C16*), ABISELECT(1424,912), "S19011C1");
    /*is_ambiguous_... S19011C16::S19011C2 */ AMB_check_base_class_offset(lv, (S19011C2*)(S19011C16*), ABISELECT(1424,912), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*), ABISELECT(17288,10784), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*), ABISELECT(17280,10780), "S19011C1");
    check_base_class_offset(lv, (S19011C10*)(S19011C17*), ABISELECT(17280,10780), "S19011C1");
    check_base_class_offset(lv, (S19011C17*)(S19011C16*), ABISELECT(17168,10704), "S19011C1");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2024,1296), "S19011C1");
    check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2016,1292), "S19011C1");
    check_base_class_offset(lv, (S19011C10*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2016,1292), "S19011C1");
    check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2472,1556), "S19011C1");
    check_base_class_offset(lv, (S19011C3*)(S19011C2*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2464,1552), "S19011C1");
    check_base_class_offset(lv, (S19011C2*)(S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2464,1552), "S19011C1");
    check_base_class_offset(lv, (S19011C9*)(S19011C8*)(S19011C16*), ABISELECT(2016,1292), "S19011C1");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*)(S19011C10*)(S19011C8*)(S19011C16*), ABISELECT(3256,2076), "S19011C1");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C3*)(S19011C10*)(S19011C8*)(S19011C16*), ABISELECT(3248,2072), "S19011C1");
    /*is_ambiguous_... S19011C8::S19011C10 */ AMB_check_base_class_offset(lv, (S19011C10*)(S19011C8*)(S19011C16*), ABISELECT(3248,2072), "S19011C1");
    check_base_class_offset(lv, (S19011C8*)(S19011C16*), ABISELECT(2016,1292), "S19011C1");
    check_base_class_offset(lv, (S19011C16*), 0, "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C3 */ AMB_check_base_class_offset(lv, (S19012C4*)(S19011C3*), ABISELECT(7248,4460), "S19011C1");
    /*is_ambiguous_... S19011C1::S19011C3 */ AMB_check_base_class_offset(lv, (S19011C3*), ABISELECT(7240,4456), "S19011C1");
    check_field_offset(lv, s19011c1f0, ABISELECT(7496,4608), "S19011C1.s19011c1f0");
    check_field_offset(lv, s19011c1f1, ABISELECT(7504,4612), "S19011C1.s19011c1f1");
    check_field_offset(lv, s19011c1f2, ABISELECT(7512,4620), "S19011C1.s19011c1f2");
    check_field_offset(lv, s19011c1f3, ABISELECT(7520,4624), "S19011C1.s19011c1f3");
    check_field_offset(lv, s19011c1f4, ABISELECT(7528,4632), "S19011C1.s19011c1f4");
    check_field_offset(lv, s19011c1f5, ABISELECT(7532,4636), "S19011C1.s19011c1f5");
    check_field_offset(lv, s19011c1f6, ABISELECT(7536,4640), "S19011C1.s19011c1f6");
    check_field_offset(lv, s19011c1f7, ABISELECT(7544,4644), "S19011C1.s19011c1f7");
    check_field_offset(lv, s19011c1f8, ABISELECT(7552,4648), "S19011C1.s19011c1f8");
    test_class_info(&lv, &cd_S19011C1);
    dp->~S19011C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19011C1(Test_S19011C1, "S19011C1", ABISELECT(17728,11040));

#else // __cplusplus

extern void _ZN8S19011C1C1Ev();
extern void _ZN8S19011C1D2Ev();
Name_Map name_map_S19011C1[] = {
  NSPAIR(_ZN8S19011C1C1Ev),
  NSPAIR(_ZN8S19011C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C12;
extern VTBL_ENTRY _ZTI9S19011C12[];
extern  VTBL_ENTRY _ZTV9S19011C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C12[];
extern Class_Descriptor cd_S19011C7;
extern VTBL_ENTRY _ZTI8S19011C7[];
extern  VTBL_ENTRY _ZTV8S19011C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C7[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C13;
extern VTBL_ENTRY _ZTI9S19011C13[];
extern  VTBL_ENTRY _ZTV9S19011C13[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C17;
extern VTBL_ENTRY _ZTI9S19011C17[];
extern  VTBL_ENTRY _ZTV9S19011C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C17[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C2;
extern VTBL_ENTRY _ZTI8S19011C2[];
extern  VTBL_ENTRY _ZTV8S19011C2[];
extern Class_Descriptor cd_S19011C9;
extern VTBL_ENTRY _ZTI8S19011C9[];
extern  VTBL_ENTRY _ZTV8S19011C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C9[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
extern Class_Descriptor cd_S19011C10;
extern VTBL_ENTRY _ZTI9S19011C10[];
extern  VTBL_ENTRY _ZTV9S19011C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C10[];
extern Class_Descriptor cd_S19011C8;
extern VTBL_ENTRY _ZTI8S19011C8[];
extern  VTBL_ENTRY _ZTV8S19011C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19011C8[];
extern Class_Descriptor cd_S19011C16;
extern VTBL_ENTRY _ZTI9S19011C16[];
extern  VTBL_ENTRY _ZTV9S19011C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19011C16[];
extern Class_Descriptor cd_S19012C4;
extern VTBL_ENTRY _ZTI8S19012C4[];
extern Class_Descriptor cd_S19011C3;
extern VTBL_ENTRY _ZTI8S19011C3[];
extern  VTBL_ENTRY _ZTV8S19011C3[];
static Base_Class bases_S19011C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19012C4,    ABISELECT(7576,4660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(7568,4656), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(7568,4656), //bcp->offset
    69, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(15248,9504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(8168,5040), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(8160,5036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(8160,5036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(8616,5300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(8608,5296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(8608,5296), //bcp->offset
    101, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(8160,5036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(9400,5820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(9392,5816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(9392,5816), //bcp->offset
    108, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(8160,5036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(15304,9532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(15296,9528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(15296,9528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(15752,9792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(15744,9788), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(15744,9788), //bcp->offset
    157, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(15296,9528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(16536,10312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(16528,10308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(16528,10308), //bcp->offset
    164, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(15296,9528), //bcp->offset
    138, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(9848,6084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(9840,6080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10104,6236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(10096,6232), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10288,6364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(10344,6392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(10336,6388), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(10336,6388), //bcp->offset
    131, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19011C12,    ABISELECT(9840,6080), //bcp->offset
    116, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19011C7,    ABISELECT(8160,5036), //bcp->offset
    80, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(16984,10576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(16976,10572), //bcp->offset
    172, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19012C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19011C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S19011C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(456,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(448,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(448,260), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19011C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1240,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S19011C13,    ABISELECT(1232,780), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(1432,916), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(1424,912), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(1424,912), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(17288,10784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(17280,10780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(17280,10780), //bcp->offset
    189, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    53, //immediately_derived
  0, 1},
  {&cd_S19011C17,    ABISELECT(17168,10704), //bcp->offset
    179, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    65, //immediately_derived
  0, 1},
  {&cd_S19012C4,    ABISELECT(2024,1296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    56, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(2472,1556), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    58, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(2464,1552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S19011C2,    ABISELECT(2464,1552), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S19011C9,    ABISELECT(2016,1292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19012C4,    ABISELECT(3256,2076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    62, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(3248,2072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S19011C10,    ABISELECT(3248,2072), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S19011C8,    ABISELECT(2016,1292), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    65, //immediately_derived
  0, 0},
  {&cd_S19011C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19012C4,    ABISELECT(7248,4460), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S19011C3,    ABISELECT(7240,4456), //bcp->offset
    62, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19011C1[];
extern void _ZN8S19011C1D1Ev();
extern void _ZN8S19011C1D0Ev();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void ABISELECT(_ZThn448_N8S19011C1D1Ev,_ZThn260_N8S19011C1D1Ev)();
extern void ABISELECT(_ZThn448_N8S19011C1D0Ev,_ZThn260_N8S19011C1D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn1232_N8S19011C1D1Ev,_ZThn780_N8S19011C1D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19011C1D0Ev,_ZThn780_N8S19011C1D0Ev)();
extern void _ZN9S19011C132v7Ev();
extern void ABISELECT(_ZThn1424_N8S19011C1D1Ev,_ZThn912_N8S19011C1D1Ev)();
extern void ABISELECT(_ZThn1424_N8S19011C1D0Ev,_ZThn912_N8S19011C1D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void ABISELECT(_ZThn2016_N8S19011C1D1Ev,_ZThn1292_N8S19011C1D1Ev)();
extern void ABISELECT(_ZThn2016_N8S19011C1D0Ev,_ZThn1292_N8S19011C1D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011C32v3Ev();
extern void _ZN8S19011C92v4Ev();
extern void _ZN8S19011C92v5Ev();
extern void _ZN8S19011C82v6Ev();
extern void ABISELECT(_ZThn2464_N8S19011C1D1Ev,_ZThn1552_N8S19011C1D1Ev)();
extern void ABISELECT(_ZThn2464_N8S19011C1D0Ev,_ZThn1552_N8S19011C1D0Ev)();
extern void _ZN8S19011C32v1Ev();
extern void _ZN8S19011C32v2Ev();
extern void _ZN8S19011