// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S499C6_nt  {
  int s499c6f0[2];
  void  mf499c6(); // _ZN9S499C6_nt7mf499c6Ev
};
//SIG(-1 S499C6_nt) C1{ m Fi[2]}


void  S499C6_nt ::mf499c6(){}

//skip512 S499C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C5_nt  {
  int s499c5f0;
  __tsi64 s499c5f1;
  void *s499c5f2[4];
  int s499c5f3[2];
  void *s499c5f4;
  ::S499C6_nt s499c5f5;
  void *s499c5f6[2];
  virtual  ~S499C5_nt(); // _ZN9S499C5_ntD1Ev
  virtual void  v19(); // _ZN9S499C5_nt3v19Ev
  virtual void  v20(); // _ZN9S499C5_nt3v20Ev
  virtual void  v21(); // _ZN9S499C5_nt3v21Ev
  virtual void  v22(); // _ZN9S499C5_nt3v22Ev
  virtual void  v23(); // _ZN9S499C5_nt3v23Ev
  virtual void  v24(); // _ZN9S499C5_nt3v24Ev
  virtual void  v25(); // _ZN9S499C5_nt3v25Ev
  virtual void  v26(); // _ZN9S499C5_nt3v26Ev
  virtual void  v27(); // _ZN9S499C5_nt3v27Ev
  virtual void  v28(); // _ZN9S499C5_nt3v28Ev
  virtual void  v29(); // _ZN9S499C5_nt3v29Ev
  virtual void  v30(); // _ZN9S499C5_nt3v30Ev
  virtual void  v31(); // _ZN9S499C5_nt3v31Ev
  virtual void  v32(); // _ZN9S499C5_nt3v32Ev
  virtual void  v33(); // _ZN9S499C5_nt3v33Ev
  virtual void  v34(); // _ZN9S499C5_nt3v34Ev
  virtual void  v35(); // _ZN9S499C5_nt3v35Ev
  virtual void  v36(); // _ZN9S499C5_nt3v36Ev
  virtual void  v37(); // _ZN9S499C5_nt3v37Ev
  virtual void  v38(); // _ZN9S499C5_nt3v38Ev
  virtual void  v39(); // _ZN9S499C5_nt3v39Ev
  virtual void  v40(); // _ZN9S499C5_nt3v40Ev
  virtual void  v41(); // _ZN9S499C5_nt3v41Ev
  virtual void  v42(); // _ZN9S499C5_nt3v42Ev
  virtual void  v43(); // _ZN9S499C5_nt3v43Ev
  virtual void  v44(); // _ZN9S499C5_nt3v44Ev
  virtual void  v45(); // _ZN9S499C5_nt3v45Ev
  virtual void  v46(); // _ZN9S499C5_nt3v46Ev
  virtual void  v47(); // _ZN9S499C5_nt3v47Ev
  virtual void  v48(); // _ZN9S499C5_nt3v48Ev
  virtual void  v49(); // _ZN9S499C5_nt3v49Ev
  virtual void  v50(); // _ZN9S499C5_nt3v50Ev
  virtual void  v51(); // _ZN9S499C5_nt3v51Ev
  virtual void  v52(); // _ZN9S499C5_nt3v52Ev
  virtual void  v53(); // _ZN9S499C5_nt3v53Ev
  virtual void  v54(); // _ZN9S499C5_nt3v54Ev
  virtual void  v55(); // _ZN9S499C5_nt3v55Ev
  virtual void  v56(); // _ZN9S499C5_nt3v56Ev
  virtual void  v57(); // _ZN9S499C5_nt3v57Ev
  virtual void  v58(); // _ZN9S499C5_nt3v58Ev
  virtual void  v59(); // _ZN9S499C5_nt3v59Ev
  virtual void  v60(); // _ZN9S499C5_nt3v60Ev
  virtual void  v61(); // _ZN9S499C5_nt3v61Ev
  virtual void  v62(); // _ZN9S499C5_nt3v62Ev
  virtual void  v63(); // _ZN9S499C5_nt3v63Ev
  virtual void  v64(); // _ZN9S499C5_nt3v64Ev
  virtual void  v65(); // _ZN9S499C5_nt3v65Ev
  virtual void  v66(); // _ZN9S499C5_nt3v66Ev
  virtual void  v67(); // _ZN9S499C5_nt3v67Ev
  virtual void  v68(); // _ZN9S499C5_nt3v68Ev
  virtual void  v69(); // _ZN9S499C5_nt3v69Ev
  virtual void  v70(); // _ZN9S499C5_nt3v70Ev
  virtual void  v71(); // _ZN9S499C5_nt3v71Ev
  virtual void  v72(); // _ZN9S499C5_nt3v72Ev
  virtual void  v73(); // _ZN9S499C5_nt3v73Ev
  virtual void  v74(); // _ZN9S499C5_nt3v74Ev
  virtual void  v75(); // _ZN9S499C5_nt3v75Ev
  virtual void  v76(); // _ZN9S499C5_nt3v76Ev
  virtual void  v77(); // _ZN9S499C5_nt3v77Ev
  virtual void  v78(); // _ZN9S499C5_nt3v78Ev
  virtual void  v79(); // _ZN9S499C5_nt3v79Ev
  virtual void  v80(); // _ZN9S499C5_nt3v80Ev
  virtual void  v81(); // _ZN9S499C5_nt3v81Ev
  virtual void  v82(); // _ZN9S499C5_nt3v82Ev
  S499C5_nt(); // tgen
};
//SIG(-1 S499C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S499C5_nt ::~S499C5_nt(){ note_dtor("S499C5_nt", this);}
void  S499C5_nt ::v19(){vfunc_called(this, "_ZN9S499C5_nt3v19Ev");}
void  S499C5_nt ::v20(){vfunc_called(this, "_ZN9S499C5_nt3v20Ev");}
void  S499C5_nt ::v21(){vfunc_called(this, "_ZN9S499C5_nt3v21Ev");}
void  S499C5_nt ::v22(){vfunc_called(this, "_ZN9S499C5_nt3v22Ev");}
void  S499C5_nt ::v23(){vfunc_called(this, "_ZN9S499C5_nt3v23Ev");}
void  S499C5_nt ::v24(){vfunc_called(this, "_ZN9S499C5_nt3v24Ev");}
void  S499C5_nt ::v25(){vfunc_called(this, "_ZN9S499C5_nt3v25Ev");}
void  S499C5_nt ::v26(){vfunc_called(this, "_ZN9S499C5_nt3v26Ev");}
void  S499C5_nt ::v27(){vfunc_called(this, "_ZN9S499C5_nt3v27Ev");}
void  S499C5_nt ::v28(){vfunc_called(this, "_ZN9S499C5_nt3v28Ev");}
void  S499C5_nt ::v29(){vfunc_called(this, "_ZN9S499C5_nt3v29Ev");}
void  S499C5_nt ::v30(){vfunc_called(this, "_ZN9S499C5_nt3v30Ev");}
void  S499C5_nt ::v31(){vfunc_called(this, "_ZN9S499C5_nt3v31Ev");}
void  S499C5_nt ::v32(){vfunc_called(this, "_ZN9S499C5_nt3v32Ev");}
void  S499C5_nt ::v33(){vfunc_called(this, "_ZN9S499C5_nt3v33Ev");}
void  S499C5_nt ::v34(){vfunc_called(this, "_ZN9S499C5_nt3v34Ev");}
void  S499C5_nt ::v35(){vfunc_called(this, "_ZN9S499C5_nt3v35Ev");}
void  S499C5_nt ::v36(){vfunc_called(this, "_ZN9S499C5_nt3v36Ev");}
void  S499C5_nt ::v37(){vfunc_called(this, "_ZN9S499C5_nt3v37Ev");}
void  S499C5_nt ::v38(){vfunc_called(this, "_ZN9S499C5_nt3v38Ev");}
void  S499C5_nt ::v39(){vfunc_called(this, "_ZN9S499C5_nt3v39Ev");}
void  S499C5_nt ::v40(){vfunc_called(this, "_ZN9S499C5_nt3v40Ev");}
void  S499C5_nt ::v41(){vfunc_called(this, "_ZN9S499C5_nt3v41Ev");}
void  S499C5_nt ::v42(){vfunc_called(this, "_ZN9S499C5_nt3v42Ev");}
void  S499C5_nt ::v43(){vfunc_called(this, "_ZN9S499C5_nt3v43Ev");}
void  S499C5_nt ::v44(){vfunc_called(this, "_ZN9S499C5_nt3v44Ev");}
void  S499C5_nt ::v45(){vfunc_called(this, "_ZN9S499C5_nt3v45Ev");}
void  S499C5_nt ::v46(){vfunc_called(this, "_ZN9S499C5_nt3v46Ev");}
void  S499C5_nt ::v47(){vfunc_called(this, "_ZN9S499C5_nt3v47Ev");}
void  S499C5_nt ::v48(){vfunc_called(this, "_ZN9S499C5_nt3v48Ev");}
void  S499C5_nt ::v49(){vfunc_called(this, "_ZN9S499C5_nt3v49Ev");}
void  S499C5_nt ::v50(){vfunc_called(this, "_ZN9S499C5_nt3v50Ev");}
void  S499C5_nt ::v51(){vfunc_called(this, "_ZN9S499C5_nt3v51Ev");}
void  S499C5_nt ::v52(){vfunc_called(this, "_ZN9S499C5_nt3v52Ev");}
void  S499C5_nt ::v53(){vfunc_called(this, "_ZN9S499C5_nt3v53Ev");}
void  S499C5_nt ::v54(){vfunc_called(this, "_ZN9S499C5_nt3v54Ev");}
void  S499C5_nt ::v55(){vfunc_called(this, "_ZN9S499C5_nt3v55Ev");}
void  S499C5_nt ::v56(){vfunc_called(this, "_ZN9S499C5_nt3v56Ev");}
void  S499C5_nt ::v57(){vfunc_called(this, "_ZN9S499C5_nt3v57Ev");}
void  S499C5_nt ::v58(){vfunc_called(this, "_ZN9S499C5_nt3v58Ev");}
void  S499C5_nt ::v59(){vfunc_called(this, "_ZN9S499C5_nt3v59Ev");}
void  S499C5_nt ::v60(){vfunc_called(this, "_ZN9S499C5_nt3v60Ev");}
void  S499C5_nt ::v61(){vfunc_called(this, "_ZN9S499C5_nt3v61Ev");}
void  S499C5_nt ::v62(){vfunc_called(this, "_ZN9S499C5_nt3v62Ev");}
void  S499C5_nt ::v63(){vfunc_called(this, "_ZN9S499C5_nt3v63Ev");}
void  S499C5_nt ::v64(){vfunc_called(this, "_ZN9S499C5_nt3v64Ev");}
void  S499C5_nt ::v65(){vfunc_called(this, "_ZN9S499C5_nt3v65Ev");}
void  S499C5_nt ::v66(){vfunc_called(this, "_ZN9S499C5_nt3v66Ev");}
void  S499C5_nt ::v67(){vfunc_called(this, "_ZN9S499C5_nt3v67Ev");}
void  S499C5_nt ::v68(){vfunc_called(this, "_ZN9S499C5_nt3v68Ev");}
void  S499C5_nt ::v69(){vfunc_called(this, "_ZN9S499C5_nt3v69Ev");}
void  S499C5_nt ::v70(){vfunc_called(this, "_ZN9S499C5_nt3v70Ev");}
void  S499C5_nt ::v71(){vfunc_called(this, "_ZN9S499C5_nt3v71Ev");}
void  S499C5_nt ::v72(){vfunc_called(this, "_ZN9S499C5_nt3v72Ev");}
void  S499C5_nt ::v73(){vfunc_called(this, "_ZN9S499C5_nt3v73Ev");}
void  S499C5_nt ::v74(){vfunc_called(this, "_ZN9S499C5_nt3v74Ev");}
void  S499C5_nt ::v75(){vfunc_called(this, "_ZN9S499C5_nt3v75Ev");}
void  S499C5_nt ::v76(){vfunc_called(this, "_ZN9S499C5_nt3v76Ev");}
void  S499C5_nt ::v77(){vfunc_called(this, "_ZN9S499C5_nt3v77Ev");}
void  S499C5_nt ::v78(){vfunc_called(this, "_ZN9S499C5_nt3v78Ev");}
void  S499C5_nt ::v79(){vfunc_called(this, "_ZN9S499C5_nt3v79Ev");}
void  S499C5_nt ::v80(){vfunc_called(this, "_ZN9S499C5_nt3v80Ev");}
void  S499C5_nt ::v81(){vfunc_called(this, "_ZN9S499C5_nt3v81Ev");}
void  S499C5_nt ::v82(){vfunc_called(this, "_ZN9S499C5_nt3v82Ev");}
S499C5_nt ::S499C5_nt(){ note_ctor("S499C5_nt", this);} // tgen

//skip512 S499C5_nt

#else // __cplusplus

extern void _ZN9S499C5_ntC1Ev();
extern void _ZN9S499C5_ntD1Ev();
Name_Map name_map_S499C5_nt[] = {
  NSPAIR(_ZN9S499C5_ntC1Ev),
  NSPAIR(_ZN9S499C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S499C5_nt[];
extern void _ZN9S499C5_ntD1Ev();
extern void _ZN9S499C5_ntD0Ev();
extern void _ZN9S499C5_nt3v19Ev();
extern void _ZN9S499C5_nt3v20Ev();
extern void _ZN9S499C5_nt3v21Ev();
extern void _ZN9S499C5_nt3v22Ev();
extern void _ZN9S499C5_nt3v23Ev();
extern void _ZN9S499C5_nt3v24Ev();
extern void _ZN9S499C5_nt3v25Ev();
extern void _ZN9S499C5_nt3v26Ev();
extern void _ZN9S499C5_nt3v27Ev();
extern void _ZN9S499C5_nt3v28Ev();
extern void _ZN9S499C5_nt3v29Ev();
extern void _ZN9S499C5_nt3v30Ev();
extern void _ZN9S499C5_nt3v31Ev();
extern void _ZN9S499C5_nt3v32Ev();
extern void _ZN9S499C5_nt3v33Ev();
extern void _ZN9S499C5_nt3v34Ev();
extern void _ZN9S499C5_nt3v35Ev();
extern void _ZN9S499C5_nt3v36Ev();
extern void _ZN9S499C5_nt3v37Ev();
extern void _ZN9S499C5_nt3v38Ev();
extern void _ZN9S499C5_nt3v39Ev();
extern void _ZN9S499C5_nt3v40Ev();
extern void _ZN9S499C5_nt3v41Ev();
extern void _ZN9S499C5_nt3v42Ev();
extern void _ZN9S499C5_nt3v43Ev();
extern void _ZN9S499C5_nt3v44Ev();
extern void _ZN9S499C5_nt3v45Ev();
extern void _ZN9S499C5_nt3v46Ev();
extern void _ZN9S499C5_nt3v47Ev();
extern void _ZN9S499C5_nt3v48Ev();
extern void _ZN9S499C5_nt3v49Ev();
extern void _ZN9S499C5_nt3v50Ev();
extern void _ZN9S499C5_nt3v51Ev();
extern void _ZN9S499C5_nt3v52Ev();
extern void _ZN9S499C5_nt3v53Ev();
extern void _ZN9S499C5_nt3v54Ev();
extern void _ZN9S499C5_nt3v55Ev();
extern void _ZN9S499C5_nt3v56Ev();
extern void _ZN9S499C5_nt3v57Ev();
extern void _ZN9S499C5_nt3v58Ev();
extern void _ZN9S499C5_nt3v59Ev();
extern void _ZN9S499C5_nt3v60Ev();
extern void _ZN9S499C5_nt3v61Ev();
extern void _ZN9S499C5_nt3v62Ev();
extern void _ZN9S499C5_nt3v63Ev();
extern void _ZN9S499C5_nt3v64Ev();
extern void _ZN9S499C5_nt3v65Ev();
extern void _ZN9S499C5_nt3v66Ev();
extern void _ZN9S499C5_nt3v67Ev();
extern void _ZN9S499C5_nt3v68Ev();
extern void _ZN9S499C5_nt3v69Ev();
extern void _ZN9S499C5_nt3v70Ev();
extern void _ZN9S499C5_nt3v71Ev();
extern void _ZN9S499C5_nt3v72Ev();
extern void _ZN9S499C5_nt3v73Ev();
extern void _ZN9S499C5_nt3v74Ev();
extern void _ZN9S499C5_nt3v75Ev();
extern void _ZN9S499C5_nt3v76Ev();
extern void _ZN9S499C5_nt3v77Ev();
extern void _ZN9S499C5_nt3v78Ev();
extern void _ZN9S499C5_nt3v79Ev();
extern void _ZN9S499C5_nt3v80Ev();
extern void _ZN9S499C5_nt3v81Ev();
extern void _ZN9S499C5_nt3v82Ev();
static  VTBL_ENTRY vtc_S499C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S499C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S499C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S499C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v82Ev,
};
extern VTBL_ENTRY _ZTI9S499C5_nt[];
VTBL_ENTRY *P__ZTI9S499C5_nt = _ZTI9S499C5_nt; 
extern  VTBL_ENTRY _ZTV9S499C5_nt[];
Class_Descriptor cd_S499C5_nt = {  "S499C5_nt", // class name
  0,0,//no base classes
  &(vtc_S499C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S499C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S499C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C4_nt  : S499C5_nt {
  virtual  ~S499C4_nt(); // _ZN9S499C4_ntD1Ev
  virtual void  v83(); // _ZN9S499C4_nt3v83Ev
  virtual void  v84(); // _ZN9S499C4_nt3v84Ev
  S499C4_nt(); // tgen
};
//SIG(-1 S499C4_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S499C4_nt ::~S499C4_nt(){ note_dtor("S499C4_nt", this);}
void  S499C4_nt ::v83(){vfunc_called(this, "_ZN9S499C4_nt3v83Ev");}
void  S499C4_nt ::v84(){vfunc_called(this, "_ZN9S499C4_nt3v84Ev");}
S499C4_nt ::S499C4_nt(){ note_ctor("S499C4_nt", this);} // tgen

//skip512 S499C4_nt

#else // __cplusplus

extern void _ZN9S499C4_ntC1Ev();
extern void _ZN9S499C4_ntD1Ev();
Name_Map name_map_S499C4_nt[] = {
  NSPAIR(_ZN9S499C4_ntC1Ev),
  NSPAIR(_ZN9S499C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S499C5_nt;
extern VTBL_ENTRY _ZTI9S499C5_nt[];
extern  VTBL_ENTRY _ZTV9S499C5_nt[];
static Base_Class bases_S499C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S499C4_nt[];
extern void _ZN9S499C4_ntD1Ev();
extern void _ZN9S499C4_ntD0Ev();
extern void _ZN9S499C5_nt3v19Ev();
extern void _ZN9S499C5_nt3v20Ev();
extern void _ZN9S499C5_nt3v21Ev();
extern void _ZN9S499C5_nt3v22Ev();
extern void _ZN9S499C5_nt3v23Ev();
extern void _ZN9S499C5_nt3v24Ev();
extern void _ZN9S499C5_nt3v25Ev();
extern void _ZN9S499C5_nt3v26Ev();
extern void _ZN9S499C5_nt3v27Ev();
extern void _ZN9S499C5_nt3v28Ev();
extern void _ZN9S499C5_nt3v29Ev();
extern void _ZN9S499C5_nt3v30Ev();
extern void _ZN9S499C5_nt3v31Ev();
extern void _ZN9S499C5_nt3v32Ev();
extern void _ZN9S499C5_nt3v33Ev();
extern void _ZN9S499C5_nt3v34Ev();
extern void _ZN9S499C5_nt3v35Ev();
extern void _ZN9S499C5_nt3v36Ev();
extern void _ZN9S499C5_nt3v37Ev();
extern void _ZN9S499C5_nt3v38Ev();
extern void _ZN9S499C5_nt3v39Ev();
extern void _ZN9S499C5_nt3v40Ev();
extern void _ZN9S499C5_nt3v41Ev();
extern void _ZN9S499C5_nt3v42Ev();
extern void _ZN9S499C5_nt3v43Ev();
extern void _ZN9S499C5_nt3v44Ev();
extern void _ZN9S499C5_nt3v45Ev();
extern void _ZN9S499C5_nt3v46Ev();
extern void _ZN9S499C5_nt3v47Ev();
extern void _ZN9S499C5_nt3v48Ev();
extern void _ZN9S499C5_nt3v49Ev();
extern void _ZN9S499C5_nt3v50Ev();
extern void _ZN9S499C5_nt3v51Ev();
extern void _ZN9S499C5_nt3v52Ev();
extern void _ZN9S499C5_nt3v53Ev();
extern void _ZN9S499C5_nt3v54Ev();
extern void _ZN9S499C5_nt3v55Ev();
extern void _ZN9S499C5_nt3v56Ev();
extern void _ZN9S499C5_nt3v57Ev();
extern void _ZN9S499C5_nt3v58Ev();
extern void _ZN9S499C5_nt3v59Ev();
extern void _ZN9S499C5_nt3v60Ev();
extern void _ZN9S499C5_nt3v61Ev();
extern void _ZN9S499C5_nt3v62Ev();
extern void _ZN9S499C5_nt3v63Ev();
extern void _ZN9S499C5_nt3v64Ev();
extern void _ZN9S499C5_nt3v65Ev();
extern void _ZN9S499C5_nt3v66Ev();
extern void _ZN9S499C5_nt3v67Ev();
extern void _ZN9S499C5_nt3v68Ev();
extern void _ZN9S499C5_nt3v69Ev();
extern void _ZN9S499C5_nt3v70Ev();
extern void _ZN9S499C5_nt3v71Ev();
extern void _ZN9S499C5_nt3v72Ev();
extern void _ZN9S499C5_nt3v73Ev();
extern void _ZN9S499C5_nt3v74Ev();
extern void _ZN9S499C5_nt3v75Ev();
extern void _ZN9S499C5_nt3v76Ev();
extern void _ZN9S499C5_nt3v77Ev();
extern void _ZN9S499C5_nt3v78Ev();
extern void _ZN9S499C5_nt3v79Ev();
extern void _ZN9S499C5_nt3v80Ev();
extern void _ZN9S499C5_nt3v81Ev();
extern void _ZN9S499C5_nt3v82Ev();
extern void _ZN9S499C4_nt3v83Ev();
extern void _ZN9S499C4_nt3v84Ev();
static  VTBL_ENTRY vtc_S499C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S499C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S499C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S499C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v84Ev,
};
extern VTBL_ENTRY _ZTI9S499C4_nt[];
VTBL_ENTRY *P__ZTI9S499C4_nt = _ZTI9S499C4_nt; 
extern  VTBL_ENTRY _ZTV9S499C4_nt[];
Class_Descriptor cd_S499C4_nt = {  "S499C4_nt", // class name
  bases_S499C4_nt, 1,
  &(vtc_S499C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S499C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S499C4_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C7_nt  {
  int s499c7f0[4];
  char s499c7f1[9];
  void  mf499c7(); // _ZN9S499C7_nt7mf499c7Ev
};
//SIG(-1 S499C7_nt) C1{ m Fi[4] Fc[9]}


void  S499C7_nt ::mf499c7(){}

//skip512 S499C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C10_nt  {
  void *s499c10f0;
  int s499c10f1[2];
  void  mf499c10(); // _ZN10S499C10_nt8mf499c10Ev
};
//SIG(-1 S499C10_nt) C1{ m Fp Fi[2]}


void  S499C10_nt ::mf499c10(){}

//skip512 S499C10_nt

#else // __cplusplus

Class_Descriptor cd_S499C10_nt = {  "S499C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C9_nt  : S499C10_nt {
};
//SIG(-1 S499C9_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S499C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
static Base_Class bases_S499C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C9_nt = {  "S499C9_nt", // class name
  bases_S499C9_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C8_nt  : S499C9_nt {
};
//SIG(-1 S499C8_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S499C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C9_nt;
static Base_Class bases_S499C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C14  : S499C10_nt {
};
//SIG(-1 S499C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S499C14()
{
  extern Class_Descriptor cd_S499C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C14, buf);
    S499C14 &lv = *(new (buf) S499C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C14)");
    check_base_class_offset(lv, (S499C10_nt*), 0, "S499C14");
    test_class_info(&lv, &cd_S499C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C14(Test_S499C14, "S499C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
static Base_Class bases_S499C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C14 = {  "S499C14", // class name
  bases_S499C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C13  : S499C14 {
};
//SIG(-1 S499C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S499C13()
{
  extern Class_Descriptor cd_S499C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C13, buf);
    S499C13 &lv = *(new (buf) S499C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C13)");
    check_base_class_offset(lv, (S499C10_nt*)(S499C14*), 0, "S499C13");
    check_base_class_offset(lv, (S499C14*), 0, "S499C13");
    test_class_info(&lv, &cd_S499C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C13(Test_S499C13, "S499C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C14;
static Base_Class bases_S499C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C13 = {  "S499C13", // class name
  bases_S499C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C18  : S499C10_nt {
};
//SIG(-1 S499C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S499C18()
{
  extern Class_Descriptor cd_S499C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C18, buf);
    S499C18 &lv = *(new (buf) S499C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C18)");
    check_base_class_offset(lv, (S499C10_nt*), 0, "S499C18");
    test_class_info(&lv, &cd_S499C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C18(Test_S499C18, "S499C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
static Base_Class bases_S499C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C18 = {  "S499C18", // class name
  bases_S499C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C17  : S499C18 {
};
//SIG(-1 S499C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S499C17()
{
  extern Class_Descriptor cd_S499C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C17, buf);
    S499C17 &lv = *(new (buf) S499C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C17)");
    check_base_class_offset(lv, (S499C10_nt*)(S499C18*), 0, "S499C17");
    check_base_class_offset(lv, (S499C18*), 0, "S499C17");
    test_class_info(&lv, &cd_S499C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C17(Test_S499C17, "S499C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C18;
static Base_Class bases_S499C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C17 = {  "S499C17", // class name
  bases_S499C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C19_nt  {
  void *s499c19f0;
  ::S499C6_nt s499c19f1;
  void  mf499c19(); // _ZN10S499C19_nt8mf499c19Ev
};
//SIG(-1 S499C19_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S499C19_nt ::mf499c19(){}

//skip512 S499C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C3_nt  : S499C4_nt {
  ::S499C7_nt s499c3f0;
  int s499c3f1;
  unsigned int s499c3f2:1;
  unsigned int s499c3f3:1;
  unsigned int s499c3f4:1;
  unsigned int s499c3f5:1;
  ::S499C8_nt s499c3f6;
  ::S499C8_nt s499c3f7;
  void *s499c3f8;
  ::S499C13 s499c3f9;
  ::S499C13 s499c3f10;
  ::S499C13 s499c3f11;
  ::S499C17 s499c3f12;
  char s499c3f13;
  int s499c3f14;
  void *s499c3f15;
  ::S499C6_nt s499c3f16;
  ::S499C6_nt s499c3f17;
  ::S499C6_nt s499c3f18;
  ::S499C6_nt s499c3f19;
  ::S499C6_nt s499c3f20;
  ::S499C6_nt s499c3f21;
  ::S499C19_nt s499c3f22;
  ::S499C19_nt s499c3f23;
  ::S499C19_nt s499c3f24;
  ::S499C19_nt s499c3f25;
  ::S499C19_nt s499c3f26;
  ::S499C19_nt s499c3f27;
  ::S499C19_nt s499c3f28;
  ::S499C19_nt s499c3f29;
  ::S499C19_nt s499c3f30;
  ::S499C19_nt s499c3f31;
  virtual  ~S499C3_nt(); // _ZN9S499C3_ntD1Ev
  virtual void  v85(); // _ZN9S499C3_nt3v85Ev
  virtual void  v86(); // _ZN9S499C3_nt3v86Ev
  virtual void  v87(); // _ZN9S499C3_nt3v87Ev
  virtual void  v88(); // _ZN9S499C3_nt3v88Ev
  virtual void  v89(); // _ZN9S499C3_nt3v89Ev
  virtual void  v90(); // _ZN9S499C3_nt3v90Ev
  virtual void  v91(); // _ZN9S499C3_nt3v91Ev
  virtual void  v92(); // _ZN9S499C3_nt3v92Ev
  virtual void  v93(); // _ZN9S499C3_nt3v93Ev
  virtual void  v94(); // _ZN9S499C3_nt3v94Ev
  virtual void  v95(); // _ZN9S499C3_nt3v95Ev
  virtual void  v96(); // _ZN9S499C3_nt3v96Ev
  virtual void  v97(); // _ZN9S499C3_nt3v97Ev
  virtual void  v98(); // _ZN9S499C3_nt3v98Ev
  virtual void  v99(); // _ZN9S499C3_nt3v99Ev
  virtual void  v100(); // _ZN9S499C3_nt4v100Ev
  virtual void  v101(); // _ZN9S499C3_nt4v101Ev
  virtual void  v102(); // _ZN9S499C3_nt4v102Ev
  virtual void  v103(); // _ZN9S499C3_nt4v103Ev
  virtual void  v104(); // _ZN9S499C3_nt4v104Ev
  virtual void  v105(); // _ZN9S499C3_nt4v105Ev
  virtual void  v106(); // _ZN9S499C3_nt4v106Ev
  virtual void  v107(); // _ZN9S499C3_nt4v107Ev
  virtual void  v108(); // _ZN9S499C3_nt4v108Ev
  virtual void  v109(); // _ZN9S499C3_nt4v109Ev
  virtual void  v110(); // _ZN9S499C3_nt4v110Ev
  virtual void  v111(); // _ZN9S499C3_nt4v111Ev
  virtual void  v112(); // _ZN9S499C3_nt4v112Ev
  virtual void  v113(); // _ZN9S499C3_nt4v113Ev
  virtual void  v114(); // _ZN9S499C3_nt4v114Ev
  virtual void  v115(); // _ZN9S499C3_nt4v115Ev
  virtual void  v116(); // _ZN9S499C3_nt4v116Ev
  virtual void  v117(); // _ZN9S499C3_nt4v117Ev
  virtual void  v118(); // _ZN9S499C3_nt4v118Ev
  virtual void  v119(); // _ZN9S499C3_nt4v119Ev
  virtual void  v120(); // _ZN9S499C3_nt4v120Ev
  virtual void  v121(); // _ZN9S499C3_nt4v121Ev
  virtual void  v122(); // _ZN9S499C3_nt4v122Ev
  virtual void  v123(); // _ZN9S499C3_nt4v123Ev
  virtual void  v124(); // _ZN9S499C3_nt4v124Ev
  virtual void  v125(); // _ZN9S499C3_nt4v125Ev
  virtual void  v126(); // _ZN9S499C3_nt4v126Ev
  virtual void  v127(); // _ZN9S499C3_nt4v127Ev
  virtual void  v128(); // _ZN9S499C3_nt4v128Ev
  virtual void  v129(); // _ZN9S499C3_nt4v129Ev
  virtual void  v130(); // _ZN9S499C3_nt4v130Ev
  virtual void  v131(); // _ZN9S499C3_nt4v131Ev
  virtual void  v132(); // _ZN9S499C3_nt4v132Ev
  virtual void  v133(); // _ZN9S499C3_nt4v133Ev
  virtual void  v134(); // _ZN9S499C3_nt4v134Ev
  virtual void  v135(); // _ZN9S499C3_nt4v135Ev
  virtual void  v136(); // _ZN9S499C3_nt4v136Ev
  virtual void  v137(); // _ZN9S499C3_nt4v137Ev
  virtual void  v138(); // _ZN9S499C3_nt4v138Ev
  virtual void  v139(); // _ZN9S499C3_nt4v139Ev
  virtual void  v140(); // _ZN9S499C3_nt4v140Ev
  virtual void  v141(); // _ZN9S499C3_nt4v141Ev
  virtual void  v142(); // _ZN9S499C3_nt4v142Ev
  virtual void  v143(); // _ZN9S499C3_nt4v143Ev
  virtual void  v144(); // _ZN9S499C3_nt4v144Ev
  virtual void  v145(); // _ZN9S499C3_nt4v145Ev
  virtual void  v146(); // _ZN9S499C3_nt4v146Ev
  virtual void  v147(); // _ZN9S499C3_nt4v147Ev
  virtual void  v148(); // _ZN9S499C3_nt4v148Ev
  virtual void  v149(); // _ZN9S499C3_nt4v149Ev
  virtual void  v150(); // _ZN9S499C3_nt4v150Ev
  virtual void  v151(); // _ZN9S499C3_nt4v151Ev
  virtual void  v152(); // _ZN9S499C3_nt4v152Ev
  virtual void  v153(); // _ZN9S499C3_nt4v153Ev
  virtual void  v154(); // _ZN9S499C3_nt4v154Ev
  virtual void  v155(); // _ZN9S499C3_nt4v155Ev
  virtual void  v156(); // _ZN9S499C3_nt4v156Ev
  virtual void  v157(); // _ZN9S499C3_nt4v157Ev
  virtual void  v158(); // _ZN9S499C3_nt4v158Ev
  virtual void  v159(); // _ZN9S499C3_nt4v159Ev
  virtual void  v160(); // _ZN9S499C3_nt4v160Ev
  S499C3_nt(); // tgen
};
//SIG(-1 S499C3_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S499C3_nt ::~S499C3_nt(){ note_dtor("S499C3_nt", this);}
void  S499C3_nt ::v85(){vfunc_called(this, "_ZN9S499C3_nt3v85Ev");}
void  S499C3_nt ::v86(){vfunc_called(this, "_ZN9S499C3_nt3v86Ev");}
void  S499C3_nt ::v87(){vfunc_called(this, "_ZN9S499C3_nt3v87Ev");}
void  S499C3_nt ::v88(){vfunc_called(this, "_ZN9S499C3_nt3v88Ev");}
void  S499C3_nt ::v89(){vfunc_called(this, "_ZN9S499C3_nt3v89Ev");}
void  S499C3_nt ::v90(){vfunc_called(this, "_ZN9S499C3_nt3v90Ev");}
void  S499C3_nt ::v91(){vfunc_called(this, "_ZN9S499C3_nt3v91Ev");}
void  S499C3_nt ::v92(){vfunc_called(this, "_ZN9S499C3_nt3v92Ev");}
void  S499C3_nt ::v93(){vfunc_called(this, "_ZN9S499C3_nt3v93Ev");}
void  S499C3_nt ::v94(){vfunc_called(this, "_ZN9S499C3_nt3v94Ev");}
void  S499C3_nt ::v95(){vfunc_called(this, "_ZN9S499C3_nt3v95Ev");}
void  S499C3_nt ::v96(){vfunc_called(this, "_ZN9S499C3_nt3v96Ev");}
void  S499C3_nt ::v97(){vfunc_called(this, "_ZN9S499C3_nt3v97Ev");}
void  S499C3_nt ::v98(){vfunc_called(this, "_ZN9S499C3_nt3v98Ev");}
void  S499C3_nt ::v99(){vfunc_called(this, "_ZN9S499C3_nt3v99Ev");}
void  S499C3_nt ::v100(){vfunc_called(this, "_ZN9S499C3_nt4v100Ev");}
void  S499C3_nt ::v101(){vfunc_called(this, "_ZN9S499C3_nt4v101Ev");}
void  S499C3_nt ::v102(){vfunc_called(this, "_ZN9S499C3_nt4v102Ev");}
void  S499C3_nt ::v103(){vfunc_called(this, "_ZN9S499C3_nt4v103Ev");}
void  S499C3_nt ::v104(){vfunc_called(this, "_ZN9S499C3_nt4v104Ev");}
void  S499C3_nt ::v105(){vfunc_called(this, "_ZN9S499C3_nt4v105Ev");}
void  S499C3_nt ::v106(){vfunc_called(this, "_ZN9S499C3_nt4v106Ev");}
void  S499C3_nt ::v107(){vfunc_called(this, "_ZN9S499C3_nt4v107Ev");}
void  S499C3_nt ::v108(){vfunc_called(this, "_ZN9S499C3_nt4v108Ev");}
void  S499C3_nt ::v109(){vfunc_called(this, "_ZN9S499C3_nt4v109Ev");}
void  S499C3_nt ::v110(){vfunc_called(this, "_ZN9S499C3_nt4v110Ev");}
void  S499C3_nt ::v111(){vfunc_called(this, "_ZN9S499C3_nt4v111Ev");}
void  S499C3_nt ::v112(){vfunc_called(this, "_ZN9S499C3_nt4v112Ev");}
void  S499C3_nt ::v113(){vfunc_called(this, "_ZN9S499C3_nt4v113Ev");}
void  S499C3_nt ::v114(){vfunc_called(this, "_ZN9S499C3_nt4v114Ev");}
void  S499C3_nt ::v115(){vfunc_called(this, "_ZN9S499C3_nt4v115Ev");}
void  S499C3_nt ::v116(){vfunc_called(this, "_ZN9S499C3_nt4v116Ev");}
void  S499C3_nt ::v117(){vfunc_called(this, "_ZN9S499C3_nt4v117Ev");}
void  S499C3_nt ::v118(){vfunc_called(this, "_ZN9S499C3_nt4v118Ev");}
void  S499C3_nt ::v119(){vfunc_called(this, "_ZN9S499C3_nt4v119Ev");}
void  S499C3_nt ::v120(){vfunc_called(this, "_ZN9S499C3_nt4v120Ev");}
void  S499C3_nt ::v121(){vfunc_called(this, "_ZN9S499C3_nt4v121Ev");}
void  S499C3_nt ::v122(){vfunc_called(this, "_ZN9S499C3_nt4v122Ev");}
void  S499C3_nt ::v123(){vfunc_called(this, "_ZN9S499C3_nt4v123Ev");}
void  S499C3_nt ::v124(){vfunc_called(this, "_ZN9S499C3_nt4v124Ev");}
void  S499C3_nt ::v125(){vfunc_called(this, "_ZN9S499C3_nt4v125Ev");}
void  S499C3_nt ::v126(){vfunc_called(this, "_ZN9S499C3_nt4v126Ev");}
void  S499C3_nt ::v127(){vfunc_called(this, "_ZN9S499C3_nt4v127Ev");}
void  S499C3_nt ::v128(){vfunc_called(this, "_ZN9S499C3_nt4v128Ev");}
void  S499C3_nt ::v129(){vfunc_called(this, "_ZN9S499C3_nt4v129Ev");}
void  S499C3_nt ::v130(){vfunc_called(this, "_ZN9S499C3_nt4v130Ev");}
void  S499C3_nt ::v131(){vfunc_called(this, "_ZN9S499C3_nt4v131Ev");}
void  S499C3_nt ::v132(){vfunc_called(this, "_ZN9S499C3_nt4v132Ev");}
void  S499C3_nt ::v133(){vfunc_called(this, "_ZN9S499C3_nt4v133Ev");}
void  S499C3_nt ::v134(){vfunc_called(this, "_ZN9S499C3_nt4v134Ev");}
void  S499C3_nt ::v135(){vfunc_called(this, "_ZN9S499C3_nt4v135Ev");}
void  S499C3_nt ::v136(){vfunc_called(this, "_ZN9S499C3_nt4v136Ev");}
void  S499C3_nt ::v137(){vfunc_called(this, "_ZN9S499C3_nt4v137Ev");}
void  S499C3_nt ::v138(){vfunc_called(this, "_ZN9S499C3_nt4v138Ev");}
void  S499C3_nt ::v139(){vfunc_called(this, "_ZN9S499C3_nt4v139Ev");}
void  S499C3_nt ::v140(){vfunc_called(this, "_ZN9S499C3_nt4v140Ev");}
void  S499C3_nt ::v141(){vfunc_called(this, "_ZN9S499C3_nt4v141Ev");}
void  S499C3_nt ::v142(){vfunc_called(this, "_ZN9S499C3_nt4v142Ev");}
void  S499C3_nt ::v143(){vfunc_called(this, "_ZN9S499C3_nt4v143Ev");}
void  S499C3_nt ::v144(){vfunc_called(this, "_ZN9S499C3_nt4v144Ev");}
void  S499C3_nt ::v145(){vfunc_called(this, "_ZN9S499C3_nt4v145Ev");}
void  S499C3_nt ::v146(){vfunc_called(this, "_ZN9S499C3_nt4v146Ev");}
void  S499C3_nt ::v147(){vfunc_called(this, "_ZN9S499C3_nt4v147Ev");}
void  S499C3_nt ::v148(){vfunc_called(this, "_ZN9S499C3_nt4v148Ev");}
void  S499C3_nt ::v149(){vfunc_called(this, "_ZN9S499C3_nt4v149Ev");}
void  S499C3_nt ::v150(){vfunc_called(this, "_ZN9S499C3_nt4v150Ev");}
void  S499C3_nt ::v151(){vfunc_called(this, "_ZN9S499C3_nt4v151Ev");}
void  S499C3_nt ::v152(){vfunc_called(this, "_ZN9S499C3_nt4v152Ev");}
void  S499C3_nt ::v153(){vfunc_called(this, "_ZN9S499C3_nt4v153Ev");}
void  S499C3_nt ::v154(){vfunc_called(this, "_ZN9S499C3_nt4v154Ev");}
void  S499C3_nt ::v155(){vfunc_called(this, "_ZN9S499C3_nt4v155Ev");}
void  S499C3_nt ::v156(){vfunc_called(this, "_ZN9S499C3_nt4v156Ev");}
void  S499C3_nt ::v157(){vfunc_called(this, "_ZN9S499C3_nt4v157Ev");}
void  S499C3_nt ::v158(){vfunc_called(this, "_ZN9S499C3_nt4v158Ev");}
void  S499C3_nt ::v159(){vfunc_called(this, "_ZN9S499C3_nt4v159Ev");}
void  S499C3_nt ::v160(){vfunc_called(this, "_ZN9S499C3_nt4v160Ev");}
S499C3_nt ::S499C3_nt(){ note_ctor("S499C3_nt", this);} // tgen

//skip512 S499C3_nt

#else // __cplusplus

extern void _ZN9S499C3_ntC1Ev();
extern void _ZN9S499C3_ntD1Ev();
Name_Map name_map_S499C3_nt[] = {
  NSPAIR(_ZN9S499C3_ntC1Ev),
  NSPAIR(_ZN9S499C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S499C5_nt;
extern VTBL_ENTRY _ZTI9S499C5_nt[];
extern  VTBL_ENTRY _ZTV9S499C5_nt[];
extern Class_Descriptor cd_S499C4_nt;
extern VTBL_ENTRY _ZTI9S499C4_nt[];
extern  VTBL_ENTRY _ZTV9S499C4_nt[];
static Base_Class bases_S499C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S499C3_nt[];
extern void _ZN9S499C3_ntD1Ev();
extern void _ZN9S499C3_ntD0Ev();
extern void _ZN9S499C5_nt3v19Ev();
extern void _ZN9S499C5_nt3v20Ev();
extern void _ZN9S499C5_nt3v21Ev();
extern void _ZN9S499C5_nt3v22Ev();
extern void _ZN9S499C5_nt3v23Ev();
extern void _ZN9S499C5_nt3v24Ev();
extern void _ZN9S499C5_nt3v25Ev();
extern void _ZN9S499C5_nt3v26Ev();
extern void _ZN9S499C5_nt3v27Ev();
extern void _ZN9S499C5_nt3v28Ev();
extern void _ZN9S499C5_nt3v29Ev();
extern void _ZN9S499C5_nt3v30Ev();
extern void _ZN9S499C5_nt3v31Ev();
extern void _ZN9S499C5_nt3v32Ev();
extern void _ZN9S499C5_nt3v33Ev();
extern void _ZN9S499C5_nt3v34Ev();
extern void _ZN9S499C5_nt3v35Ev();
extern void _ZN9S499C5_nt3v36Ev();
extern void _ZN9S499C5_nt3v37Ev();
extern void _ZN9S499C5_nt3v38Ev();
extern void _ZN9S499C5_nt3v39Ev();
extern void _ZN9S499C5_nt3v40Ev();
extern void _ZN9S499C5_nt3v41Ev();
extern void _ZN9S499C5_nt3v42Ev();
extern void _ZN9S499C5_nt3v43Ev();
extern void _ZN9S499C5_nt3v44Ev();
extern void _ZN9S499C5_nt3v45Ev();
extern void _ZN9S499C5_nt3v46Ev();
extern void _ZN9S499C5_nt3v47Ev();
extern void _ZN9S499C5_nt3v48Ev();
extern void _ZN9S499C5_nt3v49Ev();
extern void _ZN9S499C5_nt3v50Ev();
extern void _ZN9S499C5_nt3v51Ev();
extern void _ZN9S499C5_nt3v52Ev();
extern void _ZN9S499C5_nt3v53Ev();
extern void _ZN9S499C5_nt3v54Ev();
extern void _ZN9S499C5_nt3v55Ev();
extern void _ZN9S499C5_nt3v56Ev();
extern void _ZN9S499C5_nt3v57Ev();
extern void _ZN9S499C5_nt3v58Ev();
extern void _ZN9S499C5_nt3v59Ev();
extern void _ZN9S499C5_nt3v60Ev();
extern void _ZN9S499C5_nt3v61Ev();
extern void _ZN9S499C5_nt3v62Ev();
extern void _ZN9S499C5_nt3v63Ev();
extern void _ZN9S499C5_nt3v64Ev();
extern void _ZN9S499C5_nt3v65Ev();
extern void _ZN9S499C5_nt3v66Ev();
extern void _ZN9S499C5_nt3v67Ev();
extern void _ZN9S499C5_nt3v68Ev();
extern void _ZN9S499C5_nt3v69Ev();
extern void _ZN9S499C5_nt3v70Ev();
extern void _ZN9S499C5_nt3v71Ev();
extern void _ZN9S499C5_nt3v72Ev();
extern void _ZN9S499C5_nt3v73Ev();
extern void _ZN9S499C5_nt3v74Ev();
extern void _ZN9S499C5_nt3v75Ev();
extern void _ZN9S499C5_nt3v76Ev();
extern void _ZN9S499C5_nt3v77Ev();
extern void _ZN9S499C5_nt3v78Ev();
extern void _ZN9S499C5_nt3v79Ev();
extern void _ZN9S499C5_nt3v80Ev();
extern void _ZN9S499C5_nt3v81Ev();
extern void _ZN9S499C5_nt3v82Ev();
extern void _ZN9S499C4_nt3v83Ev();
extern void _ZN9S499C4_nt3v84Ev();
extern void _ZN9S499C3_nt3v85Ev();
extern void _ZN9S499C3_nt3v86Ev();
extern void _ZN9S499C3_nt3v87Ev();
extern void _ZN9S499C3_nt3v88Ev();
extern void _ZN9S499C3_nt3v89Ev();
extern void _ZN9S499C3_nt3v90Ev();
extern void _ZN9S499C3_nt3v91Ev();
extern void _ZN9S499C3_nt3v92Ev();
extern void _ZN9S499C3_nt3v93Ev();
extern void _ZN9S499C3_nt3v94Ev();
extern void _ZN9S499C3_nt3v95Ev();
extern void _ZN9S499C3_nt3v96Ev();
extern void _ZN9S499C3_nt3v97Ev();
extern void _ZN9S499C3_nt3v98Ev();
extern void _ZN9S499C3_nt3v99Ev();
extern void _ZN9S499C3_nt4v100Ev();
extern void _ZN9S499C3_nt4v101Ev();
extern void _ZN9S499C3_nt4v102Ev();
extern void _ZN9S499C3_nt4v103Ev();
extern void _ZN9S499C3_nt4v104Ev();
extern void _ZN9S499C3_nt4v105Ev();
extern void _ZN9S499C3_nt4v106Ev();
extern void _ZN9S499C3_nt4v107Ev();
extern void _ZN9S499C3_nt4v108Ev();
extern void _ZN9S499C3_nt4v109Ev();
extern void _ZN9S499C3_nt4v110Ev();
extern void _ZN9S499C3_nt4v111Ev();
extern void _ZN9S499C3_nt4v112Ev();
extern void _ZN9S499C3_nt4v113Ev();
extern void _ZN9S499C3_nt4v114Ev();
extern void _ZN9S499C3_nt4v115Ev();
extern void _ZN9S499C3_nt4v116Ev();
extern void _ZN9S499C3_nt4v117Ev();
extern void _ZN9S499C3_nt4v118Ev();
extern void _ZN9S499C3_nt4v119Ev();
extern void _ZN9S499C3_nt4v120Ev();
extern void _ZN9S499C3_nt4v121Ev();
extern void _ZN9S499C3_nt4v122Ev();
extern void _ZN9S499C3_nt4v123Ev();
extern void _ZN9S499C3_nt4v124Ev();
extern void _ZN9S499C3_nt4v125Ev();
extern void _ZN9S499C3_nt4v126Ev();
extern void _ZN9S499C3_nt4v127Ev();
extern void _ZN9S499C3_nt4v128Ev();
extern void _ZN9S499C3_nt4v129Ev();
extern void _ZN9S499C3_nt4v130Ev();
extern void _ZN9S499C3_nt4v131Ev();
extern void _ZN9S499C3_nt4v132Ev();
extern void _ZN9S499C3_nt4v133Ev();
extern void _ZN9S499C3_nt4v134Ev();
extern void _ZN9S499C3_nt4v135Ev();
extern void _ZN9S499C3_nt4v136Ev();
extern void _ZN9S499C3_nt4v137Ev();
extern void _ZN9S499C3_nt4v138Ev();
extern void _ZN9S499C3_nt4v139Ev();
extern void _ZN9S499C3_nt4v140Ev();
extern void _ZN9S499C3_nt4v141Ev();
extern void _ZN9S499C3_nt4v142Ev();
extern void _ZN9S499C3_nt4v143Ev();
extern void _ZN9S499C3_nt4v144Ev();
extern void _ZN9S499C3_nt4v145Ev();
extern void _ZN9S499C3_nt4v146Ev();
extern void _ZN9S499C3_nt4v147Ev();
extern void _ZN9S499C3_nt4v148Ev();
extern void _ZN9S499C3_nt4v149Ev();
extern void _ZN9S499C3_nt4v150Ev();
extern void _ZN9S499C3_nt4v151Ev();
extern void _ZN9S499C3_nt4v152Ev();
extern void _ZN9S499C3_nt4v153Ev();
extern void _ZN9S499C3_nt4v154Ev();
extern void _ZN9S499C3_nt4v155Ev();
extern void _ZN9S499C3_nt4v156Ev();
extern void _ZN9S499C3_nt4v157Ev();
extern void _ZN9S499C3_nt4v158Ev();
extern void _ZN9S499C3_nt4v159Ev();
extern void _ZN9S499C3_nt4v160Ev();
static  VTBL_ENTRY vtc_S499C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S499C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S499C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S499C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v160Ev,
};
extern VTBL_ENTRY _ZTI9S499C3_nt[];
VTBL_ENTRY *P__ZTI9S499C3_nt = _ZTI9S499C3_nt; 
extern  VTBL_ENTRY _ZTV9S499C3_nt[];
Class_Descriptor cd_S499C3_nt = {  "S499C3_nt", // class name
  bases_S499C3_nt, 2,
  &(vtc_S499C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S499C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S499C3_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C21_nt  {
  int s499c21f0[4];
  void  mf499c21(); // _ZN10S499C21_nt8mf499c21Ev
};
//SIG(-1 S499C21_nt) C1{ m Fi[4]}


void  S499C21_nt ::mf499c21(){}

//skip512 S499C21_nt

#else // __cplusplus

Class_Descriptor cd_S499C21_nt = {  "S499C21_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C20_nt  : S499C21_nt {
};
//SIG(-1 S499C20_nt) C1{ BC2{ m Fi[4]}}



//skip512 S499C20_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C21_nt;
static Base_Class bases_S499C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C22_nt  {
  ::S499C6_nt s499c22f0;
  void *s499c22f1;
  ::S499C20_nt s499c22f2;
  void *s499c22f3;
  void  mf499c22(); // _ZN10S499C22_nt8mf499c22Ev
};
//SIG(-1 S499C22_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S499C22_nt ::mf499c22(){}

//skip512 S499C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C24_nt  {
  void *s499c24f0[8];
  char s499c24f1[4];
  void  mf499c24(); // _ZN10S499C24_nt8mf499c24Ev
};
//SIG(-1 S499C24_nt) C1{ m Fp[8] Fc[4]}


void  S499C24_nt ::mf499c24(){}

//skip512 S499C24_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C26_nt  {
  int s499c26f0[4];
  char s499c26f1[4];
  void  mf499c26(); // _ZN10S499C26_nt8mf499c26Ev
};
//SIG(-1 S499C26_nt) C1{ m Fi[4] Fc[4]}


void  S499C26_nt ::mf499c26(){}

//skip512 S499C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C25_nt  {
  void *s499c25f0[5];
  ::S499C26_nt s499c25f1;
  unsigned int s499c25f2:1;
  unsigned int s499c25f3:1;
  int s499c25f4;
  char s499c25f5[8];
  void  mf499c25(); // _ZN10S499C25_nt8mf499c25Ev
};
//SIG(-1 S499C25_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S499C25_nt ::mf499c25(){}

//skip512 S499C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C29_nt  {
  int s499c29f0[3];
  void  mf499c29(); // _ZN10S499C29_nt8mf499c29Ev
};
//SIG(-1 S499C29_nt) C1{ m Fi[3]}


void  S499C29_nt ::mf499c29(){}

//skip512 S499C29_nt

#else // __cplusplus

Class_Descriptor cd_S499C29_nt = {  "S499C29_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C30_nt  {
  void  mf499c30(); // _ZN10S499C30_nt8mf499c30Ev
};
//SIG(-1 S499C30_nt) C1{ m}


void  S499C30_nt ::mf499c30(){}

//skip512 S499C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C32_nt  {
  int s499c32f0[2];
  char s499c32f1[2];
  void  mf499c32(); // _ZN10S499C32_nt8mf499c32Ev
};
//SIG(-1 S499C32_nt) C1{ m Fi[2] Fc[2]}


void  S499C32_nt ::mf499c32(){}

//skip512 S499C32_nt

#else // __cplusplus

Class_Descriptor cd_S499C32_nt = {  "S499C32_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C31_nt  : S499C32_nt {
  int s499c31f0;
};
//SIG(-1 S499C31_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S499C31_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C32_nt;
static Base_Class bases_S499C31_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C32_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C28_nt  {
  ::S499C29_nt s499c28f0;
  ::S499C30_nt s499c28f1;
  ::S499C31_nt s499c28f2;
  char s499c28f3;
  void  mf499c28(); // _ZN10S499C28_nt8mf499c28Ev
};
//SIG(-1 S499C28_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S499C28_nt ::mf499c28(){}

//skip512 S499C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C36_nt  {
  void *s499c36f0[2];
  void  mf499c36(); // _ZN10S499C36_nt8mf499c36Ev
};
//SIG(-1 S499C36_nt) C1{ m Fp[2]}


void  S499C36_nt ::mf499c36(){}

//skip512 S499C36_nt

#else // __cplusplus

Class_Descriptor cd_S499C36_nt = {  "S499C36_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C35_nt  : S499C36_nt {
};
//SIG(-1 S499C35_nt) C1{ BC2{ m Fp[2]}}



//skip512 S499C35_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C36_nt;
static Base_Class bases_S499C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C39  : S499C10_nt {
};
//SIG(-1 S499C39) C1{ BC2{ m Fp Fi[2]}}



static void Test_S499C39()
{
  extern Class_Descriptor cd_S499C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C39, buf);
    S499C39 &lv = *(new (buf) S499C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C39)");
    check_base_class_offset(lv, (S499C10_nt*), 0, "S499C39");
    test_class_info(&lv, &cd_S499C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C39(Test_S499C39, "S499C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
static Base_Class bases_S499C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C39 = {  "S499C39", // class name
  bases_S499C39, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C38  : S499C39 {
};
//SIG(-1 S499C38) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S499C38()
{
  extern Class_Descriptor cd_S499C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C38, buf);
    S499C38 &lv = *(new (buf) S499C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C38)");
    check_base_class_offset(lv, (S499C10_nt*)(S499C39*), 0, "S499C38");
    check_base_class_offset(lv, (S499C39*), 0, "S499C38");
    test_class_info(&lv, &cd_S499C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C38(Test_S499C38, "S499C38", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C39;
static Base_Class bases_S499C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C38 = {  "S499C38", // class name
  bases_S499C38, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C37_nt  : S499C38 {
};
//SIG(-1 S499C37_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S499C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C39;
extern Class_Descriptor cd_S499C38;
static Base_Class bases_S499C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S499C38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C34_nt  {
  ::S499C35_nt s499c34f0;
  char s499c34f1;
  ::S499C37_nt s499c34f2;
  int s499c34f3;
  ::S499C6_nt s499c34f4;
  ::S499C6_nt s499c34f5;
  void *s499c34f6;
  void  mf499c34(); // _ZN10S499C34_nt8mf499c34Ev
};
//SIG(-1 S499C34_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S499C34_nt ::mf499c34(){}

//skip512 S499C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C43  : S499C10_nt {
};
//SIG(-1 S499C43) C1{ BC2{ m Fp Fi[2]}}



static void Test_S499C43()
{
  extern Class_Descriptor cd_S499C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C43, buf);
    S499C43 &lv = *(new (buf) S499C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C43)");
    check_base_class_offset(lv, (S499C10_nt*), 0, "S499C43");
    test_class_info(&lv, &cd_S499C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C43(Test_S499C43, "S499C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
static Base_Class bases_S499C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C43 = {  "S499C43", // class name
  bases_S499C43, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C42  : S499C43 {
};
//SIG(-1 S499C42) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S499C42()
{
  extern Class_Descriptor cd_S499C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S499C42, buf);
    S499C42 &lv = *(new (buf) S499C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S499C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C42)");
    check_base_class_offset(lv, (S499C10_nt*)(S499C43*), 0, "S499C42");
    check_base_class_offset(lv, (S499C43*), 0, "S499C42");
    test_class_info(&lv, &cd_S499C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C42(Test_S499C42, "S499C42", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S499C10_nt;
extern Class_Descriptor cd_S499C43;
static Base_Class bases_S499C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S499C42 = {  "S499C42", // class name
  bases_S499C42, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C2_nt  : S499C3_nt {
  ::S499C20_nt s499c2f0;
  ::S499C6_nt s499c2f1;
  void *s499c2f2[2];
  ::S499C22_nt s499c2f3;
  ::S499C24_nt s499c2f4;
  int s499c2f5;
  ::S499C25_nt s499c2f6;
  int s499c2f7[4];
  ::S499C6_nt s499c2f8[4];
  ::S499C28_nt s499c2f9;
  ::S499C29_nt s499c2f10;
  int s499c2f11;
  ::S499C34_nt s499c2f12;
  ::S499C34_nt s499c2f13;
  void *s499c2f14;
  ::S499C29_nt s499c2f15;
  ::S499C17 s499c2f16;
  ::S499C42 s499c2f17;
  unsigned int s499c2f18:1;
  unsigned int s499c2f19:1;
  unsigned int s499c2f20:1;
  ::S499C30_nt s499c2f21;
  ::S499C19_nt s499c2f22;
  ::S499C19_nt s499c2f23;
  ::S499C19_nt s499c2f24;
  ::S499C19_nt s499c2f25;
  ::S499C19_nt s499c2f26;
  ::S499C19_nt s499c2f27;
  ::S499C19_nt s499c2f28;
  ::S499C19_nt s499c2f29;
  ::S499C19_nt s499c2f30;
  ::S499C19_nt s499c2f31;
  ::S499C19_nt s499c2f32;
  ::S499C19_nt s499c2f33;
  ::S499C19_nt s499c2f34;
  virtual  ~S499C2_nt(); // _ZN9S499C2_ntD1Ev
  virtual void  v161(); // _ZN9S499C2_nt4v161Ev
  virtual void  v162(); // _ZN9S499C2_nt4v162Ev
  virtual void  v163(); // _ZN9S499C2_nt4v163Ev
  virtual void  v164(); // _ZN9S499C2_nt4v164Ev
  virtual void  v165(); // _ZN9S499C2_nt4v165Ev
  virtual void  v166(); // _ZN9S499C2_nt4v166Ev
  virtual void  v167(); // _ZN9S499C2_nt4v167Ev
  virtual void  v168(); // _ZN9S499C2_nt4v168Ev
  virtual void  v169(); // _ZN9S499C2_nt4v169Ev
  virtual void  v170(); // _ZN9S499C2_nt4v170Ev
  virtual void  v171(); // _ZN9S499C2_nt4v171Ev
  virtual void  v172(); // _ZN9S499C2_nt4v172Ev
  virtual void  v173(); // _ZN9S499C2_nt4v173Ev
  virtual void  v174(); // _ZN9S499C2_nt4v174Ev
  virtual void  v175(); // _ZN9S499C2_nt4v175Ev
  virtual void  v176(); // _ZN9S499C2_nt4v176Ev
  virtual void  v177(); // _ZN9S499C2_nt4v177Ev
  virtual void  v178(); // _ZN9S499C2_nt4v178Ev
  virtual void  v179(); // _ZN9S499C2_nt4v179Ev
  virtual void  v180(); // _ZN9S499C2_nt4v180Ev
  virtual void  v181(); // _ZN9S499C2_nt4v181Ev
  virtual void  v182(); // _ZN9S499C2_nt4v182Ev
  virtual void  v183(); // _ZN9S499C2_nt4v183Ev
  virtual void  v184(); // _ZN9S499C2_nt4v184Ev
  virtual void  v185(); // _ZN9S499C2_nt4v185Ev
  virtual void  v186(); // _ZN9S499C2_nt4v186Ev
  virtual void  v187(); // _ZN9S499C2_nt4v187Ev
  virtual void  v188(); // _ZN9S499C2_nt4v188Ev
  virtual void  v189(); // _ZN9S499C2_nt4v189Ev
  virtual void  v190(); // _ZN9S499C2_nt4v190Ev
  virtual void  v191(); // _ZN9S499C2_nt4v191Ev
  virtual void  v192(); // _ZN9S499C2_nt4v192Ev
  virtual void  v193(); // _ZN9S499C2_nt4v193Ev
  virtual void  v194(); // _ZN9S499C2_nt4v194Ev
  virtual void  v195(); // _ZN9S499C2_nt4v195Ev
  virtual void  v196(); // _ZN9S499C2_nt4v196Ev
  virtual void  v197(); // _ZN9S499C2_nt4v197Ev
  virtual void  v198(); // _ZN9S499C2_nt4v198Ev
  virtual void  v199(); // _ZN9S499C2_nt4v199Ev
  virtual void  v200(); // _ZN9S499C2_nt4v200Ev
  virtual void  v201(); // _ZN9S499C2_nt4v201Ev
  virtual void  v202(); // _ZN9S499C2_nt4v202Ev
  virtual void  v203(); // _ZN9S499C2_nt4v203Ev
  virtual void  v204(); // _ZN9S499C2_nt4v204Ev
  virtual void  v205(); // _ZN9S499C2_nt4v205Ev
  virtual void  v206(); // _ZN9S499C2_nt4v206Ev
  virtual void  v207(); // _ZN9S499C2_nt4v207Ev
  virtual void  v208(); // _ZN9S499C2_nt4v208Ev
  virtual void  v209(); // _ZN9S499C2_nt4v209Ev
  virtual void  v210(); // _ZN9S499C2_nt4v210Ev
  virtual void  v211(); // _ZN9S499C2_nt4v211Ev
  virtual void  v212(); // _ZN9S499C2_nt4v212Ev
  virtual void  v213(); // _ZN9S499C2_nt4v213Ev
  virtual void  v214(); // _ZN9S499C2_nt4v214Ev
  virtual void  v215(); // _ZN9S499C2_nt4v215Ev
  virtual void  v216(); // _ZN9S499C2_nt4v216Ev
  virtual void  v217(); // _ZN9S499C2_nt4v217Ev
  virtual void  v218(); // _ZN9S499C2_nt4v218Ev
  virtual void  v219(); // _ZN9S499C2_nt4v219Ev
  virtual void  v220(); // _ZN9S499C2_nt4v220Ev
  virtual void  v221(); // _ZN9S499C2_nt4v221Ev
  virtual void  v222(); // _ZN9S499C2_nt4v222Ev
  virtual void  v223(); // _ZN9S499C2_nt4v223Ev
  virtual void  v224(); // _ZN9S499C2_nt4v224Ev
  virtual void  v225(); // _ZN9S499C2_nt4v225Ev
  virtual void  v226(); // _ZN9S499C2_nt4v226Ev
  virtual void  v227(); // _ZN9S499C2_nt4v227Ev
  virtual void  v228(); // _ZN9S499C2_nt4v228Ev
  virtual void  v229(); // _ZN9S499C2_nt4v229Ev
  S499C2_nt(); // tgen
};
//SIG(-1 S499C2_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S499C2_nt ::~S499C2_nt(){ note_dtor("S499C2_nt", this);}
void  S499C2_nt ::v161(){vfunc_called(this, "_ZN9S499C2_nt4v161Ev");}
void  S499C2_nt ::v162(){vfunc_called(this, "_ZN9S499C2_nt4v162Ev");}
void  S499C2_nt ::v163(){vfunc_called(this, "_ZN9S499C2_nt4v163Ev");}
void  S499C2_nt ::v164(){vfunc_called(this, "_ZN9S499C2_nt4v164Ev");}
void  S499C2_nt ::v165(){vfunc_called(this, "_ZN9S499C2_nt4v165Ev");}
void  S499C2_nt ::v166(){vfunc_called(this, "_ZN9S499C2_nt4v166Ev");}
void  S499C2_nt ::v167(){vfunc_called(this, "_ZN9S499C2_nt4v167Ev");}
void  S499C2_nt ::v168(){vfunc_called(this, "_ZN9S499C2_nt4v168Ev");}
void  S499C2_nt ::v169(){vfunc_called(this, "_ZN9S499C2_nt4v169Ev");}
void  S499C2_nt ::v170(){vfunc_called(this, "_ZN9S499C2_nt4v170Ev");}
void  S499C2_nt ::v171(){vfunc_called(this, "_ZN9S499C2_nt4v171Ev");}
void  S499C2_nt ::v172(){vfunc_called(this, "_ZN9S499C2_nt4v172Ev");}
void  S499C2_nt ::v173(){vfunc_called(this, "_ZN9S499C2_nt4v173Ev");}
void  S499C2_nt ::v174(){vfunc_called(this, "_ZN9S499C2_nt4v174Ev");}
void  S499C2_nt ::v175(){vfunc_called(this, "_ZN9S499C2_nt4v175Ev");}
void  S499C2_nt ::v176(){vfunc_called(this, "_ZN9S499C2_nt4v176Ev");}
void  S499C2_nt ::v177(){vfunc_called(this, "_ZN9S499C2_nt4v177Ev");}
void  S499C2_nt ::v178(){vfunc_called(this, "_ZN9S499C2_nt4v178Ev");}
void  S499C2_nt ::v179(){vfunc_called(this, "_ZN9S499C2_nt4v179Ev");}
void  S499C2_nt ::v180(){vfunc_called(this, "_ZN9S499C2_nt4v180Ev");}
void  S499C2_nt ::v181(){vfunc_called(this, "_ZN9S499C2_nt4v181Ev");}
void  S499C2_nt ::v182(){vfunc_called(this, "_ZN9S499C2_nt4v182Ev");}
void  S499C2_nt ::v183(){vfunc_called(this, "_ZN9S499C2_nt4v183Ev");}
void  S499C2_nt ::v184(){vfunc_called(this, "_ZN9S499C2_nt4v184Ev");}
void  S499C2_nt ::v185(){vfunc_called(this, "_ZN9S499C2_nt4v185Ev");}
void  S499C2_nt ::v186(){vfunc_called(this, "_ZN9S499C2_nt4v186Ev");}
void  S499C2_nt ::v187(){vfunc_called(this, "_ZN9S499C2_nt4v187Ev");}
void  S499C2_nt ::v188(){vfunc_called(this, "_ZN9S499C2_nt4v188Ev");}
void  S499C2_nt ::v189(){vfunc_called(this, "_ZN9S499C2_nt4v189Ev");}
void  S499C2_nt ::v190(){vfunc_called(this, "_ZN9S499C2_nt4v190Ev");}
void  S499C2_nt ::v191(){vfunc_called(this, "_ZN9S499C2_nt4v191Ev");}
void  S499C2_nt ::v192(){vfunc_called(this, "_ZN9S499C2_nt4v192Ev");}
void  S499C2_nt ::v193(){vfunc_called(this, "_ZN9S499C2_nt4v193Ev");}
void  S499C2_nt ::v194(){vfunc_called(this, "_ZN9S499C2_nt4v194Ev");}
void  S499C2_nt ::v195(){vfunc_called(this, "_ZN9S499C2_nt4v195Ev");}
void  S499C2_nt ::v196(){vfunc_called(this, "_ZN9S499C2_nt4v196Ev");}
void  S499C2_nt ::v197(){vfunc_called(this, "_ZN9S499C2_nt4v197Ev");}
void  S499C2_nt ::v198(){vfunc_called(this, "_ZN9S499C2_nt4v198Ev");}
void  S499C2_nt ::v199(){vfunc_called(this, "_ZN9S499C2_nt4v199Ev");}
void  S499C2_nt ::v200(){vfunc_called(this, "_ZN9S499C2_nt4v200Ev");}
void  S499C2_nt ::v201(){vfunc_called(this, "_ZN9S499C2_nt4v201Ev");}
void  S499C2_nt ::v202(){vfunc_called(this, "_ZN9S499C2_nt4v202Ev");}
void  S499C2_nt ::v203(){vfunc_called(this, "_ZN9S499C2_nt4v203Ev");}
void  S499C2_nt ::v204(){vfunc_called(this, "_ZN9S499C2_nt4v204Ev");}
void  S499C2_nt ::v205(){vfunc_called(this, "_ZN9S499C2_nt4v205Ev");}
void  S499C2_nt ::v206(){vfunc_called(this, "_ZN9S499C2_nt4v206Ev");}
void  S499C2_nt ::v207(){vfunc_called(this, "_ZN9S499C2_nt4v207Ev");}
void  S499C2_nt ::v208(){vfunc_called(this, "_ZN9S499C2_nt4v208Ev");}
void  S499C2_nt ::v209(){vfunc_called(this, "_ZN9S499C2_nt4v209Ev");}
void  S499C2_nt ::v210(){vfunc_called(this, "_ZN9S499C2_nt4v210Ev");}
void  S499C2_nt ::v211(){vfunc_called(this, "_ZN9S499C2_nt4v211Ev");}
void  S499C2_nt ::v212(){vfunc_called(this, "_ZN9S499C2_nt4v212Ev");}
void  S499C2_nt ::v213(){vfunc_called(this, "_ZN9S499C2_nt4v213Ev");}
void  S499C2_nt ::v214(){vfunc_called(this, "_ZN9S499C2_nt4v214Ev");}
void  S499C2_nt ::v215(){vfunc_called(this, "_ZN9S499C2_nt4v215Ev");}
void  S499C2_nt ::v216(){vfunc_called(this, "_ZN9S499C2_nt4v216Ev");}
void  S499C2_nt ::v217(){vfunc_called(this, "_ZN9S499C2_nt4v217Ev");}
void  S499C2_nt ::v218(){vfunc_called(this, "_ZN9S499C2_nt4v218Ev");}
void  S499C2_nt ::v219(){vfunc_called(this, "_ZN9S499C2_nt4v219Ev");}
void  S499C2_nt ::v220(){vfunc_called(this, "_ZN9S499C2_nt4v220Ev");}
void  S499C2_nt ::v221(){vfunc_called(this, "_ZN9S499C2_nt4v221Ev");}
void  S499C2_nt ::v222(){vfunc_called(this, "_ZN9S499C2_nt4v222Ev");}
void  S499C2_nt ::v223(){vfunc_called(this, "_ZN9S499C2_nt4v223Ev");}
void  S499C2_nt ::v224(){vfunc_called(this, "_ZN9S499C2_nt4v224Ev");}
void  S499C2_nt ::v225(){vfunc_called(this, "_ZN9S499C2_nt4v225Ev");}
void  S499C2_nt ::v226(){vfunc_called(this, "_ZN9S499C2_nt4v226Ev");}
void  S499C2_nt ::v227(){vfunc_called(this, "_ZN9S499C2_nt4v227Ev");}
void  S499C2_nt ::v228(){vfunc_called(this, "_ZN9S499C2_nt4v228Ev");}
void  S499C2_nt ::v229(){vfunc_called(this, "_ZN9S499C2_nt4v229Ev");}
S499C2_nt ::S499C2_nt(){ note_ctor("S499C2_nt", this);} // tgen

//skip512 S499C2_nt

#else // __cplusplus

extern void _ZN9S499C2_ntC1Ev();
extern void _ZN9S499C2_ntD1Ev();
Name_Map name_map_S499C2_nt[] = {
  NSPAIR(_ZN9S499C2_ntC1Ev),
  NSPAIR(_ZN9S499C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S499C5_nt;
extern VTBL_ENTRY _ZTI9S499C5_nt[];
extern  VTBL_ENTRY _ZTV9S499C5_nt[];
extern Class_Descriptor cd_S499C4_nt;
extern VTBL_ENTRY _ZTI9S499C4_nt[];
extern  VTBL_ENTRY _ZTV9S499C4_nt[];
extern Class_Descriptor cd_S499C3_nt;
extern VTBL_ENTRY _ZTI9S499C3_nt[];
extern  VTBL_ENTRY _ZTV9S499C3_nt[];
static Base_Class bases_S499C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S499C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S499C2_nt[];
extern void _ZN9S499C2_ntD1Ev();
extern void _ZN9S499C2_ntD0Ev();
extern void _ZN9S499C5_nt3v19Ev();
extern void _ZN9S499C5_nt3v20Ev();
extern void _ZN9S499C5_nt3v21Ev();
extern void _ZN9S499C5_nt3v22Ev();
extern void _ZN9S499C5_nt3v23Ev();
extern void _ZN9S499C5_nt3v24Ev();
extern void _ZN9S499C5_nt3v25Ev();
extern void _ZN9S499C5_nt3v26Ev();
extern void _ZN9S499C5_nt3v27Ev();
extern void _ZN9S499C5_nt3v28Ev();
extern void _ZN9S499C5_nt3v29Ev();
extern void _ZN9S499C5_nt3v30Ev();
extern void _ZN9S499C5_nt3v31Ev();
extern void _ZN9S499C5_nt3v32Ev();
extern void _ZN9S499C5_nt3v33Ev();
extern void _ZN9S499C5_nt3v34Ev();
extern void _ZN9S499C5_nt3v35Ev();
extern void _ZN9S499C5_nt3v36Ev();
extern void _ZN9S499C5_nt3v37Ev();
extern void _ZN9S499C5_nt3v38Ev();
extern void _ZN9S499C5_nt3v39Ev();
extern void _ZN9S499C5_nt3v40Ev();
extern void _ZN9S499C5_nt3v41Ev();
extern void _ZN9S499C5_nt3v42Ev();
extern void _ZN9S499C5_nt3v43Ev();
extern void _ZN9S499C5_nt3v44Ev();
extern void _ZN9S499C5_nt3v45Ev();
extern void _ZN9S499C5_nt3v46Ev();
extern void _ZN9S499C5_nt3v47Ev();
extern void _ZN9S499C5_nt3v48Ev();
extern void _ZN9S499C5_nt3v49Ev();
extern void _ZN9S499C5_nt3v50Ev();
extern void _ZN9S499C5_nt3v51Ev();
extern void _ZN9S499C5_nt3v52Ev();
extern void _ZN9S499C5_nt3v53Ev();
extern void _ZN9S499C5_nt3v54Ev();
extern void _ZN9S499C5_nt3v55Ev();
extern void _ZN9S499C5_nt3v56Ev();
extern void _ZN9S499C5_nt3v57Ev();
extern void _ZN9S499C5_nt3v58Ev();
extern void _ZN9S499C5_nt3v59Ev();
extern void _ZN9S499C5_nt3v60Ev();
extern void _ZN9S499C5_nt3v61Ev();
extern void _ZN9S499C5_nt3v62Ev();
extern void _ZN9S499C5_nt3v63Ev();
extern void _ZN9S499C5_nt3v64Ev();
extern void _ZN9S499C5_nt3v65Ev();
extern void _ZN9S499C5_nt3v66Ev();
extern void _ZN9S499C5_nt3v67Ev();
extern void _ZN9S499C5_nt3v68Ev();
extern void _ZN9S499C5_nt3v69Ev();
extern void _ZN9S499C5_nt3v70Ev();
extern void _ZN9S499C5_nt3v71Ev();
extern void _ZN9S499C5_nt3v72Ev();
extern void _ZN9S499C5_nt3v73Ev();
extern void _ZN9S499C5_nt3v74Ev();
extern void _ZN9S499C5_nt3v75Ev();
extern void _ZN9S499C5_nt3v76Ev();
extern void _ZN9S499C5_nt3v77Ev();
extern void _ZN9S499C5_nt3v78Ev();
extern void _ZN9S499C5_nt3v79Ev();
extern void _ZN9S499C5_nt3v80Ev();
extern void _ZN9S499C5_nt3v81Ev();
extern void _ZN9S499C5_nt3v82Ev();
extern void _ZN9S499C4_nt3v83Ev();
extern void _ZN9S499C4_nt3v84Ev();
extern void _ZN9S499C3_nt3v85Ev();
extern void _ZN9S499C3_nt3v86Ev();
extern void _ZN9S499C3_nt3v87Ev();
extern void _ZN9S499C3_nt3v88Ev();
extern void _ZN9S499C3_nt3v89Ev();
extern void _ZN9S499C3_nt3v90Ev();
extern void _ZN9S499C3_nt3v91Ev();
extern void _ZN9S499C3_nt3v92Ev();
extern void _ZN9S499C3_nt3v93Ev();
extern void _ZN9S499C3_nt3v94Ev();
extern void _ZN9S499C3_nt3v95Ev();
extern void _ZN9S499C3_nt3v96Ev();
extern void _ZN9S499C3_nt3v97Ev();
extern void _ZN9S499C3_nt3v98Ev();
extern void _ZN9S499C3_nt3v99Ev();
extern void _ZN9S499C3_nt4v100Ev();
extern void _ZN9S499C3_nt4v101Ev();
extern void _ZN9S499C3_nt4v102Ev();
extern void _ZN9S499C3_nt4v103Ev();
extern void _ZN9S499C3_nt4v104Ev();
extern void _ZN9S499C3_nt4v105Ev();
extern void _ZN9S499C3_nt4v106Ev();
extern void _ZN9S499C3_nt4v107Ev();
extern void _ZN9S499C3_nt4v108Ev();
extern void _ZN9S499C3_nt4v109Ev();
extern void _ZN9S499C3_nt4v110Ev();
extern void _ZN9S499C3_nt4v111Ev();
extern void _ZN9S499C3_nt4v112Ev();
extern void _ZN9S499C3_nt4v113Ev();
extern void _ZN9S499C3_nt4v114Ev();
extern void _ZN9S499C3_nt4v115Ev();
extern void _ZN9S499C3_nt4v116Ev();
extern void _ZN9S499C3_nt4v117Ev();
extern void _ZN9S499C3_nt4v118Ev();
extern void _ZN9S499C3_nt4v119Ev();
extern void _ZN9S499C3_nt4v120Ev();
extern void _ZN9S499C3_nt4v121Ev();
extern void _ZN9S499C3_nt4v122Ev();
extern void _ZN9S499C3_nt4v123Ev();
extern void _ZN9S499C3_nt4v124Ev();
extern void _ZN9S499C3_nt4v125Ev();
extern void _ZN9S499C3_nt4v126Ev();
extern void _ZN9S499C3_nt4v127Ev();
extern void _ZN9S499C3_nt4v128Ev();
extern void _ZN9S499C3_nt4v129Ev();
extern void _ZN9S499C3_nt4v130Ev();
extern void _ZN9S499C3_nt4v131Ev();
extern void _ZN9S499C3_nt4v132Ev();
extern void _ZN9S499C3_nt4v133Ev();
extern void _ZN9S499C3_nt4v134Ev();
extern void _ZN9S499C3_nt4v135Ev();
extern void _ZN9S499C3_nt4v136Ev();
extern void _ZN9S499C3_nt4v137Ev();
extern void _ZN9S499C3_nt4v138Ev();
extern void _ZN9S499C3_nt4v139Ev();
extern void _ZN9S499C3_nt4v140Ev();
extern void _ZN9S499C3_nt4v141Ev();
extern void _ZN9S499C3_nt4v142Ev();
extern void _ZN9S499C3_nt4v143Ev();
extern void _ZN9S499C3_nt4v144Ev();
extern void _ZN9S499C3_nt4v145Ev();
extern void _ZN9S499C3_nt4v146Ev();
extern void _ZN9S499C3_nt4v147Ev();
extern void _ZN9S499C3_nt4v148Ev();
extern void _ZN9S499C3_nt4v149Ev();
extern void _ZN9S499C3_nt4v150Ev();
extern void _ZN9S499C3_nt4v151Ev();
extern void _ZN9S499C3_nt4v152Ev();
extern void _ZN9S499C3_nt4v153Ev();
extern void _ZN9S499C3_nt4v154Ev();
extern void _ZN9S499C3_nt4v155Ev();
extern void _ZN9S499C3_nt4v156Ev();
extern void _ZN9S499C3_nt4v157Ev();
extern void _ZN9S499C3_nt4v158Ev();
extern void _ZN9S499C3_nt4v159Ev();
extern void _ZN9S499C3_nt4v160Ev();
extern void _ZN9S499C2_nt4v161Ev();
extern void _ZN9S499C2_nt4v162Ev();
extern void _ZN9S499C2_nt4v163Ev();
extern void _ZN9S499C2_nt4v164Ev();
extern void _ZN9S499C2_nt4v165Ev();
extern void _ZN9S499C2_nt4v166Ev();
extern void _ZN9S499C2_nt4v167Ev();
extern void _ZN9S499C2_nt4v168Ev();
extern void _ZN9S499C2_nt4v169Ev();
extern void _ZN9S499C2_nt4v170Ev();
extern void _ZN9S499C2_nt4v171Ev();
extern void _ZN9S499C2_nt4v172Ev();
extern void _ZN9S499C2_nt4v173Ev();
extern void _ZN9S499C2_nt4v174Ev();
extern void _ZN9S499C2_nt4v175Ev();
extern void _ZN9S499C2_nt4v176Ev();
extern void _ZN9S499C2_nt4v177Ev();
extern void _ZN9S499C2_nt4v178Ev();
extern void _ZN9S499C2_nt4v179Ev();
extern void _ZN9S499C2_nt4v180Ev();
extern void _ZN9S499C2_nt4v181Ev();
extern void _ZN9S499C2_nt4v182Ev();
extern void _ZN9S499C2_nt4v183Ev();
extern void _ZN9S499C2_nt4v184Ev();
extern void _ZN9S499C2_nt4v185Ev();
extern void _ZN9S499C2_nt4v186Ev();
extern void _ZN9S499C2_nt4v187Ev();
extern void _ZN9S499C2_nt4v188Ev();
extern void _ZN9S499C2_nt4v189Ev();
extern void _ZN9S499C2_nt4v190Ev();
extern void _ZN9S499C2_nt4v191Ev();
extern void _ZN9S499C2_nt4v192Ev();
extern void _ZN9S499C2_nt4v193Ev();
extern void _ZN9S499C2_nt4v194Ev();
extern void _ZN9S499C2_nt4v195Ev();
extern void _ZN9S499C2_nt4v196Ev();
extern void _ZN9S499C2_nt4v197Ev();
extern void _ZN9S499C2_nt4v198Ev();
extern void _ZN9S499C2_nt4v199Ev();
extern void _ZN9S499C2_nt4v200Ev();
extern void _ZN9S499C2_nt4v201Ev();
extern void _ZN9S499C2_nt4v202Ev();
extern void _ZN9S499C2_nt4v203Ev();
extern void _ZN9S499C2_nt4v204Ev();
extern void _ZN9S499C2_nt4v205Ev();
extern void _ZN9S499C2_nt4v206Ev();
extern void _ZN9S499C2_nt4v207Ev();
extern void _ZN9S499C2_nt4v208Ev();
extern void _ZN9S499C2_nt4v209Ev();
extern void _ZN9S499C2_nt4v210Ev();
extern void _ZN9S499C2_nt4v211Ev();
extern void _ZN9S499C2_nt4v212Ev();
extern void _ZN9S499C2_nt4v213Ev();
extern void _ZN9S499C2_nt4v214Ev();
extern void _ZN9S499C2_nt4v215Ev();
extern void _ZN9S499C2_nt4v216Ev();
extern void _ZN9S499C2_nt4v217Ev();
extern void _ZN9S499C2_nt4v218Ev();
extern void _ZN9S499C2_nt4v219Ev();
extern void _ZN9S499C2_nt4v220Ev();
extern void _ZN9S499C2_nt4v221Ev();
extern void _ZN9S499C2_nt4v222Ev();
extern void _ZN9S499C2_nt4v223Ev();
extern void _ZN9S499C2_nt4v224Ev();
extern void _ZN9S499C2_nt4v225Ev();
extern void _ZN9S499C2_nt4v226Ev();
extern void _ZN9S499C2_nt4v227Ev();
extern void _ZN9S499C2_nt4v228Ev();
extern void _ZN9S499C2_nt4v229Ev();
static  VTBL_ENTRY vtc_S499C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S499C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S499C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S499C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v229Ev,
};
extern VTBL_ENTRY _ZTI9S499C2_nt[];
VTBL_ENTRY *P__ZTI9S499C2_nt = _ZTI9S499C2_nt; 
extern  VTBL_ENTRY _ZTV9S499C2_nt[];
Class_Descriptor cd_S499C2_nt = {  "S499C2_nt", // class name
  bases_S499C2_nt, 3,
  &(vtc_S499C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S499C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S499C2_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C46_nt  {
  virtual  ~S499C46_nt(); // _ZN10S499C46_ntD1Ev
  virtual void  v230(); // _ZN10S499C46_nt4v230Ev
  virtual void  v231(); // _ZN10S499C46_nt4v231Ev
  virtual void  v232(); // _ZN10S499C46_nt4v232Ev
  virtual void  v233(); // _ZN10S499C46_nt4v233Ev
  virtual void  v234(); // _ZN10S499C46_nt4v234Ev
  virtual void  v235(); // _ZN10S499C46_nt4v235Ev
  virtual void  v236(); // _ZN10S499C46_nt4v236Ev
  S499C46_nt(); // tgen
};
//SIG(-1 S499C46_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7}


 S499C46_nt ::~S499C46_nt(){ note_dtor("S499C46_nt", this);}
void  S499C46_nt ::v230(){vfunc_called(this, "_ZN10S499C46_nt4v230Ev");}
void  S499C46_nt ::v231(){vfunc_called(this, "_ZN10S499C46_nt4v231Ev");}
void  S499C46_nt ::v232(){vfunc_called(this, "_ZN10S499C46_nt4v232Ev");}
void  S499C46_nt ::v233(){vfunc_called(this, "_ZN10S499C46_nt4v233Ev");}
void  S499C46_nt ::v234(){vfunc_called(this, "_ZN10S499C46_nt4v234Ev");}
void  S499C46_nt ::v235(){vfunc_called(this, "_ZN10S499C46_nt4v235Ev");}
void  S499C46_nt ::v236(){vfunc_called(this, "_ZN10S499C46_nt4v236Ev");}
S499C46_nt ::S499C46_nt(){ note_ctor("S499C46_nt", this);} // tgen

//skip512 S499C46_nt

#else // __cplusplus

extern void _ZN10S499C46_ntC1Ev();
extern void _ZN10S499C46_ntD1Ev();
Name_Map name_map_S499C46_nt[] = {
  NSPAIR(_ZN10S499C46_ntC1Ev),
  NSPAIR(_ZN10S499C46_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S499C46_nt[];
extern void _ZN10S499C46_ntD1Ev();
extern void _ZN10S499C46_ntD0Ev();
extern void _ZN10S499C46_nt4v230Ev();
extern void _ZN10S499C46_nt4v231Ev();
extern void _ZN10S499C46_nt4v232Ev();
extern void _ZN10S499C46_nt4v233Ev();
extern void _ZN10S499C46_nt4v234Ev();
extern void _ZN10S499C46_nt4v235Ev();
extern void _ZN10S499C46_nt4v236Ev();
static  VTBL_ENTRY vtc_S499C46_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S499C46_nt[0]),
  (VTBL_ENTRY)&_ZN10S499C46_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S499C46_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v236Ev,
};
extern VTBL_ENTRY _ZTI10S499C46_nt[];
VTBL_ENTRY *P__ZTI10S499C46_nt = _ZTI10S499C46_nt; 
extern  VTBL_ENTRY _ZTV10S499C46_nt[];
Class_Descriptor cd_S499C46_nt = {  "S499C46_nt", // class name
  0,0,//no base classes
  &(vtc_S499C46_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S499C46_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S499C46_nt),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C45_nt  : S499C46_nt {
  virtual  ~S499C45_nt(); // _ZN10S499C45_ntD1Ev
  virtual void  v237(); // _ZN10S499C45_nt4v237Ev
  S499C45_nt(); // tgen
};
//SIG(-1 S499C45_nt) C1{ BC2{ vd v2 v3 v4 v5 v6 v7 v8} vd v1}


 S499C45_nt ::~S499C45_nt(){ note_dtor("S499C45_nt", this);}
void  S499C45_nt ::v237(){vfunc_called(this, "_ZN10S499C45_nt4v237Ev");}
S499C45_nt ::S499C45_nt(){ note_ctor("S499C45_nt", this);} // tgen

//skip512 S499C45_nt

#else // __cplusplus

extern void _ZN10S499C45_ntC1Ev();
extern void _ZN10S499C45_ntD1Ev();
Name_Map name_map_S499C45_nt[] = {
  NSPAIR(_ZN10S499C45_ntC1Ev),
  NSPAIR(_ZN10S499C45_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S499C46_nt;
extern VTBL_ENTRY _ZTI10S499C46_nt[];
extern  VTBL_ENTRY _ZTV10S499C46_nt[];
static Base_Class bases_S499C45_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C46_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S499C45_nt[];
extern void _ZN10S499C45_ntD1Ev();
extern void _ZN10S499C45_ntD0Ev();
extern void _ZN10S499C46_nt4v230Ev();
extern void _ZN10S499C46_nt4v231Ev();
extern void _ZN10S499C46_nt4v232Ev();
extern void _ZN10S499C46_nt4v233Ev();
extern void _ZN10S499C46_nt4v234Ev();
extern void _ZN10S499C46_nt4v235Ev();
extern void _ZN10S499C46_nt4v236Ev();
extern void _ZN10S499C45_nt4v237Ev();
static  VTBL_ENTRY vtc_S499C45_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S499C45_nt[0]),
  (VTBL_ENTRY)&_ZN10S499C45_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S499C45_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S499C45_nt4v237Ev,
};
extern VTBL_ENTRY _ZTI10S499C45_nt[];
VTBL_ENTRY *P__ZTI10S499C45_nt = _ZTI10S499C45_nt; 
extern  VTBL_ENTRY _ZTV10S499C45_nt[];
Class_Descriptor cd_S499C45_nt = {  "S499C45_nt", // class name
  bases_S499C45_nt, 1,
  &(vtc_S499C45_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S499C45_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S499C45_nt),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C47_nt  {
  int s499c47f0[4];
  unsigned int s499c47f1:1;
  void  mf499c47(); // _ZN10S499C47_nt8mf499c47Ev
};
//SIG(-1 S499C47_nt) C1{ m Fi[4] Fi:1}


void  S499C47_nt ::mf499c47(){}

//skip512 S499C47_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S499C1  : S499C2_nt , S499C45_nt {
  void *s499c1f0[3];
  unsigned int s499c1f1:1;
  ::S499C34_nt s499c1f2;
  ::S499C47_nt s499c1f3;
  char s499c1f4;
  virtual  ~S499C1(); // _ZN6S499C1D1Ev
  virtual void  v1(); // _ZN6S499C12v1Ev
  virtual void  v2(); // _ZN6S499C12v2Ev
  virtual void  v3(); // _ZN6S499C12v3Ev
  virtual void  v4(); // _ZN6S499C12v4Ev
  virtual void  v5(); // _ZN6S499C12v5Ev
  virtual void  v6(); // _ZN6S499C12v6Ev
  virtual void  v7(); // _ZN6S499C12v7Ev
  virtual void  v8(); // _ZN6S499C12v8Ev
  virtual void  v9(); // _ZN6S499C12v9Ev
  virtual void  v10(); // _ZN6S499C13v10Ev
  virtual void  v11(); // _ZN6S499C13v11Ev
  virtual void  v12(); // _ZN6S499C13v12Ev
  virtual void  v13(); // _ZN6S499C13v13Ev
  virtual void  v14(); // _ZN6S499C13v14Ev
  virtual void  v15(); // _ZN6S499C13v15Ev
  virtual void  v16(); // _ZN6S499C13v16Ev
  virtual void  v17(); // _ZN6S499C13v17Ev
  virtual void  v18(); // _ZN6S499C13v18Ev
  S499C1(); // tgen
};
//SIG(1 S499C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v83 v84} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} BC35{ BC36{ vd v230 v231 v232 v233 v234 v235 v236} vd v237} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 Fp[3] Fi:1 FC27 FC37{ m Fi[4] Fi:1} Fc}


 S499C1 ::~S499C1(){ note_dtor("S499C1", this);}
void  S499C1 ::v1(){vfunc_called(this, "_ZN6S499C12v1Ev");}
void  S499C1 ::v2(){vfunc_called(this, "_ZN6S499C12v2Ev");}
void  S499C1 ::v3(){vfunc_called(this, "_ZN6S499C12v3Ev");}
void  S499C1 ::v4(){vfunc_called(this, "_ZN6S499C12v4Ev");}
void  S499C1 ::v5(){vfunc_called(this, "_ZN6S499C12v5Ev");}
void  S499C1 ::v6(){vfunc_called(this, "_ZN6S499C12v6Ev");}
void  S499C1 ::v7(){vfunc_called(this, "_ZN6S499C12v7Ev");}
void  S499C1 ::v8(){vfunc_called(this, "_ZN6S499C12v8Ev");}
void  S499C1 ::v9(){vfunc_called(this, "_ZN6S499C12v9Ev");}
void  S499C1 ::v10(){vfunc_called(this, "_ZN6S499C13v10Ev");}
void  S499C1 ::v11(){vfunc_called(this, "_ZN6S499C13v11Ev");}
void  S499C1 ::v12(){vfunc_called(this, "_ZN6S499C13v12Ev");}
void  S499C1 ::v13(){vfunc_called(this, "_ZN6S499C13v13Ev");}
void  S499C1 ::v14(){vfunc_called(this, "_ZN6S499C13v14Ev");}
void  S499C1 ::v15(){vfunc_called(this, "_ZN6S499C13v15Ev");}
void  S499C1 ::v16(){vfunc_called(this, "_ZN6S499C13v16Ev");}
void  S499C1 ::v17(){vfunc_called(this, "_ZN6S499C13v17Ev");}
void  S499C1 ::v18(){vfunc_called(this, "_ZN6S499C13v18Ev");}
S499C1 ::S499C1(){ note_ctor("S499C1", this);} // tgen

static void Test_S499C1()
{
  extern Class_Descriptor cd_S499C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(171,251)];
    init_test(&cd_S499C1, buf);
    S499C1 *dp, &lv = *(dp=new (buf) S499C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1360,1000), "sizeof(S499C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S499C1)");
    check_base_class_offset(lv, (S499C5_nt*)(S499C4_nt*)(S499C3_nt*)(S499C2_nt*), 0, "S499C1");
    check_base_class_offset(lv, (S499C4_nt*)(S499C3_nt*)(S499C2_nt*), 0, "S499C1");
    check_base_class_offset(lv, (S499C3_nt*)(S499C2_nt*), 0, "S499C1");
    check_base_class_offset(lv, (S499C2_nt*), 0, "S499C1");
    check_base_class_offset(lv, (S499C46_nt*)(S499C45_nt*), ABISELECT(1224,908), "S499C1");
    check_base_class_offset(lv, (S499C45_nt*), ABISELECT(1224,908), "S499C1");
    check_field_offset(lv, s499c1f0, ABISELECT(1232,912), "S499C1.s499c1f0");
    set_bf_and_test(lv, s499c1f1, ABISELECT(1256,924), 0, 1, 1, "S499C1");
    check_field_offset(lv, s499c1f2, ABISELECT(1264,928), "S499C1.s499c1f2");
    check_field_offset(lv, s499c1f3, ABISELECT(1336,976), "S499C1.s499c1f3");
    check_field_offset(lv, s499c1f4, ABISELECT(1356,996), "S499C1.s499c1f4");
    test_class_info(&lv, &cd_S499C1);
    dp->~S499C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS499C1(Test_S499C1, "S499C1", ABISELECT(1360,1000));

#else // __cplusplus

extern void _ZN6S499C1C1Ev();
extern void _ZN6S499C1D1Ev();
Name_Map name_map_S499C1[] = {
  NSPAIR(_ZN6S499C1C1Ev),
  NSPAIR(_ZN6S499C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S499C5_nt;
extern VTBL_ENTRY _ZTI9S499C5_nt[];
extern  VTBL_ENTRY _ZTV9S499C5_nt[];
extern Class_Descriptor cd_S499C4_nt;
extern VTBL_ENTRY _ZTI9S499C4_nt[];
extern  VTBL_ENTRY _ZTV9S499C4_nt[];
extern Class_Descriptor cd_S499C3_nt;
extern VTBL_ENTRY _ZTI9S499C3_nt[];
extern  VTBL_ENTRY _ZTV9S499C3_nt[];
extern Class_Descriptor cd_S499C2_nt;
extern VTBL_ENTRY _ZTI9S499C2_nt[];
extern  VTBL_ENTRY _ZTV9S499C2_nt[];
extern Class_Descriptor cd_S499C46_nt;
extern VTBL_ENTRY _ZTI10S499C46_nt[];
extern  VTBL_ENTRY _ZTV10S499C46_nt[];
extern Class_Descriptor cd_S499C45_nt;
extern VTBL_ENTRY _ZTI10S499C45_nt[];
extern  VTBL_ENTRY _ZTV10S499C45_nt[];
static Base_Class bases_S499C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S499C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S499C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S499C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S499C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S499C46_nt,    ABISELECT(1224,908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S499C45_nt,    ABISELECT(1224,908), //bcp->offset
    233, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S499C1[];
extern void _ZN6S499C1D1Ev();
extern void _ZN6S499C1D0Ev();
extern void _ZN9S499C5_nt3v19Ev();
extern void _ZN9S499C5_nt3v20Ev();
extern void _ZN9S499C5_nt3v21Ev();
extern void _ZN9S499C5_nt3v22Ev();
extern void _ZN9S499C5_nt3v23Ev();
extern void _ZN9S499C5_nt3v24Ev();
extern void _ZN9S499C5_nt3v25Ev();
extern void _ZN9S499C5_nt3v26Ev();
extern void _ZN9S499C5_nt3v27Ev();
extern void _ZN9S499C5_nt3v28Ev();
extern void _ZN9S499C5_nt3v29Ev();
extern void _ZN9S499C5_nt3v30Ev();
extern void _ZN9S499C5_nt3v31Ev();
extern void _ZN9S499C5_nt3v32Ev();
extern void _ZN9S499C5_nt3v33Ev();
extern void _ZN9S499C5_nt3v34Ev();
extern void _ZN9S499C5_nt3v35Ev();
extern void _ZN9S499C5_nt3v36Ev();
extern void _ZN9S499C5_nt3v37Ev();
extern void _ZN9S499C5_nt3v38Ev();
extern void _ZN9S499C5_nt3v39Ev();
extern void _ZN9S499C5_nt3v40Ev();
extern void _ZN9S499C5_nt3v41Ev();
extern void _ZN9S499C5_nt3v42Ev();
extern void _ZN9S499C5_nt3v43Ev();
extern void _ZN9S499C5_nt3v44Ev();
extern void _ZN9S499C5_nt3v45Ev();
extern void _ZN9S499C5_nt3v46Ev();
extern void _ZN9S499C5_nt3v47Ev();
extern void _ZN9S499C5_nt3v48Ev();
extern void _ZN9S499C5_nt3v49Ev();
extern void _ZN9S499C5_nt3v50Ev();
extern void _ZN9S499C5_nt3v51Ev();
extern void _ZN9S499C5_nt3v52Ev();
extern void _ZN9S499C5_nt3v53Ev();
extern void _ZN9S499C5_nt3v54Ev();
extern void _ZN9S499C5_nt3v55Ev();
extern void _ZN9S499C5_nt3v56Ev();
extern void _ZN9S499C5_nt3v57Ev();
extern void _ZN9S499C5_nt3v58Ev();
extern void _ZN9S499C5_nt3v59Ev();
extern void _ZN9S499C5_nt3v60Ev();
extern void _ZN9S499C5_nt3v61Ev();
extern void _ZN9S499C5_nt3v62Ev();
extern void _ZN9S499C5_nt3v63Ev();
extern void _ZN9S499C5_nt3v64Ev();
extern void _ZN9S499C5_nt3v65Ev();
extern void _ZN9S499C5_nt3v66Ev();
extern void _ZN9S499C5_nt3v67Ev();
extern void _ZN9S499C5_nt3v68Ev();
extern void _ZN9S499C5_nt3v69Ev();
extern void _ZN9S499C5_nt3v70Ev();
extern void _ZN9S499C5_nt3v71Ev();
extern void _ZN9S499C5_nt3v72Ev();
extern void _ZN9S499C5_nt3v73Ev();
extern void _ZN9S499C5_nt3v74Ev();
extern void _ZN9S499C5_nt3v75Ev();
extern void _ZN9S499C5_nt3v76Ev();
extern void _ZN9S499C5_nt3v77Ev();
extern void _ZN9S499C5_nt3v78Ev();
extern void _ZN9S499C5_nt3v79Ev();
extern void _ZN9S499C5_nt3v80Ev();
extern void _ZN9S499C5_nt3v81Ev();
extern void _ZN9S499C5_nt3v82Ev();
extern void _ZN9S499C4_nt3v83Ev();
extern void _ZN9S499C4_nt3v84Ev();
extern void _ZN9S499C3_nt3v85Ev();
extern void _ZN9S499C3_nt3v86Ev();
extern void _ZN9S499C3_nt3v87Ev();
extern void _ZN9S499C3_nt3v88Ev();
extern void _ZN9S499C3_nt3v89Ev();
extern void _ZN9S499C3_nt3v90Ev();
extern void _ZN9S499C3_nt3v91Ev();
extern void _ZN9S499C3_nt3v92Ev();
extern void _ZN9S499C3_nt3v93Ev();
extern void _ZN9S499C3_nt3v94Ev();
extern void _ZN9S499C3_nt3v95Ev();
extern void _ZN9S499C3_nt3v96Ev();
extern void _ZN9S499C3_nt3v97Ev();
extern void _ZN9S499C3_nt3v98Ev();
extern void _ZN9S499C3_nt3v99Ev();
extern void _ZN9S499C3_nt4v100Ev();
extern void _ZN9S499C3_nt4v101Ev();
extern void _ZN9S499C3_nt4v102Ev();
extern void _ZN9S499C3_nt4v103Ev();
extern void _ZN9S499C3_nt4v104Ev();
extern void _ZN9S499C3_nt4v105Ev();
extern void _ZN9S499C3_nt4v106Ev();
extern void _ZN9S499C3_nt4v107Ev();
extern void _ZN9S499C3_nt4v108Ev();
extern void _ZN9S499C3_nt4v109Ev();
extern void _ZN9S499C3_nt4v110Ev();
extern void _ZN9S499C3_nt4v111Ev();
extern void _ZN9S499C3_nt4v112Ev();
extern void _ZN9S499C3_nt4v113Ev();
extern void _ZN9S499C3_nt4v114Ev();
extern void _ZN9S499C3_nt4v115Ev();
extern void _ZN9S499C3_nt4v116Ev();
extern void _ZN9S499C3_nt4v117Ev();
extern void _ZN9S499C3_nt4v118Ev();
extern void _ZN9S499C3_nt4v119Ev();
extern void _ZN9S499C3_nt4v120Ev();
extern void _ZN9S499C3_nt4v121Ev();
extern void _ZN9S499C3_nt4v122Ev();
extern void _ZN9S499C3_nt4v123Ev();
extern void _ZN9S499C3_nt4v124Ev();
extern void _ZN9S499C3_nt4v125Ev();
extern void _ZN9S499C3_nt4v126Ev();
extern void _ZN9S499C3_nt4v127Ev();
extern void _ZN9S499C3_nt4v128Ev();
extern void _ZN9S499C3_nt4v129Ev();
extern void _ZN9S499C3_nt4v130Ev();
extern void _ZN9S499C3_nt4v131Ev();
extern void _ZN9S499C3_nt4v132Ev();
extern void _ZN9S499C3_nt4v133Ev();
extern void _ZN9S499C3_nt4v134Ev();
extern void _ZN9S499C3_nt4v135Ev();
extern void _ZN9S499C3_nt4v136Ev();
extern void _ZN9S499C3_nt4v137Ev();
extern void _ZN9S499C3_nt4v138Ev();
extern void _ZN9S499C3_nt4v139Ev();
extern void _ZN9S499C3_nt4v140Ev();
extern void _ZN9S499C3_nt4v141Ev();
extern void _ZN9S499C3_nt4v142Ev();
extern void _ZN9S499C3_nt4v143Ev();
extern void _ZN9S499C3_nt4v144Ev();
extern void _ZN9S499C3_nt4v145Ev();
extern void _ZN9S499C3_nt4v146Ev();
extern void _ZN9S499C3_nt4v147Ev();
extern void _ZN9S499C3_nt4v148Ev();
extern void _ZN9S499C3_nt4v149Ev();
extern void _ZN9S499C3_nt4v150Ev();
extern void _ZN9S499C3_nt4v151Ev();
extern void _ZN9S499C3_nt4v152Ev();
extern void _ZN9S499C3_nt4v153Ev();
extern void _ZN9S499C3_nt4v154Ev();
extern void _ZN9S499C3_nt4v155Ev();
extern void _ZN9S499C3_nt4v156Ev();
extern void _ZN9S499C3_nt4v157Ev();
extern void _ZN9S499C3_nt4v158Ev();
extern void _ZN9S499C3_nt4v159Ev();
extern void _ZN9S499C3_nt4v160Ev();
extern void _ZN9S499C2_nt4v161Ev();
extern void _ZN9S499C2_nt4v162Ev();
extern void _ZN9S499C2_nt4v163Ev();
extern void _ZN9S499C2_nt4v164Ev();
extern void _ZN9S499C2_nt4v165Ev();
extern void _ZN9S499C2_nt4v166Ev();
extern void _ZN9S499C2_nt4v167Ev();
extern void _ZN9S499C2_nt4v168Ev();
extern void _ZN9S499C2_nt4v169Ev();
extern void _ZN9S499C2_nt4v170Ev();
extern void _ZN9S499C2_nt4v171Ev();
extern void _ZN9S499C2_nt4v172Ev();
extern void _ZN9S499C2_nt4v173Ev();
extern void _ZN9S499C2_nt4v174Ev();
extern void _ZN9S499C2_nt4v175Ev();
extern void _ZN9S499C2_nt4v176Ev();
extern void _ZN9S499C2_nt4v177Ev();
extern void _ZN9S499C2_nt4v178Ev();
extern void _ZN9S499C2_nt4v179Ev();
extern void _ZN9S499C2_nt4v180Ev();
extern void _ZN9S499C2_nt4v181Ev();
extern void _ZN9S499C2_nt4v182Ev();
extern void _ZN9S499C2_nt4v183Ev();
extern void _ZN9S499C2_nt4v184Ev();
extern void _ZN9S499C2_nt4v185Ev();
extern void _ZN9S499C2_nt4v186Ev();
extern void _ZN9S499C2_nt4v187Ev();
extern void _ZN9S499C2_nt4v188Ev();
extern void _ZN9S499C2_nt4v189Ev();
extern void _ZN9S499C2_nt4v190Ev();
extern void _ZN9S499C2_nt4v191Ev();
extern void _ZN9S499C2_nt4v192Ev();
extern void _ZN9S499C2_nt4v193Ev();
extern void _ZN9S499C2_nt4v194Ev();
extern void _ZN9S499C2_nt4v195Ev();
extern void _ZN9S499C2_nt4v196Ev();
extern void _ZN9S499C2_nt4v197Ev();
extern void _ZN9S499C2_nt4v198Ev();
extern void _ZN9S499C2_nt4v199Ev();
extern void _ZN9S499C2_nt4v200Ev();
extern void _ZN9S499C2_nt4v201Ev();
extern void _ZN9S499C2_nt4v202Ev();
extern void _ZN9S499C2_nt4v203Ev();
extern void _ZN9S499C2_nt4v204Ev();
extern void _ZN9S499C2_nt4v205Ev();
extern void _ZN9S499C2_nt4v206Ev();
extern void _ZN9S499C2_nt4v207Ev();
extern void _ZN9S499C2_nt4v208Ev();
extern void _ZN9S499C2_nt4v209Ev();
extern void _ZN9S499C2_nt4v210Ev();
extern void _ZN9S499C2_nt4v211Ev();
extern void _ZN9S499C2_nt4v212Ev();
extern void _ZN9S499C2_nt4v213Ev();
extern void _ZN9S499C2_nt4v214Ev();
extern void _ZN9S499C2_nt4v215Ev();
extern void _ZN9S499C2_nt4v216Ev();
extern void _ZN9S499C2_nt4v217Ev();
extern void _ZN9S499C2_nt4v218Ev();
extern void _ZN9S499C2_nt4v219Ev();
extern void _ZN9S499C2_nt4v220Ev();
extern void _ZN9S499C2_nt4v221Ev();
extern void _ZN9S499C2_nt4v222Ev();
extern void _ZN9S499C2_nt4v223Ev();
extern void _ZN9S499C2_nt4v224Ev();
extern void _ZN9S499C2_nt4v225Ev();
extern void _ZN9S499C2_nt4v226Ev();
extern void _ZN9S499C2_nt4v227Ev();
extern void _ZN9S499C2_nt4v228Ev();
extern void _ZN9S499C2_nt4v229Ev();
extern void _ZN6S499C12v1Ev();
extern void _ZN6S499C12v2Ev();
extern void _ZN6S499C12v3Ev();
extern void _ZN6S499C12v4Ev();
extern void _ZN6S499C12v5Ev();
extern void _ZN6S499C12v6Ev();
extern void _ZN6S499C12v7Ev();
extern void _ZN6S499C12v8Ev();
extern void _ZN6S499C12v9Ev();
extern void _ZN6S499C13v10Ev();
extern void _ZN6S499C13v11Ev();
extern void _ZN6S499C13v12Ev();
extern void _ZN6S499C13v13Ev();
extern void _ZN6S499C13v14Ev();
extern void _ZN6S499C13v15Ev();
extern void _ZN6S499C13v16Ev();
extern void _ZN6S499C13v17Ev();
extern void _ZN6S499C13v18Ev();
extern void ABISELECT(_ZThn1224_N6S499C1D1Ev,_ZThn908_N6S499C1D1Ev)();
extern void ABISELECT(_ZThn1224_N6S499C1D0Ev,_ZThn908_N6S499C1D0Ev)();
extern void _ZN10S499C46_nt4v230Ev();
extern void _ZN10S499C46_nt4v231Ev();
extern void _ZN10S499C46_nt4v232Ev();
extern void _ZN10S499C46_nt4v233Ev();
extern void _ZN10S499C46_nt4v234Ev();
extern void _ZN10S499C46_nt4v235Ev();
extern void _ZN10S499C46_nt4v236Ev();
extern void _ZN10S499C45_nt4v237Ev();
static  VTBL_ENTRY vtc_S499C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S499C1[0]),
  (VTBL_ENTRY)&_ZN6S499C1D1Ev,
  (VTBL_ENTRY)&_ZN6S499C1D0Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S499C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S499C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S499C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN9S499C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN6S499C12v1Ev,
  (VTBL_ENTRY)&_ZN6S499C12v2Ev,
  (VTBL_ENTRY)&_ZN6S499C12v3Ev,
  (VTBL_ENTRY)&_ZN6S499C12v4Ev,
  (VTBL_ENTRY)&_ZN6S499C12v5Ev,
  (VTBL_ENTRY)&_ZN6S499C12v6Ev,
  (VTBL_ENTRY)&_ZN6S499C12v7Ev,
  (VTBL_ENTRY)&_ZN6S499C12v8Ev,
  (VTBL_ENTRY)&_ZN6S499C12v9Ev,
  (VTBL_ENTRY)&_ZN6S499C13v10Ev,
  (VTBL_ENTRY)&_ZN6S499C13v11Ev,
  (VTBL_ENTRY)&_ZN6S499C13v12Ev,
  (VTBL_ENTRY)&_ZN6S499C13v13Ev,
  (VTBL_ENTRY)&_ZN6S499C13v14Ev,
  (VTBL_ENTRY)&_ZN6S499C13v15Ev,
  (VTBL_ENTRY)&_ZN6S499C13v16Ev,
  (VTBL_ENTRY)&_ZN6S499C13v17Ev,
  (VTBL_ENTRY)&_ZN6S499C13v18Ev,
  ABISELECT(-1224,-908),
  (VTBL_ENTRY)&(_ZTI6S499C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1224_N6S499C1D1Ev,_ZThn908_N6S499C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1224_N6S499C1D0Ev,_ZThn908_N6S499C1D0Ev),
  (VTBL_ENTRY)&_ZN10S499C46_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S499C46_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S499C45_nt4v237Ev,
};
extern VTBL_ENTRY _ZTI6S499C1[];
extern  VTBL_ENTRY _ZTV6S499C1[];
Class_Descriptor cd_S499C1 = {  "S499C1", // class name
  bases_S499C1, 6,
  &(vtc_S499C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1360,1000), // object size
  NSPAIRA(_ZTI6S499C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S499C1),245, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C5_nt  {
  void *s7368c5f0;
  int s7368c5f1[2];
  ::S499C30_nt s7368c5f2;
  void  mf7368c5(); // _ZN10S7368C5_nt8mf7368c5Ev
};
//SIG(-1 S7368C5_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C5_nt ::mf7368c5(){}

//skip512 S7368C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C4_nt  {
  ::S7368C5_nt s7368c4f0;
  void  mf7368c4(); // _ZN10S7368C4_nt8mf7368c4Ev
  virtual  ~S7368C4_nt(); // _ZN10S7368C4_ntD1Ev
  S7368C4_nt(); // tgen
};
//SIG(-1 S7368C4_nt) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}}}


void  S7368C4_nt ::mf7368c4(){}
 S7368C4_nt ::~S7368C4_nt(){ note_dtor("S7368C4_nt", this);}
S7368C4_nt ::S7368C4_nt(){ note_ctor("S7368C4_nt", this);} // tgen

//skip512 S7368C4_nt

#else // __cplusplus

extern void _ZN10S7368C4_ntC1Ev();
extern void _ZN10S7368C4_ntD1Ev();
Name_Map name_map_S7368C4_nt[] = {
  NSPAIR(_ZN10S7368C4_ntC1Ev),
  NSPAIR(_ZN10S7368C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern void _ZN10S7368C4_ntD1Ev();
extern void _ZN10S7368C4_ntD0Ev();
static  VTBL_ENTRY vtc_S7368C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S7368C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S7368C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S7368C4_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
VTBL_ENTRY *P__ZTI10S7368C4_nt = _ZTI10S7368C4_nt; 
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
Class_Descriptor cd_S7368C4_nt = {  "S7368C4_nt", // class name
  0,0,//no base classes
  &(vtc_S7368C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI10S7368C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S7368C4_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C8  {
  char s7368c8f0;
  void  mf7368c8(); // _ZN7S7368C88mf7368c8Ev
  virtual  ~S7368C8(); // _ZN7S7368C8D1Ev
  S7368C8(); // tgen
};
//SIG(-1 S7368C8) C1{ vd m Fc}


void  S7368C8 ::mf7368c8(){}
 S7368C8 ::~S7368C8(){ note_dtor("S7368C8", this);}
S7368C8 ::S7368C8(){ note_ctor("S7368C8", this);} // tgen

static void Test_S7368C8()
{
  extern Class_Descriptor cd_S7368C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S7368C8, buf);
    S7368C8 *dp, &lv = *(dp=new (buf) S7368C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S7368C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C8)");
    check_field_offset(lv, s7368c8f0, ABISELECT(8,4), "S7368C8.s7368c8f0");
    test_class_info(&lv, &cd_S7368C8);
    dp->~S7368C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C8(Test_S7368C8, "S7368C8", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S7368C8C1Ev();
extern void _ZN7S7368C8D1Ev();
Name_Map name_map_S7368C8[] = {
  NSPAIR(_ZN7S7368C8C1Ev),
  NSPAIR(_ZN7S7368C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7368C8[];
extern void _ZN7S7368C8D1Ev();
extern void _ZN7S7368C8D0Ev();
static  VTBL_ENTRY vtc_S7368C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C8[0]),
  (VTBL_ENTRY)&_ZN7S7368C8D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C8D0Ev,
};
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
Class_Descriptor cd_S7368C8 = {  "S7368C8", // class name
  0,0,//no base classes
  &(vtc_S7368C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S7368C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7368C8),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C10_nt  {
  void  mf7368c10(); // _ZN11S7368C10_nt9mf7368c10Ev
};
//SIG(-1 S7368C10_nt) C1{ m}


void  S7368C10_nt ::mf7368c10(){}

//skip512 S7368C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C9_nt  {
  void *s7368c9f0;
  int s7368c9f1;
  ::S7368C10_nt s7368c9f2;
  void  mf7368c9(); // _ZN10S7368C9_nt8mf7368c9Ev
};
//SIG(-1 S7368C9_nt) C1{ m Fp Fi FC2{ m}}


void  S7368C9_nt ::mf7368c9(){}

//skip512 S7368C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C11  : S7368C8 {
  __tsi64 s7368c11f0[2];
  virtual  ~S7368C11(); // _ZN8S7368C11D1Ev
  S7368C11(); // tgen
};
//SIG(-1 S7368C11) C1{ BC2{ vd m Fc} vd FL[2]}


 S7368C11 ::~S7368C11(){ note_dtor("S7368C11", this);}
S7368C11 ::S7368C11(){ note_ctor("S7368C11", this);} // tgen

static void Test_S7368C11()
{
  extern Class_Descriptor cd_S7368C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S7368C11, buf);
    S7368C11 *dp, &lv = *(dp=new (buf) S7368C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S7368C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C11)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C11");
    check_field_offset(lv, s7368c11f0, ABISELECT(16,8), "S7368C11.s7368c11f0");
    test_class_info(&lv, &cd_S7368C11);
    dp->~S7368C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C11(Test_S7368C11, "S7368C11", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN8S7368C11C1Ev();
extern void _ZN8S7368C11D1Ev();
Name_Map name_map_S7368C11[] = {
  NSPAIR(_ZN8S7368C11C1Ev),
  NSPAIR(_ZN8S7368C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C11[];
extern void _ZN8S7368C11D1Ev();
extern void _ZN8S7368C11D0Ev();
static  VTBL_ENTRY vtc_S7368C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C11[0]),
  (VTBL_ENTRY)&_ZN8S7368C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C11D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C11[];
extern  VTBL_ENTRY _ZTV8S7368C11[];
Class_Descriptor cd_S7368C11 = {  "S7368C11", // class name
  bases_S7368C11, 1,
  &(vtc_S7368C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI8S7368C11),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C15  {
  void *s7368c15f0;
  int s7368c15f1[2];
  ::S7368C10_nt s7368c15f2;
  void  mf7368c15(); // _ZN8S7368C159mf7368c15Ev
};
//SIG(-1 S7368C15) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C15 ::mf7368c15(){}

static void Test_S7368C15()
{
  {
    init_simple_test("S7368C15");
    S7368C15 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C15)");
    check_field_offset(lv, s7368c15f0, 0, "S7368C15.s7368c15f0");
    check_field_offset(lv, s7368c15f1, ABISELECT(8,4), "S7368C15.s7368c15f1");
    check_field_offset(lv, s7368c15f2, ABISELECT(16,12), "S7368C15.s7368c15f2");
  }
}
static Arrange_To_Call_Me vS7368C15(Test_S7368C15, "S7368C15", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C12  : S7368C8 {
  ::S7368C9_nt s7368c12f0;
  ::S7368C9_nt s7368c12f1;
  ::S7368C9_nt s7368c12f2;
  ::S7368C5_nt s7368c12f3;
  ::S7368C15 s7368c12f4;
  virtual  ~S7368C12(); // _ZN8S7368C12D1Ev
  S7368C12(); // tgen
};
//SIG(-1 S7368C12) C1{ BC2{ vd m Fc} vd FC3{ m Fp Fi FC4{ m}} FC3 FC3 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m Fp Fi[2] FC4}}


 S7368C12 ::~S7368C12(){ note_dtor("S7368C12", this);}
S7368C12 ::S7368C12(){ note_ctor("S7368C12", this);} // tgen

static void Test_S7368C12()
{
  extern Class_Descriptor cd_S7368C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S7368C12, buf);
    S7368C12 *dp, &lv = *(dp=new (buf) S7368C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S7368C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C12)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C12");
    check_field_offset(lv, s7368c12f0, ABISELECT(16,8), "S7368C12.s7368c12f0");
    check_field_offset(lv, s7368c12f1, ABISELECT(32,20), "S7368C12.s7368c12f1");
    check_field_offset(lv, s7368c12f2, ABISELECT(48,32), "S7368C12.s7368c12f2");
    check_field_offset(lv, s7368c12f3, ABISELECT(64,44), "S7368C12.s7368c12f3");
    check_field_offset(lv, s7368c12f4, ABISELECT(88,60), "S7368C12.s7368c12f4");
    test_class_info(&lv, &cd_S7368C12);
    dp->~S7368C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C12(Test_S7368C12, "S7368C12", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN8S7368C12C1Ev();
extern void _ZN8S7368C12D1Ev();
Name_Map name_map_S7368C12[] = {
  NSPAIR(_ZN8S7368C12C1Ev),
  NSPAIR(_ZN8S7368C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C12[];
extern void _ZN8S7368C12D1Ev();
extern void _ZN8S7368C12D0Ev();
static  VTBL_ENTRY vtc_S7368C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C12[0]),
  (VTBL_ENTRY)&_ZN8S7368C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C12D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C12[];
extern  VTBL_ENTRY _ZTV8S7368C12[];
Class_Descriptor cd_S7368C12 = {  "S7368C12", // class name
  bases_S7368C12, 1,
  &(vtc_S7368C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI8S7368C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C12),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C7  : S7368C8 {
  int s7368c7f0;
  ::S7368C9_nt s7368c7f1;
  ::S7368C11 s7368c7f2;
  ::S7368C9_nt s7368c7f3;
  ::S7368C12 s7368c7f4;
  virtual  ~S7368C7(); // _ZN7S7368C7D1Ev
  S7368C7(); // tgen
};
//SIG(-1 S7368C7) C1{ BC2{ vd m Fc} vd Fi FC3{ m Fp Fi FC4{ m}} FC5{ BC2 vd FL[2]} FC3 FC6{ BC2 vd FC3 FC3 FC3 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m Fp Fi[2] FC4}}}


 S7368C7 ::~S7368C7(){ note_dtor("S7368C7", this);}
S7368C7 ::S7368C7(){ note_ctor("S7368C7", this);} // tgen

static void Test_S7368C7()
{
  extern Class_Descriptor cd_S7368C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,35)];
    init_test(&cd_S7368C7, buf);
    S7368C7 *dp, &lv = *(dp=new (buf) S7368C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,136), "sizeof(S7368C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C7)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C7");
    check_field_offset(lv, s7368c7f0, ABISELECT(12,8), "S7368C7.s7368c7f0");
    check_field_offset(lv, s7368c7f1, ABISELECT(16,12), "S7368C7.s7368c7f1");
    check_field_offset(lv, s7368c7f2, ABISELECT(32,24), "S7368C7.s7368c7f2");
    check_field_offset(lv, s7368c7f3, ABISELECT(64,48), "S7368C7.s7368c7f3");
    check_field_offset(lv, s7368c7f4, ABISELECT(80,60), "S7368C7.s7368c7f4");
    test_class_info(&lv, &cd_S7368C7);
    dp->~S7368C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C7(Test_S7368C7, "S7368C7", ABISELECT(192,136));

#else // __cplusplus

extern void _ZN7S7368C7C1Ev();
extern void _ZN7S7368C7D1Ev();
Name_Map name_map_S7368C7[] = {
  NSPAIR(_ZN7S7368C7C1Ev),
  NSPAIR(_ZN7S7368C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7368C7[];
extern void _ZN7S7368C7D1Ev();
extern void _ZN7S7368C7D0Ev();
static  VTBL_ENTRY vtc_S7368C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C7[0]),
  (VTBL_ENTRY)&_ZN7S7368C7D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C7D0Ev,
};
extern VTBL_ENTRY _ZTI7S7368C7[];
extern  VTBL_ENTRY _ZTV7S7368C7[];
Class_Descriptor cd_S7368C7 = {  "S7368C7", // class name
  bases_S7368C7, 1,
  &(vtc_S7368C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,136), // object size
  NSPAIRA(_ZTI7S7368C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S7368C7),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C3  : S7368C4_nt {
  void *s7368c3f0[10];
  ::S7368C7 s7368c3f1;
  ::S7368C7 s7368c3f2;
  virtual  ~S7368C3(); // _ZN7S7368C3D1Ev
  S7368C3(); // tgen
};
//SIG(-1 S7368C3) C1{ BC2{ vd m FC3{ m Fp Fi[2] FC4{ m}}} vd Fp[10] FC5{ BC6{ vd m Fc} vd Fi FC7{ m Fp Fi FC8{ m}} FC9{ BC6 vd FL[2]} FC7 FC10{ BC6 vd FC7 FC7 FC7 FC3 FC11{ m Fp Fi[2] FC8}}} FC5}


 S7368C3 ::~S7368C3(){ note_dtor("S7368C3", this);}
S7368C3 ::S7368C3(){ note_ctor("S7368C3", this);} // tgen

static void Test_S7368C3()
{
  extern Class_Descriptor cd_S7368C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(63,84)];
    init_test(&cd_S7368C3, buf);
    S7368C3 *dp, &lv = *(dp=new (buf) S7368C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,332), "sizeof(S7368C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C3)");
    check_base_class_offset(lv, (S7368C4_nt*), 0, "S7368C3");
    check_field_offset(lv, s7368c3f0, ABISELECT(32,20), "S7368C3.s7368c3f0");
    check_field_offset(lv, s7368c3f1, ABISELECT(112,60), "S7368C3.s7368c3f1");
    check_field_offset(lv, s7368c3f2, ABISELECT(304,196), "S7368C3.s7368c3f2");
    test_class_info(&lv, &cd_S7368C3);
    dp->~S7368C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C3(Test_S7368C3, "S7368C3", ABISELECT(496,332));

#else // __cplusplus

extern void _ZN7S7368C3C1Ev();
extern void _ZN7S7368C3D1Ev();
Name_Map name_map_S7368C3[] = {
  NSPAIR(_ZN7S7368C3C1Ev),
  NSPAIR(_ZN7S7368C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
static Base_Class bases_S7368C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7368C3[];
extern void _ZN7S7368C3D1Ev();
extern void _ZN7S7368C3D0Ev();
static  VTBL_ENTRY vtc_S7368C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C3[0]),
  (VTBL_ENTRY)&_ZN7S7368C3D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C3D0Ev,
};
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
Class_Descriptor cd_S7368C3 = {  "S7368C3", // class name
  bases_S7368C3, 1,
  &(vtc_S7368C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(496,332), // object size
  NSPAIRA(_ZTI7S7368C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S7368C3),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C18_nt  {
  void *s7368c18f0;
  void  mf7368c18(); // _ZN11S7368C18_nt9mf7368c18Ev
  virtual  ~S7368C18_nt(); // _ZN11S7368C18_ntD1Ev
  S7368C18_nt(); // tgen
};
//SIG(-1 S7368C18_nt) C1{ vd m Fp}


void  S7368C18_nt ::mf7368c18(){}
 S7368C18_nt ::~S7368C18_nt(){ note_dtor("S7368C18_nt", this);}
S7368C18_nt ::S7368C18_nt(){ note_ctor("S7368C18_nt", this);} // tgen

//skip512 S7368C18_nt

#else // __cplusplus

extern void _ZN11S7368C18_ntC1Ev();
extern void _ZN11S7368C18_ntD1Ev();
Name_Map name_map_S7368C18_nt[] = {
  NSPAIR(_ZN11S7368C18_ntC1Ev),
  NSPAIR(_ZN11S7368C18_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern void _ZN11S7368C18_ntD1Ev();
extern void _ZN11S7368C18_ntD0Ev();
static  VTBL_ENTRY vtc_S7368C18_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7368C18_nt[0]),
  (VTBL_ENTRY)&_ZN11S7368C18_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7368C18_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
VTBL_ENTRY *P__ZTI11S7368C18_nt = _ZTI11S7368C18_nt; 
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
Class_Descriptor cd_S7368C18_nt = {  "S7368C18_nt", // class name
  0,0,//no base classes
  &(vtc_S7368C18_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI11S7368C18_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S7368C18_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C17  : S7368C18_nt {
  ::S7368C15 s7368c17f0;
  void *s7368c17f1;
  int s7368c17f2;
  virtual  ~S7368C17(); // _ZN8S7368C17D1Ev
  S7368C17(); // tgen
};
//SIG(-1 S7368C17) C1{ BC2{ vd m Fp} vd FC3{ m Fp Fi[2] FC4{ m}} Fp Fi}


 S7368C17 ::~S7368C17(){ note_dtor("S7368C17", this);}
S7368C17 ::S7368C17(){ note_ctor("S7368C17", this);} // tgen

static void Test_S7368C17()
{
  extern Class_Descriptor cd_S7368C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S7368C17, buf);
    S7368C17 *dp, &lv = *(dp=new (buf) S7368C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S7368C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C17)");
    check_base_class_offset(lv, (S7368C18_nt*), 0, "S7368C17");
    check_field_offset(lv, s7368c17f0, ABISELECT(16,8), "S7368C17.s7368c17f0");
    check_field_offset(lv, s7368c17f1, ABISELECT(40,24), "S7368C17.s7368c17f1");
    check_field_offset(lv, s7368c17f2, ABISELECT(48,28), "S7368C17.s7368c17f2");
    test_class_info(&lv, &cd_S7368C17);
    dp->~S7368C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C17(Test_S7368C17, "S7368C17", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S7368C17C1Ev();
extern void _ZN8S7368C17D1Ev();
Name_Map name_map_S7368C17[] = {
  NSPAIR(_ZN8S7368C17C1Ev),
  NSPAIR(_ZN8S7368C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C18_nt;
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
static Base_Class bases_S7368C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C17[];
extern void _ZN8S7368C17D1Ev();
extern void _ZN8S7368C17D0Ev();
static  VTBL_ENTRY vtc_S7368C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C17[0]),
  (VTBL_ENTRY)&_ZN8S7368C17D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C17D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C17[];
extern  VTBL_ENTRY _ZTV8S7368C17[];
Class_Descriptor cd_S7368C17 = {  "S7368C17", // class name
  bases_S7368C17, 1,
  &(vtc_S7368C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S7368C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C17),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C22  {
  void  mf7368c22(); // _ZN8S7368C229mf7368c22Ev
};
//SIG(-1 S7368C22) C1{ m}


void  S7368C22 ::mf7368c22(){}

static void Test_S7368C22()
{
  {
    init_simple_test("S7368C22");
    S7368C22 lv;
    check2(sizeof(lv), 1, "sizeof(S7368C22)");
    check2(__alignof__(lv), 1, "__alignof__(S7368C22)");
  }
}
static Arrange_To_Call_Me vS7368C22(Test_S7368C22, "S7368C22", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C21  {
  void *s7368c21f0;
  int s7368c21f1[2];
  ::S7368C22 s7368c21f2;
  void  mf7368c21(); // _ZN8S7368C219mf7368c21Ev
};
//SIG(-1 S7368C21) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C21 ::mf7368c21(){}

static void Test_S7368C21()
{
  {
    init_simple_test("S7368C21");
    S7368C21 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C21)");
    check_field_offset(lv, s7368c21f0, 0, "S7368C21.s7368c21f0");
    check_field_offset(lv, s7368c21f1, ABISELECT(8,4), "S7368C21.s7368c21f1");
    check_field_offset(lv, s7368c21f2, ABISELECT(16,12), "S7368C21.s7368c21f2");
  }
}
static Arrange_To_Call_Me vS7368C21(Test_S7368C21, "S7368C21", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C25  : S7368C8 {
  ::S7368C11 s7368c25f0;
  ::S7368C11 s7368c25f1;
  virtual  ~S7368C25(); // _ZN8S7368C25D1Ev
  S7368C25(); // tgen
};
//SIG(-1 S7368C25) C1{ BC2{ vd m Fc} vd FC3{ BC2 vd FL[2]} FC3}


 S7368C25 ::~S7368C25(){ note_dtor("S7368C25", this);}
S7368C25 ::S7368C25(){ note_ctor("S7368C25", this);} // tgen

static void Test_S7368C25()
{
  extern Class_Descriptor cd_S7368C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,15)];
    init_test(&cd_S7368C25, buf);
    S7368C25 *dp, &lv = *(dp=new (buf) S7368C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,56), "sizeof(S7368C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C25)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C25");
    check_field_offset(lv, s7368c25f0, ABISELECT(16,8), "S7368C25.s7368c25f0");
    check_field_offset(lv, s7368c25f1, ABISELECT(48,32), "S7368C25.s7368c25f1");
    test_class_info(&lv, &cd_S7368C25);
    dp->~S7368C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C25(Test_S7368C25, "S7368C25", ABISELECT(80,56));

#else // __cplusplus

extern void _ZN8S7368C25C1Ev();
extern void _ZN8S7368C25D1Ev();
Name_Map name_map_S7368C25[] = {
  NSPAIR(_ZN8S7368C25C1Ev),
  NSPAIR(_ZN8S7368C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C25[];
extern void _ZN8S7368C25D1Ev();
extern void _ZN8S7368C25D0Ev();
static  VTBL_ENTRY vtc_S7368C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C25[0]),
  (VTBL_ENTRY)&_ZN8S7368C25D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C25D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C25[];
extern  VTBL_ENTRY _ZTV8S7368C25[];
Class_Descriptor cd_S7368C25 = {  "S7368C25", // class name
  bases_S7368C25, 1,
  &(vtc_S7368C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,56), // object size
  NSPAIRA(_ZTI8S7368C25),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C25),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C28_nt  {
  int s7368c28f0;
  void *s7368c28f1[7];
  short s7368c28f2;
  char s7368c28f3[10];
};
//SIG(-1 S7368C28_nt) C1{ Fi Fp[7] Fs Fc[10]}



//skip512 S7368C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C29_nt  {
  ::S7368C9_nt s7368c29f0;
  ::S7368C9_nt s7368c29f1;
  void  mf7368c29(); // _ZN11S7368C29_nt9mf7368c29Ev
};
//SIG(-1 S7368C29_nt) C1{ m FC2{ m Fp Fi FC3{ m}} FC2}


void  S7368C29_nt ::mf7368c29(){}

//skip512 S7368C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C27_nt  {
  ::S7368C28_nt s7368c27f0;
  void *s7368c27f1;
  char s7368c27f2[2];
  ::S7368C29_nt s7368c27f3;
  void  mf7368c27(); // _ZN11S7368C27_nt9mf7368c27Ev
  virtual  ~S7368C27_nt(); // _ZN11S7368C27_ntD1Ev
  S7368C27_nt(); // tgen
};
//SIG(-1 S7368C27_nt) C1{ vd m FC2{ Fi Fp[7] Fs Fc[10]} Fp Fc[2] FC3{ m FC4{ m Fp Fi FC5{ m}} FC4}}


void  S7368C27_nt ::mf7368c27(){}
 S7368C27_nt ::~S7368C27_nt(){ note_dtor("S7368C27_nt", this);}
S7368C27_nt ::S7368C27_nt(){ note_ctor("S7368C27_nt", this);} // tgen

//skip512 S7368C27_nt

#else // __cplusplus

extern void _ZN11S7368C27_ntC1Ev();
extern void _ZN11S7368C27_ntD1Ev();
Name_Map name_map_S7368C27_nt[] = {
  NSPAIR(_ZN11S7368C27_ntC1Ev),
  NSPAIR(_ZN11S7368C27_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7368C27_nt[];
extern void _ZN11S7368C27_ntD1Ev();
extern void _ZN11S7368C27_ntD0Ev();
static  VTBL_ENTRY vtc_S7368C27_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7368C27_nt[0]),
  (VTBL_ENTRY)&_ZN11S7368C27_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7368C27_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S7368C27_nt[];
VTBL_ENTRY *P__ZTI11S7368C27_nt = _ZTI11S7368C27_nt; 
extern  VTBL_ENTRY _ZTV11S7368C27_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C33  : S7368C8 {
  __tsi64 s7368c33f0;
  virtual  ~S7368C33(); // _ZN8S7368C33D1Ev
  S7368C33(); // tgen
};
//SIG(-1 S7368C33) C1{ BC2{ vd m Fc} vd FL}


 S7368C33 ::~S7368C33(){ note_dtor("S7368C33", this);}
S7368C33 ::S7368C33(){ note_ctor("S7368C33", this);} // tgen

static void Test_S7368C33()
{
  extern Class_Descriptor cd_S7368C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S7368C33, buf);
    S7368C33 *dp, &lv = *(dp=new (buf) S7368C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C33)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C33");
    check_field_offset(lv, s7368c33f0, ABISELECT(16,8), "S7368C33.s7368c33f0");
    test_class_info(&lv, &cd_S7368C33);
    dp->~S7368C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C33(Test_S7368C33, "S7368C33", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S7368C33C1Ev();
extern void _ZN8S7368C33D1Ev();
Name_Map name_map_S7368C33[] = {
  NSPAIR(_ZN8S7368C33C1Ev),
  NSPAIR(_ZN8S7368C33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C33[];
extern void _ZN8S7368C33D1Ev();
extern void _ZN8S7368C33D0Ev();
static  VTBL_ENTRY vtc_S7368C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C33[0]),
  (VTBL_ENTRY)&_ZN8S7368C33D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C33D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C33[];
extern  VTBL_ENTRY _ZTV8S7368C33[];
Class_Descriptor cd_S7368C33 = {  "S7368C33", // class name
  bases_S7368C33, 1,
  &(vtc_S7368C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S7368C33),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C33),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C32  {
  ::S7368C33 s7368c32f0;
  ::S7368C7 s7368c32f1;
  void  mf7368c32(); // _ZN8S7368C329mf7368c32Ev
  virtual  ~S7368C32(); // _ZN8S7368C32D1Ev
  S7368C32(); // tgen
};
//SIG(-1 S7368C32) C1{ vd m FC2{ BC3{ vd m Fc} vd FL} FC4{ BC3 vd Fi FC5{ m Fp Fi FC6{ m}} FC7{ BC3 vd FL[2]} FC5 FC8{ BC3 vd FC5 FC5 FC5 FC9{ m Fp Fi[2] FC10{ m}} FC11{ m Fp Fi[2] FC6}}}}


void  S7368C32 ::mf7368c32(){}
 S7368C32 ::~S7368C32(){ note_dtor("S7368C32", this);}
S7368C32 ::S7368C32(){ note_ctor("S7368C32", this);} // tgen

static void Test_S7368C32()
{
  extern Class_Descriptor cd_S7368C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S7368C32, buf);
    S7368C32 *dp, &lv = *(dp=new (buf) S7368C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S7368C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C32)");
    check_field_offset(lv, s7368c32f0, ABISELECT(8,4), "S7368C32.s7368c32f0");
    check_field_offset(lv, s7368c32f1, ABISELECT(32,20), "S7368C32.s7368c32f1");
    test_class_info(&lv, &cd_S7368C32);
    dp->~S7368C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C32(Test_S7368C32, "S7368C32", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN8S7368C32C1Ev();
extern void _ZN8S7368C32D1Ev();
Name_Map name_map_S7368C32[] = {
  NSPAIR(_ZN8S7368C32C1Ev),
  NSPAIR(_ZN8S7368C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C32[];
extern void _ZN8S7368C32D1Ev();
extern void _ZN8S7368C32D0Ev();
static  VTBL_ENTRY vtc_S7368C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C32[0]),
  (VTBL_ENTRY)&_ZN8S7368C32D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C32D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C32[];
extern  VTBL_ENTRY _ZTV8S7368C32[];
Class_Descriptor cd_S7368C32 = {  "S7368C32", // class name
  0,0,//no base classes
  &(vtc_S7368C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI8S7368C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C35  {
  ::S7368C9_nt s7368c35f0;
  ::S7368C11 s7368c35f1;
  void  mf7368c35(); // _ZN8S7368C359mf7368c35Ev
  virtual  ~S7368C35(); // _ZN8S7368C35D1Ev
  S7368C35(); // tgen
};
//SIG(-1 S7368C35) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC4{ BC5{ vd m Fc} vd FL[2]}}


void  S7368C35 ::mf7368c35(){}
 S7368C35 ::~S7368C35(){ note_dtor("S7368C35", this);}
S7368C35 ::S7368C35(){ note_ctor("S7368C35", this);} // tgen

static void Test_S7368C35()
{
  extern Class_Descriptor cd_S7368C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_S7368C35, buf);
    S7368C35 *dp, &lv = *(dp=new (buf) S7368C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S7368C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C35)");
    check_field_offset(lv, s7368c35f0, ABISELECT(8,4), "S7368C35.s7368c35f0");
    check_field_offset(lv, s7368c35f1, ABISELECT(24,16), "S7368C35.s7368c35f1");
    test_class_info(&lv, &cd_S7368C35);
    dp->~S7368C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C35(Test_S7368C35, "S7368C35", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8S7368C35C1Ev();
extern void _ZN8S7368C35D1Ev();
Name_Map name_map_S7368C35[] = {
  NSPAIR(_ZN8S7368C35C1Ev),
  NSPAIR(_ZN8S7368C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C35[];
extern void _ZN8S7368C35D1Ev();
extern void _ZN8S7368C35D0Ev();
static  VTBL_ENTRY vtc_S7368C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C35[0]),
  (VTBL_ENTRY)&_ZN8S7368C35D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C35D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C35[];
extern  VTBL_ENTRY _ZTV8S7368C35[];
Class_Descriptor cd_S7368C35 = {  "S7368C35", // class name
  0,0,//no base classes
  &(vtc_S7368C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8S7368C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C35),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C34  : S7368C8 {
  ::S7368C33 s7368c34f0;
  int s7368c34f1;
  ::S7368C35 s7368c34f2;
  ::S7368C35 s7368c34f3;
  int s7368c34f4;
  ::S7368C9_nt s7368c34f5;
  ::S7368C9_nt s7368c34f6;
  int s7368c34f7;
  ::S7368C35 s7368c34f8;
  ::S7368C35 s7368c34f9;
  virtual  ~S7368C34(); // _ZN8S7368C34D1Ev
  S7368C34(); // tgen
};
//SIG(-1 S7368C34) C1{ BC2{ vd m Fc} vd FC3{ BC2 vd FL} Fi FC4{ vd m FC5{ m Fp Fi FC6{ m}} FC7{ BC2 vd FL[2]}} FC4 Fi FC5 FC5 Fi FC4 FC4}


 S7368C34 ::~S7368C34(){ note_dtor("S7368C34", this);}
S7368C34 ::S7368C34(){ note_ctor("S7368C34", this);} // tgen

static void Test_S7368C34()
{
  extern Class_Descriptor cd_S7368C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,56)];
    init_test(&cd_S7368C34, buf);
    S7368C34 *dp, &lv = *(dp=new (buf) S7368C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,220), "sizeof(S7368C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C34)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C34");
    check_field_offset(lv, s7368c34f0, ABISELECT(16,8), "S7368C34.s7368c34f0");
    check_field_offset(lv, s7368c34f1, ABISELECT(40,24), "S7368C34.s7368c34f1");
    check_field_offset(lv, s7368c34f2, ABISELECT(48,28), "S7368C34.s7368c34f2");
    check_field_offset(lv, s7368c34f3, ABISELECT(104,68), "S7368C34.s7368c34f3");
    check_field_offset(lv, s7368c34f4, ABISELECT(160,108), "S7368C34.s7368c34f4");
    check_field_offset(lv, s7368c34f5, ABISELECT(168,112), "S7368C34.s7368c34f5");
    check_field_offset(lv, s7368c34f6, ABISELECT(184,124), "S7368C34.s7368c34f6");
    check_field_offset(lv, s7368c34f7, ABISELECT(200,136), "S7368C34.s7368c34f7");
    check_field_offset(lv, s7368c34f8, ABISELECT(208,140), "S7368C34.s7368c34f8");
    check_field_offset(lv, s7368c34f9, ABISELECT(264,180), "S7368C34.s7368c34f9");
    test_class_info(&lv, &cd_S7368C34);
    dp->~S7368C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C34(Test_S7368C34, "S7368C34", ABISELECT(320,220));

#else // __cplusplus

extern void _ZN8S7368C34C1Ev();
extern void _ZN8S7368C34D1Ev();
Name_Map name_map_S7368C34[] = {
  NSPAIR(_ZN8S7368C34C1Ev),
  NSPAIR(_ZN8S7368C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C34[];
extern void _ZN8S7368C34D1Ev();
extern void _ZN8S7368C34D0Ev();
static  VTBL_ENTRY vtc_S7368C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C34[0]),
  (VTBL_ENTRY)&_ZN8S7368C34D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C34D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C34[];
extern  VTBL_ENTRY _ZTV8S7368C34[];
Class_Descriptor cd_S7368C34 = {  "S7368C34", // class name
  bases_S7368C34, 1,
  &(vtc_S7368C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,220), // object size
  NSPAIRA(_ZTI8S7368C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C34),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C37  : S7368C8 {
  ::S7368C9_nt s7368c37f0;
  ::S7368C11 s7368c37f1;
  virtual  ~S7368C37(); // _ZN8S7368C37D1Ev
  S7368C37(); // tgen
};
//SIG(-1 S7368C37) C1{ BC2{ vd m Fc} vd FC3{ m Fp Fi FC4{ m}} FC5{ BC2 vd FL[2]}}


 S7368C37 ::~S7368C37(){ note_dtor("S7368C37", this);}
S7368C37 ::S7368C37(){ note_ctor("S7368C37", this);} // tgen

static void Test_S7368C37()
{
  extern Class_Descriptor cd_S7368C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S7368C37, buf);
    S7368C37 *dp, &lv = *(dp=new (buf) S7368C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S7368C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C37)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C37");
    check_field_offset(lv, s7368c37f0, ABISELECT(16,8), "S7368C37.s7368c37f0");
    check_field_offset(lv, s7368c37f1, ABISELECT(32,20), "S7368C37.s7368c37f1");
    test_class_info(&lv, &cd_S7368C37);
    dp->~S7368C37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C37(Test_S7368C37, "S7368C37", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN8S7368C37C1Ev();
extern void _ZN8S7368C37D1Ev();
Name_Map name_map_S7368C37[] = {
  NSPAIR(_ZN8S7368C37C1Ev),
  NSPAIR(_ZN8S7368C37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C37[];
extern void _ZN8S7368C37D1Ev();
extern void _ZN8S7368C37D0Ev();
static  VTBL_ENTRY vtc_S7368C37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C37[0]),
  (VTBL_ENTRY)&_ZN8S7368C37D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C37D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C37[];
extern  VTBL_ENTRY _ZTV8S7368C37[];
Class_Descriptor cd_S7368C37 = {  "S7368C37", // class name
  bases_S7368C37, 1,
  &(vtc_S7368C37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI8S7368C37),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C37),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C38  : S7368C8 {
  ::S7368C9_nt s7368c38f0;
  ::S7368C9_nt s7368c38f1;
  int s7368c38f2;
  virtual  ~S7368C38(); // _ZN8S7368C38D1Ev
  S7368C38(); // tgen
};
//SIG(-1 S7368C38) C1{ BC2{ vd m Fc} vd FC3{ m Fp Fi FC4{ m}} FC3 Fi}


 S7368C38 ::~S7368C38(){ note_dtor("S7368C38", this);}
S7368C38 ::S7368C38(){ note_ctor("S7368C38", this);} // tgen

static void Test_S7368C38()
{
  extern Class_Descriptor cd_S7368C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S7368C38, buf);
    S7368C38 *dp, &lv = *(dp=new (buf) S7368C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S7368C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C38)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C38");
    check_field_offset(lv, s7368c38f0, ABISELECT(16,8), "S7368C38.s7368c38f0");
    check_field_offset(lv, s7368c38f1, ABISELECT(32,20), "S7368C38.s7368c38f1");
    check_field_offset(lv, s7368c38f2, ABISELECT(48,32), "S7368C38.s7368c38f2");
    test_class_info(&lv, &cd_S7368C38);
    dp->~S7368C38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C38(Test_S7368C38, "S7368C38", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN8S7368C38C1Ev();
extern void _ZN8S7368C38D1Ev();
Name_Map name_map_S7368C38[] = {
  NSPAIR(_ZN8S7368C38C1Ev),
  NSPAIR(_ZN8S7368C38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C38[];
extern void _ZN8S7368C38D1Ev();
extern void _ZN8S7368C38D0Ev();
static  VTBL_ENTRY vtc_S7368C38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C38[0]),
  (VTBL_ENTRY)&_ZN8S7368C38D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C38D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C38[];
extern  VTBL_ENTRY _ZTV8S7368C38[];
Class_Descriptor cd_S7368C38 = {  "S7368C38", // class name
  bases_S7368C38, 1,
  &(vtc_S7368C38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI8S7368C38),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C38),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C36  : S7368C8 {
  int s7368c36f0[2];
  ::S7368C11 s7368c36f1;
  ::S7368C9_nt s7368c36f2;
  ::S7368C37 s7368c36f3;
  ::S7368C38 s7368c36f4;
  virtual  ~S7368C36(); // _ZN8S7368C36D1Ev
  S7368C36(); // tgen
};
//SIG(-1 S7368C36) C1{ BC2{ vd m Fc} vd Fi[2] FC3{ BC2 vd FL[2]} FC4{ m Fp Fi FC5{ m}} FC6{ BC2 vd FC4 FC3} FC7{ BC2 vd FC4 FC4 Fi}}


 S7368C36 ::~S7368C36(){ note_dtor("S7368C36", this);}
S7368C36 ::S7368C36(){ note_ctor("S7368C36", this);} // tgen

static void Test_S7368C36()
{
  extern Class_Descriptor cd_S7368C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S7368C36, buf);
    S7368C36 *dp, &lv = *(dp=new (buf) S7368C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S7368C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C36)");
    check_base_class_offset(lv, (S7368C8*), 0, "S7368C36");
    check_field_offset(lv, s7368c36f0, ABISELECT(12,8), "S7368C36.s7368c36f0");
    check_field_offset(lv, s7368c36f1, ABISELECT(24,16), "S7368C36.s7368c36f1");
    check_field_offset(lv, s7368c36f2, ABISELECT(56,40), "S7368C36.s7368c36f2");
    check_field_offset(lv, s7368c36f3, ABISELECT(72,52), "S7368C36.s7368c36f3");
    check_field_offset(lv, s7368c36f4, ABISELECT(136,96), "S7368C36.s7368c36f4");
    test_class_info(&lv, &cd_S7368C36);
    dp->~S7368C36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C36(Test_S7368C36, "S7368C36", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN8S7368C36C1Ev();
extern void _ZN8S7368C36D1Ev();
Name_Map name_map_S7368C36[] = {
  NSPAIR(_ZN8S7368C36C1Ev),
  NSPAIR(_ZN8S7368C36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C8;
extern VTBL_ENTRY _ZTI7S7368C8[];
extern  VTBL_ENTRY _ZTV7S7368C8[];
static Base_Class bases_S7368C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C36[];
extern void _ZN8S7368C36D1Ev();
extern void _ZN8S7368C36D0Ev();
static  VTBL_ENTRY vtc_S7368C36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C36[0]),
  (VTBL_ENTRY)&_ZN8S7368C36D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C36D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C36[];
extern  VTBL_ENTRY _ZTV8S7368C36[];
Class_Descriptor cd_S7368C36 = {  "S7368C36", // class name
  bases_S7368C36, 1,
  &(vtc_S7368C36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI8S7368C36),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C36),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C26  {
  int s7368c26f0;
  ::S7368C27_nt s7368c26f1;
  ::S7368C32 s7368c26f2;
  ::S7368C34 s7368c26f3;
  ::S7368C36 s7368c26f4;
  void  mf7368c26(); // _ZN8S7368C269mf7368c26Ev
  virtual  ~S7368C26(); // _ZN8S7368C26D1Ev
  S7368C26(); // tgen
};
//SIG(-1 S7368C26) C1{ vd m Fi FC2{ vd m FC3{ Fi Fp[7] Fs Fc[10]} Fp Fc[2] FC4{ m FC5{ m Fp Fi FC6{ m}} FC5}} FC7{ vd m FC8{ BC9{ vd m Fc} vd FL} FC10{ BC9 vd Fi FC5 FC11{ BC9 vd FL[2]} FC5 FC12{ BC9 vd FC5 FC5 FC5 FC13{ m Fp Fi[2] FC14{ m}} FC15{ m Fp Fi[2] FC6}}}} FC16{ BC9 vd FC8 Fi FC17{ vd m FC5 FC11} FC17 Fi FC5 FC5 Fi FC17 FC17} FC18{ BC9 vd Fi[2] FC11 FC5 FC19{ BC9 vd FC5 FC11} FC20{ BC9 vd FC5 FC5 Fi}}}


void  S7368C26 ::mf7368c26(){}
 S7368C26 ::~S7368C26(){ note_dtor("S7368C26", this);}
S7368C26 ::S7368C26(){ note_ctor("S7368C26", this);} // tgen

static void Test_S7368C26()
{
  extern Class_Descriptor cd_S7368C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(112,150)];
    init_test(&cd_S7368C26, buf);
    S7368C26 *dp, &lv = *(dp=new (buf) S7368C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(888,596), "sizeof(S7368C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C26)");
    check_field_offset(lv, s7368c26f0, ABISELECT(8,4), "S7368C26.s7368c26f0");
    check_field_offset(lv, s7368c26f1, ABISELECT(16,8), "S7368C26.s7368c26f1");
    check_field_offset(lv, s7368c26f2, ABISELECT(152,88), "S7368C26.s7368c26f2");
    check_field_offset(lv, s7368c26f3, ABISELECT(376,244), "S7368C26.s7368c26f3");
    check_field_offset(lv, s7368c26f4, ABISELECT(696,464), "S7368C26.s7368c26f4");
    test_class_info(&lv, &cd_S7368C26);
    dp->~S7368C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C26(Test_S7368C26, "S7368C26", ABISELECT(888,596));

#else // __cplusplus

extern void _ZN8S7368C26C1Ev();
extern void _ZN8S7368C26D1Ev();
Name_Map name_map_S7368C26[] = {
  NSPAIR(_ZN8S7368C26C1Ev),
  NSPAIR(_ZN8S7368C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C26[];
extern void _ZN8S7368C26D1Ev();
extern void _ZN8S7368C26D0Ev();
static  VTBL_ENTRY vtc_S7368C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C26[0]),
  (VTBL_ENTRY)&_ZN8S7368C26D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C26D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C26[];
extern  VTBL_ENTRY _ZTV8S7368C26[];
Class_Descriptor cd_S7368C26 = {  "S7368C26", // class name
  0,0,//no base classes
  &(vtc_S7368C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(888,596), // object size
  NSPAIRA(_ZTI8S7368C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C26),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C2  : virtual S7368C3 {
  ::S7368C17 s7368c2f0;
  ::S7368C21 s7368c2f1;
  int s7368c2f2;
  ::S7368C21 s7368c2f3;
  ::S7368C21 s7368c2f4;
  ::S7368C25 s7368c2f5;
  ::S7368C26 s7368c2f6;
  ::S7368C27_nt s7368c2f7;
  ::S7368C9_nt s7368c2f8;
  ::S7368C11 s7368c2f9;
  virtual  ~S7368C2(); // _ZN7S7368C2D2Ev
  S7368C2(); // tgen
};
//SIG(-1 S7368C2) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ BC14{ vd m Fp} vd FC12 Fp Fi} FC15{ m Fp Fi[2] FC16{ m}} Fi FC15 FC15 FC17{ BC7 vd FC10 FC10} FC18{ vd m Fi FC19{ vd m FC20{ Fi Fp[7] Fs Fc[10]} Fp Fc[2] FC21{ m FC8 FC8}} FC22{ vd m FC23{ BC7 vd FL} FC6} FC24{ BC7 vd FC23 Fi FC25{ vd m FC8 FC10} FC25 Fi FC8 FC8 Fi FC25 FC25} FC26{ BC7 vd Fi[2] FC10 FC8 FC27{ BC7 vd FC8 FC10} FC28{ BC7 vd FC8 FC8 Fi}}} FC19 FC8 FC10}


 S7368C2 ::~S7368C2(){ note_dtor("S7368C2", this);}
S7368C2 ::S7368C2(){ note_ctor("S7368C2", this);} // tgen

static void Test_S7368C2()
{
  extern Class_Descriptor cd_S7368C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(225,298)];
    init_test(&cd_S7368C2, buf);
    S7368C2 *dp, &lv = *(dp=new (buf) S7368C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1792,1188), "sizeof(S7368C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C2)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(1296,856), "S7368C2");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(1296,856), "S7368C2");
    check_field_offset(lv, s7368c2f0, ABISELECT(8,4), "S7368C2.s7368c2f0");
    check_field_offset(lv, s7368c2f1, ABISELECT(64,36), "S7368C2.s7368c2f1");
    check_field_offset(lv, s7368c2f2, ABISELECT(88,52), "S7368C2.s7368c2f2");
    check_field_offset(lv, s7368c2f3, ABISELECT(96,56), "S7368C2.s7368c2f3");
    check_field_offset(lv, s7368c2f4, ABISELECT(120,72), "S7368C2.s7368c2f4");
    check_field_offset(lv, s7368c2f5, ABISELECT(144,88), "S7368C2.s7368c2f5");
    check_field_offset(lv, s7368c2f6, ABISELECT(224,144), "S7368C2.s7368c2f6");
    check_field_offset(lv, s7368c2f7, ABISELECT(1112,740), "S7368C2.s7368c2f7");
    check_field_offset(lv, s7368c2f8, ABISELECT(1248,820), "S7368C2.s7368c2f8");
    check_field_offset(lv, s7368c2f9, ABISELECT(1264,832), "S7368C2.s7368c2f9");
    test_class_info(&lv, &cd_S7368C2);
    dp->~S7368C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C2(Test_S7368C2, "S7368C2", ABISELECT(1792,1188));

#else // __cplusplus

extern void _ZN7S7368C2C1Ev();
extern void _ZN7S7368C2D2Ev();
Name_Map name_map_S7368C2[] = {
  NSPAIR(_ZN7S7368C2C1Ev),
  NSPAIR(_ZN7S7368C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(1296,856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(1296,856), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7368C2[];
extern void _ZN7S7368C2D1Ev();
extern void _ZN7S7368C2D0Ev();
extern void ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev)();
extern void ABISELECT(_ZThn1296_N7S7368C2D1Ev,_ZThn856_N7S7368C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev)();
extern void ABISELECT(_ZThn1296_N7S7368C2D0Ev,_ZThn856_N7S7368C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C2[] = {
  ABISELECT(1296,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C2[0]),
  (VTBL_ENTRY)&_ZN7S7368C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C2D0Ev,
  ABISELECT(-1296,-856),
  ABISELECT(-1296,-856),
  (VTBL_ENTRY)&(_ZTI7S7368C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev),
};
extern VTBL_ENTRY _ZTV7S7368C2[];
static  VTT_ENTRY vtt_S7368C2[] = {
  {&(_ZTV7S7368C2[3]),  3,10},
  {&(_ZTV7S7368C2[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7S7368C2[];
extern  VTBL_ENTRY _ZTV7S7368C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7368C2[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N7S7368C2D0Ev,_ZThn856_N7S7368C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N7S7368C2D1Ev,_ZThn856_N7S7368C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C2 = {  "S7368C2", // class name
  bases_S7368C2, 2,
  &(vtc_S7368C2[0]), // expected_vtbl_contents
  &(vtt_S7368C2[0]), // expected_vtt_contents
  ABISELECT(1792,1188), // object size
  NSPAIRA(_ZTI7S7368C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7368C2),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7368C2),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C40  {
  ::S7368C9_nt s7368c40f0;
  ::S7368C11 s7368c40f1;
  int s7368c40f2[2];
  void  mf7368c40(); // _ZN8S7368C409mf7368c40Ev
  virtual  ~S7368C40(); // _ZN8S7368C40D1Ev
  S7368C40(); // tgen
};
//SIG(-1 S7368C40) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC4{ BC5{ vd m Fc} vd FL[2]} Fi[2]}


void  S7368C40 ::mf7368c40(){}
 S7368C40 ::~S7368C40(){ note_dtor("S7368C40", this);}
S7368C40 ::S7368C40(){ note_ctor("S7368C40", this);} // tgen

static void Test_S7368C40()
{
  extern Class_Descriptor cd_S7368C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,13)];
    init_test(&cd_S7368C40, buf);
    S7368C40 *dp, &lv = *(dp=new (buf) S7368C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,48), "sizeof(S7368C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C40)");
    check_field_offset(lv, s7368c40f0, ABISELECT(8,4), "S7368C40.s7368c40f0");
    check_field_offset(lv, s7368c40f1, ABISELECT(24,16), "S7368C40.s7368c40f1");
    check_field_offset(lv, s7368c40f2, ABISELECT(56,40), "S7368C40.s7368c40f2");
    test_class_info(&lv, &cd_S7368C40);
    dp->~S7368C40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C40(Test_S7368C40, "S7368C40", ABISELECT(64,48));

#else // __cplusplus

extern void _ZN8S7368C40C1Ev();
extern void _ZN8S7368C40D1Ev();
Name_Map name_map_S7368C40[] = {
  NSPAIR(_ZN8S7368C40C1Ev),
  NSPAIR(_ZN8S7368C40D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C40[];
extern void _ZN8S7368C40D1Ev();
extern void _ZN8S7368C40D0Ev();
static  VTBL_ENTRY vtc_S7368C40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C40[0]),
  (VTBL_ENTRY)&_ZN8S7368C40D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C40D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C40[];
extern  VTBL_ENTRY _ZTV8S7368C40[];
Class_Descriptor cd_S7368C40 = {  "S7368C40", // class name
  0,0,//no base classes
  &(vtc_S7368C40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,48), // object size
  NSPAIRA(_ZTI8S7368C40),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C40),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C42  {
  void *s7368c42f0;
  int s7368c42f1[2];
  ::S7368C22 s7368c42f2;
  void  mf7368c42(); // _ZN8S7368C429mf7368c42Ev
};
//SIG(-1 S7368C42) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C42 ::mf7368c42(){}

static void Test_S7368C42()
{
  {
    init_simple_test("S7368C42");
    S7368C42 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C42)");
    check_field_offset(lv, s7368c42f0, 0, "S7368C42.s7368c42f0");
    check_field_offset(lv, s7368c42f1, ABISELECT(8,4), "S7368C42.s7368c42f1");
    check_field_offset(lv, s7368c42f2, ABISELECT(16,12), "S7368C42.s7368c42f2");
  }
}
static Arrange_To_Call_Me vS7368C42(Test_S7368C42, "S7368C42", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C41  {
  ::S7368C42 s7368c41f0;
  ::S7368C25 s7368c41f1;
  ::S7368C15 s7368c41f2;
  void  mf7368c41(); // _ZN8S7368C419mf7368c41Ev
  virtual  ~S7368C41(); // _ZN8S7368C41D1Ev
  S7368C41(); // tgen
};
//SIG(-1 S7368C41) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC4{ BC5{ vd m Fc} vd FC6{ BC5 vd FL[2]} FC6} FC7{ m Fp Fi[2] FC8{ m}}}


void  S7368C41 ::mf7368c41(){}
 S7368C41 ::~S7368C41(){ note_dtor("S7368C41", this);}
S7368C41 ::S7368C41(){ note_ctor("S7368C41", this);} // tgen

static void Test_S7368C41()
{
  extern Class_Descriptor cd_S7368C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,24)];
    init_test(&cd_S7368C41, buf);
    S7368C41 *dp, &lv = *(dp=new (buf) S7368C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,92), "sizeof(S7368C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C41)");
    check_field_offset(lv, s7368c41f0, ABISELECT(8,4), "S7368C41.s7368c41f0");
    check_field_offset(lv, s7368c41f1, ABISELECT(32,20), "S7368C41.s7368c41f1");
    check_field_offset(lv, s7368c41f2, ABISELECT(112,76), "S7368C41.s7368c41f2");
    test_class_info(&lv, &cd_S7368C41);
    dp->~S7368C41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C41(Test_S7368C41, "S7368C41", ABISELECT(136,92));

#else // __cplusplus

extern void _ZN8S7368C41C1Ev();
extern void _ZN8S7368C41D1Ev();
Name_Map name_map_S7368C41[] = {
  NSPAIR(_ZN8S7368C41C1Ev),
  NSPAIR(_ZN8S7368C41D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C41[];
extern void _ZN8S7368C41D1Ev();
extern void _ZN8S7368C41D0Ev();
static  VTBL_ENTRY vtc_S7368C41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C41[0]),
  (VTBL_ENTRY)&_ZN8S7368C41D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C41D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C41[];
extern  VTBL_ENTRY _ZTV8S7368C41[];
Class_Descriptor cd_S7368C41 = {  "S7368C41", // class name
  0,0,//no base classes
  &(vtc_S7368C41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,92), // object size
  NSPAIRA(_ZTI8S7368C41),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C41),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C44  {
  ::S7368C42 s7368c44f0;
  ::S7368C25 s7368c44f1;
  void  mf7368c44(); // _ZN8S7368C449mf7368c44Ev
  virtual  ~S7368C44(); // _ZN8S7368C44D1Ev
  S7368C44(); // tgen
};
//SIG(-1 S7368C44) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}} FC4{ BC5{ vd m Fc} vd FC6{ BC5 vd FL[2]} FC6}}


void  S7368C44 ::mf7368c44(){}
 S7368C44 ::~S7368C44(){ note_dtor("S7368C44", this);}
S7368C44 ::S7368C44(){ note_ctor("S7368C44", this);} // tgen

static void Test_S7368C44()
{
  extern Class_Descriptor cd_S7368C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S7368C44, buf);
    S7368C44 *dp, &lv = *(dp=new (buf) S7368C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S7368C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C44)");
    check_field_offset(lv, s7368c44f0, ABISELECT(8,4), "S7368C44.s7368c44f0");
    check_field_offset(lv, s7368c44f1, ABISELECT(32,20), "S7368C44.s7368c44f1");
    test_class_info(&lv, &cd_S7368C44);
    dp->~S7368C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C44(Test_S7368C44, "S7368C44", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN8S7368C44C1Ev();
extern void _ZN8S7368C44D1Ev();
Name_Map name_map_S7368C44[] = {
  NSPAIR(_ZN8S7368C44C1Ev),
  NSPAIR(_ZN8S7368C44D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C44[];
extern void _ZN8S7368C44D1Ev();
extern void _ZN8S7368C44D0Ev();
static  VTBL_ENTRY vtc_S7368C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C44[0]),
  (VTBL_ENTRY)&_ZN8S7368C44D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C44D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C44[];
extern  VTBL_ENTRY _ZTV8S7368C44[];
Class_Descriptor cd_S7368C44 = {  "S7368C44", // class name
  0,0,//no base classes
  &(vtc_S7368C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI8S7368C44),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C44),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C47  {
  ::S7368C9_nt s7368c47f0;
  void  mf7368c47(); // _ZN8S7368C479mf7368c47Ev
  virtual  ~S7368C47(); // _ZN8S7368C47D1Ev
  S7368C47(); // tgen
};
//SIG(-1 S7368C47) C1{ vd m FC2{ m Fp Fi FC3{ m}}}


void  S7368C47 ::mf7368c47(){}
 S7368C47 ::~S7368C47(){ note_dtor("S7368C47", this);}
S7368C47 ::S7368C47(){ note_ctor("S7368C47", this);} // tgen

static void Test_S7368C47()
{
  extern Class_Descriptor cd_S7368C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S7368C47, buf);
    S7368C47 *dp, &lv = *(dp=new (buf) S7368C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C47)");
    check_field_offset(lv, s7368c47f0, ABISELECT(8,4), "S7368C47.s7368c47f0");
    test_class_info(&lv, &cd_S7368C47);
    dp->~S7368C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C47(Test_S7368C47, "S7368C47", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S7368C47C1Ev();
extern void _ZN8S7368C47D1Ev();
Name_Map name_map_S7368C47[] = {
  NSPAIR(_ZN8S7368C47C1Ev),
  NSPAIR(_ZN8S7368C47D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C47[];
extern void _ZN8S7368C47D1Ev();
extern void _ZN8S7368C47D0Ev();
static  VTBL_ENTRY vtc_S7368C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C47[0]),
  (VTBL_ENTRY)&_ZN8S7368C47D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C47D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C47[];
extern  VTBL_ENTRY _ZTV8S7368C47[];
Class_Descriptor cd_S7368C47 = {  "S7368C47", // class name
  0,0,//no base classes
  &(vtc_S7368C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S7368C47),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C47),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C48  {
  ::S7368C9_nt s7368c48f0;
  ::S7368C9_nt s7368c48f1;
  ::S7368C9_nt s7368c48f2;
  ::S7368C11 s7368c48f3;
  ::S7368C25 s7368c48f4;
  ::S7368C9_nt s7368c48f5;
  ::S7368C5_nt s7368c48f6;
  ::S7368C9_nt s7368c48f7;
  ::S7368C15 s7368c48f8;
  void  mf7368c48(); // _ZN8S7368C489mf7368c48Ev
  virtual  ~S7368C48(); // _ZN8S7368C48D1Ev
  S7368C48(); // tgen
};
//SIG(-1 S7368C48) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC4{ BC5{ vd m Fc} vd FL[2]} FC6{ BC5 vd FC4 FC4} FC2 FC7{ m Fp Fi[2] FC8{ m}} FC2 FC9{ m Fp Fi[2] FC3}}


void  S7368C48 ::mf7368c48(){}
 S7368C48 ::~S7368C48(){ note_dtor("S7368C48", this);}
S7368C48 ::S7368C48(){ note_ctor("S7368C48", this);} // tgen

static void Test_S7368C48()
{
  extern Class_Descriptor cd_S7368C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,45)];
    init_test(&cd_S7368C48, buf);
    S7368C48 *dp, &lv = *(dp=new (buf) S7368C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,176), "sizeof(S7368C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C48)");
    check_field_offset(lv, s7368c48f0, ABISELECT(8,4), "S7368C48.s7368c48f0");
    check_field_offset(lv, s7368c48f1, ABISELECT(24,16), "S7368C48.s7368c48f1");
    check_field_offset(lv, s7368c48f2, ABISELECT(40,28), "S7368C48.s7368c48f2");
    check_field_offset(lv, s7368c48f3, ABISELECT(56,40), "S7368C48.s7368c48f3");
    check_field_offset(lv, s7368c48f4, ABISELECT(88,64), "S7368C48.s7368c48f4");
    check_field_offset(lv, s7368c48f5, ABISELECT(168,120), "S7368C48.s7368c48f5");
    check_field_offset(lv, s7368c48f6, ABISELECT(184,132), "S7368C48.s7368c48f6");
    check_field_offset(lv, s7368c48f7, ABISELECT(208,148), "S7368C48.s7368c48f7");
    check_field_offset(lv, s7368c48f8, ABISELECT(224,160), "S7368C48.s7368c48f8");
    test_class_info(&lv, &cd_S7368C48);
    dp->~S7368C48();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C48(Test_S7368C48, "S7368C48", ABISELECT(248,176));

#else // __cplusplus

extern void _ZN8S7368C48C1Ev();
extern void _ZN8S7368C48D1Ev();
Name_Map name_map_S7368C48[] = {
  NSPAIR(_ZN8S7368C48C1Ev),
  NSPAIR(_ZN8S7368C48D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C48[];
extern void _ZN8S7368C48D1Ev();
extern void _ZN8S7368C48D0Ev();
static  VTBL_ENTRY vtc_S7368C48[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C48[0]),
  (VTBL_ENTRY)&_ZN8S7368C48D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C48D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C48[];
extern  VTBL_ENTRY _ZTV8S7368C48[];
Class_Descriptor cd_S7368C48 = {  "S7368C48", // class name
  0,0,//no base classes
  &(vtc_S7368C48[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,176), // object size
  NSPAIRA(_ZTI8S7368C48),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C48),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C51  {
  void  mf7368c51(); // _ZN8S7368C519mf7368c51Ev
};
//SIG(-1 S7368C51) C1{ m}


void  S7368C51 ::mf7368c51(){}

static void Test_S7368C51()
{
  {
    init_simple_test("S7368C51");
    S7368C51 lv;
    check2(sizeof(lv), 1, "sizeof(S7368C51)");
    check2(__alignof__(lv), 1, "__alignof__(S7368C51)");
  }
}
static Arrange_To_Call_Me vS7368C51(Test_S7368C51, "S7368C51", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S7368C51[];
VTBL_ENTRY *P__ZTI8S7368C51 = _ZTI8S7368C51; 
Class_Descriptor cd_S7368C51 = {  "S7368C51", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S7368C51),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C50  {
  void *s7368c50f0;
  int s7368c50f1[2];
  ::S7368C51 s7368c50f2;
  void  mf7368c50(); // _ZN8S7368C509mf7368c50Ev
};
//SIG(-1 S7368C50) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C50 ::mf7368c50(){}

static void Test_S7368C50()
{
  {
    init_simple_test("S7368C50");
    S7368C50 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C50)");
    check_field_offset(lv, s7368c50f0, 0, "S7368C50.s7368c50f0");
    check_field_offset(lv, s7368c50f1, ABISELECT(8,4), "S7368C50.s7368c50f1");
    check_field_offset(lv, s7368c50f2, ABISELECT(16,12), "S7368C50.s7368c50f2");
  }
}
static Arrange_To_Call_Me vS7368C50(Test_S7368C50, "S7368C50", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S7368C50[];
VTBL_ENTRY *P__ZTI8S7368C50 = _ZTI8S7368C50; 
Class_Descriptor cd_S7368C50 = {  "S7368C50", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S7368C50),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C49  {
  ::S7368C50 s7368c49f0;
  void  mf7368c49(); // _ZN8S7368C499mf7368c49Ev
  virtual  ~S7368C49(); // _ZN8S7368C49D1Ev
  S7368C49(); // tgen
};
//SIG(-1 S7368C49) C1{ vd m FC2{ m Fp Fi[2] FC3{ m}}}


void  S7368C49 ::mf7368c49(){}
 S7368C49 ::~S7368C49(){ note_dtor("S7368C49", this);}
S7368C49 ::S7368C49(){ note_ctor("S7368C49", this);} // tgen

static void Test_S7368C49()
{
  extern Class_Descriptor cd_S7368C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S7368C49, buf);
    S7368C49 *dp, &lv = *(dp=new (buf) S7368C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S7368C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C49)");
    check_field_offset(lv, s7368c49f0, ABISELECT(8,4), "S7368C49.s7368c49f0");
    test_class_info(&lv, &cd_S7368C49);
    dp->~S7368C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C49(Test_S7368C49, "S7368C49", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S7368C49C1Ev();
extern void _ZN8S7368C49D1Ev();
Name_Map name_map_S7368C49[] = {
  NSPAIR(_ZN8S7368C49C1Ev),
  NSPAIR(_ZN8S7368C49D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C49[];
extern void _ZN8S7368C49D1Ev();
extern void _ZN8S7368C49D0Ev();
static  VTBL_ENTRY vtc_S7368C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C49[0]),
  (VTBL_ENTRY)&_ZN8S7368C49D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C49D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C49[];
extern  VTBL_ENTRY _ZTV8S7368C49[];
Class_Descriptor cd_S7368C49 = {  "S7368C49", // class name
  0,0,//no base classes
  &(vtc_S7368C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S7368C49),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C49),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C39  : virtual S7368C3 {
  ::S7368C40 s7368c39f0;
  ::S7368C40 s7368c39f1;
  ::S7368C41 s7368c39f2;
  ::S7368C44 s7368c39f3;
  ::S7368C44 s7368c39f4;
  ::S7368C47 s7368c39f5;
  ::S7368C48 s7368c39f6;
  ::S7368C49 s7368c39f7;
  int s7368c39f8;
  ::S7368C34 s7368c39f9;
  ::S7368C32 s7368c39f10;
  virtual  ~S7368C39(); // _ZN8S7368C39D2Ev
  S7368C39(); // tgen
};
//SIG(-1 S7368C39) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ vd m FC8 FC10 Fi[2]} FC13 FC14{ vd m FC15{ m Fp Fi[2] FC16{ m}} FC17{ BC7 vd FC10 FC10} FC12} FC18{ vd m FC15 FC17} FC18 FC19{ vd m FC8} FC20{ vd m FC8 FC8 FC8 FC10 FC17 FC8 FC4 FC8 FC12} FC21{ vd m FC22{ m Fp Fi[2] FC23{ m}}} Fi FC24{ BC7 vd FC25{ BC7 vd FL} Fi FC26{ vd m FC8 FC10} FC26 Fi FC8 FC8 Fi FC26 FC26} FC27{ vd m FC25 FC6}}


 S7368C39 ::~S7368C39(){ note_dtor("S7368C39", this);}
S7368C39 ::S7368C39(){ note_ctor("S7368C39", this);} // tgen

static void Test_S7368C39()
{
  extern Class_Descriptor cd_S7368C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(232,318)];
    init_test(&cd_S7368C39, buf);
    S7368C39 *dp, &lv = *(dp=new (buf) S7368C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1848,1268), "sizeof(S7368C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C39)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(1352,936), "S7368C39");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(1352,936), "S7368C39");
    check_field_offset(lv, s7368c39f0, ABISELECT(8,4), "S7368C39.s7368c39f0");
    check_field_offset(lv, s7368c39f1, ABISELECT(72,52), "S7368C39.s7368c39f1");
    check_field_offset(lv, s7368c39f2, ABISELECT(136,100), "S7368C39.s7368c39f2");
    check_field_offset(lv, s7368c39f3, ABISELECT(272,192), "S7368C39.s7368c39f3");
    check_field_offset(lv, s7368c39f4, ABISELECT(384,268), "S7368C39.s7368c39f4");
    check_field_offset(lv, s7368c39f5, ABISELECT(496,344), "S7368C39.s7368c39f5");
    check_field_offset(lv, s7368c39f6, ABISELECT(520,360), "S7368C39.s7368c39f6");
    check_field_offset(lv, s7368c39f7, ABISELECT(768,536), "S7368C39.s7368c39f7");
    check_field_offset(lv, s7368c39f8, ABISELECT(800,556), "S7368C39.s7368c39f8");
    check_field_offset(lv, s7368c39f9, ABISELECT(808,560), "S7368C39.s7368c39f9");
    check_field_offset(lv, s7368c39f10, ABISELECT(1128,780), "S7368C39.s7368c39f10");
    test_class_info(&lv, &cd_S7368C39);
    dp->~S7368C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C39(Test_S7368C39, "S7368C39", ABISELECT(1848,1268));

#else // __cplusplus

extern void _ZN8S7368C39C1Ev();
extern void _ZN8S7368C39D2Ev();
Name_Map name_map_S7368C39[] = {
  NSPAIR(_ZN8S7368C39C1Ev),
  NSPAIR(_ZN8S7368C39D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(1352,936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(1352,936), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C39[];
extern void _ZN8S7368C39D1Ev();
extern void _ZN8S7368C39D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev)();
extern void ABISELECT(_ZThn1352_N8S7368C39D1Ev,_ZThn936_N8S7368C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev)();
extern void ABISELECT(_ZThn1352_N8S7368C39D0Ev,_ZThn936_N8S7368C39D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C39[] = {
  ABISELECT(1352,936),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C39[0]),
  (VTBL_ENTRY)&_ZN8S7368C39D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C39D0Ev,
  ABISELECT(-1352,-936),
  ABISELECT(-1352,-936),
  (VTBL_ENTRY)&(_ZTI8S7368C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C39[];
static  VTT_ENTRY vtt_S7368C39[] = {
  {&(_ZTV8S7368C39[3]),  3,10},
  {&(_ZTV8S7368C39[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C39[];
extern  VTBL_ENTRY _ZTV8S7368C39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C39[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S7368C39D0Ev,_ZThn936_N8S7368C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1352_N8S7368C39D1Ev,_ZThn936_N8S7368C39D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C39 = {  "S7368C39", // class name
  bases_S7368C39, 2,
  &(vtc_S7368C39[0]), // expected_vtbl_contents
  &(vtt_S7368C39[0]), // expected_vtt_contents
  ABISELECT(1848,1268), // object size
  NSPAIRA(_ZTI8S7368C39),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C39),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C39),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C53  {
  ::S7368C9_nt s7368c53f0;
  ::S7368C9_nt s7368c53f1;
  ::S7368C11 s7368c53f2;
  ::S7368C11 s7368c53f3;
  int s7368c53f4;
  char s7368c53f5;
  ::S7368C9_nt s7368c53f6;
  void  mf7368c53(); // _ZN8S7368C539mf7368c53Ev
  virtual  ~S7368C53(); // _ZN8S7368C53D1Ev
  S7368C53(); // tgen
};
//SIG(-1 S7368C53) C1{ vd m FC2{ m Fp Fi FC3{ m}} FC2 FC4{ BC5{ vd m Fc} vd FL[2]} FC4 Fi Fc FC2}


void  S7368C53 ::mf7368c53(){}
 S7368C53 ::~S7368C53(){ note_dtor("S7368C53", this);}
S7368C53 ::S7368C53(){ note_ctor("S7368C53", this);} // tgen

static void Test_S7368C53()
{
  extern Class_Descriptor cd_S7368C53;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S7368C53, buf);
    S7368C53 *dp, &lv = *(dp=new (buf) S7368C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S7368C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C53)");
    check_field_offset(lv, s7368c53f0, ABISELECT(8,4), "S7368C53.s7368c53f0");
    check_field_offset(lv, s7368c53f1, ABISELECT(24,16), "S7368C53.s7368c53f1");
    check_field_offset(lv, s7368c53f2, ABISELECT(40,28), "S7368C53.s7368c53f2");
    check_field_offset(lv, s7368c53f3, ABISELECT(72,52), "S7368C53.s7368c53f3");
    check_field_offset(lv, s7368c53f4, ABISELECT(104,76), "S7368C53.s7368c53f4");
    check_field_offset(lv, s7368c53f5, ABISELECT(108,80), "S7368C53.s7368c53f5");
    check_field_offset(lv, s7368c53f6, ABISELECT(112,84), "S7368C53.s7368c53f6");
    test_class_info(&lv, &cd_S7368C53);
    dp->~S7368C53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C53(Test_S7368C53, "S7368C53", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN8S7368C53C1Ev();
extern void _ZN8S7368C53D1Ev();
Name_Map name_map_S7368C53[] = {
  NSPAIR(_ZN8S7368C53C1Ev),
  NSPAIR(_ZN8S7368C53D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C53[];
extern void _ZN8S7368C53D1Ev();
extern void _ZN8S7368C53D0Ev();
static  VTBL_ENTRY vtc_S7368C53[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C53[0]),
  (VTBL_ENTRY)&_ZN8S7368C53D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C53D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C53[];
extern  VTBL_ENTRY _ZTV8S7368C53[];
Class_Descriptor cd_S7368C53 = {  "S7368C53", // class name
  0,0,//no base classes
  &(vtc_S7368C53[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI8S7368C53),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C53),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C55  {
  int s7368c55f0;
  ::S7368C9_nt s7368c55f1;
  ::S7368C7 s7368c55f2;
  ::S7368C7 s7368c55f3;
  __tsi64 s7368c55f4[2];
  long s7368c55f5;
  ::S7368C9_nt s7368c55f6;
  long s7368c55f7;
  ::S7368C9_nt s7368c55f8;
  ::S7368C50 s7368c55f9;
  ::S7368C15 s7368c55f10;
  ::S7368C15 s7368c55f11;
  void  mf7368c55(); // _ZN8S7368C559mf7368c55Ev
  virtual  ~S7368C55(); // _ZN8S7368C55D1Ev
  S7368C55(); // tgen
};
//SIG(-1 S7368C55) C1{ vd m Fi FC2{ m Fp Fi FC3{ m}} FC4{ BC5{ vd m Fc} vd Fi FC2 FC6{ BC5 vd FL[2]} FC2 FC7{ BC5 vd FC2 FC2 FC2 FC8{ m Fp Fi[2] FC9{ m}} FC10{ m Fp Fi[2] FC3}}} FC4 FL[2] Fl FC2 Fl FC2 FC11{ m Fp Fi[2] FC12{ m}} FC10 FC10}


void  S7368C55 ::mf7368c55(){}
 S7368C55 ::~S7368C55(){ note_dtor("S7368C55", this);}
S7368C55 ::S7368C55(){ note_ctor("S7368C55", this);} // tgen

static void Test_S7368C55()
{
  extern Class_Descriptor cd_S7368C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(70,98)];
    init_test(&cd_S7368C55, buf);
    S7368C55 *dp, &lv = *(dp=new (buf) S7368C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(552,388), "sizeof(S7368C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C55)");
    check_field_offset(lv, s7368c55f0, ABISELECT(8,4), "S7368C55.s7368c55f0");
    check_field_offset(lv, s7368c55f1, ABISELECT(16,8), "S7368C55.s7368c55f1");
    check_field_offset(lv, s7368c55f2, ABISELECT(32,20), "S7368C55.s7368c55f2");
    check_field_offset(lv, s7368c55f3, ABISELECT(224,156), "S7368C55.s7368c55f3");
    check_field_offset(lv, s7368c55f4, ABISELECT(416,292), "S7368C55.s7368c55f4");
    check_field_offset(lv, s7368c55f5, ABISELECT(432,308), "S7368C55.s7368c55f5");
    check_field_offset(lv, s7368c55f6, ABISELECT(440,312), "S7368C55.s7368c55f6");
    check_field_offset(lv, s7368c55f7, ABISELECT(456,324), "S7368C55.s7368c55f7");
    check_field_offset(lv, s7368c55f8, ABISELECT(464,328), "S7368C55.s7368c55f8");
    check_field_offset(lv, s7368c55f9, ABISELECT(480,340), "S7368C55.s7368c55f9");
    check_field_offset(lv, s7368c55f10, ABISELECT(504,356), "S7368C55.s7368c55f10");
    check_field_offset(lv, s7368c55f11, ABISELECT(528,372), "S7368C55.s7368c55f11");
    test_class_info(&lv, &cd_S7368C55);
    dp->~S7368C55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C55(Test_S7368C55, "S7368C55", ABISELECT(552,388));

#else // __cplusplus

extern void _ZN8S7368C55C1Ev();
extern void _ZN8S7368C55D1Ev();
Name_Map name_map_S7368C55[] = {
  NSPAIR(_ZN8S7368C55C1Ev),
  NSPAIR(_ZN8S7368C55D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C55[];
extern void _ZN8S7368C55D1Ev();
extern void _ZN8S7368C55D0Ev();
static  VTBL_ENTRY vtc_S7368C55[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C55[0]),
  (VTBL_ENTRY)&_ZN8S7368C55D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C55D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C55[];
extern  VTBL_ENTRY _ZTV8S7368C55[];
Class_Descriptor cd_S7368C55 = {  "S7368C55", // class name
  0,0,//no base classes
  &(vtc_S7368C55[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(552,388), // object size
  NSPAIRA(_ZTI8S7368C55),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C55),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C58  {
  void *s7368c58f0;
  int s7368c58f1[2];
  ::S7368C51 s7368c58f2;
  void  mf7368c58(); // _ZN8S7368C589mf7368c58Ev
};
//SIG(-1 S7368C58) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C58 ::mf7368c58(){}

static void Test_S7368C58()
{
  {
    init_simple_test("S7368C58");
    S7368C58 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C58)");
    check_field_offset(lv, s7368c58f0, 0, "S7368C58.s7368c58f0");
    check_field_offset(lv, s7368c58f1, ABISELECT(8,4), "S7368C58.s7368c58f1");
    check_field_offset(lv, s7368c58f2, ABISELECT(16,12), "S7368C58.s7368c58f2");
  }
}
static Arrange_To_Call_Me vS7368C58(Test_S7368C58, "S7368C58", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C54  {
  ::S7368C55 s7368c54f0;
  ::S7368C15 s7368c54f1;
  int s7368c54f2;
  ::S7368C58 s7368c54f3;
  void  mf7368c54(); // _ZN8S7368C549mf7368c54Ev
  virtual  ~S7368C54(); // _ZN8S7368C54D1Ev
  S7368C54(); // tgen
};
//SIG(-1 S7368C54) C1{ vd m FC2{ vd m Fi FC3{ m Fp Fi FC4{ m}} FC5{ BC6{ vd m Fc} vd Fi FC3 FC7{ BC6 vd FL[2]} FC3 FC8{ BC6 vd FC3 FC3 FC3 FC9{ m Fp Fi[2] FC10{ m}} FC11{ m Fp Fi[2] FC4}}} FC5 FL[2] Fl FC3 Fl FC3 FC12{ m Fp Fi[2] FC13{ m}} FC11 FC11} FC11 Fi FC14{ m Fp Fi[2] FC13}}


void  S7368C54 ::mf7368c54(){}
 S7368C54 ::~S7368C54(){ note_dtor("S7368C54", this);}
S7368C54 ::S7368C54(){ note_ctor("S7368C54", this);} // tgen

static void Test_S7368C54()
{
  extern Class_Descriptor cd_S7368C54;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(78,108)];
    init_test(&cd_S7368C54, buf);
    S7368C54 *dp, &lv = *(dp=new (buf) S7368C54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(616,428), "sizeof(S7368C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C54)");
    check_field_offset(lv, s7368c54f0, ABISELECT(8,4), "S7368C54.s7368c54f0");
    check_field_offset(lv, s7368c54f1, ABISELECT(560,392), "S7368C54.s7368c54f1");
    check_field_offset(lv, s7368c54f2, ABISELECT(584,408), "S7368C54.s7368c54f2");
    check_field_offset(lv, s7368c54f3, ABISELECT(592,412), "S7368C54.s7368c54f3");
    test_class_info(&lv, &cd_S7368C54);
    dp->~S7368C54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C54(Test_S7368C54, "S7368C54", ABISELECT(616,428));

#else // __cplusplus

extern void _ZN8S7368C54C1Ev();
extern void _ZN8S7368C54D1Ev();
Name_Map name_map_S7368C54[] = {
  NSPAIR(_ZN8S7368C54C1Ev),
  NSPAIR(_ZN8S7368C54D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C54[];
extern void _ZN8S7368C54D1Ev();
extern void _ZN8S7368C54D0Ev();
static  VTBL_ENTRY vtc_S7368C54[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C54[0]),
  (VTBL_ENTRY)&_ZN8S7368C54D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C54D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C54[];
extern  VTBL_ENTRY _ZTV8S7368C54[];
Class_Descriptor cd_S7368C54 = {  "S7368C54", // class name
  0,0,//no base classes
  &(vtc_S7368C54[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(616,428), // object size
  NSPAIRA(_ZTI8S7368C54),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C54),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C60  : S7368C18_nt {
  void *s7368c60f0;
  ::S7368C9_nt s7368c60f1;
  virtual  ~S7368C60(); // _ZN8S7368C60D1Ev
  S7368C60(); // tgen
};
//SIG(-1 S7368C60) C1{ BC2{ vd m Fp} vd Fp FC3{ m Fp Fi FC4{ m}}}


 S7368C60 ::~S7368C60(){ note_dtor("S7368C60", this);}
S7368C60 ::S7368C60(){ note_ctor("S7368C60", this);} // tgen

static void Test_S7368C60()
{
  extern Class_Descriptor cd_S7368C60;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S7368C60, buf);
    S7368C60 *dp, &lv = *(dp=new (buf) S7368C60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S7368C60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C60)");
    check_base_class_offset(lv, (S7368C18_nt*), 0, "S7368C60");
    check_field_offset(lv, s7368c60f0, ABISELECT(16,8), "S7368C60.s7368c60f0");
    check_field_offset(lv, s7368c60f1, ABISELECT(24,12), "S7368C60.s7368c60f1");
    test_class_info(&lv, &cd_S7368C60);
    dp->~S7368C60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C60(Test_S7368C60, "S7368C60", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S7368C60C1Ev();
extern void _ZN8S7368C60D1Ev();
Name_Map name_map_S7368C60[] = {
  NSPAIR(_ZN8S7368C60C1Ev),
  NSPAIR(_ZN8S7368C60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C18_nt;
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
static Base_Class bases_S7368C60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C60[];
extern void _ZN8S7368C60D1Ev();
extern void _ZN8S7368C60D0Ev();
static  VTBL_ENTRY vtc_S7368C60[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C60[0]),
  (VTBL_ENTRY)&_ZN8S7368C60D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C60D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C60[];
extern  VTBL_ENTRY _ZTV8S7368C60[];
Class_Descriptor cd_S7368C60 = {  "S7368C60", // class name
  bases_S7368C60, 1,
  &(vtc_S7368C60[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S7368C60),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C60),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C52  : virtual S7368C3 {
  ::S7368C53 s7368c52f0;
  ::S7368C54 s7368c52f1;
  ::S7368C42 s7368c52f2;
  int s7368c52f3;
  ::S7368C60 s7368c52f4;
  int s7368c52f5;
  virtual  ~S7368C52(); // _ZN8S7368C52D2Ev
  S7368C52(); // tgen
};
//SIG(-1 S7368C52) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ vd m FC8 FC8 FC10 FC10 Fi Fc FC8} FC14{ vd m FC15{ vd m Fi FC8 FC6 FC6 FL[2] Fl FC8 Fl FC8 FC16{ m Fp Fi[2] FC17{ m}} FC12 FC12} FC12 Fi FC18{ m Fp Fi[2] FC17}} FC19{ m Fp Fi[2] FC20{ m}} Fi FC21{ BC22{ vd m Fp} vd Fp FC8} Fi}


 S7368C52 ::~S7368C52(){ note_dtor("S7368C52", this);}
S7368C52 ::S7368C52(){ note_ctor("S7368C52", this);} // tgen

static void Test_S7368C52()
{
  extern Class_Descriptor cd_S7368C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(167,228)];
    init_test(&cd_S7368C52, buf);
    S7368C52 *dp, &lv = *(dp=new (buf) S7368C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1328,908), "sizeof(S7368C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C52)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(832,576), "S7368C52");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(832,576), "S7368C52");
    check_field_offset(lv, s7368c52f0, ABISELECT(8,4), "S7368C52.s7368c52f0");
    check_field_offset(lv, s7368c52f1, ABISELECT(136,100), "S7368C52.s7368c52f1");
    check_field_offset(lv, s7368c52f2, ABISELECT(752,528), "S7368C52.s7368c52f2");
    check_field_offset(lv, s7368c52f3, ABISELECT(776,544), "S7368C52.s7368c52f3");
    check_field_offset(lv, s7368c52f4, ABISELECT(784,548), "S7368C52.s7368c52f4");
    check_field_offset(lv, s7368c52f5, ABISELECT(824,572), "S7368C52.s7368c52f5");
    test_class_info(&lv, &cd_S7368C52);
    dp->~S7368C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C52(Test_S7368C52, "S7368C52", ABISELECT(1328,908));

#else // __cplusplus

extern void _ZN8S7368C52C1Ev();
extern void _ZN8S7368C52D2Ev();
Name_Map name_map_S7368C52[] = {
  NSPAIR(_ZN8S7368C52C1Ev),
  NSPAIR(_ZN8S7368C52D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(832,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(832,576), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C52[];
extern void _ZN8S7368C52D1Ev();
extern void _ZN8S7368C52D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev)();
extern void ABISELECT(_ZThn832_N8S7368C52D1Ev,_ZThn576_N8S7368C52D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev)();
extern void ABISELECT(_ZThn832_N8S7368C52D0Ev,_ZThn576_N8S7368C52D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C52[] = {
  ABISELECT(832,576),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C52[0]),
  (VTBL_ENTRY)&_ZN8S7368C52D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C52D0Ev,
  ABISELECT(-832,-576),
  ABISELECT(-832,-576),
  (VTBL_ENTRY)&(_ZTI8S7368C52[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C52[];
static  VTT_ENTRY vtt_S7368C52[] = {
  {&(_ZTV8S7368C52[3]),  3,10},
  {&(_ZTV8S7368C52[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C52[];
extern  VTBL_ENTRY _ZTV8S7368C52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C52[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S7368C52D0Ev,_ZThn576_N8S7368C52D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S7368C52D1Ev,_ZThn576_N8S7368C52D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C52 = {  "S7368C52", // class name
  bases_S7368C52, 2,
  &(vtc_S7368C52[0]), // expected_vtbl_contents
  &(vtt_S7368C52[0]), // expected_vtt_contents
  ABISELECT(1328,908), // object size
  NSPAIRA(_ZTI8S7368C52),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C52),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C52),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C61  : virtual S7368C3 {
  virtual  ~S7368C61(); // _ZN8S7368C61D2Ev
  S7368C61(); // tgen
};
//SIG(-1 S7368C61) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd}


 S7368C61 ::~S7368C61(){ note_dtor("S7368C61", this);}
S7368C61 ::S7368C61(){ note_ctor("S7368C61", this);} // tgen

static void Test_S7368C61()
{
  extern Class_Descriptor cd_S7368C61;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(64,85)];
    init_test(&cd_S7368C61, buf);
    S7368C61 *dp, &lv = *(dp=new (buf) S7368C61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(504,336), "sizeof(S7368C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C61)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(8,4), "S7368C61");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(8,4), "S7368C61");
    test_class_info(&lv, &cd_S7368C61);
    dp->~S7368C61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C61(Test_S7368C61, "S7368C61", ABISELECT(504,336));

#else // __cplusplus

extern void _ZN8S7368C61C1Ev();
extern void _ZN8S7368C61D2Ev();
Name_Map name_map_S7368C61[] = {
  NSPAIR(_ZN8S7368C61C1Ev),
  NSPAIR(_ZN8S7368C61D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C61[];
extern void _ZN8S7368C61D1Ev();
extern void _ZN8S7368C61D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev)();
extern void ABISELECT(_ZThn8_N8S7368C61D1Ev,_ZThn4_N8S7368C61D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev)();
extern void ABISELECT(_ZThn8_N8S7368C61D0Ev,_ZThn4_N8S7368C61D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C61[0]),
  (VTBL_ENTRY)&_ZN8S7368C61D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C61D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7368C61[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C61[];
static  VTT_ENTRY vtt_S7368C61[] = {
  {&(_ZTV8S7368C61[3]),  3,10},
  {&(_ZTV8S7368C61[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C61[];
extern  VTBL_ENTRY _ZTV8S7368C61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C61[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S7368C61D0Ev,_ZThn4_N8S7368C61D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S7368C61D1Ev,_ZThn4_N8S7368C61D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C61 = {  "S7368C61", // class name
  bases_S7368C61, 2,
  &(vtc_S7368C61[0]), // expected_vtbl_contents
  &(vtt_S7368C61[0]), // expected_vtt_contents
  ABISELECT(504,336), // object size
  NSPAIRA(_ZTI8S7368C61),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C61),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C61),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C63  {
  ::S7368C9_nt s7368c63f0;
  int s7368c63f1;
  ::S7368C11 s7368c63f2;
  void  mf7368c63(); // _ZN8S7368C639mf7368c63Ev
  virtual  ~S7368C63(); // _ZN8S7368C63D1Ev
  S7368C63(); // tgen
};
//SIG(-1 S7368C63) C1{ vd m FC2{ m Fp Fi FC3{ m}} Fi FC4{ BC5{ vd m Fc} vd FL[2]}}


void  S7368C63 ::mf7368c63(){}
 S7368C63 ::~S7368C63(){ note_dtor("S7368C63", this);}
S7368C63 ::S7368C63(){ note_ctor("S7368C63", this);} // tgen

static void Test_S7368C63()
{
  extern Class_Descriptor cd_S7368C63;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S7368C63, buf);
    S7368C63 *dp, &lv = *(dp=new (buf) S7368C63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S7368C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C63)");
    check_field_offset(lv, s7368c63f0, ABISELECT(8,4), "S7368C63.s7368c63f0");
    check_field_offset(lv, s7368c63f1, ABISELECT(24,16), "S7368C63.s7368c63f1");
    check_field_offset(lv, s7368c63f2, ABISELECT(32,20), "S7368C63.s7368c63f2");
    test_class_info(&lv, &cd_S7368C63);
    dp->~S7368C63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C63(Test_S7368C63, "S7368C63", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN8S7368C63C1Ev();
extern void _ZN8S7368C63D1Ev();
Name_Map name_map_S7368C63[] = {
  NSPAIR(_ZN8S7368C63C1Ev),
  NSPAIR(_ZN8S7368C63D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C63[];
extern void _ZN8S7368C63D1Ev();
extern void _ZN8S7368C63D0Ev();
static  VTBL_ENTRY vtc_S7368C63[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C63[0]),
  (VTBL_ENTRY)&_ZN8S7368C63D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C63D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C63[];
extern  VTBL_ENTRY _ZTV8S7368C63[];
Class_Descriptor cd_S7368C63 = {  "S7368C63", // class name
  0,0,//no base classes
  &(vtc_S7368C63[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI8S7368C63),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C63),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C64  {
  ::S7368C11 s7368c64f0;
  ::S7368C9_nt s7368c64f1;
  int s7368c64f2;
  ::S7368C9_nt s7368c64f3;
  ::S7368C58 s7368c64f4;
  int s7368c64f5;
  void  mf7368c64(); // _ZN8S7368C649mf7368c64Ev
  virtual  ~S7368C64(); // _ZN8S7368C64D1Ev
  S7368C64(); // tgen
};
//SIG(-1 S7368C64) C1{ vd m FC2{ BC3{ vd m Fc} vd FL[2]} FC4{ m Fp Fi FC5{ m}} Fi FC4 FC6{ m Fp Fi[2] FC7{ m}} Fi}


void  S7368C64 ::mf7368c64(){}
 S7368C64 ::~S7368C64(){ note_dtor("S7368C64", this);}
S7368C64 ::S7368C64(){ note_ctor("S7368C64", this);} // tgen

static void Test_S7368C64()
{
  extern Class_Descriptor cd_S7368C64;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,20)];
    init_test(&cd_S7368C64, buf);
    S7368C64 *dp, &lv = *(dp=new (buf) S7368C64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S7368C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C64)");
    check_field_offset(lv, s7368c64f0, ABISELECT(8,4), "S7368C64.s7368c64f0");
    check_field_offset(lv, s7368c64f1, ABISELECT(40,28), "S7368C64.s7368c64f1");
    check_field_offset(lv, s7368c64f2, ABISELECT(56,40), "S7368C64.s7368c64f2");
    check_field_offset(lv, s7368c64f3, ABISELECT(64,44), "S7368C64.s7368c64f3");
    check_field_offset(lv, s7368c64f4, ABISELECT(80,56), "S7368C64.s7368c64f4");
    check_field_offset(lv, s7368c64f5, ABISELECT(104,72), "S7368C64.s7368c64f5");
    test_class_info(&lv, &cd_S7368C64);
    dp->~S7368C64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C64(Test_S7368C64, "S7368C64", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN8S7368C64C1Ev();
extern void _ZN8S7368C64D1Ev();
Name_Map name_map_S7368C64[] = {
  NSPAIR(_ZN8S7368C64C1Ev),
  NSPAIR(_ZN8S7368C64D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S7368C64[];
extern void _ZN8S7368C64D1Ev();
extern void _ZN8S7368C64D0Ev();
static  VTBL_ENTRY vtc_S7368C64[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C64[0]),
  (VTBL_ENTRY)&_ZN8S7368C64D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C64D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C64[];
extern  VTBL_ENTRY _ZTV8S7368C64[];
Class_Descriptor cd_S7368C64 = {  "S7368C64", // class name
  0,0,//no base classes
  &(vtc_S7368C64[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI8S7368C64),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S7368C64),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C62  : virtual S7368C3 {
  ::S7368C63 s7368c62f0;
  ::S7368C64 s7368c62f1;
  ::S7368C64 s7368c62f2;
  int s7368c62f3[2];
  virtual  ~S7368C62(); // _ZN8S7368C62D2Ev
  S7368C62(); // tgen
};
//SIG(-1 S7368C62) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ vd m FC8 Fi FC10} FC14{ vd m FC10 FC8 Fi FC8 FC15{ m Fp Fi[2] FC16{ m}} Fi} FC14 Fi[2]}


 S7368C62 ::~S7368C62(){ note_dtor("S7368C62", this);}
S7368C62 ::S7368C62(){ note_ctor("S7368C62", this);} // tgen

static void Test_S7368C62()
{
  extern Class_Descriptor cd_S7368C62;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(101,136)];
    init_test(&cd_S7368C62, buf);
    S7368C62 *dp, &lv = *(dp=new (buf) S7368C62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(800,540), "sizeof(S7368C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C62)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(304,208), "S7368C62");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(304,208), "S7368C62");
    check_field_offset(lv, s7368c62f0, ABISELECT(8,4), "S7368C62.s7368c62f0");
    check_field_offset(lv, s7368c62f1, ABISELECT(72,48), "S7368C62.s7368c62f1");
    check_field_offset(lv, s7368c62f2, ABISELECT(184,124), "S7368C62.s7368c62f2");
    check_field_offset(lv, s7368c62f3, ABISELECT(296,200), "S7368C62.s7368c62f3");
    test_class_info(&lv, &cd_S7368C62);
    dp->~S7368C62();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C62(Test_S7368C62, "S7368C62", ABISELECT(800,540));

#else // __cplusplus

extern void _ZN8S7368C62C1Ev();
extern void _ZN8S7368C62D2Ev();
Name_Map name_map_S7368C62[] = {
  NSPAIR(_ZN8S7368C62C1Ev),
  NSPAIR(_ZN8S7368C62D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(304,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(304,208), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C62[];
extern void _ZN8S7368C62D1Ev();
extern void _ZN8S7368C62D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev)();
extern void ABISELECT(_ZThn304_N8S7368C62D1Ev,_ZThn208_N8S7368C62D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev)();
extern void ABISELECT(_ZThn304_N8S7368C62D0Ev,_ZThn208_N8S7368C62D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C62[] = {
  ABISELECT(304,208),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C62[0]),
  (VTBL_ENTRY)&_ZN8S7368C62D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C62D0Ev,
  ABISELECT(-304,-208),
  ABISELECT(-304,-208),
  (VTBL_ENTRY)&(_ZTI8S7368C62[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C62[];
static  VTT_ENTRY vtt_S7368C62[] = {
  {&(_ZTV8S7368C62[3]),  3,10},
  {&(_ZTV8S7368C62[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C62[];
extern  VTBL_ENTRY _ZTV8S7368C62[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C62[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S7368C62D0Ev,_ZThn208_N8S7368C62D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S7368C62D1Ev,_ZThn208_N8S7368C62D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C62 = {  "S7368C62", // class name
  bases_S7368C62, 2,
  &(vtc_S7368C62[0]), // expected_vtbl_contents
  &(vtt_S7368C62[0]), // expected_vtt_contents
  ABISELECT(800,540), // object size
  NSPAIRA(_ZTI8S7368C62),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C62),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C62),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C70_nt  {
  __tsi64 s7368c70f0[2];
  void  mf7368c70(); // _ZN11S7368C70_nt9mf7368c70Ev
};
//SIG(-1 S7368C70_nt) C1{ m FL[2]}


void  S7368C70_nt ::mf7368c70(){}

//skip512 S7368C70_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C69_nt  {
  ::S7368C70_nt s7368c69f0;
  void  mf7368c69(); // _ZN11S7368C69_nt9mf7368c69Ev
};
//SIG(-1 S7368C69_nt) C1{ m FC2{ m FL[2]}}


void  S7368C69_nt ::mf7368c69(){}

//skip512 S7368C69_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C68  : S7368C18_nt {
  int s7368c68f0;
  ::S7368C9_nt s7368c68f1;
  void *s7368c68f2;
  ::S7368C69_nt s7368c68f3;
  char s7368c68f4;
  virtual  ~S7368C68(); // _ZN8S7368C68D1Ev
  S7368C68(); // tgen
};
//SIG(-1 S7368C68) C1{ BC2{ vd m Fp} vd Fi FC3{ m Fp Fi FC4{ m}} Fp FC5{ m FC6{ m FL[2]}} Fc}


 S7368C68 ::~S7368C68(){ note_dtor("S7368C68", this);}
S7368C68 ::S7368C68(){ note_ctor("S7368C68", this);} // tgen

static void Test_S7368C68()
{
  extern Class_Descriptor cd_S7368C68;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,13)];
    init_test(&cd_S7368C68, buf);
    S7368C68 *dp, &lv = *(dp=new (buf) S7368C68());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S7368C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C68)");
    check_base_class_offset(lv, (S7368C18_nt*), 0, "S7368C68");
    check_field_offset(lv, s7368c68f0, ABISELECT(16,8), "S7368C68.s7368c68f0");
    check_field_offset(lv, s7368c68f1, ABISELECT(24,12), "S7368C68.s7368c68f1");
    check_field_offset(lv, s7368c68f2, ABISELECT(40,24), "S7368C68.s7368c68f2");
    check_field_offset(lv, s7368c68f3, ABISELECT(48,28), "S7368C68.s7368c68f3");
    check_field_offset(lv, s7368c68f4, ABISELECT(64,44), "S7368C68.s7368c68f4");
    test_class_info(&lv, &cd_S7368C68);
    dp->~S7368C68();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C68(Test_S7368C68, "S7368C68", ABISELECT(72,48));

#else // __cplusplus

extern void _ZN8S7368C68C1Ev();
extern void _ZN8S7368C68D1Ev();
Name_Map name_map_S7368C68[] = {
  NSPAIR(_ZN8S7368C68C1Ev),
  NSPAIR(_ZN8S7368C68D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C18_nt;
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
static Base_Class bases_S7368C68[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C68[];
extern void _ZN8S7368C68D1Ev();
extern void _ZN8S7368C68D0Ev();
static  VTBL_ENTRY vtc_S7368C68[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C68[0]),
  (VTBL_ENTRY)&_ZN8S7368C68D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C68D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C68[];
extern  VTBL_ENTRY _ZTV8S7368C68[];
Class_Descriptor cd_S7368C68 = {  "S7368C68", // class name
  bases_S7368C68, 1,
  &(vtc_S7368C68[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,48), // object size
  NSPAIRA(_ZTI8S7368C68),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C68),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C72_nt  {
  int s7368c72f0[2];
  void  mf7368c72(); // _ZN11S7368C72_nt9mf7368c72Ev
  virtual  ~S7368C72_nt(); // _ZN11S7368C72_ntD1Ev
  S7368C72_nt(); // tgen
};
//SIG(-1 S7368C72_nt) C1{ vd m Fi[2]}


void  S7368C72_nt ::mf7368c72(){}
 S7368C72_nt ::~S7368C72_nt(){ note_dtor("S7368C72_nt", this);}
S7368C72_nt ::S7368C72_nt(){ note_ctor("S7368C72_nt", this);} // tgen

//skip512 S7368C72_nt

#else // __cplusplus

extern void _ZN11S7368C72_ntC1Ev();
extern void _ZN11S7368C72_ntD1Ev();
Name_Map name_map_S7368C72_nt[] = {
  NSPAIR(_ZN11S7368C72_ntC1Ev),
  NSPAIR(_ZN11S7368C72_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7368C72_nt[];
extern void _ZN11S7368C72_ntD1Ev();
extern void _ZN11S7368C72_ntD0Ev();
static  VTBL_ENTRY vtc_S7368C72_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7368C72_nt[0]),
  (VTBL_ENTRY)&_ZN11S7368C72_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S7368C72_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S7368C72_nt[];
VTBL_ENTRY *P__ZTI11S7368C72_nt = _ZTI11S7368C72_nt; 
extern  VTBL_ENTRY _ZTV11S7368C72_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C71  : S7368C18_nt {
  ::S7368C72_nt s7368c71f0;
  int s7368c71f1;
  virtual  ~S7368C71(); // _ZN8S7368C71D1Ev
  S7368C71(); // tgen
};
//SIG(-1 S7368C71) C1{ BC2{ vd m Fp} vd FC3{ vd m Fi[2]} Fi}


 S7368C71 ::~S7368C71(){ note_dtor("S7368C71", this);}
S7368C71 ::S7368C71(){ note_ctor("S7368C71", this);} // tgen

static void Test_S7368C71()
{
  extern Class_Descriptor cd_S7368C71;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S7368C71, buf);
    S7368C71 *dp, &lv = *(dp=new (buf) S7368C71());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S7368C71)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C71)");
    check_base_class_offset(lv, (S7368C18_nt*), 0, "S7368C71");
    check_field_offset(lv, s7368c71f0, ABISELECT(16,8), "S7368C71.s7368c71f0");
    check_field_offset(lv, s7368c71f1, ABISELECT(32,20), "S7368C71.s7368c71f1");
    test_class_info(&lv, &cd_S7368C71);
    dp->~S7368C71();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C71(Test_S7368C71, "S7368C71", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S7368C71C1Ev();
extern void _ZN8S7368C71D1Ev();
Name_Map name_map_S7368C71[] = {
  NSPAIR(_ZN8S7368C71C1Ev),
  NSPAIR(_ZN8S7368C71D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C18_nt;
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
static Base_Class bases_S7368C71[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C71[];
extern void _ZN8S7368C71D1Ev();
extern void _ZN8S7368C71D0Ev();
static  VTBL_ENTRY vtc_S7368C71[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C71[0]),
  (VTBL_ENTRY)&_ZN8S7368C71D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C71D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C71[];
extern  VTBL_ENTRY _ZTV8S7368C71[];
Class_Descriptor cd_S7368C71 = {  "S7368C71", // class name
  bases_S7368C71, 1,
  &(vtc_S7368C71[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S7368C71),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C71),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C73  : S7368C18_nt {
  int s7368c73f0[2];
  virtual  ~S7368C73(); // _ZN8S7368C73D1Ev
  S7368C73(); // tgen
};
//SIG(-1 S7368C73) C1{ BC2{ vd m Fp} vd Fi[2]}


 S7368C73 ::~S7368C73(){ note_dtor("S7368C73", this);}
S7368C73 ::S7368C73(){ note_ctor("S7368C73", this);} // tgen

static void Test_S7368C73()
{
  extern Class_Descriptor cd_S7368C73;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S7368C73, buf);
    S7368C73 *dp, &lv = *(dp=new (buf) S7368C73());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C73)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C73)");
    check_base_class_offset(lv, (S7368C18_nt*), 0, "S7368C73");
    check_field_offset(lv, s7368c73f0, ABISELECT(16,8), "S7368C73.s7368c73f0");
    test_class_info(&lv, &cd_S7368C73);
    dp->~S7368C73();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C73(Test_S7368C73, "S7368C73", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S7368C73C1Ev();
extern void _ZN8S7368C73D1Ev();
Name_Map name_map_S7368C73[] = {
  NSPAIR(_ZN8S7368C73C1Ev),
  NSPAIR(_ZN8S7368C73D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C18_nt;
extern VTBL_ENTRY _ZTI11S7368C18_nt[];
extern  VTBL_ENTRY _ZTV11S7368C18_nt[];
static Base_Class bases_S7368C73[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C73[];
extern void _ZN8S7368C73D1Ev();
extern void _ZN8S7368C73D0Ev();
static  VTBL_ENTRY vtc_S7368C73[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C73[0]),
  (VTBL_ENTRY)&_ZN8S7368C73D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C73D0Ev,
};
extern VTBL_ENTRY _ZTI8S7368C73[];
extern  VTBL_ENTRY _ZTV8S7368C73[];
Class_Descriptor cd_S7368C73 = {  "S7368C73", // class name
  bases_S7368C73, 1,
  &(vtc_S7368C73[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S7368C73),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7368C73),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C67  : virtual S7368C3 {
  ::S7368C68 s7368c67f0;
  ::S7368C71 s7368c67f1;
  char s7368c67f2;
  ::S7368C73 s7368c67f3;
  virtual  ~S7368C67(); // _ZN8S7368C67D2Ev
  S7368C67(); // tgen
};
//SIG(-1 S7368C67) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ BC14{ vd m Fp} vd Fi FC8 Fp FC15{ m FC16{ m FL[2]}} Fc} FC17{ BC14 vd FC18{ vd m Fi[2]} Fi} Fc FC19{ BC14 vd Fi[2]}}


 S7368C67 ::~S7368C67(){ note_dtor("S7368C67", this);}
S7368C67 ::S7368C67(){ note_ctor("S7368C67", this);} // tgen

static void Test_S7368C67()
{
  extern Class_Descriptor cd_S7368C67;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(82,108)];
    init_test(&cd_S7368C67, buf);
    S7368C67 *dp, &lv = *(dp=new (buf) S7368C67());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(648,428), "sizeof(S7368C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C67)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(152,96), "S7368C67");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(152,96), "S7368C67");
    check_field_offset(lv, s7368c67f0, ABISELECT(8,4), "S7368C67.s7368c67f0");
    check_field_offset(lv, s7368c67f1, ABISELECT(80,52), "S7368C67.s7368c67f1");
    check_field_offset(lv, s7368c67f2, ABISELECT(120,76), "S7368C67.s7368c67f2");
    check_field_offset(lv, s7368c67f3, ABISELECT(128,80), "S7368C67.s7368c67f3");
    test_class_info(&lv, &cd_S7368C67);
    dp->~S7368C67();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C67(Test_S7368C67, "S7368C67", ABISELECT(648,428));

#else // __cplusplus

extern void _ZN8S7368C67C1Ev();
extern void _ZN8S7368C67D2Ev();
Name_Map name_map_S7368C67[] = {
  NSPAIR(_ZN8S7368C67C1Ev),
  NSPAIR(_ZN8S7368C67D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C67[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(152,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(152,96), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C67[];
extern void _ZN8S7368C67D1Ev();
extern void _ZN8S7368C67D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev)();
extern void ABISELECT(_ZThn152_N8S7368C67D1Ev,_ZThn96_N8S7368C67D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev)();
extern void ABISELECT(_ZThn152_N8S7368C67D0Ev,_ZThn96_N8S7368C67D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C67[] = {
  ABISELECT(152,96),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C67[0]),
  (VTBL_ENTRY)&_ZN8S7368C67D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C67D0Ev,
  ABISELECT(-152,-96),
  ABISELECT(-152,-96),
  (VTBL_ENTRY)&(_ZTI8S7368C67[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C67[];
static  VTT_ENTRY vtt_S7368C67[] = {
  {&(_ZTV8S7368C67[3]),  3,10},
  {&(_ZTV8S7368C67[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C67[];
extern  VTBL_ENTRY _ZTV8S7368C67[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C67[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7368C67D0Ev,_ZThn96_N8S7368C67D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N8S7368C67D1Ev,_ZThn96_N8S7368C67D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C67 = {  "S7368C67", // class name
  bases_S7368C67, 2,
  &(vtc_S7368C67[0]), // expected_vtbl_contents
  &(vtt_S7368C67[0]), // expected_vtt_contents
  ABISELECT(648,428), // object size
  NSPAIRA(_ZTI8S7368C67),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C67),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C67),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C74  : virtual S7368C3 {
  ::S7368C7 s7368c74f0;
  ::S7368C11 s7368c74f1;
  virtual  ~S7368C74(); // _ZN8S7368C74D2Ev
  S7368C74(); // tgen
};
//SIG(-1 S7368C74) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC6 FC10}


 S7368C74 ::~S7368C74(){ note_dtor("S7368C74", this);}
S7368C74 ::S7368C74(){ note_ctor("S7368C74", this);} // tgen

static void Test_S7368C74()
{
  extern Class_Descriptor cd_S7368C74;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,125)];
    init_test(&cd_S7368C74, buf);
    S7368C74 *dp, &lv = *(dp=new (buf) S7368C74());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,496), "sizeof(S7368C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C74)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(232,164), "S7368C74");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(232,164), "S7368C74");
    check_field_offset(lv, s7368c74f0, ABISELECT(8,4), "S7368C74.s7368c74f0");
    check_field_offset(lv, s7368c74f1, ABISELECT(200,140), "S7368C74.s7368c74f1");
    test_class_info(&lv, &cd_S7368C74);
    dp->~S7368C74();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C74(Test_S7368C74, "S7368C74", ABISELECT(728,496));

#else // __cplusplus

extern void _ZN8S7368C74C1Ev();
extern void _ZN8S7368C74D2Ev();
Name_Map name_map_S7368C74[] = {
  NSPAIR(_ZN8S7368C74C1Ev),
  NSPAIR(_ZN8S7368C74D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C74[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(232,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(232,164), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C74[];
extern void _ZN8S7368C74D1Ev();
extern void _ZN8S7368C74D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev)();
extern void ABISELECT(_ZThn232_N8S7368C74D1Ev,_ZThn164_N8S7368C74D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev)();
extern void ABISELECT(_ZThn232_N8S7368C74D0Ev,_ZThn164_N8S7368C74D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C74[] = {
  ABISELECT(232,164),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C74[0]),
  (VTBL_ENTRY)&_ZN8S7368C74D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C74D0Ev,
  ABISELECT(-232,-164),
  ABISELECT(-232,-164),
  (VTBL_ENTRY)&(_ZTI8S7368C74[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C74[];
static  VTT_ENTRY vtt_S7368C74[] = {
  {&(_ZTV8S7368C74[3]),  3,10},
  {&(_ZTV8S7368C74[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C74[];
extern  VTBL_ENTRY _ZTV8S7368C74[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C74[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7368C74D0Ev,_ZThn164_N8S7368C74D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N8S7368C74D1Ev,_ZThn164_N8S7368C74D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C74 = {  "S7368C74", // class name
  bases_S7368C74, 2,
  &(vtc_S7368C74[0]), // expected_vtbl_contents
  &(vtt_S7368C74[0]), // expected_vtt_contents
  ABISELECT(728,496), // object size
  NSPAIRA(_ZTI8S7368C74),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C74),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C74),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C75  : virtual S7368C3 {
  virtual  ~S7368C75(); // _ZN8S7368C75D2Ev
  S7368C75(); // tgen
};
//SIG(-1 S7368C75) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd}


 S7368C75 ::~S7368C75(){ note_dtor("S7368C75", this);}
S7368C75 ::S7368C75(){ note_ctor("S7368C75", this);} // tgen

static void Test_S7368C75()
{
  extern Class_Descriptor cd_S7368C75;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(64,85)];
    init_test(&cd_S7368C75, buf);
    S7368C75 *dp, &lv = *(dp=new (buf) S7368C75());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(504,336), "sizeof(S7368C75)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C75)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(8,4), "S7368C75");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(8,4), "S7368C75");
    test_class_info(&lv, &cd_S7368C75);
    dp->~S7368C75();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C75(Test_S7368C75, "S7368C75", ABISELECT(504,336));

#else // __cplusplus

extern void _ZN8S7368C75C1Ev();
extern void _ZN8S7368C75D2Ev();
Name_Map name_map_S7368C75[] = {
  NSPAIR(_ZN8S7368C75C1Ev),
  NSPAIR(_ZN8S7368C75D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C75[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C75[];
extern void _ZN8S7368C75D1Ev();
extern void _ZN8S7368C75D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev)();
extern void ABISELECT(_ZThn8_N8S7368C75D1Ev,_ZThn4_N8S7368C75D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev)();
extern void ABISELECT(_ZThn8_N8S7368C75D0Ev,_ZThn4_N8S7368C75D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C75[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C75[0]),
  (VTBL_ENTRY)&_ZN8S7368C75D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C75D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7368C75[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C75[];
static  VTT_ENTRY vtt_S7368C75[] = {
  {&(_ZTV8S7368C75[3]),  3,10},
  {&(_ZTV8S7368C75[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C75[];
extern  VTBL_ENTRY _ZTV8S7368C75[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C75[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S7368C75D0Ev,_ZThn4_N8S7368C75D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S7368C75D1Ev,_ZThn4_N8S7368C75D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C75 = {  "S7368C75", // class name
  bases_S7368C75, 2,
  &(vtc_S7368C75[0]), // expected_vtbl_contents
  &(vtt_S7368C75[0]), // expected_vtt_contents
  ABISELECT(504,336), // object size
  NSPAIRA(_ZTI8S7368C75),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C75),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C75),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C78  {
  void  mf7368c78(); // _ZN8S7368C789mf7368c78Ev
};
//SIG(-1 S7368C78) C1{ m}


void  S7368C78 ::mf7368c78(){}

static void Test_S7368C78()
{
  {
    init_simple_test("S7368C78");
    S7368C78 lv;
    check2(sizeof(lv), 1, "sizeof(S7368C78)");
    check2(__alignof__(lv), 1, "__alignof__(S7368C78)");
  }
}
static Arrange_To_Call_Me vS7368C78(Test_S7368C78, "S7368C78", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S7368C78[];
VTBL_ENTRY *P__ZTI8S7368C78 = _ZTI8S7368C78; 
Class_Descriptor cd_S7368C78 = {  "S7368C78", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S7368C78),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C77  {
  void *s7368c77f0;
  int s7368c77f1[2];
  ::S7368C78 s7368c77f2;
  void  mf7368c77(); // _ZN8S7368C779mf7368c77Ev
};
//SIG(-1 S7368C77) C1{ m Fp Fi[2] FC2{ m}}


void  S7368C77 ::mf7368c77(){}

static void Test_S7368C77()
{
  {
    init_simple_test("S7368C77");
    S7368C77 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S7368C77)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C77)");
    check_field_offset(lv, s7368c77f0, 0, "S7368C77.s7368c77f0");
    check_field_offset(lv, s7368c77f1, ABISELECT(8,4), "S7368C77.s7368c77f1");
    check_field_offset(lv, s7368c77f2, ABISELECT(16,12), "S7368C77.s7368c77f2");
  }
}
static Arrange_To_Call_Me vS7368C77(Test_S7368C77, "S7368C77", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C76  : virtual S7368C3 {
  ::S7368C32 s7368c76f0;
  ::S7368C77 s7368c76f1;
  int s7368c76f2;
  ::S7368C32 s7368c76f3;
  virtual  ~S7368C76(); // _ZN8S7368C76D2Ev
  S7368C76(); // tgen
};
//SIG(-1 S7368C76) C1{ VBC2{ BC3{ vd m FC4{ m Fp Fi[2] FC5{ m}}} vd Fp[10] FC6{ BC7{ vd m Fc} vd Fi FC8{ m Fp Fi FC9{ m}} FC10{ BC7 vd FL[2]} FC8 FC11{ BC7 vd FC8 FC8 FC8 FC4 FC12{ m Fp Fi[2] FC9}}} FC6} vd FC13{ vd m FC14{ BC7 vd FL} FC6} FC15{ m Fp Fi[2] FC16{ m}} Fi FC13}


 S7368C76 ::~S7368C76(){ note_dtor("S7368C76", this);}
S7368C76 ::S7368C76(){ note_ctor("S7368C76", this);} // tgen

static void Test_S7368C76()
{
  extern Class_Descriptor cd_S7368C76;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(124,168)];
    init_test(&cd_S7368C76, buf);
    S7368C76 *dp, &lv = *(dp=new (buf) S7368C76());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(984,668), "sizeof(S7368C76)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C76)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(488,336), "S7368C76");
    check_base_class_offset(lv, (S7368C3*), ABISELECT(488,336), "S7368C76");
    check_field_offset(lv, s7368c76f0, ABISELECT(8,4), "S7368C76.s7368c76f0");
    check_field_offset(lv, s7368c76f1, ABISELECT(232,160), "S7368C76.s7368c76f1");
    check_field_offset(lv, s7368c76f2, ABISELECT(256,176), "S7368C76.s7368c76f2");
    check_field_offset(lv, s7368c76f3, ABISELECT(264,180), "S7368C76.s7368c76f3");
    test_class_info(&lv, &cd_S7368C76);
    dp->~S7368C76();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C76(Test_S7368C76, "S7368C76", ABISELECT(984,668));

#else // __cplusplus

extern void _ZN8S7368C76C1Ev();
extern void _ZN8S7368C76D2Ev();
Name_Map name_map_S7368C76[] = {
  NSPAIR(_ZN8S7368C76C1Ev),
  NSPAIR(_ZN8S7368C76D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
static Base_Class bases_S7368C76[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(488,336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(488,336), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7368C76[];
extern void _ZN8S7368C76D1Ev();
extern void _ZN8S7368C76D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev)();
extern void ABISELECT(_ZThn488_N8S7368C76D1Ev,_ZThn336_N8S7368C76D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev)();
extern void ABISELECT(_ZThn488_N8S7368C76D0Ev,_ZThn336_N8S7368C76D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C76[] = {
  ABISELECT(488,336),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C76[0]),
  (VTBL_ENTRY)&_ZN8S7368C76D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C76D0Ev,
  ABISELECT(-488,-336),
  ABISELECT(-488,-336),
  (VTBL_ENTRY)&(_ZTI8S7368C76[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev),
};
extern VTBL_ENTRY _ZTV8S7368C76[];
static  VTT_ENTRY vtt_S7368C76[] = {
  {&(_ZTV8S7368C76[3]),  3,10},
  {&(_ZTV8S7368C76[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S7368C76[];
extern  VTBL_ENTRY _ZTV8S7368C76[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C76[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S7368C76D0Ev,_ZThn336_N8S7368C76D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S7368C76D1Ev,_ZThn336_N8S7368C76D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C76 = {  "S7368C76", // class name
  bases_S7368C76, 2,
  &(vtc_S7368C76[0]), // expected_vtbl_contents
  &(vtt_S7368C76[0]), // expected_vtt_contents
  ABISELECT(984,668), // object size
  NSPAIRA(_ZTI8S7368C76),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7368C76),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7368C76),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7368C1  : S7368C2 , S7368C39 , S7368C52 , S7368C61 , S7368C62 , S7368C67 , S7368C74 , S7368C75 , S7368C76 {
  virtual  ~S7368C1(); // _ZN7S7368C1D2Ev
  S7368C1(); // tgen
};
//SIG(1 S7368C1) C1{ BC2{ VBC3{ BC4{ vd m FC5{ m Fp Fi[2] FC6{ m}}} vd Fp[10] FC7{ BC8{ vd m Fc} vd Fi FC9{ m Fp Fi FC10{ m}} FC11{ BC8 vd FL[2]} FC9 FC12{ BC8 vd FC9 FC9 FC9 FC5 FC13{ m Fp Fi[2] FC10}}} FC7} vd FC14{ BC15{ vd m Fp} vd FC13 Fp Fi} FC16{ m Fp Fi[2] FC17{ m}} Fi FC16 FC16 FC18{ BC8 vd FC11 FC11} FC19{ vd m Fi FC20{ vd m FC21{ Fi Fp[7] Fs Fc[10]} Fp Fc[2] FC22{ m FC9 FC9}} FC23{ vd m FC24{ BC8 vd FL} FC7} FC25{ BC8 vd FC24 Fi FC26{ vd m FC9 FC11} FC26 Fi FC9 FC9 Fi FC26 FC26} FC27{ BC8 vd Fi[2] FC11 FC9 FC28{ BC8 vd FC9 FC11} FC29{ BC8 vd FC9 FC9 Fi}}} FC20 FC9 FC11} BC30{ VBC3 vd FC31{ vd m FC9 FC11 Fi[2]} FC31 FC32{ vd m FC33{ m Fp Fi[2] FC17} FC18 FC13} FC34{ vd m FC33 FC18} FC34 FC35{ vd m FC9} FC36{ vd m FC9 FC9 FC9 FC11 FC18 FC9 FC5 FC9 FC13} FC37{ vd m FC38{ m Fp Fi[2] FC39{ m}}} Fi FC25 FC23} BC40{ VBC3 vd FC41{ vd m FC9 FC9 FC11 FC11 Fi Fc FC9} FC42{ vd m FC43{ vd m Fi FC9 FC7 FC7 FL[2] Fl FC9 Fl FC9 FC38 FC13 FC13} FC13 Fi FC44{ m Fp Fi[2] FC39}} FC33 Fi FC45{ BC15 vd Fp FC9} Fi} BC46{ VBC3 vd} BC47{ VBC3 vd FC48{ vd m FC9 Fi FC11} FC49{ vd m FC11 FC9 Fi FC9 FC44 Fi} FC49 Fi[2]} BC50{ VBC3 vd FC51{ BC15 vd Fi FC9 Fp FC52{ m FC53{ m FL[2]}} Fc} FC54{ BC15 vd FC55{ vd m Fi[2]} Fi} Fc FC56{ BC15 vd Fi[2]}} BC57{ VBC3 vd FC7 FC11} BC58{ VBC3 vd} BC59{ VBC3 vd FC23 FC60{ m Fp Fi[2] FC61{ m}} Fi FC23} vd}


 S7368C1 ::~S7368C1(){ note_dtor("S7368C1", this);}
S7368C1 ::S7368C1(){ note_ctor("S7368C1", this);} // tgen

static void Test_S7368C1()
{
  extern Class_Descriptor cd_S7368C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(647,879)];
    init_test(&cd_S7368C1, buf);
    S7368C1 *dp, &lv = *(dp=new (buf) S7368C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5168,3512), "sizeof(S7368C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7368C1)");
    check_base_class_offset(lv, (S7368C4_nt*)(S7368C3*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C2*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C39*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C52*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C61*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C62*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C67*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C74*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C75*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C3*)(S7368C76*), ABISELECT(4672,3180), "S7368C1");
    check_base_class_offset(lv, (S7368C2*), 0, "S7368C1");
    check_base_class_offset(lv, (S7368C39*), ABISELECT(1296,856), "S7368C1");
    check_base_class_offset(lv, (S7368C52*), ABISELECT(2648,1792), "S7368C1");
    check_base_class_offset(lv, (S7368C61*), ABISELECT(3480,2368), "S7368C1");
    check_base_class_offset(lv, (S7368C62*), ABISELECT(3488,2372), "S7368C1");
    check_base_class_offset(lv, (S7368C67*), ABISELECT(3792,2580), "S7368C1");
    check_base_class_offset(lv, (S7368C74*), ABISELECT(3944,2676), "S7368C1");
    check_base_class_offset(lv, (S7368C75*), ABISELECT(4176,2840), "S7368C1");
    check_base_class_offset(lv, (S7368C76*), ABISELECT(4184,2844), "S7368C1");
    test_class_info(&lv, &cd_S7368C1);
    dp->~S7368C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7368C1(Test_S7368C1, "S7368C1", ABISELECT(5168,3512));

#else // __cplusplus

extern void _ZN7S7368C1C1Ev();
extern void _ZN7S7368C1D2Ev();
Name_Map name_map_S7368C1[] = {
  NSPAIR(_ZN7S7368C1C1Ev),
  NSPAIR(_ZN7S7368C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7368C4_nt;
extern VTBL_ENTRY _ZTI10S7368C4_nt[];
extern  VTBL_ENTRY _ZTV10S7368C4_nt[];
extern Class_Descriptor cd_S7368C3;
extern VTBL_ENTRY _ZTI7S7368C3[];
extern  VTBL_ENTRY _ZTV7S7368C3[];
extern Class_Descriptor cd_S7368C2;
extern VTBL_ENTRY _ZTI7S7368C2[];
extern  VTBL_ENTRY _ZTV7S7368C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7368C2[];
extern Class_Descriptor cd_S7368C39;
extern VTBL_ENTRY _ZTI8S7368C39[];
extern  VTBL_ENTRY _ZTV8S7368C39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C39[];
extern Class_Descriptor cd_S7368C52;
extern VTBL_ENTRY _ZTI8S7368C52[];
extern  VTBL_ENTRY _ZTV8S7368C52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C52[];
extern Class_Descriptor cd_S7368C61;
extern VTBL_ENTRY _ZTI8S7368C61[];
extern  VTBL_ENTRY _ZTV8S7368C61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C61[];
extern Class_Descriptor cd_S7368C62;
extern VTBL_ENTRY _ZTI8S7368C62[];
extern  VTBL_ENTRY _ZTV8S7368C62[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C62[];
extern Class_Descriptor cd_S7368C67;
extern VTBL_ENTRY _ZTI8S7368C67[];
extern  VTBL_ENTRY _ZTV8S7368C67[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C67[];
extern Class_Descriptor cd_S7368C74;
extern VTBL_ENTRY _ZTI8S7368C74[];
extern  VTBL_ENTRY _ZTV8S7368C74[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C74[];
extern Class_Descriptor cd_S7368C75;
extern VTBL_ENTRY _ZTI8S7368C75[];
extern  VTBL_ENTRY _ZTV8S7368C75[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C75[];
extern Class_Descriptor cd_S7368C76;
extern VTBL_ENTRY _ZTI8S7368C76[];
extern  VTBL_ENTRY _ZTV8S7368C76[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7368C76[];
static Base_Class bases_S7368C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7368C4_nt,    ABISELECT(4672,3180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S7368C3,    ABISELECT(4672,3180), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7368C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C39,    ABISELECT(1296,856), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C52,    ABISELECT(2648,1792), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C61,    ABISELECT(3480,2368), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C62,    ABISELECT(3488,2372), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C67,    ABISELECT(3792,2580), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C74,    ABISELECT(3944,2676), //bcp->offset
    30, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C75,    ABISELECT(4176,2840), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7368C76,    ABISELECT(4184,2844), //bcp->offset
    40, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7368C1[];
extern void _ZN7S7368C1D1Ev();
extern void _ZN7S7368C1D0Ev();
extern void ABISELECT(_ZThn1296_N7S7368C1D1Ev,_ZThn856_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn1296_N7S7368C1D0Ev,_ZThn856_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn2648_N7S7368C1D1Ev,_ZThn1792_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn2648_N7S7368C1D0Ev,_ZThn1792_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn3480_N7S7368C1D1Ev,_ZThn2368_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn3480_N7S7368C1D0Ev,_ZThn2368_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn3488_N7S7368C1D1Ev,_ZThn2372_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn3488_N7S7368C1D0Ev,_ZThn2372_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn3792_N7S7368C1D1Ev,_ZThn2580_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn3792_N7S7368C1D0Ev,_ZThn2580_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn3944_N7S7368C1D1Ev,_ZThn2676_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn3944_N7S7368C1D0Ev,_ZThn2676_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn4176_N7S7368C1D1Ev,_ZThn2840_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn4176_N7S7368C1D0Ev,_ZThn2840_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn4184_N7S7368C1D1Ev,_ZThn2844_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn4184_N7S7368C1D0Ev,_ZThn2844_N7S7368C1D0Ev)();
extern void ABISELECT(_ZTv0_n24_N7S7368C1D1Ev,_ZTv0_n12_N7S7368C1D1Ev)();
extern void ABISELECT(_ZThn4672_N7S7368C1D1Ev,_ZThn3180_N7S7368C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7368C1D0Ev,_ZTv0_n12_N7S7368C1D0Ev)();
extern void ABISELECT(_ZThn4672_N7S7368C1D0Ev,_ZThn3180_N7S7368C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7368C1[] = {
  ABISELECT(4672,3180),
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&_ZN7S7368C1D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C1D0Ev,
  ABISELECT(3376,2324),
  ABISELECT(-1296,-856),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N7S7368C1D1Ev,_ZThn856_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1296_N7S7368C1D0Ev,_ZThn856_N7S7368C1D0Ev),
  ABISELECT(2024,1388),
  ABISELECT(-2648,-1792),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2648_N7S7368C1D1Ev,_ZThn1792_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2648_N7S7368C1D0Ev,_ZThn1792_N7S7368C1D0Ev),
  ABISELECT(1192,812),
  ABISELECT(-3480,-2368),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3480_N7S7368C1D1Ev,_ZThn2368_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3480_N7S7368C1D0Ev,_ZThn2368_N7S7368C1D0Ev),
  ABISELECT(1184,808),
  ABISELECT(-3488,-2372),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3488_N7S7368C1D1Ev,_ZThn2372_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3488_N7S7368C1D0Ev,_ZThn2372_N7S7368C1D0Ev),
  ABISELECT(880,600),
  ABISELECT(-3792,-2580),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3792_N7S7368C1D1Ev,_ZThn2580_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3792_N7S7368C1D0Ev,_ZThn2580_N7S7368C1D0Ev),
  ABISELECT(728,504),
  ABISELECT(-3944,-2676),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3944_N7S7368C1D1Ev,_ZThn2676_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3944_N7S7368C1D0Ev,_ZThn2676_N7S7368C1D0Ev),
  ABISELECT(496,340),
  ABISELECT(-4176,-2840),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn4176_N7S7368C1D1Ev,_ZThn2840_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4176_N7S7368C1D0Ev,_ZThn2840_N7S7368C1D0Ev),
  ABISELECT(488,336),
  ABISELECT(-4184,-2844),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn4184_N7S7368C1D1Ev,_ZThn2844_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4184_N7S7368C1D0Ev,_ZThn2844_N7S7368C1D0Ev),
  ABISELECT(-4672,-3180),
  ABISELECT(-4672,-3180),
  (VTBL_ENTRY)&(_ZTI7S7368C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C1D1Ev,_ZTv0_n12_N7S7368C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C1D0Ev,_ZTv0_n12_N7S7368C1D0Ev),
};
extern VTBL_ENTRY _ZTV7S7368C1[];
extern void _ZN7S7368C2D1Ev();
extern void _ZN7S7368C2D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7368C2__7S7368C1[] = {
  ABISELECT(4672,3180),
  0,
  (VTBL_ENTRY)&(_ZTI7S7368C2[0]),
  (VTBL_ENTRY)&_ZN7S7368C2D1Ev,
  (VTBL_ENTRY)&_ZN7S7368C2D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev)();
extern void ABISELECT(_ZThn4672_N7S7368C2D1Ev,_ZThn3180_N7S7368C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev)();
extern void ABISELECT(_ZThn4672_N7S7368C2D0Ev,_ZThn3180_N7S7368C2D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__7S7368C2__7S7368C1[] = {
  ABISELECT(-4672,-3180),
  ABISELECT(-4672,-3180),
  (VTBL_ENTRY)&(_ZTI7S7368C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev),
};
extern void _ZN8S7368C39D1Ev();
extern void _ZN8S7368C39D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C39__7S7368C1[] = {
  ABISELECT(3376,2324),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C39[0]),
  (VTBL_ENTRY)&_ZN8S7368C39D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C39D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev)();
extern void ABISELECT(_ZThn3376_N8S7368C39D1Ev,_ZThn2324_N8S7368C39D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev)();
extern void ABISELECT(_ZThn3376_N8S7368C39D0Ev,_ZThn2324_N8S7368C39D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C39__7S7368C1[] = {
  ABISELECT(-3376,-2324),
  ABISELECT(-3376,-2324),
  (VTBL_ENTRY)&(_ZTI8S7368C39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev),
};
extern void _ZN8S7368C52D1Ev();
extern void _ZN8S7368C52D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C52__7S7368C1[] = {
  ABISELECT(2024,1388),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C52[0]),
  (VTBL_ENTRY)&_ZN8S7368C52D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C52D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev)();
extern void ABISELECT(_ZThn2024_N8S7368C52D1Ev,_ZThn1388_N8S7368C52D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev)();
extern void ABISELECT(_ZThn2024_N8S7368C52D0Ev,_ZThn1388_N8S7368C52D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C52__7S7368C1[] = {
  ABISELECT(-2024,-1388),
  ABISELECT(-2024,-1388),
  (VTBL_ENTRY)&(_ZTI8S7368C52[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev),
};
extern void _ZN8S7368C61D1Ev();
extern void _ZN8S7368C61D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C61__7S7368C1[] = {
  ABISELECT(1192,812),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C61[0]),
  (VTBL_ENTRY)&_ZN8S7368C61D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C61D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev)();
extern void ABISELECT(_ZThn1192_N8S7368C61D1Ev,_ZThn812_N8S7368C61D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev)();
extern void ABISELECT(_ZThn1192_N8S7368C61D0Ev,_ZThn812_N8S7368C61D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C61__7S7368C1[] = {
  ABISELECT(-1192,-812),
  ABISELECT(-1192,-812),
  (VTBL_ENTRY)&(_ZTI8S7368C61[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev),
};
extern void _ZN8S7368C62D1Ev();
extern void _ZN8S7368C62D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C62__7S7368C1[] = {
  ABISELECT(1184,808),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C62[0]),
  (VTBL_ENTRY)&_ZN8S7368C62D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C62D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev)();
extern void ABISELECT(_ZThn1184_N8S7368C62D1Ev,_ZThn808_N8S7368C62D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev)();
extern void ABISELECT(_ZThn1184_N8S7368C62D0Ev,_ZThn808_N8S7368C62D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C62__7S7368C1[] = {
  ABISELECT(-1184,-808),
  ABISELECT(-1184,-808),
  (VTBL_ENTRY)&(_ZTI8S7368C62[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev),
};
extern void _ZN8S7368C67D1Ev();
extern void _ZN8S7368C67D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C67__7S7368C1[] = {
  ABISELECT(880,600),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C67[0]),
  (VTBL_ENTRY)&_ZN8S7368C67D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C67D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev)();
extern void ABISELECT(_ZThn880_N8S7368C67D1Ev,_ZThn600_N8S7368C67D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev)();
extern void ABISELECT(_ZThn880_N8S7368C67D0Ev,_ZThn600_N8S7368C67D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C67__7S7368C1[] = {
  ABISELECT(-880,-600),
  ABISELECT(-880,-600),
  (VTBL_ENTRY)&(_ZTI8S7368C67[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev),
};
extern void _ZN8S7368C74D1Ev();
extern void _ZN8S7368C74D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C74__7S7368C1[] = {
  ABISELECT(728,504),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C74[0]),
  (VTBL_ENTRY)&_ZN8S7368C74D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C74D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev)();
extern void ABISELECT(_ZThn728_N8S7368C74D1Ev,_ZThn504_N8S7368C74D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev)();
extern void ABISELECT(_ZThn728_N8S7368C74D0Ev,_ZThn504_N8S7368C74D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C74__7S7368C1[] = {
  ABISELECT(-728,-504),
  ABISELECT(-728,-504),
  (VTBL_ENTRY)&(_ZTI8S7368C74[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev),
};
extern void _ZN8S7368C75D1Ev();
extern void _ZN8S7368C75D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C75__7S7368C1[] = {
  ABISELECT(496,340),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C75[0]),
  (VTBL_ENTRY)&_ZN8S7368C75D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C75D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev)();
extern void ABISELECT(_ZThn496_N8S7368C75D1Ev,_ZThn340_N8S7368C75D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev)();
extern void ABISELECT(_ZThn496_N8S7368C75D0Ev,_ZThn340_N8S7368C75D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C75__7S7368C1[] = {
  ABISELECT(-496,-340),
  ABISELECT(-496,-340),
  (VTBL_ENTRY)&(_ZTI8S7368C75[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev),
};
extern void _ZN8S7368C76D1Ev();
extern void _ZN8S7368C76D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7368C76__7S7368C1[] = {
  ABISELECT(488,336),
  0,
  (VTBL_ENTRY)&(_ZTI8S7368C76[0]),
  (VTBL_ENTRY)&_ZN8S7368C76D1Ev,
  (VTBL_ENTRY)&_ZN8S7368C76D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev)();
extern void ABISELECT(_ZThn488_N8S7368C76D1Ev,_ZThn336_N8S7368C76D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev)();
extern void ABISELECT(_ZThn488_N8S7368C76D0Ev,_ZThn336_N8S7368C76D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S7368C3__8S7368C76__7S7368C1[] = {
  ABISELECT(-488,-336),
  ABISELECT(-488,-336),
  (VTBL_ENTRY)&(_ZTI8S7368C76[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev),
};
static  VTT_ENTRY vtt_S7368C1[] = {
  {&(_ZTV7S7368C1[3]),  3,50},
  {&(_tg__ZTV7S7368C2__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__7S7368C2__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C39__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C39__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C52__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C52__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C61__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C61__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C62__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C62__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C67__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C67__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C74__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C74__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C75__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C75__7S7368C1[3]),  3,5},
  {&(_tg__ZTV8S7368C76__7S7368C1[3]),  3,5},
  {&(_tg__ZTV7S7368C3__8S7368C76__7S7368C1[3]),  3,5},
  {&(_ZTV7S7368C1[48]),  48,50},
  {&(_ZTV7S7368C1[8]),  8,50},
  {&(_ZTV7S7368C1[13]),  13,50},
  {&(_ZTV7S7368C1[18]),  18,50},
  {&(_ZTV7S7368C1[23]),  23,50},
  {&(_ZTV7S7368C1[28]),  28,50},
  {&(_ZTV7S7368C1[33]),  33,50},
  {&(_ZTV7S7368C1[38]),  38,50},
  {&(_ZTV7S7368C1[43]),  43,50},
};
extern VTBL_ENTRY _ZTI7S7368C1[];
extern  VTBL_ENTRY _ZTV7S7368C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7368C1[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C76D0Ev,_ZTv0_n12_N8S7368C76D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S7368C76D0Ev,_ZThn336_N8S7368C76D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C76D1Ev,_ZTv0_n12_N8S7368C76D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S7368C76D1Ev,_ZThn336_N8S7368C76D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C75D0Ev,_ZTv0_n12_N8S7368C75D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S7368C75D0Ev,_ZThn340_N8S7368C75D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C75D1Ev,_ZTv0_n12_N8S7368C75D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S7368C75D1Ev,_ZThn340_N8S7368C75D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C74D0Ev,_ZTv0_n12_N8S7368C74D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S7368C74D0Ev,_ZThn504_N8S7368C74D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C74D1Ev,_ZTv0_n12_N8S7368C74D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S7368C74D1Ev,_ZThn504_N8S7368C74D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C67D0Ev,_ZTv0_n12_N8S7368C67D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S7368C67D0Ev,_ZThn600_N8S7368C67D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C67D1Ev,_ZTv0_n12_N8S7368C67D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S7368C67D1Ev,_ZThn600_N8S7368C67D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C62D0Ev,_ZTv0_n12_N8S7368C62D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N8S7368C62D0Ev,_ZThn808_N8S7368C62D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C62D1Ev,_ZTv0_n12_N8S7368C62D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N8S7368C62D1Ev,_ZThn808_N8S7368C62D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C61D0Ev,_ZTv0_n12_N8S7368C61D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1192_N8S7368C61D0Ev,_ZThn812_N8S7368C61D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C61D1Ev,_ZTv0_n12_N8S7368C61D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1192_N8S7368C61D1Ev,_ZThn812_N8S7368C61D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C52D0Ev,_ZTv0_n12_N8S7368C52D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2024_N8S7368C52D0Ev,_ZThn1388_N8S7368C52D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C52D1Ev,_ZTv0_n12_N8S7368C52D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2024_N8S7368C52D1Ev,_ZThn1388_N8S7368C52D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C39D0Ev,_ZTv0_n12_N8S7368C39D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3376_N8S7368C39D0Ev,_ZThn2324_N8S7368C39D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S7368C39D1Ev,_ZTv0_n12_N8S7368C39D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3376_N8S7368C39D1Ev,_ZThn2324_N8S7368C39D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C2D0Ev,_ZTv0_n12_N7S7368C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N7S7368C2D0Ev,_ZThn3180_N7S7368C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C2D1Ev,_ZTv0_n12_N7S7368C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N7S7368C2D1Ev,_ZThn3180_N7S7368C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C1D0Ev,_ZTv0_n12_N7S7368C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N7S7368C1D0Ev,_ZThn3180_N7S7368C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S7368C1D1Ev,_ZTv0_n12_N7S7368C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N7S7368C1D1Ev,_ZThn3180_N7S7368C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7368C1 = {  "S7368C1", // class name
  bases_S7368C1, 11,
  &(vtc_S7368C1[0]), // expected_vtbl_contents
  &(vtt_S7368C1[0]), // expected_vtt_contents
  ABISELECT(5168,3512), // object size
  NSPAIRA(_ZTI7S7368C1),ABISELECT(168,88), //typeinfo_var
  NSPAIRA(_ZTV7S7368C1),50, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7368C1),28, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C2_nt  {
  virtual  ~S10256C2_nt(); // _ZN11S10256C2_ntD1Ev
  virtual void  v81(); // _ZN11S10256C2_nt3v81Ev
  virtual void  v82(); // _ZN11S10256C2_nt3v82Ev
  virtual void  v83(); // _ZN11S10256C2_nt3v83Ev
  virtual void  v84(); // _ZN11S10256C2_nt3v84Ev
  virtual void  v85(); // _ZN11S10256C2_nt3v85Ev
  virtual void  v86(); // _ZN11S10256C2_nt3v86Ev
  virtual void  v87(); // _ZN11S10256C2_nt3v87Ev
  virtual void  v88(); // _ZN11S10256C2_nt3v88Ev
  virtual void  v89(); // _ZN11S10256C2_nt3v89Ev
  virtual void  v90(); // _ZN11S10256C2_nt3v90Ev
  virtual void  v91(); // _ZN11S10256C2_nt3v91Ev
  virtual void  v92(); // _ZN11S10256C2_nt3v92Ev
  virtual void  v93(); // _ZN11S10256C2_nt3v93Ev
  virtual void  v94(); // _ZN11S10256C2_nt3v94Ev
  virtual void  v95(); // _ZN11S10256C2_nt3v95Ev
  virtual void  v96(); // _ZN11S10256C2_nt3v96Ev
  virtual void  v97(); // _ZN11S10256C2_nt3v97Ev
  virtual void  v98(); // _ZN11S10256C2_nt3v98Ev
  virtual void  v99(); // _ZN11S10256C2_nt3v99Ev
  virtual void  v100(); // _ZN11S10256C2_nt4v100Ev
  virtual void  v101(); // _ZN11S10256C2_nt4v101Ev
  virtual void  v102(); // _ZN11S10256C2_nt4v102Ev
  virtual void  v103(); // _ZN11S10256C2_nt4v103Ev
  virtual void  v104(); // _ZN11S10256C2_nt4v104Ev
  virtual void  v105(); // _ZN11S10256C2_nt4v105Ev
  virtual void  v106(); // _ZN11S10256C2_nt4v106Ev
  virtual void  v107(); // _ZN11S10256C2_nt4v107Ev
  virtual void  v108(); // _ZN11S10256C2_nt4v108Ev
  virtual void  v109(); // _ZN11S10256C2_nt4v109Ev
  virtual void  v110(); // _ZN11S10256C2_nt4v110Ev
  virtual void  v111(); // _ZN11S10256C2_nt4v111Ev
  virtual void  v112(); // _ZN11S10256C2_nt4v112Ev
  virtual void  v113(); // _ZN11S10256C2_nt4v113Ev
  virtual void  v114(); // _ZN11S10256C2_nt4v114Ev
  virtual void  v115(); // _ZN11S10256C2_nt4v115Ev
  virtual void  v116(); // _ZN11S10256C2_nt4v116Ev
  virtual void  v117(); // _ZN11S10256C2_nt4v117Ev
  virtual void  v118(); // _ZN11S10256C2_nt4v118Ev
  virtual void  v119(); // _ZN11S10256C2_nt4v119Ev
  virtual void  v120(); // _ZN11S10256C2_nt4v120Ev
  virtual void  v121(); // _ZN11S10256C2_nt4v121Ev
  virtual void  v122(); // _ZN11S10256C2_nt4v122Ev
  virtual void  v123(); // _ZN11S10256C2_nt4v123Ev
  virtual void  v124(); // _ZN11S10256C2_nt4v124Ev
  virtual void  v125(); // _ZN11S10256C2_nt4v125Ev
  virtual void  v126(); // _ZN11S10256C2_nt4v126Ev
  virtual void  v127(); // _ZN11S10256C2_nt4v127Ev
  virtual void  v128(); // _ZN11S10256C2_nt4v128Ev
  virtual void  v129(); // _ZN11S10256C2_nt4v129Ev
  virtual void  v130(); // _ZN11S10256C2_nt4v130Ev
  virtual void  v131(); // _ZN11S10256C2_nt4v131Ev
  virtual void  v132(); // _ZN11S10256C2_nt4v132Ev
  virtual void  v133(); // _ZN11S10256C2_nt4v133Ev
  virtual void  v134(); // _ZN11S10256C2_nt4v134Ev
  virtual void  v135(); // _ZN11S10256C2_nt4v135Ev
  virtual void  v136(); // _ZN11S10256C2_nt4v136Ev
  virtual void  v137(); // _ZN11S10256C2_nt4v137Ev
  virtual void  v138(); // _ZN11S10256C2_nt4v138Ev
  virtual void  v139(); // _ZN11S10256C2_nt4v139Ev
  virtual void  v140(); // _ZN11S10256C2_nt4v140Ev
  virtual void  v141(); // _ZN11S10256C2_nt4v141Ev
  virtual void  v142(); // _ZN11S10256C2_nt4v142Ev
  virtual void  v143(); // _ZN11S10256C2_nt4v143Ev
  virtual void  v144(); // _ZN11S10256C2_nt4v144Ev
  virtual void  v145(); // _ZN11S10256C2_nt4v145Ev
  virtual void  v146(); // _ZN11S10256C2_nt4v146Ev
  virtual void  v147(); // _ZN11S10256C2_nt4v147Ev
  virtual void  v148(); // _ZN11S10256C2_nt4v148Ev
  virtual void  v149(); // _ZN11S10256C2_nt4v149Ev
  virtual void  v150(); // _ZN11S10256C2_nt4v150Ev
  virtual void  v151(); // _ZN11S10256C2_nt4v151Ev
  virtual void  v152(); // _ZN11S10256C2_nt4v152Ev
  virtual void  v153(); // _ZN11S10256C2_nt4v153Ev
  virtual void  v154(); // _ZN11S10256C2_nt4v154Ev
  virtual void  v155(); // _ZN11S10256C2_nt4v155Ev
  virtual void  v156(); // _ZN11S10256C2_nt4v156Ev
  virtual void  v157(); // _ZN11S10256C2_nt4v157Ev
  virtual void  v158(); // _ZN11S10256C2_nt4v158Ev
  virtual void  v159(); // _ZN11S10256C2_nt4v159Ev
  virtual void  v160(); // _ZN11S10256C2_nt4v160Ev
  S10256C2_nt(); // tgen
};
//SIG(-1 S10256C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S10256C2_nt ::~S10256C2_nt(){ note_dtor("S10256C2_nt", this);}
void  S10256C2_nt ::v81(){vfunc_called(this, "_ZN11S10256C2_nt3v81Ev");}
void  S10256C2_nt ::v82(){vfunc_called(this, "_ZN11S10256C2_nt3v82Ev");}
void  S10256C2_nt ::v83(){vfunc_called(this, "_ZN11S10256C2_nt3v83Ev");}
void  S10256C2_nt ::v84(){vfunc_called(this, "_ZN11S10256C2_nt3v84Ev");}
void  S10256C2_nt ::v85(){vfunc_called(this, "_ZN11S10256C2_nt3v85Ev");}
void  S10256C2_nt ::v86(){vfunc_called(this, "_ZN11S10256C2_nt3v86Ev");}
void  S10256C2_nt ::v87(){vfunc_called(this, "_ZN11S10256C2_nt3v87Ev");}
void  S10256C2_nt ::v88(){vfunc_called(this, "_ZN11S10256C2_nt3v88Ev");}
void  S10256C2_nt ::v89(){vfunc_called(this, "_ZN11S10256C2_nt3v89Ev");}
void  S10256C2_nt ::v90(){vfunc_called(this, "_ZN11S10256C2_nt3v90Ev");}
void  S10256C2_nt ::v91(){vfunc_called(this, "_ZN11S10256C2_nt3v91Ev");}
void  S10256C2_nt ::v92(){vfunc_called(this, "_ZN11S10256C2_nt3v92Ev");}
void  S10256C2_nt ::v93(){vfunc_called(this, "_ZN11S10256C2_nt3v93Ev");}
void  S10256C2_nt ::v94(){vfunc_called(this, "_ZN11S10256C2_nt3v94Ev");}
void  S10256C2_nt ::v95(){vfunc_called(this, "_ZN11S10256C2_nt3v95Ev");}
void  S10256C2_nt ::v96(){vfunc_called(this, "_ZN11S10256C2_nt3v96Ev");}
void  S10256C2_nt ::v97(){vfunc_called(this, "_ZN11S10256C2_nt3v97Ev");}
void  S10256C2_nt ::v98(){vfunc_called(this, "_ZN11S10256C2_nt3v98Ev");}
void  S10256C2_nt ::v99(){vfunc_called(this, "_ZN11S10256C2_nt3v99Ev");}
void  S10256C2_nt ::v100(){vfunc_called(this, "_ZN11S10256C2_nt4v100Ev");}
void  S10256C2_nt ::v101(){vfunc_called(this, "_ZN11S10256C2_nt4v101Ev");}
void  S10256C2_nt ::v102(){vfunc_called(this, "_ZN11S10256C2_nt4v102Ev");}
void  S10256C2_nt ::v103(){vfunc_called(this, "_ZN11S10256C2_nt4v103Ev");}
void  S10256C2_nt ::v104(){vfunc_called(this, "_ZN11S10256C2_nt4v104Ev");}
void  S10256C2_nt ::v105(){vfunc_called(this, "_ZN11S10256C2_nt4v105Ev");}
void  S10256C2_nt ::v106(){vfunc_called(this, "_ZN11S10256C2_nt4v106Ev");}
void  S10256C2_nt ::v107(){vfunc_called(this, "_ZN11S10256C2_nt4v107Ev");}
void  S10256C2_nt ::v108(){vfunc_called(this, "_ZN11S10256C2_nt4v108Ev");}
void  S10256C2_nt ::v109(){vfunc_called(this, "_ZN11S10256C2_nt4v109Ev");}
void  S10256C2_nt ::v110(){vfunc_called(this, "_ZN11S10256C2_nt4v110Ev");}
void  S10256C2_nt ::v111(){vfunc_called(this, "_ZN11S10256C2_nt4v111Ev");}
void  S10256C2_nt ::v112(){vfunc_called(this, "_ZN11S10256C2_nt4v112Ev");}
void  S10256C2_nt ::v113(){vfunc_called(this, "_ZN11S10256C2_nt4v113Ev");}
void  S10256C2_nt ::v114(){vfunc_called(this, "_ZN11S10256C2_nt4v114Ev");}
void  S10256C2_nt ::v115(){vfunc_called(this, "_ZN11S10256C2_nt4v115Ev");}
void  S10256C2_nt ::v116(){vfunc_called(this, "_ZN11S10256C2_nt4v116Ev");}
void  S10256C2_nt ::v117(){vfunc_called(this, "_ZN11S10256C2_nt4v117Ev");}
void  S10256C2_nt ::v118(){vfunc_called(this, "_ZN11S10256C2_nt4v118Ev");}
void  S10256C2_nt ::v119(){vfunc_called(this, "_ZN11S10256C2_nt4v119Ev");}
void  S10256C2_nt ::v120(){vfunc_called(this, "_ZN11S10256C2_nt4v120Ev");}
void  S10256C2_nt ::v121(){vfunc_called(this, "_ZN11S10256C2_nt4v121Ev");}
void  S10256C2_nt ::v122(){vfunc_called(this, "_ZN11S10256C2_nt4v122Ev");}
void  S10256C2_nt ::v123(){vfunc_called(this, "_ZN11S10256C2_nt4v123Ev");}
void  S10256C2_nt ::v124(){vfunc_called(this, "_ZN11S10256C2_nt4v124Ev");}
void  S10256C2_nt ::v125(){vfunc_called(this, "_ZN11S10256C2_nt4v125Ev");}
void  S10256C2_nt ::v126(){vfunc_called(this, "_ZN11S10256C2_nt4v126Ev");}
void  S10256C2_nt ::v127(){vfunc_called(this, "_ZN11S10256C2_nt4v127Ev");}
void  S10256C2_nt ::v128(){vfunc_called(this, "_ZN11S10256C2_nt4v128Ev");}
void  S10256C2_nt ::v129(){vfunc_called(this, "_ZN11S10256C2_nt4v129Ev");}
void  S10256C2_nt ::v130(){vfunc_called(this, "_ZN11S10256C2_nt4v130Ev");}
void  S10256C2_nt ::v131(){vfunc_called(this, "_ZN11S10256C2_nt4v131Ev");}
void  S10256C2_nt ::v132(){vfunc_called(this, "_ZN11S10256C2_nt4v132Ev");}
void  S10256C2_nt ::v133(){vfunc_called(this, "_ZN11S10256C2_nt4v133Ev");}
void  S10256C2_nt ::v134(){vfunc_called(this, "_ZN11S10256C2_nt4v134Ev");}
void  S10256C2_nt ::v135(){vfunc_called(this, "_ZN11S10256C2_nt4v135Ev");}
void  S10256C2_nt ::v136(){vfunc_called(this, "_ZN11S10256C2_nt4v136Ev");}
void  S10256C2_nt ::v137(){vfunc_called(this, "_ZN11S10256C2_nt4v137Ev");}
void  S10256C2_nt ::v138(){vfunc_called(this, "_ZN11S10256C2_nt4v138Ev");}
void  S10256C2_nt ::v139(){vfunc_called(this, "_ZN11S10256C2_nt4v139Ev");}
void  S10256C2_nt ::v140(){vfunc_called(this, "_ZN11S10256C2_nt4v140Ev");}
void  S10256C2_nt ::v141(){vfunc_called(this, "_ZN11S10256C2_nt4v141Ev");}
void  S10256C2_nt ::v142(){vfunc_called(this, "_ZN11S10256C2_nt4v142Ev");}
void  S10256C2_nt ::v143(){vfunc_called(this, "_ZN11S10256C2_nt4v143Ev");}
void  S10256C2_nt ::v144(){vfunc_called(this, "_ZN11S10256C2_nt4v144Ev");}
void  S10256C2_nt ::v145(){vfunc_called(this, "_ZN11S10256C2_nt4v145Ev");}
void  S10256C2_nt ::v146(){vfunc_called(this, "_ZN11S10256C2_nt4v146Ev");}
void  S10256C2_nt ::v147(){vfunc_called(this, "_ZN11S10256C2_nt4v147Ev");}
void  S10256C2_nt ::v148(){vfunc_called(this, "_ZN11S10256C2_nt4v148Ev");}
void  S10256C2_nt ::v149(){vfunc_called(this, "_ZN11S10256C2_nt4v149Ev");}
void  S10256C2_nt ::v150(){vfunc_called(this, "_ZN11S10256C2_nt4v150Ev");}
void  S10256C2_nt ::v151(){vfunc_called(this, "_ZN11S10256C2_nt4v151Ev");}
void  S10256C2_nt ::v152(){vfunc_called(this, "_ZN11S10256C2_nt4v152Ev");}
void  S10256C2_nt ::v153(){vfunc_called(this, "_ZN11S10256C2_nt4v153Ev");}
void  S10256C2_nt ::v154(){vfunc_called(this, "_ZN11S10256C2_nt4v154Ev");}
void  S10256C2_nt ::v155(){vfunc_called(this, "_ZN11S10256C2_nt4v155Ev");}
void  S10256C2_nt ::v156(){vfunc_called(this, "_ZN11S10256C2_nt4v156Ev");}
void  S10256C2_nt ::v157(){vfunc_called(this, "_ZN11S10256C2_nt4v157Ev");}
void  S10256C2_nt ::v158(){vfunc_called(this, "_ZN11S10256C2_nt4v158Ev");}
void  S10256C2_nt ::v159(){vfunc_called(this, "_ZN11S10256C2_nt4v159Ev");}
void  S10256C2_nt ::v160(){vfunc_called(this, "_ZN11S10256C2_nt4v160Ev");}
S10256C2_nt ::S10256C2_nt(){ note_ctor("S10256C2_nt", this);} // tgen

//skip512 S10256C2_nt

#else // __cplusplus

extern void _ZN11S10256C2_ntC1Ev();
extern void _ZN11S10256C2_ntD1Ev();
Name_Map name_map_S10256C2_nt[] = {
  NSPAIR(_ZN11S10256C2_ntC1Ev),
  NSPAIR(_ZN11S10256C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10256C2_nt[];
extern void _ZN11S10256C2_ntD1Ev();
extern void _ZN11S10256C2_ntD0Ev();
extern void _ZN11S10256C2_nt3v81Ev();
extern void _ZN11S10256C2_nt3v82Ev();
extern void _ZN11S10256C2_nt3v83Ev();
extern void _ZN11S10256C2_nt3v84Ev();
extern void _ZN11S10256C2_nt3v85Ev();
extern void _ZN11S10256C2_nt3v86Ev();
extern void _ZN11S10256C2_nt3v87Ev();
extern void _ZN11S10256C2_nt3v88Ev();
extern void _ZN11S10256C2_nt3v89Ev();
extern void _ZN11S10256C2_nt3v90Ev();
extern void _ZN11S10256C2_nt3v91Ev();
extern void _ZN11S10256C2_nt3v92Ev();
extern void _ZN11S10256C2_nt3v93Ev();
extern void _ZN11S10256C2_nt3v94Ev();
extern void _ZN11S10256C2_nt3v95Ev();
extern void _ZN11S10256C2_nt3v96Ev();
extern void _ZN11S10256C2_nt3v97Ev();
extern void _ZN11S10256C2_nt3v98Ev();
extern void _ZN11S10256C2_nt3v99Ev();
extern void _ZN11S10256C2_nt4v100Ev();
extern void _ZN11S10256C2_nt4v101Ev();
extern void _ZN11S10256C2_nt4v102Ev();
extern void _ZN11S10256C2_nt4v103Ev();
extern void _ZN11S10256C2_nt4v104Ev();
extern void _ZN11S10256C2_nt4v105Ev();
extern void _ZN11S10256C2_nt4v106Ev();
extern void _ZN11S10256C2_nt4v107Ev();
extern void _ZN11S10256C2_nt4v108Ev();
extern void _ZN11S10256C2_nt4v109Ev();
extern void _ZN11S10256C2_nt4v110Ev();
extern void _ZN11S10256C2_nt4v111Ev();
extern void _ZN11S10256C2_nt4v112Ev();
extern void _ZN11S10256C2_nt4v113Ev();
extern void _ZN11S10256C2_nt4v114Ev();
extern void _ZN11S10256C2_nt4v115Ev();
extern void _ZN11S10256C2_nt4v116Ev();
extern void _ZN11S10256C2_nt4v117Ev();
extern void _ZN11S10256C2_nt4v118Ev();
extern void _ZN11S10256C2_nt4v119Ev();
extern void _ZN11S10256C2_nt4v120Ev();
extern void _ZN11S10256C2_nt4v121Ev();
extern void _ZN11S10256C2_nt4v122Ev();
extern void _ZN11S10256C2_nt4v123Ev();
extern void _ZN11S10256C2_nt4v124Ev();
extern void _ZN11S10256C2_nt4v125Ev();
extern void _ZN11S10256C2_nt4v126Ev();
extern void _ZN11S10256C2_nt4v127Ev();
extern void _ZN11S10256C2_nt4v128Ev();
extern void _ZN11S10256C2_nt4v129Ev();
extern void _ZN11S10256C2_nt4v130Ev();
extern void _ZN11S10256C2_nt4v131Ev();
extern void _ZN11S10256C2_nt4v132Ev();
extern void _ZN11S10256C2_nt4v133Ev();
extern void _ZN11S10256C2_nt4v134Ev();
extern void _ZN11S10256C2_nt4v135Ev();
extern void _ZN11S10256C2_nt4v136Ev();
extern void _ZN11S10256C2_nt4v137Ev();
extern void _ZN11S10256C2_nt4v138Ev();
extern void _ZN11S10256C2_nt4v139Ev();
extern void _ZN11S10256C2_nt4v140Ev();
extern void _ZN11S10256C2_nt4v141Ev();
extern void _ZN11S10256C2_nt4v142Ev();
extern void _ZN11S10256C2_nt4v143Ev();
extern void _ZN11S10256C2_nt4v144Ev();
extern void _ZN11S10256C2_nt4v145Ev();
extern void _ZN11S10256C2_nt4v146Ev();
extern void _ZN11S10256C2_nt4v147Ev();
extern void _ZN11S10256C2_nt4v148Ev();
extern void _ZN11S10256C2_nt4v149Ev();
extern void _ZN11S10256C2_nt4v150Ev();
extern void _ZN11S10256C2_nt4v151Ev();
extern void _ZN11S10256C2_nt4v152Ev();
extern void _ZN11S10256C2_nt4v153Ev();
extern void _ZN11S10256C2_nt4v154Ev();
extern void _ZN11S10256C2_nt4v155Ev();
extern void _ZN11S10256C2_nt4v156Ev();
extern void _ZN11S10256C2_nt4v157Ev();
extern void _ZN11S10256C2_nt4v158Ev();
extern void _ZN11S10256C2_nt4v159Ev();
extern void _ZN11S10256C2_nt4v160Ev();
static  VTBL_ENTRY vtc_S10256C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10256C2_nt[0]),
  (VTBL_ENTRY)&_ZN11S10256C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v160Ev,
};
extern VTBL_ENTRY _ZTI11S10256C2_nt[];
VTBL_ENTRY *P__ZTI11S10256C2_nt = _ZTI11S10256C2_nt; 
extern  VTBL_ENTRY _ZTV11S10256C2_nt[];
Class_Descriptor cd_S10256C2_nt = {  "S10256C2_nt", // class name
  0,0,//no base classes
  &(vtc_S10256C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10256C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10256C2_nt),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C3_nt  {
  void *s10256c3f0;
  int s10256c3f1;
  ::S7368C78 s10256c3f2;
  ::S7368C51 s10256c3f3;
  void  mf10256c3(); // _ZN11S10256C3_nt9mf10256c3Ev
};
//SIG(-1 S10256C3_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S10256C3_nt ::mf10256c3(){}

//skip512 S10256C3_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C7_nt  {
  long s10256c7f0[4];
};
//SIG(-1 S10256C7_nt) C1{ Fl[4]}



//skip512 S10256C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C6_nt  {
  ::S10256C7_nt s10256c6f0;
  void  mf10256c6(); // _ZN11S10256C6_nt9mf10256c6Ev
};
//SIG(-1 S10256C6_nt) C1{ m FC2{ Fl[4]}}


void  S10256C6_nt ::mf10256c6(){}

//skip512 S10256C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C12_nt  {
  int s10256c12f0[4];
  void *s10256c12f1;
  char s10256c12f2;
  int s10256c12f3[2];
  void *s10256c12f4[2];
  void  mf10256c12(); // _ZN12S10256C12_nt10mf10256c12Ev
};
//SIG(-1 S10256C12_nt) C1{ m Fi[4] Fp Fc Fi[2] Fp[2]}


void  S10256C12_nt ::mf10256c12(){}

//skip512 S10256C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C13_nt  {
  int s10256c13f0;
};
//SIG(-1 S10256C13_nt) C1{ Fi}



//skip512 S10256C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C11  {
  ::S10256C12_nt s10256c11f0;
  int s10256c11f1[5];
  __tsi64 s10256c11f2[2];
  ::S10256C13_nt s10256c11f3;
  int s10256c11f4;
  char s10256c11f5;
  int s10256c11f6;
  char s10256c11f7;
  void  mf10256c11(); // _ZN9S10256C1110mf10256c11Ev
};
//SIG(-1 S10256C11) C1{ m FC2{ m Fi[4] Fp Fc Fi[2] Fp[2]} Fi[5] FL[2] FC3{ Fi} Fi Fc Fi Fc}


void  S10256C11 ::mf10256c11(){}

static void Test_S10256C11()
{
  {
    init_simple_test("S10256C11");
    S10256C11 lv;
    check2(sizeof(lv), ABISELECT(120,96), "sizeof(S10256C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10256C11)");
    check_field_offset(lv, s10256c11f0, 0, "S10256C11.s10256c11f0");
    check_field_offset(lv, s10256c11f1, ABISELECT(56,40), "S10256C11.s10256c11f1");
    check_field_offset(lv, s10256c11f2, ABISELECT(80,60), "S10256C11.s10256c11f2");
    check_field_offset(lv, s10256c11f3, ABISELECT(96,76), "S10256C11.s10256c11f3");
    check_field_offset(lv, s10256c11f4, ABISELECT(100,80), "S10256C11.s10256c11f4");
    check_field_offset(lv, s10256c11f5, ABISELECT(104,84), "S10256C11.s10256c11f5");
    check_field_offset(lv, s10256c11f6, ABISELECT(108,88), "S10256C11.s10256c11f6");
    check_field_offset(lv, s10256c11f7, ABISELECT(112,92), "S10256C11.s10256c11f7");
  }
}
static Arrange_To_Call_Me vS10256C11(Test_S10256C11, "S10256C11", ABISELECT(120,96));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10256C1  : S10256C2_nt {
  void *s10256c1f0;
  ::S10256C3_nt s10256c1f1;
  ::S10256C6_nt s10256c1f2;
  ::S10256C3_nt s10256c1f3;
  ::S10256C6_nt s10256c1f4;
  ::S10256C3_nt s10256c1f5;
  void *s10256c1f6[10];
  ::S10256C3_nt s10256c1f7;
  ::S10256C6_nt s10256c1f8;
  ::S10256C11 s10256c1f9;
  ::S10256C6_nt s10256c1f10;
  ::S10256C3_nt s10256c1f11;
  void *s10256c1f12;
  virtual  ~S10256C1(); // _ZN8S10256C1D1Ev
  virtual void  v1(); // _ZN8S10256C12v1Ev
  virtual void  v2(); // _ZN8S10256C12v2Ev
  virtual void  v3(); // _ZN8S10256C12v3Ev
  virtual void  v4(); // _ZN8S10256C12v4Ev
  virtual void  v5(); // _ZN8S10256C12v5Ev
  virtual void  v6(); // _ZN8S10256C12v6Ev
  virtual void  v7(); // _ZN8S10256C12v7Ev
  virtual void  v8(); // _ZN8S10256C12v8Ev
  virtual void  v9(); // _ZN8S10256C12v9Ev
  virtual void  v10(); // _ZN8S10256C13v10Ev
  virtual void  v11(); // _ZN8S10256C13v11Ev
  virtual void  v12(); // _ZN8S10256C13v12Ev
  virtual void  v13(); // _ZN8S10256C13v13Ev
  virtual void  v14(); // _ZN8S10256C13v14Ev
  virtual void  v15(); // _ZN8S10256C13v15Ev
  virtual void  v16(); // _ZN8S10256C13v16Ev
  virtual void  v17(); // _ZN8S10256C13v17Ev
  virtual void  v18(); // _ZN8S10256C13v18Ev
  virtual void  v19(); // _ZN8S10256C13v19Ev
  virtual void  v20(); // _ZN8S10256C13v20Ev
  virtual void  v21(); // _ZN8S10256C13v21Ev
  virtual void  v22(); // _ZN8S10256C13v22Ev
  virtual void  v23(); // _ZN8S10256C13v23Ev
  virtual void  v24(); // _ZN8S10256C13v24Ev
  virtual void  v25(); // _ZN8S10256C13v25Ev
  virtual void  v26(); // _ZN8S10256C13v26Ev
  virtual void  v27(); // _ZN8S10256C13v27Ev
  virtual void  v28(); // _ZN8S10256C13v28Ev
  virtual void  v29(); // _ZN8S10256C13v29Ev
  virtual void  v30(); // _ZN8S10256C13v30Ev
  virtual void  v31(); // _ZN8S10256C13v31Ev
  virtual void  v32(); // _ZN8S10256C13v32Ev
  virtual void  v33(); // _ZN8S10256C13v33Ev
  virtual void  v34(); // _ZN8S10256C13v34Ev
  virtual void  v35(); // _ZN8S10256C13v35Ev
  virtual void  v36(); // _ZN8S10256C13v36Ev
  virtual void  v37(); // _ZN8S10256C13v37Ev
  virtual void  v38(); // _ZN8S10256C13v38Ev
  virtual void  v39(); // _ZN8S10256C13v39Ev
  virtual void  v40(); // _ZN8S10256C13v40Ev
  virtual void  v41(); // _ZN8S10256C13v41Ev
  virtual void  v42(); // _ZN8S10256C13v42Ev
  virtual void  v43(); // _ZN8S10256C13v43Ev
  virtual void  v44(); // _ZN8S10256C13v44Ev
  virtual void  v45(); // _ZN8S10256C13v45Ev
  virtual void  v46(); // _ZN8S10256C13v46Ev
  virtual void  v47(); // _ZN8S10256C13v47Ev
  virtual void  v48(); // _ZN8S10256C13v48Ev
  virtual void  v49(); // _ZN8S10256C13v49Ev
  virtual void  v50(); // _ZN8S10256C13v50Ev
  virtual void  v51(); // _ZN8S10256C13v51Ev
  virtual void  v52(); // _ZN8S10256C13v52Ev
  virtual void  v53(); // _ZN8S10256C13v53Ev
  virtual void  v54(); // _ZN8S10256C13v54Ev
  virtual void  v55(); // _ZN8S10256C13v55Ev
  virtual void  v56(); // _ZN8S10256C13v56Ev
  virtual void  v57(); // _ZN8S10256C13v57Ev
  virtual void  v58(); // _ZN8S10256C13v58Ev
  virtual void  v59(); // _ZN8S10256C13v59Ev
  virtual void  v60(); // _ZN8S10256C13v60Ev
  virtual void  v61(); // _ZN8S10256C13v61Ev
  virtual void  v62(); // _ZN8S10256C13v62Ev
  virtual void  v63(); // _ZN8S10256C13v63Ev
  virtual void  v64(); // _ZN8S10256C13v64Ev
  virtual void  v65(); // _ZN8S10256C13v65Ev
  virtual void  v66(); // _ZN8S10256C13v66Ev
  virtual void  v67(); // _ZN8S10256C13v67Ev
  virtual void  v68(); // _ZN8S10256C13v68Ev
  virtual void  v69(); // _ZN8S10256C13v69Ev
  virtual void  v70(); // _ZN8S10256C13v70Ev
  virtual void  v71(); // _ZN8S10256C13v71Ev
  virtual void  v72(); // _ZN8S10256C13v72Ev
  virtual void  v73(); // _ZN8S10256C13v73Ev
  virtual void  v74(); // _ZN8S10256C13v74Ev
  virtual void  v75(); // _ZN8S10256C13v75Ev
  virtual void  v76(); // _ZN8S10256C13v76Ev
  virtual void  v77(); // _ZN8S10256C13v77Ev
  virtual void  v78(); // _ZN8S10256C13v78Ev
  virtual void  v79(); // _ZN8S10256C13v79Ev
  virtual void  v80(); // _ZN8S10256C13v80Ev
  S10256C1(); // tgen
};
//SIG(1 S10256C1) C1{ BC2{ vd v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fp FC3{ m Fp Fi FC4{ m} FC5{ m}} FC6{ m FC7{ Fl[4]}} FC3 FC6 FC3 Fp[10] FC3 FC6 FC8{ m FC9{ m Fi[4] Fp Fc Fi[2] Fp[2]} Fi[5] FL[2] FC10{ Fi} Fi Fc Fi Fc} FC6 FC3 Fp}


 S10256C1 ::~S10256C1(){ note_dtor("S10256C1", this);}
void  S10256C1 ::v1(){vfunc_called(this, "_ZN8S10256C12v1Ev");}
void  S10256C1 ::v2(){vfunc_called(this, "_ZN8S10256C12v2Ev");}
void  S10256C1 ::v3(){vfunc_called(this, "_ZN8S10256C12v3Ev");}
void  S10256C1 ::v4(){vfunc_called(this, "_ZN8S10256C12v4Ev");}
void  S10256C1 ::v5(){vfunc_called(this, "_ZN8S10256C12v5Ev");}
void  S10256C1 ::v6(){vfunc_called(this, "_ZN8S10256C12v6Ev");}
void  S10256C1 ::v7(){vfunc_called(this, "_ZN8S10256C12v7Ev");}
void  S10256C1 ::v8(){vfunc_called(this, "_ZN8S10256C12v8Ev");}
void  S10256C1 ::v9(){vfunc_called(this, "_ZN8S10256C12v9Ev");}
void  S10256C1 ::v10(){vfunc_called(this, "_ZN8S10256C13v10Ev");}
void  S10256C1 ::v11(){vfunc_called(this, "_ZN8S10256C13v11Ev");}
void  S10256C1 ::v12(){vfunc_called(this, "_ZN8S10256C13v12Ev");}
void  S10256C1 ::v13(){vfunc_called(this, "_ZN8S10256C13v13Ev");}
void  S10256C1 ::v14(){vfunc_called(this, "_ZN8S10256C13v14Ev");}
void  S10256C1 ::v15(){vfunc_called(this, "_ZN8S10256C13v15Ev");}
void  S10256C1 ::v16(){vfunc_called(this, "_ZN8S10256C13v16Ev");}
void  S10256C1 ::v17(){vfunc_called(this, "_ZN8S10256C13v17Ev");}
void  S10256C1 ::v18(){vfunc_called(this, "_ZN8S10256C13v18Ev");}
void  S10256C1 ::v19(){vfunc_called(this, "_ZN8S10256C13v19Ev");}
void  S10256C1 ::v20(){vfunc_called(this, "_ZN8S10256C13v20Ev");}
void  S10256C1 ::v21(){vfunc_called(this, "_ZN8S10256C13v21Ev");}
void  S10256C1 ::v22(){vfunc_called(this, "_ZN8S10256C13v22Ev");}
void  S10256C1 ::v23(){vfunc_called(this, "_ZN8S10256C13v23Ev");}
void  S10256C1 ::v24(){vfunc_called(this, "_ZN8S10256C13v24Ev");}
void  S10256C1 ::v25(){vfunc_called(this, "_ZN8S10256C13v25Ev");}
void  S10256C1 ::v26(){vfunc_called(this, "_ZN8S10256C13v26Ev");}
void  S10256C1 ::v27(){vfunc_called(this, "_ZN8S10256C13v27Ev");}
void  S10256C1 ::v28(){vfunc_called(this, "_ZN8S10256C13v28Ev");}
void  S10256C1 ::v29(){vfunc_called(this, "_ZN8S10256C13v29Ev");}
void  S10256C1 ::v30(){vfunc_called(this, "_ZN8S10256C13v30Ev");}
void  S10256C1 ::v31(){vfunc_called(this, "_ZN8S10256C13v31Ev");}
void  S10256C1 ::v32(){vfunc_called(this, "_ZN8S10256C13v32Ev");}
void  S10256C1 ::v33(){vfunc_called(this, "_ZN8S10256C13v33Ev");}
void  S10256C1 ::v34(){vfunc_called(this, "_ZN8S10256C13v34Ev");}
void  S10256C1 ::v35(){vfunc_called(this, "_ZN8S10256C13v35Ev");}
void  S10256C1 ::v36(){vfunc_called(this, "_ZN8S10256C13v36Ev");}
void  S10256C1 ::v37(){vfunc_called(this, "_ZN8S10256C13v37Ev");}
void  S10256C1 ::v38(){vfunc_called(this, "_ZN8S10256C13v38Ev");}
void  S10256C1 ::v39(){vfunc_called(this, "_ZN8S10256C13v39Ev");}
void  S10256C1 ::v40(){vfunc_called(this, "_ZN8S10256C13v40Ev");}
void  S10256C1 ::v41(){vfunc_called(this, "_ZN8S10256C13v41Ev");}
void  S10256C1 ::v42(){vfunc_called(this, "_ZN8S10256C13v42Ev");}
void  S10256C1 ::v43(){vfunc_called(this, "_ZN8S10256C13v43Ev");}
void  S10256C1 ::v44(){vfunc_called(this, "_ZN8S10256C13v44Ev");}
void  S10256C1 ::v45(){vfunc_called(this, "_ZN8S10256C13v45Ev");}
void  S10256C1 ::v46(){vfunc_called(this, "_ZN8S10256C13v46Ev");}
void  S10256C1 ::v47(){vfunc_called(this, "_ZN8S10256C13v47Ev");}
void  S10256C1 ::v48(){vfunc_called(this, "_ZN8S10256C13v48Ev");}
void  S10256C1 ::v49(){vfunc_called(this, "_ZN8S10256C13v49Ev");}
void  S10256C1 ::v50(){vfunc_called(this, "_ZN8S10256C13v50Ev");}
void  S10256C1 ::v51(){vfunc_called(this, "_ZN8S10256C13v51Ev");}
void  S10256C1 ::v52(){vfunc_called(this, "_ZN8S10256C13v52Ev");}
void  S10256C1 ::v53(){vfunc_called(this, "_ZN8S10256C13v53Ev");}
void  S10256C1 ::v54(){vfunc_called(this, "_ZN8S10256C13v54Ev");}
void  S10256C1 ::v55(){vfunc_called(this, "_ZN8S10256C13v55Ev");}
void  S10256C1 ::v56(){vfunc_called(this, "_ZN8S10256C13v56Ev");}
void  S10256C1 ::v57(){vfunc_called(this, "_ZN8S10256C13v57Ev");}
void  S10256C1 ::v58(){vfunc_called(this, "_ZN8S10256C13v58Ev");}
void  S10256C1 ::v59(){vfunc_called(this, "_ZN8S10256C13v59Ev");}
void  S10256C1 ::v60(){vfunc_called(this, "_ZN8S10256C13v60Ev");}
void  S10256C1 ::v61(){vfunc_called(this, "_ZN8S10256C13v61Ev");}
void  S10256C1 ::v62(){vfunc_called(this, "_ZN8S10256C13v62Ev");}
void  S10256C1 ::v63(){vfunc_called(this, "_ZN8S10256C13v63Ev");}
void  S10256C1 ::v64(){vfunc_called(this, "_ZN8S10256C13v64Ev");}
void  S10256C1 ::v65(){vfunc_called(this, "_ZN8S10256C13v65Ev");}
void  S10256C1 ::v66(){vfunc_called(this, "_ZN8S10256C13v66Ev");}
void  S10256C1 ::v67(){vfunc_called(this, "_ZN8S10256C13v67Ev");}
void  S10256C1 ::v68(){vfunc_called(this, "_ZN8S10256C13v68Ev");}
void  S10256C1 ::v69(){vfunc_called(this, "_ZN8S10256C13v69Ev");}
void  S10256C1 ::v70(){vfunc_called(this, "_ZN8S10256C13v70Ev");}
void  S10256C1 ::v71(){vfunc_called(this, "_ZN8S10256C13v71Ev");}
void  S10256C1 ::v72(){vfunc_called(this, "_ZN8S10256C13v72Ev");}
void  S10256C1 ::v73(){vfunc_called(this, "_ZN8S10256C13v73Ev");}
void  S10256C1 ::v74(){vfunc_called(this, "_ZN8S10256C13v74Ev");}
void  S10256C1 ::v75(){vfunc_called(this, "_ZN8S10256C13v75Ev");}
void  S10256C1 ::v76(){vfunc_called(this, "_ZN8S10256C13v76Ev");}
void  S10256C1 ::v77(){vfunc_called(this, "_ZN8S10256C13v77Ev");}
void  S10256C1 ::v78(){vfunc_called(this, "_ZN8S10256C13v78Ev");}
void  S10256C1 ::v79(){vfunc_called(this, "_ZN8S10256C13v79Ev");}
void  S10256C1 ::v80(){vfunc_called(this, "_ZN8S10256C13v80Ev");}
S10256C1 ::S10256C1(){ note_ctor("S10256C1", this);} // tgen

static void Test_S10256C1()
{
  extern Class_Descriptor cd_S10256C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,69)];
    init_test(&cd_S10256C1, buf);
    S10256C1 *dp, &lv = *(dp=new (buf) S10256C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,272), "sizeof(S10256C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10256C1)");
    check_base_class_offset(lv, (S10256C2_nt*), 0, "S10256C1");
    check_field_offset(lv, s10256c1f0, ABISELECT(8,4), "S10256C1.s10256c1f0");
    check_field_offset(lv, s10256c1f1, ABISELECT(16,8), "S10256C1.s10256c1f1");
    check_field_offset(lv, s10256c1f2, ABISELECT(32,20), "S10256C1.s10256c1f2");
    check_field_offset(lv, s10256c1f3, ABISELECT(64,36), "S10256C1.s10256c1f3");
    check_field_offset(lv, s10256c1f4, ABISELECT(80,48), "S10256C1.s10256c1f4");
    check_field_offset(lv, s10256c1f5, ABISELECT(112,64), "S10256C1.s10256c1f5");
    check_field_offset(lv, s10256c1f6, ABISELECT(128,76), "S10256C1.s10256c1f6");
    check_field_offset(lv, s10256c1f7, ABISELECT(208,116), "S10256C1.s10256c1f7");
    check_field_offset(lv, s10256c1f8, ABISELECT(224,128), "S10256C1.s10256c1f8");
    check_field_offset(lv, s10256c1f9, ABISELECT(256,144), "S10256C1.s10256c1f9");
    check_field_offset(lv, s10256c1f10, ABISELECT(376,240), "S10256C1.s10256c1f10");
    check_field_offset(lv, s10256c1f11, ABISELECT(408,256), "S10256C1.s10256c1f11");
    check_field_offset(lv, s10256c1f12, ABISELECT(424,268), "S10256C1.s10256c1f12");
    test_class_info(&lv, &cd_S10256C1);
    dp->~S10256C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10256C1(Test_S10256C1, "S10256C1", ABISELECT(432,272));

#else // __cplusplus

extern void _ZN8S10256C1C1Ev();
extern void _ZN8S10256C1D1Ev();
Name_Map name_map_S10256C1[] = {
  NSPAIR(_ZN8S10256C1C1Ev),
  NSPAIR(_ZN8S10256C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10256C2_nt;
extern VTBL_ENTRY _ZTI11S10256C2_nt[];
extern  VTBL_ENTRY _ZTV11S10256C2_nt[];
static Base_Class bases_S10256C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10256C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10256C1[];
extern void _ZN8S10256C1D1Ev();
extern void _ZN8S10256C1D0Ev();
extern void _ZN11S10256C2_nt3v81Ev();
extern void _ZN11S10256C2_nt3v82Ev();
extern void _ZN11S10256C2_nt3v83Ev();
extern void _ZN11S10256C2_nt3v84Ev();
extern void _ZN11S10256C2_nt3v85Ev();
extern void _ZN11S10256C2_nt3v86Ev();
extern void _ZN11S10256C2_nt3v87Ev();
extern void _ZN11S10256C2_nt3v88Ev();
extern void _ZN11S10256C2_nt3v89Ev();
extern void _ZN11S10256C2_nt3v90Ev();
extern void _ZN11S10256C2_nt3v91Ev();
extern void _ZN11S10256C2_nt3v92Ev();
extern void _ZN11S10256C2_nt3v93Ev();
extern void _ZN11S10256C2_nt3v94Ev();
extern void _ZN11S10256C2_nt3v95Ev();
extern void _ZN11S10256C2_nt3v96Ev();
extern void _ZN11S10256C2_nt3v97Ev();
extern void _ZN11S10256C2_nt3v98Ev();
extern void _ZN11S10256C2_nt3v99Ev();
extern void _ZN11S10256C2_nt4v100Ev();
extern void _ZN11S10256C2_nt4v101Ev();
extern void _ZN11S10256C2_nt4v102Ev();
extern void _ZN11S10256C2_nt4v103Ev();
extern void _ZN11S10256C2_nt4v104Ev();
extern void _ZN11S10256C2_nt4v105Ev();
extern void _ZN11S10256C2_nt4v106Ev();
extern void _ZN11S10256C2_nt4v107Ev();
extern void _ZN11S10256C2_nt4v108Ev();
extern void _ZN11S10256C2_nt4v109Ev();
extern void _ZN11S10256C2_nt4v110Ev();
extern void _ZN11S10256C2_nt4v111Ev();
extern void _ZN11S10256C2_nt4v112Ev();
extern void _ZN11S10256C2_nt4v113Ev();
extern void _ZN11S10256C2_nt4v114Ev();
extern void _ZN11S10256C2_nt4v115Ev();
extern void _ZN11S10256C2_nt4v116Ev();
extern void _ZN11S10256C2_nt4v117Ev();
extern void _ZN11S10256C2_nt4v118Ev();
extern void _ZN11S10256C2_nt4v119Ev();
extern void _ZN11S10256C2_nt4v120Ev();
extern void _ZN11S10256C2_nt4v121Ev();
extern void _ZN11S10256C2_nt4v122Ev();
extern void _ZN11S10256C2_nt4v123Ev();
extern void _ZN11S10256C2_nt4v124Ev();
extern void _ZN11S10256C2_nt4v125Ev();
extern void _ZN11S10256C2_nt4v126Ev();
extern void _ZN11S10256C2_nt4v127Ev();
extern void _ZN11S10256C2_nt4v128Ev();
extern void _ZN11S10256C2_nt4v129Ev();
extern void _ZN11S10256C2_nt4v130Ev();
extern void _ZN11S10256C2_nt4v131Ev();
extern void _ZN11S10256C2_nt4v132Ev();
extern void _ZN11S10256C2_nt4v133Ev();
extern void _ZN11S10256C2_nt4v134Ev();
extern void _ZN11S10256C2_nt4v135Ev();
extern void _ZN11S10256C2_nt4v136Ev();
extern void _ZN11S10256C2_nt4v137Ev();
extern void _ZN11S10256C2_nt4v138Ev();
extern void _ZN11S10256C2_nt4v139Ev();
extern void _ZN11S10256C2_nt4v140Ev();
extern void _ZN11S10256C2_nt4v141Ev();
extern void _ZN11S10256C2_nt4v142Ev();
extern void _ZN11S10256C2_nt4v143Ev();
extern void _ZN11S10256C2_nt4v144Ev();
extern void _ZN11S10256C2_nt4v145Ev();
extern void _ZN11S10256C2_nt4v146Ev();
extern void _ZN11S10256C2_nt4v147Ev();
extern void _ZN11S10256C2_nt4v148Ev();
extern void _ZN11S10256C2_nt4v149Ev();
extern void _ZN11S10256C2_nt4v150Ev();
extern void _ZN11S10256C2_nt4v151Ev();
extern void _ZN11S10256C2_nt4v152Ev();
extern void _ZN11S10256C2_nt4v153Ev();
extern void _ZN11S10256C2_nt4v154Ev();
extern void _ZN11S10256C2_nt4v155Ev();
extern void _ZN11S10256C2_nt4v156Ev();
extern void _ZN11S10256C2_nt4v157Ev();
extern void _ZN11S10256C2_nt4v158Ev();
extern void _ZN11S10256C2_nt4v159Ev();
extern void _ZN11S10256C2_nt4v160Ev();
extern void _ZN8S10256C12v1Ev();
extern void _ZN8S10256C12v2Ev();
extern void _ZN8S10256C12v3Ev();
extern void _ZN8S10256C12v4Ev();
extern void _ZN8S10256C12v5Ev();
extern void _ZN8S10256C12v6Ev();
extern void _ZN8S10256C12v7Ev();
extern void _ZN8S10256C12v8Ev();
extern void _ZN8S10256C12v9Ev();
extern void _ZN8S10256C13v10Ev();
extern void _ZN8S10256C13v11Ev();
extern void _ZN8S10256C13v12Ev();
extern void _ZN8S10256C13v13Ev();
extern void _ZN8S10256C13v14Ev();
extern void _ZN8S10256C13v15Ev();
extern void _ZN8S10256C13v16Ev();
extern void _ZN8S10256C13v17Ev();
extern void _ZN8S10256C13v18Ev();
extern void _ZN8S10256C13v19Ev();
extern void _ZN8S10256C13v20Ev();
extern void _ZN8S10256C13v21Ev();
extern void _ZN8S10256C13v22Ev();
extern void _ZN8S10256C13v23Ev();
extern void _ZN8S10256C13v24Ev();
extern void _ZN8S10256C13v25Ev();
extern void _ZN8S10256C13v26Ev();
extern void _ZN8S10256C13v27Ev();
extern void _ZN8S10256C13v28Ev();
extern void _ZN8S10256C13v29Ev();
extern void _ZN8S10256C13v30Ev();
extern void _ZN8S10256C13v31Ev();
extern void _ZN8S10256C13v32Ev();
extern void _ZN8S10256C13v33Ev();
extern void _ZN8S10256C13v34Ev();
extern void _ZN8S10256C13v35Ev();
extern void _ZN8S10256C13v36Ev();
extern void _ZN8S10256C13v37Ev();
extern void _ZN8S10256C13v38Ev();
extern void _ZN8S10256C13v39Ev();
extern void _ZN8S10256C13v40Ev();
extern void _ZN8S10256C13v41Ev();
extern void _ZN8S10256C13v42Ev();
extern void _ZN8S10256C13v43Ev();
extern void _ZN8S10256C13v44Ev();
extern void _ZN8S10256C13v45Ev();
extern void _ZN8S10256C13v46Ev();
extern void _ZN8S10256C13v47Ev();
extern void _ZN8S10256C13v48Ev();
extern void _ZN8S10256C13v49Ev();
extern void _ZN8S10256C13v50Ev();
extern void _ZN8S10256C13v51Ev();
extern void _ZN8S10256C13v52Ev();
extern void _ZN8S10256C13v53Ev();
extern void _ZN8S10256C13v54Ev();
extern void _ZN8S10256C13v55Ev();
extern void _ZN8S10256C13v56Ev();
extern void _ZN8S10256C13v57Ev();
extern void _ZN8S10256C13v58Ev();
extern void _ZN8S10256C13v59Ev();
extern void _ZN8S10256C13v60Ev();
extern void _ZN8S10256C13v61Ev();
extern void _ZN8S10256C13v62Ev();
extern void _ZN8S10256C13v63Ev();
extern void _ZN8S10256C13v64Ev();
extern void _ZN8S10256C13v65Ev();
extern void _ZN8S10256C13v66Ev();
extern void _ZN8S10256C13v67Ev();
extern void _ZN8S10256C13v68Ev();
extern void _ZN8S10256C13v69Ev();
extern void _ZN8S10256C13v70Ev();
extern void _ZN8S10256C13v71Ev();
extern void _ZN8S10256C13v72Ev();
extern void _ZN8S10256C13v73Ev();
extern void _ZN8S10256C13v74Ev();
extern void _ZN8S10256C13v75Ev();
extern void _ZN8S10256C13v76Ev();
extern void _ZN8S10256C13v77Ev();
extern void _ZN8S10256C13v78Ev();
extern void _ZN8S10256C13v79Ev();
extern void _ZN8S10256C13v80Ev();
static  VTBL_ENTRY vtc_S10256C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10256C1[0]),
  (VTBL_ENTRY)&_ZN8S10256C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10256C1D0Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN11S10256C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10256C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v78Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v79Ev,
  (VTBL_ENTRY)&_ZN8S10256C13v80Ev,
};
extern VTBL_ENTRY _ZTI8S10256C1[];
extern  VTBL_ENTRY _ZTV8S10256C1[];
Class_Descriptor cd_S10256C1 = {  "S10256C1", // class name
  bases_S10256C1, 1,
  &(vtc_S10256C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,272), // object size
  NSPAIRA(_ZTI8S10256C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S10256C1),164, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S636C5  {
  int s636c5f0;
  __tsi64 s636c5f1;
  void *s636c5f2[4];
  int s636c5f3[2];
  void *s636c5f4;
  ::S499C6_nt s636c5f5;
  void *s636c5f6[2];
  virtual  ~S636C5(); // _ZN6S636C5D1Ev
  virtual void  v5(); // _ZN6S636C52v5Ev
  virtual void  v6(); // _ZN6S636C52v6Ev
  virtual void  v7(); // _ZN6S636C52v7Ev
  virtual void  v8(); // _ZN6S636C52v8Ev
  virtual void  v9(); // _ZN6S636C52v9Ev
  virtual void  v10(); // _ZN6S636C53v10Ev
  virtual void  v11(); // _ZN6S636C53v11Ev
  virtual void  v12(); // _ZN6S636C53v12Ev
  virtual void  v13(); // _ZN6S636C53v13Ev
  virtual void  v14(); // _ZN6S636C53v14Ev
  virtual void  v15(); // _ZN6S636C53v15Ev
  virtual void  v16(); // _ZN6S636C53v16Ev
  virtual void  v17(); // _ZN6S636C53v17Ev
  virtual void  v18(); // _ZN6S636C53v18Ev
  virtual void  v19(); // _ZN6S636C53v19Ev
  virtual void  v20(); // _ZN6S636C53v20Ev
  virtual void  v21(); // _ZN6S636C53v21Ev
  virtual void  v22(); // _ZN6S636C53v22Ev
  virtual void  v23(); // _ZN6S636C53v23Ev
  virtual void  v24(); // _ZN6S636C53v24Ev
  virtual void  v25(); // _ZN6S636C53v25Ev
  virtual void  v26(); // _ZN6S636C53v26Ev
  virtual void  v27(); // _ZN6S636C53v27Ev
  virtual void  v28(); // _ZN6S636C53v28Ev
  virtual void  v29(); // _ZN6S636C53v29Ev
  virtual void  v30(); // _ZN6S636C53v30Ev
  virtual void  v31(); // _ZN6S636C53v31Ev
  virtual void  v32(); // _ZN6S636C53v32Ev
  virtual void  v33(); // _ZN6S636C53v33Ev
  virtual void  v34(); // _ZN6S636C53v34Ev
  virtual void  v35(); // _ZN6S636C53v35Ev
  virtual void  v36(); // _ZN6S636C53v36Ev
  virtual void  v37(); // _ZN6S636C53v37Ev
  virtual void  v38(); // _ZN6S636C53v38Ev
  virtual void  v39(); // _ZN6S636C53v39Ev
  virtual void  v40(); // _ZN6S636C53v40Ev
  virtual void  v41(); // _ZN6S636C53v41Ev
  virtual void  v42(); // _ZN6S636C53v42Ev
  virtual void  v43(); // _ZN6S636C53v43Ev
  virtual void  v44(); // _ZN6S636C53v44Ev
  virtual void  v45(); // _ZN6S636C53v45Ev
  virtual void  v46(); // _ZN6S636C53v46Ev
  virtual void  v47(); // _ZN6S636C53v47Ev
  virtual void  v48(); // _ZN6S636C53v48Ev
  virtual void  v49(); // _ZN6S636C53v49Ev
  virtual void  v50(); // _ZN6S636C53v50Ev
  virtual void  v51(); // _ZN6S636C53v51Ev
  virtual void  v52(); // _ZN6S636C53v52Ev
  virtual void  v53(); // _ZN6S636C53v53Ev
  virtual void  v54(); // _ZN6S636C53v54Ev
  virtual void  v55(); // _ZN6S636C53v55Ev
  virtual void  v56(); // _ZN6S636C53v56Ev
  virtual void  v57(); // _ZN6S636C53v57Ev
  virtual void  v58(); // _ZN6S636C53v58Ev
  virtual void  v59(); // _ZN6S636C53v59Ev
  virtual void  v60(); // _ZN6S636C53v60Ev
  virtual void  v61(); // _ZN6S636C53v61Ev
  virtual void  v62(); // _ZN6S636C53v62Ev
  virtual void  v63(); // _ZN6S636C53v63Ev
  virtual void  v64(); // _ZN6S636C53v64Ev
  virtual void  v65(); // _ZN6S636C53v65Ev
  virtual void  v66(); // _ZN6S636C53v66Ev
  virtual void  v67(); // _ZN6S636C53v67Ev
  virtual void  v68(); // _ZN6S636C53v68Ev
  S636C5(); // tgen
};
//SIG(-1 S636C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S636C5 ::~S636C5(){ note_dtor("S636C5", this);}
void  S636C5 ::v5(){vfunc_called(this, "_ZN6S636C52v5Ev");}
void  S636C5 ::v6(){vfunc_called(this, "_ZN6S636C52v6Ev");}
void  S636C5 ::v7(){vfunc_called(this, "_ZN6S636C52v7Ev");}
void  S636C5 ::v8(){vfunc_called(this, "_ZN6S636C52v8Ev");}
void  S636C5 ::v9(){vfunc_called(this, "_ZN6S636C52v9Ev");}
void  S636C5 ::v10(){vfunc_called(this, "_ZN6S636C53v10Ev");}
void  S636C5 ::v11(){vfunc_called(this, "_ZN6S636C53v11Ev");}
void  S636C5 ::v12(){vfunc_called(this, "_ZN6S636C53v12Ev");}
void  S636C5 ::v13(){vfunc_called(this, "_ZN6S636C53v13Ev");}
void  S636C5 ::v14(){vfunc_called(this, "_ZN6S636C53v14Ev");}
void  S636C5 ::v15(){vfunc_called(this, "_ZN6S636C53v15Ev");}
void  S636C5 ::v16(){vfunc_called(this, "_ZN6S636C53v16Ev");}
void  S636C5 ::v17(){vfunc_called(this, "_ZN6S636C53v17Ev");}
void  S636C5 ::v18(){vfunc_called(this, "_ZN6S636C53v18Ev");}
void  S636C5 ::v19(){vfunc_called(this, "_ZN6S636C53v19Ev");}
void  S636C5 ::v20(){vfunc_called(this, "_ZN6S636C53v20Ev");}
void  S636C5 ::v21(){vfunc_called(this, "_ZN6S636C53v21Ev");}
void  S636C5 ::v22(){vfunc_called(this, "_ZN6S636C53v22Ev");}
void  S636C5 ::v23(){vfunc_called(this, "_ZN6S636C53v23Ev");}
void  S636C5 ::v24(){vfunc_called(this, "_ZN6S636C53v24Ev");}
void  S636C5 ::v25(){vfunc_called(this, "_ZN6S636C53v25Ev");}
void  S636C5 ::v26(){vfunc_called(this, "_ZN6S636C53v26Ev");}
void  S636C5 ::v27(){vfunc_called(this, "_ZN6S636C53v27Ev");}
void  S636C5 ::v28(){vfunc_called(this, "_ZN6S636C53v28Ev");}
void  S636C5 ::v29(){vfunc_called(this, "_ZN6S636C53v29Ev");}
void  S636C5 ::v30(){vfunc_called(this, "_ZN6S636C53v30Ev");}
void  S636C5 ::v31(){vfunc_called(this, "_ZN6S636C53v31Ev");}
void  S636C5 ::v32(){vfunc_called(this, "_ZN6S636C53v32Ev");}
void  S636C5 ::v33(){vfunc_called(this, "_ZN6S636C53v33Ev");}
void  S636C5 ::v34(){vfunc_called(this, "_ZN6S636C53v34Ev");}
void  S636C5 ::v35(){vfunc_called(this, "_ZN6S636C53v35Ev");}
void  S636C5 ::v36(){vfunc_called(this, "_ZN6S636C53v36Ev");}
void  S636C5 ::v37(){vfunc_called(this, "_ZN6S636C53v37Ev");}
void  S636C5 ::v38(){vfunc_called(this, "_ZN6S636C53v38Ev");}
void  S636C5 ::v39(){vfunc_called(this, "_ZN6S636C53v39Ev");}
void  S636C5 ::v40(){vfunc_called(this, "_ZN6S636C53v40Ev");}
void  S636C5 ::v41(){vfunc_called(this, "_ZN6S636C53v41Ev");}
void  S636C5 ::v42(){vfunc_called(this, "_ZN6S636C53v42Ev");}
void  S636C5 ::v43(){vfunc_called(this, "_ZN6S636C53v43Ev");}
void  S636C5 ::v44(){vfunc_called(this, "_ZN6S636C53v44Ev");}
void  S636C5 ::v45(){vfunc_called(this, "_ZN6S636C53v45Ev");}
void  S636C5 ::v46(){vfunc_called(this, "_ZN6S636C53v46Ev");}
void  S636C5 ::v47(){vfunc_called(this, "_ZN6S636C53v47Ev");}
void  S636C5 ::v48(){vfunc_called(this, "_ZN6S636C53v48Ev");}
void  S636C5 ::v49(){vfunc_called(this, "_ZN6S636C53v49Ev");}
void  S636C5 ::v50(){vfunc_called(this, "_ZN6S636C53v50Ev");}
void  S636C5 ::v51(){vfunc_called(this, "_ZN6S636C53v51Ev");}
void  S636C5 ::v52(){vfunc_called(this, "_ZN6S636C53v52Ev");}
void  S636C5 ::v53(){vfunc_called(this, "_ZN6S636C53v53Ev");}
void  S636C5 ::v54(){vfunc_called(this, "_ZN6S636C53v54Ev");}
void  S636C5 ::v55(){vfunc_called(this, "_ZN6S636C53v55Ev");}
void  S636C5 ::v56(){vfunc_called(this, "_ZN6S636C53v56Ev");}
void  S636C5 ::v57(){vfunc_called(this, "_ZN6S636C53v57Ev");}
void  S636C5 ::v58(){vfunc_called(this, "_ZN6S636C53v58Ev");}
void  S636C5 ::v59(){vfunc_called(this, "_ZN6S636C53v59Ev");}
void  S636C5 ::v60(){vfunc_called(this, "_ZN6S636C53v60Ev");}
void  S636C5 ::v61(){vfunc_called(this, "_ZN6S636C53v61Ev");}
void  S636C5 ::v62(){vfunc_called(this, "_ZN6S636C53v62Ev");}
void  S636C5 ::v63(){vfunc_called(this, "_ZN6S636C53v63Ev");}
void  S636C5 ::v64(){vfunc_called(this, "_ZN6S636C53v64Ev");}
void  S636C5 ::v65(){vfunc_called(this, "_ZN6S636C53v65Ev");}
void  S636C5 ::v66(){vfunc_called(this, "_ZN6S636C53v66Ev");}
void  S636C5 ::v67(){vfunc_called(this, "_ZN6S636C53v67Ev");}
void  S636C5 ::v68(){vfunc_called(this, "_ZN6S636C53v68Ev");}
S636C5 ::S636C5(){ note_ctor("S636C5", this);} // tgen

static void Test_S636C5()
{
  extern Class_Descriptor cd_S636C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S636C5, buf);
    S636C5 *dp, &lv = *(dp=new (buf) S636C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S636C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S636C5)");
    check_field_offset(lv, s636c5f0, ABISELECT(8,4), "S636C5.s636c5f0");
    check_field_offset(lv, s636c5f1, ABISELECT(16,8), "S636C5.s636c5f1");
    check_field_offset(lv, s636c5f2, ABISELECT(24,16), "S636C5.s636c5f2");
    check_field_offset(lv, s636c5f3, ABISELECT(56,32), "S636C5.s636c5f3");
    check_field_offset(lv, s636c5f4, ABISELECT(64,40), "S636C5.s636c5f4");
    check_field_offset(lv, s636c5f5, ABISELECT(72,44), "S636C5.s636c5f5");
    check_field_offset(lv, s636c5f6, ABISELECT(80,52), "S636C5.s636c5f6");
    test_class_info(&lv, &cd_S636C5);
    dp->~S636C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS636C5(Test_S636C5, "S636C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S636C5C1Ev();
extern void _ZN6S636C5D1Ev();
Name_Map name_map_S636C5[] = {
  NSPAIR(_ZN6S636C5C1Ev),
  NSPAIR(_ZN6S636C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S636C5[];
extern void _ZN6S636C5D1Ev();
extern void _ZN6S636C5D0Ev();
extern void _ZN6S636C52v5Ev();
extern void _ZN6S636C52v6Ev();
extern void _ZN6S636C52v7Ev();
extern void _ZN6S636C52v8Ev();
extern void _ZN6S636C52v9Ev();
extern void _ZN6S636C53v10Ev();
extern void _ZN6S636C53v11Ev();
extern void _ZN6S636C53v12Ev();
extern void _ZN6S636C53v13Ev();
extern void _ZN6S636C53v14Ev();
extern void _ZN6S636C53v15Ev();
extern void _ZN6S636C53v16Ev();
extern void _ZN6S636C53v17Ev();
extern void _ZN6S636C53v18Ev();
extern void _ZN6S636C53v19Ev();
extern void _ZN6S636C53v20Ev();
extern void _ZN6S636C53v21Ev();
extern void _ZN6S636C53v22Ev();
extern void _ZN6S636C53v23Ev();
extern void _ZN6S636C53v24Ev();
extern void _ZN6S636C53v25Ev();
extern void _ZN6S636C53v26Ev();
extern void _ZN6S636C53v27Ev();
extern void _ZN6S636C53v28Ev();
extern void _ZN6S636C53v29Ev();
extern void _ZN6S636C53v30Ev();
extern void _ZN6S636C53v31Ev();
extern void _ZN6S636C53v32Ev();
extern void _ZN6S636C53v33Ev();
extern void _ZN6S636C53v34Ev();
extern void _ZN6S636C53v35Ev();
extern void _ZN6S636C53v36Ev();
extern void _ZN6S636C53v37Ev();
extern void _ZN6S636C53v38Ev();
extern void _ZN6S636C53v39Ev();
extern void _ZN6S636C53v40Ev();
extern void _ZN6S636C53v41Ev();
extern void _ZN6S636C53v42Ev();
extern void _ZN6S636C53v43Ev();
extern void _ZN6S636C53v44Ev();
extern void _ZN6S636C53v45Ev();
extern void _ZN6S636C53v46Ev();
extern void _ZN6S636C53v47Ev();
extern void _ZN6S636C53v48Ev();
extern void _ZN6S636C53v49Ev();
extern void _ZN6S636C53v50Ev();
extern void _ZN6S636C53v51Ev();
extern void _ZN6S636C53v52Ev();
extern void _ZN6S636C53v53Ev();
extern void _ZN6S636C53v54Ev();
extern void _ZN6S636C53v55Ev();
extern void _ZN6S636C53v56Ev();
extern void _ZN6S636C53v57Ev();
extern void _ZN6S636C53v58Ev();
extern void _ZN6S636C53v59Ev();
extern void _ZN6S636C53v60Ev();
extern void _ZN6S636C53v61Ev();
extern void _ZN6S636C53v62Ev();
extern void _ZN6S636C53v63Ev();
extern void _ZN6S636C53v64Ev();
extern void _ZN6S636C53v65Ev();
extern void _ZN6S636C53v66Ev();
extern void _ZN6S636C53v67Ev();
extern void _ZN6S636C53v68Ev();
static  VTBL_ENTRY vtc_S636C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S636C5[0]),
  (VTBL_ENTRY)&_ZN6S636C5D1Ev,
  (VTBL_ENTRY)&_ZN6S636C5D0Ev,
  (VTBL_ENTRY)&_ZN6S636C52v5Ev,
  (VTBL_ENTRY)&_ZN6S636C52v6Ev,
  (VTBL_ENTRY)&_ZN6S636C52v7Ev,
  (VTBL_ENTRY)&_ZN6S636C52v8Ev,
  (VTBL_ENTRY)&_ZN6S636C52v9Ev,
  (VTBL_ENTRY)&_ZN6S636C53v10Ev,
  (VTBL_ENTRY)&_ZN6S636C53v11Ev,
  (VTBL_ENTRY)&_ZN6S636C53v12Ev,
  (VTBL_ENTRY)&_ZN6S636C53v13Ev,
  (VTBL_ENTRY)&_ZN6S636C53v14Ev,
  (VTBL_ENTRY)&_ZN6S636C53v15Ev,
  (VTBL_ENTRY)&_ZN6S636C53v16Ev,
  (VTBL_ENTRY)&_ZN6S636C53v17Ev,
  (VTBL_ENTRY)&_ZN6S636C53v18Ev,
  (VTBL_ENTRY)&_ZN6S636C53v19Ev,
  (VTBL_ENTRY)&_ZN6S636C53v20Ev,
  (VTBL_ENTRY)&_ZN6S636C53v21Ev,
  (VTBL_ENTRY)&_ZN6S636C53v22Ev,
  (VTBL_ENTRY)&_ZN6S636C53v23Ev,
  (VTBL_ENTRY)&_ZN6S636C53v24Ev,
  (VTBL_ENTRY)&_ZN6S636C53v25Ev,
  (VTBL_ENTRY)&_ZN6S636C53v26Ev,
  (VTBL_ENTRY)&_ZN6S636C53v27Ev,
  (VTBL_ENTRY)&_ZN6S636C53v28Ev,
  (VTBL_ENTRY)&_ZN6S636C53v29Ev,
  (VTBL_ENTRY)&_ZN6S636C53v30Ev,
  (VTBL_ENTRY)&_ZN6S636C53v31Ev,
  (VTBL_ENTRY)&_ZN6S636C53v32Ev,
  (VTBL_ENTRY)&_ZN6S636C53v33Ev,
  (VTBL_ENTRY)&_ZN6S636C53v34Ev,
  (VTBL_ENTRY)&_ZN6S636C53v35Ev,
  (VTBL_ENTRY)&_ZN6S636C53v36Ev,
  (VTBL_ENTRY)&_ZN6S636C53v37Ev,
  (VTBL_ENTRY)&_ZN6S636C53v38Ev,
  (VTBL_ENTRY)&_ZN6S636C53v39Ev,
  (VTBL_ENTRY)&_ZN6S636C53v40Ev,
  (VTBL_ENTRY)&_ZN6S636C53v41Ev,
  (VTBL_ENTRY)&_ZN6S636C53v42Ev,
  (VTBL_ENTRY)&_ZN6S636C53v43Ev,
  (VTBL_ENTRY)&_ZN6S636C53v44Ev,
  (VTBL_ENTRY)&_ZN6S636C53v45Ev,
  (VTBL_ENTRY)&_ZN6S636C53v46Ev,
  (VTBL_ENTRY)&_ZN6S636C53v47Ev,
  (VTBL_ENTRY)&_ZN6S636C53v48Ev,
  (VTBL_ENTRY)&_ZN6S636C53v49Ev,
  (VTBL_ENTRY)&_ZN6S636C53v50Ev,
  (VTBL_ENTRY)&_ZN6S636C53v51Ev,
  (VTBL_ENTRY)&_ZN6S636C53v52Ev,
  (VTBL_ENTRY)&_ZN6S636C53v53Ev,
  (VTBL_ENTRY)&_ZN6S636C53v54Ev,
  (VTBL_ENTRY)&_ZN6S636C53v55Ev,
  (VTBL_ENTRY)&_ZN6S636C53v56Ev,
  (VTBL_ENTRY)&_ZN6S636C53v57Ev,
  (VTBL_ENTRY)&_ZN6S636C53v58Ev,
  (VTBL_ENTRY)&_ZN6S636C53v59Ev,
  (VTBL_ENTRY)&_ZN6S636C53v60Ev,
  (VTBL_ENTRY)&_ZN6S636C53v61Ev,
  (VTBL_ENTRY)&_ZN6S636C53v62Ev,
  (VTBL_ENTRY)&_ZN6S636C53v63Ev,
  (VTBL_ENTRY)&_ZN6S636C53v64Ev,
  (VTBL_ENTRY)&_ZN6S636C53v65Ev,
  (VTBL_ENTRY)&_ZN6S636C53v66Ev,
  (VTBL_ENTRY)&_ZN6S636C53v67Ev,
  (VTBL_ENTRY)&_ZN6S636C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S636C5[];
extern  VTBL_ENTRY _ZTV6S636C5[];
Class_Descriptor cd_S636C5 = {  "S636C5", // class name
  0,0,//no base classes
  &(vtc_S636C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S636C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S636C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S636C4_nt  : S636C5 {
  int s636c4f0[2];
  void *s636c4f1;
  int s636c4f2[2];
  ::S499C37_nt s636c4f3;
  ::S499C37_nt s636c4f4;
  ::S7368C78 s636c4f5;
  ::S499C37_nt s636c4f6;
  unsigned int s636c4f7:1;
  unsigned int s636c4f8:1;
  unsigned int s636c4f9:1;
  unsigned int s636c4f10:1;
  unsigned int s636c4f11:1;
  int s636c4f12[2];
  virtual  ~S636C4_nt(); // _ZN9S636C4_ntD1Ev
  virtual void  v69(); // _ZN9S636C4_nt3v69Ev
  virtual void  v70(); // _ZN9S636C4_nt3v70Ev
  virtual void  v71(); // _ZN9S636C4_nt3v71Ev
  virtual void  v72(); // _ZN9S636C4_nt3v72Ev
  virtual void  v73(); // _ZN9S636C4_nt3v73Ev
  virtual void  v74(); // _ZN9S636C4_nt3v74Ev
  virtual void  v75(); // _ZN9S636C4_nt3v75Ev
  virtual void  v76(); // _ZN9S636C4_nt3v76Ev
  virtual void  v77(); // _ZN9S636C4_nt3v77Ev
  virtual void  v78(); // _ZN9S636C4_nt3v78Ev
  virtual void  v79(); // _ZN9S636C4_nt3v79Ev
  virtual void  v80(); // _ZN9S636C4_nt3v80Ev
  virtual void  v81(); // _ZN9S636C4_nt3v81Ev
  virtual void  v82(); // _ZN9S636C4_nt3v82Ev
  virtual void  v83(); // _ZN9S636C4_nt3v83Ev
  virtual void  v84(); // _ZN9S636C4_nt3v84Ev
  virtual void  v85(); // _ZN9S636C4_nt3v85Ev
  virtual void  v86(); // _ZN9S636C4_nt3v86Ev
  virtual void  v87(); // _ZN9S636C4_nt3v87Ev
  virtual void  v88(); // _ZN9S636C4_nt3v88Ev
  virtual void  v89(); // _ZN9S636C4_nt3v89Ev
  virtual void  v90(); // _ZN9S636C4_nt3v90Ev
  S636C4_nt(); // tgen
};
//SIG(-1 S636C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S636C4_nt ::~S636C4_nt(){ note_dtor("S636C4_nt", this);}
void  S636C4_nt ::v69(){vfunc_called(this, "_ZN9S636C4_nt3v69Ev");}
void  S636C4_nt ::v70(){vfunc_called(this, "_ZN9S636C4_nt3v70Ev");}
void  S636C4_nt ::v71(){vfunc_called(this, "_ZN9S636C4_nt3v71Ev");}
void  S636C4_nt ::v72(){vfunc_called(this, "_ZN9S636C4_nt3v72Ev");}
void  S636C4_nt ::v73(){vfunc_called(this, "_ZN9S636C4_nt3v73Ev");}
void  S636C4_nt ::v74(){vfunc_called(this, "_ZN9S636C4_nt3v74Ev");}
void  S636C4_nt ::v75(){vfunc_called(this, "_ZN9S636C4_nt3v75Ev");}
void  S636C4_nt ::v76(){vfunc_called(this, "_ZN9S636C4_nt3v76Ev");}
void  S636C4_nt ::v77(){vfunc_called(this, "_ZN9S636C4_nt3v77Ev");}
void  S636C4_nt ::v78(){vfunc_called(this, "_ZN9S636C4_nt3v78Ev");}
void  S636C4_nt ::v79(){vfunc_called(this, "_ZN9S636C4_nt3v79Ev");}
void  S636C4_nt ::v80(){vfunc_called(this, "_ZN9S636C4_nt3v80Ev");}
void  S636C4_nt ::v81(){vfunc_called(this, "_ZN9S636C4_nt3v81Ev");}
void  S636C4_nt ::v82(){vfunc_called(this, "_ZN9S636C4_nt3v82Ev");}
void  S636C4_nt ::v83(){vfunc_called(this, "_ZN9S636C4_nt3v83Ev");}
void  S636C4_nt ::v84(){vfunc_called(this, "_ZN9S636C4_nt3v84Ev");}
void  S636C4_nt ::v85(){vfunc_called(this, "_ZN9S636C4_nt3v85Ev");}
void  S636C4_nt ::v86(){vfunc_called(this, "_ZN9S636C4_nt3v86Ev");}
void  S636C4_nt ::v87(){vfunc_called(this, "_ZN9S636C4_nt3v87Ev");}
void  S636C4_nt ::v88(){vfunc_called(this, "_ZN9S636C4_nt3v88Ev");}
void  S636C4_nt ::v89(){vfunc_called(this, "_ZN9S636C4_nt3v89Ev");}
void  S636C4_nt ::v90(){vfunc_called(this, "_ZN9S636C4_nt3v90Ev");}
S636C4_nt ::S636C4_nt(){ note_ctor("S636C4_nt", this);} // tgen

//skip512 S636C4_nt

#else // __cplusplus

extern void _ZN9S636C4_ntC1Ev();
extern void _ZN9S636C4_ntD1Ev();
Name_Map name_map_S636C4_nt[] = {
  NSPAIR(_ZN9S636C4_ntC1Ev),
  NSPAIR(_ZN9S636C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S636C5;
extern VTBL_ENTRY _ZTI6S636C5[];
extern  VTBL_ENTRY _ZTV6S636C5[];
static Base_Class bases_S636C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S636C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S636C4_nt[];
extern void _ZN9S636C4_ntD1Ev();
extern void _ZN9S636C4_ntD0Ev();
extern void _ZN6S636C52v5Ev();
extern void _ZN6S636C52v6Ev();
extern void _ZN6S636C52v7Ev();
extern void _ZN6S636C52v8Ev();
extern void _ZN6S636C52v9Ev();
extern void _ZN6S636C53v10Ev();
extern void _ZN6S636C53v11Ev();
extern void _ZN6S636C53v12Ev();
extern void _ZN6S636C53v13Ev();
extern void _ZN6S636C53v14Ev();
extern void _ZN6S636C53v15Ev();
extern void _ZN6S636C53v16Ev();
extern void _ZN6S636C53v17Ev();
extern void _ZN6S636C53v18Ev();
extern void _ZN6S636C53v19Ev();
extern void _ZN6S636C53v20Ev();
extern void _ZN6S636C53v21Ev();
extern void _ZN6S636C53v22Ev();
extern void _ZN6S636C53v23Ev();
extern void _ZN6S636C53v24Ev();
extern void _ZN6S636C53v25Ev();
extern void _ZN6S636C53v26Ev();
extern void _ZN6S636C53v27Ev();
extern void _ZN6S636C53v28Ev();
extern void _ZN6S636C53v29Ev();
extern void _ZN6S636C53v30Ev();
extern void _ZN6S636C53v31Ev();
extern void _ZN6S636C53v32Ev();
extern void _ZN6S636C53v33Ev();
extern void _ZN6S636C53v34Ev();
extern void _ZN6S636C53v35Ev();
extern void _ZN6S636C53v36Ev();
extern void _ZN6S636C53v37Ev();
extern void _ZN6S636C53v38Ev();
extern void _ZN6S636C53v39Ev();
extern void _ZN6S636C53v40Ev();
extern void _ZN6S636C53v41Ev();
extern void _ZN6S636C53v42Ev();
extern void _ZN6S636C53v43Ev();
extern void _ZN6S636C53v44Ev();
extern void _ZN6S636C53v45Ev();
extern void _ZN6S636C53v46Ev();
extern void _ZN6S636C53v47Ev();
extern void _ZN6S636C53v48Ev();
extern void _ZN6S636C53v49Ev();
extern void _ZN6S636C53v50Ev();
extern void _ZN6S636C53v51Ev();
extern void _ZN6S636C53v52Ev();
extern void _ZN6S636C53v53Ev();
extern void _ZN6S636C53v54Ev();
extern void _ZN6S636C53v55Ev();
extern void _ZN6S636C53v56Ev();
extern void _ZN6S636C53v57Ev();
extern void _ZN6S636C53v58Ev();
extern void _ZN6S636C53v59Ev();
extern void _ZN6S636C53v60Ev();
extern void _ZN6S636C53v61Ev();
extern void _ZN6S636C53v62Ev();
extern void _ZN6S636C53v63Ev();
extern void _ZN6S636C53v64Ev();
extern void _ZN6S636C53v65Ev();
extern void _ZN6S636C53v66Ev();
extern void _ZN6S636C53v67Ev();
extern void _ZN6S636C53v68Ev();
extern void _ZN9S636C4_nt3v69Ev();
extern void _ZN9S636C4_nt3v70Ev();
extern void _ZN9S636C4_nt3v71Ev();
extern void _ZN9S636C4_nt3v72Ev();
extern void _ZN9S636C4_nt3v73Ev();
extern void _ZN9S636C4_nt3v74Ev();
extern void _ZN9S636C4_nt3v75Ev();
extern void _ZN9S636C4_nt3v76Ev();
extern void _ZN9S636C4_nt3v77Ev();
extern void _ZN9S636C4_nt3v78Ev();
extern void _ZN9S636C4_nt3v79Ev();
extern void _ZN9S636C4_nt3v80Ev();
extern void _ZN9S636C4_nt3v81Ev();
extern void _ZN9S636C4_nt3v82Ev();
extern void _ZN9S636C4_nt3v83Ev();
extern void _ZN9S636C4_nt3v84Ev();
extern void _ZN9S636C4_nt3v85Ev();
extern void _ZN9S636C4_nt3v86Ev();
extern void _ZN9S636C4_nt3v87Ev();
extern void _ZN9S636C4_nt3v88Ev();
extern void _ZN9S636C4_nt3v89Ev();
extern void _ZN9S636C4_nt3v90Ev();
static  VTBL_ENTRY vtc_S636C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S636C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S636C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S636C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S636C52v5Ev,
  (VTBL_ENTRY)&_ZN6S636C52v6Ev,
  (VTBL_ENTRY)&_ZN6S636C52v7Ev,
  (VTBL_ENTRY)&_ZN6S636C52v8Ev,
  (VTBL_ENTRY)&_ZN6S636C52v9Ev,
  (VTBL_ENTRY)&_ZN6S636C53v10Ev,
  (VTBL_ENTRY)&_ZN6S636C53v11Ev,
  (VTBL_ENTRY)&_ZN6S636C53v12Ev,
  (VTBL_ENTRY)&_ZN6S636C53v13Ev,
  (VTBL_ENTRY)&_ZN6S636C53v14Ev,
  (VTBL_ENTRY)&_ZN6S636C53v15Ev,
  (VTBL_ENTRY)&_ZN6S636C53v16Ev,
  (VTBL_ENTRY)&_ZN6S636C53v17Ev,
  (VTBL_ENTRY)&_ZN6S636C53v18Ev,
  (VTBL_ENTRY)&_ZN6S636C53v19Ev,
  (VTBL_ENTRY)&_ZN6S636C53v20Ev,
  (VTBL_ENTRY)&_ZN6S636C53v21Ev,
  (VTBL_ENTRY)&_ZN6S636C53v22Ev,
  (VTBL_ENTRY)&_ZN6S636C53v23Ev,
  (VTBL_ENTRY)&_ZN6S636C53v24Ev,
  (VTBL_ENTRY)&_ZN6S636C53v25Ev,
  (VTBL_ENTRY)&_ZN6S636C53v26Ev,
  (VTBL_ENTRY)&_ZN6S636C53v27Ev,
  (VTBL_ENTRY)&_ZN6S636C53v28Ev,
  (VTBL_ENTRY)&_ZN6S636C53v29Ev,
  (VTBL_ENTRY)&_ZN6S636C53v30Ev,
  (VTBL_ENTRY)&_ZN6S636C53v31Ev,
  (VTBL_ENTRY)&_ZN6S636C53v32Ev,
  (VTBL_ENTRY)&_ZN6S636C53v33Ev,
  (VTBL_ENTRY)&_ZN6S636C53v34Ev,
  (VTBL_ENTRY)&_ZN6S636C53v35Ev,
  (VTBL_ENTRY)&_ZN6S636C53v36Ev,
  (VTBL_ENTRY)&_ZN6S636C53v37Ev,
  (VTBL_ENTRY)&_ZN6S636C53v38Ev,
  (VTBL_ENTRY)&_ZN6S636C53v39Ev,
  (VTBL_ENTRY)&_ZN6S636C53v40Ev,
  (VTBL_ENTRY)&_ZN6S636C53v41Ev,
  (VTBL_ENTRY)&_ZN6S636C53v42Ev,
  (VTBL_ENTRY)&_ZN6S636C53v43Ev,
  (VTBL_ENTRY)&_ZN6S636C53v44Ev,
  (VTBL_ENTRY)&_ZN6S636C53v45Ev,
  (VTBL_ENTRY)&_ZN6S636C53v46Ev,
  (VTBL_ENTRY)&_ZN6S636C53v47Ev,
  (VTBL_ENTRY)&_ZN6S636C53v48Ev,
  (VTBL_ENTRY)&_ZN6S636C53v49Ev,
  (VTBL_ENTRY)&_ZN6S636C53v50Ev,
  (VTBL_ENTRY)&_ZN6S636C53v51Ev,
  (VTBL_ENTRY)&_ZN6S636C53v52Ev,
  (VTBL_ENTRY)&_ZN6S636C53v53Ev,
  (VTBL_ENTRY)&_ZN6S636C53v54Ev,
  (VTBL_ENTRY)&_ZN6S636C53v55Ev,
  (VTBL_ENTRY)&_ZN6S636C53v56Ev,
  (VTBL_ENTRY)&_ZN6S636C53v57Ev,
  (VTBL_ENTRY)&_ZN6S636C53v58Ev,
  (VTBL_ENTRY)&_ZN6S636C53v59Ev,
  (VTBL_ENTRY)&_ZN6S636C53v60Ev,
  (VTBL_ENTRY)&_ZN6S636C53v61Ev,
  (VTBL_ENTRY)&_ZN6S636C53v62Ev,
  (VTBL_ENTRY)&_ZN6S636C53v63Ev,
  (VTBL_ENTRY)&_ZN6S636C53v64Ev,
  (VTBL_ENTRY)&_ZN6S636C53v65Ev,
  (VTBL_ENTRY)&_ZN6S636C53v66Ev,
  (VTBL_ENTRY)&_ZN6S636C53v67Ev,
  (VTBL_ENTRY)&_ZN6S636C53v68Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S636C4_nt[];
VTBL_ENTRY *P__ZTI9S636C4_nt = _ZTI9S636C4_nt; 
extern  VTBL_ENTRY _ZTV9S636C4_nt[];
Class_Descriptor cd_S636C4_nt = {  "S636C4_nt", // class name
  bases_S636C4_nt, 1,
  &(vtc_S636C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S636C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S636C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S636C3_nt  : S636C4_nt {
  unsigned int s636c3f0:1;
  unsigned int s636c3f1:1;
  unsigned int s636c3f2:1;
  ::S499C42 s636c3f3;
  ::S499C38 s636c3f4;
  ::S499C17 s636c3f5;
  ::S499C13 s636c3f6;
  int s636c3f7[3];
  virtual  ~S636C3_nt(); // _ZN9S636C3_ntD1Ev
  virtual void  v91(); // _ZN9S636C3_nt3v91Ev
  virtual void  v92(); // _ZN9S636C3_nt3v92Ev
  virtual void  v93(); // _ZN9S636C3_nt3v93Ev
  virtual void  v94(); // _ZN9S636C3_nt3v94Ev
  virtual void  v95(); // _ZN9S636C3_nt3v95Ev
  virtual void  v96(); // _ZN9S636C3_nt3v96Ev
  virtual void  v97(); // _ZN9S636C3_nt3v97Ev
  virtual void  v98(); // _ZN9S636C3_nt3v98Ev
  virtual void  v99(); // _ZN9S636C3_nt3v99Ev
  virtual void  v100(); // _ZN9S636C3_nt4v100Ev
  virtual void  v101(); // _ZN9S636C3_nt4v101Ev
  virtual void  v102(); // _ZN9S636C3_nt4v102Ev
  virtual void  v103(); // _ZN9S636C3_nt4v103Ev
  virtual void  v104(); // _ZN9S636C3_nt4v104Ev
  virtual void  v105(); // _ZN9S636C3_nt4v105Ev
  virtual void  v106(); // _ZN9S636C3_nt4v106Ev
  virtual void  v107(); // _ZN9S636C3_nt4v107Ev
  virtual void  v108(); // _ZN9S636C3_nt4v108Ev
  virtual void  v109(); // _ZN9S636C3_nt4v109Ev
  virtual void  v110(); // _ZN9S636C3_nt4v110Ev
  S636C3_nt(); // tgen
};
//SIG(-1 S636C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S636C3_nt ::~S636C3_nt(){ note_dtor("S636C3_nt", this);}
void  S636C3_nt ::v91(){vfunc_called(this, "_ZN9S636C3_nt3v91Ev");}
void  S636C3_nt ::v92(){vfunc_called(this, "_ZN9S636C3_nt3v92Ev");}
void  S636C3_nt ::v93(){vfunc_called(this, "_ZN9S636C3_nt3v93Ev");}
void  S636C3_nt ::v94(){vfunc_called(this, "_ZN9S636C3_nt3v94Ev");}
void  S636C3_nt ::v95(){vfunc_called(this, "_ZN9S636C3_nt3v95Ev");}
void  S636C3_nt ::v96(){vfunc_called(this, "_ZN9S636C3_nt3v96Ev");}
void  S636C3_nt ::v97(){vfunc_called(this, "_ZN9S636C3_nt3v97Ev");}
void  S636C3_nt ::v98(){vfunc_called(this, "_ZN9S636C3_nt3v98Ev");}
void  S636C3_nt ::v99(){vfunc_called(this, "_ZN9S636C3_nt3v99Ev");}
void  S636C3_nt ::v100(){vfunc_called(this, "_ZN9S636C3_nt4v100Ev");}
void  S636C3_nt ::v101(){vfunc_called(this, "_ZN9S636C3_nt4v101Ev");}
void  S636C3_nt ::v102(){vfunc_called(this, "_ZN9S636C3_nt4v102Ev");}
void  S636C3_nt ::v103(){vfunc_called(this, "_ZN9S636C3_nt4v103Ev");}
void  S636C3_nt ::v104(){vfunc_called(this, "_ZN9S636C3_nt4v104Ev");}
void  S636C3_nt ::v105(){vfunc_called(this, "_ZN9S636C3_nt4v105Ev");}
void  S636C3_nt ::v106(){vfunc_called(this, "_ZN9S636C3_nt4v106Ev");}
void  S636C3_nt ::v107(){vfunc_called(this, "_ZN9S636C3_nt4v107Ev");}
void  S636C3_nt ::v108(){vfunc_called(this, "_ZN9S636C3_nt4v108Ev");}
void  S636C3_nt ::v109(){vfunc_called(this, "_ZN9S636C3_nt4v109Ev");}
void  S636C3_nt ::v110(){vfunc_called(this, "_ZN9S636C3_nt4v110Ev");}
S636C3_nt ::S636C3_nt(){ note_ctor("S636C3_nt", this);} // tgen

//skip512 S636C3_nt

#else // __cplusplus

extern void _ZN9S636C3_ntC1Ev();
extern void _ZN9S636C3_ntD1Ev();
Name_Map name_map_S636C3_nt[] = {
  NSPAIR(_ZN9S636C3_ntC1Ev),
  NSPAIR(_ZN9S636C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S636C5;
extern VTBL_ENTRY _ZTI6S636C5[];
extern  VTBL_ENTRY _ZTV6S636C5[];
extern Class_Descriptor cd_S636C4_nt;
extern VTBL_ENTRY _ZTI9S636C4_nt[];
extern  VTBL_ENTRY _ZTV9S636C4_nt[];
static Base_Class bases_S636C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S636C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S636C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S636C3_nt[];
extern void _ZN9S636C3_ntD1Ev();
extern void _ZN9S636C3_ntD0Ev();
extern void _ZN6S636C52v5Ev();
extern void _ZN6S636C52v6Ev();
extern void _ZN6S636C52v7Ev();
extern void _ZN6S636C52v8Ev();
extern void _ZN6S636C52v9Ev();
extern void _ZN6S636C53v10Ev();
extern void _ZN6S636C53v11Ev();
extern void _ZN6S636C53v12Ev();
extern void _ZN6S636C53v13Ev();
extern void _ZN6S636C53v14Ev();
extern void _ZN6S636C53v15Ev();
extern void _ZN6S636C53v16Ev();
extern void _ZN6S636C53v17Ev();
extern void _ZN6S636C53v18Ev();
extern void _ZN6S636C53v19Ev();
extern void _ZN6S636C53v20Ev();
extern void _ZN6S636C53v21Ev();
extern void _ZN6S636C53v22Ev();
extern void _ZN6S636C53v23Ev();
extern void _ZN6S636C53v24Ev();
extern void _ZN6S636C53v25Ev();
extern void _ZN6S636C53v26Ev();
extern void _ZN6S636C53v27Ev();
extern void _ZN6S636C53v28Ev();
extern void _ZN6S636C53v29Ev();
extern void _ZN6S636C53v30Ev();
extern void _ZN6S636C53v31Ev();
extern void _ZN6S636C53v32Ev();
extern void _ZN6S636C53v33Ev();
extern void _ZN6S636C53v34Ev();
extern void _ZN6S636C53v35Ev();
extern void _ZN6S636C53v36Ev();
extern void _ZN6S636C53v37Ev();
extern void _ZN6S636C53v38Ev();
extern void _ZN6S636C53v39Ev();
extern void _ZN6S636C53v40Ev();
extern void _ZN6S636C53v41Ev();
extern void _ZN6S636C53v42Ev();
extern void _ZN6S636C53v43Ev();
extern void _ZN6S636C53v44Ev();
extern void _ZN6S636C53v45Ev();
extern void _ZN6S636C53v46Ev();
extern void _ZN6S636C53v47Ev();
extern void _ZN6S636C53v48Ev();
extern void _ZN6S636C53v49Ev();
extern void _ZN6S636C53v50Ev();
extern void _ZN6S636C53v51Ev();
extern void _ZN6S636C53v52Ev();
extern void _ZN6S636C53v53Ev();
extern void _ZN6S636C53v54Ev();
extern void _ZN6S636C53v55Ev();
extern void _ZN6S636C53v56Ev();
extern void _ZN6S636C53v57Ev();
extern void _ZN6S636C53v58Ev();
extern void _ZN6S636C53v59Ev();
extern void _ZN6S636C53v60Ev();
extern void _ZN6S636C53v61Ev();
extern void _ZN6S636C53v62Ev();
extern void _ZN6S636C53v63Ev();
extern void _ZN6S636C53v64Ev();
extern void _ZN6S636C53v65Ev();
extern void _ZN6S636C53v66Ev();
extern void _ZN6S636C53v67Ev();
extern void _ZN6S636C53v68Ev();
extern void _ZN9S636C4_nt3v69Ev();
extern void _ZN9S636C4_nt3v70Ev();
extern void _ZN9S636C4_nt3v71Ev();
extern void _ZN9S636C4_nt3v72Ev();
extern void _ZN9S636C4_nt3v73Ev();
extern void _ZN9S636C4_nt3v74Ev();
extern void _ZN9S636C4_nt3v75Ev();
extern void _ZN9S636C4_nt3v76Ev();
extern void _ZN9S636C4_nt3v77Ev();
extern void _ZN9S636C4_nt3v78Ev();
extern void _ZN9S636C4_nt3v79Ev();
extern void _ZN9S636C4_nt3v80Ev();
extern void _ZN9S636C4_nt3v81Ev();
extern void _ZN9S636C4_nt3v82Ev();
extern void _ZN9S636C4_nt3v83Ev();
extern void _ZN9S636C4_nt3v84Ev();
extern void _ZN9S636C4_nt3v85Ev();
extern void _ZN9S636C4_nt3v86Ev();
extern void _ZN9S636C4_nt3v87Ev();
extern void _ZN9S636C4_nt3v88Ev();
extern void _ZN9S636C4_nt3v89Ev();
extern void _ZN9S636C4_nt3v90Ev();
extern void _ZN9S636C3_nt3v91Ev();
extern void _ZN9S636C3_nt3v92Ev();
extern void _ZN9S636C3_nt3v93Ev();
extern void _ZN9S636C3_nt3v94Ev();
extern void _ZN9S636C3_nt3v95Ev();
extern void _ZN9S636C3_nt3v96Ev();
extern void _ZN9S636C3_nt3v97Ev();
extern void _ZN9S636C3_nt3v98Ev();
extern void _ZN9S636C3_nt3v99Ev();
extern void _ZN9S636C3_nt4v100Ev();
extern void _ZN9S636C3_nt4v101Ev();
extern void _ZN9S636C3_nt4v102Ev();
extern void _ZN9S636C3_nt4v103Ev();
extern void _ZN9S636C3_nt4v104Ev();
extern void _ZN9S636C3_nt4v105Ev();
extern void _ZN9S636C3_nt4v106Ev();
extern void _ZN9S636C3_nt4v107Ev();
extern void _ZN9S636C3_nt4v108Ev();
extern void _ZN9S636C3_nt4v109Ev();
extern void _ZN9S636C3_nt4v110Ev();
static  VTBL_ENTRY vtc_S636C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S636C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S636C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S636C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S636C52v5Ev,
  (VTBL_ENTRY)&_ZN6S636C52v6Ev,
  (VTBL_ENTRY)&_ZN6S636C52v7Ev,
  (VTBL_ENTRY)&_ZN6S636C52v8Ev,
  (VTBL_ENTRY)&_ZN6S636C52v9Ev,
  (VTBL_ENTRY)&_ZN6S636C53v10Ev,
  (VTBL_ENTRY)&_ZN6S636C53v11Ev,
  (VTBL_ENTRY)&_ZN6S636C53v12Ev,
  (VTBL_ENTRY)&_ZN6S636C53v13Ev,
  (VTBL_ENTRY)&_ZN6S636C53v14Ev,
  (VTBL_ENTRY)&_ZN6S636C53v15Ev,
  (VTBL_ENTRY)&_ZN6S636C53v16Ev,
  (VTBL_ENTRY)&_ZN6S636C53v17Ev,
  (VTBL_ENTRY)&_ZN6S636C53v18Ev,
  (VTBL_ENTRY)&_ZN6S636C53v19Ev,
  (VTBL_ENTRY)&_ZN6S636C53v20Ev,
  (VTBL_ENTRY)&_ZN6S636C53v21Ev,
  (VTBL_ENTRY)&_ZN6S636C53v22Ev,
  (VTBL_ENTRY)&_ZN6S636C53v23Ev,
  (VTBL_ENTRY)&_ZN6S636C53v24Ev,
  (VTBL_ENTRY)&_ZN6S636C53v25Ev,
  (VTBL_ENTRY)&_ZN6S636C53v26Ev,
  (VTBL_ENTRY)&_ZN6S636C53v27Ev,
  (VTBL_ENTRY)&_ZN6S636C53v28Ev,
  (VTBL_ENTRY)&_ZN6S636C53v29Ev,
  (VTBL_ENTRY)&_ZN6S636C53v30Ev,
  (VTBL_ENTRY)&_ZN6S636C53v31Ev,
  (VTBL_ENTRY)&_ZN6S636C53v32Ev,
  (VTBL_ENTRY)&_ZN6S636C53v33Ev,
  (VTBL_ENTRY)&_ZN6S636C53v34Ev,
  (VTBL_ENTRY)&_ZN6S636C53v35Ev,
  (VTBL_ENTRY)&_ZN6S636C53v36Ev,
  (VTBL_ENTRY)&_ZN6S636C53v37Ev,
  (VTBL_ENTRY)&_ZN6S636C53v38Ev,
  (VTBL_ENTRY)&_ZN6S636C53v39Ev,
  (VTBL_ENTRY)&_ZN6S636C53v40Ev,
  (VTBL_ENTRY)&_ZN6S636C53v41Ev,
  (VTBL_ENTRY)&_ZN6S636C53v42Ev,
  (VTBL_ENTRY)&_ZN6S636C53v43Ev,
  (VTBL_ENTRY)&_ZN6S636C53v44Ev,
  (VTBL_ENTRY)&_ZN6S636C53v45Ev,
  (VTBL_ENTRY)&_ZN6S636C53v46Ev,
  (VTBL_ENTRY)&_ZN6S636C53v47Ev,
  (VTBL_ENTRY)&_ZN6S636C53v48Ev,
  (VTBL_ENTRY)&_ZN6S636C53v49Ev,
  (VTBL_ENTRY)&_ZN6S636C53v50Ev,
  (VTBL_ENTRY)&_ZN6S636C53v51Ev,
  (VTBL_ENTRY)&_ZN6S636C53v52Ev,
  (VTBL_ENTRY)&_ZN6S636C53v53Ev,
  (VTBL_ENTRY)&_ZN6S636C53v54Ev,
  (VTBL_ENTRY)&_ZN6S636C53v55Ev,
  (VTBL_ENTRY)&_ZN6S636C53v56Ev,
  (VTBL_ENTRY)&_ZN6S636C53v57Ev,
  (VTBL_ENTRY)&_ZN6S636C53v58Ev,
  (VTBL_ENTRY)&_ZN6S636C53v59Ev,
  (VTBL_ENTRY)&_ZN6S636C53v60Ev,
  (VTBL_ENTRY)&_ZN6S636C53v61Ev,
  (VTBL_ENTRY)&_ZN6S636C53v62Ev,
  (VTBL_ENTRY)&_ZN6S636C53v63Ev,
  (VTBL_ENTRY)&_ZN6S636C53v64Ev,
  (VTBL_ENTRY)&_ZN6S636C53v65Ev,
  (VTBL_ENTRY)&_ZN6S636C53v66Ev,
  (VTBL_ENTRY)&_ZN6S636C53v67Ev,
  (VTBL_ENTRY)&_ZN6S636C53v68Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S636C3_nt[];
VTBL_ENTRY *P__ZTI9S636C3_nt = _ZTI9S636C3_nt; 
extern  VTBL_ENTRY _ZTV9S636C3_nt[];
Class_Descriptor cd_S636C3_nt = {  "S636C3_nt", // class name
  bases_S636C3_nt, 2,
  &(vtc_S636C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S636C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S636C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S636C2_nt  : S636C3_nt {
  void *s636c2f0[2];
  int s636c2f1[4];
  unsigned int s636c2f2:1;
  unsigned int s636c2f3:1;
  unsigned int s636c2f4:1;
  char s636c2f5;
  int s636c2f6;
  unsigned int s636c2f7:1;
  ::S499C8_nt s636c2f8;
  virtual  ~S636C2_nt(); // _ZN9S636C2_ntD1Ev
  virtual void  v111(); // _ZN9S636C2_nt4v111Ev
  virtual void  v112(); // _ZN9S636C2_nt4v112Ev
  virtual void  v113(); // _ZN9S636C2_nt4v113Ev
  virtual void  v114(); // _ZN9S636C2_nt4v114Ev
  virtual void  v115(); // _ZN9S636C2_nt4v115Ev
  virtual void  v116(); // _ZN9S636C2_nt4v116Ev
  virtual void  v117(); // _ZN9S636C2_nt4v117Ev
  virtual void  v118(); // _ZN9S636C2_nt4v118Ev
  virtual void  v119(); // _ZN9S636C2_nt4v119Ev
  virtual void  v120(); // _ZN9S636C2_nt4v120Ev
  virtual void  v121(); // _ZN9S636C2_nt4v121Ev
  virtual void  v122(); // _ZN9S636C2_nt4v122Ev
  virtual void  v123(); // _ZN9S636C2_nt4v123Ev
  virtual void  v124(); // _ZN9S636C2_nt4v124Ev
  S636C2_nt(); // tgen
};
//SIG(-1 S636C2_nt) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC17{ BC18{ BC9}}}


 S636C2_nt ::~S636C2_nt(){ note_dtor("S636C2_nt", this);}
void  S636C2_nt ::v111(){vfunc_called(this, "_ZN9S636C2_nt4v111Ev");}
void  S636C2_nt ::v112(){vfunc_called(this, "_ZN9S636C2_nt4v112Ev");}
void  S636C2_nt ::v113(){vfunc_called(this, "_ZN9S636C2_nt4v113Ev");}
void  S636C2_nt ::v114(){vfunc_called(this, "_ZN9S636C2_nt4v114Ev");}
void  S636C2_nt ::v115(){vfunc_called(this, "_ZN9S636C2_nt4v115Ev");}
void  S636C2_nt ::v116(){vfunc_called(this, "_ZN9S636C2_nt4v116Ev");}
void  S636C2_nt ::v117(){vfunc_called(this, "_ZN9S636C2_nt4v117Ev");}
void  S636C2_nt ::v118(){vfunc_called(this, "_ZN9S636C2_nt4v118Ev");}
void  S636C2_nt ::v119(){vfunc_called(this, "_ZN9S636C2_nt4v119Ev");}
void  S636C2_nt ::v120(){vfunc_called(this, "_ZN9S636C2_nt4v120Ev");}
void  S636C2_nt ::v121(){vfunc_called(this, "_ZN9S636C2_nt4v121Ev");}
void  S636C2_nt ::v122(){vfunc_called(this, "_ZN9S636C2_nt4v122Ev");}
void  S636C2_nt ::v123(){vfunc_called(this, "_ZN9S636C2_nt4v123Ev");}
void  S636C2_nt ::v124(){vfunc_called(this, "_ZN9S636C2_nt4v124Ev");}
S636C2_nt ::S636C2_nt(){ note_ctor("S636C2_nt", this);} // tgen

//skip512 S636C2_nt

#else // __cplusplus

extern void _ZN9S636C2_ntC1Ev();
extern void _ZN9S636C2_ntD1Ev();
Name_Map name_map_S636C2_nt[] = {
  NSPAIR(_ZN9S636C2_ntC1Ev),
  NSPAIR(_ZN9S636C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S636C5;
extern VTBL_ENTRY _ZTI6S636C5[];
extern  VTBL_ENTRY _ZTV6S636C5[];
extern Class_Descriptor cd_S636C4_nt;
extern VTBL_ENTRY _ZTI9S636C4_nt[];
extern  VTBL_ENTRY _ZTV9S636C4_nt[];
extern Class_Descriptor cd_S636C3_nt;
extern VTBL_ENTRY _ZTI9S636C3_nt[];
extern  VTBL_ENTRY _ZTV9S636C3_nt[];
static Base_Class bases_S636C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S636C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S636C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S636C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S636C2_nt[];
extern void _ZN9S636C2_ntD1Ev();
extern void _ZN9S636C2_ntD0Ev();
extern void _ZN6S636C52v5Ev();
extern void _ZN6S636C52v6Ev();
extern void _ZN6S636C52v7Ev();
extern void _ZN6S636C52v8Ev();
extern void _ZN6S636C52v9Ev();
extern void _ZN6S636C53v10Ev();
extern void _ZN6S636C53v11Ev();
extern void _ZN6S636C53v12Ev();
extern void _ZN6S636C53v13Ev();
extern void _ZN6S636C53v14Ev();
extern void _ZN6S636C53v15Ev();
extern void _ZN6S636C53v16Ev();
extern void _ZN6S636C53v17Ev();
extern void _ZN6S636C53v18Ev();
extern void _ZN6S636C53v19Ev();
extern void _ZN6S636C53v20Ev();
extern void _ZN6S636C53v21Ev();
extern void _ZN6S636C53v22Ev();
extern void _ZN6S636C53v23Ev();
extern void _ZN6S636C53v24Ev();
extern void _ZN6S636C53v25Ev();
extern void _ZN6S636C53v26Ev();
extern void _ZN6S636C53v27Ev();
extern void _ZN6S636C53v28Ev();
extern void _ZN6S636C53v29Ev();
extern void _ZN6S636C53v30Ev();
extern void _ZN6S636C53v31Ev();
extern void _ZN6S636C53v32Ev();
extern void _ZN6S636C53v33Ev();
extern void _ZN6S636C53v34Ev();
extern void _ZN6S636C53v35Ev();
extern void _ZN6S636C53v36Ev();
extern void _ZN6S636C53v37Ev();
extern void _ZN6S636C53v38Ev();
extern void _ZN6S636C53v39Ev();
extern void _ZN6S636C53v40Ev();
extern void _ZN6S636C53v41Ev();
extern void _ZN6S636C53v42Ev();
extern void _ZN6S636C53v43Ev();
extern void _ZN6S636C53v44Ev();
extern void _ZN6S636C53v45Ev();
extern void _ZN6S636C53v46Ev();
extern void _ZN6S636C53v47Ev();
extern void _ZN6S636C53v48Ev();
extern void _ZN6S636C53v49Ev();
extern void _ZN6S636C53v50Ev();
extern void _ZN6S636C53v51Ev();
extern void _ZN6S636C53v52Ev();
extern void _ZN6S636C53v53Ev();
extern void _ZN6S636C53v54Ev();
extern void _ZN6S636C53v55Ev();
extern void _ZN6S636C53v56Ev();
extern void _ZN6S636C53v57Ev();
extern void _ZN6S636C53v58Ev();
extern void _ZN6S636C53v59Ev();
extern void _ZN6S636C53v60Ev();
extern void _ZN6S636C53v61Ev();
extern void _ZN6S636C53v62Ev();
extern void _ZN6S636C53v63Ev();
extern void _ZN6S636C53v64Ev();
extern void _ZN6S636C53v65Ev();
extern void _ZN6S636C53v66Ev();
extern void _ZN6S636C53v67Ev();
extern void _ZN6S636C53v68Ev();
extern void _ZN9S636C4_nt3v69Ev();
extern void _ZN9S636C4_nt3v70Ev();
extern void _ZN9S636C4_nt3v71Ev();
extern void _ZN9S636C4_nt3v72Ev();
extern void _ZN9S636C4_nt3v73Ev();
extern void _ZN9S636C4_nt3v74Ev();
extern void _ZN9S636C4_nt3v75Ev();
extern void _ZN9S636C4_nt3v76Ev();
extern void _ZN9S636C4_nt3v77Ev();
extern void _ZN9S636C4_nt3v78Ev();
extern void _ZN9S636C4_nt3v79Ev();
extern void _ZN9S636C4_nt3v80Ev();
extern void _ZN9S636C4_nt3v81Ev();
extern void _ZN9S636C4_nt3v82Ev();
extern void _ZN9S636C4_nt3v83Ev();
extern void _ZN9S636C4_nt3v84Ev();
extern void _ZN9S636C4_nt3v85Ev();
extern void _ZN9S636C4_nt3v86Ev();
extern void _ZN9S636C4_nt3v87Ev();
extern void _ZN9S636C4_nt3v88Ev();
extern void _ZN9S636C4_nt3v89Ev();
extern void _ZN9S636C4_nt3v90Ev();
extern void _ZN9S636C3_nt3v91Ev();
extern void _ZN9S636C3_nt3v92Ev();
extern void _ZN9S636C3_nt3v93Ev();
extern void _ZN9S636C3_nt3v94Ev();
extern void _ZN9S636C3_nt3v95Ev();
extern void _ZN9S636C3_nt3v96Ev();
extern void _ZN9S636C3_nt3v97Ev();
extern void _ZN9S636C3_nt3v98Ev();
extern void _ZN9S636C3_nt3v99Ev();
extern void _ZN9S636C3_nt4v100Ev();
extern void _ZN9S636C3_nt4v101Ev();
extern void _ZN9S636C3_nt4v102Ev();
extern void _ZN9S636C3_nt4v103Ev();
extern void _ZN9S636C3_nt4v104Ev();
extern void _ZN9S636C3_nt4v105Ev();
extern void _ZN9S636C3_nt4v106Ev();
extern void _ZN9S636C3_nt4v107Ev();
extern void _ZN9S636C3_nt4v108Ev();
extern void _ZN9S636C3_nt4v109Ev();
extern void _ZN9S636C3_nt4v110Ev();
extern void _ZN9S636C2_nt4v111Ev();
extern void _ZN9S636C2_nt4v112Ev();
extern void _ZN9S636C2_nt4v113Ev();
extern void _ZN9S636C2_nt4v114Ev();
extern void _ZN9S636C2_nt4v115Ev();
extern void _ZN9S636C2_nt4v116Ev();
extern void _ZN9S636C2_nt4v117Ev();
extern void _ZN9S636C2_nt4v118Ev();
extern void _ZN9S636C2_nt4v119Ev();
extern void _ZN9S636C2_nt4v120Ev();
extern void _ZN9S636C2_nt4v121Ev();
extern void _ZN9S636C2_nt4v122Ev();
extern void _ZN9S636C2_nt4v123Ev();
extern void _ZN9S636C2_nt4v124Ev();
static  VTBL_ENTRY vtc_S636C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S636C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S636C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S636C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S636C52v5Ev,
  (VTBL_ENTRY)&_ZN6S636C52v6Ev,
  (VTBL_ENTRY)&_ZN6S636C52v7Ev,
  (VTBL_ENTRY)&_ZN6S636C52v8Ev,
  (VTBL_ENTRY)&_ZN6S636C52v9Ev,
  (VTBL_ENTRY)&_ZN6S636C53v10Ev,
  (VTBL_ENTRY)&_ZN6S636C53v11Ev,
  (VTBL_ENTRY)&_ZN6S636C53v12Ev,
  (VTBL_ENTRY)&_ZN6S636C53v13Ev,
  (VTBL_ENTRY)&_ZN6S636C53v14Ev,
  (VTBL_ENTRY)&_ZN6S636C53v15Ev,
  (VTBL_ENTRY)&_ZN6S636C53v16Ev,
  (VTBL_ENTRY)&_ZN6S636C53v17Ev,
  (VTBL_ENTRY)&_ZN6S636C53v18Ev,
  (VTBL_ENTRY)&_ZN6S636C53v19Ev,
  (VTBL_ENTRY)&_ZN6S636C53v20Ev,
  (VTBL_ENTRY)&_ZN6S636C53v21Ev,
  (VTBL_ENTRY)&_ZN6S636C53v22Ev,
  (VTBL_ENTRY)&_ZN6S636C53v23Ev,
  (VTBL_ENTRY)&_ZN6S636C53v24Ev,
  (VTBL_ENTRY)&_ZN6S636C53v25Ev,
  (VTBL_ENTRY)&_ZN6S636C53v26Ev,
  (VTBL_ENTRY)&_ZN6S636C53v27Ev,
  (VTBL_ENTRY)&_ZN6S636C53v28Ev,
  (VTBL_ENTRY)&_ZN6S636C53v29Ev,
  (VTBL_ENTRY)&_ZN6S636C53v30Ev,
  (VTBL_ENTRY)&_ZN6S636C53v31Ev,
  (VTBL_ENTRY)&_ZN6S636C53v32Ev,
  (VTBL_ENTRY)&_ZN6S636C53v33Ev,
  (VTBL_ENTRY)&_ZN6S636C53v34Ev,
  (VTBL_ENTRY)&_ZN6S636C53v35Ev,
  (VTBL_ENTRY)&_ZN6S636C53v36Ev,
  (VTBL_ENTRY)&_ZN6S636C53v37Ev,
  (VTBL_ENTRY)&_ZN6S636C53v38Ev,
  (VTBL_ENTRY)&_ZN6S636C53v39Ev,
  (VTBL_ENTRY)&_ZN6S636C53v40Ev,
  (VTBL_ENTRY)&_ZN6S636C53v41Ev,
  (VTBL_ENTRY)&_ZN6S636C53v42Ev,
  (VTBL_ENTRY)&_ZN6S636C53v43Ev,
  (VTBL_ENTRY)&_ZN6S636C53v44Ev,
  (VTBL_ENTRY)&_ZN6S636C53v45Ev,
  (VTBL_ENTRY)&_ZN6S636C53v46Ev,
  (VTBL_ENTRY)&_ZN6S636C53v47Ev,
  (VTBL_ENTRY)&_ZN6S636C53v48Ev,
  (VTBL_ENTRY)&_ZN6S636C53v49Ev,
  (VTBL_ENTRY)&_ZN6S636C53v50Ev,
  (VTBL_ENTRY)&_ZN6S636C53v51Ev,
  (VTBL_ENTRY)&_ZN6S636C53v52Ev,
  (VTBL_ENTRY)&_ZN6S636C53v53Ev,
  (VTBL_ENTRY)&_ZN6S636C53v54Ev,
  (VTBL_ENTRY)&_ZN6S636C53v55Ev,
  (VTBL_ENTRY)&_ZN6S636C53v56Ev,
  (VTBL_ENTRY)&_ZN6S636C53v57Ev,
  (VTBL_ENTRY)&_ZN6S636C53v58Ev,
  (VTBL_ENTRY)&_ZN6S636C53v59Ev,
  (VTBL_ENTRY)&_ZN6S636C53v60Ev,
  (VTBL_ENTRY)&_ZN6S636C53v61Ev,
  (VTBL_ENTRY)&_ZN6S636C53v62Ev,
  (VTBL_ENTRY)&_ZN6S636C53v63Ev,
  (VTBL_ENTRY)&_ZN6S636C53v64Ev,
  (VTBL_ENTRY)&_ZN6S636C53v65Ev,
  (VTBL_ENTRY)&_ZN6S636C53v66Ev,
  (VTBL_ENTRY)&_ZN6S636C53v67Ev,
  (VTBL_ENTRY)&_ZN6S636C53v68Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v124Ev,
};
extern VTBL_ENTRY _ZTI9S636C2_nt[];
VTBL_ENTRY *P__ZTI9S636C2_nt = _ZTI9S636C2_nt; 
extern  VTBL_ENTRY _ZTV9S636C2_nt[];
Class_Descriptor cd_S636C2_nt = {  "S636C2_nt", // class name
  bases_S636C2_nt, 3,
  &(vtc_S636C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI9S636C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S636C2_nt),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S636C1  : S636C2_nt {
  ::S499C6_nt s636c1f0;
  ::S499C37_nt s636c1f1;
  virtual  ~S636C1(); // _ZN6S636C1D1Ev
  virtual void  v1(); // _ZN6S636C12v1Ev
  virtual void  v2(); // _ZN6S636C12v2Ev
  virtual void  v3(); // _ZN6S636C12v3Ev
  virtual void  v4(); // _ZN6S636C12v4Ev
  S636C1(); // tgen
};
//SIG(1 S636C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 FC6 FC7}


 S636C1 ::~S636C1(){ note_dtor("S636C1", this);}
void  S636C1 ::v1(){vfunc_called(this, "_ZN6S636C12v1Ev");}
void  S636C1 ::v2(){vfunc_called(this, "_ZN6S636C12v2Ev");}
void  S636C1 ::v3(){vfunc_called(this, "_ZN6S636C12v3Ev");}
void  S636C1 ::v4(){vfunc_called(this, "_ZN6S636C12v4Ev");}
S636C1 ::S636C1(){ note_ctor("S636C1", this);} // tgen

static void Test_S636C1()
{
  extern Class_Descriptor cd_S636C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,67)];
    init_test(&cd_S636C1, buf);
    S636C1 *dp, &lv = *(dp=new (buf) S636C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,264), "sizeof(S636C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S636C1)");
    check_base_class_offset(lv, (S636C5*)(S636C4_nt*)(S636C3_nt*)(S636C2_nt*), 0, "S636C1");
    check_base_class_offset(lv, (S636C4_nt*)(S636C3_nt*)(S636C2_nt*), 0, "S636C1");
    check_base_class_offset(lv, (S636C3_nt*)(S636C2_nt*), 0, "S636C1");
    check_base_class_offset(lv, (S636C2_nt*), 0, "S636C1");
    check_field_offset(lv, s636c1f0, ABISELECT(336,244), "S636C1.s636c1f0");
    check_field_offset(lv, s636c1f1, ABISELECT(344,252), "S636C1.s636c1f1");
    test_class_info(&lv, &cd_S636C1);
    dp->~S636C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS636C1(Test_S636C1, "S636C1", ABISELECT(360,264));

#else // __cplusplus

extern void _ZN6S636C1C1Ev();
extern void _ZN6S636C1D1Ev();
Name_Map name_map_S636C1[] = {
  NSPAIR(_ZN6S636C1C1Ev),
  NSPAIR(_ZN6S636C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S636C5;
extern VTBL_ENTRY _ZTI6S636C5[];
extern  VTBL_ENTRY _ZTV6S636C5[];
extern Class_Descriptor cd_S636C4_nt;
extern VTBL_ENTRY _ZTI9S636C4_nt[];
extern  VTBL_ENTRY _ZTV9S636C4_nt[];
extern Class_Descriptor cd_S636C3_nt;
extern VTBL_ENTRY _ZTI9S636C3_nt[];
extern  VTBL_ENTRY _ZTV9S636C3_nt[];
extern Class_Descriptor cd_S636C2_nt;
extern VTBL_ENTRY _ZTI9S636C2_nt[];
extern  VTBL_ENTRY _ZTV9S636C2_nt[];
static Base_Class bases_S636C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S636C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S636C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S636C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S636C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S636C1[];
extern void _ZN6S636C1D1Ev();
extern void _ZN6S636C1D0Ev();
extern void _ZN6S636C52v5Ev();
extern void _ZN6S636C52v6Ev();
extern void _ZN6S636C52v7Ev();
extern void _ZN6S636C52v8Ev();
extern void _ZN6S636C52v9Ev();
extern void _ZN6S636C53v10Ev();
extern void _ZN6S636C53v11Ev();
extern void _ZN6S636C53v12Ev();
extern void _ZN6S636C53v13Ev();
extern void _ZN6S636C53v14Ev();
extern void _ZN6S636C53v15Ev();
extern void _ZN6S636C53v16Ev();
extern void _ZN6S636C53v17Ev();
extern void _ZN6S636C53v18Ev();
extern void _ZN6S636C53v19Ev();
extern void _ZN6S636C53v20Ev();
extern void _ZN6S636C53v21Ev();
extern void _ZN6S636C53v22Ev();
extern void _ZN6S636C53v23Ev();
extern void _ZN6S636C53v24Ev();
extern void _ZN6S636C53v25Ev();
extern void _ZN6S636C53v26Ev();
extern void _ZN6S636C53v27Ev();
extern void _ZN6S636C53v28Ev();
extern void _ZN6S636C53v29Ev();
extern void _ZN6S636C53v30Ev();
extern void _ZN6S636C53v31Ev();
extern void _ZN6S636C53v32Ev();
extern void _ZN6S636C53v33Ev();
extern void _ZN6S636C53v34Ev();
extern void _ZN6S636C53v35Ev();
extern void _ZN6S636C53v36Ev();
extern void _ZN6S636C53v37Ev();
extern void _ZN6S636C53v38Ev();
extern void _ZN6S636C53v39Ev();
extern void _ZN6S636C53v40Ev();
extern void _ZN6S636C53v41Ev();
extern void _ZN6S636C53v42Ev();
extern void _ZN6S636C53v43Ev();
extern void _ZN6S636C53v44Ev();
extern void _ZN6S636C53v45Ev();
extern void _ZN6S636C53v46Ev();
extern void _ZN6S636C53v47Ev();
extern void _ZN6S636C53v48Ev();
extern void _ZN6S636C53v49Ev();
extern void _ZN6S636C53v50Ev();
extern void _ZN6S636C53v51Ev();
extern void _ZN6S636C53v52Ev();
extern void _ZN6S636C53v53Ev();
extern void _ZN6S636C53v54Ev();
extern void _ZN6S636C53v55Ev();
extern void _ZN6S636C53v56Ev();
extern void _ZN6S636C53v57Ev();
extern void _ZN6S636C53v58Ev();
extern void _ZN6S636C53v59Ev();
extern void _ZN6S636C53v60Ev();
extern void _ZN6S636C53v61Ev();
extern void _ZN6S636C53v62Ev();
extern void _ZN6S636C53v63Ev();
extern void _ZN6S636C53v64Ev();
extern void _ZN6S636C53v65Ev();
extern void _ZN6S636C53v66Ev();
extern void _ZN6S636C53v67Ev();
extern void _ZN6S636C53v68Ev();
extern void _ZN9S636C4_nt3v69Ev();
extern void _ZN9S636C4_nt3v70Ev();
extern void _ZN9S636C4_nt3v71Ev();
extern void _ZN9S636C4_nt3v72Ev();
extern void _ZN9S636C4_nt3v73Ev();
extern void _ZN9S636C4_nt3v74Ev();
extern void _ZN9S636C4_nt3v75Ev();
extern void _ZN9S636C4_nt3v76Ev();
extern void _ZN9S636C4_nt3v77Ev();
extern void _ZN9S636C4_nt3v78Ev();
extern void _ZN9S636C4_nt3v79Ev();
extern void _ZN9S636C4_nt3v80Ev();
extern void _ZN9S636C4_nt3v81Ev();
extern void _ZN9S636C4_nt3v82Ev();
extern void _ZN9S636C4_nt3v83Ev();
extern void _ZN9S636C4_nt3v84Ev();
extern void _ZN9S636C4_nt3v85Ev();
extern void _ZN9S636C4_nt3v86Ev();
extern void _ZN9S636C4_nt3v87Ev();
extern void _ZN9S636C4_nt3v88Ev();
extern void _ZN9S636C4_nt3v89Ev();
extern void _ZN9S636C4_nt3v90Ev();
extern void _ZN9S636C3_nt3v91Ev();
extern void _ZN9S636C3_nt3v92Ev();
extern void _ZN9S636C3_nt3v93Ev();
extern void _ZN9S636C3_nt3v94Ev();
extern void _ZN9S636C3_nt3v95Ev();
extern void _ZN9S636C3_nt3v96Ev();
extern void _ZN9S636C3_nt3v97Ev();
extern void _ZN9S636C3_nt3v98Ev();
extern void _ZN9S636C3_nt3v99Ev();
extern void _ZN9S636C3_nt4v100Ev();
extern void _ZN9S636C3_nt4v101Ev();
extern void _ZN9S636C3_nt4v102Ev();
extern void _ZN9S636C3_nt4v103Ev();
extern void _ZN9S636C3_nt4v104Ev();
extern void _ZN9S636C3_nt4v105Ev();
extern void _ZN9S636C3_nt4v106Ev();
extern void _ZN9S636C3_nt4v107Ev();
extern void _ZN9S636C3_nt4v108Ev();
extern void _ZN9S636C3_nt4v109Ev();
extern void _ZN9S636C3_nt4v110Ev();
extern void _ZN9S636C2_nt4v111Ev();
extern void _ZN9S636C2_nt4v112Ev();
extern void _ZN9S636C2_nt4v113Ev();
extern void _ZN9S636C2_nt4v114Ev();
extern void _ZN9S636C2_nt4v115Ev();
extern void _ZN9S636C2_nt4v116Ev();
extern void _ZN9S636C2_nt4v117Ev();
extern void _ZN9S636C2_nt4v118Ev();
extern void _ZN9S636C2_nt4v119Ev();
extern void _ZN9S636C2_nt4v120Ev();
extern void _ZN9S636C2_nt4v121Ev();
extern void _ZN9S636C2_nt4v122Ev();
extern void _ZN9S636C2_nt4v123Ev();
extern void _ZN9S636C2_nt4v124Ev();
extern void _ZN6S636C12v1Ev();
extern void _ZN6S636C12v2Ev();
extern void _ZN6S636C12v3Ev();
extern void _ZN6S636C12v4Ev();
static  VTBL_ENTRY vtc_S636C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S636C1[0]),
  (VTBL_ENTRY)&_ZN6S636C1D1Ev,
  (VTBL_ENTRY)&_ZN6S636C1D0Ev,
  (VTBL_ENTRY)&_ZN6S636C52v5Ev,
  (VTBL_ENTRY)&_ZN6S636C52v6Ev,
  (VTBL_ENTRY)&_ZN6S636C52v7Ev,
  (VTBL_ENTRY)&_ZN6S636C52v8Ev,
  (VTBL_ENTRY)&_ZN6S636C52v9Ev,
  (VTBL_ENTRY)&_ZN6S636C53v10Ev,
  (VTBL_ENTRY)&_ZN6S636C53v11Ev,
  (VTBL_ENTRY)&_ZN6S636C53v12Ev,
  (VTBL_ENTRY)&_ZN6S636C53v13Ev,
  (VTBL_ENTRY)&_ZN6S636C53v14Ev,
  (VTBL_ENTRY)&_ZN6S636C53v15Ev,
  (VTBL_ENTRY)&_ZN6S636C53v16Ev,
  (VTBL_ENTRY)&_ZN6S636C53v17Ev,
  (VTBL_ENTRY)&_ZN6S636C53v18Ev,
  (VTBL_ENTRY)&_ZN6S636C53v19Ev,
  (VTBL_ENTRY)&_ZN6S636C53v20Ev,
  (VTBL_ENTRY)&_ZN6S636C53v21Ev,
  (VTBL_ENTRY)&_ZN6S636C53v22Ev,
  (VTBL_ENTRY)&_ZN6S636C53v23Ev,
  (VTBL_ENTRY)&_ZN6S636C53v24Ev,
  (VTBL_ENTRY)&_ZN6S636C53v25Ev,
  (VTBL_ENTRY)&_ZN6S636C53v26Ev,
  (VTBL_ENTRY)&_ZN6S636C53v27Ev,
  (VTBL_ENTRY)&_ZN6S636C53v28Ev,
  (VTBL_ENTRY)&_ZN6S636C53v29Ev,
  (VTBL_ENTRY)&_ZN6S636C53v30Ev,
  (VTBL_ENTRY)&_ZN6S636C53v31Ev,
  (VTBL_ENTRY)&_ZN6S636C53v32Ev,
  (VTBL_ENTRY)&_ZN6S636C53v33Ev,
  (VTBL_ENTRY)&_ZN6S636C53v34Ev,
  (VTBL_ENTRY)&_ZN6S636C53v35Ev,
  (VTBL_ENTRY)&_ZN6S636C53v36Ev,
  (VTBL_ENTRY)&_ZN6S636C53v37Ev,
  (VTBL_ENTRY)&_ZN6S636C53v38Ev,
  (VTBL_ENTRY)&_ZN6S636C53v39Ev,
  (VTBL_ENTRY)&_ZN6S636C53v40Ev,
  (VTBL_ENTRY)&_ZN6S636C53v41Ev,
  (VTBL_ENTRY)&_ZN6S636C53v42Ev,
  (VTBL_ENTRY)&_ZN6S636C53v43Ev,
  (VTBL_ENTRY)&_ZN6S636C53v44Ev,
  (VTBL_ENTRY)&_ZN6S636C53v45Ev,
  (VTBL_ENTRY)&_ZN6S636C53v46Ev,
  (VTBL_ENTRY)&_ZN6S636C53v47Ev,
  (VTBL_ENTRY)&_ZN6S636C53v48Ev,
  (VTBL_ENTRY)&_ZN6S636C53v49Ev,
  (VTBL_ENTRY)&_ZN6S636C53v50Ev,
  (VTBL_ENTRY)&_ZN6S636C53v51Ev,
  (VTBL_ENTRY)&_ZN6S636C53v52Ev,
  (VTBL_ENTRY)&_ZN6S636C53v53Ev,
  (VTBL_ENTRY)&_ZN6S636C53v54Ev,
  (VTBL_ENTRY)&_ZN6S636C53v55Ev,
  (VTBL_ENTRY)&_ZN6S636C53v56Ev,
  (VTBL_ENTRY)&_ZN6S636C53v57Ev,
  (VTBL_ENTRY)&_ZN6S636C53v58Ev,
  (VTBL_ENTRY)&_ZN6S636C53v59Ev,
  (VTBL_ENTRY)&_ZN6S636C53v60Ev,
  (VTBL_ENTRY)&_ZN6S636C53v61Ev,
  (VTBL_ENTRY)&_ZN6S636C53v62Ev,
  (VTBL_ENTRY)&_ZN6S636C53v63Ev,
  (VTBL_ENTRY)&_ZN6S636C53v64Ev,
  (VTBL_ENTRY)&_ZN6S636C53v65Ev,
  (VTBL_ENTRY)&_ZN6S636C53v66Ev,
  (VTBL_ENTRY)&_ZN6S636C53v67Ev,
  (VTBL_ENTRY)&_ZN6S636C53v68Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S636C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S636C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S636C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN6S636C12v1Ev,
  (VTBL_ENTRY)&_ZN6S636C12v2Ev,
  (VTBL_ENTRY)&_ZN6S636C12v3Ev,
  (VTBL_ENTRY)&_ZN6S636C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S636C1[];
extern  VTBL_ENTRY _ZTV6S636C1[];
Class_Descriptor cd_S636C1 = {  "S636C1", // class name
  bases_S636C1, 4,
  &(vtc_S636C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,264), // object size
  NSPAIRA(_ZTI6S636C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S636C1),128, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C6  {
  int s199c6f0;
  __tsi64 s199c6f1;
  void *s199c6f2[4];
  int s199c6f3[2];
  void *s199c6f4;
  ::S499C6_nt s199c6f5;
  void *s199c6f6[2];
  virtual  ~S199C6(); // _ZN6S199C6D1Ev
  virtual void  v4(); // _ZN6S199C62v4Ev
  virtual void  v5(); // _ZN6S199C62v5Ev
  virtual void  v6(); // _ZN6S199C62v6Ev
  virtual void  v7(); // _ZN6S199C62v7Ev
  virtual void  v8(); // _ZN6S199C62v8Ev
  virtual void  v9(); // _ZN6S199C62v9Ev
  virtual void  v10(); // _ZN6S199C63v10Ev
  virtual void  v11(); // _ZN6S199C63v11Ev
  virtual void  v12(); // _ZN6S199C63v12Ev
  virtual void  v13(); // _ZN6S199C63v13Ev
  virtual void  v14(); // _ZN6S199C63v14Ev
  virtual void  v15(); // _ZN6S199C63v15Ev
  virtual void  v16(); // _ZN6S199C63v16Ev
  virtual void  v17(); // _ZN6S199C63v17Ev
  virtual void  v18(); // _ZN6S199C63v18Ev
  virtual void  v19(); // _ZN6S199C63v19Ev
  virtual void  v20(); // _ZN6S199C63v20Ev
  virtual void  v21(); // _ZN6S199C63v21Ev
  virtual void  v22(); // _ZN6S199C63v22Ev
  virtual void  v23(); // _ZN6S199C63v23Ev
  virtual void  v24(); // _ZN6S199C63v24Ev
  virtual void  v25(); // _ZN6S199C63v25Ev
  virtual void  v26(); // _ZN6S199C63v26Ev
  virtual void  v27(); // _ZN6S199C63v27Ev
  virtual void  v28(); // _ZN6S199C63v28Ev
  virtual void  v29(); // _ZN6S199C63v29Ev
  virtual void  v30(); // _ZN6S199C63v30Ev
  virtual void  v31(); // _ZN6S199C63v31Ev
  virtual void  v32(); // _ZN6S199C63v32Ev
  virtual void  v33(); // _ZN6S199C63v33Ev
  virtual void  v34(); // _ZN6S199C63v34Ev
  virtual void  v35(); // _ZN6S199C63v35Ev
  virtual void  v36(); // _ZN6S199C63v36Ev
  virtual void  v37(); // _ZN6S199C63v37Ev
  virtual void  v38(); // _ZN6S199C63v38Ev
  virtual void  v39(); // _ZN6S199C63v39Ev
  virtual void  v40(); // _ZN6S199C63v40Ev
  virtual void  v41(); // _ZN6S199C63v41Ev
  virtual void  v42(); // _ZN6S199C63v42Ev
  virtual void  v43(); // _ZN6S199C63v43Ev
  virtual void  v44(); // _ZN6S199C63v44Ev
  virtual void  v45(); // _ZN6S199C63v45Ev
  virtual void  v46(); // _ZN6S199C63v46Ev
  virtual void  v47(); // _ZN6S199C63v47Ev
  virtual void  v48(); // _ZN6S199C63v48Ev
  virtual void  v49(); // _ZN6S199C63v49Ev
  virtual void  v50(); // _ZN6S199C63v50Ev
  virtual void  v51(); // _ZN6S199C63v51Ev
  virtual void  v52(); // _ZN6S199C63v52Ev
  virtual void  v53(); // _ZN6S199C63v53Ev
  virtual void  v54(); // _ZN6S199C63v54Ev
  virtual void  v55(); // _ZN6S199C63v55Ev
  virtual void  v56(); // _ZN6S199C63v56Ev
  virtual void  v57(); // _ZN6S199C63v57Ev
  virtual void  v58(); // _ZN6S199C63v58Ev
  virtual void  v59(); // _ZN6S199C63v59Ev
  virtual void  v60(); // _ZN6S199C63v60Ev
  virtual void  v61(); // _ZN6S199C63v61Ev
  virtual void  v62(); // _ZN6S199C63v62Ev
  virtual void  v63(); // _ZN6S199C63v63Ev
  virtual void  v64(); // _ZN6S199C63v64Ev
  virtual void  v65(); // _ZN6S199C63v65Ev
  virtual void  v66(); // _ZN6S199C63v66Ev
  virtual void  v67(); // _ZN6S199C63v67Ev
  S199C6(); // tgen
};
//SIG(-1 S199C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S199C6 ::~S199C6(){ note_dtor("S199C6", this);}
void  S199C6 ::v4(){vfunc_called(this, "_ZN6S199C62v4Ev");}
void  S199C6 ::v5(){vfunc_called(this, "_ZN6S199C62v5Ev");}
void  S199C6 ::v6(){vfunc_called(this, "_ZN6S199C62v6Ev");}
void  S199C6 ::v7(){vfunc_called(this, "_ZN6S199C62v7Ev");}
void  S199C6 ::v8(){vfunc_called(this, "_ZN6S199C62v8Ev");}
void  S199C6 ::v9(){vfunc_called(this, "_ZN6S199C62v9Ev");}
void  S199C6 ::v10(){vfunc_called(this, "_ZN6S199C63v10Ev");}
void  S199C6 ::v11(){vfunc_called(this, "_ZN6S199C63v11Ev");}
void  S199C6 ::v12(){vfunc_called(this, "_ZN6S199C63v12Ev");}
void  S199C6 ::v13(){vfunc_called(this, "_ZN6S199C63v13Ev");}
void  S199C6 ::v14(){vfunc_called(this, "_ZN6S199C63v14Ev");}
void  S199C6 ::v15(){vfunc_called(this, "_ZN6S199C63v15Ev");}
void  S199C6 ::v16(){vfunc_called(this, "_ZN6S199C63v16Ev");}
void  S199C6 ::v17(){vfunc_called(this, "_ZN6S199C63v17Ev");}
void  S199C6 ::v18(){vfunc_called(this, "_ZN6S199C63v18Ev");}
void  S199C6 ::v19(){vfunc_called(this, "_ZN6S199C63v19Ev");}
void  S199C6 ::v20(){vfunc_called(this, "_ZN6S199C63v20Ev");}
void  S199C6 ::v21(){vfunc_called(this, "_ZN6S199C63v21Ev");}
void  S199C6 ::v22(){vfunc_called(this, "_ZN6S199C63v22Ev");}
void  S199C6 ::v23(){vfunc_called(this, "_ZN6S199C63v23Ev");}
void  S199C6 ::v24(){vfunc_called(this, "_ZN6S199C63v24Ev");}
void  S199C6 ::v25(){vfunc_called(this, "_ZN6S199C63v25Ev");}
void  S199C6 ::v26(){vfunc_called(this, "_ZN6S199C63v26Ev");}
void  S199C6 ::v27(){vfunc_called(this, "_ZN6S199C63v27Ev");}
void  S199C6 ::v28(){vfunc_called(this, "_ZN6S199C63v28Ev");}
void  S199C6 ::v29(){vfunc_called(this, "_ZN6S199C63v29Ev");}
void  S199C6 ::v30(){vfunc_called(this, "_ZN6S199C63v30Ev");}
void  S199C6 ::v31(){vfunc_called(this, "_ZN6S199C63v31Ev");}
void  S199C6 ::v32(){vfunc_called(this, "_ZN6S199C63v32Ev");}
void  S199C6 ::v33(){vfunc_called(this, "_ZN6S199C63v33Ev");}
void  S199C6 ::v34(){vfunc_called(this, "_ZN6S199C63v34Ev");}
void  S199C6 ::v35(){vfunc_called(this, "_ZN6S199C63v35Ev");}
void  S199C6 ::v36(){vfunc_called(this, "_ZN6S199C63v36Ev");}
void  S199C6 ::v37(){vfunc_called(this, "_ZN6S199C63v37Ev");}
void  S199C6 ::v38(){vfunc_called(this, "_ZN6S199C63v38Ev");}
void  S199C6 ::v39(){vfunc_called(this, "_ZN6S199C63v39Ev");}
void  S199C6 ::v40(){vfunc_called(this, "_ZN6S199C63v40Ev");}
void  S199C6 ::v41(){vfunc_called(this, "_ZN6S199C63v41Ev");}
void  S199C6 ::v42(){vfunc_called(this, "_ZN6S199C63v42Ev");}
void  S199C6 ::v43(){vfunc_called(this, "_ZN6S199C63v43Ev");}
void  S199C6 ::v44(){vfunc_called(this, "_ZN6S199C63v44Ev");}
void  S199C6 ::v45(){vfunc_called(this, "_ZN6S199C63v45Ev");}
void  S199C6 ::v46(){vfunc_called(this, "_ZN6S199C63v46Ev");}
void  S199C6 ::v47(){vfunc_called(this, "_ZN6S199C63v47Ev");}
void  S199C6 ::v48(){vfunc_called(this, "_ZN6S199C63v48Ev");}
void  S199C6 ::v49(){vfunc_called(this, "_ZN6S199C63v49Ev");}
void  S199C6 ::v50(){vfunc_called(this, "_ZN6S199C63v50Ev");}
void  S199C6 ::v51(){vfunc_called(this, "_ZN6S199C63v51Ev");}
void  S199C6 ::v52(){vfunc_called(this, "_ZN6S199C63v52Ev");}
void  S199C6 ::v53(){vfunc_called(this, "_ZN6S199C63v53Ev");}
void  S199C6 ::v54(){vfunc_called(this, "_ZN6S199C63v54Ev");}
void  S199C6 ::v55(){vfunc_called(this, "_ZN6S199C63v55Ev");}
void  S199C6 ::v56(){vfunc_called(this, "_ZN6S199C63v56Ev");}
void  S199C6 ::v57(){vfunc_called(this, "_ZN6S199C63v57Ev");}
void  S199C6 ::v58(){vfunc_called(this, "_ZN6S199C63v58Ev");}
void  S199C6 ::v59(){vfunc_called(this, "_ZN6S199C63v59Ev");}
void  S199C6 ::v60(){vfunc_called(this, "_ZN6S199C63v60Ev");}
void  S199C6 ::v61(){vfunc_called(this, "_ZN6S199C63v61Ev");}
void  S199C6 ::v62(){vfunc_called(this, "_ZN6S199C63v62Ev");}
void  S199C6 ::v63(){vfunc_called(this, "_ZN6S199C63v63Ev");}
void  S199C6 ::v64(){vfunc_called(this, "_ZN6S199C63v64Ev");}
void  S199C6 ::v65(){vfunc_called(this, "_ZN6S199C63v65Ev");}
void  S199C6 ::v66(){vfunc_called(this, "_ZN6S199C63v66Ev");}
void  S199C6 ::v67(){vfunc_called(this, "_ZN6S199C63v67Ev");}
S199C6 ::S199C6(){ note_ctor("S199C6", this);} // tgen

static void Test_S199C6()
{
  extern Class_Descriptor cd_S199C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S199C6, buf);
    S199C6 *dp, &lv = *(dp=new (buf) S199C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S199C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S199C6)");
    check_field_offset(lv, s199c6f0, ABISELECT(8,4), "S199C6.s199c6f0");
    check_field_offset(lv, s199c6f1, ABISELECT(16,8), "S199C6.s199c6f1");
    check_field_offset(lv, s199c6f2, ABISELECT(24,16), "S199C6.s199c6f2");
    check_field_offset(lv, s199c6f3, ABISELECT(56,32), "S199C6.s199c6f3");
    check_field_offset(lv, s199c6f4, ABISELECT(64,40), "S199C6.s199c6f4");
    check_field_offset(lv, s199c6f5, ABISELECT(72,44), "S199C6.s199c6f5");
    check_field_offset(lv, s199c6f6, ABISELECT(80,52), "S199C6.s199c6f6");
    test_class_info(&lv, &cd_S199C6);
    dp->~S199C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS199C6(Test_S199C6, "S199C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S199C6C1Ev();
extern void _ZN6S199C6D1Ev();
Name_Map name_map_S199C6[] = {
  NSPAIR(_ZN6S199C6C1Ev),
  NSPAIR(_ZN6S199C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S199C6[];
extern void _ZN6S199C6D1Ev();
extern void _ZN6S199C6D0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
static  VTBL_ENTRY vtc_S199C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S199C6[0]),
  (VTBL_ENTRY)&_ZN6S199C6D1Ev,
  (VTBL_ENTRY)&_ZN6S199C6D0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
Class_Descriptor cd_S199C6 = {  "S199C6", // class name
  0,0,//no base classes
  &(vtc_S199C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S199C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S199C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C5  : S199C6 {
  int s199c5f0[2];
  void *s199c5f1;
  int s199c5f2[2];
  ::S499C37_nt s199c5f3;
  ::S499C37_nt s199c5f4;
  ::S7368C78 s199c5f5;
  ::S499C37_nt s199c5f6;
  unsigned int s199c5f7:1;
  unsigned int s199c5f8:1;
  unsigned int s199c5f9:1;
  unsigned int s199c5f10:1;
  unsigned int s199c5f11:1;
  int s199c5f12[2];
  virtual  ~S199C5(); // _ZN6S199C5D1Ev
  virtual void  v68(); // _ZN6S199C53v68Ev
  virtual void  v69(); // _ZN6S199C53v69Ev
  virtual void  v70(); // _ZN6S199C53v70Ev
  virtual void  v71(); // _ZN6S199C53v71Ev
  virtual void  v72(); // _ZN6S199C53v72Ev
  virtual void  v73(); // _ZN6S199C53v73Ev
  virtual void  v74(); // _ZN6S199C53v74Ev
  virtual void  v75(); // _ZN6S199C53v75Ev
  virtual void  v76(); // _ZN6S199C53v76Ev
  virtual void  v77(); // _ZN6S199C53v77Ev
  virtual void  v78(); // _ZN6S199C53v78Ev
  virtual void  v79(); // _ZN6S199C53v79Ev
  virtual void  v80(); // _ZN6S199C53v80Ev
  virtual void  v81(); // _ZN6S199C53v81Ev
  virtual void  v82(); // _ZN6S199C53v82Ev
  virtual void  v83(); // _ZN6S199C53v83Ev
  virtual void  v84(); // _ZN6S199C53v84Ev
  virtual void  v85(); // _ZN6S199C53v85Ev
  virtual void  v86(); // _ZN6S199C53v86Ev
  virtual void  v87(); // _ZN6S199C53v87Ev
  virtual void  v88(); // _ZN6S199C53v88Ev
  virtual void  v89(); // _ZN6S199C53v89Ev
  S199C5(); // tgen
};
//SIG(-1 S199C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S199C5 ::~S199C5(){ note_dtor("S199C5", this);}
void  S199C5 ::v68(){vfunc_called(this, "_ZN6S199C53v68Ev");}
void  S199C5 ::v69(){vfunc_called(this, "_ZN6S199C53v69Ev");}
void  S199C5 ::v70(){vfunc_called(this, "_ZN6S199C53v70Ev");}
void  S199C5 ::v71(){vfunc_called(this, "_ZN6S199C53v71Ev");}
void  S199C5 ::v72(){vfunc_called(this, "_ZN6S199C53v72Ev");}
void  S199C5 ::v73(){vfunc_called(this, "_ZN6S199C53v73Ev");}
void  S199C5 ::v74(){vfunc_called(this, "_ZN6S199C53v74Ev");}
void  S199C5 ::v75(){vfunc_called(this, "_ZN6S199C53v75Ev");}
void  S199C5 ::v76(){vfunc_called(this, "_ZN6S199C53v76Ev");}
void  S199C5 ::v77(){vfunc_called(this, "_ZN6S199C53v77Ev");}
void  S199C5 ::v78(){vfunc_called(this, "_ZN6S199C53v78Ev");}
void  S199C5 ::v79(){vfunc_called(this, "_ZN6S199C53v79Ev");}
void  S199C5 ::v80(){vfunc_called(this, "_ZN6S199C53v80Ev");}
void  S199C5 ::v81(){vfunc_called(this, "_ZN6S199C53v81Ev");}
void  S199C5 ::v82(){vfunc_called(this, "_ZN6S199C53v82Ev");}
void  S199C5 ::v83(){vfunc_called(this, "_ZN6S199C53v83Ev");}
void  S199C5 ::v84(){vfunc_called(this, "_ZN6S199C53v84Ev");}
void  S199C5 ::v85(){vfunc_called(this, "_ZN6S199C53v85Ev");}
void  S199C5 ::v86(){vfunc_called(this, "_ZN6S199C53v86Ev");}
void  S199C5 ::v87(){vfunc_called(this, "_ZN6S199C53v87Ev");}
void  S199C5 ::v88(){vfunc_called(this, "_ZN6S199C53v88Ev");}
void  S199C5 ::v89(){vfunc_called(this, "_ZN6S199C53v89Ev");}
S199C5 ::S199C5(){ note_ctor("S199C5", this);} // tgen

static void Test_S199C5()
{
  extern Class_Descriptor cd_S199C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S199C5, buf);
    S199C5 *dp, &lv = *(dp=new (buf) S199C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S199C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S199C5)");
    check_base_class_offset(lv, (S199C6*), 0, "S199C5");
    check_field_offset(lv, s199c5f0, ABISELECT(96,60), "S199C5.s199c5f0");
    check_field_offset(lv, s199c5f1, ABISELECT(104,68), "S199C5.s199c5f1");
    check_field_offset(lv, s199c5f2, ABISELECT(112,72), "S199C5.s199c5f2");
    check_field_offset(lv, s199c5f3, ABISELECT(120,80), "S199C5.s199c5f3");
    check_field_offset(lv, s199c5f4, ABISELECT(136,92), "S199C5.s199c5f4");
    check_field_offset(lv, s199c5f5, ABISELECT(152,104), "S199C5.s199c5f5");
    check_field_offset(lv, s199c5f6, ABISELECT(160,108), "S199C5.s199c5f6");
    set_bf_and_test(lv, s199c5f7, ABISELECT(176,120), 0, 1, 1, "S199C5");
    set_bf_and_test(lv, s199c5f8, ABISELECT(176,120), 1, 1, 1, "S199C5");
    set_bf_and_test(lv, s199c5f9, ABISELECT(176,120), 2, 1, 1, "S199C5");
    set_bf_and_test(lv, s199c5f10, ABISELECT(176,120), 3, 1, 1, "S199C5");
    set_bf_and_test(lv, s199c5f11, ABISELECT(176,120), 4, 1, 1, "S199C5");
    check_field_offset(lv, s199c5f12, ABISELECT(180,124), "S199C5.s199c5f12");
    test_class_info(&lv, &cd_S199C5);
    dp->~S199C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS199C5(Test_S199C5, "S199C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S199C5C1Ev();
extern void _ZN6S199C5D1Ev();
Name_Map name_map_S199C5[] = {
  NSPAIR(_ZN6S199C5C1Ev),
  NSPAIR(_ZN6S199C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S199C6;
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
static Base_Class bases_S199C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S199C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S199C5[];
extern void _ZN6S199C5D1Ev();
extern void _ZN6S199C5D0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
extern void _ZN6S199C53v68Ev();
extern void _ZN6S199C53v69Ev();
extern void _ZN6S199C53v70Ev();
extern void _ZN6S199C53v71Ev();
extern void _ZN6S199C53v72Ev();
extern void _ZN6S199C53v73Ev();
extern void _ZN6S199C53v74Ev();
extern void _ZN6S199C53v75Ev();
extern void _ZN6S199C53v76Ev();
extern void _ZN6S199C53v77Ev();
extern void _ZN6S199C53v78Ev();
extern void _ZN6S199C53v79Ev();
extern void _ZN6S199C53v80Ev();
extern void _ZN6S199C53v81Ev();
extern void _ZN6S199C53v82Ev();
extern void _ZN6S199C53v83Ev();
extern void _ZN6S199C53v84Ev();
extern void _ZN6S199C53v85Ev();
extern void _ZN6S199C53v86Ev();
extern void _ZN6S199C53v87Ev();
extern void _ZN6S199C53v88Ev();
extern void _ZN6S199C53v89Ev();
static  VTBL_ENTRY vtc_S199C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S199C5[0]),
  (VTBL_ENTRY)&_ZN6S199C5D1Ev,
  (VTBL_ENTRY)&_ZN6S199C5D0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
  (VTBL_ENTRY)&_ZN6S199C53v68Ev,
  (VTBL_ENTRY)&_ZN6S199C53v69Ev,
  (VTBL_ENTRY)&_ZN6S199C53v70Ev,
  (VTBL_ENTRY)&_ZN6S199C53v71Ev,
  (VTBL_ENTRY)&_ZN6S199C53v72Ev,
  (VTBL_ENTRY)&_ZN6S199C53v73Ev,
  (VTBL_ENTRY)&_ZN6S199C53v74Ev,
  (VTBL_ENTRY)&_ZN6S199C53v75Ev,
  (VTBL_ENTRY)&_ZN6S199C53v76Ev,
  (VTBL_ENTRY)&_ZN6S199C53v77Ev,
  (VTBL_ENTRY)&_ZN6S199C53v78Ev,
  (VTBL_ENTRY)&_ZN6S199C53v79Ev,
  (VTBL_ENTRY)&_ZN6S199C53v80Ev,
  (VTBL_ENTRY)&_ZN6S199C53v81Ev,
  (VTBL_ENTRY)&_ZN6S199C53v82Ev,
  (VTBL_ENTRY)&_ZN6S199C53v83Ev,
  (VTBL_ENTRY)&_ZN6S199C53v84Ev,
  (VTBL_ENTRY)&_ZN6S199C53v85Ev,
  (VTBL_ENTRY)&_ZN6S199C53v86Ev,
  (VTBL_ENTRY)&_ZN6S199C53v87Ev,
  (VTBL_ENTRY)&_ZN6S199C53v88Ev,
  (VTBL_ENTRY)&_ZN6S199C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S199C5[];
extern  VTBL_ENTRY _ZTV6S199C5[];
Class_Descriptor cd_S199C5 = {  "S199C5", // class name
  bases_S199C5, 1,
  &(vtc_S199C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S199C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S199C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C4  : S199C5 {
  unsigned int s199c4f0:1;
  unsigned int s199c4f1:1;
  unsigned int s199c4f2:1;
  ::S499C42 s199c4f3;
  ::S499C38 s199c4f4;
  ::S499C17 s199c4f5;
  ::S499C13 s199c4f6;
  int s199c4f7[3];
  virtual  ~S199C4(); // _ZN6S199C4D1Ev
  virtual void  v90(); // _ZN6S199C43v90Ev
  virtual void  v91(); // _ZN6S199C43v91Ev
  virtual void  v92(); // _ZN6S199C43v92Ev
  virtual void  v93(); // _ZN6S199C43v93Ev
  virtual void  v94(); // _ZN6S199C43v94Ev
  virtual void  v95(); // _ZN6S199C43v95Ev
  virtual void  v96(); // _ZN6S199C43v96Ev
  virtual void  v97(); // _ZN6S199C43v97Ev
  virtual void  v98(); // _ZN6S199C43v98Ev
  virtual void  v99(); // _ZN6S199C43v99Ev
  virtual void  v100(); // _ZN6S199C44v100Ev
  virtual void  v101(); // _ZN6S199C44v101Ev
  virtual void  v102(); // _ZN6S199C44v102Ev
  virtual void  v103(); // _ZN6S199C44v103Ev
  virtual void  v104(); // _ZN6S199C44v104Ev
  virtual void  v105(); // _ZN6S199C44v105Ev
  virtual void  v106(); // _ZN6S199C44v106Ev
  virtual void  v107(); // _ZN6S199C44v107Ev
  virtual void  v108(); // _ZN6S199C44v108Ev
  virtual void  v109(); // _ZN6S199C44v109Ev
  S199C4(); // tgen
};
//SIG(-1 S199C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S199C4 ::~S199C4(){ note_dtor("S199C4", this);}
void  S199C4 ::v90(){vfunc_called(this, "_ZN6S199C43v90Ev");}
void  S199C4 ::v91(){vfunc_called(this, "_ZN6S199C43v91Ev");}
void  S199C4 ::v92(){vfunc_called(this, "_ZN6S199C43v92Ev");}
void  S199C4 ::v93(){vfunc_called(this, "_ZN6S199C43v93Ev");}
void  S199C4 ::v94(){vfunc_called(this, "_ZN6S199C43v94Ev");}
void  S199C4 ::v95(){vfunc_called(this, "_ZN6S199C43v95Ev");}
void  S199C4 ::v96(){vfunc_called(this, "_ZN6S199C43v96Ev");}
void  S199C4 ::v97(){vfunc_called(this, "_ZN6S199C43v97Ev");}
void  S199C4 ::v98(){vfunc_called(this, "_ZN6S199C43v98Ev");}
void  S199C4 ::v99(){vfunc_called(this, "_ZN6S199C43v99Ev");}
void  S199C4 ::v100(){vfunc_called(this, "_ZN6S199C44v100Ev");}
void  S199C4 ::v101(){vfunc_called(this, "_ZN6S199C44v101Ev");}
void  S199C4 ::v102(){vfunc_called(this, "_ZN6S199C44v102Ev");}
void  S199C4 ::v103(){vfunc_called(this, "_ZN6S199C44v103Ev");}
void  S199C4 ::v104(){vfunc_called(this, "_ZN6S199C44v104Ev");}
void  S199C4 ::v105(){vfunc_called(this, "_ZN6S199C44v105Ev");}
void  S199C4 ::v106(){vfunc_called(this, "_ZN6S199C44v106Ev");}
void  S199C4 ::v107(){vfunc_called(this, "_ZN6S199C44v107Ev");}
void  S199C4 ::v108(){vfunc_called(this, "_ZN6S199C44v108Ev");}
void  S199C4 ::v109(){vfunc_called(this, "_ZN6S199C44v109Ev");}
S199C4 ::S199C4(){ note_ctor("S199C4", this);} // tgen

static void Test_S199C4()
{
  extern Class_Descriptor cd_S199C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S199C4, buf);
    S199C4 *dp, &lv = *(dp=new (buf) S199C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S199C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S199C4)");
    check_base_class_offset(lv, (S199C6*)(S199C5*), 0, "S199C4");
    check_base_class_offset(lv, (S199C5*), 0, "S199C4");
    set_bf_and_test(lv, s199c4f0, ABISELECT(188,132), 0, 1, 1, "S199C4");
    set_bf_and_test(lv, s199c4f1, ABISELECT(188,132), 1, 1, 1, "S199C4");
    set_bf_and_test(lv, s199c4f2, ABISELECT(188,132), 2, 1, 1, "S199C4");
    check_field_offset(lv, s199c4f3, ABISELECT(192,136), "S199C4.s199c4f3");
    check_field_offset(lv, s199c4f4, ABISELECT(208,148), "S199C4.s199c4f4");
    check_field_offset(lv, s199c4f5, ABISELECT(224,160), "S199C4.s199c4f5");
    check_field_offset(lv, s199c4f6, ABISELECT(240,172), "S199C4.s199c4f6");
    check_field_offset(lv, s199c4f7, ABISELECT(256,184), "S199C4.s199c4f7");
    test_class_info(&lv, &cd_S199C4);
    dp->~S199C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS199C4(Test_S199C4, "S199C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S199C4C1Ev();
extern void _ZN6S199C4D1Ev();
Name_Map name_map_S199C4[] = {
  NSPAIR(_ZN6S199C4C1Ev),
  NSPAIR(_ZN6S199C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S199C6;
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
extern Class_Descriptor cd_S199C5;
extern VTBL_ENTRY _ZTI6S199C5[];
extern  VTBL_ENTRY _ZTV6S199C5[];
static Base_Class bases_S199C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S199C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S199C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S199C4[];
extern void _ZN6S199C4D1Ev();
extern void _ZN6S199C4D0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
extern void _ZN6S199C53v68Ev();
extern void _ZN6S199C53v69Ev();
extern void _ZN6S199C53v70Ev();
extern void _ZN6S199C53v71Ev();
extern void _ZN6S199C53v72Ev();
extern void _ZN6S199C53v73Ev();
extern void _ZN6S199C53v74Ev();
extern void _ZN6S199C53v75Ev();
extern void _ZN6S199C53v76Ev();
extern void _ZN6S199C53v77Ev();
extern void _ZN6S199C53v78Ev();
extern void _ZN6S199C53v79Ev();
extern void _ZN6S199C53v80Ev();
extern void _ZN6S199C53v81Ev();
extern void _ZN6S199C53v82Ev();
extern void _ZN6S199C53v83Ev();
extern void _ZN6S199C53v84Ev();
extern void _ZN6S199C53v85Ev();
extern void _ZN6S199C53v86Ev();
extern void _ZN6S199C53v87Ev();
extern void _ZN6S199C53v88Ev();
extern void _ZN6S199C53v89Ev();
extern void _ZN6S199C43v90Ev();
extern void _ZN6S199C43v91Ev();
extern void _ZN6S199C43v92Ev();
extern void _ZN6S199C43v93Ev();
extern void _ZN6S199C43v94Ev();
extern void _ZN6S199C43v95Ev();
extern void _ZN6S199C43v96Ev();
extern void _ZN6S199C43v97Ev();
extern void _ZN6S199C43v98Ev();
extern void _ZN6S199C43v99Ev();
extern void _ZN6S199C44v100Ev();
extern void _ZN6S199C44v101Ev();
extern void _ZN6S199C44v102Ev();
extern void _ZN6S199C44v103Ev();
extern void _ZN6S199C44v104Ev();
extern void _ZN6S199C44v105Ev();
extern void _ZN6S199C44v106Ev();
extern void _ZN6S199C44v107Ev();
extern void _ZN6S199C44v108Ev();
extern void _ZN6S199C44v109Ev();
static  VTBL_ENTRY vtc_S199C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S199C4[0]),
  (VTBL_ENTRY)&_ZN6S199C4D1Ev,
  (VTBL_ENTRY)&_ZN6S199C4D0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
  (VTBL_ENTRY)&_ZN6S199C53v68Ev,
  (VTBL_ENTRY)&_ZN6S199C53v69Ev,
  (VTBL_ENTRY)&_ZN6S199C53v70Ev,
  (VTBL_ENTRY)&_ZN6S199C53v71Ev,
  (VTBL_ENTRY)&_ZN6S199C53v72Ev,
  (VTBL_ENTRY)&_ZN6S199C53v73Ev,
  (VTBL_ENTRY)&_ZN6S199C53v74Ev,
  (VTBL_ENTRY)&_ZN6S199C53v75Ev,
  (VTBL_ENTRY)&_ZN6S199C53v76Ev,
  (VTBL_ENTRY)&_ZN6S199C53v77Ev,
  (VTBL_ENTRY)&_ZN6S199C53v78Ev,
  (VTBL_ENTRY)&_ZN6S199C53v79Ev,
  (VTBL_ENTRY)&_ZN6S199C53v80Ev,
  (VTBL_ENTRY)&_ZN6S199C53v81Ev,
  (VTBL_ENTRY)&_ZN6S199C53v82Ev,
  (VTBL_ENTRY)&_ZN6S199C53v83Ev,
  (VTBL_ENTRY)&_ZN6S199C53v84Ev,
  (VTBL_ENTRY)&_ZN6S199C53v85Ev,
  (VTBL_ENTRY)&_ZN6S199C53v86Ev,
  (VTBL_ENTRY)&_ZN6S199C53v87Ev,
  (VTBL_ENTRY)&_ZN6S199C53v88Ev,
  (VTBL_ENTRY)&_ZN6S199C53v89Ev,
  (VTBL_ENTRY)&_ZN6S199C43v90Ev,
  (VTBL_ENTRY)&_ZN6S199C43v91Ev,
  (VTBL_ENTRY)&_ZN6S199C43v92Ev,
  (VTBL_ENTRY)&_ZN6S199C43v93Ev,
  (VTBL_ENTRY)&_ZN6S199C43v94Ev,
  (VTBL_ENTRY)&_ZN6S199C43v95Ev,
  (VTBL_ENTRY)&_ZN6S199C43v96Ev,
  (VTBL_ENTRY)&_ZN6S199C43v97Ev,
  (VTBL_ENTRY)&_ZN6S199C43v98Ev,
  (VTBL_ENTRY)&_ZN6S199C43v99Ev,
  (VTBL_ENTRY)&_ZN6S199C44v100Ev,
  (VTBL_ENTRY)&_ZN6S199C44v101Ev,
  (VTBL_ENTRY)&_ZN6S199C44v102Ev,
  (VTBL_ENTRY)&_ZN6S199C44v103Ev,
  (VTBL_ENTRY)&_ZN6S199C44v104Ev,
  (VTBL_ENTRY)&_ZN6S199C44v105Ev,
  (VTBL_ENTRY)&_ZN6S199C44v106Ev,
  (VTBL_ENTRY)&_ZN6S199C44v107Ev,
  (VTBL_ENTRY)&_ZN6S199C44v108Ev,
  (VTBL_ENTRY)&_ZN6S199C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S199C4[];
extern  VTBL_ENTRY _ZTV6S199C4[];
Class_Descriptor cd_S199C4 = {  "S199C4", // class name
  bases_S199C4, 2,
  &(vtc_S199C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S199C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S199C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C3_nt  : S199C4 {
  ::S499C6_nt s199c3f0;
  unsigned int s199c3f1:1;
  ::S499C8_nt s199c3f2;
  virtual  ~S199C3_nt(); // _ZN9S199C3_ntD1Ev
  virtual void  v110(); // _ZN9S199C3_nt4v110Ev
  virtual void  v111(); // _ZN9S199C3_nt4v111Ev
  virtual void  v112(); // _ZN9S199C3_nt4v112Ev
  virtual void  v113(); // _ZN9S199C3_nt4v113Ev
  S199C3_nt(); // tgen
};
//SIG(-1 S199C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S199C3_nt ::~S199C3_nt(){ note_dtor("S199C3_nt", this);}
void  S199C3_nt ::v110(){vfunc_called(this, "_ZN9S199C3_nt4v110Ev");}
void  S199C3_nt ::v111(){vfunc_called(this, "_ZN9S199C3_nt4v111Ev");}
void  S199C3_nt ::v112(){vfunc_called(this, "_ZN9S199C3_nt4v112Ev");}
void  S199C3_nt ::v113(){vfunc_called(this, "_ZN9S199C3_nt4v113Ev");}
S199C3_nt ::S199C3_nt(){ note_ctor("S199C3_nt", this);} // tgen

//skip512 S199C3_nt

#else // __cplusplus

extern void _ZN9S199C3_ntC1Ev();
extern void _ZN9S199C3_ntD1Ev();
Name_Map name_map_S199C3_nt[] = {
  NSPAIR(_ZN9S199C3_ntC1Ev),
  NSPAIR(_ZN9S199C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S199C6;
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
extern Class_Descriptor cd_S199C5;
extern VTBL_ENTRY _ZTI6S199C5[];
extern  VTBL_ENTRY _ZTV6S199C5[];
extern Class_Descriptor cd_S199C4;
extern VTBL_ENTRY _ZTI6S199C4[];
extern  VTBL_ENTRY _ZTV6S199C4[];
static Base_Class bases_S199C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S199C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S199C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S199C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S199C3_nt[];
extern void _ZN9S199C3_ntD1Ev();
extern void _ZN9S199C3_ntD0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
extern void _ZN6S199C53v68Ev();
extern void _ZN6S199C53v69Ev();
extern void _ZN6S199C53v70Ev();
extern void _ZN6S199C53v71Ev();
extern void _ZN6S199C53v72Ev();
extern void _ZN6S199C53v73Ev();
extern void _ZN6S199C53v74Ev();
extern void _ZN6S199C53v75Ev();
extern void _ZN6S199C53v76Ev();
extern void _ZN6S199C53v77Ev();
extern void _ZN6S199C53v78Ev();
extern void _ZN6S199C53v79Ev();
extern void _ZN6S199C53v80Ev();
extern void _ZN6S199C53v81Ev();
extern void _ZN6S199C53v82Ev();
extern void _ZN6S199C53v83Ev();
extern void _ZN6S199C53v84Ev();
extern void _ZN6S199C53v85Ev();
extern void _ZN6S199C53v86Ev();
extern void _ZN6S199C53v87Ev();
extern void _ZN6S199C53v88Ev();
extern void _ZN6S199C53v89Ev();
extern void _ZN6S199C43v90Ev();
extern void _ZN6S199C43v91Ev();
extern void _ZN6S199C43v92Ev();
extern void _ZN6S199C43v93Ev();
extern void _ZN6S199C43v94Ev();
extern void _ZN6S199C43v95Ev();
extern void _ZN6S199C43v96Ev();
extern void _ZN6S199C43v97Ev();
extern void _ZN6S199C43v98Ev();
extern void _ZN6S199C43v99Ev();
extern void _ZN6S199C44v100Ev();
extern void _ZN6S199C44v101Ev();
extern void _ZN6S199C44v102Ev();
extern void _ZN6S199C44v103Ev();
extern void _ZN6S199C44v104Ev();
extern void _ZN6S199C44v105Ev();
extern void _ZN6S199C44v106Ev();
extern void _ZN6S199C44v107Ev();
extern void _ZN6S199C44v108Ev();
extern void _ZN6S199C44v109Ev();
extern void _ZN9S199C3_nt4v110Ev();
extern void _ZN9S199C3_nt4v111Ev();
extern void _ZN9S199C3_nt4v112Ev();
extern void _ZN9S199C3_nt4v113Ev();
static  VTBL_ENTRY vtc_S199C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S199C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S199C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S199C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
  (VTBL_ENTRY)&_ZN6S199C53v68Ev,
  (VTBL_ENTRY)&_ZN6S199C53v69Ev,
  (VTBL_ENTRY)&_ZN6S199C53v70Ev,
  (VTBL_ENTRY)&_ZN6S199C53v71Ev,
  (VTBL_ENTRY)&_ZN6S199C53v72Ev,
  (VTBL_ENTRY)&_ZN6S199C53v73Ev,
  (VTBL_ENTRY)&_ZN6S199C53v74Ev,
  (VTBL_ENTRY)&_ZN6S199C53v75Ev,
  (VTBL_ENTRY)&_ZN6S199C53v76Ev,
  (VTBL_ENTRY)&_ZN6S199C53v77Ev,
  (VTBL_ENTRY)&_ZN6S199C53v78Ev,
  (VTBL_ENTRY)&_ZN6S199C53v79Ev,
  (VTBL_ENTRY)&_ZN6S199C53v80Ev,
  (VTBL_ENTRY)&_ZN6S199C53v81Ev,
  (VTBL_ENTRY)&_ZN6S199C53v82Ev,
  (VTBL_ENTRY)&_ZN6S199C53v83Ev,
  (VTBL_ENTRY)&_ZN6S199C53v84Ev,
  (VTBL_ENTRY)&_ZN6S199C53v85Ev,
  (VTBL_ENTRY)&_ZN6S199C53v86Ev,
  (VTBL_ENTRY)&_ZN6S199C53v87Ev,
  (VTBL_ENTRY)&_ZN6S199C53v88Ev,
  (VTBL_ENTRY)&_ZN6S199C53v89Ev,
  (VTBL_ENTRY)&_ZN6S199C43v90Ev,
  (VTBL_ENTRY)&_ZN6S199C43v91Ev,
  (VTBL_ENTRY)&_ZN6S199C43v92Ev,
  (VTBL_ENTRY)&_ZN6S199C43v93Ev,
  (VTBL_ENTRY)&_ZN6S199C43v94Ev,
  (VTBL_ENTRY)&_ZN6S199C43v95Ev,
  (VTBL_ENTRY)&_ZN6S199C43v96Ev,
  (VTBL_ENTRY)&_ZN6S199C43v97Ev,
  (VTBL_ENTRY)&_ZN6S199C43v98Ev,
  (VTBL_ENTRY)&_ZN6S199C43v99Ev,
  (VTBL_ENTRY)&_ZN6S199C44v100Ev,
  (VTBL_ENTRY)&_ZN6S199C44v101Ev,
  (VTBL_ENTRY)&_ZN6S199C44v102Ev,
  (VTBL_ENTRY)&_ZN6S199C44v103Ev,
  (VTBL_ENTRY)&_ZN6S199C44v104Ev,
  (VTBL_ENTRY)&_ZN6S199C44v105Ev,
  (VTBL_ENTRY)&_ZN6S199C44v106Ev,
  (VTBL_ENTRY)&_ZN6S199C44v107Ev,
  (VTBL_ENTRY)&_ZN6S199C44v108Ev,
  (VTBL_ENTRY)&_ZN6S199C44v109Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S199C3_nt[];
VTBL_ENTRY *P__ZTI9S199C3_nt = _ZTI9S199C3_nt; 
extern  VTBL_ENTRY _ZTV9S199C3_nt[];
Class_Descriptor cd_S199C3_nt = {  "S199C3_nt", // class name
  bases_S199C3_nt, 3,
  &(vtc_S199C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S199C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S199C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C2_nt  : S199C3_nt {
  int s199c2f0;
  unsigned int s199c2f1:1;
  virtual  ~S199C2_nt(); // _ZN9S199C2_ntD1Ev
  virtual void  v114(); // _ZN9S199C2_nt4v114Ev
  virtual void  v115(); // _ZN9S199C2_nt4v115Ev
  virtual void  v116(); // _ZN9S199C2_nt4v116Ev
  virtual void  v117(); // _ZN9S199C2_nt4v117Ev
  virtual void  v118(); // _ZN9S199C2_nt4v118Ev
  virtual void  v119(); // _ZN9S199C2_nt4v119Ev
  virtual void  v120(); // _ZN9S199C2_nt4v120Ev
  virtual void  v121(); // _ZN9S199C2_nt4v121Ev
  S199C2_nt(); // tgen
};
//SIG(-1 S199C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S199C2_nt ::~S199C2_nt(){ note_dtor("S199C2_nt", this);}
void  S199C2_nt ::v114(){vfunc_called(this, "_ZN9S199C2_nt4v114Ev");}
void  S199C2_nt ::v115(){vfunc_called(this, "_ZN9S199C2_nt4v115Ev");}
void  S199C2_nt ::v116(){vfunc_called(this, "_ZN9S199C2_nt4v116Ev");}
void  S199C2_nt ::v117(){vfunc_called(this, "_ZN9S199C2_nt4v117Ev");}
void  S199C2_nt ::v118(){vfunc_called(this, "_ZN9S199C2_nt4v118Ev");}
void  S199C2_nt ::v119(){vfunc_called(this, "_ZN9S199C2_nt4v119Ev");}
void  S199C2_nt ::v120(){vfunc_called(this, "_ZN9S199C2_nt4v120Ev");}
void  S199C2_nt ::v121(){vfunc_called(this, "_ZN9S199C2_nt4v121Ev");}
S199C2_nt ::S199C2_nt(){ note_ctor("S199C2_nt", this);} // tgen

//skip512 S199C2_nt

#else // __cplusplus

extern void _ZN9S199C2_ntC1Ev();
extern void _ZN9S199C2_ntD1Ev();
Name_Map name_map_S199C2_nt[] = {
  NSPAIR(_ZN9S199C2_ntC1Ev),
  NSPAIR(_ZN9S199C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S199C6;
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
extern Class_Descriptor cd_S199C5;
extern VTBL_ENTRY _ZTI6S199C5[];
extern  VTBL_ENTRY _ZTV6S199C5[];
extern Class_Descriptor cd_S199C4;
extern VTBL_ENTRY _ZTI6S199C4[];
extern  VTBL_ENTRY _ZTV6S199C4[];
extern Class_Descriptor cd_S199C3_nt;
extern VTBL_ENTRY _ZTI9S199C3_nt[];
extern  VTBL_ENTRY _ZTV9S199C3_nt[];
static Base_Class bases_S199C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S199C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S199C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S199C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S199C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S199C2_nt[];
extern void _ZN9S199C2_ntD1Ev();
extern void _ZN9S199C2_ntD0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
extern void _ZN6S199C53v68Ev();
extern void _ZN6S199C53v69Ev();
extern void _ZN6S199C53v70Ev();
extern void _ZN6S199C53v71Ev();
extern void _ZN6S199C53v72Ev();
extern void _ZN6S199C53v73Ev();
extern void _ZN6S199C53v74Ev();
extern void _ZN6S199C53v75Ev();
extern void _ZN6S199C53v76Ev();
extern void _ZN6S199C53v77Ev();
extern void _ZN6S199C53v78Ev();
extern void _ZN6S199C53v79Ev();
extern void _ZN6S199C53v80Ev();
extern void _ZN6S199C53v81Ev();
extern void _ZN6S199C53v82Ev();
extern void _ZN6S199C53v83Ev();
extern void _ZN6S199C53v84Ev();
extern void _ZN6S199C53v85Ev();
extern void _ZN6S199C53v86Ev();
extern void _ZN6S199C53v87Ev();
extern void _ZN6S199C53v88Ev();
extern void _ZN6S199C53v89Ev();
extern void _ZN6S199C43v90Ev();
extern void _ZN6S199C43v91Ev();
extern void _ZN6S199C43v92Ev();
extern void _ZN6S199C43v93Ev();
extern void _ZN6S199C43v94Ev();
extern void _ZN6S199C43v95Ev();
extern void _ZN6S199C43v96Ev();
extern void _ZN6S199C43v97Ev();
extern void _ZN6S199C43v98Ev();
extern void _ZN6S199C43v99Ev();
extern void _ZN6S199C44v100Ev();
extern void _ZN6S199C44v101Ev();
extern void _ZN6S199C44v102Ev();
extern void _ZN6S199C44v103Ev();
extern void _ZN6S199C44v104Ev();
extern void _ZN6S199C44v105Ev();
extern void _ZN6S199C44v106Ev();
extern void _ZN6S199C44v107Ev();
extern void _ZN6S199C44v108Ev();
extern void _ZN6S199C44v109Ev();
extern void _ZN9S199C3_nt4v110Ev();
extern void _ZN9S199C3_nt4v111Ev();
extern void _ZN9S199C3_nt4v112Ev();
extern void _ZN9S199C3_nt4v113Ev();
extern void _ZN9S199C2_nt4v114Ev();
extern void _ZN9S199C2_nt4v115Ev();
extern void _ZN9S199C2_nt4v116Ev();
extern void _ZN9S199C2_nt4v117Ev();
extern void _ZN9S199C2_nt4v118Ev();
extern void _ZN9S199C2_nt4v119Ev();
extern void _ZN9S199C2_nt4v120Ev();
extern void _ZN9S199C2_nt4v121Ev();
static  VTBL_ENTRY vtc_S199C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S199C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S199C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S199C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
  (VTBL_ENTRY)&_ZN6S199C53v68Ev,
  (VTBL_ENTRY)&_ZN6S199C53v69Ev,
  (VTBL_ENTRY)&_ZN6S199C53v70Ev,
  (VTBL_ENTRY)&_ZN6S199C53v71Ev,
  (VTBL_ENTRY)&_ZN6S199C53v72Ev,
  (VTBL_ENTRY)&_ZN6S199C53v73Ev,
  (VTBL_ENTRY)&_ZN6S199C53v74Ev,
  (VTBL_ENTRY)&_ZN6S199C53v75Ev,
  (VTBL_ENTRY)&_ZN6S199C53v76Ev,
  (VTBL_ENTRY)&_ZN6S199C53v77Ev,
  (VTBL_ENTRY)&_ZN6S199C53v78Ev,
  (VTBL_ENTRY)&_ZN6S199C53v79Ev,
  (VTBL_ENTRY)&_ZN6S199C53v80Ev,
  (VTBL_ENTRY)&_ZN6S199C53v81Ev,
  (VTBL_ENTRY)&_ZN6S199C53v82Ev,
  (VTBL_ENTRY)&_ZN6S199C53v83Ev,
  (VTBL_ENTRY)&_ZN6S199C53v84Ev,
  (VTBL_ENTRY)&_ZN6S199C53v85Ev,
  (VTBL_ENTRY)&_ZN6S199C53v86Ev,
  (VTBL_ENTRY)&_ZN6S199C53v87Ev,
  (VTBL_ENTRY)&_ZN6S199C53v88Ev,
  (VTBL_ENTRY)&_ZN6S199C53v89Ev,
  (VTBL_ENTRY)&_ZN6S199C43v90Ev,
  (VTBL_ENTRY)&_ZN6S199C43v91Ev,
  (VTBL_ENTRY)&_ZN6S199C43v92Ev,
  (VTBL_ENTRY)&_ZN6S199C43v93Ev,
  (VTBL_ENTRY)&_ZN6S199C43v94Ev,
  (VTBL_ENTRY)&_ZN6S199C43v95Ev,
  (VTBL_ENTRY)&_ZN6S199C43v96Ev,
  (VTBL_ENTRY)&_ZN6S199C43v97Ev,
  (VTBL_ENTRY)&_ZN6S199C43v98Ev,
  (VTBL_ENTRY)&_ZN6S199C43v99Ev,
  (VTBL_ENTRY)&_ZN6S199C44v100Ev,
  (VTBL_ENTRY)&_ZN6S199C44v101Ev,
  (VTBL_ENTRY)&_ZN6S199C44v102Ev,
  (VTBL_ENTRY)&_ZN6S199C44v103Ev,
  (VTBL_ENTRY)&_ZN6S199C44v104Ev,
  (VTBL_ENTRY)&_ZN6S199C44v105Ev,
  (VTBL_ENTRY)&_ZN6S199C44v106Ev,
  (VTBL_ENTRY)&_ZN6S199C44v107Ev,
  (VTBL_ENTRY)&_ZN6S199C44v108Ev,
  (VTBL_ENTRY)&_ZN6S199C44v109Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v121Ev,
};
extern VTBL_ENTRY _ZTI9S199C2_nt[];
VTBL_ENTRY *P__ZTI9S199C2_nt = _ZTI9S199C2_nt; 
extern  VTBL_ENTRY _ZTV9S199C2_nt[];
Class_Descriptor cd_S199C2_nt = {  "S199C2_nt", // class name
  bases_S199C2_nt, 4,
  &(vtc_S199C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI9S199C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S199C2_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S199C1  : S199C2_nt {
  ::S499C6_nt s199c1f0;
  ::S499C37_nt s199c1f1;
  virtual  ~S199C1(); // _ZN6S199C1D1Ev
  virtual void  v1(); // _ZN6S199C12v1Ev
  virtual void  v2(); // _ZN6S199C12v2Ev
  virtual void  v3(); // _ZN6S199C12v3Ev
  S199C1(); // tgen
};
//SIG(1 S199C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC9 FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC19{ BC20{ BC11}}} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 FC7 FC8}


 S199C1 ::~S199C1(){ note_dtor("S199C1", this);}
void  S199C1 ::v1(){vfunc_called(this, "_ZN6S199C12v1Ev");}
void  S199C1 ::v2(){vfunc_called(this, "_ZN6S199C12v2Ev");}
void  S199C1 ::v3(){vfunc_called(this, "_ZN6S199C12v3Ev");}
S199C1 ::S199C1(){ note_ctor("S199C1", this);} // tgen

static void Test_S199C1()
{
  extern Class_Descriptor cd_S199C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,63)];
    init_test(&cd_S199C1, buf);
    S199C1 *dp, &lv = *(dp=new (buf) S199C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,248), "sizeof(S199C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S199C1)");
    check_base_class_offset(lv, (S199C6*)(S199C5*)(S199C4*)(S199C3_nt*)(S199C2_nt*), 0, "S199C1");
    check_base_class_offset(lv, (S199C5*)(S199C4*)(S199C3_nt*)(S199C2_nt*), 0, "S199C1");
    check_base_class_offset(lv, (S199C4*)(S199C3_nt*)(S199C2_nt*), 0, "S199C1");
    check_base_class_offset(lv, (S199C3_nt*)(S199C2_nt*), 0, "S199C1");
    check_base_class_offset(lv, (S199C2_nt*), 0, "S199C1");
    check_field_offset(lv, s199c1f0, ABISELECT(304,228), "S199C1.s199c1f0");
    check_field_offset(lv, s199c1f1, ABISELECT(312,236), "S199C1.s199c1f1");
    test_class_info(&lv, &cd_S199C1);
    dp->~S199C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS199C1(Test_S199C1, "S199C1", ABISELECT(328,248));

#else // __cplusplus

extern void _ZN6S199C1C1Ev();
extern void _ZN6S199C1D1Ev();
Name_Map name_map_S199C1[] = {
  NSPAIR(_ZN6S199C1C1Ev),
  NSPAIR(_ZN6S199C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S199C6;
extern VTBL_ENTRY _ZTI6S199C6[];
extern  VTBL_ENTRY _ZTV6S199C6[];
extern Class_Descriptor cd_S199C5;
extern VTBL_ENTRY _ZTI6S199C5[];
extern  VTBL_ENTRY _ZTV6S199C5[];
extern Class_Descriptor cd_S199C4;
extern VTBL_ENTRY _ZTI6S199C4[];
extern  VTBL_ENTRY _ZTV6S199C4[];
extern Class_Descriptor cd_S199C3_nt;
extern VTBL_ENTRY _ZTI9S199C3_nt[];
extern  VTBL_ENTRY _ZTV9S199C3_nt[];
extern Class_Descriptor cd_S199C2_nt;
extern VTBL_ENTRY _ZTI9S199C2_nt[];
extern  VTBL_ENTRY _ZTV9S199C2_nt[];
static Base_Class bases_S199C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S199C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S199C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S199C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S199C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S199C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S199C1[];
extern void _ZN6S199C1D1Ev();
extern void _ZN6S199C1D0Ev();
extern void _ZN6S199C62v4Ev();
extern void _ZN6S199C62v5Ev();
extern void _ZN6S199C62v6Ev();
extern void _ZN6S199C62v7Ev();
extern void _ZN6S199C62v8Ev();
extern void _ZN6S199C62v9Ev();
extern void _ZN6S199C63v10Ev();
extern void _ZN6S199C63v11Ev();
extern void _ZN6S199C63v12Ev();
extern void _ZN6S199C63v13Ev();
extern void _ZN6S199C63v14Ev();
extern void _ZN6S199C63v15Ev();
extern void _ZN6S199C63v16Ev();
extern void _ZN6S199C63v17Ev();
extern void _ZN6S199C63v18Ev();
extern void _ZN6S199C63v19Ev();
extern void _ZN6S199C63v20Ev();
extern void _ZN6S199C63v21Ev();
extern void _ZN6S199C63v22Ev();
extern void _ZN6S199C63v23Ev();
extern void _ZN6S199C63v24Ev();
extern void _ZN6S199C63v25Ev();
extern void _ZN6S199C63v26Ev();
extern void _ZN6S199C63v27Ev();
extern void _ZN6S199C63v28Ev();
extern void _ZN6S199C63v29Ev();
extern void _ZN6S199C63v30Ev();
extern void _ZN6S199C63v31Ev();
extern void _ZN6S199C63v32Ev();
extern void _ZN6S199C63v33Ev();
extern void _ZN6S199C63v34Ev();
extern void _ZN6S199C63v35Ev();
extern void _ZN6S199C63v36Ev();
extern void _ZN6S199C63v37Ev();
extern void _ZN6S199C63v38Ev();
extern void _ZN6S199C63v39Ev();
extern void _ZN6S199C63v40Ev();
extern void _ZN6S199C63v41Ev();
extern void _ZN6S199C63v42Ev();
extern void _ZN6S199C63v43Ev();
extern void _ZN6S199C63v44Ev();
extern void _ZN6S199C63v45Ev();
extern void _ZN6S199C63v46Ev();
extern void _ZN6S199C63v47Ev();
extern void _ZN6S199C63v48Ev();
extern void _ZN6S199C63v49Ev();
extern void _ZN6S199C63v50Ev();
extern void _ZN6S199C63v51Ev();
extern void _ZN6S199C63v52Ev();
extern void _ZN6S199C63v53Ev();
extern void _ZN6S199C63v54Ev();
extern void _ZN6S199C63v55Ev();
extern void _ZN6S199C63v56Ev();
extern void _ZN6S199C63v57Ev();
extern void _ZN6S199C63v58Ev();
extern void _ZN6S199C63v59Ev();
extern void _ZN6S199C63v60Ev();
extern void _ZN6S199C63v61Ev();
extern void _ZN6S199C63v62Ev();
extern void _ZN6S199C63v63Ev();
extern void _ZN6S199C63v64Ev();
extern void _ZN6S199C63v65Ev();
extern void _ZN6S199C63v66Ev();
extern void _ZN6S199C63v67Ev();
extern void _ZN6S199C53v68Ev();
extern void _ZN6S199C53v69Ev();
extern void _ZN6S199C53v70Ev();
extern void _ZN6S199C53v71Ev();
extern void _ZN6S199C53v72Ev();
extern void _ZN6S199C53v73Ev();
extern void _ZN6S199C53v74Ev();
extern void _ZN6S199C53v75Ev();
extern void _ZN6S199C53v76Ev();
extern void _ZN6S199C53v77Ev();
extern void _ZN6S199C53v78Ev();
extern void _ZN6S199C53v79Ev();
extern void _ZN6S199C53v80Ev();
extern void _ZN6S199C53v81Ev();
extern void _ZN6S199C53v82Ev();
extern void _ZN6S199C53v83Ev();
extern void _ZN6S199C53v84Ev();
extern void _ZN6S199C53v85Ev();
extern void _ZN6S199C53v86Ev();
extern void _ZN6S199C53v87Ev();
extern void _ZN6S199C53v88Ev();
extern void _ZN6S199C53v89Ev();
extern void _ZN6S199C43v90Ev();
extern void _ZN6S199C43v91Ev();
extern void _ZN6S199C43v92Ev();
extern void _ZN6S199C43v93Ev();
extern void _ZN6S199C43v94Ev();
extern void _ZN6S199C43v95Ev();
extern void _ZN6S199C43v96Ev();
extern void _ZN6S199C43v97Ev();
extern void _ZN6S199C43v98Ev();
extern void _ZN6S199C43v99Ev();
extern void _ZN6S199C44v100Ev();
extern void _ZN6S199C44v101Ev();
extern void _ZN6S199C44v102Ev();
extern void _ZN6S199C44v103Ev();
extern void _ZN6S199C44v104Ev();
extern void _ZN6S199C44v105Ev();
extern void _ZN6S199C44v106Ev();
extern void _ZN6S199C44v107Ev();
extern void _ZN6S199C44v108Ev();
extern void _ZN6S199C44v109Ev();
extern void _ZN9S199C3_nt4v110Ev();
extern void _ZN9S199C3_nt4v111Ev();
extern void _ZN9S199C3_nt4v112Ev();
extern void _ZN9S199C3_nt4v113Ev();
extern void _ZN9S199C2_nt4v114Ev();
extern void _ZN9S199C2_nt4v115Ev();
extern void _ZN9S199C2_nt4v116Ev();
extern void _ZN9S199C2_nt4v117Ev();
extern void _ZN9S199C2_nt4v118Ev();
extern void _ZN9S199C2_nt4v119Ev();
extern void _ZN9S199C2_nt4v120Ev();
extern void _ZN9S199C2_nt4v121Ev();
extern void _ZN6S199C12v1Ev();
extern void _ZN6S199C12v2Ev();
extern void _ZN6S199C12v3Ev();
static  VTBL_ENTRY vtc_S199C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S199C1[0]),
  (VTBL_ENTRY)&_ZN6S199C1D1Ev,
  (VTBL_ENTRY)&_ZN6S199C1D0Ev,
  (VTBL_ENTRY)&_ZN6S199C62v4Ev,
  (VTBL_ENTRY)&_ZN6S199C62v5Ev,
  (VTBL_ENTRY)&_ZN6S199C62v6Ev,
  (VTBL_ENTRY)&_ZN6S199C62v7Ev,
  (VTBL_ENTRY)&_ZN6S199C62v8Ev,
  (VTBL_ENTRY)&_ZN6S199C62v9Ev,
  (VTBL_ENTRY)&_ZN6S199C63v10Ev,
  (VTBL_ENTRY)&_ZN6S199C63v11Ev,
  (VTBL_ENTRY)&_ZN6S199C63v12Ev,
  (VTBL_ENTRY)&_ZN6S199C63v13Ev,
  (VTBL_ENTRY)&_ZN6S199C63v14Ev,
  (VTBL_ENTRY)&_ZN6S199C63v15Ev,
  (VTBL_ENTRY)&_ZN6S199C63v16Ev,
  (VTBL_ENTRY)&_ZN6S199C63v17Ev,
  (VTBL_ENTRY)&_ZN6S199C63v18Ev,
  (VTBL_ENTRY)&_ZN6S199C63v19Ev,
  (VTBL_ENTRY)&_ZN6S199C63v20Ev,
  (VTBL_ENTRY)&_ZN6S199C63v21Ev,
  (VTBL_ENTRY)&_ZN6S199C63v22Ev,
  (VTBL_ENTRY)&_ZN6S199C63v23Ev,
  (VTBL_ENTRY)&_ZN6S199C63v24Ev,
  (VTBL_ENTRY)&_ZN6S199C63v25Ev,
  (VTBL_ENTRY)&_ZN6S199C63v26Ev,
  (VTBL_ENTRY)&_ZN6S199C63v27Ev,
  (VTBL_ENTRY)&_ZN6S199C63v28Ev,
  (VTBL_ENTRY)&_ZN6S199C63v29Ev,
  (VTBL_ENTRY)&_ZN6S199C63v30Ev,
  (VTBL_ENTRY)&_ZN6S199C63v31Ev,
  (VTBL_ENTRY)&_ZN6S199C63v32Ev,
  (VTBL_ENTRY)&_ZN6S199C63v33Ev,
  (VTBL_ENTRY)&_ZN6S199C63v34Ev,
  (VTBL_ENTRY)&_ZN6S199C63v35Ev,
  (VTBL_ENTRY)&_ZN6S199C63v36Ev,
  (VTBL_ENTRY)&_ZN6S199C63v37Ev,
  (VTBL_ENTRY)&_ZN6S199C63v38Ev,
  (VTBL_ENTRY)&_ZN6S199C63v39Ev,
  (VTBL_ENTRY)&_ZN6S199C63v40Ev,
  (VTBL_ENTRY)&_ZN6S199C63v41Ev,
  (VTBL_ENTRY)&_ZN6S199C63v42Ev,
  (VTBL_ENTRY)&_ZN6S199C63v43Ev,
  (VTBL_ENTRY)&_ZN6S199C63v44Ev,
  (VTBL_ENTRY)&_ZN6S199C63v45Ev,
  (VTBL_ENTRY)&_ZN6S199C63v46Ev,
  (VTBL_ENTRY)&_ZN6S199C63v47Ev,
  (VTBL_ENTRY)&_ZN6S199C63v48Ev,
  (VTBL_ENTRY)&_ZN6S199C63v49Ev,
  (VTBL_ENTRY)&_ZN6S199C63v50Ev,
  (VTBL_ENTRY)&_ZN6S199C63v51Ev,
  (VTBL_ENTRY)&_ZN6S199C63v52Ev,
  (VTBL_ENTRY)&_ZN6S199C63v53Ev,
  (VTBL_ENTRY)&_ZN6S199C63v54Ev,
  (VTBL_ENTRY)&_ZN6S199C63v55Ev,
  (VTBL_ENTRY)&_ZN6S199C63v56Ev,
  (VTBL_ENTRY)&_ZN6S199C63v57Ev,
  (VTBL_ENTRY)&_ZN6S199C63v58Ev,
  (VTBL_ENTRY)&_ZN6S199C63v59Ev,
  (VTBL_ENTRY)&_ZN6S199C63v60Ev,
  (VTBL_ENTRY)&_ZN6S199C63v61Ev,
  (VTBL_ENTRY)&_ZN6S199C63v62Ev,
  (VTBL_ENTRY)&_ZN6S199C63v63Ev,
  (VTBL_ENTRY)&_ZN6S199C63v64Ev,
  (VTBL_ENTRY)&_ZN6S199C63v65Ev,
  (VTBL_ENTRY)&_ZN6S199C63v66Ev,
  (VTBL_ENTRY)&_ZN6S199C63v67Ev,
  (VTBL_ENTRY)&_ZN6S199C53v68Ev,
  (VTBL_ENTRY)&_ZN6S199C53v69Ev,
  (VTBL_ENTRY)&_ZN6S199C53v70Ev,
  (VTBL_ENTRY)&_ZN6S199C53v71Ev,
  (VTBL_ENTRY)&_ZN6S199C53v72Ev,
  (VTBL_ENTRY)&_ZN6S199C53v73Ev,
  (VTBL_ENTRY)&_ZN6S199C53v74Ev,
  (VTBL_ENTRY)&_ZN6S199C53v75Ev,
  (VTBL_ENTRY)&_ZN6S199C53v76Ev,
  (VTBL_ENTRY)&_ZN6S199C53v77Ev,
  (VTBL_ENTRY)&_ZN6S199C53v78Ev,
  (VTBL_ENTRY)&_ZN6S199C53v79Ev,
  (VTBL_ENTRY)&_ZN6S199C53v80Ev,
  (VTBL_ENTRY)&_ZN6S199C53v81Ev,
  (VTBL_ENTRY)&_ZN6S199C53v82Ev,
  (VTBL_ENTRY)&_ZN6S199C53v83Ev,
  (VTBL_ENTRY)&_ZN6S199C53v84Ev,
  (VTBL_ENTRY)&_ZN6S199C53v85Ev,
  (VTBL_ENTRY)&_ZN6S199C53v86Ev,
  (VTBL_ENTRY)&_ZN6S199C53v87Ev,
  (VTBL_ENTRY)&_ZN6S199C53v88Ev,
  (VTBL_ENTRY)&_ZN6S199C53v89Ev,
  (VTBL_ENTRY)&_ZN6S199C43v90Ev,
  (VTBL_ENTRY)&_ZN6S199C43v91Ev,
  (VTBL_ENTRY)&_ZN6S199C43v92Ev,
  (VTBL_ENTRY)&_ZN6S199C43v93Ev,
  (VTBL_ENTRY)&_ZN6S199C43v94Ev,
  (VTBL_ENTRY)&_ZN6S199C43v95Ev,
  (VTBL_ENTRY)&_ZN6S199C43v96Ev,
  (VTBL_ENTRY)&_ZN6S199C43v97Ev,
  (VTBL_ENTRY)&_ZN6S199C43v98Ev,
  (VTBL_ENTRY)&_ZN6S199C43v99Ev,
  (VTBL_ENTRY)&_ZN6S199C44v100Ev,
  (VTBL_ENTRY)&_ZN6S199C44v101Ev,
  (VTBL_ENTRY)&_ZN6S199C44v102Ev,
  (VTBL_ENTRY)&_ZN6S199C44v103Ev,
  (VTBL_ENTRY)&_ZN6S199C44v104Ev,
  (VTBL_ENTRY)&_ZN6S199C44v105Ev,
  (VTBL_ENTRY)&_ZN6S199C44v106Ev,
  (VTBL_ENTRY)&_ZN6S199C44v107Ev,
  (VTBL_ENTRY)&_ZN6S199C44v108Ev,
  (VTBL_ENTRY)&_ZN6S199C44v109Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S199C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S199C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN6S199C12v1Ev,
  (VTBL_ENTRY)&_ZN6S199C12v2Ev,
  (VTBL_ENTRY)&_ZN6S199C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S199C1[];
extern  VTBL_ENTRY _ZTV6S199C1[];
Class_Descriptor cd_S199C1 = {  "S199C1", // class name
  bases_S199C1, 5,
  &(vtc_S199C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,248), // object size
  NSPAIRA(_ZTI6S199C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S199C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S584C5  {
  int s584c5f0;
  __tsi64 s584c5f1;
  void *s584c5f2[4];
  int s584c5f3[2];
  void *s584c5f4;
  ::S499C6_nt s584c5f5;
  void *s584c5f6[2];
  virtual  ~S584C5(); // _ZN6S584C5D1Ev
  virtual void  v4(); // _ZN6S584C52v4Ev
  virtual void  v5(); // _ZN6S584C52v5Ev
  virtual void  v6(); // _ZN6S584C52v6Ev
  virtual void  v7(); // _ZN6S584C52v7Ev
  virtual void  v8(); // _ZN6S584C52v8Ev
  virtual void  v9(); // _ZN6S584C52v9Ev
  virtual void  v10(); // _ZN6S584C53v10Ev
  virtual void  v11(); // _ZN6S584C53v11Ev
  virtual void  v12(); // _ZN6S584C53v12Ev
  virtual void  v13(); // _ZN6S584C53v13Ev
  virtual void  v14(); // _ZN6S584C53v14Ev
  virtual void  v15(); // _ZN6S584C53v15Ev
  virtual void  v16(); // _ZN6S584C53v16Ev
  virtual void  v17(); // _ZN6S584C53v17Ev
  virtual void  v18(); // _ZN6S584C53v18Ev
  virtual void  v19(); // _ZN6S584C53v19Ev
  virtual void  v20(); // _ZN6S584C53v20Ev
  virtual void  v21(); // _ZN6S584C53v21Ev
  virtual void  v22(); // _ZN6S584C53v22Ev
  virtual void  v23(); // _ZN6S584C53v23Ev
  virtual void  v24(); // _ZN6S584C53v24Ev
  virtual void  v25(); // _ZN6S584C53v25Ev
  virtual void  v26(); // _ZN6S584C53v26Ev
  virtual void  v27(); // _ZN6S584C53v27Ev
  virtual void  v28(); // _ZN6S584C53v28Ev
  virtual void  v29(); // _ZN6S584C53v29Ev
  virtual void  v30(); // _ZN6S584C53v30Ev
  virtual void  v31(); // _ZN6S584C53v31Ev
  virtual void  v32(); // _ZN6S584C53v32Ev
  virtual void  v33(); // _ZN6S584C53v33Ev
  virtual void  v34(); // _ZN6S584C53v34Ev
  virtual void  v35(); // _ZN6S584C53v35Ev
  virtual void  v36(); // _ZN6S584C53v36Ev
  virtual void  v37(); // _ZN6S584C53v37Ev
  virtual void  v38(); // _ZN6S584C53v38Ev
  virtual void  v39(); // _ZN6S584C53v39Ev
  virtual void  v40(); // _ZN6S584C53v40Ev
  virtual void  v41(); // _ZN6S584C53v41Ev
  virtual void  v42(); // _ZN6S584C53v42Ev
  virtual void  v43(); // _ZN6S584C53v43Ev
  virtual void  v44(); // _ZN6S584C53v44Ev
  virtual void  v45(); // _ZN6S584C53v45Ev
  virtual void  v46(); // _ZN6S584C53v46Ev
  virtual void  v47(); // _ZN6S584C53v47Ev
  virtual void  v48(); // _ZN6S584C53v48Ev
  virtual void  v49(); // _ZN6S584C53v49Ev
  virtual void  v50(); // _ZN6S584C53v50Ev
  virtual void  v51(); // _ZN6S584C53v51Ev
  virtual void  v52(); // _ZN6S584C53v52Ev
  virtual void  v53(); // _ZN6S584C53v53Ev
  virtual void  v54(); // _ZN6S584C53v54Ev
  virtual void  v55(); // _ZN6S584C53v55Ev
  virtual void  v56(); // _ZN6S584C53v56Ev
  virtual void  v57(); // _ZN6S584C53v57Ev
  virtual void  v58(); // _ZN6S584C53v58Ev
  virtual void  v59(); // _ZN6S584C53v59Ev
  virtual void  v60(); // _ZN6S584C53v60Ev
  virtual void  v61(); // _ZN6S584C53v61Ev
  virtual void  v62(); // _ZN6S584C53v62Ev
  virtual void  v63(); // _ZN6S584C53v63Ev
  virtual void  v64(); // _ZN6S584C53v64Ev
  virtual void  v65(); // _ZN6S584C53v65Ev
  virtual void  v66(); // _ZN6S584C53v66Ev
  virtual void  v67(); // _ZN6S584C53v67Ev
  S584C5(); // tgen
};
//SIG(-1 S584C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S584C5 ::~S584C5(){ note_dtor("S584C5", this);}
void  S584C5 ::v4(){vfunc_called(this, "_ZN6S584C52v4Ev");}
void  S584C5 ::v5(){vfunc_called(this, "_ZN6S584C52v5Ev");}
void  S584C5 ::v6(){vfunc_called(this, "_ZN6S584C52v6Ev");}
void  S584C5 ::v7(){vfunc_called(this, "_ZN6S584C52v7Ev");}
void  S584C5 ::v8(){vfunc_called(this, "_ZN6S584C52v8Ev");}
void  S584C5 ::v9(){vfunc_called(this, "_ZN6S584C52v9Ev");}
void  S584C5 ::v10(){vfunc_called(this, "_ZN6S584C53v10Ev");}
void  S584C5 ::v11(){vfunc_called(this, "_ZN6S584C53v11Ev");}
void  S584C5 ::v12(){vfunc_called(this, "_ZN6S584C53v12Ev");}
void  S584C5 ::v13(){vfunc_called(this, "_ZN6S584C53v13Ev");}
void  S584C5 ::v14(){vfunc_called(this, "_ZN6S584C53v14Ev");}
void  S584C5 ::v15(){vfunc_called(this, "_ZN6S584C53v15Ev");}
void  S584C5 ::v16(){vfunc_called(this, "_ZN6S584C53v16Ev");}
void  S584C5 ::v17(){vfunc_called(this, "_ZN6S584C53v17Ev");}
void  S584C5 ::v18(){vfunc_called(this, "_ZN6S584C53v18Ev");}
void  S584C5 ::v19(){vfunc_called(this, "_ZN6S584C53v19Ev");}
void  S584C5 ::v20(){vfunc_called(this, "_ZN6S584C53v20Ev");}
void  S584C5 ::v21(){vfunc_called(this, "_ZN6S584C53v21Ev");}
void  S584C5 ::v22(){vfunc_called(this, "_ZN6S584C53v22Ev");}
void  S584C5 ::v23(){vfunc_called(this, "_ZN6S584C53v23Ev");}
void  S584C5 ::v24(){vfunc_called(this, "_ZN6S584C53v24Ev");}
void  S584C5 ::v25(){vfunc_called(this, "_ZN6S584C53v25Ev");}
void  S584C5 ::v26(){vfunc_called(this, "_ZN6S584C53v26Ev");}
void  S584C5 ::v27(){vfunc_called(this, "_ZN6S584C53v27Ev");}
void  S584C5 ::v28(){vfunc_called(this, "_ZN6S584C53v28Ev");}
void  S584C5 ::v29(){vfunc_called(this, "_ZN6S584C53v29Ev");}
void  S584C5 ::v30(){vfunc_called(this, "_ZN6S584C53v30Ev");}
void  S584C5 ::v31(){vfunc_called(this, "_ZN6S584C53v31Ev");}
void  S584C5 ::v32(){vfunc_called(this, "_ZN6S584C53v32Ev");}
void  S584C5 ::v33(){vfunc_called(this, "_ZN6S584C53v33Ev");}
void  S584C5 ::v34(){vfunc_called(this, "_ZN6S584C53v34Ev");}
void  S584C5 ::v35(){vfunc_called(this, "_ZN6S584C53v35Ev");}
void  S584C5 ::v36(){vfunc_called(this, "_ZN6S584C53v36Ev");}
void  S584C5 ::v37(){vfunc_called(this, "_ZN6S584C53v37Ev");}
void  S584C5 ::v38(){vfunc_called(this, "_ZN6S584C53v38Ev");}
void  S584C5 ::v39(){vfunc_called(this, "_ZN6S584C53v39Ev");}
void  S584C5 ::v40(){vfunc_called(this, "_ZN6S584C53v40Ev");}
void  S584C5 ::v41(){vfunc_called(this, "_ZN6S584C53v41Ev");}
void  S584C5 ::v42(){vfunc_called(this, "_ZN6S584C53v42Ev");}
void  S584C5 ::v43(){vfunc_called(this, "_ZN6S584C53v43Ev");}
void  S584C5 ::v44(){vfunc_called(this, "_ZN6S584C53v44Ev");}
void  S584C5 ::v45(){vfunc_called(this, "_ZN6S584C53v45Ev");}
void  S584C5 ::v46(){vfunc_called(this, "_ZN6S584C53v46Ev");}
void  S584C5 ::v47(){vfunc_called(this, "_ZN6S584C53v47Ev");}
void  S584C5 ::v48(){vfunc_called(this, "_ZN6S584C53v48Ev");}
void  S584C5 ::v49(){vfunc_called(this, "_ZN6S584C53v49Ev");}
void  S584C5 ::v50(){vfunc_called(this, "_ZN6S584C53v50Ev");}
void  S584C5 ::v51(){vfunc_called(this, "_ZN6S584C53v51Ev");}
void  S584C5 ::v52(){vfunc_called(this, "_ZN6S584C53v52Ev");}
void  S584C5 ::v53(){vfunc_called(this, "_ZN6S584C53v53Ev");}
void  S584C5 ::v54(){vfunc_called(this, "_ZN6S584C53v54Ev");}
void  S584C5 ::v55(){vfunc_called(this, "_ZN6S584C53v55Ev");}
void  S584C5 ::v56(){vfunc_called(this, "_ZN6S584C53v56Ev");}
void  S584C5 ::v57(){vfunc_called(this, "_ZN6S584C53v57Ev");}
void  S584C5 ::v58(){vfunc_called(this, "_ZN6S584C53v58Ev");}
void  S584C5 ::v59(){vfunc_called(this, "_ZN6S584C53v59Ev");}
void  S584C5 ::v60(){vfunc_called(this, "_ZN6S584C53v60Ev");}
void  S584C5 ::v61(){vfunc_called(this, "_ZN6S584C53v61Ev");}
void  S584C5 ::v62(){vfunc_called(this, "_ZN6S584C53v62Ev");}
void  S584C5 ::v63(){vfunc_called(this, "_ZN6S584C53v63Ev");}
void  S584C5 ::v64(){vfunc_called(this, "_ZN6S584C53v64Ev");}
void  S584C5 ::v65(){vfunc_called(this, "_ZN6S584C53v65Ev");}
void  S584C5 ::v66(){vfunc_called(this, "_ZN6S584C53v66Ev");}
void  S584C5 ::v67(){vfunc_called(this, "_ZN6S584C53v67Ev");}
S584C5 ::S584C5(){ note_ctor("S584C5", this);} // tgen

static void Test_S584C5()
{
  extern Class_Descriptor cd_S584C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S584C5, buf);
    S584C5 *dp, &lv = *(dp=new (buf) S584C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S584C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S584C5)");
    check_field_offset(lv, s584c5f0, ABISELECT(8,4), "S584C5.s584c5f0");
    check_field_offset(lv, s584c5f1, ABISELECT(16,8), "S584C5.s584c5f1");
    check_field_offset(lv, s584c5f2, ABISELECT(24,16), "S584C5.s584c5f2");
    check_field_offset(lv, s584c5f3, ABISELECT(56,32), "S584C5.s584c5f3");
    check_field_offset(lv, s584c5f4, ABISELECT(64,40), "S584C5.s584c5f4");
    check_field_offset(lv, s584c5f5, ABISELECT(72,44), "S584C5.s584c5f5");
    check_field_offset(lv, s584c5f6, ABISELECT(80,52), "S584C5.s584c5f6");
    test_class_info(&lv, &cd_S584C5);
    dp->~S584C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS584C5(Test_S584C5, "S584C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S584C5C1Ev();
extern void _ZN6S584C5D1Ev();
Name_Map name_map_S584C5[] = {
  NSPAIR(_ZN6S584C5C1Ev),
  NSPAIR(_ZN6S584C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S584C5[];
extern void _ZN6S584C5D1Ev();
extern void _ZN6S584C5D0Ev();
extern void _ZN6S584C52v4Ev();
extern void _ZN6S584C52v5Ev();
extern void _ZN6S584C52v6Ev();
extern void _ZN6S584C52v7Ev();
extern void _ZN6S584C52v8Ev();
extern void _ZN6S584C52v9Ev();
extern void _ZN6S584C53v10Ev();
extern void _ZN6S584C53v11Ev();
extern void _ZN6S584C53v12Ev();
extern void _ZN6S584C53v13Ev();
extern void _ZN6S584C53v14Ev();
extern void _ZN6S584C53v15Ev();
extern void _ZN6S584C53v16Ev();
extern void _ZN6S584C53v17Ev();
extern void _ZN6S584C53v18Ev();
extern void _ZN6S584C53v19Ev();
extern void _ZN6S584C53v20Ev();
extern void _ZN6S584C53v21Ev();
extern void _ZN6S584C53v22Ev();
extern void _ZN6S584C53v23Ev();
extern void _ZN6S584C53v24Ev();
extern void _ZN6S584C53v25Ev();
extern void _ZN6S584C53v26Ev();
extern void _ZN6S584C53v27Ev();
extern void _ZN6S584C53v28Ev();
extern void _ZN6S584C53v29Ev();
extern void _ZN6S584C53v30Ev();
extern void _ZN6S584C53v31Ev();
extern void _ZN6S584C53v32Ev();
extern void _ZN6S584C53v33Ev();
extern void _ZN6S584C53v34Ev();
extern void _ZN6S584C53v35Ev();
extern void _ZN6S584C53v36Ev();
extern void _ZN6S584C53v37Ev();
extern void _ZN6S584C53v38Ev();
extern void _ZN6S584C53v39Ev();
extern void _ZN6S584C53v40Ev();
extern void _ZN6S584C53v41Ev();
extern void _ZN6S584C53v42Ev();
extern void _ZN6S584C53v43Ev();
extern void _ZN6S584C53v44Ev();
extern void _ZN6S584C53v45Ev();
extern void _ZN6S584C53v46Ev();
extern void _ZN6S584C53v47Ev();
extern void _ZN6S584C53v48Ev();
extern void _ZN6S584C53v49Ev();
extern void _ZN6S584C53v50Ev();
extern void _ZN6S584C53v51Ev();
extern void _ZN6S584C53v52Ev();
extern void _ZN6S584C53v53Ev();
extern void _ZN6S584C53v54Ev();
extern void _ZN6S584C53v55Ev();
extern void _ZN6S584C53v56Ev();
extern void _ZN6S584C53v57Ev();
extern void _ZN6S584C53v58Ev();
extern void _ZN6S584C53v59Ev();
extern void _ZN6S584C53v60Ev();
extern void _ZN6S584C53v61Ev();
extern void _ZN6S584C53v62Ev();
extern void _ZN6S584C53v63Ev();
extern void _ZN6S584C53v64Ev();
extern void _ZN6S584C53v65Ev();
extern void _ZN6S584C53v66Ev();
extern void _ZN6S584C53v67Ev();
static  VTBL_ENTRY vtc_S584C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S584C5[0]),
  (VTBL_ENTRY)&_ZN6S584C5D1Ev,
  (VTBL_ENTRY)&_ZN6S584C5D0Ev,
  (VTBL_ENTRY)&_ZN6S584C52v4Ev,
  (VTBL_ENTRY)&_ZN6S584C52v5Ev,
  (VTBL_ENTRY)&_ZN6S584C52v6Ev,
  (VTBL_ENTRY)&_ZN6S584C52v7Ev,
  (VTBL_ENTRY)&_ZN6S584C52v8Ev,
  (VTBL_ENTRY)&_ZN6S584C52v9Ev,
  (VTBL_ENTRY)&_ZN6S584C53v10Ev,
  (VTBL_ENTRY)&_ZN6S584C53v11Ev,
  (VTBL_ENTRY)&_ZN6S584C53v12Ev,
  (VTBL_ENTRY)&_ZN6S584C53v13Ev,
  (VTBL_ENTRY)&_ZN6S584C53v14Ev,
  (VTBL_ENTRY)&_ZN6S584C53v15Ev,
  (VTBL_ENTRY)&_ZN6S584C53v16Ev,
  (VTBL_ENTRY)&_ZN6S584C53v17Ev,
  (VTBL_ENTRY)&_ZN6S584C53v18Ev,
  (VTBL_ENTRY)&_ZN6S584C53v19Ev,
  (VTBL_ENTRY)&_ZN6S584C53v20Ev,
  (VTBL_ENTRY)&_ZN6S584C53v21Ev,
  (VTBL_ENTRY)&_ZN6S584C53v22Ev,
  (VTBL_ENTRY)&_ZN6S584C53v23Ev,
  (VTBL_ENTRY)&_ZN6S584C53v24Ev,
  (VTBL_ENTRY)&_ZN6S584C53v25Ev,
  (VTBL_ENTRY)&_ZN6S584C53v26Ev,
  (VTBL_ENTRY)&_ZN6S584C53v27Ev,
  (VTBL_ENTRY)&_ZN6S584C53v28Ev,
  (VTBL_ENTRY)&_ZN6S584C53v29Ev,
  (VTBL_ENTRY)&_ZN6S584C53v30Ev,
  (VTBL_ENTRY)&_ZN6S584C53v31Ev,
  (VTBL_ENTRY)&_ZN6S584C53v32Ev,
  (VTBL_ENTRY)&_ZN6S584C53v33Ev,
  (VTBL_ENTRY)&_ZN6S584C53v34Ev,
  (VTBL_ENTRY)&_ZN6S584C53v35Ev,
  (VTBL_ENTRY)&_ZN6S584C53v36Ev,
  (VTBL_ENTRY)&_ZN6S584C53v37Ev,
  (VTBL_ENTRY)&_ZN6S584C53v38Ev,
  (VTBL_ENTRY)&_ZN6S584C53v39Ev,
  (VTBL_ENTRY)&_ZN6S584C53v40Ev,
  (VTBL_ENTRY)&_ZN6S584C53v41Ev,
  (VTBL_ENTRY)&_ZN6S584C53v42Ev,
  (VTBL_ENTRY)&_ZN6S584C53v43Ev,
  (VTBL_ENTRY)&_ZN6S584C53v44Ev,
  (VTBL_ENTRY)&_ZN6S584C53v45Ev,
  (VTBL_ENTRY)&_ZN6S584C53v46Ev,
  (VTBL_ENTRY)&_ZN6S584C53v47Ev,
  (VTBL_ENTRY)&_ZN6S584C53v48Ev,
  (VTBL_ENTRY)&_ZN6S584C53v49Ev,
  (VTBL_ENTRY)&_ZN6S584C53v50Ev,
  (VTBL_ENTRY)&_ZN6S584C53v51Ev,
  (VTBL_ENTRY)&_ZN6S584C53v52Ev,
  (VTBL_ENTRY)&_ZN6S584C53v53Ev,
  (VTBL_ENTRY)&_ZN6S584C53v54Ev,
  (VTBL_ENTRY)&_ZN6S584C53v55Ev,
  (VTBL_ENTRY)&_ZN6S584C53v56Ev,
  (VTBL_ENTRY)&_ZN6S584C53v57Ev,
  (VTBL_ENTRY)&_ZN6S584C53v58Ev,
  (VTBL_ENTRY)&_ZN6S584C53v59Ev,
  (VTBL_ENTRY)&_ZN6S584C53v60Ev,
  (VTBL_ENTRY)&_ZN6S584C53v61Ev,
  (VTBL_ENTRY)&_ZN6S584C53v62Ev,
  (VTBL_ENTRY)&_ZN6S584C53v63Ev,
  (VTBL_ENTRY)&_ZN6S584C53v64Ev,
  (VTBL_ENTRY)&_ZN6S584C53v65Ev,
  (VTBL_ENTRY)&_ZN6S584C53v66Ev,
  (VTBL_ENTRY)&_ZN6S584C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S584C5[];
extern  VTBL_ENTRY _ZTV6S584C5[];
Class_Descriptor cd_S584C5 = {  "S584C5", // class name
  0,0,//no base classes
  &(vtc_S584C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S584C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S584C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S584C4  : S584C5 {
  int s584c4f0[2];
  void *s584c4f1;
  int s584c4f2[2];
  ::S499C37_nt s584c4f3;
  ::S499C37_nt s584c4f4;
  ::S7368C78 s584c4f5;
  ::S499C37_nt s584c4f6;
  unsigned int s584c4f7:1;
  unsigned int s584c4f8:1;
  unsigned int s584c4f9:1;
  unsigned int s584c4f10:1;
  unsigned int s584c4f11:1;
  int s584c4f12[2];
  virtual  ~S584C4(); // _ZN6S584C4D1Ev
  virtual void  v68(); // _ZN6S584C43v68Ev
  virtual void  v69(); // _ZN6S584C43v69Ev
  virtual void  v70(); // _ZN6S584C43v70Ev
  virtual void  v71(); // _ZN6S584C43v71Ev
  virtual void  v72(); // _ZN6S584C43v72Ev
  virtual void  v73(); // _ZN6S584C43v73Ev
  virtual void  v74(); // _ZN6S584C43v74Ev
  virtual void  v75(); // _ZN6S584C43v75Ev
  virtual void  v76(); // _ZN6S584C43v76Ev
  virtual void  v77(); // _ZN6S584C43v77Ev
  virtual void  v78(); // _ZN6S584C43v78Ev
  virtual void  v79(); // _ZN6S584C43v79Ev
  virtual void  v80(); // _ZN6S584C43v80Ev
  virtual void  v81(); // _ZN6S584C43v81Ev
  virtual void  v82(); // _ZN6S584C43v82Ev
  virtual void  v83(); // _ZN6S584C43v83Ev
  virtual void  v84(); // _ZN6S584C43v84Ev
  virtual void  v85(); // _ZN6S584C43v85Ev
  virtual void  v86(); // _ZN6S584C43v86Ev
  virtual void  v87(); // _ZN6S584C43v87Ev
  virtual void  v88(); // _ZN6S584C43v88Ev
  virtual void  v89(); // _ZN6S584C43v89Ev
  S584C4(); // tgen
};
//SIG(-1 S584C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S584C4 ::~S584C4(){ note_dtor("S584C4", this);}
void  S584C4 ::v68(){vfunc_called(this, "_ZN6S584C43v68Ev");}
void  S584C4 ::v69(){vfunc_called(this, "_ZN6S584C43v69Ev");}
void  S584C4 ::v70(){vfunc_called(this, "_ZN6S584C43v70Ev");}
void  S584C4 ::v71(){vfunc_called(this, "_ZN6S584C43v71Ev");}
void  S584C4 ::v72(){vfunc_called(this, "_ZN6S584C43v72Ev");}
void  S584C4 ::v73(){vfunc_called(this, "_ZN6S584C43v73Ev");}
void  S584C4 ::v74(){vfunc_called(this, "_ZN6S584C43v74Ev");}
void  S584C4 ::v75(){vfunc_called(this, "_ZN6S584C43v75Ev");}
void  S584C4 ::v76(){vfunc_called(this, "_ZN6S584C43v76Ev");}
void  S584C4 ::v77(){vfunc_called(this, "_ZN6S584C43v77Ev");}
void  S584C4 ::v78(){vfunc_called(this, "_ZN6S584C43v78Ev");}
void  S584C4 ::v79(){vfunc_called(this, "_ZN6S584C43v79Ev");}
void  S584C4 ::v80(){vfunc_called(this, "_ZN6S584C43v80Ev");}
void  S584C4 ::v81(){vfunc_called(this, "_ZN6S584C43v81Ev");}
void  S584C4 ::v82(){vfunc_called(this, "_ZN6S584C43v82Ev");}
void  S584C4 ::v83(){vfunc_called(this, "_ZN6S584C43v83Ev");}
void  S584C4 ::v84(){vfunc_called(this, "_ZN6S584C43v84Ev");}
void  S584C4 ::v85(){vfunc_called(this, "_ZN6S584C43v85Ev");}
void  S584C4 ::v86(){vfunc_called(this, "_ZN6S584C43v86Ev");}
void  S584C4 ::v87(){vfunc_called(this, "_ZN6S584C43v87Ev");}
void  S584C4 ::v88(){vfunc_called(this, "_ZN6S584C43v88Ev");}
void  S584C4 ::v89(){vfunc_called(this, "_ZN6S584C43v89Ev");}
S584C4 ::S584C4(){ note_ctor("S584C4", this);} // tgen

static void Test_S584C4()
{
  extern Class_Descriptor cd_S584C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S584C4, buf);
    S584C4 *dp, &lv = *(dp=new (buf) S584C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S584C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S584C4)");
    check_base_class_offset(lv, (S584C5*), 0, "S584C4");
    check_field_offset(lv, s584c4f0, ABISELECT(96,60), "S584C4.s584c4f0");
    check_field_offset(lv, s584c4f1, ABISELECT(104,68), "S584C4.s584c4f1");
    check_field_offset(lv, s584c4f2, ABISELECT(112,72), "S584C4.s584c4f2");
    check_field_offset(lv, s584c4f3, ABISELECT(120,80), "S584C4.s584c4f3");
    check_field_offset(lv, s584c4f4, ABISELECT(136,92), "S584C4.s584c4f4");
    check_field_offset(lv, s584c4f5, ABISELECT(152,104), "S584C4.s584c4f5");
    check_field_offset(lv, s584c4f6, ABISELECT(160,108), "S584C4.s584c4f6");
    set_bf_and_test(lv, s584c4f7, ABISELECT(176,120), 0, 1, 1, "S584C4");
    set_bf_and_test(lv, s584c4f8, ABISELECT(176,120), 1, 1, 1, "S584C4");
    set_bf_and_test(lv, s584c4f9, ABISELECT(176,120), 2, 1, 1, "S584C4");
    set_bf_and_test(lv, s584c4f10, ABISELECT(176,120), 3, 1, 1, "S584C4");
    set_bf_and_test(lv, s584c4f11, ABISELECT(176,120), 4, 1, 1, "S584C4");
    check_field_offset(lv, s584c4f12, ABISELECT(180,124), "S584C4.s584c4f12");
    test_class_info(&lv, &cd_S584C4);
    dp->~S584C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS584C4(Test_S584C4, "S584C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S584C4C1Ev();
extern void _ZN6S584C4D1Ev();
Name_Map name_map_S584C4[] = {
  NSPAIR(_ZN6S584C4C1Ev),
  NSPAIR(_ZN6S584C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S584C5;
extern VTBL_ENTRY _ZTI6S584C5[];
extern  VTBL_ENTRY _ZTV6S584C5[];
static Base_Class bases_S584C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S584C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S584C4[];
extern void _ZN6S584C4D1Ev();
extern void _ZN6S584C4D0Ev();
extern void _ZN6S584C52v4Ev();
extern void _ZN6S584C52v5Ev();
extern void _ZN6S584C52v6Ev();
extern void _ZN6S584C52v7Ev();
extern void _ZN6S584C52v8Ev();
extern void _ZN6S584C52v9Ev();
extern void _ZN6S584C53v10Ev();
extern void _ZN6S584C53v11Ev();
extern void _ZN6S584C53v12Ev();
extern void _ZN6S584C53v13Ev();
extern void _ZN6S584C53v14Ev();
extern void _ZN6S584C53v15Ev();
extern void _ZN6S584C53v16Ev();
extern void _ZN6S584C53v17Ev();
extern void _ZN6S584C53v18Ev();
extern void _ZN6S584C53v19Ev();
extern void _ZN6S584C53v20Ev();
extern void _ZN6S584C53v21Ev();
extern void _ZN6S584C53v22Ev();
extern void _ZN6S584C53v23Ev();
extern void _ZN6S584C53v24Ev();
extern void _ZN6S584C53v25Ev();
extern void _ZN6S584C53v26Ev();
extern void _ZN6S584C53v27Ev();
extern void _ZN6S584C53v28Ev();
extern void _ZN6S584C53v29Ev();
extern void _ZN6S584C53v30Ev();
extern void _ZN6S584C53v31Ev();
extern void _ZN6S584C53v32Ev();
extern void _ZN6S584C53v33Ev();
extern void _ZN6S584C53v34Ev();
extern void _ZN6S584C53v35Ev();
extern void _ZN6S584C53v36Ev();
extern void _ZN6S584C53v37Ev();
extern void _ZN6S584C53v38Ev();
extern void _ZN6S584C53v39Ev();
extern void _ZN6S584C53v40Ev();
extern void _ZN6S584C53v41Ev();
extern void _ZN6S584C53v42Ev();
extern void _ZN6S584C53v43Ev();
extern void _ZN6S584C53v44Ev();
extern void _ZN6S584C53v45Ev();
extern void _ZN6S584C53v46Ev();
extern void _ZN6S584C53v47Ev();
extern void _ZN6S584C53v48Ev();
extern void _ZN6S584C53v49Ev();
extern void _ZN6S584C53v50Ev();
extern void _ZN6S584C53v51Ev();
extern void _ZN6S584C53v52Ev();
extern void _ZN6S584C53v53Ev();
extern void _ZN6S584C53v54Ev();
extern void _ZN6S584C53v55Ev();
extern void _ZN6S584C53v56Ev();
extern void _ZN6S584C53v57Ev();
extern void _ZN6S584C53v58Ev();
extern void _ZN6S584C53v59Ev();
extern void _ZN6S584C53v60Ev();
extern void _ZN6S584C53v61Ev();
extern void _ZN6S584C53v62Ev();
extern void _ZN6S584C53v63Ev();
extern void _ZN6S584C53v64Ev();
extern void _ZN6S584C53v65Ev();
extern void _ZN6S584C53v66Ev();
extern void _ZN6S584C53v67Ev();
extern void _ZN6S584C43v68Ev();
extern void _ZN6S584C43v69Ev();
extern void _ZN6S584C43v70Ev();
extern void _ZN6S584C43v71Ev();
extern void _ZN6S584C43v72Ev();
extern void _ZN6S584C43v73Ev();
extern void _ZN6S584C43v74Ev();
extern void _ZN6S584C43v75Ev();
extern void _ZN6S584C43v76Ev();
extern void _ZN6S584C43v77Ev();
extern void _ZN6S584C43v78Ev();
extern void _ZN6S584C43v79Ev();
extern void _ZN6S584C43v80Ev();
extern void _ZN6S584C43v81Ev();
extern void _ZN6S584C43v82Ev();
extern void _ZN6S584C43v83Ev();
extern void _ZN6S584C43v84Ev();
extern void _ZN6S584C43v85Ev();
extern void _ZN6S584C43v86Ev();
extern void _ZN6S584C43v87Ev();
extern void _ZN6S584C43v88Ev();
extern void _ZN6S584C43v89Ev();
static  VTBL_ENTRY vtc_S584C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S584C4[0]),
  (VTBL_ENTRY)&_ZN6S584C4D1Ev,
  (VTBL_ENTRY)&_ZN6S584C4D0Ev,
  (VTBL_ENTRY)&_ZN6S584C52v4Ev,
  (VTBL_ENTRY)&_ZN6S584C52v5Ev,
  (VTBL_ENTRY)&_ZN6S584C52v6Ev,
  (VTBL_ENTRY)&_ZN6S584C52v7Ev,
  (VTBL_ENTRY)&_ZN6S584C52v8Ev,
  (VTBL_ENTRY)&_ZN6S584C52v9Ev,
  (VTBL_ENTRY)&_ZN6S584C53v10Ev,
  (VTBL_ENTRY)&_ZN6S584C53v11Ev,
  (VTBL_ENTRY)&_ZN6S584C53v12Ev,
  (VTBL_ENTRY)&_ZN6S584C53v13Ev,
  (VTBL_ENTRY)&_ZN6S584C53v14Ev,
  (VTBL_ENTRY)&_ZN6S584C53v15Ev,
  (VTBL_ENTRY)&_ZN6S584C53v16Ev,
  (VTBL_ENTRY)&_ZN6S584C53v17Ev,
  (VTBL_ENTRY)&_ZN6S584C53v18Ev,
  (VTBL_ENTRY)&_ZN6S584C53v19Ev,
  (VTBL_ENTRY)&_ZN6S584C53v20Ev,
  (VTBL_ENTRY)&_ZN6S584C53v21Ev,
  (VTBL_ENTRY)&_ZN6S584C53v22Ev,
  (VTBL_ENTRY)&_ZN6S584C53v23Ev,
  (VTBL_ENTRY)&_ZN6S584C53v24Ev,
  (VTBL_ENTRY)&_ZN6S584C53v25Ev,
  (VTBL_ENTRY)&_ZN6S584C53v26Ev,
  (VTBL_ENTRY)&_ZN6S584C53v27Ev,
  (VTBL_ENTRY)&_ZN6S584C53v28Ev,
  (VTBL_ENTRY)&_ZN6S584C53v29Ev,
  (VTBL_ENTRY)&_ZN6S584C53v30Ev,
  (VTBL_ENTRY)&_ZN6S584C53v31Ev,
  (VTBL_ENTRY)&_ZN6S584C53v32Ev,
  (VTBL_ENTRY)&_ZN6S584C53v33Ev,
  (VTBL_ENTRY)&_ZN6S584C53v34Ev,
  (VTBL_ENTRY)&_ZN6S584C53v35Ev,
  (VTBL_ENTRY)&_ZN6S584C53v36Ev,
  (VTBL_ENTRY)&_ZN6S584C53v37Ev,
  (VTBL_ENTRY)&_ZN6S584C53v38Ev,
  (VTBL_ENTRY)&_ZN6S584C53v39Ev,
  (VTBL_ENTRY)&_ZN6S584C53v40Ev,
  (VTBL_ENTRY)&_ZN6S584C53v41Ev,
  (VTBL_ENTRY)&_ZN6S584C53v42Ev,
  (VTBL_ENTRY)&_ZN6S584C53v43Ev,
  (VTBL_ENTRY)&_ZN6S584C53v44Ev,
  (VTBL_ENTRY)&_ZN6S584C53v45Ev,
  (VTBL_ENTRY)&_ZN6S584C53v46Ev,
  (VTBL_ENTRY)&_ZN6S584C53v47Ev,
  (VTBL_ENTRY)&_ZN6S584C53v48Ev,
  (VTBL_ENTRY)&_ZN6S584C53v49Ev,
  (VTBL_ENTRY)&_ZN6S584C53v50Ev,
  (VTBL_ENTRY)&_ZN6S584C53v51Ev,
  (VTBL_ENTRY)&_ZN6S584C53v52Ev,
  (VTBL_ENTRY)&_ZN6S584C53v53Ev,
  (VTBL_ENTRY)&_ZN6S584C53v54Ev,
  (VTBL_ENTRY)&_ZN6S584C53v55Ev,
  (VTBL_ENTRY)&_ZN6S584C53v56Ev,
  (VTBL_ENTRY)&_ZN6S584C53v57Ev,
  (VTBL_ENTRY)&_ZN6S584C53v58Ev,
  (VTBL_ENTRY)&_ZN6S584C53v59Ev,
  (VTBL_ENTRY)&_ZN6S584C53v60Ev,
  (VTBL_ENTRY)&_ZN6S584C53v61Ev,
  (VTBL_ENTRY)&_ZN6S584C53v62Ev,
  (VTBL_ENTRY)&_ZN6S584C53v63Ev,
  (VTBL_ENTRY)&_ZN6S584C53v64Ev,
  (VTBL_ENTRY)&_ZN6S584C53v65Ev,
  (VTBL_ENTRY)&_ZN6S584C53v66Ev,
  (VTBL_ENTRY)&_ZN6S584C53v67Ev,
  (VTBL_ENTRY)&_ZN6S584C43v68Ev,
  (VTBL_ENTRY)&_ZN6S584C43v69Ev,
  (VTBL_ENTRY)&_ZN6S584C43v70Ev,
  (VTBL_ENTRY)&_ZN6S584C43v71Ev,
  (VTBL_ENTRY)&_ZN6S584C43v72Ev,
  (VTBL_ENTRY)&_ZN6S584C43v73Ev,
  (VTBL_ENTRY)&_ZN6S584C43v74Ev,
  (VTBL_ENTRY)&_ZN6S584C43v75Ev,
  (VTBL_ENTRY)&_ZN6S584C43v76Ev,
  (VTBL_ENTRY)&_ZN6S584C43v77Ev,
  (VTBL_ENTRY)&_ZN6S584C43v78Ev,
  (VTBL_ENTRY)&_ZN6S584C43v79Ev,
  (VTBL_ENTRY)&_ZN6S584C43v80Ev,
  (VTBL_ENTRY)&_ZN6S584C43v81Ev,
  (VTBL_ENTRY)&_ZN6S584C43v82Ev,
  (VTBL_ENTRY)&_ZN6S584C43v83Ev,
  (VTBL_ENTRY)&_ZN6S584C43v84Ev,
  (VTBL_ENTRY)&_ZN6S584C43v85Ev,
  (VTBL_ENTRY)&_ZN6S584C43v86Ev,
  (VTBL_ENTRY)&_ZN6S584C43v87Ev,
  (VTBL_ENTRY)&_ZN6S584C43v88Ev,
  (VTBL_ENTRY)&_ZN6S584C43v89Ev,
};
extern VTBL_ENTRY _ZTI6S584C4[];
extern  VTBL_ENTRY _ZTV6S584C4[];
Class_Descriptor cd_S584C4 = {  "S584C4", // class name
  bases_S584C4, 1,
  &(vtc_S584C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S584C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S584C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S584C3  : S584C4 {
  unsigned int s584c3f0:1;
  unsigned int s584c3f1:1;
  unsigned int s584c3f2:1;
  ::S499C42 s584c3f3;
  ::S499C38 s584c3f4;
  ::S499C17 s584c3f5;
  ::S499C13 s584c3f6;
  int s584c3f7[3];
  virtual  ~S584C3(); // _ZN6S584C3D1Ev
  virtual void  v90(); // _ZN6S584C33v90Ev
  virtual void  v91(); // _ZN6S584C33v91Ev
  virtual void  v92(); // _ZN6S584C33v92Ev
  virtual void  v93(); // _ZN6S584C33v93Ev
  virtual void  v94(); // _ZN6S584C33v94Ev
  virtual void  v95(); // _ZN6S584C33v95Ev
  virtual void  v96(); // _ZN6S584C33v96Ev
  virtual void  v97(); // _ZN6S584C33v97Ev
  virtual void  v98(); // _ZN6S584C33v98Ev
  virtual void  v99(); // _ZN6S584C33v99Ev
  virtual void  v100(); // _ZN6S584C34v100Ev
  virtual void  v101(); // _ZN6S584C34v101Ev
  virtual void  v102(); // _ZN6S584C34v102Ev
  virtual void  v103(); // _ZN6S584C34v103Ev
  virtual void  v104(); // _ZN6S584C34v104Ev
  virtual void  v105(); // _ZN6S584C34v105Ev
  virtual void  v106(); // _ZN6S584C34v106Ev
  virtual void  v107(); // _ZN6S584C34v107Ev
  virtual void  v108(); // _ZN6S584C34v108Ev
  virtual void  v109(); // _ZN6S584C34v109Ev
  S584C3(); // tgen
};
//SIG(-1 S584C3) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S584C3 ::~S584C3(){ note_dtor("S584C3", this);}
void  S584C3 ::v90(){vfunc_called(this, "_ZN6S584C33v90Ev");}
void  S584C3 ::v91(){vfunc_called(this, "_ZN6S584C33v91Ev");}
void  S584C3 ::v92(){vfunc_called(this, "_ZN6S584C33v92Ev");}
void  S584C3 ::v93(){vfunc_called(this, "_ZN6S584C33v93Ev");}
void  S584C3 ::v94(){vfunc_called(this, "_ZN6S584C33v94Ev");}
void  S584C3 ::v95(){vfunc_called(this, "_ZN6S584C33v95Ev");}
void  S584C3 ::v96(){vfunc_called(this, "_ZN6S584C33v96Ev");}
void  S584C3 ::v97(){vfunc_called(this, "_ZN6S584C33v97Ev");}
void  S584C3 ::v98(){vfunc_called(this, "_ZN6S584C33v98Ev");}
void  S584C3 ::v99(){vfunc_called(this, "_ZN6S584C33v99Ev");}
void  S584C3 ::v100(){vfunc_called(this, "_ZN6S584C34v100Ev");}
void  S584C3 ::v101(){vfunc_called(this, "_ZN6S584C34v101Ev");}
void  S584C3 ::v102(){vfunc_called(this, "_ZN6S584C34v102Ev");}
void  S584C3 ::v103(){vfunc_called(this, "_ZN6S584C34v103Ev");}
void  S584C3 ::v104(){vfunc_called(this, "_ZN6S584C34v104Ev");}
void  S584C3 ::v105(){vfunc_called(this, "_ZN6S584C34v105Ev");}
void  S584C3 ::v106(){vfunc_called(this, "_ZN6S584C34v106Ev");}
void  S584C3 ::v107(){vfunc_called(this, "_ZN6S584C34v107Ev");}
void  S584C3 ::v108(){vfunc_called(this, "_ZN6S584C34v108Ev");}
void  S584C3 ::v109(){vfunc_called(this, "_ZN6S584C34v109Ev");}
S584C3 ::S584C3(){ note_ctor("S584C3", this);} // tgen

static void Test_S584C3()
{
  extern Class_Descriptor cd_S584C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S584C3, buf);
    S584C3 *dp, &lv = *(dp=new (buf) S584C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S584C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S584C3)");
    check_base_class_offset(lv, (S584C5*)(S584C4*), 0, "S584C3");
    check_base_class_offset(lv, (S584C4*), 0, "S584C3");
    set_bf_and_test(lv, s584c3f0, ABISELECT(188,132), 0, 1, 1, "S584C3");
    set_bf_and_test(lv, s584c3f1, ABISELECT(188,132), 1, 1, 1, "S584C3");
    set_bf_and_test(lv, s584c3f2, ABISELECT(188,132), 2, 1, 1, "S584C3");
    check_field_offset(lv, s584c3f3, ABISELECT(192,136), "S584C3.s584c3f3");
    check_field_offset(lv, s584c3f4, ABISELECT(208,148), "S584C3.s584c3f4");
    check_field_offset(lv, s584c3f5, ABISELECT(224,160), "S584C3.s584c3f5");
    check_field_offset(lv, s584c3f6, ABISELECT(240,172), "S584C3.s584c3f6");
    check_field_offset(lv, s584c3f7, ABISELECT(256,184), "S584C3.s584c3f7");
    test_class_info(&lv, &cd_S584C3);
    dp->~S584C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS584C3(Test_S584C3, "S584C3", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S584C3C1Ev();
extern void _ZN6S584C3D1Ev();
Name_Map name_map_S584C3[] = {
  NSPAIR(_ZN6S584C3C1Ev),
  NSPAIR(_ZN6S584C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S584C5;
extern VTBL_ENTRY _ZTI6S584C5[];
extern  VTBL_ENTRY _ZTV6S584C5[];
extern Class_Descriptor cd_S584C4;
extern VTBL_ENTRY _ZTI6S584C4[];
extern  VTBL_ENTRY _ZTV6S584C4[];
static Base_Class bases_S584C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S584C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S584C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S584C3[];
extern void _ZN6S584C3D1Ev();
extern void _ZN6S584C3D0Ev();
extern void _ZN6S584C52v4Ev();
extern void _ZN6S584C52v5Ev();
extern void _ZN6S584C52v6Ev();
extern void _ZN6S584C52v7Ev();
extern void _ZN6S584C52v8Ev();
extern void _ZN6S584C52v9Ev();
extern void _ZN6S584C53v10Ev();
extern void _ZN6S584C53v11Ev();
extern void _ZN6S584C53v12Ev();
extern void _ZN6S584C53v13Ev();
extern void _ZN6S584C53v14Ev();
extern void _ZN6S584C53v15Ev();
extern void _ZN6S584C53v16Ev();
extern void _ZN6S584C53v17Ev();
extern void _ZN6S584C53v18Ev();
extern void _ZN6S584C53v19Ev();
extern void _ZN6S584C53v20Ev();
extern void _ZN6S584C53v21Ev();
extern void _ZN6S584C53v22Ev();
extern void _ZN6S584C53v23Ev();
extern void _ZN6S584C53v24Ev();
extern void _ZN6S584C53v25Ev();
extern void _ZN6S584C53v26Ev();
extern void _ZN6S584C53v27Ev();
extern void _ZN6S584C53v28Ev();
extern void _ZN6S584C53v29Ev();
extern void _ZN6S584C53v30Ev();
extern void _ZN6S584C53v31Ev();
extern void _ZN6S584C53v32Ev();
extern void _ZN6S584C53v33Ev();
extern void _ZN6S584C53v34Ev();
extern void _ZN6S584C53v35Ev();
extern void _ZN6S584C53v36Ev();
extern void _ZN6S584C53v37Ev();
extern void _ZN6S584C53v38Ev();
extern void _ZN6S584C53v39Ev();
extern void _ZN6S584C53v40Ev();
extern void _ZN6S584C53v41Ev();
extern void _ZN6S584C53v42Ev();
extern void _ZN6S584C53v43Ev();
extern void _ZN6S584C53v44Ev();
extern void _ZN6S584C53v45Ev();
extern void _ZN6S584C53v46Ev();
extern void _ZN6S584C53v47Ev();
extern void _ZN6S584C53v48Ev();
extern void _ZN6S584C53v49Ev();
extern void _ZN6S584C53v50Ev();
extern void _ZN6S584C53v51Ev();
extern void _ZN6S584C53v52Ev();
extern void _ZN6S584C53v53Ev();
extern void _ZN6S584C53v54Ev();
extern void _ZN6S584C53v55Ev();
extern void _ZN6S584C53v56Ev();
extern void _ZN6S584C53v57Ev();
extern void _ZN6S584C53v58Ev();
extern void _ZN6S584C53v59Ev();
extern void _ZN6S584C53v60Ev();
extern void _ZN6S584C53v61Ev();
extern void _ZN6S584C53v62Ev();
extern void _ZN6S584C53v63Ev();
extern void _ZN6S584C53v64Ev();
extern void _ZN6S584C53v65Ev();
extern void _ZN6S584C53v66Ev();
extern void _ZN6S584C53v67Ev();
extern void _ZN6S584C43v68Ev();
extern void _ZN6S584C43v69Ev();
extern void _ZN6S584C43v70Ev();
extern void _ZN6S584C43v71Ev();
extern void _ZN6S584C43v72Ev();
extern void _ZN6S584C43v73Ev();
extern void _ZN6S584C43v74Ev();
extern void _ZN6S584C43v75Ev();
extern void _ZN6S584C43v76Ev();
extern void _ZN6S584C43v77Ev();
extern void _ZN6S584C43v78Ev();
extern void _ZN6S584C43v79Ev();
extern void _ZN6S584C43v80Ev();
extern void _ZN6S584C43v81Ev();
extern void _ZN6S584C43v82Ev();
extern void _ZN6S584C43v83Ev();
extern void _ZN6S584C43v84Ev();
extern void _ZN6S584C43v85Ev();
extern void _ZN6S584C43v86Ev();
extern void _ZN6S584C43v87Ev();
extern void _ZN6S584C43v88Ev();
extern void _ZN6S584C43v89Ev();
extern void _ZN6S584C33v90Ev();
extern void _ZN6S584C33v91Ev();
extern void _ZN6S584C33v92Ev();
extern void _ZN6S584C33v93Ev();
extern void _ZN6S584C33v94Ev();
extern void _ZN6S584C33v95Ev();
extern void _ZN6S584C33v96Ev();
extern void _ZN6S584C33v97Ev();
extern void _ZN6S584C33v98Ev();
extern void _ZN6S584C33v99Ev();
extern void _ZN6S584C34v100Ev();
extern void _ZN6S584C34v101Ev();
extern void _ZN6S584C34v102Ev();
extern void _ZN6S584C34v103Ev();
extern void _ZN6S584C34v104Ev();
extern void _ZN6S584C34v105Ev();
extern void _ZN6S584C34v106Ev();
extern void _ZN6S584C34v107Ev();
extern void _ZN6S584C34v108Ev();
extern void _ZN6S584C34v109Ev();
static  VTBL_ENTRY vtc_S584C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S584C3[0]),
  (VTBL_ENTRY)&_ZN6S584C3D1Ev,
  (VTBL_ENTRY)&_ZN6S584C3D0Ev,
  (VTBL_ENTRY)&_ZN6S584C52v4Ev,
  (VTBL_ENTRY)&_ZN6S584C52v5Ev,
  (VTBL_ENTRY)&_ZN6S584C52v6Ev,
  (VTBL_ENTRY)&_ZN6S584C52v7Ev,
  (VTBL_ENTRY)&_ZN6S584C52v8Ev,
  (VTBL_ENTRY)&_ZN6S584C52v9Ev,
  (VTBL_ENTRY)&_ZN6S584C53v10Ev,
  (VTBL_ENTRY)&_ZN6S584C53v11Ev,
  (VTBL_ENTRY)&_ZN6S584C53v12Ev,
  (VTBL_ENTRY)&_ZN6S584C53v13Ev,
  (VTBL_ENTRY)&_ZN6S584C53v14Ev,
  (VTBL_ENTRY)&_ZN6S584C53v15Ev,
  (VTBL_ENTRY)&_ZN6S584C53v16Ev,
  (VTBL_ENTRY)&_ZN6S584C53v17Ev,
  (VTBL_ENTRY)&_ZN6S584C53v18Ev,
  (VTBL_ENTRY)&_ZN6S584C53v19Ev,
  (VTBL_ENTRY)&_ZN6S584C53v20Ev,
  (VTBL_ENTRY)&_ZN6S584C53v21Ev,
  (VTBL_ENTRY)&_ZN6S584C53v22Ev,
  (VTBL_ENTRY)&_ZN6S584C53v23Ev,
  (VTBL_ENTRY)&_ZN6S584C53v24Ev,
  (VTBL_ENTRY)&_ZN6S584C53v25Ev,
  (VTBL_ENTRY)&_ZN6S584C53v26Ev,
  (VTBL_ENTRY)&_ZN6S584C53v27Ev,
  (VTBL_ENTRY)&_ZN6S584C53v28Ev,
  (VTBL_ENTRY)&_ZN6S584C53v29Ev,
  (VTBL_ENTRY)&_ZN6S584C53v30Ev,
  (VTBL_ENTRY)&_ZN6S584C53v31Ev,
  (VTBL_ENTRY)&_ZN6S584C53v32Ev,
  (VTBL_ENTRY)&_ZN6S584C53v33Ev,
  (VTBL_ENTRY)&_ZN6S584C53v34Ev,
  (VTBL_ENTRY)&_ZN6S584C53v35Ev,
  (VTBL_ENTRY)&_ZN6S584C53v36Ev,
  (VTBL_ENTRY)&_ZN6S584C53v37Ev,
  (VTBL_ENTRY)&_ZN6S584C53v38Ev,
  (VTBL_ENTRY)&_ZN6S584C53v39Ev,
  (VTBL_ENTRY)&_ZN6S584C53v40Ev,
  (VTBL_ENTRY)&_ZN6S584C53v41Ev,
  (VTBL_ENTRY)&_ZN6S584C53v42Ev,
  (VTBL_ENTRY)&_ZN6S584C53v43Ev,
  (VTBL_ENTRY)&_ZN6S584C53v44Ev,
  (VTBL_ENTRY)&_ZN6S584C53v45Ev,
  (VTBL_ENTRY)&_ZN6S584C53v46Ev,
  (VTBL_ENTRY)&_ZN6S584C53v47Ev,
  (VTBL_ENTRY)&_ZN6S584C53v48Ev,
  (VTBL_ENTRY)&_ZN6S584C53v49Ev,
  (VTBL_ENTRY)&_ZN6S584C53v50Ev,
  (VTBL_ENTRY)&_ZN6S584C53v51Ev,
  (VTBL_ENTRY)&_ZN6S584C53v52Ev,
  (VTBL_ENTRY)&_ZN6S584C53v53Ev,
  (VTBL_ENTRY)&_ZN6S584C53v54Ev,
  (VTBL_ENTRY)&_ZN6S584C53v55Ev,
  (VTBL_ENTRY)&_ZN6S584C53v56Ev,
  (VTBL_ENTRY)&_ZN6S584C53v57Ev,
  (VTBL_ENTRY)&_ZN6S584C53v58Ev,
  (VTBL_ENTRY)&_ZN6S584C53v59Ev,
  (VTBL_ENTRY)&_ZN6S584C53v60Ev,
  (VTBL_ENTRY)&_ZN6S584C53v61Ev,
  (VTBL_ENTRY)&_ZN6S584C53v62Ev,
  (VTBL_ENTRY)&_ZN6S584C53v63Ev,
  (VTBL_ENTRY)&_ZN6S584C53v64Ev,
  (VTBL_ENTRY)&_ZN6S584C53v65Ev,
  (VTBL_ENTRY)&_ZN6S584C53v66Ev,
  (VTBL_ENTRY)&_ZN6S584C53v67Ev,
  (VTBL_ENTRY)&_ZN6S584C43v68Ev,
  (VTBL_ENTRY)&_ZN6S584C43v69Ev,
  (VTBL_ENTRY)&_ZN6S584C43v70Ev,
  (VTBL_ENTRY)&_ZN6S584C43v71Ev,
  (VTBL_ENTRY)&_ZN6S584C43v72Ev,
  (VTBL_ENTRY)&_ZN6S584C43v73Ev,
  (VTBL_ENTRY)&_ZN6S584C43v74Ev,
  (VTBL_ENTRY)&_ZN6S584C43v75Ev,
  (VTBL_ENTRY)&_ZN6S584C43v76Ev,
  (VTBL_ENTRY)&_ZN6S584C43v77Ev,
  (VTBL_ENTRY)&_ZN6S584C43v78Ev,
  (VTBL_ENTRY)&_ZN6S584C43v79Ev,
  (VTBL_ENTRY)&_ZN6S584C43v80Ev,
  (VTBL_ENTRY)&_ZN6S584C43v81Ev,
  (VTBL_ENTRY)&_ZN6S584C43v82Ev,
  (VTBL_ENTRY)&_ZN6S584C43v83Ev,
  (VTBL_ENTRY)&_ZN6S584C43v84Ev,
  (VTBL_ENTRY)&_ZN6S584C43v85Ev,
  (VTBL_ENTRY)&_ZN6S584C43v86Ev,
  (VTBL_ENTRY)&_ZN6S584C43v87Ev,
  (VTBL_ENTRY)&_ZN6S584C43v88Ev,
  (VTBL_ENTRY)&_ZN6S584C43v89Ev,
  (VTBL_ENTRY)&_ZN6S584C33v90Ev,
  (VTBL_ENTRY)&_ZN6S584C33v91Ev,
  (VTBL_ENTRY)&_ZN6S584C33v92Ev,
  (VTBL_ENTRY)&_ZN6S584C33v93Ev,
  (VTBL_ENTRY)&_ZN6S584C33v94Ev,
  (VTBL_ENTRY)&_ZN6S584C33v95Ev,
  (VTBL_ENTRY)&_ZN6S584C33v96Ev,
  (VTBL_ENTRY)&_ZN6S584C33v97Ev,
  (VTBL_ENTRY)&_ZN6S584C33v98Ev,
  (VTBL_ENTRY)&_ZN6S584C33v99Ev,
  (VTBL_ENTRY)&_ZN6S584C34v100Ev,
  (VTBL_ENTRY)&_ZN6S584C34v101Ev,
  (VTBL_ENTRY)&_ZN6S584C34v102Ev,
  (VTBL_ENTRY)&_ZN6S584C34v103Ev,
  (VTBL_ENTRY)&_ZN6S584C34v104Ev,
  (VTBL_ENTRY)&_ZN6S584C34v105Ev,
  (VTBL_ENTRY)&_ZN6S584C34v106Ev,
  (VTBL_ENTRY)&_ZN6S584C34v107Ev,
  (VTBL_ENTRY)&_ZN6S584C34v108Ev,
  (VTBL_ENTRY)&_ZN6S584C34v109Ev,
};
extern VTBL_ENTRY _ZTI6S584C3[];
extern  VTBL_ENTRY _ZTV6S584C3[];
Class_Descriptor cd_S584C3 = {  "S584C3", // class name
  bases_S584C3, 2,
  &(vtc_S584C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S584C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S584C3),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S584C2  : S584C3 {
  ::S499C6_nt s584c2f0;
  unsigned int s584c2f1:1;
  ::S499C8_nt s584c2f2;
  virtual  ~S584C2(); // _ZN6S584C2D1Ev
  virtual void  v110(); // _ZN6S584C24v110Ev
  virtual void  v111(); // _ZN6S584C24v111Ev
  virtual void  v112(); // _ZN6S584C24v112Ev
  virtual void  v113(); // _ZN6S584C24v113Ev
  S584C2(); // tgen
};
//SIG(-1 S584C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S584C2 ::~S584C2(){ note_dtor("S584C2", this);}
void  S584C2 ::v110(){vfunc_called(this, "_ZN6S584C24v110Ev");}
void  S584C2 ::v111(){vfunc_called(this, "_ZN6S584C24v111Ev");}
void  S584C2 ::v112(){vfunc_called(this, "_ZN6S584C24v112Ev");}
void  S584C2 ::v113(){vfunc_called(this, "_ZN6S584C24v113Ev");}
S584C2 ::S584C2(){ note_ctor("S584C2", this);} // tgen

static void Test_S584C2()
{
  extern Class_Descriptor cd_S584C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S584C2, buf);
    S584C2 *dp, &lv = *(dp=new (buf) S584C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S584C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S584C2)");
    check_base_class_offset(lv, (S584C5*)(S584C4*)(S584C3*), 0, "S584C2");
    check_base_class_offset(lv, (S584C4*)(S584C3*), 0, "S584C2");
    check_base_class_offset(lv, (S584C3*), 0, "S584C2");
    check_field_offset(lv, s584c2f0, ABISELECT(268,196), "S584C2.s584c2f0");
    set_bf_and_test(lv, s584c2f1, ABISELECT(276,204), 0, 1, 1, "S584C2");
    check_field_offset(lv, s584c2f2, ABISELECT(280,208), "S584C2.s584c2f2");
    test_class_info(&lv, &cd_S584C2);
    dp->~S584C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS584C2(Test_S584C2, "S584C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S584C2C1Ev();
extern void _ZN6S584C2D1Ev();
Name_Map name_map_S584C2[] = {
  NSPAIR(_ZN6S584C2C1Ev),
  NSPAIR(_ZN6S584C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S584C5;
extern VTBL_ENTRY _ZTI6S584C5[];
extern  VTBL_ENTRY _ZTV6S584C5[];
extern Class_Descriptor cd_S584C4;
extern VTBL_ENTRY _ZTI6S584C4[];
extern  VTBL_ENTRY _ZTV6S584C4[];
extern Class_Descriptor cd_S584C3;
extern VTBL_ENTRY _ZTI6S584C3[];
extern  VTBL_ENTRY _ZTV6S584C3[];
static Base_Class bases_S584C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S584C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S584C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S584C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S584C2[];
extern void _ZN6S584C2D1Ev();
extern void _ZN6S584C2D0Ev();
extern void _ZN6S584C52v4Ev();
extern void _ZN6S584C52v5Ev();
extern void _ZN6S584C52v6Ev();
extern void _ZN6S584C52v7Ev();
extern void _ZN6S584C52v8Ev();
extern void _ZN6S584C52v9Ev();
extern void _ZN6S584C53v10Ev();
extern void _ZN6S584C53v11Ev();
extern void _ZN6S584C53v12Ev();
extern void _ZN6S584C53v13Ev();
extern void _ZN6S584C53v14Ev();
extern void _ZN6S584C53v15Ev();
extern void _ZN6S584C53v16Ev();
extern void _ZN6S584C53v17Ev();
extern void _ZN6S584C53v18Ev();
extern void _ZN6S584C53v19Ev();
extern void _ZN6S584C53v20Ev();
extern void _ZN6S584C53v21Ev();
extern void _ZN6S584C53v22Ev();
extern void _ZN6S584C53v23Ev();
extern void _ZN6S584C53v24Ev();
extern void _ZN6S584C53v25Ev();
extern void _ZN6S584C53v26Ev();
extern void _ZN6S584C53v27Ev();
extern void _ZN6S584C53v28Ev();
extern void _ZN6S584C53v29Ev();
extern void _ZN6S584C53v30Ev();
extern void _ZN6S584C53v31Ev();
extern void _ZN6S584C53v32Ev();
extern void _ZN6S584C53v33Ev();
extern void _ZN6S584C53v34Ev();
extern void _ZN6S584C53v35Ev();
extern void _ZN6S584C53v36Ev();
extern void _ZN6S584C53v37Ev();
extern void _ZN6S584C53v38Ev();
extern void _ZN6S584C53v39Ev();
extern void _ZN6S584C53v40Ev();
extern void _ZN6S584C53v41Ev();
extern void _ZN6S584C53v42Ev();
extern void _ZN6S584C53v43Ev();
extern void _ZN6S584C53v44Ev();
extern void _ZN6S584C53v45Ev();
extern void _ZN6S584C53v46Ev();
extern void _ZN6S584C53v47Ev();
extern void _ZN6S584C53v48Ev();
extern void _ZN6S584C53v49Ev();
extern void _ZN6S584C53v50Ev();
extern void _ZN6S584C53v51Ev();
extern void _ZN6S584C53v52Ev();
extern void _ZN6S584C53v53Ev();
extern void _ZN6S584C53v54Ev();
extern void _ZN6S584C53v55Ev();
extern void _ZN6S584C53v56Ev();
extern void _ZN6S584C53v57Ev();
extern void _ZN6S584C53v58Ev();
extern void _ZN6S584C53v59Ev();
extern void _ZN6S584C53v60Ev();
extern void _ZN6S584C53v61Ev();
extern void _ZN6S584C53v62Ev();
extern void _ZN6S584C53v63Ev();
extern void _ZN6S584C53v64Ev();
extern void _ZN6S584C53v65Ev();
extern void _ZN6S584C53v66Ev();
extern void _ZN6S584C53v67Ev();
extern void _ZN6S584C43v68Ev();
extern void _ZN6S584C43v69Ev();
extern void _ZN6S584C43v70Ev();
extern void _ZN6S584C43v71Ev();
extern void _ZN6S584C43v72Ev();
extern void _ZN6S584C43v73Ev();
extern void _ZN6S584C43v74Ev();
extern void _ZN6S584C43v75Ev();
extern void _ZN6S584C43v76Ev();
extern void _ZN6S584C43v77Ev();
extern void _ZN6S584C43v78Ev();
extern void _ZN6S584C43v79Ev();
extern void _ZN6S584C43v80Ev();
extern void _ZN6S584C43v81Ev();
extern void _ZN6S584C43v82Ev();
extern void _ZN6S584C43v83Ev();
extern void _ZN6S584C43v84Ev();
extern void _ZN6S584C43v85Ev();
extern void _ZN6S584C43v86Ev();
extern void _ZN6S584C43v87Ev();
extern void _ZN6S584C43v88Ev();
extern void _ZN6S584C43v89Ev();
extern void _ZN6S584C33v90Ev();
extern void _ZN6S584C33v91Ev();
extern void _ZN6S584C33v92Ev();
extern void _ZN6S584C33v93Ev();
extern void _ZN6S584C33v94Ev();
extern void _ZN6S584C33v95Ev();
extern void _ZN6S584C33v96Ev();
extern void _ZN6S584C33v97Ev();
extern void _ZN6S584C33v98Ev();
extern void _ZN6S584C33v99Ev();
extern void _ZN6S584C34v100Ev();
extern void _ZN6S584C34v101Ev();
extern void _ZN6S584C34v102Ev();
extern void _ZN6S584C34v103Ev();
extern void _ZN6S584C34v104Ev();
extern void _ZN6S584C34v105Ev();
extern void _ZN6S584C34v106Ev();
extern void _ZN6S584C34v107Ev();
extern void _ZN6S584C34v108Ev();
extern void _ZN6S584C34v109Ev();
extern void _ZN6S584C24v110Ev();
extern void _ZN6S584C24v111Ev();
extern void _ZN6S584C24v112Ev();
extern void _ZN6S584C24v113Ev();
static  VTBL_ENTRY vtc_S584C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S584C2[0]),
  (VTBL_ENTRY)&_ZN6S584C2D1Ev,
  (VTBL_ENTRY)&_ZN6S584C2D0Ev,
  (VTBL_ENTRY)&_ZN6S584C52v4Ev,
  (VTBL_ENTRY)&_ZN6S584C52v5Ev,
  (VTBL_ENTRY)&_ZN6S584C52v6Ev,
  (VTBL_ENTRY)&_ZN6S584C52v7Ev,
  (VTBL_ENTRY)&_ZN6S584C52v8Ev,
  (VTBL_ENTRY)&_ZN6S584C52v9Ev,
  (VTBL_ENTRY)&_ZN6S584C53v10Ev,
  (VTBL_ENTRY)&_ZN6S584C53v11Ev,
  (VTBL_ENTRY)&_ZN6S584C53v12Ev,
  (VTBL_ENTRY)&_ZN6S584C53v13Ev,
  (VTBL_ENTRY)&_ZN6S584C53v14Ev,
  (VTBL_ENTRY)&_ZN6S584C53v15Ev,
  (VTBL_ENTRY)&_ZN6S584C53v16Ev,
  (VTBL_ENTRY)&_ZN6S584C53v17Ev,
  (VTBL_ENTRY)&_ZN6S584C53v18Ev,
  (VTBL_ENTRY)&_ZN6S584C53v19Ev,
  (VTBL_ENTRY)&_ZN6S584C53v20Ev,
  (VTBL_ENTRY)&_ZN6S584C53v21Ev,
  (VTBL_ENTRY)&_ZN6S584C53v22Ev,
  (VTBL_ENTRY)&_ZN6S584C53v23Ev,
  (VTBL_ENTRY)&_ZN6S584C53v24Ev,
  (VTBL_ENTRY)&_ZN6S584C53v25Ev,
  (VTBL_ENTRY)&_ZN6S584C53v26Ev,
  (VTBL_ENTRY)&_ZN6S584C53v27Ev,
  (VTBL_ENTRY)&_ZN6S584C53v28Ev,
  (VTBL_ENTRY)&_ZN6S584C53v29Ev,
  (VTBL_ENTRY)&_ZN6S584C53v30Ev,
  (VTBL_ENTRY)&_ZN6S584C53v31Ev,
  (VTBL_ENTRY)&_ZN6S584C53v32Ev,
  (VTBL_ENTRY)&_ZN6S584C53v33Ev,
  (VTBL_ENTRY)&_ZN6S584C53v34Ev,
  (VTBL_ENTRY)&_ZN6S584C53v35Ev,
  (VTBL_ENTRY)&_ZN6S584C53v36Ev,
  (VTBL_ENTRY)&_ZN6S584C53v37Ev,
  (VTBL_ENTRY)&_ZN6S584C53v38Ev,
  (VTBL_ENTRY)&_ZN6S584C53v39Ev,
  (VTBL_ENTRY)&_ZN6S584C53v40Ev,
  (VTBL_ENTRY)&_ZN6S584C53v41Ev,
  (VTBL_ENTRY)&_ZN6S584C53v42Ev,
  (VTBL_ENTRY)&_ZN6S584C53v43Ev,
  (VTBL_ENTRY)&_ZN6S584C53v44Ev,
  (VTBL_ENTRY)&_ZN6S584C53v45Ev,
  (VTBL_ENTRY)&_ZN6S584C53v46Ev,
  (VTBL_ENTRY)&_ZN6S584C53v47Ev,
  (VTBL_ENTRY)&_ZN6S584C53v48Ev,
  (VTBL_ENTRY)&_ZN6S584C53v49Ev,
  (VTBL_ENTRY)&_ZN6S584C53v50Ev,
  (VTBL_ENTRY)&_ZN6S584C53v51Ev,
  (VTBL_ENTRY)&_ZN6S584C53v52Ev,
  (VTBL_ENTRY)&_ZN6S584C53v53Ev,
  (VTBL_ENTRY)&_ZN6S584C53v54Ev,
  (VTBL_ENTRY)&_ZN6S584C53v55Ev,
  (VTBL_ENTRY)&_ZN6S584C53v56Ev,
  (VTBL_ENTRY)&_ZN6S584C53v57Ev,
  (VTBL_ENTRY)&_ZN6S584C53v58Ev,
  (VTBL_ENTRY)&_ZN6S584C53v59Ev,
  (VTBL_ENTRY)&_ZN6S584C53v60Ev,
  (VTBL_ENTRY)&_ZN6S584C53v61Ev,
  (VTBL_ENTRY)&_ZN6S584C53v62Ev,
  (VTBL_ENTRY)&_ZN6S584C53v63Ev,
  (VTBL_ENTRY)&_ZN6S584C53v64Ev,
  (VTBL_ENTRY)&_ZN6S584C53v65Ev,
  (VTBL_ENTRY)&_ZN6S584C53v66Ev,
  (VTBL_ENTRY)&_ZN6S584C53v67Ev,
  (VTBL_ENTRY)&_ZN6S584C43v68Ev,
  (VTBL_ENTRY)&_ZN6S584C43v69Ev,
  (VTBL_ENTRY)&_ZN6S584C43v70Ev,
  (VTBL_ENTRY)&_ZN6S584C43v71Ev,
  (VTBL_ENTRY)&_ZN6S584C43v72Ev,
  (VTBL_ENTRY)&_ZN6S584C43v73Ev,
  (VTBL_ENTRY)&_ZN6S584C43v74Ev,
  (VTBL_ENTRY)&_ZN6S584C43v75Ev,
  (VTBL_ENTRY)&_ZN6S584C43v76Ev,
  (VTBL_ENTRY)&_ZN6S584C43v77Ev,
  (VTBL_ENTRY)&_ZN6S584C43v78Ev,
  (VTBL_ENTRY)&_ZN6S584C43v79Ev,
  (VTBL_ENTRY)&_ZN6S584C43v80Ev,
  (VTBL_ENTRY)&_ZN6S584C43v81Ev,
  (VTBL_ENTRY)&_ZN6S584C43v82Ev,
  (VTBL_ENTRY)&_ZN6S584C43v83Ev,
  (VTBL_ENTRY)&_ZN6S584C43v84Ev,
  (VTBL_ENTRY)&_ZN6S584C43v85Ev,
  (VTBL_ENTRY)&_ZN6S584C43v86Ev,
  (VTBL_ENTRY)&_ZN6S584C43v87Ev,
  (VTBL_ENTRY)&_ZN6S584C43v88Ev,
  (VTBL_ENTRY)&_ZN6S584C43v89Ev,
  (VTBL_ENTRY)&_ZN6S584C33v90Ev,
  (VTBL_ENTRY)&_ZN6S584C33v91Ev,
  (VTBL_ENTRY)&_ZN6S584C33v92Ev,
  (VTBL_ENTRY)&_ZN6S584C33v93Ev,
  (VTBL_ENTRY)&_ZN6S584C33v94Ev,
  (VTBL_ENTRY)&_ZN6S584C33v95Ev,
  (VTBL_ENTRY)&_ZN6S584C33v96Ev,
  (VTBL_ENTRY)&_ZN6S584C33v97Ev,
  (VTBL_ENTRY)&_ZN6S584C33v98Ev,
  (VTBL_ENTRY)&_ZN6S584C33v99Ev,
  (VTBL_ENTRY)&_ZN6S584C34v100Ev,
  (VTBL_ENTRY)&_ZN6S584C34v101Ev,
  (VTBL_ENTRY)&_ZN6S584C34v102Ev,
  (VTBL_ENTRY)&_ZN6S584C34v103Ev,
  (VTBL_ENTRY)&_ZN6S584C34v104Ev,
  (VTBL_ENTRY)&_ZN6S584C34v105Ev,
  (VTBL_ENTRY)&_ZN6S584C34v106Ev,
  (VTBL_ENTRY)&_ZN6S584C34v107Ev,
  (VTBL_ENTRY)&_ZN6S584C34v108Ev,
  (VTBL_ENTRY)&_ZN6S584C34v109Ev,
  (VTBL_ENTRY)&_ZN6S584C24v110Ev,
  (VTBL_ENTRY)&_ZN6S584C24v111Ev,
  (VTBL_ENTRY)&_ZN6S584C24v112Ev,
  (VTBL_ENTRY)&_ZN6S584C24v113Ev,
};
extern VTBL_ENTRY _ZTI6S584C2[];
extern  VTBL_ENTRY _ZTV6S584C2[];
Class_Descriptor cd_S584C2 = {  "S584C2", // class name
  bases_S584C2, 3,
  &(vtc_S584C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S584C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S584C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S584C1  : S584C2 {
  void *s584c1f0;
  unsigned int s584c1f1:1;
  unsigned int s584c1f2:1;
  virtual  ~S584C1(); // _ZN6S584C1D1Ev
  virtual void  v1(); // _ZN6S584C12v1Ev
  virtual void  v2(); // _ZN6S584C12v2Ev
  virtual void  v3(); // _ZN6S584C12v3Ev
  S584C1(); // tgen
};
//SIG(1 S584C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v110 v111 v112 v113 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 Fp Fi:1 Fi:1}


 S584C1 ::~S584C1(){ note_dtor("S584C1", this);}
void  S584C1 ::v1(){vfunc_called(this, "_ZN6S584C12v1Ev");}
void  S584C1 ::v2(){vfunc_called(this, "_ZN6S584C12v2Ev");}
void  S584C1 ::v3(){vfunc_called(this, "_ZN6S584C12v3Ev");}
S584C1 ::S584C1(){ note_ctor("S584C1", this);} // tgen

static void Test_S584C1()
{
  extern Class_Descriptor cd_S584C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,58)];
    init_test(&cd_S584C1, buf);
    S584C1 *dp, &lv = *(dp=new (buf) S584C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,228), "sizeof(S584C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S584C1)");
    check_base_class_offset(lv, (S584C5*)(S584C4*)(S584C3*)(S584C2*), 0, "S584C1");
    check_base_class_offset(lv, (S584C4*)(S584C3*)(S584C2*), 0, "S584C1");
    check_base_class_offset(lv, (S584C3*)(S584C2*), 0, "S584C1");
    check_base_class_offset(lv, (S584C2*), 0, "S584C1");
    check_field_offset(lv, s584c1f0, ABISELECT(296,220), "S584C1.s584c1f0");
    set_bf_and_test(lv, s584c1f1, ABISELECT(304,224), 0, 1, 1, "S584C1");
    set_bf_and_test(lv, s584c1f2, ABISELECT(304,224), 1, 1, 1, "S584C1");
    test_class_info(&lv, &cd_S584C1);
    dp->~S584C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS584C1(Test_S584C1, "S584C1", ABISELECT(312,228));

#else // __cplusplus

extern void _ZN6S584C1C1Ev();
extern void _ZN6S584C1D1Ev();
Name_Map name_map_S584C1[] = {
  NSPAIR(_ZN6S584C1C1Ev),
  NSPAIR(_ZN6S584C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S584C5;
extern VTBL_ENTRY _ZTI6S584C5[];
extern  VTBL_ENTRY _ZTV6S584C5[];
extern Class_Descriptor cd_S584C4;
extern VTBL_ENTRY _ZTI6S584C4[];
extern  VTBL_ENTRY _ZTV6S584C4[];
extern Class_Descriptor cd_S584C3;
extern VTBL_ENTRY _ZTI6S584C3[];
extern  VTBL_ENTRY _ZTV6S584C3[];
extern Class_Descriptor cd_S584C2;
extern VTBL_ENTRY _ZTI6S584C2[];
extern  VTBL_ENTRY _ZTV6S584C2[];
static Base_Class bases_S584C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S584C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S584C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S584C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S584C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S584C1[];
extern void _ZN6S584C1D1Ev();
extern void _ZN6S584C1D0Ev();
extern void _ZN6S584C52v4Ev();
extern void _ZN6S584C52v5Ev();
extern void _ZN6S584C52v6Ev();
extern void _ZN6S584C52v7Ev();
extern void _ZN6S584C52v8Ev();
extern void _ZN6S584C52v9Ev();
extern void _ZN6S584C53v10Ev();
extern void _ZN6S584C53v11Ev();
extern void _ZN6S584C53v12Ev();
extern void _ZN6S584C53v13Ev();
extern void _ZN6S584C53v14Ev();
extern void _ZN6S584C53v15Ev();
extern void _ZN6S584C53v16Ev();
extern void _ZN6S584C53v17Ev();
extern void _ZN6S584C53v18Ev();
extern void _ZN6S584C53v19Ev();
extern void _ZN6S584C53v20Ev();
extern void _ZN6S584C53v21Ev();
extern void _ZN6S584C53v22Ev();
extern void _ZN6S584C53v23Ev();
extern void _ZN6S584C53v24Ev();
extern void _ZN6S584C53v25Ev();
extern void _ZN6S584C53v26Ev();
extern void _ZN6S584C53v27Ev();
extern void _ZN6S584C53v28Ev();
extern void _ZN6S584C53v29Ev();
extern void _ZN6S584C53v30Ev();
extern void _ZN6S584C53v31Ev();
extern void _ZN6S584C53v32Ev();
extern void _ZN6S584C53v33Ev();
extern void _ZN6S584C53v34Ev();
extern void _ZN6S584C53v35Ev();
extern void _ZN6S584C53v36Ev();
extern void _ZN6S584C53v37Ev();
extern void _ZN6S584C53v38Ev();
extern void _ZN6S584C53v39Ev();
extern void _ZN6S584C53v40Ev();
extern void _ZN6S584C53v41Ev();
extern void _ZN6S584C53v42Ev();
extern void _ZN6S584C53v43Ev();
extern void _ZN6S584C53v44Ev();
extern void _ZN6S584C53v45Ev();
extern void _ZN6S584C53v46Ev();
extern void _ZN6S584C53v47Ev();
extern void _ZN6S584C53v48Ev();
extern void _ZN6S584C53v49Ev();
extern void _ZN6S584C53v50Ev();
extern void _ZN6S584C53v51Ev();
extern void _ZN6S584C53v52Ev();
extern void _ZN6S584C53v53Ev();
extern void _ZN6S584C53v54Ev();
extern void _ZN6S584C53v55Ev();
extern void _ZN6S584C53v56Ev();
extern void _ZN6S584C53v57Ev();
extern void _ZN6S584C53v58Ev();
extern void _ZN6S584C53v59Ev();
extern void _ZN6S584C53v60Ev();
extern void _ZN6S584C53v61Ev();
extern void _ZN6S584C53v62Ev();
extern void _ZN6S584C53v63Ev();
extern void _ZN6S584C53v64Ev();
extern void _ZN6S584C53v65Ev();
extern void _ZN6S584C53v66Ev();
extern void _ZN6S584C53v67Ev();
extern void _ZN6S584C43v68Ev();
extern void _ZN6S584C43v69Ev();
extern void _ZN6S584C43v70Ev();
extern void _ZN6S584C43v71Ev();
extern void _ZN6S584C43v72Ev();
extern void _ZN6S584C43v73Ev();
extern void _ZN6S584C43v74Ev();
extern void _ZN6S584C43v75Ev();
extern void _ZN6S584C43v76Ev();
extern void _ZN6S584C43v77Ev();
extern void _ZN6S584C43v78Ev();
extern void _ZN6S584C43v79Ev();
extern void _ZN6S584C43v80Ev();
extern void _ZN6S584C43v81Ev();
extern void _ZN6S584C43v82Ev();
extern void _ZN6S584C43v83Ev();
extern void _ZN6S584C43v84Ev();
extern void _ZN6S584C43v85Ev();
extern void _ZN6S584C43v86Ev();
extern void _ZN6S584C43v87Ev();
extern void _ZN6S584C43v88Ev();
extern void _ZN6S584C43v89Ev();
extern void _ZN6S584C33v90Ev();
extern void _ZN6S584C33v91Ev();
extern void _ZN6S584C33v92Ev();
extern void _ZN6S584C33v93Ev();
extern void _ZN6S584C33v94Ev();
extern void _ZN6S584C33v95Ev();
extern void _ZN6S584C33v96Ev();
extern void _ZN6S584C33v97Ev();
extern void _ZN6S584C33v98Ev();
extern void _ZN6S584C33v99Ev();
extern void _ZN6S584C34v100Ev();
extern void _ZN6S584C34v101Ev();
extern void _ZN6S584C34v102Ev();
extern void _ZN6S584C34v103Ev();
extern void _ZN6S584C34v104Ev();
extern void _ZN6S584C34v105Ev();
extern void _ZN6S584C34v106Ev();
extern void _ZN6S584C34v107Ev();
extern void _ZN6S584C34v108Ev();
extern void _ZN6S584C34v109Ev();
extern void _ZN6S584C24v110Ev();
extern void _ZN6S584C24v111Ev();
extern void _ZN6S584C24v112Ev();
extern void _ZN6S584C24v113Ev();
extern void _ZN6S584C12v1Ev();
extern void _ZN6S584C12v2Ev();
extern void _ZN6S584C12v3Ev();
static  VTBL_ENTRY vtc_S584C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S584C1[0]),
  (VTBL_ENTRY)&_ZN6S584C1D1Ev,
  (VTBL_ENTRY)&_ZN6S584C1D0Ev,
  (VTBL_ENTRY)&_ZN6S584C52v4Ev,
  (VTBL_ENTRY)&_ZN6S584C52v5Ev,
  (VTBL_ENTRY)&_ZN6S584C52v6Ev,
  (VTBL_ENTRY)&_ZN6S584C52v7Ev,
  (VTBL_ENTRY)&_ZN6S584C52v8Ev,
  (VTBL_ENTRY)&_ZN6S584C52v9Ev,
  (VTBL_ENTRY)&_ZN6S584C53v10Ev,
  (VTBL_ENTRY)&_ZN6S584C53v11Ev,
  (VTBL_ENTRY)&_ZN6S584C53v12Ev,
  (VTBL_ENTRY)&_ZN6S584C53v13Ev,
  (VTBL_ENTRY)&_ZN6S584C53v14Ev,
  (VTBL_ENTRY)&_ZN6S584C53v15Ev,
  (VTBL_ENTRY)&_ZN6S584C53v16Ev,
  (VTBL_ENTRY)&_ZN6S584C53v17Ev,
  (VTBL_ENTRY)&_ZN6S584C53v18Ev,
  (VTBL_ENTRY)&_ZN6S584C53v19Ev,
  (VTBL_ENTRY)&_ZN6S584C53v20Ev,
  (VTBL_ENTRY)&_ZN6S584C53v21Ev,
  (VTBL_ENTRY)&_ZN6S584C53v22Ev,
  (VTBL_ENTRY)&_ZN6S584C53v23Ev,
  (VTBL_ENTRY)&_ZN6S584C53v24Ev,
  (VTBL_ENTRY)&_ZN6S584C53v25Ev,
  (VTBL_ENTRY)&_ZN6S584C53v26Ev,
  (VTBL_ENTRY)&_ZN6S584C53v27Ev,
  (VTBL_ENTRY)&_ZN6S584C53v28Ev,
  (VTBL_ENTRY)&_ZN6S584C53v29Ev,
  (VTBL_ENTRY)&_ZN6S584C53v30Ev,
  (VTBL_ENTRY)&_ZN6S584C53v31Ev,
  (VTBL_ENTRY)&_ZN6S584C53v32Ev,
  (VTBL_ENTRY)&_ZN6S584C53v33Ev,
  (VTBL_ENTRY)&_ZN6S584C53v34Ev,
  (VTBL_ENTRY)&_ZN6S584C53v35Ev,
  (VTBL_ENTRY)&_ZN6S584C53v36Ev,
  (VTBL_ENTRY)&_ZN6S584C53v37Ev,
  (VTBL_ENTRY)&_ZN6S584C53v38Ev,
  (VTBL_ENTRY)&_ZN6S584C53v39Ev,
  (VTBL_ENTRY)&_ZN6S584C53v40Ev,
  (VTBL_ENTRY)&_ZN6S584C53v41Ev,
  (VTBL_ENTRY)&_ZN6S584C53v42Ev,
  (VTBL_ENTRY)&_ZN6S584C53v43Ev,
  (VTBL_ENTRY)&_ZN6S584C53v44Ev,
  (VTBL_ENTRY)&_ZN6S584C53v45Ev,
  (VTBL_ENTRY)&_ZN6S584C53v46Ev,
  (VTBL_ENTRY)&_ZN6S584C53v47Ev,
  (VTBL_ENTRY)&_ZN6S584C53v48Ev,
  (VTBL_ENTRY)&_ZN6S584C53v49Ev,
  (VTBL_ENTRY)&_ZN6S584C53v50Ev,
  (VTBL_ENTRY)&_ZN6S584C53v51Ev,
  (VTBL_ENTRY)&_ZN6S584C53v52Ev,
  (VTBL_ENTRY)&_ZN6S584C53v53Ev,
  (VTBL_ENTRY)&_ZN6S584C53v54Ev,
  (VTBL_ENTRY)&_ZN6S584C53v55Ev,
  (VTBL_ENTRY)&_ZN6S584C53v56Ev,
  (VTBL_ENTRY)&_ZN6S584C53v57Ev,
  (VTBL_ENTRY)&_ZN6S584C53v58Ev,
  (VTBL_ENTRY)&_ZN6S584C53v59Ev,
  (VTBL_ENTRY)&_ZN6S584C53v60Ev,
  (VTBL_ENTRY)&_ZN6S584C53v61Ev,
  (VTBL_ENTRY)&_ZN6S584C53v62Ev,
  (VTBL_ENTRY)&_ZN6S584C53v63Ev,
  (VTBL_ENTRY)&_ZN6S584C53v64Ev,
  (VTBL_ENTRY)&_ZN6S584C53v65Ev,
  (VTBL_ENTRY)&_ZN6S584C53v66Ev,
  (VTBL_ENTRY)&_ZN6S584C53v67Ev,
  (VTBL_ENTRY)&_ZN6S584C43v68Ev,
  (VTBL_ENTRY)&_ZN6S584C43v69Ev,
  (VTBL_ENTRY)&_ZN6S584C43v70Ev,
  (VTBL_ENTRY)&_ZN6S584C43v71Ev,
  (VTBL_ENTRY)&_ZN6S584C43v72Ev,
  (VTBL_ENTRY)&_ZN6S584C43v73Ev,
  (VTBL_ENTRY)&_ZN6S584C43v74Ev,
  (VTBL_ENTRY)&_ZN6S584C43v75Ev,
  (VTBL_ENTRY)&_ZN6S584C43v76Ev,
  (VTBL_ENTRY)&_ZN6S584C43v77Ev,
  (VTBL_ENTRY)&_ZN6S584C43v78Ev,
  (VTBL_ENTRY)&_ZN6S584C43v79Ev,
  (VTBL_ENTRY)&_ZN6S584C43v80Ev,
  (VTBL_ENTRY)&_ZN6S584C43v81Ev,
  (VTBL_ENTRY)&_ZN6S584C43v82Ev,
  (VTBL_ENTRY)&_ZN6S584C43v83Ev,
  (VTBL_ENTRY)&_ZN6S584C43v84Ev,
  (VTBL_ENTRY)&_ZN6S584C43v85Ev,
  (VTBL_ENTRY)&_ZN6S584C43v86Ev,
  (VTBL_ENTRY)&_ZN6S584C43v87Ev,
  (VTBL_ENTRY)&_ZN6S584C43v88Ev,
  (VTBL_ENTRY)&_ZN6S584C43v89Ev,
  (VTBL_ENTRY)&_ZN6S584C33v90Ev,
  (VTBL_ENTRY)&_ZN6S584C33v91Ev,
  (VTBL_ENTRY)&_ZN6S584C33v92Ev,
  (VTBL_ENTRY)&_ZN6S584C33v93Ev,
  (VTBL_ENTRY)&_ZN6S584C33v94Ev,
  (VTBL_ENTRY)&_ZN6S584C33v95Ev,
  (VTBL_ENTRY)&_ZN6S584C33v96Ev,
  (VTBL_ENTRY)&_ZN6S584C33v97Ev,
  (VTBL_ENTRY)&_ZN6S584C33v98Ev,
  (VTBL_ENTRY)&_ZN6S584C33v99Ev,
  (VTBL_ENTRY)&_ZN6S584C34v100Ev,
  (VTBL_ENTRY)&_ZN6S584C34v101Ev,
  (VTBL_ENTRY)&_ZN6S584C34v102Ev,
  (VTBL_ENTRY)&_ZN6S584C34v103Ev,
  (VTBL_ENTRY)&_ZN6S584C34v104Ev,
  (VTBL_ENTRY)&_ZN6S584C34v105Ev,
  (VTBL_ENTRY)&_ZN6S584C34v106Ev,
  (VTBL_ENTRY)&_ZN6S584C34v107Ev,
  (VTBL_ENTRY)&_ZN6S584C34v108Ev,
  (VTBL_ENTRY)&_ZN6S584C34v109Ev,
  (VTBL_ENTRY)&_ZN6S584C24v110Ev,
  (VTBL_ENTRY)&_ZN6S584C24v111Ev,
  (VTBL_ENTRY)&_ZN6S584C24v112Ev,
  (VTBL_ENTRY)&_ZN6S584C24v113Ev,
  (VTBL_ENTRY)&_ZN6S584C12v1Ev,
  (VTBL_ENTRY)&_ZN6S584C12v2Ev,
  (VTBL_ENTRY)&_ZN6S584C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S584C1[];
extern  VTBL_ENTRY _ZTV6S584C1[];
Class_Descriptor cd_S584C1 = {  "S584C1", // class name
  bases_S584C1, 4,
  &(vtc_S584C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,228), // object size
  NSPAIRA(_ZTI6S584C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S584C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C6_nt  {
  ::S7368C9_nt s487c6f0;
  int s487c6f1;
  void  mf487c6(); // _ZN9S487C6_nt7mf487c6Ev
};
//SIG(-1 S487C6_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S487C6_nt ::mf487c6(){}

//skip512 S487C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C5_nt  {
  void *s487c5f0;
  ::S487C6_nt s487c5f1;
  char s487c5f2;
  int s487c5f3;
  virtual  ~S487C5_nt(); // _ZN9S487C5_ntD1Ev
  virtual void  v13(); // _ZN9S487C5_nt3v13Ev
  virtual void  v14(); // _ZN9S487C5_nt3v14Ev
  virtual void  v15(); // _ZN9S487C5_nt3v15Ev
  virtual void  v16(); // _ZN9S487C5_nt3v16Ev
  virtual void  v17(); // _ZN9S487C5_nt3v17Ev
  virtual void  v18(); // _ZN9S487C5_nt3v18Ev
  virtual void  v19(); // _ZN9S487C5_nt3v19Ev
  virtual void  v20(); // _ZN9S487C5_nt3v20Ev
  virtual void  v21(); // _ZN9S487C5_nt3v21Ev
  virtual void  v22(); // _ZN9S487C5_nt3v22Ev
  virtual void  v23(); // _ZN9S487C5_nt3v23Ev
  virtual void  v24(); // _ZN9S487C5_nt3v24Ev
  virtual void  v25(); // _ZN9S487C5_nt3v25Ev
  S487C5_nt(); // tgen
};
//SIG(-1 S487C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S487C5_nt ::~S487C5_nt(){ note_dtor("S487C5_nt", this);}
void  S487C5_nt ::v13(){vfunc_called(this, "_ZN9S487C5_nt3v13Ev");}
void  S487C5_nt ::v14(){vfunc_called(this, "_ZN9S487C5_nt3v14Ev");}
void  S487C5_nt ::v15(){vfunc_called(this, "_ZN9S487C5_nt3v15Ev");}
void  S487C5_nt ::v16(){vfunc_called(this, "_ZN9S487C5_nt3v16Ev");}
void  S487C5_nt ::v17(){vfunc_called(this, "_ZN9S487C5_nt3v17Ev");}
void  S487C5_nt ::v18(){vfunc_called(this, "_ZN9S487C5_nt3v18Ev");}
void  S487C5_nt ::v19(){vfunc_called(this, "_ZN9S487C5_nt3v19Ev");}
void  S487C5_nt ::v20(){vfunc_called(this, "_ZN9S487C5_nt3v20Ev");}
void  S487C5_nt ::v21(){vfunc_called(this, "_ZN9S487C5_nt3v21Ev");}
void  S487C5_nt ::v22(){vfunc_called(this, "_ZN9S487C5_nt3v22Ev");}
void  S487C5_nt ::v23(){vfunc_called(this, "_ZN9S487C5_nt3v23Ev");}
void  S487C5_nt ::v24(){vfunc_called(this, "_ZN9S487C5_nt3v24Ev");}
void  S487C5_nt ::v25(){vfunc_called(this, "_ZN9S487C5_nt3v25Ev");}
S487C5_nt ::S487C5_nt(){ note_ctor("S487C5_nt", this);} // tgen

//skip512 S487C5_nt

#else // __cplusplus

extern void _ZN9S487C5_ntC1Ev();
extern void _ZN9S487C5_ntD1Ev();
Name_Map name_map_S487C5_nt[] = {
  NSPAIR(_ZN9S487C5_ntC1Ev),
  NSPAIR(_ZN9S487C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S487C5_nt[];
extern void _ZN9S487C5_ntD1Ev();
extern void _ZN9S487C5_ntD0Ev();
extern void _ZN9S487C5_nt3v13Ev();
extern void _ZN9S487C5_nt3v14Ev();
extern void _ZN9S487C5_nt3v15Ev();
extern void _ZN9S487C5_nt3v16Ev();
extern void _ZN9S487C5_nt3v17Ev();
extern void _ZN9S487C5_nt3v18Ev();
extern void _ZN9S487C5_nt3v19Ev();
extern void _ZN9S487C5_nt3v20Ev();
extern void _ZN9S487C5_nt3v21Ev();
extern void _ZN9S487C5_nt3v22Ev();
extern void _ZN9S487C5_nt3v23Ev();
extern void _ZN9S487C5_nt3v24Ev();
extern void _ZN9S487C5_nt3v25Ev();
static  VTBL_ENTRY vtc_S487C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S487C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S487C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S487C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v25Ev,
};
extern VTBL_ENTRY _ZTI9S487C5_nt[];
VTBL_ENTRY *P__ZTI9S487C5_nt = _ZTI9S487C5_nt; 
extern  VTBL_ENTRY _ZTV9S487C5_nt[];
Class_Descriptor cd_S487C5_nt = {  "S487C5_nt", // class name
  0,0,//no base classes
  &(vtc_S487C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI9S487C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S487C5_nt),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C4_nt  : S487C5_nt {
  void *s487c4f0[3];
  int s487c4f1;
  virtual  ~S487C4_nt(); // _ZN9S487C4_ntD1Ev
  virtual void  v26(); // _ZN9S487C4_nt3v26Ev
  virtual void  v27(); // _ZN9S487C4_nt3v27Ev
  virtual void  v28(); // _ZN9S487C4_nt3v28Ev
  virtual void  v29(); // _ZN9S487C4_nt3v29Ev
  virtual void  v30(); // _ZN9S487C4_nt3v30Ev
  virtual void  v31(); // _ZN9S487C4_nt3v31Ev
  virtual void  v32(); // _ZN9S487C4_nt3v32Ev
  virtual void  v33(); // _ZN9S487C4_nt3v33Ev
  virtual void  v34(); // _ZN9S487C4_nt3v34Ev
  virtual void  v35(); // _ZN9S487C4_nt3v35Ev
  virtual void  v36(); // _ZN9S487C4_nt3v36Ev
  S487C4_nt(); // tgen
};
//SIG(-1 S487C4_nt) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S487C4_nt ::~S487C4_nt(){ note_dtor("S487C4_nt", this);}
void  S487C4_nt ::v26(){vfunc_called(this, "_ZN9S487C4_nt3v26Ev");}
void  S487C4_nt ::v27(){vfunc_called(this, "_ZN9S487C4_nt3v27Ev");}
void  S487C4_nt ::v28(){vfunc_called(this, "_ZN9S487C4_nt3v28Ev");}
void  S487C4_nt ::v29(){vfunc_called(this, "_ZN9S487C4_nt3v29Ev");}
void  S487C4_nt ::v30(){vfunc_called(this, "_ZN9S487C4_nt3v30Ev");}
void  S487C4_nt ::v31(){vfunc_called(this, "_ZN9S487C4_nt3v31Ev");}
void  S487C4_nt ::v32(){vfunc_called(this, "_ZN9S487C4_nt3v32Ev");}
void  S487C4_nt ::v33(){vfunc_called(this, "_ZN9S487C4_nt3v33Ev");}
void  S487C4_nt ::v34(){vfunc_called(this, "_ZN9S487C4_nt3v34Ev");}
void  S487C4_nt ::v35(){vfunc_called(this, "_ZN9S487C4_nt3v35Ev");}
void  S487C4_nt ::v36(){vfunc_called(this, "_ZN9S487C4_nt3v36Ev");}
S487C4_nt ::S487C4_nt(){ note_ctor("S487C4_nt", this);} // tgen

//skip512 S487C4_nt

#else // __cplusplus

extern void _ZN9S487C4_ntC1Ev();
extern void _ZN9S487C4_ntD1Ev();
Name_Map name_map_S487C4_nt[] = {
  NSPAIR(_ZN9S487C4_ntC1Ev),
  NSPAIR(_ZN9S487C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S487C5_nt;
extern VTBL_ENTRY _ZTI9S487C5_nt[];
extern  VTBL_ENTRY _ZTV9S487C5_nt[];
static Base_Class bases_S487C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S487C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S487C4_nt[];
extern void _ZN9S487C4_ntD1Ev();
extern void _ZN9S487C4_ntD0Ev();
extern void _ZN9S487C5_nt3v13Ev();
extern void _ZN9S487C5_nt3v14Ev();
extern void _ZN9S487C5_nt3v15Ev();
extern void _ZN9S487C5_nt3v16Ev();
extern void _ZN9S487C5_nt3v17Ev();
extern void _ZN9S487C5_nt3v18Ev();
extern void _ZN9S487C5_nt3v19Ev();
extern void _ZN9S487C5_nt3v20Ev();
extern void _ZN9S487C5_nt3v21Ev();
extern void _ZN9S487C5_nt3v22Ev();
extern void _ZN9S487C5_nt3v23Ev();
extern void _ZN9S487C5_nt3v24Ev();
extern void _ZN9S487C5_nt3v25Ev();
extern void _ZN9S487C4_nt3v26Ev();
extern void _ZN9S487C4_nt3v27Ev();
extern void _ZN9S487C4_nt3v28Ev();
extern void _ZN9S487C4_nt3v29Ev();
extern void _ZN9S487C4_nt3v30Ev();
extern void _ZN9S487C4_nt3v31Ev();
extern void _ZN9S487C4_nt3v32Ev();
extern void _ZN9S487C4_nt3v33Ev();
extern void _ZN9S487C4_nt3v34Ev();
extern void _ZN9S487C4_nt3v35Ev();
extern void _ZN9S487C4_nt3v36Ev();
static  VTBL_ENTRY vtc_S487C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S487C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S487C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S487C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v36Ev,
};
extern VTBL_ENTRY _ZTI9S487C4_nt[];
VTBL_ENTRY *P__ZTI9S487C4_nt = _ZTI9S487C4_nt; 
extern  VTBL_ENTRY _ZTV9S487C4_nt[];
Class_Descriptor cd_S487C4_nt = {  "S487C4_nt", // class name
  bases_S487C4_nt, 1,
  &(vtc_S487C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI9S487C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S487C4_nt),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C10_nt  {
  __tsi64 s487c10f0;
  void  mf487c10(); // _ZN10S487C10_nt8mf487c10Ev
};
//SIG(-1 S487C10_nt) C1{ m FL}


void  S487C10_nt ::mf487c10(){}

//skip512 S487C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C9_nt  {
  ::S487C10_nt s487c9f0;
  void  mf487c9(); // _ZN9S487C9_nt7mf487c9Ev
};
//SIG(-1 S487C9_nt) C1{ m FC2{ m FL}}


void  S487C9_nt ::mf487c9(){}

//skip512 S487C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C3_nt  : S487C4_nt {
  void *s487c3f0[2];
  int s487c3f1[3];
  ::S487C6_nt s487c3f2;
  char s487c3f3;
  ::S487C9_nt s487c3f4;
  char s487c3f5;
  int s487c3f6;
  char s487c3f7;
  int s487c3f8;
  char s487c3f9[2];
  int s487c3f10;
  char s487c3f11;
  virtual  ~S487C3_nt(); // _ZN9S487C3_ntD1Ev
  virtual void  v37(); // _ZN9S487C3_nt3v37Ev
  virtual void  v38(); // _ZN9S487C3_nt3v38Ev
  virtual void  v39(); // _ZN9S487C3_nt3v39Ev
  virtual void  v40(); // _ZN9S487C3_nt3v40Ev
  virtual void  v41(); // _ZN9S487C3_nt3v41Ev
  virtual void  v42(); // _ZN9S487C3_nt3v42Ev
  virtual void  v43(); // _ZN9S487C3_nt3v43Ev
  virtual void  v44(); // _ZN9S487C3_nt3v44Ev
  virtual void  v45(); // _ZN9S487C3_nt3v45Ev
  virtual void  v46(); // _ZN9S487C3_nt3v46Ev
  virtual void  v47(); // _ZN9S487C3_nt3v47Ev
  virtual void  v48(); // _ZN9S487C3_nt3v48Ev
  virtual void  v49(); // _ZN9S487C3_nt3v49Ev
  virtual void  v50(); // _ZN9S487C3_nt3v50Ev
  virtual void  v51(); // _ZN9S487C3_nt3v51Ev
  virtual void  v52(); // _ZN9S487C3_nt3v52Ev
  virtual void  v53(); // _ZN9S487C3_nt3v53Ev
  S487C3_nt(); // tgen
};
//SIG(-1 S487C3_nt) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S487C3_nt ::~S487C3_nt(){ note_dtor("S487C3_nt", this);}
void  S487C3_nt ::v37(){vfunc_called(this, "_ZN9S487C3_nt3v37Ev");}
void  S487C3_nt ::v38(){vfunc_called(this, "_ZN9S487C3_nt3v38Ev");}
void  S487C3_nt ::v39(){vfunc_called(this, "_ZN9S487C3_nt3v39Ev");}
void  S487C3_nt ::v40(){vfunc_called(this, "_ZN9S487C3_nt3v40Ev");}
void  S487C3_nt ::v41(){vfunc_called(this, "_ZN9S487C3_nt3v41Ev");}
void  S487C3_nt ::v42(){vfunc_called(this, "_ZN9S487C3_nt3v42Ev");}
void  S487C3_nt ::v43(){vfunc_called(this, "_ZN9S487C3_nt3v43Ev");}
void  S487C3_nt ::v44(){vfunc_called(this, "_ZN9S487C3_nt3v44Ev");}
void  S487C3_nt ::v45(){vfunc_called(this, "_ZN9S487C3_nt3v45Ev");}
void  S487C3_nt ::v46(){vfunc_called(this, "_ZN9S487C3_nt3v46Ev");}
void  S487C3_nt ::v47(){vfunc_called(this, "_ZN9S487C3_nt3v47Ev");}
void  S487C3_nt ::v48(){vfunc_called(this, "_ZN9S487C3_nt3v48Ev");}
void  S487C3_nt ::v49(){vfunc_called(this, "_ZN9S487C3_nt3v49Ev");}
void  S487C3_nt ::v50(){vfunc_called(this, "_ZN9S487C3_nt3v50Ev");}
void  S487C3_nt ::v51(){vfunc_called(this, "_ZN9S487C3_nt3v51Ev");}
void  S487C3_nt ::v52(){vfunc_called(this, "_ZN9S487C3_nt3v52Ev");}
void  S487C3_nt ::v53(){vfunc_called(this, "_ZN9S487C3_nt3v53Ev");}
S487C3_nt ::S487C3_nt(){ note_ctor("S487C3_nt", this);} // tgen

//skip512 S487C3_nt

#else // __cplusplus

extern void _ZN9S487C3_ntC1Ev();
extern void _ZN9S487C3_ntD1Ev();
Name_Map name_map_S487C3_nt[] = {
  NSPAIR(_ZN9S487C3_ntC1Ev),
  NSPAIR(_ZN9S487C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S487C5_nt;
extern VTBL_ENTRY _ZTI9S487C5_nt[];
extern  VTBL_ENTRY _ZTV9S487C5_nt[];
extern Class_Descriptor cd_S487C4_nt;
extern VTBL_ENTRY _ZTI9S487C4_nt[];
extern  VTBL_ENTRY _ZTV9S487C4_nt[];
static Base_Class bases_S487C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S487C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S487C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S487C3_nt[];
extern void _ZN9S487C3_ntD1Ev();
extern void _ZN9S487C3_ntD0Ev();
extern void _ZN9S487C5_nt3v13Ev();
extern void _ZN9S487C5_nt3v14Ev();
extern void _ZN9S487C5_nt3v15Ev();
extern void _ZN9S487C5_nt3v16Ev();
extern void _ZN9S487C5_nt3v17Ev();
extern void _ZN9S487C5_nt3v18Ev();
extern void _ZN9S487C5_nt3v19Ev();
extern void _ZN9S487C5_nt3v20Ev();
extern void _ZN9S487C5_nt3v21Ev();
extern void _ZN9S487C5_nt3v22Ev();
extern void _ZN9S487C5_nt3v23Ev();
extern void _ZN9S487C5_nt3v24Ev();
extern void _ZN9S487C5_nt3v25Ev();
extern void _ZN9S487C4_nt3v26Ev();
extern void _ZN9S487C4_nt3v27Ev();
extern void _ZN9S487C4_nt3v28Ev();
extern void _ZN9S487C4_nt3v29Ev();
extern void _ZN9S487C4_nt3v30Ev();
extern void _ZN9S487C4_nt3v31Ev();
extern void _ZN9S487C4_nt3v32Ev();
extern void _ZN9S487C4_nt3v33Ev();
extern void _ZN9S487C4_nt3v34Ev();
extern void _ZN9S487C4_nt3v35Ev();
extern void _ZN9S487C4_nt3v36Ev();
extern void _ZN9S487C3_nt3v37Ev();
extern void _ZN9S487C3_nt3v38Ev();
extern void _ZN9S487C3_nt3v39Ev();
extern void _ZN9S487C3_nt3v40Ev();
extern void _ZN9S487C3_nt3v41Ev();
extern void _ZN9S487C3_nt3v42Ev();
extern void _ZN9S487C3_nt3v43Ev();
extern void _ZN9S487C3_nt3v44Ev();
extern void _ZN9S487C3_nt3v45Ev();
extern void _ZN9S487C3_nt3v46Ev();
extern void _ZN9S487C3_nt3v47Ev();
extern void _ZN9S487C3_nt3v48Ev();
extern void _ZN9S487C3_nt3v49Ev();
extern void _ZN9S487C3_nt3v50Ev();
extern void _ZN9S487C3_nt3v51Ev();
extern void _ZN9S487C3_nt3v52Ev();
extern void _ZN9S487C3_nt3v53Ev();
static  VTBL_ENTRY vtc_S487C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S487C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S487C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S487C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v53Ev,
};
extern VTBL_ENTRY _ZTI9S487C3_nt[];
VTBL_ENTRY *P__ZTI9S487C3_nt = _ZTI9S487C3_nt; 
extern  VTBL_ENTRY _ZTV9S487C3_nt[];
Class_Descriptor cd_S487C3_nt = {  "S487C3_nt", // class name
  bases_S487C3_nt, 2,
  &(vtc_S487C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI9S487C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S487C3_nt),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C2_nt  : S487C3_nt {
  int s487c2f0[4];
  virtual  ~S487C2_nt(); // _ZN9S487C2_ntD1Ev
  virtual void  v54(); // _ZN9S487C2_nt3v54Ev
  virtual void  v55(); // _ZN9S487C2_nt3v55Ev
  virtual void  v56(); // _ZN9S487C2_nt3v56Ev
  virtual void  v57(); // _ZN9S487C2_nt3v57Ev
  virtual void  v58(); // _ZN9S487C2_nt3v58Ev
  virtual void  v59(); // _ZN9S487C2_nt3v59Ev
  virtual void  v60(); // _ZN9S487C2_nt3v60Ev
  virtual void  v61(); // _ZN9S487C2_nt3v61Ev
  virtual void  v62(); // _ZN9S487C2_nt3v62Ev
  virtual void  v63(); // _ZN9S487C2_nt3v63Ev
  virtual void  v64(); // _ZN9S487C2_nt3v64Ev
  virtual void  v65(); // _ZN9S487C2_nt3v65Ev
  virtual void  v66(); // _ZN9S487C2_nt3v66Ev
  S487C2_nt(); // tgen
};
//SIG(-1 S487C2_nt) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[3] Fi} vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fi[4]}


 S487C2_nt ::~S487C2_nt(){ note_dtor("S487C2_nt", this);}
void  S487C2_nt ::v54(){vfunc_called(this, "_ZN9S487C2_nt3v54Ev");}
void  S487C2_nt ::v55(){vfunc_called(this, "_ZN9S487C2_nt3v55Ev");}
void  S487C2_nt ::v56(){vfunc_called(this, "_ZN9S487C2_nt3v56Ev");}
void  S487C2_nt ::v57(){vfunc_called(this, "_ZN9S487C2_nt3v57Ev");}
void  S487C2_nt ::v58(){vfunc_called(this, "_ZN9S487C2_nt3v58Ev");}
void  S487C2_nt ::v59(){vfunc_called(this, "_ZN9S487C2_nt3v59Ev");}
void  S487C2_nt ::v60(){vfunc_called(this, "_ZN9S487C2_nt3v60Ev");}
void  S487C2_nt ::v61(){vfunc_called(this, "_ZN9S487C2_nt3v61Ev");}
void  S487C2_nt ::v62(){vfunc_called(this, "_ZN9S487C2_nt3v62Ev");}
void  S487C2_nt ::v63(){vfunc_called(this, "_ZN9S487C2_nt3v63Ev");}
void  S487C2_nt ::v64(){vfunc_called(this, "_ZN9S487C2_nt3v64Ev");}
void  S487C2_nt ::v65(){vfunc_called(this, "_ZN9S487C2_nt3v65Ev");}
void  S487C2_nt ::v66(){vfunc_called(this, "_ZN9S487C2_nt3v66Ev");}
S487C2_nt ::S487C2_nt(){ note_ctor("S487C2_nt", this);} // tgen

//skip512 S487C2_nt

#else // __cplusplus

extern void _ZN9S487C2_ntC1Ev();
extern void _ZN9S487C2_ntD1Ev();
Name_Map name_map_S487C2_nt[] = {
  NSPAIR(_ZN9S487C2_ntC1Ev),
  NSPAIR(_ZN9S487C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S487C5_nt;
extern VTBL_ENTRY _ZTI9S487C5_nt[];
extern  VTBL_ENTRY _ZTV9S487C5_nt[];
extern Class_Descriptor cd_S487C4_nt;
extern VTBL_ENTRY _ZTI9S487C4_nt[];
extern  VTBL_ENTRY _ZTV9S487C4_nt[];
extern Class_Descriptor cd_S487C3_nt;
extern VTBL_ENTRY _ZTI9S487C3_nt[];
extern  VTBL_ENTRY _ZTV9S487C3_nt[];
static Base_Class bases_S487C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S487C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S487C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S487C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S487C2_nt[];
extern void _ZN9S487C2_ntD1Ev();
extern void _ZN9S487C2_ntD0Ev();
extern void _ZN9S487C5_nt3v13Ev();
extern void _ZN9S487C5_nt3v14Ev();
extern void _ZN9S487C5_nt3v15Ev();
extern void _ZN9S487C5_nt3v16Ev();
extern void _ZN9S487C5_nt3v17Ev();
extern void _ZN9S487C5_nt3v18Ev();
extern void _ZN9S487C5_nt3v19Ev();
extern void _ZN9S487C5_nt3v20Ev();
extern void _ZN9S487C5_nt3v21Ev();
extern void _ZN9S487C5_nt3v22Ev();
extern void _ZN9S487C5_nt3v23Ev();
extern void _ZN9S487C5_nt3v24Ev();
extern void _ZN9S487C5_nt3v25Ev();
extern void _ZN9S487C4_nt3v26Ev();
extern void _ZN9S487C4_nt3v27Ev();
extern void _ZN9S487C4_nt3v28Ev();
extern void _ZN9S487C4_nt3v29Ev();
extern void _ZN9S487C4_nt3v30Ev();
extern void _ZN9S487C4_nt3v31Ev();
extern void _ZN9S487C4_nt3v32Ev();
extern void _ZN9S487C4_nt3v33Ev();
extern void _ZN9S487C4_nt3v34Ev();
extern void _ZN9S487C4_nt3v35Ev();
extern void _ZN9S487C4_nt3v36Ev();
extern void _ZN9S487C3_nt3v37Ev();
extern void _ZN9S487C3_nt3v38Ev();
extern void _ZN9S487C3_nt3v39Ev();
extern void _ZN9S487C3_nt3v40Ev();
extern void _ZN9S487C3_nt3v41Ev();
extern void _ZN9S487C3_nt3v42Ev();
extern void _ZN9S487C3_nt3v43Ev();
extern void _ZN9S487C3_nt3v44Ev();
extern void _ZN9S487C3_nt3v45Ev();
extern void _ZN9S487C3_nt3v46Ev();
extern void _ZN9S487C3_nt3v47Ev();
extern void _ZN9S487C3_nt3v48Ev();
extern void _ZN9S487C3_nt3v49Ev();
extern void _ZN9S487C3_nt3v50Ev();
extern void _ZN9S487C3_nt3v51Ev();
extern void _ZN9S487C3_nt3v52Ev();
extern void _ZN9S487C3_nt3v53Ev();
extern void _ZN9S487C2_nt3v54Ev();
extern void _ZN9S487C2_nt3v55Ev();
extern void _ZN9S487C2_nt3v56Ev();
extern void _ZN9S487C2_nt3v57Ev();
extern void _ZN9S487C2_nt3v58Ev();
extern void _ZN9S487C2_nt3v59Ev();
extern void _ZN9S487C2_nt3v60Ev();
extern void _ZN9S487C2_nt3v61Ev();
extern void _ZN9S487C2_nt3v62Ev();
extern void _ZN9S487C2_nt3v63Ev();
extern void _ZN9S487C2_nt3v64Ev();
extern void _ZN9S487C2_nt3v65Ev();
extern void _ZN9S487C2_nt3v66Ev();
static  VTBL_ENTRY vtc_S487C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S487C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S487C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S487C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v66Ev,
};
extern VTBL_ENTRY _ZTI9S487C2_nt[];
VTBL_ENTRY *P__ZTI9S487C2_nt = _ZTI9S487C2_nt; 
extern  VTBL_ENTRY _ZTV9S487C2_nt[];
Class_Descriptor cd_S487C2_nt = {  "S487C2_nt", // class name
  bases_S487C2_nt, 3,
  &(vtc_S487C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI9S487C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S487C2_nt),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C11_nt  {
  void *s487c11f0;
  int s487c11f1;
  ::S7368C78 s487c11f2;
  void  mf487c11(); // _ZN10S487C11_nt8mf487c11Ev
};
//SIG(-1 S487C11_nt) C1{ m Fp Fi FC2{ m}}


void  S487C11_nt ::mf487c11(){}

//skip512 S487C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C14_nt  {
  void *s487c14f0[2];
  void  mf487c14(); // _ZN10S487C14_nt8mf487c14Ev
};
//SIG(-1 S487C14_nt) C1{ m Fp[2]}


void  S487C14_nt ::mf487c14(){}

//skip512 S487C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C16  {
  void *s487c16f0[2];
  void  mf487c16(); // _ZN7S487C168mf487c16Ev
};
//SIG(-1 S487C16) C1{ m Fp[2]}


void  S487C16 ::mf487c16(){}

static void Test_S487C16()
{
  {
    init_simple_test("S487C16");
    S487C16 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S487C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S487C16)");
    check_field_offset(lv, s487c16f0, 0, "S487C16.s487c16f0");
  }
}
static Arrange_To_Call_Me vS487C16(Test_S487C16, "S487C16", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C22_nt  {
  __tsi64 s487c22f0;
  void *s487c22f1;
  int s487c22f2;
  virtual  ~S487C22_nt(); // _ZN10S487C22_ntD1Ev
  virtual void  v69(); // _ZN10S487C22_nt3v69Ev
  virtual void  v70(); // _ZN10S487C22_nt3v70Ev
  virtual void  v71(); // _ZN10S487C22_nt3v71Ev
  S487C22_nt(); // tgen
};
//SIG(-1 S487C22_nt) C1{ vd v1 v2 v3 FL Fp Fi}


 S487C22_nt ::~S487C22_nt(){ note_dtor("S487C22_nt", this);}
void  S487C22_nt ::v69(){vfunc_called(this, "_ZN10S487C22_nt3v69Ev");}
void  S487C22_nt ::v70(){vfunc_called(this, "_ZN10S487C22_nt3v70Ev");}
void  S487C22_nt ::v71(){vfunc_called(this, "_ZN10S487C22_nt3v71Ev");}
S487C22_nt ::S487C22_nt(){ note_ctor("S487C22_nt", this);} // tgen

//skip512 S487C22_nt

#else // __cplusplus

extern void _ZN10S487C22_ntC1Ev();
extern void _ZN10S487C22_ntD1Ev();
Name_Map name_map_S487C22_nt[] = {
  NSPAIR(_ZN10S487C22_ntC1Ev),
  NSPAIR(_ZN10S487C22_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S487C22_nt[];
extern void _ZN10S487C22_ntD1Ev();
extern void _ZN10S487C22_ntD0Ev();
extern void _ZN10S487C22_nt3v69Ev();
extern void _ZN10S487C22_nt3v70Ev();
extern void _ZN10S487C22_nt3v71Ev();
static  VTBL_ENTRY vtc_S487C22_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S487C22_nt[0]),
  (VTBL_ENTRY)&_ZN10S487C22_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S487C22_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v71Ev,
};
extern VTBL_ENTRY _ZTI10S487C22_nt[];
VTBL_ENTRY *P__ZTI10S487C22_nt = _ZTI10S487C22_nt; 
extern  VTBL_ENTRY _ZTV10S487C22_nt[];
Class_Descriptor cd_S487C22_nt = {  "S487C22_nt", // class name
  0,0,//no base classes
  &(vtc_S487C22_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI10S487C22_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S487C22_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C21_nt  : S487C22_nt {
  int s487c21f0;
  char s487c21f1;
  virtual  ~S487C21_nt(); // _ZN10S487C21_ntD1Ev
  virtual void  v67(); // _ZN10S487C21_nt3v67Ev
  virtual void  v68(); // _ZN10S487C21_nt3v68Ev
  S487C21_nt(); // tgen
};
//SIG(1 S487C21_nt) C1{ BC2{ vd v3 v4 v5 FL Fp Fi} vd v1 v2 Fi Fc}


 S487C21_nt ::~S487C21_nt(){ note_dtor("S487C21_nt", this);}
void  S487C21_nt ::v67(){vfunc_called(this, "_ZN10S487C21_nt3v67Ev");}
void  S487C21_nt ::v68(){vfunc_called(this, "_ZN10S487C21_nt3v68Ev");}
S487C21_nt ::S487C21_nt(){ note_ctor("S487C21_nt", this);} // tgen

//skip512 S487C21_nt

#else // __cplusplus

extern void _ZN10S487C21_ntC1Ev();
extern void _ZN10S487C21_ntD1Ev();
Name_Map name_map_S487C21_nt[] = {
  NSPAIR(_ZN10S487C21_ntC1Ev),
  NSPAIR(_ZN10S487C21_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S487C22_nt;
extern VTBL_ENTRY _ZTI10S487C22_nt[];
extern  VTBL_ENTRY _ZTV10S487C22_nt[];
static Base_Class bases_S487C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S487C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S487C21_nt[];
extern void _ZN10S487C21_ntD1Ev();
extern void _ZN10S487C21_ntD0Ev();
extern void _ZN10S487C22_nt3v69Ev();
extern void _ZN10S487C22_nt3v70Ev();
extern void _ZN10S487C22_nt3v71Ev();
extern void _ZN10S487C21_nt3v67Ev();
extern void _ZN10S487C21_nt3v68Ev();
static  VTBL_ENTRY vtc_S487C21_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S487C21_nt[0]),
  (VTBL_ENTRY)&_ZN10S487C21_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S487C21_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S487C22_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S487C21_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S487C21_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI10S487C21_nt[];
VTBL_ENTRY *P__ZTI10S487C21_nt = _ZTI10S487C21_nt; 
extern  VTBL_ENTRY _ZTV10S487C21_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S487C1  : S487C2_nt {
  int s487c1f0[4];
  ::S487C11_nt s487c1f1;
  ::S487C11_nt s487c1f2;
  char s487c1f3[3];
  int s487c1f4;
  __tsi64 s487c1f5;
  ::S499C36_nt s487c1f6;
  ::S487C14_nt s487c1f7;
  ::S487C14_nt s487c1f8;
  ::S487C16 s487c1f9;
  void *s487c1f10[2];
  ::S7368C77 s487c1f11;
  __tsi64 s487c1f12[2];
  char s487c1f13;
  int s487c1f14;
  char s487c1f15[2];
  ::S7368C69_nt s487c1f16;
  ::S7368C69_nt s487c1f17;
  char s487c1f18;
  int s487c1f19;
  ::S487C21_nt s487c1f20[100];
  ::S10256C11 s487c1f21;
  void *s487c1f22;
  char s487c1f23;
  int s487c1f24;
  virtual  ~S487C1(); // _ZN6S487C1D1Ev
  virtual void  v1(); // _ZN6S487C12v1Ev
  virtual void  v2(); // _ZN6S487C12v2Ev
  virtual void  v3(); // _ZN6S487C12v3Ev
  virtual void  v4(); // _ZN6S487C12v4Ev
  virtual void  v5(); // _ZN6S487C12v5Ev
  virtual void  v6(); // _ZN6S487C12v6Ev
  virtual void  v7(); // _ZN6S487C12v7Ev
  virtual void  v8(); // _ZN6S487C12v8Ev
  virtual void  v9(); // _ZN6S487C12v9Ev
  virtual void  v10(); // _ZN6S487C13v10Ev
  virtual void  v11(); // _ZN6S487C13v11Ev
  virtual void  v12(); // _ZN6S487C13v12Ev
  S487C1(); // tgen
};
//SIG(1 S487C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fc Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 Fp[3] Fi} vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 Fp[2] Fi[3] FC6 Fc FC9{ m FC10{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi[4]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fi[4] FC11{ m Fp Fi FC12{ m}} FC11 Fc[3] Fi FL FC13{ m Fp[2]} FC14{ m Fp[2]} FC14 FC15{ m Fp[2]} Fp[2] FC16{ m Fp Fi[2] FC12} FL[2] Fc Fi Fc[2] FC17{ m FC18{ m FL[2]}} FC17 Fc Fi FC19{ BC20{ vd v69 v70 v71 FL Fp Fi} vd v67 v68 Fi Fc}[100] FC21{ m FC22{ m Fi[4] Fp Fc Fi[2] Fp[2]} Fi[5] FL[2] FC23{ Fi} Fi Fc Fi Fc} Fp Fc Fi}


 S487C1 ::~S487C1(){ note_dtor("S487C1", this);}
void  S487C1 ::v1(){vfunc_called(this, "_ZN6S487C12v1Ev");}
void  S487C1 ::v2(){vfunc_called(this, "_ZN6S487C12v2Ev");}
void  S487C1 ::v3(){vfunc_called(this, "_ZN6S487C12v3Ev");}
void  S487C1 ::v4(){vfunc_called(this, "_ZN6S487C12v4Ev");}
void  S487C1 ::v5(){vfunc_called(this, "_ZN6S487C12v5Ev");}
void  S487C1 ::v6(){vfunc_called(this, "_ZN6S487C12v6Ev");}
void  S487C1 ::v7(){vfunc_called(this, "_ZN6S487C12v7Ev");}
void  S487C1 ::v8(){vfunc_called(this, "_ZN6S487C12v8Ev");}
void  S487C1 ::v9(){vfunc_called(this, "_ZN6S487C12v9Ev");}
void  S487C1 ::v10(){vfunc_called(this, "_ZN6S487C13v10Ev");}
void  S487C1 ::v11(){vfunc_called(this, "_ZN6S487C13v11Ev");}
void  S487C1 ::v12(){vfunc_called(this, "_ZN6S487C13v12Ev");}
S487C1 ::S487C1(){ note_ctor("S487C1", this);} // tgen

static void Test_S487C1()
{
  extern Class_Descriptor cd_S487C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(573,808)];
    init_test(&cd_S487C1, buf);
    S487C1 *dp, &lv = *(dp=new (buf) S487C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4576,3228), "sizeof(S487C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S487C1)");
    check_base_class_offset(lv, (S487C5_nt*)(S487C4_nt*)(S487C3_nt*)(S487C2_nt*), 0, "S487C1");
    check_base_class_offset(lv, (S487C4_nt*)(S487C3_nt*)(S487C2_nt*), 0, "S487C1");
    check_base_class_offset(lv, (S487C3_nt*)(S487C2_nt*), 0, "S487C1");
    check_base_class_offset(lv, (S487C2_nt*), 0, "S487C1");
    check_field_offset(lv, s487c1f0, ABISELECT(196,140), "S487C1.s487c1f0");
    check_field_offset(lv, s487c1f1, ABISELECT(216,156), "S487C1.s487c1f1");
    check_field_offset(lv, s487c1f2, ABISELECT(232,168), "S487C1.s487c1f2");
    check_field_offset(lv, s487c1f3, ABISELECT(248,180), "S487C1.s487c1f3");
    check_field_offset(lv, s487c1f4, ABISELECT(252,184), "S487C1.s487c1f4");
    check_field_offset(lv, s487c1f5, ABISELECT(256,188), "S487C1.s487c1f5");
    check_field_offset(lv, s487c1f6, ABISELECT(264,196), "S487C1.s487c1f6");
    check_field_offset(lv, s487c1f7, ABISELECT(280,204), "S487C1.s487c1f7");
    check_field_offset(lv, s487c1f8, ABISELECT(296,212), "S487C1.s487c1f8");
    check_field_offset(lv, s487c1f9, ABISELECT(312,220), "S487C1.s487c1f9");
    check_field_offset(lv, s487c1f10, ABISELECT(328,228), "S487C1.s487c1f10");
    check_field_offset(lv, s487c1f11, ABISELECT(344,236), "S487C1.s487c1f11");
    check_field_offset(lv, s487c1f12, ABISELECT(368,252), "S487C1.s487c1f12");
    check_field_offset(lv, s487c1f13, ABISELECT(384,268), "S487C1.s487c1f13");
    check_field_offset(lv, s487c1f14, ABISELECT(388,272), "S487C1.s487c1f14");
    check_field_offset(lv, s487c1f15, ABISELECT(392,276), "S487C1.s487c1f15");
    check_field_offset(lv, s487c1f16, ABISELECT(400,280), "S487C1.s487c1f16");
    check_field_offset(lv, s487c1f17, ABISELECT(416,296), "S487C1.s487c1f17");
    check_field_offset(lv, s487c1f18, ABISELECT(432,312), "S487C1.s487c1f18");
    check_field_offset(lv, s487c1f19, ABISELECT(436,316), "S487C1.s487c1f19");
    check_field_offset(lv, s487c1f20, ABISELECT(440,320), "S487C1.s487c1f20");
    check_field_offset(lv, s487c1f21, ABISELECT(4440,3120), "S487C1.s487c1f21");
    check_field_offset(lv, s487c1f22, ABISELECT(4560,3216), "S487C1.s487c1f22");
    check_field_offset(lv, s487c1f23, ABISELECT(4568,3220), "S487C1.s487c1f23");
    check_field_offset(lv, s487c1f24, ABISELECT(4572,3224), "S487C1.s487c1f24");
    test_class_info(&lv, &cd_S487C1);
    dp->~S487C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS487C1(Test_S487C1, "S487C1", ABISELECT(4576,3228));

#else // __cplusplus

extern void _ZN6S487C1C1Ev();
extern void _ZN6S487C1D1Ev();
Name_Map name_map_S487C1[] = {
  NSPAIR(_ZN6S487C1C1Ev),
  NSPAIR(_ZN6S487C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S487C5_nt;
extern VTBL_ENTRY _ZTI9S487C5_nt[];
extern  VTBL_ENTRY _ZTV9S487C5_nt[];
extern Class_Descriptor cd_S487C4_nt;
extern VTBL_ENTRY _ZTI9S487C4_nt[];
extern  VTBL_ENTRY _ZTV9S487C4_nt[];
extern Class_Descriptor cd_S487C3_nt;
extern VTBL_ENTRY _ZTI9S487C3_nt[];
extern  VTBL_ENTRY _ZTV9S487C3_nt[];
extern Class_Descriptor cd_S487C2_nt;
extern VTBL_ENTRY _ZTI9S487C2_nt[];
extern  VTBL_ENTRY _ZTV9S487C2_nt[];
static Base_Class bases_S487C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S487C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S487C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S487C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S487C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S487C1[];
extern void _ZN6S487C1D1Ev();
extern void _ZN6S487C1D0Ev();
extern void _ZN9S487C5_nt3v13Ev();
extern void _ZN9S487C5_nt3v14Ev();
extern void _ZN9S487C5_nt3v15Ev();
extern void _ZN9S487C5_nt3v16Ev();
extern void _ZN9S487C5_nt3v17Ev();
extern void _ZN9S487C5_nt3v18Ev();
extern void _ZN9S487C5_nt3v19Ev();
extern void _ZN9S487C5_nt3v20Ev();
extern void _ZN9S487C5_nt3v21Ev();
extern void _ZN9S487C5_nt3v22Ev();
extern void _ZN9S487C5_nt3v23Ev();
extern void _ZN9S487C5_nt3v24Ev();
extern void _ZN9S487C5_nt3v25Ev();
extern void _ZN9S487C4_nt3v26Ev();
extern void _ZN9S487C4_nt3v27Ev();
extern void _ZN9S487C4_nt3v28Ev();
extern void _ZN9S487C4_nt3v29Ev();
extern void _ZN9S487C4_nt3v30Ev();
extern void _ZN9S487C4_nt3v31Ev();
extern void _ZN9S487C4_nt3v32Ev();
extern void _ZN9S487C4_nt3v33Ev();
extern void _ZN9S487C4_nt3v34Ev();
extern void _ZN9S487C4_nt3v35Ev();
extern void _ZN9S487C4_nt3v36Ev();
extern void _ZN9S487C3_nt3v37Ev();
extern void _ZN9S487C3_nt3v38Ev();
extern void _ZN9S487C3_nt3v39Ev();
extern void _ZN9S487C3_nt3v40Ev();
extern void _ZN9S487C3_nt3v41Ev();
extern void _ZN9S487C3_nt3v42Ev();
extern void _ZN9S487C3_nt3v43Ev();
extern void _ZN9S487C3_nt3v44Ev();
extern void _ZN9S487C3_nt3v45Ev();
extern void _ZN9S487C3_nt3v46Ev();
extern void _ZN9S487C3_nt3v47Ev();
extern void _ZN9S487C3_nt3v48Ev();
extern void _ZN9S487C3_nt3v49Ev();
extern void _ZN9S487C3_nt3v50Ev();
extern void _ZN9S487C3_nt3v51Ev();
extern void _ZN9S487C3_nt3v52Ev();
extern void _ZN9S487C3_nt3v53Ev();
extern void _ZN9S487C2_nt3v54Ev();
extern void _ZN9S487C2_nt3v55Ev();
extern void _ZN9S487C2_nt3v56Ev();
extern void _ZN9S487C2_nt3v57Ev();
extern void _ZN9S487C2_nt3v58Ev();
extern void _ZN9S487C2_nt3v59Ev();
extern void _ZN9S487C2_nt3v60Ev();
extern void _ZN9S487C2_nt3v61Ev();
extern void _ZN9S487C2_nt3v62Ev();
extern void _ZN9S487C2_nt3v63Ev();
extern void _ZN9S487C2_nt3v64Ev();
extern void _ZN9S487C2_nt3v65Ev();
extern void _ZN9S487C2_nt3v66Ev();
extern void _ZN6S487C12v1Ev();
extern void _ZN6S487C12v2Ev();
extern void _ZN6S487C12v3Ev();
extern void _ZN6S487C12v4Ev();
extern void _ZN6S487C12v5Ev();
extern void _ZN6S487C12v6Ev();
extern void _ZN6S487C12v7Ev();
extern void _ZN6S487C12v8Ev();
extern void _ZN6S487C12v9Ev();
extern void _ZN6S487C13v10Ev();
extern void _ZN6S487C13v11Ev();
extern void _ZN6S487C13v12Ev();
static  VTBL_ENTRY vtc_S487C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S487C1[0]),
  (VTBL_ENTRY)&_ZN6S487C1D1Ev,
  (VTBL_ENTRY)&_ZN6S487C1D0Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S487C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S487C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S487C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S487C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN6S487C12v1Ev,
  (VTBL_ENTRY)&_ZN6S487C12v2Ev,
  (VTBL_ENTRY)&_ZN6S487C12v3Ev,
  (VTBL_ENTRY)&_ZN6S487C12v4Ev,
  (VTBL_ENTRY)&_ZN6S487C12v5Ev,
  (VTBL_ENTRY)&_ZN6S487C12v6Ev,
  (VTBL_ENTRY)&_ZN6S487C12v7Ev,
  (VTBL_ENTRY)&_ZN6S487C12v8Ev,
  (VTBL_ENTRY)&_ZN6S487C12v9Ev,
  (VTBL_ENTRY)&_ZN6S487C13v10Ev,
  (VTBL_ENTRY)&_ZN6S487C13v11Ev,
  (VTBL_ENTRY)&_ZN6S487C13v12Ev,
};
extern VTBL_ENTRY _ZTI6S487C1[];
extern  VTBL_ENTRY _ZTV6S487C1[];
Class_Descriptor cd_S487C1 = {  "S487C1", // class name
  bases_S487C1, 4,
  &(vtc_S487C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4576,3228), // object size
  NSPAIRA(_ZTI6S487C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S487C1),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C6  {
  void *s19558c6f0;
  int s19558c6f1;
  long double s19558c6f2;
  int s19558c6f3[2];
  char s19558c6f4;
  virtual void  v2(); // _ZN8S19558C62v2Ev
  virtual void  v3(); // _ZN8S19558C62v3Ev
  ~S19558C6(); // tgen
  S19558C6(); // tgen
};
//SIG(-1 S19558C6) C1{ v1 v2 Fp Fi FD Fi[2] Fc}


void  S19558C6 ::v2(){vfunc_called(this, "_ZN8S19558C62v2Ev");}
void  S19558C6 ::v3(){vfunc_called(this, "_ZN8S19558C62v3Ev");}
S19558C6 ::~S19558C6(){ note_dtor("S19558C6", this);} // tgen
S19558C6 ::S19558C6(){ note_ctor("S19558C6", this);} // tgen

static void Test_S19558C6()
{
  extern Class_Descriptor cd_S19558C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5,10)];
    init_test(&cd_S19558C6, buf);
    S19558C6 *dp, &lv = *(dp=new (buf) S19558C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S19558C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C6)");
    check_field_offset(lv, s19558c6f0, ABISELECT(8,4), "S19558C6.s19558c6f0");
    check_field_offset(lv, s19558c6f1, ABISELECT(16,8), "S19558C6.s19558c6f1");
    check_field_offset(lv, s19558c6f2, ABISELECT(32,12), "S19558C6.s19558c6f2");
    check_field_offset(lv, s19558c6f3, ABISELECT(48,24), "S19558C6.s19558c6f3");
    check_field_offset(lv, s19558c6f4, ABISELECT(56,32), "S19558C6.s19558c6f4");
    test_class_info(&lv, &cd_S19558C6);
    dp->~S19558C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C6(Test_S19558C6, "S19558C6", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN8S19558C6C1Ev();
extern void _ZN8S19558C6D1Ev();
Name_Map name_map_S19558C6[] = {
  NSPAIR(_ZN8S19558C6C1Ev),
  NSPAIR(_ZN8S19558C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S19558C6[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C6[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
Class_Descriptor cd_S19558C6 = {  "S19558C6", // class name
  0,0,//no base classes
  &(vtc_S19558C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI8S19558C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S19558C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C5  : S19558C6 {
  void *s19558c5f0;
  __tsi64 s19558c5f1;
  int s19558c5f2;
  char s19558c5f3:8;
  char s19558c5f4;
  void *s19558c5f5;
  short s19558c5f6;
  long double s19558c5f7;
  virtual  ~S19558C5(); // _ZN8S19558C5D1Ev
  S19558C5(); // tgen
};
//SIG(-1 S19558C5) C1{ BC2{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD}


 S19558C5 ::~S19558C5(){ note_dtor("S19558C5", this);}
S19558C5 ::S19558C5(){ note_ctor("S19558C5", this);} // tgen

static void Test_S19558C5()
{
  extern Class_Descriptor cd_S19558C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,20)];
    init_test(&cd_S19558C5, buf);
    S19558C5 *dp, &lv = *(dp=new (buf) S19558C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,76), "sizeof(S19558C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C5)");
    check_base_class_offset(lv, (S19558C6*), 0, "S19558C5");
    check_field_offset(lv, s19558c5f0, ABISELECT(64,36), "S19558C5.s19558c5f0");
    check_field_offset(lv, s19558c5f1, ABISELECT(72,40), "S19558C5.s19558c5f1");
    check_field_offset(lv, s19558c5f2, ABISELECT(80,48), "S19558C5.s19558c5f2");
    set_bf_and_test(lv, s19558c5f3, ABISELECT(84,52), 0, 8, 1, "S19558C5");
    set_bf_and_test(lv, s19558c5f3, ABISELECT(84,52), 0, 8, hide_sll(1LL<<7), "S19558C5");
    check_field_offset(lv, s19558c5f4, ABISELECT(85,53), "S19558C5.s19558c5f4");
    check_field_offset(lv, s19558c5f5, ABISELECT(88,56), "S19558C5.s19558c5f5");
    check_field_offset(lv, s19558c5f6, ABISELECT(96,60), "S19558C5.s19558c5f6");
    check_field_offset(lv, s19558c5f7, ABISELECT(112,64), "S19558C5.s19558c5f7");
    test_class_info(&lv, &cd_S19558C5);
    dp->~S19558C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C5(Test_S19558C5, "S19558C5", ABISELECT(128,76));

#else // __cplusplus

extern void _ZN8S19558C5C1Ev();
extern void _ZN8S19558C5D1Ev();
Name_Map name_map_S19558C5[] = {
  NSPAIR(_ZN8S19558C5C1Ev),
  NSPAIR(_ZN8S19558C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
static Base_Class bases_S19558C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C5[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C5D1Ev();
extern void _ZN8S19558C5D0Ev();
static  VTBL_ENTRY vtc_S19558C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C5[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C5D0Ev,
};
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
Class_Descriptor cd_S19558C5 = {  "S19558C5", // class name
  bases_S19558C5, 1,
  &(vtc_S19558C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,76), // object size
  NSPAIRA(_ZTI8S19558C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19558C5),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C4  : virtual S19558C5 {
  int s19558c4f0;
  ~S19558C4(); // tgen
  S19558C4(); // tgen
};
//SIG(-1 S19558C4) C1{ VBC2{ BC3{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} Fi}


S19558C4 ::~S19558C4(){ note_dtor("S19558C4", this);} // tgen
S19558C4 ::S19558C4(){ note_ctor("S19558C4", this);} // tgen

static void Test_S19558C4()
{
  extern Class_Descriptor cd_S19558C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(10,22)];
    init_test(&cd_S19558C4, buf);
    S19558C4 *dp, &lv = *(dp=new (buf) S19558C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S19558C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C4)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(16,8), "S19558C4");
    check_base_class_offset(lv, (S19558C5*), ABISELECT(16,8), "S19558C4");
    check_field_offset(lv, s19558c4f0, ABISELECT(8,4), "S19558C4.s19558c4f0");
    test_class_info(&lv, &cd_S19558C4);
    dp->~S19558C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C4(Test_S19558C4, "S19558C4", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN8S19558C4C1Ev();
extern void _ZN8S19558C4D1Ev();
Name_Map name_map_S19558C4[] = {
  NSPAIR(_ZN8S19558C4C1Ev),
  NSPAIR(_ZN8S19558C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
static Base_Class bases_S19558C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C4[];
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZThn16_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
extern void ABISELECT(_ZThn16_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C4[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
extern VTBL_ENTRY _ZTV8S19558C4[];
static  VTT_ENTRY vtt_S19558C4[] = {
  {&(_ZTV8S19558C4[3]),  3,14},
  {&(_ZTV8S19558C4[10]),  10,14},
};
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C4 = {  "S19558C4", // class name
  bases_S19558C4, 2,
  &(vtc_S19558C4[0]), // expected_vtbl_contents
  &(vtt_S19558C4[0]), // expected_vtt_contents
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI8S19558C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19558C4),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19558C4),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C9  : virtual S19558C5 , S19558C6 {
  int s19558c9f0;
  ::S19558C5 s19558c9f1;
  int s19558c9f2;
  virtual  ~S19558C9(); // _ZN8S19558C9D2Ev
  S19558C9(); // tgen
};
//SIG(-1 S19558C9) C1{ VBC2{ BC3{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} BC3 vd Fi FC2 Fi}


 S19558C9 ::~S19558C9(){ note_dtor("S19558C9", this);}
S19558C9 ::S19558C9(){ note_ctor("S19558C9", this);} // tgen

static void Test_S19558C9()
{
  extern Class_Descriptor cd_S19558C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(22,50)];
    init_test(&cd_S19558C9, buf);
    S19558C9 *dp, &lv = *(dp=new (buf) S19558C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,196), "sizeof(S19558C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C9)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(208,120), "S19558C9");
    check_base_class_offset(lv, (S19558C5*), ABISELECT(208,120), "S19558C9");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*), 0, "S19558C9");
    check_field_offset(lv, s19558c9f0, ABISELECT(60,36), "S19558C9.s19558c9f0");
    check_field_offset(lv, s19558c9f1, ABISELECT(64,40), "S19558C9.s19558c9f1");
    check_field_offset(lv, s19558c9f2, ABISELECT(192,116), "S19558C9.s19558c9f2");
    test_class_info(&lv, &cd_S19558C9);
    dp->~S19558C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C9(Test_S19558C9, "S19558C9", ABISELECT(336,196));

#else // __cplusplus

extern void _ZN8S19558C9C1Ev();
extern void _ZN8S19558C9D2Ev();
Name_Map name_map_S19558C9[] = {
  NSPAIR(_ZN8S19558C9C1Ev),
  NSPAIR(_ZN8S19558C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
static Base_Class bases_S19558C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(208,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(208,120), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C9[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn208_N8S19558C9D1Ev,_ZThn120_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn208_N8S19558C9D0Ev,_ZThn120_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C9[] = {
  ABISELECT(208,120),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
  ABISELECT(-208,-120),
  0,
  0,
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern VTBL_ENTRY _ZTV8S19558C9[];
static  VTT_ENTRY vtt_S19558C9[] = {
  {&(_ZTV8S19558C9[3]),  3,16},
  {&(_ZTV8S19558C9[12]),  12,16},
};
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S19558C9D0Ev,_ZThn120_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N8S19558C9D1Ev,_ZThn120_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C9 = {  "S19558C9", // class name
  bases_S19558C9, 3,
  &(vtc_S19558C9[0]), // expected_vtbl_contents
  &(vtt_S19558C9[0]), // expected_vtt_contents
  ABISELECT(336,196), // object size
  NSPAIRA(_ZTI8S19558C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19558C9),16, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19558C9),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C10  : S19558C9 {
  int s19558c10f0;
  void *s19558c10f1;
  int s19558c10f2[2];
  virtual  ~S19558C10(); // _ZN9S19558C10D2Ev
  S19558C10(); // tgen
};
//SIG(-1 S19558C10) C1{ BC2{ VBC3{ BC4{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} BC4 vd Fi FC3 Fi} vd Fi Fp Fi[2]}


 S19558C10 ::~S19558C10(){ note_dtor("S19558C10", this);}
S19558C10 ::S19558C10(){ note_ctor("S19558C10", this);} // tgen

static void Test_S19558C10()
{
  extern Class_Descriptor cd_S19558C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(23,54)];
    init_test(&cd_S19558C10, buf);
    S19558C10 *dp, &lv = *(dp=new (buf) S19558C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,212), "sizeof(S19558C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C10)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(224,136), "S19558C10");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(224,136), "S19558C10");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), 0, "S19558C10");
    check_base_class_offset(lv, (S19558C9*), 0, "S19558C10");
    check_field_offset(lv, s19558c10f0, ABISELECT(196,120), "S19558C10.s19558c10f0");
    check_field_offset(lv, s19558c10f1, ABISELECT(200,124), "S19558C10.s19558c10f1");
    check_field_offset(lv, s19558c10f2, ABISELECT(208,128), "S19558C10.s19558c10f2");
    test_class_info(&lv, &cd_S19558C10);
    dp->~S19558C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C10(Test_S19558C10, "S19558C10", ABISELECT(352,212));

#else // __cplusplus

extern void _ZN9S19558C10C1Ev();
extern void _ZN9S19558C10D2Ev();
Name_Map name_map_S19558C10[] = {
  NSPAIR(_ZN9S19558C10C1Ev),
  NSPAIR(_ZN9S19558C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
static Base_Class bases_S19558C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(224,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(224,136), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C10[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn136_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn136_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C10[] = {
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
  ABISELECT(-224,-136),
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern VTBL_ENTRY _ZTV9S19558C10[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C10[] = {
  ABISELECT(224,136),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn136_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn136_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C10[] = {
  ABISELECT(-224,-136),
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C10[] = {
  {&(_ZTV9S19558C10[3]),  3,16},
  {&(_tg__ZTV8S19558C9__9S19558C10[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C10[5]),  5,9},
  {&(_ZTV9S19558C10[12]),  12,16},
};
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn136_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn136_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn136_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn136_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C10 = {  "S19558C10", // class name
  bases_S19558C10, 4,
  &(vtc_S19558C10[0]), // expected_vtbl_contents
  &(vtt_S19558C10[0]), // expected_vtt_contents
  ABISELECT(352,212), // object size
  NSPAIRA(_ZTI9S19558C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19558C10),16, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C10),4, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19558C11  {
  int s19558c11f0[2];
  __tsi64 s19558c11f1;
  void  mf19558c11(); // _ZN9S19558C1110mf19558c11Ev
};
//SIG(1 S19558C11) U1{ m Fi[2] FL}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19558C8  : virtual S19558C5 , virtual S19558C9 , S19558C10 , virtual S19558C6 {
  ::S19558C11 s19558c8f0;
  virtual  ~S19558C8(); // _ZN8S19558C8D2Ev
  virtual void  v4(); // _ZN8S19558C82v4Ev
  S19558C8(); // tgen
};
//SIG(-1 S19558C8) C1{ VBC2{ BC3{ v2 v3 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC4{ VBC2 BC3 vd Fi FC2 Fi} BC5{ BC4 vd Fi Fp Fi[2]} VBC3 vd v1 FU6{ m Fi[2] FL}}


 S19558C8 ::~S19558C8(){ note_dtor("S19558C8", this);}
void  S19558C8 ::v4(){vfunc_called(this, "_ZN8S19558C82v4Ev");}
S19558C8 ::S19558C8(){ note_ctor("S19558C8", this);} // tgen

static void Test_S19558C8()
{
  extern Class_Descriptor cd_S19558C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(40,95)];
    init_test(&cd_S19558C8, buf);
    S19558C8 *dp, &lv = *(dp=new (buf) S19558C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(624,376), "sizeof(S19558C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C8)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(224,144), "S19558C8");
    check_base_class_offset(lv, (S19558C5*), ABISELECT(224,144), "S19558C8");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(224,144), "S19558C8");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*), ABISELECT(224,144), "S19558C8");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(352,220), "S19558C8");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(352,220), "S19558C8");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*), 0, "S19558C8");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*), 0, "S19558C8");
    check_base_class_offset(lv, (S19558C10*), 0, "S19558C8");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*), ABISELECT(560,340), "S19558C8");
    check_field_offset(lv, s19558c8f0, ABISELECT(216,136), "S19558C8.s19558c8f0");
    test_class_info(&lv, &cd_S19558C8);
    dp->~S19558C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C8(Test_S19558C8, "S19558C8", ABISELECT(624,376));

#else // __cplusplus

extern void _ZN8S19558C8C1Ev();
extern void _ZN8S19558C8D2Ev();
Name_Map name_map_S19558C8[] = {
  NSPAIR(_ZN8S19558C8C1Ev),
  NSPAIR(_ZN8S19558C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
static Base_Class bases_S19558C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(224,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(224,144), //bcp->offset
    10, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    ABISELECT(352,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(352,220), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(560,340), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C8[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C8[] = {
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
  ABISELECT(-352,-220),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
  0,
  0,
  ABISELECT(-560,-340),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTV8S19558C8[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C10__8S19558C8[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C10__A1__8S19558C8[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C10__A1__8S19558C8[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C10__8S19558C8[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__8S19558C8[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C8[] = {
  {&(_ZTV8S19558C8[5]),  5,35},
  {&(_tg__ZTV9S19558C10__8S19558C8[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C10__A1__8S19558C8[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C10__A1__8S19558C8[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C10__8S19558C8[5]),  5,9},
  {&(_ZTV8S19558C8[15]),  15,35},
  {&(_ZTV8S19558C8[25]),  25,35},
  {&(_ZTV8S19558C8[33]),  33,35},
  {&(_tg__ZTV8S19558C9__8S19558C8[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__8S19558C8[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C8 = {  "S19558C8", // class name
  bases_S19558C8, 8,
  &(vtc_S19558C8[0]), // expected_vtbl_contents
  &(vtt_S19558C8[0]), // expected_vtt_contents
  ABISELECT(624,376), // object size
  NSPAIRA(_ZTI8S19558C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19558C8),35, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19558C8),10, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C7  : S19558C8 {
  long double s19558c7f0[3];
  int s19558c7f1;
  char s19558c7f2;
  ::S19558C9 s19558c7f3;
  int s19558c7f4:9;
  char s19558c7f5[5];
  int s19558c7f6;
  void *s19558c7f7[9];
  virtual  ~S19558C7(); // _ZN8S19558C7D2Ev
  virtual void  v5(); // _ZN8S19558C72v5Ev
  S19558C7(); // tgen
};
//SIG(-1 S19558C7) C1{ BC2{ VBC3{ BC4{ v2 v3 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC5{ VBC3 BC4 vd Fi FC3 Fi} BC6{ BC5 vd Fi Fp Fi[2]} VBC4 vd v4 FU7{ m Fi[2] FL}} vd v1 FD[3] Fi Fc FC5 Fi:9 Fc[5] Fi Fp[9]}


 S19558C7 ::~S19558C7(){ note_dtor("S19558C7", this);}
void  S19558C7 ::v5(){vfunc_called(this, "_ZN8S19558C72v5Ev");}
S19558C7 ::S19558C7(){ note_ctor("S19558C7", this);} // tgen

static void Test_S19558C7()
{
  extern Class_Descriptor cd_S19558C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(71,167)];
    init_test(&cd_S19558C7, buf);
    S19558C7 *dp, &lv = *(dp=new (buf) S19558C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1120,664), "sizeof(S19558C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C7)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(720,432), "S19558C7");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(720,432), "S19558C7");
    /*is_ambiguous_... S19558C7::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(720,432), "S19558C7");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(720,432), "S19558C7");
    /*is_ambiguous_... S19558C7::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(848,508), "S19558C7");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(848,508), "S19558C7");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), 0, "S19558C7");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), 0, "S19558C7");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*), 0, "S19558C7");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(1056,628), "S19558C7");
    check_base_class_offset(lv, (S19558C8*), 0, "S19558C7");
    check_field_offset(lv, s19558c7f0, ABISELECT(224,144), "S19558C7.s19558c7f0");
    check_field_offset(lv, s19558c7f1, ABISELECT(272,180), "S19558C7.s19558c7f1");
    check_field_offset(lv, s19558c7f2, ABISELECT(276,184), "S19558C7.s19558c7f2");
    check_field_offset(lv, s19558c7f3, ABISELECT(288,188), "S19558C7.s19558c7f3");
    set_bf_and_test(lv, s19558c7f4, ABISELECT(624,384), 0, 9, 1, "S19558C7");
    set_bf_and_test(lv, s19558c7f4, ABISELECT(624,384), 0, 9, hide_sll(1LL<<8), "S19558C7");
    check_field_offset(lv, s19558c7f5, ABISELECT(626,386), "S19558C7.s19558c7f5");
    check_field_offset(lv, s19558c7f6, ABISELECT(632,392), "S19558C7.s19558c7f6");
    check_field_offset(lv, s19558c7f7, ABISELECT(640,396), "S19558C7.s19558c7f7");
    test_class_info(&lv, &cd_S19558C7);
    dp->~S19558C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C7(Test_S19558C7, "S19558C7", ABISELECT(1120,664));

#else // __cplusplus

extern void _ZN8S19558C7C1Ev();
extern void _ZN8S19558C7D2Ev();
Name_Map name_map_S19558C7[] = {
  NSPAIR(_ZN8S19558C7C1Ev),
  NSPAIR(_ZN8S19558C7D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
static Base_Class bases_S19558C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(720,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(720,432), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(848,508), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(848,508), //bcp->offset
    20, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(1056,628), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C7[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C7D1Ev();
extern void _ZN8S19558C7D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn848_N8S19558C7D1Ev,_ZThn508_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn848_N8S19558C7D0Ev,_ZThn508_N8S19558C7D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C7[] = {
  ABISELECT(1056,628),
  ABISELECT(848,508),
  ABISELECT(720,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev),
  ABISELECT(-848,-508),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-848,-508),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev),
  0,
  0,
  ABISELECT(-1056,-628),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTV8S19558C7[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__8S19558C7[] = {
  ABISELECT(1056,628),
  ABISELECT(848,508),
  ABISELECT(720,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__8S19558C7[] = {
  ABISELECT(720,432),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A1__8S19558C7[] = {
  ABISELECT(720,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C9D1Ev,_ZThn432_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C9D0Ev,_ZThn432_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__8S19558C7[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn720_N9S19558C10D1Ev,_ZThn432_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn720_N9S19558C10D0Ev,_ZThn432_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__8S19558C7[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__8S19558C7[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn848_N8S19558C8D1Ev,_ZThn508_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn848_N8S19558C8D0Ev,_ZThn508_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__8S19558C7[] = {
  ABISELECT(-848,-508),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-848,-508),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__8S19558C7[] = {
  0,
  0,
  ABISELECT(-1056,-628),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C7[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__8S19558C7[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C7[] = {
  {&(_ZTV8S19558C7[5]),  5,36},
  {&(_tg__ZTV8S19558C8__8S19558C7[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__8S19558C7[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A1__8S19558C7[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__8S19558C7[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__8S19558C7[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__8S19558C7[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__8S19558C7[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__8S19558C7[4]),  4,6},
  {&(_ZTV8S19558C7[16]),  16,36},
  {&(_ZTV8S19558C7[26]),  26,36},
  {&(_ZTV8S19558C7[34]),  34,36},
  {&(_tg__ZTV8S19558C9__8S19558C7[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__8S19558C7[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S19558C7[];
extern  VTBL_ENTRY _ZTV8S19558C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C7[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S19558C8D0Ev,_ZThn508_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S19558C8D1Ev,_ZThn508_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N9S19558C10D0Ev,_ZThn432_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N9S19558C10D1Ev,_ZThn432_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C9D0Ev,_ZThn432_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C9D1Ev,_ZThn432_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S19558C7D0Ev,_ZThn508_N8S19558C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S19558C7D1Ev,_ZThn508_N8S19558C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C7 = {  "S19558C7", // class name
  bases_S19558C7, 9,
  &(vtc_S19558C7[0]), // expected_vtbl_contents
  &(vtt_S19558C7[0]), // expected_vtt_contents
  ABISELECT(1120,664), // object size
  NSPAIRA(_ZTI8S19558C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19558C7),36, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19558C7),14, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C3  : virtual S19558C4 , S19558C6 , virtual S19558C7 , S19558C8 , S19558C5 {
  char  :0;
  char s19558c3f1;
  int s19558c3f2:10;
  char s19558c3f3;
  int s19558c3f4;
  virtual  ~S19558C3(); // _ZN8S19558C3D2Ev
  virtual void  v6(); // _ZN8S19558C32v6Ev
  virtual void  v7(); // _ZN8S19558C32v7Ev
  S19558C3(); // tgen
};
//SIG(-1 S19558C3) C1{ VBC2{ VBC3{ BC4{ v3 v4 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} Fi} BC4 VBC5{ BC6{ VBC3 VBC7{ VBC3 BC4 vd Fi FC3 Fi} BC8{ BC7 vd Fi Fp Fi[2]} VBC4 vd v5 FU9{ m Fi[2] FL}} vd v6 FD[3] Fi Fc FC7 Fi:9 Fc[5] Fi Fp[9]} BC6 BC3 vd v1 v2 Fc:0 Fc Fi:10 Fc Fi}


 S19558C3 ::~S19558C3(){ note_dtor("S19558C3", this);}
void  S19558C3 ::v6(){vfunc_called(this, "_ZN8S19558C32v6Ev");}
void  S19558C3 ::v7(){vfunc_called(this, "_ZN8S19558C32v7Ev");}
S19558C3 ::S19558C3(){ note_ctor("S19558C3", this);} // tgen

static void Test_S19558C3()
{
  extern Class_Descriptor cd_S19558C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(99,235)];
    init_test(&cd_S19558C3, buf);
    S19558C3 *dp, &lv = *(dp=new (buf) S19558C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1568,936), "sizeof(S19558C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C3)");
    /*is_ambiguous_... S19558C3::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(448,272), "S19558C3");
    check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(448,272), "S19558C3");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C7*), ABISELECT(448,272), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(448,272), "S19558C3");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(448,272), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(448,272), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(448,272), "S19558C3");
    check_base_class_offset(lv, (S19558C4*), ABISELECT(424,264), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*), 0, "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(1296,780), "S19558C3");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C7*), ABISELECT(1296,780), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(1296,780), "S19558C3");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(576,348), "S19558C3");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(576,348), "S19558C3");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(576,348), "S19558C3");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C7*), ABISELECT(1504,900), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(1504,900), "S19558C3");
    check_base_class_offset(lv, (S19558C8*)(S19558C7*), ABISELECT(576,348), "S19558C3");
    check_base_class_offset(lv, (S19558C7*), ABISELECT(576,348), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(64,36), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(64,36), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*), ABISELECT(64,36), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C8*), ABISELECT(64,36), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(288,180), "S19558C3");
    /*is_ambiguous_... S19558C3::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*), ABISELECT(288,180), "S19558C3");
    check_field_offset(lv, s19558c3f1, ABISELECT(416,256), "S19558C3.s19558c3f1");
    set_bf_and_test(lv, s19558c3f2, ABISELECT(417,257), 0, 10, 1, "S19558C3");
    set_bf_and_test(lv, s19558c3f2, ABISELECT(417,257), 0, 10, hide_sll(1LL<<9), "S19558C3");
    check_field_offset(lv, s19558c3f3, ABISELECT(419,259), "S19558C3.s19558c3f3");
    check_field_offset(lv, s19558c3f4, ABISELECT(420,260), "S19558C3.s19558c3f4");
    test_class_info(&lv, &cd_S19558C3);
    dp->~S19558C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C3(Test_S19558C3, "S19558C3", ABISELECT(1568,936));

#else // __cplusplus

extern void _ZN8S19558C3C1Ev();
extern void _ZN8S19558C3D2Ev();
Name_Map name_map_S19558C3[] = {
  NSPAIR(_ZN8S19558C3C1Ev),
  NSPAIR(_ZN8S19558C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C7;
extern VTBL_ENTRY _ZTI8S19558C7[];
extern  VTBL_ENTRY _ZTV8S19558C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C7[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
static Base_Class bases_S19558C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(448,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(448,272), //bcp->offset
    35, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19558C4,    ABISELECT(424,264), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(1296,780), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(1296,780), //bcp->offset
    60, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(576,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(576,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(576,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(1504,900), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C8,    ABISELECT(576,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19558C7,    ABISELECT(576,348), //bcp->offset
    44, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(64,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(288,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(288,180), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19558C3[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C3D1Ev();
extern void _ZN8S19558C3D0Ev();
extern void _ZN8S19558C32v6Ev();
extern void _ZN8S19558C32v7Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn64_N8S19558C3D1Ev,_ZThn36_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn64_N8S19558C3D0Ev,_ZThn36_N8S19558C3D0Ev)();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn288_N8S19558C3D1Ev,_ZThn180_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn288_N8S19558C3D0Ev,_ZThn180_N8S19558C3D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn424_N8S19558C3D1Ev,_ZThn264_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn424_N8S19558C3D0Ev,_ZThn264_N8S19558C3D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn448_N8S19558C3D1Ev,_ZThn272_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn448_N8S19558C3D0Ev,_ZThn272_N8S19558C3D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn576_N8S19558C3D1Ev,_ZThn348_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn576_N8S19558C3D0Ev,_ZThn348_N8S19558C3D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn1296_N8S19558C3D1Ev,_ZThn780_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn1296_N8S19558C3D0Ev,_ZThn780_N8S19558C3D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C3[] = {
  ABISELECT(1504,900),
  ABISELECT(1296,780),
  ABISELECT(576,348),
  ABISELECT(448,272),
  ABISELECT(424,264),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v6Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v7Ev,
  ABISELECT(1440,864),
  ABISELECT(1232,744),
  ABISELECT(384,236),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19558C3D1Ev,_ZThn36_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19558C3D0Ev,_ZThn36_N8S19558C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S19558C3D1Ev,_ZThn180_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N8S19558C3D0Ev,_ZThn180_N8S19558C3D0Ev),
  ABISELECT(-424,-264),
  ABISELECT(24,8),
  ABISELECT(-424,-264),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev),
  ABISELECT(-448,-272),
  0,
  0,
  ABISELECT(-448,-272),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev),
  0,
  0,
  ABISELECT(-576,-348),
  0,
  0,
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  ABISELECT(-576,-348),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
  ABISELECT(-1296,-780),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-1296,-780),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev),
  0,
  0,
  ABISELECT(-1504,-900),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTV8S19558C3[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__A1__8S19558C3[] = {
  ABISELECT(1440,864),
  ABISELECT(1232,744),
  ABISELECT(384,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__A1__8S19558C3[] = {
  ABISELECT(384,236),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A2__8S19558C3[] = {
  ABISELECT(384,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn384_N8S19558C9D1Ev,_ZThn236_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn384_N8S19558C9D0Ev,_ZThn236_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A2__8S19558C3[] = {
  ABISELECT(-384,-236),
  0,
  0,
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn384_N9S19558C10D1Ev,_ZThn236_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn384_N9S19558C10D0Ev,_ZThn236_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__A1__8S19558C3[] = {
  ABISELECT(-384,-236),
  0,
  0,
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn384_N8S19558C8D1Ev,_ZThn236_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn384_N8S19558C8D0Ev,_ZThn236_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__A1__8S19558C3[] = {
  ABISELECT(-384,-236),
  0,
  0,
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn1232_N8S19558C8D1Ev,_ZThn744_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn1232_N8S19558C8D0Ev,_ZThn744_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__A1__8S19558C3[] = {
  ABISELECT(-1232,-744),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-1232,-744),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__A1__8S19558C3[] = {
  0,
  0,
  ABISELECT(-1440,-864),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__8S19558C3[] = {
  ABISELECT(24,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZThn24_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
extern void ABISELECT(_ZThn24_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__8S19558C3[] = {
  ABISELECT(-24,-8),
  0,
  0,
  ABISELECT(-24,-8),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C7D1Ev();
extern void _ZN8S19558C7D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C7__8S19558C3[] = {
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C88S19558C7__8S19558C3[] = {
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C88S19558C7__8S19558C3[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A1__8S19558C3[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A1__8S19558C3[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__8S19558C3[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C88S19558C7__8S19558C3[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C88S19558C7__8S19558C3[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C88S19558C7__8S19558C3[] = {
  0,
  0,
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C7__8S19558C3[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C7__8S19558C3[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C7__8S19558C3[] = {
  0,
  0,
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C3[] = {
  ABISELECT(-848,-508),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__8S19558C3[] = {
  ABISELECT(848,508),
  0,
  0,
  ABISELECT(848,508),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C3[] = {
  {&(_ZTV8S19558C3[7]),  7,76},
  {&(_tg__ZTV8S19558C8__A1__8S19558C3[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__A1__8S19558C3[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A2__8S19558C3[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A2__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__A1__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__A1__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__A1__8S19558C3[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__A1__8S19558C3[4]),  4,6},
  {&(_ZTV8S19558C3[33]),  33,76},
  {&(_ZTV8S19558C3[40]),  40,76},
  {&(_ZTV8S19558C3[54]),  54,76},
  {&(_ZTV8S19558C3[66]),  66,76},
  {&(_ZTV8S19558C3[74]),  74,76},
  {&(_ZTV8S19558C3[18]),  18,76},
  {&(_tg__ZTV8S19558C4__8S19558C3[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C7__8S19558C3[5]),  5,11},
  {&(_tg__ZTV8S19558C88S19558C7__8S19558C3[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C88S19558C7__8S19558C3[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A1__8S19558C3[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A1__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C88S19558C7__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C88S19558C7__8S19558C3[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C88S19558C7__8S19558C3[4]),  4,6},
  {&(_tg__ZTV8S19558C5__8S19558C7__8S19558C3[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C7__8S19558C3[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C7__8S19558C3[4]),  4,6},
  {&(_tg__ZTV8S19558C9__8S19558C3[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__8S19558C3[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S19558C3[];
extern  VTBL_ENTRY _ZTV8S19558C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C3[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1232_N8S19558C8D0Ev,_ZThn744_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1232_N8S19558C8D1Ev,_ZThn744_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19558C8D0Ev,_ZThn236_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19558C8D1Ev,_ZThn236_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N9S19558C10D0Ev,_ZThn236_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N9S19558C10D1Ev,_ZThn236_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19558C9D0Ev,_ZThn236_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19558C9D1Ev,_ZThn236_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N8S19558C3D0Ev,_ZThn780_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1296_N8S19558C3D1Ev,_ZThn780_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn576_N8S19558C3D0Ev,_ZThn348_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn576_N8S19558C3D1Ev,_ZThn348_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn448_N8S19558C3D0Ev,_ZThn272_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn448_N8S19558C3D1Ev,_ZThn272_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N8S19558C3D0Ev,_ZThn264_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N8S19558C3D1Ev,_ZThn264_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C3 = {  "S19558C3", // class name
  bases_S19558C3, 18,
  &(vtc_S19558C3[0]), // expected_vtbl_contents
  &(vtt_S19558C3[0]), // expected_vtt_contents
  ABISELECT(1568,936), // object size
  NSPAIRA(_ZTI8S19558C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19558C3),76, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19558C3),31, //virtual table table var
  18, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C13  : virtual S19558C8 , S19558C9 {
  char s19558c13f0;
  ::S19558C9 s19558c13f1;
  char s19558c13f2;
  virtual  ~S19558C13(); // _ZN9S19558C13D2Ev
  virtual void  v8(); // _ZN9S19558C132v8Ev
  virtual void  v9(); // _ZN9S19558C132v9Ev
  S19558C13(); // tgen
};
//SIG(-1 S19558C13) C1{ VBC2{ VBC3{ BC4{ v3 v4 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC5{ VBC3 BC4 vd Fi FC3 Fi} BC6{ BC5 vd Fi Fp Fi[2]} VBC4 vd v5 FU7{ m Fi[2] FL}} BC5 vd v1 v2 Fc FC5 Fc}


 S19558C13 ::~S19558C13(){ note_dtor("S19558C13", this);}
void  S19558C13 ::v8(){vfunc_called(this, "_ZN9S19558C132v8Ev");}
void  S19558C13 ::v9(){vfunc_called(this, "_ZN9S19558C132v9Ev");}
S19558C13 ::S19558C13(){ note_ctor("S19558C13", this);} // tgen

static void Test_S19558C13()
{
  extern Class_Descriptor cd_S19558C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(75,176)];
    init_test(&cd_S19558C13, buf);
    S19558C13 *dp, &lv = *(dp=new (buf) S19558C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1184,700), "sizeof(S19558C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C13)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(784,468), "S19558C13");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(784,468), "S19558C13");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(784,468), "S19558C13");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(784,468), "S19558C13");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(784,468), "S19558C13");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(912,544), "S19558C13");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(912,544), "S19558C13");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(560,324), "S19558C13");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(560,324), "S19558C13");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*), ABISELECT(560,324), "S19558C13");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(1120,664), "S19558C13");
    check_base_class_offset(lv, (S19558C8*), ABISELECT(560,324), "S19558C13");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), 0, "S19558C13");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), 0, "S19558C13");
    check_field_offset(lv, s19558c13f0, ABISELECT(196,120), "S19558C13.s19558c13f0");
    check_field_offset(lv, s19558c13f1, ABISELECT(208,124), "S19558C13.s19558c13f1");
    check_field_offset(lv, s19558c13f2, ABISELECT(544,320), "S19558C13.s19558c13f2");
    test_class_info(&lv, &cd_S19558C13);
    dp->~S19558C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C13(Test_S19558C13, "S19558C13", ABISELECT(1184,700));

#else // __cplusplus

extern void _ZN9S19558C13C1Ev();
extern void _ZN9S19558C13D2Ev();
Name_Map name_map_S19558C13[] = {
  NSPAIR(_ZN9S19558C13C1Ev),
  NSPAIR(_ZN9S19558C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
static Base_Class bases_S19558C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(784,468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(784,468), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(912,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(912,544), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(560,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(560,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(560,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(1120,664), //bcp->offset
    45, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C8,    ABISELECT(560,324), //bcp->offset
    12, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C13[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C13D1Ev();
extern void _ZN9S19558C13D0Ev();
extern void _ZN9S19558C132v8Ev();
extern void _ZN9S19558C132v9Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn560_N9S19558C13D1Ev,_ZThn324_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn560_N9S19558C13D0Ev,_ZThn324_N9S19558C13D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn784_N9S19558C13D1Ev,_ZThn468_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn784_N9S19558C13D0Ev,_ZThn468_N9S19558C13D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn912_N9S19558C13D1Ev,_ZThn544_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn912_N9S19558C13D0Ev,_ZThn544_N9S19558C13D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C13[] = {
  ABISELECT(1120,664),
  ABISELECT(912,544),
  ABISELECT(560,324),
  ABISELECT(784,468),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v8Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v9Ev,
  0,
  ABISELECT(-560,-324),
  0,
  0,
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  ABISELECT(-560,-324),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  ABISELECT(-784,-468),
  0,
  0,
  ABISELECT(-784,-468),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev),
  ABISELECT(-912,-544),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-912,-544),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev),
  0,
  0,
  ABISELECT(-1120,-664),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTV9S19558C13[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C13[] = {
  ABISELECT(784,468),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn784_N8S19558C9D1Ev,_ZThn468_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn784_N8S19558C9D0Ev,_ZThn468_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A__9S19558C13[] = {
  ABISELECT(-784,-468),
  0,
  0,
  ABISELECT(-784,-468),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__9S19558C13[] = {
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__9S19558C13[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C13[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C13[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C13[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__9S19558C13[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__9S19558C13[] = {
  ABISELECT(-352,-220),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__9S19558C13[] = {
  0,
  0,
  ABISELECT(-560,-340),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C13[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C13[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C13[] = {
  {&(_ZTV9S19558C13[6]),  6,51},
  {&(_tg__ZTV8S19558C9__A__9S19558C13[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A__9S19558C13[5]),  5,9},
  {&(_ZTV9S19558C13[21]),  21,51},
  {&(_ZTV9S19558C13[31]),  31,51},
  {&(_ZTV9S19558C13[41]),  41,51},
  {&(_ZTV9S19558C13[49]),  49,51},
  {&(_tg__ZTV8S19558C8__9S19558C13[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__9S19558C13[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C13[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C13[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C13[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__9S19558C13[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__9S19558C13[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__9S19558C13[4]),  4,6},
  {&(_tg__ZTV8S19558C9__9S19558C13[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C13[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C13[];
extern  VTBL_ENTRY _ZTV9S19558C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C13[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C9D0Ev,_ZThn468_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C9D1Ev,_ZThn468_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn912_N9S19558C13D0Ev,_ZThn544_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn912_N9S19558C13D1Ev,_ZThn544_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C13D0Ev,_ZThn468_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C13D1Ev,_ZThn468_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19558C13D0Ev,_ZThn324_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19558C13D1Ev,_ZThn324_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C13 = {  "S19558C13", // class name
  bases_S19558C13, 11,
  &(vtc_S19558C13[0]), // expected_vtbl_contents
  &(vtt_S19558C13[0]), // expected_vtt_contents
  ABISELECT(1184,700), // object size
  NSPAIRA(_ZTI9S19558C13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19558C13),51, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C13),17, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C15  : virtual S19558C6 , S19558C8 , S19558C5 , virtual S19558C4 , S19558C9 {
  int s19558c15f0;
  int s19558c15f1;
  int s19558c15f2;
  virtual  ~S19558C15(); // _ZN9S19558C15D2Ev
  virtual void  v10(); // _ZN9S19558C153v10Ev
  S19558C15(); // tgen
};
//SIG(-1 S19558C15) C1{ VBC2{ v2 v3 Fp Fi FD Fi[2] Fc} BC3{ VBC4{ BC2 vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC5{ VBC4 BC2 vd Fi FC4 Fi} BC6{ BC5 vd Fi Fp Fi[2]} VBC2 vd v4 FU7{ m Fi[2] FL}} BC4 VBC8{ VBC4 Fi} BC5 vd v1 Fi Fi Fi}


 S19558C15 ::~S19558C15(){ note_dtor("S19558C15", this);}
void  S19558C15 ::v10(){vfunc_called(this, "_ZN9S19558C153v10Ev");}
S19558C15 ::S19558C15(){ note_ctor("S19558C15", this);} // tgen

static void Test_S19558C15()
{
  extern Class_Descriptor cd_S19558C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(62,149)];
    init_test(&cd_S19558C15, buf);
    S19558C15 *dp, &lv = *(dp=new (buf) S19558C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(976,592), "sizeof(S19558C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C15)");
    /*is_ambiguous_... S19558C15::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*), ABISELECT(560,352), "S19558C15");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(560,352), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(624,388), "S19558C15");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(624,388), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(624,388), "S19558C15");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(624,388), "S19558C15");
    check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(624,388), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(624,388), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(752,464), "S19558C15");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(752,464), "S19558C15");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), 0, "S19558C15");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), 0, "S19558C15");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*), 0, "S19558C15");
    check_base_class_offset(lv, (S19558C8*), 0, "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(224,144), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*), ABISELECT(224,144), "S19558C15");
    check_base_class_offset(lv, (S19558C4*), ABISELECT(952,584), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(352,220), "S19558C15");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(352,220), "S19558C15");
    check_field_offset(lv, s19558c15f0, ABISELECT(548,340), "S19558C15.s19558c15f0");
    check_field_offset(lv, s19558c15f1, ABISELECT(552,344), "S19558C15.s19558c15f1");
    check_field_offset(lv, s19558c15f2, ABISELECT(556,348), "S19558C15.s19558c15f2");
    test_class_info(&lv, &cd_S19558C15);
    dp->~S19558C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C15(Test_S19558C15, "S19558C15", ABISELECT(976,592));

#else // __cplusplus

extern void _ZN9S19558C15C1Ev();
extern void _ZN9S19558C15D2Ev();
Name_Map name_map_S19558C15[] = {
  NSPAIR(_ZN9S19558C15C1Ev),
  NSPAIR(_ZN9S19558C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
static Base_Class bases_S19558C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(560,352), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    ABISELECT(624,388), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(624,388), //bcp->offset
    31, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(752,464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(752,464), //bcp->offset
    40, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(224,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(224,144), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C4,    ABISELECT(952,584), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    ABISELECT(352,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(352,220), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C15[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C15D1Ev();
extern void _ZN9S19558C15D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn224_N9S19558C15D1Ev,_ZThn144_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C15D0Ev,_ZThn144_N9S19558C15D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn624_N9S19558C15D1Ev,_ZThn388_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn624_N9S19558C15D0Ev,_ZThn388_N9S19558C15D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn752_N9S19558C15D1Ev,_ZThn464_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn752_N9S19558C15D0Ev,_ZThn464_N9S19558C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn952_N9S19558C15D1Ev,_ZThn584_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn952_N9S19558C15D0Ev,_ZThn584_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C15[] = {
  ABISELECT(952,584),
  ABISELECT(560,352),
  ABISELECT(752,464),
  ABISELECT(624,388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C15D1Ev,_ZThn144_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C15D0Ev,_ZThn144_N9S19558C15D0Ev),
  ABISELECT(272,168),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev),
  0,
  0,
  ABISELECT(-560,-352),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  ABISELECT(-624,-388),
  0,
  0,
  ABISELECT(-624,-388),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev),
  ABISELECT(-752,-464),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-752,-464),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev),
  ABISELECT(-952,-584),
  ABISELECT(-328,-196),
  ABISELECT(-952,-584),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev),
};
extern VTBL_ENTRY _ZTV9S19558C15[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__9S19558C15[] = {
  ABISELECT(560,352),
  ABISELECT(752,464),
  ABISELECT(624,388),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__9S19558C15[] = {
  ABISELECT(624,388),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C15[] = {
  ABISELECT(624,388),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn624_N8S19558C9D1Ev,_ZThn388_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn624_N8S19558C9D0Ev,_ZThn388_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C15[] = {
  ABISELECT(-624,-388),
  0,
  0,
  ABISELECT(-624,-388),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn624_N9S19558C10D1Ev,_ZThn388_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn624_N9S19558C10D0Ev,_ZThn388_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C15[] = {
  ABISELECT(-624,-388),
  0,
  0,
  ABISELECT(-624,-388),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn624_N8S19558C8D1Ev,_ZThn388_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn624_N8S19558C8D0Ev,_ZThn388_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__9S19558C15[] = {
  ABISELECT(-624,-388),
  0,
  0,
  ABISELECT(-624,-388),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn752_N8S19558C8D1Ev,_ZThn464_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn752_N8S19558C8D0Ev,_ZThn464_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__9S19558C15[] = {
  ABISELECT(-752,-464),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-752,-464),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__9S19558C15[] = {
  0,
  0,
  ABISELECT(-560,-352),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C15[] = {
  ABISELECT(272,168),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn272_N8S19558C9D1Ev,_ZThn168_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn272_N8S19558C9D0Ev,_ZThn168_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A__9S19558C15[] = {
  ABISELECT(-272,-168),
  0,
  0,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C15[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C15[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C15[] = {
  ABISELECT(-328,-196),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__9S19558C15[] = {
  ABISELECT(328,196),
  0,
  0,
  ABISELECT(328,196),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
static  VTT_ENTRY vtt_S19558C15[] = {
  {&(_ZTV9S19558C15[6]),  6,56},
  {&(_tg__ZTV8S19558C8__9S19558C15[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__9S19558C15[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C15[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C15[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C15[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__9S19558C15[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__9S19558C15[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__9S19558C15[4]),  4,6},
  {&(_tg__ZTV8S19558C9__A__9S19558C15[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A__9S19558C15[5]),  5,9},
  {&(_ZTV9S19558C15[29]),  29,56},
  {&(_ZTV9S19558C15[36]),  36,56},
  {&(_ZTV9S19558C15[46]),  46,56},
  {&(_ZTV9S19558C15[54]),  54,56},
  {&(_ZTV9S19558C15[21]),  21,56},
  {&(_tg__ZTV8S19558C9__9S19558C15[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C15[5]),  5,9},
  {&(_tg__ZTV8S19558C4__9S19558C15[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__9S19558C15[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C15[];
extern  VTBL_ENTRY _ZTV9S19558C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C15[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S19558C8D0Ev,_ZThn464_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S19558C8D1Ev,_ZThn464_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19558C8D0Ev,_ZThn388_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19558C8D1Ev,_ZThn388_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N9S19558C10D0Ev,_ZThn388_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N9S19558C10D1Ev,_ZThn388_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S19558C9D0Ev,_ZThn168_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19558C9D0Ev,_ZThn388_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N8S19558C9D1Ev,_ZThn168_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19558C9D1Ev,_ZThn388_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn952_N9S19558C15D0Ev,_ZThn584_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn952_N9S19558C15D1Ev,_ZThn584_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N9S19558C15D0Ev,_ZThn464_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N9S19558C15D1Ev,_ZThn464_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N9S19558C15D0Ev,_ZThn388_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn624_N9S19558C15D1Ev,_ZThn388_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C15 = {  "S19558C15", // class name
  bases_S19558C15, 14,
  &(vtc_S19558C15[0]), // expected_vtbl_contents
  &(vtt_S19558C15[0]), // expected_vtt_contents
  ABISELECT(976,592), // object size
  NSPAIRA(_ZTI9S19558C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19558C15),56, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C15),20, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C14  : S19558C15 {
  int s19558c14f0;
  long s19558c14f1;
  int s19558c14f2;
  __tsi64 s19558c14f3;
  virtual  ~S19558C14(); // _ZN9S19558C14D2Ev
  virtual void  v11(); // _ZN9S19558C143v11Ev
  S19558C14(); // tgen
};
//SIG(-1 S19558C14) C1{ BC2{ VBC3{ v2 v3 Fp Fi FD Fi[2] Fc} BC4{ VBC5{ BC3 vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC6{ VBC5 BC3 vd Fi FC5 Fi} BC7{ BC6 vd Fi Fp Fi[2]} VBC3 vd v4 FU8{ m Fi[2] FL}} BC5 VBC9{ VBC5 Fi} BC6 vd v5 Fi Fi Fi} vd v1 Fi Fl Fi FL}


 S19558C14 ::~S19558C14(){ note_dtor("S19558C14", this);}
void  S19558C14 ::v11(){vfunc_called(this, "_ZN9S19558C143v11Ev");}
S19558C14 ::S19558C14(){ note_ctor("S19558C14", this);} // tgen

static void Test_S19558C14()
{
  extern Class_Descriptor cd_S19558C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(64,154)];
    init_test(&cd_S19558C14, buf);
    S19558C14 *dp, &lv = *(dp=new (buf) S19558C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1008,612), "sizeof(S19558C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C14)");
    /*is_ambiguous_... S19558C15::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C15*), ABISELECT(592,372), "S19558C14");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C15*), ABISELECT(592,372), "S19558C14");
    /*is_ambiguous_... S19558C14::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(656,408), "S19558C14");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C15*), ABISELECT(656,408), "S19558C14");
    /*is_ambiguous_... S19558C14::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(656,408), "S19558C14");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*), ABISELECT(656,408), "S19558C14");
    check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(656,408), "S19558C14");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C15*), ABISELECT(656,408), "S19558C14");
    /*is_ambiguous_... S19558C14::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(784,484), "S19558C14");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C15*), ABISELECT(784,484), "S19558C14");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*), 0, "S19558C14");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*), 0, "S19558C14");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C15*), 0, "S19558C14");
    check_base_class_offset(lv, (S19558C8*)(S19558C15*), 0, "S19558C14");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C15*), ABISELECT(224,144), "S19558C14");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C15*), ABISELECT(224,144), "S19558C14");
    check_base_class_offset(lv, (S19558C4*)(S19558C15*), ABISELECT(984,604), "S19558C14");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C15*), ABISELECT(352,220), "S19558C14");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C15*), ABISELECT(352,220), "S19558C14");
    check_base_class_offset(lv, (S19558C15*), 0, "S19558C14");
    check_field_offset(lv, s19558c14f0, ABISELECT(560,352), "S19558C14.s19558c14f0");
    check_field_offset(lv, s19558c14f1, ABISELECT(568,356), "S19558C14.s19558c14f1");
    check_field_offset(lv, s19558c14f2, ABISELECT(576,360), "S19558C14.s19558c14f2");
    check_field_offset(lv, s19558c14f3, ABISELECT(584,364), "S19558C14.s19558c14f3");
    test_class_info(&lv, &cd_S19558C14);
    dp->~S19558C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C14(Test_S19558C14, "S19558C14", ABISELECT(1008,612));

#else // __cplusplus

extern void _ZN9S19558C14C1Ev();
extern void _ZN9S19558C14D2Ev();
Name_Map name_map_S19558C14[] = {
  NSPAIR(_ZN9S19558C14C1Ev),
  NSPAIR(_ZN9S19558C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C15;
extern VTBL_ENTRY _ZTI9S19558C15[];
extern  VTBL_ENTRY _ZTV9S19558C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C15[];
static Base_Class bases_S19558C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(592,372), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(656,408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(656,408), //bcp->offset
    32, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(784,484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(784,484), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(224,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(224,144), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19558C4,    ABISELECT(984,604), //bcp->offset
    51, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(352,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(352,220), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19558C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C14[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C14D1Ev();
extern void _ZN9S19558C14D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN9S19558C143v11Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn224_N9S19558C14D1Ev,_ZThn144_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C14D0Ev,_ZThn144_N9S19558C14D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn656_N9S19558C14D1Ev,_ZThn408_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn656_N9S19558C14D0Ev,_ZThn408_N9S19558C14D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn784_N9S19558C14D1Ev,_ZThn484_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn784_N9S19558C14D0Ev,_ZThn484_N9S19558C14D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn984_N9S19558C14D1Ev,_ZThn604_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn984_N9S19558C14D0Ev,_ZThn604_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C14[] = {
  ABISELECT(984,604),
  ABISELECT(592,372),
  ABISELECT(784,484),
  ABISELECT(656,408),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19558C143v11Ev,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C14D1Ev,_ZThn144_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C14D0Ev,_ZThn144_N9S19558C14D0Ev),
  ABISELECT(304,188),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev),
  0,
  0,
  ABISELECT(-592,-372),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  ABISELECT(-656,-408),
  0,
  0,
  ABISELECT(-656,-408),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev),
  ABISELECT(-784,-484),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-784,-484),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev),
  ABISELECT(-984,-604),
  ABISELECT(-328,-196),
  ABISELECT(-984,-604),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev),
};
extern VTBL_ENTRY _ZTV9S19558C14[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C15D1Ev();
extern void _ZN9S19558C15D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C15__9S19558C14[] = {
  ABISELECT(984,604),
  ABISELECT(592,372),
  ABISELECT(784,484),
  ABISELECT(656,408),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C89S19558C15__9S19558C14[] = {
  ABISELECT(592,372),
  ABISELECT(784,484),
  ABISELECT(656,408),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C89S19558C15__9S19558C14[] = {
  ABISELECT(656,408),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C89S19558C15__A1__9S19558C14[] = {
  ABISELECT(656,408),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn656_N8S19558C9D1Ev,_ZThn408_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn656_N8S19558C9D0Ev,_ZThn408_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C15__A1__9S19558C14[] = {
  ABISELECT(-656,-408),
  0,
  0,
  ABISELECT(-656,-408),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn656_N9S19558C10D1Ev,_ZThn408_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn656_N9S19558C10D0Ev,_ZThn408_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C89S19558C15__9S19558C14[] = {
  ABISELECT(-656,-408),
  0,
  0,
  ABISELECT(-656,-408),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn656_N8S19558C8D1Ev,_ZThn408_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn656_N8S19558C8D0Ev,_ZThn408_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C89S19558C15__9S19558C14[] = {
  ABISELECT(-656,-408),
  0,
  0,
  ABISELECT(-656,-408),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn784_N8S19558C8D1Ev,_ZThn484_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn784_N8S19558C8D0Ev,_ZThn484_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C89S19558C15__9S19558C14[] = {
  ABISELECT(-784,-484),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-784,-484),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C89S19558C15__9S19558C14[] = {
  0,
  0,
  ABISELECT(-592,-372),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C15__A2__9S19558C14[] = {
  ABISELECT(304,188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn304_N8S19558C9D1Ev,_ZThn188_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn304_N8S19558C9D0Ev,_ZThn188_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C15__A2__9S19558C14[] = {
  ABISELECT(-304,-188),
  0,
  0,
  ABISELECT(-304,-188),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__9S19558C15__9S19558C14[] = {
  0,
  0,
  ABISELECT(-592,-372),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn656_N9S19558C15D1Ev,_ZThn408_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn656_N9S19558C15D0Ev,_ZThn408_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C15__9S19558C14[] = {
  ABISELECT(-656,-408),
  0,
  0,
  ABISELECT(-656,-408),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn784_N9S19558C15D1Ev,_ZThn484_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn784_N9S19558C15D0Ev,_ZThn484_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C15__9S19558C14[] = {
  ABISELECT(-784,-484),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-784,-484),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn984_N9S19558C15D1Ev,_ZThn604_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn984_N9S19558C15D0Ev,_ZThn604_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C15__9S19558C14[] = {
  ABISELECT(-984,-604),
  ABISELECT(-328,-196),
  ABISELECT(-984,-604),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C15__9S19558C14[] = {
  ABISELECT(304,188),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C14[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C14[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C14[] = {
  ABISELECT(-328,-196),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__9S19558C14[] = {
  ABISELECT(328,196),
  0,
  0,
  ABISELECT(328,196),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
static  VTT_ENTRY vtt_S19558C14[] = {
  {&(_ZTV9S19558C14[6]),  6,57},
  {&(_tg__ZTV9S19558C15__9S19558C14[6]),  6,12},
  {&(_tg__ZTV8S19558C89S19558C15__9S19558C14[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C89S19558C15__9S19558C14[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C89S19558C15__A1__9S19558C14[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C15__A1__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C89S19558C15__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C89S19558C15__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C89S19558C15__9S19558C14[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C89S19558C15__9S19558C14[4]),  4,6},
  {&(_tg__ZTV8S19558C99S19558C15__A2__9S19558C14[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C15__A2__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C6__9S19558C15__9S19558C14[4]),  4,6},
  {&(_tg__ZTV8S19558C5__9S19558C15__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C15__9S19558C14[6]),  6,10},
  {&(_tg__ZTV8S19558C4__9S19558C15__9S19558C14[4]),  4,6},
  {&(_tg__ZTV8S19558C9__A__9S19558C15__9S19558C14[3]),  3,7},
  {&(_ZTV9S19558C14[30]),  30,57},
  {&(_ZTV9S19558C14[37]),  37,57},
  {&(_ZTV9S19558C14[47]),  47,57},
  {&(_ZTV9S19558C14[55]),  55,57},
  {&(_ZTV9S19558C14[22]),  22,57},
  {&(_tg__ZTV8S19558C9__9S19558C14[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C14[5]),  5,9},
  {&(_tg__ZTV8S19558C4__9S19558C14[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__9S19558C14[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C14[];
extern  VTBL_ENTRY _ZTV9S19558C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C14[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N9S19558C15D0Ev,_ZThn604_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N9S19558C15D1Ev,_ZThn604_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C15D0Ev,_ZThn484_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C15D1Ev,_ZThn484_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C15D0Ev,_ZThn408_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C15D1Ev,_ZThn408_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C8D0Ev,_ZThn484_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C8D1Ev,_ZThn484_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S19558C8D0Ev,_ZThn408_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S19558C8D1Ev,_ZThn408_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C10D0Ev,_ZThn408_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C10D1Ev,_ZThn408_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S19558C9D0Ev,_ZThn188_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S19558C9D0Ev,_ZThn408_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn304_N8S19558C9D1Ev,_ZThn188_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn656_N8S19558C9D1Ev,_ZThn408_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N9S19558C14D0Ev,_ZThn604_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn984_N9S19558C14D1Ev,_ZThn604_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C14D0Ev,_ZThn484_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C14D1Ev,_ZThn484_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C14D0Ev,_ZThn408_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn656_N9S19558C14D1Ev,_ZThn408_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C14 = {  "S19558C14", // class name
  bases_S19558C14, 15,
  &(vtc_S19558C14[0]), // expected_vtbl_contents
  &(vtt_S19558C14[0]), // expected_vtt_contents
  ABISELECT(1008,612), // object size
  NSPAIRA(_ZTI9S19558C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19558C14),57, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C14),26, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C12  : S19558C3 , S19558C9 , S19558C7 , S19558C13 , S19558C14 {
  char s19558c12f0;
  char s19558c12f1;
  int s19558c12f2;
  long double s19558c12f3[4];
  void *s19558c12f4;
  __tsi64 s19558c12f5:54;
  virtual  ~S19558C12(); // _ZN9S19558C12D2Ev
  virtual void  v12(); // _ZN9S19558C123v12Ev
  S19558C12(); // tgen
};
//SIG(-1 S19558C12) C1{ BC2{ VBC3{ VBC4{ BC5{ v2 v3 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} Fi} BC5 VBC6{ BC7{ VBC4 VBC8{ VBC4 BC5 vd Fi FC4 Fi} BC9{ BC8 vd Fi Fp Fi[2]} VBC5 vd v4 FU10{ m Fi[2] FL}} vd v5 FD[3] Fi Fc FC8 Fi:9 Fc[5] Fi Fp[9]} BC7 BC4 vd v6 v7 Fc:0 Fc Fi:10 Fc Fi} BC8 BC6 BC11{ VBC7 BC8 vd v8 v9 Fc FC8 Fc} BC12{ BC13{ VBC5 BC7 BC4 VBC3 BC8 vd v10 Fi Fi Fi} vd v11 Fi Fl Fi FL} vd v1 Fc Fc Fi FD[4] Fp FL:54}


 S19558C12 ::~S19558C12(){ note_dtor("S19558C12", this);}
void  S19558C12 ::v12(){vfunc_called(this, "_ZN9S19558C123v12Ev");}
S19558C12 ::S19558C12(){ note_ctor("S19558C12", this);} // tgen

static void Test_S19558C12()
{
  extern Class_Descriptor cd_S19558C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(249,600)];
    init_test(&cd_S19558C12, buf);
    S19558C12 *dp, &lv = *(dp=new (buf) S19558C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3968,2396), "sizeof(S19558C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C12)");
    /*is_ambiguous_... S19558C12::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(2624,1588), "S19558C12");
    check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C7*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C3*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C3*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C7*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C13*), ABISELECT(2624,1588), "S19558C12");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(2624,1588), "S19558C12");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(2624,1588), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(2624,1588), "S19558C12");
    check_base_class_offset(lv, (S19558C4*)(S19558C3*), ABISELECT(2608,1580), "S19558C12");
    check_base_class_offset(lv, (S19558C4*)(S19558C15*)(S19558C14*), ABISELECT(2608,1580), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C3*), 0, "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C7*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C3*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C7*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(3472,2096), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(2752,1664), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(2752,1664), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(2752,1664), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C7*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C3*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C7*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C15*)(S19558C14*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(3680,2216), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C8*)(S19558C7*), ABISELECT(2752,1664), "S19558C12");
    check_base_class_offset(lv, (S19558C7*)(S19558C3*), ABISELECT(2752,1664), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C3*), ABISELECT(64,36), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C3*), ABISELECT(64,36), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C3*), ABISELECT(64,36), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C8*)(S19558C3*), ABISELECT(64,36), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C3*), ABISELECT(288,180), "S19558C12");
    /*is_ambiguous_... S19558C3::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C3*), ABISELECT(288,180), "S19558C12");
    check_base_class_offset(lv, (S19558C3*), 0, "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(432,264), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(432,264), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(640,384), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(640,384), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(640,384), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C8*)(S19558C7*), ABISELECT(640,384), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C7 */ AMB_check_base_class_offset(lv, (S19558C7*), ABISELECT(640,384), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(3744,2252), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(3744,2252), "S19558C12");
    /*is_ambiguous_... S19558C12::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*), ABISELECT(3744,2252), "S19558C12");
    check_base_class_offset(lv, (S19558C8*)(S19558C13*), ABISELECT(3744,2252), "S19558C12");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C13*), ABISELECT(1360,816), "S19558C12");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C13*), ABISELECT(1360,816), "S19558C12");
    check_base_class_offset(lv, (S19558C13*), ABISELECT(1360,816), "S19558C12");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1920,1140), "S19558C12");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1920,1140), "S19558C12");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1920,1140), "S19558C12");
    check_base_class_offset(lv, (S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1920,1140), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C15*)(S19558C14*), ABISELECT(2144,1284), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C15*)(S19558C14*), ABISELECT(2144,1284), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(2272,1360), "S19558C12");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(2272,1360), "S19558C12");
    check_base_class_offset(lv, (S19558C15*)(S19558C14*), ABISELECT(1920,1140), "S19558C12");
    check_base_class_offset(lv, (S19558C14*), ABISELECT(1920,1140), "S19558C12");
    check_field_offset(lv, s19558c12f0, ABISELECT(2512,1512), "S19558C12.s19558c12f0");
    check_field_offset(lv, s19558c12f1, ABISELECT(2513,1513), "S19558C12.s19558c12f1");
    check_field_offset(lv, s19558c12f2, ABISELECT(2516,1516), "S19558C12.s19558c12f2");
    check_field_offset(lv, s19558c12f3, ABISELECT(2528,1520), "S19558C12.s19558c12f3");
    check_field_offset(lv, s19558c12f4, ABISELECT(2592,1568), "S19558C12.s19558c12f4");
    set_bf_and_test(lv, s19558c12f5, ABISELECT(2600,1572), 0, 54, 1, "S19558C12");
    set_bf_and_test(lv, s19558c12f5, ABISELECT(2600,1572), 0, 54, hide_sll(1LL<<53), "S19558C12");
    test_class_info(&lv, &cd_S19558C12);
    dp->~S19558C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C12(Test_S19558C12, "S19558C12", ABISELECT(3968,2396));

#else // __cplusplus

extern void _ZN9S19558C12C1Ev();
extern void _ZN9S19558C12D2Ev();
Name_Map name_map_S19558C12[] = {
  NSPAIR(_ZN9S19558C12C1Ev),
  NSPAIR(_ZN9S19558C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C7;
extern VTBL_ENTRY _ZTI8S19558C7[];
extern  VTBL_ENTRY _ZTV8S19558C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C7[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C3;
extern VTBL_ENTRY _ZTI8S19558C3[];
extern  VTBL_ENTRY _ZTV8S19558C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C3[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C7;
extern VTBL_ENTRY _ZTI8S19558C7[];
extern  VTBL_ENTRY _ZTV8S19558C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C7[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C13;
extern VTBL_ENTRY _ZTI9S19558C13[];
extern  VTBL_ENTRY _ZTV9S19558C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C13[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C15;
extern VTBL_ENTRY _ZTI9S19558C15[];
extern  VTBL_ENTRY _ZTV9S19558C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C15[];
extern Class_Descriptor cd_S19558C14;
extern VTBL_ENTRY _ZTI9S19558C14[];
extern  VTBL_ENTRY _ZTV9S19558C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C14[];
static Base_Class bases_S19558C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(2624,1588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(2624,1588), //bcp->offset
    93, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    61, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19558C4,    ABISELECT(2608,1580), //bcp->offset
    87, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    60, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(3472,2096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(3472,2096), //bcp->offset
    118, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    63, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(2752,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(2752,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(2752,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    76, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(3680,2216), //bcp->offset
    128, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    64, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C8,    ABISELECT(2752,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    75, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19558C7,    ABISELECT(2752,1664), //bcp->offset
    102, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    62, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(64,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    65, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(288,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(288,180), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19558C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(432,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(432,264), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    66, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(640,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(640,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(640,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(640,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19558C7,    ABISELECT(640,384), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    67, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(3744,2252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(3744,2252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(3744,2252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    89, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(3744,2252), //bcp->offset
    134, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    69, //bcp->index_in_construction_vtbl_array
    88, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(1360,816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(1360,816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19558C13,    ABISELECT(1360,816), //bcp->offset
    49, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    68, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(1920,1140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(1920,1140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(1920,1140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(1920,1140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(2144,1284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(2144,1284), //bcp->offset
    74, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(2272,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(2272,1360), //bcp->offset
    80, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    71, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19558C15,    ABISELECT(1920,1140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S19558C14,    ABISELECT(1920,1140), //bcp->offset
    61, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    70, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C12[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C12D1Ev();
extern void _ZN9S19558C12D0Ev();
extern void _ZN8S19558C32v6Ev();
extern void _ZN8S19558C32v7Ev();
extern void _ZN9S19558C123v12Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn64_N9S19558C12D1Ev,_ZThn36_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn64_N9S19558C12D0Ev,_ZThn36_N9S19558C12D0Ev)();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn288_N9S19558C12D1Ev,_ZThn180_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn288_N9S19558C12D0Ev,_ZThn180_N9S19558C12D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn432_N9S19558C12D1Ev,_ZThn264_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn432_N9S19558C12D0Ev,_ZThn264_N9S19558C12D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn640_N9S19558C12D1Ev,_ZThn384_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn640_N9S19558C12D0Ev,_ZThn384_N9S19558C12D0Ev)();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn1360_N9S19558C12D1Ev,_ZThn816_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn1360_N9S19558C12D0Ev,_ZThn816_N9S19558C12D0Ev)();
extern void _ZN9S19558C132v8Ev();
extern void _ZN9S19558C132v9Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn1920_N9S19558C12D1Ev,_ZThn1140_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn1920_N9S19558C12D0Ev,_ZThn1140_N9S19558C12D0Ev)();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN9S19558C143v11Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn2144_N9S19558C12D1Ev,_ZThn1284_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn2144_N9S19558C12D0Ev,_ZThn1284_N9S19558C12D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn2272_N9S19558C12D1Ev,_ZThn1360_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn2272_N9S19558C12D0Ev,_ZThn1360_N9S19558C12D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19558C12D1Ev,_ZTv0_n16_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn2608_N9S19558C12D1Ev,_ZThn1580_N9S19558C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C12D0Ev,_ZTv0_n16_N9S19558C12D0Ev)();
extern void ABISELECT(_ZThn2608_N9S19558C12D0Ev,_ZThn1580_N9S19558C12D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C12D1Ev,_ZTv0_n20_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn2624_N9S19558C12D1Ev,_ZThn1588_N9S19558C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C12D0Ev,_ZTv0_n20_N9S19558C12D0Ev)();
extern void ABISELECT(_ZThn2624_N9S19558C12D0Ev,_ZThn1588_N9S19558C12D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C12D1Ev,_ZTv0_n32_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn2752_N9S19558C12D1Ev,_ZThn1664_N9S19558C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C12D0Ev,_ZTv0_n32_N9S19558C12D0Ev)();
extern void ABISELECT(_ZThn2752_N9S19558C12D0Ev,_ZThn1664_N9S19558C12D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C12D1Ev,_ZTv0_n24_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn3472_N9S19558C12D1Ev,_ZThn2096_N9S19558C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C12D0Ev,_ZTv0_n24_N9S19558C12D0Ev)();
extern void ABISELECT(_ZThn3472_N9S19558C12D0Ev,_ZThn2096_N9S19558C12D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C12D1Ev,_ZTv0_n32_N9S19558C12D1Ev)();
extern void ABISELECT(_ZThn3744_N9S19558C12D1Ev,_ZThn2252_N9S19558C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C12D0Ev,_ZTv0_n32_N9S19558C12D0Ev)();
extern void ABISELECT(_ZThn3744_N9S19558C12D0Ev,_ZThn2252_N9S19558C12D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY vtc_S19558C12[] = {
  ABISELECT(3744,2252),
  ABISELECT(3680,2216),
  ABISELECT(3472,2096),
  ABISELECT(2752,1664),
  ABISELECT(2624,1588),
  ABISELECT(2608,1580),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C12D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v6Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v7Ev,
  (VTBL_ENTRY)&_ZN9S19558C123v12Ev,
  ABISELECT(3616,2180),
  ABISELECT(3408,2060),
  ABISELECT(2560,1552),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19558C12D1Ev,_ZThn36_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S19558C12D0Ev,_ZThn36_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N9S19558C12D1Ev,_ZThn180_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn288_N9S19558C12D0Ev,_ZThn180_N9S19558C12D0Ev),
  ABISELECT(2192,1324),
  ABISELECT(-432,-264),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn432_N9S19558C12D1Ev,_ZThn264_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn432_N9S19558C12D0Ev,_ZThn264_N9S19558C12D0Ev),
  ABISELECT(3040,1832),
  ABISELECT(2832,1712),
  ABISELECT(1984,1204),
  ABISELECT(-640,-384),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19558C12D1Ev,_ZThn384_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn640_N9S19558C12D0Ev,_ZThn384_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
  ABISELECT(2320,1400),
  ABISELECT(2112,1280),
  ABISELECT(2384,1436),
  ABISELECT(1264,772),
  ABISELECT(-1360,-816),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1360_N9S19558C12D1Ev,_ZThn816_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1360_N9S19558C12D0Ev,_ZThn816_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19558C132v8Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v9Ev,
  ABISELECT(688,440),
  ABISELECT(1760,1076),
  ABISELECT(1552,956),
  ABISELECT(704,448),
  ABISELECT(-1920,-1140),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1920_N9S19558C12D1Ev,_ZThn1140_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1920_N9S19558C12D0Ev,_ZThn1140_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19558C143v11Ev,
  ABISELECT(-2144,-1284),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2144_N9S19558C12D1Ev,_ZThn1284_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2144_N9S19558C12D0Ev,_ZThn1284_N9S19558C12D0Ev),
  ABISELECT(352,228),
  ABISELECT(-2272,-1360),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2272_N9S19558C12D1Ev,_ZThn1360_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2272_N9S19558C12D0Ev,_ZThn1360_N9S19558C12D0Ev),
  ABISELECT(-2608,-1580),
  ABISELECT(16,8),
  ABISELECT(-2608,-1580),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C12D1Ev,_ZTv0_n16_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C12D0Ev,_ZTv0_n16_N9S19558C12D0Ev),
  ABISELECT(-2624,-1588),
  0,
  0,
  ABISELECT(-2624,-1588),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C12D1Ev,_ZTv0_n20_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C12D0Ev,_ZTv0_n20_N9S19558C12D0Ev),
  0,
  0,
  ABISELECT(-2752,-1664),
  0,
  0,
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  ABISELECT(-2752,-1664),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C12D1Ev,_ZTv0_n32_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C12D0Ev,_ZTv0_n32_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
  ABISELECT(-3472,-2096),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-3472,-2096),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C12D1Ev,_ZTv0_n24_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C12D0Ev,_ZTv0_n24_N9S19558C12D0Ev),
  0,
  0,
  ABISELECT(-3680,-2216),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  0,
  ABISELECT(-3744,-2252),
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-272,-156),
  ABISELECT(-1120,-664),
  ABISELECT(-3744,-2252),
  (VTBL_ENTRY)&(_ZTI9S19558C12[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C12D1Ev,_ZTv0_n32_N9S19558C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C12D0Ev,_ZTv0_n32_N9S19558C12D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern VTBL_ENTRY _ZTV9S19558C12[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C3D1Ev();
extern void _ZN8S19558C3D0Ev();
extern void _ZN8S19558C32v6Ev();
extern void _ZN8S19558C32v7Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C3__9S19558C12[] = {
  ABISELECT(3680,2216),
  ABISELECT(3472,2096),
  ABISELECT(2752,1664),
  ABISELECT(2624,1588),
  ABISELECT(2608,1580),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v6Ev,
  (VTBL_ENTRY)&_ZN8S19558C32v7Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C88S19558C3__A1__9S19558C12[] = {
  ABISELECT(3616,2180),
  ABISELECT(3408,2060),
  ABISELECT(2560,1552),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C88S19558C3__A1__9S19558C12[] = {
  ABISELECT(2560,1552),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C88S19558C3__A2__9S19558C12[] = {
  ABISELECT(2560,1552),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn2560_N8S19558C9D1Ev,_ZThn1552_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn2560_N8S19558C9D0Ev,_ZThn1552_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C3__A2__9S19558C12[] = {
  ABISELECT(-2560,-1552),
  0,
  0,
  ABISELECT(-2560,-1552),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn2560_N9S19558C10D1Ev,_ZThn1552_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn2560_N9S19558C10D0Ev,_ZThn1552_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C88S19558C3__A1__9S19558C12[] = {
  ABISELECT(-2560,-1552),
  0,
  0,
  ABISELECT(-2560,-1552),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn2560_N8S19558C8D1Ev,_ZThn1552_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn2560_N8S19558C8D0Ev,_ZThn1552_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C88S19558C3__A1__9S19558C12[] = {
  ABISELECT(-2560,-1552),
  0,
  0,
  ABISELECT(-2560,-1552),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn3408_N8S19558C8D1Ev,_ZThn2060_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn3408_N8S19558C8D0Ev,_ZThn2060_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C88S19558C3__A1__9S19558C12[] = {
  ABISELECT(-3408,-2060),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-3408,-2060),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C88S19558C3__A1__9S19558C12[] = {
  0,
  0,
  ABISELECT(-3616,-2180),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn2608_N8S19558C3D1Ev,_ZThn1580_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn2608_N8S19558C3D0Ev,_ZThn1580_N8S19558C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__8S19558C3__9S19558C12[] = {
  ABISELECT(-2608,-1580),
  ABISELECT(16,8),
  ABISELECT(-2608,-1580),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn2624_N8S19558C3D1Ev,_ZThn1588_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn2624_N8S19558C3D0Ev,_ZThn1588_N8S19558C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C3__9S19558C12[] = {
  ABISELECT(-2624,-1588),
  0,
  0,
  ABISELECT(-2624,-1588),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn2752_N8S19558C3D1Ev,_ZThn1664_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn2752_N8S19558C3D0Ev,_ZThn1664_N8S19558C3D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C7__8S19558C3__9S19558C12[] = {
  0,
  0,
  ABISELECT(-2752,-1664),
  0,
  0,
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  ABISELECT(-2752,-1664),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn3472_N8S19558C3D1Ev,_ZThn2096_N8S19558C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev)();
extern void ABISELECT(_ZThn3472_N8S19558C3D0Ev,_ZThn2096_N8S19558C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C3__9S19558C12[] = {
  ABISELECT(-3472,-2096),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-3472,-2096),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A4__8S19558C3__9S19558C12[] = {
  0,
  0,
  ABISELECT(-3680,-2216),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn64_N8S19558C3D1Ev,_ZThn36_N8S19558C3D1Ev)();
extern void ABISELECT(_ZThn64_N8S19558C3D0Ev,_ZThn36_N8S19558C3D0Ev)();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__A1__8S19558C3__9S19558C12[] = {
  ABISELECT(3616,2180),
  ABISELECT(3408,2060),
  ABISELECT(2560,1552),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19558C3[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19558C3D1Ev,_ZThn36_N8S19558C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19558C3D0Ev,_ZThn36_N8S19558C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C12[] = {
  ABISELECT(2192,1324),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn2192_N8S19558C9D1Ev,_ZThn1324_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn2192_N8S19558C9D0Ev,_ZThn1324_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A__9S19558C12[] = {
  ABISELECT(-2192,-1324),
  0,
  0,
  ABISELECT(-2192,-1324),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C7D1Ev();
extern void _ZN8S19558C7D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C7__A__9S19558C12[] = {
  ABISELECT(3040,1832),
  ABISELECT(2832,1712),
  ABISELECT(1984,1204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C88S19558C7__A2__9S19558C12[] = {
  ABISELECT(3040,1832),
  ABISELECT(2832,1712),
  ABISELECT(1984,1204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C88S19558C7__A2__9S19558C12[] = {
  ABISELECT(1984,1204),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A4__9S19558C12[] = {
  ABISELECT(1984,1204),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C9D1Ev,_ZThn1204_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C9D0Ev,_ZThn1204_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A4__9S19558C12[] = {
  ABISELECT(-1984,-1204),
  0,
  0,
  ABISELECT(-1984,-1204),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn1984_N9S19558C10D1Ev,_ZThn1204_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn1984_N9S19558C10D0Ev,_ZThn1204_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__A2__9S19558C12[] = {
  ABISELECT(-1984,-1204),
  0,
  0,
  ABISELECT(-1984,-1204),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C8D1Ev,_ZThn1204_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C8D0Ev,_ZThn1204_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C88S19558C7__A2__9S19558C12[] = {
  ABISELECT(-1984,-1204),
  0,
  0,
  ABISELECT(-1984,-1204),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn2832_N8S19558C8D1Ev,_ZThn1712_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn2832_N8S19558C8D0Ev,_ZThn1712_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C88S19558C7__A2__9S19558C12[] = {
  ABISELECT(-2832,-1712),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-2832,-1712),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C88S19558C7__A2__9S19558C12[] = {
  0,
  0,
  ABISELECT(-3040,-1832),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C7D1Ev,_ZThn1204_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn1984_N8S19558C7D0Ev,_ZThn1204_N8S19558C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C7__A__9S19558C12[] = {
  ABISELECT(-1984,-1204),
  0,
  0,
  ABISELECT(-1984,-1204),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn2832_N8S19558C7D1Ev,_ZThn1712_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn2832_N8S19558C7D0Ev,_ZThn1712_N8S19558C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C7__A__9S19558C12[] = {
  ABISELECT(-2832,-1712),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-2832,-1712),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C7__A__9S19558C12[] = {
  0,
  0,
  ABISELECT(-3040,-1832),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C13D1Ev();
extern void _ZN9S19558C13D0Ev();
extern void _ZN9S19558C132v8Ev();
extern void _ZN9S19558C132v9Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C13__9S19558C12[] = {
  ABISELECT(2320,1400),
  ABISELECT(2112,1280),
  ABISELECT(2384,1436),
  ABISELECT(1264,772),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v8Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v9Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C13__A6__9S19558C12[] = {
  ABISELECT(1264,772),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn1264_N8S19558C9D1Ev,_ZThn772_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn1264_N8S19558C9D0Ev,_ZThn772_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C13__A6__9S19558C12[] = {
  ABISELECT(-1264,-772),
  0,
  0,
  ABISELECT(-1264,-772),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn2384_N9S19558C13D1Ev,_ZThn1436_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn2384_N9S19558C13D0Ev,_ZThn1436_N9S19558C13D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__9S19558C13__9S19558C12[] = {
  0,
  ABISELECT(-2384,-1436),
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-272,-156),
  ABISELECT(-1120,-664),
  ABISELECT(-2384,-1436),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn1264_N9S19558C13D1Ev,_ZThn772_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn1264_N9S19558C13D0Ev,_ZThn772_N9S19558C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C13__9S19558C12[] = {
  ABISELECT(-1264,-772),
  0,
  0,
  ABISELECT(-1264,-772),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn2112_N9S19558C13D1Ev,_ZThn1280_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn2112_N9S19558C13D0Ev,_ZThn1280_N9S19558C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C13__9S19558C12[] = {
  ABISELECT(-2112,-1280),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-2112,-1280),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__9S19558C13__9S19558C12[] = {
  0,
  0,
  ABISELECT(-2320,-1400),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C14D1Ev();
extern void _ZN9S19558C14D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN9S19558C143v11Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C14__9S19558C12[] = {
  ABISELECT(688,440),
  ABISELECT(1760,1076),
  ABISELECT(1552,956),
  ABISELECT(704,448),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19558C143v11Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C15D1Ev();
extern void _ZN9S19558C15D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C159S19558C14__9S19558C12[] = {
  ABISELECT(688,440),
  ABISELECT(1760,1076),
  ABISELECT(1552,956),
  ABISELECT(704,448),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  ABISELECT(1760,1076),
  ABISELECT(1552,956),
  ABISELECT(704,448),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  ABISELECT(704,448),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C89S19558C159S19558C14__A7__9S19558C12[] = {
  ABISELECT(704,448),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn704_N8S19558C9D1Ev,_ZThn448_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn704_N8S19558C9D0Ev,_ZThn448_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C159S19558C14__A7__9S19558C12[] = {
  ABISELECT(-704,-448),
  0,
  0,
  ABISELECT(-704,-448),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn704_N9S19558C10D1Ev,_ZThn448_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn704_N9S19558C10D0Ev,_ZThn448_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  ABISELECT(-704,-448),
  0,
  0,
  ABISELECT(-704,-448),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn704_N8S19558C8D1Ev,_ZThn448_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn704_N8S19558C8D0Ev,_ZThn448_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  ABISELECT(-704,-448),
  0,
  0,
  ABISELECT(-704,-448),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn1552_N8S19558C8D1Ev,_ZThn956_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn1552_N8S19558C8D0Ev,_ZThn956_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  ABISELECT(-1552,-956),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-1552,-956),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C89S19558C159S19558C14__A4__9S19558C12[] = {
  0,
  0,
  ABISELECT(-1760,-1076),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C159S19558C14__A8__9S19558C12[] = {
  ABISELECT(352,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn352_N8S19558C9D1Ev,_ZThn228_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn352_N8S19558C9D0Ev,_ZThn228_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C159S19558C14__A8__9S19558C12[] = {
  ABISELECT(-352,-228),
  0,
  0,
  ABISELECT(-352,-228),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__9S19558C159S19558C14__9S19558C12[] = {
  0,
  0,
  ABISELECT(-1760,-1076),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn704_N9S19558C15D1Ev,_ZThn448_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn704_N9S19558C15D0Ev,_ZThn448_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C159S19558C14__9S19558C12[] = {
  ABISELECT(-704,-448),
  0,
  0,
  ABISELECT(-704,-448),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn1552_N9S19558C15D1Ev,_ZThn956_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn1552_N9S19558C15D0Ev,_ZThn956_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C159S19558C14__9S19558C12[] = {
  ABISELECT(-1552,-956),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-1552,-956),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn688_N9S19558C15D1Ev,_ZThn440_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn688_N9S19558C15D0Ev,_ZThn440_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C159S19558C14__9S19558C12[] = {
  ABISELECT(-688,-440),
  ABISELECT(16,8),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C159S19558C14__9S19558C12[] = {
  ABISELECT(352,228),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__9S19558C14__9S19558C12[] = {
  0,
  0,
  ABISELECT(-1760,-1076),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn704_N9S19558C14D1Ev,_ZThn448_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn704_N9S19558C14D0Ev,_ZThn448_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C14__9S19558C12[] = {
  ABISELECT(-704,-448),
  0,
  0,
  ABISELECT(-704,-448),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn1552_N9S19558C14D1Ev,_ZThn956_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn1552_N9S19558C14D0Ev,_ZThn956_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C14__9S19558C12[] = {
  ABISELECT(-1552,-956),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-1552,-956),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn688_N9S19558C14D1Ev,_ZThn440_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn688_N9S19558C14D0Ev,_ZThn440_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C14__9S19558C12[] = {
  ABISELECT(-688,-440),
  ABISELECT(16,8),
  ABISELECT(-688,-440),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C15__A2__9S19558C14__9S19558C12[] = {
  ABISELECT(352,228),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev),
};
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C12[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZThn16_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
extern void ABISELECT(_ZThn16_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__9S19558C12[] = {
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C7D1Ev();
extern void _ZN8S19558C7D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C7__9S19558C12[] = {
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C7D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN8S19558C72v5Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C88S19558C7__9S19558C12[] = {
  ABISELECT(928,552),
  ABISELECT(720,432),
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C88S19558C7__9S19558C12[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A1__9S19558C12[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A1__9S19558C12[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__9S19558C12[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C88S19558C7__9S19558C12[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C88S19558C7__9S19558C12[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C88S19558C7__9S19558C12[] = {
  0,
  0,
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C7__9S19558C12[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev)();
extern void ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C7__9S19558C12[] = {
  ABISELECT(-720,-432),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(-720,-432),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C7__9S19558C12[] = {
  0,
  0,
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S19558C7[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C12[] = {
  ABISELECT(-848,-508),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C12[] = {
  ABISELECT(848,508),
  0,
  0,
  ABISELECT(848,508),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__A3__9S19558C12[] = {
  ABISELECT(-64,-36),
  ABISELECT(-272,-156),
  ABISELECT(-1120,-664),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__A3__9S19558C12[] = {
  ABISELECT(-1120,-664),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A5__9S19558C12[] = {
  ABISELECT(-1120,-664),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A5__9S19558C12[] = {
  ABISELECT(1120,664),
  0,
  0,
  ABISELECT(1120,664),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__A3__9S19558C12[] = {
  ABISELECT(1120,664),
  0,
  0,
  ABISELECT(1120,664),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__A3__9S19558C12[] = {
  ABISELECT(1120,664),
  0,
  0,
  ABISELECT(1120,664),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__A3__9S19558C12[] = {
  ABISELECT(272,156),
  0,
  0,
  ABISELECT(-848,-508),
  ABISELECT(272,156),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__A3__9S19558C12[] = {
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
static  VTT_ENTRY vtt_S19558C12[] = {
  {&(_ZTV9S19558C12[8]),  8,148},
  {&(_tg__ZTV8S19558C3__9S19558C12[7]),  7,13},
  {&(_tg__ZTV8S19558C88S19558C3__A1__9S19558C12[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C88S19558C3__A1__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C88S19558C3__A2__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C3__A2__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C88S19558C3__A1__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C88S19558C3__A1__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C88S19558C3__A1__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C88S19558C3__A1__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C4__8S19558C3__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C5__8S19558C3__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C7__8S19558C3__9S19558C12[10]),  10,16},
  {&(_tg__ZTV8S19558C9__8S19558C3__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A4__8S19558C3__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C8__A1__8S19558C3__9S19558C12[5]),  5,10},
  {&(_tg__ZTV8S19558C9__A__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C7__A__9S19558C12[5]),  5,11},
  {&(_tg__ZTV8S19558C88S19558C7__A2__9S19558C12[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C88S19558C7__A2__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A4__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A4__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__A2__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C88S19558C7__A2__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C88S19558C7__A2__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C88S19558C7__A2__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C5__8S19558C7__A__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C7__A__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C7__A__9S19558C12[4]),  4,6},
  {&(_tg__ZTV9S19558C13__9S19558C12[6]),  6,12},
  {&(_tg__ZTV8S19558C99S19558C13__A6__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C13__A6__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C8__9S19558C13__9S19558C12[9]),  9,14},
  {&(_tg__ZTV8S19558C5__9S19558C13__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C13__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__9S19558C13__9S19558C12[4]),  4,6},
  {&(_tg__ZTV9S19558C14__9S19558C12[6]),  6,13},
  {&(_tg__ZTV9S19558C159S19558C14__9S19558C12[6]),  6,12},
  {&(_tg__ZTV8S19558C89S19558C159S19558C14__A4__9S19558C12[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C89S19558C159S19558C14__A4__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C89S19558C159S19558C14__A7__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C159S19558C14__A7__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C89S19558C159S19558C14__A4__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C89S19558C159S19558C14__A4__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C89S19558C159S19558C14__A4__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C89S19558C159S19558C14__A4__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C99S19558C159S19558C14__A8__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C159S19558C14__A8__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C6__9S19558C159S19558C14__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C5__9S19558C159S19558C14__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C159S19558C14__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C4__9S19558C159S19558C14__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C9__A__9S19558C159S19558C14__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C6__9S19558C14__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C5__9S19558C14__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C14__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C4__9S19558C14__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C99S19558C15__A2__9S19558C14__9S19558C12[3]),  3,7},
  {&(_ZTV9S19558C12[91]),  91,148},
  {&(_ZTV9S19558C12[98]),  98,148},
  {&(_ZTV9S19558C12[112]),  112,148},
  {&(_ZTV9S19558C12[124]),  124,148},
  {&(_ZTV9S19558C12[132]),  132,148},
  {&(_ZTV9S19558C12[20]),  20,148},
  {&(_ZTV9S19558C12[34]),  34,148},
  {&(_ZTV9S19558C12[43]),  43,148},
  {&(_ZTV9S19558C12[55]),  55,148},
  {&(_ZTV9S19558C12[143]),  143,148},
  {&(_ZTV9S19558C12[67]),  67,148},
  {&(_ZTV9S19558C12[83]),  83,148},
  {&(_tg__ZTV8S19558C4__9S19558C12[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C7__9S19558C12[5]),  5,11},
  {&(_tg__ZTV8S19558C88S19558C7__9S19558C12[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C88S19558C7__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C88S19558C7__A1__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C88S19558C7__A1__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C88S19558C7__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C88S19558C7__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C88S19558C7__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C88S19558C7__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C5__8S19558C7__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C7__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C7__9S19558C12[4]),  4,6},
  {&(_tg__ZTV8S19558C9__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C8__A3__9S19558C12[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__A3__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A5__9S19558C12[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A5__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__A3__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__A3__9S19558C12[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__A3__9S19558C12[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__A3__9S19558C12[4]),  4,6},
};
extern VTBL_ENTRY _ZTI9S19558C12[];
extern  VTBL_ENTRY _ZTV9S19558C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C12[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19558C4D0Ev,_ZThn8_N8S19558C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19558C4D1Ev,_ZThn8_N8S19558C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19558C14D0Ev,_ZThn440_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19558C14D1Ev,_ZThn440_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N9S19558C14D0Ev,_ZThn956_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N9S19558C14D1Ev,_ZThn956_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C14D0Ev,_ZThn448_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C14D1Ev,_ZThn448_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19558C15D0Ev,_ZThn440_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19558C15D1Ev,_ZThn440_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N9S19558C15D0Ev,_ZThn956_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N9S19558C15D1Ev,_ZThn956_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C15D0Ev,_ZThn448_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C15D1Ev,_ZThn448_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N9S19558C13D0Ev,_ZThn1280_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2112_N9S19558C13D1Ev,_ZThn1280_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N9S19558C13D0Ev,_ZThn772_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N9S19558C13D1Ev,_ZThn772_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2384_N9S19558C13D0Ev,_ZThn1436_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2384_N9S19558C13D1Ev,_ZThn1436_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D0Ev,_ZTv0_n24_N8S19558C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D0Ev,_ZThn432_N8S19558C7D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2832_N8S19558C7D0Ev,_ZThn1712_N8S19558C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C7D1Ev,_ZTv0_n24_N8S19558C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C7D1Ev,_ZThn432_N8S19558C7D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2832_N8S19558C7D1Ev,_ZThn1712_N8S19558C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C7D0Ev,_ZTv0_n20_N8S19558C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C7D0Ev,_ZThn1204_N8S19558C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C7D1Ev,_ZTv0_n20_N8S19558C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C7D1Ev,_ZThn1204_N8S19558C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C3D0Ev,_ZTv0_n24_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N8S19558C3D0Ev,_ZThn2096_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C3D1Ev,_ZTv0_n24_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N8S19558C3D1Ev,_ZThn2096_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19558C3D0Ev,_ZTv0_n32_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N8S19558C3D0Ev,_ZThn1664_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S19558C3D1Ev,_ZTv0_n32_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N8S19558C3D1Ev,_ZThn1664_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C3D0Ev,_ZTv0_n20_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N8S19558C3D0Ev,_ZThn1588_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C3D1Ev,_ZTv0_n20_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N8S19558C3D1Ev,_ZThn1588_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19558C3D0Ev,_ZTv0_n16_N8S19558C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2608_N8S19558C3D0Ev,_ZThn1580_N8S19558C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19558C3D1Ev,_ZTv0_n16_N8S19558C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2608_N8S19558C3D1Ev,_ZThn1580_N8S19558C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D0Ev,_ZThn432_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N8S19558C8D0Ev,_ZThn956_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2832_N8S19558C8D0Ev,_ZThn1712_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3408_N8S19558C8D0Ev,_ZThn2060_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn720_N8S19558C8D1Ev,_ZThn432_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1552_N8S19558C8D1Ev,_ZThn956_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2832_N8S19558C8D1Ev,_ZThn1712_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3408_N8S19558C8D1Ev,_ZThn2060_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S19558C8D0Ev,_ZThn448_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C8D0Ev,_ZThn1204_N8S19558C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N8S19558C8D0Ev,_ZThn1552_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S19558C8D1Ev,_ZThn448_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C8D1Ev,_ZThn1204_N8S19558C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N8S19558C8D1Ev,_ZThn1552_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C10D0Ev,_ZThn448_N9S19558C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N9S19558C10D0Ev,_ZThn1204_N9S19558C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N9S19558C10D0Ev,_ZThn1552_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N9S19558C10D1Ev,_ZThn448_N9S19558C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N9S19558C10D1Ev,_ZThn1204_N9S19558C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N9S19558C10D1Ev,_ZThn1552_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C9D0Ev,_ZThn228_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S19558C9D0Ev,_ZThn448_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N8S19558C9D0Ev,_ZThn772_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C9D0Ev,_ZThn1204_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2192_N8S19558C9D0Ev,_ZThn1324_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N8S19558C9D0Ev,_ZThn1552_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C9D1Ev,_ZThn228_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S19558C9D1Ev,_ZThn448_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1264_N8S19558C9D1Ev,_ZThn772_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1984_N8S19558C9D1Ev,_ZThn1204_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2192_N8S19558C9D1Ev,_ZThn1324_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2560_N8S19558C9D1Ev,_ZThn1552_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C12D0Ev,_ZTv0_n24_N9S19558C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S19558C12D0Ev,_ZThn2096_N9S19558C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C12D1Ev,_ZTv0_n24_N9S19558C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S19558C12D1Ev,_ZThn2096_N9S19558C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C12D0Ev,_ZTv0_n32_N9S19558C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3744_N9S19558C12D0Ev,_ZThn2252_N9S19558C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N9S19558C12D0Ev,_ZThn1664_N9S19558C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C12D1Ev,_ZTv0_n32_N9S19558C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3744_N9S19558C12D1Ev,_ZThn2252_N9S19558C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2752_N9S19558C12D1Ev,_ZThn1664_N9S19558C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C12D0Ev,_ZTv0_n20_N9S19558C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N9S19558C12D0Ev,_ZThn1588_N9S19558C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C12D1Ev,_ZTv0_n20_N9S19558C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2624_N9S19558C12D1Ev,_ZThn1588_N9S19558C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C12D0Ev,_ZTv0_n16_N9S19558C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2608_N9S19558C12D0Ev,_ZThn1580_N9S19558C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C12D1Ev,_ZTv0_n16_N9S19558C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2608_N9S19558C12D1Ev,_ZThn1580_N9S19558C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C12 = {  "S19558C12", // class name
  bases_S19558C12, 43,
  &(vtc_S19558C12[0]), // expected_vtbl_contents
  &(vtt_S19558C12[0]), // expected_vtt_contents
  ABISELECT(3968,2396), // object size
  NSPAIRA(_ZTI9S19558C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19558C12),148, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C12),95, //virtual table table var
  43, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C17  : S19558C4 , S19558C9 , S19558C14 {
  ::S19558C10 s19558c17f0;
  ~S19558C17(); // tgen
  S19558C17(); // tgen
};
//SIG(-1 S19558C17) C1{ BC2{ VBC3{ BC4{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} Fi} BC5{ VBC3 BC4 vd Fi FC3 Fi} BC6{ BC7{ VBC4 BC8{ VBC3 VBC5 BC9{ BC5 vd Fi Fp Fi[2]} VBC4 vd v3 FU10{ m Fi[2] FL}} BC3 VBC2 BC5 vd v4 Fi Fi Fi} vd v5 Fi Fl Fi FL} FC9}


S19558C17 ::~S19558C17(){ note_dtor("S19558C17", this);} // tgen
S19558C17 ::S19558C17(){ note_ctor("S19558C17", this);} // tgen

static void Test_S19558C17()
{
  extern Class_Descriptor cd_S19558C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(100,239)];
    init_test(&cd_S19558C17, buf);
    S19558C17 *dp, &lv = *(dp=new (buf) S19558C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1584,952), "sizeof(S19558C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C17)");
    /*is_ambiguous_... S19558C17::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(1168,712), "S19558C17");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(1168,712), "S19558C17");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(1168,712), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C4*), 0, "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(16,8), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(16,8), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C15*)(S19558C14*), ABISELECT(1296,788), "S19558C17");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1296,788), "S19558C17");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(1360,824), "S19558C17");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(1360,824), "S19558C17");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(224,128), "S19558C17");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(224,128), "S19558C17");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(224,128), "S19558C17");
    check_base_class_offset(lv, (S19558C8*)(S19558C15*)(S19558C14*), ABISELECT(224,128), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C15*)(S19558C14*), ABISELECT(448,272), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C15*)(S19558C14*), ABISELECT(448,272), "S19558C17");
    check_base_class_offset(lv, (S19558C4*)(S19558C15*)(S19558C14*), ABISELECT(1560,944), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(576,348), "S19558C17");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C15*)(S19558C14*), ABISELECT(576,348), "S19558C17");
    check_base_class_offset(lv, (S19558C15*)(S19558C14*), ABISELECT(224,128), "S19558C17");
    check_base_class_offset(lv, (S19558C14*), ABISELECT(224,128), "S19558C17");
    check_field_offset(lv, s19558c17f0, ABISELECT(816,500), "S19558C17.s19558c17f0");
    test_class_info(&lv, &cd_S19558C17);
    dp->~S19558C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C17(Test_S19558C17, "S19558C17", ABISELECT(1584,952));

#else // __cplusplus

extern void _ZN9S19558C17C1Ev();
extern void _ZN9S19558C17D1Ev();
Name_Map name_map_S19558C17[] = {
  NSPAIR(_ZN9S19558C17C1Ev),
  NSPAIR(_ZN9S19558C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C4;
extern VTBL_ENTRY _ZTI8S19558C4[];
extern  VTBL_ENTRY _ZTV8S19558C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C4[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C15;
extern VTBL_ENTRY _ZTI9S19558C15[];
extern  VTBL_ENTRY _ZTV9S19558C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C15[];
extern Class_Descriptor cd_S19558C14;
extern VTBL_ENTRY _ZTI9S19558C14[];
extern  VTBL_ENTRY _ZTV9S19558C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C14[];
static Base_Class bases_S19558C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(1168,712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(1168,712), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19558C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(1296,788), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(1360,824), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(1360,824), //bcp->offset
    56, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19558C8,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(448,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(448,272), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C4,    ABISELECT(1560,944), //bcp->offset
    66, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(576,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(576,348), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C15,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19558C14,    ABISELECT(224,128), //bcp->offset
    15, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C17[];
extern void _ZN9S19558C17D1Ev();
extern void _ZN9S19558C17D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn16_N9S19558C17D1Ev,_ZThn8_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn16_N9S19558C17D0Ev,_ZThn8_N9S19558C17D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn224_N9S19558C17D1Ev,_ZThn128_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C17D0Ev,_ZThn128_N9S19558C17D0Ev)();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN9S19558C143v11Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn448_N9S19558C17D1Ev,_ZThn272_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn448_N9S19558C17D0Ev,_ZThn272_N9S19558C17D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn576_N9S19558C17D1Ev,_ZThn348_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn576_N9S19558C17D0Ev,_ZThn348_N9S19558C17D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C17D1Ev,_ZTv0_n20_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn1168_N9S19558C17D1Ev,_ZThn712_N9S19558C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C17D0Ev,_ZTv0_n20_N9S19558C17D0Ev)();
extern void ABISELECT(_ZThn1168_N9S19558C17D0Ev,_ZThn712_N9S19558C17D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C17D1Ev,_ZTv0_n24_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn1360_N9S19558C17D1Ev,_ZThn824_N9S19558C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C17D0Ev,_ZTv0_n24_N9S19558C17D0Ev)();
extern void ABISELECT(_ZThn1360_N9S19558C17D0Ev,_ZThn824_N9S19558C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C17D1Ev,_ZTv0_n16_N9S19558C17D1Ev)();
extern void ABISELECT(_ZThn1560_N9S19558C17D1Ev,_ZThn944_N9S19558C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C17D0Ev,_ZTv0_n16_N9S19558C17D0Ev)();
extern void ABISELECT(_ZThn1560_N9S19558C17D0Ev,_ZThn944_N9S19558C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C17[] = {
  ABISELECT(1560,944),
  ABISELECT(1360,824),
  ABISELECT(1296,788),
  ABISELECT(1168,712),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN9S19558C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C17D0Ev,
  ABISELECT(1152,704),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19558C17D1Ev,_ZThn8_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S19558C17D0Ev,_ZThn8_N9S19558C17D0Ev),
  ABISELECT(1336,816),
  ABISELECT(1072,660),
  ABISELECT(1136,696),
  ABISELECT(944,584),
  ABISELECT(-224,-128),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C17D1Ev,_ZThn128_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn224_N9S19558C17D0Ev,_ZThn128_N9S19558C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19558C143v11Ev,
  ABISELECT(-448,-272),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19558C17D1Ev,_ZThn272_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S19558C17D0Ev,_ZThn272_N9S19558C17D0Ev),
  ABISELECT(592,364),
  ABISELECT(-576,-348),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn576_N9S19558C17D1Ev,_ZThn348_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn576_N9S19558C17D0Ev,_ZThn348_N9S19558C17D0Ev),
  ABISELECT(-1168,-712),
  0,
  0,
  ABISELECT(-1168,-712),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C17D1Ev,_ZTv0_n20_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C17D0Ev,_ZTv0_n20_N9S19558C17D0Ev),
  0,
  0,
  ABISELECT(-1296,-788),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  ABISELECT(-1360,-824),
  0,
  0,
  ABISELECT(-192,-112),
  ABISELECT(-1360,-824),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C17D1Ev,_ZTv0_n24_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C17D0Ev,_ZTv0_n24_N9S19558C17D0Ev),
  ABISELECT(-1560,-944),
  ABISELECT(-392,-232),
  ABISELECT(-1560,-944),
  (VTBL_ENTRY)&(_ZTI9S19558C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C17D1Ev,_ZTv0_n16_N9S19558C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C17D0Ev,_ZTv0_n16_N9S19558C17D0Ev),
};
extern VTBL_ENTRY _ZTV9S19558C17[];
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__A__9S19558C17[] = {
  ABISELECT(1168,712),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZThn1168_N8S19558C4D1Ev,_ZThn712_N8S19558C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
extern void ABISELECT(_ZThn1168_N8S19558C4D0Ev,_ZThn712_N8S19558C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__A__9S19558C17[] = {
  ABISELECT(-1168,-712),
  0,
  0,
  ABISELECT(-1168,-712),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C17[] = {
  ABISELECT(1152,704),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn1152_N8S19558C9D1Ev,_ZThn704_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn1152_N8S19558C9D0Ev,_ZThn704_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A__9S19558C17[] = {
  ABISELECT(-1152,-704),
  0,
  0,
  ABISELECT(-1152,-704),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C14D1Ev();
extern void _ZN9S19558C14D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
extern void _ZN9S19558C143v11Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C14__9S19558C17[] = {
  ABISELECT(1336,816),
  ABISELECT(1072,660),
  ABISELECT(1136,696),
  ABISELECT(944,584),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C14D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
  (VTBL_ENTRY)&_ZN9S19558C143v11Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C15D1Ev();
extern void _ZN9S19558C15D0Ev();
extern void _ZN8S19558C82v4Ev();
extern void _ZN9S19558C153v10Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(1336,816),
  ABISELECT(1072,660),
  ABISELECT(1136,696),
  ABISELECT(944,584),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C15D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  (VTBL_ENTRY)&_ZN9S19558C153v10Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C89S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(1072,660),
  ABISELECT(1136,696),
  ABISELECT(944,584),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C89S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(944,584),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C89S19558C159S19558C14__A2__9S19558C17[] = {
  ABISELECT(944,584),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn944_N8S19558C9D1Ev,_ZThn584_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn944_N8S19558C9D0Ev,_ZThn584_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C159S19558C14__A2__9S19558C17[] = {
  ABISELECT(-944,-584),
  0,
  0,
  ABISELECT(-944,-584),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn944_N9S19558C10D1Ev,_ZThn584_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn944_N9S19558C10D0Ev,_ZThn584_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C89S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-944,-584),
  0,
  0,
  ABISELECT(-944,-584),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn944_N8S19558C8D1Ev,_ZThn584_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn944_N8S19558C8D0Ev,_ZThn584_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C89S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-944,-584),
  0,
  0,
  ABISELECT(-944,-584),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn1136_N8S19558C8D1Ev,_ZThn696_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn1136_N8S19558C8D0Ev,_ZThn696_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C89S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-1136,-696),
  0,
  0,
  ABISELECT(-192,-112),
  ABISELECT(-1136,-696),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C89S19558C159S19558C14__9S19558C17[] = {
  0,
  0,
  ABISELECT(-1072,-660),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C159S19558C14__A3__9S19558C17[] = {
  ABISELECT(592,364),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn592_N8S19558C9D1Ev,_ZThn364_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn592_N8S19558C9D0Ev,_ZThn364_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C159S19558C14__A3__9S19558C17[] = {
  ABISELECT(-592,-364),
  0,
  0,
  ABISELECT(-592,-364),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__9S19558C159S19558C14__9S19558C17[] = {
  0,
  0,
  ABISELECT(-1072,-660),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn944_N9S19558C15D1Ev,_ZThn584_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn944_N9S19558C15D0Ev,_ZThn584_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-944,-584),
  0,
  0,
  ABISELECT(-944,-584),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn1136_N9S19558C15D1Ev,_ZThn696_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn1136_N9S19558C15D0Ev,_ZThn696_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-1136,-696),
  0,
  0,
  ABISELECT(-192,-112),
  ABISELECT(-1136,-696),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn1336_N9S19558C15D1Ev,_ZThn816_N9S19558C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev)();
extern void ABISELECT(_ZThn1336_N9S19558C15D0Ev,_ZThn816_N9S19558C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(-1336,-816),
  ABISELECT(-392,-232),
  ABISELECT(-1336,-816),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A__9S19558C159S19558C14__9S19558C17[] = {
  ABISELECT(592,364),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C15[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D1Ev,_ZThn220_N9S19558C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C15D0Ev,_ZThn220_N9S19558C15D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__9S19558C14__9S19558C17[] = {
  0,
  0,
  ABISELECT(-1072,-660),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn944_N9S19558C14D1Ev,_ZThn584_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn944_N9S19558C14D0Ev,_ZThn584_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C14__9S19558C17[] = {
  ABISELECT(-944,-584),
  0,
  0,
  ABISELECT(-944,-584),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn1136_N9S19558C14D1Ev,_ZThn696_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn1136_N9S19558C14D0Ev,_ZThn696_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C14__9S19558C17[] = {
  ABISELECT(-1136,-696),
  0,
  0,
  ABISELECT(-192,-112),
  ABISELECT(-1136,-696),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn1336_N9S19558C14D1Ev,_ZThn816_N9S19558C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev)();
extern void ABISELECT(_ZThn1336_N9S19558C14D0Ev,_ZThn816_N9S19558C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C4__9S19558C14__9S19558C17[] = {
  ABISELECT(-1336,-816),
  ABISELECT(-392,-232),
  ABISELECT(-1336,-816),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C15__A2__9S19558C14__9S19558C17[] = {
  ABISELECT(592,364),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C14[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D1Ev,_ZThn220_N9S19558C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn352_N9S19558C14D0Ev,_ZThn220_N9S19558C14D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A1__9S19558C17[] = {
  ABISELECT(-192,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A1__9S19558C17[] = {
  ABISELECT(192,112),
  0,
  0,
  ABISELECT(192,112),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C4D1Ev();
extern void _ZN8S19558C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C4__A1__9S19558C17[] = {
  ABISELECT(-392,-232),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C4D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C4__A1__9S19558C17[] = {
  ABISELECT(392,232),
  0,
  0,
  ABISELECT(392,232),
  (VTBL_ENTRY)&(_ZTI8S19558C4[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev),
};
static  VTT_ENTRY vtt_S19558C17[] = {
  {&(_ZTV9S19558C17[6]),  6,72},
  {&(_tg__ZTV8S19558C4__A__9S19558C17[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__A__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C9__A__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A__9S19558C17[5]),  5,9},
  {&(_tg__ZTV9S19558C14__9S19558C17[6]),  6,13},
  {&(_tg__ZTV9S19558C159S19558C14__9S19558C17[6]),  6,12},
  {&(_tg__ZTV8S19558C89S19558C159S19558C14__9S19558C17[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C89S19558C159S19558C14__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C89S19558C159S19558C14__A2__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C89S19558C159S19558C14__A2__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C89S19558C159S19558C14__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C89S19558C159S19558C14__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C89S19558C159S19558C14__9S19558C17[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C89S19558C159S19558C14__9S19558C17[4]),  4,6},
  {&(_tg__ZTV8S19558C99S19558C159S19558C14__A3__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C159S19558C14__A3__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C6__9S19558C159S19558C14__9S19558C17[4]),  4,6},
  {&(_tg__ZTV8S19558C5__9S19558C159S19558C14__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C159S19558C14__9S19558C17[6]),  6,10},
  {&(_tg__ZTV8S19558C4__9S19558C159S19558C14__9S19558C17[4]),  4,6},
  {&(_tg__ZTV8S19558C9__A__9S19558C159S19558C14__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C6__9S19558C14__9S19558C17[4]),  4,6},
  {&(_tg__ZTV8S19558C5__9S19558C14__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C14__9S19558C17[6]),  6,10},
  {&(_tg__ZTV8S19558C4__9S19558C14__9S19558C17[4]),  4,6},
  {&(_tg__ZTV8S19558C99S19558C15__A2__9S19558C14__9S19558C17[3]),  3,7},
  {&(_ZTV9S19558C17[46]),  46,72},
  {&(_ZTV9S19558C17[11]),  11,72},
  {&(_ZTV9S19558C17[21]),  21,72},
  {&(_ZTV9S19558C17[54]),  54,72},
  {&(_ZTV9S19558C17[62]),  62,72},
  {&(_ZTV9S19558C17[70]),  70,72},
  {&(_ZTV9S19558C17[37]),  37,72},
  {&(_tg__ZTV8S19558C9__A1__9S19558C17[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A1__9S19558C17[5]),  5,9},
  {&(_tg__ZTV8S19558C4__A1__9S19558C17[3]),  3,5},
  {&(_tg__ZTV8S19558C5__8S19558C4__A1__9S19558C17[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C17[];
extern  VTBL_ENTRY _ZTV9S19558C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C17[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D0Ev,_ZTv0_n16_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1336_N9S19558C14D0Ev,_ZThn816_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C14D1Ev,_ZTv0_n16_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1336_N9S19558C14D1Ev,_ZThn816_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D0Ev,_ZTv0_n24_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N9S19558C14D0Ev,_ZThn696_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C14D1Ev,_ZTv0_n24_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N9S19558C14D1Ev,_ZThn696_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D0Ev,_ZTv0_n20_N9S19558C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C14D0Ev,_ZThn584_N9S19558C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C14D1Ev,_ZTv0_n20_N9S19558C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C14D1Ev,_ZThn584_N9S19558C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D0Ev,_ZTv0_n16_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1336_N9S19558C15D0Ev,_ZThn816_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C15D1Ev,_ZTv0_n16_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1336_N9S19558C15D1Ev,_ZThn816_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D0Ev,_ZTv0_n24_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N9S19558C15D0Ev,_ZThn696_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C15D1Ev,_ZTv0_n24_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N9S19558C15D1Ev,_ZThn696_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D0Ev,_ZTv0_n20_N9S19558C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C15D0Ev,_ZThn584_N9S19558C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C15D1Ev,_ZTv0_n20_N9S19558C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C15D1Ev,_ZThn584_N9S19558C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N8S19558C8D0Ev,_ZThn696_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1136_N8S19558C8D1Ev,_ZThn696_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S19558C8D0Ev,_ZThn584_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S19558C8D1Ev,_ZThn584_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C10D0Ev,_ZThn584_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn944_N9S19558C10D1Ev,_ZThn584_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn592_N8S19558C9D0Ev,_ZThn364_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S19558C9D0Ev,_ZThn584_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S19558C9D0Ev,_ZThn704_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn592_N8S19558C9D1Ev,_ZThn364_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn944_N8S19558C9D1Ev,_ZThn584_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S19558C9D1Ev,_ZThn704_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D0Ev,_ZTv0_n20_N8S19558C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N8S19558C4D0Ev,_ZThn712_N8S19558C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C4D1Ev,_ZTv0_n20_N8S19558C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N8S19558C4D1Ev,_ZThn712_N8S19558C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C17D0Ev,_ZTv0_n16_N9S19558C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1560_N9S19558C17D0Ev,_ZThn944_N9S19558C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19558C17D1Ev,_ZTv0_n16_N9S19558C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1560_N9S19558C17D1Ev,_ZThn944_N9S19558C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C17D0Ev,_ZTv0_n24_N9S19558C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1360_N9S19558C17D0Ev,_ZThn824_N9S19558C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C17D1Ev,_ZTv0_n24_N9S19558C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1360_N9S19558C17D1Ev,_ZThn824_N9S19558C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C17D0Ev,_ZTv0_n20_N9S19558C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19558C17D0Ev,_ZThn712_N9S19558C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C17D1Ev,_ZTv0_n20_N9S19558C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19558C17D1Ev,_ZThn712_N9S19558C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C17 = {  "S19558C17", // class name
  bases_S19558C17, 19,
  &(vtc_S19558C17[0]), // expected_vtbl_contents
  &(vtt_S19558C17[0]), // expected_vtt_contents
  ABISELECT(1584,952), // object size
  NSPAIRA(_ZTI9S19558C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19558C17),72, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C17),38, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C19  : S19558C10 , virtual S19558C9 {
  int s19558c19f0;
  int s19558c19f1;
  virtual  ~S19558C19(); // _ZN9S19558C19D2Ev
  S19558C19(); // tgen
};
//SIG(-1 S19558C19) C1{ BC2{ BC3{ VBC4{ BC5{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} BC5 vd Fi FC4 Fi} vd Fi Fp Fi[2]} VBC3 vd Fi[2]}


 S19558C19 ::~S19558C19(){ note_dtor("S19558C19", this);}
S19558C19 ::S19558C19(){ note_ctor("S19558C19", this);} // tgen

static void Test_S19558C19()
{
  extern Class_Descriptor cd_S19558C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(36,86)];
    init_test(&cd_S19558C19, buf);
    S19558C19 *dp, &lv = *(dp=new (buf) S19558C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(560,340), "sizeof(S19558C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C19)");
    check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(224,144), "S19558C19");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*), ABISELECT(224,144), "S19558C19");
    /*is_ambiguous_... S19558C19::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(224,144), "S19558C19");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*), 0, "S19558C19");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*), 0, "S19558C19");
    check_base_class_offset(lv, (S19558C10*), 0, "S19558C19");
    /*is_ambiguous_... S19558C19::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(352,220), "S19558C19");
    /*is_ambiguous_... S19558C19::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(352,220), "S19558C19");
    check_field_offset(lv, s19558c19f0, ABISELECT(216,136), "S19558C19.s19558c19f0");
    check_field_offset(lv, s19558c19f1, ABISELECT(220,140), "S19558C19.s19558c19f1");
    test_class_info(&lv, &cd_S19558C19);
    dp->~S19558C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C19(Test_S19558C19, "S19558C19", ABISELECT(560,340));

#else // __cplusplus

extern void _ZN9S19558C19C1Ev();
extern void _ZN9S19558C19D2Ev();
Name_Map name_map_S19558C19[] = {
  NSPAIR(_ZN9S19558C19C1Ev),
  NSPAIR(_ZN9S19558C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
static Base_Class bases_S19558C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    ABISELECT(224,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(224,144), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19558C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(352,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(352,220), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C19[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C19D1Ev();
extern void _ZN9S19558C19D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C19D1Ev,_ZThn144_N9S19558C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C19D0Ev,_ZThn144_N9S19558C19D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev)();
extern void ABISELECT(_ZThn352_N9S19558C19D1Ev,_ZThn220_N9S19558C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev)();
extern void ABISELECT(_ZThn352_N9S19558C19D0Ev,_ZThn220_N9S19558C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19558C19[] = {
  ABISELECT(352,220),
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C19D0Ev,
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev),
  ABISELECT(-352,-220),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev),
};
extern VTBL_ENTRY _ZTV9S19558C19[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C10__9S19558C19[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C10__9S19558C19[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C10__9S19558C19[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C10__9S19558C19[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__A1__9S19558C19[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__A1__9S19558C19[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C19[] = {
  {&(_ZTV9S19558C19[4]),  4,27},
  {&(_tg__ZTV9S19558C10__9S19558C19[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C10__9S19558C19[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C10__9S19558C19[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C10__9S19558C19[5]),  5,9},
  {&(_ZTV9S19558C19[13]),  13,27},
  {&(_ZTV9S19558C19[23]),  23,27},
  {&(_tg__ZTV8S19558C9__A1__9S19558C19[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__A1__9S19558C19[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C19[];
extern  VTBL_ENTRY _ZTV9S19558C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C19[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N9S19558C19D0Ev,_ZThn220_N9S19558C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N9S19558C19D1Ev,_ZThn220_N9S19558C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C19D0Ev,_ZThn144_N9S19558C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C19D1Ev,_ZThn144_N9S19558C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C19 = {  "S19558C19", // class name
  bases_S19558C19, 7,
  &(vtc_S19558C19[0]), // expected_vtbl_contents
  &(vtt_S19558C19[0]), // expected_vtt_contents
  ABISELECT(560,340), // object size
  NSPAIRA(_ZTI9S19558C19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19558C19),27, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C19),9, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19558C20  {
  int s19558c20f0;
  long double s19558c20f1;
  int s19558c20f2:32;
  void *s19558c20f3;
  void *s19558c20f4;
  void  mf19558c20(); // _ZN9S19558C2010mf19558c20Ev
};
//SIG(1 S19558C20) U1{ m Fi FD Fi:32 Fp Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19558C18  : S19558C5 , virtual S19558C13 , S19558C19 {
  int s19558c18f0;
  int s19558c18f1[9];
  ::S19558C20 s19558c18f2;
  ~S19558C18(); // tgen
  S19558C18(); // tgen
};
//SIG(-1 S19558C18) C1{ BC2{ BC3{ v1 v2 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} VBC4{ VBC5{ VBC2 VBC6{ VBC2 BC3 vd Fi FC2 Fi} BC7{ BC6 vd Fi Fp Fi[2]} VBC3 vd v3 FU8{ m Fi[2] FL}} BC6 vd v4 v5 Fc FC6 Fc} BC9{ BC7 VBC6 vd Fi Fi} Fi Fi[9] FU10{ m Fi FD Fi:32 Fp Fp}}


S19558C18 ::~S19558C18(){ note_dtor("S19558C18", this);} // tgen
S19558C18 ::S19558C18(){ note_ctor("S19558C18", this);} // tgen

static void Test_S19558C18()
{
  extern Class_Descriptor cd_S19558C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(101,244)];
    init_test(&cd_S19558C18, buf);
    S19558C18 *dp, &lv = *(dp=new (buf) S19558C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1600,972), "sizeof(S19558C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C18)");
    /*is_ambiguous_... S19558C18::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), 0, "S19558C18");
    /*is_ambiguous_... S19558C18::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*), 0, "S19558C18");
    /*is_ambiguous_... S19558C18::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(1200,740), "S19558C18");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(1200,740), "S19558C18");
    /*is_ambiguous_... S19558C18::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(1200,740), "S19558C18");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(1200,740), "S19558C18");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C13*), ABISELECT(1200,740), "S19558C18");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C19*), ABISELECT(1200,740), "S19558C18");
    /*is_ambiguous_... S19558C18::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(1328,816), "S19558C18");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(1328,816), "S19558C18");
    /*is_ambiguous_... S19558C19::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C19*), ABISELECT(1328,816), "S19558C18");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(976,596), "S19558C18");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(976,596), "S19558C18");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*), ABISELECT(976,596), "S19558C18");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(1536,936), "S19558C18");
    check_base_class_offset(lv, (S19558C8*)(S19558C13*), ABISELECT(976,596), "S19558C18");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C13*), ABISELECT(416,272), "S19558C18");
    /*is_ambiguous_... S19558C13::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C13*), ABISELECT(416,272), "S19558C18");
    check_base_class_offset(lv, (S19558C13*), ABISELECT(416,272), "S19558C18");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C19*), ABISELECT(128,76), "S19558C18");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C19*), ABISELECT(128,76), "S19558C18");
    check_base_class_offset(lv, (S19558C10*)(S19558C19*), ABISELECT(128,76), "S19558C18");
    check_base_class_offset(lv, (S19558C19*), ABISELECT(128,76), "S19558C18");
    check_field_offset(lv, s19558c18f0, ABISELECT(352,220), "S19558C18.s19558c18f0");
    check_field_offset(lv, s19558c18f1, ABISELECT(356,224), "S19558C18.s19558c18f1");
    check_field_offset(lv, s19558c18f2, ABISELECT(400,260), "S19558C18.s19558c18f2");
    test_class_info(&lv, &cd_S19558C18);
    dp->~S19558C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C18(Test_S19558C18, "S19558C18", ABISELECT(1600,972));

#else // __cplusplus

extern void _ZN9S19558C18C1Ev();
extern void _ZN9S19558C18D1Ev();
Name_Map name_map_S19558C18[] = {
  NSPAIR(_ZN9S19558C18C1Ev),
  NSPAIR(_ZN9S19558C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C5;
extern VTBL_ENTRY _ZTI8S19558C5[];
extern  VTBL_ENTRY _ZTV8S19558C5[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C8;
extern VTBL_ENTRY _ZTI8S19558C8[];
extern  VTBL_ENTRY _ZTV8S19558C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C8[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C13;
extern VTBL_ENTRY _ZTI9S19558C13[];
extern  VTBL_ENTRY _ZTV9S19558C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C13[];
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Descriptor cd_S19558C9;
extern VTBL_ENTRY _ZTI8S19558C9[];
extern  VTBL_ENTRY _ZTV8S19558C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19558C9[];
extern Class_Descriptor cd_S19558C10;
extern VTBL_ENTRY _ZTI9S19558C10[];
extern  VTBL_ENTRY _ZTV9S19558C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C10[];
extern Class_Descriptor cd_S19558C19;
extern VTBL_ENTRY _ZTI9S19558C19[];
extern  VTBL_ENTRY _ZTV9S19558C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C19[];
static Base_Class bases_S19558C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19558C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19558C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19558C6,    ABISELECT(1200,740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19558C5,    ABISELECT(1200,740), //bcp->offset
    50, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(1328,816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(1328,816), //bcp->offset
    59, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(976,596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(976,596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(976,596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19558C6,    ABISELECT(1536,936), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19558C8,    ABISELECT(976,596), //bcp->offset
    36, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19558C6,    ABISELECT(416,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(416,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19558C13,    ABISELECT(416,272), //bcp->offset
    19, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19558C6,    ABISELECT(128,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19558C9,    ABISELECT(128,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19558C10,    ABISELECT(128,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19558C19,    ABISELECT(128,76), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19558C18[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C18D1Ev();
extern void _ZN9S19558C18D0Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZThn128_N9S19558C18D1Ev,_ZThn76_N9S19558C18D1Ev)();
extern void ABISELECT(_ZThn128_N9S19558C18D0Ev,_ZThn76_N9S19558C18D0Ev)();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n72_N9S19558C18D1Ev,_ZTv0_n36_N9S19558C18D1Ev)();
extern void ABISELECT(_ZThn416_N9S19558C18D1Ev,_ZThn272_N9S19558C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19558C18D0Ev,_ZTv0_n36_N9S19558C18D0Ev)();
extern void ABISELECT(_ZThn416_N9S19558C18D0Ev,_ZThn272_N9S19558C18D0Ev)() __attribute__((weak));
extern void _ZN9S19558C132v8Ev();
extern void _ZN9S19558C132v9Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C18D1Ev,_ZTv0_n32_N9S19558C18D1Ev)();
extern void ABISELECT(_ZThn976_N9S19558C18D1Ev,_ZThn596_N9S19558C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C18D0Ev,_ZTv0_n32_N9S19558C18D0Ev)();
extern void ABISELECT(_ZThn976_N9S19558C18D0Ev,_ZThn596_N9S19558C18D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C18D1Ev,_ZTv0_n20_N9S19558C18D1Ev)();
extern void ABISELECT(_ZThn1200_N9S19558C18D1Ev,_ZThn740_N9S19558C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C18D0Ev,_ZTv0_n20_N9S19558C18D0Ev)();
extern void ABISELECT(_ZThn1200_N9S19558C18D0Ev,_ZThn740_N9S19558C18D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C18D1Ev,_ZTv0_n24_N9S19558C18D1Ev)();
extern void ABISELECT(_ZThn1328_N9S19558C18D1Ev,_ZThn816_N9S19558C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C18D0Ev,_ZTv0_n24_N9S19558C18D0Ev)();
extern void ABISELECT(_ZThn1328_N9S19558C18D0Ev,_ZThn816_N9S19558C18D0Ev)() __attribute__((weak));
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY vtc_S19558C18[] = {
  ABISELECT(1536,936),
  ABISELECT(1328,816),
  ABISELECT(1200,740),
  ABISELECT(976,596),
  ABISELECT(416,272),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C18D0Ev,
  ABISELECT(1200,740),
  ABISELECT(1072,664),
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N9S19558C18D1Ev,_ZThn76_N9S19558C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N9S19558C18D0Ev,_ZThn76_N9S19558C18D0Ev),
  0,
  0,
  ABISELECT(-416,-272),
  0,
  0,
  ABISELECT(1120,664),
  ABISELECT(912,544),
  ABISELECT(560,324),
  ABISELECT(784,468),
  ABISELECT(-416,-272),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19558C18D1Ev,_ZTv0_n36_N9S19558C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19558C18D0Ev,_ZTv0_n36_N9S19558C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19558C132v8Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v9Ev,
  0,
  ABISELECT(-976,-596),
  0,
  0,
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  ABISELECT(-976,-596),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C18D1Ev,_ZTv0_n32_N9S19558C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C18D0Ev,_ZTv0_n32_N9S19558C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
  ABISELECT(-1200,-740),
  0,
  0,
  ABISELECT(-1200,-740),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C18D1Ev,_ZTv0_n20_N9S19558C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C18D0Ev,_ZTv0_n20_N9S19558C18D0Ev),
  ABISELECT(-1328,-816),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-1328,-816),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C18D1Ev,_ZTv0_n24_N9S19558C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C18D0Ev,_ZTv0_n24_N9S19558C18D0Ev),
  0,
  0,
  ABISELECT(-1536,-936),
  (VTBL_ENTRY)&(_ZTI9S19558C18[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern VTBL_ENTRY _ZTV9S19558C18[];
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C19D1Ev();
extern void _ZN9S19558C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C19__9S19558C18[] = {
  ABISELECT(1200,740),
  ABISELECT(1072,664),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C19D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C109S19558C19__A1__9S19558C18[] = {
  ABISELECT(1072,664),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C109S19558C19__A3__9S19558C18[] = {
  ABISELECT(1072,664),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn1072_N8S19558C9D1Ev,_ZThn664_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn1072_N8S19558C9D0Ev,_ZThn664_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C109S19558C19__A3__9S19558C18[] = {
  ABISELECT(-1072,-664),
  0,
  0,
  ABISELECT(-1072,-664),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn1072_N9S19558C10D1Ev,_ZThn664_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn1072_N9S19558C10D0Ev,_ZThn664_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C109S19558C19__A1__9S19558C18[] = {
  ABISELECT(-1072,-664),
  0,
  0,
  ABISELECT(-1072,-664),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev)();
extern void ABISELECT(_ZThn1072_N9S19558C19D1Ev,_ZThn664_N9S19558C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev)();
extern void ABISELECT(_ZThn1072_N9S19558C19D0Ev,_ZThn664_N9S19558C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C19__9S19558C18[] = {
  ABISELECT(-1072,-664),
  0,
  0,
  ABISELECT(-1072,-664),
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev)();
extern void ABISELECT(_ZThn1200_N9S19558C19D1Ev,_ZThn740_N9S19558C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev)();
extern void ABISELECT(_ZThn1200_N9S19558C19D0Ev,_ZThn740_N9S19558C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__A1__9S19558C19__9S19558C18[] = {
  ABISELECT(-1200,-740),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-1200,-740),
  (VTBL_ENTRY)&(_ZTI9S19558C19[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C13D1Ev();
extern void _ZN9S19558C13D0Ev();
extern void _ZN9S19558C132v8Ev();
extern void _ZN9S19558C132v9Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C13__9S19558C18[] = {
  ABISELECT(1120,664),
  ABISELECT(912,544),
  ABISELECT(560,324),
  ABISELECT(784,468),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v8Ev,
  (VTBL_ENTRY)&_ZN9S19558C132v9Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C13__A2__9S19558C18[] = {
  ABISELECT(784,468),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn784_N8S19558C9D1Ev,_ZThn468_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn784_N8S19558C9D0Ev,_ZThn468_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C13__A2__9S19558C18[] = {
  ABISELECT(-784,-468),
  0,
  0,
  ABISELECT(-784,-468),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn560_N9S19558C13D1Ev,_ZThn324_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn560_N9S19558C13D0Ev,_ZThn324_N9S19558C13D0Ev)() __attribute__((weak));
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__9S19558C13__9S19558C18[] = {
  0,
  ABISELECT(-560,-324),
  0,
  0,
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  ABISELECT(-560,-324),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn784_N9S19558C13D1Ev,_ZThn468_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn784_N9S19558C13D0Ev,_ZThn468_N9S19558C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C13__9S19558C18[] = {
  ABISELECT(-784,-468),
  0,
  0,
  ABISELECT(-784,-468),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev)();
extern void ABISELECT(_ZThn912_N9S19558C13D1Ev,_ZThn544_N9S19558C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev)();
extern void ABISELECT(_ZThn912_N9S19558C13D0Ev,_ZThn544_N9S19558C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C13__9S19558C18[] = {
  ABISELECT(-912,-544),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-912,-544),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__9S19558C13__9S19558C18[] = {
  0,
  0,
  ABISELECT(-1120,-664),
  (VTBL_ENTRY)&(_ZTI9S19558C13[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C8D1Ev();
extern void _ZN8S19558C8D0Ev();
extern void _ZN8S19558C82v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C8__9S19558C18[] = {
  ABISELECT(560,340),
  ABISELECT(352,220),
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C8D0Ev,
  (VTBL_ENTRY)&_ZN8S19558C82v4Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN9S19558C10D1Ev();
extern void _ZN9S19558C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19558C108S19558C8__9S19558C18[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19558C10D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C18[] = {
  ABISELECT(224,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C18[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev)();
extern void ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C18[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI9S19558C10[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C8__9S19558C18[] = {
  ABISELECT(-224,-144),
  0,
  0,
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev)();
extern void ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19558C9__8S19558C8__9S19558C18[] = {
  ABISELECT(-352,-220),
  0,
  0,
  ABISELECT(-128,-76),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev),
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C6__A3__8S19558C8__9S19558C18[] = {
  0,
  0,
  ABISELECT(-560,-340),
  (VTBL_ENTRY)&(_ZTI8S19558C8[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void _ZN8S19558C9D1Ev();
extern void _ZN8S19558C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19558C9__9S19558C18[] = {
  ABISELECT(-128,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19558C9D0Ev,
};
extern void _ZN8S19558C62v2Ev();
extern void _ZN8S19558C62v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S19558C5__8S19558C9__9S19558C18[] = {
  ABISELECT(128,76),
  0,
  0,
  ABISELECT(128,76),
  (VTBL_ENTRY)&(_ZTI8S19558C9[0]),
  (VTBL_ENTRY)&_ZN8S19558C62v2Ev,
  (VTBL_ENTRY)&_ZN8S19558C62v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev),
};
static  VTT_ENTRY vtt_S19558C18[] = {
  {&(_ZTV9S19558C18[7]),  7,75},
  {&(_tg__ZTV9S19558C19__9S19558C18[4]),  4,8},
  {&(_tg__ZTV9S19558C109S19558C19__A1__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C109S19558C19__A3__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C109S19558C19__A3__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C109S19558C19__A1__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C19__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C9__A1__9S19558C19__9S19558C18[6]),  6,10},
  {&(_ZTV9S19558C18[30]),  30,75},
  {&(_ZTV9S19558C18[45]),  45,75},
  {&(_ZTV9S19558C18[55]),  55,75},
  {&(_ZTV9S19558C18[65]),  65,75},
  {&(_ZTV9S19558C18[73]),  73,75},
  {&(_ZTV9S19558C18[15]),  15,75},
  {&(_tg__ZTV9S19558C13__9S19558C18[6]),  6,12},
  {&(_tg__ZTV8S19558C99S19558C13__A2__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C13__A2__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C8__9S19558C13__9S19558C18[9]),  9,14},
  {&(_tg__ZTV8S19558C5__9S19558C13__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C9__9S19558C13__9S19558C18[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__9S19558C13__9S19558C18[4]),  4,6},
  {&(_tg__ZTV8S19558C8__9S19558C18[5]),  5,10},
  {&(_tg__ZTV9S19558C108S19558C8__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C99S19558C108S19558C8__A1__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C99S19558C108S19558C8__A1__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C5__9S19558C108S19558C8__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C5__8S19558C8__9S19558C18[5]),  5,9},
  {&(_tg__ZTV8S19558C9__8S19558C8__9S19558C18[6]),  6,10},
  {&(_tg__ZTV8S19558C6__A3__8S19558C8__9S19558C18[4]),  4,6},
  {&(_tg__ZTV8S19558C9__9S19558C18[3]),  3,7},
  {&(_tg__ZTV8S19558C5__8S19558C9__9S19558C18[5]),  5,9},
};
extern VTBL_ENTRY _ZTI9S19558C18[];
extern  VTBL_ENTRY _ZTV9S19558C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19558C18[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D0Ev,_ZTv0_n24_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D0Ev,_ZThn220_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19558C8D1Ev,_ZTv0_n24_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N8S19558C8D1Ev,_ZThn220_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D0Ev,_ZTv0_n20_N8S19558C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D0Ev,_ZThn144_N8S19558C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C8D1Ev,_ZTv0_n20_N8S19558C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C8D1Ev,_ZThn144_N8S19558C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D0Ev,_ZTv0_n24_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn912_N9S19558C13D0Ev,_ZThn544_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C13D1Ev,_ZTv0_n24_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn912_N9S19558C13D1Ev,_ZThn544_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D0Ev,_ZTv0_n20_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C13D0Ev,_ZThn468_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C13D1Ev,_ZTv0_n20_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn784_N9S19558C13D1Ev,_ZThn468_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D0Ev,_ZTv0_n32_N9S19558C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19558C13D0Ev,_ZThn324_N9S19558C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C13D1Ev,_ZTv0_n32_N9S19558C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19558C13D1Ev,_ZThn324_N9S19558C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C19D0Ev,_ZTv0_n24_N9S19558C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N9S19558C19D0Ev,_ZThn740_N9S19558C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C19D1Ev,_ZTv0_n24_N9S19558C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N9S19558C19D1Ev,_ZThn740_N9S19558C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C19D0Ev,_ZTv0_n20_N9S19558C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19558C19D0Ev,_ZThn664_N9S19558C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C19D1Ev,_ZTv0_n20_N9S19558C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19558C19D1Ev,_ZThn664_N9S19558C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D0Ev,_ZTv0_n20_N9S19558C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D0Ev,_ZThn144_N9S19558C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19558C10D0Ev,_ZThn664_N9S19558C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C10D1Ev,_ZTv0_n20_N9S19558C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N9S19558C10D1Ev,_ZThn144_N9S19558C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19558C10D1Ev,_ZThn664_N9S19558C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D0Ev,_ZTv0_n20_N8S19558C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D0Ev,_ZThn144_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C9D0Ev,_ZThn468_N8S19558C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N8S19558C9D0Ev,_ZThn664_N8S19558C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19558C9D1Ev,_ZTv0_n20_N8S19558C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19558C9D1Ev,_ZThn144_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn784_N8S19558C9D1Ev,_ZThn468_N8S19558C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N8S19558C9D1Ev,_ZThn664_N8S19558C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C18D0Ev,_ZTv0_n24_N9S19558C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1328_N9S19558C18D0Ev,_ZThn816_N9S19558C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19558C18D1Ev,_ZTv0_n24_N9S19558C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1328_N9S19558C18D1Ev,_ZThn816_N9S19558C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C18D0Ev,_ZTv0_n20_N9S19558C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N9S19558C18D0Ev,_ZThn740_N9S19558C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19558C18D1Ev,_ZTv0_n20_N9S19558C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N9S19558C18D1Ev,_ZThn740_N9S19558C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C18D0Ev,_ZTv0_n32_N9S19558C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn976_N9S19558C18D0Ev,_ZThn596_N9S19558C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S19558C18D1Ev,_ZTv0_n32_N9S19558C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn976_N9S19558C18D1Ev,_ZThn596_N9S19558C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19558C18D0Ev,_ZTv0_n36_N9S19558C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn416_N9S19558C18D0Ev,_ZThn272_N9S19558C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19558C18D1Ev,_ZTv0_n36_N9S19558C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn416_N9S19558C18D1Ev,_ZThn272_N9S19558C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19558C18 = {  "S19558C18", // class name
  bases_S19558C18, 18,
  &(vtc_S19558C18[0]), // expected_vtbl_contents
  &(vtt_S19558C18[0]), // expected_vtt_contents
  ABISELECT(1600,972), // object size
  NSPAIRA(_ZTI9S19558C18),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19558C18),75, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19558C18),31, //virtual table table var
  18, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19558C16  : virtual S19558C9 , virtual S19558C17 , S19558C13 , S19558C18 , virtual S19558C7 {
  int s19558c16f0:4;
  int s19558c16f1:12;
  int s19558c16f2;
  char s19558c16f3;
  virtual  ~S19558C16(); // _ZN9S19558C16D2Ev
  virtual void  v13(); // _ZN9S19558C163v13Ev
  S19558C16(); // tgen
};
//SIG(-1 S19558C16) C1{ VBC2{ VBC3{ BC4{ v2 v3 Fp Fi FD Fi[2] Fc} vd Fp FL Fi Fc:8 Fc Fp Fs FD} BC4 vd Fi FC3 Fi} VBC5{ BC6{ VBC3 Fi} BC2 BC7{ BC8{ VBC4 BC9{ VBC3 VBC2 BC10{ BC2 vd Fi Fp Fi[2]} VBC4 vd v4 FU11{ m Fi[2] FL}} BC3 VBC6 BC2 vd v5 Fi Fi Fi} vd v6 Fi Fl Fi FL} FC10} BC12{ VBC9 BC2 vd v7 v8 Fc FC2 Fc} BC13{ BC3 VBC12 BC14{ BC10 VBC2 vd Fi Fi} Fi Fi[9] FU15{ m Fi FD Fi:32 Fp Fp}} VBC16{ BC9 vd v9 FD[3] Fi Fc FC2 Fi:9 Fc[5] Fi Fp[9]} vd v1 Fi:4 Fi:12 Fi Fc}


 S19558C16 ::~S19558C16(){ note_dtor("S19558C16", this);}
void  S19558C16 ::v13(){vfunc_called(this, "_ZN9S19558C163v13Ev");}
S19558C16 ::S19558C16(){ note_ctor("S19558C16", this);} // tgen

static void Test_S19558C16()
{
  extern Class_Descriptor cd_S19558C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(256,616)];
    init_test(&cd_S19558C16, buf);
    S19558C16 *dp, &lv = *(dp=new (buf) S19558C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4080,2460), "sizeof(S19558C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19558C16)");
    /*is_ambiguous_... S19558C16::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C17::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C4*)(S19558C17*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C17*), ABISELECT(1200,728), "S19558C16");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1200,728), "S19558C16");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C4*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C8*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C13*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C13*), ABISELECT(1200,728), "S19558C16");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C19*)(S19558C18*), ABISELECT(1200,728), "S19558C16");
    check_base_class_offset(lv, (S19558C5*)(S19558C8*)(S19558C7*), ABISELECT(1200,728), "S19558C16");
    check_base_class_offset(lv, (S19558C5*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(1200,728), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C19::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C19*)(S19558C18*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C8::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C8*)(S19558C7*), ABISELECT(992,608), "S19558C16");
    /*is_ambiguous_... S19558C17::S19558C4 */ AMB_check_base_class_offset(lv, (S19558C4*)(S19558C17*), ABISELECT(1328,804), "S19558C16");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C17*), ABISELECT(1344,812), "S19558C16");
    /*is_ambiguous_... S19558C17::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C17*), ABISELECT(1344,812), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(2496,1516), "S19558C16");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(2496,1516), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*), ABISELECT(2496,1516), "S19558C16");
    /*is_ambiguous_... S19558C8::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C8*)(S19558C7*), ABISELECT(2496,1516), "S19558C16");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    check_base_class_offset(lv, (S19558C8*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1776,1076), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1776,1076), "S19558C16");
    check_base_class_offset(lv, (S19558C4*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(2560,1552), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1904,1152), "S19558C16");
    /*is_ambiguous_... S19558C15::S19558C9 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1904,1152), "S19558C16");
    check_base_class_offset(lv, (S19558C15*)(S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    check_base_class_offset(lv, (S19558C14*)(S19558C17*), ABISELECT(1552,932), "S19558C16");
    check_base_class_offset(lv, (S19558C17*), ABISELECT(1328,804), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(2576,1560), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*), ABISELECT(2576,1560), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C8 */ AMB_check_base_class_offset(lv, (S19558C10*)(S19558C8*), ABISELECT(2576,1560), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C8*)(S19558C13*), ABISELECT(2576,1560), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C8*)(S19558C13*), ABISELECT(2576,1560), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C13*), 0, "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C13*), 0, "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C13*), 0, "S19558C16");
    /*is_ambiguous_... S19558C18::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C5*)(S19558C18*), ABISELECT(560,324), "S19558C16");
    /*is_ambiguous_... S19558C18::S19558C5 */ AMB_check_base_class_offset(lv, (S19558C5*)(S19558C18*), ABISELECT(560,324), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C13*), ABISELECT(2800,1704), "S19558C16");
    /*is_ambiguous_... S19558C16::S19558C13 */ AMB_check_base_class_offset(lv, (S19558C9*)(S19558C13*), ABISELECT(2800,1704), "S19558C16");
    check_base_class_offset(lv, (S19558C13*)(S19558C18*), ABISELECT(2800,1704), "S19558C16");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C19*)(S19558C18*), ABISELECT(688,400), "S19558C16");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C19*)(S19558C18*), ABISELECT(688,400), "S19558C16");
    check_base_class_offset(lv, (S19558C10*)(S19558C19*)(S19558C18*), ABISELECT(688,400), "S19558C16");
    check_base_class_offset(lv, (S19558C19*)(S19558C18*), ABISELECT(688,400), "S19558C16");
    check_base_class_offset(lv, (S19558C18*), ABISELECT(560,324), "S19558C16");
    /*is_ambiguous_... S19558C9::S19558C6 */ AMB_check_base_class_offset(lv, (S19558C6*)(S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(3360,2028), "S19558C16");
    check_base_class_offset(lv, (S19558C9*)(S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(3360,2028), "S19558C16");
    check_base_class_offset(lv, (S19558C10*)(S19558C8*)(S19558C7*), ABISELECT(3360,2028), "S19558C16");
    check_base_class_offset(lv, (S19558C8*)(S19558C7*), ABISELECT(3360,2028), "S19558C16");
    check_base_class_offset(lv, (S19558C7*), ABISELECT(3360,2028), "S19558C16");
    set_bf_and_test(lv, s19558c16f0, ABISELECT(976,596), 0, 4, 1, "S19558C16");
    set_bf_and_test(lv, s19558c16f0, ABISELECT(976,596), 0, 4, hide_sll(1LL<<3), "S19558C16");
    set_bf_and_test(lv, s19558c16f1, ABISELECT(976,596), 4, 12, 1, "S19558C16");
    set_bf_and_test(lv, s19558c16f1, ABISELECT(976,596), 4, 12, hide_sll(1LL<<11), "S19558C16");
    check_field_offset(lv, s19558c16f2, ABISELECT(980,600), "S19558C16.s19558c16f2");
    check_field_offset(lv, s19558c16f3, ABISELECT(984,604), "S19558C16.s19558c16f3");
    test_class_info(&lv, &cd_S19558C16);
    dp->~S19558C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19558C16(Test_S19558C16, "S19558C16", ABISELECT(4080,2460));

#else // __cplusplus

extern void _ZN9S19558C16C1Ev();
extern void _ZN9S19558C16D2Ev();
Name_Map name_map_S19558C16[] = {
  NSPAIR(_ZN9S19558C16C1Ev),
  NSPAIR(_ZN9S19558C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19558C6;
extern VTBL_ENTRY _ZTI8S19558C6[];
extern  VTBL_ENTRY _ZTV8S19558C6[];
extern Class_Desc