// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3422C4_nt  {
  int s3422c4f0[2];
  void  mf3422c4(); // _ZN10S3422C4_nt8mf3422c4Ev
};
//SIG(-1 S3422C4_nt) C1{ m Fi[2]}


void  S3422C4_nt ::mf3422c4(){}

//skip512 S3422C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C3_nt  {
  int s3422c3f0;
  __tsi64 s3422c3f1;
  void *s3422c3f2[4];
  int s3422c3f3[2];
  void *s3422c3f4;
  ::S3422C4_nt s3422c3f5;
  void *s3422c3f6[2];
  virtual  ~S3422C3_nt(); // _ZN10S3422C3_ntD1Ev
  virtual void  v8(); // _ZN10S3422C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3422C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3422C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3422C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3422C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3422C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3422C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3422C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3422C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3422C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3422C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3422C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3422C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3422C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3422C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3422C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3422C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3422C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3422C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3422C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3422C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3422C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3422C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3422C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3422C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3422C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3422C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3422C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3422C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3422C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3422C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3422C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3422C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3422C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3422C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3422C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3422C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3422C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3422C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3422C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3422C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3422C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3422C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3422C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3422C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3422C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3422C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3422C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3422C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3422C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3422C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3422C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3422C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3422C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3422C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3422C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3422C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3422C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3422C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3422C3_nt3v67Ev
  virtual void  v68(); // _ZN10S3422C3_nt3v68Ev
  virtual void  v69(); // _ZN10S3422C3_nt3v69Ev
  virtual void  v70(); // _ZN10S3422C3_nt3v70Ev
  virtual void  v71(); // _ZN10S3422C3_nt3v71Ev
  S3422C3_nt(); // tgen
};
//SIG(-1 S3422C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3422C3_nt ::~S3422C3_nt(){ note_dtor("S3422C3_nt", this);}
void  S3422C3_nt ::v8(){vfunc_called(this, "_ZN10S3422C3_nt2v8Ev");}
void  S3422C3_nt ::v9(){vfunc_called(this, "_ZN10S3422C3_nt2v9Ev");}
void  S3422C3_nt ::v10(){vfunc_called(this, "_ZN10S3422C3_nt3v10Ev");}
void  S3422C3_nt ::v11(){vfunc_called(this, "_ZN10S3422C3_nt3v11Ev");}
void  S3422C3_nt ::v12(){vfunc_called(this, "_ZN10S3422C3_nt3v12Ev");}
void  S3422C3_nt ::v13(){vfunc_called(this, "_ZN10S3422C3_nt3v13Ev");}
void  S3422C3_nt ::v14(){vfunc_called(this, "_ZN10S3422C3_nt3v14Ev");}
void  S3422C3_nt ::v15(){vfunc_called(this, "_ZN10S3422C3_nt3v15Ev");}
void  S3422C3_nt ::v16(){vfunc_called(this, "_ZN10S3422C3_nt3v16Ev");}
void  S3422C3_nt ::v17(){vfunc_called(this, "_ZN10S3422C3_nt3v17Ev");}
void  S3422C3_nt ::v18(){vfunc_called(this, "_ZN10S3422C3_nt3v18Ev");}
void  S3422C3_nt ::v19(){vfunc_called(this, "_ZN10S3422C3_nt3v19Ev");}
void  S3422C3_nt ::v20(){vfunc_called(this, "_ZN10S3422C3_nt3v20Ev");}
void  S3422C3_nt ::v21(){vfunc_called(this, "_ZN10S3422C3_nt3v21Ev");}
void  S3422C3_nt ::v22(){vfunc_called(this, "_ZN10S3422C3_nt3v22Ev");}
void  S3422C3_nt ::v23(){vfunc_called(this, "_ZN10S3422C3_nt3v23Ev");}
void  S3422C3_nt ::v24(){vfunc_called(this, "_ZN10S3422C3_nt3v24Ev");}
void  S3422C3_nt ::v25(){vfunc_called(this, "_ZN10S3422C3_nt3v25Ev");}
void  S3422C3_nt ::v26(){vfunc_called(this, "_ZN10S3422C3_nt3v26Ev");}
void  S3422C3_nt ::v27(){vfunc_called(this, "_ZN10S3422C3_nt3v27Ev");}
void  S3422C3_nt ::v28(){vfunc_called(this, "_ZN10S3422C3_nt3v28Ev");}
void  S3422C3_nt ::v29(){vfunc_called(this, "_ZN10S3422C3_nt3v29Ev");}
void  S3422C3_nt ::v30(){vfunc_called(this, "_ZN10S3422C3_nt3v30Ev");}
void  S3422C3_nt ::v31(){vfunc_called(this, "_ZN10S3422C3_nt3v31Ev");}
void  S3422C3_nt ::v32(){vfunc_called(this, "_ZN10S3422C3_nt3v32Ev");}
void  S3422C3_nt ::v33(){vfunc_called(this, "_ZN10S3422C3_nt3v33Ev");}
void  S3422C3_nt ::v34(){vfunc_called(this, "_ZN10S3422C3_nt3v34Ev");}
void  S3422C3_nt ::v35(){vfunc_called(this, "_ZN10S3422C3_nt3v35Ev");}
void  S3422C3_nt ::v36(){vfunc_called(this, "_ZN10S3422C3_nt3v36Ev");}
void  S3422C3_nt ::v37(){vfunc_called(this, "_ZN10S3422C3_nt3v37Ev");}
void  S3422C3_nt ::v38(){vfunc_called(this, "_ZN10S3422C3_nt3v38Ev");}
void  S3422C3_nt ::v39(){vfunc_called(this, "_ZN10S3422C3_nt3v39Ev");}
void  S3422C3_nt ::v40(){vfunc_called(this, "_ZN10S3422C3_nt3v40Ev");}
void  S3422C3_nt ::v41(){vfunc_called(this, "_ZN10S3422C3_nt3v41Ev");}
void  S3422C3_nt ::v42(){vfunc_called(this, "_ZN10S3422C3_nt3v42Ev");}
void  S3422C3_nt ::v43(){vfunc_called(this, "_ZN10S3422C3_nt3v43Ev");}
void  S3422C3_nt ::v44(){vfunc_called(this, "_ZN10S3422C3_nt3v44Ev");}
void  S3422C3_nt ::v45(){vfunc_called(this, "_ZN10S3422C3_nt3v45Ev");}
void  S3422C3_nt ::v46(){vfunc_called(this, "_ZN10S3422C3_nt3v46Ev");}
void  S3422C3_nt ::v47(){vfunc_called(this, "_ZN10S3422C3_nt3v47Ev");}
void  S3422C3_nt ::v48(){vfunc_called(this, "_ZN10S3422C3_nt3v48Ev");}
void  S3422C3_nt ::v49(){vfunc_called(this, "_ZN10S3422C3_nt3v49Ev");}
void  S3422C3_nt ::v50(){vfunc_called(this, "_ZN10S3422C3_nt3v50Ev");}
void  S3422C3_nt ::v51(){vfunc_called(this, "_ZN10S3422C3_nt3v51Ev");}
void  S3422C3_nt ::v52(){vfunc_called(this, "_ZN10S3422C3_nt3v52Ev");}
void  S3422C3_nt ::v53(){vfunc_called(this, "_ZN10S3422C3_nt3v53Ev");}
void  S3422C3_nt ::v54(){vfunc_called(this, "_ZN10S3422C3_nt3v54Ev");}
void  S3422C3_nt ::v55(){vfunc_called(this, "_ZN10S3422C3_nt3v55Ev");}
void  S3422C3_nt ::v56(){vfunc_called(this, "_ZN10S3422C3_nt3v56Ev");}
void  S3422C3_nt ::v57(){vfunc_called(this, "_ZN10S3422C3_nt3v57Ev");}
void  S3422C3_nt ::v58(){vfunc_called(this, "_ZN10S3422C3_nt3v58Ev");}
void  S3422C3_nt ::v59(){vfunc_called(this, "_ZN10S3422C3_nt3v59Ev");}
void  S3422C3_nt ::v60(){vfunc_called(this, "_ZN10S3422C3_nt3v60Ev");}
void  S3422C3_nt ::v61(){vfunc_called(this, "_ZN10S3422C3_nt3v61Ev");}
void  S3422C3_nt ::v62(){vfunc_called(this, "_ZN10S3422C3_nt3v62Ev");}
void  S3422C3_nt ::v63(){vfunc_called(this, "_ZN10S3422C3_nt3v63Ev");}
void  S3422C3_nt ::v64(){vfunc_called(this, "_ZN10S3422C3_nt3v64Ev");}
void  S3422C3_nt ::v65(){vfunc_called(this, "_ZN10S3422C3_nt3v65Ev");}
void  S3422C3_nt ::v66(){vfunc_called(this, "_ZN10S3422C3_nt3v66Ev");}
void  S3422C3_nt ::v67(){vfunc_called(this, "_ZN10S3422C3_nt3v67Ev");}
void  S3422C3_nt ::v68(){vfunc_called(this, "_ZN10S3422C3_nt3v68Ev");}
void  S3422C3_nt ::v69(){vfunc_called(this, "_ZN10S3422C3_nt3v69Ev");}
void  S3422C3_nt ::v70(){vfunc_called(this, "_ZN10S3422C3_nt3v70Ev");}
void  S3422C3_nt ::v71(){vfunc_called(this, "_ZN10S3422C3_nt3v71Ev");}
S3422C3_nt ::S3422C3_nt(){ note_ctor("S3422C3_nt", this);} // tgen

//skip512 S3422C3_nt

#else // __cplusplus

extern void _ZN10S3422C3_ntC1Ev();
extern void _ZN10S3422C3_ntD1Ev();
Name_Map name_map_S3422C3_nt[] = {
  NSPAIR(_ZN10S3422C3_ntC1Ev),
  NSPAIR(_ZN10S3422C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3422C3_nt[];
extern void _ZN10S3422C3_ntD1Ev();
extern void _ZN10S3422C3_ntD0Ev();
extern void _ZN10S3422C3_nt2v8Ev();
extern void _ZN10S3422C3_nt2v9Ev();
extern void _ZN10S3422C3_nt3v10Ev();
extern void _ZN10S3422C3_nt3v11Ev();
extern void _ZN10S3422C3_nt3v12Ev();
extern void _ZN10S3422C3_nt3v13Ev();
extern void _ZN10S3422C3_nt3v14Ev();
extern void _ZN10S3422C3_nt3v15Ev();
extern void _ZN10S3422C3_nt3v16Ev();
extern void _ZN10S3422C3_nt3v17Ev();
extern void _ZN10S3422C3_nt3v18Ev();
extern void _ZN10S3422C3_nt3v19Ev();
extern void _ZN10S3422C3_nt3v20Ev();
extern void _ZN10S3422C3_nt3v21Ev();
extern void _ZN10S3422C3_nt3v22Ev();
extern void _ZN10S3422C3_nt3v23Ev();
extern void _ZN10S3422C3_nt3v24Ev();
extern void _ZN10S3422C3_nt3v25Ev();
extern void _ZN10S3422C3_nt3v26Ev();
extern void _ZN10S3422C3_nt3v27Ev();
extern void _ZN10S3422C3_nt3v28Ev();
extern void _ZN10S3422C3_nt3v29Ev();
extern void _ZN10S3422C3_nt3v30Ev();
extern void _ZN10S3422C3_nt3v31Ev();
extern void _ZN10S3422C3_nt3v32Ev();
extern void _ZN10S3422C3_nt3v33Ev();
extern void _ZN10S3422C3_nt3v34Ev();
extern void _ZN10S3422C3_nt3v35Ev();
extern void _ZN10S3422C3_nt3v36Ev();
extern void _ZN10S3422C3_nt3v37Ev();
extern void _ZN10S3422C3_nt3v38Ev();
extern void _ZN10S3422C3_nt3v39Ev();
extern void _ZN10S3422C3_nt3v40Ev();
extern void _ZN10S3422C3_nt3v41Ev();
extern void _ZN10S3422C3_nt3v42Ev();
extern void _ZN10S3422C3_nt3v43Ev();
extern void _ZN10S3422C3_nt3v44Ev();
extern void _ZN10S3422C3_nt3v45Ev();
extern void _ZN10S3422C3_nt3v46Ev();
extern void _ZN10S3422C3_nt3v47Ev();
extern void _ZN10S3422C3_nt3v48Ev();
extern void _ZN10S3422C3_nt3v49Ev();
extern void _ZN10S3422C3_nt3v50Ev();
extern void _ZN10S3422C3_nt3v51Ev();
extern void _ZN10S3422C3_nt3v52Ev();
extern void _ZN10S3422C3_nt3v53Ev();
extern void _ZN10S3422C3_nt3v54Ev();
extern void _ZN10S3422C3_nt3v55Ev();
extern void _ZN10S3422C3_nt3v56Ev();
extern void _ZN10S3422C3_nt3v57Ev();
extern void _ZN10S3422C3_nt3v58Ev();
extern void _ZN10S3422C3_nt3v59Ev();
extern void _ZN10S3422C3_nt3v60Ev();
extern void _ZN10S3422C3_nt3v61Ev();
extern void _ZN10S3422C3_nt3v62Ev();
extern void _ZN10S3422C3_nt3v63Ev();
extern void _ZN10S3422C3_nt3v64Ev();
extern void _ZN10S3422C3_nt3v65Ev();
extern void _ZN10S3422C3_nt3v66Ev();
extern void _ZN10S3422C3_nt3v67Ev();
extern void _ZN10S3422C3_nt3v68Ev();
extern void _ZN10S3422C3_nt3v69Ev();
extern void _ZN10S3422C3_nt3v70Ev();
extern void _ZN10S3422C3_nt3v71Ev();
static  VTBL_ENTRY vtc_S3422C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3422C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3422C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v71Ev,
};
extern VTBL_ENTRY _ZTI10S3422C3_nt[];
VTBL_ENTRY *P__ZTI10S3422C3_nt = _ZTI10S3422C3_nt; 
extern  VTBL_ENTRY _ZTV10S3422C3_nt[];
Class_Descriptor cd_S3422C3_nt = {  "S3422C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3422C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3422C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3422C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C7_nt  {
  void *s3422c7f0;
  int s3422c7f1[2];
  void  mf3422c7(); // _ZN10S3422C7_nt8mf3422c7Ev
};
//SIG(-1 S3422C7_nt) C1{ m Fp Fi[2]}


void  S3422C7_nt ::mf3422c7(){}

//skip512 S3422C7_nt

#else // __cplusplus

Class_Descriptor cd_S3422C7_nt = {  "S3422C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C6_nt  : S3422C7_nt {
};
//SIG(-1 S3422C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3422C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
static Base_Class bases_S3422C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C6_nt = {  "S3422C6_nt", // class name
  bases_S3422C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C5_nt  : S3422C6_nt {
};
//SIG(-1 S3422C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3422C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S3422C6_nt;
static Base_Class bases_S3422C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C8_nt  {
  int s3422c8f0;
  void  mf3422c8(); // _ZN10S3422C8_nt8mf3422c8Ev
};
//SIG(-1 S3422C8_nt) C1{ m Fi}


void  S3422C8_nt ::mf3422c8(){}

//skip512 S3422C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3422C8_nt[];
VTBL_ENTRY *P__ZTI10S3422C8_nt = _ZTI10S3422C8_nt; 
Class_Descriptor cd_S3422C8_nt = {  "S3422C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3422C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C12  : S3422C7_nt {
};
//SIG(-1 S3422C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3422C12()
{
  extern Class_Descriptor cd_S3422C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C12, buf);
    S3422C12 &lv = *(new (buf) S3422C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C12)");
    check_base_class_offset(lv, (S3422C7_nt*), 0, "S3422C12");
    test_class_info(&lv, &cd_S3422C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C12(Test_S3422C12, "S3422C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
static Base_Class bases_S3422C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C12 = {  "S3422C12", // class name
  bases_S3422C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C11  : S3422C12 {
};
//SIG(-1 S3422C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3422C11()
{
  extern Class_Descriptor cd_S3422C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C11, buf);
    S3422C11 &lv = *(new (buf) S3422C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C11)");
    check_base_class_offset(lv, (S3422C7_nt*)(S3422C12*), 0, "S3422C11");
    check_base_class_offset(lv, (S3422C12*), 0, "S3422C11");
    test_class_info(&lv, &cd_S3422C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C11(Test_S3422C11, "S3422C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S3422C12;
static Base_Class bases_S3422C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C11 = {  "S3422C11", // class name
  bases_S3422C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C13_nt  {
  int s3422c13f0[3];
  void  mf3422c13(); // _ZN11S3422C13_nt9mf3422c13Ev
};
//SIG(-1 S3422C13_nt) C1{ m Fi[3]}


void  S3422C13_nt ::mf3422c13(){}

//skip512 S3422C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C18  : S3422C7_nt {
};
//SIG(-1 S3422C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3422C18()
{
  extern Class_Descriptor cd_S3422C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C18, buf);
    S3422C18 &lv = *(new (buf) S3422C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C18)");
    check_base_class_offset(lv, (S3422C7_nt*), 0, "S3422C18");
    test_class_info(&lv, &cd_S3422C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C18(Test_S3422C18, "S3422C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
static Base_Class bases_S3422C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C18 = {  "S3422C18", // class name
  bases_S3422C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C17  : S3422C18 {
};
//SIG(-1 S3422C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3422C17()
{
  extern Class_Descriptor cd_S3422C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C17, buf);
    S3422C17 &lv = *(new (buf) S3422C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C17)");
    check_base_class_offset(lv, (S3422C7_nt*)(S3422C18*), 0, "S3422C17");
    check_base_class_offset(lv, (S3422C18*), 0, "S3422C17");
    test_class_info(&lv, &cd_S3422C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C17(Test_S3422C17, "S3422C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S3422C18;
static Base_Class bases_S3422C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C17 = {  "S3422C17", // class name
  bases_S3422C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C2_nt  : S3422C3_nt {
  ::S3422C5_nt s3422c2f0;
  ::S3422C5_nt s3422c2f1;
  ::S3422C8_nt s3422c2f2;
  int s3422c2f3;
  char s3422c2f4[4];
  void *s3422c2f5[2];
  ::S3422C5_nt s3422c2f6;
  unsigned int s3422c2f7:1;
  unsigned int s3422c2f8:1;
  unsigned int s3422c2f9:1;
  unsigned int s3422c2f10:1;
  unsigned int s3422c2f11:1;
  unsigned int s3422c2f12:1;
  unsigned int s3422c2f13:1;
  unsigned int s3422c2f14:1;
  unsigned int s3422c2f15:1;
  unsigned int s3422c2f16:1;
  unsigned int s3422c2f17:1;
  unsigned int s3422c2f18:1;
  unsigned int s3422c2f19:1;
  unsigned int s3422c2f20:1;
  unsigned int s3422c2f21:1;
  unsigned int s3422c2f22:1;
  unsigned int s3422c2f23:1;
  unsigned int s3422c2f24:1;
  unsigned int s3422c2f25:1;
  unsigned int s3422c2f26:1;
  unsigned int s3422c2f27:1;
  unsigned int s3422c2f28:1;
  unsigned int s3422c2f29:1;
  unsigned int s3422c2f30:1;
  unsigned int s3422c2f31:1;
  unsigned int s3422c2f32:1;
  unsigned int s3422c2f33:1;
  unsigned int s3422c2f34:1;
  unsigned int s3422c2f35:1;
  unsigned int s3422c2f36:1;
  unsigned int s3422c2f37:1;
  unsigned int s3422c2f38:1;
  unsigned int s3422c2f39:1;
  unsigned int s3422c2f40:1;
  unsigned int s3422c2f41:1;
  unsigned int s3422c2f42:1;
  unsigned int s3422c2f43:1;
  unsigned int s3422c2f44:1;
  unsigned int s3422c2f45:1;
  unsigned int s3422c2f46:1;
  unsigned int s3422c2f47:1;
  unsigned int s3422c2f48:1;
  unsigned int s3422c2f49:1;
  unsigned int s3422c2f50:1;
  unsigned int s3422c2f51:1;
  unsigned int s3422c2f52:1;
  unsigned int s3422c2f53:1;
  unsigned int s3422c2f54:1;
  unsigned int s3422c2f55:1;
  unsigned int s3422c2f56:1;
  unsigned int s3422c2f57:1;
  unsigned int s3422c2f58:1;
  unsigned int s3422c2f59:1;
  unsigned int s3422c2f60:1;
  unsigned int s3422c2f61:1;
  unsigned int s3422c2f62:1;
  unsigned int s3422c2f63:1;
  unsigned int s3422c2f64:1;
  unsigned int s3422c2f65:1;
  unsigned int s3422c2f66:1;
  unsigned int s3422c2f67:1;
  unsigned int s3422c2f68:1;
  unsigned int s3422c2f69:1;
  unsigned int s3422c2f70:1;
  unsigned int s3422c2f71:1;
  unsigned int s3422c2f72:1;
  unsigned int s3422c2f73:1;
  unsigned int s3422c2f74:1;
  unsigned int s3422c2f75:1;
  unsigned int s3422c2f76:1;
  unsigned int s3422c2f77:1;
  unsigned int s3422c2f78:1;
  unsigned int s3422c2f79:1;
  unsigned int s3422c2f80:1;
  unsigned int s3422c2f81:1;
  unsigned int s3422c2f82:1;
  unsigned int s3422c2f83:1;
  int s3422c2f84[5];
  void *s3422c2f85[2];
  int s3422c2f86[3];
  ::S3422C4_nt s3422c2f87;
  ::S3422C4_nt s3422c2f88;
  ::S3422C4_nt s3422c2f89;
  ::S3422C11 s3422c2f90;
  ::S3422C11 s3422c2f91;
  int s3422c2f92;
  void *s3422c2f93[2];
  ::S3422C13_nt s3422c2f94;
  ::S3422C13_nt s3422c2f95;
  ::S3422C13_nt s3422c2f96;
  ::S3422C13_nt s3422c2f97;
  void *s3422c2f98;
  ::S3422C4_nt s3422c2f99;
  ::S3422C11 s3422c2f100;
  ::S3422C13_nt s3422c2f101;
  ::S3422C13_nt s3422c2f102;
  int s3422c2f103;
  ::S3422C13_nt s3422c2f104;
  ::S3422C13_nt s3422c2f105;
  void *s3422c2f106;
  int s3422c2f107;
  char s3422c2f108;
  ::S3422C13_nt s3422c2f109;
  ::S3422C13_nt s3422c2f110;
  void *s3422c2f111;
  int s3422c2f112;
  void *s3422c2f113;
  ::S3422C11 s3422c2f114;
  ::S3422C17 s3422c2f115;
  ::S3422C17 s3422c2f116;
  virtual  ~S3422C2_nt(); // _ZN10S3422C2_ntD1Ev
  virtual void  v72(); // _ZN10S3422C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3422C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3422C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3422C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3422C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3422C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3422C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3422C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3422C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3422C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3422C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3422C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3422C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3422C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3422C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3422C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3422C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3422C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3422C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3422C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3422C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3422C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3422C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3422C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3422C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3422C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3422C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3422C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3422C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3422C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3422C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3422C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3422C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3422C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3422C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3422C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3422C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3422C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3422C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3422C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3422C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3422C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3422C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3422C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3422C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3422C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3422C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3422C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3422C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3422C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3422C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3422C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3422C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3422C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3422C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3422C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3422C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3422C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3422C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3422C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3422C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3422C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3422C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3422C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3422C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3422C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3422C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3422C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3422C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3422C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3422C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3422C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3422C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3422C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3422C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3422C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3422C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3422C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3422C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3422C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3422C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3422C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3422C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3422C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3422C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3422C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3422C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3422C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3422C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3422C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3422C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3422C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3422C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3422C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3422C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3422C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3422C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3422C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3422C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3422C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3422C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3422C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3422C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3422C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3422C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3422C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3422C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3422C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3422C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3422C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3422C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3422C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3422C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3422C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3422C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3422C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3422C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3422C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3422C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3422C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3422C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3422C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3422C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3422C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3422C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3422C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3422C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3422C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3422C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3422C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3422C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3422C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3422C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3422C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3422C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3422C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3422C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3422C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3422C2_nt4v210Ev
  virtual void  v211(); // _ZN10S3422C2_nt4v211Ev
  virtual void  v212(); // _ZN10S3422C2_nt4v212Ev
  virtual void  v213(); // _ZN10S3422C2_nt4v213Ev
  virtual void  v214(); // _ZN10S3422C2_nt4v214Ev
  S3422C2_nt(); // tgen
};
//SIG(-1 S3422C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3422C2_nt ::~S3422C2_nt(){ note_dtor("S3422C2_nt", this);}
void  S3422C2_nt ::v72(){vfunc_called(this, "_ZN10S3422C2_nt3v72Ev");}
void  S3422C2_nt ::v73(){vfunc_called(this, "_ZN10S3422C2_nt3v73Ev");}
void  S3422C2_nt ::v74(){vfunc_called(this, "_ZN10S3422C2_nt3v74Ev");}
void  S3422C2_nt ::v75(){vfunc_called(this, "_ZN10S3422C2_nt3v75Ev");}
void  S3422C2_nt ::v76(){vfunc_called(this, "_ZN10S3422C2_nt3v76Ev");}
void  S3422C2_nt ::v77(){vfunc_called(this, "_ZN10S3422C2_nt3v77Ev");}
void  S3422C2_nt ::v78(){vfunc_called(this, "_ZN10S3422C2_nt3v78Ev");}
void  S3422C2_nt ::v79(){vfunc_called(this, "_ZN10S3422C2_nt3v79Ev");}
void  S3422C2_nt ::v80(){vfunc_called(this, "_ZN10S3422C2_nt3v80Ev");}
void  S3422C2_nt ::v81(){vfunc_called(this, "_ZN10S3422C2_nt3v81Ev");}
void  S3422C2_nt ::v82(){vfunc_called(this, "_ZN10S3422C2_nt3v82Ev");}
void  S3422C2_nt ::v83(){vfunc_called(this, "_ZN10S3422C2_nt3v83Ev");}
void  S3422C2_nt ::v84(){vfunc_called(this, "_ZN10S3422C2_nt3v84Ev");}
void  S3422C2_nt ::v85(){vfunc_called(this, "_ZN10S3422C2_nt3v85Ev");}
void  S3422C2_nt ::v86(){vfunc_called(this, "_ZN10S3422C2_nt3v86Ev");}
void  S3422C2_nt ::v87(){vfunc_called(this, "_ZN10S3422C2_nt3v87Ev");}
void  S3422C2_nt ::v88(){vfunc_called(this, "_ZN10S3422C2_nt3v88Ev");}
void  S3422C2_nt ::v89(){vfunc_called(this, "_ZN10S3422C2_nt3v89Ev");}
void  S3422C2_nt ::v90(){vfunc_called(this, "_ZN10S3422C2_nt3v90Ev");}
void  S3422C2_nt ::v91(){vfunc_called(this, "_ZN10S3422C2_nt3v91Ev");}
void  S3422C2_nt ::v92(){vfunc_called(this, "_ZN10S3422C2_nt3v92Ev");}
void  S3422C2_nt ::v93(){vfunc_called(this, "_ZN10S3422C2_nt3v93Ev");}
void  S3422C2_nt ::v94(){vfunc_called(this, "_ZN10S3422C2_nt3v94Ev");}
void  S3422C2_nt ::v95(){vfunc_called(this, "_ZN10S3422C2_nt3v95Ev");}
void  S3422C2_nt ::v96(){vfunc_called(this, "_ZN10S3422C2_nt3v96Ev");}
void  S3422C2_nt ::v97(){vfunc_called(this, "_ZN10S3422C2_nt3v97Ev");}
void  S3422C2_nt ::v98(){vfunc_called(this, "_ZN10S3422C2_nt3v98Ev");}
void  S3422C2_nt ::v99(){vfunc_called(this, "_ZN10S3422C2_nt3v99Ev");}
void  S3422C2_nt ::v100(){vfunc_called(this, "_ZN10S3422C2_nt4v100Ev");}
void  S3422C2_nt ::v101(){vfunc_called(this, "_ZN10S3422C2_nt4v101Ev");}
void  S3422C2_nt ::v102(){vfunc_called(this, "_ZN10S3422C2_nt4v102Ev");}
void  S3422C2_nt ::v103(){vfunc_called(this, "_ZN10S3422C2_nt4v103Ev");}
void  S3422C2_nt ::v104(){vfunc_called(this, "_ZN10S3422C2_nt4v104Ev");}
void  S3422C2_nt ::v105(){vfunc_called(this, "_ZN10S3422C2_nt4v105Ev");}
void  S3422C2_nt ::v106(){vfunc_called(this, "_ZN10S3422C2_nt4v106Ev");}
void  S3422C2_nt ::v107(){vfunc_called(this, "_ZN10S3422C2_nt4v107Ev");}
void  S3422C2_nt ::v108(){vfunc_called(this, "_ZN10S3422C2_nt4v108Ev");}
void  S3422C2_nt ::v109(){vfunc_called(this, "_ZN10S3422C2_nt4v109Ev");}
void  S3422C2_nt ::v110(){vfunc_called(this, "_ZN10S3422C2_nt4v110Ev");}
void  S3422C2_nt ::v111(){vfunc_called(this, "_ZN10S3422C2_nt4v111Ev");}
void  S3422C2_nt ::v112(){vfunc_called(this, "_ZN10S3422C2_nt4v112Ev");}
void  S3422C2_nt ::v113(){vfunc_called(this, "_ZN10S3422C2_nt4v113Ev");}
void  S3422C2_nt ::v114(){vfunc_called(this, "_ZN10S3422C2_nt4v114Ev");}
void  S3422C2_nt ::v115(){vfunc_called(this, "_ZN10S3422C2_nt4v115Ev");}
void  S3422C2_nt ::v116(){vfunc_called(this, "_ZN10S3422C2_nt4v116Ev");}
void  S3422C2_nt ::v117(){vfunc_called(this, "_ZN10S3422C2_nt4v117Ev");}
void  S3422C2_nt ::v118(){vfunc_called(this, "_ZN10S3422C2_nt4v118Ev");}
void  S3422C2_nt ::v119(){vfunc_called(this, "_ZN10S3422C2_nt4v119Ev");}
void  S3422C2_nt ::v120(){vfunc_called(this, "_ZN10S3422C2_nt4v120Ev");}
void  S3422C2_nt ::v121(){vfunc_called(this, "_ZN10S3422C2_nt4v121Ev");}
void  S3422C2_nt ::v122(){vfunc_called(this, "_ZN10S3422C2_nt4v122Ev");}
void  S3422C2_nt ::v123(){vfunc_called(this, "_ZN10S3422C2_nt4v123Ev");}
void  S3422C2_nt ::v124(){vfunc_called(this, "_ZN10S3422C2_nt4v124Ev");}
void  S3422C2_nt ::v125(){vfunc_called(this, "_ZN10S3422C2_nt4v125Ev");}
void  S3422C2_nt ::v126(){vfunc_called(this, "_ZN10S3422C2_nt4v126Ev");}
void  S3422C2_nt ::v127(){vfunc_called(this, "_ZN10S3422C2_nt4v127Ev");}
void  S3422C2_nt ::v128(){vfunc_called(this, "_ZN10S3422C2_nt4v128Ev");}
void  S3422C2_nt ::v129(){vfunc_called(this, "_ZN10S3422C2_nt4v129Ev");}
void  S3422C2_nt ::v130(){vfunc_called(this, "_ZN10S3422C2_nt4v130Ev");}
void  S3422C2_nt ::v131(){vfunc_called(this, "_ZN10S3422C2_nt4v131Ev");}
void  S3422C2_nt ::v132(){vfunc_called(this, "_ZN10S3422C2_nt4v132Ev");}
void  S3422C2_nt ::v133(){vfunc_called(this, "_ZN10S3422C2_nt4v133Ev");}
void  S3422C2_nt ::v134(){vfunc_called(this, "_ZN10S3422C2_nt4v134Ev");}
void  S3422C2_nt ::v135(){vfunc_called(this, "_ZN10S3422C2_nt4v135Ev");}
void  S3422C2_nt ::v136(){vfunc_called(this, "_ZN10S3422C2_nt4v136Ev");}
void  S3422C2_nt ::v137(){vfunc_called(this, "_ZN10S3422C2_nt4v137Ev");}
void  S3422C2_nt ::v138(){vfunc_called(this, "_ZN10S3422C2_nt4v138Ev");}
void  S3422C2_nt ::v139(){vfunc_called(this, "_ZN10S3422C2_nt4v139Ev");}
void  S3422C2_nt ::v140(){vfunc_called(this, "_ZN10S3422C2_nt4v140Ev");}
void  S3422C2_nt ::v141(){vfunc_called(this, "_ZN10S3422C2_nt4v141Ev");}
void  S3422C2_nt ::v142(){vfunc_called(this, "_ZN10S3422C2_nt4v142Ev");}
void  S3422C2_nt ::v143(){vfunc_called(this, "_ZN10S3422C2_nt4v143Ev");}
void  S3422C2_nt ::v144(){vfunc_called(this, "_ZN10S3422C2_nt4v144Ev");}
void  S3422C2_nt ::v145(){vfunc_called(this, "_ZN10S3422C2_nt4v145Ev");}
void  S3422C2_nt ::v146(){vfunc_called(this, "_ZN10S3422C2_nt4v146Ev");}
void  S3422C2_nt ::v147(){vfunc_called(this, "_ZN10S3422C2_nt4v147Ev");}
void  S3422C2_nt ::v148(){vfunc_called(this, "_ZN10S3422C2_nt4v148Ev");}
void  S3422C2_nt ::v149(){vfunc_called(this, "_ZN10S3422C2_nt4v149Ev");}
void  S3422C2_nt ::v150(){vfunc_called(this, "_ZN10S3422C2_nt4v150Ev");}
void  S3422C2_nt ::v151(){vfunc_called(this, "_ZN10S3422C2_nt4v151Ev");}
void  S3422C2_nt ::v152(){vfunc_called(this, "_ZN10S3422C2_nt4v152Ev");}
void  S3422C2_nt ::v153(){vfunc_called(this, "_ZN10S3422C2_nt4v153Ev");}
void  S3422C2_nt ::v154(){vfunc_called(this, "_ZN10S3422C2_nt4v154Ev");}
void  S3422C2_nt ::v155(){vfunc_called(this, "_ZN10S3422C2_nt4v155Ev");}
void  S3422C2_nt ::v156(){vfunc_called(this, "_ZN10S3422C2_nt4v156Ev");}
void  S3422C2_nt ::v157(){vfunc_called(this, "_ZN10S3422C2_nt4v157Ev");}
void  S3422C2_nt ::v158(){vfunc_called(this, "_ZN10S3422C2_nt4v158Ev");}
void  S3422C2_nt ::v159(){vfunc_called(this, "_ZN10S3422C2_nt4v159Ev");}
void  S3422C2_nt ::v160(){vfunc_called(this, "_ZN10S3422C2_nt4v160Ev");}
void  S3422C2_nt ::v161(){vfunc_called(this, "_ZN10S3422C2_nt4v161Ev");}
void  S3422C2_nt ::v162(){vfunc_called(this, "_ZN10S3422C2_nt4v162Ev");}
void  S3422C2_nt ::v163(){vfunc_called(this, "_ZN10S3422C2_nt4v163Ev");}
void  S3422C2_nt ::v164(){vfunc_called(this, "_ZN10S3422C2_nt4v164Ev");}
void  S3422C2_nt ::v165(){vfunc_called(this, "_ZN10S3422C2_nt4v165Ev");}
void  S3422C2_nt ::v166(){vfunc_called(this, "_ZN10S3422C2_nt4v166Ev");}
void  S3422C2_nt ::v167(){vfunc_called(this, "_ZN10S3422C2_nt4v167Ev");}
void  S3422C2_nt ::v168(){vfunc_called(this, "_ZN10S3422C2_nt4v168Ev");}
void  S3422C2_nt ::v169(){vfunc_called(this, "_ZN10S3422C2_nt4v169Ev");}
void  S3422C2_nt ::v170(){vfunc_called(this, "_ZN10S3422C2_nt4v170Ev");}
void  S3422C2_nt ::v171(){vfunc_called(this, "_ZN10S3422C2_nt4v171Ev");}
void  S3422C2_nt ::v172(){vfunc_called(this, "_ZN10S3422C2_nt4v172Ev");}
void  S3422C2_nt ::v173(){vfunc_called(this, "_ZN10S3422C2_nt4v173Ev");}
void  S3422C2_nt ::v174(){vfunc_called(this, "_ZN10S3422C2_nt4v174Ev");}
void  S3422C2_nt ::v175(){vfunc_called(this, "_ZN10S3422C2_nt4v175Ev");}
void  S3422C2_nt ::v176(){vfunc_called(this, "_ZN10S3422C2_nt4v176Ev");}
void  S3422C2_nt ::v177(){vfunc_called(this, "_ZN10S3422C2_nt4v177Ev");}
void  S3422C2_nt ::v178(){vfunc_called(this, "_ZN10S3422C2_nt4v178Ev");}
void  S3422C2_nt ::v179(){vfunc_called(this, "_ZN10S3422C2_nt4v179Ev");}
void  S3422C2_nt ::v180(){vfunc_called(this, "_ZN10S3422C2_nt4v180Ev");}
void  S3422C2_nt ::v181(){vfunc_called(this, "_ZN10S3422C2_nt4v181Ev");}
void  S3422C2_nt ::v182(){vfunc_called(this, "_ZN10S3422C2_nt4v182Ev");}
void  S3422C2_nt ::v183(){vfunc_called(this, "_ZN10S3422C2_nt4v183Ev");}
void  S3422C2_nt ::v184(){vfunc_called(this, "_ZN10S3422C2_nt4v184Ev");}
void  S3422C2_nt ::v185(){vfunc_called(this, "_ZN10S3422C2_nt4v185Ev");}
void  S3422C2_nt ::v186(){vfunc_called(this, "_ZN10S3422C2_nt4v186Ev");}
void  S3422C2_nt ::v187(){vfunc_called(this, "_ZN10S3422C2_nt4v187Ev");}
void  S3422C2_nt ::v188(){vfunc_called(this, "_ZN10S3422C2_nt4v188Ev");}
void  S3422C2_nt ::v189(){vfunc_called(this, "_ZN10S3422C2_nt4v189Ev");}
void  S3422C2_nt ::v190(){vfunc_called(this, "_ZN10S3422C2_nt4v190Ev");}
void  S3422C2_nt ::v191(){vfunc_called(this, "_ZN10S3422C2_nt4v191Ev");}
void  S3422C2_nt ::v192(){vfunc_called(this, "_ZN10S3422C2_nt4v192Ev");}
void  S3422C2_nt ::v193(){vfunc_called(this, "_ZN10S3422C2_nt4v193Ev");}
void  S3422C2_nt ::v194(){vfunc_called(this, "_ZN10S3422C2_nt4v194Ev");}
void  S3422C2_nt ::v195(){vfunc_called(this, "_ZN10S3422C2_nt4v195Ev");}
void  S3422C2_nt ::v196(){vfunc_called(this, "_ZN10S3422C2_nt4v196Ev");}
void  S3422C2_nt ::v197(){vfunc_called(this, "_ZN10S3422C2_nt4v197Ev");}
void  S3422C2_nt ::v198(){vfunc_called(this, "_ZN10S3422C2_nt4v198Ev");}
void  S3422C2_nt ::v199(){vfunc_called(this, "_ZN10S3422C2_nt4v199Ev");}
void  S3422C2_nt ::v200(){vfunc_called(this, "_ZN10S3422C2_nt4v200Ev");}
void  S3422C2_nt ::v201(){vfunc_called(this, "_ZN10S3422C2_nt4v201Ev");}
void  S3422C2_nt ::v202(){vfunc_called(this, "_ZN10S3422C2_nt4v202Ev");}
void  S3422C2_nt ::v203(){vfunc_called(this, "_ZN10S3422C2_nt4v203Ev");}
void  S3422C2_nt ::v204(){vfunc_called(this, "_ZN10S3422C2_nt4v204Ev");}
void  S3422C2_nt ::v205(){vfunc_called(this, "_ZN10S3422C2_nt4v205Ev");}
void  S3422C2_nt ::v206(){vfunc_called(this, "_ZN10S3422C2_nt4v206Ev");}
void  S3422C2_nt ::v207(){vfunc_called(this, "_ZN10S3422C2_nt4v207Ev");}
void  S3422C2_nt ::v208(){vfunc_called(this, "_ZN10S3422C2_nt4v208Ev");}
void  S3422C2_nt ::v209(){vfunc_called(this, "_ZN10S3422C2_nt4v209Ev");}
void  S3422C2_nt ::v210(){vfunc_called(this, "_ZN10S3422C2_nt4v210Ev");}
void  S3422C2_nt ::v211(){vfunc_called(this, "_ZN10S3422C2_nt4v211Ev");}
void  S3422C2_nt ::v212(){vfunc_called(this, "_ZN10S3422C2_nt4v212Ev");}
void  S3422C2_nt ::v213(){vfunc_called(this, "_ZN10S3422C2_nt4v213Ev");}
void  S3422C2_nt ::v214(){vfunc_called(this, "_ZN10S3422C2_nt4v214Ev");}
S3422C2_nt ::S3422C2_nt(){ note_ctor("S3422C2_nt", this);} // tgen

//skip512 S3422C2_nt

#else // __cplusplus

extern void _ZN10S3422C2_ntC1Ev();
extern void _ZN10S3422C2_ntD1Ev();
Name_Map name_map_S3422C2_nt[] = {
  NSPAIR(_ZN10S3422C2_ntC1Ev),
  NSPAIR(_ZN10S3422C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3422C3_nt;
extern VTBL_ENTRY _ZTI10S3422C3_nt[];
extern  VTBL_ENTRY _ZTV10S3422C3_nt[];
static Base_Class bases_S3422C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3422C2_nt[];
extern void _ZN10S3422C2_ntD1Ev();
extern void _ZN10S3422C2_ntD0Ev();
extern void _ZN10S3422C3_nt2v8Ev();
extern void _ZN10S3422C3_nt2v9Ev();
extern void _ZN10S3422C3_nt3v10Ev();
extern void _ZN10S3422C3_nt3v11Ev();
extern void _ZN10S3422C3_nt3v12Ev();
extern void _ZN10S3422C3_nt3v13Ev();
extern void _ZN10S3422C3_nt3v14Ev();
extern void _ZN10S3422C3_nt3v15Ev();
extern void _ZN10S3422C3_nt3v16Ev();
extern void _ZN10S3422C3_nt3v17Ev();
extern void _ZN10S3422C3_nt3v18Ev();
extern void _ZN10S3422C3_nt3v19Ev();
extern void _ZN10S3422C3_nt3v20Ev();
extern void _ZN10S3422C3_nt3v21Ev();
extern void _ZN10S3422C3_nt3v22Ev();
extern void _ZN10S3422C3_nt3v23Ev();
extern void _ZN10S3422C3_nt3v24Ev();
extern void _ZN10S3422C3_nt3v25Ev();
extern void _ZN10S3422C3_nt3v26Ev();
extern void _ZN10S3422C3_nt3v27Ev();
extern void _ZN10S3422C3_nt3v28Ev();
extern void _ZN10S3422C3_nt3v29Ev();
extern void _ZN10S3422C3_nt3v30Ev();
extern void _ZN10S3422C3_nt3v31Ev();
extern void _ZN10S3422C3_nt3v32Ev();
extern void _ZN10S3422C3_nt3v33Ev();
extern void _ZN10S3422C3_nt3v34Ev();
extern void _ZN10S3422C3_nt3v35Ev();
extern void _ZN10S3422C3_nt3v36Ev();
extern void _ZN10S3422C3_nt3v37Ev();
extern void _ZN10S3422C3_nt3v38Ev();
extern void _ZN10S3422C3_nt3v39Ev();
extern void _ZN10S3422C3_nt3v40Ev();
extern void _ZN10S3422C3_nt3v41Ev();
extern void _ZN10S3422C3_nt3v42Ev();
extern void _ZN10S3422C3_nt3v43Ev();
extern void _ZN10S3422C3_nt3v44Ev();
extern void _ZN10S3422C3_nt3v45Ev();
extern void _ZN10S3422C3_nt3v46Ev();
extern void _ZN10S3422C3_nt3v47Ev();
extern void _ZN10S3422C3_nt3v48Ev();
extern void _ZN10S3422C3_nt3v49Ev();
extern void _ZN10S3422C3_nt3v50Ev();
extern void _ZN10S3422C3_nt3v51Ev();
extern void _ZN10S3422C3_nt3v52Ev();
extern void _ZN10S3422C3_nt3v53Ev();
extern void _ZN10S3422C3_nt3v54Ev();
extern void _ZN10S3422C3_nt3v55Ev();
extern void _ZN10S3422C3_nt3v56Ev();
extern void _ZN10S3422C3_nt3v57Ev();
extern void _ZN10S3422C3_nt3v58Ev();
extern void _ZN10S3422C3_nt3v59Ev();
extern void _ZN10S3422C3_nt3v60Ev();
extern void _ZN10S3422C3_nt3v61Ev();
extern void _ZN10S3422C3_nt3v62Ev();
extern void _ZN10S3422C3_nt3v63Ev();
extern void _ZN10S3422C3_nt3v64Ev();
extern void _ZN10S3422C3_nt3v65Ev();
extern void _ZN10S3422C3_nt3v66Ev();
extern void _ZN10S3422C3_nt3v67Ev();
extern void _ZN10S3422C3_nt3v68Ev();
extern void _ZN10S3422C3_nt3v69Ev();
extern void _ZN10S3422C3_nt3v70Ev();
extern void _ZN10S3422C3_nt3v71Ev();
extern void _ZN10S3422C2_nt3v72Ev();
extern void _ZN10S3422C2_nt3v73Ev();
extern void _ZN10S3422C2_nt3v74Ev();
extern void _ZN10S3422C2_nt3v75Ev();
extern void _ZN10S3422C2_nt3v76Ev();
extern void _ZN10S3422C2_nt3v77Ev();
extern void _ZN10S3422C2_nt3v78Ev();
extern void _ZN10S3422C2_nt3v79Ev();
extern void _ZN10S3422C2_nt3v80Ev();
extern void _ZN10S3422C2_nt3v81Ev();
extern void _ZN10S3422C2_nt3v82Ev();
extern void _ZN10S3422C2_nt3v83Ev();
extern void _ZN10S3422C2_nt3v84Ev();
extern void _ZN10S3422C2_nt3v85Ev();
extern void _ZN10S3422C2_nt3v86Ev();
extern void _ZN10S3422C2_nt3v87Ev();
extern void _ZN10S3422C2_nt3v88Ev();
extern void _ZN10S3422C2_nt3v89Ev();
extern void _ZN10S3422C2_nt3v90Ev();
extern void _ZN10S3422C2_nt3v91Ev();
extern void _ZN10S3422C2_nt3v92Ev();
extern void _ZN10S3422C2_nt3v93Ev();
extern void _ZN10S3422C2_nt3v94Ev();
extern void _ZN10S3422C2_nt3v95Ev();
extern void _ZN10S3422C2_nt3v96Ev();
extern void _ZN10S3422C2_nt3v97Ev();
extern void _ZN10S3422C2_nt3v98Ev();
extern void _ZN10S3422C2_nt3v99Ev();
extern void _ZN10S3422C2_nt4v100Ev();
extern void _ZN10S3422C2_nt4v101Ev();
extern void _ZN10S3422C2_nt4v102Ev();
extern void _ZN10S3422C2_nt4v103Ev();
extern void _ZN10S3422C2_nt4v104Ev();
extern void _ZN10S3422C2_nt4v105Ev();
extern void _ZN10S3422C2_nt4v106Ev();
extern void _ZN10S3422C2_nt4v107Ev();
extern void _ZN10S3422C2_nt4v108Ev();
extern void _ZN10S3422C2_nt4v109Ev();
extern void _ZN10S3422C2_nt4v110Ev();
extern void _ZN10S3422C2_nt4v111Ev();
extern void _ZN10S3422C2_nt4v112Ev();
extern void _ZN10S3422C2_nt4v113Ev();
extern void _ZN10S3422C2_nt4v114Ev();
extern void _ZN10S3422C2_nt4v115Ev();
extern void _ZN10S3422C2_nt4v116Ev();
extern void _ZN10S3422C2_nt4v117Ev();
extern void _ZN10S3422C2_nt4v118Ev();
extern void _ZN10S3422C2_nt4v119Ev();
extern void _ZN10S3422C2_nt4v120Ev();
extern void _ZN10S3422C2_nt4v121Ev();
extern void _ZN10S3422C2_nt4v122Ev();
extern void _ZN10S3422C2_nt4v123Ev();
extern void _ZN10S3422C2_nt4v124Ev();
extern void _ZN10S3422C2_nt4v125Ev();
extern void _ZN10S3422C2_nt4v126Ev();
extern void _ZN10S3422C2_nt4v127Ev();
extern void _ZN10S3422C2_nt4v128Ev();
extern void _ZN10S3422C2_nt4v129Ev();
extern void _ZN10S3422C2_nt4v130Ev();
extern void _ZN10S3422C2_nt4v131Ev();
extern void _ZN10S3422C2_nt4v132Ev();
extern void _ZN10S3422C2_nt4v133Ev();
extern void _ZN10S3422C2_nt4v134Ev();
extern void _ZN10S3422C2_nt4v135Ev();
extern void _ZN10S3422C2_nt4v136Ev();
extern void _ZN10S3422C2_nt4v137Ev();
extern void _ZN10S3422C2_nt4v138Ev();
extern void _ZN10S3422C2_nt4v139Ev();
extern void _ZN10S3422C2_nt4v140Ev();
extern void _ZN10S3422C2_nt4v141Ev();
extern void _ZN10S3422C2_nt4v142Ev();
extern void _ZN10S3422C2_nt4v143Ev();
extern void _ZN10S3422C2_nt4v144Ev();
extern void _ZN10S3422C2_nt4v145Ev();
extern void _ZN10S3422C2_nt4v146Ev();
extern void _ZN10S3422C2_nt4v147Ev();
extern void _ZN10S3422C2_nt4v148Ev();
extern void _ZN10S3422C2_nt4v149Ev();
extern void _ZN10S3422C2_nt4v150Ev();
extern void _ZN10S3422C2_nt4v151Ev();
extern void _ZN10S3422C2_nt4v152Ev();
extern void _ZN10S3422C2_nt4v153Ev();
extern void _ZN10S3422C2_nt4v154Ev();
extern void _ZN10S3422C2_nt4v155Ev();
extern void _ZN10S3422C2_nt4v156Ev();
extern void _ZN10S3422C2_nt4v157Ev();
extern void _ZN10S3422C2_nt4v158Ev();
extern void _ZN10S3422C2_nt4v159Ev();
extern void _ZN10S3422C2_nt4v160Ev();
extern void _ZN10S3422C2_nt4v161Ev();
extern void _ZN10S3422C2_nt4v162Ev();
extern void _ZN10S3422C2_nt4v163Ev();
extern void _ZN10S3422C2_nt4v164Ev();
extern void _ZN10S3422C2_nt4v165Ev();
extern void _ZN10S3422C2_nt4v166Ev();
extern void _ZN10S3422C2_nt4v167Ev();
extern void _ZN10S3422C2_nt4v168Ev();
extern void _ZN10S3422C2_nt4v169Ev();
extern void _ZN10S3422C2_nt4v170Ev();
extern void _ZN10S3422C2_nt4v171Ev();
extern void _ZN10S3422C2_nt4v172Ev();
extern void _ZN10S3422C2_nt4v173Ev();
extern void _ZN10S3422C2_nt4v174Ev();
extern void _ZN10S3422C2_nt4v175Ev();
extern void _ZN10S3422C2_nt4v176Ev();
extern void _ZN10S3422C2_nt4v177Ev();
extern void _ZN10S3422C2_nt4v178Ev();
extern void _ZN10S3422C2_nt4v179Ev();
extern void _ZN10S3422C2_nt4v180Ev();
extern void _ZN10S3422C2_nt4v181Ev();
extern void _ZN10S3422C2_nt4v182Ev();
extern void _ZN10S3422C2_nt4v183Ev();
extern void _ZN10S3422C2_nt4v184Ev();
extern void _ZN10S3422C2_nt4v185Ev();
extern void _ZN10S3422C2_nt4v186Ev();
extern void _ZN10S3422C2_nt4v187Ev();
extern void _ZN10S3422C2_nt4v188Ev();
extern void _ZN10S3422C2_nt4v189Ev();
extern void _ZN10S3422C2_nt4v190Ev();
extern void _ZN10S3422C2_nt4v191Ev();
extern void _ZN10S3422C2_nt4v192Ev();
extern void _ZN10S3422C2_nt4v193Ev();
extern void _ZN10S3422C2_nt4v194Ev();
extern void _ZN10S3422C2_nt4v195Ev();
extern void _ZN10S3422C2_nt4v196Ev();
extern void _ZN10S3422C2_nt4v197Ev();
extern void _ZN10S3422C2_nt4v198Ev();
extern void _ZN10S3422C2_nt4v199Ev();
extern void _ZN10S3422C2_nt4v200Ev();
extern void _ZN10S3422C2_nt4v201Ev();
extern void _ZN10S3422C2_nt4v202Ev();
extern void _ZN10S3422C2_nt4v203Ev();
extern void _ZN10S3422C2_nt4v204Ev();
extern void _ZN10S3422C2_nt4v205Ev();
extern void _ZN10S3422C2_nt4v206Ev();
extern void _ZN10S3422C2_nt4v207Ev();
extern void _ZN10S3422C2_nt4v208Ev();
extern void _ZN10S3422C2_nt4v209Ev();
extern void _ZN10S3422C2_nt4v210Ev();
extern void _ZN10S3422C2_nt4v211Ev();
extern void _ZN10S3422C2_nt4v212Ev();
extern void _ZN10S3422C2_nt4v213Ev();
extern void _ZN10S3422C2_nt4v214Ev();
static  VTBL_ENTRY vtc_S3422C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3422C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3422C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v214Ev,
};
extern VTBL_ENTRY _ZTI10S3422C2_nt[];
VTBL_ENTRY *P__ZTI10S3422C2_nt = _ZTI10S3422C2_nt; 
extern  VTBL_ENTRY _ZTV10S3422C2_nt[];
Class_Descriptor cd_S3422C2_nt = {  "S3422C2_nt", // class name
  bases_S3422C2_nt, 1,
  &(vtc_S3422C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3422C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3422C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C24  : S3422C7_nt {
};
//SIG(-1 S3422C24) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3422C24()
{
  extern Class_Descriptor cd_S3422C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C24, buf);
    S3422C24 &lv = *(new (buf) S3422C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C24)");
    check_base_class_offset(lv, (S3422C7_nt*), 0, "S3422C24");
    test_class_info(&lv, &cd_S3422C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C24(Test_S3422C24, "S3422C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
static Base_Class bases_S3422C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C24 = {  "S3422C24", // class name
  bases_S3422C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C23  : S3422C24 {
};
//SIG(-1 S3422C23) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3422C23()
{
  extern Class_Descriptor cd_S3422C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3422C23, buf);
    S3422C23 &lv = *(new (buf) S3422C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3422C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C23)");
    check_base_class_offset(lv, (S3422C7_nt*)(S3422C24*), 0, "S3422C23");
    check_base_class_offset(lv, (S3422C24*), 0, "S3422C23");
    test_class_info(&lv, &cd_S3422C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C23(Test_S3422C23, "S3422C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S3422C24;
static Base_Class bases_S3422C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3422C23 = {  "S3422C23", // class name
  bases_S3422C23, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C22_nt  : S3422C23 {
};
//SIG(-1 S3422C22_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S3422C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S3422C24;
extern Class_Descriptor cd_S3422C23;
static Base_Class bases_S3422C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3422C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C25_nt  {
  ::S3422C22_nt s3422c25f0;
  ::S3422C22_nt s3422c25f1;
  ::S3422C22_nt s3422c25f2;
  ::S3422C22_nt s3422c25f3;
  ::S3422C22_nt s3422c25f4;
  ::S3422C22_nt s3422c25f5;
  ::S3422C22_nt s3422c25f6;
  ::S3422C22_nt s3422c25f7;
  unsigned int s3422c25f8:1;
  unsigned int s3422c25f9:1;
  ::S3422C22_nt s3422c25f10;
  ::S3422C22_nt s3422c25f11;
  ::S3422C22_nt s3422c25f12;
  void  mf3422c25(); // _ZN11S3422C25_nt9mf3422c25Ev
};
//SIG(-1 S3422C25_nt) C1{ m FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi:1 Fi:1 FC2 FC2 FC2}


void  S3422C25_nt ::mf3422c25(){}

//skip512 S3422C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C26  {
  int s3422c26f0[7];
  ::S3422C22_nt s3422c26f1;
  void  mf3422c26(); // _ZN8S3422C269mf3422c26Ev
};
//SIG(-1 S3422C26) C1{ m Fi[7] FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}}}


void  S3422C26 ::mf3422c26(){}

static void Test_S3422C26()
{
  {
    init_simple_test("S3422C26");
    S3422C26 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S3422C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C26)");
    check_field_offset(lv, s3422c26f0, 0, "S3422C26.s3422c26f0");
    check_field_offset(lv, s3422c26f1, ABISELECT(32,28), "S3422C26.s3422c26f1");
  }
}
static Arrange_To_Call_Me vS3422C26(Test_S3422C26, "S3422C26", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C21  {
  ::S3422C22_nt s3422c21f0;
  ::S3422C22_nt s3422c21f1;
  ::S3422C22_nt s3422c21f2;
  ::S3422C22_nt s3422c21f3;
  ::S3422C22_nt s3422c21f4;
  ::S3422C25_nt s3422c21f5;
  ::S3422C26 s3422c21f6;
  ::S3422C22_nt s3422c21f7;
  unsigned int s3422c21f8:1;
  unsigned int s3422c21f9:1;
  void  mf3422c21(); // _ZN8S3422C219mf3422c21Ev
};
//SIG(-1 S3422C21) C1{ m FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} FC2 FC2 FC2 FC2 FC6{ m FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi:1 Fi:1 FC2 FC2 FC2} FC7{ m Fi[7] FC2} FC2 Fi:1 Fi:1}


void  S3422C21 ::mf3422c21(){}

static void Test_S3422C21()
{
  {
    init_simple_test("S3422C21");
    static S3422C21 lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S3422C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C21)");
    check_field_offset(lv, s3422c21f0, 0, "S3422C21.s3422c21f0");
    check_field_offset(lv, s3422c21f1, ABISELECT(16,12), "S3422C21.s3422c21f1");
    check_field_offset(lv, s3422c21f2, ABISELECT(32,24), "S3422C21.s3422c21f2");
    check_field_offset(lv, s3422c21f3, ABISELECT(48,36), "S3422C21.s3422c21f3");
    check_field_offset(lv, s3422c21f4, ABISELECT(64,48), "S3422C21.s3422c21f4");
    check_field_offset(lv, s3422c21f5, ABISELECT(80,60), "S3422C21.s3422c21f5");
    check_field_offset(lv, s3422c21f6, ABISELECT(264,196), "S3422C21.s3422c21f6");
    check_field_offset(lv, s3422c21f7, ABISELECT(312,236), "S3422C21.s3422c21f7");
    set_bf_and_test(lv, s3422c21f8, ABISELECT(328,248), 0, 1, 1, "S3422C21");
    set_bf_and_test(lv, s3422c21f9, ABISELECT(328,248), 1, 1, 1, "S3422C21");
  }
}
static Arrange_To_Call_Me vS3422C21(Test_S3422C21, "S3422C21", ABISELECT(336,252));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C27  {
  unsigned int s3422c27f0:1;
  unsigned int s3422c27f1:1;
  unsigned int s3422c27f2:1;
  unsigned int s3422c27f3:1;
  unsigned int s3422c27f4:1;
  unsigned int s3422c27f5:1;
  ::S3422C25_nt s3422c27f6;
  ::S3422C22_nt s3422c27f7;
  void *s3422c27f8[13];
  void  mf3422c27(); // _ZN8S3422C279mf3422c27Ev
};
//SIG(-1 S3422C27) C1{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC2{ m FC3{ BC4{ BC5{ BC6{ m Fp Fi[2]}}}} FC3 FC3 FC3 FC3 FC3 FC3 FC3 Fi:1 Fi:1 FC3 FC3 FC3} FC3 Fp[13]}


void  S3422C27 ::mf3422c27(){}

static void Test_S3422C27()
{
  {
    init_simple_test("S3422C27");
    static S3422C27 lv;
    check2(sizeof(lv), ABISELECT(312,204), "sizeof(S3422C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C27)");
    set_bf_and_test(lv, s3422c27f0, 0, 0, 1, 1, "S3422C27");
    set_bf_and_test(lv, s3422c27f1, 0, 1, 1, 1, "S3422C27");
    set_bf_and_test(lv, s3422c27f2, 0, 2, 1, 1, "S3422C27");
    set_bf_and_test(lv, s3422c27f3, 0, 3, 1, 1, "S3422C27");
    set_bf_and_test(lv, s3422c27f4, 0, 4, 1, 1, "S3422C27");
    set_bf_and_test(lv, s3422c27f5, 0, 5, 1, 1, "S3422C27");
    check_field_offset(lv, s3422c27f6, ABISELECT(8,4), "S3422C27.s3422c27f6");
    check_field_offset(lv, s3422c27f7, ABISELECT(192,140), "S3422C27.s3422c27f7");
    check_field_offset(lv, s3422c27f8, ABISELECT(208,152), "S3422C27.s3422c27f8");
  }
}
static Arrange_To_Call_Me vS3422C27(Test_S3422C27, "S3422C27", ABISELECT(312,204));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C28_nt  {
  void  mf3422c28(); // _ZN11S3422C28_nt9mf3422c28Ev
};
//SIG(-1 S3422C28_nt) C1{ m}


void  S3422C28_nt ::mf3422c28(){}

//skip512 S3422C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3422C1  : S3422C2_nt {
  void *s3422c1f0[11];
  ::S3422C21 s3422c1f1;
  ::S3422C27 s3422c1f2;
  void *s3422c1f3[5];
  ::S3422C22_nt s3422c1f4;
  ::S3422C28_nt s3422c1f5;
  virtual  ~S3422C1(); // _ZN7S3422C1D1Ev
  virtual void  v1(); // _ZN7S3422C12v1Ev
  virtual void  v2(); // _ZN7S3422C12v2Ev
  virtual void  v3(); // _ZN7S3422C12v3Ev
  virtual void  v4(); // _ZN7S3422C12v4Ev
  virtual void  v5(); // _ZN7S3422C12v5Ev
  virtual void  v6(); // _ZN7S3422C12v6Ev
  virtual void  v7(); // _ZN7S3422C12v7Ev
  S3422C1(); // tgen
};
//SIG(1 S3422C1) C1{ BC2{ BC3{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 Fp[11] FC14{ m FC15{ BC16{ BC17{ BC7}}} FC15 FC15 FC15 FC15 FC18{ m FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 Fi:1 Fi:1 FC15 FC15 FC15} FC19{ m Fi[7] FC15} FC15 Fi:1 Fi:1} FC20{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC18 FC15 Fp[13]} Fp[5] FC15 FC21{ m}}


 S3422C1 ::~S3422C1(){ note_dtor("S3422C1", this);}
void  S3422C1 ::v1(){vfunc_called(this, "_ZN7S3422C12v1Ev");}
void  S3422C1 ::v2(){vfunc_called(this, "_ZN7S3422C12v2Ev");}
void  S3422C1 ::v3(){vfunc_called(this, "_ZN7S3422C12v3Ev");}
void  S3422C1 ::v4(){vfunc_called(this, "_ZN7S3422C12v4Ev");}
void  S3422C1 ::v5(){vfunc_called(this, "_ZN7S3422C12v5Ev");}
void  S3422C1 ::v6(){vfunc_called(this, "_ZN7S3422C12v6Ev");}
void  S3422C1 ::v7(){vfunc_called(this, "_ZN7S3422C12v7Ev");}
S3422C1 ::S3422C1(){ note_ctor("S3422C1", this);} // tgen

static void Test_S3422C1()
{
  extern Class_Descriptor cd_S3422C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(172,244)];
    init_test(&cd_S3422C1, buf);
    S3422C1 *dp, &lv = *(dp=new (buf) S3422C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1368,972), "sizeof(S3422C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3422C1)");
    check_base_class_offset(lv, (S3422C3_nt*)(S3422C2_nt*), 0, "S3422C1");
    check_base_class_offset(lv, (S3422C2_nt*), 0, "S3422C1");
    check_field_offset(lv, s3422c1f0, ABISELECT(568,436), "S3422C1.s3422c1f0");
    check_field_offset(lv, s3422c1f1, ABISELECT(656,480), "S3422C1.s3422c1f1");
    check_field_offset(lv, s3422c1f2, ABISELECT(992,732), "S3422C1.s3422c1f2");
    check_field_offset(lv, s3422c1f3, ABISELECT(1304,936), "S3422C1.s3422c1f3");
    check_field_offset(lv, s3422c1f4, ABISELECT(1344,956), "S3422C1.s3422c1f4");
    check_field_offset(lv, s3422c1f5, ABISELECT(1360,968), "S3422C1.s3422c1f5");
    test_class_info(&lv, &cd_S3422C1);
    dp->~S3422C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3422C1(Test_S3422C1, "S3422C1", ABISELECT(1368,972));

#else // __cplusplus

extern void _ZN7S3422C1C1Ev();
extern void _ZN7S3422C1D1Ev();
Name_Map name_map_S3422C1[] = {
  NSPAIR(_ZN7S3422C1C1Ev),
  NSPAIR(_ZN7S3422C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3422C3_nt;
extern VTBL_ENTRY _ZTI10S3422C3_nt[];
extern  VTBL_ENTRY _ZTV10S3422C3_nt[];
extern Class_Descriptor cd_S3422C2_nt;
extern VTBL_ENTRY _ZTI10S3422C2_nt[];
extern  VTBL_ENTRY _ZTV10S3422C2_nt[];
static Base_Class bases_S3422C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3422C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3422C1[];
extern void _ZN7S3422C1D1Ev();
extern void _ZN7S3422C1D0Ev();
extern void _ZN10S3422C3_nt2v8Ev();
extern void _ZN10S3422C3_nt2v9Ev();
extern void _ZN10S3422C3_nt3v10Ev();
extern void _ZN10S3422C3_nt3v11Ev();
extern void _ZN10S3422C3_nt3v12Ev();
extern void _ZN10S3422C3_nt3v13Ev();
extern void _ZN10S3422C3_nt3v14Ev();
extern void _ZN10S3422C3_nt3v15Ev();
extern void _ZN10S3422C3_nt3v16Ev();
extern void _ZN10S3422C3_nt3v17Ev();
extern void _ZN10S3422C3_nt3v18Ev();
extern void _ZN10S3422C3_nt3v19Ev();
extern void _ZN10S3422C3_nt3v20Ev();
extern void _ZN10S3422C3_nt3v21Ev();
extern void _ZN10S3422C3_nt3v22Ev();
extern void _ZN10S3422C3_nt3v23Ev();
extern void _ZN10S3422C3_nt3v24Ev();
extern void _ZN10S3422C3_nt3v25Ev();
extern void _ZN10S3422C3_nt3v26Ev();
extern void _ZN10S3422C3_nt3v27Ev();
extern void _ZN10S3422C3_nt3v28Ev();
extern void _ZN10S3422C3_nt3v29Ev();
extern void _ZN10S3422C3_nt3v30Ev();
extern void _ZN10S3422C3_nt3v31Ev();
extern void _ZN10S3422C3_nt3v32Ev();
extern void _ZN10S3422C3_nt3v33Ev();
extern void _ZN10S3422C3_nt3v34Ev();
extern void _ZN10S3422C3_nt3v35Ev();
extern void _ZN10S3422C3_nt3v36Ev();
extern void _ZN10S3422C3_nt3v37Ev();
extern void _ZN10S3422C3_nt3v38Ev();
extern void _ZN10S3422C3_nt3v39Ev();
extern void _ZN10S3422C3_nt3v40Ev();
extern void _ZN10S3422C3_nt3v41Ev();
extern void _ZN10S3422C3_nt3v42Ev();
extern void _ZN10S3422C3_nt3v43Ev();
extern void _ZN10S3422C3_nt3v44Ev();
extern void _ZN10S3422C3_nt3v45Ev();
extern void _ZN10S3422C3_nt3v46Ev();
extern void _ZN10S3422C3_nt3v47Ev();
extern void _ZN10S3422C3_nt3v48Ev();
extern void _ZN10S3422C3_nt3v49Ev();
extern void _ZN10S3422C3_nt3v50Ev();
extern void _ZN10S3422C3_nt3v51Ev();
extern void _ZN10S3422C3_nt3v52Ev();
extern void _ZN10S3422C3_nt3v53Ev();
extern void _ZN10S3422C3_nt3v54Ev();
extern void _ZN10S3422C3_nt3v55Ev();
extern void _ZN10S3422C3_nt3v56Ev();
extern void _ZN10S3422C3_nt3v57Ev();
extern void _ZN10S3422C3_nt3v58Ev();
extern void _ZN10S3422C3_nt3v59Ev();
extern void _ZN10S3422C3_nt3v60Ev();
extern void _ZN10S3422C3_nt3v61Ev();
extern void _ZN10S3422C3_nt3v62Ev();
extern void _ZN10S3422C3_nt3v63Ev();
extern void _ZN10S3422C3_nt3v64Ev();
extern void _ZN10S3422C3_nt3v65Ev();
extern void _ZN10S3422C3_nt3v66Ev();
extern void _ZN10S3422C3_nt3v67Ev();
extern void _ZN10S3422C3_nt3v68Ev();
extern void _ZN10S3422C3_nt3v69Ev();
extern void _ZN10S3422C3_nt3v70Ev();
extern void _ZN10S3422C3_nt3v71Ev();
extern void _ZN10S3422C2_nt3v72Ev();
extern void _ZN10S3422C2_nt3v73Ev();
extern void _ZN10S3422C2_nt3v74Ev();
extern void _ZN10S3422C2_nt3v75Ev();
extern void _ZN10S3422C2_nt3v76Ev();
extern void _ZN10S3422C2_nt3v77Ev();
extern void _ZN10S3422C2_nt3v78Ev();
extern void _ZN10S3422C2_nt3v79Ev();
extern void _ZN10S3422C2_nt3v80Ev();
extern void _ZN10S3422C2_nt3v81Ev();
extern void _ZN10S3422C2_nt3v82Ev();
extern void _ZN10S3422C2_nt3v83Ev();
extern void _ZN10S3422C2_nt3v84Ev();
extern void _ZN10S3422C2_nt3v85Ev();
extern void _ZN10S3422C2_nt3v86Ev();
extern void _ZN10S3422C2_nt3v87Ev();
extern void _ZN10S3422C2_nt3v88Ev();
extern void _ZN10S3422C2_nt3v89Ev();
extern void _ZN10S3422C2_nt3v90Ev();
extern void _ZN10S3422C2_nt3v91Ev();
extern void _ZN10S3422C2_nt3v92Ev();
extern void _ZN10S3422C2_nt3v93Ev();
extern void _ZN10S3422C2_nt3v94Ev();
extern void _ZN10S3422C2_nt3v95Ev();
extern void _ZN10S3422C2_nt3v96Ev();
extern void _ZN10S3422C2_nt3v97Ev();
extern void _ZN10S3422C2_nt3v98Ev();
extern void _ZN10S3422C2_nt3v99Ev();
extern void _ZN10S3422C2_nt4v100Ev();
extern void _ZN10S3422C2_nt4v101Ev();
extern void _ZN10S3422C2_nt4v102Ev();
extern void _ZN10S3422C2_nt4v103Ev();
extern void _ZN10S3422C2_nt4v104Ev();
extern void _ZN10S3422C2_nt4v105Ev();
extern void _ZN10S3422C2_nt4v106Ev();
extern void _ZN10S3422C2_nt4v107Ev();
extern void _ZN10S3422C2_nt4v108Ev();
extern void _ZN10S3422C2_nt4v109Ev();
extern void _ZN10S3422C2_nt4v110Ev();
extern void _ZN10S3422C2_nt4v111Ev();
extern void _ZN10S3422C2_nt4v112Ev();
extern void _ZN10S3422C2_nt4v113Ev();
extern void _ZN10S3422C2_nt4v114Ev();
extern void _ZN10S3422C2_nt4v115Ev();
extern void _ZN10S3422C2_nt4v116Ev();
extern void _ZN10S3422C2_nt4v117Ev();
extern void _ZN10S3422C2_nt4v118Ev();
extern void _ZN10S3422C2_nt4v119Ev();
extern void _ZN10S3422C2_nt4v120Ev();
extern void _ZN10S3422C2_nt4v121Ev();
extern void _ZN10S3422C2_nt4v122Ev();
extern void _ZN10S3422C2_nt4v123Ev();
extern void _ZN10S3422C2_nt4v124Ev();
extern void _ZN10S3422C2_nt4v125Ev();
extern void _ZN10S3422C2_nt4v126Ev();
extern void _ZN10S3422C2_nt4v127Ev();
extern void _ZN10S3422C2_nt4v128Ev();
extern void _ZN10S3422C2_nt4v129Ev();
extern void _ZN10S3422C2_nt4v130Ev();
extern void _ZN10S3422C2_nt4v131Ev();
extern void _ZN10S3422C2_nt4v132Ev();
extern void _ZN10S3422C2_nt4v133Ev();
extern void _ZN10S3422C2_nt4v134Ev();
extern void _ZN10S3422C2_nt4v135Ev();
extern void _ZN10S3422C2_nt4v136Ev();
extern void _ZN10S3422C2_nt4v137Ev();
extern void _ZN10S3422C2_nt4v138Ev();
extern void _ZN10S3422C2_nt4v139Ev();
extern void _ZN10S3422C2_nt4v140Ev();
extern void _ZN10S3422C2_nt4v141Ev();
extern void _ZN10S3422C2_nt4v142Ev();
extern void _ZN10S3422C2_nt4v143Ev();
extern void _ZN10S3422C2_nt4v144Ev();
extern void _ZN10S3422C2_nt4v145Ev();
extern void _ZN10S3422C2_nt4v146Ev();
extern void _ZN10S3422C2_nt4v147Ev();
extern void _ZN10S3422C2_nt4v148Ev();
extern void _ZN10S3422C2_nt4v149Ev();
extern void _ZN10S3422C2_nt4v150Ev();
extern void _ZN10S3422C2_nt4v151Ev();
extern void _ZN10S3422C2_nt4v152Ev();
extern void _ZN10S3422C2_nt4v153Ev();
extern void _ZN10S3422C2_nt4v154Ev();
extern void _ZN10S3422C2_nt4v155Ev();
extern void _ZN10S3422C2_nt4v156Ev();
extern void _ZN10S3422C2_nt4v157Ev();
extern void _ZN10S3422C2_nt4v158Ev();
extern void _ZN10S3422C2_nt4v159Ev();
extern void _ZN10S3422C2_nt4v160Ev();
extern void _ZN10S3422C2_nt4v161Ev();
extern void _ZN10S3422C2_nt4v162Ev();
extern void _ZN10S3422C2_nt4v163Ev();
extern void _ZN10S3422C2_nt4v164Ev();
extern void _ZN10S3422C2_nt4v165Ev();
extern void _ZN10S3422C2_nt4v166Ev();
extern void _ZN10S3422C2_nt4v167Ev();
extern void _ZN10S3422C2_nt4v168Ev();
extern void _ZN10S3422C2_nt4v169Ev();
extern void _ZN10S3422C2_nt4v170Ev();
extern void _ZN10S3422C2_nt4v171Ev();
extern void _ZN10S3422C2_nt4v172Ev();
extern void _ZN10S3422C2_nt4v173Ev();
extern void _ZN10S3422C2_nt4v174Ev();
extern void _ZN10S3422C2_nt4v175Ev();
extern void _ZN10S3422C2_nt4v176Ev();
extern void _ZN10S3422C2_nt4v177Ev();
extern void _ZN10S3422C2_nt4v178Ev();
extern void _ZN10S3422C2_nt4v179Ev();
extern void _ZN10S3422C2_nt4v180Ev();
extern void _ZN10S3422C2_nt4v181Ev();
extern void _ZN10S3422C2_nt4v182Ev();
extern void _ZN10S3422C2_nt4v183Ev();
extern void _ZN10S3422C2_nt4v184Ev();
extern void _ZN10S3422C2_nt4v185Ev();
extern void _ZN10S3422C2_nt4v186Ev();
extern void _ZN10S3422C2_nt4v187Ev();
extern void _ZN10S3422C2_nt4v188Ev();
extern void _ZN10S3422C2_nt4v189Ev();
extern void _ZN10S3422C2_nt4v190Ev();
extern void _ZN10S3422C2_nt4v191Ev();
extern void _ZN10S3422C2_nt4v192Ev();
extern void _ZN10S3422C2_nt4v193Ev();
extern void _ZN10S3422C2_nt4v194Ev();
extern void _ZN10S3422C2_nt4v195Ev();
extern void _ZN10S3422C2_nt4v196Ev();
extern void _ZN10S3422C2_nt4v197Ev();
extern void _ZN10S3422C2_nt4v198Ev();
extern void _ZN10S3422C2_nt4v199Ev();
extern void _ZN10S3422C2_nt4v200Ev();
extern void _ZN10S3422C2_nt4v201Ev();
extern void _ZN10S3422C2_nt4v202Ev();
extern void _ZN10S3422C2_nt4v203Ev();
extern void _ZN10S3422C2_nt4v204Ev();
extern void _ZN10S3422C2_nt4v205Ev();
extern void _ZN10S3422C2_nt4v206Ev();
extern void _ZN10S3422C2_nt4v207Ev();
extern void _ZN10S3422C2_nt4v208Ev();
extern void _ZN10S3422C2_nt4v209Ev();
extern void _ZN10S3422C2_nt4v210Ev();
extern void _ZN10S3422C2_nt4v211Ev();
extern void _ZN10S3422C2_nt4v212Ev();
extern void _ZN10S3422C2_nt4v213Ev();
extern void _ZN10S3422C2_nt4v214Ev();
extern void _ZN7S3422C12v1Ev();
extern void _ZN7S3422C12v2Ev();
extern void _ZN7S3422C12v3Ev();
extern void _ZN7S3422C12v4Ev();
extern void _ZN7S3422C12v5Ev();
extern void _ZN7S3422C12v6Ev();
extern void _ZN7S3422C12v7Ev();
static  VTBL_ENTRY vtc_S3422C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3422C1[0]),
  (VTBL_ENTRY)&_ZN7S3422C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3422C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3422C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S3422C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3422C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S3422C1[];
extern  VTBL_ENTRY _ZTV7S3422C1[];
Class_Descriptor cd_S3422C1 = {  "S3422C1", // class name
  bases_S3422C1, 2,
  &(vtc_S3422C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1368,972), // object size
  NSPAIRA(_ZTI7S3422C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3422C1),218, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C7_nt  {
  void  mf5167c7(); // _ZN10S5167C7_nt8mf5167c7Ev
};
//SIG(-1 S5167C7_nt) C1{ m}


void  S5167C7_nt ::mf5167c7(){}

//skip512 S5167C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C5_nt  {
  void *s5167c5f0;
  int s5167c5f1;
  ::S3422C28_nt s5167c5f2;
  ::S5167C7_nt s5167c5f3;
  void  mf5167c5(); // _ZN10S5167C5_nt8mf5167c5Ev
};
//SIG(-1 S5167C5_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S5167C5_nt ::mf5167c5(){}

//skip512 S5167C5_nt

#else // __cplusplus

Class_Descriptor cd_S5167C5_nt = {  "S5167C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C4_nt  : S5167C5_nt {
};
//SIG(-1 S5167C4_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S5167C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S5167C5_nt;
static Base_Class bases_S5167C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5167C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C3_nt  {
  void *s5167c3f0;
  int s5167c3f1;
  ::S5167C4_nt s5167c3f2;
  ::S5167C4_nt s5167c3f3;
  int s5167c3f4;
  virtual  ~S5167C3_nt(); // _ZN10S5167C3_ntD1Ev
  virtual void  v4(); // _ZN10S5167C3_nt2v4Ev
  virtual void  v5(); // _ZN10S5167C3_nt2v5Ev
  virtual void  v6(); // _ZN10S5167C3_nt2v6Ev
  virtual void  v7(); // _ZN10S5167C3_nt2v7Ev
  virtual void  v8(); // _ZN10S5167C3_nt2v8Ev
  virtual void  v9(); // _ZN10S5167C3_nt2v9Ev
  virtual void  v10(); // _ZN10S5167C3_nt3v10Ev
  virtual void  v11(); // _ZN10S5167C3_nt3v11Ev
  virtual void  v12(); // _ZN10S5167C3_nt3v12Ev
  virtual void  v13(); // _ZN10S5167C3_nt3v13Ev
  virtual void  v14(); // _ZN10S5167C3_nt3v14Ev
  virtual void  v15(); // _ZN10S5167C3_nt3v15Ev
  virtual void  v16(); // _ZN10S5167C3_nt3v16Ev
  virtual void  v17(); // _ZN10S5167C3_nt3v17Ev
  virtual void  v18(); // _ZN10S5167C3_nt3v18Ev
  virtual void  v19(); // _ZN10S5167C3_nt3v19Ev
  virtual void  v20(); // _ZN10S5167C3_nt3v20Ev
  virtual void  v21(); // _ZN10S5167C3_nt3v21Ev
  virtual void  v22(); // _ZN10S5167C3_nt3v22Ev
  virtual void  v23(); // _ZN10S5167C3_nt3v23Ev
  virtual void  v24(); // _ZN10S5167C3_nt3v24Ev
  virtual void  v25(); // _ZN10S5167C3_nt3v25Ev
  virtual void  v26(); // _ZN10S5167C3_nt3v26Ev
  S5167C3_nt(); // tgen
};
//SIG(-1 S5167C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S5167C3_nt ::~S5167C3_nt(){ note_dtor("S5167C3_nt", this);}
void  S5167C3_nt ::v4(){vfunc_called(this, "_ZN10S5167C3_nt2v4Ev");}
void  S5167C3_nt ::v5(){vfunc_called(this, "_ZN10S5167C3_nt2v5Ev");}
void  S5167C3_nt ::v6(){vfunc_called(this, "_ZN10S5167C3_nt2v6Ev");}
void  S5167C3_nt ::v7(){vfunc_called(this, "_ZN10S5167C3_nt2v7Ev");}
void  S5167C3_nt ::v8(){vfunc_called(this, "_ZN10S5167C3_nt2v8Ev");}
void  S5167C3_nt ::v9(){vfunc_called(this, "_ZN10S5167C3_nt2v9Ev");}
void  S5167C3_nt ::v10(){vfunc_called(this, "_ZN10S5167C3_nt3v10Ev");}
void  S5167C3_nt ::v11(){vfunc_called(this, "_ZN10S5167C3_nt3v11Ev");}
void  S5167C3_nt ::v12(){vfunc_called(this, "_ZN10S5167C3_nt3v12Ev");}
void  S5167C3_nt ::v13(){vfunc_called(this, "_ZN10S5167C3_nt3v13Ev");}
void  S5167C3_nt ::v14(){vfunc_called(this, "_ZN10S5167C3_nt3v14Ev");}
void  S5167C3_nt ::v15(){vfunc_called(this, "_ZN10S5167C3_nt3v15Ev");}
void  S5167C3_nt ::v16(){vfunc_called(this, "_ZN10S5167C3_nt3v16Ev");}
void  S5167C3_nt ::v17(){vfunc_called(this, "_ZN10S5167C3_nt3v17Ev");}
void  S5167C3_nt ::v18(){vfunc_called(this, "_ZN10S5167C3_nt3v18Ev");}
void  S5167C3_nt ::v19(){vfunc_called(this, "_ZN10S5167C3_nt3v19Ev");}
void  S5167C3_nt ::v20(){vfunc_called(this, "_ZN10S5167C3_nt3v20Ev");}
void  S5167C3_nt ::v21(){vfunc_called(this, "_ZN10S5167C3_nt3v21Ev");}
void  S5167C3_nt ::v22(){vfunc_called(this, "_ZN10S5167C3_nt3v22Ev");}
void  S5167C3_nt ::v23(){vfunc_called(this, "_ZN10S5167C3_nt3v23Ev");}
void  S5167C3_nt ::v24(){vfunc_called(this, "_ZN10S5167C3_nt3v24Ev");}
void  S5167C3_nt ::v25(){vfunc_called(this, "_ZN10S5167C3_nt3v25Ev");}
void  S5167C3_nt ::v26(){vfunc_called(this, "_ZN10S5167C3_nt3v26Ev");}
S5167C3_nt ::S5167C3_nt(){ note_ctor("S5167C3_nt", this);} // tgen

//skip512 S5167C3_nt

#else // __cplusplus

extern void _ZN10S5167C3_ntC1Ev();
extern void _ZN10S5167C3_ntD1Ev();
Name_Map name_map_S5167C3_nt[] = {
  NSPAIR(_ZN10S5167C3_ntC1Ev),
  NSPAIR(_ZN10S5167C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S5167C3_nt[];
extern void _ZN10S5167C3_ntD1Ev();
extern void _ZN10S5167C3_ntD0Ev();
extern void _ZN10S5167C3_nt2v4Ev();
extern void _ZN10S5167C3_nt2v5Ev();
extern void _ZN10S5167C3_nt2v6Ev();
extern void _ZN10S5167C3_nt2v7Ev();
extern void _ZN10S5167C3_nt2v8Ev();
extern void _ZN10S5167C3_nt2v9Ev();
extern void _ZN10S5167C3_nt3v10Ev();
extern void _ZN10S5167C3_nt3v11Ev();
extern void _ZN10S5167C3_nt3v12Ev();
extern void _ZN10S5167C3_nt3v13Ev();
extern void _ZN10S5167C3_nt3v14Ev();
extern void _ZN10S5167C3_nt3v15Ev();
extern void _ZN10S5167C3_nt3v16Ev();
extern void _ZN10S5167C3_nt3v17Ev();
extern void _ZN10S5167C3_nt3v18Ev();
extern void _ZN10S5167C3_nt3v19Ev();
extern void _ZN10S5167C3_nt3v20Ev();
extern void _ZN10S5167C3_nt3v21Ev();
extern void _ZN10S5167C3_nt3v22Ev();
extern void _ZN10S5167C3_nt3v23Ev();
extern void _ZN10S5167C3_nt3v24Ev();
extern void _ZN10S5167C3_nt3v25Ev();
extern void _ZN10S5167C3_nt3v26Ev();
static  VTBL_ENTRY vtc_S5167C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5167C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S5167C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v26Ev,
};
extern VTBL_ENTRY _ZTI10S5167C3_nt[];
VTBL_ENTRY *P__ZTI10S5167C3_nt = _ZTI10S5167C3_nt; 
extern  VTBL_ENTRY _ZTV10S5167C3_nt[];
Class_Descriptor cd_S5167C3_nt = {  "S5167C3_nt", // class name
  0,0,//no base classes
  &(vtc_S5167C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S5167C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S5167C3_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C13_nt  {
  __tsi64 s5167c13f0[2];
  void  mf5167c13(); // _ZN11S5167C13_nt9mf5167c13Ev
};
//SIG(-1 S5167C13_nt) C1{ m FL[2]}


void  S5167C13_nt ::mf5167c13(){}

//skip512 S5167C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C12_nt  {
  ::S5167C13_nt s5167c12f0;
  void  mf5167c12(); // _ZN11S5167C12_nt9mf5167c12Ev
};
//SIG(-1 S5167C12_nt) C1{ m FC2{ m FL[2]}}


void  S5167C12_nt ::mf5167c12(){}

//skip512 S5167C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C16_nt  {
  ::S5167C12_nt s5167c16f0;
  void  mf5167c16(); // _ZN11S5167C16_nt9mf5167c16Ev
};
//SIG(-1 S5167C16_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S5167C16_nt ::mf5167c16(){}

//skip512 S5167C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C17_nt  {
  ::S5167C12_nt s5167c17f0;
  ::S5167C12_nt s5167c17f1;
  ::S5167C12_nt s5167c17f2;
  ::S5167C12_nt s5167c17f3;
  void  mf5167c17(); // _ZN11S5167C17_nt9mf5167c17Ev
};
//SIG(-1 S5167C17_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S5167C17_nt ::mf5167c17(){}

//skip512 S5167C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C19_nt  {
  void *s5167c19f0;
  int s5167c19f1;
  ::S5167C7_nt s5167c19f2;
  void  mf5167c19(); // _ZN11S5167C19_nt9mf5167c19Ev
};
//SIG(-1 S5167C19_nt) C1{ m Fp Fi FC2{ m}}


void  S5167C19_nt ::mf5167c19(){}

//skip512 S5167C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C18_nt  {
  ::S5167C19_nt s5167c18f0;
  int s5167c18f1;
  void  mf5167c18(); // _ZN11S5167C18_nt9mf5167c18Ev
};
//SIG(-1 S5167C18_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S5167C18_nt ::mf5167c18(){}

//skip512 S5167C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C22  {
  void  mf5167c22(); // _ZN8S5167C229mf5167c22Ev
};
//SIG(-1 S5167C22) C1{ m}


void  S5167C22 ::mf5167c22(){}

static void Test_S5167C22()
{
  {
    init_simple_test("S5167C22");
    S5167C22 lv;
    check2(sizeof(lv), 1, "sizeof(S5167C22)");
    check2(__alignof__(lv), 1, "__alignof__(S5167C22)");
  }
}
static Arrange_To_Call_Me vS5167C22(Test_S5167C22, "S5167C22", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C21  {
  void *s5167c21f0;
  int s5167c21f1;
  ::S5167C22 s5167c21f2;
  ::S5167C22 s5167c21f3;
  void  mf5167c21(); // _ZN8S5167C219mf5167c21Ev
};
//SIG(-1 S5167C21) C1{ m Fp Fi FC2{ m} FC2}


void  S5167C21 ::mf5167c21(){}

static void Test_S5167C21()
{
  {
    init_simple_test("S5167C21");
    S5167C21 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5167C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5167C21)");
    check_field_offset(lv, s5167c21f0, 0, "S5167C21.s5167c21f0");
    check_field_offset(lv, s5167c21f1, ABISELECT(8,4), "S5167C21.s5167c21f1");
    check_field_offset(lv, s5167c21f2, ABISELECT(12,8), "S5167C21.s5167c21f2");
    check_field_offset(lv, s5167c21f3, ABISELECT(13,9), "S5167C21.s5167c21f3");
  }
}
static Arrange_To_Call_Me vS5167C21(Test_S5167C21, "S5167C21", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C26  {
  void  mf5167c26(); // _ZN8S5167C269mf5167c26Ev
};
//SIG(-1 S5167C26) C1{ m}


void  S5167C26 ::mf5167c26(){}

static void Test_S5167C26()
{
  {
    init_simple_test("S5167C26");
    S5167C26 lv;
    check2(sizeof(lv), 1, "sizeof(S5167C26)");
    check2(__alignof__(lv), 1, "__alignof__(S5167C26)");
  }
}
static Arrange_To_Call_Me vS5167C26(Test_S5167C26, "S5167C26", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C25  {
  void *s5167c25f0;
  int s5167c25f1;
  ::S5167C26 s5167c25f2;
  ::S5167C26 s5167c25f3;
  void  mf5167c25(); // _ZN8S5167C259mf5167c25Ev
};
//SIG(-1 S5167C25) C1{ m Fp Fi FC2{ m} FC2}


void  S5167C25 ::mf5167c25(){}

static void Test_S5167C25()
{
  {
    init_simple_test("S5167C25");
    S5167C25 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5167C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5167C25)");
    check_field_offset(lv, s5167c25f0, 0, "S5167C25.s5167c25f0");
    check_field_offset(lv, s5167c25f1, ABISELECT(8,4), "S5167C25.s5167c25f1");
    check_field_offset(lv, s5167c25f2, ABISELECT(12,8), "S5167C25.s5167c25f2");
    check_field_offset(lv, s5167c25f3, ABISELECT(13,9), "S5167C25.s5167c25f3");
  }
}
static Arrange_To_Call_Me vS5167C25(Test_S5167C25, "S5167C25", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S5167C25 = {  "S5167C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C24  : S5167C25 {
};
//SIG(-1 S5167C24) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S5167C24()
{
  extern Class_Descriptor cd_S5167C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S5167C24, buf);
    S5167C24 &lv = *(new (buf) S5167C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S5167C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5167C24)");
    check_base_class_offset(lv, (S5167C25*), 0, "S5167C24");
    test_class_info(&lv, &cd_S5167C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5167C24(Test_S5167C24, "S5167C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S5167C25;
static Base_Class bases_S5167C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5167C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S5167C24 = {  "S5167C24", // class name
  bases_S5167C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C29  {
  void  mf5167c29(); // _ZN8S5167C299mf5167c29Ev
};
//SIG(-1 S5167C29) C1{ m}


void  S5167C29 ::mf5167c29(){}

static void Test_S5167C29()
{
  {
    init_simple_test("S5167C29");
    S5167C29 lv;
    check2(sizeof(lv), 1, "sizeof(S5167C29)");
    check2(__alignof__(lv), 1, "__alignof__(S5167C29)");
  }
}
static Arrange_To_Call_Me vS5167C29(Test_S5167C29, "S5167C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S5167C29[];
VTBL_ENTRY *P__ZTI8S5167C29 = _ZTI8S5167C29; 
Class_Descriptor cd_S5167C29 = {  "S5167C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S5167C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C28_nt  {
  void *s5167c28f0;
  int s5167c28f1[2];
  ::S5167C29 s5167c28f2;
  void  mf5167c28(); // _ZN11S5167C28_nt9mf5167c28Ev
};
//SIG(-1 S5167C28_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S5167C28_nt ::mf5167c28(){}

//skip512 S5167C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C36  {
  void *s5167c36f0;
  int s5167c36f1[2];
  ::S5167C29 s5167c36f2;
  void  mf5167c36(); // _ZN8S5167C369mf5167c36Ev
};
//SIG(-1 S5167C36) C1{ m Fp Fi[2] FC2{ m}}


void  S5167C36 ::mf5167c36(){}

static void Test_S5167C36()
{
  {
    init_simple_test("S5167C36");
    S5167C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S5167C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5167C36)");
    check_field_offset(lv, s5167c36f0, 0, "S5167C36.s5167c36f0");
    check_field_offset(lv, s5167c36f1, ABISELECT(8,4), "S5167C36.s5167c36f1");
    check_field_offset(lv, s5167c36f2, ABISELECT(16,12), "S5167C36.s5167c36f2");
  }
}
static Arrange_To_Call_Me vS5167C36(Test_S5167C36, "S5167C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C2_nt  : S5167C3_nt {
  ::S5167C12_nt s5167c2f0;
  ::S5167C12_nt s5167c2f1;
  ::S5167C12_nt s5167c2f2;
  ::S5167C12_nt s5167c2f3;
  ::S5167C16_nt s5167c2f4;
  ::S5167C17_nt s5167c2f5;
  ::S5167C17_nt s5167c2f6;
  ::S5167C12_nt s5167c2f7;
  ::S5167C12_nt s5167c2f8;
  ::S5167C12_nt s5167c2f9;
  void *s5167c2f10;
  ::S5167C16_nt s5167c2f11;
  ::S5167C18_nt s5167c2f12;
  int s5167c2f13;
  void *s5167c2f14[7];
  ::S5167C21 s5167c2f15;
  int s5167c2f16:8;
  int s5167c2f17:8;
  int s5167c2f18:16;
  int s5167c2f19:16;
  int s5167c2f20:8;
  int s5167c2f21:8;
  int s5167c2f22:8;
  int s5167c2f23:32;
  int s5167c2f24:8;
  int s5167c2f25:4;
  int s5167c2f26:4;
  int s5167c2f27:4;
  int s5167c2f28:4;
  int s5167c2f29:4;
  int s5167c2f30:4;
  int s5167c2f31:4;
  int s5167c2f32:4;
  int s5167c2f33:4;
  int s5167c2f34:4;
  unsigned char s5167c2f35:1;
  unsigned char s5167c2f36:1;
  unsigned char s5167c2f37:1;
  unsigned char s5167c2f38:1;
  unsigned char s5167c2f39:1;
  unsigned char s5167c2f40:1;
  unsigned char s5167c2f41:1;
  unsigned char s5167c2f42:1;
  unsigned char s5167c2f43:1;
  unsigned char s5167c2f44:1;
  unsigned char s5167c2f45:1;
  unsigned char s5167c2f46:1;
  unsigned char s5167c2f47:1;
  unsigned char s5167c2f48:1;
  unsigned char s5167c2f49:1;
  unsigned char s5167c2f50:1;
  unsigned char s5167c2f51:1;
  unsigned char s5167c2f52:1;
  unsigned char s5167c2f53:1;
  unsigned char s5167c2f54:1;
  unsigned char s5167c2f55:1;
  unsigned char s5167c2f56:1;
  unsigned char s5167c2f57:1;
  unsigned char s5167c2f58:1;
  unsigned char s5167c2f59:1;
  unsigned char s5167c2f60:1;
  unsigned char s5167c2f61:1;
  unsigned char s5167c2f62:1;
  unsigned char s5167c2f63:1;
  unsigned char s5167c2f64:1;
  unsigned char s5167c2f65:1;
  unsigned char s5167c2f66:1;
  unsigned char s5167c2f67:1;
  unsigned char s5167c2f68:1;
  unsigned char s5167c2f69:1;
  unsigned char s5167c2f70:1;
  unsigned char s5167c2f71:1;
  unsigned char s5167c2f72:1;
  unsigned char s5167c2f73:1;
  unsigned char s5167c2f74:1;
  unsigned char s5167c2f75:1;
  int s5167c2f76[7];
  void *s5167c2f77[6];
  int s5167c2f78:8;
  int s5167c2f79:8;
  int s5167c2f80:8;
  int s5167c2f81:8;
  int s5167c2f82:8;
  int s5167c2f83:8;
  ::S5167C24 s5167c2f84;
  void *s5167c2f85[4];
  int s5167c2f86:8;
  int s5167c2f87:8;
  int s5167c2f88:8;
  int s5167c2f89:8;
  int s5167c2f90:8;
  int s5167c2f91:16;
  int s5167c2f92:16;
  int s5167c2f93:16;
  int s5167c2f94:4;
  int s5167c2f95:4;
  int s5167c2f96:4;
  int s5167c2f97:4;
  int s5167c2f98:4;
  int s5167c2f99:4;
  int s5167c2f100:4;
  int s5167c2f101:4;
  int s5167c2f102:4;
  int s5167c2f103:4;
  int s5167c2f104:4;
  int s5167c2f105:4;
  int s5167c2f106:8;
  int s5167c2f107:8;
  int s5167c2f108:8;
  void *s5167c2f109[7];
  ::S5167C28_nt s5167c2f110;
  void *s5167c2f111[2];
  int s5167c2f112:16;
  int s5167c2f113:16;
  ::S5167C24 s5167c2f114;
  ::S5167C28_nt s5167c2f115;
  ::S5167C36 s5167c2f116;
  void *s5167c2f117[2];
  int s5167c2f118:24;
  int s5167c2f119:8;
  void *s5167c2f120;
  virtual  ~S5167C2_nt(); // _ZN10S5167C2_ntD1Ev
  virtual void  v27(); // _ZN10S5167C2_nt3v27Ev
  virtual void  v28(); // _ZN10S5167C2_nt3v28Ev
  virtual void  v29(); // _ZN10S5167C2_nt3v29Ev
  virtual void  v30(); // _ZN10S5167C2_nt3v30Ev
  virtual void  v31(); // _ZN10S5167C2_nt3v31Ev
  virtual void  v32(); // _ZN10S5167C2_nt3v32Ev
  virtual void  v33(); // _ZN10S5167C2_nt3v33Ev
  virtual void  v34(); // _ZN10S5167C2_nt3v34Ev
  virtual void  v35(); // _ZN10S5167C2_nt3v35Ev
  virtual void  v36(); // _ZN10S5167C2_nt3v36Ev
  virtual void  v37(); // _ZN10S5167C2_nt3v37Ev
  virtual void  v38(); // _ZN10S5167C2_nt3v38Ev
  virtual void  v39(); // _ZN10S5167C2_nt3v39Ev
  virtual void  v40(); // _ZN10S5167C2_nt3v40Ev
  virtual void  v41(); // _ZN10S5167C2_nt3v41Ev
  virtual void  v42(); // _ZN10S5167C2_nt3v42Ev
  virtual void  v43(); // _ZN10S5167C2_nt3v43Ev
  virtual void  v44(); // _ZN10S5167C2_nt3v44Ev
  virtual void  v45(); // _ZN10S5167C2_nt3v45Ev
  virtual void  v46(); // _ZN10S5167C2_nt3v46Ev
  virtual void  v47(); // _ZN10S5167C2_nt3v47Ev
  virtual void  v48(); // _ZN10S5167C2_nt3v48Ev
  virtual void  v49(); // _ZN10S5167C2_nt3v49Ev
  virtual void  v50(); // _ZN10S5167C2_nt3v50Ev
  virtual void  v51(); // _ZN10S5167C2_nt3v51Ev
  virtual void  v52(); // _ZN10S5167C2_nt3v52Ev
  virtual void  v53(); // _ZN10S5167C2_nt3v53Ev
  virtual void  v54(); // _ZN10S5167C2_nt3v54Ev
  virtual void  v55(); // _ZN10S5167C2_nt3v55Ev
  virtual void  v56(); // _ZN10S5167C2_nt3v56Ev
  virtual void  v57(); // _ZN10S5167C2_nt3v57Ev
  virtual void  v58(); // _ZN10S5167C2_nt3v58Ev
  virtual void  v59(); // _ZN10S5167C2_nt3v59Ev
  virtual void  v60(); // _ZN10S5167C2_nt3v60Ev
  virtual void  v61(); // _ZN10S5167C2_nt3v61Ev
  virtual void  v62(); // _ZN10S5167C2_nt3v62Ev
  virtual void  v63(); // _ZN10S5167C2_nt3v63Ev
  virtual void  v64(); // _ZN10S5167C2_nt3v64Ev
  virtual void  v65(); // _ZN10S5167C2_nt3v65Ev
  virtual void  v66(); // _ZN10S5167C2_nt3v66Ev
  virtual void  v67(); // _ZN10S5167C2_nt3v67Ev
  virtual void  v68(); // _ZN10S5167C2_nt3v68Ev
  virtual void  v69(); // _ZN10S5167C2_nt3v69Ev
  virtual void  v70(); // _ZN10S5167C2_nt3v70Ev
  virtual void  v71(); // _ZN10S5167C2_nt3v71Ev
  virtual void  v72(); // _ZN10S5167C2_nt3v72Ev
  virtual void  v73(); // _ZN10S5167C2_nt3v73Ev
  virtual void  v74(); // _ZN10S5167C2_nt3v74Ev
  virtual void  v75(); // _ZN10S5167C2_nt3v75Ev
  virtual void  v76(); // _ZN10S5167C2_nt3v76Ev
  virtual void  v77(); // _ZN10S5167C2_nt3v77Ev
  virtual void  v78(); // _ZN10S5167C2_nt3v78Ev
  virtual void  v79(); // _ZN10S5167C2_nt3v79Ev
  virtual void  v80(); // _ZN10S5167C2_nt3v80Ev
  virtual void  v81(); // _ZN10S5167C2_nt3v81Ev
  virtual void  v82(); // _ZN10S5167C2_nt3v82Ev
  virtual void  v83(); // _ZN10S5167C2_nt3v83Ev
  virtual void  v84(); // _ZN10S5167C2_nt3v84Ev
  virtual void  v85(); // _ZN10S5167C2_nt3v85Ev
  virtual void  v86(); // _ZN10S5167C2_nt3v86Ev
  virtual void  v87(); // _ZN10S5167C2_nt3v87Ev
  virtual void  v88(); // _ZN10S5167C2_nt3v88Ev
  virtual void  v89(); // _ZN10S5167C2_nt3v89Ev
  virtual void  v90(); // _ZN10S5167C2_nt3v90Ev
  virtual void  v91(); // _ZN10S5167C2_nt3v91Ev
  virtual void  v92(); // _ZN10S5167C2_nt3v92Ev
  virtual void  v93(); // _ZN10S5167C2_nt3v93Ev
  virtual void  v94(); // _ZN10S5167C2_nt3v94Ev
  virtual void  v95(); // _ZN10S5167C2_nt3v95Ev
  virtual void  v96(); // _ZN10S5167C2_nt3v96Ev
  virtual void  v97(); // _ZN10S5167C2_nt3v97Ev
  virtual void  v98(); // _ZN10S5167C2_nt3v98Ev
  virtual void  v99(); // _ZN10S5167C2_nt3v99Ev
  virtual void  v100(); // _ZN10S5167C2_nt4v100Ev
  virtual void  v101(); // _ZN10S5167C2_nt4v101Ev
  virtual void  v102(); // _ZN10S5167C2_nt4v102Ev
  virtual void  v103(); // _ZN10S5167C2_nt4v103Ev
  virtual void  v104(); // _ZN10S5167C2_nt4v104Ev
  S5167C2_nt(); // tgen
};
//SIG(-1 S5167C2_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S5167C2_nt ::~S5167C2_nt(){ note_dtor("S5167C2_nt", this);}
void  S5167C2_nt ::v27(){vfunc_called(this, "_ZN10S5167C2_nt3v27Ev");}
void  S5167C2_nt ::v28(){vfunc_called(this, "_ZN10S5167C2_nt3v28Ev");}
void  S5167C2_nt ::v29(){vfunc_called(this, "_ZN10S5167C2_nt3v29Ev");}
void  S5167C2_nt ::v30(){vfunc_called(this, "_ZN10S5167C2_nt3v30Ev");}
void  S5167C2_nt ::v31(){vfunc_called(this, "_ZN10S5167C2_nt3v31Ev");}
void  S5167C2_nt ::v32(){vfunc_called(this, "_ZN10S5167C2_nt3v32Ev");}
void  S5167C2_nt ::v33(){vfunc_called(this, "_ZN10S5167C2_nt3v33Ev");}
void  S5167C2_nt ::v34(){vfunc_called(this, "_ZN10S5167C2_nt3v34Ev");}
void  S5167C2_nt ::v35(){vfunc_called(this, "_ZN10S5167C2_nt3v35Ev");}
void  S5167C2_nt ::v36(){vfunc_called(this, "_ZN10S5167C2_nt3v36Ev");}
void  S5167C2_nt ::v37(){vfunc_called(this, "_ZN10S5167C2_nt3v37Ev");}
void  S5167C2_nt ::v38(){vfunc_called(this, "_ZN10S5167C2_nt3v38Ev");}
void  S5167C2_nt ::v39(){vfunc_called(this, "_ZN10S5167C2_nt3v39Ev");}
void  S5167C2_nt ::v40(){vfunc_called(this, "_ZN10S5167C2_nt3v40Ev");}
void  S5167C2_nt ::v41(){vfunc_called(this, "_ZN10S5167C2_nt3v41Ev");}
void  S5167C2_nt ::v42(){vfunc_called(this, "_ZN10S5167C2_nt3v42Ev");}
void  S5167C2_nt ::v43(){vfunc_called(this, "_ZN10S5167C2_nt3v43Ev");}
void  S5167C2_nt ::v44(){vfunc_called(this, "_ZN10S5167C2_nt3v44Ev");}
void  S5167C2_nt ::v45(){vfunc_called(this, "_ZN10S5167C2_nt3v45Ev");}
void  S5167C2_nt ::v46(){vfunc_called(this, "_ZN10S5167C2_nt3v46Ev");}
void  S5167C2_nt ::v47(){vfunc_called(this, "_ZN10S5167C2_nt3v47Ev");}
void  S5167C2_nt ::v48(){vfunc_called(this, "_ZN10S5167C2_nt3v48Ev");}
void  S5167C2_nt ::v49(){vfunc_called(this, "_ZN10S5167C2_nt3v49Ev");}
void  S5167C2_nt ::v50(){vfunc_called(this, "_ZN10S5167C2_nt3v50Ev");}
void  S5167C2_nt ::v51(){vfunc_called(this, "_ZN10S5167C2_nt3v51Ev");}
void  S5167C2_nt ::v52(){vfunc_called(this, "_ZN10S5167C2_nt3v52Ev");}
void  S5167C2_nt ::v53(){vfunc_called(this, "_ZN10S5167C2_nt3v53Ev");}
void  S5167C2_nt ::v54(){vfunc_called(this, "_ZN10S5167C2_nt3v54Ev");}
void  S5167C2_nt ::v55(){vfunc_called(this, "_ZN10S5167C2_nt3v55Ev");}
void  S5167C2_nt ::v56(){vfunc_called(this, "_ZN10S5167C2_nt3v56Ev");}
void  S5167C2_nt ::v57(){vfunc_called(this, "_ZN10S5167C2_nt3v57Ev");}
void  S5167C2_nt ::v58(){vfunc_called(this, "_ZN10S5167C2_nt3v58Ev");}
void  S5167C2_nt ::v59(){vfunc_called(this, "_ZN10S5167C2_nt3v59Ev");}
void  S5167C2_nt ::v60(){vfunc_called(this, "_ZN10S5167C2_nt3v60Ev");}
void  S5167C2_nt ::v61(){vfunc_called(this, "_ZN10S5167C2_nt3v61Ev");}
void  S5167C2_nt ::v62(){vfunc_called(this, "_ZN10S5167C2_nt3v62Ev");}
void  S5167C2_nt ::v63(){vfunc_called(this, "_ZN10S5167C2_nt3v63Ev");}
void  S5167C2_nt ::v64(){vfunc_called(this, "_ZN10S5167C2_nt3v64Ev");}
void  S5167C2_nt ::v65(){vfunc_called(this, "_ZN10S5167C2_nt3v65Ev");}
void  S5167C2_nt ::v66(){vfunc_called(this, "_ZN10S5167C2_nt3v66Ev");}
void  S5167C2_nt ::v67(){vfunc_called(this, "_ZN10S5167C2_nt3v67Ev");}
void  S5167C2_nt ::v68(){vfunc_called(this, "_ZN10S5167C2_nt3v68Ev");}
void  S5167C2_nt ::v69(){vfunc_called(this, "_ZN10S5167C2_nt3v69Ev");}
void  S5167C2_nt ::v70(){vfunc_called(this, "_ZN10S5167C2_nt3v70Ev");}
void  S5167C2_nt ::v71(){vfunc_called(this, "_ZN10S5167C2_nt3v71Ev");}
void  S5167C2_nt ::v72(){vfunc_called(this, "_ZN10S5167C2_nt3v72Ev");}
void  S5167C2_nt ::v73(){vfunc_called(this, "_ZN10S5167C2_nt3v73Ev");}
void  S5167C2_nt ::v74(){vfunc_called(this, "_ZN10S5167C2_nt3v74Ev");}
void  S5167C2_nt ::v75(){vfunc_called(this, "_ZN10S5167C2_nt3v75Ev");}
void  S5167C2_nt ::v76(){vfunc_called(this, "_ZN10S5167C2_nt3v76Ev");}
void  S5167C2_nt ::v77(){vfunc_called(this, "_ZN10S5167C2_nt3v77Ev");}
void  S5167C2_nt ::v78(){vfunc_called(this, "_ZN10S5167C2_nt3v78Ev");}
void  S5167C2_nt ::v79(){vfunc_called(this, "_ZN10S5167C2_nt3v79Ev");}
void  S5167C2_nt ::v80(){vfunc_called(this, "_ZN10S5167C2_nt3v80Ev");}
void  S5167C2_nt ::v81(){vfunc_called(this, "_ZN10S5167C2_nt3v81Ev");}
void  S5167C2_nt ::v82(){vfunc_called(this, "_ZN10S5167C2_nt3v82Ev");}
void  S5167C2_nt ::v83(){vfunc_called(this, "_ZN10S5167C2_nt3v83Ev");}
void  S5167C2_nt ::v84(){vfunc_called(this, "_ZN10S5167C2_nt3v84Ev");}
void  S5167C2_nt ::v85(){vfunc_called(this, "_ZN10S5167C2_nt3v85Ev");}
void  S5167C2_nt ::v86(){vfunc_called(this, "_ZN10S5167C2_nt3v86Ev");}
void  S5167C2_nt ::v87(){vfunc_called(this, "_ZN10S5167C2_nt3v87Ev");}
void  S5167C2_nt ::v88(){vfunc_called(this, "_ZN10S5167C2_nt3v88Ev");}
void  S5167C2_nt ::v89(){vfunc_called(this, "_ZN10S5167C2_nt3v89Ev");}
void  S5167C2_nt ::v90(){vfunc_called(this, "_ZN10S5167C2_nt3v90Ev");}
void  S5167C2_nt ::v91(){vfunc_called(this, "_ZN10S5167C2_nt3v91Ev");}
void  S5167C2_nt ::v92(){vfunc_called(this, "_ZN10S5167C2_nt3v92Ev");}
void  S5167C2_nt ::v93(){vfunc_called(this, "_ZN10S5167C2_nt3v93Ev");}
void  S5167C2_nt ::v94(){vfunc_called(this, "_ZN10S5167C2_nt3v94Ev");}
void  S5167C2_nt ::v95(){vfunc_called(this, "_ZN10S5167C2_nt3v95Ev");}
void  S5167C2_nt ::v96(){vfunc_called(this, "_ZN10S5167C2_nt3v96Ev");}
void  S5167C2_nt ::v97(){vfunc_called(this, "_ZN10S5167C2_nt3v97Ev");}
void  S5167C2_nt ::v98(){vfunc_called(this, "_ZN10S5167C2_nt3v98Ev");}
void  S5167C2_nt ::v99(){vfunc_called(this, "_ZN10S5167C2_nt3v99Ev");}
void  S5167C2_nt ::v100(){vfunc_called(this, "_ZN10S5167C2_nt4v100Ev");}
void  S5167C2_nt ::v101(){vfunc_called(this, "_ZN10S5167C2_nt4v101Ev");}
void  S5167C2_nt ::v102(){vfunc_called(this, "_ZN10S5167C2_nt4v102Ev");}
void  S5167C2_nt ::v103(){vfunc_called(this, "_ZN10S5167C2_nt4v103Ev");}
void  S5167C2_nt ::v104(){vfunc_called(this, "_ZN10S5167C2_nt4v104Ev");}
S5167C2_nt ::S5167C2_nt(){ note_ctor("S5167C2_nt", this);} // tgen

//skip512 S5167C2_nt

#else // __cplusplus

extern void _ZN10S5167C2_ntC1Ev();
extern void _ZN10S5167C2_ntD1Ev();
Name_Map name_map_S5167C2_nt[] = {
  NSPAIR(_ZN10S5167C2_ntC1Ev),
  NSPAIR(_ZN10S5167C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5167C3_nt;
extern VTBL_ENTRY _ZTI10S5167C3_nt[];
extern  VTBL_ENTRY _ZTV10S5167C3_nt[];
static Base_Class bases_S5167C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5167C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S5167C2_nt[];
extern void _ZN10S5167C2_ntD1Ev();
extern void _ZN10S5167C2_ntD0Ev();
extern void _ZN10S5167C3_nt2v4Ev();
extern void _ZN10S5167C3_nt2v5Ev();
extern void _ZN10S5167C3_nt2v6Ev();
extern void _ZN10S5167C3_nt2v7Ev();
extern void _ZN10S5167C3_nt2v8Ev();
extern void _ZN10S5167C3_nt2v9Ev();
extern void _ZN10S5167C3_nt3v10Ev();
extern void _ZN10S5167C3_nt3v11Ev();
extern void _ZN10S5167C3_nt3v12Ev();
extern void _ZN10S5167C3_nt3v13Ev();
extern void _ZN10S5167C3_nt3v14Ev();
extern void _ZN10S5167C3_nt3v15Ev();
extern void _ZN10S5167C3_nt3v16Ev();
extern void _ZN10S5167C3_nt3v17Ev();
extern void _ZN10S5167C3_nt3v18Ev();
extern void _ZN10S5167C3_nt3v19Ev();
extern void _ZN10S5167C3_nt3v20Ev();
extern void _ZN10S5167C3_nt3v21Ev();
extern void _ZN10S5167C3_nt3v22Ev();
extern void _ZN10S5167C3_nt3v23Ev();
extern void _ZN10S5167C3_nt3v24Ev();
extern void _ZN10S5167C3_nt3v25Ev();
extern void _ZN10S5167C3_nt3v26Ev();
extern void _ZN10S5167C2_nt3v27Ev();
extern void _ZN10S5167C2_nt3v28Ev();
extern void _ZN10S5167C2_nt3v29Ev();
extern void _ZN10S5167C2_nt3v30Ev();
extern void _ZN10S5167C2_nt3v31Ev();
extern void _ZN10S5167C2_nt3v32Ev();
extern void _ZN10S5167C2_nt3v33Ev();
extern void _ZN10S5167C2_nt3v34Ev();
extern void _ZN10S5167C2_nt3v35Ev();
extern void _ZN10S5167C2_nt3v36Ev();
extern void _ZN10S5167C2_nt3v37Ev();
extern void _ZN10S5167C2_nt3v38Ev();
extern void _ZN10S5167C2_nt3v39Ev();
extern void _ZN10S5167C2_nt3v40Ev();
extern void _ZN10S5167C2_nt3v41Ev();
extern void _ZN10S5167C2_nt3v42Ev();
extern void _ZN10S5167C2_nt3v43Ev();
extern void _ZN10S5167C2_nt3v44Ev();
extern void _ZN10S5167C2_nt3v45Ev();
extern void _ZN10S5167C2_nt3v46Ev();
extern void _ZN10S5167C2_nt3v47Ev();
extern void _ZN10S5167C2_nt3v48Ev();
extern void _ZN10S5167C2_nt3v49Ev();
extern void _ZN10S5167C2_nt3v50Ev();
extern void _ZN10S5167C2_nt3v51Ev();
extern void _ZN10S5167C2_nt3v52Ev();
extern void _ZN10S5167C2_nt3v53Ev();
extern void _ZN10S5167C2_nt3v54Ev();
extern void _ZN10S5167C2_nt3v55Ev();
extern void _ZN10S5167C2_nt3v56Ev();
extern void _ZN10S5167C2_nt3v57Ev();
extern void _ZN10S5167C2_nt3v58Ev();
extern void _ZN10S5167C2_nt3v59Ev();
extern void _ZN10S5167C2_nt3v60Ev();
extern void _ZN10S5167C2_nt3v61Ev();
extern void _ZN10S5167C2_nt3v62Ev();
extern void _ZN10S5167C2_nt3v63Ev();
extern void _ZN10S5167C2_nt3v64Ev();
extern void _ZN10S5167C2_nt3v65Ev();
extern void _ZN10S5167C2_nt3v66Ev();
extern void _ZN10S5167C2_nt3v67Ev();
extern void _ZN10S5167C2_nt3v68Ev();
extern void _ZN10S5167C2_nt3v69Ev();
extern void _ZN10S5167C2_nt3v70Ev();
extern void _ZN10S5167C2_nt3v71Ev();
extern void _ZN10S5167C2_nt3v72Ev();
extern void _ZN10S5167C2_nt3v73Ev();
extern void _ZN10S5167C2_nt3v74Ev();
extern void _ZN10S5167C2_nt3v75Ev();
extern void _ZN10S5167C2_nt3v76Ev();
extern void _ZN10S5167C2_nt3v77Ev();
extern void _ZN10S5167C2_nt3v78Ev();
extern void _ZN10S5167C2_nt3v79Ev();
extern void _ZN10S5167C2_nt3v80Ev();
extern void _ZN10S5167C2_nt3v81Ev();
extern void _ZN10S5167C2_nt3v82Ev();
extern void _ZN10S5167C2_nt3v83Ev();
extern void _ZN10S5167C2_nt3v84Ev();
extern void _ZN10S5167C2_nt3v85Ev();
extern void _ZN10S5167C2_nt3v86Ev();
extern void _ZN10S5167C2_nt3v87Ev();
extern void _ZN10S5167C2_nt3v88Ev();
extern void _ZN10S5167C2_nt3v89Ev();
extern void _ZN10S5167C2_nt3v90Ev();
extern void _ZN10S5167C2_nt3v91Ev();
extern void _ZN10S5167C2_nt3v92Ev();
extern void _ZN10S5167C2_nt3v93Ev();
extern void _ZN10S5167C2_nt3v94Ev();
extern void _ZN10S5167C2_nt3v95Ev();
extern void _ZN10S5167C2_nt3v96Ev();
extern void _ZN10S5167C2_nt3v97Ev();
extern void _ZN10S5167C2_nt3v98Ev();
extern void _ZN10S5167C2_nt3v99Ev();
extern void _ZN10S5167C2_nt4v100Ev();
extern void _ZN10S5167C2_nt4v101Ev();
extern void _ZN10S5167C2_nt4v102Ev();
extern void _ZN10S5167C2_nt4v103Ev();
extern void _ZN10S5167C2_nt4v104Ev();
static  VTBL_ENTRY vtc_S5167C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S5167C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S5167C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v104Ev,
};
extern VTBL_ENTRY _ZTI10S5167C2_nt[];
VTBL_ENTRY *P__ZTI10S5167C2_nt = _ZTI10S5167C2_nt; 
extern  VTBL_ENTRY _ZTV10S5167C2_nt[];
Class_Descriptor cd_S5167C2_nt = {  "S5167C2_nt", // class name
  bases_S5167C2_nt, 1,
  &(vtc_S5167C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S5167C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S5167C2_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S5167C1  : S5167C2_nt {
  void *s5167c1f0[2];
  virtual  ~S5167C1(); // _ZN7S5167C1D1Ev
  virtual void  v1(); // _ZN7S5167C12v1Ev
  virtual void  v2(); // _ZN7S5167C12v2Ev
  virtual void  v3(); // _ZN7S5167C12v3Ev
  S5167C1(); // tgen
};
//SIG(1 S5167C1) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 Fp[2]}


 S5167C1 ::~S5167C1(){ note_dtor("S5167C1", this);}
void  S5167C1 ::v1(){vfunc_called(this, "_ZN7S5167C12v1Ev");}
void  S5167C1 ::v2(){vfunc_called(this, "_ZN7S5167C12v2Ev");}
void  S5167C1 ::v3(){vfunc_called(this, "_ZN7S5167C12v3Ev");}
S5167C1 ::S5167C1(){ note_ctor("S5167C1", this);} // tgen

static void Test_S5167C1()
{
  extern Class_Descriptor cd_S5167C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(107,161)];
    init_test(&cd_S5167C1, buf);
    S5167C1 *dp, &lv = *(dp=new (buf) S5167C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(848,640), "sizeof(S5167C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S5167C1)");
    check_base_class_offset(lv, (S5167C3_nt*)(S5167C2_nt*), 0, "S5167C1");
    check_base_class_offset(lv, (S5167C2_nt*), 0, "S5167C1");
    check_field_offset(lv, s5167c1f0, ABISELECT(832,632), "S5167C1.s5167c1f0");
    test_class_info(&lv, &cd_S5167C1);
    dp->~S5167C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS5167C1(Test_S5167C1, "S5167C1", ABISELECT(848,640));

#else // __cplusplus

extern void _ZN7S5167C1C1Ev();
extern void _ZN7S5167C1D1Ev();
Name_Map name_map_S5167C1[] = {
  NSPAIR(_ZN7S5167C1C1Ev),
  NSPAIR(_ZN7S5167C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S5167C3_nt;
extern VTBL_ENTRY _ZTI10S5167C3_nt[];
extern  VTBL_ENTRY _ZTV10S5167C3_nt[];
extern Class_Descriptor cd_S5167C2_nt;
extern VTBL_ENTRY _ZTI10S5167C2_nt[];
extern  VTBL_ENTRY _ZTV10S5167C2_nt[];
static Base_Class bases_S5167C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S5167C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S5167C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S5167C1[];
extern void _ZN7S5167C1D1Ev();
extern void _ZN7S5167C1D0Ev();
extern void _ZN10S5167C3_nt2v4Ev();
extern void _ZN10S5167C3_nt2v5Ev();
extern void _ZN10S5167C3_nt2v6Ev();
extern void _ZN10S5167C3_nt2v7Ev();
extern void _ZN10S5167C3_nt2v8Ev();
extern void _ZN10S5167C3_nt2v9Ev();
extern void _ZN10S5167C3_nt3v10Ev();
extern void _ZN10S5167C3_nt3v11Ev();
extern void _ZN10S5167C3_nt3v12Ev();
extern void _ZN10S5167C3_nt3v13Ev();
extern void _ZN10S5167C3_nt3v14Ev();
extern void _ZN10S5167C3_nt3v15Ev();
extern void _ZN10S5167C3_nt3v16Ev();
extern void _ZN10S5167C3_nt3v17Ev();
extern void _ZN10S5167C3_nt3v18Ev();
extern void _ZN10S5167C3_nt3v19Ev();
extern void _ZN10S5167C3_nt3v20Ev();
extern void _ZN10S5167C3_nt3v21Ev();
extern void _ZN10S5167C3_nt3v22Ev();
extern void _ZN10S5167C3_nt3v23Ev();
extern void _ZN10S5167C3_nt3v24Ev();
extern void _ZN10S5167C3_nt3v25Ev();
extern void _ZN10S5167C3_nt3v26Ev();
extern void _ZN10S5167C2_nt3v27Ev();
extern void _ZN10S5167C2_nt3v28Ev();
extern void _ZN10S5167C2_nt3v29Ev();
extern void _ZN10S5167C2_nt3v30Ev();
extern void _ZN10S5167C2_nt3v31Ev();
extern void _ZN10S5167C2_nt3v32Ev();
extern void _ZN10S5167C2_nt3v33Ev();
extern void _ZN10S5167C2_nt3v34Ev();
extern void _ZN10S5167C2_nt3v35Ev();
extern void _ZN10S5167C2_nt3v36Ev();
extern void _ZN10S5167C2_nt3v37Ev();
extern void _ZN10S5167C2_nt3v38Ev();
extern void _ZN10S5167C2_nt3v39Ev();
extern void _ZN10S5167C2_nt3v40Ev();
extern void _ZN10S5167C2_nt3v41Ev();
extern void _ZN10S5167C2_nt3v42Ev();
extern void _ZN10S5167C2_nt3v43Ev();
extern void _ZN10S5167C2_nt3v44Ev();
extern void _ZN10S5167C2_nt3v45Ev();
extern void _ZN10S5167C2_nt3v46Ev();
extern void _ZN10S5167C2_nt3v47Ev();
extern void _ZN10S5167C2_nt3v48Ev();
extern void _ZN10S5167C2_nt3v49Ev();
extern void _ZN10S5167C2_nt3v50Ev();
extern void _ZN10S5167C2_nt3v51Ev();
extern void _ZN10S5167C2_nt3v52Ev();
extern void _ZN10S5167C2_nt3v53Ev();
extern void _ZN10S5167C2_nt3v54Ev();
extern void _ZN10S5167C2_nt3v55Ev();
extern void _ZN10S5167C2_nt3v56Ev();
extern void _ZN10S5167C2_nt3v57Ev();
extern void _ZN10S5167C2_nt3v58Ev();
extern void _ZN10S5167C2_nt3v59Ev();
extern void _ZN10S5167C2_nt3v60Ev();
extern void _ZN10S5167C2_nt3v61Ev();
extern void _ZN10S5167C2_nt3v62Ev();
extern void _ZN10S5167C2_nt3v63Ev();
extern void _ZN10S5167C2_nt3v64Ev();
extern void _ZN10S5167C2_nt3v65Ev();
extern void _ZN10S5167C2_nt3v66Ev();
extern void _ZN10S5167C2_nt3v67Ev();
extern void _ZN10S5167C2_nt3v68Ev();
extern void _ZN10S5167C2_nt3v69Ev();
extern void _ZN10S5167C2_nt3v70Ev();
extern void _ZN10S5167C2_nt3v71Ev();
extern void _ZN10S5167C2_nt3v72Ev();
extern void _ZN10S5167C2_nt3v73Ev();
extern void _ZN10S5167C2_nt3v74Ev();
extern void _ZN10S5167C2_nt3v75Ev();
extern void _ZN10S5167C2_nt3v76Ev();
extern void _ZN10S5167C2_nt3v77Ev();
extern void _ZN10S5167C2_nt3v78Ev();
extern void _ZN10S5167C2_nt3v79Ev();
extern void _ZN10S5167C2_nt3v80Ev();
extern void _ZN10S5167C2_nt3v81Ev();
extern void _ZN10S5167C2_nt3v82Ev();
extern void _ZN10S5167C2_nt3v83Ev();
extern void _ZN10S5167C2_nt3v84Ev();
extern void _ZN10S5167C2_nt3v85Ev();
extern void _ZN10S5167C2_nt3v86Ev();
extern void _ZN10S5167C2_nt3v87Ev();
extern void _ZN10S5167C2_nt3v88Ev();
extern void _ZN10S5167C2_nt3v89Ev();
extern void _ZN10S5167C2_nt3v90Ev();
extern void _ZN10S5167C2_nt3v91Ev();
extern void _ZN10S5167C2_nt3v92Ev();
extern void _ZN10S5167C2_nt3v93Ev();
extern void _ZN10S5167C2_nt3v94Ev();
extern void _ZN10S5167C2_nt3v95Ev();
extern void _ZN10S5167C2_nt3v96Ev();
extern void _ZN10S5167C2_nt3v97Ev();
extern void _ZN10S5167C2_nt3v98Ev();
extern void _ZN10S5167C2_nt3v99Ev();
extern void _ZN10S5167C2_nt4v100Ev();
extern void _ZN10S5167C2_nt4v101Ev();
extern void _ZN10S5167C2_nt4v102Ev();
extern void _ZN10S5167C2_nt4v103Ev();
extern void _ZN10S5167C2_nt4v104Ev();
extern void _ZN7S5167C12v1Ev();
extern void _ZN7S5167C12v2Ev();
extern void _ZN7S5167C12v3Ev();
static  VTBL_ENTRY vtc_S5167C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S5167C1[0]),
  (VTBL_ENTRY)&_ZN7S5167C1D1Ev,
  (VTBL_ENTRY)&_ZN7S5167C1D0Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S5167C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S5167C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN7S5167C12v1Ev,
  (VTBL_ENTRY)&_ZN7S5167C12v2Ev,
  (VTBL_ENTRY)&_ZN7S5167C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S5167C1[];
extern  VTBL_ENTRY _ZTV7S5167C1[];
Class_Descriptor cd_S5167C1 = {  "S5167C1", // class name
  bases_S5167C1, 2,
  &(vtc_S5167C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(848,640), // object size
  NSPAIRA(_ZTI7S5167C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S5167C1),108, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C7  {
  int s49c7f0;
  __tsi64 s49c7f1;
  void *s49c7f2[4];
  int s49c7f3[2];
  void *s49c7f4;
  ::S3422C4_nt s49c7f5;
  void *s49c7f6[2];
  virtual  ~S49C7(); // _ZN5S49C7D1Ev
  virtual void  v11(); // _ZN5S49C73v11Ev
  virtual void  v12(); // _ZN5S49C73v12Ev
  virtual void  v13(); // _ZN5S49C73v13Ev
  virtual void  v14(); // _ZN5S49C73v14Ev
  virtual void  v15(); // _ZN5S49C73v15Ev
  virtual void  v16(); // _ZN5S49C73v16Ev
  virtual void  v17(); // _ZN5S49C73v17Ev
  virtual void  v18(); // _ZN5S49C73v18Ev
  virtual void  v19(); // _ZN5S49C73v19Ev
  virtual void  v20(); // _ZN5S49C73v20Ev
  virtual void  v21(); // _ZN5S49C73v21Ev
  virtual void  v22(); // _ZN5S49C73v22Ev
  virtual void  v23(); // _ZN5S49C73v23Ev
  virtual void  v24(); // _ZN5S49C73v24Ev
  virtual void  v25(); // _ZN5S49C73v25Ev
  virtual void  v26(); // _ZN5S49C73v26Ev
  virtual void  v27(); // _ZN5S49C73v27Ev
  virtual void  v28(); // _ZN5S49C73v28Ev
  virtual void  v29(); // _ZN5S49C73v29Ev
  virtual void  v30(); // _ZN5S49C73v30Ev
  virtual void  v31(); // _ZN5S49C73v31Ev
  virtual void  v32(); // _ZN5S49C73v32Ev
  virtual void  v33(); // _ZN5S49C73v33Ev
  virtual void  v34(); // _ZN5S49C73v34Ev
  virtual void  v35(); // _ZN5S49C73v35Ev
  virtual void  v36(); // _ZN5S49C73v36Ev
  virtual void  v37(); // _ZN5S49C73v37Ev
  virtual void  v38(); // _ZN5S49C73v38Ev
  virtual void  v39(); // _ZN5S49C73v39Ev
  virtual void  v40(); // _ZN5S49C73v40Ev
  virtual void  v41(); // _ZN5S49C73v41Ev
  virtual void  v42(); // _ZN5S49C73v42Ev
  virtual void  v43(); // _ZN5S49C73v43Ev
  virtual void  v44(); // _ZN5S49C73v44Ev
  virtual void  v45(); // _ZN5S49C73v45Ev
  virtual void  v46(); // _ZN5S49C73v46Ev
  virtual void  v47(); // _ZN5S49C73v47Ev
  virtual void  v48(); // _ZN5S49C73v48Ev
  virtual void  v49(); // _ZN5S49C73v49Ev
  virtual void  v50(); // _ZN5S49C73v50Ev
  virtual void  v51(); // _ZN5S49C73v51Ev
  virtual void  v52(); // _ZN5S49C73v52Ev
  virtual void  v53(); // _ZN5S49C73v53Ev
  virtual void  v54(); // _ZN5S49C73v54Ev
  virtual void  v55(); // _ZN5S49C73v55Ev
  virtual void  v56(); // _ZN5S49C73v56Ev
  virtual void  v57(); // _ZN5S49C73v57Ev
  virtual void  v58(); // _ZN5S49C73v58Ev
  virtual void  v59(); // _ZN5S49C73v59Ev
  virtual void  v60(); // _ZN5S49C73v60Ev
  virtual void  v61(); // _ZN5S49C73v61Ev
  virtual void  v62(); // _ZN5S49C73v62Ev
  virtual void  v63(); // _ZN5S49C73v63Ev
  virtual void  v64(); // _ZN5S49C73v64Ev
  virtual void  v65(); // _ZN5S49C73v65Ev
  virtual void  v66(); // _ZN5S49C73v66Ev
  virtual void  v67(); // _ZN5S49C73v67Ev
  virtual void  v68(); // _ZN5S49C73v68Ev
  virtual void  v69(); // _ZN5S49C73v69Ev
  virtual void  v70(); // _ZN5S49C73v70Ev
  virtual void  v71(); // _ZN5S49C73v71Ev
  virtual void  v72(); // _ZN5S49C73v72Ev
  virtual void  v73(); // _ZN5S49C73v73Ev
  virtual void  v74(); // _ZN5S49C73v74Ev
  S49C7(); // tgen
};
//SIG(-1 S49C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S49C7 ::~S49C7(){ note_dtor("S49C7", this);}
void  S49C7 ::v11(){vfunc_called(this, "_ZN5S49C73v11Ev");}
void  S49C7 ::v12(){vfunc_called(this, "_ZN5S49C73v12Ev");}
void  S49C7 ::v13(){vfunc_called(this, "_ZN5S49C73v13Ev");}
void  S49C7 ::v14(){vfunc_called(this, "_ZN5S49C73v14Ev");}
void  S49C7 ::v15(){vfunc_called(this, "_ZN5S49C73v15Ev");}
void  S49C7 ::v16(){vfunc_called(this, "_ZN5S49C73v16Ev");}
void  S49C7 ::v17(){vfunc_called(this, "_ZN5S49C73v17Ev");}
void  S49C7 ::v18(){vfunc_called(this, "_ZN5S49C73v18Ev");}
void  S49C7 ::v19(){vfunc_called(this, "_ZN5S49C73v19Ev");}
void  S49C7 ::v20(){vfunc_called(this, "_ZN5S49C73v20Ev");}
void  S49C7 ::v21(){vfunc_called(this, "_ZN5S49C73v21Ev");}
void  S49C7 ::v22(){vfunc_called(this, "_ZN5S49C73v22Ev");}
void  S49C7 ::v23(){vfunc_called(this, "_ZN5S49C73v23Ev");}
void  S49C7 ::v24(){vfunc_called(this, "_ZN5S49C73v24Ev");}
void  S49C7 ::v25(){vfunc_called(this, "_ZN5S49C73v25Ev");}
void  S49C7 ::v26(){vfunc_called(this, "_ZN5S49C73v26Ev");}
void  S49C7 ::v27(){vfunc_called(this, "_ZN5S49C73v27Ev");}
void  S49C7 ::v28(){vfunc_called(this, "_ZN5S49C73v28Ev");}
void  S49C7 ::v29(){vfunc_called(this, "_ZN5S49C73v29Ev");}
void  S49C7 ::v30(){vfunc_called(this, "_ZN5S49C73v30Ev");}
void  S49C7 ::v31(){vfunc_called(this, "_ZN5S49C73v31Ev");}
void  S49C7 ::v32(){vfunc_called(this, "_ZN5S49C73v32Ev");}
void  S49C7 ::v33(){vfunc_called(this, "_ZN5S49C73v33Ev");}
void  S49C7 ::v34(){vfunc_called(this, "_ZN5S49C73v34Ev");}
void  S49C7 ::v35(){vfunc_called(this, "_ZN5S49C73v35Ev");}
void  S49C7 ::v36(){vfunc_called(this, "_ZN5S49C73v36Ev");}
void  S49C7 ::v37(){vfunc_called(this, "_ZN5S49C73v37Ev");}
void  S49C7 ::v38(){vfunc_called(this, "_ZN5S49C73v38Ev");}
void  S49C7 ::v39(){vfunc_called(this, "_ZN5S49C73v39Ev");}
void  S49C7 ::v40(){vfunc_called(this, "_ZN5S49C73v40Ev");}
void  S49C7 ::v41(){vfunc_called(this, "_ZN5S49C73v41Ev");}
void  S49C7 ::v42(){vfunc_called(this, "_ZN5S49C73v42Ev");}
void  S49C7 ::v43(){vfunc_called(this, "_ZN5S49C73v43Ev");}
void  S49C7 ::v44(){vfunc_called(this, "_ZN5S49C73v44Ev");}
void  S49C7 ::v45(){vfunc_called(this, "_ZN5S49C73v45Ev");}
void  S49C7 ::v46(){vfunc_called(this, "_ZN5S49C73v46Ev");}
void  S49C7 ::v47(){vfunc_called(this, "_ZN5S49C73v47Ev");}
void  S49C7 ::v48(){vfunc_called(this, "_ZN5S49C73v48Ev");}
void  S49C7 ::v49(){vfunc_called(this, "_ZN5S49C73v49Ev");}
void  S49C7 ::v50(){vfunc_called(this, "_ZN5S49C73v50Ev");}
void  S49C7 ::v51(){vfunc_called(this, "_ZN5S49C73v51Ev");}
void  S49C7 ::v52(){vfunc_called(this, "_ZN5S49C73v52Ev");}
void  S49C7 ::v53(){vfunc_called(this, "_ZN5S49C73v53Ev");}
void  S49C7 ::v54(){vfunc_called(this, "_ZN5S49C73v54Ev");}
void  S49C7 ::v55(){vfunc_called(this, "_ZN5S49C73v55Ev");}
void  S49C7 ::v56(){vfunc_called(this, "_ZN5S49C73v56Ev");}
void  S49C7 ::v57(){vfunc_called(this, "_ZN5S49C73v57Ev");}
void  S49C7 ::v58(){vfunc_called(this, "_ZN5S49C73v58Ev");}
void  S49C7 ::v59(){vfunc_called(this, "_ZN5S49C73v59Ev");}
void  S49C7 ::v60(){vfunc_called(this, "_ZN5S49C73v60Ev");}
void  S49C7 ::v61(){vfunc_called(this, "_ZN5S49C73v61Ev");}
void  S49C7 ::v62(){vfunc_called(this, "_ZN5S49C73v62Ev");}
void  S49C7 ::v63(){vfunc_called(this, "_ZN5S49C73v63Ev");}
void  S49C7 ::v64(){vfunc_called(this, "_ZN5S49C73v64Ev");}
void  S49C7 ::v65(){vfunc_called(this, "_ZN5S49C73v65Ev");}
void  S49C7 ::v66(){vfunc_called(this, "_ZN5S49C73v66Ev");}
void  S49C7 ::v67(){vfunc_called(this, "_ZN5S49C73v67Ev");}
void  S49C7 ::v68(){vfunc_called(this, "_ZN5S49C73v68Ev");}
void  S49C7 ::v69(){vfunc_called(this, "_ZN5S49C73v69Ev");}
void  S49C7 ::v70(){vfunc_called(this, "_ZN5S49C73v70Ev");}
void  S49C7 ::v71(){vfunc_called(this, "_ZN5S49C73v71Ev");}
void  S49C7 ::v72(){vfunc_called(this, "_ZN5S49C73v72Ev");}
void  S49C7 ::v73(){vfunc_called(this, "_ZN5S49C73v73Ev");}
void  S49C7 ::v74(){vfunc_called(this, "_ZN5S49C73v74Ev");}
S49C7 ::S49C7(){ note_ctor("S49C7", this);} // tgen

static void Test_S49C7()
{
  extern Class_Descriptor cd_S49C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S49C7, buf);
    S49C7 *dp, &lv = *(dp=new (buf) S49C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S49C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C7)");
    check_field_offset(lv, s49c7f0, ABISELECT(8,4), "S49C7.s49c7f0");
    check_field_offset(lv, s49c7f1, ABISELECT(16,8), "S49C7.s49c7f1");
    check_field_offset(lv, s49c7f2, ABISELECT(24,16), "S49C7.s49c7f2");
    check_field_offset(lv, s49c7f3, ABISELECT(56,32), "S49C7.s49c7f3");
    check_field_offset(lv, s49c7f4, ABISELECT(64,40), "S49C7.s49c7f4");
    check_field_offset(lv, s49c7f5, ABISELECT(72,44), "S49C7.s49c7f5");
    check_field_offset(lv, s49c7f6, ABISELECT(80,52), "S49C7.s49c7f6");
    test_class_info(&lv, &cd_S49C7);
    dp->~S49C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C7(Test_S49C7, "S49C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S49C7C1Ev();
extern void _ZN5S49C7D1Ev();
Name_Map name_map_S49C7[] = {
  NSPAIR(_ZN5S49C7C1Ev),
  NSPAIR(_ZN5S49C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S49C7[];
extern void _ZN5S49C7D1Ev();
extern void _ZN5S49C7D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
static  VTBL_ENTRY vtc_S49C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C7[0]),
  (VTBL_ENTRY)&_ZN5S49C7D1Ev,
  (VTBL_ENTRY)&_ZN5S49C7D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
};
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
Class_Descriptor cd_S49C7 = {  "S49C7", // class name
  0,0,//no base classes
  &(vtc_S49C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S49C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S49C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C6_nt  : S49C7 {
  virtual  ~S49C6_nt(); // _ZN8S49C6_ntD1Ev
  virtual void  v75(); // _ZN8S49C6_nt3v75Ev
  virtual void  v76(); // _ZN8S49C6_nt3v76Ev
  S49C6_nt(); // tgen
};
//SIG(-1 S49C6_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S49C6_nt ::~S49C6_nt(){ note_dtor("S49C6_nt", this);}
void  S49C6_nt ::v75(){vfunc_called(this, "_ZN8S49C6_nt3v75Ev");}
void  S49C6_nt ::v76(){vfunc_called(this, "_ZN8S49C6_nt3v76Ev");}
S49C6_nt ::S49C6_nt(){ note_ctor("S49C6_nt", this);} // tgen

//skip512 S49C6_nt

#else // __cplusplus

extern void _ZN8S49C6_ntC1Ev();
extern void _ZN8S49C6_ntD1Ev();
Name_Map name_map_S49C6_nt[] = {
  NSPAIR(_ZN8S49C6_ntC1Ev),
  NSPAIR(_ZN8S49C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
static Base_Class bases_S49C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern void _ZN8S49C6_ntD1Ev();
extern void _ZN8S49C6_ntD0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
static  VTBL_ENTRY vtc_S49C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S49C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S49C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S49C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
};
extern VTBL_ENTRY _ZTI8S49C6_nt[];
VTBL_ENTRY *P__ZTI8S49C6_nt = _ZTI8S49C6_nt; 
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
Class_Descriptor cd_S49C6_nt = {  "S49C6_nt", // class name
  bases_S49C6_nt, 1,
  &(vtc_S49C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S49C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S49C6_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C12_nt  {
  void *s49c12f0;
  ::S3422C4_nt s49c12f1;
  void  mf49c12(); // _ZN9S49C12_nt7mf49c12Ev
};
//SIG(-1 S49C12_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S49C12_nt ::mf49c12(){}

//skip512 S49C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C5  : S49C6_nt {
  char s49c5f0;
  ::S3422C23 s49c5f1;
  ::S49C12_nt s49c5f2;
  virtual  ~S49C5(); // _ZN5S49C5D1Ev
  virtual void  v77(); // _ZN5S49C53v77Ev
  virtual void  v78(); // _ZN5S49C53v78Ev
  virtual void  v79(); // _ZN5S49C53v79Ev
  virtual void  v80(); // _ZN5S49C53v80Ev
  virtual void  v81(); // _ZN5S49C53v81Ev
  virtual void  v82(); // _ZN5S49C53v82Ev
  virtual void  v83(); // _ZN5S49C53v83Ev
  virtual void  v84(); // _ZN5S49C53v84Ev
  virtual void  v85(); // _ZN5S49C53v85Ev
  virtual void  v86(); // _ZN5S49C53v86Ev
  virtual void  v87(); // _ZN5S49C53v87Ev
  virtual void  v88(); // _ZN5S49C53v88Ev
  S49C5(); // tgen
};
//SIG(-1 S49C5) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S49C5 ::~S49C5(){ note_dtor("S49C5", this);}
void  S49C5 ::v77(){vfunc_called(this, "_ZN5S49C53v77Ev");}
void  S49C5 ::v78(){vfunc_called(this, "_ZN5S49C53v78Ev");}
void  S49C5 ::v79(){vfunc_called(this, "_ZN5S49C53v79Ev");}
void  S49C5 ::v80(){vfunc_called(this, "_ZN5S49C53v80Ev");}
void  S49C5 ::v81(){vfunc_called(this, "_ZN5S49C53v81Ev");}
void  S49C5 ::v82(){vfunc_called(this, "_ZN5S49C53v82Ev");}
void  S49C5 ::v83(){vfunc_called(this, "_ZN5S49C53v83Ev");}
void  S49C5 ::v84(){vfunc_called(this, "_ZN5S49C53v84Ev");}
void  S49C5 ::v85(){vfunc_called(this, "_ZN5S49C53v85Ev");}
void  S49C5 ::v86(){vfunc_called(this, "_ZN5S49C53v86Ev");}
void  S49C5 ::v87(){vfunc_called(this, "_ZN5S49C53v87Ev");}
void  S49C5 ::v88(){vfunc_called(this, "_ZN5S49C53v88Ev");}
S49C5 ::S49C5(){ note_ctor("S49C5", this);} // tgen

static void Test_S49C5()
{
  extern Class_Descriptor cd_S49C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S49C5, buf);
    S49C5 *dp, &lv = *(dp=new (buf) S49C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S49C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C5)");
    check_base_class_offset(lv, (S49C7*)(S49C6_nt*), 0, "S49C5");
    check_base_class_offset(lv, (S49C6_nt*), 0, "S49C5");
    check_field_offset(lv, s49c5f0, ABISELECT(96,60), "S49C5.s49c5f0");
    check_field_offset(lv, s49c5f1, ABISELECT(104,64), "S49C5.s49c5f1");
    check_field_offset(lv, s49c5f2, ABISELECT(120,76), "S49C5.s49c5f2");
    test_class_info(&lv, &cd_S49C5);
    dp->~S49C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C5(Test_S49C5, "S49C5", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN5S49C5C1Ev();
extern void _ZN5S49C5D1Ev();
Name_Map name_map_S49C5[] = {
  NSPAIR(_ZN5S49C5C1Ev),
  NSPAIR(_ZN5S49C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
extern Class_Descriptor cd_S49C6_nt;
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
static Base_Class bases_S49C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S49C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S49C5[];
extern void _ZN5S49C5D1Ev();
extern void _ZN5S49C5D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
extern void _ZN5S49C53v77Ev();
extern void _ZN5S49C53v78Ev();
extern void _ZN5S49C53v79Ev();
extern void _ZN5S49C53v80Ev();
extern void _ZN5S49C53v81Ev();
extern void _ZN5S49C53v82Ev();
extern void _ZN5S49C53v83Ev();
extern void _ZN5S49C53v84Ev();
extern void _ZN5S49C53v85Ev();
extern void _ZN5S49C53v86Ev();
extern void _ZN5S49C53v87Ev();
extern void _ZN5S49C53v88Ev();
static  VTBL_ENTRY vtc_S49C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C5[0]),
  (VTBL_ENTRY)&_ZN5S49C5D1Ev,
  (VTBL_ENTRY)&_ZN5S49C5D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN5S49C53v77Ev,
  (VTBL_ENTRY)&_ZN5S49C53v78Ev,
  (VTBL_ENTRY)&_ZN5S49C53v79Ev,
  (VTBL_ENTRY)&_ZN5S49C53v80Ev,
  (VTBL_ENTRY)&_ZN5S49C53v81Ev,
  (VTBL_ENTRY)&_ZN5S49C53v82Ev,
  (VTBL_ENTRY)&_ZN5S49C53v83Ev,
  (VTBL_ENTRY)&_ZN5S49C53v84Ev,
  (VTBL_ENTRY)&_ZN5S49C53v85Ev,
  (VTBL_ENTRY)&_ZN5S49C53v86Ev,
  (VTBL_ENTRY)&_ZN5S49C53v87Ev,
  (VTBL_ENTRY)&_ZN5S49C53v88Ev,
};
extern VTBL_ENTRY _ZTI5S49C5[];
extern  VTBL_ENTRY _ZTV5S49C5[];
Class_Descriptor cd_S49C5 = {  "S49C5", // class name
  bases_S49C5, 2,
  &(vtc_S49C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI5S49C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S49C5),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C4  : S49C5 {
  ::S3422C4_nt s49c4f0;
  ::S3422C23 s49c4f1;
  ::S49C12_nt s49c4f2;
  virtual  ~S49C4(); // _ZN5S49C4D1Ev
  virtual void  v89(); // _ZN5S49C43v89Ev
  virtual void  v90(); // _ZN5S49C43v90Ev
  virtual void  v91(); // _ZN5S49C43v91Ev
  virtual void  v92(); // _ZN5S49C43v92Ev
  virtual void  v93(); // _ZN5S49C43v93Ev
  virtual void  v94(); // _ZN5S49C43v94Ev
  virtual void  v95(); // _ZN5S49C43v95Ev
  virtual void  v96(); // _ZN5S49C43v96Ev
  virtual void  v97(); // _ZN5S49C43v97Ev
  S49C4(); // tgen
};
//SIG(-1 S49C4) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S49C4 ::~S49C4(){ note_dtor("S49C4", this);}
void  S49C4 ::v89(){vfunc_called(this, "_ZN5S49C43v89Ev");}
void  S49C4 ::v90(){vfunc_called(this, "_ZN5S49C43v90Ev");}
void  S49C4 ::v91(){vfunc_called(this, "_ZN5S49C43v91Ev");}
void  S49C4 ::v92(){vfunc_called(this, "_ZN5S49C43v92Ev");}
void  S49C4 ::v93(){vfunc_called(this, "_ZN5S49C43v93Ev");}
void  S49C4 ::v94(){vfunc_called(this, "_ZN5S49C43v94Ev");}
void  S49C4 ::v95(){vfunc_called(this, "_ZN5S49C43v95Ev");}
void  S49C4 ::v96(){vfunc_called(this, "_ZN5S49C43v96Ev");}
void  S49C4 ::v97(){vfunc_called(this, "_ZN5S49C43v97Ev");}
S49C4 ::S49C4(){ note_ctor("S49C4", this);} // tgen

static void Test_S49C4()
{
  extern Class_Descriptor cd_S49C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S49C4, buf);
    S49C4 *dp, &lv = *(dp=new (buf) S49C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S49C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C4)");
    check_base_class_offset(lv, (S49C7*)(S49C6_nt*)(S49C5*), 0, "S49C4");
    check_base_class_offset(lv, (S49C6_nt*)(S49C5*), 0, "S49C4");
    check_base_class_offset(lv, (S49C5*), 0, "S49C4");
    check_field_offset(lv, s49c4f0, ABISELECT(136,88), "S49C4.s49c4f0");
    check_field_offset(lv, s49c4f1, ABISELECT(144,96), "S49C4.s49c4f1");
    check_field_offset(lv, s49c4f2, ABISELECT(160,108), "S49C4.s49c4f2");
    test_class_info(&lv, &cd_S49C4);
    dp->~S49C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C4(Test_S49C4, "S49C4", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN5S49C4C1Ev();
extern void _ZN5S49C4D1Ev();
Name_Map name_map_S49C4[] = {
  NSPAIR(_ZN5S49C4C1Ev),
  NSPAIR(_ZN5S49C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
extern Class_Descriptor cd_S49C6_nt;
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
extern Class_Descriptor cd_S49C5;
extern VTBL_ENTRY _ZTI5S49C5[];
extern  VTBL_ENTRY _ZTV5S49C5[];
static Base_Class bases_S49C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S49C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S49C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S49C4[];
extern void _ZN5S49C4D1Ev();
extern void _ZN5S49C4D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
extern void _ZN5S49C53v77Ev();
extern void _ZN5S49C53v78Ev();
extern void _ZN5S49C53v79Ev();
extern void _ZN5S49C53v80Ev();
extern void _ZN5S49C53v81Ev();
extern void _ZN5S49C53v82Ev();
extern void _ZN5S49C53v83Ev();
extern void _ZN5S49C53v84Ev();
extern void _ZN5S49C53v85Ev();
extern void _ZN5S49C53v86Ev();
extern void _ZN5S49C53v87Ev();
extern void _ZN5S49C53v88Ev();
extern void _ZN5S49C43v89Ev();
extern void _ZN5S49C43v90Ev();
extern void _ZN5S49C43v91Ev();
extern void _ZN5S49C43v92Ev();
extern void _ZN5S49C43v93Ev();
extern void _ZN5S49C43v94Ev();
extern void _ZN5S49C43v95Ev();
extern void _ZN5S49C43v96Ev();
extern void _ZN5S49C43v97Ev();
static  VTBL_ENTRY vtc_S49C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C4[0]),
  (VTBL_ENTRY)&_ZN5S49C4D1Ev,
  (VTBL_ENTRY)&_ZN5S49C4D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN5S49C53v77Ev,
  (VTBL_ENTRY)&_ZN5S49C53v78Ev,
  (VTBL_ENTRY)&_ZN5S49C53v79Ev,
  (VTBL_ENTRY)&_ZN5S49C53v80Ev,
  (VTBL_ENTRY)&_ZN5S49C53v81Ev,
  (VTBL_ENTRY)&_ZN5S49C53v82Ev,
  (VTBL_ENTRY)&_ZN5S49C53v83Ev,
  (VTBL_ENTRY)&_ZN5S49C53v84Ev,
  (VTBL_ENTRY)&_ZN5S49C53v85Ev,
  (VTBL_ENTRY)&_ZN5S49C53v86Ev,
  (VTBL_ENTRY)&_ZN5S49C53v87Ev,
  (VTBL_ENTRY)&_ZN5S49C53v88Ev,
  (VTBL_ENTRY)&_ZN5S49C43v89Ev,
  (VTBL_ENTRY)&_ZN5S49C43v90Ev,
  (VTBL_ENTRY)&_ZN5S49C43v91Ev,
  (VTBL_ENTRY)&_ZN5S49C43v92Ev,
  (VTBL_ENTRY)&_ZN5S49C43v93Ev,
  (VTBL_ENTRY)&_ZN5S49C43v94Ev,
  (VTBL_ENTRY)&_ZN5S49C43v95Ev,
  (VTBL_ENTRY)&_ZN5S49C43v96Ev,
  (VTBL_ENTRY)&_ZN5S49C43v97Ev,
};
extern VTBL_ENTRY _ZTI5S49C4[];
extern  VTBL_ENTRY _ZTV5S49C4[];
Class_Descriptor cd_S49C4 = {  "S49C4", // class name
  bases_S49C4, 3,
  &(vtc_S49C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI5S49C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S49C4),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C3  : S49C4 {
  virtual  ~S49C3(); // _ZN5S49C3D1Ev
  virtual void  v98(); // _ZN5S49C33v98Ev
  virtual void  v99(); // _ZN5S49C33v99Ev
  S49C3(); // tgen
};
//SIG(-1 S49C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v81 v82 v83 v84 v85 v86 v87 v88 v89 FC6 FC7 FC10} vd v1 v2}


 S49C3 ::~S49C3(){ note_dtor("S49C3", this);}
void  S49C3 ::v98(){vfunc_called(this, "_ZN5S49C33v98Ev");}
void  S49C3 ::v99(){vfunc_called(this, "_ZN5S49C33v99Ev");}
S49C3 ::S49C3(){ note_ctor("S49C3", this);} // tgen

static void Test_S49C3()
{
  extern Class_Descriptor cd_S49C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S49C3, buf);
    S49C3 *dp, &lv = *(dp=new (buf) S49C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S49C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C3)");
    check_base_class_offset(lv, (S49C7*)(S49C6_nt*)(S49C5*)(S49C4*), 0, "S49C3");
    check_base_class_offset(lv, (S49C6_nt*)(S49C5*)(S49C4*), 0, "S49C3");
    check_base_class_offset(lv, (S49C5*)(S49C4*), 0, "S49C3");
    check_base_class_offset(lv, (S49C4*), 0, "S49C3");
    test_class_info(&lv, &cd_S49C3);
    dp->~S49C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C3(Test_S49C3, "S49C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN5S49C3C1Ev();
extern void _ZN5S49C3D1Ev();
Name_Map name_map_S49C3[] = {
  NSPAIR(_ZN5S49C3C1Ev),
  NSPAIR(_ZN5S49C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
extern Class_Descriptor cd_S49C6_nt;
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
extern Class_Descriptor cd_S49C5;
extern VTBL_ENTRY _ZTI5S49C5[];
extern  VTBL_ENTRY _ZTV5S49C5[];
extern Class_Descriptor cd_S49C4;
extern VTBL_ENTRY _ZTI5S49C4[];
extern  VTBL_ENTRY _ZTV5S49C4[];
static Base_Class bases_S49C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S49C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S49C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S49C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S49C3[];
extern void _ZN5S49C3D1Ev();
extern void _ZN5S49C3D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
extern void _ZN5S49C53v77Ev();
extern void _ZN5S49C53v78Ev();
extern void _ZN5S49C53v79Ev();
extern void _ZN5S49C53v80Ev();
extern void _ZN5S49C53v81Ev();
extern void _ZN5S49C53v82Ev();
extern void _ZN5S49C53v83Ev();
extern void _ZN5S49C53v84Ev();
extern void _ZN5S49C53v85Ev();
extern void _ZN5S49C53v86Ev();
extern void _ZN5S49C53v87Ev();
extern void _ZN5S49C53v88Ev();
extern void _ZN5S49C43v89Ev();
extern void _ZN5S49C43v90Ev();
extern void _ZN5S49C43v91Ev();
extern void _ZN5S49C43v92Ev();
extern void _ZN5S49C43v93Ev();
extern void _ZN5S49C43v94Ev();
extern void _ZN5S49C43v95Ev();
extern void _ZN5S49C43v96Ev();
extern void _ZN5S49C43v97Ev();
extern void _ZN5S49C33v98Ev();
extern void _ZN5S49C33v99Ev();
static  VTBL_ENTRY vtc_S49C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C3[0]),
  (VTBL_ENTRY)&_ZN5S49C3D1Ev,
  (VTBL_ENTRY)&_ZN5S49C3D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN5S49C53v77Ev,
  (VTBL_ENTRY)&_ZN5S49C53v78Ev,
  (VTBL_ENTRY)&_ZN5S49C53v79Ev,
  (VTBL_ENTRY)&_ZN5S49C53v80Ev,
  (VTBL_ENTRY)&_ZN5S49C53v81Ev,
  (VTBL_ENTRY)&_ZN5S49C53v82Ev,
  (VTBL_ENTRY)&_ZN5S49C53v83Ev,
  (VTBL_ENTRY)&_ZN5S49C53v84Ev,
  (VTBL_ENTRY)&_ZN5S49C53v85Ev,
  (VTBL_ENTRY)&_ZN5S49C53v86Ev,
  (VTBL_ENTRY)&_ZN5S49C53v87Ev,
  (VTBL_ENTRY)&_ZN5S49C53v88Ev,
  (VTBL_ENTRY)&_ZN5S49C43v89Ev,
  (VTBL_ENTRY)&_ZN5S49C43v90Ev,
  (VTBL_ENTRY)&_ZN5S49C43v91Ev,
  (VTBL_ENTRY)&_ZN5S49C43v92Ev,
  (VTBL_ENTRY)&_ZN5S49C43v93Ev,
  (VTBL_ENTRY)&_ZN5S49C43v94Ev,
  (VTBL_ENTRY)&_ZN5S49C43v95Ev,
  (VTBL_ENTRY)&_ZN5S49C43v96Ev,
  (VTBL_ENTRY)&_ZN5S49C43v97Ev,
  (VTBL_ENTRY)&_ZN5S49C33v98Ev,
  (VTBL_ENTRY)&_ZN5S49C33v99Ev,
};
extern VTBL_ENTRY _ZTI5S49C3[];
extern  VTBL_ENTRY _ZTV5S49C3[];
Class_Descriptor cd_S49C3 = {  "S49C3", // class name
  bases_S49C3, 4,
  &(vtc_S49C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI5S49C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S49C3),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C13_nt  {
  virtual  ~S49C13_nt(); // _ZN9S49C13_ntD1Ev
  virtual void  v100(); // _ZN9S49C13_nt4v100Ev
  virtual void  v101(); // _ZN9S49C13_nt4v101Ev
  virtual void  v102(); // _ZN9S49C13_nt4v102Ev
  virtual void  v103(); // _ZN9S49C13_nt4v103Ev
  virtual void  v104(); // _ZN9S49C13_nt4v104Ev
  virtual void  v105(); // _ZN9S49C13_nt4v105Ev
  virtual void  v106(); // _ZN9S49C13_nt4v106Ev
  virtual void  v107(); // _ZN9S49C13_nt4v107Ev
  S49C13_nt(); // tgen
};
//SIG(-1 S49C13_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S49C13_nt ::~S49C13_nt(){ note_dtor("S49C13_nt", this);}
void  S49C13_nt ::v100(){vfunc_called(this, "_ZN9S49C13_nt4v100Ev");}
void  S49C13_nt ::v101(){vfunc_called(this, "_ZN9S49C13_nt4v101Ev");}
void  S49C13_nt ::v102(){vfunc_called(this, "_ZN9S49C13_nt4v102Ev");}
void  S49C13_nt ::v103(){vfunc_called(this, "_ZN9S49C13_nt4v103Ev");}
void  S49C13_nt ::v104(){vfunc_called(this, "_ZN9S49C13_nt4v104Ev");}
void  S49C13_nt ::v105(){vfunc_called(this, "_ZN9S49C13_nt4v105Ev");}
void  S49C13_nt ::v106(){vfunc_called(this, "_ZN9S49C13_nt4v106Ev");}
void  S49C13_nt ::v107(){vfunc_called(this, "_ZN9S49C13_nt4v107Ev");}
S49C13_nt ::S49C13_nt(){ note_ctor("S49C13_nt", this);} // tgen

//skip512 S49C13_nt

#else // __cplusplus

extern void _ZN9S49C13_ntC1Ev();
extern void _ZN9S49C13_ntD1Ev();
Name_Map name_map_S49C13_nt[] = {
  NSPAIR(_ZN9S49C13_ntC1Ev),
  NSPAIR(_ZN9S49C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S49C13_nt[];
extern void _ZN9S49C13_ntD1Ev();
extern void _ZN9S49C13_ntD0Ev();
extern void _ZN9S49C13_nt4v100Ev();
extern void _ZN9S49C13_nt4v101Ev();
extern void _ZN9S49C13_nt4v102Ev();
extern void _ZN9S49C13_nt4v103Ev();
extern void _ZN9S49C13_nt4v104Ev();
extern void _ZN9S49C13_nt4v105Ev();
extern void _ZN9S49C13_nt4v106Ev();
extern void _ZN9S49C13_nt4v107Ev();
static  VTBL_ENTRY vtc_S49C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S49C13_nt[0]),
  (VTBL_ENTRY)&_ZN9S49C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S49C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v107Ev,
};
extern VTBL_ENTRY _ZTI9S49C13_nt[];
VTBL_ENTRY *P__ZTI9S49C13_nt = _ZTI9S49C13_nt; 
extern  VTBL_ENTRY _ZTV9S49C13_nt[];
Class_Descriptor cd_S49C13_nt = {  "S49C13_nt", // class name
  0,0,//no base classes
  &(vtc_S49C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S49C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S49C13_nt),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C14_nt  {
  virtual  ~S49C14_nt(); // _ZN9S49C14_ntD1Ev
  virtual void  v108(); // _ZN9S49C14_nt4v108Ev
  virtual void  v109(); // _ZN9S49C14_nt4v109Ev
  virtual void  v110(); // _ZN9S49C14_nt4v110Ev
  virtual void  v111(); // _ZN9S49C14_nt4v111Ev
  S49C14_nt(); // tgen
};
//SIG(-1 S49C14_nt) C1{ vd v1 v2 v3 v4}


 S49C14_nt ::~S49C14_nt(){ note_dtor("S49C14_nt", this);}
void  S49C14_nt ::v108(){vfunc_called(this, "_ZN9S49C14_nt4v108Ev");}
void  S49C14_nt ::v109(){vfunc_called(this, "_ZN9S49C14_nt4v109Ev");}
void  S49C14_nt ::v110(){vfunc_called(this, "_ZN9S49C14_nt4v110Ev");}
void  S49C14_nt ::v111(){vfunc_called(this, "_ZN9S49C14_nt4v111Ev");}
S49C14_nt ::S49C14_nt(){ note_ctor("S49C14_nt", this);} // tgen

//skip512 S49C14_nt

#else // __cplusplus

extern void _ZN9S49C14_ntC1Ev();
extern void _ZN9S49C14_ntD1Ev();
Name_Map name_map_S49C14_nt[] = {
  NSPAIR(_ZN9S49C14_ntC1Ev),
  NSPAIR(_ZN9S49C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S49C14_nt[];
extern void _ZN9S49C14_ntD1Ev();
extern void _ZN9S49C14_ntD0Ev();
extern void _ZN9S49C14_nt4v108Ev();
extern void _ZN9S49C14_nt4v109Ev();
extern void _ZN9S49C14_nt4v110Ev();
extern void _ZN9S49C14_nt4v111Ev();
static  VTBL_ENTRY vtc_S49C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S49C14_nt[0]),
  (VTBL_ENTRY)&_ZN9S49C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S49C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v111Ev,
};
extern VTBL_ENTRY _ZTI9S49C14_nt[];
VTBL_ENTRY *P__ZTI9S49C14_nt = _ZTI9S49C14_nt; 
extern  VTBL_ENTRY _ZTV9S49C14_nt[];
Class_Descriptor cd_S49C14_nt = {  "S49C14_nt", // class name
  0,0,//no base classes
  &(vtc_S49C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S49C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S49C14_nt),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C17  {
  ::S3422C4_nt s49c17f0;
  ::S3422C22_nt s49c17f1;
  void  mf49c17(); // _ZN6S49C177mf49c17Ev
};
//SIG(-1 S49C17) C1{ m FC2{ m Fi[2]} FC3{ BC4{ BC5{ BC6{ m Fp Fi[2]}}}}}


void  S49C17 ::mf49c17(){}

static void Test_S49C17()
{
  {
    init_simple_test("S49C17");
    S49C17 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S49C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C17)");
    check_field_offset(lv, s49c17f0, 0, "S49C17.s49c17f0");
    check_field_offset(lv, s49c17f1, 8, "S49C17.s49c17f1");
  }
}
static Arrange_To_Call_Me vS49C17(Test_S49C17, "S49C17", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C25_nt  {
  void *s49c25f0[2];
  void  mf49c25(); // _ZN9S49C25_nt7mf49c25Ev
};
//SIG(-1 S49C25_nt) C1{ m Fp[2]}


void  S49C25_nt ::mf49c25(){}

//skip512 S49C25_nt

#else // __cplusplus

Class_Descriptor cd_S49C25_nt = {  "S49C25_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C24_nt  : S49C25_nt {
};
//SIG(-1 S49C24_nt) C1{ BC2{ m Fp[2]}}



//skip512 S49C24_nt

#else // __cplusplus

extern Class_Descriptor cd_S49C25_nt;
static Base_Class bases_S49C24_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C25_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C2  : S49C3 , S49C13_nt , S49C14_nt {
  ::S3422C17 s49c2f0;
  ::S3422C4_nt s49c2f1;
  ::S49C17 s49c2f2;
  ::S49C17 s49c2f3;
  ::S3422C4_nt s49c2f4;
  ::S3422C11 s49c2f5;
  void *s49c2f6;
  char s49c2f7;
  ::S49C24_nt s49c2f8;
  ::S49C24_nt s49c2f9;
  virtual  ~S49C2(); // _ZN5S49C2D1Ev
  virtual void  v112(); // _ZN5S49C24v112Ev
  virtual void  v113(); // _ZN5S49C24v113Ev
  virtual void  v114(); // _ZN5S49C24v114Ev
  virtual void  v115(); // _ZN5S49C24v115Ev
  virtual void  v116(); // _ZN5S49C24v116Ev
  virtual void  v117(); // _ZN5S49C24v117Ev
  virtual void  v118(); // _ZN5S49C24v118Ev
  virtual void  v119(); // _ZN5S49C24v119Ev
  virtual void  v120(); // _ZN5S49C24v120Ev
  virtual void  v121(); // _ZN5S49C24v121Ev
  virtual void  v122(); // _ZN5S49C24v122Ev
  virtual void  v123(); // _ZN5S49C24v123Ev
  virtual void  v124(); // _ZN5S49C24v124Ev
  virtual void  v125(); // _ZN5S49C24v125Ev
  virtual void  v126(); // _ZN5S49C24v126Ev
  virtual void  v127(); // _ZN5S49C24v127Ev
  virtual void  v128(); // _ZN5S49C24v128Ev
  S49C2(); // tgen
};
//SIG(-1 S49C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v82 v83} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 FC7 FC8 FC11} vd v105 v106} BC12{ vd v107 v108 v109 v110 v111 v112 v113 v114} BC13{ vd v115 v116 v117 v118} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 FC14{ BC15{ BC10}} FC7 FC16{ m FC7 FC17{ BC8}} FC16 FC7 FC18{ BC19{ BC10}} Fp Fc FC20{ BC21{ m Fp[2]}} FC20}


 S49C2 ::~S49C2(){ note_dtor("S49C2", this);}
void  S49C2 ::v112(){vfunc_called(this, "_ZN5S49C24v112Ev");}
void  S49C2 ::v113(){vfunc_called(this, "_ZN5S49C24v113Ev");}
void  S49C2 ::v114(){vfunc_called(this, "_ZN5S49C24v114Ev");}
void  S49C2 ::v115(){vfunc_called(this, "_ZN5S49C24v115Ev");}
void  S49C2 ::v116(){vfunc_called(this, "_ZN5S49C24v116Ev");}
void  S49C2 ::v117(){vfunc_called(this, "_ZN5S49C24v117Ev");}
void  S49C2 ::v118(){vfunc_called(this, "_ZN5S49C24v118Ev");}
void  S49C2 ::v119(){vfunc_called(this, "_ZN5S49C24v119Ev");}
void  S49C2 ::v120(){vfunc_called(this, "_ZN5S49C24v120Ev");}
void  S49C2 ::v121(){vfunc_called(this, "_ZN5S49C24v121Ev");}
void  S49C2 ::v122(){vfunc_called(this, "_ZN5S49C24v122Ev");}
void  S49C2 ::v123(){vfunc_called(this, "_ZN5S49C24v123Ev");}
void  S49C2 ::v124(){vfunc_called(this, "_ZN5S49C24v124Ev");}
void  S49C2 ::v125(){vfunc_called(this, "_ZN5S49C24v125Ev");}
void  S49C2 ::v126(){vfunc_called(this, "_ZN5S49C24v126Ev");}
void  S49C2 ::v127(){vfunc_called(this, "_ZN5S49C24v127Ev");}
void  S49C2 ::v128(){vfunc_called(this, "_ZN5S49C24v128Ev");}
S49C2 ::S49C2(){ note_ctor("S49C2", this);} // tgen

static void Test_S49C2()
{
  extern Class_Descriptor cd_S49C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,59)];
    init_test(&cd_S49C2, buf);
    S49C2 *dp, &lv = *(dp=new (buf) S49C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,232), "sizeof(S49C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C2)");
    check_base_class_offset(lv, (S49C7*)(S49C6_nt*)(S49C5*)(S49C4*)(S49C3*), 0, "S49C2");
    check_base_class_offset(lv, (S49C6_nt*)(S49C5*)(S49C4*)(S49C3*), 0, "S49C2");
    check_base_class_offset(lv, (S49C5*)(S49C4*)(S49C3*), 0, "S49C2");
    check_base_class_offset(lv, (S49C4*)(S49C3*), 0, "S49C2");
    check_base_class_offset(lv, (S49C3*), 0, "S49C2");
    check_base_class_offset(lv, (S49C13_nt*), ABISELECT(176,120), "S49C2");
    check_base_class_offset(lv, (S49C14_nt*), ABISELECT(184,124), "S49C2");
    check_field_offset(lv, s49c2f0, ABISELECT(192,128), "S49C2.s49c2f0");
    check_field_offset(lv, s49c2f1, ABISELECT(208,140), "S49C2.s49c2f1");
    check_field_offset(lv, s49c2f2, ABISELECT(216,148), "S49C2.s49c2f2");
    check_field_offset(lv, s49c2f3, ABISELECT(240,168), "S49C2.s49c2f3");
    check_field_offset(lv, s49c2f4, ABISELECT(264,188), "S49C2.s49c2f4");
    check_field_offset(lv, s49c2f5, ABISELECT(272,196), "S49C2.s49c2f5");
    check_field_offset(lv, s49c2f6, ABISELECT(288,208), "S49C2.s49c2f6");
    check_field_offset(lv, s49c2f7, ABISELECT(296,212), "S49C2.s49c2f7");
    check_field_offset(lv, s49c2f8, ABISELECT(304,216), "S49C2.s49c2f8");
    check_field_offset(lv, s49c2f9, ABISELECT(320,224), "S49C2.s49c2f9");
    test_class_info(&lv, &cd_S49C2);
    dp->~S49C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C2(Test_S49C2, "S49C2", ABISELECT(336,232));

#else // __cplusplus

extern void _ZN5S49C2C1Ev();
extern void _ZN5S49C2D1Ev();
Name_Map name_map_S49C2[] = {
  NSPAIR(_ZN5S49C2C1Ev),
  NSPAIR(_ZN5S49C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
extern Class_Descriptor cd_S49C6_nt;
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
extern Class_Descriptor cd_S49C5;
extern VTBL_ENTRY _ZTI5S49C5[];
extern  VTBL_ENTRY _ZTV5S49C5[];
extern Class_Descriptor cd_S49C4;
extern VTBL_ENTRY _ZTI5S49C4[];
extern  VTBL_ENTRY _ZTV5S49C4[];
extern Class_Descriptor cd_S49C3;
extern VTBL_ENTRY _ZTI5S49C3[];
extern  VTBL_ENTRY _ZTV5S49C3[];
extern Class_Descriptor cd_S49C13_nt;
extern VTBL_ENTRY _ZTI9S49C13_nt[];
extern  VTBL_ENTRY _ZTV9S49C13_nt[];
extern Class_Descriptor cd_S49C14_nt;
extern VTBL_ENTRY _ZTI9S49C14_nt[];
extern  VTBL_ENTRY _ZTV9S49C14_nt[];
static Base_Class bases_S49C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S49C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S49C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S49C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S49C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S49C13_nt,    ABISELECT(176,120), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S49C14_nt,    ABISELECT(184,124), //bcp->offset
    122, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S49C2[];
extern void _ZN5S49C2D1Ev();
extern void _ZN5S49C2D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
extern void _ZN5S49C53v77Ev();
extern void _ZN5S49C53v78Ev();
extern void _ZN5S49C53v79Ev();
extern void _ZN5S49C53v80Ev();
extern void _ZN5S49C53v81Ev();
extern void _ZN5S49C53v82Ev();
extern void _ZN5S49C53v83Ev();
extern void _ZN5S49C53v84Ev();
extern void _ZN5S49C53v85Ev();
extern void _ZN5S49C53v86Ev();
extern void _ZN5S49C53v87Ev();
extern void _ZN5S49C53v88Ev();
extern void _ZN5S49C43v89Ev();
extern void _ZN5S49C43v90Ev();
extern void _ZN5S49C43v91Ev();
extern void _ZN5S49C43v92Ev();
extern void _ZN5S49C43v93Ev();
extern void _ZN5S49C43v94Ev();
extern void _ZN5S49C43v95Ev();
extern void _ZN5S49C43v96Ev();
extern void _ZN5S49C43v97Ev();
extern void _ZN5S49C33v98Ev();
extern void _ZN5S49C33v99Ev();
extern void _ZN5S49C24v112Ev();
extern void _ZN5S49C24v113Ev();
extern void _ZN5S49C24v114Ev();
extern void _ZN5S49C24v115Ev();
extern void _ZN5S49C24v116Ev();
extern void _ZN5S49C24v117Ev();
extern void _ZN5S49C24v118Ev();
extern void _ZN5S49C24v119Ev();
extern void _ZN5S49C24v120Ev();
extern void _ZN5S49C24v121Ev();
extern void _ZN5S49C24v122Ev();
extern void _ZN5S49C24v123Ev();
extern void _ZN5S49C24v124Ev();
extern void _ZN5S49C24v125Ev();
extern void _ZN5S49C24v126Ev();
extern void _ZN5S49C24v127Ev();
extern void _ZN5S49C24v128Ev();
extern void ABISELECT(_ZThn176_N5S49C2D1Ev,_ZThn120_N5S49C2D1Ev)();
extern void ABISELECT(_ZThn176_N5S49C2D0Ev,_ZThn120_N5S49C2D0Ev)();
extern void _ZN9S49C13_nt4v100Ev();
extern void _ZN9S49C13_nt4v101Ev();
extern void _ZN9S49C13_nt4v102Ev();
extern void _ZN9S49C13_nt4v103Ev();
extern void _ZN9S49C13_nt4v104Ev();
extern void _ZN9S49C13_nt4v105Ev();
extern void _ZN9S49C13_nt4v106Ev();
extern void _ZN9S49C13_nt4v107Ev();
extern void ABISELECT(_ZThn184_N5S49C2D1Ev,_ZThn124_N5S49C2D1Ev)();
extern void ABISELECT(_ZThn184_N5S49C2D0Ev,_ZThn124_N5S49C2D0Ev)();
extern void _ZN9S49C14_nt4v108Ev();
extern void _ZN9S49C14_nt4v109Ev();
extern void _ZN9S49C14_nt4v110Ev();
extern void _ZN9S49C14_nt4v111Ev();
static  VTBL_ENTRY vtc_S49C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C2[0]),
  (VTBL_ENTRY)&_ZN5S49C2D1Ev,
  (VTBL_ENTRY)&_ZN5S49C2D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN5S49C53v77Ev,
  (VTBL_ENTRY)&_ZN5S49C53v78Ev,
  (VTBL_ENTRY)&_ZN5S49C53v79Ev,
  (VTBL_ENTRY)&_ZN5S49C53v80Ev,
  (VTBL_ENTRY)&_ZN5S49C53v81Ev,
  (VTBL_ENTRY)&_ZN5S49C53v82Ev,
  (VTBL_ENTRY)&_ZN5S49C53v83Ev,
  (VTBL_ENTRY)&_ZN5S49C53v84Ev,
  (VTBL_ENTRY)&_ZN5S49C53v85Ev,
  (VTBL_ENTRY)&_ZN5S49C53v86Ev,
  (VTBL_ENTRY)&_ZN5S49C53v87Ev,
  (VTBL_ENTRY)&_ZN5S49C53v88Ev,
  (VTBL_ENTRY)&_ZN5S49C43v89Ev,
  (VTBL_ENTRY)&_ZN5S49C43v90Ev,
  (VTBL_ENTRY)&_ZN5S49C43v91Ev,
  (VTBL_ENTRY)&_ZN5S49C43v92Ev,
  (VTBL_ENTRY)&_ZN5S49C43v93Ev,
  (VTBL_ENTRY)&_ZN5S49C43v94Ev,
  (VTBL_ENTRY)&_ZN5S49C43v95Ev,
  (VTBL_ENTRY)&_ZN5S49C43v96Ev,
  (VTBL_ENTRY)&_ZN5S49C43v97Ev,
  (VTBL_ENTRY)&_ZN5S49C33v98Ev,
  (VTBL_ENTRY)&_ZN5S49C33v99Ev,
  (VTBL_ENTRY)&_ZN5S49C24v112Ev,
  (VTBL_ENTRY)&_ZN5S49C24v113Ev,
  (VTBL_ENTRY)&_ZN5S49C24v114Ev,
  (VTBL_ENTRY)&_ZN5S49C24v115Ev,
  (VTBL_ENTRY)&_ZN5S49C24v116Ev,
  (VTBL_ENTRY)&_ZN5S49C24v117Ev,
  (VTBL_ENTRY)&_ZN5S49C24v118Ev,
  (VTBL_ENTRY)&_ZN5S49C24v119Ev,
  (VTBL_ENTRY)&_ZN5S49C24v120Ev,
  (VTBL_ENTRY)&_ZN5S49C24v121Ev,
  (VTBL_ENTRY)&_ZN5S49C24v122Ev,
  (VTBL_ENTRY)&_ZN5S49C24v123Ev,
  (VTBL_ENTRY)&_ZN5S49C24v124Ev,
  (VTBL_ENTRY)&_ZN5S49C24v125Ev,
  (VTBL_ENTRY)&_ZN5S49C24v126Ev,
  (VTBL_ENTRY)&_ZN5S49C24v127Ev,
  (VTBL_ENTRY)&_ZN5S49C24v128Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI5S49C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S49C2D1Ev,_ZThn120_N5S49C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S49C2D0Ev,_ZThn120_N5S49C2D0Ev),
  (VTBL_ENTRY)&_ZN9S49C13_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v107Ev,
  ABISELECT(-184,-124),
  (VTBL_ENTRY)&(_ZTI5S49C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S49C2D1Ev,_ZThn124_N5S49C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S49C2D0Ev,_ZThn124_N5S49C2D0Ev),
  (VTBL_ENTRY)&_ZN9S49C14_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v111Ev,
};
extern VTBL_ENTRY _ZTI5S49C2[];
extern  VTBL_ENTRY _ZTV5S49C2[];
Class_Descriptor cd_S49C2 = {  "S49C2", // class name
  bases_S49C2, 7,
  &(vtc_S49C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,232), // object size
  NSPAIRA(_ZTI5S49C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV5S49C2),130, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C26_nt  {
  char s49c26f0[8];
  void  mf49c26(); // _ZN9S49C26_nt7mf49c26Ev
};
//SIG(-1 S49C26_nt) C1{ m Fc[8]}


void  S49C26_nt ::mf49c26(){}

//skip512 S49C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S49C1  : S49C2 {
  char s49c1f0;
  unsigned int s49c1f1:1;
  unsigned int s49c1f2:1;
  ::S49C26_nt s49c1f3;
  ::S3422C22_nt s49c1f4;
  int s49c1f5[4];
  void *s49c1f6[8];
  ::S3422C11 s49c1f7;
  ::S49C12_nt s49c1f8;
  virtual  ~S49C1(); // _ZN5S49C1D1Ev
  virtual void  v1(); // _ZN5S49C12v1Ev
  virtual void  v2(); // _ZN5S49C12v2Ev
  virtual void  v3(); // _ZN5S49C12v3Ev
  virtual void  v4(); // _ZN5S49C12v4Ev
  virtual void  v5(); // _ZN5S49C12v5Ev
  virtual void  v6(); // _ZN5S49C12v6Ev
  virtual void  v7(); // _ZN5S49C12v7Ev
  virtual void  v8(); // _ZN5S49C12v8Ev
  virtual void  v9(); // _ZN5S49C12v9Ev
  virtual void  v10(); // _ZN5S49C13v10Ev
  S49C1(); // tgen
};
//SIG(1 S49C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v75 v76} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 FC8 FC9 FC12} vd v98 v99} BC13{ vd v100 v101 v102 v103 v104 v105 v106 v107} BC14{ vd v108 v109 v110 v111} vd v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 FC15{ BC16{ BC11}} FC8 FC17{ m FC8 FC18{ BC9}} FC17 FC8 FC19{ BC20{ BC11}} Fp Fc FC21{ BC22{ m Fp[2]}} FC21} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fc Fi:1 Fi:1 FC23{ m Fc[8]} FC18 Fi[4] Fp[8] FC19 FC12}


 S49C1 ::~S49C1(){ note_dtor("S49C1", this);}
void  S49C1 ::v1(){vfunc_called(this, "_ZN5S49C12v1Ev");}
void  S49C1 ::v2(){vfunc_called(this, "_ZN5S49C12v2Ev");}
void  S49C1 ::v3(){vfunc_called(this, "_ZN5S49C12v3Ev");}
void  S49C1 ::v4(){vfunc_called(this, "_ZN5S49C12v4Ev");}
void  S49C1 ::v5(){vfunc_called(this, "_ZN5S49C12v5Ev");}
void  S49C1 ::v6(){vfunc_called(this, "_ZN5S49C12v6Ev");}
void  S49C1 ::v7(){vfunc_called(this, "_ZN5S49C12v7Ev");}
void  S49C1 ::v8(){vfunc_called(this, "_ZN5S49C12v8Ev");}
void  S49C1 ::v9(){vfunc_called(this, "_ZN5S49C12v9Ev");}
void  S49C1 ::v10(){vfunc_called(this, "_ZN5S49C13v10Ev");}
S49C1 ::S49C1(){ note_ctor("S49C1", this);} // tgen

static void Test_S49C1()
{
  extern Class_Descriptor cd_S49C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,83)];
    init_test(&cd_S49C1, buf);
    S49C1 *dp, &lv = *(dp=new (buf) S49C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,328), "sizeof(S49C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S49C1)");
    check_base_class_offset(lv, (S49C7*)(S49C6_nt*)(S49C5*)(S49C4*)(S49C3*)(S49C2*), 0, "S49C1");
    check_base_class_offset(lv, (S49C6_nt*)(S49C5*)(S49C4*)(S49C3*)(S49C2*), 0, "S49C1");
    check_base_class_offset(lv, (S49C5*)(S49C4*)(S49C3*)(S49C2*), 0, "S49C1");
    check_base_class_offset(lv, (S49C4*)(S49C3*)(S49C2*), 0, "S49C1");
    check_base_class_offset(lv, (S49C3*)(S49C2*), 0, "S49C1");
    check_base_class_offset(lv, (S49C13_nt*)(S49C2*), ABISELECT(176,120), "S49C1");
    check_base_class_offset(lv, (S49C14_nt*)(S49C2*), ABISELECT(184,124), "S49C1");
    check_base_class_offset(lv, (S49C2*), 0, "S49C1");
    check_field_offset(lv, s49c1f0, ABISELECT(336,232), "S49C1.s49c1f0");
    set_bf_and_test(lv, s49c1f1, ABISELECT(337,233), 0, 1, 1, "S49C1");
    set_bf_and_test(lv, s49c1f2, ABISELECT(337,233), 1, 1, 1, "S49C1");
    check_field_offset(lv, s49c1f3, ABISELECT(338,234), "S49C1.s49c1f3");
    check_field_offset(lv, s49c1f4, ABISELECT(352,244), "S49C1.s49c1f4");
    check_field_offset(lv, s49c1f5, ABISELECT(368,256), "S49C1.s49c1f5");
    check_field_offset(lv, s49c1f6, ABISELECT(384,272), "S49C1.s49c1f6");
    check_field_offset(lv, s49c1f7, ABISELECT(448,304), "S49C1.s49c1f7");
    check_field_offset(lv, s49c1f8, ABISELECT(464,316), "S49C1.s49c1f8");
    test_class_info(&lv, &cd_S49C1);
    dp->~S49C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS49C1(Test_S49C1, "S49C1", ABISELECT(480,328));

#else // __cplusplus

extern void _ZN5S49C1C1Ev();
extern void _ZN5S49C1D1Ev();
Name_Map name_map_S49C1[] = {
  NSPAIR(_ZN5S49C1C1Ev),
  NSPAIR(_ZN5S49C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S49C7;
extern VTBL_ENTRY _ZTI5S49C7[];
extern  VTBL_ENTRY _ZTV5S49C7[];
extern Class_Descriptor cd_S49C6_nt;
extern VTBL_ENTRY _ZTI8S49C6_nt[];
extern  VTBL_ENTRY _ZTV8S49C6_nt[];
extern Class_Descriptor cd_S49C5;
extern VTBL_ENTRY _ZTI5S49C5[];
extern  VTBL_ENTRY _ZTV5S49C5[];
extern Class_Descriptor cd_S49C4;
extern VTBL_ENTRY _ZTI5S49C4[];
extern  VTBL_ENTRY _ZTV5S49C4[];
extern Class_Descriptor cd_S49C3;
extern VTBL_ENTRY _ZTI5S49C3[];
extern  VTBL_ENTRY _ZTV5S49C3[];
extern Class_Descriptor cd_S49C13_nt;
extern VTBL_ENTRY _ZTI9S49C13_nt[];
extern  VTBL_ENTRY _ZTV9S49C13_nt[];
extern Class_Descriptor cd_S49C14_nt;
extern VTBL_ENTRY _ZTI9S49C14_nt[];
extern  VTBL_ENTRY _ZTV9S49C14_nt[];
extern Class_Descriptor cd_S49C2;
extern VTBL_ENTRY _ZTI5S49C2[];
extern  VTBL_ENTRY _ZTV5S49C2[];
static Base_Class bases_S49C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S49C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S49C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S49C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S49C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S49C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S49C13_nt,    ABISELECT(176,120), //bcp->offset
    120, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S49C14_nt,    ABISELECT(184,124), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S49C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S49C1[];
extern void _ZN5S49C1D1Ev();
extern void _ZN5S49C1D0Ev();
extern void _ZN5S49C73v11Ev();
extern void _ZN5S49C73v12Ev();
extern void _ZN5S49C73v13Ev();
extern void _ZN5S49C73v14Ev();
extern void _ZN5S49C73v15Ev();
extern void _ZN5S49C73v16Ev();
extern void _ZN5S49C73v17Ev();
extern void _ZN5S49C73v18Ev();
extern void _ZN5S49C73v19Ev();
extern void _ZN5S49C73v20Ev();
extern void _ZN5S49C73v21Ev();
extern void _ZN5S49C73v22Ev();
extern void _ZN5S49C73v23Ev();
extern void _ZN5S49C73v24Ev();
extern void _ZN5S49C73v25Ev();
extern void _ZN5S49C73v26Ev();
extern void _ZN5S49C73v27Ev();
extern void _ZN5S49C73v28Ev();
extern void _ZN5S49C73v29Ev();
extern void _ZN5S49C73v30Ev();
extern void _ZN5S49C73v31Ev();
extern void _ZN5S49C73v32Ev();
extern void _ZN5S49C73v33Ev();
extern void _ZN5S49C73v34Ev();
extern void _ZN5S49C73v35Ev();
extern void _ZN5S49C73v36Ev();
extern void _ZN5S49C73v37Ev();
extern void _ZN5S49C73v38Ev();
extern void _ZN5S49C73v39Ev();
extern void _ZN5S49C73v40Ev();
extern void _ZN5S49C73v41Ev();
extern void _ZN5S49C73v42Ev();
extern void _ZN5S49C73v43Ev();
extern void _ZN5S49C73v44Ev();
extern void _ZN5S49C73v45Ev();
extern void _ZN5S49C73v46Ev();
extern void _ZN5S49C73v47Ev();
extern void _ZN5S49C73v48Ev();
extern void _ZN5S49C73v49Ev();
extern void _ZN5S49C73v50Ev();
extern void _ZN5S49C73v51Ev();
extern void _ZN5S49C73v52Ev();
extern void _ZN5S49C73v53Ev();
extern void _ZN5S49C73v54Ev();
extern void _ZN5S49C73v55Ev();
extern void _ZN5S49C73v56Ev();
extern void _ZN5S49C73v57Ev();
extern void _ZN5S49C73v58Ev();
extern void _ZN5S49C73v59Ev();
extern void _ZN5S49C73v60Ev();
extern void _ZN5S49C73v61Ev();
extern void _ZN5S49C73v62Ev();
extern void _ZN5S49C73v63Ev();
extern void _ZN5S49C73v64Ev();
extern void _ZN5S49C73v65Ev();
extern void _ZN5S49C73v66Ev();
extern void _ZN5S49C73v67Ev();
extern void _ZN5S49C73v68Ev();
extern void _ZN5S49C73v69Ev();
extern void _ZN5S49C73v70Ev();
extern void _ZN5S49C73v71Ev();
extern void _ZN5S49C73v72Ev();
extern void _ZN5S49C73v73Ev();
extern void _ZN5S49C73v74Ev();
extern void _ZN8S49C6_nt3v75Ev();
extern void _ZN8S49C6_nt3v76Ev();
extern void _ZN5S49C53v77Ev();
extern void _ZN5S49C53v78Ev();
extern void _ZN5S49C53v79Ev();
extern void _ZN5S49C53v80Ev();
extern void _ZN5S49C53v81Ev();
extern void _ZN5S49C53v82Ev();
extern void _ZN5S49C53v83Ev();
extern void _ZN5S49C53v84Ev();
extern void _ZN5S49C53v85Ev();
extern void _ZN5S49C53v86Ev();
extern void _ZN5S49C53v87Ev();
extern void _ZN5S49C53v88Ev();
extern void _ZN5S49C43v89Ev();
extern void _ZN5S49C43v90Ev();
extern void _ZN5S49C43v91Ev();
extern void _ZN5S49C43v92Ev();
extern void _ZN5S49C43v93Ev();
extern void _ZN5S49C43v94Ev();
extern void _ZN5S49C43v95Ev();
extern void _ZN5S49C43v96Ev();
extern void _ZN5S49C43v97Ev();
extern void _ZN5S49C33v98Ev();
extern void _ZN5S49C33v99Ev();
extern void _ZN5S49C24v112Ev();
extern void _ZN5S49C24v113Ev();
extern void _ZN5S49C24v114Ev();
extern void _ZN5S49C24v115Ev();
extern void _ZN5S49C24v116Ev();
extern void _ZN5S49C24v117Ev();
extern void _ZN5S49C24v118Ev();
extern void _ZN5S49C24v119Ev();
extern void _ZN5S49C24v120Ev();
extern void _ZN5S49C24v121Ev();
extern void _ZN5S49C24v122Ev();
extern void _ZN5S49C24v123Ev();
extern void _ZN5S49C24v124Ev();
extern void _ZN5S49C24v125Ev();
extern void _ZN5S49C24v126Ev();
extern void _ZN5S49C24v127Ev();
extern void _ZN5S49C24v128Ev();
extern void _ZN5S49C12v1Ev();
extern void _ZN5S49C12v2Ev();
extern void _ZN5S49C12v3Ev();
extern void _ZN5S49C12v4Ev();
extern void _ZN5S49C12v5Ev();
extern void _ZN5S49C12v6Ev();
extern void _ZN5S49C12v7Ev();
extern void _ZN5S49C12v8Ev();
extern void _ZN5S49C12v9Ev();
extern void _ZN5S49C13v10Ev();
extern void ABISELECT(_ZThn176_N5S49C1D1Ev,_ZThn120_N5S49C1D1Ev)();
extern void ABISELECT(_ZThn176_N5S49C1D0Ev,_ZThn120_N5S49C1D0Ev)();
extern void _ZN9S49C13_nt4v100Ev();
extern void _ZN9S49C13_nt4v101Ev();
extern void _ZN9S49C13_nt4v102Ev();
extern void _ZN9S49C13_nt4v103Ev();
extern void _ZN9S49C13_nt4v104Ev();
extern void _ZN9S49C13_nt4v105Ev();
extern void _ZN9S49C13_nt4v106Ev();
extern void _ZN9S49C13_nt4v107Ev();
extern void ABISELECT(_ZThn184_N5S49C1D1Ev,_ZThn124_N5S49C1D1Ev)();
extern void ABISELECT(_ZThn184_N5S49C1D0Ev,_ZThn124_N5S49C1D0Ev)();
extern void _ZN9S49C14_nt4v108Ev();
extern void _ZN9S49C14_nt4v109Ev();
extern void _ZN9S49C14_nt4v110Ev();
extern void _ZN9S49C14_nt4v111Ev();
static  VTBL_ENTRY vtc_S49C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S49C1[0]),
  (VTBL_ENTRY)&_ZN5S49C1D1Ev,
  (VTBL_ENTRY)&_ZN5S49C1D0Ev,
  (VTBL_ENTRY)&_ZN5S49C73v11Ev,
  (VTBL_ENTRY)&_ZN5S49C73v12Ev,
  (VTBL_ENTRY)&_ZN5S49C73v13Ev,
  (VTBL_ENTRY)&_ZN5S49C73v14Ev,
  (VTBL_ENTRY)&_ZN5S49C73v15Ev,
  (VTBL_ENTRY)&_ZN5S49C73v16Ev,
  (VTBL_ENTRY)&_ZN5S49C73v17Ev,
  (VTBL_ENTRY)&_ZN5S49C73v18Ev,
  (VTBL_ENTRY)&_ZN5S49C73v19Ev,
  (VTBL_ENTRY)&_ZN5S49C73v20Ev,
  (VTBL_ENTRY)&_ZN5S49C73v21Ev,
  (VTBL_ENTRY)&_ZN5S49C73v22Ev,
  (VTBL_ENTRY)&_ZN5S49C73v23Ev,
  (VTBL_ENTRY)&_ZN5S49C73v24Ev,
  (VTBL_ENTRY)&_ZN5S49C73v25Ev,
  (VTBL_ENTRY)&_ZN5S49C73v26Ev,
  (VTBL_ENTRY)&_ZN5S49C73v27Ev,
  (VTBL_ENTRY)&_ZN5S49C73v28Ev,
  (VTBL_ENTRY)&_ZN5S49C73v29Ev,
  (VTBL_ENTRY)&_ZN5S49C73v30Ev,
  (VTBL_ENTRY)&_ZN5S49C73v31Ev,
  (VTBL_ENTRY)&_ZN5S49C73v32Ev,
  (VTBL_ENTRY)&_ZN5S49C73v33Ev,
  (VTBL_ENTRY)&_ZN5S49C73v34Ev,
  (VTBL_ENTRY)&_ZN5S49C73v35Ev,
  (VTBL_ENTRY)&_ZN5S49C73v36Ev,
  (VTBL_ENTRY)&_ZN5S49C73v37Ev,
  (VTBL_ENTRY)&_ZN5S49C73v38Ev,
  (VTBL_ENTRY)&_ZN5S49C73v39Ev,
  (VTBL_ENTRY)&_ZN5S49C73v40Ev,
  (VTBL_ENTRY)&_ZN5S49C73v41Ev,
  (VTBL_ENTRY)&_ZN5S49C73v42Ev,
  (VTBL_ENTRY)&_ZN5S49C73v43Ev,
  (VTBL_ENTRY)&_ZN5S49C73v44Ev,
  (VTBL_ENTRY)&_ZN5S49C73v45Ev,
  (VTBL_ENTRY)&_ZN5S49C73v46Ev,
  (VTBL_ENTRY)&_ZN5S49C73v47Ev,
  (VTBL_ENTRY)&_ZN5S49C73v48Ev,
  (VTBL_ENTRY)&_ZN5S49C73v49Ev,
  (VTBL_ENTRY)&_ZN5S49C73v50Ev,
  (VTBL_ENTRY)&_ZN5S49C73v51Ev,
  (VTBL_ENTRY)&_ZN5S49C73v52Ev,
  (VTBL_ENTRY)&_ZN5S49C73v53Ev,
  (VTBL_ENTRY)&_ZN5S49C73v54Ev,
  (VTBL_ENTRY)&_ZN5S49C73v55Ev,
  (VTBL_ENTRY)&_ZN5S49C73v56Ev,
  (VTBL_ENTRY)&_ZN5S49C73v57Ev,
  (VTBL_ENTRY)&_ZN5S49C73v58Ev,
  (VTBL_ENTRY)&_ZN5S49C73v59Ev,
  (VTBL_ENTRY)&_ZN5S49C73v60Ev,
  (VTBL_ENTRY)&_ZN5S49C73v61Ev,
  (VTBL_ENTRY)&_ZN5S49C73v62Ev,
  (VTBL_ENTRY)&_ZN5S49C73v63Ev,
  (VTBL_ENTRY)&_ZN5S49C73v64Ev,
  (VTBL_ENTRY)&_ZN5S49C73v65Ev,
  (VTBL_ENTRY)&_ZN5S49C73v66Ev,
  (VTBL_ENTRY)&_ZN5S49C73v67Ev,
  (VTBL_ENTRY)&_ZN5S49C73v68Ev,
  (VTBL_ENTRY)&_ZN5S49C73v69Ev,
  (VTBL_ENTRY)&_ZN5S49C73v70Ev,
  (VTBL_ENTRY)&_ZN5S49C73v71Ev,
  (VTBL_ENTRY)&_ZN5S49C73v72Ev,
  (VTBL_ENTRY)&_ZN5S49C73v73Ev,
  (VTBL_ENTRY)&_ZN5S49C73v74Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S49C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN5S49C53v77Ev,
  (VTBL_ENTRY)&_ZN5S49C53v78Ev,
  (VTBL_ENTRY)&_ZN5S49C53v79Ev,
  (VTBL_ENTRY)&_ZN5S49C53v80Ev,
  (VTBL_ENTRY)&_ZN5S49C53v81Ev,
  (VTBL_ENTRY)&_ZN5S49C53v82Ev,
  (VTBL_ENTRY)&_ZN5S49C53v83Ev,
  (VTBL_ENTRY)&_ZN5S49C53v84Ev,
  (VTBL_ENTRY)&_ZN5S49C53v85Ev,
  (VTBL_ENTRY)&_ZN5S49C53v86Ev,
  (VTBL_ENTRY)&_ZN5S49C53v87Ev,
  (VTBL_ENTRY)&_ZN5S49C53v88Ev,
  (VTBL_ENTRY)&_ZN5S49C43v89Ev,
  (VTBL_ENTRY)&_ZN5S49C43v90Ev,
  (VTBL_ENTRY)&_ZN5S49C43v91Ev,
  (VTBL_ENTRY)&_ZN5S49C43v92Ev,
  (VTBL_ENTRY)&_ZN5S49C43v93Ev,
  (VTBL_ENTRY)&_ZN5S49C43v94Ev,
  (VTBL_ENTRY)&_ZN5S49C43v95Ev,
  (VTBL_ENTRY)&_ZN5S49C43v96Ev,
  (VTBL_ENTRY)&_ZN5S49C43v97Ev,
  (VTBL_ENTRY)&_ZN5S49C33v98Ev,
  (VTBL_ENTRY)&_ZN5S49C33v99Ev,
  (VTBL_ENTRY)&_ZN5S49C24v112Ev,
  (VTBL_ENTRY)&_ZN5S49C24v113Ev,
  (VTBL_ENTRY)&_ZN5S49C24v114Ev,
  (VTBL_ENTRY)&_ZN5S49C24v115Ev,
  (VTBL_ENTRY)&_ZN5S49C24v116Ev,
  (VTBL_ENTRY)&_ZN5S49C24v117Ev,
  (VTBL_ENTRY)&_ZN5S49C24v118Ev,
  (VTBL_ENTRY)&_ZN5S49C24v119Ev,
  (VTBL_ENTRY)&_ZN5S49C24v120Ev,
  (VTBL_ENTRY)&_ZN5S49C24v121Ev,
  (VTBL_ENTRY)&_ZN5S49C24v122Ev,
  (VTBL_ENTRY)&_ZN5S49C24v123Ev,
  (VTBL_ENTRY)&_ZN5S49C24v124Ev,
  (VTBL_ENTRY)&_ZN5S49C24v125Ev,
  (VTBL_ENTRY)&_ZN5S49C24v126Ev,
  (VTBL_ENTRY)&_ZN5S49C24v127Ev,
  (VTBL_ENTRY)&_ZN5S49C24v128Ev,
  (VTBL_ENTRY)&_ZN5S49C12v1Ev,
  (VTBL_ENTRY)&_ZN5S49C12v2Ev,
  (VTBL_ENTRY)&_ZN5S49C12v3Ev,
  (VTBL_ENTRY)&_ZN5S49C12v4Ev,
  (VTBL_ENTRY)&_ZN5S49C12v5Ev,
  (VTBL_ENTRY)&_ZN5S49C12v6Ev,
  (VTBL_ENTRY)&_ZN5S49C12v7Ev,
  (VTBL_ENTRY)&_ZN5S49C12v8Ev,
  (VTBL_ENTRY)&_ZN5S49C12v9Ev,
  (VTBL_ENTRY)&_ZN5S49C13v10Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI5S49C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S49C1D1Ev,_ZThn120_N5S49C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S49C1D0Ev,_ZThn120_N5S49C1D0Ev),
  (VTBL_ENTRY)&_ZN9S49C13_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S49C13_nt4v107Ev,
  ABISELECT(-184,-124),
  (VTBL_ENTRY)&(_ZTI5S49C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S49C1D1Ev,_ZThn124_N5S49C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S49C1D0Ev,_ZThn124_N5S49C1D0Ev),
  (VTBL_ENTRY)&_ZN9S49C14_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S49C14_nt4v111Ev,
};
extern VTBL_ENTRY _ZTI5S49C1[];
extern  VTBL_ENTRY _ZTV5S49C1[];
Class_Descriptor cd_S49C1 = {  "S49C1", // class name
  bases_S49C1, 8,
  &(vtc_S49C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,328), // object size
  NSPAIRA(_ZTI5S49C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S49C1),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C5  {
  int s637c5f0;
  __tsi64 s637c5f1;
  void *s637c5f2[4];
  int s637c5f3[2];
  void *s637c5f4;
  ::S3422C4_nt s637c5f5;
  void *s637c5f6[2];
  virtual  ~S637C5(); // _ZN6S637C5D1Ev
  virtual void  v5(); // _ZN6S637C52v5Ev
  virtual void  v6(); // _ZN6S637C52v6Ev
  virtual void  v7(); // _ZN6S637C52v7Ev
  virtual void  v8(); // _ZN6S637C52v8Ev
  virtual void  v9(); // _ZN6S637C52v9Ev
  virtual void  v10(); // _ZN6S637C53v10Ev
  virtual void  v11(); // _ZN6S637C53v11Ev
  virtual void  v12(); // _ZN6S637C53v12Ev
  virtual void  v13(); // _ZN6S637C53v13Ev
  virtual void  v14(); // _ZN6S637C53v14Ev
  virtual void  v15(); // _ZN6S637C53v15Ev
  virtual void  v16(); // _ZN6S637C53v16Ev
  virtual void  v17(); // _ZN6S637C53v17Ev
  virtual void  v18(); // _ZN6S637C53v18Ev
  virtual void  v19(); // _ZN6S637C53v19Ev
  virtual void  v20(); // _ZN6S637C53v20Ev
  virtual void  v21(); // _ZN6S637C53v21Ev
  virtual void  v22(); // _ZN6S637C53v22Ev
  virtual void  v23(); // _ZN6S637C53v23Ev
  virtual void  v24(); // _ZN6S637C53v24Ev
  virtual void  v25(); // _ZN6S637C53v25Ev
  virtual void  v26(); // _ZN6S637C53v26Ev
  virtual void  v27(); // _ZN6S637C53v27Ev
  virtual void  v28(); // _ZN6S637C53v28Ev
  virtual void  v29(); // _ZN6S637C53v29Ev
  virtual void  v30(); // _ZN6S637C53v30Ev
  virtual void  v31(); // _ZN6S637C53v31Ev
  virtual void  v32(); // _ZN6S637C53v32Ev
  virtual void  v33(); // _ZN6S637C53v33Ev
  virtual void  v34(); // _ZN6S637C53v34Ev
  virtual void  v35(); // _ZN6S637C53v35Ev
  virtual void  v36(); // _ZN6S637C53v36Ev
  virtual void  v37(); // _ZN6S637C53v37Ev
  virtual void  v38(); // _ZN6S637C53v38Ev
  virtual void  v39(); // _ZN6S637C53v39Ev
  virtual void  v40(); // _ZN6S637C53v40Ev
  virtual void  v41(); // _ZN6S637C53v41Ev
  virtual void  v42(); // _ZN6S637C53v42Ev
  virtual void  v43(); // _ZN6S637C53v43Ev
  virtual void  v44(); // _ZN6S637C53v44Ev
  virtual void  v45(); // _ZN6S637C53v45Ev
  virtual void  v46(); // _ZN6S637C53v46Ev
  virtual void  v47(); // _ZN6S637C53v47Ev
  virtual void  v48(); // _ZN6S637C53v48Ev
  virtual void  v49(); // _ZN6S637C53v49Ev
  virtual void  v50(); // _ZN6S637C53v50Ev
  virtual void  v51(); // _ZN6S637C53v51Ev
  virtual void  v52(); // _ZN6S637C53v52Ev
  virtual void  v53(); // _ZN6S637C53v53Ev
  virtual void  v54(); // _ZN6S637C53v54Ev
  virtual void  v55(); // _ZN6S637C53v55Ev
  virtual void  v56(); // _ZN6S637C53v56Ev
  virtual void  v57(); // _ZN6S637C53v57Ev
  virtual void  v58(); // _ZN6S637C53v58Ev
  virtual void  v59(); // _ZN6S637C53v59Ev
  virtual void  v60(); // _ZN6S637C53v60Ev
  virtual void  v61(); // _ZN6S637C53v61Ev
  virtual void  v62(); // _ZN6S637C53v62Ev
  virtual void  v63(); // _ZN6S637C53v63Ev
  virtual void  v64(); // _ZN6S637C53v64Ev
  virtual void  v65(); // _ZN6S637C53v65Ev
  virtual void  v66(); // _ZN6S637C53v66Ev
  virtual void  v67(); // _ZN6S637C53v67Ev
  virtual void  v68(); // _ZN6S637C53v68Ev
  S637C5(); // tgen
};
//SIG(-1 S637C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S637C5 ::~S637C5(){ note_dtor("S637C5", this);}
void  S637C5 ::v5(){vfunc_called(this, "_ZN6S637C52v5Ev");}
void  S637C5 ::v6(){vfunc_called(this, "_ZN6S637C52v6Ev");}
void  S637C5 ::v7(){vfunc_called(this, "_ZN6S637C52v7Ev");}
void  S637C5 ::v8(){vfunc_called(this, "_ZN6S637C52v8Ev");}
void  S637C5 ::v9(){vfunc_called(this, "_ZN6S637C52v9Ev");}
void  S637C5 ::v10(){vfunc_called(this, "_ZN6S637C53v10Ev");}
void  S637C5 ::v11(){vfunc_called(this, "_ZN6S637C53v11Ev");}
void  S637C5 ::v12(){vfunc_called(this, "_ZN6S637C53v12Ev");}
void  S637C5 ::v13(){vfunc_called(this, "_ZN6S637C53v13Ev");}
void  S637C5 ::v14(){vfunc_called(this, "_ZN6S637C53v14Ev");}
void  S637C5 ::v15(){vfunc_called(this, "_ZN6S637C53v15Ev");}
void  S637C5 ::v16(){vfunc_called(this, "_ZN6S637C53v16Ev");}
void  S637C5 ::v17(){vfunc_called(this, "_ZN6S637C53v17Ev");}
void  S637C5 ::v18(){vfunc_called(this, "_ZN6S637C53v18Ev");}
void  S637C5 ::v19(){vfunc_called(this, "_ZN6S637C53v19Ev");}
void  S637C5 ::v20(){vfunc_called(this, "_ZN6S637C53v20Ev");}
void  S637C5 ::v21(){vfunc_called(this, "_ZN6S637C53v21Ev");}
void  S637C5 ::v22(){vfunc_called(this, "_ZN6S637C53v22Ev");}
void  S637C5 ::v23(){vfunc_called(this, "_ZN6S637C53v23Ev");}
void  S637C5 ::v24(){vfunc_called(this, "_ZN6S637C53v24Ev");}
void  S637C5 ::v25(){vfunc_called(this, "_ZN6S637C53v25Ev");}
void  S637C5 ::v26(){vfunc_called(this, "_ZN6S637C53v26Ev");}
void  S637C5 ::v27(){vfunc_called(this, "_ZN6S637C53v27Ev");}
void  S637C5 ::v28(){vfunc_called(this, "_ZN6S637C53v28Ev");}
void  S637C5 ::v29(){vfunc_called(this, "_ZN6S637C53v29Ev");}
void  S637C5 ::v30(){vfunc_called(this, "_ZN6S637C53v30Ev");}
void  S637C5 ::v31(){vfunc_called(this, "_ZN6S637C53v31Ev");}
void  S637C5 ::v32(){vfunc_called(this, "_ZN6S637C53v32Ev");}
void  S637C5 ::v33(){vfunc_called(this, "_ZN6S637C53v33Ev");}
void  S637C5 ::v34(){vfunc_called(this, "_ZN6S637C53v34Ev");}
void  S637C5 ::v35(){vfunc_called(this, "_ZN6S637C53v35Ev");}
void  S637C5 ::v36(){vfunc_called(this, "_ZN6S637C53v36Ev");}
void  S637C5 ::v37(){vfunc_called(this, "_ZN6S637C53v37Ev");}
void  S637C5 ::v38(){vfunc_called(this, "_ZN6S637C53v38Ev");}
void  S637C5 ::v39(){vfunc_called(this, "_ZN6S637C53v39Ev");}
void  S637C5 ::v40(){vfunc_called(this, "_ZN6S637C53v40Ev");}
void  S637C5 ::v41(){vfunc_called(this, "_ZN6S637C53v41Ev");}
void  S637C5 ::v42(){vfunc_called(this, "_ZN6S637C53v42Ev");}
void  S637C5 ::v43(){vfunc_called(this, "_ZN6S637C53v43Ev");}
void  S637C5 ::v44(){vfunc_called(this, "_ZN6S637C53v44Ev");}
void  S637C5 ::v45(){vfunc_called(this, "_ZN6S637C53v45Ev");}
void  S637C5 ::v46(){vfunc_called(this, "_ZN6S637C53v46Ev");}
void  S637C5 ::v47(){vfunc_called(this, "_ZN6S637C53v47Ev");}
void  S637C5 ::v48(){vfunc_called(this, "_ZN6S637C53v48Ev");}
void  S637C5 ::v49(){vfunc_called(this, "_ZN6S637C53v49Ev");}
void  S637C5 ::v50(){vfunc_called(this, "_ZN6S637C53v50Ev");}
void  S637C5 ::v51(){vfunc_called(this, "_ZN6S637C53v51Ev");}
void  S637C5 ::v52(){vfunc_called(this, "_ZN6S637C53v52Ev");}
void  S637C5 ::v53(){vfunc_called(this, "_ZN6S637C53v53Ev");}
void  S637C5 ::v54(){vfunc_called(this, "_ZN6S637C53v54Ev");}
void  S637C5 ::v55(){vfunc_called(this, "_ZN6S637C53v55Ev");}
void  S637C5 ::v56(){vfunc_called(this, "_ZN6S637C53v56Ev");}
void  S637C5 ::v57(){vfunc_called(this, "_ZN6S637C53v57Ev");}
void  S637C5 ::v58(){vfunc_called(this, "_ZN6S637C53v58Ev");}
void  S637C5 ::v59(){vfunc_called(this, "_ZN6S637C53v59Ev");}
void  S637C5 ::v60(){vfunc_called(this, "_ZN6S637C53v60Ev");}
void  S637C5 ::v61(){vfunc_called(this, "_ZN6S637C53v61Ev");}
void  S637C5 ::v62(){vfunc_called(this, "_ZN6S637C53v62Ev");}
void  S637C5 ::v63(){vfunc_called(this, "_ZN6S637C53v63Ev");}
void  S637C5 ::v64(){vfunc_called(this, "_ZN6S637C53v64Ev");}
void  S637C5 ::v65(){vfunc_called(this, "_ZN6S637C53v65Ev");}
void  S637C5 ::v66(){vfunc_called(this, "_ZN6S637C53v66Ev");}
void  S637C5 ::v67(){vfunc_called(this, "_ZN6S637C53v67Ev");}
void  S637C5 ::v68(){vfunc_called(this, "_ZN6S637C53v68Ev");}
S637C5 ::S637C5(){ note_ctor("S637C5", this);} // tgen

static void Test_S637C5()
{
  extern Class_Descriptor cd_S637C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S637C5, buf);
    S637C5 *dp, &lv = *(dp=new (buf) S637C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S637C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S637C5)");
    check_field_offset(lv, s637c5f0, ABISELECT(8,4), "S637C5.s637c5f0");
    check_field_offset(lv, s637c5f1, ABISELECT(16,8), "S637C5.s637c5f1");
    check_field_offset(lv, s637c5f2, ABISELECT(24,16), "S637C5.s637c5f2");
    check_field_offset(lv, s637c5f3, ABISELECT(56,32), "S637C5.s637c5f3");
    check_field_offset(lv, s637c5f4, ABISELECT(64,40), "S637C5.s637c5f4");
    check_field_offset(lv, s637c5f5, ABISELECT(72,44), "S637C5.s637c5f5");
    check_field_offset(lv, s637c5f6, ABISELECT(80,52), "S637C5.s637c5f6");
    test_class_info(&lv, &cd_S637C5);
    dp->~S637C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS637C5(Test_S637C5, "S637C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S637C5C1Ev();
extern void _ZN6S637C5D1Ev();
Name_Map name_map_S637C5[] = {
  NSPAIR(_ZN6S637C5C1Ev),
  NSPAIR(_ZN6S637C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S637C5[];
extern void _ZN6S637C5D1Ev();
extern void _ZN6S637C5D0Ev();
extern void _ZN6S637C52v5Ev();
extern void _ZN6S637C52v6Ev();
extern void _ZN6S637C52v7Ev();
extern void _ZN6S637C52v8Ev();
extern void _ZN6S637C52v9Ev();
extern void _ZN6S637C53v10Ev();
extern void _ZN6S637C53v11Ev();
extern void _ZN6S637C53v12Ev();
extern void _ZN6S637C53v13Ev();
extern void _ZN6S637C53v14Ev();
extern void _ZN6S637C53v15Ev();
extern void _ZN6S637C53v16Ev();
extern void _ZN6S637C53v17Ev();
extern void _ZN6S637C53v18Ev();
extern void _ZN6S637C53v19Ev();
extern void _ZN6S637C53v20Ev();
extern void _ZN6S637C53v21Ev();
extern void _ZN6S637C53v22Ev();
extern void _ZN6S637C53v23Ev();
extern void _ZN6S637C53v24Ev();
extern void _ZN6S637C53v25Ev();
extern void _ZN6S637C53v26Ev();
extern void _ZN6S637C53v27Ev();
extern void _ZN6S637C53v28Ev();
extern void _ZN6S637C53v29Ev();
extern void _ZN6S637C53v30Ev();
extern void _ZN6S637C53v31Ev();
extern void _ZN6S637C53v32Ev();
extern void _ZN6S637C53v33Ev();
extern void _ZN6S637C53v34Ev();
extern void _ZN6S637C53v35Ev();
extern void _ZN6S637C53v36Ev();
extern void _ZN6S637C53v37Ev();
extern void _ZN6S637C53v38Ev();
extern void _ZN6S637C53v39Ev();
extern void _ZN6S637C53v40Ev();
extern void _ZN6S637C53v41Ev();
extern void _ZN6S637C53v42Ev();
extern void _ZN6S637C53v43Ev();
extern void _ZN6S637C53v44Ev();
extern void _ZN6S637C53v45Ev();
extern void _ZN6S637C53v46Ev();
extern void _ZN6S637C53v47Ev();
extern void _ZN6S637C53v48Ev();
extern void _ZN6S637C53v49Ev();
extern void _ZN6S637C53v50Ev();
extern void _ZN6S637C53v51Ev();
extern void _ZN6S637C53v52Ev();
extern void _ZN6S637C53v53Ev();
extern void _ZN6S637C53v54Ev();
extern void _ZN6S637C53v55Ev();
extern void _ZN6S637C53v56Ev();
extern void _ZN6S637C53v57Ev();
extern void _ZN6S637C53v58Ev();
extern void _ZN6S637C53v59Ev();
extern void _ZN6S637C53v60Ev();
extern void _ZN6S637C53v61Ev();
extern void _ZN6S637C53v62Ev();
extern void _ZN6S637C53v63Ev();
extern void _ZN6S637C53v64Ev();
extern void _ZN6S637C53v65Ev();
extern void _ZN6S637C53v66Ev();
extern void _ZN6S637C53v67Ev();
extern void _ZN6S637C53v68Ev();
static  VTBL_ENTRY vtc_S637C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S637C5[0]),
  (VTBL_ENTRY)&_ZN6S637C5D1Ev,
  (VTBL_ENTRY)&_ZN6S637C5D0Ev,
  (VTBL_ENTRY)&_ZN6S637C52v5Ev,
  (VTBL_ENTRY)&_ZN6S637C52v6Ev,
  (VTBL_ENTRY)&_ZN6S637C52v7Ev,
  (VTBL_ENTRY)&_ZN6S637C52v8Ev,
  (VTBL_ENTRY)&_ZN6S637C52v9Ev,
  (VTBL_ENTRY)&_ZN6S637C53v10Ev,
  (VTBL_ENTRY)&_ZN6S637C53v11Ev,
  (VTBL_ENTRY)&_ZN6S637C53v12Ev,
  (VTBL_ENTRY)&_ZN6S637C53v13Ev,
  (VTBL_ENTRY)&_ZN6S637C53v14Ev,
  (VTBL_ENTRY)&_ZN6S637C53v15Ev,
  (VTBL_ENTRY)&_ZN6S637C53v16Ev,
  (VTBL_ENTRY)&_ZN6S637C53v17Ev,
  (VTBL_ENTRY)&_ZN6S637C53v18Ev,
  (VTBL_ENTRY)&_ZN6S637C53v19Ev,
  (VTBL_ENTRY)&_ZN6S637C53v20Ev,
  (VTBL_ENTRY)&_ZN6S637C53v21Ev,
  (VTBL_ENTRY)&_ZN6S637C53v22Ev,
  (VTBL_ENTRY)&_ZN6S637C53v23Ev,
  (VTBL_ENTRY)&_ZN6S637C53v24Ev,
  (VTBL_ENTRY)&_ZN6S637C53v25Ev,
  (VTBL_ENTRY)&_ZN6S637C53v26Ev,
  (VTBL_ENTRY)&_ZN6S637C53v27Ev,
  (VTBL_ENTRY)&_ZN6S637C53v28Ev,
  (VTBL_ENTRY)&_ZN6S637C53v29Ev,
  (VTBL_ENTRY)&_ZN6S637C53v30Ev,
  (VTBL_ENTRY)&_ZN6S637C53v31Ev,
  (VTBL_ENTRY)&_ZN6S637C53v32Ev,
  (VTBL_ENTRY)&_ZN6S637C53v33Ev,
  (VTBL_ENTRY)&_ZN6S637C53v34Ev,
  (VTBL_ENTRY)&_ZN6S637C53v35Ev,
  (VTBL_ENTRY)&_ZN6S637C53v36Ev,
  (VTBL_ENTRY)&_ZN6S637C53v37Ev,
  (VTBL_ENTRY)&_ZN6S637C53v38Ev,
  (VTBL_ENTRY)&_ZN6S637C53v39Ev,
  (VTBL_ENTRY)&_ZN6S637C53v40Ev,
  (VTBL_ENTRY)&_ZN6S637C53v41Ev,
  (VTBL_ENTRY)&_ZN6S637C53v42Ev,
  (VTBL_ENTRY)&_ZN6S637C53v43Ev,
  (VTBL_ENTRY)&_ZN6S637C53v44Ev,
  (VTBL_ENTRY)&_ZN6S637C53v45Ev,
  (VTBL_ENTRY)&_ZN6S637C53v46Ev,
  (VTBL_ENTRY)&_ZN6S637C53v47Ev,
  (VTBL_ENTRY)&_ZN6S637C53v48Ev,
  (VTBL_ENTRY)&_ZN6S637C53v49Ev,
  (VTBL_ENTRY)&_ZN6S637C53v50Ev,
  (VTBL_ENTRY)&_ZN6S637C53v51Ev,
  (VTBL_ENTRY)&_ZN6S637C53v52Ev,
  (VTBL_ENTRY)&_ZN6S637C53v53Ev,
  (VTBL_ENTRY)&_ZN6S637C53v54Ev,
  (VTBL_ENTRY)&_ZN6S637C53v55Ev,
  (VTBL_ENTRY)&_ZN6S637C53v56Ev,
  (VTBL_ENTRY)&_ZN6S637C53v57Ev,
  (VTBL_ENTRY)&_ZN6S637C53v58Ev,
  (VTBL_ENTRY)&_ZN6S637C53v59Ev,
  (VTBL_ENTRY)&_ZN6S637C53v60Ev,
  (VTBL_ENTRY)&_ZN6S637C53v61Ev,
  (VTBL_ENTRY)&_ZN6S637C53v62Ev,
  (VTBL_ENTRY)&_ZN6S637C53v63Ev,
  (VTBL_ENTRY)&_ZN6S637C53v64Ev,
  (VTBL_ENTRY)&_ZN6S637C53v65Ev,
  (VTBL_ENTRY)&_ZN6S637C53v66Ev,
  (VTBL_ENTRY)&_ZN6S637C53v67Ev,
  (VTBL_ENTRY)&_ZN6S637C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S637C5[];
extern  VTBL_ENTRY _ZTV6S637C5[];
Class_Descriptor cd_S637C5 = {  "S637C5", // class name
  0,0,//no base classes
  &(vtc_S637C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S637C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S637C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C4_nt  : S637C5 {
  int s637c4f0[2];
  void *s637c4f1;
  int s637c4f2[2];
  ::S3422C22_nt s637c4f3;
  ::S3422C22_nt s637c4f4;
  ::S5167C29 s637c4f5;
  ::S3422C22_nt s637c4f6;
  unsigned int s637c4f7:1;
  unsigned int s637c4f8:1;
  unsigned int s637c4f9:1;
  unsigned int s637c4f10:1;
  unsigned int s637c4f11:1;
  int s637c4f12[2];
  virtual  ~S637C4_nt(); // _ZN9S637C4_ntD1Ev
  virtual void  v69(); // _ZN9S637C4_nt3v69Ev
  virtual void  v70(); // _ZN9S637C4_nt3v70Ev
  virtual void  v71(); // _ZN9S637C4_nt3v71Ev
  virtual void  v72(); // _ZN9S637C4_nt3v72Ev
  virtual void  v73(); // _ZN9S637C4_nt3v73Ev
  virtual void  v74(); // _ZN9S637C4_nt3v74Ev
  virtual void  v75(); // _ZN9S637C4_nt3v75Ev
  virtual void  v76(); // _ZN9S637C4_nt3v76Ev
  virtual void  v77(); // _ZN9S637C4_nt3v77Ev
  virtual void  v78(); // _ZN9S637C4_nt3v78Ev
  virtual void  v79(); // _ZN9S637C4_nt3v79Ev
  virtual void  v80(); // _ZN9S637C4_nt3v80Ev
  virtual void  v81(); // _ZN9S637C4_nt3v81Ev
  virtual void  v82(); // _ZN9S637C4_nt3v82Ev
  virtual void  v83(); // _ZN9S637C4_nt3v83Ev
  virtual void  v84(); // _ZN9S637C4_nt3v84Ev
  virtual void  v85(); // _ZN9S637C4_nt3v85Ev
  virtual void  v86(); // _ZN9S637C4_nt3v86Ev
  virtual void  v87(); // _ZN9S637C4_nt3v87Ev
  virtual void  v88(); // _ZN9S637C4_nt3v88Ev
  virtual void  v89(); // _ZN9S637C4_nt3v89Ev
  virtual void  v90(); // _ZN9S637C4_nt3v90Ev
  S637C4_nt(); // tgen
};
//SIG(-1 S637C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S637C4_nt ::~S637C4_nt(){ note_dtor("S637C4_nt", this);}
void  S637C4_nt ::v69(){vfunc_called(this, "_ZN9S637C4_nt3v69Ev");}
void  S637C4_nt ::v70(){vfunc_called(this, "_ZN9S637C4_nt3v70Ev");}
void  S637C4_nt ::v71(){vfunc_called(this, "_ZN9S637C4_nt3v71Ev");}
void  S637C4_nt ::v72(){vfunc_called(this, "_ZN9S637C4_nt3v72Ev");}
void  S637C4_nt ::v73(){vfunc_called(this, "_ZN9S637C4_nt3v73Ev");}
void  S637C4_nt ::v74(){vfunc_called(this, "_ZN9S637C4_nt3v74Ev");}
void  S637C4_nt ::v75(){vfunc_called(this, "_ZN9S637C4_nt3v75Ev");}
void  S637C4_nt ::v76(){vfunc_called(this, "_ZN9S637C4_nt3v76Ev");}
void  S637C4_nt ::v77(){vfunc_called(this, "_ZN9S637C4_nt3v77Ev");}
void  S637C4_nt ::v78(){vfunc_called(this, "_ZN9S637C4_nt3v78Ev");}
void  S637C4_nt ::v79(){vfunc_called(this, "_ZN9S637C4_nt3v79Ev");}
void  S637C4_nt ::v80(){vfunc_called(this, "_ZN9S637C4_nt3v80Ev");}
void  S637C4_nt ::v81(){vfunc_called(this, "_ZN9S637C4_nt3v81Ev");}
void  S637C4_nt ::v82(){vfunc_called(this, "_ZN9S637C4_nt3v82Ev");}
void  S637C4_nt ::v83(){vfunc_called(this, "_ZN9S637C4_nt3v83Ev");}
void  S637C4_nt ::v84(){vfunc_called(this, "_ZN9S637C4_nt3v84Ev");}
void  S637C4_nt ::v85(){vfunc_called(this, "_ZN9S637C4_nt3v85Ev");}
void  S637C4_nt ::v86(){vfunc_called(this, "_ZN9S637C4_nt3v86Ev");}
void  S637C4_nt ::v87(){vfunc_called(this, "_ZN9S637C4_nt3v87Ev");}
void  S637C4_nt ::v88(){vfunc_called(this, "_ZN9S637C4_nt3v88Ev");}
void  S637C4_nt ::v89(){vfunc_called(this, "_ZN9S637C4_nt3v89Ev");}
void  S637C4_nt ::v90(){vfunc_called(this, "_ZN9S637C4_nt3v90Ev");}
S637C4_nt ::S637C4_nt(){ note_ctor("S637C4_nt", this);} // tgen

//skip512 S637C4_nt

#else // __cplusplus

extern void _ZN9S637C4_ntC1Ev();
extern void _ZN9S637C4_ntD1Ev();
Name_Map name_map_S637C4_nt[] = {
  NSPAIR(_ZN9S637C4_ntC1Ev),
  NSPAIR(_ZN9S637C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S637C5;
extern VTBL_ENTRY _ZTI6S637C5[];
extern  VTBL_ENTRY _ZTV6S637C5[];
static Base_Class bases_S637C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S637C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S637C4_nt[];
extern void _ZN9S637C4_ntD1Ev();
extern void _ZN9S637C4_ntD0Ev();
extern void _ZN6S637C52v5Ev();
extern void _ZN6S637C52v6Ev();
extern void _ZN6S637C52v7Ev();
extern void _ZN6S637C52v8Ev();
extern void _ZN6S637C52v9Ev();
extern void _ZN6S637C53v10Ev();
extern void _ZN6S637C53v11Ev();
extern void _ZN6S637C53v12Ev();
extern void _ZN6S637C53v13Ev();
extern void _ZN6S637C53v14Ev();
extern void _ZN6S637C53v15Ev();
extern void _ZN6S637C53v16Ev();
extern void _ZN6S637C53v17Ev();
extern void _ZN6S637C53v18Ev();
extern void _ZN6S637C53v19Ev();
extern void _ZN6S637C53v20Ev();
extern void _ZN6S637C53v21Ev();
extern void _ZN6S637C53v22Ev();
extern void _ZN6S637C53v23Ev();
extern void _ZN6S637C53v24Ev();
extern void _ZN6S637C53v25Ev();
extern void _ZN6S637C53v26Ev();
extern void _ZN6S637C53v27Ev();
extern void _ZN6S637C53v28Ev();
extern void _ZN6S637C53v29Ev();
extern void _ZN6S637C53v30Ev();
extern void _ZN6S637C53v31Ev();
extern void _ZN6S637C53v32Ev();
extern void _ZN6S637C53v33Ev();
extern void _ZN6S637C53v34Ev();
extern void _ZN6S637C53v35Ev();
extern void _ZN6S637C53v36Ev();
extern void _ZN6S637C53v37Ev();
extern void _ZN6S637C53v38Ev();
extern void _ZN6S637C53v39Ev();
extern void _ZN6S637C53v40Ev();
extern void _ZN6S637C53v41Ev();
extern void _ZN6S637C53v42Ev();
extern void _ZN6S637C53v43Ev();
extern void _ZN6S637C53v44Ev();
extern void _ZN6S637C53v45Ev();
extern void _ZN6S637C53v46Ev();
extern void _ZN6S637C53v47Ev();
extern void _ZN6S637C53v48Ev();
extern void _ZN6S637C53v49Ev();
extern void _ZN6S637C53v50Ev();
extern void _ZN6S637C53v51Ev();
extern void _ZN6S637C53v52Ev();
extern void _ZN6S637C53v53Ev();
extern void _ZN6S637C53v54Ev();
extern void _ZN6S637C53v55Ev();
extern void _ZN6S637C53v56Ev();
extern void _ZN6S637C53v57Ev();
extern void _ZN6S637C53v58Ev();
extern void _ZN6S637C53v59Ev();
extern void _ZN6S637C53v60Ev();
extern void _ZN6S637C53v61Ev();
extern void _ZN6S637C53v62Ev();
extern void _ZN6S637C53v63Ev();
extern void _ZN6S637C53v64Ev();
extern void _ZN6S637C53v65Ev();
extern void _ZN6S637C53v66Ev();
extern void _ZN6S637C53v67Ev();
extern void _ZN6S637C53v68Ev();
extern void _ZN9S637C4_nt3v69Ev();
extern void _ZN9S637C4_nt3v70Ev();
extern void _ZN9S637C4_nt3v71Ev();
extern void _ZN9S637C4_nt3v72Ev();
extern void _ZN9S637C4_nt3v73Ev();
extern void _ZN9S637C4_nt3v74Ev();
extern void _ZN9S637C4_nt3v75Ev();
extern void _ZN9S637C4_nt3v76Ev();
extern void _ZN9S637C4_nt3v77Ev();
extern void _ZN9S637C4_nt3v78Ev();
extern void _ZN9S637C4_nt3v79Ev();
extern void _ZN9S637C4_nt3v80Ev();
extern void _ZN9S637C4_nt3v81Ev();
extern void _ZN9S637C4_nt3v82Ev();
extern void _ZN9S637C4_nt3v83Ev();
extern void _ZN9S637C4_nt3v84Ev();
extern void _ZN9S637C4_nt3v85Ev();
extern void _ZN9S637C4_nt3v86Ev();
extern void _ZN9S637C4_nt3v87Ev();
extern void _ZN9S637C4_nt3v88Ev();
extern void _ZN9S637C4_nt3v89Ev();
extern void _ZN9S637C4_nt3v90Ev();
static  VTBL_ENTRY vtc_S637C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S637C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S637C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S637C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S637C52v5Ev,
  (VTBL_ENTRY)&_ZN6S637C52v6Ev,
  (VTBL_ENTRY)&_ZN6S637C52v7Ev,
  (VTBL_ENTRY)&_ZN6S637C52v8Ev,
  (VTBL_ENTRY)&_ZN6S637C52v9Ev,
  (VTBL_ENTRY)&_ZN6S637C53v10Ev,
  (VTBL_ENTRY)&_ZN6S637C53v11Ev,
  (VTBL_ENTRY)&_ZN6S637C53v12Ev,
  (VTBL_ENTRY)&_ZN6S637C53v13Ev,
  (VTBL_ENTRY)&_ZN6S637C53v14Ev,
  (VTBL_ENTRY)&_ZN6S637C53v15Ev,
  (VTBL_ENTRY)&_ZN6S637C53v16Ev,
  (VTBL_ENTRY)&_ZN6S637C53v17Ev,
  (VTBL_ENTRY)&_ZN6S637C53v18Ev,
  (VTBL_ENTRY)&_ZN6S637C53v19Ev,
  (VTBL_ENTRY)&_ZN6S637C53v20Ev,
  (VTBL_ENTRY)&_ZN6S637C53v21Ev,
  (VTBL_ENTRY)&_ZN6S637C53v22Ev,
  (VTBL_ENTRY)&_ZN6S637C53v23Ev,
  (VTBL_ENTRY)&_ZN6S637C53v24Ev,
  (VTBL_ENTRY)&_ZN6S637C53v25Ev,
  (VTBL_ENTRY)&_ZN6S637C53v26Ev,
  (VTBL_ENTRY)&_ZN6S637C53v27Ev,
  (VTBL_ENTRY)&_ZN6S637C53v28Ev,
  (VTBL_ENTRY)&_ZN6S637C53v29Ev,
  (VTBL_ENTRY)&_ZN6S637C53v30Ev,
  (VTBL_ENTRY)&_ZN6S637C53v31Ev,
  (VTBL_ENTRY)&_ZN6S637C53v32Ev,
  (VTBL_ENTRY)&_ZN6S637C53v33Ev,
  (VTBL_ENTRY)&_ZN6S637C53v34Ev,
  (VTBL_ENTRY)&_ZN6S637C53v35Ev,
  (VTBL_ENTRY)&_ZN6S637C53v36Ev,
  (VTBL_ENTRY)&_ZN6S637C53v37Ev,
  (VTBL_ENTRY)&_ZN6S637C53v38Ev,
  (VTBL_ENTRY)&_ZN6S637C53v39Ev,
  (VTBL_ENTRY)&_ZN6S637C53v40Ev,
  (VTBL_ENTRY)&_ZN6S637C53v41Ev,
  (VTBL_ENTRY)&_ZN6S637C53v42Ev,
  (VTBL_ENTRY)&_ZN6S637C53v43Ev,
  (VTBL_ENTRY)&_ZN6S637C53v44Ev,
  (VTBL_ENTRY)&_ZN6S637C53v45Ev,
  (VTBL_ENTRY)&_ZN6S637C53v46Ev,
  (VTBL_ENTRY)&_ZN6S637C53v47Ev,
  (VTBL_ENTRY)&_ZN6S637C53v48Ev,
  (VTBL_ENTRY)&_ZN6S637C53v49Ev,
  (VTBL_ENTRY)&_ZN6S637C53v50Ev,
  (VTBL_ENTRY)&_ZN6S637C53v51Ev,
  (VTBL_ENTRY)&_ZN6S637C53v52Ev,
  (VTBL_ENTRY)&_ZN6S637C53v53Ev,
  (VTBL_ENTRY)&_ZN6S637C53v54Ev,
  (VTBL_ENTRY)&_ZN6S637C53v55Ev,
  (VTBL_ENTRY)&_ZN6S637C53v56Ev,
  (VTBL_ENTRY)&_ZN6S637C53v57Ev,
  (VTBL_ENTRY)&_ZN6S637C53v58Ev,
  (VTBL_ENTRY)&_ZN6S637C53v59Ev,
  (VTBL_ENTRY)&_ZN6S637C53v60Ev,
  (VTBL_ENTRY)&_ZN6S637C53v61Ev,
  (VTBL_ENTRY)&_ZN6S637C53v62Ev,
  (VTBL_ENTRY)&_ZN6S637C53v63Ev,
  (VTBL_ENTRY)&_ZN6S637C53v64Ev,
  (VTBL_ENTRY)&_ZN6S637C53v65Ev,
  (VTBL_ENTRY)&_ZN6S637C53v66Ev,
  (VTBL_ENTRY)&_ZN6S637C53v67Ev,
  (VTBL_ENTRY)&_ZN6S637C53v68Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S637C4_nt[];
VTBL_ENTRY *P__ZTI9S637C4_nt = _ZTI9S637C4_nt; 
extern  VTBL_ENTRY _ZTV9S637C4_nt[];
Class_Descriptor cd_S637C4_nt = {  "S637C4_nt", // class name
  bases_S637C4_nt, 1,
  &(vtc_S637C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S637C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S637C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C3_nt  : S637C4_nt {
  unsigned int s637c3f0:1;
  unsigned int s637c3f1:1;
  unsigned int s637c3f2:1;
  ::S3422C23 s637c3f3;
  ::S3422C17 s637c3f4;
  ::S3422C11 s637c3f5;
  ::S3422C5_nt s637c3f6;
  int s637c3f7[3];
  virtual  ~S637C3_nt(); // _ZN9S637C3_ntD1Ev
  virtual void  v91(); // _ZN9S637C3_nt3v91Ev
  virtual void  v92(); // _ZN9S637C3_nt3v92Ev
  virtual void  v93(); // _ZN9S637C3_nt3v93Ev
  virtual void  v94(); // _ZN9S637C3_nt3v94Ev
  virtual void  v95(); // _ZN9S637C3_nt3v95Ev
  virtual void  v96(); // _ZN9S637C3_nt3v96Ev
  virtual void  v97(); // _ZN9S637C3_nt3v97Ev
  virtual void  v98(); // _ZN9S637C3_nt3v98Ev
  virtual void  v99(); // _ZN9S637C3_nt3v99Ev
  virtual void  v100(); // _ZN9S637C3_nt4v100Ev
  virtual void  v101(); // _ZN9S637C3_nt4v101Ev
  virtual void  v102(); // _ZN9S637C3_nt4v102Ev
  virtual void  v103(); // _ZN9S637C3_nt4v103Ev
  virtual void  v104(); // _ZN9S637C3_nt4v104Ev
  virtual void  v105(); // _ZN9S637C3_nt4v105Ev
  virtual void  v106(); // _ZN9S637C3_nt4v106Ev
  virtual void  v107(); // _ZN9S637C3_nt4v107Ev
  virtual void  v108(); // _ZN9S637C3_nt4v108Ev
  virtual void  v109(); // _ZN9S637C3_nt4v109Ev
  virtual void  v110(); // _ZN9S637C3_nt4v110Ev
  S637C3_nt(); // tgen
};
//SIG(-1 S637C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC6 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S637C3_nt ::~S637C3_nt(){ note_dtor("S637C3_nt", this);}
void  S637C3_nt ::v91(){vfunc_called(this, "_ZN9S637C3_nt3v91Ev");}
void  S637C3_nt ::v92(){vfunc_called(this, "_ZN9S637C3_nt3v92Ev");}
void  S637C3_nt ::v93(){vfunc_called(this, "_ZN9S637C3_nt3v93Ev");}
void  S637C3_nt ::v94(){vfunc_called(this, "_ZN9S637C3_nt3v94Ev");}
void  S637C3_nt ::v95(){vfunc_called(this, "_ZN9S637C3_nt3v95Ev");}
void  S637C3_nt ::v96(){vfunc_called(this, "_ZN9S637C3_nt3v96Ev");}
void  S637C3_nt ::v97(){vfunc_called(this, "_ZN9S637C3_nt3v97Ev");}
void  S637C3_nt ::v98(){vfunc_called(this, "_ZN9S637C3_nt3v98Ev");}
void  S637C3_nt ::v99(){vfunc_called(this, "_ZN9S637C3_nt3v99Ev");}
void  S637C3_nt ::v100(){vfunc_called(this, "_ZN9S637C3_nt4v100Ev");}
void  S637C3_nt ::v101(){vfunc_called(this, "_ZN9S637C3_nt4v101Ev");}
void  S637C3_nt ::v102(){vfunc_called(this, "_ZN9S637C3_nt4v102Ev");}
void  S637C3_nt ::v103(){vfunc_called(this, "_ZN9S637C3_nt4v103Ev");}
void  S637C3_nt ::v104(){vfunc_called(this, "_ZN9S637C3_nt4v104Ev");}
void  S637C3_nt ::v105(){vfunc_called(this, "_ZN9S637C3_nt4v105Ev");}
void  S637C3_nt ::v106(){vfunc_called(this, "_ZN9S637C3_nt4v106Ev");}
void  S637C3_nt ::v107(){vfunc_called(this, "_ZN9S637C3_nt4v107Ev");}
void  S637C3_nt ::v108(){vfunc_called(this, "_ZN9S637C3_nt4v108Ev");}
void  S637C3_nt ::v109(){vfunc_called(this, "_ZN9S637C3_nt4v109Ev");}
void  S637C3_nt ::v110(){vfunc_called(this, "_ZN9S637C3_nt4v110Ev");}
S637C3_nt ::S637C3_nt(){ note_ctor("S637C3_nt", this);} // tgen

//skip512 S637C3_nt

#else // __cplusplus

extern void _ZN9S637C3_ntC1Ev();
extern void _ZN9S637C3_ntD1Ev();
Name_Map name_map_S637C3_nt[] = {
  NSPAIR(_ZN9S637C3_ntC1Ev),
  NSPAIR(_ZN9S637C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S637C5;
extern VTBL_ENTRY _ZTI6S637C5[];
extern  VTBL_ENTRY _ZTV6S637C5[];
extern Class_Descriptor cd_S637C4_nt;
extern VTBL_ENTRY _ZTI9S637C4_nt[];
extern  VTBL_ENTRY _ZTV9S637C4_nt[];
static Base_Class bases_S637C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S637C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S637C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S637C3_nt[];
extern void _ZN9S637C3_ntD1Ev();
extern void _ZN9S637C3_ntD0Ev();
extern void _ZN6S637C52v5Ev();
extern void _ZN6S637C52v6Ev();
extern void _ZN6S637C52v7Ev();
extern void _ZN6S637C52v8Ev();
extern void _ZN6S637C52v9Ev();
extern void _ZN6S637C53v10Ev();
extern void _ZN6S637C53v11Ev();
extern void _ZN6S637C53v12Ev();
extern void _ZN6S637C53v13Ev();
extern void _ZN6S637C53v14Ev();
extern void _ZN6S637C53v15Ev();
extern void _ZN6S637C53v16Ev();
extern void _ZN6S637C53v17Ev();
extern void _ZN6S637C53v18Ev();
extern void _ZN6S637C53v19Ev();
extern void _ZN6S637C53v20Ev();
extern void _ZN6S637C53v21Ev();
extern void _ZN6S637C53v22Ev();
extern void _ZN6S637C53v23Ev();
extern void _ZN6S637C53v24Ev();
extern void _ZN6S637C53v25Ev();
extern void _ZN6S637C53v26Ev();
extern void _ZN6S637C53v27Ev();
extern void _ZN6S637C53v28Ev();
extern void _ZN6S637C53v29Ev();
extern void _ZN6S637C53v30Ev();
extern void _ZN6S637C53v31Ev();
extern void _ZN6S637C53v32Ev();
extern void _ZN6S637C53v33Ev();
extern void _ZN6S637C53v34Ev();
extern void _ZN6S637C53v35Ev();
extern void _ZN6S637C53v36Ev();
extern void _ZN6S637C53v37Ev();
extern void _ZN6S637C53v38Ev();
extern void _ZN6S637C53v39Ev();
extern void _ZN6S637C53v40Ev();
extern void _ZN6S637C53v41Ev();
extern void _ZN6S637C53v42Ev();
extern void _ZN6S637C53v43Ev();
extern void _ZN6S637C53v44Ev();
extern void _ZN6S637C53v45Ev();
extern void _ZN6S637C53v46Ev();
extern void _ZN6S637C53v47Ev();
extern void _ZN6S637C53v48Ev();
extern void _ZN6S637C53v49Ev();
extern void _ZN6S637C53v50Ev();
extern void _ZN6S637C53v51Ev();
extern void _ZN6S637C53v52Ev();
extern void _ZN6S637C53v53Ev();
extern void _ZN6S637C53v54Ev();
extern void _ZN6S637C53v55Ev();
extern void _ZN6S637C53v56Ev();
extern void _ZN6S637C53v57Ev();
extern void _ZN6S637C53v58Ev();
extern void _ZN6S637C53v59Ev();
extern void _ZN6S637C53v60Ev();
extern void _ZN6S637C53v61Ev();
extern void _ZN6S637C53v62Ev();
extern void _ZN6S637C53v63Ev();
extern void _ZN6S637C53v64Ev();
extern void _ZN6S637C53v65Ev();
extern void _ZN6S637C53v66Ev();
extern void _ZN6S637C53v67Ev();
extern void _ZN6S637C53v68Ev();
extern void _ZN9S637C4_nt3v69Ev();
extern void _ZN9S637C4_nt3v70Ev();
extern void _ZN9S637C4_nt3v71Ev();
extern void _ZN9S637C4_nt3v72Ev();
extern void _ZN9S637C4_nt3v73Ev();
extern void _ZN9S637C4_nt3v74Ev();
extern void _ZN9S637C4_nt3v75Ev();
extern void _ZN9S637C4_nt3v76Ev();
extern void _ZN9S637C4_nt3v77Ev();
extern void _ZN9S637C4_nt3v78Ev();
extern void _ZN9S637C4_nt3v79Ev();
extern void _ZN9S637C4_nt3v80Ev();
extern void _ZN9S637C4_nt3v81Ev();
extern void _ZN9S637C4_nt3v82Ev();
extern void _ZN9S637C4_nt3v83Ev();
extern void _ZN9S637C4_nt3v84Ev();
extern void _ZN9S637C4_nt3v85Ev();
extern void _ZN9S637C4_nt3v86Ev();
extern void _ZN9S637C4_nt3v87Ev();
extern void _ZN9S637C4_nt3v88Ev();
extern void _ZN9S637C4_nt3v89Ev();
extern void _ZN9S637C4_nt3v90Ev();
extern void _ZN9S637C3_nt3v91Ev();
extern void _ZN9S637C3_nt3v92Ev();
extern void _ZN9S637C3_nt3v93Ev();
extern void _ZN9S637C3_nt3v94Ev();
extern void _ZN9S637C3_nt3v95Ev();
extern void _ZN9S637C3_nt3v96Ev();
extern void _ZN9S637C3_nt3v97Ev();
extern void _ZN9S637C3_nt3v98Ev();
extern void _ZN9S637C3_nt3v99Ev();
extern void _ZN9S637C3_nt4v100Ev();
extern void _ZN9S637C3_nt4v101Ev();
extern void _ZN9S637C3_nt4v102Ev();
extern void _ZN9S637C3_nt4v103Ev();
extern void _ZN9S637C3_nt4v104Ev();
extern void _ZN9S637C3_nt4v105Ev();
extern void _ZN9S637C3_nt4v106Ev();
extern void _ZN9S637C3_nt4v107Ev();
extern void _ZN9S637C3_nt4v108Ev();
extern void _ZN9S637C3_nt4v109Ev();
extern void _ZN9S637C3_nt4v110Ev();
static  VTBL_ENTRY vtc_S637C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S637C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S637C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S637C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S637C52v5Ev,
  (VTBL_ENTRY)&_ZN6S637C52v6Ev,
  (VTBL_ENTRY)&_ZN6S637C52v7Ev,
  (VTBL_ENTRY)&_ZN6S637C52v8Ev,
  (VTBL_ENTRY)&_ZN6S637C52v9Ev,
  (VTBL_ENTRY)&_ZN6S637C53v10Ev,
  (VTBL_ENTRY)&_ZN6S637C53v11Ev,
  (VTBL_ENTRY)&_ZN6S637C53v12Ev,
  (VTBL_ENTRY)&_ZN6S637C53v13Ev,
  (VTBL_ENTRY)&_ZN6S637C53v14Ev,
  (VTBL_ENTRY)&_ZN6S637C53v15Ev,
  (VTBL_ENTRY)&_ZN6S637C53v16Ev,
  (VTBL_ENTRY)&_ZN6S637C53v17Ev,
  (VTBL_ENTRY)&_ZN6S637C53v18Ev,
  (VTBL_ENTRY)&_ZN6S637C53v19Ev,
  (VTBL_ENTRY)&_ZN6S637C53v20Ev,
  (VTBL_ENTRY)&_ZN6S637C53v21Ev,
  (VTBL_ENTRY)&_ZN6S637C53v22Ev,
  (VTBL_ENTRY)&_ZN6S637C53v23Ev,
  (VTBL_ENTRY)&_ZN6S637C53v24Ev,
  (VTBL_ENTRY)&_ZN6S637C53v25Ev,
  (VTBL_ENTRY)&_ZN6S637C53v26Ev,
  (VTBL_ENTRY)&_ZN6S637C53v27Ev,
  (VTBL_ENTRY)&_ZN6S637C53v28Ev,
  (VTBL_ENTRY)&_ZN6S637C53v29Ev,
  (VTBL_ENTRY)&_ZN6S637C53v30Ev,
  (VTBL_ENTRY)&_ZN6S637C53v31Ev,
  (VTBL_ENTRY)&_ZN6S637C53v32Ev,
  (VTBL_ENTRY)&_ZN6S637C53v33Ev,
  (VTBL_ENTRY)&_ZN6S637C53v34Ev,
  (VTBL_ENTRY)&_ZN6S637C53v35Ev,
  (VTBL_ENTRY)&_ZN6S637C53v36Ev,
  (VTBL_ENTRY)&_ZN6S637C53v37Ev,
  (VTBL_ENTRY)&_ZN6S637C53v38Ev,
  (VTBL_ENTRY)&_ZN6S637C53v39Ev,
  (VTBL_ENTRY)&_ZN6S637C53v40Ev,
  (VTBL_ENTRY)&_ZN6S637C53v41Ev,
  (VTBL_ENTRY)&_ZN6S637C53v42Ev,
  (VTBL_ENTRY)&_ZN6S637C53v43Ev,
  (VTBL_ENTRY)&_ZN6S637C53v44Ev,
  (VTBL_ENTRY)&_ZN6S637C53v45Ev,
  (VTBL_ENTRY)&_ZN6S637C53v46Ev,
  (VTBL_ENTRY)&_ZN6S637C53v47Ev,
  (VTBL_ENTRY)&_ZN6S637C53v48Ev,
  (VTBL_ENTRY)&_ZN6S637C53v49Ev,
  (VTBL_ENTRY)&_ZN6S637C53v50Ev,
  (VTBL_ENTRY)&_ZN6S637C53v51Ev,
  (VTBL_ENTRY)&_ZN6S637C53v52Ev,
  (VTBL_ENTRY)&_ZN6S637C53v53Ev,
  (VTBL_ENTRY)&_ZN6S637C53v54Ev,
  (VTBL_ENTRY)&_ZN6S637C53v55Ev,
  (VTBL_ENTRY)&_ZN6S637C53v56Ev,
  (VTBL_ENTRY)&_ZN6S637C53v57Ev,
  (VTBL_ENTRY)&_ZN6S637C53v58Ev,
  (VTBL_ENTRY)&_ZN6S637C53v59Ev,
  (VTBL_ENTRY)&_ZN6S637C53v60Ev,
  (VTBL_ENTRY)&_ZN6S637C53v61Ev,
  (VTBL_ENTRY)&_ZN6S637C53v62Ev,
  (VTBL_ENTRY)&_ZN6S637C53v63Ev,
  (VTBL_ENTRY)&_ZN6S637C53v64Ev,
  (VTBL_ENTRY)&_ZN6S637C53v65Ev,
  (VTBL_ENTRY)&_ZN6S637C53v66Ev,
  (VTBL_ENTRY)&_ZN6S637C53v67Ev,
  (VTBL_ENTRY)&_ZN6S637C53v68Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S637C3_nt[];
VTBL_ENTRY *P__ZTI9S637C3_nt = _ZTI9S637C3_nt; 
extern  VTBL_ENTRY _ZTV9S637C3_nt[];
Class_Descriptor cd_S637C3_nt = {  "S637C3_nt", // class name
  bases_S637C3_nt, 2,
  &(vtc_S637C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S637C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S637C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C21  : S3422C7_nt {
};
//SIG(-1 S637C21) C1{ BC2{ m Fp Fi[2]}}



static void Test_S637C21()
{
  extern Class_Descriptor cd_S637C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S637C21, buf);
    S637C21 &lv = *(new (buf) S637C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S637C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S637C21)");
    check_base_class_offset(lv, (S3422C7_nt*), 0, "S637C21");
    test_class_info(&lv, &cd_S637C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS637C21(Test_S637C21, "S637C21", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
static Base_Class bases_S637C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S637C21 = {  "S637C21", // class name
  bases_S637C21, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C20_nt  : S637C21 {
};
//SIG(-1 S637C20_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S637C20_nt

#else // __cplusplus

extern Class_Descriptor cd_S3422C7_nt;
extern Class_Descriptor cd_S637C21;
static Base_Class bases_S637C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3422C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S637C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C2_nt  : S637C3_nt {
  void *s637c2f0[2];
  int s637c2f1[4];
  unsigned int s637c2f2:1;
  unsigned int s637c2f3:1;
  unsigned int s637c2f4:1;
  char s637c2f5;
  int s637c2f6;
  unsigned int s637c2f7:1;
  ::S637C20_nt s637c2f8;
  virtual  ~S637C2_nt(); // _ZN9S637C2_ntD1Ev
  virtual void  v111(); // _ZN9S637C2_nt4v111Ev
  virtual void  v112(); // _ZN9S637C2_nt4v112Ev
  virtual void  v113(); // _ZN9S637C2_nt4v113Ev
  virtual void  v114(); // _ZN9S637C2_nt4v114Ev
  virtual void  v115(); // _ZN9S637C2_nt4v115Ev
  virtual void  v116(); // _ZN9S637C2_nt4v116Ev
  virtual void  v117(); // _ZN9S637C2_nt4v117Ev
  virtual void  v118(); // _ZN9S637C2_nt4v118Ev
  virtual void  v119(); // _ZN9S637C2_nt4v119Ev
  virtual void  v120(); // _ZN9S637C2_nt4v120Ev
  virtual void  v121(); // _ZN9S637C2_nt4v121Ev
  virtual void  v122(); // _ZN9S637C2_nt4v122Ev
  virtual void  v123(); // _ZN9S637C2_nt4v123Ev
  virtual void  v124(); // _ZN9S637C2_nt4v124Ev
  S637C2_nt(); // tgen
};
//SIG(-1 S637C2_nt) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fi:1 Fi:1 Fi:1 FC7 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC17{ BC18{ BC9}}}


 S637C2_nt ::~S637C2_nt(){ note_dtor("S637C2_nt", this);}
void  S637C2_nt ::v111(){vfunc_called(this, "_ZN9S637C2_nt4v111Ev");}
void  S637C2_nt ::v112(){vfunc_called(this, "_ZN9S637C2_nt4v112Ev");}
void  S637C2_nt ::v113(){vfunc_called(this, "_ZN9S637C2_nt4v113Ev");}
void  S637C2_nt ::v114(){vfunc_called(this, "_ZN9S637C2_nt4v114Ev");}
void  S637C2_nt ::v115(){vfunc_called(this, "_ZN9S637C2_nt4v115Ev");}
void  S637C2_nt ::v116(){vfunc_called(this, "_ZN9S637C2_nt4v116Ev");}
void  S637C2_nt ::v117(){vfunc_called(this, "_ZN9S637C2_nt4v117Ev");}
void  S637C2_nt ::v118(){vfunc_called(this, "_ZN9S637C2_nt4v118Ev");}
void  S637C2_nt ::v119(){vfunc_called(this, "_ZN9S637C2_nt4v119Ev");}
void  S637C2_nt ::v120(){vfunc_called(this, "_ZN9S637C2_nt4v120Ev");}
void  S637C2_nt ::v121(){vfunc_called(this, "_ZN9S637C2_nt4v121Ev");}
void  S637C2_nt ::v122(){vfunc_called(this, "_ZN9S637C2_nt4v122Ev");}
void  S637C2_nt ::v123(){vfunc_called(this, "_ZN9S637C2_nt4v123Ev");}
void  S637C2_nt ::v124(){vfunc_called(this, "_ZN9S637C2_nt4v124Ev");}
S637C2_nt ::S637C2_nt(){ note_ctor("S637C2_nt", this);} // tgen

//skip512 S637C2_nt

#else // __cplusplus

extern void _ZN9S637C2_ntC1Ev();
extern void _ZN9S637C2_ntD1Ev();
Name_Map name_map_S637C2_nt[] = {
  NSPAIR(_ZN9S637C2_ntC1Ev),
  NSPAIR(_ZN9S637C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S637C5;
extern VTBL_ENTRY _ZTI6S637C5[];
extern  VTBL_ENTRY _ZTV6S637C5[];
extern Class_Descriptor cd_S637C4_nt;
extern VTBL_ENTRY _ZTI9S637C4_nt[];
extern  VTBL_ENTRY _ZTV9S637C4_nt[];
extern Class_Descriptor cd_S637C3_nt;
extern VTBL_ENTRY _ZTI9S637C3_nt[];
extern  VTBL_ENTRY _ZTV9S637C3_nt[];
static Base_Class bases_S637C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S637C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S637C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S637C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S637C2_nt[];
extern void _ZN9S637C2_ntD1Ev();
extern void _ZN9S637C2_ntD0Ev();
extern void _ZN6S637C52v5Ev();
extern void _ZN6S637C52v6Ev();
extern void _ZN6S637C52v7Ev();
extern void _ZN6S637C52v8Ev();
extern void _ZN6S637C52v9Ev();
extern void _ZN6S637C53v10Ev();
extern void _ZN6S637C53v11Ev();
extern void _ZN6S637C53v12Ev();
extern void _ZN6S637C53v13Ev();
extern void _ZN6S637C53v14Ev();
extern void _ZN6S637C53v15Ev();
extern void _ZN6S637C53v16Ev();
extern void _ZN6S637C53v17Ev();
extern void _ZN6S637C53v18Ev();
extern void _ZN6S637C53v19Ev();
extern void _ZN6S637C53v20Ev();
extern void _ZN6S637C53v21Ev();
extern void _ZN6S637C53v22Ev();
extern void _ZN6S637C53v23Ev();
extern void _ZN6S637C53v24Ev();
extern void _ZN6S637C53v25Ev();
extern void _ZN6S637C53v26Ev();
extern void _ZN6S637C53v27Ev();
extern void _ZN6S637C53v28Ev();
extern void _ZN6S637C53v29Ev();
extern void _ZN6S637C53v30Ev();
extern void _ZN6S637C53v31Ev();
extern void _ZN6S637C53v32Ev();
extern void _ZN6S637C53v33Ev();
extern void _ZN6S637C53v34Ev();
extern void _ZN6S637C53v35Ev();
extern void _ZN6S637C53v36Ev();
extern void _ZN6S637C53v37Ev();
extern void _ZN6S637C53v38Ev();
extern void _ZN6S637C53v39Ev();
extern void _ZN6S637C53v40Ev();
extern void _ZN6S637C53v41Ev();
extern void _ZN6S637C53v42Ev();
extern void _ZN6S637C53v43Ev();
extern void _ZN6S637C53v44Ev();
extern void _ZN6S637C53v45Ev();
extern void _ZN6S637C53v46Ev();
extern void _ZN6S637C53v47Ev();
extern void _ZN6S637C53v48Ev();
extern void _ZN6S637C53v49Ev();
extern void _ZN6S637C53v50Ev();
extern void _ZN6S637C53v51Ev();
extern void _ZN6S637C53v52Ev();
extern void _ZN6S637C53v53Ev();
extern void _ZN6S637C53v54Ev();
extern void _ZN6S637C53v55Ev();
extern void _ZN6S637C53v56Ev();
extern void _ZN6S637C53v57Ev();
extern void _ZN6S637C53v58Ev();
extern void _ZN6S637C53v59Ev();
extern void _ZN6S637C53v60Ev();
extern void _ZN6S637C53v61Ev();
extern void _ZN6S637C53v62Ev();
extern void _ZN6S637C53v63Ev();
extern void _ZN6S637C53v64Ev();
extern void _ZN6S637C53v65Ev();
extern void _ZN6S637C53v66Ev();
extern void _ZN6S637C53v67Ev();
extern void _ZN6S637C53v68Ev();
extern void _ZN9S637C4_nt3v69Ev();
extern void _ZN9S637C4_nt3v70Ev();
extern void _ZN9S637C4_nt3v71Ev();
extern void _ZN9S637C4_nt3v72Ev();
extern void _ZN9S637C4_nt3v73Ev();
extern void _ZN9S637C4_nt3v74Ev();
extern void _ZN9S637C4_nt3v75Ev();
extern void _ZN9S637C4_nt3v76Ev();
extern void _ZN9S637C4_nt3v77Ev();
extern void _ZN9S637C4_nt3v78Ev();
extern void _ZN9S637C4_nt3v79Ev();
extern void _ZN9S637C4_nt3v80Ev();
extern void _ZN9S637C4_nt3v81Ev();
extern void _ZN9S637C4_nt3v82Ev();
extern void _ZN9S637C4_nt3v83Ev();
extern void _ZN9S637C4_nt3v84Ev();
extern void _ZN9S637C4_nt3v85Ev();
extern void _ZN9S637C4_nt3v86Ev();
extern void _ZN9S637C4_nt3v87Ev();
extern void _ZN9S637C4_nt3v88Ev();
extern void _ZN9S637C4_nt3v89Ev();
extern void _ZN9S637C4_nt3v90Ev();
extern void _ZN9S637C3_nt3v91Ev();
extern void _ZN9S637C3_nt3v92Ev();
extern void _ZN9S637C3_nt3v93Ev();
extern void _ZN9S637C3_nt3v94Ev();
extern void _ZN9S637C3_nt3v95Ev();
extern void _ZN9S637C3_nt3v96Ev();
extern void _ZN9S637C3_nt3v97Ev();
extern void _ZN9S637C3_nt3v98Ev();
extern void _ZN9S637C3_nt3v99Ev();
extern void _ZN9S637C3_nt4v100Ev();
extern void _ZN9S637C3_nt4v101Ev();
extern void _ZN9S637C3_nt4v102Ev();
extern void _ZN9S637C3_nt4v103Ev();
extern void _ZN9S637C3_nt4v104Ev();
extern void _ZN9S637C3_nt4v105Ev();
extern void _ZN9S637C3_nt4v106Ev();
extern void _ZN9S637C3_nt4v107Ev();
extern void _ZN9S637C3_nt4v108Ev();
extern void _ZN9S637C3_nt4v109Ev();
extern void _ZN9S637C3_nt4v110Ev();
extern void _ZN9S637C2_nt4v111Ev();
extern void _ZN9S637C2_nt4v112Ev();
extern void _ZN9S637C2_nt4v113Ev();
extern void _ZN9S637C2_nt4v114Ev();
extern void _ZN9S637C2_nt4v115Ev();
extern void _ZN9S637C2_nt4v116Ev();
extern void _ZN9S637C2_nt4v117Ev();
extern void _ZN9S637C2_nt4v118Ev();
extern void _ZN9S637C2_nt4v119Ev();
extern void _ZN9S637C2_nt4v120Ev();
extern void _ZN9S637C2_nt4v121Ev();
extern void _ZN9S637C2_nt4v122Ev();
extern void _ZN9S637C2_nt4v123Ev();
extern void _ZN9S637C2_nt4v124Ev();
static  VTBL_ENTRY vtc_S637C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S637C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S637C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S637C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S637C52v5Ev,
  (VTBL_ENTRY)&_ZN6S637C52v6Ev,
  (VTBL_ENTRY)&_ZN6S637C52v7Ev,
  (VTBL_ENTRY)&_ZN6S637C52v8Ev,
  (VTBL_ENTRY)&_ZN6S637C52v9Ev,
  (VTBL_ENTRY)&_ZN6S637C53v10Ev,
  (VTBL_ENTRY)&_ZN6S637C53v11Ev,
  (VTBL_ENTRY)&_ZN6S637C53v12Ev,
  (VTBL_ENTRY)&_ZN6S637C53v13Ev,
  (VTBL_ENTRY)&_ZN6S637C53v14Ev,
  (VTBL_ENTRY)&_ZN6S637C53v15Ev,
  (VTBL_ENTRY)&_ZN6S637C53v16Ev,
  (VTBL_ENTRY)&_ZN6S637C53v17Ev,
  (VTBL_ENTRY)&_ZN6S637C53v18Ev,
  (VTBL_ENTRY)&_ZN6S637C53v19Ev,
  (VTBL_ENTRY)&_ZN6S637C53v20Ev,
  (VTBL_ENTRY)&_ZN6S637C53v21Ev,
  (VTBL_ENTRY)&_ZN6S637C53v22Ev,
  (VTBL_ENTRY)&_ZN6S637C53v23Ev,
  (VTBL_ENTRY)&_ZN6S637C53v24Ev,
  (VTBL_ENTRY)&_ZN6S637C53v25Ev,
  (VTBL_ENTRY)&_ZN6S637C53v26Ev,
  (VTBL_ENTRY)&_ZN6S637C53v27Ev,
  (VTBL_ENTRY)&_ZN6S637C53v28Ev,
  (VTBL_ENTRY)&_ZN6S637C53v29Ev,
  (VTBL_ENTRY)&_ZN6S637C53v30Ev,
  (VTBL_ENTRY)&_ZN6S637C53v31Ev,
  (VTBL_ENTRY)&_ZN6S637C53v32Ev,
  (VTBL_ENTRY)&_ZN6S637C53v33Ev,
  (VTBL_ENTRY)&_ZN6S637C53v34Ev,
  (VTBL_ENTRY)&_ZN6S637C53v35Ev,
  (VTBL_ENTRY)&_ZN6S637C53v36Ev,
  (VTBL_ENTRY)&_ZN6S637C53v37Ev,
  (VTBL_ENTRY)&_ZN6S637C53v38Ev,
  (VTBL_ENTRY)&_ZN6S637C53v39Ev,
  (VTBL_ENTRY)&_ZN6S637C53v40Ev,
  (VTBL_ENTRY)&_ZN6S637C53v41Ev,
  (VTBL_ENTRY)&_ZN6S637C53v42Ev,
  (VTBL_ENTRY)&_ZN6S637C53v43Ev,
  (VTBL_ENTRY)&_ZN6S637C53v44Ev,
  (VTBL_ENTRY)&_ZN6S637C53v45Ev,
  (VTBL_ENTRY)&_ZN6S637C53v46Ev,
  (VTBL_ENTRY)&_ZN6S637C53v47Ev,
  (VTBL_ENTRY)&_ZN6S637C53v48Ev,
  (VTBL_ENTRY)&_ZN6S637C53v49Ev,
  (VTBL_ENTRY)&_ZN6S637C53v50Ev,
  (VTBL_ENTRY)&_ZN6S637C53v51Ev,
  (VTBL_ENTRY)&_ZN6S637C53v52Ev,
  (VTBL_ENTRY)&_ZN6S637C53v53Ev,
  (VTBL_ENTRY)&_ZN6S637C53v54Ev,
  (VTBL_ENTRY)&_ZN6S637C53v55Ev,
  (VTBL_ENTRY)&_ZN6S637C53v56Ev,
  (VTBL_ENTRY)&_ZN6S637C53v57Ev,
  (VTBL_ENTRY)&_ZN6S637C53v58Ev,
  (VTBL_ENTRY)&_ZN6S637C53v59Ev,
  (VTBL_ENTRY)&_ZN6S637C53v60Ev,
  (VTBL_ENTRY)&_ZN6S637C53v61Ev,
  (VTBL_ENTRY)&_ZN6S637C53v62Ev,
  (VTBL_ENTRY)&_ZN6S637C53v63Ev,
  (VTBL_ENTRY)&_ZN6S637C53v64Ev,
  (VTBL_ENTRY)&_ZN6S637C53v65Ev,
  (VTBL_ENTRY)&_ZN6S637C53v66Ev,
  (VTBL_ENTRY)&_ZN6S637C53v67Ev,
  (VTBL_ENTRY)&_ZN6S637C53v68Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v124Ev,
};
extern VTBL_ENTRY _ZTI9S637C2_nt[];
VTBL_ENTRY *P__ZTI9S637C2_nt = _ZTI9S637C2_nt; 
extern  VTBL_ENTRY _ZTV9S637C2_nt[];
Class_Descriptor cd_S637C2_nt = {  "S637C2_nt", // class name
  bases_S637C2_nt, 3,
  &(vtc_S637C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,244), // object size
  NSPAIRA(_ZTI9S637C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S637C2_nt),124, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S637C1  : S637C2_nt {
  ::S3422C4_nt s637c1f0;
  virtual  ~S637C1(); // _ZN6S637C1D1Ev
  virtual void  v1(); // _ZN6S637C12v1Ev
  virtual void  v2(); // _ZN6S637C12v2Ev
  virtual void  v3(); // _ZN6S637C12v3Ev
  virtual void  v4(); // _ZN6S637C12v4Ev
  S637C1(); // tgen
};
//SIG(1 S637C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC8 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 Fp[2] Fi[4] Fi:1 Fi:1 Fi:1 Fc Fi Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 FC6}


 S637C1 ::~S637C1(){ note_dtor("S637C1", this);}
void  S637C1 ::v1(){vfunc_called(this, "_ZN6S637C12v1Ev");}
void  S637C1 ::v2(){vfunc_called(this, "_ZN6S637C12v2Ev");}
void  S637C1 ::v3(){vfunc_called(this, "_ZN6S637C12v3Ev");}
void  S637C1 ::v4(){vfunc_called(this, "_ZN6S637C12v4Ev");}
S637C1 ::S637C1(){ note_ctor("S637C1", this);} // tgen

static void Test_S637C1()
{
  extern Class_Descriptor cd_S637C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,64)];
    init_test(&cd_S637C1, buf);
    S637C1 *dp, &lv = *(dp=new (buf) S637C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,252), "sizeof(S637C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S637C1)");
    check_base_class_offset(lv, (S637C5*)(S637C4_nt*)(S637C3_nt*)(S637C2_nt*), 0, "S637C1");
    check_base_class_offset(lv, (S637C4_nt*)(S637C3_nt*)(S637C2_nt*), 0, "S637C1");
    check_base_class_offset(lv, (S637C3_nt*)(S637C2_nt*), 0, "S637C1");
    check_base_class_offset(lv, (S637C2_nt*), 0, "S637C1");
    check_field_offset(lv, s637c1f0, ABISELECT(336,244), "S637C1.s637c1f0");
    test_class_info(&lv, &cd_S637C1);
    dp->~S637C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS637C1(Test_S637C1, "S637C1", ABISELECT(344,252));

#else // __cplusplus

extern void _ZN6S637C1C1Ev();
extern void _ZN6S637C1D1Ev();
Name_Map name_map_S637C1[] = {
  NSPAIR(_ZN6S637C1C1Ev),
  NSPAIR(_ZN6S637C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S637C5;
extern VTBL_ENTRY _ZTI6S637C5[];
extern  VTBL_ENTRY _ZTV6S637C5[];
extern Class_Descriptor cd_S637C4_nt;
extern VTBL_ENTRY _ZTI9S637C4_nt[];
extern  VTBL_ENTRY _ZTV9S637C4_nt[];
extern Class_Descriptor cd_S637C3_nt;
extern VTBL_ENTRY _ZTI9S637C3_nt[];
extern  VTBL_ENTRY _ZTV9S637C3_nt[];
extern Class_Descriptor cd_S637C2_nt;
extern VTBL_ENTRY _ZTI9S637C2_nt[];
extern  VTBL_ENTRY _ZTV9S637C2_nt[];
static Base_Class bases_S637C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S637C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S637C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S637C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S637C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S637C1[];
extern void _ZN6S637C1D1Ev();
extern void _ZN6S637C1D0Ev();
extern void _ZN6S637C52v5Ev();
extern void _ZN6S637C52v6Ev();
extern void _ZN6S637C52v7Ev();
extern void _ZN6S637C52v8Ev();
extern void _ZN6S637C52v9Ev();
extern void _ZN6S637C53v10Ev();
extern void _ZN6S637C53v11Ev();
extern void _ZN6S637C53v12Ev();
extern void _ZN6S637C53v13Ev();
extern void _ZN6S637C53v14Ev();
extern void _ZN6S637C53v15Ev();
extern void _ZN6S637C53v16Ev();
extern void _ZN6S637C53v17Ev();
extern void _ZN6S637C53v18Ev();
extern void _ZN6S637C53v19Ev();
extern void _ZN6S637C53v20Ev();
extern void _ZN6S637C53v21Ev();
extern void _ZN6S637C53v22Ev();
extern void _ZN6S637C53v23Ev();
extern void _ZN6S637C53v24Ev();
extern void _ZN6S637C53v25Ev();
extern void _ZN6S637C53v26Ev();
extern void _ZN6S637C53v27Ev();
extern void _ZN6S637C53v28Ev();
extern void _ZN6S637C53v29Ev();
extern void _ZN6S637C53v30Ev();
extern void _ZN6S637C53v31Ev();
extern void _ZN6S637C53v32Ev();
extern void _ZN6S637C53v33Ev();
extern void _ZN6S637C53v34Ev();
extern void _ZN6S637C53v35Ev();
extern void _ZN6S637C53v36Ev();
extern void _ZN6S637C53v37Ev();
extern void _ZN6S637C53v38Ev();
extern void _ZN6S637C53v39Ev();
extern void _ZN6S637C53v40Ev();
extern void _ZN6S637C53v41Ev();
extern void _ZN6S637C53v42Ev();
extern void _ZN6S637C53v43Ev();
extern void _ZN6S637C53v44Ev();
extern void _ZN6S637C53v45Ev();
extern void _ZN6S637C53v46Ev();
extern void _ZN6S637C53v47Ev();
extern void _ZN6S637C53v48Ev();
extern void _ZN6S637C53v49Ev();
extern void _ZN6S637C53v50Ev();
extern void _ZN6S637C53v51Ev();
extern void _ZN6S637C53v52Ev();
extern void _ZN6S637C53v53Ev();
extern void _ZN6S637C53v54Ev();
extern void _ZN6S637C53v55Ev();
extern void _ZN6S637C53v56Ev();
extern void _ZN6S637C53v57Ev();
extern void _ZN6S637C53v58Ev();
extern void _ZN6S637C53v59Ev();
extern void _ZN6S637C53v60Ev();
extern void _ZN6S637C53v61Ev();
extern void _ZN6S637C53v62Ev();
extern void _ZN6S637C53v63Ev();
extern void _ZN6S637C53v64Ev();
extern void _ZN6S637C53v65Ev();
extern void _ZN6S637C53v66Ev();
extern void _ZN6S637C53v67Ev();
extern void _ZN6S637C53v68Ev();
extern void _ZN9S637C4_nt3v69Ev();
extern void _ZN9S637C4_nt3v70Ev();
extern void _ZN9S637C4_nt3v71Ev();
extern void _ZN9S637C4_nt3v72Ev();
extern void _ZN9S637C4_nt3v73Ev();
extern void _ZN9S637C4_nt3v74Ev();
extern void _ZN9S637C4_nt3v75Ev();
extern void _ZN9S637C4_nt3v76Ev();
extern void _ZN9S637C4_nt3v77Ev();
extern void _ZN9S637C4_nt3v78Ev();
extern void _ZN9S637C4_nt3v79Ev();
extern void _ZN9S637C4_nt3v80Ev();
extern void _ZN9S637C4_nt3v81Ev();
extern void _ZN9S637C4_nt3v82Ev();
extern void _ZN9S637C4_nt3v83Ev();
extern void _ZN9S637C4_nt3v84Ev();
extern void _ZN9S637C4_nt3v85Ev();
extern void _ZN9S637C4_nt3v86Ev();
extern void _ZN9S637C4_nt3v87Ev();
extern void _ZN9S637C4_nt3v88Ev();
extern void _ZN9S637C4_nt3v89Ev();
extern void _ZN9S637C4_nt3v90Ev();
extern void _ZN9S637C3_nt3v91Ev();
extern void _ZN9S637C3_nt3v92Ev();
extern void _ZN9S637C3_nt3v93Ev();
extern void _ZN9S637C3_nt3v94Ev();
extern void _ZN9S637C3_nt3v95Ev();
extern void _ZN9S637C3_nt3v96Ev();
extern void _ZN9S637C3_nt3v97Ev();
extern void _ZN9S637C3_nt3v98Ev();
extern void _ZN9S637C3_nt3v99Ev();
extern void _ZN9S637C3_nt4v100Ev();
extern void _ZN9S637C3_nt4v101Ev();
extern void _ZN9S637C3_nt4v102Ev();
extern void _ZN9S637C3_nt4v103Ev();
extern void _ZN9S637C3_nt4v104Ev();
extern void _ZN9S637C3_nt4v105Ev();
extern void _ZN9S637C3_nt4v106Ev();
extern void _ZN9S637C3_nt4v107Ev();
extern void _ZN9S637C3_nt4v108Ev();
extern void _ZN9S637C3_nt4v109Ev();
extern void _ZN9S637C3_nt4v110Ev();
extern void _ZN9S637C2_nt4v111Ev();
extern void _ZN9S637C2_nt4v112Ev();
extern void _ZN9S637C2_nt4v113Ev();
extern void _ZN9S637C2_nt4v114Ev();
extern void _ZN9S637C2_nt4v115Ev();
extern void _ZN9S637C2_nt4v116Ev();
extern void _ZN9S637C2_nt4v117Ev();
extern void _ZN9S637C2_nt4v118Ev();
extern void _ZN9S637C2_nt4v119Ev();
extern void _ZN9S637C2_nt4v120Ev();
extern void _ZN9S637C2_nt4v121Ev();
extern void _ZN9S637C2_nt4v122Ev();
extern void _ZN9S637C2_nt4v123Ev();
extern void _ZN9S637C2_nt4v124Ev();
extern void _ZN6S637C12v1Ev();
extern void _ZN6S637C12v2Ev();
extern void _ZN6S637C12v3Ev();
extern void _ZN6S637C12v4Ev();
static  VTBL_ENTRY vtc_S637C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S637C1[0]),
  (VTBL_ENTRY)&_ZN6S637C1D1Ev,
  (VTBL_ENTRY)&_ZN6S637C1D0Ev,
  (VTBL_ENTRY)&_ZN6S637C52v5Ev,
  (VTBL_ENTRY)&_ZN6S637C52v6Ev,
  (VTBL_ENTRY)&_ZN6S637C52v7Ev,
  (VTBL_ENTRY)&_ZN6S637C52v8Ev,
  (VTBL_ENTRY)&_ZN6S637C52v9Ev,
  (VTBL_ENTRY)&_ZN6S637C53v10Ev,
  (VTBL_ENTRY)&_ZN6S637C53v11Ev,
  (VTBL_ENTRY)&_ZN6S637C53v12Ev,
  (VTBL_ENTRY)&_ZN6S637C53v13Ev,
  (VTBL_ENTRY)&_ZN6S637C53v14Ev,
  (VTBL_ENTRY)&_ZN6S637C53v15Ev,
  (VTBL_ENTRY)&_ZN6S637C53v16Ev,
  (VTBL_ENTRY)&_ZN6S637C53v17Ev,
  (VTBL_ENTRY)&_ZN6S637C53v18Ev,
  (VTBL_ENTRY)&_ZN6S637C53v19Ev,
  (VTBL_ENTRY)&_ZN6S637C53v20Ev,
  (VTBL_ENTRY)&_ZN6S637C53v21Ev,
  (VTBL_ENTRY)&_ZN6S637C53v22Ev,
  (VTBL_ENTRY)&_ZN6S637C53v23Ev,
  (VTBL_ENTRY)&_ZN6S637C53v24Ev,
  (VTBL_ENTRY)&_ZN6S637C53v25Ev,
  (VTBL_ENTRY)&_ZN6S637C53v26Ev,
  (VTBL_ENTRY)&_ZN6S637C53v27Ev,
  (VTBL_ENTRY)&_ZN6S637C53v28Ev,
  (VTBL_ENTRY)&_ZN6S637C53v29Ev,
  (VTBL_ENTRY)&_ZN6S637C53v30Ev,
  (VTBL_ENTRY)&_ZN6S637C53v31Ev,
  (VTBL_ENTRY)&_ZN6S637C53v32Ev,
  (VTBL_ENTRY)&_ZN6S637C53v33Ev,
  (VTBL_ENTRY)&_ZN6S637C53v34Ev,
  (VTBL_ENTRY)&_ZN6S637C53v35Ev,
  (VTBL_ENTRY)&_ZN6S637C53v36Ev,
  (VTBL_ENTRY)&_ZN6S637C53v37Ev,
  (VTBL_ENTRY)&_ZN6S637C53v38Ev,
  (VTBL_ENTRY)&_ZN6S637C53v39Ev,
  (VTBL_ENTRY)&_ZN6S637C53v40Ev,
  (VTBL_ENTRY)&_ZN6S637C53v41Ev,
  (VTBL_ENTRY)&_ZN6S637C53v42Ev,
  (VTBL_ENTRY)&_ZN6S637C53v43Ev,
  (VTBL_ENTRY)&_ZN6S637C53v44Ev,
  (VTBL_ENTRY)&_ZN6S637C53v45Ev,
  (VTBL_ENTRY)&_ZN6S637C53v46Ev,
  (VTBL_ENTRY)&_ZN6S637C53v47Ev,
  (VTBL_ENTRY)&_ZN6S637C53v48Ev,
  (VTBL_ENTRY)&_ZN6S637C53v49Ev,
  (VTBL_ENTRY)&_ZN6S637C53v50Ev,
  (VTBL_ENTRY)&_ZN6S637C53v51Ev,
  (VTBL_ENTRY)&_ZN6S637C53v52Ev,
  (VTBL_ENTRY)&_ZN6S637C53v53Ev,
  (VTBL_ENTRY)&_ZN6S637C53v54Ev,
  (VTBL_ENTRY)&_ZN6S637C53v55Ev,
  (VTBL_ENTRY)&_ZN6S637C53v56Ev,
  (VTBL_ENTRY)&_ZN6S637C53v57Ev,
  (VTBL_ENTRY)&_ZN6S637C53v58Ev,
  (VTBL_ENTRY)&_ZN6S637C53v59Ev,
  (VTBL_ENTRY)&_ZN6S637C53v60Ev,
  (VTBL_ENTRY)&_ZN6S637C53v61Ev,
  (VTBL_ENTRY)&_ZN6S637C53v62Ev,
  (VTBL_ENTRY)&_ZN6S637C53v63Ev,
  (VTBL_ENTRY)&_ZN6S637C53v64Ev,
  (VTBL_ENTRY)&_ZN6S637C53v65Ev,
  (VTBL_ENTRY)&_ZN6S637C53v66Ev,
  (VTBL_ENTRY)&_ZN6S637C53v67Ev,
  (VTBL_ENTRY)&_ZN6S637C53v68Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S637C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S637C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S637C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN6S637C12v1Ev,
  (VTBL_ENTRY)&_ZN6S637C12v2Ev,
  (VTBL_ENTRY)&_ZN6S637C12v3Ev,
  (VTBL_ENTRY)&_ZN6S637C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S637C1[];
extern  VTBL_ENTRY _ZTV6S637C1[];
Class_Descriptor cd_S637C1 = {  "S637C1", // class name
  bases_S637C1, 4,
  &(vtc_S637C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(344,252), // object size
  NSPAIRA(_ZTI6S637C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S637C1),128, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C6  {
  int s164c6f0;
  __tsi64 s164c6f1;
  void *s164c6f2[4];
  int s164c6f3[2];
  void *s164c6f4;
  ::S3422C4_nt s164c6f5;
  void *s164c6f6[2];
  virtual  ~S164C6(); // _ZN6S164C6D1Ev
  virtual void  v23(); // _ZN6S164C63v23Ev
  virtual void  v24(); // _ZN6S164C63v24Ev
  virtual void  v25(); // _ZN6S164C63v25Ev
  virtual void  v26(); // _ZN6S164C63v26Ev
  virtual void  v27(); // _ZN6S164C63v27Ev
  virtual void  v28(); // _ZN6S164C63v28Ev
  virtual void  v29(); // _ZN6S164C63v29Ev
  virtual void  v30(); // _ZN6S164C63v30Ev
  virtual void  v31(); // _ZN6S164C63v31Ev
  virtual void  v32(); // _ZN6S164C63v32Ev
  virtual void  v33(); // _ZN6S164C63v33Ev
  virtual void  v34(); // _ZN6S164C63v34Ev
  virtual void  v35(); // _ZN6S164C63v35Ev
  virtual void  v36(); // _ZN6S164C63v36Ev
  virtual void  v37(); // _ZN6S164C63v37Ev
  virtual void  v38(); // _ZN6S164C63v38Ev
  virtual void  v39(); // _ZN6S164C63v39Ev
  virtual void  v40(); // _ZN6S164C63v40Ev
  virtual void  v41(); // _ZN6S164C63v41Ev
  virtual void  v42(); // _ZN6S164C63v42Ev
  virtual void  v43(); // _ZN6S164C63v43Ev
  virtual void  v44(); // _ZN6S164C63v44Ev
  virtual void  v45(); // _ZN6S164C63v45Ev
  virtual void  v46(); // _ZN6S164C63v46Ev
  virtual void  v47(); // _ZN6S164C63v47Ev
  virtual void  v48(); // _ZN6S164C63v48Ev
  virtual void  v49(); // _ZN6S164C63v49Ev
  virtual void  v50(); // _ZN6S164C63v50Ev
  virtual void  v51(); // _ZN6S164C63v51Ev
  virtual void  v52(); // _ZN6S164C63v52Ev
  virtual void  v53(); // _ZN6S164C63v53Ev
  virtual void  v54(); // _ZN6S164C63v54Ev
  virtual void  v55(); // _ZN6S164C63v55Ev
  virtual void  v56(); // _ZN6S164C63v56Ev
  virtual void  v57(); // _ZN6S164C63v57Ev
  virtual void  v58(); // _ZN6S164C63v58Ev
  virtual void  v59(); // _ZN6S164C63v59Ev
  virtual void  v60(); // _ZN6S164C63v60Ev
  virtual void  v61(); // _ZN6S164C63v61Ev
  virtual void  v62(); // _ZN6S164C63v62Ev
  virtual void  v63(); // _ZN6S164C63v63Ev
  virtual void  v64(); // _ZN6S164C63v64Ev
  virtual void  v65(); // _ZN6S164C63v65Ev
  virtual void  v66(); // _ZN6S164C63v66Ev
  virtual void  v67(); // _ZN6S164C63v67Ev
  virtual void  v68(); // _ZN6S164C63v68Ev
  virtual void  v69(); // _ZN6S164C63v69Ev
  virtual void  v70(); // _ZN6S164C63v70Ev
  virtual void  v71(); // _ZN6S164C63v71Ev
  virtual void  v72(); // _ZN6S164C63v72Ev
  virtual void  v73(); // _ZN6S164C63v73Ev
  virtual void  v74(); // _ZN6S164C63v74Ev
  virtual void  v75(); // _ZN6S164C63v75Ev
  virtual void  v76(); // _ZN6S164C63v76Ev
  virtual void  v77(); // _ZN6S164C63v77Ev
  virtual void  v78(); // _ZN6S164C63v78Ev
  virtual void  v79(); // _ZN6S164C63v79Ev
  virtual void  v80(); // _ZN6S164C63v80Ev
  virtual void  v81(); // _ZN6S164C63v81Ev
  virtual void  v82(); // _ZN6S164C63v82Ev
  virtual void  v83(); // _ZN6S164C63v83Ev
  virtual void  v84(); // _ZN6S164C63v84Ev
  virtual void  v85(); // _ZN6S164C63v85Ev
  virtual void  v86(); // _ZN6S164C63v86Ev
  S164C6(); // tgen
};
//SIG(-1 S164C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S164C6 ::~S164C6(){ note_dtor("S164C6", this);}
void  S164C6 ::v23(){vfunc_called(this, "_ZN6S164C63v23Ev");}
void  S164C6 ::v24(){vfunc_called(this, "_ZN6S164C63v24Ev");}
void  S164C6 ::v25(){vfunc_called(this, "_ZN6S164C63v25Ev");}
void  S164C6 ::v26(){vfunc_called(this, "_ZN6S164C63v26Ev");}
void  S164C6 ::v27(){vfunc_called(this, "_ZN6S164C63v27Ev");}
void  S164C6 ::v28(){vfunc_called(this, "_ZN6S164C63v28Ev");}
void  S164C6 ::v29(){vfunc_called(this, "_ZN6S164C63v29Ev");}
void  S164C6 ::v30(){vfunc_called(this, "_ZN6S164C63v30Ev");}
void  S164C6 ::v31(){vfunc_called(this, "_ZN6S164C63v31Ev");}
void  S164C6 ::v32(){vfunc_called(this, "_ZN6S164C63v32Ev");}
void  S164C6 ::v33(){vfunc_called(this, "_ZN6S164C63v33Ev");}
void  S164C6 ::v34(){vfunc_called(this, "_ZN6S164C63v34Ev");}
void  S164C6 ::v35(){vfunc_called(this, "_ZN6S164C63v35Ev");}
void  S164C6 ::v36(){vfunc_called(this, "_ZN6S164C63v36Ev");}
void  S164C6 ::v37(){vfunc_called(this, "_ZN6S164C63v37Ev");}
void  S164C6 ::v38(){vfunc_called(this, "_ZN6S164C63v38Ev");}
void  S164C6 ::v39(){vfunc_called(this, "_ZN6S164C63v39Ev");}
void  S164C6 ::v40(){vfunc_called(this, "_ZN6S164C63v40Ev");}
void  S164C6 ::v41(){vfunc_called(this, "_ZN6S164C63v41Ev");}
void  S164C6 ::v42(){vfunc_called(this, "_ZN6S164C63v42Ev");}
void  S164C6 ::v43(){vfunc_called(this, "_ZN6S164C63v43Ev");}
void  S164C6 ::v44(){vfunc_called(this, "_ZN6S164C63v44Ev");}
void  S164C6 ::v45(){vfunc_called(this, "_ZN6S164C63v45Ev");}
void  S164C6 ::v46(){vfunc_called(this, "_ZN6S164C63v46Ev");}
void  S164C6 ::v47(){vfunc_called(this, "_ZN6S164C63v47Ev");}
void  S164C6 ::v48(){vfunc_called(this, "_ZN6S164C63v48Ev");}
void  S164C6 ::v49(){vfunc_called(this, "_ZN6S164C63v49Ev");}
void  S164C6 ::v50(){vfunc_called(this, "_ZN6S164C63v50Ev");}
void  S164C6 ::v51(){vfunc_called(this, "_ZN6S164C63v51Ev");}
void  S164C6 ::v52(){vfunc_called(this, "_ZN6S164C63v52Ev");}
void  S164C6 ::v53(){vfunc_called(this, "_ZN6S164C63v53Ev");}
void  S164C6 ::v54(){vfunc_called(this, "_ZN6S164C63v54Ev");}
void  S164C6 ::v55(){vfunc_called(this, "_ZN6S164C63v55Ev");}
void  S164C6 ::v56(){vfunc_called(this, "_ZN6S164C63v56Ev");}
void  S164C6 ::v57(){vfunc_called(this, "_ZN6S164C63v57Ev");}
void  S164C6 ::v58(){vfunc_called(this, "_ZN6S164C63v58Ev");}
void  S164C6 ::v59(){vfunc_called(this, "_ZN6S164C63v59Ev");}
void  S164C6 ::v60(){vfunc_called(this, "_ZN6S164C63v60Ev");}
void  S164C6 ::v61(){vfunc_called(this, "_ZN6S164C63v61Ev");}
void  S164C6 ::v62(){vfunc_called(this, "_ZN6S164C63v62Ev");}
void  S164C6 ::v63(){vfunc_called(this, "_ZN6S164C63v63Ev");}
void  S164C6 ::v64(){vfunc_called(this, "_ZN6S164C63v64Ev");}
void  S164C6 ::v65(){vfunc_called(this, "_ZN6S164C63v65Ev");}
void  S164C6 ::v66(){vfunc_called(this, "_ZN6S164C63v66Ev");}
void  S164C6 ::v67(){vfunc_called(this, "_ZN6S164C63v67Ev");}
void  S164C6 ::v68(){vfunc_called(this, "_ZN6S164C63v68Ev");}
void  S164C6 ::v69(){vfunc_called(this, "_ZN6S164C63v69Ev");}
void  S164C6 ::v70(){vfunc_called(this, "_ZN6S164C63v70Ev");}
void  S164C6 ::v71(){vfunc_called(this, "_ZN6S164C63v71Ev");}
void  S164C6 ::v72(){vfunc_called(this, "_ZN6S164C63v72Ev");}
void  S164C6 ::v73(){vfunc_called(this, "_ZN6S164C63v73Ev");}
void  S164C6 ::v74(){vfunc_called(this, "_ZN6S164C63v74Ev");}
void  S164C6 ::v75(){vfunc_called(this, "_ZN6S164C63v75Ev");}
void  S164C6 ::v76(){vfunc_called(this, "_ZN6S164C63v76Ev");}
void  S164C6 ::v77(){vfunc_called(this, "_ZN6S164C63v77Ev");}
void  S164C6 ::v78(){vfunc_called(this, "_ZN6S164C63v78Ev");}
void  S164C6 ::v79(){vfunc_called(this, "_ZN6S164C63v79Ev");}
void  S164C6 ::v80(){vfunc_called(this, "_ZN6S164C63v80Ev");}
void  S164C6 ::v81(){vfunc_called(this, "_ZN6S164C63v81Ev");}
void  S164C6 ::v82(){vfunc_called(this, "_ZN6S164C63v82Ev");}
void  S164C6 ::v83(){vfunc_called(this, "_ZN6S164C63v83Ev");}
void  S164C6 ::v84(){vfunc_called(this, "_ZN6S164C63v84Ev");}
void  S164C6 ::v85(){vfunc_called(this, "_ZN6S164C63v85Ev");}
void  S164C6 ::v86(){vfunc_called(this, "_ZN6S164C63v86Ev");}
S164C6 ::S164C6(){ note_ctor("S164C6", this);} // tgen

static void Test_S164C6()
{
  extern Class_Descriptor cd_S164C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S164C6, buf);
    S164C6 *dp, &lv = *(dp=new (buf) S164C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S164C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C6)");
    check_field_offset(lv, s164c6f0, ABISELECT(8,4), "S164C6.s164c6f0");
    check_field_offset(lv, s164c6f1, ABISELECT(16,8), "S164C6.s164c6f1");
    check_field_offset(lv, s164c6f2, ABISELECT(24,16), "S164C6.s164c6f2");
    check_field_offset(lv, s164c6f3, ABISELECT(56,32), "S164C6.s164c6f3");
    check_field_offset(lv, s164c6f4, ABISELECT(64,40), "S164C6.s164c6f4");
    check_field_offset(lv, s164c6f5, ABISELECT(72,44), "S164C6.s164c6f5");
    check_field_offset(lv, s164c6f6, ABISELECT(80,52), "S164C6.s164c6f6");
    test_class_info(&lv, &cd_S164C6);
    dp->~S164C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C6(Test_S164C6, "S164C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S164C6C1Ev();
extern void _ZN6S164C6D1Ev();
Name_Map name_map_S164C6[] = {
  NSPAIR(_ZN6S164C6C1Ev),
  NSPAIR(_ZN6S164C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S164C6[];
extern void _ZN6S164C6D1Ev();
extern void _ZN6S164C6D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
static  VTBL_ENTRY vtc_S164C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C6[0]),
  (VTBL_ENTRY)&_ZN6S164C6D1Ev,
  (VTBL_ENTRY)&_ZN6S164C6D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
};
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
Class_Descriptor cd_S164C6 = {  "S164C6", // class name
  0,0,//no base classes
  &(vtc_S164C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S164C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S164C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C5  : S164C6 {
  virtual  ~S164C5(); // _ZN6S164C5D1Ev
  virtual void  v87(); // _ZN6S164C53v87Ev
  virtual void  v88(); // _ZN6S164C53v88Ev
  S164C5(); // tgen
};
//SIG(-1 S164C5) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S164C5 ::~S164C5(){ note_dtor("S164C5", this);}
void  S164C5 ::v87(){vfunc_called(this, "_ZN6S164C53v87Ev");}
void  S164C5 ::v88(){vfunc_called(this, "_ZN6S164C53v88Ev");}
S164C5 ::S164C5(){ note_ctor("S164C5", this);} // tgen

static void Test_S164C5()
{
  extern Class_Descriptor cd_S164C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S164C5, buf);
    S164C5 *dp, &lv = *(dp=new (buf) S164C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S164C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C5)");
    check_base_class_offset(lv, (S164C6*), 0, "S164C5");
    test_class_info(&lv, &cd_S164C5);
    dp->~S164C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C5(Test_S164C5, "S164C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S164C5C1Ev();
extern void _ZN6S164C5D1Ev();
Name_Map name_map_S164C5[] = {
  NSPAIR(_ZN6S164C5C1Ev),
  NSPAIR(_ZN6S164C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S164C6;
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
static Base_Class bases_S164C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S164C5[];
extern void _ZN6S164C5D1Ev();
extern void _ZN6S164C5D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
extern void _ZN6S164C53v87Ev();
extern void _ZN6S164C53v88Ev();
static  VTBL_ENTRY vtc_S164C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C5[0]),
  (VTBL_ENTRY)&_ZN6S164C5D1Ev,
  (VTBL_ENTRY)&_ZN6S164C5D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
  (VTBL_ENTRY)&_ZN6S164C53v87Ev,
  (VTBL_ENTRY)&_ZN6S164C53v88Ev,
};
extern VTBL_ENTRY _ZTI6S164C5[];
extern  VTBL_ENTRY _ZTV6S164C5[];
Class_Descriptor cd_S164C5 = {  "S164C5", // class name
  bases_S164C5, 1,
  &(vtc_S164C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S164C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S164C5),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C4  : S164C5 {
  char s164c4f0;
  ::S3422C23 s164c4f1;
  ::S49C12_nt s164c4f2;
  virtual  ~S164C4(); // _ZN6S164C4D1Ev
  virtual void  v89(); // _ZN6S164C43v89Ev
  virtual void  v90(); // _ZN6S164C43v90Ev
  virtual void  v91(); // _ZN6S164C43v91Ev
  virtual void  v92(); // _ZN6S164C43v92Ev
  virtual void  v93(); // _ZN6S164C43v93Ev
  virtual void  v94(); // _ZN6S164C43v94Ev
  virtual void  v95(); // _ZN6S164C43v95Ev
  virtual void  v96(); // _ZN6S164C43v96Ev
  virtual void  v97(); // _ZN6S164C43v97Ev
  virtual void  v98(); // _ZN6S164C43v98Ev
  virtual void  v99(); // _ZN6S164C43v99Ev
  virtual void  v100(); // _ZN6S164C44v100Ev
  S164C4(); // tgen
};
//SIG(-1 S164C4) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S164C4 ::~S164C4(){ note_dtor("S164C4", this);}
void  S164C4 ::v89(){vfunc_called(this, "_ZN6S164C43v89Ev");}
void  S164C4 ::v90(){vfunc_called(this, "_ZN6S164C43v90Ev");}
void  S164C4 ::v91(){vfunc_called(this, "_ZN6S164C43v91Ev");}
void  S164C4 ::v92(){vfunc_called(this, "_ZN6S164C43v92Ev");}
void  S164C4 ::v93(){vfunc_called(this, "_ZN6S164C43v93Ev");}
void  S164C4 ::v94(){vfunc_called(this, "_ZN6S164C43v94Ev");}
void  S164C4 ::v95(){vfunc_called(this, "_ZN6S164C43v95Ev");}
void  S164C4 ::v96(){vfunc_called(this, "_ZN6S164C43v96Ev");}
void  S164C4 ::v97(){vfunc_called(this, "_ZN6S164C43v97Ev");}
void  S164C4 ::v98(){vfunc_called(this, "_ZN6S164C43v98Ev");}
void  S164C4 ::v99(){vfunc_called(this, "_ZN6S164C43v99Ev");}
void  S164C4 ::v100(){vfunc_called(this, "_ZN6S164C44v100Ev");}
S164C4 ::S164C4(){ note_ctor("S164C4", this);} // tgen

static void Test_S164C4()
{
  extern Class_Descriptor cd_S164C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S164C4, buf);
    S164C4 *dp, &lv = *(dp=new (buf) S164C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S164C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C4)");
    check_base_class_offset(lv, (S164C6*)(S164C5*), 0, "S164C4");
    check_base_class_offset(lv, (S164C5*), 0, "S164C4");
    check_field_offset(lv, s164c4f0, ABISELECT(96,60), "S164C4.s164c4f0");
    check_field_offset(lv, s164c4f1, ABISELECT(104,64), "S164C4.s164c4f1");
    check_field_offset(lv, s164c4f2, ABISELECT(120,76), "S164C4.s164c4f2");
    test_class_info(&lv, &cd_S164C4);
    dp->~S164C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C4(Test_S164C4, "S164C4", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S164C4C1Ev();
extern void _ZN6S164C4D1Ev();
Name_Map name_map_S164C4[] = {
  NSPAIR(_ZN6S164C4C1Ev),
  NSPAIR(_ZN6S164C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S164C6;
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
extern Class_Descriptor cd_S164C5;
extern VTBL_ENTRY _ZTI6S164C5[];
extern  VTBL_ENTRY _ZTV6S164C5[];
static Base_Class bases_S164C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S164C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S164C4[];
extern void _ZN6S164C4D1Ev();
extern void _ZN6S164C4D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
extern void _ZN6S164C53v87Ev();
extern void _ZN6S164C53v88Ev();
extern void _ZN6S164C43v89Ev();
extern void _ZN6S164C43v90Ev();
extern void _ZN6S164C43v91Ev();
extern void _ZN6S164C43v92Ev();
extern void _ZN6S164C43v93Ev();
extern void _ZN6S164C43v94Ev();
extern void _ZN6S164C43v95Ev();
extern void _ZN6S164C43v96Ev();
extern void _ZN6S164C43v97Ev();
extern void _ZN6S164C43v98Ev();
extern void _ZN6S164C43v99Ev();
extern void _ZN6S164C44v100Ev();
static  VTBL_ENTRY vtc_S164C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C4[0]),
  (VTBL_ENTRY)&_ZN6S164C4D1Ev,
  (VTBL_ENTRY)&_ZN6S164C4D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
  (VTBL_ENTRY)&_ZN6S164C53v87Ev,
  (VTBL_ENTRY)&_ZN6S164C53v88Ev,
  (VTBL_ENTRY)&_ZN6S164C43v89Ev,
  (VTBL_ENTRY)&_ZN6S164C43v90Ev,
  (VTBL_ENTRY)&_ZN6S164C43v91Ev,
  (VTBL_ENTRY)&_ZN6S164C43v92Ev,
  (VTBL_ENTRY)&_ZN6S164C43v93Ev,
  (VTBL_ENTRY)&_ZN6S164C43v94Ev,
  (VTBL_ENTRY)&_ZN6S164C43v95Ev,
  (VTBL_ENTRY)&_ZN6S164C43v96Ev,
  (VTBL_ENTRY)&_ZN6S164C43v97Ev,
  (VTBL_ENTRY)&_ZN6S164C43v98Ev,
  (VTBL_ENTRY)&_ZN6S164C43v99Ev,
  (VTBL_ENTRY)&_ZN6S164C44v100Ev,
};
extern VTBL_ENTRY _ZTI6S164C4[];
extern  VTBL_ENTRY _ZTV6S164C4[];
Class_Descriptor cd_S164C4 = {  "S164C4", // class name
  bases_S164C4, 2,
  &(vtc_S164C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S164C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S164C4),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C3  : S164C4 {
  ::S3422C4_nt s164c3f0;
  ::S3422C23 s164c3f1;
  ::S49C12_nt s164c3f2;
  virtual  ~S164C3(); // _ZN6S164C3D1Ev
  virtual void  v101(); // _ZN6S164C34v101Ev
  virtual void  v102(); // _ZN6S164C34v102Ev
  virtual void  v103(); // _ZN6S164C34v103Ev
  virtual void  v104(); // _ZN6S164C34v104Ev
  virtual void  v105(); // _ZN6S164C34v105Ev
  virtual void  v106(); // _ZN6S164C34v106Ev
  virtual void  v107(); // _ZN6S164C34v107Ev
  virtual void  v108(); // _ZN6S164C34v108Ev
  virtual void  v109(); // _ZN6S164C34v109Ev
  S164C3(); // tgen
};
//SIG(-1 S164C3) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S164C3 ::~S164C3(){ note_dtor("S164C3", this);}
void  S164C3 ::v101(){vfunc_called(this, "_ZN6S164C34v101Ev");}
void  S164C3 ::v102(){vfunc_called(this, "_ZN6S164C34v102Ev");}
void  S164C3 ::v103(){vfunc_called(this, "_ZN6S164C34v103Ev");}
void  S164C3 ::v104(){vfunc_called(this, "_ZN6S164C34v104Ev");}
void  S164C3 ::v105(){vfunc_called(this, "_ZN6S164C34v105Ev");}
void  S164C3 ::v106(){vfunc_called(this, "_ZN6S164C34v106Ev");}
void  S164C3 ::v107(){vfunc_called(this, "_ZN6S164C34v107Ev");}
void  S164C3 ::v108(){vfunc_called(this, "_ZN6S164C34v108Ev");}
void  S164C3 ::v109(){vfunc_called(this, "_ZN6S164C34v109Ev");}
S164C3 ::S164C3(){ note_ctor("S164C3", this);} // tgen

static void Test_S164C3()
{
  extern Class_Descriptor cd_S164C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S164C3, buf);
    S164C3 *dp, &lv = *(dp=new (buf) S164C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S164C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C3)");
    check_base_class_offset(lv, (S164C6*)(S164C5*)(S164C4*), 0, "S164C3");
    check_base_class_offset(lv, (S164C5*)(S164C4*), 0, "S164C3");
    check_base_class_offset(lv, (S164C4*), 0, "S164C3");
    check_field_offset(lv, s164c3f0, ABISELECT(136,88), "S164C3.s164c3f0");
    check_field_offset(lv, s164c3f1, ABISELECT(144,96), "S164C3.s164c3f1");
    check_field_offset(lv, s164c3f2, ABISELECT(160,108), "S164C3.s164c3f2");
    test_class_info(&lv, &cd_S164C3);
    dp->~S164C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C3(Test_S164C3, "S164C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S164C3C1Ev();
extern void _ZN6S164C3D1Ev();
Name_Map name_map_S164C3[] = {
  NSPAIR(_ZN6S164C3C1Ev),
  NSPAIR(_ZN6S164C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S164C6;
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
extern Class_Descriptor cd_S164C5;
extern VTBL_ENTRY _ZTI6S164C5[];
extern  VTBL_ENTRY _ZTV6S164C5[];
extern Class_Descriptor cd_S164C4;
extern VTBL_ENTRY _ZTI6S164C4[];
extern  VTBL_ENTRY _ZTV6S164C4[];
static Base_Class bases_S164C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S164C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S164C3[];
extern void _ZN6S164C3D1Ev();
extern void _ZN6S164C3D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
extern void _ZN6S164C53v87Ev();
extern void _ZN6S164C53v88Ev();
extern void _ZN6S164C43v89Ev();
extern void _ZN6S164C43v90Ev();
extern void _ZN6S164C43v91Ev();
extern void _ZN6S164C43v92Ev();
extern void _ZN6S164C43v93Ev();
extern void _ZN6S164C43v94Ev();
extern void _ZN6S164C43v95Ev();
extern void _ZN6S164C43v96Ev();
extern void _ZN6S164C43v97Ev();
extern void _ZN6S164C43v98Ev();
extern void _ZN6S164C43v99Ev();
extern void _ZN6S164C44v100Ev();
extern void _ZN6S164C34v101Ev();
extern void _ZN6S164C34v102Ev();
extern void _ZN6S164C34v103Ev();
extern void _ZN6S164C34v104Ev();
extern void _ZN6S164C34v105Ev();
extern void _ZN6S164C34v106Ev();
extern void _ZN6S164C34v107Ev();
extern void _ZN6S164C34v108Ev();
extern void _ZN6S164C34v109Ev();
static  VTBL_ENTRY vtc_S164C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C3[0]),
  (VTBL_ENTRY)&_ZN6S164C3D1Ev,
  (VTBL_ENTRY)&_ZN6S164C3D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
  (VTBL_ENTRY)&_ZN6S164C53v87Ev,
  (VTBL_ENTRY)&_ZN6S164C53v88Ev,
  (VTBL_ENTRY)&_ZN6S164C43v89Ev,
  (VTBL_ENTRY)&_ZN6S164C43v90Ev,
  (VTBL_ENTRY)&_ZN6S164C43v91Ev,
  (VTBL_ENTRY)&_ZN6S164C43v92Ev,
  (VTBL_ENTRY)&_ZN6S164C43v93Ev,
  (VTBL_ENTRY)&_ZN6S164C43v94Ev,
  (VTBL_ENTRY)&_ZN6S164C43v95Ev,
  (VTBL_ENTRY)&_ZN6S164C43v96Ev,
  (VTBL_ENTRY)&_ZN6S164C43v97Ev,
  (VTBL_ENTRY)&_ZN6S164C43v98Ev,
  (VTBL_ENTRY)&_ZN6S164C43v99Ev,
  (VTBL_ENTRY)&_ZN6S164C44v100Ev,
  (VTBL_ENTRY)&_ZN6S164C34v101Ev,
  (VTBL_ENTRY)&_ZN6S164C34v102Ev,
  (VTBL_ENTRY)&_ZN6S164C34v103Ev,
  (VTBL_ENTRY)&_ZN6S164C34v104Ev,
  (VTBL_ENTRY)&_ZN6S164C34v105Ev,
  (VTBL_ENTRY)&_ZN6S164C34v106Ev,
  (VTBL_ENTRY)&_ZN6S164C34v107Ev,
  (VTBL_ENTRY)&_ZN6S164C34v108Ev,
  (VTBL_ENTRY)&_ZN6S164C34v109Ev,
};
extern VTBL_ENTRY _ZTI6S164C3[];
extern  VTBL_ENTRY _ZTV6S164C3[];
Class_Descriptor cd_S164C3 = {  "S164C3", // class name
  bases_S164C3, 3,
  &(vtc_S164C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S164C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S164C3),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C12  {
  virtual  ~S164C12(); // _ZN7S164C12D1Ev
  virtual void  v110(); // _ZN7S164C124v110Ev
  virtual void  v111(); // _ZN7S164C124v111Ev
  virtual void  v112(); // _ZN7S164C124v112Ev
  virtual void  v113(); // _ZN7S164C124v113Ev
  virtual void  v114(); // _ZN7S164C124v114Ev
  virtual void  v115(); // _ZN7S164C124v115Ev
  virtual void  v116(); // _ZN7S164C124v116Ev
  virtual void  v117(); // _ZN7S164C124v117Ev
  S164C12(); // tgen
};
//SIG(-1 S164C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S164C12 ::~S164C12(){ note_dtor("S164C12", this);}
void  S164C12 ::v110(){vfunc_called(this, "_ZN7S164C124v110Ev");}
void  S164C12 ::v111(){vfunc_called(this, "_ZN7S164C124v111Ev");}
void  S164C12 ::v112(){vfunc_called(this, "_ZN7S164C124v112Ev");}
void  S164C12 ::v113(){vfunc_called(this, "_ZN7S164C124v113Ev");}
void  S164C12 ::v114(){vfunc_called(this, "_ZN7S164C124v114Ev");}
void  S164C12 ::v115(){vfunc_called(this, "_ZN7S164C124v115Ev");}
void  S164C12 ::v116(){vfunc_called(this, "_ZN7S164C124v116Ev");}
void  S164C12 ::v117(){vfunc_called(this, "_ZN7S164C124v117Ev");}
S164C12 ::S164C12(){ note_ctor("S164C12", this);} // tgen

static void Test_S164C12()
{
  extern Class_Descriptor cd_S164C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S164C12, buf);
    S164C12 *dp, &lv = *(dp=new (buf) S164C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S164C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C12)");
    test_class_info(&lv, &cd_S164C12);
    dp->~S164C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C12(Test_S164C12, "S164C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S164C12C1Ev();
extern void _ZN7S164C12D1Ev();
Name_Map name_map_S164C12[] = {
  NSPAIR(_ZN7S164C12C1Ev),
  NSPAIR(_ZN7S164C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S164C12[];
extern void _ZN7S164C12D1Ev();
extern void _ZN7S164C12D0Ev();
extern void _ZN7S164C124v110Ev();
extern void _ZN7S164C124v111Ev();
extern void _ZN7S164C124v112Ev();
extern void _ZN7S164C124v113Ev();
extern void _ZN7S164C124v114Ev();
extern void _ZN7S164C124v115Ev();
extern void _ZN7S164C124v116Ev();
extern void _ZN7S164C124v117Ev();
static  VTBL_ENTRY vtc_S164C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S164C12[0]),
  (VTBL_ENTRY)&_ZN7S164C12D1Ev,
  (VTBL_ENTRY)&_ZN7S164C12D0Ev,
  (VTBL_ENTRY)&_ZN7S164C124v110Ev,
  (VTBL_ENTRY)&_ZN7S164C124v111Ev,
  (VTBL_ENTRY)&_ZN7S164C124v112Ev,
  (VTBL_ENTRY)&_ZN7S164C124v113Ev,
  (VTBL_ENTRY)&_ZN7S164C124v114Ev,
  (VTBL_ENTRY)&_ZN7S164C124v115Ev,
  (VTBL_ENTRY)&_ZN7S164C124v116Ev,
  (VTBL_ENTRY)&_ZN7S164C124v117Ev,
};
extern VTBL_ENTRY _ZTI7S164C12[];
extern  VTBL_ENTRY _ZTV7S164C12[];
Class_Descriptor cd_S164C12 = {  "S164C12", // class name
  0,0,//no base classes
  &(vtc_S164C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S164C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S164C12),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C16_nt  {
  ::S3422C24 s164c16f0;
  void *s164c16f1;
  int s164c16f2;
  void  mf164c16(); // _ZN10S164C16_nt8mf164c16Ev
};
//SIG(-1 S164C16_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S164C16_nt ::mf164c16(){}

//skip512 S164C16_nt

#else // __cplusplus

Class_Descriptor cd_S164C16_nt = {  "S164C16_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C15_nt  : S164C16_nt {
};
//SIG(-1 S164C15_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S164C15_nt

#else // __cplusplus

extern Class_Descriptor cd_S164C16_nt;
static Base_Class bases_S164C15_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C2  : S164C3 , S164C12 {
  ::S3422C17 s164c2f0;
  ::S164C15_nt s164c2f1;
  virtual  ~S164C2(); // _ZN6S164C2D1Ev
  virtual void  v118(); // _ZN6S164C24v118Ev
  virtual void  v119(); // _ZN6S164C24v119Ev
  virtual void  v120(); // _ZN6S164C24v120Ev
  virtual void  v121(); // _ZN6S164C24v121Ev
  virtual void  v122(); // _ZN6S164C24v122Ev
  virtual void  v123(); // _ZN6S164C24v123Ev
  virtual void  v124(); // _ZN6S164C24v124Ev
  virtual void  v125(); // _ZN6S164C24v125Ev
  virtual void  v126(); // _ZN6S164C24v126Ev
  virtual void  v127(); // _ZN6S164C24v127Ev
  virtual void  v128(); // _ZN6S164C24v128Ev
  virtual void  v129(); // _ZN6S164C24v129Ev
  virtual void  v130(); // _ZN6S164C24v130Ev
  virtual void  v131(); // _ZN6S164C24v131Ev
  virtual void  v132(); // _ZN6S164C24v132Ev
  virtual void  v133(); // _ZN6S164C24v133Ev
  virtual void  v134(); // _ZN6S164C24v134Ev
  virtual void  v135(); // _ZN6S164C24v135Ev
  virtual void  v136(); // _ZN6S164C24v136Ev
  S164C2(); // tgen
};
//SIG(-1 S164C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v84 v85} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 FC6 FC7 FC10} BC11{ vd v107 v108 v109 v110 v111 v112 v113 v114} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC12{ BC13{ BC9}} FC14{ BC15{ m FC8 Fp Fi}}}


 S164C2 ::~S164C2(){ note_dtor("S164C2", this);}
void  S164C2 ::v118(){vfunc_called(this, "_ZN6S164C24v118Ev");}
void  S164C2 ::v119(){vfunc_called(this, "_ZN6S164C24v119Ev");}
void  S164C2 ::v120(){vfunc_called(this, "_ZN6S164C24v120Ev");}
void  S164C2 ::v121(){vfunc_called(this, "_ZN6S164C24v121Ev");}
void  S164C2 ::v122(){vfunc_called(this, "_ZN6S164C24v122Ev");}
void  S164C2 ::v123(){vfunc_called(this, "_ZN6S164C24v123Ev");}
void  S164C2 ::v124(){vfunc_called(this, "_ZN6S164C24v124Ev");}
void  S164C2 ::v125(){vfunc_called(this, "_ZN6S164C24v125Ev");}
void  S164C2 ::v126(){vfunc_called(this, "_ZN6S164C24v126Ev");}
void  S164C2 ::v127(){vfunc_called(this, "_ZN6S164C24v127Ev");}
void  S164C2 ::v128(){vfunc_called(this, "_ZN6S164C24v128Ev");}
void  S164C2 ::v129(){vfunc_called(this, "_ZN6S164C24v129Ev");}
void  S164C2 ::v130(){vfunc_called(this, "_ZN6S164C24v130Ev");}
void  S164C2 ::v131(){vfunc_called(this, "_ZN6S164C24v131Ev");}
void  S164C2 ::v132(){vfunc_called(this, "_ZN6S164C24v132Ev");}
void  S164C2 ::v133(){vfunc_called(this, "_ZN6S164C24v133Ev");}
void  S164C2 ::v134(){vfunc_called(this, "_ZN6S164C24v134Ev");}
void  S164C2 ::v135(){vfunc_called(this, "_ZN6S164C24v135Ev");}
void  S164C2 ::v136(){vfunc_called(this, "_ZN6S164C24v136Ev");}
S164C2 ::S164C2(){ note_ctor("S164C2", this);} // tgen

static void Test_S164C2()
{
  extern Class_Descriptor cd_S164C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,40)];
    init_test(&cd_S164C2, buf);
    S164C2 *dp, &lv = *(dp=new (buf) S164C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,156), "sizeof(S164C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C2)");
    check_base_class_offset(lv, (S164C6*)(S164C5*)(S164C4*)(S164C3*), 0, "S164C2");
    check_base_class_offset(lv, (S164C5*)(S164C4*)(S164C3*), 0, "S164C2");
    check_base_class_offset(lv, (S164C4*)(S164C3*), 0, "S164C2");
    check_base_class_offset(lv, (S164C3*), 0, "S164C2");
    check_base_class_offset(lv, (S164C12*), ABISELECT(176,120), "S164C2");
    check_field_offset(lv, s164c2f0, ABISELECT(184,124), "S164C2.s164c2f0");
    check_field_offset(lv, s164c2f1, ABISELECT(200,136), "S164C2.s164c2f1");
    test_class_info(&lv, &cd_S164C2);
    dp->~S164C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C2(Test_S164C2, "S164C2", ABISELECT(232,156));

#else // __cplusplus

extern void _ZN6S164C2C1Ev();
extern void _ZN6S164C2D1Ev();
Name_Map name_map_S164C2[] = {
  NSPAIR(_ZN6S164C2C1Ev),
  NSPAIR(_ZN6S164C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S164C6;
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
extern Class_Descriptor cd_S164C5;
extern VTBL_ENTRY _ZTI6S164C5[];
extern  VTBL_ENTRY _ZTV6S164C5[];
extern Class_Descriptor cd_S164C4;
extern VTBL_ENTRY _ZTI6S164C4[];
extern  VTBL_ENTRY _ZTV6S164C4[];
extern Class_Descriptor cd_S164C3;
extern VTBL_ENTRY _ZTI6S164C3[];
extern  VTBL_ENTRY _ZTV6S164C3[];
extern Class_Descriptor cd_S164C12;
extern VTBL_ENTRY _ZTI7S164C12[];
extern  VTBL_ENTRY _ZTV7S164C12[];
static Base_Class bases_S164C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S164C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S164C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S164C12,    ABISELECT(176,120), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S164C2[];
extern void _ZN6S164C2D1Ev();
extern void _ZN6S164C2D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
extern void _ZN6S164C53v87Ev();
extern void _ZN6S164C53v88Ev();
extern void _ZN6S164C43v89Ev();
extern void _ZN6S164C43v90Ev();
extern void _ZN6S164C43v91Ev();
extern void _ZN6S164C43v92Ev();
extern void _ZN6S164C43v93Ev();
extern void _ZN6S164C43v94Ev();
extern void _ZN6S164C43v95Ev();
extern void _ZN6S164C43v96Ev();
extern void _ZN6S164C43v97Ev();
extern void _ZN6S164C43v98Ev();
extern void _ZN6S164C43v99Ev();
extern void _ZN6S164C44v100Ev();
extern void _ZN6S164C34v101Ev();
extern void _ZN6S164C34v102Ev();
extern void _ZN6S164C34v103Ev();
extern void _ZN6S164C34v104Ev();
extern void _ZN6S164C34v105Ev();
extern void _ZN6S164C34v106Ev();
extern void _ZN6S164C34v107Ev();
extern void _ZN6S164C34v108Ev();
extern void _ZN6S164C34v109Ev();
extern void _ZN6S164C24v118Ev();
extern void _ZN6S164C24v119Ev();
extern void _ZN6S164C24v120Ev();
extern void _ZN6S164C24v121Ev();
extern void _ZN6S164C24v122Ev();
extern void _ZN6S164C24v123Ev();
extern void _ZN6S164C24v124Ev();
extern void _ZN6S164C24v125Ev();
extern void _ZN6S164C24v126Ev();
extern void _ZN6S164C24v127Ev();
extern void _ZN6S164C24v128Ev();
extern void _ZN6S164C24v129Ev();
extern void _ZN6S164C24v130Ev();
extern void _ZN6S164C24v131Ev();
extern void _ZN6S164C24v132Ev();
extern void _ZN6S164C24v133Ev();
extern void _ZN6S164C24v134Ev();
extern void _ZN6S164C24v135Ev();
extern void _ZN6S164C24v136Ev();
extern void ABISELECT(_ZThn176_N6S164C2D1Ev,_ZThn120_N6S164C2D1Ev)();
extern void ABISELECT(_ZThn176_N6S164C2D0Ev,_ZThn120_N6S164C2D0Ev)();
extern void _ZN7S164C124v110Ev();
extern void _ZN7S164C124v111Ev();
extern void _ZN7S164C124v112Ev();
extern void _ZN7S164C124v113Ev();
extern void _ZN7S164C124v114Ev();
extern void _ZN7S164C124v115Ev();
extern void _ZN7S164C124v116Ev();
extern void _ZN7S164C124v117Ev();
static  VTBL_ENTRY vtc_S164C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C2[0]),
  (VTBL_ENTRY)&_ZN6S164C2D1Ev,
  (VTBL_ENTRY)&_ZN6S164C2D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
  (VTBL_ENTRY)&_ZN6S164C53v87Ev,
  (VTBL_ENTRY)&_ZN6S164C53v88Ev,
  (VTBL_ENTRY)&_ZN6S164C43v89Ev,
  (VTBL_ENTRY)&_ZN6S164C43v90Ev,
  (VTBL_ENTRY)&_ZN6S164C43v91Ev,
  (VTBL_ENTRY)&_ZN6S164C43v92Ev,
  (VTBL_ENTRY)&_ZN6S164C43v93Ev,
  (VTBL_ENTRY)&_ZN6S164C43v94Ev,
  (VTBL_ENTRY)&_ZN6S164C43v95Ev,
  (VTBL_ENTRY)&_ZN6S164C43v96Ev,
  (VTBL_ENTRY)&_ZN6S164C43v97Ev,
  (VTBL_ENTRY)&_ZN6S164C43v98Ev,
  (VTBL_ENTRY)&_ZN6S164C43v99Ev,
  (VTBL_ENTRY)&_ZN6S164C44v100Ev,
  (VTBL_ENTRY)&_ZN6S164C34v101Ev,
  (VTBL_ENTRY)&_ZN6S164C34v102Ev,
  (VTBL_ENTRY)&_ZN6S164C34v103Ev,
  (VTBL_ENTRY)&_ZN6S164C34v104Ev,
  (VTBL_ENTRY)&_ZN6S164C34v105Ev,
  (VTBL_ENTRY)&_ZN6S164C34v106Ev,
  (VTBL_ENTRY)&_ZN6S164C34v107Ev,
  (VTBL_ENTRY)&_ZN6S164C34v108Ev,
  (VTBL_ENTRY)&_ZN6S164C34v109Ev,
  (VTBL_ENTRY)&_ZN6S164C24v118Ev,
  (VTBL_ENTRY)&_ZN6S164C24v119Ev,
  (VTBL_ENTRY)&_ZN6S164C24v120Ev,
  (VTBL_ENTRY)&_ZN6S164C24v121Ev,
  (VTBL_ENTRY)&_ZN6S164C24v122Ev,
  (VTBL_ENTRY)&_ZN6S164C24v123Ev,
  (VTBL_ENTRY)&_ZN6S164C24v124Ev,
  (VTBL_ENTRY)&_ZN6S164C24v125Ev,
  (VTBL_ENTRY)&_ZN6S164C24v126Ev,
  (VTBL_ENTRY)&_ZN6S164C24v127Ev,
  (VTBL_ENTRY)&_ZN6S164C24v128Ev,
  (VTBL_ENTRY)&_ZN6S164C24v129Ev,
  (VTBL_ENTRY)&_ZN6S164C24v130Ev,
  (VTBL_ENTRY)&_ZN6S164C24v131Ev,
  (VTBL_ENTRY)&_ZN6S164C24v132Ev,
  (VTBL_ENTRY)&_ZN6S164C24v133Ev,
  (VTBL_ENTRY)&_ZN6S164C24v134Ev,
  (VTBL_ENTRY)&_ZN6S164C24v135Ev,
  (VTBL_ENTRY)&_ZN6S164C24v136Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S164C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S164C2D1Ev,_ZThn120_N6S164C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S164C2D0Ev,_ZThn120_N6S164C2D0Ev),
  (VTBL_ENTRY)&_ZN7S164C124v110Ev,
  (VTBL_ENTRY)&_ZN7S164C124v111Ev,
  (VTBL_ENTRY)&_ZN7S164C124v112Ev,
  (VTBL_ENTRY)&_ZN7S164C124v113Ev,
  (VTBL_ENTRY)&_ZN7S164C124v114Ev,
  (VTBL_ENTRY)&_ZN7S164C124v115Ev,
  (VTBL_ENTRY)&_ZN7S164C124v116Ev,
  (VTBL_ENTRY)&_ZN7S164C124v117Ev,
};
extern VTBL_ENTRY _ZTI6S164C2[];
extern  VTBL_ENTRY _ZTV6S164C2[];
Class_Descriptor cd_S164C2 = {  "S164C2", // class name
  bases_S164C2, 5,
  &(vtc_S164C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,156), // object size
  NSPAIRA(_ZTI6S164C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S164C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C18  {
  virtual  ~S164C18(); // _ZN7S164C18D1Ev
  virtual void  v137(); // _ZN7S164C184v137Ev
  virtual void  v138(); // _ZN7S164C184v138Ev
  virtual void  v139(); // _ZN7S164C184v139Ev
  virtual void  v140(); // _ZN7S164C184v140Ev
  S164C18(); // tgen
};
//SIG(-1 S164C18) C1{ vd v1 v2 v3 v4}


 S164C18 ::~S164C18(){ note_dtor("S164C18", this);}
void  S164C18 ::v137(){vfunc_called(this, "_ZN7S164C184v137Ev");}
void  S164C18 ::v138(){vfunc_called(this, "_ZN7S164C184v138Ev");}
void  S164C18 ::v139(){vfunc_called(this, "_ZN7S164C184v139Ev");}
void  S164C18 ::v140(){vfunc_called(this, "_ZN7S164C184v140Ev");}
S164C18 ::S164C18(){ note_ctor("S164C18", this);} // tgen

static void Test_S164C18()
{
  extern Class_Descriptor cd_S164C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S164C18, buf);
    S164C18 *dp, &lv = *(dp=new (buf) S164C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S164C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C18)");
    test_class_info(&lv, &cd_S164C18);
    dp->~S164C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C18(Test_S164C18, "S164C18", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S164C18C1Ev();
extern void _ZN7S164C18D1Ev();
Name_Map name_map_S164C18[] = {
  NSPAIR(_ZN7S164C18C1Ev),
  NSPAIR(_ZN7S164C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S164C18[];
extern void _ZN7S164C18D1Ev();
extern void _ZN7S164C18D0Ev();
extern void _ZN7S164C184v137Ev();
extern void _ZN7S164C184v138Ev();
extern void _ZN7S164C184v139Ev();
extern void _ZN7S164C184v140Ev();
static  VTBL_ENTRY vtc_S164C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S164C18[0]),
  (VTBL_ENTRY)&_ZN7S164C18D1Ev,
  (VTBL_ENTRY)&_ZN7S164C18D0Ev,
  (VTBL_ENTRY)&_ZN7S164C184v137Ev,
  (VTBL_ENTRY)&_ZN7S164C184v138Ev,
  (VTBL_ENTRY)&_ZN7S164C184v139Ev,
  (VTBL_ENTRY)&_ZN7S164C184v140Ev,
};
extern VTBL_ENTRY _ZTI7S164C18[];
extern  VTBL_ENTRY _ZTV7S164C18[];
Class_Descriptor cd_S164C18 = {  "S164C18", // class name
  0,0,//no base classes
  &(vtc_S164C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S164C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S164C18),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S164C1  : S164C2 , S164C18 {
  ::S3422C11 s164c1f0;
  ::S3422C11 s164c1f1;
  ::S3422C11 s164c1f2;
  int s164c1f3;
  virtual  ~S164C1(); // _ZN6S164C1D1Ev
  virtual void  v1(); // _ZN6S164C12v1Ev
  virtual void  v2(); // _ZN6S164C12v2Ev
  virtual void  v3(); // _ZN6S164C12v3Ev
  virtual void  v4(); // _ZN6S164C12v4Ev
  virtual void  v5(); // _ZN6S164C12v5Ev
  virtual void  v6(); // _ZN6S164C12v6Ev
  virtual void  v7(); // _ZN6S164C12v7Ev
  virtual void  v8(); // _ZN6S164C12v8Ev
  virtual void  v9(); // _ZN6S164C12v9Ev
  virtual void  v10(); // _ZN6S164C13v10Ev
  virtual void  v11(); // _ZN6S164C13v11Ev
  virtual void  v12(); // _ZN6S164C13v12Ev
  virtual void  v13(); // _ZN6S164C13v13Ev
  virtual void  v14(); // _ZN6S164C13v14Ev
  virtual void  v15(); // _ZN6S164C13v15Ev
  virtual void  v16(); // _ZN6S164C13v16Ev
  virtual void  v17(); // _ZN6S164C13v17Ev
  virtual void  v18(); // _ZN6S164C13v18Ev
  virtual void  v19(); // _ZN6S164C13v19Ev
  virtual void  v20(); // _ZN6S164C13v20Ev
  virtual void  v21(); // _ZN6S164C13v21Ev
  virtual void  v22(); // _ZN6S164C13v22Ev
  S164C1(); // tgen
};
//SIG(1 S164C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v101 v102 v103 v104 v105 v106 v107 v108 v109 FC7 FC8 FC11} BC12{ vd v110 v111 v112 v113 v114 v115 v116 v117} vd v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 FC13{ BC14{ BC10}} FC15{ BC16{ m FC9 Fp Fi}}} BC17{ vd v137 v138 v139 v140} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 FC18{ BC19{ BC10}} FC18 FC18 Fi}


 S164C1 ::~S164C1(){ note_dtor("S164C1", this);}
void  S164C1 ::v1(){vfunc_called(this, "_ZN6S164C12v1Ev");}
void  S164C1 ::v2(){vfunc_called(this, "_ZN6S164C12v2Ev");}
void  S164C1 ::v3(){vfunc_called(this, "_ZN6S164C12v3Ev");}
void  S164C1 ::v4(){vfunc_called(this, "_ZN6S164C12v4Ev");}
void  S164C1 ::v5(){vfunc_called(this, "_ZN6S164C12v5Ev");}
void  S164C1 ::v6(){vfunc_called(this, "_ZN6S164C12v6Ev");}
void  S164C1 ::v7(){vfunc_called(this, "_ZN6S164C12v7Ev");}
void  S164C1 ::v8(){vfunc_called(this, "_ZN6S164C12v8Ev");}
void  S164C1 ::v9(){vfunc_called(this, "_ZN6S164C12v9Ev");}
void  S164C1 ::v10(){vfunc_called(this, "_ZN6S164C13v10Ev");}
void  S164C1 ::v11(){vfunc_called(this, "_ZN6S164C13v11Ev");}
void  S164C1 ::v12(){vfunc_called(this, "_ZN6S164C13v12Ev");}
void  S164C1 ::v13(){vfunc_called(this, "_ZN6S164C13v13Ev");}
void  S164C1 ::v14(){vfunc_called(this, "_ZN6S164C13v14Ev");}
void  S164C1 ::v15(){vfunc_called(this, "_ZN6S164C13v15Ev");}
void  S164C1 ::v16(){vfunc_called(this, "_ZN6S164C13v16Ev");}
void  S164C1 ::v17(){vfunc_called(this, "_ZN6S164C13v17Ev");}
void  S164C1 ::v18(){vfunc_called(this, "_ZN6S164C13v18Ev");}
void  S164C1 ::v19(){vfunc_called(this, "_ZN6S164C13v19Ev");}
void  S164C1 ::v20(){vfunc_called(this, "_ZN6S164C13v20Ev");}
void  S164C1 ::v21(){vfunc_called(this, "_ZN6S164C13v21Ev");}
void  S164C1 ::v22(){vfunc_called(this, "_ZN6S164C13v22Ev");}
S164C1 ::S164C1(){ note_ctor("S164C1", this);} // tgen

static void Test_S164C1()
{
  extern Class_Descriptor cd_S164C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,51)];
    init_test(&cd_S164C1, buf);
    S164C1 *dp, &lv = *(dp=new (buf) S164C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,200), "sizeof(S164C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S164C1)");
    check_base_class_offset(lv, (S164C6*)(S164C5*)(S164C4*)(S164C3*)(S164C2*), 0, "S164C1");
    check_base_class_offset(lv, (S164C5*)(S164C4*)(S164C3*)(S164C2*), 0, "S164C1");
    check_base_class_offset(lv, (S164C4*)(S164C3*)(S164C2*), 0, "S164C1");
    check_base_class_offset(lv, (S164C3*)(S164C2*), 0, "S164C1");
    check_base_class_offset(lv, (S164C12*)(S164C2*), ABISELECT(176,120), "S164C1");
    check_base_class_offset(lv, (S164C2*), 0, "S164C1");
    check_base_class_offset(lv, (S164C18*), ABISELECT(232,156), "S164C1");
    check_field_offset(lv, s164c1f0, ABISELECT(240,160), "S164C1.s164c1f0");
    check_field_offset(lv, s164c1f1, ABISELECT(256,172), "S164C1.s164c1f1");
    check_field_offset(lv, s164c1f2, ABISELECT(272,184), "S164C1.s164c1f2");
    check_field_offset(lv, s164c1f3, ABISELECT(288,196), "S164C1.s164c1f3");
    test_class_info(&lv, &cd_S164C1);
    dp->~S164C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS164C1(Test_S164C1, "S164C1", ABISELECT(296,200));

#else // __cplusplus

extern void _ZN6S164C1C1Ev();
extern void _ZN6S164C1D1Ev();
Name_Map name_map_S164C1[] = {
  NSPAIR(_ZN6S164C1C1Ev),
  NSPAIR(_ZN6S164C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S164C6;
extern VTBL_ENTRY _ZTI6S164C6[];
extern  VTBL_ENTRY _ZTV6S164C6[];
extern Class_Descriptor cd_S164C5;
extern VTBL_ENTRY _ZTI6S164C5[];
extern  VTBL_ENTRY _ZTV6S164C5[];
extern Class_Descriptor cd_S164C4;
extern VTBL_ENTRY _ZTI6S164C4[];
extern  VTBL_ENTRY _ZTV6S164C4[];
extern Class_Descriptor cd_S164C3;
extern VTBL_ENTRY _ZTI6S164C3[];
extern  VTBL_ENTRY _ZTV6S164C3[];
extern Class_Descriptor cd_S164C12;
extern VTBL_ENTRY _ZTI7S164C12[];
extern  VTBL_ENTRY _ZTV7S164C12[];
extern Class_Descriptor cd_S164C2;
extern VTBL_ENTRY _ZTI6S164C2[];
extern  VTBL_ENTRY _ZTV6S164C2[];
extern Class_Descriptor cd_S164C18;
extern VTBL_ENTRY _ZTI7S164C18[];
extern  VTBL_ENTRY _ZTV7S164C18[];
static Base_Class bases_S164C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S164C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S164C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S164C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S164C12,    ABISELECT(176,120), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S164C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S164C18,    ABISELECT(232,156), //bcp->offset
    144, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S164C1[];
extern void _ZN6S164C1D1Ev();
extern void _ZN6S164C1D0Ev();
extern void _ZN6S164C63v23Ev();
extern void _ZN6S164C63v24Ev();
extern void _ZN6S164C63v25Ev();
extern void _ZN6S164C63v26Ev();
extern void _ZN6S164C63v27Ev();
extern void _ZN6S164C63v28Ev();
extern void _ZN6S164C63v29Ev();
extern void _ZN6S164C63v30Ev();
extern void _ZN6S164C63v31Ev();
extern void _ZN6S164C63v32Ev();
extern void _ZN6S164C63v33Ev();
extern void _ZN6S164C63v34Ev();
extern void _ZN6S164C63v35Ev();
extern void _ZN6S164C63v36Ev();
extern void _ZN6S164C63v37Ev();
extern void _ZN6S164C63v38Ev();
extern void _ZN6S164C63v39Ev();
extern void _ZN6S164C63v40Ev();
extern void _ZN6S164C63v41Ev();
extern void _ZN6S164C63v42Ev();
extern void _ZN6S164C63v43Ev();
extern void _ZN6S164C63v44Ev();
extern void _ZN6S164C63v45Ev();
extern void _ZN6S164C63v46Ev();
extern void _ZN6S164C63v47Ev();
extern void _ZN6S164C63v48Ev();
extern void _ZN6S164C63v49Ev();
extern void _ZN6S164C63v50Ev();
extern void _ZN6S164C63v51Ev();
extern void _ZN6S164C63v52Ev();
extern void _ZN6S164C63v53Ev();
extern void _ZN6S164C63v54Ev();
extern void _ZN6S164C63v55Ev();
extern void _ZN6S164C63v56Ev();
extern void _ZN6S164C63v57Ev();
extern void _ZN6S164C63v58Ev();
extern void _ZN6S164C63v59Ev();
extern void _ZN6S164C63v60Ev();
extern void _ZN6S164C63v61Ev();
extern void _ZN6S164C63v62Ev();
extern void _ZN6S164C63v63Ev();
extern void _ZN6S164C63v64Ev();
extern void _ZN6S164C63v65Ev();
extern void _ZN6S164C63v66Ev();
extern void _ZN6S164C63v67Ev();
extern void _ZN6S164C63v68Ev();
extern void _ZN6S164C63v69Ev();
extern void _ZN6S164C63v70Ev();
extern void _ZN6S164C63v71Ev();
extern void _ZN6S164C63v72Ev();
extern void _ZN6S164C63v73Ev();
extern void _ZN6S164C63v74Ev();
extern void _ZN6S164C63v75Ev();
extern void _ZN6S164C63v76Ev();
extern void _ZN6S164C63v77Ev();
extern void _ZN6S164C63v78Ev();
extern void _ZN6S164C63v79Ev();
extern void _ZN6S164C63v80Ev();
extern void _ZN6S164C63v81Ev();
extern void _ZN6S164C63v82Ev();
extern void _ZN6S164C63v83Ev();
extern void _ZN6S164C63v84Ev();
extern void _ZN6S164C63v85Ev();
extern void _ZN6S164C63v86Ev();
extern void _ZN6S164C53v87Ev();
extern void _ZN6S164C53v88Ev();
extern void _ZN6S164C43v89Ev();
extern void _ZN6S164C43v90Ev();
extern void _ZN6S164C43v91Ev();
extern void _ZN6S164C43v92Ev();
extern void _ZN6S164C43v93Ev();
extern void _ZN6S164C43v94Ev();
extern void _ZN6S164C43v95Ev();
extern void _ZN6S164C43v96Ev();
extern void _ZN6S164C43v97Ev();
extern void _ZN6S164C43v98Ev();
extern void _ZN6S164C43v99Ev();
extern void _ZN6S164C44v100Ev();
extern void _ZN6S164C34v101Ev();
extern void _ZN6S164C34v102Ev();
extern void _ZN6S164C34v103Ev();
extern void _ZN6S164C34v104Ev();
extern void _ZN6S164C34v105Ev();
extern void _ZN6S164C34v106Ev();
extern void _ZN6S164C34v107Ev();
extern void _ZN6S164C34v108Ev();
extern void _ZN6S164C34v109Ev();
extern void _ZN6S164C24v118Ev();
extern void _ZN6S164C24v119Ev();
extern void _ZN6S164C24v120Ev();
extern void _ZN6S164C24v121Ev();
extern void _ZN6S164C24v122Ev();
extern void _ZN6S164C24v123Ev();
extern void _ZN6S164C24v124Ev();
extern void _ZN6S164C24v125Ev();
extern void _ZN6S164C24v126Ev();
extern void _ZN6S164C24v127Ev();
extern void _ZN6S164C24v128Ev();
extern void _ZN6S164C24v129Ev();
extern void _ZN6S164C24v130Ev();
extern void _ZN6S164C24v131Ev();
extern void _ZN6S164C24v132Ev();
extern void _ZN6S164C24v133Ev();
extern void _ZN6S164C24v134Ev();
extern void _ZN6S164C24v135Ev();
extern void _ZN6S164C24v136Ev();
extern void _ZN6S164C12v1Ev();
extern void _ZN6S164C12v2Ev();
extern void _ZN6S164C12v3Ev();
extern void _ZN6S164C12v4Ev();
extern void _ZN6S164C12v5Ev();
extern void _ZN6S164C12v6Ev();
extern void _ZN6S164C12v7Ev();
extern void _ZN6S164C12v8Ev();
extern void _ZN6S164C12v9Ev();
extern void _ZN6S164C13v10Ev();
extern void _ZN6S164C13v11Ev();
extern void _ZN6S164C13v12Ev();
extern void _ZN6S164C13v13Ev();
extern void _ZN6S164C13v14Ev();
extern void _ZN6S164C13v15Ev();
extern void _ZN6S164C13v16Ev();
extern void _ZN6S164C13v17Ev();
extern void _ZN6S164C13v18Ev();
extern void _ZN6S164C13v19Ev();
extern void _ZN6S164C13v20Ev();
extern void _ZN6S164C13v21Ev();
extern void _ZN6S164C13v22Ev();
extern void ABISELECT(_ZThn176_N6S164C1D1Ev,_ZThn120_N6S164C1D1Ev)();
extern void ABISELECT(_ZThn176_N6S164C1D0Ev,_ZThn120_N6S164C1D0Ev)();
extern void _ZN7S164C124v110Ev();
extern void _ZN7S164C124v111Ev();
extern void _ZN7S164C124v112Ev();
extern void _ZN7S164C124v113Ev();
extern void _ZN7S164C124v114Ev();
extern void _ZN7S164C124v115Ev();
extern void _ZN7S164C124v116Ev();
extern void _ZN7S164C124v117Ev();
extern void ABISELECT(_ZThn232_N6S164C1D1Ev,_ZThn156_N6S164C1D1Ev)();
extern void ABISELECT(_ZThn232_N6S164C1D0Ev,_ZThn156_N6S164C1D0Ev)();
extern void _ZN7S164C184v137Ev();
extern void _ZN7S164C184v138Ev();
extern void _ZN7S164C184v139Ev();
extern void _ZN7S164C184v140Ev();
static  VTBL_ENTRY vtc_S164C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S164C1[0]),
  (VTBL_ENTRY)&_ZN6S164C1D1Ev,
  (VTBL_ENTRY)&_ZN6S164C1D0Ev,
  (VTBL_ENTRY)&_ZN6S164C63v23Ev,
  (VTBL_ENTRY)&_ZN6S164C63v24Ev,
  (VTBL_ENTRY)&_ZN6S164C63v25Ev,
  (VTBL_ENTRY)&_ZN6S164C63v26Ev,
  (VTBL_ENTRY)&_ZN6S164C63v27Ev,
  (VTBL_ENTRY)&_ZN6S164C63v28Ev,
  (VTBL_ENTRY)&_ZN6S164C63v29Ev,
  (VTBL_ENTRY)&_ZN6S164C63v30Ev,
  (VTBL_ENTRY)&_ZN6S164C63v31Ev,
  (VTBL_ENTRY)&_ZN6S164C63v32Ev,
  (VTBL_ENTRY)&_ZN6S164C63v33Ev,
  (VTBL_ENTRY)&_ZN6S164C63v34Ev,
  (VTBL_ENTRY)&_ZN6S164C63v35Ev,
  (VTBL_ENTRY)&_ZN6S164C63v36Ev,
  (VTBL_ENTRY)&_ZN6S164C63v37Ev,
  (VTBL_ENTRY)&_ZN6S164C63v38Ev,
  (VTBL_ENTRY)&_ZN6S164C63v39Ev,
  (VTBL_ENTRY)&_ZN6S164C63v40Ev,
  (VTBL_ENTRY)&_ZN6S164C63v41Ev,
  (VTBL_ENTRY)&_ZN6S164C63v42Ev,
  (VTBL_ENTRY)&_ZN6S164C63v43Ev,
  (VTBL_ENTRY)&_ZN6S164C63v44Ev,
  (VTBL_ENTRY)&_ZN6S164C63v45Ev,
  (VTBL_ENTRY)&_ZN6S164C63v46Ev,
  (VTBL_ENTRY)&_ZN6S164C63v47Ev,
  (VTBL_ENTRY)&_ZN6S164C63v48Ev,
  (VTBL_ENTRY)&_ZN6S164C63v49Ev,
  (VTBL_ENTRY)&_ZN6S164C63v50Ev,
  (VTBL_ENTRY)&_ZN6S164C63v51Ev,
  (VTBL_ENTRY)&_ZN6S164C63v52Ev,
  (VTBL_ENTRY)&_ZN6S164C63v53Ev,
  (VTBL_ENTRY)&_ZN6S164C63v54Ev,
  (VTBL_ENTRY)&_ZN6S164C63v55Ev,
  (VTBL_ENTRY)&_ZN6S164C63v56Ev,
  (VTBL_ENTRY)&_ZN6S164C63v57Ev,
  (VTBL_ENTRY)&_ZN6S164C63v58Ev,
  (VTBL_ENTRY)&_ZN6S164C63v59Ev,
  (VTBL_ENTRY)&_ZN6S164C63v60Ev,
  (VTBL_ENTRY)&_ZN6S164C63v61Ev,
  (VTBL_ENTRY)&_ZN6S164C63v62Ev,
  (VTBL_ENTRY)&_ZN6S164C63v63Ev,
  (VTBL_ENTRY)&_ZN6S164C63v64Ev,
  (VTBL_ENTRY)&_ZN6S164C63v65Ev,
  (VTBL_ENTRY)&_ZN6S164C63v66Ev,
  (VTBL_ENTRY)&_ZN6S164C63v67Ev,
  (VTBL_ENTRY)&_ZN6S164C63v68Ev,
  (VTBL_ENTRY)&_ZN6S164C63v69Ev,
  (VTBL_ENTRY)&_ZN6S164C63v70Ev,
  (VTBL_ENTRY)&_ZN6S164C63v71Ev,
  (VTBL_ENTRY)&_ZN6S164C63v72Ev,
  (VTBL_ENTRY)&_ZN6S164C63v73Ev,
  (VTBL_ENTRY)&_ZN6S164C63v74Ev,
  (VTBL_ENTRY)&_ZN6S164C63v75Ev,
  (VTBL_ENTRY)&_ZN6S164C63v76Ev,
  (VTBL_ENTRY)&_ZN6S164C63v77Ev,
  (VTBL_ENTRY)&_ZN6S164C63v78Ev,
  (VTBL_ENTRY)&_ZN6S164C63v79Ev,
  (VTBL_ENTRY)&_ZN6S164C63v80Ev,
  (VTBL_ENTRY)&_ZN6S164C63v81Ev,
  (VTBL_ENTRY)&_ZN6S164C63v82Ev,
  (VTBL_ENTRY)&_ZN6S164C63v83Ev,
  (VTBL_ENTRY)&_ZN6S164C63v84Ev,
  (VTBL_ENTRY)&_ZN6S164C63v85Ev,
  (VTBL_ENTRY)&_ZN6S164C63v86Ev,
  (VTBL_ENTRY)&_ZN6S164C53v87Ev,
  (VTBL_ENTRY)&_ZN6S164C53v88Ev,
  (VTBL_ENTRY)&_ZN6S164C43v89Ev,
  (VTBL_ENTRY)&_ZN6S164C43v90Ev,
  (VTBL_ENTRY)&_ZN6S164C43v91Ev,
  (VTBL_ENTRY)&_ZN6S164C43v92Ev,
  (VTBL_ENTRY)&_ZN6S164C43v93Ev,
  (VTBL_ENTRY)&_ZN6S164C43v94Ev,
  (VTBL_ENTRY)&_ZN6S164C43v95Ev,
  (VTBL_ENTRY)&_ZN6S164C43v96Ev,
  (VTBL_ENTRY)&_ZN6S164C43v97Ev,
  (VTBL_ENTRY)&_ZN6S164C43v98Ev,
  (VTBL_ENTRY)&_ZN6S164C43v99Ev,
  (VTBL_ENTRY)&_ZN6S164C44v100Ev,
  (VTBL_ENTRY)&_ZN6S164C34v101Ev,
  (VTBL_ENTRY)&_ZN6S164C34v102Ev,
  (VTBL_ENTRY)&_ZN6S164C34v103Ev,
  (VTBL_ENTRY)&_ZN6S164C34v104Ev,
  (VTBL_ENTRY)&_ZN6S164C34v105Ev,
  (VTBL_ENTRY)&_ZN6S164C34v106Ev,
  (VTBL_ENTRY)&_ZN6S164C34v107Ev,
  (VTBL_ENTRY)&_ZN6S164C34v108Ev,
  (VTBL_ENTRY)&_ZN6S164C34v109Ev,
  (VTBL_ENTRY)&_ZN6S164C24v118Ev,
  (VTBL_ENTRY)&_ZN6S164C24v119Ev,
  (VTBL_ENTRY)&_ZN6S164C24v120Ev,
  (VTBL_ENTRY)&_ZN6S164C24v121Ev,
  (VTBL_ENTRY)&_ZN6S164C24v122Ev,
  (VTBL_ENTRY)&_ZN6S164C24v123Ev,
  (VTBL_ENTRY)&_ZN6S164C24v124Ev,
  (VTBL_ENTRY)&_ZN6S164C24v125Ev,
  (VTBL_ENTRY)&_ZN6S164C24v126Ev,
  (VTBL_ENTRY)&_ZN6S164C24v127Ev,
  (VTBL_ENTRY)&_ZN6S164C24v128Ev,
  (VTBL_ENTRY)&_ZN6S164C24v129Ev,
  (VTBL_ENTRY)&_ZN6S164C24v130Ev,
  (VTBL_ENTRY)&_ZN6S164C24v131Ev,
  (VTBL_ENTRY)&_ZN6S164C24v132Ev,
  (VTBL_ENTRY)&_ZN6S164C24v133Ev,
  (VTBL_ENTRY)&_ZN6S164C24v134Ev,
  (VTBL_ENTRY)&_ZN6S164C24v135Ev,
  (VTBL_ENTRY)&_ZN6S164C24v136Ev,
  (VTBL_ENTRY)&_ZN6S164C12v1Ev,
  (VTBL_ENTRY)&_ZN6S164C12v2Ev,
  (VTBL_ENTRY)&_ZN6S164C12v3Ev,
  (VTBL_ENTRY)&_ZN6S164C12v4Ev,
  (VTBL_ENTRY)&_ZN6S164C12v5Ev,
  (VTBL_ENTRY)&_ZN6S164C12v6Ev,
  (VTBL_ENTRY)&_ZN6S164C12v7Ev,
  (VTBL_ENTRY)&_ZN6S164C12v8Ev,
  (VTBL_ENTRY)&_ZN6S164C12v9Ev,
  (VTBL_ENTRY)&_ZN6S164C13v10Ev,
  (VTBL_ENTRY)&_ZN6S164C13v11Ev,
  (VTBL_ENTRY)&_ZN6S164C13v12Ev,
  (VTBL_ENTRY)&_ZN6S164C13v13Ev,
  (VTBL_ENTRY)&_ZN6S164C13v14Ev,
  (VTBL_ENTRY)&_ZN6S164C13v15Ev,
  (VTBL_ENTRY)&_ZN6S164C13v16Ev,
  (VTBL_ENTRY)&_ZN6S164C13v17Ev,
  (VTBL_ENTRY)&_ZN6S164C13v18Ev,
  (VTBL_ENTRY)&_ZN6S164C13v19Ev,
  (VTBL_ENTRY)&_ZN6S164C13v20Ev,
  (VTBL_ENTRY)&_ZN6S164C13v21Ev,
  (VTBL_ENTRY)&_ZN6S164C13v22Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S164C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S164C1D1Ev,_ZThn120_N6S164C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S164C1D0Ev,_ZThn120_N6S164C1D0Ev),
  (VTBL_ENTRY)&_ZN7S164C124v110Ev,
  (VTBL_ENTRY)&_ZN7S164C124v111Ev,
  (VTBL_ENTRY)&_ZN7S164C124v112Ev,
  (VTBL_ENTRY)&_ZN7S164C124v113Ev,
  (VTBL_ENTRY)&_ZN7S164C124v114Ev,
  (VTBL_ENTRY)&_ZN7S164C124v115Ev,
  (VTBL_ENTRY)&_ZN7S164C124v116Ev,
  (VTBL_ENTRY)&_ZN7S164C124v117Ev,
  ABISELECT(-232,-156),
  (VTBL_ENTRY)&(_ZTI6S164C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn232_N6S164C1D1Ev,_ZThn156_N6S164C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn232_N6S164C1D0Ev,_ZThn156_N6S164C1D0Ev),
  (VTBL_ENTRY)&_ZN7S164C184v137Ev,
  (VTBL_ENTRY)&_ZN7S164C184v138Ev,
  (VTBL_ENTRY)&_ZN7S164C184v139Ev,
  (VTBL_ENTRY)&_ZN7S164C184v140Ev,
};
extern VTBL_ENTRY _ZTI6S164C1[];
extern  VTBL_ENTRY _ZTV6S164C1[];
Class_Descriptor cd_S164C1 = {  "S164C1", // class name
  bases_S164C1, 7,
  &(vtc_S164C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,200), // object size
  NSPAIRA(_ZTI6S164C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S164C1),152, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C6  {
  int s223c6f0;
  __tsi64 s223c6f1;
  void *s223c6f2[4];
  int s223c6f3[2];
  void *s223c6f4;
  ::S3422C4_nt s223c6f5;
  void *s223c6f6[2];
  virtual  ~S223C6(); // _ZN6S223C6D1Ev
  virtual void  v4(); // _ZN6S223C62v4Ev
  virtual void  v5(); // _ZN6S223C62v5Ev
  virtual void  v6(); // _ZN6S223C62v6Ev
  virtual void  v7(); // _ZN6S223C62v7Ev
  virtual void  v8(); // _ZN6S223C62v8Ev
  virtual void  v9(); // _ZN6S223C62v9Ev
  virtual void  v10(); // _ZN6S223C63v10Ev
  virtual void  v11(); // _ZN6S223C63v11Ev
  virtual void  v12(); // _ZN6S223C63v12Ev
  virtual void  v13(); // _ZN6S223C63v13Ev
  virtual void  v14(); // _ZN6S223C63v14Ev
  virtual void  v15(); // _ZN6S223C63v15Ev
  virtual void  v16(); // _ZN6S223C63v16Ev
  virtual void  v17(); // _ZN6S223C63v17Ev
  virtual void  v18(); // _ZN6S223C63v18Ev
  virtual void  v19(); // _ZN6S223C63v19Ev
  virtual void  v20(); // _ZN6S223C63v20Ev
  virtual void  v21(); // _ZN6S223C63v21Ev
  virtual void  v22(); // _ZN6S223C63v22Ev
  virtual void  v23(); // _ZN6S223C63v23Ev
  virtual void  v24(); // _ZN6S223C63v24Ev
  virtual void  v25(); // _ZN6S223C63v25Ev
  virtual void  v26(); // _ZN6S223C63v26Ev
  virtual void  v27(); // _ZN6S223C63v27Ev
  virtual void  v28(); // _ZN6S223C63v28Ev
  virtual void  v29(); // _ZN6S223C63v29Ev
  virtual void  v30(); // _ZN6S223C63v30Ev
  virtual void  v31(); // _ZN6S223C63v31Ev
  virtual void  v32(); // _ZN6S223C63v32Ev
  virtual void  v33(); // _ZN6S223C63v33Ev
  virtual void  v34(); // _ZN6S223C63v34Ev
  virtual void  v35(); // _ZN6S223C63v35Ev
  virtual void  v36(); // _ZN6S223C63v36Ev
  virtual void  v37(); // _ZN6S223C63v37Ev
  virtual void  v38(); // _ZN6S223C63v38Ev
  virtual void  v39(); // _ZN6S223C63v39Ev
  virtual void  v40(); // _ZN6S223C63v40Ev
  virtual void  v41(); // _ZN6S223C63v41Ev
  virtual void  v42(); // _ZN6S223C63v42Ev
  virtual void  v43(); // _ZN6S223C63v43Ev
  virtual void  v44(); // _ZN6S223C63v44Ev
  virtual void  v45(); // _ZN6S223C63v45Ev
  virtual void  v46(); // _ZN6S223C63v46Ev
  virtual void  v47(); // _ZN6S223C63v47Ev
  virtual void  v48(); // _ZN6S223C63v48Ev
  virtual void  v49(); // _ZN6S223C63v49Ev
  virtual void  v50(); // _ZN6S223C63v50Ev
  virtual void  v51(); // _ZN6S223C63v51Ev
  virtual void  v52(); // _ZN6S223C63v52Ev
  virtual void  v53(); // _ZN6S223C63v53Ev
  virtual void  v54(); // _ZN6S223C63v54Ev
  virtual void  v55(); // _ZN6S223C63v55Ev
  virtual void  v56(); // _ZN6S223C63v56Ev
  virtual void  v57(); // _ZN6S223C63v57Ev
  virtual void  v58(); // _ZN6S223C63v58Ev
  virtual void  v59(); // _ZN6S223C63v59Ev
  virtual void  v60(); // _ZN6S223C63v60Ev
  virtual void  v61(); // _ZN6S223C63v61Ev
  virtual void  v62(); // _ZN6S223C63v62Ev
  virtual void  v63(); // _ZN6S223C63v63Ev
  virtual void  v64(); // _ZN6S223C63v64Ev
  virtual void  v65(); // _ZN6S223C63v65Ev
  virtual void  v66(); // _ZN6S223C63v66Ev
  virtual void  v67(); // _ZN6S223C63v67Ev
  S223C6(); // tgen
};
//SIG(-1 S223C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S223C6 ::~S223C6(){ note_dtor("S223C6", this);}
void  S223C6 ::v4(){vfunc_called(this, "_ZN6S223C62v4Ev");}
void  S223C6 ::v5(){vfunc_called(this, "_ZN6S223C62v5Ev");}
void  S223C6 ::v6(){vfunc_called(this, "_ZN6S223C62v6Ev");}
void  S223C6 ::v7(){vfunc_called(this, "_ZN6S223C62v7Ev");}
void  S223C6 ::v8(){vfunc_called(this, "_ZN6S223C62v8Ev");}
void  S223C6 ::v9(){vfunc_called(this, "_ZN6S223C62v9Ev");}
void  S223C6 ::v10(){vfunc_called(this, "_ZN6S223C63v10Ev");}
void  S223C6 ::v11(){vfunc_called(this, "_ZN6S223C63v11Ev");}
void  S223C6 ::v12(){vfunc_called(this, "_ZN6S223C63v12Ev");}
void  S223C6 ::v13(){vfunc_called(this, "_ZN6S223C63v13Ev");}
void  S223C6 ::v14(){vfunc_called(this, "_ZN6S223C63v14Ev");}
void  S223C6 ::v15(){vfunc_called(this, "_ZN6S223C63v15Ev");}
void  S223C6 ::v16(){vfunc_called(this, "_ZN6S223C63v16Ev");}
void  S223C6 ::v17(){vfunc_called(this, "_ZN6S223C63v17Ev");}
void  S223C6 ::v18(){vfunc_called(this, "_ZN6S223C63v18Ev");}
void  S223C6 ::v19(){vfunc_called(this, "_ZN6S223C63v19Ev");}
void  S223C6 ::v20(){vfunc_called(this, "_ZN6S223C63v20Ev");}
void  S223C6 ::v21(){vfunc_called(this, "_ZN6S223C63v21Ev");}
void  S223C6 ::v22(){vfunc_called(this, "_ZN6S223C63v22Ev");}
void  S223C6 ::v23(){vfunc_called(this, "_ZN6S223C63v23Ev");}
void  S223C6 ::v24(){vfunc_called(this, "_ZN6S223C63v24Ev");}
void  S223C6 ::v25(){vfunc_called(this, "_ZN6S223C63v25Ev");}
void  S223C6 ::v26(){vfunc_called(this, "_ZN6S223C63v26Ev");}
void  S223C6 ::v27(){vfunc_called(this, "_ZN6S223C63v27Ev");}
void  S223C6 ::v28(){vfunc_called(this, "_ZN6S223C63v28Ev");}
void  S223C6 ::v29(){vfunc_called(this, "_ZN6S223C63v29Ev");}
void  S223C6 ::v30(){vfunc_called(this, "_ZN6S223C63v30Ev");}
void  S223C6 ::v31(){vfunc_called(this, "_ZN6S223C63v31Ev");}
void  S223C6 ::v32(){vfunc_called(this, "_ZN6S223C63v32Ev");}
void  S223C6 ::v33(){vfunc_called(this, "_ZN6S223C63v33Ev");}
void  S223C6 ::v34(){vfunc_called(this, "_ZN6S223C63v34Ev");}
void  S223C6 ::v35(){vfunc_called(this, "_ZN6S223C63v35Ev");}
void  S223C6 ::v36(){vfunc_called(this, "_ZN6S223C63v36Ev");}
void  S223C6 ::v37(){vfunc_called(this, "_ZN6S223C63v37Ev");}
void  S223C6 ::v38(){vfunc_called(this, "_ZN6S223C63v38Ev");}
void  S223C6 ::v39(){vfunc_called(this, "_ZN6S223C63v39Ev");}
void  S223C6 ::v40(){vfunc_called(this, "_ZN6S223C63v40Ev");}
void  S223C6 ::v41(){vfunc_called(this, "_ZN6S223C63v41Ev");}
void  S223C6 ::v42(){vfunc_called(this, "_ZN6S223C63v42Ev");}
void  S223C6 ::v43(){vfunc_called(this, "_ZN6S223C63v43Ev");}
void  S223C6 ::v44(){vfunc_called(this, "_ZN6S223C63v44Ev");}
void  S223C6 ::v45(){vfunc_called(this, "_ZN6S223C63v45Ev");}
void  S223C6 ::v46(){vfunc_called(this, "_ZN6S223C63v46Ev");}
void  S223C6 ::v47(){vfunc_called(this, "_ZN6S223C63v47Ev");}
void  S223C6 ::v48(){vfunc_called(this, "_ZN6S223C63v48Ev");}
void  S223C6 ::v49(){vfunc_called(this, "_ZN6S223C63v49Ev");}
void  S223C6 ::v50(){vfunc_called(this, "_ZN6S223C63v50Ev");}
void  S223C6 ::v51(){vfunc_called(this, "_ZN6S223C63v51Ev");}
void  S223C6 ::v52(){vfunc_called(this, "_ZN6S223C63v52Ev");}
void  S223C6 ::v53(){vfunc_called(this, "_ZN6S223C63v53Ev");}
void  S223C6 ::v54(){vfunc_called(this, "_ZN6S223C63v54Ev");}
void  S223C6 ::v55(){vfunc_called(this, "_ZN6S223C63v55Ev");}
void  S223C6 ::v56(){vfunc_called(this, "_ZN6S223C63v56Ev");}
void  S223C6 ::v57(){vfunc_called(this, "_ZN6S223C63v57Ev");}
void  S223C6 ::v58(){vfunc_called(this, "_ZN6S223C63v58Ev");}
void  S223C6 ::v59(){vfunc_called(this, "_ZN6S223C63v59Ev");}
void  S223C6 ::v60(){vfunc_called(this, "_ZN6S223C63v60Ev");}
void  S223C6 ::v61(){vfunc_called(this, "_ZN6S223C63v61Ev");}
void  S223C6 ::v62(){vfunc_called(this, "_ZN6S223C63v62Ev");}
void  S223C6 ::v63(){vfunc_called(this, "_ZN6S223C63v63Ev");}
void  S223C6 ::v64(){vfunc_called(this, "_ZN6S223C63v64Ev");}
void  S223C6 ::v65(){vfunc_called(this, "_ZN6S223C63v65Ev");}
void  S223C6 ::v66(){vfunc_called(this, "_ZN6S223C63v66Ev");}
void  S223C6 ::v67(){vfunc_called(this, "_ZN6S223C63v67Ev");}
S223C6 ::S223C6(){ note_ctor("S223C6", this);} // tgen

static void Test_S223C6()
{
  extern Class_Descriptor cd_S223C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S223C6, buf);
    S223C6 *dp, &lv = *(dp=new (buf) S223C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S223C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C6)");
    check_field_offset(lv, s223c6f0, ABISELECT(8,4), "S223C6.s223c6f0");
    check_field_offset(lv, s223c6f1, ABISELECT(16,8), "S223C6.s223c6f1");
    check_field_offset(lv, s223c6f2, ABISELECT(24,16), "S223C6.s223c6f2");
    check_field_offset(lv, s223c6f3, ABISELECT(56,32), "S223C6.s223c6f3");
    check_field_offset(lv, s223c6f4, ABISELECT(64,40), "S223C6.s223c6f4");
    check_field_offset(lv, s223c6f5, ABISELECT(72,44), "S223C6.s223c6f5");
    check_field_offset(lv, s223c6f6, ABISELECT(80,52), "S223C6.s223c6f6");
    test_class_info(&lv, &cd_S223C6);
    dp->~S223C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C6(Test_S223C6, "S223C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S223C6C1Ev();
extern void _ZN6S223C6D1Ev();
Name_Map name_map_S223C6[] = {
  NSPAIR(_ZN6S223C6C1Ev),
  NSPAIR(_ZN6S223C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S223C6[];
extern void _ZN6S223C6D1Ev();
extern void _ZN6S223C6D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
static  VTBL_ENTRY vtc_S223C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C6[0]),
  (VTBL_ENTRY)&_ZN6S223C6D1Ev,
  (VTBL_ENTRY)&_ZN6S223C6D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
Class_Descriptor cd_S223C6 = {  "S223C6", // class name
  0,0,//no base classes
  &(vtc_S223C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S223C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S223C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C5  : S223C6 {
  virtual  ~S223C5(); // _ZN6S223C5D1Ev
  virtual void  v68(); // _ZN6S223C53v68Ev
  virtual void  v69(); // _ZN6S223C53v69Ev
  S223C5(); // tgen
};
//SIG(-1 S223C5) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S223C5 ::~S223C5(){ note_dtor("S223C5", this);}
void  S223C5 ::v68(){vfunc_called(this, "_ZN6S223C53v68Ev");}
void  S223C5 ::v69(){vfunc_called(this, "_ZN6S223C53v69Ev");}
S223C5 ::S223C5(){ note_ctor("S223C5", this);} // tgen

static void Test_S223C5()
{
  extern Class_Descriptor cd_S223C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S223C5, buf);
    S223C5 *dp, &lv = *(dp=new (buf) S223C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S223C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C5)");
    check_base_class_offset(lv, (S223C6*), 0, "S223C5");
    test_class_info(&lv, &cd_S223C5);
    dp->~S223C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C5(Test_S223C5, "S223C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S223C5C1Ev();
extern void _ZN6S223C5D1Ev();
Name_Map name_map_S223C5[] = {
  NSPAIR(_ZN6S223C5C1Ev),
  NSPAIR(_ZN6S223C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S223C6;
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
static Base_Class bases_S223C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S223C5[];
extern void _ZN6S223C5D1Ev();
extern void _ZN6S223C5D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
extern void _ZN6S223C53v68Ev();
extern void _ZN6S223C53v69Ev();
static  VTBL_ENTRY vtc_S223C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C5[0]),
  (VTBL_ENTRY)&_ZN6S223C5D1Ev,
  (VTBL_ENTRY)&_ZN6S223C5D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
  (VTBL_ENTRY)&_ZN6S223C53v68Ev,
  (VTBL_ENTRY)&_ZN6S223C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S223C5[];
extern  VTBL_ENTRY _ZTV6S223C5[];
Class_Descriptor cd_S223C5 = {  "S223C5", // class name
  bases_S223C5, 1,
  &(vtc_S223C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S223C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S223C5),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C4  : S223C5 {
  char s223c4f0;
  ::S3422C23 s223c4f1;
  ::S49C12_nt s223c4f2;
  virtual  ~S223C4(); // _ZN6S223C4D1Ev
  virtual void  v70(); // _ZN6S223C43v70Ev
  virtual void  v71(); // _ZN6S223C43v71Ev
  virtual void  v72(); // _ZN6S223C43v72Ev
  virtual void  v73(); // _ZN6S223C43v73Ev
  virtual void  v74(); // _ZN6S223C43v74Ev
  virtual void  v75(); // _ZN6S223C43v75Ev
  virtual void  v76(); // _ZN6S223C43v76Ev
  virtual void  v77(); // _ZN6S223C43v77Ev
  virtual void  v78(); // _ZN6S223C43v78Ev
  virtual void  v79(); // _ZN6S223C43v79Ev
  virtual void  v80(); // _ZN6S223C43v80Ev
  virtual void  v81(); // _ZN6S223C43v81Ev
  S223C4(); // tgen
};
//SIG(-1 S223C4) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S223C4 ::~S223C4(){ note_dtor("S223C4", this);}
void  S223C4 ::v70(){vfunc_called(this, "_ZN6S223C43v70Ev");}
void  S223C4 ::v71(){vfunc_called(this, "_ZN6S223C43v71Ev");}
void  S223C4 ::v72(){vfunc_called(this, "_ZN6S223C43v72Ev");}
void  S223C4 ::v73(){vfunc_called(this, "_ZN6S223C43v73Ev");}
void  S223C4 ::v74(){vfunc_called(this, "_ZN6S223C43v74Ev");}
void  S223C4 ::v75(){vfunc_called(this, "_ZN6S223C43v75Ev");}
void  S223C4 ::v76(){vfunc_called(this, "_ZN6S223C43v76Ev");}
void  S223C4 ::v77(){vfunc_called(this, "_ZN6S223C43v77Ev");}
void  S223C4 ::v78(){vfunc_called(this, "_ZN6S223C43v78Ev");}
void  S223C4 ::v79(){vfunc_called(this, "_ZN6S223C43v79Ev");}
void  S223C4 ::v80(){vfunc_called(this, "_ZN6S223C43v80Ev");}
void  S223C4 ::v81(){vfunc_called(this, "_ZN6S223C43v81Ev");}
S223C4 ::S223C4(){ note_ctor("S223C4", this);} // tgen

static void Test_S223C4()
{
  extern Class_Descriptor cd_S223C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S223C4, buf);
    S223C4 *dp, &lv = *(dp=new (buf) S223C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S223C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C4)");
    check_base_class_offset(lv, (S223C6*)(S223C5*), 0, "S223C4");
    check_base_class_offset(lv, (S223C5*), 0, "S223C4");
    check_field_offset(lv, s223c4f0, ABISELECT(96,60), "S223C4.s223c4f0");
    check_field_offset(lv, s223c4f1, ABISELECT(104,64), "S223C4.s223c4f1");
    check_field_offset(lv, s223c4f2, ABISELECT(120,76), "S223C4.s223c4f2");
    test_class_info(&lv, &cd_S223C4);
    dp->~S223C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C4(Test_S223C4, "S223C4", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S223C4C1Ev();
extern void _ZN6S223C4D1Ev();
Name_Map name_map_S223C4[] = {
  NSPAIR(_ZN6S223C4C1Ev),
  NSPAIR(_ZN6S223C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S223C6;
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
extern Class_Descriptor cd_S223C5;
extern VTBL_ENTRY _ZTI6S223C5[];
extern  VTBL_ENTRY _ZTV6S223C5[];
static Base_Class bases_S223C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S223C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S223C4[];
extern void _ZN6S223C4D1Ev();
extern void _ZN6S223C4D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
extern void _ZN6S223C53v68Ev();
extern void _ZN6S223C53v69Ev();
extern void _ZN6S223C43v70Ev();
extern void _ZN6S223C43v71Ev();
extern void _ZN6S223C43v72Ev();
extern void _ZN6S223C43v73Ev();
extern void _ZN6S223C43v74Ev();
extern void _ZN6S223C43v75Ev();
extern void _ZN6S223C43v76Ev();
extern void _ZN6S223C43v77Ev();
extern void _ZN6S223C43v78Ev();
extern void _ZN6S223C43v79Ev();
extern void _ZN6S223C43v80Ev();
extern void _ZN6S223C43v81Ev();
static  VTBL_ENTRY vtc_S223C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C4[0]),
  (VTBL_ENTRY)&_ZN6S223C4D1Ev,
  (VTBL_ENTRY)&_ZN6S223C4D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
  (VTBL_ENTRY)&_ZN6S223C53v68Ev,
  (VTBL_ENTRY)&_ZN6S223C53v69Ev,
  (VTBL_ENTRY)&_ZN6S223C43v70Ev,
  (VTBL_ENTRY)&_ZN6S223C43v71Ev,
  (VTBL_ENTRY)&_ZN6S223C43v72Ev,
  (VTBL_ENTRY)&_ZN6S223C43v73Ev,
  (VTBL_ENTRY)&_ZN6S223C43v74Ev,
  (VTBL_ENTRY)&_ZN6S223C43v75Ev,
  (VTBL_ENTRY)&_ZN6S223C43v76Ev,
  (VTBL_ENTRY)&_ZN6S223C43v77Ev,
  (VTBL_ENTRY)&_ZN6S223C43v78Ev,
  (VTBL_ENTRY)&_ZN6S223C43v79Ev,
  (VTBL_ENTRY)&_ZN6S223C43v80Ev,
  (VTBL_ENTRY)&_ZN6S223C43v81Ev,
};
extern VTBL_ENTRY _ZTI6S223C4[];
extern  VTBL_ENTRY _ZTV6S223C4[];
Class_Descriptor cd_S223C4 = {  "S223C4", // class name
  bases_S223C4, 2,
  &(vtc_S223C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S223C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S223C4),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C3  : S223C4 {
  ::S3422C4_nt s223c3f0;
  ::S3422C23 s223c3f1;
  ::S49C12_nt s223c3f2;
  virtual  ~S223C3(); // _ZN6S223C3D1Ev
  virtual void  v82(); // _ZN6S223C33v82Ev
  virtual void  v83(); // _ZN6S223C33v83Ev
  virtual void  v84(); // _ZN6S223C33v84Ev
  virtual void  v85(); // _ZN6S223C33v85Ev
  virtual void  v86(); // _ZN6S223C33v86Ev
  virtual void  v87(); // _ZN6S223C33v87Ev
  virtual void  v88(); // _ZN6S223C33v88Ev
  virtual void  v89(); // _ZN6S223C33v89Ev
  virtual void  v90(); // _ZN6S223C33v90Ev
  S223C3(); // tgen
};
//SIG(-1 S223C3) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S223C3 ::~S223C3(){ note_dtor("S223C3", this);}
void  S223C3 ::v82(){vfunc_called(this, "_ZN6S223C33v82Ev");}
void  S223C3 ::v83(){vfunc_called(this, "_ZN6S223C33v83Ev");}
void  S223C3 ::v84(){vfunc_called(this, "_ZN6S223C33v84Ev");}
void  S223C3 ::v85(){vfunc_called(this, "_ZN6S223C33v85Ev");}
void  S223C3 ::v86(){vfunc_called(this, "_ZN6S223C33v86Ev");}
void  S223C3 ::v87(){vfunc_called(this, "_ZN6S223C33v87Ev");}
void  S223C3 ::v88(){vfunc_called(this, "_ZN6S223C33v88Ev");}
void  S223C3 ::v89(){vfunc_called(this, "_ZN6S223C33v89Ev");}
void  S223C3 ::v90(){vfunc_called(this, "_ZN6S223C33v90Ev");}
S223C3 ::S223C3(){ note_ctor("S223C3", this);} // tgen

static void Test_S223C3()
{
  extern Class_Descriptor cd_S223C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S223C3, buf);
    S223C3 *dp, &lv = *(dp=new (buf) S223C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S223C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C3)");
    check_base_class_offset(lv, (S223C6*)(S223C5*)(S223C4*), 0, "S223C3");
    check_base_class_offset(lv, (S223C5*)(S223C4*), 0, "S223C3");
    check_base_class_offset(lv, (S223C4*), 0, "S223C3");
    check_field_offset(lv, s223c3f0, ABISELECT(136,88), "S223C3.s223c3f0");
    check_field_offset(lv, s223c3f1, ABISELECT(144,96), "S223C3.s223c3f1");
    check_field_offset(lv, s223c3f2, ABISELECT(160,108), "S223C3.s223c3f2");
    test_class_info(&lv, &cd_S223C3);
    dp->~S223C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C3(Test_S223C3, "S223C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S223C3C1Ev();
extern void _ZN6S223C3D1Ev();
Name_Map name_map_S223C3[] = {
  NSPAIR(_ZN6S223C3C1Ev),
  NSPAIR(_ZN6S223C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S223C6;
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
extern Class_Descriptor cd_S223C5;
extern VTBL_ENTRY _ZTI6S223C5[];
extern  VTBL_ENTRY _ZTV6S223C5[];
extern Class_Descriptor cd_S223C4;
extern VTBL_ENTRY _ZTI6S223C4[];
extern  VTBL_ENTRY _ZTV6S223C4[];
static Base_Class bases_S223C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S223C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S223C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S223C3[];
extern void _ZN6S223C3D1Ev();
extern void _ZN6S223C3D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
extern void _ZN6S223C53v68Ev();
extern void _ZN6S223C53v69Ev();
extern void _ZN6S223C43v70Ev();
extern void _ZN6S223C43v71Ev();
extern void _ZN6S223C43v72Ev();
extern void _ZN6S223C43v73Ev();
extern void _ZN6S223C43v74Ev();
extern void _ZN6S223C43v75Ev();
extern void _ZN6S223C43v76Ev();
extern void _ZN6S223C43v77Ev();
extern void _ZN6S223C43v78Ev();
extern void _ZN6S223C43v79Ev();
extern void _ZN6S223C43v80Ev();
extern void _ZN6S223C43v81Ev();
extern void _ZN6S223C33v82Ev();
extern void _ZN6S223C33v83Ev();
extern void _ZN6S223C33v84Ev();
extern void _ZN6S223C33v85Ev();
extern void _ZN6S223C33v86Ev();
extern void _ZN6S223C33v87Ev();
extern void _ZN6S223C33v88Ev();
extern void _ZN6S223C33v89Ev();
extern void _ZN6S223C33v90Ev();
static  VTBL_ENTRY vtc_S223C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C3[0]),
  (VTBL_ENTRY)&_ZN6S223C3D1Ev,
  (VTBL_ENTRY)&_ZN6S223C3D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
  (VTBL_ENTRY)&_ZN6S223C53v68Ev,
  (VTBL_ENTRY)&_ZN6S223C53v69Ev,
  (VTBL_ENTRY)&_ZN6S223C43v70Ev,
  (VTBL_ENTRY)&_ZN6S223C43v71Ev,
  (VTBL_ENTRY)&_ZN6S223C43v72Ev,
  (VTBL_ENTRY)&_ZN6S223C43v73Ev,
  (VTBL_ENTRY)&_ZN6S223C43v74Ev,
  (VTBL_ENTRY)&_ZN6S223C43v75Ev,
  (VTBL_ENTRY)&_ZN6S223C43v76Ev,
  (VTBL_ENTRY)&_ZN6S223C43v77Ev,
  (VTBL_ENTRY)&_ZN6S223C43v78Ev,
  (VTBL_ENTRY)&_ZN6S223C43v79Ev,
  (VTBL_ENTRY)&_ZN6S223C43v80Ev,
  (VTBL_ENTRY)&_ZN6S223C43v81Ev,
  (VTBL_ENTRY)&_ZN6S223C33v82Ev,
  (VTBL_ENTRY)&_ZN6S223C33v83Ev,
  (VTBL_ENTRY)&_ZN6S223C33v84Ev,
  (VTBL_ENTRY)&_ZN6S223C33v85Ev,
  (VTBL_ENTRY)&_ZN6S223C33v86Ev,
  (VTBL_ENTRY)&_ZN6S223C33v87Ev,
  (VTBL_ENTRY)&_ZN6S223C33v88Ev,
  (VTBL_ENTRY)&_ZN6S223C33v89Ev,
  (VTBL_ENTRY)&_ZN6S223C33v90Ev,
};
extern VTBL_ENTRY _ZTI6S223C3[];
extern  VTBL_ENTRY _ZTV6S223C3[];
Class_Descriptor cd_S223C3 = {  "S223C3", // class name
  bases_S223C3, 3,
  &(vtc_S223C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S223C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S223C3),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C21_nt  : S164C16_nt {
};
//SIG(-1 S223C21_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S223C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S164C16_nt;
static Base_Class bases_S223C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S164C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C28_nt  {
  ::S3422C24 s223c28f0;
  void *s223c28f1;
  int s223c28f2;
  void  mf223c28(); // _ZN10S223C28_nt8mf223c28Ev
};
//SIG(-1 S223C28_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S223C28_nt ::mf223c28(){}

//skip512 S223C28_nt

#else // __cplusplus

Class_Descriptor cd_S223C28_nt = {  "S223C28_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C27  : S223C28_nt {
};
//SIG(-1 S223C27) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



static void Test_S223C27()
{
  extern Class_Descriptor cd_S223C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S223C27, buf);
    S223C27 &lv = *(new (buf) S223C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S223C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C27)");
    check_base_class_offset(lv, (S223C28_nt*), 0, "S223C27");
    test_class_info(&lv, &cd_S223C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C27(Test_S223C27, "S223C27", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S223C28_nt;
static Base_Class bases_S223C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S223C27 = {  "S223C27", // class name
  bases_S223C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C2  : S223C3 {
  ::S3422C17 s223c2f0;
  ::S3422C11 s223c2f1;
  ::S3422C5_nt s223c2f2;
  ::S164C15_nt s223c2f3;
  ::S223C21_nt s223c2f4;
  ::S223C21_nt s223c2f5;
  ::S223C27 s223c2f6;
  ::S223C27 s223c2f7;
  virtual  ~S223C2(); // _ZN6S223C2D1Ev
  virtual void  v91(); // _ZN6S223C23v91Ev
  virtual void  v92(); // _ZN6S223C23v92Ev
  virtual void  v93(); // _ZN6S223C23v93Ev
  virtual void  v94(); // _ZN6S223C23v94Ev
  virtual void  v95(); // _ZN6S223C23v95Ev
  virtual void  v96(); // _ZN6S223C23v96Ev
  virtual void  v97(); // _ZN6S223C23v97Ev
  virtual void  v98(); // _ZN6S223C23v98Ev
  virtual void  v99(); // _ZN6S223C23v99Ev
  virtual void  v100(); // _ZN6S223C24v100Ev
  virtual void  v101(); // _ZN6S223C24v101Ev
  virtual void  v102(); // _ZN6S223C24v102Ev
  virtual void  v103(); // _ZN6S223C24v103Ev
  virtual void  v104(); // _ZN6S223C24v104Ev
  virtual void  v105(); // _ZN6S223C24v105Ev
  S223C2(); // tgen
};
//SIG(-1 S223C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v80 v81} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 FC6 FC7 FC10} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ m FC8 Fp Fi}} FC19{ BC18} FC19 FC20{ BC21{ m FC8 Fp Fi}} FC20}


 S223C2 ::~S223C2(){ note_dtor("S223C2", this);}
void  S223C2 ::v91(){vfunc_called(this, "_ZN6S223C23v91Ev");}
void  S223C2 ::v92(){vfunc_called(this, "_ZN6S223C23v92Ev");}
void  S223C2 ::v93(){vfunc_called(this, "_ZN6S223C23v93Ev");}
void  S223C2 ::v94(){vfunc_called(this, "_ZN6S223C23v94Ev");}
void  S223C2 ::v95(){vfunc_called(this, "_ZN6S223C23v95Ev");}
void  S223C2 ::v96(){vfunc_called(this, "_ZN6S223C23v96Ev");}
void  S223C2 ::v97(){vfunc_called(this, "_ZN6S223C23v97Ev");}
void  S223C2 ::v98(){vfunc_called(this, "_ZN6S223C23v98Ev");}
void  S223C2 ::v99(){vfunc_called(this, "_ZN6S223C23v99Ev");}
void  S223C2 ::v100(){vfunc_called(this, "_ZN6S223C24v100Ev");}
void  S223C2 ::v101(){vfunc_called(this, "_ZN6S223C24v101Ev");}
void  S223C2 ::v102(){vfunc_called(this, "_ZN6S223C24v102Ev");}
void  S223C2 ::v103(){vfunc_called(this, "_ZN6S223C24v103Ev");}
void  S223C2 ::v104(){vfunc_called(this, "_ZN6S223C24v104Ev");}
void  S223C2 ::v105(){vfunc_called(this, "_ZN6S223C24v105Ev");}
S223C2 ::S223C2(){ note_ctor("S223C2", this);} // tgen

static void Test_S223C2()
{
  extern Class_Descriptor cd_S223C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,65)];
    init_test(&cd_S223C2, buf);
    S223C2 *dp, &lv = *(dp=new (buf) S223C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,256), "sizeof(S223C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C2)");
    check_base_class_offset(lv, (S223C6*)(S223C5*)(S223C4*)(S223C3*), 0, "S223C2");
    check_base_class_offset(lv, (S223C5*)(S223C4*)(S223C3*), 0, "S223C2");
    check_base_class_offset(lv, (S223C4*)(S223C3*), 0, "S223C2");
    check_base_class_offset(lv, (S223C3*), 0, "S223C2");
    check_field_offset(lv, s223c2f0, ABISELECT(176,120), "S223C2.s223c2f0");
    check_field_offset(lv, s223c2f1, ABISELECT(192,132), "S223C2.s223c2f1");
    check_field_offset(lv, s223c2f2, ABISELECT(208,144), "S223C2.s223c2f2");
    check_field_offset(lv, s223c2f3, ABISELECT(224,156), "S223C2.s223c2f3");
    check_field_offset(lv, s223c2f4, ABISELECT(256,176), "S223C2.s223c2f4");
    check_field_offset(lv, s223c2f5, ABISELECT(288,196), "S223C2.s223c2f5");
    check_field_offset(lv, s223c2f6, ABISELECT(320,216), "S223C2.s223c2f6");
    check_field_offset(lv, s223c2f7, ABISELECT(352,236), "S223C2.s223c2f7");
    test_class_info(&lv, &cd_S223C2);
    dp->~S223C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C2(Test_S223C2, "S223C2", ABISELECT(384,256));

#else // __cplusplus

extern void _ZN6S223C2C1Ev();
extern void _ZN6S223C2D1Ev();
Name_Map name_map_S223C2[] = {
  NSPAIR(_ZN6S223C2C1Ev),
  NSPAIR(_ZN6S223C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S223C6;
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
extern Class_Descriptor cd_S223C5;
extern VTBL_ENTRY _ZTI6S223C5[];
extern  VTBL_ENTRY _ZTV6S223C5[];
extern Class_Descriptor cd_S223C4;
extern VTBL_ENTRY _ZTI6S223C4[];
extern  VTBL_ENTRY _ZTV6S223C4[];
extern Class_Descriptor cd_S223C3;
extern VTBL_ENTRY _ZTI6S223C3[];
extern  VTBL_ENTRY _ZTV6S223C3[];
static Base_Class bases_S223C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S223C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S223C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S223C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S223C2[];
extern void _ZN6S223C2D1Ev();
extern void _ZN6S223C2D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
extern void _ZN6S223C53v68Ev();
extern void _ZN6S223C53v69Ev();
extern void _ZN6S223C43v70Ev();
extern void _ZN6S223C43v71Ev();
extern void _ZN6S223C43v72Ev();
extern void _ZN6S223C43v73Ev();
extern void _ZN6S223C43v74Ev();
extern void _ZN6S223C43v75Ev();
extern void _ZN6S223C43v76Ev();
extern void _ZN6S223C43v77Ev();
extern void _ZN6S223C43v78Ev();
extern void _ZN6S223C43v79Ev();
extern void _ZN6S223C43v80Ev();
extern void _ZN6S223C43v81Ev();
extern void _ZN6S223C33v82Ev();
extern void _ZN6S223C33v83Ev();
extern void _ZN6S223C33v84Ev();
extern void _ZN6S223C33v85Ev();
extern void _ZN6S223C33v86Ev();
extern void _ZN6S223C33v87Ev();
extern void _ZN6S223C33v88Ev();
extern void _ZN6S223C33v89Ev();
extern void _ZN6S223C33v90Ev();
extern void _ZN6S223C23v91Ev();
extern void _ZN6S223C23v92Ev();
extern void _ZN6S223C23v93Ev();
extern void _ZN6S223C23v94Ev();
extern void _ZN6S223C23v95Ev();
extern void _ZN6S223C23v96Ev();
extern void _ZN6S223C23v97Ev();
extern void _ZN6S223C23v98Ev();
extern void _ZN6S223C23v99Ev();
extern void _ZN6S223C24v100Ev();
extern void _ZN6S223C24v101Ev();
extern void _ZN6S223C24v102Ev();
extern void _ZN6S223C24v103Ev();
extern void _ZN6S223C24v104Ev();
extern void _ZN6S223C24v105Ev();
static  VTBL_ENTRY vtc_S223C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C2[0]),
  (VTBL_ENTRY)&_ZN6S223C2D1Ev,
  (VTBL_ENTRY)&_ZN6S223C2D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
  (VTBL_ENTRY)&_ZN6S223C53v68Ev,
  (VTBL_ENTRY)&_ZN6S223C53v69Ev,
  (VTBL_ENTRY)&_ZN6S223C43v70Ev,
  (VTBL_ENTRY)&_ZN6S223C43v71Ev,
  (VTBL_ENTRY)&_ZN6S223C43v72Ev,
  (VTBL_ENTRY)&_ZN6S223C43v73Ev,
  (VTBL_ENTRY)&_ZN6S223C43v74Ev,
  (VTBL_ENTRY)&_ZN6S223C43v75Ev,
  (VTBL_ENTRY)&_ZN6S223C43v76Ev,
  (VTBL_ENTRY)&_ZN6S223C43v77Ev,
  (VTBL_ENTRY)&_ZN6S223C43v78Ev,
  (VTBL_ENTRY)&_ZN6S223C43v79Ev,
  (VTBL_ENTRY)&_ZN6S223C43v80Ev,
  (VTBL_ENTRY)&_ZN6S223C43v81Ev,
  (VTBL_ENTRY)&_ZN6S223C33v82Ev,
  (VTBL_ENTRY)&_ZN6S223C33v83Ev,
  (VTBL_ENTRY)&_ZN6S223C33v84Ev,
  (VTBL_ENTRY)&_ZN6S223C33v85Ev,
  (VTBL_ENTRY)&_ZN6S223C33v86Ev,
  (VTBL_ENTRY)&_ZN6S223C33v87Ev,
  (VTBL_ENTRY)&_ZN6S223C33v88Ev,
  (VTBL_ENTRY)&_ZN6S223C33v89Ev,
  (VTBL_ENTRY)&_ZN6S223C33v90Ev,
  (VTBL_ENTRY)&_ZN6S223C23v91Ev,
  (VTBL_ENTRY)&_ZN6S223C23v92Ev,
  (VTBL_ENTRY)&_ZN6S223C23v93Ev,
  (VTBL_ENTRY)&_ZN6S223C23v94Ev,
  (VTBL_ENTRY)&_ZN6S223C23v95Ev,
  (VTBL_ENTRY)&_ZN6S223C23v96Ev,
  (VTBL_ENTRY)&_ZN6S223C23v97Ev,
  (VTBL_ENTRY)&_ZN6S223C23v98Ev,
  (VTBL_ENTRY)&_ZN6S223C23v99Ev,
  (VTBL_ENTRY)&_ZN6S223C24v100Ev,
  (VTBL_ENTRY)&_ZN6S223C24v101Ev,
  (VTBL_ENTRY)&_ZN6S223C24v102Ev,
  (VTBL_ENTRY)&_ZN6S223C24v103Ev,
  (VTBL_ENTRY)&_ZN6S223C24v104Ev,
  (VTBL_ENTRY)&_ZN6S223C24v105Ev,
};
extern VTBL_ENTRY _ZTI6S223C2[];
extern  VTBL_ENTRY _ZTV6S223C2[];
Class_Descriptor cd_S223C2 = {  "S223C2", // class name
  bases_S223C2, 4,
  &(vtc_S223C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,256), // object size
  NSPAIRA(_ZTI6S223C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S223C2),106, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C34  {
  ::S3422C18 s223c34f0;
  void *s223c34f1;
  int s223c34f2;
  void  mf223c34(); // _ZN7S223C348mf223c34Ev
};
//SIG(-1 S223C34) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S223C34 ::mf223c34(){}

static void Test_S223C34()
{
  {
    init_simple_test("S223C34");
    S223C34 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S223C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C34)");
    check_field_offset(lv, s223c34f0, 0, "S223C34.s223c34f0");
    check_field_offset(lv, s223c34f1, ABISELECT(16,12), "S223C34.s223c34f1");
    check_field_offset(lv, s223c34f2, ABISELECT(24,16), "S223C34.s223c34f2");
  }
}
static Arrange_To_Call_Me vS223C34(Test_S223C34, "S223C34", ABISELECT(32,20));

#else // __cplusplus

Class_Descriptor cd_S223C34 = {  "S223C34", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C33  : S223C34 {
};
//SIG(-1 S223C33) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



static void Test_S223C33()
{
  extern Class_Descriptor cd_S223C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S223C33, buf);
    S223C33 &lv = *(new (buf) S223C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S223C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C33)");
    check_base_class_offset(lv, (S223C34*), 0, "S223C33");
    test_class_info(&lv, &cd_S223C33);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C33(Test_S223C33, "S223C33", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S223C34;
static Base_Class bases_S223C33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S223C33 = {  "S223C33", // class name
  bases_S223C33, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S223C1  : S223C2 {
  ::S223C33 s223c1f0;
  virtual  ~S223C1(); // _ZN6S223C1D1Ev
  virtual void  v1(); // _ZN6S223C12v1Ev
  virtual void  v2(); // _ZN6S223C12v2Ev
  virtual void  v3(); // _ZN6S223C12v3Ev
  S223C1(); // tgen
};
//SIG(1 S223C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 FC7 FC8 FC11} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ m FC9 Fp Fi}} FC20{ BC19} FC20 FC21{ BC22{ m FC9 Fp Fi}} FC21} vd v1 v2 v3 FC23{ BC24{ m FC13 Fp Fi}}}


 S223C1 ::~S223C1(){ note_dtor("S223C1", this);}
void  S223C1 ::v1(){vfunc_called(this, "_ZN6S223C12v1Ev");}
void  S223C1 ::v2(){vfunc_called(this, "_ZN6S223C12v2Ev");}
void  S223C1 ::v3(){vfunc_called(this, "_ZN6S223C12v3Ev");}
S223C1 ::S223C1(){ note_ctor("S223C1", this);} // tgen

static void Test_S223C1()
{
  extern Class_Descriptor cd_S223C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,70)];
    init_test(&cd_S223C1, buf);
    S223C1 *dp, &lv = *(dp=new (buf) S223C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,276), "sizeof(S223C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S223C1)");
    check_base_class_offset(lv, (S223C6*)(S223C5*)(S223C4*)(S223C3*)(S223C2*), 0, "S223C1");
    check_base_class_offset(lv, (S223C5*)(S223C4*)(S223C3*)(S223C2*), 0, "S223C1");
    check_base_class_offset(lv, (S223C4*)(S223C3*)(S223C2*), 0, "S223C1");
    check_base_class_offset(lv, (S223C3*)(S223C2*), 0, "S223C1");
    check_base_class_offset(lv, (S223C2*), 0, "S223C1");
    check_field_offset(lv, s223c1f0, ABISELECT(384,256), "S223C1.s223c1f0");
    test_class_info(&lv, &cd_S223C1);
    dp->~S223C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS223C1(Test_S223C1, "S223C1", ABISELECT(416,276));

#else // __cplusplus

extern void _ZN6S223C1C1Ev();
extern void _ZN6S223C1D1Ev();
Name_Map name_map_S223C1[] = {
  NSPAIR(_ZN6S223C1C1Ev),
  NSPAIR(_ZN6S223C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S223C6;
extern VTBL_ENTRY _ZTI6S223C6[];
extern  VTBL_ENTRY _ZTV6S223C6[];
extern Class_Descriptor cd_S223C5;
extern VTBL_ENTRY _ZTI6S223C5[];
extern  VTBL_ENTRY _ZTV6S223C5[];
extern Class_Descriptor cd_S223C4;
extern VTBL_ENTRY _ZTI6S223C4[];
extern  VTBL_ENTRY _ZTV6S223C4[];
extern Class_Descriptor cd_S223C3;
extern VTBL_ENTRY _ZTI6S223C3[];
extern  VTBL_ENTRY _ZTV6S223C3[];
extern Class_Descriptor cd_S223C2;
extern VTBL_ENTRY _ZTI6S223C2[];
extern  VTBL_ENTRY _ZTV6S223C2[];
static Base_Class bases_S223C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S223C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S223C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S223C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S223C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S223C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S223C1[];
extern void _ZN6S223C1D1Ev();
extern void _ZN6S223C1D0Ev();
extern void _ZN6S223C62v4Ev();
extern void _ZN6S223C62v5Ev();
extern void _ZN6S223C62v6Ev();
extern void _ZN6S223C62v7Ev();
extern void _ZN6S223C62v8Ev();
extern void _ZN6S223C62v9Ev();
extern void _ZN6S223C63v10Ev();
extern void _ZN6S223C63v11Ev();
extern void _ZN6S223C63v12Ev();
extern void _ZN6S223C63v13Ev();
extern void _ZN6S223C63v14Ev();
extern void _ZN6S223C63v15Ev();
extern void _ZN6S223C63v16Ev();
extern void _ZN6S223C63v17Ev();
extern void _ZN6S223C63v18Ev();
extern void _ZN6S223C63v19Ev();
extern void _ZN6S223C63v20Ev();
extern void _ZN6S223C63v21Ev();
extern void _ZN6S223C63v22Ev();
extern void _ZN6S223C63v23Ev();
extern void _ZN6S223C63v24Ev();
extern void _ZN6S223C63v25Ev();
extern void _ZN6S223C63v26Ev();
extern void _ZN6S223C63v27Ev();
extern void _ZN6S223C63v28Ev();
extern void _ZN6S223C63v29Ev();
extern void _ZN6S223C63v30Ev();
extern void _ZN6S223C63v31Ev();
extern void _ZN6S223C63v32Ev();
extern void _ZN6S223C63v33Ev();
extern void _ZN6S223C63v34Ev();
extern void _ZN6S223C63v35Ev();
extern void _ZN6S223C63v36Ev();
extern void _ZN6S223C63v37Ev();
extern void _ZN6S223C63v38Ev();
extern void _ZN6S223C63v39Ev();
extern void _ZN6S223C63v40Ev();
extern void _ZN6S223C63v41Ev();
extern void _ZN6S223C63v42Ev();
extern void _ZN6S223C63v43Ev();
extern void _ZN6S223C63v44Ev();
extern void _ZN6S223C63v45Ev();
extern void _ZN6S223C63v46Ev();
extern void _ZN6S223C63v47Ev();
extern void _ZN6S223C63v48Ev();
extern void _ZN6S223C63v49Ev();
extern void _ZN6S223C63v50Ev();
extern void _ZN6S223C63v51Ev();
extern void _ZN6S223C63v52Ev();
extern void _ZN6S223C63v53Ev();
extern void _ZN6S223C63v54Ev();
extern void _ZN6S223C63v55Ev();
extern void _ZN6S223C63v56Ev();
extern void _ZN6S223C63v57Ev();
extern void _ZN6S223C63v58Ev();
extern void _ZN6S223C63v59Ev();
extern void _ZN6S223C63v60Ev();
extern void _ZN6S223C63v61Ev();
extern void _ZN6S223C63v62Ev();
extern void _ZN6S223C63v63Ev();
extern void _ZN6S223C63v64Ev();
extern void _ZN6S223C63v65Ev();
extern void _ZN6S223C63v66Ev();
extern void _ZN6S223C63v67Ev();
extern void _ZN6S223C53v68Ev();
extern void _ZN6S223C53v69Ev();
extern void _ZN6S223C43v70Ev();
extern void _ZN6S223C43v71Ev();
extern void _ZN6S223C43v72Ev();
extern void _ZN6S223C43v73Ev();
extern void _ZN6S223C43v74Ev();
extern void _ZN6S223C43v75Ev();
extern void _ZN6S223C43v76Ev();
extern void _ZN6S223C43v77Ev();
extern void _ZN6S223C43v78Ev();
extern void _ZN6S223C43v79Ev();
extern void _ZN6S223C43v80Ev();
extern void _ZN6S223C43v81Ev();
extern void _ZN6S223C33v82Ev();
extern void _ZN6S223C33v83Ev();
extern void _ZN6S223C33v84Ev();
extern void _ZN6S223C33v85Ev();
extern void _ZN6S223C33v86Ev();
extern void _ZN6S223C33v87Ev();
extern void _ZN6S223C33v88Ev();
extern void _ZN6S223C33v89Ev();
extern void _ZN6S223C33v90Ev();
extern void _ZN6S223C23v91Ev();
extern void _ZN6S223C23v92Ev();
extern void _ZN6S223C23v93Ev();
extern void _ZN6S223C23v94Ev();
extern void _ZN6S223C23v95Ev();
extern void _ZN6S223C23v96Ev();
extern void _ZN6S223C23v97Ev();
extern void _ZN6S223C23v98Ev();
extern void _ZN6S223C23v99Ev();
extern void _ZN6S223C24v100Ev();
extern void _ZN6S223C24v101Ev();
extern void _ZN6S223C24v102Ev();
extern void _ZN6S223C24v103Ev();
extern void _ZN6S223C24v104Ev();
extern void _ZN6S223C24v105Ev();
extern void _ZN6S223C12v1Ev();
extern void _ZN6S223C12v2Ev();
extern void _ZN6S223C12v3Ev();
static  VTBL_ENTRY vtc_S223C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S223C1[0]),
  (VTBL_ENTRY)&_ZN6S223C1D1Ev,
  (VTBL_ENTRY)&_ZN6S223C1D0Ev,
  (VTBL_ENTRY)&_ZN6S223C62v4Ev,
  (VTBL_ENTRY)&_ZN6S223C62v5Ev,
  (VTBL_ENTRY)&_ZN6S223C62v6Ev,
  (VTBL_ENTRY)&_ZN6S223C62v7Ev,
  (VTBL_ENTRY)&_ZN6S223C62v8Ev,
  (VTBL_ENTRY)&_ZN6S223C62v9Ev,
  (VTBL_ENTRY)&_ZN6S223C63v10Ev,
  (VTBL_ENTRY)&_ZN6S223C63v11Ev,
  (VTBL_ENTRY)&_ZN6S223C63v12Ev,
  (VTBL_ENTRY)&_ZN6S223C63v13Ev,
  (VTBL_ENTRY)&_ZN6S223C63v14Ev,
  (VTBL_ENTRY)&_ZN6S223C63v15Ev,
  (VTBL_ENTRY)&_ZN6S223C63v16Ev,
  (VTBL_ENTRY)&_ZN6S223C63v17Ev,
  (VTBL_ENTRY)&_ZN6S223C63v18Ev,
  (VTBL_ENTRY)&_ZN6S223C63v19Ev,
  (VTBL_ENTRY)&_ZN6S223C63v20Ev,
  (VTBL_ENTRY)&_ZN6S223C63v21Ev,
  (VTBL_ENTRY)&_ZN6S223C63v22Ev,
  (VTBL_ENTRY)&_ZN6S223C63v23Ev,
  (VTBL_ENTRY)&_ZN6S223C63v24Ev,
  (VTBL_ENTRY)&_ZN6S223C63v25Ev,
  (VTBL_ENTRY)&_ZN6S223C63v26Ev,
  (VTBL_ENTRY)&_ZN6S223C63v27Ev,
  (VTBL_ENTRY)&_ZN6S223C63v28Ev,
  (VTBL_ENTRY)&_ZN6S223C63v29Ev,
  (VTBL_ENTRY)&_ZN6S223C63v30Ev,
  (VTBL_ENTRY)&_ZN6S223C63v31Ev,
  (VTBL_ENTRY)&_ZN6S223C63v32Ev,
  (VTBL_ENTRY)&_ZN6S223C63v33Ev,
  (VTBL_ENTRY)&_ZN6S223C63v34Ev,
  (VTBL_ENTRY)&_ZN6S223C63v35Ev,
  (VTBL_ENTRY)&_ZN6S223C63v36Ev,
  (VTBL_ENTRY)&_ZN6S223C63v37Ev,
  (VTBL_ENTRY)&_ZN6S223C63v38Ev,
  (VTBL_ENTRY)&_ZN6S223C63v39Ev,
  (VTBL_ENTRY)&_ZN6S223C63v40Ev,
  (VTBL_ENTRY)&_ZN6S223C63v41Ev,
  (VTBL_ENTRY)&_ZN6S223C63v42Ev,
  (VTBL_ENTRY)&_ZN6S223C63v43Ev,
  (VTBL_ENTRY)&_ZN6S223C63v44Ev,
  (VTBL_ENTRY)&_ZN6S223C63v45Ev,
  (VTBL_ENTRY)&_ZN6S223C63v46Ev,
  (VTBL_ENTRY)&_ZN6S223C63v47Ev,
  (VTBL_ENTRY)&_ZN6S223C63v48Ev,
  (VTBL_ENTRY)&_ZN6S223C63v49Ev,
  (VTBL_ENTRY)&_ZN6S223C63v50Ev,
  (VTBL_ENTRY)&_ZN6S223C63v51Ev,
  (VTBL_ENTRY)&_ZN6S223C63v52Ev,
  (VTBL_ENTRY)&_ZN6S223C63v53Ev,
  (VTBL_ENTRY)&_ZN6S223C63v54Ev,
  (VTBL_ENTRY)&_ZN6S223C63v55Ev,
  (VTBL_ENTRY)&_ZN6S223C63v56Ev,
  (VTBL_ENTRY)&_ZN6S223C63v57Ev,
  (VTBL_ENTRY)&_ZN6S223C63v58Ev,
  (VTBL_ENTRY)&_ZN6S223C63v59Ev,
  (VTBL_ENTRY)&_ZN6S223C63v60Ev,
  (VTBL_ENTRY)&_ZN6S223C63v61Ev,
  (VTBL_ENTRY)&_ZN6S223C63v62Ev,
  (VTBL_ENTRY)&_ZN6S223C63v63Ev,
  (VTBL_ENTRY)&_ZN6S223C63v64Ev,
  (VTBL_ENTRY)&_ZN6S223C63v65Ev,
  (VTBL_ENTRY)&_ZN6S223C63v66Ev,
  (VTBL_ENTRY)&_ZN6S223C63v67Ev,
  (VTBL_ENTRY)&_ZN6S223C53v68Ev,
  (VTBL_ENTRY)&_ZN6S223C53v69Ev,
  (VTBL_ENTRY)&_ZN6S223C43v70Ev,
  (VTBL_ENTRY)&_ZN6S223C43v71Ev,
  (VTBL_ENTRY)&_ZN6S223C43v72Ev,
  (VTBL_ENTRY)&_ZN6S223C43v73Ev,
  (VTBL_ENTRY)&_ZN6S223C43v74Ev,
  (VTBL_ENTRY)&_ZN6S223C43v75Ev,
  (VTBL_ENTRY)&_ZN6S223C43v76Ev,
  (VTBL_ENTRY)&_ZN6S223C43v77Ev,
  (VTBL_ENTRY)&_ZN6S223C43v78Ev,
  (VTBL_ENTRY)&_ZN6S223C43v79Ev,
  (VTBL_ENTRY)&_ZN6S223C43v80Ev,
  (VTBL_ENTRY)&_ZN6S223C43v81Ev,
  (VTBL_ENTRY)&_ZN6S223C33v82Ev,
  (VTBL_ENTRY)&_ZN6S223C33v83Ev,
  (VTBL_ENTRY)&_ZN6S223C33v84Ev,
  (VTBL_ENTRY)&_ZN6S223C33v85Ev,
  (VTBL_ENTRY)&_ZN6S223C33v86Ev,
  (VTBL_ENTRY)&_ZN6S223C33v87Ev,
  (VTBL_ENTRY)&_ZN6S223C33v88Ev,
  (VTBL_ENTRY)&_ZN6S223C33v89Ev,
  (VTBL_ENTRY)&_ZN6S223C33v90Ev,
  (VTBL_ENTRY)&_ZN6S223C23v91Ev,
  (VTBL_ENTRY)&_ZN6S223C23v92Ev,
  (VTBL_ENTRY)&_ZN6S223C23v93Ev,
  (VTBL_ENTRY)&_ZN6S223C23v94Ev,
  (VTBL_ENTRY)&_ZN6S223C23v95Ev,
  (VTBL_ENTRY)&_ZN6S223C23v96Ev,
  (VTBL_ENTRY)&_ZN6S223C23v97Ev,
  (VTBL_ENTRY)&_ZN6S223C23v98Ev,
  (VTBL_ENTRY)&_ZN6S223C23v99Ev,
  (VTBL_ENTRY)&_ZN6S223C24v100Ev,
  (VTBL_ENTRY)&_ZN6S223C24v101Ev,
  (VTBL_ENTRY)&_ZN6S223C24v102Ev,
  (VTBL_ENTRY)&_ZN6S223C24v103Ev,
  (VTBL_ENTRY)&_ZN6S223C24v104Ev,
  (VTBL_ENTRY)&_ZN6S223C24v105Ev,
  (VTBL_ENTRY)&_ZN6S223C12v1Ev,
  (VTBL_ENTRY)&_ZN6S223C12v2Ev,
  (VTBL_ENTRY)&_ZN6S223C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S223C1[];
extern  VTBL_ENTRY _ZTV6S223C1[];
Class_Descriptor cd_S223C1 = {  "S223C1", // class name
  bases_S223C1, 5,
  &(vtc_S223C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,276), // object size
  NSPAIRA(_ZTI6S223C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S223C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C6  {
  int s158c6f0;
  __tsi64 s158c6f1;
  void *s158c6f2[4];
  int s158c6f3[2];
  void *s158c6f4;
  ::S3422C4_nt s158c6f5;
  void *s158c6f6[2];
  virtual  ~S158C6(); // _ZN6S158C6D1Ev
  virtual void  v16(); // _ZN6S158C63v16Ev
  virtual void  v17(); // _ZN6S158C63v17Ev
  virtual void  v18(); // _ZN6S158C63v18Ev
  virtual void  v19(); // _ZN6S158C63v19Ev
  virtual void  v20(); // _ZN6S158C63v20Ev
  virtual void  v21(); // _ZN6S158C63v21Ev
  virtual void  v22(); // _ZN6S158C63v22Ev
  virtual void  v23(); // _ZN6S158C63v23Ev
  virtual void  v24(); // _ZN6S158C63v24Ev
  virtual void  v25(); // _ZN6S158C63v25Ev
  virtual void  v26(); // _ZN6S158C63v26Ev
  virtual void  v27(); // _ZN6S158C63v27Ev
  virtual void  v28(); // _ZN6S158C63v28Ev
  virtual void  v29(); // _ZN6S158C63v29Ev
  virtual void  v30(); // _ZN6S158C63v30Ev
  virtual void  v31(); // _ZN6S158C63v31Ev
  virtual void  v32(); // _ZN6S158C63v32Ev
  virtual void  v33(); // _ZN6S158C63v33Ev
  virtual void  v34(); // _ZN6S158C63v34Ev
  virtual void  v35(); // _ZN6S158C63v35Ev
  virtual void  v36(); // _ZN6S158C63v36Ev
  virtual void  v37(); // _ZN6S158C63v37Ev
  virtual void  v38(); // _ZN6S158C63v38Ev
  virtual void  v39(); // _ZN6S158C63v39Ev
  virtual void  v40(); // _ZN6S158C63v40Ev
  virtual void  v41(); // _ZN6S158C63v41Ev
  virtual void  v42(); // _ZN6S158C63v42Ev
  virtual void  v43(); // _ZN6S158C63v43Ev
  virtual void  v44(); // _ZN6S158C63v44Ev
  virtual void  v45(); // _ZN6S158C63v45Ev
  virtual void  v46(); // _ZN6S158C63v46Ev
  virtual void  v47(); // _ZN6S158C63v47Ev
  virtual void  v48(); // _ZN6S158C63v48Ev
  virtual void  v49(); // _ZN6S158C63v49Ev
  virtual void  v50(); // _ZN6S158C63v50Ev
  virtual void  v51(); // _ZN6S158C63v51Ev
  virtual void  v52(); // _ZN6S158C63v52Ev
  virtual void  v53(); // _ZN6S158C63v53Ev
  virtual void  v54(); // _ZN6S158C63v54Ev
  virtual void  v55(); // _ZN6S158C63v55Ev
  virtual void  v56(); // _ZN6S158C63v56Ev
  virtual void  v57(); // _ZN6S158C63v57Ev
  virtual void  v58(); // _ZN6S158C63v58Ev
  virtual void  v59(); // _ZN6S158C63v59Ev
  virtual void  v60(); // _ZN6S158C63v60Ev
  virtual void  v61(); // _ZN6S158C63v61Ev
  virtual void  v62(); // _ZN6S158C63v62Ev
  virtual void  v63(); // _ZN6S158C63v63Ev
  virtual void  v64(); // _ZN6S158C63v64Ev
  virtual void  v65(); // _ZN6S158C63v65Ev
  virtual void  v66(); // _ZN6S158C63v66Ev
  virtual void  v67(); // _ZN6S158C63v67Ev
  virtual void  v68(); // _ZN6S158C63v68Ev
  virtual void  v69(); // _ZN6S158C63v69Ev
  virtual void  v70(); // _ZN6S158C63v70Ev
  virtual void  v71(); // _ZN6S158C63v71Ev
  virtual void  v72(); // _ZN6S158C63v72Ev
  virtual void  v73(); // _ZN6S158C63v73Ev
  virtual void  v74(); // _ZN6S158C63v74Ev
  virtual void  v75(); // _ZN6S158C63v75Ev
  virtual void  v76(); // _ZN6S158C63v76Ev
  virtual void  v77(); // _ZN6S158C63v77Ev
  virtual void  v78(); // _ZN6S158C63v78Ev
  virtual void  v79(); // _ZN6S158C63v79Ev
  S158C6(); // tgen
};
//SIG(-1 S158C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S158C6 ::~S158C6(){ note_dtor("S158C6", this);}
void  S158C6 ::v16(){vfunc_called(this, "_ZN6S158C63v16Ev");}
void  S158C6 ::v17(){vfunc_called(this, "_ZN6S158C63v17Ev");}
void  S158C6 ::v18(){vfunc_called(this, "_ZN6S158C63v18Ev");}
void  S158C6 ::v19(){vfunc_called(this, "_ZN6S158C63v19Ev");}
void  S158C6 ::v20(){vfunc_called(this, "_ZN6S158C63v20Ev");}
void  S158C6 ::v21(){vfunc_called(this, "_ZN6S158C63v21Ev");}
void  S158C6 ::v22(){vfunc_called(this, "_ZN6S158C63v22Ev");}
void  S158C6 ::v23(){vfunc_called(this, "_ZN6S158C63v23Ev");}
void  S158C6 ::v24(){vfunc_called(this, "_ZN6S158C63v24Ev");}
void  S158C6 ::v25(){vfunc_called(this, "_ZN6S158C63v25Ev");}
void  S158C6 ::v26(){vfunc_called(this, "_ZN6S158C63v26Ev");}
void  S158C6 ::v27(){vfunc_called(this, "_ZN6S158C63v27Ev");}
void  S158C6 ::v28(){vfunc_called(this, "_ZN6S158C63v28Ev");}
void  S158C6 ::v29(){vfunc_called(this, "_ZN6S158C63v29Ev");}
void  S158C6 ::v30(){vfunc_called(this, "_ZN6S158C63v30Ev");}
void  S158C6 ::v31(){vfunc_called(this, "_ZN6S158C63v31Ev");}
void  S158C6 ::v32(){vfunc_called(this, "_ZN6S158C63v32Ev");}
void  S158C6 ::v33(){vfunc_called(this, "_ZN6S158C63v33Ev");}
void  S158C6 ::v34(){vfunc_called(this, "_ZN6S158C63v34Ev");}
void  S158C6 ::v35(){vfunc_called(this, "_ZN6S158C63v35Ev");}
void  S158C6 ::v36(){vfunc_called(this, "_ZN6S158C63v36Ev");}
void  S158C6 ::v37(){vfunc_called(this, "_ZN6S158C63v37Ev");}
void  S158C6 ::v38(){vfunc_called(this, "_ZN6S158C63v38Ev");}
void  S158C6 ::v39(){vfunc_called(this, "_ZN6S158C63v39Ev");}
void  S158C6 ::v40(){vfunc_called(this, "_ZN6S158C63v40Ev");}
void  S158C6 ::v41(){vfunc_called(this, "_ZN6S158C63v41Ev");}
void  S158C6 ::v42(){vfunc_called(this, "_ZN6S158C63v42Ev");}
void  S158C6 ::v43(){vfunc_called(this, "_ZN6S158C63v43Ev");}
void  S158C6 ::v44(){vfunc_called(this, "_ZN6S158C63v44Ev");}
void  S158C6 ::v45(){vfunc_called(this, "_ZN6S158C63v45Ev");}
void  S158C6 ::v46(){vfunc_called(this, "_ZN6S158C63v46Ev");}
void  S158C6 ::v47(){vfunc_called(this, "_ZN6S158C63v47Ev");}
void  S158C6 ::v48(){vfunc_called(this, "_ZN6S158C63v48Ev");}
void  S158C6 ::v49(){vfunc_called(this, "_ZN6S158C63v49Ev");}
void  S158C6 ::v50(){vfunc_called(this, "_ZN6S158C63v50Ev");}
void  S158C6 ::v51(){vfunc_called(this, "_ZN6S158C63v51Ev");}
void  S158C6 ::v52(){vfunc_called(this, "_ZN6S158C63v52Ev");}
void  S158C6 ::v53(){vfunc_called(this, "_ZN6S158C63v53Ev");}
void  S158C6 ::v54(){vfunc_called(this, "_ZN6S158C63v54Ev");}
void  S158C6 ::v55(){vfunc_called(this, "_ZN6S158C63v55Ev");}
void  S158C6 ::v56(){vfunc_called(this, "_ZN6S158C63v56Ev");}
void  S158C6 ::v57(){vfunc_called(this, "_ZN6S158C63v57Ev");}
void  S158C6 ::v58(){vfunc_called(this, "_ZN6S158C63v58Ev");}
void  S158C6 ::v59(){vfunc_called(this, "_ZN6S158C63v59Ev");}
void  S158C6 ::v60(){vfunc_called(this, "_ZN6S158C63v60Ev");}
void  S158C6 ::v61(){vfunc_called(this, "_ZN6S158C63v61Ev");}
void  S158C6 ::v62(){vfunc_called(this, "_ZN6S158C63v62Ev");}
void  S158C6 ::v63(){vfunc_called(this, "_ZN6S158C63v63Ev");}
void  S158C6 ::v64(){vfunc_called(this, "_ZN6S158C63v64Ev");}
void  S158C6 ::v65(){vfunc_called(this, "_ZN6S158C63v65Ev");}
void  S158C6 ::v66(){vfunc_called(this, "_ZN6S158C63v66Ev");}
void  S158C6 ::v67(){vfunc_called(this, "_ZN6S158C63v67Ev");}
void  S158C6 ::v68(){vfunc_called(this, "_ZN6S158C63v68Ev");}
void  S158C6 ::v69(){vfunc_called(this, "_ZN6S158C63v69Ev");}
void  S158C6 ::v70(){vfunc_called(this, "_ZN6S158C63v70Ev");}
void  S158C6 ::v71(){vfunc_called(this, "_ZN6S158C63v71Ev");}
void  S158C6 ::v72(){vfunc_called(this, "_ZN6S158C63v72Ev");}
void  S158C6 ::v73(){vfunc_called(this, "_ZN6S158C63v73Ev");}
void  S158C6 ::v74(){vfunc_called(this, "_ZN6S158C63v74Ev");}
void  S158C6 ::v75(){vfunc_called(this, "_ZN6S158C63v75Ev");}
void  S158C6 ::v76(){vfunc_called(this, "_ZN6S158C63v76Ev");}
void  S158C6 ::v77(){vfunc_called(this, "_ZN6S158C63v77Ev");}
void  S158C6 ::v78(){vfunc_called(this, "_ZN6S158C63v78Ev");}
void  S158C6 ::v79(){vfunc_called(this, "_ZN6S158C63v79Ev");}
S158C6 ::S158C6(){ note_ctor("S158C6", this);} // tgen

static void Test_S158C6()
{
  extern Class_Descriptor cd_S158C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S158C6, buf);
    S158C6 *dp, &lv = *(dp=new (buf) S158C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S158C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C6)");
    check_field_offset(lv, s158c6f0, ABISELECT(8,4), "S158C6.s158c6f0");
    check_field_offset(lv, s158c6f1, ABISELECT(16,8), "S158C6.s158c6f1");
    check_field_offset(lv, s158c6f2, ABISELECT(24,16), "S158C6.s158c6f2");
    check_field_offset(lv, s158c6f3, ABISELECT(56,32), "S158C6.s158c6f3");
    check_field_offset(lv, s158c6f4, ABISELECT(64,40), "S158C6.s158c6f4");
    check_field_offset(lv, s158c6f5, ABISELECT(72,44), "S158C6.s158c6f5");
    check_field_offset(lv, s158c6f6, ABISELECT(80,52), "S158C6.s158c6f6");
    test_class_info(&lv, &cd_S158C6);
    dp->~S158C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C6(Test_S158C6, "S158C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S158C6C1Ev();
extern void _ZN6S158C6D1Ev();
Name_Map name_map_S158C6[] = {
  NSPAIR(_ZN6S158C6C1Ev),
  NSPAIR(_ZN6S158C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S158C6[];
extern void _ZN6S158C6D1Ev();
extern void _ZN6S158C6D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
static  VTBL_ENTRY vtc_S158C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C6[0]),
  (VTBL_ENTRY)&_ZN6S158C6D1Ev,
  (VTBL_ENTRY)&_ZN6S158C6D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
};
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
Class_Descriptor cd_S158C6 = {  "S158C6", // class name
  0,0,//no base classes
  &(vtc_S158C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S158C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S158C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C5  : S158C6 {
  virtual  ~S158C5(); // _ZN6S158C5D1Ev
  virtual void  v80(); // _ZN6S158C53v80Ev
  virtual void  v81(); // _ZN6S158C53v81Ev
  S158C5(); // tgen
};
//SIG(-1 S158C5) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S158C5 ::~S158C5(){ note_dtor("S158C5", this);}
void  S158C5 ::v80(){vfunc_called(this, "_ZN6S158C53v80Ev");}
void  S158C5 ::v81(){vfunc_called(this, "_ZN6S158C53v81Ev");}
S158C5 ::S158C5(){ note_ctor("S158C5", this);} // tgen

static void Test_S158C5()
{
  extern Class_Descriptor cd_S158C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S158C5, buf);
    S158C5 *dp, &lv = *(dp=new (buf) S158C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S158C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C5)");
    check_base_class_offset(lv, (S158C6*), 0, "S158C5");
    test_class_info(&lv, &cd_S158C5);
    dp->~S158C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C5(Test_S158C5, "S158C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S158C5C1Ev();
extern void _ZN6S158C5D1Ev();
Name_Map name_map_S158C5[] = {
  NSPAIR(_ZN6S158C5C1Ev),
  NSPAIR(_ZN6S158C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S158C6;
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
static Base_Class bases_S158C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S158C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S158C5[];
extern void _ZN6S158C5D1Ev();
extern void _ZN6S158C5D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
extern void _ZN6S158C53v80Ev();
extern void _ZN6S158C53v81Ev();
static  VTBL_ENTRY vtc_S158C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C5[0]),
  (VTBL_ENTRY)&_ZN6S158C5D1Ev,
  (VTBL_ENTRY)&_ZN6S158C5D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
  (VTBL_ENTRY)&_ZN6S158C53v80Ev,
  (VTBL_ENTRY)&_ZN6S158C53v81Ev,
};
extern VTBL_ENTRY _ZTI6S158C5[];
extern  VTBL_ENTRY _ZTV6S158C5[];
Class_Descriptor cd_S158C5 = {  "S158C5", // class name
  bases_S158C5, 1,
  &(vtc_S158C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S158C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S158C5),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C4  : S158C5 {
  char s158c4f0;
  ::S3422C23 s158c4f1;
  ::S49C12_nt s158c4f2;
  virtual  ~S158C4(); // _ZN6S158C4D1Ev
  virtual void  v82(); // _ZN6S158C43v82Ev
  virtual void  v83(); // _ZN6S158C43v83Ev
  virtual void  v84(); // _ZN6S158C43v84Ev
  virtual void  v85(); // _ZN6S158C43v85Ev
  virtual void  v86(); // _ZN6S158C43v86Ev
  virtual void  v87(); // _ZN6S158C43v87Ev
  virtual void  v88(); // _ZN6S158C43v88Ev
  virtual void  v89(); // _ZN6S158C43v89Ev
  virtual void  v90(); // _ZN6S158C43v90Ev
  virtual void  v91(); // _ZN6S158C43v91Ev
  virtual void  v92(); // _ZN6S158C43v92Ev
  virtual void  v93(); // _ZN6S158C43v93Ev
  S158C4(); // tgen
};
//SIG(-1 S158C4) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S158C4 ::~S158C4(){ note_dtor("S158C4", this);}
void  S158C4 ::v82(){vfunc_called(this, "_ZN6S158C43v82Ev");}
void  S158C4 ::v83(){vfunc_called(this, "_ZN6S158C43v83Ev");}
void  S158C4 ::v84(){vfunc_called(this, "_ZN6S158C43v84Ev");}
void  S158C4 ::v85(){vfunc_called(this, "_ZN6S158C43v85Ev");}
void  S158C4 ::v86(){vfunc_called(this, "_ZN6S158C43v86Ev");}
void  S158C4 ::v87(){vfunc_called(this, "_ZN6S158C43v87Ev");}
void  S158C4 ::v88(){vfunc_called(this, "_ZN6S158C43v88Ev");}
void  S158C4 ::v89(){vfunc_called(this, "_ZN6S158C43v89Ev");}
void  S158C4 ::v90(){vfunc_called(this, "_ZN6S158C43v90Ev");}
void  S158C4 ::v91(){vfunc_called(this, "_ZN6S158C43v91Ev");}
void  S158C4 ::v92(){vfunc_called(this, "_ZN6S158C43v92Ev");}
void  S158C4 ::v93(){vfunc_called(this, "_ZN6S158C43v93Ev");}
S158C4 ::S158C4(){ note_ctor("S158C4", this);} // tgen

static void Test_S158C4()
{
  extern Class_Descriptor cd_S158C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S158C4, buf);
    S158C4 *dp, &lv = *(dp=new (buf) S158C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S158C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C4)");
    check_base_class_offset(lv, (S158C6*)(S158C5*), 0, "S158C4");
    check_base_class_offset(lv, (S158C5*), 0, "S158C4");
    check_field_offset(lv, s158c4f0, ABISELECT(96,60), "S158C4.s158c4f0");
    check_field_offset(lv, s158c4f1, ABISELECT(104,64), "S158C4.s158c4f1");
    check_field_offset(lv, s158c4f2, ABISELECT(120,76), "S158C4.s158c4f2");
    test_class_info(&lv, &cd_S158C4);
    dp->~S158C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C4(Test_S158C4, "S158C4", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S158C4C1Ev();
extern void _ZN6S158C4D1Ev();
Name_Map name_map_S158C4[] = {
  NSPAIR(_ZN6S158C4C1Ev),
  NSPAIR(_ZN6S158C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S158C6;
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
extern Class_Descriptor cd_S158C5;
extern VTBL_ENTRY _ZTI6S158C5[];
extern  VTBL_ENTRY _ZTV6S158C5[];
static Base_Class bases_S158C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S158C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S158C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S158C4[];
extern void _ZN6S158C4D1Ev();
extern void _ZN6S158C4D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
extern void _ZN6S158C53v80Ev();
extern void _ZN6S158C53v81Ev();
extern void _ZN6S158C43v82Ev();
extern void _ZN6S158C43v83Ev();
extern void _ZN6S158C43v84Ev();
extern void _ZN6S158C43v85Ev();
extern void _ZN6S158C43v86Ev();
extern void _ZN6S158C43v87Ev();
extern void _ZN6S158C43v88Ev();
extern void _ZN6S158C43v89Ev();
extern void _ZN6S158C43v90Ev();
extern void _ZN6S158C43v91Ev();
extern void _ZN6S158C43v92Ev();
extern void _ZN6S158C43v93Ev();
static  VTBL_ENTRY vtc_S158C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C4[0]),
  (VTBL_ENTRY)&_ZN6S158C4D1Ev,
  (VTBL_ENTRY)&_ZN6S158C4D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
  (VTBL_ENTRY)&_ZN6S158C53v80Ev,
  (VTBL_ENTRY)&_ZN6S158C53v81Ev,
  (VTBL_ENTRY)&_ZN6S158C43v82Ev,
  (VTBL_ENTRY)&_ZN6S158C43v83Ev,
  (VTBL_ENTRY)&_ZN6S158C43v84Ev,
  (VTBL_ENTRY)&_ZN6S158C43v85Ev,
  (VTBL_ENTRY)&_ZN6S158C43v86Ev,
  (VTBL_ENTRY)&_ZN6S158C43v87Ev,
  (VTBL_ENTRY)&_ZN6S158C43v88Ev,
  (VTBL_ENTRY)&_ZN6S158C43v89Ev,
  (VTBL_ENTRY)&_ZN6S158C43v90Ev,
  (VTBL_ENTRY)&_ZN6S158C43v91Ev,
  (VTBL_ENTRY)&_ZN6S158C43v92Ev,
  (VTBL_ENTRY)&_ZN6S158C43v93Ev,
};
extern VTBL_ENTRY _ZTI6S158C4[];
extern  VTBL_ENTRY _ZTV6S158C4[];
Class_Descriptor cd_S158C4 = {  "S158C4", // class name
  bases_S158C4, 2,
  &(vtc_S158C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S158C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S158C4),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C3  : S158C4 {
  ::S3422C4_nt s158c3f0;
  ::S3422C23 s158c3f1;
  ::S49C12_nt s158c3f2;
  virtual  ~S158C3(); // _ZN6S158C3D1Ev
  virtual void  v94(); // _ZN6S158C33v94Ev
  virtual void  v95(); // _ZN6S158C33v95Ev
  virtual void  v96(); // _ZN6S158C33v96Ev
  virtual void  v97(); // _ZN6S158C33v97Ev
  virtual void  v98(); // _ZN6S158C33v98Ev
  virtual void  v99(); // _ZN6S158C33v99Ev
  virtual void  v100(); // _ZN6S158C34v100Ev
  virtual void  v101(); // _ZN6S158C34v101Ev
  virtual void  v102(); // _ZN6S158C34v102Ev
  S158C3(); // tgen
};
//SIG(-1 S158C3) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S158C3 ::~S158C3(){ note_dtor("S158C3", this);}
void  S158C3 ::v94(){vfunc_called(this, "_ZN6S158C33v94Ev");}
void  S158C3 ::v95(){vfunc_called(this, "_ZN6S158C33v95Ev");}
void  S158C3 ::v96(){vfunc_called(this, "_ZN6S158C33v96Ev");}
void  S158C3 ::v97(){vfunc_called(this, "_ZN6S158C33v97Ev");}
void  S158C3 ::v98(){vfunc_called(this, "_ZN6S158C33v98Ev");}
void  S158C3 ::v99(){vfunc_called(this, "_ZN6S158C33v99Ev");}
void  S158C3 ::v100(){vfunc_called(this, "_ZN6S158C34v100Ev");}
void  S158C3 ::v101(){vfunc_called(this, "_ZN6S158C34v101Ev");}
void  S158C3 ::v102(){vfunc_called(this, "_ZN6S158C34v102Ev");}
S158C3 ::S158C3(){ note_ctor("S158C3", this);} // tgen

static void Test_S158C3()
{
  extern Class_Descriptor cd_S158C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S158C3, buf);
    S158C3 *dp, &lv = *(dp=new (buf) S158C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S158C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C3)");
    check_base_class_offset(lv, (S158C6*)(S158C5*)(S158C4*), 0, "S158C3");
    check_base_class_offset(lv, (S158C5*)(S158C4*), 0, "S158C3");
    check_base_class_offset(lv, (S158C4*), 0, "S158C3");
    check_field_offset(lv, s158c3f0, ABISELECT(136,88), "S158C3.s158c3f0");
    check_field_offset(lv, s158c3f1, ABISELECT(144,96), "S158C3.s158c3f1");
    check_field_offset(lv, s158c3f2, ABISELECT(160,108), "S158C3.s158c3f2");
    test_class_info(&lv, &cd_S158C3);
    dp->~S158C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C3(Test_S158C3, "S158C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S158C3C1Ev();
extern void _ZN6S158C3D1Ev();
Name_Map name_map_S158C3[] = {
  NSPAIR(_ZN6S158C3C1Ev),
  NSPAIR(_ZN6S158C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S158C6;
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
extern Class_Descriptor cd_S158C5;
extern VTBL_ENTRY _ZTI6S158C5[];
extern  VTBL_ENTRY _ZTV6S158C5[];
extern Class_Descriptor cd_S158C4;
extern VTBL_ENTRY _ZTI6S158C4[];
extern  VTBL_ENTRY _ZTV6S158C4[];
static Base_Class bases_S158C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S158C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S158C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S158C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S158C3[];
extern void _ZN6S158C3D1Ev();
extern void _ZN6S158C3D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
extern void _ZN6S158C53v80Ev();
extern void _ZN6S158C53v81Ev();
extern void _ZN6S158C43v82Ev();
extern void _ZN6S158C43v83Ev();
extern void _ZN6S158C43v84Ev();
extern void _ZN6S158C43v85Ev();
extern void _ZN6S158C43v86Ev();
extern void _ZN6S158C43v87Ev();
extern void _ZN6S158C43v88Ev();
extern void _ZN6S158C43v89Ev();
extern void _ZN6S158C43v90Ev();
extern void _ZN6S158C43v91Ev();
extern void _ZN6S158C43v92Ev();
extern void _ZN6S158C43v93Ev();
extern void _ZN6S158C33v94Ev();
extern void _ZN6S158C33v95Ev();
extern void _ZN6S158C33v96Ev();
extern void _ZN6S158C33v97Ev();
extern void _ZN6S158C33v98Ev();
extern void _ZN6S158C33v99Ev();
extern void _ZN6S158C34v100Ev();
extern void _ZN6S158C34v101Ev();
extern void _ZN6S158C34v102Ev();
static  VTBL_ENTRY vtc_S158C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C3[0]),
  (VTBL_ENTRY)&_ZN6S158C3D1Ev,
  (VTBL_ENTRY)&_ZN6S158C3D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
  (VTBL_ENTRY)&_ZN6S158C53v80Ev,
  (VTBL_ENTRY)&_ZN6S158C53v81Ev,
  (VTBL_ENTRY)&_ZN6S158C43v82Ev,
  (VTBL_ENTRY)&_ZN6S158C43v83Ev,
  (VTBL_ENTRY)&_ZN6S158C43v84Ev,
  (VTBL_ENTRY)&_ZN6S158C43v85Ev,
  (VTBL_ENTRY)&_ZN6S158C43v86Ev,
  (VTBL_ENTRY)&_ZN6S158C43v87Ev,
  (VTBL_ENTRY)&_ZN6S158C43v88Ev,
  (VTBL_ENTRY)&_ZN6S158C43v89Ev,
  (VTBL_ENTRY)&_ZN6S158C43v90Ev,
  (VTBL_ENTRY)&_ZN6S158C43v91Ev,
  (VTBL_ENTRY)&_ZN6S158C43v92Ev,
  (VTBL_ENTRY)&_ZN6S158C43v93Ev,
  (VTBL_ENTRY)&_ZN6S158C33v94Ev,
  (VTBL_ENTRY)&_ZN6S158C33v95Ev,
  (VTBL_ENTRY)&_ZN6S158C33v96Ev,
  (VTBL_ENTRY)&_ZN6S158C33v97Ev,
  (VTBL_ENTRY)&_ZN6S158C33v98Ev,
  (VTBL_ENTRY)&_ZN6S158C33v99Ev,
  (VTBL_ENTRY)&_ZN6S158C34v100Ev,
  (VTBL_ENTRY)&_ZN6S158C34v101Ev,
  (VTBL_ENTRY)&_ZN6S158C34v102Ev,
};
extern VTBL_ENTRY _ZTI6S158C3[];
extern  VTBL_ENTRY _ZTV6S158C3[];
Class_Descriptor cd_S158C3 = {  "S158C3", // class name
  bases_S158C3, 3,
  &(vtc_S158C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S158C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S158C3),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C12  {
  virtual  ~S158C12(); // _ZN7S158C12D1Ev
  virtual void  v103(); // _ZN7S158C124v103Ev
  virtual void  v104(); // _ZN7S158C124v104Ev
  virtual void  v105(); // _ZN7S158C124v105Ev
  virtual void  v106(); // _ZN7S158C124v106Ev
  virtual void  v107(); // _ZN7S158C124v107Ev
  virtual void  v108(); // _ZN7S158C124v108Ev
  virtual void  v109(); // _ZN7S158C124v109Ev
  virtual void  v110(); // _ZN7S158C124v110Ev
  S158C12(); // tgen
};
//SIG(-1 S158C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S158C12 ::~S158C12(){ note_dtor("S158C12", this);}
void  S158C12 ::v103(){vfunc_called(this, "_ZN7S158C124v103Ev");}
void  S158C12 ::v104(){vfunc_called(this, "_ZN7S158C124v104Ev");}
void  S158C12 ::v105(){vfunc_called(this, "_ZN7S158C124v105Ev");}
void  S158C12 ::v106(){vfunc_called(this, "_ZN7S158C124v106Ev");}
void  S158C12 ::v107(){vfunc_called(this, "_ZN7S158C124v107Ev");}
void  S158C12 ::v108(){vfunc_called(this, "_ZN7S158C124v108Ev");}
void  S158C12 ::v109(){vfunc_called(this, "_ZN7S158C124v109Ev");}
void  S158C12 ::v110(){vfunc_called(this, "_ZN7S158C124v110Ev");}
S158C12 ::S158C12(){ note_ctor("S158C12", this);} // tgen

static void Test_S158C12()
{
  extern Class_Descriptor cd_S158C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S158C12, buf);
    S158C12 *dp, &lv = *(dp=new (buf) S158C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S158C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C12)");
    test_class_info(&lv, &cd_S158C12);
    dp->~S158C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C12(Test_S158C12, "S158C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S158C12C1Ev();
extern void _ZN7S158C12D1Ev();
Name_Map name_map_S158C12[] = {
  NSPAIR(_ZN7S158C12C1Ev),
  NSPAIR(_ZN7S158C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S158C12[];
extern void _ZN7S158C12D1Ev();
extern void _ZN7S158C12D0Ev();
extern void _ZN7S158C124v103Ev();
extern void _ZN7S158C124v104Ev();
extern void _ZN7S158C124v105Ev();
extern void _ZN7S158C124v106Ev();
extern void _ZN7S158C124v107Ev();
extern void _ZN7S158C124v108Ev();
extern void _ZN7S158C124v109Ev();
extern void _ZN7S158C124v110Ev();
static  VTBL_ENTRY vtc_S158C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S158C12[0]),
  (VTBL_ENTRY)&_ZN7S158C12D1Ev,
  (VTBL_ENTRY)&_ZN7S158C12D0Ev,
  (VTBL_ENTRY)&_ZN7S158C124v103Ev,
  (VTBL_ENTRY)&_ZN7S158C124v104Ev,
  (VTBL_ENTRY)&_ZN7S158C124v105Ev,
  (VTBL_ENTRY)&_ZN7S158C124v106Ev,
  (VTBL_ENTRY)&_ZN7S158C124v107Ev,
  (VTBL_ENTRY)&_ZN7S158C124v108Ev,
  (VTBL_ENTRY)&_ZN7S158C124v109Ev,
  (VTBL_ENTRY)&_ZN7S158C124v110Ev,
};
extern VTBL_ENTRY _ZTI7S158C12[];
extern  VTBL_ENTRY _ZTV7S158C12[];
Class_Descriptor cd_S158C12 = {  "S158C12", // class name
  0,0,//no base classes
  &(vtc_S158C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S158C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S158C12),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C2  : S158C3 , S158C12 {
  ::S3422C17 s158c2f0;
  ::S223C33 s158c2f1;
  virtual  ~S158C2(); // _ZN6S158C2D1Ev
  virtual void  v111(); // _ZN6S158C24v111Ev
  virtual void  v112(); // _ZN6S158C24v112Ev
  virtual void  v113(); // _ZN6S158C24v113Ev
  virtual void  v114(); // _ZN6S158C24v114Ev
  virtual void  v115(); // _ZN6S158C24v115Ev
  virtual void  v116(); // _ZN6S158C24v116Ev
  virtual void  v117(); // _ZN6S158C24v117Ev
  virtual void  v118(); // _ZN6S158C24v118Ev
  virtual void  v119(); // _ZN6S158C24v119Ev
  virtual void  v120(); // _ZN6S158C24v120Ev
  virtual void  v121(); // _ZN6S158C24v121Ev
  virtual void  v122(); // _ZN6S158C24v122Ev
  virtual void  v123(); // _ZN6S158C24v123Ev
  virtual void  v124(); // _ZN6S158C24v124Ev
  virtual void  v125(); // _ZN6S158C24v125Ev
  virtual void  v126(); // _ZN6S158C24v126Ev
  virtual void  v127(); // _ZN6S158C24v127Ev
  virtual void  v128(); // _ZN6S158C24v128Ev
  virtual void  v129(); // _ZN6S158C24v129Ev
  S158C2(); // tgen
};
//SIG(-1 S158C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v84 v85} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 FC6 FC7 FC10} BC11{ vd v107 v108 v109 v110 v111 v112 v113 v114} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC12{ BC13{ BC9}} FC14{ BC15{ m FC13 Fp Fi}}}


 S158C2 ::~S158C2(){ note_dtor("S158C2", this);}
void  S158C2 ::v111(){vfunc_called(this, "_ZN6S158C24v111Ev");}
void  S158C2 ::v112(){vfunc_called(this, "_ZN6S158C24v112Ev");}
void  S158C2 ::v113(){vfunc_called(this, "_ZN6S158C24v113Ev");}
void  S158C2 ::v114(){vfunc_called(this, "_ZN6S158C24v114Ev");}
void  S158C2 ::v115(){vfunc_called(this, "_ZN6S158C24v115Ev");}
void  S158C2 ::v116(){vfunc_called(this, "_ZN6S158C24v116Ev");}
void  S158C2 ::v117(){vfunc_called(this, "_ZN6S158C24v117Ev");}
void  S158C2 ::v118(){vfunc_called(this, "_ZN6S158C24v118Ev");}
void  S158C2 ::v119(){vfunc_called(this, "_ZN6S158C24v119Ev");}
void  S158C2 ::v120(){vfunc_called(this, "_ZN6S158C24v120Ev");}
void  S158C2 ::v121(){vfunc_called(this, "_ZN6S158C24v121Ev");}
void  S158C2 ::v122(){vfunc_called(this, "_ZN6S158C24v122Ev");}
void  S158C2 ::v123(){vfunc_called(this, "_ZN6S158C24v123Ev");}
void  S158C2 ::v124(){vfunc_called(this, "_ZN6S158C24v124Ev");}
void  S158C2 ::v125(){vfunc_called(this, "_ZN6S158C24v125Ev");}
void  S158C2 ::v126(){vfunc_called(this, "_ZN6S158C24v126Ev");}
void  S158C2 ::v127(){vfunc_called(this, "_ZN6S158C24v127Ev");}
void  S158C2 ::v128(){vfunc_called(this, "_ZN6S158C24v128Ev");}
void  S158C2 ::v129(){vfunc_called(this, "_ZN6S158C24v129Ev");}
S158C2 ::S158C2(){ note_ctor("S158C2", this);} // tgen

static void Test_S158C2()
{
  extern Class_Descriptor cd_S158C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,40)];
    init_test(&cd_S158C2, buf);
    S158C2 *dp, &lv = *(dp=new (buf) S158C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,156), "sizeof(S158C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C2)");
    check_base_class_offset(lv, (S158C6*)(S158C5*)(S158C4*)(S158C3*), 0, "S158C2");
    check_base_class_offset(lv, (S158C5*)(S158C4*)(S158C3*), 0, "S158C2");
    check_base_class_offset(lv, (S158C4*)(S158C3*), 0, "S158C2");
    check_base_class_offset(lv, (S158C3*), 0, "S158C2");
    check_base_class_offset(lv, (S158C12*), ABISELECT(176,120), "S158C2");
    check_field_offset(lv, s158c2f0, ABISELECT(184,124), "S158C2.s158c2f0");
    check_field_offset(lv, s158c2f1, ABISELECT(200,136), "S158C2.s158c2f1");
    test_class_info(&lv, &cd_S158C2);
    dp->~S158C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C2(Test_S158C2, "S158C2", ABISELECT(232,156));

#else // __cplusplus

extern void _ZN6S158C2C1Ev();
extern void _ZN6S158C2D1Ev();
Name_Map name_map_S158C2[] = {
  NSPAIR(_ZN6S158C2C1Ev),
  NSPAIR(_ZN6S158C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S158C6;
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
extern Class_Descriptor cd_S158C5;
extern VTBL_ENTRY _ZTI6S158C5[];
extern  VTBL_ENTRY _ZTV6S158C5[];
extern Class_Descriptor cd_S158C4;
extern VTBL_ENTRY _ZTI6S158C4[];
extern  VTBL_ENTRY _ZTV6S158C4[];
extern Class_Descriptor cd_S158C3;
extern VTBL_ENTRY _ZTI6S158C3[];
extern  VTBL_ENTRY _ZTV6S158C3[];
extern Class_Descriptor cd_S158C12;
extern VTBL_ENTRY _ZTI7S158C12[];
extern  VTBL_ENTRY _ZTV7S158C12[];
static Base_Class bases_S158C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S158C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S158C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S158C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S158C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S158C12,    ABISELECT(176,120), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S158C2[];
extern void _ZN6S158C2D1Ev();
extern void _ZN6S158C2D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
extern void _ZN6S158C53v80Ev();
extern void _ZN6S158C53v81Ev();
extern void _ZN6S158C43v82Ev();
extern void _ZN6S158C43v83Ev();
extern void _ZN6S158C43v84Ev();
extern void _ZN6S158C43v85Ev();
extern void _ZN6S158C43v86Ev();
extern void _ZN6S158C43v87Ev();
extern void _ZN6S158C43v88Ev();
extern void _ZN6S158C43v89Ev();
extern void _ZN6S158C43v90Ev();
extern void _ZN6S158C43v91Ev();
extern void _ZN6S158C43v92Ev();
extern void _ZN6S158C43v93Ev();
extern void _ZN6S158C33v94Ev();
extern void _ZN6S158C33v95Ev();
extern void _ZN6S158C33v96Ev();
extern void _ZN6S158C33v97Ev();
extern void _ZN6S158C33v98Ev();
extern void _ZN6S158C33v99Ev();
extern void _ZN6S158C34v100Ev();
extern void _ZN6S158C34v101Ev();
extern void _ZN6S158C34v102Ev();
extern void _ZN6S158C24v111Ev();
extern void _ZN6S158C24v112Ev();
extern void _ZN6S158C24v113Ev();
extern void _ZN6S158C24v114Ev();
extern void _ZN6S158C24v115Ev();
extern void _ZN6S158C24v116Ev();
extern void _ZN6S158C24v117Ev();
extern void _ZN6S158C24v118Ev();
extern void _ZN6S158C24v119Ev();
extern void _ZN6S158C24v120Ev();
extern void _ZN6S158C24v121Ev();
extern void _ZN6S158C24v122Ev();
extern void _ZN6S158C24v123Ev();
extern void _ZN6S158C24v124Ev();
extern void _ZN6S158C24v125Ev();
extern void _ZN6S158C24v126Ev();
extern void _ZN6S158C24v127Ev();
extern void _ZN6S158C24v128Ev();
extern void _ZN6S158C24v129Ev();
extern void ABISELECT(_ZThn176_N6S158C2D1Ev,_ZThn120_N6S158C2D1Ev)();
extern void ABISELECT(_ZThn176_N6S158C2D0Ev,_ZThn120_N6S158C2D0Ev)();
extern void _ZN7S158C124v103Ev();
extern void _ZN7S158C124v104Ev();
extern void _ZN7S158C124v105Ev();
extern void _ZN7S158C124v106Ev();
extern void _ZN7S158C124v107Ev();
extern void _ZN7S158C124v108Ev();
extern void _ZN7S158C124v109Ev();
extern void _ZN7S158C124v110Ev();
static  VTBL_ENTRY vtc_S158C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C2[0]),
  (VTBL_ENTRY)&_ZN6S158C2D1Ev,
  (VTBL_ENTRY)&_ZN6S158C2D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
  (VTBL_ENTRY)&_ZN6S158C53v80Ev,
  (VTBL_ENTRY)&_ZN6S158C53v81Ev,
  (VTBL_ENTRY)&_ZN6S158C43v82Ev,
  (VTBL_ENTRY)&_ZN6S158C43v83Ev,
  (VTBL_ENTRY)&_ZN6S158C43v84Ev,
  (VTBL_ENTRY)&_ZN6S158C43v85Ev,
  (VTBL_ENTRY)&_ZN6S158C43v86Ev,
  (VTBL_ENTRY)&_ZN6S158C43v87Ev,
  (VTBL_ENTRY)&_ZN6S158C43v88Ev,
  (VTBL_ENTRY)&_ZN6S158C43v89Ev,
  (VTBL_ENTRY)&_ZN6S158C43v90Ev,
  (VTBL_ENTRY)&_ZN6S158C43v91Ev,
  (VTBL_ENTRY)&_ZN6S158C43v92Ev,
  (VTBL_ENTRY)&_ZN6S158C43v93Ev,
  (VTBL_ENTRY)&_ZN6S158C33v94Ev,
  (VTBL_ENTRY)&_ZN6S158C33v95Ev,
  (VTBL_ENTRY)&_ZN6S158C33v96Ev,
  (VTBL_ENTRY)&_ZN6S158C33v97Ev,
  (VTBL_ENTRY)&_ZN6S158C33v98Ev,
  (VTBL_ENTRY)&_ZN6S158C33v99Ev,
  (VTBL_ENTRY)&_ZN6S158C34v100Ev,
  (VTBL_ENTRY)&_ZN6S158C34v101Ev,
  (VTBL_ENTRY)&_ZN6S158C34v102Ev,
  (VTBL_ENTRY)&_ZN6S158C24v111Ev,
  (VTBL_ENTRY)&_ZN6S158C24v112Ev,
  (VTBL_ENTRY)&_ZN6S158C24v113Ev,
  (VTBL_ENTRY)&_ZN6S158C24v114Ev,
  (VTBL_ENTRY)&_ZN6S158C24v115Ev,
  (VTBL_ENTRY)&_ZN6S158C24v116Ev,
  (VTBL_ENTRY)&_ZN6S158C24v117Ev,
  (VTBL_ENTRY)&_ZN6S158C24v118Ev,
  (VTBL_ENTRY)&_ZN6S158C24v119Ev,
  (VTBL_ENTRY)&_ZN6S158C24v120Ev,
  (VTBL_ENTRY)&_ZN6S158C24v121Ev,
  (VTBL_ENTRY)&_ZN6S158C24v122Ev,
  (VTBL_ENTRY)&_ZN6S158C24v123Ev,
  (VTBL_ENTRY)&_ZN6S158C24v124Ev,
  (VTBL_ENTRY)&_ZN6S158C24v125Ev,
  (VTBL_ENTRY)&_ZN6S158C24v126Ev,
  (VTBL_ENTRY)&_ZN6S158C24v127Ev,
  (VTBL_ENTRY)&_ZN6S158C24v128Ev,
  (VTBL_ENTRY)&_ZN6S158C24v129Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S158C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S158C2D1Ev,_ZThn120_N6S158C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S158C2D0Ev,_ZThn120_N6S158C2D0Ev),
  (VTBL_ENTRY)&_ZN7S158C124v103Ev,
  (VTBL_ENTRY)&_ZN7S158C124v104Ev,
  (VTBL_ENTRY)&_ZN7S158C124v105Ev,
  (VTBL_ENTRY)&_ZN7S158C124v106Ev,
  (VTBL_ENTRY)&_ZN7S158C124v107Ev,
  (VTBL_ENTRY)&_ZN7S158C124v108Ev,
  (VTBL_ENTRY)&_ZN7S158C124v109Ev,
  (VTBL_ENTRY)&_ZN7S158C124v110Ev,
};
extern VTBL_ENTRY _ZTI6S158C2[];
extern  VTBL_ENTRY _ZTV6S158C2[];
Class_Descriptor cd_S158C2 = {  "S158C2", // class name
  bases_S158C2, 5,
  &(vtc_S158C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,156), // object size
  NSPAIRA(_ZTI6S158C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S158C2),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S158C1  : S158C2 {
  ::S223C27 s158c1f0;
  ::S3422C11 s158c1f1;
  virtual  ~S158C1(); // _ZN6S158C1D1Ev
  virtual void  v1(); // _ZN6S158C12v1Ev
  virtual void  v2(); // _ZN6S158C12v2Ev
  virtual void  v3(); // _ZN6S158C12v3Ev
  virtual void  v4(); // _ZN6S158C12v4Ev
  virtual void  v5(); // _ZN6S158C12v5Ev
  virtual void  v6(); // _ZN6S158C12v6Ev
  virtual void  v7(); // _ZN6S158C12v7Ev
  virtual void  v8(); // _ZN6S158C12v8Ev
  virtual void  v9(); // _ZN6S158C12v9Ev
  virtual void  v10(); // _ZN6S158C13v10Ev
  virtual void  v11(); // _ZN6S158C13v11Ev
  virtual void  v12(); // _ZN6S158C13v12Ev
  virtual void  v13(); // _ZN6S158C13v13Ev
  virtual void  v14(); // _ZN6S158C13v14Ev
  virtual void  v15(); // _ZN6S158C13v15Ev
  S158C1(); // tgen
};
//SIG(1 S158C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v80 v81} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 FC7 FC8 FC11} BC12{ vd v103 v104 v105 v106 v107 v108 v109 v110} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 FC13{ BC14{ BC10}} FC15{ BC16{ m FC14 Fp Fi}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC17{ BC18{ m FC9 Fp Fi}} FC19{ BC20{ BC10}}}


 S158C1 ::~S158C1(){ note_dtor("S158C1", this);}
void  S158C1 ::v1(){vfunc_called(this, "_ZN6S158C12v1Ev");}
void  S158C1 ::v2(){vfunc_called(this, "_ZN6S158C12v2Ev");}
void  S158C1 ::v3(){vfunc_called(this, "_ZN6S158C12v3Ev");}
void  S158C1 ::v4(){vfunc_called(this, "_ZN6S158C12v4Ev");}
void  S158C1 ::v5(){vfunc_called(this, "_ZN6S158C12v5Ev");}
void  S158C1 ::v6(){vfunc_called(this, "_ZN6S158C12v6Ev");}
void  S158C1 ::v7(){vfunc_called(this, "_ZN6S158C12v7Ev");}
void  S158C1 ::v8(){vfunc_called(this, "_ZN6S158C12v8Ev");}
void  S158C1 ::v9(){vfunc_called(this, "_ZN6S158C12v9Ev");}
void  S158C1 ::v10(){vfunc_called(this, "_ZN6S158C13v10Ev");}
void  S158C1 ::v11(){vfunc_called(this, "_ZN6S158C13v11Ev");}
void  S158C1 ::v12(){vfunc_called(this, "_ZN6S158C13v12Ev");}
void  S158C1 ::v13(){vfunc_called(this, "_ZN6S158C13v13Ev");}
void  S158C1 ::v14(){vfunc_called(this, "_ZN6S158C13v14Ev");}
void  S158C1 ::v15(){vfunc_called(this, "_ZN6S158C13v15Ev");}
S158C1 ::S158C1(){ note_ctor("S158C1", this);} // tgen

static void Test_S158C1()
{
  extern Class_Descriptor cd_S158C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,48)];
    init_test(&cd_S158C1, buf);
    S158C1 *dp, &lv = *(dp=new (buf) S158C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,188), "sizeof(S158C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S158C1)");
    check_base_class_offset(lv, (S158C6*)(S158C5*)(S158C4*)(S158C3*)(S158C2*), 0, "S158C1");
    check_base_class_offset(lv, (S158C5*)(S158C4*)(S158C3*)(S158C2*), 0, "S158C1");
    check_base_class_offset(lv, (S158C4*)(S158C3*)(S158C2*), 0, "S158C1");
    check_base_class_offset(lv, (S158C3*)(S158C2*), 0, "S158C1");
    check_base_class_offset(lv, (S158C12*)(S158C2*), ABISELECT(176,120), "S158C1");
    check_base_class_offset(lv, (S158C2*), 0, "S158C1");
    check_field_offset(lv, s158c1f0, ABISELECT(232,156), "S158C1.s158c1f0");
    check_field_offset(lv, s158c1f1, ABISELECT(264,176), "S158C1.s158c1f1");
    test_class_info(&lv, &cd_S158C1);
    dp->~S158C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS158C1(Test_S158C1, "S158C1", ABISELECT(280,188));

#else // __cplusplus

extern void _ZN6S158C1C1Ev();
extern void _ZN6S158C1D1Ev();
Name_Map name_map_S158C1[] = {
  NSPAIR(_ZN6S158C1C1Ev),
  NSPAIR(_ZN6S158C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S158C6;
extern VTBL_ENTRY _ZTI6S158C6[];
extern  VTBL_ENTRY _ZTV6S158C6[];
extern Class_Descriptor cd_S158C5;
extern VTBL_ENTRY _ZTI6S158C5[];
extern  VTBL_ENTRY _ZTV6S158C5[];
extern Class_Descriptor cd_S158C4;
extern VTBL_ENTRY _ZTI6S158C4[];
extern  VTBL_ENTRY _ZTV6S158C4[];
extern Class_Descriptor cd_S158C3;
extern VTBL_ENTRY _ZTI6S158C3[];
extern  VTBL_ENTRY _ZTV6S158C3[];
extern Class_Descriptor cd_S158C12;
extern VTBL_ENTRY _ZTI7S158C12[];
extern  VTBL_ENTRY _ZTV7S158C12[];
extern Class_Descriptor cd_S158C2;
extern VTBL_ENTRY _ZTI6S158C2[];
extern  VTBL_ENTRY _ZTV6S158C2[];
static Base_Class bases_S158C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S158C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S158C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S158C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S158C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S158C12,    ABISELECT(176,120), //bcp->offset
    125, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S158C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S158C1[];
extern void _ZN6S158C1D1Ev();
extern void _ZN6S158C1D0Ev();
extern void _ZN6S158C63v16Ev();
extern void _ZN6S158C63v17Ev();
extern void _ZN6S158C63v18Ev();
extern void _ZN6S158C63v19Ev();
extern void _ZN6S158C63v20Ev();
extern void _ZN6S158C63v21Ev();
extern void _ZN6S158C63v22Ev();
extern void _ZN6S158C63v23Ev();
extern void _ZN6S158C63v24Ev();
extern void _ZN6S158C63v25Ev();
extern void _ZN6S158C63v26Ev();
extern void _ZN6S158C63v27Ev();
extern void _ZN6S158C63v28Ev();
extern void _ZN6S158C63v29Ev();
extern void _ZN6S158C63v30Ev();
extern void _ZN6S158C63v31Ev();
extern void _ZN6S158C63v32Ev();
extern void _ZN6S158C63v33Ev();
extern void _ZN6S158C63v34Ev();
extern void _ZN6S158C63v35Ev();
extern void _ZN6S158C63v36Ev();
extern void _ZN6S158C63v37Ev();
extern void _ZN6S158C63v38Ev();
extern void _ZN6S158C63v39Ev();
extern void _ZN6S158C63v40Ev();
extern void _ZN6S158C63v41Ev();
extern void _ZN6S158C63v42Ev();
extern void _ZN6S158C63v43Ev();
extern void _ZN6S158C63v44Ev();
extern void _ZN6S158C63v45Ev();
extern void _ZN6S158C63v46Ev();
extern void _ZN6S158C63v47Ev();
extern void _ZN6S158C63v48Ev();
extern void _ZN6S158C63v49Ev();
extern void _ZN6S158C63v50Ev();
extern void _ZN6S158C63v51Ev();
extern void _ZN6S158C63v52Ev();
extern void _ZN6S158C63v53Ev();
extern void _ZN6S158C63v54Ev();
extern void _ZN6S158C63v55Ev();
extern void _ZN6S158C63v56Ev();
extern void _ZN6S158C63v57Ev();
extern void _ZN6S158C63v58Ev();
extern void _ZN6S158C63v59Ev();
extern void _ZN6S158C63v60Ev();
extern void _ZN6S158C63v61Ev();
extern void _ZN6S158C63v62Ev();
extern void _ZN6S158C63v63Ev();
extern void _ZN6S158C63v64Ev();
extern void _ZN6S158C63v65Ev();
extern void _ZN6S158C63v66Ev();
extern void _ZN6S158C63v67Ev();
extern void _ZN6S158C63v68Ev();
extern void _ZN6S158C63v69Ev();
extern void _ZN6S158C63v70Ev();
extern void _ZN6S158C63v71Ev();
extern void _ZN6S158C63v72Ev();
extern void _ZN6S158C63v73Ev();
extern void _ZN6S158C63v74Ev();
extern void _ZN6S158C63v75Ev();
extern void _ZN6S158C63v76Ev();
extern void _ZN6S158C63v77Ev();
extern void _ZN6S158C63v78Ev();
extern void _ZN6S158C63v79Ev();
extern void _ZN6S158C53v80Ev();
extern void _ZN6S158C53v81Ev();
extern void _ZN6S158C43v82Ev();
extern void _ZN6S158C43v83Ev();
extern void _ZN6S158C43v84Ev();
extern void _ZN6S158C43v85Ev();
extern void _ZN6S158C43v86Ev();
extern void _ZN6S158C43v87Ev();
extern void _ZN6S158C43v88Ev();
extern void _ZN6S158C43v89Ev();
extern void _ZN6S158C43v90Ev();
extern void _ZN6S158C43v91Ev();
extern void _ZN6S158C43v92Ev();
extern void _ZN6S158C43v93Ev();
extern void _ZN6S158C33v94Ev();
extern void _ZN6S158C33v95Ev();
extern void _ZN6S158C33v96Ev();
extern void _ZN6S158C33v97Ev();
extern void _ZN6S158C33v98Ev();
extern void _ZN6S158C33v99Ev();
extern void _ZN6S158C34v100Ev();
extern void _ZN6S158C34v101Ev();
extern void _ZN6S158C34v102Ev();
extern void _ZN6S158C24v111Ev();
extern void _ZN6S158C24v112Ev();
extern void _ZN6S158C24v113Ev();
extern void _ZN6S158C24v114Ev();
extern void _ZN6S158C24v115Ev();
extern void _ZN6S158C24v116Ev();
extern void _ZN6S158C24v117Ev();
extern void _ZN6S158C24v118Ev();
extern void _ZN6S158C24v119Ev();
extern void _ZN6S158C24v120Ev();
extern void _ZN6S158C24v121Ev();
extern void _ZN6S158C24v122Ev();
extern void _ZN6S158C24v123Ev();
extern void _ZN6S158C24v124Ev();
extern void _ZN6S158C24v125Ev();
extern void _ZN6S158C24v126Ev();
extern void _ZN6S158C24v127Ev();
extern void _ZN6S158C24v128Ev();
extern void _ZN6S158C24v129Ev();
extern void _ZN6S158C12v1Ev();
extern void _ZN6S158C12v2Ev();
extern void _ZN6S158C12v3Ev();
extern void _ZN6S158C12v4Ev();
extern void _ZN6S158C12v5Ev();
extern void _ZN6S158C12v6Ev();
extern void _ZN6S158C12v7Ev();
extern void _ZN6S158C12v8Ev();
extern void _ZN6S158C12v9Ev();
extern void _ZN6S158C13v10Ev();
extern void _ZN6S158C13v11Ev();
extern void _ZN6S158C13v12Ev();
extern void _ZN6S158C13v13Ev();
extern void _ZN6S158C13v14Ev();
extern void _ZN6S158C13v15Ev();
extern void ABISELECT(_ZThn176_N6S158C1D1Ev,_ZThn120_N6S158C1D1Ev)();
extern void ABISELECT(_ZThn176_N6S158C1D0Ev,_ZThn120_N6S158C1D0Ev)();
extern void _ZN7S158C124v103Ev();
extern void _ZN7S158C124v104Ev();
extern void _ZN7S158C124v105Ev();
extern void _ZN7S158C124v106Ev();
extern void _ZN7S158C124v107Ev();
extern void _ZN7S158C124v108Ev();
extern void _ZN7S158C124v109Ev();
extern void _ZN7S158C124v110Ev();
static  VTBL_ENTRY vtc_S158C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S158C1[0]),
  (VTBL_ENTRY)&_ZN6S158C1D1Ev,
  (VTBL_ENTRY)&_ZN6S158C1D0Ev,
  (VTBL_ENTRY)&_ZN6S158C63v16Ev,
  (VTBL_ENTRY)&_ZN6S158C63v17Ev,
  (VTBL_ENTRY)&_ZN6S158C63v18Ev,
  (VTBL_ENTRY)&_ZN6S158C63v19Ev,
  (VTBL_ENTRY)&_ZN6S158C63v20Ev,
  (VTBL_ENTRY)&_ZN6S158C63v21Ev,
  (VTBL_ENTRY)&_ZN6S158C63v22Ev,
  (VTBL_ENTRY)&_ZN6S158C63v23Ev,
  (VTBL_ENTRY)&_ZN6S158C63v24Ev,
  (VTBL_ENTRY)&_ZN6S158C63v25Ev,
  (VTBL_ENTRY)&_ZN6S158C63v26Ev,
  (VTBL_ENTRY)&_ZN6S158C63v27Ev,
  (VTBL_ENTRY)&_ZN6S158C63v28Ev,
  (VTBL_ENTRY)&_ZN6S158C63v29Ev,
  (VTBL_ENTRY)&_ZN6S158C63v30Ev,
  (VTBL_ENTRY)&_ZN6S158C63v31Ev,
  (VTBL_ENTRY)&_ZN6S158C63v32Ev,
  (VTBL_ENTRY)&_ZN6S158C63v33Ev,
  (VTBL_ENTRY)&_ZN6S158C63v34Ev,
  (VTBL_ENTRY)&_ZN6S158C63v35Ev,
  (VTBL_ENTRY)&_ZN6S158C63v36Ev,
  (VTBL_ENTRY)&_ZN6S158C63v37Ev,
  (VTBL_ENTRY)&_ZN6S158C63v38Ev,
  (VTBL_ENTRY)&_ZN6S158C63v39Ev,
  (VTBL_ENTRY)&_ZN6S158C63v40Ev,
  (VTBL_ENTRY)&_ZN6S158C63v41Ev,
  (VTBL_ENTRY)&_ZN6S158C63v42Ev,
  (VTBL_ENTRY)&_ZN6S158C63v43Ev,
  (VTBL_ENTRY)&_ZN6S158C63v44Ev,
  (VTBL_ENTRY)&_ZN6S158C63v45Ev,
  (VTBL_ENTRY)&_ZN6S158C63v46Ev,
  (VTBL_ENTRY)&_ZN6S158C63v47Ev,
  (VTBL_ENTRY)&_ZN6S158C63v48Ev,
  (VTBL_ENTRY)&_ZN6S158C63v49Ev,
  (VTBL_ENTRY)&_ZN6S158C63v50Ev,
  (VTBL_ENTRY)&_ZN6S158C63v51Ev,
  (VTBL_ENTRY)&_ZN6S158C63v52Ev,
  (VTBL_ENTRY)&_ZN6S158C63v53Ev,
  (VTBL_ENTRY)&_ZN6S158C63v54Ev,
  (VTBL_ENTRY)&_ZN6S158C63v55Ev,
  (VTBL_ENTRY)&_ZN6S158C63v56Ev,
  (VTBL_ENTRY)&_ZN6S158C63v57Ev,
  (VTBL_ENTRY)&_ZN6S158C63v58Ev,
  (VTBL_ENTRY)&_ZN6S158C63v59Ev,
  (VTBL_ENTRY)&_ZN6S158C63v60Ev,
  (VTBL_ENTRY)&_ZN6S158C63v61Ev,
  (VTBL_ENTRY)&_ZN6S158C63v62Ev,
  (VTBL_ENTRY)&_ZN6S158C63v63Ev,
  (VTBL_ENTRY)&_ZN6S158C63v64Ev,
  (VTBL_ENTRY)&_ZN6S158C63v65Ev,
  (VTBL_ENTRY)&_ZN6S158C63v66Ev,
  (VTBL_ENTRY)&_ZN6S158C63v67Ev,
  (VTBL_ENTRY)&_ZN6S158C63v68Ev,
  (VTBL_ENTRY)&_ZN6S158C63v69Ev,
  (VTBL_ENTRY)&_ZN6S158C63v70Ev,
  (VTBL_ENTRY)&_ZN6S158C63v71Ev,
  (VTBL_ENTRY)&_ZN6S158C63v72Ev,
  (VTBL_ENTRY)&_ZN6S158C63v73Ev,
  (VTBL_ENTRY)&_ZN6S158C63v74Ev,
  (VTBL_ENTRY)&_ZN6S158C63v75Ev,
  (VTBL_ENTRY)&_ZN6S158C63v76Ev,
  (VTBL_ENTRY)&_ZN6S158C63v77Ev,
  (VTBL_ENTRY)&_ZN6S158C63v78Ev,
  (VTBL_ENTRY)&_ZN6S158C63v79Ev,
  (VTBL_ENTRY)&_ZN6S158C53v80Ev,
  (VTBL_ENTRY)&_ZN6S158C53v81Ev,
  (VTBL_ENTRY)&_ZN6S158C43v82Ev,
  (VTBL_ENTRY)&_ZN6S158C43v83Ev,
  (VTBL_ENTRY)&_ZN6S158C43v84Ev,
  (VTBL_ENTRY)&_ZN6S158C43v85Ev,
  (VTBL_ENTRY)&_ZN6S158C43v86Ev,
  (VTBL_ENTRY)&_ZN6S158C43v87Ev,
  (VTBL_ENTRY)&_ZN6S158C43v88Ev,
  (VTBL_ENTRY)&_ZN6S158C43v89Ev,
  (VTBL_ENTRY)&_ZN6S158C43v90Ev,
  (VTBL_ENTRY)&_ZN6S158C43v91Ev,
  (VTBL_ENTRY)&_ZN6S158C43v92Ev,
  (VTBL_ENTRY)&_ZN6S158C43v93Ev,
  (VTBL_ENTRY)&_ZN6S158C33v94Ev,
  (VTBL_ENTRY)&_ZN6S158C33v95Ev,
  (VTBL_ENTRY)&_ZN6S158C33v96Ev,
  (VTBL_ENTRY)&_ZN6S158C33v97Ev,
  (VTBL_ENTRY)&_ZN6S158C33v98Ev,
  (VTBL_ENTRY)&_ZN6S158C33v99Ev,
  (VTBL_ENTRY)&_ZN6S158C34v100Ev,
  (VTBL_ENTRY)&_ZN6S158C34v101Ev,
  (VTBL_ENTRY)&_ZN6S158C34v102Ev,
  (VTBL_ENTRY)&_ZN6S158C24v111Ev,
  (VTBL_ENTRY)&_ZN6S158C24v112Ev,
  (VTBL_ENTRY)&_ZN6S158C24v113Ev,
  (VTBL_ENTRY)&_ZN6S158C24v114Ev,
  (VTBL_ENTRY)&_ZN6S158C24v115Ev,
  (VTBL_ENTRY)&_ZN6S158C24v116Ev,
  (VTBL_ENTRY)&_ZN6S158C24v117Ev,
  (VTBL_ENTRY)&_ZN6S158C24v118Ev,
  (VTBL_ENTRY)&_ZN6S158C24v119Ev,
  (VTBL_ENTRY)&_ZN6S158C24v120Ev,
  (VTBL_ENTRY)&_ZN6S158C24v121Ev,
  (VTBL_ENTRY)&_ZN6S158C24v122Ev,
  (VTBL_ENTRY)&_ZN6S158C24v123Ev,
  (VTBL_ENTRY)&_ZN6S158C24v124Ev,
  (VTBL_ENTRY)&_ZN6S158C24v125Ev,
  (VTBL_ENTRY)&_ZN6S158C24v126Ev,
  (VTBL_ENTRY)&_ZN6S158C24v127Ev,
  (VTBL_ENTRY)&_ZN6S158C24v128Ev,
  (VTBL_ENTRY)&_ZN6S158C24v129Ev,
  (VTBL_ENTRY)&_ZN6S158C12v1Ev,
  (VTBL_ENTRY)&_ZN6S158C12v2Ev,
  (VTBL_ENTRY)&_ZN6S158C12v3Ev,
  (VTBL_ENTRY)&_ZN6S158C12v4Ev,
  (VTBL_ENTRY)&_ZN6S158C12v5Ev,
  (VTBL_ENTRY)&_ZN6S158C12v6Ev,
  (VTBL_ENTRY)&_ZN6S158C12v7Ev,
  (VTBL_ENTRY)&_ZN6S158C12v8Ev,
  (VTBL_ENTRY)&_ZN6S158C12v9Ev,
  (VTBL_ENTRY)&_ZN6S158C13v10Ev,
  (VTBL_ENTRY)&_ZN6S158C13v11Ev,
  (VTBL_ENTRY)&_ZN6S158C13v12Ev,
  (VTBL_ENTRY)&_ZN6S158C13v13Ev,
  (VTBL_ENTRY)&_ZN6S158C13v14Ev,
  (VTBL_ENTRY)&_ZN6S158C13v15Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S158C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S158C1D1Ev,_ZThn120_N6S158C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S158C1D0Ev,_ZThn120_N6S158C1D0Ev),
  (VTBL_ENTRY)&_ZN7S158C124v103Ev,
  (VTBL_ENTRY)&_ZN7S158C124v104Ev,
  (VTBL_ENTRY)&_ZN7S158C124v105Ev,
  (VTBL_ENTRY)&_ZN7S158C124v106Ev,
  (VTBL_ENTRY)&_ZN7S158C124v107Ev,
  (VTBL_ENTRY)&_ZN7S158C124v108Ev,
  (VTBL_ENTRY)&_ZN7S158C124v109Ev,
  (VTBL_ENTRY)&_ZN7S158C124v110Ev,
};
extern VTBL_ENTRY _ZTI6S158C1[];
extern  VTBL_ENTRY _ZTV6S158C1[];
Class_Descriptor cd_S158C1 = {  "S158C1", // class name
  bases_S158C1, 6,
  &(vtc_S158C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,188), // object size
  NSPAIRA(_ZTI6S158C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S158C1),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C7  {
  int s50c7f0;
  __tsi64 s50c7f1;
  void *s50c7f2[4];
  int s50c7f3[2];
  void *s50c7f4;
  ::S3422C4_nt s50c7f5;
  void *s50c7f6[2];
  virtual  ~S50C7(); // _ZN5S50C7D1Ev
  virtual void  v11(); // _ZN5S50C73v11Ev
  virtual void  v12(); // _ZN5S50C73v12Ev
  virtual void  v13(); // _ZN5S50C73v13Ev
  virtual void  v14(); // _ZN5S50C73v14Ev
  virtual void  v15(); // _ZN5S50C73v15Ev
  virtual void  v16(); // _ZN5S50C73v16Ev
  virtual void  v17(); // _ZN5S50C73v17Ev
  virtual void  v18(); // _ZN5S50C73v18Ev
  virtual void  v19(); // _ZN5S50C73v19Ev
  virtual void  v20(); // _ZN5S50C73v20Ev
  virtual void  v21(); // _ZN5S50C73v21Ev
  virtual void  v22(); // _ZN5S50C73v22Ev
  virtual void  v23(); // _ZN5S50C73v23Ev
  virtual void  v24(); // _ZN5S50C73v24Ev
  virtual void  v25(); // _ZN5S50C73v25Ev
  virtual void  v26(); // _ZN5S50C73v26Ev
  virtual void  v27(); // _ZN5S50C73v27Ev
  virtual void  v28(); // _ZN5S50C73v28Ev
  virtual void  v29(); // _ZN5S50C73v29Ev
  virtual void  v30(); // _ZN5S50C73v30Ev
  virtual void  v31(); // _ZN5S50C73v31Ev
  virtual void  v32(); // _ZN5S50C73v32Ev
  virtual void  v33(); // _ZN5S50C73v33Ev
  virtual void  v34(); // _ZN5S50C73v34Ev
  virtual void  v35(); // _ZN5S50C73v35Ev
  virtual void  v36(); // _ZN5S50C73v36Ev
  virtual void  v37(); // _ZN5S50C73v37Ev
  virtual void  v38(); // _ZN5S50C73v38Ev
  virtual void  v39(); // _ZN5S50C73v39Ev
  virtual void  v40(); // _ZN5S50C73v40Ev
  virtual void  v41(); // _ZN5S50C73v41Ev
  virtual void  v42(); // _ZN5S50C73v42Ev
  virtual void  v43(); // _ZN5S50C73v43Ev
  virtual void  v44(); // _ZN5S50C73v44Ev
  virtual void  v45(); // _ZN5S50C73v45Ev
  virtual void  v46(); // _ZN5S50C73v46Ev
  virtual void  v47(); // _ZN5S50C73v47Ev
  virtual void  v48(); // _ZN5S50C73v48Ev
  virtual void  v49(); // _ZN5S50C73v49Ev
  virtual void  v50(); // _ZN5S50C73v50Ev
  virtual void  v51(); // _ZN5S50C73v51Ev
  virtual void  v52(); // _ZN5S50C73v52Ev
  virtual void  v53(); // _ZN5S50C73v53Ev
  virtual void  v54(); // _ZN5S50C73v54Ev
  virtual void  v55(); // _ZN5S50C73v55Ev
  virtual void  v56(); // _ZN5S50C73v56Ev
  virtual void  v57(); // _ZN5S50C73v57Ev
  virtual void  v58(); // _ZN5S50C73v58Ev
  virtual void  v59(); // _ZN5S50C73v59Ev
  virtual void  v60(); // _ZN5S50C73v60Ev
  virtual void  v61(); // _ZN5S50C73v61Ev
  virtual void  v62(); // _ZN5S50C73v62Ev
  virtual void  v63(); // _ZN5S50C73v63Ev
  virtual void  v64(); // _ZN5S50C73v64Ev
  virtual void  v65(); // _ZN5S50C73v65Ev
  virtual void  v66(); // _ZN5S50C73v66Ev
  virtual void  v67(); // _ZN5S50C73v67Ev
  virtual void  v68(); // _ZN5S50C73v68Ev
  virtual void  v69(); // _ZN5S50C73v69Ev
  virtual void  v70(); // _ZN5S50C73v70Ev
  virtual void  v71(); // _ZN5S50C73v71Ev
  virtual void  v72(); // _ZN5S50C73v72Ev
  virtual void  v73(); // _ZN5S50C73v73Ev
  virtual void  v74(); // _ZN5S50C73v74Ev
  S50C7(); // tgen
};
//SIG(-1 S50C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S50C7 ::~S50C7(){ note_dtor("S50C7", this);}
void  S50C7 ::v11(){vfunc_called(this, "_ZN5S50C73v11Ev");}
void  S50C7 ::v12(){vfunc_called(this, "_ZN5S50C73v12Ev");}
void  S50C7 ::v13(){vfunc_called(this, "_ZN5S50C73v13Ev");}
void  S50C7 ::v14(){vfunc_called(this, "_ZN5S50C73v14Ev");}
void  S50C7 ::v15(){vfunc_called(this, "_ZN5S50C73v15Ev");}
void  S50C7 ::v16(){vfunc_called(this, "_ZN5S50C73v16Ev");}
void  S50C7 ::v17(){vfunc_called(this, "_ZN5S50C73v17Ev");}
void  S50C7 ::v18(){vfunc_called(this, "_ZN5S50C73v18Ev");}
void  S50C7 ::v19(){vfunc_called(this, "_ZN5S50C73v19Ev");}
void  S50C7 ::v20(){vfunc_called(this, "_ZN5S50C73v20Ev");}
void  S50C7 ::v21(){vfunc_called(this, "_ZN5S50C73v21Ev");}
void  S50C7 ::v22(){vfunc_called(this, "_ZN5S50C73v22Ev");}
void  S50C7 ::v23(){vfunc_called(this, "_ZN5S50C73v23Ev");}
void  S50C7 ::v24(){vfunc_called(this, "_ZN5S50C73v24Ev");}
void  S50C7 ::v25(){vfunc_called(this, "_ZN5S50C73v25Ev");}
void  S50C7 ::v26(){vfunc_called(this, "_ZN5S50C73v26Ev");}
void  S50C7 ::v27(){vfunc_called(this, "_ZN5S50C73v27Ev");}
void  S50C7 ::v28(){vfunc_called(this, "_ZN5S50C73v28Ev");}
void  S50C7 ::v29(){vfunc_called(this, "_ZN5S50C73v29Ev");}
void  S50C7 ::v30(){vfunc_called(this, "_ZN5S50C73v30Ev");}
void  S50C7 ::v31(){vfunc_called(this, "_ZN5S50C73v31Ev");}
void  S50C7 ::v32(){vfunc_called(this, "_ZN5S50C73v32Ev");}
void  S50C7 ::v33(){vfunc_called(this, "_ZN5S50C73v33Ev");}
void  S50C7 ::v34(){vfunc_called(this, "_ZN5S50C73v34Ev");}
void  S50C7 ::v35(){vfunc_called(this, "_ZN5S50C73v35Ev");}
void  S50C7 ::v36(){vfunc_called(this, "_ZN5S50C73v36Ev");}
void  S50C7 ::v37(){vfunc_called(this, "_ZN5S50C73v37Ev");}
void  S50C7 ::v38(){vfunc_called(this, "_ZN5S50C73v38Ev");}
void  S50C7 ::v39(){vfunc_called(this, "_ZN5S50C73v39Ev");}
void  S50C7 ::v40(){vfunc_called(this, "_ZN5S50C73v40Ev");}
void  S50C7 ::v41(){vfunc_called(this, "_ZN5S50C73v41Ev");}
void  S50C7 ::v42(){vfunc_called(this, "_ZN5S50C73v42Ev");}
void  S50C7 ::v43(){vfunc_called(this, "_ZN5S50C73v43Ev");}
void  S50C7 ::v44(){vfunc_called(this, "_ZN5S50C73v44Ev");}
void  S50C7 ::v45(){vfunc_called(this, "_ZN5S50C73v45Ev");}
void  S50C7 ::v46(){vfunc_called(this, "_ZN5S50C73v46Ev");}
void  S50C7 ::v47(){vfunc_called(this, "_ZN5S50C73v47Ev");}
void  S50C7 ::v48(){vfunc_called(this, "_ZN5S50C73v48Ev");}
void  S50C7 ::v49(){vfunc_called(this, "_ZN5S50C73v49Ev");}
void  S50C7 ::v50(){vfunc_called(this, "_ZN5S50C73v50Ev");}
void  S50C7 ::v51(){vfunc_called(this, "_ZN5S50C73v51Ev");}
void  S50C7 ::v52(){vfunc_called(this, "_ZN5S50C73v52Ev");}
void  S50C7 ::v53(){vfunc_called(this, "_ZN5S50C73v53Ev");}
void  S50C7 ::v54(){vfunc_called(this, "_ZN5S50C73v54Ev");}
void  S50C7 ::v55(){vfunc_called(this, "_ZN5S50C73v55Ev");}
void  S50C7 ::v56(){vfunc_called(this, "_ZN5S50C73v56Ev");}
void  S50C7 ::v57(){vfunc_called(this, "_ZN5S50C73v57Ev");}
void  S50C7 ::v58(){vfunc_called(this, "_ZN5S50C73v58Ev");}
void  S50C7 ::v59(){vfunc_called(this, "_ZN5S50C73v59Ev");}
void  S50C7 ::v60(){vfunc_called(this, "_ZN5S50C73v60Ev");}
void  S50C7 ::v61(){vfunc_called(this, "_ZN5S50C73v61Ev");}
void  S50C7 ::v62(){vfunc_called(this, "_ZN5S50C73v62Ev");}
void  S50C7 ::v63(){vfunc_called(this, "_ZN5S50C73v63Ev");}
void  S50C7 ::v64(){vfunc_called(this, "_ZN5S50C73v64Ev");}
void  S50C7 ::v65(){vfunc_called(this, "_ZN5S50C73v65Ev");}
void  S50C7 ::v66(){vfunc_called(this, "_ZN5S50C73v66Ev");}
void  S50C7 ::v67(){vfunc_called(this, "_ZN5S50C73v67Ev");}
void  S50C7 ::v68(){vfunc_called(this, "_ZN5S50C73v68Ev");}
void  S50C7 ::v69(){vfunc_called(this, "_ZN5S50C73v69Ev");}
void  S50C7 ::v70(){vfunc_called(this, "_ZN5S50C73v70Ev");}
void  S50C7 ::v71(){vfunc_called(this, "_ZN5S50C73v71Ev");}
void  S50C7 ::v72(){vfunc_called(this, "_ZN5S50C73v72Ev");}
void  S50C7 ::v73(){vfunc_called(this, "_ZN5S50C73v73Ev");}
void  S50C7 ::v74(){vfunc_called(this, "_ZN5S50C73v74Ev");}
S50C7 ::S50C7(){ note_ctor("S50C7", this);} // tgen

static void Test_S50C7()
{
  extern Class_Descriptor cd_S50C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S50C7, buf);
    S50C7 *dp, &lv = *(dp=new (buf) S50C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S50C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C7)");
    check_field_offset(lv, s50c7f0, ABISELECT(8,4), "S50C7.s50c7f0");
    check_field_offset(lv, s50c7f1, ABISELECT(16,8), "S50C7.s50c7f1");
    check_field_offset(lv, s50c7f2, ABISELECT(24,16), "S50C7.s50c7f2");
    check_field_offset(lv, s50c7f3, ABISELECT(56,32), "S50C7.s50c7f3");
    check_field_offset(lv, s50c7f4, ABISELECT(64,40), "S50C7.s50c7f4");
    check_field_offset(lv, s50c7f5, ABISELECT(72,44), "S50C7.s50c7f5");
    check_field_offset(lv, s50c7f6, ABISELECT(80,52), "S50C7.s50c7f6");
    test_class_info(&lv, &cd_S50C7);
    dp->~S50C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C7(Test_S50C7, "S50C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S50C7C1Ev();
extern void _ZN5S50C7D1Ev();
Name_Map name_map_S50C7[] = {
  NSPAIR(_ZN5S50C7C1Ev),
  NSPAIR(_ZN5S50C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S50C7[];
extern void _ZN5S50C7D1Ev();
extern void _ZN5S50C7D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
static  VTBL_ENTRY vtc_S50C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C7[0]),
  (VTBL_ENTRY)&_ZN5S50C7D1Ev,
  (VTBL_ENTRY)&_ZN5S50C7D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
};
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
Class_Descriptor cd_S50C7 = {  "S50C7", // class name
  0,0,//no base classes
  &(vtc_S50C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S50C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S50C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C6  : S50C7 {
  virtual  ~S50C6(); // _ZN5S50C6D1Ev
  virtual void  v75(); // _ZN5S50C63v75Ev
  virtual void  v76(); // _ZN5S50C63v76Ev
  S50C6(); // tgen
};
//SIG(-1 S50C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S50C6 ::~S50C6(){ note_dtor("S50C6", this);}
void  S50C6 ::v75(){vfunc_called(this, "_ZN5S50C63v75Ev");}
void  S50C6 ::v76(){vfunc_called(this, "_ZN5S50C63v76Ev");}
S50C6 ::S50C6(){ note_ctor("S50C6", this);} // tgen

static void Test_S50C6()
{
  extern Class_Descriptor cd_S50C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S50C6, buf);
    S50C6 *dp, &lv = *(dp=new (buf) S50C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S50C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C6)");
    check_base_class_offset(lv, (S50C7*), 0, "S50C6");
    test_class_info(&lv, &cd_S50C6);
    dp->~S50C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C6(Test_S50C6, "S50C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S50C6C1Ev();
extern void _ZN5S50C6D1Ev();
Name_Map name_map_S50C6[] = {
  NSPAIR(_ZN5S50C6C1Ev),
  NSPAIR(_ZN5S50C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
static Base_Class bases_S50C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C6[];
extern void _ZN5S50C6D1Ev();
extern void _ZN5S50C6D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
static  VTBL_ENTRY vtc_S50C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C6[0]),
  (VTBL_ENTRY)&_ZN5S50C6D1Ev,
  (VTBL_ENTRY)&_ZN5S50C6D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
};
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
Class_Descriptor cd_S50C6 = {  "S50C6", // class name
  bases_S50C6, 1,
  &(vtc_S50C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S50C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S50C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C5  : S50C6 {
  char s50c5f0;
  ::S3422C23 s50c5f1;
  ::S49C12_nt s50c5f2;
  virtual  ~S50C5(); // _ZN5S50C5D1Ev
  virtual void  v77(); // _ZN5S50C53v77Ev
  virtual void  v78(); // _ZN5S50C53v78Ev
  virtual void  v79(); // _ZN5S50C53v79Ev
  virtual void  v80(); // _ZN5S50C53v80Ev
  virtual void  v81(); // _ZN5S50C53v81Ev
  virtual void  v82(); // _ZN5S50C53v82Ev
  virtual void  v83(); // _ZN5S50C53v83Ev
  virtual void  v84(); // _ZN5S50C53v84Ev
  virtual void  v85(); // _ZN5S50C53v85Ev
  virtual void  v86(); // _ZN5S50C53v86Ev
  virtual void  v87(); // _ZN5S50C53v87Ev
  virtual void  v88(); // _ZN5S50C53v88Ev
  S50C5(); // tgen
};
//SIG(-1 S50C5) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S50C5 ::~S50C5(){ note_dtor("S50C5", this);}
void  S50C5 ::v77(){vfunc_called(this, "_ZN5S50C53v77Ev");}
void  S50C5 ::v78(){vfunc_called(this, "_ZN5S50C53v78Ev");}
void  S50C5 ::v79(){vfunc_called(this, "_ZN5S50C53v79Ev");}
void  S50C5 ::v80(){vfunc_called(this, "_ZN5S50C53v80Ev");}
void  S50C5 ::v81(){vfunc_called(this, "_ZN5S50C53v81Ev");}
void  S50C5 ::v82(){vfunc_called(this, "_ZN5S50C53v82Ev");}
void  S50C5 ::v83(){vfunc_called(this, "_ZN5S50C53v83Ev");}
void  S50C5 ::v84(){vfunc_called(this, "_ZN5S50C53v84Ev");}
void  S50C5 ::v85(){vfunc_called(this, "_ZN5S50C53v85Ev");}
void  S50C5 ::v86(){vfunc_called(this, "_ZN5S50C53v86Ev");}
void  S50C5 ::v87(){vfunc_called(this, "_ZN5S50C53v87Ev");}
void  S50C5 ::v88(){vfunc_called(this, "_ZN5S50C53v88Ev");}
S50C5 ::S50C5(){ note_ctor("S50C5", this);} // tgen

static void Test_S50C5()
{
  extern Class_Descriptor cd_S50C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S50C5, buf);
    S50C5 *dp, &lv = *(dp=new (buf) S50C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S50C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C5)");
    check_base_class_offset(lv, (S50C7*)(S50C6*), 0, "S50C5");
    check_base_class_offset(lv, (S50C6*), 0, "S50C5");
    check_field_offset(lv, s50c5f0, ABISELECT(96,60), "S50C5.s50c5f0");
    check_field_offset(lv, s50c5f1, ABISELECT(104,64), "S50C5.s50c5f1");
    check_field_offset(lv, s50c5f2, ABISELECT(120,76), "S50C5.s50c5f2");
    test_class_info(&lv, &cd_S50C5);
    dp->~S50C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C5(Test_S50C5, "S50C5", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN5S50C5C1Ev();
extern void _ZN5S50C5D1Ev();
Name_Map name_map_S50C5[] = {
  NSPAIR(_ZN5S50C5C1Ev),
  NSPAIR(_ZN5S50C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
extern Class_Descriptor cd_S50C6;
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
static Base_Class bases_S50C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S50C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C5[];
extern void _ZN5S50C5D1Ev();
extern void _ZN5S50C5D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
extern void _ZN5S50C53v77Ev();
extern void _ZN5S50C53v78Ev();
extern void _ZN5S50C53v79Ev();
extern void _ZN5S50C53v80Ev();
extern void _ZN5S50C53v81Ev();
extern void _ZN5S50C53v82Ev();
extern void _ZN5S50C53v83Ev();
extern void _ZN5S50C53v84Ev();
extern void _ZN5S50C53v85Ev();
extern void _ZN5S50C53v86Ev();
extern void _ZN5S50C53v87Ev();
extern void _ZN5S50C53v88Ev();
static  VTBL_ENTRY vtc_S50C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C5[0]),
  (VTBL_ENTRY)&_ZN5S50C5D1Ev,
  (VTBL_ENTRY)&_ZN5S50C5D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
  (VTBL_ENTRY)&_ZN5S50C53v77Ev,
  (VTBL_ENTRY)&_ZN5S50C53v78Ev,
  (VTBL_ENTRY)&_ZN5S50C53v79Ev,
  (VTBL_ENTRY)&_ZN5S50C53v80Ev,
  (VTBL_ENTRY)&_ZN5S50C53v81Ev,
  (VTBL_ENTRY)&_ZN5S50C53v82Ev,
  (VTBL_ENTRY)&_ZN5S50C53v83Ev,
  (VTBL_ENTRY)&_ZN5S50C53v84Ev,
  (VTBL_ENTRY)&_ZN5S50C53v85Ev,
  (VTBL_ENTRY)&_ZN5S50C53v86Ev,
  (VTBL_ENTRY)&_ZN5S50C53v87Ev,
  (VTBL_ENTRY)&_ZN5S50C53v88Ev,
};
extern VTBL_ENTRY _ZTI5S50C5[];
extern  VTBL_ENTRY _ZTV5S50C5[];
Class_Descriptor cd_S50C5 = {  "S50C5", // class name
  bases_S50C5, 2,
  &(vtc_S50C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI5S50C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S50C5),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C4  : S50C5 {
  ::S3422C4_nt s50c4f0;
  ::S3422C23 s50c4f1;
  ::S49C12_nt s50c4f2;
  virtual  ~S50C4(); // _ZN5S50C4D1Ev
  virtual void  v89(); // _ZN5S50C43v89Ev
  virtual void  v90(); // _ZN5S50C43v90Ev
  virtual void  v91(); // _ZN5S50C43v91Ev
  virtual void  v92(); // _ZN5S50C43v92Ev
  virtual void  v93(); // _ZN5S50C43v93Ev
  virtual void  v94(); // _ZN5S50C43v94Ev
  virtual void  v95(); // _ZN5S50C43v95Ev
  virtual void  v96(); // _ZN5S50C43v96Ev
  virtual void  v97(); // _ZN5S50C43v97Ev
  S50C4(); // tgen
};
//SIG(-1 S50C4) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S50C4 ::~S50C4(){ note_dtor("S50C4", this);}
void  S50C4 ::v89(){vfunc_called(this, "_ZN5S50C43v89Ev");}
void  S50C4 ::v90(){vfunc_called(this, "_ZN5S50C43v90Ev");}
void  S50C4 ::v91(){vfunc_called(this, "_ZN5S50C43v91Ev");}
void  S50C4 ::v92(){vfunc_called(this, "_ZN5S50C43v92Ev");}
void  S50C4 ::v93(){vfunc_called(this, "_ZN5S50C43v93Ev");}
void  S50C4 ::v94(){vfunc_called(this, "_ZN5S50C43v94Ev");}
void  S50C4 ::v95(){vfunc_called(this, "_ZN5S50C43v95Ev");}
void  S50C4 ::v96(){vfunc_called(this, "_ZN5S50C43v96Ev");}
void  S50C4 ::v97(){vfunc_called(this, "_ZN5S50C43v97Ev");}
S50C4 ::S50C4(){ note_ctor("S50C4", this);} // tgen

static void Test_S50C4()
{
  extern Class_Descriptor cd_S50C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S50C4, buf);
    S50C4 *dp, &lv = *(dp=new (buf) S50C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S50C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C4)");
    check_base_class_offset(lv, (S50C7*)(S50C6*)(S50C5*), 0, "S50C4");
    check_base_class_offset(lv, (S50C6*)(S50C5*), 0, "S50C4");
    check_base_class_offset(lv, (S50C5*), 0, "S50C4");
    check_field_offset(lv, s50c4f0, ABISELECT(136,88), "S50C4.s50c4f0");
    check_field_offset(lv, s50c4f1, ABISELECT(144,96), "S50C4.s50c4f1");
    check_field_offset(lv, s50c4f2, ABISELECT(160,108), "S50C4.s50c4f2");
    test_class_info(&lv, &cd_S50C4);
    dp->~S50C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C4(Test_S50C4, "S50C4", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN5S50C4C1Ev();
extern void _ZN5S50C4D1Ev();
Name_Map name_map_S50C4[] = {
  NSPAIR(_ZN5S50C4C1Ev),
  NSPAIR(_ZN5S50C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
extern Class_Descriptor cd_S50C6;
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
extern Class_Descriptor cd_S50C5;
extern VTBL_ENTRY _ZTI5S50C5[];
extern  VTBL_ENTRY _ZTV5S50C5[];
static Base_Class bases_S50C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S50C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S50C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C4[];
extern void _ZN5S50C4D1Ev();
extern void _ZN5S50C4D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
extern void _ZN5S50C53v77Ev();
extern void _ZN5S50C53v78Ev();
extern void _ZN5S50C53v79Ev();
extern void _ZN5S50C53v80Ev();
extern void _ZN5S50C53v81Ev();
extern void _ZN5S50C53v82Ev();
extern void _ZN5S50C53v83Ev();
extern void _ZN5S50C53v84Ev();
extern void _ZN5S50C53v85Ev();
extern void _ZN5S50C53v86Ev();
extern void _ZN5S50C53v87Ev();
extern void _ZN5S50C53v88Ev();
extern void _ZN5S50C43v89Ev();
extern void _ZN5S50C43v90Ev();
extern void _ZN5S50C43v91Ev();
extern void _ZN5S50C43v92Ev();
extern void _ZN5S50C43v93Ev();
extern void _ZN5S50C43v94Ev();
extern void _ZN5S50C43v95Ev();
extern void _ZN5S50C43v96Ev();
extern void _ZN5S50C43v97Ev();
static  VTBL_ENTRY vtc_S50C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C4[0]),
  (VTBL_ENTRY)&_ZN5S50C4D1Ev,
  (VTBL_ENTRY)&_ZN5S50C4D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
  (VTBL_ENTRY)&_ZN5S50C53v77Ev,
  (VTBL_ENTRY)&_ZN5S50C53v78Ev,
  (VTBL_ENTRY)&_ZN5S50C53v79Ev,
  (VTBL_ENTRY)&_ZN5S50C53v80Ev,
  (VTBL_ENTRY)&_ZN5S50C53v81Ev,
  (VTBL_ENTRY)&_ZN5S50C53v82Ev,
  (VTBL_ENTRY)&_ZN5S50C53v83Ev,
  (VTBL_ENTRY)&_ZN5S50C53v84Ev,
  (VTBL_ENTRY)&_ZN5S50C53v85Ev,
  (VTBL_ENTRY)&_ZN5S50C53v86Ev,
  (VTBL_ENTRY)&_ZN5S50C53v87Ev,
  (VTBL_ENTRY)&_ZN5S50C53v88Ev,
  (VTBL_ENTRY)&_ZN5S50C43v89Ev,
  (VTBL_ENTRY)&_ZN5S50C43v90Ev,
  (VTBL_ENTRY)&_ZN5S50C43v91Ev,
  (VTBL_ENTRY)&_ZN5S50C43v92Ev,
  (VTBL_ENTRY)&_ZN5S50C43v93Ev,
  (VTBL_ENTRY)&_ZN5S50C43v94Ev,
  (VTBL_ENTRY)&_ZN5S50C43v95Ev,
  (VTBL_ENTRY)&_ZN5S50C43v96Ev,
  (VTBL_ENTRY)&_ZN5S50C43v97Ev,
};
extern VTBL_ENTRY _ZTI5S50C4[];
extern  VTBL_ENTRY _ZTV5S50C4[];
Class_Descriptor cd_S50C4 = {  "S50C4", // class name
  bases_S50C4, 3,
  &(vtc_S50C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI5S50C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S50C4),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C3  : S50C4 {
  virtual  ~S50C3(); // _ZN5S50C3D1Ev
  virtual void  v98(); // _ZN5S50C33v98Ev
  virtual void  v99(); // _ZN5S50C33v99Ev
  S50C3(); // tgen
};
//SIG(-1 S50C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v81 v82 v83 v84 v85 v86 v87 v88 v89 FC6 FC7 FC10} vd v1 v2}


 S50C3 ::~S50C3(){ note_dtor("S50C3", this);}
void  S50C3 ::v98(){vfunc_called(this, "_ZN5S50C33v98Ev");}
void  S50C3 ::v99(){vfunc_called(this, "_ZN5S50C33v99Ev");}
S50C3 ::S50C3(){ note_ctor("S50C3", this);} // tgen

static void Test_S50C3()
{
  extern Class_Descriptor cd_S50C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S50C3, buf);
    S50C3 *dp, &lv = *(dp=new (buf) S50C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S50C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C3)");
    check_base_class_offset(lv, (S50C7*)(S50C6*)(S50C5*)(S50C4*), 0, "S50C3");
    check_base_class_offset(lv, (S50C6*)(S50C5*)(S50C4*), 0, "S50C3");
    check_base_class_offset(lv, (S50C5*)(S50C4*), 0, "S50C3");
    check_base_class_offset(lv, (S50C4*), 0, "S50C3");
    test_class_info(&lv, &cd_S50C3);
    dp->~S50C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C3(Test_S50C3, "S50C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN5S50C3C1Ev();
extern void _ZN5S50C3D1Ev();
Name_Map name_map_S50C3[] = {
  NSPAIR(_ZN5S50C3C1Ev),
  NSPAIR(_ZN5S50C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
extern Class_Descriptor cd_S50C6;
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
extern Class_Descriptor cd_S50C5;
extern VTBL_ENTRY _ZTI5S50C5[];
extern  VTBL_ENTRY _ZTV5S50C5[];
extern Class_Descriptor cd_S50C4;
extern VTBL_ENTRY _ZTI5S50C4[];
extern  VTBL_ENTRY _ZTV5S50C4[];
static Base_Class bases_S50C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S50C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S50C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S50C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C3[];
extern void _ZN5S50C3D1Ev();
extern void _ZN5S50C3D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
extern void _ZN5S50C53v77Ev();
extern void _ZN5S50C53v78Ev();
extern void _ZN5S50C53v79Ev();
extern void _ZN5S50C53v80Ev();
extern void _ZN5S50C53v81Ev();
extern void _ZN5S50C53v82Ev();
extern void _ZN5S50C53v83Ev();
extern void _ZN5S50C53v84Ev();
extern void _ZN5S50C53v85Ev();
extern void _ZN5S50C53v86Ev();
extern void _ZN5S50C53v87Ev();
extern void _ZN5S50C53v88Ev();
extern void _ZN5S50C43v89Ev();
extern void _ZN5S50C43v90Ev();
extern void _ZN5S50C43v91Ev();
extern void _ZN5S50C43v92Ev();
extern void _ZN5S50C43v93Ev();
extern void _ZN5S50C43v94Ev();
extern void _ZN5S50C43v95Ev();
extern void _ZN5S50C43v96Ev();
extern void _ZN5S50C43v97Ev();
extern void _ZN5S50C33v98Ev();
extern void _ZN5S50C33v99Ev();
static  VTBL_ENTRY vtc_S50C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C3[0]),
  (VTBL_ENTRY)&_ZN5S50C3D1Ev,
  (VTBL_ENTRY)&_ZN5S50C3D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
  (VTBL_ENTRY)&_ZN5S50C53v77Ev,
  (VTBL_ENTRY)&_ZN5S50C53v78Ev,
  (VTBL_ENTRY)&_ZN5S50C53v79Ev,
  (VTBL_ENTRY)&_ZN5S50C53v80Ev,
  (VTBL_ENTRY)&_ZN5S50C53v81Ev,
  (VTBL_ENTRY)&_ZN5S50C53v82Ev,
  (VTBL_ENTRY)&_ZN5S50C53v83Ev,
  (VTBL_ENTRY)&_ZN5S50C53v84Ev,
  (VTBL_ENTRY)&_ZN5S50C53v85Ev,
  (VTBL_ENTRY)&_ZN5S50C53v86Ev,
  (VTBL_ENTRY)&_ZN5S50C53v87Ev,
  (VTBL_ENTRY)&_ZN5S50C53v88Ev,
  (VTBL_ENTRY)&_ZN5S50C43v89Ev,
  (VTBL_ENTRY)&_ZN5S50C43v90Ev,
  (VTBL_ENTRY)&_ZN5S50C43v91Ev,
  (VTBL_ENTRY)&_ZN5S50C43v92Ev,
  (VTBL_ENTRY)&_ZN5S50C43v93Ev,
  (VTBL_ENTRY)&_ZN5S50C43v94Ev,
  (VTBL_ENTRY)&_ZN5S50C43v95Ev,
  (VTBL_ENTRY)&_ZN5S50C43v96Ev,
  (VTBL_ENTRY)&_ZN5S50C43v97Ev,
  (VTBL_ENTRY)&_ZN5S50C33v98Ev,
  (VTBL_ENTRY)&_ZN5S50C33v99Ev,
};
extern VTBL_ENTRY _ZTI5S50C3[];
extern  VTBL_ENTRY _ZTV5S50C3[];
Class_Descriptor cd_S50C3 = {  "S50C3", // class name
  bases_S50C3, 4,
  &(vtc_S50C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI5S50C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S50C3),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C13  {
  virtual  ~S50C13(); // _ZN6S50C13D1Ev
  virtual void  v100(); // _ZN6S50C134v100Ev
  virtual void  v101(); // _ZN6S50C134v101Ev
  virtual void  v102(); // _ZN6S50C134v102Ev
  virtual void  v103(); // _ZN6S50C134v103Ev
  virtual void  v104(); // _ZN6S50C134v104Ev
  virtual void  v105(); // _ZN6S50C134v105Ev
  virtual void  v106(); // _ZN6S50C134v106Ev
  virtual void  v107(); // _ZN6S50C134v107Ev
  S50C13(); // tgen
};
//SIG(-1 S50C13) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S50C13 ::~S50C13(){ note_dtor("S50C13", this);}
void  S50C13 ::v100(){vfunc_called(this, "_ZN6S50C134v100Ev");}
void  S50C13 ::v101(){vfunc_called(this, "_ZN6S50C134v101Ev");}
void  S50C13 ::v102(){vfunc_called(this, "_ZN6S50C134v102Ev");}
void  S50C13 ::v103(){vfunc_called(this, "_ZN6S50C134v103Ev");}
void  S50C13 ::v104(){vfunc_called(this, "_ZN6S50C134v104Ev");}
void  S50C13 ::v105(){vfunc_called(this, "_ZN6S50C134v105Ev");}
void  S50C13 ::v106(){vfunc_called(this, "_ZN6S50C134v106Ev");}
void  S50C13 ::v107(){vfunc_called(this, "_ZN6S50C134v107Ev");}
S50C13 ::S50C13(){ note_ctor("S50C13", this);} // tgen

static void Test_S50C13()
{
  extern Class_Descriptor cd_S50C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S50C13, buf);
    S50C13 *dp, &lv = *(dp=new (buf) S50C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S50C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C13)");
    test_class_info(&lv, &cd_S50C13);
    dp->~S50C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C13(Test_S50C13, "S50C13", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S50C13C1Ev();
extern void _ZN6S50C13D1Ev();
Name_Map name_map_S50C13[] = {
  NSPAIR(_ZN6S50C13C1Ev),
  NSPAIR(_ZN6S50C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S50C13[];
extern void _ZN6S50C13D1Ev();
extern void _ZN6S50C13D0Ev();
extern void _ZN6S50C134v100Ev();
extern void _ZN6S50C134v101Ev();
extern void _ZN6S50C134v102Ev();
extern void _ZN6S50C134v103Ev();
extern void _ZN6S50C134v104Ev();
extern void _ZN6S50C134v105Ev();
extern void _ZN6S50C134v106Ev();
extern void _ZN6S50C134v107Ev();
static  VTBL_ENTRY vtc_S50C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S50C13[0]),
  (VTBL_ENTRY)&_ZN6S50C13D1Ev,
  (VTBL_ENTRY)&_ZN6S50C13D0Ev,
  (VTBL_ENTRY)&_ZN6S50C134v100Ev,
  (VTBL_ENTRY)&_ZN6S50C134v101Ev,
  (VTBL_ENTRY)&_ZN6S50C134v102Ev,
  (VTBL_ENTRY)&_ZN6S50C134v103Ev,
  (VTBL_ENTRY)&_ZN6S50C134v104Ev,
  (VTBL_ENTRY)&_ZN6S50C134v105Ev,
  (VTBL_ENTRY)&_ZN6S50C134v106Ev,
  (VTBL_ENTRY)&_ZN6S50C134v107Ev,
};
extern VTBL_ENTRY _ZTI6S50C13[];
extern  VTBL_ENTRY _ZTV6S50C13[];
Class_Descriptor cd_S50C13 = {  "S50C13", // class name
  0,0,//no base classes
  &(vtc_S50C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S50C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S50C13),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C14  {
  virtual  ~S50C14(); // _ZN6S50C14D1Ev
  virtual void  v108(); // _ZN6S50C144v108Ev
  virtual void  v109(); // _ZN6S50C144v109Ev
  virtual void  v110(); // _ZN6S50C144v110Ev
  virtual void  v111(); // _ZN6S50C144v111Ev
  S50C14(); // tgen
};
//SIG(-1 S50C14) C1{ vd v1 v2 v3 v4}


 S50C14 ::~S50C14(){ note_dtor("S50C14", this);}
void  S50C14 ::v108(){vfunc_called(this, "_ZN6S50C144v108Ev");}
void  S50C14 ::v109(){vfunc_called(this, "_ZN6S50C144v109Ev");}
void  S50C14 ::v110(){vfunc_called(this, "_ZN6S50C144v110Ev");}
void  S50C14 ::v111(){vfunc_called(this, "_ZN6S50C144v111Ev");}
S50C14 ::S50C14(){ note_ctor("S50C14", this);} // tgen

static void Test_S50C14()
{
  extern Class_Descriptor cd_S50C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S50C14, buf);
    S50C14 *dp, &lv = *(dp=new (buf) S50C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S50C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C14)");
    test_class_info(&lv, &cd_S50C14);
    dp->~S50C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C14(Test_S50C14, "S50C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S50C14C1Ev();
extern void _ZN6S50C14D1Ev();
Name_Map name_map_S50C14[] = {
  NSPAIR(_ZN6S50C14C1Ev),
  NSPAIR(_ZN6S50C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S50C14[];
extern void _ZN6S50C14D1Ev();
extern void _ZN6S50C14D0Ev();
extern void _ZN6S50C144v108Ev();
extern void _ZN6S50C144v109Ev();
extern void _ZN6S50C144v110Ev();
extern void _ZN6S50C144v111Ev();
static  VTBL_ENTRY vtc_S50C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S50C14[0]),
  (VTBL_ENTRY)&_ZN6S50C14D1Ev,
  (VTBL_ENTRY)&_ZN6S50C14D0Ev,
  (VTBL_ENTRY)&_ZN6S50C144v108Ev,
  (VTBL_ENTRY)&_ZN6S50C144v109Ev,
  (VTBL_ENTRY)&_ZN6S50C144v110Ev,
  (VTBL_ENTRY)&_ZN6S50C144v111Ev,
};
extern VTBL_ENTRY _ZTI6S50C14[];
extern  VTBL_ENTRY _ZTV6S50C14[];
Class_Descriptor cd_S50C14 = {  "S50C14", // class name
  0,0,//no base classes
  &(vtc_S50C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S50C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S50C14),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C2  : S50C3 , S50C13 , S50C14 {
  ::S3422C4_nt s50c2f0;
  void *s50c2f1;
  ::S49C24_nt s50c2f2;
  ::S3422C17 s50c2f3;
  int s50c2f4[2];
  virtual  ~S50C2(); // _ZN5S50C2D1Ev
  virtual void  v112(); // _ZN5S50C24v112Ev
  virtual void  v113(); // _ZN5S50C24v113Ev
  virtual void  v114(); // _ZN5S50C24v114Ev
  virtual void  v115(); // _ZN5S50C24v115Ev
  virtual void  v116(); // _ZN5S50C24v116Ev
  virtual void  v117(); // _ZN5S50C24v117Ev
  virtual void  v118(); // _ZN5S50C24v118Ev
  virtual void  v119(); // _ZN5S50C24v119Ev
  virtual void  v120(); // _ZN5S50C24v120Ev
  virtual void  v121(); // _ZN5S50C24v121Ev
  virtual void  v122(); // _ZN5S50C24v122Ev
  virtual void  v123(); // _ZN5S50C24v123Ev
  virtual void  v124(); // _ZN5S50C24v124Ev
  virtual void  v125(); // _ZN5S50C24v125Ev
  virtual void  v126(); // _ZN5S50C24v126Ev
  virtual void  v127(); // _ZN5S50C24v127Ev
  virtual void  v128(); // _ZN5S50C24v128Ev
  virtual void  v129(); // _ZN5S50C24v129Ev
  S50C2(); // tgen
};
//SIG(-1 S50C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v83 v84} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 FC7 FC8 FC11} vd v106 v107} BC12{ vd v108 v109 v110 v111 v112 v113 v114 v115} BC13{ vd v116 v117 v118 v119} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 FC7 Fp FC14{ BC15{ m Fp[2]}} FC16{ BC17{ BC10}} Fi[2]}


 S50C2 ::~S50C2(){ note_dtor("S50C2", this);}
void  S50C2 ::v112(){vfunc_called(this, "_ZN5S50C24v112Ev");}
void  S50C2 ::v113(){vfunc_called(this, "_ZN5S50C24v113Ev");}
void  S50C2 ::v114(){vfunc_called(this, "_ZN5S50C24v114Ev");}
void  S50C2 ::v115(){vfunc_called(this, "_ZN5S50C24v115Ev");}
void  S50C2 ::v116(){vfunc_called(this, "_ZN5S50C24v116Ev");}
void  S50C2 ::v117(){vfunc_called(this, "_ZN5S50C24v117Ev");}
void  S50C2 ::v118(){vfunc_called(this, "_ZN5S50C24v118Ev");}
void  S50C2 ::v119(){vfunc_called(this, "_ZN5S50C24v119Ev");}
void  S50C2 ::v120(){vfunc_called(this, "_ZN5S50C24v120Ev");}
void  S50C2 ::v121(){vfunc_called(this, "_ZN5S50C24v121Ev");}
void  S50C2 ::v122(){vfunc_called(this, "_ZN5S50C24v122Ev");}
void  S50C2 ::v123(){vfunc_called(this, "_ZN5S50C24v123Ev");}
void  S50C2 ::v124(){vfunc_called(this, "_ZN5S50C24v124Ev");}
void  S50C2 ::v125(){vfunc_called(this, "_ZN5S50C24v125Ev");}
void  S50C2 ::v126(){vfunc_called(this, "_ZN5S50C24v126Ev");}
void  S50C2 ::v127(){vfunc_called(this, "_ZN5S50C24v127Ev");}
void  S50C2 ::v128(){vfunc_called(this, "_ZN5S50C24v128Ev");}
void  S50C2 ::v129(){vfunc_called(this, "_ZN5S50C24v129Ev");}
S50C2 ::S50C2(){ note_ctor("S50C2", this);} // tgen

static void Test_S50C2()
{
  extern Class_Descriptor cd_S50C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,43)];
    init_test(&cd_S50C2, buf);
    S50C2 *dp, &lv = *(dp=new (buf) S50C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,168), "sizeof(S50C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C2)");
    check_base_class_offset(lv, (S50C7*)(S50C6*)(S50C5*)(S50C4*)(S50C3*), 0, "S50C2");
    check_base_class_offset(lv, (S50C6*)(S50C5*)(S50C4*)(S50C3*), 0, "S50C2");
    check_base_class_offset(lv, (S50C5*)(S50C4*)(S50C3*), 0, "S50C2");
    check_base_class_offset(lv, (S50C4*)(S50C3*), 0, "S50C2");
    check_base_class_offset(lv, (S50C3*), 0, "S50C2");
    check_base_class_offset(lv, (S50C13*), ABISELECT(176,120), "S50C2");
    check_base_class_offset(lv, (S50C14*), ABISELECT(184,124), "S50C2");
    check_field_offset(lv, s50c2f0, ABISELECT(192,128), "S50C2.s50c2f0");
    check_field_offset(lv, s50c2f1, ABISELECT(200,136), "S50C2.s50c2f1");
    check_field_offset(lv, s50c2f2, ABISELECT(208,140), "S50C2.s50c2f2");
    check_field_offset(lv, s50c2f3, ABISELECT(224,148), "S50C2.s50c2f3");
    check_field_offset(lv, s50c2f4, ABISELECT(240,160), "S50C2.s50c2f4");
    test_class_info(&lv, &cd_S50C2);
    dp->~S50C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C2(Test_S50C2, "S50C2", ABISELECT(248,168));

#else // __cplusplus

extern void _ZN5S50C2C1Ev();
extern void _ZN5S50C2D1Ev();
Name_Map name_map_S50C2[] = {
  NSPAIR(_ZN5S50C2C1Ev),
  NSPAIR(_ZN5S50C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
extern Class_Descriptor cd_S50C6;
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
extern Class_Descriptor cd_S50C5;
extern VTBL_ENTRY _ZTI5S50C5[];
extern  VTBL_ENTRY _ZTV5S50C5[];
extern Class_Descriptor cd_S50C4;
extern VTBL_ENTRY _ZTI5S50C4[];
extern  VTBL_ENTRY _ZTV5S50C4[];
extern Class_Descriptor cd_S50C3;
extern VTBL_ENTRY _ZTI5S50C3[];
extern  VTBL_ENTRY _ZTV5S50C3[];
extern Class_Descriptor cd_S50C13;
extern VTBL_ENTRY _ZTI6S50C13[];
extern  VTBL_ENTRY _ZTV6S50C13[];
extern Class_Descriptor cd_S50C14;
extern VTBL_ENTRY _ZTI6S50C14[];
extern  VTBL_ENTRY _ZTV6S50C14[];
static Base_Class bases_S50C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S50C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S50C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S50C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S50C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S50C13,    ABISELECT(176,120), //bcp->offset
    111, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S50C14,    ABISELECT(184,124), //bcp->offset
    123, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C2[];
extern void _ZN5S50C2D1Ev();
extern void _ZN5S50C2D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
extern void _ZN5S50C53v77Ev();
extern void _ZN5S50C53v78Ev();
extern void _ZN5S50C53v79Ev();
extern void _ZN5S50C53v80Ev();
extern void _ZN5S50C53v81Ev();
extern void _ZN5S50C53v82Ev();
extern void _ZN5S50C53v83Ev();
extern void _ZN5S50C53v84Ev();
extern void _ZN5S50C53v85Ev();
extern void _ZN5S50C53v86Ev();
extern void _ZN5S50C53v87Ev();
extern void _ZN5S50C53v88Ev();
extern void _ZN5S50C43v89Ev();
extern void _ZN5S50C43v90Ev();
extern void _ZN5S50C43v91Ev();
extern void _ZN5S50C43v92Ev();
extern void _ZN5S50C43v93Ev();
extern void _ZN5S50C43v94Ev();
extern void _ZN5S50C43v95Ev();
extern void _ZN5S50C43v96Ev();
extern void _ZN5S50C43v97Ev();
extern void _ZN5S50C33v98Ev();
extern void _ZN5S50C33v99Ev();
extern void _ZN5S50C24v112Ev();
extern void _ZN5S50C24v113Ev();
extern void _ZN5S50C24v114Ev();
extern void _ZN5S50C24v115Ev();
extern void _ZN5S50C24v116Ev();
extern void _ZN5S50C24v117Ev();
extern void _ZN5S50C24v118Ev();
extern void _ZN5S50C24v119Ev();
extern void _ZN5S50C24v120Ev();
extern void _ZN5S50C24v121Ev();
extern void _ZN5S50C24v122Ev();
extern void _ZN5S50C24v123Ev();
extern void _ZN5S50C24v124Ev();
extern void _ZN5S50C24v125Ev();
extern void _ZN5S50C24v126Ev();
extern void _ZN5S50C24v127Ev();
extern void _ZN5S50C24v128Ev();
extern void _ZN5S50C24v129Ev();
extern void ABISELECT(_ZThn176_N5S50C2D1Ev,_ZThn120_N5S50C2D1Ev)();
extern void ABISELECT(_ZThn176_N5S50C2D0Ev,_ZThn120_N5S50C2D0Ev)();
extern void _ZN6S50C134v100Ev();
extern void _ZN6S50C134v101Ev();
extern void _ZN6S50C134v102Ev();
extern void _ZN6S50C134v103Ev();
extern void _ZN6S50C134v104Ev();
extern void _ZN6S50C134v105Ev();
extern void _ZN6S50C134v106Ev();
extern void _ZN6S50C134v107Ev();
extern void ABISELECT(_ZThn184_N5S50C2D1Ev,_ZThn124_N5S50C2D1Ev)();
extern void ABISELECT(_ZThn184_N5S50C2D0Ev,_ZThn124_N5S50C2D0Ev)();
extern void _ZN6S50C144v108Ev();
extern void _ZN6S50C144v109Ev();
extern void _ZN6S50C144v110Ev();
extern void _ZN6S50C144v111Ev();
static  VTBL_ENTRY vtc_S50C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C2[0]),
  (VTBL_ENTRY)&_ZN5S50C2D1Ev,
  (VTBL_ENTRY)&_ZN5S50C2D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
  (VTBL_ENTRY)&_ZN5S50C53v77Ev,
  (VTBL_ENTRY)&_ZN5S50C53v78Ev,
  (VTBL_ENTRY)&_ZN5S50C53v79Ev,
  (VTBL_ENTRY)&_ZN5S50C53v80Ev,
  (VTBL_ENTRY)&_ZN5S50C53v81Ev,
  (VTBL_ENTRY)&_ZN5S50C53v82Ev,
  (VTBL_ENTRY)&_ZN5S50C53v83Ev,
  (VTBL_ENTRY)&_ZN5S50C53v84Ev,
  (VTBL_ENTRY)&_ZN5S50C53v85Ev,
  (VTBL_ENTRY)&_ZN5S50C53v86Ev,
  (VTBL_ENTRY)&_ZN5S50C53v87Ev,
  (VTBL_ENTRY)&_ZN5S50C53v88Ev,
  (VTBL_ENTRY)&_ZN5S50C43v89Ev,
  (VTBL_ENTRY)&_ZN5S50C43v90Ev,
  (VTBL_ENTRY)&_ZN5S50C43v91Ev,
  (VTBL_ENTRY)&_ZN5S50C43v92Ev,
  (VTBL_ENTRY)&_ZN5S50C43v93Ev,
  (VTBL_ENTRY)&_ZN5S50C43v94Ev,
  (VTBL_ENTRY)&_ZN5S50C43v95Ev,
  (VTBL_ENTRY)&_ZN5S50C43v96Ev,
  (VTBL_ENTRY)&_ZN5S50C43v97Ev,
  (VTBL_ENTRY)&_ZN5S50C33v98Ev,
  (VTBL_ENTRY)&_ZN5S50C33v99Ev,
  (VTBL_ENTRY)&_ZN5S50C24v112Ev,
  (VTBL_ENTRY)&_ZN5S50C24v113Ev,
  (VTBL_ENTRY)&_ZN5S50C24v114Ev,
  (VTBL_ENTRY)&_ZN5S50C24v115Ev,
  (VTBL_ENTRY)&_ZN5S50C24v116Ev,
  (VTBL_ENTRY)&_ZN5S50C24v117Ev,
  (VTBL_ENTRY)&_ZN5S50C24v118Ev,
  (VTBL_ENTRY)&_ZN5S50C24v119Ev,
  (VTBL_ENTRY)&_ZN5S50C24v120Ev,
  (VTBL_ENTRY)&_ZN5S50C24v121Ev,
  (VTBL_ENTRY)&_ZN5S50C24v122Ev,
  (VTBL_ENTRY)&_ZN5S50C24v123Ev,
  (VTBL_ENTRY)&_ZN5S50C24v124Ev,
  (VTBL_ENTRY)&_ZN5S50C24v125Ev,
  (VTBL_ENTRY)&_ZN5S50C24v126Ev,
  (VTBL_ENTRY)&_ZN5S50C24v127Ev,
  (VTBL_ENTRY)&_ZN5S50C24v128Ev,
  (VTBL_ENTRY)&_ZN5S50C24v129Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI5S50C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S50C2D1Ev,_ZThn120_N5S50C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S50C2D0Ev,_ZThn120_N5S50C2D0Ev),
  (VTBL_ENTRY)&_ZN6S50C134v100Ev,
  (VTBL_ENTRY)&_ZN6S50C134v101Ev,
  (VTBL_ENTRY)&_ZN6S50C134v102Ev,
  (VTBL_ENTRY)&_ZN6S50C134v103Ev,
  (VTBL_ENTRY)&_ZN6S50C134v104Ev,
  (VTBL_ENTRY)&_ZN6S50C134v105Ev,
  (VTBL_ENTRY)&_ZN6S50C134v106Ev,
  (VTBL_ENTRY)&_ZN6S50C134v107Ev,
  ABISELECT(-184,-124),
  (VTBL_ENTRY)&(_ZTI5S50C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S50C2D1Ev,_ZThn124_N5S50C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S50C2D0Ev,_ZThn124_N5S50C2D0Ev),
  (VTBL_ENTRY)&_ZN6S50C144v108Ev,
  (VTBL_ENTRY)&_ZN6S50C144v109Ev,
  (VTBL_ENTRY)&_ZN6S50C144v110Ev,
  (VTBL_ENTRY)&_ZN6S50C144v111Ev,
};
extern VTBL_ENTRY _ZTI5S50C2[];
extern  VTBL_ENTRY _ZTV5S50C2[];
Class_Descriptor cd_S50C2 = {  "S50C2", // class name
  bases_S50C2, 7,
  &(vtc_S50C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,168), // object size
  NSPAIRA(_ZTI5S50C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV5S50C2),131, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S50C1  : S50C2 {
  void *s50c1f0;
  virtual  ~S50C1(); // _ZN5S50C1D1Ev
  virtual void  v1(); // _ZN5S50C12v1Ev
  virtual void  v2(); // _ZN5S50C12v2Ev
  virtual void  v3(); // _ZN5S50C12v3Ev
  virtual void  v4(); // _ZN5S50C12v4Ev
  virtual void  v5(); // _ZN5S50C12v5Ev
  virtual void  v6(); // _ZN5S50C12v6Ev
  virtual void  v7(); // _ZN5S50C12v7Ev
  virtual void  v8(); // _ZN5S50C12v8Ev
  virtual void  v9(); // _ZN5S50C12v9Ev
  virtual void  v10(); // _ZN5S50C13v10Ev
  S50C1(); // tgen
};
//SIG(1 S50C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v75 v76} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 FC8 FC9 FC12} vd v98 v99} BC13{ vd v100 v101 v102 v103 v104 v105 v106 v107} BC14{ vd v108 v109 v110 v111} vd v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 FC8 Fp FC15{ BC16{ m Fp[2]}} FC17{ BC18{ BC11}} Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S50C1 ::~S50C1(){ note_dtor("S50C1", this);}
void  S50C1 ::v1(){vfunc_called(this, "_ZN5S50C12v1Ev");}
void  S50C1 ::v2(){vfunc_called(this, "_ZN5S50C12v2Ev");}
void  S50C1 ::v3(){vfunc_called(this, "_ZN5S50C12v3Ev");}
void  S50C1 ::v4(){vfunc_called(this, "_ZN5S50C12v4Ev");}
void  S50C1 ::v5(){vfunc_called(this, "_ZN5S50C12v5Ev");}
void  S50C1 ::v6(){vfunc_called(this, "_ZN5S50C12v6Ev");}
void  S50C1 ::v7(){vfunc_called(this, "_ZN5S50C12v7Ev");}
void  S50C1 ::v8(){vfunc_called(this, "_ZN5S50C12v8Ev");}
void  S50C1 ::v9(){vfunc_called(this, "_ZN5S50C12v9Ev");}
void  S50C1 ::v10(){vfunc_called(this, "_ZN5S50C13v10Ev");}
S50C1 ::S50C1(){ note_ctor("S50C1", this);} // tgen

static void Test_S50C1()
{
  extern Class_Descriptor cd_S50C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,44)];
    init_test(&cd_S50C1, buf);
    S50C1 *dp, &lv = *(dp=new (buf) S50C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,172), "sizeof(S50C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S50C1)");
    check_base_class_offset(lv, (S50C7*)(S50C6*)(S50C5*)(S50C4*)(S50C3*)(S50C2*), 0, "S50C1");
    check_base_class_offset(lv, (S50C6*)(S50C5*)(S50C4*)(S50C3*)(S50C2*), 0, "S50C1");
    check_base_class_offset(lv, (S50C5*)(S50C4*)(S50C3*)(S50C2*), 0, "S50C1");
    check_base_class_offset(lv, (S50C4*)(S50C3*)(S50C2*), 0, "S50C1");
    check_base_class_offset(lv, (S50C3*)(S50C2*), 0, "S50C1");
    check_base_class_offset(lv, (S50C13*)(S50C2*), ABISELECT(176,120), "S50C1");
    check_base_class_offset(lv, (S50C14*)(S50C2*), ABISELECT(184,124), "S50C1");
    check_base_class_offset(lv, (S50C2*), 0, "S50C1");
    check_field_offset(lv, s50c1f0, ABISELECT(248,168), "S50C1.s50c1f0");
    test_class_info(&lv, &cd_S50C1);
    dp->~S50C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS50C1(Test_S50C1, "S50C1", ABISELECT(256,172));

#else // __cplusplus

extern void _ZN5S50C1C1Ev();
extern void _ZN5S50C1D1Ev();
Name_Map name_map_S50C1[] = {
  NSPAIR(_ZN5S50C1C1Ev),
  NSPAIR(_ZN5S50C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S50C7;
extern VTBL_ENTRY _ZTI5S50C7[];
extern  VTBL_ENTRY _ZTV5S50C7[];
extern Class_Descriptor cd_S50C6;
extern VTBL_ENTRY _ZTI5S50C6[];
extern  VTBL_ENTRY _ZTV5S50C6[];
extern Class_Descriptor cd_S50C5;
extern VTBL_ENTRY _ZTI5S50C5[];
extern  VTBL_ENTRY _ZTV5S50C5[];
extern Class_Descriptor cd_S50C4;
extern VTBL_ENTRY _ZTI5S50C4[];
extern  VTBL_ENTRY _ZTV5S50C4[];
extern Class_Descriptor cd_S50C3;
extern VTBL_ENTRY _ZTI5S50C3[];
extern  VTBL_ENTRY _ZTV5S50C3[];
extern Class_Descriptor cd_S50C13;
extern VTBL_ENTRY _ZTI6S50C13[];
extern  VTBL_ENTRY _ZTV6S50C13[];
extern Class_Descriptor cd_S50C14;
extern VTBL_ENTRY _ZTI6S50C14[];
extern  VTBL_ENTRY _ZTV6S50C14[];
extern Class_Descriptor cd_S50C2;
extern VTBL_ENTRY _ZTI5S50C2[];
extern  VTBL_ENTRY _ZTV5S50C2[];
static Base_Class bases_S50C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S50C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S50C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S50C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S50C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S50C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S50C13,    ABISELECT(176,120), //bcp->offset
    121, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S50C14,    ABISELECT(184,124), //bcp->offset
    133, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S50C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S50C1[];
extern void _ZN5S50C1D1Ev();
extern void _ZN5S50C1D0Ev();
extern void _ZN5S50C73v11Ev();
extern void _ZN5S50C73v12Ev();
extern void _ZN5S50C73v13Ev();
extern void _ZN5S50C73v14Ev();
extern void _ZN5S50C73v15Ev();
extern void _ZN5S50C73v16Ev();
extern void _ZN5S50C73v17Ev();
extern void _ZN5S50C73v18Ev();
extern void _ZN5S50C73v19Ev();
extern void _ZN5S50C73v20Ev();
extern void _ZN5S50C73v21Ev();
extern void _ZN5S50C73v22Ev();
extern void _ZN5S50C73v23Ev();
extern void _ZN5S50C73v24Ev();
extern void _ZN5S50C73v25Ev();
extern void _ZN5S50C73v26Ev();
extern void _ZN5S50C73v27Ev();
extern void _ZN5S50C73v28Ev();
extern void _ZN5S50C73v29Ev();
extern void _ZN5S50C73v30Ev();
extern void _ZN5S50C73v31Ev();
extern void _ZN5S50C73v32Ev();
extern void _ZN5S50C73v33Ev();
extern void _ZN5S50C73v34Ev();
extern void _ZN5S50C73v35Ev();
extern void _ZN5S50C73v36Ev();
extern void _ZN5S50C73v37Ev();
extern void _ZN5S50C73v38Ev();
extern void _ZN5S50C73v39Ev();
extern void _ZN5S50C73v40Ev();
extern void _ZN5S50C73v41Ev();
extern void _ZN5S50C73v42Ev();
extern void _ZN5S50C73v43Ev();
extern void _ZN5S50C73v44Ev();
extern void _ZN5S50C73v45Ev();
extern void _ZN5S50C73v46Ev();
extern void _ZN5S50C73v47Ev();
extern void _ZN5S50C73v48Ev();
extern void _ZN5S50C73v49Ev();
extern void _ZN5S50C73v50Ev();
extern void _ZN5S50C73v51Ev();
extern void _ZN5S50C73v52Ev();
extern void _ZN5S50C73v53Ev();
extern void _ZN5S50C73v54Ev();
extern void _ZN5S50C73v55Ev();
extern void _ZN5S50C73v56Ev();
extern void _ZN5S50C73v57Ev();
extern void _ZN5S50C73v58Ev();
extern void _ZN5S50C73v59Ev();
extern void _ZN5S50C73v60Ev();
extern void _ZN5S50C73v61Ev();
extern void _ZN5S50C73v62Ev();
extern void _ZN5S50C73v63Ev();
extern void _ZN5S50C73v64Ev();
extern void _ZN5S50C73v65Ev();
extern void _ZN5S50C73v66Ev();
extern void _ZN5S50C73v67Ev();
extern void _ZN5S50C73v68Ev();
extern void _ZN5S50C73v69Ev();
extern void _ZN5S50C73v70Ev();
extern void _ZN5S50C73v71Ev();
extern void _ZN5S50C73v72Ev();
extern void _ZN5S50C73v73Ev();
extern void _ZN5S50C73v74Ev();
extern void _ZN5S50C63v75Ev();
extern void _ZN5S50C63v76Ev();
extern void _ZN5S50C53v77Ev();
extern void _ZN5S50C53v78Ev();
extern void _ZN5S50C53v79Ev();
extern void _ZN5S50C53v80Ev();
extern void _ZN5S50C53v81Ev();
extern void _ZN5S50C53v82Ev();
extern void _ZN5S50C53v83Ev();
extern void _ZN5S50C53v84Ev();
extern void _ZN5S50C53v85Ev();
extern void _ZN5S50C53v86Ev();
extern void _ZN5S50C53v87Ev();
extern void _ZN5S50C53v88Ev();
extern void _ZN5S50C43v89Ev();
extern void _ZN5S50C43v90Ev();
extern void _ZN5S50C43v91Ev();
extern void _ZN5S50C43v92Ev();
extern void _ZN5S50C43v93Ev();
extern void _ZN5S50C43v94Ev();
extern void _ZN5S50C43v95Ev();
extern void _ZN5S50C43v96Ev();
extern void _ZN5S50C43v97Ev();
extern void _ZN5S50C33v98Ev();
extern void _ZN5S50C33v99Ev();
extern void _ZN5S50C24v112Ev();
extern void _ZN5S50C24v113Ev();
extern void _ZN5S50C24v114Ev();
extern void _ZN5S50C24v115Ev();
extern void _ZN5S50C24v116Ev();
extern void _ZN5S50C24v117Ev();
extern void _ZN5S50C24v118Ev();
extern void _ZN5S50C24v119Ev();
extern void _ZN5S50C24v120Ev();
extern void _ZN5S50C24v121Ev();
extern void _ZN5S50C24v122Ev();
extern void _ZN5S50C24v123Ev();
extern void _ZN5S50C24v124Ev();
extern void _ZN5S50C24v125Ev();
extern void _ZN5S50C24v126Ev();
extern void _ZN5S50C24v127Ev();
extern void _ZN5S50C24v128Ev();
extern void _ZN5S50C24v129Ev();
extern void _ZN5S50C12v1Ev();
extern void _ZN5S50C12v2Ev();
extern void _ZN5S50C12v3Ev();
extern void _ZN5S50C12v4Ev();
extern void _ZN5S50C12v5Ev();
extern void _ZN5S50C12v6Ev();
extern void _ZN5S50C12v7Ev();
extern void _ZN5S50C12v8Ev();
extern void _ZN5S50C12v9Ev();
extern void _ZN5S50C13v10Ev();
extern void ABISELECT(_ZThn176_N5S50C1D1Ev,_ZThn120_N5S50C1D1Ev)();
extern void ABISELECT(_ZThn176_N5S50C1D0Ev,_ZThn120_N5S50C1D0Ev)();
extern void _ZN6S50C134v100Ev();
extern void _ZN6S50C134v101Ev();
extern void _ZN6S50C134v102Ev();
extern void _ZN6S50C134v103Ev();
extern void _ZN6S50C134v104Ev();
extern void _ZN6S50C134v105Ev();
extern void _ZN6S50C134v106Ev();
extern void _ZN6S50C134v107Ev();
extern void ABISELECT(_ZThn184_N5S50C1D1Ev,_ZThn124_N5S50C1D1Ev)();
extern void ABISELECT(_ZThn184_N5S50C1D0Ev,_ZThn124_N5S50C1D0Ev)();
extern void _ZN6S50C144v108Ev();
extern void _ZN6S50C144v109Ev();
extern void _ZN6S50C144v110Ev();
extern void _ZN6S50C144v111Ev();
static  VTBL_ENTRY vtc_S50C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S50C1[0]),
  (VTBL_ENTRY)&_ZN5S50C1D1Ev,
  (VTBL_ENTRY)&_ZN5S50C1D0Ev,
  (VTBL_ENTRY)&_ZN5S50C73v11Ev,
  (VTBL_ENTRY)&_ZN5S50C73v12Ev,
  (VTBL_ENTRY)&_ZN5S50C73v13Ev,
  (VTBL_ENTRY)&_ZN5S50C73v14Ev,
  (VTBL_ENTRY)&_ZN5S50C73v15Ev,
  (VTBL_ENTRY)&_ZN5S50C73v16Ev,
  (VTBL_ENTRY)&_ZN5S50C73v17Ev,
  (VTBL_ENTRY)&_ZN5S50C73v18Ev,
  (VTBL_ENTRY)&_ZN5S50C73v19Ev,
  (VTBL_ENTRY)&_ZN5S50C73v20Ev,
  (VTBL_ENTRY)&_ZN5S50C73v21Ev,
  (VTBL_ENTRY)&_ZN5S50C73v22Ev,
  (VTBL_ENTRY)&_ZN5S50C73v23Ev,
  (VTBL_ENTRY)&_ZN5S50C73v24Ev,
  (VTBL_ENTRY)&_ZN5S50C73v25Ev,
  (VTBL_ENTRY)&_ZN5S50C73v26Ev,
  (VTBL_ENTRY)&_ZN5S50C73v27Ev,
  (VTBL_ENTRY)&_ZN5S50C73v28Ev,
  (VTBL_ENTRY)&_ZN5S50C73v29Ev,
  (VTBL_ENTRY)&_ZN5S50C73v30Ev,
  (VTBL_ENTRY)&_ZN5S50C73v31Ev,
  (VTBL_ENTRY)&_ZN5S50C73v32Ev,
  (VTBL_ENTRY)&_ZN5S50C73v33Ev,
  (VTBL_ENTRY)&_ZN5S50C73v34Ev,
  (VTBL_ENTRY)&_ZN5S50C73v35Ev,
  (VTBL_ENTRY)&_ZN5S50C73v36Ev,
  (VTBL_ENTRY)&_ZN5S50C73v37Ev,
  (VTBL_ENTRY)&_ZN5S50C73v38Ev,
  (VTBL_ENTRY)&_ZN5S50C73v39Ev,
  (VTBL_ENTRY)&_ZN5S50C73v40Ev,
  (VTBL_ENTRY)&_ZN5S50C73v41Ev,
  (VTBL_ENTRY)&_ZN5S50C73v42Ev,
  (VTBL_ENTRY)&_ZN5S50C73v43Ev,
  (VTBL_ENTRY)&_ZN5S50C73v44Ev,
  (VTBL_ENTRY)&_ZN5S50C73v45Ev,
  (VTBL_ENTRY)&_ZN5S50C73v46Ev,
  (VTBL_ENTRY)&_ZN5S50C73v47Ev,
  (VTBL_ENTRY)&_ZN5S50C73v48Ev,
  (VTBL_ENTRY)&_ZN5S50C73v49Ev,
  (VTBL_ENTRY)&_ZN5S50C73v50Ev,
  (VTBL_ENTRY)&_ZN5S50C73v51Ev,
  (VTBL_ENTRY)&_ZN5S50C73v52Ev,
  (VTBL_ENTRY)&_ZN5S50C73v53Ev,
  (VTBL_ENTRY)&_ZN5S50C73v54Ev,
  (VTBL_ENTRY)&_ZN5S50C73v55Ev,
  (VTBL_ENTRY)&_ZN5S50C73v56Ev,
  (VTBL_ENTRY)&_ZN5S50C73v57Ev,
  (VTBL_ENTRY)&_ZN5S50C73v58Ev,
  (VTBL_ENTRY)&_ZN5S50C73v59Ev,
  (VTBL_ENTRY)&_ZN5S50C73v60Ev,
  (VTBL_ENTRY)&_ZN5S50C73v61Ev,
  (VTBL_ENTRY)&_ZN5S50C73v62Ev,
  (VTBL_ENTRY)&_ZN5S50C73v63Ev,
  (VTBL_ENTRY)&_ZN5S50C73v64Ev,
  (VTBL_ENTRY)&_ZN5S50C73v65Ev,
  (VTBL_ENTRY)&_ZN5S50C73v66Ev,
  (VTBL_ENTRY)&_ZN5S50C73v67Ev,
  (VTBL_ENTRY)&_ZN5S50C73v68Ev,
  (VTBL_ENTRY)&_ZN5S50C73v69Ev,
  (VTBL_ENTRY)&_ZN5S50C73v70Ev,
  (VTBL_ENTRY)&_ZN5S50C73v71Ev,
  (VTBL_ENTRY)&_ZN5S50C73v72Ev,
  (VTBL_ENTRY)&_ZN5S50C73v73Ev,
  (VTBL_ENTRY)&_ZN5S50C73v74Ev,
  (VTBL_ENTRY)&_ZN5S50C63v75Ev,
  (VTBL_ENTRY)&_ZN5S50C63v76Ev,
  (VTBL_ENTRY)&_ZN5S50C53v77Ev,
  (VTBL_ENTRY)&_ZN5S50C53v78Ev,
  (VTBL_ENTRY)&_ZN5S50C53v79Ev,
  (VTBL_ENTRY)&_ZN5S50C53v80Ev,
  (VTBL_ENTRY)&_ZN5S50C53v81Ev,
  (VTBL_ENTRY)&_ZN5S50C53v82Ev,
  (VTBL_ENTRY)&_ZN5S50C53v83Ev,
  (VTBL_ENTRY)&_ZN5S50C53v84Ev,
  (VTBL_ENTRY)&_ZN5S50C53v85Ev,
  (VTBL_ENTRY)&_ZN5S50C53v86Ev,
  (VTBL_ENTRY)&_ZN5S50C53v87Ev,
  (VTBL_ENTRY)&_ZN5S50C53v88Ev,
  (VTBL_ENTRY)&_ZN5S50C43v89Ev,
  (VTBL_ENTRY)&_ZN5S50C43v90Ev,
  (VTBL_ENTRY)&_ZN5S50C43v91Ev,
  (VTBL_ENTRY)&_ZN5S50C43v92Ev,
  (VTBL_ENTRY)&_ZN5S50C43v93Ev,
  (VTBL_ENTRY)&_ZN5S50C43v94Ev,
  (VTBL_ENTRY)&_ZN5S50C43v95Ev,
  (VTBL_ENTRY)&_ZN5S50C43v96Ev,
  (VTBL_ENTRY)&_ZN5S50C43v97Ev,
  (VTBL_ENTRY)&_ZN5S50C33v98Ev,
  (VTBL_ENTRY)&_ZN5S50C33v99Ev,
  (VTBL_ENTRY)&_ZN5S50C24v112Ev,
  (VTBL_ENTRY)&_ZN5S50C24v113Ev,
  (VTBL_ENTRY)&_ZN5S50C24v114Ev,
  (VTBL_ENTRY)&_ZN5S50C24v115Ev,
  (VTBL_ENTRY)&_ZN5S50C24v116Ev,
  (VTBL_ENTRY)&_ZN5S50C24v117Ev,
  (VTBL_ENTRY)&_ZN5S50C24v118Ev,
  (VTBL_ENTRY)&_ZN5S50C24v119Ev,
  (VTBL_ENTRY)&_ZN5S50C24v120Ev,
  (VTBL_ENTRY)&_ZN5S50C24v121Ev,
  (VTBL_ENTRY)&_ZN5S50C24v122Ev,
  (VTBL_ENTRY)&_ZN5S50C24v123Ev,
  (VTBL_ENTRY)&_ZN5S50C24v124Ev,
  (VTBL_ENTRY)&_ZN5S50C24v125Ev,
  (VTBL_ENTRY)&_ZN5S50C24v126Ev,
  (VTBL_ENTRY)&_ZN5S50C24v127Ev,
  (VTBL_ENTRY)&_ZN5S50C24v128Ev,
  (VTBL_ENTRY)&_ZN5S50C24v129Ev,
  (VTBL_ENTRY)&_ZN5S50C12v1Ev,
  (VTBL_ENTRY)&_ZN5S50C12v2Ev,
  (VTBL_ENTRY)&_ZN5S50C12v3Ev,
  (VTBL_ENTRY)&_ZN5S50C12v4Ev,
  (VTBL_ENTRY)&_ZN5S50C12v5Ev,
  (VTBL_ENTRY)&_ZN5S50C12v6Ev,
  (VTBL_ENTRY)&_ZN5S50C12v7Ev,
  (VTBL_ENTRY)&_ZN5S50C12v8Ev,
  (VTBL_ENTRY)&_ZN5S50C12v9Ev,
  (VTBL_ENTRY)&_ZN5S50C13v10Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI5S50C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S50C1D1Ev,_ZThn120_N5S50C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N5S50C1D0Ev,_ZThn120_N5S50C1D0Ev),
  (VTBL_ENTRY)&_ZN6S50C134v100Ev,
  (VTBL_ENTRY)&_ZN6S50C134v101Ev,
  (VTBL_ENTRY)&_ZN6S50C134v102Ev,
  (VTBL_ENTRY)&_ZN6S50C134v103Ev,
  (VTBL_ENTRY)&_ZN6S50C134v104Ev,
  (VTBL_ENTRY)&_ZN6S50C134v105Ev,
  (VTBL_ENTRY)&_ZN6S50C134v106Ev,
  (VTBL_ENTRY)&_ZN6S50C134v107Ev,
  ABISELECT(-184,-124),
  (VTBL_ENTRY)&(_ZTI5S50C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S50C1D1Ev,_ZThn124_N5S50C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N5S50C1D0Ev,_ZThn124_N5S50C1D0Ev),
  (VTBL_ENTRY)&_ZN6S50C144v108Ev,
  (VTBL_ENTRY)&_ZN6S50C144v109Ev,
  (VTBL_ENTRY)&_ZN6S50C144v110Ev,
  (VTBL_ENTRY)&_ZN6S50C144v111Ev,
};
extern VTBL_ENTRY _ZTI5S50C1[];
extern  VTBL_ENTRY _ZTV5S50C1[];
Class_Descriptor cd_S50C1 = {  "S50C1", // class name
  bases_S50C1, 8,
  &(vtc_S50C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,172), // object size
  NSPAIRA(_ZTI5S50C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S50C1),141, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C7  {
  int s88c7f0;
  __tsi64 s88c7f1;
  void *s88c7f2[4];
  int s88c7f3[2];
  void *s88c7f4;
  ::S3422C4_nt s88c7f5;
  void *s88c7f6[2];
  virtual  ~S88C7(); // _ZN5S88C7D1Ev
  virtual void  v4(); // _ZN5S88C72v4Ev
  virtual void  v5(); // _ZN5S88C72v5Ev
  virtual void  v6(); // _ZN5S88C72v6Ev
  virtual void  v7(); // _ZN5S88C72v7Ev
  virtual void  v8(); // _ZN5S88C72v8Ev
  virtual void  v9(); // _ZN5S88C72v9Ev
  virtual void  v10(); // _ZN5S88C73v10Ev
  virtual void  v11(); // _ZN5S88C73v11Ev
  virtual void  v12(); // _ZN5S88C73v12Ev
  virtual void  v13(); // _ZN5S88C73v13Ev
  virtual void  v14(); // _ZN5S88C73v14Ev
  virtual void  v15(); // _ZN5S88C73v15Ev
  virtual void  v16(); // _ZN5S88C73v16Ev
  virtual void  v17(); // _ZN5S88C73v17Ev
  virtual void  v18(); // _ZN5S88C73v18Ev
  virtual void  v19(); // _ZN5S88C73v19Ev
  virtual void  v20(); // _ZN5S88C73v20Ev
  virtual void  v21(); // _ZN5S88C73v21Ev
  virtual void  v22(); // _ZN5S88C73v22Ev
  virtual void  v23(); // _ZN5S88C73v23Ev
  virtual void  v24(); // _ZN5S88C73v24Ev
  virtual void  v25(); // _ZN5S88C73v25Ev
  virtual void  v26(); // _ZN5S88C73v26Ev
  virtual void  v27(); // _ZN5S88C73v27Ev
  virtual void  v28(); // _ZN5S88C73v28Ev
  virtual void  v29(); // _ZN5S88C73v29Ev
  virtual void  v30(); // _ZN5S88C73v30Ev
  virtual void  v31(); // _ZN5S88C73v31Ev
  virtual void  v32(); // _ZN5S88C73v32Ev
  virtual void  v33(); // _ZN5S88C73v33Ev
  virtual void  v34(); // _ZN5S88C73v34Ev
  virtual void  v35(); // _ZN5S88C73v35Ev
  virtual void  v36(); // _ZN5S88C73v36Ev
  virtual void  v37(); // _ZN5S88C73v37Ev
  virtual void  v38(); // _ZN5S88C73v38Ev
  virtual void  v39(); // _ZN5S88C73v39Ev
  virtual void  v40(); // _ZN5S88C73v40Ev
  virtual void  v41(); // _ZN5S88C73v41Ev
  virtual void  v42(); // _ZN5S88C73v42Ev
  virtual void  v43(); // _ZN5S88C73v43Ev
  virtual void  v44(); // _ZN5S88C73v44Ev
  virtual void  v45(); // _ZN5S88C73v45Ev
  virtual void  v46(); // _ZN5S88C73v46Ev
  virtual void  v47(); // _ZN5S88C73v47Ev
  virtual void  v48(); // _ZN5S88C73v48Ev
  virtual void  v49(); // _ZN5S88C73v49Ev
  virtual void  v50(); // _ZN5S88C73v50Ev
  virtual void  v51(); // _ZN5S88C73v51Ev
  virtual void  v52(); // _ZN5S88C73v52Ev
  virtual void  v53(); // _ZN5S88C73v53Ev
  virtual void  v54(); // _ZN5S88C73v54Ev
  virtual void  v55(); // _ZN5S88C73v55Ev
  virtual void  v56(); // _ZN5S88C73v56Ev
  virtual void  v57(); // _ZN5S88C73v57Ev
  virtual void  v58(); // _ZN5S88C73v58Ev
  virtual void  v59(); // _ZN5S88C73v59Ev
  virtual void  v60(); // _ZN5S88C73v60Ev
  virtual void  v61(); // _ZN5S88C73v61Ev
  virtual void  v62(); // _ZN5S88C73v62Ev
  virtual void  v63(); // _ZN5S88C73v63Ev
  virtual void  v64(); // _ZN5S88C73v64Ev
  virtual void  v65(); // _ZN5S88C73v65Ev
  virtual void  v66(); // _ZN5S88C73v66Ev
  virtual void  v67(); // _ZN5S88C73v67Ev
  S88C7(); // tgen
};
//SIG(-1 S88C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S88C7 ::~S88C7(){ note_dtor("S88C7", this);}
void  S88C7 ::v4(){vfunc_called(this, "_ZN5S88C72v4Ev");}
void  S88C7 ::v5(){vfunc_called(this, "_ZN5S88C72v5Ev");}
void  S88C7 ::v6(){vfunc_called(this, "_ZN5S88C72v6Ev");}
void  S88C7 ::v7(){vfunc_called(this, "_ZN5S88C72v7Ev");}
void  S88C7 ::v8(){vfunc_called(this, "_ZN5S88C72v8Ev");}
void  S88C7 ::v9(){vfunc_called(this, "_ZN5S88C72v9Ev");}
void  S88C7 ::v10(){vfunc_called(this, "_ZN5S88C73v10Ev");}
void  S88C7 ::v11(){vfunc_called(this, "_ZN5S88C73v11Ev");}
void  S88C7 ::v12(){vfunc_called(this, "_ZN5S88C73v12Ev");}
void  S88C7 ::v13(){vfunc_called(this, "_ZN5S88C73v13Ev");}
void  S88C7 ::v14(){vfunc_called(this, "_ZN5S88C73v14Ev");}
void  S88C7 ::v15(){vfunc_called(this, "_ZN5S88C73v15Ev");}
void  S88C7 ::v16(){vfunc_called(this, "_ZN5S88C73v16Ev");}
void  S88C7 ::v17(){vfunc_called(this, "_ZN5S88C73v17Ev");}
void  S88C7 ::v18(){vfunc_called(this, "_ZN5S88C73v18Ev");}
void  S88C7 ::v19(){vfunc_called(this, "_ZN5S88C73v19Ev");}
void  S88C7 ::v20(){vfunc_called(this, "_ZN5S88C73v20Ev");}
void  S88C7 ::v21(){vfunc_called(this, "_ZN5S88C73v21Ev");}
void  S88C7 ::v22(){vfunc_called(this, "_ZN5S88C73v22Ev");}
void  S88C7 ::v23(){vfunc_called(this, "_ZN5S88C73v23Ev");}
void  S88C7 ::v24(){vfunc_called(this, "_ZN5S88C73v24Ev");}
void  S88C7 ::v25(){vfunc_called(this, "_ZN5S88C73v25Ev");}
void  S88C7 ::v26(){vfunc_called(this, "_ZN5S88C73v26Ev");}
void  S88C7 ::v27(){vfunc_called(this, "_ZN5S88C73v27Ev");}
void  S88C7 ::v28(){vfunc_called(this, "_ZN5S88C73v28Ev");}
void  S88C7 ::v29(){vfunc_called(this, "_ZN5S88C73v29Ev");}
void  S88C7 ::v30(){vfunc_called(this, "_ZN5S88C73v30Ev");}
void  S88C7 ::v31(){vfunc_called(this, "_ZN5S88C73v31Ev");}
void  S88C7 ::v32(){vfunc_called(this, "_ZN5S88C73v32Ev");}
void  S88C7 ::v33(){vfunc_called(this, "_ZN5S88C73v33Ev");}
void  S88C7 ::v34(){vfunc_called(this, "_ZN5S88C73v34Ev");}
void  S88C7 ::v35(){vfunc_called(this, "_ZN5S88C73v35Ev");}
void  S88C7 ::v36(){vfunc_called(this, "_ZN5S88C73v36Ev");}
void  S88C7 ::v37(){vfunc_called(this, "_ZN5S88C73v37Ev");}
void  S88C7 ::v38(){vfunc_called(this, "_ZN5S88C73v38Ev");}
void  S88C7 ::v39(){vfunc_called(this, "_ZN5S88C73v39Ev");}
void  S88C7 ::v40(){vfunc_called(this, "_ZN5S88C73v40Ev");}
void  S88C7 ::v41(){vfunc_called(this, "_ZN5S88C73v41Ev");}
void  S88C7 ::v42(){vfunc_called(this, "_ZN5S88C73v42Ev");}
void  S88C7 ::v43(){vfunc_called(this, "_ZN5S88C73v43Ev");}
void  S88C7 ::v44(){vfunc_called(this, "_ZN5S88C73v44Ev");}
void  S88C7 ::v45(){vfunc_called(this, "_ZN5S88C73v45Ev");}
void  S88C7 ::v46(){vfunc_called(this, "_ZN5S88C73v46Ev");}
void  S88C7 ::v47(){vfunc_called(this, "_ZN5S88C73v47Ev");}
void  S88C7 ::v48(){vfunc_called(this, "_ZN5S88C73v48Ev");}
void  S88C7 ::v49(){vfunc_called(this, "_ZN5S88C73v49Ev");}
void  S88C7 ::v50(){vfunc_called(this, "_ZN5S88C73v50Ev");}
void  S88C7 ::v51(){vfunc_called(this, "_ZN5S88C73v51Ev");}
void  S88C7 ::v52(){vfunc_called(this, "_ZN5S88C73v52Ev");}
void  S88C7 ::v53(){vfunc_called(this, "_ZN5S88C73v53Ev");}
void  S88C7 ::v54(){vfunc_called(this, "_ZN5S88C73v54Ev");}
void  S88C7 ::v55(){vfunc_called(this, "_ZN5S88C73v55Ev");}
void  S88C7 ::v56(){vfunc_called(this, "_ZN5S88C73v56Ev");}
void  S88C7 ::v57(){vfunc_called(this, "_ZN5S88C73v57Ev");}
void  S88C7 ::v58(){vfunc_called(this, "_ZN5S88C73v58Ev");}
void  S88C7 ::v59(){vfunc_called(this, "_ZN5S88C73v59Ev");}
void  S88C7 ::v60(){vfunc_called(this, "_ZN5S88C73v60Ev");}
void  S88C7 ::v61(){vfunc_called(this, "_ZN5S88C73v61Ev");}
void  S88C7 ::v62(){vfunc_called(this, "_ZN5S88C73v62Ev");}
void  S88C7 ::v63(){vfunc_called(this, "_ZN5S88C73v63Ev");}
void  S88C7 ::v64(){vfunc_called(this, "_ZN5S88C73v64Ev");}
void  S88C7 ::v65(){vfunc_called(this, "_ZN5S88C73v65Ev");}
void  S88C7 ::v66(){vfunc_called(this, "_ZN5S88C73v66Ev");}
void  S88C7 ::v67(){vfunc_called(this, "_ZN5S88C73v67Ev");}
S88C7 ::S88C7(){ note_ctor("S88C7", this);} // tgen

static void Test_S88C7()
{
  extern Class_Descriptor cd_S88C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S88C7, buf);
    S88C7 *dp, &lv = *(dp=new (buf) S88C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S88C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C7)");
    check_field_offset(lv, s88c7f0, ABISELECT(8,4), "S88C7.s88c7f0");
    check_field_offset(lv, s88c7f1, ABISELECT(16,8), "S88C7.s88c7f1");
    check_field_offset(lv, s88c7f2, ABISELECT(24,16), "S88C7.s88c7f2");
    check_field_offset(lv, s88c7f3, ABISELECT(56,32), "S88C7.s88c7f3");
    check_field_offset(lv, s88c7f4, ABISELECT(64,40), "S88C7.s88c7f4");
    check_field_offset(lv, s88c7f5, ABISELECT(72,44), "S88C7.s88c7f5");
    check_field_offset(lv, s88c7f6, ABISELECT(80,52), "S88C7.s88c7f6");
    test_class_info(&lv, &cd_S88C7);
    dp->~S88C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C7(Test_S88C7, "S88C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S88C7C1Ev();
extern void _ZN5S88C7D1Ev();
Name_Map name_map_S88C7[] = {
  NSPAIR(_ZN5S88C7C1Ev),
  NSPAIR(_ZN5S88C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S88C7[];
extern void _ZN5S88C7D1Ev();
extern void _ZN5S88C7D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
static  VTBL_ENTRY vtc_S88C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C7[0]),
  (VTBL_ENTRY)&_ZN5S88C7D1Ev,
  (VTBL_ENTRY)&_ZN5S88C7D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
Class_Descriptor cd_S88C7 = {  "S88C7", // class name
  0,0,//no base classes
  &(vtc_S88C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S88C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S88C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C6  : S88C7 {
  virtual  ~S88C6(); // _ZN5S88C6D1Ev
  virtual void  v68(); // _ZN5S88C63v68Ev
  virtual void  v69(); // _ZN5S88C63v69Ev
  S88C6(); // tgen
};
//SIG(-1 S88C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S88C6 ::~S88C6(){ note_dtor("S88C6", this);}
void  S88C6 ::v68(){vfunc_called(this, "_ZN5S88C63v68Ev");}
void  S88C6 ::v69(){vfunc_called(this, "_ZN5S88C63v69Ev");}
S88C6 ::S88C6(){ note_ctor("S88C6", this);} // tgen

static void Test_S88C6()
{
  extern Class_Descriptor cd_S88C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S88C6, buf);
    S88C6 *dp, &lv = *(dp=new (buf) S88C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S88C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C6)");
    check_base_class_offset(lv, (S88C7*), 0, "S88C6");
    test_class_info(&lv, &cd_S88C6);
    dp->~S88C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C6(Test_S88C6, "S88C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S88C6C1Ev();
extern void _ZN5S88C6D1Ev();
Name_Map name_map_S88C6[] = {
  NSPAIR(_ZN5S88C6C1Ev),
  NSPAIR(_ZN5S88C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
static Base_Class bases_S88C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C6[];
extern void _ZN5S88C6D1Ev();
extern void _ZN5S88C6D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
static  VTBL_ENTRY vtc_S88C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C6[0]),
  (VTBL_ENTRY)&_ZN5S88C6D1Ev,
  (VTBL_ENTRY)&_ZN5S88C6D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
};
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
Class_Descriptor cd_S88C6 = {  "S88C6", // class name
  bases_S88C6, 1,
  &(vtc_S88C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S88C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S88C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C5  : S88C6 {
  char s88c5f0;
  ::S3422C23 s88c5f1;
  ::S49C12_nt s88c5f2;
  virtual  ~S88C5(); // _ZN5S88C5D1Ev
  virtual void  v70(); // _ZN5S88C53v70Ev
  virtual void  v71(); // _ZN5S88C53v71Ev
  virtual void  v72(); // _ZN5S88C53v72Ev
  virtual void  v73(); // _ZN5S88C53v73Ev
  virtual void  v74(); // _ZN5S88C53v74Ev
  virtual void  v75(); // _ZN5S88C53v75Ev
  virtual void  v76(); // _ZN5S88C53v76Ev
  virtual void  v77(); // _ZN5S88C53v77Ev
  virtual void  v78(); // _ZN5S88C53v78Ev
  virtual void  v79(); // _ZN5S88C53v79Ev
  virtual void  v80(); // _ZN5S88C53v80Ev
  virtual void  v81(); // _ZN5S88C53v81Ev
  S88C5(); // tgen
};
//SIG(-1 S88C5) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S88C5 ::~S88C5(){ note_dtor("S88C5", this);}
void  S88C5 ::v70(){vfunc_called(this, "_ZN5S88C53v70Ev");}
void  S88C5 ::v71(){vfunc_called(this, "_ZN5S88C53v71Ev");}
void  S88C5 ::v72(){vfunc_called(this, "_ZN5S88C53v72Ev");}
void  S88C5 ::v73(){vfunc_called(this, "_ZN5S88C53v73Ev");}
void  S88C5 ::v74(){vfunc_called(this, "_ZN5S88C53v74Ev");}
void  S88C5 ::v75(){vfunc_called(this, "_ZN5S88C53v75Ev");}
void  S88C5 ::v76(){vfunc_called(this, "_ZN5S88C53v76Ev");}
void  S88C5 ::v77(){vfunc_called(this, "_ZN5S88C53v77Ev");}
void  S88C5 ::v78(){vfunc_called(this, "_ZN5S88C53v78Ev");}
void  S88C5 ::v79(){vfunc_called(this, "_ZN5S88C53v79Ev");}
void  S88C5 ::v80(){vfunc_called(this, "_ZN5S88C53v80Ev");}
void  S88C5 ::v81(){vfunc_called(this, "_ZN5S88C53v81Ev");}
S88C5 ::S88C5(){ note_ctor("S88C5", this);} // tgen

static void Test_S88C5()
{
  extern Class_Descriptor cd_S88C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S88C5, buf);
    S88C5 *dp, &lv = *(dp=new (buf) S88C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S88C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C5)");
    check_base_class_offset(lv, (S88C7*)(S88C6*), 0, "S88C5");
    check_base_class_offset(lv, (S88C6*), 0, "S88C5");
    check_field_offset(lv, s88c5f0, ABISELECT(96,60), "S88C5.s88c5f0");
    check_field_offset(lv, s88c5f1, ABISELECT(104,64), "S88C5.s88c5f1");
    check_field_offset(lv, s88c5f2, ABISELECT(120,76), "S88C5.s88c5f2");
    test_class_info(&lv, &cd_S88C5);
    dp->~S88C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C5(Test_S88C5, "S88C5", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN5S88C5C1Ev();
extern void _ZN5S88C5D1Ev();
Name_Map name_map_S88C5[] = {
  NSPAIR(_ZN5S88C5C1Ev),
  NSPAIR(_ZN5S88C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
extern Class_Descriptor cd_S88C6;
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
static Base_Class bases_S88C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S88C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C5[];
extern void _ZN5S88C5D1Ev();
extern void _ZN5S88C5D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
extern void _ZN5S88C53v70Ev();
extern void _ZN5S88C53v71Ev();
extern void _ZN5S88C53v72Ev();
extern void _ZN5S88C53v73Ev();
extern void _ZN5S88C53v74Ev();
extern void _ZN5S88C53v75Ev();
extern void _ZN5S88C53v76Ev();
extern void _ZN5S88C53v77Ev();
extern void _ZN5S88C53v78Ev();
extern void _ZN5S88C53v79Ev();
extern void _ZN5S88C53v80Ev();
extern void _ZN5S88C53v81Ev();
static  VTBL_ENTRY vtc_S88C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C5[0]),
  (VTBL_ENTRY)&_ZN5S88C5D1Ev,
  (VTBL_ENTRY)&_ZN5S88C5D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
  (VTBL_ENTRY)&_ZN5S88C53v70Ev,
  (VTBL_ENTRY)&_ZN5S88C53v71Ev,
  (VTBL_ENTRY)&_ZN5S88C53v72Ev,
  (VTBL_ENTRY)&_ZN5S88C53v73Ev,
  (VTBL_ENTRY)&_ZN5S88C53v74Ev,
  (VTBL_ENTRY)&_ZN5S88C53v75Ev,
  (VTBL_ENTRY)&_ZN5S88C53v76Ev,
  (VTBL_ENTRY)&_ZN5S88C53v77Ev,
  (VTBL_ENTRY)&_ZN5S88C53v78Ev,
  (VTBL_ENTRY)&_ZN5S88C53v79Ev,
  (VTBL_ENTRY)&_ZN5S88C53v80Ev,
  (VTBL_ENTRY)&_ZN5S88C53v81Ev,
};
extern VTBL_ENTRY _ZTI5S88C5[];
extern  VTBL_ENTRY _ZTV5S88C5[];
Class_Descriptor cd_S88C5 = {  "S88C5", // class name
  bases_S88C5, 2,
  &(vtc_S88C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI5S88C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S88C5),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C4  : S88C5 {
  ::S3422C17 s88c4f0;
  virtual  ~S88C4(); // _ZN5S88C4D1Ev
  virtual void  v82(); // _ZN5S88C43v82Ev
  virtual void  v83(); // _ZN5S88C43v83Ev
  virtual void  v84(); // _ZN5S88C43v84Ev
  S88C4(); // tgen
};
//SIG(-1 S88C4) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 FC10{ BC11{ BC8}}}


 S88C4 ::~S88C4(){ note_dtor("S88C4", this);}
void  S88C4 ::v82(){vfunc_called(this, "_ZN5S88C43v82Ev");}
void  S88C4 ::v83(){vfunc_called(this, "_ZN5S88C43v83Ev");}
void  S88C4 ::v84(){vfunc_called(this, "_ZN5S88C43v84Ev");}
S88C4 ::S88C4(){ note_ctor("S88C4", this);} // tgen

static void Test_S88C4()
{
  extern Class_Descriptor cd_S88C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,26)];
    init_test(&cd_S88C4, buf);
    S88C4 *dp, &lv = *(dp=new (buf) S88C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,100), "sizeof(S88C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C4)");
    check_base_class_offset(lv, (S88C7*)(S88C6*)(S88C5*), 0, "S88C4");
    check_base_class_offset(lv, (S88C6*)(S88C5*), 0, "S88C4");
    check_base_class_offset(lv, (S88C5*), 0, "S88C4");
    check_field_offset(lv, s88c4f0, ABISELECT(136,88), "S88C4.s88c4f0");
    test_class_info(&lv, &cd_S88C4);
    dp->~S88C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C4(Test_S88C4, "S88C4", ABISELECT(152,100));

#else // __cplusplus

extern void _ZN5S88C4C1Ev();
extern void _ZN5S88C4D1Ev();
Name_Map name_map_S88C4[] = {
  NSPAIR(_ZN5S88C4C1Ev),
  NSPAIR(_ZN5S88C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
extern Class_Descriptor cd_S88C6;
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
extern Class_Descriptor cd_S88C5;
extern VTBL_ENTRY _ZTI5S88C5[];
extern  VTBL_ENTRY _ZTV5S88C5[];
static Base_Class bases_S88C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S88C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S88C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C4[];
extern void _ZN5S88C4D1Ev();
extern void _ZN5S88C4D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
extern void _ZN5S88C53v70Ev();
extern void _ZN5S88C53v71Ev();
extern void _ZN5S88C53v72Ev();
extern void _ZN5S88C53v73Ev();
extern void _ZN5S88C53v74Ev();
extern void _ZN5S88C53v75Ev();
extern void _ZN5S88C53v76Ev();
extern void _ZN5S88C53v77Ev();
extern void _ZN5S88C53v78Ev();
extern void _ZN5S88C53v79Ev();
extern void _ZN5S88C53v80Ev();
extern void _ZN5S88C53v81Ev();
extern void _ZN5S88C43v82Ev();
extern void _ZN5S88C43v83Ev();
extern void _ZN5S88C43v84Ev();
static  VTBL_ENTRY vtc_S88C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C4[0]),
  (VTBL_ENTRY)&_ZN5S88C4D1Ev,
  (VTBL_ENTRY)&_ZN5S88C4D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
  (VTBL_ENTRY)&_ZN5S88C53v70Ev,
  (VTBL_ENTRY)&_ZN5S88C53v71Ev,
  (VTBL_ENTRY)&_ZN5S88C53v72Ev,
  (VTBL_ENTRY)&_ZN5S88C53v73Ev,
  (VTBL_ENTRY)&_ZN5S88C53v74Ev,
  (VTBL_ENTRY)&_ZN5S88C53v75Ev,
  (VTBL_ENTRY)&_ZN5S88C53v76Ev,
  (VTBL_ENTRY)&_ZN5S88C53v77Ev,
  (VTBL_ENTRY)&_ZN5S88C53v78Ev,
  (VTBL_ENTRY)&_ZN5S88C53v79Ev,
  (VTBL_ENTRY)&_ZN5S88C53v80Ev,
  (VTBL_ENTRY)&_ZN5S88C53v81Ev,
  (VTBL_ENTRY)&_ZN5S88C43v82Ev,
  (VTBL_ENTRY)&_ZN5S88C43v83Ev,
  (VTBL_ENTRY)&_ZN5S88C43v84Ev,
};
extern VTBL_ENTRY _ZTI5S88C4[];
extern  VTBL_ENTRY _ZTV5S88C4[];
Class_Descriptor cd_S88C4 = {  "S88C4", // class name
  bases_S88C4, 3,
  &(vtc_S88C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,100), // object size
  NSPAIRA(_ZTI5S88C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S88C4),85, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C15  {
  virtual  ~S88C15(); // _ZN6S88C15D1Ev
  virtual void  v85(); // _ZN6S88C153v85Ev
  virtual void  v86(); // _ZN6S88C153v86Ev
  virtual void  v87(); // _ZN6S88C153v87Ev
  virtual void  v88(); // _ZN6S88C153v88Ev
  S88C15(); // tgen
};
//SIG(-1 S88C15) C1{ vd v1 v2 v3 v4}


 S88C15 ::~S88C15(){ note_dtor("S88C15", this);}
void  S88C15 ::v85(){vfunc_called(this, "_ZN6S88C153v85Ev");}
void  S88C15 ::v86(){vfunc_called(this, "_ZN6S88C153v86Ev");}
void  S88C15 ::v87(){vfunc_called(this, "_ZN6S88C153v87Ev");}
void  S88C15 ::v88(){vfunc_called(this, "_ZN6S88C153v88Ev");}
S88C15 ::S88C15(){ note_ctor("S88C15", this);} // tgen

static void Test_S88C15()
{
  extern Class_Descriptor cd_S88C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S88C15, buf);
    S88C15 *dp, &lv = *(dp=new (buf) S88C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S88C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C15)");
    test_class_info(&lv, &cd_S88C15);
    dp->~S88C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C15(Test_S88C15, "S88C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S88C15C1Ev();
extern void _ZN6S88C15D1Ev();
Name_Map name_map_S88C15[] = {
  NSPAIR(_ZN6S88C15C1Ev),
  NSPAIR(_ZN6S88C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S88C15[];
extern void _ZN6S88C15D1Ev();
extern void _ZN6S88C15D0Ev();
extern void _ZN6S88C153v85Ev();
extern void _ZN6S88C153v86Ev();
extern void _ZN6S88C153v87Ev();
extern void _ZN6S88C153v88Ev();
static  VTBL_ENTRY vtc_S88C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S88C15[0]),
  (VTBL_ENTRY)&_ZN6S88C15D1Ev,
  (VTBL_ENTRY)&_ZN6S88C15D0Ev,
  (VTBL_ENTRY)&_ZN6S88C153v85Ev,
  (VTBL_ENTRY)&_ZN6S88C153v86Ev,
  (VTBL_ENTRY)&_ZN6S88C153v87Ev,
  (VTBL_ENTRY)&_ZN6S88C153v88Ev,
};
extern VTBL_ENTRY _ZTI6S88C15[];
extern  VTBL_ENTRY _ZTV6S88C15[];
Class_Descriptor cd_S88C15 = {  "S88C15", // class name
  0,0,//no base classes
  &(vtc_S88C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S88C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S88C15),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C3  : S88C4 , S88C15 {
  virtual  ~S88C3(); // _ZN5S88C3D1Ev
  virtual void  v89(); // _ZN5S88C33v89Ev
  virtual void  v90(); // _ZN5S88C33v90Ev
  virtual void  v91(); // _ZN5S88C33v91Ev
  virtual void  v92(); // _ZN5S88C33v92Ev
  virtual void  v93(); // _ZN5S88C33v93Ev
  virtual void  v94(); // _ZN5S88C33v94Ev
  virtual void  v95(); // _ZN5S88C33v95Ev
  virtual void  v96(); // _ZN5S88C33v96Ev
  virtual void  v97(); // _ZN5S88C33v97Ev
  S88C3(); // tgen
};
//SIG(-1 S88C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v88 v89 v90 FC11{ BC12{ BC9}}} BC13{ vd v91 v92 v93 v94} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S88C3 ::~S88C3(){ note_dtor("S88C3", this);}
void  S88C3 ::v89(){vfunc_called(this, "_ZN5S88C33v89Ev");}
void  S88C3 ::v90(){vfunc_called(this, "_ZN5S88C33v90Ev");}
void  S88C3 ::v91(){vfunc_called(this, "_ZN5S88C33v91Ev");}
void  S88C3 ::v92(){vfunc_called(this, "_ZN5S88C33v92Ev");}
void  S88C3 ::v93(){vfunc_called(this, "_ZN5S88C33v93Ev");}
void  S88C3 ::v94(){vfunc_called(this, "_ZN5S88C33v94Ev");}
void  S88C3 ::v95(){vfunc_called(this, "_ZN5S88C33v95Ev");}
void  S88C3 ::v96(){vfunc_called(this, "_ZN5S88C33v96Ev");}
void  S88C3 ::v97(){vfunc_called(this, "_ZN5S88C33v97Ev");}
S88C3 ::S88C3(){ note_ctor("S88C3", this);} // tgen

static void Test_S88C3()
{
  extern Class_Descriptor cd_S88C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,27)];
    init_test(&cd_S88C3, buf);
    S88C3 *dp, &lv = *(dp=new (buf) S88C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,104), "sizeof(S88C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C3)");
    check_base_class_offset(lv, (S88C7*)(S88C6*)(S88C5*)(S88C4*), 0, "S88C3");
    check_base_class_offset(lv, (S88C6*)(S88C5*)(S88C4*), 0, "S88C3");
    check_base_class_offset(lv, (S88C5*)(S88C4*), 0, "S88C3");
    check_base_class_offset(lv, (S88C4*), 0, "S88C3");
    check_base_class_offset(lv, (S88C15*), ABISELECT(152,100), "S88C3");
    test_class_info(&lv, &cd_S88C3);
    dp->~S88C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C3(Test_S88C3, "S88C3", ABISELECT(160,104));

#else // __cplusplus

extern void _ZN5S88C3C1Ev();
extern void _ZN5S88C3D1Ev();
Name_Map name_map_S88C3[] = {
  NSPAIR(_ZN5S88C3C1Ev),
  NSPAIR(_ZN5S88C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
extern Class_Descriptor cd_S88C6;
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
extern Class_Descriptor cd_S88C5;
extern VTBL_ENTRY _ZTI5S88C5[];
extern  VTBL_ENTRY _ZTV5S88C5[];
extern Class_Descriptor cd_S88C4;
extern VTBL_ENTRY _ZTI5S88C4[];
extern  VTBL_ENTRY _ZTV5S88C4[];
extern Class_Descriptor cd_S88C15;
extern VTBL_ENTRY _ZTI6S88C15[];
extern  VTBL_ENTRY _ZTV6S88C15[];
static Base_Class bases_S88C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S88C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S88C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S88C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S88C15,    ABISELECT(152,100), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C3[];
extern void _ZN5S88C3D1Ev();
extern void _ZN5S88C3D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
extern void _ZN5S88C53v70Ev();
extern void _ZN5S88C53v71Ev();
extern void _ZN5S88C53v72Ev();
extern void _ZN5S88C53v73Ev();
extern void _ZN5S88C53v74Ev();
extern void _ZN5S88C53v75Ev();
extern void _ZN5S88C53v76Ev();
extern void _ZN5S88C53v77Ev();
extern void _ZN5S88C53v78Ev();
extern void _ZN5S88C53v79Ev();
extern void _ZN5S88C53v80Ev();
extern void _ZN5S88C53v81Ev();
extern void _ZN5S88C43v82Ev();
extern void _ZN5S88C43v83Ev();
extern void _ZN5S88C43v84Ev();
extern void _ZN5S88C33v89Ev();
extern void _ZN5S88C33v90Ev();
extern void _ZN5S88C33v91Ev();
extern void _ZN5S88C33v92Ev();
extern void _ZN5S88C33v93Ev();
extern void _ZN5S88C33v94Ev();
extern void _ZN5S88C33v95Ev();
extern void _ZN5S88C33v96Ev();
extern void _ZN5S88C33v97Ev();
extern void ABISELECT(_ZThn152_N5S88C3D1Ev,_ZThn100_N5S88C3D1Ev)();
extern void ABISELECT(_ZThn152_N5S88C3D0Ev,_ZThn100_N5S88C3D0Ev)();
extern void _ZN6S88C153v85Ev();
extern void _ZN6S88C153v86Ev();
extern void _ZN6S88C153v87Ev();
extern void _ZN6S88C153v88Ev();
static  VTBL_ENTRY vtc_S88C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C3[0]),
  (VTBL_ENTRY)&_ZN5S88C3D1Ev,
  (VTBL_ENTRY)&_ZN5S88C3D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
  (VTBL_ENTRY)&_ZN5S88C53v70Ev,
  (VTBL_ENTRY)&_ZN5S88C53v71Ev,
  (VTBL_ENTRY)&_ZN5S88C53v72Ev,
  (VTBL_ENTRY)&_ZN5S88C53v73Ev,
  (VTBL_ENTRY)&_ZN5S88C53v74Ev,
  (VTBL_ENTRY)&_ZN5S88C53v75Ev,
  (VTBL_ENTRY)&_ZN5S88C53v76Ev,
  (VTBL_ENTRY)&_ZN5S88C53v77Ev,
  (VTBL_ENTRY)&_ZN5S88C53v78Ev,
  (VTBL_ENTRY)&_ZN5S88C53v79Ev,
  (VTBL_ENTRY)&_ZN5S88C53v80Ev,
  (VTBL_ENTRY)&_ZN5S88C53v81Ev,
  (VTBL_ENTRY)&_ZN5S88C43v82Ev,
  (VTBL_ENTRY)&_ZN5S88C43v83Ev,
  (VTBL_ENTRY)&_ZN5S88C43v84Ev,
  (VTBL_ENTRY)&_ZN5S88C33v89Ev,
  (VTBL_ENTRY)&_ZN5S88C33v90Ev,
  (VTBL_ENTRY)&_ZN5S88C33v91Ev,
  (VTBL_ENTRY)&_ZN5S88C33v92Ev,
  (VTBL_ENTRY)&_ZN5S88C33v93Ev,
  (VTBL_ENTRY)&_ZN5S88C33v94Ev,
  (VTBL_ENTRY)&_ZN5S88C33v95Ev,
  (VTBL_ENTRY)&_ZN5S88C33v96Ev,
  (VTBL_ENTRY)&_ZN5S88C33v97Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S88C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C3D1Ev,_ZThn100_N5S88C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C3D0Ev,_ZThn100_N5S88C3D0Ev),
  (VTBL_ENTRY)&_ZN6S88C153v85Ev,
  (VTBL_ENTRY)&_ZN6S88C153v86Ev,
  (VTBL_ENTRY)&_ZN6S88C153v87Ev,
  (VTBL_ENTRY)&_ZN6S88C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S88C3[];
extern  VTBL_ENTRY _ZTV5S88C3[];
Class_Descriptor cd_S88C3 = {  "S88C3", // class name
  bases_S88C3, 5,
  &(vtc_S88C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,104), // object size
  NSPAIRA(_ZTI5S88C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5S88C3),102, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C2  : S88C3 {
  unsigned int s88c2f0:1;
  unsigned int s88c2f1:1;
  unsigned int s88c2f2:1;
  unsigned int s88c2f3:1;
  ::S3422C22_nt s88c2f4;
  virtual  ~S88C2(); // _ZN5S88C2D1Ev
  virtual void  v98(); // _ZN5S88C23v98Ev
  virtual void  v99(); // _ZN5S88C23v99Ev
  virtual void  v100(); // _ZN5S88C24v100Ev
  virtual void  v101(); // _ZN5S88C24v101Ev
  virtual void  v102(); // _ZN5S88C24v102Ev
  S88C2(); // tgen
};
//SIG(-1 S88C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v84 v85 v86 FC12{ BC13{ BC10}}} BC14{ vd v87 v88 v89 v90} vd v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC8}}


 S88C2 ::~S88C2(){ note_dtor("S88C2", this);}
void  S88C2 ::v98(){vfunc_called(this, "_ZN5S88C23v98Ev");}
void  S88C2 ::v99(){vfunc_called(this, "_ZN5S88C23v99Ev");}
void  S88C2 ::v100(){vfunc_called(this, "_ZN5S88C24v100Ev");}
void  S88C2 ::v101(){vfunc_called(this, "_ZN5S88C24v101Ev");}
void  S88C2 ::v102(){vfunc_called(this, "_ZN5S88C24v102Ev");}
S88C2 ::S88C2(){ note_ctor("S88C2", this);} // tgen

static void Test_S88C2()
{
  extern Class_Descriptor cd_S88C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S88C2, buf);
    S88C2 *dp, &lv = *(dp=new (buf) S88C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S88C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C2)");
    check_base_class_offset(lv, (S88C7*)(S88C6*)(S88C5*)(S88C4*)(S88C3*), 0, "S88C2");
    check_base_class_offset(lv, (S88C6*)(S88C5*)(S88C4*)(S88C3*), 0, "S88C2");
    check_base_class_offset(lv, (S88C5*)(S88C4*)(S88C3*), 0, "S88C2");
    check_base_class_offset(lv, (S88C4*)(S88C3*), 0, "S88C2");
    check_base_class_offset(lv, (S88C15*)(S88C3*), ABISELECT(152,100), "S88C2");
    check_base_class_offset(lv, (S88C3*), 0, "S88C2");
    set_bf_and_test(lv, s88c2f0, ABISELECT(160,104), 0, 1, 1, "S88C2");
    set_bf_and_test(lv, s88c2f1, ABISELECT(160,104), 1, 1, 1, "S88C2");
    set_bf_and_test(lv, s88c2f2, ABISELECT(160,104), 2, 1, 1, "S88C2");
    set_bf_and_test(lv, s88c2f3, ABISELECT(160,104), 3, 1, 1, "S88C2");
    check_field_offset(lv, s88c2f4, ABISELECT(168,108), "S88C2.s88c2f4");
    test_class_info(&lv, &cd_S88C2);
    dp->~S88C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C2(Test_S88C2, "S88C2", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN5S88C2C1Ev();
extern void _ZN5S88C2D1Ev();
Name_Map name_map_S88C2[] = {
  NSPAIR(_ZN5S88C2C1Ev),
  NSPAIR(_ZN5S88C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
extern Class_Descriptor cd_S88C6;
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
extern Class_Descriptor cd_S88C5;
extern VTBL_ENTRY _ZTI5S88C5[];
extern  VTBL_ENTRY _ZTV5S88C5[];
extern Class_Descriptor cd_S88C4;
extern VTBL_ENTRY _ZTI5S88C4[];
extern  VTBL_ENTRY _ZTV5S88C4[];
extern Class_Descriptor cd_S88C15;
extern VTBL_ENTRY _ZTI6S88C15[];
extern  VTBL_ENTRY _ZTV6S88C15[];
extern Class_Descriptor cd_S88C3;
extern VTBL_ENTRY _ZTI5S88C3[];
extern  VTBL_ENTRY _ZTV5S88C3[];
static Base_Class bases_S88C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S88C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S88C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S88C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S88C15,    ABISELECT(152,100), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S88C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C2[];
extern void _ZN5S88C2D1Ev();
extern void _ZN5S88C2D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
extern void _ZN5S88C53v70Ev();
extern void _ZN5S88C53v71Ev();
extern void _ZN5S88C53v72Ev();
extern void _ZN5S88C53v73Ev();
extern void _ZN5S88C53v74Ev();
extern void _ZN5S88C53v75Ev();
extern void _ZN5S88C53v76Ev();
extern void _ZN5S88C53v77Ev();
extern void _ZN5S88C53v78Ev();
extern void _ZN5S88C53v79Ev();
extern void _ZN5S88C53v80Ev();
extern void _ZN5S88C53v81Ev();
extern void _ZN5S88C43v82Ev();
extern void _ZN5S88C43v83Ev();
extern void _ZN5S88C43v84Ev();
extern void _ZN5S88C33v89Ev();
extern void _ZN5S88C33v90Ev();
extern void _ZN5S88C33v91Ev();
extern void _ZN5S88C33v92Ev();
extern void _ZN5S88C33v93Ev();
extern void _ZN5S88C33v94Ev();
extern void _ZN5S88C33v95Ev();
extern void _ZN5S88C33v96Ev();
extern void _ZN5S88C33v97Ev();
extern void _ZN5S88C23v98Ev();
extern void _ZN5S88C23v99Ev();
extern void _ZN5S88C24v100Ev();
extern void _ZN5S88C24v101Ev();
extern void _ZN5S88C24v102Ev();
extern void ABISELECT(_ZThn152_N5S88C2D1Ev,_ZThn100_N5S88C2D1Ev)();
extern void ABISELECT(_ZThn152_N5S88C2D0Ev,_ZThn100_N5S88C2D0Ev)();
extern void _ZN6S88C153v85Ev();
extern void _ZN6S88C153v86Ev();
extern void _ZN6S88C153v87Ev();
extern void _ZN6S88C153v88Ev();
static  VTBL_ENTRY vtc_S88C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C2[0]),
  (VTBL_ENTRY)&_ZN5S88C2D1Ev,
  (VTBL_ENTRY)&_ZN5S88C2D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
  (VTBL_ENTRY)&_ZN5S88C53v70Ev,
  (VTBL_ENTRY)&_ZN5S88C53v71Ev,
  (VTBL_ENTRY)&_ZN5S88C53v72Ev,
  (VTBL_ENTRY)&_ZN5S88C53v73Ev,
  (VTBL_ENTRY)&_ZN5S88C53v74Ev,
  (VTBL_ENTRY)&_ZN5S88C53v75Ev,
  (VTBL_ENTRY)&_ZN5S88C53v76Ev,
  (VTBL_ENTRY)&_ZN5S88C53v77Ev,
  (VTBL_ENTRY)&_ZN5S88C53v78Ev,
  (VTBL_ENTRY)&_ZN5S88C53v79Ev,
  (VTBL_ENTRY)&_ZN5S88C53v80Ev,
  (VTBL_ENTRY)&_ZN5S88C53v81Ev,
  (VTBL_ENTRY)&_ZN5S88C43v82Ev,
  (VTBL_ENTRY)&_ZN5S88C43v83Ev,
  (VTBL_ENTRY)&_ZN5S88C43v84Ev,
  (VTBL_ENTRY)&_ZN5S88C33v89Ev,
  (VTBL_ENTRY)&_ZN5S88C33v90Ev,
  (VTBL_ENTRY)&_ZN5S88C33v91Ev,
  (VTBL_ENTRY)&_ZN5S88C33v92Ev,
  (VTBL_ENTRY)&_ZN5S88C33v93Ev,
  (VTBL_ENTRY)&_ZN5S88C33v94Ev,
  (VTBL_ENTRY)&_ZN5S88C33v95Ev,
  (VTBL_ENTRY)&_ZN5S88C33v96Ev,
  (VTBL_ENTRY)&_ZN5S88C33v97Ev,
  (VTBL_ENTRY)&_ZN5S88C23v98Ev,
  (VTBL_ENTRY)&_ZN5S88C23v99Ev,
  (VTBL_ENTRY)&_ZN5S88C24v100Ev,
  (VTBL_ENTRY)&_ZN5S88C24v101Ev,
  (VTBL_ENTRY)&_ZN5S88C24v102Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S88C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C2D1Ev,_ZThn100_N5S88C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C2D0Ev,_ZThn100_N5S88C2D0Ev),
  (VTBL_ENTRY)&_ZN6S88C153v85Ev,
  (VTBL_ENTRY)&_ZN6S88C153v86Ev,
  (VTBL_ENTRY)&_ZN6S88C153v87Ev,
  (VTBL_ENTRY)&_ZN6S88C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S88C2[];
extern  VTBL_ENTRY _ZTV5S88C2[];
Class_Descriptor cd_S88C2 = {  "S88C2", // class name
  bases_S88C2, 6,
  &(vtc_S88C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI5S88C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S88C2),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C21_nt  {
  int s88c21f0[4];
  unsigned int s88c21f1:1;
  void  mf88c21(); // _ZN9S88C21_nt7mf88c21Ev
};
//SIG(-1 S88C21_nt) C1{ m Fi[4] Fi:1}


void  S88C21_nt ::mf88c21(){}

//skip512 S88C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S88C1  : S88C2 {
  char s88c1f0[2];
  ::S3422C11 s88c1f1;
  ::S3422C22_nt s88c1f2;
  ::S3422C4_nt s88c1f3;
  ::S3422C22_nt s88c1f4;
  ::S3422C22_nt s88c1f5;
  ::S3422C22_nt s88c1f6;
  unsigned int s88c1f7:1;
  unsigned int s88c1f8:1;
  unsigned int s88c1f9:1;
  unsigned int s88c1f10:1;
  unsigned int s88c1f11:1;
  int s88c1f12;
  ::S88C21_nt s88c1f13;
  virtual  ~S88C1(); // _ZN5S88C1D1Ev
  virtual void  v1(); // _ZN5S88C12v1Ev
  virtual void  v2(); // _ZN5S88C12v2Ev
  virtual void  v3(); // _ZN5S88C12v3Ev
  S88C1(); // tgen
};
//SIG(1 S88C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} vd v82 v83 v84 FC13{ BC14{ BC11}}} BC15{ vd v85 v86 v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC9}} vd v1 v2 v3 Fc[2] FC17{ BC18{ BC11}} FC16 FC8 FC16 FC16 FC16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC19{ m Fi[4] Fi:1}}


 S88C1 ::~S88C1(){ note_dtor("S88C1", this);}
void  S88C1 ::v1(){vfunc_called(this, "_ZN5S88C12v1Ev");}
void  S88C1 ::v2(){vfunc_called(this, "_ZN5S88C12v2Ev");}
void  S88C1 ::v3(){vfunc_called(this, "_ZN5S88C12v3Ev");}
S88C1 ::S88C1(){ note_ctor("S88C1", this);} // tgen

static void Test_S88C1()
{
  extern Class_Descriptor cd_S88C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,56)];
    init_test(&cd_S88C1, buf);
    S88C1 *dp, &lv = *(dp=new (buf) S88C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,220), "sizeof(S88C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S88C1)");
    check_base_class_offset(lv, (S88C7*)(S88C6*)(S88C5*)(S88C4*)(S88C3*)(S88C2*), 0, "S88C1");
    check_base_class_offset(lv, (S88C6*)(S88C5*)(S88C4*)(S88C3*)(S88C2*), 0, "S88C1");
    check_base_class_offset(lv, (S88C5*)(S88C4*)(S88C3*)(S88C2*), 0, "S88C1");
    check_base_class_offset(lv, (S88C4*)(S88C3*)(S88C2*), 0, "S88C1");
    check_base_class_offset(lv, (S88C15*)(S88C3*)(S88C2*), ABISELECT(152,100), "S88C1");
    check_base_class_offset(lv, (S88C3*)(S88C2*), 0, "S88C1");
    check_base_class_offset(lv, (S88C2*), 0, "S88C1");
    check_field_offset(lv, s88c1f0, ABISELECT(184,120), "S88C1.s88c1f0");
    check_field_offset(lv, s88c1f1, ABISELECT(192,124), "S88C1.s88c1f1");
    check_field_offset(lv, s88c1f2, ABISELECT(208,136), "S88C1.s88c1f2");
    check_field_offset(lv, s88c1f3, ABISELECT(224,148), "S88C1.s88c1f3");
    check_field_offset(lv, s88c1f4, ABISELECT(232,156), "S88C1.s88c1f4");
    check_field_offset(lv, s88c1f5, ABISELECT(248,168), "S88C1.s88c1f5");
    check_field_offset(lv, s88c1f6, ABISELECT(264,180), "S88C1.s88c1f6");
    set_bf_and_test(lv, s88c1f7, ABISELECT(280,192), 0, 1, 1, "S88C1");
    set_bf_and_test(lv, s88c1f8, ABISELECT(280,192), 1, 1, 1, "S88C1");
    set_bf_and_test(lv, s88c1f9, ABISELECT(280,192), 2, 1, 1, "S88C1");
    set_bf_and_test(lv, s88c1f10, ABISELECT(280,192), 3, 1, 1, "S88C1");
    set_bf_and_test(lv, s88c1f11, ABISELECT(280,192), 4, 1, 1, "S88C1");
    check_field_offset(lv, s88c1f12, ABISELECT(284,196), "S88C1.s88c1f12");
    check_field_offset(lv, s88c1f13, ABISELECT(288,200), "S88C1.s88c1f13");
    test_class_info(&lv, &cd_S88C1);
    dp->~S88C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS88C1(Test_S88C1, "S88C1", ABISELECT(312,220));

#else // __cplusplus

extern void _ZN5S88C1C1Ev();
extern void _ZN5S88C1D1Ev();
Name_Map name_map_S88C1[] = {
  NSPAIR(_ZN5S88C1C1Ev),
  NSPAIR(_ZN5S88C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S88C7;
extern VTBL_ENTRY _ZTI5S88C7[];
extern  VTBL_ENTRY _ZTV5S88C7[];
extern Class_Descriptor cd_S88C6;
extern VTBL_ENTRY _ZTI5S88C6[];
extern  VTBL_ENTRY _ZTV5S88C6[];
extern Class_Descriptor cd_S88C5;
extern VTBL_ENTRY _ZTI5S88C5[];
extern  VTBL_ENTRY _ZTV5S88C5[];
extern Class_Descriptor cd_S88C4;
extern VTBL_ENTRY _ZTI5S88C4[];
extern  VTBL_ENTRY _ZTV5S88C4[];
extern Class_Descriptor cd_S88C15;
extern VTBL_ENTRY _ZTI6S88C15[];
extern  VTBL_ENTRY _ZTV6S88C15[];
extern Class_Descriptor cd_S88C3;
extern VTBL_ENTRY _ZTI5S88C3[];
extern  VTBL_ENTRY _ZTV5S88C3[];
extern Class_Descriptor cd_S88C2;
extern VTBL_ENTRY _ZTI5S88C2[];
extern  VTBL_ENTRY _ZTV5S88C2[];
static Base_Class bases_S88C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S88C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S88C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S88C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S88C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S88C15,    ABISELECT(152,100), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S88C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S88C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S88C1[];
extern void _ZN5S88C1D1Ev();
extern void _ZN5S88C1D0Ev();
extern void _ZN5S88C72v4Ev();
extern void _ZN5S88C72v5Ev();
extern void _ZN5S88C72v6Ev();
extern void _ZN5S88C72v7Ev();
extern void _ZN5S88C72v8Ev();
extern void _ZN5S88C72v9Ev();
extern void _ZN5S88C73v10Ev();
extern void _ZN5S88C73v11Ev();
extern void _ZN5S88C73v12Ev();
extern void _ZN5S88C73v13Ev();
extern void _ZN5S88C73v14Ev();
extern void _ZN5S88C73v15Ev();
extern void _ZN5S88C73v16Ev();
extern void _ZN5S88C73v17Ev();
extern void _ZN5S88C73v18Ev();
extern void _ZN5S88C73v19Ev();
extern void _ZN5S88C73v20Ev();
extern void _ZN5S88C73v21Ev();
extern void _ZN5S88C73v22Ev();
extern void _ZN5S88C73v23Ev();
extern void _ZN5S88C73v24Ev();
extern void _ZN5S88C73v25Ev();
extern void _ZN5S88C73v26Ev();
extern void _ZN5S88C73v27Ev();
extern void _ZN5S88C73v28Ev();
extern void _ZN5S88C73v29Ev();
extern void _ZN5S88C73v30Ev();
extern void _ZN5S88C73v31Ev();
extern void _ZN5S88C73v32Ev();
extern void _ZN5S88C73v33Ev();
extern void _ZN5S88C73v34Ev();
extern void _ZN5S88C73v35Ev();
extern void _ZN5S88C73v36Ev();
extern void _ZN5S88C73v37Ev();
extern void _ZN5S88C73v38Ev();
extern void _ZN5S88C73v39Ev();
extern void _ZN5S88C73v40Ev();
extern void _ZN5S88C73v41Ev();
extern void _ZN5S88C73v42Ev();
extern void _ZN5S88C73v43Ev();
extern void _ZN5S88C73v44Ev();
extern void _ZN5S88C73v45Ev();
extern void _ZN5S88C73v46Ev();
extern void _ZN5S88C73v47Ev();
extern void _ZN5S88C73v48Ev();
extern void _ZN5S88C73v49Ev();
extern void _ZN5S88C73v50Ev();
extern void _ZN5S88C73v51Ev();
extern void _ZN5S88C73v52Ev();
extern void _ZN5S88C73v53Ev();
extern void _ZN5S88C73v54Ev();
extern void _ZN5S88C73v55Ev();
extern void _ZN5S88C73v56Ev();
extern void _ZN5S88C73v57Ev();
extern void _ZN5S88C73v58Ev();
extern void _ZN5S88C73v59Ev();
extern void _ZN5S88C73v60Ev();
extern void _ZN5S88C73v61Ev();
extern void _ZN5S88C73v62Ev();
extern void _ZN5S88C73v63Ev();
extern void _ZN5S88C73v64Ev();
extern void _ZN5S88C73v65Ev();
extern void _ZN5S88C73v66Ev();
extern void _ZN5S88C73v67Ev();
extern void _ZN5S88C63v68Ev();
extern void _ZN5S88C63v69Ev();
extern void _ZN5S88C53v70Ev();
extern void _ZN5S88C53v71Ev();
extern void _ZN5S88C53v72Ev();
extern void _ZN5S88C53v73Ev();
extern void _ZN5S88C53v74Ev();
extern void _ZN5S88C53v75Ev();
extern void _ZN5S88C53v76Ev();
extern void _ZN5S88C53v77Ev();
extern void _ZN5S88C53v78Ev();
extern void _ZN5S88C53v79Ev();
extern void _ZN5S88C53v80Ev();
extern void _ZN5S88C53v81Ev();
extern void _ZN5S88C43v82Ev();
extern void _ZN5S88C43v83Ev();
extern void _ZN5S88C43v84Ev();
extern void _ZN5S88C33v89Ev();
extern void _ZN5S88C33v90Ev();
extern void _ZN5S88C33v91Ev();
extern void _ZN5S88C33v92Ev();
extern void _ZN5S88C33v93Ev();
extern void _ZN5S88C33v94Ev();
extern void _ZN5S88C33v95Ev();
extern void _ZN5S88C33v96Ev();
extern void _ZN5S88C33v97Ev();
extern void _ZN5S88C23v98Ev();
extern void _ZN5S88C23v99Ev();
extern void _ZN5S88C24v100Ev();
extern void _ZN5S88C24v101Ev();
extern void _ZN5S88C24v102Ev();
extern void _ZN5S88C12v1Ev();
extern void _ZN5S88C12v2Ev();
extern void _ZN5S88C12v3Ev();
extern void ABISELECT(_ZThn152_N5S88C1D1Ev,_ZThn100_N5S88C1D1Ev)();
extern void ABISELECT(_ZThn152_N5S88C1D0Ev,_ZThn100_N5S88C1D0Ev)();
extern void _ZN6S88C153v85Ev();
extern void _ZN6S88C153v86Ev();
extern void _ZN6S88C153v87Ev();
extern void _ZN6S88C153v88Ev();
static  VTBL_ENTRY vtc_S88C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S88C1[0]),
  (VTBL_ENTRY)&_ZN5S88C1D1Ev,
  (VTBL_ENTRY)&_ZN5S88C1D0Ev,
  (VTBL_ENTRY)&_ZN5S88C72v4Ev,
  (VTBL_ENTRY)&_ZN5S88C72v5Ev,
  (VTBL_ENTRY)&_ZN5S88C72v6Ev,
  (VTBL_ENTRY)&_ZN5S88C72v7Ev,
  (VTBL_ENTRY)&_ZN5S88C72v8Ev,
  (VTBL_ENTRY)&_ZN5S88C72v9Ev,
  (VTBL_ENTRY)&_ZN5S88C73v10Ev,
  (VTBL_ENTRY)&_ZN5S88C73v11Ev,
  (VTBL_ENTRY)&_ZN5S88C73v12Ev,
  (VTBL_ENTRY)&_ZN5S88C73v13Ev,
  (VTBL_ENTRY)&_ZN5S88C73v14Ev,
  (VTBL_ENTRY)&_ZN5S88C73v15Ev,
  (VTBL_ENTRY)&_ZN5S88C73v16Ev,
  (VTBL_ENTRY)&_ZN5S88C73v17Ev,
  (VTBL_ENTRY)&_ZN5S88C73v18Ev,
  (VTBL_ENTRY)&_ZN5S88C73v19Ev,
  (VTBL_ENTRY)&_ZN5S88C73v20Ev,
  (VTBL_ENTRY)&_ZN5S88C73v21Ev,
  (VTBL_ENTRY)&_ZN5S88C73v22Ev,
  (VTBL_ENTRY)&_ZN5S88C73v23Ev,
  (VTBL_ENTRY)&_ZN5S88C73v24Ev,
  (VTBL_ENTRY)&_ZN5S88C73v25Ev,
  (VTBL_ENTRY)&_ZN5S88C73v26Ev,
  (VTBL_ENTRY)&_ZN5S88C73v27Ev,
  (VTBL_ENTRY)&_ZN5S88C73v28Ev,
  (VTBL_ENTRY)&_ZN5S88C73v29Ev,
  (VTBL_ENTRY)&_ZN5S88C73v30Ev,
  (VTBL_ENTRY)&_ZN5S88C73v31Ev,
  (VTBL_ENTRY)&_ZN5S88C73v32Ev,
  (VTBL_ENTRY)&_ZN5S88C73v33Ev,
  (VTBL_ENTRY)&_ZN5S88C73v34Ev,
  (VTBL_ENTRY)&_ZN5S88C73v35Ev,
  (VTBL_ENTRY)&_ZN5S88C73v36Ev,
  (VTBL_ENTRY)&_ZN5S88C73v37Ev,
  (VTBL_ENTRY)&_ZN5S88C73v38Ev,
  (VTBL_ENTRY)&_ZN5S88C73v39Ev,
  (VTBL_ENTRY)&_ZN5S88C73v40Ev,
  (VTBL_ENTRY)&_ZN5S88C73v41Ev,
  (VTBL_ENTRY)&_ZN5S88C73v42Ev,
  (VTBL_ENTRY)&_ZN5S88C73v43Ev,
  (VTBL_ENTRY)&_ZN5S88C73v44Ev,
  (VTBL_ENTRY)&_ZN5S88C73v45Ev,
  (VTBL_ENTRY)&_ZN5S88C73v46Ev,
  (VTBL_ENTRY)&_ZN5S88C73v47Ev,
  (VTBL_ENTRY)&_ZN5S88C73v48Ev,
  (VTBL_ENTRY)&_ZN5S88C73v49Ev,
  (VTBL_ENTRY)&_ZN5S88C73v50Ev,
  (VTBL_ENTRY)&_ZN5S88C73v51Ev,
  (VTBL_ENTRY)&_ZN5S88C73v52Ev,
  (VTBL_ENTRY)&_ZN5S88C73v53Ev,
  (VTBL_ENTRY)&_ZN5S88C73v54Ev,
  (VTBL_ENTRY)&_ZN5S88C73v55Ev,
  (VTBL_ENTRY)&_ZN5S88C73v56Ev,
  (VTBL_ENTRY)&_ZN5S88C73v57Ev,
  (VTBL_ENTRY)&_ZN5S88C73v58Ev,
  (VTBL_ENTRY)&_ZN5S88C73v59Ev,
  (VTBL_ENTRY)&_ZN5S88C73v60Ev,
  (VTBL_ENTRY)&_ZN5S88C73v61Ev,
  (VTBL_ENTRY)&_ZN5S88C73v62Ev,
  (VTBL_ENTRY)&_ZN5S88C73v63Ev,
  (VTBL_ENTRY)&_ZN5S88C73v64Ev,
  (VTBL_ENTRY)&_ZN5S88C73v65Ev,
  (VTBL_ENTRY)&_ZN5S88C73v66Ev,
  (VTBL_ENTRY)&_ZN5S88C73v67Ev,
  (VTBL_ENTRY)&_ZN5S88C63v68Ev,
  (VTBL_ENTRY)&_ZN5S88C63v69Ev,
  (VTBL_ENTRY)&_ZN5S88C53v70Ev,
  (VTBL_ENTRY)&_ZN5S88C53v71Ev,
  (VTBL_ENTRY)&_ZN5S88C53v72Ev,
  (VTBL_ENTRY)&_ZN5S88C53v73Ev,
  (VTBL_ENTRY)&_ZN5S88C53v74Ev,
  (VTBL_ENTRY)&_ZN5S88C53v75Ev,
  (VTBL_ENTRY)&_ZN5S88C53v76Ev,
  (VTBL_ENTRY)&_ZN5S88C53v77Ev,
  (VTBL_ENTRY)&_ZN5S88C53v78Ev,
  (VTBL_ENTRY)&_ZN5S88C53v79Ev,
  (VTBL_ENTRY)&_ZN5S88C53v80Ev,
  (VTBL_ENTRY)&_ZN5S88C53v81Ev,
  (VTBL_ENTRY)&_ZN5S88C43v82Ev,
  (VTBL_ENTRY)&_ZN5S88C43v83Ev,
  (VTBL_ENTRY)&_ZN5S88C43v84Ev,
  (VTBL_ENTRY)&_ZN5S88C33v89Ev,
  (VTBL_ENTRY)&_ZN5S88C33v90Ev,
  (VTBL_ENTRY)&_ZN5S88C33v91Ev,
  (VTBL_ENTRY)&_ZN5S88C33v92Ev,
  (VTBL_ENTRY)&_ZN5S88C33v93Ev,
  (VTBL_ENTRY)&_ZN5S88C33v94Ev,
  (VTBL_ENTRY)&_ZN5S88C33v95Ev,
  (VTBL_ENTRY)&_ZN5S88C33v96Ev,
  (VTBL_ENTRY)&_ZN5S88C33v97Ev,
  (VTBL_ENTRY)&_ZN5S88C23v98Ev,
  (VTBL_ENTRY)&_ZN5S88C23v99Ev,
  (VTBL_ENTRY)&_ZN5S88C24v100Ev,
  (VTBL_ENTRY)&_ZN5S88C24v101Ev,
  (VTBL_ENTRY)&_ZN5S88C24v102Ev,
  (VTBL_ENTRY)&_ZN5S88C12v1Ev,
  (VTBL_ENTRY)&_ZN5S88C12v2Ev,
  (VTBL_ENTRY)&_ZN5S88C12v3Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S88C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C1D1Ev,_ZThn100_N5S88C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S88C1D0Ev,_ZThn100_N5S88C1D0Ev),
  (VTBL_ENTRY)&_ZN6S88C153v85Ev,
  (VTBL_ENTRY)&_ZN6S88C153v86Ev,
  (VTBL_ENTRY)&_ZN6S88C153v87Ev,
  (VTBL_ENTRY)&_ZN6S88C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S88C1[];
extern  VTBL_ENTRY _ZTV5S88C1[];
Class_Descriptor cd_S88C1 = {  "S88C1", // class name
  bases_S88C1, 7,
  &(vtc_S88C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,220), // object size
  NSPAIRA(_ZTI5S88C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S88C1),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C5  {
  int s515c5f0;
  __tsi64 s515c5f1;
  void *s515c5f2[4];
  int s515c5f3[2];
  void *s515c5f4;
  ::S3422C4_nt s515c5f5;
  void *s515c5f6[2];
  virtual  ~S515C5(); // _ZN6S515C5D1Ev
  virtual void  v27(); // _ZN6S515C53v27Ev
  virtual void  v28(); // _ZN6S515C53v28Ev
  virtual void  v29(); // _ZN6S515C53v29Ev
  virtual void  v30(); // _ZN6S515C53v30Ev
  virtual void  v31(); // _ZN6S515C53v31Ev
  virtual void  v32(); // _ZN6S515C53v32Ev
  virtual void  v33(); // _ZN6S515C53v33Ev
  virtual void  v34(); // _ZN6S515C53v34Ev
  virtual void  v35(); // _ZN6S515C53v35Ev
  virtual void  v36(); // _ZN6S515C53v36Ev
  virtual void  v37(); // _ZN6S515C53v37Ev
  virtual void  v38(); // _ZN6S515C53v38Ev
  virtual void  v39(); // _ZN6S515C53v39Ev
  virtual void  v40(); // _ZN6S515C53v40Ev
  virtual void  v41(); // _ZN6S515C53v41Ev
  virtual void  v42(); // _ZN6S515C53v42Ev
  virtual void  v43(); // _ZN6S515C53v43Ev
  virtual void  v44(); // _ZN6S515C53v44Ev
  virtual void  v45(); // _ZN6S515C53v45Ev
  virtual void  v46(); // _ZN6S515C53v46Ev
  virtual void  v47(); // _ZN6S515C53v47Ev
  virtual void  v48(); // _ZN6S515C53v48Ev
  virtual void  v49(); // _ZN6S515C53v49Ev
  virtual void  v50(); // _ZN6S515C53v50Ev
  virtual void  v51(); // _ZN6S515C53v51Ev
  virtual void  v52(); // _ZN6S515C53v52Ev
  virtual void  v53(); // _ZN6S515C53v53Ev
  virtual void  v54(); // _ZN6S515C53v54Ev
  virtual void  v55(); // _ZN6S515C53v55Ev
  virtual void  v56(); // _ZN6S515C53v56Ev
  virtual void  v57(); // _ZN6S515C53v57Ev
  virtual void  v58(); // _ZN6S515C53v58Ev
  virtual void  v59(); // _ZN6S515C53v59Ev
  virtual void  v60(); // _ZN6S515C53v60Ev
  virtual void  v61(); // _ZN6S515C53v61Ev
  virtual void  v62(); // _ZN6S515C53v62Ev
  virtual void  v63(); // _ZN6S515C53v63Ev
  virtual void  v64(); // _ZN6S515C53v64Ev
  virtual void  v65(); // _ZN6S515C53v65Ev
  virtual void  v66(); // _ZN6S515C53v66Ev
  virtual void  v67(); // _ZN6S515C53v67Ev
  virtual void  v68(); // _ZN6S515C53v68Ev
  virtual void  v69(); // _ZN6S515C53v69Ev
  virtual void  v70(); // _ZN6S515C53v70Ev
  virtual void  v71(); // _ZN6S515C53v71Ev
  virtual void  v72(); // _ZN6S515C53v72Ev
  virtual void  v73(); // _ZN6S515C53v73Ev
  virtual void  v74(); // _ZN6S515C53v74Ev
  virtual void  v75(); // _ZN6S515C53v75Ev
  virtual void  v76(); // _ZN6S515C53v76Ev
  virtual void  v77(); // _ZN6S515C53v77Ev
  virtual void  v78(); // _ZN6S515C53v78Ev
  virtual void  v79(); // _ZN6S515C53v79Ev
  virtual void  v80(); // _ZN6S515C53v80Ev
  virtual void  v81(); // _ZN6S515C53v81Ev
  virtual void  v82(); // _ZN6S515C53v82Ev
  virtual void  v83(); // _ZN6S515C53v83Ev
  virtual void  v84(); // _ZN6S515C53v84Ev
  virtual void  v85(); // _ZN6S515C53v85Ev
  virtual void  v86(); // _ZN6S515C53v86Ev
  virtual void  v87(); // _ZN6S515C53v87Ev
  virtual void  v88(); // _ZN6S515C53v88Ev
  virtual void  v89(); // _ZN6S515C53v89Ev
  virtual void  v90(); // _ZN6S515C53v90Ev
  S515C5(); // tgen
};
//SIG(-1 S515C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S515C5 ::~S515C5(){ note_dtor("S515C5", this);}
void  S515C5 ::v27(){vfunc_called(this, "_ZN6S515C53v27Ev");}
void  S515C5 ::v28(){vfunc_called(this, "_ZN6S515C53v28Ev");}
void  S515C5 ::v29(){vfunc_called(this, "_ZN6S515C53v29Ev");}
void  S515C5 ::v30(){vfunc_called(this, "_ZN6S515C53v30Ev");}
void  S515C5 ::v31(){vfunc_called(this, "_ZN6S515C53v31Ev");}
void  S515C5 ::v32(){vfunc_called(this, "_ZN6S515C53v32Ev");}
void  S515C5 ::v33(){vfunc_called(this, "_ZN6S515C53v33Ev");}
void  S515C5 ::v34(){vfunc_called(this, "_ZN6S515C53v34Ev");}
void  S515C5 ::v35(){vfunc_called(this, "_ZN6S515C53v35Ev");}
void  S515C5 ::v36(){vfunc_called(this, "_ZN6S515C53v36Ev");}
void  S515C5 ::v37(){vfunc_called(this, "_ZN6S515C53v37Ev");}
void  S515C5 ::v38(){vfunc_called(this, "_ZN6S515C53v38Ev");}
void  S515C5 ::v39(){vfunc_called(this, "_ZN6S515C53v39Ev");}
void  S515C5 ::v40(){vfunc_called(this, "_ZN6S515C53v40Ev");}
void  S515C5 ::v41(){vfunc_called(this, "_ZN6S515C53v41Ev");}
void  S515C5 ::v42(){vfunc_called(this, "_ZN6S515C53v42Ev");}
void  S515C5 ::v43(){vfunc_called(this, "_ZN6S515C53v43Ev");}
void  S515C5 ::v44(){vfunc_called(this, "_ZN6S515C53v44Ev");}
void  S515C5 ::v45(){vfunc_called(this, "_ZN6S515C53v45Ev");}
void  S515C5 ::v46(){vfunc_called(this, "_ZN6S515C53v46Ev");}
void  S515C5 ::v47(){vfunc_called(this, "_ZN6S515C53v47Ev");}
void  S515C5 ::v48(){vfunc_called(this, "_ZN6S515C53v48Ev");}
void  S515C5 ::v49(){vfunc_called(this, "_ZN6S515C53v49Ev");}
void  S515C5 ::v50(){vfunc_called(this, "_ZN6S515C53v50Ev");}
void  S515C5 ::v51(){vfunc_called(this, "_ZN6S515C53v51Ev");}
void  S515C5 ::v52(){vfunc_called(this, "_ZN6S515C53v52Ev");}
void  S515C5 ::v53(){vfunc_called(this, "_ZN6S515C53v53Ev");}
void  S515C5 ::v54(){vfunc_called(this, "_ZN6S515C53v54Ev");}
void  S515C5 ::v55(){vfunc_called(this, "_ZN6S515C53v55Ev");}
void  S515C5 ::v56(){vfunc_called(this, "_ZN6S515C53v56Ev");}
void  S515C5 ::v57(){vfunc_called(this, "_ZN6S515C53v57Ev");}
void  S515C5 ::v58(){vfunc_called(this, "_ZN6S515C53v58Ev");}
void  S515C5 ::v59(){vfunc_called(this, "_ZN6S515C53v59Ev");}
void  S515C5 ::v60(){vfunc_called(this, "_ZN6S515C53v60Ev");}
void  S515C5 ::v61(){vfunc_called(this, "_ZN6S515C53v61Ev");}
void  S515C5 ::v62(){vfunc_called(this, "_ZN6S515C53v62Ev");}
void  S515C5 ::v63(){vfunc_called(this, "_ZN6S515C53v63Ev");}
void  S515C5 ::v64(){vfunc_called(this, "_ZN6S515C53v64Ev");}
void  S515C5 ::v65(){vfunc_called(this, "_ZN6S515C53v65Ev");}
void  S515C5 ::v66(){vfunc_called(this, "_ZN6S515C53v66Ev");}
void  S515C5 ::v67(){vfunc_called(this, "_ZN6S515C53v67Ev");}
void  S515C5 ::v68(){vfunc_called(this, "_ZN6S515C53v68Ev");}
void  S515C5 ::v69(){vfunc_called(this, "_ZN6S515C53v69Ev");}
void  S515C5 ::v70(){vfunc_called(this, "_ZN6S515C53v70Ev");}
void  S515C5 ::v71(){vfunc_called(this, "_ZN6S515C53v71Ev");}
void  S515C5 ::v72(){vfunc_called(this, "_ZN6S515C53v72Ev");}
void  S515C5 ::v73(){vfunc_called(this, "_ZN6S515C53v73Ev");}
void  S515C5 ::v74(){vfunc_called(this, "_ZN6S515C53v74Ev");}
void  S515C5 ::v75(){vfunc_called(this, "_ZN6S515C53v75Ev");}
void  S515C5 ::v76(){vfunc_called(this, "_ZN6S515C53v76Ev");}
void  S515C5 ::v77(){vfunc_called(this, "_ZN6S515C53v77Ev");}
void  S515C5 ::v78(){vfunc_called(this, "_ZN6S515C53v78Ev");}
void  S515C5 ::v79(){vfunc_called(this, "_ZN6S515C53v79Ev");}
void  S515C5 ::v80(){vfunc_called(this, "_ZN6S515C53v80Ev");}
void  S515C5 ::v81(){vfunc_called(this, "_ZN6S515C53v81Ev");}
void  S515C5 ::v82(){vfunc_called(this, "_ZN6S515C53v82Ev");}
void  S515C5 ::v83(){vfunc_called(this, "_ZN6S515C53v83Ev");}
void  S515C5 ::v84(){vfunc_called(this, "_ZN6S515C53v84Ev");}
void  S515C5 ::v85(){vfunc_called(this, "_ZN6S515C53v85Ev");}
void  S515C5 ::v86(){vfunc_called(this, "_ZN6S515C53v86Ev");}
void  S515C5 ::v87(){vfunc_called(this, "_ZN6S515C53v87Ev");}
void  S515C5 ::v88(){vfunc_called(this, "_ZN6S515C53v88Ev");}
void  S515C5 ::v89(){vfunc_called(this, "_ZN6S515C53v89Ev");}
void  S515C5 ::v90(){vfunc_called(this, "_ZN6S515C53v90Ev");}
S515C5 ::S515C5(){ note_ctor("S515C5", this);} // tgen

static void Test_S515C5()
{
  extern Class_Descriptor cd_S515C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S515C5, buf);
    S515C5 *dp, &lv = *(dp=new (buf) S515C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S515C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C5)");
    check_field_offset(lv, s515c5f0, ABISELECT(8,4), "S515C5.s515c5f0");
    check_field_offset(lv, s515c5f1, ABISELECT(16,8), "S515C5.s515c5f1");
    check_field_offset(lv, s515c5f2, ABISELECT(24,16), "S515C5.s515c5f2");
    check_field_offset(lv, s515c5f3, ABISELECT(56,32), "S515C5.s515c5f3");
    check_field_offset(lv, s515c5f4, ABISELECT(64,40), "S515C5.s515c5f4");
    check_field_offset(lv, s515c5f5, ABISELECT(72,44), "S515C5.s515c5f5");
    check_field_offset(lv, s515c5f6, ABISELECT(80,52), "S515C5.s515c5f6");
    test_class_info(&lv, &cd_S515C5);
    dp->~S515C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C5(Test_S515C5, "S515C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S515C5C1Ev();
extern void _ZN6S515C5D1Ev();
Name_Map name_map_S515C5[] = {
  NSPAIR(_ZN6S515C5C1Ev),
  NSPAIR(_ZN6S515C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S515C5[];
extern void _ZN6S515C5D1Ev();
extern void _ZN6S515C5D0Ev();
extern void _ZN6S515C53v27Ev();
extern void _ZN6S515C53v28Ev();
extern void _ZN6S515C53v29Ev();
extern void _ZN6S515C53v30Ev();
extern void _ZN6S515C53v31Ev();
extern void _ZN6S515C53v32Ev();
extern void _ZN6S515C53v33Ev();
extern void _ZN6S515C53v34Ev();
extern void _ZN6S515C53v35Ev();
extern void _ZN6S515C53v36Ev();
extern void _ZN6S515C53v37Ev();
extern void _ZN6S515C53v38Ev();
extern void _ZN6S515C53v39Ev();
extern void _ZN6S515C53v40Ev();
extern void _ZN6S515C53v41Ev();
extern void _ZN6S515C53v42Ev();
extern void _ZN6S515C53v43Ev();
extern void _ZN6S515C53v44Ev();
extern void _ZN6S515C53v45Ev();
extern void _ZN6S515C53v46Ev();
extern void _ZN6S515C53v47Ev();
extern void _ZN6S515C53v48Ev();
extern void _ZN6S515C53v49Ev();
extern void _ZN6S515C53v50Ev();
extern void _ZN6S515C53v51Ev();
extern void _ZN6S515C53v52Ev();
extern void _ZN6S515C53v53Ev();
extern void _ZN6S515C53v54Ev();
extern void _ZN6S515C53v55Ev();
extern void _ZN6S515C53v56Ev();
extern void _ZN6S515C53v57Ev();
extern void _ZN6S515C53v58Ev();
extern void _ZN6S515C53v59Ev();
extern void _ZN6S515C53v60Ev();
extern void _ZN6S515C53v61Ev();
extern void _ZN6S515C53v62Ev();
extern void _ZN6S515C53v63Ev();
extern void _ZN6S515C53v64Ev();
extern void _ZN6S515C53v65Ev();
extern void _ZN6S515C53v66Ev();
extern void _ZN6S515C53v67Ev();
extern void _ZN6S515C53v68Ev();
extern void _ZN6S515C53v69Ev();
extern void _ZN6S515C53v70Ev();
extern void _ZN6S515C53v71Ev();
extern void _ZN6S515C53v72Ev();
extern void _ZN6S515C53v73Ev();
extern void _ZN6S515C53v74Ev();
extern void _ZN6S515C53v75Ev();
extern void _ZN6S515C53v76Ev();
extern void _ZN6S515C53v77Ev();
extern void _ZN6S515C53v78Ev();
extern void _ZN6S515C53v79Ev();
extern void _ZN6S515C53v80Ev();
extern void _ZN6S515C53v81Ev();
extern void _ZN6S515C53v82Ev();
extern void _ZN6S515C53v83Ev();
extern void _ZN6S515C53v84Ev();
extern void _ZN6S515C53v85Ev();
extern void _ZN6S515C53v86Ev();
extern void _ZN6S515C53v87Ev();
extern void _ZN6S515C53v88Ev();
extern void _ZN6S515C53v89Ev();
extern void _ZN6S515C53v90Ev();
static  VTBL_ENTRY vtc_S515C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S515C5[0]),
  (VTBL_ENTRY)&_ZN6S515C5D1Ev,
  (VTBL_ENTRY)&_ZN6S515C5D0Ev,
  (VTBL_ENTRY)&_ZN6S515C53v27Ev,
  (VTBL_ENTRY)&_ZN6S515C53v28Ev,
  (VTBL_ENTRY)&_ZN6S515C53v29Ev,
  (VTBL_ENTRY)&_ZN6S515C53v30Ev,
  (VTBL_ENTRY)&_ZN6S515C53v31Ev,
  (VTBL_ENTRY)&_ZN6S515C53v32Ev,
  (VTBL_ENTRY)&_ZN6S515C53v33Ev,
  (VTBL_ENTRY)&_ZN6S515C53v34Ev,
  (VTBL_ENTRY)&_ZN6S515C53v35Ev,
  (VTBL_ENTRY)&_ZN6S515C53v36Ev,
  (VTBL_ENTRY)&_ZN6S515C53v37Ev,
  (VTBL_ENTRY)&_ZN6S515C53v38Ev,
  (VTBL_ENTRY)&_ZN6S515C53v39Ev,
  (VTBL_ENTRY)&_ZN6S515C53v40Ev,
  (VTBL_ENTRY)&_ZN6S515C53v41Ev,
  (VTBL_ENTRY)&_ZN6S515C53v42Ev,
  (VTBL_ENTRY)&_ZN6S515C53v43Ev,
  (VTBL_ENTRY)&_ZN6S515C53v44Ev,
  (VTBL_ENTRY)&_ZN6S515C53v45Ev,
  (VTBL_ENTRY)&_ZN6S515C53v46Ev,
  (VTBL_ENTRY)&_ZN6S515C53v47Ev,
  (VTBL_ENTRY)&_ZN6S515C53v48Ev,
  (VTBL_ENTRY)&_ZN6S515C53v49Ev,
  (VTBL_ENTRY)&_ZN6S515C53v50Ev,
  (VTBL_ENTRY)&_ZN6S515C53v51Ev,
  (VTBL_ENTRY)&_ZN6S515C53v52Ev,
  (VTBL_ENTRY)&_ZN6S515C53v53Ev,
  (VTBL_ENTRY)&_ZN6S515C53v54Ev,
  (VTBL_ENTRY)&_ZN6S515C53v55Ev,
  (VTBL_ENTRY)&_ZN6S515C53v56Ev,
  (VTBL_ENTRY)&_ZN6S515C53v57Ev,
  (VTBL_ENTRY)&_ZN6S515C53v58Ev,
  (VTBL_ENTRY)&_ZN6S515C53v59Ev,
  (VTBL_ENTRY)&_ZN6S515C53v60Ev,
  (VTBL_ENTRY)&_ZN6S515C53v61Ev,
  (VTBL_ENTRY)&_ZN6S515C53v62Ev,
  (VTBL_ENTRY)&_ZN6S515C53v63Ev,
  (VTBL_ENTRY)&_ZN6S515C53v64Ev,
  (VTBL_ENTRY)&_ZN6S515C53v65Ev,
  (VTBL_ENTRY)&_ZN6S515C53v66Ev,
  (VTBL_ENTRY)&_ZN6S515C53v67Ev,
  (VTBL_ENTRY)&_ZN6S515C53v68Ev,
  (VTBL_ENTRY)&_ZN6S515C53v69Ev,
  (VTBL_ENTRY)&_ZN6S515C53v70Ev,
  (VTBL_ENTRY)&_ZN6S515C53v71Ev,
  (VTBL_ENTRY)&_ZN6S515C53v72Ev,
  (VTBL_ENTRY)&_ZN6S515C53v73Ev,
  (VTBL_ENTRY)&_ZN6S515C53v74Ev,
  (VTBL_ENTRY)&_ZN6S515C53v75Ev,
  (VTBL_ENTRY)&_ZN6S515C53v76Ev,
  (VTBL_ENTRY)&_ZN6S515C53v77Ev,
  (VTBL_ENTRY)&_ZN6S515C53v78Ev,
  (VTBL_ENTRY)&_ZN6S515C53v79Ev,
  (VTBL_ENTRY)&_ZN6S515C53v80Ev,
  (VTBL_ENTRY)&_ZN6S515C53v81Ev,
  (VTBL_ENTRY)&_ZN6S515C53v82Ev,
  (VTBL_ENTRY)&_ZN6S515C53v83Ev,
  (VTBL_ENTRY)&_ZN6S515C53v84Ev,
  (VTBL_ENTRY)&_ZN6S515C53v85Ev,
  (VTBL_ENTRY)&_ZN6S515C53v86Ev,
  (VTBL_ENTRY)&_ZN6S515C53v87Ev,
  (VTBL_ENTRY)&_ZN6S515C53v88Ev,
  (VTBL_ENTRY)&_ZN6S515C53v89Ev,
  (VTBL_ENTRY)&_ZN6S515C53v90Ev,
};
extern VTBL_ENTRY _ZTI6S515C5[];
extern  VTBL_ENTRY _ZTV6S515C5[];
Class_Descriptor cd_S515C5 = {  "S515C5", // class name
  0,0,//no base classes
  &(vtc_S515C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S515C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S515C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C4  : S515C5 {
  virtual  ~S515C4(); // _ZN6S515C4D1Ev
  virtual void  v91(); // _ZN6S515C43v91Ev
  virtual void  v92(); // _ZN6S515C43v92Ev
  S515C4(); // tgen
};
//SIG(-1 S515C4) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S515C4 ::~S515C4(){ note_dtor("S515C4", this);}
void  S515C4 ::v91(){vfunc_called(this, "_ZN6S515C43v91Ev");}
void  S515C4 ::v92(){vfunc_called(this, "_ZN6S515C43v92Ev");}
S515C4 ::S515C4(){ note_ctor("S515C4", this);} // tgen

static void Test_S515C4()
{
  extern Class_Descriptor cd_S515C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S515C4, buf);
    S515C4 *dp, &lv = *(dp=new (buf) S515C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S515C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C4)");
    check_base_class_offset(lv, (S515C5*), 0, "S515C4");
    test_class_info(&lv, &cd_S515C4);
    dp->~S515C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C4(Test_S515C4, "S515C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S515C4C1Ev();
extern void _ZN6S515C4D1Ev();
Name_Map name_map_S515C4[] = {
  NSPAIR(_ZN6S515C4C1Ev),
  NSPAIR(_ZN6S515C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S515C5;
extern VTBL_ENTRY _ZTI6S515C5[];
extern  VTBL_ENTRY _ZTV6S515C5[];
static Base_Class bases_S515C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S515C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S515C4[];
extern void _ZN6S515C4D1Ev();
extern void _ZN6S515C4D0Ev();
extern void _ZN6S515C53v27Ev();
extern void _ZN6S515C53v28Ev();
extern void _ZN6S515C53v29Ev();
extern void _ZN6S515C53v30Ev();
extern void _ZN6S515C53v31Ev();
extern void _ZN6S515C53v32Ev();
extern void _ZN6S515C53v33Ev();
extern void _ZN6S515C53v34Ev();
extern void _ZN6S515C53v35Ev();
extern void _ZN6S515C53v36Ev();
extern void _ZN6S515C53v37Ev();
extern void _ZN6S515C53v38Ev();
extern void _ZN6S515C53v39Ev();
extern void _ZN6S515C53v40Ev();
extern void _ZN6S515C53v41Ev();
extern void _ZN6S515C53v42Ev();
extern void _ZN6S515C53v43Ev();
extern void _ZN6S515C53v44Ev();
extern void _ZN6S515C53v45Ev();
extern void _ZN6S515C53v46Ev();
extern void _ZN6S515C53v47Ev();
extern void _ZN6S515C53v48Ev();
extern void _ZN6S515C53v49Ev();
extern void _ZN6S515C53v50Ev();
extern void _ZN6S515C53v51Ev();
extern void _ZN6S515C53v52Ev();
extern void _ZN6S515C53v53Ev();
extern void _ZN6S515C53v54Ev();
extern void _ZN6S515C53v55Ev();
extern void _ZN6S515C53v56Ev();
extern void _ZN6S515C53v57Ev();
extern void _ZN6S515C53v58Ev();
extern void _ZN6S515C53v59Ev();
extern void _ZN6S515C53v60Ev();
extern void _ZN6S515C53v61Ev();
extern void _ZN6S515C53v62Ev();
extern void _ZN6S515C53v63Ev();
extern void _ZN6S515C53v64Ev();
extern void _ZN6S515C53v65Ev();
extern void _ZN6S515C53v66Ev();
extern void _ZN6S515C53v67Ev();
extern void _ZN6S515C53v68Ev();
extern void _ZN6S515C53v69Ev();
extern void _ZN6S515C53v70Ev();
extern void _ZN6S515C53v71Ev();
extern void _ZN6S515C53v72Ev();
extern void _ZN6S515C53v73Ev();
extern void _ZN6S515C53v74Ev();
extern void _ZN6S515C53v75Ev();
extern void _ZN6S515C53v76Ev();
extern void _ZN6S515C53v77Ev();
extern void _ZN6S515C53v78Ev();
extern void _ZN6S515C53v79Ev();
extern void _ZN6S515C53v80Ev();
extern void _ZN6S515C53v81Ev();
extern void _ZN6S515C53v82Ev();
extern void _ZN6S515C53v83Ev();
extern void _ZN6S515C53v84Ev();
extern void _ZN6S515C53v85Ev();
extern void _ZN6S515C53v86Ev();
extern void _ZN6S515C53v87Ev();
extern void _ZN6S515C53v88Ev();
extern void _ZN6S515C53v89Ev();
extern void _ZN6S515C53v90Ev();
extern void _ZN6S515C43v91Ev();
extern void _ZN6S515C43v92Ev();
static  VTBL_ENTRY vtc_S515C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S515C4[0]),
  (VTBL_ENTRY)&_ZN6S515C4D1Ev,
  (VTBL_ENTRY)&_ZN6S515C4D0Ev,
  (VTBL_ENTRY)&_ZN6S515C53v27Ev,
  (VTBL_ENTRY)&_ZN6S515C53v28Ev,
  (VTBL_ENTRY)&_ZN6S515C53v29Ev,
  (VTBL_ENTRY)&_ZN6S515C53v30Ev,
  (VTBL_ENTRY)&_ZN6S515C53v31Ev,
  (VTBL_ENTRY)&_ZN6S515C53v32Ev,
  (VTBL_ENTRY)&_ZN6S515C53v33Ev,
  (VTBL_ENTRY)&_ZN6S515C53v34Ev,
  (VTBL_ENTRY)&_ZN6S515C53v35Ev,
  (VTBL_ENTRY)&_ZN6S515C53v36Ev,
  (VTBL_ENTRY)&_ZN6S515C53v37Ev,
  (VTBL_ENTRY)&_ZN6S515C53v38Ev,
  (VTBL_ENTRY)&_ZN6S515C53v39Ev,
  (VTBL_ENTRY)&_ZN6S515C53v40Ev,
  (VTBL_ENTRY)&_ZN6S515C53v41Ev,
  (VTBL_ENTRY)&_ZN6S515C53v42Ev,
  (VTBL_ENTRY)&_ZN6S515C53v43Ev,
  (VTBL_ENTRY)&_ZN6S515C53v44Ev,
  (VTBL_ENTRY)&_ZN6S515C53v45Ev,
  (VTBL_ENTRY)&_ZN6S515C53v46Ev,
  (VTBL_ENTRY)&_ZN6S515C53v47Ev,
  (VTBL_ENTRY)&_ZN6S515C53v48Ev,
  (VTBL_ENTRY)&_ZN6S515C53v49Ev,
  (VTBL_ENTRY)&_ZN6S515C53v50Ev,
  (VTBL_ENTRY)&_ZN6S515C53v51Ev,
  (VTBL_ENTRY)&_ZN6S515C53v52Ev,
  (VTBL_ENTRY)&_ZN6S515C53v53Ev,
  (VTBL_ENTRY)&_ZN6S515C53v54Ev,
  (VTBL_ENTRY)&_ZN6S515C53v55Ev,
  (VTBL_ENTRY)&_ZN6S515C53v56Ev,
  (VTBL_ENTRY)&_ZN6S515C53v57Ev,
  (VTBL_ENTRY)&_ZN6S515C53v58Ev,
  (VTBL_ENTRY)&_ZN6S515C53v59Ev,
  (VTBL_ENTRY)&_ZN6S515C53v60Ev,
  (VTBL_ENTRY)&_ZN6S515C53v61Ev,
  (VTBL_ENTRY)&_ZN6S515C53v62Ev,
  (VTBL_ENTRY)&_ZN6S515C53v63Ev,
  (VTBL_ENTRY)&_ZN6S515C53v64Ev,
  (VTBL_ENTRY)&_ZN6S515C53v65Ev,
  (VTBL_ENTRY)&_ZN6S515C53v66Ev,
  (VTBL_ENTRY)&_ZN6S515C53v67Ev,
  (VTBL_ENTRY)&_ZN6S515C53v68Ev,
  (VTBL_ENTRY)&_ZN6S515C53v69Ev,
  (VTBL_ENTRY)&_ZN6S515C53v70Ev,
  (VTBL_ENTRY)&_ZN6S515C53v71Ev,
  (VTBL_ENTRY)&_ZN6S515C53v72Ev,
  (VTBL_ENTRY)&_ZN6S515C53v73Ev,
  (VTBL_ENTRY)&_ZN6S515C53v74Ev,
  (VTBL_ENTRY)&_ZN6S515C53v75Ev,
  (VTBL_ENTRY)&_ZN6S515C53v76Ev,
  (VTBL_ENTRY)&_ZN6S515C53v77Ev,
  (VTBL_ENTRY)&_ZN6S515C53v78Ev,
  (VTBL_ENTRY)&_ZN6S515C53v79Ev,
  (VTBL_ENTRY)&_ZN6S515C53v80Ev,
  (VTBL_ENTRY)&_ZN6S515C53v81Ev,
  (VTBL_ENTRY)&_ZN6S515C53v82Ev,
  (VTBL_ENTRY)&_ZN6S515C53v83Ev,
  (VTBL_ENTRY)&_ZN6S515C53v84Ev,
  (VTBL_ENTRY)&_ZN6S515C53v85Ev,
  (VTBL_ENTRY)&_ZN6S515C53v86Ev,
  (VTBL_ENTRY)&_ZN6S515C53v87Ev,
  (VTBL_ENTRY)&_ZN6S515C53v88Ev,
  (VTBL_ENTRY)&_ZN6S515C53v89Ev,
  (VTBL_ENTRY)&_ZN6S515C53v90Ev,
  (VTBL_ENTRY)&_ZN6S515C43v91Ev,
  (VTBL_ENTRY)&_ZN6S515C43v92Ev,
};
extern VTBL_ENTRY _ZTI6S515C4[];
extern  VTBL_ENTRY _ZTV6S515C4[];
Class_Descriptor cd_S515C4 = {  "S515C4", // class name
  bases_S515C4, 1,
  &(vtc_S515C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S515C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S515C4),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C3  : S515C4 {
  char s515c3f0;
  ::S3422C23 s515c3f1;
  ::S49C12_nt s515c3f2;
  virtual  ~S515C3(); // _ZN6S515C3D1Ev
  virtual void  v93(); // _ZN6S515C33v93Ev
  virtual void  v94(); // _ZN6S515C33v94Ev
  virtual void  v95(); // _ZN6S515C33v95Ev
  virtual void  v96(); // _ZN6S515C33v96Ev
  virtual void  v97(); // _ZN6S515C33v97Ev
  virtual void  v98(); // _ZN6S515C33v98Ev
  virtual void  v99(); // _ZN6S515C33v99Ev
  virtual void  v100(); // _ZN6S515C34v100Ev
  virtual void  v101(); // _ZN6S515C34v101Ev
  virtual void  v102(); // _ZN6S515C34v102Ev
  virtual void  v103(); // _ZN6S515C34v103Ev
  virtual void  v104(); // _ZN6S515C34v104Ev
  S515C3(); // tgen
};
//SIG(-1 S515C3) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S515C3 ::~S515C3(){ note_dtor("S515C3", this);}
void  S515C3 ::v93(){vfunc_called(this, "_ZN6S515C33v93Ev");}
void  S515C3 ::v94(){vfunc_called(this, "_ZN6S515C33v94Ev");}
void  S515C3 ::v95(){vfunc_called(this, "_ZN6S515C33v95Ev");}
void  S515C3 ::v96(){vfunc_called(this, "_ZN6S515C33v96Ev");}
void  S515C3 ::v97(){vfunc_called(this, "_ZN6S515C33v97Ev");}
void  S515C3 ::v98(){vfunc_called(this, "_ZN6S515C33v98Ev");}
void  S515C3 ::v99(){vfunc_called(this, "_ZN6S515C33v99Ev");}
void  S515C3 ::v100(){vfunc_called(this, "_ZN6S515C34v100Ev");}
void  S515C3 ::v101(){vfunc_called(this, "_ZN6S515C34v101Ev");}
void  S515C3 ::v102(){vfunc_called(this, "_ZN6S515C34v102Ev");}
void  S515C3 ::v103(){vfunc_called(this, "_ZN6S515C34v103Ev");}
void  S515C3 ::v104(){vfunc_called(this, "_ZN6S515C34v104Ev");}
S515C3 ::S515C3(){ note_ctor("S515C3", this);} // tgen

static void Test_S515C3()
{
  extern Class_Descriptor cd_S515C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S515C3, buf);
    S515C3 *dp, &lv = *(dp=new (buf) S515C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S515C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C3)");
    check_base_class_offset(lv, (S515C5*)(S515C4*), 0, "S515C3");
    check_base_class_offset(lv, (S515C4*), 0, "S515C3");
    check_field_offset(lv, s515c3f0, ABISELECT(96,60), "S515C3.s515c3f0");
    check_field_offset(lv, s515c3f1, ABISELECT(104,64), "S515C3.s515c3f1");
    check_field_offset(lv, s515c3f2, ABISELECT(120,76), "S515C3.s515c3f2");
    test_class_info(&lv, &cd_S515C3);
    dp->~S515C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C3(Test_S515C3, "S515C3", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S515C3C1Ev();
extern void _ZN6S515C3D1Ev();
Name_Map name_map_S515C3[] = {
  NSPAIR(_ZN6S515C3C1Ev),
  NSPAIR(_ZN6S515C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S515C5;
extern VTBL_ENTRY _ZTI6S515C5[];
extern  VTBL_ENTRY _ZTV6S515C5[];
extern Class_Descriptor cd_S515C4;
extern VTBL_ENTRY _ZTI6S515C4[];
extern  VTBL_ENTRY _ZTV6S515C4[];
static Base_Class bases_S515C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S515C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S515C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S515C3[];
extern void _ZN6S515C3D1Ev();
extern void _ZN6S515C3D0Ev();
extern void _ZN6S515C53v27Ev();
extern void _ZN6S515C53v28Ev();
extern void _ZN6S515C53v29Ev();
extern void _ZN6S515C53v30Ev();
extern void _ZN6S515C53v31Ev();
extern void _ZN6S515C53v32Ev();
extern void _ZN6S515C53v33Ev();
extern void _ZN6S515C53v34Ev();
extern void _ZN6S515C53v35Ev();
extern void _ZN6S515C53v36Ev();
extern void _ZN6S515C53v37Ev();
extern void _ZN6S515C53v38Ev();
extern void _ZN6S515C53v39Ev();
extern void _ZN6S515C53v40Ev();
extern void _ZN6S515C53v41Ev();
extern void _ZN6S515C53v42Ev();
extern void _ZN6S515C53v43Ev();
extern void _ZN6S515C53v44Ev();
extern void _ZN6S515C53v45Ev();
extern void _ZN6S515C53v46Ev();
extern void _ZN6S515C53v47Ev();
extern void _ZN6S515C53v48Ev();
extern void _ZN6S515C53v49Ev();
extern void _ZN6S515C53v50Ev();
extern void _ZN6S515C53v51Ev();
extern void _ZN6S515C53v52Ev();
extern void _ZN6S515C53v53Ev();
extern void _ZN6S515C53v54Ev();
extern void _ZN6S515C53v55Ev();
extern void _ZN6S515C53v56Ev();
extern void _ZN6S515C53v57Ev();
extern void _ZN6S515C53v58Ev();
extern void _ZN6S515C53v59Ev();
extern void _ZN6S515C53v60Ev();
extern void _ZN6S515C53v61Ev();
extern void _ZN6S515C53v62Ev();
extern void _ZN6S515C53v63Ev();
extern void _ZN6S515C53v64Ev();
extern void _ZN6S515C53v65Ev();
extern void _ZN6S515C53v66Ev();
extern void _ZN6S515C53v67Ev();
extern void _ZN6S515C53v68Ev();
extern void _ZN6S515C53v69Ev();
extern void _ZN6S515C53v70Ev();
extern void _ZN6S515C53v71Ev();
extern void _ZN6S515C53v72Ev();
extern void _ZN6S515C53v73Ev();
extern void _ZN6S515C53v74Ev();
extern void _ZN6S515C53v75Ev();
extern void _ZN6S515C53v76Ev();
extern void _ZN6S515C53v77Ev();
extern void _ZN6S515C53v78Ev();
extern void _ZN6S515C53v79Ev();
extern void _ZN6S515C53v80Ev();
extern void _ZN6S515C53v81Ev();
extern void _ZN6S515C53v82Ev();
extern void _ZN6S515C53v83Ev();
extern void _ZN6S515C53v84Ev();
extern void _ZN6S515C53v85Ev();
extern void _ZN6S515C53v86Ev();
extern void _ZN6S515C53v87Ev();
extern void _ZN6S515C53v88Ev();
extern void _ZN6S515C53v89Ev();
extern void _ZN6S515C53v90Ev();
extern void _ZN6S515C43v91Ev();
extern void _ZN6S515C43v92Ev();
extern void _ZN6S515C33v93Ev();
extern void _ZN6S515C33v94Ev();
extern void _ZN6S515C33v95Ev();
extern void _ZN6S515C33v96Ev();
extern void _ZN6S515C33v97Ev();
extern void _ZN6S515C33v98Ev();
extern void _ZN6S515C33v99Ev();
extern void _ZN6S515C34v100Ev();
extern void _ZN6S515C34v101Ev();
extern void _ZN6S515C34v102Ev();
extern void _ZN6S515C34v103Ev();
extern void _ZN6S515C34v104Ev();
static  VTBL_ENTRY vtc_S515C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S515C3[0]),
  (VTBL_ENTRY)&_ZN6S515C3D1Ev,
  (VTBL_ENTRY)&_ZN6S515C3D0Ev,
  (VTBL_ENTRY)&_ZN6S515C53v27Ev,
  (VTBL_ENTRY)&_ZN6S515C53v28Ev,
  (VTBL_ENTRY)&_ZN6S515C53v29Ev,
  (VTBL_ENTRY)&_ZN6S515C53v30Ev,
  (VTBL_ENTRY)&_ZN6S515C53v31Ev,
  (VTBL_ENTRY)&_ZN6S515C53v32Ev,
  (VTBL_ENTRY)&_ZN6S515C53v33Ev,
  (VTBL_ENTRY)&_ZN6S515C53v34Ev,
  (VTBL_ENTRY)&_ZN6S515C53v35Ev,
  (VTBL_ENTRY)&_ZN6S515C53v36Ev,
  (VTBL_ENTRY)&_ZN6S515C53v37Ev,
  (VTBL_ENTRY)&_ZN6S515C53v38Ev,
  (VTBL_ENTRY)&_ZN6S515C53v39Ev,
  (VTBL_ENTRY)&_ZN6S515C53v40Ev,
  (VTBL_ENTRY)&_ZN6S515C53v41Ev,
  (VTBL_ENTRY)&_ZN6S515C53v42Ev,
  (VTBL_ENTRY)&_ZN6S515C53v43Ev,
  (VTBL_ENTRY)&_ZN6S515C53v44Ev,
  (VTBL_ENTRY)&_ZN6S515C53v45Ev,
  (VTBL_ENTRY)&_ZN6S515C53v46Ev,
  (VTBL_ENTRY)&_ZN6S515C53v47Ev,
  (VTBL_ENTRY)&_ZN6S515C53v48Ev,
  (VTBL_ENTRY)&_ZN6S515C53v49Ev,
  (VTBL_ENTRY)&_ZN6S515C53v50Ev,
  (VTBL_ENTRY)&_ZN6S515C53v51Ev,
  (VTBL_ENTRY)&_ZN6S515C53v52Ev,
  (VTBL_ENTRY)&_ZN6S515C53v53Ev,
  (VTBL_ENTRY)&_ZN6S515C53v54Ev,
  (VTBL_ENTRY)&_ZN6S515C53v55Ev,
  (VTBL_ENTRY)&_ZN6S515C53v56Ev,
  (VTBL_ENTRY)&_ZN6S515C53v57Ev,
  (VTBL_ENTRY)&_ZN6S515C53v58Ev,
  (VTBL_ENTRY)&_ZN6S515C53v59Ev,
  (VTBL_ENTRY)&_ZN6S515C53v60Ev,
  (VTBL_ENTRY)&_ZN6S515C53v61Ev,
  (VTBL_ENTRY)&_ZN6S515C53v62Ev,
  (VTBL_ENTRY)&_ZN6S515C53v63Ev,
  (VTBL_ENTRY)&_ZN6S515C53v64Ev,
  (VTBL_ENTRY)&_ZN6S515C53v65Ev,
  (VTBL_ENTRY)&_ZN6S515C53v66Ev,
  (VTBL_ENTRY)&_ZN6S515C53v67Ev,
  (VTBL_ENTRY)&_ZN6S515C53v68Ev,
  (VTBL_ENTRY)&_ZN6S515C53v69Ev,
  (VTBL_ENTRY)&_ZN6S515C53v70Ev,
  (VTBL_ENTRY)&_ZN6S515C53v71Ev,
  (VTBL_ENTRY)&_ZN6S515C53v72Ev,
  (VTBL_ENTRY)&_ZN6S515C53v73Ev,
  (VTBL_ENTRY)&_ZN6S515C53v74Ev,
  (VTBL_ENTRY)&_ZN6S515C53v75Ev,
  (VTBL_ENTRY)&_ZN6S515C53v76Ev,
  (VTBL_ENTRY)&_ZN6S515C53v77Ev,
  (VTBL_ENTRY)&_ZN6S515C53v78Ev,
  (VTBL_ENTRY)&_ZN6S515C53v79Ev,
  (VTBL_ENTRY)&_ZN6S515C53v80Ev,
  (VTBL_ENTRY)&_ZN6S515C53v81Ev,
  (VTBL_ENTRY)&_ZN6S515C53v82Ev,
  (VTBL_ENTRY)&_ZN6S515C53v83Ev,
  (VTBL_ENTRY)&_ZN6S515C53v84Ev,
  (VTBL_ENTRY)&_ZN6S515C53v85Ev,
  (VTBL_ENTRY)&_ZN6S515C53v86Ev,
  (VTBL_ENTRY)&_ZN6S515C53v87Ev,
  (VTBL_ENTRY)&_ZN6S515C53v88Ev,
  (VTBL_ENTRY)&_ZN6S515C53v89Ev,
  (VTBL_ENTRY)&_ZN6S515C53v90Ev,
  (VTBL_ENTRY)&_ZN6S515C43v91Ev,
  (VTBL_ENTRY)&_ZN6S515C43v92Ev,
  (VTBL_ENTRY)&_ZN6S515C33v93Ev,
  (VTBL_ENTRY)&_ZN6S515C33v94Ev,
  (VTBL_ENTRY)&_ZN6S515C33v95Ev,
  (VTBL_ENTRY)&_ZN6S515C33v96Ev,
  (VTBL_ENTRY)&_ZN6S515C33v97Ev,
  (VTBL_ENTRY)&_ZN6S515C33v98Ev,
  (VTBL_ENTRY)&_ZN6S515C33v99Ev,
  (VTBL_ENTRY)&_ZN6S515C34v100Ev,
  (VTBL_ENTRY)&_ZN6S515C34v101Ev,
  (VTBL_ENTRY)&_ZN6S515C34v102Ev,
  (VTBL_ENTRY)&_ZN6S515C34v103Ev,
  (VTBL_ENTRY)&_ZN6S515C34v104Ev,
};
extern VTBL_ENTRY _ZTI6S515C3[];
extern  VTBL_ENTRY _ZTV6S515C3[];
Class_Descriptor cd_S515C3 = {  "S515C3", // class name
  bases_S515C3, 2,
  &(vtc_S515C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S515C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S515C3),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C2  : S515C3 {
  ::S3422C4_nt s515c2f0;
  ::S3422C23 s515c2f1;
  ::S49C12_nt s515c2f2;
  virtual  ~S515C2(); // _ZN6S515C2D1Ev
  virtual void  v105(); // _ZN6S515C24v105Ev
  virtual void  v106(); // _ZN6S515C24v106Ev
  virtual void  v107(); // _ZN6S515C24v107Ev
  virtual void  v108(); // _ZN6S515C24v108Ev
  virtual void  v109(); // _ZN6S515C24v109Ev
  virtual void  v110(); // _ZN6S515C24v110Ev
  virtual void  v111(); // _ZN6S515C24v111Ev
  virtual void  v112(); // _ZN6S515C24v112Ev
  virtual void  v113(); // _ZN6S515C24v113Ev
  S515C2(); // tgen
};
//SIG(-1 S515C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S515C2 ::~S515C2(){ note_dtor("S515C2", this);}
void  S515C2 ::v105(){vfunc_called(this, "_ZN6S515C24v105Ev");}
void  S515C2 ::v106(){vfunc_called(this, "_ZN6S515C24v106Ev");}
void  S515C2 ::v107(){vfunc_called(this, "_ZN6S515C24v107Ev");}
void  S515C2 ::v108(){vfunc_called(this, "_ZN6S515C24v108Ev");}
void  S515C2 ::v109(){vfunc_called(this, "_ZN6S515C24v109Ev");}
void  S515C2 ::v110(){vfunc_called(this, "_ZN6S515C24v110Ev");}
void  S515C2 ::v111(){vfunc_called(this, "_ZN6S515C24v111Ev");}
void  S515C2 ::v112(){vfunc_called(this, "_ZN6S515C24v112Ev");}
void  S515C2 ::v113(){vfunc_called(this, "_ZN6S515C24v113Ev");}
S515C2 ::S515C2(){ note_ctor("S515C2", this);} // tgen

static void Test_S515C2()
{
  extern Class_Descriptor cd_S515C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S515C2, buf);
    S515C2 *dp, &lv = *(dp=new (buf) S515C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S515C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C2)");
    check_base_class_offset(lv, (S515C5*)(S515C4*)(S515C3*), 0, "S515C2");
    check_base_class_offset(lv, (S515C4*)(S515C3*), 0, "S515C2");
    check_base_class_offset(lv, (S515C3*), 0, "S515C2");
    check_field_offset(lv, s515c2f0, ABISELECT(136,88), "S515C2.s515c2f0");
    check_field_offset(lv, s515c2f1, ABISELECT(144,96), "S515C2.s515c2f1");
    check_field_offset(lv, s515c2f2, ABISELECT(160,108), "S515C2.s515c2f2");
    test_class_info(&lv, &cd_S515C2);
    dp->~S515C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C2(Test_S515C2, "S515C2", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S515C2C1Ev();
extern void _ZN6S515C2D1Ev();
Name_Map name_map_S515C2[] = {
  NSPAIR(_ZN6S515C2C1Ev),
  NSPAIR(_ZN6S515C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S515C5;
extern VTBL_ENTRY _ZTI6S515C5[];
extern  VTBL_ENTRY _ZTV6S515C5[];
extern Class_Descriptor cd_S515C4;
extern VTBL_ENTRY _ZTI6S515C4[];
extern  VTBL_ENTRY _ZTV6S515C4[];
extern Class_Descriptor cd_S515C3;
extern VTBL_ENTRY _ZTI6S515C3[];
extern  VTBL_ENTRY _ZTV6S515C3[];
static Base_Class bases_S515C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S515C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S515C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S515C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S515C2[];
extern void _ZN6S515C2D1Ev();
extern void _ZN6S515C2D0Ev();
extern void _ZN6S515C53v27Ev();
extern void _ZN6S515C53v28Ev();
extern void _ZN6S515C53v29Ev();
extern void _ZN6S515C53v30Ev();
extern void _ZN6S515C53v31Ev();
extern void _ZN6S515C53v32Ev();
extern void _ZN6S515C53v33Ev();
extern void _ZN6S515C53v34Ev();
extern void _ZN6S515C53v35Ev();
extern void _ZN6S515C53v36Ev();
extern void _ZN6S515C53v37Ev();
extern void _ZN6S515C53v38Ev();
extern void _ZN6S515C53v39Ev();
extern void _ZN6S515C53v40Ev();
extern void _ZN6S515C53v41Ev();
extern void _ZN6S515C53v42Ev();
extern void _ZN6S515C53v43Ev();
extern void _ZN6S515C53v44Ev();
extern void _ZN6S515C53v45Ev();
extern void _ZN6S515C53v46Ev();
extern void _ZN6S515C53v47Ev();
extern void _ZN6S515C53v48Ev();
extern void _ZN6S515C53v49Ev();
extern void _ZN6S515C53v50Ev();
extern void _ZN6S515C53v51Ev();
extern void _ZN6S515C53v52Ev();
extern void _ZN6S515C53v53Ev();
extern void _ZN6S515C53v54Ev();
extern void _ZN6S515C53v55Ev();
extern void _ZN6S515C53v56Ev();
extern void _ZN6S515C53v57Ev();
extern void _ZN6S515C53v58Ev();
extern void _ZN6S515C53v59Ev();
extern void _ZN6S515C53v60Ev();
extern void _ZN6S515C53v61Ev();
extern void _ZN6S515C53v62Ev();
extern void _ZN6S515C53v63Ev();
extern void _ZN6S515C53v64Ev();
extern void _ZN6S515C53v65Ev();
extern void _ZN6S515C53v66Ev();
extern void _ZN6S515C53v67Ev();
extern void _ZN6S515C53v68Ev();
extern void _ZN6S515C53v69Ev();
extern void _ZN6S515C53v70Ev();
extern void _ZN6S515C53v71Ev();
extern void _ZN6S515C53v72Ev();
extern void _ZN6S515C53v73Ev();
extern void _ZN6S515C53v74Ev();
extern void _ZN6S515C53v75Ev();
extern void _ZN6S515C53v76Ev();
extern void _ZN6S515C53v77Ev();
extern void _ZN6S515C53v78Ev();
extern void _ZN6S515C53v79Ev();
extern void _ZN6S515C53v80Ev();
extern void _ZN6S515C53v81Ev();
extern void _ZN6S515C53v82Ev();
extern void _ZN6S515C53v83Ev();
extern void _ZN6S515C53v84Ev();
extern void _ZN6S515C53v85Ev();
extern void _ZN6S515C53v86Ev();
extern void _ZN6S515C53v87Ev();
extern void _ZN6S515C53v88Ev();
extern void _ZN6S515C53v89Ev();
extern void _ZN6S515C53v90Ev();
extern void _ZN6S515C43v91Ev();
extern void _ZN6S515C43v92Ev();
extern void _ZN6S515C33v93Ev();
extern void _ZN6S515C33v94Ev();
extern void _ZN6S515C33v95Ev();
extern void _ZN6S515C33v96Ev();
extern void _ZN6S515C33v97Ev();
extern void _ZN6S515C33v98Ev();
extern void _ZN6S515C33v99Ev();
extern void _ZN6S515C34v100Ev();
extern void _ZN6S515C34v101Ev();
extern void _ZN6S515C34v102Ev();
extern void _ZN6S515C34v103Ev();
extern void _ZN6S515C34v104Ev();
extern void _ZN6S515C24v105Ev();
extern void _ZN6S515C24v106Ev();
extern void _ZN6S515C24v107Ev();
extern void _ZN6S515C24v108Ev();
extern void _ZN6S515C24v109Ev();
extern void _ZN6S515C24v110Ev();
extern void _ZN6S515C24v111Ev();
extern void _ZN6S515C24v112Ev();
extern void _ZN6S515C24v113Ev();
static  VTBL_ENTRY vtc_S515C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S515C2[0]),
  (VTBL_ENTRY)&_ZN6S515C2D1Ev,
  (VTBL_ENTRY)&_ZN6S515C2D0Ev,
  (VTBL_ENTRY)&_ZN6S515C53v27Ev,
  (VTBL_ENTRY)&_ZN6S515C53v28Ev,
  (VTBL_ENTRY)&_ZN6S515C53v29Ev,
  (VTBL_ENTRY)&_ZN6S515C53v30Ev,
  (VTBL_ENTRY)&_ZN6S515C53v31Ev,
  (VTBL_ENTRY)&_ZN6S515C53v32Ev,
  (VTBL_ENTRY)&_ZN6S515C53v33Ev,
  (VTBL_ENTRY)&_ZN6S515C53v34Ev,
  (VTBL_ENTRY)&_ZN6S515C53v35Ev,
  (VTBL_ENTRY)&_ZN6S515C53v36Ev,
  (VTBL_ENTRY)&_ZN6S515C53v37Ev,
  (VTBL_ENTRY)&_ZN6S515C53v38Ev,
  (VTBL_ENTRY)&_ZN6S515C53v39Ev,
  (VTBL_ENTRY)&_ZN6S515C53v40Ev,
  (VTBL_ENTRY)&_ZN6S515C53v41Ev,
  (VTBL_ENTRY)&_ZN6S515C53v42Ev,
  (VTBL_ENTRY)&_ZN6S515C53v43Ev,
  (VTBL_ENTRY)&_ZN6S515C53v44Ev,
  (VTBL_ENTRY)&_ZN6S515C53v45Ev,
  (VTBL_ENTRY)&_ZN6S515C53v46Ev,
  (VTBL_ENTRY)&_ZN6S515C53v47Ev,
  (VTBL_ENTRY)&_ZN6S515C53v48Ev,
  (VTBL_ENTRY)&_ZN6S515C53v49Ev,
  (VTBL_ENTRY)&_ZN6S515C53v50Ev,
  (VTBL_ENTRY)&_ZN6S515C53v51Ev,
  (VTBL_ENTRY)&_ZN6S515C53v52Ev,
  (VTBL_ENTRY)&_ZN6S515C53v53Ev,
  (VTBL_ENTRY)&_ZN6S515C53v54Ev,
  (VTBL_ENTRY)&_ZN6S515C53v55Ev,
  (VTBL_ENTRY)&_ZN6S515C53v56Ev,
  (VTBL_ENTRY)&_ZN6S515C53v57Ev,
  (VTBL_ENTRY)&_ZN6S515C53v58Ev,
  (VTBL_ENTRY)&_ZN6S515C53v59Ev,
  (VTBL_ENTRY)&_ZN6S515C53v60Ev,
  (VTBL_ENTRY)&_ZN6S515C53v61Ev,
  (VTBL_ENTRY)&_ZN6S515C53v62Ev,
  (VTBL_ENTRY)&_ZN6S515C53v63Ev,
  (VTBL_ENTRY)&_ZN6S515C53v64Ev,
  (VTBL_ENTRY)&_ZN6S515C53v65Ev,
  (VTBL_ENTRY)&_ZN6S515C53v66Ev,
  (VTBL_ENTRY)&_ZN6S515C53v67Ev,
  (VTBL_ENTRY)&_ZN6S515C53v68Ev,
  (VTBL_ENTRY)&_ZN6S515C53v69Ev,
  (VTBL_ENTRY)&_ZN6S515C53v70Ev,
  (VTBL_ENTRY)&_ZN6S515C53v71Ev,
  (VTBL_ENTRY)&_ZN6S515C53v72Ev,
  (VTBL_ENTRY)&_ZN6S515C53v73Ev,
  (VTBL_ENTRY)&_ZN6S515C53v74Ev,
  (VTBL_ENTRY)&_ZN6S515C53v75Ev,
  (VTBL_ENTRY)&_ZN6S515C53v76Ev,
  (VTBL_ENTRY)&_ZN6S515C53v77Ev,
  (VTBL_ENTRY)&_ZN6S515C53v78Ev,
  (VTBL_ENTRY)&_ZN6S515C53v79Ev,
  (VTBL_ENTRY)&_ZN6S515C53v80Ev,
  (VTBL_ENTRY)&_ZN6S515C53v81Ev,
  (VTBL_ENTRY)&_ZN6S515C53v82Ev,
  (VTBL_ENTRY)&_ZN6S515C53v83Ev,
  (VTBL_ENTRY)&_ZN6S515C53v84Ev,
  (VTBL_ENTRY)&_ZN6S515C53v85Ev,
  (VTBL_ENTRY)&_ZN6S515C53v86Ev,
  (VTBL_ENTRY)&_ZN6S515C53v87Ev,
  (VTBL_ENTRY)&_ZN6S515C53v88Ev,
  (VTBL_ENTRY)&_ZN6S515C53v89Ev,
  (VTBL_ENTRY)&_ZN6S515C53v90Ev,
  (VTBL_ENTRY)&_ZN6S515C43v91Ev,
  (VTBL_ENTRY)&_ZN6S515C43v92Ev,
  (VTBL_ENTRY)&_ZN6S515C33v93Ev,
  (VTBL_ENTRY)&_ZN6S515C33v94Ev,
  (VTBL_ENTRY)&_ZN6S515C33v95Ev,
  (VTBL_ENTRY)&_ZN6S515C33v96Ev,
  (VTBL_ENTRY)&_ZN6S515C33v97Ev,
  (VTBL_ENTRY)&_ZN6S515C33v98Ev,
  (VTBL_ENTRY)&_ZN6S515C33v99Ev,
  (VTBL_ENTRY)&_ZN6S515C34v100Ev,
  (VTBL_ENTRY)&_ZN6S515C34v101Ev,
  (VTBL_ENTRY)&_ZN6S515C34v102Ev,
  (VTBL_ENTRY)&_ZN6S515C34v103Ev,
  (VTBL_ENTRY)&_ZN6S515C34v104Ev,
  (VTBL_ENTRY)&_ZN6S515C24v105Ev,
  (VTBL_ENTRY)&_ZN6S515C24v106Ev,
  (VTBL_ENTRY)&_ZN6S515C24v107Ev,
  (VTBL_ENTRY)&_ZN6S515C24v108Ev,
  (VTBL_ENTRY)&_ZN6S515C24v109Ev,
  (VTBL_ENTRY)&_ZN6S515C24v110Ev,
  (VTBL_ENTRY)&_ZN6S515C24v111Ev,
  (VTBL_ENTRY)&_ZN6S515C24v112Ev,
  (VTBL_ENTRY)&_ZN6S515C24v113Ev,
};
extern VTBL_ENTRY _ZTI6S515C2[];
extern  VTBL_ENTRY _ZTV6S515C2[];
Class_Descriptor cd_S515C2 = {  "S515C2", // class name
  bases_S515C2, 3,
  &(vtc_S515C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S515C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S515C2),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C11  {
  virtual  ~S515C11(); // _ZN7S515C11D1Ev
  virtual void  v114(); // _ZN7S515C114v114Ev
  virtual void  v115(); // _ZN7S515C114v115Ev
  virtual void  v116(); // _ZN7S515C114v116Ev
  virtual void  v117(); // _ZN7S515C114v117Ev
  virtual void  v118(); // _ZN7S515C114v118Ev
  virtual void  v119(); // _ZN7S515C114v119Ev
  virtual void  v120(); // _ZN7S515C114v120Ev
  virtual void  v121(); // _ZN7S515C114v121Ev
  S515C11(); // tgen
};
//SIG(-1 S515C11) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S515C11 ::~S515C11(){ note_dtor("S515C11", this);}
void  S515C11 ::v114(){vfunc_called(this, "_ZN7S515C114v114Ev");}
void  S515C11 ::v115(){vfunc_called(this, "_ZN7S515C114v115Ev");}
void  S515C11 ::v116(){vfunc_called(this, "_ZN7S515C114v116Ev");}
void  S515C11 ::v117(){vfunc_called(this, "_ZN7S515C114v117Ev");}
void  S515C11 ::v118(){vfunc_called(this, "_ZN7S515C114v118Ev");}
void  S515C11 ::v119(){vfunc_called(this, "_ZN7S515C114v119Ev");}
void  S515C11 ::v120(){vfunc_called(this, "_ZN7S515C114v120Ev");}
void  S515C11 ::v121(){vfunc_called(this, "_ZN7S515C114v121Ev");}
S515C11 ::S515C11(){ note_ctor("S515C11", this);} // tgen

static void Test_S515C11()
{
  extern Class_Descriptor cd_S515C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S515C11, buf);
    S515C11 *dp, &lv = *(dp=new (buf) S515C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S515C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C11)");
    test_class_info(&lv, &cd_S515C11);
    dp->~S515C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C11(Test_S515C11, "S515C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S515C11C1Ev();
extern void _ZN7S515C11D1Ev();
Name_Map name_map_S515C11[] = {
  NSPAIR(_ZN7S515C11C1Ev),
  NSPAIR(_ZN7S515C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S515C11[];
extern void _ZN7S515C11D1Ev();
extern void _ZN7S515C11D0Ev();
extern void _ZN7S515C114v114Ev();
extern void _ZN7S515C114v115Ev();
extern void _ZN7S515C114v116Ev();
extern void _ZN7S515C114v117Ev();
extern void _ZN7S515C114v118Ev();
extern void _ZN7S515C114v119Ev();
extern void _ZN7S515C114v120Ev();
extern void _ZN7S515C114v121Ev();
static  VTBL_ENTRY vtc_S515C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S515C11[0]),
  (VTBL_ENTRY)&_ZN7S515C11D1Ev,
  (VTBL_ENTRY)&_ZN7S515C11D0Ev,
  (VTBL_ENTRY)&_ZN7S515C114v114Ev,
  (VTBL_ENTRY)&_ZN7S515C114v115Ev,
  (VTBL_ENTRY)&_ZN7S515C114v116Ev,
  (VTBL_ENTRY)&_ZN7S515C114v117Ev,
  (VTBL_ENTRY)&_ZN7S515C114v118Ev,
  (VTBL_ENTRY)&_ZN7S515C114v119Ev,
  (VTBL_ENTRY)&_ZN7S515C114v120Ev,
  (VTBL_ENTRY)&_ZN7S515C114v121Ev,
};
extern VTBL_ENTRY _ZTI7S515C11[];
extern  VTBL_ENTRY _ZTV7S515C11[];
Class_Descriptor cd_S515C11 = {  "S515C11", // class name
  0,0,//no base classes
  &(vtc_S515C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S515C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S515C11),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C12  {
  virtual  ~S515C12(); // _ZN7S515C12D1Ev
  virtual void  v122(); // _ZN7S515C124v122Ev
  virtual void  v123(); // _ZN7S515C124v123Ev
  virtual void  v124(); // _ZN7S515C124v124Ev
  virtual void  v125(); // _ZN7S515C124v125Ev
  S515C12(); // tgen
};
//SIG(-1 S515C12) C1{ vd v1 v2 v3 v4}


 S515C12 ::~S515C12(){ note_dtor("S515C12", this);}
void  S515C12 ::v122(){vfunc_called(this, "_ZN7S515C124v122Ev");}
void  S515C12 ::v123(){vfunc_called(this, "_ZN7S515C124v123Ev");}
void  S515C12 ::v124(){vfunc_called(this, "_ZN7S515C124v124Ev");}
void  S515C12 ::v125(){vfunc_called(this, "_ZN7S515C124v125Ev");}
S515C12 ::S515C12(){ note_ctor("S515C12", this);} // tgen

static void Test_S515C12()
{
  extern Class_Descriptor cd_S515C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S515C12, buf);
    S515C12 *dp, &lv = *(dp=new (buf) S515C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S515C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C12)");
    test_class_info(&lv, &cd_S515C12);
    dp->~S515C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C12(Test_S515C12, "S515C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S515C12C1Ev();
extern void _ZN7S515C12D1Ev();
Name_Map name_map_S515C12[] = {
  NSPAIR(_ZN7S515C12C1Ev),
  NSPAIR(_ZN7S515C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S515C12[];
extern void _ZN7S515C12D1Ev();
extern void _ZN7S515C12D0Ev();
extern void _ZN7S515C124v122Ev();
extern void _ZN7S515C124v123Ev();
extern void _ZN7S515C124v124Ev();
extern void _ZN7S515C124v125Ev();
static  VTBL_ENTRY vtc_S515C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S515C12[0]),
  (VTBL_ENTRY)&_ZN7S515C12D1Ev,
  (VTBL_ENTRY)&_ZN7S515C12D0Ev,
  (VTBL_ENTRY)&_ZN7S515C124v122Ev,
  (VTBL_ENTRY)&_ZN7S515C124v123Ev,
  (VTBL_ENTRY)&_ZN7S515C124v124Ev,
  (VTBL_ENTRY)&_ZN7S515C124v125Ev,
};
extern VTBL_ENTRY _ZTI7S515C12[];
extern  VTBL_ENTRY _ZTV7S515C12[];
Class_Descriptor cd_S515C12 = {  "S515C12", // class name
  0,0,//no base classes
  &(vtc_S515C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S515C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S515C12),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S515C1  : S515C2 , S515C11 , S515C12 {
  ::S3422C17 s515c1f0;
  virtual  ~S515C1(); // _ZN6S515C1D1Ev
  virtual void  v1(); // _ZN6S515C12v1Ev
  virtual void  v2(); // _ZN6S515C12v2Ev
  virtual void  v3(); // _ZN6S515C12v3Ev
  virtual void  v4(); // _ZN6S515C12v4Ev
  virtual void  v5(); // _ZN6S515C12v5Ev
  virtual void  v6(); // _ZN6S515C12v6Ev
  virtual void  v7(); // _ZN6S515C12v7Ev
  virtual void  v8(); // _ZN6S515C12v8Ev
  virtual void  v9(); // _ZN6S515C12v9Ev
  virtual void  v10(); // _ZN6S515C13v10Ev
  virtual void  v11(); // _ZN6S515C13v11Ev
  virtual void  v12(); // _ZN6S515C13v12Ev
  virtual void  v13(); // _ZN6S515C13v13Ev
  virtual void  v14(); // _ZN6S515C13v14Ev
  virtual void  v15(); // _ZN6S515C13v15Ev
  virtual void  v16(); // _ZN6S515C13v16Ev
  virtual void  v17(); // _ZN6S515C13v17Ev
  virtual void  v18(); // _ZN6S515C13v18Ev
  virtual void  v19(); // _ZN6S515C13v19Ev
  virtual void  v20(); // _ZN6S515C13v20Ev
  virtual void  v21(); // _ZN6S515C13v21Ev
  virtual void  v22(); // _ZN6S515C13v22Ev
  virtual void  v23(); // _ZN6S515C13v23Ev
  virtual void  v24(); // _ZN6S515C13v24Ev
  virtual void  v25(); // _ZN6S515C13v25Ev
  virtual void  v26(); // _ZN6S515C13v26Ev
  S515C1(); // tgen
};
//SIG(1 S515C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v91 v92} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v105 v106 v107 v108 v109 v110 v111 v112 v113 FC6 FC7 FC10} BC11{ vd v114 v115 v116 v117 v118 v119 v120 v121} BC12{ vd v122 v123 v124 v125} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 FC13{ BC14{ BC9}}}


 S515C1 ::~S515C1(){ note_dtor("S515C1", this);}
void  S515C1 ::v1(){vfunc_called(this, "_ZN6S515C12v1Ev");}
void  S515C1 ::v2(){vfunc_called(this, "_ZN6S515C12v2Ev");}
void  S515C1 ::v3(){vfunc_called(this, "_ZN6S515C12v3Ev");}
void  S515C1 ::v4(){vfunc_called(this, "_ZN6S515C12v4Ev");}
void  S515C1 ::v5(){vfunc_called(this, "_ZN6S515C12v5Ev");}
void  S515C1 ::v6(){vfunc_called(this, "_ZN6S515C12v6Ev");}
void  S515C1 ::v7(){vfunc_called(this, "_ZN6S515C12v7Ev");}
void  S515C1 ::v8(){vfunc_called(this, "_ZN6S515C12v8Ev");}
void  S515C1 ::v9(){vfunc_called(this, "_ZN6S515C12v9Ev");}
void  S515C1 ::v10(){vfunc_called(this, "_ZN6S515C13v10Ev");}
void  S515C1 ::v11(){vfunc_called(this, "_ZN6S515C13v11Ev");}
void  S515C1 ::v12(){vfunc_called(this, "_ZN6S515C13v12Ev");}
void  S515C1 ::v13(){vfunc_called(this, "_ZN6S515C13v13Ev");}
void  S515C1 ::v14(){vfunc_called(this, "_ZN6S515C13v14Ev");}
void  S515C1 ::v15(){vfunc_called(this, "_ZN6S515C13v15Ev");}
void  S515C1 ::v16(){vfunc_called(this, "_ZN6S515C13v16Ev");}
void  S515C1 ::v17(){vfunc_called(this, "_ZN6S515C13v17Ev");}
void  S515C1 ::v18(){vfunc_called(this, "_ZN6S515C13v18Ev");}
void  S515C1 ::v19(){vfunc_called(this, "_ZN6S515C13v19Ev");}
void  S515C1 ::v20(){vfunc_called(this, "_ZN6S515C13v20Ev");}
void  S515C1 ::v21(){vfunc_called(this, "_ZN6S515C13v21Ev");}
void  S515C1 ::v22(){vfunc_called(this, "_ZN6S515C13v22Ev");}
void  S515C1 ::v23(){vfunc_called(this, "_ZN6S515C13v23Ev");}
void  S515C1 ::v24(){vfunc_called(this, "_ZN6S515C13v24Ev");}
void  S515C1 ::v25(){vfunc_called(this, "_ZN6S515C13v25Ev");}
void  S515C1 ::v26(){vfunc_called(this, "_ZN6S515C13v26Ev");}
S515C1 ::S515C1(){ note_ctor("S515C1", this);} // tgen

static void Test_S515C1()
{
  extern Class_Descriptor cd_S515C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,36)];
    init_test(&cd_S515C1, buf);
    S515C1 *dp, &lv = *(dp=new (buf) S515C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,140), "sizeof(S515C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S515C1)");
    check_base_class_offset(lv, (S515C5*)(S515C4*)(S515C3*)(S515C2*), 0, "S515C1");
    check_base_class_offset(lv, (S515C4*)(S515C3*)(S515C2*), 0, "S515C1");
    check_base_class_offset(lv, (S515C3*)(S515C2*), 0, "S515C1");
    check_base_class_offset(lv, (S515C2*), 0, "S515C1");
    check_base_class_offset(lv, (S515C11*), ABISELECT(176,120), "S515C1");
    check_base_class_offset(lv, (S515C12*), ABISELECT(184,124), "S515C1");
    check_field_offset(lv, s515c1f0, ABISELECT(192,128), "S515C1.s515c1f0");
    test_class_info(&lv, &cd_S515C1);
    dp->~S515C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS515C1(Test_S515C1, "S515C1", ABISELECT(208,140));

#else // __cplusplus

extern void _ZN6S515C1C1Ev();
extern void _ZN6S515C1D1Ev();
Name_Map name_map_S515C1[] = {
  NSPAIR(_ZN6S515C1C1Ev),
  NSPAIR(_ZN6S515C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S515C5;
extern VTBL_ENTRY _ZTI6S515C5[];
extern  VTBL_ENTRY _ZTV6S515C5[];
extern Class_Descriptor cd_S515C4;
extern VTBL_ENTRY _ZTI6S515C4[];
extern  VTBL_ENTRY _ZTV6S515C4[];
extern Class_Descriptor cd_S515C3;
extern VTBL_ENTRY _ZTI6S515C3[];
extern  VTBL_ENTRY _ZTV6S515C3[];
extern Class_Descriptor cd_S515C2;
extern VTBL_ENTRY _ZTI6S515C2[];
extern  VTBL_ENTRY _ZTV6S515C2[];
extern Class_Descriptor cd_S515C11;
extern VTBL_ENTRY _ZTI7S515C11[];
extern  VTBL_ENTRY _ZTV7S515C11[];
extern Class_Descriptor cd_S515C12;
extern VTBL_ENTRY _ZTI7S515C12[];
extern  VTBL_ENTRY _ZTV7S515C12[];
static Base_Class bases_S515C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S515C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S515C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S515C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S515C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S515C11,    ABISELECT(176,120), //bcp->offset
    117, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S515C12,    ABISELECT(184,124), //bcp->offset
    129, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S515C1[];
extern void _ZN6S515C1D1Ev();
extern void _ZN6S515C1D0Ev();
extern void _ZN6S515C53v27Ev();
extern void _ZN6S515C53v28Ev();
extern void _ZN6S515C53v29Ev();
extern void _ZN6S515C53v30Ev();
extern void _ZN6S515C53v31Ev();
extern void _ZN6S515C53v32Ev();
extern void _ZN6S515C53v33Ev();
extern void _ZN6S515C53v34Ev();
extern void _ZN6S515C53v35Ev();
extern void _ZN6S515C53v36Ev();
extern void _ZN6S515C53v37Ev();
extern void _ZN6S515C53v38Ev();
extern void _ZN6S515C53v39Ev();
extern void _ZN6S515C53v40Ev();
extern void _ZN6S515C53v41Ev();
extern void _ZN6S515C53v42Ev();
extern void _ZN6S515C53v43Ev();
extern void _ZN6S515C53v44Ev();
extern void _ZN6S515C53v45Ev();
extern void _ZN6S515C53v46Ev();
extern void _ZN6S515C53v47Ev();
extern void _ZN6S515C53v48Ev();
extern void _ZN6S515C53v49Ev();
extern void _ZN6S515C53v50Ev();
extern void _ZN6S515C53v51Ev();
extern void _ZN6S515C53v52Ev();
extern void _ZN6S515C53v53Ev();
extern void _ZN6S515C53v54Ev();
extern void _ZN6S515C53v55Ev();
extern void _ZN6S515C53v56Ev();
extern void _ZN6S515C53v57Ev();
extern void _ZN6S515C53v58Ev();
extern void _ZN6S515C53v59Ev();
extern void _ZN6S515C53v60Ev();
extern void _ZN6S515C53v61Ev();
extern void _ZN6S515C53v62Ev();
extern void _ZN6S515C53v63Ev();
extern void _ZN6S515C53v64Ev();
extern void _ZN6S515C53v65Ev();
extern void _ZN6S515C53v66Ev();
extern void _ZN6S515C53v67Ev();
extern void _ZN6S515C53v68Ev();
extern void _ZN6S515C53v69Ev();
extern void _ZN6S515C53v70Ev();
extern void _ZN6S515C53v71Ev();
extern void _ZN6S515C53v72Ev();
extern void _ZN6S515C53v73Ev();
extern void _ZN6S515C53v74Ev();
extern void _ZN6S515C53v75Ev();
extern void _ZN6S515C53v76Ev();
extern void _ZN6S515C53v77Ev();
extern void _ZN6S515C53v78Ev();
extern void _ZN6S515C53v79Ev();
extern void _ZN6S515C53v80Ev();
extern void _ZN6S515C53v81Ev();
extern void _ZN6S515C53v82Ev();
extern void _ZN6S515C53v83Ev();
extern void _ZN6S515C53v84Ev();
extern void _ZN6S515C53v85Ev();
extern void _ZN6S515C53v86Ev();
extern void _ZN6S515C53v87Ev();
extern void _ZN6S515C53v88Ev();
extern void _ZN6S515C53v89Ev();
extern void _ZN6S515C53v90Ev();
extern void _ZN6S515C43v91Ev();
extern void _ZN6S515C43v92Ev();
extern void _ZN6S515C33v93Ev();
extern void _ZN6S515C33v94Ev();
extern void _ZN6S515C33v95Ev();
extern void _ZN6S515C33v96Ev();
extern void _ZN6S515C33v97Ev();
extern void _ZN6S515C33v98Ev();
extern void _ZN6S515C33v99Ev();
extern void _ZN6S515C34v100Ev();
extern void _ZN6S515C34v101Ev();
extern void _ZN6S515C34v102Ev();
extern void _ZN6S515C34v103Ev();
extern void _ZN6S515C34v104Ev();
extern void _ZN6S515C24v105Ev();
extern void _ZN6S515C24v106Ev();
extern void _ZN6S515C24v107Ev();
extern void _ZN6S515C24v108Ev();
extern void _ZN6S515C24v109Ev();
extern void _ZN6S515C24v110Ev();
extern void _ZN6S515C24v111Ev();
extern void _ZN6S515C24v112Ev();
extern void _ZN6S515C24v113Ev();
extern void _ZN6S515C12v1Ev();
extern void _ZN6S515C12v2Ev();
extern void _ZN6S515C12v3Ev();
extern void _ZN6S515C12v4Ev();
extern void _ZN6S515C12v5Ev();
extern void _ZN6S515C12v6Ev();
extern void _ZN6S515C12v7Ev();
extern void _ZN6S515C12v8Ev();
extern void _ZN6S515C12v9Ev();
extern void _ZN6S515C13v10Ev();
extern void _ZN6S515C13v11Ev();
extern void _ZN6S515C13v12Ev();
extern void _ZN6S515C13v13Ev();
extern void _ZN6S515C13v14Ev();
extern void _ZN6S515C13v15Ev();
extern void _ZN6S515C13v16Ev();
extern void _ZN6S515C13v17Ev();
extern void _ZN6S515C13v18Ev();
extern void _ZN6S515C13v19Ev();
extern void _ZN6S515C13v20Ev();
extern void _ZN6S515C13v21Ev();
extern void _ZN6S515C13v22Ev();
extern void _ZN6S515C13v23Ev();
extern void _ZN6S515C13v24Ev();
extern void _ZN6S515C13v25Ev();
extern void _ZN6S515C13v26Ev();
extern void ABISELECT(_ZThn176_N6S515C1D1Ev,_ZThn120_N6S515C1D1Ev)();
extern void ABISELECT(_ZThn176_N6S515C1D0Ev,_ZThn120_N6S515C1D0Ev)();
extern void _ZN7S515C114v114Ev();
extern void _ZN7S515C114v115Ev();
extern void _ZN7S515C114v116Ev();
extern void _ZN7S515C114v117Ev();
extern void _ZN7S515C114v118Ev();
extern void _ZN7S515C114v119Ev();
extern void _ZN7S515C114v120Ev();
extern void _ZN7S515C114v121Ev();
extern void ABISELECT(_ZThn184_N6S515C1D1Ev,_ZThn124_N6S515C1D1Ev)();
extern void ABISELECT(_ZThn184_N6S515C1D0Ev,_ZThn124_N6S515C1D0Ev)();
extern void _ZN7S515C124v122Ev();
extern void _ZN7S515C124v123Ev();
extern void _ZN7S515C124v124Ev();
extern void _ZN7S515C124v125Ev();
static  VTBL_ENTRY vtc_S515C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S515C1[0]),
  (VTBL_ENTRY)&_ZN6S515C1D1Ev,
  (VTBL_ENTRY)&_ZN6S515C1D0Ev,
  (VTBL_ENTRY)&_ZN6S515C53v27Ev,
  (VTBL_ENTRY)&_ZN6S515C53v28Ev,
  (VTBL_ENTRY)&_ZN6S515C53v29Ev,
  (VTBL_ENTRY)&_ZN6S515C53v30Ev,
  (VTBL_ENTRY)&_ZN6S515C53v31Ev,
  (VTBL_ENTRY)&_ZN6S515C53v32Ev,
  (VTBL_ENTRY)&_ZN6S515C53v33Ev,
  (VTBL_ENTRY)&_ZN6S515C53v34Ev,
  (VTBL_ENTRY)&_ZN6S515C53v35Ev,
  (VTBL_ENTRY)&_ZN6S515C53v36Ev,
  (VTBL_ENTRY)&_ZN6S515C53v37Ev,
  (VTBL_ENTRY)&_ZN6S515C53v38Ev,
  (VTBL_ENTRY)&_ZN6S515C53v39Ev,
  (VTBL_ENTRY)&_ZN6S515C53v40Ev,
  (VTBL_ENTRY)&_ZN6S515C53v41Ev,
  (VTBL_ENTRY)&_ZN6S515C53v42Ev,
  (VTBL_ENTRY)&_ZN6S515C53v43Ev,
  (VTBL_ENTRY)&_ZN6S515C53v44Ev,
  (VTBL_ENTRY)&_ZN6S515C53v45Ev,
  (VTBL_ENTRY)&_ZN6S515C53v46Ev,
  (VTBL_ENTRY)&_ZN6S515C53v47Ev,
  (VTBL_ENTRY)&_ZN6S515C53v48Ev,
  (VTBL_ENTRY)&_ZN6S515C53v49Ev,
  (VTBL_ENTRY)&_ZN6S515C53v50Ev,
  (VTBL_ENTRY)&_ZN6S515C53v51Ev,
  (VTBL_ENTRY)&_ZN6S515C53v52Ev,
  (VTBL_ENTRY)&_ZN6S515C53v53Ev,
  (VTBL_ENTRY)&_ZN6S515C53v54Ev,
  (VTBL_ENTRY)&_ZN6S515C53v55Ev,
  (VTBL_ENTRY)&_ZN6S515C53v56Ev,
  (VTBL_ENTRY)&_ZN6S515C53v57Ev,
  (VTBL_ENTRY)&_ZN6S515C53v58Ev,
  (VTBL_ENTRY)&_ZN6S515C53v59Ev,
  (VTBL_ENTRY)&_ZN6S515C53v60Ev,
  (VTBL_ENTRY)&_ZN6S515C53v61Ev,
  (VTBL_ENTRY)&_ZN6S515C53v62Ev,
  (VTBL_ENTRY)&_ZN6S515C53v63Ev,
  (VTBL_ENTRY)&_ZN6S515C53v64Ev,
  (VTBL_ENTRY)&_ZN6S515C53v65Ev,
  (VTBL_ENTRY)&_ZN6S515C53v66Ev,
  (VTBL_ENTRY)&_ZN6S515C53v67Ev,
  (VTBL_ENTRY)&_ZN6S515C53v68Ev,
  (VTBL_ENTRY)&_ZN6S515C53v69Ev,
  (VTBL_ENTRY)&_ZN6S515C53v70Ev,
  (VTBL_ENTRY)&_ZN6S515C53v71Ev,
  (VTBL_ENTRY)&_ZN6S515C53v72Ev,
  (VTBL_ENTRY)&_ZN6S515C53v73Ev,
  (VTBL_ENTRY)&_ZN6S515C53v74Ev,
  (VTBL_ENTRY)&_ZN6S515C53v75Ev,
  (VTBL_ENTRY)&_ZN6S515C53v76Ev,
  (VTBL_ENTRY)&_ZN6S515C53v77Ev,
  (VTBL_ENTRY)&_ZN6S515C53v78Ev,
  (VTBL_ENTRY)&_ZN6S515C53v79Ev,
  (VTBL_ENTRY)&_ZN6S515C53v80Ev,
  (VTBL_ENTRY)&_ZN6S515C53v81Ev,
  (VTBL_ENTRY)&_ZN6S515C53v82Ev,
  (VTBL_ENTRY)&_ZN6S515C53v83Ev,
  (VTBL_ENTRY)&_ZN6S515C53v84Ev,
  (VTBL_ENTRY)&_ZN6S515C53v85Ev,
  (VTBL_ENTRY)&_ZN6S515C53v86Ev,
  (VTBL_ENTRY)&_ZN6S515C53v87Ev,
  (VTBL_ENTRY)&_ZN6S515C53v88Ev,
  (VTBL_ENTRY)&_ZN6S515C53v89Ev,
  (VTBL_ENTRY)&_ZN6S515C53v90Ev,
  (VTBL_ENTRY)&_ZN6S515C43v91Ev,
  (VTBL_ENTRY)&_ZN6S515C43v92Ev,
  (VTBL_ENTRY)&_ZN6S515C33v93Ev,
  (VTBL_ENTRY)&_ZN6S515C33v94Ev,
  (VTBL_ENTRY)&_ZN6S515C33v95Ev,
  (VTBL_ENTRY)&_ZN6S515C33v96Ev,
  (VTBL_ENTRY)&_ZN6S515C33v97Ev,
  (VTBL_ENTRY)&_ZN6S515C33v98Ev,
  (VTBL_ENTRY)&_ZN6S515C33v99Ev,
  (VTBL_ENTRY)&_ZN6S515C34v100Ev,
  (VTBL_ENTRY)&_ZN6S515C34v101Ev,
  (VTBL_ENTRY)&_ZN6S515C34v102Ev,
  (VTBL_ENTRY)&_ZN6S515C34v103Ev,
  (VTBL_ENTRY)&_ZN6S515C34v104Ev,
  (VTBL_ENTRY)&_ZN6S515C24v105Ev,
  (VTBL_ENTRY)&_ZN6S515C24v106Ev,
  (VTBL_ENTRY)&_ZN6S515C24v107Ev,
  (VTBL_ENTRY)&_ZN6S515C24v108Ev,
  (VTBL_ENTRY)&_ZN6S515C24v109Ev,
  (VTBL_ENTRY)&_ZN6S515C24v110Ev,
  (VTBL_ENTRY)&_ZN6S515C24v111Ev,
  (VTBL_ENTRY)&_ZN6S515C24v112Ev,
  (VTBL_ENTRY)&_ZN6S515C24v113Ev,
  (VTBL_ENTRY)&_ZN6S515C12v1Ev,
  (VTBL_ENTRY)&_ZN6S515C12v2Ev,
  (VTBL_ENTRY)&_ZN6S515C12v3Ev,
  (VTBL_ENTRY)&_ZN6S515C12v4Ev,
  (VTBL_ENTRY)&_ZN6S515C12v5Ev,
  (VTBL_ENTRY)&_ZN6S515C12v6Ev,
  (VTBL_ENTRY)&_ZN6S515C12v7Ev,
  (VTBL_ENTRY)&_ZN6S515C12v8Ev,
  (VTBL_ENTRY)&_ZN6S515C12v9Ev,
  (VTBL_ENTRY)&_ZN6S515C13v10Ev,
  (VTBL_ENTRY)&_ZN6S515C13v11Ev,
  (VTBL_ENTRY)&_ZN6S515C13v12Ev,
  (VTBL_ENTRY)&_ZN6S515C13v13Ev,
  (VTBL_ENTRY)&_ZN6S515C13v14Ev,
  (VTBL_ENTRY)&_ZN6S515C13v15Ev,
  (VTBL_ENTRY)&_ZN6S515C13v16Ev,
  (VTBL_ENTRY)&_ZN6S515C13v17Ev,
  (VTBL_ENTRY)&_ZN6S515C13v18Ev,
  (VTBL_ENTRY)&_ZN6S515C13v19Ev,
  (VTBL_ENTRY)&_ZN6S515C13v20Ev,
  (VTBL_ENTRY)&_ZN6S515C13v21Ev,
  (VTBL_ENTRY)&_ZN6S515C13v22Ev,
  (VTBL_ENTRY)&_ZN6S515C13v23Ev,
  (VTBL_ENTRY)&_ZN6S515C13v24Ev,
  (VTBL_ENTRY)&_ZN6S515C13v25Ev,
  (VTBL_ENTRY)&_ZN6S515C13v26Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S515C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S515C1D1Ev,_ZThn120_N6S515C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S515C1D0Ev,_ZThn120_N6S515C1D0Ev),
  (VTBL_ENTRY)&_ZN7S515C114v114Ev,
  (VTBL_ENTRY)&_ZN7S515C114v115Ev,
  (VTBL_ENTRY)&_ZN7S515C114v116Ev,
  (VTBL_ENTRY)&_ZN7S515C114v117Ev,
  (VTBL_ENTRY)&_ZN7S515C114v118Ev,
  (VTBL_ENTRY)&_ZN7S515C114v119Ev,
  (VTBL_ENTRY)&_ZN7S515C114v120Ev,
  (VTBL_ENTRY)&_ZN7S515C114v121Ev,
  ABISELECT(-184,-124),
  (VTBL_ENTRY)&(_ZTI6S515C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N6S515C1D1Ev,_ZThn124_N6S515C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N6S515C1D0Ev,_ZThn124_N6S515C1D0Ev),
  (VTBL_ENTRY)&_ZN7S515C124v122Ev,
  (VTBL_ENTRY)&_ZN7S515C124v123Ev,
  (VTBL_ENTRY)&_ZN7S515C124v124Ev,
  (VTBL_ENTRY)&_ZN7S515C124v125Ev,
};
extern VTBL_ENTRY _ZTI6S515C1[];
extern  VTBL_ENTRY _ZTV6S515C1[];
Class_Descriptor cd_S515C1 = {  "S515C1", // class name
  bases_S515C1, 6,
  &(vtc_S515C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,140), // object size
  NSPAIRA(_ZTI6S515C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S515C1),137, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C6  {
  int s159c6f0;
  __tsi64 s159c6f1;
  void *s159c6f2[4];
  int s159c6f3[2];
  void *s159c6f4;
  ::S3422C4_nt s159c6f5;
  void *s159c6f6[2];
  virtual  ~S159C6(); // _ZN6S159C6D1Ev
  virtual void  v16(); // _ZN6S159C63v16Ev
  virtual void  v17(); // _ZN6S159C63v17Ev
  virtual void  v18(); // _ZN6S159C63v18Ev
  virtual void  v19(); // _ZN6S159C63v19Ev
  virtual void  v20(); // _ZN6S159C63v20Ev
  virtual void  v21(); // _ZN6S159C63v21Ev
  virtual void  v22(); // _ZN6S159C63v22Ev
  virtual void  v23(); // _ZN6S159C63v23Ev
  virtual void  v24(); // _ZN6S159C63v24Ev
  virtual void  v25(); // _ZN6S159C63v25Ev
  virtual void  v26(); // _ZN6S159C63v26Ev
  virtual void  v27(); // _ZN6S159C63v27Ev
  virtual void  v28(); // _ZN6S159C63v28Ev
  virtual void  v29(); // _ZN6S159C63v29Ev
  virtual void  v30(); // _ZN6S159C63v30Ev
  virtual void  v31(); // _ZN6S159C63v31Ev
  virtual void  v32(); // _ZN6S159C63v32Ev
  virtual void  v33(); // _ZN6S159C63v33Ev
  virtual void  v34(); // _ZN6S159C63v34Ev
  virtual void  v35(); // _ZN6S159C63v35Ev
  virtual void  v36(); // _ZN6S159C63v36Ev
  virtual void  v37(); // _ZN6S159C63v37Ev
  virtual void  v38(); // _ZN6S159C63v38Ev
  virtual void  v39(); // _ZN6S159C63v39Ev
  virtual void  v40(); // _ZN6S159C63v40Ev
  virtual void  v41(); // _ZN6S159C63v41Ev
  virtual void  v42(); // _ZN6S159C63v42Ev
  virtual void  v43(); // _ZN6S159C63v43Ev
  virtual void  v44(); // _ZN6S159C63v44Ev
  virtual void  v45(); // _ZN6S159C63v45Ev
  virtual void  v46(); // _ZN6S159C63v46Ev
  virtual void  v47(); // _ZN6S159C63v47Ev
  virtual void  v48(); // _ZN6S159C63v48Ev
  virtual void  v49(); // _ZN6S159C63v49Ev
  virtual void  v50(); // _ZN6S159C63v50Ev
  virtual void  v51(); // _ZN6S159C63v51Ev
  virtual void  v52(); // _ZN6S159C63v52Ev
  virtual void  v53(); // _ZN6S159C63v53Ev
  virtual void  v54(); // _ZN6S159C63v54Ev
  virtual void  v55(); // _ZN6S159C63v55Ev
  virtual void  v56(); // _ZN6S159C63v56Ev
  virtual void  v57(); // _ZN6S159C63v57Ev
  virtual void  v58(); // _ZN6S159C63v58Ev
  virtual void  v59(); // _ZN6S159C63v59Ev
  virtual void  v60(); // _ZN6S159C63v60Ev
  virtual void  v61(); // _ZN6S159C63v61Ev
  virtual void  v62(); // _ZN6S159C63v62Ev
  virtual void  v63(); // _ZN6S159C63v63Ev
  virtual void  v64(); // _ZN6S159C63v64Ev
  virtual void  v65(); // _ZN6S159C63v65Ev
  virtual void  v66(); // _ZN6S159C63v66Ev
  virtual void  v67(); // _ZN6S159C63v67Ev
  virtual void  v68(); // _ZN6S159C63v68Ev
  virtual void  v69(); // _ZN6S159C63v69Ev
  virtual void  v70(); // _ZN6S159C63v70Ev
  virtual void  v71(); // _ZN6S159C63v71Ev
  virtual void  v72(); // _ZN6S159C63v72Ev
  virtual void  v73(); // _ZN6S159C63v73Ev
  virtual void  v74(); // _ZN6S159C63v74Ev
  virtual void  v75(); // _ZN6S159C63v75Ev
  virtual void  v76(); // _ZN6S159C63v76Ev
  virtual void  v77(); // _ZN6S159C63v77Ev
  virtual void  v78(); // _ZN6S159C63v78Ev
  virtual void  v79(); // _ZN6S159C63v79Ev
  S159C6(); // tgen
};
//SIG(-1 S159C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S159C6 ::~S159C6(){ note_dtor("S159C6", this);}
void  S159C6 ::v16(){vfunc_called(this, "_ZN6S159C63v16Ev");}
void  S159C6 ::v17(){vfunc_called(this, "_ZN6S159C63v17Ev");}
void  S159C6 ::v18(){vfunc_called(this, "_ZN6S159C63v18Ev");}
void  S159C6 ::v19(){vfunc_called(this, "_ZN6S159C63v19Ev");}
void  S159C6 ::v20(){vfunc_called(this, "_ZN6S159C63v20Ev");}
void  S159C6 ::v21(){vfunc_called(this, "_ZN6S159C63v21Ev");}
void  S159C6 ::v22(){vfunc_called(this, "_ZN6S159C63v22Ev");}
void  S159C6 ::v23(){vfunc_called(this, "_ZN6S159C63v23Ev");}
void  S159C6 ::v24(){vfunc_called(this, "_ZN6S159C63v24Ev");}
void  S159C6 ::v25(){vfunc_called(this, "_ZN6S159C63v25Ev");}
void  S159C6 ::v26(){vfunc_called(this, "_ZN6S159C63v26Ev");}
void  S159C6 ::v27(){vfunc_called(this, "_ZN6S159C63v27Ev");}
void  S159C6 ::v28(){vfunc_called(this, "_ZN6S159C63v28Ev");}
void  S159C6 ::v29(){vfunc_called(this, "_ZN6S159C63v29Ev");}
void  S159C6 ::v30(){vfunc_called(this, "_ZN6S159C63v30Ev");}
void  S159C6 ::v31(){vfunc_called(this, "_ZN6S159C63v31Ev");}
void  S159C6 ::v32(){vfunc_called(this, "_ZN6S159C63v32Ev");}
void  S159C6 ::v33(){vfunc_called(this, "_ZN6S159C63v33Ev");}
void  S159C6 ::v34(){vfunc_called(this, "_ZN6S159C63v34Ev");}
void  S159C6 ::v35(){vfunc_called(this, "_ZN6S159C63v35Ev");}
void  S159C6 ::v36(){vfunc_called(this, "_ZN6S159C63v36Ev");}
void  S159C6 ::v37(){vfunc_called(this, "_ZN6S159C63v37Ev");}
void  S159C6 ::v38(){vfunc_called(this, "_ZN6S159C63v38Ev");}
void  S159C6 ::v39(){vfunc_called(this, "_ZN6S159C63v39Ev");}
void  S159C6 ::v40(){vfunc_called(this, "_ZN6S159C63v40Ev");}
void  S159C6 ::v41(){vfunc_called(this, "_ZN6S159C63v41Ev");}
void  S159C6 ::v42(){vfunc_called(this, "_ZN6S159C63v42Ev");}
void  S159C6 ::v43(){vfunc_called(this, "_ZN6S159C63v43Ev");}
void  S159C6 ::v44(){vfunc_called(this, "_ZN6S159C63v44Ev");}
void  S159C6 ::v45(){vfunc_called(this, "_ZN6S159C63v45Ev");}
void  S159C6 ::v46(){vfunc_called(this, "_ZN6S159C63v46Ev");}
void  S159C6 ::v47(){vfunc_called(this, "_ZN6S159C63v47Ev");}
void  S159C6 ::v48(){vfunc_called(this, "_ZN6S159C63v48Ev");}
void  S159C6 ::v49(){vfunc_called(this, "_ZN6S159C63v49Ev");}
void  S159C6 ::v50(){vfunc_called(this, "_ZN6S159C63v50Ev");}
void  S159C6 ::v51(){vfunc_called(this, "_ZN6S159C63v51Ev");}
void  S159C6 ::v52(){vfunc_called(this, "_ZN6S159C63v52Ev");}
void  S159C6 ::v53(){vfunc_called(this, "_ZN6S159C63v53Ev");}
void  S159C6 ::v54(){vfunc_called(this, "_ZN6S159C63v54Ev");}
void  S159C6 ::v55(){vfunc_called(this, "_ZN6S159C63v55Ev");}
void  S159C6 ::v56(){vfunc_called(this, "_ZN6S159C63v56Ev");}
void  S159C6 ::v57(){vfunc_called(this, "_ZN6S159C63v57Ev");}
void  S159C6 ::v58(){vfunc_called(this, "_ZN6S159C63v58Ev");}
void  S159C6 ::v59(){vfunc_called(this, "_ZN6S159C63v59Ev");}
void  S159C6 ::v60(){vfunc_called(this, "_ZN6S159C63v60Ev");}
void  S159C6 ::v61(){vfunc_called(this, "_ZN6S159C63v61Ev");}
void  S159C6 ::v62(){vfunc_called(this, "_ZN6S159C63v62Ev");}
void  S159C6 ::v63(){vfunc_called(this, "_ZN6S159C63v63Ev");}
void  S159C6 ::v64(){vfunc_called(this, "_ZN6S159C63v64Ev");}
void  S159C6 ::v65(){vfunc_called(this, "_ZN6S159C63v65Ev");}
void  S159C6 ::v66(){vfunc_called(this, "_ZN6S159C63v66Ev");}
void  S159C6 ::v67(){vfunc_called(this, "_ZN6S159C63v67Ev");}
void  S159C6 ::v68(){vfunc_called(this, "_ZN6S159C63v68Ev");}
void  S159C6 ::v69(){vfunc_called(this, "_ZN6S159C63v69Ev");}
void  S159C6 ::v70(){vfunc_called(this, "_ZN6S159C63v70Ev");}
void  S159C6 ::v71(){vfunc_called(this, "_ZN6S159C63v71Ev");}
void  S159C6 ::v72(){vfunc_called(this, "_ZN6S159C63v72Ev");}
void  S159C6 ::v73(){vfunc_called(this, "_ZN6S159C63v73Ev");}
void  S159C6 ::v74(){vfunc_called(this, "_ZN6S159C63v74Ev");}
void  S159C6 ::v75(){vfunc_called(this, "_ZN6S159C63v75Ev");}
void  S159C6 ::v76(){vfunc_called(this, "_ZN6S159C63v76Ev");}
void  S159C6 ::v77(){vfunc_called(this, "_ZN6S159C63v77Ev");}
void  S159C6 ::v78(){vfunc_called(this, "_ZN6S159C63v78Ev");}
void  S159C6 ::v79(){vfunc_called(this, "_ZN6S159C63v79Ev");}
S159C6 ::S159C6(){ note_ctor("S159C6", this);} // tgen

static void Test_S159C6()
{
  extern Class_Descriptor cd_S159C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S159C6, buf);
    S159C6 *dp, &lv = *(dp=new (buf) S159C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S159C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C6)");
    check_field_offset(lv, s159c6f0, ABISELECT(8,4), "S159C6.s159c6f0");
    check_field_offset(lv, s159c6f1, ABISELECT(16,8), "S159C6.s159c6f1");
    check_field_offset(lv, s159c6f2, ABISELECT(24,16), "S159C6.s159c6f2");
    check_field_offset(lv, s159c6f3, ABISELECT(56,32), "S159C6.s159c6f3");
    check_field_offset(lv, s159c6f4, ABISELECT(64,40), "S159C6.s159c6f4");
    check_field_offset(lv, s159c6f5, ABISELECT(72,44), "S159C6.s159c6f5");
    check_field_offset(lv, s159c6f6, ABISELECT(80,52), "S159C6.s159c6f6");
    test_class_info(&lv, &cd_S159C6);
    dp->~S159C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C6(Test_S159C6, "S159C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S159C6C1Ev();
extern void _ZN6S159C6D1Ev();
Name_Map name_map_S159C6[] = {
  NSPAIR(_ZN6S159C6C1Ev),
  NSPAIR(_ZN6S159C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S159C6[];
extern void _ZN6S159C6D1Ev();
extern void _ZN6S159C6D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
static  VTBL_ENTRY vtc_S159C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C6[0]),
  (VTBL_ENTRY)&_ZN6S159C6D1Ev,
  (VTBL_ENTRY)&_ZN6S159C6D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
};
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
Class_Descriptor cd_S159C6 = {  "S159C6", // class name
  0,0,//no base classes
  &(vtc_S159C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S159C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S159C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C5  : S159C6 {
  virtual  ~S159C5(); // _ZN6S159C5D1Ev
  virtual void  v80(); // _ZN6S159C53v80Ev
  virtual void  v81(); // _ZN6S159C53v81Ev
  S159C5(); // tgen
};
//SIG(-1 S159C5) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S159C5 ::~S159C5(){ note_dtor("S159C5", this);}
void  S159C5 ::v80(){vfunc_called(this, "_ZN6S159C53v80Ev");}
void  S159C5 ::v81(){vfunc_called(this, "_ZN6S159C53v81Ev");}
S159C5 ::S159C5(){ note_ctor("S159C5", this);} // tgen

static void Test_S159C5()
{
  extern Class_Descriptor cd_S159C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S159C5, buf);
    S159C5 *dp, &lv = *(dp=new (buf) S159C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S159C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C5)");
    check_base_class_offset(lv, (S159C6*), 0, "S159C5");
    test_class_info(&lv, &cd_S159C5);
    dp->~S159C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C5(Test_S159C5, "S159C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S159C5C1Ev();
extern void _ZN6S159C5D1Ev();
Name_Map name_map_S159C5[] = {
  NSPAIR(_ZN6S159C5C1Ev),
  NSPAIR(_ZN6S159C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S159C6;
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
static Base_Class bases_S159C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S159C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S159C5[];
extern void _ZN6S159C5D1Ev();
extern void _ZN6S159C5D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
extern void _ZN6S159C53v80Ev();
extern void _ZN6S159C53v81Ev();
static  VTBL_ENTRY vtc_S159C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C5[0]),
  (VTBL_ENTRY)&_ZN6S159C5D1Ev,
  (VTBL_ENTRY)&_ZN6S159C5D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
  (VTBL_ENTRY)&_ZN6S159C53v80Ev,
  (VTBL_ENTRY)&_ZN6S159C53v81Ev,
};
extern VTBL_ENTRY _ZTI6S159C5[];
extern  VTBL_ENTRY _ZTV6S159C5[];
Class_Descriptor cd_S159C5 = {  "S159C5", // class name
  bases_S159C5, 1,
  &(vtc_S159C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S159C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S159C5),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C4  : S159C5 {
  char s159c4f0;
  ::S3422C23 s159c4f1;
  ::S49C12_nt s159c4f2;
  virtual  ~S159C4(); // _ZN6S159C4D1Ev
  virtual void  v82(); // _ZN6S159C43v82Ev
  virtual void  v83(); // _ZN6S159C43v83Ev
  virtual void  v84(); // _ZN6S159C43v84Ev
  virtual void  v85(); // _ZN6S159C43v85Ev
  virtual void  v86(); // _ZN6S159C43v86Ev
  virtual void  v87(); // _ZN6S159C43v87Ev
  virtual void  v88(); // _ZN6S159C43v88Ev
  virtual void  v89(); // _ZN6S159C43v89Ev
  virtual void  v90(); // _ZN6S159C43v90Ev
  virtual void  v91(); // _ZN6S159C43v91Ev
  virtual void  v92(); // _ZN6S159C43v92Ev
  virtual void  v93(); // _ZN6S159C43v93Ev
  S159C4(); // tgen
};
//SIG(-1 S159C4) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S159C4 ::~S159C4(){ note_dtor("S159C4", this);}
void  S159C4 ::v82(){vfunc_called(this, "_ZN6S159C43v82Ev");}
void  S159C4 ::v83(){vfunc_called(this, "_ZN6S159C43v83Ev");}
void  S159C4 ::v84(){vfunc_called(this, "_ZN6S159C43v84Ev");}
void  S159C4 ::v85(){vfunc_called(this, "_ZN6S159C43v85Ev");}
void  S159C4 ::v86(){vfunc_called(this, "_ZN6S159C43v86Ev");}
void  S159C4 ::v87(){vfunc_called(this, "_ZN6S159C43v87Ev");}
void  S159C4 ::v88(){vfunc_called(this, "_ZN6S159C43v88Ev");}
void  S159C4 ::v89(){vfunc_called(this, "_ZN6S159C43v89Ev");}
void  S159C4 ::v90(){vfunc_called(this, "_ZN6S159C43v90Ev");}
void  S159C4 ::v91(){vfunc_called(this, "_ZN6S159C43v91Ev");}
void  S159C4 ::v92(){vfunc_called(this, "_ZN6S159C43v92Ev");}
void  S159C4 ::v93(){vfunc_called(this, "_ZN6S159C43v93Ev");}
S159C4 ::S159C4(){ note_ctor("S159C4", this);} // tgen

static void Test_S159C4()
{
  extern Class_Descriptor cd_S159C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S159C4, buf);
    S159C4 *dp, &lv = *(dp=new (buf) S159C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S159C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C4)");
    check_base_class_offset(lv, (S159C6*)(S159C5*), 0, "S159C4");
    check_base_class_offset(lv, (S159C5*), 0, "S159C4");
    check_field_offset(lv, s159c4f0, ABISELECT(96,60), "S159C4.s159c4f0");
    check_field_offset(lv, s159c4f1, ABISELECT(104,64), "S159C4.s159c4f1");
    check_field_offset(lv, s159c4f2, ABISELECT(120,76), "S159C4.s159c4f2");
    test_class_info(&lv, &cd_S159C4);
    dp->~S159C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C4(Test_S159C4, "S159C4", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN6S159C4C1Ev();
extern void _ZN6S159C4D1Ev();
Name_Map name_map_S159C4[] = {
  NSPAIR(_ZN6S159C4C1Ev),
  NSPAIR(_ZN6S159C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S159C6;
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
extern Class_Descriptor cd_S159C5;
extern VTBL_ENTRY _ZTI6S159C5[];
extern  VTBL_ENTRY _ZTV6S159C5[];
static Base_Class bases_S159C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S159C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S159C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S159C4[];
extern void _ZN6S159C4D1Ev();
extern void _ZN6S159C4D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
extern void _ZN6S159C53v80Ev();
extern void _ZN6S159C53v81Ev();
extern void _ZN6S159C43v82Ev();
extern void _ZN6S159C43v83Ev();
extern void _ZN6S159C43v84Ev();
extern void _ZN6S159C43v85Ev();
extern void _ZN6S159C43v86Ev();
extern void _ZN6S159C43v87Ev();
extern void _ZN6S159C43v88Ev();
extern void _ZN6S159C43v89Ev();
extern void _ZN6S159C43v90Ev();
extern void _ZN6S159C43v91Ev();
extern void _ZN6S159C43v92Ev();
extern void _ZN6S159C43v93Ev();
static  VTBL_ENTRY vtc_S159C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C4[0]),
  (VTBL_ENTRY)&_ZN6S159C4D1Ev,
  (VTBL_ENTRY)&_ZN6S159C4D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
  (VTBL_ENTRY)&_ZN6S159C53v80Ev,
  (VTBL_ENTRY)&_ZN6S159C53v81Ev,
  (VTBL_ENTRY)&_ZN6S159C43v82Ev,
  (VTBL_ENTRY)&_ZN6S159C43v83Ev,
  (VTBL_ENTRY)&_ZN6S159C43v84Ev,
  (VTBL_ENTRY)&_ZN6S159C43v85Ev,
  (VTBL_ENTRY)&_ZN6S159C43v86Ev,
  (VTBL_ENTRY)&_ZN6S159C43v87Ev,
  (VTBL_ENTRY)&_ZN6S159C43v88Ev,
  (VTBL_ENTRY)&_ZN6S159C43v89Ev,
  (VTBL_ENTRY)&_ZN6S159C43v90Ev,
  (VTBL_ENTRY)&_ZN6S159C43v91Ev,
  (VTBL_ENTRY)&_ZN6S159C43v92Ev,
  (VTBL_ENTRY)&_ZN6S159C43v93Ev,
};
extern VTBL_ENTRY _ZTI6S159C4[];
extern  VTBL_ENTRY _ZTV6S159C4[];
Class_Descriptor cd_S159C4 = {  "S159C4", // class name
  bases_S159C4, 2,
  &(vtc_S159C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI6S159C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S159C4),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C3  : S159C4 {
  ::S3422C4_nt s159c3f0;
  ::S3422C23 s159c3f1;
  ::S49C12_nt s159c3f2;
  virtual  ~S159C3(); // _ZN6S159C3D1Ev
  virtual void  v94(); // _ZN6S159C33v94Ev
  virtual void  v95(); // _ZN6S159C33v95Ev
  virtual void  v96(); // _ZN6S159C33v96Ev
  virtual void  v97(); // _ZN6S159C33v97Ev
  virtual void  v98(); // _ZN6S159C33v98Ev
  virtual void  v99(); // _ZN6S159C33v99Ev
  virtual void  v100(); // _ZN6S159C34v100Ev
  virtual void  v101(); // _ZN6S159C34v101Ev
  virtual void  v102(); // _ZN6S159C34v102Ev
  S159C3(); // tgen
};
//SIG(-1 S159C3) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC5 FC6 FC9}


 S159C3 ::~S159C3(){ note_dtor("S159C3", this);}
void  S159C3 ::v94(){vfunc_called(this, "_ZN6S159C33v94Ev");}
void  S159C3 ::v95(){vfunc_called(this, "_ZN6S159C33v95Ev");}
void  S159C3 ::v96(){vfunc_called(this, "_ZN6S159C33v96Ev");}
void  S159C3 ::v97(){vfunc_called(this, "_ZN6S159C33v97Ev");}
void  S159C3 ::v98(){vfunc_called(this, "_ZN6S159C33v98Ev");}
void  S159C3 ::v99(){vfunc_called(this, "_ZN6S159C33v99Ev");}
void  S159C3 ::v100(){vfunc_called(this, "_ZN6S159C34v100Ev");}
void  S159C3 ::v101(){vfunc_called(this, "_ZN6S159C34v101Ev");}
void  S159C3 ::v102(){vfunc_called(this, "_ZN6S159C34v102Ev");}
S159C3 ::S159C3(){ note_ctor("S159C3", this);} // tgen

static void Test_S159C3()
{
  extern Class_Descriptor cd_S159C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S159C3, buf);
    S159C3 *dp, &lv = *(dp=new (buf) S159C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S159C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C3)");
    check_base_class_offset(lv, (S159C6*)(S159C5*)(S159C4*), 0, "S159C3");
    check_base_class_offset(lv, (S159C5*)(S159C4*), 0, "S159C3");
    check_base_class_offset(lv, (S159C4*), 0, "S159C3");
    check_field_offset(lv, s159c3f0, ABISELECT(136,88), "S159C3.s159c3f0");
    check_field_offset(lv, s159c3f1, ABISELECT(144,96), "S159C3.s159c3f1");
    check_field_offset(lv, s159c3f2, ABISELECT(160,108), "S159C3.s159c3f2");
    test_class_info(&lv, &cd_S159C3);
    dp->~S159C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C3(Test_S159C3, "S159C3", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S159C3C1Ev();
extern void _ZN6S159C3D1Ev();
Name_Map name_map_S159C3[] = {
  NSPAIR(_ZN6S159C3C1Ev),
  NSPAIR(_ZN6S159C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S159C6;
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
extern Class_Descriptor cd_S159C5;
extern VTBL_ENTRY _ZTI6S159C5[];
extern  VTBL_ENTRY _ZTV6S159C5[];
extern Class_Descriptor cd_S159C4;
extern VTBL_ENTRY _ZTI6S159C4[];
extern  VTBL_ENTRY _ZTV6S159C4[];
static Base_Class bases_S159C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S159C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S159C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S159C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S159C3[];
extern void _ZN6S159C3D1Ev();
extern void _ZN6S159C3D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
extern void _ZN6S159C53v80Ev();
extern void _ZN6S159C53v81Ev();
extern void _ZN6S159C43v82Ev();
extern void _ZN6S159C43v83Ev();
extern void _ZN6S159C43v84Ev();
extern void _ZN6S159C43v85Ev();
extern void _ZN6S159C43v86Ev();
extern void _ZN6S159C43v87Ev();
extern void _ZN6S159C43v88Ev();
extern void _ZN6S159C43v89Ev();
extern void _ZN6S159C43v90Ev();
extern void _ZN6S159C43v91Ev();
extern void _ZN6S159C43v92Ev();
extern void _ZN6S159C43v93Ev();
extern void _ZN6S159C33v94Ev();
extern void _ZN6S159C33v95Ev();
extern void _ZN6S159C33v96Ev();
extern void _ZN6S159C33v97Ev();
extern void _ZN6S159C33v98Ev();
extern void _ZN6S159C33v99Ev();
extern void _ZN6S159C34v100Ev();
extern void _ZN6S159C34v101Ev();
extern void _ZN6S159C34v102Ev();
static  VTBL_ENTRY vtc_S159C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C3[0]),
  (VTBL_ENTRY)&_ZN6S159C3D1Ev,
  (VTBL_ENTRY)&_ZN6S159C3D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
  (VTBL_ENTRY)&_ZN6S159C53v80Ev,
  (VTBL_ENTRY)&_ZN6S159C53v81Ev,
  (VTBL_ENTRY)&_ZN6S159C43v82Ev,
  (VTBL_ENTRY)&_ZN6S159C43v83Ev,
  (VTBL_ENTRY)&_ZN6S159C43v84Ev,
  (VTBL_ENTRY)&_ZN6S159C43v85Ev,
  (VTBL_ENTRY)&_ZN6S159C43v86Ev,
  (VTBL_ENTRY)&_ZN6S159C43v87Ev,
  (VTBL_ENTRY)&_ZN6S159C43v88Ev,
  (VTBL_ENTRY)&_ZN6S159C43v89Ev,
  (VTBL_ENTRY)&_ZN6S159C43v90Ev,
  (VTBL_ENTRY)&_ZN6S159C43v91Ev,
  (VTBL_ENTRY)&_ZN6S159C43v92Ev,
  (VTBL_ENTRY)&_ZN6S159C43v93Ev,
  (VTBL_ENTRY)&_ZN6S159C33v94Ev,
  (VTBL_ENTRY)&_ZN6S159C33v95Ev,
  (VTBL_ENTRY)&_ZN6S159C33v96Ev,
  (VTBL_ENTRY)&_ZN6S159C33v97Ev,
  (VTBL_ENTRY)&_ZN6S159C33v98Ev,
  (VTBL_ENTRY)&_ZN6S159C33v99Ev,
  (VTBL_ENTRY)&_ZN6S159C34v100Ev,
  (VTBL_ENTRY)&_ZN6S159C34v101Ev,
  (VTBL_ENTRY)&_ZN6S159C34v102Ev,
};
extern VTBL_ENTRY _ZTI6S159C3[];
extern  VTBL_ENTRY _ZTV6S159C3[];
Class_Descriptor cd_S159C3 = {  "S159C3", // class name
  bases_S159C3, 3,
  &(vtc_S159C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S159C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S159C3),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C2  : S159C3 {
  virtual  ~S159C2(); // _ZN6S159C2D1Ev
  virtual void  v103(); // _ZN6S159C24v103Ev
  virtual void  v104(); // _ZN6S159C24v104Ev
  S159C2(); // tgen
};
//SIG(-1 S159C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v81 v82 v83 v84 v85 v86 v87 v88 v89 FC6 FC7 FC10} vd v1 v2}


 S159C2 ::~S159C2(){ note_dtor("S159C2", this);}
void  S159C2 ::v103(){vfunc_called(this, "_ZN6S159C24v103Ev");}
void  S159C2 ::v104(){vfunc_called(this, "_ZN6S159C24v104Ev");}
S159C2 ::S159C2(){ note_ctor("S159C2", this);} // tgen

static void Test_S159C2()
{
  extern Class_Descriptor cd_S159C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(23,31)];
    init_test(&cd_S159C2, buf);
    S159C2 *dp, &lv = *(dp=new (buf) S159C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,120), "sizeof(S159C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C2)");
    check_base_class_offset(lv, (S159C6*)(S159C5*)(S159C4*)(S159C3*), 0, "S159C2");
    check_base_class_offset(lv, (S159C5*)(S159C4*)(S159C3*), 0, "S159C2");
    check_base_class_offset(lv, (S159C4*)(S159C3*), 0, "S159C2");
    check_base_class_offset(lv, (S159C3*), 0, "S159C2");
    test_class_info(&lv, &cd_S159C2);
    dp->~S159C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C2(Test_S159C2, "S159C2", ABISELECT(176,120));

#else // __cplusplus

extern void _ZN6S159C2C1Ev();
extern void _ZN6S159C2D1Ev();
Name_Map name_map_S159C2[] = {
  NSPAIR(_ZN6S159C2C1Ev),
  NSPAIR(_ZN6S159C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S159C6;
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
extern Class_Descriptor cd_S159C5;
extern VTBL_ENTRY _ZTI6S159C5[];
extern  VTBL_ENTRY _ZTV6S159C5[];
extern Class_Descriptor cd_S159C4;
extern VTBL_ENTRY _ZTI6S159C4[];
extern  VTBL_ENTRY _ZTV6S159C4[];
extern Class_Descriptor cd_S159C3;
extern VTBL_ENTRY _ZTI6S159C3[];
extern  VTBL_ENTRY _ZTV6S159C3[];
static Base_Class bases_S159C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S159C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S159C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S159C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S159C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S159C2[];
extern void _ZN6S159C2D1Ev();
extern void _ZN6S159C2D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
extern void _ZN6S159C53v80Ev();
extern void _ZN6S159C53v81Ev();
extern void _ZN6S159C43v82Ev();
extern void _ZN6S159C43v83Ev();
extern void _ZN6S159C43v84Ev();
extern void _ZN6S159C43v85Ev();
extern void _ZN6S159C43v86Ev();
extern void _ZN6S159C43v87Ev();
extern void _ZN6S159C43v88Ev();
extern void _ZN6S159C43v89Ev();
extern void _ZN6S159C43v90Ev();
extern void _ZN6S159C43v91Ev();
extern void _ZN6S159C43v92Ev();
extern void _ZN6S159C43v93Ev();
extern void _ZN6S159C33v94Ev();
extern void _ZN6S159C33v95Ev();
extern void _ZN6S159C33v96Ev();
extern void _ZN6S159C33v97Ev();
extern void _ZN6S159C33v98Ev();
extern void _ZN6S159C33v99Ev();
extern void _ZN6S159C34v100Ev();
extern void _ZN6S159C34v101Ev();
extern void _ZN6S159C34v102Ev();
extern void _ZN6S159C24v103Ev();
extern void _ZN6S159C24v104Ev();
static  VTBL_ENTRY vtc_S159C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C2[0]),
  (VTBL_ENTRY)&_ZN6S159C2D1Ev,
  (VTBL_ENTRY)&_ZN6S159C2D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
  (VTBL_ENTRY)&_ZN6S159C53v80Ev,
  (VTBL_ENTRY)&_ZN6S159C53v81Ev,
  (VTBL_ENTRY)&_ZN6S159C43v82Ev,
  (VTBL_ENTRY)&_ZN6S159C43v83Ev,
  (VTBL_ENTRY)&_ZN6S159C43v84Ev,
  (VTBL_ENTRY)&_ZN6S159C43v85Ev,
  (VTBL_ENTRY)&_ZN6S159C43v86Ev,
  (VTBL_ENTRY)&_ZN6S159C43v87Ev,
  (VTBL_ENTRY)&_ZN6S159C43v88Ev,
  (VTBL_ENTRY)&_ZN6S159C43v89Ev,
  (VTBL_ENTRY)&_ZN6S159C43v90Ev,
  (VTBL_ENTRY)&_ZN6S159C43v91Ev,
  (VTBL_ENTRY)&_ZN6S159C43v92Ev,
  (VTBL_ENTRY)&_ZN6S159C43v93Ev,
  (VTBL_ENTRY)&_ZN6S159C33v94Ev,
  (VTBL_ENTRY)&_ZN6S159C33v95Ev,
  (VTBL_ENTRY)&_ZN6S159C33v96Ev,
  (VTBL_ENTRY)&_ZN6S159C33v97Ev,
  (VTBL_ENTRY)&_ZN6S159C33v98Ev,
  (VTBL_ENTRY)&_ZN6S159C33v99Ev,
  (VTBL_ENTRY)&_ZN6S159C34v100Ev,
  (VTBL_ENTRY)&_ZN6S159C34v101Ev,
  (VTBL_ENTRY)&_ZN6S159C34v102Ev,
  (VTBL_ENTRY)&_ZN6S159C24v103Ev,
  (VTBL_ENTRY)&_ZN6S159C24v104Ev,
};
extern VTBL_ENTRY _ZTI6S159C2[];
extern  VTBL_ENTRY _ZTV6S159C2[];
Class_Descriptor cd_S159C2 = {  "S159C2", // class name
  bases_S159C2, 4,
  &(vtc_S159C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(176,120), // object size
  NSPAIRA(_ZTI6S159C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S159C2),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C12  {
  virtual  ~S159C12(); // _ZN7S159C12D1Ev
  virtual void  v105(); // _ZN7S159C124v105Ev
  virtual void  v106(); // _ZN7S159C124v106Ev
  virtual void  v107(); // _ZN7S159C124v107Ev
  virtual void  v108(); // _ZN7S159C124v108Ev
  virtual void  v109(); // _ZN7S159C124v109Ev
  virtual void  v110(); // _ZN7S159C124v110Ev
  virtual void  v111(); // _ZN7S159C124v111Ev
  virtual void  v112(); // _ZN7S159C124v112Ev
  S159C12(); // tgen
};
//SIG(-1 S159C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S159C12 ::~S159C12(){ note_dtor("S159C12", this);}
void  S159C12 ::v105(){vfunc_called(this, "_ZN7S159C124v105Ev");}
void  S159C12 ::v106(){vfunc_called(this, "_ZN7S159C124v106Ev");}
void  S159C12 ::v107(){vfunc_called(this, "_ZN7S159C124v107Ev");}
void  S159C12 ::v108(){vfunc_called(this, "_ZN7S159C124v108Ev");}
void  S159C12 ::v109(){vfunc_called(this, "_ZN7S159C124v109Ev");}
void  S159C12 ::v110(){vfunc_called(this, "_ZN7S159C124v110Ev");}
void  S159C12 ::v111(){vfunc_called(this, "_ZN7S159C124v111Ev");}
void  S159C12 ::v112(){vfunc_called(this, "_ZN7S159C124v112Ev");}
S159C12 ::S159C12(){ note_ctor("S159C12", this);} // tgen

static void Test_S159C12()
{
  extern Class_Descriptor cd_S159C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S159C12, buf);
    S159C12 *dp, &lv = *(dp=new (buf) S159C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S159C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C12)");
    test_class_info(&lv, &cd_S159C12);
    dp->~S159C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C12(Test_S159C12, "S159C12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S159C12C1Ev();
extern void _ZN7S159C12D1Ev();
Name_Map name_map_S159C12[] = {
  NSPAIR(_ZN7S159C12C1Ev),
  NSPAIR(_ZN7S159C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S159C12[];
extern void _ZN7S159C12D1Ev();
extern void _ZN7S159C12D0Ev();
extern void _ZN7S159C124v105Ev();
extern void _ZN7S159C124v106Ev();
extern void _ZN7S159C124v107Ev();
extern void _ZN7S159C124v108Ev();
extern void _ZN7S159C124v109Ev();
extern void _ZN7S159C124v110Ev();
extern void _ZN7S159C124v111Ev();
extern void _ZN7S159C124v112Ev();
static  VTBL_ENTRY vtc_S159C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S159C12[0]),
  (VTBL_ENTRY)&_ZN7S159C12D1Ev,
  (VTBL_ENTRY)&_ZN7S159C12D0Ev,
  (VTBL_ENTRY)&_ZN7S159C124v105Ev,
  (VTBL_ENTRY)&_ZN7S159C124v106Ev,
  (VTBL_ENTRY)&_ZN7S159C124v107Ev,
  (VTBL_ENTRY)&_ZN7S159C124v108Ev,
  (VTBL_ENTRY)&_ZN7S159C124v109Ev,
  (VTBL_ENTRY)&_ZN7S159C124v110Ev,
  (VTBL_ENTRY)&_ZN7S159C124v111Ev,
  (VTBL_ENTRY)&_ZN7S159C124v112Ev,
};
extern VTBL_ENTRY _ZTI7S159C12[];
extern  VTBL_ENTRY _ZTV7S159C12[];
Class_Descriptor cd_S159C12 = {  "S159C12", // class name
  0,0,//no base classes
  &(vtc_S159C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S159C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S159C12),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S159C1  : S159C2 , S159C12 {
  void *s159c1f0[4];
  ::S3422C22_nt s159c1f1;
  int s159c1f2[2];
  ::S3422C22_nt s159c1f3;
  void *s159c1f4[3];
  ::S3422C22_nt s159c1f5;
  void *s159c1f6;
  ::S3422C22_nt s159c1f7;
  void *s159c1f8;
  ::S3422C22_nt s159c1f9;
  void *s159c1f10;
  ::S3422C22_nt s159c1f11;
  void *s159c1f12;
  virtual  ~S159C1(); // _ZN6S159C1D1Ev
  virtual void  v1(); // _ZN6S159C12v1Ev
  virtual void  v2(); // _ZN6S159C12v2Ev
  virtual void  v3(); // _ZN6S159C12v3Ev
  virtual void  v4(); // _ZN6S159C12v4Ev
  virtual void  v5(); // _ZN6S159C12v5Ev
  virtual void  v6(); // _ZN6S159C12v6Ev
  virtual void  v7(); // _ZN6S159C12v7Ev
  virtual void  v8(); // _ZN6S159C12v8Ev
  virtual void  v9(); // _ZN6S159C12v9Ev
  virtual void  v10(); // _ZN6S159C13v10Ev
  virtual void  v11(); // _ZN6S159C13v11Ev
  virtual void  v12(); // _ZN6S159C13v12Ev
  virtual void  v13(); // _ZN6S159C13v13Ev
  virtual void  v14(); // _ZN6S159C13v14Ev
  virtual void  v15(); // _ZN6S159C13v15Ev
  S159C1(); // tgen
};
//SIG(1 S159C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v80 v81} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 FC7 FC8 FC11} vd v103 v104} BC12{ vd v105 v106 v107 v108 v109 v110 v111 v112} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp[4] FC13{ BC8} Fi[2] FC13 Fp[3] FC13 Fp FC13 Fp FC13 Fp FC13 Fp}


 S159C1 ::~S159C1(){ note_dtor("S159C1", this);}
void  S159C1 ::v1(){vfunc_called(this, "_ZN6S159C12v1Ev");}
void  S159C1 ::v2(){vfunc_called(this, "_ZN6S159C12v2Ev");}
void  S159C1 ::v3(){vfunc_called(this, "_ZN6S159C12v3Ev");}
void  S159C1 ::v4(){vfunc_called(this, "_ZN6S159C12v4Ev");}
void  S159C1 ::v5(){vfunc_called(this, "_ZN6S159C12v5Ev");}
void  S159C1 ::v6(){vfunc_called(this, "_ZN6S159C12v6Ev");}
void  S159C1 ::v7(){vfunc_called(this, "_ZN6S159C12v7Ev");}
void  S159C1 ::v8(){vfunc_called(this, "_ZN6S159C12v8Ev");}
void  S159C1 ::v9(){vfunc_called(this, "_ZN6S159C12v9Ev");}
void  S159C1 ::v10(){vfunc_called(this, "_ZN6S159C13v10Ev");}
void  S159C1 ::v11(){vfunc_called(this, "_ZN6S159C13v11Ev");}
void  S159C1 ::v12(){vfunc_called(this, "_ZN6S159C13v12Ev");}
void  S159C1 ::v13(){vfunc_called(this, "_ZN6S159C13v13Ev");}
void  S159C1 ::v14(){vfunc_called(this, "_ZN6S159C13v14Ev");}
void  S159C1 ::v15(){vfunc_called(this, "_ZN6S159C13v15Ev");}
S159C1 ::S159C1(){ note_ctor("S159C1", this);} // tgen

static void Test_S159C1()
{
  extern Class_Descriptor cd_S159C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,63)];
    init_test(&cd_S159C1, buf);
    S159C1 *dp, &lv = *(dp=new (buf) S159C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,248), "sizeof(S159C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S159C1)");
    check_base_class_offset(lv, (S159C6*)(S159C5*)(S159C4*)(S159C3*)(S159C2*), 0, "S159C1");
    check_base_class_offset(lv, (S159C5*)(S159C4*)(S159C3*)(S159C2*), 0, "S159C1");
    check_base_class_offset(lv, (S159C4*)(S159C3*)(S159C2*), 0, "S159C1");
    check_base_class_offset(lv, (S159C3*)(S159C2*), 0, "S159C1");
    check_base_class_offset(lv, (S159C2*), 0, "S159C1");
    check_base_class_offset(lv, (S159C12*), ABISELECT(176,120), "S159C1");
    check_field_offset(lv, s159c1f0, ABISELECT(184,124), "S159C1.s159c1f0");
    check_field_offset(lv, s159c1f1, ABISELECT(216,140), "S159C1.s159c1f1");
    check_field_offset(lv, s159c1f2, ABISELECT(232,152), "S159C1.s159c1f2");
    check_field_offset(lv, s159c1f3, ABISELECT(240,160), "S159C1.s159c1f3");
    check_field_offset(lv, s159c1f4, ABISELECT(256,172), "S159C1.s159c1f4");
    check_field_offset(lv, s159c1f5, ABISELECT(280,184), "S159C1.s159c1f5");
    check_field_offset(lv, s159c1f6, ABISELECT(296,196), "S159C1.s159c1f6");
    check_field_offset(lv, s159c1f7, ABISELECT(304,200), "S159C1.s159c1f7");
    check_field_offset(lv, s159c1f8, ABISELECT(320,212), "S159C1.s159c1f8");
    check_field_offset(lv, s159c1f9, ABISELECT(328,216), "S159C1.s159c1f9");
    check_field_offset(lv, s159c1f10, ABISELECT(344,228), "S159C1.s159c1f10");
    check_field_offset(lv, s159c1f11, ABISELECT(352,232), "S159C1.s159c1f11");
    check_field_offset(lv, s159c1f12, ABISELECT(368,244), "S159C1.s159c1f12");
    test_class_info(&lv, &cd_S159C1);
    dp->~S159C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS159C1(Test_S159C1, "S159C1", ABISELECT(376,248));

#else // __cplusplus

extern void _ZN6S159C1C1Ev();
extern void _ZN6S159C1D1Ev();
Name_Map name_map_S159C1[] = {
  NSPAIR(_ZN6S159C1C1Ev),
  NSPAIR(_ZN6S159C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S159C6;
extern VTBL_ENTRY _ZTI6S159C6[];
extern  VTBL_ENTRY _ZTV6S159C6[];
extern Class_Descriptor cd_S159C5;
extern VTBL_ENTRY _ZTI6S159C5[];
extern  VTBL_ENTRY _ZTV6S159C5[];
extern Class_Descriptor cd_S159C4;
extern VTBL_ENTRY _ZTI6S159C4[];
extern  VTBL_ENTRY _ZTV6S159C4[];
extern Class_Descriptor cd_S159C3;
extern VTBL_ENTRY _ZTI6S159C3[];
extern  VTBL_ENTRY _ZTV6S159C3[];
extern Class_Descriptor cd_S159C2;
extern VTBL_ENTRY _ZTI6S159C2[];
extern  VTBL_ENTRY _ZTV6S159C2[];
extern Class_Descriptor cd_S159C12;
extern VTBL_ENTRY _ZTI7S159C12[];
extern  VTBL_ENTRY _ZTV7S159C12[];
static Base_Class bases_S159C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S159C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S159C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S159C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S159C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S159C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S159C12,    ABISELECT(176,120), //bcp->offset
    108, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S159C1[];
extern void _ZN6S159C1D1Ev();
extern void _ZN6S159C1D0Ev();
extern void _ZN6S159C63v16Ev();
extern void _ZN6S159C63v17Ev();
extern void _ZN6S159C63v18Ev();
extern void _ZN6S159C63v19Ev();
extern void _ZN6S159C63v20Ev();
extern void _ZN6S159C63v21Ev();
extern void _ZN6S159C63v22Ev();
extern void _ZN6S159C63v23Ev();
extern void _ZN6S159C63v24Ev();
extern void _ZN6S159C63v25Ev();
extern void _ZN6S159C63v26Ev();
extern void _ZN6S159C63v27Ev();
extern void _ZN6S159C63v28Ev();
extern void _ZN6S159C63v29Ev();
extern void _ZN6S159C63v30Ev();
extern void _ZN6S159C63v31Ev();
extern void _ZN6S159C63v32Ev();
extern void _ZN6S159C63v33Ev();
extern void _ZN6S159C63v34Ev();
extern void _ZN6S159C63v35Ev();
extern void _ZN6S159C63v36Ev();
extern void _ZN6S159C63v37Ev();
extern void _ZN6S159C63v38Ev();
extern void _ZN6S159C63v39Ev();
extern void _ZN6S159C63v40Ev();
extern void _ZN6S159C63v41Ev();
extern void _ZN6S159C63v42Ev();
extern void _ZN6S159C63v43Ev();
extern void _ZN6S159C63v44Ev();
extern void _ZN6S159C63v45Ev();
extern void _ZN6S159C63v46Ev();
extern void _ZN6S159C63v47Ev();
extern void _ZN6S159C63v48Ev();
extern void _ZN6S159C63v49Ev();
extern void _ZN6S159C63v50Ev();
extern void _ZN6S159C63v51Ev();
extern void _ZN6S159C63v52Ev();
extern void _ZN6S159C63v53Ev();
extern void _ZN6S159C63v54Ev();
extern void _ZN6S159C63v55Ev();
extern void _ZN6S159C63v56Ev();
extern void _ZN6S159C63v57Ev();
extern void _ZN6S159C63v58Ev();
extern void _ZN6S159C63v59Ev();
extern void _ZN6S159C63v60Ev();
extern void _ZN6S159C63v61Ev();
extern void _ZN6S159C63v62Ev();
extern void _ZN6S159C63v63Ev();
extern void _ZN6S159C63v64Ev();
extern void _ZN6S159C63v65Ev();
extern void _ZN6S159C63v66Ev();
extern void _ZN6S159C63v67Ev();
extern void _ZN6S159C63v68Ev();
extern void _ZN6S159C63v69Ev();
extern void _ZN6S159C63v70Ev();
extern void _ZN6S159C63v71Ev();
extern void _ZN6S159C63v72Ev();
extern void _ZN6S159C63v73Ev();
extern void _ZN6S159C63v74Ev();
extern void _ZN6S159C63v75Ev();
extern void _ZN6S159C63v76Ev();
extern void _ZN6S159C63v77Ev();
extern void _ZN6S159C63v78Ev();
extern void _ZN6S159C63v79Ev();
extern void _ZN6S159C53v80Ev();
extern void _ZN6S159C53v81Ev();
extern void _ZN6S159C43v82Ev();
extern void _ZN6S159C43v83Ev();
extern void _ZN6S159C43v84Ev();
extern void _ZN6S159C43v85Ev();
extern void _ZN6S159C43v86Ev();
extern void _ZN6S159C43v87Ev();
extern void _ZN6S159C43v88Ev();
extern void _ZN6S159C43v89Ev();
extern void _ZN6S159C43v90Ev();
extern void _ZN6S159C43v91Ev();
extern void _ZN6S159C43v92Ev();
extern void _ZN6S159C43v93Ev();
extern void _ZN6S159C33v94Ev();
extern void _ZN6S159C33v95Ev();
extern void _ZN6S159C33v96Ev();
extern void _ZN6S159C33v97Ev();
extern void _ZN6S159C33v98Ev();
extern void _ZN6S159C33v99Ev();
extern void _ZN6S159C34v100Ev();
extern void _ZN6S159C34v101Ev();
extern void _ZN6S159C34v102Ev();
extern void _ZN6S159C24v103Ev();
extern void _ZN6S159C24v104Ev();
extern void _ZN6S159C12v1Ev();
extern void _ZN6S159C12v2Ev();
extern void _ZN6S159C12v3Ev();
extern void _ZN6S159C12v4Ev();
extern void _ZN6S159C12v5Ev();
extern void _ZN6S159C12v6Ev();
extern void _ZN6S159C12v7Ev();
extern void _ZN6S159C12v8Ev();
extern void _ZN6S159C12v9Ev();
extern void _ZN6S159C13v10Ev();
extern void _ZN6S159C13v11Ev();
extern void _ZN6S159C13v12Ev();
extern void _ZN6S159C13v13Ev();
extern void _ZN6S159C13v14Ev();
extern void _ZN6S159C13v15Ev();
extern void ABISELECT(_ZThn176_N6S159C1D1Ev,_ZThn120_N6S159C1D1Ev)();
extern void ABISELECT(_ZThn176_N6S159C1D0Ev,_ZThn120_N6S159C1D0Ev)();
extern void _ZN7S159C124v105Ev();
extern void _ZN7S159C124v106Ev();
extern void _ZN7S159C124v107Ev();
extern void _ZN7S159C124v108Ev();
extern void _ZN7S159C124v109Ev();
extern void _ZN7S159C124v110Ev();
extern void _ZN7S159C124v111Ev();
extern void _ZN7S159C124v112Ev();
static  VTBL_ENTRY vtc_S159C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S159C1[0]),
  (VTBL_ENTRY)&_ZN6S159C1D1Ev,
  (VTBL_ENTRY)&_ZN6S159C1D0Ev,
  (VTBL_ENTRY)&_ZN6S159C63v16Ev,
  (VTBL_ENTRY)&_ZN6S159C63v17Ev,
  (VTBL_ENTRY)&_ZN6S159C63v18Ev,
  (VTBL_ENTRY)&_ZN6S159C63v19Ev,
  (VTBL_ENTRY)&_ZN6S159C63v20Ev,
  (VTBL_ENTRY)&_ZN6S159C63v21Ev,
  (VTBL_ENTRY)&_ZN6S159C63v22Ev,
  (VTBL_ENTRY)&_ZN6S159C63v23Ev,
  (VTBL_ENTRY)&_ZN6S159C63v24Ev,
  (VTBL_ENTRY)&_ZN6S159C63v25Ev,
  (VTBL_ENTRY)&_ZN6S159C63v26Ev,
  (VTBL_ENTRY)&_ZN6S159C63v27Ev,
  (VTBL_ENTRY)&_ZN6S159C63v28Ev,
  (VTBL_ENTRY)&_ZN6S159C63v29Ev,
  (VTBL_ENTRY)&_ZN6S159C63v30Ev,
  (VTBL_ENTRY)&_ZN6S159C63v31Ev,
  (VTBL_ENTRY)&_ZN6S159C63v32Ev,
  (VTBL_ENTRY)&_ZN6S159C63v33Ev,
  (VTBL_ENTRY)&_ZN6S159C63v34Ev,
  (VTBL_ENTRY)&_ZN6S159C63v35Ev,
  (VTBL_ENTRY)&_ZN6S159C63v36Ev,
  (VTBL_ENTRY)&_ZN6S159C63v37Ev,
  (VTBL_ENTRY)&_ZN6S159C63v38Ev,
  (VTBL_ENTRY)&_ZN6S159C63v39Ev,
  (VTBL_ENTRY)&_ZN6S159C63v40Ev,
  (VTBL_ENTRY)&_ZN6S159C63v41Ev,
  (VTBL_ENTRY)&_ZN6S159C63v42Ev,
  (VTBL_ENTRY)&_ZN6S159C63v43Ev,
  (VTBL_ENTRY)&_ZN6S159C63v44Ev,
  (VTBL_ENTRY)&_ZN6S159C63v45Ev,
  (VTBL_ENTRY)&_ZN6S159C63v46Ev,
  (VTBL_ENTRY)&_ZN6S159C63v47Ev,
  (VTBL_ENTRY)&_ZN6S159C63v48Ev,
  (VTBL_ENTRY)&_ZN6S159C63v49Ev,
  (VTBL_ENTRY)&_ZN6S159C63v50Ev,
  (VTBL_ENTRY)&_ZN6S159C63v51Ev,
  (VTBL_ENTRY)&_ZN6S159C63v52Ev,
  (VTBL_ENTRY)&_ZN6S159C63v53Ev,
  (VTBL_ENTRY)&_ZN6S159C63v54Ev,
  (VTBL_ENTRY)&_ZN6S159C63v55Ev,
  (VTBL_ENTRY)&_ZN6S159C63v56Ev,
  (VTBL_ENTRY)&_ZN6S159C63v57Ev,
  (VTBL_ENTRY)&_ZN6S159C63v58Ev,
  (VTBL_ENTRY)&_ZN6S159C63v59Ev,
  (VTBL_ENTRY)&_ZN6S159C63v60Ev,
  (VTBL_ENTRY)&_ZN6S159C63v61Ev,
  (VTBL_ENTRY)&_ZN6S159C63v62Ev,
  (VTBL_ENTRY)&_ZN6S159C63v63Ev,
  (VTBL_ENTRY)&_ZN6S159C63v64Ev,
  (VTBL_ENTRY)&_ZN6S159C63v65Ev,
  (VTBL_ENTRY)&_ZN6S159C63v66Ev,
  (VTBL_ENTRY)&_ZN6S159C63v67Ev,
  (VTBL_ENTRY)&_ZN6S159C63v68Ev,
  (VTBL_ENTRY)&_ZN6S159C63v69Ev,
  (VTBL_ENTRY)&_ZN6S159C63v70Ev,
  (VTBL_ENTRY)&_ZN6S159C63v71Ev,
  (VTBL_ENTRY)&_ZN6S159C63v72Ev,
  (VTBL_ENTRY)&_ZN6S159C63v73Ev,
  (VTBL_ENTRY)&_ZN6S159C63v74Ev,
  (VTBL_ENTRY)&_ZN6S159C63v75Ev,
  (VTBL_ENTRY)&_ZN6S159C63v76Ev,
  (VTBL_ENTRY)&_ZN6S159C63v77Ev,
  (VTBL_ENTRY)&_ZN6S159C63v78Ev,
  (VTBL_ENTRY)&_ZN6S159C63v79Ev,
  (VTBL_ENTRY)&_ZN6S159C53v80Ev,
  (VTBL_ENTRY)&_ZN6S159C53v81Ev,
  (VTBL_ENTRY)&_ZN6S159C43v82Ev,
  (VTBL_ENTRY)&_ZN6S159C43v83Ev,
  (VTBL_ENTRY)&_ZN6S159C43v84Ev,
  (VTBL_ENTRY)&_ZN6S159C43v85Ev,
  (VTBL_ENTRY)&_ZN6S159C43v86Ev,
  (VTBL_ENTRY)&_ZN6S159C43v87Ev,
  (VTBL_ENTRY)&_ZN6S159C43v88Ev,
  (VTBL_ENTRY)&_ZN6S159C43v89Ev,
  (VTBL_ENTRY)&_ZN6S159C43v90Ev,
  (VTBL_ENTRY)&_ZN6S159C43v91Ev,
  (VTBL_ENTRY)&_ZN6S159C43v92Ev,
  (VTBL_ENTRY)&_ZN6S159C43v93Ev,
  (VTBL_ENTRY)&_ZN6S159C33v94Ev,
  (VTBL_ENTRY)&_ZN6S159C33v95Ev,
  (VTBL_ENTRY)&_ZN6S159C33v96Ev,
  (VTBL_ENTRY)&_ZN6S159C33v97Ev,
  (VTBL_ENTRY)&_ZN6S159C33v98Ev,
  (VTBL_ENTRY)&_ZN6S159C33v99Ev,
  (VTBL_ENTRY)&_ZN6S159C34v100Ev,
  (VTBL_ENTRY)&_ZN6S159C34v101Ev,
  (VTBL_ENTRY)&_ZN6S159C34v102Ev,
  (VTBL_ENTRY)&_ZN6S159C24v103Ev,
  (VTBL_ENTRY)&_ZN6S159C24v104Ev,
  (VTBL_ENTRY)&_ZN6S159C12v1Ev,
  (VTBL_ENTRY)&_ZN6S159C12v2Ev,
  (VTBL_ENTRY)&_ZN6S159C12v3Ev,
  (VTBL_ENTRY)&_ZN6S159C12v4Ev,
  (VTBL_ENTRY)&_ZN6S159C12v5Ev,
  (VTBL_ENTRY)&_ZN6S159C12v6Ev,
  (VTBL_ENTRY)&_ZN6S159C12v7Ev,
  (VTBL_ENTRY)&_ZN6S159C12v8Ev,
  (VTBL_ENTRY)&_ZN6S159C12v9Ev,
  (VTBL_ENTRY)&_ZN6S159C13v10Ev,
  (VTBL_ENTRY)&_ZN6S159C13v11Ev,
  (VTBL_ENTRY)&_ZN6S159C13v12Ev,
  (VTBL_ENTRY)&_ZN6S159C13v13Ev,
  (VTBL_ENTRY)&_ZN6S159C13v14Ev,
  (VTBL_ENTRY)&_ZN6S159C13v15Ev,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI6S159C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S159C1D1Ev,_ZThn120_N6S159C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N6S159C1D0Ev,_ZThn120_N6S159C1D0Ev),
  (VTBL_ENTRY)&_ZN7S159C124v105Ev,
  (VTBL_ENTRY)&_ZN7S159C124v106Ev,
  (VTBL_ENTRY)&_ZN7S159C124v107Ev,
  (VTBL_ENTRY)&_ZN7S159C124v108Ev,
  (VTBL_ENTRY)&_ZN7S159C124v109Ev,
  (VTBL_ENTRY)&_ZN7S159C124v110Ev,
  (VTBL_ENTRY)&_ZN7S159C124v111Ev,
  (VTBL_ENTRY)&_ZN7S159C124v112Ev,
};
extern VTBL_ENTRY _ZTI6S159C1[];
extern  VTBL_ENTRY _ZTV6S159C1[];
Class_Descriptor cd_S159C1 = {  "S159C1", // class name
  bases_S159C1, 6,
  &(vtc_S159C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,248), // object size
  NSPAIRA(_ZTI6S159C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S159C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C7  {
  int s89c7f0;
  __tsi64 s89c7f1;
  void *s89c7f2[4];
  int s89c7f3[2];
  void *s89c7f4;
  ::S3422C4_nt s89c7f5;
  void *s89c7f6[2];
  virtual  ~S89C7(); // _ZN5S89C7D1Ev
  virtual void  v4(); // _ZN5S89C72v4Ev
  virtual void  v5(); // _ZN5S89C72v5Ev
  virtual void  v6(); // _ZN5S89C72v6Ev
  virtual void  v7(); // _ZN5S89C72v7Ev
  virtual void  v8(); // _ZN5S89C72v8Ev
  virtual void  v9(); // _ZN5S89C72v9Ev
  virtual void  v10(); // _ZN5S89C73v10Ev
  virtual void  v11(); // _ZN5S89C73v11Ev
  virtual void  v12(); // _ZN5S89C73v12Ev
  virtual void  v13(); // _ZN5S89C73v13Ev
  virtual void  v14(); // _ZN5S89C73v14Ev
  virtual void  v15(); // _ZN5S89C73v15Ev
  virtual void  v16(); // _ZN5S89C73v16Ev
  virtual void  v17(); // _ZN5S89C73v17Ev
  virtual void  v18(); // _ZN5S89C73v18Ev
  virtual void  v19(); // _ZN5S89C73v19Ev
  virtual void  v20(); // _ZN5S89C73v20Ev
  virtual void  v21(); // _ZN5S89C73v21Ev
  virtual void  v22(); // _ZN5S89C73v22Ev
  virtual void  v23(); // _ZN5S89C73v23Ev
  virtual void  v24(); // _ZN5S89C73v24Ev
  virtual void  v25(); // _ZN5S89C73v25Ev
  virtual void  v26(); // _ZN5S89C73v26Ev
  virtual void  v27(); // _ZN5S89C73v27Ev
  virtual void  v28(); // _ZN5S89C73v28Ev
  virtual void  v29(); // _ZN5S89C73v29Ev
  virtual void  v30(); // _ZN5S89C73v30Ev
  virtual void  v31(); // _ZN5S89C73v31Ev
  virtual void  v32(); // _ZN5S89C73v32Ev
  virtual void  v33(); // _ZN5S89C73v33Ev
  virtual void  v34(); // _ZN5S89C73v34Ev
  virtual void  v35(); // _ZN5S89C73v35Ev
  virtual void  v36(); // _ZN5S89C73v36Ev
  virtual void  v37(); // _ZN5S89C73v37Ev
  virtual void  v38(); // _ZN5S89C73v38Ev
  virtual void  v39(); // _ZN5S89C73v39Ev
  virtual void  v40(); // _ZN5S89C73v40Ev
  virtual void  v41(); // _ZN5S89C73v41Ev
  virtual void  v42(); // _ZN5S89C73v42Ev
  virtual void  v43(); // _ZN5S89C73v43Ev
  virtual void  v44(); // _ZN5S89C73v44Ev
  virtual void  v45(); // _ZN5S89C73v45Ev
  virtual void  v46(); // _ZN5S89C73v46Ev
  virtual void  v47(); // _ZN5S89C73v47Ev
  virtual void  v48(); // _ZN5S89C73v48Ev
  virtual void  v49(); // _ZN5S89C73v49Ev
  virtual void  v50(); // _ZN5S89C73v50Ev
  virtual void  v51(); // _ZN5S89C73v51Ev
  virtual void  v52(); // _ZN5S89C73v52Ev
  virtual void  v53(); // _ZN5S89C73v53Ev
  virtual void  v54(); // _ZN5S89C73v54Ev
  virtual void  v55(); // _ZN5S89C73v55Ev
  virtual void  v56(); // _ZN5S89C73v56Ev
  virtual void  v57(); // _ZN5S89C73v57Ev
  virtual void  v58(); // _ZN5S89C73v58Ev
  virtual void  v59(); // _ZN5S89C73v59Ev
  virtual void  v60(); // _ZN5S89C73v60Ev
  virtual void  v61(); // _ZN5S89C73v61Ev
  virtual void  v62(); // _ZN5S89C73v62Ev
  virtual void  v63(); // _ZN5S89C73v63Ev
  virtual void  v64(); // _ZN5S89C73v64Ev
  virtual void  v65(); // _ZN5S89C73v65Ev
  virtual void  v66(); // _ZN5S89C73v66Ev
  virtual void  v67(); // _ZN5S89C73v67Ev
  S89C7(); // tgen
};
//SIG(-1 S89C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S89C7 ::~S89C7(){ note_dtor("S89C7", this);}
void  S89C7 ::v4(){vfunc_called(this, "_ZN5S89C72v4Ev");}
void  S89C7 ::v5(){vfunc_called(this, "_ZN5S89C72v5Ev");}
void  S89C7 ::v6(){vfunc_called(this, "_ZN5S89C72v6Ev");}
void  S89C7 ::v7(){vfunc_called(this, "_ZN5S89C72v7Ev");}
void  S89C7 ::v8(){vfunc_called(this, "_ZN5S89C72v8Ev");}
void  S89C7 ::v9(){vfunc_called(this, "_ZN5S89C72v9Ev");}
void  S89C7 ::v10(){vfunc_called(this, "_ZN5S89C73v10Ev");}
void  S89C7 ::v11(){vfunc_called(this, "_ZN5S89C73v11Ev");}
void  S89C7 ::v12(){vfunc_called(this, "_ZN5S89C73v12Ev");}
void  S89C7 ::v13(){vfunc_called(this, "_ZN5S89C73v13Ev");}
void  S89C7 ::v14(){vfunc_called(this, "_ZN5S89C73v14Ev");}
void  S89C7 ::v15(){vfunc_called(this, "_ZN5S89C73v15Ev");}
void  S89C7 ::v16(){vfunc_called(this, "_ZN5S89C73v16Ev");}
void  S89C7 ::v17(){vfunc_called(this, "_ZN5S89C73v17Ev");}
void  S89C7 ::v18(){vfunc_called(this, "_ZN5S89C73v18Ev");}
void  S89C7 ::v19(){vfunc_called(this, "_ZN5S89C73v19Ev");}
void  S89C7 ::v20(){vfunc_called(this, "_ZN5S89C73v20Ev");}
void  S89C7 ::v21(){vfunc_called(this, "_ZN5S89C73v21Ev");}
void  S89C7 ::v22(){vfunc_called(this, "_ZN5S89C73v22Ev");}
void  S89C7 ::v23(){vfunc_called(this, "_ZN5S89C73v23Ev");}
void  S89C7 ::v24(){vfunc_called(this, "_ZN5S89C73v24Ev");}
void  S89C7 ::v25(){vfunc_called(this, "_ZN5S89C73v25Ev");}
void  S89C7 ::v26(){vfunc_called(this, "_ZN5S89C73v26Ev");}
void  S89C7 ::v27(){vfunc_called(this, "_ZN5S89C73v27Ev");}
void  S89C7 ::v28(){vfunc_called(this, "_ZN5S89C73v28Ev");}
void  S89C7 ::v29(){vfunc_called(this, "_ZN5S89C73v29Ev");}
void  S89C7 ::v30(){vfunc_called(this, "_ZN5S89C73v30Ev");}
void  S89C7 ::v31(){vfunc_called(this, "_ZN5S89C73v31Ev");}
void  S89C7 ::v32(){vfunc_called(this, "_ZN5S89C73v32Ev");}
void  S89C7 ::v33(){vfunc_called(this, "_ZN5S89C73v33Ev");}
void  S89C7 ::v34(){vfunc_called(this, "_ZN5S89C73v34Ev");}
void  S89C7 ::v35(){vfunc_called(this, "_ZN5S89C73v35Ev");}
void  S89C7 ::v36(){vfunc_called(this, "_ZN5S89C73v36Ev");}
void  S89C7 ::v37(){vfunc_called(this, "_ZN5S89C73v37Ev");}
void  S89C7 ::v38(){vfunc_called(this, "_ZN5S89C73v38Ev");}
void  S89C7 ::v39(){vfunc_called(this, "_ZN5S89C73v39Ev");}
void  S89C7 ::v40(){vfunc_called(this, "_ZN5S89C73v40Ev");}
void  S89C7 ::v41(){vfunc_called(this, "_ZN5S89C73v41Ev");}
void  S89C7 ::v42(){vfunc_called(this, "_ZN5S89C73v42Ev");}
void  S89C7 ::v43(){vfunc_called(this, "_ZN5S89C73v43Ev");}
void  S89C7 ::v44(){vfunc_called(this, "_ZN5S89C73v44Ev");}
void  S89C7 ::v45(){vfunc_called(this, "_ZN5S89C73v45Ev");}
void  S89C7 ::v46(){vfunc_called(this, "_ZN5S89C73v46Ev");}
void  S89C7 ::v47(){vfunc_called(this, "_ZN5S89C73v47Ev");}
void  S89C7 ::v48(){vfunc_called(this, "_ZN5S89C73v48Ev");}
void  S89C7 ::v49(){vfunc_called(this, "_ZN5S89C73v49Ev");}
void  S89C7 ::v50(){vfunc_called(this, "_ZN5S89C73v50Ev");}
void  S89C7 ::v51(){vfunc_called(this, "_ZN5S89C73v51Ev");}
void  S89C7 ::v52(){vfunc_called(this, "_ZN5S89C73v52Ev");}
void  S89C7 ::v53(){vfunc_called(this, "_ZN5S89C73v53Ev");}
void  S89C7 ::v54(){vfunc_called(this, "_ZN5S89C73v54Ev");}
void  S89C7 ::v55(){vfunc_called(this, "_ZN5S89C73v55Ev");}
void  S89C7 ::v56(){vfunc_called(this, "_ZN5S89C73v56Ev");}
void  S89C7 ::v57(){vfunc_called(this, "_ZN5S89C73v57Ev");}
void  S89C7 ::v58(){vfunc_called(this, "_ZN5S89C73v58Ev");}
void  S89C7 ::v59(){vfunc_called(this, "_ZN5S89C73v59Ev");}
void  S89C7 ::v60(){vfunc_called(this, "_ZN5S89C73v60Ev");}
void  S89C7 ::v61(){vfunc_called(this, "_ZN5S89C73v61Ev");}
void  S89C7 ::v62(){vfunc_called(this, "_ZN5S89C73v62Ev");}
void  S89C7 ::v63(){vfunc_called(this, "_ZN5S89C73v63Ev");}
void  S89C7 ::v64(){vfunc_called(this, "_ZN5S89C73v64Ev");}
void  S89C7 ::v65(){vfunc_called(this, "_ZN5S89C73v65Ev");}
void  S89C7 ::v66(){vfunc_called(this, "_ZN5S89C73v66Ev");}
void  S89C7 ::v67(){vfunc_called(this, "_ZN5S89C73v67Ev");}
S89C7 ::S89C7(){ note_ctor("S89C7", this);} // tgen

static void Test_S89C7()
{
  extern Class_Descriptor cd_S89C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S89C7, buf);
    S89C7 *dp, &lv = *(dp=new (buf) S89C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S89C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C7)");
    check_field_offset(lv, s89c7f0, ABISELECT(8,4), "S89C7.s89c7f0");
    check_field_offset(lv, s89c7f1, ABISELECT(16,8), "S89C7.s89c7f1");
    check_field_offset(lv, s89c7f2, ABISELECT(24,16), "S89C7.s89c7f2");
    check_field_offset(lv, s89c7f3, ABISELECT(56,32), "S89C7.s89c7f3");
    check_field_offset(lv, s89c7f4, ABISELECT(64,40), "S89C7.s89c7f4");
    check_field_offset(lv, s89c7f5, ABISELECT(72,44), "S89C7.s89c7f5");
    check_field_offset(lv, s89c7f6, ABISELECT(80,52), "S89C7.s89c7f6");
    test_class_info(&lv, &cd_S89C7);
    dp->~S89C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C7(Test_S89C7, "S89C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S89C7C1Ev();
extern void _ZN5S89C7D1Ev();
Name_Map name_map_S89C7[] = {
  NSPAIR(_ZN5S89C7C1Ev),
  NSPAIR(_ZN5S89C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S89C7[];
extern void _ZN5S89C7D1Ev();
extern void _ZN5S89C7D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
static  VTBL_ENTRY vtc_S89C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C7[0]),
  (VTBL_ENTRY)&_ZN5S89C7D1Ev,
  (VTBL_ENTRY)&_ZN5S89C7D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
Class_Descriptor cd_S89C7 = {  "S89C7", // class name
  0,0,//no base classes
  &(vtc_S89C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S89C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S89C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C6  : S89C7 {
  virtual  ~S89C6(); // _ZN5S89C6D1Ev
  virtual void  v68(); // _ZN5S89C63v68Ev
  virtual void  v69(); // _ZN5S89C63v69Ev
  S89C6(); // tgen
};
//SIG(-1 S89C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S89C6 ::~S89C6(){ note_dtor("S89C6", this);}
void  S89C6 ::v68(){vfunc_called(this, "_ZN5S89C63v68Ev");}
void  S89C6 ::v69(){vfunc_called(this, "_ZN5S89C63v69Ev");}
S89C6 ::S89C6(){ note_ctor("S89C6", this);} // tgen

static void Test_S89C6()
{
  extern Class_Descriptor cd_S89C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S89C6, buf);
    S89C6 *dp, &lv = *(dp=new (buf) S89C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S89C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C6)");
    check_base_class_offset(lv, (S89C7*), 0, "S89C6");
    test_class_info(&lv, &cd_S89C6);
    dp->~S89C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C6(Test_S89C6, "S89C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S89C6C1Ev();
extern void _ZN5S89C6D1Ev();
Name_Map name_map_S89C6[] = {
  NSPAIR(_ZN5S89C6C1Ev),
  NSPAIR(_ZN5S89C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
static Base_Class bases_S89C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C6[];
extern void _ZN5S89C6D1Ev();
extern void _ZN5S89C6D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
static  VTBL_ENTRY vtc_S89C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C6[0]),
  (VTBL_ENTRY)&_ZN5S89C6D1Ev,
  (VTBL_ENTRY)&_ZN5S89C6D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
};
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
Class_Descriptor cd_S89C6 = {  "S89C6", // class name
  bases_S89C6, 1,
  &(vtc_S89C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S89C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S89C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C5  : S89C6 {
  char s89c5f0;
  ::S3422C23 s89c5f1;
  ::S49C12_nt s89c5f2;
  virtual  ~S89C5(); // _ZN5S89C5D1Ev
  virtual void  v70(); // _ZN5S89C53v70Ev
  virtual void  v71(); // _ZN5S89C53v71Ev
  virtual void  v72(); // _ZN5S89C53v72Ev
  virtual void  v73(); // _ZN5S89C53v73Ev
  virtual void  v74(); // _ZN5S89C53v74Ev
  virtual void  v75(); // _ZN5S89C53v75Ev
  virtual void  v76(); // _ZN5S89C53v76Ev
  virtual void  v77(); // _ZN5S89C53v77Ev
  virtual void  v78(); // _ZN5S89C53v78Ev
  virtual void  v79(); // _ZN5S89C53v79Ev
  virtual void  v80(); // _ZN5S89C53v80Ev
  virtual void  v81(); // _ZN5S89C53v81Ev
  S89C5(); // tgen
};
//SIG(-1 S89C5) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S89C5 ::~S89C5(){ note_dtor("S89C5", this);}
void  S89C5 ::v70(){vfunc_called(this, "_ZN5S89C53v70Ev");}
void  S89C5 ::v71(){vfunc_called(this, "_ZN5S89C53v71Ev");}
void  S89C5 ::v72(){vfunc_called(this, "_ZN5S89C53v72Ev");}
void  S89C5 ::v73(){vfunc_called(this, "_ZN5S89C53v73Ev");}
void  S89C5 ::v74(){vfunc_called(this, "_ZN5S89C53v74Ev");}
void  S89C5 ::v75(){vfunc_called(this, "_ZN5S89C53v75Ev");}
void  S89C5 ::v76(){vfunc_called(this, "_ZN5S89C53v76Ev");}
void  S89C5 ::v77(){vfunc_called(this, "_ZN5S89C53v77Ev");}
void  S89C5 ::v78(){vfunc_called(this, "_ZN5S89C53v78Ev");}
void  S89C5 ::v79(){vfunc_called(this, "_ZN5S89C53v79Ev");}
void  S89C5 ::v80(){vfunc_called(this, "_ZN5S89C53v80Ev");}
void  S89C5 ::v81(){vfunc_called(this, "_ZN5S89C53v81Ev");}
S89C5 ::S89C5(){ note_ctor("S89C5", this);} // tgen

static void Test_S89C5()
{
  extern Class_Descriptor cd_S89C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S89C5, buf);
    S89C5 *dp, &lv = *(dp=new (buf) S89C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S89C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C5)");
    check_base_class_offset(lv, (S89C7*)(S89C6*), 0, "S89C5");
    check_base_class_offset(lv, (S89C6*), 0, "S89C5");
    check_field_offset(lv, s89c5f0, ABISELECT(96,60), "S89C5.s89c5f0");
    check_field_offset(lv, s89c5f1, ABISELECT(104,64), "S89C5.s89c5f1");
    check_field_offset(lv, s89c5f2, ABISELECT(120,76), "S89C5.s89c5f2");
    test_class_info(&lv, &cd_S89C5);
    dp->~S89C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C5(Test_S89C5, "S89C5", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN5S89C5C1Ev();
extern void _ZN5S89C5D1Ev();
Name_Map name_map_S89C5[] = {
  NSPAIR(_ZN5S89C5C1Ev),
  NSPAIR(_ZN5S89C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
extern Class_Descriptor cd_S89C6;
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
static Base_Class bases_S89C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S89C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C5[];
extern void _ZN5S89C5D1Ev();
extern void _ZN5S89C5D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
extern void _ZN5S89C53v70Ev();
extern void _ZN5S89C53v71Ev();
extern void _ZN5S89C53v72Ev();
extern void _ZN5S89C53v73Ev();
extern void _ZN5S89C53v74Ev();
extern void _ZN5S89C53v75Ev();
extern void _ZN5S89C53v76Ev();
extern void _ZN5S89C53v77Ev();
extern void _ZN5S89C53v78Ev();
extern void _ZN5S89C53v79Ev();
extern void _ZN5S89C53v80Ev();
extern void _ZN5S89C53v81Ev();
static  VTBL_ENTRY vtc_S89C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C5[0]),
  (VTBL_ENTRY)&_ZN5S89C5D1Ev,
  (VTBL_ENTRY)&_ZN5S89C5D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
  (VTBL_ENTRY)&_ZN5S89C53v70Ev,
  (VTBL_ENTRY)&_ZN5S89C53v71Ev,
  (VTBL_ENTRY)&_ZN5S89C53v72Ev,
  (VTBL_ENTRY)&_ZN5S89C53v73Ev,
  (VTBL_ENTRY)&_ZN5S89C53v74Ev,
  (VTBL_ENTRY)&_ZN5S89C53v75Ev,
  (VTBL_ENTRY)&_ZN5S89C53v76Ev,
  (VTBL_ENTRY)&_ZN5S89C53v77Ev,
  (VTBL_ENTRY)&_ZN5S89C53v78Ev,
  (VTBL_ENTRY)&_ZN5S89C53v79Ev,
  (VTBL_ENTRY)&_ZN5S89C53v80Ev,
  (VTBL_ENTRY)&_ZN5S89C53v81Ev,
};
extern VTBL_ENTRY _ZTI5S89C5[];
extern  VTBL_ENTRY _ZTV5S89C5[];
Class_Descriptor cd_S89C5 = {  "S89C5", // class name
  bases_S89C5, 2,
  &(vtc_S89C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI5S89C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S89C5),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C4  : S89C5 {
  ::S3422C17 s89c4f0;
  virtual  ~S89C4(); // _ZN5S89C4D1Ev
  virtual void  v82(); // _ZN5S89C43v82Ev
  virtual void  v83(); // _ZN5S89C43v83Ev
  virtual void  v84(); // _ZN5S89C43v84Ev
  S89C4(); // tgen
};
//SIG(-1 S89C4) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 FC10{ BC11{ BC8}}}


 S89C4 ::~S89C4(){ note_dtor("S89C4", this);}
void  S89C4 ::v82(){vfunc_called(this, "_ZN5S89C43v82Ev");}
void  S89C4 ::v83(){vfunc_called(this, "_ZN5S89C43v83Ev");}
void  S89C4 ::v84(){vfunc_called(this, "_ZN5S89C43v84Ev");}
S89C4 ::S89C4(){ note_ctor("S89C4", this);} // tgen

static void Test_S89C4()
{
  extern Class_Descriptor cd_S89C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,26)];
    init_test(&cd_S89C4, buf);
    S89C4 *dp, &lv = *(dp=new (buf) S89C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,100), "sizeof(S89C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C4)");
    check_base_class_offset(lv, (S89C7*)(S89C6*)(S89C5*), 0, "S89C4");
    check_base_class_offset(lv, (S89C6*)(S89C5*), 0, "S89C4");
    check_base_class_offset(lv, (S89C5*), 0, "S89C4");
    check_field_offset(lv, s89c4f0, ABISELECT(136,88), "S89C4.s89c4f0");
    test_class_info(&lv, &cd_S89C4);
    dp->~S89C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C4(Test_S89C4, "S89C4", ABISELECT(152,100));

#else // __cplusplus

extern void _ZN5S89C4C1Ev();
extern void _ZN5S89C4D1Ev();
Name_Map name_map_S89C4[] = {
  NSPAIR(_ZN5S89C4C1Ev),
  NSPAIR(_ZN5S89C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
extern Class_Descriptor cd_S89C6;
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
extern Class_Descriptor cd_S89C5;
extern VTBL_ENTRY _ZTI5S89C5[];
extern  VTBL_ENTRY _ZTV5S89C5[];
static Base_Class bases_S89C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S89C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S89C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C4[];
extern void _ZN5S89C4D1Ev();
extern void _ZN5S89C4D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
extern void _ZN5S89C53v70Ev();
extern void _ZN5S89C53v71Ev();
extern void _ZN5S89C53v72Ev();
extern void _ZN5S89C53v73Ev();
extern void _ZN5S89C53v74Ev();
extern void _ZN5S89C53v75Ev();
extern void _ZN5S89C53v76Ev();
extern void _ZN5S89C53v77Ev();
extern void _ZN5S89C53v78Ev();
extern void _ZN5S89C53v79Ev();
extern void _ZN5S89C53v80Ev();
extern void _ZN5S89C53v81Ev();
extern void _ZN5S89C43v82Ev();
extern void _ZN5S89C43v83Ev();
extern void _ZN5S89C43v84Ev();
static  VTBL_ENTRY vtc_S89C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C4[0]),
  (VTBL_ENTRY)&_ZN5S89C4D1Ev,
  (VTBL_ENTRY)&_ZN5S89C4D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
  (VTBL_ENTRY)&_ZN5S89C53v70Ev,
  (VTBL_ENTRY)&_ZN5S89C53v71Ev,
  (VTBL_ENTRY)&_ZN5S89C53v72Ev,
  (VTBL_ENTRY)&_ZN5S89C53v73Ev,
  (VTBL_ENTRY)&_ZN5S89C53v74Ev,
  (VTBL_ENTRY)&_ZN5S89C53v75Ev,
  (VTBL_ENTRY)&_ZN5S89C53v76Ev,
  (VTBL_ENTRY)&_ZN5S89C53v77Ev,
  (VTBL_ENTRY)&_ZN5S89C53v78Ev,
  (VTBL_ENTRY)&_ZN5S89C53v79Ev,
  (VTBL_ENTRY)&_ZN5S89C53v80Ev,
  (VTBL_ENTRY)&_ZN5S89C53v81Ev,
  (VTBL_ENTRY)&_ZN5S89C43v82Ev,
  (VTBL_ENTRY)&_ZN5S89C43v83Ev,
  (VTBL_ENTRY)&_ZN5S89C43v84Ev,
};
extern VTBL_ENTRY _ZTI5S89C4[];
extern  VTBL_ENTRY _ZTV5S89C4[];
Class_Descriptor cd_S89C4 = {  "S89C4", // class name
  bases_S89C4, 3,
  &(vtc_S89C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,100), // object size
  NSPAIRA(_ZTI5S89C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S89C4),85, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C15  {
  virtual  ~S89C15(); // _ZN6S89C15D1Ev
  virtual void  v85(); // _ZN6S89C153v85Ev
  virtual void  v86(); // _ZN6S89C153v86Ev
  virtual void  v87(); // _ZN6S89C153v87Ev
  virtual void  v88(); // _ZN6S89C153v88Ev
  S89C15(); // tgen
};
//SIG(-1 S89C15) C1{ vd v1 v2 v3 v4}


 S89C15 ::~S89C15(){ note_dtor("S89C15", this);}
void  S89C15 ::v85(){vfunc_called(this, "_ZN6S89C153v85Ev");}
void  S89C15 ::v86(){vfunc_called(this, "_ZN6S89C153v86Ev");}
void  S89C15 ::v87(){vfunc_called(this, "_ZN6S89C153v87Ev");}
void  S89C15 ::v88(){vfunc_called(this, "_ZN6S89C153v88Ev");}
S89C15 ::S89C15(){ note_ctor("S89C15", this);} // tgen

static void Test_S89C15()
{
  extern Class_Descriptor cd_S89C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S89C15, buf);
    S89C15 *dp, &lv = *(dp=new (buf) S89C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S89C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C15)");
    test_class_info(&lv, &cd_S89C15);
    dp->~S89C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C15(Test_S89C15, "S89C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S89C15C1Ev();
extern void _ZN6S89C15D1Ev();
Name_Map name_map_S89C15[] = {
  NSPAIR(_ZN6S89C15C1Ev),
  NSPAIR(_ZN6S89C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S89C15[];
extern void _ZN6S89C15D1Ev();
extern void _ZN6S89C15D0Ev();
extern void _ZN6S89C153v85Ev();
extern void _ZN6S89C153v86Ev();
extern void _ZN6S89C153v87Ev();
extern void _ZN6S89C153v88Ev();
static  VTBL_ENTRY vtc_S89C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S89C15[0]),
  (VTBL_ENTRY)&_ZN6S89C15D1Ev,
  (VTBL_ENTRY)&_ZN6S89C15D0Ev,
  (VTBL_ENTRY)&_ZN6S89C153v85Ev,
  (VTBL_ENTRY)&_ZN6S89C153v86Ev,
  (VTBL_ENTRY)&_ZN6S89C153v87Ev,
  (VTBL_ENTRY)&_ZN6S89C153v88Ev,
};
extern VTBL_ENTRY _ZTI6S89C15[];
extern  VTBL_ENTRY _ZTV6S89C15[];
Class_Descriptor cd_S89C15 = {  "S89C15", // class name
  0,0,//no base classes
  &(vtc_S89C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S89C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S89C15),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C3  : S89C4 , S89C15 {
  virtual  ~S89C3(); // _ZN5S89C3D1Ev
  virtual void  v89(); // _ZN5S89C33v89Ev
  virtual void  v90(); // _ZN5S89C33v90Ev
  virtual void  v91(); // _ZN5S89C33v91Ev
  virtual void  v92(); // _ZN5S89C33v92Ev
  virtual void  v93(); // _ZN5S89C33v93Ev
  virtual void  v94(); // _ZN5S89C33v94Ev
  virtual void  v95(); // _ZN5S89C33v95Ev
  virtual void  v96(); // _ZN5S89C33v96Ev
  virtual void  v97(); // _ZN5S89C33v97Ev
  S89C3(); // tgen
};
//SIG(-1 S89C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v88 v89 v90 FC11{ BC12{ BC9}}} BC13{ vd v91 v92 v93 v94} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S89C3 ::~S89C3(){ note_dtor("S89C3", this);}
void  S89C3 ::v89(){vfunc_called(this, "_ZN5S89C33v89Ev");}
void  S89C3 ::v90(){vfunc_called(this, "_ZN5S89C33v90Ev");}
void  S89C3 ::v91(){vfunc_called(this, "_ZN5S89C33v91Ev");}
void  S89C3 ::v92(){vfunc_called(this, "_ZN5S89C33v92Ev");}
void  S89C3 ::v93(){vfunc_called(this, "_ZN5S89C33v93Ev");}
void  S89C3 ::v94(){vfunc_called(this, "_ZN5S89C33v94Ev");}
void  S89C3 ::v95(){vfunc_called(this, "_ZN5S89C33v95Ev");}
void  S89C3 ::v96(){vfunc_called(this, "_ZN5S89C33v96Ev");}
void  S89C3 ::v97(){vfunc_called(this, "_ZN5S89C33v97Ev");}
S89C3 ::S89C3(){ note_ctor("S89C3", this);} // tgen

static void Test_S89C3()
{
  extern Class_Descriptor cd_S89C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,27)];
    init_test(&cd_S89C3, buf);
    S89C3 *dp, &lv = *(dp=new (buf) S89C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,104), "sizeof(S89C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C3)");
    check_base_class_offset(lv, (S89C7*)(S89C6*)(S89C5*)(S89C4*), 0, "S89C3");
    check_base_class_offset(lv, (S89C6*)(S89C5*)(S89C4*), 0, "S89C3");
    check_base_class_offset(lv, (S89C5*)(S89C4*), 0, "S89C3");
    check_base_class_offset(lv, (S89C4*), 0, "S89C3");
    check_base_class_offset(lv, (S89C15*), ABISELECT(152,100), "S89C3");
    test_class_info(&lv, &cd_S89C3);
    dp->~S89C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C3(Test_S89C3, "S89C3", ABISELECT(160,104));

#else // __cplusplus

extern void _ZN5S89C3C1Ev();
extern void _ZN5S89C3D1Ev();
Name_Map name_map_S89C3[] = {
  NSPAIR(_ZN5S89C3C1Ev),
  NSPAIR(_ZN5S89C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
extern Class_Descriptor cd_S89C6;
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
extern Class_Descriptor cd_S89C5;
extern VTBL_ENTRY _ZTI5S89C5[];
extern  VTBL_ENTRY _ZTV5S89C5[];
extern Class_Descriptor cd_S89C4;
extern VTBL_ENTRY _ZTI5S89C4[];
extern  VTBL_ENTRY _ZTV5S89C4[];
extern Class_Descriptor cd_S89C15;
extern VTBL_ENTRY _ZTI6S89C15[];
extern  VTBL_ENTRY _ZTV6S89C15[];
static Base_Class bases_S89C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S89C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S89C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S89C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S89C15,    ABISELECT(152,100), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C3[];
extern void _ZN5S89C3D1Ev();
extern void _ZN5S89C3D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
extern void _ZN5S89C53v70Ev();
extern void _ZN5S89C53v71Ev();
extern void _ZN5S89C53v72Ev();
extern void _ZN5S89C53v73Ev();
extern void _ZN5S89C53v74Ev();
extern void _ZN5S89C53v75Ev();
extern void _ZN5S89C53v76Ev();
extern void _ZN5S89C53v77Ev();
extern void _ZN5S89C53v78Ev();
extern void _ZN5S89C53v79Ev();
extern void _ZN5S89C53v80Ev();
extern void _ZN5S89C53v81Ev();
extern void _ZN5S89C43v82Ev();
extern void _ZN5S89C43v83Ev();
extern void _ZN5S89C43v84Ev();
extern void _ZN5S89C33v89Ev();
extern void _ZN5S89C33v90Ev();
extern void _ZN5S89C33v91Ev();
extern void _ZN5S89C33v92Ev();
extern void _ZN5S89C33v93Ev();
extern void _ZN5S89C33v94Ev();
extern void _ZN5S89C33v95Ev();
extern void _ZN5S89C33v96Ev();
extern void _ZN5S89C33v97Ev();
extern void ABISELECT(_ZThn152_N5S89C3D1Ev,_ZThn100_N5S89C3D1Ev)();
extern void ABISELECT(_ZThn152_N5S89C3D0Ev,_ZThn100_N5S89C3D0Ev)();
extern void _ZN6S89C153v85Ev();
extern void _ZN6S89C153v86Ev();
extern void _ZN6S89C153v87Ev();
extern void _ZN6S89C153v88Ev();
static  VTBL_ENTRY vtc_S89C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C3[0]),
  (VTBL_ENTRY)&_ZN5S89C3D1Ev,
  (VTBL_ENTRY)&_ZN5S89C3D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
  (VTBL_ENTRY)&_ZN5S89C53v70Ev,
  (VTBL_ENTRY)&_ZN5S89C53v71Ev,
  (VTBL_ENTRY)&_ZN5S89C53v72Ev,
  (VTBL_ENTRY)&_ZN5S89C53v73Ev,
  (VTBL_ENTRY)&_ZN5S89C53v74Ev,
  (VTBL_ENTRY)&_ZN5S89C53v75Ev,
  (VTBL_ENTRY)&_ZN5S89C53v76Ev,
  (VTBL_ENTRY)&_ZN5S89C53v77Ev,
  (VTBL_ENTRY)&_ZN5S89C53v78Ev,
  (VTBL_ENTRY)&_ZN5S89C53v79Ev,
  (VTBL_ENTRY)&_ZN5S89C53v80Ev,
  (VTBL_ENTRY)&_ZN5S89C53v81Ev,
  (VTBL_ENTRY)&_ZN5S89C43v82Ev,
  (VTBL_ENTRY)&_ZN5S89C43v83Ev,
  (VTBL_ENTRY)&_ZN5S89C43v84Ev,
  (VTBL_ENTRY)&_ZN5S89C33v89Ev,
  (VTBL_ENTRY)&_ZN5S89C33v90Ev,
  (VTBL_ENTRY)&_ZN5S89C33v91Ev,
  (VTBL_ENTRY)&_ZN5S89C33v92Ev,
  (VTBL_ENTRY)&_ZN5S89C33v93Ev,
  (VTBL_ENTRY)&_ZN5S89C33v94Ev,
  (VTBL_ENTRY)&_ZN5S89C33v95Ev,
  (VTBL_ENTRY)&_ZN5S89C33v96Ev,
  (VTBL_ENTRY)&_ZN5S89C33v97Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S89C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C3D1Ev,_ZThn100_N5S89C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C3D0Ev,_ZThn100_N5S89C3D0Ev),
  (VTBL_ENTRY)&_ZN6S89C153v85Ev,
  (VTBL_ENTRY)&_ZN6S89C153v86Ev,
  (VTBL_ENTRY)&_ZN6S89C153v87Ev,
  (VTBL_ENTRY)&_ZN6S89C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S89C3[];
extern  VTBL_ENTRY _ZTV5S89C3[];
Class_Descriptor cd_S89C3 = {  "S89C3", // class name
  bases_S89C3, 5,
  &(vtc_S89C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,104), // object size
  NSPAIRA(_ZTI5S89C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5S89C3),102, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C2  : S89C3 {
  unsigned int s89c2f0:1;
  unsigned int s89c2f1:1;
  unsigned int s89c2f2:1;
  unsigned int s89c2f3:1;
  ::S3422C22_nt s89c2f4;
  virtual  ~S89C2(); // _ZN5S89C2D1Ev
  virtual void  v98(); // _ZN5S89C23v98Ev
  virtual void  v99(); // _ZN5S89C23v99Ev
  virtual void  v100(); // _ZN5S89C24v100Ev
  virtual void  v101(); // _ZN5S89C24v101Ev
  virtual void  v102(); // _ZN5S89C24v102Ev
  S89C2(); // tgen
};
//SIG(-1 S89C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v84 v85 v86 FC12{ BC13{ BC10}}} BC14{ vd v87 v88 v89 v90} vd v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC8}}


 S89C2 ::~S89C2(){ note_dtor("S89C2", this);}
void  S89C2 ::v98(){vfunc_called(this, "_ZN5S89C23v98Ev");}
void  S89C2 ::v99(){vfunc_called(this, "_ZN5S89C23v99Ev");}
void  S89C2 ::v100(){vfunc_called(this, "_ZN5S89C24v100Ev");}
void  S89C2 ::v101(){vfunc_called(this, "_ZN5S89C24v101Ev");}
void  S89C2 ::v102(){vfunc_called(this, "_ZN5S89C24v102Ev");}
S89C2 ::S89C2(){ note_ctor("S89C2", this);} // tgen

static void Test_S89C2()
{
  extern Class_Descriptor cd_S89C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S89C2, buf);
    S89C2 *dp, &lv = *(dp=new (buf) S89C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S89C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C2)");
    check_base_class_offset(lv, (S89C7*)(S89C6*)(S89C5*)(S89C4*)(S89C3*), 0, "S89C2");
    check_base_class_offset(lv, (S89C6*)(S89C5*)(S89C4*)(S89C3*), 0, "S89C2");
    check_base_class_offset(lv, (S89C5*)(S89C4*)(S89C3*), 0, "S89C2");
    check_base_class_offset(lv, (S89C4*)(S89C3*), 0, "S89C2");
    check_base_class_offset(lv, (S89C15*)(S89C3*), ABISELECT(152,100), "S89C2");
    check_base_class_offset(lv, (S89C3*), 0, "S89C2");
    set_bf_and_test(lv, s89c2f0, ABISELECT(160,104), 0, 1, 1, "S89C2");
    set_bf_and_test(lv, s89c2f1, ABISELECT(160,104), 1, 1, 1, "S89C2");
    set_bf_and_test(lv, s89c2f2, ABISELECT(160,104), 2, 1, 1, "S89C2");
    set_bf_and_test(lv, s89c2f3, ABISELECT(160,104), 3, 1, 1, "S89C2");
    check_field_offset(lv, s89c2f4, ABISELECT(168,108), "S89C2.s89c2f4");
    test_class_info(&lv, &cd_S89C2);
    dp->~S89C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C2(Test_S89C2, "S89C2", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN5S89C2C1Ev();
extern void _ZN5S89C2D1Ev();
Name_Map name_map_S89C2[] = {
  NSPAIR(_ZN5S89C2C1Ev),
  NSPAIR(_ZN5S89C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
extern Class_Descriptor cd_S89C6;
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
extern Class_Descriptor cd_S89C5;
extern VTBL_ENTRY _ZTI5S89C5[];
extern  VTBL_ENTRY _ZTV5S89C5[];
extern Class_Descriptor cd_S89C4;
extern VTBL_ENTRY _ZTI5S89C4[];
extern  VTBL_ENTRY _ZTV5S89C4[];
extern Class_Descriptor cd_S89C15;
extern VTBL_ENTRY _ZTI6S89C15[];
extern  VTBL_ENTRY _ZTV6S89C15[];
extern Class_Descriptor cd_S89C3;
extern VTBL_ENTRY _ZTI5S89C3[];
extern  VTBL_ENTRY _ZTV5S89C3[];
static Base_Class bases_S89C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S89C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S89C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S89C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S89C15,    ABISELECT(152,100), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S89C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C2[];
extern void _ZN5S89C2D1Ev();
extern void _ZN5S89C2D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
extern void _ZN5S89C53v70Ev();
extern void _ZN5S89C53v71Ev();
extern void _ZN5S89C53v72Ev();
extern void _ZN5S89C53v73Ev();
extern void _ZN5S89C53v74Ev();
extern void _ZN5S89C53v75Ev();
extern void _ZN5S89C53v76Ev();
extern void _ZN5S89C53v77Ev();
extern void _ZN5S89C53v78Ev();
extern void _ZN5S89C53v79Ev();
extern void _ZN5S89C53v80Ev();
extern void _ZN5S89C53v81Ev();
extern void _ZN5S89C43v82Ev();
extern void _ZN5S89C43v83Ev();
extern void _ZN5S89C43v84Ev();
extern void _ZN5S89C33v89Ev();
extern void _ZN5S89C33v90Ev();
extern void _ZN5S89C33v91Ev();
extern void _ZN5S89C33v92Ev();
extern void _ZN5S89C33v93Ev();
extern void _ZN5S89C33v94Ev();
extern void _ZN5S89C33v95Ev();
extern void _ZN5S89C33v96Ev();
extern void _ZN5S89C33v97Ev();
extern void _ZN5S89C23v98Ev();
extern void _ZN5S89C23v99Ev();
extern void _ZN5S89C24v100Ev();
extern void _ZN5S89C24v101Ev();
extern void _ZN5S89C24v102Ev();
extern void ABISELECT(_ZThn152_N5S89C2D1Ev,_ZThn100_N5S89C2D1Ev)();
extern void ABISELECT(_ZThn152_N5S89C2D0Ev,_ZThn100_N5S89C2D0Ev)();
extern void _ZN6S89C153v85Ev();
extern void _ZN6S89C153v86Ev();
extern void _ZN6S89C153v87Ev();
extern void _ZN6S89C153v88Ev();
static  VTBL_ENTRY vtc_S89C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C2[0]),
  (VTBL_ENTRY)&_ZN5S89C2D1Ev,
  (VTBL_ENTRY)&_ZN5S89C2D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
  (VTBL_ENTRY)&_ZN5S89C53v70Ev,
  (VTBL_ENTRY)&_ZN5S89C53v71Ev,
  (VTBL_ENTRY)&_ZN5S89C53v72Ev,
  (VTBL_ENTRY)&_ZN5S89C53v73Ev,
  (VTBL_ENTRY)&_ZN5S89C53v74Ev,
  (VTBL_ENTRY)&_ZN5S89C53v75Ev,
  (VTBL_ENTRY)&_ZN5S89C53v76Ev,
  (VTBL_ENTRY)&_ZN5S89C53v77Ev,
  (VTBL_ENTRY)&_ZN5S89C53v78Ev,
  (VTBL_ENTRY)&_ZN5S89C53v79Ev,
  (VTBL_ENTRY)&_ZN5S89C53v80Ev,
  (VTBL_ENTRY)&_ZN5S89C53v81Ev,
  (VTBL_ENTRY)&_ZN5S89C43v82Ev,
  (VTBL_ENTRY)&_ZN5S89C43v83Ev,
  (VTBL_ENTRY)&_ZN5S89C43v84Ev,
  (VTBL_ENTRY)&_ZN5S89C33v89Ev,
  (VTBL_ENTRY)&_ZN5S89C33v90Ev,
  (VTBL_ENTRY)&_ZN5S89C33v91Ev,
  (VTBL_ENTRY)&_ZN5S89C33v92Ev,
  (VTBL_ENTRY)&_ZN5S89C33v93Ev,
  (VTBL_ENTRY)&_ZN5S89C33v94Ev,
  (VTBL_ENTRY)&_ZN5S89C33v95Ev,
  (VTBL_ENTRY)&_ZN5S89C33v96Ev,
  (VTBL_ENTRY)&_ZN5S89C33v97Ev,
  (VTBL_ENTRY)&_ZN5S89C23v98Ev,
  (VTBL_ENTRY)&_ZN5S89C23v99Ev,
  (VTBL_ENTRY)&_ZN5S89C24v100Ev,
  (VTBL_ENTRY)&_ZN5S89C24v101Ev,
  (VTBL_ENTRY)&_ZN5S89C24v102Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S89C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C2D1Ev,_ZThn100_N5S89C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C2D0Ev,_ZThn100_N5S89C2D0Ev),
  (VTBL_ENTRY)&_ZN6S89C153v85Ev,
  (VTBL_ENTRY)&_ZN6S89C153v86Ev,
  (VTBL_ENTRY)&_ZN6S89C153v87Ev,
  (VTBL_ENTRY)&_ZN6S89C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S89C2[];
extern  VTBL_ENTRY _ZTV5S89C2[];
Class_Descriptor cd_S89C2 = {  "S89C2", // class name
  bases_S89C2, 6,
  &(vtc_S89C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI5S89C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S89C2),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S89C1  : S89C2 {
  ::S3422C22_nt s89c1f0;
  ::S3422C22_nt s89c1f1;
  ::S3422C22_nt s89c1f2;
  ::S3422C22_nt s89c1f3;
  ::S3422C22_nt s89c1f4;
  ::S3422C22_nt s89c1f5;
  ::S3422C22_nt s89c1f6;
  ::S3422C22_nt s89c1f7;
  ::S3422C22_nt s89c1f8;
  ::S3422C22_nt s89c1f9;
  unsigned int s89c1f10:1;
  int s89c1f11[4];
  virtual  ~S89C1(); // _ZN5S89C1D1Ev
  virtual void  v1(); // _ZN5S89C12v1Ev
  virtual void  v2(); // _ZN5S89C12v2Ev
  virtual void  v3(); // _ZN5S89C12v3Ev
  S89C1(); // tgen
};
//SIG(1 S89C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} vd v82 v83 v84 FC13{ BC14{ BC11}}} BC15{ vd v85 v86 v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97} vd v98 v99 v100 v101 v102 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC9}} vd v1 v2 v3 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 Fi:1 Fi[4]}


 S89C1 ::~S89C1(){ note_dtor("S89C1", this);}
void  S89C1 ::v1(){vfunc_called(this, "_ZN5S89C12v1Ev");}
void  S89C1 ::v2(){vfunc_called(this, "_ZN5S89C12v2Ev");}
void  S89C1 ::v3(){vfunc_called(this, "_ZN5S89C12v3Ev");}
S89C1 ::S89C1(){ note_ctor("S89C1", this);} // tgen

static void Test_S89C1()
{
  extern Class_Descriptor cd_S89C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,66)];
    init_test(&cd_S89C1, buf);
    S89C1 *dp, &lv = *(dp=new (buf) S89C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,260), "sizeof(S89C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S89C1)");
    check_base_class_offset(lv, (S89C7*)(S89C6*)(S89C5*)(S89C4*)(S89C3*)(S89C2*), 0, "S89C1");
    check_base_class_offset(lv, (S89C6*)(S89C5*)(S89C4*)(S89C3*)(S89C2*), 0, "S89C1");
    check_base_class_offset(lv, (S89C5*)(S89C4*)(S89C3*)(S89C2*), 0, "S89C1");
    check_base_class_offset(lv, (S89C4*)(S89C3*)(S89C2*), 0, "S89C1");
    check_base_class_offset(lv, (S89C15*)(S89C3*)(S89C2*), ABISELECT(152,100), "S89C1");
    check_base_class_offset(lv, (S89C3*)(S89C2*), 0, "S89C1");
    check_base_class_offset(lv, (S89C2*), 0, "S89C1");
    check_field_offset(lv, s89c1f0, ABISELECT(184,120), "S89C1.s89c1f0");
    check_field_offset(lv, s89c1f1, ABISELECT(200,132), "S89C1.s89c1f1");
    check_field_offset(lv, s89c1f2, ABISELECT(216,144), "S89C1.s89c1f2");
    check_field_offset(lv, s89c1f3, ABISELECT(232,156), "S89C1.s89c1f3");
    check_field_offset(lv, s89c1f4, ABISELECT(248,168), "S89C1.s89c1f4");
    check_field_offset(lv, s89c1f5, ABISELECT(264,180), "S89C1.s89c1f5");
    check_field_offset(lv, s89c1f6, ABISELECT(280,192), "S89C1.s89c1f6");
    check_field_offset(lv, s89c1f7, ABISELECT(296,204), "S89C1.s89c1f7");
    check_field_offset(lv, s89c1f8, ABISELECT(312,216), "S89C1.s89c1f8");
    check_field_offset(lv, s89c1f9, ABISELECT(328,228), "S89C1.s89c1f9");
    set_bf_and_test(lv, s89c1f10, ABISELECT(344,240), 0, 1, 1, "S89C1");
    check_field_offset(lv, s89c1f11, ABISELECT(348,244), "S89C1.s89c1f11");
    test_class_info(&lv, &cd_S89C1);
    dp->~S89C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS89C1(Test_S89C1, "S89C1", ABISELECT(368,260));

#else // __cplusplus

extern void _ZN5S89C1C1Ev();
extern void _ZN5S89C1D1Ev();
Name_Map name_map_S89C1[] = {
  NSPAIR(_ZN5S89C1C1Ev),
  NSPAIR(_ZN5S89C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S89C7;
extern VTBL_ENTRY _ZTI5S89C7[];
extern  VTBL_ENTRY _ZTV5S89C7[];
extern Class_Descriptor cd_S89C6;
extern VTBL_ENTRY _ZTI5S89C6[];
extern  VTBL_ENTRY _ZTV5S89C6[];
extern Class_Descriptor cd_S89C5;
extern VTBL_ENTRY _ZTI5S89C5[];
extern  VTBL_ENTRY _ZTV5S89C5[];
extern Class_Descriptor cd_S89C4;
extern VTBL_ENTRY _ZTI5S89C4[];
extern  VTBL_ENTRY _ZTV5S89C4[];
extern Class_Descriptor cd_S89C15;
extern VTBL_ENTRY _ZTI6S89C15[];
extern  VTBL_ENTRY _ZTV6S89C15[];
extern Class_Descriptor cd_S89C3;
extern VTBL_ENTRY _ZTI5S89C3[];
extern  VTBL_ENTRY _ZTV5S89C3[];
extern Class_Descriptor cd_S89C2;
extern VTBL_ENTRY _ZTI5S89C2[];
extern  VTBL_ENTRY _ZTV5S89C2[];
static Base_Class bases_S89C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S89C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S89C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S89C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S89C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S89C15,    ABISELECT(152,100), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S89C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S89C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S89C1[];
extern void _ZN5S89C1D1Ev();
extern void _ZN5S89C1D0Ev();
extern void _ZN5S89C72v4Ev();
extern void _ZN5S89C72v5Ev();
extern void _ZN5S89C72v6Ev();
extern void _ZN5S89C72v7Ev();
extern void _ZN5S89C72v8Ev();
extern void _ZN5S89C72v9Ev();
extern void _ZN5S89C73v10Ev();
extern void _ZN5S89C73v11Ev();
extern void _ZN5S89C73v12Ev();
extern void _ZN5S89C73v13Ev();
extern void _ZN5S89C73v14Ev();
extern void _ZN5S89C73v15Ev();
extern void _ZN5S89C73v16Ev();
extern void _ZN5S89C73v17Ev();
extern void _ZN5S89C73v18Ev();
extern void _ZN5S89C73v19Ev();
extern void _ZN5S89C73v20Ev();
extern void _ZN5S89C73v21Ev();
extern void _ZN5S89C73v22Ev();
extern void _ZN5S89C73v23Ev();
extern void _ZN5S89C73v24Ev();
extern void _ZN5S89C73v25Ev();
extern void _ZN5S89C73v26Ev();
extern void _ZN5S89C73v27Ev();
extern void _ZN5S89C73v28Ev();
extern void _ZN5S89C73v29Ev();
extern void _ZN5S89C73v30Ev();
extern void _ZN5S89C73v31Ev();
extern void _ZN5S89C73v32Ev();
extern void _ZN5S89C73v33Ev();
extern void _ZN5S89C73v34Ev();
extern void _ZN5S89C73v35Ev();
extern void _ZN5S89C73v36Ev();
extern void _ZN5S89C73v37Ev();
extern void _ZN5S89C73v38Ev();
extern void _ZN5S89C73v39Ev();
extern void _ZN5S89C73v40Ev();
extern void _ZN5S89C73v41Ev();
extern void _ZN5S89C73v42Ev();
extern void _ZN5S89C73v43Ev();
extern void _ZN5S89C73v44Ev();
extern void _ZN5S89C73v45Ev();
extern void _ZN5S89C73v46Ev();
extern void _ZN5S89C73v47Ev();
extern void _ZN5S89C73v48Ev();
extern void _ZN5S89C73v49Ev();
extern void _ZN5S89C73v50Ev();
extern void _ZN5S89C73v51Ev();
extern void _ZN5S89C73v52Ev();
extern void _ZN5S89C73v53Ev();
extern void _ZN5S89C73v54Ev();
extern void _ZN5S89C73v55Ev();
extern void _ZN5S89C73v56Ev();
extern void _ZN5S89C73v57Ev();
extern void _ZN5S89C73v58Ev();
extern void _ZN5S89C73v59Ev();
extern void _ZN5S89C73v60Ev();
extern void _ZN5S89C73v61Ev();
extern void _ZN5S89C73v62Ev();
extern void _ZN5S89C73v63Ev();
extern void _ZN5S89C73v64Ev();
extern void _ZN5S89C73v65Ev();
extern void _ZN5S89C73v66Ev();
extern void _ZN5S89C73v67Ev();
extern void _ZN5S89C63v68Ev();
extern void _ZN5S89C63v69Ev();
extern void _ZN5S89C53v70Ev();
extern void _ZN5S89C53v71Ev();
extern void _ZN5S89C53v72Ev();
extern void _ZN5S89C53v73Ev();
extern void _ZN5S89C53v74Ev();
extern void _ZN5S89C53v75Ev();
extern void _ZN5S89C53v76Ev();
extern void _ZN5S89C53v77Ev();
extern void _ZN5S89C53v78Ev();
extern void _ZN5S89C53v79Ev();
extern void _ZN5S89C53v80Ev();
extern void _ZN5S89C53v81Ev();
extern void _ZN5S89C43v82Ev();
extern void _ZN5S89C43v83Ev();
extern void _ZN5S89C43v84Ev();
extern void _ZN5S89C33v89Ev();
extern void _ZN5S89C33v90Ev();
extern void _ZN5S89C33v91Ev();
extern void _ZN5S89C33v92Ev();
extern void _ZN5S89C33v93Ev();
extern void _ZN5S89C33v94Ev();
extern void _ZN5S89C33v95Ev();
extern void _ZN5S89C33v96Ev();
extern void _ZN5S89C33v97Ev();
extern void _ZN5S89C23v98Ev();
extern void _ZN5S89C23v99Ev();
extern void _ZN5S89C24v100Ev();
extern void _ZN5S89C24v101Ev();
extern void _ZN5S89C24v102Ev();
extern void _ZN5S89C12v1Ev();
extern void _ZN5S89C12v2Ev();
extern void _ZN5S89C12v3Ev();
extern void ABISELECT(_ZThn152_N5S89C1D1Ev,_ZThn100_N5S89C1D1Ev)();
extern void ABISELECT(_ZThn152_N5S89C1D0Ev,_ZThn100_N5S89C1D0Ev)();
extern void _ZN6S89C153v85Ev();
extern void _ZN6S89C153v86Ev();
extern void _ZN6S89C153v87Ev();
extern void _ZN6S89C153v88Ev();
static  VTBL_ENTRY vtc_S89C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S89C1[0]),
  (VTBL_ENTRY)&_ZN5S89C1D1Ev,
  (VTBL_ENTRY)&_ZN5S89C1D0Ev,
  (VTBL_ENTRY)&_ZN5S89C72v4Ev,
  (VTBL_ENTRY)&_ZN5S89C72v5Ev,
  (VTBL_ENTRY)&_ZN5S89C72v6Ev,
  (VTBL_ENTRY)&_ZN5S89C72v7Ev,
  (VTBL_ENTRY)&_ZN5S89C72v8Ev,
  (VTBL_ENTRY)&_ZN5S89C72v9Ev,
  (VTBL_ENTRY)&_ZN5S89C73v10Ev,
  (VTBL_ENTRY)&_ZN5S89C73v11Ev,
  (VTBL_ENTRY)&_ZN5S89C73v12Ev,
  (VTBL_ENTRY)&_ZN5S89C73v13Ev,
  (VTBL_ENTRY)&_ZN5S89C73v14Ev,
  (VTBL_ENTRY)&_ZN5S89C73v15Ev,
  (VTBL_ENTRY)&_ZN5S89C73v16Ev,
  (VTBL_ENTRY)&_ZN5S89C73v17Ev,
  (VTBL_ENTRY)&_ZN5S89C73v18Ev,
  (VTBL_ENTRY)&_ZN5S89C73v19Ev,
  (VTBL_ENTRY)&_ZN5S89C73v20Ev,
  (VTBL_ENTRY)&_ZN5S89C73v21Ev,
  (VTBL_ENTRY)&_ZN5S89C73v22Ev,
  (VTBL_ENTRY)&_ZN5S89C73v23Ev,
  (VTBL_ENTRY)&_ZN5S89C73v24Ev,
  (VTBL_ENTRY)&_ZN5S89C73v25Ev,
  (VTBL_ENTRY)&_ZN5S89C73v26Ev,
  (VTBL_ENTRY)&_ZN5S89C73v27Ev,
  (VTBL_ENTRY)&_ZN5S89C73v28Ev,
  (VTBL_ENTRY)&_ZN5S89C73v29Ev,
  (VTBL_ENTRY)&_ZN5S89C73v30Ev,
  (VTBL_ENTRY)&_ZN5S89C73v31Ev,
  (VTBL_ENTRY)&_ZN5S89C73v32Ev,
  (VTBL_ENTRY)&_ZN5S89C73v33Ev,
  (VTBL_ENTRY)&_ZN5S89C73v34Ev,
  (VTBL_ENTRY)&_ZN5S89C73v35Ev,
  (VTBL_ENTRY)&_ZN5S89C73v36Ev,
  (VTBL_ENTRY)&_ZN5S89C73v37Ev,
  (VTBL_ENTRY)&_ZN5S89C73v38Ev,
  (VTBL_ENTRY)&_ZN5S89C73v39Ev,
  (VTBL_ENTRY)&_ZN5S89C73v40Ev,
  (VTBL_ENTRY)&_ZN5S89C73v41Ev,
  (VTBL_ENTRY)&_ZN5S89C73v42Ev,
  (VTBL_ENTRY)&_ZN5S89C73v43Ev,
  (VTBL_ENTRY)&_ZN5S89C73v44Ev,
  (VTBL_ENTRY)&_ZN5S89C73v45Ev,
  (VTBL_ENTRY)&_ZN5S89C73v46Ev,
  (VTBL_ENTRY)&_ZN5S89C73v47Ev,
  (VTBL_ENTRY)&_ZN5S89C73v48Ev,
  (VTBL_ENTRY)&_ZN5S89C73v49Ev,
  (VTBL_ENTRY)&_ZN5S89C73v50Ev,
  (VTBL_ENTRY)&_ZN5S89C73v51Ev,
  (VTBL_ENTRY)&_ZN5S89C73v52Ev,
  (VTBL_ENTRY)&_ZN5S89C73v53Ev,
  (VTBL_ENTRY)&_ZN5S89C73v54Ev,
  (VTBL_ENTRY)&_ZN5S89C73v55Ev,
  (VTBL_ENTRY)&_ZN5S89C73v56Ev,
  (VTBL_ENTRY)&_ZN5S89C73v57Ev,
  (VTBL_ENTRY)&_ZN5S89C73v58Ev,
  (VTBL_ENTRY)&_ZN5S89C73v59Ev,
  (VTBL_ENTRY)&_ZN5S89C73v60Ev,
  (VTBL_ENTRY)&_ZN5S89C73v61Ev,
  (VTBL_ENTRY)&_ZN5S89C73v62Ev,
  (VTBL_ENTRY)&_ZN5S89C73v63Ev,
  (VTBL_ENTRY)&_ZN5S89C73v64Ev,
  (VTBL_ENTRY)&_ZN5S89C73v65Ev,
  (VTBL_ENTRY)&_ZN5S89C73v66Ev,
  (VTBL_ENTRY)&_ZN5S89C73v67Ev,
  (VTBL_ENTRY)&_ZN5S89C63v68Ev,
  (VTBL_ENTRY)&_ZN5S89C63v69Ev,
  (VTBL_ENTRY)&_ZN5S89C53v70Ev,
  (VTBL_ENTRY)&_ZN5S89C53v71Ev,
  (VTBL_ENTRY)&_ZN5S89C53v72Ev,
  (VTBL_ENTRY)&_ZN5S89C53v73Ev,
  (VTBL_ENTRY)&_ZN5S89C53v74Ev,
  (VTBL_ENTRY)&_ZN5S89C53v75Ev,
  (VTBL_ENTRY)&_ZN5S89C53v76Ev,
  (VTBL_ENTRY)&_ZN5S89C53v77Ev,
  (VTBL_ENTRY)&_ZN5S89C53v78Ev,
  (VTBL_ENTRY)&_ZN5S89C53v79Ev,
  (VTBL_ENTRY)&_ZN5S89C53v80Ev,
  (VTBL_ENTRY)&_ZN5S89C53v81Ev,
  (VTBL_ENTRY)&_ZN5S89C43v82Ev,
  (VTBL_ENTRY)&_ZN5S89C43v83Ev,
  (VTBL_ENTRY)&_ZN5S89C43v84Ev,
  (VTBL_ENTRY)&_ZN5S89C33v89Ev,
  (VTBL_ENTRY)&_ZN5S89C33v90Ev,
  (VTBL_ENTRY)&_ZN5S89C33v91Ev,
  (VTBL_ENTRY)&_ZN5S89C33v92Ev,
  (VTBL_ENTRY)&_ZN5S89C33v93Ev,
  (VTBL_ENTRY)&_ZN5S89C33v94Ev,
  (VTBL_ENTRY)&_ZN5S89C33v95Ev,
  (VTBL_ENTRY)&_ZN5S89C33v96Ev,
  (VTBL_ENTRY)&_ZN5S89C33v97Ev,
  (VTBL_ENTRY)&_ZN5S89C23v98Ev,
  (VTBL_ENTRY)&_ZN5S89C23v99Ev,
  (VTBL_ENTRY)&_ZN5S89C24v100Ev,
  (VTBL_ENTRY)&_ZN5S89C24v101Ev,
  (VTBL_ENTRY)&_ZN5S89C24v102Ev,
  (VTBL_ENTRY)&_ZN5S89C12v1Ev,
  (VTBL_ENTRY)&_ZN5S89C12v2Ev,
  (VTBL_ENTRY)&_ZN5S89C12v3Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S89C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C1D1Ev,_ZThn100_N5S89C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S89C1D0Ev,_ZThn100_N5S89C1D0Ev),
  (VTBL_ENTRY)&_ZN6S89C153v85Ev,
  (VTBL_ENTRY)&_ZN6S89C153v86Ev,
  (VTBL_ENTRY)&_ZN6S89C153v87Ev,
  (VTBL_ENTRY)&_ZN6S89C153v88Ev,
};
extern VTBL_ENTRY _ZTI5S89C1[];
extern  VTBL_ENTRY _ZTV5S89C1[];
Class_Descriptor cd_S89C1 = {  "S89C1", // class name
  bases_S89C1, 7,
  &(vtc_S89C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,260), // object size
  NSPAIRA(_ZTI5S89C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S89C1),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C7  {
  int s51c7f0;
  __tsi64 s51c7f1;
  void *s51c7f2[4];
  int s51c7f3[2];
  void *s51c7f4;
  ::S3422C4_nt s51c7f5;
  void *s51c7f6[2];
  virtual  ~S51C7(); // _ZN5S51C7D1Ev
  virtual void  v11(); // _ZN5S51C73v11Ev
  virtual void  v12(); // _ZN5S51C73v12Ev
  virtual void  v13(); // _ZN5S51C73v13Ev
  virtual void  v14(); // _ZN5S51C73v14Ev
  virtual void  v15(); // _ZN5S51C73v15Ev
  virtual void  v16(); // _ZN5S51C73v16Ev
  virtual void  v17(); // _ZN5S51C73v17Ev
  virtual void  v18(); // _ZN5S51C73v18Ev
  virtual void  v19(); // _ZN5S51C73v19Ev
  virtual void  v20(); // _ZN5S51C73v20Ev
  virtual void  v21(); // _ZN5S51C73v21Ev
  virtual void  v22(); // _ZN5S51C73v22Ev
  virtual void  v23(); // _ZN5S51C73v23Ev
  virtual void  v24(); // _ZN5S51C73v24Ev
  virtual void  v25(); // _ZN5S51C73v25Ev
  virtual void  v26(); // _ZN5S51C73v26Ev
  virtual void  v27(); // _ZN5S51C73v27Ev
  virtual void  v28(); // _ZN5S51C73v28Ev
  virtual void  v29(); // _ZN5S51C73v29Ev
  virtual void  v30(); // _ZN5S51C73v30Ev
  virtual void  v31(); // _ZN5S51C73v31Ev
  virtual void  v32(); // _ZN5S51C73v32Ev
  virtual void  v33(); // _ZN5S51C73v33Ev
  virtual void  v34(); // _ZN5S51C73v34Ev
  virtual void  v35(); // _ZN5S51C73v35Ev
  virtual void  v36(); // _ZN5S51C73v36Ev
  virtual void  v37(); // _ZN5S51C73v37Ev
  virtual void  v38(); // _ZN5S51C73v38Ev
  virtual void  v39(); // _ZN5S51C73v39Ev
  virtual void  v40(); // _ZN5S51C73v40Ev
  virtual void  v41(); // _ZN5S51C73v41Ev
  virtual void  v42(); // _ZN5S51C73v42Ev
  virtual void  v43(); // _ZN5S51C73v43Ev
  virtual void  v44(); // _ZN5S51C73v44Ev
  virtual void  v45(); // _ZN5S51C73v45Ev
  virtual void  v46(); // _ZN5S51C73v46Ev
  virtual void  v47(); // _ZN5S51C73v47Ev
  virtual void  v48(); // _ZN5S51C73v48Ev
  virtual void  v49(); // _ZN5S51C73v49Ev
  virtual void  v50(); // _ZN5S51C73v50Ev
  virtual void  v51(); // _ZN5S51C73v51Ev
  virtual void  v52(); // _ZN5S51C73v52Ev
  virtual void  v53(); // _ZN5S51C73v53Ev
  virtual void  v54(); // _ZN5S51C73v54Ev
  virtual void  v55(); // _ZN5S51C73v55Ev
  virtual void  v56(); // _ZN5S51C73v56Ev
  virtual void  v57(); // _ZN5S51C73v57Ev
  virtual void  v58(); // _ZN5S51C73v58Ev
  virtual void  v59(); // _ZN5S51C73v59Ev
  virtual void  v60(); // _ZN5S51C73v60Ev
  virtual void  v61(); // _ZN5S51C73v61Ev
  virtual void  v62(); // _ZN5S51C73v62Ev
  virtual void  v63(); // _ZN5S51C73v63Ev
  virtual void  v64(); // _ZN5S51C73v64Ev
  virtual void  v65(); // _ZN5S51C73v65Ev
  virtual void  v66(); // _ZN5S51C73v66Ev
  virtual void  v67(); // _ZN5S51C73v67Ev
  virtual void  v68(); // _ZN5S51C73v68Ev
  virtual void  v69(); // _ZN5S51C73v69Ev
  virtual void  v70(); // _ZN5S51C73v70Ev
  virtual void  v71(); // _ZN5S51C73v71Ev
  virtual void  v72(); // _ZN5S51C73v72Ev
  virtual void  v73(); // _ZN5S51C73v73Ev
  virtual void  v74(); // _ZN5S51C73v74Ev
  S51C7(); // tgen
};
//SIG(-1 S51C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S51C7 ::~S51C7(){ note_dtor("S51C7", this);}
void  S51C7 ::v11(){vfunc_called(this, "_ZN5S51C73v11Ev");}
void  S51C7 ::v12(){vfunc_called(this, "_ZN5S51C73v12Ev");}
void  S51C7 ::v13(){vfunc_called(this, "_ZN5S51C73v13Ev");}
void  S51C7 ::v14(){vfunc_called(this, "_ZN5S51C73v14Ev");}
void  S51C7 ::v15(){vfunc_called(this, "_ZN5S51C73v15Ev");}
void  S51C7 ::v16(){vfunc_called(this, "_ZN5S51C73v16Ev");}
void  S51C7 ::v17(){vfunc_called(this, "_ZN5S51C73v17Ev");}
void  S51C7 ::v18(){vfunc_called(this, "_ZN5S51C73v18Ev");}
void  S51C7 ::v19(){vfunc_called(this, "_ZN5S51C73v19Ev");}
void  S51C7 ::v20(){vfunc_called(this, "_ZN5S51C73v20Ev");}
void  S51C7 ::v21(){vfunc_called(this, "_ZN5S51C73v21Ev");}
void  S51C7 ::v22(){vfunc_called(this, "_ZN5S51C73v22Ev");}
void  S51C7 ::v23(){vfunc_called(this, "_ZN5S51C73v23Ev");}
void  S51C7 ::v24(){vfunc_called(this, "_ZN5S51C73v24Ev");}
void  S51C7 ::v25(){vfunc_called(this, "_ZN5S51C73v25Ev");}
void  S51C7 ::v26(){vfunc_called(this, "_ZN5S51C73v26Ev");}
void  S51C7 ::v27(){vfunc_called(this, "_ZN5S51C73v27Ev");}
void  S51C7 ::v28(){vfunc_called(this, "_ZN5S51C73v28Ev");}
void  S51C7 ::v29(){vfunc_called(this, "_ZN5S51C73v29Ev");}
void  S51C7 ::v30(){vfunc_called(this, "_ZN5S51C73v30Ev");}
void  S51C7 ::v31(){vfunc_called(this, "_ZN5S51C73v31Ev");}
void  S51C7 ::v32(){vfunc_called(this, "_ZN5S51C73v32Ev");}
void  S51C7 ::v33(){vfunc_called(this, "_ZN5S51C73v33Ev");}
void  S51C7 ::v34(){vfunc_called(this, "_ZN5S51C73v34Ev");}
void  S51C7 ::v35(){vfunc_called(this, "_ZN5S51C73v35Ev");}
void  S51C7 ::v36(){vfunc_called(this, "_ZN5S51C73v36Ev");}
void  S51C7 ::v37(){vfunc_called(this, "_ZN5S51C73v37Ev");}
void  S51C7 ::v38(){vfunc_called(this, "_ZN5S51C73v38Ev");}
void  S51C7 ::v39(){vfunc_called(this, "_ZN5S51C73v39Ev");}
void  S51C7 ::v40(){vfunc_called(this, "_ZN5S51C73v40Ev");}
void  S51C7 ::v41(){vfunc_called(this, "_ZN5S51C73v41Ev");}
void  S51C7 ::v42(){vfunc_called(this, "_ZN5S51C73v42Ev");}
void  S51C7 ::v43(){vfunc_called(this, "_ZN5S51C73v43Ev");}
void  S51C7 ::v44(){vfunc_called(this, "_ZN5S51C73v44Ev");}
void  S51C7 ::v45(){vfunc_called(this, "_ZN5S51C73v45Ev");}
void  S51C7 ::v46(){vfunc_called(this, "_ZN5S51C73v46Ev");}
void  S51C7 ::v47(){vfunc_called(this, "_ZN5S51C73v47Ev");}
void  S51C7 ::v48(){vfunc_called(this, "_ZN5S51C73v48Ev");}
void  S51C7 ::v49(){vfunc_called(this, "_ZN5S51C73v49Ev");}
void  S51C7 ::v50(){vfunc_called(this, "_ZN5S51C73v50Ev");}
void  S51C7 ::v51(){vfunc_called(this, "_ZN5S51C73v51Ev");}
void  S51C7 ::v52(){vfunc_called(this, "_ZN5S51C73v52Ev");}
void  S51C7 ::v53(){vfunc_called(this, "_ZN5S51C73v53Ev");}
void  S51C7 ::v54(){vfunc_called(this, "_ZN5S51C73v54Ev");}
void  S51C7 ::v55(){vfunc_called(this, "_ZN5S51C73v55Ev");}
void  S51C7 ::v56(){vfunc_called(this, "_ZN5S51C73v56Ev");}
void  S51C7 ::v57(){vfunc_called(this, "_ZN5S51C73v57Ev");}
void  S51C7 ::v58(){vfunc_called(this, "_ZN5S51C73v58Ev");}
void  S51C7 ::v59(){vfunc_called(this, "_ZN5S51C73v59Ev");}
void  S51C7 ::v60(){vfunc_called(this, "_ZN5S51C73v60Ev");}
void  S51C7 ::v61(){vfunc_called(this, "_ZN5S51C73v61Ev");}
void  S51C7 ::v62(){vfunc_called(this, "_ZN5S51C73v62Ev");}
void  S51C7 ::v63(){vfunc_called(this, "_ZN5S51C73v63Ev");}
void  S51C7 ::v64(){vfunc_called(this, "_ZN5S51C73v64Ev");}
void  S51C7 ::v65(){vfunc_called(this, "_ZN5S51C73v65Ev");}
void  S51C7 ::v66(){vfunc_called(this, "_ZN5S51C73v66Ev");}
void  S51C7 ::v67(){vfunc_called(this, "_ZN5S51C73v67Ev");}
void  S51C7 ::v68(){vfunc_called(this, "_ZN5S51C73v68Ev");}
void  S51C7 ::v69(){vfunc_called(this, "_ZN5S51C73v69Ev");}
void  S51C7 ::v70(){vfunc_called(this, "_ZN5S51C73v70Ev");}
void  S51C7 ::v71(){vfunc_called(this, "_ZN5S51C73v71Ev");}
void  S51C7 ::v72(){vfunc_called(this, "_ZN5S51C73v72Ev");}
void  S51C7 ::v73(){vfunc_called(this, "_ZN5S51C73v73Ev");}
void  S51C7 ::v74(){vfunc_called(this, "_ZN5S51C73v74Ev");}
S51C7 ::S51C7(){ note_ctor("S51C7", this);} // tgen

static void Test_S51C7()
{
  extern Class_Descriptor cd_S51C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S51C7, buf);
    S51C7 *dp, &lv = *(dp=new (buf) S51C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S51C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C7)");
    check_field_offset(lv, s51c7f0, ABISELECT(8,4), "S51C7.s51c7f0");
    check_field_offset(lv, s51c7f1, ABISELECT(16,8), "S51C7.s51c7f1");
    check_field_offset(lv, s51c7f2, ABISELECT(24,16), "S51C7.s51c7f2");
    check_field_offset(lv, s51c7f3, ABISELECT(56,32), "S51C7.s51c7f3");
    check_field_offset(lv, s51c7f4, ABISELECT(64,40), "S51C7.s51c7f4");
    check_field_offset(lv, s51c7f5, ABISELECT(72,44), "S51C7.s51c7f5");
    check_field_offset(lv, s51c7f6, ABISELECT(80,52), "S51C7.s51c7f6");
    test_class_info(&lv, &cd_S51C7);
    dp->~S51C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C7(Test_S51C7, "S51C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S51C7C1Ev();
extern void _ZN5S51C7D1Ev();
Name_Map name_map_S51C7[] = {
  NSPAIR(_ZN5S51C7C1Ev),
  NSPAIR(_ZN5S51C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S51C7[];
extern void _ZN5S51C7D1Ev();
extern void _ZN5S51C7D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
static  VTBL_ENTRY vtc_S51C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C7[0]),
  (VTBL_ENTRY)&_ZN5S51C7D1Ev,
  (VTBL_ENTRY)&_ZN5S51C7D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
};
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
Class_Descriptor cd_S51C7 = {  "S51C7", // class name
  0,0,//no base classes
  &(vtc_S51C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S51C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S51C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C6  : S51C7 {
  virtual  ~S51C6(); // _ZN5S51C6D1Ev
  virtual void  v75(); // _ZN5S51C63v75Ev
  virtual void  v76(); // _ZN5S51C63v76Ev
  S51C6(); // tgen
};
//SIG(-1 S51C6) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S51C6 ::~S51C6(){ note_dtor("S51C6", this);}
void  S51C6 ::v75(){vfunc_called(this, "_ZN5S51C63v75Ev");}
void  S51C6 ::v76(){vfunc_called(this, "_ZN5S51C63v76Ev");}
S51C6 ::S51C6(){ note_ctor("S51C6", this);} // tgen

static void Test_S51C6()
{
  extern Class_Descriptor cd_S51C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S51C6, buf);
    S51C6 *dp, &lv = *(dp=new (buf) S51C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S51C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C6)");
    check_base_class_offset(lv, (S51C7*), 0, "S51C6");
    test_class_info(&lv, &cd_S51C6);
    dp->~S51C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C6(Test_S51C6, "S51C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S51C6C1Ev();
extern void _ZN5S51C6D1Ev();
Name_Map name_map_S51C6[] = {
  NSPAIR(_ZN5S51C6C1Ev),
  NSPAIR(_ZN5S51C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S51C7;
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
static Base_Class bases_S51C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S51C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S51C6[];
extern void _ZN5S51C6D1Ev();
extern void _ZN5S51C6D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
extern void _ZN5S51C63v75Ev();
extern void _ZN5S51C63v76Ev();
static  VTBL_ENTRY vtc_S51C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C6[0]),
  (VTBL_ENTRY)&_ZN5S51C6D1Ev,
  (VTBL_ENTRY)&_ZN5S51C6D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
  (VTBL_ENTRY)&_ZN5S51C63v75Ev,
  (VTBL_ENTRY)&_ZN5S51C63v76Ev,
};
extern VTBL_ENTRY _ZTI5S51C6[];
extern  VTBL_ENTRY _ZTV5S51C6[];
Class_Descriptor cd_S51C6 = {  "S51C6", // class name
  bases_S51C6, 1,
  &(vtc_S51C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S51C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S51C6),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C5  : S51C6 {
  char s51c5f0;
  ::S3422C23 s51c5f1;
  ::S49C12_nt s51c5f2;
  virtual  ~S51C5(); // _ZN5S51C5D1Ev
  virtual void  v77(); // _ZN5S51C53v77Ev
  virtual void  v78(); // _ZN5S51C53v78Ev
  virtual void  v79(); // _ZN5S51C53v79Ev
  virtual void  v80(); // _ZN5S51C53v80Ev
  virtual void  v81(); // _ZN5S51C53v81Ev
  virtual void  v82(); // _ZN5S51C53v82Ev
  virtual void  v83(); // _ZN5S51C53v83Ev
  virtual void  v84(); // _ZN5S51C53v84Ev
  virtual void  v85(); // _ZN5S51C53v85Ev
  virtual void  v86(); // _ZN5S51C53v86Ev
  virtual void  v87(); // _ZN5S51C53v87Ev
  virtual void  v88(); // _ZN5S51C53v88Ev
  S51C5(); // tgen
};
//SIG(-1 S51C5) C1{ BC2{ BC3{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v77 v78} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fc FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC8{ m Fp FC4}}


 S51C5 ::~S51C5(){ note_dtor("S51C5", this);}
void  S51C5 ::v77(){vfunc_called(this, "_ZN5S51C53v77Ev");}
void  S51C5 ::v78(){vfunc_called(this, "_ZN5S51C53v78Ev");}
void  S51C5 ::v79(){vfunc_called(this, "_ZN5S51C53v79Ev");}
void  S51C5 ::v80(){vfunc_called(this, "_ZN5S51C53v80Ev");}
void  S51C5 ::v81(){vfunc_called(this, "_ZN5S51C53v81Ev");}
void  S51C5 ::v82(){vfunc_called(this, "_ZN5S51C53v82Ev");}
void  S51C5 ::v83(){vfunc_called(this, "_ZN5S51C53v83Ev");}
void  S51C5 ::v84(){vfunc_called(this, "_ZN5S51C53v84Ev");}
void  S51C5 ::v85(){vfunc_called(this, "_ZN5S51C53v85Ev");}
void  S51C5 ::v86(){vfunc_called(this, "_ZN5S51C53v86Ev");}
void  S51C5 ::v87(){vfunc_called(this, "_ZN5S51C53v87Ev");}
void  S51C5 ::v88(){vfunc_called(this, "_ZN5S51C53v88Ev");}
S51C5 ::S51C5(){ note_ctor("S51C5", this);} // tgen

static void Test_S51C5()
{
  extern Class_Descriptor cd_S51C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,23)];
    init_test(&cd_S51C5, buf);
    S51C5 *dp, &lv = *(dp=new (buf) S51C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,88), "sizeof(S51C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C5)");
    check_base_class_offset(lv, (S51C7*)(S51C6*), 0, "S51C5");
    check_base_class_offset(lv, (S51C6*), 0, "S51C5");
    check_field_offset(lv, s51c5f0, ABISELECT(96,60), "S51C5.s51c5f0");
    check_field_offset(lv, s51c5f1, ABISELECT(104,64), "S51C5.s51c5f1");
    check_field_offset(lv, s51c5f2, ABISELECT(120,76), "S51C5.s51c5f2");
    test_class_info(&lv, &cd_S51C5);
    dp->~S51C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C5(Test_S51C5, "S51C5", ABISELECT(136,88));

#else // __cplusplus

extern void _ZN5S51C5C1Ev();
extern void _ZN5S51C5D1Ev();
Name_Map name_map_S51C5[] = {
  NSPAIR(_ZN5S51C5C1Ev),
  NSPAIR(_ZN5S51C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S51C7;
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
extern Class_Descriptor cd_S51C6;
extern VTBL_ENTRY _ZTI5S51C6[];
extern  VTBL_ENTRY _ZTV5S51C6[];
static Base_Class bases_S51C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S51C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S51C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S51C5[];
extern void _ZN5S51C5D1Ev();
extern void _ZN5S51C5D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
extern void _ZN5S51C63v75Ev();
extern void _ZN5S51C63v76Ev();
extern void _ZN5S51C53v77Ev();
extern void _ZN5S51C53v78Ev();
extern void _ZN5S51C53v79Ev();
extern void _ZN5S51C53v80Ev();
extern void _ZN5S51C53v81Ev();
extern void _ZN5S51C53v82Ev();
extern void _ZN5S51C53v83Ev();
extern void _ZN5S51C53v84Ev();
extern void _ZN5S51C53v85Ev();
extern void _ZN5S51C53v86Ev();
extern void _ZN5S51C53v87Ev();
extern void _ZN5S51C53v88Ev();
static  VTBL_ENTRY vtc_S51C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C5[0]),
  (VTBL_ENTRY)&_ZN5S51C5D1Ev,
  (VTBL_ENTRY)&_ZN5S51C5D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
  (VTBL_ENTRY)&_ZN5S51C63v75Ev,
  (VTBL_ENTRY)&_ZN5S51C63v76Ev,
  (VTBL_ENTRY)&_ZN5S51C53v77Ev,
  (VTBL_ENTRY)&_ZN5S51C53v78Ev,
  (VTBL_ENTRY)&_ZN5S51C53v79Ev,
  (VTBL_ENTRY)&_ZN5S51C53v80Ev,
  (VTBL_ENTRY)&_ZN5S51C53v81Ev,
  (VTBL_ENTRY)&_ZN5S51C53v82Ev,
  (VTBL_ENTRY)&_ZN5S51C53v83Ev,
  (VTBL_ENTRY)&_ZN5S51C53v84Ev,
  (VTBL_ENTRY)&_ZN5S51C53v85Ev,
  (VTBL_ENTRY)&_ZN5S51C53v86Ev,
  (VTBL_ENTRY)&_ZN5S51C53v87Ev,
  (VTBL_ENTRY)&_ZN5S51C53v88Ev,
};
extern VTBL_ENTRY _ZTI5S51C5[];
extern  VTBL_ENTRY _ZTV5S51C5[];
Class_Descriptor cd_S51C5 = {  "S51C5", // class name
  bases_S51C5, 2,
  &(vtc_S51C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,88), // object size
  NSPAIRA(_ZTI5S51C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S51C5),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C4  : S51C5 {
  ::S3422C17 s51c4f0;
  virtual  ~S51C4(); // _ZN5S51C4D1Ev
  virtual void  v89(); // _ZN5S51C43v89Ev
  virtual void  v90(); // _ZN5S51C43v90Ev
  virtual void  v91(); // _ZN5S51C43v91Ev
  S51C4(); // tgen
};
//SIG(-1 S51C4) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fc FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ m Fp FC5}} vd v1 v2 v3 FC10{ BC11{ BC8}}}


 S51C4 ::~S51C4(){ note_dtor("S51C4", this);}
void  S51C4 ::v89(){vfunc_called(this, "_ZN5S51C43v89Ev");}
void  S51C4 ::v90(){vfunc_called(this, "_ZN5S51C43v90Ev");}
void  S51C4 ::v91(){vfunc_called(this, "_ZN5S51C43v91Ev");}
S51C4 ::S51C4(){ note_ctor("S51C4", this);} // tgen

static void Test_S51C4()
{
  extern Class_Descriptor cd_S51C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,26)];
    init_test(&cd_S51C4, buf);
    S51C4 *dp, &lv = *(dp=new (buf) S51C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,100), "sizeof(S51C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C4)");
    check_base_class_offset(lv, (S51C7*)(S51C6*)(S51C5*), 0, "S51C4");
    check_base_class_offset(lv, (S51C6*)(S51C5*), 0, "S51C4");
    check_base_class_offset(lv, (S51C5*), 0, "S51C4");
    check_field_offset(lv, s51c4f0, ABISELECT(136,88), "S51C4.s51c4f0");
    test_class_info(&lv, &cd_S51C4);
    dp->~S51C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C4(Test_S51C4, "S51C4", ABISELECT(152,100));

#else // __cplusplus

extern void _ZN5S51C4C1Ev();
extern void _ZN5S51C4D1Ev();
Name_Map name_map_S51C4[] = {
  NSPAIR(_ZN5S51C4C1Ev),
  NSPAIR(_ZN5S51C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S51C7;
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
extern Class_Descriptor cd_S51C6;
extern VTBL_ENTRY _ZTI5S51C6[];
extern  VTBL_ENTRY _ZTV5S51C6[];
extern Class_Descriptor cd_S51C5;
extern VTBL_ENTRY _ZTI5S51C5[];
extern  VTBL_ENTRY _ZTV5S51C5[];
static Base_Class bases_S51C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S51C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S51C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S51C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S51C4[];
extern void _ZN5S51C4D1Ev();
extern void _ZN5S51C4D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
extern void _ZN5S51C63v75Ev();
extern void _ZN5S51C63v76Ev();
extern void _ZN5S51C53v77Ev();
extern void _ZN5S51C53v78Ev();
extern void _ZN5S51C53v79Ev();
extern void _ZN5S51C53v80Ev();
extern void _ZN5S51C53v81Ev();
extern void _ZN5S51C53v82Ev();
extern void _ZN5S51C53v83Ev();
extern void _ZN5S51C53v84Ev();
extern void _ZN5S51C53v85Ev();
extern void _ZN5S51C53v86Ev();
extern void _ZN5S51C53v87Ev();
extern void _ZN5S51C53v88Ev();
extern void _ZN5S51C43v89Ev();
extern void _ZN5S51C43v90Ev();
extern void _ZN5S51C43v91Ev();
static  VTBL_ENTRY vtc_S51C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C4[0]),
  (VTBL_ENTRY)&_ZN5S51C4D1Ev,
  (VTBL_ENTRY)&_ZN5S51C4D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
  (VTBL_ENTRY)&_ZN5S51C63v75Ev,
  (VTBL_ENTRY)&_ZN5S51C63v76Ev,
  (VTBL_ENTRY)&_ZN5S51C53v77Ev,
  (VTBL_ENTRY)&_ZN5S51C53v78Ev,
  (VTBL_ENTRY)&_ZN5S51C53v79Ev,
  (VTBL_ENTRY)&_ZN5S51C53v80Ev,
  (VTBL_ENTRY)&_ZN5S51C53v81Ev,
  (VTBL_ENTRY)&_ZN5S51C53v82Ev,
  (VTBL_ENTRY)&_ZN5S51C53v83Ev,
  (VTBL_ENTRY)&_ZN5S51C53v84Ev,
  (VTBL_ENTRY)&_ZN5S51C53v85Ev,
  (VTBL_ENTRY)&_ZN5S51C53v86Ev,
  (VTBL_ENTRY)&_ZN5S51C53v87Ev,
  (VTBL_ENTRY)&_ZN5S51C53v88Ev,
  (VTBL_ENTRY)&_ZN5S51C43v89Ev,
  (VTBL_ENTRY)&_ZN5S51C43v90Ev,
  (VTBL_ENTRY)&_ZN5S51C43v91Ev,
};
extern VTBL_ENTRY _ZTI5S51C4[];
extern  VTBL_ENTRY _ZTV5S51C4[];
Class_Descriptor cd_S51C4 = {  "S51C4", // class name
  bases_S51C4, 3,
  &(vtc_S51C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,100), // object size
  NSPAIRA(_ZTI5S51C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S51C4),85, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C15  {
  virtual  ~S51C15(); // _ZN6S51C15D1Ev
  virtual void  v92(); // _ZN6S51C153v92Ev
  virtual void  v93(); // _ZN6S51C153v93Ev
  virtual void  v94(); // _ZN6S51C153v94Ev
  virtual void  v95(); // _ZN6S51C153v95Ev
  S51C15(); // tgen
};
//SIG(-1 S51C15) C1{ vd v1 v2 v3 v4}


 S51C15 ::~S51C15(){ note_dtor("S51C15", this);}
void  S51C15 ::v92(){vfunc_called(this, "_ZN6S51C153v92Ev");}
void  S51C15 ::v93(){vfunc_called(this, "_ZN6S51C153v93Ev");}
void  S51C15 ::v94(){vfunc_called(this, "_ZN6S51C153v94Ev");}
void  S51C15 ::v95(){vfunc_called(this, "_ZN6S51C153v95Ev");}
S51C15 ::S51C15(){ note_ctor("S51C15", this);} // tgen

static void Test_S51C15()
{
  extern Class_Descriptor cd_S51C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S51C15, buf);
    S51C15 *dp, &lv = *(dp=new (buf) S51C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S51C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C15)");
    test_class_info(&lv, &cd_S51C15);
    dp->~S51C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C15(Test_S51C15, "S51C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S51C15C1Ev();
extern void _ZN6S51C15D1Ev();
Name_Map name_map_S51C15[] = {
  NSPAIR(_ZN6S51C15C1Ev),
  NSPAIR(_ZN6S51C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S51C15[];
extern void _ZN6S51C15D1Ev();
extern void _ZN6S51C15D0Ev();
extern void _ZN6S51C153v92Ev();
extern void _ZN6S51C153v93Ev();
extern void _ZN6S51C153v94Ev();
extern void _ZN6S51C153v95Ev();
static  VTBL_ENTRY vtc_S51C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S51C15[0]),
  (VTBL_ENTRY)&_ZN6S51C15D1Ev,
  (VTBL_ENTRY)&_ZN6S51C15D0Ev,
  (VTBL_ENTRY)&_ZN6S51C153v92Ev,
  (VTBL_ENTRY)&_ZN6S51C153v93Ev,
  (VTBL_ENTRY)&_ZN6S51C153v94Ev,
  (VTBL_ENTRY)&_ZN6S51C153v95Ev,
};
extern VTBL_ENTRY _ZTI6S51C15[];
extern  VTBL_ENTRY _ZTV6S51C15[];
Class_Descriptor cd_S51C15 = {  "S51C15", // class name
  0,0,//no base classes
  &(vtc_S51C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S51C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S51C15),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C3  : S51C4 , S51C15 {
  virtual  ~S51C3(); // _ZN5S51C3D1Ev
  virtual void  v96(); // _ZN5S51C33v96Ev
  virtual void  v97(); // _ZN5S51C33v97Ev
  virtual void  v98(); // _ZN5S51C33v98Ev
  virtual void  v99(); // _ZN5S51C33v99Ev
  virtual void  v100(); // _ZN5S51C34v100Ev
  virtual void  v101(); // _ZN5S51C34v101Ev
  virtual void  v102(); // _ZN5S51C34v102Ev
  virtual void  v103(); // _ZN5S51C34v103Ev
  virtual void  v104(); // _ZN5S51C34v104Ev
  S51C3(); // tgen
};
//SIG(-1 S51C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fc FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ m Fp FC6}} vd v88 v89 v90 FC11{ BC12{ BC9}}} BC13{ vd v91 v92 v93 v94} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S51C3 ::~S51C3(){ note_dtor("S51C3", this);}
void  S51C3 ::v96(){vfunc_called(this, "_ZN5S51C33v96Ev");}
void  S51C3 ::v97(){vfunc_called(this, "_ZN5S51C33v97Ev");}
void  S51C3 ::v98(){vfunc_called(this, "_ZN5S51C33v98Ev");}
void  S51C3 ::v99(){vfunc_called(this, "_ZN5S51C33v99Ev");}
void  S51C3 ::v100(){vfunc_called(this, "_ZN5S51C34v100Ev");}
void  S51C3 ::v101(){vfunc_called(this, "_ZN5S51C34v101Ev");}
void  S51C3 ::v102(){vfunc_called(this, "_ZN5S51C34v102Ev");}
void  S51C3 ::v103(){vfunc_called(this, "_ZN5S51C34v103Ev");}
void  S51C3 ::v104(){vfunc_called(this, "_ZN5S51C34v104Ev");}
S51C3 ::S51C3(){ note_ctor("S51C3", this);} // tgen

static void Test_S51C3()
{
  extern Class_Descriptor cd_S51C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,27)];
    init_test(&cd_S51C3, buf);
    S51C3 *dp, &lv = *(dp=new (buf) S51C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,104), "sizeof(S51C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C3)");
    check_base_class_offset(lv, (S51C7*)(S51C6*)(S51C5*)(S51C4*), 0, "S51C3");
    check_base_class_offset(lv, (S51C6*)(S51C5*)(S51C4*), 0, "S51C3");
    check_base_class_offset(lv, (S51C5*)(S51C4*), 0, "S51C3");
    check_base_class_offset(lv, (S51C4*), 0, "S51C3");
    check_base_class_offset(lv, (S51C15*), ABISELECT(152,100), "S51C3");
    test_class_info(&lv, &cd_S51C3);
    dp->~S51C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C3(Test_S51C3, "S51C3", ABISELECT(160,104));

#else // __cplusplus

extern void _ZN5S51C3C1Ev();
extern void _ZN5S51C3D1Ev();
Name_Map name_map_S51C3[] = {
  NSPAIR(_ZN5S51C3C1Ev),
  NSPAIR(_ZN5S51C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S51C7;
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
extern Class_Descriptor cd_S51C6;
extern VTBL_ENTRY _ZTI5S51C6[];
extern  VTBL_ENTRY _ZTV5S51C6[];
extern Class_Descriptor cd_S51C5;
extern VTBL_ENTRY _ZTI5S51C5[];
extern  VTBL_ENTRY _ZTV5S51C5[];
extern Class_Descriptor cd_S51C4;
extern VTBL_ENTRY _ZTI5S51C4[];
extern  VTBL_ENTRY _ZTV5S51C4[];
extern Class_Descriptor cd_S51C15;
extern VTBL_ENTRY _ZTI6S51C15[];
extern  VTBL_ENTRY _ZTV6S51C15[];
static Base_Class bases_S51C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S51C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S51C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S51C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S51C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S51C15,    ABISELECT(152,100), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S51C3[];
extern void _ZN5S51C3D1Ev();
extern void _ZN5S51C3D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
extern void _ZN5S51C63v75Ev();
extern void _ZN5S51C63v76Ev();
extern void _ZN5S51C53v77Ev();
extern void _ZN5S51C53v78Ev();
extern void _ZN5S51C53v79Ev();
extern void _ZN5S51C53v80Ev();
extern void _ZN5S51C53v81Ev();
extern void _ZN5S51C53v82Ev();
extern void _ZN5S51C53v83Ev();
extern void _ZN5S51C53v84Ev();
extern void _ZN5S51C53v85Ev();
extern void _ZN5S51C53v86Ev();
extern void _ZN5S51C53v87Ev();
extern void _ZN5S51C53v88Ev();
extern void _ZN5S51C43v89Ev();
extern void _ZN5S51C43v90Ev();
extern void _ZN5S51C43v91Ev();
extern void _ZN5S51C33v96Ev();
extern void _ZN5S51C33v97Ev();
extern void _ZN5S51C33v98Ev();
extern void _ZN5S51C33v99Ev();
extern void _ZN5S51C34v100Ev();
extern void _ZN5S51C34v101Ev();
extern void _ZN5S51C34v102Ev();
extern void _ZN5S51C34v103Ev();
extern void _ZN5S51C34v104Ev();
extern void ABISELECT(_ZThn152_N5S51C3D1Ev,_ZThn100_N5S51C3D1Ev)();
extern void ABISELECT(_ZThn152_N5S51C3D0Ev,_ZThn100_N5S51C3D0Ev)();
extern void _ZN6S51C153v92Ev();
extern void _ZN6S51C153v93Ev();
extern void _ZN6S51C153v94Ev();
extern void _ZN6S51C153v95Ev();
static  VTBL_ENTRY vtc_S51C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C3[0]),
  (VTBL_ENTRY)&_ZN5S51C3D1Ev,
  (VTBL_ENTRY)&_ZN5S51C3D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
  (VTBL_ENTRY)&_ZN5S51C63v75Ev,
  (VTBL_ENTRY)&_ZN5S51C63v76Ev,
  (VTBL_ENTRY)&_ZN5S51C53v77Ev,
  (VTBL_ENTRY)&_ZN5S51C53v78Ev,
  (VTBL_ENTRY)&_ZN5S51C53v79Ev,
  (VTBL_ENTRY)&_ZN5S51C53v80Ev,
  (VTBL_ENTRY)&_ZN5S51C53v81Ev,
  (VTBL_ENTRY)&_ZN5S51C53v82Ev,
  (VTBL_ENTRY)&_ZN5S51C53v83Ev,
  (VTBL_ENTRY)&_ZN5S51C53v84Ev,
  (VTBL_ENTRY)&_ZN5S51C53v85Ev,
  (VTBL_ENTRY)&_ZN5S51C53v86Ev,
  (VTBL_ENTRY)&_ZN5S51C53v87Ev,
  (VTBL_ENTRY)&_ZN5S51C53v88Ev,
  (VTBL_ENTRY)&_ZN5S51C43v89Ev,
  (VTBL_ENTRY)&_ZN5S51C43v90Ev,
  (VTBL_ENTRY)&_ZN5S51C43v91Ev,
  (VTBL_ENTRY)&_ZN5S51C33v96Ev,
  (VTBL_ENTRY)&_ZN5S51C33v97Ev,
  (VTBL_ENTRY)&_ZN5S51C33v98Ev,
  (VTBL_ENTRY)&_ZN5S51C33v99Ev,
  (VTBL_ENTRY)&_ZN5S51C34v100Ev,
  (VTBL_ENTRY)&_ZN5S51C34v101Ev,
  (VTBL_ENTRY)&_ZN5S51C34v102Ev,
  (VTBL_ENTRY)&_ZN5S51C34v103Ev,
  (VTBL_ENTRY)&_ZN5S51C34v104Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S51C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S51C3D1Ev,_ZThn100_N5S51C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S51C3D0Ev,_ZThn100_N5S51C3D0Ev),
  (VTBL_ENTRY)&_ZN6S51C153v92Ev,
  (VTBL_ENTRY)&_ZN6S51C153v93Ev,
  (VTBL_ENTRY)&_ZN6S51C153v94Ev,
  (VTBL_ENTRY)&_ZN6S51C153v95Ev,
};
extern VTBL_ENTRY _ZTI5S51C3[];
extern  VTBL_ENTRY _ZTV5S51C3[];
Class_Descriptor cd_S51C3 = {  "S51C3", // class name
  bases_S51C3, 5,
  &(vtc_S51C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,104), // object size
  NSPAIRA(_ZTI5S51C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV5S51C3),102, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C2  : S51C3 {
  unsigned int s51c2f0:1;
  unsigned int s51c2f1:1;
  unsigned int s51c2f2:1;
  unsigned int s51c2f3:1;
  ::S3422C22_nt s51c2f4;
  virtual  ~S51C2(); // _ZN5S51C2D1Ev
  virtual void  v105(); // _ZN5S51C24v105Ev
  virtual void  v106(); // _ZN5S51C24v106Ev
  virtual void  v107(); // _ZN5S51C24v107Ev
  virtual void  v108(); // _ZN5S51C24v108Ev
  virtual void  v109(); // _ZN5S51C24v109Ev
  S51C2(); // tgen
};
//SIG(-1 S51C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fc FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC11{ m Fp FC7}} vd v84 v85 v86 FC12{ BC13{ BC10}}} BC14{ vd v87 v88 v89 v90} vd v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC8}}


 S51C2 ::~S51C2(){ note_dtor("S51C2", this);}
void  S51C2 ::v105(){vfunc_called(this, "_ZN5S51C24v105Ev");}
void  S51C2 ::v106(){vfunc_called(this, "_ZN5S51C24v106Ev");}
void  S51C2 ::v107(){vfunc_called(this, "_ZN5S51C24v107Ev");}
void  S51C2 ::v108(){vfunc_called(this, "_ZN5S51C24v108Ev");}
void  S51C2 ::v109(){vfunc_called(this, "_ZN5S51C24v109Ev");}
S51C2 ::S51C2(){ note_ctor("S51C2", this);} // tgen

static void Test_S51C2()
{
  extern Class_Descriptor cd_S51C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,31)];
    init_test(&cd_S51C2, buf);
    S51C2 *dp, &lv = *(dp=new (buf) S51C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,120), "sizeof(S51C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C2)");
    check_base_class_offset(lv, (S51C7*)(S51C6*)(S51C5*)(S51C4*)(S51C3*), 0, "S51C2");
    check_base_class_offset(lv, (S51C6*)(S51C5*)(S51C4*)(S51C3*), 0, "S51C2");
    check_base_class_offset(lv, (S51C5*)(S51C4*)(S51C3*), 0, "S51C2");
    check_base_class_offset(lv, (S51C4*)(S51C3*), 0, "S51C2");
    check_base_class_offset(lv, (S51C15*)(S51C3*), ABISELECT(152,100), "S51C2");
    check_base_class_offset(lv, (S51C3*), 0, "S51C2");
    set_bf_and_test(lv, s51c2f0, ABISELECT(160,104), 0, 1, 1, "S51C2");
    set_bf_and_test(lv, s51c2f1, ABISELECT(160,104), 1, 1, 1, "S51C2");
    set_bf_and_test(lv, s51c2f2, ABISELECT(160,104), 2, 1, 1, "S51C2");
    set_bf_and_test(lv, s51c2f3, ABISELECT(160,104), 3, 1, 1, "S51C2");
    check_field_offset(lv, s51c2f4, ABISELECT(168,108), "S51C2.s51c2f4");
    test_class_info(&lv, &cd_S51C2);
    dp->~S51C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS51C2(Test_S51C2, "S51C2", ABISELECT(184,120));

#else // __cplusplus

extern void _ZN5S51C2C1Ev();
extern void _ZN5S51C2D1Ev();
Name_Map name_map_S51C2[] = {
  NSPAIR(_ZN5S51C2C1Ev),
  NSPAIR(_ZN5S51C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S51C7;
extern VTBL_ENTRY _ZTI5S51C7[];
extern  VTBL_ENTRY _ZTV5S51C7[];
extern Class_Descriptor cd_S51C6;
extern VTBL_ENTRY _ZTI5S51C6[];
extern  VTBL_ENTRY _ZTV5S51C6[];
extern Class_Descriptor cd_S51C5;
extern VTBL_ENTRY _ZTI5S51C5[];
extern  VTBL_ENTRY _ZTV5S51C5[];
extern Class_Descriptor cd_S51C4;
extern VTBL_ENTRY _ZTI5S51C4[];
extern  VTBL_ENTRY _ZTV5S51C4[];
extern Class_Descriptor cd_S51C15;
extern VTBL_ENTRY _ZTI6S51C15[];
extern  VTBL_ENTRY _ZTV6S51C15[];
extern Class_Descriptor cd_S51C3;
extern VTBL_ENTRY _ZTI5S51C3[];
extern  VTBL_ENTRY _ZTV5S51C3[];
static Base_Class bases_S51C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S51C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S51C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S51C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S51C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S51C15,    ABISELECT(152,100), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S51C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S51C2[];
extern void _ZN5S51C2D1Ev();
extern void _ZN5S51C2D0Ev();
extern void _ZN5S51C73v11Ev();
extern void _ZN5S51C73v12Ev();
extern void _ZN5S51C73v13Ev();
extern void _ZN5S51C73v14Ev();
extern void _ZN5S51C73v15Ev();
extern void _ZN5S51C73v16Ev();
extern void _ZN5S51C73v17Ev();
extern void _ZN5S51C73v18Ev();
extern void _ZN5S51C73v19Ev();
extern void _ZN5S51C73v20Ev();
extern void _ZN5S51C73v21Ev();
extern void _ZN5S51C73v22Ev();
extern void _ZN5S51C73v23Ev();
extern void _ZN5S51C73v24Ev();
extern void _ZN5S51C73v25Ev();
extern void _ZN5S51C73v26Ev();
extern void _ZN5S51C73v27Ev();
extern void _ZN5S51C73v28Ev();
extern void _ZN5S51C73v29Ev();
extern void _ZN5S51C73v30Ev();
extern void _ZN5S51C73v31Ev();
extern void _ZN5S51C73v32Ev();
extern void _ZN5S51C73v33Ev();
extern void _ZN5S51C73v34Ev();
extern void _ZN5S51C73v35Ev();
extern void _ZN5S51C73v36Ev();
extern void _ZN5S51C73v37Ev();
extern void _ZN5S51C73v38Ev();
extern void _ZN5S51C73v39Ev();
extern void _ZN5S51C73v40Ev();
extern void _ZN5S51C73v41Ev();
extern void _ZN5S51C73v42Ev();
extern void _ZN5S51C73v43Ev();
extern void _ZN5S51C73v44Ev();
extern void _ZN5S51C73v45Ev();
extern void _ZN5S51C73v46Ev();
extern void _ZN5S51C73v47Ev();
extern void _ZN5S51C73v48Ev();
extern void _ZN5S51C73v49Ev();
extern void _ZN5S51C73v50Ev();
extern void _ZN5S51C73v51Ev();
extern void _ZN5S51C73v52Ev();
extern void _ZN5S51C73v53Ev();
extern void _ZN5S51C73v54Ev();
extern void _ZN5S51C73v55Ev();
extern void _ZN5S51C73v56Ev();
extern void _ZN5S51C73v57Ev();
extern void _ZN5S51C73v58Ev();
extern void _ZN5S51C73v59Ev();
extern void _ZN5S51C73v60Ev();
extern void _ZN5S51C73v61Ev();
extern void _ZN5S51C73v62Ev();
extern void _ZN5S51C73v63Ev();
extern void _ZN5S51C73v64Ev();
extern void _ZN5S51C73v65Ev();
extern void _ZN5S51C73v66Ev();
extern void _ZN5S51C73v67Ev();
extern void _ZN5S51C73v68Ev();
extern void _ZN5S51C73v69Ev();
extern void _ZN5S51C73v70Ev();
extern void _ZN5S51C73v71Ev();
extern void _ZN5S51C73v72Ev();
extern void _ZN5S51C73v73Ev();
extern void _ZN5S51C73v74Ev();
extern void _ZN5S51C63v75Ev();
extern void _ZN5S51C63v76Ev();
extern void _ZN5S51C53v77Ev();
extern void _ZN5S51C53v78Ev();
extern void _ZN5S51C53v79Ev();
extern void _ZN5S51C53v80Ev();
extern void _ZN5S51C53v81Ev();
extern void _ZN5S51C53v82Ev();
extern void _ZN5S51C53v83Ev();
extern void _ZN5S51C53v84Ev();
extern void _ZN5S51C53v85Ev();
extern void _ZN5S51C53v86Ev();
extern void _ZN5S51C53v87Ev();
extern void _ZN5S51C53v88Ev();
extern void _ZN5S51C43v89Ev();
extern void _ZN5S51C43v90Ev();
extern void _ZN5S51C43v91Ev();
extern void _ZN5S51C33v96Ev();
extern void _ZN5S51C33v97Ev();
extern void _ZN5S51C33v98Ev();
extern void _ZN5S51C33v99Ev();
extern void _ZN5S51C34v100Ev();
extern void _ZN5S51C34v101Ev();
extern void _ZN5S51C34v102Ev();
extern void _ZN5S51C34v103Ev();
extern void _ZN5S51C34v104Ev();
extern void _ZN5S51C24v105Ev();
extern void _ZN5S51C24v106Ev();
extern void _ZN5S51C24v107Ev();
extern void _ZN5S51C24v108Ev();
extern void _ZN5S51C24v109Ev();
extern void ABISELECT(_ZThn152_N5S51C2D1Ev,_ZThn100_N5S51C2D1Ev)();
extern void ABISELECT(_ZThn152_N5S51C2D0Ev,_ZThn100_N5S51C2D0Ev)();
extern void _ZN6S51C153v92Ev();
extern void _ZN6S51C153v93Ev();
extern void _ZN6S51C153v94Ev();
extern void _ZN6S51C153v95Ev();
static  VTBL_ENTRY vtc_S51C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S51C2[0]),
  (VTBL_ENTRY)&_ZN5S51C2D1Ev,
  (VTBL_ENTRY)&_ZN5S51C2D0Ev,
  (VTBL_ENTRY)&_ZN5S51C73v11Ev,
  (VTBL_ENTRY)&_ZN5S51C73v12Ev,
  (VTBL_ENTRY)&_ZN5S51C73v13Ev,
  (VTBL_ENTRY)&_ZN5S51C73v14Ev,
  (VTBL_ENTRY)&_ZN5S51C73v15Ev,
  (VTBL_ENTRY)&_ZN5S51C73v16Ev,
  (VTBL_ENTRY)&_ZN5S51C73v17Ev,
  (VTBL_ENTRY)&_ZN5S51C73v18Ev,
  (VTBL_ENTRY)&_ZN5S51C73v19Ev,
  (VTBL_ENTRY)&_ZN5S51C73v20Ev,
  (VTBL_ENTRY)&_ZN5S51C73v21Ev,
  (VTBL_ENTRY)&_ZN5S51C73v22Ev,
  (VTBL_ENTRY)&_ZN5S51C73v23Ev,
  (VTBL_ENTRY)&_ZN5S51C73v24Ev,
  (VTBL_ENTRY)&_ZN5S51C73v25Ev,
  (VTBL_ENTRY)&_ZN5S51C73v26Ev,
  (VTBL_ENTRY)&_ZN5S51C73v27Ev,
  (VTBL_ENTRY)&_ZN5S51C73v28Ev,
  (VTBL_ENTRY)&_ZN5S51C73v29Ev,
  (VTBL_ENTRY)&_ZN5S51C73v30Ev,
  (VTBL_ENTRY)&_ZN5S51C73v31Ev,
  (VTBL_ENTRY)&_ZN5S51C73v32Ev,
  (VTBL_ENTRY)&_ZN5S51C73v33Ev,
  (VTBL_ENTRY)&_ZN5S51C73v34Ev,
  (VTBL_ENTRY)&_ZN5S51C73v35Ev,
  (VTBL_ENTRY)&_ZN5S51C73v36Ev,
  (VTBL_ENTRY)&_ZN5S51C73v37Ev,
  (VTBL_ENTRY)&_ZN5S51C73v38Ev,
  (VTBL_ENTRY)&_ZN5S51C73v39Ev,
  (VTBL_ENTRY)&_ZN5S51C73v40Ev,
  (VTBL_ENTRY)&_ZN5S51C73v41Ev,
  (VTBL_ENTRY)&_ZN5S51C73v42Ev,
  (VTBL_ENTRY)&_ZN5S51C73v43Ev,
  (VTBL_ENTRY)&_ZN5S51C73v44Ev,
  (VTBL_ENTRY)&_ZN5S51C73v45Ev,
  (VTBL_ENTRY)&_ZN5S51C73v46Ev,
  (VTBL_ENTRY)&_ZN5S51C73v47Ev,
  (VTBL_ENTRY)&_ZN5S51C73v48Ev,
  (VTBL_ENTRY)&_ZN5S51C73v49Ev,
  (VTBL_ENTRY)&_ZN5S51C73v50Ev,
  (VTBL_ENTRY)&_ZN5S51C73v51Ev,
  (VTBL_ENTRY)&_ZN5S51C73v52Ev,
  (VTBL_ENTRY)&_ZN5S51C73v53Ev,
  (VTBL_ENTRY)&_ZN5S51C73v54Ev,
  (VTBL_ENTRY)&_ZN5S51C73v55Ev,
  (VTBL_ENTRY)&_ZN5S51C73v56Ev,
  (VTBL_ENTRY)&_ZN5S51C73v57Ev,
  (VTBL_ENTRY)&_ZN5S51C73v58Ev,
  (VTBL_ENTRY)&_ZN5S51C73v59Ev,
  (VTBL_ENTRY)&_ZN5S51C73v60Ev,
  (VTBL_ENTRY)&_ZN5S51C73v61Ev,
  (VTBL_ENTRY)&_ZN5S51C73v62Ev,
  (VTBL_ENTRY)&_ZN5S51C73v63Ev,
  (VTBL_ENTRY)&_ZN5S51C73v64Ev,
  (VTBL_ENTRY)&_ZN5S51C73v65Ev,
  (VTBL_ENTRY)&_ZN5S51C73v66Ev,
  (VTBL_ENTRY)&_ZN5S51C73v67Ev,
  (VTBL_ENTRY)&_ZN5S51C73v68Ev,
  (VTBL_ENTRY)&_ZN5S51C73v69Ev,
  (VTBL_ENTRY)&_ZN5S51C73v70Ev,
  (VTBL_ENTRY)&_ZN5S51C73v71Ev,
  (VTBL_ENTRY)&_ZN5S51C73v72Ev,
  (VTBL_ENTRY)&_ZN5S51C73v73Ev,
  (VTBL_ENTRY)&_ZN5S51C73v74Ev,
  (VTBL_ENTRY)&_ZN5S51C63v75Ev,
  (VTBL_ENTRY)&_ZN5S51C63v76Ev,
  (VTBL_ENTRY)&_ZN5S51C53v77Ev,
  (VTBL_ENTRY)&_ZN5S51C53v78Ev,
  (VTBL_ENTRY)&_ZN5S51C53v79Ev,
  (VTBL_ENTRY)&_ZN5S51C53v80Ev,
  (VTBL_ENTRY)&_ZN5S51C53v81Ev,
  (VTBL_ENTRY)&_ZN5S51C53v82Ev,
  (VTBL_ENTRY)&_ZN5S51C53v83Ev,
  (VTBL_ENTRY)&_ZN5S51C53v84Ev,
  (VTBL_ENTRY)&_ZN5S51C53v85Ev,
  (VTBL_ENTRY)&_ZN5S51C53v86Ev,
  (VTBL_ENTRY)&_ZN5S51C53v87Ev,
  (VTBL_ENTRY)&_ZN5S51C53v88Ev,
  (VTBL_ENTRY)&_ZN5S51C43v89Ev,
  (VTBL_ENTRY)&_ZN5S51C43v90Ev,
  (VTBL_ENTRY)&_ZN5S51C43v91Ev,
  (VTBL_ENTRY)&_ZN5S51C33v96Ev,
  (VTBL_ENTRY)&_ZN5S51C33v97Ev,
  (VTBL_ENTRY)&_ZN5S51C33v98Ev,
  (VTBL_ENTRY)&_ZN5S51C33v99Ev,
  (VTBL_ENTRY)&_ZN5S51C34v100Ev,
  (VTBL_ENTRY)&_ZN5S51C34v101Ev,
  (VTBL_ENTRY)&_ZN5S51C34v102Ev,
  (VTBL_ENTRY)&_ZN5S51C34v103Ev,
  (VTBL_ENTRY)&_ZN5S51C34v104Ev,
  (VTBL_ENTRY)&_ZN5S51C24v105Ev,
  (VTBL_ENTRY)&_ZN5S51C24v106Ev,
  (VTBL_ENTRY)&_ZN5S51C24v107Ev,
  (VTBL_ENTRY)&_ZN5S51C24v108Ev,
  (VTBL_ENTRY)&_ZN5S51C24v109Ev,
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI5S51C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S51C2D1Ev,_ZThn100_N5S51C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn152_N5S51C2D0Ev,_ZThn100_N5S51C2D0Ev),
  (VTBL_ENTRY)&_ZN6S51C153v92Ev,
  (VTBL_ENTRY)&_ZN6S51C153v93Ev,
  (VTBL_ENTRY)&_ZN6S51C153v94Ev,
  (VTBL_ENTRY)&_ZN6S51C153v95Ev,
};
extern VTBL_ENTRY _ZTI5S51C2[];
extern  VTBL_ENTRY _ZTV5S51C2[];
Class_Descriptor cd_S51C2 = {  "S51C2", // class name
  bases_S51C2, 6,
  &(vtc_S51C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,120), // object size
  NSPAIRA(_ZTI5S51C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S51C2),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S51C1  : S51C2 {
  ::S3422C4_nt s51c1f0;
  ::S3422C11 s51c1f1;
  virtual  ~S51C1(); // _ZN5S51C1D1Ev
  virtual void  v1(); // _ZN5S51C12v1Ev
  virtual void  v2(); // _ZN5S51C12v2Ev
  virtual void  v3(); // _ZN5S51C12v3Ev
  virtual void  v4(); // _ZN5S51C12v4Ev
  virtual void  v5(); // _ZN5S51C12v5Ev
  virtual void  v6(); // _ZN5S51C12v6Ev
  virtual void  v7(); // _ZN5S51C12v7Ev
  virtual void  v8(); // _ZN5S51C12v8Ev
  virtual void  v9(); // _ZN5S51C12v9Ev
  virtual void  v10(); // _ZN5S51C13v10Ev
  S51C1(); // tgen
};
//SIG(1 S51C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v75 v76} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fc FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC12{ m Fp FC8}} vd v89 v90 v91 FC13{ BC14{ BC11}}} BC15{ vd v92 v93 v94 v95} vd v96 v97 v98 v99 v100 v101 v102 v103 v104} vd v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC9}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC8 FC17{ BC18{ BC11}}}


 S51C1 ::~S51C1(){ note_dtor("S51C1", this);}
void  S51C1 ::v1(){vfunc_called(this, "_ZN5S51C12v1Ev");}
void  S51C1 ::v2(){vfunc_called(this, "_ZN5S51C12v2Ev");}
void  S51C1 ::v3(){vfunc_called(this, "_ZN5S51C12v3Ev");}
void  S51C1 ::v4(){vfunc_called(this, "_ZN5S51C12v4Ev");}
void  S51C1 ::v5(){vfunc_called(this, "_ZN5S51C12v5Ev");}
void  S51C1 ::v6(){vfunc_called(this, "_ZN5S51C12v6Ev");}
void  S51C1 ::v7(){vfunc_called(this, "_ZN5S51C12v7Ev");}
void  S51C1 ::v8(){vfunc_called(this, "_ZN5S51C12v8Ev");}
void  S51C1 ::v9(){vfunc_called(this, "_ZN5S51C12v9Ev");}
void  S51C1 ::v10(){vfunc_called(this, "_ZN5S51C13v10Ev");}
S51C1 ::S51C1(){ note_ctor("S51C1", this);} // tgen

static void Test_S51C1()
{
  extern Class_Descriptor cd_S51C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,36)];
    init_test(&cd_S51C1, buf);
    S51C1 *dp, &lv = *(dp=new (buf) S51C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,140), "sizeof(S51C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S51C1)");
    check_base_class_offset(lv, (S51C7*)(S51C6*)(S51C5*)(S51C4*)(S51C3*)(S51C2*), 0, "S51C1");
    che