// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S248C7_nt  {
  int s248c7f0[2];
  void  mf248c7(); // _ZN9S248C7_nt7mf248c7Ev
};
//SIG(-1 S248C7_nt) C1{ m Fi[2]}


void  S248C7_nt ::mf248c7(){}

//skip512 S248C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C6_nt  {
  int s248c6f0;
  __tsi64 s248c6f1;
  void *s248c6f2[4];
  int s248c6f3[2];
  void *s248c6f4;
  ::S248C7_nt s248c6f5;
  void *s248c6f6[2];
  virtual  ~S248C6_nt(); // _ZN9S248C6_ntD1Ev
  virtual void  v5(); // _ZN9S248C6_nt2v5Ev
  virtual void  v6(); // _ZN9S248C6_nt2v6Ev
  virtual void  v7(); // _ZN9S248C6_nt2v7Ev
  virtual void  v8(); // _ZN9S248C6_nt2v8Ev
  virtual void  v9(); // _ZN9S248C6_nt2v9Ev
  virtual void  v10(); // _ZN9S248C6_nt3v10Ev
  virtual void  v11(); // _ZN9S248C6_nt3v11Ev
  virtual void  v12(); // _ZN9S248C6_nt3v12Ev
  virtual void  v13(); // _ZN9S248C6_nt3v13Ev
  virtual void  v14(); // _ZN9S248C6_nt3v14Ev
  virtual void  v15(); // _ZN9S248C6_nt3v15Ev
  virtual void  v16(); // _ZN9S248C6_nt3v16Ev
  virtual void  v17(); // _ZN9S248C6_nt3v17Ev
  virtual void  v18(); // _ZN9S248C6_nt3v18Ev
  virtual void  v19(); // _ZN9S248C6_nt3v19Ev
  virtual void  v20(); // _ZN9S248C6_nt3v20Ev
  virtual void  v21(); // _ZN9S248C6_nt3v21Ev
  virtual void  v22(); // _ZN9S248C6_nt3v22Ev
  virtual void  v23(); // _ZN9S248C6_nt3v23Ev
  virtual void  v24(); // _ZN9S248C6_nt3v24Ev
  virtual void  v25(); // _ZN9S248C6_nt3v25Ev
  virtual void  v26(); // _ZN9S248C6_nt3v26Ev
  virtual void  v27(); // _ZN9S248C6_nt3v27Ev
  virtual void  v28(); // _ZN9S248C6_nt3v28Ev
  virtual void  v29(); // _ZN9S248C6_nt3v29Ev
  virtual void  v30(); // _ZN9S248C6_nt3v30Ev
  virtual void  v31(); // _ZN9S248C6_nt3v31Ev
  virtual void  v32(); // _ZN9S248C6_nt3v32Ev
  virtual void  v33(); // _ZN9S248C6_nt3v33Ev
  virtual void  v34(); // _ZN9S248C6_nt3v34Ev
  virtual void  v35(); // _ZN9S248C6_nt3v35Ev
  virtual void  v36(); // _ZN9S248C6_nt3v36Ev
  virtual void  v37(); // _ZN9S248C6_nt3v37Ev
  virtual void  v38(); // _ZN9S248C6_nt3v38Ev
  virtual void  v39(); // _ZN9S248C6_nt3v39Ev
  virtual void  v40(); // _ZN9S248C6_nt3v40Ev
  virtual void  v41(); // _ZN9S248C6_nt3v41Ev
  virtual void  v42(); // _ZN9S248C6_nt3v42Ev
  virtual void  v43(); // _ZN9S248C6_nt3v43Ev
  virtual void  v44(); // _ZN9S248C6_nt3v44Ev
  virtual void  v45(); // _ZN9S248C6_nt3v45Ev
  virtual void  v46(); // _ZN9S248C6_nt3v46Ev
  virtual void  v47(); // _ZN9S248C6_nt3v47Ev
  virtual void  v48(); // _ZN9S248C6_nt3v48Ev
  virtual void  v49(); // _ZN9S248C6_nt3v49Ev
  virtual void  v50(); // _ZN9S248C6_nt3v50Ev
  virtual void  v51(); // _ZN9S248C6_nt3v51Ev
  virtual void  v52(); // _ZN9S248C6_nt3v52Ev
  virtual void  v53(); // _ZN9S248C6_nt3v53Ev
  virtual void  v54(); // _ZN9S248C6_nt3v54Ev
  virtual void  v55(); // _ZN9S248C6_nt3v55Ev
  virtual void  v56(); // _ZN9S248C6_nt3v56Ev
  virtual void  v57(); // _ZN9S248C6_nt3v57Ev
  virtual void  v58(); // _ZN9S248C6_nt3v58Ev
  virtual void  v59(); // _ZN9S248C6_nt3v59Ev
  virtual void  v60(); // _ZN9S248C6_nt3v60Ev
  virtual void  v61(); // _ZN9S248C6_nt3v61Ev
  virtual void  v62(); // _ZN9S248C6_nt3v62Ev
  virtual void  v63(); // _ZN9S248C6_nt3v63Ev
  virtual void  v64(); // _ZN9S248C6_nt3v64Ev
  virtual void  v65(); // _ZN9S248C6_nt3v65Ev
  virtual void  v66(); // _ZN9S248C6_nt3v66Ev
  virtual void  v67(); // _ZN9S248C6_nt3v67Ev
  virtual void  v68(); // _ZN9S248C6_nt3v68Ev
  S248C6_nt(); // tgen
};
//SIG(-1 S248C6_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S248C6_nt ::~S248C6_nt(){ note_dtor("S248C6_nt", this);}
void  S248C6_nt ::v5(){vfunc_called(this, "_ZN9S248C6_nt2v5Ev");}
void  S248C6_nt ::v6(){vfunc_called(this, "_ZN9S248C6_nt2v6Ev");}
void  S248C6_nt ::v7(){vfunc_called(this, "_ZN9S248C6_nt2v7Ev");}
void  S248C6_nt ::v8(){vfunc_called(this, "_ZN9S248C6_nt2v8Ev");}
void  S248C6_nt ::v9(){vfunc_called(this, "_ZN9S248C6_nt2v9Ev");}
void  S248C6_nt ::v10(){vfunc_called(this, "_ZN9S248C6_nt3v10Ev");}
void  S248C6_nt ::v11(){vfunc_called(this, "_ZN9S248C6_nt3v11Ev");}
void  S248C6_nt ::v12(){vfunc_called(this, "_ZN9S248C6_nt3v12Ev");}
void  S248C6_nt ::v13(){vfunc_called(this, "_ZN9S248C6_nt3v13Ev");}
void  S248C6_nt ::v14(){vfunc_called(this, "_ZN9S248C6_nt3v14Ev");}
void  S248C6_nt ::v15(){vfunc_called(this, "_ZN9S248C6_nt3v15Ev");}
void  S248C6_nt ::v16(){vfunc_called(this, "_ZN9S248C6_nt3v16Ev");}
void  S248C6_nt ::v17(){vfunc_called(this, "_ZN9S248C6_nt3v17Ev");}
void  S248C6_nt ::v18(){vfunc_called(this, "_ZN9S248C6_nt3v18Ev");}
void  S248C6_nt ::v19(){vfunc_called(this, "_ZN9S248C6_nt3v19Ev");}
void  S248C6_nt ::v20(){vfunc_called(this, "_ZN9S248C6_nt3v20Ev");}
void  S248C6_nt ::v21(){vfunc_called(this, "_ZN9S248C6_nt3v21Ev");}
void  S248C6_nt ::v22(){vfunc_called(this, "_ZN9S248C6_nt3v22Ev");}
void  S248C6_nt ::v23(){vfunc_called(this, "_ZN9S248C6_nt3v23Ev");}
void  S248C6_nt ::v24(){vfunc_called(this, "_ZN9S248C6_nt3v24Ev");}
void  S248C6_nt ::v25(){vfunc_called(this, "_ZN9S248C6_nt3v25Ev");}
void  S248C6_nt ::v26(){vfunc_called(this, "_ZN9S248C6_nt3v26Ev");}
void  S248C6_nt ::v27(){vfunc_called(this, "_ZN9S248C6_nt3v27Ev");}
void  S248C6_nt ::v28(){vfunc_called(this, "_ZN9S248C6_nt3v28Ev");}
void  S248C6_nt ::v29(){vfunc_called(this, "_ZN9S248C6_nt3v29Ev");}
void  S248C6_nt ::v30(){vfunc_called(this, "_ZN9S248C6_nt3v30Ev");}
void  S248C6_nt ::v31(){vfunc_called(this, "_ZN9S248C6_nt3v31Ev");}
void  S248C6_nt ::v32(){vfunc_called(this, "_ZN9S248C6_nt3v32Ev");}
void  S248C6_nt ::v33(){vfunc_called(this, "_ZN9S248C6_nt3v33Ev");}
void  S248C6_nt ::v34(){vfunc_called(this, "_ZN9S248C6_nt3v34Ev");}
void  S248C6_nt ::v35(){vfunc_called(this, "_ZN9S248C6_nt3v35Ev");}
void  S248C6_nt ::v36(){vfunc_called(this, "_ZN9S248C6_nt3v36Ev");}
void  S248C6_nt ::v37(){vfunc_called(this, "_ZN9S248C6_nt3v37Ev");}
void  S248C6_nt ::v38(){vfunc_called(this, "_ZN9S248C6_nt3v38Ev");}
void  S248C6_nt ::v39(){vfunc_called(this, "_ZN9S248C6_nt3v39Ev");}
void  S248C6_nt ::v40(){vfunc_called(this, "_ZN9S248C6_nt3v40Ev");}
void  S248C6_nt ::v41(){vfunc_called(this, "_ZN9S248C6_nt3v41Ev");}
void  S248C6_nt ::v42(){vfunc_called(this, "_ZN9S248C6_nt3v42Ev");}
void  S248C6_nt ::v43(){vfunc_called(this, "_ZN9S248C6_nt3v43Ev");}
void  S248C6_nt ::v44(){vfunc_called(this, "_ZN9S248C6_nt3v44Ev");}
void  S248C6_nt ::v45(){vfunc_called(this, "_ZN9S248C6_nt3v45Ev");}
void  S248C6_nt ::v46(){vfunc_called(this, "_ZN9S248C6_nt3v46Ev");}
void  S248C6_nt ::v47(){vfunc_called(this, "_ZN9S248C6_nt3v47Ev");}
void  S248C6_nt ::v48(){vfunc_called(this, "_ZN9S248C6_nt3v48Ev");}
void  S248C6_nt ::v49(){vfunc_called(this, "_ZN9S248C6_nt3v49Ev");}
void  S248C6_nt ::v50(){vfunc_called(this, "_ZN9S248C6_nt3v50Ev");}
void  S248C6_nt ::v51(){vfunc_called(this, "_ZN9S248C6_nt3v51Ev");}
void  S248C6_nt ::v52(){vfunc_called(this, "_ZN9S248C6_nt3v52Ev");}
void  S248C6_nt ::v53(){vfunc_called(this, "_ZN9S248C6_nt3v53Ev");}
void  S248C6_nt ::v54(){vfunc_called(this, "_ZN9S248C6_nt3v54Ev");}
void  S248C6_nt ::v55(){vfunc_called(this, "_ZN9S248C6_nt3v55Ev");}
void  S248C6_nt ::v56(){vfunc_called(this, "_ZN9S248C6_nt3v56Ev");}
void  S248C6_nt ::v57(){vfunc_called(this, "_ZN9S248C6_nt3v57Ev");}
void  S248C6_nt ::v58(){vfunc_called(this, "_ZN9S248C6_nt3v58Ev");}
void  S248C6_nt ::v59(){vfunc_called(this, "_ZN9S248C6_nt3v59Ev");}
void  S248C6_nt ::v60(){vfunc_called(this, "_ZN9S248C6_nt3v60Ev");}
void  S248C6_nt ::v61(){vfunc_called(this, "_ZN9S248C6_nt3v61Ev");}
void  S248C6_nt ::v62(){vfunc_called(this, "_ZN9S248C6_nt3v62Ev");}
void  S248C6_nt ::v63(){vfunc_called(this, "_ZN9S248C6_nt3v63Ev");}
void  S248C6_nt ::v64(){vfunc_called(this, "_ZN9S248C6_nt3v64Ev");}
void  S248C6_nt ::v65(){vfunc_called(this, "_ZN9S248C6_nt3v65Ev");}
void  S248C6_nt ::v66(){vfunc_called(this, "_ZN9S248C6_nt3v66Ev");}
void  S248C6_nt ::v67(){vfunc_called(this, "_ZN9S248C6_nt3v67Ev");}
void  S248C6_nt ::v68(){vfunc_called(this, "_ZN9S248C6_nt3v68Ev");}
S248C6_nt ::S248C6_nt(){ note_ctor("S248C6_nt", this);} // tgen

//skip512 S248C6_nt

#else // __cplusplus

extern void _ZN9S248C6_ntC1Ev();
extern void _ZN9S248C6_ntD1Ev();
Name_Map name_map_S248C6_nt[] = {
  NSPAIR(_ZN9S248C6_ntC1Ev),
  NSPAIR(_ZN9S248C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern void _ZN9S248C6_ntD1Ev();
extern void _ZN9S248C6_ntD0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
static  VTBL_ENTRY vtc_S248C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S248C6_nt[0]),
  (VTBL_ENTRY)&_ZN9S248C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S248C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI9S248C6_nt[];
VTBL_ENTRY *P__ZTI9S248C6_nt = _ZTI9S248C6_nt; 
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
Class_Descriptor cd_S248C6_nt = {  "S248C6_nt", // class name
  0,0,//no base classes
  &(vtc_S248C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S248C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S248C6_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C5_nt  : S248C6_nt {
  virtual  ~S248C5_nt(); // _ZN9S248C5_ntD1Ev
  virtual void  v69(); // _ZN9S248C5_nt3v69Ev
  virtual void  v70(); // _ZN9S248C5_nt3v70Ev
  S248C5_nt(); // tgen
};
//SIG(-1 S248C5_nt) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2}


 S248C5_nt ::~S248C5_nt(){ note_dtor("S248C5_nt", this);}
void  S248C5_nt ::v69(){vfunc_called(this, "_ZN9S248C5_nt3v69Ev");}
void  S248C5_nt ::v70(){vfunc_called(this, "_ZN9S248C5_nt3v70Ev");}
S248C5_nt ::S248C5_nt(){ note_ctor("S248C5_nt", this);} // tgen

//skip512 S248C5_nt

#else // __cplusplus

extern void _ZN9S248C5_ntC1Ev();
extern void _ZN9S248C5_ntD1Ev();
Name_Map name_map_S248C5_nt[] = {
  NSPAIR(_ZN9S248C5_ntC1Ev),
  NSPAIR(_ZN9S248C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S248C6_nt;
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
static Base_Class bases_S248C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S248C5_nt[];
extern void _ZN9S248C5_ntD1Ev();
extern void _ZN9S248C5_ntD0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
extern void _ZN9S248C5_nt3v69Ev();
extern void _ZN9S248C5_nt3v70Ev();
static  VTBL_ENTRY vtc_S248C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S248C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S248C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S248C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI9S248C5_nt[];
VTBL_ENTRY *P__ZTI9S248C5_nt = _ZTI9S248C5_nt; 
extern  VTBL_ENTRY _ZTV9S248C5_nt[];
Class_Descriptor cd_S248C5_nt = {  "S248C5_nt", // class name
  bases_S248C5_nt, 1,
  &(vtc_S248C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S248C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S248C5_nt),70, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C8_nt  {
  int s248c8f0[4];
  char s248c8f1[9];
  void  mf248c8(); // _ZN9S248C8_nt7mf248c8Ev
};
//SIG(-1 S248C8_nt) C1{ m Fi[4] Fc[9]}


void  S248C8_nt ::mf248c8(){}

//skip512 S248C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C11_nt  {
  void *s248c11f0;
  int s248c11f1[2];
  void  mf248c11(); // _ZN10S248C11_nt8mf248c11Ev
};
//SIG(-1 S248C11_nt) C1{ m Fp Fi[2]}


void  S248C11_nt ::mf248c11(){}

//skip512 S248C11_nt

#else // __cplusplus

Class_Descriptor cd_S248C11_nt = {  "S248C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C10_nt  : S248C11_nt {
};
//SIG(-1 S248C10_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S248C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
static Base_Class bases_S248C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C10_nt = {  "S248C10_nt", // class name
  bases_S248C10_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C9_nt  : S248C10_nt {
};
//SIG(-1 S248C9_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S248C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C10_nt;
static Base_Class bases_S248C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C15  : S248C11_nt {
};
//SIG(-1 S248C15) C1{ BC2{ m Fp Fi[2]}}



static void Test_S248C15()
{
  extern Class_Descriptor cd_S248C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C15, buf);
    S248C15 &lv = *(new (buf) S248C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C15)");
    check_base_class_offset(lv, (S248C11_nt*), 0, "S248C15");
    test_class_info(&lv, &cd_S248C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C15(Test_S248C15, "S248C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
static Base_Class bases_S248C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C15 = {  "S248C15", // class name
  bases_S248C15, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C14  : S248C15 {
};
//SIG(-1 S248C14) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S248C14()
{
  extern Class_Descriptor cd_S248C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C14, buf);
    S248C14 &lv = *(new (buf) S248C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C14)");
    check_base_class_offset(lv, (S248C11_nt*)(S248C15*), 0, "S248C14");
    check_base_class_offset(lv, (S248C15*), 0, "S248C14");
    test_class_info(&lv, &cd_S248C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C14(Test_S248C14, "S248C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C15;
static Base_Class bases_S248C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C14 = {  "S248C14", // class name
  bases_S248C14, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C19  : S248C11_nt {
};
//SIG(-1 S248C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S248C19()
{
  extern Class_Descriptor cd_S248C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C19, buf);
    S248C19 &lv = *(new (buf) S248C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C19)");
    check_base_class_offset(lv, (S248C11_nt*), 0, "S248C19");
    test_class_info(&lv, &cd_S248C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C19(Test_S248C19, "S248C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
static Base_Class bases_S248C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C19 = {  "S248C19", // class name
  bases_S248C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C18  : S248C19 {
};
//SIG(-1 S248C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S248C18()
{
  extern Class_Descriptor cd_S248C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C18, buf);
    S248C18 &lv = *(new (buf) S248C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C18)");
    check_base_class_offset(lv, (S248C11_nt*)(S248C19*), 0, "S248C18");
    check_base_class_offset(lv, (S248C19*), 0, "S248C18");
    test_class_info(&lv, &cd_S248C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C18(Test_S248C18, "S248C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C19;
static Base_Class bases_S248C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C18 = {  "S248C18", // class name
  bases_S248C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C20_nt  {
  void *s248c20f0;
  ::S248C7_nt s248c20f1;
  void  mf248c20(); // _ZN10S248C20_nt8mf248c20Ev
};
//SIG(-1 S248C20_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S248C20_nt ::mf248c20(){}

//skip512 S248C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C4_nt  : S248C5_nt {
  ::S248C8_nt s248c4f0;
  int s248c4f1;
  unsigned int s248c4f2:1;
  unsigned int s248c4f3:1;
  unsigned int s248c4f4:1;
  unsigned int s248c4f5:1;
  ::S248C9_nt s248c4f6;
  ::S248C9_nt s248c4f7;
  void *s248c4f8;
  ::S248C14 s248c4f9;
  ::S248C14 s248c4f10;
  ::S248C14 s248c4f11;
  ::S248C18 s248c4f12;
  char s248c4f13;
  int s248c4f14;
  void *s248c4f15;
  ::S248C7_nt s248c4f16;
  ::S248C7_nt s248c4f17;
  ::S248C7_nt s248c4f18;
  ::S248C7_nt s248c4f19;
  ::S248C7_nt s248c4f20;
  ::S248C7_nt s248c4f21;
  ::S248C20_nt s248c4f22;
  ::S248C20_nt s248c4f23;
  ::S248C20_nt s248c4f24;
  ::S248C20_nt s248c4f25;
  ::S248C20_nt s248c4f26;
  ::S248C20_nt s248c4f27;
  ::S248C20_nt s248c4f28;
  ::S248C20_nt s248c4f29;
  ::S248C20_nt s248c4f30;
  ::S248C20_nt s248c4f31;
  virtual  ~S248C4_nt(); // _ZN9S248C4_ntD1Ev
  virtual void  v71(); // _ZN9S248C4_nt3v71Ev
  virtual void  v72(); // _ZN9S248C4_nt3v72Ev
  virtual void  v73(); // _ZN9S248C4_nt3v73Ev
  virtual void  v74(); // _ZN9S248C4_nt3v74Ev
  virtual void  v75(); // _ZN9S248C4_nt3v75Ev
  virtual void  v76(); // _ZN9S248C4_nt3v76Ev
  virtual void  v77(); // _ZN9S248C4_nt3v77Ev
  virtual void  v78(); // _ZN9S248C4_nt3v78Ev
  virtual void  v79(); // _ZN9S248C4_nt3v79Ev
  virtual void  v80(); // _ZN9S248C4_nt3v80Ev
  virtual void  v81(); // _ZN9S248C4_nt3v81Ev
  virtual void  v82(); // _ZN9S248C4_nt3v82Ev
  virtual void  v83(); // _ZN9S248C4_nt3v83Ev
  virtual void  v84(); // _ZN9S248C4_nt3v84Ev
  virtual void  v85(); // _ZN9S248C4_nt3v85Ev
  virtual void  v86(); // _ZN9S248C4_nt3v86Ev
  virtual void  v87(); // _ZN9S248C4_nt3v87Ev
  virtual void  v88(); // _ZN9S248C4_nt3v88Ev
  virtual void  v89(); // _ZN9S248C4_nt3v89Ev
  virtual void  v90(); // _ZN9S248C4_nt3v90Ev
  virtual void  v91(); // _ZN9S248C4_nt3v91Ev
  virtual void  v92(); // _ZN9S248C4_nt3v92Ev
  virtual void  v93(); // _ZN9S248C4_nt3v93Ev
  virtual void  v94(); // _ZN9S248C4_nt3v94Ev
  virtual void  v95(); // _ZN9S248C4_nt3v95Ev
  virtual void  v96(); // _ZN9S248C4_nt3v96Ev
  virtual void  v97(); // _ZN9S248C4_nt3v97Ev
  virtual void  v98(); // _ZN9S248C4_nt3v98Ev
  virtual void  v99(); // _ZN9S248C4_nt3v99Ev
  virtual void  v100(); // _ZN9S248C4_nt4v100Ev
  virtual void  v101(); // _ZN9S248C4_nt4v101Ev
  virtual void  v102(); // _ZN9S248C4_nt4v102Ev
  virtual void  v103(); // _ZN9S248C4_nt4v103Ev
  virtual void  v104(); // _ZN9S248C4_nt4v104Ev
  virtual void  v105(); // _ZN9S248C4_nt4v105Ev
  virtual void  v106(); // _ZN9S248C4_nt4v106Ev
  virtual void  v107(); // _ZN9S248C4_nt4v107Ev
  virtual void  v108(); // _ZN9S248C4_nt4v108Ev
  virtual void  v109(); // _ZN9S248C4_nt4v109Ev
  virtual void  v110(); // _ZN9S248C4_nt4v110Ev
  virtual void  v111(); // _ZN9S248C4_nt4v111Ev
  virtual void  v112(); // _ZN9S248C4_nt4v112Ev
  virtual void  v113(); // _ZN9S248C4_nt4v113Ev
  virtual void  v114(); // _ZN9S248C4_nt4v114Ev
  virtual void  v115(); // _ZN9S248C4_nt4v115Ev
  virtual void  v116(); // _ZN9S248C4_nt4v116Ev
  virtual void  v117(); // _ZN9S248C4_nt4v117Ev
  virtual void  v118(); // _ZN9S248C4_nt4v118Ev
  virtual void  v119(); // _ZN9S248C4_nt4v119Ev
  virtual void  v120(); // _ZN9S248C4_nt4v120Ev
  virtual void  v121(); // _ZN9S248C4_nt4v121Ev
  virtual void  v122(); // _ZN9S248C4_nt4v122Ev
  virtual void  v123(); // _ZN9S248C4_nt4v123Ev
  virtual void  v124(); // _ZN9S248C4_nt4v124Ev
  virtual void  v125(); // _ZN9S248C4_nt4v125Ev
  virtual void  v126(); // _ZN9S248C4_nt4v126Ev
  virtual void  v127(); // _ZN9S248C4_nt4v127Ev
  virtual void  v128(); // _ZN9S248C4_nt4v128Ev
  virtual void  v129(); // _ZN9S248C4_nt4v129Ev
  virtual void  v130(); // _ZN9S248C4_nt4v130Ev
  virtual void  v131(); // _ZN9S248C4_nt4v131Ev
  virtual void  v132(); // _ZN9S248C4_nt4v132Ev
  virtual void  v133(); // _ZN9S248C4_nt4v133Ev
  virtual void  v134(); // _ZN9S248C4_nt4v134Ev
  virtual void  v135(); // _ZN9S248C4_nt4v135Ev
  virtual void  v136(); // _ZN9S248C4_nt4v136Ev
  virtual void  v137(); // _ZN9S248C4_nt4v137Ev
  virtual void  v138(); // _ZN9S248C4_nt4v138Ev
  virtual void  v139(); // _ZN9S248C4_nt4v139Ev
  virtual void  v140(); // _ZN9S248C4_nt4v140Ev
  virtual void  v141(); // _ZN9S248C4_nt4v141Ev
  virtual void  v142(); // _ZN9S248C4_nt4v142Ev
  virtual void  v143(); // _ZN9S248C4_nt4v143Ev
  virtual void  v144(); // _ZN9S248C4_nt4v144Ev
  virtual void  v145(); // _ZN9S248C4_nt4v145Ev
  virtual void  v146(); // _ZN9S248C4_nt4v146Ev
  S248C4_nt(); // tgen
};
//SIG(-1 S248C4_nt) C1{ BC2{ BC3{ vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v141 v142} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 FC5{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 Fp FC9{ BC10{ BC8}} FC9 FC9 FC11{ BC12{ BC8}} Fc Fi Fp FC4 FC4 FC4 FC4 FC4 FC4 FC13{ m Fp FC4} FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13 FC13}


 S248C4_nt ::~S248C4_nt(){ note_dtor("S248C4_nt", this);}
void  S248C4_nt ::v71(){vfunc_called(this, "_ZN9S248C4_nt3v71Ev");}
void  S248C4_nt ::v72(){vfunc_called(this, "_ZN9S248C4_nt3v72Ev");}
void  S248C4_nt ::v73(){vfunc_called(this, "_ZN9S248C4_nt3v73Ev");}
void  S248C4_nt ::v74(){vfunc_called(this, "_ZN9S248C4_nt3v74Ev");}
void  S248C4_nt ::v75(){vfunc_called(this, "_ZN9S248C4_nt3v75Ev");}
void  S248C4_nt ::v76(){vfunc_called(this, "_ZN9S248C4_nt3v76Ev");}
void  S248C4_nt ::v77(){vfunc_called(this, "_ZN9S248C4_nt3v77Ev");}
void  S248C4_nt ::v78(){vfunc_called(this, "_ZN9S248C4_nt3v78Ev");}
void  S248C4_nt ::v79(){vfunc_called(this, "_ZN9S248C4_nt3v79Ev");}
void  S248C4_nt ::v80(){vfunc_called(this, "_ZN9S248C4_nt3v80Ev");}
void  S248C4_nt ::v81(){vfunc_called(this, "_ZN9S248C4_nt3v81Ev");}
void  S248C4_nt ::v82(){vfunc_called(this, "_ZN9S248C4_nt3v82Ev");}
void  S248C4_nt ::v83(){vfunc_called(this, "_ZN9S248C4_nt3v83Ev");}
void  S248C4_nt ::v84(){vfunc_called(this, "_ZN9S248C4_nt3v84Ev");}
void  S248C4_nt ::v85(){vfunc_called(this, "_ZN9S248C4_nt3v85Ev");}
void  S248C4_nt ::v86(){vfunc_called(this, "_ZN9S248C4_nt3v86Ev");}
void  S248C4_nt ::v87(){vfunc_called(this, "_ZN9S248C4_nt3v87Ev");}
void  S248C4_nt ::v88(){vfunc_called(this, "_ZN9S248C4_nt3v88Ev");}
void  S248C4_nt ::v89(){vfunc_called(this, "_ZN9S248C4_nt3v89Ev");}
void  S248C4_nt ::v90(){vfunc_called(this, "_ZN9S248C4_nt3v90Ev");}
void  S248C4_nt ::v91(){vfunc_called(this, "_ZN9S248C4_nt3v91Ev");}
void  S248C4_nt ::v92(){vfunc_called(this, "_ZN9S248C4_nt3v92Ev");}
void  S248C4_nt ::v93(){vfunc_called(this, "_ZN9S248C4_nt3v93Ev");}
void  S248C4_nt ::v94(){vfunc_called(this, "_ZN9S248C4_nt3v94Ev");}
void  S248C4_nt ::v95(){vfunc_called(this, "_ZN9S248C4_nt3v95Ev");}
void  S248C4_nt ::v96(){vfunc_called(this, "_ZN9S248C4_nt3v96Ev");}
void  S248C4_nt ::v97(){vfunc_called(this, "_ZN9S248C4_nt3v97Ev");}
void  S248C4_nt ::v98(){vfunc_called(this, "_ZN9S248C4_nt3v98Ev");}
void  S248C4_nt ::v99(){vfunc_called(this, "_ZN9S248C4_nt3v99Ev");}
void  S248C4_nt ::v100(){vfunc_called(this, "_ZN9S248C4_nt4v100Ev");}
void  S248C4_nt ::v101(){vfunc_called(this, "_ZN9S248C4_nt4v101Ev");}
void  S248C4_nt ::v102(){vfunc_called(this, "_ZN9S248C4_nt4v102Ev");}
void  S248C4_nt ::v103(){vfunc_called(this, "_ZN9S248C4_nt4v103Ev");}
void  S248C4_nt ::v104(){vfunc_called(this, "_ZN9S248C4_nt4v104Ev");}
void  S248C4_nt ::v105(){vfunc_called(this, "_ZN9S248C4_nt4v105Ev");}
void  S248C4_nt ::v106(){vfunc_called(this, "_ZN9S248C4_nt4v106Ev");}
void  S248C4_nt ::v107(){vfunc_called(this, "_ZN9S248C4_nt4v107Ev");}
void  S248C4_nt ::v108(){vfunc_called(this, "_ZN9S248C4_nt4v108Ev");}
void  S248C4_nt ::v109(){vfunc_called(this, "_ZN9S248C4_nt4v109Ev");}
void  S248C4_nt ::v110(){vfunc_called(this, "_ZN9S248C4_nt4v110Ev");}
void  S248C4_nt ::v111(){vfunc_called(this, "_ZN9S248C4_nt4v111Ev");}
void  S248C4_nt ::v112(){vfunc_called(this, "_ZN9S248C4_nt4v112Ev");}
void  S248C4_nt ::v113(){vfunc_called(this, "_ZN9S248C4_nt4v113Ev");}
void  S248C4_nt ::v114(){vfunc_called(this, "_ZN9S248C4_nt4v114Ev");}
void  S248C4_nt ::v115(){vfunc_called(this, "_ZN9S248C4_nt4v115Ev");}
void  S248C4_nt ::v116(){vfunc_called(this, "_ZN9S248C4_nt4v116Ev");}
void  S248C4_nt ::v117(){vfunc_called(this, "_ZN9S248C4_nt4v117Ev");}
void  S248C4_nt ::v118(){vfunc_called(this, "_ZN9S248C4_nt4v118Ev");}
void  S248C4_nt ::v119(){vfunc_called(this, "_ZN9S248C4_nt4v119Ev");}
void  S248C4_nt ::v120(){vfunc_called(this, "_ZN9S248C4_nt4v120Ev");}
void  S248C4_nt ::v121(){vfunc_called(this, "_ZN9S248C4_nt4v121Ev");}
void  S248C4_nt ::v122(){vfunc_called(this, "_ZN9S248C4_nt4v122Ev");}
void  S248C4_nt ::v123(){vfunc_called(this, "_ZN9S248C4_nt4v123Ev");}
void  S248C4_nt ::v124(){vfunc_called(this, "_ZN9S248C4_nt4v124Ev");}
void  S248C4_nt ::v125(){vfunc_called(this, "_ZN9S248C4_nt4v125Ev");}
void  S248C4_nt ::v126(){vfunc_called(this, "_ZN9S248C4_nt4v126Ev");}
void  S248C4_nt ::v127(){vfunc_called(this, "_ZN9S248C4_nt4v127Ev");}
void  S248C4_nt ::v128(){vfunc_called(this, "_ZN9S248C4_nt4v128Ev");}
void  S248C4_nt ::v129(){vfunc_called(this, "_ZN9S248C4_nt4v129Ev");}
void  S248C4_nt ::v130(){vfunc_called(this, "_ZN9S248C4_nt4v130Ev");}
void  S248C4_nt ::v131(){vfunc_called(this, "_ZN9S248C4_nt4v131Ev");}
void  S248C4_nt ::v132(){vfunc_called(this, "_ZN9S248C4_nt4v132Ev");}
void  S248C4_nt ::v133(){vfunc_called(this, "_ZN9S248C4_nt4v133Ev");}
void  S248C4_nt ::v134(){vfunc_called(this, "_ZN9S248C4_nt4v134Ev");}
void  S248C4_nt ::v135(){vfunc_called(this, "_ZN9S248C4_nt4v135Ev");}
void  S248C4_nt ::v136(){vfunc_called(this, "_ZN9S248C4_nt4v136Ev");}
void  S248C4_nt ::v137(){vfunc_called(this, "_ZN9S248C4_nt4v137Ev");}
void  S248C4_nt ::v138(){vfunc_called(this, "_ZN9S248C4_nt4v138Ev");}
void  S248C4_nt ::v139(){vfunc_called(this, "_ZN9S248C4_nt4v139Ev");}
void  S248C4_nt ::v140(){vfunc_called(this, "_ZN9S248C4_nt4v140Ev");}
void  S248C4_nt ::v141(){vfunc_called(this, "_ZN9S248C4_nt4v141Ev");}
void  S248C4_nt ::v142(){vfunc_called(this, "_ZN9S248C4_nt4v142Ev");}
void  S248C4_nt ::v143(){vfunc_called(this, "_ZN9S248C4_nt4v143Ev");}
void  S248C4_nt ::v144(){vfunc_called(this, "_ZN9S248C4_nt4v144Ev");}
void  S248C4_nt ::v145(){vfunc_called(this, "_ZN9S248C4_nt4v145Ev");}
void  S248C4_nt ::v146(){vfunc_called(this, "_ZN9S248C4_nt4v146Ev");}
S248C4_nt ::S248C4_nt(){ note_ctor("S248C4_nt", this);} // tgen

//skip512 S248C4_nt

#else // __cplusplus

extern void _ZN9S248C4_ntC1Ev();
extern void _ZN9S248C4_ntD1Ev();
Name_Map name_map_S248C4_nt[] = {
  NSPAIR(_ZN9S248C4_ntC1Ev),
  NSPAIR(_ZN9S248C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S248C6_nt;
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
extern Class_Descriptor cd_S248C5_nt;
extern VTBL_ENTRY _ZTI9S248C5_nt[];
extern  VTBL_ENTRY _ZTV9S248C5_nt[];
static Base_Class bases_S248C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S248C4_nt[];
extern void _ZN9S248C4_ntD1Ev();
extern void _ZN9S248C4_ntD0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
extern void _ZN9S248C5_nt3v69Ev();
extern void _ZN9S248C5_nt3v70Ev();
extern void _ZN9S248C4_nt3v71Ev();
extern void _ZN9S248C4_nt3v72Ev();
extern void _ZN9S248C4_nt3v73Ev();
extern void _ZN9S248C4_nt3v74Ev();
extern void _ZN9S248C4_nt3v75Ev();
extern void _ZN9S248C4_nt3v76Ev();
extern void _ZN9S248C4_nt3v77Ev();
extern void _ZN9S248C4_nt3v78Ev();
extern void _ZN9S248C4_nt3v79Ev();
extern void _ZN9S248C4_nt3v80Ev();
extern void _ZN9S248C4_nt3v81Ev();
extern void _ZN9S248C4_nt3v82Ev();
extern void _ZN9S248C4_nt3v83Ev();
extern void _ZN9S248C4_nt3v84Ev();
extern void _ZN9S248C4_nt3v85Ev();
extern void _ZN9S248C4_nt3v86Ev();
extern void _ZN9S248C4_nt3v87Ev();
extern void _ZN9S248C4_nt3v88Ev();
extern void _ZN9S248C4_nt3v89Ev();
extern void _ZN9S248C4_nt3v90Ev();
extern void _ZN9S248C4_nt3v91Ev();
extern void _ZN9S248C4_nt3v92Ev();
extern void _ZN9S248C4_nt3v93Ev();
extern void _ZN9S248C4_nt3v94Ev();
extern void _ZN9S248C4_nt3v95Ev();
extern void _ZN9S248C4_nt3v96Ev();
extern void _ZN9S248C4_nt3v97Ev();
extern void _ZN9S248C4_nt3v98Ev();
extern void _ZN9S248C4_nt3v99Ev();
extern void _ZN9S248C4_nt4v100Ev();
extern void _ZN9S248C4_nt4v101Ev();
extern void _ZN9S248C4_nt4v102Ev();
extern void _ZN9S248C4_nt4v103Ev();
extern void _ZN9S248C4_nt4v104Ev();
extern void _ZN9S248C4_nt4v105Ev();
extern void _ZN9S248C4_nt4v106Ev();
extern void _ZN9S248C4_nt4v107Ev();
extern void _ZN9S248C4_nt4v108Ev();
extern void _ZN9S248C4_nt4v109Ev();
extern void _ZN9S248C4_nt4v110Ev();
extern void _ZN9S248C4_nt4v111Ev();
extern void _ZN9S248C4_nt4v112Ev();
extern void _ZN9S248C4_nt4v113Ev();
extern void _ZN9S248C4_nt4v114Ev();
extern void _ZN9S248C4_nt4v115Ev();
extern void _ZN9S248C4_nt4v116Ev();
extern void _ZN9S248C4_nt4v117Ev();
extern void _ZN9S248C4_nt4v118Ev();
extern void _ZN9S248C4_nt4v119Ev();
extern void _ZN9S248C4_nt4v120Ev();
extern void _ZN9S248C4_nt4v121Ev();
extern void _ZN9S248C4_nt4v122Ev();
extern void _ZN9S248C4_nt4v123Ev();
extern void _ZN9S248C4_nt4v124Ev();
extern void _ZN9S248C4_nt4v125Ev();
extern void _ZN9S248C4_nt4v126Ev();
extern void _ZN9S248C4_nt4v127Ev();
extern void _ZN9S248C4_nt4v128Ev();
extern void _ZN9S248C4_nt4v129Ev();
extern void _ZN9S248C4_nt4v130Ev();
extern void _ZN9S248C4_nt4v131Ev();
extern void _ZN9S248C4_nt4v132Ev();
extern void _ZN9S248C4_nt4v133Ev();
extern void _ZN9S248C4_nt4v134Ev();
extern void _ZN9S248C4_nt4v135Ev();
extern void _ZN9S248C4_nt4v136Ev();
extern void _ZN9S248C4_nt4v137Ev();
extern void _ZN9S248C4_nt4v138Ev();
extern void _ZN9S248C4_nt4v139Ev();
extern void _ZN9S248C4_nt4v140Ev();
extern void _ZN9S248C4_nt4v141Ev();
extern void _ZN9S248C4_nt4v142Ev();
extern void _ZN9S248C4_nt4v143Ev();
extern void _ZN9S248C4_nt4v144Ev();
extern void _ZN9S248C4_nt4v145Ev();
extern void _ZN9S248C4_nt4v146Ev();
static  VTBL_ENTRY vtc_S248C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S248C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S248C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S248C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v146Ev,
};
extern VTBL_ENTRY _ZTI9S248C4_nt[];
VTBL_ENTRY *P__ZTI9S248C4_nt = _ZTI9S248C4_nt; 
extern  VTBL_ENTRY _ZTV9S248C4_nt[];
Class_Descriptor cd_S248C4_nt = {  "S248C4_nt", // class name
  bases_S248C4_nt, 2,
  &(vtc_S248C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(464,352), // object size
  NSPAIRA(_ZTI9S248C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S248C4_nt),146, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C22_nt  {
  int s248c22f0[4];
  void  mf248c22(); // _ZN10S248C22_nt8mf248c22Ev
};
//SIG(-1 S248C22_nt) C1{ m Fi[4]}


void  S248C22_nt ::mf248c22(){}

//skip512 S248C22_nt

#else // __cplusplus

Class_Descriptor cd_S248C22_nt = {  "S248C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C21_nt  : S248C22_nt {
};
//SIG(-1 S248C21_nt) C1{ BC2{ m Fi[4]}}



//skip512 S248C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C22_nt;
static Base_Class bases_S248C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C22_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C23_nt  {
  ::S248C7_nt s248c23f0;
  void *s248c23f1;
  ::S248C21_nt s248c23f2;
  void *s248c23f3;
  void  mf248c23(); // _ZN10S248C23_nt8mf248c23Ev
};
//SIG(-1 S248C23_nt) C1{ m FC2{ m Fi[2]} Fp FC3{ BC4{ m Fi[4]}} Fp}


void  S248C23_nt ::mf248c23(){}

//skip512 S248C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C25_nt  {
  void *s248c25f0[8];
  char s248c25f1[4];
  void  mf248c25(); // _ZN10S248C25_nt8mf248c25Ev
};
//SIG(-1 S248C25_nt) C1{ m Fp[8] Fc[4]}


void  S248C25_nt ::mf248c25(){}

//skip512 S248C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C27_nt  {
  int s248c27f0[4];
  char s248c27f1[4];
  void  mf248c27(); // _ZN10S248C27_nt8mf248c27Ev
};
//SIG(-1 S248C27_nt) C1{ m Fi[4] Fc[4]}


void  S248C27_nt ::mf248c27(){}

//skip512 S248C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C26_nt  {
  void *s248c26f0[5];
  ::S248C27_nt s248c26f1;
  unsigned int s248c26f2:1;
  unsigned int s248c26f3:1;
  int s248c26f4;
  char s248c26f5[8];
  void  mf248c26(); // _ZN10S248C26_nt8mf248c26Ev
};
//SIG(-1 S248C26_nt) C1{ m Fp[5] FC2{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]}


void  S248C26_nt ::mf248c26(){}

//skip512 S248C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C30_nt  {
  int s248c30f0[3];
  void  mf248c30(); // _ZN10S248C30_nt8mf248c30Ev
};
//SIG(-1 S248C30_nt) C1{ m Fi[3]}


void  S248C30_nt ::mf248c30(){}

//skip512 S248C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C31_nt  {
  void  mf248c31(); // _ZN10S248C31_nt8mf248c31Ev
};
//SIG(-1 S248C31_nt) C1{ m}


void  S248C31_nt ::mf248c31(){}

//skip512 S248C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C33_nt  {
  int s248c33f0[2];
  char s248c33f1[2];
  void  mf248c33(); // _ZN10S248C33_nt8mf248c33Ev
};
//SIG(-1 S248C33_nt) C1{ m Fi[2] Fc[2]}


void  S248C33_nt ::mf248c33(){}

//skip512 S248C33_nt

#else // __cplusplus

Class_Descriptor cd_S248C33_nt = {  "S248C33_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C32_nt  : S248C33_nt {
  int s248c32f0;
};
//SIG(-1 S248C32_nt) C1{ BC2{ m Fi[2] Fc[2]} Fi}



//skip512 S248C32_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C33_nt;
static Base_Class bases_S248C32_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C33_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C29_nt  {
  ::S248C30_nt s248c29f0;
  ::S248C31_nt s248c29f1;
  ::S248C32_nt s248c29f2;
  char s248c29f3;
  void  mf248c29(); // _ZN10S248C29_nt8mf248c29Ev
};
//SIG(-1 S248C29_nt) C1{ m FC2{ m Fi[3]} FC3{ m} FC4{ BC5{ m Fi[2] Fc[2]} Fi} Fc}


void  S248C29_nt ::mf248c29(){}

//skip512 S248C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C37_nt  {
  void *s248c37f0[2];
  void  mf248c37(); // _ZN10S248C37_nt8mf248c37Ev
};
//SIG(-1 S248C37_nt) C1{ m Fp[2]}


void  S248C37_nt ::mf248c37(){}

//skip512 S248C37_nt

#else // __cplusplus

Class_Descriptor cd_S248C37_nt = {  "S248C37_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C36_nt  : S248C37_nt {
};
//SIG(-1 S248C36_nt) C1{ BC2{ m Fp[2]}}



//skip512 S248C36_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C37_nt;
static Base_Class bases_S248C36_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C37_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C40  : S248C11_nt {
};
//SIG(-1 S248C40) C1{ BC2{ m Fp Fi[2]}}



static void Test_S248C40()
{
  extern Class_Descriptor cd_S248C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C40, buf);
    S248C40 &lv = *(new (buf) S248C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C40)");
    check_base_class_offset(lv, (S248C11_nt*), 0, "S248C40");
    test_class_info(&lv, &cd_S248C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C40(Test_S248C40, "S248C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
static Base_Class bases_S248C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C40 = {  "S248C40", // class name
  bases_S248C40, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C39  : S248C40 {
};
//SIG(-1 S248C39) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S248C39()
{
  extern Class_Descriptor cd_S248C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C39, buf);
    S248C39 &lv = *(new (buf) S248C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C39)");
    check_base_class_offset(lv, (S248C11_nt*)(S248C40*), 0, "S248C39");
    check_base_class_offset(lv, (S248C40*), 0, "S248C39");
    test_class_info(&lv, &cd_S248C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C39(Test_S248C39, "S248C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C40;
static Base_Class bases_S248C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C39 = {  "S248C39", // class name
  bases_S248C39, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C38_nt  : S248C39 {
};
//SIG(-1 S248C38_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S248C38_nt

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C40;
extern Class_Descriptor cd_S248C39;
static Base_Class bases_S248C38_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S248C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C35_nt  {
  ::S248C36_nt s248c35f0;
  char s248c35f1;
  ::S248C38_nt s248c35f2;
  int s248c35f3;
  ::S248C7_nt s248c35f4;
  ::S248C7_nt s248c35f5;
  void *s248c35f6;
  void  mf248c35(); // _ZN10S248C35_nt8mf248c35Ev
};
//SIG(-1 S248C35_nt) C1{ m FC2{ BC3{ m Fp[2]}} Fc FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} Fi FC8{ m Fi[2]} FC8 Fp}


void  S248C35_nt ::mf248c35(){}

//skip512 S248C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C44  : S248C11_nt {
};
//SIG(-1 S248C44) C1{ BC2{ m Fp Fi[2]}}



static void Test_S248C44()
{
  extern Class_Descriptor cd_S248C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C44, buf);
    S248C44 &lv = *(new (buf) S248C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C44)");
    check_base_class_offset(lv, (S248C11_nt*), 0, "S248C44");
    test_class_info(&lv, &cd_S248C44);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C44(Test_S248C44, "S248C44", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
static Base_Class bases_S248C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C44 = {  "S248C44", // class name
  bases_S248C44, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C43  : S248C44 {
};
//SIG(-1 S248C43) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S248C43()
{
  extern Class_Descriptor cd_S248C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S248C43, buf);
    S248C43 &lv = *(new (buf) S248C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S248C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C43)");
    check_base_class_offset(lv, (S248C11_nt*)(S248C44*), 0, "S248C43");
    check_base_class_offset(lv, (S248C44*), 0, "S248C43");
    test_class_info(&lv, &cd_S248C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C43(Test_S248C43, "S248C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S248C11_nt;
extern Class_Descriptor cd_S248C44;
static Base_Class bases_S248C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C44,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S248C43 = {  "S248C43", // class name
  bases_S248C43, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C3_nt  : S248C4_nt {
  ::S248C21_nt s248c3f0;
  ::S248C7_nt s248c3f1;
  void *s248c3f2[2];
  ::S248C23_nt s248c3f3;
  ::S248C25_nt s248c3f4;
  int s248c3f5;
  ::S248C26_nt s248c3f6;
  int s248c3f7[4];
  ::S248C7_nt s248c3f8[4];
  ::S248C29_nt s248c3f9;
  ::S248C30_nt s248c3f10;
  int s248c3f11;
  ::S248C35_nt s248c3f12;
  ::S248C35_nt s248c3f13;
  void *s248c3f14;
  ::S248C30_nt s248c3f15;
  ::S248C18 s248c3f16;
  ::S248C43 s248c3f17;
  unsigned int s248c3f18:1;
  unsigned int s248c3f19:1;
  unsigned int s248c3f20:1;
  ::S248C31_nt s248c3f21;
  ::S248C20_nt s248c3f22;
  ::S248C20_nt s248c3f23;
  ::S248C20_nt s248c3f24;
  ::S248C20_nt s248c3f25;
  ::S248C20_nt s248c3f26;
  ::S248C20_nt s248c3f27;
  ::S248C20_nt s248c3f28;
  ::S248C20_nt s248c3f29;
  ::S248C20_nt s248c3f30;
  ::S248C20_nt s248c3f31;
  ::S248C20_nt s248c3f32;
  ::S248C20_nt s248c3f33;
  ::S248C20_nt s248c3f34;
  virtual  ~S248C3_nt(); // _ZN9S248C3_ntD1Ev
  virtual void  v147(); // _ZN9S248C3_nt4v147Ev
  virtual void  v148(); // _ZN9S248C3_nt4v148Ev
  virtual void  v149(); // _ZN9S248C3_nt4v149Ev
  virtual void  v150(); // _ZN9S248C3_nt4v150Ev
  virtual void  v151(); // _ZN9S248C3_nt4v151Ev
  virtual void  v152(); // _ZN9S248C3_nt4v152Ev
  virtual void  v153(); // _ZN9S248C3_nt4v153Ev
  virtual void  v154(); // _ZN9S248C3_nt4v154Ev
  virtual void  v155(); // _ZN9S248C3_nt4v155Ev
  virtual void  v156(); // _ZN9S248C3_nt4v156Ev
  virtual void  v157(); // _ZN9S248C3_nt4v157Ev
  virtual void  v158(); // _ZN9S248C3_nt4v158Ev
  virtual void  v159(); // _ZN9S248C3_nt4v159Ev
  virtual void  v160(); // _ZN9S248C3_nt4v160Ev
  virtual void  v161(); // _ZN9S248C3_nt4v161Ev
  virtual void  v162(); // _ZN9S248C3_nt4v162Ev
  virtual void  v163(); // _ZN9S248C3_nt4v163Ev
  virtual void  v164(); // _ZN9S248C3_nt4v164Ev
  virtual void  v165(); // _ZN9S248C3_nt4v165Ev
  virtual void  v166(); // _ZN9S248C3_nt4v166Ev
  virtual void  v167(); // _ZN9S248C3_nt4v167Ev
  virtual void  v168(); // _ZN9S248C3_nt4v168Ev
  virtual void  v169(); // _ZN9S248C3_nt4v169Ev
  virtual void  v170(); // _ZN9S248C3_nt4v170Ev
  virtual void  v171(); // _ZN9S248C3_nt4v171Ev
  virtual void  v172(); // _ZN9S248C3_nt4v172Ev
  virtual void  v173(); // _ZN9S248C3_nt4v173Ev
  virtual void  v174(); // _ZN9S248C3_nt4v174Ev
  virtual void  v175(); // _ZN9S248C3_nt4v175Ev
  virtual void  v176(); // _ZN9S248C3_nt4v176Ev
  virtual void  v177(); // _ZN9S248C3_nt4v177Ev
  virtual void  v178(); // _ZN9S248C3_nt4v178Ev
  virtual void  v179(); // _ZN9S248C3_nt4v179Ev
  virtual void  v180(); // _ZN9S248C3_nt4v180Ev
  virtual void  v181(); // _ZN9S248C3_nt4v181Ev
  virtual void  v182(); // _ZN9S248C3_nt4v182Ev
  virtual void  v183(); // _ZN9S248C3_nt4v183Ev
  virtual void  v184(); // _ZN9S248C3_nt4v184Ev
  virtual void  v185(); // _ZN9S248C3_nt4v185Ev
  virtual void  v186(); // _ZN9S248C3_nt4v186Ev
  virtual void  v187(); // _ZN9S248C3_nt4v187Ev
  virtual void  v188(); // _ZN9S248C3_nt4v188Ev
  virtual void  v189(); // _ZN9S248C3_nt4v189Ev
  virtual void  v190(); // _ZN9S248C3_nt4v190Ev
  virtual void  v191(); // _ZN9S248C3_nt4v191Ev
  virtual void  v192(); // _ZN9S248C3_nt4v192Ev
  virtual void  v193(); // _ZN9S248C3_nt4v193Ev
  virtual void  v194(); // _ZN9S248C3_nt4v194Ev
  virtual void  v195(); // _ZN9S248C3_nt4v195Ev
  virtual void  v196(); // _ZN9S248C3_nt4v196Ev
  virtual void  v197(); // _ZN9S248C3_nt4v197Ev
  virtual void  v198(); // _ZN9S248C3_nt4v198Ev
  virtual void  v199(); // _ZN9S248C3_nt4v199Ev
  virtual void  v200(); // _ZN9S248C3_nt4v200Ev
  virtual void  v201(); // _ZN9S248C3_nt4v201Ev
  virtual void  v202(); // _ZN9S248C3_nt4v202Ev
  virtual void  v203(); // _ZN9S248C3_nt4v203Ev
  virtual void  v204(); // _ZN9S248C3_nt4v204Ev
  virtual void  v205(); // _ZN9S248C3_nt4v205Ev
  virtual void  v206(); // _ZN9S248C3_nt4v206Ev
  virtual void  v207(); // _ZN9S248C3_nt4v207Ev
  virtual void  v208(); // _ZN9S248C3_nt4v208Ev
  virtual void  v209(); // _ZN9S248C3_nt4v209Ev
  virtual void  v210(); // _ZN9S248C3_nt4v210Ev
  virtual void  v211(); // _ZN9S248C3_nt4v211Ev
  virtual void  v212(); // _ZN9S248C3_nt4v212Ev
  virtual void  v213(); // _ZN9S248C3_nt4v213Ev
  virtual void  v214(); // _ZN9S248C3_nt4v214Ev
  virtual void  v215(); // _ZN9S248C3_nt4v215Ev
  S248C3_nt(); // tgen
};
//SIG(-1 S248C3_nt) C1{ BC2{ BC3{ BC4{ vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v134 v135} vd v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 FC6{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 Fp FC10{ BC11{ BC9}} FC10 FC10 FC12{ BC13{ BC9}} Fc Fi Fp FC5 FC5 FC5 FC5 FC5 FC5 FC14{ m Fp FC5} FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 FC15{ BC16{ m Fi[4]}} FC5 Fp[2] FC17{ m FC5 Fp FC15 Fp} FC18{ m Fp[8] Fc[4]} Fi FC19{ m Fp[5] FC20{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC5[4] FC21{ m FC22{ m Fi[3]} FC23{ m} FC24{ BC25{ m Fi[2] Fc[2]} Fi} Fc} FC22 Fi FC26{ m FC27{ BC28{ m Fp[2]}} Fc FC29{ BC30{ BC31{ BC9}}} Fi FC5 FC5 Fp} FC26 Fp FC22 FC12 FC32{ BC33{ BC9}} Fi:1 Fi:1 Fi:1 FC23 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14 FC14}


 S248C3_nt ::~S248C3_nt(){ note_dtor("S248C3_nt", this);}
void  S248C3_nt ::v147(){vfunc_called(this, "_ZN9S248C3_nt4v147Ev");}
void  S248C3_nt ::v148(){vfunc_called(this, "_ZN9S248C3_nt4v148Ev");}
void  S248C3_nt ::v149(){vfunc_called(this, "_ZN9S248C3_nt4v149Ev");}
void  S248C3_nt ::v150(){vfunc_called(this, "_ZN9S248C3_nt4v150Ev");}
void  S248C3_nt ::v151(){vfunc_called(this, "_ZN9S248C3_nt4v151Ev");}
void  S248C3_nt ::v152(){vfunc_called(this, "_ZN9S248C3_nt4v152Ev");}
void  S248C3_nt ::v153(){vfunc_called(this, "_ZN9S248C3_nt4v153Ev");}
void  S248C3_nt ::v154(){vfunc_called(this, "_ZN9S248C3_nt4v154Ev");}
void  S248C3_nt ::v155(){vfunc_called(this, "_ZN9S248C3_nt4v155Ev");}
void  S248C3_nt ::v156(){vfunc_called(this, "_ZN9S248C3_nt4v156Ev");}
void  S248C3_nt ::v157(){vfunc_called(this, "_ZN9S248C3_nt4v157Ev");}
void  S248C3_nt ::v158(){vfunc_called(this, "_ZN9S248C3_nt4v158Ev");}
void  S248C3_nt ::v159(){vfunc_called(this, "_ZN9S248C3_nt4v159Ev");}
void  S248C3_nt ::v160(){vfunc_called(this, "_ZN9S248C3_nt4v160Ev");}
void  S248C3_nt ::v161(){vfunc_called(this, "_ZN9S248C3_nt4v161Ev");}
void  S248C3_nt ::v162(){vfunc_called(this, "_ZN9S248C3_nt4v162Ev");}
void  S248C3_nt ::v163(){vfunc_called(this, "_ZN9S248C3_nt4v163Ev");}
void  S248C3_nt ::v164(){vfunc_called(this, "_ZN9S248C3_nt4v164Ev");}
void  S248C3_nt ::v165(){vfunc_called(this, "_ZN9S248C3_nt4v165Ev");}
void  S248C3_nt ::v166(){vfunc_called(this, "_ZN9S248C3_nt4v166Ev");}
void  S248C3_nt ::v167(){vfunc_called(this, "_ZN9S248C3_nt4v167Ev");}
void  S248C3_nt ::v168(){vfunc_called(this, "_ZN9S248C3_nt4v168Ev");}
void  S248C3_nt ::v169(){vfunc_called(this, "_ZN9S248C3_nt4v169Ev");}
void  S248C3_nt ::v170(){vfunc_called(this, "_ZN9S248C3_nt4v170Ev");}
void  S248C3_nt ::v171(){vfunc_called(this, "_ZN9S248C3_nt4v171Ev");}
void  S248C3_nt ::v172(){vfunc_called(this, "_ZN9S248C3_nt4v172Ev");}
void  S248C3_nt ::v173(){vfunc_called(this, "_ZN9S248C3_nt4v173Ev");}
void  S248C3_nt ::v174(){vfunc_called(this, "_ZN9S248C3_nt4v174Ev");}
void  S248C3_nt ::v175(){vfunc_called(this, "_ZN9S248C3_nt4v175Ev");}
void  S248C3_nt ::v176(){vfunc_called(this, "_ZN9S248C3_nt4v176Ev");}
void  S248C3_nt ::v177(){vfunc_called(this, "_ZN9S248C3_nt4v177Ev");}
void  S248C3_nt ::v178(){vfunc_called(this, "_ZN9S248C3_nt4v178Ev");}
void  S248C3_nt ::v179(){vfunc_called(this, "_ZN9S248C3_nt4v179Ev");}
void  S248C3_nt ::v180(){vfunc_called(this, "_ZN9S248C3_nt4v180Ev");}
void  S248C3_nt ::v181(){vfunc_called(this, "_ZN9S248C3_nt4v181Ev");}
void  S248C3_nt ::v182(){vfunc_called(this, "_ZN9S248C3_nt4v182Ev");}
void  S248C3_nt ::v183(){vfunc_called(this, "_ZN9S248C3_nt4v183Ev");}
void  S248C3_nt ::v184(){vfunc_called(this, "_ZN9S248C3_nt4v184Ev");}
void  S248C3_nt ::v185(){vfunc_called(this, "_ZN9S248C3_nt4v185Ev");}
void  S248C3_nt ::v186(){vfunc_called(this, "_ZN9S248C3_nt4v186Ev");}
void  S248C3_nt ::v187(){vfunc_called(this, "_ZN9S248C3_nt4v187Ev");}
void  S248C3_nt ::v188(){vfunc_called(this, "_ZN9S248C3_nt4v188Ev");}
void  S248C3_nt ::v189(){vfunc_called(this, "_ZN9S248C3_nt4v189Ev");}
void  S248C3_nt ::v190(){vfunc_called(this, "_ZN9S248C3_nt4v190Ev");}
void  S248C3_nt ::v191(){vfunc_called(this, "_ZN9S248C3_nt4v191Ev");}
void  S248C3_nt ::v192(){vfunc_called(this, "_ZN9S248C3_nt4v192Ev");}
void  S248C3_nt ::v193(){vfunc_called(this, "_ZN9S248C3_nt4v193Ev");}
void  S248C3_nt ::v194(){vfunc_called(this, "_ZN9S248C3_nt4v194Ev");}
void  S248C3_nt ::v195(){vfunc_called(this, "_ZN9S248C3_nt4v195Ev");}
void  S248C3_nt ::v196(){vfunc_called(this, "_ZN9S248C3_nt4v196Ev");}
void  S248C3_nt ::v197(){vfunc_called(this, "_ZN9S248C3_nt4v197Ev");}
void  S248C3_nt ::v198(){vfunc_called(this, "_ZN9S248C3_nt4v198Ev");}
void  S248C3_nt ::v199(){vfunc_called(this, "_ZN9S248C3_nt4v199Ev");}
void  S248C3_nt ::v200(){vfunc_called(this, "_ZN9S248C3_nt4v200Ev");}
void  S248C3_nt ::v201(){vfunc_called(this, "_ZN9S248C3_nt4v201Ev");}
void  S248C3_nt ::v202(){vfunc_called(this, "_ZN9S248C3_nt4v202Ev");}
void  S248C3_nt ::v203(){vfunc_called(this, "_ZN9S248C3_nt4v203Ev");}
void  S248C3_nt ::v204(){vfunc_called(this, "_ZN9S248C3_nt4v204Ev");}
void  S248C3_nt ::v205(){vfunc_called(this, "_ZN9S248C3_nt4v205Ev");}
void  S248C3_nt ::v206(){vfunc_called(this, "_ZN9S248C3_nt4v206Ev");}
void  S248C3_nt ::v207(){vfunc_called(this, "_ZN9S248C3_nt4v207Ev");}
void  S248C3_nt ::v208(){vfunc_called(this, "_ZN9S248C3_nt4v208Ev");}
void  S248C3_nt ::v209(){vfunc_called(this, "_ZN9S248C3_nt4v209Ev");}
void  S248C3_nt ::v210(){vfunc_called(this, "_ZN9S248C3_nt4v210Ev");}
void  S248C3_nt ::v211(){vfunc_called(this, "_ZN9S248C3_nt4v211Ev");}
void  S248C3_nt ::v212(){vfunc_called(this, "_ZN9S248C3_nt4v212Ev");}
void  S248C3_nt ::v213(){vfunc_called(this, "_ZN9S248C3_nt4v213Ev");}
void  S248C3_nt ::v214(){vfunc_called(this, "_ZN9S248C3_nt4v214Ev");}
void  S248C3_nt ::v215(){vfunc_called(this, "_ZN9S248C3_nt4v215Ev");}
S248C3_nt ::S248C3_nt(){ note_ctor("S248C3_nt", this);} // tgen

//skip512 S248C3_nt

#else // __cplusplus

extern void _ZN9S248C3_ntC1Ev();
extern void _ZN9S248C3_ntD1Ev();
Name_Map name_map_S248C3_nt[] = {
  NSPAIR(_ZN9S248C3_ntC1Ev),
  NSPAIR(_ZN9S248C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S248C6_nt;
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
extern Class_Descriptor cd_S248C5_nt;
extern VTBL_ENTRY _ZTI9S248C5_nt[];
extern  VTBL_ENTRY _ZTV9S248C5_nt[];
extern Class_Descriptor cd_S248C4_nt;
extern VTBL_ENTRY _ZTI9S248C4_nt[];
extern  VTBL_ENTRY _ZTV9S248C4_nt[];
static Base_Class bases_S248C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S248C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S248C3_nt[];
extern void _ZN9S248C3_ntD1Ev();
extern void _ZN9S248C3_ntD0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
extern void _ZN9S248C5_nt3v69Ev();
extern void _ZN9S248C5_nt3v70Ev();
extern void _ZN9S248C4_nt3v71Ev();
extern void _ZN9S248C4_nt3v72Ev();
extern void _ZN9S248C4_nt3v73Ev();
extern void _ZN9S248C4_nt3v74Ev();
extern void _ZN9S248C4_nt3v75Ev();
extern void _ZN9S248C4_nt3v76Ev();
extern void _ZN9S248C4_nt3v77Ev();
extern void _ZN9S248C4_nt3v78Ev();
extern void _ZN9S248C4_nt3v79Ev();
extern void _ZN9S248C4_nt3v80Ev();
extern void _ZN9S248C4_nt3v81Ev();
extern void _ZN9S248C4_nt3v82Ev();
extern void _ZN9S248C4_nt3v83Ev();
extern void _ZN9S248C4_nt3v84Ev();
extern void _ZN9S248C4_nt3v85Ev();
extern void _ZN9S248C4_nt3v86Ev();
extern void _ZN9S248C4_nt3v87Ev();
extern void _ZN9S248C4_nt3v88Ev();
extern void _ZN9S248C4_nt3v89Ev();
extern void _ZN9S248C4_nt3v90Ev();
extern void _ZN9S248C4_nt3v91Ev();
extern void _ZN9S248C4_nt3v92Ev();
extern void _ZN9S248C4_nt3v93Ev();
extern void _ZN9S248C4_nt3v94Ev();
extern void _ZN9S248C4_nt3v95Ev();
extern void _ZN9S248C4_nt3v96Ev();
extern void _ZN9S248C4_nt3v97Ev();
extern void _ZN9S248C4_nt3v98Ev();
extern void _ZN9S248C4_nt3v99Ev();
extern void _ZN9S248C4_nt4v100Ev();
extern void _ZN9S248C4_nt4v101Ev();
extern void _ZN9S248C4_nt4v102Ev();
extern void _ZN9S248C4_nt4v103Ev();
extern void _ZN9S248C4_nt4v104Ev();
extern void _ZN9S248C4_nt4v105Ev();
extern void _ZN9S248C4_nt4v106Ev();
extern void _ZN9S248C4_nt4v107Ev();
extern void _ZN9S248C4_nt4v108Ev();
extern void _ZN9S248C4_nt4v109Ev();
extern void _ZN9S248C4_nt4v110Ev();
extern void _ZN9S248C4_nt4v111Ev();
extern void _ZN9S248C4_nt4v112Ev();
extern void _ZN9S248C4_nt4v113Ev();
extern void _ZN9S248C4_nt4v114Ev();
extern void _ZN9S248C4_nt4v115Ev();
extern void _ZN9S248C4_nt4v116Ev();
extern void _ZN9S248C4_nt4v117Ev();
extern void _ZN9S248C4_nt4v118Ev();
extern void _ZN9S248C4_nt4v119Ev();
extern void _ZN9S248C4_nt4v120Ev();
extern void _ZN9S248C4_nt4v121Ev();
extern void _ZN9S248C4_nt4v122Ev();
extern void _ZN9S248C4_nt4v123Ev();
extern void _ZN9S248C4_nt4v124Ev();
extern void _ZN9S248C4_nt4v125Ev();
extern void _ZN9S248C4_nt4v126Ev();
extern void _ZN9S248C4_nt4v127Ev();
extern void _ZN9S248C4_nt4v128Ev();
extern void _ZN9S248C4_nt4v129Ev();
extern void _ZN9S248C4_nt4v130Ev();
extern void _ZN9S248C4_nt4v131Ev();
extern void _ZN9S248C4_nt4v132Ev();
extern void _ZN9S248C4_nt4v133Ev();
extern void _ZN9S248C4_nt4v134Ev();
extern void _ZN9S248C4_nt4v135Ev();
extern void _ZN9S248C4_nt4v136Ev();
extern void _ZN9S248C4_nt4v137Ev();
extern void _ZN9S248C4_nt4v138Ev();
extern void _ZN9S248C4_nt4v139Ev();
extern void _ZN9S248C4_nt4v140Ev();
extern void _ZN9S248C4_nt4v141Ev();
extern void _ZN9S248C4_nt4v142Ev();
extern void _ZN9S248C4_nt4v143Ev();
extern void _ZN9S248C4_nt4v144Ev();
extern void _ZN9S248C4_nt4v145Ev();
extern void _ZN9S248C4_nt4v146Ev();
extern void _ZN9S248C3_nt4v147Ev();
extern void _ZN9S248C3_nt4v148Ev();
extern void _ZN9S248C3_nt4v149Ev();
extern void _ZN9S248C3_nt4v150Ev();
extern void _ZN9S248C3_nt4v151Ev();
extern void _ZN9S248C3_nt4v152Ev();
extern void _ZN9S248C3_nt4v153Ev();
extern void _ZN9S248C3_nt4v154Ev();
extern void _ZN9S248C3_nt4v155Ev();
extern void _ZN9S248C3_nt4v156Ev();
extern void _ZN9S248C3_nt4v157Ev();
extern void _ZN9S248C3_nt4v158Ev();
extern void _ZN9S248C3_nt4v159Ev();
extern void _ZN9S248C3_nt4v160Ev();
extern void _ZN9S248C3_nt4v161Ev();
extern void _ZN9S248C3_nt4v162Ev();
extern void _ZN9S248C3_nt4v163Ev();
extern void _ZN9S248C3_nt4v164Ev();
extern void _ZN9S248C3_nt4v165Ev();
extern void _ZN9S248C3_nt4v166Ev();
extern void _ZN9S248C3_nt4v167Ev();
extern void _ZN9S248C3_nt4v168Ev();
extern void _ZN9S248C3_nt4v169Ev();
extern void _ZN9S248C3_nt4v170Ev();
extern void _ZN9S248C3_nt4v171Ev();
extern void _ZN9S248C3_nt4v172Ev();
extern void _ZN9S248C3_nt4v173Ev();
extern void _ZN9S248C3_nt4v174Ev();
extern void _ZN9S248C3_nt4v175Ev();
extern void _ZN9S248C3_nt4v176Ev();
extern void _ZN9S248C3_nt4v177Ev();
extern void _ZN9S248C3_nt4v178Ev();
extern void _ZN9S248C3_nt4v179Ev();
extern void _ZN9S248C3_nt4v180Ev();
extern void _ZN9S248C3_nt4v181Ev();
extern void _ZN9S248C3_nt4v182Ev();
extern void _ZN9S248C3_nt4v183Ev();
extern void _ZN9S248C3_nt4v184Ev();
extern void _ZN9S248C3_nt4v185Ev();
extern void _ZN9S248C3_nt4v186Ev();
extern void _ZN9S248C3_nt4v187Ev();
extern void _ZN9S248C3_nt4v188Ev();
extern void _ZN9S248C3_nt4v189Ev();
extern void _ZN9S248C3_nt4v190Ev();
extern void _ZN9S248C3_nt4v191Ev();
extern void _ZN9S248C3_nt4v192Ev();
extern void _ZN9S248C3_nt4v193Ev();
extern void _ZN9S248C3_nt4v194Ev();
extern void _ZN9S248C3_nt4v195Ev();
extern void _ZN9S248C3_nt4v196Ev();
extern void _ZN9S248C3_nt4v197Ev();
extern void _ZN9S248C3_nt4v198Ev();
extern void _ZN9S248C3_nt4v199Ev();
extern void _ZN9S248C3_nt4v200Ev();
extern void _ZN9S248C3_nt4v201Ev();
extern void _ZN9S248C3_nt4v202Ev();
extern void _ZN9S248C3_nt4v203Ev();
extern void _ZN9S248C3_nt4v204Ev();
extern void _ZN9S248C3_nt4v205Ev();
extern void _ZN9S248C3_nt4v206Ev();
extern void _ZN9S248C3_nt4v207Ev();
extern void _ZN9S248C3_nt4v208Ev();
extern void _ZN9S248C3_nt4v209Ev();
extern void _ZN9S248C3_nt4v210Ev();
extern void _ZN9S248C3_nt4v211Ev();
extern void _ZN9S248C3_nt4v212Ev();
extern void _ZN9S248C3_nt4v213Ev();
extern void _ZN9S248C3_nt4v214Ev();
extern void _ZN9S248C3_nt4v215Ev();
static  VTBL_ENTRY vtc_S248C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S248C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S248C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S248C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v215Ev,
};
extern VTBL_ENTRY _ZTI9S248C3_nt[];
VTBL_ENTRY *P__ZTI9S248C3_nt = _ZTI9S248C3_nt; 
extern  VTBL_ENTRY _ZTV9S248C3_nt[];
Class_Descriptor cd_S248C3_nt = {  "S248C3_nt", // class name
  bases_S248C3_nt, 3,
  &(vtc_S248C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,908), // object size
  NSPAIRA(_ZTI9S248C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S248C3_nt),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C48_nt  {
  int s248c48f0;
  char s248c48f1[2];
  void  mf248c48(); // _ZN10S248C48_nt8mf248c48Ev
};
//SIG(-1 S248C48_nt) C1{ m Fi Fc[2]}


void  S248C48_nt ::mf248c48(){}

//skip512 S248C48_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C2  : S248C3_nt {
  ::S248C43 s248c2f0;
  void *s248c2f1[2];
  char s248c2f2[2];
  ::S248C48_nt s248c2f3;
  ::S248C48_nt s248c2f4[2];
  ::S248C23_nt s248c2f5;
  ::S248C23_nt s248c2f6;
  unsigned int s248c2f7:1;
  ::S248C7_nt s248c2f8;
  unsigned int s248c2f9:1;
  ::S248C20_nt s248c2f10;
  ::S248C20_nt s248c2f11;
  ::S248C20_nt s248c2f12;
  virtual  ~S248C2(); // _ZN6S248C2D1Ev
  virtual void  v216(); // _ZN6S248C24v216Ev
  virtual void  v217(); // _ZN6S248C24v217Ev
  virtual void  v218(); // _ZN6S248C24v218Ev
  virtual void  v219(); // _ZN6S248C24v219Ev
  virtual void  v220(); // _ZN6S248C24v220Ev
  virtual void  v221(); // _ZN6S248C24v221Ev
  virtual void  v222(); // _ZN6S248C24v222Ev
  virtual void  v223(); // _ZN6S248C24v223Ev
  virtual void  v224(); // _ZN6S248C24v224Ev
  virtual void  v225(); // _ZN6S248C24v225Ev
  virtual void  v226(); // _ZN6S248C24v226Ev
  virtual void  v227(); // _ZN6S248C24v227Ev
  virtual void  v228(); // _ZN6S248C24v228Ev
  virtual void  v229(); // _ZN6S248C24v229Ev
  virtual void  v230(); // _ZN6S248C24v230Ev
  virtual void  v231(); // _ZN6S248C24v231Ev
  virtual void  v232(); // _ZN6S248C24v232Ev
  virtual void  v233(); // _ZN6S248C24v233Ev
  virtual void  v234(); // _ZN6S248C24v234Ev
  virtual void  v235(); // _ZN6S248C24v235Ev
  virtual void  v236(); // _ZN6S248C24v236Ev
  virtual void  v237(); // _ZN6S248C24v237Ev
  virtual void  v238(); // _ZN6S248C24v238Ev
  S248C2(); // tgen
};
//SIG(-1 S248C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 FC7{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fp FC11{ BC12{ BC10}} FC11 FC11 FC13{ BC14{ BC10}} Fc Fi Fp FC6 FC6 FC6 FC6 FC6 FC6 FC15{ m Fp FC6} FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 FC16{ BC17{ m Fi[4]}} FC6 Fp[2] FC18{ m FC6 Fp FC16 Fp} FC19{ m Fp[8] Fc[4]} Fi FC20{ m Fp[5] FC21{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC6[4] FC22{ m FC23{ m Fi[3]} FC24{ m} FC25{ BC26{ m Fi[2] Fc[2]} Fi} Fc} FC23 Fi FC27{ m FC28{ BC29{ m Fp[2]}} Fc FC30{ BC31{ BC32{ BC10}}} Fi FC6 FC6 Fp} FC27 Fp FC23 FC13 FC33{ BC34{ BC10}} Fi:1 Fi:1 Fi:1 FC24 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15 FC15} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 FC33 Fp[2] Fc[2] FC35{ m Fi Fc[2]} FC35[2] FC18 FC18 Fi:1 FC6 Fi:1 FC15 FC15 FC15}


 S248C2 ::~S248C2(){ note_dtor("S248C2", this);}
void  S248C2 ::v216(){vfunc_called(this, "_ZN6S248C24v216Ev");}
void  S248C2 ::v217(){vfunc_called(this, "_ZN6S248C24v217Ev");}
void  S248C2 ::v218(){vfunc_called(this, "_ZN6S248C24v218Ev");}
void  S248C2 ::v219(){vfunc_called(this, "_ZN6S248C24v219Ev");}
void  S248C2 ::v220(){vfunc_called(this, "_ZN6S248C24v220Ev");}
void  S248C2 ::v221(){vfunc_called(this, "_ZN6S248C24v221Ev");}
void  S248C2 ::v222(){vfunc_called(this, "_ZN6S248C24v222Ev");}
void  S248C2 ::v223(){vfunc_called(this, "_ZN6S248C24v223Ev");}
void  S248C2 ::v224(){vfunc_called(this, "_ZN6S248C24v224Ev");}
void  S248C2 ::v225(){vfunc_called(this, "_ZN6S248C24v225Ev");}
void  S248C2 ::v226(){vfunc_called(this, "_ZN6S248C24v226Ev");}
void  S248C2 ::v227(){vfunc_called(this, "_ZN6S248C24v227Ev");}
void  S248C2 ::v228(){vfunc_called(this, "_ZN6S248C24v228Ev");}
void  S248C2 ::v229(){vfunc_called(this, "_ZN6S248C24v229Ev");}
void  S248C2 ::v230(){vfunc_called(this, "_ZN6S248C24v230Ev");}
void  S248C2 ::v231(){vfunc_called(this, "_ZN6S248C24v231Ev");}
void  S248C2 ::v232(){vfunc_called(this, "_ZN6S248C24v232Ev");}
void  S248C2 ::v233(){vfunc_called(this, "_ZN6S248C24v233Ev");}
void  S248C2 ::v234(){vfunc_called(this, "_ZN6S248C24v234Ev");}
void  S248C2 ::v235(){vfunc_called(this, "_ZN6S248C24v235Ev");}
void  S248C2 ::v236(){vfunc_called(this, "_ZN6S248C24v236Ev");}
void  S248C2 ::v237(){vfunc_called(this, "_ZN6S248C24v237Ev");}
void  S248C2 ::v238(){vfunc_called(this, "_ZN6S248C24v238Ev");}
S248C2 ::S248C2(){ note_ctor("S248C2", this);} // tgen

static void Test_S248C2()
{
  extern Class_Descriptor cd_S248C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(180,269)];
    init_test(&cd_S248C2, buf);
    S248C2 *dp, &lv = *(dp=new (buf) S248C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1432,1072), "sizeof(S248C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C2)");
    check_base_class_offset(lv, (S248C6_nt*)(S248C5_nt*)(S248C4_nt*)(S248C3_nt*), 0, "S248C2");
    check_base_class_offset(lv, (S248C5_nt*)(S248C4_nt*)(S248C3_nt*), 0, "S248C2");
    check_base_class_offset(lv, (S248C4_nt*)(S248C3_nt*), 0, "S248C2");
    check_base_class_offset(lv, (S248C3_nt*), 0, "S248C2");
    check_field_offset(lv, s248c2f0, ABISELECT(1224,908), "S248C2.s248c2f0");
    check_field_offset(lv, s248c2f1, ABISELECT(1240,920), "S248C2.s248c2f1");
    check_field_offset(lv, s248c2f2, ABISELECT(1256,928), "S248C2.s248c2f2");
    check_field_offset(lv, s248c2f3, ABISELECT(1260,932), "S248C2.s248c2f3");
    check_field_offset(lv, s248c2f4, ABISELECT(1268,940), "S248C2.s248c2f4");
    check_field_offset(lv, s248c2f5, ABISELECT(1288,956), "S248C2.s248c2f5");
    check_field_offset(lv, s248c2f6, ABISELECT(1328,988), "S248C2.s248c2f6");
    set_bf_and_test(lv, s248c2f7, ABISELECT(1368,1020), 0, 1, 1, "S248C2");
    check_field_offset(lv, s248c2f8, ABISELECT(1372,1024), "S248C2.s248c2f8");
    set_bf_and_test(lv, s248c2f9, ABISELECT(1380,1032), 0, 1, 1, "S248C2");
    check_field_offset(lv, s248c2f10, ABISELECT(1384,1036), "S248C2.s248c2f10");
    check_field_offset(lv, s248c2f11, ABISELECT(1400,1048), "S248C2.s248c2f11");
    check_field_offset(lv, s248c2f12, ABISELECT(1416,1060), "S248C2.s248c2f12");
    test_class_info(&lv, &cd_S248C2);
    dp->~S248C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C2(Test_S248C2, "S248C2", ABISELECT(1432,1072));

#else // __cplusplus

extern void _ZN6S248C2C1Ev();
extern void _ZN6S248C2D1Ev();
Name_Map name_map_S248C2[] = {
  NSPAIR(_ZN6S248C2C1Ev),
  NSPAIR(_ZN6S248C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S248C6_nt;
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
extern Class_Descriptor cd_S248C5_nt;
extern VTBL_ENTRY _ZTI9S248C5_nt[];
extern  VTBL_ENTRY _ZTV9S248C5_nt[];
extern Class_Descriptor cd_S248C4_nt;
extern VTBL_ENTRY _ZTI9S248C4_nt[];
extern  VTBL_ENTRY _ZTV9S248C4_nt[];
extern Class_Descriptor cd_S248C3_nt;
extern VTBL_ENTRY _ZTI9S248C3_nt[];
extern  VTBL_ENTRY _ZTV9S248C3_nt[];
static Base_Class bases_S248C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S248C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S248C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S248C2[];
extern void _ZN6S248C2D1Ev();
extern void _ZN6S248C2D0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
extern void _ZN9S248C5_nt3v69Ev();
extern void _ZN9S248C5_nt3v70Ev();
extern void _ZN9S248C4_nt3v71Ev();
extern void _ZN9S248C4_nt3v72Ev();
extern void _ZN9S248C4_nt3v73Ev();
extern void _ZN9S248C4_nt3v74Ev();
extern void _ZN9S248C4_nt3v75Ev();
extern void _ZN9S248C4_nt3v76Ev();
extern void _ZN9S248C4_nt3v77Ev();
extern void _ZN9S248C4_nt3v78Ev();
extern void _ZN9S248C4_nt3v79Ev();
extern void _ZN9S248C4_nt3v80Ev();
extern void _ZN9S248C4_nt3v81Ev();
extern void _ZN9S248C4_nt3v82Ev();
extern void _ZN9S248C4_nt3v83Ev();
extern void _ZN9S248C4_nt3v84Ev();
extern void _ZN9S248C4_nt3v85Ev();
extern void _ZN9S248C4_nt3v86Ev();
extern void _ZN9S248C4_nt3v87Ev();
extern void _ZN9S248C4_nt3v88Ev();
extern void _ZN9S248C4_nt3v89Ev();
extern void _ZN9S248C4_nt3v90Ev();
extern void _ZN9S248C4_nt3v91Ev();
extern void _ZN9S248C4_nt3v92Ev();
extern void _ZN9S248C4_nt3v93Ev();
extern void _ZN9S248C4_nt3v94Ev();
extern void _ZN9S248C4_nt3v95Ev();
extern void _ZN9S248C4_nt3v96Ev();
extern void _ZN9S248C4_nt3v97Ev();
extern void _ZN9S248C4_nt3v98Ev();
extern void _ZN9S248C4_nt3v99Ev();
extern void _ZN9S248C4_nt4v100Ev();
extern void _ZN9S248C4_nt4v101Ev();
extern void _ZN9S248C4_nt4v102Ev();
extern void _ZN9S248C4_nt4v103Ev();
extern void _ZN9S248C4_nt4v104Ev();
extern void _ZN9S248C4_nt4v105Ev();
extern void _ZN9S248C4_nt4v106Ev();
extern void _ZN9S248C4_nt4v107Ev();
extern void _ZN9S248C4_nt4v108Ev();
extern void _ZN9S248C4_nt4v109Ev();
extern void _ZN9S248C4_nt4v110Ev();
extern void _ZN9S248C4_nt4v111Ev();
extern void _ZN9S248C4_nt4v112Ev();
extern void _ZN9S248C4_nt4v113Ev();
extern void _ZN9S248C4_nt4v114Ev();
extern void _ZN9S248C4_nt4v115Ev();
extern void _ZN9S248C4_nt4v116Ev();
extern void _ZN9S248C4_nt4v117Ev();
extern void _ZN9S248C4_nt4v118Ev();
extern void _ZN9S248C4_nt4v119Ev();
extern void _ZN9S248C4_nt4v120Ev();
extern void _ZN9S248C4_nt4v121Ev();
extern void _ZN9S248C4_nt4v122Ev();
extern void _ZN9S248C4_nt4v123Ev();
extern void _ZN9S248C4_nt4v124Ev();
extern void _ZN9S248C4_nt4v125Ev();
extern void _ZN9S248C4_nt4v126Ev();
extern void _ZN9S248C4_nt4v127Ev();
extern void _ZN9S248C4_nt4v128Ev();
extern void _ZN9S248C4_nt4v129Ev();
extern void _ZN9S248C4_nt4v130Ev();
extern void _ZN9S248C4_nt4v131Ev();
extern void _ZN9S248C4_nt4v132Ev();
extern void _ZN9S248C4_nt4v133Ev();
extern void _ZN9S248C4_nt4v134Ev();
extern void _ZN9S248C4_nt4v135Ev();
extern void _ZN9S248C4_nt4v136Ev();
extern void _ZN9S248C4_nt4v137Ev();
extern void _ZN9S248C4_nt4v138Ev();
extern void _ZN9S248C4_nt4v139Ev();
extern void _ZN9S248C4_nt4v140Ev();
extern void _ZN9S248C4_nt4v141Ev();
extern void _ZN9S248C4_nt4v142Ev();
extern void _ZN9S248C4_nt4v143Ev();
extern void _ZN9S248C4_nt4v144Ev();
extern void _ZN9S248C4_nt4v145Ev();
extern void _ZN9S248C4_nt4v146Ev();
extern void _ZN9S248C3_nt4v147Ev();
extern void _ZN9S248C3_nt4v148Ev();
extern void _ZN9S248C3_nt4v149Ev();
extern void _ZN9S248C3_nt4v150Ev();
extern void _ZN9S248C3_nt4v151Ev();
extern void _ZN9S248C3_nt4v152Ev();
extern void _ZN9S248C3_nt4v153Ev();
extern void _ZN9S248C3_nt4v154Ev();
extern void _ZN9S248C3_nt4v155Ev();
extern void _ZN9S248C3_nt4v156Ev();
extern void _ZN9S248C3_nt4v157Ev();
extern void _ZN9S248C3_nt4v158Ev();
extern void _ZN9S248C3_nt4v159Ev();
extern void _ZN9S248C3_nt4v160Ev();
extern void _ZN9S248C3_nt4v161Ev();
extern void _ZN9S248C3_nt4v162Ev();
extern void _ZN9S248C3_nt4v163Ev();
extern void _ZN9S248C3_nt4v164Ev();
extern void _ZN9S248C3_nt4v165Ev();
extern void _ZN9S248C3_nt4v166Ev();
extern void _ZN9S248C3_nt4v167Ev();
extern void _ZN9S248C3_nt4v168Ev();
extern void _ZN9S248C3_nt4v169Ev();
extern void _ZN9S248C3_nt4v170Ev();
extern void _ZN9S248C3_nt4v171Ev();
extern void _ZN9S248C3_nt4v172Ev();
extern void _ZN9S248C3_nt4v173Ev();
extern void _ZN9S248C3_nt4v174Ev();
extern void _ZN9S248C3_nt4v175Ev();
extern void _ZN9S248C3_nt4v176Ev();
extern void _ZN9S248C3_nt4v177Ev();
extern void _ZN9S248C3_nt4v178Ev();
extern void _ZN9S248C3_nt4v179Ev();
extern void _ZN9S248C3_nt4v180Ev();
extern void _ZN9S248C3_nt4v181Ev();
extern void _ZN9S248C3_nt4v182Ev();
extern void _ZN9S248C3_nt4v183Ev();
extern void _ZN9S248C3_nt4v184Ev();
extern void _ZN9S248C3_nt4v185Ev();
extern void _ZN9S248C3_nt4v186Ev();
extern void _ZN9S248C3_nt4v187Ev();
extern void _ZN9S248C3_nt4v188Ev();
extern void _ZN9S248C3_nt4v189Ev();
extern void _ZN9S248C3_nt4v190Ev();
extern void _ZN9S248C3_nt4v191Ev();
extern void _ZN9S248C3_nt4v192Ev();
extern void _ZN9S248C3_nt4v193Ev();
extern void _ZN9S248C3_nt4v194Ev();
extern void _ZN9S248C3_nt4v195Ev();
extern void _ZN9S248C3_nt4v196Ev();
extern void _ZN9S248C3_nt4v197Ev();
extern void _ZN9S248C3_nt4v198Ev();
extern void _ZN9S248C3_nt4v199Ev();
extern void _ZN9S248C3_nt4v200Ev();
extern void _ZN9S248C3_nt4v201Ev();
extern void _ZN9S248C3_nt4v202Ev();
extern void _ZN9S248C3_nt4v203Ev();
extern void _ZN9S248C3_nt4v204Ev();
extern void _ZN9S248C3_nt4v205Ev();
extern void _ZN9S248C3_nt4v206Ev();
extern void _ZN9S248C3_nt4v207Ev();
extern void _ZN9S248C3_nt4v208Ev();
extern void _ZN9S248C3_nt4v209Ev();
extern void _ZN9S248C3_nt4v210Ev();
extern void _ZN9S248C3_nt4v211Ev();
extern void _ZN9S248C3_nt4v212Ev();
extern void _ZN9S248C3_nt4v213Ev();
extern void _ZN9S248C3_nt4v214Ev();
extern void _ZN9S248C3_nt4v215Ev();
extern void _ZN6S248C24v216Ev();
extern void _ZN6S248C24v217Ev();
extern void _ZN6S248C24v218Ev();
extern void _ZN6S248C24v219Ev();
extern void _ZN6S248C24v220Ev();
extern void _ZN6S248C24v221Ev();
extern void _ZN6S248C24v222Ev();
extern void _ZN6S248C24v223Ev();
extern void _ZN6S248C24v224Ev();
extern void _ZN6S248C24v225Ev();
extern void _ZN6S248C24v226Ev();
extern void _ZN6S248C24v227Ev();
extern void _ZN6S248C24v228Ev();
extern void _ZN6S248C24v229Ev();
extern void _ZN6S248C24v230Ev();
extern void _ZN6S248C24v231Ev();
extern void _ZN6S248C24v232Ev();
extern void _ZN6S248C24v233Ev();
extern void _ZN6S248C24v234Ev();
extern void _ZN6S248C24v235Ev();
extern void _ZN6S248C24v236Ev();
extern void _ZN6S248C24v237Ev();
extern void _ZN6S248C24v238Ev();
static  VTBL_ENTRY vtc_S248C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S248C2[0]),
  (VTBL_ENTRY)&_ZN6S248C2D1Ev,
  (VTBL_ENTRY)&_ZN6S248C2D0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN6S248C24v216Ev,
  (VTBL_ENTRY)&_ZN6S248C24v217Ev,
  (VTBL_ENTRY)&_ZN6S248C24v218Ev,
  (VTBL_ENTRY)&_ZN6S248C24v219Ev,
  (VTBL_ENTRY)&_ZN6S248C24v220Ev,
  (VTBL_ENTRY)&_ZN6S248C24v221Ev,
  (VTBL_ENTRY)&_ZN6S248C24v222Ev,
  (VTBL_ENTRY)&_ZN6S248C24v223Ev,
  (VTBL_ENTRY)&_ZN6S248C24v224Ev,
  (VTBL_ENTRY)&_ZN6S248C24v225Ev,
  (VTBL_ENTRY)&_ZN6S248C24v226Ev,
  (VTBL_ENTRY)&_ZN6S248C24v227Ev,
  (VTBL_ENTRY)&_ZN6S248C24v228Ev,
  (VTBL_ENTRY)&_ZN6S248C24v229Ev,
  (VTBL_ENTRY)&_ZN6S248C24v230Ev,
  (VTBL_ENTRY)&_ZN6S248C24v231Ev,
  (VTBL_ENTRY)&_ZN6S248C24v232Ev,
  (VTBL_ENTRY)&_ZN6S248C24v233Ev,
  (VTBL_ENTRY)&_ZN6S248C24v234Ev,
  (VTBL_ENTRY)&_ZN6S248C24v235Ev,
  (VTBL_ENTRY)&_ZN6S248C24v236Ev,
  (VTBL_ENTRY)&_ZN6S248C24v237Ev,
  (VTBL_ENTRY)&_ZN6S248C24v238Ev,
};
extern VTBL_ENTRY _ZTI6S248C2[];
extern  VTBL_ENTRY _ZTV6S248C2[];
Class_Descriptor cd_S248C2 = {  "S248C2", // class name
  bases_S248C2, 4,
  &(vtc_S248C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1432,1072), // object size
  NSPAIRA(_ZTI6S248C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S248C2),238, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S248C1  : S248C2 {
  ::S248C7_nt s248c1f0;
  ::S248C7_nt s248c1f1;
  void *s248c1f2[2];
  virtual  ~S248C1(); // _ZN6S248C1D1Ev
  virtual void  v1(); // _ZN6S248C12v1Ev
  virtual void  v2(); // _ZN6S248C12v2Ev
  virtual void  v3(); // _ZN6S248C12v3Ev
  virtual void  v4(); // _ZN6S248C12v4Ev
  S248C1(); // tgen
};
//SIG(1 S248C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 FC8{ m Fi[4] Fc[9]} Fi Fi:1 Fi:1 Fi:1 Fi:1 FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fp FC12{ BC13{ BC11}} FC12 FC12 FC14{ BC15{ BC11}} Fc Fi Fp FC7 FC7 FC7 FC7 FC7 FC7 FC16{ m Fp FC7} FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 FC17{ BC18{ m Fi[4]}} FC7 Fp[2] FC19{ m FC7 Fp FC17 Fp} FC20{ m Fp[8] Fc[4]} Fi FC21{ m Fp[5] FC22{ m Fi[4] Fc[4]} Fi:1 Fi:1 Fi Fc[8]} Fi[4] FC7[4] FC23{ m FC24{ m Fi[3]} FC25{ m} FC26{ BC27{ m Fi[2] Fc[2]} Fi} Fc} FC24 Fi FC28{ m FC29{ BC30{ m Fp[2]}} Fc FC31{ BC32{ BC33{ BC11}}} Fi FC7 FC7 Fp} FC28 Fp FC24 FC14 FC34{ BC35{ BC11}} Fi:1 Fi:1 Fi:1 FC25 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16 FC16} vd v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 FC34 Fp[2] Fc[2] FC36{ m Fi Fc[2]} FC36[2] FC19 FC19 Fi:1 FC7 Fi:1 FC16 FC16 FC16} vd v1 v2 v3 v4 FC7 FC7 Fp[2]}


 S248C1 ::~S248C1(){ note_dtor("S248C1", this);}
void  S248C1 ::v1(){vfunc_called(this, "_ZN6S248C12v1Ev");}
void  S248C1 ::v2(){vfunc_called(this, "_ZN6S248C12v2Ev");}
void  S248C1 ::v3(){vfunc_called(this, "_ZN6S248C12v3Ev");}
void  S248C1 ::v4(){vfunc_called(this, "_ZN6S248C12v4Ev");}
S248C1 ::S248C1(){ note_ctor("S248C1", this);} // tgen

static void Test_S248C1()
{
  extern Class_Descriptor cd_S248C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(184,275)];
    init_test(&cd_S248C1, buf);
    S248C1 *dp, &lv = *(dp=new (buf) S248C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1464,1096), "sizeof(S248C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S248C1)");
    check_base_class_offset(lv, (S248C6_nt*)(S248C5_nt*)(S248C4_nt*)(S248C3_nt*)(S248C2*), 0, "S248C1");
    check_base_class_offset(lv, (S248C5_nt*)(S248C4_nt*)(S248C3_nt*)(S248C2*), 0, "S248C1");
    check_base_class_offset(lv, (S248C4_nt*)(S248C3_nt*)(S248C2*), 0, "S248C1");
    check_base_class_offset(lv, (S248C3_nt*)(S248C2*), 0, "S248C1");
    check_base_class_offset(lv, (S248C2*), 0, "S248C1");
    check_field_offset(lv, s248c1f0, ABISELECT(1432,1072), "S248C1.s248c1f0");
    check_field_offset(lv, s248c1f1, ABISELECT(1440,1080), "S248C1.s248c1f1");
    check_field_offset(lv, s248c1f2, ABISELECT(1448,1088), "S248C1.s248c1f2");
    test_class_info(&lv, &cd_S248C1);
    dp->~S248C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS248C1(Test_S248C1, "S248C1", ABISELECT(1464,1096));

#else // __cplusplus

extern void _ZN6S248C1C1Ev();
extern void _ZN6S248C1D1Ev();
Name_Map name_map_S248C1[] = {
  NSPAIR(_ZN6S248C1C1Ev),
  NSPAIR(_ZN6S248C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S248C6_nt;
extern VTBL_ENTRY _ZTI9S248C6_nt[];
extern  VTBL_ENTRY _ZTV9S248C6_nt[];
extern Class_Descriptor cd_S248C5_nt;
extern VTBL_ENTRY _ZTI9S248C5_nt[];
extern  VTBL_ENTRY _ZTV9S248C5_nt[];
extern Class_Descriptor cd_S248C4_nt;
extern VTBL_ENTRY _ZTI9S248C4_nt[];
extern  VTBL_ENTRY _ZTV9S248C4_nt[];
extern Class_Descriptor cd_S248C3_nt;
extern VTBL_ENTRY _ZTI9S248C3_nt[];
extern  VTBL_ENTRY _ZTV9S248C3_nt[];
extern Class_Descriptor cd_S248C2;
extern VTBL_ENTRY _ZTI6S248C2[];
extern  VTBL_ENTRY _ZTV6S248C2[];
static Base_Class bases_S248C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S248C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S248C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S248C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S248C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S248C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S248C1[];
extern void _ZN6S248C1D1Ev();
extern void _ZN6S248C1D0Ev();
extern void _ZN9S248C6_nt2v5Ev();
extern void _ZN9S248C6_nt2v6Ev();
extern void _ZN9S248C6_nt2v7Ev();
extern void _ZN9S248C6_nt2v8Ev();
extern void _ZN9S248C6_nt2v9Ev();
extern void _ZN9S248C6_nt3v10Ev();
extern void _ZN9S248C6_nt3v11Ev();
extern void _ZN9S248C6_nt3v12Ev();
extern void _ZN9S248C6_nt3v13Ev();
extern void _ZN9S248C6_nt3v14Ev();
extern void _ZN9S248C6_nt3v15Ev();
extern void _ZN9S248C6_nt3v16Ev();
extern void _ZN9S248C6_nt3v17Ev();
extern void _ZN9S248C6_nt3v18Ev();
extern void _ZN9S248C6_nt3v19Ev();
extern void _ZN9S248C6_nt3v20Ev();
extern void _ZN9S248C6_nt3v21Ev();
extern void _ZN9S248C6_nt3v22Ev();
extern void _ZN9S248C6_nt3v23Ev();
extern void _ZN9S248C6_nt3v24Ev();
extern void _ZN9S248C6_nt3v25Ev();
extern void _ZN9S248C6_nt3v26Ev();
extern void _ZN9S248C6_nt3v27Ev();
extern void _ZN9S248C6_nt3v28Ev();
extern void _ZN9S248C6_nt3v29Ev();
extern void _ZN9S248C6_nt3v30Ev();
extern void _ZN9S248C6_nt3v31Ev();
extern void _ZN9S248C6_nt3v32Ev();
extern void _ZN9S248C6_nt3v33Ev();
extern void _ZN9S248C6_nt3v34Ev();
extern void _ZN9S248C6_nt3v35Ev();
extern void _ZN9S248C6_nt3v36Ev();
extern void _ZN9S248C6_nt3v37Ev();
extern void _ZN9S248C6_nt3v38Ev();
extern void _ZN9S248C6_nt3v39Ev();
extern void _ZN9S248C6_nt3v40Ev();
extern void _ZN9S248C6_nt3v41Ev();
extern void _ZN9S248C6_nt3v42Ev();
extern void _ZN9S248C6_nt3v43Ev();
extern void _ZN9S248C6_nt3v44Ev();
extern void _ZN9S248C6_nt3v45Ev();
extern void _ZN9S248C6_nt3v46Ev();
extern void _ZN9S248C6_nt3v47Ev();
extern void _ZN9S248C6_nt3v48Ev();
extern void _ZN9S248C6_nt3v49Ev();
extern void _ZN9S248C6_nt3v50Ev();
extern void _ZN9S248C6_nt3v51Ev();
extern void _ZN9S248C6_nt3v52Ev();
extern void _ZN9S248C6_nt3v53Ev();
extern void _ZN9S248C6_nt3v54Ev();
extern void _ZN9S248C6_nt3v55Ev();
extern void _ZN9S248C6_nt3v56Ev();
extern void _ZN9S248C6_nt3v57Ev();
extern void _ZN9S248C6_nt3v58Ev();
extern void _ZN9S248C6_nt3v59Ev();
extern void _ZN9S248C6_nt3v60Ev();
extern void _ZN9S248C6_nt3v61Ev();
extern void _ZN9S248C6_nt3v62Ev();
extern void _ZN9S248C6_nt3v63Ev();
extern void _ZN9S248C6_nt3v64Ev();
extern void _ZN9S248C6_nt3v65Ev();
extern void _ZN9S248C6_nt3v66Ev();
extern void _ZN9S248C6_nt3v67Ev();
extern void _ZN9S248C6_nt3v68Ev();
extern void _ZN9S248C5_nt3v69Ev();
extern void _ZN9S248C5_nt3v70Ev();
extern void _ZN9S248C4_nt3v71Ev();
extern void _ZN9S248C4_nt3v72Ev();
extern void _ZN9S248C4_nt3v73Ev();
extern void _ZN9S248C4_nt3v74Ev();
extern void _ZN9S248C4_nt3v75Ev();
extern void _ZN9S248C4_nt3v76Ev();
extern void _ZN9S248C4_nt3v77Ev();
extern void _ZN9S248C4_nt3v78Ev();
extern void _ZN9S248C4_nt3v79Ev();
extern void _ZN9S248C4_nt3v80Ev();
extern void _ZN9S248C4_nt3v81Ev();
extern void _ZN9S248C4_nt3v82Ev();
extern void _ZN9S248C4_nt3v83Ev();
extern void _ZN9S248C4_nt3v84Ev();
extern void _ZN9S248C4_nt3v85Ev();
extern void _ZN9S248C4_nt3v86Ev();
extern void _ZN9S248C4_nt3v87Ev();
extern void _ZN9S248C4_nt3v88Ev();
extern void _ZN9S248C4_nt3v89Ev();
extern void _ZN9S248C4_nt3v90Ev();
extern void _ZN9S248C4_nt3v91Ev();
extern void _ZN9S248C4_nt3v92Ev();
extern void _ZN9S248C4_nt3v93Ev();
extern void _ZN9S248C4_nt3v94Ev();
extern void _ZN9S248C4_nt3v95Ev();
extern void _ZN9S248C4_nt3v96Ev();
extern void _ZN9S248C4_nt3v97Ev();
extern void _ZN9S248C4_nt3v98Ev();
extern void _ZN9S248C4_nt3v99Ev();
extern void _ZN9S248C4_nt4v100Ev();
extern void _ZN9S248C4_nt4v101Ev();
extern void _ZN9S248C4_nt4v102Ev();
extern void _ZN9S248C4_nt4v103Ev();
extern void _ZN9S248C4_nt4v104Ev();
extern void _ZN9S248C4_nt4v105Ev();
extern void _ZN9S248C4_nt4v106Ev();
extern void _ZN9S248C4_nt4v107Ev();
extern void _ZN9S248C4_nt4v108Ev();
extern void _ZN9S248C4_nt4v109Ev();
extern void _ZN9S248C4_nt4v110Ev();
extern void _ZN9S248C4_nt4v111Ev();
extern void _ZN9S248C4_nt4v112Ev();
extern void _ZN9S248C4_nt4v113Ev();
extern void _ZN9S248C4_nt4v114Ev();
extern void _ZN9S248C4_nt4v115Ev();
extern void _ZN9S248C4_nt4v116Ev();
extern void _ZN9S248C4_nt4v117Ev();
extern void _ZN9S248C4_nt4v118Ev();
extern void _ZN9S248C4_nt4v119Ev();
extern void _ZN9S248C4_nt4v120Ev();
extern void _ZN9S248C4_nt4v121Ev();
extern void _ZN9S248C4_nt4v122Ev();
extern void _ZN9S248C4_nt4v123Ev();
extern void _ZN9S248C4_nt4v124Ev();
extern void _ZN9S248C4_nt4v125Ev();
extern void _ZN9S248C4_nt4v126Ev();
extern void _ZN9S248C4_nt4v127Ev();
extern void _ZN9S248C4_nt4v128Ev();
extern void _ZN9S248C4_nt4v129Ev();
extern void _ZN9S248C4_nt4v130Ev();
extern void _ZN9S248C4_nt4v131Ev();
extern void _ZN9S248C4_nt4v132Ev();
extern void _ZN9S248C4_nt4v133Ev();
extern void _ZN9S248C4_nt4v134Ev();
extern void _ZN9S248C4_nt4v135Ev();
extern void _ZN9S248C4_nt4v136Ev();
extern void _ZN9S248C4_nt4v137Ev();
extern void _ZN9S248C4_nt4v138Ev();
extern void _ZN9S248C4_nt4v139Ev();
extern void _ZN9S248C4_nt4v140Ev();
extern void _ZN9S248C4_nt4v141Ev();
extern void _ZN9S248C4_nt4v142Ev();
extern void _ZN9S248C4_nt4v143Ev();
extern void _ZN9S248C4_nt4v144Ev();
extern void _ZN9S248C4_nt4v145Ev();
extern void _ZN9S248C4_nt4v146Ev();
extern void _ZN9S248C3_nt4v147Ev();
extern void _ZN9S248C3_nt4v148Ev();
extern void _ZN9S248C3_nt4v149Ev();
extern void _ZN9S248C3_nt4v150Ev();
extern void _ZN9S248C3_nt4v151Ev();
extern void _ZN9S248C3_nt4v152Ev();
extern void _ZN9S248C3_nt4v153Ev();
extern void _ZN9S248C3_nt4v154Ev();
extern void _ZN9S248C3_nt4v155Ev();
extern void _ZN9S248C3_nt4v156Ev();
extern void _ZN9S248C3_nt4v157Ev();
extern void _ZN9S248C3_nt4v158Ev();
extern void _ZN9S248C3_nt4v159Ev();
extern void _ZN9S248C3_nt4v160Ev();
extern void _ZN9S248C3_nt4v161Ev();
extern void _ZN9S248C3_nt4v162Ev();
extern void _ZN9S248C3_nt4v163Ev();
extern void _ZN9S248C3_nt4v164Ev();
extern void _ZN9S248C3_nt4v165Ev();
extern void _ZN9S248C3_nt4v166Ev();
extern void _ZN9S248C3_nt4v167Ev();
extern void _ZN9S248C3_nt4v168Ev();
extern void _ZN9S248C3_nt4v169Ev();
extern void _ZN9S248C3_nt4v170Ev();
extern void _ZN9S248C3_nt4v171Ev();
extern void _ZN9S248C3_nt4v172Ev();
extern void _ZN9S248C3_nt4v173Ev();
extern void _ZN9S248C3_nt4v174Ev();
extern void _ZN9S248C3_nt4v175Ev();
extern void _ZN9S248C3_nt4v176Ev();
extern void _ZN9S248C3_nt4v177Ev();
extern void _ZN9S248C3_nt4v178Ev();
extern void _ZN9S248C3_nt4v179Ev();
extern void _ZN9S248C3_nt4v180Ev();
extern void _ZN9S248C3_nt4v181Ev();
extern void _ZN9S248C3_nt4v182Ev();
extern void _ZN9S248C3_nt4v183Ev();
extern void _ZN9S248C3_nt4v184Ev();
extern void _ZN9S248C3_nt4v185Ev();
extern void _ZN9S248C3_nt4v186Ev();
extern void _ZN9S248C3_nt4v187Ev();
extern void _ZN9S248C3_nt4v188Ev();
extern void _ZN9S248C3_nt4v189Ev();
extern void _ZN9S248C3_nt4v190Ev();
extern void _ZN9S248C3_nt4v191Ev();
extern void _ZN9S248C3_nt4v192Ev();
extern void _ZN9S248C3_nt4v193Ev();
extern void _ZN9S248C3_nt4v194Ev();
extern void _ZN9S248C3_nt4v195Ev();
extern void _ZN9S248C3_nt4v196Ev();
extern void _ZN9S248C3_nt4v197Ev();
extern void _ZN9S248C3_nt4v198Ev();
extern void _ZN9S248C3_nt4v199Ev();
extern void _ZN9S248C3_nt4v200Ev();
extern void _ZN9S248C3_nt4v201Ev();
extern void _ZN9S248C3_nt4v202Ev();
extern void _ZN9S248C3_nt4v203Ev();
extern void _ZN9S248C3_nt4v204Ev();
extern void _ZN9S248C3_nt4v205Ev();
extern void _ZN9S248C3_nt4v206Ev();
extern void _ZN9S248C3_nt4v207Ev();
extern void _ZN9S248C3_nt4v208Ev();
extern void _ZN9S248C3_nt4v209Ev();
extern void _ZN9S248C3_nt4v210Ev();
extern void _ZN9S248C3_nt4v211Ev();
extern void _ZN9S248C3_nt4v212Ev();
extern void _ZN9S248C3_nt4v213Ev();
extern void _ZN9S248C3_nt4v214Ev();
extern void _ZN9S248C3_nt4v215Ev();
extern void _ZN6S248C24v216Ev();
extern void _ZN6S248C24v217Ev();
extern void _ZN6S248C24v218Ev();
extern void _ZN6S248C24v219Ev();
extern void _ZN6S248C24v220Ev();
extern void _ZN6S248C24v221Ev();
extern void _ZN6S248C24v222Ev();
extern void _ZN6S248C24v223Ev();
extern void _ZN6S248C24v224Ev();
extern void _ZN6S248C24v225Ev();
extern void _ZN6S248C24v226Ev();
extern void _ZN6S248C24v227Ev();
extern void _ZN6S248C24v228Ev();
extern void _ZN6S248C24v229Ev();
extern void _ZN6S248C24v230Ev();
extern void _ZN6S248C24v231Ev();
extern void _ZN6S248C24v232Ev();
extern void _ZN6S248C24v233Ev();
extern void _ZN6S248C24v234Ev();
extern void _ZN6S248C24v235Ev();
extern void _ZN6S248C24v236Ev();
extern void _ZN6S248C24v237Ev();
extern void _ZN6S248C24v238Ev();
extern void _ZN6S248C12v1Ev();
extern void _ZN6S248C12v2Ev();
extern void _ZN6S248C12v3Ev();
extern void _ZN6S248C12v4Ev();
static  VTBL_ENTRY vtc_S248C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S248C1[0]),
  (VTBL_ENTRY)&_ZN6S248C1D1Ev,
  (VTBL_ENTRY)&_ZN6S248C1D0Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S248C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S248C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S248C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v214Ev,
  (VTBL_ENTRY)&_ZN9S248C3_nt4v215Ev,
  (VTBL_ENTRY)&_ZN6S248C24v216Ev,
  (VTBL_ENTRY)&_ZN6S248C24v217Ev,
  (VTBL_ENTRY)&_ZN6S248C24v218Ev,
  (VTBL_ENTRY)&_ZN6S248C24v219Ev,
  (VTBL_ENTRY)&_ZN6S248C24v220Ev,
  (VTBL_ENTRY)&_ZN6S248C24v221Ev,
  (VTBL_ENTRY)&_ZN6S248C24v222Ev,
  (VTBL_ENTRY)&_ZN6S248C24v223Ev,
  (VTBL_ENTRY)&_ZN6S248C24v224Ev,
  (VTBL_ENTRY)&_ZN6S248C24v225Ev,
  (VTBL_ENTRY)&_ZN6S248C24v226Ev,
  (VTBL_ENTRY)&_ZN6S248C24v227Ev,
  (VTBL_ENTRY)&_ZN6S248C24v228Ev,
  (VTBL_ENTRY)&_ZN6S248C24v229Ev,
  (VTBL_ENTRY)&_ZN6S248C24v230Ev,
  (VTBL_ENTRY)&_ZN6S248C24v231Ev,
  (VTBL_ENTRY)&_ZN6S248C24v232Ev,
  (VTBL_ENTRY)&_ZN6S248C24v233Ev,
  (VTBL_ENTRY)&_ZN6S248C24v234Ev,
  (VTBL_ENTRY)&_ZN6S248C24v235Ev,
  (VTBL_ENTRY)&_ZN6S248C24v236Ev,
  (VTBL_ENTRY)&_ZN6S248C24v237Ev,
  (VTBL_ENTRY)&_ZN6S248C24v238Ev,
  (VTBL_ENTRY)&_ZN6S248C12v1Ev,
  (VTBL_ENTRY)&_ZN6S248C12v2Ev,
  (VTBL_ENTRY)&_ZN6S248C12v3Ev,
  (VTBL_ENTRY)&_ZN6S248C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S248C1[];
extern  VTBL_ENTRY _ZTV6S248C1[];
Class_Descriptor cd_S248C1 = {  "S248C1", // class name
  bases_S248C1, 5,
  &(vtc_S248C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1464,1096), // object size
  NSPAIRA(_ZTI6S248C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S248C1),242, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C7_nt  {
  void  mf4947c7(); // _ZN10S4947C7_nt8mf4947c7Ev
};
//SIG(-1 S4947C7_nt) C1{ m}


void  S4947C7_nt ::mf4947c7(){}

//skip512 S4947C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C5_nt  {
  void *s4947c5f0;
  int s4947c5f1;
  ::S248C31_nt s4947c5f2;
  ::S4947C7_nt s4947c5f3;
  void  mf4947c5(); // _ZN10S4947C5_nt8mf4947c5Ev
};
//SIG(-1 S4947C5_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S4947C5_nt ::mf4947c5(){}

//skip512 S4947C5_nt

#else // __cplusplus

Class_Descriptor cd_S4947C5_nt = {  "S4947C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C4_nt  : S4947C5_nt {
};
//SIG(-1 S4947C4_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S4947C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S4947C5_nt;
static Base_Class bases_S4947C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4947C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C3_nt  {
  void *s4947c3f0;
  int s4947c3f1;
  ::S4947C4_nt s4947c3f2;
  ::S4947C4_nt s4947c3f3;
  int s4947c3f4;
  virtual  ~S4947C3_nt(); // _ZN10S4947C3_ntD1Ev
  virtual void  v3(); // _ZN10S4947C3_nt2v3Ev
  virtual void  v4(); // _ZN10S4947C3_nt2v4Ev
  virtual void  v5(); // _ZN10S4947C3_nt2v5Ev
  virtual void  v6(); // _ZN10S4947C3_nt2v6Ev
  virtual void  v7(); // _ZN10S4947C3_nt2v7Ev
  virtual void  v8(); // _ZN10S4947C3_nt2v8Ev
  virtual void  v9(); // _ZN10S4947C3_nt2v9Ev
  virtual void  v10(); // _ZN10S4947C3_nt3v10Ev
  virtual void  v11(); // _ZN10S4947C3_nt3v11Ev
  virtual void  v12(); // _ZN10S4947C3_nt3v12Ev
  virtual void  v13(); // _ZN10S4947C3_nt3v13Ev
  virtual void  v14(); // _ZN10S4947C3_nt3v14Ev
  virtual void  v15(); // _ZN10S4947C3_nt3v15Ev
  virtual void  v16(); // _ZN10S4947C3_nt3v16Ev
  virtual void  v17(); // _ZN10S4947C3_nt3v17Ev
  virtual void  v18(); // _ZN10S4947C3_nt3v18Ev
  virtual void  v19(); // _ZN10S4947C3_nt3v19Ev
  virtual void  v20(); // _ZN10S4947C3_nt3v20Ev
  virtual void  v21(); // _ZN10S4947C3_nt3v21Ev
  virtual void  v22(); // _ZN10S4947C3_nt3v22Ev
  virtual void  v23(); // _ZN10S4947C3_nt3v23Ev
  virtual void  v24(); // _ZN10S4947C3_nt3v24Ev
  virtual void  v25(); // _ZN10S4947C3_nt3v25Ev
  S4947C3_nt(); // tgen
};
//SIG(-1 S4947C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC2 Fi}


 S4947C3_nt ::~S4947C3_nt(){ note_dtor("S4947C3_nt", this);}
void  S4947C3_nt ::v3(){vfunc_called(this, "_ZN10S4947C3_nt2v3Ev");}
void  S4947C3_nt ::v4(){vfunc_called(this, "_ZN10S4947C3_nt2v4Ev");}
void  S4947C3_nt ::v5(){vfunc_called(this, "_ZN10S4947C3_nt2v5Ev");}
void  S4947C3_nt ::v6(){vfunc_called(this, "_ZN10S4947C3_nt2v6Ev");}
void  S4947C3_nt ::v7(){vfunc_called(this, "_ZN10S4947C3_nt2v7Ev");}
void  S4947C3_nt ::v8(){vfunc_called(this, "_ZN10S4947C3_nt2v8Ev");}
void  S4947C3_nt ::v9(){vfunc_called(this, "_ZN10S4947C3_nt2v9Ev");}
void  S4947C3_nt ::v10(){vfunc_called(this, "_ZN10S4947C3_nt3v10Ev");}
void  S4947C3_nt ::v11(){vfunc_called(this, "_ZN10S4947C3_nt3v11Ev");}
void  S4947C3_nt ::v12(){vfunc_called(this, "_ZN10S4947C3_nt3v12Ev");}
void  S4947C3_nt ::v13(){vfunc_called(this, "_ZN10S4947C3_nt3v13Ev");}
void  S4947C3_nt ::v14(){vfunc_called(this, "_ZN10S4947C3_nt3v14Ev");}
void  S4947C3_nt ::v15(){vfunc_called(this, "_ZN10S4947C3_nt3v15Ev");}
void  S4947C3_nt ::v16(){vfunc_called(this, "_ZN10S4947C3_nt3v16Ev");}
void  S4947C3_nt ::v17(){vfunc_called(this, "_ZN10S4947C3_nt3v17Ev");}
void  S4947C3_nt ::v18(){vfunc_called(this, "_ZN10S4947C3_nt3v18Ev");}
void  S4947C3_nt ::v19(){vfunc_called(this, "_ZN10S4947C3_nt3v19Ev");}
void  S4947C3_nt ::v20(){vfunc_called(this, "_ZN10S4947C3_nt3v20Ev");}
void  S4947C3_nt ::v21(){vfunc_called(this, "_ZN10S4947C3_nt3v21Ev");}
void  S4947C3_nt ::v22(){vfunc_called(this, "_ZN10S4947C3_nt3v22Ev");}
void  S4947C3_nt ::v23(){vfunc_called(this, "_ZN10S4947C3_nt3v23Ev");}
void  S4947C3_nt ::v24(){vfunc_called(this, "_ZN10S4947C3_nt3v24Ev");}
void  S4947C3_nt ::v25(){vfunc_called(this, "_ZN10S4947C3_nt3v25Ev");}
S4947C3_nt ::S4947C3_nt(){ note_ctor("S4947C3_nt", this);} // tgen

//skip512 S4947C3_nt

#else // __cplusplus

extern void _ZN10S4947C3_ntC1Ev();
extern void _ZN10S4947C3_ntD1Ev();
Name_Map name_map_S4947C3_nt[] = {
  NSPAIR(_ZN10S4947C3_ntC1Ev),
  NSPAIR(_ZN10S4947C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4947C3_nt[];
extern void _ZN10S4947C3_ntD1Ev();
extern void _ZN10S4947C3_ntD0Ev();
extern void _ZN10S4947C3_nt2v3Ev();
extern void _ZN10S4947C3_nt2v4Ev();
extern void _ZN10S4947C3_nt2v5Ev();
extern void _ZN10S4947C3_nt2v6Ev();
extern void _ZN10S4947C3_nt2v7Ev();
extern void _ZN10S4947C3_nt2v8Ev();
extern void _ZN10S4947C3_nt2v9Ev();
extern void _ZN10S4947C3_nt3v10Ev();
extern void _ZN10S4947C3_nt3v11Ev();
extern void _ZN10S4947C3_nt3v12Ev();
extern void _ZN10S4947C3_nt3v13Ev();
extern void _ZN10S4947C3_nt3v14Ev();
extern void _ZN10S4947C3_nt3v15Ev();
extern void _ZN10S4947C3_nt3v16Ev();
extern void _ZN10S4947C3_nt3v17Ev();
extern void _ZN10S4947C3_nt3v18Ev();
extern void _ZN10S4947C3_nt3v19Ev();
extern void _ZN10S4947C3_nt3v20Ev();
extern void _ZN10S4947C3_nt3v21Ev();
extern void _ZN10S4947C3_nt3v22Ev();
extern void _ZN10S4947C3_nt3v23Ev();
extern void _ZN10S4947C3_nt3v24Ev();
extern void _ZN10S4947C3_nt3v25Ev();
static  VTBL_ENTRY vtc_S4947C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4947C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S4947C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v25Ev,
};
extern VTBL_ENTRY _ZTI10S4947C3_nt[];
VTBL_ENTRY *P__ZTI10S4947C3_nt = _ZTI10S4947C3_nt; 
extern  VTBL_ENTRY _ZTV10S4947C3_nt[];
Class_Descriptor cd_S4947C3_nt = {  "S4947C3_nt", // class name
  0,0,//no base classes
  &(vtc_S4947C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S4947C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4947C3_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C13_nt  {
  __tsi64 s4947c13f0[2];
  void  mf4947c13(); // _ZN11S4947C13_nt9mf4947c13Ev
};
//SIG(-1 S4947C13_nt) C1{ m FL[2]}


void  S4947C13_nt ::mf4947c13(){}

//skip512 S4947C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C12_nt  {
  ::S4947C13_nt s4947c12f0;
  void  mf4947c12(); // _ZN11S4947C12_nt9mf4947c12Ev
};
//SIG(-1 S4947C12_nt) C1{ m FC2{ m FL[2]}}


void  S4947C12_nt ::mf4947c12(){}

//skip512 S4947C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C16_nt  {
  ::S4947C12_nt s4947c16f0;
  void  mf4947c16(); // _ZN11S4947C16_nt9mf4947c16Ev
};
//SIG(-1 S4947C16_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S4947C16_nt ::mf4947c16(){}

//skip512 S4947C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C17_nt  {
  ::S4947C12_nt s4947c17f0;
  ::S4947C12_nt s4947c17f1;
  ::S4947C12_nt s4947c17f2;
  ::S4947C12_nt s4947c17f3;
  void  mf4947c17(); // _ZN11S4947C17_nt9mf4947c17Ev
};
//SIG(-1 S4947C17_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S4947C17_nt ::mf4947c17(){}

//skip512 S4947C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C19_nt  {
  void *s4947c19f0;
  int s4947c19f1;
  ::S4947C7_nt s4947c19f2;
  void  mf4947c19(); // _ZN11S4947C19_nt9mf4947c19Ev
};
//SIG(-1 S4947C19_nt) C1{ m Fp Fi FC2{ m}}


void  S4947C19_nt ::mf4947c19(){}

//skip512 S4947C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C18_nt  {
  ::S4947C19_nt s4947c18f0;
  int s4947c18f1;
  void  mf4947c18(); // _ZN11S4947C18_nt9mf4947c18Ev
};
//SIG(-1 S4947C18_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S4947C18_nt ::mf4947c18(){}

//skip512 S4947C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C22  {
  void  mf4947c22(); // _ZN8S4947C229mf4947c22Ev
};
//SIG(-1 S4947C22) C1{ m}


void  S4947C22 ::mf4947c22(){}

static void Test_S4947C22()
{
  {
    init_simple_test("S4947C22");
    S4947C22 lv;
    check2(sizeof(lv), 1, "sizeof(S4947C22)");
    check2(__alignof__(lv), 1, "__alignof__(S4947C22)");
  }
}
static Arrange_To_Call_Me vS4947C22(Test_S4947C22, "S4947C22", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C21  {
  void *s4947c21f0;
  int s4947c21f1;
  ::S4947C22 s4947c21f2;
  ::S4947C22 s4947c21f3;
  void  mf4947c21(); // _ZN8S4947C219mf4947c21Ev
};
//SIG(-1 S4947C21) C1{ m Fp Fi FC2{ m} FC2}


void  S4947C21 ::mf4947c21(){}

static void Test_S4947C21()
{
  {
    init_simple_test("S4947C21");
    S4947C21 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4947C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4947C21)");
    check_field_offset(lv, s4947c21f0, 0, "S4947C21.s4947c21f0");
    check_field_offset(lv, s4947c21f1, ABISELECT(8,4), "S4947C21.s4947c21f1");
    check_field_offset(lv, s4947c21f2, ABISELECT(12,8), "S4947C21.s4947c21f2");
    check_field_offset(lv, s4947c21f3, ABISELECT(13,9), "S4947C21.s4947c21f3");
  }
}
static Arrange_To_Call_Me vS4947C21(Test_S4947C21, "S4947C21", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C26  {
  void  mf4947c26(); // _ZN8S4947C269mf4947c26Ev
};
//SIG(-1 S4947C26) C1{ m}


void  S4947C26 ::mf4947c26(){}

static void Test_S4947C26()
{
  {
    init_simple_test("S4947C26");
    S4947C26 lv;
    check2(sizeof(lv), 1, "sizeof(S4947C26)");
    check2(__alignof__(lv), 1, "__alignof__(S4947C26)");
  }
}
static Arrange_To_Call_Me vS4947C26(Test_S4947C26, "S4947C26", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C25  {
  void *s4947c25f0;
  int s4947c25f1;
  ::S4947C26 s4947c25f2;
  ::S4947C26 s4947c25f3;
  void  mf4947c25(); // _ZN8S4947C259mf4947c25Ev
};
//SIG(-1 S4947C25) C1{ m Fp Fi FC2{ m} FC2}


void  S4947C25 ::mf4947c25(){}

static void Test_S4947C25()
{
  {
    init_simple_test("S4947C25");
    S4947C25 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4947C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4947C25)");
    check_field_offset(lv, s4947c25f0, 0, "S4947C25.s4947c25f0");
    check_field_offset(lv, s4947c25f1, ABISELECT(8,4), "S4947C25.s4947c25f1");
    check_field_offset(lv, s4947c25f2, ABISELECT(12,8), "S4947C25.s4947c25f2");
    check_field_offset(lv, s4947c25f3, ABISELECT(13,9), "S4947C25.s4947c25f3");
  }
}
static Arrange_To_Call_Me vS4947C25(Test_S4947C25, "S4947C25", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S4947C25 = {  "S4947C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C24  : S4947C25 {
};
//SIG(-1 S4947C24) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S4947C24()
{
  extern Class_Descriptor cd_S4947C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S4947C24, buf);
    S4947C24 &lv = *(new (buf) S4947C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4947C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4947C24)");
    check_base_class_offset(lv, (S4947C25*), 0, "S4947C24");
    test_class_info(&lv, &cd_S4947C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4947C24(Test_S4947C24, "S4947C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S4947C25;
static Base_Class bases_S4947C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4947C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S4947C24 = {  "S4947C24", // class name
  bases_S4947C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C29  {
  void  mf4947c29(); // _ZN8S4947C299mf4947c29Ev
};
//SIG(-1 S4947C29) C1{ m}


void  S4947C29 ::mf4947c29(){}

static void Test_S4947C29()
{
  {
    init_simple_test("S4947C29");
    S4947C29 lv;
    check2(sizeof(lv), 1, "sizeof(S4947C29)");
    check2(__alignof__(lv), 1, "__alignof__(S4947C29)");
  }
}
static Arrange_To_Call_Me vS4947C29(Test_S4947C29, "S4947C29", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4947C29[];
VTBL_ENTRY *P__ZTI8S4947C29 = _ZTI8S4947C29; 
Class_Descriptor cd_S4947C29 = {  "S4947C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4947C29),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C28_nt  {
  void *s4947c28f0;
  int s4947c28f1[2];
  ::S4947C29 s4947c28f2;
  void  mf4947c28(); // _ZN11S4947C28_nt9mf4947c28Ev
};
//SIG(-1 S4947C28_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S4947C28_nt ::mf4947c28(){}

//skip512 S4947C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C36  {
  void *s4947c36f0;
  int s4947c36f1[2];
  ::S4947C29 s4947c36f2;
  void  mf4947c36(); // _ZN8S4947C369mf4947c36Ev
};
//SIG(-1 S4947C36) C1{ m Fp Fi[2] FC2{ m}}


void  S4947C36 ::mf4947c36(){}

static void Test_S4947C36()
{
  {
    init_simple_test("S4947C36");
    S4947C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4947C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4947C36)");
    check_field_offset(lv, s4947c36f0, 0, "S4947C36.s4947c36f0");
    check_field_offset(lv, s4947c36f1, ABISELECT(8,4), "S4947C36.s4947c36f1");
    check_field_offset(lv, s4947c36f2, ABISELECT(16,12), "S4947C36.s4947c36f2");
  }
}
static Arrange_To_Call_Me vS4947C36(Test_S4947C36, "S4947C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C2_nt  : S4947C3_nt {
  ::S4947C12_nt s4947c2f0;
  ::S4947C12_nt s4947c2f1;
  ::S4947C12_nt s4947c2f2;
  ::S4947C12_nt s4947c2f3;
  ::S4947C16_nt s4947c2f4;
  ::S4947C17_nt s4947c2f5;
  ::S4947C17_nt s4947c2f6;
  ::S4947C12_nt s4947c2f7;
  ::S4947C12_nt s4947c2f8;
  ::S4947C12_nt s4947c2f9;
  void *s4947c2f10;
  ::S4947C16_nt s4947c2f11;
  ::S4947C18_nt s4947c2f12;
  int s4947c2f13;
  void *s4947c2f14[7];
  ::S4947C21 s4947c2f15;
  int s4947c2f16:8;
  int s4947c2f17:8;
  int s4947c2f18:16;
  int s4947c2f19:16;
  int s4947c2f20:8;
  int s4947c2f21:8;
  int s4947c2f22:8;
  int s4947c2f23:32;
  int s4947c2f24:8;
  int s4947c2f25:4;
  int s4947c2f26:4;
  int s4947c2f27:4;
  int s4947c2f28:4;
  int s4947c2f29:4;
  int s4947c2f30:4;
  int s4947c2f31:4;
  int s4947c2f32:4;
  int s4947c2f33:4;
  int s4947c2f34:4;
  unsigned char s4947c2f35:1;
  unsigned char s4947c2f36:1;
  unsigned char s4947c2f37:1;
  unsigned char s4947c2f38:1;
  unsigned char s4947c2f39:1;
  unsigned char s4947c2f40:1;
  unsigned char s4947c2f41:1;
  unsigned char s4947c2f42:1;
  unsigned char s4947c2f43:1;
  unsigned char s4947c2f44:1;
  unsigned char s4947c2f45:1;
  unsigned char s4947c2f46:1;
  unsigned char s4947c2f47:1;
  unsigned char s4947c2f48:1;
  unsigned char s4947c2f49:1;
  unsigned char s4947c2f50:1;
  unsigned char s4947c2f51:1;
  unsigned char s4947c2f52:1;
  unsigned char s4947c2f53:1;
  unsigned char s4947c2f54:1;
  unsigned char s4947c2f55:1;
  unsigned char s4947c2f56:1;
  unsigned char s4947c2f57:1;
  unsigned char s4947c2f58:1;
  unsigned char s4947c2f59:1;
  unsigned char s4947c2f60:1;
  unsigned char s4947c2f61:1;
  unsigned char s4947c2f62:1;
  unsigned char s4947c2f63:1;
  unsigned char s4947c2f64:1;
  unsigned char s4947c2f65:1;
  unsigned char s4947c2f66:1;
  unsigned char s4947c2f67:1;
  unsigned char s4947c2f68:1;
  unsigned char s4947c2f69:1;
  unsigned char s4947c2f70:1;
  unsigned char s4947c2f71:1;
  unsigned char s4947c2f72:1;
  unsigned char s4947c2f73:1;
  unsigned char s4947c2f74:1;
  unsigned char s4947c2f75:1;
  int s4947c2f76[7];
  void *s4947c2f77[6];
  int s4947c2f78:8;
  int s4947c2f79:8;
  int s4947c2f80:8;
  int s4947c2f81:8;
  int s4947c2f82:8;
  int s4947c2f83:8;
  ::S4947C24 s4947c2f84;
  void *s4947c2f85[4];
  int s4947c2f86:8;
  int s4947c2f87:8;
  int s4947c2f88:8;
  int s4947c2f89:8;
  int s4947c2f90:8;
  int s4947c2f91:16;
  int s4947c2f92:16;
  int s4947c2f93:16;
  int s4947c2f94:4;
  int s4947c2f95:4;
  int s4947c2f96:4;
  int s4947c2f97:4;
  int s4947c2f98:4;
  int s4947c2f99:4;
  int s4947c2f100:4;
  int s4947c2f101:4;
  int s4947c2f102:4;
  int s4947c2f103:4;
  int s4947c2f104:4;
  int s4947c2f105:4;
  int s4947c2f106:8;
  int s4947c2f107:8;
  int s4947c2f108:8;
  void *s4947c2f109[7];
  ::S4947C28_nt s4947c2f110;
  void *s4947c2f111[2];
  int s4947c2f112:16;
  int s4947c2f113:16;
  ::S4947C24 s4947c2f114;
  ::S4947C28_nt s4947c2f115;
  ::S4947C36 s4947c2f116;
  void *s4947c2f117[2];
  int s4947c2f118:24;
  int s4947c2f119:8;
  void *s4947c2f120;
  virtual  ~S4947C2_nt(); // _ZN10S4947C2_ntD1Ev
  virtual void  v26(); // _ZN10S4947C2_nt3v26Ev
  virtual void  v27(); // _ZN10S4947C2_nt3v27Ev
  virtual void  v28(); // _ZN10S4947C2_nt3v28Ev
  virtual void  v29(); // _ZN10S4947C2_nt3v29Ev
  virtual void  v30(); // _ZN10S4947C2_nt3v30Ev
  virtual void  v31(); // _ZN10S4947C2_nt3v31Ev
  virtual void  v32(); // _ZN10S4947C2_nt3v32Ev
  virtual void  v33(); // _ZN10S4947C2_nt3v33Ev
  virtual void  v34(); // _ZN10S4947C2_nt3v34Ev
  virtual void  v35(); // _ZN10S4947C2_nt3v35Ev
  virtual void  v36(); // _ZN10S4947C2_nt3v36Ev
  virtual void  v37(); // _ZN10S4947C2_nt3v37Ev
  virtual void  v38(); // _ZN10S4947C2_nt3v38Ev
  virtual void  v39(); // _ZN10S4947C2_nt3v39Ev
  virtual void  v40(); // _ZN10S4947C2_nt3v40Ev
  virtual void  v41(); // _ZN10S4947C2_nt3v41Ev
  virtual void  v42(); // _ZN10S4947C2_nt3v42Ev
  virtual void  v43(); // _ZN10S4947C2_nt3v43Ev
  virtual void  v44(); // _ZN10S4947C2_nt3v44Ev
  virtual void  v45(); // _ZN10S4947C2_nt3v45Ev
  virtual void  v46(); // _ZN10S4947C2_nt3v46Ev
  virtual void  v47(); // _ZN10S4947C2_nt3v47Ev
  virtual void  v48(); // _ZN10S4947C2_nt3v48Ev
  virtual void  v49(); // _ZN10S4947C2_nt3v49Ev
  virtual void  v50(); // _ZN10S4947C2_nt3v50Ev
  virtual void  v51(); // _ZN10S4947C2_nt3v51Ev
  virtual void  v52(); // _ZN10S4947C2_nt3v52Ev
  virtual void  v53(); // _ZN10S4947C2_nt3v53Ev
  virtual void  v54(); // _ZN10S4947C2_nt3v54Ev
  virtual void  v55(); // _ZN10S4947C2_nt3v55Ev
  virtual void  v56(); // _ZN10S4947C2_nt3v56Ev
  virtual void  v57(); // _ZN10S4947C2_nt3v57Ev
  virtual void  v58(); // _ZN10S4947C2_nt3v58Ev
  virtual void  v59(); // _ZN10S4947C2_nt3v59Ev
  virtual void  v60(); // _ZN10S4947C2_nt3v60Ev
  virtual void  v61(); // _ZN10S4947C2_nt3v61Ev
  virtual void  v62(); // _ZN10S4947C2_nt3v62Ev
  virtual void  v63(); // _ZN10S4947C2_nt3v63Ev
  virtual void  v64(); // _ZN10S4947C2_nt3v64Ev
  virtual void  v65(); // _ZN10S4947C2_nt3v65Ev
  virtual void  v66(); // _ZN10S4947C2_nt3v66Ev
  virtual void  v67(); // _ZN10S4947C2_nt3v67Ev
  virtual void  v68(); // _ZN10S4947C2_nt3v68Ev
  virtual void  v69(); // _ZN10S4947C2_nt3v69Ev
  virtual void  v70(); // _ZN10S4947C2_nt3v70Ev
  virtual void  v71(); // _ZN10S4947C2_nt3v71Ev
  virtual void  v72(); // _ZN10S4947C2_nt3v72Ev
  virtual void  v73(); // _ZN10S4947C2_nt3v73Ev
  virtual void  v74(); // _ZN10S4947C2_nt3v74Ev
  virtual void  v75(); // _ZN10S4947C2_nt3v75Ev
  virtual void  v76(); // _ZN10S4947C2_nt3v76Ev
  virtual void  v77(); // _ZN10S4947C2_nt3v77Ev
  virtual void  v78(); // _ZN10S4947C2_nt3v78Ev
  virtual void  v79(); // _ZN10S4947C2_nt3v79Ev
  virtual void  v80(); // _ZN10S4947C2_nt3v80Ev
  virtual void  v81(); // _ZN10S4947C2_nt3v81Ev
  virtual void  v82(); // _ZN10S4947C2_nt3v82Ev
  virtual void  v83(); // _ZN10S4947C2_nt3v83Ev
  virtual void  v84(); // _ZN10S4947C2_nt3v84Ev
  virtual void  v85(); // _ZN10S4947C2_nt3v85Ev
  virtual void  v86(); // _ZN10S4947C2_nt3v86Ev
  virtual void  v87(); // _ZN10S4947C2_nt3v87Ev
  virtual void  v88(); // _ZN10S4947C2_nt3v88Ev
  virtual void  v89(); // _ZN10S4947C2_nt3v89Ev
  virtual void  v90(); // _ZN10S4947C2_nt3v90Ev
  virtual void  v91(); // _ZN10S4947C2_nt3v91Ev
  virtual void  v92(); // _ZN10S4947C2_nt3v92Ev
  virtual void  v93(); // _ZN10S4947C2_nt3v93Ev
  virtual void  v94(); // _ZN10S4947C2_nt3v94Ev
  virtual void  v95(); // _ZN10S4947C2_nt3v95Ev
  virtual void  v96(); // _ZN10S4947C2_nt3v96Ev
  virtual void  v97(); // _ZN10S4947C2_nt3v97Ev
  virtual void  v98(); // _ZN10S4947C2_nt3v98Ev
  virtual void  v99(); // _ZN10S4947C2_nt3v99Ev
  virtual void  v100(); // _ZN10S4947C2_nt4v100Ev
  virtual void  v101(); // _ZN10S4947C2_nt4v101Ev
  virtual void  v102(); // _ZN10S4947C2_nt4v102Ev
  virtual void  v103(); // _ZN10S4947C2_nt4v103Ev
  S4947C2_nt(); // tgen
};
//SIG(-1 S4947C2_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC6} Fi} Fi Fp[7] FC13{ m Fp Fi FC14{ m} FC14} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC17{ m} FC17}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC19{ m}} Fp[2] Fi:16 Fi:16 FC15 FC18 FC20{ m Fp Fi[2] FC19} Fp[2] Fi:24 Fi:8 Fp}


 S4947C2_nt ::~S4947C2_nt(){ note_dtor("S4947C2_nt", this);}
void  S4947C2_nt ::v26(){vfunc_called(this, "_ZN10S4947C2_nt3v26Ev");}
void  S4947C2_nt ::v27(){vfunc_called(this, "_ZN10S4947C2_nt3v27Ev");}
void  S4947C2_nt ::v28(){vfunc_called(this, "_ZN10S4947C2_nt3v28Ev");}
void  S4947C2_nt ::v29(){vfunc_called(this, "_ZN10S4947C2_nt3v29Ev");}
void  S4947C2_nt ::v30(){vfunc_called(this, "_ZN10S4947C2_nt3v30Ev");}
void  S4947C2_nt ::v31(){vfunc_called(this, "_ZN10S4947C2_nt3v31Ev");}
void  S4947C2_nt ::v32(){vfunc_called(this, "_ZN10S4947C2_nt3v32Ev");}
void  S4947C2_nt ::v33(){vfunc_called(this, "_ZN10S4947C2_nt3v33Ev");}
void  S4947C2_nt ::v34(){vfunc_called(this, "_ZN10S4947C2_nt3v34Ev");}
void  S4947C2_nt ::v35(){vfunc_called(this, "_ZN10S4947C2_nt3v35Ev");}
void  S4947C2_nt ::v36(){vfunc_called(this, "_ZN10S4947C2_nt3v36Ev");}
void  S4947C2_nt ::v37(){vfunc_called(this, "_ZN10S4947C2_nt3v37Ev");}
void  S4947C2_nt ::v38(){vfunc_called(this, "_ZN10S4947C2_nt3v38Ev");}
void  S4947C2_nt ::v39(){vfunc_called(this, "_ZN10S4947C2_nt3v39Ev");}
void  S4947C2_nt ::v40(){vfunc_called(this, "_ZN10S4947C2_nt3v40Ev");}
void  S4947C2_nt ::v41(){vfunc_called(this, "_ZN10S4947C2_nt3v41Ev");}
void  S4947C2_nt ::v42(){vfunc_called(this, "_ZN10S4947C2_nt3v42Ev");}
void  S4947C2_nt ::v43(){vfunc_called(this, "_ZN10S4947C2_nt3v43Ev");}
void  S4947C2_nt ::v44(){vfunc_called(this, "_ZN10S4947C2_nt3v44Ev");}
void  S4947C2_nt ::v45(){vfunc_called(this, "_ZN10S4947C2_nt3v45Ev");}
void  S4947C2_nt ::v46(){vfunc_called(this, "_ZN10S4947C2_nt3v46Ev");}
void  S4947C2_nt ::v47(){vfunc_called(this, "_ZN10S4947C2_nt3v47Ev");}
void  S4947C2_nt ::v48(){vfunc_called(this, "_ZN10S4947C2_nt3v48Ev");}
void  S4947C2_nt ::v49(){vfunc_called(this, "_ZN10S4947C2_nt3v49Ev");}
void  S4947C2_nt ::v50(){vfunc_called(this, "_ZN10S4947C2_nt3v50Ev");}
void  S4947C2_nt ::v51(){vfunc_called(this, "_ZN10S4947C2_nt3v51Ev");}
void  S4947C2_nt ::v52(){vfunc_called(this, "_ZN10S4947C2_nt3v52Ev");}
void  S4947C2_nt ::v53(){vfunc_called(this, "_ZN10S4947C2_nt3v53Ev");}
void  S4947C2_nt ::v54(){vfunc_called(this, "_ZN10S4947C2_nt3v54Ev");}
void  S4947C2_nt ::v55(){vfunc_called(this, "_ZN10S4947C2_nt3v55Ev");}
void  S4947C2_nt ::v56(){vfunc_called(this, "_ZN10S4947C2_nt3v56Ev");}
void  S4947C2_nt ::v57(){vfunc_called(this, "_ZN10S4947C2_nt3v57Ev");}
void  S4947C2_nt ::v58(){vfunc_called(this, "_ZN10S4947C2_nt3v58Ev");}
void  S4947C2_nt ::v59(){vfunc_called(this, "_ZN10S4947C2_nt3v59Ev");}
void  S4947C2_nt ::v60(){vfunc_called(this, "_ZN10S4947C2_nt3v60Ev");}
void  S4947C2_nt ::v61(){vfunc_called(this, "_ZN10S4947C2_nt3v61Ev");}
void  S4947C2_nt ::v62(){vfunc_called(this, "_ZN10S4947C2_nt3v62Ev");}
void  S4947C2_nt ::v63(){vfunc_called(this, "_ZN10S4947C2_nt3v63Ev");}
void  S4947C2_nt ::v64(){vfunc_called(this, "_ZN10S4947C2_nt3v64Ev");}
void  S4947C2_nt ::v65(){vfunc_called(this, "_ZN10S4947C2_nt3v65Ev");}
void  S4947C2_nt ::v66(){vfunc_called(this, "_ZN10S4947C2_nt3v66Ev");}
void  S4947C2_nt ::v67(){vfunc_called(this, "_ZN10S4947C2_nt3v67Ev");}
void  S4947C2_nt ::v68(){vfunc_called(this, "_ZN10S4947C2_nt3v68Ev");}
void  S4947C2_nt ::v69(){vfunc_called(this, "_ZN10S4947C2_nt3v69Ev");}
void  S4947C2_nt ::v70(){vfunc_called(this, "_ZN10S4947C2_nt3v70Ev");}
void  S4947C2_nt ::v71(){vfunc_called(this, "_ZN10S4947C2_nt3v71Ev");}
void  S4947C2_nt ::v72(){vfunc_called(this, "_ZN10S4947C2_nt3v72Ev");}
void  S4947C2_nt ::v73(){vfunc_called(this, "_ZN10S4947C2_nt3v73Ev");}
void  S4947C2_nt ::v74(){vfunc_called(this, "_ZN10S4947C2_nt3v74Ev");}
void  S4947C2_nt ::v75(){vfunc_called(this, "_ZN10S4947C2_nt3v75Ev");}
void  S4947C2_nt ::v76(){vfunc_called(this, "_ZN10S4947C2_nt3v76Ev");}
void  S4947C2_nt ::v77(){vfunc_called(this, "_ZN10S4947C2_nt3v77Ev");}
void  S4947C2_nt ::v78(){vfunc_called(this, "_ZN10S4947C2_nt3v78Ev");}
void  S4947C2_nt ::v79(){vfunc_called(this, "_ZN10S4947C2_nt3v79Ev");}
void  S4947C2_nt ::v80(){vfunc_called(this, "_ZN10S4947C2_nt3v80Ev");}
void  S4947C2_nt ::v81(){vfunc_called(this, "_ZN10S4947C2_nt3v81Ev");}
void  S4947C2_nt ::v82(){vfunc_called(this, "_ZN10S4947C2_nt3v82Ev");}
void  S4947C2_nt ::v83(){vfunc_called(this, "_ZN10S4947C2_nt3v83Ev");}
void  S4947C2_nt ::v84(){vfunc_called(this, "_ZN10S4947C2_nt3v84Ev");}
void  S4947C2_nt ::v85(){vfunc_called(this, "_ZN10S4947C2_nt3v85Ev");}
void  S4947C2_nt ::v86(){vfunc_called(this, "_ZN10S4947C2_nt3v86Ev");}
void  S4947C2_nt ::v87(){vfunc_called(this, "_ZN10S4947C2_nt3v87Ev");}
void  S4947C2_nt ::v88(){vfunc_called(this, "_ZN10S4947C2_nt3v88Ev");}
void  S4947C2_nt ::v89(){vfunc_called(this, "_ZN10S4947C2_nt3v89Ev");}
void  S4947C2_nt ::v90(){vfunc_called(this, "_ZN10S4947C2_nt3v90Ev");}
void  S4947C2_nt ::v91(){vfunc_called(this, "_ZN10S4947C2_nt3v91Ev");}
void  S4947C2_nt ::v92(){vfunc_called(this, "_ZN10S4947C2_nt3v92Ev");}
void  S4947C2_nt ::v93(){vfunc_called(this, "_ZN10S4947C2_nt3v93Ev");}
void  S4947C2_nt ::v94(){vfunc_called(this, "_ZN10S4947C2_nt3v94Ev");}
void  S4947C2_nt ::v95(){vfunc_called(this, "_ZN10S4947C2_nt3v95Ev");}
void  S4947C2_nt ::v96(){vfunc_called(this, "_ZN10S4947C2_nt3v96Ev");}
void  S4947C2_nt ::v97(){vfunc_called(this, "_ZN10S4947C2_nt3v97Ev");}
void  S4947C2_nt ::v98(){vfunc_called(this, "_ZN10S4947C2_nt3v98Ev");}
void  S4947C2_nt ::v99(){vfunc_called(this, "_ZN10S4947C2_nt3v99Ev");}
void  S4947C2_nt ::v100(){vfunc_called(this, "_ZN10S4947C2_nt4v100Ev");}
void  S4947C2_nt ::v101(){vfunc_called(this, "_ZN10S4947C2_nt4v101Ev");}
void  S4947C2_nt ::v102(){vfunc_called(this, "_ZN10S4947C2_nt4v102Ev");}
void  S4947C2_nt ::v103(){vfunc_called(this, "_ZN10S4947C2_nt4v103Ev");}
S4947C2_nt ::S4947C2_nt(){ note_ctor("S4947C2_nt", this);} // tgen

//skip512 S4947C2_nt

#else // __cplusplus

extern void _ZN10S4947C2_ntC1Ev();
extern void _ZN10S4947C2_ntD1Ev();
Name_Map name_map_S4947C2_nt[] = {
  NSPAIR(_ZN10S4947C2_ntC1Ev),
  NSPAIR(_ZN10S4947C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4947C3_nt;
extern VTBL_ENTRY _ZTI10S4947C3_nt[];
extern  VTBL_ENTRY _ZTV10S4947C3_nt[];
static Base_Class bases_S4947C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4947C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S4947C2_nt[];
extern void _ZN10S4947C2_ntD1Ev();
extern void _ZN10S4947C2_ntD0Ev();
extern void _ZN10S4947C3_nt2v3Ev();
extern void _ZN10S4947C3_nt2v4Ev();
extern void _ZN10S4947C3_nt2v5Ev();
extern void _ZN10S4947C3_nt2v6Ev();
extern void _ZN10S4947C3_nt2v7Ev();
extern void _ZN10S4947C3_nt2v8Ev();
extern void _ZN10S4947C3_nt2v9Ev();
extern void _ZN10S4947C3_nt3v10Ev();
extern void _ZN10S4947C3_nt3v11Ev();
extern void _ZN10S4947C3_nt3v12Ev();
extern void _ZN10S4947C3_nt3v13Ev();
extern void _ZN10S4947C3_nt3v14Ev();
extern void _ZN10S4947C3_nt3v15Ev();
extern void _ZN10S4947C3_nt3v16Ev();
extern void _ZN10S4947C3_nt3v17Ev();
extern void _ZN10S4947C3_nt3v18Ev();
extern void _ZN10S4947C3_nt3v19Ev();
extern void _ZN10S4947C3_nt3v20Ev();
extern void _ZN10S4947C3_nt3v21Ev();
extern void _ZN10S4947C3_nt3v22Ev();
extern void _ZN10S4947C3_nt3v23Ev();
extern void _ZN10S4947C3_nt3v24Ev();
extern void _ZN10S4947C3_nt3v25Ev();
extern void _ZN10S4947C2_nt3v26Ev();
extern void _ZN10S4947C2_nt3v27Ev();
extern void _ZN10S4947C2_nt3v28Ev();
extern void _ZN10S4947C2_nt3v29Ev();
extern void _ZN10S4947C2_nt3v30Ev();
extern void _ZN10S4947C2_nt3v31Ev();
extern void _ZN10S4947C2_nt3v32Ev();
extern void _ZN10S4947C2_nt3v33Ev();
extern void _ZN10S4947C2_nt3v34Ev();
extern void _ZN10S4947C2_nt3v35Ev();
extern void _ZN10S4947C2_nt3v36Ev();
extern void _ZN10S4947C2_nt3v37Ev();
extern void _ZN10S4947C2_nt3v38Ev();
extern void _ZN10S4947C2_nt3v39Ev();
extern void _ZN10S4947C2_nt3v40Ev();
extern void _ZN10S4947C2_nt3v41Ev();
extern void _ZN10S4947C2_nt3v42Ev();
extern void _ZN10S4947C2_nt3v43Ev();
extern void _ZN10S4947C2_nt3v44Ev();
extern void _ZN10S4947C2_nt3v45Ev();
extern void _ZN10S4947C2_nt3v46Ev();
extern void _ZN10S4947C2_nt3v47Ev();
extern void _ZN10S4947C2_nt3v48Ev();
extern void _ZN10S4947C2_nt3v49Ev();
extern void _ZN10S4947C2_nt3v50Ev();
extern void _ZN10S4947C2_nt3v51Ev();
extern void _ZN10S4947C2_nt3v52Ev();
extern void _ZN10S4947C2_nt3v53Ev();
extern void _ZN10S4947C2_nt3v54Ev();
extern void _ZN10S4947C2_nt3v55Ev();
extern void _ZN10S4947C2_nt3v56Ev();
extern void _ZN10S4947C2_nt3v57Ev();
extern void _ZN10S4947C2_nt3v58Ev();
extern void _ZN10S4947C2_nt3v59Ev();
extern void _ZN10S4947C2_nt3v60Ev();
extern void _ZN10S4947C2_nt3v61Ev();
extern void _ZN10S4947C2_nt3v62Ev();
extern void _ZN10S4947C2_nt3v63Ev();
extern void _ZN10S4947C2_nt3v64Ev();
extern void _ZN10S4947C2_nt3v65Ev();
extern void _ZN10S4947C2_nt3v66Ev();
extern void _ZN10S4947C2_nt3v67Ev();
extern void _ZN10S4947C2_nt3v68Ev();
extern void _ZN10S4947C2_nt3v69Ev();
extern void _ZN10S4947C2_nt3v70Ev();
extern void _ZN10S4947C2_nt3v71Ev();
extern void _ZN10S4947C2_nt3v72Ev();
extern void _ZN10S4947C2_nt3v73Ev();
extern void _ZN10S4947C2_nt3v74Ev();
extern void _ZN10S4947C2_nt3v75Ev();
extern void _ZN10S4947C2_nt3v76Ev();
extern void _ZN10S4947C2_nt3v77Ev();
extern void _ZN10S4947C2_nt3v78Ev();
extern void _ZN10S4947C2_nt3v79Ev();
extern void _ZN10S4947C2_nt3v80Ev();
extern void _ZN10S4947C2_nt3v81Ev();
extern void _ZN10S4947C2_nt3v82Ev();
extern void _ZN10S4947C2_nt3v83Ev();
extern void _ZN10S4947C2_nt3v84Ev();
extern void _ZN10S4947C2_nt3v85Ev();
extern void _ZN10S4947C2_nt3v86Ev();
extern void _ZN10S4947C2_nt3v87Ev();
extern void _ZN10S4947C2_nt3v88Ev();
extern void _ZN10S4947C2_nt3v89Ev();
extern void _ZN10S4947C2_nt3v90Ev();
extern void _ZN10S4947C2_nt3v91Ev();
extern void _ZN10S4947C2_nt3v92Ev();
extern void _ZN10S4947C2_nt3v93Ev();
extern void _ZN10S4947C2_nt3v94Ev();
extern void _ZN10S4947C2_nt3v95Ev();
extern void _ZN10S4947C2_nt3v96Ev();
extern void _ZN10S4947C2_nt3v97Ev();
extern void _ZN10S4947C2_nt3v98Ev();
extern void _ZN10S4947C2_nt3v99Ev();
extern void _ZN10S4947C2_nt4v100Ev();
extern void _ZN10S4947C2_nt4v101Ev();
extern void _ZN10S4947C2_nt4v102Ev();
extern void _ZN10S4947C2_nt4v103Ev();
static  VTBL_ENTRY vtc_S4947C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4947C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S4947C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v103Ev,
};
extern VTBL_ENTRY _ZTI10S4947C2_nt[];
VTBL_ENTRY *P__ZTI10S4947C2_nt = _ZTI10S4947C2_nt; 
extern  VTBL_ENTRY _ZTV10S4947C2_nt[];
Class_Descriptor cd_S4947C2_nt = {  "S4947C2_nt", // class name
  bases_S4947C2_nt, 1,
  &(vtc_S4947C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S4947C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S4947C2_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4947C1  : S4947C2_nt {
  virtual  ~S4947C1(); // _ZN7S4947C1D1Ev
  virtual void  v1(); // _ZN7S4947C12v1Ev
  virtual void  v2(); // _ZN7S4947C12v2Ev
  S4947C1(); // tgen
};
//SIG(1 S4947C1) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC4 Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC7} Fi} Fi Fp[7] FC14{ m Fp Fi FC15{ m} FC15} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC18{ m} FC18}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:16 Fi:16 FC16 FC19 FC21{ m Fp Fi[2] FC20} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2}


 S4947C1 ::~S4947C1(){ note_dtor("S4947C1", this);}
void  S4947C1 ::v1(){vfunc_called(this, "_ZN7S4947C12v1Ev");}
void  S4947C1 ::v2(){vfunc_called(this, "_ZN7S4947C12v2Ev");}
S4947C1 ::S4947C1(){ note_ctor("S4947C1", this);} // tgen

static void Test_S4947C1()
{
  extern Class_Descriptor cd_S4947C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S4947C1, buf);
    S4947C1 *dp, &lv = *(dp=new (buf) S4947C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S4947C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4947C1)");
    check_base_class_offset(lv, (S4947C3_nt*)(S4947C2_nt*), 0, "S4947C1");
    check_base_class_offset(lv, (S4947C2_nt*), 0, "S4947C1");
    test_class_info(&lv, &cd_S4947C1);
    dp->~S4947C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4947C1(Test_S4947C1, "S4947C1", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S4947C1C1Ev();
extern void _ZN7S4947C1D1Ev();
Name_Map name_map_S4947C1[] = {
  NSPAIR(_ZN7S4947C1C1Ev),
  NSPAIR(_ZN7S4947C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4947C3_nt;
extern VTBL_ENTRY _ZTI10S4947C3_nt[];
extern  VTBL_ENTRY _ZTV10S4947C3_nt[];
extern Class_Descriptor cd_S4947C2_nt;
extern VTBL_ENTRY _ZTI10S4947C2_nt[];
extern  VTBL_ENTRY _ZTV10S4947C2_nt[];
static Base_Class bases_S4947C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4947C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4947C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4947C1[];
extern void _ZN7S4947C1D1Ev();
extern void _ZN7S4947C1D0Ev();
extern void _ZN10S4947C3_nt2v3Ev();
extern void _ZN10S4947C3_nt2v4Ev();
extern void _ZN10S4947C3_nt2v5Ev();
extern void _ZN10S4947C3_nt2v6Ev();
extern void _ZN10S4947C3_nt2v7Ev();
extern void _ZN10S4947C3_nt2v8Ev();
extern void _ZN10S4947C3_nt2v9Ev();
extern void _ZN10S4947C3_nt3v10Ev();
extern void _ZN10S4947C3_nt3v11Ev();
extern void _ZN10S4947C3_nt3v12Ev();
extern void _ZN10S4947C3_nt3v13Ev();
extern void _ZN10S4947C3_nt3v14Ev();
extern void _ZN10S4947C3_nt3v15Ev();
extern void _ZN10S4947C3_nt3v16Ev();
extern void _ZN10S4947C3_nt3v17Ev();
extern void _ZN10S4947C3_nt3v18Ev();
extern void _ZN10S4947C3_nt3v19Ev();
extern void _ZN10S4947C3_nt3v20Ev();
extern void _ZN10S4947C3_nt3v21Ev();
extern void _ZN10S4947C3_nt3v22Ev();
extern void _ZN10S4947C3_nt3v23Ev();
extern void _ZN10S4947C3_nt3v24Ev();
extern void _ZN10S4947C3_nt3v25Ev();
extern void _ZN10S4947C2_nt3v26Ev();
extern void _ZN10S4947C2_nt3v27Ev();
extern void _ZN10S4947C2_nt3v28Ev();
extern void _ZN10S4947C2_nt3v29Ev();
extern void _ZN10S4947C2_nt3v30Ev();
extern void _ZN10S4947C2_nt3v31Ev();
extern void _ZN10S4947C2_nt3v32Ev();
extern void _ZN10S4947C2_nt3v33Ev();
extern void _ZN10S4947C2_nt3v34Ev();
extern void _ZN10S4947C2_nt3v35Ev();
extern void _ZN10S4947C2_nt3v36Ev();
extern void _ZN10S4947C2_nt3v37Ev();
extern void _ZN10S4947C2_nt3v38Ev();
extern void _ZN10S4947C2_nt3v39Ev();
extern void _ZN10S4947C2_nt3v40Ev();
extern void _ZN10S4947C2_nt3v41Ev();
extern void _ZN10S4947C2_nt3v42Ev();
extern void _ZN10S4947C2_nt3v43Ev();
extern void _ZN10S4947C2_nt3v44Ev();
extern void _ZN10S4947C2_nt3v45Ev();
extern void _ZN10S4947C2_nt3v46Ev();
extern void _ZN10S4947C2_nt3v47Ev();
extern void _ZN10S4947C2_nt3v48Ev();
extern void _ZN10S4947C2_nt3v49Ev();
extern void _ZN10S4947C2_nt3v50Ev();
extern void _ZN10S4947C2_nt3v51Ev();
extern void _ZN10S4947C2_nt3v52Ev();
extern void _ZN10S4947C2_nt3v53Ev();
extern void _ZN10S4947C2_nt3v54Ev();
extern void _ZN10S4947C2_nt3v55Ev();
extern void _ZN10S4947C2_nt3v56Ev();
extern void _ZN10S4947C2_nt3v57Ev();
extern void _ZN10S4947C2_nt3v58Ev();
extern void _ZN10S4947C2_nt3v59Ev();
extern void _ZN10S4947C2_nt3v60Ev();
extern void _ZN10S4947C2_nt3v61Ev();
extern void _ZN10S4947C2_nt3v62Ev();
extern void _ZN10S4947C2_nt3v63Ev();
extern void _ZN10S4947C2_nt3v64Ev();
extern void _ZN10S4947C2_nt3v65Ev();
extern void _ZN10S4947C2_nt3v66Ev();
extern void _ZN10S4947C2_nt3v67Ev();
extern void _ZN10S4947C2_nt3v68Ev();
extern void _ZN10S4947C2_nt3v69Ev();
extern void _ZN10S4947C2_nt3v70Ev();
extern void _ZN10S4947C2_nt3v71Ev();
extern void _ZN10S4947C2_nt3v72Ev();
extern void _ZN10S4947C2_nt3v73Ev();
extern void _ZN10S4947C2_nt3v74Ev();
extern void _ZN10S4947C2_nt3v75Ev();
extern void _ZN10S4947C2_nt3v76Ev();
extern void _ZN10S4947C2_nt3v77Ev();
extern void _ZN10S4947C2_nt3v78Ev();
extern void _ZN10S4947C2_nt3v79Ev();
extern void _ZN10S4947C2_nt3v80Ev();
extern void _ZN10S4947C2_nt3v81Ev();
extern void _ZN10S4947C2_nt3v82Ev();
extern void _ZN10S4947C2_nt3v83Ev();
extern void _ZN10S4947C2_nt3v84Ev();
extern void _ZN10S4947C2_nt3v85Ev();
extern void _ZN10S4947C2_nt3v86Ev();
extern void _ZN10S4947C2_nt3v87Ev();
extern void _ZN10S4947C2_nt3v88Ev();
extern void _ZN10S4947C2_nt3v89Ev();
extern void _ZN10S4947C2_nt3v90Ev();
extern void _ZN10S4947C2_nt3v91Ev();
extern void _ZN10S4947C2_nt3v92Ev();
extern void _ZN10S4947C2_nt3v93Ev();
extern void _ZN10S4947C2_nt3v94Ev();
extern void _ZN10S4947C2_nt3v95Ev();
extern void _ZN10S4947C2_nt3v96Ev();
extern void _ZN10S4947C2_nt3v97Ev();
extern void _ZN10S4947C2_nt3v98Ev();
extern void _ZN10S4947C2_nt3v99Ev();
extern void _ZN10S4947C2_nt4v100Ev();
extern void _ZN10S4947C2_nt4v101Ev();
extern void _ZN10S4947C2_nt4v102Ev();
extern void _ZN10S4947C2_nt4v103Ev();
extern void _ZN7S4947C12v1Ev();
extern void _ZN7S4947C12v2Ev();
static  VTBL_ENTRY vtc_S4947C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4947C1[0]),
  (VTBL_ENTRY)&_ZN7S4947C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4947C1D0Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S4947C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S4947C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN7S4947C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4947C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S4947C1[];
extern  VTBL_ENTRY _ZTV7S4947C1[];
Class_Descriptor cd_S4947C1 = {  "S4947C1", // class name
  bases_S4947C1, 2,
  &(vtc_S4947C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S4947C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4947C1),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C2_nt  {
  virtual  ~S10248C2_nt(); // _ZN11S10248C2_ntD1Ev
  virtual void  v8(); // _ZN11S10248C2_nt2v8Ev
  virtual void  v9(); // _ZN11S10248C2_nt2v9Ev
  virtual void  v10(); // _ZN11S10248C2_nt3v10Ev
  virtual void  v11(); // _ZN11S10248C2_nt3v11Ev
  virtual void  v12(); // _ZN11S10248C2_nt3v12Ev
  virtual void  v13(); // _ZN11S10248C2_nt3v13Ev
  S10248C2_nt(); // tgen
};
//SIG(-1 S10248C2_nt) C1{ vd v1 v2 v3 v4 v5 v6}


 S10248C2_nt ::~S10248C2_nt(){ note_dtor("S10248C2_nt", this);}
void  S10248C2_nt ::v8(){vfunc_called(this, "_ZN11S10248C2_nt2v8Ev");}
void  S10248C2_nt ::v9(){vfunc_called(this, "_ZN11S10248C2_nt2v9Ev");}
void  S10248C2_nt ::v10(){vfunc_called(this, "_ZN11S10248C2_nt3v10Ev");}
void  S10248C2_nt ::v11(){vfunc_called(this, "_ZN11S10248C2_nt3v11Ev");}
void  S10248C2_nt ::v12(){vfunc_called(this, "_ZN11S10248C2_nt3v12Ev");}
void  S10248C2_nt ::v13(){vfunc_called(this, "_ZN11S10248C2_nt3v13Ev");}
S10248C2_nt ::S10248C2_nt(){ note_ctor("S10248C2_nt", this);} // tgen

//skip512 S10248C2_nt

#else // __cplusplus

extern void _ZN11S10248C2_ntC1Ev();
extern void _ZN11S10248C2_ntD1Ev();
Name_Map name_map_S10248C2_nt[] = {
  NSPAIR(_ZN11S10248C2_ntC1Ev),
  NSPAIR(_ZN11S10248C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10248C2_nt[];
extern void _ZN11S10248C2_ntD1Ev();
extern void _ZN11S10248C2_ntD0Ev();
extern void _ZN11S10248C2_nt2v8Ev();
extern void _ZN11S10248C2_nt2v9Ev();
extern void _ZN11S10248C2_nt3v10Ev();
extern void _ZN11S10248C2_nt3v11Ev();
extern void _ZN11S10248C2_nt3v12Ev();
extern void _ZN11S10248C2_nt3v13Ev();
static  VTBL_ENTRY vtc_S10248C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10248C2_nt[0]),
  (VTBL_ENTRY)&_ZN11S10248C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI11S10248C2_nt[];
VTBL_ENTRY *P__ZTI11S10248C2_nt = _ZTI11S10248C2_nt; 
extern  VTBL_ENTRY _ZTV11S10248C2_nt[];
Class_Descriptor cd_S10248C2_nt = {  "S10248C2_nt", // class name
  0,0,//no base classes
  &(vtc_S10248C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10248C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10248C2_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C3_nt  {
  virtual  ~S10248C3_nt(); // _ZN11S10248C3_ntD1Ev
  virtual void  v14(); // _ZN11S10248C3_nt3v14Ev
  S10248C3_nt(); // tgen
};
//SIG(-1 S10248C3_nt) C1{ vd v1}


 S10248C3_nt ::~S10248C3_nt(){ note_dtor("S10248C3_nt", this);}
void  S10248C3_nt ::v14(){vfunc_called(this, "_ZN11S10248C3_nt3v14Ev");}
S10248C3_nt ::S10248C3_nt(){ note_ctor("S10248C3_nt", this);} // tgen

//skip512 S10248C3_nt

#else // __cplusplus

extern void _ZN11S10248C3_ntC1Ev();
extern void _ZN11S10248C3_ntD1Ev();
Name_Map name_map_S10248C3_nt[] = {
  NSPAIR(_ZN11S10248C3_ntC1Ev),
  NSPAIR(_ZN11S10248C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10248C3_nt[];
extern void _ZN11S10248C3_ntD1Ev();
extern void _ZN11S10248C3_ntD0Ev();
extern void _ZN11S10248C3_nt3v14Ev();
static  VTBL_ENTRY vtc_S10248C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10248C3_nt[0]),
  (VTBL_ENTRY)&_ZN11S10248C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10248C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10248C3_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI11S10248C3_nt[];
VTBL_ENTRY *P__ZTI11S10248C3_nt = _ZTI11S10248C3_nt; 
extern  VTBL_ENTRY _ZTV11S10248C3_nt[];
Class_Descriptor cd_S10248C3_nt = {  "S10248C3_nt", // class name
  0,0,//no base classes
  &(vtc_S10248C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10248C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10248C3_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C4  {
  char s10248c4f0[12];
};
//SIG(-1 S10248C4) C1{ Fc[12]}



static void Test_S10248C4()
{
  {
    init_simple_test("S10248C4");
    S10248C4 lv;
    check2(sizeof(lv), 12, "sizeof(S10248C4)");
    check2(__alignof__(lv), 1, "__alignof__(S10248C4)");
    check_field_offset(lv, s10248c4f0, 0, "S10248C4.s10248c4f0");
  }
}
static Arrange_To_Call_Me vS10248C4(Test_S10248C4, "S10248C4", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C5  {
  char s10248c5f0[128];
};
//SIG(-1 S10248C5) C1{ Fc[128]}



static void Test_S10248C5()
{
  {
    init_simple_test("S10248C5");
    S10248C5 lv;
    check2(sizeof(lv), 128, "sizeof(S10248C5)");
    check2(__alignof__(lv), 1, "__alignof__(S10248C5)");
    check_field_offset(lv, s10248c5f0, 0, "S10248C5.s10248c5f0");
  }
}
static Arrange_To_Call_Me vS10248C5(Test_S10248C5, "S10248C5", 128);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C7_nt  {
  char s10248c7f0[20];
};
//SIG(-1 S10248C7_nt) C1{ Fc[20]}



//skip512 S10248C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C6_nt  {
  ::S10248C7_nt s10248c6f0;
  char s10248c6f1[16];
};
//SIG(-1 S10248C6_nt) C1{ FC2{ Fc[20]} Fc[16]}



//skip512 S10248C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C8  {
  int s10248c8f0[3];
  char s10248c8f1;
  void *s10248c8f2[2];
};
//SIG(-1 S10248C8) C1{ Fi[3] Fc Fp[2]}



static void Test_S10248C8()
{
  {
    init_simple_test("S10248C8");
    S10248C8 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S10248C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C8)");
    check_field_offset(lv, s10248c8f0, 0, "S10248C8.s10248c8f0");
    check_field_offset(lv, s10248c8f1, 12, "S10248C8.s10248c8f1");
    check_field_offset(lv, s10248c8f2, 16, "S10248C8.s10248c8f2");
  }
}
static Arrange_To_Call_Me vS10248C8(Test_S10248C8, "S10248C8", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C9_nt  {
  void *s10248c9f0[2];
  int s10248c9f1;
  void  mf10248c9(); // _ZN11S10248C9_nt9mf10248c9Ev
};
//SIG(-1 S10248C9_nt) C1{ m Fp[2] Fi}


void  S10248C9_nt ::mf10248c9(){}

//skip512 S10248C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C10  {
  void *s10248c10f0[5];
  int s10248c10f1[3];
  void  mf10248c10(); // _ZN9S10248C1010mf10248c10Ev
};
//SIG(-1 S10248C10) C1{ m Fp[5] Fi[3]}


void  S10248C10 ::mf10248c10(){}

static void Test_S10248C10()
{
  {
    init_simple_test("S10248C10");
    S10248C10 lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S10248C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C10)");
    check_field_offset(lv, s10248c10f0, 0, "S10248C10.s10248c10f0");
    check_field_offset(lv, s10248c10f1, ABISELECT(40,20), "S10248C10.s10248c10f1");
  }
}
static Arrange_To_Call_Me vS10248C10(Test_S10248C10, "S10248C10", ABISELECT(56,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C12_nt  {
  long s10248c12f0[4];
};
//SIG(-1 S10248C12_nt) C1{ Fl[4]}



//skip512 S10248C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C11  {
  ::S10248C12_nt s10248c11f0;
  char s10248c11f1;
  void  mf10248c11(); // _ZN9S10248C1110mf10248c11Ev
};
//SIG(-1 S10248C11) C1{ m FC2{ Fl[4]} Fc}


void  S10248C11 ::mf10248c11(){}

static void Test_S10248C11()
{
  {
    init_simple_test("S10248C11");
    S10248C11 lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S10248C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C11)");
    check_field_offset(lv, s10248c11f0, 0, "S10248C11.s10248c11f0");
    check_field_offset(lv, s10248c11f1, ABISELECT(32,16), "S10248C11.s10248c11f1");
  }
}
static Arrange_To_Call_Me vS10248C11(Test_S10248C11, "S10248C11", ABISELECT(40,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C13  {
  long s10248c13f0[2];
  void  mf10248c13(); // _ZN9S10248C1310mf10248c13Ev
};
//SIG(-1 S10248C13) C1{ m Fl[2]}


void  S10248C13 ::mf10248c13(){}

static void Test_S10248C13()
{
  {
    init_simple_test("S10248C13");
    S10248C13 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10248C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C13)");
    check_field_offset(lv, s10248c13f0, 0, "S10248C13.s10248c13f0");
  }
}
static Arrange_To_Call_Me vS10248C13(Test_S10248C13, "S10248C13", ABISELECT(16,8));

#else // __cplusplus

Class_Descriptor cd_S10248C13 = {  "S10248C13", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C15_nt  {
  virtual  ~S10248C15_nt(); // _ZN12S10248C15_ntD1Ev
  virtual void  v24(); // _ZN12S10248C15_nt3v24Ev
  virtual void  v25(); // _ZN12S10248C15_nt3v25Ev
  virtual void  v26(); // _ZN12S10248C15_nt3v26Ev
  virtual void  v27(); // _ZN12S10248C15_nt3v27Ev
  virtual void  v28(); // _ZN12S10248C15_nt3v28Ev
  virtual void  v29(); // _ZN12S10248C15_nt3v29Ev
  virtual void  v30(); // _ZN12S10248C15_nt3v30Ev
  virtual void  v31(); // _ZN12S10248C15_nt3v31Ev
  S10248C15_nt(); // tgen
};
//SIG(-1 S10248C15_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S10248C15_nt ::~S10248C15_nt(){ note_dtor("S10248C15_nt", this);}
void  S10248C15_nt ::v24(){vfunc_called(this, "_ZN12S10248C15_nt3v24Ev");}
void  S10248C15_nt ::v25(){vfunc_called(this, "_ZN12S10248C15_nt3v25Ev");}
void  S10248C15_nt ::v26(){vfunc_called(this, "_ZN12S10248C15_nt3v26Ev");}
void  S10248C15_nt ::v27(){vfunc_called(this, "_ZN12S10248C15_nt3v27Ev");}
void  S10248C15_nt ::v28(){vfunc_called(this, "_ZN12S10248C15_nt3v28Ev");}
void  S10248C15_nt ::v29(){vfunc_called(this, "_ZN12S10248C15_nt3v29Ev");}
void  S10248C15_nt ::v30(){vfunc_called(this, "_ZN12S10248C15_nt3v30Ev");}
void  S10248C15_nt ::v31(){vfunc_called(this, "_ZN12S10248C15_nt3v31Ev");}
S10248C15_nt ::S10248C15_nt(){ note_ctor("S10248C15_nt", this);} // tgen

//skip512 S10248C15_nt

#else // __cplusplus

extern void _ZN12S10248C15_ntC1Ev();
extern void _ZN12S10248C15_ntD1Ev();
Name_Map name_map_S10248C15_nt[] = {
  NSPAIR(_ZN12S10248C15_ntC1Ev),
  NSPAIR(_ZN12S10248C15_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10248C15_nt[];
extern void _ZN12S10248C15_ntD1Ev();
extern void _ZN12S10248C15_ntD0Ev();
extern void _ZN12S10248C15_nt3v24Ev();
extern void _ZN12S10248C15_nt3v25Ev();
extern void _ZN12S10248C15_nt3v26Ev();
extern void _ZN12S10248C15_nt3v27Ev();
extern void _ZN12S10248C15_nt3v28Ev();
extern void _ZN12S10248C15_nt3v29Ev();
extern void _ZN12S10248C15_nt3v30Ev();
extern void _ZN12S10248C15_nt3v31Ev();
static  VTBL_ENTRY vtc_S10248C15_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10248C15_nt[0]),
  (VTBL_ENTRY)&_ZN12S10248C15_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v24Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v30Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI12S10248C15_nt[];
VTBL_ENTRY *P__ZTI12S10248C15_nt = _ZTI12S10248C15_nt; 
extern  VTBL_ENTRY _ZTV12S10248C15_nt[];
Class_Descriptor cd_S10248C15_nt = {  "S10248C15_nt", // class name
  0,0,//no base classes
  &(vtc_S10248C15_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S10248C15_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S10248C15_nt),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C17  {
  virtual  ~S10248C17(); // _ZN9S10248C17D1Ev
  virtual void  v32(); // _ZN9S10248C173v32Ev
  S10248C17(); // tgen
};
//SIG(-1 S10248C17) C1{ vd v1}


 S10248C17 ::~S10248C17(){ note_dtor("S10248C17", this);}
void  S10248C17 ::v32(){vfunc_called(this, "_ZN9S10248C173v32Ev");}
S10248C17 ::S10248C17(){ note_ctor("S10248C17", this);} // tgen

static void Test_S10248C17()
{
  extern Class_Descriptor cd_S10248C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10248C17, buf);
    S10248C17 *dp, &lv = *(dp=new (buf) S10248C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10248C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C17)");
    test_class_info(&lv, &cd_S10248C17);
    dp->~S10248C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C17(Test_S10248C17, "S10248C17", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10248C17C1Ev();
extern void _ZN9S10248C17D1Ev();
Name_Map name_map_S10248C17[] = {
  NSPAIR(_ZN9S10248C17C1Ev),
  NSPAIR(_ZN9S10248C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10248C17[];
extern void _ZN9S10248C17D1Ev();
extern void _ZN9S10248C17D0Ev();
extern void _ZN9S10248C173v32Ev();
static  VTBL_ENTRY vtc_S10248C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C17[0]),
  (VTBL_ENTRY)&_ZN9S10248C17D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C17D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C173v32Ev,
};
extern VTBL_ENTRY _ZTI9S10248C17[];
extern  VTBL_ENTRY _ZTV9S10248C17[];
Class_Descriptor cd_S10248C17 = {  "S10248C17", // class name
  0,0,//no base classes
  &(vtc_S10248C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10248C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10248C17),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C18_nt  {
  void *s10248c18f0;
  virtual  ~S10248C18_nt(); // _ZN12S10248C18_ntD1Ev
  virtual void  v33(); // _ZN12S10248C18_nt3v33Ev
  virtual void  v34(); // _ZN12S10248C18_nt3v34Ev
  virtual void  v35(); // _ZN12S10248C18_nt3v35Ev
  S10248C18_nt(); // tgen
};
//SIG(-1 S10248C18_nt) C1{ vd v1 v2 v3 Fp}


 S10248C18_nt ::~S10248C18_nt(){ note_dtor("S10248C18_nt", this);}
void  S10248C18_nt ::v33(){vfunc_called(this, "_ZN12S10248C18_nt3v33Ev");}
void  S10248C18_nt ::v34(){vfunc_called(this, "_ZN12S10248C18_nt3v34Ev");}
void  S10248C18_nt ::v35(){vfunc_called(this, "_ZN12S10248C18_nt3v35Ev");}
S10248C18_nt ::S10248C18_nt(){ note_ctor("S10248C18_nt", this);} // tgen

//skip512 S10248C18_nt

#else // __cplusplus

extern void _ZN12S10248C18_ntC1Ev();
extern void _ZN12S10248C18_ntD1Ev();
Name_Map name_map_S10248C18_nt[] = {
  NSPAIR(_ZN12S10248C18_ntC1Ev),
  NSPAIR(_ZN12S10248C18_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10248C18_nt[];
extern void _ZN12S10248C18_ntD1Ev();
extern void _ZN12S10248C18_ntD0Ev();
extern void _ZN12S10248C18_nt3v33Ev();
extern void _ZN12S10248C18_nt3v34Ev();
extern void _ZN12S10248C18_nt3v35Ev();
static  VTBL_ENTRY vtc_S10248C18_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10248C18_nt[0]),
  (VTBL_ENTRY)&_ZN12S10248C18_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v33Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v34Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v35Ev,
};
extern VTBL_ENTRY _ZTI12S10248C18_nt[];
VTBL_ENTRY *P__ZTI12S10248C18_nt = _ZTI12S10248C18_nt; 
extern  VTBL_ENTRY _ZTV12S10248C18_nt[];
Class_Descriptor cd_S10248C18_nt = {  "S10248C18_nt", // class name
  0,0,//no base classes
  &(vtc_S10248C18_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI12S10248C18_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S10248C18_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C16  : S10248C17 , S10248C3_nt , S10248C18_nt {
  virtual  ~S10248C16(); // _ZN9S10248C16D1Ev
  virtual void  v36(); // _ZN9S10248C163v36Ev
  S10248C16(); // tgen
};
//SIG(-1 S10248C16) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S10248C16 ::~S10248C16(){ note_dtor("S10248C16", this);}
void  S10248C16 ::v36(){vfunc_called(this, "_ZN9S10248C163v36Ev");}
S10248C16 ::S10248C16(){ note_ctor("S10248C16", this);} // tgen

static void Test_S10248C16()
{
  extern Class_Descriptor cd_S10248C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S10248C16, buf);
    S10248C16 *dp, &lv = *(dp=new (buf) S10248C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10248C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C16)");
    check_base_class_offset(lv, (S10248C17*), 0, "S10248C16");
    check_base_class_offset(lv, (S10248C3_nt*), ABISELECT(8,4), "S10248C16");
    check_base_class_offset(lv, (S10248C18_nt*), ABISELECT(16,8), "S10248C16");
    test_class_info(&lv, &cd_S10248C16);
    dp->~S10248C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C16(Test_S10248C16, "S10248C16", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN9S10248C16C1Ev();
extern void _ZN9S10248C16D1Ev();
Name_Map name_map_S10248C16[] = {
  NSPAIR(_ZN9S10248C16C1Ev),
  NSPAIR(_ZN9S10248C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C17;
extern VTBL_ENTRY _ZTI9S10248C17[];
extern  VTBL_ENTRY _ZTV9S10248C17[];
extern Class_Descriptor cd_S10248C3_nt;
extern VTBL_ENTRY _ZTI11S10248C3_nt[];
extern  VTBL_ENTRY _ZTV11S10248C3_nt[];
extern Class_Descriptor cd_S10248C18_nt;
extern VTBL_ENTRY _ZTI12S10248C18_nt[];
extern  VTBL_ENTRY _ZTV12S10248C18_nt[];
static Base_Class bases_S10248C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10248C3_nt,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10248C18_nt,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10248C16[];
extern void _ZN9S10248C16D1Ev();
extern void _ZN9S10248C16D0Ev();
extern void _ZN9S10248C173v32Ev();
extern void _ZN9S10248C163v36Ev();
extern void ABISELECT(_ZThn8_N9S10248C16D1Ev,_ZThn4_N9S10248C16D1Ev)();
extern void ABISELECT(_ZThn8_N9S10248C16D0Ev,_ZThn4_N9S10248C16D0Ev)();
extern void _ZN11S10248C3_nt3v14Ev();
extern void ABISELECT(_ZThn16_N9S10248C16D1Ev,_ZThn8_N9S10248C16D1Ev)();
extern void ABISELECT(_ZThn16_N9S10248C16D0Ev,_ZThn8_N9S10248C16D0Ev)();
extern void _ZN12S10248C18_nt3v33Ev();
extern void _ZN12S10248C18_nt3v34Ev();
extern void _ZN12S10248C18_nt3v35Ev();
static  VTBL_ENTRY vtc_S10248C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C16[0]),
  (VTBL_ENTRY)&_ZN9S10248C16D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C16D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C173v32Ev,
  (VTBL_ENTRY)&_ZN9S10248C163v36Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10248C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10248C16D1Ev,_ZThn4_N9S10248C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10248C16D0Ev,_ZThn4_N9S10248C16D0Ev),
  (VTBL_ENTRY)&_ZN11S10248C3_nt3v14Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S10248C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10248C16D1Ev,_ZThn8_N9S10248C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10248C16D0Ev,_ZThn8_N9S10248C16D0Ev),
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v33Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v34Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v35Ev,
};
extern VTBL_ENTRY _ZTI9S10248C16[];
extern  VTBL_ENTRY _ZTV9S10248C16[];
Class_Descriptor cd_S10248C16 = {  "S10248C16", // class name
  bases_S10248C16, 3,
  &(vtc_S10248C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI9S10248C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S10248C16),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C19  {
  int s10248c19f0;
  char s10248c19f1[512];
};
//SIG(-1 S10248C19) C1{ Fi Fc[512]}



static void Test_S10248C19()
{
  {
    init_simple_test("S10248C19");
    S10248C19 lv;
    check2(sizeof(lv), 516, "sizeof(S10248C19)");
    check2(__alignof__(lv), 4, "__alignof__(S10248C19)");
    check_field_offset(lv, s10248c19f0, 0, "S10248C19.s10248c19f0");
    check_field_offset(lv, s10248c19f1, 4, "S10248C19.s10248c19f1");
  }
}
static Arrange_To_Call_Me vS10248C19(Test_S10248C19, "S10248C19", 516);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C21  {
  int s10248c21f0;
  char s10248c21f1[512];
};
//SIG(-1 S10248C21) C1{ Fi Fc[512]}



static void Test_S10248C21()
{
  {
    init_simple_test("S10248C21");
    S10248C21 lv;
    check2(sizeof(lv), 516, "sizeof(S10248C21)");
    check2(__alignof__(lv), 4, "__alignof__(S10248C21)");
    check_field_offset(lv, s10248c21f0, 0, "S10248C21.s10248c21f0");
    check_field_offset(lv, s10248c21f1, 4, "S10248C21.s10248c21f1");
  }
}
static Arrange_To_Call_Me vS10248C21(Test_S10248C21, "S10248C21", 516);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C22  {
  void *s10248c22f0;
  int s10248c22f1;
  char s10248c22f2;
};
//SIG(-1 S10248C22) C1{ Fp Fi Fc}



static void Test_S10248C22()
{
  {
    init_simple_test("S10248C22");
    S10248C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S10248C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C22)");
    check_field_offset(lv, s10248c22f0, 0, "S10248C22.s10248c22f0");
    check_field_offset(lv, s10248c22f1, ABISELECT(8,4), "S10248C22.s10248c22f1");
    check_field_offset(lv, s10248c22f2, ABISELECT(12,8), "S10248C22.s10248c22f2");
  }
}
static Arrange_To_Call_Me vS10248C22(Test_S10248C22, "S10248C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C24  {
  virtual  ~S10248C24(); // _ZN9S10248C24D1Ev
  virtual void  v38(); // _ZN9S10248C243v38Ev
  S10248C24(); // tgen
};
//SIG(-1 S10248C24) C1{ vd v1}


 S10248C24 ::~S10248C24(){ note_dtor("S10248C24", this);}
void  S10248C24 ::v38(){vfunc_called(this, "_ZN9S10248C243v38Ev");}
S10248C24 ::S10248C24(){ note_ctor("S10248C24", this);} // tgen

static void Test_S10248C24()
{
  extern Class_Descriptor cd_S10248C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10248C24, buf);
    S10248C24 *dp, &lv = *(dp=new (buf) S10248C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10248C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C24)");
    test_class_info(&lv, &cd_S10248C24);
    dp->~S10248C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C24(Test_S10248C24, "S10248C24", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10248C24C1Ev();
extern void _ZN9S10248C24D1Ev();
Name_Map name_map_S10248C24[] = {
  NSPAIR(_ZN9S10248C24C1Ev),
  NSPAIR(_ZN9S10248C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10248C24[];
extern void _ZN9S10248C24D1Ev();
extern void _ZN9S10248C24D0Ev();
extern void _ZN9S10248C243v38Ev();
static  VTBL_ENTRY vtc_S10248C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C24[0]),
  (VTBL_ENTRY)&_ZN9S10248C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C243v38Ev,
};
extern VTBL_ENTRY _ZTI9S10248C24[];
extern  VTBL_ENTRY _ZTV9S10248C24[];
Class_Descriptor cd_S10248C24 = {  "S10248C24", // class name
  0,0,//no base classes
  &(vtc_S10248C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10248C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10248C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C23  : S10248C24 {
  void *s10248c23f0;
  virtual  ~S10248C23(); // _ZN9S10248C23D1Ev
  virtual void  v37(); // _ZN9S10248C233v37Ev
  S10248C23(); // tgen
};
//SIG(-1 S10248C23) C1{ BC2{ vd v2} vd v1 Fp}


 S10248C23 ::~S10248C23(){ note_dtor("S10248C23", this);}
void  S10248C23 ::v37(){vfunc_called(this, "_ZN9S10248C233v37Ev");}
S10248C23 ::S10248C23(){ note_ctor("S10248C23", this);} // tgen

static void Test_S10248C23()
{
  extern Class_Descriptor cd_S10248C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10248C23, buf);
    S10248C23 *dp, &lv = *(dp=new (buf) S10248C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10248C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C23)");
    check_base_class_offset(lv, (S10248C24*), 0, "S10248C23");
    check_field_offset(lv, s10248c23f0, ABISELECT(8,4), "S10248C23.s10248c23f0");
    test_class_info(&lv, &cd_S10248C23);
    dp->~S10248C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C23(Test_S10248C23, "S10248C23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S10248C23C1Ev();
extern void _ZN9S10248C23D1Ev();
Name_Map name_map_S10248C23[] = {
  NSPAIR(_ZN9S10248C23C1Ev),
  NSPAIR(_ZN9S10248C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C24;
extern VTBL_ENTRY _ZTI9S10248C24[];
extern  VTBL_ENTRY _ZTV9S10248C24[];
static Base_Class bases_S10248C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10248C23[];
extern void _ZN9S10248C23D1Ev();
extern void _ZN9S10248C23D0Ev();
extern void _ZN9S10248C243v38Ev();
extern void _ZN9S10248C233v37Ev();
static  VTBL_ENTRY vtc_S10248C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C23[0]),
  (VTBL_ENTRY)&_ZN9S10248C23D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C23D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C243v38Ev,
  (VTBL_ENTRY)&_ZN9S10248C233v37Ev,
};
extern VTBL_ENTRY _ZTI9S10248C23[];
extern  VTBL_ENTRY _ZTV9S10248C23[];
Class_Descriptor cd_S10248C23 = {  "S10248C23", // class name
  bases_S10248C23, 1,
  &(vtc_S10248C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S10248C23),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10248C23),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C26_nt  {
  int s10248c26f0;
  void  mf10248c26(); // _ZN12S10248C26_nt10mf10248c26Ev
};
//SIG(-1 S10248C26_nt) C1{ m Fi}


void  S10248C26_nt ::mf10248c26(){}

//skip512 S10248C26_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S10248C26_nt[];
VTBL_ENTRY *P__ZTI12S10248C26_nt = _ZTI12S10248C26_nt; 
Class_Descriptor cd_S10248C26_nt = {  "S10248C26_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI12S10248C26_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C28  {
  int s10248c28f0;
  void *s10248c28f1;
};
//SIG(-1 S10248C28) C1{ Fi Fp}



static void Test_S10248C28()
{
  {
    init_simple_test("S10248C28");
    S10248C28 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10248C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C28)");
    check_field_offset(lv, s10248c28f0, 0, "S10248C28.s10248c28f0");
    check_field_offset(lv, s10248c28f1, ABISELECT(8,4), "S10248C28.s10248c28f1");
  }
}
static Arrange_To_Call_Me vS10248C28(Test_S10248C28, "S10248C28", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C27  {
  ::S10248C28 s10248c27f0;
  int s10248c27f1;
  void  mf10248c27(); // _ZN9S10248C2710mf10248c27Ev
};
//SIG(-1 S10248C27) C1{ m FC2{ Fi Fp} Fi}


void  S10248C27 ::mf10248c27(){}

static void Test_S10248C27()
{
  {
    init_simple_test("S10248C27");
    S10248C27 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10248C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C27)");
    check_field_offset(lv, s10248c27f0, 0, "S10248C27.s10248c27f0");
    check_field_offset(lv, s10248c27f1, ABISELECT(16,8), "S10248C27.s10248c27f1");
  }
}
static Arrange_To_Call_Me vS10248C27(Test_S10248C27, "S10248C27", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C33_nt  {
  int s10248c33f0;
};
//SIG(-1 S10248C33_nt) C1{ Fi}



//skip512 S10248C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C32  {
  char s10248c32f0[2];
  short s10248c32f1;
  ::S10248C33_nt s10248c32f2;
  short s10248c32f3;
  char s10248c32f4[6];
};
//SIG(-1 S10248C32) C1{ Fc[2] Fs FC2{ Fi} Fs Fc[6]}



static void Test_S10248C32()
{
  {
    init_simple_test("S10248C32");
    S10248C32 lv;
    check2(sizeof(lv), 16, "sizeof(S10248C32)");
    check2(__alignof__(lv), 4, "__alignof__(S10248C32)");
    check_field_offset(lv, s10248c32f0, 0, "S10248C32.s10248c32f0");
    check_field_offset(lv, s10248c32f1, 2, "S10248C32.s10248c32f1");
    check_field_offset(lv, s10248c32f2, 4, "S10248C32.s10248c32f2");
    check_field_offset(lv, s10248c32f3, 8, "S10248C32.s10248c32f3");
    check_field_offset(lv, s10248c32f4, 10, "S10248C32.s10248c32f4");
  }
}
static Arrange_To_Call_Me vS10248C32(Test_S10248C32, "S10248C32", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C34  {
  int s10248c34f0;
  void *s10248c34f1[3];
  void  mf10248c34(); // _ZN9S10248C3410mf10248c34Ev
};
//SIG(-1 S10248C34) C1{ m Fi Fp[3]}


void  S10248C34 ::mf10248c34(){}

static void Test_S10248C34()
{
  {
    init_simple_test("S10248C34");
    S10248C34 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10248C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C34)");
    check_field_offset(lv, s10248c34f0, 0, "S10248C34.s10248c34f0");
    check_field_offset(lv, s10248c34f1, ABISELECT(8,4), "S10248C34.s10248c34f1");
  }
}
static Arrange_To_Call_Me vS10248C34(Test_S10248C34, "S10248C34", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C31  {
  int s10248c31f0;
  void *s10248c31f1;
  int s10248c31f2;
  ::S10248C32 s10248c31f3;
  int s10248c31f4[3];
  ::S10248C34 s10248c31f5;
  virtual  ~S10248C31(); // _ZN9S10248C31D1Ev
  virtual void  v48(); // _ZN9S10248C313v48Ev
  virtual void  v49(); // _ZN9S10248C313v49Ev
  virtual void  v50(); // _ZN9S10248C313v50Ev
  virtual void  v51(); // _ZN9S10248C313v51Ev
  virtual void  v52(); // _ZN9S10248C313v52Ev
  virtual void  v53(); // _ZN9S10248C313v53Ev
  virtual void  v54(); // _ZN9S10248C313v54Ev
  S10248C31(); // tgen
};
//SIG(-1 S10248C31) C1{ vd v1 v2 v3 v4 v5 v6 v7 Fi Fp Fi FC2{ Fc[2] Fs FC3{ Fi} Fs Fc[6]} Fi[3] FC4{ m Fi Fp[3]}}


 S10248C31 ::~S10248C31(){ note_dtor("S10248C31", this);}
void  S10248C31 ::v48(){vfunc_called(this, "_ZN9S10248C313v48Ev");}
void  S10248C31 ::v49(){vfunc_called(this, "_ZN9S10248C313v49Ev");}
void  S10248C31 ::v50(){vfunc_called(this, "_ZN9S10248C313v50Ev");}
void  S10248C31 ::v51(){vfunc_called(this, "_ZN9S10248C313v51Ev");}
void  S10248C31 ::v52(){vfunc_called(this, "_ZN9S10248C313v52Ev");}
void  S10248C31 ::v53(){vfunc_called(this, "_ZN9S10248C313v53Ev");}
void  S10248C31 ::v54(){vfunc_called(this, "_ZN9S10248C313v54Ev");}
S10248C31 ::S10248C31(){ note_ctor("S10248C31", this);} // tgen

static void Test_S10248C31()
{
  extern Class_Descriptor cd_S10248C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,16)];
    init_test(&cd_S10248C31, buf);
    S10248C31 *dp, &lv = *(dp=new (buf) S10248C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S10248C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C31)");
    check_field_offset(lv, s10248c31f0, ABISELECT(8,4), "S10248C31.s10248c31f0");
    check_field_offset(lv, s10248c31f1, ABISELECT(16,8), "S10248C31.s10248c31f1");
    check_field_offset(lv, s10248c31f2, ABISELECT(24,12), "S10248C31.s10248c31f2");
    check_field_offset(lv, s10248c31f3, ABISELECT(28,16), "S10248C31.s10248c31f3");
    check_field_offset(lv, s10248c31f4, ABISELECT(44,32), "S10248C31.s10248c31f4");
    check_field_offset(lv, s10248c31f5, ABISELECT(56,44), "S10248C31.s10248c31f5");
    test_class_info(&lv, &cd_S10248C31);
    dp->~S10248C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C31(Test_S10248C31, "S10248C31", ABISELECT(88,60));

#else // __cplusplus

extern void _ZN9S10248C31C1Ev();
extern void _ZN9S10248C31D1Ev();
Name_Map name_map_S10248C31[] = {
  NSPAIR(_ZN9S10248C31C1Ev),
  NSPAIR(_ZN9S10248C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10248C31[];
extern void _ZN9S10248C31D1Ev();
extern void _ZN9S10248C31D0Ev();
extern void _ZN9S10248C313v48Ev();
extern void _ZN9S10248C313v49Ev();
extern void _ZN9S10248C313v50Ev();
extern void _ZN9S10248C313v51Ev();
extern void _ZN9S10248C313v52Ev();
extern void _ZN9S10248C313v53Ev();
extern void _ZN9S10248C313v54Ev();
static  VTBL_ENTRY vtc_S10248C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C31[0]),
  (VTBL_ENTRY)&_ZN9S10248C31D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C31D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v48Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v49Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v50Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v51Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v52Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v53Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v54Ev,
};
extern VTBL_ENTRY _ZTI9S10248C31[];
extern  VTBL_ENTRY _ZTV9S10248C31[];
Class_Descriptor cd_S10248C31 = {  "S10248C31", // class name
  0,0,//no base classes
  &(vtc_S10248C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,60), // object size
  NSPAIRA(_ZTI9S10248C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10248C31),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C30  : S10248C31 {
  virtual  ~S10248C30(); // _ZN9S10248C30D1Ev
  virtual void  v42(); // _ZN9S10248C303v42Ev
  virtual void  v43(); // _ZN9S10248C303v43Ev
  virtual void  v44(); // _ZN9S10248C303v44Ev
  virtual void  v45(); // _ZN9S10248C303v45Ev
  virtual void  v46(); // _ZN9S10248C303v46Ev
  virtual void  v47(); // _ZN9S10248C303v47Ev
  S10248C30(); // tgen
};
//SIG(-1 S10248C30) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 Fi Fp Fi FC3{ Fc[2] Fs FC4{ Fi} Fs Fc[6]} Fi[3] FC5{ m Fi Fp[3]}} vd v1 v2 v3 v4 v5 v6}


 S10248C30 ::~S10248C30(){ note_dtor("S10248C30", this);}
void  S10248C30 ::v42(){vfunc_called(this, "_ZN9S10248C303v42Ev");}
void  S10248C30 ::v43(){vfunc_called(this, "_ZN9S10248C303v43Ev");}
void  S10248C30 ::v44(){vfunc_called(this, "_ZN9S10248C303v44Ev");}
void  S10248C30 ::v45(){vfunc_called(this, "_ZN9S10248C303v45Ev");}
void  S10248C30 ::v46(){vfunc_called(this, "_ZN9S10248C303v46Ev");}
void  S10248C30 ::v47(){vfunc_called(this, "_ZN9S10248C303v47Ev");}
S10248C30 ::S10248C30(){ note_ctor("S10248C30", this);} // tgen

static void Test_S10248C30()
{
  extern Class_Descriptor cd_S10248C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,16)];
    init_test(&cd_S10248C30, buf);
    S10248C30 *dp, &lv = *(dp=new (buf) S10248C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S10248C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C30)");
    check_base_class_offset(lv, (S10248C31*), 0, "S10248C30");
    test_class_info(&lv, &cd_S10248C30);
    dp->~S10248C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C30(Test_S10248C30, "S10248C30", ABISELECT(88,60));

#else // __cplusplus

extern void _ZN9S10248C30C1Ev();
extern void _ZN9S10248C30D1Ev();
Name_Map name_map_S10248C30[] = {
  NSPAIR(_ZN9S10248C30C1Ev),
  NSPAIR(_ZN9S10248C30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C31;
extern VTBL_ENTRY _ZTI9S10248C31[];
extern  VTBL_ENTRY _ZTV9S10248C31[];
static Base_Class bases_S10248C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10248C30[];
extern void _ZN9S10248C30D1Ev();
extern void _ZN9S10248C30D0Ev();
extern void _ZN9S10248C313v48Ev();
extern void _ZN9S10248C313v49Ev();
extern void _ZN9S10248C313v50Ev();
extern void _ZN9S10248C313v51Ev();
extern void _ZN9S10248C313v52Ev();
extern void _ZN9S10248C313v53Ev();
extern void _ZN9S10248C313v54Ev();
extern void _ZN9S10248C303v42Ev();
extern void _ZN9S10248C303v43Ev();
extern void _ZN9S10248C303v44Ev();
extern void _ZN9S10248C303v45Ev();
extern void _ZN9S10248C303v46Ev();
extern void _ZN9S10248C303v47Ev();
static  VTBL_ENTRY vtc_S10248C30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C30[0]),
  (VTBL_ENTRY)&_ZN9S10248C30D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C30D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v48Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v49Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v50Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v51Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v52Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v53Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v54Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v42Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v43Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v44Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v45Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v46Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v47Ev,
};
extern VTBL_ENTRY _ZTI9S10248C30[];
extern  VTBL_ENTRY _ZTV9S10248C30[];
Class_Descriptor cd_S10248C30 = {  "S10248C30", // class name
  bases_S10248C30, 1,
  &(vtc_S10248C30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,60), // object size
  NSPAIRA(_ZTI9S10248C30),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10248C30),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C25  {
  char s10248c25f0;
  int s10248c25f1;
  ::S10248C26_nt s10248c25f2;
  ::S10248C27 s10248c25f3;
  void *s10248c25f4;
  ::S10248C9_nt s10248c25f5;
  ::S10248C9_nt s10248c25f6;
  void *s10248c25f7[2];
  int s10248c25f8;
  void *s10248c25f9;
  ::S10248C30 s10248c25f10;
  char s10248c25f11;
  long s10248c25f12;
  ::S10248C13 s10248c25f13;
  long s10248c25f14;
  ::S10248C13 s10248c25f15;
  virtual  ~S10248C25(); // _ZN9S10248C25D1Ev
  virtual void  v39(); // _ZN9S10248C253v39Ev
  virtual void  v40(); // _ZN9S10248C253v40Ev
  virtual void  v41(); // _ZN9S10248C253v41Ev
  S10248C25(); // tgen
};
//SIG(-1 S10248C25) C1{ vd v1 v2 v3 Fc Fi FC2{ m Fi} FC3{ m FC4{ Fi Fp} Fi} Fp FC5{ m Fp[2] Fi} FC5 Fp[2] Fi Fp FC6{ BC7{ vd v10 v11 v12 v13 v14 v15 v16 Fi Fp Fi FC8{ Fc[2] Fs FC9{ Fi} Fs Fc[6]} Fi[3] FC10{ m Fi Fp[3]}} vd v4 v5 v6 v7 v8 v9} Fc Fl FC11{ m Fl[2]} Fl FC11}


 S10248C25 ::~S10248C25(){ note_dtor("S10248C25", this);}
void  S10248C25 ::v39(){vfunc_called(this, "_ZN9S10248C253v39Ev");}
void  S10248C25 ::v40(){vfunc_called(this, "_ZN9S10248C253v40Ev");}
void  S10248C25 ::v41(){vfunc_called(this, "_ZN9S10248C253v41Ev");}
S10248C25 ::S10248C25(){ note_ctor("S10248C25", this);} // tgen

static void Test_S10248C25()
{
  extern Class_Descriptor cd_S10248C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,41)];
    init_test(&cd_S10248C25, buf);
    S10248C25 *dp, &lv = *(dp=new (buf) S10248C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,160), "sizeof(S10248C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C25)");
    check_field_offset(lv, s10248c25f0, ABISELECT(8,4), "S10248C25.s10248c25f0");
    check_field_offset(lv, s10248c25f1, ABISELECT(12,8), "S10248C25.s10248c25f1");
    check_field_offset(lv, s10248c25f2, ABISELECT(16,12), "S10248C25.s10248c25f2");
    check_field_offset(lv, s10248c25f3, ABISELECT(24,16), "S10248C25.s10248c25f3");
    check_field_offset(lv, s10248c25f4, ABISELECT(48,28), "S10248C25.s10248c25f4");
    check_field_offset(lv, s10248c25f5, ABISELECT(56,32), "S10248C25.s10248c25f5");
    check_field_offset(lv, s10248c25f6, ABISELECT(80,44), "S10248C25.s10248c25f6");
    check_field_offset(lv, s10248c25f7, ABISELECT(104,56), "S10248C25.s10248c25f7");
    check_field_offset(lv, s10248c25f8, ABISELECT(120,64), "S10248C25.s10248c25f8");
    check_field_offset(lv, s10248c25f9, ABISELECT(128,68), "S10248C25.s10248c25f9");
    check_field_offset(lv, s10248c25f10, ABISELECT(136,72), "S10248C25.s10248c25f10");
    check_field_offset(lv, s10248c25f11, ABISELECT(224,132), "S10248C25.s10248c25f11");
    check_field_offset(lv, s10248c25f12, ABISELECT(232,136), "S10248C25.s10248c25f12");
    check_field_offset(lv, s10248c25f13, ABISELECT(240,140), "S10248C25.s10248c25f13");
    check_field_offset(lv, s10248c25f14, ABISELECT(256,148), "S10248C25.s10248c25f14");
    check_field_offset(lv, s10248c25f15, ABISELECT(264,152), "S10248C25.s10248c25f15");
    test_class_info(&lv, &cd_S10248C25);
    dp->~S10248C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C25(Test_S10248C25, "S10248C25", ABISELECT(280,160));

#else // __cplusplus

extern void _ZN9S10248C25C1Ev();
extern void _ZN9S10248C25D1Ev();
Name_Map name_map_S10248C25[] = {
  NSPAIR(_ZN9S10248C25C1Ev),
  NSPAIR(_ZN9S10248C25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10248C25[];
extern void _ZN9S10248C25D1Ev();
extern void _ZN9S10248C25D0Ev();
extern void _ZN9S10248C253v39Ev();
extern void _ZN9S10248C253v40Ev();
extern void _ZN9S10248C253v41Ev();
static  VTBL_ENTRY vtc_S10248C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C25[0]),
  (VTBL_ENTRY)&_ZN9S10248C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C253v39Ev,
  (VTBL_ENTRY)&_ZN9S10248C253v40Ev,
  (VTBL_ENTRY)&_ZN9S10248C253v41Ev,
};
extern VTBL_ENTRY _ZTI9S10248C25[];
extern  VTBL_ENTRY _ZTV9S10248C25[];
Class_Descriptor cd_S10248C25 = {  "S10248C25", // class name
  0,0,//no base classes
  &(vtc_S10248C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,160), // object size
  NSPAIRA(_ZTI9S10248C25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10248C25),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C36  : S10248C30 {
  void *s10248c36f0;
  virtual  ~S10248C36(); // _ZN9S10248C36D1Ev
  virtual void  v58(); // _ZN9S10248C363v58Ev
  virtual void  v59(); // _ZN9S10248C363v59Ev
  virtual void  v60(); // _ZN9S10248C363v60Ev
  virtual void  v61(); // _ZN9S10248C363v61Ev
  virtual void  v62(); // _ZN9S10248C363v62Ev
  virtual void  v63(); // _ZN9S10248C363v63Ev
  S10248C36(); // tgen
};
//SIG(-1 S10248C36) C1{ BC2{ BC3{ vd v7 v8 v9 v10 v11 v12 v13 Fi Fp Fi FC4{ Fc[2] Fs FC5{ Fi} Fs Fc[6]} Fi[3] FC6{ m Fi Fp[3]}} vd v14 v15 v16 v17 v18 v19} vd v1 v2 v3 v4 v5 v6 Fp}


 S10248C36 ::~S10248C36(){ note_dtor("S10248C36", this);}
void  S10248C36 ::v58(){vfunc_called(this, "_ZN9S10248C363v58Ev");}
void  S10248C36 ::v59(){vfunc_called(this, "_ZN9S10248C363v59Ev");}
void  S10248C36 ::v60(){vfunc_called(this, "_ZN9S10248C363v60Ev");}
void  S10248C36 ::v61(){vfunc_called(this, "_ZN9S10248C363v61Ev");}
void  S10248C36 ::v62(){vfunc_called(this, "_ZN9S10248C363v62Ev");}
void  S10248C36 ::v63(){vfunc_called(this, "_ZN9S10248C363v63Ev");}
S10248C36 ::S10248C36(){ note_ctor("S10248C36", this);} // tgen

static void Test_S10248C36()
{
  extern Class_Descriptor cd_S10248C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,17)];
    init_test(&cd_S10248C36, buf);
    S10248C36 *dp, &lv = *(dp=new (buf) S10248C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,64), "sizeof(S10248C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C36)");
    check_base_class_offset(lv, (S10248C31*)(S10248C30*), 0, "S10248C36");
    check_base_class_offset(lv, (S10248C30*), 0, "S10248C36");
    check_field_offset(lv, s10248c36f0, ABISELECT(88,60), "S10248C36.s10248c36f0");
    test_class_info(&lv, &cd_S10248C36);
    dp->~S10248C36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C36(Test_S10248C36, "S10248C36", ABISELECT(96,64));

#else // __cplusplus

extern void _ZN9S10248C36C1Ev();
extern void _ZN9S10248C36D1Ev();
Name_Map name_map_S10248C36[] = {
  NSPAIR(_ZN9S10248C36C1Ev),
  NSPAIR(_ZN9S10248C36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C31;
extern VTBL_ENTRY _ZTI9S10248C31[];
extern  VTBL_ENTRY _ZTV9S10248C31[];
extern Class_Descriptor cd_S10248C30;
extern VTBL_ENTRY _ZTI9S10248C30[];
extern  VTBL_ENTRY _ZTV9S10248C30[];
static Base_Class bases_S10248C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10248C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10248C36[];
extern void _ZN9S10248C36D1Ev();
extern void _ZN9S10248C36D0Ev();
extern void _ZN9S10248C313v48Ev();
extern void _ZN9S10248C313v49Ev();
extern void _ZN9S10248C313v50Ev();
extern void _ZN9S10248C313v51Ev();
extern void _ZN9S10248C313v52Ev();
extern void _ZN9S10248C313v53Ev();
extern void _ZN9S10248C313v54Ev();
extern void _ZN9S10248C303v42Ev();
extern void _ZN9S10248C303v43Ev();
extern void _ZN9S10248C303v44Ev();
extern void _ZN9S10248C303v45Ev();
extern void _ZN9S10248C303v46Ev();
extern void _ZN9S10248C303v47Ev();
extern void _ZN9S10248C363v58Ev();
extern void _ZN9S10248C363v59Ev();
extern void _ZN9S10248C363v60Ev();
extern void _ZN9S10248C363v61Ev();
extern void _ZN9S10248C363v62Ev();
extern void _ZN9S10248C363v63Ev();
static  VTBL_ENTRY vtc_S10248C36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C36[0]),
  (VTBL_ENTRY)&_ZN9S10248C36D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C36D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v48Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v49Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v50Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v51Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v52Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v53Ev,
  (VTBL_ENTRY)&_ZN9S10248C313v54Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v42Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v43Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v44Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v45Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v46Ev,
  (VTBL_ENTRY)&_ZN9S10248C303v47Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v58Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v59Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v60Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v61Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v62Ev,
  (VTBL_ENTRY)&_ZN9S10248C363v63Ev,
};
extern VTBL_ENTRY _ZTI9S10248C36[];
extern  VTBL_ENTRY _ZTV9S10248C36[];
Class_Descriptor cd_S10248C36 = {  "S10248C36", // class name
  bases_S10248C36, 2,
  &(vtc_S10248C36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,64), // object size
  NSPAIRA(_ZTI9S10248C36),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10248C36),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C35  {
  char s10248c35f0;
  int s10248c35f1;
  ::S10248C26_nt s10248c35f2;
  ::S10248C27 s10248c35f3;
  void *s10248c35f4;
  ::S10248C9_nt s10248c35f5;
  ::S10248C9_nt s10248c35f6;
  void *s10248c35f7[2];
  int s10248c35f8;
  void *s10248c35f9;
  ::S10248C36 s10248c35f10;
  char s10248c35f11;
  long s10248c35f12;
  ::S10248C13 s10248c35f13;
  long s10248c35f14;
  ::S10248C13 s10248c35f15;
  virtual  ~S10248C35(); // _ZN9S10248C35D1Ev
  virtual void  v55(); // _ZN9S10248C353v55Ev
  virtual void  v56(); // _ZN9S10248C353v56Ev
  virtual void  v57(); // _ZN9S10248C353v57Ev
  S10248C35(); // tgen
};
//SIG(-1 S10248C35) C1{ vd v1 v2 v3 Fc Fi FC2{ m Fi} FC3{ m FC4{ Fi Fp} Fi} Fp FC5{ m Fp[2] Fi} FC5 Fp[2] Fi Fp FC6{ BC7{ BC8{ vd v10 v11 v12 v13 v14 v15 v16 Fi Fp Fi FC9{ Fc[2] Fs FC10{ Fi} Fs Fc[6]} Fi[3] FC11{ m Fi Fp[3]}} vd v17 v18 v19 v20 v21 v22} vd v4 v5 v6 v7 v8 v9 Fp} Fc Fl FC12{ m Fl[2]} Fl FC12}


 S10248C35 ::~S10248C35(){ note_dtor("S10248C35", this);}
void  S10248C35 ::v55(){vfunc_called(this, "_ZN9S10248C353v55Ev");}
void  S10248C35 ::v56(){vfunc_called(this, "_ZN9S10248C353v56Ev");}
void  S10248C35 ::v57(){vfunc_called(this, "_ZN9S10248C353v57Ev");}
S10248C35 ::S10248C35(){ note_ctor("S10248C35", this);} // tgen

static void Test_S10248C35()
{
  extern Class_Descriptor cd_S10248C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,42)];
    init_test(&cd_S10248C35, buf);
    S10248C35 *dp, &lv = *(dp=new (buf) S10248C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,164), "sizeof(S10248C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C35)");
    check_field_offset(lv, s10248c35f0, ABISELECT(8,4), "S10248C35.s10248c35f0");
    check_field_offset(lv, s10248c35f1, ABISELECT(12,8), "S10248C35.s10248c35f1");
    check_field_offset(lv, s10248c35f2, ABISELECT(16,12), "S10248C35.s10248c35f2");
    check_field_offset(lv, s10248c35f3, ABISELECT(24,16), "S10248C35.s10248c35f3");
    check_field_offset(lv, s10248c35f4, ABISELECT(48,28), "S10248C35.s10248c35f4");
    check_field_offset(lv, s10248c35f5, ABISELECT(56,32), "S10248C35.s10248c35f5");
    check_field_offset(lv, s10248c35f6, ABISELECT(80,44), "S10248C35.s10248c35f6");
    check_field_offset(lv, s10248c35f7, ABISELECT(104,56), "S10248C35.s10248c35f7");
    check_field_offset(lv, s10248c35f8, ABISELECT(120,64), "S10248C35.s10248c35f8");
    check_field_offset(lv, s10248c35f9, ABISELECT(128,68), "S10248C35.s10248c35f9");
    check_field_offset(lv, s10248c35f10, ABISELECT(136,72), "S10248C35.s10248c35f10");
    check_field_offset(lv, s10248c35f11, ABISELECT(232,136), "S10248C35.s10248c35f11");
    check_field_offset(lv, s10248c35f12, ABISELECT(240,140), "S10248C35.s10248c35f12");
    check_field_offset(lv, s10248c35f13, ABISELECT(248,144), "S10248C35.s10248c35f13");
    check_field_offset(lv, s10248c35f14, ABISELECT(264,152), "S10248C35.s10248c35f14");
    check_field_offset(lv, s10248c35f15, ABISELECT(272,156), "S10248C35.s10248c35f15");
    test_class_info(&lv, &cd_S10248C35);
    dp->~S10248C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C35(Test_S10248C35, "S10248C35", ABISELECT(288,164));

#else // __cplusplus

extern void _ZN9S10248C35C1Ev();
extern void _ZN9S10248C35D1Ev();
Name_Map name_map_S10248C35[] = {
  NSPAIR(_ZN9S10248C35C1Ev),
  NSPAIR(_ZN9S10248C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10248C35[];
extern void _ZN9S10248C35D1Ev();
extern void _ZN9S10248C35D0Ev();
extern void _ZN9S10248C353v55Ev();
extern void _ZN9S10248C353v56Ev();
extern void _ZN9S10248C353v57Ev();
static  VTBL_ENTRY vtc_S10248C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C35[0]),
  (VTBL_ENTRY)&_ZN9S10248C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C35D0Ev,
  (VTBL_ENTRY)&_ZN9S10248C353v55Ev,
  (VTBL_ENTRY)&_ZN9S10248C353v56Ev,
  (VTBL_ENTRY)&_ZN9S10248C353v57Ev,
};
extern VTBL_ENTRY _ZTI9S10248C35[];
extern  VTBL_ENTRY _ZTV9S10248C35[];
Class_Descriptor cd_S10248C35 = {  "S10248C35", // class name
  0,0,//no base classes
  &(vtc_S10248C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,164), // object size
  NSPAIRA(_ZTI9S10248C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10248C35),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C14  : S10248C15_nt , S10248C16 {
  void *s10248c14f0[3];
  short s10248c14f1;
  char s10248c14f2;
  int s10248c14f3[2];
  ::S10248C19 s10248c14f4;
  ::S10248C19 s10248c14f5;
  ::S10248C21 s10248c14f6;
  short s10248c14f7;
  ::S10248C13 s10248c14f8;
  ::S10248C22 s10248c14f9;
  ::S10248C23 s10248c14f10;
  ::S10248C25 s10248c14f11;
  ::S10248C35 s10248c14f12;
  void *s10248c14f13[20];
  virtual  ~S10248C14(); // _ZN9S10248C14D1Ev
  virtual void  v15(); // _ZN9S10248C143v15Ev
  virtual void  v16(); // _ZN9S10248C143v16Ev
  virtual void  v17(); // _ZN9S10248C143v17Ev
  virtual void  v18(); // _ZN9S10248C143v18Ev
  virtual void  v19(); // _ZN9S10248C143v19Ev
  virtual void  v20(); // _ZN9S10248C143v20Ev
  virtual void  v21(); // _ZN9S10248C143v21Ev
  virtual void  v22(); // _ZN9S10248C143v22Ev
  virtual void  v23(); // _ZN9S10248C143v23Ev
  S10248C14(); // tgen
};
//SIG(1 S10248C14) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 v16 v17} BC3{ BC4{ vd v18} BC5{ vd v19} BC6{ vd v20 v21 v22 Fp} vd v23} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[3] Fs Fc Fi[2] FC7{ Fi Fc[512]} FC7 FC8{ Fi Fc[512]} Fs FC9{ m Fl[2]} FC10{ Fp Fi Fc} FC11{ BC12{ vd v25} vd v24 Fp} FC13{ vd v26 v27 v28 Fc Fi FC14{ m Fi} FC15{ m FC16{ Fi Fp} Fi} Fp FC17{ m Fp[2] Fi} FC17 Fp[2] Fi Fp FC18{ BC19{ vd v35 v36 v37 v38 v39 v40 v41 Fi Fp Fi FC20{ Fc[2] Fs FC21{ Fi} Fs Fc[6]} Fi[3] FC22{ m Fi Fp[3]}} vd v29 v30 v31 v32 v33 v34} Fc Fl FC9 Fl FC9} FC23{ vd v42 v43 v44 Fc Fi FC14 FC15 Fp FC17 FC17 Fp[2] Fi Fp FC24{ BC18 vd v45 v46 v47 v48 v49 v50 Fp} Fc Fl FC9 Fl FC9} Fp[20]}


 S10248C14 ::~S10248C14(){ note_dtor("S10248C14", this);}
void  S10248C14 ::v15(){vfunc_called(this, "_ZN9S10248C143v15Ev");}
void  S10248C14 ::v16(){vfunc_called(this, "_ZN9S10248C143v16Ev");}
void  S10248C14 ::v17(){vfunc_called(this, "_ZN9S10248C143v17Ev");}
void  S10248C14 ::v18(){vfunc_called(this, "_ZN9S10248C143v18Ev");}
void  S10248C14 ::v19(){vfunc_called(this, "_ZN9S10248C143v19Ev");}
void  S10248C14 ::v20(){vfunc_called(this, "_ZN9S10248C143v20Ev");}
void  S10248C14 ::v21(){vfunc_called(this, "_ZN9S10248C143v21Ev");}
void  S10248C14 ::v22(){vfunc_called(this, "_ZN9S10248C143v22Ev");}
void  S10248C14 ::v23(){vfunc_called(this, "_ZN9S10248C143v23Ev");}
S10248C14 ::S10248C14(){ note_ctor("S10248C14", this);} // tgen

static void Test_S10248C14()
{
  extern Class_Descriptor cd_S10248C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(302,508)];
    init_test(&cd_S10248C14, buf);
    S10248C14 *dp, &lv = *(dp=new (buf) S10248C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2408,2028), "sizeof(S10248C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C14)");
    check_base_class_offset(lv, (S10248C15_nt*), 0, "S10248C14");
    check_base_class_offset(lv, (S10248C17*)(S10248C16*), ABISELECT(8,4), "S10248C14");
    check_base_class_offset(lv, (S10248C3_nt*)(S10248C16*), ABISELECT(16,8), "S10248C14");
    check_base_class_offset(lv, (S10248C18_nt*)(S10248C16*), ABISELECT(24,12), "S10248C14");
    check_base_class_offset(lv, (S10248C16*), ABISELECT(8,4), "S10248C14");
    check_field_offset(lv, s10248c14f0, ABISELECT(40,20), "S10248C14.s10248c14f0");
    check_field_offset(lv, s10248c14f1, ABISELECT(64,32), "S10248C14.s10248c14f1");
    check_field_offset(lv, s10248c14f2, ABISELECT(66,34), "S10248C14.s10248c14f2");
    check_field_offset(lv, s10248c14f3, ABISELECT(68,36), "S10248C14.s10248c14f3");
    check_field_offset(lv, s10248c14f4, ABISELECT(76,44), "S10248C14.s10248c14f4");
    check_field_offset(lv, s10248c14f5, ABISELECT(592,560), "S10248C14.s10248c14f5");
    check_field_offset(lv, s10248c14f6, ABISELECT(1108,1076), "S10248C14.s10248c14f6");
    check_field_offset(lv, s10248c14f7, ABISELECT(1624,1592), "S10248C14.s10248c14f7");
    check_field_offset(lv, s10248c14f8, ABISELECT(1632,1596), "S10248C14.s10248c14f8");
    check_field_offset(lv, s10248c14f9, ABISELECT(1648,1604), "S10248C14.s10248c14f9");
    check_field_offset(lv, s10248c14f10, ABISELECT(1664,1616), "S10248C14.s10248c14f10");
    check_field_offset(lv, s10248c14f11, ABISELECT(1680,1624), "S10248C14.s10248c14f11");
    check_field_offset(lv, s10248c14f12, ABISELECT(1960,1784), "S10248C14.s10248c14f12");
    check_field_offset(lv, s10248c14f13, ABISELECT(2248,1948), "S10248C14.s10248c14f13");
    test_class_info(&lv, &cd_S10248C14);
    dp->~S10248C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C14(Test_S10248C14, "S10248C14", ABISELECT(2408,2028));

#else // __cplusplus

extern void _ZN9S10248C14C1Ev();
extern void _ZN9S10248C14D1Ev();
Name_Map name_map_S10248C14[] = {
  NSPAIR(_ZN9S10248C14C1Ev),
  NSPAIR(_ZN9S10248C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C15_nt;
extern VTBL_ENTRY _ZTI12S10248C15_nt[];
extern  VTBL_ENTRY _ZTV12S10248C15_nt[];
extern Class_Descriptor cd_S10248C17;
extern VTBL_ENTRY _ZTI9S10248C17[];
extern  VTBL_ENTRY _ZTV9S10248C17[];
extern Class_Descriptor cd_S10248C3_nt;
extern VTBL_ENTRY _ZTI11S10248C3_nt[];
extern  VTBL_ENTRY _ZTV11S10248C3_nt[];
extern Class_Descriptor cd_S10248C18_nt;
extern VTBL_ENTRY _ZTI12S10248C18_nt[];
extern  VTBL_ENTRY _ZTV12S10248C18_nt[];
extern Class_Descriptor cd_S10248C16;
extern VTBL_ENTRY _ZTI9S10248C16[];
extern  VTBL_ENTRY _ZTV9S10248C16[];
static Base_Class bases_S10248C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10248C17,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10248C3_nt,    ABISELECT(16,8), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10248C18_nt,    ABISELECT(24,12), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10248C16,    ABISELECT(8,4), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10248C14[];
extern void _ZN9S10248C14D1Ev();
extern void _ZN9S10248C14D0Ev();
extern void _ZN12S10248C15_nt3v24Ev();
extern void _ZN12S10248C15_nt3v25Ev();
extern void _ZN12S10248C15_nt3v26Ev();
extern void _ZN12S10248C15_nt3v27Ev();
extern void _ZN12S10248C15_nt3v28Ev();
extern void _ZN12S10248C15_nt3v29Ev();
extern void _ZN12S10248C15_nt3v30Ev();
extern void _ZN12S10248C15_nt3v31Ev();
extern void _ZN9S10248C143v15Ev();
extern void _ZN9S10248C143v16Ev();
extern void _ZN9S10248C143v17Ev();
extern void _ZN9S10248C143v18Ev();
extern void _ZN9S10248C143v19Ev();
extern void _ZN9S10248C143v20Ev();
extern void _ZN9S10248C143v21Ev();
extern void _ZN9S10248C143v22Ev();
extern void _ZN9S10248C143v23Ev();
extern void ABISELECT(_ZThn8_N9S10248C14D1Ev,_ZThn4_N9S10248C14D1Ev)();
extern void ABISELECT(_ZThn8_N9S10248C14D0Ev,_ZThn4_N9S10248C14D0Ev)();
extern void _ZN9S10248C173v32Ev();
extern void _ZN9S10248C163v36Ev();
extern void ABISELECT(_ZThn16_N9S10248C14D1Ev,_ZThn8_N9S10248C14D1Ev)();
extern void ABISELECT(_ZThn16_N9S10248C14D0Ev,_ZThn8_N9S10248C14D0Ev)();
extern void _ZN11S10248C3_nt3v14Ev();
extern void ABISELECT(_ZThn24_N9S10248C14D1Ev,_ZThn12_N9S10248C14D1Ev)();
extern void ABISELECT(_ZThn24_N9S10248C14D0Ev,_ZThn12_N9S10248C14D0Ev)();
extern void _ZN12S10248C18_nt3v33Ev();
extern void _ZN12S10248C18_nt3v34Ev();
extern void _ZN12S10248C18_nt3v35Ev();
static  VTBL_ENTRY vtc_S10248C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10248C14[0]),
  (VTBL_ENTRY)&_ZN9S10248C14D1Ev,
  (VTBL_ENTRY)&_ZN9S10248C14D0Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v24Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v30Ev,
  (VTBL_ENTRY)&_ZN12S10248C15_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v15Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v16Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v17Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v18Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v19Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v20Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v21Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v22Ev,
  (VTBL_ENTRY)&_ZN9S10248C143v23Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10248C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10248C14D1Ev,_ZThn4_N9S10248C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10248C14D0Ev,_ZThn4_N9S10248C14D0Ev),
  (VTBL_ENTRY)&_ZN9S10248C173v32Ev,
  (VTBL_ENTRY)&_ZN9S10248C163v36Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S10248C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10248C14D1Ev,_ZThn8_N9S10248C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10248C14D0Ev,_ZThn8_N9S10248C14D0Ev),
  (VTBL_ENTRY)&_ZN11S10248C3_nt3v14Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S10248C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S10248C14D1Ev,_ZThn12_N9S10248C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S10248C14D0Ev,_ZThn12_N9S10248C14D0Ev),
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v33Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v34Ev,
  (VTBL_ENTRY)&_ZN12S10248C18_nt3v35Ev,
};
extern VTBL_ENTRY _ZTI9S10248C14[];
extern  VTBL_ENTRY _ZTV9S10248C14[];
Class_Descriptor cd_S10248C14 = {  "S10248C14", // class name
  bases_S10248C14, 5,
  &(vtc_S10248C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2408,2028), // object size
  NSPAIRA(_ZTI9S10248C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10248C14),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10248C1  : S10248C2_nt , S10248C3_nt {
  short s10248c1f0;
  ::S10248C4 s10248c1f1;
  ::S10248C5 s10248c1f2;
  ::S10248C6_nt s10248c1f3;
  ::S10248C8 s10248c1f4;
  void *s10248c1f5[3];
  ::S10248C9_nt s10248c1f6;
  char s10248c1f7;
  int s10248c1f8[2];
  char s10248c1f9[32768];
  ::S10248C10 s10248c1f10;
  ::S10248C10 s10248c1f11;
  ::S10248C11 s10248c1f12;
  ::S10248C11 s10248c1f13;
  ::S10248C13 s10248c1f14;
  ::S10248C14 s10248c1f15[4];
  short s10248c1f16[2];
  virtual  ~S10248C1(); // _ZN8S10248C1D1Ev
  virtual void  v1(); // _ZN8S10248C12v1Ev
  virtual void  v2(); // _ZN8S10248C12v2Ev
  virtual void  v3(); // _ZN8S10248C12v3Ev
  virtual void  v4(); // _ZN8S10248C12v4Ev
  virtual void  v5(); // _ZN8S10248C12v5Ev
  virtual void  v6(); // _ZN8S10248C12v6Ev
  virtual void  v7(); // _ZN8S10248C12v7Ev
  S10248C1(); // tgen
};
//SIG(1 S10248C1) C1{ BC2{ vd v8 v9 v10 v11 v12 v13} BC3{ vd v14} vd v1 v2 v3 v4 v5 v6 v7 Fs FC4{ Fc[12]} FC5{ Fc[128]} FC6{ FC7{ Fc[20]} Fc[16]} FC8{ Fi[3] Fc Fp[2]} Fp[3] FC9{ m Fp[2] Fi} Fc Fi[2] Fc[32768] FC10{ m Fp[5] Fi[3]} FC10 FC11{ m FC12{ Fl[4]} Fc} FC11 FC13{ m Fl[2]} FC14{ BC15{ vd v24 v25 v26 v27 v28 v29 v30 v31} BC16{ BC17{ vd v32} BC3 BC18{ vd v33 v34 v35 Fp} vd v36} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp[3] Fs Fc Fi[2] FC19{ Fi Fc[512]} FC19 FC20{ Fi Fc[512]} Fs FC13 FC21{ Fp Fi Fc} FC22{ BC23{ vd v38} vd v37 Fp} FC24{ vd v39 v40 v41 Fc Fi FC25{ m Fi} FC26{ m FC27{ Fi Fp} Fi} Fp FC9 FC9 Fp[2] Fi Fp FC28{ BC29{ vd v48 v49 v50 v51 v52 v53 v54 Fi Fp Fi FC30{ Fc[2] Fs FC31{ Fi} Fs Fc[6]} Fi[3] FC32{ m Fi Fp[3]}} vd v42 v43 v44 v45 v46 v47} Fc Fl FC13 Fl FC13} FC33{ vd v55 v56 v57 Fc Fi FC25 FC26 Fp FC9 FC9 Fp[2] Fi Fp FC34{ BC28 vd v58 v59 v60 v61 v62 v63 Fp} Fc Fl FC13 Fl FC13} Fp[20]}[4] Fs[2]}


 S10248C1 ::~S10248C1(){ note_dtor("S10248C1", this);}
void  S10248C1 ::v1(){vfunc_called(this, "_ZN8S10248C12v1Ev");}
void  S10248C1 ::v2(){vfunc_called(this, "_ZN8S10248C12v2Ev");}
void  S10248C1 ::v3(){vfunc_called(this, "_ZN8S10248C12v3Ev");}
void  S10248C1 ::v4(){vfunc_called(this, "_ZN8S10248C12v4Ev");}
void  S10248C1 ::v5(){vfunc_called(this, "_ZN8S10248C12v5Ev");}
void  S10248C1 ::v6(){vfunc_called(this, "_ZN8S10248C12v6Ev");}
void  S10248C1 ::v7(){vfunc_called(this, "_ZN8S10248C12v7Ev");}
S10248C1 ::S10248C1(){ note_ctor("S10248C1", this);} // tgen

static void Test_S10248C1()
{
  extern Class_Descriptor cd_S10248C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5365,10312)];
    init_test(&cd_S10248C1, buf);
    S10248C1 *dp, &lv = *(dp=new (buf) S10248C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(42912,41244), "sizeof(S10248C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10248C1)");
    check_base_class_offset(lv, (S10248C2_nt*), 0, "S10248C1");
    check_base_class_offset(lv, (S10248C3_nt*), ABISELECT(8,4), "S10248C1");
    check_field_offset(lv, s10248c1f0, ABISELECT(16,8), "S10248C1.s10248c1f0");
    check_field_offset(lv, s10248c1f1, ABISELECT(18,10), "S10248C1.s10248c1f1");
    check_field_offset(lv, s10248c1f2, ABISELECT(30,22), "S10248C1.s10248c1f2");
    check_field_offset(lv, s10248c1f3, ABISELECT(158,150), "S10248C1.s10248c1f3");
    check_field_offset(lv, s10248c1f4, ABISELECT(200,188), "S10248C1.s10248c1f4");
    check_field_offset(lv, s10248c1f5, ABISELECT(232,212), "S10248C1.s10248c1f5");
    check_field_offset(lv, s10248c1f6, ABISELECT(256,224), "S10248C1.s10248c1f6");
    check_field_offset(lv, s10248c1f7, ABISELECT(280,236), "S10248C1.s10248c1f7");
    check_field_offset(lv, s10248c1f8, ABISELECT(284,240), "S10248C1.s10248c1f8");
    check_field_offset(lv, s10248c1f9, ABISELECT(292,248), "S10248C1.s10248c1f9");
    check_field_offset(lv, s10248c1f10, ABISELECT(33064,33016), "S10248C1.s10248c1f10");
    check_field_offset(lv, s10248c1f11, ABISELECT(33120,33048), "S10248C1.s10248c1f11");
    check_field_offset(lv, s10248c1f12, ABISELECT(33176,33080), "S10248C1.s10248c1f12");
    check_field_offset(lv, s10248c1f13, ABISELECT(33216,33100), "S10248C1.s10248c1f13");
    check_field_offset(lv, s10248c1f14, ABISELECT(33256,33120), "S10248C1.s10248c1f14");
    check_field_offset(lv, s10248c1f15, ABISELECT(33272,33128), "S10248C1.s10248c1f15");
    check_field_offset(lv, s10248c1f16, ABISELECT(42904,41240), "S10248C1.s10248c1f16");
    test_class_info(&lv, &cd_S10248C1);
    dp->~S10248C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10248C1(Test_S10248C1, "S10248C1", ABISELECT(42912,41244));

#else // __cplusplus

extern void _ZN8S10248C1C1Ev();
extern void _ZN8S10248C1D1Ev();
Name_Map name_map_S10248C1[] = {
  NSPAIR(_ZN8S10248C1C1Ev),
  NSPAIR(_ZN8S10248C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10248C2_nt;
extern VTBL_ENTRY _ZTI11S10248C2_nt[];
extern  VTBL_ENTRY _ZTV11S10248C2_nt[];
extern Class_Descriptor cd_S10248C3_nt;
extern VTBL_ENTRY _ZTI11S10248C3_nt[];
extern  VTBL_ENTRY _ZTV11S10248C3_nt[];
static Base_Class bases_S10248C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10248C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10248C3_nt,    ABISELECT(8,4), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10248C1[];
extern void _ZN8S10248C1D1Ev();
extern void _ZN8S10248C1D0Ev();
extern void _ZN11S10248C2_nt2v8Ev();
extern void _ZN11S10248C2_nt2v9Ev();
extern void _ZN11S10248C2_nt3v10Ev();
extern void _ZN11S10248C2_nt3v11Ev();
extern void _ZN11S10248C2_nt3v12Ev();
extern void _ZN11S10248C2_nt3v13Ev();
extern void _ZN8S10248C12v1Ev();
extern void _ZN8S10248C12v2Ev();
extern void _ZN8S10248C12v3Ev();
extern void _ZN8S10248C12v4Ev();
extern void _ZN8S10248C12v5Ev();
extern void _ZN8S10248C12v6Ev();
extern void _ZN8S10248C12v7Ev();
extern void ABISELECT(_ZThn8_N8S10248C1D1Ev,_ZThn4_N8S10248C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10248C1D0Ev,_ZThn4_N8S10248C1D0Ev)();
extern void _ZN11S10248C3_nt3v14Ev();
static  VTBL_ENTRY vtc_S10248C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10248C1[0]),
  (VTBL_ENTRY)&_ZN8S10248C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10248C1D0Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt2v8Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S10248C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10248C12v7Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10248C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10248C1D1Ev,_ZThn4_N8S10248C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10248C1D0Ev,_ZThn4_N8S10248C1D0Ev),
  (VTBL_ENTRY)&_ZN11S10248C3_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI8S10248C1[];
extern  VTBL_ENTRY _ZTV8S10248C1[];
Class_Descriptor cd_S10248C1 = {  "S10248C1", // class name
  bases_S10248C1, 2,
  &(vtc_S10248C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(42912,41244), // object size
  NSPAIRA(_ZTI8S10248C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10248C1),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C2  {
  virtual  ~S10249C2(); // _ZN8S10249C2D1Ev
  virtual void  v8(); // _ZN8S10249C22v8Ev
  virtual void  v9(); // _ZN8S10249C22v9Ev
  virtual void  v10(); // _ZN8S10249C23v10Ev
  virtual void  v11(); // _ZN8S10249C23v11Ev
  virtual void  v12(); // _ZN8S10249C23v12Ev
  virtual void  v13(); // _ZN8S10249C23v13Ev
  S10249C2(); // tgen
};
//SIG(-1 S10249C2) C1{ vd v1 v2 v3 v4 v5 v6}


 S10249C2 ::~S10249C2(){ note_dtor("S10249C2", this);}
void  S10249C2 ::v8(){vfunc_called(this, "_ZN8S10249C22v8Ev");}
void  S10249C2 ::v9(){vfunc_called(this, "_ZN8S10249C22v9Ev");}
void  S10249C2 ::v10(){vfunc_called(this, "_ZN8S10249C23v10Ev");}
void  S10249C2 ::v11(){vfunc_called(this, "_ZN8S10249C23v11Ev");}
void  S10249C2 ::v12(){vfunc_called(this, "_ZN8S10249C23v12Ev");}
void  S10249C2 ::v13(){vfunc_called(this, "_ZN8S10249C23v13Ev");}
S10249C2 ::S10249C2(){ note_ctor("S10249C2", this);} // tgen

static void Test_S10249C2()
{
  extern Class_Descriptor cd_S10249C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10249C2, buf);
    S10249C2 *dp, &lv = *(dp=new (buf) S10249C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10249C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C2)");
    test_class_info(&lv, &cd_S10249C2);
    dp->~S10249C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C2(Test_S10249C2, "S10249C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10249C2C1Ev();
extern void _ZN8S10249C2D1Ev();
Name_Map name_map_S10249C2[] = {
  NSPAIR(_ZN8S10249C2C1Ev),
  NSPAIR(_ZN8S10249C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10249C2[];
extern void _ZN8S10249C2D1Ev();
extern void _ZN8S10249C2D0Ev();
extern void _ZN8S10249C22v8Ev();
extern void _ZN8S10249C22v9Ev();
extern void _ZN8S10249C23v10Ev();
extern void _ZN8S10249C23v11Ev();
extern void _ZN8S10249C23v12Ev();
extern void _ZN8S10249C23v13Ev();
static  VTBL_ENTRY vtc_S10249C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10249C2[0]),
  (VTBL_ENTRY)&_ZN8S10249C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10249C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10249C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10249C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v11Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v12Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v13Ev,
};
extern VTBL_ENTRY _ZTI8S10249C2[];
extern  VTBL_ENTRY _ZTV8S10249C2[];
Class_Descriptor cd_S10249C2 = {  "S10249C2", // class name
  0,0,//no base classes
  &(vtc_S10249C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10249C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10249C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C3  {
  virtual  ~S10249C3(); // _ZN8S10249C3D1Ev
  virtual void  v14(); // _ZN8S10249C33v14Ev
  S10249C3(); // tgen
};
//SIG(-1 S10249C3) C1{ vd v1}


 S10249C3 ::~S10249C3(){ note_dtor("S10249C3", this);}
void  S10249C3 ::v14(){vfunc_called(this, "_ZN8S10249C33v14Ev");}
S10249C3 ::S10249C3(){ note_ctor("S10249C3", this);} // tgen

static void Test_S10249C3()
{
  extern Class_Descriptor cd_S10249C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10249C3, buf);
    S10249C3 *dp, &lv = *(dp=new (buf) S10249C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10249C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C3)");
    test_class_info(&lv, &cd_S10249C3);
    dp->~S10249C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C3(Test_S10249C3, "S10249C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10249C3C1Ev();
extern void _ZN8S10249C3D1Ev();
Name_Map name_map_S10249C3[] = {
  NSPAIR(_ZN8S10249C3C1Ev),
  NSPAIR(_ZN8S10249C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10249C3[];
extern void _ZN8S10249C3D1Ev();
extern void _ZN8S10249C3D0Ev();
extern void _ZN8S10249C33v14Ev();
static  VTBL_ENTRY vtc_S10249C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10249C3[0]),
  (VTBL_ENTRY)&_ZN8S10249C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10249C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10249C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10249C3[];
extern  VTBL_ENTRY _ZTV8S10249C3[];
Class_Descriptor cd_S10249C3 = {  "S10249C3", // class name
  0,0,//no base classes
  &(vtc_S10249C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10249C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10249C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C12_nt  {
  __tsi64 s10249c12f0[4];
};
//SIG(-1 S10249C12_nt) C1{ FL[4]}



//skip512 S10249C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C11  {
  ::S10249C12_nt s10249c11f0;
  char s10249c11f1;
  void  mf10249c11(); // _ZN9S10249C1110mf10249c11Ev
};
//SIG(-1 S10249C11) C1{ m FC2{ FL[4]} Fc}


void  S10249C11 ::mf10249c11(){}

static void Test_S10249C11()
{
  {
    init_simple_test("S10249C11");
    S10249C11 lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S10249C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C11)");
    check_field_offset(lv, s10249c11f0, 0, "S10249C11.s10249c11f0");
    check_field_offset(lv, s10249c11f1, 32, "S10249C11.s10249c11f1");
  }
}
static Arrange_To_Call_Me vS10249C11(Test_S10249C11, "S10249C11", ABISELECT(40,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C15  {
  virtual  ~S10249C15(); // _ZN9S10249C15D1Ev
  virtual void  v24(); // _ZN9S10249C153v24Ev
  virtual void  v25(); // _ZN9S10249C153v25Ev
  virtual void  v26(); // _ZN9S10249C153v26Ev
  virtual void  v27(); // _ZN9S10249C153v27Ev
  virtual void  v28(); // _ZN9S10249C153v28Ev
  virtual void  v29(); // _ZN9S10249C153v29Ev
  virtual void  v30(); // _ZN9S10249C153v30Ev
  virtual void  v31(); // _ZN9S10249C153v31Ev
  S10249C15(); // tgen
};
//SIG(-1 S10249C15) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8}


 S10249C15 ::~S10249C15(){ note_dtor("S10249C15", this);}
void  S10249C15 ::v24(){vfunc_called(this, "_ZN9S10249C153v24Ev");}
void  S10249C15 ::v25(){vfunc_called(this, "_ZN9S10249C153v25Ev");}
void  S10249C15 ::v26(){vfunc_called(this, "_ZN9S10249C153v26Ev");}
void  S10249C15 ::v27(){vfunc_called(this, "_ZN9S10249C153v27Ev");}
void  S10249C15 ::v28(){vfunc_called(this, "_ZN9S10249C153v28Ev");}
void  S10249C15 ::v29(){vfunc_called(this, "_ZN9S10249C153v29Ev");}
void  S10249C15 ::v30(){vfunc_called(this, "_ZN9S10249C153v30Ev");}
void  S10249C15 ::v31(){vfunc_called(this, "_ZN9S10249C153v31Ev");}
S10249C15 ::S10249C15(){ note_ctor("S10249C15", this);} // tgen

static void Test_S10249C15()
{
  extern Class_Descriptor cd_S10249C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10249C15, buf);
    S10249C15 *dp, &lv = *(dp=new (buf) S10249C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10249C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C15)");
    test_class_info(&lv, &cd_S10249C15);
    dp->~S10249C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C15(Test_S10249C15, "S10249C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10249C15C1Ev();
extern void _ZN9S10249C15D1Ev();
Name_Map name_map_S10249C15[] = {
  NSPAIR(_ZN9S10249C15C1Ev),
  NSPAIR(_ZN9S10249C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C15[];
extern void _ZN9S10249C15D1Ev();
extern void _ZN9S10249C15D0Ev();
extern void _ZN9S10249C153v24Ev();
extern void _ZN9S10249C153v25Ev();
extern void _ZN9S10249C153v26Ev();
extern void _ZN9S10249C153v27Ev();
extern void _ZN9S10249C153v28Ev();
extern void _ZN9S10249C153v29Ev();
extern void _ZN9S10249C153v30Ev();
extern void _ZN9S10249C153v31Ev();
static  VTBL_ENTRY vtc_S10249C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C15[0]),
  (VTBL_ENTRY)&_ZN9S10249C15D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C15D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v24Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v25Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v26Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v27Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v28Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v29Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v30Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v31Ev,
};
extern VTBL_ENTRY _ZTI9S10249C15[];
extern  VTBL_ENTRY _ZTV9S10249C15[];
Class_Descriptor cd_S10249C15 = {  "S10249C15", // class name
  0,0,//no base classes
  &(vtc_S10249C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10249C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C15),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C17  {
  virtual  ~S10249C17(); // _ZN9S10249C17D1Ev
  virtual void  v32(); // _ZN9S10249C173v32Ev
  S10249C17(); // tgen
};
//SIG(-1 S10249C17) C1{ vd v1}


 S10249C17 ::~S10249C17(){ note_dtor("S10249C17", this);}
void  S10249C17 ::v32(){vfunc_called(this, "_ZN9S10249C173v32Ev");}
S10249C17 ::S10249C17(){ note_ctor("S10249C17", this);} // tgen

static void Test_S10249C17()
{
  extern Class_Descriptor cd_S10249C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10249C17, buf);
    S10249C17 *dp, &lv = *(dp=new (buf) S10249C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10249C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C17)");
    test_class_info(&lv, &cd_S10249C17);
    dp->~S10249C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C17(Test_S10249C17, "S10249C17", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10249C17C1Ev();
extern void _ZN9S10249C17D1Ev();
Name_Map name_map_S10249C17[] = {
  NSPAIR(_ZN9S10249C17C1Ev),
  NSPAIR(_ZN9S10249C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C17[];
extern void _ZN9S10249C17D1Ev();
extern void _ZN9S10249C17D0Ev();
extern void _ZN9S10249C173v32Ev();
static  VTBL_ENTRY vtc_S10249C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C17[0]),
  (VTBL_ENTRY)&_ZN9S10249C17D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C17D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C173v32Ev,
};
extern VTBL_ENTRY _ZTI9S10249C17[];
extern  VTBL_ENTRY _ZTV9S10249C17[];
Class_Descriptor cd_S10249C17 = {  "S10249C17", // class name
  0,0,//no base classes
  &(vtc_S10249C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10249C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C17),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C18  {
  void *s10249c18f0;
  virtual  ~S10249C18(); // _ZN9S10249C18D1Ev
  virtual void  v33(); // _ZN9S10249C183v33Ev
  virtual void  v34(); // _ZN9S10249C183v34Ev
  virtual void  v35(); // _ZN9S10249C183v35Ev
  S10249C18(); // tgen
};
//SIG(-1 S10249C18) C1{ vd v1 v2 v3 Fp}


 S10249C18 ::~S10249C18(){ note_dtor("S10249C18", this);}
void  S10249C18 ::v33(){vfunc_called(this, "_ZN9S10249C183v33Ev");}
void  S10249C18 ::v34(){vfunc_called(this, "_ZN9S10249C183v34Ev");}
void  S10249C18 ::v35(){vfunc_called(this, "_ZN9S10249C183v35Ev");}
S10249C18 ::S10249C18(){ note_ctor("S10249C18", this);} // tgen

static void Test_S10249C18()
{
  extern Class_Descriptor cd_S10249C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S10249C18, buf);
    S10249C18 *dp, &lv = *(dp=new (buf) S10249C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10249C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C18)");
    check_field_offset(lv, s10249c18f0, ABISELECT(8,4), "S10249C18.s10249c18f0");
    test_class_info(&lv, &cd_S10249C18);
    dp->~S10249C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C18(Test_S10249C18, "S10249C18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S10249C18C1Ev();
extern void _ZN9S10249C18D1Ev();
Name_Map name_map_S10249C18[] = {
  NSPAIR(_ZN9S10249C18C1Ev),
  NSPAIR(_ZN9S10249C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C18[];
extern void _ZN9S10249C18D1Ev();
extern void _ZN9S10249C18D0Ev();
extern void _ZN9S10249C183v33Ev();
extern void _ZN9S10249C183v34Ev();
extern void _ZN9S10249C183v35Ev();
static  VTBL_ENTRY vtc_S10249C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C18[0]),
  (VTBL_ENTRY)&_ZN9S10249C18D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C18D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v33Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v34Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v35Ev,
};
extern VTBL_ENTRY _ZTI9S10249C18[];
extern  VTBL_ENTRY _ZTV9S10249C18[];
Class_Descriptor cd_S10249C18 = {  "S10249C18", // class name
  0,0,//no base classes
  &(vtc_S10249C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S10249C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C18),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C16  : S10249C17 , S10249C3 , S10249C18 {
  virtual  ~S10249C16(); // _ZN9S10249C16D1Ev
  virtual void  v36(); // _ZN9S10249C163v36Ev
  S10249C16(); // tgen
};
//SIG(-1 S10249C16) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S10249C16 ::~S10249C16(){ note_dtor("S10249C16", this);}
void  S10249C16 ::v36(){vfunc_called(this, "_ZN9S10249C163v36Ev");}
S10249C16 ::S10249C16(){ note_ctor("S10249C16", this);} // tgen

static void Test_S10249C16()
{
  extern Class_Descriptor cd_S10249C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S10249C16, buf);
    S10249C16 *dp, &lv = *(dp=new (buf) S10249C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S10249C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C16)");
    check_base_class_offset(lv, (S10249C17*), 0, "S10249C16");
    check_base_class_offset(lv, (S10249C3*), ABISELECT(8,4), "S10249C16");
    check_base_class_offset(lv, (S10249C18*), ABISELECT(16,8), "S10249C16");
    test_class_info(&lv, &cd_S10249C16);
    dp->~S10249C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C16(Test_S10249C16, "S10249C16", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN9S10249C16C1Ev();
extern void _ZN9S10249C16D1Ev();
Name_Map name_map_S10249C16[] = {
  NSPAIR(_ZN9S10249C16C1Ev),
  NSPAIR(_ZN9S10249C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10249C17;
extern VTBL_ENTRY _ZTI9S10249C17[];
extern  VTBL_ENTRY _ZTV9S10249C17[];
extern Class_Descriptor cd_S10249C3;
extern VTBL_ENTRY _ZTI8S10249C3[];
extern  VTBL_ENTRY _ZTV8S10249C3[];
extern Class_Descriptor cd_S10249C18;
extern VTBL_ENTRY _ZTI9S10249C18[];
extern  VTBL_ENTRY _ZTV9S10249C18[];
static Base_Class bases_S10249C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10249C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10249C3,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10249C18,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10249C16[];
extern void _ZN9S10249C16D1Ev();
extern void _ZN9S10249C16D0Ev();
extern void _ZN9S10249C173v32Ev();
extern void _ZN9S10249C163v36Ev();
extern void ABISELECT(_ZThn8_N9S10249C16D1Ev,_ZThn4_N9S10249C16D1Ev)();
extern void ABISELECT(_ZThn8_N9S10249C16D0Ev,_ZThn4_N9S10249C16D0Ev)();
extern void _ZN8S10249C33v14Ev();
extern void ABISELECT(_ZThn16_N9S10249C16D1Ev,_ZThn8_N9S10249C16D1Ev)();
extern void ABISELECT(_ZThn16_N9S10249C16D0Ev,_ZThn8_N9S10249C16D0Ev)();
extern void _ZN9S10249C183v33Ev();
extern void _ZN9S10249C183v34Ev();
extern void _ZN9S10249C183v35Ev();
static  VTBL_ENTRY vtc_S10249C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C16[0]),
  (VTBL_ENTRY)&_ZN9S10249C16D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C16D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C173v32Ev,
  (VTBL_ENTRY)&_ZN9S10249C163v36Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10249C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10249C16D1Ev,_ZThn4_N9S10249C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10249C16D0Ev,_ZThn4_N9S10249C16D0Ev),
  (VTBL_ENTRY)&_ZN8S10249C33v14Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S10249C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10249C16D1Ev,_ZThn8_N9S10249C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10249C16D0Ev,_ZThn8_N9S10249C16D0Ev),
  (VTBL_ENTRY)&_ZN9S10249C183v33Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v34Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v35Ev,
};
extern VTBL_ENTRY _ZTI9S10249C16[];
extern  VTBL_ENTRY _ZTV9S10249C16[];
Class_Descriptor cd_S10249C16 = {  "S10249C16", // class name
  bases_S10249C16, 3,
  &(vtc_S10249C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI9S10249C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S10249C16),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C21  {
  int s10249c21f0;
  char s10249c21f1[512];
};
//SIG(-1 S10249C21) C1{ Fi Fc[512]}



static void Test_S10249C21()
{
  {
    init_simple_test("S10249C21");
    S10249C21 lv;
    check2(sizeof(lv), 516, "sizeof(S10249C21)");
    check2(__alignof__(lv), 4, "__alignof__(S10249C21)");
    check_field_offset(lv, s10249c21f0, 0, "S10249C21.s10249c21f0");
    check_field_offset(lv, s10249c21f1, 4, "S10249C21.s10249c21f1");
  }
}
static Arrange_To_Call_Me vS10249C21(Test_S10249C21, "S10249C21", 516);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C29  {
  void *s10249c29f0[2];
  int s10249c29f1;
  void  mf10249c29(); // _ZN9S10249C2910mf10249c29Ev
};
//SIG(-1 S10249C29) C1{ m Fp[2] Fi}


void  S10249C29 ::mf10249c29(){}

static void Test_S10249C29()
{
  {
    init_simple_test("S10249C29");
    S10249C29 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S10249C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C29)");
    check_field_offset(lv, s10249c29f0, 0, "S10249C29.s10249c29f0");
    check_field_offset(lv, s10249c29f1, ABISELECT(16,8), "S10249C29.s10249c29f1");
  }
}
static Arrange_To_Call_Me vS10249C29(Test_S10249C29, "S10249C29", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C31  {
  int s10249c31f0;
  void *s10249c31f1;
  int s10249c31f2;
  ::S10248C32 s10249c31f3;
  int s10249c31f4[3];
  ::S10248C34 s10249c31f5;
  virtual  ~S10249C31(); // _ZN9S10249C31D1Ev
  virtual void  v48(); // _ZN9S10249C313v48Ev
  virtual void  v49(); // _ZN9S10249C313v49Ev
  virtual void  v50(); // _ZN9S10249C313v50Ev
  virtual void  v51(); // _ZN9S10249C313v51Ev
  virtual void  v52(); // _ZN9S10249C313v52Ev
  virtual void  v53(); // _ZN9S10249C313v53Ev
  virtual void  v54(); // _ZN9S10249C313v54Ev
  S10249C31(); // tgen
};
//SIG(-1 S10249C31) C1{ vd v1 v2 v3 v4 v5 v6 v7 Fi Fp Fi FC2{ Fc[2] Fs FC3{ Fi} Fs Fc[6]} Fi[3] FC4{ m Fi Fp[3]}}


 S10249C31 ::~S10249C31(){ note_dtor("S10249C31", this);}
void  S10249C31 ::v48(){vfunc_called(this, "_ZN9S10249C313v48Ev");}
void  S10249C31 ::v49(){vfunc_called(this, "_ZN9S10249C313v49Ev");}
void  S10249C31 ::v50(){vfunc_called(this, "_ZN9S10249C313v50Ev");}
void  S10249C31 ::v51(){vfunc_called(this, "_ZN9S10249C313v51Ev");}
void  S10249C31 ::v52(){vfunc_called(this, "_ZN9S10249C313v52Ev");}
void  S10249C31 ::v53(){vfunc_called(this, "_ZN9S10249C313v53Ev");}
void  S10249C31 ::v54(){vfunc_called(this, "_ZN9S10249C313v54Ev");}
S10249C31 ::S10249C31(){ note_ctor("S10249C31", this);} // tgen

static void Test_S10249C31()
{
  extern Class_Descriptor cd_S10249C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,16)];
    init_test(&cd_S10249C31, buf);
    S10249C31 *dp, &lv = *(dp=new (buf) S10249C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S10249C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C31)");
    check_field_offset(lv, s10249c31f0, ABISELECT(8,4), "S10249C31.s10249c31f0");
    check_field_offset(lv, s10249c31f1, ABISELECT(16,8), "S10249C31.s10249c31f1");
    check_field_offset(lv, s10249c31f2, ABISELECT(24,12), "S10249C31.s10249c31f2");
    check_field_offset(lv, s10249c31f3, ABISELECT(28,16), "S10249C31.s10249c31f3");
    check_field_offset(lv, s10249c31f4, ABISELECT(44,32), "S10249C31.s10249c31f4");
    check_field_offset(lv, s10249c31f5, ABISELECT(56,44), "S10249C31.s10249c31f5");
    test_class_info(&lv, &cd_S10249C31);
    dp->~S10249C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C31(Test_S10249C31, "S10249C31", ABISELECT(88,60));

#else // __cplusplus

extern void _ZN9S10249C31C1Ev();
extern void _ZN9S10249C31D1Ev();
Name_Map name_map_S10249C31[] = {
  NSPAIR(_ZN9S10249C31C1Ev),
  NSPAIR(_ZN9S10249C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C31[];
extern void _ZN9S10249C31D1Ev();
extern void _ZN9S10249C31D0Ev();
extern void _ZN9S10249C313v48Ev();
extern void _ZN9S10249C313v49Ev();
extern void _ZN9S10249C313v50Ev();
extern void _ZN9S10249C313v51Ev();
extern void _ZN9S10249C313v52Ev();
extern void _ZN9S10249C313v53Ev();
extern void _ZN9S10249C313v54Ev();
static  VTBL_ENTRY vtc_S10249C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C31[0]),
  (VTBL_ENTRY)&_ZN9S10249C31D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C31D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v48Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v49Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v50Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v51Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v52Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v53Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v54Ev,
};
extern VTBL_ENTRY _ZTI9S10249C31[];
extern  VTBL_ENTRY _ZTV9S10249C31[];
Class_Descriptor cd_S10249C31 = {  "S10249C31", // class name
  0,0,//no base classes
  &(vtc_S10249C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,60), // object size
  NSPAIRA(_ZTI9S10249C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C31),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C30  : S10249C31 {
  virtual  ~S10249C30(); // _ZN9S10249C30D1Ev
  virtual void  v42(); // _ZN9S10249C303v42Ev
  virtual void  v43(); // _ZN9S10249C303v43Ev
  virtual void  v44(); // _ZN9S10249C303v44Ev
  virtual void  v45(); // _ZN9S10249C303v45Ev
  virtual void  v46(); // _ZN9S10249C303v46Ev
  virtual void  v47(); // _ZN9S10249C303v47Ev
  S10249C30(); // tgen
};
//SIG(-1 S10249C30) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 Fi Fp Fi FC3{ Fc[2] Fs FC4{ Fi} Fs Fc[6]} Fi[3] FC5{ m Fi Fp[3]}} vd v1 v2 v3 v4 v5 v6}


 S10249C30 ::~S10249C30(){ note_dtor("S10249C30", this);}
void  S10249C30 ::v42(){vfunc_called(this, "_ZN9S10249C303v42Ev");}
void  S10249C30 ::v43(){vfunc_called(this, "_ZN9S10249C303v43Ev");}
void  S10249C30 ::v44(){vfunc_called(this, "_ZN9S10249C303v44Ev");}
void  S10249C30 ::v45(){vfunc_called(this, "_ZN9S10249C303v45Ev");}
void  S10249C30 ::v46(){vfunc_called(this, "_ZN9S10249C303v46Ev");}
void  S10249C30 ::v47(){vfunc_called(this, "_ZN9S10249C303v47Ev");}
S10249C30 ::S10249C30(){ note_ctor("S10249C30", this);} // tgen

static void Test_S10249C30()
{
  extern Class_Descriptor cd_S10249C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,16)];
    init_test(&cd_S10249C30, buf);
    S10249C30 *dp, &lv = *(dp=new (buf) S10249C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S10249C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C30)");
    check_base_class_offset(lv, (S10249C31*), 0, "S10249C30");
    test_class_info(&lv, &cd_S10249C30);
    dp->~S10249C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C30(Test_S10249C30, "S10249C30", ABISELECT(88,60));

#else // __cplusplus

extern void _ZN9S10249C30C1Ev();
extern void _ZN9S10249C30D1Ev();
Name_Map name_map_S10249C30[] = {
  NSPAIR(_ZN9S10249C30C1Ev),
  NSPAIR(_ZN9S10249C30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10249C31;
extern VTBL_ENTRY _ZTI9S10249C31[];
extern  VTBL_ENTRY _ZTV9S10249C31[];
static Base_Class bases_S10249C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10249C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10249C30[];
extern void _ZN9S10249C30D1Ev();
extern void _ZN9S10249C30D0Ev();
extern void _ZN9S10249C313v48Ev();
extern void _ZN9S10249C313v49Ev();
extern void _ZN9S10249C313v50Ev();
extern void _ZN9S10249C313v51Ev();
extern void _ZN9S10249C313v52Ev();
extern void _ZN9S10249C313v53Ev();
extern void _ZN9S10249C313v54Ev();
extern void _ZN9S10249C303v42Ev();
extern void _ZN9S10249C303v43Ev();
extern void _ZN9S10249C303v44Ev();
extern void _ZN9S10249C303v45Ev();
extern void _ZN9S10249C303v46Ev();
extern void _ZN9S10249C303v47Ev();
static  VTBL_ENTRY vtc_S10249C30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C30[0]),
  (VTBL_ENTRY)&_ZN9S10249C30D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C30D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v48Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v49Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v50Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v51Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v52Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v53Ev,
  (VTBL_ENTRY)&_ZN9S10249C313v54Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v42Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v43Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v44Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v45Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v46Ev,
  (VTBL_ENTRY)&_ZN9S10249C303v47Ev,
};
extern VTBL_ENTRY _ZTI9S10249C30[];
extern  VTBL_ENTRY _ZTV9S10249C30[];
Class_Descriptor cd_S10249C30 = {  "S10249C30", // class name
  bases_S10249C30, 1,
  &(vtc_S10249C30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,60), // object size
  NSPAIRA(_ZTI9S10249C30),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10249C30),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C25  {
  char s10249c25f0;
  int s10249c25f1;
  ::S10248C26_nt s10249c25f2;
  ::S10248C27 s10249c25f3;
  void *s10249c25f4;
  ::S10249C29 s10249c25f5;
  ::S10249C29 s10249c25f6;
  void *s10249c25f7[2];
  int s10249c25f8;
  void *s10249c25f9;
  ::S10249C30 s10249c25f10;
  char s10249c25f11;
  __tsi64 s10249c25f12;
  ::S4947C13_nt s10249c25f13;
  __tsi64 s10249c25f14;
  ::S4947C13_nt s10249c25f15;
  virtual  ~S10249C25(); // _ZN9S10249C25D1Ev
  virtual void  v39(); // _ZN9S10249C253v39Ev
  virtual void  v40(); // _ZN9S10249C253v40Ev
  virtual void  v41(); // _ZN9S10249C253v41Ev
  S10249C25(); // tgen
};
//SIG(-1 S10249C25) C1{ vd v1 v2 v3 Fc Fi FC2{ m Fi} FC3{ m FC4{ Fi Fp} Fi} Fp FC5{ m Fp[2] Fi} FC5 Fp[2] Fi Fp FC6{ BC7{ vd v10 v11 v12 v13 v14 v15 v16 Fi Fp Fi FC8{ Fc[2] Fs FC9{ Fi} Fs Fc[6]} Fi[3] FC10{ m Fi Fp[3]}} vd v4 v5 v6 v7 v8 v9} Fc FL FC11{ m FL[2]} FL FC11}


 S10249C25 ::~S10249C25(){ note_dtor("S10249C25", this);}
void  S10249C25 ::v39(){vfunc_called(this, "_ZN9S10249C253v39Ev");}
void  S10249C25 ::v40(){vfunc_called(this, "_ZN9S10249C253v40Ev");}
void  S10249C25 ::v41(){vfunc_called(this, "_ZN9S10249C253v41Ev");}
S10249C25 ::S10249C25(){ note_ctor("S10249C25", this);} // tgen

static void Test_S10249C25()
{
  extern Class_Descriptor cd_S10249C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,47)];
    init_test(&cd_S10249C25, buf);
    S10249C25 *dp, &lv = *(dp=new (buf) S10249C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,184), "sizeof(S10249C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C25)");
    check_field_offset(lv, s10249c25f0, ABISELECT(8,4), "S10249C25.s10249c25f0");
    check_field_offset(lv, s10249c25f1, ABISELECT(12,8), "S10249C25.s10249c25f1");
    check_field_offset(lv, s10249c25f2, ABISELECT(16,12), "S10249C25.s10249c25f2");
    check_field_offset(lv, s10249c25f3, ABISELECT(24,16), "S10249C25.s10249c25f3");
    check_field_offset(lv, s10249c25f4, ABISELECT(48,28), "S10249C25.s10249c25f4");
    check_field_offset(lv, s10249c25f5, ABISELECT(56,32), "S10249C25.s10249c25f5");
    check_field_offset(lv, s10249c25f6, ABISELECT(80,44), "S10249C25.s10249c25f6");
    check_field_offset(lv, s10249c25f7, ABISELECT(104,56), "S10249C25.s10249c25f7");
    check_field_offset(lv, s10249c25f8, ABISELECT(120,64), "S10249C25.s10249c25f8");
    check_field_offset(lv, s10249c25f9, ABISELECT(128,68), "S10249C25.s10249c25f9");
    check_field_offset(lv, s10249c25f10, ABISELECT(136,72), "S10249C25.s10249c25f10");
    check_field_offset(lv, s10249c25f11, ABISELECT(224,132), "S10249C25.s10249c25f11");
    check_field_offset(lv, s10249c25f12, ABISELECT(232,136), "S10249C25.s10249c25f12");
    check_field_offset(lv, s10249c25f13, ABISELECT(240,144), "S10249C25.s10249c25f13");
    check_field_offset(lv, s10249c25f14, ABISELECT(256,160), "S10249C25.s10249c25f14");
    check_field_offset(lv, s10249c25f15, ABISELECT(264,168), "S10249C25.s10249c25f15");
    test_class_info(&lv, &cd_S10249C25);
    dp->~S10249C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C25(Test_S10249C25, "S10249C25", ABISELECT(280,184));

#else // __cplusplus

extern void _ZN9S10249C25C1Ev();
extern void _ZN9S10249C25D1Ev();
Name_Map name_map_S10249C25[] = {
  NSPAIR(_ZN9S10249C25C1Ev),
  NSPAIR(_ZN9S10249C25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C25[];
extern void _ZN9S10249C25D1Ev();
extern void _ZN9S10249C25D0Ev();
extern void _ZN9S10249C253v39Ev();
extern void _ZN9S10249C253v40Ev();
extern void _ZN9S10249C253v41Ev();
static  VTBL_ENTRY vtc_S10249C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C25[0]),
  (VTBL_ENTRY)&_ZN9S10249C25D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C25D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C253v39Ev,
  (VTBL_ENTRY)&_ZN9S10249C253v40Ev,
  (VTBL_ENTRY)&_ZN9S10249C253v41Ev,
};
extern VTBL_ENTRY _ZTI9S10249C25[];
extern  VTBL_ENTRY _ZTV9S10249C25[];
Class_Descriptor cd_S10249C25 = {  "S10249C25", // class name
  0,0,//no base classes
  &(vtc_S10249C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,184), // object size
  NSPAIRA(_ZTI9S10249C25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C25),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C35  {
  char s10249c35f0;
  int s10249c35f1;
  ::S10248C26_nt s10249c35f2;
  ::S10248C27 s10249c35f3;
  void *s10249c35f4;
  ::S10249C29 s10249c35f5;
  ::S10249C29 s10249c35f6;
  void *s10249c35f7[2];
  int s10249c35f8;
  void *s10249c35f9;
  ::S10248C36 s10249c35f10;
  char s10249c35f11;
  __tsi64 s10249c35f12;
  ::S4947C13_nt s10249c35f13;
  __tsi64 s10249c35f14;
  ::S4947C13_nt s10249c35f15;
  virtual  ~S10249C35(); // _ZN9S10249C35D1Ev
  virtual void  v55(); // _ZN9S10249C353v55Ev
  virtual void  v56(); // _ZN9S10249C353v56Ev
  virtual void  v57(); // _ZN9S10249C353v57Ev
  S10249C35(); // tgen
};
//SIG(-1 S10249C35) C1{ vd v1 v2 v3 Fc Fi FC2{ m Fi} FC3{ m FC4{ Fi Fp} Fi} Fp FC5{ m Fp[2] Fi} FC5 Fp[2] Fi Fp FC6{ BC7{ BC8{ vd v10 v11 v12 v13 v14 v15 v16 Fi Fp Fi FC9{ Fc[2] Fs FC10{ Fi} Fs Fc[6]} Fi[3] FC11{ m Fi Fp[3]}} vd v17 v18 v19 v20 v21 v22} vd v4 v5 v6 v7 v8 v9 Fp} Fc FL FC12{ m FL[2]} FL FC12}


 S10249C35 ::~S10249C35(){ note_dtor("S10249C35", this);}
void  S10249C35 ::v55(){vfunc_called(this, "_ZN9S10249C353v55Ev");}
void  S10249C35 ::v56(){vfunc_called(this, "_ZN9S10249C353v56Ev");}
void  S10249C35 ::v57(){vfunc_called(this, "_ZN9S10249C353v57Ev");}
S10249C35 ::S10249C35(){ note_ctor("S10249C35", this);} // tgen

static void Test_S10249C35()
{
  extern Class_Descriptor cd_S10249C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,48)];
    init_test(&cd_S10249C35, buf);
    S10249C35 *dp, &lv = *(dp=new (buf) S10249C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,188), "sizeof(S10249C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C35)");
    check_field_offset(lv, s10249c35f0, ABISELECT(8,4), "S10249C35.s10249c35f0");
    check_field_offset(lv, s10249c35f1, ABISELECT(12,8), "S10249C35.s10249c35f1");
    check_field_offset(lv, s10249c35f2, ABISELECT(16,12), "S10249C35.s10249c35f2");
    check_field_offset(lv, s10249c35f3, ABISELECT(24,16), "S10249C35.s10249c35f3");
    check_field_offset(lv, s10249c35f4, ABISELECT(48,28), "S10249C35.s10249c35f4");
    check_field_offset(lv, s10249c35f5, ABISELECT(56,32), "S10249C35.s10249c35f5");
    check_field_offset(lv, s10249c35f6, ABISELECT(80,44), "S10249C35.s10249c35f6");
    check_field_offset(lv, s10249c35f7, ABISELECT(104,56), "S10249C35.s10249c35f7");
    check_field_offset(lv, s10249c35f8, ABISELECT(120,64), "S10249C35.s10249c35f8");
    check_field_offset(lv, s10249c35f9, ABISELECT(128,68), "S10249C35.s10249c35f9");
    check_field_offset(lv, s10249c35f10, ABISELECT(136,72), "S10249C35.s10249c35f10");
    check_field_offset(lv, s10249c35f11, ABISELECT(232,136), "S10249C35.s10249c35f11");
    check_field_offset(lv, s10249c35f12, ABISELECT(240,140), "S10249C35.s10249c35f12");
    check_field_offset(lv, s10249c35f13, ABISELECT(248,148), "S10249C35.s10249c35f13");
    check_field_offset(lv, s10249c35f14, ABISELECT(264,164), "S10249C35.s10249c35f14");
    check_field_offset(lv, s10249c35f15, ABISELECT(272,172), "S10249C35.s10249c35f15");
    test_class_info(&lv, &cd_S10249C35);
    dp->~S10249C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C35(Test_S10249C35, "S10249C35", ABISELECT(288,188));

#else // __cplusplus

extern void _ZN9S10249C35C1Ev();
extern void _ZN9S10249C35D1Ev();
Name_Map name_map_S10249C35[] = {
  NSPAIR(_ZN9S10249C35C1Ev),
  NSPAIR(_ZN9S10249C35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10249C35[];
extern void _ZN9S10249C35D1Ev();
extern void _ZN9S10249C35D0Ev();
extern void _ZN9S10249C353v55Ev();
extern void _ZN9S10249C353v56Ev();
extern void _ZN9S10249C353v57Ev();
static  VTBL_ENTRY vtc_S10249C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C35[0]),
  (VTBL_ENTRY)&_ZN9S10249C35D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C35D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C353v55Ev,
  (VTBL_ENTRY)&_ZN9S10249C353v56Ev,
  (VTBL_ENTRY)&_ZN9S10249C353v57Ev,
};
extern VTBL_ENTRY _ZTI9S10249C35[];
extern  VTBL_ENTRY _ZTV9S10249C35[];
Class_Descriptor cd_S10249C35 = {  "S10249C35", // class name
  0,0,//no base classes
  &(vtc_S10249C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,188), // object size
  NSPAIRA(_ZTI9S10249C35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10249C35),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C14  : S10249C15 , S10249C16 {
  void *s10249c14f0[3];
  short s10249c14f1;
  char s10249c14f2;
  int s10249c14f3[2];
  ::S10248C21 s10249c14f4;
  ::S10248C19 s10249c14f5;
  ::S10249C21 s10249c14f6;
  short s10249c14f7;
  ::S4947C13_nt s10249c14f8;
  ::S10248C22 s10249c14f9;
  ::S10248C23 s10249c14f10;
  ::S10249C25 s10249c14f11;
  ::S10249C35 s10249c14f12;
  void *s10249c14f13[20];
  virtual  ~S10249C14(); // _ZN9S10249C14D1Ev
  virtual void  v15(); // _ZN9S10249C143v15Ev
  virtual void  v16(); // _ZN9S10249C143v16Ev
  virtual void  v17(); // _ZN9S10249C143v17Ev
  virtual void  v18(); // _ZN9S10249C143v18Ev
  virtual void  v19(); // _ZN9S10249C143v19Ev
  virtual void  v20(); // _ZN9S10249C143v20Ev
  virtual void  v21(); // _ZN9S10249C143v21Ev
  virtual void  v22(); // _ZN9S10249C143v22Ev
  virtual void  v23(); // _ZN9S10249C143v23Ev
  S10249C14(); // tgen
};
//SIG(1 S10249C14) C1{ BC2{ vd v10 v11 v12 v13 v14 v15 v16 v17} BC3{ BC4{ vd v18} BC5{ vd v19} BC6{ vd v20 v21 v22 Fp} vd v23} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[3] Fs Fc Fi[2] FC7{ Fi Fc[512]} FC8{ Fi Fc[512]} FC9{ Fi Fc[512]} Fs FC10{ m FL[2]} FC11{ Fp Fi Fc} FC12{ BC13{ vd v25} vd v24 Fp} FC14{ vd v26 v27 v28 Fc Fi FC15{ m Fi} FC16{ m FC17{ Fi Fp} Fi} Fp FC18{ m Fp[2] Fi} FC18 Fp[2] Fi Fp FC19{ BC20{ vd v35 v36 v37 v38 v39 v40 v41 Fi Fp Fi FC21{ Fc[2] Fs FC22{ Fi} Fs Fc[6]} Fi[3] FC23{ m Fi Fp[3]}} vd v29 v30 v31 v32 v33 v34} Fc FL FC10 FL FC10} FC24{ vd v42 v43 v44 Fc Fi FC15 FC16 Fp FC18 FC18 Fp[2] Fi Fp FC25{ BC26{ BC27{ vd v51 v52 v53 v54 v55 v56 v57 Fi Fp Fi FC21 Fi[3] FC23} vd v58 v59 v60 v61 v62 v63} vd v45 v46 v47 v48 v49 v50 Fp} Fc FL FC10 FL FC10} Fp[20]}


 S10249C14 ::~S10249C14(){ note_dtor("S10249C14", this);}
void  S10249C14 ::v15(){vfunc_called(this, "_ZN9S10249C143v15Ev");}
void  S10249C14 ::v16(){vfunc_called(this, "_ZN9S10249C143v16Ev");}
void  S10249C14 ::v17(){vfunc_called(this, "_ZN9S10249C143v17Ev");}
void  S10249C14 ::v18(){vfunc_called(this, "_ZN9S10249C143v18Ev");}
void  S10249C14 ::v19(){vfunc_called(this, "_ZN9S10249C143v19Ev");}
void  S10249C14 ::v20(){vfunc_called(this, "_ZN9S10249C143v20Ev");}
void  S10249C14 ::v21(){vfunc_called(this, "_ZN9S10249C143v21Ev");}
void  S10249C14 ::v22(){vfunc_called(this, "_ZN9S10249C143v22Ev");}
void  S10249C14 ::v23(){vfunc_called(this, "_ZN9S10249C143v23Ev");}
S10249C14 ::S10249C14(){ note_ctor("S10249C14", this);} // tgen

static void Test_S10249C14()
{
  extern Class_Descriptor cd_S10249C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(302,522)];
    init_test(&cd_S10249C14, buf);
    S10249C14 *dp, &lv = *(dp=new (buf) S10249C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2408,2084), "sizeof(S10249C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C14)");
    check_base_class_offset(lv, (S10249C15*), 0, "S10249C14");
    check_base_class_offset(lv, (S10249C17*)(S10249C16*), ABISELECT(8,4), "S10249C14");
    check_base_class_offset(lv, (S10249C3*)(S10249C16*), ABISELECT(16,8), "S10249C14");
    check_base_class_offset(lv, (S10249C18*)(S10249C16*), ABISELECT(24,12), "S10249C14");
    check_base_class_offset(lv, (S10249C16*), ABISELECT(8,4), "S10249C14");
    check_field_offset(lv, s10249c14f0, ABISELECT(40,20), "S10249C14.s10249c14f0");
    check_field_offset(lv, s10249c14f1, ABISELECT(64,32), "S10249C14.s10249c14f1");
    check_field_offset(lv, s10249c14f2, ABISELECT(66,34), "S10249C14.s10249c14f2");
    check_field_offset(lv, s10249c14f3, ABISELECT(68,36), "S10249C14.s10249c14f3");
    check_field_offset(lv, s10249c14f4, ABISELECT(76,44), "S10249C14.s10249c14f4");
    check_field_offset(lv, s10249c14f5, ABISELECT(592,560), "S10249C14.s10249c14f5");
    check_field_offset(lv, s10249c14f6, ABISELECT(1108,1076), "S10249C14.s10249c14f6");
    check_field_offset(lv, s10249c14f7, ABISELECT(1624,1592), "S10249C14.s10249c14f7");
    check_field_offset(lv, s10249c14f8, ABISELECT(1632,1596), "S10249C14.s10249c14f8");
    check_field_offset(lv, s10249c14f9, ABISELECT(1648,1612), "S10249C14.s10249c14f9");
    check_field_offset(lv, s10249c14f10, ABISELECT(1664,1624), "S10249C14.s10249c14f10");
    check_field_offset(lv, s10249c14f11, ABISELECT(1680,1632), "S10249C14.s10249c14f11");
    check_field_offset(lv, s10249c14f12, ABISELECT(1960,1816), "S10249C14.s10249c14f12");
    check_field_offset(lv, s10249c14f13, ABISELECT(2248,2004), "S10249C14.s10249c14f13");
    test_class_info(&lv, &cd_S10249C14);
    dp->~S10249C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C14(Test_S10249C14, "S10249C14", ABISELECT(2408,2084));

#else // __cplusplus

extern void _ZN9S10249C14C1Ev();
extern void _ZN9S10249C14D1Ev();
Name_Map name_map_S10249C14[] = {
  NSPAIR(_ZN9S10249C14C1Ev),
  NSPAIR(_ZN9S10249C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10249C15;
extern VTBL_ENTRY _ZTI9S10249C15[];
extern  VTBL_ENTRY _ZTV9S10249C15[];
extern Class_Descriptor cd_S10249C17;
extern VTBL_ENTRY _ZTI9S10249C17[];
extern  VTBL_ENTRY _ZTV9S10249C17[];
extern Class_Descriptor cd_S10249C3;
extern VTBL_ENTRY _ZTI8S10249C3[];
extern  VTBL_ENTRY _ZTV8S10249C3[];
extern Class_Descriptor cd_S10249C18;
extern VTBL_ENTRY _ZTI9S10249C18[];
extern  VTBL_ENTRY _ZTV9S10249C18[];
extern Class_Descriptor cd_S10249C16;
extern VTBL_ENTRY _ZTI9S10249C16[];
extern  VTBL_ENTRY _ZTV9S10249C16[];
static Base_Class bases_S10249C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10249C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10249C17,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10249C3,    ABISELECT(16,8), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10249C18,    ABISELECT(24,12), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S10249C16,    ABISELECT(8,4), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10249C14[];
extern void _ZN9S10249C14D1Ev();
extern void _ZN9S10249C14D0Ev();
extern void _ZN9S10249C153v24Ev();
extern void _ZN9S10249C153v25Ev();
extern void _ZN9S10249C153v26Ev();
extern void _ZN9S10249C153v27Ev();
extern void _ZN9S10249C153v28Ev();
extern void _ZN9S10249C153v29Ev();
extern void _ZN9S10249C153v30Ev();
extern void _ZN9S10249C153v31Ev();
extern void _ZN9S10249C143v15Ev();
extern void _ZN9S10249C143v16Ev();
extern void _ZN9S10249C143v17Ev();
extern void _ZN9S10249C143v18Ev();
extern void _ZN9S10249C143v19Ev();
extern void _ZN9S10249C143v20Ev();
extern void _ZN9S10249C143v21Ev();
extern void _ZN9S10249C143v22Ev();
extern void _ZN9S10249C143v23Ev();
extern void ABISELECT(_ZThn8_N9S10249C14D1Ev,_ZThn4_N9S10249C14D1Ev)();
extern void ABISELECT(_ZThn8_N9S10249C14D0Ev,_ZThn4_N9S10249C14D0Ev)();
extern void _ZN9S10249C173v32Ev();
extern void _ZN9S10249C163v36Ev();
extern void ABISELECT(_ZThn16_N9S10249C14D1Ev,_ZThn8_N9S10249C14D1Ev)();
extern void ABISELECT(_ZThn16_N9S10249C14D0Ev,_ZThn8_N9S10249C14D0Ev)();
extern void _ZN8S10249C33v14Ev();
extern void ABISELECT(_ZThn24_N9S10249C14D1Ev,_ZThn12_N9S10249C14D1Ev)();
extern void ABISELECT(_ZThn24_N9S10249C14D0Ev,_ZThn12_N9S10249C14D0Ev)();
extern void _ZN9S10249C183v33Ev();
extern void _ZN9S10249C183v34Ev();
extern void _ZN9S10249C183v35Ev();
static  VTBL_ENTRY vtc_S10249C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10249C14[0]),
  (VTBL_ENTRY)&_ZN9S10249C14D1Ev,
  (VTBL_ENTRY)&_ZN9S10249C14D0Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v24Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v25Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v26Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v27Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v28Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v29Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v30Ev,
  (VTBL_ENTRY)&_ZN9S10249C153v31Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v15Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v16Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v17Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v18Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v19Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v20Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v21Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v22Ev,
  (VTBL_ENTRY)&_ZN9S10249C143v23Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S10249C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10249C14D1Ev,_ZThn4_N9S10249C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S10249C14D0Ev,_ZThn4_N9S10249C14D0Ev),
  (VTBL_ENTRY)&_ZN9S10249C173v32Ev,
  (VTBL_ENTRY)&_ZN9S10249C163v36Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S10249C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10249C14D1Ev,_ZThn8_N9S10249C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S10249C14D0Ev,_ZThn8_N9S10249C14D0Ev),
  (VTBL_ENTRY)&_ZN8S10249C33v14Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S10249C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S10249C14D1Ev,_ZThn12_N9S10249C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S10249C14D0Ev,_ZThn12_N9S10249C14D0Ev),
  (VTBL_ENTRY)&_ZN9S10249C183v33Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v34Ev,
  (VTBL_ENTRY)&_ZN9S10249C183v35Ev,
};
extern VTBL_ENTRY _ZTI9S10249C14[];
extern  VTBL_ENTRY _ZTV9S10249C14[];
Class_Descriptor cd_S10249C14 = {  "S10249C14", // class name
  bases_S10249C14, 5,
  &(vtc_S10249C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2408,2084), // object size
  NSPAIRA(_ZTI9S10249C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S10249C14),39, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10249C1  : S10249C2 , S10249C3 {
  short s10249c1f0;
  ::S10248C4 s10249c1f1;
  ::S10248C5 s10249c1f2;
  ::S10248C6_nt s10249c1f3;
  ::S10248C8 s10249c1f4;
  void *s10249c1f5[3];
  ::S10248C9_nt s10249c1f6;
  char s10249c1f7;
  int s10249c1f8[2];
  char s10249c1f9[32768];
  ::S10248C10 s10249c1f10;
  ::S10248C10 s10249c1f11;
  ::S10249C11 s10249c1f12;
  ::S10249C11 s10249c1f13;
  ::S4947C13_nt s10249c1f14;
  ::S10249C14 s10249c1f15[4];
  short s10249c1f16[2];
  virtual  ~S10249C1(); // _ZN8S10249C1D1Ev
  virtual void  v1(); // _ZN8S10249C12v1Ev
  virtual void  v2(); // _ZN8S10249C12v2Ev
  virtual void  v3(); // _ZN8S10249C12v3Ev
  virtual void  v4(); // _ZN8S10249C12v4Ev
  virtual void  v5(); // _ZN8S10249C12v5Ev
  virtual void  v6(); // _ZN8S10249C12v6Ev
  virtual void  v7(); // _ZN8S10249C12v7Ev
  S10249C1(); // tgen
};
//SIG(1 S10249C1) C1{ BC2{ vd v8 v9 v10 v11 v12 v13} BC3{ vd v14} vd v1 v2 v3 v4 v5 v6 v7 Fs FC4{ Fc[12]} FC5{ Fc[128]} FC6{ FC7{ Fc[20]} Fc[16]} FC8{ Fi[3] Fc Fp[2]} Fp[3] FC9{ m Fp[2] Fi} Fc Fi[2] Fc[32768] FC10{ m Fp[5] Fi[3]} FC10 FC11{ m FC12{ FL[4]} Fc} FC11 FC13{ m FL[2]} FC14{ BC15{ vd v24 v25 v26 v27 v28 v29 v30 v31} BC16{ BC17{ vd v32} BC3 BC18{ vd v33 v34 v35 Fp} vd v36} vd v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp[3] Fs Fc Fi[2] FC19{ Fi Fc[512]} FC20{ Fi Fc[512]} FC21{ Fi Fc[512]} Fs FC13 FC22{ Fp Fi Fc} FC23{ BC24{ vd v38} vd v37 Fp} FC25{ vd v39 v40 v41 Fc Fi FC26{ m Fi} FC27{ m FC28{ Fi Fp} Fi} Fp FC29{ m Fp[2] Fi} FC29 Fp[2] Fi Fp FC30{ BC31{ vd v48 v49 v50 v51 v52 v53 v54 Fi Fp Fi FC32{ Fc[2] Fs FC33{ Fi} Fs Fc[6]} Fi[3] FC34{ m Fi Fp[3]}} vd v42 v43 v44 v45 v46 v47} Fc FL FC13 FL FC13} FC35{ vd v55 v56 v57 Fc Fi FC26 FC27 Fp FC29 FC29 Fp[2] Fi Fp FC36{ BC37{ BC38{ vd v64 v65 v66 v67 v68 v69 v70 Fi Fp Fi FC32 Fi[3] FC34} vd v71 v72 v73 v74 v75 v76} vd v58 v59 v60 v61 v62 v63 Fp} Fc FL FC13 FL FC13} Fp[20]}[4] Fs[2]}


 S10249C1 ::~S10249C1(){ note_dtor("S10249C1", this);}
void  S10249C1 ::v1(){vfunc_called(this, "_ZN8S10249C12v1Ev");}
void  S10249C1 ::v2(){vfunc_called(this, "_ZN8S10249C12v2Ev");}
void  S10249C1 ::v3(){vfunc_called(this, "_ZN8S10249C12v3Ev");}
void  S10249C1 ::v4(){vfunc_called(this, "_ZN8S10249C12v4Ev");}
void  S10249C1 ::v5(){vfunc_called(this, "_ZN8S10249C12v5Ev");}
void  S10249C1 ::v6(){vfunc_called(this, "_ZN8S10249C12v6Ev");}
void  S10249C1 ::v7(){vfunc_called(this, "_ZN8S10249C12v7Ev");}
S10249C1 ::S10249C1(){ note_ctor("S10249C1", this);} // tgen

static void Test_S10249C1()
{
  extern Class_Descriptor cd_S10249C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5365,10378)];
    init_test(&cd_S10249C1, buf);
    S10249C1 *dp, &lv = *(dp=new (buf) S10249C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(42912,41508), "sizeof(S10249C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10249C1)");
    check_base_class_offset(lv, (S10249C2*), 0, "S10249C1");
    check_base_class_offset(lv, (S10249C3*), ABISELECT(8,4), "S10249C1");
    check_field_offset(lv, s10249c1f0, ABISELECT(16,8), "S10249C1.s10249c1f0");
    check_field_offset(lv, s10249c1f1, ABISELECT(18,10), "S10249C1.s10249c1f1");
    check_field_offset(lv, s10249c1f2, ABISELECT(30,22), "S10249C1.s10249c1f2");
    check_field_offset(lv, s10249c1f3, ABISELECT(158,150), "S10249C1.s10249c1f3");
    check_field_offset(lv, s10249c1f4, ABISELECT(200,188), "S10249C1.s10249c1f4");
    check_field_offset(lv, s10249c1f5, ABISELECT(232,212), "S10249C1.s10249c1f5");
    check_field_offset(lv, s10249c1f6, ABISELECT(256,224), "S10249C1.s10249c1f6");
    check_field_offset(lv, s10249c1f7, ABISELECT(280,236), "S10249C1.s10249c1f7");
    check_field_offset(lv, s10249c1f8, ABISELECT(284,240), "S10249C1.s10249c1f8");
    check_field_offset(lv, s10249c1f9, ABISELECT(292,248), "S10249C1.s10249c1f9");
    check_field_offset(lv, s10249c1f10, ABISELECT(33064,33016), "S10249C1.s10249c1f10");
    check_field_offset(lv, s10249c1f11, ABISELECT(33120,33048), "S10249C1.s10249c1f11");
    check_field_offset(lv, s10249c1f12, ABISELECT(33176,33080), "S10249C1.s10249c1f12");
    check_field_offset(lv, s10249c1f13, ABISELECT(33216,33116), "S10249C1.s10249c1f13");
    check_field_offset(lv, s10249c1f14, ABISELECT(33256,33152), "S10249C1.s10249c1f14");
    check_field_offset(lv, s10249c1f15, ABISELECT(33272,33168), "S10249C1.s10249c1f15");
    check_field_offset(lv, s10249c1f16, ABISELECT(42904,41504), "S10249C1.s10249c1f16");
    test_class_info(&lv, &cd_S10249C1);
    dp->~S10249C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10249C1(Test_S10249C1, "S10249C1", ABISELECT(42912,41508));

#else // __cplusplus

extern void _ZN8S10249C1C1Ev();
extern void _ZN8S10249C1D1Ev();
Name_Map name_map_S10249C1[] = {
  NSPAIR(_ZN8S10249C1C1Ev),
  NSPAIR(_ZN8S10249C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10249C2;
extern VTBL_ENTRY _ZTI8S10249C2[];
extern  VTBL_ENTRY _ZTV8S10249C2[];
extern Class_Descriptor cd_S10249C3;
extern VTBL_ENTRY _ZTI8S10249C3[];
extern  VTBL_ENTRY _ZTV8S10249C3[];
static Base_Class bases_S10249C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10249C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10249C3,    ABISELECT(8,4), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10249C1[];
extern void _ZN8S10249C1D1Ev();
extern void _ZN8S10249C1D0Ev();
extern void _ZN8S10249C22v8Ev();
extern void _ZN8S10249C22v9Ev();
extern void _ZN8S10249C23v10Ev();
extern void _ZN8S10249C23v11Ev();
extern void _ZN8S10249C23v12Ev();
extern void _ZN8S10249C23v13Ev();
extern void _ZN8S10249C12v1Ev();
extern void _ZN8S10249C12v2Ev();
extern void _ZN8S10249C12v3Ev();
extern void _ZN8S10249C12v4Ev();
extern void _ZN8S10249C12v5Ev();
extern void _ZN8S10249C12v6Ev();
extern void _ZN8S10249C12v7Ev();
extern void ABISELECT(_ZThn8_N8S10249C1D1Ev,_ZThn4_N8S10249C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10249C1D0Ev,_ZThn4_N8S10249C1D0Ev)();
extern void _ZN8S10249C33v14Ev();
static  VTBL_ENTRY vtc_S10249C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10249C1[0]),
  (VTBL_ENTRY)&_ZN8S10249C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10249C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10249C22v8Ev,
  (VTBL_ENTRY)&_ZN8S10249C22v9Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v10Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v11Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v12Ev,
  (VTBL_ENTRY)&_ZN8S10249C23v13Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10249C12v7Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10249C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10249C1D1Ev,_ZThn4_N8S10249C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10249C1D0Ev,_ZThn4_N8S10249C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10249C33v14Ev,
};
extern VTBL_ENTRY _ZTI8S10249C1[];
extern  VTBL_ENTRY _ZTV8S10249C1[];
Class_Descriptor cd_S10249C1 = {  "S10249C1", // class name
  bases_S10249C1, 2,
  &(vtc_S10249C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(42912,41508), // object size
  NSPAIRA(_ZTI8S10249C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10249C1),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S633C5  {
  int s633c5f0;
  __tsi64 s633c5f1;
  void *s633c5f2[4];
  int s633c5f3[2];
  void *s633c5f4;
  ::S248C7_nt s633c5f5;
  void *s633c5f6[2];
  virtual  ~S633C5(); // _ZN6S633C5D1Ev
  virtual void  v5(); // _ZN6S633C52v5Ev
  virtual void  v6(); // _ZN6S633C52v6Ev
  virtual void  v7(); // _ZN6S633C52v7Ev
  virtual void  v8(); // _ZN6S633C52v8Ev
  virtual void  v9(); // _ZN6S633C52v9Ev
  virtual void  v10(); // _ZN6S633C53v10Ev
  virtual void  v11(); // _ZN6S633C53v11Ev
  virtual void  v12(); // _ZN6S633C53v12Ev
  virtual void  v13(); // _ZN6S633C53v13Ev
  virtual void  v14(); // _ZN6S633C53v14Ev
  virtual void  v15(); // _ZN6S633C53v15Ev
  virtual void  v16(); // _ZN6S633C53v16Ev
  virtual void  v17(); // _ZN6S633C53v17Ev
  virtual void  v18(); // _ZN6S633C53v18Ev
  virtual void  v19(); // _ZN6S633C53v19Ev
  virtual void  v20(); // _ZN6S633C53v20Ev
  virtual void  v21(); // _ZN6S633C53v21Ev
  virtual void  v22(); // _ZN6S633C53v22Ev
  virtual void  v23(); // _ZN6S633C53v23Ev
  virtual void  v24(); // _ZN6S633C53v24Ev
  virtual void  v25(); // _ZN6S633C53v25Ev
  virtual void  v26(); // _ZN6S633C53v26Ev
  virtual void  v27(); // _ZN6S633C53v27Ev
  virtual void  v28(); // _ZN6S633C53v28Ev
  virtual void  v29(); // _ZN6S633C53v29Ev
  virtual void  v30(); // _ZN6S633C53v30Ev
  virtual void  v31(); // _ZN6S633C53v31Ev
  virtual void  v32(); // _ZN6S633C53v32Ev
  virtual void  v33(); // _ZN6S633C53v33Ev
  virtual void  v34(); // _ZN6S633C53v34Ev
  virtual void  v35(); // _ZN6S633C53v35Ev
  virtual void  v36(); // _ZN6S633C53v36Ev
  virtual void  v37(); // _ZN6S633C53v37Ev
  virtual void  v38(); // _ZN6S633C53v38Ev
  virtual void  v39(); // _ZN6S633C53v39Ev
  virtual void  v40(); // _ZN6S633C53v40Ev
  virtual void  v41(); // _ZN6S633C53v41Ev
  virtual void  v42(); // _ZN6S633C53v42Ev
  virtual void  v43(); // _ZN6S633C53v43Ev
  virtual void  v44(); // _ZN6S633C53v44Ev
  virtual void  v45(); // _ZN6S633C53v45Ev
  virtual void  v46(); // _ZN6S633C53v46Ev
  virtual void  v47(); // _ZN6S633C53v47Ev
  virtual void  v48(); // _ZN6S633C53v48Ev
  virtual void  v49(); // _ZN6S633C53v49Ev
  virtual void  v50(); // _ZN6S633C53v50Ev
  virtual void  v51(); // _ZN6S633C53v51Ev
  virtual void  v52(); // _ZN6S633C53v52Ev
  virtual void  v53(); // _ZN6S633C53v53Ev
  virtual void  v54(); // _ZN6S633C53v54Ev
  virtual void  v55(); // _ZN6S633C53v55Ev
  virtual void  v56(); // _ZN6S633C53v56Ev
  virtual void  v57(); // _ZN6S633C53v57Ev
  virtual void  v58(); // _ZN6S633C53v58Ev
  virtual void  v59(); // _ZN6S633C53v59Ev
  virtual void  v60(); // _ZN6S633C53v60Ev
  virtual void  v61(); // _ZN6S633C53v61Ev
  virtual void  v62(); // _ZN6S633C53v62Ev
  virtual void  v63(); // _ZN6S633C53v63Ev
  virtual void  v64(); // _ZN6S633C53v64Ev
  virtual void  v65(); // _ZN6S633C53v65Ev
  virtual void  v66(); // _ZN6S633C53v66Ev
  virtual void  v67(); // _ZN6S633C53v67Ev
  virtual void  v68(); // _ZN6S633C53v68Ev
  S633C5(); // tgen
};
//SIG(-1 S633C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S633C5 ::~S633C5(){ note_dtor("S633C5", this);}
void  S633C5 ::v5(){vfunc_called(this, "_ZN6S633C52v5Ev");}
void  S633C5 ::v6(){vfunc_called(this, "_ZN6S633C52v6Ev");}
void  S633C5 ::v7(){vfunc_called(this, "_ZN6S633C52v7Ev");}
void  S633C5 ::v8(){vfunc_called(this, "_ZN6S633C52v8Ev");}
void  S633C5 ::v9(){vfunc_called(this, "_ZN6S633C52v9Ev");}
void  S633C5 ::v10(){vfunc_called(this, "_ZN6S633C53v10Ev");}
void  S633C5 ::v11(){vfunc_called(this, "_ZN6S633C53v11Ev");}
void  S633C5 ::v12(){vfunc_called(this, "_ZN6S633C53v12Ev");}
void  S633C5 ::v13(){vfunc_called(this, "_ZN6S633C53v13Ev");}
void  S633C5 ::v14(){vfunc_called(this, "_ZN6S633C53v14Ev");}
void  S633C5 ::v15(){vfunc_called(this, "_ZN6S633C53v15Ev");}
void  S633C5 ::v16(){vfunc_called(this, "_ZN6S633C53v16Ev");}
void  S633C5 ::v17(){vfunc_called(this, "_ZN6S633C53v17Ev");}
void  S633C5 ::v18(){vfunc_called(this, "_ZN6S633C53v18Ev");}
void  S633C5 ::v19(){vfunc_called(this, "_ZN6S633C53v19Ev");}
void  S633C5 ::v20(){vfunc_called(this, "_ZN6S633C53v20Ev");}
void  S633C5 ::v21(){vfunc_called(this, "_ZN6S633C53v21Ev");}
void  S633C5 ::v22(){vfunc_called(this, "_ZN6S633C53v22Ev");}
void  S633C5 ::v23(){vfunc_called(this, "_ZN6S633C53v23Ev");}
void  S633C5 ::v24(){vfunc_called(this, "_ZN6S633C53v24Ev");}
void  S633C5 ::v25(){vfunc_called(this, "_ZN6S633C53v25Ev");}
void  S633C5 ::v26(){vfunc_called(this, "_ZN6S633C53v26Ev");}
void  S633C5 ::v27(){vfunc_called(this, "_ZN6S633C53v27Ev");}
void  S633C5 ::v28(){vfunc_called(this, "_ZN6S633C53v28Ev");}
void  S633C5 ::v29(){vfunc_called(this, "_ZN6S633C53v29Ev");}
void  S633C5 ::v30(){vfunc_called(this, "_ZN6S633C53v30Ev");}
void  S633C5 ::v31(){vfunc_called(this, "_ZN6S633C53v31Ev");}
void  S633C5 ::v32(){vfunc_called(this, "_ZN6S633C53v32Ev");}
void  S633C5 ::v33(){vfunc_called(this, "_ZN6S633C53v33Ev");}
void  S633C5 ::v34(){vfunc_called(this, "_ZN6S633C53v34Ev");}
void  S633C5 ::v35(){vfunc_called(this, "_ZN6S633C53v35Ev");}
void  S633C5 ::v36(){vfunc_called(this, "_ZN6S633C53v36Ev");}
void  S633C5 ::v37(){vfunc_called(this, "_ZN6S633C53v37Ev");}
void  S633C5 ::v38(){vfunc_called(this, "_ZN6S633C53v38Ev");}
void  S633C5 ::v39(){vfunc_called(this, "_ZN6S633C53v39Ev");}
void  S633C5 ::v40(){vfunc_called(this, "_ZN6S633C53v40Ev");}
void  S633C5 ::v41(){vfunc_called(this, "_ZN6S633C53v41Ev");}
void  S633C5 ::v42(){vfunc_called(this, "_ZN6S633C53v42Ev");}
void  S633C5 ::v43(){vfunc_called(this, "_ZN6S633C53v43Ev");}
void  S633C5 ::v44(){vfunc_called(this, "_ZN6S633C53v44Ev");}
void  S633C5 ::v45(){vfunc_called(this, "_ZN6S633C53v45Ev");}
void  S633C5 ::v46(){vfunc_called(this, "_ZN6S633C53v46Ev");}
void  S633C5 ::v47(){vfunc_called(this, "_ZN6S633C53v47Ev");}
void  S633C5 ::v48(){vfunc_called(this, "_ZN6S633C53v48Ev");}
void  S633C5 ::v49(){vfunc_called(this, "_ZN6S633C53v49Ev");}
void  S633C5 ::v50(){vfunc_called(this, "_ZN6S633C53v50Ev");}
void  S633C5 ::v51(){vfunc_called(this, "_ZN6S633C53v51Ev");}
void  S633C5 ::v52(){vfunc_called(this, "_ZN6S633C53v52Ev");}
void  S633C5 ::v53(){vfunc_called(this, "_ZN6S633C53v53Ev");}
void  S633C5 ::v54(){vfunc_called(this, "_ZN6S633C53v54Ev");}
void  S633C5 ::v55(){vfunc_called(this, "_ZN6S633C53v55Ev");}
void  S633C5 ::v56(){vfunc_called(this, "_ZN6S633C53v56Ev");}
void  S633C5 ::v57(){vfunc_called(this, "_ZN6S633C53v57Ev");}
void  S633C5 ::v58(){vfunc_called(this, "_ZN6S633C53v58Ev");}
void  S633C5 ::v59(){vfunc_called(this, "_ZN6S633C53v59Ev");}
void  S633C5 ::v60(){vfunc_called(this, "_ZN6S633C53v60Ev");}
void  S633C5 ::v61(){vfunc_called(this, "_ZN6S633C53v61Ev");}
void  S633C5 ::v62(){vfunc_called(this, "_ZN6S633C53v62Ev");}
void  S633C5 ::v63(){vfunc_called(this, "_ZN6S633C53v63Ev");}
void  S633C5 ::v64(){vfunc_called(this, "_ZN6S633C53v64Ev");}
void  S633C5 ::v65(){vfunc_called(this, "_ZN6S633C53v65Ev");}
void  S633C5 ::v66(){vfunc_called(this, "_ZN6S633C53v66Ev");}
void  S633C5 ::v67(){vfunc_called(this, "_ZN6S633C53v67Ev");}
void  S633C5 ::v68(){vfunc_called(this, "_ZN6S633C53v68Ev");}
S633C5 ::S633C5(){ note_ctor("S633C5", this);} // tgen

static void Test_S633C5()
{
  extern Class_Descriptor cd_S633C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S633C5, buf);
    S633C5 *dp, &lv = *(dp=new (buf) S633C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S633C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S633C5)");
    check_field_offset(lv, s633c5f0, ABISELECT(8,4), "S633C5.s633c5f0");
    check_field_offset(lv, s633c5f1, ABISELECT(16,8), "S633C5.s633c5f1");
    check_field_offset(lv, s633c5f2, ABISELECT(24,16), "S633C5.s633c5f2");
    check_field_offset(lv, s633c5f3, ABISELECT(56,32), "S633C5.s633c5f3");
    check_field_offset(lv, s633c5f4, ABISELECT(64,40), "S633C5.s633c5f4");
    check_field_offset(lv, s633c5f5, ABISELECT(72,44), "S633C5.s633c5f5");
    check_field_offset(lv, s633c5f6, ABISELECT(80,52), "S633C5.s633c5f6");
    test_class_info(&lv, &cd_S633C5);
    dp->~S633C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS633C5(Test_S633C5, "S633C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S633C5C1Ev();
extern void _ZN6S633C5D1Ev();
Name_Map name_map_S633C5[] = {
  NSPAIR(_ZN6S633C5C1Ev),
  NSPAIR(_ZN6S633C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S633C5[];
extern void _ZN6S633C5D1Ev();
extern void _ZN6S633C5D0Ev();
extern void _ZN6S633C52v5Ev();
extern void _ZN6S633C52v6Ev();
extern void _ZN6S633C52v7Ev();
extern void _ZN6S633C52v8Ev();
extern void _ZN6S633C52v9Ev();
extern void _ZN6S633C53v10Ev();
extern void _ZN6S633C53v11Ev();
extern void _ZN6S633C53v12Ev();
extern void _ZN6S633C53v13Ev();
extern void _ZN6S633C53v14Ev();
extern void _ZN6S633C53v15Ev();
extern void _ZN6S633C53v16Ev();
extern void _ZN6S633C53v17Ev();
extern void _ZN6S633C53v18Ev();
extern void _ZN6S633C53v19Ev();
extern void _ZN6S633C53v20Ev();
extern void _ZN6S633C53v21Ev();
extern void _ZN6S633C53v22Ev();
extern void _ZN6S633C53v23Ev();
extern void _ZN6S633C53v24Ev();
extern void _ZN6S633C53v25Ev();
extern void _ZN6S633C53v26Ev();
extern void _ZN6S633C53v27Ev();
extern void _ZN6S633C53v28Ev();
extern void _ZN6S633C53v29Ev();
extern void _ZN6S633C53v30Ev();
extern void _ZN6S633C53v31Ev();
extern void _ZN6S633C53v32Ev();
extern void _ZN6S633C53v33Ev();
extern void _ZN6S633C53v34Ev();
extern void _ZN6S633C53v35Ev();
extern void _ZN6S633C53v36Ev();
extern void _ZN6S633C53v37Ev();
extern void _ZN6S633C53v38Ev();
extern void _ZN6S633C53v39Ev();
extern void _ZN6S633C53v40Ev();
extern void _ZN6S633C53v41Ev();
extern void _ZN6S633C53v42Ev();
extern void _ZN6S633C53v43Ev();
extern void _ZN6S633C53v44Ev();
extern void _ZN6S633C53v45Ev();
extern void _ZN6S633C53v46Ev();
extern void _ZN6S633C53v47Ev();
extern void _ZN6S633C53v48Ev();
extern void _ZN6S633C53v49Ev();
extern void _ZN6S633C53v50Ev();
extern void _ZN6S633C53v51Ev();
extern void _ZN6S633C53v52Ev();
extern void _ZN6S633C53v53Ev();
extern void _ZN6S633C53v54Ev();
extern void _ZN6S633C53v55Ev();
extern void _ZN6S633C53v56Ev();
extern void _ZN6S633C53v57Ev();
extern void _ZN6S633C53v58Ev();
extern void _ZN6S633C53v59Ev();
extern void _ZN6S633C53v60Ev();
extern void _ZN6S633C53v61Ev();
extern void _ZN6S633C53v62Ev();
extern void _ZN6S633C53v63Ev();
extern void _ZN6S633C53v64Ev();
extern void _ZN6S633C53v65Ev();
extern void _ZN6S633C53v66Ev();
extern void _ZN6S633C53v67Ev();
extern void _ZN6S633C53v68Ev();
static  VTBL_ENTRY vtc_S633C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S633C5[0]),
  (VTBL_ENTRY)&_ZN6S633C5D1Ev,
  (VTBL_ENTRY)&_ZN6S633C5D0Ev,
  (VTBL_ENTRY)&_ZN6S633C52v5Ev,
  (VTBL_ENTRY)&_ZN6S633C52v6Ev,
  (VTBL_ENTRY)&_ZN6S633C52v7Ev,
  (VTBL_ENTRY)&_ZN6S633C52v8Ev,
  (VTBL_ENTRY)&_ZN6S633C52v9Ev,
  (VTBL_ENTRY)&_ZN6S633C53v10Ev,
  (VTBL_ENTRY)&_ZN6S633C53v11Ev,
  (VTBL_ENTRY)&_ZN6S633C53v12Ev,
  (VTBL_ENTRY)&_ZN6S633C53v13Ev,
  (VTBL_ENTRY)&_ZN6S633C53v14Ev,
  (VTBL_ENTRY)&_ZN6S633C53v15Ev,
  (VTBL_ENTRY)&_ZN6S633C53v16Ev,
  (VTBL_ENTRY)&_ZN6S633C53v17Ev,
  (VTBL_ENTRY)&_ZN6S633C53v18Ev,
  (VTBL_ENTRY)&_ZN6S633C53v19Ev,
  (VTBL_ENTRY)&_ZN6S633C53v20Ev,
  (VTBL_ENTRY)&_ZN6S633C53v21Ev,
  (VTBL_ENTRY)&_ZN6S633C53v22Ev,
  (VTBL_ENTRY)&_ZN6S633C53v23Ev,
  (VTBL_ENTRY)&_ZN6S633C53v24Ev,
  (VTBL_ENTRY)&_ZN6S633C53v25Ev,
  (VTBL_ENTRY)&_ZN6S633C53v26Ev,
  (VTBL_ENTRY)&_ZN6S633C53v27Ev,
  (VTBL_ENTRY)&_ZN6S633C53v28Ev,
  (VTBL_ENTRY)&_ZN6S633C53v29Ev,
  (VTBL_ENTRY)&_ZN6S633C53v30Ev,
  (VTBL_ENTRY)&_ZN6S633C53v31Ev,
  (VTBL_ENTRY)&_ZN6S633C53v32Ev,
  (VTBL_ENTRY)&_ZN6S633C53v33Ev,
  (VTBL_ENTRY)&_ZN6S633C53v34Ev,
  (VTBL_ENTRY)&_ZN6S633C53v35Ev,
  (VTBL_ENTRY)&_ZN6S633C53v36Ev,
  (VTBL_ENTRY)&_ZN6S633C53v37Ev,
  (VTBL_ENTRY)&_ZN6S633C53v38Ev,
  (VTBL_ENTRY)&_ZN6S633C53v39Ev,
  (VTBL_ENTRY)&_ZN6S633C53v40Ev,
  (VTBL_ENTRY)&_ZN6S633C53v41Ev,
  (VTBL_ENTRY)&_ZN6S633C53v42Ev,
  (VTBL_ENTRY)&_ZN6S633C53v43Ev,
  (VTBL_ENTRY)&_ZN6S633C53v44Ev,
  (VTBL_ENTRY)&_ZN6S633C53v45Ev,
  (VTBL_ENTRY)&_ZN6S633C53v46Ev,
  (VTBL_ENTRY)&_ZN6S633C53v47Ev,
  (VTBL_ENTRY)&_ZN6S633C53v48Ev,
  (VTBL_ENTRY)&_ZN6S633C53v49Ev,
  (VTBL_ENTRY)&_ZN6S633C53v50Ev,
  (VTBL_ENTRY)&_ZN6S633C53v51Ev,
  (VTBL_ENTRY)&_ZN6S633C53v52Ev,
  (VTBL_ENTRY)&_ZN6S633C53v53Ev,
  (VTBL_ENTRY)&_ZN6S633C53v54Ev,
  (VTBL_ENTRY)&_ZN6S633C53v55Ev,
  (VTBL_ENTRY)&_ZN6S633C53v56Ev,
  (VTBL_ENTRY)&_ZN6S633C53v57Ev,
  (VTBL_ENTRY)&_ZN6S633C53v58Ev,
  (VTBL_ENTRY)&_ZN6S633C53v59Ev,
  (VTBL_ENTRY)&_ZN6S633C53v60Ev,
  (VTBL_ENTRY)&_ZN6S633C53v61Ev,
  (VTBL_ENTRY)&_ZN6S633C53v62Ev,
  (VTBL_ENTRY)&_ZN6S633C53v63Ev,
  (VTBL_ENTRY)&_ZN6S633C53v64Ev,
  (VTBL_ENTRY)&_ZN6S633C53v65Ev,
  (VTBL_ENTRY)&_ZN6S633C53v66Ev,
  (VTBL_ENTRY)&_ZN6S633C53v67Ev,
  (VTBL_ENTRY)&_ZN6S633C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S633C5[];
extern  VTBL_ENTRY _ZTV6S633C5[];
Class_Descriptor cd_S633C5 = {  "S633C5", // class name
  0,0,//no base classes
  &(vtc_S633C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S633C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S633C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S633C4_nt  : S633C5 {
  int s633c4f0[2];
  void *s633c4f1;
  int s633c4f2[2];
  ::S248C38_nt s633c4f3;
  ::S248C38_nt s633c4f4;
  ::S4947C29 s633c4f5;
  ::S248C38_nt s633c4f6;
  unsigned int s633c4f7:1;
  unsigned int s633c4f8:1;
  unsigned int s633c4f9:1;
  unsigned int s633c4f10:1;
  unsigned int s633c4f11:1;
  int s633c4f12[2];
  virtual  ~S633C4_nt(); // _ZN9S633C4_ntD1Ev
  virtual void  v69(); // _ZN9S633C4_nt3v69Ev
  virtual void  v70(); // _ZN9S633C4_nt3v70Ev
  virtual void  v71(); // _ZN9S633C4_nt3v71Ev
  virtual void  v72(); // _ZN9S633C4_nt3v72Ev
  virtual void  v73(); // _ZN9S633C4_nt3v73Ev
  virtual void  v74(); // _ZN9S633C4_nt3v74Ev
  virtual void  v75(); // _ZN9S633C4_nt3v75Ev
  virtual void  v76(); // _ZN9S633C4_nt3v76Ev
  virtual void  v77(); // _ZN9S633C4_nt3v77Ev
  virtual void  v78(); // _ZN9S633C4_nt3v78Ev
  virtual void  v79(); // _ZN9S633C4_nt3v79Ev
  virtual void  v80(); // _ZN9S633C4_nt3v80Ev
  virtual void  v81(); // _ZN9S633C4_nt3v81Ev
  virtual void  v82(); // _ZN9S633C4_nt3v82Ev
  virtual void  v83(); // _ZN9S633C4_nt3v83Ev
  virtual void  v84(); // _ZN9S633C4_nt3v84Ev
  virtual void  v85(); // _ZN9S633C4_nt3v85Ev
  virtual void  v86(); // _ZN9S633C4_nt3v86Ev
  virtual void  v87(); // _ZN9S633C4_nt3v87Ev
  virtual void  v88(); // _ZN9S633C4_nt3v88Ev
  virtual void  v89(); // _ZN9S633C4_nt3v89Ev
  virtual void  v90(); // _ZN9S633C4_nt3v90Ev
  S633C4_nt(); // tgen
};
//SIG(-1 S633C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S633C4_nt ::~S633C4_nt(){ note_dtor("S633C4_nt", this);}
void  S633C4_nt ::v69(){vfunc_called(this, "_ZN9S633C4_nt3v69Ev");}
void  S633C4_nt ::v70(){vfunc_called(this, "_ZN9S633C4_nt3v70Ev");}
void  S633C4_nt ::v71(){vfunc_called(this, "_ZN9S633C4_nt3v71Ev");}
void  S633C4_nt ::v72(){vfunc_called(this, "_ZN9S633C4_nt3v72Ev");}
void  S633C4_nt ::v73(){vfunc_called(this, "_ZN9S633C4_nt3v73Ev");}
void  S633C4_nt ::v74(){vfunc_called(this, "_ZN9S633C4_nt3v74Ev");}
void  S633C4_nt ::v75(){vfunc_called(this, "_ZN9S633C4_nt3v75Ev");}
void  S633C4_nt ::v76(){vfunc_called(this, "_ZN9S633C4_nt3v76Ev");}
void  S633C4_nt ::v77(){vfunc_called(this, "_ZN9S633C4_nt3v77Ev");}
void  S633C4_nt ::v78(){vfunc_called(this, "_ZN9S633C4_nt3v78Ev");}
void  S633C4_nt ::v79(){vfunc_called(this, "_ZN9S633C4_nt3v79Ev");}
void  S633C4_nt ::v80(){vfunc_called(this, "_ZN9S633C4_nt3v80Ev");}
void  S633C4_nt ::v81(){vfunc_called(this, "_ZN9S633C4_nt3v81Ev");}
void  S633C4_nt ::v82(){vfunc_called(this, "_ZN9S633C4_nt3v82Ev");}
void  S633C4_nt ::v83(){vfunc_called(this, "_ZN9S633C4_nt3v83Ev");}
void  S633C4_nt ::v84(){vfunc_called(this, "_ZN9S633C4_nt3v84Ev");}
void  S633C4_nt ::v85(){vfunc_called(this, "_ZN9S633C4_nt3v85Ev");}
void  S633C4_nt ::v86(){vfunc_called(this, "_ZN9S633C4_nt3v86Ev");}
void  S633C4_nt ::v87(){vfunc_called(this, "_ZN9S633C4_nt3v87Ev");}
void  S633C4_nt ::v88(){vfunc_called(this, "_ZN9S633C4_nt3v88Ev");}
void  S633C4_nt ::v89(){vfunc_called(this, "_ZN9S633C4_nt3v89Ev");}
void  S633C4_nt ::v90(){vfunc_called(this, "_ZN9S633C4_nt3v90Ev");}
S633C4_nt ::S633C4_nt(){ note_ctor("S633C4_nt", this);} // tgen

//skip512 S633C4_nt

#else // __cplusplus

extern void _ZN9S633C4_ntC1Ev();
extern void _ZN9S633C4_ntD1Ev();
Name_Map name_map_S633C4_nt[] = {
  NSPAIR(_ZN9S633C4_ntC1Ev),
  NSPAIR(_ZN9S633C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S633C5;
extern VTBL_ENTRY _ZTI6S633C5[];
extern  VTBL_ENTRY _ZTV6S633C5[];
static Base_Class bases_S633C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S633C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S633C4_nt[];
extern void _ZN9S633C4_ntD1Ev();
extern void _ZN9S633C4_ntD0Ev();
extern void _ZN6S633C52v5Ev();
extern void _ZN6S633C52v6Ev();
extern void _ZN6S633C52v7Ev();
extern void _ZN6S633C52v8Ev();
extern void _ZN6S633C52v9Ev();
extern void _ZN6S633C53v10Ev();
extern void _ZN6S633C53v11Ev();
extern void _ZN6S633C53v12Ev();
extern void _ZN6S633C53v13Ev();
extern void _ZN6S633C53v14Ev();
extern void _ZN6S633C53v15Ev();
extern void _ZN6S633C53v16Ev();
extern void _ZN6S633C53v17Ev();
extern void _ZN6S633C53v18Ev();
extern void _ZN6S633C53v19Ev();
extern void _ZN6S633C53v20Ev();
extern void _ZN6S633C53v21Ev();
extern void _ZN6S633C53v22Ev();
extern void _ZN6S633C53v23Ev();
extern void _ZN6S633C53v24Ev();
extern void _ZN6S633C53v25Ev();
extern void _ZN6S633C53v26Ev();
extern void _ZN6S633C53v27Ev();
extern void _ZN6S633C53v28Ev();
extern void _ZN6S633C53v29Ev();
extern void _ZN6S633C53v30Ev();
extern void _ZN6S633C53v31Ev();
extern void _ZN6S633C53v32Ev();
extern void _ZN6S633C53v33Ev();
extern void _ZN6S633C53v34Ev();
extern void _ZN6S633C53v35Ev();
extern void _ZN6S633C53v36Ev();
extern void _ZN6S633C53v37Ev();
extern void _ZN6S633C53v38Ev();
extern void _ZN6S633C53v39Ev();
extern void _ZN6S633C53v40Ev();
extern void _ZN6S633C53v41Ev();
extern void _ZN6S633C53v42Ev();
extern void _ZN6S633C53v43Ev();
extern void _ZN6S633C53v44Ev();
extern void _ZN6S633C53v45Ev();
extern void _ZN6S633C53v46Ev();
extern void _ZN6S633C53v47Ev();
extern void _ZN6S633C53v48Ev();
extern void _ZN6S633C53v49Ev();
extern void _ZN6S633C53v50Ev();
extern void _ZN6S633C53v51Ev();
extern void _ZN6S633C53v52Ev();
extern void _ZN6S633C53v53Ev();
extern void _ZN6S633C53v54Ev();
extern void _ZN6S633C53v55Ev();
extern void _ZN6S633C53v56Ev();
extern void _ZN6S633C53v57Ev();
extern void _ZN6S633C53v58Ev();
extern void _ZN6S633C53v59Ev();
extern void _ZN6S633C53v60Ev();
extern void _ZN6S633C53v61Ev();
extern void _ZN6S633C53v62Ev();
extern void _ZN6S633C53v63Ev();
extern void _ZN6S633C53v64Ev();
extern void _ZN6S633C53v65Ev();
extern void _ZN6S633C53v66Ev();
extern void _ZN6S633C53v67Ev();
extern void _ZN6S633C53v68Ev();
extern void _ZN9S633C4_nt3v69Ev();
extern void _ZN9S633C4_nt3v70Ev();
extern void _ZN9S633C4_nt3v71Ev();
extern void _ZN9S633C4_nt3v72Ev();
extern void _ZN9S633C4_nt3v73Ev();
extern void _ZN9S633C4_nt3v74Ev();
extern void _ZN9S633C4_nt3v75Ev();
extern void _ZN9S633C4_nt3v76Ev();
extern void _ZN9S633C4_nt3v77Ev();
extern void _ZN9S633C4_nt3v78Ev();
extern void _ZN9S633C4_nt3v79Ev();
extern void _ZN9S633C4_nt3v80Ev();
extern void _ZN9S633C4_nt3v81Ev();
extern void _ZN9S633C4_nt3v82Ev();
extern void _ZN9S633C4_nt3v83Ev();
extern void _ZN9S633C4_nt3v84Ev();
extern void _ZN9S633C4_nt3v85Ev();
extern void _ZN9S633C4_nt3v86Ev();
extern void _ZN9S633C4_nt3v87Ev();
extern void _ZN9S633C4_nt3v88Ev();
extern void _ZN9S633C4_nt3v89Ev();
extern void _ZN9S633C4_nt3v90Ev();
static  VTBL_ENTRY vtc_S633C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S633C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S633C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S633C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S633C52v5Ev,
  (VTBL_ENTRY)&_ZN6S633C52v6Ev,
  (VTBL_ENTRY)&_ZN6S633C52v7Ev,
  (VTBL_ENTRY)&_ZN6S633C52v8Ev,
  (VTBL_ENTRY)&_ZN6S633C52v9Ev,
  (VTBL_ENTRY)&_ZN6S633C53v10Ev,
  (VTBL_ENTRY)&_ZN6S633C53v11Ev,
  (VTBL_ENTRY)&_ZN6S633C53v12Ev,
  (VTBL_ENTRY)&_ZN6S633C53v13Ev,
  (VTBL_ENTRY)&_ZN6S633C53v14Ev,
  (VTBL_ENTRY)&_ZN6S633C53v15Ev,
  (VTBL_ENTRY)&_ZN6S633C53v16Ev,
  (VTBL_ENTRY)&_ZN6S633C53v17Ev,
  (VTBL_ENTRY)&_ZN6S633C53v18Ev,
  (VTBL_ENTRY)&_ZN6S633C53v19Ev,
  (VTBL_ENTRY)&_ZN6S633C53v20Ev,
  (VTBL_ENTRY)&_ZN6S633C53v21Ev,
  (VTBL_ENTRY)&_ZN6S633C53v22Ev,
  (VTBL_ENTRY)&_ZN6S633C53v23Ev,
  (VTBL_ENTRY)&_ZN6S633C53v24Ev,
  (VTBL_ENTRY)&_ZN6S633C53v25Ev,
  (VTBL_ENTRY)&_ZN6S633C53v26Ev,
  (VTBL_ENTRY)&_ZN6S633C53v27Ev,
  (VTBL_ENTRY)&_ZN6S633C53v28Ev,
  (VTBL_ENTRY)&_ZN6S633C53v29Ev,
  (VTBL_ENTRY)&_ZN6S633C53v30Ev,
  (VTBL_ENTRY)&_ZN6S633C53v31Ev,
  (VTBL_ENTRY)&_ZN6S633C53v32Ev,
  (VTBL_ENTRY)&_ZN6S633C53v33Ev,
  (VTBL_ENTRY)&_ZN6S633C53v34Ev,
  (VTBL_ENTRY)&_ZN6S633C53v35Ev,
  (VTBL_ENTRY)&_ZN6S633C53v36Ev,
  (VTBL_ENTRY)&_ZN6S633C53v37Ev,
  (VTBL_ENTRY)&_ZN6S633C53v38Ev,
  (VTBL_ENTRY)&_ZN6S633C53v39Ev,
  (VTBL_ENTRY)&_ZN6S633C53v40Ev,
  (VTBL_ENTRY)&_ZN6S633C53v41Ev,
  (VTBL_ENTRY)&_ZN6S633C53v42Ev,
  (VTBL_ENTRY)&_ZN6S633C53v43Ev,
  (VTBL_ENTRY)&_ZN6S633C53v44Ev,
  (VTBL_ENTRY)&_ZN6S633C53v45Ev,
  (VTBL_ENTRY)&_ZN6S633C53v46Ev,
  (VTBL_ENTRY)&_ZN6S633C53v47Ev,
  (VTBL_ENTRY)&_ZN6S633C53v48Ev,
  (VTBL_ENTRY)&_ZN6S633C53v49Ev,
  (VTBL_ENTRY)&_ZN6S633C53v50Ev,
  (VTBL_ENTRY)&_ZN6S633C53v51Ev,
  (VTBL_ENTRY)&_ZN6S633C53v52Ev,
  (VTBL_ENTRY)&_ZN6S633C53v53Ev,
  (VTBL_ENTRY)&_ZN6S633C53v54Ev,
  (VTBL_ENTRY)&_ZN6S633C53v55Ev,
  (VTBL_ENTRY)&_ZN6S633C53v56Ev,
  (VTBL_ENTRY)&_ZN6S633C53v57Ev,
  (VTBL_ENTRY)&_ZN6S633C53v58Ev,
  (VTBL_ENTRY)&_ZN6S633C53v59Ev,
  (VTBL_ENTRY)&_ZN6S633C53v60Ev,
  (VTBL_ENTRY)&_ZN6S633C53v61Ev,
  (VTBL_ENTRY)&_ZN6S633C53v62Ev,
  (VTBL_ENTRY)&_ZN6S633C53v63Ev,
  (VTBL_ENTRY)&_ZN6S633C53v64Ev,
  (VTBL_ENTRY)&_ZN6S633C53v65Ev,
  (VTBL_ENTRY)&_ZN6S633C53v66Ev,
  (VTBL_ENTRY)&_ZN6S633C53v67Ev,
  (VTBL_ENTRY)&_ZN6S633C53v68Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v90Ev,
};
extern VTBL_ENTRY _ZTI9S633C4_nt[];
VTBL_ENTRY *P__ZTI9S633C4_nt = _ZTI9S633C4_nt; 
extern  VTBL_ENTRY _ZTV9S633C4_nt[];
Class_Descriptor cd_S633C4_nt = {  "S633C4_nt", // class name
  bases_S633C4_nt, 1,
  &(vtc_S633C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S633C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S633C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S633C3_nt  : S633C4_nt {
  unsigned int s633c3f0:1;
  unsigned int s633c3f1:1;
  unsigned int s633c3f2:1;
  ::S248C43 s633c3f3;
  ::S248C39 s633c3f4;
  ::S248C18 s633c3f5;
  ::S248C14 s633c3f6;
  int s633c3f7[3];
  virtual  ~S633C3_nt(); // _ZN9S633C3_ntD1Ev
  virtual void  v91(); // _ZN9S633C3_nt3v91Ev
  virtual void  v92(); // _ZN9S633C3_nt3v92Ev
  virtual void  v93(); // _ZN9S633C3_nt3v93Ev
  virtual void  v94(); // _ZN9S633C3_nt3v94Ev
  virtual void  v95(); // _ZN9S633C3_nt3v95Ev
  virtual void  v96(); // _ZN9S633C3_nt3v96Ev
  virtual void  v97(); // _ZN9S633C3_nt3v97Ev
  virtual void  v98(); // _ZN9S633C3_nt3v98Ev
  virtual void  v99(); // _ZN9S633C3_nt3v99Ev
  virtual void  v100(); // _ZN9S633C3_nt4v100Ev
  virtual void  v101(); // _ZN9S633C3_nt4v101Ev
  virtual void  v102(); // _ZN9S633C3_nt4v102Ev
  virtual void  v103(); // _ZN9S633C3_nt4v103Ev
  virtual void  v104(); // _ZN9S633C3_nt4v104Ev
  virtual void  v105(); // _ZN9S633C3_nt4v105Ev
  virtual void  v106(); // _ZN9S633C3_nt4v106Ev
  virtual void  v107(); // _ZN9S633C3_nt4v107Ev
  virtual void  v108(); // _ZN9S633C3_nt4v108Ev
  virtual void  v109(); // _ZN9S633C3_nt4v109Ev
  virtual void  v110(); // _ZN9S633C3_nt4v110Ev
  S633C3_nt(); // tgen
};
//SIG(-1 S633C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC6 FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} Fi[3]}


 S633C3_nt ::~S633C3_nt(){ note_dtor("S633C3_nt", this);}
void  S633C3_nt ::v91(){vfunc_called(this, "_ZN9S633C3_nt3v91Ev");}
void  S633C3_nt ::v92(){vfunc_called(this, "_ZN9S633C3_nt3v92Ev");}
void  S633C3_nt ::v93(){vfunc_called(this, "_ZN9S633C3_nt3v93Ev");}
void  S633C3_nt ::v94(){vfunc_called(this, "_ZN9S633C3_nt3v94Ev");}
void  S633C3_nt ::v95(){vfunc_called(this, "_ZN9S633C3_nt3v95Ev");}
void  S633C3_nt ::v96(){vfunc_called(this, "_ZN9S633C3_nt3v96Ev");}
void  S633C3_nt ::v97(){vfunc_called(this, "_ZN9S633C3_nt3v97Ev");}
void  S633C3_nt ::v98(){vfunc_called(this, "_ZN9S633C3_nt3v98Ev");}
void  S633C3_nt ::v99(){vfunc_called(this, "_ZN9S633C3_nt3v99Ev");}
void  S633C3_nt ::v100(){vfunc_called(this, "_ZN9S633C3_nt4v100Ev");}
void  S633C3_nt ::v101(){vfunc_called(this, "_ZN9S633C3_nt4v101Ev");}
void  S633C3_nt ::v102(){vfunc_called(this, "_ZN9S633C3_nt4v102Ev");}
void  S633C3_nt ::v103(){vfunc_called(this, "_ZN9S633C3_nt4v103Ev");}
void  S633C3_nt ::v104(){vfunc_called(this, "_ZN9S633C3_nt4v104Ev");}
void  S633C3_nt ::v105(){vfunc_called(this, "_ZN9S633C3_nt4v105Ev");}
void  S633C3_nt ::v106(){vfunc_called(this, "_ZN9S633C3_nt4v106Ev");}
void  S633C3_nt ::v107(){vfunc_called(this, "_ZN9S633C3_nt4v107Ev");}
void  S633C3_nt ::v108(){vfunc_called(this, "_ZN9S633C3_nt4v108Ev");}
void  S633C3_nt ::v109(){vfunc_called(this, "_ZN9S633C3_nt4v109Ev");}
void  S633C3_nt ::v110(){vfunc_called(this, "_ZN9S633C3_nt4v110Ev");}
S633C3_nt ::S633C3_nt(){ note_ctor("S633C3_nt", this);} // tgen

//skip512 S633C3_nt

#else // __cplusplus

extern void _ZN9S633C3_ntC1Ev();
extern void _ZN9S633C3_ntD1Ev();
Name_Map name_map_S633C3_nt[] = {
  NSPAIR(_ZN9S633C3_ntC1Ev),
  NSPAIR(_ZN9S633C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S633C5;
extern VTBL_ENTRY _ZTI6S633C5[];
extern  VTBL_ENTRY _ZTV6S633C5[];
extern Class_Descriptor cd_S633C4_nt;
extern VTBL_ENTRY _ZTI9S633C4_nt[];
extern  VTBL_ENTRY _ZTV9S633C4_nt[];
static Base_Class bases_S633C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S633C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S633C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S633C3_nt[];
extern void _ZN9S633C3_ntD1Ev();
extern void _ZN9S633C3_ntD0Ev();
extern void _ZN6S633C52v5Ev();
extern void _ZN6S633C52v6Ev();
extern void _ZN6S633C52v7Ev();
extern void _ZN6S633C52v8Ev();
extern void _ZN6S633C52v9Ev();
extern void _ZN6S633C53v10Ev();
extern void _ZN6S633C53v11Ev();
extern void _ZN6S633C53v12Ev();
extern void _ZN6S633C53v13Ev();
extern void _ZN6S633C53v14Ev();
extern void _ZN6S633C53v15Ev();
extern void _ZN6S633C53v16Ev();
extern void _ZN6S633C53v17Ev();
extern void _ZN6S633C53v18Ev();
extern void _ZN6S633C53v19Ev();
extern void _ZN6S633C53v20Ev();
extern void _ZN6S633C53v21Ev();
extern void _ZN6S633C53v22Ev();
extern void _ZN6S633C53v23Ev();
extern void _ZN6S633C53v24Ev();
extern void _ZN6S633C53v25Ev();
extern void _ZN6S633C53v26Ev();
extern void _ZN6S633C53v27Ev();
extern void _ZN6S633C53v28Ev();
extern void _ZN6S633C53v29Ev();
extern void _ZN6S633C53v30Ev();
extern void _ZN6S633C53v31Ev();
extern void _ZN6S633C53v32Ev();
extern void _ZN6S633C53v33Ev();
extern void _ZN6S633C53v34Ev();
extern void _ZN6S633C53v35Ev();
extern void _ZN6S633C53v36Ev();
extern void _ZN6S633C53v37Ev();
extern void _ZN6S633C53v38Ev();
extern void _ZN6S633C53v39Ev();
extern void _ZN6S633C53v40Ev();
extern void _ZN6S633C53v41Ev();
extern void _ZN6S633C53v42Ev();
extern void _ZN6S633C53v43Ev();
extern void _ZN6S633C53v44Ev();
extern void _ZN6S633C53v45Ev();
extern void _ZN6S633C53v46Ev();
extern void _ZN6S633C53v47Ev();
extern void _ZN6S633C53v48Ev();
extern void _ZN6S633C53v49Ev();
extern void _ZN6S633C53v50Ev();
extern void _ZN6S633C53v51Ev();
extern void _ZN6S633C53v52Ev();
extern void _ZN6S633C53v53Ev();
extern void _ZN6S633C53v54Ev();
extern void _ZN6S633C53v55Ev();
extern void _ZN6S633C53v56Ev();
extern void _ZN6S633C53v57Ev();
extern void _ZN6S633C53v58Ev();
extern void _ZN6S633C53v59Ev();
extern void _ZN6S633C53v60Ev();
extern void _ZN6S633C53v61Ev();
extern void _ZN6S633C53v62Ev();
extern void _ZN6S633C53v63Ev();
extern void _ZN6S633C53v64Ev();
extern void _ZN6S633C53v65Ev();
extern void _ZN6S633C53v66Ev();
extern void _ZN6S633C53v67Ev();
extern void _ZN6S633C53v68Ev();
extern void _ZN9S633C4_nt3v69Ev();
extern void _ZN9S633C4_nt3v70Ev();
extern void _ZN9S633C4_nt3v71Ev();
extern void _ZN9S633C4_nt3v72Ev();
extern void _ZN9S633C4_nt3v73Ev();
extern void _ZN9S633C4_nt3v74Ev();
extern void _ZN9S633C4_nt3v75Ev();
extern void _ZN9S633C4_nt3v76Ev();
extern void _ZN9S633C4_nt3v77Ev();
extern void _ZN9S633C4_nt3v78Ev();
extern void _ZN9S633C4_nt3v79Ev();
extern void _ZN9S633C4_nt3v80Ev();
extern void _ZN9S633C4_nt3v81Ev();
extern void _ZN9S633C4_nt3v82Ev();
extern void _ZN9S633C4_nt3v83Ev();
extern void _ZN9S633C4_nt3v84Ev();
extern void _ZN9S633C4_nt3v85Ev();
extern void _ZN9S633C4_nt3v86Ev();
extern void _ZN9S633C4_nt3v87Ev();
extern void _ZN9S633C4_nt3v88Ev();
extern void _ZN9S633C4_nt3v89Ev();
extern void _ZN9S633C4_nt3v90Ev();
extern void _ZN9S633C3_nt3v91Ev();
extern void _ZN9S633C3_nt3v92Ev();
extern void _ZN9S633C3_nt3v93Ev();
extern void _ZN9S633C3_nt3v94Ev();
extern void _ZN9S633C3_nt3v95Ev();
extern void _ZN9S633C3_nt3v96Ev();
extern void _ZN9S633C3_nt3v97Ev();
extern void _ZN9S633C3_nt3v98Ev();
extern void _ZN9S633C3_nt3v99Ev();
extern void _ZN9S633C3_nt4v100Ev();
extern void _ZN9S633C3_nt4v101Ev();
extern void _ZN9S633C3_nt4v102Ev();
extern void _ZN9S633C3_nt4v103Ev();
extern void _ZN9S633C3_nt4v104Ev();
extern void _ZN9S633C3_nt4v105Ev();
extern void _ZN9S633C3_nt4v106Ev();
extern void _ZN9S633C3_nt4v107Ev();
extern void _ZN9S633C3_nt4v108Ev();
extern void _ZN9S633C3_nt4v109Ev();
extern void _ZN9S633C3_nt4v110Ev();
static  VTBL_ENTRY vtc_S633C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S633C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S633C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S633C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S633C52v5Ev,
  (VTBL_ENTRY)&_ZN6S633C52v6Ev,
  (VTBL_ENTRY)&_ZN6S633C52v7Ev,
  (VTBL_ENTRY)&_ZN6S633C52v8Ev,
  (VTBL_ENTRY)&_ZN6S633C52v9Ev,
  (VTBL_ENTRY)&_ZN6S633C53v10Ev,
  (VTBL_ENTRY)&_ZN6S633C53v11Ev,
  (VTBL_ENTRY)&_ZN6S633C53v12Ev,
  (VTBL_ENTRY)&_ZN6S633C53v13Ev,
  (VTBL_ENTRY)&_ZN6S633C53v14Ev,
  (VTBL_ENTRY)&_ZN6S633C53v15Ev,
  (VTBL_ENTRY)&_ZN6S633C53v16Ev,
  (VTBL_ENTRY)&_ZN6S633C53v17Ev,
  (VTBL_ENTRY)&_ZN6S633C53v18Ev,
  (VTBL_ENTRY)&_ZN6S633C53v19Ev,
  (VTBL_ENTRY)&_ZN6S633C53v20Ev,
  (VTBL_ENTRY)&_ZN6S633C53v21Ev,
  (VTBL_ENTRY)&_ZN6S633C53v22Ev,
  (VTBL_ENTRY)&_ZN6S633C53v23Ev,
  (VTBL_ENTRY)&_ZN6S633C53v24Ev,
  (VTBL_ENTRY)&_ZN6S633C53v25Ev,
  (VTBL_ENTRY)&_ZN6S633C53v26Ev,
  (VTBL_ENTRY)&_ZN6S633C53v27Ev,
  (VTBL_ENTRY)&_ZN6S633C53v28Ev,
  (VTBL_ENTRY)&_ZN6S633C53v29Ev,
  (VTBL_ENTRY)&_ZN6S633C53v30Ev,
  (VTBL_ENTRY)&_ZN6S633C53v31Ev,
  (VTBL_ENTRY)&_ZN6S633C53v32Ev,
  (VTBL_ENTRY)&_ZN6S633C53v33Ev,
  (VTBL_ENTRY)&_ZN6S633C53v34Ev,
  (VTBL_ENTRY)&_ZN6S633C53v35Ev,
  (VTBL_ENTRY)&_ZN6S633C53v36Ev,
  (VTBL_ENTRY)&_ZN6S633C53v37Ev,
  (VTBL_ENTRY)&_ZN6S633C53v38Ev,
  (VTBL_ENTRY)&_ZN6S633C53v39Ev,
  (VTBL_ENTRY)&_ZN6S633C53v40Ev,
  (VTBL_ENTRY)&_ZN6S633C53v41Ev,
  (VTBL_ENTRY)&_ZN6S633C53v42Ev,
  (VTBL_ENTRY)&_ZN6S633C53v43Ev,
  (VTBL_ENTRY)&_ZN6S633C53v44Ev,
  (VTBL_ENTRY)&_ZN6S633C53v45Ev,
  (VTBL_ENTRY)&_ZN6S633C53v46Ev,
  (VTBL_ENTRY)&_ZN6S633C53v47Ev,
  (VTBL_ENTRY)&_ZN6S633C53v48Ev,
  (VTBL_ENTRY)&_ZN6S633C53v49Ev,
  (VTBL_ENTRY)&_ZN6S633C53v50Ev,
  (VTBL_ENTRY)&_ZN6S633C53v51Ev,
  (VTBL_ENTRY)&_ZN6S633C53v52Ev,
  (VTBL_ENTRY)&_ZN6S633C53v53Ev,
  (VTBL_ENTRY)&_ZN6S633C53v54Ev,
  (VTBL_ENTRY)&_ZN6S633C53v55Ev,
  (VTBL_ENTRY)&_ZN6S633C53v56Ev,
  (VTBL_ENTRY)&_ZN6S633C53v57Ev,
  (VTBL_ENTRY)&_ZN6S633C53v58Ev,
  (VTBL_ENTRY)&_ZN6S633C53v59Ev,
  (VTBL_ENTRY)&_ZN6S633C53v60Ev,
  (VTBL_ENTRY)&_ZN6S633C53v61Ev,
  (VTBL_ENTRY)&_ZN6S633C53v62Ev,
  (VTBL_ENTRY)&_ZN6S633C53v63Ev,
  (VTBL_ENTRY)&_ZN6S633C53v64Ev,
  (VTBL_ENTRY)&_ZN6S633C53v65Ev,
  (VTBL_ENTRY)&_ZN6S633C53v66Ev,
  (VTBL_ENTRY)&_ZN6S633C53v67Ev,
  (VTBL_ENTRY)&_ZN6S633C53v68Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v110Ev,
};
extern VTBL_ENTRY _ZTI9S633C3_nt[];
VTBL_ENTRY *P__ZTI9S633C3_nt = _ZTI9S633C3_nt; 
extern  VTBL_ENTRY _ZTV9S633C3_nt[];
Class_Descriptor cd_S633C3_nt = {  "S633C3_nt", // class name
  bases_S633C3_nt, 2,
  &(vtc_S633C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S633C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S633C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S633C2_nt  : S633C3_nt {
  ::S248C7_nt s633c2f0;
  unsigned int s633c2f1:1;
  ::S248C9_nt s633c2f2;
  virtual  ~S633C2_nt(); // _ZN9S633C2_ntD1Ev
  virtual void  v111(); // _ZN9S633C2_nt4v111Ev
  virtual void  v112(); // _ZN9S633C2_nt4v112Ev
  virtual void  v113(); // _ZN9S633C2_nt4v113Ev
  virtual void  v114(); // _ZN9S633C2_nt4v114Ev
  S633C2_nt(); // tgen
};
//SIG(-1 S633C2_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC7 FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17{ BC18{ BC9}}}


 S633C2_nt ::~S633C2_nt(){ note_dtor("S633C2_nt", this);}
void  S633C2_nt ::v111(){vfunc_called(this, "_ZN9S633C2_nt4v111Ev");}
void  S633C2_nt ::v112(){vfunc_called(this, "_ZN9S633C2_nt4v112Ev");}
void  S633C2_nt ::v113(){vfunc_called(this, "_ZN9S633C2_nt4v113Ev");}
void  S633C2_nt ::v114(){vfunc_called(this, "_ZN9S633C2_nt4v114Ev");}
S633C2_nt ::S633C2_nt(){ note_ctor("S633C2_nt", this);} // tgen

//skip512 S633C2_nt

#else // __cplusplus

extern void _ZN9S633C2_ntC1Ev();
extern void _ZN9S633C2_ntD1Ev();
Name_Map name_map_S633C2_nt[] = {
  NSPAIR(_ZN9S633C2_ntC1Ev),
  NSPAIR(_ZN9S633C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S633C5;
extern VTBL_ENTRY _ZTI6S633C5[];
extern  VTBL_ENTRY _ZTV6S633C5[];
extern Class_Descriptor cd_S633C4_nt;
extern VTBL_ENTRY _ZTI9S633C4_nt[];
extern  VTBL_ENTRY _ZTV9S633C4_nt[];
extern Class_Descriptor cd_S633C3_nt;
extern VTBL_ENTRY _ZTI9S633C3_nt[];
extern  VTBL_ENTRY _ZTV9S633C3_nt[];
static Base_Class bases_S633C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S633C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S633C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S633C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S633C2_nt[];
extern void _ZN9S633C2_ntD1Ev();
extern void _ZN9S633C2_ntD0Ev();
extern void _ZN6S633C52v5Ev();
extern void _ZN6S633C52v6Ev();
extern void _ZN6S633C52v7Ev();
extern void _ZN6S633C52v8Ev();
extern void _ZN6S633C52v9Ev();
extern void _ZN6S633C53v10Ev();
extern void _ZN6S633C53v11Ev();
extern void _ZN6S633C53v12Ev();
extern void _ZN6S633C53v13Ev();
extern void _ZN6S633C53v14Ev();
extern void _ZN6S633C53v15Ev();
extern void _ZN6S633C53v16Ev();
extern void _ZN6S633C53v17Ev();
extern void _ZN6S633C53v18Ev();
extern void _ZN6S633C53v19Ev();
extern void _ZN6S633C53v20Ev();
extern void _ZN6S633C53v21Ev();
extern void _ZN6S633C53v22Ev();
extern void _ZN6S633C53v23Ev();
extern void _ZN6S633C53v24Ev();
extern void _ZN6S633C53v25Ev();
extern void _ZN6S633C53v26Ev();
extern void _ZN6S633C53v27Ev();
extern void _ZN6S633C53v28Ev();
extern void _ZN6S633C53v29Ev();
extern void _ZN6S633C53v30Ev();
extern void _ZN6S633C53v31Ev();
extern void _ZN6S633C53v32Ev();
extern void _ZN6S633C53v33Ev();
extern void _ZN6S633C53v34Ev();
extern void _ZN6S633C53v35Ev();
extern void _ZN6S633C53v36Ev();
extern void _ZN6S633C53v37Ev();
extern void _ZN6S633C53v38Ev();
extern void _ZN6S633C53v39Ev();
extern void _ZN6S633C53v40Ev();
extern void _ZN6S633C53v41Ev();
extern void _ZN6S633C53v42Ev();
extern void _ZN6S633C53v43Ev();
extern void _ZN6S633C53v44Ev();
extern void _ZN6S633C53v45Ev();
extern void _ZN6S633C53v46Ev();
extern void _ZN6S633C53v47Ev();
extern void _ZN6S633C53v48Ev();
extern void _ZN6S633C53v49Ev();
extern void _ZN6S633C53v50Ev();
extern void _ZN6S633C53v51Ev();
extern void _ZN6S633C53v52Ev();
extern void _ZN6S633C53v53Ev();
extern void _ZN6S633C53v54Ev();
extern void _ZN6S633C53v55Ev();
extern void _ZN6S633C53v56Ev();
extern void _ZN6S633C53v57Ev();
extern void _ZN6S633C53v58Ev();
extern void _ZN6S633C53v59Ev();
extern void _ZN6S633C53v60Ev();
extern void _ZN6S633C53v61Ev();
extern void _ZN6S633C53v62Ev();
extern void _ZN6S633C53v63Ev();
extern void _ZN6S633C53v64Ev();
extern void _ZN6S633C53v65Ev();
extern void _ZN6S633C53v66Ev();
extern void _ZN6S633C53v67Ev();
extern void _ZN6S633C53v68Ev();
extern void _ZN9S633C4_nt3v69Ev();
extern void _ZN9S633C4_nt3v70Ev();
extern void _ZN9S633C4_nt3v71Ev();
extern void _ZN9S633C4_nt3v72Ev();
extern void _ZN9S633C4_nt3v73Ev();
extern void _ZN9S633C4_nt3v74Ev();
extern void _ZN9S633C4_nt3v75Ev();
extern void _ZN9S633C4_nt3v76Ev();
extern void _ZN9S633C4_nt3v77Ev();
extern void _ZN9S633C4_nt3v78Ev();
extern void _ZN9S633C4_nt3v79Ev();
extern void _ZN9S633C4_nt3v80Ev();
extern void _ZN9S633C4_nt3v81Ev();
extern void _ZN9S633C4_nt3v82Ev();
extern void _ZN9S633C4_nt3v83Ev();
extern void _ZN9S633C4_nt3v84Ev();
extern void _ZN9S633C4_nt3v85Ev();
extern void _ZN9S633C4_nt3v86Ev();
extern void _ZN9S633C4_nt3v87Ev();
extern void _ZN9S633C4_nt3v88Ev();
extern void _ZN9S633C4_nt3v89Ev();
extern void _ZN9S633C4_nt3v90Ev();
extern void _ZN9S633C3_nt3v91Ev();
extern void _ZN9S633C3_nt3v92Ev();
extern void _ZN9S633C3_nt3v93Ev();
extern void _ZN9S633C3_nt3v94Ev();
extern void _ZN9S633C3_nt3v95Ev();
extern void _ZN9S633C3_nt3v96Ev();
extern void _ZN9S633C3_nt3v97Ev();
extern void _ZN9S633C3_nt3v98Ev();
extern void _ZN9S633C3_nt3v99Ev();
extern void _ZN9S633C3_nt4v100Ev();
extern void _ZN9S633C3_nt4v101Ev();
extern void _ZN9S633C3_nt4v102Ev();
extern void _ZN9S633C3_nt4v103Ev();
extern void _ZN9S633C3_nt4v104Ev();
extern void _ZN9S633C3_nt4v105Ev();
extern void _ZN9S633C3_nt4v106Ev();
extern void _ZN9S633C3_nt4v107Ev();
extern void _ZN9S633C3_nt4v108Ev();
extern void _ZN9S633C3_nt4v109Ev();
extern void _ZN9S633C3_nt4v110Ev();
extern void _ZN9S633C2_nt4v111Ev();
extern void _ZN9S633C2_nt4v112Ev();
extern void _ZN9S633C2_nt4v113Ev();
extern void _ZN9S633C2_nt4v114Ev();
static  VTBL_ENTRY vtc_S633C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S633C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S633C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S633C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S633C52v5Ev,
  (VTBL_ENTRY)&_ZN6S633C52v6Ev,
  (VTBL_ENTRY)&_ZN6S633C52v7Ev,
  (VTBL_ENTRY)&_ZN6S633C52v8Ev,
  (VTBL_ENTRY)&_ZN6S633C52v9Ev,
  (VTBL_ENTRY)&_ZN6S633C53v10Ev,
  (VTBL_ENTRY)&_ZN6S633C53v11Ev,
  (VTBL_ENTRY)&_ZN6S633C53v12Ev,
  (VTBL_ENTRY)&_ZN6S633C53v13Ev,
  (VTBL_ENTRY)&_ZN6S633C53v14Ev,
  (VTBL_ENTRY)&_ZN6S633C53v15Ev,
  (VTBL_ENTRY)&_ZN6S633C53v16Ev,
  (VTBL_ENTRY)&_ZN6S633C53v17Ev,
  (VTBL_ENTRY)&_ZN6S633C53v18Ev,
  (VTBL_ENTRY)&_ZN6S633C53v19Ev,
  (VTBL_ENTRY)&_ZN6S633C53v20Ev,
  (VTBL_ENTRY)&_ZN6S633C53v21Ev,
  (VTBL_ENTRY)&_ZN6S633C53v22Ev,
  (VTBL_ENTRY)&_ZN6S633C53v23Ev,
  (VTBL_ENTRY)&_ZN6S633C53v24Ev,
  (VTBL_ENTRY)&_ZN6S633C53v25Ev,
  (VTBL_ENTRY)&_ZN6S633C53v26Ev,
  (VTBL_ENTRY)&_ZN6S633C53v27Ev,
  (VTBL_ENTRY)&_ZN6S633C53v28Ev,
  (VTBL_ENTRY)&_ZN6S633C53v29Ev,
  (VTBL_ENTRY)&_ZN6S633C53v30Ev,
  (VTBL_ENTRY)&_ZN6S633C53v31Ev,
  (VTBL_ENTRY)&_ZN6S633C53v32Ev,
  (VTBL_ENTRY)&_ZN6S633C53v33Ev,
  (VTBL_ENTRY)&_ZN6S633C53v34Ev,
  (VTBL_ENTRY)&_ZN6S633C53v35Ev,
  (VTBL_ENTRY)&_ZN6S633C53v36Ev,
  (VTBL_ENTRY)&_ZN6S633C53v37Ev,
  (VTBL_ENTRY)&_ZN6S633C53v38Ev,
  (VTBL_ENTRY)&_ZN6S633C53v39Ev,
  (VTBL_ENTRY)&_ZN6S633C53v40Ev,
  (VTBL_ENTRY)&_ZN6S633C53v41Ev,
  (VTBL_ENTRY)&_ZN6S633C53v42Ev,
  (VTBL_ENTRY)&_ZN6S633C53v43Ev,
  (VTBL_ENTRY)&_ZN6S633C53v44Ev,
  (VTBL_ENTRY)&_ZN6S633C53v45Ev,
  (VTBL_ENTRY)&_ZN6S633C53v46Ev,
  (VTBL_ENTRY)&_ZN6S633C53v47Ev,
  (VTBL_ENTRY)&_ZN6S633C53v48Ev,
  (VTBL_ENTRY)&_ZN6S633C53v49Ev,
  (VTBL_ENTRY)&_ZN6S633C53v50Ev,
  (VTBL_ENTRY)&_ZN6S633C53v51Ev,
  (VTBL_ENTRY)&_ZN6S633C53v52Ev,
  (VTBL_ENTRY)&_ZN6S633C53v53Ev,
  (VTBL_ENTRY)&_ZN6S633C53v54Ev,
  (VTBL_ENTRY)&_ZN6S633C53v55Ev,
  (VTBL_ENTRY)&_ZN6S633C53v56Ev,
  (VTBL_ENTRY)&_ZN6S633C53v57Ev,
  (VTBL_ENTRY)&_ZN6S633C53v58Ev,
  (VTBL_ENTRY)&_ZN6S633C53v59Ev,
  (VTBL_ENTRY)&_ZN6S633C53v60Ev,
  (VTBL_ENTRY)&_ZN6S633C53v61Ev,
  (VTBL_ENTRY)&_ZN6S633C53v62Ev,
  (VTBL_ENTRY)&_ZN6S633C53v63Ev,
  (VTBL_ENTRY)&_ZN6S633C53v64Ev,
  (VTBL_ENTRY)&_ZN6S633C53v65Ev,
  (VTBL_ENTRY)&_ZN6S633C53v66Ev,
  (VTBL_ENTRY)&_ZN6S633C53v67Ev,
  (VTBL_ENTRY)&_ZN6S633C53v68Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v114Ev,
};
extern VTBL_ENTRY _ZTI9S633C2_nt[];
VTBL_ENTRY *P__ZTI9S633C2_nt = _ZTI9S633C2_nt; 
extern  VTBL_ENTRY _ZTV9S633C2_nt[];
Class_Descriptor cd_S633C2_nt = {  "S633C2_nt", // class name
  bases_S633C2_nt, 3,
  &(vtc_S633C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S633C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S633C2_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S633C1  : S633C2_nt {
  unsigned int s633c1f0:1;
  unsigned int s633c1f1:1;
  ::S248C30_nt s633c1f2;
  ::S248C30_nt s633c1f3;
  ::S248C30_nt s633c1f4;
  void *s633c1f5;
  int s633c1f6;
  virtual  ~S633C1(); // _ZN6S633C1D1Ev
  virtual void  v1(); // _ZN6S633C12v1Ev
  virtual void  v2(); // _ZN6S633C12v2Ev
  virtual void  v3(); // _ZN6S633C12v3Ev
  virtual void  v4(); // _ZN6S633C12v4Ev
  S633C1(); // tgen
};
//SIG(1 S633C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC8 FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} Fi[3]} vd v111 v112 v113 v114 FC6 Fi:1 FC18{ BC19{ BC10}}} vd v1 v2 v3 v4 Fi:1 Fi:1 FC20{ m Fi[3]} FC20 FC20 Fp Fi}


 S633C1 ::~S633C1(){ note_dtor("S633C1", this);}
void  S633C1 ::v1(){vfunc_called(this, "_ZN6S633C12v1Ev");}
void  S633C1 ::v2(){vfunc_called(this, "_ZN6S633C12v2Ev");}
void  S633C1 ::v3(){vfunc_called(this, "_ZN6S633C12v3Ev");}
void  S633C1 ::v4(){vfunc_called(this, "_ZN6S633C12v4Ev");}
S633C1 ::S633C1(){ note_ctor("S633C1", this);} // tgen

static void Test_S633C1()
{
  extern Class_Descriptor cd_S633C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(45,68)];
    init_test(&cd_S633C1, buf);
    S633C1 *dp, &lv = *(dp=new (buf) S633C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,268), "sizeof(S633C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S633C1)");
    check_base_class_offset(lv, (S633C5*)(S633C4_nt*)(S633C3_nt*)(S633C2_nt*), 0, "S633C1");
    check_base_class_offset(lv, (S633C4_nt*)(S633C3_nt*)(S633C2_nt*), 0, "S633C1");
    check_base_class_offset(lv, (S633C3_nt*)(S633C2_nt*), 0, "S633C1");
    check_base_class_offset(lv, (S633C2_nt*), 0, "S633C1");
    set_bf_and_test(lv, s633c1f0, ABISELECT(296,220), 0, 1, 1, "S633C1");
    set_bf_and_test(lv, s633c1f1, ABISELECT(296,220), 1, 1, 1, "S633C1");
    check_field_offset(lv, s633c1f2, ABISELECT(300,224), "S633C1.s633c1f2");
    check_field_offset(lv, s633c1f3, ABISELECT(312,236), "S633C1.s633c1f3");
    check_field_offset(lv, s633c1f4, ABISELECT(324,248), "S633C1.s633c1f4");
    check_field_offset(lv, s633c1f5, ABISELECT(336,260), "S633C1.s633c1f5");
    check_field_offset(lv, s633c1f6, ABISELECT(344,264), "S633C1.s633c1f6");
    test_class_info(&lv, &cd_S633C1);
    dp->~S633C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS633C1(Test_S633C1, "S633C1", ABISELECT(352,268));

#else // __cplusplus

extern void _ZN6S633C1C1Ev();
extern void _ZN6S633C1D1Ev();
Name_Map name_map_S633C1[] = {
  NSPAIR(_ZN6S633C1C1Ev),
  NSPAIR(_ZN6S633C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S633C5;
extern VTBL_ENTRY _ZTI6S633C5[];
extern  VTBL_ENTRY _ZTV6S633C5[];
extern Class_Descriptor cd_S633C4_nt;
extern VTBL_ENTRY _ZTI9S633C4_nt[];
extern  VTBL_ENTRY _ZTV9S633C4_nt[];
extern Class_Descriptor cd_S633C3_nt;
extern VTBL_ENTRY _ZTI9S633C3_nt[];
extern  VTBL_ENTRY _ZTV9S633C3_nt[];
extern Class_Descriptor cd_S633C2_nt;
extern VTBL_ENTRY _ZTI9S633C2_nt[];
extern  VTBL_ENTRY _ZTV9S633C2_nt[];
static Base_Class bases_S633C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S633C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S633C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S633C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S633C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S633C1[];
extern void _ZN6S633C1D1Ev();
extern void _ZN6S633C1D0Ev();
extern void _ZN6S633C52v5Ev();
extern void _ZN6S633C52v6Ev();
extern void _ZN6S633C52v7Ev();
extern void _ZN6S633C52v8Ev();
extern void _ZN6S633C52v9Ev();
extern void _ZN6S633C53v10Ev();
extern void _ZN6S633C53v11Ev();
extern void _ZN6S633C53v12Ev();
extern void _ZN6S633C53v13Ev();
extern void _ZN6S633C53v14Ev();
extern void _ZN6S633C53v15Ev();
extern void _ZN6S633C53v16Ev();
extern void _ZN6S633C53v17Ev();
extern void _ZN6S633C53v18Ev();
extern void _ZN6S633C53v19Ev();
extern void _ZN6S633C53v20Ev();
extern void _ZN6S633C53v21Ev();
extern void _ZN6S633C53v22Ev();
extern void _ZN6S633C53v23Ev();
extern void _ZN6S633C53v24Ev();
extern void _ZN6S633C53v25Ev();
extern void _ZN6S633C53v26Ev();
extern void _ZN6S633C53v27Ev();
extern void _ZN6S633C53v28Ev();
extern void _ZN6S633C53v29Ev();
extern void _ZN6S633C53v30Ev();
extern void _ZN6S633C53v31Ev();
extern void _ZN6S633C53v32Ev();
extern void _ZN6S633C53v33Ev();
extern void _ZN6S633C53v34Ev();
extern void _ZN6S633C53v35Ev();
extern void _ZN6S633C53v36Ev();
extern void _ZN6S633C53v37Ev();
extern void _ZN6S633C53v38Ev();
extern void _ZN6S633C53v39Ev();
extern void _ZN6S633C53v40Ev();
extern void _ZN6S633C53v41Ev();
extern void _ZN6S633C53v42Ev();
extern void _ZN6S633C53v43Ev();
extern void _ZN6S633C53v44Ev();
extern void _ZN6S633C53v45Ev();
extern void _ZN6S633C53v46Ev();
extern void _ZN6S633C53v47Ev();
extern void _ZN6S633C53v48Ev();
extern void _ZN6S633C53v49Ev();
extern void _ZN6S633C53v50Ev();
extern void _ZN6S633C53v51Ev();
extern void _ZN6S633C53v52Ev();
extern void _ZN6S633C53v53Ev();
extern void _ZN6S633C53v54Ev();
extern void _ZN6S633C53v55Ev();
extern void _ZN6S633C53v56Ev();
extern void _ZN6S633C53v57Ev();
extern void _ZN6S633C53v58Ev();
extern void _ZN6S633C53v59Ev();
extern void _ZN6S633C53v60Ev();
extern void _ZN6S633C53v61Ev();
extern void _ZN6S633C53v62Ev();
extern void _ZN6S633C53v63Ev();
extern void _ZN6S633C53v64Ev();
extern void _ZN6S633C53v65Ev();
extern void _ZN6S633C53v66Ev();
extern void _ZN6S633C53v67Ev();
extern void _ZN6S633C53v68Ev();
extern void _ZN9S633C4_nt3v69Ev();
extern void _ZN9S633C4_nt3v70Ev();
extern void _ZN9S633C4_nt3v71Ev();
extern void _ZN9S633C4_nt3v72Ev();
extern void _ZN9S633C4_nt3v73Ev();
extern void _ZN9S633C4_nt3v74Ev();
extern void _ZN9S633C4_nt3v75Ev();
extern void _ZN9S633C4_nt3v76Ev();
extern void _ZN9S633C4_nt3v77Ev();
extern void _ZN9S633C4_nt3v78Ev();
extern void _ZN9S633C4_nt3v79Ev();
extern void _ZN9S633C4_nt3v80Ev();
extern void _ZN9S633C4_nt3v81Ev();
extern void _ZN9S633C4_nt3v82Ev();
extern void _ZN9S633C4_nt3v83Ev();
extern void _ZN9S633C4_nt3v84Ev();
extern void _ZN9S633C4_nt3v85Ev();
extern void _ZN9S633C4_nt3v86Ev();
extern void _ZN9S633C4_nt3v87Ev();
extern void _ZN9S633C4_nt3v88Ev();
extern void _ZN9S633C4_nt3v89Ev();
extern void _ZN9S633C4_nt3v90Ev();
extern void _ZN9S633C3_nt3v91Ev();
extern void _ZN9S633C3_nt3v92Ev();
extern void _ZN9S633C3_nt3v93Ev();
extern void _ZN9S633C3_nt3v94Ev();
extern void _ZN9S633C3_nt3v95Ev();
extern void _ZN9S633C3_nt3v96Ev();
extern void _ZN9S633C3_nt3v97Ev();
extern void _ZN9S633C3_nt3v98Ev();
extern void _ZN9S633C3_nt3v99Ev();
extern void _ZN9S633C3_nt4v100Ev();
extern void _ZN9S633C3_nt4v101Ev();
extern void _ZN9S633C3_nt4v102Ev();
extern void _ZN9S633C3_nt4v103Ev();
extern void _ZN9S633C3_nt4v104Ev();
extern void _ZN9S633C3_nt4v105Ev();
extern void _ZN9S633C3_nt4v106Ev();
extern void _ZN9S633C3_nt4v107Ev();
extern void _ZN9S633C3_nt4v108Ev();
extern void _ZN9S633C3_nt4v109Ev();
extern void _ZN9S633C3_nt4v110Ev();
extern void _ZN9S633C2_nt4v111Ev();
extern void _ZN9S633C2_nt4v112Ev();
extern void _ZN9S633C2_nt4v113Ev();
extern void _ZN9S633C2_nt4v114Ev();
extern void _ZN6S633C12v1Ev();
extern void _ZN6S633C12v2Ev();
extern void _ZN6S633C12v3Ev();
extern void _ZN6S633C12v4Ev();
static  VTBL_ENTRY vtc_S633C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S633C1[0]),
  (VTBL_ENTRY)&_ZN6S633C1D1Ev,
  (VTBL_ENTRY)&_ZN6S633C1D0Ev,
  (VTBL_ENTRY)&_ZN6S633C52v5Ev,
  (VTBL_ENTRY)&_ZN6S633C52v6Ev,
  (VTBL_ENTRY)&_ZN6S633C52v7Ev,
  (VTBL_ENTRY)&_ZN6S633C52v8Ev,
  (VTBL_ENTRY)&_ZN6S633C52v9Ev,
  (VTBL_ENTRY)&_ZN6S633C53v10Ev,
  (VTBL_ENTRY)&_ZN6S633C53v11Ev,
  (VTBL_ENTRY)&_ZN6S633C53v12Ev,
  (VTBL_ENTRY)&_ZN6S633C53v13Ev,
  (VTBL_ENTRY)&_ZN6S633C53v14Ev,
  (VTBL_ENTRY)&_ZN6S633C53v15Ev,
  (VTBL_ENTRY)&_ZN6S633C53v16Ev,
  (VTBL_ENTRY)&_ZN6S633C53v17Ev,
  (VTBL_ENTRY)&_ZN6S633C53v18Ev,
  (VTBL_ENTRY)&_ZN6S633C53v19Ev,
  (VTBL_ENTRY)&_ZN6S633C53v20Ev,
  (VTBL_ENTRY)&_ZN6S633C53v21Ev,
  (VTBL_ENTRY)&_ZN6S633C53v22Ev,
  (VTBL_ENTRY)&_ZN6S633C53v23Ev,
  (VTBL_ENTRY)&_ZN6S633C53v24Ev,
  (VTBL_ENTRY)&_ZN6S633C53v25Ev,
  (VTBL_ENTRY)&_ZN6S633C53v26Ev,
  (VTBL_ENTRY)&_ZN6S633C53v27Ev,
  (VTBL_ENTRY)&_ZN6S633C53v28Ev,
  (VTBL_ENTRY)&_ZN6S633C53v29Ev,
  (VTBL_ENTRY)&_ZN6S633C53v30Ev,
  (VTBL_ENTRY)&_ZN6S633C53v31Ev,
  (VTBL_ENTRY)&_ZN6S633C53v32Ev,
  (VTBL_ENTRY)&_ZN6S633C53v33Ev,
  (VTBL_ENTRY)&_ZN6S633C53v34Ev,
  (VTBL_ENTRY)&_ZN6S633C53v35Ev,
  (VTBL_ENTRY)&_ZN6S633C53v36Ev,
  (VTBL_ENTRY)&_ZN6S633C53v37Ev,
  (VTBL_ENTRY)&_ZN6S633C53v38Ev,
  (VTBL_ENTRY)&_ZN6S633C53v39Ev,
  (VTBL_ENTRY)&_ZN6S633C53v40Ev,
  (VTBL_ENTRY)&_ZN6S633C53v41Ev,
  (VTBL_ENTRY)&_ZN6S633C53v42Ev,
  (VTBL_ENTRY)&_ZN6S633C53v43Ev,
  (VTBL_ENTRY)&_ZN6S633C53v44Ev,
  (VTBL_ENTRY)&_ZN6S633C53v45Ev,
  (VTBL_ENTRY)&_ZN6S633C53v46Ev,
  (VTBL_ENTRY)&_ZN6S633C53v47Ev,
  (VTBL_ENTRY)&_ZN6S633C53v48Ev,
  (VTBL_ENTRY)&_ZN6S633C53v49Ev,
  (VTBL_ENTRY)&_ZN6S633C53v50Ev,
  (VTBL_ENTRY)&_ZN6S633C53v51Ev,
  (VTBL_ENTRY)&_ZN6S633C53v52Ev,
  (VTBL_ENTRY)&_ZN6S633C53v53Ev,
  (VTBL_ENTRY)&_ZN6S633C53v54Ev,
  (VTBL_ENTRY)&_ZN6S633C53v55Ev,
  (VTBL_ENTRY)&_ZN6S633C53v56Ev,
  (VTBL_ENTRY)&_ZN6S633C53v57Ev,
  (VTBL_ENTRY)&_ZN6S633C53v58Ev,
  (VTBL_ENTRY)&_ZN6S633C53v59Ev,
  (VTBL_ENTRY)&_ZN6S633C53v60Ev,
  (VTBL_ENTRY)&_ZN6S633C53v61Ev,
  (VTBL_ENTRY)&_ZN6S633C53v62Ev,
  (VTBL_ENTRY)&_ZN6S633C53v63Ev,
  (VTBL_ENTRY)&_ZN6S633C53v64Ev,
  (VTBL_ENTRY)&_ZN6S633C53v65Ev,
  (VTBL_ENTRY)&_ZN6S633C53v66Ev,
  (VTBL_ENTRY)&_ZN6S633C53v67Ev,
  (VTBL_ENTRY)&_ZN6S633C53v68Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S633C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S633C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S633C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN6S633C12v1Ev,
  (VTBL_ENTRY)&_ZN6S633C12v2Ev,
  (VTBL_ENTRY)&_ZN6S633C12v3Ev,
  (VTBL_ENTRY)&_ZN6S633C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S633C1[];
extern  VTBL_ENTRY _ZTV6S633C1[];
Class_Descriptor cd_S633C1 = {  "S633C1", // class name
  bases_S633C1, 4,
  &(vtc_S633C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(352,268), // object size
  NSPAIRA(_ZTI6S633C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S633C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C3  {
  virtual  ~S4291C3(); // _ZN7S4291C3D1Ev
  virtual void  v17(); // _ZN7S4291C33v17Ev
  virtual void  v18(); // _ZN7S4291C33v18Ev
  virtual void  v19(); // _ZN7S4291C33v19Ev
  virtual void  v20(); // _ZN7S4291C33v20Ev
  virtual void  v21(); // _ZN7S4291C33v21Ev
  virtual void  v22(); // _ZN7S4291C33v22Ev
  virtual void  v23(); // _ZN7S4291C33v23Ev
  virtual void  v24(); // _ZN7S4291C33v24Ev
  virtual void  v25(); // _ZN7S4291C33v25Ev
  virtual void  v26(); // _ZN7S4291C33v26Ev
  virtual void  v27(); // _ZN7S4291C33v27Ev
  virtual void  v28(); // _ZN7S4291C33v28Ev
  virtual void  v29(); // _ZN7S4291C33v29Ev
  virtual void  v30(); // _ZN7S4291C33v30Ev
  virtual void  v31(); // _ZN7S4291C33v31Ev
  virtual void  v32(); // _ZN7S4291C33v32Ev
  virtual void  v33(); // _ZN7S4291C33v33Ev
  virtual void  v34(); // _ZN7S4291C33v34Ev
  virtual void  v35(); // _ZN7S4291C33v35Ev
  virtual void  v36(); // _ZN7S4291C33v36Ev
  virtual void  v37(); // _ZN7S4291C33v37Ev
  virtual void  v38(); // _ZN7S4291C33v38Ev
  virtual void  v39(); // _ZN7S4291C33v39Ev
  virtual void  v40(); // _ZN7S4291C33v40Ev
  virtual void  v41(); // _ZN7S4291C33v41Ev
  S4291C3(); // tgen
};
//SIG(-1 S4291C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25}


 S4291C3 ::~S4291C3(){ note_dtor("S4291C3", this);}
void  S4291C3 ::v17(){vfunc_called(this, "_ZN7S4291C33v17Ev");}
void  S4291C3 ::v18(){vfunc_called(this, "_ZN7S4291C33v18Ev");}
void  S4291C3 ::v19(){vfunc_called(this, "_ZN7S4291C33v19Ev");}
void  S4291C3 ::v20(){vfunc_called(this, "_ZN7S4291C33v20Ev");}
void  S4291C3 ::v21(){vfunc_called(this, "_ZN7S4291C33v21Ev");}
void  S4291C3 ::v22(){vfunc_called(this, "_ZN7S4291C33v22Ev");}
void  S4291C3 ::v23(){vfunc_called(this, "_ZN7S4291C33v23Ev");}
void  S4291C3 ::v24(){vfunc_called(this, "_ZN7S4291C33v24Ev");}
void  S4291C3 ::v25(){vfunc_called(this, "_ZN7S4291C33v25Ev");}
void  S4291C3 ::v26(){vfunc_called(this, "_ZN7S4291C33v26Ev");}
void  S4291C3 ::v27(){vfunc_called(this, "_ZN7S4291C33v27Ev");}
void  S4291C3 ::v28(){vfunc_called(this, "_ZN7S4291C33v28Ev");}
void  S4291C3 ::v29(){vfunc_called(this, "_ZN7S4291C33v29Ev");}
void  S4291C3 ::v30(){vfunc_called(this, "_ZN7S4291C33v30Ev");}
void  S4291C3 ::v31(){vfunc_called(this, "_ZN7S4291C33v31Ev");}
void  S4291C3 ::v32(){vfunc_called(this, "_ZN7S4291C33v32Ev");}
void  S4291C3 ::v33(){vfunc_called(this, "_ZN7S4291C33v33Ev");}
void  S4291C3 ::v34(){vfunc_called(this, "_ZN7S4291C33v34Ev");}
void  S4291C3 ::v35(){vfunc_called(this, "_ZN7S4291C33v35Ev");}
void  S4291C3 ::v36(){vfunc_called(this, "_ZN7S4291C33v36Ev");}
void  S4291C3 ::v37(){vfunc_called(this, "_ZN7S4291C33v37Ev");}
void  S4291C3 ::v38(){vfunc_called(this, "_ZN7S4291C33v38Ev");}
void  S4291C3 ::v39(){vfunc_called(this, "_ZN7S4291C33v39Ev");}
void  S4291C3 ::v40(){vfunc_called(this, "_ZN7S4291C33v40Ev");}
void  S4291C3 ::v41(){vfunc_called(this, "_ZN7S4291C33v41Ev");}
S4291C3 ::S4291C3(){ note_ctor("S4291C3", this);} // tgen

static void Test_S4291C3()
{
  extern Class_Descriptor cd_S4291C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4291C3, buf);
    S4291C3 *dp, &lv = *(dp=new (buf) S4291C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4291C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C3)");
    test_class_info(&lv, &cd_S4291C3);
    dp->~S4291C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C3(Test_S4291C3, "S4291C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4291C3C1Ev();
extern void _ZN7S4291C3D1Ev();
Name_Map name_map_S4291C3[] = {
  NSPAIR(_ZN7S4291C3C1Ev),
  NSPAIR(_ZN7S4291C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4291C3[];
extern void _ZN7S4291C3D1Ev();
extern void _ZN7S4291C3D0Ev();
extern void _ZN7S4291C33v17Ev();
extern void _ZN7S4291C33v18Ev();
extern void _ZN7S4291C33v19Ev();
extern void _ZN7S4291C33v20Ev();
extern void _ZN7S4291C33v21Ev();
extern void _ZN7S4291C33v22Ev();
extern void _ZN7S4291C33v23Ev();
extern void _ZN7S4291C33v24Ev();
extern void _ZN7S4291C33v25Ev();
extern void _ZN7S4291C33v26Ev();
extern void _ZN7S4291C33v27Ev();
extern void _ZN7S4291C33v28Ev();
extern void _ZN7S4291C33v29Ev();
extern void _ZN7S4291C33v30Ev();
extern void _ZN7S4291C33v31Ev();
extern void _ZN7S4291C33v32Ev();
extern void _ZN7S4291C33v33Ev();
extern void _ZN7S4291C33v34Ev();
extern void _ZN7S4291C33v35Ev();
extern void _ZN7S4291C33v36Ev();
extern void _ZN7S4291C33v37Ev();
extern void _ZN7S4291C33v38Ev();
extern void _ZN7S4291C33v39Ev();
extern void _ZN7S4291C33v40Ev();
extern void _ZN7S4291C33v41Ev();
static  VTBL_ENTRY vtc_S4291C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C3[0]),
  (VTBL_ENTRY)&_ZN7S4291C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v41Ev,
};
extern VTBL_ENTRY _ZTI7S4291C3[];
extern  VTBL_ENTRY _ZTV7S4291C3[];
Class_Descriptor cd_S4291C3 = {  "S4291C3", // class name
  0,0,//no base classes
  &(vtc_S4291C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4291C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4291C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C5  {
  virtual  ~S4291C5(); // _ZN7S4291C5D1Ev
  virtual void  v42(); // _ZN7S4291C53v42Ev
  S4291C5(); // tgen
};
//SIG(-1 S4291C5) C1{ vd v1}


 S4291C5 ::~S4291C5(){ note_dtor("S4291C5", this);}
void  S4291C5 ::v42(){vfunc_called(this, "_ZN7S4291C53v42Ev");}
S4291C5 ::S4291C5(){ note_ctor("S4291C5", this);} // tgen

static void Test_S4291C5()
{
  extern Class_Descriptor cd_S4291C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4291C5, buf);
    S4291C5 *dp, &lv = *(dp=new (buf) S4291C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4291C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C5)");
    test_class_info(&lv, &cd_S4291C5);
    dp->~S4291C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C5(Test_S4291C5, "S4291C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4291C5C1Ev();
extern void _ZN7S4291C5D1Ev();
Name_Map name_map_S4291C5[] = {
  NSPAIR(_ZN7S4291C5C1Ev),
  NSPAIR(_ZN7S4291C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4291C5[];
extern void _ZN7S4291C5D1Ev();
extern void _ZN7S4291C5D0Ev();
extern void _ZN7S4291C53v42Ev();
static  VTBL_ENTRY vtc_S4291C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C5[0]),
  (VTBL_ENTRY)&_ZN7S4291C5D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C5D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C53v42Ev,
};
extern VTBL_ENTRY _ZTI7S4291C5[];
extern  VTBL_ENTRY _ZTV7S4291C5[];
Class_Descriptor cd_S4291C5 = {  "S4291C5", // class name
  0,0,//no base classes
  &(vtc_S4291C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4291C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4291C5),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C6  {
  virtual  ~S4291C6(); // _ZN7S4291C6D1Ev
  virtual void  v43(); // _ZN7S4291C63v43Ev
  S4291C6(); // tgen
};
//SIG(-1 S4291C6) C1{ vd v1}


 S4291C6 ::~S4291C6(){ note_dtor("S4291C6", this);}
void  S4291C6 ::v43(){vfunc_called(this, "_ZN7S4291C63v43Ev");}
S4291C6 ::S4291C6(){ note_ctor("S4291C6", this);} // tgen

static void Test_S4291C6()
{
  extern Class_Descriptor cd_S4291C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4291C6, buf);
    S4291C6 *dp, &lv = *(dp=new (buf) S4291C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4291C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C6)");
    test_class_info(&lv, &cd_S4291C6);
    dp->~S4291C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C6(Test_S4291C6, "S4291C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4291C6C1Ev();
extern void _ZN7S4291C6D1Ev();
Name_Map name_map_S4291C6[] = {
  NSPAIR(_ZN7S4291C6C1Ev),
  NSPAIR(_ZN7S4291C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4291C6[];
extern void _ZN7S4291C6D1Ev();
extern void _ZN7S4291C6D0Ev();
extern void _ZN7S4291C63v43Ev();
static  VTBL_ENTRY vtc_S4291C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C6[0]),
  (VTBL_ENTRY)&_ZN7S4291C6D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C6D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C63v43Ev,
};
extern VTBL_ENTRY _ZTI7S4291C6[];
extern  VTBL_ENTRY _ZTV7S4291C6[];
Class_Descriptor cd_S4291C6 = {  "S4291C6", // class name
  0,0,//no base classes
  &(vtc_S4291C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4291C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4291C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C7  {
  void *s4291c7f0;
  virtual  ~S4291C7(); // _ZN7S4291C7D1Ev
  virtual void  v44(); // _ZN7S4291C73v44Ev
  virtual void  v45(); // _ZN7S4291C73v45Ev
  virtual void  v46(); // _ZN7S4291C73v46Ev
  S4291C7(); // tgen
};
//SIG(-1 S4291C7) C1{ vd v1 v2 v3 Fp}


 S4291C7 ::~S4291C7(){ note_dtor("S4291C7", this);}
void  S4291C7 ::v44(){vfunc_called(this, "_ZN7S4291C73v44Ev");}
void  S4291C7 ::v45(){vfunc_called(this, "_ZN7S4291C73v45Ev");}
void  S4291C7 ::v46(){vfunc_called(this, "_ZN7S4291C73v46Ev");}
S4291C7 ::S4291C7(){ note_ctor("S4291C7", this);} // tgen

static void Test_S4291C7()
{
  extern Class_Descriptor cd_S4291C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4291C7, buf);
    S4291C7 *dp, &lv = *(dp=new (buf) S4291C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4291C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C7)");
    check_field_offset(lv, s4291c7f0, ABISELECT(8,4), "S4291C7.s4291c7f0");
    test_class_info(&lv, &cd_S4291C7);
    dp->~S4291C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C7(Test_S4291C7, "S4291C7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S4291C7C1Ev();
extern void _ZN7S4291C7D1Ev();
Name_Map name_map_S4291C7[] = {
  NSPAIR(_ZN7S4291C7C1Ev),
  NSPAIR(_ZN7S4291C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4291C7[];
extern void _ZN7S4291C7D1Ev();
extern void _ZN7S4291C7D0Ev();
extern void _ZN7S4291C73v44Ev();
extern void _ZN7S4291C73v45Ev();
extern void _ZN7S4291C73v46Ev();
static  VTBL_ENTRY vtc_S4291C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C7[0]),
  (VTBL_ENTRY)&_ZN7S4291C7D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C7D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4291C7[];
extern  VTBL_ENTRY _ZTV7S4291C7[];
Class_Descriptor cd_S4291C7 = {  "S4291C7", // class name
  0,0,//no base classes
  &(vtc_S4291C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S4291C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4291C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C4  : S4291C5 , S4291C6 , S4291C7 {
  virtual  ~S4291C4(); // _ZN7S4291C4D1Ev
  virtual void  v47(); // _ZN7S4291C43v47Ev
  S4291C4(); // tgen
};
//SIG(-1 S4291C4) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S4291C4 ::~S4291C4(){ note_dtor("S4291C4", this);}
void  S4291C4 ::v47(){vfunc_called(this, "_ZN7S4291C43v47Ev");}
S4291C4 ::S4291C4(){ note_ctor("S4291C4", this);} // tgen

static void Test_S4291C4()
{
  extern Class_Descriptor cd_S4291C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S4291C4, buf);
    S4291C4 *dp, &lv = *(dp=new (buf) S4291C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S4291C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C4)");
    check_base_class_offset(lv, (S4291C5*), 0, "S4291C4");
    check_base_class_offset(lv, (S4291C6*), ABISELECT(8,4), "S4291C4");
    check_base_class_offset(lv, (S4291C7*), ABISELECT(16,8), "S4291C4");
    test_class_info(&lv, &cd_S4291C4);
    dp->~S4291C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C4(Test_S4291C4, "S4291C4", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN7S4291C4C1Ev();
extern void _ZN7S4291C4D1Ev();
Name_Map name_map_S4291C4[] = {
  NSPAIR(_ZN7S4291C4C1Ev),
  NSPAIR(_ZN7S4291C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4291C5;
extern VTBL_ENTRY _ZTI7S4291C5[];
extern  VTBL_ENTRY _ZTV7S4291C5[];
extern Class_Descriptor cd_S4291C6;
extern VTBL_ENTRY _ZTI7S4291C6[];
extern  VTBL_ENTRY _ZTV7S4291C6[];
extern Class_Descriptor cd_S4291C7;
extern VTBL_ENTRY _ZTI7S4291C7[];
extern  VTBL_ENTRY _ZTV7S4291C7[];
static Base_Class bases_S4291C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4291C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4291C6,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4291C7,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4291C4[];
extern void _ZN7S4291C4D1Ev();
extern void _ZN7S4291C4D0Ev();
extern void _ZN7S4291C53v42Ev();
extern void _ZN7S4291C43v47Ev();
extern void ABISELECT(_ZThn8_N7S4291C4D1Ev,_ZThn4_N7S4291C4D1Ev)();
extern void ABISELECT(_ZThn8_N7S4291C4D0Ev,_ZThn4_N7S4291C4D0Ev)();
extern void _ZN7S4291C63v43Ev();
extern void ABISELECT(_ZThn16_N7S4291C4D1Ev,_ZThn8_N7S4291C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S4291C4D0Ev,_ZThn8_N7S4291C4D0Ev)();
extern void _ZN7S4291C73v44Ev();
extern void _ZN7S4291C73v45Ev();
extern void _ZN7S4291C73v46Ev();
static  VTBL_ENTRY vtc_S4291C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C4[0]),
  (VTBL_ENTRY)&_ZN7S4291C4D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C4D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4291C43v47Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4291C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C4D1Ev,_ZThn4_N7S4291C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C4D0Ev,_ZThn4_N7S4291C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C63v43Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4291C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C4D1Ev,_ZThn8_N7S4291C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C4D0Ev,_ZThn8_N7S4291C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4291C4[];
extern  VTBL_ENTRY _ZTV7S4291C4[];
Class_Descriptor cd_S4291C4 = {  "S4291C4", // class name
  bases_S4291C4, 3,
  &(vtc_S4291C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S4291C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S4291C4),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C2  : S4291C3 , S4291C4 {
  ::S10248C23 s4291c2f0;
  ::S10248C25 s4291c2f1;
  int s4291c2f2[2];
  char s4291c2f3;
  short s4291c2f4[6];
  ::S10249C21 s4291c2f5;
  virtual  ~S4291C2(); // _ZN7S4291C2D1Ev
  virtual void  v48(); // _ZN7S4291C23v48Ev
  virtual void  v49(); // _ZN7S4291C23v49Ev
  virtual void  v50(); // _ZN7S4291C23v50Ev
  virtual void  v51(); // _ZN7S4291C23v51Ev
  virtual void  v52(); // _ZN7S4291C23v52Ev
  virtual void  v53(); // _ZN7S4291C23v53Ev
  virtual void  v54(); // _ZN7S4291C23v54Ev
  virtual void  v55(); // _ZN7S4291C23v55Ev
  virtual void  v56(); // _ZN7S4291C23v56Ev
  virtual void  v57(); // _ZN7S4291C23v57Ev
  virtual void  v58(); // _ZN7S4291C23v58Ev
  virtual void  v59(); // _ZN7S4291C23v59Ev
  virtual void  v60(); // _ZN7S4291C23v60Ev
  virtual void  v61(); // _ZN7S4291C23v61Ev
  S4291C2(); // tgen
};
//SIG(-1 S4291C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39} BC3{ BC4{ vd v40} BC5{ vd v41} BC6{ vd v42 v43 v44 Fp} vd v45} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC7{ BC8{ vd v47} vd v46 Fp} FC9{ vd v48 v49 v50 Fc Fi FC10{ m Fi} FC11{ m FC12{ Fi Fp} Fi} Fp FC13{ m Fp[2] Fi} FC13 Fp[2] Fi Fp FC14{ BC15{ vd v57 v58 v59 v60 v61 v62 v63 Fi Fp Fi FC16{ Fc[2] Fs FC17{ Fi} Fs Fc[6]} Fi[3] FC18{ m Fi Fp[3]}} vd v51 v52 v53 v54 v55 v56} Fc Fl FC19{ m Fl[2]} Fl FC19} Fi[2] Fc Fs[6] FC20{ Fi Fc[512]}}


 S4291C2 ::~S4291C2(){ note_dtor("S4291C2", this);}
void  S4291C2 ::v48(){vfunc_called(this, "_ZN7S4291C23v48Ev");}
void  S4291C2 ::v49(){vfunc_called(this, "_ZN7S4291C23v49Ev");}
void  S4291C2 ::v50(){vfunc_called(this, "_ZN7S4291C23v50Ev");}
void  S4291C2 ::v51(){vfunc_called(this, "_ZN7S4291C23v51Ev");}
void  S4291C2 ::v52(){vfunc_called(this, "_ZN7S4291C23v52Ev");}
void  S4291C2 ::v53(){vfunc_called(this, "_ZN7S4291C23v53Ev");}
void  S4291C2 ::v54(){vfunc_called(this, "_ZN7S4291C23v54Ev");}
void  S4291C2 ::v55(){vfunc_called(this, "_ZN7S4291C23v55Ev");}
void  S4291C2 ::v56(){vfunc_called(this, "_ZN7S4291C23v56Ev");}
void  S4291C2 ::v57(){vfunc_called(this, "_ZN7S4291C23v57Ev");}
void  S4291C2 ::v58(){vfunc_called(this, "_ZN7S4291C23v58Ev");}
void  S4291C2 ::v59(){vfunc_called(this, "_ZN7S4291C23v59Ev");}
void  S4291C2 ::v60(){vfunc_called(this, "_ZN7S4291C23v60Ev");}
void  S4291C2 ::v61(){vfunc_called(this, "_ZN7S4291C23v61Ev");}
S4291C2 ::S4291C2(){ note_ctor("S4291C2", this);} // tgen

static void Test_S4291C2()
{
  extern Class_Descriptor cd_S4291C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(111,183)];
    init_test(&cd_S4291C2, buf);
    S4291C2 *dp, &lv = *(dp=new (buf) S4291C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(880,728), "sizeof(S4291C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C2)");
    check_base_class_offset(lv, (S4291C3*), 0, "S4291C2");
    check_base_class_offset(lv, (S4291C5*)(S4291C4*), ABISELECT(8,4), "S4291C2");
    check_base_class_offset(lv, (S4291C6*)(S4291C4*), ABISELECT(16,8), "S4291C2");
    check_base_class_offset(lv, (S4291C7*)(S4291C4*), ABISELECT(24,12), "S4291C2");
    check_base_class_offset(lv, (S4291C4*), ABISELECT(8,4), "S4291C2");
    check_field_offset(lv, s4291c2f0, ABISELECT(40,20), "S4291C2.s4291c2f0");
    check_field_offset(lv, s4291c2f1, ABISELECT(56,28), "S4291C2.s4291c2f1");
    check_field_offset(lv, s4291c2f2, ABISELECT(336,188), "S4291C2.s4291c2f2");
    check_field_offset(lv, s4291c2f3, ABISELECT(344,196), "S4291C2.s4291c2f3");
    check_field_offset(lv, s4291c2f4, ABISELECT(346,198), "S4291C2.s4291c2f4");
    check_field_offset(lv, s4291c2f5, ABISELECT(360,212), "S4291C2.s4291c2f5");
    test_class_info(&lv, &cd_S4291C2);
    dp->~S4291C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C2(Test_S4291C2, "S4291C2", ABISELECT(880,728));

#else // __cplusplus

extern void _ZN7S4291C2C1Ev();
extern void _ZN7S4291C2D1Ev();
Name_Map name_map_S4291C2[] = {
  NSPAIR(_ZN7S4291C2C1Ev),
  NSPAIR(_ZN7S4291C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4291C3;
extern VTBL_ENTRY _ZTI7S4291C3[];
extern  VTBL_ENTRY _ZTV7S4291C3[];
extern Class_Descriptor cd_S4291C5;
extern VTBL_ENTRY _ZTI7S4291C5[];
extern  VTBL_ENTRY _ZTV7S4291C5[];
extern Class_Descriptor cd_S4291C6;
extern VTBL_ENTRY _ZTI7S4291C6[];
extern  VTBL_ENTRY _ZTV7S4291C6[];
extern Class_Descriptor cd_S4291C7;
extern VTBL_ENTRY _ZTI7S4291C7[];
extern  VTBL_ENTRY _ZTV7S4291C7[];
extern Class_Descriptor cd_S4291C4;
extern VTBL_ENTRY _ZTI7S4291C4[];
extern  VTBL_ENTRY _ZTV7S4291C4[];
static Base_Class bases_S4291C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4291C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4291C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C6,    ABISELECT(16,8), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C7,    ABISELECT(24,12), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C4,    ABISELECT(8,4), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4291C2[];
extern void _ZN7S4291C2D1Ev();
extern void _ZN7S4291C2D0Ev();
extern void _ZN7S4291C33v17Ev();
extern void _ZN7S4291C33v18Ev();
extern void _ZN7S4291C33v19Ev();
extern void _ZN7S4291C33v20Ev();
extern void _ZN7S4291C33v21Ev();
extern void _ZN7S4291C33v22Ev();
extern void _ZN7S4291C33v23Ev();
extern void _ZN7S4291C33v24Ev();
extern void _ZN7S4291C33v25Ev();
extern void _ZN7S4291C33v26Ev();
extern void _ZN7S4291C33v27Ev();
extern void _ZN7S4291C33v28Ev();
extern void _ZN7S4291C33v29Ev();
extern void _ZN7S4291C33v30Ev();
extern void _ZN7S4291C33v31Ev();
extern void _ZN7S4291C33v32Ev();
extern void _ZN7S4291C33v33Ev();
extern void _ZN7S4291C33v34Ev();
extern void _ZN7S4291C33v35Ev();
extern void _ZN7S4291C33v36Ev();
extern void _ZN7S4291C33v37Ev();
extern void _ZN7S4291C33v38Ev();
extern void _ZN7S4291C33v39Ev();
extern void _ZN7S4291C33v40Ev();
extern void _ZN7S4291C33v41Ev();
extern void _ZN7S4291C23v48Ev();
extern void _ZN7S4291C23v49Ev();
extern void _ZN7S4291C23v50Ev();
extern void _ZN7S4291C23v51Ev();
extern void _ZN7S4291C23v52Ev();
extern void _ZN7S4291C23v53Ev();
extern void _ZN7S4291C23v54Ev();
extern void _ZN7S4291C23v55Ev();
extern void _ZN7S4291C23v56Ev();
extern void _ZN7S4291C23v57Ev();
extern void _ZN7S4291C23v58Ev();
extern void _ZN7S4291C23v59Ev();
extern void _ZN7S4291C23v60Ev();
extern void _ZN7S4291C23v61Ev();
extern void ABISELECT(_ZThn8_N7S4291C2D1Ev,_ZThn4_N7S4291C2D1Ev)();
extern void ABISELECT(_ZThn8_N7S4291C2D0Ev,_ZThn4_N7S4291C2D0Ev)();
extern void _ZN7S4291C53v42Ev();
extern void _ZN7S4291C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4291C2D1Ev,_ZThn8_N7S4291C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S4291C2D0Ev,_ZThn8_N7S4291C2D0Ev)();
extern void _ZN7S4291C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4291C2D1Ev,_ZThn12_N7S4291C2D1Ev)();
extern void ABISELECT(_ZThn24_N7S4291C2D0Ev,_ZThn12_N7S4291C2D0Ev)();
extern void _ZN7S4291C73v44Ev();
extern void _ZN7S4291C73v45Ev();
extern void _ZN7S4291C73v46Ev();
static  VTBL_ENTRY vtc_S4291C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C2[0]),
  (VTBL_ENTRY)&_ZN7S4291C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v61Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4291C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C2D1Ev,_ZThn4_N7S4291C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C2D0Ev,_ZThn4_N7S4291C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4291C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4291C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C2D1Ev,_ZThn8_N7S4291C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C2D0Ev,_ZThn8_N7S4291C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4291C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4291C2D1Ev,_ZThn12_N7S4291C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4291C2D0Ev,_ZThn12_N7S4291C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4291C2[];
extern  VTBL_ENTRY _ZTV7S4291C2[];
Class_Descriptor cd_S4291C2 = {  "S4291C2", // class name
  bases_S4291C2, 5,
  &(vtc_S4291C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,728), // object size
  NSPAIRA(_ZTI7S4291C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4291C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C23_nt  {
  char s4291c23f0[16];
};
//SIG(-1 S4291C23_nt) C1{ Fc[16]}



//skip512 S4291C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C24  {
  char s4291c24f0[32];
};
//SIG(-1 S4291C24) C1{ Fc[32]}



static void Test_S4291C24()
{
  {
    init_simple_test("S4291C24");
    S4291C24 lv;
    check2(sizeof(lv), 32, "sizeof(S4291C24)");
    check2(__alignof__(lv), 1, "__alignof__(S4291C24)");
    check_field_offset(lv, s4291c24f0, 0, "S4291C24.s4291c24f0");
  }
}
static Arrange_To_Call_Me vS4291C24(Test_S4291C24, "S4291C24", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C26  {
  long s4291c26f0;
};
//SIG(-1 S4291C26) C1{ Fl}



static void Test_S4291C26()
{
  {
    init_simple_test("S4291C26");
    S4291C26 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4291C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C26)");
    check_field_offset(lv, s4291c26f0, 0, "S4291C26.s4291c26f0");
  }
}
static Arrange_To_Call_Me vS4291C26(Test_S4291C26, "S4291C26", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C27  {
  short s4291c27f0;
  char s4291c27f1[2];
  void *s4291c27f2;
  int s4291c27f3;
};
//SIG(-1 S4291C27) C1{ Fs Fc[2] Fp Fi}



static void Test_S4291C27()
{
  {
    init_simple_test("S4291C27");
    S4291C27 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S4291C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C27)");
    check_field_offset(lv, s4291c27f0, 0, "S4291C27.s4291c27f0");
    check_field_offset(lv, s4291c27f1, 2, "S4291C27.s4291c27f1");
    check_field_offset(lv, s4291c27f2, ABISELECT(8,4), "S4291C27.s4291c27f2");
    check_field_offset(lv, s4291c27f3, ABISELECT(16,8), "S4291C27.s4291c27f3");
  }
}
static Arrange_To_Call_Me vS4291C27(Test_S4291C27, "S4291C27", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C25  {
  ::S4291C26 s4291c25f0;
  short s4291c25f1;
  char s4291c25f2[2];
  ::S4291C27 s4291c25f3;
};
//SIG(1 S4291C25) C1{ FC2{ Fl} Fs Fc[2] FC3{ Fs Fc[2] Fp Fi}}



static void Test_S4291C25()
{
  {
    init_simple_test("S4291C25");
    S4291C25 lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S4291C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C25)");
    check_field_offset(lv, s4291c25f0, 0, "S4291C25.s4291c25f0");
    check_field_offset(lv, s4291c25f1, ABISELECT(8,4), "S4291C25.s4291c25f1");
    check_field_offset(lv, s4291c25f2, ABISELECT(10,6), "S4291C25.s4291c25f2");
    check_field_offset(lv, s4291c25f3, ABISELECT(16,8), "S4291C25.s4291c25f3");
  }
}
static Arrange_To_Call_Me vS4291C25(Test_S4291C25, "S4291C25", ABISELECT(40,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C28  {
  int s4291c28f0;
  char s4291c28f1[64];
};
//SIG(-1 S4291C28) C1{ Fi Fc[64]}



static void Test_S4291C28()
{
  {
    init_simple_test("S4291C28");
    S4291C28 lv;
    check2(sizeof(lv), 68, "sizeof(S4291C28)");
    check2(__alignof__(lv), 4, "__alignof__(S4291C28)");
    check_field_offset(lv, s4291c28f0, 0, "S4291C28.s4291c28f0");
    check_field_offset(lv, s4291c28f1, 4, "S4291C28.s4291c28f1");
  }
}
static Arrange_To_Call_Me vS4291C28(Test_S4291C28, "S4291C28", 68);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C22  {
  short s4291c22f0;
  int s4291c22f1;
  short s4291c22f2;
  ::S4291C23_nt s4291c22f3;
  long s4291c22f4;
  ::S4291C24 s4291c22f5;
  ::S4291C25 s4291c22f6[2];
  short s4291c22f7;
  ::S4291C28 s4291c22f8;
  void *s4291c22f9;
  int s4291c22f10;
};
//SIG(-1 S4291C22) C1{ Fs Fi Fs FC2{ Fc[16]} Fl FC3{ Fc[32]} FC4{ FC5{ Fl} Fs Fc[2] FC6{ Fs Fc[2] Fp Fi}}[2] Fs FC7{ Fi Fc[64]} Fp Fi}



static void Test_S4291C22()
{
  {
    init_simple_test("S4291C22");
    S4291C22 lv;
    check2(sizeof(lv), ABISELECT(240,184), "sizeof(S4291C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C22)");
    check_field_offset(lv, s4291c22f0, 0, "S4291C22.s4291c22f0");
    check_field_offset(lv, s4291c22f1, 4, "S4291C22.s4291c22f1");
    check_field_offset(lv, s4291c22f2, 8, "S4291C22.s4291c22f2");
    check_field_offset(lv, s4291c22f3, 10, "S4291C22.s4291c22f3");
    check_field_offset(lv, s4291c22f4, ABISELECT(32,28), "S4291C22.s4291c22f4");
    check_field_offset(lv, s4291c22f5, ABISELECT(40,32), "S4291C22.s4291c22f5");
    check_field_offset(lv, s4291c22f6, ABISELECT(72,64), "S4291C22.s4291c22f6");
    check_field_offset(lv, s4291c22f7, ABISELECT(152,104), "S4291C22.s4291c22f7");
    check_field_offset(lv, s4291c22f8, ABISELECT(156,108), "S4291C22.s4291c22f8");
    check_field_offset(lv, s4291c22f9, ABISELECT(224,176), "S4291C22.s4291c22f9");
    check_field_offset(lv, s4291c22f10, ABISELECT(232,180), "S4291C22.s4291c22f10");
  }
}
static Arrange_To_Call_Me vS4291C22(Test_S4291C22, "S4291C22", ABISELECT(240,184));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C29  {
  ::S10249C29 s4291c29f0;
  void  mf4291c29(); // _ZN8S4291C299mf4291c29Ev
};
//SIG(-1 S4291C29) C1{ m FC2{ m Fp[2] Fi}}


void  S4291C29 ::mf4291c29(){}

static void Test_S4291C29()
{
  {
    init_simple_test("S4291C29");
    S4291C29 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S4291C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C29)");
    check_field_offset(lv, s4291c29f0, 0, "S4291C29.s4291c29f0");
  }
}
static Arrange_To_Call_Me vS4291C29(Test_S4291C29, "S4291C29", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4291C1  : S4291C2 {
  ::S4291C22 s4291c1f0;
  void *s4291c1f1;
  ::S4291C29 s4291c1f2;
  void *s4291c1f3[64];
  virtual  ~S4291C1(); // _ZN7S4291C1D1Ev
  virtual void  v1(); // _ZN7S4291C12v1Ev
  virtual void  v2(); // _ZN7S4291C12v2Ev
  virtual void  v3(); // _ZN7S4291C12v3Ev
  virtual void  v4(); // _ZN7S4291C12v4Ev
  virtual void  v5(); // _ZN7S4291C12v5Ev
  virtual void  v6(); // _ZN7S4291C12v6Ev
  virtual void  v7(); // _ZN7S4291C12v7Ev
  virtual void  v8(); // _ZN7S4291C12v8Ev
  virtual void  v9(); // _ZN7S4291C12v9Ev
  virtual void  v10(); // _ZN7S4291C13v10Ev
  virtual void  v11(); // _ZN7S4291C13v11Ev
  virtual void  v12(); // _ZN7S4291C13v12Ev
  virtual void  v13(); // _ZN7S4291C13v13Ev
  virtual void  v14(); // _ZN7S4291C13v14Ev
  virtual void  v15(); // _ZN7S4291C13v15Ev
  virtual void  v16(); // _ZN7S4291C13v16Ev
  S4291C1(); // tgen
};
//SIG(1 S4291C1) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41} BC4{ BC5{ vd v42} BC6{ vd v43} BC7{ vd v44 v45 v46 Fp} vd v47} vd v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 FC8{ BC9{ vd v63} vd v62 Fp} FC10{ vd v64 v65 v66 Fc Fi FC11{ m Fi} FC12{ m FC13{ Fi Fp} Fi} Fp FC14{ m Fp[2] Fi} FC14 Fp[2] Fi Fp FC15{ BC16{ vd v73 v74 v75 v76 v77 v78 v79 Fi Fp Fi FC17{ Fc[2] Fs FC18{ Fi} Fs Fc[6]} Fi[3] FC19{ m Fi Fp[3]}} vd v67 v68 v69 v70 v71 v72} Fc Fl FC20{ m Fl[2]} Fl FC20} Fi[2] Fc Fs[6] FC21{ Fi Fc[512]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC22{ Fs Fi Fs FC23{ Fc[16]} Fl FC24{ Fc[32]} FC25{ FC26{ Fl} Fs Fc[2] FC27{ Fs Fc[2] Fp Fi}}[2] Fs FC28{ Fi Fc[64]} Fp Fi} Fp FC29{ m FC30{ m Fp[2] Fi}} Fp[64]}


 S4291C1 ::~S4291C1(){ note_dtor("S4291C1", this);}
void  S4291C1 ::v1(){vfunc_called(this, "_ZN7S4291C12v1Ev");}
void  S4291C1 ::v2(){vfunc_called(this, "_ZN7S4291C12v2Ev");}
void  S4291C1 ::v3(){vfunc_called(this, "_ZN7S4291C12v3Ev");}
void  S4291C1 ::v4(){vfunc_called(this, "_ZN7S4291C12v4Ev");}
void  S4291C1 ::v5(){vfunc_called(this, "_ZN7S4291C12v5Ev");}
void  S4291C1 ::v6(){vfunc_called(this, "_ZN7S4291C12v6Ev");}
void  S4291C1 ::v7(){vfunc_called(this, "_ZN7S4291C12v7Ev");}
void  S4291C1 ::v8(){vfunc_called(this, "_ZN7S4291C12v8Ev");}
void  S4291C1 ::v9(){vfunc_called(this, "_ZN7S4291C12v9Ev");}
void  S4291C1 ::v10(){vfunc_called(this, "_ZN7S4291C13v10Ev");}
void  S4291C1 ::v11(){vfunc_called(this, "_ZN7S4291C13v11Ev");}
void  S4291C1 ::v12(){vfunc_called(this, "_ZN7S4291C13v12Ev");}
void  S4291C1 ::v13(){vfunc_called(this, "_ZN7S4291C13v13Ev");}
void  S4291C1 ::v14(){vfunc_called(this, "_ZN7S4291C13v14Ev");}
void  S4291C1 ::v15(){vfunc_called(this, "_ZN7S4291C13v15Ev");}
void  S4291C1 ::v16(){vfunc_called(this, "_ZN7S4291C13v16Ev");}
S4291C1 ::S4291C1(){ note_ctor("S4291C1", this);} // tgen

static void Test_S4291C1()
{
  extern Class_Descriptor cd_S4291C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(209,297)];
    init_test(&cd_S4291C1, buf);
    S4291C1 *dp, &lv = *(dp=new (buf) S4291C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1664,1184), "sizeof(S4291C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4291C1)");
    check_base_class_offset(lv, (S4291C3*)(S4291C2*), 0, "S4291C1");
    check_base_class_offset(lv, (S4291C5*)(S4291C4*)(S4291C2*), ABISELECT(8,4), "S4291C1");
    check_base_class_offset(lv, (S4291C6*)(S4291C4*)(S4291C2*), ABISELECT(16,8), "S4291C1");
    check_base_class_offset(lv, (S4291C7*)(S4291C4*)(S4291C2*), ABISELECT(24,12), "S4291C1");
    check_base_class_offset(lv, (S4291C4*)(S4291C2*), ABISELECT(8,4), "S4291C1");
    check_base_class_offset(lv, (S4291C2*), 0, "S4291C1");
    check_field_offset(lv, s4291c1f0, ABISELECT(880,728), "S4291C1.s4291c1f0");
    check_field_offset(lv, s4291c1f1, ABISELECT(1120,912), "S4291C1.s4291c1f1");
    check_field_offset(lv, s4291c1f2, ABISELECT(1128,916), "S4291C1.s4291c1f2");
    check_field_offset(lv, s4291c1f3, ABISELECT(1152,928), "S4291C1.s4291c1f3");
    test_class_info(&lv, &cd_S4291C1);
    dp->~S4291C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4291C1(Test_S4291C1, "S4291C1", ABISELECT(1664,1184));

#else // __cplusplus

extern void _ZN7S4291C1C1Ev();
extern void _ZN7S4291C1D1Ev();
Name_Map name_map_S4291C1[] = {
  NSPAIR(_ZN7S4291C1C1Ev),
  NSPAIR(_ZN7S4291C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4291C3;
extern VTBL_ENTRY _ZTI7S4291C3[];
extern  VTBL_ENTRY _ZTV7S4291C3[];
extern Class_Descriptor cd_S4291C5;
extern VTBL_ENTRY _ZTI7S4291C5[];
extern  VTBL_ENTRY _ZTV7S4291C5[];
extern Class_Descriptor cd_S4291C6;
extern VTBL_ENTRY _ZTI7S4291C6[];
extern  VTBL_ENTRY _ZTV7S4291C6[];
extern Class_Descriptor cd_S4291C7;
extern VTBL_ENTRY _ZTI7S4291C7[];
extern  VTBL_ENTRY _ZTV7S4291C7[];
extern Class_Descriptor cd_S4291C4;
extern VTBL_ENTRY _ZTI7S4291C4[];
extern  VTBL_ENTRY _ZTV7S4291C4[];
extern Class_Descriptor cd_S4291C2;
extern VTBL_ENTRY _ZTI7S4291C2[];
extern  VTBL_ENTRY _ZTV7S4291C2[];
static Base_Class bases_S4291C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4291C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4291C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C6,    ABISELECT(16,8), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C7,    ABISELECT(24,12), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4291C4,    ABISELECT(8,4), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4291C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4291C1[];
extern void _ZN7S4291C1D1Ev();
extern void _ZN7S4291C1D0Ev();
extern void _ZN7S4291C33v17Ev();
extern void _ZN7S4291C33v18Ev();
extern void _ZN7S4291C33v19Ev();
extern void _ZN7S4291C33v20Ev();
extern void _ZN7S4291C33v21Ev();
extern void _ZN7S4291C33v22Ev();
extern void _ZN7S4291C33v23Ev();
extern void _ZN7S4291C33v24Ev();
extern void _ZN7S4291C33v25Ev();
extern void _ZN7S4291C33v26Ev();
extern void _ZN7S4291C33v27Ev();
extern void _ZN7S4291C33v28Ev();
extern void _ZN7S4291C33v29Ev();
extern void _ZN7S4291C33v30Ev();
extern void _ZN7S4291C33v31Ev();
extern void _ZN7S4291C33v32Ev();
extern void _ZN7S4291C33v33Ev();
extern void _ZN7S4291C33v34Ev();
extern void _ZN7S4291C33v35Ev();
extern void _ZN7S4291C33v36Ev();
extern void _ZN7S4291C33v37Ev();
extern void _ZN7S4291C33v38Ev();
extern void _ZN7S4291C33v39Ev();
extern void _ZN7S4291C33v40Ev();
extern void _ZN7S4291C33v41Ev();
extern void _ZN7S4291C23v48Ev();
extern void _ZN7S4291C23v49Ev();
extern void _ZN7S4291C23v50Ev();
extern void _ZN7S4291C23v51Ev();
extern void _ZN7S4291C23v52Ev();
extern void _ZN7S4291C23v53Ev();
extern void _ZN7S4291C23v54Ev();
extern void _ZN7S4291C23v55Ev();
extern void _ZN7S4291C23v56Ev();
extern void _ZN7S4291C23v57Ev();
extern void _ZN7S4291C23v58Ev();
extern void _ZN7S4291C23v59Ev();
extern void _ZN7S4291C23v60Ev();
extern void _ZN7S4291C23v61Ev();
extern void _ZN7S4291C12v1Ev();
extern void _ZN7S4291C12v2Ev();
extern void _ZN7S4291C12v3Ev();
extern void _ZN7S4291C12v4Ev();
extern void _ZN7S4291C12v5Ev();
extern void _ZN7S4291C12v6Ev();
extern void _ZN7S4291C12v7Ev();
extern void _ZN7S4291C12v8Ev();
extern void _ZN7S4291C12v9Ev();
extern void _ZN7S4291C13v10Ev();
extern void _ZN7S4291C13v11Ev();
extern void _ZN7S4291C13v12Ev();
extern void _ZN7S4291C13v13Ev();
extern void _ZN7S4291C13v14Ev();
extern void _ZN7S4291C13v15Ev();
extern void _ZN7S4291C13v16Ev();
extern void ABISELECT(_ZThn8_N7S4291C1D1Ev,_ZThn4_N7S4291C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S4291C1D0Ev,_ZThn4_N7S4291C1D0Ev)();
extern void _ZN7S4291C53v42Ev();
extern void _ZN7S4291C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4291C1D1Ev,_ZThn8_N7S4291C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S4291C1D0Ev,_ZThn8_N7S4291C1D0Ev)();
extern void _ZN7S4291C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4291C1D1Ev,_ZThn12_N7S4291C1D1Ev)();
extern void ABISELECT(_ZThn24_N7S4291C1D0Ev,_ZThn12_N7S4291C1D0Ev)();
extern void _ZN7S4291C73v44Ev();
extern void _ZN7S4291C73v45Ev();
extern void _ZN7S4291C73v46Ev();
static  VTBL_ENTRY vtc_S4291C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4291C1[0]),
  (VTBL_ENTRY)&_ZN7S4291C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4291C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4291C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4291C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4291C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4291C13v16Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4291C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C1D1Ev,_ZThn4_N7S4291C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4291C1D0Ev,_ZThn4_N7S4291C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4291C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4291C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C1D1Ev,_ZThn8_N7S4291C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4291C1D0Ev,_ZThn8_N7S4291C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4291C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4291C1D1Ev,_ZThn12_N7S4291C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4291C1D0Ev,_ZThn12_N7S4291C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4291C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4291C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4291C1[];
extern  VTBL_ENTRY _ZTV7S4291C1[];
Class_Descriptor cd_S4291C1 = {  "S4291C1", // class name
  bases_S4291C1, 6,
  &(vtc_S4291C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1664,1184), // object size
  NSPAIRA(_ZTI7S4291C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4291C1),77, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C3  {
  virtual  ~S4292C3(); // _ZN7S4292C3D1Ev
  virtual void  v17(); // _ZN7S4292C33v17Ev
  virtual void  v18(); // _ZN7S4292C33v18Ev
  virtual void  v19(); // _ZN7S4292C33v19Ev
  virtual void  v20(); // _ZN7S4292C33v20Ev
  virtual void  v21(); // _ZN7S4292C33v21Ev
  virtual void  v22(); // _ZN7S4292C33v22Ev
  virtual void  v23(); // _ZN7S4292C33v23Ev
  virtual void  v24(); // _ZN7S4292C33v24Ev
  virtual void  v25(); // _ZN7S4292C33v25Ev
  virtual void  v26(); // _ZN7S4292C33v26Ev
  virtual void  v27(); // _ZN7S4292C33v27Ev
  virtual void  v28(); // _ZN7S4292C33v28Ev
  virtual void  v29(); // _ZN7S4292C33v29Ev
  virtual void  v30(); // _ZN7S4292C33v30Ev
  virtual void  v31(); // _ZN7S4292C33v31Ev
  virtual void  v32(); // _ZN7S4292C33v32Ev
  virtual void  v33(); // _ZN7S4292C33v33Ev
  virtual void  v34(); // _ZN7S4292C33v34Ev
  virtual void  v35(); // _ZN7S4292C33v35Ev
  virtual void  v36(); // _ZN7S4292C33v36Ev
  virtual void  v37(); // _ZN7S4292C33v37Ev
  virtual void  v38(); // _ZN7S4292C33v38Ev
  virtual void  v39(); // _ZN7S4292C33v39Ev
  virtual void  v40(); // _ZN7S4292C33v40Ev
  virtual void  v41(); // _ZN7S4292C33v41Ev
  S4292C3(); // tgen
};
//SIG(-1 S4292C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25}


 S4292C3 ::~S4292C3(){ note_dtor("S4292C3", this);}
void  S4292C3 ::v17(){vfunc_called(this, "_ZN7S4292C33v17Ev");}
void  S4292C3 ::v18(){vfunc_called(this, "_ZN7S4292C33v18Ev");}
void  S4292C3 ::v19(){vfunc_called(this, "_ZN7S4292C33v19Ev");}
void  S4292C3 ::v20(){vfunc_called(this, "_ZN7S4292C33v20Ev");}
void  S4292C3 ::v21(){vfunc_called(this, "_ZN7S4292C33v21Ev");}
void  S4292C3 ::v22(){vfunc_called(this, "_ZN7S4292C33v22Ev");}
void  S4292C3 ::v23(){vfunc_called(this, "_ZN7S4292C33v23Ev");}
void  S4292C3 ::v24(){vfunc_called(this, "_ZN7S4292C33v24Ev");}
void  S4292C3 ::v25(){vfunc_called(this, "_ZN7S4292C33v25Ev");}
void  S4292C3 ::v26(){vfunc_called(this, "_ZN7S4292C33v26Ev");}
void  S4292C3 ::v27(){vfunc_called(this, "_ZN7S4292C33v27Ev");}
void  S4292C3 ::v28(){vfunc_called(this, "_ZN7S4292C33v28Ev");}
void  S4292C3 ::v29(){vfunc_called(this, "_ZN7S4292C33v29Ev");}
void  S4292C3 ::v30(){vfunc_called(this, "_ZN7S4292C33v30Ev");}
void  S4292C3 ::v31(){vfunc_called(this, "_ZN7S4292C33v31Ev");}
void  S4292C3 ::v32(){vfunc_called(this, "_ZN7S4292C33v32Ev");}
void  S4292C3 ::v33(){vfunc_called(this, "_ZN7S4292C33v33Ev");}
void  S4292C3 ::v34(){vfunc_called(this, "_ZN7S4292C33v34Ev");}
void  S4292C3 ::v35(){vfunc_called(this, "_ZN7S4292C33v35Ev");}
void  S4292C3 ::v36(){vfunc_called(this, "_ZN7S4292C33v36Ev");}
void  S4292C3 ::v37(){vfunc_called(this, "_ZN7S4292C33v37Ev");}
void  S4292C3 ::v38(){vfunc_called(this, "_ZN7S4292C33v38Ev");}
void  S4292C3 ::v39(){vfunc_called(this, "_ZN7S4292C33v39Ev");}
void  S4292C3 ::v40(){vfunc_called(this, "_ZN7S4292C33v40Ev");}
void  S4292C3 ::v41(){vfunc_called(this, "_ZN7S4292C33v41Ev");}
S4292C3 ::S4292C3(){ note_ctor("S4292C3", this);} // tgen

static void Test_S4292C3()
{
  extern Class_Descriptor cd_S4292C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4292C3, buf);
    S4292C3 *dp, &lv = *(dp=new (buf) S4292C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4292C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C3)");
    test_class_info(&lv, &cd_S4292C3);
    dp->~S4292C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C3(Test_S4292C3, "S4292C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4292C3C1Ev();
extern void _ZN7S4292C3D1Ev();
Name_Map name_map_S4292C3[] = {
  NSPAIR(_ZN7S4292C3C1Ev),
  NSPAIR(_ZN7S4292C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4292C3[];
extern void _ZN7S4292C3D1Ev();
extern void _ZN7S4292C3D0Ev();
extern void _ZN7S4292C33v17Ev();
extern void _ZN7S4292C33v18Ev();
extern void _ZN7S4292C33v19Ev();
extern void _ZN7S4292C33v20Ev();
extern void _ZN7S4292C33v21Ev();
extern void _ZN7S4292C33v22Ev();
extern void _ZN7S4292C33v23Ev();
extern void _ZN7S4292C33v24Ev();
extern void _ZN7S4292C33v25Ev();
extern void _ZN7S4292C33v26Ev();
extern void _ZN7S4292C33v27Ev();
extern void _ZN7S4292C33v28Ev();
extern void _ZN7S4292C33v29Ev();
extern void _ZN7S4292C33v30Ev();
extern void _ZN7S4292C33v31Ev();
extern void _ZN7S4292C33v32Ev();
extern void _ZN7S4292C33v33Ev();
extern void _ZN7S4292C33v34Ev();
extern void _ZN7S4292C33v35Ev();
extern void _ZN7S4292C33v36Ev();
extern void _ZN7S4292C33v37Ev();
extern void _ZN7S4292C33v38Ev();
extern void _ZN7S4292C33v39Ev();
extern void _ZN7S4292C33v40Ev();
extern void _ZN7S4292C33v41Ev();
static  VTBL_ENTRY vtc_S4292C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C3[0]),
  (VTBL_ENTRY)&_ZN7S4292C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v41Ev,
};
extern VTBL_ENTRY _ZTI7S4292C3[];
extern  VTBL_ENTRY _ZTV7S4292C3[];
Class_Descriptor cd_S4292C3 = {  "S4292C3", // class name
  0,0,//no base classes
  &(vtc_S4292C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4292C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4292C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C5  {
  virtual  ~S4292C5(); // _ZN7S4292C5D1Ev
  virtual void  v42(); // _ZN7S4292C53v42Ev
  S4292C5(); // tgen
};
//SIG(-1 S4292C5) C1{ vd v1}


 S4292C5 ::~S4292C5(){ note_dtor("S4292C5", this);}
void  S4292C5 ::v42(){vfunc_called(this, "_ZN7S4292C53v42Ev");}
S4292C5 ::S4292C5(){ note_ctor("S4292C5", this);} // tgen

static void Test_S4292C5()
{
  extern Class_Descriptor cd_S4292C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4292C5, buf);
    S4292C5 *dp, &lv = *(dp=new (buf) S4292C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4292C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C5)");
    test_class_info(&lv, &cd_S4292C5);
    dp->~S4292C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C5(Test_S4292C5, "S4292C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4292C5C1Ev();
extern void _ZN7S4292C5D1Ev();
Name_Map name_map_S4292C5[] = {
  NSPAIR(_ZN7S4292C5C1Ev),
  NSPAIR(_ZN7S4292C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4292C5[];
extern void _ZN7S4292C5D1Ev();
extern void _ZN7S4292C5D0Ev();
extern void _ZN7S4292C53v42Ev();
static  VTBL_ENTRY vtc_S4292C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C5[0]),
  (VTBL_ENTRY)&_ZN7S4292C5D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C5D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C53v42Ev,
};
extern VTBL_ENTRY _ZTI7S4292C5[];
extern  VTBL_ENTRY _ZTV7S4292C5[];
Class_Descriptor cd_S4292C5 = {  "S4292C5", // class name
  0,0,//no base classes
  &(vtc_S4292C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4292C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4292C5),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C6  {
  virtual  ~S4292C6(); // _ZN7S4292C6D1Ev
  virtual void  v43(); // _ZN7S4292C63v43Ev
  S4292C6(); // tgen
};
//SIG(-1 S4292C6) C1{ vd v1}


 S4292C6 ::~S4292C6(){ note_dtor("S4292C6", this);}
void  S4292C6 ::v43(){vfunc_called(this, "_ZN7S4292C63v43Ev");}
S4292C6 ::S4292C6(){ note_ctor("S4292C6", this);} // tgen

static void Test_S4292C6()
{
  extern Class_Descriptor cd_S4292C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4292C6, buf);
    S4292C6 *dp, &lv = *(dp=new (buf) S4292C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4292C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C6)");
    test_class_info(&lv, &cd_S4292C6);
    dp->~S4292C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C6(Test_S4292C6, "S4292C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4292C6C1Ev();
extern void _ZN7S4292C6D1Ev();
Name_Map name_map_S4292C6[] = {
  NSPAIR(_ZN7S4292C6C1Ev),
  NSPAIR(_ZN7S4292C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4292C6[];
extern void _ZN7S4292C6D1Ev();
extern void _ZN7S4292C6D0Ev();
extern void _ZN7S4292C63v43Ev();
static  VTBL_ENTRY vtc_S4292C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C6[0]),
  (VTBL_ENTRY)&_ZN7S4292C6D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C6D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C63v43Ev,
};
extern VTBL_ENTRY _ZTI7S4292C6[];
extern  VTBL_ENTRY _ZTV7S4292C6[];
Class_Descriptor cd_S4292C6 = {  "S4292C6", // class name
  0,0,//no base classes
  &(vtc_S4292C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4292C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4292C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C7  {
  void *s4292c7f0;
  virtual  ~S4292C7(); // _ZN7S4292C7D1Ev
  virtual void  v44(); // _ZN7S4292C73v44Ev
  virtual void  v45(); // _ZN7S4292C73v45Ev
  virtual void  v46(); // _ZN7S4292C73v46Ev
  S4292C7(); // tgen
};
//SIG(-1 S4292C7) C1{ vd v1 v2 v3 Fp}


 S4292C7 ::~S4292C7(){ note_dtor("S4292C7", this);}
void  S4292C7 ::v44(){vfunc_called(this, "_ZN7S4292C73v44Ev");}
void  S4292C7 ::v45(){vfunc_called(this, "_ZN7S4292C73v45Ev");}
void  S4292C7 ::v46(){vfunc_called(this, "_ZN7S4292C73v46Ev");}
S4292C7 ::S4292C7(){ note_ctor("S4292C7", this);} // tgen

static void Test_S4292C7()
{
  extern Class_Descriptor cd_S4292C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4292C7, buf);
    S4292C7 *dp, &lv = *(dp=new (buf) S4292C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4292C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C7)");
    check_field_offset(lv, s4292c7f0, ABISELECT(8,4), "S4292C7.s4292c7f0");
    test_class_info(&lv, &cd_S4292C7);
    dp->~S4292C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C7(Test_S4292C7, "S4292C7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S4292C7C1Ev();
extern void _ZN7S4292C7D1Ev();
Name_Map name_map_S4292C7[] = {
  NSPAIR(_ZN7S4292C7C1Ev),
  NSPAIR(_ZN7S4292C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4292C7[];
extern void _ZN7S4292C7D1Ev();
extern void _ZN7S4292C7D0Ev();
extern void _ZN7S4292C73v44Ev();
extern void _ZN7S4292C73v45Ev();
extern void _ZN7S4292C73v46Ev();
static  VTBL_ENTRY vtc_S4292C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C7[0]),
  (VTBL_ENTRY)&_ZN7S4292C7D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C7D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4292C7[];
extern  VTBL_ENTRY _ZTV7S4292C7[];
Class_Descriptor cd_S4292C7 = {  "S4292C7", // class name
  0,0,//no base classes
  &(vtc_S4292C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S4292C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4292C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C4  : S4292C5 , S4292C6 , S4292C7 {
  virtual  ~S4292C4(); // _ZN7S4292C4D1Ev
  virtual void  v47(); // _ZN7S4292C43v47Ev
  S4292C4(); // tgen
};
//SIG(-1 S4292C4) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S4292C4 ::~S4292C4(){ note_dtor("S4292C4", this);}
void  S4292C4 ::v47(){vfunc_called(this, "_ZN7S4292C43v47Ev");}
S4292C4 ::S4292C4(){ note_ctor("S4292C4", this);} // tgen

static void Test_S4292C4()
{
  extern Class_Descriptor cd_S4292C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S4292C4, buf);
    S4292C4 *dp, &lv = *(dp=new (buf) S4292C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S4292C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C4)");
    check_base_class_offset(lv, (S4292C5*), 0, "S4292C4");
    check_base_class_offset(lv, (S4292C6*), ABISELECT(8,4), "S4292C4");
    check_base_class_offset(lv, (S4292C7*), ABISELECT(16,8), "S4292C4");
    test_class_info(&lv, &cd_S4292C4);
    dp->~S4292C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C4(Test_S4292C4, "S4292C4", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN7S4292C4C1Ev();
extern void _ZN7S4292C4D1Ev();
Name_Map name_map_S4292C4[] = {
  NSPAIR(_ZN7S4292C4C1Ev),
  NSPAIR(_ZN7S4292C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4292C5;
extern VTBL_ENTRY _ZTI7S4292C5[];
extern  VTBL_ENTRY _ZTV7S4292C5[];
extern Class_Descriptor cd_S4292C6;
extern VTBL_ENTRY _ZTI7S4292C6[];
extern  VTBL_ENTRY _ZTV7S4292C6[];
extern Class_Descriptor cd_S4292C7;
extern VTBL_ENTRY _ZTI7S4292C7[];
extern  VTBL_ENTRY _ZTV7S4292C7[];
static Base_Class bases_S4292C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4292C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4292C6,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4292C7,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4292C4[];
extern void _ZN7S4292C4D1Ev();
extern void _ZN7S4292C4D0Ev();
extern void _ZN7S4292C53v42Ev();
extern void _ZN7S4292C43v47Ev();
extern void ABISELECT(_ZThn8_N7S4292C4D1Ev,_ZThn4_N7S4292C4D1Ev)();
extern void ABISELECT(_ZThn8_N7S4292C4D0Ev,_ZThn4_N7S4292C4D0Ev)();
extern void _ZN7S4292C63v43Ev();
extern void ABISELECT(_ZThn16_N7S4292C4D1Ev,_ZThn8_N7S4292C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S4292C4D0Ev,_ZThn8_N7S4292C4D0Ev)();
extern void _ZN7S4292C73v44Ev();
extern void _ZN7S4292C73v45Ev();
extern void _ZN7S4292C73v46Ev();
static  VTBL_ENTRY vtc_S4292C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C4[0]),
  (VTBL_ENTRY)&_ZN7S4292C4D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C4D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4292C43v47Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4292C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C4D1Ev,_ZThn4_N7S4292C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C4D0Ev,_ZThn4_N7S4292C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C63v43Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4292C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C4D1Ev,_ZThn8_N7S4292C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C4D0Ev,_ZThn8_N7S4292C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4292C4[];
extern  VTBL_ENTRY _ZTV7S4292C4[];
Class_Descriptor cd_S4292C4 = {  "S4292C4", // class name
  bases_S4292C4, 3,
  &(vtc_S4292C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S4292C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S4292C4),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C2  : S4292C3 , S4292C4 {
  ::S10248C23 s4292c2f0;
  ::S10249C25 s4292c2f1;
  int s4292c2f2[2];
  char s4292c2f3;
  short s4292c2f4[6];
  ::S10249C21 s4292c2f5;
  virtual  ~S4292C2(); // _ZN7S4292C2D1Ev
  virtual void  v48(); // _ZN7S4292C23v48Ev
  virtual void  v49(); // _ZN7S4292C23v49Ev
  virtual void  v50(); // _ZN7S4292C23v50Ev
  virtual void  v51(); // _ZN7S4292C23v51Ev
  virtual void  v52(); // _ZN7S4292C23v52Ev
  virtual void  v53(); // _ZN7S4292C23v53Ev
  virtual void  v54(); // _ZN7S4292C23v54Ev
  virtual void  v55(); // _ZN7S4292C23v55Ev
  virtual void  v56(); // _ZN7S4292C23v56Ev
  virtual void  v57(); // _ZN7S4292C23v57Ev
  virtual void  v58(); // _ZN7S4292C23v58Ev
  virtual void  v59(); // _ZN7S4292C23v59Ev
  virtual void  v60(); // _ZN7S4292C23v60Ev
  virtual void  v61(); // _ZN7S4292C23v61Ev
  S4292C2(); // tgen
};
//SIG(-1 S4292C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39} BC3{ BC4{ vd v40} BC5{ vd v41} BC6{ vd v42 v43 v44 Fp} vd v45} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC7{ BC8{ vd v47} vd v46 Fp} FC9{ vd v48 v49 v50 Fc Fi FC10{ m Fi} FC11{ m FC12{ Fi Fp} Fi} Fp FC13{ m Fp[2] Fi} FC13 Fp[2] Fi Fp FC14{ BC15{ vd v57 v58 v59 v60 v61 v62 v63 Fi Fp Fi FC16{ Fc[2] Fs FC17{ Fi} Fs Fc[6]} Fi[3] FC18{ m Fi Fp[3]}} vd v51 v52 v53 v54 v55 v56} Fc FL FC19{ m FL[2]} FL FC19} Fi[2] Fc Fs[6] FC20{ Fi Fc[512]}}


 S4292C2 ::~S4292C2(){ note_dtor("S4292C2", this);}
void  S4292C2 ::v48(){vfunc_called(this, "_ZN7S4292C23v48Ev");}
void  S4292C2 ::v49(){vfunc_called(this, "_ZN7S4292C23v49Ev");}
void  S4292C2 ::v50(){vfunc_called(this, "_ZN7S4292C23v50Ev");}
void  S4292C2 ::v51(){vfunc_called(this, "_ZN7S4292C23v51Ev");}
void  S4292C2 ::v52(){vfunc_called(this, "_ZN7S4292C23v52Ev");}
void  S4292C2 ::v53(){vfunc_called(this, "_ZN7S4292C23v53Ev");}
void  S4292C2 ::v54(){vfunc_called(this, "_ZN7S4292C23v54Ev");}
void  S4292C2 ::v55(){vfunc_called(this, "_ZN7S4292C23v55Ev");}
void  S4292C2 ::v56(){vfunc_called(this, "_ZN7S4292C23v56Ev");}
void  S4292C2 ::v57(){vfunc_called(this, "_ZN7S4292C23v57Ev");}
void  S4292C2 ::v58(){vfunc_called(this, "_ZN7S4292C23v58Ev");}
void  S4292C2 ::v59(){vfunc_called(this, "_ZN7S4292C23v59Ev");}
void  S4292C2 ::v60(){vfunc_called(this, "_ZN7S4292C23v60Ev");}
void  S4292C2 ::v61(){vfunc_called(this, "_ZN7S4292C23v61Ev");}
S4292C2 ::S4292C2(){ note_ctor("S4292C2", this);} // tgen

static void Test_S4292C2()
{
  extern Class_Descriptor cd_S4292C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(111,189)];
    init_test(&cd_S4292C2, buf);
    S4292C2 *dp, &lv = *(dp=new (buf) S4292C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(880,752), "sizeof(S4292C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C2)");
    check_base_class_offset(lv, (S4292C3*), 0, "S4292C2");
    check_base_class_offset(lv, (S4292C5*)(S4292C4*), ABISELECT(8,4), "S4292C2");
    check_base_class_offset(lv, (S4292C6*)(S4292C4*), ABISELECT(16,8), "S4292C2");
    check_base_class_offset(lv, (S4292C7*)(S4292C4*), ABISELECT(24,12), "S4292C2");
    check_base_class_offset(lv, (S4292C4*), ABISELECT(8,4), "S4292C2");
    check_field_offset(lv, s4292c2f0, ABISELECT(40,20), "S4292C2.s4292c2f0");
    check_field_offset(lv, s4292c2f1, ABISELECT(56,28), "S4292C2.s4292c2f1");
    check_field_offset(lv, s4292c2f2, ABISELECT(336,212), "S4292C2.s4292c2f2");
    check_field_offset(lv, s4292c2f3, ABISELECT(344,220), "S4292C2.s4292c2f3");
    check_field_offset(lv, s4292c2f4, ABISELECT(346,222), "S4292C2.s4292c2f4");
    check_field_offset(lv, s4292c2f5, ABISELECT(360,236), "S4292C2.s4292c2f5");
    test_class_info(&lv, &cd_S4292C2);
    dp->~S4292C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C2(Test_S4292C2, "S4292C2", ABISELECT(880,752));

#else // __cplusplus

extern void _ZN7S4292C2C1Ev();
extern void _ZN7S4292C2D1Ev();
Name_Map name_map_S4292C2[] = {
  NSPAIR(_ZN7S4292C2C1Ev),
  NSPAIR(_ZN7S4292C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4292C3;
extern VTBL_ENTRY _ZTI7S4292C3[];
extern  VTBL_ENTRY _ZTV7S4292C3[];
extern Class_Descriptor cd_S4292C5;
extern VTBL_ENTRY _ZTI7S4292C5[];
extern  VTBL_ENTRY _ZTV7S4292C5[];
extern Class_Descriptor cd_S4292C6;
extern VTBL_ENTRY _ZTI7S4292C6[];
extern  VTBL_ENTRY _ZTV7S4292C6[];
extern Class_Descriptor cd_S4292C7;
extern VTBL_ENTRY _ZTI7S4292C7[];
extern  VTBL_ENTRY _ZTV7S4292C7[];
extern Class_Descriptor cd_S4292C4;
extern VTBL_ENTRY _ZTI7S4292C4[];
extern  VTBL_ENTRY _ZTV7S4292C4[];
static Base_Class bases_S4292C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4292C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4292C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C6,    ABISELECT(16,8), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C7,    ABISELECT(24,12), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C4,    ABISELECT(8,4), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4292C2[];
extern void _ZN7S4292C2D1Ev();
extern void _ZN7S4292C2D0Ev();
extern void _ZN7S4292C33v17Ev();
extern void _ZN7S4292C33v18Ev();
extern void _ZN7S4292C33v19Ev();
extern void _ZN7S4292C33v20Ev();
extern void _ZN7S4292C33v21Ev();
extern void _ZN7S4292C33v22Ev();
extern void _ZN7S4292C33v23Ev();
extern void _ZN7S4292C33v24Ev();
extern void _ZN7S4292C33v25Ev();
extern void _ZN7S4292C33v26Ev();
extern void _ZN7S4292C33v27Ev();
extern void _ZN7S4292C33v28Ev();
extern void _ZN7S4292C33v29Ev();
extern void _ZN7S4292C33v30Ev();
extern void _ZN7S4292C33v31Ev();
extern void _ZN7S4292C33v32Ev();
extern void _ZN7S4292C33v33Ev();
extern void _ZN7S4292C33v34Ev();
extern void _ZN7S4292C33v35Ev();
extern void _ZN7S4292C33v36Ev();
extern void _ZN7S4292C33v37Ev();
extern void _ZN7S4292C33v38Ev();
extern void _ZN7S4292C33v39Ev();
extern void _ZN7S4292C33v40Ev();
extern void _ZN7S4292C33v41Ev();
extern void _ZN7S4292C23v48Ev();
extern void _ZN7S4292C23v49Ev();
extern void _ZN7S4292C23v50Ev();
extern void _ZN7S4292C23v51Ev();
extern void _ZN7S4292C23v52Ev();
extern void _ZN7S4292C23v53Ev();
extern void _ZN7S4292C23v54Ev();
extern void _ZN7S4292C23v55Ev();
extern void _ZN7S4292C23v56Ev();
extern void _ZN7S4292C23v57Ev();
extern void _ZN7S4292C23v58Ev();
extern void _ZN7S4292C23v59Ev();
extern void _ZN7S4292C23v60Ev();
extern void _ZN7S4292C23v61Ev();
extern void ABISELECT(_ZThn8_N7S4292C2D1Ev,_ZThn4_N7S4292C2D1Ev)();
extern void ABISELECT(_ZThn8_N7S4292C2D0Ev,_ZThn4_N7S4292C2D0Ev)();
extern void _ZN7S4292C53v42Ev();
extern void _ZN7S4292C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4292C2D1Ev,_ZThn8_N7S4292C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S4292C2D0Ev,_ZThn8_N7S4292C2D0Ev)();
extern void _ZN7S4292C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4292C2D1Ev,_ZThn12_N7S4292C2D1Ev)();
extern void ABISELECT(_ZThn24_N7S4292C2D0Ev,_ZThn12_N7S4292C2D0Ev)();
extern void _ZN7S4292C73v44Ev();
extern void _ZN7S4292C73v45Ev();
extern void _ZN7S4292C73v46Ev();
static  VTBL_ENTRY vtc_S4292C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C2[0]),
  (VTBL_ENTRY)&_ZN7S4292C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v61Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4292C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C2D1Ev,_ZThn4_N7S4292C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C2D0Ev,_ZThn4_N7S4292C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4292C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4292C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C2D1Ev,_ZThn8_N7S4292C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C2D0Ev,_ZThn8_N7S4292C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4292C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4292C2D1Ev,_ZThn12_N7S4292C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4292C2D0Ev,_ZThn12_N7S4292C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4292C2[];
extern  VTBL_ENTRY _ZTV7S4292C2[];
Class_Descriptor cd_S4292C2 = {  "S4292C2", // class name
  bases_S4292C2, 5,
  &(vtc_S4292C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,752), // object size
  NSPAIRA(_ZTI7S4292C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4292C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C26_nt  {
  __tsi64 s4292c26f0;
};
//SIG(-1 S4292C26_nt) C1{ FL}



//skip512 S4292C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C25  {
  ::S4292C26_nt s4292c25f0;
  short s4292c25f1;
  char s4292c25f2[2];
  ::S4291C27 s4292c25f3;
};
//SIG(1 S4292C25) C1{ FC2{ FL} Fs Fc[2] FC3{ Fs Fc[2] Fp Fi}}



static void Test_S4292C25()
{
  {
    init_simple_test("S4292C25");
    S4292C25 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S4292C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C25)");
    check_field_offset(lv, s4292c25f0, 0, "S4292C25.s4292c25f0");
    check_field_offset(lv, s4292c25f1, 8, "S4292C25.s4292c25f1");
    check_field_offset(lv, s4292c25f2, 10, "S4292C25.s4292c25f2");
    check_field_offset(lv, s4292c25f3, ABISELECT(16,12), "S4292C25.s4292c25f3");
  }
}
static Arrange_To_Call_Me vS4292C25(Test_S4292C25, "S4292C25", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C22  {
  short s4292c22f0;
  int s4292c22f1;
  short s4292c22f2;
  ::S4291C23_nt s4292c22f3;
  __tsi64 s4292c22f4;
  ::S4291C24 s4292c22f5;
  ::S4292C25 s4292c22f6[2];
  short s4292c22f7;
  ::S4291C28 s4292c22f8;
  void *s4292c22f9;
  int s4292c22f10;
};
//SIG(-1 S4292C22) C1{ Fs Fi Fs FC2{ Fc[16]} FL FC3{ Fc[32]} FC4{ FC5{ FL} Fs Fc[2] FC6{ Fs Fc[2] Fp Fi}}[2] Fs FC7{ Fi Fc[64]} Fp Fi}



static void Test_S4292C22()
{
  {
    init_simple_test("S4292C22");
    S4292C22 lv;
    check2(sizeof(lv), ABISELECT(240,196), "sizeof(S4292C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C22)");
    check_field_offset(lv, s4292c22f0, 0, "S4292C22.s4292c22f0");
    check_field_offset(lv, s4292c22f1, 4, "S4292C22.s4292c22f1");
    check_field_offset(lv, s4292c22f2, 8, "S4292C22.s4292c22f2");
    check_field_offset(lv, s4292c22f3, 10, "S4292C22.s4292c22f3");
    check_field_offset(lv, s4292c22f4, ABISELECT(32,28), "S4292C22.s4292c22f4");
    check_field_offset(lv, s4292c22f5, ABISELECT(40,36), "S4292C22.s4292c22f5");
    check_field_offset(lv, s4292c22f6, ABISELECT(72,68), "S4292C22.s4292c22f6");
    check_field_offset(lv, s4292c22f7, ABISELECT(152,116), "S4292C22.s4292c22f7");
    check_field_offset(lv, s4292c22f8, ABISELECT(156,120), "S4292C22.s4292c22f8");
    check_field_offset(lv, s4292c22f9, ABISELECT(224,188), "S4292C22.s4292c22f9");
    check_field_offset(lv, s4292c22f10, ABISELECT(232,192), "S4292C22.s4292c22f10");
  }
}
static Arrange_To_Call_Me vS4292C22(Test_S4292C22, "S4292C22", ABISELECT(240,196));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4292C1  : S4292C2 {
  ::S4292C22 s4292c1f0;
  void *s4292c1f1;
  ::S4291C29 s4292c1f2;
  void *s4292c1f3[64];
  virtual  ~S4292C1(); // _ZN7S4292C1D1Ev
  virtual void  v1(); // _ZN7S4292C12v1Ev
  virtual void  v2(); // _ZN7S4292C12v2Ev
  virtual void  v3(); // _ZN7S4292C12v3Ev
  virtual void  v4(); // _ZN7S4292C12v4Ev
  virtual void  v5(); // _ZN7S4292C12v5Ev
  virtual void  v6(); // _ZN7S4292C12v6Ev
  virtual void  v7(); // _ZN7S4292C12v7Ev
  virtual void  v8(); // _ZN7S4292C12v8Ev
  virtual void  v9(); // _ZN7S4292C12v9Ev
  virtual void  v10(); // _ZN7S4292C13v10Ev
  virtual void  v11(); // _ZN7S4292C13v11Ev
  virtual void  v12(); // _ZN7S4292C13v12Ev
  virtual void  v13(); // _ZN7S4292C13v13Ev
  virtual void  v14(); // _ZN7S4292C13v14Ev
  virtual void  v15(); // _ZN7S4292C13v15Ev
  virtual void  v16(); // _ZN7S4292C13v16Ev
  S4292C1(); // tgen
};
//SIG(1 S4292C1) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41} BC4{ BC5{ vd v42} BC6{ vd v43} BC7{ vd v44 v45 v46 Fp} vd v47} vd v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 FC8{ BC9{ vd v63} vd v62 Fp} FC10{ vd v64 v65 v66 Fc Fi FC11{ m Fi} FC12{ m FC13{ Fi Fp} Fi} Fp FC14{ m Fp[2] Fi} FC14 Fp[2] Fi Fp FC15{ BC16{ vd v73 v74 v75 v76 v77 v78 v79 Fi Fp Fi FC17{ Fc[2] Fs FC18{ Fi} Fs Fc[6]} Fi[3] FC19{ m Fi Fp[3]}} vd v67 v68 v69 v70 v71 v72} Fc FL FC20{ m FL[2]} FL FC20} Fi[2] Fc Fs[6] FC21{ Fi Fc[512]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC22{ Fs Fi Fs FC23{ Fc[16]} FL FC24{ Fc[32]} FC25{ FC26{ FL} Fs Fc[2] FC27{ Fs Fc[2] Fp Fi}}[2] Fs FC28{ Fi Fc[64]} Fp Fi} Fp FC29{ m FC14} Fp[64]}


 S4292C1 ::~S4292C1(){ note_dtor("S4292C1", this);}
void  S4292C1 ::v1(){vfunc_called(this, "_ZN7S4292C12v1Ev");}
void  S4292C1 ::v2(){vfunc_called(this, "_ZN7S4292C12v2Ev");}
void  S4292C1 ::v3(){vfunc_called(this, "_ZN7S4292C12v3Ev");}
void  S4292C1 ::v4(){vfunc_called(this, "_ZN7S4292C12v4Ev");}
void  S4292C1 ::v5(){vfunc_called(this, "_ZN7S4292C12v5Ev");}
void  S4292C1 ::v6(){vfunc_called(this, "_ZN7S4292C12v6Ev");}
void  S4292C1 ::v7(){vfunc_called(this, "_ZN7S4292C12v7Ev");}
void  S4292C1 ::v8(){vfunc_called(this, "_ZN7S4292C12v8Ev");}
void  S4292C1 ::v9(){vfunc_called(this, "_ZN7S4292C12v9Ev");}
void  S4292C1 ::v10(){vfunc_called(this, "_ZN7S4292C13v10Ev");}
void  S4292C1 ::v11(){vfunc_called(this, "_ZN7S4292C13v11Ev");}
void  S4292C1 ::v12(){vfunc_called(this, "_ZN7S4292C13v12Ev");}
void  S4292C1 ::v13(){vfunc_called(this, "_ZN7S4292C13v13Ev");}
void  S4292C1 ::v14(){vfunc_called(this, "_ZN7S4292C13v14Ev");}
void  S4292C1 ::v15(){vfunc_called(this, "_ZN7S4292C13v15Ev");}
void  S4292C1 ::v16(){vfunc_called(this, "_ZN7S4292C13v16Ev");}
S4292C1 ::S4292C1(){ note_ctor("S4292C1", this);} // tgen

static void Test_S4292C1()
{
  extern Class_Descriptor cd_S4292C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(209,306)];
    init_test(&cd_S4292C1, buf);
    S4292C1 *dp, &lv = *(dp=new (buf) S4292C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1664,1220), "sizeof(S4292C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4292C1)");
    check_base_class_offset(lv, (S4292C3*)(S4292C2*), 0, "S4292C1");
    check_base_class_offset(lv, (S4292C5*)(S4292C4*)(S4292C2*), ABISELECT(8,4), "S4292C1");
    check_base_class_offset(lv, (S4292C6*)(S4292C4*)(S4292C2*), ABISELECT(16,8), "S4292C1");
    check_base_class_offset(lv, (S4292C7*)(S4292C4*)(S4292C2*), ABISELECT(24,12), "S4292C1");
    check_base_class_offset(lv, (S4292C4*)(S4292C2*), ABISELECT(8,4), "S4292C1");
    check_base_class_offset(lv, (S4292C2*), 0, "S4292C1");
    check_field_offset(lv, s4292c1f0, ABISELECT(880,752), "S4292C1.s4292c1f0");
    check_field_offset(lv, s4292c1f1, ABISELECT(1120,948), "S4292C1.s4292c1f1");
    check_field_offset(lv, s4292c1f2, ABISELECT(1128,952), "S4292C1.s4292c1f2");
    check_field_offset(lv, s4292c1f3, ABISELECT(1152,964), "S4292C1.s4292c1f3");
    test_class_info(&lv, &cd_S4292C1);
    dp->~S4292C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4292C1(Test_S4292C1, "S4292C1", ABISELECT(1664,1220));

#else // __cplusplus

extern void _ZN7S4292C1C1Ev();
extern void _ZN7S4292C1D1Ev();
Name_Map name_map_S4292C1[] = {
  NSPAIR(_ZN7S4292C1C1Ev),
  NSPAIR(_ZN7S4292C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4292C3;
extern VTBL_ENTRY _ZTI7S4292C3[];
extern  VTBL_ENTRY _ZTV7S4292C3[];
extern Class_Descriptor cd_S4292C5;
extern VTBL_ENTRY _ZTI7S4292C5[];
extern  VTBL_ENTRY _ZTV7S4292C5[];
extern Class_Descriptor cd_S4292C6;
extern VTBL_ENTRY _ZTI7S4292C6[];
extern  VTBL_ENTRY _ZTV7S4292C6[];
extern Class_Descriptor cd_S4292C7;
extern VTBL_ENTRY _ZTI7S4292C7[];
extern  VTBL_ENTRY _ZTV7S4292C7[];
extern Class_Descriptor cd_S4292C4;
extern VTBL_ENTRY _ZTI7S4292C4[];
extern  VTBL_ENTRY _ZTV7S4292C4[];
extern Class_Descriptor cd_S4292C2;
extern VTBL_ENTRY _ZTI7S4292C2[];
extern  VTBL_ENTRY _ZTV7S4292C2[];
static Base_Class bases_S4292C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4292C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4292C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C6,    ABISELECT(16,8), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C7,    ABISELECT(24,12), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4292C4,    ABISELECT(8,4), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4292C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4292C1[];
extern void _ZN7S4292C1D1Ev();
extern void _ZN7S4292C1D0Ev();
extern void _ZN7S4292C33v17Ev();
extern void _ZN7S4292C33v18Ev();
extern void _ZN7S4292C33v19Ev();
extern void _ZN7S4292C33v20Ev();
extern void _ZN7S4292C33v21Ev();
extern void _ZN7S4292C33v22Ev();
extern void _ZN7S4292C33v23Ev();
extern void _ZN7S4292C33v24Ev();
extern void _ZN7S4292C33v25Ev();
extern void _ZN7S4292C33v26Ev();
extern void _ZN7S4292C33v27Ev();
extern void _ZN7S4292C33v28Ev();
extern void _ZN7S4292C33v29Ev();
extern void _ZN7S4292C33v30Ev();
extern void _ZN7S4292C33v31Ev();
extern void _ZN7S4292C33v32Ev();
extern void _ZN7S4292C33v33Ev();
extern void _ZN7S4292C33v34Ev();
extern void _ZN7S4292C33v35Ev();
extern void _ZN7S4292C33v36Ev();
extern void _ZN7S4292C33v37Ev();
extern void _ZN7S4292C33v38Ev();
extern void _ZN7S4292C33v39Ev();
extern void _ZN7S4292C33v40Ev();
extern void _ZN7S4292C33v41Ev();
extern void _ZN7S4292C23v48Ev();
extern void _ZN7S4292C23v49Ev();
extern void _ZN7S4292C23v50Ev();
extern void _ZN7S4292C23v51Ev();
extern void _ZN7S4292C23v52Ev();
extern void _ZN7S4292C23v53Ev();
extern void _ZN7S4292C23v54Ev();
extern void _ZN7S4292C23v55Ev();
extern void _ZN7S4292C23v56Ev();
extern void _ZN7S4292C23v57Ev();
extern void _ZN7S4292C23v58Ev();
extern void _ZN7S4292C23v59Ev();
extern void _ZN7S4292C23v60Ev();
extern void _ZN7S4292C23v61Ev();
extern void _ZN7S4292C12v1Ev();
extern void _ZN7S4292C12v2Ev();
extern void _ZN7S4292C12v3Ev();
extern void _ZN7S4292C12v4Ev();
extern void _ZN7S4292C12v5Ev();
extern void _ZN7S4292C12v6Ev();
extern void _ZN7S4292C12v7Ev();
extern void _ZN7S4292C12v8Ev();
extern void _ZN7S4292C12v9Ev();
extern void _ZN7S4292C13v10Ev();
extern void _ZN7S4292C13v11Ev();
extern void _ZN7S4292C13v12Ev();
extern void _ZN7S4292C13v13Ev();
extern void _ZN7S4292C13v14Ev();
extern void _ZN7S4292C13v15Ev();
extern void _ZN7S4292C13v16Ev();
extern void ABISELECT(_ZThn8_N7S4292C1D1Ev,_ZThn4_N7S4292C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S4292C1D0Ev,_ZThn4_N7S4292C1D0Ev)();
extern void _ZN7S4292C53v42Ev();
extern void _ZN7S4292C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4292C1D1Ev,_ZThn8_N7S4292C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S4292C1D0Ev,_ZThn8_N7S4292C1D0Ev)();
extern void _ZN7S4292C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4292C1D1Ev,_ZThn12_N7S4292C1D1Ev)();
extern void ABISELECT(_ZThn24_N7S4292C1D0Ev,_ZThn12_N7S4292C1D0Ev)();
extern void _ZN7S4292C73v44Ev();
extern void _ZN7S4292C73v45Ev();
extern void _ZN7S4292C73v46Ev();
static  VTBL_ENTRY vtc_S4292C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4292C1[0]),
  (VTBL_ENTRY)&_ZN7S4292C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4292C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4292C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4292C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4292C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4292C13v16Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4292C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C1D1Ev,_ZThn4_N7S4292C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4292C1D0Ev,_ZThn4_N7S4292C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4292C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4292C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C1D1Ev,_ZThn8_N7S4292C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4292C1D0Ev,_ZThn8_N7S4292C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4292C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4292C1D1Ev,_ZThn12_N7S4292C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4292C1D0Ev,_ZThn12_N7S4292C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4292C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4292C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4292C1[];
extern  VTBL_ENTRY _ZTV7S4292C1[];
Class_Descriptor cd_S4292C1 = {  "S4292C1", // class name
  bases_S4292C1, 6,
  &(vtc_S4292C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1664,1220), // object size
  NSPAIRA(_ZTI7S4292C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4292C1),77, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C3  {
  virtual  ~S4293C3(); // _ZN7S4293C3D1Ev
  virtual void  v17(); // _ZN7S4293C33v17Ev
  virtual void  v18(); // _ZN7S4293C33v18Ev
  virtual void  v19(); // _ZN7S4293C33v19Ev
  virtual void  v20(); // _ZN7S4293C33v20Ev
  virtual void  v21(); // _ZN7S4293C33v21Ev
  virtual void  v22(); // _ZN7S4293C33v22Ev
  virtual void  v23(); // _ZN7S4293C33v23Ev
  virtual void  v24(); // _ZN7S4293C33v24Ev
  virtual void  v25(); // _ZN7S4293C33v25Ev
  virtual void  v26(); // _ZN7S4293C33v26Ev
  virtual void  v27(); // _ZN7S4293C33v27Ev
  virtual void  v28(); // _ZN7S4293C33v28Ev
  virtual void  v29(); // _ZN7S4293C33v29Ev
  virtual void  v30(); // _ZN7S4293C33v30Ev
  virtual void  v31(); // _ZN7S4293C33v31Ev
  virtual void  v32(); // _ZN7S4293C33v32Ev
  virtual void  v33(); // _ZN7S4293C33v33Ev
  virtual void  v34(); // _ZN7S4293C33v34Ev
  virtual void  v35(); // _ZN7S4293C33v35Ev
  virtual void  v36(); // _ZN7S4293C33v36Ev
  virtual void  v37(); // _ZN7S4293C33v37Ev
  virtual void  v38(); // _ZN7S4293C33v38Ev
  virtual void  v39(); // _ZN7S4293C33v39Ev
  virtual void  v40(); // _ZN7S4293C33v40Ev
  virtual void  v41(); // _ZN7S4293C33v41Ev
  S4293C3(); // tgen
};
//SIG(-1 S4293C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25}


 S4293C3 ::~S4293C3(){ note_dtor("S4293C3", this);}
void  S4293C3 ::v17(){vfunc_called(this, "_ZN7S4293C33v17Ev");}
void  S4293C3 ::v18(){vfunc_called(this, "_ZN7S4293C33v18Ev");}
void  S4293C3 ::v19(){vfunc_called(this, "_ZN7S4293C33v19Ev");}
void  S4293C3 ::v20(){vfunc_called(this, "_ZN7S4293C33v20Ev");}
void  S4293C3 ::v21(){vfunc_called(this, "_ZN7S4293C33v21Ev");}
void  S4293C3 ::v22(){vfunc_called(this, "_ZN7S4293C33v22Ev");}
void  S4293C3 ::v23(){vfunc_called(this, "_ZN7S4293C33v23Ev");}
void  S4293C3 ::v24(){vfunc_called(this, "_ZN7S4293C33v24Ev");}
void  S4293C3 ::v25(){vfunc_called(this, "_ZN7S4293C33v25Ev");}
void  S4293C3 ::v26(){vfunc_called(this, "_ZN7S4293C33v26Ev");}
void  S4293C3 ::v27(){vfunc_called(this, "_ZN7S4293C33v27Ev");}
void  S4293C3 ::v28(){vfunc_called(this, "_ZN7S4293C33v28Ev");}
void  S4293C3 ::v29(){vfunc_called(this, "_ZN7S4293C33v29Ev");}
void  S4293C3 ::v30(){vfunc_called(this, "_ZN7S4293C33v30Ev");}
void  S4293C3 ::v31(){vfunc_called(this, "_ZN7S4293C33v31Ev");}
void  S4293C3 ::v32(){vfunc_called(this, "_ZN7S4293C33v32Ev");}
void  S4293C3 ::v33(){vfunc_called(this, "_ZN7S4293C33v33Ev");}
void  S4293C3 ::v34(){vfunc_called(this, "_ZN7S4293C33v34Ev");}
void  S4293C3 ::v35(){vfunc_called(this, "_ZN7S4293C33v35Ev");}
void  S4293C3 ::v36(){vfunc_called(this, "_ZN7S4293C33v36Ev");}
void  S4293C3 ::v37(){vfunc_called(this, "_ZN7S4293C33v37Ev");}
void  S4293C3 ::v38(){vfunc_called(this, "_ZN7S4293C33v38Ev");}
void  S4293C3 ::v39(){vfunc_called(this, "_ZN7S4293C33v39Ev");}
void  S4293C3 ::v40(){vfunc_called(this, "_ZN7S4293C33v40Ev");}
void  S4293C3 ::v41(){vfunc_called(this, "_ZN7S4293C33v41Ev");}
S4293C3 ::S4293C3(){ note_ctor("S4293C3", this);} // tgen

static void Test_S4293C3()
{
  extern Class_Descriptor cd_S4293C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4293C3, buf);
    S4293C3 *dp, &lv = *(dp=new (buf) S4293C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4293C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C3)");
    test_class_info(&lv, &cd_S4293C3);
    dp->~S4293C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C3(Test_S4293C3, "S4293C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4293C3C1Ev();
extern void _ZN7S4293C3D1Ev();
Name_Map name_map_S4293C3[] = {
  NSPAIR(_ZN7S4293C3C1Ev),
  NSPAIR(_ZN7S4293C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4293C3[];
extern void _ZN7S4293C3D1Ev();
extern void _ZN7S4293C3D0Ev();
extern void _ZN7S4293C33v17Ev();
extern void _ZN7S4293C33v18Ev();
extern void _ZN7S4293C33v19Ev();
extern void _ZN7S4293C33v20Ev();
extern void _ZN7S4293C33v21Ev();
extern void _ZN7S4293C33v22Ev();
extern void _ZN7S4293C33v23Ev();
extern void _ZN7S4293C33v24Ev();
extern void _ZN7S4293C33v25Ev();
extern void _ZN7S4293C33v26Ev();
extern void _ZN7S4293C33v27Ev();
extern void _ZN7S4293C33v28Ev();
extern void _ZN7S4293C33v29Ev();
extern void _ZN7S4293C33v30Ev();
extern void _ZN7S4293C33v31Ev();
extern void _ZN7S4293C33v32Ev();
extern void _ZN7S4293C33v33Ev();
extern void _ZN7S4293C33v34Ev();
extern void _ZN7S4293C33v35Ev();
extern void _ZN7S4293C33v36Ev();
extern void _ZN7S4293C33v37Ev();
extern void _ZN7S4293C33v38Ev();
extern void _ZN7S4293C33v39Ev();
extern void _ZN7S4293C33v40Ev();
extern void _ZN7S4293C33v41Ev();
static  VTBL_ENTRY vtc_S4293C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C3[0]),
  (VTBL_ENTRY)&_ZN7S4293C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v41Ev,
};
extern VTBL_ENTRY _ZTI7S4293C3[];
extern  VTBL_ENTRY _ZTV7S4293C3[];
Class_Descriptor cd_S4293C3 = {  "S4293C3", // class name
  0,0,//no base classes
  &(vtc_S4293C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4293C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4293C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C5  {
  virtual  ~S4293C5(); // _ZN7S4293C5D1Ev
  virtual void  v42(); // _ZN7S4293C53v42Ev
  S4293C5(); // tgen
};
//SIG(-1 S4293C5) C1{ vd v1}


 S4293C5 ::~S4293C5(){ note_dtor("S4293C5", this);}
void  S4293C5 ::v42(){vfunc_called(this, "_ZN7S4293C53v42Ev");}
S4293C5 ::S4293C5(){ note_ctor("S4293C5", this);} // tgen

static void Test_S4293C5()
{
  extern Class_Descriptor cd_S4293C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4293C5, buf);
    S4293C5 *dp, &lv = *(dp=new (buf) S4293C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4293C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C5)");
    test_class_info(&lv, &cd_S4293C5);
    dp->~S4293C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C5(Test_S4293C5, "S4293C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4293C5C1Ev();
extern void _ZN7S4293C5D1Ev();
Name_Map name_map_S4293C5[] = {
  NSPAIR(_ZN7S4293C5C1Ev),
  NSPAIR(_ZN7S4293C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4293C5[];
extern void _ZN7S4293C5D1Ev();
extern void _ZN7S4293C5D0Ev();
extern void _ZN7S4293C53v42Ev();
static  VTBL_ENTRY vtc_S4293C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C5[0]),
  (VTBL_ENTRY)&_ZN7S4293C5D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C5D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C53v42Ev,
};
extern VTBL_ENTRY _ZTI7S4293C5[];
extern  VTBL_ENTRY _ZTV7S4293C5[];
Class_Descriptor cd_S4293C5 = {  "S4293C5", // class name
  0,0,//no base classes
  &(vtc_S4293C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4293C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4293C5),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C6  {
  virtual  ~S4293C6(); // _ZN7S4293C6D1Ev
  virtual void  v43(); // _ZN7S4293C63v43Ev
  S4293C6(); // tgen
};
//SIG(-1 S4293C6) C1{ vd v1}


 S4293C6 ::~S4293C6(){ note_dtor("S4293C6", this);}
void  S4293C6 ::v43(){vfunc_called(this, "_ZN7S4293C63v43Ev");}
S4293C6 ::S4293C6(){ note_ctor("S4293C6", this);} // tgen

static void Test_S4293C6()
{
  extern Class_Descriptor cd_S4293C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4293C6, buf);
    S4293C6 *dp, &lv = *(dp=new (buf) S4293C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4293C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C6)");
    test_class_info(&lv, &cd_S4293C6);
    dp->~S4293C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C6(Test_S4293C6, "S4293C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4293C6C1Ev();
extern void _ZN7S4293C6D1Ev();
Name_Map name_map_S4293C6[] = {
  NSPAIR(_ZN7S4293C6C1Ev),
  NSPAIR(_ZN7S4293C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4293C6[];
extern void _ZN7S4293C6D1Ev();
extern void _ZN7S4293C6D0Ev();
extern void _ZN7S4293C63v43Ev();
static  VTBL_ENTRY vtc_S4293C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C6[0]),
  (VTBL_ENTRY)&_ZN7S4293C6D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C6D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C63v43Ev,
};
extern VTBL_ENTRY _ZTI7S4293C6[];
extern  VTBL_ENTRY _ZTV7S4293C6[];
Class_Descriptor cd_S4293C6 = {  "S4293C6", // class name
  0,0,//no base classes
  &(vtc_S4293C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4293C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4293C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C7  {
  void *s4293c7f0;
  virtual  ~S4293C7(); // _ZN7S4293C7D1Ev
  virtual void  v44(); // _ZN7S4293C73v44Ev
  virtual void  v45(); // _ZN7S4293C73v45Ev
  virtual void  v46(); // _ZN7S4293C73v46Ev
  S4293C7(); // tgen
};
//SIG(-1 S4293C7) C1{ vd v1 v2 v3 Fp}


 S4293C7 ::~S4293C7(){ note_dtor("S4293C7", this);}
void  S4293C7 ::v44(){vfunc_called(this, "_ZN7S4293C73v44Ev");}
void  S4293C7 ::v45(){vfunc_called(this, "_ZN7S4293C73v45Ev");}
void  S4293C7 ::v46(){vfunc_called(this, "_ZN7S4293C73v46Ev");}
S4293C7 ::S4293C7(){ note_ctor("S4293C7", this);} // tgen

static void Test_S4293C7()
{
  extern Class_Descriptor cd_S4293C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4293C7, buf);
    S4293C7 *dp, &lv = *(dp=new (buf) S4293C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4293C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C7)");
    check_field_offset(lv, s4293c7f0, ABISELECT(8,4), "S4293C7.s4293c7f0");
    test_class_info(&lv, &cd_S4293C7);
    dp->~S4293C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C7(Test_S4293C7, "S4293C7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S4293C7C1Ev();
extern void _ZN7S4293C7D1Ev();
Name_Map name_map_S4293C7[] = {
  NSPAIR(_ZN7S4293C7C1Ev),
  NSPAIR(_ZN7S4293C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4293C7[];
extern void _ZN7S4293C7D1Ev();
extern void _ZN7S4293C7D0Ev();
extern void _ZN7S4293C73v44Ev();
extern void _ZN7S4293C73v45Ev();
extern void _ZN7S4293C73v46Ev();
static  VTBL_ENTRY vtc_S4293C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C7[0]),
  (VTBL_ENTRY)&_ZN7S4293C7D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C7D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4293C7[];
extern  VTBL_ENTRY _ZTV7S4293C7[];
Class_Descriptor cd_S4293C7 = {  "S4293C7", // class name
  0,0,//no base classes
  &(vtc_S4293C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S4293C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4293C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C4  : S4293C5 , S4293C6 , S4293C7 {
  virtual  ~S4293C4(); // _ZN7S4293C4D1Ev
  virtual void  v47(); // _ZN7S4293C43v47Ev
  S4293C4(); // tgen
};
//SIG(-1 S4293C4) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S4293C4 ::~S4293C4(){ note_dtor("S4293C4", this);}
void  S4293C4 ::v47(){vfunc_called(this, "_ZN7S4293C43v47Ev");}
S4293C4 ::S4293C4(){ note_ctor("S4293C4", this);} // tgen

static void Test_S4293C4()
{
  extern Class_Descriptor cd_S4293C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S4293C4, buf);
    S4293C4 *dp, &lv = *(dp=new (buf) S4293C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S4293C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C4)");
    check_base_class_offset(lv, (S4293C5*), 0, "S4293C4");
    check_base_class_offset(lv, (S4293C6*), ABISELECT(8,4), "S4293C4");
    check_base_class_offset(lv, (S4293C7*), ABISELECT(16,8), "S4293C4");
    test_class_info(&lv, &cd_S4293C4);
    dp->~S4293C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C4(Test_S4293C4, "S4293C4", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN7S4293C4C1Ev();
extern void _ZN7S4293C4D1Ev();
Name_Map name_map_S4293C4[] = {
  NSPAIR(_ZN7S4293C4C1Ev),
  NSPAIR(_ZN7S4293C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4293C5;
extern VTBL_ENTRY _ZTI7S4293C5[];
extern  VTBL_ENTRY _ZTV7S4293C5[];
extern Class_Descriptor cd_S4293C6;
extern VTBL_ENTRY _ZTI7S4293C6[];
extern  VTBL_ENTRY _ZTV7S4293C6[];
extern Class_Descriptor cd_S4293C7;
extern VTBL_ENTRY _ZTI7S4293C7[];
extern  VTBL_ENTRY _ZTV7S4293C7[];
static Base_Class bases_S4293C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4293C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4293C6,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4293C7,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4293C4[];
extern void _ZN7S4293C4D1Ev();
extern void _ZN7S4293C4D0Ev();
extern void _ZN7S4293C53v42Ev();
extern void _ZN7S4293C43v47Ev();
extern void ABISELECT(_ZThn8_N7S4293C4D1Ev,_ZThn4_N7S4293C4D1Ev)();
extern void ABISELECT(_ZThn8_N7S4293C4D0Ev,_ZThn4_N7S4293C4D0Ev)();
extern void _ZN7S4293C63v43Ev();
extern void ABISELECT(_ZThn16_N7S4293C4D1Ev,_ZThn8_N7S4293C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S4293C4D0Ev,_ZThn8_N7S4293C4D0Ev)();
extern void _ZN7S4293C73v44Ev();
extern void _ZN7S4293C73v45Ev();
extern void _ZN7S4293C73v46Ev();
static  VTBL_ENTRY vtc_S4293C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C4[0]),
  (VTBL_ENTRY)&_ZN7S4293C4D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C4D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4293C43v47Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4293C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C4D1Ev,_ZThn4_N7S4293C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C4D0Ev,_ZThn4_N7S4293C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C63v43Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4293C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C4D1Ev,_ZThn8_N7S4293C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C4D0Ev,_ZThn8_N7S4293C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4293C4[];
extern  VTBL_ENTRY _ZTV7S4293C4[];
Class_Descriptor cd_S4293C4 = {  "S4293C4", // class name
  bases_S4293C4, 3,
  &(vtc_S4293C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S4293C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S4293C4),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C2  : S4293C3 , S4293C4 {
  ::S10248C23 s4293c2f0;
  ::S10248C25 s4293c2f1;
  int s4293c2f2[2];
  char s4293c2f3;
  short s4293c2f4[6];
  ::S10249C21 s4293c2f5;
  virtual  ~S4293C2(); // _ZN7S4293C2D1Ev
  virtual void  v48(); // _ZN7S4293C23v48Ev
  virtual void  v49(); // _ZN7S4293C23v49Ev
  virtual void  v50(); // _ZN7S4293C23v50Ev
  virtual void  v51(); // _ZN7S4293C23v51Ev
  virtual void  v52(); // _ZN7S4293C23v52Ev
  virtual void  v53(); // _ZN7S4293C23v53Ev
  virtual void  v54(); // _ZN7S4293C23v54Ev
  virtual void  v55(); // _ZN7S4293C23v55Ev
  virtual void  v56(); // _ZN7S4293C23v56Ev
  virtual void  v57(); // _ZN7S4293C23v57Ev
  virtual void  v58(); // _ZN7S4293C23v58Ev
  virtual void  v59(); // _ZN7S4293C23v59Ev
  virtual void  v60(); // _ZN7S4293C23v60Ev
  virtual void  v61(); // _ZN7S4293C23v61Ev
  S4293C2(); // tgen
};
//SIG(-1 S4293C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39} BC3{ BC4{ vd v40} BC5{ vd v41} BC6{ vd v42 v43 v44 Fp} vd v45} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC7{ BC8{ vd v47} vd v46 Fp} FC9{ vd v48 v49 v50 Fc Fi FC10{ m Fi} FC11{ m FC12{ Fi Fp} Fi} Fp FC13{ m Fp[2] Fi} FC13 Fp[2] Fi Fp FC14{ BC15{ vd v57 v58 v59 v60 v61 v62 v63 Fi Fp Fi FC16{ Fc[2] Fs FC17{ Fi} Fs Fc[6]} Fi[3] FC18{ m Fi Fp[3]}} vd v51 v52 v53 v54 v55 v56} Fc Fl FC19{ m Fl[2]} Fl FC19} Fi[2] Fc Fs[6] FC20{ Fi Fc[512]}}


 S4293C2 ::~S4293C2(){ note_dtor("S4293C2", this);}
void  S4293C2 ::v48(){vfunc_called(this, "_ZN7S4293C23v48Ev");}
void  S4293C2 ::v49(){vfunc_called(this, "_ZN7S4293C23v49Ev");}
void  S4293C2 ::v50(){vfunc_called(this, "_ZN7S4293C23v50Ev");}
void  S4293C2 ::v51(){vfunc_called(this, "_ZN7S4293C23v51Ev");}
void  S4293C2 ::v52(){vfunc_called(this, "_ZN7S4293C23v52Ev");}
void  S4293C2 ::v53(){vfunc_called(this, "_ZN7S4293C23v53Ev");}
void  S4293C2 ::v54(){vfunc_called(this, "_ZN7S4293C23v54Ev");}
void  S4293C2 ::v55(){vfunc_called(this, "_ZN7S4293C23v55Ev");}
void  S4293C2 ::v56(){vfunc_called(this, "_ZN7S4293C23v56Ev");}
void  S4293C2 ::v57(){vfunc_called(this, "_ZN7S4293C23v57Ev");}
void  S4293C2 ::v58(){vfunc_called(this, "_ZN7S4293C23v58Ev");}
void  S4293C2 ::v59(){vfunc_called(this, "_ZN7S4293C23v59Ev");}
void  S4293C2 ::v60(){vfunc_called(this, "_ZN7S4293C23v60Ev");}
void  S4293C2 ::v61(){vfunc_called(this, "_ZN7S4293C23v61Ev");}
S4293C2 ::S4293C2(){ note_ctor("S4293C2", this);} // tgen

static void Test_S4293C2()
{
  extern Class_Descriptor cd_S4293C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(111,183)];
    init_test(&cd_S4293C2, buf);
    S4293C2 *dp, &lv = *(dp=new (buf) S4293C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(880,728), "sizeof(S4293C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C2)");
    check_base_class_offset(lv, (S4293C3*), 0, "S4293C2");
    check_base_class_offset(lv, (S4293C5*)(S4293C4*), ABISELECT(8,4), "S4293C2");
    check_base_class_offset(lv, (S4293C6*)(S4293C4*), ABISELECT(16,8), "S4293C2");
    check_base_class_offset(lv, (S4293C7*)(S4293C4*), ABISELECT(24,12), "S4293C2");
    check_base_class_offset(lv, (S4293C4*), ABISELECT(8,4), "S4293C2");
    check_field_offset(lv, s4293c2f0, ABISELECT(40,20), "S4293C2.s4293c2f0");
    check_field_offset(lv, s4293c2f1, ABISELECT(56,28), "S4293C2.s4293c2f1");
    check_field_offset(lv, s4293c2f2, ABISELECT(336,188), "S4293C2.s4293c2f2");
    check_field_offset(lv, s4293c2f3, ABISELECT(344,196), "S4293C2.s4293c2f3");
    check_field_offset(lv, s4293c2f4, ABISELECT(346,198), "S4293C2.s4293c2f4");
    check_field_offset(lv, s4293c2f5, ABISELECT(360,212), "S4293C2.s4293c2f5");
    test_class_info(&lv, &cd_S4293C2);
    dp->~S4293C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C2(Test_S4293C2, "S4293C2", ABISELECT(880,728));

#else // __cplusplus

extern void _ZN7S4293C2C1Ev();
extern void _ZN7S4293C2D1Ev();
Name_Map name_map_S4293C2[] = {
  NSPAIR(_ZN7S4293C2C1Ev),
  NSPAIR(_ZN7S4293C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4293C3;
extern VTBL_ENTRY _ZTI7S4293C3[];
extern  VTBL_ENTRY _ZTV7S4293C3[];
extern Class_Descriptor cd_S4293C5;
extern VTBL_ENTRY _ZTI7S4293C5[];
extern  VTBL_ENTRY _ZTV7S4293C5[];
extern Class_Descriptor cd_S4293C6;
extern VTBL_ENTRY _ZTI7S4293C6[];
extern  VTBL_ENTRY _ZTV7S4293C6[];
extern Class_Descriptor cd_S4293C7;
extern VTBL_ENTRY _ZTI7S4293C7[];
extern  VTBL_ENTRY _ZTV7S4293C7[];
extern Class_Descriptor cd_S4293C4;
extern VTBL_ENTRY _ZTI7S4293C4[];
extern  VTBL_ENTRY _ZTV7S4293C4[];
static Base_Class bases_S4293C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4293C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4293C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C6,    ABISELECT(16,8), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C7,    ABISELECT(24,12), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C4,    ABISELECT(8,4), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4293C2[];
extern void _ZN7S4293C2D1Ev();
extern void _ZN7S4293C2D0Ev();
extern void _ZN7S4293C33v17Ev();
extern void _ZN7S4293C33v18Ev();
extern void _ZN7S4293C33v19Ev();
extern void _ZN7S4293C33v20Ev();
extern void _ZN7S4293C33v21Ev();
extern void _ZN7S4293C33v22Ev();
extern void _ZN7S4293C33v23Ev();
extern void _ZN7S4293C33v24Ev();
extern void _ZN7S4293C33v25Ev();
extern void _ZN7S4293C33v26Ev();
extern void _ZN7S4293C33v27Ev();
extern void _ZN7S4293C33v28Ev();
extern void _ZN7S4293C33v29Ev();
extern void _ZN7S4293C33v30Ev();
extern void _ZN7S4293C33v31Ev();
extern void _ZN7S4293C33v32Ev();
extern void _ZN7S4293C33v33Ev();
extern void _ZN7S4293C33v34Ev();
extern void _ZN7S4293C33v35Ev();
extern void _ZN7S4293C33v36Ev();
extern void _ZN7S4293C33v37Ev();
extern void _ZN7S4293C33v38Ev();
extern void _ZN7S4293C33v39Ev();
extern void _ZN7S4293C33v40Ev();
extern void _ZN7S4293C33v41Ev();
extern void _ZN7S4293C23v48Ev();
extern void _ZN7S4293C23v49Ev();
extern void _ZN7S4293C23v50Ev();
extern void _ZN7S4293C23v51Ev();
extern void _ZN7S4293C23v52Ev();
extern void _ZN7S4293C23v53Ev();
extern void _ZN7S4293C23v54Ev();
extern void _ZN7S4293C23v55Ev();
extern void _ZN7S4293C23v56Ev();
extern void _ZN7S4293C23v57Ev();
extern void _ZN7S4293C23v58Ev();
extern void _ZN7S4293C23v59Ev();
extern void _ZN7S4293C23v60Ev();
extern void _ZN7S4293C23v61Ev();
extern void ABISELECT(_ZThn8_N7S4293C2D1Ev,_ZThn4_N7S4293C2D1Ev)();
extern void ABISELECT(_ZThn8_N7S4293C2D0Ev,_ZThn4_N7S4293C2D0Ev)();
extern void _ZN7S4293C53v42Ev();
extern void _ZN7S4293C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4293C2D1Ev,_ZThn8_N7S4293C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S4293C2D0Ev,_ZThn8_N7S4293C2D0Ev)();
extern void _ZN7S4293C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4293C2D1Ev,_ZThn12_N7S4293C2D1Ev)();
extern void ABISELECT(_ZThn24_N7S4293C2D0Ev,_ZThn12_N7S4293C2D0Ev)();
extern void _ZN7S4293C73v44Ev();
extern void _ZN7S4293C73v45Ev();
extern void _ZN7S4293C73v46Ev();
static  VTBL_ENTRY vtc_S4293C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C2[0]),
  (VTBL_ENTRY)&_ZN7S4293C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v61Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4293C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C2D1Ev,_ZThn4_N7S4293C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C2D0Ev,_ZThn4_N7S4293C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4293C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4293C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C2D1Ev,_ZThn8_N7S4293C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C2D0Ev,_ZThn8_N7S4293C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4293C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4293C2D1Ev,_ZThn12_N7S4293C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4293C2D0Ev,_ZThn12_N7S4293C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4293C2[];
extern  VTBL_ENTRY _ZTV7S4293C2[];
Class_Descriptor cd_S4293C2 = {  "S4293C2", // class name
  bases_S4293C2, 5,
  &(vtc_S4293C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,728), // object size
  NSPAIRA(_ZTI7S4293C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4293C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C23  {
  char s4293c23f0[64];
};
//SIG(-1 S4293C23) C1{ Fc[64]}



static void Test_S4293C23()
{
  {
    init_simple_test("S4293C23");
    S4293C23 lv;
    check2(sizeof(lv), 64, "sizeof(S4293C23)");
    check2(__alignof__(lv), 1, "__alignof__(S4293C23)");
    check_field_offset(lv, s4293c23f0, 0, "S4293C23.s4293c23f0");
  }
}
static Arrange_To_Call_Me vS4293C23(Test_S4293C23, "S4293C23", 64);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C22  {
  short s4293c22f0;
  int s4293c22f1;
  short s4293c22f2;
  ::S4293C23 s4293c22f3;
  ::S4291C25 s4293c22f4[2];
};
//SIG(-1 S4293C22) C1{ Fs Fi Fs FC2{ Fc[64]} FC3{ FC4{ Fl} Fs Fc[2] FC5{ Fs Fc[2] Fp Fi}}[2]}



static void Test_S4293C22()
{
  {
    init_simple_test("S4293C22");
    S4293C22 lv;
    check2(sizeof(lv), ABISELECT(160,116), "sizeof(S4293C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C22)");
    check_field_offset(lv, s4293c22f0, 0, "S4293C22.s4293c22f0");
    check_field_offset(lv, s4293c22f1, 4, "S4293C22.s4293c22f1");
    check_field_offset(lv, s4293c22f2, 8, "S4293C22.s4293c22f2");
    check_field_offset(lv, s4293c22f3, 10, "S4293C22.s4293c22f3");
    check_field_offset(lv, s4293c22f4, ABISELECT(80,76), "S4293C22.s4293c22f4");
  }
}
static Arrange_To_Call_Me vS4293C22(Test_S4293C22, "S4293C22", ABISELECT(160,116));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4293C1  : S4293C2 {
  ::S4293C22 s4293c1f0;
  char s4293c1f1;
  virtual  ~S4293C1(); // _ZN7S4293C1D1Ev
  virtual void  v1(); // _ZN7S4293C12v1Ev
  virtual void  v2(); // _ZN7S4293C12v2Ev
  virtual void  v3(); // _ZN7S4293C12v3Ev
  virtual void  v4(); // _ZN7S4293C12v4Ev
  virtual void  v5(); // _ZN7S4293C12v5Ev
  virtual void  v6(); // _ZN7S4293C12v6Ev
  virtual void  v7(); // _ZN7S4293C12v7Ev
  virtual void  v8(); // _ZN7S4293C12v8Ev
  virtual void  v9(); // _ZN7S4293C12v9Ev
  virtual void  v10(); // _ZN7S4293C13v10Ev
  virtual void  v11(); // _ZN7S4293C13v11Ev
  virtual void  v12(); // _ZN7S4293C13v12Ev
  virtual void  v13(); // _ZN7S4293C13v13Ev
  virtual void  v14(); // _ZN7S4293C13v14Ev
  virtual void  v15(); // _ZN7S4293C13v15Ev
  virtual void  v16(); // _ZN7S4293C13v16Ev
  S4293C1(); // tgen
};
//SIG(1 S4293C1) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41} BC4{ BC5{ vd v42} BC6{ vd v43} BC7{ vd v44 v45 v46 Fp} vd v47} vd v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 FC8{ BC9{ vd v63} vd v62 Fp} FC10{ vd v64 v65 v66 Fc Fi FC11{ m Fi} FC12{ m FC13{ Fi Fp} Fi} Fp FC14{ m Fp[2] Fi} FC14 Fp[2] Fi Fp FC15{ BC16{ vd v73 v74 v75 v76 v77 v78 v79 Fi Fp Fi FC17{ Fc[2] Fs FC18{ Fi} Fs Fc[6]} Fi[3] FC19{ m Fi Fp[3]}} vd v67 v68 v69 v70 v71 v72} Fc Fl FC20{ m Fl[2]} Fl FC20} Fi[2] Fc Fs[6] FC21{ Fi Fc[512]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC22{ Fs Fi Fs FC23{ Fc[64]} FC24{ FC25{ Fl} Fs Fc[2] FC26{ Fs Fc[2] Fp Fi}}[2]} Fc}


 S4293C1 ::~S4293C1(){ note_dtor("S4293C1", this);}
void  S4293C1 ::v1(){vfunc_called(this, "_ZN7S4293C12v1Ev");}
void  S4293C1 ::v2(){vfunc_called(this, "_ZN7S4293C12v2Ev");}
void  S4293C1 ::v3(){vfunc_called(this, "_ZN7S4293C12v3Ev");}
void  S4293C1 ::v4(){vfunc_called(this, "_ZN7S4293C12v4Ev");}
void  S4293C1 ::v5(){vfunc_called(this, "_ZN7S4293C12v5Ev");}
void  S4293C1 ::v6(){vfunc_called(this, "_ZN7S4293C12v6Ev");}
void  S4293C1 ::v7(){vfunc_called(this, "_ZN7S4293C12v7Ev");}
void  S4293C1 ::v8(){vfunc_called(this, "_ZN7S4293C12v8Ev");}
void  S4293C1 ::v9(){vfunc_called(this, "_ZN7S4293C12v9Ev");}
void  S4293C1 ::v10(){vfunc_called(this, "_ZN7S4293C13v10Ev");}
void  S4293C1 ::v11(){vfunc_called(this, "_ZN7S4293C13v11Ev");}
void  S4293C1 ::v12(){vfunc_called(this, "_ZN7S4293C13v12Ev");}
void  S4293C1 ::v13(){vfunc_called(this, "_ZN7S4293C13v13Ev");}
void  S4293C1 ::v14(){vfunc_called(this, "_ZN7S4293C13v14Ev");}
void  S4293C1 ::v15(){vfunc_called(this, "_ZN7S4293C13v15Ev");}
void  S4293C1 ::v16(){vfunc_called(this, "_ZN7S4293C13v16Ev");}
S4293C1 ::S4293C1(){ note_ctor("S4293C1", this);} // tgen

static void Test_S4293C1()
{
  extern Class_Descriptor cd_S4293C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(132,213)];
    init_test(&cd_S4293C1, buf);
    S4293C1 *dp, &lv = *(dp=new (buf) S4293C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1048,848), "sizeof(S4293C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4293C1)");
    check_base_class_offset(lv, (S4293C3*)(S4293C2*), 0, "S4293C1");
    check_base_class_offset(lv, (S4293C5*)(S4293C4*)(S4293C2*), ABISELECT(8,4), "S4293C1");
    check_base_class_offset(lv, (S4293C6*)(S4293C4*)(S4293C2*), ABISELECT(16,8), "S4293C1");
    check_base_class_offset(lv, (S4293C7*)(S4293C4*)(S4293C2*), ABISELECT(24,12), "S4293C1");
    check_base_class_offset(lv, (S4293C4*)(S4293C2*), ABISELECT(8,4), "S4293C1");
    check_base_class_offset(lv, (S4293C2*), 0, "S4293C1");
    check_field_offset(lv, s4293c1f0, ABISELECT(880,728), "S4293C1.s4293c1f0");
    check_field_offset(lv, s4293c1f1, ABISELECT(1040,844), "S4293C1.s4293c1f1");
    test_class_info(&lv, &cd_S4293C1);
    dp->~S4293C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4293C1(Test_S4293C1, "S4293C1", ABISELECT(1048,848));

#else // __cplusplus

extern void _ZN7S4293C1C1Ev();
extern void _ZN7S4293C1D1Ev();
Name_Map name_map_S4293C1[] = {
  NSPAIR(_ZN7S4293C1C1Ev),
  NSPAIR(_ZN7S4293C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4293C3;
extern VTBL_ENTRY _ZTI7S4293C3[];
extern  VTBL_ENTRY _ZTV7S4293C3[];
extern Class_Descriptor cd_S4293C5;
extern VTBL_ENTRY _ZTI7S4293C5[];
extern  VTBL_ENTRY _ZTV7S4293C5[];
extern Class_Descriptor cd_S4293C6;
extern VTBL_ENTRY _ZTI7S4293C6[];
extern  VTBL_ENTRY _ZTV7S4293C6[];
extern Class_Descriptor cd_S4293C7;
extern VTBL_ENTRY _ZTI7S4293C7[];
extern  VTBL_ENTRY _ZTV7S4293C7[];
extern Class_Descriptor cd_S4293C4;
extern VTBL_ENTRY _ZTI7S4293C4[];
extern  VTBL_ENTRY _ZTV7S4293C4[];
extern Class_Descriptor cd_S4293C2;
extern VTBL_ENTRY _ZTI7S4293C2[];
extern  VTBL_ENTRY _ZTV7S4293C2[];
static Base_Class bases_S4293C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4293C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4293C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C6,    ABISELECT(16,8), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C7,    ABISELECT(24,12), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4293C4,    ABISELECT(8,4), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4293C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4293C1[];
extern void _ZN7S4293C1D1Ev();
extern void _ZN7S4293C1D0Ev();
extern void _ZN7S4293C33v17Ev();
extern void _ZN7S4293C33v18Ev();
extern void _ZN7S4293C33v19Ev();
extern void _ZN7S4293C33v20Ev();
extern void _ZN7S4293C33v21Ev();
extern void _ZN7S4293C33v22Ev();
extern void _ZN7S4293C33v23Ev();
extern void _ZN7S4293C33v24Ev();
extern void _ZN7S4293C33v25Ev();
extern void _ZN7S4293C33v26Ev();
extern void _ZN7S4293C33v27Ev();
extern void _ZN7S4293C33v28Ev();
extern void _ZN7S4293C33v29Ev();
extern void _ZN7S4293C33v30Ev();
extern void _ZN7S4293C33v31Ev();
extern void _ZN7S4293C33v32Ev();
extern void _ZN7S4293C33v33Ev();
extern void _ZN7S4293C33v34Ev();
extern void _ZN7S4293C33v35Ev();
extern void _ZN7S4293C33v36Ev();
extern void _ZN7S4293C33v37Ev();
extern void _ZN7S4293C33v38Ev();
extern void _ZN7S4293C33v39Ev();
extern void _ZN7S4293C33v40Ev();
extern void _ZN7S4293C33v41Ev();
extern void _ZN7S4293C23v48Ev();
extern void _ZN7S4293C23v49Ev();
extern void _ZN7S4293C23v50Ev();
extern void _ZN7S4293C23v51Ev();
extern void _ZN7S4293C23v52Ev();
extern void _ZN7S4293C23v53Ev();
extern void _ZN7S4293C23v54Ev();
extern void _ZN7S4293C23v55Ev();
extern void _ZN7S4293C23v56Ev();
extern void _ZN7S4293C23v57Ev();
extern void _ZN7S4293C23v58Ev();
extern void _ZN7S4293C23v59Ev();
extern void _ZN7S4293C23v60Ev();
extern void _ZN7S4293C23v61Ev();
extern void _ZN7S4293C12v1Ev();
extern void _ZN7S4293C12v2Ev();
extern void _ZN7S4293C12v3Ev();
extern void _ZN7S4293C12v4Ev();
extern void _ZN7S4293C12v5Ev();
extern void _ZN7S4293C12v6Ev();
extern void _ZN7S4293C12v7Ev();
extern void _ZN7S4293C12v8Ev();
extern void _ZN7S4293C12v9Ev();
extern void _ZN7S4293C13v10Ev();
extern void _ZN7S4293C13v11Ev();
extern void _ZN7S4293C13v12Ev();
extern void _ZN7S4293C13v13Ev();
extern void _ZN7S4293C13v14Ev();
extern void _ZN7S4293C13v15Ev();
extern void _ZN7S4293C13v16Ev();
extern void ABISELECT(_ZThn8_N7S4293C1D1Ev,_ZThn4_N7S4293C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S4293C1D0Ev,_ZThn4_N7S4293C1D0Ev)();
extern void _ZN7S4293C53v42Ev();
extern void _ZN7S4293C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4293C1D1Ev,_ZThn8_N7S4293C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S4293C1D0Ev,_ZThn8_N7S4293C1D0Ev)();
extern void _ZN7S4293C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4293C1D1Ev,_ZThn12_N7S4293C1D1Ev)();
extern void ABISELECT(_ZThn24_N7S4293C1D0Ev,_ZThn12_N7S4293C1D0Ev)();
extern void _ZN7S4293C73v44Ev();
extern void _ZN7S4293C73v45Ev();
extern void _ZN7S4293C73v46Ev();
static  VTBL_ENTRY vtc_S4293C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4293C1[0]),
  (VTBL_ENTRY)&_ZN7S4293C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4293C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4293C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4293C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4293C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4293C13v16Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4293C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C1D1Ev,_ZThn4_N7S4293C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4293C1D0Ev,_ZThn4_N7S4293C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4293C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4293C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C1D1Ev,_ZThn8_N7S4293C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4293C1D0Ev,_ZThn8_N7S4293C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4293C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4293C1D1Ev,_ZThn12_N7S4293C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4293C1D0Ev,_ZThn12_N7S4293C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4293C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4293C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4293C1[];
extern  VTBL_ENTRY _ZTV7S4293C1[];
Class_Descriptor cd_S4293C1 = {  "S4293C1", // class name
  bases_S4293C1, 6,
  &(vtc_S4293C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1048,848), // object size
  NSPAIRA(_ZTI7S4293C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4293C1),77, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C3  {
  virtual  ~S4294C3(); // _ZN7S4294C3D1Ev
  virtual void  v17(); // _ZN7S4294C33v17Ev
  virtual void  v18(); // _ZN7S4294C33v18Ev
  virtual void  v19(); // _ZN7S4294C33v19Ev
  virtual void  v20(); // _ZN7S4294C33v20Ev
  virtual void  v21(); // _ZN7S4294C33v21Ev
  virtual void  v22(); // _ZN7S4294C33v22Ev
  virtual void  v23(); // _ZN7S4294C33v23Ev
  virtual void  v24(); // _ZN7S4294C33v24Ev
  virtual void  v25(); // _ZN7S4294C33v25Ev
  virtual void  v26(); // _ZN7S4294C33v26Ev
  virtual void  v27(); // _ZN7S4294C33v27Ev
  virtual void  v28(); // _ZN7S4294C33v28Ev
  virtual void  v29(); // _ZN7S4294C33v29Ev
  virtual void  v30(); // _ZN7S4294C33v30Ev
  virtual void  v31(); // _ZN7S4294C33v31Ev
  virtual void  v32(); // _ZN7S4294C33v32Ev
  virtual void  v33(); // _ZN7S4294C33v33Ev
  virtual void  v34(); // _ZN7S4294C33v34Ev
  virtual void  v35(); // _ZN7S4294C33v35Ev
  virtual void  v36(); // _ZN7S4294C33v36Ev
  virtual void  v37(); // _ZN7S4294C33v37Ev
  virtual void  v38(); // _ZN7S4294C33v38Ev
  virtual void  v39(); // _ZN7S4294C33v39Ev
  virtual void  v40(); // _ZN7S4294C33v40Ev
  virtual void  v41(); // _ZN7S4294C33v41Ev
  S4294C3(); // tgen
};
//SIG(-1 S4294C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25}


 S4294C3 ::~S4294C3(){ note_dtor("S4294C3", this);}
void  S4294C3 ::v17(){vfunc_called(this, "_ZN7S4294C33v17Ev");}
void  S4294C3 ::v18(){vfunc_called(this, "_ZN7S4294C33v18Ev");}
void  S4294C3 ::v19(){vfunc_called(this, "_ZN7S4294C33v19Ev");}
void  S4294C3 ::v20(){vfunc_called(this, "_ZN7S4294C33v20Ev");}
void  S4294C3 ::v21(){vfunc_called(this, "_ZN7S4294C33v21Ev");}
void  S4294C3 ::v22(){vfunc_called(this, "_ZN7S4294C33v22Ev");}
void  S4294C3 ::v23(){vfunc_called(this, "_ZN7S4294C33v23Ev");}
void  S4294C3 ::v24(){vfunc_called(this, "_ZN7S4294C33v24Ev");}
void  S4294C3 ::v25(){vfunc_called(this, "_ZN7S4294C33v25Ev");}
void  S4294C3 ::v26(){vfunc_called(this, "_ZN7S4294C33v26Ev");}
void  S4294C3 ::v27(){vfunc_called(this, "_ZN7S4294C33v27Ev");}
void  S4294C3 ::v28(){vfunc_called(this, "_ZN7S4294C33v28Ev");}
void  S4294C3 ::v29(){vfunc_called(this, "_ZN7S4294C33v29Ev");}
void  S4294C3 ::v30(){vfunc_called(this, "_ZN7S4294C33v30Ev");}
void  S4294C3 ::v31(){vfunc_called(this, "_ZN7S4294C33v31Ev");}
void  S4294C3 ::v32(){vfunc_called(this, "_ZN7S4294C33v32Ev");}
void  S4294C3 ::v33(){vfunc_called(this, "_ZN7S4294C33v33Ev");}
void  S4294C3 ::v34(){vfunc_called(this, "_ZN7S4294C33v34Ev");}
void  S4294C3 ::v35(){vfunc_called(this, "_ZN7S4294C33v35Ev");}
void  S4294C3 ::v36(){vfunc_called(this, "_ZN7S4294C33v36Ev");}
void  S4294C3 ::v37(){vfunc_called(this, "_ZN7S4294C33v37Ev");}
void  S4294C3 ::v38(){vfunc_called(this, "_ZN7S4294C33v38Ev");}
void  S4294C3 ::v39(){vfunc_called(this, "_ZN7S4294C33v39Ev");}
void  S4294C3 ::v40(){vfunc_called(this, "_ZN7S4294C33v40Ev");}
void  S4294C3 ::v41(){vfunc_called(this, "_ZN7S4294C33v41Ev");}
S4294C3 ::S4294C3(){ note_ctor("S4294C3", this);} // tgen

static void Test_S4294C3()
{
  extern Class_Descriptor cd_S4294C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4294C3, buf);
    S4294C3 *dp, &lv = *(dp=new (buf) S4294C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4294C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C3)");
    test_class_info(&lv, &cd_S4294C3);
    dp->~S4294C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C3(Test_S4294C3, "S4294C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4294C3C1Ev();
extern void _ZN7S4294C3D1Ev();
Name_Map name_map_S4294C3[] = {
  NSPAIR(_ZN7S4294C3C1Ev),
  NSPAIR(_ZN7S4294C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4294C3[];
extern void _ZN7S4294C3D1Ev();
extern void _ZN7S4294C3D0Ev();
extern void _ZN7S4294C33v17Ev();
extern void _ZN7S4294C33v18Ev();
extern void _ZN7S4294C33v19Ev();
extern void _ZN7S4294C33v20Ev();
extern void _ZN7S4294C33v21Ev();
extern void _ZN7S4294C33v22Ev();
extern void _ZN7S4294C33v23Ev();
extern void _ZN7S4294C33v24Ev();
extern void _ZN7S4294C33v25Ev();
extern void _ZN7S4294C33v26Ev();
extern void _ZN7S4294C33v27Ev();
extern void _ZN7S4294C33v28Ev();
extern void _ZN7S4294C33v29Ev();
extern void _ZN7S4294C33v30Ev();
extern void _ZN7S4294C33v31Ev();
extern void _ZN7S4294C33v32Ev();
extern void _ZN7S4294C33v33Ev();
extern void _ZN7S4294C33v34Ev();
extern void _ZN7S4294C33v35Ev();
extern void _ZN7S4294C33v36Ev();
extern void _ZN7S4294C33v37Ev();
extern void _ZN7S4294C33v38Ev();
extern void _ZN7S4294C33v39Ev();
extern void _ZN7S4294C33v40Ev();
extern void _ZN7S4294C33v41Ev();
static  VTBL_ENTRY vtc_S4294C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C3[0]),
  (VTBL_ENTRY)&_ZN7S4294C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v41Ev,
};
extern VTBL_ENTRY _ZTI7S4294C3[];
extern  VTBL_ENTRY _ZTV7S4294C3[];
Class_Descriptor cd_S4294C3 = {  "S4294C3", // class name
  0,0,//no base classes
  &(vtc_S4294C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4294C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4294C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C5  {
  virtual  ~S4294C5(); // _ZN7S4294C5D1Ev
  virtual void  v42(); // _ZN7S4294C53v42Ev
  S4294C5(); // tgen
};
//SIG(-1 S4294C5) C1{ vd v1}


 S4294C5 ::~S4294C5(){ note_dtor("S4294C5", this);}
void  S4294C5 ::v42(){vfunc_called(this, "_ZN7S4294C53v42Ev");}
S4294C5 ::S4294C5(){ note_ctor("S4294C5", this);} // tgen

static void Test_S4294C5()
{
  extern Class_Descriptor cd_S4294C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4294C5, buf);
    S4294C5 *dp, &lv = *(dp=new (buf) S4294C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4294C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C5)");
    test_class_info(&lv, &cd_S4294C5);
    dp->~S4294C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C5(Test_S4294C5, "S4294C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4294C5C1Ev();
extern void _ZN7S4294C5D1Ev();
Name_Map name_map_S4294C5[] = {
  NSPAIR(_ZN7S4294C5C1Ev),
  NSPAIR(_ZN7S4294C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4294C5[];
extern void _ZN7S4294C5D1Ev();
extern void _ZN7S4294C5D0Ev();
extern void _ZN7S4294C53v42Ev();
static  VTBL_ENTRY vtc_S4294C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C5[0]),
  (VTBL_ENTRY)&_ZN7S4294C5D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C5D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C53v42Ev,
};
extern VTBL_ENTRY _ZTI7S4294C5[];
extern  VTBL_ENTRY _ZTV7S4294C5[];
Class_Descriptor cd_S4294C5 = {  "S4294C5", // class name
  0,0,//no base classes
  &(vtc_S4294C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4294C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4294C5),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C6  {
  virtual  ~S4294C6(); // _ZN7S4294C6D1Ev
  virtual void  v43(); // _ZN7S4294C63v43Ev
  S4294C6(); // tgen
};
//SIG(-1 S4294C6) C1{ vd v1}


 S4294C6 ::~S4294C6(){ note_dtor("S4294C6", this);}
void  S4294C6 ::v43(){vfunc_called(this, "_ZN7S4294C63v43Ev");}
S4294C6 ::S4294C6(){ note_ctor("S4294C6", this);} // tgen

static void Test_S4294C6()
{
  extern Class_Descriptor cd_S4294C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4294C6, buf);
    S4294C6 *dp, &lv = *(dp=new (buf) S4294C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4294C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C6)");
    test_class_info(&lv, &cd_S4294C6);
    dp->~S4294C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C6(Test_S4294C6, "S4294C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4294C6C1Ev();
extern void _ZN7S4294C6D1Ev();
Name_Map name_map_S4294C6[] = {
  NSPAIR(_ZN7S4294C6C1Ev),
  NSPAIR(_ZN7S4294C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4294C6[];
extern void _ZN7S4294C6D1Ev();
extern void _ZN7S4294C6D0Ev();
extern void _ZN7S4294C63v43Ev();
static  VTBL_ENTRY vtc_S4294C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C6[0]),
  (VTBL_ENTRY)&_ZN7S4294C6D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C6D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C63v43Ev,
};
extern VTBL_ENTRY _ZTI7S4294C6[];
extern  VTBL_ENTRY _ZTV7S4294C6[];
Class_Descriptor cd_S4294C6 = {  "S4294C6", // class name
  0,0,//no base classes
  &(vtc_S4294C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4294C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4294C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C7  {
  void *s4294c7f0;
  virtual  ~S4294C7(); // _ZN7S4294C7D1Ev
  virtual void  v44(); // _ZN7S4294C73v44Ev
  virtual void  v45(); // _ZN7S4294C73v45Ev
  virtual void  v46(); // _ZN7S4294C73v46Ev
  S4294C7(); // tgen
};
//SIG(-1 S4294C7) C1{ vd v1 v2 v3 Fp}


 S4294C7 ::~S4294C7(){ note_dtor("S4294C7", this);}
void  S4294C7 ::v44(){vfunc_called(this, "_ZN7S4294C73v44Ev");}
void  S4294C7 ::v45(){vfunc_called(this, "_ZN7S4294C73v45Ev");}
void  S4294C7 ::v46(){vfunc_called(this, "_ZN7S4294C73v46Ev");}
S4294C7 ::S4294C7(){ note_ctor("S4294C7", this);} // tgen

static void Test_S4294C7()
{
  extern Class_Descriptor cd_S4294C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4294C7, buf);
    S4294C7 *dp, &lv = *(dp=new (buf) S4294C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4294C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C7)");
    check_field_offset(lv, s4294c7f0, ABISELECT(8,4), "S4294C7.s4294c7f0");
    test_class_info(&lv, &cd_S4294C7);
    dp->~S4294C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C7(Test_S4294C7, "S4294C7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S4294C7C1Ev();
extern void _ZN7S4294C7D1Ev();
Name_Map name_map_S4294C7[] = {
  NSPAIR(_ZN7S4294C7C1Ev),
  NSPAIR(_ZN7S4294C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4294C7[];
extern void _ZN7S4294C7D1Ev();
extern void _ZN7S4294C7D0Ev();
extern void _ZN7S4294C73v44Ev();
extern void _ZN7S4294C73v45Ev();
extern void _ZN7S4294C73v46Ev();
static  VTBL_ENTRY vtc_S4294C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C7[0]),
  (VTBL_ENTRY)&_ZN7S4294C7D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C7D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4294C7[];
extern  VTBL_ENTRY _ZTV7S4294C7[];
Class_Descriptor cd_S4294C7 = {  "S4294C7", // class name
  0,0,//no base classes
  &(vtc_S4294C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S4294C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4294C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C4  : S4294C5 , S4294C6 , S4294C7 {
  virtual  ~S4294C4(); // _ZN7S4294C4D1Ev
  virtual void  v47(); // _ZN7S4294C43v47Ev
  S4294C4(); // tgen
};
//SIG(-1 S4294C4) C1{ BC2{ vd v2} BC3{ vd v3} BC4{ vd v4 v5 v6 Fp} vd v1}


 S4294C4 ::~S4294C4(){ note_dtor("S4294C4", this);}
void  S4294C4 ::v47(){vfunc_called(this, "_ZN7S4294C43v47Ev");}
S4294C4 ::S4294C4(){ note_ctor("S4294C4", this);} // tgen

static void Test_S4294C4()
{
  extern Class_Descriptor cd_S4294C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S4294C4, buf);
    S4294C4 *dp, &lv = *(dp=new (buf) S4294C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S4294C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C4)");
    check_base_class_offset(lv, (S4294C5*), 0, "S4294C4");
    check_base_class_offset(lv, (S4294C6*), ABISELECT(8,4), "S4294C4");
    check_base_class_offset(lv, (S4294C7*), ABISELECT(16,8), "S4294C4");
    test_class_info(&lv, &cd_S4294C4);
    dp->~S4294C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C4(Test_S4294C4, "S4294C4", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN7S4294C4C1Ev();
extern void _ZN7S4294C4D1Ev();
Name_Map name_map_S4294C4[] = {
  NSPAIR(_ZN7S4294C4C1Ev),
  NSPAIR(_ZN7S4294C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4294C5;
extern VTBL_ENTRY _ZTI7S4294C5[];
extern  VTBL_ENTRY _ZTV7S4294C5[];
extern Class_Descriptor cd_S4294C6;
extern VTBL_ENTRY _ZTI7S4294C6[];
extern  VTBL_ENTRY _ZTV7S4294C6[];
extern Class_Descriptor cd_S4294C7;
extern VTBL_ENTRY _ZTI7S4294C7[];
extern  VTBL_ENTRY _ZTV7S4294C7[];
static Base_Class bases_S4294C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4294C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4294C6,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4294C7,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4294C4[];
extern void _ZN7S4294C4D1Ev();
extern void _ZN7S4294C4D0Ev();
extern void _ZN7S4294C53v42Ev();
extern void _ZN7S4294C43v47Ev();
extern void ABISELECT(_ZThn8_N7S4294C4D1Ev,_ZThn4_N7S4294C4D1Ev)();
extern void ABISELECT(_ZThn8_N7S4294C4D0Ev,_ZThn4_N7S4294C4D0Ev)();
extern void _ZN7S4294C63v43Ev();
extern void ABISELECT(_ZThn16_N7S4294C4D1Ev,_ZThn8_N7S4294C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S4294C4D0Ev,_ZThn8_N7S4294C4D0Ev)();
extern void _ZN7S4294C73v44Ev();
extern void _ZN7S4294C73v45Ev();
extern void _ZN7S4294C73v46Ev();
static  VTBL_ENTRY vtc_S4294C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C4[0]),
  (VTBL_ENTRY)&_ZN7S4294C4D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C4D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4294C43v47Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4294C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C4D1Ev,_ZThn4_N7S4294C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C4D0Ev,_ZThn4_N7S4294C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C63v43Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4294C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C4D1Ev,_ZThn8_N7S4294C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C4D0Ev,_ZThn8_N7S4294C4D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4294C4[];
extern  VTBL_ENTRY _ZTV7S4294C4[];
Class_Descriptor cd_S4294C4 = {  "S4294C4", // class name
  bases_S4294C4, 3,
  &(vtc_S4294C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S4294C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S4294C4),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C2  : S4294C3 , S4294C4 {
  ::S10248C23 s4294c2f0;
  ::S10249C25 s4294c2f1;
  int s4294c2f2[2];
  char s4294c2f3;
  short s4294c2f4[6];
  ::S10249C21 s4294c2f5;
  virtual  ~S4294C2(); // _ZN7S4294C2D1Ev
  virtual void  v48(); // _ZN7S4294C23v48Ev
  virtual void  v49(); // _ZN7S4294C23v49Ev
  virtual void  v50(); // _ZN7S4294C23v50Ev
  virtual void  v51(); // _ZN7S4294C23v51Ev
  virtual void  v52(); // _ZN7S4294C23v52Ev
  virtual void  v53(); // _ZN7S4294C23v53Ev
  virtual void  v54(); // _ZN7S4294C23v54Ev
  virtual void  v55(); // _ZN7S4294C23v55Ev
  virtual void  v56(); // _ZN7S4294C23v56Ev
  virtual void  v57(); // _ZN7S4294C23v57Ev
  virtual void  v58(); // _ZN7S4294C23v58Ev
  virtual void  v59(); // _ZN7S4294C23v59Ev
  virtual void  v60(); // _ZN7S4294C23v60Ev
  virtual void  v61(); // _ZN7S4294C23v61Ev
  S4294C2(); // tgen
};
//SIG(-1 S4294C2) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39} BC3{ BC4{ vd v40} BC5{ vd v41} BC6{ vd v42 v43 v44 Fp} vd v45} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC7{ BC8{ vd v47} vd v46 Fp} FC9{ vd v48 v49 v50 Fc Fi FC10{ m Fi} FC11{ m FC12{ Fi Fp} Fi} Fp FC13{ m Fp[2] Fi} FC13 Fp[2] Fi Fp FC14{ BC15{ vd v57 v58 v59 v60 v61 v62 v63 Fi Fp Fi FC16{ Fc[2] Fs FC17{ Fi} Fs Fc[6]} Fi[3] FC18{ m Fi Fp[3]}} vd v51 v52 v53 v54 v55 v56} Fc FL FC19{ m FL[2]} FL FC19} Fi[2] Fc Fs[6] FC20{ Fi Fc[512]}}


 S4294C2 ::~S4294C2(){ note_dtor("S4294C2", this);}
void  S4294C2 ::v48(){vfunc_called(this, "_ZN7S4294C23v48Ev");}
void  S4294C2 ::v49(){vfunc_called(this, "_ZN7S4294C23v49Ev");}
void  S4294C2 ::v50(){vfunc_called(this, "_ZN7S4294C23v50Ev");}
void  S4294C2 ::v51(){vfunc_called(this, "_ZN7S4294C23v51Ev");}
void  S4294C2 ::v52(){vfunc_called(this, "_ZN7S4294C23v52Ev");}
void  S4294C2 ::v53(){vfunc_called(this, "_ZN7S4294C23v53Ev");}
void  S4294C2 ::v54(){vfunc_called(this, "_ZN7S4294C23v54Ev");}
void  S4294C2 ::v55(){vfunc_called(this, "_ZN7S4294C23v55Ev");}
void  S4294C2 ::v56(){vfunc_called(this, "_ZN7S4294C23v56Ev");}
void  S4294C2 ::v57(){vfunc_called(this, "_ZN7S4294C23v57Ev");}
void  S4294C2 ::v58(){vfunc_called(this, "_ZN7S4294C23v58Ev");}
void  S4294C2 ::v59(){vfunc_called(this, "_ZN7S4294C23v59Ev");}
void  S4294C2 ::v60(){vfunc_called(this, "_ZN7S4294C23v60Ev");}
void  S4294C2 ::v61(){vfunc_called(this, "_ZN7S4294C23v61Ev");}
S4294C2 ::S4294C2(){ note_ctor("S4294C2", this);} // tgen

static void Test_S4294C2()
{
  extern Class_Descriptor cd_S4294C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(111,189)];
    init_test(&cd_S4294C2, buf);
    S4294C2 *dp, &lv = *(dp=new (buf) S4294C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(880,752), "sizeof(S4294C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C2)");
    check_base_class_offset(lv, (S4294C3*), 0, "S4294C2");
    check_base_class_offset(lv, (S4294C5*)(S4294C4*), ABISELECT(8,4), "S4294C2");
    check_base_class_offset(lv, (S4294C6*)(S4294C4*), ABISELECT(16,8), "S4294C2");
    check_base_class_offset(lv, (S4294C7*)(S4294C4*), ABISELECT(24,12), "S4294C2");
    check_base_class_offset(lv, (S4294C4*), ABISELECT(8,4), "S4294C2");
    check_field_offset(lv, s4294c2f0, ABISELECT(40,20), "S4294C2.s4294c2f0");
    check_field_offset(lv, s4294c2f1, ABISELECT(56,28), "S4294C2.s4294c2f1");
    check_field_offset(lv, s4294c2f2, ABISELECT(336,212), "S4294C2.s4294c2f2");
    check_field_offset(lv, s4294c2f3, ABISELECT(344,220), "S4294C2.s4294c2f3");
    check_field_offset(lv, s4294c2f4, ABISELECT(346,222), "S4294C2.s4294c2f4");
    check_field_offset(lv, s4294c2f5, ABISELECT(360,236), "S4294C2.s4294c2f5");
    test_class_info(&lv, &cd_S4294C2);
    dp->~S4294C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C2(Test_S4294C2, "S4294C2", ABISELECT(880,752));

#else // __cplusplus

extern void _ZN7S4294C2C1Ev();
extern void _ZN7S4294C2D1Ev();
Name_Map name_map_S4294C2[] = {
  NSPAIR(_ZN7S4294C2C1Ev),
  NSPAIR(_ZN7S4294C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4294C3;
extern VTBL_ENTRY _ZTI7S4294C3[];
extern  VTBL_ENTRY _ZTV7S4294C3[];
extern Class_Descriptor cd_S4294C5;
extern VTBL_ENTRY _ZTI7S4294C5[];
extern  VTBL_ENTRY _ZTV7S4294C5[];
extern Class_Descriptor cd_S4294C6;
extern VTBL_ENTRY _ZTI7S4294C6[];
extern  VTBL_ENTRY _ZTV7S4294C6[];
extern Class_Descriptor cd_S4294C7;
extern VTBL_ENTRY _ZTI7S4294C7[];
extern  VTBL_ENTRY _ZTV7S4294C7[];
extern Class_Descriptor cd_S4294C4;
extern VTBL_ENTRY _ZTI7S4294C4[];
extern  VTBL_ENTRY _ZTV7S4294C4[];
static Base_Class bases_S4294C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4294C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4294C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C6,    ABISELECT(16,8), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C7,    ABISELECT(24,12), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C4,    ABISELECT(8,4), //bcp->offset
    43, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4294C2[];
extern void _ZN7S4294C2D1Ev();
extern void _ZN7S4294C2D0Ev();
extern void _ZN7S4294C33v17Ev();
extern void _ZN7S4294C33v18Ev();
extern void _ZN7S4294C33v19Ev();
extern void _ZN7S4294C33v20Ev();
extern void _ZN7S4294C33v21Ev();
extern void _ZN7S4294C33v22Ev();
extern void _ZN7S4294C33v23Ev();
extern void _ZN7S4294C33v24Ev();
extern void _ZN7S4294C33v25Ev();
extern void _ZN7S4294C33v26Ev();
extern void _ZN7S4294C33v27Ev();
extern void _ZN7S4294C33v28Ev();
extern void _ZN7S4294C33v29Ev();
extern void _ZN7S4294C33v30Ev();
extern void _ZN7S4294C33v31Ev();
extern void _ZN7S4294C33v32Ev();
extern void _ZN7S4294C33v33Ev();
extern void _ZN7S4294C33v34Ev();
extern void _ZN7S4294C33v35Ev();
extern void _ZN7S4294C33v36Ev();
extern void _ZN7S4294C33v37Ev();
extern void _ZN7S4294C33v38Ev();
extern void _ZN7S4294C33v39Ev();
extern void _ZN7S4294C33v40Ev();
extern void _ZN7S4294C33v41Ev();
extern void _ZN7S4294C23v48Ev();
extern void _ZN7S4294C23v49Ev();
extern void _ZN7S4294C23v50Ev();
extern void _ZN7S4294C23v51Ev();
extern void _ZN7S4294C23v52Ev();
extern void _ZN7S4294C23v53Ev();
extern void _ZN7S4294C23v54Ev();
extern void _ZN7S4294C23v55Ev();
extern void _ZN7S4294C23v56Ev();
extern void _ZN7S4294C23v57Ev();
extern void _ZN7S4294C23v58Ev();
extern void _ZN7S4294C23v59Ev();
extern void _ZN7S4294C23v60Ev();
extern void _ZN7S4294C23v61Ev();
extern void ABISELECT(_ZThn8_N7S4294C2D1Ev,_ZThn4_N7S4294C2D1Ev)();
extern void ABISELECT(_ZThn8_N7S4294C2D0Ev,_ZThn4_N7S4294C2D0Ev)();
extern void _ZN7S4294C53v42Ev();
extern void _ZN7S4294C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4294C2D1Ev,_ZThn8_N7S4294C2D1Ev)();
extern void ABISELECT(_ZThn16_N7S4294C2D0Ev,_ZThn8_N7S4294C2D0Ev)();
extern void _ZN7S4294C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4294C2D1Ev,_ZThn12_N7S4294C2D1Ev)();
extern void ABISELECT(_ZThn24_N7S4294C2D0Ev,_ZThn12_N7S4294C2D0Ev)();
extern void _ZN7S4294C73v44Ev();
extern void _ZN7S4294C73v45Ev();
extern void _ZN7S4294C73v46Ev();
static  VTBL_ENTRY vtc_S4294C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C2[0]),
  (VTBL_ENTRY)&_ZN7S4294C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v61Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4294C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C2D1Ev,_ZThn4_N7S4294C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C2D0Ev,_ZThn4_N7S4294C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4294C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4294C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C2D1Ev,_ZThn8_N7S4294C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C2D0Ev,_ZThn8_N7S4294C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4294C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4294C2D1Ev,_ZThn12_N7S4294C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4294C2D0Ev,_ZThn12_N7S4294C2D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4294C2[];
extern  VTBL_ENTRY _ZTV7S4294C2[];
Class_Descriptor cd_S4294C2 = {  "S4294C2", // class name
  bases_S4294C2, 5,
  &(vtc_S4294C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,752), // object size
  NSPAIRA(_ZTI7S4294C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4294C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C22  {
  short s4294c22f0;
  int s4294c22f1;
  short s4294c22f2;
  ::S4293C23 s4294c22f3;
  ::S4292C25 s4294c22f4[2];
};
//SIG(-1 S4294C22) C1{ Fs Fi Fs FC2{ Fc[64]} FC3{ FC4{ FL} Fs Fc[2] FC5{ Fs Fc[2] Fp Fi}}[2]}



static void Test_S4294C22()
{
  {
    init_simple_test("S4294C22");
    S4294C22 lv;
    check2(sizeof(lv), ABISELECT(160,124), "sizeof(S4294C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C22)");
    check_field_offset(lv, s4294c22f0, 0, "S4294C22.s4294c22f0");
    check_field_offset(lv, s4294c22f1, 4, "S4294C22.s4294c22f1");
    check_field_offset(lv, s4294c22f2, 8, "S4294C22.s4294c22f2");
    check_field_offset(lv, s4294c22f3, 10, "S4294C22.s4294c22f3");
    check_field_offset(lv, s4294c22f4, ABISELECT(80,76), "S4294C22.s4294c22f4");
  }
}
static Arrange_To_Call_Me vS4294C22(Test_S4294C22, "S4294C22", ABISELECT(160,124));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4294C1  : S4294C2 {
  ::S4294C22 s4294c1f0;
  char s4294c1f1;
  virtual  ~S4294C1(); // _ZN7S4294C1D1Ev
  virtual void  v1(); // _ZN7S4294C12v1Ev
  virtual void  v2(); // _ZN7S4294C12v2Ev
  virtual void  v3(); // _ZN7S4294C12v3Ev
  virtual void  v4(); // _ZN7S4294C12v4Ev
  virtual void  v5(); // _ZN7S4294C12v5Ev
  virtual void  v6(); // _ZN7S4294C12v6Ev
  virtual void  v7(); // _ZN7S4294C12v7Ev
  virtual void  v8(); // _ZN7S4294C12v8Ev
  virtual void  v9(); // _ZN7S4294C12v9Ev
  virtual void  v10(); // _ZN7S4294C13v10Ev
  virtual void  v11(); // _ZN7S4294C13v11Ev
  virtual void  v12(); // _ZN7S4294C13v12Ev
  virtual void  v13(); // _ZN7S4294C13v13Ev
  virtual void  v14(); // _ZN7S4294C13v14Ev
  virtual void  v15(); // _ZN7S4294C13v15Ev
  virtual void  v16(); // _ZN7S4294C13v16Ev
  S4294C1(); // tgen
};
//SIG(1 S4294C1) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41} BC4{ BC5{ vd v42} BC6{ vd v43} BC7{ vd v44 v45 v46 Fp} vd v47} vd v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 FC8{ BC9{ vd v63} vd v62 Fp} FC10{ vd v64 v65 v66 Fc Fi FC11{ m Fi} FC12{ m FC13{ Fi Fp} Fi} Fp FC14{ m Fp[2] Fi} FC14 Fp[2] Fi Fp FC15{ BC16{ vd v73 v74 v75 v76 v77 v78 v79 Fi Fp Fi FC17{ Fc[2] Fs FC18{ Fi} Fs Fc[6]} Fi[3] FC19{ m Fi Fp[3]}} vd v67 v68 v69 v70 v71 v72} Fc FL FC20{ m FL[2]} FL FC20} Fi[2] Fc Fs[6] FC21{ Fi Fc[512]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC22{ Fs Fi Fs FC23{ Fc[64]} FC24{ FC25{ FL} Fs Fc[2] FC26{ Fs Fc[2] Fp Fi}}[2]} Fc}


 S4294C1 ::~S4294C1(){ note_dtor("S4294C1", this);}
void  S4294C1 ::v1(){vfunc_called(this, "_ZN7S4294C12v1Ev");}
void  S4294C1 ::v2(){vfunc_called(this, "_ZN7S4294C12v2Ev");}
void  S4294C1 ::v3(){vfunc_called(this, "_ZN7S4294C12v3Ev");}
void  S4294C1 ::v4(){vfunc_called(this, "_ZN7S4294C12v4Ev");}
void  S4294C1 ::v5(){vfunc_called(this, "_ZN7S4294C12v5Ev");}
void  S4294C1 ::v6(){vfunc_called(this, "_ZN7S4294C12v6Ev");}
void  S4294C1 ::v7(){vfunc_called(this, "_ZN7S4294C12v7Ev");}
void  S4294C1 ::v8(){vfunc_called(this, "_ZN7S4294C12v8Ev");}
void  S4294C1 ::v9(){vfunc_called(this, "_ZN7S4294C12v9Ev");}
void  S4294C1 ::v10(){vfunc_called(this, "_ZN7S4294C13v10Ev");}
void  S4294C1 ::v11(){vfunc_called(this, "_ZN7S4294C13v11Ev");}
void  S4294C1 ::v12(){vfunc_called(this, "_ZN7S4294C13v12Ev");}
void  S4294C1 ::v13(){vfunc_called(this, "_ZN7S4294C13v13Ev");}
void  S4294C1 ::v14(){vfunc_called(this, "_ZN7S4294C13v14Ev");}
void  S4294C1 ::v15(){vfunc_called(this, "_ZN7S4294C13v15Ev");}
void  S4294C1 ::v16(){vfunc_called(this, "_ZN7S4294C13v16Ev");}
S4294C1 ::S4294C1(){ note_ctor("S4294C1", this);} // tgen

static void Test_S4294C1()
{
  extern Class_Descriptor cd_S4294C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(132,221)];
    init_test(&cd_S4294C1, buf);
    S4294C1 *dp, &lv = *(dp=new (buf) S4294C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1048,880), "sizeof(S4294C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4294C1)");
    check_base_class_offset(lv, (S4294C3*)(S4294C2*), 0, "S4294C1");
    check_base_class_offset(lv, (S4294C5*)(S4294C4*)(S4294C2*), ABISELECT(8,4), "S4294C1");
    check_base_class_offset(lv, (S4294C6*)(S4294C4*)(S4294C2*), ABISELECT(16,8), "S4294C1");
    check_base_class_offset(lv, (S4294C7*)(S4294C4*)(S4294C2*), ABISELECT(24,12), "S4294C1");
    check_base_class_offset(lv, (S4294C4*)(S4294C2*), ABISELECT(8,4), "S4294C1");
    check_base_class_offset(lv, (S4294C2*), 0, "S4294C1");
    check_field_offset(lv, s4294c1f0, ABISELECT(880,752), "S4294C1.s4294c1f0");
    check_field_offset(lv, s4294c1f1, ABISELECT(1040,876), "S4294C1.s4294c1f1");
    test_class_info(&lv, &cd_S4294C1);
    dp->~S4294C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4294C1(Test_S4294C1, "S4294C1", ABISELECT(1048,880));

#else // __cplusplus

extern void _ZN7S4294C1C1Ev();
extern void _ZN7S4294C1D1Ev();
Name_Map name_map_S4294C1[] = {
  NSPAIR(_ZN7S4294C1C1Ev),
  NSPAIR(_ZN7S4294C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4294C3;
extern VTBL_ENTRY _ZTI7S4294C3[];
extern  VTBL_ENTRY _ZTV7S4294C3[];
extern Class_Descriptor cd_S4294C5;
extern VTBL_ENTRY _ZTI7S4294C5[];
extern  VTBL_ENTRY _ZTV7S4294C5[];
extern Class_Descriptor cd_S4294C6;
extern VTBL_ENTRY _ZTI7S4294C6[];
extern  VTBL_ENTRY _ZTV7S4294C6[];
extern Class_Descriptor cd_S4294C7;
extern VTBL_ENTRY _ZTI7S4294C7[];
extern  VTBL_ENTRY _ZTV7S4294C7[];
extern Class_Descriptor cd_S4294C4;
extern VTBL_ENTRY _ZTI7S4294C4[];
extern  VTBL_ENTRY _ZTV7S4294C4[];
extern Class_Descriptor cd_S4294C2;
extern VTBL_ENTRY _ZTI7S4294C2[];
extern  VTBL_ENTRY _ZTV7S4294C2[];
static Base_Class bases_S4294C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4294C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4294C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C6,    ABISELECT(16,8), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C7,    ABISELECT(24,12), //bcp->offset
    70, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S4294C4,    ABISELECT(8,4), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S4294C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4294C1[];
extern void _ZN7S4294C1D1Ev();
extern void _ZN7S4294C1D0Ev();
extern void _ZN7S4294C33v17Ev();
extern void _ZN7S4294C33v18Ev();
extern void _ZN7S4294C33v19Ev();
extern void _ZN7S4294C33v20Ev();
extern void _ZN7S4294C33v21Ev();
extern void _ZN7S4294C33v22Ev();
extern void _ZN7S4294C33v23Ev();
extern void _ZN7S4294C33v24Ev();
extern void _ZN7S4294C33v25Ev();
extern void _ZN7S4294C33v26Ev();
extern void _ZN7S4294C33v27Ev();
extern void _ZN7S4294C33v28Ev();
extern void _ZN7S4294C33v29Ev();
extern void _ZN7S4294C33v30Ev();
extern void _ZN7S4294C33v31Ev();
extern void _ZN7S4294C33v32Ev();
extern void _ZN7S4294C33v33Ev();
extern void _ZN7S4294C33v34Ev();
extern void _ZN7S4294C33v35Ev();
extern void _ZN7S4294C33v36Ev();
extern void _ZN7S4294C33v37Ev();
extern void _ZN7S4294C33v38Ev();
extern void _ZN7S4294C33v39Ev();
extern void _ZN7S4294C33v40Ev();
extern void _ZN7S4294C33v41Ev();
extern void _ZN7S4294C23v48Ev();
extern void _ZN7S4294C23v49Ev();
extern void _ZN7S4294C23v50Ev();
extern void _ZN7S4294C23v51Ev();
extern void _ZN7S4294C23v52Ev();
extern void _ZN7S4294C23v53Ev();
extern void _ZN7S4294C23v54Ev();
extern void _ZN7S4294C23v55Ev();
extern void _ZN7S4294C23v56Ev();
extern void _ZN7S4294C23v57Ev();
extern void _ZN7S4294C23v58Ev();
extern void _ZN7S4294C23v59Ev();
extern void _ZN7S4294C23v60Ev();
extern void _ZN7S4294C23v61Ev();
extern void _ZN7S4294C12v1Ev();
extern void _ZN7S4294C12v2Ev();
extern void _ZN7S4294C12v3Ev();
extern void _ZN7S4294C12v4Ev();
extern void _ZN7S4294C12v5Ev();
extern void _ZN7S4294C12v6Ev();
extern void _ZN7S4294C12v7Ev();
extern void _ZN7S4294C12v8Ev();
extern void _ZN7S4294C12v9Ev();
extern void _ZN7S4294C13v10Ev();
extern void _ZN7S4294C13v11Ev();
extern void _ZN7S4294C13v12Ev();
extern void _ZN7S4294C13v13Ev();
extern void _ZN7S4294C13v14Ev();
extern void _ZN7S4294C13v15Ev();
extern void _ZN7S4294C13v16Ev();
extern void ABISELECT(_ZThn8_N7S4294C1D1Ev,_ZThn4_N7S4294C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S4294C1D0Ev,_ZThn4_N7S4294C1D0Ev)();
extern void _ZN7S4294C53v42Ev();
extern void _ZN7S4294C43v47Ev();
extern void ABISELECT(_ZThn16_N7S4294C1D1Ev,_ZThn8_N7S4294C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S4294C1D0Ev,_ZThn8_N7S4294C1D0Ev)();
extern void _ZN7S4294C63v43Ev();
extern void ABISELECT(_ZThn24_N7S4294C1D1Ev,_ZThn12_N7S4294C1D1Ev)();
extern void ABISELECT(_ZThn24_N7S4294C1D0Ev,_ZThn12_N7S4294C1D0Ev)();
extern void _ZN7S4294C73v44Ev();
extern void _ZN7S4294C73v45Ev();
extern void _ZN7S4294C73v46Ev();
static  VTBL_ENTRY vtc_S4294C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4294C1[0]),
  (VTBL_ENTRY)&_ZN7S4294C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4294C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4294C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4294C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4294C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4294C13v16Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S4294C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C1D1Ev,_ZThn4_N7S4294C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S4294C1D0Ev,_ZThn4_N7S4294C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C53v42Ev,
  (VTBL_ENTRY)&_ZN7S4294C43v47Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S4294C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C1D1Ev,_ZThn8_N7S4294C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S4294C1D0Ev,_ZThn8_N7S4294C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C63v43Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S4294C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4294C1D1Ev,_ZThn12_N7S4294C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N7S4294C1D0Ev,_ZThn12_N7S4294C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4294C73v44Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v45Ev,
  (VTBL_ENTRY)&_ZN7S4294C73v46Ev,
};
extern VTBL_ENTRY _ZTI7S4294C1[];
extern  VTBL_ENTRY _ZTV7S4294C1[];
Class_Descriptor cd_S4294C1 = {  "S4294C1", // class name
  bases_S4294C1, 6,
  &(vtc_S4294C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1048,880), // object size
  NSPAIRA(_ZTI7S4294C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4294C1),77, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C3  {
  char s20287c3f0:7;
  long double s20287c3f1;
  __tsi64 s20287c3f2;
  char s20287c3f3;
  __tsi64 s20287c3f4;
  char s20287c3f5:8;
  void *s20287c3f6;
  __tsi64 s20287c3f7[4];
  void  mf20287c3(); // _ZN8S20287C39mf20287c3Ev
};
//SIG(-1 S20287C3) C1{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]}


void  S20287C3 ::mf20287c3(){}

static void Test_S20287C3()
{
  {
    init_simple_test("S20287C3");
    static S20287C3 lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S20287C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C3)");
    set_bf_and_test(lv, s20287c3f0, 0, 0, 7, 1, "S20287C3");
    set_bf_and_test(lv, s20287c3f0, 0, 0, 7, hide_sll(1LL<<6), "S20287C3");
    check_field_offset(lv, s20287c3f1, ABISELECT(16,4), "S20287C3.s20287c3f1");
    check_field_offset(lv, s20287c3f2, ABISELECT(32,16), "S20287C3.s20287c3f2");
    check_field_offset(lv, s20287c3f3, ABISELECT(40,24), "S20287C3.s20287c3f3");
    check_field_offset(lv, s20287c3f4, ABISELECT(48,28), "S20287C3.s20287c3f4");
    set_bf_and_test(lv, s20287c3f5, ABISELECT(56,36), 0, 8, 1, "S20287C3");
    set_bf_and_test(lv, s20287c3f5, ABISELECT(56,36), 0, 8, hide_sll(1LL<<7), "S20287C3");
    check_field_offset(lv, s20287c3f6, ABISELECT(64,40), "S20287C3.s20287c3f6");
    check_field_offset(lv, s20287c3f7, ABISELECT(72,44), "S20287C3.s20287c3f7");
  }
}
static Arrange_To_Call_Me vS20287C3(Test_S20287C3, "S20287C3", ABISELECT(112,76));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20287C3[];
VTBL_ENTRY *P__ZTI8S20287C3 = _ZTI8S20287C3; 
Class_Descriptor cd_S20287C3 = {  "S20287C3", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI8S20287C3),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C2  {
  __tsi64 s20287c2f0;
  long double s20287c2f1;
  ::S20287C3 s20287c2f2;
  int s20287c2f3;
  short s20287c2f4;
  void *s20287c2f5[9];
  long s20287c2f6[2];
  virtual void  v6(); // _ZN8S20287C22v6Ev
  ~S20287C2(); // tgen
  S20287C2(); // tgen
};
//SIG(-1 S20287C2) C1{ v1 FL FD FC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} Fi Fs Fp[9] Fl[2]}


void  S20287C2 ::v6(){vfunc_called(this, "_ZN8S20287C22v6Ev");}
S20287C2 ::~S20287C2(){ note_dtor("S20287C2", this);} // tgen
S20287C2 ::S20287C2(){ note_ctor("S20287C2", this);} // tgen

static void Test_S20287C2()
{
  extern Class_Descriptor cd_S20287C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,39)];
    init_test(&cd_S20287C2, buf);
    S20287C2 *dp, &lv = *(dp=new (buf) S20287C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,152), "sizeof(S20287C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C2)");
    check_field_offset(lv, s20287c2f0, ABISELECT(8,4), "S20287C2.s20287c2f0");
    check_field_offset(lv, s20287c2f1, ABISELECT(16,12), "S20287C2.s20287c2f1");
    check_field_offset(lv, s20287c2f2, ABISELECT(32,24), "S20287C2.s20287c2f2");
    check_field_offset(lv, s20287c2f3, ABISELECT(144,100), "S20287C2.s20287c2f3");
    check_field_offset(lv, s20287c2f4, ABISELECT(148,104), "S20287C2.s20287c2f4");
    check_field_offset(lv, s20287c2f5, ABISELECT(152,108), "S20287C2.s20287c2f5");
    check_field_offset(lv, s20287c2f6, ABISELECT(224,144), "S20287C2.s20287c2f6");
    test_class_info(&lv, &cd_S20287C2);
    dp->~S20287C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C2(Test_S20287C2, "S20287C2", ABISELECT(240,152));

#else // __cplusplus

extern void _ZN8S20287C2C1Ev();
extern void _ZN8S20287C2D1Ev();
Name_Map name_map_S20287C2[] = {
  NSPAIR(_ZN8S20287C2C1Ev),
  NSPAIR(_ZN8S20287C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20287C2[];
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY vtc_S20287C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C2[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
Class_Descriptor cd_S20287C2 = {  "S20287C2", // class name
  0,0,//no base classes
  &(vtc_S20287C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,152), // object size
  NSPAIRA(_ZTI8S20287C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20287C2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C7  {
  __tsi64 s20287c7f0;
  __tsi64 s20287c7f1:2;
  unsigned char s20287c7f2:1;
  char s20287c7f3;
  int s20287c7f4[7];
  __tsi64 s20287c7f5[2];
  int s20287c7f6[4];
  void *s20287c7f7;
  virtual  ~S20287C7(); // _ZN8S20287C7D1Ev
  virtual void  v1(); // _ZN8S20287C72v1Ev
  S20287C7(); // tgen
};
//SIG(-1 S20287C7) C1{ vd v1 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp}


 S20287C7 ::~S20287C7(){ note_dtor("S20287C7", this);}
void  S20287C7 ::v1(){vfunc_called(this, "_ZN8S20287C72v1Ev");}
S20287C7 ::S20287C7(){ note_ctor("S20287C7", this);} // tgen

static void Test_S20287C7()
{
  extern Class_Descriptor cd_S20287C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,21)];
    init_test(&cd_S20287C7, buf);
    S20287C7 *dp, &lv = *(dp=new (buf) S20287C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,80), "sizeof(S20287C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20287C7)");
    check_field_offset(lv, s20287c7f0, ABISELECT(8,4), "S20287C7.s20287c7f0");
    set_bf_and_test(lv, s20287c7f1, ABISELECT(16,12), 0, 2, 1, "S20287C7");
    set_bf_and_test(lv, s20287c7f1, ABISELECT(16,12), 0, 2, hide_sll(1LL<<1), "S20287C7");
    set_bf_and_test(lv, s20287c7f2, ABISELECT(16,12), 2, 1, 1, "S20287C7");
    check_field_offset(lv, s20287c7f3, ABISELECT(17,13), "S20287C7.s20287c7f3");
    check_field_offset(lv, s20287c7f4, ABISELECT(20,16), "S20287C7.s20287c7f4");
    check_field_offset(lv, s20287c7f5, ABISELECT(48,44), "S20287C7.s20287c7f5");
    check_field_offset(lv, s20287c7f6, ABISELECT(64,60), "S20287C7.s20287c7f6");
    check_field_offset(lv, s20287c7f7, ABISELECT(80,76), "S20287C7.s20287c7f7");
    test_class_info(&lv, &cd_S20287C7);
    dp->~S20287C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C7(Test_S20287C7, "S20287C7", ABISELECT(88,80));

#else // __cplusplus

extern void _ZN8S20287C7C1Ev();
extern void _ZN8S20287C7D1Ev();
Name_Map name_map_S20287C7[] = {
  NSPAIR(_ZN8S20287C7C1Ev),
  NSPAIR(_ZN8S20287C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20287C7[];
extern void _ZN8S20287C7D1Ev();
extern void _ZN8S20287C7D0Ev();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY vtc_S20287C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C7[0]),
  (VTBL_ENTRY)&_ZN8S20287C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
Class_Descriptor cd_S20287C7 = {  "S20287C7", // class name
  0,0,//no base classes
  &(vtc_S20287C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,80), // object size
  NSPAIRA(_ZTI8S20287C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20287C7),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C6  : virtual S20287C3 , virtual S20287C7 {
  int s20287c6f0;
  void *s20287c6f1;
  virtual void  v2(); // _ZN8S20287C62v2Ev
  virtual void  v3(); // _ZN8S20287C62v3Ev
  virtual void  v4(); // _ZN8S20287C62v4Ev
  virtual void  v5(); // _ZN8S20287C62v5Ev
  ~S20287C6(); // tgen
  S20287C6(); // tgen
};
//SIG(-1 S20287C6) C1{ VBC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC3{ vd v5 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v1 v2 v3 v4 Fi Fp}


void  S20287C6 ::v2(){vfunc_called(this, "_ZN8S20287C62v2Ev");}
void  S20287C6 ::v3(){vfunc_called(this, "_ZN8S20287C62v3Ev");}
void  S20287C6 ::v4(){vfunc_called(this, "_ZN8S20287C62v4Ev");}
void  S20287C6 ::v5(){vfunc_called(this, "_ZN8S20287C62v5Ev");}
S20287C6 ::~S20287C6(){ note_dtor("S20287C6", this);} // tgen
S20287C6 ::S20287C6(){ note_ctor("S20287C6", this);} // tgen

static void Test_S20287C6()
{
  extern Class_Descriptor cd_S20287C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,43)];
    init_test(&cd_S20287C6, buf);
    S20287C6 *dp, &lv = *(dp=new (buf) S20287C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,168), "sizeof(S20287C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C6)");
    check_base_class_offset(lv, (S20287C3*), ABISELECT(32,12), "S20287C6");
    check_base_class_offset(lv, (S20287C7*), ABISELECT(144,88), "S20287C6");
    check_field_offset(lv, s20287c6f0, ABISELECT(8,4), "S20287C6.s20287c6f0");
    check_field_offset(lv, s20287c6f1, ABISELECT(16,8), "S20287C6.s20287c6f1");
    test_class_info(&lv, &cd_S20287C6);
    dp->~S20287C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C6(Test_S20287C6, "S20287C6", ABISELECT(240,168));

#else // __cplusplus

extern void _ZN8S20287C6C1Ev();
extern void _ZN8S20287C6D1Ev();
Name_Map name_map_S20287C6[] = {
  NSPAIR(_ZN8S20287C6C1Ev),
  NSPAIR(_ZN8S20287C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
static Base_Class bases_S20287C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C7,    ABISELECT(144,88), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C6[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn144_N8S20287C6D1Ev,_ZThn88_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn144_N8S20287C6D0Ev,_ZThn88_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY vtc_S20287C6[] = {
  ABISELECT(144,88),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
  0,
  ABISELECT(-144,-88),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern VTBL_ENTRY _ZTV8S20287C6[];
static  VTT_ENTRY vtt_S20287C6[] = {
  {&(_ZTV8S20287C6[4]),  4,17},
  {&(_ZTV8S20287C6[14]),  14,17},
};
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S20287C6D0Ev,_ZThn88_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S20287C6D1Ev,_ZThn88_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C6 = {  "S20287C6", // class name
  bases_S20287C6, 2,
  &(vtc_S20287C6[0]), // expected_vtbl_contents
  &(vtt_S20287C6[0]), // expected_vtt_contents
  ABISELECT(240,168), // object size
  NSPAIRA(_ZTI8S20287C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20287C6),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C6),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C5  : S20287C6 {
  int s20287c5f0;
  long s20287c5f1;
  __tsi64 s20287c5f2;
  ::S20287C7 s20287c5f3[9];
  void *s20287c5f4;
  int s20287c5f5;
  ::S20287C3 s20287c5f6;
  int s20287c5f7[3];
  void *s20287c5f8[2];
  virtual  ~S20287C5(); // _ZN8S20287C5D2Ev
  S20287C5(); // tgen
};
//SIG(-1 S20287C5) C1{ BC2{ VBC3{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC4{ vd v1 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v2 v3 v4 v5 Fi Fp} vd Fi Fl FL FC4[9] Fp Fi FC3 Fi[3] Fp[2]}


 S20287C5 ::~S20287C5(){ note_dtor("S20287C5", this);}
S20287C5 ::S20287C5(){ note_ctor("S20287C5", this);} // tgen

static void Test_S20287C5()
{
  extern Class_Descriptor cd_S20287C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(77,253)];
    init_test(&cd_S20287C5, buf);
    S20287C5 *dp, &lv = *(dp=new (buf) S20287C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1216,1008), "sizeof(S20287C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C5)");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(1008,852), "S20287C5");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(1120,928), "S20287C5");
    check_base_class_offset(lv, (S20287C6*), 0, "S20287C5");
    check_field_offset(lv, s20287c5f0, ABISELECT(24,12), "S20287C5.s20287c5f0");
    check_field_offset(lv, s20287c5f1, ABISELECT(32,16), "S20287C5.s20287c5f1");
    check_field_offset(lv, s20287c5f2, ABISELECT(40,20), "S20287C5.s20287c5f2");
    check_field_offset(lv, s20287c5f3, ABISELECT(48,28), "S20287C5.s20287c5f3");
    check_field_offset(lv, s20287c5f4, ABISELECT(840,748), "S20287C5.s20287c5f4");
    check_field_offset(lv, s20287c5f5, ABISELECT(848,752), "S20287C5.s20287c5f5");
    check_field_offset(lv, s20287c5f6, ABISELECT(864,756), "S20287C5.s20287c5f6");
    check_field_offset(lv, s20287c5f7, ABISELECT(976,832), "S20287C5.s20287c5f7");
    check_field_offset(lv, s20287c5f8, ABISELECT(992,844), "S20287C5.s20287c5f8");
    test_class_info(&lv, &cd_S20287C5);
    dp->~S20287C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C5(Test_S20287C5, "S20287C5", ABISELECT(1216,1008));

#else // __cplusplus

extern void _ZN8S20287C5C1Ev();
extern void _ZN8S20287C5D2Ev();
Name_Map name_map_S20287C5[] = {
  NSPAIR(_ZN8S20287C5C1Ev),
  NSPAIR(_ZN8S20287C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
static Base_Class bases_S20287C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(1008,852), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(1120,928), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C5[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C5D1Ev();
extern void _ZN8S20287C5D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C5D1Ev,_ZThn928_N8S20287C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C5D0Ev,_ZThn928_N8S20287C5D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY vtc_S20287C5[] = {
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D0Ev,
  0,
  ABISELECT(-1120,-928),
  ABISELECT(-1120,-928),
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern VTBL_ENTRY _ZTV8S20287C5[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C5[] = {
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C6D1Ev,_ZThn928_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C6D0Ev,_ZThn928_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__8S20287C5[] = {
  0,
  ABISELECT(-1120,-928),
  ABISELECT(-1120,-928),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C5[] = {
  {&(_ZTV8S20287C5[4]),  4,17},
  {&(_tg__ZTV8S20287C6__8S20287C5[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__8S20287C5[4]),  4,7},
  {&(_ZTV8S20287C5[14]),  14,17},
};
extern VTBL_ENTRY _ZTI8S20287C5[];
extern  VTBL_ENTRY _ZTV8S20287C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C5[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C6D0Ev,_ZThn928_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C6D1Ev,_ZThn928_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C5D0Ev,_ZThn928_N8S20287C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C5D1Ev,_ZThn928_N8S20287C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C5 = {  "S20287C5", // class name
  bases_S20287C5, 3,
  &(vtc_S20287C5[0]), // expected_vtbl_contents
  &(vtt_S20287C5[0]), // expected_vtt_contents
  ABISELECT(1216,1008), // object size
  NSPAIRA(_ZTI8S20287C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20287C5),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C5),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C8  : S20287C3 , S20287C7 , S20287C2 , S20287C6 {
  long s20287c8f0;
  int s20287c8f1;
  virtual  ~S20287C8(); // _ZN8S20287C8D2Ev
  virtual void  v7(); // _ZN8S20287C82v7Ev
  S20287C8(); // tgen
};
//SIG(-1 S20287C8) C1{ BC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} BC3{ vd v2 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} BC4{ v3 FL FD FC2 Fi Fs Fp[9] Fl[2]} BC5{ VBC2 VBC3 v4 v5 v6 v7 Fi Fp} vd v1 Fl Fi}


 S20287C8 ::~S20287C8(){ note_dtor("S20287C8", this);}
void  S20287C8 ::v7(){vfunc_called(this, "_ZN8S20287C82v7Ev");}
S20287C8 ::S20287C8(){ note_ctor("S20287C8", this);} // tgen

static void Test_S20287C8()
{
  extern Class_Descriptor cd_S20287C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(45,122)];
    init_test(&cd_S20287C8, buf);
    S20287C8 *dp, &lv = *(dp=new (buf) S20287C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(704,484), "sizeof(S20287C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C8)");
    /*is_ambiguous_... S20287C8::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*), ABISELECT(96,80), "S20287C8");
    /*is_ambiguous_... S20287C8::S20287C7 */ AMB_check_base_class_offset(lv, (S20287C7*), 0, "S20287C8");
    check_base_class_offset(lv, (S20287C2*), ABISELECT(208,156), "S20287C8");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(496,328), "S20287C8");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(608,404), "S20287C8");
    check_base_class_offset(lv, (S20287C6*), ABISELECT(448,308), "S20287C8");
    check_field_offset(lv, s20287c8f0, ABISELECT(472,320), "S20287C8.s20287c8f0");
    check_field_offset(lv, s20287c8f1, ABISELECT(480,324), "S20287C8.s20287c8f1");
    test_class_info(&lv, &cd_S20287C8);
    dp->~S20287C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C8(Test_S20287C8, "S20287C8", ABISELECT(704,484));

#else // __cplusplus

extern void _ZN8S20287C8C1Ev();
extern void _ZN8S20287C8D2Ev();
Name_Map name_map_S20287C8[] = {
  NSPAIR(_ZN8S20287C8C1Ev),
  NSPAIR(_ZN8S20287C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
static Base_Class bases_S20287C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(96,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C2,    ABISELECT(208,156), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(496,328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(608,404), //bcp->offset
    21, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(448,308), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C8[];
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn608_N8S20287C8D1Ev,_ZThn404_N8S20287C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void ABISELECT(_ZThn608_N8S20287C8D0Ev,_ZThn404_N8S20287C8D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY vtc_S20287C8[] = {
  ABISELECT(608,404),
  ABISELECT(496,328),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(160,96),
  ABISELECT(48,20),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
  0,
  ABISELECT(-608,-404),
  ABISELECT(-608,-404),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern VTBL_ENTRY _ZTV8S20287C8[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8[] = {
  ABISELECT(160,96),
  ABISELECT(48,20),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn160_N8S20287C6D1Ev,_ZThn96_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn160_N8S20287C6D0Ev,_ZThn96_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__8S20287C8[] = {
  0,
  ABISELECT(-160,-96),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C8[] = {
  {&(_ZTV8S20287C8[4]),  4,28},
  {&(_tg__ZTV8S20287C6__8S20287C8[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__8S20287C8[4]),  4,7},
  {&(_ZTV8S20287C8[15]),  15,28},
  {&(_ZTV8S20287C8[25]),  25,28},
};
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S20287C6D0Ev,_ZThn96_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S20287C6D1Ev,_ZThn96_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn608_N8S20287C8D0Ev,_ZThn404_N8S20287C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn608_N8S20287C8D1Ev,_ZThn404_N8S20287C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C8 = {  "S20287C8", // class name
  bases_S20287C8, 6,
  &(vtc_S20287C8[0]), // expected_vtbl_contents
  &(vtt_S20287C8[0]), // expected_vtt_contents
  ABISELECT(704,484), // object size
  NSPAIRA(_ZTI8S20287C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20287C8),28, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C8),5, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C10  : virtual S20287C7 , S20287C3 , S20287C6 , S20287C2 {
  int s20287c10f0;
  char s20287c10f1;
  void *s20287c10f2;
  int s20287c10f3;
  ::S20287C2 s20287c10f4;
  int s20287c10f5[5];
  ::S20287C6 s20287c10f6[6];
  __tsi64 s20287c10f7:5;
  virtual  ~S20287C10(); // _ZN9S20287C10D2Ev
  virtual void  v8(); // _ZN9S20287C102v8Ev
  S20287C10(); // tgen
};
//SIG(-1 S20287C10) C1{ VBC2{ vd v2 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} BC3{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} BC4{ VBC3 VBC2 v3 v4 v5 v6 Fi Fp} BC5{ v7 FL FD FC3 Fi Fs Fp[9] Fl[2]} vd v1 Fi Fc Fp Fi FC5 Fi[5] FC4[6] FL:5}


 S20287C10 ::~S20287C10(){ note_dtor("S20287C10", this);}
void  S20287C10 ::v8(){vfunc_called(this, "_ZN9S20287C102v8Ev");}
S20287C10 ::S20287C10(){ note_ctor("S20287C10", this);} // tgen

static void Test_S20287C10()
{
  extern Class_Descriptor cd_S20287C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(147,400)];
    init_test(&cd_S20287C10, buf);
    S20287C10 *dp, &lv = *(dp=new (buf) S20287C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2336,1596), "sizeof(S20287C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C10)");
    check_base_class_offset(lv, (S20287C7*), ABISELECT(2136,1440), "S20287C10");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(2136,1440), "S20287C10");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*), ABISELECT(32,12), "S20287C10");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(2224,1520), "S20287C10");
    check_base_class_offset(lv, (S20287C6*), 0, "S20287C10");
    check_base_class_offset(lv, (S20287C2*), ABISELECT(144,88), "S20287C10");
    check_field_offset(lv, s20287c10f0, ABISELECT(384,240), "S20287C10.s20287c10f0");
    check_field_offset(lv, s20287c10f1, ABISELECT(388,244), "S20287C10.s20287c10f1");
    check_field_offset(lv, s20287c10f2, ABISELECT(392,248), "S20287C10.s20287c10f2");
    check_field_offset(lv, s20287c10f3, ABISELECT(400,252), "S20287C10.s20287c10f3");
    check_field_offset(lv, s20287c10f4, ABISELECT(416,256), "S20287C10.s20287c10f4");
    check_field_offset(lv, s20287c10f5, ABISELECT(656,408), "S20287C10.s20287c10f5");
    check_field_offset(lv, s20287c10f6, ABISELECT(688,428), "S20287C10.s20287c10f6");
    set_bf_and_test(lv, s20287c10f7, ABISELECT(2128,1436), 0, 5, 1, "S20287C10");
    set_bf_and_test(lv, s20287c10f7, ABISELECT(2128,1436), 0, 5, hide_sll(1LL<<4), "S20287C10");
    test_class_info(&lv, &cd_S20287C10);
    dp->~S20287C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C10(Test_S20287C10, "S20287C10", ABISELECT(2336,1596));

#else // __cplusplus

extern void _ZN9S20287C10C1Ev();
extern void _ZN9S20287C10D2Ev();
Name_Map name_map_S20287C10[] = {
  NSPAIR(_ZN9S20287C10C1Ev),
  NSPAIR(_ZN9S20287C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
static Base_Class bases_S20287C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C7,    ABISELECT(2136,1440), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(2224,1520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C2,    ABISELECT(144,88), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20287C10[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZThn2136_N9S20287C10D1Ev,_ZThn1440_N9S20287C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void ABISELECT(_ZThn2136_N9S20287C10D0Ev,_ZThn1440_N9S20287C10D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY vtc_S20287C10[] = {
  ABISELECT(2136,1440),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  0,
  ABISELECT(-2136,-1440),
  ABISELECT(-2136,-1440),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern VTBL_ENTRY _ZTV9S20287C10[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__9S20287C10[] = {
  ABISELECT(2136,1440),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn2136_N8S20287C6D1Ev,_ZThn1440_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn2136_N8S20287C6D0Ev,_ZThn1440_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__9S20287C10[] = {
  0,
  ABISELECT(-2136,-1440),
  ABISELECT(-2136,-1440),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C10[] = {
  {&(_ZTV9S20287C10[4]),  4,21},
  {&(_tg__ZTV8S20287C6__9S20287C10[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__9S20287C10[4]),  4,7},
  {&(_ZTV9S20287C10[18]),  18,21},
};
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N8S20287C6D0Ev,_ZThn1440_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N8S20287C6D1Ev,_ZThn1440_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N9S20287C10D0Ev,_ZThn1440_N9S20287C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N9S20287C10D1Ev,_ZThn1440_N9S20287C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C10 = {  "S20287C10", // class name
  bases_S20287C10, 5,
  &(vtc_S20287C10[0]), // expected_vtbl_contents
  &(vtt_S20287C10[0]), // expected_vtt_contents
  ABISELECT(2336,1596), // object size
  NSPAIRA(_ZTI9S20287C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20287C10),21, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20287C10),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C9  : virtual S20287C10 , virtual S20287C8 , S20287C6 , virtual S20287C2 {
  long s20287c9f0;
  virtual  ~S20287C9(); // _ZN8S20287C9D2Ev
  S20287C9(); // tgen
};
//SIG(-1 S20287C9) C1{ VBC2{ VBC3{ vd v1 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} BC4{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} BC5{ VBC4 VBC3 v2 v3 v4 v5 Fi Fp} BC6{ v6 FL FD FC4 Fi Fs Fp[9] Fl[2]} vd v7 Fi Fc Fp Fi FC6 Fi[5] FC5[6] FL:5} VBC7{ BC4 BC3 BC6 BC5 vd v8 Fl Fi} BC5 VBC6 vd Fl}


 S20287C9 ::~S20287C9(){ note_dtor("S20287C9", this);}
S20287C9 ::S20287C9(){ note_ctor("S20287C9", this);} // tgen

static void Test_S20287C9()
{
  extern Class_Descriptor cd_S20287C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(195,524)];
    init_test(&cd_S20287C9, buf);
    S20287C9 *dp, &lv = *(dp=new (buf) S20287C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3104,2092), "sizeof(S20287C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C9)");
    check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(2168,1456), "S20287C9");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(2168,1456), "S20287C9");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(2168,1456), "S20287C9");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(2168,1456), "S20287C9");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(64,28), "S20287C9");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(2256,1536), "S20287C9");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(2256,1536), "S20287C9");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(2256,1536), "S20287C9");
    check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(32,16), "S20287C9");
    check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(176,104), "S20287C9");
    check_base_class_offset(lv, (S20287C10*), ABISELECT(32,16), "S20287C9");
    /*is_ambiguous_... S20287C8::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(2464,1692), "S20287C9");
    /*is_ambiguous_... S20287C8::S20287C7 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(2368,1612), "S20287C9");
    check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(2576,1768), "S20287C9");
    check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(2816,1920), "S20287C9");
    check_base_class_offset(lv, (S20287C8*), ABISELECT(2368,1612), "S20287C9");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*), 0, "S20287C9");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*), ABISELECT(2864,1940), "S20287C9");
    check_field_offset(lv, s20287c9f0, ABISELECT(24,12), "S20287C9.s20287c9f0");
    test_class_info(&lv, &cd_S20287C9);
    dp->~S20287C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C9(Test_S20287C9, "S20287C9", ABISELECT(3104,2092));

#else // __cplusplus

extern void _ZN8S20287C9C1Ev();
extern void _ZN8S20287C9D2Ev();
Name_Map name_map_S20287C9[] = {
  NSPAIR(_ZN8S20287C9C1Ev),
  NSPAIR(_ZN8S20287C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
static Base_Class bases_S20287C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C7,    ABISELECT(2168,1456), //bcp->offset
    34, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(64,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(2256,1536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(176,104), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(32,16), //bcp->offset
    13, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(2464,1692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(2368,1612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(2576,1768), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(2816,1920), //bcp->offset
    60, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(2368,1612), //bcp->offset
    41, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C2,    ABISELECT(2864,1940), //bcp->offset
    70, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C9[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn32_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2168_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2168_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2368_N8S20287C9D1Ev,_ZThn1612_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2368_N8S20287C9D0Ev,_ZThn1612_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY vtc_S20287C9[] = {
  ABISELECT(2864,1940),
  ABISELECT(2368,1612),
  ABISELECT(32,16),
  ABISELECT(2168,1456),
  ABISELECT(2256,1536),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
  ABISELECT(144,88),
  0,
  ABISELECT(-32,-16),
  0,
  0,
  0,
  0,
  ABISELECT(2136,1440),
  ABISELECT(2224,1520),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  0,
  ABISELECT(-2168,-1456),
  ABISELECT(-2168,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2368,-1612),
  ABISELECT(-200,-156),
  ABISELECT(-112,-76),
  ABISELECT(-2368,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-2576,-1768),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-648,-464),
  ABISELECT(-560,-384),
  ABISELECT(-2816,-1920),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
  0,
  ABISELECT(-2864,-1940),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern VTBL_ENTRY _ZTV8S20287C9[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A2__8S20287C9[] = {
  ABISELECT(2168,1456),
  ABISELECT(2256,1536),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn2168_N8S20287C6D1Ev,_ZThn1456_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn2168_N8S20287C6D0Ev,_ZThn1456_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A2__8S20287C9[] = {
  0,
  ABISELECT(-2168,-1456),
  ABISELECT(-2168,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9[] = {
  ABISELECT(2136,1440),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__8S20287C9[] = {
  ABISELECT(2136,1440),
  ABISELECT(2224,1520),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn2136_N8S20287C6D1Ev,_ZThn1440_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn2136_N8S20287C6D0Ev,_ZThn1440_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__8S20287C9[] = {
  0,
  ABISELECT(-2136,-1440),
  ABISELECT(-2136,-1440),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZThn2136_N9S20287C10D1Ev,_ZThn1440_N9S20287C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void ABISELECT(_ZThn2136_N9S20287C10D0Ev,_ZThn1440_N9S20287C10D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__8S20287C9[] = {
  0,
  ABISELECT(-2136,-1440),
  ABISELECT(-2136,-1440),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9[] = {
  ABISELECT(-200,-156),
  ABISELECT(-112,-76),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9[] = {
  ABISELECT(-648,-464),
  ABISELECT(-560,-384),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A1__8S20287C9[] = {
  0,
  ABISELECT(648,464),
  ABISELECT(648,464),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__8S20287C9[] = {
  ABISELECT(-648,-464),
  ABISELECT(-560,-384),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__8S20287C9[] = {
  0,
  ABISELECT(200,156),
  ABISELECT(200,156),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C9[] = {
  {&(_ZTV8S20287C9[7]),  7,74},
  {&(_tg__ZTV8S20287C6__A2__8S20287C9[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A2__8S20287C9[4]),  4,7},
  {&(_ZTV8S20287C9[24]),  24,74},
  {&(_ZTV8S20287C9[38]),  38,74},
  {&(_ZTV8S20287C9[33]),  33,74},
  {&(_ZTV8S20287C9[53]),  53,74},
  {&(_ZTV8S20287C9[59]),  59,74},
  {&(_ZTV8S20287C9[64]),  64,74},
  {&(_ZTV8S20287C9[73]),  73,74},
  {&(_tg__ZTV9S20287C10__8S20287C9[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__8S20287C9[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__8S20287C9[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__8S20287C9[4]),  4,7},
  {&(_tg__ZTV8S20287C8__8S20287C9[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A1__8S20287C9[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__8S20287C9[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__8S20287C9[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N9S20287C10D0Ev,_ZThn1440_N9S20287C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N9S20287C10D1Ev,_ZThn1440_N9S20287C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N8S20287C6D0Ev,_ZThn1440_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2168_N8S20287C6D0Ev,_ZThn1456_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2136_N8S20287C6D1Ev,_ZThn1440_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2168_N8S20287C6D1Ev,_ZThn1456_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2368_N8S20287C9D0Ev,_ZThn1612_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2368_N8S20287C9D1Ev,_ZThn1612_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2168_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2168_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C9 = {  "S20287C9", // class name
  bases_S20287C9, 13,
  &(vtc_S20287C9[0]), // expected_vtbl_contents
  &(vtt_S20287C9[0]), // expected_vtt_contents
  ABISELECT(3104,2092), // object size
  NSPAIRA(_ZTI8S20287C9),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20287C9),74, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C9),19, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C13  : S20287C3 , S20287C8 , virtual S20287C9 , S20287C7 , virtual S20287C6 {
  long s20287c13f0;
  ::S20287C2 s20287c13f1;
  int s20287c13f2;
  long s20287c13f3[9];
  void *s20287c13f4;
  virtual  ~S20287C13(); // _ZN9S20287C13D2Ev
  virtual void  v10(); // _ZN9S20287C133v10Ev
  virtual void  v11(); // _ZN9S20287C133v11Ev
  S20287C13(); // tgen
};
//SIG(-1 S20287C13) C1{ BC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} BC3{ BC2 BC4{ vd v3 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} BC5{ v4 FL FD FC2 Fi Fs Fp[9] Fl[2]} BC6{ VBC2 VBC4 v5 v6 v7 v8 Fi Fp} vd v9 Fl Fi} VBC7{ VBC8{ VBC4 BC2 BC6 BC5 vd v10 Fi Fc Fp Fi FC5 Fi[5] FC6[6] FL:5} VBC3 BC6 VBC5 vd Fl} BC4 VBC6 vd v1 v2 Fl FC5 Fi Fl[9] Fp}


 S20287C13 ::~S20287C13(){ note_dtor("S20287C13", this);}
void  S20287C13 ::v10(){vfunc_called(this, "_ZN9S20287C133v10Ev");}
void  S20287C13 ::v11(){vfunc_called(this, "_ZN9S20287C133v11Ev");}
S20287C13 ::S20287C13(){ note_ctor("S20287C13", this);} // tgen

static void Test_S20287C13()
{
  extern Class_Descriptor cd_S20287C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(263,698)];
    init_test(&cd_S20287C13, buf);
    S20287C13 *dp, &lv = *(dp=new (buf) S20287C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4192,2788), "sizeof(S20287C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C13)");
    /*is_ambiguous_... S20287C13::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*), ABISELECT(496,328), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(96,80), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), 0, "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(208,156), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(1040,684), "S20287C13");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(1040,684), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(1040,684), "S20287C13");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C9*), ABISELECT(1040,684), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(1040,684), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(1152,760), "S20287C13");
    check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(1152,760), "S20287C13");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(1152,760), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(1152,760), "S20287C13");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C9*), ABISELECT(1152,760), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(1152,760), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(448,308), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C8*), 0, "S20287C13");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(1312,868), "S20287C13");
    check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(1280,856), "S20287C13");
    check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(1424,944), "S20287C13");
    check_base_class_offset(lv, (S20287C10*)(S20287C9*), ABISELECT(1280,856), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(3520,2376), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(3424,2296), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(3632,2452), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(3872,2604), "S20287C13");
    check_base_class_offset(lv, (S20287C8*)(S20287C9*), ABISELECT(3424,2296), "S20287C13");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C9*), ABISELECT(1240,840), "S20287C13");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C9*), ABISELECT(3920,2624), "S20287C13");
    check_base_class_offset(lv, (S20287C9*), ABISELECT(1240,840), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C7 */ AMB_check_base_class_offset(lv, (S20287C7*), ABISELECT(608,404), "S20287C13");
    /*is_ambiguous_... S20287C13::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*), ABISELECT(4160,2776), "S20287C13");
    check_field_offset(lv, s20287c13f0, ABISELECT(696,484), "S20287C13.s20287c13f0");
    check_field_offset(lv, s20287c13f1, ABISELECT(704,488), "S20287C13.s20287c13f1");
    check_field_offset(lv, s20287c13f2, ABISELECT(944,640), "S20287C13.s20287c13f2");
    check_field_offset(lv, s20287c13f3, ABISELECT(952,644), "S20287C13.s20287c13f3");
    check_field_offset(lv, s20287c13f4, ABISELECT(1024,680), "S20287C13.s20287c13f4");
    test_class_info(&lv, &cd_S20287C13);
    dp->~S20287C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C13(Test_S20287C13, "S20287C13", ABISELECT(4192,2788));

#else // __cplusplus

extern void _ZN9S20287C13C1Ev();
extern void _ZN9S20287C13D2Ev();
Name_Map name_map_S20287C13[] = {
  NSPAIR(_ZN9S20287C13C1Ev),
  NSPAIR(_ZN9S20287C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C9;
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
static Base_Class bases_S20287C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(496,328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(96,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20287C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(208,156), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(1040,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(1152,760), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(448,308), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20287C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(1312,868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(1280,856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(1424,944), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(1280,856), //bcp->offset
    58, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(3520,2376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(3424,2296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(3632,2452), //bcp->offset
    95, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(3872,2604), //bcp->offset
    98, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(3424,2296), //bcp->offset
    79, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(1240,840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(3920,2624), //bcp->offset
    108, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S20287C9,    ABISELECT(1240,840), //bcp->offset
    40, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C7,    ABISELECT(608,404), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C6,    ABISELECT(4160,2776), //bcp->offset
    112, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20287C13[];
extern void _ZN9S20287C13D1Ev();
extern void _ZN9S20287C13D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn608_N9S20287C13D1Ev,_ZThn404_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn608_N9S20287C13D0Ev,_ZThn404_N9S20287C13D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1152_N9S20287C13D1Ev,_ZThn760_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1152_N9S20287C13D0Ev,_ZThn760_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1240_N9S20287C13D1Ev,_ZThn840_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1240_N9S20287C13D0Ev,_ZThn840_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1280_N9S20287C13D1Ev,_ZThn856_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1280_N9S20287C13D0Ev,_ZThn856_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3424_N9S20287C13D1Ev,_ZThn2296_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3424_N9S20287C13D0Ev,_ZThn2296_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev)();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn4160_N9S20287C13D1Ev,_ZThn2776_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn4160_N9S20287C13D0Ev,_ZThn2776_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20287C13[] = {
  ABISELECT(4160,2776),
  ABISELECT(3920,2624),
  ABISELECT(3424,2296),
  ABISELECT(1280,856),
  ABISELECT(1240,840),
  ABISELECT(1152,760),
  ABISELECT(1040,684),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN9S20287C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(704,452),
  ABISELECT(592,376),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev),
  ABISELECT(-608,-404),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn608_N9S20287C13D1Ev,_ZThn404_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn608_N9S20287C13D0Ev,_ZThn404_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  0,
  ABISELECT(-1152,-760),
  ABISELECT(-1152,-760),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-1240,-840),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  ABISELECT(-1240,-840),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev),
  ABISELECT(144,88),
  0,
  ABISELECT(-1280,-856),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-1280,-856),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-1424,-944),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-3424,-2296),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-3424,-2296),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-3632,-2452),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-3872,-2604),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev),
  0,
  ABISELECT(-3920,-2624),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-4160,-2776),
  0,
  0,
  0,
  0,
  ABISELECT(-3008,-2016),
  ABISELECT(-3120,-2092),
  ABISELECT(-4160,-2776),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
};
extern VTBL_ENTRY _ZTV9S20287C13[];
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A__9S20287C13[] = {
  ABISELECT(1152,760),
  ABISELECT(1040,684),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__9S20287C13[] = {
  ABISELECT(704,452),
  ABISELECT(592,376),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn704_N8S20287C6D1Ev,_ZThn452_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn704_N8S20287C6D0Ev,_ZThn452_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__9S20287C13[] = {
  0,
  ABISELECT(-704,-452),
  ABISELECT(-704,-452),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A__9S20287C13[] = {
  ABISELECT(704,452),
  ABISELECT(592,376),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn1152_N8S20287C8D1Ev,_ZThn760_N8S20287C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void ABISELECT(_ZThn1152_N8S20287C8D0Ev,_ZThn760_N8S20287C8D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A__9S20287C13[] = {
  0,
  ABISELECT(-1152,-760),
  ABISELECT(-1152,-760),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C13[] = {
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C9__A3__9S20287C13[] = {
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C9__A3__9S20287C13[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9__9S20287C13[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-40,-16),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-40,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C9__9S20287C13[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C13[] = {
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9__9S20287C13[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2184,-1456),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-2184,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C13[] = {
  ABISELECT(-2392,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C13[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-2632,-1764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A2__8S20287C9__9S20287C13[] = {
  0,
  ABISELECT(-2680,-1784),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C13[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A1__9S20287C13[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A1__9S20287C13[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__9S20287C13[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C13[] = {
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A2__9S20287C13[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A2__9S20287C13[] = {
  0,
  ABISELECT(2720,1844),
  ABISELECT(2720,1844),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A1__9S20287C13[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C13[] = {
  0,
  ABISELECT(2272,1536),
  ABISELECT(2272,1536),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A4__9S20287C13[] = {
  ABISELECT(-3008,-2016),
  ABISELECT(-3120,-2092),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A4__9S20287C13[] = {
  0,
  ABISELECT(3008,2016),
  ABISELECT(3008,2016),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C13[] = {
  {&(_ZTV9S20287C13[9]),  9,127},
  {&(_tg__ZTV8S20287C8__A__9S20287C13[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A__9S20287C13[4]),  4,7},
  {&(_ZTV9S20287C13[22]),  22,127},
  {&(_ZTV9S20287C13[37]),  37,127},
  {&(_ZTV9S20287C13[52]),  52,127},
  {&(_ZTV9S20287C13[69]),  69,127},
  {&(_ZTV9S20287C13[78]),  78,127},
  {&(_ZTV9S20287C13[91]),  91,127},
  {&(_ZTV9S20287C13[97]),  97,127},
  {&(_ZTV9S20287C13[102]),  102,127},
  {&(_ZTV9S20287C13[111]),  111,127},
  {&(_ZTV9S20287C13[121]),  121,127},
  {&(_tg__ZTV8S20287C9__9S20287C13[7]),  7,13},
  {&(_tg__ZTV8S20287C68S20287C9__A3__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C9__A3__9S20287C13[4]),  4,7},
  {&(_tg__ZTV9S20287C10__8S20287C9__9S20287C13[11]),  11,18},
  {&(_tg__ZTV8S20287C7__8S20287C9__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C13[2]),  2,3},
  {&(_tg__ZTV8S20287C8__8S20287C9__9S20287C13[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C13[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A2__8S20287C9__9S20287C13[3]),  3,4},
  {&(_tg__ZTV9S20287C10__9S20287C13[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A1__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A1__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A1__9S20287C13[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A2__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A2__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A1__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C13[4]),  4,7},
  {&(_tg__ZTV8S20287C6__A4__9S20287C13[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A4__9S20287C13[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20287C13[];
extern  VTBL_ENTRY _ZTV9S20287C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C13[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S20287C8D0Ev,_ZThn760_N8S20287C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S20287C8D1Ev,_ZThn760_N8S20287C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S20287C6D0Ev,_ZThn452_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S20287C6D1Ev,_ZThn452_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3424_N9S20287C13D0Ev,_ZThn2296_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3424_N9S20287C13D1Ev,_ZThn2296_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4160_N9S20287C13D0Ev,_ZThn2776_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1280_N9S20287C13D0Ev,_ZThn856_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4160_N9S20287C13D1Ev,_ZThn2776_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1280_N9S20287C13D1Ev,_ZThn856_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1240_N9S20287C13D0Ev,_ZThn840_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1240_N9S20287C13D1Ev,_ZThn840_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N9S20287C13D0Ev,_ZThn760_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N9S20287C13D1Ev,_ZThn760_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C13 = {  "S20287C13", // class name
  bases_S20287C13, 22,
  &(vtc_S20287C13[0]), // expected_vtbl_contents
  &(vtt_S20287C13[0]), // expected_vtt_contents
  ABISELECT(4192,2788), // object size
  NSPAIRA(_ZTI9S20287C13),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20287C13),127, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20287C13),37, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C12  : virtual S20287C3 , S20287C6 , virtual S20287C5 , virtual S20287C13 {
  ::S20287C9 s20287c12f0;
  short s20287c12f1;
  __tsi64 s20287c12f2[4];
  virtual  ~S20287C12(); // _ZN9S20287C12D2Ev
  virtual void  v12(); // _ZN9S20287C123v12Ev
  S20287C12(); // tgen
};
//SIG(-1 S20287C12) C1{ VBC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} BC3{ VBC2 VBC4{ vd v2 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v3 v4 v5 v6 Fi Fp} VBC5{ BC3 vd Fi Fl FL FC4[9] Fp Fi FC2 Fi[3] Fp[2]} VBC6{ BC2 BC7{ BC2 BC4 BC8{ v7 FL FD FC2 Fi Fs Fp[9] Fl[2]} BC3 vd v8 Fl Fi} VBC9{ VBC10{ VBC4 BC2 BC3 BC8 vd v9 Fi Fc Fp Fi FC8 Fi[5] FC3[6] FL:5} VBC7 BC3 VBC8 vd Fl} BC4 VBC3 vd v10 v11 Fl FC8 Fi Fl[9] Fp} vd v1 FC9 Fs FL[4]}


 S20287C12 ::~S20287C12(){ note_dtor("S20287C12", this);}
void  S20287C12 ::v12(){vfunc_called(this, "_ZN9S20287C123v12Ev");}
S20287C12 ::S20287C12(){ note_ctor("S20287C12", this);} // tgen

static void Test_S20287C12()
{
  extern Class_Descriptor cd_S20287C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(525,1446)];
    init_test(&cd_S20287C12, buf);
    S20287C12 *dp, &lv = *(dp=new (buf) S20287C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8384,5780), "sizeof(S20287C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C12)");
    /*is_ambiguous_... S20287C12::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(3184,2140), "S20287C12");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C5*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(3184,2140), "S20287C12");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C9*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(3184,2140), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(3296,2216), "S20287C12");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C5*), ABISELECT(3296,2216), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(3296,2216), "S20287C12");
    check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(3296,2216), "S20287C12");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(3296,2216), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(3296,2216), "S20287C12");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C9*), ABISELECT(3296,2216), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(3296,2216), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*), 0, "S20287C12");
    check_base_class_offset(lv, (S20287C6*)(S20287C5*), ABISELECT(3392,2296), "S20287C12");
    check_base_class_offset(lv, (S20287C5*), ABISELECT(3392,2296), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C13*), ABISELECT(4896,3476), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*)(S20287C13*), ABISELECT(4496,3228), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*)(S20287C13*), ABISELECT(4400,3148), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*)(S20287C13*), ABISELECT(4608,3304), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(4848,3456), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C8*)(S20287C13*), ABISELECT(4400,3148), "S20287C12");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(5504,3860), "S20287C12");
    check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(5472,3848), "S20287C12");
    check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(5616,3936), "S20287C12");
    check_base_class_offset(lv, (S20287C10*)(S20287C9*), ABISELECT(5472,3848), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(7712,5368), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(7616,5288), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(7824,5444), "S20287C12");
    /*is_ambiguous_... S20287C12::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(8064,5596), "S20287C12");
    check_base_class_offset(lv, (S20287C8*)(S20287C9*), ABISELECT(7616,5288), "S20287C12");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C9*), ABISELECT(5432,3832), "S20287C12");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C9*), ABISELECT(8112,5616), "S20287C12");
    check_base_class_offset(lv, (S20287C9*)(S20287C13*), ABISELECT(5432,3832), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C7 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C13*), ABISELECT(5008,3552), "S20287C12");
    /*is_ambiguous_... S20287C13::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C13*), ABISELECT(8352,5768), "S20287C12");
    check_base_class_offset(lv, (S20287C13*), ABISELECT(4400,3148), "S20287C12");
    check_field_offset(lv, s20287c12f0, ABISELECT(32,12), "S20287C12.s20287c12f0");
    check_field_offset(lv, s20287c12f1, ABISELECT(3136,2104), "S20287C12.s20287c12f1");
    check_field_offset(lv, s20287c12f2, ABISELECT(3144,2108), "S20287C12.s20287c12f2");
    test_class_info(&lv, &cd_S20287C12);
    dp->~S20287C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C12(Test_S20287C12, "S20287C12", ABISELECT(8384,5780));

#else // __cplusplus

extern void _ZN9S20287C12C1Ev();
extern void _ZN9S20287C12D2Ev();
Name_Map name_map_S20287C12[] = {
  NSPAIR(_ZN9S20287C12C1Ev),
  NSPAIR(_ZN9S20287C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C5;
extern VTBL_ENTRY _ZTI8S20287C5[];
extern  VTBL_ENTRY _ZTV8S20287C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C5[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C9;
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C13;
extern VTBL_ENTRY _ZTI9S20287C13[];
extern  VTBL_ENTRY _ZTV9S20287C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C13[];
static Base_Class bases_S20287C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(3184,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C7,    ABISELECT(3296,2216), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C6,    ABISELECT(3392,2296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20287C5,    ABISELECT(3392,2296), //bcp->offset
    25, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(4896,3476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(4496,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(4400,3148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(4608,3304), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(4848,3456), //bcp->offset
    68, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(4400,3148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(5504,3860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(5472,3848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(5616,3936), //bcp->offset
    119, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(5472,3848), //bcp->offset
    101, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(7712,5368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(7616,5288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(7824,5444), //bcp->offset
    138, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(8064,5596), //bcp->offset
    141, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(7616,5288), //bcp->offset
    122, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(5432,3832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(8112,5616), //bcp->offset
    151, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C9,    ABISELECT(5432,3832), //bcp->offset
    83, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(5008,3552), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(8352,5768), //bcp->offset
    155, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20287C13,    ABISELECT(4400,3148), //bcp->offset
    40, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20287C12[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C12D1Ev();
extern void _ZN9S20287C12D0Ev();
extern void _ZN9S20287C123v12Ev();
extern void ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn3296_N9S20287C12D1Ev,_ZThn2216_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn3296_N9S20287C12D0Ev,_ZThn2216_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn3392_N9S20287C12D1Ev,_ZThn2296_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn3392_N9S20287C12D0Ev,_ZThn2296_N9S20287C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn4400_N9S20287C12D1Ev,_ZThn3148_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn4400_N9S20287C12D0Ev,_ZThn3148_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n80_N9S20287C12D1Ev,_ZTvn308_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn448_n80_N9S20287C12D0Ev,_ZTvn308_n40_N9S20287C12D0Ev)();
extern void ABISELECT(_ZTvn608_n80_N9S20287C12D1Ev,_ZTvn404_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn608_n80_N9S20287C12D0Ev,_ZTvn404_n40_N9S20287C12D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn5432_N9S20287C12D1Ev,_ZThn3832_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn5432_N9S20287C12D0Ev,_ZThn3832_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn5472_N9S20287C12D1Ev,_ZThn3848_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn5472_N9S20287C12D0Ev,_ZThn3848_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn7616_N9S20287C12D1Ev,_ZThn5288_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn7616_N9S20287C12D0Ev,_ZThn5288_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C12D1Ev,_ZTvn308_n20_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C12D0Ev,_ZTvn308_n20_N9S20287C12D0Ev)();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn8352_N9S20287C12D1Ev,_ZThn5768_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn8352_N9S20287C12D0Ev,_ZThn5768_N9S20287C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20287C12[] = {
  ABISELECT(8352,5768),
  ABISELECT(8112,5616),
  ABISELECT(7616,5288),
  ABISELECT(5472,3848),
  ABISELECT(5432,3832),
  ABISELECT(4400,3148),
  ABISELECT(3392,2296),
  ABISELECT(3296,2216),
  ABISELECT(3184,2140),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C12D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C123v12Ev,
  0,
  ABISELECT(-3296,-2216),
  ABISELECT(-3296,-2216),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-3392,-2296),
  0,
  0,
  0,
  0,
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  ABISELECT(-3392,-2296),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
  0,
  0,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-4400,-3148),
  ABISELECT(3952,2620),
  ABISELECT(3712,2468),
  ABISELECT(3216,2140),
  ABISELECT(1072,700),
  ABISELECT(1032,684),
  ABISELECT(-1104,-932),
  ABISELECT(-1216,-1008),
  ABISELECT(-4400,-3148),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
  ABISELECT(-4608,-3304),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-1552,-1240),
  ABISELECT(-1664,-1316),
  ABISELECT(-4848,-3456),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C12D1Ev,_ZTvn308_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C12D0Ev,_ZTvn308_n40_N9S20287C12D0Ev),
  ABISELECT(-5008,-3552),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C12D1Ev,_ZTvn404_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C12D0Ev,_ZTvn404_n40_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-5432,-3832),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-2136,-1616),
  ABISELECT(-2248,-1692),
  ABISELECT(-5432,-3832),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev),
  ABISELECT(144,88),
  0,
  ABISELECT(-5472,-3848),
  0,
  0,
  0,
  0,
  ABISELECT(-2176,-1632),
  ABISELECT(-2288,-1708),
  ABISELECT(-5472,-3848),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-5616,-3936),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-7616,-5288),
  ABISELECT(-4320,-3072),
  ABISELECT(-4432,-3148),
  ABISELECT(-7616,-5288),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-7824,-5444),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-4768,-3380),
  ABISELECT(-4880,-3456),
  ABISELECT(-8064,-5596),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C12D1Ev,_ZTvn308_n20_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C12D0Ev,_ZTvn308_n20_N9S20287C12D0Ev),
  0,
  ABISELECT(-8112,-5616),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-8352,-5768),
  0,
  0,
  0,
  0,
  ABISELECT(-5056,-3552),
  ABISELECT(-5168,-3628),
  ABISELECT(-8352,-5768),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
};
extern VTBL_ENTRY _ZTV9S20287C12[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A__9S20287C12[] = {
  ABISELECT(3296,2216),
  ABISELECT(3184,2140),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn3296_N8S20287C6D1Ev,_ZThn2216_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn3296_N8S20287C6D0Ev,_ZThn2216_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A__9S20287C12[] = {
  0,
  ABISELECT(-3296,-2216),
  ABISELECT(-3296,-2216),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C5D1Ev();
extern void _ZN8S20287C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C5__9S20287C12[] = {
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C5__A1__9S20287C12[] = {
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C5__A1__9S20287C12[] = {
  0,
  ABISELECT(96,80),
  ABISELECT(96,80),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C5__9S20287C12[] = {
  0,
  ABISELECT(96,80),
  ABISELECT(96,80),
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN9S20287C13D1Ev();
extern void _ZN9S20287C13D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C13__9S20287C12[] = {
  ABISELECT(3952,2620),
  ABISELECT(3712,2468),
  ABISELECT(3216,2140),
  ABISELECT(1072,700),
  ABISELECT(1032,684),
  ABISELECT(-1104,-932),
  ABISELECT(-1216,-1008),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN9S20287C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C89S20287C13__9S20287C12[] = {
  ABISELECT(-1104,-932),
  ABISELECT(-1216,-1008),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C12[] = {
  ABISELECT(-1552,-1240),
  ABISELECT(-1664,-1316),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A2__9S20287C12[] = {
  0,
  ABISELECT(1552,1240),
  ABISELECT(1552,1240),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C89S20287C13__9S20287C12[] = {
  ABISELECT(-1552,-1240),
  ABISELECT(-1664,-1316),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C89S20287C13__9S20287C12[] = {
  0,
  ABISELECT(1104,932),
  ABISELECT(1104,932),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__9S20287C13__9S20287C12[] = {
  ABISELECT(-1552,-1240),
  ABISELECT(-1664,-1316),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__9S20287C13__9S20287C12[] = {
  0,
  ABISELECT(1104,932),
  ABISELECT(1104,932),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C13__9S20287C12[] = {
  ABISELECT(-1032,-684),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-2136,-1616),
  ABISELECT(-2248,-1692),
  ABISELECT(-1032,-684),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1072_N9S20287C13D1Ev,_ZThn700_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1072_N9S20287C13D0Ev,_ZThn700_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C13__9S20287C12[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-1072,-700),
  0,
  0,
  0,
  0,
  ABISELECT(-2176,-1632),
  ABISELECT(-2288,-1708),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__9S20287C13__9S20287C12[] = {
  ABISELECT(-1216,-788),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3216_N9S20287C13D1Ev,_ZThn2140_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3216_N9S20287C13D0Ev,_ZThn2140_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C13__9S20287C12[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-3216,-2140),
  ABISELECT(-4320,-3072),
  ABISELECT(-4432,-3148),
  ABISELECT(-3216,-2140),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__9S20287C13__9S20287C12[] = {
  ABISELECT(-3424,-2296),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A2__9S20287C13__9S20287C12[] = {
  ABISELECT(-4768,-3380),
  ABISELECT(-4880,-3456),
  ABISELECT(-3664,-2448),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__9S20287C13__9S20287C12[] = {
  0,
  ABISELECT(-3712,-2468),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3952_N9S20287C13D1Ev,_ZThn2620_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3952_N9S20287C13D0Ev,_ZThn2620_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C6__A4__9S20287C13__9S20287C12[] = {
  ABISELECT(-3952,-2620),
  0,
  0,
  0,
  0,
  ABISELECT(-5056,-3552),
  ABISELECT(-5168,-3628),
  ABISELECT(-3952,-2620),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C12[] = {
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-2136,-1616),
  ABISELECT(-2248,-1692),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C9__A5__9S20287C12[] = {
  ABISELECT(-2136,-1616),
  ABISELECT(-2248,-1692),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C9__A5__9S20287C12[] = {
  0,
  ABISELECT(2136,1616),
  ABISELECT(2136,1616),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9__9S20287C12[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-40,-16),
  0,
  0,
  0,
  0,
  ABISELECT(-2176,-1632),
  ABISELECT(-2288,-1708),
  ABISELECT(-40,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C9__9S20287C12[] = {
  0,
  ABISELECT(2136,1616),
  ABISELECT(2136,1616),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C12[] = {
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9__9S20287C12[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2184,-1456),
  ABISELECT(-4320,-3072),
  ABISELECT(-4432,-3148),
  ABISELECT(-2184,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C12[] = {
  ABISELECT(-2392,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C12[] = {
  ABISELECT(-4768,-3380),
  ABISELECT(-4880,-3456),
  ABISELECT(-2632,-1764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A2__8S20287C9__9S20287C12[] = {
  0,
  ABISELECT(-2680,-1784),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C12[] = {
  ABISELECT(-2176,-1632),
  ABISELECT(-2288,-1708),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A3__9S20287C12[] = {
  ABISELECT(-2176,-1632),
  ABISELECT(-2288,-1708),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A3__9S20287C12[] = {
  0,
  ABISELECT(2176,1632),
  ABISELECT(2176,1632),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__9S20287C12[] = {
  0,
  ABISELECT(2176,1632),
  ABISELECT(2176,1632),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C12[] = {
  ABISELECT(-4320,-3072),
  ABISELECT(-4432,-3148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A4__9S20287C12[] = {
  ABISELECT(-4768,-3380),
  ABISELECT(-4880,-3456),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A4__9S20287C12[] = {
  0,
  ABISELECT(4768,3380),
  ABISELECT(4768,3380),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A1__9S20287C12[] = {
  ABISELECT(-4768,-3380),
  ABISELECT(-4880,-3456),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C12[] = {
  0,
  ABISELECT(4320,3072),
  ABISELECT(4320,3072),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A6__9S20287C12[] = {
  ABISELECT(-5056,-3552),
  ABISELECT(-5168,-3628),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A6__9S20287C12[] = {
  0,
  ABISELECT(5056,3552),
  ABISELECT(5056,3552),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C12[] = {
  {&(_ZTV9S20287C12[11]),  11,170},
  {&(_tg__ZTV8S20287C6__A__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A__9S20287C12[4]),  4,7},
  {&(_ZTV9S20287C12[22]),  22,170},
  {&(_ZTV9S20287C12[34]),  34,170},
  {&(_ZTV9S20287C12[59]),  59,170},
  {&(_ZTV9S20287C12[67]),  67,170},
  {&(_ZTV9S20287C12[72]),  72,170},
  {&(_ZTV9S20287C12[95]),  95,170},
  {&(_ZTV9S20287C12[112]),  112,170},
  {&(_ZTV9S20287C12[121]),  121,170},
  {&(_ZTV9S20287C12[134]),  134,170},
  {&(_ZTV9S20287C12[140]),  140,170},
  {&(_ZTV9S20287C12[145]),  145,170},
  {&(_ZTV9S20287C12[154]),  154,170},
  {&(_ZTV9S20287C12[80]),  80,170},
  {&(_ZTV9S20287C12[164]),  164,170},
  {&(_tg__ZTV8S20287C5__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C68S20287C5__A1__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C5__A1__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C7__8S20287C5__9S20287C12[4]),  4,7},
  {&(_tg__ZTV9S20287C13__9S20287C12[9]),  9,15},
  {&(_tg__ZTV8S20287C89S20287C13__9S20287C12[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A2__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C89S20287C13__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C89S20287C13__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C68S20287C8__9S20287C13__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__9S20287C13__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C9__9S20287C13__9S20287C12[12]),  12,18},
  {&(_tg__ZTV9S20287C10__9S20287C13__9S20287C12[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__9S20287C13__9S20287C12[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__9S20287C13__9S20287C12[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__9S20287C13__9S20287C12[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A2__9S20287C13__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__9S20287C13__9S20287C12[3]),  3,4},
  {&(_tg__ZTV8S20287C6__A4__9S20287C13__9S20287C12[9]),  9,15},
  {&(_tg__ZTV8S20287C9__9S20287C12[7]),  7,13},
  {&(_tg__ZTV8S20287C68S20287C9__A5__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C9__A5__9S20287C12[4]),  4,7},
  {&(_tg__ZTV9S20287C10__8S20287C9__9S20287C12[11]),  11,18},
  {&(_tg__ZTV8S20287C7__8S20287C9__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C12[2]),  2,3},
  {&(_tg__ZTV8S20287C8__8S20287C9__9S20287C12[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C12[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A2__8S20287C9__9S20287C12[3]),  3,4},
  {&(_tg__ZTV9S20287C10__9S20287C12[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A3__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A3__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A1__9S20287C12[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A4__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A4__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A1__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C12[4]),  4,7},
  {&(_tg__ZTV8S20287C6__A6__9S20287C12[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A6__9S20287C12[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20287C12[];
extern  VTBL_ENTRY _ZTV9S20287C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C12[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3216_N9S20287C13D0Ev,_ZThn2140_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3216_N9S20287C13D1Ev,_ZThn2140_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3952_N9S20287C13D0Ev,_ZThn2620_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S20287C13D0Ev,_ZThn700_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3952_N9S20287C13D1Ev,_ZThn2620_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S20287C13D1Ev,_ZThn700_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3296_N8S20287C6D0Ev,_ZThn2216_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3296_N8S20287C6D1Ev,_ZThn2216_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7616_N9S20287C12D0Ev,_ZThn5288_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7616_N9S20287C12D1Ev,_ZThn5288_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5432_N9S20287C12D0Ev,_ZThn3832_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5432_N9S20287C12D1Ev,_ZThn3832_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4400_N9S20287C12D0Ev,_ZThn3148_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4400_N9S20287C12D1Ev,_ZThn3148_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8352_N9S20287C12D0Ev,_ZThn5768_N9S20287C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5472_N9S20287C12D0Ev,_ZThn3848_N9S20287C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3392_N9S20287C12D0Ev,_ZThn2296_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8352_N9S20287C12D1Ev,_ZThn5768_N9S20287C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5472_N9S20287C12D1Ev,_ZThn3848_N9S20287C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3392_N9S20287C12D1Ev,_ZThn2296_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3296_N9S20287C12D0Ev,_ZThn2216_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3296_N9S20287C12D1Ev,_ZThn2216_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C12 = {  "S20287C12", // class name
  bases_S20287C12, 26,
  &(vtc_S20287C12[0]), // expected_vtbl_contents
  &(vtt_S20287C12[0]), // expected_vtt_contents
  ABISELECT(8384,5780), // object size
  NSPAIRA(_ZTI9S20287C12),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20287C12),170, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20287C12),58, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C14  {
  int s20287c14f0;
  void *s20287c14f1;
  char s20287c14f2;
  int s20287c14f3;
  long double s20287c14f4;
  __tsi64 s20287c14f5;
  void *s20287c14f6[2];
  __tsi64 s20287c14f7;
  __tsi64 s20287c14f8:64;
  __tsi64 s20287c14f9:14;
  long s20287c14f10;
  void *s20287c14f11;
  virtual void  v13(); // _ZN9S20287C143v13Ev
  virtual void  v14(); // _ZN9S20287C143v14Ev
  ~S20287C14(); // tgen
  S20287C14(); // tgen
};
//SIG(-1 S20287C14) C1{ v1 v2 Fi Fp Fc Fi FD FL Fp[2] FL FL:64 FL:14 Fl Fp}


void  S20287C14 ::v13(){vfunc_called(this, "_ZN9S20287C143v13Ev");}
void  S20287C14 ::v14(){vfunc_called(this, "_ZN9S20287C143v14Ev");}
S20287C14 ::~S20287C14(){ note_dtor("S20287C14", this);} // tgen
S20287C14 ::S20287C14(){ note_ctor("S20287C14", this);} // tgen

static void Test_S20287C14()
{
  extern Class_Descriptor cd_S20287C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(8,20)];
    init_test(&cd_S20287C14, buf);
    S20287C14 *dp, &lv = *(dp=new (buf) S20287C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,76), "sizeof(S20287C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C14)");
    check_field_offset(lv, s20287c14f0, ABISELECT(8,4), "S20287C14.s20287c14f0");
    check_field_offset(lv, s20287c14f1, ABISELECT(16,8), "S20287C14.s20287c14f1");
    check_field_offset(lv, s20287c14f2, ABISELECT(24,12), "S20287C14.s20287c14f2");
    check_field_offset(lv, s20287c14f3, ABISELECT(28,16), "S20287C14.s20287c14f3");
    check_field_offset(lv, s20287c14f4, ABISELECT(32,20), "S20287C14.s20287c14f4");
    check_field_offset(lv, s20287c14f5, ABISELECT(48,32), "S20287C14.s20287c14f5");
    check_field_offset(lv, s20287c14f6, ABISELECT(56,40), "S20287C14.s20287c14f6");
    check_field_offset(lv, s20287c14f7, ABISELECT(72,48), "S20287C14.s20287c14f7");
    set_bf_and_test(lv, s20287c14f8, ABISELECT(80,56), 0, 64, 1, "S20287C14");
    set_bf_and_test(lv, s20287c14f8, ABISELECT(80,56), 0, 64, hide_sll(1LL<<63), "S20287C14");
    set_bf_and_test(lv, s20287c14f9, ABISELECT(88,64), 0, 14, 1, "S20287C14");
    set_bf_and_test(lv, s20287c14f9, ABISELECT(88,64), 0, 14, hide_sll(1LL<<13), "S20287C14");
    check_field_offset(lv, s20287c14f10, ABISELECT(96,68), "S20287C14.s20287c14f10");
    check_field_offset(lv, s20287c14f11, ABISELECT(104,72), "S20287C14.s20287c14f11");
    test_class_info(&lv, &cd_S20287C14);
    dp->~S20287C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C14(Test_S20287C14, "S20287C14", ABISELECT(112,76));

#else // __cplusplus

extern void _ZN9S20287C14C1Ev();
extern void _ZN9S20287C14D1Ev();
Name_Map name_map_S20287C14[] = {
  NSPAIR(_ZN9S20287C14C1Ev),
  NSPAIR(_ZN9S20287C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20287C14[];
extern void _ZN9S20287C143v13Ev();
extern void _ZN9S20287C143v14Ev();
static  VTBL_ENTRY vtc_S20287C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C14[0]),
  (VTBL_ENTRY)&_ZN9S20287C143v13Ev,
  (VTBL_ENTRY)&_ZN9S20287C143v14Ev,
};
extern VTBL_ENTRY _ZTI9S20287C14[];
extern  VTBL_ENTRY _ZTV9S20287C14[];
Class_Descriptor cd_S20287C14 = {  "S20287C14", // class name
  0,0,//no base classes
  &(vtc_S20287C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,76), // object size
  NSPAIRA(_ZTI9S20287C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20287C14),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C11  : virtual S20287C5 , S20287C12 , S20287C13 , S20287C14 , S20287C3 {
  long s20287c11f0;
  __tsi64 s20287c11f1:21;
  ~S20287C11(); // tgen
  S20287C11(); // tgen
};
//SIG(-1 S20287C11) C1{ VBC2{ BC3{ VBC4{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC5{ vd v1 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v2 v3 v4 v5 Fi Fp} vd Fi Fl FL FC5[9] Fp Fi FC4 Fi[3] Fp[2]} BC6{ VBC4 BC3 VBC2 VBC7{ BC4 BC8{ BC4 BC5 BC9{ v6 FL FD FC4 Fi Fs Fp[9] Fl[2]} BC3 vd v7 Fl Fi} VBC10{ VBC11{ VBC5 BC4 BC3 BC9 vd v8 Fi Fc Fp Fi FC9 Fi[5] FC3[6] FL:5} VBC8 BC3 VBC9 vd Fl} BC5 VBC3 vd v9 v10 Fl FC9 Fi Fl[9] Fp} vd v11 FC10 Fs FL[4]} BC7 BC12{ v12 v13 Fi Fp Fc Fi FD FL Fp[2] FL FL:64 FL:14 Fl Fp} BC4 Fl FL:21}


S20287C11 ::~S20287C11(){ note_dtor("S20287C11", this);} // tgen
S20287C11 ::S20287C11(){ note_ctor("S20287C11", this);} // tgen

static void Test_S20287C11()
{
  extern Class_Descriptor cd_S20287C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(605,1657)];
    init_test(&cd_S20287C11, buf);
    S20287C11 *dp, &lv = *(dp=new (buf) S20287C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9664,6624), "sizeof(S20287C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C11)");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C5*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C12::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C12*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C12*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(5472,3836), "S20287C11");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C9*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(5472,3836), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(5472,3836), "S20287C11");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C5*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C12*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(5584,3912), "S20287C11");
    check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(5584,3912), "S20287C11");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C9*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(5584,3912), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(5584,3912), "S20287C11");
    check_base_class_offset(lv, (S20287C6*)(S20287C5*), ABISELECT(4464,2984), "S20287C11");
    check_base_class_offset(lv, (S20287C5*), ABISELECT(4464,2984), "S20287C11");
    check_base_class_offset(lv, (S20287C5*)(S20287C12*), ABISELECT(4464,2984), "S20287C11");
    /*is_ambiguous_... S20287C12::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C12*), 0, "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C13*), ABISELECT(6176,4320), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*)(S20287C13*), ABISELECT(5776,4072), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*)(S20287C13*), ABISELECT(5680,3992), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*)(S20287C13*), ABISELECT(5888,4148), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(6128,4300), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C8*)(S20287C13*), ABISELECT(5680,3992), "S20287C11");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(6784,4704), "S20287C11");
    check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(6752,4692), "S20287C11");
    check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(6896,4780), "S20287C11");
    check_base_class_offset(lv, (S20287C10*)(S20287C9*), ABISELECT(6752,4692), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(8992,6212), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(8896,6132), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(9104,6288), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(9344,6440), "S20287C11");
    check_base_class_offset(lv, (S20287C8*)(S20287C9*), ABISELECT(8896,6132), "S20287C11");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C9*), ABISELECT(6712,4676), "S20287C11");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C9*), ABISELECT(9392,6460), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C9*)(S20287C13*), ABISELECT(6712,4676), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C9*)(S20287C13*), ABISELECT(6712,4676), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C13*), ABISELECT(6288,4396), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C13*), ABISELECT(9632,6612), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C13*), ABISELECT(9632,6612), "S20287C11");
    check_base_class_offset(lv, (S20287C13*)(S20287C12*), ABISELECT(5680,3992), "S20287C11");
    check_base_class_offset(lv, (S20287C12*), 0, "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C13*), ABISELECT(3680,2468), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*)(S20287C13*), ABISELECT(3280,2220), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*)(S20287C13*), ABISELECT(3184,2140), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*)(S20287C13*), ABISELECT(3392,2296), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(3632,2448), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C8*)(S20287C13*), ABISELECT(3184,2140), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C13*), ABISELECT(3792,2544), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C13 */ AMB_check_base_class_offset(lv, (S20287C13*), ABISELECT(3184,2140), "S20287C11");
    check_base_class_offset(lv, (S20287C14*), ABISELECT(4224,2824), "S20287C11");
    /*is_ambiguous_... S20287C11::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*), ABISELECT(4336,2900), "S20287C11");
    check_field_offset(lv, s20287c11f0, ABISELECT(4448,2976), "S20287C11.s20287c11f0");
    set_bf_and_test(lv, s20287c11f1, ABISELECT(4456,2980), 0, 21, 1, "S20287C11");
    set_bf_and_test(lv, s20287c11f1, ABISELECT(4456,2980), 0, 21, hide_sll(1LL<<20), "S20287C11");
    test_class_info(&lv, &cd_S20287C11);
    dp->~S20287C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C11(Test_S20287C11, "S20287C11", ABISELECT(9664,6624));

#else // __cplusplus

extern void _ZN9S20287C11C1Ev();
extern void _ZN9S20287C11D1Ev();
Name_Map name_map_S20287C11[] = {
  NSPAIR(_ZN9S20287C11C1Ev),
  NSPAIR(_ZN9S20287C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C5;
extern VTBL_ENTRY _ZTI8S20287C5[];
extern  VTBL_ENTRY _ZTV8S20287C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C5[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C9;
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C13;
extern VTBL_ENTRY _ZTI9S20287C13[];
extern  VTBL_ENTRY _ZTV9S20287C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C13[];
extern Class_Descriptor cd_S20287C12;
extern VTBL_ENTRY _ZTI9S20287C12[];
extern  VTBL_ENTRY _ZTV9S20287C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C12[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C13;
extern VTBL_ENTRY _ZTI9S20287C13[];
extern  VTBL_ENTRY _ZTV9S20287C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C13[];
extern Class_Descriptor cd_S20287C14;
extern VTBL_ENTRY _ZTI9S20287C14[];
extern  VTBL_ENTRY _ZTV9S20287C14[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
static Base_Class bases_S20287C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(5472,3836), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(5584,3912), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(4464,2984), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20287C5,    ABISELECT(4464,2984), //bcp->offset
    55, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(6176,4320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(5776,4072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(5680,3992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(5888,4148), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(6128,4300), //bcp->offset
    105, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(5680,3992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(6784,4704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(6752,4692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(6896,4780), //bcp->offset
    156, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(6752,4692), //bcp->offset
    138, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(8992,6212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(8896,6132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(9104,6288), //bcp->offset
    175, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(9344,6440), //bcp->offset
    178, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(8896,6132), //bcp->offset
    159, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    85, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(6712,4676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(9392,6460), //bcp->offset
    188, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20287C9,    ABISELECT(6712,4676), //bcp->offset
    120, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(6288,4396), //bcp->offset
    115, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(9632,6612), //bcp->offset
    192, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20287C13,    ABISELECT(5680,3992), //bcp->offset
    77, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S20287C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(3680,2468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(3280,2220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(3184,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(3392,2296), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(3632,2448), //bcp->offset
    36, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(3184,2140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(3792,2544), //bcp->offset
    46, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C13,    ABISELECT(3184,2140), //bcp->offset
    18, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C14,    ABISELECT(4224,2824), //bcp->offset
    51, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(4336,2900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20287C11[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C11D1Ev();
extern void _ZN9S20287C11D0Ev();
extern void _ZN9S20287C123v12Ev();
extern void ABISELECT(_ZThn3184_N9S20287C11D1Ev,_ZThn2140_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn3184_N9S20287C11D0Ev,_ZThn2140_N9S20287C11D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn3632_N9S20287C11D1Ev,_ZThn2448_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn3632_N9S20287C11D0Ev,_ZThn2448_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn3792_N9S20287C11D1Ev,_ZThn2544_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn3792_N9S20287C11D0Ev,_ZThn2544_N9S20287C11D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN9S20287C143v13Ev();
extern void _ZN9S20287C143v14Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn4464_N9S20287C11D1Ev,_ZThn2984_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn4464_N9S20287C11D0Ev,_ZThn2984_N9S20287C11D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C11D1Ev,_ZTv0_n12_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn5584_N9S20287C11D1Ev,_ZThn3912_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C11D0Ev,_ZTv0_n12_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn5584_N9S20287C11D0Ev,_ZThn3912_N9S20287C11D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void ABISELECT(_ZTv0_n80_N9S20287C11D1Ev,_ZTv0_n40_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn5680_N9S20287C11D1Ev,_ZThn3992_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20287C11D0Ev,_ZTv0_n40_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn5680_N9S20287C11D0Ev,_ZThn3992_N9S20287C11D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n80_N9S20287C11D1Ev,_ZTvn308_n40_N9S20287C11D1Ev)();
extern void ABISELECT(_ZTvn448_n80_N9S20287C11D0Ev,_ZTvn308_n40_N9S20287C11D0Ev)();
extern void ABISELECT(_ZTvn608_n80_N9S20287C11D1Ev,_ZTvn404_n40_N9S20287C11D1Ev)();
extern void ABISELECT(_ZTvn608_n80_N9S20287C11D0Ev,_ZTvn404_n40_N9S20287C11D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C11D1Ev,_ZTv0_n48_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn6712_N9S20287C11D1Ev,_ZThn4676_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C11D0Ev,_ZTv0_n48_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn6712_N9S20287C11D0Ev,_ZThn4676_N9S20287C11D0Ev)() __attribute__((weak));
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn6752_N9S20287C11D1Ev,_ZThn4692_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn6752_N9S20287C11D0Ev,_ZThn4692_N9S20287C11D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n40_N9S20287C11D1Ev,_ZTv0_n20_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn8896_N9S20287C11D1Ev,_ZThn6132_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C11D0Ev,_ZTv0_n20_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn8896_N9S20287C11D0Ev,_ZThn6132_N9S20287C11D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C11D1Ev,_ZTvn308_n20_N9S20287C11D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C11D0Ev,_ZTvn308_n20_N9S20287C11D0Ev)();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev)();
extern void ABISELECT(_ZThn9632_N9S20287C11D1Ev,_ZThn6612_N9S20287C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev)();
extern void ABISELECT(_ZThn9632_N9S20287C11D0Ev,_ZThn6612_N9S20287C11D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20287C11[] = {
  ABISELECT(9632,6612),
  ABISELECT(9392,6460),
  ABISELECT(8896,6132),
  ABISELECT(6752,4692),
  ABISELECT(6712,4676),
  ABISELECT(5680,3992),
  ABISELECT(4464,2984),
  ABISELECT(5584,3912),
  ABISELECT(5472,3836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C11D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C123v12Ev,
  ABISELECT(6448,4472),
  ABISELECT(6208,4320),
  ABISELECT(5712,3992),
  ABISELECT(3568,2552),
  ABISELECT(3528,2536),
  ABISELECT(2400,1772),
  ABISELECT(2288,1696),
  ABISELECT(-3184,-2140),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3184_N9S20287C11D1Ev,_ZThn2140_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3184_N9S20287C11D0Ev,_ZThn2140_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
  ABISELECT(-3392,-2296),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(1952,1464),
  ABISELECT(1840,1388),
  ABISELECT(-3632,-2448),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn3632_N9S20287C11D1Ev,_ZThn2448_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3632_N9S20287C11D0Ev,_ZThn2448_N9S20287C11D0Ev),
  ABISELECT(-3792,-2544),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3792_N9S20287C11D1Ev,_ZThn2544_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3792_N9S20287C11D0Ev,_ZThn2544_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-4224,-2824),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN9S20287C143v13Ev,
  (VTBL_ENTRY)&_ZN9S20287C143v14Ev,
  ABISELECT(-4464,-2984),
  0,
  0,
  0,
  0,
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  ABISELECT(-4464,-2984),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev),
  0,
  ABISELECT(-5584,-3912),
  ABISELECT(-5584,-3912),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C11D1Ev,_ZTv0_n12_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C11D0Ev,_ZTv0_n12_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  0,
  0,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-5680,-3992),
  ABISELECT(3952,2620),
  ABISELECT(3712,2468),
  ABISELECT(3216,2140),
  ABISELECT(1072,700),
  ABISELECT(1032,684),
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  ABISELECT(-5680,-3992),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C11D1Ev,_ZTv0_n40_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C11D0Ev,_ZTv0_n40_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
  ABISELECT(-5888,-4148),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-544,-388),
  ABISELECT(-656,-464),
  ABISELECT(-6128,-4300),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C11D1Ev,_ZTvn308_n40_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C11D0Ev,_ZTvn308_n40_N9S20287C11D0Ev),
  ABISELECT(-6288,-4396),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C11D1Ev,_ZTvn404_n40_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C11D0Ev,_ZTvn404_n40_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-6712,-4676),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  ABISELECT(-6712,-4676),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C11D1Ev,_ZTv0_n48_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C11D0Ev,_ZTv0_n48_N9S20287C11D0Ev),
  ABISELECT(144,88),
  0,
  ABISELECT(-6752,-4692),
  0,
  0,
  0,
  0,
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  ABISELECT(-6752,-4692),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-6896,-4780),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-8896,-6132),
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  ABISELECT(-8896,-6132),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C11D1Ev,_ZTv0_n20_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C11D0Ev,_ZTv0_n20_N9S20287C11D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-9104,-6288),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-9344,-6440),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C11D1Ev,_ZTvn308_n20_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C11D0Ev,_ZTvn308_n20_N9S20287C11D0Ev),
  0,
  ABISELECT(-9392,-6460),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-9632,-6612),
  0,
  0,
  0,
  0,
  ABISELECT(-4048,-2700),
  ABISELECT(-4160,-2776),
  ABISELECT(-9632,-6612),
  (VTBL_ENTRY)&(_ZTI9S20287C11[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev),
};
extern VTBL_ENTRY _ZTV9S20287C11[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C12D1Ev();
extern void _ZN9S20287C12D0Ev();
extern void _ZN9S20287C123v12Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C12__9S20287C11[] = {
  ABISELECT(9632,6612),
  ABISELECT(9392,6460),
  ABISELECT(8896,6132),
  ABISELECT(6752,4692),
  ABISELECT(6712,4676),
  ABISELECT(5680,3992),
  ABISELECT(4464,2984),
  ABISELECT(5584,3912),
  ABISELECT(5472,3836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C12D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C123v12Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C12__A1__9S20287C11[] = {
  ABISELECT(5584,3912),
  ABISELECT(5472,3836),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn5584_N8S20287C6D1Ev,_ZThn3912_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn5584_N8S20287C6D0Ev,_ZThn3912_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C12__A1__9S20287C11[] = {
  0,
  ABISELECT(-5584,-3912),
  ABISELECT(-5584,-3912),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn5584_N9S20287C12D1Ev,_ZThn3912_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn5584_N9S20287C12D0Ev,_ZThn3912_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C12__9S20287C11[] = {
  0,
  ABISELECT(-5584,-3912),
  ABISELECT(-5584,-3912),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn4464_N9S20287C12D1Ev,_ZThn2984_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn4464_N9S20287C12D0Ev,_ZThn2984_N9S20287C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C5__9S20287C12__9S20287C11[] = {
  ABISELECT(-4464,-2984),
  0,
  0,
  0,
  0,
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  ABISELECT(-4464,-2984),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
};
extern void ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn5680_N9S20287C12D1Ev,_ZThn3992_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn5680_N9S20287C12D0Ev,_ZThn3992_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C13__9S20287C12__9S20287C11[] = {
  0,
  0,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-5680,-3992),
  ABISELECT(3952,2620),
  ABISELECT(3712,2468),
  ABISELECT(3216,2140),
  ABISELECT(1072,700),
  ABISELECT(1032,684),
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  ABISELECT(-5680,-3992),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C89S20287C13__9S20287C12__9S20287C11[] = {
  ABISELECT(-5888,-4148),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n80_N9S20287C12D1Ev,_ZTvn308_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn448_n80_N9S20287C12D0Ev,_ZTvn308_n40_N9S20287C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C12__9S20287C11[] = {
  ABISELECT(-544,-388),
  ABISELECT(-656,-464),
  ABISELECT(-6128,-4300),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C12D1Ev,_ZTvn308_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N9S20287C12D0Ev,_ZTvn308_n40_N9S20287C12D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn6712_N9S20287C12D1Ev,_ZThn4676_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn6712_N9S20287C12D0Ev,_ZThn4676_N9S20287C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C12__9S20287C11[] = {
  ABISELECT(-6712,-4676),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  ABISELECT(-6712,-4676),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn6752_N9S20287C12D1Ev,_ZThn4692_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn6752_N9S20287C12D0Ev,_ZThn4692_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C12__9S20287C11[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-6752,-4692),
  0,
  0,
  0,
  0,
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  ABISELECT(-6752,-4692),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__9S20287C12__9S20287C11[] = {
  ABISELECT(-6896,-4780),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn8896_N9S20287C12D1Ev,_ZThn6132_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn8896_N9S20287C12D0Ev,_ZThn6132_N9S20287C12D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C12__9S20287C11[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-8896,-6132),
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  ABISELECT(-8896,-6132),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__9S20287C12__9S20287C11[] = {
  ABISELECT(-9104,-6288),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C12D1Ev,_ZTvn308_n20_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C12D0Ev,_ZTvn308_n20_N9S20287C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A4__9S20287C12__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-9344,-6440),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C12D1Ev,_ZTvn308_n20_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C12D0Ev,_ZTvn308_n20_N9S20287C12D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__9S20287C12__9S20287C11[] = {
  0,
  ABISELECT(-9392,-6460),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTvn608_n80_N9S20287C12D1Ev,_ZTvn404_n40_N9S20287C12D1Ev)();
extern void ABISELECT(_ZTvn608_n80_N9S20287C12D0Ev,_ZTvn404_n40_N9S20287C12D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C79S20287C13__A3__9S20287C12__9S20287C11[] = {
  ABISELECT(-6288,-4396),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C12D1Ev,_ZTvn404_n40_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N9S20287C12D0Ev,_ZTvn404_n40_N9S20287C12D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev)();
extern void ABISELECT(_ZThn9632_N9S20287C12D1Ev,_ZThn6612_N9S20287C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev)();
extern void ABISELECT(_ZThn9632_N9S20287C12D0Ev,_ZThn6612_N9S20287C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C6__A6__9S20287C12__9S20287C11[] = {
  ABISELECT(-9632,-6612),
  0,
  0,
  0,
  0,
  ABISELECT(-4048,-2700),
  ABISELECT(-4160,-2776),
  ABISELECT(-9632,-6612),
  (VTBL_ENTRY)&(_ZTI9S20287C12[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev),
};
extern void _ZN9S20287C13D1Ev();
extern void _ZN9S20287C13D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C13__A__9S20287C11[] = {
  ABISELECT(6448,4472),
  ABISELECT(6208,4320),
  ABISELECT(5712,3992),
  ABISELECT(3568,2552),
  ABISELECT(3528,2536),
  ABISELECT(2400,1772),
  ABISELECT(2288,1696),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN9S20287C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C89S20287C13__A2__9S20287C11[] = {
  ABISELECT(2400,1772),
  ABISELECT(2288,1696),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C89S20287C13__A7__9S20287C11[] = {
  ABISELECT(1952,1464),
  ABISELECT(1840,1388),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn1952_N8S20287C6D1Ev,_ZThn1464_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn1952_N8S20287C6D0Ev,_ZThn1464_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A7__9S20287C11[] = {
  0,
  ABISELECT(-1952,-1464),
  ABISELECT(-1952,-1464),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C89S20287C13__A2__9S20287C11[] = {
  ABISELECT(1952,1464),
  ABISELECT(1840,1388),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn2400_N8S20287C8D1Ev,_ZThn1772_N8S20287C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void ABISELECT(_ZThn2400_N8S20287C8D0Ev,_ZThn1772_N8S20287C8D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C89S20287C13__A2__9S20287C11[] = {
  0,
  ABISELECT(-2400,-1772),
  ABISELECT(-2400,-1772),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__9S20287C13__A__9S20287C11[] = {
  ABISELECT(1952,1464),
  ABISELECT(1840,1388),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn2400_N9S20287C13D1Ev,_ZThn1772_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn2400_N9S20287C13D0Ev,_ZThn1772_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__9S20287C13__A__9S20287C11[] = {
  0,
  ABISELECT(-2400,-1772),
  ABISELECT(-2400,-1772),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3528_N9S20287C13D1Ev,_ZThn2536_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3528_N9S20287C13D0Ev,_ZThn2536_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C13__A__9S20287C11[] = {
  ABISELECT(-3528,-2536),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  ABISELECT(-3528,-2536),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3568_N9S20287C13D1Ev,_ZThn2552_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3568_N9S20287C13D0Ev,_ZThn2552_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C13__A__9S20287C11[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-3568,-2552),
  0,
  0,
  0,
  0,
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  ABISELECT(-3568,-2552),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__9S20287C13__A__9S20287C11[] = {
  ABISELECT(-3712,-2640),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn5712_N9S20287C13D1Ev,_ZThn3992_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn5712_N9S20287C13D0Ev,_ZThn3992_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C13__A__9S20287C11[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-5712,-3992),
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  ABISELECT(-5712,-3992),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__9S20287C13__A__9S20287C11[] = {
  ABISELECT(-5920,-4148),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A2__9S20287C13__A__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-6160,-4300),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__9S20287C13__A__9S20287C11[] = {
  0,
  ABISELECT(-6208,-4320),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn6448_N9S20287C13D1Ev,_ZThn4472_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn6448_N9S20287C13D0Ev,_ZThn4472_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C6__A4__9S20287C13__A__9S20287C11[] = {
  ABISELECT(-6448,-4472),
  0,
  0,
  0,
  0,
  ABISELECT(-4048,-2700),
  ABISELECT(-4160,-2776),
  ABISELECT(-6448,-4472),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C5D1Ev();
extern void _ZN8S20287C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C5__9S20287C11[] = {
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C5__9S20287C11[] = {
  ABISELECT(1120,928),
  ABISELECT(1008,852),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C6D1Ev,_ZThn928_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C6D0Ev,_ZThn928_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C5__9S20287C11[] = {
  0,
  ABISELECT(-1120,-928),
  ABISELECT(-1120,-928),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C5D1Ev,_ZThn928_N8S20287C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev)();
extern void ABISELECT(_ZThn1120_N8S20287C5D0Ev,_ZThn928_N8S20287C5D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C5__9S20287C11[] = {
  0,
  ABISELECT(-1120,-928),
  ABISELECT(-1120,-928),
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN9S20287C13D1Ev();
extern void _ZN9S20287C13D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C13__9S20287C11[] = {
  ABISELECT(3952,2620),
  ABISELECT(3712,2468),
  ABISELECT(3216,2140),
  ABISELECT(1072,700),
  ABISELECT(1032,684),
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN9S20287C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C89S20287C13__9S20287C11[] = {
  ABISELECT(-96,-80),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C11[] = {
  ABISELECT(-544,-388),
  ABISELECT(-656,-464),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A2__9S20287C11[] = {
  0,
  ABISELECT(544,388),
  ABISELECT(544,388),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C89S20287C13__9S20287C11[] = {
  ABISELECT(-544,-388),
  ABISELECT(-656,-464),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C89S20287C13__9S20287C11[] = {
  0,
  ABISELECT(96,80),
  ABISELECT(96,80),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__9S20287C13__9S20287C11[] = {
  ABISELECT(-544,-388),
  ABISELECT(-656,-464),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__9S20287C13__9S20287C11[] = {
  0,
  ABISELECT(96,80),
  ABISELECT(96,80),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C13__9S20287C11[] = {
  ABISELECT(-1032,-684),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  ABISELECT(-1032,-684),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1072_N9S20287C13D1Ev,_ZThn700_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1072_N9S20287C13D0Ev,_ZThn700_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C13__9S20287C11[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-1072,-700),
  0,
  0,
  0,
  0,
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  ABISELECT(-1072,-700),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__9S20287C13__9S20287C11[] = {
  ABISELECT(-1216,-788),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3216_N9S20287C13D1Ev,_ZThn2140_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3216_N9S20287C13D0Ev,_ZThn2140_N9S20287C13D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C13__9S20287C11[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-3216,-2140),
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  ABISELECT(-3216,-2140),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__9S20287C13__9S20287C11[] = {
  ABISELECT(-3424,-2296),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A2__9S20287C13__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-3664,-2448),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__9S20287C13__9S20287C11[] = {
  0,
  ABISELECT(-3712,-2468),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn3952_N9S20287C13D1Ev,_ZThn2620_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn3952_N9S20287C13D0Ev,_ZThn2620_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C6__A4__9S20287C13__9S20287C11[] = {
  ABISELECT(-3952,-2620),
  0,
  0,
  0,
  0,
  ABISELECT(-4048,-2700),
  ABISELECT(-4160,-2776),
  ABISELECT(-3952,-2620),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C11[] = {
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C9__A5__9S20287C11[] = {
  ABISELECT(-1128,-764),
  ABISELECT(-1240,-840),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C9__A5__9S20287C11[] = {
  0,
  ABISELECT(1128,764),
  ABISELECT(1128,764),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9__9S20287C11[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-40,-16),
  0,
  0,
  0,
  0,
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  ABISELECT(-40,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C9__9S20287C11[] = {
  0,
  ABISELECT(1128,764),
  ABISELECT(1128,764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C11[] = {
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9__9S20287C11[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2184,-1456),
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  ABISELECT(-2184,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C11[] = {
  ABISELECT(-2392,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-2632,-1764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A2__8S20287C9__9S20287C11[] = {
  0,
  ABISELECT(-2680,-1784),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C11[] = {
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A3__9S20287C11[] = {
  ABISELECT(-1168,-780),
  ABISELECT(-1280,-856),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A3__9S20287C11[] = {
  0,
  ABISELECT(1168,780),
  ABISELECT(1168,780),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__9S20287C11[] = {
  0,
  ABISELECT(1168,780),
  ABISELECT(1168,780),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C11[] = {
  ABISELECT(-3312,-2220),
  ABISELECT(-3424,-2296),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A4__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A4__9S20287C11[] = {
  0,
  ABISELECT(3760,2528),
  ABISELECT(3760,2528),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A1__9S20287C11[] = {
  ABISELECT(-3760,-2528),
  ABISELECT(-3872,-2604),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C11[] = {
  0,
  ABISELECT(3312,2220),
  ABISELECT(3312,2220),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A6__9S20287C11[] = {
  ABISELECT(-4048,-2700),
  ABISELECT(-4160,-2776),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A6__9S20287C11[] = {
  0,
  ABISELECT(4048,2700),
  ABISELECT(4048,2700),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C11[] = {
  {&(_ZTV9S20287C11[11]),  11,207},
  {&(_tg__ZTV9S20287C12__9S20287C11[11]),  11,18},
  {&(_tg__ZTV8S20287C69S20287C12__A1__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C12__A1__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C12__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C5__9S20287C12__9S20287C11[9]),  9,15},
  {&(_tg__ZTV9S20287C13__9S20287C12__9S20287C11[19]),  19,25},
  {&(_tg__ZTV8S20287C28S20287C89S20287C13__9S20287C12__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C12__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C9__9S20287C12__9S20287C11[12]),  12,18},
  {&(_tg__ZTV9S20287C10__9S20287C12__9S20287C11[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__9S20287C12__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__9S20287C12__9S20287C11[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__9S20287C12__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A4__9S20287C12__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__9S20287C12__9S20287C11[3]),  3,4},
  {&(_tg__ZTV8S20287C79S20287C13__A3__9S20287C12__9S20287C11[2]),  2,5},
  {&(_tg__ZTV8S20287C6__A6__9S20287C12__9S20287C11[9]),  9,15},
  {&(_tg__ZTV9S20287C13__A__9S20287C11[9]),  9,15},
  {&(_tg__ZTV8S20287C89S20287C13__A2__9S20287C11[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C89S20287C13__A7__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A7__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C89S20287C13__A2__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C89S20287C13__A2__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C68S20287C8__9S20287C13__A__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__9S20287C13__A__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C9__9S20287C13__A__9S20287C11[12]),  12,18},
  {&(_tg__ZTV9S20287C10__9S20287C13__A__9S20287C11[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__9S20287C13__A__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__9S20287C13__A__9S20287C11[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__9S20287C13__A__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A2__9S20287C13__A__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__9S20287C13__A__9S20287C11[3]),  3,4},
  {&(_tg__ZTV8S20287C6__A4__9S20287C13__A__9S20287C11[9]),  9,15},
  {&(_ZTV9S20287C11[64]),  64,207},
  {&(_ZTV9S20287C11[74]),  74,207},
  {&(_ZTV9S20287C11[96]),  96,207},
  {&(_ZTV9S20287C11[104]),  104,207},
  {&(_ZTV9S20287C11[109]),  109,207},
  {&(_ZTV9S20287C11[132]),  132,207},
  {&(_ZTV9S20287C11[149]),  149,207},
  {&(_ZTV9S20287C11[158]),  158,207},
  {&(_ZTV9S20287C11[171]),  171,207},
  {&(_ZTV9S20287C11[177]),  177,207},
  {&(_ZTV9S20287C11[182]),  182,207},
  {&(_ZTV9S20287C11[191]),  191,207},
  {&(_ZTV9S20287C11[117]),  117,207},
  {&(_ZTV9S20287C11[201]),  201,207},
  {&(_ZTV9S20287C11[27]),  27,207},
  {&(_ZTV9S20287C11[40]),  40,207},
  {&(_tg__ZTV8S20287C5__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C68S20287C5__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C5__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C7__8S20287C5__9S20287C11[4]),  4,7},
  {&(_tg__ZTV9S20287C13__9S20287C11[9]),  9,15},
  {&(_tg__ZTV8S20287C89S20287C13__9S20287C11[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C89S20287C13__A2__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A2__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C89S20287C13__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C89S20287C13__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C68S20287C8__9S20287C13__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__9S20287C13__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C9__9S20287C13__9S20287C11[12]),  12,18},
  {&(_tg__ZTV9S20287C10__9S20287C13__9S20287C11[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__9S20287C13__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__9S20287C13__9S20287C11[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__9S20287C13__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A2__9S20287C13__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__9S20287C13__9S20287C11[3]),  3,4},
  {&(_tg__ZTV8S20287C6__A4__9S20287C13__9S20287C11[9]),  9,15},
  {&(_tg__ZTV8S20287C9__9S20287C11[7]),  7,13},
  {&(_tg__ZTV8S20287C68S20287C9__A5__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C9__A5__9S20287C11[4]),  4,7},
  {&(_tg__ZTV9S20287C10__8S20287C9__9S20287C11[11]),  11,18},
  {&(_tg__ZTV8S20287C7__8S20287C9__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C29S20287C10__8S20287C9__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C8__8S20287C9__9S20287C11[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A1__8S20287C9__9S20287C11[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A2__8S20287C9__9S20287C11[3]),  3,4},
  {&(_tg__ZTV9S20287C10__9S20287C11[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A3__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A3__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A1__9S20287C11[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A4__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A4__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A1__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A1__9S20287C11[4]),  4,7},
  {&(_tg__ZTV8S20287C6__A6__9S20287C11[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A6__9S20287C11[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20287C11[];
extern  VTBL_ENTRY _ZTV9S20287C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C11[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C5D0Ev,_ZThn928_N8S20287C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C5D1Ev,_ZThn928_N8S20287C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3216_N9S20287C13D0Ev,_ZThn2140_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5712_N9S20287C13D0Ev,_ZThn3992_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3216_N9S20287C13D1Ev,_ZThn2140_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5712_N9S20287C13D1Ev,_ZThn3992_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3952_N9S20287C13D0Ev,_ZThn2620_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S20287C13D0Ev,_ZThn700_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6448_N9S20287C13D0Ev,_ZThn4472_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3568_N9S20287C13D0Ev,_ZThn2552_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3952_N9S20287C13D1Ev,_ZThn2620_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S20287C13D1Ev,_ZThn700_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6448_N9S20287C13D1Ev,_ZThn4472_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3568_N9S20287C13D1Ev,_ZThn2552_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3528_N9S20287C13D0Ev,_ZThn2536_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3528_N9S20287C13D1Ev,_ZThn2536_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N9S20287C13D0Ev,_ZThn1772_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N9S20287C13D1Ev,_ZThn1772_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S20287C8D0Ev,_ZThn1772_N8S20287C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S20287C8D1Ev,_ZThn1772_N8S20287C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C12D0Ev,_ZTv0_n20_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8896_N9S20287C12D0Ev,_ZThn6132_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C12D1Ev,_ZTv0_n20_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8896_N9S20287C12D1Ev,_ZThn6132_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C12D0Ev,_ZTv0_n48_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6712_N9S20287C12D0Ev,_ZThn4676_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C12D1Ev,_ZTv0_n48_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6712_N9S20287C12D1Ev,_ZThn4676_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C12D0Ev,_ZTv0_n40_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5680_N9S20287C12D0Ev,_ZThn3992_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C12D1Ev,_ZTv0_n40_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5680_N9S20287C12D1Ev,_ZThn3992_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C12D0Ev,_ZTv0_n36_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9632_N9S20287C12D0Ev,_ZThn6612_N9S20287C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6752_N9S20287C12D0Ev,_ZThn4692_N9S20287C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4464_N9S20287C12D0Ev,_ZThn2984_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C12D1Ev,_ZTv0_n36_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9632_N9S20287C12D1Ev,_ZThn6612_N9S20287C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6752_N9S20287C12D1Ev,_ZThn4692_N9S20287C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4464_N9S20287C12D1Ev,_ZThn2984_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C12D0Ev,_ZTv0_n12_N9S20287C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N9S20287C12D0Ev,_ZThn3912_N9S20287C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C12D1Ev,_ZTv0_n12_N9S20287C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N9S20287C12D1Ev,_ZThn3912_N9S20287C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C6D0Ev,_ZThn928_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1952_N8S20287C6D0Ev,_ZThn1464_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N8S20287C6D0Ev,_ZThn3912_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1120_N8S20287C6D1Ev,_ZThn928_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1952_N8S20287C6D1Ev,_ZThn1464_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N8S20287C6D1Ev,_ZThn3912_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C11D0Ev,_ZTv0_n20_N9S20287C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8896_N9S20287C11D0Ev,_ZThn6132_N9S20287C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20287C11D1Ev,_ZTv0_n20_N9S20287C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8896_N9S20287C11D1Ev,_ZThn6132_N9S20287C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C11D0Ev,_ZTv0_n48_N9S20287C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6712_N9S20287C11D0Ev,_ZThn4676_N9S20287C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20287C11D1Ev,_ZTv0_n48_N9S20287C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6712_N9S20287C11D1Ev,_ZThn4676_N9S20287C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C11D0Ev,_ZTv0_n40_N9S20287C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5680_N9S20287C11D0Ev,_ZThn3992_N9S20287C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S20287C11D1Ev,_ZTv0_n40_N9S20287C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5680_N9S20287C11D1Ev,_ZThn3992_N9S20287C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C11D0Ev,_ZTv0_n12_N9S20287C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N9S20287C11D0Ev,_ZThn3912_N9S20287C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C11D1Ev,_ZTv0_n12_N9S20287C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N9S20287C11D1Ev,_ZThn3912_N9S20287C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C11D0Ev,_ZTv0_n36_N9S20287C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9632_N9S20287C11D0Ev,_ZThn6612_N9S20287C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6752_N9S20287C11D0Ev,_ZThn4692_N9S20287C11D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4464_N9S20287C11D0Ev,_ZThn2984_N9S20287C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C11D1Ev,_ZTv0_n36_N9S20287C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn9632_N9S20287C11D1Ev,_ZThn6612_N9S20287C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6752_N9S20287C11D1Ev,_ZThn4692_N9S20287C11D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4464_N9S20287C11D1Ev,_ZThn2984_N9S20287C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C11 = {  "S20287C11", // class name
  bases_S20287C11, 37,
  &(vtc_S20287C11[0]), // expected_vtbl_contents
  &(vtt_S20287C11[0]), // expected_vtt_contents
  ABISELECT(9664,6624), // object size
  NSPAIRA(_ZTI9S20287C11),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20287C11),207, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20287C11),91, //virtual table table var
  29, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C4  : S20287C5 , S20287C8 , virtual S20287C9 {
  int s20287c4f0;
  long s20287c4f1;
  __tsi64 s20287c4f2;
  ::S20287C2 s20287c4f3;
  int s20287c4f4;
  long s20287c4f5;
  int s20287c4f6;
  ::S20287C11 s20287c4f7;
  long double s20287c4f8[2];
  long s20287c4f9[2];
  virtual  ~S20287C4(); // _ZN8S20287C4D2Ev
  virtual void  v9(); // _ZN8S20287C42v9Ev
  S20287C4(); // tgen
};
//SIG(-1 S20287C4) C1{ BC2{ BC3{ VBC4{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC5{ vd v2 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v3 v4 v5 v6 Fi Fp} vd Fi Fl FL FC5[9] Fp Fi FC4 Fi[3] Fp[2]} BC6{ BC4 BC5 BC7{ v7 FL FD FC4 Fi Fs Fp[9] Fl[2]} BC3 vd v8 Fl Fi} VBC8{ VBC9{ VBC5 BC4 BC3 BC7 vd v9 Fi Fc Fp Fi FC7 Fi[5] FC3[6] FL:5} VBC6 BC3 VBC7 vd Fl} vd v1 Fi Fl FL FC7 Fi Fl Fi FC10{ VBC2 BC11{ VBC4 BC3 VBC2 VBC12{ BC4 BC6 VBC8 BC5 VBC3 vd v10 v11 Fl FC7 Fi Fl[9] Fp} vd v12 FC8 Fs FL[4]} BC12 BC13{ v13 v14 Fi Fp Fc Fi FD FL Fp[2] FL FL:64 FL:14 Fl Fp} BC4 Fl FL:21} FD[2] Fl[2]}


 S20287C4 ::~S20287C4(){ note_dtor("S20287C4", this);}
void  S20287C4 ::v9(){vfunc_called(this, "_ZN8S20287C42v9Ev");}
S20287C4 ::S20287C4(){ note_ctor("S20287C4", this);} // tgen

static void Test_S20287C4()
{
  extern Class_Descriptor cd_S20287C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(915,2528)];
    init_test(&cd_S20287C4, buf);
    S20287C4 *dp, &lv = *(dp=new (buf) S20287C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14624,10108), "sizeof(S20287C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C4)");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C5*), ABISELECT(11504,8016), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(11504,8016), "S20287C4");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(11504,8016), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(11504,8016), "S20287C4");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C9*), ABISELECT(11504,8016), "S20287C4");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C5*), ABISELECT(11616,8092), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(11616,8092), "S20287C4");
    check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(11616,8092), "S20287C4");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(11616,8092), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(11616,8092), "S20287C4");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C9*), ABISELECT(11616,8092), "S20287C4");
    check_base_class_offset(lv, (S20287C6*)(S20287C5*), 0, "S20287C4");
    check_base_class_offset(lv, (S20287C5*), 0, "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(1104,932), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(1008,852), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(1216,1008), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(1456,1160), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C8*), ABISELECT(1008,852), "S20287C4");
    /*is_ambiguous_... S20287C10::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(11776,8200), "S20287C4");
    check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(11744,8188), "S20287C4");
    check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(11888,8276), "S20287C4");
    check_base_class_offset(lv, (S20287C10*)(S20287C9*), ABISELECT(11744,8188), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(13984,9708), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(13888,9628), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(14096,9784), "S20287C4");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(14336,9936), "S20287C4");
    check_base_class_offset(lv, (S20287C8*)(S20287C9*), ABISELECT(13888,9628), "S20287C4");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C9*), ABISELECT(11704,8172), "S20287C4");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C9*), ABISELECT(14384,9956), "S20287C4");
    check_base_class_offset(lv, (S20287C9*), ABISELECT(11704,8172), "S20287C4");
    check_field_offset(lv, s20287c4f0, ABISELECT(1492,1180), "S20287C4.s20287c4f0");
    check_field_offset(lv, s20287c4f1, ABISELECT(1496,1184), "S20287C4.s20287c4f1");
    check_field_offset(lv, s20287c4f2, ABISELECT(1504,1188), "S20287C4.s20287c4f2");
    check_field_offset(lv, s20287c4f3, ABISELECT(1520,1196), "S20287C4.s20287c4f3");
    check_field_offset(lv, s20287c4f4, ABISELECT(1760,1348), "S20287C4.s20287c4f4");
    check_field_offset(lv, s20287c4f5, ABISELECT(1768,1352), "S20287C4.s20287c4f5");
    check_field_offset(lv, s20287c4f6, ABISELECT(1776,1356), "S20287C4.s20287c4f6");
    check_field_offset(lv, s20287c4f7, ABISELECT(1792,1360), "S20287C4.s20287c4f7");
    check_field_offset(lv, s20287c4f8, ABISELECT(11456,7984), "S20287C4.s20287c4f8");
    check_field_offset(lv, s20287c4f9, ABISELECT(11488,8008), "S20287C4.s20287c4f9");
    test_class_info(&lv, &cd_S20287C4);
    dp->~S20287C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C4(Test_S20287C4, "S20287C4", ABISELECT(14624,10108));

#else // __cplusplus

extern void _ZN8S20287C4C1Ev();
extern void _ZN8S20287C4D2Ev();
Name_Map name_map_S20287C4[] = {
  NSPAIR(_ZN8S20287C4C1Ev),
  NSPAIR(_ZN8S20287C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C5;
extern VTBL_ENTRY _ZTI8S20287C5[];
extern  VTBL_ENTRY _ZTV8S20287C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C5[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C9;
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
static Base_Class bases_S20287C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(11504,8016), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(11616,8092), //bcp->offset
    36, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20287C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(1104,932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(1008,852), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(1216,1008), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(1456,1160), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(1008,852), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20287C3,    ABISELECT(11776,8200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(11744,8188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(11888,8276), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(11744,8188), //bcp->offset
    61, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(13984,9708), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(13888,9628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(14096,9784), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(14336,9936), //bcp->offset
    101, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(13888,9628), //bcp->offset
    82, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(11704,8172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(14384,9956), //bcp->offset
    111, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20287C9,    ABISELECT(11704,8172), //bcp->offset
    43, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C4[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C4D1Ev();
extern void _ZN8S20287C4D0Ev();
extern void _ZN8S20287C42v9Ev();
extern void ABISELECT(_ZThn1008_N8S20287C4D1Ev,_ZThn852_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn1008_N8S20287C4D0Ev,_ZThn852_N8S20287C4D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn1456_N8S20287C4D1Ev,_ZThn1160_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn1456_N8S20287C4D0Ev,_ZThn1160_N8S20287C4D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C4D1Ev,_ZThn8092_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C4D0Ev,_ZThn8092_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11704_N8S20287C4D1Ev,_ZThn8172_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11704_N8S20287C4D0Ev,_ZThn8172_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11744_N8S20287C4D1Ev,_ZThn8188_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11744_N8S20287C4D0Ev,_ZThn8188_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn13888_N8S20287C4D1Ev,_ZThn9628_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn13888_N8S20287C4D0Ev,_ZThn9628_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C4D1Ev,_ZTvn308_n20_N8S20287C4D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C4D0Ev,_ZTvn308_n20_N8S20287C4D0Ev)();
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY vtc_S20287C4[] = {
  ABISELECT(14384,9956),
  ABISELECT(13888,9628),
  ABISELECT(11744,8188),
  ABISELECT(11704,8172),
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C42v9Ev,
  ABISELECT(10608,7240),
  ABISELECT(10496,7164),
  ABISELECT(-1008,-852),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1008_N8S20287C4D1Ev,_ZThn852_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1008_N8S20287C4D0Ev,_ZThn852_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-1216,-1008),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  ABISELECT(-1456,-1160),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1456_N8S20287C4D1Ev,_ZThn1160_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1456_N8S20287C4D0Ev,_ZThn1160_N8S20287C4D0Ev),
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-11704,-8172),
  0,
  0,
  0,
  0,
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  ABISELECT(-11704,-8172),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev),
  ABISELECT(144,88),
  0,
  ABISELECT(-11744,-8188),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-11744,-8188),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-11888,-8276),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-13888,-9628),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-13888,-9628),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-14096,-9784),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-14336,-9936),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C4D1Ev,_ZTvn308_n20_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C4D0Ev,_ZTvn308_n20_N8S20287C4D0Ev),
  0,
  ABISELECT(-14384,-9956),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern VTBL_ENTRY _ZTV8S20287C4[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C5D1Ev();
extern void _ZN8S20287C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C5__8S20287C4[] = {
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C5__8S20287C4[] = {
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C6D1Ev,_ZThn8092_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C6D0Ev,_ZThn8092_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C5__8S20287C4[] = {
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C5D1Ev,_ZThn8092_N8S20287C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C5D0Ev,_ZThn8092_N8S20287C5D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C5__8S20287C4[] = {
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A__8S20287C4[] = {
  ABISELECT(10608,7240),
  ABISELECT(10496,7164),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C4[] = {
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn10160_N8S20287C6D1Ev,_ZThn6932_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn10160_N8S20287C6D0Ev,_ZThn6932_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A1__8S20287C4[] = {
  0,
  ABISELECT(-10160,-6932),
  ABISELECT(-10160,-6932),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A__8S20287C4[] = {
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn10608_N8S20287C8D1Ev,_ZThn7240_N8S20287C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void ABISELECT(_ZThn10608_N8S20287C8D0Ev,_ZThn7240_N8S20287C8D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A__8S20287C4[] = {
  0,
  ABISELECT(-10608,-7240),
  ABISELECT(-10608,-7240),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C9__8S20287C4[] = {
  ABISELECT(2680,1784),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C9__A4__8S20287C4[] = {
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C9__A4__8S20287C4[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9__8S20287C4[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-40,-16),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-40,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C9__8S20287C4[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__8S20287C9__8S20287C4[] = {
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9__8S20287C4[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2184,-1456),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-2184,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A1__8S20287C9__8S20287C4[] = {
  ABISELECT(-2392,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9__8S20287C4[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-2632,-1764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A2__8S20287C9__8S20287C4[] = {
  0,
  ABISELECT(-2680,-1784),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C4[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A2__8S20287C4[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A2__8S20287C4[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__8S20287C4[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__8S20287C4[] = {
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A3__8S20287C4[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A3__8S20287C4[] = {
  0,
  ABISELECT(2720,1844),
  ABISELECT(2720,1844),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A1__8S20287C4[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A1__8S20287C4[] = {
  0,
  ABISELECT(2272,1536),
  ABISELECT(2272,1536),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C4[] = {
  {&(_ZTV8S20287C4[8]),  8,115},
  {&(_tg__ZTV8S20287C5__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C68S20287C5__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C5__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C7__8S20287C5__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A__8S20287C4[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A1__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A__8S20287C4[4]),  4,7},
  {&(_ZTV8S20287C4[40]),  40,115},
  {&(_ZTV8S20287C4[19]),  19,115},
  {&(_ZTV8S20287C4[30]),  30,115},
  {&(_ZTV8S20287C4[55]),  55,115},
  {&(_ZTV8S20287C4[72]),  72,115},
  {&(_ZTV8S20287C4[81]),  81,115},
  {&(_ZTV8S20287C4[94]),  94,115},
  {&(_ZTV8S20287C4[100]),  100,115},
  {&(_ZTV8S20287C4[105]),  105,115},
  {&(_ZTV8S20287C4[114]),  114,115},
  {&(_tg__ZTV8S20287C9__8S20287C4[7]),  7,13},
  {&(_tg__ZTV8S20287C68S20287C9__A4__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C9__A4__8S20287C4[4]),  4,7},
  {&(_tg__ZTV9S20287C10__8S20287C9__8S20287C4[11]),  11,18},
  {&(_tg__ZTV8S20287C7__8S20287C9__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C29S20287C10__8S20287C9__8S20287C4[2]),  2,3},
  {&(_tg__ZTV8S20287C8__8S20287C9__8S20287C4[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A1__8S20287C9__8S20287C4[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A2__8S20287C9__8S20287C4[3]),  3,4},
  {&(_tg__ZTV9S20287C10__8S20287C4[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A2__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A2__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A1__8S20287C4[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A3__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A3__8S20287C4[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A1__8S20287C4[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A1__8S20287C4[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S20287C4[];
extern  VTBL_ENTRY _ZTV8S20287C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C4[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10608_N8S20287C8D0Ev,_ZThn7240_N8S20287C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10608_N8S20287C8D1Ev,_ZThn7240_N8S20287C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C5D0Ev,_ZThn8092_N8S20287C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C5D1Ev,_ZThn8092_N8S20287C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10160_N8S20287C6D0Ev,_ZThn6932_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C6D0Ev,_ZThn8092_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10160_N8S20287C6D1Ev,_ZThn6932_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C6D1Ev,_ZThn8092_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13888_N8S20287C4D0Ev,_ZThn9628_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13888_N8S20287C4D1Ev,_ZThn9628_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11744_N8S20287C4D0Ev,_ZThn8188_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11744_N8S20287C4D1Ev,_ZThn8188_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11704_N8S20287C4D0Ev,_ZThn8172_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11704_N8S20287C4D1Ev,_ZThn8172_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C4D0Ev,_ZThn8092_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C4D1Ev,_ZThn8092_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C4 = {  "S20287C4", // class name
  bases_S20287C4, 21,
  &(vtc_S20287C4[0]), // expected_vtbl_contents
  &(vtt_S20287C4[0]), // expected_vtt_contents
  ABISELECT(14624,10108), // object size
  NSPAIRA(_ZTI8S20287C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20287C4),115, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C4),39, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20287C1  : virtual S20287C2 , virtual S20287C4 , virtual S20287C13 , S20287C10 {
  long s20287c1f0;
  void *s20287c1f1;
  long s20287c1f2;
  ::S20287C8 s20287c1f3;
  void *s20287c1f4;
  char s20287c1f5;
  virtual  ~S20287C1(); // _ZN8S20287C1D2Ev
  S20287C1(); // tgen
};
//SIG(1 S20287C1) C1{ VBC2{ v1 FL FD FC3{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} Fi Fs Fp[9] Fl[2]} VBC4{ BC5{ BC6{ VBC3 VBC7{ vd v2 FL FL:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v3 v4 v5 v6 Fi Fp} vd Fi Fl FL FC7[9] Fp Fi FC3 Fi[3] Fp[2]} BC8{ BC3 BC7 BC2 BC6 vd v7 Fl Fi} VBC9{ VBC10{ VBC7 BC3 BC6 BC2 vd v8 Fi Fc Fp Fi FC2 Fi[5] FC6[6] FL:5} VBC8 BC6 VBC2 vd Fl} vd v9 Fi Fl FL FC2 Fi Fl Fi FC11{ VBC5 BC12{ VBC3 BC6 VBC5 VBC13{ BC3 BC8 VBC9 BC7 VBC6 vd v10 v11 Fl FC2 Fi Fl[9] Fp} vd v12 FC9 Fs FL[4]} BC13 BC14{ v13 v14 Fi Fp Fc Fi FD FL Fp[2] FL FL:64 FL:14 Fl Fp} BC3 Fl FL:21} FD[2] Fl[2]} VBC13 BC10 vd Fl Fp Fl FC8 Fp Fc}


 S20287C1 ::~S20287C1(){ note_dtor("S20287C1", this);}
S20287C1 ::S20287C1(){ note_ctor("S20287C1", this);} // tgen

static void Test_S20287C1()
{
  extern Class_Descriptor cd_S20287C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1161,3188)];
    init_test(&cd_S20287C1, buf);
    S20287C1 *dp, &lv = *(dp=new (buf) S20287C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(18560,12748), "sizeof(S20287C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20287C1)");
    /*is_ambiguous_... S20287C1::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*), ABISELECT(2880,1944), "S20287C1");
    /*is_ambiguous_... S20287C9::S20287C2 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C9*), ABISELECT(2880,1944), "S20287C1");
    check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C5*)(S20287C4*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*)(S20287C4*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C9*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*), ABISELECT(14624,10112), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C6*)(S20287C10*), ABISELECT(14624,10112), "S20287C1");
    check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C5*)(S20287C4*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*)(S20287C4*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C9*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C10*), ABISELECT(14736,10188), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C6*)(S20287C10*), ABISELECT(14736,10188), "S20287C1");
    check_base_class_offset(lv, (S20287C6*)(S20287C5*)(S20287C4*), ABISELECT(3120,2096), "S20287C1");
    check_base_class_offset(lv, (S20287C5*)(S20287C4*), ABISELECT(3120,2096), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*)(S20287C4*), ABISELECT(4224,3028), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*)(S20287C4*), ABISELECT(4128,2948), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*)(S20287C4*), ABISELECT(4336,3104), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*)(S20287C4*), ABISELECT(4576,3256), "S20287C1");
    /*is_ambiguous_... S20287C4::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C8*)(S20287C4*), ABISELECT(4128,2948), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(14896,10296), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C10*), ABISELECT(14864,10284), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(15008,10372), "S20287C1");
    check_base_class_offset(lv, (S20287C10*)(S20287C9*), ABISELECT(14864,10284), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*), ABISELECT(17104,11804), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*), ABISELECT(17008,11724), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*), ABISELECT(17216,11880), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*), ABISELECT(17456,12032), "S20287C1");
    check_base_class_offset(lv, (S20287C8*)(S20287C9*), ABISELECT(17008,11724), "S20287C1");
    /*is_ambiguous_... S20287C9::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C9*), ABISELECT(14824,10268), "S20287C1");
    check_base_class_offset(lv, (S20287C9*)(S20287C4*), ABISELECT(14824,10268), "S20287C1");
    check_base_class_offset(lv, (S20287C9*)(S20287C13*), ABISELECT(14824,10268), "S20287C1");
    check_base_class_offset(lv, (S20287C4*), ABISELECT(3120,2096), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C3 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C13*), ABISELECT(18000,12380), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C8*)(S20287C13*), ABISELECT(17600,12132), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C8*)(S20287C13*), ABISELECT(17504,12052), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C8*)(S20287C13*), ABISELECT(17712,12208), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C8*)(S20287C13*), ABISELECT(17952,12360), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C8 */ AMB_check_base_class_offset(lv, (S20287C8*)(S20287C13*), ABISELECT(17504,12052), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C7 */ AMB_check_base_class_offset(lv, (S20287C7*)(S20287C13*), ABISELECT(18112,12456), "S20287C1");
    /*is_ambiguous_... S20287C13::S20287C6 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C13*), ABISELECT(18536,12736), "S20287C1");
    check_base_class_offset(lv, (S20287C13*), ABISELECT(17504,12052), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C3*)(S20287C10*), ABISELECT(32,12), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C6*)(S20287C10*), 0, "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C2*)(S20287C10*), ABISELECT(144,88), "S20287C1");
    /*is_ambiguous_... S20287C1::S20287C10 */ AMB_check_base_class_offset(lv, (S20287C10*), 0, "S20287C1");
    check_field_offset(lv, s20287c1f0, ABISELECT(2136,1440), "S20287C1.s20287c1f0");
    check_field_offset(lv, s20287c1f1, ABISELECT(2144,1444), "S20287C1.s20287c1f1");
    check_field_offset(lv, s20287c1f2, ABISELECT(2152,1448), "S20287C1.s20287c1f2");
    check_field_offset(lv, s20287c1f3, ABISELECT(2160,1452), "S20287C1.s20287c1f3");
    check_field_offset(lv, s20287c1f4, ABISELECT(2864,1936), "S20287C1.s20287c1f4");
    check_field_offset(lv, s20287c1f5, ABISELECT(2872,1940), "S20287C1.s20287c1f5");
    test_class_info(&lv, &cd_S20287C1);
    dp->~S20287C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20287C1(Test_S20287C1, "S20287C1", ABISELECT(18560,12748));

#else // __cplusplus

extern void _ZN8S20287C1C1Ev();
extern void _ZN8S20287C1D2Ev();
Name_Map name_map_S20287C1[] = {
  NSPAIR(_ZN8S20287C1C1Ev),
  NSPAIR(_ZN8S20287C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C5;
extern VTBL_ENTRY _ZTI8S20287C5[];
extern  VTBL_ENTRY _ZTV8S20287C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C5[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C9;
extern VTBL_ENTRY _ZTI8S20287C9[];
extern  VTBL_ENTRY _ZTV8S20287C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C9[];
extern Class_Descriptor cd_S20287C4;
extern VTBL_ENTRY _ZTI8S20287C4[];
extern  VTBL_ENTRY _ZTV8S20287C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C4[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C8;
extern VTBL_ENTRY _ZTI8S20287C8[];
extern  VTBL_ENTRY _ZTV8S20287C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C8[];
extern Class_Descriptor cd_S20287C7;
extern VTBL_ENTRY _ZTI8S20287C7[];
extern  VTBL_ENTRY _ZTV8S20287C7[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C13;
extern VTBL_ENTRY _ZTI9S20287C13[];
extern  VTBL_ENTRY _ZTV9S20287C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C13[];
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20287C6;
extern VTBL_ENTRY _ZTI8S20287C6[];
extern  VTBL_ENTRY _ZTV8S20287C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C6[];
extern Class_Descriptor cd_S20287C2;
extern VTBL_ENTRY _ZTI8S20287C2[];
extern  VTBL_ENTRY _ZTV8S20287C2[];
extern Class_Descriptor cd_S20287C10;
extern VTBL_ENTRY _ZTI9S20287C10[];
extern  VTBL_ENTRY _ZTV9S20287C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20287C10[];
static Base_Class bases_S20287C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C2,    ABISELECT(2880,1944), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(14624,10112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20287C7,    ABISELECT(14736,10188), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(3120,2096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20287C5,    ABISELECT(3120,2096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(4224,3028), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(4128,2948), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(4336,3104), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(4576,3256), //bcp->offset
    60, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(4128,2948), //bcp->offset
    49, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(14896,10296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(14864,10284), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(15008,10372), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20287C10,    ABISELECT(14864,10284), //bcp->offset
    95, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20287C3,    ABISELECT(17104,11804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(17008,11724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(17216,11880), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(17456,12032), //bcp->offset
    135, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(17008,11724), //bcp->offset
    116, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S20287C6,    ABISELECT(14824,10268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20287C9,    ABISELECT(14824,10268), //bcp->offset
    77, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S20287C4,    ABISELECT(3120,2096), //bcp->offset
    25, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(18000,12380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20287C3,    ABISELECT(17600,12132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(17504,12052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(17712,12208), //bcp->offset
    170, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(17952,12360), //bcp->offset
    173, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20287C8,    ABISELECT(17504,12052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20287C7,    ABISELECT(18112,12456), //bcp->offset
    183, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20287C6,    ABISELECT(18536,12736), //bcp->offset
    188, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    78, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S20287C13,    ABISELECT(17504,12052), //bcp->offset
    145, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20287C3,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C2,    ABISELECT(144,88), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20287C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20287C1[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C1D1Ev();
extern void _ZN8S20287C1D0Ev();
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n104_N8S20287C1D1Ev,_ZTv0_n52_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn3120_N8S20287C1D1Ev,_ZThn2096_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n104_N8S20287C1D0Ev,_ZTv0_n52_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn3120_N8S20287C1D0Ev,_ZThn2096_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN8S20287C42v9Ev();
extern void ABISELECT(_ZTvn1008_n104_N8S20287C1D1Ev,_ZTvn852_n52_N8S20287C1D1Ev)();
extern void ABISELECT(_ZTvn1008_n104_N8S20287C1D0Ev,_ZTvn852_n52_N8S20287C1D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn1456_n104_N8S20287C1D1Ev,_ZTvn1160_n52_N8S20287C1D1Ev)();
extern void ABISELECT(_ZTvn1456_n104_N8S20287C1D0Ev,_ZTvn1160_n52_N8S20287C1D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C1D1Ev,_ZTv0_n12_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn14736_N8S20287C1D1Ev,_ZThn10188_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C1D0Ev,_ZTv0_n12_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn14736_N8S20287C1D0Ev,_ZThn10188_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N8S20287C1D1Ev,_ZTv0_n48_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn14824_N8S20287C1D1Ev,_ZThn10268_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S20287C1D0Ev,_ZTv0_n48_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn14824_N8S20287C1D0Ev,_ZThn10268_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C1D1Ev,_ZTv0_n36_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn14864_N8S20287C1D1Ev,_ZThn10284_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C1D0Ev,_ZTv0_n36_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn14864_N8S20287C1D0Ev,_ZThn10284_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
extern void _ZN8S20287C22v6Ev();
extern void ABISELECT(_ZTv0_n40_N8S20287C1D1Ev,_ZTv0_n20_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn17008_N8S20287C1D1Ev,_ZThn11724_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C1D0Ev,_ZTv0_n20_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn17008_N8S20287C1D0Ev,_ZThn11724_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C1D1Ev,_ZTvn308_n20_N8S20287C1D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C1D0Ev,_ZTvn308_n20_N8S20287C1D0Ev)();
extern void ABISELECT(_ZTv0_n80_N8S20287C1D1Ev,_ZTv0_n40_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn17504_N8S20287C1D1Ev,_ZThn12052_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S20287C1D0Ev,_ZTv0_n40_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn17504_N8S20287C1D0Ev,_ZThn12052_N8S20287C1D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
extern void _ZN8S20287C22v6Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n80_N8S20287C1D1Ev,_ZTvn308_n40_N8S20287C1D1Ev)();
extern void ABISELECT(_ZTvn448_n80_N8S20287C1D0Ev,_ZTvn308_n40_N8S20287C1D0Ev)();
extern void ABISELECT(_ZTvn608_n80_N8S20287C1D1Ev,_ZTvn404_n40_N8S20287C1D1Ev)();
extern void ABISELECT(_ZTvn608_n80_N8S20287C1D0Ev,_ZTvn404_n40_N8S20287C1D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C1D1Ev,_ZTv0_n36_N8S20287C1D1Ev)();
extern void ABISELECT(_ZThn18536_N8S20287C1D1Ev,_ZThn12736_N8S20287C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C1D0Ev,_ZTv0_n36_N8S20287C1D0Ev)();
extern void ABISELECT(_ZThn18536_N8S20287C1D0Ev,_ZThn12736_N8S20287C1D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20287C1[] = {
  ABISELECT(18536,12736),
  ABISELECT(17504,12052),
  ABISELECT(17008,11724),
  ABISELECT(14864,10284),
  ABISELECT(14824,10268),
  ABISELECT(3120,2096),
  ABISELECT(2880,1944),
  ABISELECT(14736,10188),
  ABISELECT(14624,10112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C1D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  0,
  ABISELECT(-2880,-1944),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(1216,1008),
  ABISELECT(1008,852),
  ABISELECT(1008,852),
  0,
  ABISELECT(-3120,-2096),
  0,
  0,
  0,
  0,
  ABISELECT(-240,-152),
  ABISELECT(13888,9628),
  ABISELECT(11744,8188),
  ABISELECT(11704,8172),
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  ABISELECT(-3120,-2096),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N8S20287C1D1Ev,_ZTv0_n52_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N8S20287C1D0Ev,_ZTv0_n52_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C42v9Ev,
  ABISELECT(10608,7240),
  ABISELECT(10496,7164),
  ABISELECT(-4128,-2948),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1008_n104_N8S20287C1D1Ev,_ZTvn852_n52_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1008_n104_N8S20287C1D0Ev,_ZTvn852_n52_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-4336,-3104),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  ABISELECT(-4576,-3256),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1456_n104_N8S20287C1D1Ev,_ZTvn1160_n52_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1456_n104_N8S20287C1D0Ev,_ZTvn1160_n52_N8S20287C1D0Ev),
  0,
  ABISELECT(-14736,-10188),
  ABISELECT(-14736,-10188),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C1D1Ev,_ZTv0_n12_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C1D0Ev,_ZTv0_n12_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-14824,-10268),
  0,
  0,
  0,
  0,
  ABISELECT(-11944,-8324),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  ABISELECT(-14824,-10268),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C1D1Ev,_ZTv0_n48_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C1D0Ev,_ZTv0_n48_N8S20287C1D0Ev),
  ABISELECT(144,88),
  0,
  ABISELECT(-14864,-10284),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-14864,-10284),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C1D1Ev,_ZTv0_n36_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C1D0Ev,_ZTv0_n36_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
  ABISELECT(-15008,-10372),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-17008,-11724),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-17008,-11724),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C1D1Ev,_ZTv0_n20_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C1D0Ev,_ZTv0_n20_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  ABISELECT(-17216,-11880),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-17456,-12032),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C1D1Ev,_ZTvn308_n20_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C1D0Ev,_ZTvn308_n20_N8S20287C1D0Ev),
  0,
  0,
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-17504,-12052),
  ABISELECT(1032,684),
  ABISELECT(-14624,-10108),
  ABISELECT(-496,-328),
  ABISELECT(-2640,-1768),
  ABISELECT(-2680,-1784),
  ABISELECT(-2768,-1864),
  ABISELECT(-2880,-1940),
  ABISELECT(-17504,-12052),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20287C1D1Ev,_ZTv0_n40_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S20287C1D0Ev,_ZTv0_n40_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
  ABISELECT(-17712,-12208),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
  ABISELECT(-3216,-2172),
  ABISELECT(-3328,-2248),
  ABISELECT(-17952,-12360),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N8S20287C1D1Ev,_ZTvn308_n40_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n80_N8S20287C1D0Ev,_ZTvn308_n40_N8S20287C1D0Ev),
  ABISELECT(-18112,-12456),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N8S20287C1D1Ev,_ZTvn404_n40_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn608_n80_N8S20287C1D0Ev,_ZTvn404_n40_N8S20287C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  ABISELECT(-18536,-12736),
  0,
  0,
  0,
  0,
  ABISELECT(-3800,-2548),
  ABISELECT(-3912,-2624),
  ABISELECT(-18536,-12736),
  (VTBL_ENTRY)&(_ZTI8S20287C1[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C1D1Ev,_ZTv0_n36_N8S20287C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C1D0Ev,_ZTv0_n36_N8S20287C1D0Ev),
};
extern VTBL_ENTRY _ZTV8S20287C1[];
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__A__8S20287C1[] = {
  ABISELECT(14736,10188),
  ABISELECT(14624,10112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A7__8S20287C1[] = {
  ABISELECT(14736,10188),
  ABISELECT(14624,10112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn14736_N8S20287C6D1Ev,_ZThn10188_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn14736_N8S20287C6D0Ev,_ZThn10188_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A7__8S20287C1[] = {
  0,
  ABISELECT(-14736,-10188),
  ABISELECT(-14736,-10188),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZThn14736_N9S20287C10D1Ev,_ZThn10188_N9S20287C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void ABISELECT(_ZThn14736_N9S20287C10D0Ev,_ZThn10188_N9S20287C10D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__A__8S20287C1[] = {
  0,
  ABISELECT(-14736,-10188),
  ABISELECT(-14736,-10188),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C4D1Ev();
extern void _ZN8S20287C4D0Ev();
extern void _ZN8S20287C42v9Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C4__8S20287C1[] = {
  ABISELECT(-240,-152),
  ABISELECT(13888,9628),
  ABISELECT(11744,8188),
  ABISELECT(11704,8172),
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C42v9Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C5D1Ev();
extern void _ZN8S20287C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C58S20287C4__8S20287C1[] = {
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C5D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C58S20287C4__8S20287C1[] = {
  ABISELECT(11616,8092),
  ABISELECT(11504,8016),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C6D1Ev,_ZThn8092_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C6D0Ev,_ZThn8092_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C58S20287C4__8S20287C1[] = {
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C5D1Ev,_ZThn8092_N8S20287C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C5D0Ev,_ZThn8092_N8S20287C5D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C58S20287C4__8S20287C1[] = {
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C88S20287C4__8S20287C1[] = {
  ABISELECT(10608,7240),
  ABISELECT(10496,7164),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C88S20287C4__A1__8S20287C1[] = {
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZThn10160_N8S20287C6D1Ev,_ZThn6932_N8S20287C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void ABISELECT(_ZThn10160_N8S20287C6D0Ev,_ZThn6932_N8S20287C6D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C88S20287C4__A1__8S20287C1[] = {
  0,
  ABISELECT(-10160,-6932),
  ABISELECT(-10160,-6932),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C88S20287C4__8S20287C1[] = {
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn10608_N8S20287C8D1Ev,_ZThn7240_N8S20287C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void ABISELECT(_ZThn10608_N8S20287C8D0Ev,_ZThn7240_N8S20287C8D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C88S20287C4__8S20287C1[] = {
  0,
  ABISELECT(-10608,-7240),
  ABISELECT(-10608,-7240),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C4D1Ev,_ZThn8092_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11616_N8S20287C4D0Ev,_ZThn8092_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C4__8S20287C1[] = {
  0,
  ABISELECT(-11616,-8092),
  ABISELECT(-11616,-8092),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZThn1008_N8S20287C4D1Ev,_ZThn852_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn1008_N8S20287C4D0Ev,_ZThn852_N8S20287C4D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A__8S20287C4__8S20287C1[] = {
  ABISELECT(10608,7240),
  ABISELECT(10496,7164),
  ABISELECT(-1008,-852),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1008_N8S20287C4D1Ev,_ZThn852_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1008_N8S20287C4D0Ev,_ZThn852_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn1456_N8S20287C4D1Ev,_ZThn1160_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn1456_N8S20287C4D0Ev,_ZThn1160_N8S20287C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C4__8S20287C1[] = {
  ABISELECT(10160,6932),
  ABISELECT(10048,6856),
  ABISELECT(-1456,-1160),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1456_N8S20287C4D1Ev,_ZThn1160_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1456_N8S20287C4D0Ev,_ZThn1160_N8S20287C4D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11704_N8S20287C4D1Ev,_ZThn8172_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11704_N8S20287C4D0Ev,_ZThn8172_N8S20287C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C9__8S20287C4__8S20287C1[] = {
  ABISELECT(-11704,-8172),
  0,
  0,
  0,
  0,
  ABISELECT(-11944,-8324),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  ABISELECT(-11704,-8172),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn11744_N8S20287C4D1Ev,_ZThn8188_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn11744_N8S20287C4D0Ev,_ZThn8188_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C4__8S20287C1[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-11744,-8188),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-11744,-8188),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__8S20287C4__8S20287C1[] = {
  ABISELECT(-11888,-8276),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev)();
extern void ABISELECT(_ZThn13888_N8S20287C4D1Ev,_ZThn9628_N8S20287C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev)();
extern void ABISELECT(_ZThn13888_N8S20287C4D0Ev,_ZThn9628_N8S20287C4D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__8S20287C4__8S20287C1[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-13888,-9628),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-13888,-9628),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__8S20287C4__8S20287C1[] = {
  ABISELECT(-14096,-9784),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C4D1Ev,_ZTvn308_n20_N8S20287C4D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C4D0Ev,_ZTvn308_n20_N8S20287C4D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A3__8S20287C4__8S20287C1[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-14336,-9936),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C4D1Ev,_ZTvn308_n20_N8S20287C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C4D0Ev,_ZTvn308_n20_N8S20287C4D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__8S20287C4__8S20287C1[] = {
  0,
  ABISELECT(240,152),
  (VTBL_ENTRY)&(_ZTI8S20287C4[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C9D1Ev();
extern void _ZN8S20287C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C9__8S20287C1[] = {
  ABISELECT(-11944,-8324),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C9D0Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C9__A4__8S20287C1[] = {
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C9__A4__8S20287C1[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C9__8S20287C1[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(-40,-16),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(-40,-16),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C9__8S20287C1[] = {
  0,
  ABISELECT(88,80),
  ABISELECT(88,80),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D1Ev,_ZTv0_n12_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C9D0Ev,_ZTv0_n12_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__8S20287C9__8S20287C1[] = {
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev)();
extern void ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev)() __attribute__((weak));
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__8S20287C9__8S20287C1[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(-2184,-1456),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(-2184,-1456),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A1__8S20287C9__8S20287C1[] = {
  ABISELECT(-2392,-1612),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A1__8S20287C9__8S20287C1[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-2632,-1764),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D1Ev,_ZTvn308_n20_N8S20287C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N8S20287C9D0Ev,_ZTvn308_n20_N8S20287C9D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A2__8S20287C9__8S20287C1[] = {
  0,
  ABISELECT(11944,8324),
  (VTBL_ENTRY)&(_ZTI8S20287C9[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN9S20287C10D1Ev();
extern void _ZN9S20287C10D0Ev();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__8S20287C1[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C69S20287C10__A2__8S20287C1[] = {
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C69S20287C10__A2__8S20287C1[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__9S20287C10__8S20287C1[] = {
  0,
  ABISELECT(128,96),
  ABISELECT(128,96),
  (VTBL_ENTRY)&(_ZTI9S20287C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__8S20287C1[] = {
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A3__8S20287C1[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C8__A3__8S20287C1[] = {
  0,
  ABISELECT(2720,1844),
  ABISELECT(2720,1844),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C8__A1__8S20287C1[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C8__A1__8S20287C1[] = {
  0,
  ABISELECT(2272,1536),
  ABISELECT(2272,1536),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN9S20287C13D1Ev();
extern void _ZN9S20287C13D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
extern void _ZN9S20287C133v10Ev();
extern void _ZN9S20287C133v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C13__8S20287C1[] = {
  ABISELECT(1032,684),
  ABISELECT(-14624,-10108),
  ABISELECT(-496,-328),
  ABISELECT(-2640,-1768),
  ABISELECT(-2680,-1784),
  ABISELECT(-2768,-1864),
  ABISELECT(-2880,-1940),
  0,
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN9S20287C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20287C13D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v10Ev,
  (VTBL_ENTRY)&_ZN9S20287C133v11Ev,
};
extern void _ZN8S20287C8D1Ev();
extern void _ZN8S20287C8D0Ev();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C89S20287C13__A2__8S20287C1[] = {
  ABISELECT(-2768,-1864),
  ABISELECT(-2880,-1940),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C8D0Ev,
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C89S20287C13__A5__8S20287C1[] = {
  ABISELECT(-3216,-2172),
  ABISELECT(-3328,-2248),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A5__8S20287C1[] = {
  0,
  ABISELECT(3216,2172),
  ABISELECT(3216,2172),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev)();
extern void ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C6__8S20287C89S20287C13__A2__8S20287C1[] = {
  ABISELECT(-3216,-2172),
  ABISELECT(-3328,-2248),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D1Ev,_ZThn308_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N8S20287C8D0Ev,_ZThn308_N8S20287C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__8S20287C89S20287C13__A2__8S20287C1[] = {
  0,
  ABISELECT(2768,1864),
  ABISELECT(2768,1864),
  (VTBL_ENTRY)&(_ZTI8S20287C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__9S20287C13__8S20287C1[] = {
  ABISELECT(-3216,-2172),
  ABISELECT(-3328,-2248),
  ABISELECT(-448,-308),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D1Ev,_ZThn308_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn448_N9S20287C13D0Ev,_ZThn308_N9S20287C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__A1__9S20287C13__8S20287C1[] = {
  0,
  ABISELECT(2768,1864),
  ABISELECT(2768,1864),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D1Ev,_ZTv0_n12_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20287C13D0Ev,_ZTv0_n12_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C9__9S20287C13__8S20287C1[] = {
  ABISELECT(2680,1784),
  0,
  0,
  0,
  0,
  ABISELECT(-11944,-8324),
  ABISELECT(2184,1456),
  ABISELECT(40,16),
  ABISELECT(-88,-80),
  ABISELECT(-200,-156),
  ABISELECT(2680,1784),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D1Ev,_ZTv0_n48_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20287C13D0Ev,_ZTv0_n48_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void _ZN9S20287C102v8Ev();
static  VTBL_ENTRY _tg__ZTV9S20287C10__9S20287C13__8S20287C1[] = {
  ABISELECT(144,88),
  0,
  ABISELECT(2640,1768),
  0,
  0,
  0,
  0,
  ABISELECT(-128,-96),
  ABISELECT(-240,-172),
  ABISELECT(2640,1768),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN9S20287C102v8Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C29S20287C10__A1__9S20287C13__8S20287C1[] = {
  ABISELECT(2496,1680),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev)();
extern void _ZN8S20287C72v1Ev();
extern void _ZN8S20287C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C8__A1__9S20287C13__8S20287C1[] = {
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(448,308),
  ABISELECT(208,156),
  0,
  0,
  ABISELECT(496,328),
  ABISELECT(-2272,-1536),
  ABISELECT(-2384,-1612),
  ABISELECT(496,328),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D1Ev,_ZTv0_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20287C13D0Ev,_ZTv0_n20_N9S20287C13D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
  (VTBL_ENTRY)&_ZN8S20287C82v7Ev,
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C28S20287C8__A2__9S20287C13__8S20287C1[] = {
  ABISELECT(288,172),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev)();
extern void ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20287C68S20287C8__A2__9S20287C13__8S20287C1[] = {
  ABISELECT(-2720,-1844),
  ABISELECT(-2832,-1920),
  ABISELECT(48,20),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D1Ev,_ZTvn308_n20_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn448_n40_N9S20287C13D0Ev,_ZTvn308_n20_N9S20287C13D0Ev),
};
extern void _ZN8S20287C22v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C2__A3__9S20287C13__8S20287C1[] = {
  0,
  ABISELECT(14624,10108),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C22v6Ev,
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev)();
extern void ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20287C6__A4__9S20287C13__8S20287C1[] = {
  ABISELECT(-1032,-684),
  0,
  0,
  0,
  0,
  ABISELECT(-3800,-2548),
  ABISELECT(-3912,-2624),
  ABISELECT(-1032,-684),
  (VTBL_ENTRY)&(_ZTI9S20287C13[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev),
};
extern void _ZN8S20287C62v2Ev();
extern void _ZN8S20287C62v3Ev();
extern void _ZN8S20287C62v4Ev();
extern void _ZN8S20287C62v5Ev();
extern void _ZN8S20287C6D1Ev();
extern void _ZN8S20287C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C6__A6__8S20287C1[] = {
  ABISELECT(-3800,-2548),
  ABISELECT(-3912,-2624),
  0,
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&_ZN8S20287C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20287C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20287C6D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev)();
extern void _ZN8S20287C72v1Ev();
static  VTBL_ENTRY _tg__ZTV8S20287C7__8S20287C6__A6__8S20287C1[] = {
  0,
  ABISELECT(3800,2548),
  ABISELECT(3800,2548),
  (VTBL_ENTRY)&(_ZTI8S20287C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20287C72v1Ev,
};
static  VTT_ENTRY vtt_S20287C1[] = {
  {&(_ZTV8S20287C1[11]),  11,203},
  {&(_tg__ZTV9S20287C10__A__8S20287C1[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A7__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A7__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__A__8S20287C1[4]),  4,7},
  {&(_ZTV8S20287C1[24]),  24,203},
  {&(_ZTV8S20287C1[42]),  42,203},
  {&(_ZTV8S20287C1[74]),  74,203},
  {&(_ZTV8S20287C1[53]),  53,203},
  {&(_ZTV8S20287C1[59]),  59,203},
  {&(_ZTV8S20287C1[64]),  64,203},
  {&(_ZTV8S20287C1[89]),  89,203},
  {&(_ZTV8S20287C1[106]),  106,203},
  {&(_ZTV8S20287C1[115]),  115,203},
  {&(_ZTV8S20287C1[128]),  128,203},
  {&(_ZTV8S20287C1[134]),  134,203},
  {&(_ZTV8S20287C1[139]),  139,203},
  {&(_ZTV8S20287C1[164]),  164,203},
  {&(_ZTV8S20287C1[172]),  172,203},
  {&(_ZTV8S20287C1[177]),  177,203},
  {&(_ZTV8S20287C1[185]),  185,203},
  {&(_ZTV8S20287C1[197]),  197,203},
  {&(_tg__ZTV8S20287C4__8S20287C1[8]),  8,15},
  {&(_tg__ZTV8S20287C58S20287C4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C68S20287C58S20287C4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C58S20287C4__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C7__8S20287C58S20287C4__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C88S20287C4__8S20287C1[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C88S20287C4__A1__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C88S20287C4__A1__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C88S20287C4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C88S20287C4__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C7__8S20287C4__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A__8S20287C4__8S20287C1[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C9__8S20287C4__8S20287C1[12]),  12,18},
  {&(_tg__ZTV9S20287C10__8S20287C4__8S20287C1[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__8S20287C4__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__8S20287C4__8S20287C1[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__8S20287C4__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A3__8S20287C4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__8S20287C4__8S20287C1[3]),  3,4},
  {&(_tg__ZTV8S20287C9__8S20287C1[7]),  7,13},
  {&(_tg__ZTV8S20287C68S20287C9__A4__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C9__A4__8S20287C1[4]),  4,7},
  {&(_tg__ZTV9S20287C10__8S20287C9__8S20287C1[11]),  11,18},
  {&(_tg__ZTV8S20287C7__8S20287C9__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C29S20287C10__8S20287C9__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C8__8S20287C9__8S20287C1[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A1__8S20287C9__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A1__8S20287C9__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A2__8S20287C9__8S20287C1[3]),  3,4},
  {&(_tg__ZTV9S20287C10__8S20287C1[4]),  4,11},
  {&(_tg__ZTV8S20287C69S20287C10__A2__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C69S20287C10__A2__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C7__9S20287C10__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C8__A1__8S20287C1[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C8__A3__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C8__A3__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C8__A1__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C8__A1__8S20287C1[4]),  4,7},
  {&(_tg__ZTV9S20287C13__8S20287C1[9]),  9,15},
  {&(_tg__ZTV8S20287C89S20287C13__A2__8S20287C1[4]),  4,8},
  {&(_tg__ZTV8S20287C68S20287C89S20287C13__A5__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C68S20287C89S20287C13__A5__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C6__8S20287C89S20287C13__A2__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__8S20287C89S20287C13__A2__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C68S20287C8__9S20287C13__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__A1__9S20287C13__8S20287C1[4]),  4,7},
  {&(_tg__ZTV8S20287C9__9S20287C13__8S20287C1[12]),  12,18},
  {&(_tg__ZTV9S20287C10__9S20287C13__8S20287C1[11]),  11,18},
  {&(_tg__ZTV8S20287C29S20287C10__A1__9S20287C13__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C8__A1__9S20287C13__8S20287C1[12]),  12,16},
  {&(_tg__ZTV8S20287C28S20287C8__A2__9S20287C13__8S20287C1[2]),  2,3},
  {&(_tg__ZTV8S20287C68S20287C8__A2__9S20287C13__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C2__A3__9S20287C13__8S20287C1[3]),  3,4},
  {&(_tg__ZTV8S20287C6__A4__9S20287C13__8S20287C1[9]),  9,15},
  {&(_tg__ZTV8S20287C6__A6__8S20287C1[4]),  4,10},
  {&(_tg__ZTV8S20287C7__8S20287C6__A6__8S20287C1[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S20287C1[];
extern  VTBL_ENTRY _ZTV8S20287C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20287C1[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D0Ev,_ZTv0_n36_N9S20287C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D0Ev,_ZThn684_N9S20287C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S20287C13D1Ev,_ZTv0_n36_N9S20287C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1032_N9S20287C13D1Ev,_ZThn684_N9S20287C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D0Ev,_ZTv0_n20_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D0Ev,_ZThn1456_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C9D1Ev,_ZTv0_n20_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2184_N8S20287C9D1Ev,_ZThn1456_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D0Ev,_ZTv0_n36_N8S20287C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D0Ev,_ZThn16_N8S20287C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C9D1Ev,_ZTv0_n36_N8S20287C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S20287C9D1Ev,_ZThn16_N8S20287C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C4D0Ev,_ZTv0_n20_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13888_N8S20287C4D0Ev,_ZThn9628_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C4D1Ev,_ZTv0_n20_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13888_N8S20287C4D1Ev,_ZThn9628_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C4D0Ev,_ZTv0_n36_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11744_N8S20287C4D0Ev,_ZThn8188_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C4D1Ev,_ZTv0_n36_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11744_N8S20287C4D1Ev,_ZThn8188_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C4D0Ev,_ZTv0_n48_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11704_N8S20287C4D0Ev,_ZThn8172_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C4D1Ev,_ZTv0_n48_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11704_N8S20287C4D1Ev,_ZThn8172_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C4D0Ev,_ZTv0_n12_N8S20287C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C4D0Ev,_ZThn8092_N8S20287C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C4D1Ev,_ZTv0_n12_N8S20287C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C4D1Ev,_ZThn8092_N8S20287C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D0Ev,_ZTv0_n12_N8S20287C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10608_N8S20287C8D0Ev,_ZThn7240_N8S20287C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C8D1Ev,_ZTv0_n12_N8S20287C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10608_N8S20287C8D1Ev,_ZThn7240_N8S20287C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D0Ev,_ZTv0_n12_N8S20287C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C5D0Ev,_ZThn8092_N8S20287C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C5D1Ev,_ZTv0_n12_N8S20287C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C5D1Ev,_ZThn8092_N8S20287C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D0Ev,_ZTv0_n12_N9S20287C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N9S20287C10D0Ev,_ZThn10188_N9S20287C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20287C10D1Ev,_ZTv0_n12_N9S20287C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N9S20287C10D1Ev,_ZThn10188_N9S20287C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D0Ev,_ZTv0_n12_N8S20287C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10160_N8S20287C6D0Ev,_ZThn6932_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C6D0Ev,_ZThn8092_N8S20287C6D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N8S20287C6D0Ev,_ZThn10188_N8S20287C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C6D1Ev,_ZTv0_n12_N8S20287C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10160_N8S20287C6D1Ev,_ZThn6932_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn11616_N8S20287C6D1Ev,_ZThn8092_N8S20287C6D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N8S20287C6D1Ev,_ZThn10188_N8S20287C6D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S20287C1D0Ev,_ZTv0_n40_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17504_N8S20287C1D0Ev,_ZThn12052_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S20287C1D1Ev,_ZTv0_n40_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17504_N8S20287C1D1Ev,_ZThn12052_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C1D0Ev,_ZTv0_n20_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17008_N8S20287C1D0Ev,_ZThn11724_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20287C1D1Ev,_ZTv0_n20_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17008_N8S20287C1D1Ev,_ZThn11724_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C1D0Ev,_ZTv0_n36_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18536_N8S20287C1D0Ev,_ZThn12736_N8S20287C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14864_N8S20287C1D0Ev,_ZThn10284_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S20287C1D1Ev,_ZTv0_n36_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18536_N8S20287C1D1Ev,_ZThn12736_N8S20287C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14864_N8S20287C1D1Ev,_ZThn10284_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C1D0Ev,_ZTv0_n48_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14824_N8S20287C1D0Ev,_ZThn10268_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S20287C1D1Ev,_ZTv0_n48_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14824_N8S20287C1D1Ev,_ZThn10268_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C1D0Ev,_ZTv0_n12_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N8S20287C1D0Ev,_ZThn10188_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20287C1D1Ev,_ZTv0_n12_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14736_N8S20287C1D1Ev,_ZThn10188_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N8S20287C1D0Ev,_ZTv0_n52_N8S20287C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3120_N8S20287C1D0Ev,_ZThn2096_N8S20287C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N8S20287C1D1Ev,_ZTv0_n52_N8S20287C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3120_N8S20287C1D1Ev,_ZThn2096_N8S20287C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20287C1 = {  "S20287C1", // class name
  bases_S20287C1, 35,
  &(vtc_S20287C1[0]), // expected_vtbl_contents
  &(vtt_S20287C1[0]), // expected_vtt_contents
  ABISELECT(18560,12748), // object size
  NSPAIRA(_ZTI8S20287C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20287C1),203, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20287C1),79, //virtual table table var
  28, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20286C2  {
  __tsi64 s20286c2f0;
  long double s20286c2f1;
  ::S20287C3 s20286c2f2;
  int s20286c2f3;
  short s20286c2f4;
  void *s20286c2f5[9];
  long s20286c2f6;
  __tsi64 s20286c2f7;
  virtual void  v6(); // _ZN8S20286C22v6Ev
  ~S20286C2(); // tgen
  S20286C2(); // tgen
};
//SIG(-1 S20286C2) C1{ v1 FL FD FC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} Fi Fs Fp[9] Fl FL}


void  S20286C2 ::v6(){vfunc_called(this, "_ZN8S20286C22v6Ev");}
S20286C2 ::~S20286C2(){ note_dtor("S20286C2", this);} // tgen
S20286C2 ::S20286C2(){ note_ctor("S20286C2", this);} // tgen

static void Test_S20286C2()
{
  extern Class_Descriptor cd_S20286C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,40)];
    init_test(&cd_S20286C2, buf);
    S20286C2 *dp, &lv = *(dp=new (buf) S20286C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,156), "sizeof(S20286C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20286C2)");
    check_field_offset(lv, s20286c2f0, ABISELECT(8,4), "S20286C2.s20286c2f0");
    check_field_offset(lv, s20286c2f1, ABISELECT(16,12), "S20286C2.s20286c2f1");
    check_field_offset(lv, s20286c2f2, ABISELECT(32,24), "S20286C2.s20286c2f2");
    check_field_offset(lv, s20286c2f3, ABISELECT(144,100), "S20286C2.s20286c2f3");
    check_field_offset(lv, s20286c2f4, ABISELECT(148,104), "S20286C2.s20286c2f4");
    check_field_offset(lv, s20286c2f5, ABISELECT(152,108), "S20286C2.s20286c2f5");
    check_field_offset(lv, s20286c2f6, ABISELECT(224,144), "S20286C2.s20286c2f6");
    check_field_offset(lv, s20286c2f7, ABISELECT(232,148), "S20286C2.s20286c2f7");
    test_class_info(&lv, &cd_S20286C2);
    dp->~S20286C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20286C2(Test_S20286C2, "S20286C2", ABISELECT(240,156));

#else // __cplusplus

extern void _ZN8S20286C2C1Ev();
extern void _ZN8S20286C2D1Ev();
Name_Map name_map_S20286C2[] = {
  NSPAIR(_ZN8S20286C2C1Ev),
  NSPAIR(_ZN8S20286C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20286C2[];
extern void _ZN8S20286C22v6Ev();
static  VTBL_ENTRY vtc_S20286C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20286C2[0]),
  (VTBL_ENTRY)&_ZN8S20286C22v6Ev,
};
extern VTBL_ENTRY _ZTI8S20286C2[];
extern  VTBL_ENTRY _ZTV8S20286C2[];
Class_Descriptor cd_S20286C2 = {  "S20286C2", // class name
  0,0,//no base classes
  &(vtc_S20286C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,156), // object size
  NSPAIRA(_ZTI8S20286C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20286C2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20286C7  {
  __tsi64 s20286c7f0;
  int s20286c7f1:2;
  unsigned char s20286c7f2:1;
  char s20286c7f3;
  int s20286c7f4[7];
  __tsi64 s20286c7f5[2];
  int s20286c7f6[4];
  void *s20286c7f7;
  virtual  ~S20286C7(); // _ZN8S20286C7D1Ev
  virtual void  v1(); // _ZN8S20286C72v1Ev
  S20286C7(); // tgen
};
//SIG(-1 S20286C7) C1{ vd v1 FL Fi:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp}


 S20286C7 ::~S20286C7(){ note_dtor("S20286C7", this);}
void  S20286C7 ::v1(){vfunc_called(this, "_ZN8S20286C72v1Ev");}
S20286C7 ::S20286C7(){ note_ctor("S20286C7", this);} // tgen

static void Test_S20286C7()
{
  extern Class_Descriptor cd_S20286C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,21)];
    init_test(&cd_S20286C7, buf);
    S20286C7 *dp, &lv = *(dp=new (buf) S20286C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,80), "sizeof(S20286C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20286C7)");
    check_field_offset(lv, s20286c7f0, ABISELECT(8,4), "S20286C7.s20286c7f0");
    set_bf_and_test(lv, s20286c7f1, ABISELECT(16,12), 0, 2, 1, "S20286C7");
    set_bf_and_test(lv, s20286c7f1, ABISELECT(16,12), 0, 2, hide_sll(1LL<<1), "S20286C7");
    set_bf_and_test(lv, s20286c7f2, ABISELECT(16,12), 2, 1, 1, "S20286C7");
    check_field_offset(lv, s20286c7f3, ABISELECT(17,13), "S20286C7.s20286c7f3");
    check_field_offset(lv, s20286c7f4, ABISELECT(20,16), "S20286C7.s20286c7f4");
    check_field_offset(lv, s20286c7f5, ABISELECT(48,44), "S20286C7.s20286c7f5");
    check_field_offset(lv, s20286c7f6, ABISELECT(64,60), "S20286C7.s20286c7f6");
    check_field_offset(lv, s20286c7f7, ABISELECT(80,76), "S20286C7.s20286c7f7");
    test_class_info(&lv, &cd_S20286C7);
    dp->~S20286C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20286C7(Test_S20286C7, "S20286C7", ABISELECT(88,80));

#else // __cplusplus

extern void _ZN8S20286C7C1Ev();
extern void _ZN8S20286C7D1Ev();
Name_Map name_map_S20286C7[] = {
  NSPAIR(_ZN8S20286C7C1Ev),
  NSPAIR(_ZN8S20286C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20286C7[];
extern void _ZN8S20286C7D1Ev();
extern void _ZN8S20286C7D0Ev();
extern void _ZN8S20286C72v1Ev();
static  VTBL_ENTRY vtc_S20286C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20286C7[0]),
  (VTBL_ENTRY)&_ZN8S20286C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20286C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20286C72v1Ev,
};
extern VTBL_ENTRY _ZTI8S20286C7[];
extern  VTBL_ENTRY _ZTV8S20286C7[];
Class_Descriptor cd_S20286C7 = {  "S20286C7", // class name
  0,0,//no base classes
  &(vtc_S20286C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,80), // object size
  NSPAIRA(_ZTI8S20286C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20286C7),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20286C6  : virtual S20287C3 , virtual S20286C7 {
  int s20286c6f0;
  void *s20286c6f1;
  virtual void  v2(); // _ZN8S20286C62v2Ev
  virtual void  v3(); // _ZN8S20286C62v3Ev
  virtual void  v4(); // _ZN8S20286C62v4Ev
  virtual void  v5(); // _ZN8S20286C62v5Ev
  ~S20286C6(); // tgen
  S20286C6(); // tgen
};
//SIG(-1 S20286C6) C1{ VBC2{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC3{ vd v5 FL Fi:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v1 v2 v3 v4 Fi Fp}


void  S20286C6 ::v2(){vfunc_called(this, "_ZN8S20286C62v2Ev");}
void  S20286C6 ::v3(){vfunc_called(this, "_ZN8S20286C62v3Ev");}
void  S20286C6 ::v4(){vfunc_called(this, "_ZN8S20286C62v4Ev");}
void  S20286C6 ::v5(){vfunc_called(this, "_ZN8S20286C62v5Ev");}
S20286C6 ::~S20286C6(){ note_dtor("S20286C6", this);} // tgen
S20286C6 ::S20286C6(){ note_ctor("S20286C6", this);} // tgen

static void Test_S20286C6()
{
  extern Class_Descriptor cd_S20286C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,43)];
    init_test(&cd_S20286C6, buf);
    S20286C6 *dp, &lv = *(dp=new (buf) S20286C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,168), "sizeof(S20286C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20286C6)");
    check_base_class_offset(lv, (S20287C3*), ABISELECT(32,12), "S20286C6");
    check_base_class_offset(lv, (S20286C7*), ABISELECT(144,88), "S20286C6");
    check_field_offset(lv, s20286c6f0, ABISELECT(8,4), "S20286C6.s20286c6f0");
    check_field_offset(lv, s20286c6f1, ABISELECT(16,8), "S20286C6.s20286c6f1");
    test_class_info(&lv, &cd_S20286C6);
    dp->~S20286C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20286C6(Test_S20286C6, "S20286C6", ABISELECT(240,168));

#else // __cplusplus

extern void _ZN8S20286C6C1Ev();
extern void _ZN8S20286C6D1Ev();
Name_Map name_map_S20286C6[] = {
  NSPAIR(_ZN8S20286C6C1Ev),
  NSPAIR(_ZN8S20286C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20286C7;
extern VTBL_ENTRY _ZTI8S20286C7[];
extern  VTBL_ENTRY _ZTV8S20286C7[];
static Base_Class bases_S20286C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20286C7,    ABISELECT(144,88), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20286C6[];
extern void _ZN8S20286C62v2Ev();
extern void _ZN8S20286C62v3Ev();
extern void _ZN8S20286C62v4Ev();
extern void _ZN8S20286C62v5Ev();
extern void _ZN8S20286C6D1Ev();
extern void _ZN8S20286C6D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20286C6D1Ev,_ZTv0_n12_N8S20286C6D1Ev)();
extern void ABISELECT(_ZThn144_N8S20286C6D1Ev,_ZThn88_N8S20286C6D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20286C6D0Ev,_ZTv0_n12_N8S20286C6D0Ev)();
extern void ABISELECT(_ZThn144_N8S20286C6D0Ev,_ZThn88_N8S20286C6D0Ev)() __attribute__((weak));
extern void _ZN8S20286C72v1Ev();
static  VTBL_ENTRY vtc_S20286C6[] = {
  ABISELECT(144,88),
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20286C6[0]),
  (VTBL_ENTRY)&_ZN8S20286C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20286C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20286C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20286C62v5Ev,
  (VTBL_ENTRY)&_ZN8S20286C6D1Ev,
  (VTBL_ENTRY)&_ZN8S20286C6D0Ev,
  0,
  ABISELECT(-144,-88),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20286C6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20286C6D1Ev,_ZTv0_n12_N8S20286C6D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20286C6D0Ev,_ZTv0_n12_N8S20286C6D0Ev),
  (VTBL_ENTRY)&_ZN8S20286C72v1Ev,
};
extern VTBL_ENTRY _ZTV8S20286C6[];
static  VTT_ENTRY vtt_S20286C6[] = {
  {&(_ZTV8S20286C6[4]),  4,17},
  {&(_ZTV8S20286C6[14]),  14,17},
};
extern VTBL_ENTRY _ZTI8S20286C6[];
extern  VTBL_ENTRY _ZTV8S20286C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20286C6[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20286C6D0Ev,_ZTv0_n12_N8S20286C6D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S20286C6D0Ev,_ZThn88_N8S20286C6D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20286C6D1Ev,_ZTv0_n12_N8S20286C6D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N8S20286C6D1Ev,_ZThn88_N8S20286C6D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20286C6 = {  "S20286C6", // class name
  bases_S20286C6, 2,
  &(vtc_S20286C6[0]), // expected_vtbl_contents
  &(vtt_S20286C6[0]), // expected_vtt_contents
  ABISELECT(240,168), // object size
  NSPAIRA(_ZTI8S20286C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20286C6),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20286C6),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20286C5  : S20286C6 {
  int s20286c5f0;
  __tsi64 s20286c5f1[2];
  ::S20286C7 s20286c5f2[9];
  void *s20286c5f3;
  int s20286c5f4;
  ::S20287C3 s20286c5f5;
  int s20286c5f6[3];
  void *s20286c5f7[2];
  virtual  ~S20286C5(); // _ZN8S20286C5D2Ev
  S20286C5(); // tgen
};
//SIG(-1 S20286C5) C1{ BC2{ VBC3{ m Fc:7 FD FL Fc FL Fc:8 Fp FL[4]} VBC4{ vd v1 FL Fi:2 Fc:1 Fc Fi[7] FL[2] Fi[4] Fp} v2 v3 v4 v5 Fi Fp} vd Fi FL[2] FC4[9] Fp Fi FC3 Fi[3] Fp[2]}


 S20286C5 ::~S20286C5(){ note_dtor("S20286C5", this);}
S20286C5 ::S20286C5(){ note_ctor("S20286C5", this);} // tgen

static void Test_S20286C5()
{
  extern Class_Descriptor cd_S20286C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(77,254)];
    init_test(&cd_S20286C5, buf);
    S20286C5 *dp, &lv = *(dp=new (buf) S20286C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1216,1012), "sizeof(S20286C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20286C5)");
    check_base_class_offset(lv, (S20287C3*)(S20286C6*), ABISELECT(1008,856), "S20286C5");
    check_base_class_offset(lv, (S20286C7*)(S20286C6*), ABISELECT(1120,932), "S20286C5");
    check_base_class_offset(lv, (S20286C6*), 0, "S20286C5");
    check_field_offset(lv, s20286c5f0, ABISELECT(24,12), "S20286C5.s20286c5f0");
    check_field_offset(lv, s20286c5f1, ABISELECT(32,16), "S20286C5.s20286c5f1");
    check_field_offset(lv, s20286c5f2, ABISELECT(48,32), "S20286C5.s20286c5f2");
    check_field_offset(lv, s20286c5f3, ABISELECT(840,752), "S20286C5.s20286c5f3");
    check_field_offset(lv, s20286c5f4, ABISELECT(848,756), "S20286C5.s20286c5f4");
    check_field_offset(lv, s20286c5f5, ABISELECT(864,760), "S20286C5.s20286c5f5");
    check_field_offset(lv, s20286c5f6, ABISELECT(976,836), "S20286C5.s20286c5f6");
    check_field_offset(lv, s20286c5f7, ABISELECT(992,848), "S20286C5.s20286c5f7");
    test_class_info(&lv, &cd_S20286C5);
    dp->~S20286C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20286C5(Test_S20286C5, "S20286C5", ABISELECT(1216,1012));

#else // __cplusplus

extern void _ZN8S20286C5C1Ev();
extern void _ZN8S20286C5D2Ev();
Name_Map name_map_S20286C5[] = {
  NSPAIR(_ZN8S20286C5C1Ev),
  NSPAIR(_ZN8S20286C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20287C3;
extern VTBL_ENTRY _ZTI8S20287C3[];
extern Class_Descriptor cd_S20286C7;
extern VTBL_ENTRY _ZTI8S20286C7[];
extern  VTBL_ENTRY _ZTV8S20286C7[];
extern Class_Descriptor cd_S20286C6;
extern VTBL_ENTRY _ZTI8S20286C6[];
extern  VTBL_ENTRY _ZTV8S20286C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20286C6[];
static Base_Class bases_S20286C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20287C3,    ABISELECT(1008,856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20286C7,    ABISELECT(1120,932), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20286C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20286C5[];
extern void _ZN8S20286C62v2Ev();
extern void _ZN8S20286C62v3Ev();
extern void _ZN8S20286C62v4Ev();
extern void _ZN8S20286C62v5Ev();
extern void _ZN8S20286C5D1Ev();
extern void _ZN8S20286C5D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20286C5D1Ev,_ZTv0_n12_N8S20286C5D1Ev)();
extern void ABISELECT(_ZThn1120_N8S20286C5D1Ev,_ZThn932_N8S20286C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20286C5D0Ev,_ZTv0_n12_N8S20286C5D0Ev)();
extern void ABISELECT(_ZThn1120_N8S20286C5D0Ev,_ZThn932_N8S20286C5D0Ev)() __attribute__((weak));
extern void _ZN8S20286C72v1Ev();
static  VTBL_ENTRY vtc_S20286C5[] = {
  ABISELECT(1120,9