// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S95C8_nt  {
  int s95c8f0[2];
  void  mf95c8(); // _ZN8S95C8_nt6mf95c8Ev
};
//SIG(-1 S95C8_nt) C1{ m Fi[2]}


void  S95C8_nt ::mf95c8(){}

//skip512 S95C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C7_nt  {
  int s95c7f0;
  __tsi64 s95c7f1;
  void *s95c7f2[4];
  int s95c7f3[2];
  void *s95c7f4;
  ::S95C8_nt s95c7f5;
  void *s95c7f6[2];
  virtual  ~S95C7_nt(); // _ZN8S95C7_ntD1Ev
  virtual void  v5(); // _ZN8S95C7_nt2v5Ev
  virtual void  v6(); // _ZN8S95C7_nt2v6Ev
  virtual void  v7(); // _ZN8S95C7_nt2v7Ev
  virtual void  v8(); // _ZN8S95C7_nt2v8Ev
  virtual void  v9(); // _ZN8S95C7_nt2v9Ev
  virtual void  v10(); // _ZN8S95C7_nt3v10Ev
  virtual void  v11(); // _ZN8S95C7_nt3v11Ev
  virtual void  v12(); // _ZN8S95C7_nt3v12Ev
  virtual void  v13(); // _ZN8S95C7_nt3v13Ev
  virtual void  v14(); // _ZN8S95C7_nt3v14Ev
  virtual void  v15(); // _ZN8S95C7_nt3v15Ev
  virtual void  v16(); // _ZN8S95C7_nt3v16Ev
  virtual void  v17(); // _ZN8S95C7_nt3v17Ev
  virtual void  v18(); // _ZN8S95C7_nt3v18Ev
  virtual void  v19(); // _ZN8S95C7_nt3v19Ev
  virtual void  v20(); // _ZN8S95C7_nt3v20Ev
  virtual void  v21(); // _ZN8S95C7_nt3v21Ev
  virtual void  v22(); // _ZN8S95C7_nt3v22Ev
  virtual void  v23(); // _ZN8S95C7_nt3v23Ev
  virtual void  v24(); // _ZN8S95C7_nt3v24Ev
  virtual void  v25(); // _ZN8S95C7_nt3v25Ev
  virtual void  v26(); // _ZN8S95C7_nt3v26Ev
  virtual void  v27(); // _ZN8S95C7_nt3v27Ev
  virtual void  v28(); // _ZN8S95C7_nt3v28Ev
  virtual void  v29(); // _ZN8S95C7_nt3v29Ev
  virtual void  v30(); // _ZN8S95C7_nt3v30Ev
  virtual void  v31(); // _ZN8S95C7_nt3v31Ev
  virtual void  v32(); // _ZN8S95C7_nt3v32Ev
  virtual void  v33(); // _ZN8S95C7_nt3v33Ev
  virtual void  v34(); // _ZN8S95C7_nt3v34Ev
  virtual void  v35(); // _ZN8S95C7_nt3v35Ev
  virtual void  v36(); // _ZN8S95C7_nt3v36Ev
  virtual void  v37(); // _ZN8S95C7_nt3v37Ev
  virtual void  v38(); // _ZN8S95C7_nt3v38Ev
  virtual void  v39(); // _ZN8S95C7_nt3v39Ev
  virtual void  v40(); // _ZN8S95C7_nt3v40Ev
  virtual void  v41(); // _ZN8S95C7_nt3v41Ev
  virtual void  v42(); // _ZN8S95C7_nt3v42Ev
  virtual void  v43(); // _ZN8S95C7_nt3v43Ev
  virtual void  v44(); // _ZN8S95C7_nt3v44Ev
  virtual void  v45(); // _ZN8S95C7_nt3v45Ev
  virtual void  v46(); // _ZN8S95C7_nt3v46Ev
  virtual void  v47(); // _ZN8S95C7_nt3v47Ev
  virtual void  v48(); // _ZN8S95C7_nt3v48Ev
  virtual void  v49(); // _ZN8S95C7_nt3v49Ev
  virtual void  v50(); // _ZN8S95C7_nt3v50Ev
  virtual void  v51(); // _ZN8S95C7_nt3v51Ev
  virtual void  v52(); // _ZN8S95C7_nt3v52Ev
  virtual void  v53(); // _ZN8S95C7_nt3v53Ev
  virtual void  v54(); // _ZN8S95C7_nt3v54Ev
  virtual void  v55(); // _ZN8S95C7_nt3v55Ev
  virtual void  v56(); // _ZN8S95C7_nt3v56Ev
  virtual void  v57(); // _ZN8S95C7_nt3v57Ev
  virtual void  v58(); // _ZN8S95C7_nt3v58Ev
  virtual void  v59(); // _ZN8S95C7_nt3v59Ev
  virtual void  v60(); // _ZN8S95C7_nt3v60Ev
  virtual void  v61(); // _ZN8S95C7_nt3v61Ev
  virtual void  v62(); // _ZN8S95C7_nt3v62Ev
  virtual void  v63(); // _ZN8S95C7_nt3v63Ev
  virtual void  v64(); // _ZN8S95C7_nt3v64Ev
  virtual void  v65(); // _ZN8S95C7_nt3v65Ev
  virtual void  v66(); // _ZN8S95C7_nt3v66Ev
  virtual void  v67(); // _ZN8S95C7_nt3v67Ev
  virtual void  v68(); // _ZN8S95C7_nt3v68Ev
  S95C7_nt(); // tgen
};
//SIG(-1 S95C7_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S95C7_nt ::~S95C7_nt(){ note_dtor("S95C7_nt", this);}
void  S95C7_nt ::v5(){vfunc_called(this, "_ZN8S95C7_nt2v5Ev");}
void  S95C7_nt ::v6(){vfunc_called(this, "_ZN8S95C7_nt2v6Ev");}
void  S95C7_nt ::v7(){vfunc_called(this, "_ZN8S95C7_nt2v7Ev");}
void  S95C7_nt ::v8(){vfunc_called(this, "_ZN8S95C7_nt2v8Ev");}
void  S95C7_nt ::v9(){vfunc_called(this, "_ZN8S95C7_nt2v9Ev");}
void  S95C7_nt ::v10(){vfunc_called(this, "_ZN8S95C7_nt3v10Ev");}
void  S95C7_nt ::v11(){vfunc_called(this, "_ZN8S95C7_nt3v11Ev");}
void  S95C7_nt ::v12(){vfunc_called(this, "_ZN8S95C7_nt3v12Ev");}
void  S95C7_nt ::v13(){vfunc_called(this, "_ZN8S95C7_nt3v13Ev");}
void  S95C7_nt ::v14(){vfunc_called(this, "_ZN8S95C7_nt3v14Ev");}
void  S95C7_nt ::v15(){vfunc_called(this, "_ZN8S95C7_nt3v15Ev");}
void  S95C7_nt ::v16(){vfunc_called(this, "_ZN8S95C7_nt3v16Ev");}
void  S95C7_nt ::v17(){vfunc_called(this, "_ZN8S95C7_nt3v17Ev");}
void  S95C7_nt ::v18(){vfunc_called(this, "_ZN8S95C7_nt3v18Ev");}
void  S95C7_nt ::v19(){vfunc_called(this, "_ZN8S95C7_nt3v19Ev");}
void  S95C7_nt ::v20(){vfunc_called(this, "_ZN8S95C7_nt3v20Ev");}
void  S95C7_nt ::v21(){vfunc_called(this, "_ZN8S95C7_nt3v21Ev");}
void  S95C7_nt ::v22(){vfunc_called(this, "_ZN8S95C7_nt3v22Ev");}
void  S95C7_nt ::v23(){vfunc_called(this, "_ZN8S95C7_nt3v23Ev");}
void  S95C7_nt ::v24(){vfunc_called(this, "_ZN8S95C7_nt3v24Ev");}
void  S95C7_nt ::v25(){vfunc_called(this, "_ZN8S95C7_nt3v25Ev");}
void  S95C7_nt ::v26(){vfunc_called(this, "_ZN8S95C7_nt3v26Ev");}
void  S95C7_nt ::v27(){vfunc_called(this, "_ZN8S95C7_nt3v27Ev");}
void  S95C7_nt ::v28(){vfunc_called(this, "_ZN8S95C7_nt3v28Ev");}
void  S95C7_nt ::v29(){vfunc_called(this, "_ZN8S95C7_nt3v29Ev");}
void  S95C7_nt ::v30(){vfunc_called(this, "_ZN8S95C7_nt3v30Ev");}
void  S95C7_nt ::v31(){vfunc_called(this, "_ZN8S95C7_nt3v31Ev");}
void  S95C7_nt ::v32(){vfunc_called(this, "_ZN8S95C7_nt3v32Ev");}
void  S95C7_nt ::v33(){vfunc_called(this, "_ZN8S95C7_nt3v33Ev");}
void  S95C7_nt ::v34(){vfunc_called(this, "_ZN8S95C7_nt3v34Ev");}
void  S95C7_nt ::v35(){vfunc_called(this, "_ZN8S95C7_nt3v35Ev");}
void  S95C7_nt ::v36(){vfunc_called(this, "_ZN8S95C7_nt3v36Ev");}
void  S95C7_nt ::v37(){vfunc_called(this, "_ZN8S95C7_nt3v37Ev");}
void  S95C7_nt ::v38(){vfunc_called(this, "_ZN8S95C7_nt3v38Ev");}
void  S95C7_nt ::v39(){vfunc_called(this, "_ZN8S95C7_nt3v39Ev");}
void  S95C7_nt ::v40(){vfunc_called(this, "_ZN8S95C7_nt3v40Ev");}
void  S95C7_nt ::v41(){vfunc_called(this, "_ZN8S95C7_nt3v41Ev");}
void  S95C7_nt ::v42(){vfunc_called(this, "_ZN8S95C7_nt3v42Ev");}
void  S95C7_nt ::v43(){vfunc_called(this, "_ZN8S95C7_nt3v43Ev");}
void  S95C7_nt ::v44(){vfunc_called(this, "_ZN8S95C7_nt3v44Ev");}
void  S95C7_nt ::v45(){vfunc_called(this, "_ZN8S95C7_nt3v45Ev");}
void  S95C7_nt ::v46(){vfunc_called(this, "_ZN8S95C7_nt3v46Ev");}
void  S95C7_nt ::v47(){vfunc_called(this, "_ZN8S95C7_nt3v47Ev");}
void  S95C7_nt ::v48(){vfunc_called(this, "_ZN8S95C7_nt3v48Ev");}
void  S95C7_nt ::v49(){vfunc_called(this, "_ZN8S95C7_nt3v49Ev");}
void  S95C7_nt ::v50(){vfunc_called(this, "_ZN8S95C7_nt3v50Ev");}
void  S95C7_nt ::v51(){vfunc_called(this, "_ZN8S95C7_nt3v51Ev");}
void  S95C7_nt ::v52(){vfunc_called(this, "_ZN8S95C7_nt3v52Ev");}
void  S95C7_nt ::v53(){vfunc_called(this, "_ZN8S95C7_nt3v53Ev");}
void  S95C7_nt ::v54(){vfunc_called(this, "_ZN8S95C7_nt3v54Ev");}
void  S95C7_nt ::v55(){vfunc_called(this, "_ZN8S95C7_nt3v55Ev");}
void  S95C7_nt ::v56(){vfunc_called(this, "_ZN8S95C7_nt3v56Ev");}
void  S95C7_nt ::v57(){vfunc_called(this, "_ZN8S95C7_nt3v57Ev");}
void  S95C7_nt ::v58(){vfunc_called(this, "_ZN8S95C7_nt3v58Ev");}
void  S95C7_nt ::v59(){vfunc_called(this, "_ZN8S95C7_nt3v59Ev");}
void  S95C7_nt ::v60(){vfunc_called(this, "_ZN8S95C7_nt3v60Ev");}
void  S95C7_nt ::v61(){vfunc_called(this, "_ZN8S95C7_nt3v61Ev");}
void  S95C7_nt ::v62(){vfunc_called(this, "_ZN8S95C7_nt3v62Ev");}
void  S95C7_nt ::v63(){vfunc_called(this, "_ZN8S95C7_nt3v63Ev");}
void  S95C7_nt ::v64(){vfunc_called(this, "_ZN8S95C7_nt3v64Ev");}
void  S95C7_nt ::v65(){vfunc_called(this, "_ZN8S95C7_nt3v65Ev");}
void  S95C7_nt ::v66(){vfunc_called(this, "_ZN8S95C7_nt3v66Ev");}
void  S95C7_nt ::v67(){vfunc_called(this, "_ZN8S95C7_nt3v67Ev");}
void  S95C7_nt ::v68(){vfunc_called(this, "_ZN8S95C7_nt3v68Ev");}
S95C7_nt ::S95C7_nt(){ note_ctor("S95C7_nt", this);} // tgen

//skip512 S95C7_nt

#else // __cplusplus

extern void _ZN8S95C7_ntC1Ev();
extern void _ZN8S95C7_ntD1Ev();
Name_Map name_map_S95C7_nt[] = {
  NSPAIR(_ZN8S95C7_ntC1Ev),
  NSPAIR(_ZN8S95C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern void _ZN8S95C7_ntD1Ev();
extern void _ZN8S95C7_ntD0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
static  VTBL_ENTRY vtc_S95C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S95C7_nt[0]),
  (VTBL_ENTRY)&_ZN8S95C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S95C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
};
extern VTBL_ENTRY _ZTI8S95C7_nt[];
VTBL_ENTRY *P__ZTI8S95C7_nt = _ZTI8S95C7_nt; 
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
Class_Descriptor cd_S95C7_nt = {  "S95C7_nt", // class name
  0,0,//no base classes
  &(vtc_S95C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI8S95C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S95C7_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C6  : S95C7_nt {
  void *s95c6f0;
  ::S95C8_nt s95c6f1;
  virtual  ~S95C6(); // _ZN5S95C6D1Ev
  virtual void  v69(); // _ZN5S95C63v69Ev
  virtual void  v70(); // _ZN5S95C63v70Ev
  virtual void  v71(); // _ZN5S95C63v71Ev
  virtual void  v72(); // _ZN5S95C63v72Ev
  virtual void  v73(); // _ZN5S95C63v73Ev
  S95C6(); // tgen
};
//SIG(-1 S95C6) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S95C6 ::~S95C6(){ note_dtor("S95C6", this);}
void  S95C6 ::v69(){vfunc_called(this, "_ZN5S95C63v69Ev");}
void  S95C6 ::v70(){vfunc_called(this, "_ZN5S95C63v70Ev");}
void  S95C6 ::v71(){vfunc_called(this, "_ZN5S95C63v71Ev");}
void  S95C6 ::v72(){vfunc_called(this, "_ZN5S95C63v72Ev");}
void  S95C6 ::v73(){vfunc_called(this, "_ZN5S95C63v73Ev");}
S95C6 ::S95C6(){ note_ctor("S95C6", this);} // tgen

static void Test_S95C6()
{
  extern Class_Descriptor cd_S95C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S95C6, buf);
    S95C6 *dp, &lv = *(dp=new (buf) S95C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S95C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C6)");
    check_base_class_offset(lv, (S95C7_nt*), 0, "S95C6");
    check_field_offset(lv, s95c6f0, ABISELECT(96,60), "S95C6.s95c6f0");
    check_field_offset(lv, s95c6f1, ABISELECT(104,64), "S95C6.s95c6f1");
    test_class_info(&lv, &cd_S95C6);
    dp->~S95C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C6(Test_S95C6, "S95C6", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN5S95C6C1Ev();
extern void _ZN5S95C6D1Ev();
Name_Map name_map_S95C6[] = {
  NSPAIR(_ZN5S95C6C1Ev),
  NSPAIR(_ZN5S95C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
static Base_Class bases_S95C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C6[];
extern void _ZN5S95C6D1Ev();
extern void _ZN5S95C6D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
static  VTBL_ENTRY vtc_S95C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C6[0]),
  (VTBL_ENTRY)&_ZN5S95C6D1Ev,
  (VTBL_ENTRY)&_ZN5S95C6D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
};
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
Class_Descriptor cd_S95C6 = {  "S95C6", // class name
  bases_S95C6, 1,
  &(vtc_S95C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI5S95C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C6),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C5  : S95C6 {
  void *s95c5f0[2];
  unsigned int s95c5f1:1;
  unsigned int s95c5f2:1;
  unsigned int s95c5f3:1;
  unsigned int s95c5f4:1;
  char s95c5f5;
  virtual  ~S95C5(); // _ZN5S95C5D1Ev
  virtual void  v74(); // _ZN5S95C53v74Ev
  virtual void  v75(); // _ZN5S95C53v75Ev
  virtual void  v76(); // _ZN5S95C53v76Ev
  virtual void  v77(); // _ZN5S95C53v77Ev
  virtual void  v78(); // _ZN5S95C53v78Ev
  virtual void  v79(); // _ZN5S95C53v79Ev
  virtual void  v80(); // _ZN5S95C53v80Ev
  virtual void  v81(); // _ZN5S95C53v81Ev
  virtual void  v82(); // _ZN5S95C53v82Ev
  virtual void  v83(); // _ZN5S95C53v83Ev
  virtual void  v84(); // _ZN5S95C53v84Ev
  virtual void  v85(); // _ZN5S95C53v85Ev
  virtual void  v86(); // _ZN5S95C53v86Ev
  virtual void  v87(); // _ZN5S95C53v87Ev
  virtual void  v88(); // _ZN5S95C53v88Ev
  virtual void  v89(); // _ZN5S95C53v89Ev
  virtual void  v90(); // _ZN5S95C53v90Ev
  virtual void  v91(); // _ZN5S95C53v91Ev
  virtual void  v92(); // _ZN5S95C53v92Ev
  virtual void  v93(); // _ZN5S95C53v93Ev
  virtual void  v94(); // _ZN5S95C53v94Ev
  virtual void  v95(); // _ZN5S95C53v95Ev
  S95C5(); // tgen
};
//SIG(-1 S95C5) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S95C5 ::~S95C5(){ note_dtor("S95C5", this);}
void  S95C5 ::v74(){vfunc_called(this, "_ZN5S95C53v74Ev");}
void  S95C5 ::v75(){vfunc_called(this, "_ZN5S95C53v75Ev");}
void  S95C5 ::v76(){vfunc_called(this, "_ZN5S95C53v76Ev");}
void  S95C5 ::v77(){vfunc_called(this, "_ZN5S95C53v77Ev");}
void  S95C5 ::v78(){vfunc_called(this, "_ZN5S95C53v78Ev");}
void  S95C5 ::v79(){vfunc_called(this, "_ZN5S95C53v79Ev");}
void  S95C5 ::v80(){vfunc_called(this, "_ZN5S95C53v80Ev");}
void  S95C5 ::v81(){vfunc_called(this, "_ZN5S95C53v81Ev");}
void  S95C5 ::v82(){vfunc_called(this, "_ZN5S95C53v82Ev");}
void  S95C5 ::v83(){vfunc_called(this, "_ZN5S95C53v83Ev");}
void  S95C5 ::v84(){vfunc_called(this, "_ZN5S95C53v84Ev");}
void  S95C5 ::v85(){vfunc_called(this, "_ZN5S95C53v85Ev");}
void  S95C5 ::v86(){vfunc_called(this, "_ZN5S95C53v86Ev");}
void  S95C5 ::v87(){vfunc_called(this, "_ZN5S95C53v87Ev");}
void  S95C5 ::v88(){vfunc_called(this, "_ZN5S95C53v88Ev");}
void  S95C5 ::v89(){vfunc_called(this, "_ZN5S95C53v89Ev");}
void  S95C5 ::v90(){vfunc_called(this, "_ZN5S95C53v90Ev");}
void  S95C5 ::v91(){vfunc_called(this, "_ZN5S95C53v91Ev");}
void  S95C5 ::v92(){vfunc_called(this, "_ZN5S95C53v92Ev");}
void  S95C5 ::v93(){vfunc_called(this, "_ZN5S95C53v93Ev");}
void  S95C5 ::v94(){vfunc_called(this, "_ZN5S95C53v94Ev");}
void  S95C5 ::v95(){vfunc_called(this, "_ZN5S95C53v95Ev");}
S95C5 ::S95C5(){ note_ctor("S95C5", this);} // tgen

static void Test_S95C5()
{
  extern Class_Descriptor cd_S95C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S95C5, buf);
    S95C5 *dp, &lv = *(dp=new (buf) S95C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S95C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C5)");
    check_base_class_offset(lv, (S95C7_nt*)(S95C6*), 0, "S95C5");
    check_base_class_offset(lv, (S95C6*), 0, "S95C5");
    check_field_offset(lv, s95c5f0, ABISELECT(112,72), "S95C5.s95c5f0");
    set_bf_and_test(lv, s95c5f1, ABISELECT(128,80), 0, 1, 1, "S95C5");
    set_bf_and_test(lv, s95c5f2, ABISELECT(128,80), 1, 1, 1, "S95C5");
    set_bf_and_test(lv, s95c5f3, ABISELECT(128,80), 2, 1, 1, "S95C5");
    set_bf_and_test(lv, s95c5f4, ABISELECT(128,80), 3, 1, 1, "S95C5");
    check_field_offset(lv, s95c5f5, ABISELECT(129,81), "S95C5.s95c5f5");
    test_class_info(&lv, &cd_S95C5);
    dp->~S95C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C5(Test_S95C5, "S95C5", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN5S95C5C1Ev();
extern void _ZN5S95C5D1Ev();
Name_Map name_map_S95C5[] = {
  NSPAIR(_ZN5S95C5C1Ev),
  NSPAIR(_ZN5S95C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
extern Class_Descriptor cd_S95C6;
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
static Base_Class bases_S95C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C5[];
extern void _ZN5S95C5D1Ev();
extern void _ZN5S95C5D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
extern void _ZN5S95C53v74Ev();
extern void _ZN5S95C53v75Ev();
extern void _ZN5S95C53v76Ev();
extern void _ZN5S95C53v77Ev();
extern void _ZN5S95C53v78Ev();
extern void _ZN5S95C53v79Ev();
extern void _ZN5S95C53v80Ev();
extern void _ZN5S95C53v81Ev();
extern void _ZN5S95C53v82Ev();
extern void _ZN5S95C53v83Ev();
extern void _ZN5S95C53v84Ev();
extern void _ZN5S95C53v85Ev();
extern void _ZN5S95C53v86Ev();
extern void _ZN5S95C53v87Ev();
extern void _ZN5S95C53v88Ev();
extern void _ZN5S95C53v89Ev();
extern void _ZN5S95C53v90Ev();
extern void _ZN5S95C53v91Ev();
extern void _ZN5S95C53v92Ev();
extern void _ZN5S95C53v93Ev();
extern void _ZN5S95C53v94Ev();
extern void _ZN5S95C53v95Ev();
static  VTBL_ENTRY vtc_S95C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C5[0]),
  (VTBL_ENTRY)&_ZN5S95C5D1Ev,
  (VTBL_ENTRY)&_ZN5S95C5D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
  (VTBL_ENTRY)&_ZN5S95C53v74Ev,
  (VTBL_ENTRY)&_ZN5S95C53v75Ev,
  (VTBL_ENTRY)&_ZN5S95C53v76Ev,
  (VTBL_ENTRY)&_ZN5S95C53v77Ev,
  (VTBL_ENTRY)&_ZN5S95C53v78Ev,
  (VTBL_ENTRY)&_ZN5S95C53v79Ev,
  (VTBL_ENTRY)&_ZN5S95C53v80Ev,
  (VTBL_ENTRY)&_ZN5S95C53v81Ev,
  (VTBL_ENTRY)&_ZN5S95C53v82Ev,
  (VTBL_ENTRY)&_ZN5S95C53v83Ev,
  (VTBL_ENTRY)&_ZN5S95C53v84Ev,
  (VTBL_ENTRY)&_ZN5S95C53v85Ev,
  (VTBL_ENTRY)&_ZN5S95C53v86Ev,
  (VTBL_ENTRY)&_ZN5S95C53v87Ev,
  (VTBL_ENTRY)&_ZN5S95C53v88Ev,
  (VTBL_ENTRY)&_ZN5S95C53v89Ev,
  (VTBL_ENTRY)&_ZN5S95C53v90Ev,
  (VTBL_ENTRY)&_ZN5S95C53v91Ev,
  (VTBL_ENTRY)&_ZN5S95C53v92Ev,
  (VTBL_ENTRY)&_ZN5S95C53v93Ev,
  (VTBL_ENTRY)&_ZN5S95C53v94Ev,
  (VTBL_ENTRY)&_ZN5S95C53v95Ev,
};
extern VTBL_ENTRY _ZTI5S95C5[];
extern  VTBL_ENTRY _ZTV5S95C5[];
Class_Descriptor cd_S95C5 = {  "S95C5", // class name
  bases_S95C5, 2,
  &(vtc_S95C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI5S95C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C5),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C9_nt  {
  int s95c9f0;
  void  mf95c9(); // _ZN8S95C9_nt6mf95c9Ev
};
//SIG(-1 S95C9_nt) C1{ m Fi}


void  S95C9_nt ::mf95c9(){}

//skip512 S95C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S95C9_nt[];
VTBL_ENTRY *P__ZTI8S95C9_nt = _ZTI8S95C9_nt; 
Class_Descriptor cd_S95C9_nt = {  "S95C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI8S95C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C10_nt  {
  void  mf95c10(); // _ZN9S95C10_nt7mf95c10Ev
};
//SIG(-1 S95C10_nt) C1{ m}


void  S95C10_nt ::mf95c10(){}

//skip512 S95C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C12_nt  {
  void *s95c12f0;
  int s95c12f1[2];
  void  mf95c12(); // _ZN9S95C12_nt7mf95c12Ev
};
//SIG(-1 S95C12_nt) C1{ m Fp Fi[2]}


void  S95C12_nt ::mf95c12(){}

//skip512 S95C12_nt

#else // __cplusplus

Class_Descriptor cd_S95C12_nt = {  "S95C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C11_nt  : S95C12_nt {
};
//SIG(-1 S95C11_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S95C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C14_nt  {
  int s95c14f0[3];
  void  mf95c14(); // _ZN9S95C14_nt7mf95c14Ev
};
//SIG(-1 S95C14_nt) C1{ m Fi[3]}


void  S95C14_nt ::mf95c14(){}

//skip512 S95C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C13  {
  ::S95C14_nt s95c13f0;
  ::S95C14_nt s95c13f1;
  int s95c13f2;
  void  mf95c13(); // _ZN6S95C137mf95c13Ev
};
//SIG(-1 S95C13) C1{ m FC2{ m Fi[3]} FC2 Fi}


void  S95C13 ::mf95c13(){}

static void Test_S95C13()
{
  {
    init_simple_test("S95C13");
    S95C13 lv;
    check2(sizeof(lv), 28, "sizeof(S95C13)");
    check2(__alignof__(lv), 4, "__alignof__(S95C13)");
    check_field_offset(lv, s95c13f0, 0, "S95C13.s95c13f0");
    check_field_offset(lv, s95c13f1, 12, "S95C13.s95c13f1");
    check_field_offset(lv, s95c13f2, 24, "S95C13.s95c13f2");
  }
}
static Arrange_To_Call_Me vS95C13(Test_S95C13, "S95C13", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C16  {
  void  mf95c16(); // _ZN6S95C167mf95c16Ev
};
//SIG(-1 S95C16) C1{ m}


void  S95C16 ::mf95c16(){}

static void Test_S95C16()
{
  {
    init_simple_test("S95C16");
    S95C16 lv;
    check2(sizeof(lv), 1, "sizeof(S95C16)");
    check2(__alignof__(lv), 1, "__alignof__(S95C16)");
  }
}
static Arrange_To_Call_Me vS95C16(Test_S95C16, "S95C16", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C18  : S95C12_nt {
};
//SIG(-1 S95C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C18()
{
  extern Class_Descriptor cd_S95C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C18, buf);
    S95C18 &lv = *(new (buf) S95C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C18)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C18");
    test_class_info(&lv, &cd_S95C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C18(Test_S95C18, "S95C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C18 = {  "S95C18", // class name
  bases_S95C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C17_nt  : S95C18 {
};
//SIG(-1 S95C17_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S95C17_nt

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S95C18;
static Base_Class bases_S95C17_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C4  : S95C5 {
  void *s95c4f0;
  ::S95C9_nt s95c4f1;
  int s95c4f2;
  ::S95C10_nt s95c4f3;
  int s95c4f4;
  ::S95C11_nt s95c4f5;
  int s95c4f6;
  void *s95c4f7[2];
  ::S95C13 s95c4f8;
  void *s95c4f9;
  int s95c4f10[2];
  char s95c4f11[3];
  int s95c4f12;
  unsigned int s95c4f13:1;
  unsigned int s95c4f14:1;
  unsigned int s95c4f15:1;
  unsigned int s95c4f16:1;
  unsigned int s95c4f17:1;
  unsigned int s95c4f18:1;
  unsigned int s95c4f19:1;
  unsigned int s95c4f20:1;
  unsigned int s95c4f21:1;
  unsigned int s95c4f22:1;
  unsigned int s95c4f23:1;
  unsigned int s95c4f24:1;
  unsigned int s95c4f25:1;
  unsigned int s95c4f26:1;
  int s95c4f27;
  unsigned int s95c4f28:1;
  unsigned int s95c4f29:1;
  unsigned int s95c4f30:1;
  unsigned int s95c4f31:1;
  unsigned int s95c4f32:1;
  unsigned int s95c4f33:1;
  ::S95C10_nt s95c4f34;
  unsigned int s95c4f35:1;
  unsigned int s95c4f36:1;
  unsigned int s95c4f37:1;
  unsigned int s95c4f38:1;
  unsigned int s95c4f39:1;
  unsigned int s95c4f40:1;
  unsigned int s95c4f41:1;
  char s95c4f42;
  ::S95C16 s95c4f43;
  unsigned int s95c4f44:1;
  unsigned int s95c4f45:1;
  unsigned int s95c4f46:1;
  unsigned int s95c4f47:1;
  unsigned int s95c4f48:1;
  unsigned int s95c4f49:1;
  unsigned int s95c4f50:1;
  unsigned int s95c4f51:1;
  unsigned int s95c4f52:1;
  unsigned int s95c4f53:1;
  unsigned int s95c4f54:1;
  unsigned int s95c4f55:1;
  ::S95C17_nt s95c4f56;
  void *s95c4f57[2];
  char s95c4f58;
  ::S95C10_nt s95c4f59;
  ::S95C14_nt s95c4f60;
  ::S95C14_nt s95c4f61;
  int s95c4f62;
  ::S95C14_nt s95c4f63;
  unsigned int s95c4f64:1;
  unsigned int s95c4f65:1;
  unsigned int s95c4f66:1;
  int s95c4f67[3];
  virtual  ~S95C4(); // _ZN5S95C4D1Ev
  virtual void  v96(); // _ZN5S95C43v96Ev
  virtual void  v97(); // _ZN5S95C43v97Ev
  virtual void  v98(); // _ZN5S95C43v98Ev
  virtual void  v99(); // _ZN5S95C43v99Ev
  virtual void  v100(); // _ZN5S95C44v100Ev
  virtual void  v101(); // _ZN5S95C44v101Ev
  virtual void  v102(); // _ZN5S95C44v102Ev
  virtual void  v103(); // _ZN5S95C44v103Ev
  virtual void  v104(); // _ZN5S95C44v104Ev
  virtual void  v105(); // _ZN5S95C44v105Ev
  virtual void  v106(); // _ZN5S95C44v106Ev
  virtual void  v107(); // _ZN5S95C44v107Ev
  virtual void  v108(); // _ZN5S95C44v108Ev
  virtual void  v109(); // _ZN5S95C44v109Ev
  virtual void  v110(); // _ZN5S95C44v110Ev
  virtual void  v111(); // _ZN5S95C44v111Ev
  virtual void  v112(); // _ZN5S95C44v112Ev
  virtual void  v113(); // _ZN5S95C44v113Ev
  virtual void  v114(); // _ZN5S95C44v114Ev
  virtual void  v115(); // _ZN5S95C44v115Ev
  virtual void  v116(); // _ZN5S95C44v116Ev
  virtual void  v117(); // _ZN5S95C44v117Ev
  virtual void  v118(); // _ZN5S95C44v118Ev
  virtual void  v119(); // _ZN5S95C44v119Ev
  virtual void  v120(); // _ZN5S95C44v120Ev
  virtual void  v121(); // _ZN5S95C44v121Ev
  virtual void  v122(); // _ZN5S95C44v122Ev
  virtual void  v123(); // _ZN5S95C44v123Ev
  virtual void  v124(); // _ZN5S95C44v124Ev
  virtual void  v125(); // _ZN5S95C44v125Ev
  virtual void  v126(); // _ZN5S95C44v126Ev
  virtual void  v127(); // _ZN5S95C44v127Ev
  virtual void  v128(); // _ZN5S95C44v128Ev
  virtual void  v129(); // _ZN5S95C44v129Ev
  virtual void  v130(); // _ZN5S95C44v130Ev
  virtual void  v131(); // _ZN5S95C44v131Ev
  virtual void  v132(); // _ZN5S95C44v132Ev
  virtual void  v133(); // _ZN5S95C44v133Ev
  virtual void  v134(); // _ZN5S95C44v134Ev
  virtual void  v135(); // _ZN5S95C44v135Ev
  virtual void  v136(); // _ZN5S95C44v136Ev
  virtual void  v137(); // _ZN5S95C44v137Ev
  virtual void  v138(); // _ZN5S95C44v138Ev
  virtual void  v139(); // _ZN5S95C44v139Ev
  virtual void  v140(); // _ZN5S95C44v140Ev
  virtual void  v141(); // _ZN5S95C44v141Ev
  virtual void  v142(); // _ZN5S95C44v142Ev
  virtual void  v143(); // _ZN5S95C44v143Ev
  virtual void  v144(); // _ZN5S95C44v144Ev
  virtual void  v145(); // _ZN5S95C44v145Ev
  virtual void  v146(); // _ZN5S95C44v146Ev
  virtual void  v147(); // _ZN5S95C44v147Ev
  virtual void  v148(); // _ZN5S95C44v148Ev
  virtual void  v149(); // _ZN5S95C44v149Ev
  virtual void  v150(); // _ZN5S95C44v150Ev
  virtual void  v151(); // _ZN5S95C44v151Ev
  virtual void  v152(); // _ZN5S95C44v152Ev
  virtual void  v153(); // _ZN5S95C44v153Ev
  virtual void  v154(); // _ZN5S95C44v154Ev
  virtual void  v155(); // _ZN5S95C44v155Ev
  virtual void  v156(); // _ZN5S95C44v156Ev
  S95C4(); // tgen
};
//SIG(-1 S95C4) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC9}} Fp[2] Fc FC7 FC11 FC11 Fi FC11 Fi:1 Fi:1 Fi:1 Fi[3]}


 S95C4 ::~S95C4(){ note_dtor("S95C4", this);}
void  S95C4 ::v96(){vfunc_called(this, "_ZN5S95C43v96Ev");}
void  S95C4 ::v97(){vfunc_called(this, "_ZN5S95C43v97Ev");}
void  S95C4 ::v98(){vfunc_called(this, "_ZN5S95C43v98Ev");}
void  S95C4 ::v99(){vfunc_called(this, "_ZN5S95C43v99Ev");}
void  S95C4 ::v100(){vfunc_called(this, "_ZN5S95C44v100Ev");}
void  S95C4 ::v101(){vfunc_called(this, "_ZN5S95C44v101Ev");}
void  S95C4 ::v102(){vfunc_called(this, "_ZN5S95C44v102Ev");}
void  S95C4 ::v103(){vfunc_called(this, "_ZN5S95C44v103Ev");}
void  S95C4 ::v104(){vfunc_called(this, "_ZN5S95C44v104Ev");}
void  S95C4 ::v105(){vfunc_called(this, "_ZN5S95C44v105Ev");}
void  S95C4 ::v106(){vfunc_called(this, "_ZN5S95C44v106Ev");}
void  S95C4 ::v107(){vfunc_called(this, "_ZN5S95C44v107Ev");}
void  S95C4 ::v108(){vfunc_called(this, "_ZN5S95C44v108Ev");}
void  S95C4 ::v109(){vfunc_called(this, "_ZN5S95C44v109Ev");}
void  S95C4 ::v110(){vfunc_called(this, "_ZN5S95C44v110Ev");}
void  S95C4 ::v111(){vfunc_called(this, "_ZN5S95C44v111Ev");}
void  S95C4 ::v112(){vfunc_called(this, "_ZN5S95C44v112Ev");}
void  S95C4 ::v113(){vfunc_called(this, "_ZN5S95C44v113Ev");}
void  S95C4 ::v114(){vfunc_called(this, "_ZN5S95C44v114Ev");}
void  S95C4 ::v115(){vfunc_called(this, "_ZN5S95C44v115Ev");}
void  S95C4 ::v116(){vfunc_called(this, "_ZN5S95C44v116Ev");}
void  S95C4 ::v117(){vfunc_called(this, "_ZN5S95C44v117Ev");}
void  S95C4 ::v118(){vfunc_called(this, "_ZN5S95C44v118Ev");}
void  S95C4 ::v119(){vfunc_called(this, "_ZN5S95C44v119Ev");}
void  S95C4 ::v120(){vfunc_called(this, "_ZN5S95C44v120Ev");}
void  S95C4 ::v121(){vfunc_called(this, "_ZN5S95C44v121Ev");}
void  S95C4 ::v122(){vfunc_called(this, "_ZN5S95C44v122Ev");}
void  S95C4 ::v123(){vfunc_called(this, "_ZN5S95C44v123Ev");}
void  S95C4 ::v124(){vfunc_called(this, "_ZN5S95C44v124Ev");}
void  S95C4 ::v125(){vfunc_called(this, "_ZN5S95C44v125Ev");}
void  S95C4 ::v126(){vfunc_called(this, "_ZN5S95C44v126Ev");}
void  S95C4 ::v127(){vfunc_called(this, "_ZN5S95C44v127Ev");}
void  S95C4 ::v128(){vfunc_called(this, "_ZN5S95C44v128Ev");}
void  S95C4 ::v129(){vfunc_called(this, "_ZN5S95C44v129Ev");}
void  S95C4 ::v130(){vfunc_called(this, "_ZN5S95C44v130Ev");}
void  S95C4 ::v131(){vfunc_called(this, "_ZN5S95C44v131Ev");}
void  S95C4 ::v132(){vfunc_called(this, "_ZN5S95C44v132Ev");}
void  S95C4 ::v133(){vfunc_called(this, "_ZN5S95C44v133Ev");}
void  S95C4 ::v134(){vfunc_called(this, "_ZN5S95C44v134Ev");}
void  S95C4 ::v135(){vfunc_called(this, "_ZN5S95C44v135Ev");}
void  S95C4 ::v136(){vfunc_called(this, "_ZN5S95C44v136Ev");}
void  S95C4 ::v137(){vfunc_called(this, "_ZN5S95C44v137Ev");}
void  S95C4 ::v138(){vfunc_called(this, "_ZN5S95C44v138Ev");}
void  S95C4 ::v139(){vfunc_called(this, "_ZN5S95C44v139Ev");}
void  S95C4 ::v140(){vfunc_called(this, "_ZN5S95C44v140Ev");}
void  S95C4 ::v141(){vfunc_called(this, "_ZN5S95C44v141Ev");}
void  S95C4 ::v142(){vfunc_called(this, "_ZN5S95C44v142Ev");}
void  S95C4 ::v143(){vfunc_called(this, "_ZN5S95C44v143Ev");}
void  S95C4 ::v144(){vfunc_called(this, "_ZN5S95C44v144Ev");}
void  S95C4 ::v145(){vfunc_called(this, "_ZN5S95C44v145Ev");}
void  S95C4 ::v146(){vfunc_called(this, "_ZN5S95C44v146Ev");}
void  S95C4 ::v147(){vfunc_called(this, "_ZN5S95C44v147Ev");}
void  S95C4 ::v148(){vfunc_called(this, "_ZN5S95C44v148Ev");}
void  S95C4 ::v149(){vfunc_called(this, "_ZN5S95C44v149Ev");}
void  S95C4 ::v150(){vfunc_called(this, "_ZN5S95C44v150Ev");}
void  S95C4 ::v151(){vfunc_called(this, "_ZN5S95C44v151Ev");}
void  S95C4 ::v152(){vfunc_called(this, "_ZN5S95C44v152Ev");}
void  S95C4 ::v153(){vfunc_called(this, "_ZN5S95C44v153Ev");}
void  S95C4 ::v154(){vfunc_called(this, "_ZN5S95C44v154Ev");}
void  S95C4 ::v155(){vfunc_called(this, "_ZN5S95C44v155Ev");}
void  S95C4 ::v156(){vfunc_called(this, "_ZN5S95C44v156Ev");}
S95C4 ::S95C4(){ note_ctor("S95C4", this);} // tgen

static void Test_S95C4()
{
  extern Class_Descriptor cd_S95C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S95C4, buf);
    S95C4 *dp, &lv = *(dp=new (buf) S95C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S95C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C4)");
    check_base_class_offset(lv, (S95C7_nt*)(S95C6*)(S95C5*), 0, "S95C4");
    check_base_class_offset(lv, (S95C6*)(S95C5*), 0, "S95C4");
    check_base_class_offset(lv, (S95C5*), 0, "S95C4");
    check_field_offset(lv, s95c4f0, ABISELECT(136,84), "S95C4.s95c4f0");
    check_field_offset(lv, s95c4f1, ABISELECT(144,88), "S95C4.s95c4f1");
    check_field_offset(lv, s95c4f2, ABISELECT(148,92), "S95C4.s95c4f2");
    check_field_offset(lv, s95c4f3, ABISELECT(152,96), "S95C4.s95c4f3");
    check_field_offset(lv, s95c4f4, ABISELECT(156,100), "S95C4.s95c4f4");
    check_field_offset(lv, s95c4f5, ABISELECT(160,104), "S95C4.s95c4f5");
    check_field_offset(lv, s95c4f6, ABISELECT(176,116), "S95C4.s95c4f6");
    check_field_offset(lv, s95c4f7, ABISELECT(184,120), "S95C4.s95c4f7");
    check_field_offset(lv, s95c4f8, ABISELECT(200,128), "S95C4.s95c4f8");
    check_field_offset(lv, s95c4f9, ABISELECT(232,156), "S95C4.s95c4f9");
    check_field_offset(lv, s95c4f10, ABISELECT(240,160), "S95C4.s95c4f10");
    check_field_offset(lv, s95c4f11, ABISELECT(248,168), "S95C4.s95c4f11");
    check_field_offset(lv, s95c4f12, ABISELECT(252,172), "S95C4.s95c4f12");
    set_bf_and_test(lv, s95c4f13, ABISELECT(256,176), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f14, ABISELECT(256,176), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f15, ABISELECT(256,176), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f16, ABISELECT(256,176), 3, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f17, ABISELECT(256,176), 4, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f18, ABISELECT(256,176), 5, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f19, ABISELECT(256,176), 6, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f20, ABISELECT(256,176), 7, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f21, ABISELECT(257,177), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f22, ABISELECT(257,177), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f23, ABISELECT(257,177), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f24, ABISELECT(257,177), 3, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f25, ABISELECT(257,177), 4, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f26, ABISELECT(257,177), 5, 1, 1, "S95C4");
    check_field_offset(lv, s95c4f27, ABISELECT(260,180), "S95C4.s95c4f27");
    set_bf_and_test(lv, s95c4f28, ABISELECT(264,184), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f29, ABISELECT(264,184), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f30, ABISELECT(264,184), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f31, ABISELECT(264,184), 3, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f32, ABISELECT(264,184), 4, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f33, ABISELECT(264,184), 5, 1, 1, "S95C4");
    check_field_offset(lv, s95c4f34, ABISELECT(265,185), "S95C4.s95c4f34");
    set_bf_and_test(lv, s95c4f35, ABISELECT(266,186), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f36, ABISELECT(266,186), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f37, ABISELECT(266,186), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f38, ABISELECT(266,186), 3, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f39, ABISELECT(266,186), 4, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f40, ABISELECT(266,186), 5, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f41, ABISELECT(266,186), 6, 1, 1, "S95C4");
    check_field_offset(lv, s95c4f42, ABISELECT(267,187), "S95C4.s95c4f42");
    check_field_offset(lv, s95c4f43, ABISELECT(268,188), "S95C4.s95c4f43");
    set_bf_and_test(lv, s95c4f44, ABISELECT(269,189), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f45, ABISELECT(269,189), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f46, ABISELECT(269,189), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f47, ABISELECT(269,189), 3, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f48, ABISELECT(269,189), 4, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f49, ABISELECT(269,189), 5, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f50, ABISELECT(269,189), 6, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f51, ABISELECT(269,189), 7, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f52, ABISELECT(270,190), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f53, ABISELECT(270,190), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f54, ABISELECT(270,190), 2, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f55, ABISELECT(270,190), 3, 1, 1, "S95C4");
    check_field_offset(lv, s95c4f56, ABISELECT(272,192), "S95C4.s95c4f56");
    check_field_offset(lv, s95c4f57, ABISELECT(288,204), "S95C4.s95c4f57");
    check_field_offset(lv, s95c4f58, ABISELECT(304,212), "S95C4.s95c4f58");
    check_field_offset(lv, s95c4f59, ABISELECT(305,213), "S95C4.s95c4f59");
    check_field_offset(lv, s95c4f60, ABISELECT(308,216), "S95C4.s95c4f60");
    check_field_offset(lv, s95c4f61, ABISELECT(320,228), "S95C4.s95c4f61");
    check_field_offset(lv, s95c4f62, ABISELECT(332,240), "S95C4.s95c4f62");
    check_field_offset(lv, s95c4f63, ABISELECT(336,244), "S95C4.s95c4f63");
    set_bf_and_test(lv, s95c4f64, ABISELECT(348,256), 0, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f65, ABISELECT(348,256), 1, 1, 1, "S95C4");
    set_bf_and_test(lv, s95c4f66, ABISELECT(348,256), 2, 1, 1, "S95C4");
    check_field_offset(lv, s95c4f67, ABISELECT(352,260), "S95C4.s95c4f67");
    test_class_info(&lv, &cd_S95C4);
    dp->~S95C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C4(Test_S95C4, "S95C4", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN5S95C4C1Ev();
extern void _ZN5S95C4D1Ev();
Name_Map name_map_S95C4[] = {
  NSPAIR(_ZN5S95C4C1Ev),
  NSPAIR(_ZN5S95C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
extern Class_Descriptor cd_S95C6;
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
extern Class_Descriptor cd_S95C5;
extern VTBL_ENTRY _ZTI5S95C5[];
extern  VTBL_ENTRY _ZTV5S95C5[];
static Base_Class bases_S95C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S95C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C4[];
extern void _ZN5S95C4D1Ev();
extern void _ZN5S95C4D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
extern void _ZN5S95C53v74Ev();
extern void _ZN5S95C53v75Ev();
extern void _ZN5S95C53v76Ev();
extern void _ZN5S95C53v77Ev();
extern void _ZN5S95C53v78Ev();
extern void _ZN5S95C53v79Ev();
extern void _ZN5S95C53v80Ev();
extern void _ZN5S95C53v81Ev();
extern void _ZN5S95C53v82Ev();
extern void _ZN5S95C53v83Ev();
extern void _ZN5S95C53v84Ev();
extern void _ZN5S95C53v85Ev();
extern void _ZN5S95C53v86Ev();
extern void _ZN5S95C53v87Ev();
extern void _ZN5S95C53v88Ev();
extern void _ZN5S95C53v89Ev();
extern void _ZN5S95C53v90Ev();
extern void _ZN5S95C53v91Ev();
extern void _ZN5S95C53v92Ev();
extern void _ZN5S95C53v93Ev();
extern void _ZN5S95C53v94Ev();
extern void _ZN5S95C53v95Ev();
extern void _ZN5S95C43v96Ev();
extern void _ZN5S95C43v97Ev();
extern void _ZN5S95C43v98Ev();
extern void _ZN5S95C43v99Ev();
extern void _ZN5S95C44v100Ev();
extern void _ZN5S95C44v101Ev();
extern void _ZN5S95C44v102Ev();
extern void _ZN5S95C44v103Ev();
extern void _ZN5S95C44v104Ev();
extern void _ZN5S95C44v105Ev();
extern void _ZN5S95C44v106Ev();
extern void _ZN5S95C44v107Ev();
extern void _ZN5S95C44v108Ev();
extern void _ZN5S95C44v109Ev();
extern void _ZN5S95C44v110Ev();
extern void _ZN5S95C44v111Ev();
extern void _ZN5S95C44v112Ev();
extern void _ZN5S95C44v113Ev();
extern void _ZN5S95C44v114Ev();
extern void _ZN5S95C44v115Ev();
extern void _ZN5S95C44v116Ev();
extern void _ZN5S95C44v117Ev();
extern void _ZN5S95C44v118Ev();
extern void _ZN5S95C44v119Ev();
extern void _ZN5S95C44v120Ev();
extern void _ZN5S95C44v121Ev();
extern void _ZN5S95C44v122Ev();
extern void _ZN5S95C44v123Ev();
extern void _ZN5S95C44v124Ev();
extern void _ZN5S95C44v125Ev();
extern void _ZN5S95C44v126Ev();
extern void _ZN5S95C44v127Ev();
extern void _ZN5S95C44v128Ev();
extern void _ZN5S95C44v129Ev();
extern void _ZN5S95C44v130Ev();
extern void _ZN5S95C44v131Ev();
extern void _ZN5S95C44v132Ev();
extern void _ZN5S95C44v133Ev();
extern void _ZN5S95C44v134Ev();
extern void _ZN5S95C44v135Ev();
extern void _ZN5S95C44v136Ev();
extern void _ZN5S95C44v137Ev();
extern void _ZN5S95C44v138Ev();
extern void _ZN5S95C44v139Ev();
extern void _ZN5S95C44v140Ev();
extern void _ZN5S95C44v141Ev();
extern void _ZN5S95C44v142Ev();
extern void _ZN5S95C44v143Ev();
extern void _ZN5S95C44v144Ev();
extern void _ZN5S95C44v145Ev();
extern void _ZN5S95C44v146Ev();
extern void _ZN5S95C44v147Ev();
extern void _ZN5S95C44v148Ev();
extern void _ZN5S95C44v149Ev();
extern void _ZN5S95C44v150Ev();
extern void _ZN5S95C44v151Ev();
extern void _ZN5S95C44v152Ev();
extern void _ZN5S95C44v153Ev();
extern void _ZN5S95C44v154Ev();
extern void _ZN5S95C44v155Ev();
extern void _ZN5S95C44v156Ev();
static  VTBL_ENTRY vtc_S95C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C4[0]),
  (VTBL_ENTRY)&_ZN5S95C4D1Ev,
  (VTBL_ENTRY)&_ZN5S95C4D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
  (VTBL_ENTRY)&_ZN5S95C53v74Ev,
  (VTBL_ENTRY)&_ZN5S95C53v75Ev,
  (VTBL_ENTRY)&_ZN5S95C53v76Ev,
  (VTBL_ENTRY)&_ZN5S95C53v77Ev,
  (VTBL_ENTRY)&_ZN5S95C53v78Ev,
  (VTBL_ENTRY)&_ZN5S95C53v79Ev,
  (VTBL_ENTRY)&_ZN5S95C53v80Ev,
  (VTBL_ENTRY)&_ZN5S95C53v81Ev,
  (VTBL_ENTRY)&_ZN5S95C53v82Ev,
  (VTBL_ENTRY)&_ZN5S95C53v83Ev,
  (VTBL_ENTRY)&_ZN5S95C53v84Ev,
  (VTBL_ENTRY)&_ZN5S95C53v85Ev,
  (VTBL_ENTRY)&_ZN5S95C53v86Ev,
  (VTBL_ENTRY)&_ZN5S95C53v87Ev,
  (VTBL_ENTRY)&_ZN5S95C53v88Ev,
  (VTBL_ENTRY)&_ZN5S95C53v89Ev,
  (VTBL_ENTRY)&_ZN5S95C53v90Ev,
  (VTBL_ENTRY)&_ZN5S95C53v91Ev,
  (VTBL_ENTRY)&_ZN5S95C53v92Ev,
  (VTBL_ENTRY)&_ZN5S95C53v93Ev,
  (VTBL_ENTRY)&_ZN5S95C53v94Ev,
  (VTBL_ENTRY)&_ZN5S95C53v95Ev,
  (VTBL_ENTRY)&_ZN5S95C43v96Ev,
  (VTBL_ENTRY)&_ZN5S95C43v97Ev,
  (VTBL_ENTRY)&_ZN5S95C43v98Ev,
  (VTBL_ENTRY)&_ZN5S95C43v99Ev,
  (VTBL_ENTRY)&_ZN5S95C44v100Ev,
  (VTBL_ENTRY)&_ZN5S95C44v101Ev,
  (VTBL_ENTRY)&_ZN5S95C44v102Ev,
  (VTBL_ENTRY)&_ZN5S95C44v103Ev,
  (VTBL_ENTRY)&_ZN5S95C44v104Ev,
  (VTBL_ENTRY)&_ZN5S95C44v105Ev,
  (VTBL_ENTRY)&_ZN5S95C44v106Ev,
  (VTBL_ENTRY)&_ZN5S95C44v107Ev,
  (VTBL_ENTRY)&_ZN5S95C44v108Ev,
  (VTBL_ENTRY)&_ZN5S95C44v109Ev,
  (VTBL_ENTRY)&_ZN5S95C44v110Ev,
  (VTBL_ENTRY)&_ZN5S95C44v111Ev,
  (VTBL_ENTRY)&_ZN5S95C44v112Ev,
  (VTBL_ENTRY)&_ZN5S95C44v113Ev,
  (VTBL_ENTRY)&_ZN5S95C44v114Ev,
  (VTBL_ENTRY)&_ZN5S95C44v115Ev,
  (VTBL_ENTRY)&_ZN5S95C44v116Ev,
  (VTBL_ENTRY)&_ZN5S95C44v117Ev,
  (VTBL_ENTRY)&_ZN5S95C44v118Ev,
  (VTBL_ENTRY)&_ZN5S95C44v119Ev,
  (VTBL_ENTRY)&_ZN5S95C44v120Ev,
  (VTBL_ENTRY)&_ZN5S95C44v121Ev,
  (VTBL_ENTRY)&_ZN5S95C44v122Ev,
  (VTBL_ENTRY)&_ZN5S95C44v123Ev,
  (VTBL_ENTRY)&_ZN5S95C44v124Ev,
  (VTBL_ENTRY)&_ZN5S95C44v125Ev,
  (VTBL_ENTRY)&_ZN5S95C44v126Ev,
  (VTBL_ENTRY)&_ZN5S95C44v127Ev,
  (VTBL_ENTRY)&_ZN5S95C44v128Ev,
  (VTBL_ENTRY)&_ZN5S95C44v129Ev,
  (VTBL_ENTRY)&_ZN5S95C44v130Ev,
  (VTBL_ENTRY)&_ZN5S95C44v131Ev,
  (VTBL_ENTRY)&_ZN5S95C44v132Ev,
  (VTBL_ENTRY)&_ZN5S95C44v133Ev,
  (VTBL_ENTRY)&_ZN5S95C44v134Ev,
  (VTBL_ENTRY)&_ZN5S95C44v135Ev,
  (VTBL_ENTRY)&_ZN5S95C44v136Ev,
  (VTBL_ENTRY)&_ZN5S95C44v137Ev,
  (VTBL_ENTRY)&_ZN5S95C44v138Ev,
  (VTBL_ENTRY)&_ZN5S95C44v139Ev,
  (VTBL_ENTRY)&_ZN5S95C44v140Ev,
  (VTBL_ENTRY)&_ZN5S95C44v141Ev,
  (VTBL_ENTRY)&_ZN5S95C44v142Ev,
  (VTBL_ENTRY)&_ZN5S95C44v143Ev,
  (VTBL_ENTRY)&_ZN5S95C44v144Ev,
  (VTBL_ENTRY)&_ZN5S95C44v145Ev,
  (VTBL_ENTRY)&_ZN5S95C44v146Ev,
  (VTBL_ENTRY)&_ZN5S95C44v147Ev,
  (VTBL_ENTRY)&_ZN5S95C44v148Ev,
  (VTBL_ENTRY)&_ZN5S95C44v149Ev,
  (VTBL_ENTRY)&_ZN5S95C44v150Ev,
  (VTBL_ENTRY)&_ZN5S95C44v151Ev,
  (VTBL_ENTRY)&_ZN5S95C44v152Ev,
  (VTBL_ENTRY)&_ZN5S95C44v153Ev,
  (VTBL_ENTRY)&_ZN5S95C44v154Ev,
  (VTBL_ENTRY)&_ZN5S95C44v155Ev,
  (VTBL_ENTRY)&_ZN5S95C44v156Ev,
};
extern VTBL_ENTRY _ZTI5S95C4[];
extern  VTBL_ENTRY _ZTV5S95C4[];
Class_Descriptor cd_S95C4 = {  "S95C4", // class name
  bases_S95C4, 3,
  &(vtc_S95C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI5S95C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C4),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C3  : S95C4 {
  ::S95C17_nt s95c3f0;
  virtual  ~S95C3(); // _ZN5S95C3D1Ev
  virtual void  v157(); // _ZN5S95C34v157Ev
  virtual void  v158(); // _ZN5S95C34v158Ev
  virtual void  v159(); // _ZN5S95C34v159Ev
  virtual void  v160(); // _ZN5S95C34v160Ev
  S95C3(); // tgen
};
//SIG(-1 S95C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC6} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC10}} Fp[2] Fc FC8 FC12 FC12 Fi FC12 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 FC14}


 S95C3 ::~S95C3(){ note_dtor("S95C3", this);}
void  S95C3 ::v157(){vfunc_called(this, "_ZN5S95C34v157Ev");}
void  S95C3 ::v158(){vfunc_called(this, "_ZN5S95C34v158Ev");}
void  S95C3 ::v159(){vfunc_called(this, "_ZN5S95C34v159Ev");}
void  S95C3 ::v160(){vfunc_called(this, "_ZN5S95C34v160Ev");}
S95C3 ::S95C3(){ note_ctor("S95C3", this);} // tgen

static void Test_S95C3()
{
  extern Class_Descriptor cd_S95C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,72)];
    init_test(&cd_S95C3, buf);
    S95C3 *dp, &lv = *(dp=new (buf) S95C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,284), "sizeof(S95C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C3)");
    check_base_class_offset(lv, (S95C7_nt*)(S95C6*)(S95C5*)(S95C4*), 0, "S95C3");
    check_base_class_offset(lv, (S95C6*)(S95C5*)(S95C4*), 0, "S95C3");
    check_base_class_offset(lv, (S95C5*)(S95C4*), 0, "S95C3");
    check_base_class_offset(lv, (S95C4*), 0, "S95C3");
    check_field_offset(lv, s95c3f0, ABISELECT(368,272), "S95C3.s95c3f0");
    test_class_info(&lv, &cd_S95C3);
    dp->~S95C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C3(Test_S95C3, "S95C3", ABISELECT(384,284));

#else // __cplusplus

extern void _ZN5S95C3C1Ev();
extern void _ZN5S95C3D1Ev();
Name_Map name_map_S95C3[] = {
  NSPAIR(_ZN5S95C3C1Ev),
  NSPAIR(_ZN5S95C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
extern Class_Descriptor cd_S95C6;
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
extern Class_Descriptor cd_S95C5;
extern VTBL_ENTRY _ZTI5S95C5[];
extern  VTBL_ENTRY _ZTV5S95C5[];
extern Class_Descriptor cd_S95C4;
extern VTBL_ENTRY _ZTI5S95C4[];
extern  VTBL_ENTRY _ZTV5S95C4[];
static Base_Class bases_S95C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S95C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S95C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C3[];
extern void _ZN5S95C3D1Ev();
extern void _ZN5S95C3D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
extern void _ZN5S95C53v74Ev();
extern void _ZN5S95C53v75Ev();
extern void _ZN5S95C53v76Ev();
extern void _ZN5S95C53v77Ev();
extern void _ZN5S95C53v78Ev();
extern void _ZN5S95C53v79Ev();
extern void _ZN5S95C53v80Ev();
extern void _ZN5S95C53v81Ev();
extern void _ZN5S95C53v82Ev();
extern void _ZN5S95C53v83Ev();
extern void _ZN5S95C53v84Ev();
extern void _ZN5S95C53v85Ev();
extern void _ZN5S95C53v86Ev();
extern void _ZN5S95C53v87Ev();
extern void _ZN5S95C53v88Ev();
extern void _ZN5S95C53v89Ev();
extern void _ZN5S95C53v90Ev();
extern void _ZN5S95C53v91Ev();
extern void _ZN5S95C53v92Ev();
extern void _ZN5S95C53v93Ev();
extern void _ZN5S95C53v94Ev();
extern void _ZN5S95C53v95Ev();
extern void _ZN5S95C43v96Ev();
extern void _ZN5S95C43v97Ev();
extern void _ZN5S95C43v98Ev();
extern void _ZN5S95C43v99Ev();
extern void _ZN5S95C44v100Ev();
extern void _ZN5S95C44v101Ev();
extern void _ZN5S95C44v102Ev();
extern void _ZN5S95C44v103Ev();
extern void _ZN5S95C44v104Ev();
extern void _ZN5S95C44v105Ev();
extern void _ZN5S95C44v106Ev();
extern void _ZN5S95C44v107Ev();
extern void _ZN5S95C44v108Ev();
extern void _ZN5S95C44v109Ev();
extern void _ZN5S95C44v110Ev();
extern void _ZN5S95C44v111Ev();
extern void _ZN5S95C44v112Ev();
extern void _ZN5S95C44v113Ev();
extern void _ZN5S95C44v114Ev();
extern void _ZN5S95C44v115Ev();
extern void _ZN5S95C44v116Ev();
extern void _ZN5S95C44v117Ev();
extern void _ZN5S95C44v118Ev();
extern void _ZN5S95C44v119Ev();
extern void _ZN5S95C44v120Ev();
extern void _ZN5S95C44v121Ev();
extern void _ZN5S95C44v122Ev();
extern void _ZN5S95C44v123Ev();
extern void _ZN5S95C44v124Ev();
extern void _ZN5S95C44v125Ev();
extern void _ZN5S95C44v126Ev();
extern void _ZN5S95C44v127Ev();
extern void _ZN5S95C44v128Ev();
extern void _ZN5S95C44v129Ev();
extern void _ZN5S95C44v130Ev();
extern void _ZN5S95C44v131Ev();
extern void _ZN5S95C44v132Ev();
extern void _ZN5S95C44v133Ev();
extern void _ZN5S95C44v134Ev();
extern void _ZN5S95C44v135Ev();
extern void _ZN5S95C44v136Ev();
extern void _ZN5S95C44v137Ev();
extern void _ZN5S95C44v138Ev();
extern void _ZN5S95C44v139Ev();
extern void _ZN5S95C44v140Ev();
extern void _ZN5S95C44v141Ev();
extern void _ZN5S95C44v142Ev();
extern void _ZN5S95C44v143Ev();
extern void _ZN5S95C44v144Ev();
extern void _ZN5S95C44v145Ev();
extern void _ZN5S95C44v146Ev();
extern void _ZN5S95C44v147Ev();
extern void _ZN5S95C44v148Ev();
extern void _ZN5S95C44v149Ev();
extern void _ZN5S95C44v150Ev();
extern void _ZN5S95C44v151Ev();
extern void _ZN5S95C44v152Ev();
extern void _ZN5S95C44v153Ev();
extern void _ZN5S95C44v154Ev();
extern void _ZN5S95C44v155Ev();
extern void _ZN5S95C44v156Ev();
extern void _ZN5S95C34v157Ev();
extern void _ZN5S95C34v158Ev();
extern void _ZN5S95C34v159Ev();
extern void _ZN5S95C34v160Ev();
static  VTBL_ENTRY vtc_S95C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C3[0]),
  (VTBL_ENTRY)&_ZN5S95C3D1Ev,
  (VTBL_ENTRY)&_ZN5S95C3D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
  (VTBL_ENTRY)&_ZN5S95C53v74Ev,
  (VTBL_ENTRY)&_ZN5S95C53v75Ev,
  (VTBL_ENTRY)&_ZN5S95C53v76Ev,
  (VTBL_ENTRY)&_ZN5S95C53v77Ev,
  (VTBL_ENTRY)&_ZN5S95C53v78Ev,
  (VTBL_ENTRY)&_ZN5S95C53v79Ev,
  (VTBL_ENTRY)&_ZN5S95C53v80Ev,
  (VTBL_ENTRY)&_ZN5S95C53v81Ev,
  (VTBL_ENTRY)&_ZN5S95C53v82Ev,
  (VTBL_ENTRY)&_ZN5S95C53v83Ev,
  (VTBL_ENTRY)&_ZN5S95C53v84Ev,
  (VTBL_ENTRY)&_ZN5S95C53v85Ev,
  (VTBL_ENTRY)&_ZN5S95C53v86Ev,
  (VTBL_ENTRY)&_ZN5S95C53v87Ev,
  (VTBL_ENTRY)&_ZN5S95C53v88Ev,
  (VTBL_ENTRY)&_ZN5S95C53v89Ev,
  (VTBL_ENTRY)&_ZN5S95C53v90Ev,
  (VTBL_ENTRY)&_ZN5S95C53v91Ev,
  (VTBL_ENTRY)&_ZN5S95C53v92Ev,
  (VTBL_ENTRY)&_ZN5S95C53v93Ev,
  (VTBL_ENTRY)&_ZN5S95C53v94Ev,
  (VTBL_ENTRY)&_ZN5S95C53v95Ev,
  (VTBL_ENTRY)&_ZN5S95C43v96Ev,
  (VTBL_ENTRY)&_ZN5S95C43v97Ev,
  (VTBL_ENTRY)&_ZN5S95C43v98Ev,
  (VTBL_ENTRY)&_ZN5S95C43v99Ev,
  (VTBL_ENTRY)&_ZN5S95C44v100Ev,
  (VTBL_ENTRY)&_ZN5S95C44v101Ev,
  (VTBL_ENTRY)&_ZN5S95C44v102Ev,
  (VTBL_ENTRY)&_ZN5S95C44v103Ev,
  (VTBL_ENTRY)&_ZN5S95C44v104Ev,
  (VTBL_ENTRY)&_ZN5S95C44v105Ev,
  (VTBL_ENTRY)&_ZN5S95C44v106Ev,
  (VTBL_ENTRY)&_ZN5S95C44v107Ev,
  (VTBL_ENTRY)&_ZN5S95C44v108Ev,
  (VTBL_ENTRY)&_ZN5S95C44v109Ev,
  (VTBL_ENTRY)&_ZN5S95C44v110Ev,
  (VTBL_ENTRY)&_ZN5S95C44v111Ev,
  (VTBL_ENTRY)&_ZN5S95C44v112Ev,
  (VTBL_ENTRY)&_ZN5S95C44v113Ev,
  (VTBL_ENTRY)&_ZN5S95C44v114Ev,
  (VTBL_ENTRY)&_ZN5S95C44v115Ev,
  (VTBL_ENTRY)&_ZN5S95C44v116Ev,
  (VTBL_ENTRY)&_ZN5S95C44v117Ev,
  (VTBL_ENTRY)&_ZN5S95C44v118Ev,
  (VTBL_ENTRY)&_ZN5S95C44v119Ev,
  (VTBL_ENTRY)&_ZN5S95C44v120Ev,
  (VTBL_ENTRY)&_ZN5S95C44v121Ev,
  (VTBL_ENTRY)&_ZN5S95C44v122Ev,
  (VTBL_ENTRY)&_ZN5S95C44v123Ev,
  (VTBL_ENTRY)&_ZN5S95C44v124Ev,
  (VTBL_ENTRY)&_ZN5S95C44v125Ev,
  (VTBL_ENTRY)&_ZN5S95C44v126Ev,
  (VTBL_ENTRY)&_ZN5S95C44v127Ev,
  (VTBL_ENTRY)&_ZN5S95C44v128Ev,
  (VTBL_ENTRY)&_ZN5S95C44v129Ev,
  (VTBL_ENTRY)&_ZN5S95C44v130Ev,
  (VTBL_ENTRY)&_ZN5S95C44v131Ev,
  (VTBL_ENTRY)&_ZN5S95C44v132Ev,
  (VTBL_ENTRY)&_ZN5S95C44v133Ev,
  (VTBL_ENTRY)&_ZN5S95C44v134Ev,
  (VTBL_ENTRY)&_ZN5S95C44v135Ev,
  (VTBL_ENTRY)&_ZN5S95C44v136Ev,
  (VTBL_ENTRY)&_ZN5S95C44v137Ev,
  (VTBL_ENTRY)&_ZN5S95C44v138Ev,
  (VTBL_ENTRY)&_ZN5S95C44v139Ev,
  (VTBL_ENTRY)&_ZN5S95C44v140Ev,
  (VTBL_ENTRY)&_ZN5S95C44v141Ev,
  (VTBL_ENTRY)&_ZN5S95C44v142Ev,
  (VTBL_ENTRY)&_ZN5S95C44v143Ev,
  (VTBL_ENTRY)&_ZN5S95C44v144Ev,
  (VTBL_ENTRY)&_ZN5S95C44v145Ev,
  (VTBL_ENTRY)&_ZN5S95C44v146Ev,
  (VTBL_ENTRY)&_ZN5S95C44v147Ev,
  (VTBL_ENTRY)&_ZN5S95C44v148Ev,
  (VTBL_ENTRY)&_ZN5S95C44v149Ev,
  (VTBL_ENTRY)&_ZN5S95C44v150Ev,
  (VTBL_ENTRY)&_ZN5S95C44v151Ev,
  (VTBL_ENTRY)&_ZN5S95C44v152Ev,
  (VTBL_ENTRY)&_ZN5S95C44v153Ev,
  (VTBL_ENTRY)&_ZN5S95C44v154Ev,
  (VTBL_ENTRY)&_ZN5S95C44v155Ev,
  (VTBL_ENTRY)&_ZN5S95C44v156Ev,
  (VTBL_ENTRY)&_ZN5S95C34v157Ev,
  (VTBL_ENTRY)&_ZN5S95C34v158Ev,
  (VTBL_ENTRY)&_ZN5S95C34v159Ev,
  (VTBL_ENTRY)&_ZN5S95C34v160Ev,
};
extern VTBL_ENTRY _ZTI5S95C3[];
extern  VTBL_ENTRY _ZTV5S95C3[];
Class_Descriptor cd_S95C3 = {  "S95C3", // class name
  bases_S95C3, 4,
  &(vtc_S95C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,284), // object size
  NSPAIRA(_ZTI5S95C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C3),160, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C24  : S95C12_nt {
};
//SIG(-1 S95C24) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C24()
{
  extern Class_Descriptor cd_S95C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C24, buf);
    S95C24 &lv = *(new (buf) S95C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C24)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C24");
    test_class_info(&lv, &cd_S95C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C24(Test_S95C24, "S95C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C24 = {  "S95C24", // class name
  bases_S95C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C26  : S95C12_nt {
};
//SIG(-1 S95C26) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C26()
{
  extern Class_Descriptor cd_S95C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C26, buf);
    S95C26 &lv = *(new (buf) S95C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C26)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C26");
    test_class_info(&lv, &cd_S95C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C26(Test_S95C26, "S95C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C26 = {  "S95C26", // class name
  bases_S95C26, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C28  : S95C12_nt {
};
//SIG(-1 S95C28) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C28()
{
  extern Class_Descriptor cd_S95C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C28, buf);
    S95C28 &lv = *(new (buf) S95C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C28)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C28");
    test_class_info(&lv, &cd_S95C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C28(Test_S95C28, "S95C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C28 = {  "S95C28", // class name
  bases_S95C28, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C27  : S95C28 {
};
//SIG(-1 S95C27) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S95C27()
{
  extern Class_Descriptor cd_S95C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C27, buf);
    S95C27 &lv = *(new (buf) S95C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C27)");
    check_base_class_offset(lv, (S95C12_nt*)(S95C28*), 0, "S95C27");
    check_base_class_offset(lv, (S95C28*), 0, "S95C27");
    test_class_info(&lv, &cd_S95C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C27(Test_S95C27, "S95C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S95C28;
static Base_Class bases_S95C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C27 = {  "S95C27", // class name
  bases_S95C27, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C32  : S95C12_nt {
};
//SIG(-1 S95C32) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C32()
{
  extern Class_Descriptor cd_S95C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C32, buf);
    S95C32 &lv = *(new (buf) S95C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C32)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C32");
    test_class_info(&lv, &cd_S95C32);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C32(Test_S95C32, "S95C32", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C32 = {  "S95C32", // class name
  bases_S95C32, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C31  : S95C32 {
};
//SIG(-1 S95C31) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S95C31()
{
  extern Class_Descriptor cd_S95C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C31, buf);
    S95C31 &lv = *(new (buf) S95C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C31)");
    check_base_class_offset(lv, (S95C12_nt*)(S95C32*), 0, "S95C31");
    check_base_class_offset(lv, (S95C32*), 0, "S95C31");
    test_class_info(&lv, &cd_S95C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C31(Test_S95C31, "S95C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S95C32;
static Base_Class bases_S95C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C31 = {  "S95C31", // class name
  bases_S95C31, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C36  : S95C12_nt {
};
//SIG(-1 S95C36) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C36()
{
  extern Class_Descriptor cd_S95C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C36, buf);
    S95C36 &lv = *(new (buf) S95C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C36)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C36");
    test_class_info(&lv, &cd_S95C36);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C36(Test_S95C36, "S95C36", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C36 = {  "S95C36", // class name
  bases_S95C36, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C35  : S95C36 {
};
//SIG(-1 S95C35) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S95C35()
{
  extern Class_Descriptor cd_S95C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C35, buf);
    S95C35 &lv = *(new (buf) S95C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C35)");
    check_base_class_offset(lv, (S95C12_nt*)(S95C36*), 0, "S95C35");
    check_base_class_offset(lv, (S95C36*), 0, "S95C35");
    test_class_info(&lv, &cd_S95C35);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C35(Test_S95C35, "S95C35", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S95C36;
static Base_Class bases_S95C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C35 = {  "S95C35", // class name
  bases_S95C35, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C38  : S95C12_nt {
};
//SIG(-1 S95C38) C1{ BC2{ m Fp Fi[2]}}



static void Test_S95C38()
{
  extern Class_Descriptor cd_S95C38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S95C38, buf);
    S95C38 &lv = *(new (buf) S95C38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S95C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C38)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S95C38");
    test_class_info(&lv, &cd_S95C38);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C38(Test_S95C38, "S95C38", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S95C38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S95C38 = {  "S95C38", // class name
  bases_S95C38, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C40_nt  {
  int s95c40f0[4];
  void  mf95c40(); // _ZN9S95C40_nt7mf95c40Ev
};
//SIG(-1 S95C40_nt) C1{ m Fi[4]}


void  S95C40_nt ::mf95c40(){}

//skip512 S95C40_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C39  {
  ::S95C40_nt s95c39f0;
  ::S95C14_nt s95c39f1;
  int s95c39f2;
  void  mf95c39(); // _ZN6S95C397mf95c39Ev
};
//SIG(-1 S95C39) C1{ m FC2{ m Fi[4]} FC3{ m Fi[3]} Fi}


void  S95C39 ::mf95c39(){}

static void Test_S95C39()
{
  {
    init_simple_test("S95C39");
    S95C39 lv;
    check2(sizeof(lv), 32, "sizeof(S95C39)");
    check2(__alignof__(lv), 4, "__alignof__(S95C39)");
    check_field_offset(lv, s95c39f0, 0, "S95C39.s95c39f0");
    check_field_offset(lv, s95c39f1, 16, "S95C39.s95c39f1");
    check_field_offset(lv, s95c39f2, 28, "S95C39.s95c39f2");
  }
}
static Arrange_To_Call_Me vS95C39(Test_S95C39, "S95C39", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C2  : S95C3 {
  void *s95c2f0[4];
  ::S95C11_nt s95c2f1;
  void *s95c2f2[2];
  int s95c2f3[2];
  void *s95c2f4;
  ::S95C16 s95c2f5;
  ::S95C24 s95c2f6;
  ::S95C24 s95c2f7;
  ::S95C26 s95c2f8;
  void *s95c2f9;
  ::S95C27 s95c2f10;
  ::S95C27 s95c2f11;
  ::S95C27 s95c2f12;
  ::S95C31 s95c2f13;
  ::S95C31 s95c2f14;
  ::S95C35 s95c2f15;
  ::S95C35 s95c2f16;
  int s95c2f17[19];
  ::S95C8_nt s95c2f18;
  int s95c2f19;
  unsigned int s95c2f20:1;
  unsigned int s95c2f21:1;
  unsigned int s95c2f22:1;
  unsigned int s95c2f23:1;
  unsigned int s95c2f24:1;
  unsigned int s95c2f25:1;
  unsigned int s95c2f26:1;
  unsigned int s95c2f27:1;
  unsigned int s95c2f28:1;
  unsigned int s95c2f29:1;
  unsigned int s95c2f30:1;
  unsigned int s95c2f31:1;
  unsigned int s95c2f32:1;
  unsigned int s95c2f33:1;
  unsigned int s95c2f34:1;
  unsigned int s95c2f35:1;
  unsigned int s95c2f36:1;
  unsigned int s95c2f37:1;
  unsigned int s95c2f38:1;
  unsigned int s95c2f39:1;
  unsigned int s95c2f40:1;
  unsigned int s95c2f41:1;
  unsigned int s95c2f42:1;
  unsigned int s95c2f43:1;
  unsigned int s95c2f44:1;
  unsigned int s95c2f45:1;
  unsigned int s95c2f46:1;
  unsigned int s95c2f47:1;
  unsigned int s95c2f48:1;
  unsigned int s95c2f49:1;
  unsigned int s95c2f50:1;
  ::S95C14_nt s95c2f51;
  ::S95C14_nt s95c2f52;
  ::S95C14_nt s95c2f53;
  int s95c2f54;
  void *s95c2f55;
  int s95c2f56;
  ::S95C38 s95c2f57;
  ::S95C38 s95c2f58;
  ::S95C28 s95c2f59;
  int s95c2f60[2];
  ::S95C28 s95c2f61;
  int s95c2f62;
  ::S95C38 s95c2f63;
  ::S95C38 s95c2f64;
  ::S95C28 s95c2f65;
  int s95c2f66;
  char s95c2f67;
  ::S95C16 s95c2f68;
  int s95c2f69[2];
  void *s95c2f70;
  ::S95C39 s95c2f71;
  ::S95C14_nt s95c2f72;
  ::S95C14_nt s95c2f73;
  ::S95C14_nt s95c2f74;
  char s95c2f75[4];
  int s95c2f76;
  char s95c2f77[2];
  void *s95c2f78[2];
  virtual  ~S95C2(); // _ZN5S95C2D1Ev
  virtual void  v161(); // _ZN5S95C24v161Ev
  virtual void  v162(); // _ZN5S95C24v162Ev
  virtual void  v163(); // _ZN5S95C24v163Ev
  virtual void  v164(); // _ZN5S95C24v164Ev
  virtual void  v165(); // _ZN5S95C24v165Ev
  virtual void  v166(); // _ZN5S95C24v166Ev
  virtual void  v167(); // _ZN5S95C24v167Ev
  virtual void  v168(); // _ZN5S95C24v168Ev
  virtual void  v169(); // _ZN5S95C24v169Ev
  virtual void  v170(); // _ZN5S95C24v170Ev
  virtual void  v171(); // _ZN5S95C24v171Ev
  virtual void  v172(); // _ZN5S95C24v172Ev
  virtual void  v173(); // _ZN5S95C24v173Ev
  virtual void  v174(); // _ZN5S95C24v174Ev
  virtual void  v175(); // _ZN5S95C24v175Ev
  virtual void  v176(); // _ZN5S95C24v176Ev
  virtual void  v177(); // _ZN5S95C24v177Ev
  virtual void  v178(); // _ZN5S95C24v178Ev
  virtual void  v179(); // _ZN5S95C24v179Ev
  virtual void  v180(); // _ZN5S95C24v180Ev
  virtual void  v181(); // _ZN5S95C24v181Ev
  virtual void  v182(); // _ZN5S95C24v182Ev
  virtual void  v183(); // _ZN5S95C24v183Ev
  virtual void  v184(); // _ZN5S95C24v184Ev
  virtual void  v185(); // _ZN5S95C24v185Ev
  virtual void  v186(); // _ZN5S95C24v186Ev
  virtual void  v187(); // _ZN5S95C24v187Ev
  virtual void  v188(); // _ZN5S95C24v188Ev
  virtual void  v189(); // _ZN5S95C24v189Ev
  virtual void  v190(); // _ZN5S95C24v190Ev
  virtual void  v191(); // _ZN5S95C24v191Ev
  virtual void  v192(); // _ZN5S95C24v192Ev
  virtual void  v193(); // _ZN5S95C24v193Ev
  virtual void  v194(); // _ZN5S95C24v194Ev
  virtual void  v195(); // _ZN5S95C24v195Ev
  virtual void  v196(); // _ZN5S95C24v196Ev
  virtual void  v197(); // _ZN5S95C24v197Ev
  virtual void  v198(); // _ZN5S95C24v198Ev
  virtual void  v199(); // _ZN5S95C24v199Ev
  virtual void  v200(); // _ZN5S95C24v200Ev
  virtual void  v201(); // _ZN5S95C24v201Ev
  virtual void  v202(); // _ZN5S95C24v202Ev
  virtual void  v203(); // _ZN5S95C24v203Ev
  virtual void  v204(); // _ZN5S95C24v204Ev
  virtual void  v205(); // _ZN5S95C24v205Ev
  virtual void  v206(); // _ZN5S95C24v206Ev
  virtual void  v207(); // _ZN5S95C24v207Ev
  S95C2(); // tgen
};
//SIG(-1 S95C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v112 v113 v114 v115 v116 Fp FC7} vd v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 Fp FC8{ m Fi} Fi FC9{ m} Fi FC10{ BC11{ m Fp Fi[2]}} Fi Fp[2] FC12{ m FC13{ m Fi[3]} FC13 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC16{ BC11}} Fp[2] Fc FC9 FC13 FC13 Fi FC13 Fi:1 Fi:1 Fi:1 Fi[3]} vd v200 v201 v202 v203 FC15} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 Fp[4] FC10 Fp[2] Fi[2] Fp FC14 FC17{ BC11} FC17 FC18{ BC11} Fp FC19{ BC20{ BC11}} FC19 FC19 FC21{ BC22{ BC11}} FC21 FC23{ BC24{ BC11}} FC23 Fi[19] FC7 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13 FC13 FC13 Fi Fp Fi FC25{ BC11} FC25 FC20 Fi[2] FC20 Fi FC25 FC25 FC20 Fi Fc FC14 Fi[2] Fp FC26{ m FC27{ m Fi[4]} FC13 Fi} FC13 FC13 FC13 Fc[4] Fi Fc[2] Fp[2]}


 S95C2 ::~S95C2(){ note_dtor("S95C2", this);}
void  S95C2 ::v161(){vfunc_called(this, "_ZN5S95C24v161Ev");}
void  S95C2 ::v162(){vfunc_called(this, "_ZN5S95C24v162Ev");}
void  S95C2 ::v163(){vfunc_called(this, "_ZN5S95C24v163Ev");}
void  S95C2 ::v164(){vfunc_called(this, "_ZN5S95C24v164Ev");}
void  S95C2 ::v165(){vfunc_called(this, "_ZN5S95C24v165Ev");}
void  S95C2 ::v166(){vfunc_called(this, "_ZN5S95C24v166Ev");}
void  S95C2 ::v167(){vfunc_called(this, "_ZN5S95C24v167Ev");}
void  S95C2 ::v168(){vfunc_called(this, "_ZN5S95C24v168Ev");}
void  S95C2 ::v169(){vfunc_called(this, "_ZN5S95C24v169Ev");}
void  S95C2 ::v170(){vfunc_called(this, "_ZN5S95C24v170Ev");}
void  S95C2 ::v171(){vfunc_called(this, "_ZN5S95C24v171Ev");}
void  S95C2 ::v172(){vfunc_called(this, "_ZN5S95C24v172Ev");}
void  S95C2 ::v173(){vfunc_called(this, "_ZN5S95C24v173Ev");}
void  S95C2 ::v174(){vfunc_called(this, "_ZN5S95C24v174Ev");}
void  S95C2 ::v175(){vfunc_called(this, "_ZN5S95C24v175Ev");}
void  S95C2 ::v176(){vfunc_called(this, "_ZN5S95C24v176Ev");}
void  S95C2 ::v177(){vfunc_called(this, "_ZN5S95C24v177Ev");}
void  S95C2 ::v178(){vfunc_called(this, "_ZN5S95C24v178Ev");}
void  S95C2 ::v179(){vfunc_called(this, "_ZN5S95C24v179Ev");}
void  S95C2 ::v180(){vfunc_called(this, "_ZN5S95C24v180Ev");}
void  S95C2 ::v181(){vfunc_called(this, "_ZN5S95C24v181Ev");}
void  S95C2 ::v182(){vfunc_called(this, "_ZN5S95C24v182Ev");}
void  S95C2 ::v183(){vfunc_called(this, "_ZN5S95C24v183Ev");}
void  S95C2 ::v184(){vfunc_called(this, "_ZN5S95C24v184Ev");}
void  S95C2 ::v185(){vfunc_called(this, "_ZN5S95C24v185Ev");}
void  S95C2 ::v186(){vfunc_called(this, "_ZN5S95C24v186Ev");}
void  S95C2 ::v187(){vfunc_called(this, "_ZN5S95C24v187Ev");}
void  S95C2 ::v188(){vfunc_called(this, "_ZN5S95C24v188Ev");}
void  S95C2 ::v189(){vfunc_called(this, "_ZN5S95C24v189Ev");}
void  S95C2 ::v190(){vfunc_called(this, "_ZN5S95C24v190Ev");}
void  S95C2 ::v191(){vfunc_called(this, "_ZN5S95C24v191Ev");}
void  S95C2 ::v192(){vfunc_called(this, "_ZN5S95C24v192Ev");}
void  S95C2 ::v193(){vfunc_called(this, "_ZN5S95C24v193Ev");}
void  S95C2 ::v194(){vfunc_called(this, "_ZN5S95C24v194Ev");}
void  S95C2 ::v195(){vfunc_called(this, "_ZN5S95C24v195Ev");}
void  S95C2 ::v196(){vfunc_called(this, "_ZN5S95C24v196Ev");}
void  S95C2 ::v197(){vfunc_called(this, "_ZN5S95C24v197Ev");}
void  S95C2 ::v198(){vfunc_called(this, "_ZN5S95C24v198Ev");}
void  S95C2 ::v199(){vfunc_called(this, "_ZN5S95C24v199Ev");}
void  S95C2 ::v200(){vfunc_called(this, "_ZN5S95C24v200Ev");}
void  S95C2 ::v201(){vfunc_called(this, "_ZN5S95C24v201Ev");}
void  S95C2 ::v202(){vfunc_called(this, "_ZN5S95C24v202Ev");}
void  S95C2 ::v203(){vfunc_called(this, "_ZN5S95C24v203Ev");}
void  S95C2 ::v204(){vfunc_called(this, "_ZN5S95C24v204Ev");}
void  S95C2 ::v205(){vfunc_called(this, "_ZN5S95C24v205Ev");}
void  S95C2 ::v206(){vfunc_called(this, "_ZN5S95C24v206Ev");}
void  S95C2 ::v207(){vfunc_called(this, "_ZN5S95C24v207Ev");}
S95C2 ::S95C2(){ note_ctor("S95C2", this);} // tgen

static void Test_S95C2()
{
  extern Class_Descriptor cd_S95C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,202)];
    init_test(&cd_S95C2, buf);
    S95C2 *dp, &lv = *(dp=new (buf) S95C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,804), "sizeof(S95C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C2)");
    check_base_class_offset(lv, (S95C7_nt*)(S95C6*)(S95C5*)(S95C4*)(S95C3*), 0, "S95C2");
    check_base_class_offset(lv, (S95C6*)(S95C5*)(S95C4*)(S95C3*), 0, "S95C2");
    check_base_class_offset(lv, (S95C5*)(S95C4*)(S95C3*), 0, "S95C2");
    check_base_class_offset(lv, (S95C4*)(S95C3*), 0, "S95C2");
    check_base_class_offset(lv, (S95C3*), 0, "S95C2");
    check_field_offset(lv, s95c2f0, ABISELECT(384,284), "S95C2.s95c2f0");
    check_field_offset(lv, s95c2f1, ABISELECT(416,300), "S95C2.s95c2f1");
    check_field_offset(lv, s95c2f2, ABISELECT(432,312), "S95C2.s95c2f2");
    check_field_offset(lv, s95c2f3, ABISELECT(448,320), "S95C2.s95c2f3");
    check_field_offset(lv, s95c2f4, ABISELECT(456,328), "S95C2.s95c2f4");
    check_field_offset(lv, s95c2f5, ABISELECT(464,332), "S95C2.s95c2f5");
    check_field_offset(lv, s95c2f6, ABISELECT(472,336), "S95C2.s95c2f6");
    check_field_offset(lv, s95c2f7, ABISELECT(488,348), "S95C2.s95c2f7");
    check_field_offset(lv, s95c2f8, ABISELECT(504,360), "S95C2.s95c2f8");
    check_field_offset(lv, s95c2f9, ABISELECT(520,372), "S95C2.s95c2f9");
    check_field_offset(lv, s95c2f10, ABISELECT(528,376), "S95C2.s95c2f10");
    check_field_offset(lv, s95c2f11, ABISELECT(544,388), "S95C2.s95c2f11");
    check_field_offset(lv, s95c2f12, ABISELECT(560,400), "S95C2.s95c2f12");
    check_field_offset(lv, s95c2f13, ABISELECT(576,412), "S95C2.s95c2f13");
    check_field_offset(lv, s95c2f14, ABISELECT(592,424), "S95C2.s95c2f14");
    check_field_offset(lv, s95c2f15, ABISELECT(608,436), "S95C2.s95c2f15");
    check_field_offset(lv, s95c2f16, ABISELECT(624,448), "S95C2.s95c2f16");
    check_field_offset(lv, s95c2f17, ABISELECT(640,460), "S95C2.s95c2f17");
    check_field_offset(lv, s95c2f18, ABISELECT(716,536), "S95C2.s95c2f18");
    check_field_offset(lv, s95c2f19, ABISELECT(724,544), "S95C2.s95c2f19");
    set_bf_and_test(lv, s95c2f20, ABISELECT(728,548), 0, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f21, ABISELECT(728,548), 1, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f22, ABISELECT(728,548), 2, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f23, ABISELECT(728,548), 3, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f24, ABISELECT(728,548), 4, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f25, ABISELECT(728,548), 5, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f26, ABISELECT(728,548), 6, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f27, ABISELECT(728,548), 7, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f28, ABISELECT(729,549), 0, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f29, ABISELECT(729,549), 1, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f30, ABISELECT(729,549), 2, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f31, ABISELECT(729,549), 3, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f32, ABISELECT(729,549), 4, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f33, ABISELECT(729,549), 5, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f34, ABISELECT(729,549), 6, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f35, ABISELECT(729,549), 7, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f36, ABISELECT(730,550), 0, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f37, ABISELECT(730,550), 1, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f38, ABISELECT(730,550), 2, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f39, ABISELECT(730,550), 3, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f40, ABISELECT(730,550), 4, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f41, ABISELECT(730,550), 5, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f42, ABISELECT(730,550), 6, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f43, ABISELECT(730,550), 7, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f44, ABISELECT(731,551), 0, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f45, ABISELECT(731,551), 1, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f46, ABISELECT(731,551), 2, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f47, ABISELECT(731,551), 3, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f48, ABISELECT(731,551), 4, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f49, ABISELECT(731,551), 5, 1, 1, "S95C2");
    set_bf_and_test(lv, s95c2f50, ABISELECT(731,551), 6, 1, 1, "S95C2");
    check_field_offset(lv, s95c2f51, ABISELECT(732,552), "S95C2.s95c2f51");
    check_field_offset(lv, s95c2f52, ABISELECT(744,564), "S95C2.s95c2f52");
    check_field_offset(lv, s95c2f53, ABISELECT(756,576), "S95C2.s95c2f53");
    check_field_offset(lv, s95c2f54, ABISELECT(768,588), "S95C2.s95c2f54");
    check_field_offset(lv, s95c2f55, ABISELECT(776,592), "S95C2.s95c2f55");
    check_field_offset(lv, s95c2f56, ABISELECT(784,596), "S95C2.s95c2f56");
    check_field_offset(lv, s95c2f57, ABISELECT(792,600), "S95C2.s95c2f57");
    check_field_offset(lv, s95c2f58, ABISELECT(808,612), "S95C2.s95c2f58");
    check_field_offset(lv, s95c2f59, ABISELECT(824,624), "S95C2.s95c2f59");
    check_field_offset(lv, s95c2f60, ABISELECT(840,636), "S95C2.s95c2f60");
    check_field_offset(lv, s95c2f61, ABISELECT(848,644), "S95C2.s95c2f61");
    check_field_offset(lv, s95c2f62, ABISELECT(864,656), "S95C2.s95c2f62");
    check_field_offset(lv, s95c2f63, ABISELECT(872,660), "S95C2.s95c2f63");
    check_field_offset(lv, s95c2f64, ABISELECT(888,672), "S95C2.s95c2f64");
    check_field_offset(lv, s95c2f65, ABISELECT(904,684), "S95C2.s95c2f65");
    check_field_offset(lv, s95c2f66, ABISELECT(920,696), "S95C2.s95c2f66");
    check_field_offset(lv, s95c2f67, ABISELECT(924,700), "S95C2.s95c2f67");
    check_field_offset(lv, s95c2f68, ABISELECT(925,701), "S95C2.s95c2f68");
    check_field_offset(lv, s95c2f69, ABISELECT(928,704), "S95C2.s95c2f69");
    check_field_offset(lv, s95c2f70, ABISELECT(936,712), "S95C2.s95c2f70");
    check_field_offset(lv, s95c2f71, ABISELECT(944,716), "S95C2.s95c2f71");
    check_field_offset(lv, s95c2f72, ABISELECT(976,748), "S95C2.s95c2f72");
    check_field_offset(lv, s95c2f73, ABISELECT(988,760), "S95C2.s95c2f73");
    check_field_offset(lv, s95c2f74, ABISELECT(1000,772), "S95C2.s95c2f74");
    check_field_offset(lv, s95c2f75, ABISELECT(1012,784), "S95C2.s95c2f75");
    check_field_offset(lv, s95c2f76, ABISELECT(1016,788), "S95C2.s95c2f76");
    check_field_offset(lv, s95c2f77, ABISELECT(1020,792), "S95C2.s95c2f77");
    check_field_offset(lv, s95c2f78, ABISELECT(1024,796), "S95C2.s95c2f78");
    test_class_info(&lv, &cd_S95C2);
    dp->~S95C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C2(Test_S95C2, "S95C2", ABISELECT(1040,804));

#else // __cplusplus

extern void _ZN5S95C2C1Ev();
extern void _ZN5S95C2D1Ev();
Name_Map name_map_S95C2[] = {
  NSPAIR(_ZN5S95C2C1Ev),
  NSPAIR(_ZN5S95C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
extern Class_Descriptor cd_S95C6;
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
extern Class_Descriptor cd_S95C5;
extern VTBL_ENTRY _ZTI5S95C5[];
extern  VTBL_ENTRY _ZTV5S95C5[];
extern Class_Descriptor cd_S95C4;
extern VTBL_ENTRY _ZTI5S95C4[];
extern  VTBL_ENTRY _ZTV5S95C4[];
extern Class_Descriptor cd_S95C3;
extern VTBL_ENTRY _ZTI5S95C3[];
extern  VTBL_ENTRY _ZTV5S95C3[];
static Base_Class bases_S95C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S95C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S95C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S95C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C2[];
extern void _ZN5S95C2D1Ev();
extern void _ZN5S95C2D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
extern void _ZN5S95C53v74Ev();
extern void _ZN5S95C53v75Ev();
extern void _ZN5S95C53v76Ev();
extern void _ZN5S95C53v77Ev();
extern void _ZN5S95C53v78Ev();
extern void _ZN5S95C53v79Ev();
extern void _ZN5S95C53v80Ev();
extern void _ZN5S95C53v81Ev();
extern void _ZN5S95C53v82Ev();
extern void _ZN5S95C53v83Ev();
extern void _ZN5S95C53v84Ev();
extern void _ZN5S95C53v85Ev();
extern void _ZN5S95C53v86Ev();
extern void _ZN5S95C53v87Ev();
extern void _ZN5S95C53v88Ev();
extern void _ZN5S95C53v89Ev();
extern void _ZN5S95C53v90Ev();
extern void _ZN5S95C53v91Ev();
extern void _ZN5S95C53v92Ev();
extern void _ZN5S95C53v93Ev();
extern void _ZN5S95C53v94Ev();
extern void _ZN5S95C53v95Ev();
extern void _ZN5S95C43v96Ev();
extern void _ZN5S95C43v97Ev();
extern void _ZN5S95C43v98Ev();
extern void _ZN5S95C43v99Ev();
extern void _ZN5S95C44v100Ev();
extern void _ZN5S95C44v101Ev();
extern void _ZN5S95C44v102Ev();
extern void _ZN5S95C44v103Ev();
extern void _ZN5S95C44v104Ev();
extern void _ZN5S95C44v105Ev();
extern void _ZN5S95C44v106Ev();
extern void _ZN5S95C44v107Ev();
extern void _ZN5S95C44v108Ev();
extern void _ZN5S95C44v109Ev();
extern void _ZN5S95C44v110Ev();
extern void _ZN5S95C44v111Ev();
extern void _ZN5S95C44v112Ev();
extern void _ZN5S95C44v113Ev();
extern void _ZN5S95C44v114Ev();
extern void _ZN5S95C44v115Ev();
extern void _ZN5S95C44v116Ev();
extern void _ZN5S95C44v117Ev();
extern void _ZN5S95C44v118Ev();
extern void _ZN5S95C44v119Ev();
extern void _ZN5S95C44v120Ev();
extern void _ZN5S95C44v121Ev();
extern void _ZN5S95C44v122Ev();
extern void _ZN5S95C44v123Ev();
extern void _ZN5S95C44v124Ev();
extern void _ZN5S95C44v125Ev();
extern void _ZN5S95C44v126Ev();
extern void _ZN5S95C44v127Ev();
extern void _ZN5S95C44v128Ev();
extern void _ZN5S95C44v129Ev();
extern void _ZN5S95C44v130Ev();
extern void _ZN5S95C44v131Ev();
extern void _ZN5S95C44v132Ev();
extern void _ZN5S95C44v133Ev();
extern void _ZN5S95C44v134Ev();
extern void _ZN5S95C44v135Ev();
extern void _ZN5S95C44v136Ev();
extern void _ZN5S95C44v137Ev();
extern void _ZN5S95C44v138Ev();
extern void _ZN5S95C44v139Ev();
extern void _ZN5S95C44v140Ev();
extern void _ZN5S95C44v141Ev();
extern void _ZN5S95C44v142Ev();
extern void _ZN5S95C44v143Ev();
extern void _ZN5S95C44v144Ev();
extern void _ZN5S95C44v145Ev();
extern void _ZN5S95C44v146Ev();
extern void _ZN5S95C44v147Ev();
extern void _ZN5S95C44v148Ev();
extern void _ZN5S95C44v149Ev();
extern void _ZN5S95C44v150Ev();
extern void _ZN5S95C44v151Ev();
extern void _ZN5S95C44v152Ev();
extern void _ZN5S95C44v153Ev();
extern void _ZN5S95C44v154Ev();
extern void _ZN5S95C44v155Ev();
extern void _ZN5S95C44v156Ev();
extern void _ZN5S95C34v157Ev();
extern void _ZN5S95C34v158Ev();
extern void _ZN5S95C34v159Ev();
extern void _ZN5S95C34v160Ev();
extern void _ZN5S95C24v161Ev();
extern void _ZN5S95C24v162Ev();
extern void _ZN5S95C24v163Ev();
extern void _ZN5S95C24v164Ev();
extern void _ZN5S95C24v165Ev();
extern void _ZN5S95C24v166Ev();
extern void _ZN5S95C24v167Ev();
extern void _ZN5S95C24v168Ev();
extern void _ZN5S95C24v169Ev();
extern void _ZN5S95C24v170Ev();
extern void _ZN5S95C24v171Ev();
extern void _ZN5S95C24v172Ev();
extern void _ZN5S95C24v173Ev();
extern void _ZN5S95C24v174Ev();
extern void _ZN5S95C24v175Ev();
extern void _ZN5S95C24v176Ev();
extern void _ZN5S95C24v177Ev();
extern void _ZN5S95C24v178Ev();
extern void _ZN5S95C24v179Ev();
extern void _ZN5S95C24v180Ev();
extern void _ZN5S95C24v181Ev();
extern void _ZN5S95C24v182Ev();
extern void _ZN5S95C24v183Ev();
extern void _ZN5S95C24v184Ev();
extern void _ZN5S95C24v185Ev();
extern void _ZN5S95C24v186Ev();
extern void _ZN5S95C24v187Ev();
extern void _ZN5S95C24v188Ev();
extern void _ZN5S95C24v189Ev();
extern void _ZN5S95C24v190Ev();
extern void _ZN5S95C24v191Ev();
extern void _ZN5S95C24v192Ev();
extern void _ZN5S95C24v193Ev();
extern void _ZN5S95C24v194Ev();
extern void _ZN5S95C24v195Ev();
extern void _ZN5S95C24v196Ev();
extern void _ZN5S95C24v197Ev();
extern void _ZN5S95C24v198Ev();
extern void _ZN5S95C24v199Ev();
extern void _ZN5S95C24v200Ev();
extern void _ZN5S95C24v201Ev();
extern void _ZN5S95C24v202Ev();
extern void _ZN5S95C24v203Ev();
extern void _ZN5S95C24v204Ev();
extern void _ZN5S95C24v205Ev();
extern void _ZN5S95C24v206Ev();
extern void _ZN5S95C24v207Ev();
static  VTBL_ENTRY vtc_S95C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C2[0]),
  (VTBL_ENTRY)&_ZN5S95C2D1Ev,
  (VTBL_ENTRY)&_ZN5S95C2D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
  (VTBL_ENTRY)&_ZN5S95C53v74Ev,
  (VTBL_ENTRY)&_ZN5S95C53v75Ev,
  (VTBL_ENTRY)&_ZN5S95C53v76Ev,
  (VTBL_ENTRY)&_ZN5S95C53v77Ev,
  (VTBL_ENTRY)&_ZN5S95C53v78Ev,
  (VTBL_ENTRY)&_ZN5S95C53v79Ev,
  (VTBL_ENTRY)&_ZN5S95C53v80Ev,
  (VTBL_ENTRY)&_ZN5S95C53v81Ev,
  (VTBL_ENTRY)&_ZN5S95C53v82Ev,
  (VTBL_ENTRY)&_ZN5S95C53v83Ev,
  (VTBL_ENTRY)&_ZN5S95C53v84Ev,
  (VTBL_ENTRY)&_ZN5S95C53v85Ev,
  (VTBL_ENTRY)&_ZN5S95C53v86Ev,
  (VTBL_ENTRY)&_ZN5S95C53v87Ev,
  (VTBL_ENTRY)&_ZN5S95C53v88Ev,
  (VTBL_ENTRY)&_ZN5S95C53v89Ev,
  (VTBL_ENTRY)&_ZN5S95C53v90Ev,
  (VTBL_ENTRY)&_ZN5S95C53v91Ev,
  (VTBL_ENTRY)&_ZN5S95C53v92Ev,
  (VTBL_ENTRY)&_ZN5S95C53v93Ev,
  (VTBL_ENTRY)&_ZN5S95C53v94Ev,
  (VTBL_ENTRY)&_ZN5S95C53v95Ev,
  (VTBL_ENTRY)&_ZN5S95C43v96Ev,
  (VTBL_ENTRY)&_ZN5S95C43v97Ev,
  (VTBL_ENTRY)&_ZN5S95C43v98Ev,
  (VTBL_ENTRY)&_ZN5S95C43v99Ev,
  (VTBL_ENTRY)&_ZN5S95C44v100Ev,
  (VTBL_ENTRY)&_ZN5S95C44v101Ev,
  (VTBL_ENTRY)&_ZN5S95C44v102Ev,
  (VTBL_ENTRY)&_ZN5S95C44v103Ev,
  (VTBL_ENTRY)&_ZN5S95C44v104Ev,
  (VTBL_ENTRY)&_ZN5S95C44v105Ev,
  (VTBL_ENTRY)&_ZN5S95C44v106Ev,
  (VTBL_ENTRY)&_ZN5S95C44v107Ev,
  (VTBL_ENTRY)&_ZN5S95C44v108Ev,
  (VTBL_ENTRY)&_ZN5S95C44v109Ev,
  (VTBL_ENTRY)&_ZN5S95C44v110Ev,
  (VTBL_ENTRY)&_ZN5S95C44v111Ev,
  (VTBL_ENTRY)&_ZN5S95C44v112Ev,
  (VTBL_ENTRY)&_ZN5S95C44v113Ev,
  (VTBL_ENTRY)&_ZN5S95C44v114Ev,
  (VTBL_ENTRY)&_ZN5S95C44v115Ev,
  (VTBL_ENTRY)&_ZN5S95C44v116Ev,
  (VTBL_ENTRY)&_ZN5S95C44v117Ev,
  (VTBL_ENTRY)&_ZN5S95C44v118Ev,
  (VTBL_ENTRY)&_ZN5S95C44v119Ev,
  (VTBL_ENTRY)&_ZN5S95C44v120Ev,
  (VTBL_ENTRY)&_ZN5S95C44v121Ev,
  (VTBL_ENTRY)&_ZN5S95C44v122Ev,
  (VTBL_ENTRY)&_ZN5S95C44v123Ev,
  (VTBL_ENTRY)&_ZN5S95C44v124Ev,
  (VTBL_ENTRY)&_ZN5S95C44v125Ev,
  (VTBL_ENTRY)&_ZN5S95C44v126Ev,
  (VTBL_ENTRY)&_ZN5S95C44v127Ev,
  (VTBL_ENTRY)&_ZN5S95C44v128Ev,
  (VTBL_ENTRY)&_ZN5S95C44v129Ev,
  (VTBL_ENTRY)&_ZN5S95C44v130Ev,
  (VTBL_ENTRY)&_ZN5S95C44v131Ev,
  (VTBL_ENTRY)&_ZN5S95C44v132Ev,
  (VTBL_ENTRY)&_ZN5S95C44v133Ev,
  (VTBL_ENTRY)&_ZN5S95C44v134Ev,
  (VTBL_ENTRY)&_ZN5S95C44v135Ev,
  (VTBL_ENTRY)&_ZN5S95C44v136Ev,
  (VTBL_ENTRY)&_ZN5S95C44v137Ev,
  (VTBL_ENTRY)&_ZN5S95C44v138Ev,
  (VTBL_ENTRY)&_ZN5S95C44v139Ev,
  (VTBL_ENTRY)&_ZN5S95C44v140Ev,
  (VTBL_ENTRY)&_ZN5S95C44v141Ev,
  (VTBL_ENTRY)&_ZN5S95C44v142Ev,
  (VTBL_ENTRY)&_ZN5S95C44v143Ev,
  (VTBL_ENTRY)&_ZN5S95C44v144Ev,
  (VTBL_ENTRY)&_ZN5S95C44v145Ev,
  (VTBL_ENTRY)&_ZN5S95C44v146Ev,
  (VTBL_ENTRY)&_ZN5S95C44v147Ev,
  (VTBL_ENTRY)&_ZN5S95C44v148Ev,
  (VTBL_ENTRY)&_ZN5S95C44v149Ev,
  (VTBL_ENTRY)&_ZN5S95C44v150Ev,
  (VTBL_ENTRY)&_ZN5S95C44v151Ev,
  (VTBL_ENTRY)&_ZN5S95C44v152Ev,
  (VTBL_ENTRY)&_ZN5S95C44v153Ev,
  (VTBL_ENTRY)&_ZN5S95C44v154Ev,
  (VTBL_ENTRY)&_ZN5S95C44v155Ev,
  (VTBL_ENTRY)&_ZN5S95C44v156Ev,
  (VTBL_ENTRY)&_ZN5S95C34v157Ev,
  (VTBL_ENTRY)&_ZN5S95C34v158Ev,
  (VTBL_ENTRY)&_ZN5S95C34v159Ev,
  (VTBL_ENTRY)&_ZN5S95C34v160Ev,
  (VTBL_ENTRY)&_ZN5S95C24v161Ev,
  (VTBL_ENTRY)&_ZN5S95C24v162Ev,
  (VTBL_ENTRY)&_ZN5S95C24v163Ev,
  (VTBL_ENTRY)&_ZN5S95C24v164Ev,
  (VTBL_ENTRY)&_ZN5S95C24v165Ev,
  (VTBL_ENTRY)&_ZN5S95C24v166Ev,
  (VTBL_ENTRY)&_ZN5S95C24v167Ev,
  (VTBL_ENTRY)&_ZN5S95C24v168Ev,
  (VTBL_ENTRY)&_ZN5S95C24v169Ev,
  (VTBL_ENTRY)&_ZN5S95C24v170Ev,
  (VTBL_ENTRY)&_ZN5S95C24v171Ev,
  (VTBL_ENTRY)&_ZN5S95C24v172Ev,
  (VTBL_ENTRY)&_ZN5S95C24v173Ev,
  (VTBL_ENTRY)&_ZN5S95C24v174Ev,
  (VTBL_ENTRY)&_ZN5S95C24v175Ev,
  (VTBL_ENTRY)&_ZN5S95C24v176Ev,
  (VTBL_ENTRY)&_ZN5S95C24v177Ev,
  (VTBL_ENTRY)&_ZN5S95C24v178Ev,
  (VTBL_ENTRY)&_ZN5S95C24v179Ev,
  (VTBL_ENTRY)&_ZN5S95C24v180Ev,
  (VTBL_ENTRY)&_ZN5S95C24v181Ev,
  (VTBL_ENTRY)&_ZN5S95C24v182Ev,
  (VTBL_ENTRY)&_ZN5S95C24v183Ev,
  (VTBL_ENTRY)&_ZN5S95C24v184Ev,
  (VTBL_ENTRY)&_ZN5S95C24v185Ev,
  (VTBL_ENTRY)&_ZN5S95C24v186Ev,
  (VTBL_ENTRY)&_ZN5S95C24v187Ev,
  (VTBL_ENTRY)&_ZN5S95C24v188Ev,
  (VTBL_ENTRY)&_ZN5S95C24v189Ev,
  (VTBL_ENTRY)&_ZN5S95C24v190Ev,
  (VTBL_ENTRY)&_ZN5S95C24v191Ev,
  (VTBL_ENTRY)&_ZN5S95C24v192Ev,
  (VTBL_ENTRY)&_ZN5S95C24v193Ev,
  (VTBL_ENTRY)&_ZN5S95C24v194Ev,
  (VTBL_ENTRY)&_ZN5S95C24v195Ev,
  (VTBL_ENTRY)&_ZN5S95C24v196Ev,
  (VTBL_ENTRY)&_ZN5S95C24v197Ev,
  (VTBL_ENTRY)&_ZN5S95C24v198Ev,
  (VTBL_ENTRY)&_ZN5S95C24v199Ev,
  (VTBL_ENTRY)&_ZN5S95C24v200Ev,
  (VTBL_ENTRY)&_ZN5S95C24v201Ev,
  (VTBL_ENTRY)&_ZN5S95C24v202Ev,
  (VTBL_ENTRY)&_ZN5S95C24v203Ev,
  (VTBL_ENTRY)&_ZN5S95C24v204Ev,
  (VTBL_ENTRY)&_ZN5S95C24v205Ev,
  (VTBL_ENTRY)&_ZN5S95C24v206Ev,
  (VTBL_ENTRY)&_ZN5S95C24v207Ev,
};
extern VTBL_ENTRY _ZTI5S95C2[];
extern  VTBL_ENTRY _ZTV5S95C2[];
Class_Descriptor cd_S95C2 = {  "S95C2", // class name
  bases_S95C2, 5,
  &(vtc_S95C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,804), // object size
  NSPAIRA(_ZTI5S95C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C2),207, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S95C1  : S95C2 {
  int s95c1f0;
  unsigned int s95c1f1:1;
  int s95c1f2;
  virtual  ~S95C1(); // _ZN5S95C1D1Ev
  virtual void  v1(); // _ZN5S95C12v1Ev
  virtual void  v2(); // _ZN5S95C12v2Ev
  virtual void  v3(); // _ZN5S95C12v3Ev
  virtual void  v4(); // _ZN5S95C12v4Ev
  S95C1(); // tgen
};
//SIG(1 S95C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC8} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC9{ m Fi} Fi FC10{ m} Fi FC11{ BC12{ m Fp Fi[2]}} Fi Fp[2] FC13{ m FC14{ m Fi[3]} FC14 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC10 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC15{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC12}} Fp[2] Fc FC10 FC14 FC14 Fi FC14 Fi:1 Fi:1 Fi:1 Fi[3]} vd v157 v158 v159 v160 FC16} vd v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fp[4] FC11 Fp[2] Fi[2] Fp FC15 FC18{ BC12} FC18 FC19{ BC12} Fp FC20{ BC21{ BC12}} FC20 FC20 FC22{ BC23{ BC12}} FC22 FC24{ BC25{ BC12}} FC24 Fi[19] FC8 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14 FC14 FC14 Fi Fp Fi FC26{ BC12} FC26 FC21 Fi[2] FC21 Fi FC26 FC26 FC21 Fi Fc FC15 Fi[2] Fp FC27{ m FC28{ m Fi[4]} FC14 Fi} FC14 FC14 FC14 Fc[4] Fi Fc[2] Fp[2]} vd v1 v2 v3 v4 Fi Fi:1 Fi}


 S95C1 ::~S95C1(){ note_dtor("S95C1", this);}
void  S95C1 ::v1(){vfunc_called(this, "_ZN5S95C12v1Ev");}
void  S95C1 ::v2(){vfunc_called(this, "_ZN5S95C12v2Ev");}
void  S95C1 ::v3(){vfunc_called(this, "_ZN5S95C12v3Ev");}
void  S95C1 ::v4(){vfunc_called(this, "_ZN5S95C12v4Ev");}
S95C1 ::S95C1(){ note_ctor("S95C1", this);} // tgen

static void Test_S95C1()
{
  extern Class_Descriptor cd_S95C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(133,205)];
    init_test(&cd_S95C1, buf);
    S95C1 *dp, &lv = *(dp=new (buf) S95C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1056,816), "sizeof(S95C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S95C1)");
    check_base_class_offset(lv, (S95C7_nt*)(S95C6*)(S95C5*)(S95C4*)(S95C3*)(S95C2*), 0, "S95C1");
    check_base_class_offset(lv, (S95C6*)(S95C5*)(S95C4*)(S95C3*)(S95C2*), 0, "S95C1");
    check_base_class_offset(lv, (S95C5*)(S95C4*)(S95C3*)(S95C2*), 0, "S95C1");
    check_base_class_offset(lv, (S95C4*)(S95C3*)(S95C2*), 0, "S95C1");
    check_base_class_offset(lv, (S95C3*)(S95C2*), 0, "S95C1");
    check_base_class_offset(lv, (S95C2*), 0, "S95C1");
    check_field_offset(lv, s95c1f0, ABISELECT(1040,804), "S95C1.s95c1f0");
    set_bf_and_test(lv, s95c1f1, ABISELECT(1044,808), 0, 1, 1, "S95C1");
    check_field_offset(lv, s95c1f2, ABISELECT(1048,812), "S95C1.s95c1f2");
    test_class_info(&lv, &cd_S95C1);
    dp->~S95C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS95C1(Test_S95C1, "S95C1", ABISELECT(1056,816));

#else // __cplusplus

extern void _ZN5S95C1C1Ev();
extern void _ZN5S95C1D1Ev();
Name_Map name_map_S95C1[] = {
  NSPAIR(_ZN5S95C1C1Ev),
  NSPAIR(_ZN5S95C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S95C7_nt;
extern VTBL_ENTRY _ZTI8S95C7_nt[];
extern  VTBL_ENTRY _ZTV8S95C7_nt[];
extern Class_Descriptor cd_S95C6;
extern VTBL_ENTRY _ZTI5S95C6[];
extern  VTBL_ENTRY _ZTV5S95C6[];
extern Class_Descriptor cd_S95C5;
extern VTBL_ENTRY _ZTI5S95C5[];
extern  VTBL_ENTRY _ZTV5S95C5[];
extern Class_Descriptor cd_S95C4;
extern VTBL_ENTRY _ZTI5S95C4[];
extern  VTBL_ENTRY _ZTV5S95C4[];
extern Class_Descriptor cd_S95C3;
extern VTBL_ENTRY _ZTI5S95C3[];
extern  VTBL_ENTRY _ZTV5S95C3[];
extern Class_Descriptor cd_S95C2;
extern VTBL_ENTRY _ZTI5S95C2[];
extern  VTBL_ENTRY _ZTV5S95C2[];
static Base_Class bases_S95C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S95C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S95C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S95C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S95C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S95C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S95C1[];
extern void _ZN5S95C1D1Ev();
extern void _ZN5S95C1D0Ev();
extern void _ZN8S95C7_nt2v5Ev();
extern void _ZN8S95C7_nt2v6Ev();
extern void _ZN8S95C7_nt2v7Ev();
extern void _ZN8S95C7_nt2v8Ev();
extern void _ZN8S95C7_nt2v9Ev();
extern void _ZN8S95C7_nt3v10Ev();
extern void _ZN8S95C7_nt3v11Ev();
extern void _ZN8S95C7_nt3v12Ev();
extern void _ZN8S95C7_nt3v13Ev();
extern void _ZN8S95C7_nt3v14Ev();
extern void _ZN8S95C7_nt3v15Ev();
extern void _ZN8S95C7_nt3v16Ev();
extern void _ZN8S95C7_nt3v17Ev();
extern void _ZN8S95C7_nt3v18Ev();
extern void _ZN8S95C7_nt3v19Ev();
extern void _ZN8S95C7_nt3v20Ev();
extern void _ZN8S95C7_nt3v21Ev();
extern void _ZN8S95C7_nt3v22Ev();
extern void _ZN8S95C7_nt3v23Ev();
extern void _ZN8S95C7_nt3v24Ev();
extern void _ZN8S95C7_nt3v25Ev();
extern void _ZN8S95C7_nt3v26Ev();
extern void _ZN8S95C7_nt3v27Ev();
extern void _ZN8S95C7_nt3v28Ev();
extern void _ZN8S95C7_nt3v29Ev();
extern void _ZN8S95C7_nt3v30Ev();
extern void _ZN8S95C7_nt3v31Ev();
extern void _ZN8S95C7_nt3v32Ev();
extern void _ZN8S95C7_nt3v33Ev();
extern void _ZN8S95C7_nt3v34Ev();
extern void _ZN8S95C7_nt3v35Ev();
extern void _ZN8S95C7_nt3v36Ev();
extern void _ZN8S95C7_nt3v37Ev();
extern void _ZN8S95C7_nt3v38Ev();
extern void _ZN8S95C7_nt3v39Ev();
extern void _ZN8S95C7_nt3v40Ev();
extern void _ZN8S95C7_nt3v41Ev();
extern void _ZN8S95C7_nt3v42Ev();
extern void _ZN8S95C7_nt3v43Ev();
extern void _ZN8S95C7_nt3v44Ev();
extern void _ZN8S95C7_nt3v45Ev();
extern void _ZN8S95C7_nt3v46Ev();
extern void _ZN8S95C7_nt3v47Ev();
extern void _ZN8S95C7_nt3v48Ev();
extern void _ZN8S95C7_nt3v49Ev();
extern void _ZN8S95C7_nt3v50Ev();
extern void _ZN8S95C7_nt3v51Ev();
extern void _ZN8S95C7_nt3v52Ev();
extern void _ZN8S95C7_nt3v53Ev();
extern void _ZN8S95C7_nt3v54Ev();
extern void _ZN8S95C7_nt3v55Ev();
extern void _ZN8S95C7_nt3v56Ev();
extern void _ZN8S95C7_nt3v57Ev();
extern void _ZN8S95C7_nt3v58Ev();
extern void _ZN8S95C7_nt3v59Ev();
extern void _ZN8S95C7_nt3v60Ev();
extern void _ZN8S95C7_nt3v61Ev();
extern void _ZN8S95C7_nt3v62Ev();
extern void _ZN8S95C7_nt3v63Ev();
extern void _ZN8S95C7_nt3v64Ev();
extern void _ZN8S95C7_nt3v65Ev();
extern void _ZN8S95C7_nt3v66Ev();
extern void _ZN8S95C7_nt3v67Ev();
extern void _ZN8S95C7_nt3v68Ev();
extern void _ZN5S95C63v69Ev();
extern void _ZN5S95C63v70Ev();
extern void _ZN5S95C63v71Ev();
extern void _ZN5S95C63v72Ev();
extern void _ZN5S95C63v73Ev();
extern void _ZN5S95C53v74Ev();
extern void _ZN5S95C53v75Ev();
extern void _ZN5S95C53v76Ev();
extern void _ZN5S95C53v77Ev();
extern void _ZN5S95C53v78Ev();
extern void _ZN5S95C53v79Ev();
extern void _ZN5S95C53v80Ev();
extern void _ZN5S95C53v81Ev();
extern void _ZN5S95C53v82Ev();
extern void _ZN5S95C53v83Ev();
extern void _ZN5S95C53v84Ev();
extern void _ZN5S95C53v85Ev();
extern void _ZN5S95C53v86Ev();
extern void _ZN5S95C53v87Ev();
extern void _ZN5S95C53v88Ev();
extern void _ZN5S95C53v89Ev();
extern void _ZN5S95C53v90Ev();
extern void _ZN5S95C53v91Ev();
extern void _ZN5S95C53v92Ev();
extern void _ZN5S95C53v93Ev();
extern void _ZN5S95C53v94Ev();
extern void _ZN5S95C53v95Ev();
extern void _ZN5S95C43v96Ev();
extern void _ZN5S95C43v97Ev();
extern void _ZN5S95C43v98Ev();
extern void _ZN5S95C43v99Ev();
extern void _ZN5S95C44v100Ev();
extern void _ZN5S95C44v101Ev();
extern void _ZN5S95C44v102Ev();
extern void _ZN5S95C44v103Ev();
extern void _ZN5S95C44v104Ev();
extern void _ZN5S95C44v105Ev();
extern void _ZN5S95C44v106Ev();
extern void _ZN5S95C44v107Ev();
extern void _ZN5S95C44v108Ev();
extern void _ZN5S95C44v109Ev();
extern void _ZN5S95C44v110Ev();
extern void _ZN5S95C44v111Ev();
extern void _ZN5S95C44v112Ev();
extern void _ZN5S95C44v113Ev();
extern void _ZN5S95C44v114Ev();
extern void _ZN5S95C44v115Ev();
extern void _ZN5S95C44v116Ev();
extern void _ZN5S95C44v117Ev();
extern void _ZN5S95C44v118Ev();
extern void _ZN5S95C44v119Ev();
extern void _ZN5S95C44v120Ev();
extern void _ZN5S95C44v121Ev();
extern void _ZN5S95C44v122Ev();
extern void _ZN5S95C44v123Ev();
extern void _ZN5S95C44v124Ev();
extern void _ZN5S95C44v125Ev();
extern void _ZN5S95C44v126Ev();
extern void _ZN5S95C44v127Ev();
extern void _ZN5S95C44v128Ev();
extern void _ZN5S95C44v129Ev();
extern void _ZN5S95C44v130Ev();
extern void _ZN5S95C44v131Ev();
extern void _ZN5S95C44v132Ev();
extern void _ZN5S95C44v133Ev();
extern void _ZN5S95C44v134Ev();
extern void _ZN5S95C44v135Ev();
extern void _ZN5S95C44v136Ev();
extern void _ZN5S95C44v137Ev();
extern void _ZN5S95C44v138Ev();
extern void _ZN5S95C44v139Ev();
extern void _ZN5S95C44v140Ev();
extern void _ZN5S95C44v141Ev();
extern void _ZN5S95C44v142Ev();
extern void _ZN5S95C44v143Ev();
extern void _ZN5S95C44v144Ev();
extern void _ZN5S95C44v145Ev();
extern void _ZN5S95C44v146Ev();
extern void _ZN5S95C44v147Ev();
extern void _ZN5S95C44v148Ev();
extern void _ZN5S95C44v149Ev();
extern void _ZN5S95C44v150Ev();
extern void _ZN5S95C44v151Ev();
extern void _ZN5S95C44v152Ev();
extern void _ZN5S95C44v153Ev();
extern void _ZN5S95C44v154Ev();
extern void _ZN5S95C44v155Ev();
extern void _ZN5S95C44v156Ev();
extern void _ZN5S95C34v157Ev();
extern void _ZN5S95C34v158Ev();
extern void _ZN5S95C34v159Ev();
extern void _ZN5S95C34v160Ev();
extern void _ZN5S95C24v161Ev();
extern void _ZN5S95C24v162Ev();
extern void _ZN5S95C24v163Ev();
extern void _ZN5S95C24v164Ev();
extern void _ZN5S95C24v165Ev();
extern void _ZN5S95C24v166Ev();
extern void _ZN5S95C24v167Ev();
extern void _ZN5S95C24v168Ev();
extern void _ZN5S95C24v169Ev();
extern void _ZN5S95C24v170Ev();
extern void _ZN5S95C24v171Ev();
extern void _ZN5S95C24v172Ev();
extern void _ZN5S95C24v173Ev();
extern void _ZN5S95C24v174Ev();
extern void _ZN5S95C24v175Ev();
extern void _ZN5S95C24v176Ev();
extern void _ZN5S95C24v177Ev();
extern void _ZN5S95C24v178Ev();
extern void _ZN5S95C24v179Ev();
extern void _ZN5S95C24v180Ev();
extern void _ZN5S95C24v181Ev();
extern void _ZN5S95C24v182Ev();
extern void _ZN5S95C24v183Ev();
extern void _ZN5S95C24v184Ev();
extern void _ZN5S95C24v185Ev();
extern void _ZN5S95C24v186Ev();
extern void _ZN5S95C24v187Ev();
extern void _ZN5S95C24v188Ev();
extern void _ZN5S95C24v189Ev();
extern void _ZN5S95C24v190Ev();
extern void _ZN5S95C24v191Ev();
extern void _ZN5S95C24v192Ev();
extern void _ZN5S95C24v193Ev();
extern void _ZN5S95C24v194Ev();
extern void _ZN5S95C24v195Ev();
extern void _ZN5S95C24v196Ev();
extern void _ZN5S95C24v197Ev();
extern void _ZN5S95C24v198Ev();
extern void _ZN5S95C24v199Ev();
extern void _ZN5S95C24v200Ev();
extern void _ZN5S95C24v201Ev();
extern void _ZN5S95C24v202Ev();
extern void _ZN5S95C24v203Ev();
extern void _ZN5S95C24v204Ev();
extern void _ZN5S95C24v205Ev();
extern void _ZN5S95C24v206Ev();
extern void _ZN5S95C24v207Ev();
extern void _ZN5S95C12v1Ev();
extern void _ZN5S95C12v2Ev();
extern void _ZN5S95C12v3Ev();
extern void _ZN5S95C12v4Ev();
static  VTBL_ENTRY vtc_S95C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S95C1[0]),
  (VTBL_ENTRY)&_ZN5S95C1D1Ev,
  (VTBL_ENTRY)&_ZN5S95C1D0Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v5Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v6Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v7Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt2v9Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v10Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v11Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v12Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v13Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v14Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v16Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v17Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v19Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v20Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v21Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v22Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v23Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v24Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v25Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v26Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v27Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v28Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v29Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v30Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v31Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v32Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v33Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v34Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v35Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v36Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v37Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v38Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v39Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v40Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v41Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v42Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v43Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v44Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v45Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v46Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v47Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v48Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v49Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v50Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v51Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v52Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v53Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v54Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v55Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v56Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v57Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v58Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v59Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v60Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v61Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v62Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v63Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v64Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v65Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v66Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v67Ev,
  (VTBL_ENTRY)&_ZN8S95C7_nt3v68Ev,
  (VTBL_ENTRY)&_ZN5S95C63v69Ev,
  (VTBL_ENTRY)&_ZN5S95C63v70Ev,
  (VTBL_ENTRY)&_ZN5S95C63v71Ev,
  (VTBL_ENTRY)&_ZN5S95C63v72Ev,
  (VTBL_ENTRY)&_ZN5S95C63v73Ev,
  (VTBL_ENTRY)&_ZN5S95C53v74Ev,
  (VTBL_ENTRY)&_ZN5S95C53v75Ev,
  (VTBL_ENTRY)&_ZN5S95C53v76Ev,
  (VTBL_ENTRY)&_ZN5S95C53v77Ev,
  (VTBL_ENTRY)&_ZN5S95C53v78Ev,
  (VTBL_ENTRY)&_ZN5S95C53v79Ev,
  (VTBL_ENTRY)&_ZN5S95C53v80Ev,
  (VTBL_ENTRY)&_ZN5S95C53v81Ev,
  (VTBL_ENTRY)&_ZN5S95C53v82Ev,
  (VTBL_ENTRY)&_ZN5S95C53v83Ev,
  (VTBL_ENTRY)&_ZN5S95C53v84Ev,
  (VTBL_ENTRY)&_ZN5S95C53v85Ev,
  (VTBL_ENTRY)&_ZN5S95C53v86Ev,
  (VTBL_ENTRY)&_ZN5S95C53v87Ev,
  (VTBL_ENTRY)&_ZN5S95C53v88Ev,
  (VTBL_ENTRY)&_ZN5S95C53v89Ev,
  (VTBL_ENTRY)&_ZN5S95C53v90Ev,
  (VTBL_ENTRY)&_ZN5S95C53v91Ev,
  (VTBL_ENTRY)&_ZN5S95C53v92Ev,
  (VTBL_ENTRY)&_ZN5S95C53v93Ev,
  (VTBL_ENTRY)&_ZN5S95C53v94Ev,
  (VTBL_ENTRY)&_ZN5S95C53v95Ev,
  (VTBL_ENTRY)&_ZN5S95C43v96Ev,
  (VTBL_ENTRY)&_ZN5S95C43v97Ev,
  (VTBL_ENTRY)&_ZN5S95C43v98Ev,
  (VTBL_ENTRY)&_ZN5S95C43v99Ev,
  (VTBL_ENTRY)&_ZN5S95C44v100Ev,
  (VTBL_ENTRY)&_ZN5S95C44v101Ev,
  (VTBL_ENTRY)&_ZN5S95C44v102Ev,
  (VTBL_ENTRY)&_ZN5S95C44v103Ev,
  (VTBL_ENTRY)&_ZN5S95C44v104Ev,
  (VTBL_ENTRY)&_ZN5S95C44v105Ev,
  (VTBL_ENTRY)&_ZN5S95C44v106Ev,
  (VTBL_ENTRY)&_ZN5S95C44v107Ev,
  (VTBL_ENTRY)&_ZN5S95C44v108Ev,
  (VTBL_ENTRY)&_ZN5S95C44v109Ev,
  (VTBL_ENTRY)&_ZN5S95C44v110Ev,
  (VTBL_ENTRY)&_ZN5S95C44v111Ev,
  (VTBL_ENTRY)&_ZN5S95C44v112Ev,
  (VTBL_ENTRY)&_ZN5S95C44v113Ev,
  (VTBL_ENTRY)&_ZN5S95C44v114Ev,
  (VTBL_ENTRY)&_ZN5S95C44v115Ev,
  (VTBL_ENTRY)&_ZN5S95C44v116Ev,
  (VTBL_ENTRY)&_ZN5S95C44v117Ev,
  (VTBL_ENTRY)&_ZN5S95C44v118Ev,
  (VTBL_ENTRY)&_ZN5S95C44v119Ev,
  (VTBL_ENTRY)&_ZN5S95C44v120Ev,
  (VTBL_ENTRY)&_ZN5S95C44v121Ev,
  (VTBL_ENTRY)&_ZN5S95C44v122Ev,
  (VTBL_ENTRY)&_ZN5S95C44v123Ev,
  (VTBL_ENTRY)&_ZN5S95C44v124Ev,
  (VTBL_ENTRY)&_ZN5S95C44v125Ev,
  (VTBL_ENTRY)&_ZN5S95C44v126Ev,
  (VTBL_ENTRY)&_ZN5S95C44v127Ev,
  (VTBL_ENTRY)&_ZN5S95C44v128Ev,
  (VTBL_ENTRY)&_ZN5S95C44v129Ev,
  (VTBL_ENTRY)&_ZN5S95C44v130Ev,
  (VTBL_ENTRY)&_ZN5S95C44v131Ev,
  (VTBL_ENTRY)&_ZN5S95C44v132Ev,
  (VTBL_ENTRY)&_ZN5S95C44v133Ev,
  (VTBL_ENTRY)&_ZN5S95C44v134Ev,
  (VTBL_ENTRY)&_ZN5S95C44v135Ev,
  (VTBL_ENTRY)&_ZN5S95C44v136Ev,
  (VTBL_ENTRY)&_ZN5S95C44v137Ev,
  (VTBL_ENTRY)&_ZN5S95C44v138Ev,
  (VTBL_ENTRY)&_ZN5S95C44v139Ev,
  (VTBL_ENTRY)&_ZN5S95C44v140Ev,
  (VTBL_ENTRY)&_ZN5S95C44v141Ev,
  (VTBL_ENTRY)&_ZN5S95C44v142Ev,
  (VTBL_ENTRY)&_ZN5S95C44v143Ev,
  (VTBL_ENTRY)&_ZN5S95C44v144Ev,
  (VTBL_ENTRY)&_ZN5S95C44v145Ev,
  (VTBL_ENTRY)&_ZN5S95C44v146Ev,
  (VTBL_ENTRY)&_ZN5S95C44v147Ev,
  (VTBL_ENTRY)&_ZN5S95C44v148Ev,
  (VTBL_ENTRY)&_ZN5S95C44v149Ev,
  (VTBL_ENTRY)&_ZN5S95C44v150Ev,
  (VTBL_ENTRY)&_ZN5S95C44v151Ev,
  (VTBL_ENTRY)&_ZN5S95C44v152Ev,
  (VTBL_ENTRY)&_ZN5S95C44v153Ev,
  (VTBL_ENTRY)&_ZN5S95C44v154Ev,
  (VTBL_ENTRY)&_ZN5S95C44v155Ev,
  (VTBL_ENTRY)&_ZN5S95C44v156Ev,
  (VTBL_ENTRY)&_ZN5S95C34v157Ev,
  (VTBL_ENTRY)&_ZN5S95C34v158Ev,
  (VTBL_ENTRY)&_ZN5S95C34v159Ev,
  (VTBL_ENTRY)&_ZN5S95C34v160Ev,
  (VTBL_ENTRY)&_ZN5S95C24v161Ev,
  (VTBL_ENTRY)&_ZN5S95C24v162Ev,
  (VTBL_ENTRY)&_ZN5S95C24v163Ev,
  (VTBL_ENTRY)&_ZN5S95C24v164Ev,
  (VTBL_ENTRY)&_ZN5S95C24v165Ev,
  (VTBL_ENTRY)&_ZN5S95C24v166Ev,
  (VTBL_ENTRY)&_ZN5S95C24v167Ev,
  (VTBL_ENTRY)&_ZN5S95C24v168Ev,
  (VTBL_ENTRY)&_ZN5S95C24v169Ev,
  (VTBL_ENTRY)&_ZN5S95C24v170Ev,
  (VTBL_ENTRY)&_ZN5S95C24v171Ev,
  (VTBL_ENTRY)&_ZN5S95C24v172Ev,
  (VTBL_ENTRY)&_ZN5S95C24v173Ev,
  (VTBL_ENTRY)&_ZN5S95C24v174Ev,
  (VTBL_ENTRY)&_ZN5S95C24v175Ev,
  (VTBL_ENTRY)&_ZN5S95C24v176Ev,
  (VTBL_ENTRY)&_ZN5S95C24v177Ev,
  (VTBL_ENTRY)&_ZN5S95C24v178Ev,
  (VTBL_ENTRY)&_ZN5S95C24v179Ev,
  (VTBL_ENTRY)&_ZN5S95C24v180Ev,
  (VTBL_ENTRY)&_ZN5S95C24v181Ev,
  (VTBL_ENTRY)&_ZN5S95C24v182Ev,
  (VTBL_ENTRY)&_ZN5S95C24v183Ev,
  (VTBL_ENTRY)&_ZN5S95C24v184Ev,
  (VTBL_ENTRY)&_ZN5S95C24v185Ev,
  (VTBL_ENTRY)&_ZN5S95C24v186Ev,
  (VTBL_ENTRY)&_ZN5S95C24v187Ev,
  (VTBL_ENTRY)&_ZN5S95C24v188Ev,
  (VTBL_ENTRY)&_ZN5S95C24v189Ev,
  (VTBL_ENTRY)&_ZN5S95C24v190Ev,
  (VTBL_ENTRY)&_ZN5S95C24v191Ev,
  (VTBL_ENTRY)&_ZN5S95C24v192Ev,
  (VTBL_ENTRY)&_ZN5S95C24v193Ev,
  (VTBL_ENTRY)&_ZN5S95C24v194Ev,
  (VTBL_ENTRY)&_ZN5S95C24v195Ev,
  (VTBL_ENTRY)&_ZN5S95C24v196Ev,
  (VTBL_ENTRY)&_ZN5S95C24v197Ev,
  (VTBL_ENTRY)&_ZN5S95C24v198Ev,
  (VTBL_ENTRY)&_ZN5S95C24v199Ev,
  (VTBL_ENTRY)&_ZN5S95C24v200Ev,
  (VTBL_ENTRY)&_ZN5S95C24v201Ev,
  (VTBL_ENTRY)&_ZN5S95C24v202Ev,
  (VTBL_ENTRY)&_ZN5S95C24v203Ev,
  (VTBL_ENTRY)&_ZN5S95C24v204Ev,
  (VTBL_ENTRY)&_ZN5S95C24v205Ev,
  (VTBL_ENTRY)&_ZN5S95C24v206Ev,
  (VTBL_ENTRY)&_ZN5S95C24v207Ev,
  (VTBL_ENTRY)&_ZN5S95C12v1Ev,
  (VTBL_ENTRY)&_ZN5S95C12v2Ev,
  (VTBL_ENTRY)&_ZN5S95C12v3Ev,
  (VTBL_ENTRY)&_ZN5S95C12v4Ev,
};
extern VTBL_ENTRY _ZTI5S95C1[];
extern  VTBL_ENTRY _ZTV5S95C1[];
Class_Descriptor cd_S95C1 = {  "S95C1", // class name
  bases_S95C1, 6,
  &(vtc_S95C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1056,816), // object size
  NSPAIRA(_ZTI5S95C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S95C1),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C6  {
  int s236c6f0;
  __tsi64 s236c6f1;
  void *s236c6f2[4];
  int s236c6f3[2];
  void *s236c6f4;
  ::S95C8_nt s236c6f5;
  void *s236c6f6[2];
  virtual  ~S236C6(); // _ZN6S236C6D1Ev
  virtual void  v5(); // _ZN6S236C62v5Ev
  virtual void  v6(); // _ZN6S236C62v6Ev
  virtual void  v7(); // _ZN6S236C62v7Ev
  virtual void  v8(); // _ZN6S236C62v8Ev
  virtual void  v9(); // _ZN6S236C62v9Ev
  virtual void  v10(); // _ZN6S236C63v10Ev
  virtual void  v11(); // _ZN6S236C63v11Ev
  virtual void  v12(); // _ZN6S236C63v12Ev
  virtual void  v13(); // _ZN6S236C63v13Ev
  virtual void  v14(); // _ZN6S236C63v14Ev
  virtual void  v15(); // _ZN6S236C63v15Ev
  virtual void  v16(); // _ZN6S236C63v16Ev
  virtual void  v17(); // _ZN6S236C63v17Ev
  virtual void  v18(); // _ZN6S236C63v18Ev
  virtual void  v19(); // _ZN6S236C63v19Ev
  virtual void  v20(); // _ZN6S236C63v20Ev
  virtual void  v21(); // _ZN6S236C63v21Ev
  virtual void  v22(); // _ZN6S236C63v22Ev
  virtual void  v23(); // _ZN6S236C63v23Ev
  virtual void  v24(); // _ZN6S236C63v24Ev
  virtual void  v25(); // _ZN6S236C63v25Ev
  virtual void  v26(); // _ZN6S236C63v26Ev
  virtual void  v27(); // _ZN6S236C63v27Ev
  virtual void  v28(); // _ZN6S236C63v28Ev
  virtual void  v29(); // _ZN6S236C63v29Ev
  virtual void  v30(); // _ZN6S236C63v30Ev
  virtual void  v31(); // _ZN6S236C63v31Ev
  virtual void  v32(); // _ZN6S236C63v32Ev
  virtual void  v33(); // _ZN6S236C63v33Ev
  virtual void  v34(); // _ZN6S236C63v34Ev
  virtual void  v35(); // _ZN6S236C63v35Ev
  virtual void  v36(); // _ZN6S236C63v36Ev
  virtual void  v37(); // _ZN6S236C63v37Ev
  virtual void  v38(); // _ZN6S236C63v38Ev
  virtual void  v39(); // _ZN6S236C63v39Ev
  virtual void  v40(); // _ZN6S236C63v40Ev
  virtual void  v41(); // _ZN6S236C63v41Ev
  virtual void  v42(); // _ZN6S236C63v42Ev
  virtual void  v43(); // _ZN6S236C63v43Ev
  virtual void  v44(); // _ZN6S236C63v44Ev
  virtual void  v45(); // _ZN6S236C63v45Ev
  virtual void  v46(); // _ZN6S236C63v46Ev
  virtual void  v47(); // _ZN6S236C63v47Ev
  virtual void  v48(); // _ZN6S236C63v48Ev
  virtual void  v49(); // _ZN6S236C63v49Ev
  virtual void  v50(); // _ZN6S236C63v50Ev
  virtual void  v51(); // _ZN6S236C63v51Ev
  virtual void  v52(); // _ZN6S236C63v52Ev
  virtual void  v53(); // _ZN6S236C63v53Ev
  virtual void  v54(); // _ZN6S236C63v54Ev
  virtual void  v55(); // _ZN6S236C63v55Ev
  virtual void  v56(); // _ZN6S236C63v56Ev
  virtual void  v57(); // _ZN6S236C63v57Ev
  virtual void  v58(); // _ZN6S236C63v58Ev
  virtual void  v59(); // _ZN6S236C63v59Ev
  virtual void  v60(); // _ZN6S236C63v60Ev
  virtual void  v61(); // _ZN6S236C63v61Ev
  virtual void  v62(); // _ZN6S236C63v62Ev
  virtual void  v63(); // _ZN6S236C63v63Ev
  virtual void  v64(); // _ZN6S236C63v64Ev
  virtual void  v65(); // _ZN6S236C63v65Ev
  virtual void  v66(); // _ZN6S236C63v66Ev
  virtual void  v67(); // _ZN6S236C63v67Ev
  virtual void  v68(); // _ZN6S236C63v68Ev
  S236C6(); // tgen
};
//SIG(-1 S236C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S236C6 ::~S236C6(){ note_dtor("S236C6", this);}
void  S236C6 ::v5(){vfunc_called(this, "_ZN6S236C62v5Ev");}
void  S236C6 ::v6(){vfunc_called(this, "_ZN6S236C62v6Ev");}
void  S236C6 ::v7(){vfunc_called(this, "_ZN6S236C62v7Ev");}
void  S236C6 ::v8(){vfunc_called(this, "_ZN6S236C62v8Ev");}
void  S236C6 ::v9(){vfunc_called(this, "_ZN6S236C62v9Ev");}
void  S236C6 ::v10(){vfunc_called(this, "_ZN6S236C63v10Ev");}
void  S236C6 ::v11(){vfunc_called(this, "_ZN6S236C63v11Ev");}
void  S236C6 ::v12(){vfunc_called(this, "_ZN6S236C63v12Ev");}
void  S236C6 ::v13(){vfunc_called(this, "_ZN6S236C63v13Ev");}
void  S236C6 ::v14(){vfunc_called(this, "_ZN6S236C63v14Ev");}
void  S236C6 ::v15(){vfunc_called(this, "_ZN6S236C63v15Ev");}
void  S236C6 ::v16(){vfunc_called(this, "_ZN6S236C63v16Ev");}
void  S236C6 ::v17(){vfunc_called(this, "_ZN6S236C63v17Ev");}
void  S236C6 ::v18(){vfunc_called(this, "_ZN6S236C63v18Ev");}
void  S236C6 ::v19(){vfunc_called(this, "_ZN6S236C63v19Ev");}
void  S236C6 ::v20(){vfunc_called(this, "_ZN6S236C63v20Ev");}
void  S236C6 ::v21(){vfunc_called(this, "_ZN6S236C63v21Ev");}
void  S236C6 ::v22(){vfunc_called(this, "_ZN6S236C63v22Ev");}
void  S236C6 ::v23(){vfunc_called(this, "_ZN6S236C63v23Ev");}
void  S236C6 ::v24(){vfunc_called(this, "_ZN6S236C63v24Ev");}
void  S236C6 ::v25(){vfunc_called(this, "_ZN6S236C63v25Ev");}
void  S236C6 ::v26(){vfunc_called(this, "_ZN6S236C63v26Ev");}
void  S236C6 ::v27(){vfunc_called(this, "_ZN6S236C63v27Ev");}
void  S236C6 ::v28(){vfunc_called(this, "_ZN6S236C63v28Ev");}
void  S236C6 ::v29(){vfunc_called(this, "_ZN6S236C63v29Ev");}
void  S236C6 ::v30(){vfunc_called(this, "_ZN6S236C63v30Ev");}
void  S236C6 ::v31(){vfunc_called(this, "_ZN6S236C63v31Ev");}
void  S236C6 ::v32(){vfunc_called(this, "_ZN6S236C63v32Ev");}
void  S236C6 ::v33(){vfunc_called(this, "_ZN6S236C63v33Ev");}
void  S236C6 ::v34(){vfunc_called(this, "_ZN6S236C63v34Ev");}
void  S236C6 ::v35(){vfunc_called(this, "_ZN6S236C63v35Ev");}
void  S236C6 ::v36(){vfunc_called(this, "_ZN6S236C63v36Ev");}
void  S236C6 ::v37(){vfunc_called(this, "_ZN6S236C63v37Ev");}
void  S236C6 ::v38(){vfunc_called(this, "_ZN6S236C63v38Ev");}
void  S236C6 ::v39(){vfunc_called(this, "_ZN6S236C63v39Ev");}
void  S236C6 ::v40(){vfunc_called(this, "_ZN6S236C63v40Ev");}
void  S236C6 ::v41(){vfunc_called(this, "_ZN6S236C63v41Ev");}
void  S236C6 ::v42(){vfunc_called(this, "_ZN6S236C63v42Ev");}
void  S236C6 ::v43(){vfunc_called(this, "_ZN6S236C63v43Ev");}
void  S236C6 ::v44(){vfunc_called(this, "_ZN6S236C63v44Ev");}
void  S236C6 ::v45(){vfunc_called(this, "_ZN6S236C63v45Ev");}
void  S236C6 ::v46(){vfunc_called(this, "_ZN6S236C63v46Ev");}
void  S236C6 ::v47(){vfunc_called(this, "_ZN6S236C63v47Ev");}
void  S236C6 ::v48(){vfunc_called(this, "_ZN6S236C63v48Ev");}
void  S236C6 ::v49(){vfunc_called(this, "_ZN6S236C63v49Ev");}
void  S236C6 ::v50(){vfunc_called(this, "_ZN6S236C63v50Ev");}
void  S236C6 ::v51(){vfunc_called(this, "_ZN6S236C63v51Ev");}
void  S236C6 ::v52(){vfunc_called(this, "_ZN6S236C63v52Ev");}
void  S236C6 ::v53(){vfunc_called(this, "_ZN6S236C63v53Ev");}
void  S236C6 ::v54(){vfunc_called(this, "_ZN6S236C63v54Ev");}
void  S236C6 ::v55(){vfunc_called(this, "_ZN6S236C63v55Ev");}
void  S236C6 ::v56(){vfunc_called(this, "_ZN6S236C63v56Ev");}
void  S236C6 ::v57(){vfunc_called(this, "_ZN6S236C63v57Ev");}
void  S236C6 ::v58(){vfunc_called(this, "_ZN6S236C63v58Ev");}
void  S236C6 ::v59(){vfunc_called(this, "_ZN6S236C63v59Ev");}
void  S236C6 ::v60(){vfunc_called(this, "_ZN6S236C63v60Ev");}
void  S236C6 ::v61(){vfunc_called(this, "_ZN6S236C63v61Ev");}
void  S236C6 ::v62(){vfunc_called(this, "_ZN6S236C63v62Ev");}
void  S236C6 ::v63(){vfunc_called(this, "_ZN6S236C63v63Ev");}
void  S236C6 ::v64(){vfunc_called(this, "_ZN6S236C63v64Ev");}
void  S236C6 ::v65(){vfunc_called(this, "_ZN6S236C63v65Ev");}
void  S236C6 ::v66(){vfunc_called(this, "_ZN6S236C63v66Ev");}
void  S236C6 ::v67(){vfunc_called(this, "_ZN6S236C63v67Ev");}
void  S236C6 ::v68(){vfunc_called(this, "_ZN6S236C63v68Ev");}
S236C6 ::S236C6(){ note_ctor("S236C6", this);} // tgen

static void Test_S236C6()
{
  extern Class_Descriptor cd_S236C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S236C6, buf);
    S236C6 *dp, &lv = *(dp=new (buf) S236C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S236C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C6)");
    check_field_offset(lv, s236c6f0, ABISELECT(8,4), "S236C6.s236c6f0");
    check_field_offset(lv, s236c6f1, ABISELECT(16,8), "S236C6.s236c6f1");
    check_field_offset(lv, s236c6f2, ABISELECT(24,16), "S236C6.s236c6f2");
    check_field_offset(lv, s236c6f3, ABISELECT(56,32), "S236C6.s236c6f3");
    check_field_offset(lv, s236c6f4, ABISELECT(64,40), "S236C6.s236c6f4");
    check_field_offset(lv, s236c6f5, ABISELECT(72,44), "S236C6.s236c6f5");
    check_field_offset(lv, s236c6f6, ABISELECT(80,52), "S236C6.s236c6f6");
    test_class_info(&lv, &cd_S236C6);
    dp->~S236C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C6(Test_S236C6, "S236C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S236C6C1Ev();
extern void _ZN6S236C6D1Ev();
Name_Map name_map_S236C6[] = {
  NSPAIR(_ZN6S236C6C1Ev),
  NSPAIR(_ZN6S236C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S236C6[];
extern void _ZN6S236C6D1Ev();
extern void _ZN6S236C6D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
static  VTBL_ENTRY vtc_S236C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C6[0]),
  (VTBL_ENTRY)&_ZN6S236C6D1Ev,
  (VTBL_ENTRY)&_ZN6S236C6D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
};
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
Class_Descriptor cd_S236C6 = {  "S236C6", // class name
  0,0,//no base classes
  &(vtc_S236C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S236C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S236C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C5  : S236C6 {
  void *s236c5f0;
  ::S95C8_nt s236c5f1;
  virtual  ~S236C5(); // _ZN6S236C5D1Ev
  virtual void  v69(); // _ZN6S236C53v69Ev
  virtual void  v70(); // _ZN6S236C53v70Ev
  virtual void  v71(); // _ZN6S236C53v71Ev
  virtual void  v72(); // _ZN6S236C53v72Ev
  virtual void  v73(); // _ZN6S236C53v73Ev
  S236C5(); // tgen
};
//SIG(-1 S236C5) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S236C5 ::~S236C5(){ note_dtor("S236C5", this);}
void  S236C5 ::v69(){vfunc_called(this, "_ZN6S236C53v69Ev");}
void  S236C5 ::v70(){vfunc_called(this, "_ZN6S236C53v70Ev");}
void  S236C5 ::v71(){vfunc_called(this, "_ZN6S236C53v71Ev");}
void  S236C5 ::v72(){vfunc_called(this, "_ZN6S236C53v72Ev");}
void  S236C5 ::v73(){vfunc_called(this, "_ZN6S236C53v73Ev");}
S236C5 ::S236C5(){ note_ctor("S236C5", this);} // tgen

static void Test_S236C5()
{
  extern Class_Descriptor cd_S236C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S236C5, buf);
    S236C5 *dp, &lv = *(dp=new (buf) S236C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S236C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C5)");
    check_base_class_offset(lv, (S236C6*), 0, "S236C5");
    check_field_offset(lv, s236c5f0, ABISELECT(96,60), "S236C5.s236c5f0");
    check_field_offset(lv, s236c5f1, ABISELECT(104,64), "S236C5.s236c5f1");
    test_class_info(&lv, &cd_S236C5);
    dp->~S236C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C5(Test_S236C5, "S236C5", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S236C5C1Ev();
extern void _ZN6S236C5D1Ev();
Name_Map name_map_S236C5[] = {
  NSPAIR(_ZN6S236C5C1Ev),
  NSPAIR(_ZN6S236C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S236C6;
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
static Base_Class bases_S236C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S236C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S236C5[];
extern void _ZN6S236C5D1Ev();
extern void _ZN6S236C5D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
extern void _ZN6S236C53v69Ev();
extern void _ZN6S236C53v70Ev();
extern void _ZN6S236C53v71Ev();
extern void _ZN6S236C53v72Ev();
extern void _ZN6S236C53v73Ev();
static  VTBL_ENTRY vtc_S236C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C5[0]),
  (VTBL_ENTRY)&_ZN6S236C5D1Ev,
  (VTBL_ENTRY)&_ZN6S236C5D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
  (VTBL_ENTRY)&_ZN6S236C53v69Ev,
  (VTBL_ENTRY)&_ZN6S236C53v70Ev,
  (VTBL_ENTRY)&_ZN6S236C53v71Ev,
  (VTBL_ENTRY)&_ZN6S236C53v72Ev,
  (VTBL_ENTRY)&_ZN6S236C53v73Ev,
};
extern VTBL_ENTRY _ZTI6S236C5[];
extern  VTBL_ENTRY _ZTV6S236C5[];
Class_Descriptor cd_S236C5 = {  "S236C5", // class name
  bases_S236C5, 1,
  &(vtc_S236C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S236C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S236C5),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C4  : S236C5 {
  void *s236c4f0[2];
  unsigned int s236c4f1:1;
  unsigned int s236c4f2:1;
  unsigned int s236c4f3:1;
  unsigned int s236c4f4:1;
  char s236c4f5;
  virtual  ~S236C4(); // _ZN6S236C4D1Ev
  virtual void  v74(); // _ZN6S236C43v74Ev
  virtual void  v75(); // _ZN6S236C43v75Ev
  virtual void  v76(); // _ZN6S236C43v76Ev
  virtual void  v77(); // _ZN6S236C43v77Ev
  virtual void  v78(); // _ZN6S236C43v78Ev
  virtual void  v79(); // _ZN6S236C43v79Ev
  virtual void  v80(); // _ZN6S236C43v80Ev
  virtual void  v81(); // _ZN6S236C43v81Ev
  virtual void  v82(); // _ZN6S236C43v82Ev
  virtual void  v83(); // _ZN6S236C43v83Ev
  virtual void  v84(); // _ZN6S236C43v84Ev
  virtual void  v85(); // _ZN6S236C43v85Ev
  virtual void  v86(); // _ZN6S236C43v86Ev
  virtual void  v87(); // _ZN6S236C43v87Ev
  virtual void  v88(); // _ZN6S236C43v88Ev
  virtual void  v89(); // _ZN6S236C43v89Ev
  virtual void  v90(); // _ZN6S236C43v90Ev
  virtual void  v91(); // _ZN6S236C43v91Ev
  virtual void  v92(); // _ZN6S236C43v92Ev
  virtual void  v93(); // _ZN6S236C43v93Ev
  virtual void  v94(); // _ZN6S236C43v94Ev
  virtual void  v95(); // _ZN6S236C43v95Ev
  S236C4(); // tgen
};
//SIG(-1 S236C4) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S236C4 ::~S236C4(){ note_dtor("S236C4", this);}
void  S236C4 ::v74(){vfunc_called(this, "_ZN6S236C43v74Ev");}
void  S236C4 ::v75(){vfunc_called(this, "_ZN6S236C43v75Ev");}
void  S236C4 ::v76(){vfunc_called(this, "_ZN6S236C43v76Ev");}
void  S236C4 ::v77(){vfunc_called(this, "_ZN6S236C43v77Ev");}
void  S236C4 ::v78(){vfunc_called(this, "_ZN6S236C43v78Ev");}
void  S236C4 ::v79(){vfunc_called(this, "_ZN6S236C43v79Ev");}
void  S236C4 ::v80(){vfunc_called(this, "_ZN6S236C43v80Ev");}
void  S236C4 ::v81(){vfunc_called(this, "_ZN6S236C43v81Ev");}
void  S236C4 ::v82(){vfunc_called(this, "_ZN6S236C43v82Ev");}
void  S236C4 ::v83(){vfunc_called(this, "_ZN6S236C43v83Ev");}
void  S236C4 ::v84(){vfunc_called(this, "_ZN6S236C43v84Ev");}
void  S236C4 ::v85(){vfunc_called(this, "_ZN6S236C43v85Ev");}
void  S236C4 ::v86(){vfunc_called(this, "_ZN6S236C43v86Ev");}
void  S236C4 ::v87(){vfunc_called(this, "_ZN6S236C43v87Ev");}
void  S236C4 ::v88(){vfunc_called(this, "_ZN6S236C43v88Ev");}
void  S236C4 ::v89(){vfunc_called(this, "_ZN6S236C43v89Ev");}
void  S236C4 ::v90(){vfunc_called(this, "_ZN6S236C43v90Ev");}
void  S236C4 ::v91(){vfunc_called(this, "_ZN6S236C43v91Ev");}
void  S236C4 ::v92(){vfunc_called(this, "_ZN6S236C43v92Ev");}
void  S236C4 ::v93(){vfunc_called(this, "_ZN6S236C43v93Ev");}
void  S236C4 ::v94(){vfunc_called(this, "_ZN6S236C43v94Ev");}
void  S236C4 ::v95(){vfunc_called(this, "_ZN6S236C43v95Ev");}
S236C4 ::S236C4(){ note_ctor("S236C4", this);} // tgen

static void Test_S236C4()
{
  extern Class_Descriptor cd_S236C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S236C4, buf);
    S236C4 *dp, &lv = *(dp=new (buf) S236C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S236C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C4)");
    check_base_class_offset(lv, (S236C6*)(S236C5*), 0, "S236C4");
    check_base_class_offset(lv, (S236C5*), 0, "S236C4");
    check_field_offset(lv, s236c4f0, ABISELECT(112,72), "S236C4.s236c4f0");
    set_bf_and_test(lv, s236c4f1, ABISELECT(128,80), 0, 1, 1, "S236C4");
    set_bf_and_test(lv, s236c4f2, ABISELECT(128,80), 1, 1, 1, "S236C4");
    set_bf_and_test(lv, s236c4f3, ABISELECT(128,80), 2, 1, 1, "S236C4");
    set_bf_and_test(lv, s236c4f4, ABISELECT(128,80), 3, 1, 1, "S236C4");
    check_field_offset(lv, s236c4f5, ABISELECT(129,81), "S236C4.s236c4f5");
    test_class_info(&lv, &cd_S236C4);
    dp->~S236C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C4(Test_S236C4, "S236C4", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S236C4C1Ev();
extern void _ZN6S236C4D1Ev();
Name_Map name_map_S236C4[] = {
  NSPAIR(_ZN6S236C4C1Ev),
  NSPAIR(_ZN6S236C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S236C6;
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
extern Class_Descriptor cd_S236C5;
extern VTBL_ENTRY _ZTI6S236C5[];
extern  VTBL_ENTRY _ZTV6S236C5[];
static Base_Class bases_S236C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S236C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S236C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S236C4[];
extern void _ZN6S236C4D1Ev();
extern void _ZN6S236C4D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
extern void _ZN6S236C53v69Ev();
extern void _ZN6S236C53v70Ev();
extern void _ZN6S236C53v71Ev();
extern void _ZN6S236C53v72Ev();
extern void _ZN6S236C53v73Ev();
extern void _ZN6S236C43v74Ev();
extern void _ZN6S236C43v75Ev();
extern void _ZN6S236C43v76Ev();
extern void _ZN6S236C43v77Ev();
extern void _ZN6S236C43v78Ev();
extern void _ZN6S236C43v79Ev();
extern void _ZN6S236C43v80Ev();
extern void _ZN6S236C43v81Ev();
extern void _ZN6S236C43v82Ev();
extern void _ZN6S236C43v83Ev();
extern void _ZN6S236C43v84Ev();
extern void _ZN6S236C43v85Ev();
extern void _ZN6S236C43v86Ev();
extern void _ZN6S236C43v87Ev();
extern void _ZN6S236C43v88Ev();
extern void _ZN6S236C43v89Ev();
extern void _ZN6S236C43v90Ev();
extern void _ZN6S236C43v91Ev();
extern void _ZN6S236C43v92Ev();
extern void _ZN6S236C43v93Ev();
extern void _ZN6S236C43v94Ev();
extern void _ZN6S236C43v95Ev();
static  VTBL_ENTRY vtc_S236C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C4[0]),
  (VTBL_ENTRY)&_ZN6S236C4D1Ev,
  (VTBL_ENTRY)&_ZN6S236C4D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
  (VTBL_ENTRY)&_ZN6S236C53v69Ev,
  (VTBL_ENTRY)&_ZN6S236C53v70Ev,
  (VTBL_ENTRY)&_ZN6S236C53v71Ev,
  (VTBL_ENTRY)&_ZN6S236C53v72Ev,
  (VTBL_ENTRY)&_ZN6S236C53v73Ev,
  (VTBL_ENTRY)&_ZN6S236C43v74Ev,
  (VTBL_ENTRY)&_ZN6S236C43v75Ev,
  (VTBL_ENTRY)&_ZN6S236C43v76Ev,
  (VTBL_ENTRY)&_ZN6S236C43v77Ev,
  (VTBL_ENTRY)&_ZN6S236C43v78Ev,
  (VTBL_ENTRY)&_ZN6S236C43v79Ev,
  (VTBL_ENTRY)&_ZN6S236C43v80Ev,
  (VTBL_ENTRY)&_ZN6S236C43v81Ev,
  (VTBL_ENTRY)&_ZN6S236C43v82Ev,
  (VTBL_ENTRY)&_ZN6S236C43v83Ev,
  (VTBL_ENTRY)&_ZN6S236C43v84Ev,
  (VTBL_ENTRY)&_ZN6S236C43v85Ev,
  (VTBL_ENTRY)&_ZN6S236C43v86Ev,
  (VTBL_ENTRY)&_ZN6S236C43v87Ev,
  (VTBL_ENTRY)&_ZN6S236C43v88Ev,
  (VTBL_ENTRY)&_ZN6S236C43v89Ev,
  (VTBL_ENTRY)&_ZN6S236C43v90Ev,
  (VTBL_ENTRY)&_ZN6S236C43v91Ev,
  (VTBL_ENTRY)&_ZN6S236C43v92Ev,
  (VTBL_ENTRY)&_ZN6S236C43v93Ev,
  (VTBL_ENTRY)&_ZN6S236C43v94Ev,
  (VTBL_ENTRY)&_ZN6S236C43v95Ev,
};
extern VTBL_ENTRY _ZTI6S236C4[];
extern  VTBL_ENTRY _ZTV6S236C4[];
Class_Descriptor cd_S236C4 = {  "S236C4", // class name
  bases_S236C4, 2,
  &(vtc_S236C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S236C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S236C4),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C15_nt  {
  void  mf236c15(); // _ZN10S236C15_nt8mf236c15Ev
};
//SIG(-1 S236C15_nt) C1{ m}


void  S236C15_nt ::mf236c15(){}

//skip512 S236C15_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S236C15_nt[];
VTBL_ENTRY *P__ZTI10S236C15_nt = _ZTI10S236C15_nt; 
Class_Descriptor cd_S236C15_nt = {  "S236C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S236C15_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C18_nt  {
  int s236c18f0[3];
  void  mf236c18(); // _ZN10S236C18_nt8mf236c18Ev
};
//SIG(-1 S236C18_nt) C1{ m Fi[3]}


void  S236C18_nt ::mf236c18(){}

//skip512 S236C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C3  : S236C4 {
  void *s236c3f0;
  ::S95C9_nt s236c3f1;
  int s236c3f2;
  ::S95C16 s236c3f3;
  int s236c3f4;
  ::S95C38 s236c3f5;
  int s236c3f6;
  void *s236c3f7[2];
  ::S95C13 s236c3f8;
  void *s236c3f9;
  int s236c3f10[2];
  char s236c3f11[3];
  int s236c3f12;
  unsigned int s236c3f13:1;
  unsigned int s236c3f14:1;
  unsigned int s236c3f15:1;
  unsigned int s236c3f16:1;
  unsigned int s236c3f17:1;
  unsigned int s236c3f18:1;
  unsigned int s236c3f19:1;
  unsigned int s236c3f20:1;
  unsigned int s236c3f21:1;
  unsigned int s236c3f22:1;
  unsigned int s236c3f23:1;
  unsigned int s236c3f24:1;
  unsigned int s236c3f25:1;
  unsigned int s236c3f26:1;
  int s236c3f27;
  unsigned int s236c3f28:1;
  unsigned int s236c3f29:1;
  unsigned int s236c3f30:1;
  unsigned int s236c3f31:1;
  unsigned int s236c3f32:1;
  unsigned int s236c3f33:1;
  ::S95C10_nt s236c3f34;
  unsigned int s236c3f35:1;
  unsigned int s236c3f36:1;
  unsigned int s236c3f37:1;
  unsigned int s236c3f38:1;
  unsigned int s236c3f39:1;
  unsigned int s236c3f40:1;
  unsigned int s236c3f41:1;
  char s236c3f42;
  ::S236C15_nt s236c3f43;
  unsigned int s236c3f44:1;
  unsigned int s236c3f45:1;
  unsigned int s236c3f46:1;
  unsigned int s236c3f47:1;
  unsigned int s236c3f48:1;
  unsigned int s236c3f49:1;
  unsigned int s236c3f50:1;
  unsigned int s236c3f51:1;
  unsigned int s236c3f52:1;
  unsigned int s236c3f53:1;
  unsigned int s236c3f54:1;
  unsigned int s236c3f55:1;
  ::S95C35 s236c3f56;
  void *s236c3f57[2];
  char s236c3f58;
  ::S95C16 s236c3f59;
  ::S95C14_nt s236c3f60;
  ::S236C18_nt s236c3f61;
  int s236c3f62;
  ::S95C14_nt s236c3f63;
  unsigned int s236c3f64:1;
  unsigned int s236c3f65:1;
  unsigned int s236c3f66:1;
  int s236c3f67[3];
  virtual  ~S236C3(); // _ZN6S236C3D1Ev
  virtual void  v96(); // _ZN6S236C33v96Ev
  virtual void  v97(); // _ZN6S236C33v97Ev
  virtual void  v98(); // _ZN6S236C33v98Ev
  virtual void  v99(); // _ZN6S236C33v99Ev
  virtual void  v100(); // _ZN6S236C34v100Ev
  virtual void  v101(); // _ZN6S236C34v101Ev
  virtual void  v102(); // _ZN6S236C34v102Ev
  virtual void  v103(); // _ZN6S236C34v103Ev
  virtual void  v104(); // _ZN6S236C34v104Ev
  virtual void  v105(); // _ZN6S236C34v105Ev
  virtual void  v106(); // _ZN6S236C34v106Ev
  virtual void  v107(); // _ZN6S236C34v107Ev
  virtual void  v108(); // _ZN6S236C34v108Ev
  virtual void  v109(); // _ZN6S236C34v109Ev
  virtual void  v110(); // _ZN6S236C34v110Ev
  virtual void  v111(); // _ZN6S236C34v111Ev
  virtual void  v112(); // _ZN6S236C34v112Ev
  virtual void  v113(); // _ZN6S236C34v113Ev
  virtual void  v114(); // _ZN6S236C34v114Ev
  virtual void  v115(); // _ZN6S236C34v115Ev
  virtual void  v116(); // _ZN6S236C34v116Ev
  virtual void  v117(); // _ZN6S236C34v117Ev
  virtual void  v118(); // _ZN6S236C34v118Ev
  virtual void  v119(); // _ZN6S236C34v119Ev
  virtual void  v120(); // _ZN6S236C34v120Ev
  virtual void  v121(); // _ZN6S236C34v121Ev
  virtual void  v122(); // _ZN6S236C34v122Ev
  virtual void  v123(); // _ZN6S236C34v123Ev
  virtual void  v124(); // _ZN6S236C34v124Ev
  virtual void  v125(); // _ZN6S236C34v125Ev
  virtual void  v126(); // _ZN6S236C34v126Ev
  virtual void  v127(); // _ZN6S236C34v127Ev
  virtual void  v128(); // _ZN6S236C34v128Ev
  virtual void  v129(); // _ZN6S236C34v129Ev
  virtual void  v130(); // _ZN6S236C34v130Ev
  virtual void  v131(); // _ZN6S236C34v131Ev
  virtual void  v132(); // _ZN6S236C34v132Ev
  virtual void  v133(); // _ZN6S236C34v133Ev
  virtual void  v134(); // _ZN6S236C34v134Ev
  virtual void  v135(); // _ZN6S236C34v135Ev
  virtual void  v136(); // _ZN6S236C34v136Ev
  virtual void  v137(); // _ZN6S236C34v137Ev
  virtual void  v138(); // _ZN6S236C34v138Ev
  virtual void  v139(); // _ZN6S236C34v139Ev
  virtual void  v140(); // _ZN6S236C34v140Ev
  virtual void  v141(); // _ZN6S236C34v141Ev
  virtual void  v142(); // _ZN6S236C34v142Ev
  virtual void  v143(); // _ZN6S236C34v143Ev
  virtual void  v144(); // _ZN6S236C34v144Ev
  virtual void  v145(); // _ZN6S236C34v145Ev
  virtual void  v146(); // _ZN6S236C34v146Ev
  virtual void  v147(); // _ZN6S236C34v147Ev
  virtual void  v148(); // _ZN6S236C34v148Ev
  virtual void  v149(); // _ZN6S236C34v149Ev
  virtual void  v150(); // _ZN6S236C34v150Ev
  virtual void  v151(); // _ZN6S236C34v151Ev
  virtual void  v152(); // _ZN6S236C34v152Ev
  virtual void  v153(); // _ZN6S236C34v153Ev
  virtual void  v154(); // _ZN6S236C34v154Ev
  virtual void  v155(); // _ZN6S236C34v155Ev
  virtual void  v156(); // _ZN6S236C34v156Ev
  S236C3(); // tgen
};
//SIG(-1 S236C3) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC9}} Fp[2] Fc FC7 FC11 FC16{ m Fi[3]} Fi FC11 Fi:1 Fi:1 Fi:1 Fi[3]}


 S236C3 ::~S236C3(){ note_dtor("S236C3", this);}
void  S236C3 ::v96(){vfunc_called(this, "_ZN6S236C33v96Ev");}
void  S236C3 ::v97(){vfunc_called(this, "_ZN6S236C33v97Ev");}
void  S236C3 ::v98(){vfunc_called(this, "_ZN6S236C33v98Ev");}
void  S236C3 ::v99(){vfunc_called(this, "_ZN6S236C33v99Ev");}
void  S236C3 ::v100(){vfunc_called(this, "_ZN6S236C34v100Ev");}
void  S236C3 ::v101(){vfunc_called(this, "_ZN6S236C34v101Ev");}
void  S236C3 ::v102(){vfunc_called(this, "_ZN6S236C34v102Ev");}
void  S236C3 ::v103(){vfunc_called(this, "_ZN6S236C34v103Ev");}
void  S236C3 ::v104(){vfunc_called(this, "_ZN6S236C34v104Ev");}
void  S236C3 ::v105(){vfunc_called(this, "_ZN6S236C34v105Ev");}
void  S236C3 ::v106(){vfunc_called(this, "_ZN6S236C34v106Ev");}
void  S236C3 ::v107(){vfunc_called(this, "_ZN6S236C34v107Ev");}
void  S236C3 ::v108(){vfunc_called(this, "_ZN6S236C34v108Ev");}
void  S236C3 ::v109(){vfunc_called(this, "_ZN6S236C34v109Ev");}
void  S236C3 ::v110(){vfunc_called(this, "_ZN6S236C34v110Ev");}
void  S236C3 ::v111(){vfunc_called(this, "_ZN6S236C34v111Ev");}
void  S236C3 ::v112(){vfunc_called(this, "_ZN6S236C34v112Ev");}
void  S236C3 ::v113(){vfunc_called(this, "_ZN6S236C34v113Ev");}
void  S236C3 ::v114(){vfunc_called(this, "_ZN6S236C34v114Ev");}
void  S236C3 ::v115(){vfunc_called(this, "_ZN6S236C34v115Ev");}
void  S236C3 ::v116(){vfunc_called(this, "_ZN6S236C34v116Ev");}
void  S236C3 ::v117(){vfunc_called(this, "_ZN6S236C34v117Ev");}
void  S236C3 ::v118(){vfunc_called(this, "_ZN6S236C34v118Ev");}
void  S236C3 ::v119(){vfunc_called(this, "_ZN6S236C34v119Ev");}
void  S236C3 ::v120(){vfunc_called(this, "_ZN6S236C34v120Ev");}
void  S236C3 ::v121(){vfunc_called(this, "_ZN6S236C34v121Ev");}
void  S236C3 ::v122(){vfunc_called(this, "_ZN6S236C34v122Ev");}
void  S236C3 ::v123(){vfunc_called(this, "_ZN6S236C34v123Ev");}
void  S236C3 ::v124(){vfunc_called(this, "_ZN6S236C34v124Ev");}
void  S236C3 ::v125(){vfunc_called(this, "_ZN6S236C34v125Ev");}
void  S236C3 ::v126(){vfunc_called(this, "_ZN6S236C34v126Ev");}
void  S236C3 ::v127(){vfunc_called(this, "_ZN6S236C34v127Ev");}
void  S236C3 ::v128(){vfunc_called(this, "_ZN6S236C34v128Ev");}
void  S236C3 ::v129(){vfunc_called(this, "_ZN6S236C34v129Ev");}
void  S236C3 ::v130(){vfunc_called(this, "_ZN6S236C34v130Ev");}
void  S236C3 ::v131(){vfunc_called(this, "_ZN6S236C34v131Ev");}
void  S236C3 ::v132(){vfunc_called(this, "_ZN6S236C34v132Ev");}
void  S236C3 ::v133(){vfunc_called(this, "_ZN6S236C34v133Ev");}
void  S236C3 ::v134(){vfunc_called(this, "_ZN6S236C34v134Ev");}
void  S236C3 ::v135(){vfunc_called(this, "_ZN6S236C34v135Ev");}
void  S236C3 ::v136(){vfunc_called(this, "_ZN6S236C34v136Ev");}
void  S236C3 ::v137(){vfunc_called(this, "_ZN6S236C34v137Ev");}
void  S236C3 ::v138(){vfunc_called(this, "_ZN6S236C34v138Ev");}
void  S236C3 ::v139(){vfunc_called(this, "_ZN6S236C34v139Ev");}
void  S236C3 ::v140(){vfunc_called(this, "_ZN6S236C34v140Ev");}
void  S236C3 ::v141(){vfunc_called(this, "_ZN6S236C34v141Ev");}
void  S236C3 ::v142(){vfunc_called(this, "_ZN6S236C34v142Ev");}
void  S236C3 ::v143(){vfunc_called(this, "_ZN6S236C34v143Ev");}
void  S236C3 ::v144(){vfunc_called(this, "_ZN6S236C34v144Ev");}
void  S236C3 ::v145(){vfunc_called(this, "_ZN6S236C34v145Ev");}
void  S236C3 ::v146(){vfunc_called(this, "_ZN6S236C34v146Ev");}
void  S236C3 ::v147(){vfunc_called(this, "_ZN6S236C34v147Ev");}
void  S236C3 ::v148(){vfunc_called(this, "_ZN6S236C34v148Ev");}
void  S236C3 ::v149(){vfunc_called(this, "_ZN6S236C34v149Ev");}
void  S236C3 ::v150(){vfunc_called(this, "_ZN6S236C34v150Ev");}
void  S236C3 ::v151(){vfunc_called(this, "_ZN6S236C34v151Ev");}
void  S236C3 ::v152(){vfunc_called(this, "_ZN6S236C34v152Ev");}
void  S236C3 ::v153(){vfunc_called(this, "_ZN6S236C34v153Ev");}
void  S236C3 ::v154(){vfunc_called(this, "_ZN6S236C34v154Ev");}
void  S236C3 ::v155(){vfunc_called(this, "_ZN6S236C34v155Ev");}
void  S236C3 ::v156(){vfunc_called(this, "_ZN6S236C34v156Ev");}
S236C3 ::S236C3(){ note_ctor("S236C3", this);} // tgen

static void Test_S236C3()
{
  extern Class_Descriptor cd_S236C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S236C3, buf);
    S236C3 *dp, &lv = *(dp=new (buf) S236C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S236C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C3)");
    check_base_class_offset(lv, (S236C6*)(S236C5*)(S236C4*), 0, "S236C3");
    check_base_class_offset(lv, (S236C5*)(S236C4*), 0, "S236C3");
    check_base_class_offset(lv, (S236C4*), 0, "S236C3");
    check_field_offset(lv, s236c3f0, ABISELECT(136,84), "S236C3.s236c3f0");
    check_field_offset(lv, s236c3f1, ABISELECT(144,88), "S236C3.s236c3f1");
    check_field_offset(lv, s236c3f2, ABISELECT(148,92), "S236C3.s236c3f2");
    check_field_offset(lv, s236c3f3, ABISELECT(152,96), "S236C3.s236c3f3");
    check_field_offset(lv, s236c3f4, ABISELECT(156,100), "S236C3.s236c3f4");
    check_field_offset(lv, s236c3f5, ABISELECT(160,104), "S236C3.s236c3f5");
    check_field_offset(lv, s236c3f6, ABISELECT(176,116), "S236C3.s236c3f6");
    check_field_offset(lv, s236c3f7, ABISELECT(184,120), "S236C3.s236c3f7");
    check_field_offset(lv, s236c3f8, ABISELECT(200,128), "S236C3.s236c3f8");
    check_field_offset(lv, s236c3f9, ABISELECT(232,156), "S236C3.s236c3f9");
    check_field_offset(lv, s236c3f10, ABISELECT(240,160), "S236C3.s236c3f10");
    check_field_offset(lv, s236c3f11, ABISELECT(248,168), "S236C3.s236c3f11");
    check_field_offset(lv, s236c3f12, ABISELECT(252,172), "S236C3.s236c3f12");
    set_bf_and_test(lv, s236c3f13, ABISELECT(256,176), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f14, ABISELECT(256,176), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f15, ABISELECT(256,176), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f16, ABISELECT(256,176), 3, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f17, ABISELECT(256,176), 4, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f18, ABISELECT(256,176), 5, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f19, ABISELECT(256,176), 6, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f20, ABISELECT(256,176), 7, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f21, ABISELECT(257,177), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f22, ABISELECT(257,177), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f23, ABISELECT(257,177), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f24, ABISELECT(257,177), 3, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f25, ABISELECT(257,177), 4, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f26, ABISELECT(257,177), 5, 1, 1, "S236C3");
    check_field_offset(lv, s236c3f27, ABISELECT(260,180), "S236C3.s236c3f27");
    set_bf_and_test(lv, s236c3f28, ABISELECT(264,184), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f29, ABISELECT(264,184), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f30, ABISELECT(264,184), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f31, ABISELECT(264,184), 3, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f32, ABISELECT(264,184), 4, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f33, ABISELECT(264,184), 5, 1, 1, "S236C3");
    check_field_offset(lv, s236c3f34, ABISELECT(265,185), "S236C3.s236c3f34");
    set_bf_and_test(lv, s236c3f35, ABISELECT(266,186), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f36, ABISELECT(266,186), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f37, ABISELECT(266,186), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f38, ABISELECT(266,186), 3, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f39, ABISELECT(266,186), 4, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f40, ABISELECT(266,186), 5, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f41, ABISELECT(266,186), 6, 1, 1, "S236C3");
    check_field_offset(lv, s236c3f42, ABISELECT(267,187), "S236C3.s236c3f42");
    check_field_offset(lv, s236c3f43, ABISELECT(268,188), "S236C3.s236c3f43");
    set_bf_and_test(lv, s236c3f44, ABISELECT(269,189), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f45, ABISELECT(269,189), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f46, ABISELECT(269,189), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f47, ABISELECT(269,189), 3, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f48, ABISELECT(269,189), 4, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f49, ABISELECT(269,189), 5, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f50, ABISELECT(269,189), 6, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f51, ABISELECT(269,189), 7, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f52, ABISELECT(270,190), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f53, ABISELECT(270,190), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f54, ABISELECT(270,190), 2, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f55, ABISELECT(270,190), 3, 1, 1, "S236C3");
    check_field_offset(lv, s236c3f56, ABISELECT(272,192), "S236C3.s236c3f56");
    check_field_offset(lv, s236c3f57, ABISELECT(288,204), "S236C3.s236c3f57");
    check_field_offset(lv, s236c3f58, ABISELECT(304,212), "S236C3.s236c3f58");
    check_field_offset(lv, s236c3f59, ABISELECT(305,213), "S236C3.s236c3f59");
    check_field_offset(lv, s236c3f60, ABISELECT(308,216), "S236C3.s236c3f60");
    check_field_offset(lv, s236c3f61, ABISELECT(320,228), "S236C3.s236c3f61");
    check_field_offset(lv, s236c3f62, ABISELECT(332,240), "S236C3.s236c3f62");
    check_field_offset(lv, s236c3f63, ABISELECT(336,244), "S236C3.s236c3f63");
    set_bf_and_test(lv, s236c3f64, ABISELECT(348,256), 0, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f65, ABISELECT(348,256), 1, 1, 1, "S236C3");
    set_bf_and_test(lv, s236c3f66, ABISELECT(348,256), 2, 1, 1, "S236C3");
    check_field_offset(lv, s236c3f67, ABISELECT(352,260), "S236C3.s236c3f67");
    test_class_info(&lv, &cd_S236C3);
    dp->~S236C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C3(Test_S236C3, "S236C3", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S236C3C1Ev();
extern void _ZN6S236C3D1Ev();
Name_Map name_map_S236C3[] = {
  NSPAIR(_ZN6S236C3C1Ev),
  NSPAIR(_ZN6S236C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S236C6;
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
extern Class_Descriptor cd_S236C5;
extern VTBL_ENTRY _ZTI6S236C5[];
extern  VTBL_ENTRY _ZTV6S236C5[];
extern Class_Descriptor cd_S236C4;
extern VTBL_ENTRY _ZTI6S236C4[];
extern  VTBL_ENTRY _ZTV6S236C4[];
static Base_Class bases_S236C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S236C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S236C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S236C3[];
extern void _ZN6S236C3D1Ev();
extern void _ZN6S236C3D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
extern void _ZN6S236C53v69Ev();
extern void _ZN6S236C53v70Ev();
extern void _ZN6S236C53v71Ev();
extern void _ZN6S236C53v72Ev();
extern void _ZN6S236C53v73Ev();
extern void _ZN6S236C43v74Ev();
extern void _ZN6S236C43v75Ev();
extern void _ZN6S236C43v76Ev();
extern void _ZN6S236C43v77Ev();
extern void _ZN6S236C43v78Ev();
extern void _ZN6S236C43v79Ev();
extern void _ZN6S236C43v80Ev();
extern void _ZN6S236C43v81Ev();
extern void _ZN6S236C43v82Ev();
extern void _ZN6S236C43v83Ev();
extern void _ZN6S236C43v84Ev();
extern void _ZN6S236C43v85Ev();
extern void _ZN6S236C43v86Ev();
extern void _ZN6S236C43v87Ev();
extern void _ZN6S236C43v88Ev();
extern void _ZN6S236C43v89Ev();
extern void _ZN6S236C43v90Ev();
extern void _ZN6S236C43v91Ev();
extern void _ZN6S236C43v92Ev();
extern void _ZN6S236C43v93Ev();
extern void _ZN6S236C43v94Ev();
extern void _ZN6S236C43v95Ev();
extern void _ZN6S236C33v96Ev();
extern void _ZN6S236C33v97Ev();
extern void _ZN6S236C33v98Ev();
extern void _ZN6S236C33v99Ev();
extern void _ZN6S236C34v100Ev();
extern void _ZN6S236C34v101Ev();
extern void _ZN6S236C34v102Ev();
extern void _ZN6S236C34v103Ev();
extern void _ZN6S236C34v104Ev();
extern void _ZN6S236C34v105Ev();
extern void _ZN6S236C34v106Ev();
extern void _ZN6S236C34v107Ev();
extern void _ZN6S236C34v108Ev();
extern void _ZN6S236C34v109Ev();
extern void _ZN6S236C34v110Ev();
extern void _ZN6S236C34v111Ev();
extern void _ZN6S236C34v112Ev();
extern void _ZN6S236C34v113Ev();
extern void _ZN6S236C34v114Ev();
extern void _ZN6S236C34v115Ev();
extern void _ZN6S236C34v116Ev();
extern void _ZN6S236C34v117Ev();
extern void _ZN6S236C34v118Ev();
extern void _ZN6S236C34v119Ev();
extern void _ZN6S236C34v120Ev();
extern void _ZN6S236C34v121Ev();
extern void _ZN6S236C34v122Ev();
extern void _ZN6S236C34v123Ev();
extern void _ZN6S236C34v124Ev();
extern void _ZN6S236C34v125Ev();
extern void _ZN6S236C34v126Ev();
extern void _ZN6S236C34v127Ev();
extern void _ZN6S236C34v128Ev();
extern void _ZN6S236C34v129Ev();
extern void _ZN6S236C34v130Ev();
extern void _ZN6S236C34v131Ev();
extern void _ZN6S236C34v132Ev();
extern void _ZN6S236C34v133Ev();
extern void _ZN6S236C34v134Ev();
extern void _ZN6S236C34v135Ev();
extern void _ZN6S236C34v136Ev();
extern void _ZN6S236C34v137Ev();
extern void _ZN6S236C34v138Ev();
extern void _ZN6S236C34v139Ev();
extern void _ZN6S236C34v140Ev();
extern void _ZN6S236C34v141Ev();
extern void _ZN6S236C34v142Ev();
extern void _ZN6S236C34v143Ev();
extern void _ZN6S236C34v144Ev();
extern void _ZN6S236C34v145Ev();
extern void _ZN6S236C34v146Ev();
extern void _ZN6S236C34v147Ev();
extern void _ZN6S236C34v148Ev();
extern void _ZN6S236C34v149Ev();
extern void _ZN6S236C34v150Ev();
extern void _ZN6S236C34v151Ev();
extern void _ZN6S236C34v152Ev();
extern void _ZN6S236C34v153Ev();
extern void _ZN6S236C34v154Ev();
extern void _ZN6S236C34v155Ev();
extern void _ZN6S236C34v156Ev();
static  VTBL_ENTRY vtc_S236C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C3[0]),
  (VTBL_ENTRY)&_ZN6S236C3D1Ev,
  (VTBL_ENTRY)&_ZN6S236C3D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
  (VTBL_ENTRY)&_ZN6S236C53v69Ev,
  (VTBL_ENTRY)&_ZN6S236C53v70Ev,
  (VTBL_ENTRY)&_ZN6S236C53v71Ev,
  (VTBL_ENTRY)&_ZN6S236C53v72Ev,
  (VTBL_ENTRY)&_ZN6S236C53v73Ev,
  (VTBL_ENTRY)&_ZN6S236C43v74Ev,
  (VTBL_ENTRY)&_ZN6S236C43v75Ev,
  (VTBL_ENTRY)&_ZN6S236C43v76Ev,
  (VTBL_ENTRY)&_ZN6S236C43v77Ev,
  (VTBL_ENTRY)&_ZN6S236C43v78Ev,
  (VTBL_ENTRY)&_ZN6S236C43v79Ev,
  (VTBL_ENTRY)&_ZN6S236C43v80Ev,
  (VTBL_ENTRY)&_ZN6S236C43v81Ev,
  (VTBL_ENTRY)&_ZN6S236C43v82Ev,
  (VTBL_ENTRY)&_ZN6S236C43v83Ev,
  (VTBL_ENTRY)&_ZN6S236C43v84Ev,
  (VTBL_ENTRY)&_ZN6S236C43v85Ev,
  (VTBL_ENTRY)&_ZN6S236C43v86Ev,
  (VTBL_ENTRY)&_ZN6S236C43v87Ev,
  (VTBL_ENTRY)&_ZN6S236C43v88Ev,
  (VTBL_ENTRY)&_ZN6S236C43v89Ev,
  (VTBL_ENTRY)&_ZN6S236C43v90Ev,
  (VTBL_ENTRY)&_ZN6S236C43v91Ev,
  (VTBL_ENTRY)&_ZN6S236C43v92Ev,
  (VTBL_ENTRY)&_ZN6S236C43v93Ev,
  (VTBL_ENTRY)&_ZN6S236C43v94Ev,
  (VTBL_ENTRY)&_ZN6S236C43v95Ev,
  (VTBL_ENTRY)&_ZN6S236C33v96Ev,
  (VTBL_ENTRY)&_ZN6S236C33v97Ev,
  (VTBL_ENTRY)&_ZN6S236C33v98Ev,
  (VTBL_ENTRY)&_ZN6S236C33v99Ev,
  (VTBL_ENTRY)&_ZN6S236C34v100Ev,
  (VTBL_ENTRY)&_ZN6S236C34v101Ev,
  (VTBL_ENTRY)&_ZN6S236C34v102Ev,
  (VTBL_ENTRY)&_ZN6S236C34v103Ev,
  (VTBL_ENTRY)&_ZN6S236C34v104Ev,
  (VTBL_ENTRY)&_ZN6S236C34v105Ev,
  (VTBL_ENTRY)&_ZN6S236C34v106Ev,
  (VTBL_ENTRY)&_ZN6S236C34v107Ev,
  (VTBL_ENTRY)&_ZN6S236C34v108Ev,
  (VTBL_ENTRY)&_ZN6S236C34v109Ev,
  (VTBL_ENTRY)&_ZN6S236C34v110Ev,
  (VTBL_ENTRY)&_ZN6S236C34v111Ev,
  (VTBL_ENTRY)&_ZN6S236C34v112Ev,
  (VTBL_ENTRY)&_ZN6S236C34v113Ev,
  (VTBL_ENTRY)&_ZN6S236C34v114Ev,
  (VTBL_ENTRY)&_ZN6S236C34v115Ev,
  (VTBL_ENTRY)&_ZN6S236C34v116Ev,
  (VTBL_ENTRY)&_ZN6S236C34v117Ev,
  (VTBL_ENTRY)&_ZN6S236C34v118Ev,
  (VTBL_ENTRY)&_ZN6S236C34v119Ev,
  (VTBL_ENTRY)&_ZN6S236C34v120Ev,
  (VTBL_ENTRY)&_ZN6S236C34v121Ev,
  (VTBL_ENTRY)&_ZN6S236C34v122Ev,
  (VTBL_ENTRY)&_ZN6S236C34v123Ev,
  (VTBL_ENTRY)&_ZN6S236C34v124Ev,
  (VTBL_ENTRY)&_ZN6S236C34v125Ev,
  (VTBL_ENTRY)&_ZN6S236C34v126Ev,
  (VTBL_ENTRY)&_ZN6S236C34v127Ev,
  (VTBL_ENTRY)&_ZN6S236C34v128Ev,
  (VTBL_ENTRY)&_ZN6S236C34v129Ev,
  (VTBL_ENTRY)&_ZN6S236C34v130Ev,
  (VTBL_ENTRY)&_ZN6S236C34v131Ev,
  (VTBL_ENTRY)&_ZN6S236C34v132Ev,
  (VTBL_ENTRY)&_ZN6S236C34v133Ev,
  (VTBL_ENTRY)&_ZN6S236C34v134Ev,
  (VTBL_ENTRY)&_ZN6S236C34v135Ev,
  (VTBL_ENTRY)&_ZN6S236C34v136Ev,
  (VTBL_ENTRY)&_ZN6S236C34v137Ev,
  (VTBL_ENTRY)&_ZN6S236C34v138Ev,
  (VTBL_ENTRY)&_ZN6S236C34v139Ev,
  (VTBL_ENTRY)&_ZN6S236C34v140Ev,
  (VTBL_ENTRY)&_ZN6S236C34v141Ev,
  (VTBL_ENTRY)&_ZN6S236C34v142Ev,
  (VTBL_ENTRY)&_ZN6S236C34v143Ev,
  (VTBL_ENTRY)&_ZN6S236C34v144Ev,
  (VTBL_ENTRY)&_ZN6S236C34v145Ev,
  (VTBL_ENTRY)&_ZN6S236C34v146Ev,
  (VTBL_ENTRY)&_ZN6S236C34v147Ev,
  (VTBL_ENTRY)&_ZN6S236C34v148Ev,
  (VTBL_ENTRY)&_ZN6S236C34v149Ev,
  (VTBL_ENTRY)&_ZN6S236C34v150Ev,
  (VTBL_ENTRY)&_ZN6S236C34v151Ev,
  (VTBL_ENTRY)&_ZN6S236C34v152Ev,
  (VTBL_ENTRY)&_ZN6S236C34v153Ev,
  (VTBL_ENTRY)&_ZN6S236C34v154Ev,
  (VTBL_ENTRY)&_ZN6S236C34v155Ev,
  (VTBL_ENTRY)&_ZN6S236C34v156Ev,
};
extern VTBL_ENTRY _ZTI6S236C3[];
extern  VTBL_ENTRY _ZTV6S236C3[];
Class_Descriptor cd_S236C3 = {  "S236C3", // class name
  bases_S236C3, 3,
  &(vtc_S236C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S236C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S236C3),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C26  : S95C12_nt {
};
//SIG(-1 S236C26) C1{ BC2{ m Fp Fi[2]}}



static void Test_S236C26()
{
  extern Class_Descriptor cd_S236C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S236C26, buf);
    S236C26 &lv = *(new (buf) S236C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S236C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C26)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S236C26");
    test_class_info(&lv, &cd_S236C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C26(Test_S236C26, "S236C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S236C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S236C26 = {  "S236C26", // class name
  bases_S236C26, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C25_nt  : S236C26 {
};
//SIG(-1 S236C25_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S236C25_nt

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S236C26;
static Base_Class bases_S236C25_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S236C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C29_nt  {
  void *s236c29f0;
  ::S95C8_nt s236c29f1;
  void  mf236c29(); // _ZN10S236C29_nt8mf236c29Ev
};
//SIG(-1 S236C29_nt) C1{ m Fp FC2{ m Fi[2]}}


void  S236C29_nt ::mf236c29(){}

//skip512 S236C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C2  : S236C3 {
  void *s236c2f0;
  ::S95C31 s236c2f1;
  ::S95C27 s236c2f2;
  ::S95C17_nt s236c2f3;
  unsigned int s236c2f4:1;
  unsigned int s236c2f5:1;
  unsigned int s236c2f6:1;
  unsigned int s236c2f7:1;
  unsigned int s236c2f8:1;
  unsigned int s236c2f9:1;
  unsigned int s236c2f10:1;
  unsigned int s236c2f11:1;
  unsigned int s236c2f12:1;
  unsigned int s236c2f13:1;
  unsigned int s236c2f14:1;
  unsigned int s236c2f15:1;
  unsigned int s236c2f16:1;
  unsigned int s236c2f17:1;
  unsigned int s236c2f18:1;
  unsigned int s236c2f19:1;
  unsigned int s236c2f20:1;
  ::S236C25_nt s236c2f21;
  ::S95C14_nt s236c2f22;
  ::S95C14_nt s236c2f23;
  int s236c2f24[5];
  char s236c2f25;
  ::S236C25_nt s236c2f26;
  ::S236C29_nt s236c2f27;
  virtual  ~S236C2(); // _ZN6S236C2D1Ev
  virtual void  v157(); // _ZN6S236C24v157Ev
  virtual void  v158(); // _ZN6S236C24v158Ev
  virtual void  v159(); // _ZN6S236C24v159Ev
  virtual void  v160(); // _ZN6S236C24v160Ev
  virtual void  v161(); // _ZN6S236C24v161Ev
  virtual void  v162(); // _ZN6S236C24v162Ev
  virtual void  v163(); // _ZN6S236C24v163Ev
  virtual void  v164(); // _ZN6S236C24v164Ev
  virtual void  v165(); // _ZN6S236C24v165Ev
  virtual void  v166(); // _ZN6S236C24v166Ev
  virtual void  v167(); // _ZN6S236C24v167Ev
  virtual void  v168(); // _ZN6S236C24v168Ev
  virtual void  v169(); // _ZN6S236C24v169Ev
  virtual void  v170(); // _ZN6S236C24v170Ev
  virtual void  v171(); // _ZN6S236C24v171Ev
  virtual void  v172(); // _ZN6S236C24v172Ev
  virtual void  v173(); // _ZN6S236C24v173Ev
  virtual void  v174(); // _ZN6S236C24v174Ev
  virtual void  v175(); // _ZN6S236C24v175Ev
  virtual void  v176(); // _ZN6S236C24v176Ev
  virtual void  v177(); // _ZN6S236C24v177Ev
  virtual void  v178(); // _ZN6S236C24v178Ev
  virtual void  v179(); // _ZN6S236C24v179Ev
  virtual void  v180(); // _ZN6S236C24v180Ev
  virtual void  v181(); // _ZN6S236C24v181Ev
  virtual void  v182(); // _ZN6S236C24v182Ev
  virtual void  v183(); // _ZN6S236C24v183Ev
  virtual void  v184(); // _ZN6S236C24v184Ev
  virtual void  v185(); // _ZN6S236C24v185Ev
  virtual void  v186(); // _ZN6S236C24v186Ev
  virtual void  v187(); // _ZN6S236C24v187Ev
  virtual void  v188(); // _ZN6S236C24v188Ev
  virtual void  v189(); // _ZN6S236C24v189Ev
  S236C2(); // tgen
};
//SIG(-1 S236C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v98 v99 v100 v101 v102 Fp FC6} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC16{ BC10}} Fp[2] Fc FC8 FC12 FC17{ m Fi[3]} Fi FC12 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC18{ BC19{ BC10}} FC20{ BC21{ BC10}} FC22{ BC23{ BC10}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC24{ BC25{ BC10}} FC12 FC12 Fi[5] Fc FC24 FC26{ m Fp FC6}}


 S236C2 ::~S236C2(){ note_dtor("S236C2", this);}
void  S236C2 ::v157(){vfunc_called(this, "_ZN6S236C24v157Ev");}
void  S236C2 ::v158(){vfunc_called(this, "_ZN6S236C24v158Ev");}
void  S236C2 ::v159(){vfunc_called(this, "_ZN6S236C24v159Ev");}
void  S236C2 ::v160(){vfunc_called(this, "_ZN6S236C24v160Ev");}
void  S236C2 ::v161(){vfunc_called(this, "_ZN6S236C24v161Ev");}
void  S236C2 ::v162(){vfunc_called(this, "_ZN6S236C24v162Ev");}
void  S236C2 ::v163(){vfunc_called(this, "_ZN6S236C24v163Ev");}
void  S236C2 ::v164(){vfunc_called(this, "_ZN6S236C24v164Ev");}
void  S236C2 ::v165(){vfunc_called(this, "_ZN6S236C24v165Ev");}
void  S236C2 ::v166(){vfunc_called(this, "_ZN6S236C24v166Ev");}
void  S236C2 ::v167(){vfunc_called(this, "_ZN6S236C24v167Ev");}
void  S236C2 ::v168(){vfunc_called(this, "_ZN6S236C24v168Ev");}
void  S236C2 ::v169(){vfunc_called(this, "_ZN6S236C24v169Ev");}
void  S236C2 ::v170(){vfunc_called(this, "_ZN6S236C24v170Ev");}
void  S236C2 ::v171(){vfunc_called(this, "_ZN6S236C24v171Ev");}
void  S236C2 ::v172(){vfunc_called(this, "_ZN6S236C24v172Ev");}
void  S236C2 ::v173(){vfunc_called(this, "_ZN6S236C24v173Ev");}
void  S236C2 ::v174(){vfunc_called(this, "_ZN6S236C24v174Ev");}
void  S236C2 ::v175(){vfunc_called(this, "_ZN6S236C24v175Ev");}
void  S236C2 ::v176(){vfunc_called(this, "_ZN6S236C24v176Ev");}
void  S236C2 ::v177(){vfunc_called(this, "_ZN6S236C24v177Ev");}
void  S236C2 ::v178(){vfunc_called(this, "_ZN6S236C24v178Ev");}
void  S236C2 ::v179(){vfunc_called(this, "_ZN6S236C24v179Ev");}
void  S236C2 ::v180(){vfunc_called(this, "_ZN6S236C24v180Ev");}
void  S236C2 ::v181(){vfunc_called(this, "_ZN6S236C24v181Ev");}
void  S236C2 ::v182(){vfunc_called(this, "_ZN6S236C24v182Ev");}
void  S236C2 ::v183(){vfunc_called(this, "_ZN6S236C24v183Ev");}
void  S236C2 ::v184(){vfunc_called(this, "_ZN6S236C24v184Ev");}
void  S236C2 ::v185(){vfunc_called(this, "_ZN6S236C24v185Ev");}
void  S236C2 ::v186(){vfunc_called(this, "_ZN6S236C24v186Ev");}
void  S236C2 ::v187(){vfunc_called(this, "_ZN6S236C24v187Ev");}
void  S236C2 ::v188(){vfunc_called(this, "_ZN6S236C24v188Ev");}
void  S236C2 ::v189(){vfunc_called(this, "_ZN6S236C24v189Ev");}
S236C2 ::S236C2(){ note_ctor("S236C2", this);} // tgen

static void Test_S236C2()
{
  extern Class_Descriptor cd_S236C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(67,101)];
    init_test(&cd_S236C2, buf);
    S236C2 *dp, &lv = *(dp=new (buf) S236C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,400), "sizeof(S236C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C2)");
    check_base_class_offset(lv, (S236C6*)(S236C5*)(S236C4*)(S236C3*), 0, "S236C2");
    check_base_class_offset(lv, (S236C5*)(S236C4*)(S236C3*), 0, "S236C2");
    check_base_class_offset(lv, (S236C4*)(S236C3*), 0, "S236C2");
    check_base_class_offset(lv, (S236C3*), 0, "S236C2");
    check_field_offset(lv, s236c2f0, ABISELECT(368,272), "S236C2.s236c2f0");
    check_field_offset(lv, s236c2f1, ABISELECT(376,276), "S236C2.s236c2f1");
    check_field_offset(lv, s236c2f2, ABISELECT(392,288), "S236C2.s236c2f2");
    check_field_offset(lv, s236c2f3, ABISELECT(408,300), "S236C2.s236c2f3");
    set_bf_and_test(lv, s236c2f4, ABISELECT(424,312), 0, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f5, ABISELECT(424,312), 1, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f6, ABISELECT(424,312), 2, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f7, ABISELECT(424,312), 3, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f8, ABISELECT(424,312), 4, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f9, ABISELECT(424,312), 5, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f10, ABISELECT(424,312), 6, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f11, ABISELECT(424,312), 7, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f12, ABISELECT(425,313), 0, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f13, ABISELECT(425,313), 1, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f14, ABISELECT(425,313), 2, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f15, ABISELECT(425,313), 3, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f16, ABISELECT(425,313), 4, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f17, ABISELECT(425,313), 5, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f18, ABISELECT(425,313), 6, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f19, ABISELECT(425,313), 7, 1, 1, "S236C2");
    set_bf_and_test(lv, s236c2f20, ABISELECT(426,314), 0, 1, 1, "S236C2");
    check_field_offset(lv, s236c2f21, ABISELECT(432,316), "S236C2.s236c2f21");
    check_field_offset(lv, s236c2f22, ABISELECT(448,328), "S236C2.s236c2f22");
    check_field_offset(lv, s236c2f23, ABISELECT(460,340), "S236C2.s236c2f23");
    check_field_offset(lv, s236c2f24, ABISELECT(472,352), "S236C2.s236c2f24");
    check_field_offset(lv, s236c2f25, ABISELECT(492,372), "S236C2.s236c2f25");
    check_field_offset(lv, s236c2f26, ABISELECT(496,376), "S236C2.s236c2f26");
    check_field_offset(lv, s236c2f27, ABISELECT(512,388), "S236C2.s236c2f27");
    test_class_info(&lv, &cd_S236C2);
    dp->~S236C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C2(Test_S236C2, "S236C2", ABISELECT(528,400));

#else // __cplusplus

extern void _ZN6S236C2C1Ev();
extern void _ZN6S236C2D1Ev();
Name_Map name_map_S236C2[] = {
  NSPAIR(_ZN6S236C2C1Ev),
  NSPAIR(_ZN6S236C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S236C6;
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
extern Class_Descriptor cd_S236C5;
extern VTBL_ENTRY _ZTI6S236C5[];
extern  VTBL_ENTRY _ZTV6S236C5[];
extern Class_Descriptor cd_S236C4;
extern VTBL_ENTRY _ZTI6S236C4[];
extern  VTBL_ENTRY _ZTV6S236C4[];
extern Class_Descriptor cd_S236C3;
extern VTBL_ENTRY _ZTI6S236C3[];
extern  VTBL_ENTRY _ZTV6S236C3[];
static Base_Class bases_S236C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S236C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S236C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S236C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S236C2[];
extern void _ZN6S236C2D1Ev();
extern void _ZN6S236C2D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
extern void _ZN6S236C53v69Ev();
extern void _ZN6S236C53v70Ev();
extern void _ZN6S236C53v71Ev();
extern void _ZN6S236C53v72Ev();
extern void _ZN6S236C53v73Ev();
extern void _ZN6S236C43v74Ev();
extern void _ZN6S236C43v75Ev();
extern void _ZN6S236C43v76Ev();
extern void _ZN6S236C43v77Ev();
extern void _ZN6S236C43v78Ev();
extern void _ZN6S236C43v79Ev();
extern void _ZN6S236C43v80Ev();
extern void _ZN6S236C43v81Ev();
extern void _ZN6S236C43v82Ev();
extern void _ZN6S236C43v83Ev();
extern void _ZN6S236C43v84Ev();
extern void _ZN6S236C43v85Ev();
extern void _ZN6S236C43v86Ev();
extern void _ZN6S236C43v87Ev();
extern void _ZN6S236C43v88Ev();
extern void _ZN6S236C43v89Ev();
extern void _ZN6S236C43v90Ev();
extern void _ZN6S236C43v91Ev();
extern void _ZN6S236C43v92Ev();
extern void _ZN6S236C43v93Ev();
extern void _ZN6S236C43v94Ev();
extern void _ZN6S236C43v95Ev();
extern void _ZN6S236C33v96Ev();
extern void _ZN6S236C33v97Ev();
extern void _ZN6S236C33v98Ev();
extern void _ZN6S236C33v99Ev();
extern void _ZN6S236C34v100Ev();
extern void _ZN6S236C34v101Ev();
extern void _ZN6S236C34v102Ev();
extern void _ZN6S236C34v103Ev();
extern void _ZN6S236C34v104Ev();
extern void _ZN6S236C34v105Ev();
extern void _ZN6S236C34v106Ev();
extern void _ZN6S236C34v107Ev();
extern void _ZN6S236C34v108Ev();
extern void _ZN6S236C34v109Ev();
extern void _ZN6S236C34v110Ev();
extern void _ZN6S236C34v111Ev();
extern void _ZN6S236C34v112Ev();
extern void _ZN6S236C34v113Ev();
extern void _ZN6S236C34v114Ev();
extern void _ZN6S236C34v115Ev();
extern void _ZN6S236C34v116Ev();
extern void _ZN6S236C34v117Ev();
extern void _ZN6S236C34v118Ev();
extern void _ZN6S236C34v119Ev();
extern void _ZN6S236C34v120Ev();
extern void _ZN6S236C34v121Ev();
extern void _ZN6S236C34v122Ev();
extern void _ZN6S236C34v123Ev();
extern void _ZN6S236C34v124Ev();
extern void _ZN6S236C34v125Ev();
extern void _ZN6S236C34v126Ev();
extern void _ZN6S236C34v127Ev();
extern void _ZN6S236C34v128Ev();
extern void _ZN6S236C34v129Ev();
extern void _ZN6S236C34v130Ev();
extern void _ZN6S236C34v131Ev();
extern void _ZN6S236C34v132Ev();
extern void _ZN6S236C34v133Ev();
extern void _ZN6S236C34v134Ev();
extern void _ZN6S236C34v135Ev();
extern void _ZN6S236C34v136Ev();
extern void _ZN6S236C34v137Ev();
extern void _ZN6S236C34v138Ev();
extern void _ZN6S236C34v139Ev();
extern void _ZN6S236C34v140Ev();
extern void _ZN6S236C34v141Ev();
extern void _ZN6S236C34v142Ev();
extern void _ZN6S236C34v143Ev();
extern void _ZN6S236C34v144Ev();
extern void _ZN6S236C34v145Ev();
extern void _ZN6S236C34v146Ev();
extern void _ZN6S236C34v147Ev();
extern void _ZN6S236C34v148Ev();
extern void _ZN6S236C34v149Ev();
extern void _ZN6S236C34v150Ev();
extern void _ZN6S236C34v151Ev();
extern void _ZN6S236C34v152Ev();
extern void _ZN6S236C34v153Ev();
extern void _ZN6S236C34v154Ev();
extern void _ZN6S236C34v155Ev();
extern void _ZN6S236C34v156Ev();
extern void _ZN6S236C24v157Ev();
extern void _ZN6S236C24v158Ev();
extern void _ZN6S236C24v159Ev();
extern void _ZN6S236C24v160Ev();
extern void _ZN6S236C24v161Ev();
extern void _ZN6S236C24v162Ev();
extern void _ZN6S236C24v163Ev();
extern void _ZN6S236C24v164Ev();
extern void _ZN6S236C24v165Ev();
extern void _ZN6S236C24v166Ev();
extern void _ZN6S236C24v167Ev();
extern void _ZN6S236C24v168Ev();
extern void _ZN6S236C24v169Ev();
extern void _ZN6S236C24v170Ev();
extern void _ZN6S236C24v171Ev();
extern void _ZN6S236C24v172Ev();
extern void _ZN6S236C24v173Ev();
extern void _ZN6S236C24v174Ev();
extern void _ZN6S236C24v175Ev();
extern void _ZN6S236C24v176Ev();
extern void _ZN6S236C24v177Ev();
extern void _ZN6S236C24v178Ev();
extern void _ZN6S236C24v179Ev();
extern void _ZN6S236C24v180Ev();
extern void _ZN6S236C24v181Ev();
extern void _ZN6S236C24v182Ev();
extern void _ZN6S236C24v183Ev();
extern void _ZN6S236C24v184Ev();
extern void _ZN6S236C24v185Ev();
extern void _ZN6S236C24v186Ev();
extern void _ZN6S236C24v187Ev();
extern void _ZN6S236C24v188Ev();
extern void _ZN6S236C24v189Ev();
static  VTBL_ENTRY vtc_S236C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C2[0]),
  (VTBL_ENTRY)&_ZN6S236C2D1Ev,
  (VTBL_ENTRY)&_ZN6S236C2D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
  (VTBL_ENTRY)&_ZN6S236C53v69Ev,
  (VTBL_ENTRY)&_ZN6S236C53v70Ev,
  (VTBL_ENTRY)&_ZN6S236C53v71Ev,
  (VTBL_ENTRY)&_ZN6S236C53v72Ev,
  (VTBL_ENTRY)&_ZN6S236C53v73Ev,
  (VTBL_ENTRY)&_ZN6S236C43v74Ev,
  (VTBL_ENTRY)&_ZN6S236C43v75Ev,
  (VTBL_ENTRY)&_ZN6S236C43v76Ev,
  (VTBL_ENTRY)&_ZN6S236C43v77Ev,
  (VTBL_ENTRY)&_ZN6S236C43v78Ev,
  (VTBL_ENTRY)&_ZN6S236C43v79Ev,
  (VTBL_ENTRY)&_ZN6S236C43v80Ev,
  (VTBL_ENTRY)&_ZN6S236C43v81Ev,
  (VTBL_ENTRY)&_ZN6S236C43v82Ev,
  (VTBL_ENTRY)&_ZN6S236C43v83Ev,
  (VTBL_ENTRY)&_ZN6S236C43v84Ev,
  (VTBL_ENTRY)&_ZN6S236C43v85Ev,
  (VTBL_ENTRY)&_ZN6S236C43v86Ev,
  (VTBL_ENTRY)&_ZN6S236C43v87Ev,
  (VTBL_ENTRY)&_ZN6S236C43v88Ev,
  (VTBL_ENTRY)&_ZN6S236C43v89Ev,
  (VTBL_ENTRY)&_ZN6S236C43v90Ev,
  (VTBL_ENTRY)&_ZN6S236C43v91Ev,
  (VTBL_ENTRY)&_ZN6S236C43v92Ev,
  (VTBL_ENTRY)&_ZN6S236C43v93Ev,
  (VTBL_ENTRY)&_ZN6S236C43v94Ev,
  (VTBL_ENTRY)&_ZN6S236C43v95Ev,
  (VTBL_ENTRY)&_ZN6S236C33v96Ev,
  (VTBL_ENTRY)&_ZN6S236C33v97Ev,
  (VTBL_ENTRY)&_ZN6S236C33v98Ev,
  (VTBL_ENTRY)&_ZN6S236C33v99Ev,
  (VTBL_ENTRY)&_ZN6S236C34v100Ev,
  (VTBL_ENTRY)&_ZN6S236C34v101Ev,
  (VTBL_ENTRY)&_ZN6S236C34v102Ev,
  (VTBL_ENTRY)&_ZN6S236C34v103Ev,
  (VTBL_ENTRY)&_ZN6S236C34v104Ev,
  (VTBL_ENTRY)&_ZN6S236C34v105Ev,
  (VTBL_ENTRY)&_ZN6S236C34v106Ev,
  (VTBL_ENTRY)&_ZN6S236C34v107Ev,
  (VTBL_ENTRY)&_ZN6S236C34v108Ev,
  (VTBL_ENTRY)&_ZN6S236C34v109Ev,
  (VTBL_ENTRY)&_ZN6S236C34v110Ev,
  (VTBL_ENTRY)&_ZN6S236C34v111Ev,
  (VTBL_ENTRY)&_ZN6S236C34v112Ev,
  (VTBL_ENTRY)&_ZN6S236C34v113Ev,
  (VTBL_ENTRY)&_ZN6S236C34v114Ev,
  (VTBL_ENTRY)&_ZN6S236C34v115Ev,
  (VTBL_ENTRY)&_ZN6S236C34v116Ev,
  (VTBL_ENTRY)&_ZN6S236C34v117Ev,
  (VTBL_ENTRY)&_ZN6S236C34v118Ev,
  (VTBL_ENTRY)&_ZN6S236C34v119Ev,
  (VTBL_ENTRY)&_ZN6S236C34v120Ev,
  (VTBL_ENTRY)&_ZN6S236C34v121Ev,
  (VTBL_ENTRY)&_ZN6S236C34v122Ev,
  (VTBL_ENTRY)&_ZN6S236C34v123Ev,
  (VTBL_ENTRY)&_ZN6S236C34v124Ev,
  (VTBL_ENTRY)&_ZN6S236C34v125Ev,
  (VTBL_ENTRY)&_ZN6S236C34v126Ev,
  (VTBL_ENTRY)&_ZN6S236C34v127Ev,
  (VTBL_ENTRY)&_ZN6S236C34v128Ev,
  (VTBL_ENTRY)&_ZN6S236C34v129Ev,
  (VTBL_ENTRY)&_ZN6S236C34v130Ev,
  (VTBL_ENTRY)&_ZN6S236C34v131Ev,
  (VTBL_ENTRY)&_ZN6S236C34v132Ev,
  (VTBL_ENTRY)&_ZN6S236C34v133Ev,
  (VTBL_ENTRY)&_ZN6S236C34v134Ev,
  (VTBL_ENTRY)&_ZN6S236C34v135Ev,
  (VTBL_ENTRY)&_ZN6S236C34v136Ev,
  (VTBL_ENTRY)&_ZN6S236C34v137Ev,
  (VTBL_ENTRY)&_ZN6S236C34v138Ev,
  (VTBL_ENTRY)&_ZN6S236C34v139Ev,
  (VTBL_ENTRY)&_ZN6S236C34v140Ev,
  (VTBL_ENTRY)&_ZN6S236C34v141Ev,
  (VTBL_ENTRY)&_ZN6S236C34v142Ev,
  (VTBL_ENTRY)&_ZN6S236C34v143Ev,
  (VTBL_ENTRY)&_ZN6S236C34v144Ev,
  (VTBL_ENTRY)&_ZN6S236C34v145Ev,
  (VTBL_ENTRY)&_ZN6S236C34v146Ev,
  (VTBL_ENTRY)&_ZN6S236C34v147Ev,
  (VTBL_ENTRY)&_ZN6S236C34v148Ev,
  (VTBL_ENTRY)&_ZN6S236C34v149Ev,
  (VTBL_ENTRY)&_ZN6S236C34v150Ev,
  (VTBL_ENTRY)&_ZN6S236C34v151Ev,
  (VTBL_ENTRY)&_ZN6S236C34v152Ev,
  (VTBL_ENTRY)&_ZN6S236C34v153Ev,
  (VTBL_ENTRY)&_ZN6S236C34v154Ev,
  (VTBL_ENTRY)&_ZN6S236C34v155Ev,
  (VTBL_ENTRY)&_ZN6S236C34v156Ev,
  (VTBL_ENTRY)&_ZN6S236C24v157Ev,
  (VTBL_ENTRY)&_ZN6S236C24v158Ev,
  (VTBL_ENTRY)&_ZN6S236C24v159Ev,
  (VTBL_ENTRY)&_ZN6S236C24v160Ev,
  (VTBL_ENTRY)&_ZN6S236C24v161Ev,
  (VTBL_ENTRY)&_ZN6S236C24v162Ev,
  (VTBL_ENTRY)&_ZN6S236C24v163Ev,
  (VTBL_ENTRY)&_ZN6S236C24v164Ev,
  (VTBL_ENTRY)&_ZN6S236C24v165Ev,
  (VTBL_ENTRY)&_ZN6S236C24v166Ev,
  (VTBL_ENTRY)&_ZN6S236C24v167Ev,
  (VTBL_ENTRY)&_ZN6S236C24v168Ev,
  (VTBL_ENTRY)&_ZN6S236C24v169Ev,
  (VTBL_ENTRY)&_ZN6S236C24v170Ev,
  (VTBL_ENTRY)&_ZN6S236C24v171Ev,
  (VTBL_ENTRY)&_ZN6S236C24v172Ev,
  (VTBL_ENTRY)&_ZN6S236C24v173Ev,
  (VTBL_ENTRY)&_ZN6S236C24v174Ev,
  (VTBL_ENTRY)&_ZN6S236C24v175Ev,
  (VTBL_ENTRY)&_ZN6S236C24v176Ev,
  (VTBL_ENTRY)&_ZN6S236C24v177Ev,
  (VTBL_ENTRY)&_ZN6S236C24v178Ev,
  (VTBL_ENTRY)&_ZN6S236C24v179Ev,
  (VTBL_ENTRY)&_ZN6S236C24v180Ev,
  (VTBL_ENTRY)&_ZN6S236C24v181Ev,
  (VTBL_ENTRY)&_ZN6S236C24v182Ev,
  (VTBL_ENTRY)&_ZN6S236C24v183Ev,
  (VTBL_ENTRY)&_ZN6S236C24v184Ev,
  (VTBL_ENTRY)&_ZN6S236C24v185Ev,
  (VTBL_ENTRY)&_ZN6S236C24v186Ev,
  (VTBL_ENTRY)&_ZN6S236C24v187Ev,
  (VTBL_ENTRY)&_ZN6S236C24v188Ev,
  (VTBL_ENTRY)&_ZN6S236C24v189Ev,
};
extern VTBL_ENTRY _ZTI6S236C2[];
extern  VTBL_ENTRY _ZTV6S236C2[];
Class_Descriptor cd_S236C2 = {  "S236C2", // class name
  bases_S236C2, 4,
  &(vtc_S236C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(528,400), // object size
  NSPAIRA(_ZTI6S236C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S236C2),189, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S236C1  : S236C2 {
  int s236c1f0;
  unsigned int s236c1f1:1;
  ::S95C14_nt s236c1f2;
  virtual  ~S236C1(); // _ZN6S236C1D1Ev
  virtual void  v1(); // _ZN6S236C12v1Ev
  virtual void  v2(); // _ZN6S236C12v2Ev
  virtual void  v3(); // _ZN6S236C12v3Ev
  virtual void  v4(); // _ZN6S236C12v4Ev
  S236C1(); // tgen
};
//SIG(1 S236C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC7} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC8{ m Fi} Fi FC9{ m} Fi FC10{ BC11{ m Fp Fi[2]}} Fi Fp[2] FC12{ m FC13{ m Fi[3]} FC13 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC15{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC11}} Fp[2] Fc FC9 FC13 FC18{ m Fi[3]} Fi FC13 Fi:1 Fi:1 Fi:1 Fi[3]} vd v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 Fp FC19{ BC20{ BC11}} FC21{ BC22{ BC11}} FC23{ BC24{ BC11}} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC25{ BC26{ BC11}} FC13 FC13 Fi[5] Fc FC25 FC27{ m Fp FC7}} vd v1 v2 v3 v4 Fi Fi:1 FC13}


 S236C1 ::~S236C1(){ note_dtor("S236C1", this);}
void  S236C1 ::v1(){vfunc_called(this, "_ZN6S236C12v1Ev");}
void  S236C1 ::v2(){vfunc_called(this, "_ZN6S236C12v2Ev");}
void  S236C1 ::v3(){vfunc_called(this, "_ZN6S236C12v3Ev");}
void  S236C1 ::v4(){vfunc_called(this, "_ZN6S236C12v4Ev");}
S236C1 ::S236C1(){ note_ctor("S236C1", this);} // tgen

static void Test_S236C1()
{
  extern Class_Descriptor cd_S236C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(70,106)];
    init_test(&cd_S236C1, buf);
    S236C1 *dp, &lv = *(dp=new (buf) S236C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(552,420), "sizeof(S236C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S236C1)");
    check_base_class_offset(lv, (S236C6*)(S236C5*)(S236C4*)(S236C3*)(S236C2*), 0, "S236C1");
    check_base_class_offset(lv, (S236C5*)(S236C4*)(S236C3*)(S236C2*), 0, "S236C1");
    check_base_class_offset(lv, (S236C4*)(S236C3*)(S236C2*), 0, "S236C1");
    check_base_class_offset(lv, (S236C3*)(S236C2*), 0, "S236C1");
    check_base_class_offset(lv, (S236C2*), 0, "S236C1");
    check_field_offset(lv, s236c1f0, ABISELECT(528,400), "S236C1.s236c1f0");
    set_bf_and_test(lv, s236c1f1, ABISELECT(532,404), 0, 1, 1, "S236C1");
    check_field_offset(lv, s236c1f2, ABISELECT(536,408), "S236C1.s236c1f2");
    test_class_info(&lv, &cd_S236C1);
    dp->~S236C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS236C1(Test_S236C1, "S236C1", ABISELECT(552,420));

#else // __cplusplus

extern void _ZN6S236C1C1Ev();
extern void _ZN6S236C1D1Ev();
Name_Map name_map_S236C1[] = {
  NSPAIR(_ZN6S236C1C1Ev),
  NSPAIR(_ZN6S236C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S236C6;
extern VTBL_ENTRY _ZTI6S236C6[];
extern  VTBL_ENTRY _ZTV6S236C6[];
extern Class_Descriptor cd_S236C5;
extern VTBL_ENTRY _ZTI6S236C5[];
extern  VTBL_ENTRY _ZTV6S236C5[];
extern Class_Descriptor cd_S236C4;
extern VTBL_ENTRY _ZTI6S236C4[];
extern  VTBL_ENTRY _ZTV6S236C4[];
extern Class_Descriptor cd_S236C3;
extern VTBL_ENTRY _ZTI6S236C3[];
extern  VTBL_ENTRY _ZTV6S236C3[];
extern Class_Descriptor cd_S236C2;
extern VTBL_ENTRY _ZTI6S236C2[];
extern  VTBL_ENTRY _ZTV6S236C2[];
static Base_Class bases_S236C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S236C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S236C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S236C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S236C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S236C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S236C1[];
extern void _ZN6S236C1D1Ev();
extern void _ZN6S236C1D0Ev();
extern void _ZN6S236C62v5Ev();
extern void _ZN6S236C62v6Ev();
extern void _ZN6S236C62v7Ev();
extern void _ZN6S236C62v8Ev();
extern void _ZN6S236C62v9Ev();
extern void _ZN6S236C63v10Ev();
extern void _ZN6S236C63v11Ev();
extern void _ZN6S236C63v12Ev();
extern void _ZN6S236C63v13Ev();
extern void _ZN6S236C63v14Ev();
extern void _ZN6S236C63v15Ev();
extern void _ZN6S236C63v16Ev();
extern void _ZN6S236C63v17Ev();
extern void _ZN6S236C63v18Ev();
extern void _ZN6S236C63v19Ev();
extern void _ZN6S236C63v20Ev();
extern void _ZN6S236C63v21Ev();
extern void _ZN6S236C63v22Ev();
extern void _ZN6S236C63v23Ev();
extern void _ZN6S236C63v24Ev();
extern void _ZN6S236C63v25Ev();
extern void _ZN6S236C63v26Ev();
extern void _ZN6S236C63v27Ev();
extern void _ZN6S236C63v28Ev();
extern void _ZN6S236C63v29Ev();
extern void _ZN6S236C63v30Ev();
extern void _ZN6S236C63v31Ev();
extern void _ZN6S236C63v32Ev();
extern void _ZN6S236C63v33Ev();
extern void _ZN6S236C63v34Ev();
extern void _ZN6S236C63v35Ev();
extern void _ZN6S236C63v36Ev();
extern void _ZN6S236C63v37Ev();
extern void _ZN6S236C63v38Ev();
extern void _ZN6S236C63v39Ev();
extern void _ZN6S236C63v40Ev();
extern void _ZN6S236C63v41Ev();
extern void _ZN6S236C63v42Ev();
extern void _ZN6S236C63v43Ev();
extern void _ZN6S236C63v44Ev();
extern void _ZN6S236C63v45Ev();
extern void _ZN6S236C63v46Ev();
extern void _ZN6S236C63v47Ev();
extern void _ZN6S236C63v48Ev();
extern void _ZN6S236C63v49Ev();
extern void _ZN6S236C63v50Ev();
extern void _ZN6S236C63v51Ev();
extern void _ZN6S236C63v52Ev();
extern void _ZN6S236C63v53Ev();
extern void _ZN6S236C63v54Ev();
extern void _ZN6S236C63v55Ev();
extern void _ZN6S236C63v56Ev();
extern void _ZN6S236C63v57Ev();
extern void _ZN6S236C63v58Ev();
extern void _ZN6S236C63v59Ev();
extern void _ZN6S236C63v60Ev();
extern void _ZN6S236C63v61Ev();
extern void _ZN6S236C63v62Ev();
extern void _ZN6S236C63v63Ev();
extern void _ZN6S236C63v64Ev();
extern void _ZN6S236C63v65Ev();
extern void _ZN6S236C63v66Ev();
extern void _ZN6S236C63v67Ev();
extern void _ZN6S236C63v68Ev();
extern void _ZN6S236C53v69Ev();
extern void _ZN6S236C53v70Ev();
extern void _ZN6S236C53v71Ev();
extern void _ZN6S236C53v72Ev();
extern void _ZN6S236C53v73Ev();
extern void _ZN6S236C43v74Ev();
extern void _ZN6S236C43v75Ev();
extern void _ZN6S236C43v76Ev();
extern void _ZN6S236C43v77Ev();
extern void _ZN6S236C43v78Ev();
extern void _ZN6S236C43v79Ev();
extern void _ZN6S236C43v80Ev();
extern void _ZN6S236C43v81Ev();
extern void _ZN6S236C43v82Ev();
extern void _ZN6S236C43v83Ev();
extern void _ZN6S236C43v84Ev();
extern void _ZN6S236C43v85Ev();
extern void _ZN6S236C43v86Ev();
extern void _ZN6S236C43v87Ev();
extern void _ZN6S236C43v88Ev();
extern void _ZN6S236C43v89Ev();
extern void _ZN6S236C43v90Ev();
extern void _ZN6S236C43v91Ev();
extern void _ZN6S236C43v92Ev();
extern void _ZN6S236C43v93Ev();
extern void _ZN6S236C43v94Ev();
extern void _ZN6S236C43v95Ev();
extern void _ZN6S236C33v96Ev();
extern void _ZN6S236C33v97Ev();
extern void _ZN6S236C33v98Ev();
extern void _ZN6S236C33v99Ev();
extern void _ZN6S236C34v100Ev();
extern void _ZN6S236C34v101Ev();
extern void _ZN6S236C34v102Ev();
extern void _ZN6S236C34v103Ev();
extern void _ZN6S236C34v104Ev();
extern void _ZN6S236C34v105Ev();
extern void _ZN6S236C34v106Ev();
extern void _ZN6S236C34v107Ev();
extern void _ZN6S236C34v108Ev();
extern void _ZN6S236C34v109Ev();
extern void _ZN6S236C34v110Ev();
extern void _ZN6S236C34v111Ev();
extern void _ZN6S236C34v112Ev();
extern void _ZN6S236C34v113Ev();
extern void _ZN6S236C34v114Ev();
extern void _ZN6S236C34v115Ev();
extern void _ZN6S236C34v116Ev();
extern void _ZN6S236C34v117Ev();
extern void _ZN6S236C34v118Ev();
extern void _ZN6S236C34v119Ev();
extern void _ZN6S236C34v120Ev();
extern void _ZN6S236C34v121Ev();
extern void _ZN6S236C34v122Ev();
extern void _ZN6S236C34v123Ev();
extern void _ZN6S236C34v124Ev();
extern void _ZN6S236C34v125Ev();
extern void _ZN6S236C34v126Ev();
extern void _ZN6S236C34v127Ev();
extern void _ZN6S236C34v128Ev();
extern void _ZN6S236C34v129Ev();
extern void _ZN6S236C34v130Ev();
extern void _ZN6S236C34v131Ev();
extern void _ZN6S236C34v132Ev();
extern void _ZN6S236C34v133Ev();
extern void _ZN6S236C34v134Ev();
extern void _ZN6S236C34v135Ev();
extern void _ZN6S236C34v136Ev();
extern void _ZN6S236C34v137Ev();
extern void _ZN6S236C34v138Ev();
extern void _ZN6S236C34v139Ev();
extern void _ZN6S236C34v140Ev();
extern void _ZN6S236C34v141Ev();
extern void _ZN6S236C34v142Ev();
extern void _ZN6S236C34v143Ev();
extern void _ZN6S236C34v144Ev();
extern void _ZN6S236C34v145Ev();
extern void _ZN6S236C34v146Ev();
extern void _ZN6S236C34v147Ev();
extern void _ZN6S236C34v148Ev();
extern void _ZN6S236C34v149Ev();
extern void _ZN6S236C34v150Ev();
extern void _ZN6S236C34v151Ev();
extern void _ZN6S236C34v152Ev();
extern void _ZN6S236C34v153Ev();
extern void _ZN6S236C34v154Ev();
extern void _ZN6S236C34v155Ev();
extern void _ZN6S236C34v156Ev();
extern void _ZN6S236C24v157Ev();
extern void _ZN6S236C24v158Ev();
extern void _ZN6S236C24v159Ev();
extern void _ZN6S236C24v160Ev();
extern void _ZN6S236C24v161Ev();
extern void _ZN6S236C24v162Ev();
extern void _ZN6S236C24v163Ev();
extern void _ZN6S236C24v164Ev();
extern void _ZN6S236C24v165Ev();
extern void _ZN6S236C24v166Ev();
extern void _ZN6S236C24v167Ev();
extern void _ZN6S236C24v168Ev();
extern void _ZN6S236C24v169Ev();
extern void _ZN6S236C24v170Ev();
extern void _ZN6S236C24v171Ev();
extern void _ZN6S236C24v172Ev();
extern void _ZN6S236C24v173Ev();
extern void _ZN6S236C24v174Ev();
extern void _ZN6S236C24v175Ev();
extern void _ZN6S236C24v176Ev();
extern void _ZN6S236C24v177Ev();
extern void _ZN6S236C24v178Ev();
extern void _ZN6S236C24v179Ev();
extern void _ZN6S236C24v180Ev();
extern void _ZN6S236C24v181Ev();
extern void _ZN6S236C24v182Ev();
extern void _ZN6S236C24v183Ev();
extern void _ZN6S236C24v184Ev();
extern void _ZN6S236C24v185Ev();
extern void _ZN6S236C24v186Ev();
extern void _ZN6S236C24v187Ev();
extern void _ZN6S236C24v188Ev();
extern void _ZN6S236C24v189Ev();
extern void _ZN6S236C12v1Ev();
extern void _ZN6S236C12v2Ev();
extern void _ZN6S236C12v3Ev();
extern void _ZN6S236C12v4Ev();
static  VTBL_ENTRY vtc_S236C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S236C1[0]),
  (VTBL_ENTRY)&_ZN6S236C1D1Ev,
  (VTBL_ENTRY)&_ZN6S236C1D0Ev,
  (VTBL_ENTRY)&_ZN6S236C62v5Ev,
  (VTBL_ENTRY)&_ZN6S236C62v6Ev,
  (VTBL_ENTRY)&_ZN6S236C62v7Ev,
  (VTBL_ENTRY)&_ZN6S236C62v8Ev,
  (VTBL_ENTRY)&_ZN6S236C62v9Ev,
  (VTBL_ENTRY)&_ZN6S236C63v10Ev,
  (VTBL_ENTRY)&_ZN6S236C63v11Ev,
  (VTBL_ENTRY)&_ZN6S236C63v12Ev,
  (VTBL_ENTRY)&_ZN6S236C63v13Ev,
  (VTBL_ENTRY)&_ZN6S236C63v14Ev,
  (VTBL_ENTRY)&_ZN6S236C63v15Ev,
  (VTBL_ENTRY)&_ZN6S236C63v16Ev,
  (VTBL_ENTRY)&_ZN6S236C63v17Ev,
  (VTBL_ENTRY)&_ZN6S236C63v18Ev,
  (VTBL_ENTRY)&_ZN6S236C63v19Ev,
  (VTBL_ENTRY)&_ZN6S236C63v20Ev,
  (VTBL_ENTRY)&_ZN6S236C63v21Ev,
  (VTBL_ENTRY)&_ZN6S236C63v22Ev,
  (VTBL_ENTRY)&_ZN6S236C63v23Ev,
  (VTBL_ENTRY)&_ZN6S236C63v24Ev,
  (VTBL_ENTRY)&_ZN6S236C63v25Ev,
  (VTBL_ENTRY)&_ZN6S236C63v26Ev,
  (VTBL_ENTRY)&_ZN6S236C63v27Ev,
  (VTBL_ENTRY)&_ZN6S236C63v28Ev,
  (VTBL_ENTRY)&_ZN6S236C63v29Ev,
  (VTBL_ENTRY)&_ZN6S236C63v30Ev,
  (VTBL_ENTRY)&_ZN6S236C63v31Ev,
  (VTBL_ENTRY)&_ZN6S236C63v32Ev,
  (VTBL_ENTRY)&_ZN6S236C63v33Ev,
  (VTBL_ENTRY)&_ZN6S236C63v34Ev,
  (VTBL_ENTRY)&_ZN6S236C63v35Ev,
  (VTBL_ENTRY)&_ZN6S236C63v36Ev,
  (VTBL_ENTRY)&_ZN6S236C63v37Ev,
  (VTBL_ENTRY)&_ZN6S236C63v38Ev,
  (VTBL_ENTRY)&_ZN6S236C63v39Ev,
  (VTBL_ENTRY)&_ZN6S236C63v40Ev,
  (VTBL_ENTRY)&_ZN6S236C63v41Ev,
  (VTBL_ENTRY)&_ZN6S236C63v42Ev,
  (VTBL_ENTRY)&_ZN6S236C63v43Ev,
  (VTBL_ENTRY)&_ZN6S236C63v44Ev,
  (VTBL_ENTRY)&_ZN6S236C63v45Ev,
  (VTBL_ENTRY)&_ZN6S236C63v46Ev,
  (VTBL_ENTRY)&_ZN6S236C63v47Ev,
  (VTBL_ENTRY)&_ZN6S236C63v48Ev,
  (VTBL_ENTRY)&_ZN6S236C63v49Ev,
  (VTBL_ENTRY)&_ZN6S236C63v50Ev,
  (VTBL_ENTRY)&_ZN6S236C63v51Ev,
  (VTBL_ENTRY)&_ZN6S236C63v52Ev,
  (VTBL_ENTRY)&_ZN6S236C63v53Ev,
  (VTBL_ENTRY)&_ZN6S236C63v54Ev,
  (VTBL_ENTRY)&_ZN6S236C63v55Ev,
  (VTBL_ENTRY)&_ZN6S236C63v56Ev,
  (VTBL_ENTRY)&_ZN6S236C63v57Ev,
  (VTBL_ENTRY)&_ZN6S236C63v58Ev,
  (VTBL_ENTRY)&_ZN6S236C63v59Ev,
  (VTBL_ENTRY)&_ZN6S236C63v60Ev,
  (VTBL_ENTRY)&_ZN6S236C63v61Ev,
  (VTBL_ENTRY)&_ZN6S236C63v62Ev,
  (VTBL_ENTRY)&_ZN6S236C63v63Ev,
  (VTBL_ENTRY)&_ZN6S236C63v64Ev,
  (VTBL_ENTRY)&_ZN6S236C63v65Ev,
  (VTBL_ENTRY)&_ZN6S236C63v66Ev,
  (VTBL_ENTRY)&_ZN6S236C63v67Ev,
  (VTBL_ENTRY)&_ZN6S236C63v68Ev,
  (VTBL_ENTRY)&_ZN6S236C53v69Ev,
  (VTBL_ENTRY)&_ZN6S236C53v70Ev,
  (VTBL_ENTRY)&_ZN6S236C53v71Ev,
  (VTBL_ENTRY)&_ZN6S236C53v72Ev,
  (VTBL_ENTRY)&_ZN6S236C53v73Ev,
  (VTBL_ENTRY)&_ZN6S236C43v74Ev,
  (VTBL_ENTRY)&_ZN6S236C43v75Ev,
  (VTBL_ENTRY)&_ZN6S236C43v76Ev,
  (VTBL_ENTRY)&_ZN6S236C43v77Ev,
  (VTBL_ENTRY)&_ZN6S236C43v78Ev,
  (VTBL_ENTRY)&_ZN6S236C43v79Ev,
  (VTBL_ENTRY)&_ZN6S236C43v80Ev,
  (VTBL_ENTRY)&_ZN6S236C43v81Ev,
  (VTBL_ENTRY)&_ZN6S236C43v82Ev,
  (VTBL_ENTRY)&_ZN6S236C43v83Ev,
  (VTBL_ENTRY)&_ZN6S236C43v84Ev,
  (VTBL_ENTRY)&_ZN6S236C43v85Ev,
  (VTBL_ENTRY)&_ZN6S236C43v86Ev,
  (VTBL_ENTRY)&_ZN6S236C43v87Ev,
  (VTBL_ENTRY)&_ZN6S236C43v88Ev,
  (VTBL_ENTRY)&_ZN6S236C43v89Ev,
  (VTBL_ENTRY)&_ZN6S236C43v90Ev,
  (VTBL_ENTRY)&_ZN6S236C43v91Ev,
  (VTBL_ENTRY)&_ZN6S236C43v92Ev,
  (VTBL_ENTRY)&_ZN6S236C43v93Ev,
  (VTBL_ENTRY)&_ZN6S236C43v94Ev,
  (VTBL_ENTRY)&_ZN6S236C43v95Ev,
  (VTBL_ENTRY)&_ZN6S236C33v96Ev,
  (VTBL_ENTRY)&_ZN6S236C33v97Ev,
  (VTBL_ENTRY)&_ZN6S236C33v98Ev,
  (VTBL_ENTRY)&_ZN6S236C33v99Ev,
  (VTBL_ENTRY)&_ZN6S236C34v100Ev,
  (VTBL_ENTRY)&_ZN6S236C34v101Ev,
  (VTBL_ENTRY)&_ZN6S236C34v102Ev,
  (VTBL_ENTRY)&_ZN6S236C34v103Ev,
  (VTBL_ENTRY)&_ZN6S236C34v104Ev,
  (VTBL_ENTRY)&_ZN6S236C34v105Ev,
  (VTBL_ENTRY)&_ZN6S236C34v106Ev,
  (VTBL_ENTRY)&_ZN6S236C34v107Ev,
  (VTBL_ENTRY)&_ZN6S236C34v108Ev,
  (VTBL_ENTRY)&_ZN6S236C34v109Ev,
  (VTBL_ENTRY)&_ZN6S236C34v110Ev,
  (VTBL_ENTRY)&_ZN6S236C34v111Ev,
  (VTBL_ENTRY)&_ZN6S236C34v112Ev,
  (VTBL_ENTRY)&_ZN6S236C34v113Ev,
  (VTBL_ENTRY)&_ZN6S236C34v114Ev,
  (VTBL_ENTRY)&_ZN6S236C34v115Ev,
  (VTBL_ENTRY)&_ZN6S236C34v116Ev,
  (VTBL_ENTRY)&_ZN6S236C34v117Ev,
  (VTBL_ENTRY)&_ZN6S236C34v118Ev,
  (VTBL_ENTRY)&_ZN6S236C34v119Ev,
  (VTBL_ENTRY)&_ZN6S236C34v120Ev,
  (VTBL_ENTRY)&_ZN6S236C34v121Ev,
  (VTBL_ENTRY)&_ZN6S236C34v122Ev,
  (VTBL_ENTRY)&_ZN6S236C34v123Ev,
  (VTBL_ENTRY)&_ZN6S236C34v124Ev,
  (VTBL_ENTRY)&_ZN6S236C34v125Ev,
  (VTBL_ENTRY)&_ZN6S236C34v126Ev,
  (VTBL_ENTRY)&_ZN6S236C34v127Ev,
  (VTBL_ENTRY)&_ZN6S236C34v128Ev,
  (VTBL_ENTRY)&_ZN6S236C34v129Ev,
  (VTBL_ENTRY)&_ZN6S236C34v130Ev,
  (VTBL_ENTRY)&_ZN6S236C34v131Ev,
  (VTBL_ENTRY)&_ZN6S236C34v132Ev,
  (VTBL_ENTRY)&_ZN6S236C34v133Ev,
  (VTBL_ENTRY)&_ZN6S236C34v134Ev,
  (VTBL_ENTRY)&_ZN6S236C34v135Ev,
  (VTBL_ENTRY)&_ZN6S236C34v136Ev,
  (VTBL_ENTRY)&_ZN6S236C34v137Ev,
  (VTBL_ENTRY)&_ZN6S236C34v138Ev,
  (VTBL_ENTRY)&_ZN6S236C34v139Ev,
  (VTBL_ENTRY)&_ZN6S236C34v140Ev,
  (VTBL_ENTRY)&_ZN6S236C34v141Ev,
  (VTBL_ENTRY)&_ZN6S236C34v142Ev,
  (VTBL_ENTRY)&_ZN6S236C34v143Ev,
  (VTBL_ENTRY)&_ZN6S236C34v144Ev,
  (VTBL_ENTRY)&_ZN6S236C34v145Ev,
  (VTBL_ENTRY)&_ZN6S236C34v146Ev,
  (VTBL_ENTRY)&_ZN6S236C34v147Ev,
  (VTBL_ENTRY)&_ZN6S236C34v148Ev,
  (VTBL_ENTRY)&_ZN6S236C34v149Ev,
  (VTBL_ENTRY)&_ZN6S236C34v150Ev,
  (VTBL_ENTRY)&_ZN6S236C34v151Ev,
  (VTBL_ENTRY)&_ZN6S236C34v152Ev,
  (VTBL_ENTRY)&_ZN6S236C34v153Ev,
  (VTBL_ENTRY)&_ZN6S236C34v154Ev,
  (VTBL_ENTRY)&_ZN6S236C34v155Ev,
  (VTBL_ENTRY)&_ZN6S236C34v156Ev,
  (VTBL_ENTRY)&_ZN6S236C24v157Ev,
  (VTBL_ENTRY)&_ZN6S236C24v158Ev,
  (VTBL_ENTRY)&_ZN6S236C24v159Ev,
  (VTBL_ENTRY)&_ZN6S236C24v160Ev,
  (VTBL_ENTRY)&_ZN6S236C24v161Ev,
  (VTBL_ENTRY)&_ZN6S236C24v162Ev,
  (VTBL_ENTRY)&_ZN6S236C24v163Ev,
  (VTBL_ENTRY)&_ZN6S236C24v164Ev,
  (VTBL_ENTRY)&_ZN6S236C24v165Ev,
  (VTBL_ENTRY)&_ZN6S236C24v166Ev,
  (VTBL_ENTRY)&_ZN6S236C24v167Ev,
  (VTBL_ENTRY)&_ZN6S236C24v168Ev,
  (VTBL_ENTRY)&_ZN6S236C24v169Ev,
  (VTBL_ENTRY)&_ZN6S236C24v170Ev,
  (VTBL_ENTRY)&_ZN6S236C24v171Ev,
  (VTBL_ENTRY)&_ZN6S236C24v172Ev,
  (VTBL_ENTRY)&_ZN6S236C24v173Ev,
  (VTBL_ENTRY)&_ZN6S236C24v174Ev,
  (VTBL_ENTRY)&_ZN6S236C24v175Ev,
  (VTBL_ENTRY)&_ZN6S236C24v176Ev,
  (VTBL_ENTRY)&_ZN6S236C24v177Ev,
  (VTBL_ENTRY)&_ZN6S236C24v178Ev,
  (VTBL_ENTRY)&_ZN6S236C24v179Ev,
  (VTBL_ENTRY)&_ZN6S236C24v180Ev,
  (VTBL_ENTRY)&_ZN6S236C24v181Ev,
  (VTBL_ENTRY)&_ZN6S236C24v182Ev,
  (VTBL_ENTRY)&_ZN6S236C24v183Ev,
  (VTBL_ENTRY)&_ZN6S236C24v184Ev,
  (VTBL_ENTRY)&_ZN6S236C24v185Ev,
  (VTBL_ENTRY)&_ZN6S236C24v186Ev,
  (VTBL_ENTRY)&_ZN6S236C24v187Ev,
  (VTBL_ENTRY)&_ZN6S236C24v188Ev,
  (VTBL_ENTRY)&_ZN6S236C24v189Ev,
  (VTBL_ENTRY)&_ZN6S236C12v1Ev,
  (VTBL_ENTRY)&_ZN6S236C12v2Ev,
  (VTBL_ENTRY)&_ZN6S236C12v3Ev,
  (VTBL_ENTRY)&_ZN6S236C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S236C1[];
extern  VTBL_ENTRY _ZTV6S236C1[];
Class_Descriptor cd_S236C1 = {  "S236C1", // class name
  bases_S236C1, 5,
  &(vtc_S236C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(552,420), // object size
  NSPAIRA(_ZTI6S236C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S236C1),193, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C7  {
  int s112c7f0;
  __tsi64 s112c7f1;
  void *s112c7f2[4];
  int s112c7f3[2];
  void *s112c7f4;
  ::S95C8_nt s112c7f5;
  void *s112c7f6[2];
  virtual  ~S112C7(); // _ZN6S112C7D1Ev
  virtual void  v7(); // _ZN6S112C72v7Ev
  virtual void  v8(); // _ZN6S112C72v8Ev
  virtual void  v9(); // _ZN6S112C72v9Ev
  virtual void  v10(); // _ZN6S112C73v10Ev
  virtual void  v11(); // _ZN6S112C73v11Ev
  virtual void  v12(); // _ZN6S112C73v12Ev
  virtual void  v13(); // _ZN6S112C73v13Ev
  virtual void  v14(); // _ZN6S112C73v14Ev
  virtual void  v15(); // _ZN6S112C73v15Ev
  virtual void  v16(); // _ZN6S112C73v16Ev
  virtual void  v17(); // _ZN6S112C73v17Ev
  virtual void  v18(); // _ZN6S112C73v18Ev
  virtual void  v19(); // _ZN6S112C73v19Ev
  virtual void  v20(); // _ZN6S112C73v20Ev
  virtual void  v21(); // _ZN6S112C73v21Ev
  virtual void  v22(); // _ZN6S112C73v22Ev
  virtual void  v23(); // _ZN6S112C73v23Ev
  virtual void  v24(); // _ZN6S112C73v24Ev
  virtual void  v25(); // _ZN6S112C73v25Ev
  virtual void  v26(); // _ZN6S112C73v26Ev
  virtual void  v27(); // _ZN6S112C73v27Ev
  virtual void  v28(); // _ZN6S112C73v28Ev
  virtual void  v29(); // _ZN6S112C73v29Ev
  virtual void  v30(); // _ZN6S112C73v30Ev
  virtual void  v31(); // _ZN6S112C73v31Ev
  virtual void  v32(); // _ZN6S112C73v32Ev
  virtual void  v33(); // _ZN6S112C73v33Ev
  virtual void  v34(); // _ZN6S112C73v34Ev
  virtual void  v35(); // _ZN6S112C73v35Ev
  virtual void  v36(); // _ZN6S112C73v36Ev
  virtual void  v37(); // _ZN6S112C73v37Ev
  virtual void  v38(); // _ZN6S112C73v38Ev
  virtual void  v39(); // _ZN6S112C73v39Ev
  virtual void  v40(); // _ZN6S112C73v40Ev
  virtual void  v41(); // _ZN6S112C73v41Ev
  virtual void  v42(); // _ZN6S112C73v42Ev
  virtual void  v43(); // _ZN6S112C73v43Ev
  virtual void  v44(); // _ZN6S112C73v44Ev
  virtual void  v45(); // _ZN6S112C73v45Ev
  virtual void  v46(); // _ZN6S112C73v46Ev
  virtual void  v47(); // _ZN6S112C73v47Ev
  virtual void  v48(); // _ZN6S112C73v48Ev
  virtual void  v49(); // _ZN6S112C73v49Ev
  virtual void  v50(); // _ZN6S112C73v50Ev
  virtual void  v51(); // _ZN6S112C73v51Ev
  virtual void  v52(); // _ZN6S112C73v52Ev
  virtual void  v53(); // _ZN6S112C73v53Ev
  virtual void  v54(); // _ZN6S112C73v54Ev
  virtual void  v55(); // _ZN6S112C73v55Ev
  virtual void  v56(); // _ZN6S112C73v56Ev
  virtual void  v57(); // _ZN6S112C73v57Ev
  virtual void  v58(); // _ZN6S112C73v58Ev
  virtual void  v59(); // _ZN6S112C73v59Ev
  virtual void  v60(); // _ZN6S112C73v60Ev
  virtual void  v61(); // _ZN6S112C73v61Ev
  virtual void  v62(); // _ZN6S112C73v62Ev
  virtual void  v63(); // _ZN6S112C73v63Ev
  virtual void  v64(); // _ZN6S112C73v64Ev
  virtual void  v65(); // _ZN6S112C73v65Ev
  virtual void  v66(); // _ZN6S112C73v66Ev
  virtual void  v67(); // _ZN6S112C73v67Ev
  virtual void  v68(); // _ZN6S112C73v68Ev
  virtual void  v69(); // _ZN6S112C73v69Ev
  virtual void  v70(); // _ZN6S112C73v70Ev
  S112C7(); // tgen
};
//SIG(-1 S112C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S112C7 ::~S112C7(){ note_dtor("S112C7", this);}
void  S112C7 ::v7(){vfunc_called(this, "_ZN6S112C72v7Ev");}
void  S112C7 ::v8(){vfunc_called(this, "_ZN6S112C72v8Ev");}
void  S112C7 ::v9(){vfunc_called(this, "_ZN6S112C72v9Ev");}
void  S112C7 ::v10(){vfunc_called(this, "_ZN6S112C73v10Ev");}
void  S112C7 ::v11(){vfunc_called(this, "_ZN6S112C73v11Ev");}
void  S112C7 ::v12(){vfunc_called(this, "_ZN6S112C73v12Ev");}
void  S112C7 ::v13(){vfunc_called(this, "_ZN6S112C73v13Ev");}
void  S112C7 ::v14(){vfunc_called(this, "_ZN6S112C73v14Ev");}
void  S112C7 ::v15(){vfunc_called(this, "_ZN6S112C73v15Ev");}
void  S112C7 ::v16(){vfunc_called(this, "_ZN6S112C73v16Ev");}
void  S112C7 ::v17(){vfunc_called(this, "_ZN6S112C73v17Ev");}
void  S112C7 ::v18(){vfunc_called(this, "_ZN6S112C73v18Ev");}
void  S112C7 ::v19(){vfunc_called(this, "_ZN6S112C73v19Ev");}
void  S112C7 ::v20(){vfunc_called(this, "_ZN6S112C73v20Ev");}
void  S112C7 ::v21(){vfunc_called(this, "_ZN6S112C73v21Ev");}
void  S112C7 ::v22(){vfunc_called(this, "_ZN6S112C73v22Ev");}
void  S112C7 ::v23(){vfunc_called(this, "_ZN6S112C73v23Ev");}
void  S112C7 ::v24(){vfunc_called(this, "_ZN6S112C73v24Ev");}
void  S112C7 ::v25(){vfunc_called(this, "_ZN6S112C73v25Ev");}
void  S112C7 ::v26(){vfunc_called(this, "_ZN6S112C73v26Ev");}
void  S112C7 ::v27(){vfunc_called(this, "_ZN6S112C73v27Ev");}
void  S112C7 ::v28(){vfunc_called(this, "_ZN6S112C73v28Ev");}
void  S112C7 ::v29(){vfunc_called(this, "_ZN6S112C73v29Ev");}
void  S112C7 ::v30(){vfunc_called(this, "_ZN6S112C73v30Ev");}
void  S112C7 ::v31(){vfunc_called(this, "_ZN6S112C73v31Ev");}
void  S112C7 ::v32(){vfunc_called(this, "_ZN6S112C73v32Ev");}
void  S112C7 ::v33(){vfunc_called(this, "_ZN6S112C73v33Ev");}
void  S112C7 ::v34(){vfunc_called(this, "_ZN6S112C73v34Ev");}
void  S112C7 ::v35(){vfunc_called(this, "_ZN6S112C73v35Ev");}
void  S112C7 ::v36(){vfunc_called(this, "_ZN6S112C73v36Ev");}
void  S112C7 ::v37(){vfunc_called(this, "_ZN6S112C73v37Ev");}
void  S112C7 ::v38(){vfunc_called(this, "_ZN6S112C73v38Ev");}
void  S112C7 ::v39(){vfunc_called(this, "_ZN6S112C73v39Ev");}
void  S112C7 ::v40(){vfunc_called(this, "_ZN6S112C73v40Ev");}
void  S112C7 ::v41(){vfunc_called(this, "_ZN6S112C73v41Ev");}
void  S112C7 ::v42(){vfunc_called(this, "_ZN6S112C73v42Ev");}
void  S112C7 ::v43(){vfunc_called(this, "_ZN6S112C73v43Ev");}
void  S112C7 ::v44(){vfunc_called(this, "_ZN6S112C73v44Ev");}
void  S112C7 ::v45(){vfunc_called(this, "_ZN6S112C73v45Ev");}
void  S112C7 ::v46(){vfunc_called(this, "_ZN6S112C73v46Ev");}
void  S112C7 ::v47(){vfunc_called(this, "_ZN6S112C73v47Ev");}
void  S112C7 ::v48(){vfunc_called(this, "_ZN6S112C73v48Ev");}
void  S112C7 ::v49(){vfunc_called(this, "_ZN6S112C73v49Ev");}
void  S112C7 ::v50(){vfunc_called(this, "_ZN6S112C73v50Ev");}
void  S112C7 ::v51(){vfunc_called(this, "_ZN6S112C73v51Ev");}
void  S112C7 ::v52(){vfunc_called(this, "_ZN6S112C73v52Ev");}
void  S112C7 ::v53(){vfunc_called(this, "_ZN6S112C73v53Ev");}
void  S112C7 ::v54(){vfunc_called(this, "_ZN6S112C73v54Ev");}
void  S112C7 ::v55(){vfunc_called(this, "_ZN6S112C73v55Ev");}
void  S112C7 ::v56(){vfunc_called(this, "_ZN6S112C73v56Ev");}
void  S112C7 ::v57(){vfunc_called(this, "_ZN6S112C73v57Ev");}
void  S112C7 ::v58(){vfunc_called(this, "_ZN6S112C73v58Ev");}
void  S112C7 ::v59(){vfunc_called(this, "_ZN6S112C73v59Ev");}
void  S112C7 ::v60(){vfunc_called(this, "_ZN6S112C73v60Ev");}
void  S112C7 ::v61(){vfunc_called(this, "_ZN6S112C73v61Ev");}
void  S112C7 ::v62(){vfunc_called(this, "_ZN6S112C73v62Ev");}
void  S112C7 ::v63(){vfunc_called(this, "_ZN6S112C73v63Ev");}
void  S112C7 ::v64(){vfunc_called(this, "_ZN6S112C73v64Ev");}
void  S112C7 ::v65(){vfunc_called(this, "_ZN6S112C73v65Ev");}
void  S112C7 ::v66(){vfunc_called(this, "_ZN6S112C73v66Ev");}
void  S112C7 ::v67(){vfunc_called(this, "_ZN6S112C73v67Ev");}
void  S112C7 ::v68(){vfunc_called(this, "_ZN6S112C73v68Ev");}
void  S112C7 ::v69(){vfunc_called(this, "_ZN6S112C73v69Ev");}
void  S112C7 ::v70(){vfunc_called(this, "_ZN6S112C73v70Ev");}
S112C7 ::S112C7(){ note_ctor("S112C7", this);} // tgen

static void Test_S112C7()
{
  extern Class_Descriptor cd_S112C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S112C7, buf);
    S112C7 *dp, &lv = *(dp=new (buf) S112C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S112C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C7)");
    check_field_offset(lv, s112c7f0, ABISELECT(8,4), "S112C7.s112c7f0");
    check_field_offset(lv, s112c7f1, ABISELECT(16,8), "S112C7.s112c7f1");
    check_field_offset(lv, s112c7f2, ABISELECT(24,16), "S112C7.s112c7f2");
    check_field_offset(lv, s112c7f3, ABISELECT(56,32), "S112C7.s112c7f3");
    check_field_offset(lv, s112c7f4, ABISELECT(64,40), "S112C7.s112c7f4");
    check_field_offset(lv, s112c7f5, ABISELECT(72,44), "S112C7.s112c7f5");
    check_field_offset(lv, s112c7f6, ABISELECT(80,52), "S112C7.s112c7f6");
    test_class_info(&lv, &cd_S112C7);
    dp->~S112C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C7(Test_S112C7, "S112C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S112C7C1Ev();
extern void _ZN6S112C7D1Ev();
Name_Map name_map_S112C7[] = {
  NSPAIR(_ZN6S112C7C1Ev),
  NSPAIR(_ZN6S112C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S112C7[];
extern void _ZN6S112C7D1Ev();
extern void _ZN6S112C7D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
static  VTBL_ENTRY vtc_S112C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C7[0]),
  (VTBL_ENTRY)&_ZN6S112C7D1Ev,
  (VTBL_ENTRY)&_ZN6S112C7D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
};
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
Class_Descriptor cd_S112C7 = {  "S112C7", // class name
  0,0,//no base classes
  &(vtc_S112C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S112C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S112C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C6  : S112C7 {
  void *s112c6f0;
  ::S95C8_nt s112c6f1;
  virtual  ~S112C6(); // _ZN6S112C6D1Ev
  virtual void  v71(); // _ZN6S112C63v71Ev
  virtual void  v72(); // _ZN6S112C63v72Ev
  virtual void  v73(); // _ZN6S112C63v73Ev
  virtual void  v74(); // _ZN6S112C63v74Ev
  virtual void  v75(); // _ZN6S112C63v75Ev
  S112C6(); // tgen
};
//SIG(-1 S112C6) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S112C6 ::~S112C6(){ note_dtor("S112C6", this);}
void  S112C6 ::v71(){vfunc_called(this, "_ZN6S112C63v71Ev");}
void  S112C6 ::v72(){vfunc_called(this, "_ZN6S112C63v72Ev");}
void  S112C6 ::v73(){vfunc_called(this, "_ZN6S112C63v73Ev");}
void  S112C6 ::v74(){vfunc_called(this, "_ZN6S112C63v74Ev");}
void  S112C6 ::v75(){vfunc_called(this, "_ZN6S112C63v75Ev");}
S112C6 ::S112C6(){ note_ctor("S112C6", this);} // tgen

static void Test_S112C6()
{
  extern Class_Descriptor cd_S112C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S112C6, buf);
    S112C6 *dp, &lv = *(dp=new (buf) S112C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S112C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C6)");
    check_base_class_offset(lv, (S112C7*), 0, "S112C6");
    check_field_offset(lv, s112c6f0, ABISELECT(96,60), "S112C6.s112c6f0");
    check_field_offset(lv, s112c6f1, ABISELECT(104,64), "S112C6.s112c6f1");
    test_class_info(&lv, &cd_S112C6);
    dp->~S112C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C6(Test_S112C6, "S112C6", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S112C6C1Ev();
extern void _ZN6S112C6D1Ev();
Name_Map name_map_S112C6[] = {
  NSPAIR(_ZN6S112C6C1Ev),
  NSPAIR(_ZN6S112C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
static Base_Class bases_S112C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C6[];
extern void _ZN6S112C6D1Ev();
extern void _ZN6S112C6D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
static  VTBL_ENTRY vtc_S112C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C6[0]),
  (VTBL_ENTRY)&_ZN6S112C6D1Ev,
  (VTBL_ENTRY)&_ZN6S112C6D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
};
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
Class_Descriptor cd_S112C6 = {  "S112C6", // class name
  bases_S112C6, 1,
  &(vtc_S112C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S112C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C6),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C5  : S112C6 {
  void *s112c5f0[2];
  unsigned int s112c5f1:1;
  unsigned int s112c5f2:1;
  unsigned int s112c5f3:1;
  unsigned int s112c5f4:1;
  char s112c5f5;
  virtual  ~S112C5(); // _ZN6S112C5D1Ev
  virtual void  v76(); // _ZN6S112C53v76Ev
  virtual void  v77(); // _ZN6S112C53v77Ev
  virtual void  v78(); // _ZN6S112C53v78Ev
  virtual void  v79(); // _ZN6S112C53v79Ev
  virtual void  v80(); // _ZN6S112C53v80Ev
  virtual void  v81(); // _ZN6S112C53v81Ev
  virtual void  v82(); // _ZN6S112C53v82Ev
  virtual void  v83(); // _ZN6S112C53v83Ev
  virtual void  v84(); // _ZN6S112C53v84Ev
  virtual void  v85(); // _ZN6S112C53v85Ev
  virtual void  v86(); // _ZN6S112C53v86Ev
  virtual void  v87(); // _ZN6S112C53v87Ev
  virtual void  v88(); // _ZN6S112C53v88Ev
  virtual void  v89(); // _ZN6S112C53v89Ev
  virtual void  v90(); // _ZN6S112C53v90Ev
  virtual void  v91(); // _ZN6S112C53v91Ev
  virtual void  v92(); // _ZN6S112C53v92Ev
  virtual void  v93(); // _ZN6S112C53v93Ev
  virtual void  v94(); // _ZN6S112C53v94Ev
  virtual void  v95(); // _ZN6S112C53v95Ev
  virtual void  v96(); // _ZN6S112C53v96Ev
  virtual void  v97(); // _ZN6S112C53v97Ev
  S112C5(); // tgen
};
//SIG(-1 S112C5) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S112C5 ::~S112C5(){ note_dtor("S112C5", this);}
void  S112C5 ::v76(){vfunc_called(this, "_ZN6S112C53v76Ev");}
void  S112C5 ::v77(){vfunc_called(this, "_ZN6S112C53v77Ev");}
void  S112C5 ::v78(){vfunc_called(this, "_ZN6S112C53v78Ev");}
void  S112C5 ::v79(){vfunc_called(this, "_ZN6S112C53v79Ev");}
void  S112C5 ::v80(){vfunc_called(this, "_ZN6S112C53v80Ev");}
void  S112C5 ::v81(){vfunc_called(this, "_ZN6S112C53v81Ev");}
void  S112C5 ::v82(){vfunc_called(this, "_ZN6S112C53v82Ev");}
void  S112C5 ::v83(){vfunc_called(this, "_ZN6S112C53v83Ev");}
void  S112C5 ::v84(){vfunc_called(this, "_ZN6S112C53v84Ev");}
void  S112C5 ::v85(){vfunc_called(this, "_ZN6S112C53v85Ev");}
void  S112C5 ::v86(){vfunc_called(this, "_ZN6S112C53v86Ev");}
void  S112C5 ::v87(){vfunc_called(this, "_ZN6S112C53v87Ev");}
void  S112C5 ::v88(){vfunc_called(this, "_ZN6S112C53v88Ev");}
void  S112C5 ::v89(){vfunc_called(this, "_ZN6S112C53v89Ev");}
void  S112C5 ::v90(){vfunc_called(this, "_ZN6S112C53v90Ev");}
void  S112C5 ::v91(){vfunc_called(this, "_ZN6S112C53v91Ev");}
void  S112C5 ::v92(){vfunc_called(this, "_ZN6S112C53v92Ev");}
void  S112C5 ::v93(){vfunc_called(this, "_ZN6S112C53v93Ev");}
void  S112C5 ::v94(){vfunc_called(this, "_ZN6S112C53v94Ev");}
void  S112C5 ::v95(){vfunc_called(this, "_ZN6S112C53v95Ev");}
void  S112C5 ::v96(){vfunc_called(this, "_ZN6S112C53v96Ev");}
void  S112C5 ::v97(){vfunc_called(this, "_ZN6S112C53v97Ev");}
S112C5 ::S112C5(){ note_ctor("S112C5", this);} // tgen

static void Test_S112C5()
{
  extern Class_Descriptor cd_S112C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S112C5, buf);
    S112C5 *dp, &lv = *(dp=new (buf) S112C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S112C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C5)");
    check_base_class_offset(lv, (S112C7*)(S112C6*), 0, "S112C5");
    check_base_class_offset(lv, (S112C6*), 0, "S112C5");
    check_field_offset(lv, s112c5f0, ABISELECT(112,72), "S112C5.s112c5f0");
    set_bf_and_test(lv, s112c5f1, ABISELECT(128,80), 0, 1, 1, "S112C5");
    set_bf_and_test(lv, s112c5f2, ABISELECT(128,80), 1, 1, 1, "S112C5");
    set_bf_and_test(lv, s112c5f3, ABISELECT(128,80), 2, 1, 1, "S112C5");
    set_bf_and_test(lv, s112c5f4, ABISELECT(128,80), 3, 1, 1, "S112C5");
    check_field_offset(lv, s112c5f5, ABISELECT(129,81), "S112C5.s112c5f5");
    test_class_info(&lv, &cd_S112C5);
    dp->~S112C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C5(Test_S112C5, "S112C5", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S112C5C1Ev();
extern void _ZN6S112C5D1Ev();
Name_Map name_map_S112C5[] = {
  NSPAIR(_ZN6S112C5C1Ev),
  NSPAIR(_ZN6S112C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
extern Class_Descriptor cd_S112C6;
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
static Base_Class bases_S112C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S112C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C5[];
extern void _ZN6S112C5D1Ev();
extern void _ZN6S112C5D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
extern void _ZN6S112C53v76Ev();
extern void _ZN6S112C53v77Ev();
extern void _ZN6S112C53v78Ev();
extern void _ZN6S112C53v79Ev();
extern void _ZN6S112C53v80Ev();
extern void _ZN6S112C53v81Ev();
extern void _ZN6S112C53v82Ev();
extern void _ZN6S112C53v83Ev();
extern void _ZN6S112C53v84Ev();
extern void _ZN6S112C53v85Ev();
extern void _ZN6S112C53v86Ev();
extern void _ZN6S112C53v87Ev();
extern void _ZN6S112C53v88Ev();
extern void _ZN6S112C53v89Ev();
extern void _ZN6S112C53v90Ev();
extern void _ZN6S112C53v91Ev();
extern void _ZN6S112C53v92Ev();
extern void _ZN6S112C53v93Ev();
extern void _ZN6S112C53v94Ev();
extern void _ZN6S112C53v95Ev();
extern void _ZN6S112C53v96Ev();
extern void _ZN6S112C53v97Ev();
static  VTBL_ENTRY vtc_S112C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C5[0]),
  (VTBL_ENTRY)&_ZN6S112C5D1Ev,
  (VTBL_ENTRY)&_ZN6S112C5D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
  (VTBL_ENTRY)&_ZN6S112C53v76Ev,
  (VTBL_ENTRY)&_ZN6S112C53v77Ev,
  (VTBL_ENTRY)&_ZN6S112C53v78Ev,
  (VTBL_ENTRY)&_ZN6S112C53v79Ev,
  (VTBL_ENTRY)&_ZN6S112C53v80Ev,
  (VTBL_ENTRY)&_ZN6S112C53v81Ev,
  (VTBL_ENTRY)&_ZN6S112C53v82Ev,
  (VTBL_ENTRY)&_ZN6S112C53v83Ev,
  (VTBL_ENTRY)&_ZN6S112C53v84Ev,
  (VTBL_ENTRY)&_ZN6S112C53v85Ev,
  (VTBL_ENTRY)&_ZN6S112C53v86Ev,
  (VTBL_ENTRY)&_ZN6S112C53v87Ev,
  (VTBL_ENTRY)&_ZN6S112C53v88Ev,
  (VTBL_ENTRY)&_ZN6S112C53v89Ev,
  (VTBL_ENTRY)&_ZN6S112C53v90Ev,
  (VTBL_ENTRY)&_ZN6S112C53v91Ev,
  (VTBL_ENTRY)&_ZN6S112C53v92Ev,
  (VTBL_ENTRY)&_ZN6S112C53v93Ev,
  (VTBL_ENTRY)&_ZN6S112C53v94Ev,
  (VTBL_ENTRY)&_ZN6S112C53v95Ev,
  (VTBL_ENTRY)&_ZN6S112C53v96Ev,
  (VTBL_ENTRY)&_ZN6S112C53v97Ev,
};
extern VTBL_ENTRY _ZTI6S112C5[];
extern  VTBL_ENTRY _ZTV6S112C5[];
Class_Descriptor cd_S112C5 = {  "S112C5", // class name
  bases_S112C5, 2,
  &(vtc_S112C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S112C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C5),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C4  : S112C5 {
  void *s112c4f0;
  ::S95C9_nt s112c4f1;
  int s112c4f2;
  ::S236C15_nt s112c4f3;
  int s112c4f4;
  ::S236C26 s112c4f5;
  int s112c4f6;
  void *s112c4f7[2];
  ::S95C13 s112c4f8;
  void *s112c4f9;
  int s112c4f10[2];
  char s112c4f11[3];
  int s112c4f12;
  unsigned int s112c4f13:1;
  unsigned int s112c4f14:1;
  unsigned int s112c4f15:1;
  unsigned int s112c4f16:1;
  unsigned int s112c4f17:1;
  unsigned int s112c4f18:1;
  unsigned int s112c4f19:1;
  unsigned int s112c4f20:1;
  unsigned int s112c4f21:1;
  unsigned int s112c4f22:1;
  unsigned int s112c4f23:1;
  unsigned int s112c4f24:1;
  unsigned int s112c4f25:1;
  unsigned int s112c4f26:1;
  int s112c4f27;
  unsigned int s112c4f28:1;
  unsigned int s112c4f29:1;
  unsigned int s112c4f30:1;
  unsigned int s112c4f31:1;
  unsigned int s112c4f32:1;
  unsigned int s112c4f33:1;
  ::S95C16 s112c4f34;
  unsigned int s112c4f35:1;
  unsigned int s112c4f36:1;
  unsigned int s112c4f37:1;
  unsigned int s112c4f38:1;
  unsigned int s112c4f39:1;
  unsigned int s112c4f40:1;
  unsigned int s112c4f41:1;
  char s112c4f42;
  ::S95C10_nt s112c4f43;
  unsigned int s112c4f44:1;
  unsigned int s112c4f45:1;
  unsigned int s112c4f46:1;
  unsigned int s112c4f47:1;
  unsigned int s112c4f48:1;
  unsigned int s112c4f49:1;
  unsigned int s112c4f50:1;
  unsigned int s112c4f51:1;
  unsigned int s112c4f52:1;
  unsigned int s112c4f53:1;
  unsigned int s112c4f54:1;
  unsigned int s112c4f55:1;
  ::S236C25_nt s112c4f56;
  void *s112c4f57[2];
  char s112c4f58;
  ::S236C15_nt s112c4f59;
  ::S236C18_nt s112c4f60;
  ::S95C14_nt s112c4f61;
  int s112c4f62;
  ::S236C18_nt s112c4f63;
  unsigned int s112c4f64:1;
  unsigned int s112c4f65:1;
  unsigned int s112c4f66:1;
  int s112c4f67[3];
  virtual  ~S112C4(); // _ZN6S112C4D1Ev
  virtual void  v98(); // _ZN6S112C43v98Ev
  virtual void  v99(); // _ZN6S112C43v99Ev
  virtual void  v100(); // _ZN6S112C44v100Ev
  virtual void  v101(); // _ZN6S112C44v101Ev
  virtual void  v102(); // _ZN6S112C44v102Ev
  virtual void  v103(); // _ZN6S112C44v103Ev
  virtual void  v104(); // _ZN6S112C44v104Ev
  virtual void  v105(); // _ZN6S112C44v105Ev
  virtual void  v106(); // _ZN6S112C44v106Ev
  virtual void  v107(); // _ZN6S112C44v107Ev
  virtual void  v108(); // _ZN6S112C44v108Ev
  virtual void  v109(); // _ZN6S112C44v109Ev
  virtual void  v110(); // _ZN6S112C44v110Ev
  virtual void  v111(); // _ZN6S112C44v111Ev
  virtual void  v112(); // _ZN6S112C44v112Ev
  virtual void  v113(); // _ZN6S112C44v113Ev
  virtual void  v114(); // _ZN6S112C44v114Ev
  virtual void  v115(); // _ZN6S112C44v115Ev
  virtual void  v116(); // _ZN6S112C44v116Ev
  virtual void  v117(); // _ZN6S112C44v117Ev
  virtual void  v118(); // _ZN6S112C44v118Ev
  virtual void  v119(); // _ZN6S112C44v119Ev
  virtual void  v120(); // _ZN6S112C44v120Ev
  virtual void  v121(); // _ZN6S112C44v121Ev
  virtual void  v122(); // _ZN6S112C44v122Ev
  virtual void  v123(); // _ZN6S112C44v123Ev
  virtual void  v124(); // _ZN6S112C44v124Ev
  virtual void  v125(); // _ZN6S112C44v125Ev
  virtual void  v126(); // _ZN6S112C44v126Ev
  virtual void  v127(); // _ZN6S112C44v127Ev
  virtual void  v128(); // _ZN6S112C44v128Ev
  virtual void  v129(); // _ZN6S112C44v129Ev
  virtual void  v130(); // _ZN6S112C44v130Ev
  virtual void  v131(); // _ZN6S112C44v131Ev
  virtual void  v132(); // _ZN6S112C44v132Ev
  virtual void  v133(); // _ZN6S112C44v133Ev
  virtual void  v134(); // _ZN6S112C44v134Ev
  virtual void  v135(); // _ZN6S112C44v135Ev
  virtual void  v136(); // _ZN6S112C44v136Ev
  virtual void  v137(); // _ZN6S112C44v137Ev
  virtual void  v138(); // _ZN6S112C44v138Ev
  virtual void  v139(); // _ZN6S112C44v139Ev
  virtual void  v140(); // _ZN6S112C44v140Ev
  virtual void  v141(); // _ZN6S112C44v141Ev
  virtual void  v142(); // _ZN6S112C44v142Ev
  virtual void  v143(); // _ZN6S112C44v143Ev
  virtual void  v144(); // _ZN6S112C44v144Ev
  virtual void  v145(); // _ZN6S112C44v145Ev
  virtual void  v146(); // _ZN6S112C44v146Ev
  virtual void  v147(); // _ZN6S112C44v147Ev
  virtual void  v148(); // _ZN6S112C44v148Ev
  virtual void  v149(); // _ZN6S112C44v149Ev
  virtual void  v150(); // _ZN6S112C44v150Ev
  virtual void  v151(); // _ZN6S112C44v151Ev
  virtual void  v152(); // _ZN6S112C44v152Ev
  virtual void  v153(); // _ZN6S112C44v153Ev
  virtual void  v154(); // _ZN6S112C44v154Ev
  virtual void  v155(); // _ZN6S112C44v155Ev
  virtual void  v156(); // _ZN6S112C44v156Ev
  virtual void  v157(); // _ZN6S112C44v157Ev
  virtual void  v158(); // _ZN6S112C44v158Ev
  S112C4(); // tgen
};
//SIG(-1 S112C4) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S112C4 ::~S112C4(){ note_dtor("S112C4", this);}
void  S112C4 ::v98(){vfunc_called(this, "_ZN6S112C43v98Ev");}
void  S112C4 ::v99(){vfunc_called(this, "_ZN6S112C43v99Ev");}
void  S112C4 ::v100(){vfunc_called(this, "_ZN6S112C44v100Ev");}
void  S112C4 ::v101(){vfunc_called(this, "_ZN6S112C44v101Ev");}
void  S112C4 ::v102(){vfunc_called(this, "_ZN6S112C44v102Ev");}
void  S112C4 ::v103(){vfunc_called(this, "_ZN6S112C44v103Ev");}
void  S112C4 ::v104(){vfunc_called(this, "_ZN6S112C44v104Ev");}
void  S112C4 ::v105(){vfunc_called(this, "_ZN6S112C44v105Ev");}
void  S112C4 ::v106(){vfunc_called(this, "_ZN6S112C44v106Ev");}
void  S112C4 ::v107(){vfunc_called(this, "_ZN6S112C44v107Ev");}
void  S112C4 ::v108(){vfunc_called(this, "_ZN6S112C44v108Ev");}
void  S112C4 ::v109(){vfunc_called(this, "_ZN6S112C44v109Ev");}
void  S112C4 ::v110(){vfunc_called(this, "_ZN6S112C44v110Ev");}
void  S112C4 ::v111(){vfunc_called(this, "_ZN6S112C44v111Ev");}
void  S112C4 ::v112(){vfunc_called(this, "_ZN6S112C44v112Ev");}
void  S112C4 ::v113(){vfunc_called(this, "_ZN6S112C44v113Ev");}
void  S112C4 ::v114(){vfunc_called(this, "_ZN6S112C44v114Ev");}
void  S112C4 ::v115(){vfunc_called(this, "_ZN6S112C44v115Ev");}
void  S112C4 ::v116(){vfunc_called(this, "_ZN6S112C44v116Ev");}
void  S112C4 ::v117(){vfunc_called(this, "_ZN6S112C44v117Ev");}
void  S112C4 ::v118(){vfunc_called(this, "_ZN6S112C44v118Ev");}
void  S112C4 ::v119(){vfunc_called(this, "_ZN6S112C44v119Ev");}
void  S112C4 ::v120(){vfunc_called(this, "_ZN6S112C44v120Ev");}
void  S112C4 ::v121(){vfunc_called(this, "_ZN6S112C44v121Ev");}
void  S112C4 ::v122(){vfunc_called(this, "_ZN6S112C44v122Ev");}
void  S112C4 ::v123(){vfunc_called(this, "_ZN6S112C44v123Ev");}
void  S112C4 ::v124(){vfunc_called(this, "_ZN6S112C44v124Ev");}
void  S112C4 ::v125(){vfunc_called(this, "_ZN6S112C44v125Ev");}
void  S112C4 ::v126(){vfunc_called(this, "_ZN6S112C44v126Ev");}
void  S112C4 ::v127(){vfunc_called(this, "_ZN6S112C44v127Ev");}
void  S112C4 ::v128(){vfunc_called(this, "_ZN6S112C44v128Ev");}
void  S112C4 ::v129(){vfunc_called(this, "_ZN6S112C44v129Ev");}
void  S112C4 ::v130(){vfunc_called(this, "_ZN6S112C44v130Ev");}
void  S112C4 ::v131(){vfunc_called(this, "_ZN6S112C44v131Ev");}
void  S112C4 ::v132(){vfunc_called(this, "_ZN6S112C44v132Ev");}
void  S112C4 ::v133(){vfunc_called(this, "_ZN6S112C44v133Ev");}
void  S112C4 ::v134(){vfunc_called(this, "_ZN6S112C44v134Ev");}
void  S112C4 ::v135(){vfunc_called(this, "_ZN6S112C44v135Ev");}
void  S112C4 ::v136(){vfunc_called(this, "_ZN6S112C44v136Ev");}
void  S112C4 ::v137(){vfunc_called(this, "_ZN6S112C44v137Ev");}
void  S112C4 ::v138(){vfunc_called(this, "_ZN6S112C44v138Ev");}
void  S112C4 ::v139(){vfunc_called(this, "_ZN6S112C44v139Ev");}
void  S112C4 ::v140(){vfunc_called(this, "_ZN6S112C44v140Ev");}
void  S112C4 ::v141(){vfunc_called(this, "_ZN6S112C44v141Ev");}
void  S112C4 ::v142(){vfunc_called(this, "_ZN6S112C44v142Ev");}
void  S112C4 ::v143(){vfunc_called(this, "_ZN6S112C44v143Ev");}
void  S112C4 ::v144(){vfunc_called(this, "_ZN6S112C44v144Ev");}
void  S112C4 ::v145(){vfunc_called(this, "_ZN6S112C44v145Ev");}
void  S112C4 ::v146(){vfunc_called(this, "_ZN6S112C44v146Ev");}
void  S112C4 ::v147(){vfunc_called(this, "_ZN6S112C44v147Ev");}
void  S112C4 ::v148(){vfunc_called(this, "_ZN6S112C44v148Ev");}
void  S112C4 ::v149(){vfunc_called(this, "_ZN6S112C44v149Ev");}
void  S112C4 ::v150(){vfunc_called(this, "_ZN6S112C44v150Ev");}
void  S112C4 ::v151(){vfunc_called(this, "_ZN6S112C44v151Ev");}
void  S112C4 ::v152(){vfunc_called(this, "_ZN6S112C44v152Ev");}
void  S112C4 ::v153(){vfunc_called(this, "_ZN6S112C44v153Ev");}
void  S112C4 ::v154(){vfunc_called(this, "_ZN6S112C44v154Ev");}
void  S112C4 ::v155(){vfunc_called(this, "_ZN6S112C44v155Ev");}
void  S112C4 ::v156(){vfunc_called(this, "_ZN6S112C44v156Ev");}
void  S112C4 ::v157(){vfunc_called(this, "_ZN6S112C44v157Ev");}
void  S112C4 ::v158(){vfunc_called(this, "_ZN6S112C44v158Ev");}
S112C4 ::S112C4(){ note_ctor("S112C4", this);} // tgen

static void Test_S112C4()
{
  extern Class_Descriptor cd_S112C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S112C4, buf);
    S112C4 *dp, &lv = *(dp=new (buf) S112C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S112C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C4)");
    check_base_class_offset(lv, (S112C7*)(S112C6*)(S112C5*), 0, "S112C4");
    check_base_class_offset(lv, (S112C6*)(S112C5*), 0, "S112C4");
    check_base_class_offset(lv, (S112C5*), 0, "S112C4");
    check_field_offset(lv, s112c4f0, ABISELECT(136,84), "S112C4.s112c4f0");
    check_field_offset(lv, s112c4f1, ABISELECT(144,88), "S112C4.s112c4f1");
    check_field_offset(lv, s112c4f2, ABISELECT(148,92), "S112C4.s112c4f2");
    check_field_offset(lv, s112c4f3, ABISELECT(152,96), "S112C4.s112c4f3");
    check_field_offset(lv, s112c4f4, ABISELECT(156,100), "S112C4.s112c4f4");
    check_field_offset(lv, s112c4f5, ABISELECT(160,104), "S112C4.s112c4f5");
    check_field_offset(lv, s112c4f6, ABISELECT(176,116), "S112C4.s112c4f6");
    check_field_offset(lv, s112c4f7, ABISELECT(184,120), "S112C4.s112c4f7");
    check_field_offset(lv, s112c4f8, ABISELECT(200,128), "S112C4.s112c4f8");
    check_field_offset(lv, s112c4f9, ABISELECT(232,156), "S112C4.s112c4f9");
    check_field_offset(lv, s112c4f10, ABISELECT(240,160), "S112C4.s112c4f10");
    check_field_offset(lv, s112c4f11, ABISELECT(248,168), "S112C4.s112c4f11");
    check_field_offset(lv, s112c4f12, ABISELECT(252,172), "S112C4.s112c4f12");
    set_bf_and_test(lv, s112c4f13, ABISELECT(256,176), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f14, ABISELECT(256,176), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f15, ABISELECT(256,176), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f16, ABISELECT(256,176), 3, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f17, ABISELECT(256,176), 4, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f18, ABISELECT(256,176), 5, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f19, ABISELECT(256,176), 6, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f20, ABISELECT(256,176), 7, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f21, ABISELECT(257,177), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f22, ABISELECT(257,177), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f23, ABISELECT(257,177), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f24, ABISELECT(257,177), 3, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f25, ABISELECT(257,177), 4, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f26, ABISELECT(257,177), 5, 1, 1, "S112C4");
    check_field_offset(lv, s112c4f27, ABISELECT(260,180), "S112C4.s112c4f27");
    set_bf_and_test(lv, s112c4f28, ABISELECT(264,184), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f29, ABISELECT(264,184), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f30, ABISELECT(264,184), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f31, ABISELECT(264,184), 3, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f32, ABISELECT(264,184), 4, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f33, ABISELECT(264,184), 5, 1, 1, "S112C4");
    check_field_offset(lv, s112c4f34, ABISELECT(265,185), "S112C4.s112c4f34");
    set_bf_and_test(lv, s112c4f35, ABISELECT(266,186), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f36, ABISELECT(266,186), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f37, ABISELECT(266,186), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f38, ABISELECT(266,186), 3, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f39, ABISELECT(266,186), 4, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f40, ABISELECT(266,186), 5, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f41, ABISELECT(266,186), 6, 1, 1, "S112C4");
    check_field_offset(lv, s112c4f42, ABISELECT(267,187), "S112C4.s112c4f42");
    check_field_offset(lv, s112c4f43, ABISELECT(268,188), "S112C4.s112c4f43");
    set_bf_and_test(lv, s112c4f44, ABISELECT(269,189), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f45, ABISELECT(269,189), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f46, ABISELECT(269,189), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f47, ABISELECT(269,189), 3, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f48, ABISELECT(269,189), 4, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f49, ABISELECT(269,189), 5, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f50, ABISELECT(269,189), 6, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f51, ABISELECT(269,189), 7, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f52, ABISELECT(270,190), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f53, ABISELECT(270,190), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f54, ABISELECT(270,190), 2, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f55, ABISELECT(270,190), 3, 1, 1, "S112C4");
    check_field_offset(lv, s112c4f56, ABISELECT(272,192), "S112C4.s112c4f56");
    check_field_offset(lv, s112c4f57, ABISELECT(288,204), "S112C4.s112c4f57");
    check_field_offset(lv, s112c4f58, ABISELECT(304,212), "S112C4.s112c4f58");
    check_field_offset(lv, s112c4f59, ABISELECT(305,213), "S112C4.s112c4f59");
    check_field_offset(lv, s112c4f60, ABISELECT(308,216), "S112C4.s112c4f60");
    check_field_offset(lv, s112c4f61, ABISELECT(320,228), "S112C4.s112c4f61");
    check_field_offset(lv, s112c4f62, ABISELECT(332,240), "S112C4.s112c4f62");
    check_field_offset(lv, s112c4f63, ABISELECT(336,244), "S112C4.s112c4f63");
    set_bf_and_test(lv, s112c4f64, ABISELECT(348,256), 0, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f65, ABISELECT(348,256), 1, 1, 1, "S112C4");
    set_bf_and_test(lv, s112c4f66, ABISELECT(348,256), 2, 1, 1, "S112C4");
    check_field_offset(lv, s112c4f67, ABISELECT(352,260), "S112C4.s112c4f67");
    test_class_info(&lv, &cd_S112C4);
    dp->~S112C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C4(Test_S112C4, "S112C4", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S112C4C1Ev();
extern void _ZN6S112C4D1Ev();
Name_Map name_map_S112C4[] = {
  NSPAIR(_ZN6S112C4C1Ev),
  NSPAIR(_ZN6S112C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
extern Class_Descriptor cd_S112C6;
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
extern Class_Descriptor cd_S112C5;
extern VTBL_ENTRY _ZTI6S112C5[];
extern  VTBL_ENTRY _ZTV6S112C5[];
static Base_Class bases_S112C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S112C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S112C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C4[];
extern void _ZN6S112C4D1Ev();
extern void _ZN6S112C4D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
extern void _ZN6S112C53v76Ev();
extern void _ZN6S112C53v77Ev();
extern void _ZN6S112C53v78Ev();
extern void _ZN6S112C53v79Ev();
extern void _ZN6S112C53v80Ev();
extern void _ZN6S112C53v81Ev();
extern void _ZN6S112C53v82Ev();
extern void _ZN6S112C53v83Ev();
extern void _ZN6S112C53v84Ev();
extern void _ZN6S112C53v85Ev();
extern void _ZN6S112C53v86Ev();
extern void _ZN6S112C53v87Ev();
extern void _ZN6S112C53v88Ev();
extern void _ZN6S112C53v89Ev();
extern void _ZN6S112C53v90Ev();
extern void _ZN6S112C53v91Ev();
extern void _ZN6S112C53v92Ev();
extern void _ZN6S112C53v93Ev();
extern void _ZN6S112C53v94Ev();
extern void _ZN6S112C53v95Ev();
extern void _ZN6S112C53v96Ev();
extern void _ZN6S112C53v97Ev();
extern void _ZN6S112C43v98Ev();
extern void _ZN6S112C43v99Ev();
extern void _ZN6S112C44v100Ev();
extern void _ZN6S112C44v101Ev();
extern void _ZN6S112C44v102Ev();
extern void _ZN6S112C44v103Ev();
extern void _ZN6S112C44v104Ev();
extern void _ZN6S112C44v105Ev();
extern void _ZN6S112C44v106Ev();
extern void _ZN6S112C44v107Ev();
extern void _ZN6S112C44v108Ev();
extern void _ZN6S112C44v109Ev();
extern void _ZN6S112C44v110Ev();
extern void _ZN6S112C44v111Ev();
extern void _ZN6S112C44v112Ev();
extern void _ZN6S112C44v113Ev();
extern void _ZN6S112C44v114Ev();
extern void _ZN6S112C44v115Ev();
extern void _ZN6S112C44v116Ev();
extern void _ZN6S112C44v117Ev();
extern void _ZN6S112C44v118Ev();
extern void _ZN6S112C44v119Ev();
extern void _ZN6S112C44v120Ev();
extern void _ZN6S112C44v121Ev();
extern void _ZN6S112C44v122Ev();
extern void _ZN6S112C44v123Ev();
extern void _ZN6S112C44v124Ev();
extern void _ZN6S112C44v125Ev();
extern void _ZN6S112C44v126Ev();
extern void _ZN6S112C44v127Ev();
extern void _ZN6S112C44v128Ev();
extern void _ZN6S112C44v129Ev();
extern void _ZN6S112C44v130Ev();
extern void _ZN6S112C44v131Ev();
extern void _ZN6S112C44v132Ev();
extern void _ZN6S112C44v133Ev();
extern void _ZN6S112C44v134Ev();
extern void _ZN6S112C44v135Ev();
extern void _ZN6S112C44v136Ev();
extern void _ZN6S112C44v137Ev();
extern void _ZN6S112C44v138Ev();
extern void _ZN6S112C44v139Ev();
extern void _ZN6S112C44v140Ev();
extern void _ZN6S112C44v141Ev();
extern void _ZN6S112C44v142Ev();
extern void _ZN6S112C44v143Ev();
extern void _ZN6S112C44v144Ev();
extern void _ZN6S112C44v145Ev();
extern void _ZN6S112C44v146Ev();
extern void _ZN6S112C44v147Ev();
extern void _ZN6S112C44v148Ev();
extern void _ZN6S112C44v149Ev();
extern void _ZN6S112C44v150Ev();
extern void _ZN6S112C44v151Ev();
extern void _ZN6S112C44v152Ev();
extern void _ZN6S112C44v153Ev();
extern void _ZN6S112C44v154Ev();
extern void _ZN6S112C44v155Ev();
extern void _ZN6S112C44v156Ev();
extern void _ZN6S112C44v157Ev();
extern void _ZN6S112C44v158Ev();
static  VTBL_ENTRY vtc_S112C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C4[0]),
  (VTBL_ENTRY)&_ZN6S112C4D1Ev,
  (VTBL_ENTRY)&_ZN6S112C4D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
  (VTBL_ENTRY)&_ZN6S112C53v76Ev,
  (VTBL_ENTRY)&_ZN6S112C53v77Ev,
  (VTBL_ENTRY)&_ZN6S112C53v78Ev,
  (VTBL_ENTRY)&_ZN6S112C53v79Ev,
  (VTBL_ENTRY)&_ZN6S112C53v80Ev,
  (VTBL_ENTRY)&_ZN6S112C53v81Ev,
  (VTBL_ENTRY)&_ZN6S112C53v82Ev,
  (VTBL_ENTRY)&_ZN6S112C53v83Ev,
  (VTBL_ENTRY)&_ZN6S112C53v84Ev,
  (VTBL_ENTRY)&_ZN6S112C53v85Ev,
  (VTBL_ENTRY)&_ZN6S112C53v86Ev,
  (VTBL_ENTRY)&_ZN6S112C53v87Ev,
  (VTBL_ENTRY)&_ZN6S112C53v88Ev,
  (VTBL_ENTRY)&_ZN6S112C53v89Ev,
  (VTBL_ENTRY)&_ZN6S112C53v90Ev,
  (VTBL_ENTRY)&_ZN6S112C53v91Ev,
  (VTBL_ENTRY)&_ZN6S112C53v92Ev,
  (VTBL_ENTRY)&_ZN6S112C53v93Ev,
  (VTBL_ENTRY)&_ZN6S112C53v94Ev,
  (VTBL_ENTRY)&_ZN6S112C53v95Ev,
  (VTBL_ENTRY)&_ZN6S112C53v96Ev,
  (VTBL_ENTRY)&_ZN6S112C53v97Ev,
  (VTBL_ENTRY)&_ZN6S112C43v98Ev,
  (VTBL_ENTRY)&_ZN6S112C43v99Ev,
  (VTBL_ENTRY)&_ZN6S112C44v100Ev,
  (VTBL_ENTRY)&_ZN6S112C44v101Ev,
  (VTBL_ENTRY)&_ZN6S112C44v102Ev,
  (VTBL_ENTRY)&_ZN6S112C44v103Ev,
  (VTBL_ENTRY)&_ZN6S112C44v104Ev,
  (VTBL_ENTRY)&_ZN6S112C44v105Ev,
  (VTBL_ENTRY)&_ZN6S112C44v106Ev,
  (VTBL_ENTRY)&_ZN6S112C44v107Ev,
  (VTBL_ENTRY)&_ZN6S112C44v108Ev,
  (VTBL_ENTRY)&_ZN6S112C44v109Ev,
  (VTBL_ENTRY)&_ZN6S112C44v110Ev,
  (VTBL_ENTRY)&_ZN6S112C44v111Ev,
  (VTBL_ENTRY)&_ZN6S112C44v112Ev,
  (VTBL_ENTRY)&_ZN6S112C44v113Ev,
  (VTBL_ENTRY)&_ZN6S112C44v114Ev,
  (VTBL_ENTRY)&_ZN6S112C44v115Ev,
  (VTBL_ENTRY)&_ZN6S112C44v116Ev,
  (VTBL_ENTRY)&_ZN6S112C44v117Ev,
  (VTBL_ENTRY)&_ZN6S112C44v118Ev,
  (VTBL_ENTRY)&_ZN6S112C44v119Ev,
  (VTBL_ENTRY)&_ZN6S112C44v120Ev,
  (VTBL_ENTRY)&_ZN6S112C44v121Ev,
  (VTBL_ENTRY)&_ZN6S112C44v122Ev,
  (VTBL_ENTRY)&_ZN6S112C44v123Ev,
  (VTBL_ENTRY)&_ZN6S112C44v124Ev,
  (VTBL_ENTRY)&_ZN6S112C44v125Ev,
  (VTBL_ENTRY)&_ZN6S112C44v126Ev,
  (VTBL_ENTRY)&_ZN6S112C44v127Ev,
  (VTBL_ENTRY)&_ZN6S112C44v128Ev,
  (VTBL_ENTRY)&_ZN6S112C44v129Ev,
  (VTBL_ENTRY)&_ZN6S112C44v130Ev,
  (VTBL_ENTRY)&_ZN6S112C44v131Ev,
  (VTBL_ENTRY)&_ZN6S112C44v132Ev,
  (VTBL_ENTRY)&_ZN6S112C44v133Ev,
  (VTBL_ENTRY)&_ZN6S112C44v134Ev,
  (VTBL_ENTRY)&_ZN6S112C44v135Ev,
  (VTBL_ENTRY)&_ZN6S112C44v136Ev,
  (VTBL_ENTRY)&_ZN6S112C44v137Ev,
  (VTBL_ENTRY)&_ZN6S112C44v138Ev,
  (VTBL_ENTRY)&_ZN6S112C44v139Ev,
  (VTBL_ENTRY)&_ZN6S112C44v140Ev,
  (VTBL_ENTRY)&_ZN6S112C44v141Ev,
  (VTBL_ENTRY)&_ZN6S112C44v142Ev,
  (VTBL_ENTRY)&_ZN6S112C44v143Ev,
  (VTBL_ENTRY)&_ZN6S112C44v144Ev,
  (VTBL_ENTRY)&_ZN6S112C44v145Ev,
  (VTBL_ENTRY)&_ZN6S112C44v146Ev,
  (VTBL_ENTRY)&_ZN6S112C44v147Ev,
  (VTBL_ENTRY)&_ZN6S112C44v148Ev,
  (VTBL_ENTRY)&_ZN6S112C44v149Ev,
  (VTBL_ENTRY)&_ZN6S112C44v150Ev,
  (VTBL_ENTRY)&_ZN6S112C44v151Ev,
  (VTBL_ENTRY)&_ZN6S112C44v152Ev,
  (VTBL_ENTRY)&_ZN6S112C44v153Ev,
  (VTBL_ENTRY)&_ZN6S112C44v154Ev,
  (VTBL_ENTRY)&_ZN6S112C44v155Ev,
  (VTBL_ENTRY)&_ZN6S112C44v156Ev,
  (VTBL_ENTRY)&_ZN6S112C44v157Ev,
  (VTBL_ENTRY)&_ZN6S112C44v158Ev,
};
extern VTBL_ENTRY _ZTI6S112C4[];
extern  VTBL_ENTRY _ZTV6S112C4[];
Class_Descriptor cd_S112C4 = {  "S112C4", // class name
  bases_S112C4, 3,
  &(vtc_S112C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S112C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C4),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C3  : S112C4 {
  ::S95C35 s112c3f0;
  virtual  ~S112C3(); // _ZN6S112C3D1Ev
  virtual void  v159(); // _ZN6S112C34v159Ev
  virtual void  v160(); // _ZN6S112C34v160Ev
  virtual void  v161(); // _ZN6S112C34v161Ev
  virtual void  v162(); // _ZN6S112C34v162Ev
  S112C3(); // tgen
};
//SIG(-1 S112C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC6} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 FC17{ BC18{ BC10}}}


 S112C3 ::~S112C3(){ note_dtor("S112C3", this);}
void  S112C3 ::v159(){vfunc_called(this, "_ZN6S112C34v159Ev");}
void  S112C3 ::v160(){vfunc_called(this, "_ZN6S112C34v160Ev");}
void  S112C3 ::v161(){vfunc_called(this, "_ZN6S112C34v161Ev");}
void  S112C3 ::v162(){vfunc_called(this, "_ZN6S112C34v162Ev");}
S112C3 ::S112C3(){ note_ctor("S112C3", this);} // tgen

static void Test_S112C3()
{
  extern Class_Descriptor cd_S112C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,72)];
    init_test(&cd_S112C3, buf);
    S112C3 *dp, &lv = *(dp=new (buf) S112C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,284), "sizeof(S112C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C3)");
    check_base_class_offset(lv, (S112C7*)(S112C6*)(S112C5*)(S112C4*), 0, "S112C3");
    check_base_class_offset(lv, (S112C6*)(S112C5*)(S112C4*), 0, "S112C3");
    check_base_class_offset(lv, (S112C5*)(S112C4*), 0, "S112C3");
    check_base_class_offset(lv, (S112C4*), 0, "S112C3");
    check_field_offset(lv, s112c3f0, ABISELECT(368,272), "S112C3.s112c3f0");
    test_class_info(&lv, &cd_S112C3);
    dp->~S112C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C3(Test_S112C3, "S112C3", ABISELECT(384,284));

#else // __cplusplus

extern void _ZN6S112C3C1Ev();
extern void _ZN6S112C3D1Ev();
Name_Map name_map_S112C3[] = {
  NSPAIR(_ZN6S112C3C1Ev),
  NSPAIR(_ZN6S112C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
extern Class_Descriptor cd_S112C6;
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
extern Class_Descriptor cd_S112C5;
extern VTBL_ENTRY _ZTI6S112C5[];
extern  VTBL_ENTRY _ZTV6S112C5[];
extern Class_Descriptor cd_S112C4;
extern VTBL_ENTRY _ZTI6S112C4[];
extern  VTBL_ENTRY _ZTV6S112C4[];
static Base_Class bases_S112C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S112C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S112C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S112C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C3[];
extern void _ZN6S112C3D1Ev();
extern void _ZN6S112C3D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
extern void _ZN6S112C53v76Ev();
extern void _ZN6S112C53v77Ev();
extern void _ZN6S112C53v78Ev();
extern void _ZN6S112C53v79Ev();
extern void _ZN6S112C53v80Ev();
extern void _ZN6S112C53v81Ev();
extern void _ZN6S112C53v82Ev();
extern void _ZN6S112C53v83Ev();
extern void _ZN6S112C53v84Ev();
extern void _ZN6S112C53v85Ev();
extern void _ZN6S112C53v86Ev();
extern void _ZN6S112C53v87Ev();
extern void _ZN6S112C53v88Ev();
extern void _ZN6S112C53v89Ev();
extern void _ZN6S112C53v90Ev();
extern void _ZN6S112C53v91Ev();
extern void _ZN6S112C53v92Ev();
extern void _ZN6S112C53v93Ev();
extern void _ZN6S112C53v94Ev();
extern void _ZN6S112C53v95Ev();
extern void _ZN6S112C53v96Ev();
extern void _ZN6S112C53v97Ev();
extern void _ZN6S112C43v98Ev();
extern void _ZN6S112C43v99Ev();
extern void _ZN6S112C44v100Ev();
extern void _ZN6S112C44v101Ev();
extern void _ZN6S112C44v102Ev();
extern void _ZN6S112C44v103Ev();
extern void _ZN6S112C44v104Ev();
extern void _ZN6S112C44v105Ev();
extern void _ZN6S112C44v106Ev();
extern void _ZN6S112C44v107Ev();
extern void _ZN6S112C44v108Ev();
extern void _ZN6S112C44v109Ev();
extern void _ZN6S112C44v110Ev();
extern void _ZN6S112C44v111Ev();
extern void _ZN6S112C44v112Ev();
extern void _ZN6S112C44v113Ev();
extern void _ZN6S112C44v114Ev();
extern void _ZN6S112C44v115Ev();
extern void _ZN6S112C44v116Ev();
extern void _ZN6S112C44v117Ev();
extern void _ZN6S112C44v118Ev();
extern void _ZN6S112C44v119Ev();
extern void _ZN6S112C44v120Ev();
extern void _ZN6S112C44v121Ev();
extern void _ZN6S112C44v122Ev();
extern void _ZN6S112C44v123Ev();
extern void _ZN6S112C44v124Ev();
extern void _ZN6S112C44v125Ev();
extern void _ZN6S112C44v126Ev();
extern void _ZN6S112C44v127Ev();
extern void _ZN6S112C44v128Ev();
extern void _ZN6S112C44v129Ev();
extern void _ZN6S112C44v130Ev();
extern void _ZN6S112C44v131Ev();
extern void _ZN6S112C44v132Ev();
extern void _ZN6S112C44v133Ev();
extern void _ZN6S112C44v134Ev();
extern void _ZN6S112C44v135Ev();
extern void _ZN6S112C44v136Ev();
extern void _ZN6S112C44v137Ev();
extern void _ZN6S112C44v138Ev();
extern void _ZN6S112C44v139Ev();
extern void _ZN6S112C44v140Ev();
extern void _ZN6S112C44v141Ev();
extern void _ZN6S112C44v142Ev();
extern void _ZN6S112C44v143Ev();
extern void _ZN6S112C44v144Ev();
extern void _ZN6S112C44v145Ev();
extern void _ZN6S112C44v146Ev();
extern void _ZN6S112C44v147Ev();
extern void _ZN6S112C44v148Ev();
extern void _ZN6S112C44v149Ev();
extern void _ZN6S112C44v150Ev();
extern void _ZN6S112C44v151Ev();
extern void _ZN6S112C44v152Ev();
extern void _ZN6S112C44v153Ev();
extern void _ZN6S112C44v154Ev();
extern void _ZN6S112C44v155Ev();
extern void _ZN6S112C44v156Ev();
extern void _ZN6S112C44v157Ev();
extern void _ZN6S112C44v158Ev();
extern void _ZN6S112C34v159Ev();
extern void _ZN6S112C34v160Ev();
extern void _ZN6S112C34v161Ev();
extern void _ZN6S112C34v162Ev();
static  VTBL_ENTRY vtc_S112C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C3[0]),
  (VTBL_ENTRY)&_ZN6S112C3D1Ev,
  (VTBL_ENTRY)&_ZN6S112C3D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
  (VTBL_ENTRY)&_ZN6S112C53v76Ev,
  (VTBL_ENTRY)&_ZN6S112C53v77Ev,
  (VTBL_ENTRY)&_ZN6S112C53v78Ev,
  (VTBL_ENTRY)&_ZN6S112C53v79Ev,
  (VTBL_ENTRY)&_ZN6S112C53v80Ev,
  (VTBL_ENTRY)&_ZN6S112C53v81Ev,
  (VTBL_ENTRY)&_ZN6S112C53v82Ev,
  (VTBL_ENTRY)&_ZN6S112C53v83Ev,
  (VTBL_ENTRY)&_ZN6S112C53v84Ev,
  (VTBL_ENTRY)&_ZN6S112C53v85Ev,
  (VTBL_ENTRY)&_ZN6S112C53v86Ev,
  (VTBL_ENTRY)&_ZN6S112C53v87Ev,
  (VTBL_ENTRY)&_ZN6S112C53v88Ev,
  (VTBL_ENTRY)&_ZN6S112C53v89Ev,
  (VTBL_ENTRY)&_ZN6S112C53v90Ev,
  (VTBL_ENTRY)&_ZN6S112C53v91Ev,
  (VTBL_ENTRY)&_ZN6S112C53v92Ev,
  (VTBL_ENTRY)&_ZN6S112C53v93Ev,
  (VTBL_ENTRY)&_ZN6S112C53v94Ev,
  (VTBL_ENTRY)&_ZN6S112C53v95Ev,
  (VTBL_ENTRY)&_ZN6S112C53v96Ev,
  (VTBL_ENTRY)&_ZN6S112C53v97Ev,
  (VTBL_ENTRY)&_ZN6S112C43v98Ev,
  (VTBL_ENTRY)&_ZN6S112C43v99Ev,
  (VTBL_ENTRY)&_ZN6S112C44v100Ev,
  (VTBL_ENTRY)&_ZN6S112C44v101Ev,
  (VTBL_ENTRY)&_ZN6S112C44v102Ev,
  (VTBL_ENTRY)&_ZN6S112C44v103Ev,
  (VTBL_ENTRY)&_ZN6S112C44v104Ev,
  (VTBL_ENTRY)&_ZN6S112C44v105Ev,
  (VTBL_ENTRY)&_ZN6S112C44v106Ev,
  (VTBL_ENTRY)&_ZN6S112C44v107Ev,
  (VTBL_ENTRY)&_ZN6S112C44v108Ev,
  (VTBL_ENTRY)&_ZN6S112C44v109Ev,
  (VTBL_ENTRY)&_ZN6S112C44v110Ev,
  (VTBL_ENTRY)&_ZN6S112C44v111Ev,
  (VTBL_ENTRY)&_ZN6S112C44v112Ev,
  (VTBL_ENTRY)&_ZN6S112C44v113Ev,
  (VTBL_ENTRY)&_ZN6S112C44v114Ev,
  (VTBL_ENTRY)&_ZN6S112C44v115Ev,
  (VTBL_ENTRY)&_ZN6S112C44v116Ev,
  (VTBL_ENTRY)&_ZN6S112C44v117Ev,
  (VTBL_ENTRY)&_ZN6S112C44v118Ev,
  (VTBL_ENTRY)&_ZN6S112C44v119Ev,
  (VTBL_ENTRY)&_ZN6S112C44v120Ev,
  (VTBL_ENTRY)&_ZN6S112C44v121Ev,
  (VTBL_ENTRY)&_ZN6S112C44v122Ev,
  (VTBL_ENTRY)&_ZN6S112C44v123Ev,
  (VTBL_ENTRY)&_ZN6S112C44v124Ev,
  (VTBL_ENTRY)&_ZN6S112C44v125Ev,
  (VTBL_ENTRY)&_ZN6S112C44v126Ev,
  (VTBL_ENTRY)&_ZN6S112C44v127Ev,
  (VTBL_ENTRY)&_ZN6S112C44v128Ev,
  (VTBL_ENTRY)&_ZN6S112C44v129Ev,
  (VTBL_ENTRY)&_ZN6S112C44v130Ev,
  (VTBL_ENTRY)&_ZN6S112C44v131Ev,
  (VTBL_ENTRY)&_ZN6S112C44v132Ev,
  (VTBL_ENTRY)&_ZN6S112C44v133Ev,
  (VTBL_ENTRY)&_ZN6S112C44v134Ev,
  (VTBL_ENTRY)&_ZN6S112C44v135Ev,
  (VTBL_ENTRY)&_ZN6S112C44v136Ev,
  (VTBL_ENTRY)&_ZN6S112C44v137Ev,
  (VTBL_ENTRY)&_ZN6S112C44v138Ev,
  (VTBL_ENTRY)&_ZN6S112C44v139Ev,
  (VTBL_ENTRY)&_ZN6S112C44v140Ev,
  (VTBL_ENTRY)&_ZN6S112C44v141Ev,
  (VTBL_ENTRY)&_ZN6S112C44v142Ev,
  (VTBL_ENTRY)&_ZN6S112C44v143Ev,
  (VTBL_ENTRY)&_ZN6S112C44v144Ev,
  (VTBL_ENTRY)&_ZN6S112C44v145Ev,
  (VTBL_ENTRY)&_ZN6S112C44v146Ev,
  (VTBL_ENTRY)&_ZN6S112C44v147Ev,
  (VTBL_ENTRY)&_ZN6S112C44v148Ev,
  (VTBL_ENTRY)&_ZN6S112C44v149Ev,
  (VTBL_ENTRY)&_ZN6S112C44v150Ev,
  (VTBL_ENTRY)&_ZN6S112C44v151Ev,
  (VTBL_ENTRY)&_ZN6S112C44v152Ev,
  (VTBL_ENTRY)&_ZN6S112C44v153Ev,
  (VTBL_ENTRY)&_ZN6S112C44v154Ev,
  (VTBL_ENTRY)&_ZN6S112C44v155Ev,
  (VTBL_ENTRY)&_ZN6S112C44v156Ev,
  (VTBL_ENTRY)&_ZN6S112C44v157Ev,
  (VTBL_ENTRY)&_ZN6S112C44v158Ev,
  (VTBL_ENTRY)&_ZN6S112C34v159Ev,
  (VTBL_ENTRY)&_ZN6S112C34v160Ev,
  (VTBL_ENTRY)&_ZN6S112C34v161Ev,
  (VTBL_ENTRY)&_ZN6S112C34v162Ev,
};
extern VTBL_ENTRY _ZTI6S112C3[];
extern  VTBL_ENTRY _ZTV6S112C3[];
Class_Descriptor cd_S112C3 = {  "S112C3", // class name
  bases_S112C3, 4,
  &(vtc_S112C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,284), // object size
  NSPAIRA(_ZTI6S112C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C3),160, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C22_nt  {
  void  mf112c22(); // _ZN10S112C22_nt8mf112c22Ev
};
//SIG(-1 S112C22_nt) C1{ m}


void  S112C22_nt ::mf112c22(){}

//skip512 S112C22_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S112C22_nt[];
VTBL_ENTRY *P__ZTI10S112C22_nt = _ZTI10S112C22_nt; 
Class_Descriptor cd_S112C22_nt = {  "S112C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S112C22_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C2  : S112C3 {
  int s112c2f0[2];
  void *s112c2f1;
  ::S112C22_nt s112c2f2;
  unsigned int s112c2f3:1;
  unsigned int s112c2f4:1;
  int s112c2f5[4];
  unsigned int s112c2f6:1;
  ::S95C38 s112c2f7;
  ::S95C36 s112c2f8;
  virtual  ~S112C2(); // _ZN6S112C2D1Ev
  virtual void  v163(); // _ZN6S112C24v163Ev
  virtual void  v164(); // _ZN6S112C24v164Ev
  virtual void  v165(); // _ZN6S112C24v165Ev
  virtual void  v166(); // _ZN6S112C24v166Ev
  virtual void  v167(); // _ZN6S112C24v167Ev
  virtual void  v168(); // _ZN6S112C24v168Ev
  virtual void  v169(); // _ZN6S112C24v169Ev
  virtual void  v170(); // _ZN6S112C24v170Ev
  virtual void  v171(); // _ZN6S112C24v171Ev
  virtual void  v172(); // _ZN6S112C24v172Ev
  virtual void  v173(); // _ZN6S112C24v173Ev
  virtual void  v174(); // _ZN6S112C24v174Ev
  virtual void  v175(); // _ZN6S112C24v175Ev
  virtual void  v176(); // _ZN6S112C24v176Ev
  virtual void  v177(); // _ZN6S112C24v177Ev
  virtual void  v178(); // _ZN6S112C24v178Ev
  virtual void  v179(); // _ZN6S112C24v179Ev
  virtual void  v180(); // _ZN6S112C24v180Ev
  virtual void  v181(); // _ZN6S112C24v181Ev
  virtual void  v182(); // _ZN6S112C24v182Ev
  virtual void  v183(); // _ZN6S112C24v183Ev
  virtual void  v184(); // _ZN6S112C24v184Ev
  virtual void  v185(); // _ZN6S112C24v185Ev
  virtual void  v186(); // _ZN6S112C24v186Ev
  virtual void  v187(); // _ZN6S112C24v187Ev
  virtual void  v188(); // _ZN6S112C24v188Ev
  virtual void  v189(); // _ZN6S112C24v189Ev
  virtual void  v190(); // _ZN6S112C24v190Ev
  virtual void  v191(); // _ZN6S112C24v191Ev
  virtual void  v192(); // _ZN6S112C24v192Ev
  virtual void  v193(); // _ZN6S112C24v193Ev
  virtual void  v194(); // _ZN6S112C24v194Ev
  S112C2(); // tgen
};
//SIG(-1 S112C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v97 v98 v99 v100 v101 Fp FC7} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 Fp FC8{ m Fi} Fi FC9{ m} Fi FC10{ BC11{ m Fp Fi[2]}} Fi Fp[2] FC12{ m FC13{ m Fi[3]} FC13 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC15{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC10} Fp[2] Fc FC9 FC17{ m Fi[3]} FC13 Fi FC17 Fi:1 Fi:1 Fi:1 Fi[3]} vd v185 v186 v187 v188 FC18{ BC19{ BC11}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fi[2] Fp FC20{ m} Fi:1 Fi:1 Fi[4] Fi:1 FC21{ BC11} FC19}


 S112C2 ::~S112C2(){ note_dtor("S112C2", this);}
void  S112C2 ::v163(){vfunc_called(this, "_ZN6S112C24v163Ev");}
void  S112C2 ::v164(){vfunc_called(this, "_ZN6S112C24v164Ev");}
void  S112C2 ::v165(){vfunc_called(this, "_ZN6S112C24v165Ev");}
void  S112C2 ::v166(){vfunc_called(this, "_ZN6S112C24v166Ev");}
void  S112C2 ::v167(){vfunc_called(this, "_ZN6S112C24v167Ev");}
void  S112C2 ::v168(){vfunc_called(this, "_ZN6S112C24v168Ev");}
void  S112C2 ::v169(){vfunc_called(this, "_ZN6S112C24v169Ev");}
void  S112C2 ::v170(){vfunc_called(this, "_ZN6S112C24v170Ev");}
void  S112C2 ::v171(){vfunc_called(this, "_ZN6S112C24v171Ev");}
void  S112C2 ::v172(){vfunc_called(this, "_ZN6S112C24v172Ev");}
void  S112C2 ::v173(){vfunc_called(this, "_ZN6S112C24v173Ev");}
void  S112C2 ::v174(){vfunc_called(this, "_ZN6S112C24v174Ev");}
void  S112C2 ::v175(){vfunc_called(this, "_ZN6S112C24v175Ev");}
void  S112C2 ::v176(){vfunc_called(this, "_ZN6S112C24v176Ev");}
void  S112C2 ::v177(){vfunc_called(this, "_ZN6S112C24v177Ev");}
void  S112C2 ::v178(){vfunc_called(this, "_ZN6S112C24v178Ev");}
void  S112C2 ::v179(){vfunc_called(this, "_ZN6S112C24v179Ev");}
void  S112C2 ::v180(){vfunc_called(this, "_ZN6S112C24v180Ev");}
void  S112C2 ::v181(){vfunc_called(this, "_ZN6S112C24v181Ev");}
void  S112C2 ::v182(){vfunc_called(this, "_ZN6S112C24v182Ev");}
void  S112C2 ::v183(){vfunc_called(this, "_ZN6S112C24v183Ev");}
void  S112C2 ::v184(){vfunc_called(this, "_ZN6S112C24v184Ev");}
void  S112C2 ::v185(){vfunc_called(this, "_ZN6S112C24v185Ev");}
void  S112C2 ::v186(){vfunc_called(this, "_ZN6S112C24v186Ev");}
void  S112C2 ::v187(){vfunc_called(this, "_ZN6S112C24v187Ev");}
void  S112C2 ::v188(){vfunc_called(this, "_ZN6S112C24v188Ev");}
void  S112C2 ::v189(){vfunc_called(this, "_ZN6S112C24v189Ev");}
void  S112C2 ::v190(){vfunc_called(this, "_ZN6S112C24v190Ev");}
void  S112C2 ::v191(){vfunc_called(this, "_ZN6S112C24v191Ev");}
void  S112C2 ::v192(){vfunc_called(this, "_ZN6S112C24v192Ev");}
void  S112C2 ::v193(){vfunc_called(this, "_ZN6S112C24v193Ev");}
void  S112C2 ::v194(){vfunc_called(this, "_ZN6S112C24v194Ev");}
S112C2 ::S112C2(){ note_ctor("S112C2", this);} // tgen

static void Test_S112C2()
{
  extern Class_Descriptor cd_S112C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(58,87)];
    init_test(&cd_S112C2, buf);
    S112C2 *dp, &lv = *(dp=new (buf) S112C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(456,344), "sizeof(S112C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C2)");
    check_base_class_offset(lv, (S112C7*)(S112C6*)(S112C5*)(S112C4*)(S112C3*), 0, "S112C2");
    check_base_class_offset(lv, (S112C6*)(S112C5*)(S112C4*)(S112C3*), 0, "S112C2");
    check_base_class_offset(lv, (S112C5*)(S112C4*)(S112C3*), 0, "S112C2");
    check_base_class_offset(lv, (S112C4*)(S112C3*), 0, "S112C2");
    check_base_class_offset(lv, (S112C3*), 0, "S112C2");
    check_field_offset(lv, s112c2f0, ABISELECT(384,284), "S112C2.s112c2f0");
    check_field_offset(lv, s112c2f1, ABISELECT(392,292), "S112C2.s112c2f1");
    check_field_offset(lv, s112c2f2, ABISELECT(400,296), "S112C2.s112c2f2");
    set_bf_and_test(lv, s112c2f3, ABISELECT(401,297), 0, 1, 1, "S112C2");
    set_bf_and_test(lv, s112c2f4, ABISELECT(401,297), 1, 1, 1, "S112C2");
    check_field_offset(lv, s112c2f5, ABISELECT(404,300), "S112C2.s112c2f5");
    set_bf_and_test(lv, s112c2f6, ABISELECT(420,316), 0, 1, 1, "S112C2");
    check_field_offset(lv, s112c2f7, ABISELECT(424,320), "S112C2.s112c2f7");
    check_field_offset(lv, s112c2f8, ABISELECT(440,332), "S112C2.s112c2f8");
    test_class_info(&lv, &cd_S112C2);
    dp->~S112C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C2(Test_S112C2, "S112C2", ABISELECT(456,344));

#else // __cplusplus

extern void _ZN6S112C2C1Ev();
extern void _ZN6S112C2D1Ev();
Name_Map name_map_S112C2[] = {
  NSPAIR(_ZN6S112C2C1Ev),
  NSPAIR(_ZN6S112C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
extern Class_Descriptor cd_S112C6;
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
extern Class_Descriptor cd_S112C5;
extern VTBL_ENTRY _ZTI6S112C5[];
extern  VTBL_ENTRY _ZTV6S112C5[];
extern Class_Descriptor cd_S112C4;
extern VTBL_ENTRY _ZTI6S112C4[];
extern  VTBL_ENTRY _ZTV6S112C4[];
extern Class_Descriptor cd_S112C3;
extern VTBL_ENTRY _ZTI6S112C3[];
extern  VTBL_ENTRY _ZTV6S112C3[];
static Base_Class bases_S112C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S112C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S112C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S112C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S112C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C2[];
extern void _ZN6S112C2D1Ev();
extern void _ZN6S112C2D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
extern void _ZN6S112C53v76Ev();
extern void _ZN6S112C53v77Ev();
extern void _ZN6S112C53v78Ev();
extern void _ZN6S112C53v79Ev();
extern void _ZN6S112C53v80Ev();
extern void _ZN6S112C53v81Ev();
extern void _ZN6S112C53v82Ev();
extern void _ZN6S112C53v83Ev();
extern void _ZN6S112C53v84Ev();
extern void _ZN6S112C53v85Ev();
extern void _ZN6S112C53v86Ev();
extern void _ZN6S112C53v87Ev();
extern void _ZN6S112C53v88Ev();
extern void _ZN6S112C53v89Ev();
extern void _ZN6S112C53v90Ev();
extern void _ZN6S112C53v91Ev();
extern void _ZN6S112C53v92Ev();
extern void _ZN6S112C53v93Ev();
extern void _ZN6S112C53v94Ev();
extern void _ZN6S112C53v95Ev();
extern void _ZN6S112C53v96Ev();
extern void _ZN6S112C53v97Ev();
extern void _ZN6S112C43v98Ev();
extern void _ZN6S112C43v99Ev();
extern void _ZN6S112C44v100Ev();
extern void _ZN6S112C44v101Ev();
extern void _ZN6S112C44v102Ev();
extern void _ZN6S112C44v103Ev();
extern void _ZN6S112C44v104Ev();
extern void _ZN6S112C44v105Ev();
extern void _ZN6S112C44v106Ev();
extern void _ZN6S112C44v107Ev();
extern void _ZN6S112C44v108Ev();
extern void _ZN6S112C44v109Ev();
extern void _ZN6S112C44v110Ev();
extern void _ZN6S112C44v111Ev();
extern void _ZN6S112C44v112Ev();
extern void _ZN6S112C44v113Ev();
extern void _ZN6S112C44v114Ev();
extern void _ZN6S112C44v115Ev();
extern void _ZN6S112C44v116Ev();
extern void _ZN6S112C44v117Ev();
extern void _ZN6S112C44v118Ev();
extern void _ZN6S112C44v119Ev();
extern void _ZN6S112C44v120Ev();
extern void _ZN6S112C44v121Ev();
extern void _ZN6S112C44v122Ev();
extern void _ZN6S112C44v123Ev();
extern void _ZN6S112C44v124Ev();
extern void _ZN6S112C44v125Ev();
extern void _ZN6S112C44v126Ev();
extern void _ZN6S112C44v127Ev();
extern void _ZN6S112C44v128Ev();
extern void _ZN6S112C44v129Ev();
extern void _ZN6S112C44v130Ev();
extern void _ZN6S112C44v131Ev();
extern void _ZN6S112C44v132Ev();
extern void _ZN6S112C44v133Ev();
extern void _ZN6S112C44v134Ev();
extern void _ZN6S112C44v135Ev();
extern void _ZN6S112C44v136Ev();
extern void _ZN6S112C44v137Ev();
extern void _ZN6S112C44v138Ev();
extern void _ZN6S112C44v139Ev();
extern void _ZN6S112C44v140Ev();
extern void _ZN6S112C44v141Ev();
extern void _ZN6S112C44v142Ev();
extern void _ZN6S112C44v143Ev();
extern void _ZN6S112C44v144Ev();
extern void _ZN6S112C44v145Ev();
extern void _ZN6S112C44v146Ev();
extern void _ZN6S112C44v147Ev();
extern void _ZN6S112C44v148Ev();
extern void _ZN6S112C44v149Ev();
extern void _ZN6S112C44v150Ev();
extern void _ZN6S112C44v151Ev();
extern void _ZN6S112C44v152Ev();
extern void _ZN6S112C44v153Ev();
extern void _ZN6S112C44v154Ev();
extern void _ZN6S112C44v155Ev();
extern void _ZN6S112C44v156Ev();
extern void _ZN6S112C44v157Ev();
extern void _ZN6S112C44v158Ev();
extern void _ZN6S112C34v159Ev();
extern void _ZN6S112C34v160Ev();
extern void _ZN6S112C34v161Ev();
extern void _ZN6S112C34v162Ev();
extern void _ZN6S112C24v163Ev();
extern void _ZN6S112C24v164Ev();
extern void _ZN6S112C24v165Ev();
extern void _ZN6S112C24v166Ev();
extern void _ZN6S112C24v167Ev();
extern void _ZN6S112C24v168Ev();
extern void _ZN6S112C24v169Ev();
extern void _ZN6S112C24v170Ev();
extern void _ZN6S112C24v171Ev();
extern void _ZN6S112C24v172Ev();
extern void _ZN6S112C24v173Ev();
extern void _ZN6S112C24v174Ev();
extern void _ZN6S112C24v175Ev();
extern void _ZN6S112C24v176Ev();
extern void _ZN6S112C24v177Ev();
extern void _ZN6S112C24v178Ev();
extern void _ZN6S112C24v179Ev();
extern void _ZN6S112C24v180Ev();
extern void _ZN6S112C24v181Ev();
extern void _ZN6S112C24v182Ev();
extern void _ZN6S112C24v183Ev();
extern void _ZN6S112C24v184Ev();
extern void _ZN6S112C24v185Ev();
extern void _ZN6S112C24v186Ev();
extern void _ZN6S112C24v187Ev();
extern void _ZN6S112C24v188Ev();
extern void _ZN6S112C24v189Ev();
extern void _ZN6S112C24v190Ev();
extern void _ZN6S112C24v191Ev();
extern void _ZN6S112C24v192Ev();
extern void _ZN6S112C24v193Ev();
extern void _ZN6S112C24v194Ev();
static  VTBL_ENTRY vtc_S112C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C2[0]),
  (VTBL_ENTRY)&_ZN6S112C2D1Ev,
  (VTBL_ENTRY)&_ZN6S112C2D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
  (VTBL_ENTRY)&_ZN6S112C53v76Ev,
  (VTBL_ENTRY)&_ZN6S112C53v77Ev,
  (VTBL_ENTRY)&_ZN6S112C53v78Ev,
  (VTBL_ENTRY)&_ZN6S112C53v79Ev,
  (VTBL_ENTRY)&_ZN6S112C53v80Ev,
  (VTBL_ENTRY)&_ZN6S112C53v81Ev,
  (VTBL_ENTRY)&_ZN6S112C53v82Ev,
  (VTBL_ENTRY)&_ZN6S112C53v83Ev,
  (VTBL_ENTRY)&_ZN6S112C53v84Ev,
  (VTBL_ENTRY)&_ZN6S112C53v85Ev,
  (VTBL_ENTRY)&_ZN6S112C53v86Ev,
  (VTBL_ENTRY)&_ZN6S112C53v87Ev,
  (VTBL_ENTRY)&_ZN6S112C53v88Ev,
  (VTBL_ENTRY)&_ZN6S112C53v89Ev,
  (VTBL_ENTRY)&_ZN6S112C53v90Ev,
  (VTBL_ENTRY)&_ZN6S112C53v91Ev,
  (VTBL_ENTRY)&_ZN6S112C53v92Ev,
  (VTBL_ENTRY)&_ZN6S112C53v93Ev,
  (VTBL_ENTRY)&_ZN6S112C53v94Ev,
  (VTBL_ENTRY)&_ZN6S112C53v95Ev,
  (VTBL_ENTRY)&_ZN6S112C53v96Ev,
  (VTBL_ENTRY)&_ZN6S112C53v97Ev,
  (VTBL_ENTRY)&_ZN6S112C43v98Ev,
  (VTBL_ENTRY)&_ZN6S112C43v99Ev,
  (VTBL_ENTRY)&_ZN6S112C44v100Ev,
  (VTBL_ENTRY)&_ZN6S112C44v101Ev,
  (VTBL_ENTRY)&_ZN6S112C44v102Ev,
  (VTBL_ENTRY)&_ZN6S112C44v103Ev,
  (VTBL_ENTRY)&_ZN6S112C44v104Ev,
  (VTBL_ENTRY)&_ZN6S112C44v105Ev,
  (VTBL_ENTRY)&_ZN6S112C44v106Ev,
  (VTBL_ENTRY)&_ZN6S112C44v107Ev,
  (VTBL_ENTRY)&_ZN6S112C44v108Ev,
  (VTBL_ENTRY)&_ZN6S112C44v109Ev,
  (VTBL_ENTRY)&_ZN6S112C44v110Ev,
  (VTBL_ENTRY)&_ZN6S112C44v111Ev,
  (VTBL_ENTRY)&_ZN6S112C44v112Ev,
  (VTBL_ENTRY)&_ZN6S112C44v113Ev,
  (VTBL_ENTRY)&_ZN6S112C44v114Ev,
  (VTBL_ENTRY)&_ZN6S112C44v115Ev,
  (VTBL_ENTRY)&_ZN6S112C44v116Ev,
  (VTBL_ENTRY)&_ZN6S112C44v117Ev,
  (VTBL_ENTRY)&_ZN6S112C44v118Ev,
  (VTBL_ENTRY)&_ZN6S112C44v119Ev,
  (VTBL_ENTRY)&_ZN6S112C44v120Ev,
  (VTBL_ENTRY)&_ZN6S112C44v121Ev,
  (VTBL_ENTRY)&_ZN6S112C44v122Ev,
  (VTBL_ENTRY)&_ZN6S112C44v123Ev,
  (VTBL_ENTRY)&_ZN6S112C44v124Ev,
  (VTBL_ENTRY)&_ZN6S112C44v125Ev,
  (VTBL_ENTRY)&_ZN6S112C44v126Ev,
  (VTBL_ENTRY)&_ZN6S112C44v127Ev,
  (VTBL_ENTRY)&_ZN6S112C44v128Ev,
  (VTBL_ENTRY)&_ZN6S112C44v129Ev,
  (VTBL_ENTRY)&_ZN6S112C44v130Ev,
  (VTBL_ENTRY)&_ZN6S112C44v131Ev,
  (VTBL_ENTRY)&_ZN6S112C44v132Ev,
  (VTBL_ENTRY)&_ZN6S112C44v133Ev,
  (VTBL_ENTRY)&_ZN6S112C44v134Ev,
  (VTBL_ENTRY)&_ZN6S112C44v135Ev,
  (VTBL_ENTRY)&_ZN6S112C44v136Ev,
  (VTBL_ENTRY)&_ZN6S112C44v137Ev,
  (VTBL_ENTRY)&_ZN6S112C44v138Ev,
  (VTBL_ENTRY)&_ZN6S112C44v139Ev,
  (VTBL_ENTRY)&_ZN6S112C44v140Ev,
  (VTBL_ENTRY)&_ZN6S112C44v141Ev,
  (VTBL_ENTRY)&_ZN6S112C44v142Ev,
  (VTBL_ENTRY)&_ZN6S112C44v143Ev,
  (VTBL_ENTRY)&_ZN6S112C44v144Ev,
  (VTBL_ENTRY)&_ZN6S112C44v145Ev,
  (VTBL_ENTRY)&_ZN6S112C44v146Ev,
  (VTBL_ENTRY)&_ZN6S112C44v147Ev,
  (VTBL_ENTRY)&_ZN6S112C44v148Ev,
  (VTBL_ENTRY)&_ZN6S112C44v149Ev,
  (VTBL_ENTRY)&_ZN6S112C44v150Ev,
  (VTBL_ENTRY)&_ZN6S112C44v151Ev,
  (VTBL_ENTRY)&_ZN6S112C44v152Ev,
  (VTBL_ENTRY)&_ZN6S112C44v153Ev,
  (VTBL_ENTRY)&_ZN6S112C44v154Ev,
  (VTBL_ENTRY)&_ZN6S112C44v155Ev,
  (VTBL_ENTRY)&_ZN6S112C44v156Ev,
  (VTBL_ENTRY)&_ZN6S112C44v157Ev,
  (VTBL_ENTRY)&_ZN6S112C44v158Ev,
  (VTBL_ENTRY)&_ZN6S112C34v159Ev,
  (VTBL_ENTRY)&_ZN6S112C34v160Ev,
  (VTBL_ENTRY)&_ZN6S112C34v161Ev,
  (VTBL_ENTRY)&_ZN6S112C34v162Ev,
  (VTBL_ENTRY)&_ZN6S112C24v163Ev,
  (VTBL_ENTRY)&_ZN6S112C24v164Ev,
  (VTBL_ENTRY)&_ZN6S112C24v165Ev,
  (VTBL_ENTRY)&_ZN6S112C24v166Ev,
  (VTBL_ENTRY)&_ZN6S112C24v167Ev,
  (VTBL_ENTRY)&_ZN6S112C24v168Ev,
  (VTBL_ENTRY)&_ZN6S112C24v169Ev,
  (VTBL_ENTRY)&_ZN6S112C24v170Ev,
  (VTBL_ENTRY)&_ZN6S112C24v171Ev,
  (VTBL_ENTRY)&_ZN6S112C24v172Ev,
  (VTBL_ENTRY)&_ZN6S112C24v173Ev,
  (VTBL_ENTRY)&_ZN6S112C24v174Ev,
  (VTBL_ENTRY)&_ZN6S112C24v175Ev,
  (VTBL_ENTRY)&_ZN6S112C24v176Ev,
  (VTBL_ENTRY)&_ZN6S112C24v177Ev,
  (VTBL_ENTRY)&_ZN6S112C24v178Ev,
  (VTBL_ENTRY)&_ZN6S112C24v179Ev,
  (VTBL_ENTRY)&_ZN6S112C24v180Ev,
  (VTBL_ENTRY)&_ZN6S112C24v181Ev,
  (VTBL_ENTRY)&_ZN6S112C24v182Ev,
  (VTBL_ENTRY)&_ZN6S112C24v183Ev,
  (VTBL_ENTRY)&_ZN6S112C24v184Ev,
  (VTBL_ENTRY)&_ZN6S112C24v185Ev,
  (VTBL_ENTRY)&_ZN6S112C24v186Ev,
  (VTBL_ENTRY)&_ZN6S112C24v187Ev,
  (VTBL_ENTRY)&_ZN6S112C24v188Ev,
  (VTBL_ENTRY)&_ZN6S112C24v189Ev,
  (VTBL_ENTRY)&_ZN6S112C24v190Ev,
  (VTBL_ENTRY)&_ZN6S112C24v191Ev,
  (VTBL_ENTRY)&_ZN6S112C24v192Ev,
  (VTBL_ENTRY)&_ZN6S112C24v193Ev,
  (VTBL_ENTRY)&_ZN6S112C24v194Ev,
};
extern VTBL_ENTRY _ZTI6S112C2[];
extern  VTBL_ENTRY _ZTV6S112C2[];
Class_Descriptor cd_S112C2 = {  "S112C2", // class name
  bases_S112C2, 5,
  &(vtc_S112C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(456,344), // object size
  NSPAIRA(_ZTI6S112C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C2),192, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S112C1  : S112C2 {
  ::S95C31 s112c1f0;
  ::S236C18_nt s112c1f1;
  void *s112c1f2[3];
  virtual  ~S112C1(); // _ZN6S112C1D1Ev
  virtual void  v1(); // _ZN6S112C12v1Ev
  virtual void  v2(); // _ZN6S112C12v2Ev
  virtual void  v3(); // _ZN6S112C12v3Ev
  virtual void  v4(); // _ZN6S112C12v4Ev
  virtual void  v5(); // _ZN6S112C12v5Ev
  virtual void  v6(); // _ZN6S112C12v6Ev
  S112C1(); // tgen
};
//SIG(1 S112C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 Fp FC8} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 Fp FC9{ m Fi} Fi FC10{ m} Fi FC11{ BC12{ m Fp Fi[2]}} Fi Fp[2] FC13{ m FC14{ m Fi[3]} FC14 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC16{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC11} Fp[2] Fc FC10 FC18{ m Fi[3]} FC14 Fi FC18 Fi:1 Fi:1 Fi:1 Fi[3]} vd v159 v160 v161 v162 FC19{ BC20{ BC12}}} vd v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 Fi[2] Fp FC21{ m} Fi:1 Fi:1 Fi[4] Fi:1 FC22{ BC12} FC20} vd v1 v2 v3 v4 v5 v6 FC23{ BC24{ BC12}} FC18 Fp[3]}


 S112C1 ::~S112C1(){ note_dtor("S112C1", this);}
void  S112C1 ::v1(){vfunc_called(this, "_ZN6S112C12v1Ev");}
void  S112C1 ::v2(){vfunc_called(this, "_ZN6S112C12v2Ev");}
void  S112C1 ::v3(){vfunc_called(this, "_ZN6S112C12v3Ev");}
void  S112C1 ::v4(){vfunc_called(this, "_ZN6S112C12v4Ev");}
void  S112C1 ::v5(){vfunc_called(this, "_ZN6S112C12v5Ev");}
void  S112C1 ::v6(){vfunc_called(this, "_ZN6S112C12v6Ev");}
S112C1 ::S112C1(){ note_ctor("S112C1", this);} // tgen

static void Test_S112C1()
{
  extern Class_Descriptor cd_S112C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(65,96)];
    init_test(&cd_S112C1, buf);
    S112C1 *dp, &lv = *(dp=new (buf) S112C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,380), "sizeof(S112C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S112C1)");
    check_base_class_offset(lv, (S112C7*)(S112C6*)(S112C5*)(S112C4*)(S112C3*)(S112C2*), 0, "S112C1");
    check_base_class_offset(lv, (S112C6*)(S112C5*)(S112C4*)(S112C3*)(S112C2*), 0, "S112C1");
    check_base_class_offset(lv, (S112C5*)(S112C4*)(S112C3*)(S112C2*), 0, "S112C1");
    check_base_class_offset(lv, (S112C4*)(S112C3*)(S112C2*), 0, "S112C1");
    check_base_class_offset(lv, (S112C3*)(S112C2*), 0, "S112C1");
    check_base_class_offset(lv, (S112C2*), 0, "S112C1");
    check_field_offset(lv, s112c1f0, ABISELECT(456,344), "S112C1.s112c1f0");
    check_field_offset(lv, s112c1f1, ABISELECT(472,356), "S112C1.s112c1f1");
    check_field_offset(lv, s112c1f2, ABISELECT(488,368), "S112C1.s112c1f2");
    test_class_info(&lv, &cd_S112C1);
    dp->~S112C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS112C1(Test_S112C1, "S112C1", ABISELECT(512,380));

#else // __cplusplus

extern void _ZN6S112C1C1Ev();
extern void _ZN6S112C1D1Ev();
Name_Map name_map_S112C1[] = {
  NSPAIR(_ZN6S112C1C1Ev),
  NSPAIR(_ZN6S112C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S112C7;
extern VTBL_ENTRY _ZTI6S112C7[];
extern  VTBL_ENTRY _ZTV6S112C7[];
extern Class_Descriptor cd_S112C6;
extern VTBL_ENTRY _ZTI6S112C6[];
extern  VTBL_ENTRY _ZTV6S112C6[];
extern Class_Descriptor cd_S112C5;
extern VTBL_ENTRY _ZTI6S112C5[];
extern  VTBL_ENTRY _ZTV6S112C5[];
extern Class_Descriptor cd_S112C4;
extern VTBL_ENTRY _ZTI6S112C4[];
extern  VTBL_ENTRY _ZTV6S112C4[];
extern Class_Descriptor cd_S112C3;
extern VTBL_ENTRY _ZTI6S112C3[];
extern  VTBL_ENTRY _ZTV6S112C3[];
extern Class_Descriptor cd_S112C2;
extern VTBL_ENTRY _ZTI6S112C2[];
extern  VTBL_ENTRY _ZTV6S112C2[];
static Base_Class bases_S112C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S112C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S112C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S112C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S112C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S112C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S112C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S112C1[];
extern void _ZN6S112C1D1Ev();
extern void _ZN6S112C1D0Ev();
extern void _ZN6S112C72v7Ev();
extern void _ZN6S112C72v8Ev();
extern void _ZN6S112C72v9Ev();
extern void _ZN6S112C73v10Ev();
extern void _ZN6S112C73v11Ev();
extern void _ZN6S112C73v12Ev();
extern void _ZN6S112C73v13Ev();
extern void _ZN6S112C73v14Ev();
extern void _ZN6S112C73v15Ev();
extern void _ZN6S112C73v16Ev();
extern void _ZN6S112C73v17Ev();
extern void _ZN6S112C73v18Ev();
extern void _ZN6S112C73v19Ev();
extern void _ZN6S112C73v20Ev();
extern void _ZN6S112C73v21Ev();
extern void _ZN6S112C73v22Ev();
extern void _ZN6S112C73v23Ev();
extern void _ZN6S112C73v24Ev();
extern void _ZN6S112C73v25Ev();
extern void _ZN6S112C73v26Ev();
extern void _ZN6S112C73v27Ev();
extern void _ZN6S112C73v28Ev();
extern void _ZN6S112C73v29Ev();
extern void _ZN6S112C73v30Ev();
extern void _ZN6S112C73v31Ev();
extern void _ZN6S112C73v32Ev();
extern void _ZN6S112C73v33Ev();
extern void _ZN6S112C73v34Ev();
extern void _ZN6S112C73v35Ev();
extern void _ZN6S112C73v36Ev();
extern void _ZN6S112C73v37Ev();
extern void _ZN6S112C73v38Ev();
extern void _ZN6S112C73v39Ev();
extern void _ZN6S112C73v40Ev();
extern void _ZN6S112C73v41Ev();
extern void _ZN6S112C73v42Ev();
extern void _ZN6S112C73v43Ev();
extern void _ZN6S112C73v44Ev();
extern void _ZN6S112C73v45Ev();
extern void _ZN6S112C73v46Ev();
extern void _ZN6S112C73v47Ev();
extern void _ZN6S112C73v48Ev();
extern void _ZN6S112C73v49Ev();
extern void _ZN6S112C73v50Ev();
extern void _ZN6S112C73v51Ev();
extern void _ZN6S112C73v52Ev();
extern void _ZN6S112C73v53Ev();
extern void _ZN6S112C73v54Ev();
extern void _ZN6S112C73v55Ev();
extern void _ZN6S112C73v56Ev();
extern void _ZN6S112C73v57Ev();
extern void _ZN6S112C73v58Ev();
extern void _ZN6S112C73v59Ev();
extern void _ZN6S112C73v60Ev();
extern void _ZN6S112C73v61Ev();
extern void _ZN6S112C73v62Ev();
extern void _ZN6S112C73v63Ev();
extern void _ZN6S112C73v64Ev();
extern void _ZN6S112C73v65Ev();
extern void _ZN6S112C73v66Ev();
extern void _ZN6S112C73v67Ev();
extern void _ZN6S112C73v68Ev();
extern void _ZN6S112C73v69Ev();
extern void _ZN6S112C73v70Ev();
extern void _ZN6S112C63v71Ev();
extern void _ZN6S112C63v72Ev();
extern void _ZN6S112C63v73Ev();
extern void _ZN6S112C63v74Ev();
extern void _ZN6S112C63v75Ev();
extern void _ZN6S112C53v76Ev();
extern void _ZN6S112C53v77Ev();
extern void _ZN6S112C53v78Ev();
extern void _ZN6S112C53v79Ev();
extern void _ZN6S112C53v80Ev();
extern void _ZN6S112C53v81Ev();
extern void _ZN6S112C53v82Ev();
extern void _ZN6S112C53v83Ev();
extern void _ZN6S112C53v84Ev();
extern void _ZN6S112C53v85Ev();
extern void _ZN6S112C53v86Ev();
extern void _ZN6S112C53v87Ev();
extern void _ZN6S112C53v88Ev();
extern void _ZN6S112C53v89Ev();
extern void _ZN6S112C53v90Ev();
extern void _ZN6S112C53v91Ev();
extern void _ZN6S112C53v92Ev();
extern void _ZN6S112C53v93Ev();
extern void _ZN6S112C53v94Ev();
extern void _ZN6S112C53v95Ev();
extern void _ZN6S112C53v96Ev();
extern void _ZN6S112C53v97Ev();
extern void _ZN6S112C43v98Ev();
extern void _ZN6S112C43v99Ev();
extern void _ZN6S112C44v100Ev();
extern void _ZN6S112C44v101Ev();
extern void _ZN6S112C44v102Ev();
extern void _ZN6S112C44v103Ev();
extern void _ZN6S112C44v104Ev();
extern void _ZN6S112C44v105Ev();
extern void _ZN6S112C44v106Ev();
extern void _ZN6S112C44v107Ev();
extern void _ZN6S112C44v108Ev();
extern void _ZN6S112C44v109Ev();
extern void _ZN6S112C44v110Ev();
extern void _ZN6S112C44v111Ev();
extern void _ZN6S112C44v112Ev();
extern void _ZN6S112C44v113Ev();
extern void _ZN6S112C44v114Ev();
extern void _ZN6S112C44v115Ev();
extern void _ZN6S112C44v116Ev();
extern void _ZN6S112C44v117Ev();
extern void _ZN6S112C44v118Ev();
extern void _ZN6S112C44v119Ev();
extern void _ZN6S112C44v120Ev();
extern void _ZN6S112C44v121Ev();
extern void _ZN6S112C44v122Ev();
extern void _ZN6S112C44v123Ev();
extern void _ZN6S112C44v124Ev();
extern void _ZN6S112C44v125Ev();
extern void _ZN6S112C44v126Ev();
extern void _ZN6S112C44v127Ev();
extern void _ZN6S112C44v128Ev();
extern void _ZN6S112C44v129Ev();
extern void _ZN6S112C44v130Ev();
extern void _ZN6S112C44v131Ev();
extern void _ZN6S112C44v132Ev();
extern void _ZN6S112C44v133Ev();
extern void _ZN6S112C44v134Ev();
extern void _ZN6S112C44v135Ev();
extern void _ZN6S112C44v136Ev();
extern void _ZN6S112C44v137Ev();
extern void _ZN6S112C44v138Ev();
extern void _ZN6S112C44v139Ev();
extern void _ZN6S112C44v140Ev();
extern void _ZN6S112C44v141Ev();
extern void _ZN6S112C44v142Ev();
extern void _ZN6S112C44v143Ev();
extern void _ZN6S112C44v144Ev();
extern void _ZN6S112C44v145Ev();
extern void _ZN6S112C44v146Ev();
extern void _ZN6S112C44v147Ev();
extern void _ZN6S112C44v148Ev();
extern void _ZN6S112C44v149Ev();
extern void _ZN6S112C44v150Ev();
extern void _ZN6S112C44v151Ev();
extern void _ZN6S112C44v152Ev();
extern void _ZN6S112C44v153Ev();
extern void _ZN6S112C44v154Ev();
extern void _ZN6S112C44v155Ev();
extern void _ZN6S112C44v156Ev();
extern void _ZN6S112C44v157Ev();
extern void _ZN6S112C44v158Ev();
extern void _ZN6S112C34v159Ev();
extern void _ZN6S112C34v160Ev();
extern void _ZN6S112C34v161Ev();
extern void _ZN6S112C34v162Ev();
extern void _ZN6S112C24v163Ev();
extern void _ZN6S112C24v164Ev();
extern void _ZN6S112C24v165Ev();
extern void _ZN6S112C24v166Ev();
extern void _ZN6S112C24v167Ev();
extern void _ZN6S112C24v168Ev();
extern void _ZN6S112C24v169Ev();
extern void _ZN6S112C24v170Ev();
extern void _ZN6S112C24v171Ev();
extern void _ZN6S112C24v172Ev();
extern void _ZN6S112C24v173Ev();
extern void _ZN6S112C24v174Ev();
extern void _ZN6S112C24v175Ev();
extern void _ZN6S112C24v176Ev();
extern void _ZN6S112C24v177Ev();
extern void _ZN6S112C24v178Ev();
extern void _ZN6S112C24v179Ev();
extern void _ZN6S112C24v180Ev();
extern void _ZN6S112C24v181Ev();
extern void _ZN6S112C24v182Ev();
extern void _ZN6S112C24v183Ev();
extern void _ZN6S112C24v184Ev();
extern void _ZN6S112C24v185Ev();
extern void _ZN6S112C24v186Ev();
extern void _ZN6S112C24v187Ev();
extern void _ZN6S112C24v188Ev();
extern void _ZN6S112C24v189Ev();
extern void _ZN6S112C24v190Ev();
extern void _ZN6S112C24v191Ev();
extern void _ZN6S112C24v192Ev();
extern void _ZN6S112C24v193Ev();
extern void _ZN6S112C24v194Ev();
extern void _ZN6S112C12v1Ev();
extern void _ZN6S112C12v2Ev();
extern void _ZN6S112C12v3Ev();
extern void _ZN6S112C12v4Ev();
extern void _ZN6S112C12v5Ev();
extern void _ZN6S112C12v6Ev();
static  VTBL_ENTRY vtc_S112C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S112C1[0]),
  (VTBL_ENTRY)&_ZN6S112C1D1Ev,
  (VTBL_ENTRY)&_ZN6S112C1D0Ev,
  (VTBL_ENTRY)&_ZN6S112C72v7Ev,
  (VTBL_ENTRY)&_ZN6S112C72v8Ev,
  (VTBL_ENTRY)&_ZN6S112C72v9Ev,
  (VTBL_ENTRY)&_ZN6S112C73v10Ev,
  (VTBL_ENTRY)&_ZN6S112C73v11Ev,
  (VTBL_ENTRY)&_ZN6S112C73v12Ev,
  (VTBL_ENTRY)&_ZN6S112C73v13Ev,
  (VTBL_ENTRY)&_ZN6S112C73v14Ev,
  (VTBL_ENTRY)&_ZN6S112C73v15Ev,
  (VTBL_ENTRY)&_ZN6S112C73v16Ev,
  (VTBL_ENTRY)&_ZN6S112C73v17Ev,
  (VTBL_ENTRY)&_ZN6S112C73v18Ev,
  (VTBL_ENTRY)&_ZN6S112C73v19Ev,
  (VTBL_ENTRY)&_ZN6S112C73v20Ev,
  (VTBL_ENTRY)&_ZN6S112C73v21Ev,
  (VTBL_ENTRY)&_ZN6S112C73v22Ev,
  (VTBL_ENTRY)&_ZN6S112C73v23Ev,
  (VTBL_ENTRY)&_ZN6S112C73v24Ev,
  (VTBL_ENTRY)&_ZN6S112C73v25Ev,
  (VTBL_ENTRY)&_ZN6S112C73v26Ev,
  (VTBL_ENTRY)&_ZN6S112C73v27Ev,
  (VTBL_ENTRY)&_ZN6S112C73v28Ev,
  (VTBL_ENTRY)&_ZN6S112C73v29Ev,
  (VTBL_ENTRY)&_ZN6S112C73v30Ev,
  (VTBL_ENTRY)&_ZN6S112C73v31Ev,
  (VTBL_ENTRY)&_ZN6S112C73v32Ev,
  (VTBL_ENTRY)&_ZN6S112C73v33Ev,
  (VTBL_ENTRY)&_ZN6S112C73v34Ev,
  (VTBL_ENTRY)&_ZN6S112C73v35Ev,
  (VTBL_ENTRY)&_ZN6S112C73v36Ev,
  (VTBL_ENTRY)&_ZN6S112C73v37Ev,
  (VTBL_ENTRY)&_ZN6S112C73v38Ev,
  (VTBL_ENTRY)&_ZN6S112C73v39Ev,
  (VTBL_ENTRY)&_ZN6S112C73v40Ev,
  (VTBL_ENTRY)&_ZN6S112C73v41Ev,
  (VTBL_ENTRY)&_ZN6S112C73v42Ev,
  (VTBL_ENTRY)&_ZN6S112C73v43Ev,
  (VTBL_ENTRY)&_ZN6S112C73v44Ev,
  (VTBL_ENTRY)&_ZN6S112C73v45Ev,
  (VTBL_ENTRY)&_ZN6S112C73v46Ev,
  (VTBL_ENTRY)&_ZN6S112C73v47Ev,
  (VTBL_ENTRY)&_ZN6S112C73v48Ev,
  (VTBL_ENTRY)&_ZN6S112C73v49Ev,
  (VTBL_ENTRY)&_ZN6S112C73v50Ev,
  (VTBL_ENTRY)&_ZN6S112C73v51Ev,
  (VTBL_ENTRY)&_ZN6S112C73v52Ev,
  (VTBL_ENTRY)&_ZN6S112C73v53Ev,
  (VTBL_ENTRY)&_ZN6S112C73v54Ev,
  (VTBL_ENTRY)&_ZN6S112C73v55Ev,
  (VTBL_ENTRY)&_ZN6S112C73v56Ev,
  (VTBL_ENTRY)&_ZN6S112C73v57Ev,
  (VTBL_ENTRY)&_ZN6S112C73v58Ev,
  (VTBL_ENTRY)&_ZN6S112C73v59Ev,
  (VTBL_ENTRY)&_ZN6S112C73v60Ev,
  (VTBL_ENTRY)&_ZN6S112C73v61Ev,
  (VTBL_ENTRY)&_ZN6S112C73v62Ev,
  (VTBL_ENTRY)&_ZN6S112C73v63Ev,
  (VTBL_ENTRY)&_ZN6S112C73v64Ev,
  (VTBL_ENTRY)&_ZN6S112C73v65Ev,
  (VTBL_ENTRY)&_ZN6S112C73v66Ev,
  (VTBL_ENTRY)&_ZN6S112C73v67Ev,
  (VTBL_ENTRY)&_ZN6S112C73v68Ev,
  (VTBL_ENTRY)&_ZN6S112C73v69Ev,
  (VTBL_ENTRY)&_ZN6S112C73v70Ev,
  (VTBL_ENTRY)&_ZN6S112C63v71Ev,
  (VTBL_ENTRY)&_ZN6S112C63v72Ev,
  (VTBL_ENTRY)&_ZN6S112C63v73Ev,
  (VTBL_ENTRY)&_ZN6S112C63v74Ev,
  (VTBL_ENTRY)&_ZN6S112C63v75Ev,
  (VTBL_ENTRY)&_ZN6S112C53v76Ev,
  (VTBL_ENTRY)&_ZN6S112C53v77Ev,
  (VTBL_ENTRY)&_ZN6S112C53v78Ev,
  (VTBL_ENTRY)&_ZN6S112C53v79Ev,
  (VTBL_ENTRY)&_ZN6S112C53v80Ev,
  (VTBL_ENTRY)&_ZN6S112C53v81Ev,
  (VTBL_ENTRY)&_ZN6S112C53v82Ev,
  (VTBL_ENTRY)&_ZN6S112C53v83Ev,
  (VTBL_ENTRY)&_ZN6S112C53v84Ev,
  (VTBL_ENTRY)&_ZN6S112C53v85Ev,
  (VTBL_ENTRY)&_ZN6S112C53v86Ev,
  (VTBL_ENTRY)&_ZN6S112C53v87Ev,
  (VTBL_ENTRY)&_ZN6S112C53v88Ev,
  (VTBL_ENTRY)&_ZN6S112C53v89Ev,
  (VTBL_ENTRY)&_ZN6S112C53v90Ev,
  (VTBL_ENTRY)&_ZN6S112C53v91Ev,
  (VTBL_ENTRY)&_ZN6S112C53v92Ev,
  (VTBL_ENTRY)&_ZN6S112C53v93Ev,
  (VTBL_ENTRY)&_ZN6S112C53v94Ev,
  (VTBL_ENTRY)&_ZN6S112C53v95Ev,
  (VTBL_ENTRY)&_ZN6S112C53v96Ev,
  (VTBL_ENTRY)&_ZN6S112C53v97Ev,
  (VTBL_ENTRY)&_ZN6S112C43v98Ev,
  (VTBL_ENTRY)&_ZN6S112C43v99Ev,
  (VTBL_ENTRY)&_ZN6S112C44v100Ev,
  (VTBL_ENTRY)&_ZN6S112C44v101Ev,
  (VTBL_ENTRY)&_ZN6S112C44v102Ev,
  (VTBL_ENTRY)&_ZN6S112C44v103Ev,
  (VTBL_ENTRY)&_ZN6S112C44v104Ev,
  (VTBL_ENTRY)&_ZN6S112C44v105Ev,
  (VTBL_ENTRY)&_ZN6S112C44v106Ev,
  (VTBL_ENTRY)&_ZN6S112C44v107Ev,
  (VTBL_ENTRY)&_ZN6S112C44v108Ev,
  (VTBL_ENTRY)&_ZN6S112C44v109Ev,
  (VTBL_ENTRY)&_ZN6S112C44v110Ev,
  (VTBL_ENTRY)&_ZN6S112C44v111Ev,
  (VTBL_ENTRY)&_ZN6S112C44v112Ev,
  (VTBL_ENTRY)&_ZN6S112C44v113Ev,
  (VTBL_ENTRY)&_ZN6S112C44v114Ev,
  (VTBL_ENTRY)&_ZN6S112C44v115Ev,
  (VTBL_ENTRY)&_ZN6S112C44v116Ev,
  (VTBL_ENTRY)&_ZN6S112C44v117Ev,
  (VTBL_ENTRY)&_ZN6S112C44v118Ev,
  (VTBL_ENTRY)&_ZN6S112C44v119Ev,
  (VTBL_ENTRY)&_ZN6S112C44v120Ev,
  (VTBL_ENTRY)&_ZN6S112C44v121Ev,
  (VTBL_ENTRY)&_ZN6S112C44v122Ev,
  (VTBL_ENTRY)&_ZN6S112C44v123Ev,
  (VTBL_ENTRY)&_ZN6S112C44v124Ev,
  (VTBL_ENTRY)&_ZN6S112C44v125Ev,
  (VTBL_ENTRY)&_ZN6S112C44v126Ev,
  (VTBL_ENTRY)&_ZN6S112C44v127Ev,
  (VTBL_ENTRY)&_ZN6S112C44v128Ev,
  (VTBL_ENTRY)&_ZN6S112C44v129Ev,
  (VTBL_ENTRY)&_ZN6S112C44v130Ev,
  (VTBL_ENTRY)&_ZN6S112C44v131Ev,
  (VTBL_ENTRY)&_ZN6S112C44v132Ev,
  (VTBL_ENTRY)&_ZN6S112C44v133Ev,
  (VTBL_ENTRY)&_ZN6S112C44v134Ev,
  (VTBL_ENTRY)&_ZN6S112C44v135Ev,
  (VTBL_ENTRY)&_ZN6S112C44v136Ev,
  (VTBL_ENTRY)&_ZN6S112C44v137Ev,
  (VTBL_ENTRY)&_ZN6S112C44v138Ev,
  (VTBL_ENTRY)&_ZN6S112C44v139Ev,
  (VTBL_ENTRY)&_ZN6S112C44v140Ev,
  (VTBL_ENTRY)&_ZN6S112C44v141Ev,
  (VTBL_ENTRY)&_ZN6S112C44v142Ev,
  (VTBL_ENTRY)&_ZN6S112C44v143Ev,
  (VTBL_ENTRY)&_ZN6S112C44v144Ev,
  (VTBL_ENTRY)&_ZN6S112C44v145Ev,
  (VTBL_ENTRY)&_ZN6S112C44v146Ev,
  (VTBL_ENTRY)&_ZN6S112C44v147Ev,
  (VTBL_ENTRY)&_ZN6S112C44v148Ev,
  (VTBL_ENTRY)&_ZN6S112C44v149Ev,
  (VTBL_ENTRY)&_ZN6S112C44v150Ev,
  (VTBL_ENTRY)&_ZN6S112C44v151Ev,
  (VTBL_ENTRY)&_ZN6S112C44v152Ev,
  (VTBL_ENTRY)&_ZN6S112C44v153Ev,
  (VTBL_ENTRY)&_ZN6S112C44v154Ev,
  (VTBL_ENTRY)&_ZN6S112C44v155Ev,
  (VTBL_ENTRY)&_ZN6S112C44v156Ev,
  (VTBL_ENTRY)&_ZN6S112C44v157Ev,
  (VTBL_ENTRY)&_ZN6S112C44v158Ev,
  (VTBL_ENTRY)&_ZN6S112C34v159Ev,
  (VTBL_ENTRY)&_ZN6S112C34v160Ev,
  (VTBL_ENTRY)&_ZN6S112C34v161Ev,
  (VTBL_ENTRY)&_ZN6S112C34v162Ev,
  (VTBL_ENTRY)&_ZN6S112C24v163Ev,
  (VTBL_ENTRY)&_ZN6S112C24v164Ev,
  (VTBL_ENTRY)&_ZN6S112C24v165Ev,
  (VTBL_ENTRY)&_ZN6S112C24v166Ev,
  (VTBL_ENTRY)&_ZN6S112C24v167Ev,
  (VTBL_ENTRY)&_ZN6S112C24v168Ev,
  (VTBL_ENTRY)&_ZN6S112C24v169Ev,
  (VTBL_ENTRY)&_ZN6S112C24v170Ev,
  (VTBL_ENTRY)&_ZN6S112C24v171Ev,
  (VTBL_ENTRY)&_ZN6S112C24v172Ev,
  (VTBL_ENTRY)&_ZN6S112C24v173Ev,
  (VTBL_ENTRY)&_ZN6S112C24v174Ev,
  (VTBL_ENTRY)&_ZN6S112C24v175Ev,
  (VTBL_ENTRY)&_ZN6S112C24v176Ev,
  (VTBL_ENTRY)&_ZN6S112C24v177Ev,
  (VTBL_ENTRY)&_ZN6S112C24v178Ev,
  (VTBL_ENTRY)&_ZN6S112C24v179Ev,
  (VTBL_ENTRY)&_ZN6S112C24v180Ev,
  (VTBL_ENTRY)&_ZN6S112C24v181Ev,
  (VTBL_ENTRY)&_ZN6S112C24v182Ev,
  (VTBL_ENTRY)&_ZN6S112C24v183Ev,
  (VTBL_ENTRY)&_ZN6S112C24v184Ev,
  (VTBL_ENTRY)&_ZN6S112C24v185Ev,
  (VTBL_ENTRY)&_ZN6S112C24v186Ev,
  (VTBL_ENTRY)&_ZN6S112C24v187Ev,
  (VTBL_ENTRY)&_ZN6S112C24v188Ev,
  (VTBL_ENTRY)&_ZN6S112C24v189Ev,
  (VTBL_ENTRY)&_ZN6S112C24v190Ev,
  (VTBL_ENTRY)&_ZN6S112C24v191Ev,
  (VTBL_ENTRY)&_ZN6S112C24v192Ev,
  (VTBL_ENTRY)&_ZN6S112C24v193Ev,
  (VTBL_ENTRY)&_ZN6S112C24v194Ev,
  (VTBL_ENTRY)&_ZN6S112C12v1Ev,
  (VTBL_ENTRY)&_ZN6S112C12v2Ev,
  (VTBL_ENTRY)&_ZN6S112C12v3Ev,
  (VTBL_ENTRY)&_ZN6S112C12v4Ev,
  (VTBL_ENTRY)&_ZN6S112C12v5Ev,
  (VTBL_ENTRY)&_ZN6S112C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S112C1[];
extern  VTBL_ENTRY _ZTV6S112C1[];
Class_Descriptor cd_S112C1 = {  "S112C1", // class name
  bases_S112C1, 6,
  &(vtc_S112C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(512,380), // object size
  NSPAIRA(_ZTI6S112C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S112C1),198, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C5  {
  int s490c5f0;
  __tsi64 s490c5f1;
  void *s490c5f2[4];
  int s490c5f3[2];
  void *s490c5f4;
  ::S95C8_nt s490c5f5;
  void *s490c5f6[2];
  virtual  ~S490C5(); // _ZN6S490C5D1Ev
  virtual void  v16(); // _ZN6S490C53v16Ev
  virtual void  v17(); // _ZN6S490C53v17Ev
  virtual void  v18(); // _ZN6S490C53v18Ev
  virtual void  v19(); // _ZN6S490C53v19Ev
  virtual void  v20(); // _ZN6S490C53v20Ev
  virtual void  v21(); // _ZN6S490C53v21Ev
  virtual void  v22(); // _ZN6S490C53v22Ev
  virtual void  v23(); // _ZN6S490C53v23Ev
  virtual void  v24(); // _ZN6S490C53v24Ev
  virtual void  v25(); // _ZN6S490C53v25Ev
  virtual void  v26(); // _ZN6S490C53v26Ev
  virtual void  v27(); // _ZN6S490C53v27Ev
  virtual void  v28(); // _ZN6S490C53v28Ev
  virtual void  v29(); // _ZN6S490C53v29Ev
  virtual void  v30(); // _ZN6S490C53v30Ev
  virtual void  v31(); // _ZN6S490C53v31Ev
  virtual void  v32(); // _ZN6S490C53v32Ev
  virtual void  v33(); // _ZN6S490C53v33Ev
  virtual void  v34(); // _ZN6S490C53v34Ev
  virtual void  v35(); // _ZN6S490C53v35Ev
  virtual void  v36(); // _ZN6S490C53v36Ev
  virtual void  v37(); // _ZN6S490C53v37Ev
  virtual void  v38(); // _ZN6S490C53v38Ev
  virtual void  v39(); // _ZN6S490C53v39Ev
  virtual void  v40(); // _ZN6S490C53v40Ev
  virtual void  v41(); // _ZN6S490C53v41Ev
  virtual void  v42(); // _ZN6S490C53v42Ev
  virtual void  v43(); // _ZN6S490C53v43Ev
  virtual void  v44(); // _ZN6S490C53v44Ev
  virtual void  v45(); // _ZN6S490C53v45Ev
  virtual void  v46(); // _ZN6S490C53v46Ev
  virtual void  v47(); // _ZN6S490C53v47Ev
  virtual void  v48(); // _ZN6S490C53v48Ev
  virtual void  v49(); // _ZN6S490C53v49Ev
  virtual void  v50(); // _ZN6S490C53v50Ev
  virtual void  v51(); // _ZN6S490C53v51Ev
  virtual void  v52(); // _ZN6S490C53v52Ev
  virtual void  v53(); // _ZN6S490C53v53Ev
  virtual void  v54(); // _ZN6S490C53v54Ev
  virtual void  v55(); // _ZN6S490C53v55Ev
  virtual void  v56(); // _ZN6S490C53v56Ev
  virtual void  v57(); // _ZN6S490C53v57Ev
  virtual void  v58(); // _ZN6S490C53v58Ev
  virtual void  v59(); // _ZN6S490C53v59Ev
  virtual void  v60(); // _ZN6S490C53v60Ev
  virtual void  v61(); // _ZN6S490C53v61Ev
  virtual void  v62(); // _ZN6S490C53v62Ev
  virtual void  v63(); // _ZN6S490C53v63Ev
  virtual void  v64(); // _ZN6S490C53v64Ev
  virtual void  v65(); // _ZN6S490C53v65Ev
  virtual void  v66(); // _ZN6S490C53v66Ev
  virtual void  v67(); // _ZN6S490C53v67Ev
  virtual void  v68(); // _ZN6S490C53v68Ev
  virtual void  v69(); // _ZN6S490C53v69Ev
  virtual void  v70(); // _ZN6S490C53v70Ev
  virtual void  v71(); // _ZN6S490C53v71Ev
  virtual void  v72(); // _ZN6S490C53v72Ev
  virtual void  v73(); // _ZN6S490C53v73Ev
  virtual void  v74(); // _ZN6S490C53v74Ev
  virtual void  v75(); // _ZN6S490C53v75Ev
  virtual void  v76(); // _ZN6S490C53v76Ev
  virtual void  v77(); // _ZN6S490C53v77Ev
  virtual void  v78(); // _ZN6S490C53v78Ev
  virtual void  v79(); // _ZN6S490C53v79Ev
  S490C5(); // tgen
};
//SIG(-1 S490C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S490C5 ::~S490C5(){ note_dtor("S490C5", this);}
void  S490C5 ::v16(){vfunc_called(this, "_ZN6S490C53v16Ev");}
void  S490C5 ::v17(){vfunc_called(this, "_ZN6S490C53v17Ev");}
void  S490C5 ::v18(){vfunc_called(this, "_ZN6S490C53v18Ev");}
void  S490C5 ::v19(){vfunc_called(this, "_ZN6S490C53v19Ev");}
void  S490C5 ::v20(){vfunc_called(this, "_ZN6S490C53v20Ev");}
void  S490C5 ::v21(){vfunc_called(this, "_ZN6S490C53v21Ev");}
void  S490C5 ::v22(){vfunc_called(this, "_ZN6S490C53v22Ev");}
void  S490C5 ::v23(){vfunc_called(this, "_ZN6S490C53v23Ev");}
void  S490C5 ::v24(){vfunc_called(this, "_ZN6S490C53v24Ev");}
void  S490C5 ::v25(){vfunc_called(this, "_ZN6S490C53v25Ev");}
void  S490C5 ::v26(){vfunc_called(this, "_ZN6S490C53v26Ev");}
void  S490C5 ::v27(){vfunc_called(this, "_ZN6S490C53v27Ev");}
void  S490C5 ::v28(){vfunc_called(this, "_ZN6S490C53v28Ev");}
void  S490C5 ::v29(){vfunc_called(this, "_ZN6S490C53v29Ev");}
void  S490C5 ::v30(){vfunc_called(this, "_ZN6S490C53v30Ev");}
void  S490C5 ::v31(){vfunc_called(this, "_ZN6S490C53v31Ev");}
void  S490C5 ::v32(){vfunc_called(this, "_ZN6S490C53v32Ev");}
void  S490C5 ::v33(){vfunc_called(this, "_ZN6S490C53v33Ev");}
void  S490C5 ::v34(){vfunc_called(this, "_ZN6S490C53v34Ev");}
void  S490C5 ::v35(){vfunc_called(this, "_ZN6S490C53v35Ev");}
void  S490C5 ::v36(){vfunc_called(this, "_ZN6S490C53v36Ev");}
void  S490C5 ::v37(){vfunc_called(this, "_ZN6S490C53v37Ev");}
void  S490C5 ::v38(){vfunc_called(this, "_ZN6S490C53v38Ev");}
void  S490C5 ::v39(){vfunc_called(this, "_ZN6S490C53v39Ev");}
void  S490C5 ::v40(){vfunc_called(this, "_ZN6S490C53v40Ev");}
void  S490C5 ::v41(){vfunc_called(this, "_ZN6S490C53v41Ev");}
void  S490C5 ::v42(){vfunc_called(this, "_ZN6S490C53v42Ev");}
void  S490C5 ::v43(){vfunc_called(this, "_ZN6S490C53v43Ev");}
void  S490C5 ::v44(){vfunc_called(this, "_ZN6S490C53v44Ev");}
void  S490C5 ::v45(){vfunc_called(this, "_ZN6S490C53v45Ev");}
void  S490C5 ::v46(){vfunc_called(this, "_ZN6S490C53v46Ev");}
void  S490C5 ::v47(){vfunc_called(this, "_ZN6S490C53v47Ev");}
void  S490C5 ::v48(){vfunc_called(this, "_ZN6S490C53v48Ev");}
void  S490C5 ::v49(){vfunc_called(this, "_ZN6S490C53v49Ev");}
void  S490C5 ::v50(){vfunc_called(this, "_ZN6S490C53v50Ev");}
void  S490C5 ::v51(){vfunc_called(this, "_ZN6S490C53v51Ev");}
void  S490C5 ::v52(){vfunc_called(this, "_ZN6S490C53v52Ev");}
void  S490C5 ::v53(){vfunc_called(this, "_ZN6S490C53v53Ev");}
void  S490C5 ::v54(){vfunc_called(this, "_ZN6S490C53v54Ev");}
void  S490C5 ::v55(){vfunc_called(this, "_ZN6S490C53v55Ev");}
void  S490C5 ::v56(){vfunc_called(this, "_ZN6S490C53v56Ev");}
void  S490C5 ::v57(){vfunc_called(this, "_ZN6S490C53v57Ev");}
void  S490C5 ::v58(){vfunc_called(this, "_ZN6S490C53v58Ev");}
void  S490C5 ::v59(){vfunc_called(this, "_ZN6S490C53v59Ev");}
void  S490C5 ::v60(){vfunc_called(this, "_ZN6S490C53v60Ev");}
void  S490C5 ::v61(){vfunc_called(this, "_ZN6S490C53v61Ev");}
void  S490C5 ::v62(){vfunc_called(this, "_ZN6S490C53v62Ev");}
void  S490C5 ::v63(){vfunc_called(this, "_ZN6S490C53v63Ev");}
void  S490C5 ::v64(){vfunc_called(this, "_ZN6S490C53v64Ev");}
void  S490C5 ::v65(){vfunc_called(this, "_ZN6S490C53v65Ev");}
void  S490C5 ::v66(){vfunc_called(this, "_ZN6S490C53v66Ev");}
void  S490C5 ::v67(){vfunc_called(this, "_ZN6S490C53v67Ev");}
void  S490C5 ::v68(){vfunc_called(this, "_ZN6S490C53v68Ev");}
void  S490C5 ::v69(){vfunc_called(this, "_ZN6S490C53v69Ev");}
void  S490C5 ::v70(){vfunc_called(this, "_ZN6S490C53v70Ev");}
void  S490C5 ::v71(){vfunc_called(this, "_ZN6S490C53v71Ev");}
void  S490C5 ::v72(){vfunc_called(this, "_ZN6S490C53v72Ev");}
void  S490C5 ::v73(){vfunc_called(this, "_ZN6S490C53v73Ev");}
void  S490C5 ::v74(){vfunc_called(this, "_ZN6S490C53v74Ev");}
void  S490C5 ::v75(){vfunc_called(this, "_ZN6S490C53v75Ev");}
void  S490C5 ::v76(){vfunc_called(this, "_ZN6S490C53v76Ev");}
void  S490C5 ::v77(){vfunc_called(this, "_ZN6S490C53v77Ev");}
void  S490C5 ::v78(){vfunc_called(this, "_ZN6S490C53v78Ev");}
void  S490C5 ::v79(){vfunc_called(this, "_ZN6S490C53v79Ev");}
S490C5 ::S490C5(){ note_ctor("S490C5", this);} // tgen

static void Test_S490C5()
{
  extern Class_Descriptor cd_S490C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S490C5, buf);
    S490C5 *dp, &lv = *(dp=new (buf) S490C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S490C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C5)");
    check_field_offset(lv, s490c5f0, ABISELECT(8,4), "S490C5.s490c5f0");
    check_field_offset(lv, s490c5f1, ABISELECT(16,8), "S490C5.s490c5f1");
    check_field_offset(lv, s490c5f2, ABISELECT(24,16), "S490C5.s490c5f2");
    check_field_offset(lv, s490c5f3, ABISELECT(56,32), "S490C5.s490c5f3");
    check_field_offset(lv, s490c5f4, ABISELECT(64,40), "S490C5.s490c5f4");
    check_field_offset(lv, s490c5f5, ABISELECT(72,44), "S490C5.s490c5f5");
    check_field_offset(lv, s490c5f6, ABISELECT(80,52), "S490C5.s490c5f6");
    test_class_info(&lv, &cd_S490C5);
    dp->~S490C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C5(Test_S490C5, "S490C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S490C5C1Ev();
extern void _ZN6S490C5D1Ev();
Name_Map name_map_S490C5[] = {
  NSPAIR(_ZN6S490C5C1Ev),
  NSPAIR(_ZN6S490C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S490C5[];
extern void _ZN6S490C5D1Ev();
extern void _ZN6S490C5D0Ev();
extern void _ZN6S490C53v16Ev();
extern void _ZN6S490C53v17Ev();
extern void _ZN6S490C53v18Ev();
extern void _ZN6S490C53v19Ev();
extern void _ZN6S490C53v20Ev();
extern void _ZN6S490C53v21Ev();
extern void _ZN6S490C53v22Ev();
extern void _ZN6S490C53v23Ev();
extern void _ZN6S490C53v24Ev();
extern void _ZN6S490C53v25Ev();
extern void _ZN6S490C53v26Ev();
extern void _ZN6S490C53v27Ev();
extern void _ZN6S490C53v28Ev();
extern void _ZN6S490C53v29Ev();
extern void _ZN6S490C53v30Ev();
extern void _ZN6S490C53v31Ev();
extern void _ZN6S490C53v32Ev();
extern void _ZN6S490C53v33Ev();
extern void _ZN6S490C53v34Ev();
extern void _ZN6S490C53v35Ev();
extern void _ZN6S490C53v36Ev();
extern void _ZN6S490C53v37Ev();
extern void _ZN6S490C53v38Ev();
extern void _ZN6S490C53v39Ev();
extern void _ZN6S490C53v40Ev();
extern void _ZN6S490C53v41Ev();
extern void _ZN6S490C53v42Ev();
extern void _ZN6S490C53v43Ev();
extern void _ZN6S490C53v44Ev();
extern void _ZN6S490C53v45Ev();
extern void _ZN6S490C53v46Ev();
extern void _ZN6S490C53v47Ev();
extern void _ZN6S490C53v48Ev();
extern void _ZN6S490C53v49Ev();
extern void _ZN6S490C53v50Ev();
extern void _ZN6S490C53v51Ev();
extern void _ZN6S490C53v52Ev();
extern void _ZN6S490C53v53Ev();
extern void _ZN6S490C53v54Ev();
extern void _ZN6S490C53v55Ev();
extern void _ZN6S490C53v56Ev();
extern void _ZN6S490C53v57Ev();
extern void _ZN6S490C53v58Ev();
extern void _ZN6S490C53v59Ev();
extern void _ZN6S490C53v60Ev();
extern void _ZN6S490C53v61Ev();
extern void _ZN6S490C53v62Ev();
extern void _ZN6S490C53v63Ev();
extern void _ZN6S490C53v64Ev();
extern void _ZN6S490C53v65Ev();
extern void _ZN6S490C53v66Ev();
extern void _ZN6S490C53v67Ev();
extern void _ZN6S490C53v68Ev();
extern void _ZN6S490C53v69Ev();
extern void _ZN6S490C53v70Ev();
extern void _ZN6S490C53v71Ev();
extern void _ZN6S490C53v72Ev();
extern void _ZN6S490C53v73Ev();
extern void _ZN6S490C53v74Ev();
extern void _ZN6S490C53v75Ev();
extern void _ZN6S490C53v76Ev();
extern void _ZN6S490C53v77Ev();
extern void _ZN6S490C53v78Ev();
extern void _ZN6S490C53v79Ev();
static  VTBL_ENTRY vtc_S490C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S490C5[0]),
  (VTBL_ENTRY)&_ZN6S490C5D1Ev,
  (VTBL_ENTRY)&_ZN6S490C5D0Ev,
  (VTBL_ENTRY)&_ZN6S490C53v16Ev,
  (VTBL_ENTRY)&_ZN6S490C53v17Ev,
  (VTBL_ENTRY)&_ZN6S490C53v18Ev,
  (VTBL_ENTRY)&_ZN6S490C53v19Ev,
  (VTBL_ENTRY)&_ZN6S490C53v20Ev,
  (VTBL_ENTRY)&_ZN6S490C53v21Ev,
  (VTBL_ENTRY)&_ZN6S490C53v22Ev,
  (VTBL_ENTRY)&_ZN6S490C53v23Ev,
  (VTBL_ENTRY)&_ZN6S490C53v24Ev,
  (VTBL_ENTRY)&_ZN6S490C53v25Ev,
  (VTBL_ENTRY)&_ZN6S490C53v26Ev,
  (VTBL_ENTRY)&_ZN6S490C53v27Ev,
  (VTBL_ENTRY)&_ZN6S490C53v28Ev,
  (VTBL_ENTRY)&_ZN6S490C53v29Ev,
  (VTBL_ENTRY)&_ZN6S490C53v30Ev,
  (VTBL_ENTRY)&_ZN6S490C53v31Ev,
  (VTBL_ENTRY)&_ZN6S490C53v32Ev,
  (VTBL_ENTRY)&_ZN6S490C53v33Ev,
  (VTBL_ENTRY)&_ZN6S490C53v34Ev,
  (VTBL_ENTRY)&_ZN6S490C53v35Ev,
  (VTBL_ENTRY)&_ZN6S490C53v36Ev,
  (VTBL_ENTRY)&_ZN6S490C53v37Ev,
  (VTBL_ENTRY)&_ZN6S490C53v38Ev,
  (VTBL_ENTRY)&_ZN6S490C53v39Ev,
  (VTBL_ENTRY)&_ZN6S490C53v40Ev,
  (VTBL_ENTRY)&_ZN6S490C53v41Ev,
  (VTBL_ENTRY)&_ZN6S490C53v42Ev,
  (VTBL_ENTRY)&_ZN6S490C53v43Ev,
  (VTBL_ENTRY)&_ZN6S490C53v44Ev,
  (VTBL_ENTRY)&_ZN6S490C53v45Ev,
  (VTBL_ENTRY)&_ZN6S490C53v46Ev,
  (VTBL_ENTRY)&_ZN6S490C53v47Ev,
  (VTBL_ENTRY)&_ZN6S490C53v48Ev,
  (VTBL_ENTRY)&_ZN6S490C53v49Ev,
  (VTBL_ENTRY)&_ZN6S490C53v50Ev,
  (VTBL_ENTRY)&_ZN6S490C53v51Ev,
  (VTBL_ENTRY)&_ZN6S490C53v52Ev,
  (VTBL_ENTRY)&_ZN6S490C53v53Ev,
  (VTBL_ENTRY)&_ZN6S490C53v54Ev,
  (VTBL_ENTRY)&_ZN6S490C53v55Ev,
  (VTBL_ENTRY)&_ZN6S490C53v56Ev,
  (VTBL_ENTRY)&_ZN6S490C53v57Ev,
  (VTBL_ENTRY)&_ZN6S490C53v58Ev,
  (VTBL_ENTRY)&_ZN6S490C53v59Ev,
  (VTBL_ENTRY)&_ZN6S490C53v60Ev,
  (VTBL_ENTRY)&_ZN6S490C53v61Ev,
  (VTBL_ENTRY)&_ZN6S490C53v62Ev,
  (VTBL_ENTRY)&_ZN6S490C53v63Ev,
  (VTBL_ENTRY)&_ZN6S490C53v64Ev,
  (VTBL_ENTRY)&_ZN6S490C53v65Ev,
  (VTBL_ENTRY)&_ZN6S490C53v66Ev,
  (VTBL_ENTRY)&_ZN6S490C53v67Ev,
  (VTBL_ENTRY)&_ZN6S490C53v68Ev,
  (VTBL_ENTRY)&_ZN6S490C53v69Ev,
  (VTBL_ENTRY)&_ZN6S490C53v70Ev,
  (VTBL_ENTRY)&_ZN6S490C53v71Ev,
  (VTBL_ENTRY)&_ZN6S490C53v72Ev,
  (VTBL_ENTRY)&_ZN6S490C53v73Ev,
  (VTBL_ENTRY)&_ZN6S490C53v74Ev,
  (VTBL_ENTRY)&_ZN6S490C53v75Ev,
  (VTBL_ENTRY)&_ZN6S490C53v76Ev,
  (VTBL_ENTRY)&_ZN6S490C53v77Ev,
  (VTBL_ENTRY)&_ZN6S490C53v78Ev,
  (VTBL_ENTRY)&_ZN6S490C53v79Ev,
};
extern VTBL_ENTRY _ZTI6S490C5[];
extern  VTBL_ENTRY _ZTV6S490C5[];
Class_Descriptor cd_S490C5 = {  "S490C5", // class name
  0,0,//no base classes
  &(vtc_S490C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S490C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S490C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C4  : S490C5 {
  void *s490c4f0;
  ::S95C8_nt s490c4f1;
  virtual  ~S490C4(); // _ZN6S490C4D1Ev
  virtual void  v80(); // _ZN6S490C43v80Ev
  virtual void  v81(); // _ZN6S490C43v81Ev
  virtual void  v82(); // _ZN6S490C43v82Ev
  virtual void  v83(); // _ZN6S490C43v83Ev
  virtual void  v84(); // _ZN6S490C43v84Ev
  S490C4(); // tgen
};
//SIG(-1 S490C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S490C4 ::~S490C4(){ note_dtor("S490C4", this);}
void  S490C4 ::v80(){vfunc_called(this, "_ZN6S490C43v80Ev");}
void  S490C4 ::v81(){vfunc_called(this, "_ZN6S490C43v81Ev");}
void  S490C4 ::v82(){vfunc_called(this, "_ZN6S490C43v82Ev");}
void  S490C4 ::v83(){vfunc_called(this, "_ZN6S490C43v83Ev");}
void  S490C4 ::v84(){vfunc_called(this, "_ZN6S490C43v84Ev");}
S490C4 ::S490C4(){ note_ctor("S490C4", this);} // tgen

static void Test_S490C4()
{
  extern Class_Descriptor cd_S490C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S490C4, buf);
    S490C4 *dp, &lv = *(dp=new (buf) S490C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S490C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C4)");
    check_base_class_offset(lv, (S490C5*), 0, "S490C4");
    check_field_offset(lv, s490c4f0, ABISELECT(96,60), "S490C4.s490c4f0");
    check_field_offset(lv, s490c4f1, ABISELECT(104,64), "S490C4.s490c4f1");
    test_class_info(&lv, &cd_S490C4);
    dp->~S490C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C4(Test_S490C4, "S490C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S490C4C1Ev();
extern void _ZN6S490C4D1Ev();
Name_Map name_map_S490C4[] = {
  NSPAIR(_ZN6S490C4C1Ev),
  NSPAIR(_ZN6S490C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S490C5;
extern VTBL_ENTRY _ZTI6S490C5[];
extern  VTBL_ENTRY _ZTV6S490C5[];
static Base_Class bases_S490C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S490C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S490C4[];
extern void _ZN6S490C4D1Ev();
extern void _ZN6S490C4D0Ev();
extern void _ZN6S490C53v16Ev();
extern void _ZN6S490C53v17Ev();
extern void _ZN6S490C53v18Ev();
extern void _ZN6S490C53v19Ev();
extern void _ZN6S490C53v20Ev();
extern void _ZN6S490C53v21Ev();
extern void _ZN6S490C53v22Ev();
extern void _ZN6S490C53v23Ev();
extern void _ZN6S490C53v24Ev();
extern void _ZN6S490C53v25Ev();
extern void _ZN6S490C53v26Ev();
extern void _ZN6S490C53v27Ev();
extern void _ZN6S490C53v28Ev();
extern void _ZN6S490C53v29Ev();
extern void _ZN6S490C53v30Ev();
extern void _ZN6S490C53v31Ev();
extern void _ZN6S490C53v32Ev();
extern void _ZN6S490C53v33Ev();
extern void _ZN6S490C53v34Ev();
extern void _ZN6S490C53v35Ev();
extern void _ZN6S490C53v36Ev();
extern void _ZN6S490C53v37Ev();
extern void _ZN6S490C53v38Ev();
extern void _ZN6S490C53v39Ev();
extern void _ZN6S490C53v40Ev();
extern void _ZN6S490C53v41Ev();
extern void _ZN6S490C53v42Ev();
extern void _ZN6S490C53v43Ev();
extern void _ZN6S490C53v44Ev();
extern void _ZN6S490C53v45Ev();
extern void _ZN6S490C53v46Ev();
extern void _ZN6S490C53v47Ev();
extern void _ZN6S490C53v48Ev();
extern void _ZN6S490C53v49Ev();
extern void _ZN6S490C53v50Ev();
extern void _ZN6S490C53v51Ev();
extern void _ZN6S490C53v52Ev();
extern void _ZN6S490C53v53Ev();
extern void _ZN6S490C53v54Ev();
extern void _ZN6S490C53v55Ev();
extern void _ZN6S490C53v56Ev();
extern void _ZN6S490C53v57Ev();
extern void _ZN6S490C53v58Ev();
extern void _ZN6S490C53v59Ev();
extern void _ZN6S490C53v60Ev();
extern void _ZN6S490C53v61Ev();
extern void _ZN6S490C53v62Ev();
extern void _ZN6S490C53v63Ev();
extern void _ZN6S490C53v64Ev();
extern void _ZN6S490C53v65Ev();
extern void _ZN6S490C53v66Ev();
extern void _ZN6S490C53v67Ev();
extern void _ZN6S490C53v68Ev();
extern void _ZN6S490C53v69Ev();
extern void _ZN6S490C53v70Ev();
extern void _ZN6S490C53v71Ev();
extern void _ZN6S490C53v72Ev();
extern void _ZN6S490C53v73Ev();
extern void _ZN6S490C53v74Ev();
extern void _ZN6S490C53v75Ev();
extern void _ZN6S490C53v76Ev();
extern void _ZN6S490C53v77Ev();
extern void _ZN6S490C53v78Ev();
extern void _ZN6S490C53v79Ev();
extern void _ZN6S490C43v80Ev();
extern void _ZN6S490C43v81Ev();
extern void _ZN6S490C43v82Ev();
extern void _ZN6S490C43v83Ev();
extern void _ZN6S490C43v84Ev();
static  VTBL_ENTRY vtc_S490C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S490C4[0]),
  (VTBL_ENTRY)&_ZN6S490C4D1Ev,
  (VTBL_ENTRY)&_ZN6S490C4D0Ev,
  (VTBL_ENTRY)&_ZN6S490C53v16Ev,
  (VTBL_ENTRY)&_ZN6S490C53v17Ev,
  (VTBL_ENTRY)&_ZN6S490C53v18Ev,
  (VTBL_ENTRY)&_ZN6S490C53v19Ev,
  (VTBL_ENTRY)&_ZN6S490C53v20Ev,
  (VTBL_ENTRY)&_ZN6S490C53v21Ev,
  (VTBL_ENTRY)&_ZN6S490C53v22Ev,
  (VTBL_ENTRY)&_ZN6S490C53v23Ev,
  (VTBL_ENTRY)&_ZN6S490C53v24Ev,
  (VTBL_ENTRY)&_ZN6S490C53v25Ev,
  (VTBL_ENTRY)&_ZN6S490C53v26Ev,
  (VTBL_ENTRY)&_ZN6S490C53v27Ev,
  (VTBL_ENTRY)&_ZN6S490C53v28Ev,
  (VTBL_ENTRY)&_ZN6S490C53v29Ev,
  (VTBL_ENTRY)&_ZN6S490C53v30Ev,
  (VTBL_ENTRY)&_ZN6S490C53v31Ev,
  (VTBL_ENTRY)&_ZN6S490C53v32Ev,
  (VTBL_ENTRY)&_ZN6S490C53v33Ev,
  (VTBL_ENTRY)&_ZN6S490C53v34Ev,
  (VTBL_ENTRY)&_ZN6S490C53v35Ev,
  (VTBL_ENTRY)&_ZN6S490C53v36Ev,
  (VTBL_ENTRY)&_ZN6S490C53v37Ev,
  (VTBL_ENTRY)&_ZN6S490C53v38Ev,
  (VTBL_ENTRY)&_ZN6S490C53v39Ev,
  (VTBL_ENTRY)&_ZN6S490C53v40Ev,
  (VTBL_ENTRY)&_ZN6S490C53v41Ev,
  (VTBL_ENTRY)&_ZN6S490C53v42Ev,
  (VTBL_ENTRY)&_ZN6S490C53v43Ev,
  (VTBL_ENTRY)&_ZN6S490C53v44Ev,
  (VTBL_ENTRY)&_ZN6S490C53v45Ev,
  (VTBL_ENTRY)&_ZN6S490C53v46Ev,
  (VTBL_ENTRY)&_ZN6S490C53v47Ev,
  (VTBL_ENTRY)&_ZN6S490C53v48Ev,
  (VTBL_ENTRY)&_ZN6S490C53v49Ev,
  (VTBL_ENTRY)&_ZN6S490C53v50Ev,
  (VTBL_ENTRY)&_ZN6S490C53v51Ev,
  (VTBL_ENTRY)&_ZN6S490C53v52Ev,
  (VTBL_ENTRY)&_ZN6S490C53v53Ev,
  (VTBL_ENTRY)&_ZN6S490C53v54Ev,
  (VTBL_ENTRY)&_ZN6S490C53v55Ev,
  (VTBL_ENTRY)&_ZN6S490C53v56Ev,
  (VTBL_ENTRY)&_ZN6S490C53v57Ev,
  (VTBL_ENTRY)&_ZN6S490C53v58Ev,
  (VTBL_ENTRY)&_ZN6S490C53v59Ev,
  (VTBL_ENTRY)&_ZN6S490C53v60Ev,
  (VTBL_ENTRY)&_ZN6S490C53v61Ev,
  (VTBL_ENTRY)&_ZN6S490C53v62Ev,
  (VTBL_ENTRY)&_ZN6S490C53v63Ev,
  (VTBL_ENTRY)&_ZN6S490C53v64Ev,
  (VTBL_ENTRY)&_ZN6S490C53v65Ev,
  (VTBL_ENTRY)&_ZN6S490C53v66Ev,
  (VTBL_ENTRY)&_ZN6S490C53v67Ev,
  (VTBL_ENTRY)&_ZN6S490C53v68Ev,
  (VTBL_ENTRY)&_ZN6S490C53v69Ev,
  (VTBL_ENTRY)&_ZN6S490C53v70Ev,
  (VTBL_ENTRY)&_ZN6S490C53v71Ev,
  (VTBL_ENTRY)&_ZN6S490C53v72Ev,
  (VTBL_ENTRY)&_ZN6S490C53v73Ev,
  (VTBL_ENTRY)&_ZN6S490C53v74Ev,
  (VTBL_ENTRY)&_ZN6S490C53v75Ev,
  (VTBL_ENTRY)&_ZN6S490C53v76Ev,
  (VTBL_ENTRY)&_ZN6S490C53v77Ev,
  (VTBL_ENTRY)&_ZN6S490C53v78Ev,
  (VTBL_ENTRY)&_ZN6S490C53v79Ev,
  (VTBL_ENTRY)&_ZN6S490C43v80Ev,
  (VTBL_ENTRY)&_ZN6S490C43v81Ev,
  (VTBL_ENTRY)&_ZN6S490C43v82Ev,
  (VTBL_ENTRY)&_ZN6S490C43v83Ev,
  (VTBL_ENTRY)&_ZN6S490C43v84Ev,
};
extern VTBL_ENTRY _ZTI6S490C4[];
extern  VTBL_ENTRY _ZTV6S490C4[];
Class_Descriptor cd_S490C4 = {  "S490C4", // class name
  bases_S490C4, 1,
  &(vtc_S490C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S490C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S490C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C3  : S490C4 {
  void *s490c3f0[2];
  unsigned int s490c3f1:1;
  unsigned int s490c3f2:1;
  unsigned int s490c3f3:1;
  unsigned int s490c3f4:1;
  char s490c3f5;
  virtual  ~S490C3(); // _ZN6S490C3D1Ev
  virtual void  v85(); // _ZN6S490C33v85Ev
  virtual void  v86(); // _ZN6S490C33v86Ev
  virtual void  v87(); // _ZN6S490C33v87Ev
  virtual void  v88(); // _ZN6S490C33v88Ev
  virtual void  v89(); // _ZN6S490C33v89Ev
  virtual void  v90(); // _ZN6S490C33v90Ev
  virtual void  v91(); // _ZN6S490C33v91Ev
  virtual void  v92(); // _ZN6S490C33v92Ev
  virtual void  v93(); // _ZN6S490C33v93Ev
  virtual void  v94(); // _ZN6S490C33v94Ev
  virtual void  v95(); // _ZN6S490C33v95Ev
  virtual void  v96(); // _ZN6S490C33v96Ev
  virtual void  v97(); // _ZN6S490C33v97Ev
  virtual void  v98(); // _ZN6S490C33v98Ev
  virtual void  v99(); // _ZN6S490C33v99Ev
  virtual void  v100(); // _ZN6S490C34v100Ev
  virtual void  v101(); // _ZN6S490C34v101Ev
  virtual void  v102(); // _ZN6S490C34v102Ev
  virtual void  v103(); // _ZN6S490C34v103Ev
  virtual void  v104(); // _ZN6S490C34v104Ev
  virtual void  v105(); // _ZN6S490C34v105Ev
  virtual void  v106(); // _ZN6S490C34v106Ev
  S490C3(); // tgen
};
//SIG(-1 S490C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S490C3 ::~S490C3(){ note_dtor("S490C3", this);}
void  S490C3 ::v85(){vfunc_called(this, "_ZN6S490C33v85Ev");}
void  S490C3 ::v86(){vfunc_called(this, "_ZN6S490C33v86Ev");}
void  S490C3 ::v87(){vfunc_called(this, "_ZN6S490C33v87Ev");}
void  S490C3 ::v88(){vfunc_called(this, "_ZN6S490C33v88Ev");}
void  S490C3 ::v89(){vfunc_called(this, "_ZN6S490C33v89Ev");}
void  S490C3 ::v90(){vfunc_called(this, "_ZN6S490C33v90Ev");}
void  S490C3 ::v91(){vfunc_called(this, "_ZN6S490C33v91Ev");}
void  S490C3 ::v92(){vfunc_called(this, "_ZN6S490C33v92Ev");}
void  S490C3 ::v93(){vfunc_called(this, "_ZN6S490C33v93Ev");}
void  S490C3 ::v94(){vfunc_called(this, "_ZN6S490C33v94Ev");}
void  S490C3 ::v95(){vfunc_called(this, "_ZN6S490C33v95Ev");}
void  S490C3 ::v96(){vfunc_called(this, "_ZN6S490C33v96Ev");}
void  S490C3 ::v97(){vfunc_called(this, "_ZN6S490C33v97Ev");}
void  S490C3 ::v98(){vfunc_called(this, "_ZN6S490C33v98Ev");}
void  S490C3 ::v99(){vfunc_called(this, "_ZN6S490C33v99Ev");}
void  S490C3 ::v100(){vfunc_called(this, "_ZN6S490C34v100Ev");}
void  S490C3 ::v101(){vfunc_called(this, "_ZN6S490C34v101Ev");}
void  S490C3 ::v102(){vfunc_called(this, "_ZN6S490C34v102Ev");}
void  S490C3 ::v103(){vfunc_called(this, "_ZN6S490C34v103Ev");}
void  S490C3 ::v104(){vfunc_called(this, "_ZN6S490C34v104Ev");}
void  S490C3 ::v105(){vfunc_called(this, "_ZN6S490C34v105Ev");}
void  S490C3 ::v106(){vfunc_called(this, "_ZN6S490C34v106Ev");}
S490C3 ::S490C3(){ note_ctor("S490C3", this);} // tgen

static void Test_S490C3()
{
  extern Class_Descriptor cd_S490C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S490C3, buf);
    S490C3 *dp, &lv = *(dp=new (buf) S490C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S490C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C3)");
    check_base_class_offset(lv, (S490C5*)(S490C4*), 0, "S490C3");
    check_base_class_offset(lv, (S490C4*), 0, "S490C3");
    check_field_offset(lv, s490c3f0, ABISELECT(112,72), "S490C3.s490c3f0");
    set_bf_and_test(lv, s490c3f1, ABISELECT(128,80), 0, 1, 1, "S490C3");
    set_bf_and_test(lv, s490c3f2, ABISELECT(128,80), 1, 1, 1, "S490C3");
    set_bf_and_test(lv, s490c3f3, ABISELECT(128,80), 2, 1, 1, "S490C3");
    set_bf_and_test(lv, s490c3f4, ABISELECT(128,80), 3, 1, 1, "S490C3");
    check_field_offset(lv, s490c3f5, ABISELECT(129,81), "S490C3.s490c3f5");
    test_class_info(&lv, &cd_S490C3);
    dp->~S490C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C3(Test_S490C3, "S490C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S490C3C1Ev();
extern void _ZN6S490C3D1Ev();
Name_Map name_map_S490C3[] = {
  NSPAIR(_ZN6S490C3C1Ev),
  NSPAIR(_ZN6S490C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S490C5;
extern VTBL_ENTRY _ZTI6S490C5[];
extern  VTBL_ENTRY _ZTV6S490C5[];
extern Class_Descriptor cd_S490C4;
extern VTBL_ENTRY _ZTI6S490C4[];
extern  VTBL_ENTRY _ZTV6S490C4[];
static Base_Class bases_S490C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S490C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S490C3[];
extern void _ZN6S490C3D1Ev();
extern void _ZN6S490C3D0Ev();
extern void _ZN6S490C53v16Ev();
extern void _ZN6S490C53v17Ev();
extern void _ZN6S490C53v18Ev();
extern void _ZN6S490C53v19Ev();
extern void _ZN6S490C53v20Ev();
extern void _ZN6S490C53v21Ev();
extern void _ZN6S490C53v22Ev();
extern void _ZN6S490C53v23Ev();
extern void _ZN6S490C53v24Ev();
extern void _ZN6S490C53v25Ev();
extern void _ZN6S490C53v26Ev();
extern void _ZN6S490C53v27Ev();
extern void _ZN6S490C53v28Ev();
extern void _ZN6S490C53v29Ev();
extern void _ZN6S490C53v30Ev();
extern void _ZN6S490C53v31Ev();
extern void _ZN6S490C53v32Ev();
extern void _ZN6S490C53v33Ev();
extern void _ZN6S490C53v34Ev();
extern void _ZN6S490C53v35Ev();
extern void _ZN6S490C53v36Ev();
extern void _ZN6S490C53v37Ev();
extern void _ZN6S490C53v38Ev();
extern void _ZN6S490C53v39Ev();
extern void _ZN6S490C53v40Ev();
extern void _ZN6S490C53v41Ev();
extern void _ZN6S490C53v42Ev();
extern void _ZN6S490C53v43Ev();
extern void _ZN6S490C53v44Ev();
extern void _ZN6S490C53v45Ev();
extern void _ZN6S490C53v46Ev();
extern void _ZN6S490C53v47Ev();
extern void _ZN6S490C53v48Ev();
extern void _ZN6S490C53v49Ev();
extern void _ZN6S490C53v50Ev();
extern void _ZN6S490C53v51Ev();
extern void _ZN6S490C53v52Ev();
extern void _ZN6S490C53v53Ev();
extern void _ZN6S490C53v54Ev();
extern void _ZN6S490C53v55Ev();
extern void _ZN6S490C53v56Ev();
extern void _ZN6S490C53v57Ev();
extern void _ZN6S490C53v58Ev();
extern void _ZN6S490C53v59Ev();
extern void _ZN6S490C53v60Ev();
extern void _ZN6S490C53v61Ev();
extern void _ZN6S490C53v62Ev();
extern void _ZN6S490C53v63Ev();
extern void _ZN6S490C53v64Ev();
extern void _ZN6S490C53v65Ev();
extern void _ZN6S490C53v66Ev();
extern void _ZN6S490C53v67Ev();
extern void _ZN6S490C53v68Ev();
extern void _ZN6S490C53v69Ev();
extern void _ZN6S490C53v70Ev();
extern void _ZN6S490C53v71Ev();
extern void _ZN6S490C53v72Ev();
extern void _ZN6S490C53v73Ev();
extern void _ZN6S490C53v74Ev();
extern void _ZN6S490C53v75Ev();
extern void _ZN6S490C53v76Ev();
extern void _ZN6S490C53v77Ev();
extern void _ZN6S490C53v78Ev();
extern void _ZN6S490C53v79Ev();
extern void _ZN6S490C43v80Ev();
extern void _ZN6S490C43v81Ev();
extern void _ZN6S490C43v82Ev();
extern void _ZN6S490C43v83Ev();
extern void _ZN6S490C43v84Ev();
extern void _ZN6S490C33v85Ev();
extern void _ZN6S490C33v86Ev();
extern void _ZN6S490C33v87Ev();
extern void _ZN6S490C33v88Ev();
extern void _ZN6S490C33v89Ev();
extern void _ZN6S490C33v90Ev();
extern void _ZN6S490C33v91Ev();
extern void _ZN6S490C33v92Ev();
extern void _ZN6S490C33v93Ev();
extern void _ZN6S490C33v94Ev();
extern void _ZN6S490C33v95Ev();
extern void _ZN6S490C33v96Ev();
extern void _ZN6S490C33v97Ev();
extern void _ZN6S490C33v98Ev();
extern void _ZN6S490C33v99Ev();
extern void _ZN6S490C34v100Ev();
extern void _ZN6S490C34v101Ev();
extern void _ZN6S490C34v102Ev();
extern void _ZN6S490C34v103Ev();
extern void _ZN6S490C34v104Ev();
extern void _ZN6S490C34v105Ev();
extern void _ZN6S490C34v106Ev();
static  VTBL_ENTRY vtc_S490C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S490C3[0]),
  (VTBL_ENTRY)&_ZN6S490C3D1Ev,
  (VTBL_ENTRY)&_ZN6S490C3D0Ev,
  (VTBL_ENTRY)&_ZN6S490C53v16Ev,
  (VTBL_ENTRY)&_ZN6S490C53v17Ev,
  (VTBL_ENTRY)&_ZN6S490C53v18Ev,
  (VTBL_ENTRY)&_ZN6S490C53v19Ev,
  (VTBL_ENTRY)&_ZN6S490C53v20Ev,
  (VTBL_ENTRY)&_ZN6S490C53v21Ev,
  (VTBL_ENTRY)&_ZN6S490C53v22Ev,
  (VTBL_ENTRY)&_ZN6S490C53v23Ev,
  (VTBL_ENTRY)&_ZN6S490C53v24Ev,
  (VTBL_ENTRY)&_ZN6S490C53v25Ev,
  (VTBL_ENTRY)&_ZN6S490C53v26Ev,
  (VTBL_ENTRY)&_ZN6S490C53v27Ev,
  (VTBL_ENTRY)&_ZN6S490C53v28Ev,
  (VTBL_ENTRY)&_ZN6S490C53v29Ev,
  (VTBL_ENTRY)&_ZN6S490C53v30Ev,
  (VTBL_ENTRY)&_ZN6S490C53v31Ev,
  (VTBL_ENTRY)&_ZN6S490C53v32Ev,
  (VTBL_ENTRY)&_ZN6S490C53v33Ev,
  (VTBL_ENTRY)&_ZN6S490C53v34Ev,
  (VTBL_ENTRY)&_ZN6S490C53v35Ev,
  (VTBL_ENTRY)&_ZN6S490C53v36Ev,
  (VTBL_ENTRY)&_ZN6S490C53v37Ev,
  (VTBL_ENTRY)&_ZN6S490C53v38Ev,
  (VTBL_ENTRY)&_ZN6S490C53v39Ev,
  (VTBL_ENTRY)&_ZN6S490C53v40Ev,
  (VTBL_ENTRY)&_ZN6S490C53v41Ev,
  (VTBL_ENTRY)&_ZN6S490C53v42Ev,
  (VTBL_ENTRY)&_ZN6S490C53v43Ev,
  (VTBL_ENTRY)&_ZN6S490C53v44Ev,
  (VTBL_ENTRY)&_ZN6S490C53v45Ev,
  (VTBL_ENTRY)&_ZN6S490C53v46Ev,
  (VTBL_ENTRY)&_ZN6S490C53v47Ev,
  (VTBL_ENTRY)&_ZN6S490C53v48Ev,
  (VTBL_ENTRY)&_ZN6S490C53v49Ev,
  (VTBL_ENTRY)&_ZN6S490C53v50Ev,
  (VTBL_ENTRY)&_ZN6S490C53v51Ev,
  (VTBL_ENTRY)&_ZN6S490C53v52Ev,
  (VTBL_ENTRY)&_ZN6S490C53v53Ev,
  (VTBL_ENTRY)&_ZN6S490C53v54Ev,
  (VTBL_ENTRY)&_ZN6S490C53v55Ev,
  (VTBL_ENTRY)&_ZN6S490C53v56Ev,
  (VTBL_ENTRY)&_ZN6S490C53v57Ev,
  (VTBL_ENTRY)&_ZN6S490C53v58Ev,
  (VTBL_ENTRY)&_ZN6S490C53v59Ev,
  (VTBL_ENTRY)&_ZN6S490C53v60Ev,
  (VTBL_ENTRY)&_ZN6S490C53v61Ev,
  (VTBL_ENTRY)&_ZN6S490C53v62Ev,
  (VTBL_ENTRY)&_ZN6S490C53v63Ev,
  (VTBL_ENTRY)&_ZN6S490C53v64Ev,
  (VTBL_ENTRY)&_ZN6S490C53v65Ev,
  (VTBL_ENTRY)&_ZN6S490C53v66Ev,
  (VTBL_ENTRY)&_ZN6S490C53v67Ev,
  (VTBL_ENTRY)&_ZN6S490C53v68Ev,
  (VTBL_ENTRY)&_ZN6S490C53v69Ev,
  (VTBL_ENTRY)&_ZN6S490C53v70Ev,
  (VTBL_ENTRY)&_ZN6S490C53v71Ev,
  (VTBL_ENTRY)&_ZN6S490C53v72Ev,
  (VTBL_ENTRY)&_ZN6S490C53v73Ev,
  (VTBL_ENTRY)&_ZN6S490C53v74Ev,
  (VTBL_ENTRY)&_ZN6S490C53v75Ev,
  (VTBL_ENTRY)&_ZN6S490C53v76Ev,
  (VTBL_ENTRY)&_ZN6S490C53v77Ev,
  (VTBL_ENTRY)&_ZN6S490C53v78Ev,
  (VTBL_ENTRY)&_ZN6S490C53v79Ev,
  (VTBL_ENTRY)&_ZN6S490C43v80Ev,
  (VTBL_ENTRY)&_ZN6S490C43v81Ev,
  (VTBL_ENTRY)&_ZN6S490C43v82Ev,
  (VTBL_ENTRY)&_ZN6S490C43v83Ev,
  (VTBL_ENTRY)&_ZN6S490C43v84Ev,
  (VTBL_ENTRY)&_ZN6S490C33v85Ev,
  (VTBL_ENTRY)&_ZN6S490C33v86Ev,
  (VTBL_ENTRY)&_ZN6S490C33v87Ev,
  (VTBL_ENTRY)&_ZN6S490C33v88Ev,
  (VTBL_ENTRY)&_ZN6S490C33v89Ev,
  (VTBL_ENTRY)&_ZN6S490C33v90Ev,
  (VTBL_ENTRY)&_ZN6S490C33v91Ev,
  (VTBL_ENTRY)&_ZN6S490C33v92Ev,
  (VTBL_ENTRY)&_ZN6S490C33v93Ev,
  (VTBL_ENTRY)&_ZN6S490C33v94Ev,
  (VTBL_ENTRY)&_ZN6S490C33v95Ev,
  (VTBL_ENTRY)&_ZN6S490C33v96Ev,
  (VTBL_ENTRY)&_ZN6S490C33v97Ev,
  (VTBL_ENTRY)&_ZN6S490C33v98Ev,
  (VTBL_ENTRY)&_ZN6S490C33v99Ev,
  (VTBL_ENTRY)&_ZN6S490C34v100Ev,
  (VTBL_ENTRY)&_ZN6S490C34v101Ev,
  (VTBL_ENTRY)&_ZN6S490C34v102Ev,
  (VTBL_ENTRY)&_ZN6S490C34v103Ev,
  (VTBL_ENTRY)&_ZN6S490C34v104Ev,
  (VTBL_ENTRY)&_ZN6S490C34v105Ev,
  (VTBL_ENTRY)&_ZN6S490C34v106Ev,
};
extern VTBL_ENTRY _ZTI6S490C3[];
extern  VTBL_ENTRY _ZTV6S490C3[];
Class_Descriptor cd_S490C3 = {  "S490C3", // class name
  bases_S490C3, 2,
  &(vtc_S490C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S490C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S490C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C2  : S490C3 {
  void *s490c2f0;
  ::S95C9_nt s490c2f1;
  int s490c2f2;
  ::S236C15_nt s490c2f3;
  int s490c2f4;
  ::S236C26 s490c2f5;
  int s490c2f6;
  void *s490c2f7[2];
  ::S95C13 s490c2f8;
  void *s490c2f9;
  int s490c2f10[2];
  char s490c2f11[3];
  int s490c2f12;
  unsigned int s490c2f13:1;
  unsigned int s490c2f14:1;
  unsigned int s490c2f15:1;
  unsigned int s490c2f16:1;
  unsigned int s490c2f17:1;
  unsigned int s490c2f18:1;
  unsigned int s490c2f19:1;
  unsigned int s490c2f20:1;
  unsigned int s490c2f21:1;
  unsigned int s490c2f22:1;
  unsigned int s490c2f23:1;
  unsigned int s490c2f24:1;
  unsigned int s490c2f25:1;
  unsigned int s490c2f26:1;
  int s490c2f27;
  unsigned int s490c2f28:1;
  unsigned int s490c2f29:1;
  unsigned int s490c2f30:1;
  unsigned int s490c2f31:1;
  unsigned int s490c2f32:1;
  unsigned int s490c2f33:1;
  ::S112C22_nt s490c2f34;
  unsigned int s490c2f35:1;
  unsigned int s490c2f36:1;
  unsigned int s490c2f37:1;
  unsigned int s490c2f38:1;
  unsigned int s490c2f39:1;
  unsigned int s490c2f40:1;
  unsigned int s490c2f41:1;
  char s490c2f42;
  ::S95C16 s490c2f43;
  unsigned int s490c2f44:1;
  unsigned int s490c2f45:1;
  unsigned int s490c2f46:1;
  unsigned int s490c2f47:1;
  unsigned int s490c2f48:1;
  unsigned int s490c2f49:1;
  unsigned int s490c2f50:1;
  unsigned int s490c2f51:1;
  unsigned int s490c2f52:1;
  unsigned int s490c2f53:1;
  unsigned int s490c2f54:1;
  unsigned int s490c2f55:1;
  ::S236C25_nt s490c2f56;
  void *s490c2f57[2];
  char s490c2f58;
  ::S236C15_nt s490c2f59;
  ::S236C18_nt s490c2f60;
  ::S95C14_nt s490c2f61;
  int s490c2f62;
  ::S236C18_nt s490c2f63;
  unsigned int s490c2f64:1;
  unsigned int s490c2f65:1;
  unsigned int s490c2f66:1;
  int s490c2f67[3];
  virtual  ~S490C2(); // _ZN6S490C2D1Ev
  virtual void  v107(); // _ZN6S490C24v107Ev
  virtual void  v108(); // _ZN6S490C24v108Ev
  virtual void  v109(); // _ZN6S490C24v109Ev
  virtual void  v110(); // _ZN6S490C24v110Ev
  virtual void  v111(); // _ZN6S490C24v111Ev
  virtual void  v112(); // _ZN6S490C24v112Ev
  virtual void  v113(); // _ZN6S490C24v113Ev
  virtual void  v114(); // _ZN6S490C24v114Ev
  virtual void  v115(); // _ZN6S490C24v115Ev
  virtual void  v116(); // _ZN6S490C24v116Ev
  virtual void  v117(); // _ZN6S490C24v117Ev
  virtual void  v118(); // _ZN6S490C24v118Ev
  virtual void  v119(); // _ZN6S490C24v119Ev
  virtual void  v120(); // _ZN6S490C24v120Ev
  virtual void  v121(); // _ZN6S490C24v121Ev
  virtual void  v122(); // _ZN6S490C24v122Ev
  virtual void  v123(); // _ZN6S490C24v123Ev
  virtual void  v124(); // _ZN6S490C24v124Ev
  virtual void  v125(); // _ZN6S490C24v125Ev
  virtual void  v126(); // _ZN6S490C24v126Ev
  virtual void  v127(); // _ZN6S490C24v127Ev
  virtual void  v128(); // _ZN6S490C24v128Ev
  virtual void  v129(); // _ZN6S490C24v129Ev
  virtual void  v130(); // _ZN6S490C24v130Ev
  virtual void  v131(); // _ZN6S490C24v131Ev
  virtual void  v132(); // _ZN6S490C24v132Ev
  virtual void  v133(); // _ZN6S490C24v133Ev
  virtual void  v134(); // _ZN6S490C24v134Ev
  virtual void  v135(); // _ZN6S490C24v135Ev
  virtual void  v136(); // _ZN6S490C24v136Ev
  virtual void  v137(); // _ZN6S490C24v137Ev
  virtual void  v138(); // _ZN6S490C24v138Ev
  virtual void  v139(); // _ZN6S490C24v139Ev
  virtual void  v140(); // _ZN6S490C24v140Ev
  virtual void  v141(); // _ZN6S490C24v141Ev
  virtual void  v142(); // _ZN6S490C24v142Ev
  virtual void  v143(); // _ZN6S490C24v143Ev
  virtual void  v144(); // _ZN6S490C24v144Ev
  virtual void  v145(); // _ZN6S490C24v145Ev
  virtual void  v146(); // _ZN6S490C24v146Ev
  virtual void  v147(); // _ZN6S490C24v147Ev
  virtual void  v148(); // _ZN6S490C24v148Ev
  virtual void  v149(); // _ZN6S490C24v149Ev
  virtual void  v150(); // _ZN6S490C24v150Ev
  virtual void  v151(); // _ZN6S490C24v151Ev
  virtual void  v152(); // _ZN6S490C24v152Ev
  virtual void  v153(); // _ZN6S490C24v153Ev
  virtual void  v154(); // _ZN6S490C24v154Ev
  virtual void  v155(); // _ZN6S490C24v155Ev
  virtual void  v156(); // _ZN6S490C24v156Ev
  virtual void  v157(); // _ZN6S490C24v157Ev
  virtual void  v158(); // _ZN6S490C24v158Ev
  virtual void  v159(); // _ZN6S490C24v159Ev
  virtual void  v160(); // _ZN6S490C24v160Ev
  virtual void  v161(); // _ZN6S490C24v161Ev
  virtual void  v162(); // _ZN6S490C24v162Ev
  virtual void  v163(); // _ZN6S490C24v163Ev
  virtual void  v164(); // _ZN6S490C24v164Ev
  virtual void  v165(); // _ZN6S490C24v165Ev
  virtual void  v166(); // _ZN6S490C24v166Ev
  virtual void  v167(); // _ZN6S490C24v167Ev
  S490C2(); // tgen
};
//SIG(-1 S490C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S490C2 ::~S490C2(){ note_dtor("S490C2", this);}
void  S490C2 ::v107(){vfunc_called(this, "_ZN6S490C24v107Ev");}
void  S490C2 ::v108(){vfunc_called(this, "_ZN6S490C24v108Ev");}
void  S490C2 ::v109(){vfunc_called(this, "_ZN6S490C24v109Ev");}
void  S490C2 ::v110(){vfunc_called(this, "_ZN6S490C24v110Ev");}
void  S490C2 ::v111(){vfunc_called(this, "_ZN6S490C24v111Ev");}
void  S490C2 ::v112(){vfunc_called(this, "_ZN6S490C24v112Ev");}
void  S490C2 ::v113(){vfunc_called(this, "_ZN6S490C24v113Ev");}
void  S490C2 ::v114(){vfunc_called(this, "_ZN6S490C24v114Ev");}
void  S490C2 ::v115(){vfunc_called(this, "_ZN6S490C24v115Ev");}
void  S490C2 ::v116(){vfunc_called(this, "_ZN6S490C24v116Ev");}
void  S490C2 ::v117(){vfunc_called(this, "_ZN6S490C24v117Ev");}
void  S490C2 ::v118(){vfunc_called(this, "_ZN6S490C24v118Ev");}
void  S490C2 ::v119(){vfunc_called(this, "_ZN6S490C24v119Ev");}
void  S490C2 ::v120(){vfunc_called(this, "_ZN6S490C24v120Ev");}
void  S490C2 ::v121(){vfunc_called(this, "_ZN6S490C24v121Ev");}
void  S490C2 ::v122(){vfunc_called(this, "_ZN6S490C24v122Ev");}
void  S490C2 ::v123(){vfunc_called(this, "_ZN6S490C24v123Ev");}
void  S490C2 ::v124(){vfunc_called(this, "_ZN6S490C24v124Ev");}
void  S490C2 ::v125(){vfunc_called(this, "_ZN6S490C24v125Ev");}
void  S490C2 ::v126(){vfunc_called(this, "_ZN6S490C24v126Ev");}
void  S490C2 ::v127(){vfunc_called(this, "_ZN6S490C24v127Ev");}
void  S490C2 ::v128(){vfunc_called(this, "_ZN6S490C24v128Ev");}
void  S490C2 ::v129(){vfunc_called(this, "_ZN6S490C24v129Ev");}
void  S490C2 ::v130(){vfunc_called(this, "_ZN6S490C24v130Ev");}
void  S490C2 ::v131(){vfunc_called(this, "_ZN6S490C24v131Ev");}
void  S490C2 ::v132(){vfunc_called(this, "_ZN6S490C24v132Ev");}
void  S490C2 ::v133(){vfunc_called(this, "_ZN6S490C24v133Ev");}
void  S490C2 ::v134(){vfunc_called(this, "_ZN6S490C24v134Ev");}
void  S490C2 ::v135(){vfunc_called(this, "_ZN6S490C24v135Ev");}
void  S490C2 ::v136(){vfunc_called(this, "_ZN6S490C24v136Ev");}
void  S490C2 ::v137(){vfunc_called(this, "_ZN6S490C24v137Ev");}
void  S490C2 ::v138(){vfunc_called(this, "_ZN6S490C24v138Ev");}
void  S490C2 ::v139(){vfunc_called(this, "_ZN6S490C24v139Ev");}
void  S490C2 ::v140(){vfunc_called(this, "_ZN6S490C24v140Ev");}
void  S490C2 ::v141(){vfunc_called(this, "_ZN6S490C24v141Ev");}
void  S490C2 ::v142(){vfunc_called(this, "_ZN6S490C24v142Ev");}
void  S490C2 ::v143(){vfunc_called(this, "_ZN6S490C24v143Ev");}
void  S490C2 ::v144(){vfunc_called(this, "_ZN6S490C24v144Ev");}
void  S490C2 ::v145(){vfunc_called(this, "_ZN6S490C24v145Ev");}
void  S490C2 ::v146(){vfunc_called(this, "_ZN6S490C24v146Ev");}
void  S490C2 ::v147(){vfunc_called(this, "_ZN6S490C24v147Ev");}
void  S490C2 ::v148(){vfunc_called(this, "_ZN6S490C24v148Ev");}
void  S490C2 ::v149(){vfunc_called(this, "_ZN6S490C24v149Ev");}
void  S490C2 ::v150(){vfunc_called(this, "_ZN6S490C24v150Ev");}
void  S490C2 ::v151(){vfunc_called(this, "_ZN6S490C24v151Ev");}
void  S490C2 ::v152(){vfunc_called(this, "_ZN6S490C24v152Ev");}
void  S490C2 ::v153(){vfunc_called(this, "_ZN6S490C24v153Ev");}
void  S490C2 ::v154(){vfunc_called(this, "_ZN6S490C24v154Ev");}
void  S490C2 ::v155(){vfunc_called(this, "_ZN6S490C24v155Ev");}
void  S490C2 ::v156(){vfunc_called(this, "_ZN6S490C24v156Ev");}
void  S490C2 ::v157(){vfunc_called(this, "_ZN6S490C24v157Ev");}
void  S490C2 ::v158(){vfunc_called(this, "_ZN6S490C24v158Ev");}
void  S490C2 ::v159(){vfunc_called(this, "_ZN6S490C24v159Ev");}
void  S490C2 ::v160(){vfunc_called(this, "_ZN6S490C24v160Ev");}
void  S490C2 ::v161(){vfunc_called(this, "_ZN6S490C24v161Ev");}
void  S490C2 ::v162(){vfunc_called(this, "_ZN6S490C24v162Ev");}
void  S490C2 ::v163(){vfunc_called(this, "_ZN6S490C24v163Ev");}
void  S490C2 ::v164(){vfunc_called(this, "_ZN6S490C24v164Ev");}
void  S490C2 ::v165(){vfunc_called(this, "_ZN6S490C24v165Ev");}
void  S490C2 ::v166(){vfunc_called(this, "_ZN6S490C24v166Ev");}
void  S490C2 ::v167(){vfunc_called(this, "_ZN6S490C24v167Ev");}
S490C2 ::S490C2(){ note_ctor("S490C2", this);} // tgen

static void Test_S490C2()
{
  extern Class_Descriptor cd_S490C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S490C2, buf);
    S490C2 *dp, &lv = *(dp=new (buf) S490C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S490C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C2)");
    check_base_class_offset(lv, (S490C5*)(S490C4*)(S490C3*), 0, "S490C2");
    check_base_class_offset(lv, (S490C4*)(S490C3*), 0, "S490C2");
    check_base_class_offset(lv, (S490C3*), 0, "S490C2");
    check_field_offset(lv, s490c2f0, ABISELECT(136,84), "S490C2.s490c2f0");
    check_field_offset(lv, s490c2f1, ABISELECT(144,88), "S490C2.s490c2f1");
    check_field_offset(lv, s490c2f2, ABISELECT(148,92), "S490C2.s490c2f2");
    check_field_offset(lv, s490c2f3, ABISELECT(152,96), "S490C2.s490c2f3");
    check_field_offset(lv, s490c2f4, ABISELECT(156,100), "S490C2.s490c2f4");
    check_field_offset(lv, s490c2f5, ABISELECT(160,104), "S490C2.s490c2f5");
    check_field_offset(lv, s490c2f6, ABISELECT(176,116), "S490C2.s490c2f6");
    check_field_offset(lv, s490c2f7, ABISELECT(184,120), "S490C2.s490c2f7");
    check_field_offset(lv, s490c2f8, ABISELECT(200,128), "S490C2.s490c2f8");
    check_field_offset(lv, s490c2f9, ABISELECT(232,156), "S490C2.s490c2f9");
    check_field_offset(lv, s490c2f10, ABISELECT(240,160), "S490C2.s490c2f10");
    check_field_offset(lv, s490c2f11, ABISELECT(248,168), "S490C2.s490c2f11");
    check_field_offset(lv, s490c2f12, ABISELECT(252,172), "S490C2.s490c2f12");
    set_bf_and_test(lv, s490c2f13, ABISELECT(256,176), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f14, ABISELECT(256,176), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f15, ABISELECT(256,176), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f16, ABISELECT(256,176), 3, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f17, ABISELECT(256,176), 4, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f18, ABISELECT(256,176), 5, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f19, ABISELECT(256,176), 6, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f20, ABISELECT(256,176), 7, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f21, ABISELECT(257,177), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f22, ABISELECT(257,177), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f23, ABISELECT(257,177), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f24, ABISELECT(257,177), 3, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f25, ABISELECT(257,177), 4, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f26, ABISELECT(257,177), 5, 1, 1, "S490C2");
    check_field_offset(lv, s490c2f27, ABISELECT(260,180), "S490C2.s490c2f27");
    set_bf_and_test(lv, s490c2f28, ABISELECT(264,184), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f29, ABISELECT(264,184), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f30, ABISELECT(264,184), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f31, ABISELECT(264,184), 3, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f32, ABISELECT(264,184), 4, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f33, ABISELECT(264,184), 5, 1, 1, "S490C2");
    check_field_offset(lv, s490c2f34, ABISELECT(265,185), "S490C2.s490c2f34");
    set_bf_and_test(lv, s490c2f35, ABISELECT(266,186), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f36, ABISELECT(266,186), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f37, ABISELECT(266,186), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f38, ABISELECT(266,186), 3, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f39, ABISELECT(266,186), 4, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f40, ABISELECT(266,186), 5, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f41, ABISELECT(266,186), 6, 1, 1, "S490C2");
    check_field_offset(lv, s490c2f42, ABISELECT(267,187), "S490C2.s490c2f42");
    check_field_offset(lv, s490c2f43, ABISELECT(268,188), "S490C2.s490c2f43");
    set_bf_and_test(lv, s490c2f44, ABISELECT(269,189), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f45, ABISELECT(269,189), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f46, ABISELECT(269,189), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f47, ABISELECT(269,189), 3, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f48, ABISELECT(269,189), 4, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f49, ABISELECT(269,189), 5, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f50, ABISELECT(269,189), 6, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f51, ABISELECT(269,189), 7, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f52, ABISELECT(270,190), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f53, ABISELECT(270,190), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f54, ABISELECT(270,190), 2, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f55, ABISELECT(270,190), 3, 1, 1, "S490C2");
    check_field_offset(lv, s490c2f56, ABISELECT(272,192), "S490C2.s490c2f56");
    check_field_offset(lv, s490c2f57, ABISELECT(288,204), "S490C2.s490c2f57");
    check_field_offset(lv, s490c2f58, ABISELECT(304,212), "S490C2.s490c2f58");
    check_field_offset(lv, s490c2f59, ABISELECT(305,213), "S490C2.s490c2f59");
    check_field_offset(lv, s490c2f60, ABISELECT(308,216), "S490C2.s490c2f60");
    check_field_offset(lv, s490c2f61, ABISELECT(320,228), "S490C2.s490c2f61");
    check_field_offset(lv, s490c2f62, ABISELECT(332,240), "S490C2.s490c2f62");
    check_field_offset(lv, s490c2f63, ABISELECT(336,244), "S490C2.s490c2f63");
    set_bf_and_test(lv, s490c2f64, ABISELECT(348,256), 0, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f65, ABISELECT(348,256), 1, 1, 1, "S490C2");
    set_bf_and_test(lv, s490c2f66, ABISELECT(348,256), 2, 1, 1, "S490C2");
    check_field_offset(lv, s490c2f67, ABISELECT(352,260), "S490C2.s490c2f67");
    test_class_info(&lv, &cd_S490C2);
    dp->~S490C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C2(Test_S490C2, "S490C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S490C2C1Ev();
extern void _ZN6S490C2D1Ev();
Name_Map name_map_S490C2[] = {
  NSPAIR(_ZN6S490C2C1Ev),
  NSPAIR(_ZN6S490C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S490C5;
extern VTBL_ENTRY _ZTI6S490C5[];
extern  VTBL_ENTRY _ZTV6S490C5[];
extern Class_Descriptor cd_S490C4;
extern VTBL_ENTRY _ZTI6S490C4[];
extern  VTBL_ENTRY _ZTV6S490C4[];
extern Class_Descriptor cd_S490C3;
extern VTBL_ENTRY _ZTI6S490C3[];
extern  VTBL_ENTRY _ZTV6S490C3[];
static Base_Class bases_S490C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S490C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S490C2[];
extern void _ZN6S490C2D1Ev();
extern void _ZN6S490C2D0Ev();
extern void _ZN6S490C53v16Ev();
extern void _ZN6S490C53v17Ev();
extern void _ZN6S490C53v18Ev();
extern void _ZN6S490C53v19Ev();
extern void _ZN6S490C53v20Ev();
extern void _ZN6S490C53v21Ev();
extern void _ZN6S490C53v22Ev();
extern void _ZN6S490C53v23Ev();
extern void _ZN6S490C53v24Ev();
extern void _ZN6S490C53v25Ev();
extern void _ZN6S490C53v26Ev();
extern void _ZN6S490C53v27Ev();
extern void _ZN6S490C53v28Ev();
extern void _ZN6S490C53v29Ev();
extern void _ZN6S490C53v30Ev();
extern void _ZN6S490C53v31Ev();
extern void _ZN6S490C53v32Ev();
extern void _ZN6S490C53v33Ev();
extern void _ZN6S490C53v34Ev();
extern void _ZN6S490C53v35Ev();
extern void _ZN6S490C53v36Ev();
extern void _ZN6S490C53v37Ev();
extern void _ZN6S490C53v38Ev();
extern void _ZN6S490C53v39Ev();
extern void _ZN6S490C53v40Ev();
extern void _ZN6S490C53v41Ev();
extern void _ZN6S490C53v42Ev();
extern void _ZN6S490C53v43Ev();
extern void _ZN6S490C53v44Ev();
extern void _ZN6S490C53v45Ev();
extern void _ZN6S490C53v46Ev();
extern void _ZN6S490C53v47Ev();
extern void _ZN6S490C53v48Ev();
extern void _ZN6S490C53v49Ev();
extern void _ZN6S490C53v50Ev();
extern void _ZN6S490C53v51Ev();
extern void _ZN6S490C53v52Ev();
extern void _ZN6S490C53v53Ev();
extern void _ZN6S490C53v54Ev();
extern void _ZN6S490C53v55Ev();
extern void _ZN6S490C53v56Ev();
extern void _ZN6S490C53v57Ev();
extern void _ZN6S490C53v58Ev();
extern void _ZN6S490C53v59Ev();
extern void _ZN6S490C53v60Ev();
extern void _ZN6S490C53v61Ev();
extern void _ZN6S490C53v62Ev();
extern void _ZN6S490C53v63Ev();
extern void _ZN6S490C53v64Ev();
extern void _ZN6S490C53v65Ev();
extern void _ZN6S490C53v66Ev();
extern void _ZN6S490C53v67Ev();
extern void _ZN6S490C53v68Ev();
extern void _ZN6S490C53v69Ev();
extern void _ZN6S490C53v70Ev();
extern void _ZN6S490C53v71Ev();
extern void _ZN6S490C53v72Ev();
extern void _ZN6S490C53v73Ev();
extern void _ZN6S490C53v74Ev();
extern void _ZN6S490C53v75Ev();
extern void _ZN6S490C53v76Ev();
extern void _ZN6S490C53v77Ev();
extern void _ZN6S490C53v78Ev();
extern void _ZN6S490C53v79Ev();
extern void _ZN6S490C43v80Ev();
extern void _ZN6S490C43v81Ev();
extern void _ZN6S490C43v82Ev();
extern void _ZN6S490C43v83Ev();
extern void _ZN6S490C43v84Ev();
extern void _ZN6S490C33v85Ev();
extern void _ZN6S490C33v86Ev();
extern void _ZN6S490C33v87Ev();
extern void _ZN6S490C33v88Ev();
extern void _ZN6S490C33v89Ev();
extern void _ZN6S490C33v90Ev();
extern void _ZN6S490C33v91Ev();
extern void _ZN6S490C33v92Ev();
extern void _ZN6S490C33v93Ev();
extern void _ZN6S490C33v94Ev();
extern void _ZN6S490C33v95Ev();
extern void _ZN6S490C33v96Ev();
extern void _ZN6S490C33v97Ev();
extern void _ZN6S490C33v98Ev();
extern void _ZN6S490C33v99Ev();
extern void _ZN6S490C34v100Ev();
extern void _ZN6S490C34v101Ev();
extern void _ZN6S490C34v102Ev();
extern void _ZN6S490C34v103Ev();
extern void _ZN6S490C34v104Ev();
extern void _ZN6S490C34v105Ev();
extern void _ZN6S490C34v106Ev();
extern void _ZN6S490C24v107Ev();
extern void _ZN6S490C24v108Ev();
extern void _ZN6S490C24v109Ev();
extern void _ZN6S490C24v110Ev();
extern void _ZN6S490C24v111Ev();
extern void _ZN6S490C24v112Ev();
extern void _ZN6S490C24v113Ev();
extern void _ZN6S490C24v114Ev();
extern void _ZN6S490C24v115Ev();
extern void _ZN6S490C24v116Ev();
extern void _ZN6S490C24v117Ev();
extern void _ZN6S490C24v118Ev();
extern void _ZN6S490C24v119Ev();
extern void _ZN6S490C24v120Ev();
extern void _ZN6S490C24v121Ev();
extern void _ZN6S490C24v122Ev();
extern void _ZN6S490C24v123Ev();
extern void _ZN6S490C24v124Ev();
extern void _ZN6S490C24v125Ev();
extern void _ZN6S490C24v126Ev();
extern void _ZN6S490C24v127Ev();
extern void _ZN6S490C24v128Ev();
extern void _ZN6S490C24v129Ev();
extern void _ZN6S490C24v130Ev();
extern void _ZN6S490C24v131Ev();
extern void _ZN6S490C24v132Ev();
extern void _ZN6S490C24v133Ev();
extern void _ZN6S490C24v134Ev();
extern void _ZN6S490C24v135Ev();
extern void _ZN6S490C24v136Ev();
extern void _ZN6S490C24v137Ev();
extern void _ZN6S490C24v138Ev();
extern void _ZN6S490C24v139Ev();
extern void _ZN6S490C24v140Ev();
extern void _ZN6S490C24v141Ev();
extern void _ZN6S490C24v142Ev();
extern void _ZN6S490C24v143Ev();
extern void _ZN6S490C24v144Ev();
extern void _ZN6S490C24v145Ev();
extern void _ZN6S490C24v146Ev();
extern void _ZN6S490C24v147Ev();
extern void _ZN6S490C24v148Ev();
extern void _ZN6S490C24v149Ev();
extern void _ZN6S490C24v150Ev();
extern void _ZN6S490C24v151Ev();
extern void _ZN6S490C24v152Ev();
extern void _ZN6S490C24v153Ev();
extern void _ZN6S490C24v154Ev();
extern void _ZN6S490C24v155Ev();
extern void _ZN6S490C24v156Ev();
extern void _ZN6S490C24v157Ev();
extern void _ZN6S490C24v158Ev();
extern void _ZN6S490C24v159Ev();
extern void _ZN6S490C24v160Ev();
extern void _ZN6S490C24v161Ev();
extern void _ZN6S490C24v162Ev();
extern void _ZN6S490C24v163Ev();
extern void _ZN6S490C24v164Ev();
extern void _ZN6S490C24v165Ev();
extern void _ZN6S490C24v166Ev();
extern void _ZN6S490C24v167Ev();
static  VTBL_ENTRY vtc_S490C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S490C2[0]),
  (VTBL_ENTRY)&_ZN6S490C2D1Ev,
  (VTBL_ENTRY)&_ZN6S490C2D0Ev,
  (VTBL_ENTRY)&_ZN6S490C53v16Ev,
  (VTBL_ENTRY)&_ZN6S490C53v17Ev,
  (VTBL_ENTRY)&_ZN6S490C53v18Ev,
  (VTBL_ENTRY)&_ZN6S490C53v19Ev,
  (VTBL_ENTRY)&_ZN6S490C53v20Ev,
  (VTBL_ENTRY)&_ZN6S490C53v21Ev,
  (VTBL_ENTRY)&_ZN6S490C53v22Ev,
  (VTBL_ENTRY)&_ZN6S490C53v23Ev,
  (VTBL_ENTRY)&_ZN6S490C53v24Ev,
  (VTBL_ENTRY)&_ZN6S490C53v25Ev,
  (VTBL_ENTRY)&_ZN6S490C53v26Ev,
  (VTBL_ENTRY)&_ZN6S490C53v27Ev,
  (VTBL_ENTRY)&_ZN6S490C53v28Ev,
  (VTBL_ENTRY)&_ZN6S490C53v29Ev,
  (VTBL_ENTRY)&_ZN6S490C53v30Ev,
  (VTBL_ENTRY)&_ZN6S490C53v31Ev,
  (VTBL_ENTRY)&_ZN6S490C53v32Ev,
  (VTBL_ENTRY)&_ZN6S490C53v33Ev,
  (VTBL_ENTRY)&_ZN6S490C53v34Ev,
  (VTBL_ENTRY)&_ZN6S490C53v35Ev,
  (VTBL_ENTRY)&_ZN6S490C53v36Ev,
  (VTBL_ENTRY)&_ZN6S490C53v37Ev,
  (VTBL_ENTRY)&_ZN6S490C53v38Ev,
  (VTBL_ENTRY)&_ZN6S490C53v39Ev,
  (VTBL_ENTRY)&_ZN6S490C53v40Ev,
  (VTBL_ENTRY)&_ZN6S490C53v41Ev,
  (VTBL_ENTRY)&_ZN6S490C53v42Ev,
  (VTBL_ENTRY)&_ZN6S490C53v43Ev,
  (VTBL_ENTRY)&_ZN6S490C53v44Ev,
  (VTBL_ENTRY)&_ZN6S490C53v45Ev,
  (VTBL_ENTRY)&_ZN6S490C53v46Ev,
  (VTBL_ENTRY)&_ZN6S490C53v47Ev,
  (VTBL_ENTRY)&_ZN6S490C53v48Ev,
  (VTBL_ENTRY)&_ZN6S490C53v49Ev,
  (VTBL_ENTRY)&_ZN6S490C53v50Ev,
  (VTBL_ENTRY)&_ZN6S490C53v51Ev,
  (VTBL_ENTRY)&_ZN6S490C53v52Ev,
  (VTBL_ENTRY)&_ZN6S490C53v53Ev,
  (VTBL_ENTRY)&_ZN6S490C53v54Ev,
  (VTBL_ENTRY)&_ZN6S490C53v55Ev,
  (VTBL_ENTRY)&_ZN6S490C53v56Ev,
  (VTBL_ENTRY)&_ZN6S490C53v57Ev,
  (VTBL_ENTRY)&_ZN6S490C53v58Ev,
  (VTBL_ENTRY)&_ZN6S490C53v59Ev,
  (VTBL_ENTRY)&_ZN6S490C53v60Ev,
  (VTBL_ENTRY)&_ZN6S490C53v61Ev,
  (VTBL_ENTRY)&_ZN6S490C53v62Ev,
  (VTBL_ENTRY)&_ZN6S490C53v63Ev,
  (VTBL_ENTRY)&_ZN6S490C53v64Ev,
  (VTBL_ENTRY)&_ZN6S490C53v65Ev,
  (VTBL_ENTRY)&_ZN6S490C53v66Ev,
  (VTBL_ENTRY)&_ZN6S490C53v67Ev,
  (VTBL_ENTRY)&_ZN6S490C53v68Ev,
  (VTBL_ENTRY)&_ZN6S490C53v69Ev,
  (VTBL_ENTRY)&_ZN6S490C53v70Ev,
  (VTBL_ENTRY)&_ZN6S490C53v71Ev,
  (VTBL_ENTRY)&_ZN6S490C53v72Ev,
  (VTBL_ENTRY)&_ZN6S490C53v73Ev,
  (VTBL_ENTRY)&_ZN6S490C53v74Ev,
  (VTBL_ENTRY)&_ZN6S490C53v75Ev,
  (VTBL_ENTRY)&_ZN6S490C53v76Ev,
  (VTBL_ENTRY)&_ZN6S490C53v77Ev,
  (VTBL_ENTRY)&_ZN6S490C53v78Ev,
  (VTBL_ENTRY)&_ZN6S490C53v79Ev,
  (VTBL_ENTRY)&_ZN6S490C43v80Ev,
  (VTBL_ENTRY)&_ZN6S490C43v81Ev,
  (VTBL_ENTRY)&_ZN6S490C43v82Ev,
  (VTBL_ENTRY)&_ZN6S490C43v83Ev,
  (VTBL_ENTRY)&_ZN6S490C43v84Ev,
  (VTBL_ENTRY)&_ZN6S490C33v85Ev,
  (VTBL_ENTRY)&_ZN6S490C33v86Ev,
  (VTBL_ENTRY)&_ZN6S490C33v87Ev,
  (VTBL_ENTRY)&_ZN6S490C33v88Ev,
  (VTBL_ENTRY)&_ZN6S490C33v89Ev,
  (VTBL_ENTRY)&_ZN6S490C33v90Ev,
  (VTBL_ENTRY)&_ZN6S490C33v91Ev,
  (VTBL_ENTRY)&_ZN6S490C33v92Ev,
  (VTBL_ENTRY)&_ZN6S490C33v93Ev,
  (VTBL_ENTRY)&_ZN6S490C33v94Ev,
  (VTBL_ENTRY)&_ZN6S490C33v95Ev,
  (VTBL_ENTRY)&_ZN6S490C33v96Ev,
  (VTBL_ENTRY)&_ZN6S490C33v97Ev,
  (VTBL_ENTRY)&_ZN6S490C33v98Ev,
  (VTBL_ENTRY)&_ZN6S490C33v99Ev,
  (VTBL_ENTRY)&_ZN6S490C34v100Ev,
  (VTBL_ENTRY)&_ZN6S490C34v101Ev,
  (VTBL_ENTRY)&_ZN6S490C34v102Ev,
  (VTBL_ENTRY)&_ZN6S490C34v103Ev,
  (VTBL_ENTRY)&_ZN6S490C34v104Ev,
  (VTBL_ENTRY)&_ZN6S490C34v105Ev,
  (VTBL_ENTRY)&_ZN6S490C34v106Ev,
  (VTBL_ENTRY)&_ZN6S490C24v107Ev,
  (VTBL_ENTRY)&_ZN6S490C24v108Ev,
  (VTBL_ENTRY)&_ZN6S490C24v109Ev,
  (VTBL_ENTRY)&_ZN6S490C24v110Ev,
  (VTBL_ENTRY)&_ZN6S490C24v111Ev,
  (VTBL_ENTRY)&_ZN6S490C24v112Ev,
  (VTBL_ENTRY)&_ZN6S490C24v113Ev,
  (VTBL_ENTRY)&_ZN6S490C24v114Ev,
  (VTBL_ENTRY)&_ZN6S490C24v115Ev,
  (VTBL_ENTRY)&_ZN6S490C24v116Ev,
  (VTBL_ENTRY)&_ZN6S490C24v117Ev,
  (VTBL_ENTRY)&_ZN6S490C24v118Ev,
  (VTBL_ENTRY)&_ZN6S490C24v119Ev,
  (VTBL_ENTRY)&_ZN6S490C24v120Ev,
  (VTBL_ENTRY)&_ZN6S490C24v121Ev,
  (VTBL_ENTRY)&_ZN6S490C24v122Ev,
  (VTBL_ENTRY)&_ZN6S490C24v123Ev,
  (VTBL_ENTRY)&_ZN6S490C24v124Ev,
  (VTBL_ENTRY)&_ZN6S490C24v125Ev,
  (VTBL_ENTRY)&_ZN6S490C24v126Ev,
  (VTBL_ENTRY)&_ZN6S490C24v127Ev,
  (VTBL_ENTRY)&_ZN6S490C24v128Ev,
  (VTBL_ENTRY)&_ZN6S490C24v129Ev,
  (VTBL_ENTRY)&_ZN6S490C24v130Ev,
  (VTBL_ENTRY)&_ZN6S490C24v131Ev,
  (VTBL_ENTRY)&_ZN6S490C24v132Ev,
  (VTBL_ENTRY)&_ZN6S490C24v133Ev,
  (VTBL_ENTRY)&_ZN6S490C24v134Ev,
  (VTBL_ENTRY)&_ZN6S490C24v135Ev,
  (VTBL_ENTRY)&_ZN6S490C24v136Ev,
  (VTBL_ENTRY)&_ZN6S490C24v137Ev,
  (VTBL_ENTRY)&_ZN6S490C24v138Ev,
  (VTBL_ENTRY)&_ZN6S490C24v139Ev,
  (VTBL_ENTRY)&_ZN6S490C24v140Ev,
  (VTBL_ENTRY)&_ZN6S490C24v141Ev,
  (VTBL_ENTRY)&_ZN6S490C24v142Ev,
  (VTBL_ENTRY)&_ZN6S490C24v143Ev,
  (VTBL_ENTRY)&_ZN6S490C24v144Ev,
  (VTBL_ENTRY)&_ZN6S490C24v145Ev,
  (VTBL_ENTRY)&_ZN6S490C24v146Ev,
  (VTBL_ENTRY)&_ZN6S490C24v147Ev,
  (VTBL_ENTRY)&_ZN6S490C24v148Ev,
  (VTBL_ENTRY)&_ZN6S490C24v149Ev,
  (VTBL_ENTRY)&_ZN6S490C24v150Ev,
  (VTBL_ENTRY)&_ZN6S490C24v151Ev,
  (VTBL_ENTRY)&_ZN6S490C24v152Ev,
  (VTBL_ENTRY)&_ZN6S490C24v153Ev,
  (VTBL_ENTRY)&_ZN6S490C24v154Ev,
  (VTBL_ENTRY)&_ZN6S490C24v155Ev,
  (VTBL_ENTRY)&_ZN6S490C24v156Ev,
  (VTBL_ENTRY)&_ZN6S490C24v157Ev,
  (VTBL_ENTRY)&_ZN6S490C24v158Ev,
  (VTBL_ENTRY)&_ZN6S490C24v159Ev,
  (VTBL_ENTRY)&_ZN6S490C24v160Ev,
  (VTBL_ENTRY)&_ZN6S490C24v161Ev,
  (VTBL_ENTRY)&_ZN6S490C24v162Ev,
  (VTBL_ENTRY)&_ZN6S490C24v163Ev,
  (VTBL_ENTRY)&_ZN6S490C24v164Ev,
  (VTBL_ENTRY)&_ZN6S490C24v165Ev,
  (VTBL_ENTRY)&_ZN6S490C24v166Ev,
  (VTBL_ENTRY)&_ZN6S490C24v167Ev,
};
extern VTBL_ENTRY _ZTI6S490C2[];
extern  VTBL_ENTRY _ZTV6S490C2[];
Class_Descriptor cd_S490C2 = {  "S490C2", // class name
  bases_S490C2, 3,
  &(vtc_S490C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S490C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S490C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C27  : S95C12_nt {
};
//SIG(-1 S490C27) C1{ BC2{ m Fp Fi[2]}}



static void Test_S490C27()
{
  extern Class_Descriptor cd_S490C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S490C27, buf);
    S490C27 &lv = *(new (buf) S490C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S490C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C27)");
    check_base_class_offset(lv, (S95C12_nt*), 0, "S490C27");
    test_class_info(&lv, &cd_S490C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C27(Test_S490C27, "S490C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
static Base_Class bases_S490C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S490C27 = {  "S490C27", // class name
  bases_S490C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C26  : S490C27 {
};
//SIG(-1 S490C26) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S490C26()
{
  extern Class_Descriptor cd_S490C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S490C26, buf);
    S490C26 &lv = *(new (buf) S490C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S490C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C26)");
    check_base_class_offset(lv, (S95C12_nt*)(S490C27*), 0, "S490C26");
    check_base_class_offset(lv, (S490C27*), 0, "S490C26");
    test_class_info(&lv, &cd_S490C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C26(Test_S490C26, "S490C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S95C12_nt;
extern Class_Descriptor cd_S490C27;
static Base_Class bases_S490C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S95C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S490C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S490C26 = {  "S490C26", // class name
  bases_S490C26, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S490C1  : S490C2 {
  void *s490c1f0;
  int s490c1f1[11];
  ::S236C18_nt s490c1f2;
  ::S95C14_nt s490c1f3;
  ::S236C18_nt s490c1f4;
  ::S236C18_nt s490c1f5;
  ::S236C18_nt s490c1f6;
  ::S236C18_nt s490c1f7;
  unsigned int s490c1f8:1;
  unsigned int s490c1f9:1;
  unsigned int s490c1f10:1;
  unsigned int s490c1f11:1;
  unsigned int s490c1f12:1;
  unsigned int s490c1f13:1;
  unsigned int s490c1f14:1;
  unsigned int s490c1f15:1;
  unsigned int s490c1f16:1;
  void *s490c1f17;
  ::S95C8_nt s490c1f18;
  int s490c1f19[2];
  ::S95C35 s490c1f20;
  ::S95C31 s490c1f21;
  ::S95C27 s490c1f22;
  void *s490c1f23;
  ::S95C17_nt s490c1f24;
  int s490c1f25[4];
  char s490c1f26;
  ::S490C26 s490c1f27;
  ::S490C26 s490c1f28;
  virtual  ~S490C1(); // _ZN6S490C1D1Ev
  virtual void  v1(); // _ZN6S490C12v1Ev
  virtual void  v2(); // _ZN6S490C12v2Ev
  virtual void  v3(); // _ZN6S490C12v3Ev
  virtual void  v4(); // _ZN6S490C12v4Ev
  virtual void  v5(); // _ZN6S490C12v5Ev
  virtual void  v6(); // _ZN6S490C12v6Ev
  virtual void  v7(); // _ZN6S490C12v7Ev
  virtual void  v8(); // _ZN6S490C12v8Ev
  virtual void  v9(); // _ZN6S490C12v9Ev
  virtual void  v10(); // _ZN6S490C13v10Ev
  virtual void  v11(); // _ZN6S490C13v11Ev
  virtual void  v12(); // _ZN6S490C13v12Ev
  virtual void  v13(); // _ZN6S490C13v13Ev
  virtual void  v14(); // _ZN6S490C13v14Ev
  virtual void  v15(); // _ZN6S490C13v15Ev
  S490C1(); // tgen
};
//SIG(1 S490C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v80 v81 v82 v83 v84 Fp FC6} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp Fi[11] FC16 FC12 FC16 FC16 FC16 FC16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp FC6 Fi[2] FC17{ BC18{ BC10}} FC19{ BC20{ BC10}} FC21{ BC22{ BC10}} Fp FC23{ BC24{ BC10}} Fi[4] Fc FC25{ BC26{ BC10}} FC25}


 S490C1 ::~S490C1(){ note_dtor("S490C1", this);}
void  S490C1 ::v1(){vfunc_called(this, "_ZN6S490C12v1Ev");}
void  S490C1 ::v2(){vfunc_called(this, "_ZN6S490C12v2Ev");}
void  S490C1 ::v3(){vfunc_called(this, "_ZN6S490C12v3Ev");}
void  S490C1 ::v4(){vfunc_called(this, "_ZN6S490C12v4Ev");}
void  S490C1 ::v5(){vfunc_called(this, "_ZN6S490C12v5Ev");}
void  S490C1 ::v6(){vfunc_called(this, "_ZN6S490C12v6Ev");}
void  S490C1 ::v7(){vfunc_called(this, "_ZN6S490C12v7Ev");}
void  S490C1 ::v8(){vfunc_called(this, "_ZN6S490C12v8Ev");}
void  S490C1 ::v9(){vfunc_called(this, "_ZN6S490C12v9Ev");}
void  S490C1 ::v10(){vfunc_called(this, "_ZN6S490C13v10Ev");}
void  S490C1 ::v11(){vfunc_called(this, "_ZN6S490C13v11Ev");}
void  S490C1 ::v12(){vfunc_called(this, "_ZN6S490C13v12Ev");}
void  S490C1 ::v13(){vfunc_called(this, "_ZN6S490C13v13Ev");}
void  S490C1 ::v14(){vfunc_called(this, "_ZN6S490C13v14Ev");}
void  S490C1 ::v15(){vfunc_called(this, "_ZN6S490C13v15Ev");}
S490C1 ::S490C1(){ note_ctor("S490C1", this);} // tgen

static void Test_S490C1()
{
  extern Class_Descriptor cd_S490C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(82,129)];
    init_test(&cd_S490C1, buf);
    S490C1 *dp, &lv = *(dp=new (buf) S490C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(648,512), "sizeof(S490C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S490C1)");
    check_base_class_offset(lv, (S490C5*)(S490C4*)(S490C3*)(S490C2*), 0, "S490C1");
    check_base_class_offset(lv, (S490C4*)(S490C3*)(S490C2*), 0, "S490C1");
    check_base_class_offset(lv, (S490C3*)(S490C2*), 0, "S490C1");
    check_base_class_offset(lv, (S490C2*), 0, "S490C1");
    check_field_offset(lv, s490c1f0, ABISELECT(368,272), "S490C1.s490c1f0");
    check_field_offset(lv, s490c1f1, ABISELECT(376,276), "S490C1.s490c1f1");
    check_field_offset(lv, s490c1f2, ABISELECT(420,320), "S490C1.s490c1f2");
    check_field_offset(lv, s490c1f3, ABISELECT(432,332), "S490C1.s490c1f3");
    check_field_offset(lv, s490c1f4, ABISELECT(444,344), "S490C1.s490c1f4");
    check_field_offset(lv, s490c1f5, ABISELECT(456,356), "S490C1.s490c1f5");
    check_field_offset(lv, s490c1f6, ABISELECT(468,368), "S490C1.s490c1f6");
    check_field_offset(lv, s490c1f7, ABISELECT(480,380), "S490C1.s490c1f7");
    set_bf_and_test(lv, s490c1f8, ABISELECT(492,392), 0, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f9, ABISELECT(492,392), 1, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f10, ABISELECT(492,392), 2, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f11, ABISELECT(492,392), 3, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f12, ABISELECT(492,392), 4, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f13, ABISELECT(492,392), 5, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f14, ABISELECT(492,392), 6, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f15, ABISELECT(492,392), 7, 1, 1, "S490C1");
    set_bf_and_test(lv, s490c1f16, ABISELECT(493,393), 0, 1, 1, "S490C1");
    check_field_offset(lv, s490c1f17, ABISELECT(496,396), "S490C1.s490c1f17");
    check_field_offset(lv, s490c1f18, ABISELECT(504,400), "S490C1.s490c1f18");
    check_field_offset(lv, s490c1f19, ABISELECT(512,408), "S490C1.s490c1f19");
    check_field_offset(lv, s490c1f20, ABISELECT(520,416), "S490C1.s490c1f20");
    check_field_offset(lv, s490c1f21, ABISELECT(536,428), "S490C1.s490c1f21");
    check_field_offset(lv, s490c1f22, ABISELECT(552,440), "S490C1.s490c1f22");
    check_field_offset(lv, s490c1f23, ABISELECT(568,452), "S490C1.s490c1f23");
    check_field_offset(lv, s490c1f24, ABISELECT(576,456), "S490C1.s490c1f24");
    check_field_offset(lv, s490c1f25, ABISELECT(592,468), "S490C1.s490c1f25");
    check_field_offset(lv, s490c1f26, ABISELECT(608,484), "S490C1.s490c1f26");
    check_field_offset(lv, s490c1f27, ABISELECT(616,488), "S490C1.s490c1f27");
    check_field_offset(lv, s490c1f28, ABISELECT(632,500), "S490C1.s490c1f28");
    test_class_info(&lv, &cd_S490C1);
    dp->~S490C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS490C1(Test_S490C1, "S490C1", ABISELECT(648,512));

#else // __cplusplus

extern void _ZN6S490C1C1Ev();
extern void _ZN6S490C1D1Ev();
Name_Map name_map_S490C1[] = {
  NSPAIR(_ZN6S490C1C1Ev),
  NSPAIR(_ZN6S490C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S490C5;
extern VTBL_ENTRY _ZTI6S490C5[];
extern  VTBL_ENTRY _ZTV6S490C5[];
extern Class_Descriptor cd_S490C4;
extern VTBL_ENTRY _ZTI6S490C4[];
extern  VTBL_ENTRY _ZTV6S490C4[];
extern Class_Descriptor cd_S490C3;
extern VTBL_ENTRY _ZTI6S490C3[];
extern  VTBL_ENTRY _ZTV6S490C3[];
extern Class_Descriptor cd_S490C2;
extern VTBL_ENTRY _ZTI6S490C2[];
extern  VTBL_ENTRY _ZTV6S490C2[];
static Base_Class bases_S490C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S490C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S490C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S490C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S490C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S490C1[];
extern void _ZN6S490C1D1Ev();
extern void _ZN6S490C1D0Ev();
extern void _ZN6S490C53v16Ev();
extern void _ZN6S490C53v17Ev();
extern void _ZN6S490C53v18Ev();
extern void _ZN6S490C53v19Ev();
extern void _ZN6S490C53v20Ev();
extern void _ZN6S490C53v21Ev();
extern void _ZN6S490C53v22Ev();
extern void _ZN6S490C53v23Ev();
extern void _ZN6S490C53v24Ev();
extern void _ZN6S490C53v25Ev();
extern void _ZN6S490C53v26Ev();
extern void _ZN6S490C53v27Ev();
extern void _ZN6S490C53v28Ev();
extern void _ZN6S490C53v29Ev();
extern void _ZN6S490C53v30Ev();
extern void _ZN6S490C53v31Ev();
extern void _ZN6S490C53v32Ev();
extern void _ZN6S490C53v33Ev();
extern void _ZN6S490C53v34Ev();
extern void _ZN6S490C53v35Ev();
extern void _ZN6S490C53v36Ev();
extern void _ZN6S490C53v37Ev();
extern void _ZN6S490C53v38Ev();
extern void _ZN6S490C53v39Ev();
extern void _ZN6S490C53v40Ev();
extern void _ZN6S490C53v41Ev();
extern void _ZN6S490C53v42Ev();
extern void _ZN6S490C53v43Ev();
extern void _ZN6S490C53v44Ev();
extern void _ZN6S490C53v45Ev();
extern void _ZN6S490C53v46Ev();
extern void _ZN6S490C53v47Ev();
extern void _ZN6S490C53v48Ev();
extern void _ZN6S490C53v49Ev();
extern void _ZN6S490C53v50Ev();
extern void _ZN6S490C53v51Ev();
extern void _ZN6S490C53v52Ev();
extern void _ZN6S490C53v53Ev();
extern void _ZN6S490C53v54Ev();
extern void _ZN6S490C53v55Ev();
extern void _ZN6S490C53v56Ev();
extern void _ZN6S490C53v57Ev();
extern void _ZN6S490C53v58Ev();
extern void _ZN6S490C53v59Ev();
extern void _ZN6S490C53v60Ev();
extern void _ZN6S490C53v61Ev();
extern void _ZN6S490C53v62Ev();
extern void _ZN6S490C53v63Ev();
extern void _ZN6S490C53v64Ev();
extern void _ZN6S490C53v65Ev();
extern void _ZN6S490C53v66Ev();
extern void _ZN6S490C53v67Ev();
extern void _ZN6S490C53v68Ev();
extern void _ZN6S490C53v69Ev();
extern void _ZN6S490C53v70Ev();
extern void _ZN6S490C53v71Ev();
extern void _ZN6S490C53v72Ev();
extern void _ZN6S490C53v73Ev();
extern void _ZN6S490C53v74Ev();
extern void _ZN6S490C53v75Ev();
extern void _ZN6S490C53v76Ev();
extern void _ZN6S490C53v77Ev();
extern void _ZN6S490C53v78Ev();
extern void _ZN6S490C53v79Ev();
extern void _ZN6S490C43v80Ev();
extern void _ZN6S490C43v81Ev();
extern void _ZN6S490C43v82Ev();
extern void _ZN6S490C43v83Ev();
extern void _ZN6S490C43v84Ev();
extern void _ZN6S490C33v85Ev();
extern void _ZN6S490C33v86Ev();
extern void _ZN6S490C33v87Ev();
extern void _ZN6S490C33v88Ev();
extern void _ZN6S490C33v89Ev();
extern void _ZN6S490C33v90Ev();
extern void _ZN6S490C33v91Ev();
extern void _ZN6S490C33v92Ev();
extern void _ZN6S490C33v93Ev();
extern void _ZN6S490C33v94Ev();
extern void _ZN6S490C33v95Ev();
extern void _ZN6S490C33v96Ev();
extern void _ZN6S490C33v97Ev();
extern void _ZN6S490C33v98Ev();
extern void _ZN6S490C33v99Ev();
extern void _ZN6S490C34v100Ev();
extern void _ZN6S490C34v101Ev();
extern void _ZN6S490C34v102Ev();
extern void _ZN6S490C34v103Ev();
extern void _ZN6S490C34v104Ev();
extern void _ZN6S490C34v105Ev();
extern void _ZN6S490C34v106Ev();
extern void _ZN6S490C24v107Ev();
extern void _ZN6S490C24v108Ev();
extern void _ZN6S490C24v109Ev();
extern void _ZN6S490C24v110Ev();
extern void _ZN6S490C24v111Ev();
extern void _ZN6S490C24v112Ev();
extern void _ZN6S490C24v113Ev();
extern void _ZN6S490C24v114Ev();
extern void _ZN6S490C24v115Ev();
extern void _ZN6S490C24v116Ev();
extern void _ZN6S490C24v117Ev();
extern void _ZN6S490C24v118Ev();
extern void _ZN6S490C24v119Ev();
extern void _ZN6S490C24v120Ev();
extern void _ZN6S490C24v121Ev();
extern void _ZN6S490C24v122Ev();
extern void _ZN6S490C24v123Ev();
extern void _ZN6S490C24v124Ev();
extern void _ZN6S490C24v125Ev();
extern void _ZN6S490C24v126Ev();
extern void _ZN6S490C24v127Ev();
extern void _ZN6S490C24v128Ev();
extern void _ZN6S490C24v129Ev();
extern void _ZN6S490C24v130Ev();
extern void _ZN6S490C24v131Ev();
extern void _ZN6S490C24v132Ev();
extern void _ZN6S490C24v133Ev();
extern void _ZN6S490C24v134Ev();
extern void _ZN6S490C24v135Ev();
extern void _ZN6S490C24v136Ev();
extern void _ZN6S490C24v137Ev();
extern void _ZN6S490C24v138Ev();
extern void _ZN6S490C24v139Ev();
extern void _ZN6S490C24v140Ev();
extern void _ZN6S490C24v141Ev();
extern void _ZN6S490C24v142Ev();
extern void _ZN6S490C24v143Ev();
extern void _ZN6S490C24v144Ev();
extern void _ZN6S490C24v145Ev();
extern void _ZN6S490C24v146Ev();
extern void _ZN6S490C24v147Ev();
extern void _ZN6S490C24v148Ev();
extern void _ZN6S490C24v149Ev();
extern void _ZN6S490C24v150Ev();
extern void _ZN6S490C24v151Ev();
extern void _ZN6S490C24v152Ev();
extern void _ZN6S490C24v153Ev();
extern void _ZN6S490C24v154Ev();
extern void _ZN6S490C24v155Ev();
extern void _ZN6S490C24v156Ev();
extern void _ZN6S490C24v157Ev();
extern void _ZN6S490C24v158Ev();
extern void _ZN6S490C24v159Ev();
extern void _ZN6S490C24v160Ev();
extern void _ZN6S490C24v161Ev();
extern void _ZN6S490C24v162Ev();
extern void _ZN6S490C24v163Ev();
extern void _ZN6S490C24v164Ev();
extern void _ZN6S490C24v165Ev();
extern void _ZN6S490C24v166Ev();
extern void _ZN6S490C24v167Ev();
extern void _ZN6S490C12v1Ev();
extern void _ZN6S490C12v2Ev();
extern void _ZN6S490C12v3Ev();
extern void _ZN6S490C12v4Ev();
extern void _ZN6S490C12v5Ev();
extern void _ZN6S490C12v6Ev();
extern void _ZN6S490C12v7Ev();
extern void _ZN6S490C12v8Ev();
extern void _ZN6S490C12v9Ev();
extern void _ZN6S490C13v10Ev();
extern void _ZN6S490C13v11Ev();
extern void _ZN6S490C13v12Ev();
extern void _ZN6S490C13v13Ev();
extern void _ZN6S490C13v14Ev();
extern void _ZN6S490C13v15Ev();
static  VTBL_ENTRY vtc_S490C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S490C1[0]),
  (VTBL_ENTRY)&_ZN6S490C1D1Ev,
  (VTBL_ENTRY)&_ZN6S490C1D0Ev,
  (VTBL_ENTRY)&_ZN6S490C53v16Ev,
  (VTBL_ENTRY)&_ZN6S490C53v17Ev,
  (VTBL_ENTRY)&_ZN6S490C53v18Ev,
  (VTBL_ENTRY)&_ZN6S490C53v19Ev,
  (VTBL_ENTRY)&_ZN6S490C53v20Ev,
  (VTBL_ENTRY)&_ZN6S490C53v21Ev,
  (VTBL_ENTRY)&_ZN6S490C53v22Ev,
  (VTBL_ENTRY)&_ZN6S490C53v23Ev,
  (VTBL_ENTRY)&_ZN6S490C53v24Ev,
  (VTBL_ENTRY)&_ZN6S490C53v25Ev,
  (VTBL_ENTRY)&_ZN6S490C53v26Ev,
  (VTBL_ENTRY)&_ZN6S490C53v27Ev,
  (VTBL_ENTRY)&_ZN6S490C53v28Ev,
  (VTBL_ENTRY)&_ZN6S490C53v29Ev,
  (VTBL_ENTRY)&_ZN6S490C53v30Ev,
  (VTBL_ENTRY)&_ZN6S490C53v31Ev,
  (VTBL_ENTRY)&_ZN6S490C53v32Ev,
  (VTBL_ENTRY)&_ZN6S490C53v33Ev,
  (VTBL_ENTRY)&_ZN6S490C53v34Ev,
  (VTBL_ENTRY)&_ZN6S490C53v35Ev,
  (VTBL_ENTRY)&_ZN6S490C53v36Ev,
  (VTBL_ENTRY)&_ZN6S490C53v37Ev,
  (VTBL_ENTRY)&_ZN6S490C53v38Ev,
  (VTBL_ENTRY)&_ZN6S490C53v39Ev,
  (VTBL_ENTRY)&_ZN6S490C53v40Ev,
  (VTBL_ENTRY)&_ZN6S490C53v41Ev,
  (VTBL_ENTRY)&_ZN6S490C53v42Ev,
  (VTBL_ENTRY)&_ZN6S490C53v43Ev,
  (VTBL_ENTRY)&_ZN6S490C53v44Ev,
  (VTBL_ENTRY)&_ZN6S490C53v45Ev,
  (VTBL_ENTRY)&_ZN6S490C53v46Ev,
  (VTBL_ENTRY)&_ZN6S490C53v47Ev,
  (VTBL_ENTRY)&_ZN6S490C53v48Ev,
  (VTBL_ENTRY)&_ZN6S490C53v49Ev,
  (VTBL_ENTRY)&_ZN6S490C53v50Ev,
  (VTBL_ENTRY)&_ZN6S490C53v51Ev,
  (VTBL_ENTRY)&_ZN6S490C53v52Ev,
  (VTBL_ENTRY)&_ZN6S490C53v53Ev,
  (VTBL_ENTRY)&_ZN6S490C53v54Ev,
  (VTBL_ENTRY)&_ZN6S490C53v55Ev,
  (VTBL_ENTRY)&_ZN6S490C53v56Ev,
  (VTBL_ENTRY)&_ZN6S490C53v57Ev,
  (VTBL_ENTRY)&_ZN6S490C53v58Ev,
  (VTBL_ENTRY)&_ZN6S490C53v59Ev,
  (VTBL_ENTRY)&_ZN6S490C53v60Ev,
  (VTBL_ENTRY)&_ZN6S490C53v61Ev,
  (VTBL_ENTRY)&_ZN6S490C53v62Ev,
  (VTBL_ENTRY)&_ZN6S490C53v63Ev,
  (VTBL_ENTRY)&_ZN6S490C53v64Ev,
  (VTBL_ENTRY)&_ZN6S490C53v65Ev,
  (VTBL_ENTRY)&_ZN6S490C53v66Ev,
  (VTBL_ENTRY)&_ZN6S490C53v67Ev,
  (VTBL_ENTRY)&_ZN6S490C53v68Ev,
  (VTBL_ENTRY)&_ZN6S490C53v69Ev,
  (VTBL_ENTRY)&_ZN6S490C53v70Ev,
  (VTBL_ENTRY)&_ZN6S490C53v71Ev,
  (VTBL_ENTRY)&_ZN6S490C53v72Ev,
  (VTBL_ENTRY)&_ZN6S490C53v73Ev,
  (VTBL_ENTRY)&_ZN6S490C53v74Ev,
  (VTBL_ENTRY)&_ZN6S490C53v75Ev,
  (VTBL_ENTRY)&_ZN6S490C53v76Ev,
  (VTBL_ENTRY)&_ZN6S490C53v77Ev,
  (VTBL_ENTRY)&_ZN6S490C53v78Ev,
  (VTBL_ENTRY)&_ZN6S490C53v79Ev,
  (VTBL_ENTRY)&_ZN6S490C43v80Ev,
  (VTBL_ENTRY)&_ZN6S490C43v81Ev,
  (VTBL_ENTRY)&_ZN6S490C43v82Ev,
  (VTBL_ENTRY)&_ZN6S490C43v83Ev,
  (VTBL_ENTRY)&_ZN6S490C43v84Ev,
  (VTBL_ENTRY)&_ZN6S490C33v85Ev,
  (VTBL_ENTRY)&_ZN6S490C33v86Ev,
  (VTBL_ENTRY)&_ZN6S490C33v87Ev,
  (VTBL_ENTRY)&_ZN6S490C33v88Ev,
  (VTBL_ENTRY)&_ZN6S490C33v89Ev,
  (VTBL_ENTRY)&_ZN6S490C33v90Ev,
  (VTBL_ENTRY)&_ZN6S490C33v91Ev,
  (VTBL_ENTRY)&_ZN6S490C33v92Ev,
  (VTBL_ENTRY)&_ZN6S490C33v93Ev,
  (VTBL_ENTRY)&_ZN6S490C33v94Ev,
  (VTBL_ENTRY)&_ZN6S490C33v95Ev,
  (VTBL_ENTRY)&_ZN6S490C33v96Ev,
  (VTBL_ENTRY)&_ZN6S490C33v97Ev,
  (VTBL_ENTRY)&_ZN6S490C33v98Ev,
  (VTBL_ENTRY)&_ZN6S490C33v99Ev,
  (VTBL_ENTRY)&_ZN6S490C34v100Ev,
  (VTBL_ENTRY)&_ZN6S490C34v101Ev,
  (VTBL_ENTRY)&_ZN6S490C34v102Ev,
  (VTBL_ENTRY)&_ZN6S490C34v103Ev,
  (VTBL_ENTRY)&_ZN6S490C34v104Ev,
  (VTBL_ENTRY)&_ZN6S490C34v105Ev,
  (VTBL_ENTRY)&_ZN6S490C34v106Ev,
  (VTBL_ENTRY)&_ZN6S490C24v107Ev,
  (VTBL_ENTRY)&_ZN6S490C24v108Ev,
  (VTBL_ENTRY)&_ZN6S490C24v109Ev,
  (VTBL_ENTRY)&_ZN6S490C24v110Ev,
  (VTBL_ENTRY)&_ZN6S490C24v111Ev,
  (VTBL_ENTRY)&_ZN6S490C24v112Ev,
  (VTBL_ENTRY)&_ZN6S490C24v113Ev,
  (VTBL_ENTRY)&_ZN6S490C24v114Ev,
  (VTBL_ENTRY)&_ZN6S490C24v115Ev,
  (VTBL_ENTRY)&_ZN6S490C24v116Ev,
  (VTBL_ENTRY)&_ZN6S490C24v117Ev,
  (VTBL_ENTRY)&_ZN6S490C24v118Ev,
  (VTBL_ENTRY)&_ZN6S490C24v119Ev,
  (VTBL_ENTRY)&_ZN6S490C24v120Ev,
  (VTBL_ENTRY)&_ZN6S490C24v121Ev,
  (VTBL_ENTRY)&_ZN6S490C24v122Ev,
  (VTBL_ENTRY)&_ZN6S490C24v123Ev,
  (VTBL_ENTRY)&_ZN6S490C24v124Ev,
  (VTBL_ENTRY)&_ZN6S490C24v125Ev,
  (VTBL_ENTRY)&_ZN6S490C24v126Ev,
  (VTBL_ENTRY)&_ZN6S490C24v127Ev,
  (VTBL_ENTRY)&_ZN6S490C24v128Ev,
  (VTBL_ENTRY)&_ZN6S490C24v129Ev,
  (VTBL_ENTRY)&_ZN6S490C24v130Ev,
  (VTBL_ENTRY)&_ZN6S490C24v131Ev,
  (VTBL_ENTRY)&_ZN6S490C24v132Ev,
  (VTBL_ENTRY)&_ZN6S490C24v133Ev,
  (VTBL_ENTRY)&_ZN6S490C24v134Ev,
  (VTBL_ENTRY)&_ZN6S490C24v135Ev,
  (VTBL_ENTRY)&_ZN6S490C24v136Ev,
  (VTBL_ENTRY)&_ZN6S490C24v137Ev,
  (VTBL_ENTRY)&_ZN6S490C24v138Ev,
  (VTBL_ENTRY)&_ZN6S490C24v139Ev,
  (VTBL_ENTRY)&_ZN6S490C24v140Ev,
  (VTBL_ENTRY)&_ZN6S490C24v141Ev,
  (VTBL_ENTRY)&_ZN6S490C24v142Ev,
  (VTBL_ENTRY)&_ZN6S490C24v143Ev,
  (VTBL_ENTRY)&_ZN6S490C24v144Ev,
  (VTBL_ENTRY)&_ZN6S490C24v145Ev,
  (VTBL_ENTRY)&_ZN6S490C24v146Ev,
  (VTBL_ENTRY)&_ZN6S490C24v147Ev,
  (VTBL_ENTRY)&_ZN6S490C24v148Ev,
  (VTBL_ENTRY)&_ZN6S490C24v149Ev,
  (VTBL_ENTRY)&_ZN6S490C24v150Ev,
  (VTBL_ENTRY)&_ZN6S490C24v151Ev,
  (VTBL_ENTRY)&_ZN6S490C24v152Ev,
  (VTBL_ENTRY)&_ZN6S490C24v153Ev,
  (VTBL_ENTRY)&_ZN6S490C24v154Ev,
  (VTBL_ENTRY)&_ZN6S490C24v155Ev,
  (VTBL_ENTRY)&_ZN6S490C24v156Ev,
  (VTBL_ENTRY)&_ZN6S490C24v157Ev,
  (VTBL_ENTRY)&_ZN6S490C24v158Ev,
  (VTBL_ENTRY)&_ZN6S490C24v159Ev,
  (VTBL_ENTRY)&_ZN6S490C24v160Ev,
  (VTBL_ENTRY)&_ZN6S490C24v161Ev,
  (VTBL_ENTRY)&_ZN6S490C24v162Ev,
  (VTBL_ENTRY)&_ZN6S490C24v163Ev,
  (VTBL_ENTRY)&_ZN6S490C24v164Ev,
  (VTBL_ENTRY)&_ZN6S490C24v165Ev,
  (VTBL_ENTRY)&_ZN6S490C24v166Ev,
  (VTBL_ENTRY)&_ZN6S490C24v167Ev,
  (VTBL_ENTRY)&_ZN6S490C12v1Ev,
  (VTBL_ENTRY)&_ZN6S490C12v2Ev,
  (VTBL_ENTRY)&_ZN6S490C12v3Ev,
  (VTBL_ENTRY)&_ZN6S490C12v4Ev,
  (VTBL_ENTRY)&_ZN6S490C12v5Ev,
  (VTBL_ENTRY)&_ZN6S490C12v6Ev,
  (VTBL_ENTRY)&_ZN6S490C12v7Ev,
  (VTBL_ENTRY)&_ZN6S490C12v8Ev,
  (VTBL_ENTRY)&_ZN6S490C12v9Ev,
  (VTBL_ENTRY)&_ZN6S490C13v10Ev,
  (VTBL_ENTRY)&_ZN6S490C13v11Ev,
  (VTBL_ENTRY)&_ZN6S490C13v12Ev,
  (VTBL_ENTRY)&_ZN6S490C13v13Ev,
  (VTBL_ENTRY)&_ZN6S490C13v14Ev,
  (VTBL_ENTRY)&_ZN6S490C13v15Ev,
};
extern VTBL_ENTRY _ZTI6S490C1[];
extern  VTBL_ENTRY _ZTV6S490C1[];
Class_Descriptor cd_S490C1 = {  "S490C1", // class name
  bases_S490C1, 4,
  &(vtc_S490C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(648,512), // object size
  NSPAIRA(_ZTI6S490C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S490C1),171, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C5  {
  int s513c5f0;
  __tsi64 s513c5f1;
  void *s513c5f2[4];
  int s513c5f3[2];
  void *s513c5f4;
  ::S95C8_nt s513c5f5;
  void *s513c5f6[2];
  virtual  ~S513C5(); // _ZN6S513C5D1Ev
  virtual void  v25(); // _ZN6S513C53v25Ev
  virtual void  v26(); // _ZN6S513C53v26Ev
  virtual void  v27(); // _ZN6S513C53v27Ev
  virtual void  v28(); // _ZN6S513C53v28Ev
  virtual void  v29(); // _ZN6S513C53v29Ev
  virtual void  v30(); // _ZN6S513C53v30Ev
  virtual void  v31(); // _ZN6S513C53v31Ev
  virtual void  v32(); // _ZN6S513C53v32Ev
  virtual void  v33(); // _ZN6S513C53v33Ev
  virtual void  v34(); // _ZN6S513C53v34Ev
  virtual void  v35(); // _ZN6S513C53v35Ev
  virtual void  v36(); // _ZN6S513C53v36Ev
  virtual void  v37(); // _ZN6S513C53v37Ev
  virtual void  v38(); // _ZN6S513C53v38Ev
  virtual void  v39(); // _ZN6S513C53v39Ev
  virtual void  v40(); // _ZN6S513C53v40Ev
  virtual void  v41(); // _ZN6S513C53v41Ev
  virtual void  v42(); // _ZN6S513C53v42Ev
  virtual void  v43(); // _ZN6S513C53v43Ev
  virtual void  v44(); // _ZN6S513C53v44Ev
  virtual void  v45(); // _ZN6S513C53v45Ev
  virtual void  v46(); // _ZN6S513C53v46Ev
  virtual void  v47(); // _ZN6S513C53v47Ev
  virtual void  v48(); // _ZN6S513C53v48Ev
  virtual void  v49(); // _ZN6S513C53v49Ev
  virtual void  v50(); // _ZN6S513C53v50Ev
  virtual void  v51(); // _ZN6S513C53v51Ev
  virtual void  v52(); // _ZN6S513C53v52Ev
  virtual void  v53(); // _ZN6S513C53v53Ev
  virtual void  v54(); // _ZN6S513C53v54Ev
  virtual void  v55(); // _ZN6S513C53v55Ev
  virtual void  v56(); // _ZN6S513C53v56Ev
  virtual void  v57(); // _ZN6S513C53v57Ev
  virtual void  v58(); // _ZN6S513C53v58Ev
  virtual void  v59(); // _ZN6S513C53v59Ev
  virtual void  v60(); // _ZN6S513C53v60Ev
  virtual void  v61(); // _ZN6S513C53v61Ev
  virtual void  v62(); // _ZN6S513C53v62Ev
  virtual void  v63(); // _ZN6S513C53v63Ev
  virtual void  v64(); // _ZN6S513C53v64Ev
  virtual void  v65(); // _ZN6S513C53v65Ev
  virtual void  v66(); // _ZN6S513C53v66Ev
  virtual void  v67(); // _ZN6S513C53v67Ev
  virtual void  v68(); // _ZN6S513C53v68Ev
  virtual void  v69(); // _ZN6S513C53v69Ev
  virtual void  v70(); // _ZN6S513C53v70Ev
  virtual void  v71(); // _ZN6S513C53v71Ev
  virtual void  v72(); // _ZN6S513C53v72Ev
  virtual void  v73(); // _ZN6S513C53v73Ev
  virtual void  v74(); // _ZN6S513C53v74Ev
  virtual void  v75(); // _ZN6S513C53v75Ev
  virtual void  v76(); // _ZN6S513C53v76Ev
  virtual void  v77(); // _ZN6S513C53v77Ev
  virtual void  v78(); // _ZN6S513C53v78Ev
  virtual void  v79(); // _ZN6S513C53v79Ev
  virtual void  v80(); // _ZN6S513C53v80Ev
  virtual void  v81(); // _ZN6S513C53v81Ev
  virtual void  v82(); // _ZN6S513C53v82Ev
  virtual void  v83(); // _ZN6S513C53v83Ev
  virtual void  v84(); // _ZN6S513C53v84Ev
  virtual void  v85(); // _ZN6S513C53v85Ev
  virtual void  v86(); // _ZN6S513C53v86Ev
  virtual void  v87(); // _ZN6S513C53v87Ev
  virtual void  v88(); // _ZN6S513C53v88Ev
  S513C5(); // tgen
};
//SIG(-1 S513C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S513C5 ::~S513C5(){ note_dtor("S513C5", this);}
void  S513C5 ::v25(){vfunc_called(this, "_ZN6S513C53v25Ev");}
void  S513C5 ::v26(){vfunc_called(this, "_ZN6S513C53v26Ev");}
void  S513C5 ::v27(){vfunc_called(this, "_ZN6S513C53v27Ev");}
void  S513C5 ::v28(){vfunc_called(this, "_ZN6S513C53v28Ev");}
void  S513C5 ::v29(){vfunc_called(this, "_ZN6S513C53v29Ev");}
void  S513C5 ::v30(){vfunc_called(this, "_ZN6S513C53v30Ev");}
void  S513C5 ::v31(){vfunc_called(this, "_ZN6S513C53v31Ev");}
void  S513C5 ::v32(){vfunc_called(this, "_ZN6S513C53v32Ev");}
void  S513C5 ::v33(){vfunc_called(this, "_ZN6S513C53v33Ev");}
void  S513C5 ::v34(){vfunc_called(this, "_ZN6S513C53v34Ev");}
void  S513C5 ::v35(){vfunc_called(this, "_ZN6S513C53v35Ev");}
void  S513C5 ::v36(){vfunc_called(this, "_ZN6S513C53v36Ev");}
void  S513C5 ::v37(){vfunc_called(this, "_ZN6S513C53v37Ev");}
void  S513C5 ::v38(){vfunc_called(this, "_ZN6S513C53v38Ev");}
void  S513C5 ::v39(){vfunc_called(this, "_ZN6S513C53v39Ev");}
void  S513C5 ::v40(){vfunc_called(this, "_ZN6S513C53v40Ev");}
void  S513C5 ::v41(){vfunc_called(this, "_ZN6S513C53v41Ev");}
void  S513C5 ::v42(){vfunc_called(this, "_ZN6S513C53v42Ev");}
void  S513C5 ::v43(){vfunc_called(this, "_ZN6S513C53v43Ev");}
void  S513C5 ::v44(){vfunc_called(this, "_ZN6S513C53v44Ev");}
void  S513C5 ::v45(){vfunc_called(this, "_ZN6S513C53v45Ev");}
void  S513C5 ::v46(){vfunc_called(this, "_ZN6S513C53v46Ev");}
void  S513C5 ::v47(){vfunc_called(this, "_ZN6S513C53v47Ev");}
void  S513C5 ::v48(){vfunc_called(this, "_ZN6S513C53v48Ev");}
void  S513C5 ::v49(){vfunc_called(this, "_ZN6S513C53v49Ev");}
void  S513C5 ::v50(){vfunc_called(this, "_ZN6S513C53v50Ev");}
void  S513C5 ::v51(){vfunc_called(this, "_ZN6S513C53v51Ev");}
void  S513C5 ::v52(){vfunc_called(this, "_ZN6S513C53v52Ev");}
void  S513C5 ::v53(){vfunc_called(this, "_ZN6S513C53v53Ev");}
void  S513C5 ::v54(){vfunc_called(this, "_ZN6S513C53v54Ev");}
void  S513C5 ::v55(){vfunc_called(this, "_ZN6S513C53v55Ev");}
void  S513C5 ::v56(){vfunc_called(this, "_ZN6S513C53v56Ev");}
void  S513C5 ::v57(){vfunc_called(this, "_ZN6S513C53v57Ev");}
void  S513C5 ::v58(){vfunc_called(this, "_ZN6S513C53v58Ev");}
void  S513C5 ::v59(){vfunc_called(this, "_ZN6S513C53v59Ev");}
void  S513C5 ::v60(){vfunc_called(this, "_ZN6S513C53v60Ev");}
void  S513C5 ::v61(){vfunc_called(this, "_ZN6S513C53v61Ev");}
void  S513C5 ::v62(){vfunc_called(this, "_ZN6S513C53v62Ev");}
void  S513C5 ::v63(){vfunc_called(this, "_ZN6S513C53v63Ev");}
void  S513C5 ::v64(){vfunc_called(this, "_ZN6S513C53v64Ev");}
void  S513C5 ::v65(){vfunc_called(this, "_ZN6S513C53v65Ev");}
void  S513C5 ::v66(){vfunc_called(this, "_ZN6S513C53v66Ev");}
void  S513C5 ::v67(){vfunc_called(this, "_ZN6S513C53v67Ev");}
void  S513C5 ::v68(){vfunc_called(this, "_ZN6S513C53v68Ev");}
void  S513C5 ::v69(){vfunc_called(this, "_ZN6S513C53v69Ev");}
void  S513C5 ::v70(){vfunc_called(this, "_ZN6S513C53v70Ev");}
void  S513C5 ::v71(){vfunc_called(this, "_ZN6S513C53v71Ev");}
void  S513C5 ::v72(){vfunc_called(this, "_ZN6S513C53v72Ev");}
void  S513C5 ::v73(){vfunc_called(this, "_ZN6S513C53v73Ev");}
void  S513C5 ::v74(){vfunc_called(this, "_ZN6S513C53v74Ev");}
void  S513C5 ::v75(){vfunc_called(this, "_ZN6S513C53v75Ev");}
void  S513C5 ::v76(){vfunc_called(this, "_ZN6S513C53v76Ev");}
void  S513C5 ::v77(){vfunc_called(this, "_ZN6S513C53v77Ev");}
void  S513C5 ::v78(){vfunc_called(this, "_ZN6S513C53v78Ev");}
void  S513C5 ::v79(){vfunc_called(this, "_ZN6S513C53v79Ev");}
void  S513C5 ::v80(){vfunc_called(this, "_ZN6S513C53v80Ev");}
void  S513C5 ::v81(){vfunc_called(this, "_ZN6S513C53v81Ev");}
void  S513C5 ::v82(){vfunc_called(this, "_ZN6S513C53v82Ev");}
void  S513C5 ::v83(){vfunc_called(this, "_ZN6S513C53v83Ev");}
void  S513C5 ::v84(){vfunc_called(this, "_ZN6S513C53v84Ev");}
void  S513C5 ::v85(){vfunc_called(this, "_ZN6S513C53v85Ev");}
void  S513C5 ::v86(){vfunc_called(this, "_ZN6S513C53v86Ev");}
void  S513C5 ::v87(){vfunc_called(this, "_ZN6S513C53v87Ev");}
void  S513C5 ::v88(){vfunc_called(this, "_ZN6S513C53v88Ev");}
S513C5 ::S513C5(){ note_ctor("S513C5", this);} // tgen

static void Test_S513C5()
{
  extern Class_Descriptor cd_S513C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S513C5, buf);
    S513C5 *dp, &lv = *(dp=new (buf) S513C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S513C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C5)");
    check_field_offset(lv, s513c5f0, ABISELECT(8,4), "S513C5.s513c5f0");
    check_field_offset(lv, s513c5f1, ABISELECT(16,8), "S513C5.s513c5f1");
    check_field_offset(lv, s513c5f2, ABISELECT(24,16), "S513C5.s513c5f2");
    check_field_offset(lv, s513c5f3, ABISELECT(56,32), "S513C5.s513c5f3");
    check_field_offset(lv, s513c5f4, ABISELECT(64,40), "S513C5.s513c5f4");
    check_field_offset(lv, s513c5f5, ABISELECT(72,44), "S513C5.s513c5f5");
    check_field_offset(lv, s513c5f6, ABISELECT(80,52), "S513C5.s513c5f6");
    test_class_info(&lv, &cd_S513C5);
    dp->~S513C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS513C5(Test_S513C5, "S513C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S513C5C1Ev();
extern void _ZN6S513C5D1Ev();
Name_Map name_map_S513C5[] = {
  NSPAIR(_ZN6S513C5C1Ev),
  NSPAIR(_ZN6S513C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S513C5[];
extern void _ZN6S513C5D1Ev();
extern void _ZN6S513C5D0Ev();
extern void _ZN6S513C53v25Ev();
extern void _ZN6S513C53v26Ev();
extern void _ZN6S513C53v27Ev();
extern void _ZN6S513C53v28Ev();
extern void _ZN6S513C53v29Ev();
extern void _ZN6S513C53v30Ev();
extern void _ZN6S513C53v31Ev();
extern void _ZN6S513C53v32Ev();
extern void _ZN6S513C53v33Ev();
extern void _ZN6S513C53v34Ev();
extern void _ZN6S513C53v35Ev();
extern void _ZN6S513C53v36Ev();
extern void _ZN6S513C53v37Ev();
extern void _ZN6S513C53v38Ev();
extern void _ZN6S513C53v39Ev();
extern void _ZN6S513C53v40Ev();
extern void _ZN6S513C53v41Ev();
extern void _ZN6S513C53v42Ev();
extern void _ZN6S513C53v43Ev();
extern void _ZN6S513C53v44Ev();
extern void _ZN6S513C53v45Ev();
extern void _ZN6S513C53v46Ev();
extern void _ZN6S513C53v47Ev();
extern void _ZN6S513C53v48Ev();
extern void _ZN6S513C53v49Ev();
extern void _ZN6S513C53v50Ev();
extern void _ZN6S513C53v51Ev();
extern void _ZN6S513C53v52Ev();
extern void _ZN6S513C53v53Ev();
extern void _ZN6S513C53v54Ev();
extern void _ZN6S513C53v55Ev();
extern void _ZN6S513C53v56Ev();
extern void _ZN6S513C53v57Ev();
extern void _ZN6S513C53v58Ev();
extern void _ZN6S513C53v59Ev();
extern void _ZN6S513C53v60Ev();
extern void _ZN6S513C53v61Ev();
extern void _ZN6S513C53v62Ev();
extern void _ZN6S513C53v63Ev();
extern void _ZN6S513C53v64Ev();
extern void _ZN6S513C53v65Ev();
extern void _ZN6S513C53v66Ev();
extern void _ZN6S513C53v67Ev();
extern void _ZN6S513C53v68Ev();
extern void _ZN6S513C53v69Ev();
extern void _ZN6S513C53v70Ev();
extern void _ZN6S513C53v71Ev();
extern void _ZN6S513C53v72Ev();
extern void _ZN6S513C53v73Ev();
extern void _ZN6S513C53v74Ev();
extern void _ZN6S513C53v75Ev();
extern void _ZN6S513C53v76Ev();
extern void _ZN6S513C53v77Ev();
extern void _ZN6S513C53v78Ev();
extern void _ZN6S513C53v79Ev();
extern void _ZN6S513C53v80Ev();
extern void _ZN6S513C53v81Ev();
extern void _ZN6S513C53v82Ev();
extern void _ZN6S513C53v83Ev();
extern void _ZN6S513C53v84Ev();
extern void _ZN6S513C53v85Ev();
extern void _ZN6S513C53v86Ev();
extern void _ZN6S513C53v87Ev();
extern void _ZN6S513C53v88Ev();
static  VTBL_ENTRY vtc_S513C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S513C5[0]),
  (VTBL_ENTRY)&_ZN6S513C5D1Ev,
  (VTBL_ENTRY)&_ZN6S513C5D0Ev,
  (VTBL_ENTRY)&_ZN6S513C53v25Ev,
  (VTBL_ENTRY)&_ZN6S513C53v26Ev,
  (VTBL_ENTRY)&_ZN6S513C53v27Ev,
  (VTBL_ENTRY)&_ZN6S513C53v28Ev,
  (VTBL_ENTRY)&_ZN6S513C53v29Ev,
  (VTBL_ENTRY)&_ZN6S513C53v30Ev,
  (VTBL_ENTRY)&_ZN6S513C53v31Ev,
  (VTBL_ENTRY)&_ZN6S513C53v32Ev,
  (VTBL_ENTRY)&_ZN6S513C53v33Ev,
  (VTBL_ENTRY)&_ZN6S513C53v34Ev,
  (VTBL_ENTRY)&_ZN6S513C53v35Ev,
  (VTBL_ENTRY)&_ZN6S513C53v36Ev,
  (VTBL_ENTRY)&_ZN6S513C53v37Ev,
  (VTBL_ENTRY)&_ZN6S513C53v38Ev,
  (VTBL_ENTRY)&_ZN6S513C53v39Ev,
  (VTBL_ENTRY)&_ZN6S513C53v40Ev,
  (VTBL_ENTRY)&_ZN6S513C53v41Ev,
  (VTBL_ENTRY)&_ZN6S513C53v42Ev,
  (VTBL_ENTRY)&_ZN6S513C53v43Ev,
  (VTBL_ENTRY)&_ZN6S513C53v44Ev,
  (VTBL_ENTRY)&_ZN6S513C53v45Ev,
  (VTBL_ENTRY)&_ZN6S513C53v46Ev,
  (VTBL_ENTRY)&_ZN6S513C53v47Ev,
  (VTBL_ENTRY)&_ZN6S513C53v48Ev,
  (VTBL_ENTRY)&_ZN6S513C53v49Ev,
  (VTBL_ENTRY)&_ZN6S513C53v50Ev,
  (VTBL_ENTRY)&_ZN6S513C53v51Ev,
  (VTBL_ENTRY)&_ZN6S513C53v52Ev,
  (VTBL_ENTRY)&_ZN6S513C53v53Ev,
  (VTBL_ENTRY)&_ZN6S513C53v54Ev,
  (VTBL_ENTRY)&_ZN6S513C53v55Ev,
  (VTBL_ENTRY)&_ZN6S513C53v56Ev,
  (VTBL_ENTRY)&_ZN6S513C53v57Ev,
  (VTBL_ENTRY)&_ZN6S513C53v58Ev,
  (VTBL_ENTRY)&_ZN6S513C53v59Ev,
  (VTBL_ENTRY)&_ZN6S513C53v60Ev,
  (VTBL_ENTRY)&_ZN6S513C53v61Ev,
  (VTBL_ENTRY)&_ZN6S513C53v62Ev,
  (VTBL_ENTRY)&_ZN6S513C53v63Ev,
  (VTBL_ENTRY)&_ZN6S513C53v64Ev,
  (VTBL_ENTRY)&_ZN6S513C53v65Ev,
  (VTBL_ENTRY)&_ZN6S513C53v66Ev,
  (VTBL_ENTRY)&_ZN6S513C53v67Ev,
  (VTBL_ENTRY)&_ZN6S513C53v68Ev,
  (VTBL_ENTRY)&_ZN6S513C53v69Ev,
  (VTBL_ENTRY)&_ZN6S513C53v70Ev,
  (VTBL_ENTRY)&_ZN6S513C53v71Ev,
  (VTBL_ENTRY)&_ZN6S513C53v72Ev,
  (VTBL_ENTRY)&_ZN6S513C53v73Ev,
  (VTBL_ENTRY)&_ZN6S513C53v74Ev,
  (VTBL_ENTRY)&_ZN6S513C53v75Ev,
  (VTBL_ENTRY)&_ZN6S513C53v76Ev,
  (VTBL_ENTRY)&_ZN6S513C53v77Ev,
  (VTBL_ENTRY)&_ZN6S513C53v78Ev,
  (VTBL_ENTRY)&_ZN6S513C53v79Ev,
  (VTBL_ENTRY)&_ZN6S513C53v80Ev,
  (VTBL_ENTRY)&_ZN6S513C53v81Ev,
  (VTBL_ENTRY)&_ZN6S513C53v82Ev,
  (VTBL_ENTRY)&_ZN6S513C53v83Ev,
  (VTBL_ENTRY)&_ZN6S513C53v84Ev,
  (VTBL_ENTRY)&_ZN6S513C53v85Ev,
  (VTBL_ENTRY)&_ZN6S513C53v86Ev,
  (VTBL_ENTRY)&_ZN6S513C53v87Ev,
  (VTBL_ENTRY)&_ZN6S513C53v88Ev,
};
extern VTBL_ENTRY _ZTI6S513C5[];
extern  VTBL_ENTRY _ZTV6S513C5[];
Class_Descriptor cd_S513C5 = {  "S513C5", // class name
  0,0,//no base classes
  &(vtc_S513C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S513C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S513C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C4  : S513C5 {
  void *s513c4f0;
  ::S95C8_nt s513c4f1;
  virtual  ~S513C4(); // _ZN6S513C4D1Ev
  virtual void  v89(); // _ZN6S513C43v89Ev
  virtual void  v90(); // _ZN6S513C43v90Ev
  virtual void  v91(); // _ZN6S513C43v91Ev
  virtual void  v92(); // _ZN6S513C43v92Ev
  virtual void  v93(); // _ZN6S513C43v93Ev
  S513C4(); // tgen
};
//SIG(-1 S513C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S513C4 ::~S513C4(){ note_dtor("S513C4", this);}
void  S513C4 ::v89(){vfunc_called(this, "_ZN6S513C43v89Ev");}
void  S513C4 ::v90(){vfunc_called(this, "_ZN6S513C43v90Ev");}
void  S513C4 ::v91(){vfunc_called(this, "_ZN6S513C43v91Ev");}
void  S513C4 ::v92(){vfunc_called(this, "_ZN6S513C43v92Ev");}
void  S513C4 ::v93(){vfunc_called(this, "_ZN6S513C43v93Ev");}
S513C4 ::S513C4(){ note_ctor("S513C4", this);} // tgen

static void Test_S513C4()
{
  extern Class_Descriptor cd_S513C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S513C4, buf);
    S513C4 *dp, &lv = *(dp=new (buf) S513C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S513C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C4)");
    check_base_class_offset(lv, (S513C5*), 0, "S513C4");
    check_field_offset(lv, s513c4f0, ABISELECT(96,60), "S513C4.s513c4f0");
    check_field_offset(lv, s513c4f1, ABISELECT(104,64), "S513C4.s513c4f1");
    test_class_info(&lv, &cd_S513C4);
    dp->~S513C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS513C4(Test_S513C4, "S513C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S513C4C1Ev();
extern void _ZN6S513C4D1Ev();
Name_Map name_map_S513C4[] = {
  NSPAIR(_ZN6S513C4C1Ev),
  NSPAIR(_ZN6S513C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S513C5;
extern VTBL_ENTRY _ZTI6S513C5[];
extern  VTBL_ENTRY _ZTV6S513C5[];
static Base_Class bases_S513C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S513C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S513C4[];
extern void _ZN6S513C4D1Ev();
extern void _ZN6S513C4D0Ev();
extern void _ZN6S513C53v25Ev();
extern void _ZN6S513C53v26Ev();
extern void _ZN6S513C53v27Ev();
extern void _ZN6S513C53v28Ev();
extern void _ZN6S513C53v29Ev();
extern void _ZN6S513C53v30Ev();
extern void _ZN6S513C53v31Ev();
extern void _ZN6S513C53v32Ev();
extern void _ZN6S513C53v33Ev();
extern void _ZN6S513C53v34Ev();
extern void _ZN6S513C53v35Ev();
extern void _ZN6S513C53v36Ev();
extern void _ZN6S513C53v37Ev();
extern void _ZN6S513C53v38Ev();
extern void _ZN6S513C53v39Ev();
extern void _ZN6S513C53v40Ev();
extern void _ZN6S513C53v41Ev();
extern void _ZN6S513C53v42Ev();
extern void _ZN6S513C53v43Ev();
extern void _ZN6S513C53v44Ev();
extern void _ZN6S513C53v45Ev();
extern void _ZN6S513C53v46Ev();
extern void _ZN6S513C53v47Ev();
extern void _ZN6S513C53v48Ev();
extern void _ZN6S513C53v49Ev();
extern void _ZN6S513C53v50Ev();
extern void _ZN6S513C53v51Ev();
extern void _ZN6S513C53v52Ev();
extern void _ZN6S513C53v53Ev();
extern void _ZN6S513C53v54Ev();
extern void _ZN6S513C53v55Ev();
extern void _ZN6S513C53v56Ev();
extern void _ZN6S513C53v57Ev();
extern void _ZN6S513C53v58Ev();
extern void _ZN6S513C53v59Ev();
extern void _ZN6S513C53v60Ev();
extern void _ZN6S513C53v61Ev();
extern void _ZN6S513C53v62Ev();
extern void _ZN6S513C53v63Ev();
extern void _ZN6S513C53v64Ev();
extern void _ZN6S513C53v65Ev();
extern void _ZN6S513C53v66Ev();
extern void _ZN6S513C53v67Ev();
extern void _ZN6S513C53v68Ev();
extern void _ZN6S513C53v69Ev();
extern void _ZN6S513C53v70Ev();
extern void _ZN6S513C53v71Ev();
extern void _ZN6S513C53v72Ev();
extern void _ZN6S513C53v73Ev();
extern void _ZN6S513C53v74Ev();
extern void _ZN6S513C53v75Ev();
extern void _ZN6S513C53v76Ev();
extern void _ZN6S513C53v77Ev();
extern void _ZN6S513C53v78Ev();
extern void _ZN6S513C53v79Ev();
extern void _ZN6S513C53v80Ev();
extern void _ZN6S513C53v81Ev();
extern void _ZN6S513C53v82Ev();
extern void _ZN6S513C53v83Ev();
extern void _ZN6S513C53v84Ev();
extern void _ZN6S513C53v85Ev();
extern void _ZN6S513C53v86Ev();
extern void _ZN6S513C53v87Ev();
extern void _ZN6S513C53v88Ev();
extern void _ZN6S513C43v89Ev();
extern void _ZN6S513C43v90Ev();
extern void _ZN6S513C43v91Ev();
extern void _ZN6S513C43v92Ev();
extern void _ZN6S513C43v93Ev();
static  VTBL_ENTRY vtc_S513C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S513C4[0]),
  (VTBL_ENTRY)&_ZN6S513C4D1Ev,
  (VTBL_ENTRY)&_ZN6S513C4D0Ev,
  (VTBL_ENTRY)&_ZN6S513C53v25Ev,
  (VTBL_ENTRY)&_ZN6S513C53v26Ev,
  (VTBL_ENTRY)&_ZN6S513C53v27Ev,
  (VTBL_ENTRY)&_ZN6S513C53v28Ev,
  (VTBL_ENTRY)&_ZN6S513C53v29Ev,
  (VTBL_ENTRY)&_ZN6S513C53v30Ev,
  (VTBL_ENTRY)&_ZN6S513C53v31Ev,
  (VTBL_ENTRY)&_ZN6S513C53v32Ev,
  (VTBL_ENTRY)&_ZN6S513C53v33Ev,
  (VTBL_ENTRY)&_ZN6S513C53v34Ev,
  (VTBL_ENTRY)&_ZN6S513C53v35Ev,
  (VTBL_ENTRY)&_ZN6S513C53v36Ev,
  (VTBL_ENTRY)&_ZN6S513C53v37Ev,
  (VTBL_ENTRY)&_ZN6S513C53v38Ev,
  (VTBL_ENTRY)&_ZN6S513C53v39Ev,
  (VTBL_ENTRY)&_ZN6S513C53v40Ev,
  (VTBL_ENTRY)&_ZN6S513C53v41Ev,
  (VTBL_ENTRY)&_ZN6S513C53v42Ev,
  (VTBL_ENTRY)&_ZN6S513C53v43Ev,
  (VTBL_ENTRY)&_ZN6S513C53v44Ev,
  (VTBL_ENTRY)&_ZN6S513C53v45Ev,
  (VTBL_ENTRY)&_ZN6S513C53v46Ev,
  (VTBL_ENTRY)&_ZN6S513C53v47Ev,
  (VTBL_ENTRY)&_ZN6S513C53v48Ev,
  (VTBL_ENTRY)&_ZN6S513C53v49Ev,
  (VTBL_ENTRY)&_ZN6S513C53v50Ev,
  (VTBL_ENTRY)&_ZN6S513C53v51Ev,
  (VTBL_ENTRY)&_ZN6S513C53v52Ev,
  (VTBL_ENTRY)&_ZN6S513C53v53Ev,
  (VTBL_ENTRY)&_ZN6S513C53v54Ev,
  (VTBL_ENTRY)&_ZN6S513C53v55Ev,
  (VTBL_ENTRY)&_ZN6S513C53v56Ev,
  (VTBL_ENTRY)&_ZN6S513C53v57Ev,
  (VTBL_ENTRY)&_ZN6S513C53v58Ev,
  (VTBL_ENTRY)&_ZN6S513C53v59Ev,
  (VTBL_ENTRY)&_ZN6S513C53v60Ev,
  (VTBL_ENTRY)&_ZN6S513C53v61Ev,
  (VTBL_ENTRY)&_ZN6S513C53v62Ev,
  (VTBL_ENTRY)&_ZN6S513C53v63Ev,
  (VTBL_ENTRY)&_ZN6S513C53v64Ev,
  (VTBL_ENTRY)&_ZN6S513C53v65Ev,
  (VTBL_ENTRY)&_ZN6S513C53v66Ev,
  (VTBL_ENTRY)&_ZN6S513C53v67Ev,
  (VTBL_ENTRY)&_ZN6S513C53v68Ev,
  (VTBL_ENTRY)&_ZN6S513C53v69Ev,
  (VTBL_ENTRY)&_ZN6S513C53v70Ev,
  (VTBL_ENTRY)&_ZN6S513C53v71Ev,
  (VTBL_ENTRY)&_ZN6S513C53v72Ev,
  (VTBL_ENTRY)&_ZN6S513C53v73Ev,
  (VTBL_ENTRY)&_ZN6S513C53v74Ev,
  (VTBL_ENTRY)&_ZN6S513C53v75Ev,
  (VTBL_ENTRY)&_ZN6S513C53v76Ev,
  (VTBL_ENTRY)&_ZN6S513C53v77Ev,
  (VTBL_ENTRY)&_ZN6S513C53v78Ev,
  (VTBL_ENTRY)&_ZN6S513C53v79Ev,
  (VTBL_ENTRY)&_ZN6S513C53v80Ev,
  (VTBL_ENTRY)&_ZN6S513C53v81Ev,
  (VTBL_ENTRY)&_ZN6S513C53v82Ev,
  (VTBL_ENTRY)&_ZN6S513C53v83Ev,
  (VTBL_ENTRY)&_ZN6S513C53v84Ev,
  (VTBL_ENTRY)&_ZN6S513C53v85Ev,
  (VTBL_ENTRY)&_ZN6S513C53v86Ev,
  (VTBL_ENTRY)&_ZN6S513C53v87Ev,
  (VTBL_ENTRY)&_ZN6S513C53v88Ev,
  (VTBL_ENTRY)&_ZN6S513C43v89Ev,
  (VTBL_ENTRY)&_ZN6S513C43v90Ev,
  (VTBL_ENTRY)&_ZN6S513C43v91Ev,
  (VTBL_ENTRY)&_ZN6S513C43v92Ev,
  (VTBL_ENTRY)&_ZN6S513C43v93Ev,
};
extern VTBL_ENTRY _ZTI6S513C4[];
extern  VTBL_ENTRY _ZTV6S513C4[];
Class_Descriptor cd_S513C4 = {  "S513C4", // class name
  bases_S513C4, 1,
  &(vtc_S513C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S513C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S513C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C3  : S513C4 {
  void *s513c3f0[2];
  unsigned int s513c3f1:1;
  unsigned int s513c3f2:1;
  unsigned int s513c3f3:1;
  unsigned int s513c3f4:1;
  char s513c3f5;
  virtual  ~S513C3(); // _ZN6S513C3D1Ev
  virtual void  v94(); // _ZN6S513C33v94Ev
  virtual void  v95(); // _ZN6S513C33v95Ev
  virtual void  v96(); // _ZN6S513C33v96Ev
  virtual void  v97(); // _ZN6S513C33v97Ev
  virtual void  v98(); // _ZN6S513C33v98Ev
  virtual void  v99(); // _ZN6S513C33v99Ev
  virtual void  v100(); // _ZN6S513C34v100Ev
  virtual void  v101(); // _ZN6S513C34v101Ev
  virtual void  v102(); // _ZN6S513C34v102Ev
  virtual void  v103(); // _ZN6S513C34v103Ev
  virtual void  v104(); // _ZN6S513C34v104Ev
  virtual void  v105(); // _ZN6S513C34v105Ev
  virtual void  v106(); // _ZN6S513C34v106Ev
  virtual void  v107(); // _ZN6S513C34v107Ev
  virtual void  v108(); // _ZN6S513C34v108Ev
  virtual void  v109(); // _ZN6S513C34v109Ev
  virtual void  v110(); // _ZN6S513C34v110Ev
  virtual void  v111(); // _ZN6S513C34v111Ev
  virtual void  v112(); // _ZN6S513C34v112Ev
  virtual void  v113(); // _ZN6S513C34v113Ev
  virtual void  v114(); // _ZN6S513C34v114Ev
  virtual void  v115(); // _ZN6S513C34v115Ev
  S513C3(); // tgen
};
//SIG(-1 S513C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S513C3 ::~S513C3(){ note_dtor("S513C3", this);}
void  S513C3 ::v94(){vfunc_called(this, "_ZN6S513C33v94Ev");}
void  S513C3 ::v95(){vfunc_called(this, "_ZN6S513C33v95Ev");}
void  S513C3 ::v96(){vfunc_called(this, "_ZN6S513C33v96Ev");}
void  S513C3 ::v97(){vfunc_called(this, "_ZN6S513C33v97Ev");}
void  S513C3 ::v98(){vfunc_called(this, "_ZN6S513C33v98Ev");}
void  S513C3 ::v99(){vfunc_called(this, "_ZN6S513C33v99Ev");}
void  S513C3 ::v100(){vfunc_called(this, "_ZN6S513C34v100Ev");}
void  S513C3 ::v101(){vfunc_called(this, "_ZN6S513C34v101Ev");}
void  S513C3 ::v102(){vfunc_called(this, "_ZN6S513C34v102Ev");}
void  S513C3 ::v103(){vfunc_called(this, "_ZN6S513C34v103Ev");}
void  S513C3 ::v104(){vfunc_called(this, "_ZN6S513C34v104Ev");}
void  S513C3 ::v105(){vfunc_called(this, "_ZN6S513C34v105Ev");}
void  S513C3 ::v106(){vfunc_called(this, "_ZN6S513C34v106Ev");}
void  S513C3 ::v107(){vfunc_called(this, "_ZN6S513C34v107Ev");}
void  S513C3 ::v108(){vfunc_called(this, "_ZN6S513C34v108Ev");}
void  S513C3 ::v109(){vfunc_called(this, "_ZN6S513C34v109Ev");}
void  S513C3 ::v110(){vfunc_called(this, "_ZN6S513C34v110Ev");}
void  S513C3 ::v111(){vfunc_called(this, "_ZN6S513C34v111Ev");}
void  S513C3 ::v112(){vfunc_called(this, "_ZN6S513C34v112Ev");}
void  S513C3 ::v113(){vfunc_called(this, "_ZN6S513C34v113Ev");}
void  S513C3 ::v114(){vfunc_called(this, "_ZN6S513C34v114Ev");}
void  S513C3 ::v115(){vfunc_called(this, "_ZN6S513C34v115Ev");}
S513C3 ::S513C3(){ note_ctor("S513C3", this);} // tgen

static void Test_S513C3()
{
  extern Class_Descriptor cd_S513C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S513C3, buf);
    S513C3 *dp, &lv = *(dp=new (buf) S513C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S513C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C3)");
    check_base_class_offset(lv, (S513C5*)(S513C4*), 0, "S513C3");
    check_base_class_offset(lv, (S513C4*), 0, "S513C3");
    check_field_offset(lv, s513c3f0, ABISELECT(112,72), "S513C3.s513c3f0");
    set_bf_and_test(lv, s513c3f1, ABISELECT(128,80), 0, 1, 1, "S513C3");
    set_bf_and_test(lv, s513c3f2, ABISELECT(128,80), 1, 1, 1, "S513C3");
    set_bf_and_test(lv, s513c3f3, ABISELECT(128,80), 2, 1, 1, "S513C3");
    set_bf_and_test(lv, s513c3f4, ABISELECT(128,80), 3, 1, 1, "S513C3");
    check_field_offset(lv, s513c3f5, ABISELECT(129,81), "S513C3.s513c3f5");
    test_class_info(&lv, &cd_S513C3);
    dp->~S513C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS513C3(Test_S513C3, "S513C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S513C3C1Ev();
extern void _ZN6S513C3D1Ev();
Name_Map name_map_S513C3[] = {
  NSPAIR(_ZN6S513C3C1Ev),
  NSPAIR(_ZN6S513C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S513C5;
extern VTBL_ENTRY _ZTI6S513C5[];
extern  VTBL_ENTRY _ZTV6S513C5[];
extern Class_Descriptor cd_S513C4;
extern VTBL_ENTRY _ZTI6S513C4[];
extern  VTBL_ENTRY _ZTV6S513C4[];
static Base_Class bases_S513C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S513C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S513C3[];
extern void _ZN6S513C3D1Ev();
extern void _ZN6S513C3D0Ev();
extern void _ZN6S513C53v25Ev();
extern void _ZN6S513C53v26Ev();
extern void _ZN6S513C53v27Ev();
extern void _ZN6S513C53v28Ev();
extern void _ZN6S513C53v29Ev();
extern void _ZN6S513C53v30Ev();
extern void _ZN6S513C53v31Ev();
extern void _ZN6S513C53v32Ev();
extern void _ZN6S513C53v33Ev();
extern void _ZN6S513C53v34Ev();
extern void _ZN6S513C53v35Ev();
extern void _ZN6S513C53v36Ev();
extern void _ZN6S513C53v37Ev();
extern void _ZN6S513C53v38Ev();
extern void _ZN6S513C53v39Ev();
extern void _ZN6S513C53v40Ev();
extern void _ZN6S513C53v41Ev();
extern void _ZN6S513C53v42Ev();
extern void _ZN6S513C53v43Ev();
extern void _ZN6S513C53v44Ev();
extern void _ZN6S513C53v45Ev();
extern void _ZN6S513C53v46Ev();
extern void _ZN6S513C53v47Ev();
extern void _ZN6S513C53v48Ev();
extern void _ZN6S513C53v49Ev();
extern void _ZN6S513C53v50Ev();
extern void _ZN6S513C53v51Ev();
extern void _ZN6S513C53v52Ev();
extern void _ZN6S513C53v53Ev();
extern void _ZN6S513C53v54Ev();
extern void _ZN6S513C53v55Ev();
extern void _ZN6S513C53v56Ev();
extern void _ZN6S513C53v57Ev();
extern void _ZN6S513C53v58Ev();
extern void _ZN6S513C53v59Ev();
extern void _ZN6S513C53v60Ev();
extern void _ZN6S513C53v61Ev();
extern void _ZN6S513C53v62Ev();
extern void _ZN6S513C53v63Ev();
extern void _ZN6S513C53v64Ev();
extern void _ZN6S513C53v65Ev();
extern void _ZN6S513C53v66Ev();
extern void _ZN6S513C53v67Ev();
extern void _ZN6S513C53v68Ev();
extern void _ZN6S513C53v69Ev();
extern void _ZN6S513C53v70Ev();
extern void _ZN6S513C53v71Ev();
extern void _ZN6S513C53v72Ev();
extern void _ZN6S513C53v73Ev();
extern void _ZN6S513C53v74Ev();
extern void _ZN6S513C53v75Ev();
extern void _ZN6S513C53v76Ev();
extern void _ZN6S513C53v77Ev();
extern void _ZN6S513C53v78Ev();
extern void _ZN6S513C53v79Ev();
extern void _ZN6S513C53v80Ev();
extern void _ZN6S513C53v81Ev();
extern void _ZN6S513C53v82Ev();
extern void _ZN6S513C53v83Ev();
extern void _ZN6S513C53v84Ev();
extern void _ZN6S513C53v85Ev();
extern void _ZN6S513C53v86Ev();
extern void _ZN6S513C53v87Ev();
extern void _ZN6S513C53v88Ev();
extern void _ZN6S513C43v89Ev();
extern void _ZN6S513C43v90Ev();
extern void _ZN6S513C43v91Ev();
extern void _ZN6S513C43v92Ev();
extern void _ZN6S513C43v93Ev();
extern void _ZN6S513C33v94Ev();
extern void _ZN6S513C33v95Ev();
extern void _ZN6S513C33v96Ev();
extern void _ZN6S513C33v97Ev();
extern void _ZN6S513C33v98Ev();
extern void _ZN6S513C33v99Ev();
extern void _ZN6S513C34v100Ev();
extern void _ZN6S513C34v101Ev();
extern void _ZN6S513C34v102Ev();
extern void _ZN6S513C34v103Ev();
extern void _ZN6S513C34v104Ev();
extern void _ZN6S513C34v105Ev();
extern void _ZN6S513C34v106Ev();
extern void _ZN6S513C34v107Ev();
extern void _ZN6S513C34v108Ev();
extern void _ZN6S513C34v109Ev();
extern void _ZN6S513C34v110Ev();
extern void _ZN6S513C34v111Ev();
extern void _ZN6S513C34v112Ev();
extern void _ZN6S513C34v113Ev();
extern void _ZN6S513C34v114Ev();
extern void _ZN6S513C34v115Ev();
static  VTBL_ENTRY vtc_S513C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S513C3[0]),
  (VTBL_ENTRY)&_ZN6S513C3D1Ev,
  (VTBL_ENTRY)&_ZN6S513C3D0Ev,
  (VTBL_ENTRY)&_ZN6S513C53v25Ev,
  (VTBL_ENTRY)&_ZN6S513C53v26Ev,
  (VTBL_ENTRY)&_ZN6S513C53v27Ev,
  (VTBL_ENTRY)&_ZN6S513C53v28Ev,
  (VTBL_ENTRY)&_ZN6S513C53v29Ev,
  (VTBL_ENTRY)&_ZN6S513C53v30Ev,
  (VTBL_ENTRY)&_ZN6S513C53v31Ev,
  (VTBL_ENTRY)&_ZN6S513C53v32Ev,
  (VTBL_ENTRY)&_ZN6S513C53v33Ev,
  (VTBL_ENTRY)&_ZN6S513C53v34Ev,
  (VTBL_ENTRY)&_ZN6S513C53v35Ev,
  (VTBL_ENTRY)&_ZN6S513C53v36Ev,
  (VTBL_ENTRY)&_ZN6S513C53v37Ev,
  (VTBL_ENTRY)&_ZN6S513C53v38Ev,
  (VTBL_ENTRY)&_ZN6S513C53v39Ev,
  (VTBL_ENTRY)&_ZN6S513C53v40Ev,
  (VTBL_ENTRY)&_ZN6S513C53v41Ev,
  (VTBL_ENTRY)&_ZN6S513C53v42Ev,
  (VTBL_ENTRY)&_ZN6S513C53v43Ev,
  (VTBL_ENTRY)&_ZN6S513C53v44Ev,
  (VTBL_ENTRY)&_ZN6S513C53v45Ev,
  (VTBL_ENTRY)&_ZN6S513C53v46Ev,
  (VTBL_ENTRY)&_ZN6S513C53v47Ev,
  (VTBL_ENTRY)&_ZN6S513C53v48Ev,
  (VTBL_ENTRY)&_ZN6S513C53v49Ev,
  (VTBL_ENTRY)&_ZN6S513C53v50Ev,
  (VTBL_ENTRY)&_ZN6S513C53v51Ev,
  (VTBL_ENTRY)&_ZN6S513C53v52Ev,
  (VTBL_ENTRY)&_ZN6S513C53v53Ev,
  (VTBL_ENTRY)&_ZN6S513C53v54Ev,
  (VTBL_ENTRY)&_ZN6S513C53v55Ev,
  (VTBL_ENTRY)&_ZN6S513C53v56Ev,
  (VTBL_ENTRY)&_ZN6S513C53v57Ev,
  (VTBL_ENTRY)&_ZN6S513C53v58Ev,
  (VTBL_ENTRY)&_ZN6S513C53v59Ev,
  (VTBL_ENTRY)&_ZN6S513C53v60Ev,
  (VTBL_ENTRY)&_ZN6S513C53v61Ev,
  (VTBL_ENTRY)&_ZN6S513C53v62Ev,
  (VTBL_ENTRY)&_ZN6S513C53v63Ev,
  (VTBL_ENTRY)&_ZN6S513C53v64Ev,
  (VTBL_ENTRY)&_ZN6S513C53v65Ev,
  (VTBL_ENTRY)&_ZN6S513C53v66Ev,
  (VTBL_ENTRY)&_ZN6S513C53v67Ev,
  (VTBL_ENTRY)&_ZN6S513C53v68Ev,
  (VTBL_ENTRY)&_ZN6S513C53v69Ev,
  (VTBL_ENTRY)&_ZN6S513C53v70Ev,
  (VTBL_ENTRY)&_ZN6S513C53v71Ev,
  (VTBL_ENTRY)&_ZN6S513C53v72Ev,
  (VTBL_ENTRY)&_ZN6S513C53v73Ev,
  (VTBL_ENTRY)&_ZN6S513C53v74Ev,
  (VTBL_ENTRY)&_ZN6S513C53v75Ev,
  (VTBL_ENTRY)&_ZN6S513C53v76Ev,
  (VTBL_ENTRY)&_ZN6S513C53v77Ev,
  (VTBL_ENTRY)&_ZN6S513C53v78Ev,
  (VTBL_ENTRY)&_ZN6S513C53v79Ev,
  (VTBL_ENTRY)&_ZN6S513C53v80Ev,
  (VTBL_ENTRY)&_ZN6S513C53v81Ev,
  (VTBL_ENTRY)&_ZN6S513C53v82Ev,
  (VTBL_ENTRY)&_ZN6S513C53v83Ev,
  (VTBL_ENTRY)&_ZN6S513C53v84Ev,
  (VTBL_ENTRY)&_ZN6S513C53v85Ev,
  (VTBL_ENTRY)&_ZN6S513C53v86Ev,
  (VTBL_ENTRY)&_ZN6S513C53v87Ev,
  (VTBL_ENTRY)&_ZN6S513C53v88Ev,
  (VTBL_ENTRY)&_ZN6S513C43v89Ev,
  (VTBL_ENTRY)&_ZN6S513C43v90Ev,
  (VTBL_ENTRY)&_ZN6S513C43v91Ev,
  (VTBL_ENTRY)&_ZN6S513C43v92Ev,
  (VTBL_ENTRY)&_ZN6S513C43v93Ev,
  (VTBL_ENTRY)&_ZN6S513C33v94Ev,
  (VTBL_ENTRY)&_ZN6S513C33v95Ev,
  (VTBL_ENTRY)&_ZN6S513C33v96Ev,
  (VTBL_ENTRY)&_ZN6S513C33v97Ev,
  (VTBL_ENTRY)&_ZN6S513C33v98Ev,
  (VTBL_ENTRY)&_ZN6S513C33v99Ev,
  (VTBL_ENTRY)&_ZN6S513C34v100Ev,
  (VTBL_ENTRY)&_ZN6S513C34v101Ev,
  (VTBL_ENTRY)&_ZN6S513C34v102Ev,
  (VTBL_ENTRY)&_ZN6S513C34v103Ev,
  (VTBL_ENTRY)&_ZN6S513C34v104Ev,
  (VTBL_ENTRY)&_ZN6S513C34v105Ev,
  (VTBL_ENTRY)&_ZN6S513C34v106Ev,
  (VTBL_ENTRY)&_ZN6S513C34v107Ev,
  (VTBL_ENTRY)&_ZN6S513C34v108Ev,
  (VTBL_ENTRY)&_ZN6S513C34v109Ev,
  (VTBL_ENTRY)&_ZN6S513C34v110Ev,
  (VTBL_ENTRY)&_ZN6S513C34v111Ev,
  (VTBL_ENTRY)&_ZN6S513C34v112Ev,
  (VTBL_ENTRY)&_ZN6S513C34v113Ev,
  (VTBL_ENTRY)&_ZN6S513C34v114Ev,
  (VTBL_ENTRY)&_ZN6S513C34v115Ev,
};
extern VTBL_ENTRY _ZTI6S513C3[];
extern  VTBL_ENTRY _ZTV6S513C3[];
Class_Descriptor cd_S513C3 = {  "S513C3", // class name
  bases_S513C3, 2,
  &(vtc_S513C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S513C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S513C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C2  : S513C3 {
  void *s513c2f0;
  ::S95C9_nt s513c2f1;
  int s513c2f2;
  ::S236C15_nt s513c2f3;
  int s513c2f4;
  ::S490C27 s513c2f5;
  int s513c2f6;
  void *s513c2f7[2];
  ::S95C13 s513c2f8;
  void *s513c2f9;
  int s513c2f10[2];
  char s513c2f11[3];
  int s513c2f12;
  unsigned int s513c2f13:1;
  unsigned int s513c2f14:1;
  unsigned int s513c2f15:1;
  unsigned int s513c2f16:1;
  unsigned int s513c2f17:1;
  unsigned int s513c2f18:1;
  unsigned int s513c2f19:1;
  unsigned int s513c2f20:1;
  unsigned int s513c2f21:1;
  unsigned int s513c2f22:1;
  unsigned int s513c2f23:1;
  unsigned int s513c2f24:1;
  unsigned int s513c2f25:1;
  unsigned int s513c2f26:1;
  int s513c2f27;
  unsigned int s513c2f28:1;
  unsigned int s513c2f29:1;
  unsigned int s513c2f30:1;
  unsigned int s513c2f31:1;
  unsigned int s513c2f32:1;
  unsigned int s513c2f33:1;
  ::S112C22_nt s513c2f34;
  unsigned int s513c2f35:1;
  unsigned int s513c2f36:1;
  unsigned int s513c2f37:1;
  unsigned int s513c2f38:1;
  unsigned int s513c2f39:1;
  unsigned int s513c2f40:1;
  unsigned int s513c2f41:1;
  char s513c2f42;
  ::S95C16 s513c2f43;
  unsigned int s513c2f44:1;
  unsigned int s513c2f45:1;
  unsigned int s513c2f46:1;
  unsigned int s513c2f47:1;
  unsigned int s513c2f48:1;
  unsigned int s513c2f49:1;
  unsigned int s513c2f50:1;
  unsigned int s513c2f51:1;
  unsigned int s513c2f52:1;
  unsigned int s513c2f53:1;
  unsigned int s513c2f54:1;
  unsigned int s513c2f55:1;
  ::S490C26 s513c2f56;
  void *s513c2f57[2];
  char s513c2f58;
  ::S236C15_nt s513c2f59;
  ::S236C18_nt s513c2f60;
  ::S95C14_nt s513c2f61;
  int s513c2f62;
  ::S236C18_nt s513c2f63;
  unsigned int s513c2f64:1;
  unsigned int s513c2f65:1;
  unsigned int s513c2f66:1;
  int s513c2f67[3];
  virtual  ~S513C2(); // _ZN6S513C2D1Ev
  virtual void  v116(); // _ZN6S513C24v116Ev
  virtual void  v117(); // _ZN6S513C24v117Ev
  virtual void  v118(); // _ZN6S513C24v118Ev
  virtual void  v119(); // _ZN6S513C24v119Ev
  virtual void  v120(); // _ZN6S513C24v120Ev
  virtual void  v121(); // _ZN6S513C24v121Ev
  virtual void  v122(); // _ZN6S513C24v122Ev
  virtual void  v123(); // _ZN6S513C24v123Ev
  virtual void  v124(); // _ZN6S513C24v124Ev
  virtual void  v125(); // _ZN6S513C24v125Ev
  virtual void  v126(); // _ZN6S513C24v126Ev
  virtual void  v127(); // _ZN6S513C24v127Ev
  virtual void  v128(); // _ZN6S513C24v128Ev
  virtual void  v129(); // _ZN6S513C24v129Ev
  virtual void  v130(); // _ZN6S513C24v130Ev
  virtual void  v131(); // _ZN6S513C24v131Ev
  virtual void  v132(); // _ZN6S513C24v132Ev
  virtual void  v133(); // _ZN6S513C24v133Ev
  virtual void  v134(); // _ZN6S513C24v134Ev
  virtual void  v135(); // _ZN6S513C24v135Ev
  virtual void  v136(); // _ZN6S513C24v136Ev
  virtual void  v137(); // _ZN6S513C24v137Ev
  virtual void  v138(); // _ZN6S513C24v138Ev
  virtual void  v139(); // _ZN6S513C24v139Ev
  virtual void  v140(); // _ZN6S513C24v140Ev
  virtual void  v141(); // _ZN6S513C24v141Ev
  virtual void  v142(); // _ZN6S513C24v142Ev
  virtual void  v143(); // _ZN6S513C24v143Ev
  virtual void  v144(); // _ZN6S513C24v144Ev
  virtual void  v145(); // _ZN6S513C24v145Ev
  virtual void  v146(); // _ZN6S513C24v146Ev
  virtual void  v147(); // _ZN6S513C24v147Ev
  virtual void  v148(); // _ZN6S513C24v148Ev
  virtual void  v149(); // _ZN6S513C24v149Ev
  virtual void  v150(); // _ZN6S513C24v150Ev
  virtual void  v151(); // _ZN6S513C24v151Ev
  virtual void  v152(); // _ZN6S513C24v152Ev
  virtual void  v153(); // _ZN6S513C24v153Ev
  virtual void  v154(); // _ZN6S513C24v154Ev
  virtual void  v155(); // _ZN6S513C24v155Ev
  virtual void  v156(); // _ZN6S513C24v156Ev
  virtual void  v157(); // _ZN6S513C24v157Ev
  virtual void  v158(); // _ZN6S513C24v158Ev
  virtual void  v159(); // _ZN6S513C24v159Ev
  virtual void  v160(); // _ZN6S513C24v160Ev
  virtual void  v161(); // _ZN6S513C24v161Ev
  virtual void  v162(); // _ZN6S513C24v162Ev
  virtual void  v163(); // _ZN6S513C24v163Ev
  virtual void  v164(); // _ZN6S513C24v164Ev
  virtual void  v165(); // _ZN6S513C24v165Ev
  virtual void  v166(); // _ZN6S513C24v166Ev
  virtual void  v167(); // _ZN6S513C24v167Ev
  virtual void  v168(); // _ZN6S513C24v168Ev
  virtual void  v169(); // _ZN6S513C24v169Ev
  virtual void  v170(); // _ZN6S513C24v170Ev
  virtual void  v171(); // _ZN6S513C24v171Ev
  virtual void  v172(); // _ZN6S513C24v172Ev
  virtual void  v173(); // _ZN6S513C24v173Ev
  virtual void  v174(); // _ZN6S513C24v174Ev
  virtual void  v175(); // _ZN6S513C24v175Ev
  virtual void  v176(); // _ZN6S513C24v176Ev
  S513C2(); // tgen
};
//SIG(-1 S513C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S513C2 ::~S513C2(){ note_dtor("S513C2", this);}
void  S513C2 ::v116(){vfunc_called(this, "_ZN6S513C24v116Ev");}
void  S513C2 ::v117(){vfunc_called(this, "_ZN6S513C24v117Ev");}
void  S513C2 ::v118(){vfunc_called(this, "_ZN6S513C24v118Ev");}
void  S513C2 ::v119(){vfunc_called(this, "_ZN6S513C24v119Ev");}
void  S513C2 ::v120(){vfunc_called(this, "_ZN6S513C24v120Ev");}
void  S513C2 ::v121(){vfunc_called(this, "_ZN6S513C24v121Ev");}
void  S513C2 ::v122(){vfunc_called(this, "_ZN6S513C24v122Ev");}
void  S513C2 ::v123(){vfunc_called(this, "_ZN6S513C24v123Ev");}
void  S513C2 ::v124(){vfunc_called(this, "_ZN6S513C24v124Ev");}
void  S513C2 ::v125(){vfunc_called(this, "_ZN6S513C24v125Ev");}
void  S513C2 ::v126(){vfunc_called(this, "_ZN6S513C24v126Ev");}
void  S513C2 ::v127(){vfunc_called(this, "_ZN6S513C24v127Ev");}
void  S513C2 ::v128(){vfunc_called(this, "_ZN6S513C24v128Ev");}
void  S513C2 ::v129(){vfunc_called(this, "_ZN6S513C24v129Ev");}
void  S513C2 ::v130(){vfunc_called(this, "_ZN6S513C24v130Ev");}
void  S513C2 ::v131(){vfunc_called(this, "_ZN6S513C24v131Ev");}
void  S513C2 ::v132(){vfunc_called(this, "_ZN6S513C24v132Ev");}
void  S513C2 ::v133(){vfunc_called(this, "_ZN6S513C24v133Ev");}
void  S513C2 ::v134(){vfunc_called(this, "_ZN6S513C24v134Ev");}
void  S513C2 ::v135(){vfunc_called(this, "_ZN6S513C24v135Ev");}
void  S513C2 ::v136(){vfunc_called(this, "_ZN6S513C24v136Ev");}
void  S513C2 ::v137(){vfunc_called(this, "_ZN6S513C24v137Ev");}
void  S513C2 ::v138(){vfunc_called(this, "_ZN6S513C24v138Ev");}
void  S513C2 ::v139(){vfunc_called(this, "_ZN6S513C24v139Ev");}
void  S513C2 ::v140(){vfunc_called(this, "_ZN6S513C24v140Ev");}
void  S513C2 ::v141(){vfunc_called(this, "_ZN6S513C24v141Ev");}
void  S513C2 ::v142(){vfunc_called(this, "_ZN6S513C24v142Ev");}
void  S513C2 ::v143(){vfunc_called(this, "_ZN6S513C24v143Ev");}
void  S513C2 ::v144(){vfunc_called(this, "_ZN6S513C24v144Ev");}
void  S513C2 ::v145(){vfunc_called(this, "_ZN6S513C24v145Ev");}
void  S513C2 ::v146(){vfunc_called(this, "_ZN6S513C24v146Ev");}
void  S513C2 ::v147(){vfunc_called(this, "_ZN6S513C24v147Ev");}
void  S513C2 ::v148(){vfunc_called(this, "_ZN6S513C24v148Ev");}
void  S513C2 ::v149(){vfunc_called(this, "_ZN6S513C24v149Ev");}
void  S513C2 ::v150(){vfunc_called(this, "_ZN6S513C24v150Ev");}
void  S513C2 ::v151(){vfunc_called(this, "_ZN6S513C24v151Ev");}
void  S513C2 ::v152(){vfunc_called(this, "_ZN6S513C24v152Ev");}
void  S513C2 ::v153(){vfunc_called(this, "_ZN6S513C24v153Ev");}
void  S513C2 ::v154(){vfunc_called(this, "_ZN6S513C24v154Ev");}
void  S513C2 ::v155(){vfunc_called(this, "_ZN6S513C24v155Ev");}
void  S513C2 ::v156(){vfunc_called(this, "_ZN6S513C24v156Ev");}
void  S513C2 ::v157(){vfunc_called(this, "_ZN6S513C24v157Ev");}
void  S513C2 ::v158(){vfunc_called(this, "_ZN6S513C24v158Ev");}
void  S513C2 ::v159(){vfunc_called(this, "_ZN6S513C24v159Ev");}
void  S513C2 ::v160(){vfunc_called(this, "_ZN6S513C24v160Ev");}
void  S513C2 ::v161(){vfunc_called(this, "_ZN6S513C24v161Ev");}
void  S513C2 ::v162(){vfunc_called(this, "_ZN6S513C24v162Ev");}
void  S513C2 ::v163(){vfunc_called(this, "_ZN6S513C24v163Ev");}
void  S513C2 ::v164(){vfunc_called(this, "_ZN6S513C24v164Ev");}
void  S513C2 ::v165(){vfunc_called(this, "_ZN6S513C24v165Ev");}
void  S513C2 ::v166(){vfunc_called(this, "_ZN6S513C24v166Ev");}
void  S513C2 ::v167(){vfunc_called(this, "_ZN6S513C24v167Ev");}
void  S513C2 ::v168(){vfunc_called(this, "_ZN6S513C24v168Ev");}
void  S513C2 ::v169(){vfunc_called(this, "_ZN6S513C24v169Ev");}
void  S513C2 ::v170(){vfunc_called(this, "_ZN6S513C24v170Ev");}
void  S513C2 ::v171(){vfunc_called(this, "_ZN6S513C24v171Ev");}
void  S513C2 ::v172(){vfunc_called(this, "_ZN6S513C24v172Ev");}
void  S513C2 ::v173(){vfunc_called(this, "_ZN6S513C24v173Ev");}
void  S513C2 ::v174(){vfunc_called(this, "_ZN6S513C24v174Ev");}
void  S513C2 ::v175(){vfunc_called(this, "_ZN6S513C24v175Ev");}
void  S513C2 ::v176(){vfunc_called(this, "_ZN6S513C24v176Ev");}
S513C2 ::S513C2(){ note_ctor("S513C2", this);} // tgen

static void Test_S513C2()
{
  extern Class_Descriptor cd_S513C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S513C2, buf);
    S513C2 *dp, &lv = *(dp=new (buf) S513C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S513C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C2)");
    check_base_class_offset(lv, (S513C5*)(S513C4*)(S513C3*), 0, "S513C2");
    check_base_class_offset(lv, (S513C4*)(S513C3*), 0, "S513C2");
    check_base_class_offset(lv, (S513C3*), 0, "S513C2");
    check_field_offset(lv, s513c2f0, ABISELECT(136,84), "S513C2.s513c2f0");
    check_field_offset(lv, s513c2f1, ABISELECT(144,88), "S513C2.s513c2f1");
    check_field_offset(lv, s513c2f2, ABISELECT(148,92), "S513C2.s513c2f2");
    check_field_offset(lv, s513c2f3, ABISELECT(152,96), "S513C2.s513c2f3");
    check_field_offset(lv, s513c2f4, ABISELECT(156,100), "S513C2.s513c2f4");
    check_field_offset(lv, s513c2f5, ABISELECT(160,104), "S513C2.s513c2f5");
    check_field_offset(lv, s513c2f6, ABISELECT(176,116), "S513C2.s513c2f6");
    check_field_offset(lv, s513c2f7, ABISELECT(184,120), "S513C2.s513c2f7");
    check_field_offset(lv, s513c2f8, ABISELECT(200,128), "S513C2.s513c2f8");
    check_field_offset(lv, s513c2f9, ABISELECT(232,156), "S513C2.s513c2f9");
    check_field_offset(lv, s513c2f10, ABISELECT(240,160), "S513C2.s513c2f10");
    check_field_offset(lv, s513c2f11, ABISELECT(248,168), "S513C2.s513c2f11");
    check_field_offset(lv, s513c2f12, ABISELECT(252,172), "S513C2.s513c2f12");
    set_bf_and_test(lv, s513c2f13, ABISELECT(256,176), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f14, ABISELECT(256,176), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f15, ABISELECT(256,176), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f16, ABISELECT(256,176), 3, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f17, ABISELECT(256,176), 4, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f18, ABISELECT(256,176), 5, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f19, ABISELECT(256,176), 6, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f20, ABISELECT(256,176), 7, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f21, ABISELECT(257,177), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f22, ABISELECT(257,177), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f23, ABISELECT(257,177), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f24, ABISELECT(257,177), 3, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f25, ABISELECT(257,177), 4, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f26, ABISELECT(257,177), 5, 1, 1, "S513C2");
    check_field_offset(lv, s513c2f27, ABISELECT(260,180), "S513C2.s513c2f27");
    set_bf_and_test(lv, s513c2f28, ABISELECT(264,184), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f29, ABISELECT(264,184), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f30, ABISELECT(264,184), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f31, ABISELECT(264,184), 3, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f32, ABISELECT(264,184), 4, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f33, ABISELECT(264,184), 5, 1, 1, "S513C2");
    check_field_offset(lv, s513c2f34, ABISELECT(265,185), "S513C2.s513c2f34");
    set_bf_and_test(lv, s513c2f35, ABISELECT(266,186), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f36, ABISELECT(266,186), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f37, ABISELECT(266,186), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f38, ABISELECT(266,186), 3, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f39, ABISELECT(266,186), 4, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f40, ABISELECT(266,186), 5, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f41, ABISELECT(266,186), 6, 1, 1, "S513C2");
    check_field_offset(lv, s513c2f42, ABISELECT(267,187), "S513C2.s513c2f42");
    check_field_offset(lv, s513c2f43, ABISELECT(268,188), "S513C2.s513c2f43");
    set_bf_and_test(lv, s513c2f44, ABISELECT(269,189), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f45, ABISELECT(269,189), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f46, ABISELECT(269,189), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f47, ABISELECT(269,189), 3, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f48, ABISELECT(269,189), 4, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f49, ABISELECT(269,189), 5, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f50, ABISELECT(269,189), 6, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f51, ABISELECT(269,189), 7, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f52, ABISELECT(270,190), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f53, ABISELECT(270,190), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f54, ABISELECT(270,190), 2, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f55, ABISELECT(270,190), 3, 1, 1, "S513C2");
    check_field_offset(lv, s513c2f56, ABISELECT(272,192), "S513C2.s513c2f56");
    check_field_offset(lv, s513c2f57, ABISELECT(288,204), "S513C2.s513c2f57");
    check_field_offset(lv, s513c2f58, ABISELECT(304,212), "S513C2.s513c2f58");
    check_field_offset(lv, s513c2f59, ABISELECT(305,213), "S513C2.s513c2f59");
    check_field_offset(lv, s513c2f60, ABISELECT(308,216), "S513C2.s513c2f60");
    check_field_offset(lv, s513c2f61, ABISELECT(320,228), "S513C2.s513c2f61");
    check_field_offset(lv, s513c2f62, ABISELECT(332,240), "S513C2.s513c2f62");
    check_field_offset(lv, s513c2f63, ABISELECT(336,244), "S513C2.s513c2f63");
    set_bf_and_test(lv, s513c2f64, ABISELECT(348,256), 0, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f65, ABISELECT(348,256), 1, 1, 1, "S513C2");
    set_bf_and_test(lv, s513c2f66, ABISELECT(348,256), 2, 1, 1, "S513C2");
    check_field_offset(lv, s513c2f67, ABISELECT(352,260), "S513C2.s513c2f67");
    test_class_info(&lv, &cd_S513C2);
    dp->~S513C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS513C2(Test_S513C2, "S513C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S513C2C1Ev();
extern void _ZN6S513C2D1Ev();
Name_Map name_map_S513C2[] = {
  NSPAIR(_ZN6S513C2C1Ev),
  NSPAIR(_ZN6S513C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S513C5;
extern VTBL_ENTRY _ZTI6S513C5[];
extern  VTBL_ENTRY _ZTV6S513C5[];
extern Class_Descriptor cd_S513C4;
extern VTBL_ENTRY _ZTI6S513C4[];
extern  VTBL_ENTRY _ZTV6S513C4[];
extern Class_Descriptor cd_S513C3;
extern VTBL_ENTRY _ZTI6S513C3[];
extern  VTBL_ENTRY _ZTV6S513C3[];
static Base_Class bases_S513C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S513C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S513C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S513C2[];
extern void _ZN6S513C2D1Ev();
extern void _ZN6S513C2D0Ev();
extern void _ZN6S513C53v25Ev();
extern void _ZN6S513C53v26Ev();
extern void _ZN6S513C53v27Ev();
extern void _ZN6S513C53v28Ev();
extern void _ZN6S513C53v29Ev();
extern void _ZN6S513C53v30Ev();
extern void _ZN6S513C53v31Ev();
extern void _ZN6S513C53v32Ev();
extern void _ZN6S513C53v33Ev();
extern void _ZN6S513C53v34Ev();
extern void _ZN6S513C53v35Ev();
extern void _ZN6S513C53v36Ev();
extern void _ZN6S513C53v37Ev();
extern void _ZN6S513C53v38Ev();
extern void _ZN6S513C53v39Ev();
extern void _ZN6S513C53v40Ev();
extern void _ZN6S513C53v41Ev();
extern void _ZN6S513C53v42Ev();
extern void _ZN6S513C53v43Ev();
extern void _ZN6S513C53v44Ev();
extern void _ZN6S513C53v45Ev();
extern void _ZN6S513C53v46Ev();
extern void _ZN6S513C53v47Ev();
extern void _ZN6S513C53v48Ev();
extern void _ZN6S513C53v49Ev();
extern void _ZN6S513C53v50Ev();
extern void _ZN6S513C53v51Ev();
extern void _ZN6S513C53v52Ev();
extern void _ZN6S513C53v53Ev();
extern void _ZN6S513C53v54Ev();
extern void _ZN6S513C53v55Ev();
extern void _ZN6S513C53v56Ev();
extern void _ZN6S513C53v57Ev();
extern void _ZN6S513C53v58Ev();
extern void _ZN6S513C53v59Ev();
extern void _ZN6S513C53v60Ev();
extern void _ZN6S513C53v61Ev();
extern void _ZN6S513C53v62Ev();
extern void _ZN6S513C53v63Ev();
extern void _ZN6S513C53v64Ev();
extern void _ZN6S513C53v65Ev();
extern void _ZN6S513C53v66Ev();
extern void _ZN6S513C53v67Ev();
extern void _ZN6S513C53v68Ev();
extern void _ZN6S513C53v69Ev();
extern void _ZN6S513C53v70Ev();
extern void _ZN6S513C53v71Ev();
extern void _ZN6S513C53v72Ev();
extern void _ZN6S513C53v73Ev();
extern void _ZN6S513C53v74Ev();
extern void _ZN6S513C53v75Ev();
extern void _ZN6S513C53v76Ev();
extern void _ZN6S513C53v77Ev();
extern void _ZN6S513C53v78Ev();
extern void _ZN6S513C53v79Ev();
extern void _ZN6S513C53v80Ev();
extern void _ZN6S513C53v81Ev();
extern void _ZN6S513C53v82Ev();
extern void _ZN6S513C53v83Ev();
extern void _ZN6S513C53v84Ev();
extern void _ZN6S513C53v85Ev();
extern void _ZN6S513C53v86Ev();
extern void _ZN6S513C53v87Ev();
extern void _ZN6S513C53v88Ev();
extern void _ZN6S513C43v89Ev();
extern void _ZN6S513C43v90Ev();
extern void _ZN6S513C43v91Ev();
extern void _ZN6S513C43v92Ev();
extern void _ZN6S513C43v93Ev();
extern void _ZN6S513C33v94Ev();
extern void _ZN6S513C33v95Ev();
extern void _ZN6S513C33v96Ev();
extern void _ZN6S513C33v97Ev();
extern void _ZN6S513C33v98Ev();
extern void _ZN6S513C33v99Ev();
extern void _ZN6S513C34v100Ev();
extern void _ZN6S513C34v101Ev();
extern void _ZN6S513C34v102Ev();
extern void _ZN6S513C34v103Ev();
extern void _ZN6S513C34v104Ev();
extern void _ZN6S513C34v105Ev();
extern void _ZN6S513C34v106Ev();
extern void _ZN6S513C34v107Ev();
extern void _ZN6S513C34v108Ev();
extern void _ZN6S513C34v109Ev();
extern void _ZN6S513C34v110Ev();
extern void _ZN6S513C34v111Ev();
extern void _ZN6S513C34v112Ev();
extern void _ZN6S513C34v113Ev();
extern void _ZN6S513C34v114Ev();
extern void _ZN6S513C34v115Ev();
extern void _ZN6S513C24v116Ev();
extern void _ZN6S513C24v117Ev();
extern void _ZN6S513C24v118Ev();
extern void _ZN6S513C24v119Ev();
extern void _ZN6S513C24v120Ev();
extern void _ZN6S513C24v121Ev();
extern void _ZN6S513C24v122Ev();
extern void _ZN6S513C24v123Ev();
extern void _ZN6S513C24v124Ev();
extern void _ZN6S513C24v125Ev();
extern void _ZN6S513C24v126Ev();
extern void _ZN6S513C24v127Ev();
extern void _ZN6S513C24v128Ev();
extern void _ZN6S513C24v129Ev();
extern void _ZN6S513C24v130Ev();
extern void _ZN6S513C24v131Ev();
extern void _ZN6S513C24v132Ev();
extern void _ZN6S513C24v133Ev();
extern void _ZN6S513C24v134Ev();
extern void _ZN6S513C24v135Ev();
extern void _ZN6S513C24v136Ev();
extern void _ZN6S513C24v137Ev();
extern void _ZN6S513C24v138Ev();
extern void _ZN6S513C24v139Ev();
extern void _ZN6S513C24v140Ev();
extern void _ZN6S513C24v141Ev();
extern void _ZN6S513C24v142Ev();
extern void _ZN6S513C24v143Ev();
extern void _ZN6S513C24v144Ev();
extern void _ZN6S513C24v145Ev();
extern void _ZN6S513C24v146Ev();
extern void _ZN6S513C24v147Ev();
extern void _ZN6S513C24v148Ev();
extern void _ZN6S513C24v149Ev();
extern void _ZN6S513C24v150Ev();
extern void _ZN6S513C24v151Ev();
extern void _ZN6S513C24v152Ev();
extern void _ZN6S513C24v153Ev();
extern void _ZN6S513C24v154Ev();
extern void _ZN6S513C24v155Ev();
extern void _ZN6S513C24v156Ev();
extern void _ZN6S513C24v157Ev();
extern void _ZN6S513C24v158Ev();
extern void _ZN6S513C24v159Ev();
extern void _ZN6S513C24v160Ev();
extern void _ZN6S513C24v161Ev();
extern void _ZN6S513C24v162Ev();
extern void _ZN6S513C24v163Ev();
extern void _ZN6S513C24v164Ev();
extern void _ZN6S513C24v165Ev();
extern void _ZN6S513C24v166Ev();
extern void _ZN6S513C24v167Ev();
extern void _ZN6S513C24v168Ev();
extern void _ZN6S513C24v169Ev();
extern void _ZN6S513C24v170Ev();
extern void _ZN6S513C24v171Ev();
extern void _ZN6S513C24v172Ev();
extern void _ZN6S513C24v173Ev();
extern void _ZN6S513C24v174Ev();
extern void _ZN6S513C24v175Ev();
extern void _ZN6S513C24v176Ev();
static  VTBL_ENTRY vtc_S513C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S513C2[0]),
  (VTBL_ENTRY)&_ZN6S513C2D1Ev,
  (VTBL_ENTRY)&_ZN6S513C2D0Ev,
  (VTBL_ENTRY)&_ZN6S513C53v25Ev,
  (VTBL_ENTRY)&_ZN6S513C53v26Ev,
  (VTBL_ENTRY)&_ZN6S513C53v27Ev,
  (VTBL_ENTRY)&_ZN6S513C53v28Ev,
  (VTBL_ENTRY)&_ZN6S513C53v29Ev,
  (VTBL_ENTRY)&_ZN6S513C53v30Ev,
  (VTBL_ENTRY)&_ZN6S513C53v31Ev,
  (VTBL_ENTRY)&_ZN6S513C53v32Ev,
  (VTBL_ENTRY)&_ZN6S513C53v33Ev,
  (VTBL_ENTRY)&_ZN6S513C53v34Ev,
  (VTBL_ENTRY)&_ZN6S513C53v35Ev,
  (VTBL_ENTRY)&_ZN6S513C53v36Ev,
  (VTBL_ENTRY)&_ZN6S513C53v37Ev,
  (VTBL_ENTRY)&_ZN6S513C53v38Ev,
  (VTBL_ENTRY)&_ZN6S513C53v39Ev,
  (VTBL_ENTRY)&_ZN6S513C53v40Ev,
  (VTBL_ENTRY)&_ZN6S513C53v41Ev,
  (VTBL_ENTRY)&_ZN6S513C53v42Ev,
  (VTBL_ENTRY)&_ZN6S513C53v43Ev,
  (VTBL_ENTRY)&_ZN6S513C53v44Ev,
  (VTBL_ENTRY)&_ZN6S513C53v45Ev,
  (VTBL_ENTRY)&_ZN6S513C53v46Ev,
  (VTBL_ENTRY)&_ZN6S513C53v47Ev,
  (VTBL_ENTRY)&_ZN6S513C53v48Ev,
  (VTBL_ENTRY)&_ZN6S513C53v49Ev,
  (VTBL_ENTRY)&_ZN6S513C53v50Ev,
  (VTBL_ENTRY)&_ZN6S513C53v51Ev,
  (VTBL_ENTRY)&_ZN6S513C53v52Ev,
  (VTBL_ENTRY)&_ZN6S513C53v53Ev,
  (VTBL_ENTRY)&_ZN6S513C53v54Ev,
  (VTBL_ENTRY)&_ZN6S513C53v55Ev,
  (VTBL_ENTRY)&_ZN6S513C53v56Ev,
  (VTBL_ENTRY)&_ZN6S513C53v57Ev,
  (VTBL_ENTRY)&_ZN6S513C53v58Ev,
  (VTBL_ENTRY)&_ZN6S513C53v59Ev,
  (VTBL_ENTRY)&_ZN6S513C53v60Ev,
  (VTBL_ENTRY)&_ZN6S513C53v61Ev,
  (VTBL_ENTRY)&_ZN6S513C53v62Ev,
  (VTBL_ENTRY)&_ZN6S513C53v63Ev,
  (VTBL_ENTRY)&_ZN6S513C53v64Ev,
  (VTBL_ENTRY)&_ZN6S513C53v65Ev,
  (VTBL_ENTRY)&_ZN6S513C53v66Ev,
  (VTBL_ENTRY)&_ZN6S513C53v67Ev,
  (VTBL_ENTRY)&_ZN6S513C53v68Ev,
  (VTBL_ENTRY)&_ZN6S513C53v69Ev,
  (VTBL_ENTRY)&_ZN6S513C53v70Ev,
  (VTBL_ENTRY)&_ZN6S513C53v71Ev,
  (VTBL_ENTRY)&_ZN6S513C53v72Ev,
  (VTBL_ENTRY)&_ZN6S513C53v73Ev,
  (VTBL_ENTRY)&_ZN6S513C53v74Ev,
  (VTBL_ENTRY)&_ZN6S513C53v75Ev,
  (VTBL_ENTRY)&_ZN6S513C53v76Ev,
  (VTBL_ENTRY)&_ZN6S513C53v77Ev,
  (VTBL_ENTRY)&_ZN6S513C53v78Ev,
  (VTBL_ENTRY)&_ZN6S513C53v79Ev,
  (VTBL_ENTRY)&_ZN6S513C53v80Ev,
  (VTBL_ENTRY)&_ZN6S513C53v81Ev,
  (VTBL_ENTRY)&_ZN6S513C53v82Ev,
  (VTBL_ENTRY)&_ZN6S513C53v83Ev,
  (VTBL_ENTRY)&_ZN6S513C53v84Ev,
  (VTBL_ENTRY)&_ZN6S513C53v85Ev,
  (VTBL_ENTRY)&_ZN6S513C53v86Ev,
  (VTBL_ENTRY)&_ZN6S513C53v87Ev,
  (VTBL_ENTRY)&_ZN6S513C53v88Ev,
  (VTBL_ENTRY)&_ZN6S513C43v89Ev,
  (VTBL_ENTRY)&_ZN6S513C43v90Ev,
  (VTBL_ENTRY)&_ZN6S513C43v91Ev,
  (VTBL_ENTRY)&_ZN6S513C43v92Ev,
  (VTBL_ENTRY)&_ZN6S513C43v93Ev,
  (VTBL_ENTRY)&_ZN6S513C33v94Ev,
  (VTBL_ENTRY)&_ZN6S513C33v95Ev,
  (VTBL_ENTRY)&_ZN6S513C33v96Ev,
  (VTBL_ENTRY)&_ZN6S513C33v97Ev,
  (VTBL_ENTRY)&_ZN6S513C33v98Ev,
  (VTBL_ENTRY)&_ZN6S513C33v99Ev,
  (VTBL_ENTRY)&_ZN6S513C34v100Ev,
  (VTBL_ENTRY)&_ZN6S513C34v101Ev,
  (VTBL_ENTRY)&_ZN6S513C34v102Ev,
  (VTBL_ENTRY)&_ZN6S513C34v103Ev,
  (VTBL_ENTRY)&_ZN6S513C34v104Ev,
  (VTBL_ENTRY)&_ZN6S513C34v105Ev,
  (VTBL_ENTRY)&_ZN6S513C34v106Ev,
  (VTBL_ENTRY)&_ZN6S513C34v107Ev,
  (VTBL_ENTRY)&_ZN6S513C34v108Ev,
  (VTBL_ENTRY)&_ZN6S513C34v109Ev,
  (VTBL_ENTRY)&_ZN6S513C34v110Ev,
  (VTBL_ENTRY)&_ZN6S513C34v111Ev,
  (VTBL_ENTRY)&_ZN6S513C34v112Ev,
  (VTBL_ENTRY)&_ZN6S513C34v113Ev,
  (VTBL_ENTRY)&_ZN6S513C34v114Ev,
  (VTBL_ENTRY)&_ZN6S513C34v115Ev,
  (VTBL_ENTRY)&_ZN6S513C24v116Ev,
  (VTBL_ENTRY)&_ZN6S513C24v117Ev,
  (VTBL_ENTRY)&_ZN6S513C24v118Ev,
  (VTBL_ENTRY)&_ZN6S513C24v119Ev,
  (VTBL_ENTRY)&_ZN6S513C24v120Ev,
  (VTBL_ENTRY)&_ZN6S513C24v121Ev,
  (VTBL_ENTRY)&_ZN6S513C24v122Ev,
  (VTBL_ENTRY)&_ZN6S513C24v123Ev,
  (VTBL_ENTRY)&_ZN6S513C24v124Ev,
  (VTBL_ENTRY)&_ZN6S513C24v125Ev,
  (VTBL_ENTRY)&_ZN6S513C24v126Ev,
  (VTBL_ENTRY)&_ZN6S513C24v127Ev,
  (VTBL_ENTRY)&_ZN6S513C24v128Ev,
  (VTBL_ENTRY)&_ZN6S513C24v129Ev,
  (VTBL_ENTRY)&_ZN6S513C24v130Ev,
  (VTBL_ENTRY)&_ZN6S513C24v131Ev,
  (VTBL_ENTRY)&_ZN6S513C24v132Ev,
  (VTBL_ENTRY)&_ZN6S513C24v133Ev,
  (VTBL_ENTRY)&_ZN6S513C24v134Ev,
  (VTBL_ENTRY)&_ZN6S513C24v135Ev,
  (VTBL_ENTRY)&_ZN6S513C24v136Ev,
  (VTBL_ENTRY)&_ZN6S513C24v137Ev,
  (VTBL_ENTRY)&_ZN6S513C24v138Ev,
  (VTBL_ENTRY)&_ZN6S513C24v139Ev,
  (VTBL_ENTRY)&_ZN6S513C24v140Ev,
  (VTBL_ENTRY)&_ZN6S513C24v141Ev,
  (VTBL_ENTRY)&_ZN6S513C24v142Ev,
  (VTBL_ENTRY)&_ZN6S513C24v143Ev,
  (VTBL_ENTRY)&_ZN6S513C24v144Ev,
  (VTBL_ENTRY)&_ZN6S513C24v145Ev,
  (VTBL_ENTRY)&_ZN6S513C24v146Ev,
  (VTBL_ENTRY)&_ZN6S513C24v147Ev,
  (VTBL_ENTRY)&_ZN6S513C24v148Ev,
  (VTBL_ENTRY)&_ZN6S513C24v149Ev,
  (VTBL_ENTRY)&_ZN6S513C24v150Ev,
  (VTBL_ENTRY)&_ZN6S513C24v151Ev,
  (VTBL_ENTRY)&_ZN6S513C24v152Ev,
  (VTBL_ENTRY)&_ZN6S513C24v153Ev,
  (VTBL_ENTRY)&_ZN6S513C24v154Ev,
  (VTBL_ENTRY)&_ZN6S513C24v155Ev,
  (VTBL_ENTRY)&_ZN6S513C24v156Ev,
  (VTBL_ENTRY)&_ZN6S513C24v157Ev,
  (VTBL_ENTRY)&_ZN6S513C24v158Ev,
  (VTBL_ENTRY)&_ZN6S513C24v159Ev,
  (VTBL_ENTRY)&_ZN6S513C24v160Ev,
  (VTBL_ENTRY)&_ZN6S513C24v161Ev,
  (VTBL_ENTRY)&_ZN6S513C24v162Ev,
  (VTBL_ENTRY)&_ZN6S513C24v163Ev,
  (VTBL_ENTRY)&_ZN6S513C24v164Ev,
  (VTBL_ENTRY)&_ZN6S513C24v165Ev,
  (VTBL_ENTRY)&_ZN6S513C24v166Ev,
  (VTBL_ENTRY)&_ZN6S513C24v167Ev,
  (VTBL_ENTRY)&_ZN6S513C24v168Ev,
  (VTBL_ENTRY)&_ZN6S513C24v169Ev,
  (VTBL_ENTRY)&_ZN6S513C24v170Ev,
  (VTBL_ENTRY)&_ZN6S513C24v171Ev,
  (VTBL_ENTRY)&_ZN6S513C24v172Ev,
  (VTBL_ENTRY)&_ZN6S513C24v173Ev,
  (VTBL_ENTRY)&_ZN6S513C24v174Ev,
  (VTBL_ENTRY)&_ZN6S513C24v175Ev,
  (VTBL_ENTRY)&_ZN6S513C24v176Ev,
};
extern VTBL_ENTRY _ZTI6S513C2[];
extern  VTBL_ENTRY _ZTV6S513C2[];
Class_Descriptor cd_S513C2 = {  "S513C2", // class name
  bases_S513C2, 3,
  &(vtc_S513C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S513C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S513C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C20_nt  {
  void *s513c20f0;
  void  mf513c20(); // _ZN10S513C20_nt8mf513c20Ev
};
//SIG(-1 S513C20_nt) C1{ m Fp}


void  S513C20_nt ::mf513c20(){}

//skip512 S513C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C24  {
  ::S95C26 s513c24f0;
  void  mf513c24(); // _ZN7S513C248mf513c24Ev
};
//SIG(-1 S513C24) C1{ m FC2{ BC3{ m Fp Fi[2]}}}


void  S513C24 ::mf513c24(){}

static void Test_S513C24()
{
  {
    init_simple_test("S513C24");
    S513C24 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S513C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C24)");
    check_field_offset(lv, s513c24f0, 0, "S513C24.s513c24f0");
  }
}
static Arrange_To_Call_Me vS513C24(Test_S513C24, "S513C24", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S513C1  : S513C2 {
  ::S236C26 s513c1f0;
  ::S95C38 s513c1f1;
  void *s513c1f2;
  int s513c1f3[6];
  ::S513C20_nt s513c1f4;
  ::S95C36 s513c1f5;
  ::S95C32 s513c1f6;
  ::S95C28 s513c1f7;
  int s513c1f8;
  void *s513c1f9[5];
  ::S513C24 s513c1f10;
  ::S95C24 s513c1f11;
  void *s513c1f12;
  int s513c1f13;
  virtual  ~S513C1(); // _ZN6S513C1D1Ev
  virtual void  v1(); // _ZN6S513C12v1Ev
  virtual void  v2(); // _ZN6S513C12v2Ev
  virtual void  v3(); // _ZN6S513C12v3Ev
  virtual void  v4(); // _ZN6S513C12v4Ev
  virtual void  v5(); // _ZN6S513C12v5Ev
  virtual void  v6(); // _ZN6S513C12v6Ev
  virtual void  v7(); // _ZN6S513C12v7Ev
  virtual void  v8(); // _ZN6S513C12v8Ev
  virtual void  v9(); // _ZN6S513C12v9Ev
  virtual void  v10(); // _ZN6S513C13v10Ev
  virtual void  v11(); // _ZN6S513C13v11Ev
  virtual void  v12(); // _ZN6S513C13v12Ev
  virtual void  v13(); // _ZN6S513C13v13Ev
  virtual void  v14(); // _ZN6S513C13v14Ev
  virtual void  v15(); // _ZN6S513C13v15Ev
  virtual void  v16(); // _ZN6S513C13v16Ev
  virtual void  v17(); // _ZN6S513C13v17Ev
  virtual void  v18(); // _ZN6S513C13v18Ev
  virtual void  v19(); // _ZN6S513C13v19Ev
  virtual void  v20(); // _ZN6S513C13v20Ev
  virtual void  v21(); // _ZN6S513C13v21Ev
  virtual void  v22(); // _ZN6S513C13v22Ev
  virtual void  v23(); // _ZN6S513C13v23Ev
  virtual void  v24(); // _ZN6S513C13v24Ev
  S513C1(); // tgen
};
//SIG(1 S513C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v89 v90 v91 v92 v93 Fp FC6} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 FC17{ BC10} FC18{ BC10} Fp Fi[6] FC19{ m Fp} FC20{ BC10} FC21{ BC10} FC22{ BC10} Fi Fp[5] FC23{ m FC24{ BC10}} FC25{ BC10} Fp Fi}


 S513C1 ::~S513C1(){ note_dtor("S513C1", this);}
void  S513C1 ::v1(){vfunc_called(this, "_ZN6S513C12v1Ev");}
void  S513C1 ::v2(){vfunc_called(this, "_ZN6S513C12v2Ev");}
void  S513C1 ::v3(){vfunc_called(this, "_ZN6S513C12v3Ev");}
void  S513C1 ::v4(){vfunc_called(this, "_ZN6S513C12v4Ev");}
void  S513C1 ::v5(){vfunc_called(this, "_ZN6S513C12v5Ev");}
void  S513C1 ::v6(){vfunc_called(this, "_ZN6S513C12v6Ev");}
void  S513C1 ::v7(){vfunc_called(this, "_ZN6S513C12v7Ev");}
void  S513C1 ::v8(){vfunc_called(this, "_ZN6S513C12v8Ev");}
void  S513C1 ::v9(){vfunc_called(this, "_ZN6S513C12v9Ev");}
void  S513C1 ::v10(){vfunc_called(this, "_ZN6S513C13v10Ev");}
void  S513C1 ::v11(){vfunc_called(this, "_ZN6S513C13v11Ev");}
void  S513C1 ::v12(){vfunc_called(this, "_ZN6S513C13v12Ev");}
void  S513C1 ::v13(){vfunc_called(this, "_ZN6S513C13v13Ev");}
void  S513C1 ::v14(){vfunc_called(this, "_ZN6S513C13v14Ev");}
void  S513C1 ::v15(){vfunc_called(this, "_ZN6S513C13v15Ev");}
void  S513C1 ::v16(){vfunc_called(this, "_ZN6S513C13v16Ev");}
void  S513C1 ::v17(){vfunc_called(this, "_ZN6S513C13v17Ev");}
void  S513C1 ::v18(){vfunc_called(this, "_ZN6S513C13v18Ev");}
void  S513C1 ::v19(){vfunc_called(this, "_ZN6S513C13v19Ev");}
void  S513C1 ::v20(){vfunc_called(this, "_ZN6S513C13v20Ev");}
void  S513C1 ::v21(){vfunc_called(this, "_ZN6S513C13v21Ev");}
void  S513C1 ::v22(){vfunc_called(this, "_ZN6S513C13v22Ev");}
void  S513C1 ::v23(){vfunc_called(this, "_ZN6S513C13v23Ev");}
void  S513C1 ::v24(){vfunc_called(this, "_ZN6S513C13v24Ev");}
S513C1 ::S513C1(){ note_ctor("S513C1", this);} // tgen

static void Test_S513C1()
{
  extern Class_Descriptor cd_S513C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(74,106)];
    init_test(&cd_S513C1, buf);
    S513C1 *dp, &lv = *(dp=new (buf) S513C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(584,420), "sizeof(S513C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S513C1)");
    check_base_class_offset(lv, (S513C5*)(S513C4*)(S513C3*)(S513C2*), 0, "S513C1");
    check_base_class_offset(lv, (S513C4*)(S513C3*)(S513C2*), 0, "S513C1");
    check_base_class_offset(lv, (S513C3*)(S513C2*), 0, "S513C1");
    check_base_class_offset(lv, (S513C2*), 0, "S513C1");
    check_field_offset(lv, s513c1f0, ABISELECT(368,272), "S513C1.s513c1f0");
    check_field_offset(lv, s513c1f1, ABISELECT(384,284), "S513C1.s513c1f1");
    check_field_offset(lv, s513c1f2, ABISELECT(400,296), "S513C1.s513c1f2");
    check_field_offset(lv, s513c1f3, ABISELECT(408,300), "S513C1.s513c1f3");
    check_field_offset(lv, s513c1f4, ABISELECT(432,324), "S513C1.s513c1f4");
    check_field_offset(lv, s513c1f5, ABISELECT(440,328), "S513C1.s513c1f5");
    check_field_offset(lv, s513c1f6, ABISELECT(456,340), "S513C1.s513c1f6");
    check_field_offset(lv, s513c1f7, ABISELECT(472,352), "S513C1.s513c1f7");
    check_field_offset(lv, s513c1f8, ABISELECT(488,364), "S513C1.s513c1f8");
    check_field_offset(lv, s513c1f9, ABISELECT(496,368), "S513C1.s513c1f9");
    check_field_offset(lv, s513c1f10, ABISELECT(536,388), "S513C1.s513c1f10");
    check_field_offset(lv, s513c1f11, ABISELECT(552,400), "S513C1.s513c1f11");
    check_field_offset(lv, s513c1f12, ABISELECT(568,412), "S513C1.s513c1f12");
    check_field_offset(lv, s513c1f13, ABISELECT(576,416), "S513C1.s513c1f13");
    test_class_info(&lv, &cd_S513C1);
    dp->~S513C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS513C1(Test_S513C1, "S513C1", ABISELECT(584,420));

#else // __cplusplus

extern void _ZN6S513C1C1Ev();
extern void _ZN6S513C1D1Ev();
Name_Map name_map_S513C1[] = {
  NSPAIR(_ZN6S513C1C1Ev),
  NSPAIR(_ZN6S513C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S513C5;
extern VTBL_ENTRY _ZTI6S513C5[];
extern  VTBL_ENTRY _ZTV6S513C5[];
extern Class_Descriptor cd_S513C4;
extern VTBL_ENTRY _ZTI6S513C4[];
extern  VTBL_ENTRY _ZTV6S513C4[];
extern Class_Descriptor cd_S513C3;
extern VTBL_ENTRY _ZTI6S513C3[];
extern  VTBL_ENTRY _ZTV6S513C3[];
extern Class_Descriptor cd_S513C2;
extern VTBL_ENTRY _ZTI6S513C2[];
extern  VTBL_ENTRY _ZTV6S513C2[];
static Base_Class bases_S513C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S513C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S513C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S513C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S513C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S513C1[];
extern void _ZN6S513C1D1Ev();
extern void _ZN6S513C1D0Ev();
extern void _ZN6S513C53v25Ev();
extern void _ZN6S513C53v26Ev();
extern void _ZN6S513C53v27Ev();
extern void _ZN6S513C53v28Ev();
extern void _ZN6S513C53v29Ev();
extern void _ZN6S513C53v30Ev();
extern void _ZN6S513C53v31Ev();
extern void _ZN6S513C53v32Ev();
extern void _ZN6S513C53v33Ev();
extern void _ZN6S513C53v34Ev();
extern void _ZN6S513C53v35Ev();
extern void _ZN6S513C53v36Ev();
extern void _ZN6S513C53v37Ev();
extern void _ZN6S513C53v38Ev();
extern void _ZN6S513C53v39Ev();
extern void _ZN6S513C53v40Ev();
extern void _ZN6S513C53v41Ev();
extern void _ZN6S513C53v42Ev();
extern void _ZN6S513C53v43Ev();
extern void _ZN6S513C53v44Ev();
extern void _ZN6S513C53v45Ev();
extern void _ZN6S513C53v46Ev();
extern void _ZN6S513C53v47Ev();
extern void _ZN6S513C53v48Ev();
extern void _ZN6S513C53v49Ev();
extern void _ZN6S513C53v50Ev();
extern void _ZN6S513C53v51Ev();
extern void _ZN6S513C53v52Ev();
extern void _ZN6S513C53v53Ev();
extern void _ZN6S513C53v54Ev();
extern void _ZN6S513C53v55Ev();
extern void _ZN6S513C53v56Ev();
extern void _ZN6S513C53v57Ev();
extern void _ZN6S513C53v58Ev();
extern void _ZN6S513C53v59Ev();
extern void _ZN6S513C53v60Ev();
extern void _ZN6S513C53v61Ev();
extern void _ZN6S513C53v62Ev();
extern void _ZN6S513C53v63Ev();
extern void _ZN6S513C53v64Ev();
extern void _ZN6S513C53v65Ev();
extern void _ZN6S513C53v66Ev();
extern void _ZN6S513C53v67Ev();
extern void _ZN6S513C53v68Ev();
extern void _ZN6S513C53v69Ev();
extern void _ZN6S513C53v70Ev();
extern void _ZN6S513C53v71Ev();
extern void _ZN6S513C53v72Ev();
extern void _ZN6S513C53v73Ev();
extern void _ZN6S513C53v74Ev();
extern void _ZN6S513C53v75Ev();
extern void _ZN6S513C53v76Ev();
extern void _ZN6S513C53v77Ev();
extern void _ZN6S513C53v78Ev();
extern void _ZN6S513C53v79Ev();
extern void _ZN6S513C53v80Ev();
extern void _ZN6S513C53v81Ev();
extern void _ZN6S513C53v82Ev();
extern void _ZN6S513C53v83Ev();
extern void _ZN6S513C53v84Ev();
extern void _ZN6S513C53v85Ev();
extern void _ZN6S513C53v86Ev();
extern void _ZN6S513C53v87Ev();
extern void _ZN6S513C53v88Ev();
extern void _ZN6S513C43v89Ev();
extern void _ZN6S513C43v90Ev();
extern void _ZN6S513C43v91Ev();
extern void _ZN6S513C43v92Ev();
extern void _ZN6S513C43v93Ev();
extern void _ZN6S513C33v94Ev();
extern void _ZN6S513C33v95Ev();
extern void _ZN6S513C33v96Ev();
extern void _ZN6S513C33v97Ev();
extern void _ZN6S513C33v98Ev();
extern void _ZN6S513C33v99Ev();
extern void _ZN6S513C34v100Ev();
extern void _ZN6S513C34v101Ev();
extern void _ZN6S513C34v102Ev();
extern void _ZN6S513C34v103Ev();
extern void _ZN6S513C34v104Ev();
extern void _ZN6S513C34v105Ev();
extern void _ZN6S513C34v106Ev();
extern void _ZN6S513C34v107Ev();
extern void _ZN6S513C34v108Ev();
extern void _ZN6S513C34v109Ev();
extern void _ZN6S513C34v110Ev();
extern void _ZN6S513C34v111Ev();
extern void _ZN6S513C34v112Ev();
extern void _ZN6S513C34v113Ev();
extern void _ZN6S513C34v114Ev();
extern void _ZN6S513C34v115Ev();
extern void _ZN6S513C24v116Ev();
extern void _ZN6S513C24v117Ev();
extern void _ZN6S513C24v118Ev();
extern void _ZN6S513C24v119Ev();
extern void _ZN6S513C24v120Ev();
extern void _ZN6S513C24v121Ev();
extern void _ZN6S513C24v122Ev();
extern void _ZN6S513C24v123Ev();
extern void _ZN6S513C24v124Ev();
extern void _ZN6S513C24v125Ev();
extern void _ZN6S513C24v126Ev();
extern void _ZN6S513C24v127Ev();
extern void _ZN6S513C24v128Ev();
extern void _ZN6S513C24v129Ev();
extern void _ZN6S513C24v130Ev();
extern void _ZN6S513C24v131Ev();
extern void _ZN6S513C24v132Ev();
extern void _ZN6S513C24v133Ev();
extern void _ZN6S513C24v134Ev();
extern void _ZN6S513C24v135Ev();
extern void _ZN6S513C24v136Ev();
extern void _ZN6S513C24v137Ev();
extern void _ZN6S513C24v138Ev();
extern void _ZN6S513C24v139Ev();
extern void _ZN6S513C24v140Ev();
extern void _ZN6S513C24v141Ev();
extern void _ZN6S513C24v142Ev();
extern void _ZN6S513C24v143Ev();
extern void _ZN6S513C24v144Ev();
extern void _ZN6S513C24v145Ev();
extern void _ZN6S513C24v146Ev();
extern void _ZN6S513C24v147Ev();
extern void _ZN6S513C24v148Ev();
extern void _ZN6S513C24v149Ev();
extern void _ZN6S513C24v150Ev();
extern void _ZN6S513C24v151Ev();
extern void _ZN6S513C24v152Ev();
extern void _ZN6S513C24v153Ev();
extern void _ZN6S513C24v154Ev();
extern void _ZN6S513C24v155Ev();
extern void _ZN6S513C24v156Ev();
extern void _ZN6S513C24v157Ev();
extern void _ZN6S513C24v158Ev();
extern void _ZN6S513C24v159Ev();
extern void _ZN6S513C24v160Ev();
extern void _ZN6S513C24v161Ev();
extern void _ZN6S513C24v162Ev();
extern void _ZN6S513C24v163Ev();
extern void _ZN6S513C24v164Ev();
extern void _ZN6S513C24v165Ev();
extern void _ZN6S513C24v166Ev();
extern void _ZN6S513C24v167Ev();
extern void _ZN6S513C24v168Ev();
extern void _ZN6S513C24v169Ev();
extern void _ZN6S513C24v170Ev();
extern void _ZN6S513C24v171Ev();
extern void _ZN6S513C24v172Ev();
extern void _ZN6S513C24v173Ev();
extern void _ZN6S513C24v174Ev();
extern void _ZN6S513C24v175Ev();
extern void _ZN6S513C24v176Ev();
extern void _ZN6S513C12v1Ev();
extern void _ZN6S513C12v2Ev();
extern void _ZN6S513C12v3Ev();
extern void _ZN6S513C12v4Ev();
extern void _ZN6S513C12v5Ev();
extern void _ZN6S513C12v6Ev();
extern void _ZN6S513C12v7Ev();
extern void _ZN6S513C12v8Ev();
extern void _ZN6S513C12v9Ev();
extern void _ZN6S513C13v10Ev();
extern void _ZN6S513C13v11Ev();
extern void _ZN6S513C13v12Ev();
extern void _ZN6S513C13v13Ev();
extern void _ZN6S513C13v14Ev();
extern void _ZN6S513C13v15Ev();
extern void _ZN6S513C13v16Ev();
extern void _ZN6S513C13v17Ev();
extern void _ZN6S513C13v18Ev();
extern void _ZN6S513C13v19Ev();
extern void _ZN6S513C13v20Ev();
extern void _ZN6S513C13v21Ev();
extern void _ZN6S513C13v22Ev();
extern void _ZN6S513C13v23Ev();
extern void _ZN6S513C13v24Ev();
static  VTBL_ENTRY vtc_S513C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S513C1[0]),
  (VTBL_ENTRY)&_ZN6S513C1D1Ev,
  (VTBL_ENTRY)&_ZN6S513C1D0Ev,
  (VTBL_ENTRY)&_ZN6S513C53v25Ev,
  (VTBL_ENTRY)&_ZN6S513C53v26Ev,
  (VTBL_ENTRY)&_ZN6S513C53v27Ev,
  (VTBL_ENTRY)&_ZN6S513C53v28Ev,
  (VTBL_ENTRY)&_ZN6S513C53v29Ev,
  (VTBL_ENTRY)&_ZN6S513C53v30Ev,
  (VTBL_ENTRY)&_ZN6S513C53v31Ev,
  (VTBL_ENTRY)&_ZN6S513C53v32Ev,
  (VTBL_ENTRY)&_ZN6S513C53v33Ev,
  (VTBL_ENTRY)&_ZN6S513C53v34Ev,
  (VTBL_ENTRY)&_ZN6S513C53v35Ev,
  (VTBL_ENTRY)&_ZN6S513C53v36Ev,
  (VTBL_ENTRY)&_ZN6S513C53v37Ev,
  (VTBL_ENTRY)&_ZN6S513C53v38Ev,
  (VTBL_ENTRY)&_ZN6S513C53v39Ev,
  (VTBL_ENTRY)&_ZN6S513C53v40Ev,
  (VTBL_ENTRY)&_ZN6S513C53v41Ev,
  (VTBL_ENTRY)&_ZN6S513C53v42Ev,
  (VTBL_ENTRY)&_ZN6S513C53v43Ev,
  (VTBL_ENTRY)&_ZN6S513C53v44Ev,
  (VTBL_ENTRY)&_ZN6S513C53v45Ev,
  (VTBL_ENTRY)&_ZN6S513C53v46Ev,
  (VTBL_ENTRY)&_ZN6S513C53v47Ev,
  (VTBL_ENTRY)&_ZN6S513C53v48Ev,
  (VTBL_ENTRY)&_ZN6S513C53v49Ev,
  (VTBL_ENTRY)&_ZN6S513C53v50Ev,
  (VTBL_ENTRY)&_ZN6S513C53v51Ev,
  (VTBL_ENTRY)&_ZN6S513C53v52Ev,
  (VTBL_ENTRY)&_ZN6S513C53v53Ev,
  (VTBL_ENTRY)&_ZN6S513C53v54Ev,
  (VTBL_ENTRY)&_ZN6S513C53v55Ev,
  (VTBL_ENTRY)&_ZN6S513C53v56Ev,
  (VTBL_ENTRY)&_ZN6S513C53v57Ev,
  (VTBL_ENTRY)&_ZN6S513C53v58Ev,
  (VTBL_ENTRY)&_ZN6S513C53v59Ev,
  (VTBL_ENTRY)&_ZN6S513C53v60Ev,
  (VTBL_ENTRY)&_ZN6S513C53v61Ev,
  (VTBL_ENTRY)&_ZN6S513C53v62Ev,
  (VTBL_ENTRY)&_ZN6S513C53v63Ev,
  (VTBL_ENTRY)&_ZN6S513C53v64Ev,
  (VTBL_ENTRY)&_ZN6S513C53v65Ev,
  (VTBL_ENTRY)&_ZN6S513C53v66Ev,
  (VTBL_ENTRY)&_ZN6S513C53v67Ev,
  (VTBL_ENTRY)&_ZN6S513C53v68Ev,
  (VTBL_ENTRY)&_ZN6S513C53v69Ev,
  (VTBL_ENTRY)&_ZN6S513C53v70Ev,
  (VTBL_ENTRY)&_ZN6S513C53v71Ev,
  (VTBL_ENTRY)&_ZN6S513C53v72Ev,
  (VTBL_ENTRY)&_ZN6S513C53v73Ev,
  (VTBL_ENTRY)&_ZN6S513C53v74Ev,
  (VTBL_ENTRY)&_ZN6S513C53v75Ev,
  (VTBL_ENTRY)&_ZN6S513C53v76Ev,
  (VTBL_ENTRY)&_ZN6S513C53v77Ev,
  (VTBL_ENTRY)&_ZN6S513C53v78Ev,
  (VTBL_ENTRY)&_ZN6S513C53v79Ev,
  (VTBL_ENTRY)&_ZN6S513C53v80Ev,
  (VTBL_ENTRY)&_ZN6S513C53v81Ev,
  (VTBL_ENTRY)&_ZN6S513C53v82Ev,
  (VTBL_ENTRY)&_ZN6S513C53v83Ev,
  (VTBL_ENTRY)&_ZN6S513C53v84Ev,
  (VTBL_ENTRY)&_ZN6S513C53v85Ev,
  (VTBL_ENTRY)&_ZN6S513C53v86Ev,
  (VTBL_ENTRY)&_ZN6S513C53v87Ev,
  (VTBL_ENTRY)&_ZN6S513C53v88Ev,
  (VTBL_ENTRY)&_ZN6S513C43v89Ev,
  (VTBL_ENTRY)&_ZN6S513C43v90Ev,
  (VTBL_ENTRY)&_ZN6S513C43v91Ev,
  (VTBL_ENTRY)&_ZN6S513C43v92Ev,
  (VTBL_ENTRY)&_ZN6S513C43v93Ev,
  (VTBL_ENTRY)&_ZN6S513C33v94Ev,
  (VTBL_ENTRY)&_ZN6S513C33v95Ev,
  (VTBL_ENTRY)&_ZN6S513C33v96Ev,
  (VTBL_ENTRY)&_ZN6S513C33v97Ev,
  (VTBL_ENTRY)&_ZN6S513C33v98Ev,
  (VTBL_ENTRY)&_ZN6S513C33v99Ev,
  (VTBL_ENTRY)&_ZN6S513C34v100Ev,
  (VTBL_ENTRY)&_ZN6S513C34v101Ev,
  (VTBL_ENTRY)&_ZN6S513C34v102Ev,
  (VTBL_ENTRY)&_ZN6S513C34v103Ev,
  (VTBL_ENTRY)&_ZN6S513C34v104Ev,
  (VTBL_ENTRY)&_ZN6S513C34v105Ev,
  (VTBL_ENTRY)&_ZN6S513C34v106Ev,
  (VTBL_ENTRY)&_ZN6S513C34v107Ev,
  (VTBL_ENTRY)&_ZN6S513C34v108Ev,
  (VTBL_ENTRY)&_ZN6S513C34v109Ev,
  (VTBL_ENTRY)&_ZN6S513C34v110Ev,
  (VTBL_ENTRY)&_ZN6S513C34v111Ev,
  (VTBL_ENTRY)&_ZN6S513C34v112Ev,
  (VTBL_ENTRY)&_ZN6S513C34v113Ev,
  (VTBL_ENTRY)&_ZN6S513C34v114Ev,
  (VTBL_ENTRY)&_ZN6S513C34v115Ev,
  (VTBL_ENTRY)&_ZN6S513C24v116Ev,
  (VTBL_ENTRY)&_ZN6S513C24v117Ev,
  (VTBL_ENTRY)&_ZN6S513C24v118Ev,
  (VTBL_ENTRY)&_ZN6S513C24v119Ev,
  (VTBL_ENTRY)&_ZN6S513C24v120Ev,
  (VTBL_ENTRY)&_ZN6S513C24v121Ev,
  (VTBL_ENTRY)&_ZN6S513C24v122Ev,
  (VTBL_ENTRY)&_ZN6S513C24v123Ev,
  (VTBL_ENTRY)&_ZN6S513C24v124Ev,
  (VTBL_ENTRY)&_ZN6S513C24v125Ev,
  (VTBL_ENTRY)&_ZN6S513C24v126Ev,
  (VTBL_ENTRY)&_ZN6S513C24v127Ev,
  (VTBL_ENTRY)&_ZN6S513C24v128Ev,
  (VTBL_ENTRY)&_ZN6S513C24v129Ev,
  (VTBL_ENTRY)&_ZN6S513C24v130Ev,
  (VTBL_ENTRY)&_ZN6S513C24v131Ev,
  (VTBL_ENTRY)&_ZN6S513C24v132Ev,
  (VTBL_ENTRY)&_ZN6S513C24v133Ev,
  (VTBL_ENTRY)&_ZN6S513C24v134Ev,
  (VTBL_ENTRY)&_ZN6S513C24v135Ev,
  (VTBL_ENTRY)&_ZN6S513C24v136Ev,
  (VTBL_ENTRY)&_ZN6S513C24v137Ev,
  (VTBL_ENTRY)&_ZN6S513C24v138Ev,
  (VTBL_ENTRY)&_ZN6S513C24v139Ev,
  (VTBL_ENTRY)&_ZN6S513C24v140Ev,
  (VTBL_ENTRY)&_ZN6S513C24v141Ev,
  (VTBL_ENTRY)&_ZN6S513C24v142Ev,
  (VTBL_ENTRY)&_ZN6S513C24v143Ev,
  (VTBL_ENTRY)&_ZN6S513C24v144Ev,
  (VTBL_ENTRY)&_ZN6S513C24v145Ev,
  (VTBL_ENTRY)&_ZN6S513C24v146Ev,
  (VTBL_ENTRY)&_ZN6S513C24v147Ev,
  (VTBL_ENTRY)&_ZN6S513C24v148Ev,
  (VTBL_ENTRY)&_ZN6S513C24v149Ev,
  (VTBL_ENTRY)&_ZN6S513C24v150Ev,
  (VTBL_ENTRY)&_ZN6S513C24v151Ev,
  (VTBL_ENTRY)&_ZN6S513C24v152Ev,
  (VTBL_ENTRY)&_ZN6S513C24v153Ev,
  (VTBL_ENTRY)&_ZN6S513C24v154Ev,
  (VTBL_ENTRY)&_ZN6S513C24v155Ev,
  (VTBL_ENTRY)&_ZN6S513C24v156Ev,
  (VTBL_ENTRY)&_ZN6S513C24v157Ev,
  (VTBL_ENTRY)&_ZN6S513C24v158Ev,
  (VTBL_ENTRY)&_ZN6S513C24v159Ev,
  (VTBL_ENTRY)&_ZN6S513C24v160Ev,
  (VTBL_ENTRY)&_ZN6S513C24v161Ev,
  (VTBL_ENTRY)&_ZN6S513C24v162Ev,
  (VTBL_ENTRY)&_ZN6S513C24v163Ev,
  (VTBL_ENTRY)&_ZN6S513C24v164Ev,
  (VTBL_ENTRY)&_ZN6S513C24v165Ev,
  (VTBL_ENTRY)&_ZN6S513C24v166Ev,
  (VTBL_ENTRY)&_ZN6S513C24v167Ev,
  (VTBL_ENTRY)&_ZN6S513C24v168Ev,
  (VTBL_ENTRY)&_ZN6S513C24v169Ev,
  (VTBL_ENTRY)&_ZN6S513C24v170Ev,
  (VTBL_ENTRY)&_ZN6S513C24v171Ev,
  (VTBL_ENTRY)&_ZN6S513C24v172Ev,
  (VTBL_ENTRY)&_ZN6S513C24v173Ev,
  (VTBL_ENTRY)&_ZN6S513C24v174Ev,
  (VTBL_ENTRY)&_ZN6S513C24v175Ev,
  (VTBL_ENTRY)&_ZN6S513C24v176Ev,
  (VTBL_ENTRY)&_ZN6S513C12v1Ev,
  (VTBL_ENTRY)&_ZN6S513C12v2Ev,
  (VTBL_ENTRY)&_ZN6S513C12v3Ev,
  (VTBL_ENTRY)&_ZN6S513C12v4Ev,
  (VTBL_ENTRY)&_ZN6S513C12v5Ev,
  (VTBL_ENTRY)&_ZN6S513C12v6Ev,
  (VTBL_ENTRY)&_ZN6S513C12v7Ev,
  (VTBL_ENTRY)&_ZN6S513C12v8Ev,
  (VTBL_ENTRY)&_ZN6S513C12v9Ev,
  (VTBL_ENTRY)&_ZN6S513C13v10Ev,
  (VTBL_ENTRY)&_ZN6S513C13v11Ev,
  (VTBL_ENTRY)&_ZN6S513C13v12Ev,
  (VTBL_ENTRY)&_ZN6S513C13v13Ev,
  (VTBL_ENTRY)&_ZN6S513C13v14Ev,
  (VTBL_ENTRY)&_ZN6S513C13v15Ev,
  (VTBL_ENTRY)&_ZN6S513C13v16Ev,
  (VTBL_ENTRY)&_ZN6S513C13v17Ev,
  (VTBL_ENTRY)&_ZN6S513C13v18Ev,
  (VTBL_ENTRY)&_ZN6S513C13v19Ev,
  (VTBL_ENTRY)&_ZN6S513C13v20Ev,
  (VTBL_ENTRY)&_ZN6S513C13v21Ev,
  (VTBL_ENTRY)&_ZN6S513C13v22Ev,
  (VTBL_ENTRY)&_ZN6S513C13v23Ev,
  (VTBL_ENTRY)&_ZN6S513C13v24Ev,
};
extern VTBL_ENTRY _ZTI6S513C1[];
extern  VTBL_ENTRY _ZTV6S513C1[];
Class_Descriptor cd_S513C1 = {  "S513C1", // class name
  bases_S513C1, 4,
  &(vtc_S513C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(584,420), // object size
  NSPAIRA(_ZTI6S513C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S513C1),180, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S497C5  {
  int s497c5f0;
  __tsi64 s497c5f1;
  void *s497c5f2[4];
  int s497c5f3[2];
  void *s497c5f4;
  ::S95C8_nt s497c5f5;
  void *s497c5f6[2];
  virtual  ~S497C5(); // _ZN6S497C5D1Ev
  virtual void  v17(); // _ZN6S497C53v17Ev
  virtual void  v18(); // _ZN6S497C53v18Ev
  virtual void  v19(); // _ZN6S497C53v19Ev
  virtual void  v20(); // _ZN6S497C53v20Ev
  virtual void  v21(); // _ZN6S497C53v21Ev
  virtual void  v22(); // _ZN6S497C53v22Ev
  virtual void  v23(); // _ZN6S497C53v23Ev
  virtual void  v24(); // _ZN6S497C53v24Ev
  virtual void  v25(); // _ZN6S497C53v25Ev
  virtual void  v26(); // _ZN6S497C53v26Ev
  virtual void  v27(); // _ZN6S497C53v27Ev
  virtual void  v28(); // _ZN6S497C53v28Ev
  virtual void  v29(); // _ZN6S497C53v29Ev
  virtual void  v30(); // _ZN6S497C53v30Ev
  virtual void  v31(); // _ZN6S497C53v31Ev
  virtual void  v32(); // _ZN6S497C53v32Ev
  virtual void  v33(); // _ZN6S497C53v33Ev
  virtual void  v34(); // _ZN6S497C53v34Ev
  virtual void  v35(); // _ZN6S497C53v35Ev
  virtual void  v36(); // _ZN6S497C53v36Ev
  virtual void  v37(); // _ZN6S497C53v37Ev
  virtual void  v38(); // _ZN6S497C53v38Ev
  virtual void  v39(); // _ZN6S497C53v39Ev
  virtual void  v40(); // _ZN6S497C53v40Ev
  virtual void  v41(); // _ZN6S497C53v41Ev
  virtual void  v42(); // _ZN6S497C53v42Ev
  virtual void  v43(); // _ZN6S497C53v43Ev
  virtual void  v44(); // _ZN6S497C53v44Ev
  virtual void  v45(); // _ZN6S497C53v45Ev
  virtual void  v46(); // _ZN6S497C53v46Ev
  virtual void  v47(); // _ZN6S497C53v47Ev
  virtual void  v48(); // _ZN6S497C53v48Ev
  virtual void  v49(); // _ZN6S497C53v49Ev
  virtual void  v50(); // _ZN6S497C53v50Ev
  virtual void  v51(); // _ZN6S497C53v51Ev
  virtual void  v52(); // _ZN6S497C53v52Ev
  virtual void  v53(); // _ZN6S497C53v53Ev
  virtual void  v54(); // _ZN6S497C53v54Ev
  virtual void  v55(); // _ZN6S497C53v55Ev
  virtual void  v56(); // _ZN6S497C53v56Ev
  virtual void  v57(); // _ZN6S497C53v57Ev
  virtual void  v58(); // _ZN6S497C53v58Ev
  virtual void  v59(); // _ZN6S497C53v59Ev
  virtual void  v60(); // _ZN6S497C53v60Ev
  virtual void  v61(); // _ZN6S497C53v61Ev
  virtual void  v62(); // _ZN6S497C53v62Ev
  virtual void  v63(); // _ZN6S497C53v63Ev
  virtual void  v64(); // _ZN6S497C53v64Ev
  virtual void  v65(); // _ZN6S497C53v65Ev
  virtual void  v66(); // _ZN6S497C53v66Ev
  virtual void  v67(); // _ZN6S497C53v67Ev
  virtual void  v68(); // _ZN6S497C53v68Ev
  virtual void  v69(); // _ZN6S497C53v69Ev
  virtual void  v70(); // _ZN6S497C53v70Ev
  virtual void  v71(); // _ZN6S497C53v71Ev
  virtual void  v72(); // _ZN6S497C53v72Ev
  virtual void  v73(); // _ZN6S497C53v73Ev
  virtual void  v74(); // _ZN6S497C53v74Ev
  virtual void  v75(); // _ZN6S497C53v75Ev
  virtual void  v76(); // _ZN6S497C53v76Ev
  virtual void  v77(); // _ZN6S497C53v77Ev
  virtual void  v78(); // _ZN6S497C53v78Ev
  virtual void  v79(); // _ZN6S497C53v79Ev
  virtual void  v80(); // _ZN6S497C53v80Ev
  S497C5(); // tgen
};
//SIG(-1 S497C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S497C5 ::~S497C5(){ note_dtor("S497C5", this);}
void  S497C5 ::v17(){vfunc_called(this, "_ZN6S497C53v17Ev");}
void  S497C5 ::v18(){vfunc_called(this, "_ZN6S497C53v18Ev");}
void  S497C5 ::v19(){vfunc_called(this, "_ZN6S497C53v19Ev");}
void  S497C5 ::v20(){vfunc_called(this, "_ZN6S497C53v20Ev");}
void  S497C5 ::v21(){vfunc_called(this, "_ZN6S497C53v21Ev");}
void  S497C5 ::v22(){vfunc_called(this, "_ZN6S497C53v22Ev");}
void  S497C5 ::v23(){vfunc_called(this, "_ZN6S497C53v23Ev");}
void  S497C5 ::v24(){vfunc_called(this, "_ZN6S497C53v24Ev");}
void  S497C5 ::v25(){vfunc_called(this, "_ZN6S497C53v25Ev");}
void  S497C5 ::v26(){vfunc_called(this, "_ZN6S497C53v26Ev");}
void  S497C5 ::v27(){vfunc_called(this, "_ZN6S497C53v27Ev");}
void  S497C5 ::v28(){vfunc_called(this, "_ZN6S497C53v28Ev");}
void  S497C5 ::v29(){vfunc_called(this, "_ZN6S497C53v29Ev");}
void  S497C5 ::v30(){vfunc_called(this, "_ZN6S497C53v30Ev");}
void  S497C5 ::v31(){vfunc_called(this, "_ZN6S497C53v31Ev");}
void  S497C5 ::v32(){vfunc_called(this, "_ZN6S497C53v32Ev");}
void  S497C5 ::v33(){vfunc_called(this, "_ZN6S497C53v33Ev");}
void  S497C5 ::v34(){vfunc_called(this, "_ZN6S497C53v34Ev");}
void  S497C5 ::v35(){vfunc_called(this, "_ZN6S497C53v35Ev");}
void  S497C5 ::v36(){vfunc_called(this, "_ZN6S497C53v36Ev");}
void  S497C5 ::v37(){vfunc_called(this, "_ZN6S497C53v37Ev");}
void  S497C5 ::v38(){vfunc_called(this, "_ZN6S497C53v38Ev");}
void  S497C5 ::v39(){vfunc_called(this, "_ZN6S497C53v39Ev");}
void  S497C5 ::v40(){vfunc_called(this, "_ZN6S497C53v40Ev");}
void  S497C5 ::v41(){vfunc_called(this, "_ZN6S497C53v41Ev");}
void  S497C5 ::v42(){vfunc_called(this, "_ZN6S497C53v42Ev");}
void  S497C5 ::v43(){vfunc_called(this, "_ZN6S497C53v43Ev");}
void  S497C5 ::v44(){vfunc_called(this, "_ZN6S497C53v44Ev");}
void  S497C5 ::v45(){vfunc_called(this, "_ZN6S497C53v45Ev");}
void  S497C5 ::v46(){vfunc_called(this, "_ZN6S497C53v46Ev");}
void  S497C5 ::v47(){vfunc_called(this, "_ZN6S497C53v47Ev");}
void  S497C5 ::v48(){vfunc_called(this, "_ZN6S497C53v48Ev");}
void  S497C5 ::v49(){vfunc_called(this, "_ZN6S497C53v49Ev");}
void  S497C5 ::v50(){vfunc_called(this, "_ZN6S497C53v50Ev");}
void  S497C5 ::v51(){vfunc_called(this, "_ZN6S497C53v51Ev");}
void  S497C5 ::v52(){vfunc_called(this, "_ZN6S497C53v52Ev");}
void  S497C5 ::v53(){vfunc_called(this, "_ZN6S497C53v53Ev");}
void  S497C5 ::v54(){vfunc_called(this, "_ZN6S497C53v54Ev");}
void  S497C5 ::v55(){vfunc_called(this, "_ZN6S497C53v55Ev");}
void  S497C5 ::v56(){vfunc_called(this, "_ZN6S497C53v56Ev");}
void  S497C5 ::v57(){vfunc_called(this, "_ZN6S497C53v57Ev");}
void  S497C5 ::v58(){vfunc_called(this, "_ZN6S497C53v58Ev");}
void  S497C5 ::v59(){vfunc_called(this, "_ZN6S497C53v59Ev");}
void  S497C5 ::v60(){vfunc_called(this, "_ZN6S497C53v60Ev");}
void  S497C5 ::v61(){vfunc_called(this, "_ZN6S497C53v61Ev");}
void  S497C5 ::v62(){vfunc_called(this, "_ZN6S497C53v62Ev");}
void  S497C5 ::v63(){vfunc_called(this, "_ZN6S497C53v63Ev");}
void  S497C5 ::v64(){vfunc_called(this, "_ZN6S497C53v64Ev");}
void  S497C5 ::v65(){vfunc_called(this, "_ZN6S497C53v65Ev");}
void  S497C5 ::v66(){vfunc_called(this, "_ZN6S497C53v66Ev");}
void  S497C5 ::v67(){vfunc_called(this, "_ZN6S497C53v67Ev");}
void  S497C5 ::v68(){vfunc_called(this, "_ZN6S497C53v68Ev");}
void  S497C5 ::v69(){vfunc_called(this, "_ZN6S497C53v69Ev");}
void  S497C5 ::v70(){vfunc_called(this, "_ZN6S497C53v70Ev");}
void  S497C5 ::v71(){vfunc_called(this, "_ZN6S497C53v71Ev");}
void  S497C5 ::v72(){vfunc_called(this, "_ZN6S497C53v72Ev");}
void  S497C5 ::v73(){vfunc_called(this, "_ZN6S497C53v73Ev");}
void  S497C5 ::v74(){vfunc_called(this, "_ZN6S497C53v74Ev");}
void  S497C5 ::v75(){vfunc_called(this, "_ZN6S497C53v75Ev");}
void  S497C5 ::v76(){vfunc_called(this, "_ZN6S497C53v76Ev");}
void  S497C5 ::v77(){vfunc_called(this, "_ZN6S497C53v77Ev");}
void  S497C5 ::v78(){vfunc_called(this, "_ZN6S497C53v78Ev");}
void  S497C5 ::v79(){vfunc_called(this, "_ZN6S497C53v79Ev");}
void  S497C5 ::v80(){vfunc_called(this, "_ZN6S497C53v80Ev");}
S497C5 ::S497C5(){ note_ctor("S497C5", this);} // tgen

static void Test_S497C5()
{
  extern Class_Descriptor cd_S497C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S497C5, buf);
    S497C5 *dp, &lv = *(dp=new (buf) S497C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S497C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S497C5)");
    check_field_offset(lv, s497c5f0, ABISELECT(8,4), "S497C5.s497c5f0");
    check_field_offset(lv, s497c5f1, ABISELECT(16,8), "S497C5.s497c5f1");
    check_field_offset(lv, s497c5f2, ABISELECT(24,16), "S497C5.s497c5f2");
    check_field_offset(lv, s497c5f3, ABISELECT(56,32), "S497C5.s497c5f3");
    check_field_offset(lv, s497c5f4, ABISELECT(64,40), "S497C5.s497c5f4");
    check_field_offset(lv, s497c5f5, ABISELECT(72,44), "S497C5.s497c5f5");
    check_field_offset(lv, s497c5f6, ABISELECT(80,52), "S497C5.s497c5f6");
    test_class_info(&lv, &cd_S497C5);
    dp->~S497C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS497C5(Test_S497C5, "S497C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S497C5C1Ev();
extern void _ZN6S497C5D1Ev();
Name_Map name_map_S497C5[] = {
  NSPAIR(_ZN6S497C5C1Ev),
  NSPAIR(_ZN6S497C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S497C5[];
extern void _ZN6S497C5D1Ev();
extern void _ZN6S497C5D0Ev();
extern void _ZN6S497C53v17Ev();
extern void _ZN6S497C53v18Ev();
extern void _ZN6S497C53v19Ev();
extern void _ZN6S497C53v20Ev();
extern void _ZN6S497C53v21Ev();
extern void _ZN6S497C53v22Ev();
extern void _ZN6S497C53v23Ev();
extern void _ZN6S497C53v24Ev();
extern void _ZN6S497C53v25Ev();
extern void _ZN6S497C53v26Ev();
extern void _ZN6S497C53v27Ev();
extern void _ZN6S497C53v28Ev();
extern void _ZN6S497C53v29Ev();
extern void _ZN6S497C53v30Ev();
extern void _ZN6S497C53v31Ev();
extern void _ZN6S497C53v32Ev();
extern void _ZN6S497C53v33Ev();
extern void _ZN6S497C53v34Ev();
extern void _ZN6S497C53v35Ev();
extern void _ZN6S497C53v36Ev();
extern void _ZN6S497C53v37Ev();
extern void _ZN6S497C53v38Ev();
extern void _ZN6S497C53v39Ev();
extern void _ZN6S497C53v40Ev();
extern void _ZN6S497C53v41Ev();
extern void _ZN6S497C53v42Ev();
extern void _ZN6S497C53v43Ev();
extern void _ZN6S497C53v44Ev();
extern void _ZN6S497C53v45Ev();
extern void _ZN6S497C53v46Ev();
extern void _ZN6S497C53v47Ev();
extern void _ZN6S497C53v48Ev();
extern void _ZN6S497C53v49Ev();
extern void _ZN6S497C53v50Ev();
extern void _ZN6S497C53v51Ev();
extern void _ZN6S497C53v52Ev();
extern void _ZN6S497C53v53Ev();
extern void _ZN6S497C53v54Ev();
extern void _ZN6S497C53v55Ev();
extern void _ZN6S497C53v56Ev();
extern void _ZN6S497C53v57Ev();
extern void _ZN6S497C53v58Ev();
extern void _ZN6S497C53v59Ev();
extern void _ZN6S497C53v60Ev();
extern void _ZN6S497C53v61Ev();
extern void _ZN6S497C53v62Ev();
extern void _ZN6S497C53v63Ev();
extern void _ZN6S497C53v64Ev();
extern void _ZN6S497C53v65Ev();
extern void _ZN6S497C53v66Ev();
extern void _ZN6S497C53v67Ev();
extern void _ZN6S497C53v68Ev();
extern void _ZN6S497C53v69Ev();
extern void _ZN6S497C53v70Ev();
extern void _ZN6S497C53v71Ev();
extern void _ZN6S497C53v72Ev();
extern void _ZN6S497C53v73Ev();
extern void _ZN6S497C53v74Ev();
extern void _ZN6S497C53v75Ev();
extern void _ZN6S497C53v76Ev();
extern void _ZN6S497C53v77Ev();
extern void _ZN6S497C53v78Ev();
extern void _ZN6S497C53v79Ev();
extern void _ZN6S497C53v80Ev();
static  VTBL_ENTRY vtc_S497C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S497C5[0]),
  (VTBL_ENTRY)&_ZN6S497C5D1Ev,
  (VTBL_ENTRY)&_ZN6S497C5D0Ev,
  (VTBL_ENTRY)&_ZN6S497C53v17Ev,
  (VTBL_ENTRY)&_ZN6S497C53v18Ev,
  (VTBL_ENTRY)&_ZN6S497C53v19Ev,
  (VTBL_ENTRY)&_ZN6S497C53v20Ev,
  (VTBL_ENTRY)&_ZN6S497C53v21Ev,
  (VTBL_ENTRY)&_ZN6S497C53v22Ev,
  (VTBL_ENTRY)&_ZN6S497C53v23Ev,
  (VTBL_ENTRY)&_ZN6S497C53v24Ev,
  (VTBL_ENTRY)&_ZN6S497C53v25Ev,
  (VTBL_ENTRY)&_ZN6S497C53v26Ev,
  (VTBL_ENTRY)&_ZN6S497C53v27Ev,
  (VTBL_ENTRY)&_ZN6S497C53v28Ev,
  (VTBL_ENTRY)&_ZN6S497C53v29Ev,
  (VTBL_ENTRY)&_ZN6S497C53v30Ev,
  (VTBL_ENTRY)&_ZN6S497C53v31Ev,
  (VTBL_ENTRY)&_ZN6S497C53v32Ev,
  (VTBL_ENTRY)&_ZN6S497C53v33Ev,
  (VTBL_ENTRY)&_ZN6S497C53v34Ev,
  (VTBL_ENTRY)&_ZN6S497C53v35Ev,
  (VTBL_ENTRY)&_ZN6S497C53v36Ev,
  (VTBL_ENTRY)&_ZN6S497C53v37Ev,
  (VTBL_ENTRY)&_ZN6S497C53v38Ev,
  (VTBL_ENTRY)&_ZN6S497C53v39Ev,
  (VTBL_ENTRY)&_ZN6S497C53v40Ev,
  (VTBL_ENTRY)&_ZN6S497C53v41Ev,
  (VTBL_ENTRY)&_ZN6S497C53v42Ev,
  (VTBL_ENTRY)&_ZN6S497C53v43Ev,
  (VTBL_ENTRY)&_ZN6S497C53v44Ev,
  (VTBL_ENTRY)&_ZN6S497C53v45Ev,
  (VTBL_ENTRY)&_ZN6S497C53v46Ev,
  (VTBL_ENTRY)&_ZN6S497C53v47Ev,
  (VTBL_ENTRY)&_ZN6S497C53v48Ev,
  (VTBL_ENTRY)&_ZN6S497C53v49Ev,
  (VTBL_ENTRY)&_ZN6S497C53v50Ev,
  (VTBL_ENTRY)&_ZN6S497C53v51Ev,
  (VTBL_ENTRY)&_ZN6S497C53v52Ev,
  (VTBL_ENTRY)&_ZN6S497C53v53Ev,
  (VTBL_ENTRY)&_ZN6S497C53v54Ev,
  (VTBL_ENTRY)&_ZN6S497C53v55Ev,
  (VTBL_ENTRY)&_ZN6S497C53v56Ev,
  (VTBL_ENTRY)&_ZN6S497C53v57Ev,
  (VTBL_ENTRY)&_ZN6S497C53v58Ev,
  (VTBL_ENTRY)&_ZN6S497C53v59Ev,
  (VTBL_ENTRY)&_ZN6S497C53v60Ev,
  (VTBL_ENTRY)&_ZN6S497C53v61Ev,
  (VTBL_ENTRY)&_ZN6S497C53v62Ev,
  (VTBL_ENTRY)&_ZN6S497C53v63Ev,
  (VTBL_ENTRY)&_ZN6S497C53v64Ev,
  (VTBL_ENTRY)&_ZN6S497C53v65Ev,
  (VTBL_ENTRY)&_ZN6S497C53v66Ev,
  (VTBL_ENTRY)&_ZN6S497C53v67Ev,
  (VTBL_ENTRY)&_ZN6S497C53v68Ev,
  (VTBL_ENTRY)&_ZN6S497C53v69Ev,
  (VTBL_ENTRY)&_ZN6S497C53v70Ev,
  (VTBL_ENTRY)&_ZN6S497C53v71Ev,
  (VTBL_ENTRY)&_ZN6S497C53v72Ev,
  (VTBL_ENTRY)&_ZN6S497C53v73Ev,
  (VTBL_ENTRY)&_ZN6S497C53v74Ev,
  (VTBL_ENTRY)&_ZN6S497C53v75Ev,
  (VTBL_ENTRY)&_ZN6S497C53v76Ev,
  (VTBL_ENTRY)&_ZN6S497C53v77Ev,
  (VTBL_ENTRY)&_ZN6S497C53v78Ev,
  (VTBL_ENTRY)&_ZN6S497C53v79Ev,
  (VTBL_ENTRY)&_ZN6S497C53v80Ev,
};
extern VTBL_ENTRY _ZTI6S497C5[];
extern  VTBL_ENTRY _ZTV6S497C5[];
Class_Descriptor cd_S497C5 = {  "S497C5", // class name
  0,0,//no base classes
  &(vtc_S497C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S497C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S497C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S497C4  : S497C5 {
  void *s497c4f0;
  ::S95C8_nt s497c4f1;
  virtual  ~S497C4(); // _ZN6S497C4D1Ev
  virtual void  v81(); // _ZN6S497C43v81Ev
  virtual void  v82(); // _ZN6S497C43v82Ev
  virtual void  v83(); // _ZN6S497C43v83Ev
  virtual void  v84(); // _ZN6S497C43v84Ev
  virtual void  v85(); // _ZN6S497C43v85Ev
  S497C4(); // tgen
};
//SIG(-1 S497C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S497C4 ::~S497C4(){ note_dtor("S497C4", this);}
void  S497C4 ::v81(){vfunc_called(this, "_ZN6S497C43v81Ev");}
void  S497C4 ::v82(){vfunc_called(this, "_ZN6S497C43v82Ev");}
void  S497C4 ::v83(){vfunc_called(this, "_ZN6S497C43v83Ev");}
void  S497C4 ::v84(){vfunc_called(this, "_ZN6S497C43v84Ev");}
void  S497C4 ::v85(){vfunc_called(this, "_ZN6S497C43v85Ev");}
S497C4 ::S497C4(){ note_ctor("S497C4", this);} // tgen

static void Test_S497C4()
{
  extern Class_Descriptor cd_S497C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S497C4, buf);
    S497C4 *dp, &lv = *(dp=new (buf) S497C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S497C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S497C4)");
    check_base_class_offset(lv, (S497C5*), 0, "S497C4");
    check_field_offset(lv, s497c4f0, ABISELECT(96,60), "S497C4.s497c4f0");
    check_field_offset(lv, s497c4f1, ABISELECT(104,64), "S497C4.s497c4f1");
    test_class_info(&lv, &cd_S497C4);
    dp->~S497C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS497C4(Test_S497C4, "S497C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S497C4C1Ev();
extern void _ZN6S497C4D1Ev();
Name_Map name_map_S497C4[] = {
  NSPAIR(_ZN6S497C4C1Ev),
  NSPAIR(_ZN6S497C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S497C5;
extern VTBL_ENTRY _ZTI6S497C5[];
extern  VTBL_ENTRY _ZTV6S497C5[];
static Base_Class bases_S497C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S497C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S497C4[];
extern void _ZN6S497C4D1Ev();
extern void _ZN6S497C4D0Ev();
extern void _ZN6S497C53v17Ev();
extern void _ZN6S497C53v18Ev();
extern void _ZN6S497C53v19Ev();
extern void _ZN6S497C53v20Ev();
extern void _ZN6S497C53v21Ev();
extern void _ZN6S497C53v22Ev();
extern void _ZN6S497C53v23Ev();
extern void _ZN6S497C53v24Ev();
extern void _ZN6S497C53v25Ev();
extern void _ZN6S497C53v26Ev();
extern void _ZN6S497C53v27Ev();
extern void _ZN6S497C53v28Ev();
extern void _ZN6S497C53v29Ev();
extern void _ZN6S497C53v30Ev();
extern void _ZN6S497C53v31Ev();
extern void _ZN6S497C53v32Ev();
extern void _ZN6S497C53v33Ev();
extern void _ZN6S497C53v34Ev();
extern void _ZN6S497C53v35Ev();
extern void _ZN6S497C53v36Ev();
extern void _ZN6S497C53v37Ev();
extern void _ZN6S497C53v38Ev();
extern void _ZN6S497C53v39Ev();
extern void _ZN6S497C53v40Ev();
extern void _ZN6S497C53v41Ev();
extern void _ZN6S497C53v42Ev();
extern void _ZN6S497C53v43Ev();
extern void _ZN6S497C53v44Ev();
extern void _ZN6S497C53v45Ev();
extern void _ZN6S497C53v46Ev();
extern void _ZN6S497C53v47Ev();
extern void _ZN6S497C53v48Ev();
extern void _ZN6S497C53v49Ev();
extern void _ZN6S497C53v50Ev();
extern void _ZN6S497C53v51Ev();
extern void _ZN6S497C53v52Ev();
extern void _ZN6S497C53v53Ev();
extern void _ZN6S497C53v54Ev();
extern void _ZN6S497C53v55Ev();
extern void _ZN6S497C53v56Ev();
extern void _ZN6S497C53v57Ev();
extern void _ZN6S497C53v58Ev();
extern void _ZN6S497C53v59Ev();
extern void _ZN6S497C53v60Ev();
extern void _ZN6S497C53v61Ev();
extern void _ZN6S497C53v62Ev();
extern void _ZN6S497C53v63Ev();
extern void _ZN6S497C53v64Ev();
extern void _ZN6S497C53v65Ev();
extern void _ZN6S497C53v66Ev();
extern void _ZN6S497C53v67Ev();
extern void _ZN6S497C53v68Ev();
extern void _ZN6S497C53v69Ev();
extern void _ZN6S497C53v70Ev();
extern void _ZN6S497C53v71Ev();
extern void _ZN6S497C53v72Ev();
extern void _ZN6S497C53v73Ev();
extern void _ZN6S497C53v74Ev();
extern void _ZN6S497C53v75Ev();
extern void _ZN6S497C53v76Ev();
extern void _ZN6S497C53v77Ev();
extern void _ZN6S497C53v78Ev();
extern void _ZN6S497C53v79Ev();
extern void _ZN6S497C53v80Ev();
extern void _ZN6S497C43v81Ev();
extern void _ZN6S497C43v82Ev();
extern void _ZN6S497C43v83Ev();
extern void _ZN6S497C43v84Ev();
extern void _ZN6S497C43v85Ev();
static  VTBL_ENTRY vtc_S497C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S497C4[0]),
  (VTBL_ENTRY)&_ZN6S497C4D1Ev,
  (VTBL_ENTRY)&_ZN6S497C4D0Ev,
  (VTBL_ENTRY)&_ZN6S497C53v17Ev,
  (VTBL_ENTRY)&_ZN6S497C53v18Ev,
  (VTBL_ENTRY)&_ZN6S497C53v19Ev,
  (VTBL_ENTRY)&_ZN6S497C53v20Ev,
  (VTBL_ENTRY)&_ZN6S497C53v21Ev,
  (VTBL_ENTRY)&_ZN6S497C53v22Ev,
  (VTBL_ENTRY)&_ZN6S497C53v23Ev,
  (VTBL_ENTRY)&_ZN6S497C53v24Ev,
  (VTBL_ENTRY)&_ZN6S497C53v25Ev,
  (VTBL_ENTRY)&_ZN6S497C53v26Ev,
  (VTBL_ENTRY)&_ZN6S497C53v27Ev,
  (VTBL_ENTRY)&_ZN6S497C53v28Ev,
  (VTBL_ENTRY)&_ZN6S497C53v29Ev,
  (VTBL_ENTRY)&_ZN6S497C53v30Ev,
  (VTBL_ENTRY)&_ZN6S497C53v31Ev,
  (VTBL_ENTRY)&_ZN6S497C53v32Ev,
  (VTBL_ENTRY)&_ZN6S497C53v33Ev,
  (VTBL_ENTRY)&_ZN6S497C53v34Ev,
  (VTBL_ENTRY)&_ZN6S497C53v35Ev,
  (VTBL_ENTRY)&_ZN6S497C53v36Ev,
  (VTBL_ENTRY)&_ZN6S497C53v37Ev,
  (VTBL_ENTRY)&_ZN6S497C53v38Ev,
  (VTBL_ENTRY)&_ZN6S497C53v39Ev,
  (VTBL_ENTRY)&_ZN6S497C53v40Ev,
  (VTBL_ENTRY)&_ZN6S497C53v41Ev,
  (VTBL_ENTRY)&_ZN6S497C53v42Ev,
  (VTBL_ENTRY)&_ZN6S497C53v43Ev,
  (VTBL_ENTRY)&_ZN6S497C53v44Ev,
  (VTBL_ENTRY)&_ZN6S497C53v45Ev,
  (VTBL_ENTRY)&_ZN6S497C53v46Ev,
  (VTBL_ENTRY)&_ZN6S497C53v47Ev,
  (VTBL_ENTRY)&_ZN6S497C53v48Ev,
  (VTBL_ENTRY)&_ZN6S497C53v49Ev,
  (VTBL_ENTRY)&_ZN6S497C53v50Ev,
  (VTBL_ENTRY)&_ZN6S497C53v51Ev,
  (VTBL_ENTRY)&_ZN6S497C53v52Ev,
  (VTBL_ENTRY)&_ZN6S497C53v53Ev,
  (VTBL_ENTRY)&_ZN6S497C53v54Ev,
  (VTBL_ENTRY)&_ZN6S497C53v55Ev,
  (VTBL_ENTRY)&_ZN6S497C53v56Ev,
  (VTBL_ENTRY)&_ZN6S497C53v57Ev,
  (VTBL_ENTRY)&_ZN6S497C53v58Ev,
  (VTBL_ENTRY)&_ZN6S497C53v59Ev,
  (VTBL_ENTRY)&_ZN6S497C53v60Ev,
  (VTBL_ENTRY)&_ZN6S497C53v61Ev,
  (VTBL_ENTRY)&_ZN6S497C53v62Ev,
  (VTBL_ENTRY)&_ZN6S497C53v63Ev,
  (VTBL_ENTRY)&_ZN6S497C53v64Ev,
  (VTBL_ENTRY)&_ZN6S497C53v65Ev,
  (VTBL_ENTRY)&_ZN6S497C53v66Ev,
  (VTBL_ENTRY)&_ZN6S497C53v67Ev,
  (VTBL_ENTRY)&_ZN6S497C53v68Ev,
  (VTBL_ENTRY)&_ZN6S497C53v69Ev,
  (VTBL_ENTRY)&_ZN6S497C53v70Ev,
  (VTBL_ENTRY)&_ZN6S497C53v71Ev,
  (VTBL_ENTRY)&_ZN6S497C53v72Ev,
  (VTBL_ENTRY)&_ZN6S497C53v73Ev,
  (VTBL_ENTRY)&_ZN6S497C53v74Ev,
  (VTBL_ENTRY)&_ZN6S497C53v75Ev,
  (VTBL_ENTRY)&_ZN6S497C53v76Ev,
  (VTBL_ENTRY)&_ZN6S497C53v77Ev,
  (VTBL_ENTRY)&_ZN6S497C53v78Ev,
  (VTBL_ENTRY)&_ZN6S497C53v79Ev,
  (VTBL_ENTRY)&_ZN6S497C53v80Ev,
  (VTBL_ENTRY)&_ZN6S497C43v81Ev,
  (VTBL_ENTRY)&_ZN6S497C43v82Ev,
  (VTBL_ENTRY)&_ZN6S497C43v83Ev,
  (VTBL_ENTRY)&_ZN6S497C43v84Ev,
  (VTBL_ENTRY)&_ZN6S497C43v85Ev,
};
extern VTBL_ENTRY _ZTI6S497C4[];
extern  VTBL_ENTRY _ZTV6S497C4[];
Class_Descriptor cd_S497C4 = {  "S497C4", // class name
  bases_S497C4, 1,
  &(vtc_S497C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S497C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S497C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S497C3  : S497C4 {
  void *s497c3f0[2];
  unsigned int s497c3f1:1;
  unsigned int s497c3f2:1;
  unsigned int s497c3f3:1;
  unsigned int s497c3f4:1;
  char s497c3f5;
  virtual  ~S497C3(); // _ZN6S497C3D1Ev
  virtual void  v86(); // _ZN6S497C33v86Ev
  virtual void  v87(); // _ZN6S497C33v87Ev
  virtual void  v88(); // _ZN6S497C33v88Ev
  virtual void  v89(); // _ZN6S497C33v89Ev
  virtual void  v90(); // _ZN6S497C33v90Ev
  virtual void  v91(); // _ZN6S497C33v91Ev
  virtual void  v92(); // _ZN6S497C33v92Ev
  virtual void  v93(); // _ZN6S497C33v93Ev
  virtual void  v94(); // _ZN6S497C33v94Ev
  virtual void  v95(); // _ZN6S497C33v95Ev
  virtual void  v96(); // _ZN6S497C33v96Ev
  virtual void  v97(); // _ZN6S497C33v97Ev
  virtual void  v98(); // _ZN6S497C33v98Ev
  virtual void  v99(); // _ZN6S497C33v99Ev
  virtual void  v100(); // _ZN6S497C34v100Ev
  virtual void  v101(); // _ZN6S497C34v101Ev
  virtual void  v102(); // _ZN6S497C34v102Ev
  virtual void  v103(); // _ZN6S497C34v103Ev
  virtual void  v104(); // _ZN6S497C34v104Ev
  virtual void  v105(); // _ZN6S497C34v105Ev
  virtual void  v106(); // _ZN6S497C34v106Ev
  virtual void  v107(); // _ZN6S497C34v107Ev
  S497C3(); // tgen
};
//SIG(-1 S497C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S497C3 ::~S497C3(){ note_dtor("S497C3", this);}
void  S497C3 ::v86(){vfunc_called(this, "_ZN6S497C33v86Ev");}
void  S497C3 ::v87(){vfunc_called(this, "_ZN6S497C33v87Ev");}
void  S497C3 ::v88(){vfunc_called(this, "_ZN6S497C33v88Ev");}
void  S497C3 ::v89(){vfunc_called(this, "_ZN6S497C33v89Ev");}
void  S497C3 ::v90(){vfunc_called(this, "_ZN6S497C33v90Ev");}
void  S497C3 ::v91(){vfunc_called(this, "_ZN6S497C33v91Ev");}
void  S497C3 ::v92(){vfunc_called(this, "_ZN6S497C33v92Ev");}
void  S497C3 ::v93(){vfunc_called(this, "_ZN6S497C33v93Ev");}
void  S497C3 ::v94(){vfunc_called(this, "_ZN6S497C33v94Ev");}
void  S497C3 ::v95(){vfunc_called(this, "_ZN6S497C33v95Ev");}
void  S497C3 ::v96(){vfunc_called(this, "_ZN6S497C33v96Ev");}
void  S497C3 ::v97(){vfunc_called(this, "_ZN6S497C33v97Ev");}
void  S497C3 ::v98(){vfunc_called(this, "_ZN6S497C33v98Ev");}
void  S497C3 ::v99(){vfunc_called(this, "_ZN6S497C33v99Ev");}
void  S497C3 ::v100(){vfunc_called(this, "_ZN6S497C34v100Ev");}
void  S497C3 ::v101(){vfunc_called(this, "_ZN6S497C34v101Ev");}
void  S497C3 ::v102(){vfunc_called(this, "_ZN6S497C34v102Ev");}
void  S497C3 ::v103(){vfunc_called(this, "_ZN6S497C34v103Ev");}
void  S497C3 ::v104(){vfunc_called(this, "_ZN6S497C34v104Ev");}
void  S497C3 ::v105(){vfunc_called(this, "_ZN6S497C34v105Ev");}
void  S497C3 ::v106(){vfunc_called(this, "_ZN6S497C34v106Ev");}
void  S497C3 ::v107(){vfunc_called(this, "_ZN6S497C34v107Ev");}
S497C3 ::S497C3(){ note_ctor("S497C3", this);} // tgen

static void Test_S497C3()
{
  extern Class_Descriptor cd_S497C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S497C3, buf);
    S497C3 *dp, &lv = *(dp=new (buf) S497C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S497C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S497C3)");
    check_base_class_offset(lv, (S497C5*)(S497C4*), 0, "S497C3");
    check_base_class_offset(lv, (S497C4*), 0, "S497C3");
    check_field_offset(lv, s497c3f0, ABISELECT(112,72), "S497C3.s497c3f0");
    set_bf_and_test(lv, s497c3f1, ABISELECT(128,80), 0, 1, 1, "S497C3");
    set_bf_and_test(lv, s497c3f2, ABISELECT(128,80), 1, 1, 1, "S497C3");
    set_bf_and_test(lv, s497c3f3, ABISELECT(128,80), 2, 1, 1, "S497C3");
    set_bf_and_test(lv, s497c3f4, ABISELECT(128,80), 3, 1, 1, "S497C3");
    check_field_offset(lv, s497c3f5, ABISELECT(129,81), "S497C3.s497c3f5");
    test_class_info(&lv, &cd_S497C3);
    dp->~S497C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS497C3(Test_S497C3, "S497C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S497C3C1Ev();
extern void _ZN6S497C3D1Ev();
Name_Map name_map_S497C3[] = {
  NSPAIR(_ZN6S497C3C1Ev),
  NSPAIR(_ZN6S497C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S497C5;
extern VTBL_ENTRY _ZTI6S497C5[];
extern  VTBL_ENTRY _ZTV6S497C5[];
extern Class_Descriptor cd_S497C4;
extern VTBL_ENTRY _ZTI6S497C4[];
extern  VTBL_ENTRY _ZTV6S497C4[];
static Base_Class bases_S497C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S497C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S497C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S497C3[];
extern void _ZN6S497C3D1Ev();
extern void _ZN6S497C3D0Ev();
extern void _ZN6S497C53v17Ev();
extern void _ZN6S497C53v18Ev();
extern void _ZN6S497C53v19Ev();
extern void _ZN6S497C53v20Ev();
extern void _ZN6S497C53v21Ev();
extern void _ZN6S497C53v22Ev();
extern void _ZN6S497C53v23Ev();
extern void _ZN6S497C53v24Ev();
extern void _ZN6S497C53v25Ev();
extern void _ZN6S497C53v26Ev();
extern void _ZN6S497C53v27Ev();
extern void _ZN6S497C53v28Ev();
extern void _ZN6S497C53v29Ev();
extern void _ZN6S497C53v30Ev();
extern void _ZN6S497C53v31Ev();
extern void _ZN6S497C53v32Ev();
extern void _ZN6S497C53v33Ev();
extern void _ZN6S497C53v34Ev();
extern void _ZN6S497C53v35Ev();
extern void _ZN6S497C53v36Ev();
extern void _ZN6S497C53v37Ev();
extern void _ZN6S497C53v38Ev();
extern void _ZN6S497C53v39Ev();
extern void _ZN6S497C53v40Ev();
extern void _ZN6S497C53v41Ev();
extern void _ZN6S497C53v42Ev();
extern void _ZN6S497C53v43Ev();
extern void _ZN6S497C53v44Ev();
extern void _ZN6S497C53v45Ev();
extern void _ZN6S497C53v46Ev();
extern void _ZN6S497C53v47Ev();
extern void _ZN6S497C53v48Ev();
extern void _ZN6S497C53v49Ev();
extern void _ZN6S497C53v50Ev();
extern void _ZN6S497C53v51Ev();
extern void _ZN6S497C53v52Ev();
extern void _ZN6S497C53v53Ev();
extern void _ZN6S497C53v54Ev();
extern void _ZN6S497C53v55Ev();
extern void _ZN6S497C53v56Ev();
extern void _ZN6S497C53v57Ev();
extern void _ZN6S497C53v58Ev();
extern void _ZN6S497C53v59Ev();
extern void _ZN6S497C53v60Ev();
extern void _ZN6S497C53v61Ev();
extern void _ZN6S497C53v62Ev();
extern void _ZN6S497C53v63Ev();
extern void _ZN6S497C53v64Ev();
extern void _ZN6S497C53v65Ev();
extern void _ZN6S497C53v66Ev();
extern void _ZN6S497C53v67Ev();
extern void _ZN6S497C53v68Ev();
extern void _ZN6S497C53v69Ev();
extern void _ZN6S497C53v70Ev();
extern void _ZN6S497C53v71Ev();
extern void _ZN6S497C53v72Ev();
extern void _ZN6S497C53v73Ev();
extern void _ZN6S497C53v74Ev();
extern void _ZN6S497C53v75Ev();
extern void _ZN6S497C53v76Ev();
extern void _ZN6S497C53v77Ev();
extern void _ZN6S497C53v78Ev();
extern void _ZN6S497C53v79Ev();
extern void _ZN6S497C53v80Ev();
extern void _ZN6S497C43v81Ev();
extern void _ZN6S497C43v82Ev();
extern void _ZN6S497C43v83Ev();
extern void _ZN6S497C43v84Ev();
extern void _ZN6S497C43v85Ev();
extern void _ZN6S497C33v86Ev();
extern void _ZN6S497C33v87Ev();
extern void _ZN6S497C33v88Ev();
extern void _ZN6S497C33v89Ev();
extern void _ZN6S497C33v90Ev();
extern void _ZN6S497C33v91Ev();
extern void _ZN6S497C33v92Ev();
extern void _ZN6S497C33v93Ev();
extern void _ZN6S497C33v94Ev();
extern void _ZN6S497C33v95Ev();
extern void _ZN6S497C33v96Ev();
extern void _ZN6S497C33v97Ev();
extern void _ZN6S497C33v98Ev();
extern void _ZN6S497C33v99Ev();
extern void _ZN6S497C34v100Ev();
extern void _ZN6S497C34v101Ev();
extern void _ZN6S497C34v102Ev();
extern void _ZN6S497C34v103Ev();
extern void _ZN6S497C34v104Ev();
extern void _ZN6S497C34v105Ev();
extern void _ZN6S497C34v106Ev();
extern void _ZN6S497C34v107Ev();
static  VTBL_ENTRY vtc_S497C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S497C3[0]),
  (VTBL_ENTRY)&_ZN6S497C3D1Ev,
  (VTBL_ENTRY)&_ZN6S497C3D0Ev,
  (VTBL_ENTRY)&_ZN6S497C53v17Ev,
  (VTBL_ENTRY)&_ZN6S497C53v18Ev,
  (VTBL_ENTRY)&_ZN6S497C53v19Ev,
  (VTBL_ENTRY)&_ZN6S497C53v20Ev,
  (VTBL_ENTRY)&_ZN6S497C53v21Ev,
  (VTBL_ENTRY)&_ZN6S497C53v22Ev,
  (VTBL_ENTRY)&_ZN6S497C53v23Ev,
  (VTBL_ENTRY)&_ZN6S497C53v24Ev,
  (VTBL_ENTRY)&_ZN6S497C53v25Ev,
  (VTBL_ENTRY)&_ZN6S497C53v26Ev,
  (VTBL_ENTRY)&_ZN6S497C53v27Ev,
  (VTBL_ENTRY)&_ZN6S497C53v28Ev,
  (VTBL_ENTRY)&_ZN6S497C53v29Ev,
  (VTBL_ENTRY)&_ZN6S497C53v30Ev,
  (VTBL_ENTRY)&_ZN6S497C53v31Ev,
  (VTBL_ENTRY)&_ZN6S497C53v32Ev,
  (VTBL_ENTRY)&_ZN6S497C53v33Ev,
  (VTBL_ENTRY)&_ZN6S497C53v34Ev,
  (VTBL_ENTRY)&_ZN6S497C53v35Ev,
  (VTBL_ENTRY)&_ZN6S497C53v36Ev,
  (VTBL_ENTRY)&_ZN6S497C53v37Ev,
  (VTBL_ENTRY)&_ZN6S497C53v38Ev,
  (VTBL_ENTRY)&_ZN6S497C53v39Ev,
  (VTBL_ENTRY)&_ZN6S497C53v40Ev,
  (VTBL_ENTRY)&_ZN6S497C53v41Ev,
  (VTBL_ENTRY)&_ZN6S497C53v42Ev,
  (VTBL_ENTRY)&_ZN6S497C53v43Ev,
  (VTBL_ENTRY)&_ZN6S497C53v44Ev,
  (VTBL_ENTRY)&_ZN6S497C53v45Ev,
  (VTBL_ENTRY)&_ZN6S497C53v46Ev,
  (VTBL_ENTRY)&_ZN6S497C53v47Ev,
  (VTBL_ENTRY)&_ZN6S497C53v48Ev,
  (VTBL_ENTRY)&_ZN6S497C53v49Ev,
  (VTBL_ENTRY)&_ZN6S497C53v50Ev,
  (VTBL_ENTRY)&_ZN6S497C53v51Ev,
  (VTBL_ENTRY)&_ZN6S497C53v52Ev,
  (VTBL_ENTRY)&_ZN6S497C53v53Ev,
  (VTBL_ENTRY)&_ZN6S497C53v54Ev,
  (VTBL_ENTRY)&_ZN6S497C53v55Ev,
  (VTBL_ENTRY)&_ZN6S497C53v56Ev,
  (VTBL_ENTRY)&_ZN6S497C53v57Ev,
  (VTBL_ENTRY)&_ZN6S497C53v58Ev,
  (VTBL_ENTRY)&_ZN6S497C53v59Ev,
  (VTBL_ENTRY)&_ZN6S497C53v60Ev,
  (VTBL_ENTRY)&_ZN6S497C53v61Ev,
  (VTBL_ENTRY)&_ZN6S497C53v62Ev,
  (VTBL_ENTRY)&_ZN6S497C53v63Ev,
  (VTBL_ENTRY)&_ZN6S497C53v64Ev,
  (VTBL_ENTRY)&_ZN6S497C53v65Ev,
  (VTBL_ENTRY)&_ZN6S497C53v66Ev,
  (VTBL_ENTRY)&_ZN6S497C53v67Ev,
  (VTBL_ENTRY)&_ZN6S497C53v68Ev,
  (VTBL_ENTRY)&_ZN6S497C53v69Ev,
  (VTBL_ENTRY)&_ZN6S497C53v70Ev,
  (VTBL_ENTRY)&_ZN6S497C53v71Ev,
  (VTBL_ENTRY)&_ZN6S497C53v72Ev,
  (VTBL_ENTRY)&_ZN6S497C53v73Ev,
  (VTBL_ENTRY)&_ZN6S497C53v74Ev,
  (VTBL_ENTRY)&_ZN6S497C53v75Ev,
  (VTBL_ENTRY)&_ZN6S497C53v76Ev,
  (VTBL_ENTRY)&_ZN6S497C53v77Ev,
  (VTBL_ENTRY)&_ZN6S497C53v78Ev,
  (VTBL_ENTRY)&_ZN6S497C53v79Ev,
  (VTBL_ENTRY)&_ZN6S497C53v80Ev,
  (VTBL_ENTRY)&_ZN6S497C43v81Ev,
  (VTBL_ENTRY)&_ZN6S497C43v82Ev,
  (VTBL_ENTRY)&_ZN6S497C43v83Ev,
  (VTBL_ENTRY)&_ZN6S497C43v84Ev,
  (VTBL_ENTRY)&_ZN6S497C43v85Ev,
  (VTBL_ENTRY)&_ZN6S497C33v86Ev,
  (VTBL_ENTRY)&_ZN6S497C33v87Ev,
  (VTBL_ENTRY)&_ZN6S497C33v88Ev,
  (VTBL_ENTRY)&_ZN6S497C33v89Ev,
  (VTBL_ENTRY)&_ZN6S497C33v90Ev,
  (VTBL_ENTRY)&_ZN6S497C33v91Ev,
  (VTBL_ENTRY)&_ZN6S497C33v92Ev,
  (VTBL_ENTRY)&_ZN6S497C33v93Ev,
  (VTBL_ENTRY)&_ZN6S497C33v94Ev,
  (VTBL_ENTRY)&_ZN6S497C33v95Ev,
  (VTBL_ENTRY)&_ZN6S497C33v96Ev,
  (VTBL_ENTRY)&_ZN6S497C33v97Ev,
  (VTBL_ENTRY)&_ZN6S497C33v98Ev,
  (VTBL_ENTRY)&_ZN6S497C33v99Ev,
  (VTBL_ENTRY)&_ZN6S497C34v100Ev,
  (VTBL_ENTRY)&_ZN6S497C34v101Ev,
  (VTBL_ENTRY)&_ZN6S497C34v102Ev,
  (VTBL_ENTRY)&_ZN6S497C34v103Ev,
  (VTBL_ENTRY)&_ZN6S497C34v104Ev,
  (VTBL_ENTRY)&_ZN6S497C34v105Ev,
  (VTBL_ENTRY)&_ZN6S497C34v106Ev,
  (VTBL_ENTRY)&_ZN6S497C34v107Ev,
};
extern VTBL_ENTRY _ZTI6S497C3[];
extern  VTBL_ENTRY _ZTV6S497C3[];
Class_Descriptor cd_S497C3 = {  "S497C3", // class name
  bases_S497C3, 2,
  &(vtc_S497C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S497C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S497C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S497C2  : S497C3 {
  void *s497c2f0;
  ::S95C9_nt s497c2f1;
  int s497c2f2;
  ::S236C15_nt s497c2f3;
  int s497c2f4;
  ::S490C27 s497c2f5;
  int s497c2f6;
  void *s497c2f7[2];
  ::S95C13 s497c2f8;
  void *s497c2f9;
  int s497c2f10[2];
  char s497c2f11[3];
  int s497c2f12;
  unsigned int s497c2f13:1;
  unsigned int s497c2f14:1;
  unsigned int s497c2f15:1;
  unsigned int s497c2f16:1;
  unsigned int s497c2f17:1;
  unsigned int s497c2f18:1;
  unsigned int s497c2f19:1;
  unsigned int s497c2f20:1;
  unsigned int s497c2f21:1;
  unsigned int s497c2f22:1;
  unsigned int s497c2f23:1;
  unsigned int s497c2f24:1;
  unsigned int s497c2f25:1;
  unsigned int s497c2f26:1;
  int s497c2f27;
  unsigned int s497c2f28:1;
  unsigned int s497c2f29:1;
  unsigned int s497c2f30:1;
  unsigned int s497c2f31:1;
  unsigned int s497c2f32:1;
  unsigned int s497c2f33:1;
  ::S112C22_nt s497c2f34;
  unsigned int s497c2f35:1;
  unsigned int s497c2f36:1;
  unsigned int s497c2f37:1;
  unsigned int s497c2f38:1;
  unsigned int s497c2f39:1;
  unsigned int s497c2f40:1;
  unsigned int s497c2f41:1;
  char s497c2f42;
  ::S95C16 s497c2f43;
  unsigned int s497c2f44:1;
  unsigned int s497c2f45:1;
  unsigned int s497c2f46:1;
  unsigned int s497c2f47:1;
  unsigned int s497c2f48:1;
  unsigned int s497c2f49:1;
  unsigned int s497c2f50:1;
  unsigned int s497c2f51:1;
  unsigned int s497c2f52:1;
  unsigned int s497c2f53:1;
  unsigned int s497c2f54:1;
  unsigned int s497c2f55:1;
  ::S490C26 s497c2f56;
  void *s497c2f57[2];
  char s497c2f58;
  ::S236C15_nt s497c2f59;
  ::S236C18_nt s497c2f60;
  ::S95C14_nt s497c2f61;
  int s497c2f62;
  ::S236C18_nt s497c2f63;
  unsigned int s497c2f64:1;
  unsigned int s497c2f65:1;
  unsigned int s497c2f66:1;
  int s497c2f67[3];
  virtual  ~S497C2(); // _ZN6S497C2D1Ev
  virtual void  v108(); // _ZN6S497C24v108Ev
  virtual void  v109(); // _ZN6S497C24v109Ev
  virtual void  v110(); // _ZN6S497C24v110Ev
  virtual void  v111(); // _ZN6S497C24v111Ev
  virtual void  v112(); // _ZN6S497C24v112Ev
  virtual void  v113(); // _ZN6S497C24v113Ev
  virtual void  v114(); // _ZN6S497C24v114Ev
  virtual void  v115(); // _ZN6S497C24v115Ev
  virtual void  v116(); // _ZN6S497C24v116Ev
  virtual void  v117(); // _ZN6S497C24v117Ev
  virtual void  v118(); // _ZN6S497C24v118Ev
  virtual void  v119(); // _ZN6S497C24v119Ev
  virtual void  v120(); // _ZN6S497C24v120Ev
  virtual void  v121(); // _ZN6S497C24v121Ev
  virtual void  v122(); // _ZN6S497C24v122Ev
  virtual void  v123(); // _ZN6S497C24v123Ev
  virtual void  v124(); // _ZN6S497C24v124Ev
  virtual void  v125(); // _ZN6S497C24v125Ev
  virtual void  v126(); // _ZN6S497C24v126Ev
  virtual void  v127(); // _ZN6S497C24v127Ev
  virtual void  v128(); // _ZN6S497C24v128Ev
  virtual void  v129(); // _ZN6S497C24v129Ev
  virtual void  v130(); // _ZN6S497C24v130Ev
  virtual void  v131(); // _ZN6S497C24v131Ev
  virtual void  v132(); // _ZN6S497C24v132Ev
  virtual void  v133(); // _ZN6S497C24v133Ev
  virtual void  v134(); // _ZN6S497C24v134Ev
  virtual void  v135(); // _ZN6S497C24v135Ev
  virtual void  v136(); // _ZN6S497C24v136Ev
  virtual void  v137(); // _ZN6S497C24v137Ev
  virtual void  v138(); // _ZN6S497C24v138Ev
  virtual void  v139(); // _ZN6S497C24v139Ev
  virtual void  v140(); // _ZN6S497C24v140Ev
  virtual void  v141(); // _ZN6S497C24v141Ev
  virtual void  v142(); // _ZN6S497C24v142Ev
  virtual void  v143(); // _ZN6S497C24v143Ev
  virtual void  v144(); // _ZN6S497C24v144Ev
  virtual void  v145(); // _ZN6S497C24v145Ev
  virtual void  v146(); // _ZN6S497C24v146Ev
  virtual void  v147(); // _ZN6S497C24v147Ev
  virtual void  v148(); // _ZN6S497C24v148Ev
  virtual void  v149(); // _ZN6S497C24v149Ev
  virtual void  v150(); // _ZN6S497C24v150Ev
  virtual void  v151(); // _ZN6S497C24v151Ev
  virtual void  v152(); // _ZN6S497C24v152Ev
  virtual void  v153(); // _ZN6S497C24v153Ev
  virtual void  v154(); // _ZN6S497C24v154Ev
  virtual void  v155(); // _ZN6S497C24v155Ev
  virtual void  v156(); // _ZN6S497C24v156Ev
  virtual void  v157(); // _ZN6S497C24v157Ev
  virtual void  v158(); // _ZN6S497C24v158Ev
  virtual void  v159(); // _ZN6S497C24v159Ev
  virtual void  v160(); // _ZN6S497C24v160Ev
  virtual void  v161(); // _ZN6S497C24v161Ev
  virtual void  v162(); // _ZN6S497C24v162Ev
  virtual void  v163(); // _ZN6S497C24v163Ev
  virtual void  v164(); // _ZN6S497C24v164Ev
  virtual void  v165(); // _ZN6S497C24v165Ev
  virtual void  v166(); // _ZN6S497C24v166Ev
  virtual void  v167(); // _ZN6S497C24v167Ev
  virtual void  v168(); // _ZN6S497C24v168Ev
  S497C2(); // tgen
};
//SIG(-1 S497C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S497C2 ::~S497C2(){ note_dtor("S497C2", this);}
void  S497C2 ::v108(){vfunc_called(this, "_ZN6S497C24v108Ev");}
void  S497C2 ::v109(){vfunc_called(this, "_ZN6S497C24v109Ev");}
void  S497C2 ::v110(){vfunc_called(this, "_ZN6S497C24v110Ev");}
void  S497C2 ::v111(){vfunc_called(this, "_ZN6S497C24v111Ev");}
void  S497C2 ::v112(){vfunc_called(this, "_ZN6S497C24v112Ev");}
void  S497C2 ::v113(){vfunc_called(this, "_ZN6S497C24v113Ev");}
void  S497C2 ::v114(){vfunc_called(this, "_ZN6S497C24v114Ev");}
void  S497C2 ::v115(){vfunc_called(this, "_ZN6S497C24v115Ev");}
void  S497C2 ::v116(){vfunc_called(this, "_ZN6S497C24v116Ev");}
void  S497C2 ::v117(){vfunc_called(this, "_ZN6S497C24v117Ev");}
void  S497C2 ::v118(){vfunc_called(this, "_ZN6S497C24v118Ev");}
void  S497C2 ::v119(){vfunc_called(this, "_ZN6S497C24v119Ev");}
void  S497C2 ::v120(){vfunc_called(this, "_ZN6S497C24v120Ev");}
void  S497C2 ::v121(){vfunc_called(this, "_ZN6S497C24v121Ev");}
void  S497C2 ::v122(){vfunc_called(this, "_ZN6S497C24v122Ev");}
void  S497C2 ::v123(){vfunc_called(this, "_ZN6S497C24v123Ev");}
void  S497C2 ::v124(){vfunc_called(this, "_ZN6S497C24v124Ev");}
void  S497C2 ::v125(){vfunc_called(this, "_ZN6S497C24v125Ev");}
void  S497C2 ::v126(){vfunc_called(this, "_ZN6S497C24v126Ev");}
void  S497C2 ::v127(){vfunc_called(this, "_ZN6S497C24v127Ev");}
void  S497C2 ::v128(){vfunc_called(this, "_ZN6S497C24v128Ev");}
void  S497C2 ::v129(){vfunc_called(this, "_ZN6S497C24v129Ev");}
void  S497C2 ::v130(){vfunc_called(this, "_ZN6S497C24v130Ev");}
void  S497C2 ::v131(){vfunc_called(this, "_ZN6S497C24v131Ev");}
void  S497C2 ::v132(){vfunc_called(this, "_ZN6S497C24v132Ev");}
void  S497C2 ::v133(){vfunc_called(this, "_ZN6S497C24v133Ev");}
void  S497C2 ::v134(){vfunc_called(this, "_ZN6S497C24v134Ev");}
void  S497C2 ::v135(){vfunc_called(this, "_ZN6S497C24v135Ev");}
void  S497C2 ::v136(){vfunc_called(this, "_ZN6S497C24v136Ev");}
void  S497C2 ::v137(){vfunc_called(this, "_ZN6S497C24v137Ev");}
void  S497C2 ::v138(){vfunc_called(this, "_ZN6S497C24v138Ev");}
void  S497C2 ::v139(){vfunc_called(this, "_ZN6S497C24v139Ev");}
void  S497C2 ::v140(){vfunc_called(this, "_ZN6S497C24v140Ev");}
void  S497C2 ::v141(){vfunc_called(this, "_ZN6S497C24v141Ev");}
void  S497C2 ::v142(){vfunc_called(this, "_ZN6S497C24v142Ev");}
void  S497C2 ::v143(){vfunc_called(this, "_ZN6S497C24v143Ev");}
void  S497C2 ::v144(){vfunc_called(this, "_ZN6S497C24v144Ev");}
void  S497C2 ::v145(){vfunc_called(this, "_ZN6S497C24v145Ev");}
void  S497C2 ::v146(){vfunc_called(this, "_ZN6S497C24v146Ev");}
void  S497C2 ::v147(){vfunc_called(this, "_ZN6S497C24v147Ev");}
void  S497C2 ::v148(){vfunc_called(this, "_ZN6S497C24v148Ev");}
void  S497C2 ::v149(){vfunc_called(this, "_ZN6S497C24v149Ev");}
void  S497C2 ::v150(){vfunc_called(this, "_ZN6S497C24v150Ev");}
void  S497C2 ::v151(){vfunc_called(this, "_ZN6S497C24v151Ev");}
void  S497C2 ::v152(){vfunc_called(this, "_ZN6S497C24v152Ev");}
void  S497C2 ::v153(){vfunc_called(this, "_ZN6S497C24v153Ev");}
void  S497C2 ::v154(){vfunc_called(this, "_ZN6S497C24v154Ev");}
void  S497C2 ::v155(){vfunc_called(this, "_ZN6S497C24v155Ev");}
void  S497C2 ::v156(){vfunc_called(this, "_ZN6S497C24v156Ev");}
void  S497C2 ::v157(){vfunc_called(this, "_ZN6S497C24v157Ev");}
void  S497C2 ::v158(){vfunc_called(this, "_ZN6S497C24v158Ev");}
void  S497C2 ::v159(){vfunc_called(this, "_ZN6S497C24v159Ev");}
void  S497C2 ::v160(){vfunc_called(this, "_ZN6S497C24v160Ev");}
void  S497C2 ::v161(){vfunc_called(this, "_ZN6S497C24v161Ev");}
void  S497C2 ::v162(){vfunc_called(this, "_ZN6S497C24v162Ev");}
void  S497C2 ::v163(){vfunc_called(this, "_ZN6S497C24v163Ev");}
void  S497C2 ::v164(){vfunc_called(this, "_ZN6S497C24v164Ev");}
void  S497C2 ::v165(){vfunc_called(this, "_ZN6S497C24v165Ev");}
void  S497C2 ::v166(){vfunc_called(this, "_ZN6S497C24v166Ev");}
void  S497C2 ::v167(){vfunc_called(this, "_ZN6S497C24v167Ev");}
void  S497C2 ::v168(){vfunc_called(this, "_ZN6S497C24v168Ev");}
S497C2 ::S497C2(){ note_ctor("S497C2", this);} // tgen

static void Test_S497C2()
{
  extern Class_Descriptor cd_S497C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S497C2, buf);
    S497C2 *dp, &lv = *(dp=new (buf) S497C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S497C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S497C2)");
    check_base_class_offset(lv, (S497C5*)(S497C4*)(S497C3*), 0, "S497C2");
    check_base_class_offset(lv, (S497C4*)(S497C3*), 0, "S497C2");
    check_base_class_offset(lv, (S497C3*), 0, "S497C2");
    check_field_offset(lv, s497c2f0, ABISELECT(136,84), "S497C2.s497c2f0");
    check_field_offset(lv, s497c2f1, ABISELECT(144,88), "S497C2.s497c2f1");
    check_field_offset(lv, s497c2f2, ABISELECT(148,92), "S497C2.s497c2f2");
    check_field_offset(lv, s497c2f3, ABISELECT(152,96), "S497C2.s497c2f3");
    check_field_offset(lv, s497c2f4, ABISELECT(156,100), "S497C2.s497c2f4");
    check_field_offset(lv, s497c2f5, ABISELECT(160,104), "S497C2.s497c2f5");
    check_field_offset(lv, s497c2f6, ABISELECT(176,116), "S497C2.s497c2f6");
    check_field_offset(lv, s497c2f7, ABISELECT(184,120), "S497C2.s497c2f7");
    check_field_offset(lv, s497c2f8, ABISELECT(200,128), "S497C2.s497c2f8");
    check_field_offset(lv, s497c2f9, ABISELECT(232,156), "S497C2.s497c2f9");
    check_field_offset(lv, s497c2f10, ABISELECT(240,160), "S497C2.s497c2f10");
    check_field_offset(lv, s497c2f11, ABISELECT(248,168), "S497C2.s497c2f11");
    check_field_offset(lv, s497c2f12, ABISELECT(252,172), "S497C2.s497c2f12");
    set_bf_and_test(lv, s497c2f13, ABISELECT(256,176), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f14, ABISELECT(256,176), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f15, ABISELECT(256,176), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f16, ABISELECT(256,176), 3, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f17, ABISELECT(256,176), 4, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f18, ABISELECT(256,176), 5, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f19, ABISELECT(256,176), 6, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f20, ABISELECT(256,176), 7, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f21, ABISELECT(257,177), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f22, ABISELECT(257,177), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f23, ABISELECT(257,177), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f24, ABISELECT(257,177), 3, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f25, ABISELECT(257,177), 4, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f26, ABISELECT(257,177), 5, 1, 1, "S497C2");
    check_field_offset(lv, s497c2f27, ABISELECT(260,180), "S497C2.s497c2f27");
    set_bf_and_test(lv, s497c2f28, ABISELECT(264,184), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f29, ABISELECT(264,184), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f30, ABISELECT(264,184), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f31, ABISELECT(264,184), 3, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f32, ABISELECT(264,184), 4, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f33, ABISELECT(264,184), 5, 1, 1, "S497C2");
    check_field_offset(lv, s497c2f34, ABISELECT(265,185), "S497C2.s497c2f34");
    set_bf_and_test(lv, s497c2f35, ABISELECT(266,186), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f36, ABISELECT(266,186), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f37, ABISELECT(266,186), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f38, ABISELECT(266,186), 3, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f39, ABISELECT(266,186), 4, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f40, ABISELECT(266,186), 5, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f41, ABISELECT(266,186), 6, 1, 1, "S497C2");
    check_field_offset(lv, s497c2f42, ABISELECT(267,187), "S497C2.s497c2f42");
    check_field_offset(lv, s497c2f43, ABISELECT(268,188), "S497C2.s497c2f43");
    set_bf_and_test(lv, s497c2f44, ABISELECT(269,189), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f45, ABISELECT(269,189), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f46, ABISELECT(269,189), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f47, ABISELECT(269,189), 3, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f48, ABISELECT(269,189), 4, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f49, ABISELECT(269,189), 5, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f50, ABISELECT(269,189), 6, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f51, ABISELECT(269,189), 7, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f52, ABISELECT(270,190), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f53, ABISELECT(270,190), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f54, ABISELECT(270,190), 2, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f55, ABISELECT(270,190), 3, 1, 1, "S497C2");
    check_field_offset(lv, s497c2f56, ABISELECT(272,192), "S497C2.s497c2f56");
    check_field_offset(lv, s497c2f57, ABISELECT(288,204), "S497C2.s497c2f57");
    check_field_offset(lv, s497c2f58, ABISELECT(304,212), "S497C2.s497c2f58");
    check_field_offset(lv, s497c2f59, ABISELECT(305,213), "S497C2.s497c2f59");
    check_field_offset(lv, s497c2f60, ABISELECT(308,216), "S497C2.s497c2f60");
    check_field_offset(lv, s497c2f61, ABISELECT(320,228), "S497C2.s497c2f61");
    check_field_offset(lv, s497c2f62, ABISELECT(332,240), "S497C2.s497c2f62");
    check_field_offset(lv, s497c2f63, ABISELECT(336,244), "S497C2.s497c2f63");
    set_bf_and_test(lv, s497c2f64, ABISELECT(348,256), 0, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f65, ABISELECT(348,256), 1, 1, 1, "S497C2");
    set_bf_and_test(lv, s497c2f66, ABISELECT(348,256), 2, 1, 1, "S497C2");
    check_field_offset(lv, s497c2f67, ABISELECT(352,260), "S497C2.s497c2f67");
    test_class_info(&lv, &cd_S497C2);
    dp->~S497C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS497C2(Test_S497C2, "S497C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S497C2C1Ev();
extern void _ZN6S497C2D1Ev();
Name_Map name_map_S497C2[] = {
  NSPAIR(_ZN6S497C2C1Ev),
  NSPAIR(_ZN6S497C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S497C5;
extern VTBL_ENTRY _ZTI6S497C5[];
extern  VTBL_ENTRY _ZTV6S497C5[];
extern Class_Descriptor cd_S497C4;
extern VTBL_ENTRY _ZTI6S497C4[];
extern  VTBL_ENTRY _ZTV6S497C4[];
extern Class_Descriptor cd_S497C3;
extern VTBL_ENTRY _ZTI6S497C3[];
extern  VTBL_ENTRY _ZTV6S497C3[];
static Base_Class bases_S497C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S497C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S497C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S497C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S497C2[];
extern void _ZN6S497C2D1Ev();
extern void _ZN6S497C2D0Ev();
extern void _ZN6S497C53v17Ev();
extern void _ZN6S497C53v18Ev();
extern void _ZN6S497C53v19Ev();
extern void _ZN6S497C53v20Ev();
extern void _ZN6S497C53v21Ev();
extern void _ZN6S497C53v22Ev();
extern void _ZN6S497C53v23Ev();
extern void _ZN6S497C53v24Ev();
extern void _ZN6S497C53v25Ev();
extern void _ZN6S497C53v26Ev();
extern void _ZN6S497C53v27Ev();
extern void _ZN6S497C53v28Ev();
extern void _ZN6S497C53v29Ev();
extern void _ZN6S497C53v30Ev();
extern void _ZN6S497C53v31Ev();
extern void _ZN6S497C53v32Ev();
extern void _ZN6S497C53v33Ev();
extern void _ZN6S497C53v34Ev();
extern void _ZN6S497C53v35Ev();
extern void _ZN6S497C53v36Ev();
extern void _ZN6S497C53v37Ev();
extern void _ZN6S497C53v38Ev();
extern void _ZN6S497C53v39Ev();
extern void _ZN6S497C53v40Ev();
extern void _ZN6S497C53v41Ev();
extern void _ZN6S497C53v42Ev();
extern void _ZN6S497C53v43Ev();
extern void _ZN6S497C53v44Ev();
extern void _ZN6S497C53v45Ev();
extern void _ZN6S497C53v46Ev();
extern void _ZN6S497C53v47Ev();
extern void _ZN6S497C53v48Ev();
extern void _ZN6S497C53v49Ev();
extern void _ZN6S497C53v50Ev();
extern void _ZN6S497C53v51Ev();
extern void _ZN6S497C53v52Ev();
extern void _ZN6S497C53v53Ev();
extern void _ZN6S497C53v54Ev();
extern void _ZN6S497C53v55Ev();
extern void _ZN6S497C53v56Ev();
extern void _ZN6S497C53v57Ev();
extern void _ZN6S497C53v58Ev();
extern void _ZN6S497C53v59Ev();
extern void _ZN6S497C53v60Ev();
extern void _ZN6S497C53v61Ev();
extern void _ZN6S497C53v62Ev();
extern void _ZN6S497C53v63Ev();
extern void _ZN6S497C53v64Ev();
extern void _ZN6S497C53v65Ev();
extern void _ZN6S497C53v66Ev();
extern void _ZN6S497C53v67Ev();
extern void _ZN6S497C53v68Ev();
extern void _ZN6S497C53v69Ev();
extern void _ZN6S497C53v70Ev();
extern void _ZN6S497C53v71Ev();
extern void _ZN6S497C53v72Ev();
extern void _ZN6S497C53v73Ev();
extern void _ZN6S497C53v74Ev();
extern void _ZN6S497C53v75Ev();
extern void _ZN6S497C53v76Ev();
extern void _ZN6S497C53v77Ev();
extern void _ZN6S497C53v78Ev();
extern void _ZN6S497C53v79Ev();
extern void _ZN6S497C53v80Ev();
extern void _ZN6S497C43v81Ev();
extern void _ZN6S497C43v82Ev();
extern void _ZN6S497C43v83Ev();
extern void _ZN6S497C43v84Ev();
extern void _ZN6S497C43v85Ev();
extern void _ZN6S497C33v86Ev();
extern void _ZN6S497C33v87Ev();
extern void _ZN6S497C33v88Ev();
extern void _ZN6S497C33v89Ev();
extern void _ZN6S497C33v90Ev();
extern void _ZN6S497C33v91Ev();
extern void _ZN6S497C33v92Ev();
extern void _ZN6S497C33v93Ev();
extern void _ZN6S497C33v94Ev();
extern void _ZN6S497C33v95Ev();
extern void _ZN6S497C33v96Ev();
extern void _ZN6S497C33v97Ev();
extern void _ZN6S497C33v98Ev();
extern void _ZN6S497C33v99Ev();
extern void _ZN6S497C34v100Ev();
extern void _ZN6S497C34v101Ev();
extern void _ZN6S497C34v102Ev();
extern void _ZN6S497C34v103Ev();
extern void _ZN6S497C34v104Ev();
extern void _ZN6S497C34v105Ev();
extern void _ZN6S497C34v106Ev();
extern void _ZN6S497C34v107Ev();
extern void _ZN6S497C24v108Ev();
extern void _ZN6S497C24v109Ev();
extern void _ZN6S497C24v110Ev();
extern void _ZN6S497C24v111Ev();
extern void _ZN6S497C24v112Ev();
extern void _ZN6S497C24v113Ev();
extern void _ZN6S497C24v114Ev();
extern void _ZN6S497C24v115Ev();
extern void _ZN6S497C24v116Ev();
extern void _ZN6S497C24v117Ev();
extern void _ZN6S497C24v118Ev();
extern void _ZN6S497C24v119Ev();
extern void _ZN6S497C24v120Ev();
extern void _ZN6S497C24v121Ev();
extern void _ZN6S497C24v122Ev();
extern void _ZN6S497C24v123Ev();
extern void _ZN6S497C24v124Ev();
extern void _ZN6S497C24v125Ev();
extern void _ZN6S497C24v126Ev();
extern void _ZN6S497C24v127Ev();
extern void _ZN6S497C24v128Ev();
extern void _ZN6S497C24v129Ev();
extern void _ZN6S497C24v130Ev();
extern void _ZN6S497C24v131Ev();
extern void _ZN6S497C24v132Ev();
extern void _ZN6S497C24v133Ev();
extern void _ZN6S497C24v134Ev();
extern void _ZN6S497C24v135Ev();
extern void _ZN6S497C24v136Ev();
extern void _ZN6S497C24v137Ev();
extern void _ZN6S497C24v138Ev();
extern void _ZN6S497C24v139Ev();
extern void _ZN6S497C24v140Ev();
extern void _ZN6S497C24v141Ev();
extern void _ZN6S497C24v142Ev();
extern void _ZN6S497C24v143Ev();
extern void _ZN6S497C24v144Ev();
extern void _ZN6S497C24v145Ev();
extern void _ZN6S497C24v146Ev();
extern void _ZN6S497C24v147Ev();
extern void _ZN6S497C24v148Ev();
extern void _ZN6S497C24v149Ev();
extern void _ZN6S497C24v150Ev();
extern void _ZN6S497C24v151Ev();
extern void _ZN6S497C24v152Ev();
extern void _ZN6S497C24v153Ev();
extern void _ZN6S497C24v154Ev();
extern void _ZN6S497C24v155Ev();
extern void _ZN6S497C24v156Ev();
extern void _ZN6S497C24v157Ev();
extern void _ZN6S497C24v158Ev();
extern void _ZN6S497C24v159Ev();
extern void _ZN6S497C24v160Ev();
extern void _ZN6S497C24v161Ev();
extern void _ZN6S497C24v162Ev();
extern void _ZN6S497C24v163Ev();
extern void _ZN6S497C24v164Ev();
extern void _ZN6S497C24v165Ev();
extern void _ZN6S497C24v166Ev();
extern void _ZN6S497C24v167Ev();
extern void _ZN6S497C24v168Ev();
static  VTBL_ENTRY vtc_S497C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S497C2[0]),
  (VTBL_ENTRY)&_ZN6S497C2D1Ev,
  (VTBL_ENTRY)&_ZN6S497C2D0Ev,
  (VTBL_ENTRY)&_ZN6S497C53v17Ev,
  (VTBL_ENTRY)&_ZN6S497C53v18Ev,
  (VTBL_ENTRY)&_ZN6S497C53v19Ev,
  (VTBL_ENTRY)&_ZN6S497C53v20Ev,
  (VTBL_ENTRY)&_ZN6S497C53v21Ev,
  (VTBL_ENTRY)&_ZN6S497C53v22Ev,
  (VTBL_ENTRY)&_ZN6S497C53v23Ev,
  (VTBL_ENTRY)&_ZN6S497C53v24Ev,
  (VTBL_ENTRY)&_ZN6S497C53v25Ev,
  (VTBL_ENTRY)&_ZN6S497C53v26Ev,
  (VTBL_ENTRY)&_ZN6S497C53v27Ev,
  (VTBL_ENTRY)&_ZN6S497C53v28Ev,
  (VTBL_ENTRY)&_ZN6S497C53v29Ev,
  (VTBL_ENTRY)&_ZN6S497C53v30Ev,
  (VTBL_ENTRY)&_ZN6S497C53v31Ev,
  (VTBL_ENTRY)&_ZN6S497C53v32Ev,
  (VTBL_ENTRY)&_ZN6S497C53v33Ev,
  (VTBL_ENTRY)&_ZN6S497C53v34Ev,
  (VTBL_ENTRY)&_ZN6S497C53v35Ev,
  (VTBL_ENTRY)&_ZN6S497C53v36Ev,
  (VTBL_ENTRY)&_ZN6S497C53v37Ev,
  (VTBL_ENTRY)&_ZN6S497C53v38Ev,
  (VTBL_ENTRY)&_ZN6S497C53v39Ev,
  (VTBL_ENTRY)&_ZN6S497C53v40Ev,
  (VTBL_ENTRY)&_ZN6S497C53v41Ev,
  (VTBL_ENTRY)&_ZN6S497C53v42Ev,
  (VTBL_ENTRY)&_ZN6S497C53v43Ev,
  (VTBL_ENTRY)&_ZN6S497C53v44Ev,
  (VTBL_ENTRY)&_ZN6S497C53v45Ev,
  (VTBL_ENTRY)&_ZN6S497C53v46Ev,
  (VTBL_ENTRY)&_ZN6S497C53v47Ev,
  (VTBL_ENTRY)&_ZN6S497C53v48Ev,
  (VTBL_ENTRY)&_ZN6S497C53v49Ev,
  (VTBL_ENTRY)&_ZN6S497C53v50Ev,
  (VTBL_ENTRY)&_ZN6S497C53v51Ev,
  (VTBL_ENTRY)&_ZN6S497C53v52Ev,
  (VTBL_ENTRY)&_ZN6S497C53v53Ev,
  (VTBL_ENTRY)&_ZN6S497C53v54Ev,
  (VTBL_ENTRY)&_ZN6S497C53v55Ev,
  (VTBL_ENTRY)&_ZN6S497C53v56Ev,
  (VTBL_ENTRY)&_ZN6S497C53v57Ev,
  (VTBL_ENTRY)&_ZN6S497C53v58Ev,
  (VTBL_ENTRY)&_ZN6S497C53v59Ev,
  (VTBL_ENTRY)&_ZN6S497C53v60Ev,
  (VTBL_ENTRY)&_ZN6S497C53v61Ev,
  (VTBL_ENTRY)&_ZN6S497C53v62Ev,
  (VTBL_ENTRY)&_ZN6S497C53v63Ev,
  (VTBL_ENTRY)&_ZN6S497C53v64Ev,
  (VTBL_ENTRY)&_ZN6S497C53v65Ev,
  (VTBL_ENTRY)&_ZN6S497C53v66Ev,
  (VTBL_ENTRY)&_ZN6S497C53v67Ev,
  (VTBL_ENTRY)&_ZN6S497C53v68Ev,
  (VTBL_ENTRY)&_ZN6S497C53v69Ev,
  (VTBL_ENTRY)&_ZN6S497C53v70Ev,
  (VTBL_ENTRY)&_ZN6S497C53v71Ev,
  (VTBL_ENTRY)&_ZN6S497C53v72Ev,
  (VTBL_ENTRY)&_ZN6S497C53v73Ev,
  (VTBL_ENTRY)&_ZN6S497C53v74Ev,
  (VTBL_ENTRY)&_ZN6S497C53v75Ev,
  (VTBL_ENTRY)&_ZN6S497C53v76Ev,
  (VTBL_ENTRY)&_ZN6S497C53v77Ev,
  (VTBL_ENTRY)&_ZN6S497C53v78Ev,
  (VTBL_ENTRY)&_ZN6S497C53v79Ev,
  (VTBL_ENTRY)&_ZN6S497C53v80Ev,
  (VTBL_ENTRY)&_ZN6S497C43v81Ev,
  (VTBL_ENTRY)&_ZN6S497C43v82Ev,
  (VTBL_ENTRY)&_ZN6S497C43v83Ev,
  (VTBL_ENTRY)&_ZN6S497C43v84Ev,
  (VTBL_ENTRY)&_ZN6S497C43v85Ev,
  (VTBL_ENTRY)&_ZN6S497C33v86Ev,
  (VTBL_ENTRY)&_ZN6S497C33v87Ev,
  (VTBL_ENTRY)&_ZN6S497C33v88Ev,
  (VTBL_ENTRY)&_ZN6S497C33v89Ev,
  (VTBL_ENTRY)&_ZN6S497C33v90Ev,
  (VTBL_ENTRY)&_ZN6S497C33v91Ev,
  (VTBL_ENTRY)&_ZN6S497C33v92Ev,
  (VTBL_ENTRY)&_ZN6S497C33v93Ev,
  (VTBL_ENTRY)&_ZN6S497C33v94Ev,
  (VTBL_ENTRY)&_ZN6S497C33v95Ev,
  (VTBL_ENTRY)&_ZN6S497C33v96Ev,
  (VTBL_ENTRY)&_ZN6S497C33v97Ev,
  (VTBL_ENTRY)&_ZN6S497C33v98Ev,
  (VTBL_ENTRY)&_ZN6S497C33v99Ev,
  (VTBL_ENTRY)&_ZN6S497C34v100Ev,
  (VTBL_ENTRY)&_ZN6S497C34v101Ev,
  (VTBL_ENTRY)&_ZN6S497C34v102Ev,
  (VTBL_ENTRY)&_ZN6S497C34v103Ev,
  (VTBL_ENTRY)&_ZN6S497C34v104Ev,
  (VTBL_ENTRY)&_ZN6S497C34v105Ev,
  (VTBL_ENTRY)&_ZN6S497C34v106Ev,
  (VTBL_ENTRY)&_ZN6S497C34v107Ev,
  (VTBL_ENTRY)&_ZN6S497C24v108Ev,
  (VTBL_ENTRY)&_ZN6S497C24v109Ev,
  (VTBL_ENTRY)&_ZN6S497C24v110Ev,
  (VTBL_ENTRY)&_ZN6S497C24v111Ev,
  (VTBL_ENTRY)&_ZN6S497C24v112Ev,
  (VTBL_ENTRY)&_ZN6S497C24v113Ev,
  (VTBL_ENTRY)&_ZN6S497C24v114Ev,
  (VTBL_ENTRY)&_ZN6S497C24v115Ev,
  (VTBL_ENTRY)&_ZN6S497C24v116Ev,
  (VTBL_ENTRY)&_ZN6S497C24v117Ev,
  (VTBL_ENTRY)&_ZN6S497C24v118Ev,
  (VTBL_ENTRY)&_ZN6S497C24v119Ev,
  (VTBL_ENTRY)&_ZN6S497C24v120Ev,
  (VTBL_ENTRY)&_ZN6S497C24v121Ev,
  (VTBL_ENTRY)&_ZN6S497C24v122Ev,
  (VTBL_ENTRY)&_ZN6S497C24v123Ev,
  (VTBL_ENTRY)&_ZN6S497C24v124Ev,
  (VTBL_ENTRY)&_ZN6S497C24v125Ev,
  (VTBL_ENTRY)&_ZN6S497C24v126Ev,
  (VTBL_ENTRY)&_ZN6S497C24v127Ev,
  (VTBL_ENTRY)&_ZN6S497C24v128Ev,
  (VTBL_ENTRY)&_ZN6S497C24v129Ev,
  (VTBL_ENTRY)&_ZN6S497C24v130Ev,
  (VTBL_ENTRY)&_ZN6S497C24v131Ev,
  (VTBL_ENTRY)&_ZN6S497C24v132Ev,
  (VTBL_ENTRY)&_ZN6S497C24v133Ev,
  (VTBL_ENTRY)&_ZN6S497C24v134Ev,
  (VTBL_ENTRY)&_ZN6S497C24v135Ev,
  (VTBL_ENTRY)&_ZN6S497C24v136Ev,
  (VTBL_ENTRY)&_ZN6S497C24v137Ev,
  (VTBL_ENTRY)&_ZN6S497C24v138Ev,
  (VTBL_ENTRY)&_ZN6S497C24v139Ev,
  (VTBL_ENTRY)&_ZN6S497C24v140Ev,
  (VTBL_ENTRY)&_ZN6S497C24v141Ev,
  (VTBL_ENTRY)&_ZN6S497C24v142Ev,
  (VTBL_ENTRY)&_ZN6S497C24v143Ev,
  (VTBL_ENTRY)&_ZN6S497C24v144Ev,
  (VTBL_ENTRY)&_ZN6S497C24v145Ev,
  (VTBL_ENTRY)&_ZN6S497C24v146Ev,
  (VTBL_ENTRY)&_ZN6S497C24v147Ev,
  (VTBL_ENTRY)&_ZN6S497C24v148Ev,
  (VTBL_ENTRY)&_ZN6S497C24v149Ev,
  (VTBL_ENTRY)&_ZN6S497C24v150Ev,
  (VTBL_ENTRY)&_ZN6S497C24v151Ev,
  (VTBL_ENTRY)&_ZN6S497C24v152Ev,
  (VTBL_ENTRY)&_ZN6S497C24v153Ev,
  (VTBL_ENTRY)&_ZN6S497C24v154Ev,
  (VTBL_ENTRY)&_ZN6S497C24v155Ev,
  (VTBL_ENTRY)&_ZN6S497C24v156Ev,
  (VTBL_ENTRY)&_ZN6S497C24v157Ev,
  (VTBL_ENTRY)&_ZN6S497C24v158Ev,
  (VTBL_ENTRY)&_ZN6S497C24v159Ev,
  (VTBL_ENTRY)&_ZN6S497C24v160Ev,
  (VTBL_ENTRY)&_ZN6S497C24v161Ev,
  (VTBL_ENTRY)&_ZN6S497C24v162Ev,
  (VTBL_ENTRY)&_ZN6S497C24v163Ev,
  (VTBL_ENTRY)&_ZN6S497C24v164Ev,
  (VTBL_ENTRY)&_ZN6S497C24v165Ev,
  (VTBL_ENTRY)&_ZN6S497C24v166Ev,
  (VTBL_ENTRY)&_ZN6S497C24v167Ev,
  (VTBL_ENTRY)&_ZN6S497C24v168Ev,
};
extern VTBL_ENTRY _ZTI6S497C2[];
extern  VTBL_ENTRY _ZTV6S497C2[];
Class_Descriptor cd_S497C2 = {  "S497C2", // class name
  bases_S497C2, 3,
  &(vtc_S497C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S497C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S497C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S497C1  : S497C2 {
  void *s497c1f0;
  unsigned int s497c1f1:1;
  unsigned int s497c1f2:1;
  unsigned int s497c1f3:1;
  unsigned int s497c1f4:1;
  int s497c1f5[3];
  void *s497c1f6[5];
  ::S236C25_nt s497c1f7;
  ::S513C20_nt s497c1f8;
  ::S513C20_nt s497c1f9;
  ::S513C20_nt s497c1f10;
  ::S513C20_nt s497c1f11;
  ::S236C15_nt s497c1f12;
  int s497c1f13;
  virtual  ~S497C1(); // _ZN6S497C1D1Ev
  virtual void  v1(); // _ZN6S497C12v1Ev
  virtual void  v2(); // _ZN6S497C12v2Ev
  virtual void  v3(); // _ZN6S497C12v3Ev
  virtual void  v4(); // _ZN6S497C12v4Ev
  virtual void  v5(); // _ZN6S497C12v5Ev
  virtual void  v6(); // _ZN6S497C12v6Ev
  virtual void  v7(); // _ZN6S497C12v7Ev
  virtual void  v8(); // _ZN6S497C12v8Ev
  virtual void  v9(); // _ZN6S497C12v9Ev
  virtual void  v10(); // _ZN6S497C13v10Ev
  virtual void  v11(); // _ZN6S497C13v11Ev
  virtual void  v12(); // _ZN6S497C13v12Ev
  virtual void  v13(); // _ZN6S497C13v13Ev
  virtual void  v14(); // _ZN6S497C13v14Ev
  virtual void  v15(); // _ZN6S497C13v15Ev
  virtual void  v16(); // _ZN6S497C13v16Ev
  S497C1(); // tgen
};
//SIG(1 S497C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84 v85 Fp FC6} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] Fp[5] FC17{ BC18{ BC10}} FC19{ m Fp} FC19 FC19 FC19 FC8 Fi}


 S497C1 ::~S497C1(){ note_dtor("S497C1", this);}
void  S497C1 ::v1(){vfunc_called(this, "_ZN6S497C12v1Ev");}
void  S497C1 ::v2(){vfunc_called(this, "_ZN6S497C12v2Ev");}
void  S497C1 ::v3(){vfunc_called(this, "_ZN6S497C12v3Ev");}
void  S497C1 ::v4(){vfunc_called(this, "_ZN6S497C12v4Ev");}
void  S497C1 ::v5(){vfunc_called(this, "_ZN6S497C12v5Ev");}
void  S497C1 ::v6(){vfunc_called(this, "_ZN6S497C12v6Ev");}
void  S497C1 ::v7(){vfunc_called(this, "_ZN6S497C12v7Ev");}
void  S497C1 ::v8(){vfunc_called(this, "_ZN6S497C12v8Ev");}
void  S497C1 ::v9(){vfunc_called(this, "_ZN6S497C12v9Ev");}
void  S497C1 ::v10(){vfunc_called(this, "_ZN6S497C13v10Ev");}
void  S497C1 ::v11(){vfunc_called(this, "_ZN6S497C13v11Ev");}
void  S497C1 ::v12(){vfunc_called(this, "_ZN6S497C13v12Ev");}
void  S497C1 ::v13(){vfunc_called(this, "_ZN6S497C13v13Ev");}
void  S497C1 ::v14(){vfunc_called(this, "_ZN6S497C13v14Ev");}
void  S497C1 ::v15(){vfunc_called(this, "_ZN6S497C13v15Ev");}
void  S497C1 ::v16(){vfunc_called(this, "_ZN6S497C13v16Ev");}
S497C1 ::S497C1(){ note_ctor("S497C1", this);} // tgen

static void Test_S497C1()
{
  extern Class_Descriptor cd_S497C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(62,88)];
    init_test(&cd_S497C1, buf);
    S497C1 *dp, &lv = *(dp=new (buf) S497C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(488,348), "sizeof(S497C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S497C1)");
    check_base_class_offset(lv, (S497C5*)(S497C4*)(S497C3*)(S497C2*), 0, "S497C1");
    check_base_class_offset(lv, (S497C4*)(S497C3*)(S497C2*), 0, "S497C1");
    check_base_class_offset(lv, (S497C3*)(S497C2*), 0, "S497C1");
    check_base_class_offset(lv, (S497C2*), 0, "S497C1");
    check_field_offset(lv, s497c1f0, ABISELECT(368,272), "S497C1.s497c1f0");
    set_bf_and_test(lv, s497c1f1, ABISELECT(376,276), 0, 1, 1, "S497C1");
    set_bf_and_test(lv, s497c1f2, ABISELECT(376,276), 1, 1, 1, "S497C1");
    set_bf_and_test(lv, s497c1f3, ABISELECT(376,276), 2, 1, 1, "S497C1");
    set_bf_and_test(lv, s497c1f4, ABISELECT(376,276), 3, 1, 1, "S497C1");
    check_field_offset(lv, s497c1f5, ABISELECT(380,280), "S497C1.s497c1f5");
    check_field_offset(lv, s497c1f6, ABISELECT(392,292), "S497C1.s497c1f6");
    check_field_offset(lv, s497c1f7, ABISELECT(432,312), "S497C1.s497c1f7");
    check_field_offset(lv, s497c1f8, ABISELECT(448,324), "S497C1.s497c1f8");
    check_field_offset(lv, s497c1f9, ABISELECT(456,328), "S497C1.s497c1f9");
    check_field_offset(lv, s497c1f10, ABISELECT(464,332), "S497C1.s497c1f10");
    check_field_offset(lv, s497c1f11, ABISELECT(472,336), "S497C1.s497c1f11");
    check_field_offset(lv, s497c1f12, ABISELECT(480,340), "S497C1.s497c1f12");
    check_field_offset(lv, s497c1f13, ABISELECT(484,344), "S497C1.s497c1f13");
    test_class_info(&lv, &cd_S497C1);
    dp->~S497C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS497C1(Test_S497C1, "S497C1", ABISELECT(488,348));

#else // __cplusplus

extern void _ZN6S497C1C1Ev();
extern void _ZN6S497C1D1Ev();
Name_Map name_map_S497C1[] = {
  NSPAIR(_ZN6S497C1C1Ev),
  NSPAIR(_ZN6S497C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S497C5;
extern VTBL_ENTRY _ZTI6S497C5[];
extern  VTBL_ENTRY _ZTV6S497C5[];
extern Class_Descriptor cd_S497C4;
extern VTBL_ENTRY _ZTI6S497C4[];
extern  VTBL_ENTRY _ZTV6S497C4[];
extern Class_Descriptor cd_S497C3;
extern VTBL_ENTRY _ZTI6S497C3[];
extern  VTBL_ENTRY _ZTV6S497C3[];
extern Class_Descriptor cd_S497C2;
extern VTBL_ENTRY _ZTI6S497C2[];
extern  VTBL_ENTRY _ZTV6S497C2[];
static Base_Class bases_S497C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S497C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S497C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S497C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S497C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S497C1[];
extern void _ZN6S497C1D1Ev();
extern void _ZN6S497C1D0Ev();
extern void _ZN6S497C53v17Ev();
extern void _ZN6S497C53v18Ev();
extern void _ZN6S497C53v19Ev();
extern void _ZN6S497C53v20Ev();
extern void _ZN6S497C53v21Ev();
extern void _ZN6S497C53v22Ev();
extern void _ZN6S497C53v23Ev();
extern void _ZN6S497C53v24Ev();
extern void _ZN6S497C53v25Ev();
extern void _ZN6S497C53v26Ev();
extern void _ZN6S497C53v27Ev();
extern void _ZN6S497C53v28Ev();
extern void _ZN6S497C53v29Ev();
extern void _ZN6S497C53v30Ev();
extern void _ZN6S497C53v31Ev();
extern void _ZN6S497C53v32Ev();
extern void _ZN6S497C53v33Ev();
extern void _ZN6S497C53v34Ev();
extern void _ZN6S497C53v35Ev();
extern void _ZN6S497C53v36Ev();
extern void _ZN6S497C53v37Ev();
extern void _ZN6S497C53v38Ev();
extern void _ZN6S497C53v39Ev();
extern void _ZN6S497C53v40Ev();
extern void _ZN6S497C53v41Ev();
extern void _ZN6S497C53v42Ev();
extern void _ZN6S497C53v43Ev();
extern void _ZN6S497C53v44Ev();
extern void _ZN6S497C53v45Ev();
extern void _ZN6S497C53v46Ev();
extern void _ZN6S497C53v47Ev();
extern void _ZN6S497C53v48Ev();
extern void _ZN6S497C53v49Ev();
extern void _ZN6S497C53v50Ev();
extern void _ZN6S497C53v51Ev();
extern void _ZN6S497C53v52Ev();
extern void _ZN6S497C53v53Ev();
extern void _ZN6S497C53v54Ev();
extern void _ZN6S497C53v55Ev();
extern void _ZN6S497C53v56Ev();
extern void _ZN6S497C53v57Ev();
extern void _ZN6S497C53v58Ev();
extern void _ZN6S497C53v59Ev();
extern void _ZN6S497C53v60Ev();
extern void _ZN6S497C53v61Ev();
extern void _ZN6S497C53v62Ev();
extern void _ZN6S497C53v63Ev();
extern void _ZN6S497C53v64Ev();
extern void _ZN6S497C53v65Ev();
extern void _ZN6S497C53v66Ev();
extern void _ZN6S497C53v67Ev();
extern void _ZN6S497C53v68Ev();
extern void _ZN6S497C53v69Ev();
extern void _ZN6S497C53v70Ev();
extern void _ZN6S497C53v71Ev();
extern void _ZN6S497C53v72Ev();
extern void _ZN6S497C53v73Ev();
extern void _ZN6S497C53v74Ev();
extern void _ZN6S497C53v75Ev();
extern void _ZN6S497C53v76Ev();
extern void _ZN6S497C53v77Ev();
extern void _ZN6S497C53v78Ev();
extern void _ZN6S497C53v79Ev();
extern void _ZN6S497C53v80Ev();
extern void _ZN6S497C43v81Ev();
extern void _ZN6S497C43v82Ev();
extern void _ZN6S497C43v83Ev();
extern void _ZN6S497C43v84Ev();
extern void _ZN6S497C43v85Ev();
extern void _ZN6S497C33v86Ev();
extern void _ZN6S497C33v87Ev();
extern void _ZN6S497C33v88Ev();
extern void _ZN6S497C33v89Ev();
extern void _ZN6S497C33v90Ev();
extern void _ZN6S497C33v91Ev();
extern void _ZN6S497C33v92Ev();
extern void _ZN6S497C33v93Ev();
extern void _ZN6S497C33v94Ev();
extern void _ZN6S497C33v95Ev();
extern void _ZN6S497C33v96Ev();
extern void _ZN6S497C33v97Ev();
extern void _ZN6S497C33v98Ev();
extern void _ZN6S497C33v99Ev();
extern void _ZN6S497C34v100Ev();
extern void _ZN6S497C34v101Ev();
extern void _ZN6S497C34v102Ev();
extern void _ZN6S497C34v103Ev();
extern void _ZN6S497C34v104Ev();
extern void _ZN6S497C34v105Ev();
extern void _ZN6S497C34v106Ev();
extern void _ZN6S497C34v107Ev();
extern void _ZN6S497C24v108Ev();
extern void _ZN6S497C24v109Ev();
extern void _ZN6S497C24v110Ev();
extern void _ZN6S497C24v111Ev();
extern void _ZN6S497C24v112Ev();
extern void _ZN6S497C24v113Ev();
extern void _ZN6S497C24v114Ev();
extern void _ZN6S497C24v115Ev();
extern void _ZN6S497C24v116Ev();
extern void _ZN6S497C24v117Ev();
extern void _ZN6S497C24v118Ev();
extern void _ZN6S497C24v119Ev();
extern void _ZN6S497C24v120Ev();
extern void _ZN6S497C24v121Ev();
extern void _ZN6S497C24v122Ev();
extern void _ZN6S497C24v123Ev();
extern void _ZN6S497C24v124Ev();
extern void _ZN6S497C24v125Ev();
extern void _ZN6S497C24v126Ev();
extern void _ZN6S497C24v127Ev();
extern void _ZN6S497C24v128Ev();
extern void _ZN6S497C24v129Ev();
extern void _ZN6S497C24v130Ev();
extern void _ZN6S497C24v131Ev();
extern void _ZN6S497C24v132Ev();
extern void _ZN6S497C24v133Ev();
extern void _ZN6S497C24v134Ev();
extern void _ZN6S497C24v135Ev();
extern void _ZN6S497C24v136Ev();
extern void _ZN6S497C24v137Ev();
extern void _ZN6S497C24v138Ev();
extern void _ZN6S497C24v139Ev();
extern void _ZN6S497C24v140Ev();
extern void _ZN6S497C24v141Ev();
extern void _ZN6S497C24v142Ev();
extern void _ZN6S497C24v143Ev();
extern void _ZN6S497C24v144Ev();
extern void _ZN6S497C24v145Ev();
extern void _ZN6S497C24v146Ev();
extern void _ZN6S497C24v147Ev();
extern void _ZN6S497C24v148Ev();
extern void _ZN6S497C24v149Ev();
extern void _ZN6S497C24v150Ev();
extern void _ZN6S497C24v151Ev();
extern void _ZN6S497C24v152Ev();
extern void _ZN6S497C24v153Ev();
extern void _ZN6S497C24v154Ev();
extern void _ZN6S497C24v155Ev();
extern void _ZN6S497C24v156Ev();
extern void _ZN6S497C24v157Ev();
extern void _ZN6S497C24v158Ev();
extern void _ZN6S497C24v159Ev();
extern void _ZN6S497C24v160Ev();
extern void _ZN6S497C24v161Ev();
extern void _ZN6S497C24v162Ev();
extern void _ZN6S497C24v163Ev();
extern void _ZN6S497C24v164Ev();
extern void _ZN6S497C24v165Ev();
extern void _ZN6S497C24v166Ev();
extern void _ZN6S497C24v167Ev();
extern void _ZN6S497C24v168Ev();
extern void _ZN6S497C12v1Ev();
extern void _ZN6S497C12v2Ev();
extern void _ZN6S497C12v3Ev();
extern void _ZN6S497C12v4Ev();
extern void _ZN6S497C12v5Ev();
extern void _ZN6S497C12v6Ev();
extern void _ZN6S497C12v7Ev();
extern void _ZN6S497C12v8Ev();
extern void _ZN6S497C12v9Ev();
extern void _ZN6S497C13v10Ev();
extern void _ZN6S497C13v11Ev();
extern void _ZN6S497C13v12Ev();
extern void _ZN6S497C13v13Ev();
extern void _ZN6S497C13v14Ev();
extern void _ZN6S497C13v15Ev();
extern void _ZN6S497C13v16Ev();
static  VTBL_ENTRY vtc_S497C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S497C1[0]),
  (VTBL_ENTRY)&_ZN6S497C1D1Ev,
  (VTBL_ENTRY)&_ZN6S497C1D0Ev,
  (VTBL_ENTRY)&_ZN6S497C53v17Ev,
  (VTBL_ENTRY)&_ZN6S497C53v18Ev,
  (VTBL_ENTRY)&_ZN6S497C53v19Ev,
  (VTBL_ENTRY)&_ZN6S497C53v20Ev,
  (VTBL_ENTRY)&_ZN6S497C53v21Ev,
  (VTBL_ENTRY)&_ZN6S497C53v22Ev,
  (VTBL_ENTRY)&_ZN6S497C53v23Ev,
  (VTBL_ENTRY)&_ZN6S497C53v24Ev,
  (VTBL_ENTRY)&_ZN6S497C53v25Ev,
  (VTBL_ENTRY)&_ZN6S497C53v26Ev,
  (VTBL_ENTRY)&_ZN6S497C53v27Ev,
  (VTBL_ENTRY)&_ZN6S497C53v28Ev,
  (VTBL_ENTRY)&_ZN6S497C53v29Ev,
  (VTBL_ENTRY)&_ZN6S497C53v30Ev,
  (VTBL_ENTRY)&_ZN6S497C53v31Ev,
  (VTBL_ENTRY)&_ZN6S497C53v32Ev,
  (VTBL_ENTRY)&_ZN6S497C53v33Ev,
  (VTBL_ENTRY)&_ZN6S497C53v34Ev,
  (VTBL_ENTRY)&_ZN6S497C53v35Ev,
  (VTBL_ENTRY)&_ZN6S497C53v36Ev,
  (VTBL_ENTRY)&_ZN6S497C53v37Ev,
  (VTBL_ENTRY)&_ZN6S497C53v38Ev,
  (VTBL_ENTRY)&_ZN6S497C53v39Ev,
  (VTBL_ENTRY)&_ZN6S497C53v40Ev,
  (VTBL_ENTRY)&_ZN6S497C53v41Ev,
  (VTBL_ENTRY)&_ZN6S497C53v42Ev,
  (VTBL_ENTRY)&_ZN6S497C53v43Ev,
  (VTBL_ENTRY)&_ZN6S497C53v44Ev,
  (VTBL_ENTRY)&_ZN6S497C53v45Ev,
  (VTBL_ENTRY)&_ZN6S497C53v46Ev,
  (VTBL_ENTRY)&_ZN6S497C53v47Ev,
  (VTBL_ENTRY)&_ZN6S497C53v48Ev,
  (VTBL_ENTRY)&_ZN6S497C53v49Ev,
  (VTBL_ENTRY)&_ZN6S497C53v50Ev,
  (VTBL_ENTRY)&_ZN6S497C53v51Ev,
  (VTBL_ENTRY)&_ZN6S497C53v52Ev,
  (VTBL_ENTRY)&_ZN6S497C53v53Ev,
  (VTBL_ENTRY)&_ZN6S497C53v54Ev,
  (VTBL_ENTRY)&_ZN6S497C53v55Ev,
  (VTBL_ENTRY)&_ZN6S497C53v56Ev,
  (VTBL_ENTRY)&_ZN6S497C53v57Ev,
  (VTBL_ENTRY)&_ZN6S497C53v58Ev,
  (VTBL_ENTRY)&_ZN6S497C53v59Ev,
  (VTBL_ENTRY)&_ZN6S497C53v60Ev,
  (VTBL_ENTRY)&_ZN6S497C53v61Ev,
  (VTBL_ENTRY)&_ZN6S497C53v62Ev,
  (VTBL_ENTRY)&_ZN6S497C53v63Ev,
  (VTBL_ENTRY)&_ZN6S497C53v64Ev,
  (VTBL_ENTRY)&_ZN6S497C53v65Ev,
  (VTBL_ENTRY)&_ZN6S497C53v66Ev,
  (VTBL_ENTRY)&_ZN6S497C53v67Ev,
  (VTBL_ENTRY)&_ZN6S497C53v68Ev,
  (VTBL_ENTRY)&_ZN6S497C53v69Ev,
  (VTBL_ENTRY)&_ZN6S497C53v70Ev,
  (VTBL_ENTRY)&_ZN6S497C53v71Ev,
  (VTBL_ENTRY)&_ZN6S497C53v72Ev,
  (VTBL_ENTRY)&_ZN6S497C53v73Ev,
  (VTBL_ENTRY)&_ZN6S497C53v74Ev,
  (VTBL_ENTRY)&_ZN6S497C53v75Ev,
  (VTBL_ENTRY)&_ZN6S497C53v76Ev,
  (VTBL_ENTRY)&_ZN6S497C53v77Ev,
  (VTBL_ENTRY)&_ZN6S497C53v78Ev,
  (VTBL_ENTRY)&_ZN6S497C53v79Ev,
  (VTBL_ENTRY)&_ZN6S497C53v80Ev,
  (VTBL_ENTRY)&_ZN6S497C43v81Ev,
  (VTBL_ENTRY)&_ZN6S497C43v82Ev,
  (VTBL_ENTRY)&_ZN6S497C43v83Ev,
  (VTBL_ENTRY)&_ZN6S497C43v84Ev,
  (VTBL_ENTRY)&_ZN6S497C43v85Ev,
  (VTBL_ENTRY)&_ZN6S497C33v86Ev,
  (VTBL_ENTRY)&_ZN6S497C33v87Ev,
  (VTBL_ENTRY)&_ZN6S497C33v88Ev,
  (VTBL_ENTRY)&_ZN6S497C33v89Ev,
  (VTBL_ENTRY)&_ZN6S497C33v90Ev,
  (VTBL_ENTRY)&_ZN6S497C33v91Ev,
  (VTBL_ENTRY)&_ZN6S497C33v92Ev,
  (VTBL_ENTRY)&_ZN6S497C33v93Ev,
  (VTBL_ENTRY)&_ZN6S497C33v94Ev,
  (VTBL_ENTRY)&_ZN6S497C33v95Ev,
  (VTBL_ENTRY)&_ZN6S497C33v96Ev,
  (VTBL_ENTRY)&_ZN6S497C33v97Ev,
  (VTBL_ENTRY)&_ZN6S497C33v98Ev,
  (VTBL_ENTRY)&_ZN6S497C33v99Ev,
  (VTBL_ENTRY)&_ZN6S497C34v100Ev,
  (VTBL_ENTRY)&_ZN6S497C34v101Ev,
  (VTBL_ENTRY)&_ZN6S497C34v102Ev,
  (VTBL_ENTRY)&_ZN6S497C34v103Ev,
  (VTBL_ENTRY)&_ZN6S497C34v104Ev,
  (VTBL_ENTRY)&_ZN6S497C34v105Ev,
  (VTBL_ENTRY)&_ZN6S497C34v106Ev,
  (VTBL_ENTRY)&_ZN6S497C34v107Ev,
  (VTBL_ENTRY)&_ZN6S497C24v108Ev,
  (VTBL_ENTRY)&_ZN6S497C24v109Ev,
  (VTBL_ENTRY)&_ZN6S497C24v110Ev,
  (VTBL_ENTRY)&_ZN6S497C24v111Ev,
  (VTBL_ENTRY)&_ZN6S497C24v112Ev,
  (VTBL_ENTRY)&_ZN6S497C24v113Ev,
  (VTBL_ENTRY)&_ZN6S497C24v114Ev,
  (VTBL_ENTRY)&_ZN6S497C24v115Ev,
  (VTBL_ENTRY)&_ZN6S497C24v116Ev,
  (VTBL_ENTRY)&_ZN6S497C24v117Ev,
  (VTBL_ENTRY)&_ZN6S497C24v118Ev,
  (VTBL_ENTRY)&_ZN6S497C24v119Ev,
  (VTBL_ENTRY)&_ZN6S497C24v120Ev,
  (VTBL_ENTRY)&_ZN6S497C24v121Ev,
  (VTBL_ENTRY)&_ZN6S497C24v122Ev,
  (VTBL_ENTRY)&_ZN6S497C24v123Ev,
  (VTBL_ENTRY)&_ZN6S497C24v124Ev,
  (VTBL_ENTRY)&_ZN6S497C24v125Ev,
  (VTBL_ENTRY)&_ZN6S497C24v126Ev,
  (VTBL_ENTRY)&_ZN6S497C24v127Ev,
  (VTBL_ENTRY)&_ZN6S497C24v128Ev,
  (VTBL_ENTRY)&_ZN6S497C24v129Ev,
  (VTBL_ENTRY)&_ZN6S497C24v130Ev,
  (VTBL_ENTRY)&_ZN6S497C24v131Ev,
  (VTBL_ENTRY)&_ZN6S497C24v132Ev,
  (VTBL_ENTRY)&_ZN6S497C24v133Ev,
  (VTBL_ENTRY)&_ZN6S497C24v134Ev,
  (VTBL_ENTRY)&_ZN6S497C24v135Ev,
  (VTBL_ENTRY)&_ZN6S497C24v136Ev,
  (VTBL_ENTRY)&_ZN6S497C24v137Ev,
  (VTBL_ENTRY)&_ZN6S497C24v138Ev,
  (VTBL_ENTRY)&_ZN6S497C24v139Ev,
  (VTBL_ENTRY)&_ZN6S497C24v140Ev,
  (VTBL_ENTRY)&_ZN6S497C24v141Ev,
  (VTBL_ENTRY)&_ZN6S497C24v142Ev,
  (VTBL_ENTRY)&_ZN6S497C24v143Ev,
  (VTBL_ENTRY)&_ZN6S497C24v144Ev,
  (VTBL_ENTRY)&_ZN6S497C24v145Ev,
  (VTBL_ENTRY)&_ZN6S497C24v146Ev,
  (VTBL_ENTRY)&_ZN6S497C24v147Ev,
  (VTBL_ENTRY)&_ZN6S497C24v148Ev,
  (VTBL_ENTRY)&_ZN6S497C24v149Ev,
  (VTBL_ENTRY)&_ZN6S497C24v150Ev,
  (VTBL_ENTRY)&_ZN6S497C24v151Ev,
  (VTBL_ENTRY)&_ZN6S497C24v152Ev,
  (VTBL_ENTRY)&_ZN6S497C24v153Ev,
  (VTBL_ENTRY)&_ZN6S497C24v154Ev,
  (VTBL_ENTRY)&_ZN6S497C24v155Ev,
  (VTBL_ENTRY)&_ZN6S497C24v156Ev,
  (VTBL_ENTRY)&_ZN6S497C24v157Ev,
  (VTBL_ENTRY)&_ZN6S497C24v158Ev,
  (VTBL_ENTRY)&_ZN6S497C24v159Ev,
  (VTBL_ENTRY)&_ZN6S497C24v160Ev,
  (VTBL_ENTRY)&_ZN6S497C24v161Ev,
  (VTBL_ENTRY)&_ZN6S497C24v162Ev,
  (VTBL_ENTRY)&_ZN6S497C24v163Ev,
  (VTBL_ENTRY)&_ZN6S497C24v164Ev,
  (VTBL_ENTRY)&_ZN6S497C24v165Ev,
  (VTBL_ENTRY)&_ZN6S497C24v166Ev,
  (VTBL_ENTRY)&_ZN6S497C24v167Ev,
  (VTBL_ENTRY)&_ZN6S497C24v168Ev,
  (VTBL_ENTRY)&_ZN6S497C12v1Ev,
  (VTBL_ENTRY)&_ZN6S497C12v2Ev,
  (VTBL_ENTRY)&_ZN6S497C12v3Ev,
  (VTBL_ENTRY)&_ZN6S497C12v4Ev,
  (VTBL_ENTRY)&_ZN6S497C12v5Ev,
  (VTBL_ENTRY)&_ZN6S497C12v6Ev,
  (VTBL_ENTRY)&_ZN6S497C12v7Ev,
  (VTBL_ENTRY)&_ZN6S497C12v8Ev,
  (VTBL_ENTRY)&_ZN6S497C12v9Ev,
  (VTBL_ENTRY)&_ZN6S497C13v10Ev,
  (VTBL_ENTRY)&_ZN6S497C13v11Ev,
  (VTBL_ENTRY)&_ZN6S497C13v12Ev,
  (VTBL_ENTRY)&_ZN6S497C13v13Ev,
  (VTBL_ENTRY)&_ZN6S497C13v14Ev,
  (VTBL_ENTRY)&_ZN6S497C13v15Ev,
  (VTBL_ENTRY)&_ZN6S497C13v16Ev,
};
extern VTBL_ENTRY _ZTI6S497C1[];
extern  VTBL_ENTRY _ZTV6S497C1[];
Class_Descriptor cd_S497C1 = {  "S497C1", // class name
  bases_S497C1, 4,
  &(vtc_S497C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(488,348), // object size
  NSPAIRA(_ZTI6S497C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S497C1),172, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C5  {
  int s480c5f0;
  __tsi64 s480c5f1;
  void *s480c5f2[4];
  int s480c5f3[2];
  void *s480c5f4;
  ::S95C8_nt s480c5f5;
  void *s480c5f6[2];
  virtual  ~S480C5(); // _ZN6S480C5D1Ev
  virtual void  v12(); // _ZN6S480C53v12Ev
  virtual void  v13(); // _ZN6S480C53v13Ev
  virtual void  v14(); // _ZN6S480C53v14Ev
  virtual void  v15(); // _ZN6S480C53v15Ev
  virtual void  v16(); // _ZN6S480C53v16Ev
  virtual void  v17(); // _ZN6S480C53v17Ev
  virtual void  v18(); // _ZN6S480C53v18Ev
  virtual void  v19(); // _ZN6S480C53v19Ev
  virtual void  v20(); // _ZN6S480C53v20Ev
  virtual void  v21(); // _ZN6S480C53v21Ev
  virtual void  v22(); // _ZN6S480C53v22Ev
  virtual void  v23(); // _ZN6S480C53v23Ev
  virtual void  v24(); // _ZN6S480C53v24Ev
  virtual void  v25(); // _ZN6S480C53v25Ev
  virtual void  v26(); // _ZN6S480C53v26Ev
  virtual void  v27(); // _ZN6S480C53v27Ev
  virtual void  v28(); // _ZN6S480C53v28Ev
  virtual void  v29(); // _ZN6S480C53v29Ev
  virtual void  v30(); // _ZN6S480C53v30Ev
  virtual void  v31(); // _ZN6S480C53v31Ev
  virtual void  v32(); // _ZN6S480C53v32Ev
  virtual void  v33(); // _ZN6S480C53v33Ev
  virtual void  v34(); // _ZN6S480C53v34Ev
  virtual void  v35(); // _ZN6S480C53v35Ev
  virtual void  v36(); // _ZN6S480C53v36Ev
  virtual void  v37(); // _ZN6S480C53v37Ev
  virtual void  v38(); // _ZN6S480C53v38Ev
  virtual void  v39(); // _ZN6S480C53v39Ev
  virtual void  v40(); // _ZN6S480C53v40Ev
  virtual void  v41(); // _ZN6S480C53v41Ev
  virtual void  v42(); // _ZN6S480C53v42Ev
  virtual void  v43(); // _ZN6S480C53v43Ev
  virtual void  v44(); // _ZN6S480C53v44Ev
  virtual void  v45(); // _ZN6S480C53v45Ev
  virtual void  v46(); // _ZN6S480C53v46Ev
  virtual void  v47(); // _ZN6S480C53v47Ev
  virtual void  v48(); // _ZN6S480C53v48Ev
  virtual void  v49(); // _ZN6S480C53v49Ev
  virtual void  v50(); // _ZN6S480C53v50Ev
  virtual void  v51(); // _ZN6S480C53v51Ev
  virtual void  v52(); // _ZN6S480C53v52Ev
  virtual void  v53(); // _ZN6S480C53v53Ev
  virtual void  v54(); // _ZN6S480C53v54Ev
  virtual void  v55(); // _ZN6S480C53v55Ev
  virtual void  v56(); // _ZN6S480C53v56Ev
  virtual void  v57(); // _ZN6S480C53v57Ev
  virtual void  v58(); // _ZN6S480C53v58Ev
  virtual void  v59(); // _ZN6S480C53v59Ev
  virtual void  v60(); // _ZN6S480C53v60Ev
  virtual void  v61(); // _ZN6S480C53v61Ev
  virtual void  v62(); // _ZN6S480C53v62Ev
  virtual void  v63(); // _ZN6S480C53v63Ev
  virtual void  v64(); // _ZN6S480C53v64Ev
  virtual void  v65(); // _ZN6S480C53v65Ev
  virtual void  v66(); // _ZN6S480C53v66Ev
  virtual void  v67(); // _ZN6S480C53v67Ev
  virtual void  v68(); // _ZN6S480C53v68Ev
  virtual void  v69(); // _ZN6S480C53v69Ev
  virtual void  v70(); // _ZN6S480C53v70Ev
  virtual void  v71(); // _ZN6S480C53v71Ev
  virtual void  v72(); // _ZN6S480C53v72Ev
  virtual void  v73(); // _ZN6S480C53v73Ev
  virtual void  v74(); // _ZN6S480C53v74Ev
  virtual void  v75(); // _ZN6S480C53v75Ev
  S480C5(); // tgen
};
//SIG(-1 S480C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S480C5 ::~S480C5(){ note_dtor("S480C5", this);}
void  S480C5 ::v12(){vfunc_called(this, "_ZN6S480C53v12Ev");}
void  S480C5 ::v13(){vfunc_called(this, "_ZN6S480C53v13Ev");}
void  S480C5 ::v14(){vfunc_called(this, "_ZN6S480C53v14Ev");}
void  S480C5 ::v15(){vfunc_called(this, "_ZN6S480C53v15Ev");}
void  S480C5 ::v16(){vfunc_called(this, "_ZN6S480C53v16Ev");}
void  S480C5 ::v17(){vfunc_called(this, "_ZN6S480C53v17Ev");}
void  S480C5 ::v18(){vfunc_called(this, "_ZN6S480C53v18Ev");}
void  S480C5 ::v19(){vfunc_called(this, "_ZN6S480C53v19Ev");}
void  S480C5 ::v20(){vfunc_called(this, "_ZN6S480C53v20Ev");}
void  S480C5 ::v21(){vfunc_called(this, "_ZN6S480C53v21Ev");}
void  S480C5 ::v22(){vfunc_called(this, "_ZN6S480C53v22Ev");}
void  S480C5 ::v23(){vfunc_called(this, "_ZN6S480C53v23Ev");}
void  S480C5 ::v24(){vfunc_called(this, "_ZN6S480C53v24Ev");}
void  S480C5 ::v25(){vfunc_called(this, "_ZN6S480C53v25Ev");}
void  S480C5 ::v26(){vfunc_called(this, "_ZN6S480C53v26Ev");}
void  S480C5 ::v27(){vfunc_called(this, "_ZN6S480C53v27Ev");}
void  S480C5 ::v28(){vfunc_called(this, "_ZN6S480C53v28Ev");}
void  S480C5 ::v29(){vfunc_called(this, "_ZN6S480C53v29Ev");}
void  S480C5 ::v30(){vfunc_called(this, "_ZN6S480C53v30Ev");}
void  S480C5 ::v31(){vfunc_called(this, "_ZN6S480C53v31Ev");}
void  S480C5 ::v32(){vfunc_called(this, "_ZN6S480C53v32Ev");}
void  S480C5 ::v33(){vfunc_called(this, "_ZN6S480C53v33Ev");}
void  S480C5 ::v34(){vfunc_called(this, "_ZN6S480C53v34Ev");}
void  S480C5 ::v35(){vfunc_called(this, "_ZN6S480C53v35Ev");}
void  S480C5 ::v36(){vfunc_called(this, "_ZN6S480C53v36Ev");}
void  S480C5 ::v37(){vfunc_called(this, "_ZN6S480C53v37Ev");}
void  S480C5 ::v38(){vfunc_called(this, "_ZN6S480C53v38Ev");}
void  S480C5 ::v39(){vfunc_called(this, "_ZN6S480C53v39Ev");}
void  S480C5 ::v40(){vfunc_called(this, "_ZN6S480C53v40Ev");}
void  S480C5 ::v41(){vfunc_called(this, "_ZN6S480C53v41Ev");}
void  S480C5 ::v42(){vfunc_called(this, "_ZN6S480C53v42Ev");}
void  S480C5 ::v43(){vfunc_called(this, "_ZN6S480C53v43Ev");}
void  S480C5 ::v44(){vfunc_called(this, "_ZN6S480C53v44Ev");}
void  S480C5 ::v45(){vfunc_called(this, "_ZN6S480C53v45Ev");}
void  S480C5 ::v46(){vfunc_called(this, "_ZN6S480C53v46Ev");}
void  S480C5 ::v47(){vfunc_called(this, "_ZN6S480C53v47Ev");}
void  S480C5 ::v48(){vfunc_called(this, "_ZN6S480C53v48Ev");}
void  S480C5 ::v49(){vfunc_called(this, "_ZN6S480C53v49Ev");}
void  S480C5 ::v50(){vfunc_called(this, "_ZN6S480C53v50Ev");}
void  S480C5 ::v51(){vfunc_called(this, "_ZN6S480C53v51Ev");}
void  S480C5 ::v52(){vfunc_called(this, "_ZN6S480C53v52Ev");}
void  S480C5 ::v53(){vfunc_called(this, "_ZN6S480C53v53Ev");}
void  S480C5 ::v54(){vfunc_called(this, "_ZN6S480C53v54Ev");}
void  S480C5 ::v55(){vfunc_called(this, "_ZN6S480C53v55Ev");}
void  S480C5 ::v56(){vfunc_called(this, "_ZN6S480C53v56Ev");}
void  S480C5 ::v57(){vfunc_called(this, "_ZN6S480C53v57Ev");}
void  S480C5 ::v58(){vfunc_called(this, "_ZN6S480C53v58Ev");}
void  S480C5 ::v59(){vfunc_called(this, "_ZN6S480C53v59Ev");}
void  S480C5 ::v60(){vfunc_called(this, "_ZN6S480C53v60Ev");}
void  S480C5 ::v61(){vfunc_called(this, "_ZN6S480C53v61Ev");}
void  S480C5 ::v62(){vfunc_called(this, "_ZN6S480C53v62Ev");}
void  S480C5 ::v63(){vfunc_called(this, "_ZN6S480C53v63Ev");}
void  S480C5 ::v64(){vfunc_called(this, "_ZN6S480C53v64Ev");}
void  S480C5 ::v65(){vfunc_called(this, "_ZN6S480C53v65Ev");}
void  S480C5 ::v66(){vfunc_called(this, "_ZN6S480C53v66Ev");}
void  S480C5 ::v67(){vfunc_called(this, "_ZN6S480C53v67Ev");}
void  S480C5 ::v68(){vfunc_called(this, "_ZN6S480C53v68Ev");}
void  S480C5 ::v69(){vfunc_called(this, "_ZN6S480C53v69Ev");}
void  S480C5 ::v70(){vfunc_called(this, "_ZN6S480C53v70Ev");}
void  S480C5 ::v71(){vfunc_called(this, "_ZN6S480C53v71Ev");}
void  S480C5 ::v72(){vfunc_called(this, "_ZN6S480C53v72Ev");}
void  S480C5 ::v73(){vfunc_called(this, "_ZN6S480C53v73Ev");}
void  S480C5 ::v74(){vfunc_called(this, "_ZN6S480C53v74Ev");}
void  S480C5 ::v75(){vfunc_called(this, "_ZN6S480C53v75Ev");}
S480C5 ::S480C5(){ note_ctor("S480C5", this);} // tgen

static void Test_S480C5()
{
  extern Class_Descriptor cd_S480C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S480C5, buf);
    S480C5 *dp, &lv = *(dp=new (buf) S480C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S480C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C5)");
    check_field_offset(lv, s480c5f0, ABISELECT(8,4), "S480C5.s480c5f0");
    check_field_offset(lv, s480c5f1, ABISELECT(16,8), "S480C5.s480c5f1");
    check_field_offset(lv, s480c5f2, ABISELECT(24,16), "S480C5.s480c5f2");
    check_field_offset(lv, s480c5f3, ABISELECT(56,32), "S480C5.s480c5f3");
    check_field_offset(lv, s480c5f4, ABISELECT(64,40), "S480C5.s480c5f4");
    check_field_offset(lv, s480c5f5, ABISELECT(72,44), "S480C5.s480c5f5");
    check_field_offset(lv, s480c5f6, ABISELECT(80,52), "S480C5.s480c5f6");
    test_class_info(&lv, &cd_S480C5);
    dp->~S480C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS480C5(Test_S480C5, "S480C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S480C5C1Ev();
extern void _ZN6S480C5D1Ev();
Name_Map name_map_S480C5[] = {
  NSPAIR(_ZN6S480C5C1Ev),
  NSPAIR(_ZN6S480C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S480C5[];
extern void _ZN6S480C5D1Ev();
extern void _ZN6S480C5D0Ev();
extern void _ZN6S480C53v12Ev();
extern void _ZN6S480C53v13Ev();
extern void _ZN6S480C53v14Ev();
extern void _ZN6S480C53v15Ev();
extern void _ZN6S480C53v16Ev();
extern void _ZN6S480C53v17Ev();
extern void _ZN6S480C53v18Ev();
extern void _ZN6S480C53v19Ev();
extern void _ZN6S480C53v20Ev();
extern void _ZN6S480C53v21Ev();
extern void _ZN6S480C53v22Ev();
extern void _ZN6S480C53v23Ev();
extern void _ZN6S480C53v24Ev();
extern void _ZN6S480C53v25Ev();
extern void _ZN6S480C53v26Ev();
extern void _ZN6S480C53v27Ev();
extern void _ZN6S480C53v28Ev();
extern void _ZN6S480C53v29Ev();
extern void _ZN6S480C53v30Ev();
extern void _ZN6S480C53v31Ev();
extern void _ZN6S480C53v32Ev();
extern void _ZN6S480C53v33Ev();
extern void _ZN6S480C53v34Ev();
extern void _ZN6S480C53v35Ev();
extern void _ZN6S480C53v36Ev();
extern void _ZN6S480C53v37Ev();
extern void _ZN6S480C53v38Ev();
extern void _ZN6S480C53v39Ev();
extern void _ZN6S480C53v40Ev();
extern void _ZN6S480C53v41Ev();
extern void _ZN6S480C53v42Ev();
extern void _ZN6S480C53v43Ev();
extern void _ZN6S480C53v44Ev();
extern void _ZN6S480C53v45Ev();
extern void _ZN6S480C53v46Ev();
extern void _ZN6S480C53v47Ev();
extern void _ZN6S480C53v48Ev();
extern void _ZN6S480C53v49Ev();
extern void _ZN6S480C53v50Ev();
extern void _ZN6S480C53v51Ev();
extern void _ZN6S480C53v52Ev();
extern void _ZN6S480C53v53Ev();
extern void _ZN6S480C53v54Ev();
extern void _ZN6S480C53v55Ev();
extern void _ZN6S480C53v56Ev();
extern void _ZN6S480C53v57Ev();
extern void _ZN6S480C53v58Ev();
extern void _ZN6S480C53v59Ev();
extern void _ZN6S480C53v60Ev();
extern void _ZN6S480C53v61Ev();
extern void _ZN6S480C53v62Ev();
extern void _ZN6S480C53v63Ev();
extern void _ZN6S480C53v64Ev();
extern void _ZN6S480C53v65Ev();
extern void _ZN6S480C53v66Ev();
extern void _ZN6S480C53v67Ev();
extern void _ZN6S480C53v68Ev();
extern void _ZN6S480C53v69Ev();
extern void _ZN6S480C53v70Ev();
extern void _ZN6S480C53v71Ev();
extern void _ZN6S480C53v72Ev();
extern void _ZN6S480C53v73Ev();
extern void _ZN6S480C53v74Ev();
extern void _ZN6S480C53v75Ev();
static  VTBL_ENTRY vtc_S480C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S480C5[0]),
  (VTBL_ENTRY)&_ZN6S480C5D1Ev,
  (VTBL_ENTRY)&_ZN6S480C5D0Ev,
  (VTBL_ENTRY)&_ZN6S480C53v12Ev,
  (VTBL_ENTRY)&_ZN6S480C53v13Ev,
  (VTBL_ENTRY)&_ZN6S480C53v14Ev,
  (VTBL_ENTRY)&_ZN6S480C53v15Ev,
  (VTBL_ENTRY)&_ZN6S480C53v16Ev,
  (VTBL_ENTRY)&_ZN6S480C53v17Ev,
  (VTBL_ENTRY)&_ZN6S480C53v18Ev,
  (VTBL_ENTRY)&_ZN6S480C53v19Ev,
  (VTBL_ENTRY)&_ZN6S480C53v20Ev,
  (VTBL_ENTRY)&_ZN6S480C53v21Ev,
  (VTBL_ENTRY)&_ZN6S480C53v22Ev,
  (VTBL_ENTRY)&_ZN6S480C53v23Ev,
  (VTBL_ENTRY)&_ZN6S480C53v24Ev,
  (VTBL_ENTRY)&_ZN6S480C53v25Ev,
  (VTBL_ENTRY)&_ZN6S480C53v26Ev,
  (VTBL_ENTRY)&_ZN6S480C53v27Ev,
  (VTBL_ENTRY)&_ZN6S480C53v28Ev,
  (VTBL_ENTRY)&_ZN6S480C53v29Ev,
  (VTBL_ENTRY)&_ZN6S480C53v30Ev,
  (VTBL_ENTRY)&_ZN6S480C53v31Ev,
  (VTBL_ENTRY)&_ZN6S480C53v32Ev,
  (VTBL_ENTRY)&_ZN6S480C53v33Ev,
  (VTBL_ENTRY)&_ZN6S480C53v34Ev,
  (VTBL_ENTRY)&_ZN6S480C53v35Ev,
  (VTBL_ENTRY)&_ZN6S480C53v36Ev,
  (VTBL_ENTRY)&_ZN6S480C53v37Ev,
  (VTBL_ENTRY)&_ZN6S480C53v38Ev,
  (VTBL_ENTRY)&_ZN6S480C53v39Ev,
  (VTBL_ENTRY)&_ZN6S480C53v40Ev,
  (VTBL_ENTRY)&_ZN6S480C53v41Ev,
  (VTBL_ENTRY)&_ZN6S480C53v42Ev,
  (VTBL_ENTRY)&_ZN6S480C53v43Ev,
  (VTBL_ENTRY)&_ZN6S480C53v44Ev,
  (VTBL_ENTRY)&_ZN6S480C53v45Ev,
  (VTBL_ENTRY)&_ZN6S480C53v46Ev,
  (VTBL_ENTRY)&_ZN6S480C53v47Ev,
  (VTBL_ENTRY)&_ZN6S480C53v48Ev,
  (VTBL_ENTRY)&_ZN6S480C53v49Ev,
  (VTBL_ENTRY)&_ZN6S480C53v50Ev,
  (VTBL_ENTRY)&_ZN6S480C53v51Ev,
  (VTBL_ENTRY)&_ZN6S480C53v52Ev,
  (VTBL_ENTRY)&_ZN6S480C53v53Ev,
  (VTBL_ENTRY)&_ZN6S480C53v54Ev,
  (VTBL_ENTRY)&_ZN6S480C53v55Ev,
  (VTBL_ENTRY)&_ZN6S480C53v56Ev,
  (VTBL_ENTRY)&_ZN6S480C53v57Ev,
  (VTBL_ENTRY)&_ZN6S480C53v58Ev,
  (VTBL_ENTRY)&_ZN6S480C53v59Ev,
  (VTBL_ENTRY)&_ZN6S480C53v60Ev,
  (VTBL_ENTRY)&_ZN6S480C53v61Ev,
  (VTBL_ENTRY)&_ZN6S480C53v62Ev,
  (VTBL_ENTRY)&_ZN6S480C53v63Ev,
  (VTBL_ENTRY)&_ZN6S480C53v64Ev,
  (VTBL_ENTRY)&_ZN6S480C53v65Ev,
  (VTBL_ENTRY)&_ZN6S480C53v66Ev,
  (VTBL_ENTRY)&_ZN6S480C53v67Ev,
  (VTBL_ENTRY)&_ZN6S480C53v68Ev,
  (VTBL_ENTRY)&_ZN6S480C53v69Ev,
  (VTBL_ENTRY)&_ZN6S480C53v70Ev,
  (VTBL_ENTRY)&_ZN6S480C53v71Ev,
  (VTBL_ENTRY)&_ZN6S480C53v72Ev,
  (VTBL_ENTRY)&_ZN6S480C53v73Ev,
  (VTBL_ENTRY)&_ZN6S480C53v74Ev,
  (VTBL_ENTRY)&_ZN6S480C53v75Ev,
};
extern VTBL_ENTRY _ZTI6S480C5[];
extern  VTBL_ENTRY _ZTV6S480C5[];
Class_Descriptor cd_S480C5 = {  "S480C5", // class name
  0,0,//no base classes
  &(vtc_S480C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S480C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S480C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C4  : S480C5 {
  void *s480c4f0;
  ::S95C8_nt s480c4f1;
  virtual  ~S480C4(); // _ZN6S480C4D1Ev
  virtual void  v76(); // _ZN6S480C43v76Ev
  virtual void  v77(); // _ZN6S480C43v77Ev
  virtual void  v78(); // _ZN6S480C43v78Ev
  virtual void  v79(); // _ZN6S480C43v79Ev
  virtual void  v80(); // _ZN6S480C43v80Ev
  S480C4(); // tgen
};
//SIG(-1 S480C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S480C4 ::~S480C4(){ note_dtor("S480C4", this);}
void  S480C4 ::v76(){vfunc_called(this, "_ZN6S480C43v76Ev");}
void  S480C4 ::v77(){vfunc_called(this, "_ZN6S480C43v77Ev");}
void  S480C4 ::v78(){vfunc_called(this, "_ZN6S480C43v78Ev");}
void  S480C4 ::v79(){vfunc_called(this, "_ZN6S480C43v79Ev");}
void  S480C4 ::v80(){vfunc_called(this, "_ZN6S480C43v80Ev");}
S480C4 ::S480C4(){ note_ctor("S480C4", this);} // tgen

static void Test_S480C4()
{
  extern Class_Descriptor cd_S480C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S480C4, buf);
    S480C4 *dp, &lv = *(dp=new (buf) S480C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S480C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C4)");
    check_base_class_offset(lv, (S480C5*), 0, "S480C4");
    check_field_offset(lv, s480c4f0, ABISELECT(96,60), "S480C4.s480c4f0");
    check_field_offset(lv, s480c4f1, ABISELECT(104,64), "S480C4.s480c4f1");
    test_class_info(&lv, &cd_S480C4);
    dp->~S480C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS480C4(Test_S480C4, "S480C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S480C4C1Ev();
extern void _ZN6S480C4D1Ev();
Name_Map name_map_S480C4[] = {
  NSPAIR(_ZN6S480C4C1Ev),
  NSPAIR(_ZN6S480C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S480C5;
extern VTBL_ENTRY _ZTI6S480C5[];
extern  VTBL_ENTRY _ZTV6S480C5[];
static Base_Class bases_S480C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S480C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S480C4[];
extern void _ZN6S480C4D1Ev();
extern void _ZN6S480C4D0Ev();
extern void _ZN6S480C53v12Ev();
extern void _ZN6S480C53v13Ev();
extern void _ZN6S480C53v14Ev();
extern void _ZN6S480C53v15Ev();
extern void _ZN6S480C53v16Ev();
extern void _ZN6S480C53v17Ev();
extern void _ZN6S480C53v18Ev();
extern void _ZN6S480C53v19Ev();
extern void _ZN6S480C53v20Ev();
extern void _ZN6S480C53v21Ev();
extern void _ZN6S480C53v22Ev();
extern void _ZN6S480C53v23Ev();
extern void _ZN6S480C53v24Ev();
extern void _ZN6S480C53v25Ev();
extern void _ZN6S480C53v26Ev();
extern void _ZN6S480C53v27Ev();
extern void _ZN6S480C53v28Ev();
extern void _ZN6S480C53v29Ev();
extern void _ZN6S480C53v30Ev();
extern void _ZN6S480C53v31Ev();
extern void _ZN6S480C53v32Ev();
extern void _ZN6S480C53v33Ev();
extern void _ZN6S480C53v34Ev();
extern void _ZN6S480C53v35Ev();
extern void _ZN6S480C53v36Ev();
extern void _ZN6S480C53v37Ev();
extern void _ZN6S480C53v38Ev();
extern void _ZN6S480C53v39Ev();
extern void _ZN6S480C53v40Ev();
extern void _ZN6S480C53v41Ev();
extern void _ZN6S480C53v42Ev();
extern void _ZN6S480C53v43Ev();
extern void _ZN6S480C53v44Ev();
extern void _ZN6S480C53v45Ev();
extern void _ZN6S480C53v46Ev();
extern void _ZN6S480C53v47Ev();
extern void _ZN6S480C53v48Ev();
extern void _ZN6S480C53v49Ev();
extern void _ZN6S480C53v50Ev();
extern void _ZN6S480C53v51Ev();
extern void _ZN6S480C53v52Ev();
extern void _ZN6S480C53v53Ev();
extern void _ZN6S480C53v54Ev();
extern void _ZN6S480C53v55Ev();
extern void _ZN6S480C53v56Ev();
extern void _ZN6S480C53v57Ev();
extern void _ZN6S480C53v58Ev();
extern void _ZN6S480C53v59Ev();
extern void _ZN6S480C53v60Ev();
extern void _ZN6S480C53v61Ev();
extern void _ZN6S480C53v62Ev();
extern void _ZN6S480C53v63Ev();
extern void _ZN6S480C53v64Ev();
extern void _ZN6S480C53v65Ev();
extern void _ZN6S480C53v66Ev();
extern void _ZN6S480C53v67Ev();
extern void _ZN6S480C53v68Ev();
extern void _ZN6S480C53v69Ev();
extern void _ZN6S480C53v70Ev();
extern void _ZN6S480C53v71Ev();
extern void _ZN6S480C53v72Ev();
extern void _ZN6S480C53v73Ev();
extern void _ZN6S480C53v74Ev();
extern void _ZN6S480C53v75Ev();
extern void _ZN6S480C43v76Ev();
extern void _ZN6S480C43v77Ev();
extern void _ZN6S480C43v78Ev();
extern void _ZN6S480C43v79Ev();
extern void _ZN6S480C43v80Ev();
static  VTBL_ENTRY vtc_S480C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S480C4[0]),
  (VTBL_ENTRY)&_ZN6S480C4D1Ev,
  (VTBL_ENTRY)&_ZN6S480C4D0Ev,
  (VTBL_ENTRY)&_ZN6S480C53v12Ev,
  (VTBL_ENTRY)&_ZN6S480C53v13Ev,
  (VTBL_ENTRY)&_ZN6S480C53v14Ev,
  (VTBL_ENTRY)&_ZN6S480C53v15Ev,
  (VTBL_ENTRY)&_ZN6S480C53v16Ev,
  (VTBL_ENTRY)&_ZN6S480C53v17Ev,
  (VTBL_ENTRY)&_ZN6S480C53v18Ev,
  (VTBL_ENTRY)&_ZN6S480C53v19Ev,
  (VTBL_ENTRY)&_ZN6S480C53v20Ev,
  (VTBL_ENTRY)&_ZN6S480C53v21Ev,
  (VTBL_ENTRY)&_ZN6S480C53v22Ev,
  (VTBL_ENTRY)&_ZN6S480C53v23Ev,
  (VTBL_ENTRY)&_ZN6S480C53v24Ev,
  (VTBL_ENTRY)&_ZN6S480C53v25Ev,
  (VTBL_ENTRY)&_ZN6S480C53v26Ev,
  (VTBL_ENTRY)&_ZN6S480C53v27Ev,
  (VTBL_ENTRY)&_ZN6S480C53v28Ev,
  (VTBL_ENTRY)&_ZN6S480C53v29Ev,
  (VTBL_ENTRY)&_ZN6S480C53v30Ev,
  (VTBL_ENTRY)&_ZN6S480C53v31Ev,
  (VTBL_ENTRY)&_ZN6S480C53v32Ev,
  (VTBL_ENTRY)&_ZN6S480C53v33Ev,
  (VTBL_ENTRY)&_ZN6S480C53v34Ev,
  (VTBL_ENTRY)&_ZN6S480C53v35Ev,
  (VTBL_ENTRY)&_ZN6S480C53v36Ev,
  (VTBL_ENTRY)&_ZN6S480C53v37Ev,
  (VTBL_ENTRY)&_ZN6S480C53v38Ev,
  (VTBL_ENTRY)&_ZN6S480C53v39Ev,
  (VTBL_ENTRY)&_ZN6S480C53v40Ev,
  (VTBL_ENTRY)&_ZN6S480C53v41Ev,
  (VTBL_ENTRY)&_ZN6S480C53v42Ev,
  (VTBL_ENTRY)&_ZN6S480C53v43Ev,
  (VTBL_ENTRY)&_ZN6S480C53v44Ev,
  (VTBL_ENTRY)&_ZN6S480C53v45Ev,
  (VTBL_ENTRY)&_ZN6S480C53v46Ev,
  (VTBL_ENTRY)&_ZN6S480C53v47Ev,
  (VTBL_ENTRY)&_ZN6S480C53v48Ev,
  (VTBL_ENTRY)&_ZN6S480C53v49Ev,
  (VTBL_ENTRY)&_ZN6S480C53v50Ev,
  (VTBL_ENTRY)&_ZN6S480C53v51Ev,
  (VTBL_ENTRY)&_ZN6S480C53v52Ev,
  (VTBL_ENTRY)&_ZN6S480C53v53Ev,
  (VTBL_ENTRY)&_ZN6S480C53v54Ev,
  (VTBL_ENTRY)&_ZN6S480C53v55Ev,
  (VTBL_ENTRY)&_ZN6S480C53v56Ev,
  (VTBL_ENTRY)&_ZN6S480C53v57Ev,
  (VTBL_ENTRY)&_ZN6S480C53v58Ev,
  (VTBL_ENTRY)&_ZN6S480C53v59Ev,
  (VTBL_ENTRY)&_ZN6S480C53v60Ev,
  (VTBL_ENTRY)&_ZN6S480C53v61Ev,
  (VTBL_ENTRY)&_ZN6S480C53v62Ev,
  (VTBL_ENTRY)&_ZN6S480C53v63Ev,
  (VTBL_ENTRY)&_ZN6S480C53v64Ev,
  (VTBL_ENTRY)&_ZN6S480C53v65Ev,
  (VTBL_ENTRY)&_ZN6S480C53v66Ev,
  (VTBL_ENTRY)&_ZN6S480C53v67Ev,
  (VTBL_ENTRY)&_ZN6S480C53v68Ev,
  (VTBL_ENTRY)&_ZN6S480C53v69Ev,
  (VTBL_ENTRY)&_ZN6S480C53v70Ev,
  (VTBL_ENTRY)&_ZN6S480C53v71Ev,
  (VTBL_ENTRY)&_ZN6S480C53v72Ev,
  (VTBL_ENTRY)&_ZN6S480C53v73Ev,
  (VTBL_ENTRY)&_ZN6S480C53v74Ev,
  (VTBL_ENTRY)&_ZN6S480C53v75Ev,
  (VTBL_ENTRY)&_ZN6S480C43v76Ev,
  (VTBL_ENTRY)&_ZN6S480C43v77Ev,
  (VTBL_ENTRY)&_ZN6S480C43v78Ev,
  (VTBL_ENTRY)&_ZN6S480C43v79Ev,
  (VTBL_ENTRY)&_ZN6S480C43v80Ev,
};
extern VTBL_ENTRY _ZTI6S480C4[];
extern  VTBL_ENTRY _ZTV6S480C4[];
Class_Descriptor cd_S480C4 = {  "S480C4", // class name
  bases_S480C4, 1,
  &(vtc_S480C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S480C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S480C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C3  : S480C4 {
  void *s480c3f0[2];
  unsigned int s480c3f1:1;
  unsigned int s480c3f2:1;
  unsigned int s480c3f3:1;
  unsigned int s480c3f4:1;
  char s480c3f5;
  virtual  ~S480C3(); // _ZN6S480C3D1Ev
  virtual void  v81(); // _ZN6S480C33v81Ev
  virtual void  v82(); // _ZN6S480C33v82Ev
  virtual void  v83(); // _ZN6S480C33v83Ev
  virtual void  v84(); // _ZN6S480C33v84Ev
  virtual void  v85(); // _ZN6S480C33v85Ev
  virtual void  v86(); // _ZN6S480C33v86Ev
  virtual void  v87(); // _ZN6S480C33v87Ev
  virtual void  v88(); // _ZN6S480C33v88Ev
  virtual void  v89(); // _ZN6S480C33v89Ev
  virtual void  v90(); // _ZN6S480C33v90Ev
  virtual void  v91(); // _ZN6S480C33v91Ev
  virtual void  v92(); // _ZN6S480C33v92Ev
  virtual void  v93(); // _ZN6S480C33v93Ev
  virtual void  v94(); // _ZN6S480C33v94Ev
  virtual void  v95(); // _ZN6S480C33v95Ev
  virtual void  v96(); // _ZN6S480C33v96Ev
  virtual void  v97(); // _ZN6S480C33v97Ev
  virtual void  v98(); // _ZN6S480C33v98Ev
  virtual void  v99(); // _ZN6S480C33v99Ev
  virtual void  v100(); // _ZN6S480C34v100Ev
  virtual void  v101(); // _ZN6S480C34v101Ev
  virtual void  v102(); // _ZN6S480C34v102Ev
  S480C3(); // tgen
};
//SIG(-1 S480C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S480C3 ::~S480C3(){ note_dtor("S480C3", this);}
void  S480C3 ::v81(){vfunc_called(this, "_ZN6S480C33v81Ev");}
void  S480C3 ::v82(){vfunc_called(this, "_ZN6S480C33v82Ev");}
void  S480C3 ::v83(){vfunc_called(this, "_ZN6S480C33v83Ev");}
void  S480C3 ::v84(){vfunc_called(this, "_ZN6S480C33v84Ev");}
void  S480C3 ::v85(){vfunc_called(this, "_ZN6S480C33v85Ev");}
void  S480C3 ::v86(){vfunc_called(this, "_ZN6S480C33v86Ev");}
void  S480C3 ::v87(){vfunc_called(this, "_ZN6S480C33v87Ev");}
void  S480C3 ::v88(){vfunc_called(this, "_ZN6S480C33v88Ev");}
void  S480C3 ::v89(){vfunc_called(this, "_ZN6S480C33v89Ev");}
void  S480C3 ::v90(){vfunc_called(this, "_ZN6S480C33v90Ev");}
void  S480C3 ::v91(){vfunc_called(this, "_ZN6S480C33v91Ev");}
void  S480C3 ::v92(){vfunc_called(this, "_ZN6S480C33v92Ev");}
void  S480C3 ::v93(){vfunc_called(this, "_ZN6S480C33v93Ev");}
void  S480C3 ::v94(){vfunc_called(this, "_ZN6S480C33v94Ev");}
void  S480C3 ::v95(){vfunc_called(this, "_ZN6S480C33v95Ev");}
void  S480C3 ::v96(){vfunc_called(this, "_ZN6S480C33v96Ev");}
void  S480C3 ::v97(){vfunc_called(this, "_ZN6S480C33v97Ev");}
void  S480C3 ::v98(){vfunc_called(this, "_ZN6S480C33v98Ev");}
void  S480C3 ::v99(){vfunc_called(this, "_ZN6S480C33v99Ev");}
void  S480C3 ::v100(){vfunc_called(this, "_ZN6S480C34v100Ev");}
void  S480C3 ::v101(){vfunc_called(this, "_ZN6S480C34v101Ev");}
void  S480C3 ::v102(){vfunc_called(this, "_ZN6S480C34v102Ev");}
S480C3 ::S480C3(){ note_ctor("S480C3", this);} // tgen

static void Test_S480C3()
{
  extern Class_Descriptor cd_S480C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S480C3, buf);
    S480C3 *dp, &lv = *(dp=new (buf) S480C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S480C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C3)");
    check_base_class_offset(lv, (S480C5*)(S480C4*), 0, "S480C3");
    check_base_class_offset(lv, (S480C4*), 0, "S480C3");
    check_field_offset(lv, s480c3f0, ABISELECT(112,72), "S480C3.s480c3f0");
    set_bf_and_test(lv, s480c3f1, ABISELECT(128,80), 0, 1, 1, "S480C3");
    set_bf_and_test(lv, s480c3f2, ABISELECT(128,80), 1, 1, 1, "S480C3");
    set_bf_and_test(lv, s480c3f3, ABISELECT(128,80), 2, 1, 1, "S480C3");
    set_bf_and_test(lv, s480c3f4, ABISELECT(128,80), 3, 1, 1, "S480C3");
    check_field_offset(lv, s480c3f5, ABISELECT(129,81), "S480C3.s480c3f5");
    test_class_info(&lv, &cd_S480C3);
    dp->~S480C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS480C3(Test_S480C3, "S480C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S480C3C1Ev();
extern void _ZN6S480C3D1Ev();
Name_Map name_map_S480C3[] = {
  NSPAIR(_ZN6S480C3C1Ev),
  NSPAIR(_ZN6S480C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S480C5;
extern VTBL_ENTRY _ZTI6S480C5[];
extern  VTBL_ENTRY _ZTV6S480C5[];
extern Class_Descriptor cd_S480C4;
extern VTBL_ENTRY _ZTI6S480C4[];
extern  VTBL_ENTRY _ZTV6S480C4[];
static Base_Class bases_S480C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S480C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S480C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S480C3[];
extern void _ZN6S480C3D1Ev();
extern void _ZN6S480C3D0Ev();
extern void _ZN6S480C53v12Ev();
extern void _ZN6S480C53v13Ev();
extern void _ZN6S480C53v14Ev();
extern void _ZN6S480C53v15Ev();
extern void _ZN6S480C53v16Ev();
extern void _ZN6S480C53v17Ev();
extern void _ZN6S480C53v18Ev();
extern void _ZN6S480C53v19Ev();
extern void _ZN6S480C53v20Ev();
extern void _ZN6S480C53v21Ev();
extern void _ZN6S480C53v22Ev();
extern void _ZN6S480C53v23Ev();
extern void _ZN6S480C53v24Ev();
extern void _ZN6S480C53v25Ev();
extern void _ZN6S480C53v26Ev();
extern void _ZN6S480C53v27Ev();
extern void _ZN6S480C53v28Ev();
extern void _ZN6S480C53v29Ev();
extern void _ZN6S480C53v30Ev();
extern void _ZN6S480C53v31Ev();
extern void _ZN6S480C53v32Ev();
extern void _ZN6S480C53v33Ev();
extern void _ZN6S480C53v34Ev();
extern void _ZN6S480C53v35Ev();
extern void _ZN6S480C53v36Ev();
extern void _ZN6S480C53v37Ev();
extern void _ZN6S480C53v38Ev();
extern void _ZN6S480C53v39Ev();
extern void _ZN6S480C53v40Ev();
extern void _ZN6S480C53v41Ev();
extern void _ZN6S480C53v42Ev();
extern void _ZN6S480C53v43Ev();
extern void _ZN6S480C53v44Ev();
extern void _ZN6S480C53v45Ev();
extern void _ZN6S480C53v46Ev();
extern void _ZN6S480C53v47Ev();
extern void _ZN6S480C53v48Ev();
extern void _ZN6S480C53v49Ev();
extern void _ZN6S480C53v50Ev();
extern void _ZN6S480C53v51Ev();
extern void _ZN6S480C53v52Ev();
extern void _ZN6S480C53v53Ev();
extern void _ZN6S480C53v54Ev();
extern void _ZN6S480C53v55Ev();
extern void _ZN6S480C53v56Ev();
extern void _ZN6S480C53v57Ev();
extern void _ZN6S480C53v58Ev();
extern void _ZN6S480C53v59Ev();
extern void _ZN6S480C53v60Ev();
extern void _ZN6S480C53v61Ev();
extern void _ZN6S480C53v62Ev();
extern void _ZN6S480C53v63Ev();
extern void _ZN6S480C53v64Ev();
extern void _ZN6S480C53v65Ev();
extern void _ZN6S480C53v66Ev();
extern void _ZN6S480C53v67Ev();
extern void _ZN6S480C53v68Ev();
extern void _ZN6S480C53v69Ev();
extern void _ZN6S480C53v70Ev();
extern void _ZN6S480C53v71Ev();
extern void _ZN6S480C53v72Ev();
extern void _ZN6S480C53v73Ev();
extern void _ZN6S480C53v74Ev();
extern void _ZN6S480C53v75Ev();
extern void _ZN6S480C43v76Ev();
extern void _ZN6S480C43v77Ev();
extern void _ZN6S480C43v78Ev();
extern void _ZN6S480C43v79Ev();
extern void _ZN6S480C43v80Ev();
extern void _ZN6S480C33v81Ev();
extern void _ZN6S480C33v82Ev();
extern void _ZN6S480C33v83Ev();
extern void _ZN6S480C33v84Ev();
extern void _ZN6S480C33v85Ev();
extern void _ZN6S480C33v86Ev();
extern void _ZN6S480C33v87Ev();
extern void _ZN6S480C33v88Ev();
extern void _ZN6S480C33v89Ev();
extern void _ZN6S480C33v90Ev();
extern void _ZN6S480C33v91Ev();
extern void _ZN6S480C33v92Ev();
extern void _ZN6S480C33v93Ev();
extern void _ZN6S480C33v94Ev();
extern void _ZN6S480C33v95Ev();
extern void _ZN6S480C33v96Ev();
extern void _ZN6S480C33v97Ev();
extern void _ZN6S480C33v98Ev();
extern void _ZN6S480C33v99Ev();
extern void _ZN6S480C34v100Ev();
extern void _ZN6S480C34v101Ev();
extern void _ZN6S480C34v102Ev();
static  VTBL_ENTRY vtc_S480C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S480C3[0]),
  (VTBL_ENTRY)&_ZN6S480C3D1Ev,
  (VTBL_ENTRY)&_ZN6S480C3D0Ev,
  (VTBL_ENTRY)&_ZN6S480C53v12Ev,
  (VTBL_ENTRY)&_ZN6S480C53v13Ev,
  (VTBL_ENTRY)&_ZN6S480C53v14Ev,
  (VTBL_ENTRY)&_ZN6S480C53v15Ev,
  (VTBL_ENTRY)&_ZN6S480C53v16Ev,
  (VTBL_ENTRY)&_ZN6S480C53v17Ev,
  (VTBL_ENTRY)&_ZN6S480C53v18Ev,
  (VTBL_ENTRY)&_ZN6S480C53v19Ev,
  (VTBL_ENTRY)&_ZN6S480C53v20Ev,
  (VTBL_ENTRY)&_ZN6S480C53v21Ev,
  (VTBL_ENTRY)&_ZN6S480C53v22Ev,
  (VTBL_ENTRY)&_ZN6S480C53v23Ev,
  (VTBL_ENTRY)&_ZN6S480C53v24Ev,
  (VTBL_ENTRY)&_ZN6S480C53v25Ev,
  (VTBL_ENTRY)&_ZN6S480C53v26Ev,
  (VTBL_ENTRY)&_ZN6S480C53v27Ev,
  (VTBL_ENTRY)&_ZN6S480C53v28Ev,
  (VTBL_ENTRY)&_ZN6S480C53v29Ev,
  (VTBL_ENTRY)&_ZN6S480C53v30Ev,
  (VTBL_ENTRY)&_ZN6S480C53v31Ev,
  (VTBL_ENTRY)&_ZN6S480C53v32Ev,
  (VTBL_ENTRY)&_ZN6S480C53v33Ev,
  (VTBL_ENTRY)&_ZN6S480C53v34Ev,
  (VTBL_ENTRY)&_ZN6S480C53v35Ev,
  (VTBL_ENTRY)&_ZN6S480C53v36Ev,
  (VTBL_ENTRY)&_ZN6S480C53v37Ev,
  (VTBL_ENTRY)&_ZN6S480C53v38Ev,
  (VTBL_ENTRY)&_ZN6S480C53v39Ev,
  (VTBL_ENTRY)&_ZN6S480C53v40Ev,
  (VTBL_ENTRY)&_ZN6S480C53v41Ev,
  (VTBL_ENTRY)&_ZN6S480C53v42Ev,
  (VTBL_ENTRY)&_ZN6S480C53v43Ev,
  (VTBL_ENTRY)&_ZN6S480C53v44Ev,
  (VTBL_ENTRY)&_ZN6S480C53v45Ev,
  (VTBL_ENTRY)&_ZN6S480C53v46Ev,
  (VTBL_ENTRY)&_ZN6S480C53v47Ev,
  (VTBL_ENTRY)&_ZN6S480C53v48Ev,
  (VTBL_ENTRY)&_ZN6S480C53v49Ev,
  (VTBL_ENTRY)&_ZN6S480C53v50Ev,
  (VTBL_ENTRY)&_ZN6S480C53v51Ev,
  (VTBL_ENTRY)&_ZN6S480C53v52Ev,
  (VTBL_ENTRY)&_ZN6S480C53v53Ev,
  (VTBL_ENTRY)&_ZN6S480C53v54Ev,
  (VTBL_ENTRY)&_ZN6S480C53v55Ev,
  (VTBL_ENTRY)&_ZN6S480C53v56Ev,
  (VTBL_ENTRY)&_ZN6S480C53v57Ev,
  (VTBL_ENTRY)&_ZN6S480C53v58Ev,
  (VTBL_ENTRY)&_ZN6S480C53v59Ev,
  (VTBL_ENTRY)&_ZN6S480C53v60Ev,
  (VTBL_ENTRY)&_ZN6S480C53v61Ev,
  (VTBL_ENTRY)&_ZN6S480C53v62Ev,
  (VTBL_ENTRY)&_ZN6S480C53v63Ev,
  (VTBL_ENTRY)&_ZN6S480C53v64Ev,
  (VTBL_ENTRY)&_ZN6S480C53v65Ev,
  (VTBL_ENTRY)&_ZN6S480C53v66Ev,
  (VTBL_ENTRY)&_ZN6S480C53v67Ev,
  (VTBL_ENTRY)&_ZN6S480C53v68Ev,
  (VTBL_ENTRY)&_ZN6S480C53v69Ev,
  (VTBL_ENTRY)&_ZN6S480C53v70Ev,
  (VTBL_ENTRY)&_ZN6S480C53v71Ev,
  (VTBL_ENTRY)&_ZN6S480C53v72Ev,
  (VTBL_ENTRY)&_ZN6S480C53v73Ev,
  (VTBL_ENTRY)&_ZN6S480C53v74Ev,
  (VTBL_ENTRY)&_ZN6S480C53v75Ev,
  (VTBL_ENTRY)&_ZN6S480C43v76Ev,
  (VTBL_ENTRY)&_ZN6S480C43v77Ev,
  (VTBL_ENTRY)&_ZN6S480C43v78Ev,
  (VTBL_ENTRY)&_ZN6S480C43v79Ev,
  (VTBL_ENTRY)&_ZN6S480C43v80Ev,
  (VTBL_ENTRY)&_ZN6S480C33v81Ev,
  (VTBL_ENTRY)&_ZN6S480C33v82Ev,
  (VTBL_ENTRY)&_ZN6S480C33v83Ev,
  (VTBL_ENTRY)&_ZN6S480C33v84Ev,
  (VTBL_ENTRY)&_ZN6S480C33v85Ev,
  (VTBL_ENTRY)&_ZN6S480C33v86Ev,
  (VTBL_ENTRY)&_ZN6S480C33v87Ev,
  (VTBL_ENTRY)&_ZN6S480C33v88Ev,
  (VTBL_ENTRY)&_ZN6S480C33v89Ev,
  (VTBL_ENTRY)&_ZN6S480C33v90Ev,
  (VTBL_ENTRY)&_ZN6S480C33v91Ev,
  (VTBL_ENTRY)&_ZN6S480C33v92Ev,
  (VTBL_ENTRY)&_ZN6S480C33v93Ev,
  (VTBL_ENTRY)&_ZN6S480C33v94Ev,
  (VTBL_ENTRY)&_ZN6S480C33v95Ev,
  (VTBL_ENTRY)&_ZN6S480C33v96Ev,
  (VTBL_ENTRY)&_ZN6S480C33v97Ev,
  (VTBL_ENTRY)&_ZN6S480C33v98Ev,
  (VTBL_ENTRY)&_ZN6S480C33v99Ev,
  (VTBL_ENTRY)&_ZN6S480C34v100Ev,
  (VTBL_ENTRY)&_ZN6S480C34v101Ev,
  (VTBL_ENTRY)&_ZN6S480C34v102Ev,
};
extern VTBL_ENTRY _ZTI6S480C3[];
extern  VTBL_ENTRY _ZTV6S480C3[];
Class_Descriptor cd_S480C3 = {  "S480C3", // class name
  bases_S480C3, 2,
  &(vtc_S480C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S480C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S480C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C2  : S480C3 {
  void *s480c2f0;
  ::S95C9_nt s480c2f1;
  int s480c2f2;
  ::S236C15_nt s480c2f3;
  int s480c2f4;
  ::S490C27 s480c2f5;
  int s480c2f6;
  void *s480c2f7[2];
  ::S95C13 s480c2f8;
  void *s480c2f9;
  int s480c2f10[2];
  char s480c2f11[3];
  int s480c2f12;
  unsigned int s480c2f13:1;
  unsigned int s480c2f14:1;
  unsigned int s480c2f15:1;
  unsigned int s480c2f16:1;
  unsigned int s480c2f17:1;
  unsigned int s480c2f18:1;
  unsigned int s480c2f19:1;
  unsigned int s480c2f20:1;
  unsigned int s480c2f21:1;
  unsigned int s480c2f22:1;
  unsigned int s480c2f23:1;
  unsigned int s480c2f24:1;
  unsigned int s480c2f25:1;
  unsigned int s480c2f26:1;
  int s480c2f27;
  unsigned int s480c2f28:1;
  unsigned int s480c2f29:1;
  unsigned int s480c2f30:1;
  unsigned int s480c2f31:1;
  unsigned int s480c2f32:1;
  unsigned int s480c2f33:1;
  ::S112C22_nt s480c2f34;
  unsigned int s480c2f35:1;
  unsigned int s480c2f36:1;
  unsigned int s480c2f37:1;
  unsigned int s480c2f38:1;
  unsigned int s480c2f39:1;
  unsigned int s480c2f40:1;
  unsigned int s480c2f41:1;
  char s480c2f42;
  ::S95C16 s480c2f43;
  unsigned int s480c2f44:1;
  unsigned int s480c2f45:1;
  unsigned int s480c2f46:1;
  unsigned int s480c2f47:1;
  unsigned int s480c2f48:1;
  unsigned int s480c2f49:1;
  unsigned int s480c2f50:1;
  unsigned int s480c2f51:1;
  unsigned int s480c2f52:1;
  unsigned int s480c2f53:1;
  unsigned int s480c2f54:1;
  unsigned int s480c2f55:1;
  ::S490C26 s480c2f56;
  void *s480c2f57[2];
  char s480c2f58;
  ::S236C15_nt s480c2f59;
  ::S236C18_nt s480c2f60;
  ::S95C14_nt s480c2f61;
  int s480c2f62;
  ::S236C18_nt s480c2f63;
  unsigned int s480c2f64:1;
  unsigned int s480c2f65:1;
  unsigned int s480c2f66:1;
  int s480c2f67[3];
  virtual  ~S480C2(); // _ZN6S480C2D1Ev
  virtual void  v103(); // _ZN6S480C24v103Ev
  virtual void  v104(); // _ZN6S480C24v104Ev
  virtual void  v105(); // _ZN6S480C24v105Ev
  virtual void  v106(); // _ZN6S480C24v106Ev
  virtual void  v107(); // _ZN6S480C24v107Ev
  virtual void  v108(); // _ZN6S480C24v108Ev
  virtual void  v109(); // _ZN6S480C24v109Ev
  virtual void  v110(); // _ZN6S480C24v110Ev
  virtual void  v111(); // _ZN6S480C24v111Ev
  virtual void  v112(); // _ZN6S480C24v112Ev
  virtual void  v113(); // _ZN6S480C24v113Ev
  virtual void  v114(); // _ZN6S480C24v114Ev
  virtual void  v115(); // _ZN6S480C24v115Ev
  virtual void  v116(); // _ZN6S480C24v116Ev
  virtual void  v117(); // _ZN6S480C24v117Ev
  virtual void  v118(); // _ZN6S480C24v118Ev
  virtual void  v119(); // _ZN6S480C24v119Ev
  virtual void  v120(); // _ZN6S480C24v120Ev
  virtual void  v121(); // _ZN6S480C24v121Ev
  virtual void  v122(); // _ZN6S480C24v122Ev
  virtual void  v123(); // _ZN6S480C24v123Ev
  virtual void  v124(); // _ZN6S480C24v124Ev
  virtual void  v125(); // _ZN6S480C24v125Ev
  virtual void  v126(); // _ZN6S480C24v126Ev
  virtual void  v127(); // _ZN6S480C24v127Ev
  virtual void  v128(); // _ZN6S480C24v128Ev
  virtual void  v129(); // _ZN6S480C24v129Ev
  virtual void  v130(); // _ZN6S480C24v130Ev
  virtual void  v131(); // _ZN6S480C24v131Ev
  virtual void  v132(); // _ZN6S480C24v132Ev
  virtual void  v133(); // _ZN6S480C24v133Ev
  virtual void  v134(); // _ZN6S480C24v134Ev
  virtual void  v135(); // _ZN6S480C24v135Ev
  virtual void  v136(); // _ZN6S480C24v136Ev
  virtual void  v137(); // _ZN6S480C24v137Ev
  virtual void  v138(); // _ZN6S480C24v138Ev
  virtual void  v139(); // _ZN6S480C24v139Ev
  virtual void  v140(); // _ZN6S480C24v140Ev
  virtual void  v141(); // _ZN6S480C24v141Ev
  virtual void  v142(); // _ZN6S480C24v142Ev
  virtual void  v143(); // _ZN6S480C24v143Ev
  virtual void  v144(); // _ZN6S480C24v144Ev
  virtual void  v145(); // _ZN6S480C24v145Ev
  virtual void  v146(); // _ZN6S480C24v146Ev
  virtual void  v147(); // _ZN6S480C24v147Ev
  virtual void  v148(); // _ZN6S480C24v148Ev
  virtual void  v149(); // _ZN6S480C24v149Ev
  virtual void  v150(); // _ZN6S480C24v150Ev
  virtual void  v151(); // _ZN6S480C24v151Ev
  virtual void  v152(); // _ZN6S480C24v152Ev
  virtual void  v153(); // _ZN6S480C24v153Ev
  virtual void  v154(); // _ZN6S480C24v154Ev
  virtual void  v155(); // _ZN6S480C24v155Ev
  virtual void  v156(); // _ZN6S480C24v156Ev
  virtual void  v157(); // _ZN6S480C24v157Ev
  virtual void  v158(); // _ZN6S480C24v158Ev
  virtual void  v159(); // _ZN6S480C24v159Ev
  virtual void  v160(); // _ZN6S480C24v160Ev
  virtual void  v161(); // _ZN6S480C24v161Ev
  virtual void  v162(); // _ZN6S480C24v162Ev
  virtual void  v163(); // _ZN6S480C24v163Ev
  S480C2(); // tgen
};
//SIG(-1 S480C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S480C2 ::~S480C2(){ note_dtor("S480C2", this);}
void  S480C2 ::v103(){vfunc_called(this, "_ZN6S480C24v103Ev");}
void  S480C2 ::v104(){vfunc_called(this, "_ZN6S480C24v104Ev");}
void  S480C2 ::v105(){vfunc_called(this, "_ZN6S480C24v105Ev");}
void  S480C2 ::v106(){vfunc_called(this, "_ZN6S480C24v106Ev");}
void  S480C2 ::v107(){vfunc_called(this, "_ZN6S480C24v107Ev");}
void  S480C2 ::v108(){vfunc_called(this, "_ZN6S480C24v108Ev");}
void  S480C2 ::v109(){vfunc_called(this, "_ZN6S480C24v109Ev");}
void  S480C2 ::v110(){vfunc_called(this, "_ZN6S480C24v110Ev");}
void  S480C2 ::v111(){vfunc_called(this, "_ZN6S480C24v111Ev");}
void  S480C2 ::v112(){vfunc_called(this, "_ZN6S480C24v112Ev");}
void  S480C2 ::v113(){vfunc_called(this, "_ZN6S480C24v113Ev");}
void  S480C2 ::v114(){vfunc_called(this, "_ZN6S480C24v114Ev");}
void  S480C2 ::v115(){vfunc_called(this, "_ZN6S480C24v115Ev");}
void  S480C2 ::v116(){vfunc_called(this, "_ZN6S480C24v116Ev");}
void  S480C2 ::v117(){vfunc_called(this, "_ZN6S480C24v117Ev");}
void  S480C2 ::v118(){vfunc_called(this, "_ZN6S480C24v118Ev");}
void  S480C2 ::v119(){vfunc_called(this, "_ZN6S480C24v119Ev");}
void  S480C2 ::v120(){vfunc_called(this, "_ZN6S480C24v120Ev");}
void  S480C2 ::v121(){vfunc_called(this, "_ZN6S480C24v121Ev");}
void  S480C2 ::v122(){vfunc_called(this, "_ZN6S480C24v122Ev");}
void  S480C2 ::v123(){vfunc_called(this, "_ZN6S480C24v123Ev");}
void  S480C2 ::v124(){vfunc_called(this, "_ZN6S480C24v124Ev");}
void  S480C2 ::v125(){vfunc_called(this, "_ZN6S480C24v125Ev");}
void  S480C2 ::v126(){vfunc_called(this, "_ZN6S480C24v126Ev");}
void  S480C2 ::v127(){vfunc_called(this, "_ZN6S480C24v127Ev");}
void  S480C2 ::v128(){vfunc_called(this, "_ZN6S480C24v128Ev");}
void  S480C2 ::v129(){vfunc_called(this, "_ZN6S480C24v129Ev");}
void  S480C2 ::v130(){vfunc_called(this, "_ZN6S480C24v130Ev");}
void  S480C2 ::v131(){vfunc_called(this, "_ZN6S480C24v131Ev");}
void  S480C2 ::v132(){vfunc_called(this, "_ZN6S480C24v132Ev");}
void  S480C2 ::v133(){vfunc_called(this, "_ZN6S480C24v133Ev");}
void  S480C2 ::v134(){vfunc_called(this, "_ZN6S480C24v134Ev");}
void  S480C2 ::v135(){vfunc_called(this, "_ZN6S480C24v135Ev");}
void  S480C2 ::v136(){vfunc_called(this, "_ZN6S480C24v136Ev");}
void  S480C2 ::v137(){vfunc_called(this, "_ZN6S480C24v137Ev");}
void  S480C2 ::v138(){vfunc_called(this, "_ZN6S480C24v138Ev");}
void  S480C2 ::v139(){vfunc_called(this, "_ZN6S480C24v139Ev");}
void  S480C2 ::v140(){vfunc_called(this, "_ZN6S480C24v140Ev");}
void  S480C2 ::v141(){vfunc_called(this, "_ZN6S480C24v141Ev");}
void  S480C2 ::v142(){vfunc_called(this, "_ZN6S480C24v142Ev");}
void  S480C2 ::v143(){vfunc_called(this, "_ZN6S480C24v143Ev");}
void  S480C2 ::v144(){vfunc_called(this, "_ZN6S480C24v144Ev");}
void  S480C2 ::v145(){vfunc_called(this, "_ZN6S480C24v145Ev");}
void  S480C2 ::v146(){vfunc_called(this, "_ZN6S480C24v146Ev");}
void  S480C2 ::v147(){vfunc_called(this, "_ZN6S480C24v147Ev");}
void  S480C2 ::v148(){vfunc_called(this, "_ZN6S480C24v148Ev");}
void  S480C2 ::v149(){vfunc_called(this, "_ZN6S480C24v149Ev");}
void  S480C2 ::v150(){vfunc_called(this, "_ZN6S480C24v150Ev");}
void  S480C2 ::v151(){vfunc_called(this, "_ZN6S480C24v151Ev");}
void  S480C2 ::v152(){vfunc_called(this, "_ZN6S480C24v152Ev");}
void  S480C2 ::v153(){vfunc_called(this, "_ZN6S480C24v153Ev");}
void  S480C2 ::v154(){vfunc_called(this, "_ZN6S480C24v154Ev");}
void  S480C2 ::v155(){vfunc_called(this, "_ZN6S480C24v155Ev");}
void  S480C2 ::v156(){vfunc_called(this, "_ZN6S480C24v156Ev");}
void  S480C2 ::v157(){vfunc_called(this, "_ZN6S480C24v157Ev");}
void  S480C2 ::v158(){vfunc_called(this, "_ZN6S480C24v158Ev");}
void  S480C2 ::v159(){vfunc_called(this, "_ZN6S480C24v159Ev");}
void  S480C2 ::v160(){vfunc_called(this, "_ZN6S480C24v160Ev");}
void  S480C2 ::v161(){vfunc_called(this, "_ZN6S480C24v161Ev");}
void  S480C2 ::v162(){vfunc_called(this, "_ZN6S480C24v162Ev");}
void  S480C2 ::v163(){vfunc_called(this, "_ZN6S480C24v163Ev");}
S480C2 ::S480C2(){ note_ctor("S480C2", this);} // tgen

static void Test_S480C2()
{
  extern Class_Descriptor cd_S480C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S480C2, buf);
    S480C2 *dp, &lv = *(dp=new (buf) S480C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S480C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C2)");
    check_base_class_offset(lv, (S480C5*)(S480C4*)(S480C3*), 0, "S480C2");
    check_base_class_offset(lv, (S480C4*)(S480C3*), 0, "S480C2");
    check_base_class_offset(lv, (S480C3*), 0, "S480C2");
    check_field_offset(lv, s480c2f0, ABISELECT(136,84), "S480C2.s480c2f0");
    check_field_offset(lv, s480c2f1, ABISELECT(144,88), "S480C2.s480c2f1");
    check_field_offset(lv, s480c2f2, ABISELECT(148,92), "S480C2.s480c2f2");
    check_field_offset(lv, s480c2f3, ABISELECT(152,96), "S480C2.s480c2f3");
    check_field_offset(lv, s480c2f4, ABISELECT(156,100), "S480C2.s480c2f4");
    check_field_offset(lv, s480c2f5, ABISELECT(160,104), "S480C2.s480c2f5");
    check_field_offset(lv, s480c2f6, ABISELECT(176,116), "S480C2.s480c2f6");
    check_field_offset(lv, s480c2f7, ABISELECT(184,120), "S480C2.s480c2f7");
    check_field_offset(lv, s480c2f8, ABISELECT(200,128), "S480C2.s480c2f8");
    check_field_offset(lv, s480c2f9, ABISELECT(232,156), "S480C2.s480c2f9");
    check_field_offset(lv, s480c2f10, ABISELECT(240,160), "S480C2.s480c2f10");
    check_field_offset(lv, s480c2f11, ABISELECT(248,168), "S480C2.s480c2f11");
    check_field_offset(lv, s480c2f12, ABISELECT(252,172), "S480C2.s480c2f12");
    set_bf_and_test(lv, s480c2f13, ABISELECT(256,176), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f14, ABISELECT(256,176), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f15, ABISELECT(256,176), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f16, ABISELECT(256,176), 3, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f17, ABISELECT(256,176), 4, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f18, ABISELECT(256,176), 5, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f19, ABISELECT(256,176), 6, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f20, ABISELECT(256,176), 7, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f21, ABISELECT(257,177), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f22, ABISELECT(257,177), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f23, ABISELECT(257,177), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f24, ABISELECT(257,177), 3, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f25, ABISELECT(257,177), 4, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f26, ABISELECT(257,177), 5, 1, 1, "S480C2");
    check_field_offset(lv, s480c2f27, ABISELECT(260,180), "S480C2.s480c2f27");
    set_bf_and_test(lv, s480c2f28, ABISELECT(264,184), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f29, ABISELECT(264,184), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f30, ABISELECT(264,184), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f31, ABISELECT(264,184), 3, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f32, ABISELECT(264,184), 4, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f33, ABISELECT(264,184), 5, 1, 1, "S480C2");
    check_field_offset(lv, s480c2f34, ABISELECT(265,185), "S480C2.s480c2f34");
    set_bf_and_test(lv, s480c2f35, ABISELECT(266,186), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f36, ABISELECT(266,186), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f37, ABISELECT(266,186), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f38, ABISELECT(266,186), 3, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f39, ABISELECT(266,186), 4, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f40, ABISELECT(266,186), 5, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f41, ABISELECT(266,186), 6, 1, 1, "S480C2");
    check_field_offset(lv, s480c2f42, ABISELECT(267,187), "S480C2.s480c2f42");
    check_field_offset(lv, s480c2f43, ABISELECT(268,188), "S480C2.s480c2f43");
    set_bf_and_test(lv, s480c2f44, ABISELECT(269,189), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f45, ABISELECT(269,189), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f46, ABISELECT(269,189), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f47, ABISELECT(269,189), 3, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f48, ABISELECT(269,189), 4, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f49, ABISELECT(269,189), 5, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f50, ABISELECT(269,189), 6, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f51, ABISELECT(269,189), 7, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f52, ABISELECT(270,190), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f53, ABISELECT(270,190), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f54, ABISELECT(270,190), 2, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f55, ABISELECT(270,190), 3, 1, 1, "S480C2");
    check_field_offset(lv, s480c2f56, ABISELECT(272,192), "S480C2.s480c2f56");
    check_field_offset(lv, s480c2f57, ABISELECT(288,204), "S480C2.s480c2f57");
    check_field_offset(lv, s480c2f58, ABISELECT(304,212), "S480C2.s480c2f58");
    check_field_offset(lv, s480c2f59, ABISELECT(305,213), "S480C2.s480c2f59");
    check_field_offset(lv, s480c2f60, ABISELECT(308,216), "S480C2.s480c2f60");
    check_field_offset(lv, s480c2f61, ABISELECT(320,228), "S480C2.s480c2f61");
    check_field_offset(lv, s480c2f62, ABISELECT(332,240), "S480C2.s480c2f62");
    check_field_offset(lv, s480c2f63, ABISELECT(336,244), "S480C2.s480c2f63");
    set_bf_and_test(lv, s480c2f64, ABISELECT(348,256), 0, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f65, ABISELECT(348,256), 1, 1, 1, "S480C2");
    set_bf_and_test(lv, s480c2f66, ABISELECT(348,256), 2, 1, 1, "S480C2");
    check_field_offset(lv, s480c2f67, ABISELECT(352,260), "S480C2.s480c2f67");
    test_class_info(&lv, &cd_S480C2);
    dp->~S480C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS480C2(Test_S480C2, "S480C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S480C2C1Ev();
extern void _ZN6S480C2D1Ev();
Name_Map name_map_S480C2[] = {
  NSPAIR(_ZN6S480C2C1Ev),
  NSPAIR(_ZN6S480C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S480C5;
extern VTBL_ENTRY _ZTI6S480C5[];
extern  VTBL_ENTRY _ZTV6S480C5[];
extern Class_Descriptor cd_S480C4;
extern VTBL_ENTRY _ZTI6S480C4[];
extern  VTBL_ENTRY _ZTV6S480C4[];
extern Class_Descriptor cd_S480C3;
extern VTBL_ENTRY _ZTI6S480C3[];
extern  VTBL_ENTRY _ZTV6S480C3[];
static Base_Class bases_S480C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S480C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S480C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S480C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S480C2[];
extern void _ZN6S480C2D1Ev();
extern void _ZN6S480C2D0Ev();
extern void _ZN6S480C53v12Ev();
extern void _ZN6S480C53v13Ev();
extern void _ZN6S480C53v14Ev();
extern void _ZN6S480C53v15Ev();
extern void _ZN6S480C53v16Ev();
extern void _ZN6S480C53v17Ev();
extern void _ZN6S480C53v18Ev();
extern void _ZN6S480C53v19Ev();
extern void _ZN6S480C53v20Ev();
extern void _ZN6S480C53v21Ev();
extern void _ZN6S480C53v22Ev();
extern void _ZN6S480C53v23Ev();
extern void _ZN6S480C53v24Ev();
extern void _ZN6S480C53v25Ev();
extern void _ZN6S480C53v26Ev();
extern void _ZN6S480C53v27Ev();
extern void _ZN6S480C53v28Ev();
extern void _ZN6S480C53v29Ev();
extern void _ZN6S480C53v30Ev();
extern void _ZN6S480C53v31Ev();
extern void _ZN6S480C53v32Ev();
extern void _ZN6S480C53v33Ev();
extern void _ZN6S480C53v34Ev();
extern void _ZN6S480C53v35Ev();
extern void _ZN6S480C53v36Ev();
extern void _ZN6S480C53v37Ev();
extern void _ZN6S480C53v38Ev();
extern void _ZN6S480C53v39Ev();
extern void _ZN6S480C53v40Ev();
extern void _ZN6S480C53v41Ev();
extern void _ZN6S480C53v42Ev();
extern void _ZN6S480C53v43Ev();
extern void _ZN6S480C53v44Ev();
extern void _ZN6S480C53v45Ev();
extern void _ZN6S480C53v46Ev();
extern void _ZN6S480C53v47Ev();
extern void _ZN6S480C53v48Ev();
extern void _ZN6S480C53v49Ev();
extern void _ZN6S480C53v50Ev();
extern void _ZN6S480C53v51Ev();
extern void _ZN6S480C53v52Ev();
extern void _ZN6S480C53v53Ev();
extern void _ZN6S480C53v54Ev();
extern void _ZN6S480C53v55Ev();
extern void _ZN6S480C53v56Ev();
extern void _ZN6S480C53v57Ev();
extern void _ZN6S480C53v58Ev();
extern void _ZN6S480C53v59Ev();
extern void _ZN6S480C53v60Ev();
extern void _ZN6S480C53v61Ev();
extern void _ZN6S480C53v62Ev();
extern void _ZN6S480C53v63Ev();
extern void _ZN6S480C53v64Ev();
extern void _ZN6S480C53v65Ev();
extern void _ZN6S480C53v66Ev();
extern void _ZN6S480C53v67Ev();
extern void _ZN6S480C53v68Ev();
extern void _ZN6S480C53v69Ev();
extern void _ZN6S480C53v70Ev();
extern void _ZN6S480C53v71Ev();
extern void _ZN6S480C53v72Ev();
extern void _ZN6S480C53v73Ev();
extern void _ZN6S480C53v74Ev();
extern void _ZN6S480C53v75Ev();
extern void _ZN6S480C43v76Ev();
extern void _ZN6S480C43v77Ev();
extern void _ZN6S480C43v78Ev();
extern void _ZN6S480C43v79Ev();
extern void _ZN6S480C43v80Ev();
extern void _ZN6S480C33v81Ev();
extern void _ZN6S480C33v82Ev();
extern void _ZN6S480C33v83Ev();
extern void _ZN6S480C33v84Ev();
extern void _ZN6S480C33v85Ev();
extern void _ZN6S480C33v86Ev();
extern void _ZN6S480C33v87Ev();
extern void _ZN6S480C33v88Ev();
extern void _ZN6S480C33v89Ev();
extern void _ZN6S480C33v90Ev();
extern void _ZN6S480C33v91Ev();
extern void _ZN6S480C33v92Ev();
extern void _ZN6S480C33v93Ev();
extern void _ZN6S480C33v94Ev();
extern void _ZN6S480C33v95Ev();
extern void _ZN6S480C33v96Ev();
extern void _ZN6S480C33v97Ev();
extern void _ZN6S480C33v98Ev();
extern void _ZN6S480C33v99Ev();
extern void _ZN6S480C34v100Ev();
extern void _ZN6S480C34v101Ev();
extern void _ZN6S480C34v102Ev();
extern void _ZN6S480C24v103Ev();
extern void _ZN6S480C24v104Ev();
extern void _ZN6S480C24v105Ev();
extern void _ZN6S480C24v106Ev();
extern void _ZN6S480C24v107Ev();
extern void _ZN6S480C24v108Ev();
extern void _ZN6S480C24v109Ev();
extern void _ZN6S480C24v110Ev();
extern void _ZN6S480C24v111Ev();
extern void _ZN6S480C24v112Ev();
extern void _ZN6S480C24v113Ev();
extern void _ZN6S480C24v114Ev();
extern void _ZN6S480C24v115Ev();
extern void _ZN6S480C24v116Ev();
extern void _ZN6S480C24v117Ev();
extern void _ZN6S480C24v118Ev();
extern void _ZN6S480C24v119Ev();
extern void _ZN6S480C24v120Ev();
extern void _ZN6S480C24v121Ev();
extern void _ZN6S480C24v122Ev();
extern void _ZN6S480C24v123Ev();
extern void _ZN6S480C24v124Ev();
extern void _ZN6S480C24v125Ev();
extern void _ZN6S480C24v126Ev();
extern void _ZN6S480C24v127Ev();
extern void _ZN6S480C24v128Ev();
extern void _ZN6S480C24v129Ev();
extern void _ZN6S480C24v130Ev();
extern void _ZN6S480C24v131Ev();
extern void _ZN6S480C24v132Ev();
extern void _ZN6S480C24v133Ev();
extern void _ZN6S480C24v134Ev();
extern void _ZN6S480C24v135Ev();
extern void _ZN6S480C24v136Ev();
extern void _ZN6S480C24v137Ev();
extern void _ZN6S480C24v138Ev();
extern void _ZN6S480C24v139Ev();
extern void _ZN6S480C24v140Ev();
extern void _ZN6S480C24v141Ev();
extern void _ZN6S480C24v142Ev();
extern void _ZN6S480C24v143Ev();
extern void _ZN6S480C24v144Ev();
extern void _ZN6S480C24v145Ev();
extern void _ZN6S480C24v146Ev();
extern void _ZN6S480C24v147Ev();
extern void _ZN6S480C24v148Ev();
extern void _ZN6S480C24v149Ev();
extern void _ZN6S480C24v150Ev();
extern void _ZN6S480C24v151Ev();
extern void _ZN6S480C24v152Ev();
extern void _ZN6S480C24v153Ev();
extern void _ZN6S480C24v154Ev();
extern void _ZN6S480C24v155Ev();
extern void _ZN6S480C24v156Ev();
extern void _ZN6S480C24v157Ev();
extern void _ZN6S480C24v158Ev();
extern void _ZN6S480C24v159Ev();
extern void _ZN6S480C24v160Ev();
extern void _ZN6S480C24v161Ev();
extern void _ZN6S480C24v162Ev();
extern void _ZN6S480C24v163Ev();
static  VTBL_ENTRY vtc_S480C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S480C2[0]),
  (VTBL_ENTRY)&_ZN6S480C2D1Ev,
  (VTBL_ENTRY)&_ZN6S480C2D0Ev,
  (VTBL_ENTRY)&_ZN6S480C53v12Ev,
  (VTBL_ENTRY)&_ZN6S480C53v13Ev,
  (VTBL_ENTRY)&_ZN6S480C53v14Ev,
  (VTBL_ENTRY)&_ZN6S480C53v15Ev,
  (VTBL_ENTRY)&_ZN6S480C53v16Ev,
  (VTBL_ENTRY)&_ZN6S480C53v17Ev,
  (VTBL_ENTRY)&_ZN6S480C53v18Ev,
  (VTBL_ENTRY)&_ZN6S480C53v19Ev,
  (VTBL_ENTRY)&_ZN6S480C53v20Ev,
  (VTBL_ENTRY)&_ZN6S480C53v21Ev,
  (VTBL_ENTRY)&_ZN6S480C53v22Ev,
  (VTBL_ENTRY)&_ZN6S480C53v23Ev,
  (VTBL_ENTRY)&_ZN6S480C53v24Ev,
  (VTBL_ENTRY)&_ZN6S480C53v25Ev,
  (VTBL_ENTRY)&_ZN6S480C53v26Ev,
  (VTBL_ENTRY)&_ZN6S480C53v27Ev,
  (VTBL_ENTRY)&_ZN6S480C53v28Ev,
  (VTBL_ENTRY)&_ZN6S480C53v29Ev,
  (VTBL_ENTRY)&_ZN6S480C53v30Ev,
  (VTBL_ENTRY)&_ZN6S480C53v31Ev,
  (VTBL_ENTRY)&_ZN6S480C53v32Ev,
  (VTBL_ENTRY)&_ZN6S480C53v33Ev,
  (VTBL_ENTRY)&_ZN6S480C53v34Ev,
  (VTBL_ENTRY)&_ZN6S480C53v35Ev,
  (VTBL_ENTRY)&_ZN6S480C53v36Ev,
  (VTBL_ENTRY)&_ZN6S480C53v37Ev,
  (VTBL_ENTRY)&_ZN6S480C53v38Ev,
  (VTBL_ENTRY)&_ZN6S480C53v39Ev,
  (VTBL_ENTRY)&_ZN6S480C53v40Ev,
  (VTBL_ENTRY)&_ZN6S480C53v41Ev,
  (VTBL_ENTRY)&_ZN6S480C53v42Ev,
  (VTBL_ENTRY)&_ZN6S480C53v43Ev,
  (VTBL_ENTRY)&_ZN6S480C53v44Ev,
  (VTBL_ENTRY)&_ZN6S480C53v45Ev,
  (VTBL_ENTRY)&_ZN6S480C53v46Ev,
  (VTBL_ENTRY)&_ZN6S480C53v47Ev,
  (VTBL_ENTRY)&_ZN6S480C53v48Ev,
  (VTBL_ENTRY)&_ZN6S480C53v49Ev,
  (VTBL_ENTRY)&_ZN6S480C53v50Ev,
  (VTBL_ENTRY)&_ZN6S480C53v51Ev,
  (VTBL_ENTRY)&_ZN6S480C53v52Ev,
  (VTBL_ENTRY)&_ZN6S480C53v53Ev,
  (VTBL_ENTRY)&_ZN6S480C53v54Ev,
  (VTBL_ENTRY)&_ZN6S480C53v55Ev,
  (VTBL_ENTRY)&_ZN6S480C53v56Ev,
  (VTBL_ENTRY)&_ZN6S480C53v57Ev,
  (VTBL_ENTRY)&_ZN6S480C53v58Ev,
  (VTBL_ENTRY)&_ZN6S480C53v59Ev,
  (VTBL_ENTRY)&_ZN6S480C53v60Ev,
  (VTBL_ENTRY)&_ZN6S480C53v61Ev,
  (VTBL_ENTRY)&_ZN6S480C53v62Ev,
  (VTBL_ENTRY)&_ZN6S480C53v63Ev,
  (VTBL_ENTRY)&_ZN6S480C53v64Ev,
  (VTBL_ENTRY)&_ZN6S480C53v65Ev,
  (VTBL_ENTRY)&_ZN6S480C53v66Ev,
  (VTBL_ENTRY)&_ZN6S480C53v67Ev,
  (VTBL_ENTRY)&_ZN6S480C53v68Ev,
  (VTBL_ENTRY)&_ZN6S480C53v69Ev,
  (VTBL_ENTRY)&_ZN6S480C53v70Ev,
  (VTBL_ENTRY)&_ZN6S480C53v71Ev,
  (VTBL_ENTRY)&_ZN6S480C53v72Ev,
  (VTBL_ENTRY)&_ZN6S480C53v73Ev,
  (VTBL_ENTRY)&_ZN6S480C53v74Ev,
  (VTBL_ENTRY)&_ZN6S480C53v75Ev,
  (VTBL_ENTRY)&_ZN6S480C43v76Ev,
  (VTBL_ENTRY)&_ZN6S480C43v77Ev,
  (VTBL_ENTRY)&_ZN6S480C43v78Ev,
  (VTBL_ENTRY)&_ZN6S480C43v79Ev,
  (VTBL_ENTRY)&_ZN6S480C43v80Ev,
  (VTBL_ENTRY)&_ZN6S480C33v81Ev,
  (VTBL_ENTRY)&_ZN6S480C33v82Ev,
  (VTBL_ENTRY)&_ZN6S480C33v83Ev,
  (VTBL_ENTRY)&_ZN6S480C33v84Ev,
  (VTBL_ENTRY)&_ZN6S480C33v85Ev,
  (VTBL_ENTRY)&_ZN6S480C33v86Ev,
  (VTBL_ENTRY)&_ZN6S480C33v87Ev,
  (VTBL_ENTRY)&_ZN6S480C33v88Ev,
  (VTBL_ENTRY)&_ZN6S480C33v89Ev,
  (VTBL_ENTRY)&_ZN6S480C33v90Ev,
  (VTBL_ENTRY)&_ZN6S480C33v91Ev,
  (VTBL_ENTRY)&_ZN6S480C33v92Ev,
  (VTBL_ENTRY)&_ZN6S480C33v93Ev,
  (VTBL_ENTRY)&_ZN6S480C33v94Ev,
  (VTBL_ENTRY)&_ZN6S480C33v95Ev,
  (VTBL_ENTRY)&_ZN6S480C33v96Ev,
  (VTBL_ENTRY)&_ZN6S480C33v97Ev,
  (VTBL_ENTRY)&_ZN6S480C33v98Ev,
  (VTBL_ENTRY)&_ZN6S480C33v99Ev,
  (VTBL_ENTRY)&_ZN6S480C34v100Ev,
  (VTBL_ENTRY)&_ZN6S480C34v101Ev,
  (VTBL_ENTRY)&_ZN6S480C34v102Ev,
  (VTBL_ENTRY)&_ZN6S480C24v103Ev,
  (VTBL_ENTRY)&_ZN6S480C24v104Ev,
  (VTBL_ENTRY)&_ZN6S480C24v105Ev,
  (VTBL_ENTRY)&_ZN6S480C24v106Ev,
  (VTBL_ENTRY)&_ZN6S480C24v107Ev,
  (VTBL_ENTRY)&_ZN6S480C24v108Ev,
  (VTBL_ENTRY)&_ZN6S480C24v109Ev,
  (VTBL_ENTRY)&_ZN6S480C24v110Ev,
  (VTBL_ENTRY)&_ZN6S480C24v111Ev,
  (VTBL_ENTRY)&_ZN6S480C24v112Ev,
  (VTBL_ENTRY)&_ZN6S480C24v113Ev,
  (VTBL_ENTRY)&_ZN6S480C24v114Ev,
  (VTBL_ENTRY)&_ZN6S480C24v115Ev,
  (VTBL_ENTRY)&_ZN6S480C24v116Ev,
  (VTBL_ENTRY)&_ZN6S480C24v117Ev,
  (VTBL_ENTRY)&_ZN6S480C24v118Ev,
  (VTBL_ENTRY)&_ZN6S480C24v119Ev,
  (VTBL_ENTRY)&_ZN6S480C24v120Ev,
  (VTBL_ENTRY)&_ZN6S480C24v121Ev,
  (VTBL_ENTRY)&_ZN6S480C24v122Ev,
  (VTBL_ENTRY)&_ZN6S480C24v123Ev,
  (VTBL_ENTRY)&_ZN6S480C24v124Ev,
  (VTBL_ENTRY)&_ZN6S480C24v125Ev,
  (VTBL_ENTRY)&_ZN6S480C24v126Ev,
  (VTBL_ENTRY)&_ZN6S480C24v127Ev,
  (VTBL_ENTRY)&_ZN6S480C24v128Ev,
  (VTBL_ENTRY)&_ZN6S480C24v129Ev,
  (VTBL_ENTRY)&_ZN6S480C24v130Ev,
  (VTBL_ENTRY)&_ZN6S480C24v131Ev,
  (VTBL_ENTRY)&_ZN6S480C24v132Ev,
  (VTBL_ENTRY)&_ZN6S480C24v133Ev,
  (VTBL_ENTRY)&_ZN6S480C24v134Ev,
  (VTBL_ENTRY)&_ZN6S480C24v135Ev,
  (VTBL_ENTRY)&_ZN6S480C24v136Ev,
  (VTBL_ENTRY)&_ZN6S480C24v137Ev,
  (VTBL_ENTRY)&_ZN6S480C24v138Ev,
  (VTBL_ENTRY)&_ZN6S480C24v139Ev,
  (VTBL_ENTRY)&_ZN6S480C24v140Ev,
  (VTBL_ENTRY)&_ZN6S480C24v141Ev,
  (VTBL_ENTRY)&_ZN6S480C24v142Ev,
  (VTBL_ENTRY)&_ZN6S480C24v143Ev,
  (VTBL_ENTRY)&_ZN6S480C24v144Ev,
  (VTBL_ENTRY)&_ZN6S480C24v145Ev,
  (VTBL_ENTRY)&_ZN6S480C24v146Ev,
  (VTBL_ENTRY)&_ZN6S480C24v147Ev,
  (VTBL_ENTRY)&_ZN6S480C24v148Ev,
  (VTBL_ENTRY)&_ZN6S480C24v149Ev,
  (VTBL_ENTRY)&_ZN6S480C24v150Ev,
  (VTBL_ENTRY)&_ZN6S480C24v151Ev,
  (VTBL_ENTRY)&_ZN6S480C24v152Ev,
  (VTBL_ENTRY)&_ZN6S480C24v153Ev,
  (VTBL_ENTRY)&_ZN6S480C24v154Ev,
  (VTBL_ENTRY)&_ZN6S480C24v155Ev,
  (VTBL_ENTRY)&_ZN6S480C24v156Ev,
  (VTBL_ENTRY)&_ZN6S480C24v157Ev,
  (VTBL_ENTRY)&_ZN6S480C24v158Ev,
  (VTBL_ENTRY)&_ZN6S480C24v159Ev,
  (VTBL_ENTRY)&_ZN6S480C24v160Ev,
  (VTBL_ENTRY)&_ZN6S480C24v161Ev,
  (VTBL_ENTRY)&_ZN6S480C24v162Ev,
  (VTBL_ENTRY)&_ZN6S480C24v163Ev,
};
extern VTBL_ENTRY _ZTI6S480C2[];
extern  VTBL_ENTRY _ZTV6S480C2[];
Class_Descriptor cd_S480C2 = {  "S480C2", // class name
  bases_S480C2, 3,
  &(vtc_S480C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S480C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S480C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C18  {
  ::S236C25_nt s480c18f0;
  ::S95C35 s480c18f1;
  ::S95C31 s480c18f2;
  ::S95C27 s480c18f3;
  void *s480c18f4;
  void  mf480c18(); // _ZN7S480C188mf480c18Ev
};
//SIG(-1 S480C18) C1{ m FC2{ BC3{ BC4{ m Fp Fi[2]}}} FC5{ BC6{ BC4}} FC7{ BC8{ BC4}} FC9{ BC10{ BC4}} Fp}


void  S480C18 ::mf480c18(){}

static void Test_S480C18()
{
  {
    init_simple_test("S480C18");
    S480C18 lv;
    check2(sizeof(lv), ABISELECT(72,52), "sizeof(S480C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C18)");
    check_field_offset(lv, s480c18f0, 0, "S480C18.s480c18f0");
    check_field_offset(lv, s480c18f1, ABISELECT(16,12), "S480C18.s480c18f1");
    check_field_offset(lv, s480c18f2, ABISELECT(32,24), "S480C18.s480c18f2");
    check_field_offset(lv, s480c18f3, ABISELECT(48,36), "S480C18.s480c18f3");
    check_field_offset(lv, s480c18f4, ABISELECT(64,48), "S480C18.s480c18f4");
  }
}
static Arrange_To_Call_Me vS480C18(Test_S480C18, "S480C18", ABISELECT(72,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C27  {
  ::S236C26 s480c27f0;
};
//SIG(-1 S480C27) C1{ FC2{ BC3{ m Fp Fi[2]}}}



static void Test_S480C27()
{
  {
    init_simple_test("S480C27");
    S480C27 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S480C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C27)");
    check_field_offset(lv, s480c27f0, 0, "S480C27.s480c27f0");
  }
}
static Arrange_To_Call_Me vS480C27(Test_S480C27, "S480C27", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S480C1  : S480C2 {
  void *s480c1f0;
  ::S480C18 s480c1f1;
  void *s480c1f2;
  ::S480C27 s480c1f3;
  int s480c1f4;
  virtual  ~S480C1(); // _ZN6S480C1D1Ev
  virtual void  v1(); // _ZN6S480C12v1Ev
  virtual void  v2(); // _ZN6S480C12v2Ev
  virtual void  v3(); // _ZN6S480C12v3Ev
  virtual void  v4(); // _ZN6S480C12v4Ev
  virtual void  v5(); // _ZN6S480C12v5Ev
  virtual void  v6(); // _ZN6S480C12v6Ev
  virtual void  v7(); // _ZN6S480C12v7Ev
  virtual void  v8(); // _ZN6S480C12v8Ev
  virtual void  v9(); // _ZN6S480C12v9Ev
  virtual void  v10(); // _ZN6S480C13v10Ev
  virtual void  v11(); // _ZN6S480C13v11Ev
  S480C1(); // tgen
};
//SIG(1 S480C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79 v80 Fp FC6} vd v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp FC17{ m FC18{ BC19{ BC10}} FC20{ BC21{ BC10}} FC22{ BC23{ BC10}} FC24{ BC25{ BC10}} Fp} Fp FC26{ FC19} Fi}


 S480C1 ::~S480C1(){ note_dtor("S480C1", this);}
void  S480C1 ::v1(){vfunc_called(this, "_ZN6S480C12v1Ev");}
void  S480C1 ::v2(){vfunc_called(this, "_ZN6S480C12v2Ev");}
void  S480C1 ::v3(){vfunc_called(this, "_ZN6S480C12v3Ev");}
void  S480C1 ::v4(){vfunc_called(this, "_ZN6S480C12v4Ev");}
void  S480C1 ::v5(){vfunc_called(this, "_ZN6S480C12v5Ev");}
void  S480C1 ::v6(){vfunc_called(this, "_ZN6S480C12v6Ev");}
void  S480C1 ::v7(){vfunc_called(this, "_ZN6S480C12v7Ev");}
void  S480C1 ::v8(){vfunc_called(this, "_ZN6S480C12v8Ev");}
void  S480C1 ::v9(){vfunc_called(this, "_ZN6S480C12v9Ev");}
void  S480C1 ::v10(){vfunc_called(this, "_ZN6S480C13v10Ev");}
void  S480C1 ::v11(){vfunc_called(this, "_ZN6S480C13v11Ev");}
S480C1 ::S480C1(){ note_ctor("S480C1", this);} // tgen

static void Test_S480C1()
{
  extern Class_Descriptor cd_S480C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,88)];
    init_test(&cd_S480C1, buf);
    S480C1 *dp, &lv = *(dp=new (buf) S480C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,348), "sizeof(S480C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S480C1)");
    check_base_class_offset(lv, (S480C5*)(S480C4*)(S480C3*)(S480C2*), 0, "S480C1");
    check_base_class_offset(lv, (S480C4*)(S480C3*)(S480C2*), 0, "S480C1");
    check_base_class_offset(lv, (S480C3*)(S480C2*), 0, "S480C1");
    check_base_class_offset(lv, (S480C2*), 0, "S480C1");
    check_field_offset(lv, s480c1f0, ABISELECT(368,272), "S480C1.s480c1f0");
    check_field_offset(lv, s480c1f1, ABISELECT(376,276), "S480C1.s480c1f1");
    check_field_offset(lv, s480c1f2, ABISELECT(448,328), "S480C1.s480c1f2");
    check_field_offset(lv, s480c1f3, ABISELECT(456,332), "S480C1.s480c1f3");
    check_field_offset(lv, s480c1f4, ABISELECT(472,344), "S480C1.s480c1f4");
    test_class_info(&lv, &cd_S480C1);
    dp->~S480C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS480C1(Test_S480C1, "S480C1", ABISELECT(480,348));

#else // __cplusplus

extern void _ZN6S480C1C1Ev();
extern void _ZN6S480C1D1Ev();
Name_Map name_map_S480C1[] = {
  NSPAIR(_ZN6S480C1C1Ev),
  NSPAIR(_ZN6S480C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S480C5;
extern VTBL_ENTRY _ZTI6S480C5[];
extern  VTBL_ENTRY _ZTV6S480C5[];
extern Class_Descriptor cd_S480C4;
extern VTBL_ENTRY _ZTI6S480C4[];
extern  VTBL_ENTRY _ZTV6S480C4[];
extern Class_Descriptor cd_S480C3;
extern VTBL_ENTRY _ZTI6S480C3[];
extern  VTBL_ENTRY _ZTV6S480C3[];
extern Class_Descriptor cd_S480C2;
extern VTBL_ENTRY _ZTI6S480C2[];
extern  VTBL_ENTRY _ZTV6S480C2[];
static Base_Class bases_S480C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S480C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S480C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S480C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S480C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S480C1[];
extern void _ZN6S480C1D1Ev();
extern void _ZN6S480C1D0Ev();
extern void _ZN6S480C53v12Ev();
extern void _ZN6S480C53v13Ev();
extern void _ZN6S480C53v14Ev();
extern void _ZN6S480C53v15Ev();
extern void _ZN6S480C53v16Ev();
extern void _ZN6S480C53v17Ev();
extern void _ZN6S480C53v18Ev();
extern void _ZN6S480C53v19Ev();
extern void _ZN6S480C53v20Ev();
extern void _ZN6S480C53v21Ev();
extern void _ZN6S480C53v22Ev();
extern void _ZN6S480C53v23Ev();
extern void _ZN6S480C53v24Ev();
extern void _ZN6S480C53v25Ev();
extern void _ZN6S480C53v26Ev();
extern void _ZN6S480C53v27Ev();
extern void _ZN6S480C53v28Ev();
extern void _ZN6S480C53v29Ev();
extern void _ZN6S480C53v30Ev();
extern void _ZN6S480C53v31Ev();
extern void _ZN6S480C53v32Ev();
extern void _ZN6S480C53v33Ev();
extern void _ZN6S480C53v34Ev();
extern void _ZN6S480C53v35Ev();
extern void _ZN6S480C53v36Ev();
extern void _ZN6S480C53v37Ev();
extern void _ZN6S480C53v38Ev();
extern void _ZN6S480C53v39Ev();
extern void _ZN6S480C53v40Ev();
extern void _ZN6S480C53v41Ev();
extern void _ZN6S480C53v42Ev();
extern void _ZN6S480C53v43Ev();
extern void _ZN6S480C53v44Ev();
extern void _ZN6S480C53v45Ev();
extern void _ZN6S480C53v46Ev();
extern void _ZN6S480C53v47Ev();
extern void _ZN6S480C53v48Ev();
extern void _ZN6S480C53v49Ev();
extern void _ZN6S480C53v50Ev();
extern void _ZN6S480C53v51Ev();
extern void _ZN6S480C53v52Ev();
extern void _ZN6S480C53v53Ev();
extern void _ZN6S480C53v54Ev();
extern void _ZN6S480C53v55Ev();
extern void _ZN6S480C53v56Ev();
extern void _ZN6S480C53v57Ev();
extern void _ZN6S480C53v58Ev();
extern void _ZN6S480C53v59Ev();
extern void _ZN6S480C53v60Ev();
extern void _ZN6S480C53v61Ev();
extern void _ZN6S480C53v62Ev();
extern void _ZN6S480C53v63Ev();
extern void _ZN6S480C53v64Ev();
extern void _ZN6S480C53v65Ev();
extern void _ZN6S480C53v66Ev();
extern void _ZN6S480C53v67Ev();
extern void _ZN6S480C53v68Ev();
extern void _ZN6S480C53v69Ev();
extern void _ZN6S480C53v70Ev();
extern void _ZN6S480C53v71Ev();
extern void _ZN6S480C53v72Ev();
extern void _ZN6S480C53v73Ev();
extern void _ZN6S480C53v74Ev();
extern void _ZN6S480C53v75Ev();
extern void _ZN6S480C43v76Ev();
extern void _ZN6S480C43v77Ev();
extern void _ZN6S480C43v78Ev();
extern void _ZN6S480C43v79Ev();
extern void _ZN6S480C43v80Ev();
extern void _ZN6S480C33v81Ev();
extern void _ZN6S480C33v82Ev();
extern void _ZN6S480C33v83Ev();
extern void _ZN6S480C33v84Ev();
extern void _ZN6S480C33v85Ev();
extern void _ZN6S480C33v86Ev();
extern void _ZN6S480C33v87Ev();
extern void _ZN6S480C33v88Ev();
extern void _ZN6S480C33v89Ev();
extern void _ZN6S480C33v90Ev();
extern void _ZN6S480C33v91Ev();
extern void _ZN6S480C33v92Ev();
extern void _ZN6S480C33v93Ev();
extern void _ZN6S480C33v94Ev();
extern void _ZN6S480C33v95Ev();
extern void _ZN6S480C33v96Ev();
extern void _ZN6S480C33v97Ev();
extern void _ZN6S480C33v98Ev();
extern void _ZN6S480C33v99Ev();
extern void _ZN6S480C34v100Ev();
extern void _ZN6S480C34v101Ev();
extern void _ZN6S480C34v102Ev();
extern void _ZN6S480C24v103Ev();
extern void _ZN6S480C24v104Ev();
extern void _ZN6S480C24v105Ev();
extern void _ZN6S480C24v106Ev();
extern void _ZN6S480C24v107Ev();
extern void _ZN6S480C24v108Ev();
extern void _ZN6S480C24v109Ev();
extern void _ZN6S480C24v110Ev();
extern void _ZN6S480C24v111Ev();
extern void _ZN6S480C24v112Ev();
extern void _ZN6S480C24v113Ev();
extern void _ZN6S480C24v114Ev();
extern void _ZN6S480C24v115Ev();
extern void _ZN6S480C24v116Ev();
extern void _ZN6S480C24v117Ev();
extern void _ZN6S480C24v118Ev();
extern void _ZN6S480C24v119Ev();
extern void _ZN6S480C24v120Ev();
extern void _ZN6S480C24v121Ev();
extern void _ZN6S480C24v122Ev();
extern void _ZN6S480C24v123Ev();
extern void _ZN6S480C24v124Ev();
extern void _ZN6S480C24v125Ev();
extern void _ZN6S480C24v126Ev();
extern void _ZN6S480C24v127Ev();
extern void _ZN6S480C24v128Ev();
extern void _ZN6S480C24v129Ev();
extern void _ZN6S480C24v130Ev();
extern void _ZN6S480C24v131Ev();
extern void _ZN6S480C24v132Ev();
extern void _ZN6S480C24v133Ev();
extern void _ZN6S480C24v134Ev();
extern void _ZN6S480C24v135Ev();
extern void _ZN6S480C24v136Ev();
extern void _ZN6S480C24v137Ev();
extern void _ZN6S480C24v138Ev();
extern void _ZN6S480C24v139Ev();
extern void _ZN6S480C24v140Ev();
extern void _ZN6S480C24v141Ev();
extern void _ZN6S480C24v142Ev();
extern void _ZN6S480C24v143Ev();
extern void _ZN6S480C24v144Ev();
extern void _ZN6S480C24v145Ev();
extern void _ZN6S480C24v146Ev();
extern void _ZN6S480C24v147Ev();
extern void _ZN6S480C24v148Ev();
extern void _ZN6S480C24v149Ev();
extern void _ZN6S480C24v150Ev();
extern void _ZN6S480C24v151Ev();
extern void _ZN6S480C24v152Ev();
extern void _ZN6S480C24v153Ev();
extern void _ZN6S480C24v154Ev();
extern void _ZN6S480C24v155Ev();
extern void _ZN6S480C24v156Ev();
extern void _ZN6S480C24v157Ev();
extern void _ZN6S480C24v158Ev();
extern void _ZN6S480C24v159Ev();
extern void _ZN6S480C24v160Ev();
extern void _ZN6S480C24v161Ev();
extern void _ZN6S480C24v162Ev();
extern void _ZN6S480C24v163Ev();
extern void _ZN6S480C12v1Ev();
extern void _ZN6S480C12v2Ev();
extern void _ZN6S480C12v3Ev();
extern void _ZN6S480C12v4Ev();
extern void _ZN6S480C12v5Ev();
extern void _ZN6S480C12v6Ev();
extern void _ZN6S480C12v7Ev();
extern void _ZN6S480C12v8Ev();
extern void _ZN6S480C12v9Ev();
extern void _ZN6S480C13v10Ev();
extern void _ZN6S480C13v11Ev();
static  VTBL_ENTRY vtc_S480C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S480C1[0]),
  (VTBL_ENTRY)&_ZN6S480C1D1Ev,
  (VTBL_ENTRY)&_ZN6S480C1D0Ev,
  (VTBL_ENTRY)&_ZN6S480C53v12Ev,
  (VTBL_ENTRY)&_ZN6S480C53v13Ev,
  (VTBL_ENTRY)&_ZN6S480C53v14Ev,
  (VTBL_ENTRY)&_ZN6S480C53v15Ev,
  (VTBL_ENTRY)&_ZN6S480C53v16Ev,
  (VTBL_ENTRY)&_ZN6S480C53v17Ev,
  (VTBL_ENTRY)&_ZN6S480C53v18Ev,
  (VTBL_ENTRY)&_ZN6S480C53v19Ev,
  (VTBL_ENTRY)&_ZN6S480C53v20Ev,
  (VTBL_ENTRY)&_ZN6S480C53v21Ev,
  (VTBL_ENTRY)&_ZN6S480C53v22Ev,
  (VTBL_ENTRY)&_ZN6S480C53v23Ev,
  (VTBL_ENTRY)&_ZN6S480C53v24Ev,
  (VTBL_ENTRY)&_ZN6S480C53v25Ev,
  (VTBL_ENTRY)&_ZN6S480C53v26Ev,
  (VTBL_ENTRY)&_ZN6S480C53v27Ev,
  (VTBL_ENTRY)&_ZN6S480C53v28Ev,
  (VTBL_ENTRY)&_ZN6S480C53v29Ev,
  (VTBL_ENTRY)&_ZN6S480C53v30Ev,
  (VTBL_ENTRY)&_ZN6S480C53v31Ev,
  (VTBL_ENTRY)&_ZN6S480C53v32Ev,
  (VTBL_ENTRY)&_ZN6S480C53v33Ev,
  (VTBL_ENTRY)&_ZN6S480C53v34Ev,
  (VTBL_ENTRY)&_ZN6S480C53v35Ev,
  (VTBL_ENTRY)&_ZN6S480C53v36Ev,
  (VTBL_ENTRY)&_ZN6S480C53v37Ev,
  (VTBL_ENTRY)&_ZN6S480C53v38Ev,
  (VTBL_ENTRY)&_ZN6S480C53v39Ev,
  (VTBL_ENTRY)&_ZN6S480C53v40Ev,
  (VTBL_ENTRY)&_ZN6S480C53v41Ev,
  (VTBL_ENTRY)&_ZN6S480C53v42Ev,
  (VTBL_ENTRY)&_ZN6S480C53v43Ev,
  (VTBL_ENTRY)&_ZN6S480C53v44Ev,
  (VTBL_ENTRY)&_ZN6S480C53v45Ev,
  (VTBL_ENTRY)&_ZN6S480C53v46Ev,
  (VTBL_ENTRY)&_ZN6S480C53v47Ev,
  (VTBL_ENTRY)&_ZN6S480C53v48Ev,
  (VTBL_ENTRY)&_ZN6S480C53v49Ev,
  (VTBL_ENTRY)&_ZN6S480C53v50Ev,
  (VTBL_ENTRY)&_ZN6S480C53v51Ev,
  (VTBL_ENTRY)&_ZN6S480C53v52Ev,
  (VTBL_ENTRY)&_ZN6S480C53v53Ev,
  (VTBL_ENTRY)&_ZN6S480C53v54Ev,
  (VTBL_ENTRY)&_ZN6S480C53v55Ev,
  (VTBL_ENTRY)&_ZN6S480C53v56Ev,
  (VTBL_ENTRY)&_ZN6S480C53v57Ev,
  (VTBL_ENTRY)&_ZN6S480C53v58Ev,
  (VTBL_ENTRY)&_ZN6S480C53v59Ev,
  (VTBL_ENTRY)&_ZN6S480C53v60Ev,
  (VTBL_ENTRY)&_ZN6S480C53v61Ev,
  (VTBL_ENTRY)&_ZN6S480C53v62Ev,
  (VTBL_ENTRY)&_ZN6S480C53v63Ev,
  (VTBL_ENTRY)&_ZN6S480C53v64Ev,
  (VTBL_ENTRY)&_ZN6S480C53v65Ev,
  (VTBL_ENTRY)&_ZN6S480C53v66Ev,
  (VTBL_ENTRY)&_ZN6S480C53v67Ev,
  (VTBL_ENTRY)&_ZN6S480C53v68Ev,
  (VTBL_ENTRY)&_ZN6S480C53v69Ev,
  (VTBL_ENTRY)&_ZN6S480C53v70Ev,
  (VTBL_ENTRY)&_ZN6S480C53v71Ev,
  (VTBL_ENTRY)&_ZN6S480C53v72Ev,
  (VTBL_ENTRY)&_ZN6S480C53v73Ev,
  (VTBL_ENTRY)&_ZN6S480C53v74Ev,
  (VTBL_ENTRY)&_ZN6S480C53v75Ev,
  (VTBL_ENTRY)&_ZN6S480C43v76Ev,
  (VTBL_ENTRY)&_ZN6S480C43v77Ev,
  (VTBL_ENTRY)&_ZN6S480C43v78Ev,
  (VTBL_ENTRY)&_ZN6S480C43v79Ev,
  (VTBL_ENTRY)&_ZN6S480C43v80Ev,
  (VTBL_ENTRY)&_ZN6S480C33v81Ev,
  (VTBL_ENTRY)&_ZN6S480C33v82Ev,
  (VTBL_ENTRY)&_ZN6S480C33v83Ev,
  (VTBL_ENTRY)&_ZN6S480C33v84Ev,
  (VTBL_ENTRY)&_ZN6S480C33v85Ev,
  (VTBL_ENTRY)&_ZN6S480C33v86Ev,
  (VTBL_ENTRY)&_ZN6S480C33v87Ev,
  (VTBL_ENTRY)&_ZN6S480C33v88Ev,
  (VTBL_ENTRY)&_ZN6S480C33v89Ev,
  (VTBL_ENTRY)&_ZN6S480C33v90Ev,
  (VTBL_ENTRY)&_ZN6S480C33v91Ev,
  (VTBL_ENTRY)&_ZN6S480C33v92Ev,
  (VTBL_ENTRY)&_ZN6S480C33v93Ev,
  (VTBL_ENTRY)&_ZN6S480C33v94Ev,
  (VTBL_ENTRY)&_ZN6S480C33v95Ev,
  (VTBL_ENTRY)&_ZN6S480C33v96Ev,
  (VTBL_ENTRY)&_ZN6S480C33v97Ev,
  (VTBL_ENTRY)&_ZN6S480C33v98Ev,
  (VTBL_ENTRY)&_ZN6S480C33v99Ev,
  (VTBL_ENTRY)&_ZN6S480C34v100Ev,
  (VTBL_ENTRY)&_ZN6S480C34v101Ev,
  (VTBL_ENTRY)&_ZN6S480C34v102Ev,
  (VTBL_ENTRY)&_ZN6S480C24v103Ev,
  (VTBL_ENTRY)&_ZN6S480C24v104Ev,
  (VTBL_ENTRY)&_ZN6S480C24v105Ev,
  (VTBL_ENTRY)&_ZN6S480C24v106Ev,
  (VTBL_ENTRY)&_ZN6S480C24v107Ev,
  (VTBL_ENTRY)&_ZN6S480C24v108Ev,
  (VTBL_ENTRY)&_ZN6S480C24v109Ev,
  (VTBL_ENTRY)&_ZN6S480C24v110Ev,
  (VTBL_ENTRY)&_ZN6S480C24v111Ev,
  (VTBL_ENTRY)&_ZN6S480C24v112Ev,
  (VTBL_ENTRY)&_ZN6S480C24v113Ev,
  (VTBL_ENTRY)&_ZN6S480C24v114Ev,
  (VTBL_ENTRY)&_ZN6S480C24v115Ev,
  (VTBL_ENTRY)&_ZN6S480C24v116Ev,
  (VTBL_ENTRY)&_ZN6S480C24v117Ev,
  (VTBL_ENTRY)&_ZN6S480C24v118Ev,
  (VTBL_ENTRY)&_ZN6S480C24v119Ev,
  (VTBL_ENTRY)&_ZN6S480C24v120Ev,
  (VTBL_ENTRY)&_ZN6S480C24v121Ev,
  (VTBL_ENTRY)&_ZN6S480C24v122Ev,
  (VTBL_ENTRY)&_ZN6S480C24v123Ev,
  (VTBL_ENTRY)&_ZN6S480C24v124Ev,
  (VTBL_ENTRY)&_ZN6S480C24v125Ev,
  (VTBL_ENTRY)&_ZN6S480C24v126Ev,
  (VTBL_ENTRY)&_ZN6S480C24v127Ev,
  (VTBL_ENTRY)&_ZN6S480C24v128Ev,
  (VTBL_ENTRY)&_ZN6S480C24v129Ev,
  (VTBL_ENTRY)&_ZN6S480C24v130Ev,
  (VTBL_ENTRY)&_ZN6S480C24v131Ev,
  (VTBL_ENTRY)&_ZN6S480C24v132Ev,
  (VTBL_ENTRY)&_ZN6S480C24v133Ev,
  (VTBL_ENTRY)&_ZN6S480C24v134Ev,
  (VTBL_ENTRY)&_ZN6S480C24v135Ev,
  (VTBL_ENTRY)&_ZN6S480C24v136Ev,
  (VTBL_ENTRY)&_ZN6S480C24v137Ev,
  (VTBL_ENTRY)&_ZN6S480C24v138Ev,
  (VTBL_ENTRY)&_ZN6S480C24v139Ev,
  (VTBL_ENTRY)&_ZN6S480C24v140Ev,
  (VTBL_ENTRY)&_ZN6S480C24v141Ev,
  (VTBL_ENTRY)&_ZN6S480C24v142Ev,
  (VTBL_ENTRY)&_ZN6S480C24v143Ev,
  (VTBL_ENTRY)&_ZN6S480C24v144Ev,
  (VTBL_ENTRY)&_ZN6S480C24v145Ev,
  (VTBL_ENTRY)&_ZN6S480C24v146Ev,
  (VTBL_ENTRY)&_ZN6S480C24v147Ev,
  (VTBL_ENTRY)&_ZN6S480C24v148Ev,
  (VTBL_ENTRY)&_ZN6S480C24v149Ev,
  (VTBL_ENTRY)&_ZN6S480C24v150Ev,
  (VTBL_ENTRY)&_ZN6S480C24v151Ev,
  (VTBL_ENTRY)&_ZN6S480C24v152Ev,
  (VTBL_ENTRY)&_ZN6S480C24v153Ev,
  (VTBL_ENTRY)&_ZN6S480C24v154Ev,
  (VTBL_ENTRY)&_ZN6S480C24v155Ev,
  (VTBL_ENTRY)&_ZN6S480C24v156Ev,
  (VTBL_ENTRY)&_ZN6S480C24v157Ev,
  (VTBL_ENTRY)&_ZN6S480C24v158Ev,
  (VTBL_ENTRY)&_ZN6S480C24v159Ev,
  (VTBL_ENTRY)&_ZN6S480C24v160Ev,
  (VTBL_ENTRY)&_ZN6S480C24v161Ev,
  (VTBL_ENTRY)&_ZN6S480C24v162Ev,
  (VTBL_ENTRY)&_ZN6S480C24v163Ev,
  (VTBL_ENTRY)&_ZN6S480C12v1Ev,
  (VTBL_ENTRY)&_ZN6S480C12v2Ev,
  (VTBL_ENTRY)&_ZN6S480C12v3Ev,
  (VTBL_ENTRY)&_ZN6S480C12v4Ev,
  (VTBL_ENTRY)&_ZN6S480C12v5Ev,
  (VTBL_ENTRY)&_ZN6S480C12v6Ev,
  (VTBL_ENTRY)&_ZN6S480C12v7Ev,
  (VTBL_ENTRY)&_ZN6S480C12v8Ev,
  (VTBL_ENTRY)&_ZN6S480C12v9Ev,
  (VTBL_ENTRY)&_ZN6S480C13v10Ev,
  (VTBL_ENTRY)&_ZN6S480C13v11Ev,
};
extern VTBL_ENTRY _ZTI6S480C1[];
extern  VTBL_ENTRY _ZTV6S480C1[];
Class_Descriptor cd_S480C1 = {  "S480C1", // class name
  bases_S480C1, 4,
  &(vtc_S480C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,348), // object size
  NSPAIRA(_ZTI6S480C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S480C1),167, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C5  {
  int s494c5f0;
  __tsi64 s494c5f1;
  void *s494c5f2[4];
  int s494c5f3[2];
  void *s494c5f4;
  ::S95C8_nt s494c5f5;
  void *s494c5f6[2];
  virtual  ~S494C5(); // _ZN6S494C5D1Ev
  virtual void  v17(); // _ZN6S494C53v17Ev
  virtual void  v18(); // _ZN6S494C53v18Ev
  virtual void  v19(); // _ZN6S494C53v19Ev
  virtual void  v20(); // _ZN6S494C53v20Ev
  virtual void  v21(); // _ZN6S494C53v21Ev
  virtual void  v22(); // _ZN6S494C53v22Ev
  virtual void  v23(); // _ZN6S494C53v23Ev
  virtual void  v24(); // _ZN6S494C53v24Ev
  virtual void  v25(); // _ZN6S494C53v25Ev
  virtual void  v26(); // _ZN6S494C53v26Ev
  virtual void  v27(); // _ZN6S494C53v27Ev
  virtual void  v28(); // _ZN6S494C53v28Ev
  virtual void  v29(); // _ZN6S494C53v29Ev
  virtual void  v30(); // _ZN6S494C53v30Ev
  virtual void  v31(); // _ZN6S494C53v31Ev
  virtual void  v32(); // _ZN6S494C53v32Ev
  virtual void  v33(); // _ZN6S494C53v33Ev
  virtual void  v34(); // _ZN6S494C53v34Ev
  virtual void  v35(); // _ZN6S494C53v35Ev
  virtual void  v36(); // _ZN6S494C53v36Ev
  virtual void  v37(); // _ZN6S494C53v37Ev
  virtual void  v38(); // _ZN6S494C53v38Ev
  virtual void  v39(); // _ZN6S494C53v39Ev
  virtual void  v40(); // _ZN6S494C53v40Ev
  virtual void  v41(); // _ZN6S494C53v41Ev
  virtual void  v42(); // _ZN6S494C53v42Ev
  virtual void  v43(); // _ZN6S494C53v43Ev
  virtual void  v44(); // _ZN6S494C53v44Ev
  virtual void  v45(); // _ZN6S494C53v45Ev
  virtual void  v46(); // _ZN6S494C53v46Ev
  virtual void  v47(); // _ZN6S494C53v47Ev
  virtual void  v48(); // _ZN6S494C53v48Ev
  virtual void  v49(); // _ZN6S494C53v49Ev
  virtual void  v50(); // _ZN6S494C53v50Ev
  virtual void  v51(); // _ZN6S494C53v51Ev
  virtual void  v52(); // _ZN6S494C53v52Ev
  virtual void  v53(); // _ZN6S494C53v53Ev
  virtual void  v54(); // _ZN6S494C53v54Ev
  virtual void  v55(); // _ZN6S494C53v55Ev
  virtual void  v56(); // _ZN6S494C53v56Ev
  virtual void  v57(); // _ZN6S494C53v57Ev
  virtual void  v58(); // _ZN6S494C53v58Ev
  virtual void  v59(); // _ZN6S494C53v59Ev
  virtual void  v60(); // _ZN6S494C53v60Ev
  virtual void  v61(); // _ZN6S494C53v61Ev
  virtual void  v62(); // _ZN6S494C53v62Ev
  virtual void  v63(); // _ZN6S494C53v63Ev
  virtual void  v64(); // _ZN6S494C53v64Ev
  virtual void  v65(); // _ZN6S494C53v65Ev
  virtual void  v66(); // _ZN6S494C53v66Ev
  virtual void  v67(); // _ZN6S494C53v67Ev
  virtual void  v68(); // _ZN6S494C53v68Ev
  virtual void  v69(); // _ZN6S494C53v69Ev
  virtual void  v70(); // _ZN6S494C53v70Ev
  virtual void  v71(); // _ZN6S494C53v71Ev
  virtual void  v72(); // _ZN6S494C53v72Ev
  virtual void  v73(); // _ZN6S494C53v73Ev
  virtual void  v74(); // _ZN6S494C53v74Ev
  virtual void  v75(); // _ZN6S494C53v75Ev
  virtual void  v76(); // _ZN6S494C53v76Ev
  virtual void  v77(); // _ZN6S494C53v77Ev
  virtual void  v78(); // _ZN6S494C53v78Ev
  virtual void  v79(); // _ZN6S494C53v79Ev
  virtual void  v80(); // _ZN6S494C53v80Ev
  S494C5(); // tgen
};
//SIG(-1 S494C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S494C5 ::~S494C5(){ note_dtor("S494C5", this);}
void  S494C5 ::v17(){vfunc_called(this, "_ZN6S494C53v17Ev");}
void  S494C5 ::v18(){vfunc_called(this, "_ZN6S494C53v18Ev");}
void  S494C5 ::v19(){vfunc_called(this, "_ZN6S494C53v19Ev");}
void  S494C5 ::v20(){vfunc_called(this, "_ZN6S494C53v20Ev");}
void  S494C5 ::v21(){vfunc_called(this, "_ZN6S494C53v21Ev");}
void  S494C5 ::v22(){vfunc_called(this, "_ZN6S494C53v22Ev");}
void  S494C5 ::v23(){vfunc_called(this, "_ZN6S494C53v23Ev");}
void  S494C5 ::v24(){vfunc_called(this, "_ZN6S494C53v24Ev");}
void  S494C5 ::v25(){vfunc_called(this, "_ZN6S494C53v25Ev");}
void  S494C5 ::v26(){vfunc_called(this, "_ZN6S494C53v26Ev");}
void  S494C5 ::v27(){vfunc_called(this, "_ZN6S494C53v27Ev");}
void  S494C5 ::v28(){vfunc_called(this, "_ZN6S494C53v28Ev");}
void  S494C5 ::v29(){vfunc_called(this, "_ZN6S494C53v29Ev");}
void  S494C5 ::v30(){vfunc_called(this, "_ZN6S494C53v30Ev");}
void  S494C5 ::v31(){vfunc_called(this, "_ZN6S494C53v31Ev");}
void  S494C5 ::v32(){vfunc_called(this, "_ZN6S494C53v32Ev");}
void  S494C5 ::v33(){vfunc_called(this, "_ZN6S494C53v33Ev");}
void  S494C5 ::v34(){vfunc_called(this, "_ZN6S494C53v34Ev");}
void  S494C5 ::v35(){vfunc_called(this, "_ZN6S494C53v35Ev");}
void  S494C5 ::v36(){vfunc_called(this, "_ZN6S494C53v36Ev");}
void  S494C5 ::v37(){vfunc_called(this, "_ZN6S494C53v37Ev");}
void  S494C5 ::v38(){vfunc_called(this, "_ZN6S494C53v38Ev");}
void  S494C5 ::v39(){vfunc_called(this, "_ZN6S494C53v39Ev");}
void  S494C5 ::v40(){vfunc_called(this, "_ZN6S494C53v40Ev");}
void  S494C5 ::v41(){vfunc_called(this, "_ZN6S494C53v41Ev");}
void  S494C5 ::v42(){vfunc_called(this, "_ZN6S494C53v42Ev");}
void  S494C5 ::v43(){vfunc_called(this, "_ZN6S494C53v43Ev");}
void  S494C5 ::v44(){vfunc_called(this, "_ZN6S494C53v44Ev");}
void  S494C5 ::v45(){vfunc_called(this, "_ZN6S494C53v45Ev");}
void  S494C5 ::v46(){vfunc_called(this, "_ZN6S494C53v46Ev");}
void  S494C5 ::v47(){vfunc_called(this, "_ZN6S494C53v47Ev");}
void  S494C5 ::v48(){vfunc_called(this, "_ZN6S494C53v48Ev");}
void  S494C5 ::v49(){vfunc_called(this, "_ZN6S494C53v49Ev");}
void  S494C5 ::v50(){vfunc_called(this, "_ZN6S494C53v50Ev");}
void  S494C5 ::v51(){vfunc_called(this, "_ZN6S494C53v51Ev");}
void  S494C5 ::v52(){vfunc_called(this, "_ZN6S494C53v52Ev");}
void  S494C5 ::v53(){vfunc_called(this, "_ZN6S494C53v53Ev");}
void  S494C5 ::v54(){vfunc_called(this, "_ZN6S494C53v54Ev");}
void  S494C5 ::v55(){vfunc_called(this, "_ZN6S494C53v55Ev");}
void  S494C5 ::v56(){vfunc_called(this, "_ZN6S494C53v56Ev");}
void  S494C5 ::v57(){vfunc_called(this, "_ZN6S494C53v57Ev");}
void  S494C5 ::v58(){vfunc_called(this, "_ZN6S494C53v58Ev");}
void  S494C5 ::v59(){vfunc_called(this, "_ZN6S494C53v59Ev");}
void  S494C5 ::v60(){vfunc_called(this, "_ZN6S494C53v60Ev");}
void  S494C5 ::v61(){vfunc_called(this, "_ZN6S494C53v61Ev");}
void  S494C5 ::v62(){vfunc_called(this, "_ZN6S494C53v62Ev");}
void  S494C5 ::v63(){vfunc_called(this, "_ZN6S494C53v63Ev");}
void  S494C5 ::v64(){vfunc_called(this, "_ZN6S494C53v64Ev");}
void  S494C5 ::v65(){vfunc_called(this, "_ZN6S494C53v65Ev");}
void  S494C5 ::v66(){vfunc_called(this, "_ZN6S494C53v66Ev");}
void  S494C5 ::v67(){vfunc_called(this, "_ZN6S494C53v67Ev");}
void  S494C5 ::v68(){vfunc_called(this, "_ZN6S494C53v68Ev");}
void  S494C5 ::v69(){vfunc_called(this, "_ZN6S494C53v69Ev");}
void  S494C5 ::v70(){vfunc_called(this, "_ZN6S494C53v70Ev");}
void  S494C5 ::v71(){vfunc_called(this, "_ZN6S494C53v71Ev");}
void  S494C5 ::v72(){vfunc_called(this, "_ZN6S494C53v72Ev");}
void  S494C5 ::v73(){vfunc_called(this, "_ZN6S494C53v73Ev");}
void  S494C5 ::v74(){vfunc_called(this, "_ZN6S494C53v74Ev");}
void  S494C5 ::v75(){vfunc_called(this, "_ZN6S494C53v75Ev");}
void  S494C5 ::v76(){vfunc_called(this, "_ZN6S494C53v76Ev");}
void  S494C5 ::v77(){vfunc_called(this, "_ZN6S494C53v77Ev");}
void  S494C5 ::v78(){vfunc_called(this, "_ZN6S494C53v78Ev");}
void  S494C5 ::v79(){vfunc_called(this, "_ZN6S494C53v79Ev");}
void  S494C5 ::v80(){vfunc_called(this, "_ZN6S494C53v80Ev");}
S494C5 ::S494C5(){ note_ctor("S494C5", this);} // tgen

static void Test_S494C5()
{
  extern Class_Descriptor cd_S494C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S494C5, buf);
    S494C5 *dp, &lv = *(dp=new (buf) S494C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S494C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C5)");
    check_field_offset(lv, s494c5f0, ABISELECT(8,4), "S494C5.s494c5f0");
    check_field_offset(lv, s494c5f1, ABISELECT(16,8), "S494C5.s494c5f1");
    check_field_offset(lv, s494c5f2, ABISELECT(24,16), "S494C5.s494c5f2");
    check_field_offset(lv, s494c5f3, ABISELECT(56,32), "S494C5.s494c5f3");
    check_field_offset(lv, s494c5f4, ABISELECT(64,40), "S494C5.s494c5f4");
    check_field_offset(lv, s494c5f5, ABISELECT(72,44), "S494C5.s494c5f5");
    check_field_offset(lv, s494c5f6, ABISELECT(80,52), "S494C5.s494c5f6");
    test_class_info(&lv, &cd_S494C5);
    dp->~S494C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C5(Test_S494C5, "S494C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S494C5C1Ev();
extern void _ZN6S494C5D1Ev();
Name_Map name_map_S494C5[] = {
  NSPAIR(_ZN6S494C5C1Ev),
  NSPAIR(_ZN6S494C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S494C5[];
extern void _ZN6S494C5D1Ev();
extern void _ZN6S494C5D0Ev();
extern void _ZN6S494C53v17Ev();
extern void _ZN6S494C53v18Ev();
extern void _ZN6S494C53v19Ev();
extern void _ZN6S494C53v20Ev();
extern void _ZN6S494C53v21Ev();
extern void _ZN6S494C53v22Ev();
extern void _ZN6S494C53v23Ev();
extern void _ZN6S494C53v24Ev();
extern void _ZN6S494C53v25Ev();
extern void _ZN6S494C53v26Ev();
extern void _ZN6S494C53v27Ev();
extern void _ZN6S494C53v28Ev();
extern void _ZN6S494C53v29Ev();
extern void _ZN6S494C53v30Ev();
extern void _ZN6S494C53v31Ev();
extern void _ZN6S494C53v32Ev();
extern void _ZN6S494C53v33Ev();
extern void _ZN6S494C53v34Ev();
extern void _ZN6S494C53v35Ev();
extern void _ZN6S494C53v36Ev();
extern void _ZN6S494C53v37Ev();
extern void _ZN6S494C53v38Ev();
extern void _ZN6S494C53v39Ev();
extern void _ZN6S494C53v40Ev();
extern void _ZN6S494C53v41Ev();
extern void _ZN6S494C53v42Ev();
extern void _ZN6S494C53v43Ev();
extern void _ZN6S494C53v44Ev();
extern void _ZN6S494C53v45Ev();
extern void _ZN6S494C53v46Ev();
extern void _ZN6S494C53v47Ev();
extern void _ZN6S494C53v48Ev();
extern void _ZN6S494C53v49Ev();
extern void _ZN6S494C53v50Ev();
extern void _ZN6S494C53v51Ev();
extern void _ZN6S494C53v52Ev();
extern void _ZN6S494C53v53Ev();
extern void _ZN6S494C53v54Ev();
extern void _ZN6S494C53v55Ev();
extern void _ZN6S494C53v56Ev();
extern void _ZN6S494C53v57Ev();
extern void _ZN6S494C53v58Ev();
extern void _ZN6S494C53v59Ev();
extern void _ZN6S494C53v60Ev();
extern void _ZN6S494C53v61Ev();
extern void _ZN6S494C53v62Ev();
extern void _ZN6S494C53v63Ev();
extern void _ZN6S494C53v64Ev();
extern void _ZN6S494C53v65Ev();
extern void _ZN6S494C53v66Ev();
extern void _ZN6S494C53v67Ev();
extern void _ZN6S494C53v68Ev();
extern void _ZN6S494C53v69Ev();
extern void _ZN6S494C53v70Ev();
extern void _ZN6S494C53v71Ev();
extern void _ZN6S494C53v72Ev();
extern void _ZN6S494C53v73Ev();
extern void _ZN6S494C53v74Ev();
extern void _ZN6S494C53v75Ev();
extern void _ZN6S494C53v76Ev();
extern void _ZN6S494C53v77Ev();
extern void _ZN6S494C53v78Ev();
extern void _ZN6S494C53v79Ev();
extern void _ZN6S494C53v80Ev();
static  VTBL_ENTRY vtc_S494C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S494C5[0]),
  (VTBL_ENTRY)&_ZN6S494C5D1Ev,
  (VTBL_ENTRY)&_ZN6S494C5D0Ev,
  (VTBL_ENTRY)&_ZN6S494C53v17Ev,
  (VTBL_ENTRY)&_ZN6S494C53v18Ev,
  (VTBL_ENTRY)&_ZN6S494C53v19Ev,
  (VTBL_ENTRY)&_ZN6S494C53v20Ev,
  (VTBL_ENTRY)&_ZN6S494C53v21Ev,
  (VTBL_ENTRY)&_ZN6S494C53v22Ev,
  (VTBL_ENTRY)&_ZN6S494C53v23Ev,
  (VTBL_ENTRY)&_ZN6S494C53v24Ev,
  (VTBL_ENTRY)&_ZN6S494C53v25Ev,
  (VTBL_ENTRY)&_ZN6S494C53v26Ev,
  (VTBL_ENTRY)&_ZN6S494C53v27Ev,
  (VTBL_ENTRY)&_ZN6S494C53v28Ev,
  (VTBL_ENTRY)&_ZN6S494C53v29Ev,
  (VTBL_ENTRY)&_ZN6S494C53v30Ev,
  (VTBL_ENTRY)&_ZN6S494C53v31Ev,
  (VTBL_ENTRY)&_ZN6S494C53v32Ev,
  (VTBL_ENTRY)&_ZN6S494C53v33Ev,
  (VTBL_ENTRY)&_ZN6S494C53v34Ev,
  (VTBL_ENTRY)&_ZN6S494C53v35Ev,
  (VTBL_ENTRY)&_ZN6S494C53v36Ev,
  (VTBL_ENTRY)&_ZN6S494C53v37Ev,
  (VTBL_ENTRY)&_ZN6S494C53v38Ev,
  (VTBL_ENTRY)&_ZN6S494C53v39Ev,
  (VTBL_ENTRY)&_ZN6S494C53v40Ev,
  (VTBL_ENTRY)&_ZN6S494C53v41Ev,
  (VTBL_ENTRY)&_ZN6S494C53v42Ev,
  (VTBL_ENTRY)&_ZN6S494C53v43Ev,
  (VTBL_ENTRY)&_ZN6S494C53v44Ev,
  (VTBL_ENTRY)&_ZN6S494C53v45Ev,
  (VTBL_ENTRY)&_ZN6S494C53v46Ev,
  (VTBL_ENTRY)&_ZN6S494C53v47Ev,
  (VTBL_ENTRY)&_ZN6S494C53v48Ev,
  (VTBL_ENTRY)&_ZN6S494C53v49Ev,
  (VTBL_ENTRY)&_ZN6S494C53v50Ev,
  (VTBL_ENTRY)&_ZN6S494C53v51Ev,
  (VTBL_ENTRY)&_ZN6S494C53v52Ev,
  (VTBL_ENTRY)&_ZN6S494C53v53Ev,
  (VTBL_ENTRY)&_ZN6S494C53v54Ev,
  (VTBL_ENTRY)&_ZN6S494C53v55Ev,
  (VTBL_ENTRY)&_ZN6S494C53v56Ev,
  (VTBL_ENTRY)&_ZN6S494C53v57Ev,
  (VTBL_ENTRY)&_ZN6S494C53v58Ev,
  (VTBL_ENTRY)&_ZN6S494C53v59Ev,
  (VTBL_ENTRY)&_ZN6S494C53v60Ev,
  (VTBL_ENTRY)&_ZN6S494C53v61Ev,
  (VTBL_ENTRY)&_ZN6S494C53v62Ev,
  (VTBL_ENTRY)&_ZN6S494C53v63Ev,
  (VTBL_ENTRY)&_ZN6S494C53v64Ev,
  (VTBL_ENTRY)&_ZN6S494C53v65Ev,
  (VTBL_ENTRY)&_ZN6S494C53v66Ev,
  (VTBL_ENTRY)&_ZN6S494C53v67Ev,
  (VTBL_ENTRY)&_ZN6S494C53v68Ev,
  (VTBL_ENTRY)&_ZN6S494C53v69Ev,
  (VTBL_ENTRY)&_ZN6S494C53v70Ev,
  (VTBL_ENTRY)&_ZN6S494C53v71Ev,
  (VTBL_ENTRY)&_ZN6S494C53v72Ev,
  (VTBL_ENTRY)&_ZN6S494C53v73Ev,
  (VTBL_ENTRY)&_ZN6S494C53v74Ev,
  (VTBL_ENTRY)&_ZN6S494C53v75Ev,
  (VTBL_ENTRY)&_ZN6S494C53v76Ev,
  (VTBL_ENTRY)&_ZN6S494C53v77Ev,
  (VTBL_ENTRY)&_ZN6S494C53v78Ev,
  (VTBL_ENTRY)&_ZN6S494C53v79Ev,
  (VTBL_ENTRY)&_ZN6S494C53v80Ev,
};
extern VTBL_ENTRY _ZTI6S494C5[];
extern  VTBL_ENTRY _ZTV6S494C5[];
Class_Descriptor cd_S494C5 = {  "S494C5", // class name
  0,0,//no base classes
  &(vtc_S494C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S494C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S494C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C4  : S494C5 {
  void *s494c4f0;
  ::S95C8_nt s494c4f1;
  virtual  ~S494C4(); // _ZN6S494C4D1Ev
  virtual void  v81(); // _ZN6S494C43v81Ev
  virtual void  v82(); // _ZN6S494C43v82Ev
  virtual void  v83(); // _ZN6S494C43v83Ev
  virtual void  v84(); // _ZN6S494C43v84Ev
  virtual void  v85(); // _ZN6S494C43v85Ev
  S494C4(); // tgen
};
//SIG(-1 S494C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S494C4 ::~S494C4(){ note_dtor("S494C4", this);}
void  S494C4 ::v81(){vfunc_called(this, "_ZN6S494C43v81Ev");}
void  S494C4 ::v82(){vfunc_called(this, "_ZN6S494C43v82Ev");}
void  S494C4 ::v83(){vfunc_called(this, "_ZN6S494C43v83Ev");}
void  S494C4 ::v84(){vfunc_called(this, "_ZN6S494C43v84Ev");}
void  S494C4 ::v85(){vfunc_called(this, "_ZN6S494C43v85Ev");}
S494C4 ::S494C4(){ note_ctor("S494C4", this);} // tgen

static void Test_S494C4()
{
  extern Class_Descriptor cd_S494C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S494C4, buf);
    S494C4 *dp, &lv = *(dp=new (buf) S494C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S494C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C4)");
    check_base_class_offset(lv, (S494C5*), 0, "S494C4");
    check_field_offset(lv, s494c4f0, ABISELECT(96,60), "S494C4.s494c4f0");
    check_field_offset(lv, s494c4f1, ABISELECT(104,64), "S494C4.s494c4f1");
    test_class_info(&lv, &cd_S494C4);
    dp->~S494C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C4(Test_S494C4, "S494C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S494C4C1Ev();
extern void _ZN6S494C4D1Ev();
Name_Map name_map_S494C4[] = {
  NSPAIR(_ZN6S494C4C1Ev),
  NSPAIR(_ZN6S494C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S494C5;
extern VTBL_ENTRY _ZTI6S494C5[];
extern  VTBL_ENTRY _ZTV6S494C5[];
static Base_Class bases_S494C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S494C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S494C4[];
extern void _ZN6S494C4D1Ev();
extern void _ZN6S494C4D0Ev();
extern void _ZN6S494C53v17Ev();
extern void _ZN6S494C53v18Ev();
extern void _ZN6S494C53v19Ev();
extern void _ZN6S494C53v20Ev();
extern void _ZN6S494C53v21Ev();
extern void _ZN6S494C53v22Ev();
extern void _ZN6S494C53v23Ev();
extern void _ZN6S494C53v24Ev();
extern void _ZN6S494C53v25Ev();
extern void _ZN6S494C53v26Ev();
extern void _ZN6S494C53v27Ev();
extern void _ZN6S494C53v28Ev();
extern void _ZN6S494C53v29Ev();
extern void _ZN6S494C53v30Ev();
extern void _ZN6S494C53v31Ev();
extern void _ZN6S494C53v32Ev();
extern void _ZN6S494C53v33Ev();
extern void _ZN6S494C53v34Ev();
extern void _ZN6S494C53v35Ev();
extern void _ZN6S494C53v36Ev();
extern void _ZN6S494C53v37Ev();
extern void _ZN6S494C53v38Ev();
extern void _ZN6S494C53v39Ev();
extern void _ZN6S494C53v40Ev();
extern void _ZN6S494C53v41Ev();
extern void _ZN6S494C53v42Ev();
extern void _ZN6S494C53v43Ev();
extern void _ZN6S494C53v44Ev();
extern void _ZN6S494C53v45Ev();
extern void _ZN6S494C53v46Ev();
extern void _ZN6S494C53v47Ev();
extern void _ZN6S494C53v48Ev();
extern void _ZN6S494C53v49Ev();
extern void _ZN6S494C53v50Ev();
extern void _ZN6S494C53v51Ev();
extern void _ZN6S494C53v52Ev();
extern void _ZN6S494C53v53Ev();
extern void _ZN6S494C53v54Ev();
extern void _ZN6S494C53v55Ev();
extern void _ZN6S494C53v56Ev();
extern void _ZN6S494C53v57Ev();
extern void _ZN6S494C53v58Ev();
extern void _ZN6S494C53v59Ev();
extern void _ZN6S494C53v60Ev();
extern void _ZN6S494C53v61Ev();
extern void _ZN6S494C53v62Ev();
extern void _ZN6S494C53v63Ev();
extern void _ZN6S494C53v64Ev();
extern void _ZN6S494C53v65Ev();
extern void _ZN6S494C53v66Ev();
extern void _ZN6S494C53v67Ev();
extern void _ZN6S494C53v68Ev();
extern void _ZN6S494C53v69Ev();
extern void _ZN6S494C53v70Ev();
extern void _ZN6S494C53v71Ev();
extern void _ZN6S494C53v72Ev();
extern void _ZN6S494C53v73Ev();
extern void _ZN6S494C53v74Ev();
extern void _ZN6S494C53v75Ev();
extern void _ZN6S494C53v76Ev();
extern void _ZN6S494C53v77Ev();
extern void _ZN6S494C53v78Ev();
extern void _ZN6S494C53v79Ev();
extern void _ZN6S494C53v80Ev();
extern void _ZN6S494C43v81Ev();
extern void _ZN6S494C43v82Ev();
extern void _ZN6S494C43v83Ev();
extern void _ZN6S494C43v84Ev();
extern void _ZN6S494C43v85Ev();
static  VTBL_ENTRY vtc_S494C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S494C4[0]),
  (VTBL_ENTRY)&_ZN6S494C4D1Ev,
  (VTBL_ENTRY)&_ZN6S494C4D0Ev,
  (VTBL_ENTRY)&_ZN6S494C53v17Ev,
  (VTBL_ENTRY)&_ZN6S494C53v18Ev,
  (VTBL_ENTRY)&_ZN6S494C53v19Ev,
  (VTBL_ENTRY)&_ZN6S494C53v20Ev,
  (VTBL_ENTRY)&_ZN6S494C53v21Ev,
  (VTBL_ENTRY)&_ZN6S494C53v22Ev,
  (VTBL_ENTRY)&_ZN6S494C53v23Ev,
  (VTBL_ENTRY)&_ZN6S494C53v24Ev,
  (VTBL_ENTRY)&_ZN6S494C53v25Ev,
  (VTBL_ENTRY)&_ZN6S494C53v26Ev,
  (VTBL_ENTRY)&_ZN6S494C53v27Ev,
  (VTBL_ENTRY)&_ZN6S494C53v28Ev,
  (VTBL_ENTRY)&_ZN6S494C53v29Ev,
  (VTBL_ENTRY)&_ZN6S494C53v30Ev,
  (VTBL_ENTRY)&_ZN6S494C53v31Ev,
  (VTBL_ENTRY)&_ZN6S494C53v32Ev,
  (VTBL_ENTRY)&_ZN6S494C53v33Ev,
  (VTBL_ENTRY)&_ZN6S494C53v34Ev,
  (VTBL_ENTRY)&_ZN6S494C53v35Ev,
  (VTBL_ENTRY)&_ZN6S494C53v36Ev,
  (VTBL_ENTRY)&_ZN6S494C53v37Ev,
  (VTBL_ENTRY)&_ZN6S494C53v38Ev,
  (VTBL_ENTRY)&_ZN6S494C53v39Ev,
  (VTBL_ENTRY)&_ZN6S494C53v40Ev,
  (VTBL_ENTRY)&_ZN6S494C53v41Ev,
  (VTBL_ENTRY)&_ZN6S494C53v42Ev,
  (VTBL_ENTRY)&_ZN6S494C53v43Ev,
  (VTBL_ENTRY)&_ZN6S494C53v44Ev,
  (VTBL_ENTRY)&_ZN6S494C53v45Ev,
  (VTBL_ENTRY)&_ZN6S494C53v46Ev,
  (VTBL_ENTRY)&_ZN6S494C53v47Ev,
  (VTBL_ENTRY)&_ZN6S494C53v48Ev,
  (VTBL_ENTRY)&_ZN6S494C53v49Ev,
  (VTBL_ENTRY)&_ZN6S494C53v50Ev,
  (VTBL_ENTRY)&_ZN6S494C53v51Ev,
  (VTBL_ENTRY)&_ZN6S494C53v52Ev,
  (VTBL_ENTRY)&_ZN6S494C53v53Ev,
  (VTBL_ENTRY)&_ZN6S494C53v54Ev,
  (VTBL_ENTRY)&_ZN6S494C53v55Ev,
  (VTBL_ENTRY)&_ZN6S494C53v56Ev,
  (VTBL_ENTRY)&_ZN6S494C53v57Ev,
  (VTBL_ENTRY)&_ZN6S494C53v58Ev,
  (VTBL_ENTRY)&_ZN6S494C53v59Ev,
  (VTBL_ENTRY)&_ZN6S494C53v60Ev,
  (VTBL_ENTRY)&_ZN6S494C53v61Ev,
  (VTBL_ENTRY)&_ZN6S494C53v62Ev,
  (VTBL_ENTRY)&_ZN6S494C53v63Ev,
  (VTBL_ENTRY)&_ZN6S494C53v64Ev,
  (VTBL_ENTRY)&_ZN6S494C53v65Ev,
  (VTBL_ENTRY)&_ZN6S494C53v66Ev,
  (VTBL_ENTRY)&_ZN6S494C53v67Ev,
  (VTBL_ENTRY)&_ZN6S494C53v68Ev,
  (VTBL_ENTRY)&_ZN6S494C53v69Ev,
  (VTBL_ENTRY)&_ZN6S494C53v70Ev,
  (VTBL_ENTRY)&_ZN6S494C53v71Ev,
  (VTBL_ENTRY)&_ZN6S494C53v72Ev,
  (VTBL_ENTRY)&_ZN6S494C53v73Ev,
  (VTBL_ENTRY)&_ZN6S494C53v74Ev,
  (VTBL_ENTRY)&_ZN6S494C53v75Ev,
  (VTBL_ENTRY)&_ZN6S494C53v76Ev,
  (VTBL_ENTRY)&_ZN6S494C53v77Ev,
  (VTBL_ENTRY)&_ZN6S494C53v78Ev,
  (VTBL_ENTRY)&_ZN6S494C53v79Ev,
  (VTBL_ENTRY)&_ZN6S494C53v80Ev,
  (VTBL_ENTRY)&_ZN6S494C43v81Ev,
  (VTBL_ENTRY)&_ZN6S494C43v82Ev,
  (VTBL_ENTRY)&_ZN6S494C43v83Ev,
  (VTBL_ENTRY)&_ZN6S494C43v84Ev,
  (VTBL_ENTRY)&_ZN6S494C43v85Ev,
};
extern VTBL_ENTRY _ZTI6S494C4[];
extern  VTBL_ENTRY _ZTV6S494C4[];
Class_Descriptor cd_S494C4 = {  "S494C4", // class name
  bases_S494C4, 1,
  &(vtc_S494C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S494C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S494C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C3  : S494C4 {
  void *s494c3f0[2];
  unsigned int s494c3f1:1;
  unsigned int s494c3f2:1;
  unsigned int s494c3f3:1;
  unsigned int s494c3f4:1;
  char s494c3f5;
  virtual  ~S494C3(); // _ZN6S494C3D1Ev
  virtual void  v86(); // _ZN6S494C33v86Ev
  virtual void  v87(); // _ZN6S494C33v87Ev
  virtual void  v88(); // _ZN6S494C33v88Ev
  virtual void  v89(); // _ZN6S494C33v89Ev
  virtual void  v90(); // _ZN6S494C33v90Ev
  virtual void  v91(); // _ZN6S494C33v91Ev
  virtual void  v92(); // _ZN6S494C33v92Ev
  virtual void  v93(); // _ZN6S494C33v93Ev
  virtual void  v94(); // _ZN6S494C33v94Ev
  virtual void  v95(); // _ZN6S494C33v95Ev
  virtual void  v96(); // _ZN6S494C33v96Ev
  virtual void  v97(); // _ZN6S494C33v97Ev
  virtual void  v98(); // _ZN6S494C33v98Ev
  virtual void  v99(); // _ZN6S494C33v99Ev
  virtual void  v100(); // _ZN6S494C34v100Ev
  virtual void  v101(); // _ZN6S494C34v101Ev
  virtual void  v102(); // _ZN6S494C34v102Ev
  virtual void  v103(); // _ZN6S494C34v103Ev
  virtual void  v104(); // _ZN6S494C34v104Ev
  virtual void  v105(); // _ZN6S494C34v105Ev
  virtual void  v106(); // _ZN6S494C34v106Ev
  virtual void  v107(); // _ZN6S494C34v107Ev
  S494C3(); // tgen
};
//SIG(-1 S494C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S494C3 ::~S494C3(){ note_dtor("S494C3", this);}
void  S494C3 ::v86(){vfunc_called(this, "_ZN6S494C33v86Ev");}
void  S494C3 ::v87(){vfunc_called(this, "_ZN6S494C33v87Ev");}
void  S494C3 ::v88(){vfunc_called(this, "_ZN6S494C33v88Ev");}
void  S494C3 ::v89(){vfunc_called(this, "_ZN6S494C33v89Ev");}
void  S494C3 ::v90(){vfunc_called(this, "_ZN6S494C33v90Ev");}
void  S494C3 ::v91(){vfunc_called(this, "_ZN6S494C33v91Ev");}
void  S494C3 ::v92(){vfunc_called(this, "_ZN6S494C33v92Ev");}
void  S494C3 ::v93(){vfunc_called(this, "_ZN6S494C33v93Ev");}
void  S494C3 ::v94(){vfunc_called(this, "_ZN6S494C33v94Ev");}
void  S494C3 ::v95(){vfunc_called(this, "_ZN6S494C33v95Ev");}
void  S494C3 ::v96(){vfunc_called(this, "_ZN6S494C33v96Ev");}
void  S494C3 ::v97(){vfunc_called(this, "_ZN6S494C33v97Ev");}
void  S494C3 ::v98(){vfunc_called(this, "_ZN6S494C33v98Ev");}
void  S494C3 ::v99(){vfunc_called(this, "_ZN6S494C33v99Ev");}
void  S494C3 ::v100(){vfunc_called(this, "_ZN6S494C34v100Ev");}
void  S494C3 ::v101(){vfunc_called(this, "_ZN6S494C34v101Ev");}
void  S494C3 ::v102(){vfunc_called(this, "_ZN6S494C34v102Ev");}
void  S494C3 ::v103(){vfunc_called(this, "_ZN6S494C34v103Ev");}
void  S494C3 ::v104(){vfunc_called(this, "_ZN6S494C34v104Ev");}
void  S494C3 ::v105(){vfunc_called(this, "_ZN6S494C34v105Ev");}
void  S494C3 ::v106(){vfunc_called(this, "_ZN6S494C34v106Ev");}
void  S494C3 ::v107(){vfunc_called(this, "_ZN6S494C34v107Ev");}
S494C3 ::S494C3(){ note_ctor("S494C3", this);} // tgen

static void Test_S494C3()
{
  extern Class_Descriptor cd_S494C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S494C3, buf);
    S494C3 *dp, &lv = *(dp=new (buf) S494C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S494C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C3)");
    check_base_class_offset(lv, (S494C5*)(S494C4*), 0, "S494C3");
    check_base_class_offset(lv, (S494C4*), 0, "S494C3");
    check_field_offset(lv, s494c3f0, ABISELECT(112,72), "S494C3.s494c3f0");
    set_bf_and_test(lv, s494c3f1, ABISELECT(128,80), 0, 1, 1, "S494C3");
    set_bf_and_test(lv, s494c3f2, ABISELECT(128,80), 1, 1, 1, "S494C3");
    set_bf_and_test(lv, s494c3f3, ABISELECT(128,80), 2, 1, 1, "S494C3");
    set_bf_and_test(lv, s494c3f4, ABISELECT(128,80), 3, 1, 1, "S494C3");
    check_field_offset(lv, s494c3f5, ABISELECT(129,81), "S494C3.s494c3f5");
    test_class_info(&lv, &cd_S494C3);
    dp->~S494C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C3(Test_S494C3, "S494C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S494C3C1Ev();
extern void _ZN6S494C3D1Ev();
Name_Map name_map_S494C3[] = {
  NSPAIR(_ZN6S494C3C1Ev),
  NSPAIR(_ZN6S494C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S494C5;
extern VTBL_ENTRY _ZTI6S494C5[];
extern  VTBL_ENTRY _ZTV6S494C5[];
extern Class_Descriptor cd_S494C4;
extern VTBL_ENTRY _ZTI6S494C4[];
extern  VTBL_ENTRY _ZTV6S494C4[];
static Base_Class bases_S494C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S494C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S494C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S494C3[];
extern void _ZN6S494C3D1Ev();
extern void _ZN6S494C3D0Ev();
extern void _ZN6S494C53v17Ev();
extern void _ZN6S494C53v18Ev();
extern void _ZN6S494C53v19Ev();
extern void _ZN6S494C53v20Ev();
extern void _ZN6S494C53v21Ev();
extern void _ZN6S494C53v22Ev();
extern void _ZN6S494C53v23Ev();
extern void _ZN6S494C53v24Ev();
extern void _ZN6S494C53v25Ev();
extern void _ZN6S494C53v26Ev();
extern void _ZN6S494C53v27Ev();
extern void _ZN6S494C53v28Ev();
extern void _ZN6S494C53v29Ev();
extern void _ZN6S494C53v30Ev();
extern void _ZN6S494C53v31Ev();
extern void _ZN6S494C53v32Ev();
extern void _ZN6S494C53v33Ev();
extern void _ZN6S494C53v34Ev();
extern void _ZN6S494C53v35Ev();
extern void _ZN6S494C53v36Ev();
extern void _ZN6S494C53v37Ev();
extern void _ZN6S494C53v38Ev();
extern void _ZN6S494C53v39Ev();
extern void _ZN6S494C53v40Ev();
extern void _ZN6S494C53v41Ev();
extern void _ZN6S494C53v42Ev();
extern void _ZN6S494C53v43Ev();
extern void _ZN6S494C53v44Ev();
extern void _ZN6S494C53v45Ev();
extern void _ZN6S494C53v46Ev();
extern void _ZN6S494C53v47Ev();
extern void _ZN6S494C53v48Ev();
extern void _ZN6S494C53v49Ev();
extern void _ZN6S494C53v50Ev();
extern void _ZN6S494C53v51Ev();
extern void _ZN6S494C53v52Ev();
extern void _ZN6S494C53v53Ev();
extern void _ZN6S494C53v54Ev();
extern void _ZN6S494C53v55Ev();
extern void _ZN6S494C53v56Ev();
extern void _ZN6S494C53v57Ev();
extern void _ZN6S494C53v58Ev();
extern void _ZN6S494C53v59Ev();
extern void _ZN6S494C53v60Ev();
extern void _ZN6S494C53v61Ev();
extern void _ZN6S494C53v62Ev();
extern void _ZN6S494C53v63Ev();
extern void _ZN6S494C53v64Ev();
extern void _ZN6S494C53v65Ev();
extern void _ZN6S494C53v66Ev();
extern void _ZN6S494C53v67Ev();
extern void _ZN6S494C53v68Ev();
extern void _ZN6S494C53v69Ev();
extern void _ZN6S494C53v70Ev();
extern void _ZN6S494C53v71Ev();
extern void _ZN6S494C53v72Ev();
extern void _ZN6S494C53v73Ev();
extern void _ZN6S494C53v74Ev();
extern void _ZN6S494C53v75Ev();
extern void _ZN6S494C53v76Ev();
extern void _ZN6S494C53v77Ev();
extern void _ZN6S494C53v78Ev();
extern void _ZN6S494C53v79Ev();
extern void _ZN6S494C53v80Ev();
extern void _ZN6S494C43v81Ev();
extern void _ZN6S494C43v82Ev();
extern void _ZN6S494C43v83Ev();
extern void _ZN6S494C43v84Ev();
extern void _ZN6S494C43v85Ev();
extern void _ZN6S494C33v86Ev();
extern void _ZN6S494C33v87Ev();
extern void _ZN6S494C33v88Ev();
extern void _ZN6S494C33v89Ev();
extern void _ZN6S494C33v90Ev();
extern void _ZN6S494C33v91Ev();
extern void _ZN6S494C33v92Ev();
extern void _ZN6S494C33v93Ev();
extern void _ZN6S494C33v94Ev();
extern void _ZN6S494C33v95Ev();
extern void _ZN6S494C33v96Ev();
extern void _ZN6S494C33v97Ev();
extern void _ZN6S494C33v98Ev();
extern void _ZN6S494C33v99Ev();
extern void _ZN6S494C34v100Ev();
extern void _ZN6S494C34v101Ev();
extern void _ZN6S494C34v102Ev();
extern void _ZN6S494C34v103Ev();
extern void _ZN6S494C34v104Ev();
extern void _ZN6S494C34v105Ev();
extern void _ZN6S494C34v106Ev();
extern void _ZN6S494C34v107Ev();
static  VTBL_ENTRY vtc_S494C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S494C3[0]),
  (VTBL_ENTRY)&_ZN6S494C3D1Ev,
  (VTBL_ENTRY)&_ZN6S494C3D0Ev,
  (VTBL_ENTRY)&_ZN6S494C53v17Ev,
  (VTBL_ENTRY)&_ZN6S494C53v18Ev,
  (VTBL_ENTRY)&_ZN6S494C53v19Ev,
  (VTBL_ENTRY)&_ZN6S494C53v20Ev,
  (VTBL_ENTRY)&_ZN6S494C53v21Ev,
  (VTBL_ENTRY)&_ZN6S494C53v22Ev,
  (VTBL_ENTRY)&_ZN6S494C53v23Ev,
  (VTBL_ENTRY)&_ZN6S494C53v24Ev,
  (VTBL_ENTRY)&_ZN6S494C53v25Ev,
  (VTBL_ENTRY)&_ZN6S494C53v26Ev,
  (VTBL_ENTRY)&_ZN6S494C53v27Ev,
  (VTBL_ENTRY)&_ZN6S494C53v28Ev,
  (VTBL_ENTRY)&_ZN6S494C53v29Ev,
  (VTBL_ENTRY)&_ZN6S494C53v30Ev,
  (VTBL_ENTRY)&_ZN6S494C53v31Ev,
  (VTBL_ENTRY)&_ZN6S494C53v32Ev,
  (VTBL_ENTRY)&_ZN6S494C53v33Ev,
  (VTBL_ENTRY)&_ZN6S494C53v34Ev,
  (VTBL_ENTRY)&_ZN6S494C53v35Ev,
  (VTBL_ENTRY)&_ZN6S494C53v36Ev,
  (VTBL_ENTRY)&_ZN6S494C53v37Ev,
  (VTBL_ENTRY)&_ZN6S494C53v38Ev,
  (VTBL_ENTRY)&_ZN6S494C53v39Ev,
  (VTBL_ENTRY)&_ZN6S494C53v40Ev,
  (VTBL_ENTRY)&_ZN6S494C53v41Ev,
  (VTBL_ENTRY)&_ZN6S494C53v42Ev,
  (VTBL_ENTRY)&_ZN6S494C53v43Ev,
  (VTBL_ENTRY)&_ZN6S494C53v44Ev,
  (VTBL_ENTRY)&_ZN6S494C53v45Ev,
  (VTBL_ENTRY)&_ZN6S494C53v46Ev,
  (VTBL_ENTRY)&_ZN6S494C53v47Ev,
  (VTBL_ENTRY)&_ZN6S494C53v48Ev,
  (VTBL_ENTRY)&_ZN6S494C53v49Ev,
  (VTBL_ENTRY)&_ZN6S494C53v50Ev,
  (VTBL_ENTRY)&_ZN6S494C53v51Ev,
  (VTBL_ENTRY)&_ZN6S494C53v52Ev,
  (VTBL_ENTRY)&_ZN6S494C53v53Ev,
  (VTBL_ENTRY)&_ZN6S494C53v54Ev,
  (VTBL_ENTRY)&_ZN6S494C53v55Ev,
  (VTBL_ENTRY)&_ZN6S494C53v56Ev,
  (VTBL_ENTRY)&_ZN6S494C53v57Ev,
  (VTBL_ENTRY)&_ZN6S494C53v58Ev,
  (VTBL_ENTRY)&_ZN6S494C53v59Ev,
  (VTBL_ENTRY)&_ZN6S494C53v60Ev,
  (VTBL_ENTRY)&_ZN6S494C53v61Ev,
  (VTBL_ENTRY)&_ZN6S494C53v62Ev,
  (VTBL_ENTRY)&_ZN6S494C53v63Ev,
  (VTBL_ENTRY)&_ZN6S494C53v64Ev,
  (VTBL_ENTRY)&_ZN6S494C53v65Ev,
  (VTBL_ENTRY)&_ZN6S494C53v66Ev,
  (VTBL_ENTRY)&_ZN6S494C53v67Ev,
  (VTBL_ENTRY)&_ZN6S494C53v68Ev,
  (VTBL_ENTRY)&_ZN6S494C53v69Ev,
  (VTBL_ENTRY)&_ZN6S494C53v70Ev,
  (VTBL_ENTRY)&_ZN6S494C53v71Ev,
  (VTBL_ENTRY)&_ZN6S494C53v72Ev,
  (VTBL_ENTRY)&_ZN6S494C53v73Ev,
  (VTBL_ENTRY)&_ZN6S494C53v74Ev,
  (VTBL_ENTRY)&_ZN6S494C53v75Ev,
  (VTBL_ENTRY)&_ZN6S494C53v76Ev,
  (VTBL_ENTRY)&_ZN6S494C53v77Ev,
  (VTBL_ENTRY)&_ZN6S494C53v78Ev,
  (VTBL_ENTRY)&_ZN6S494C53v79Ev,
  (VTBL_ENTRY)&_ZN6S494C53v80Ev,
  (VTBL_ENTRY)&_ZN6S494C43v81Ev,
  (VTBL_ENTRY)&_ZN6S494C43v82Ev,
  (VTBL_ENTRY)&_ZN6S494C43v83Ev,
  (VTBL_ENTRY)&_ZN6S494C43v84Ev,
  (VTBL_ENTRY)&_ZN6S494C43v85Ev,
  (VTBL_ENTRY)&_ZN6S494C33v86Ev,
  (VTBL_ENTRY)&_ZN6S494C33v87Ev,
  (VTBL_ENTRY)&_ZN6S494C33v88Ev,
  (VTBL_ENTRY)&_ZN6S494C33v89Ev,
  (VTBL_ENTRY)&_ZN6S494C33v90Ev,
  (VTBL_ENTRY)&_ZN6S494C33v91Ev,
  (VTBL_ENTRY)&_ZN6S494C33v92Ev,
  (VTBL_ENTRY)&_ZN6S494C33v93Ev,
  (VTBL_ENTRY)&_ZN6S494C33v94Ev,
  (VTBL_ENTRY)&_ZN6S494C33v95Ev,
  (VTBL_ENTRY)&_ZN6S494C33v96Ev,
  (VTBL_ENTRY)&_ZN6S494C33v97Ev,
  (VTBL_ENTRY)&_ZN6S494C33v98Ev,
  (VTBL_ENTRY)&_ZN6S494C33v99Ev,
  (VTBL_ENTRY)&_ZN6S494C34v100Ev,
  (VTBL_ENTRY)&_ZN6S494C34v101Ev,
  (VTBL_ENTRY)&_ZN6S494C34v102Ev,
  (VTBL_ENTRY)&_ZN6S494C34v103Ev,
  (VTBL_ENTRY)&_ZN6S494C34v104Ev,
  (VTBL_ENTRY)&_ZN6S494C34v105Ev,
  (VTBL_ENTRY)&_ZN6S494C34v106Ev,
  (VTBL_ENTRY)&_ZN6S494C34v107Ev,
};
extern VTBL_ENTRY _ZTI6S494C3[];
extern  VTBL_ENTRY _ZTV6S494C3[];
Class_Descriptor cd_S494C3 = {  "S494C3", // class name
  bases_S494C3, 2,
  &(vtc_S494C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S494C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S494C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C2  : S494C3 {
  void *s494c2f0;
  ::S95C9_nt s494c2f1;
  int s494c2f2;
  ::S236C15_nt s494c2f3;
  int s494c2f4;
  ::S490C27 s494c2f5;
  int s494c2f6;
  void *s494c2f7[2];
  ::S95C13 s494c2f8;
  void *s494c2f9;
  int s494c2f10[2];
  char s494c2f11[3];
  int s494c2f12;
  unsigned int s494c2f13:1;
  unsigned int s494c2f14:1;
  unsigned int s494c2f15:1;
  unsigned int s494c2f16:1;
  unsigned int s494c2f17:1;
  unsigned int s494c2f18:1;
  unsigned int s494c2f19:1;
  unsigned int s494c2f20:1;
  unsigned int s494c2f21:1;
  unsigned int s494c2f22:1;
  unsigned int s494c2f23:1;
  unsigned int s494c2f24:1;
  unsigned int s494c2f25:1;
  unsigned int s494c2f26:1;
  int s494c2f27;
  unsigned int s494c2f28:1;
  unsigned int s494c2f29:1;
  unsigned int s494c2f30:1;
  unsigned int s494c2f31:1;
  unsigned int s494c2f32:1;
  unsigned int s494c2f33:1;
  ::S112C22_nt s494c2f34;
  unsigned int s494c2f35:1;
  unsigned int s494c2f36:1;
  unsigned int s494c2f37:1;
  unsigned int s494c2f38:1;
  unsigned int s494c2f39:1;
  unsigned int s494c2f40:1;
  unsigned int s494c2f41:1;
  char s494c2f42;
  ::S95C16 s494c2f43;
  unsigned int s494c2f44:1;
  unsigned int s494c2f45:1;
  unsigned int s494c2f46:1;
  unsigned int s494c2f47:1;
  unsigned int s494c2f48:1;
  unsigned int s494c2f49:1;
  unsigned int s494c2f50:1;
  unsigned int s494c2f51:1;
  unsigned int s494c2f52:1;
  unsigned int s494c2f53:1;
  unsigned int s494c2f54:1;
  unsigned int s494c2f55:1;
  ::S490C26 s494c2f56;
  void *s494c2f57[2];
  char s494c2f58;
  ::S236C15_nt s494c2f59;
  ::S236C18_nt s494c2f60;
  ::S95C14_nt s494c2f61;
  int s494c2f62;
  ::S236C18_nt s494c2f63;
  unsigned int s494c2f64:1;
  unsigned int s494c2f65:1;
  unsigned int s494c2f66:1;
  int s494c2f67[3];
  virtual  ~S494C2(); // _ZN6S494C2D1Ev
  virtual void  v108(); // _ZN6S494C24v108Ev
  virtual void  v109(); // _ZN6S494C24v109Ev
  virtual void  v110(); // _ZN6S494C24v110Ev
  virtual void  v111(); // _ZN6S494C24v111Ev
  virtual void  v112(); // _ZN6S494C24v112Ev
  virtual void  v113(); // _ZN6S494C24v113Ev
  virtual void  v114(); // _ZN6S494C24v114Ev
  virtual void  v115(); // _ZN6S494C24v115Ev
  virtual void  v116(); // _ZN6S494C24v116Ev
  virtual void  v117(); // _ZN6S494C24v117Ev
  virtual void  v118(); // _ZN6S494C24v118Ev
  virtual void  v119(); // _ZN6S494C24v119Ev
  virtual void  v120(); // _ZN6S494C24v120Ev
  virtual void  v121(); // _ZN6S494C24v121Ev
  virtual void  v122(); // _ZN6S494C24v122Ev
  virtual void  v123(); // _ZN6S494C24v123Ev
  virtual void  v124(); // _ZN6S494C24v124Ev
  virtual void  v125(); // _ZN6S494C24v125Ev
  virtual void  v126(); // _ZN6S494C24v126Ev
  virtual void  v127(); // _ZN6S494C24v127Ev
  virtual void  v128(); // _ZN6S494C24v128Ev
  virtual void  v129(); // _ZN6S494C24v129Ev
  virtual void  v130(); // _ZN6S494C24v130Ev
  virtual void  v131(); // _ZN6S494C24v131Ev
  virtual void  v132(); // _ZN6S494C24v132Ev
  virtual void  v133(); // _ZN6S494C24v133Ev
  virtual void  v134(); // _ZN6S494C24v134Ev
  virtual void  v135(); // _ZN6S494C24v135Ev
  virtual void  v136(); // _ZN6S494C24v136Ev
  virtual void  v137(); // _ZN6S494C24v137Ev
  virtual void  v138(); // _ZN6S494C24v138Ev
  virtual void  v139(); // _ZN6S494C24v139Ev
  virtual void  v140(); // _ZN6S494C24v140Ev
  virtual void  v141(); // _ZN6S494C24v141Ev
  virtual void  v142(); // _ZN6S494C24v142Ev
  virtual void  v143(); // _ZN6S494C24v143Ev
  virtual void  v144(); // _ZN6S494C24v144Ev
  virtual void  v145(); // _ZN6S494C24v145Ev
  virtual void  v146(); // _ZN6S494C24v146Ev
  virtual void  v147(); // _ZN6S494C24v147Ev
  virtual void  v148(); // _ZN6S494C24v148Ev
  virtual void  v149(); // _ZN6S494C24v149Ev
  virtual void  v150(); // _ZN6S494C24v150Ev
  virtual void  v151(); // _ZN6S494C24v151Ev
  virtual void  v152(); // _ZN6S494C24v152Ev
  virtual void  v153(); // _ZN6S494C24v153Ev
  virtual void  v154(); // _ZN6S494C24v154Ev
  virtual void  v155(); // _ZN6S494C24v155Ev
  virtual void  v156(); // _ZN6S494C24v156Ev
  virtual void  v157(); // _ZN6S494C24v157Ev
  virtual void  v158(); // _ZN6S494C24v158Ev
  virtual void  v159(); // _ZN6S494C24v159Ev
  virtual void  v160(); // _ZN6S494C24v160Ev
  virtual void  v161(); // _ZN6S494C24v161Ev
  virtual void  v162(); // _ZN6S494C24v162Ev
  virtual void  v163(); // _ZN6S494C24v163Ev
  virtual void  v164(); // _ZN6S494C24v164Ev
  virtual void  v165(); // _ZN6S494C24v165Ev
  virtual void  v166(); // _ZN6S494C24v166Ev
  virtual void  v167(); // _ZN6S494C24v167Ev
  virtual void  v168(); // _ZN6S494C24v168Ev
  S494C2(); // tgen
};
//SIG(-1 S494C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S494C2 ::~S494C2(){ note_dtor("S494C2", this);}
void  S494C2 ::v108(){vfunc_called(this, "_ZN6S494C24v108Ev");}
void  S494C2 ::v109(){vfunc_called(this, "_ZN6S494C24v109Ev");}
void  S494C2 ::v110(){vfunc_called(this, "_ZN6S494C24v110Ev");}
void  S494C2 ::v111(){vfunc_called(this, "_ZN6S494C24v111Ev");}
void  S494C2 ::v112(){vfunc_called(this, "_ZN6S494C24v112Ev");}
void  S494C2 ::v113(){vfunc_called(this, "_ZN6S494C24v113Ev");}
void  S494C2 ::v114(){vfunc_called(this, "_ZN6S494C24v114Ev");}
void  S494C2 ::v115(){vfunc_called(this, "_ZN6S494C24v115Ev");}
void  S494C2 ::v116(){vfunc_called(this, "_ZN6S494C24v116Ev");}
void  S494C2 ::v117(){vfunc_called(this, "_ZN6S494C24v117Ev");}
void  S494C2 ::v118(){vfunc_called(this, "_ZN6S494C24v118Ev");}
void  S494C2 ::v119(){vfunc_called(this, "_ZN6S494C24v119Ev");}
void  S494C2 ::v120(){vfunc_called(this, "_ZN6S494C24v120Ev");}
void  S494C2 ::v121(){vfunc_called(this, "_ZN6S494C24v121Ev");}
void  S494C2 ::v122(){vfunc_called(this, "_ZN6S494C24v122Ev");}
void  S494C2 ::v123(){vfunc_called(this, "_ZN6S494C24v123Ev");}
void  S494C2 ::v124(){vfunc_called(this, "_ZN6S494C24v124Ev");}
void  S494C2 ::v125(){vfunc_called(this, "_ZN6S494C24v125Ev");}
void  S494C2 ::v126(){vfunc_called(this, "_ZN6S494C24v126Ev");}
void  S494C2 ::v127(){vfunc_called(this, "_ZN6S494C24v127Ev");}
void  S494C2 ::v128(){vfunc_called(this, "_ZN6S494C24v128Ev");}
void  S494C2 ::v129(){vfunc_called(this, "_ZN6S494C24v129Ev");}
void  S494C2 ::v130(){vfunc_called(this, "_ZN6S494C24v130Ev");}
void  S494C2 ::v131(){vfunc_called(this, "_ZN6S494C24v131Ev");}
void  S494C2 ::v132(){vfunc_called(this, "_ZN6S494C24v132Ev");}
void  S494C2 ::v133(){vfunc_called(this, "_ZN6S494C24v133Ev");}
void  S494C2 ::v134(){vfunc_called(this, "_ZN6S494C24v134Ev");}
void  S494C2 ::v135(){vfunc_called(this, "_ZN6S494C24v135Ev");}
void  S494C2 ::v136(){vfunc_called(this, "_ZN6S494C24v136Ev");}
void  S494C2 ::v137(){vfunc_called(this, "_ZN6S494C24v137Ev");}
void  S494C2 ::v138(){vfunc_called(this, "_ZN6S494C24v138Ev");}
void  S494C2 ::v139(){vfunc_called(this, "_ZN6S494C24v139Ev");}
void  S494C2 ::v140(){vfunc_called(this, "_ZN6S494C24v140Ev");}
void  S494C2 ::v141(){vfunc_called(this, "_ZN6S494C24v141Ev");}
void  S494C2 ::v142(){vfunc_called(this, "_ZN6S494C24v142Ev");}
void  S494C2 ::v143(){vfunc_called(this, "_ZN6S494C24v143Ev");}
void  S494C2 ::v144(){vfunc_called(this, "_ZN6S494C24v144Ev");}
void  S494C2 ::v145(){vfunc_called(this, "_ZN6S494C24v145Ev");}
void  S494C2 ::v146(){vfunc_called(this, "_ZN6S494C24v146Ev");}
void  S494C2 ::v147(){vfunc_called(this, "_ZN6S494C24v147Ev");}
void  S494C2 ::v148(){vfunc_called(this, "_ZN6S494C24v148Ev");}
void  S494C2 ::v149(){vfunc_called(this, "_ZN6S494C24v149Ev");}
void  S494C2 ::v150(){vfunc_called(this, "_ZN6S494C24v150Ev");}
void  S494C2 ::v151(){vfunc_called(this, "_ZN6S494C24v151Ev");}
void  S494C2 ::v152(){vfunc_called(this, "_ZN6S494C24v152Ev");}
void  S494C2 ::v153(){vfunc_called(this, "_ZN6S494C24v153Ev");}
void  S494C2 ::v154(){vfunc_called(this, "_ZN6S494C24v154Ev");}
void  S494C2 ::v155(){vfunc_called(this, "_ZN6S494C24v155Ev");}
void  S494C2 ::v156(){vfunc_called(this, "_ZN6S494C24v156Ev");}
void  S494C2 ::v157(){vfunc_called(this, "_ZN6S494C24v157Ev");}
void  S494C2 ::v158(){vfunc_called(this, "_ZN6S494C24v158Ev");}
void  S494C2 ::v159(){vfunc_called(this, "_ZN6S494C24v159Ev");}
void  S494C2 ::v160(){vfunc_called(this, "_ZN6S494C24v160Ev");}
void  S494C2 ::v161(){vfunc_called(this, "_ZN6S494C24v161Ev");}
void  S494C2 ::v162(){vfunc_called(this, "_ZN6S494C24v162Ev");}
void  S494C2 ::v163(){vfunc_called(this, "_ZN6S494C24v163Ev");}
void  S494C2 ::v164(){vfunc_called(this, "_ZN6S494C24v164Ev");}
void  S494C2 ::v165(){vfunc_called(this, "_ZN6S494C24v165Ev");}
void  S494C2 ::v166(){vfunc_called(this, "_ZN6S494C24v166Ev");}
void  S494C2 ::v167(){vfunc_called(this, "_ZN6S494C24v167Ev");}
void  S494C2 ::v168(){vfunc_called(this, "_ZN6S494C24v168Ev");}
S494C2 ::S494C2(){ note_ctor("S494C2", this);} // tgen

static void Test_S494C2()
{
  extern Class_Descriptor cd_S494C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S494C2, buf);
    S494C2 *dp, &lv = *(dp=new (buf) S494C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S494C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C2)");
    check_base_class_offset(lv, (S494C5*)(S494C4*)(S494C3*), 0, "S494C2");
    check_base_class_offset(lv, (S494C4*)(S494C3*), 0, "S494C2");
    check_base_class_offset(lv, (S494C3*), 0, "S494C2");
    check_field_offset(lv, s494c2f0, ABISELECT(136,84), "S494C2.s494c2f0");
    check_field_offset(lv, s494c2f1, ABISELECT(144,88), "S494C2.s494c2f1");
    check_field_offset(lv, s494c2f2, ABISELECT(148,92), "S494C2.s494c2f2");
    check_field_offset(lv, s494c2f3, ABISELECT(152,96), "S494C2.s494c2f3");
    check_field_offset(lv, s494c2f4, ABISELECT(156,100), "S494C2.s494c2f4");
    check_field_offset(lv, s494c2f5, ABISELECT(160,104), "S494C2.s494c2f5");
    check_field_offset(lv, s494c2f6, ABISELECT(176,116), "S494C2.s494c2f6");
    check_field_offset(lv, s494c2f7, ABISELECT(184,120), "S494C2.s494c2f7");
    check_field_offset(lv, s494c2f8, ABISELECT(200,128), "S494C2.s494c2f8");
    check_field_offset(lv, s494c2f9, ABISELECT(232,156), "S494C2.s494c2f9");
    check_field_offset(lv, s494c2f10, ABISELECT(240,160), "S494C2.s494c2f10");
    check_field_offset(lv, s494c2f11, ABISELECT(248,168), "S494C2.s494c2f11");
    check_field_offset(lv, s494c2f12, ABISELECT(252,172), "S494C2.s494c2f12");
    set_bf_and_test(lv, s494c2f13, ABISELECT(256,176), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f14, ABISELECT(256,176), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f15, ABISELECT(256,176), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f16, ABISELECT(256,176), 3, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f17, ABISELECT(256,176), 4, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f18, ABISELECT(256,176), 5, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f19, ABISELECT(256,176), 6, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f20, ABISELECT(256,176), 7, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f21, ABISELECT(257,177), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f22, ABISELECT(257,177), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f23, ABISELECT(257,177), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f24, ABISELECT(257,177), 3, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f25, ABISELECT(257,177), 4, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f26, ABISELECT(257,177), 5, 1, 1, "S494C2");
    check_field_offset(lv, s494c2f27, ABISELECT(260,180), "S494C2.s494c2f27");
    set_bf_and_test(lv, s494c2f28, ABISELECT(264,184), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f29, ABISELECT(264,184), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f30, ABISELECT(264,184), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f31, ABISELECT(264,184), 3, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f32, ABISELECT(264,184), 4, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f33, ABISELECT(264,184), 5, 1, 1, "S494C2");
    check_field_offset(lv, s494c2f34, ABISELECT(265,185), "S494C2.s494c2f34");
    set_bf_and_test(lv, s494c2f35, ABISELECT(266,186), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f36, ABISELECT(266,186), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f37, ABISELECT(266,186), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f38, ABISELECT(266,186), 3, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f39, ABISELECT(266,186), 4, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f40, ABISELECT(266,186), 5, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f41, ABISELECT(266,186), 6, 1, 1, "S494C2");
    check_field_offset(lv, s494c2f42, ABISELECT(267,187), "S494C2.s494c2f42");
    check_field_offset(lv, s494c2f43, ABISELECT(268,188), "S494C2.s494c2f43");
    set_bf_and_test(lv, s494c2f44, ABISELECT(269,189), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f45, ABISELECT(269,189), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f46, ABISELECT(269,189), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f47, ABISELECT(269,189), 3, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f48, ABISELECT(269,189), 4, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f49, ABISELECT(269,189), 5, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f50, ABISELECT(269,189), 6, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f51, ABISELECT(269,189), 7, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f52, ABISELECT(270,190), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f53, ABISELECT(270,190), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f54, ABISELECT(270,190), 2, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f55, ABISELECT(270,190), 3, 1, 1, "S494C2");
    check_field_offset(lv, s494c2f56, ABISELECT(272,192), "S494C2.s494c2f56");
    check_field_offset(lv, s494c2f57, ABISELECT(288,204), "S494C2.s494c2f57");
    check_field_offset(lv, s494c2f58, ABISELECT(304,212), "S494C2.s494c2f58");
    check_field_offset(lv, s494c2f59, ABISELECT(305,213), "S494C2.s494c2f59");
    check_field_offset(lv, s494c2f60, ABISELECT(308,216), "S494C2.s494c2f60");
    check_field_offset(lv, s494c2f61, ABISELECT(320,228), "S494C2.s494c2f61");
    check_field_offset(lv, s494c2f62, ABISELECT(332,240), "S494C2.s494c2f62");
    check_field_offset(lv, s494c2f63, ABISELECT(336,244), "S494C2.s494c2f63");
    set_bf_and_test(lv, s494c2f64, ABISELECT(348,256), 0, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f65, ABISELECT(348,256), 1, 1, 1, "S494C2");
    set_bf_and_test(lv, s494c2f66, ABISELECT(348,256), 2, 1, 1, "S494C2");
    check_field_offset(lv, s494c2f67, ABISELECT(352,260), "S494C2.s494c2f67");
    test_class_info(&lv, &cd_S494C2);
    dp->~S494C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C2(Test_S494C2, "S494C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S494C2C1Ev();
extern void _ZN6S494C2D1Ev();
Name_Map name_map_S494C2[] = {
  NSPAIR(_ZN6S494C2C1Ev),
  NSPAIR(_ZN6S494C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S494C5;
extern VTBL_ENTRY _ZTI6S494C5[];
extern  VTBL_ENTRY _ZTV6S494C5[];
extern Class_Descriptor cd_S494C4;
extern VTBL_ENTRY _ZTI6S494C4[];
extern  VTBL_ENTRY _ZTV6S494C4[];
extern Class_Descriptor cd_S494C3;
extern VTBL_ENTRY _ZTI6S494C3[];
extern  VTBL_ENTRY _ZTV6S494C3[];
static Base_Class bases_S494C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S494C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S494C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S494C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S494C2[];
extern void _ZN6S494C2D1Ev();
extern void _ZN6S494C2D0Ev();
extern void _ZN6S494C53v17Ev();
extern void _ZN6S494C53v18Ev();
extern void _ZN6S494C53v19Ev();
extern void _ZN6S494C53v20Ev();
extern void _ZN6S494C53v21Ev();
extern void _ZN6S494C53v22Ev();
extern void _ZN6S494C53v23Ev();
extern void _ZN6S494C53v24Ev();
extern void _ZN6S494C53v25Ev();
extern void _ZN6S494C53v26Ev();
extern void _ZN6S494C53v27Ev();
extern void _ZN6S494C53v28Ev();
extern void _ZN6S494C53v29Ev();
extern void _ZN6S494C53v30Ev();
extern void _ZN6S494C53v31Ev();
extern void _ZN6S494C53v32Ev();
extern void _ZN6S494C53v33Ev();
extern void _ZN6S494C53v34Ev();
extern void _ZN6S494C53v35Ev();
extern void _ZN6S494C53v36Ev();
extern void _ZN6S494C53v37Ev();
extern void _ZN6S494C53v38Ev();
extern void _ZN6S494C53v39Ev();
extern void _ZN6S494C53v40Ev();
extern void _ZN6S494C53v41Ev();
extern void _ZN6S494C53v42Ev();
extern void _ZN6S494C53v43Ev();
extern void _ZN6S494C53v44Ev();
extern void _ZN6S494C53v45Ev();
extern void _ZN6S494C53v46Ev();
extern void _ZN6S494C53v47Ev();
extern void _ZN6S494C53v48Ev();
extern void _ZN6S494C53v49Ev();
extern void _ZN6S494C53v50Ev();
extern void _ZN6S494C53v51Ev();
extern void _ZN6S494C53v52Ev();
extern void _ZN6S494C53v53Ev();
extern void _ZN6S494C53v54Ev();
extern void _ZN6S494C53v55Ev();
extern void _ZN6S494C53v56Ev();
extern void _ZN6S494C53v57Ev();
extern void _ZN6S494C53v58Ev();
extern void _ZN6S494C53v59Ev();
extern void _ZN6S494C53v60Ev();
extern void _ZN6S494C53v61Ev();
extern void _ZN6S494C53v62Ev();
extern void _ZN6S494C53v63Ev();
extern void _ZN6S494C53v64Ev();
extern void _ZN6S494C53v65Ev();
extern void _ZN6S494C53v66Ev();
extern void _ZN6S494C53v67Ev();
extern void _ZN6S494C53v68Ev();
extern void _ZN6S494C53v69Ev();
extern void _ZN6S494C53v70Ev();
extern void _ZN6S494C53v71Ev();
extern void _ZN6S494C53v72Ev();
extern void _ZN6S494C53v73Ev();
extern void _ZN6S494C53v74Ev();
extern void _ZN6S494C53v75Ev();
extern void _ZN6S494C53v76Ev();
extern void _ZN6S494C53v77Ev();
extern void _ZN6S494C53v78Ev();
extern void _ZN6S494C53v79Ev();
extern void _ZN6S494C53v80Ev();
extern void _ZN6S494C43v81Ev();
extern void _ZN6S494C43v82Ev();
extern void _ZN6S494C43v83Ev();
extern void _ZN6S494C43v84Ev();
extern void _ZN6S494C43v85Ev();
extern void _ZN6S494C33v86Ev();
extern void _ZN6S494C33v87Ev();
extern void _ZN6S494C33v88Ev();
extern void _ZN6S494C33v89Ev();
extern void _ZN6S494C33v90Ev();
extern void _ZN6S494C33v91Ev();
extern void _ZN6S494C33v92Ev();
extern void _ZN6S494C33v93Ev();
extern void _ZN6S494C33v94Ev();
extern void _ZN6S494C33v95Ev();
extern void _ZN6S494C33v96Ev();
extern void _ZN6S494C33v97Ev();
extern void _ZN6S494C33v98Ev();
extern void _ZN6S494C33v99Ev();
extern void _ZN6S494C34v100Ev();
extern void _ZN6S494C34v101Ev();
extern void _ZN6S494C34v102Ev();
extern void _ZN6S494C34v103Ev();
extern void _ZN6S494C34v104Ev();
extern void _ZN6S494C34v105Ev();
extern void _ZN6S494C34v106Ev();
extern void _ZN6S494C34v107Ev();
extern void _ZN6S494C24v108Ev();
extern void _ZN6S494C24v109Ev();
extern void _ZN6S494C24v110Ev();
extern void _ZN6S494C24v111Ev();
extern void _ZN6S494C24v112Ev();
extern void _ZN6S494C24v113Ev();
extern void _ZN6S494C24v114Ev();
extern void _ZN6S494C24v115Ev();
extern void _ZN6S494C24v116Ev();
extern void _ZN6S494C24v117Ev();
extern void _ZN6S494C24v118Ev();
extern void _ZN6S494C24v119Ev();
extern void _ZN6S494C24v120Ev();
extern void _ZN6S494C24v121Ev();
extern void _ZN6S494C24v122Ev();
extern void _ZN6S494C24v123Ev();
extern void _ZN6S494C24v124Ev();
extern void _ZN6S494C24v125Ev();
extern void _ZN6S494C24v126Ev();
extern void _ZN6S494C24v127Ev();
extern void _ZN6S494C24v128Ev();
extern void _ZN6S494C24v129Ev();
extern void _ZN6S494C24v130Ev();
extern void _ZN6S494C24v131Ev();
extern void _ZN6S494C24v132Ev();
extern void _ZN6S494C24v133Ev();
extern void _ZN6S494C24v134Ev();
extern void _ZN6S494C24v135Ev();
extern void _ZN6S494C24v136Ev();
extern void _ZN6S494C24v137Ev();
extern void _ZN6S494C24v138Ev();
extern void _ZN6S494C24v139Ev();
extern void _ZN6S494C24v140Ev();
extern void _ZN6S494C24v141Ev();
extern void _ZN6S494C24v142Ev();
extern void _ZN6S494C24v143Ev();
extern void _ZN6S494C24v144Ev();
extern void _ZN6S494C24v145Ev();
extern void _ZN6S494C24v146Ev();
extern void _ZN6S494C24v147Ev();
extern void _ZN6S494C24v148Ev();
extern void _ZN6S494C24v149Ev();
extern void _ZN6S494C24v150Ev();
extern void _ZN6S494C24v151Ev();
extern void _ZN6S494C24v152Ev();
extern void _ZN6S494C24v153Ev();
extern void _ZN6S494C24v154Ev();
extern void _ZN6S494C24v155Ev();
extern void _ZN6S494C24v156Ev();
extern void _ZN6S494C24v157Ev();
extern void _ZN6S494C24v158Ev();
extern void _ZN6S494C24v159Ev();
extern void _ZN6S494C24v160Ev();
extern void _ZN6S494C24v161Ev();
extern void _ZN6S494C24v162Ev();
extern void _ZN6S494C24v163Ev();
extern void _ZN6S494C24v164Ev();
extern void _ZN6S494C24v165Ev();
extern void _ZN6S494C24v166Ev();
extern void _ZN6S494C24v167Ev();
extern void _ZN6S494C24v168Ev();
static  VTBL_ENTRY vtc_S494C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S494C2[0]),
  (VTBL_ENTRY)&_ZN6S494C2D1Ev,
  (VTBL_ENTRY)&_ZN6S494C2D0Ev,
  (VTBL_ENTRY)&_ZN6S494C53v17Ev,
  (VTBL_ENTRY)&_ZN6S494C53v18Ev,
  (VTBL_ENTRY)&_ZN6S494C53v19Ev,
  (VTBL_ENTRY)&_ZN6S494C53v20Ev,
  (VTBL_ENTRY)&_ZN6S494C53v21Ev,
  (VTBL_ENTRY)&_ZN6S494C53v22Ev,
  (VTBL_ENTRY)&_ZN6S494C53v23Ev,
  (VTBL_ENTRY)&_ZN6S494C53v24Ev,
  (VTBL_ENTRY)&_ZN6S494C53v25Ev,
  (VTBL_ENTRY)&_ZN6S494C53v26Ev,
  (VTBL_ENTRY)&_ZN6S494C53v27Ev,
  (VTBL_ENTRY)&_ZN6S494C53v28Ev,
  (VTBL_ENTRY)&_ZN6S494C53v29Ev,
  (VTBL_ENTRY)&_ZN6S494C53v30Ev,
  (VTBL_ENTRY)&_ZN6S494C53v31Ev,
  (VTBL_ENTRY)&_ZN6S494C53v32Ev,
  (VTBL_ENTRY)&_ZN6S494C53v33Ev,
  (VTBL_ENTRY)&_ZN6S494C53v34Ev,
  (VTBL_ENTRY)&_ZN6S494C53v35Ev,
  (VTBL_ENTRY)&_ZN6S494C53v36Ev,
  (VTBL_ENTRY)&_ZN6S494C53v37Ev,
  (VTBL_ENTRY)&_ZN6S494C53v38Ev,
  (VTBL_ENTRY)&_ZN6S494C53v39Ev,
  (VTBL_ENTRY)&_ZN6S494C53v40Ev,
  (VTBL_ENTRY)&_ZN6S494C53v41Ev,
  (VTBL_ENTRY)&_ZN6S494C53v42Ev,
  (VTBL_ENTRY)&_ZN6S494C53v43Ev,
  (VTBL_ENTRY)&_ZN6S494C53v44Ev,
  (VTBL_ENTRY)&_ZN6S494C53v45Ev,
  (VTBL_ENTRY)&_ZN6S494C53v46Ev,
  (VTBL_ENTRY)&_ZN6S494C53v47Ev,
  (VTBL_ENTRY)&_ZN6S494C53v48Ev,
  (VTBL_ENTRY)&_ZN6S494C53v49Ev,
  (VTBL_ENTRY)&_ZN6S494C53v50Ev,
  (VTBL_ENTRY)&_ZN6S494C53v51Ev,
  (VTBL_ENTRY)&_ZN6S494C53v52Ev,
  (VTBL_ENTRY)&_ZN6S494C53v53Ev,
  (VTBL_ENTRY)&_ZN6S494C53v54Ev,
  (VTBL_ENTRY)&_ZN6S494C53v55Ev,
  (VTBL_ENTRY)&_ZN6S494C53v56Ev,
  (VTBL_ENTRY)&_ZN6S494C53v57Ev,
  (VTBL_ENTRY)&_ZN6S494C53v58Ev,
  (VTBL_ENTRY)&_ZN6S494C53v59Ev,
  (VTBL_ENTRY)&_ZN6S494C53v60Ev,
  (VTBL_ENTRY)&_ZN6S494C53v61Ev,
  (VTBL_ENTRY)&_ZN6S494C53v62Ev,
  (VTBL_ENTRY)&_ZN6S494C53v63Ev,
  (VTBL_ENTRY)&_ZN6S494C53v64Ev,
  (VTBL_ENTRY)&_ZN6S494C53v65Ev,
  (VTBL_ENTRY)&_ZN6S494C53v66Ev,
  (VTBL_ENTRY)&_ZN6S494C53v67Ev,
  (VTBL_ENTRY)&_ZN6S494C53v68Ev,
  (VTBL_ENTRY)&_ZN6S494C53v69Ev,
  (VTBL_ENTRY)&_ZN6S494C53v70Ev,
  (VTBL_ENTRY)&_ZN6S494C53v71Ev,
  (VTBL_ENTRY)&_ZN6S494C53v72Ev,
  (VTBL_ENTRY)&_ZN6S494C53v73Ev,
  (VTBL_ENTRY)&_ZN6S494C53v74Ev,
  (VTBL_ENTRY)&_ZN6S494C53v75Ev,
  (VTBL_ENTRY)&_ZN6S494C53v76Ev,
  (VTBL_ENTRY)&_ZN6S494C53v77Ev,
  (VTBL_ENTRY)&_ZN6S494C53v78Ev,
  (VTBL_ENTRY)&_ZN6S494C53v79Ev,
  (VTBL_ENTRY)&_ZN6S494C53v80Ev,
  (VTBL_ENTRY)&_ZN6S494C43v81Ev,
  (VTBL_ENTRY)&_ZN6S494C43v82Ev,
  (VTBL_ENTRY)&_ZN6S494C43v83Ev,
  (VTBL_ENTRY)&_ZN6S494C43v84Ev,
  (VTBL_ENTRY)&_ZN6S494C43v85Ev,
  (VTBL_ENTRY)&_ZN6S494C33v86Ev,
  (VTBL_ENTRY)&_ZN6S494C33v87Ev,
  (VTBL_ENTRY)&_ZN6S494C33v88Ev,
  (VTBL_ENTRY)&_ZN6S494C33v89Ev,
  (VTBL_ENTRY)&_ZN6S494C33v90Ev,
  (VTBL_ENTRY)&_ZN6S494C33v91Ev,
  (VTBL_ENTRY)&_ZN6S494C33v92Ev,
  (VTBL_ENTRY)&_ZN6S494C33v93Ev,
  (VTBL_ENTRY)&_ZN6S494C33v94Ev,
  (VTBL_ENTRY)&_ZN6S494C33v95Ev,
  (VTBL_ENTRY)&_ZN6S494C33v96Ev,
  (VTBL_ENTRY)&_ZN6S494C33v97Ev,
  (VTBL_ENTRY)&_ZN6S494C33v98Ev,
  (VTBL_ENTRY)&_ZN6S494C33v99Ev,
  (VTBL_ENTRY)&_ZN6S494C34v100Ev,
  (VTBL_ENTRY)&_ZN6S494C34v101Ev,
  (VTBL_ENTRY)&_ZN6S494C34v102Ev,
  (VTBL_ENTRY)&_ZN6S494C34v103Ev,
  (VTBL_ENTRY)&_ZN6S494C34v104Ev,
  (VTBL_ENTRY)&_ZN6S494C34v105Ev,
  (VTBL_ENTRY)&_ZN6S494C34v106Ev,
  (VTBL_ENTRY)&_ZN6S494C34v107Ev,
  (VTBL_ENTRY)&_ZN6S494C24v108Ev,
  (VTBL_ENTRY)&_ZN6S494C24v109Ev,
  (VTBL_ENTRY)&_ZN6S494C24v110Ev,
  (VTBL_ENTRY)&_ZN6S494C24v111Ev,
  (VTBL_ENTRY)&_ZN6S494C24v112Ev,
  (VTBL_ENTRY)&_ZN6S494C24v113Ev,
  (VTBL_ENTRY)&_ZN6S494C24v114Ev,
  (VTBL_ENTRY)&_ZN6S494C24v115Ev,
  (VTBL_ENTRY)&_ZN6S494C24v116Ev,
  (VTBL_ENTRY)&_ZN6S494C24v117Ev,
  (VTBL_ENTRY)&_ZN6S494C24v118Ev,
  (VTBL_ENTRY)&_ZN6S494C24v119Ev,
  (VTBL_ENTRY)&_ZN6S494C24v120Ev,
  (VTBL_ENTRY)&_ZN6S494C24v121Ev,
  (VTBL_ENTRY)&_ZN6S494C24v122Ev,
  (VTBL_ENTRY)&_ZN6S494C24v123Ev,
  (VTBL_ENTRY)&_ZN6S494C24v124Ev,
  (VTBL_ENTRY)&_ZN6S494C24v125Ev,
  (VTBL_ENTRY)&_ZN6S494C24v126Ev,
  (VTBL_ENTRY)&_ZN6S494C24v127Ev,
  (VTBL_ENTRY)&_ZN6S494C24v128Ev,
  (VTBL_ENTRY)&_ZN6S494C24v129Ev,
  (VTBL_ENTRY)&_ZN6S494C24v130Ev,
  (VTBL_ENTRY)&_ZN6S494C24v131Ev,
  (VTBL_ENTRY)&_ZN6S494C24v132Ev,
  (VTBL_ENTRY)&_ZN6S494C24v133Ev,
  (VTBL_ENTRY)&_ZN6S494C24v134Ev,
  (VTBL_ENTRY)&_ZN6S494C24v135Ev,
  (VTBL_ENTRY)&_ZN6S494C24v136Ev,
  (VTBL_ENTRY)&_ZN6S494C24v137Ev,
  (VTBL_ENTRY)&_ZN6S494C24v138Ev,
  (VTBL_ENTRY)&_ZN6S494C24v139Ev,
  (VTBL_ENTRY)&_ZN6S494C24v140Ev,
  (VTBL_ENTRY)&_ZN6S494C24v141Ev,
  (VTBL_ENTRY)&_ZN6S494C24v142Ev,
  (VTBL_ENTRY)&_ZN6S494C24v143Ev,
  (VTBL_ENTRY)&_ZN6S494C24v144Ev,
  (VTBL_ENTRY)&_ZN6S494C24v145Ev,
  (VTBL_ENTRY)&_ZN6S494C24v146Ev,
  (VTBL_ENTRY)&_ZN6S494C24v147Ev,
  (VTBL_ENTRY)&_ZN6S494C24v148Ev,
  (VTBL_ENTRY)&_ZN6S494C24v149Ev,
  (VTBL_ENTRY)&_ZN6S494C24v150Ev,
  (VTBL_ENTRY)&_ZN6S494C24v151Ev,
  (VTBL_ENTRY)&_ZN6S494C24v152Ev,
  (VTBL_ENTRY)&_ZN6S494C24v153Ev,
  (VTBL_ENTRY)&_ZN6S494C24v154Ev,
  (VTBL_ENTRY)&_ZN6S494C24v155Ev,
  (VTBL_ENTRY)&_ZN6S494C24v156Ev,
  (VTBL_ENTRY)&_ZN6S494C24v157Ev,
  (VTBL_ENTRY)&_ZN6S494C24v158Ev,
  (VTBL_ENTRY)&_ZN6S494C24v159Ev,
  (VTBL_ENTRY)&_ZN6S494C24v160Ev,
  (VTBL_ENTRY)&_ZN6S494C24v161Ev,
  (VTBL_ENTRY)&_ZN6S494C24v162Ev,
  (VTBL_ENTRY)&_ZN6S494C24v163Ev,
  (VTBL_ENTRY)&_ZN6S494C24v164Ev,
  (VTBL_ENTRY)&_ZN6S494C24v165Ev,
  (VTBL_ENTRY)&_ZN6S494C24v166Ev,
  (VTBL_ENTRY)&_ZN6S494C24v167Ev,
  (VTBL_ENTRY)&_ZN6S494C24v168Ev,
};
extern VTBL_ENTRY _ZTI6S494C2[];
extern  VTBL_ENTRY _ZTV6S494C2[];
Class_Descriptor cd_S494C2 = {  "S494C2", // class name
  bases_S494C2, 3,
  &(vtc_S494C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S494C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S494C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C18  {
  void *s494c18f0;
  virtual void  v169(); // _ZN7S494C184v169Ev
  virtual void  v170(); // _ZN7S494C184v170Ev
  virtual void  v171(); // _ZN7S494C184v171Ev
  virtual void  v172(); // _ZN7S494C184v172Ev
  virtual void  v173(); // _ZN7S494C184v173Ev
  virtual void  v174(); // _ZN7S494C184v174Ev
  virtual void  v175(); // _ZN7S494C184v175Ev
  virtual void  v176(); // _ZN7S494C184v176Ev
  ~S494C18(); // tgen
  S494C18(); // tgen
};
//SIG(-1 S494C18) C1{ v1 v2 v3 v4 v5 v6 v7 v8 Fp}


void  S494C18 ::v169(){vfunc_called(this, "_ZN7S494C184v169Ev");}
void  S494C18 ::v170(){vfunc_called(this, "_ZN7S494C184v170Ev");}
void  S494C18 ::v171(){vfunc_called(this, "_ZN7S494C184v171Ev");}
void  S494C18 ::v172(){vfunc_called(this, "_ZN7S494C184v172Ev");}
void  S494C18 ::v173(){vfunc_called(this, "_ZN7S494C184v173Ev");}
void  S494C18 ::v174(){vfunc_called(this, "_ZN7S494C184v174Ev");}
void  S494C18 ::v175(){vfunc_called(this, "_ZN7S494C184v175Ev");}
void  S494C18 ::v176(){vfunc_called(this, "_ZN7S494C184v176Ev");}
S494C18 ::~S494C18(){ note_dtor("S494C18", this);} // tgen
S494C18 ::S494C18(){ note_ctor("S494C18", this);} // tgen

static void Test_S494C18()
{
  extern Class_Descriptor cd_S494C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S494C18, buf);
    S494C18 *dp, &lv = *(dp=new (buf) S494C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S494C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C18)");
    check_field_offset(lv, s494c18f0, ABISELECT(8,4), "S494C18.s494c18f0");
    test_class_info(&lv, &cd_S494C18);
    dp->~S494C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C18(Test_S494C18, "S494C18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S494C18C1Ev();
extern void _ZN7S494C18D1Ev();
Name_Map name_map_S494C18[] = {
  NSPAIR(_ZN7S494C18C1Ev),
  NSPAIR(_ZN7S494C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S494C18[];
extern void _ZN7S494C184v169Ev();
extern void _ZN7S494C184v170Ev();
extern void _ZN7S494C184v171Ev();
extern void _ZN7S494C184v172Ev();
extern void _ZN7S494C184v173Ev();
extern void _ZN7S494C184v174Ev();
extern void _ZN7S494C184v175Ev();
extern void _ZN7S494C184v176Ev();
static  VTBL_ENTRY vtc_S494C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S494C18[0]),
  (VTBL_ENTRY)&_ZN7S494C184v169Ev,
  (VTBL_ENTRY)&_ZN7S494C184v170Ev,
  (VTBL_ENTRY)&_ZN7S494C184v171Ev,
  (VTBL_ENTRY)&_ZN7S494C184v172Ev,
  (VTBL_ENTRY)&_ZN7S494C184v173Ev,
  (VTBL_ENTRY)&_ZN7S494C184v174Ev,
  (VTBL_ENTRY)&_ZN7S494C184v175Ev,
  (VTBL_ENTRY)&_ZN7S494C184v176Ev,
};
extern VTBL_ENTRY _ZTI7S494C18[];
extern  VTBL_ENTRY _ZTV7S494C18[];
Class_Descriptor cd_S494C18 = {  "S494C18", // class name
  0,0,//no base classes
  &(vtc_S494C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S494C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S494C18),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S494C1  : S494C2 , S494C18 {
  ::S236C26 s494c1f0;
  int s494c1f1;
  virtual  ~S494C1(); // _ZN6S494C1D1Ev
  virtual void  v1(); // _ZN6S494C12v1Ev
  virtual void  v2(); // _ZN6S494C12v2Ev
  virtual void  v3(); // _ZN6S494C12v3Ev
  virtual void  v4(); // _ZN6S494C12v4Ev
  virtual void  v5(); // _ZN6S494C12v5Ev
  virtual void  v6(); // _ZN6S494C12v6Ev
  virtual void  v7(); // _ZN6S494C12v7Ev
  virtual void  v8(); // _ZN6S494C12v8Ev
  virtual void  v9(); // _ZN6S494C12v9Ev
  virtual void  v10(); // _ZN6S494C13v10Ev
  virtual void  v11(); // _ZN6S494C13v11Ev
  virtual void  v12(); // _ZN6S494C13v12Ev
  virtual void  v13(); // _ZN6S494C13v13Ev
  virtual void  v14(); // _ZN6S494C13v14Ev
  virtual void  v15(); // _ZN6S494C13v15Ev
  virtual void  v16(); // _ZN6S494C13v16Ev
  S494C1(); // tgen
};
//SIG(1 S494C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84 v85 Fp FC6} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} BC17{ v169 v170 v171 v172 v173 v174 v175 v176 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC18{ BC10} Fi}


 S494C1 ::~S494C1(){ note_dtor("S494C1", this);}
void  S494C1 ::v1(){vfunc_called(this, "_ZN6S494C12v1Ev");}
void  S494C1 ::v2(){vfunc_called(this, "_ZN6S494C12v2Ev");}
void  S494C1 ::v3(){vfunc_called(this, "_ZN6S494C12v3Ev");}
void  S494C1 ::v4(){vfunc_called(this, "_ZN6S494C12v4Ev");}
void  S494C1 ::v5(){vfunc_called(this, "_ZN6S494C12v5Ev");}
void  S494C1 ::v6(){vfunc_called(this, "_ZN6S494C12v6Ev");}
void  S494C1 ::v7(){vfunc_called(this, "_ZN6S494C12v7Ev");}
void  S494C1 ::v8(){vfunc_called(this, "_ZN6S494C12v8Ev");}
void  S494C1 ::v9(){vfunc_called(this, "_ZN6S494C12v9Ev");}
void  S494C1 ::v10(){vfunc_called(this, "_ZN6S494C13v10Ev");}
void  S494C1 ::v11(){vfunc_called(this, "_ZN6S494C13v11Ev");}
void  S494C1 ::v12(){vfunc_called(this, "_ZN6S494C13v12Ev");}
void  S494C1 ::v13(){vfunc_called(this, "_ZN6S494C13v13Ev");}
void  S494C1 ::v14(){vfunc_called(this, "_ZN6S494C13v14Ev");}
void  S494C1 ::v15(){vfunc_called(this, "_ZN6S494C13v15Ev");}
void  S494C1 ::v16(){vfunc_called(this, "_ZN6S494C13v16Ev");}
S494C1 ::S494C1(){ note_ctor("S494C1", this);} // tgen

static void Test_S494C1()
{
  extern Class_Descriptor cd_S494C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(52,75)];
    init_test(&cd_S494C1, buf);
    S494C1 *dp, &lv = *(dp=new (buf) S494C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(408,296), "sizeof(S494C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S494C1)");
    check_base_class_offset(lv, (S494C5*)(S494C4*)(S494C3*)(S494C2*), 0, "S494C1");
    check_base_class_offset(lv, (S494C4*)(S494C3*)(S494C2*), 0, "S494C1");
    check_base_class_offset(lv, (S494C3*)(S494C2*), 0, "S494C1");
    check_base_class_offset(lv, (S494C2*), 0, "S494C1");
    check_base_class_offset(lv, (S494C18*), ABISELECT(368,272), "S494C1");
    check_field_offset(lv, s494c1f0, ABISELECT(384,280), "S494C1.s494c1f0");
    check_field_offset(lv, s494c1f1, ABISELECT(400,292), "S494C1.s494c1f1");
    test_class_info(&lv, &cd_S494C1);
    dp->~S494C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS494C1(Test_S494C1, "S494C1", ABISELECT(408,296));

#else // __cplusplus

extern void _ZN6S494C1C1Ev();
extern void _ZN6S494C1D1Ev();
Name_Map name_map_S494C1[] = {
  NSPAIR(_ZN6S494C1C1Ev),
  NSPAIR(_ZN6S494C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S494C5;
extern VTBL_ENTRY _ZTI6S494C5[];
extern  VTBL_ENTRY _ZTV6S494C5[];
extern Class_Descriptor cd_S494C4;
extern VTBL_ENTRY _ZTI6S494C4[];
extern  VTBL_ENTRY _ZTV6S494C4[];
extern Class_Descriptor cd_S494C3;
extern VTBL_ENTRY _ZTI6S494C3[];
extern  VTBL_ENTRY _ZTV6S494C3[];
extern Class_Descriptor cd_S494C2;
extern VTBL_ENTRY _ZTI6S494C2[];
extern  VTBL_ENTRY _ZTV6S494C2[];
extern Class_Descriptor cd_S494C18;
extern VTBL_ENTRY _ZTI7S494C18[];
extern  VTBL_ENTRY _ZTV7S494C18[];
static Base_Class bases_S494C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S494C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S494C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S494C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S494C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S494C18,    ABISELECT(368,272), //bcp->offset
    172, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S494C1[];
extern void _ZN6S494C1D1Ev();
extern void _ZN6S494C1D0Ev();
extern void _ZN6S494C53v17Ev();
extern void _ZN6S494C53v18Ev();
extern void _ZN6S494C53v19Ev();
extern void _ZN6S494C53v20Ev();
extern void _ZN6S494C53v21Ev();
extern void _ZN6S494C53v22Ev();
extern void _ZN6S494C53v23Ev();
extern void _ZN6S494C53v24Ev();
extern void _ZN6S494C53v25Ev();
extern void _ZN6S494C53v26Ev();
extern void _ZN6S494C53v27Ev();
extern void _ZN6S494C53v28Ev();
extern void _ZN6S494C53v29Ev();
extern void _ZN6S494C53v30Ev();
extern void _ZN6S494C53v31Ev();
extern void _ZN6S494C53v32Ev();
extern void _ZN6S494C53v33Ev();
extern void _ZN6S494C53v34Ev();
extern void _ZN6S494C53v35Ev();
extern void _ZN6S494C53v36Ev();
extern void _ZN6S494C53v37Ev();
extern void _ZN6S494C53v38Ev();
extern void _ZN6S494C53v39Ev();
extern void _ZN6S494C53v40Ev();
extern void _ZN6S494C53v41Ev();
extern void _ZN6S494C53v42Ev();
extern void _ZN6S494C53v43Ev();
extern void _ZN6S494C53v44Ev();
extern void _ZN6S494C53v45Ev();
extern void _ZN6S494C53v46Ev();
extern void _ZN6S494C53v47Ev();
extern void _ZN6S494C53v48Ev();
extern void _ZN6S494C53v49Ev();
extern void _ZN6S494C53v50Ev();
extern void _ZN6S494C53v51Ev();
extern void _ZN6S494C53v52Ev();
extern void _ZN6S494C53v53Ev();
extern void _ZN6S494C53v54Ev();
extern void _ZN6S494C53v55Ev();
extern void _ZN6S494C53v56Ev();
extern void _ZN6S494C53v57Ev();
extern void _ZN6S494C53v58Ev();
extern void _ZN6S494C53v59Ev();
extern void _ZN6S494C53v60Ev();
extern void _ZN6S494C53v61Ev();
extern void _ZN6S494C53v62Ev();
extern void _ZN6S494C53v63Ev();
extern void _ZN6S494C53v64Ev();
extern void _ZN6S494C53v65Ev();
extern void _ZN6S494C53v66Ev();
extern void _ZN6S494C53v67Ev();
extern void _ZN6S494C53v68Ev();
extern void _ZN6S494C53v69Ev();
extern void _ZN6S494C53v70Ev();
extern void _ZN6S494C53v71Ev();
extern void _ZN6S494C53v72Ev();
extern void _ZN6S494C53v73Ev();
extern void _ZN6S494C53v74Ev();
extern void _ZN6S494C53v75Ev();
extern void _ZN6S494C53v76Ev();
extern void _ZN6S494C53v77Ev();
extern void _ZN6S494C53v78Ev();
extern void _ZN6S494C53v79Ev();
extern void _ZN6S494C53v80Ev();
extern void _ZN6S494C43v81Ev();
extern void _ZN6S494C43v82Ev();
extern void _ZN6S494C43v83Ev();
extern void _ZN6S494C43v84Ev();
extern void _ZN6S494C43v85Ev();
extern void _ZN6S494C33v86Ev();
extern void _ZN6S494C33v87Ev();
extern void _ZN6S494C33v88Ev();
extern void _ZN6S494C33v89Ev();
extern void _ZN6S494C33v90Ev();
extern void _ZN6S494C33v91Ev();
extern void _ZN6S494C33v92Ev();
extern void _ZN6S494C33v93Ev();
extern void _ZN6S494C33v94Ev();
extern void _ZN6S494C33v95Ev();
extern void _ZN6S494C33v96Ev();
extern void _ZN6S494C33v97Ev();
extern void _ZN6S494C33v98Ev();
extern void _ZN6S494C33v99Ev();
extern void _ZN6S494C34v100Ev();
extern void _ZN6S494C34v101Ev();
extern void _ZN6S494C34v102Ev();
extern void _ZN6S494C34v103Ev();
extern void _ZN6S494C34v104Ev();
extern void _ZN6S494C34v105Ev();
extern void _ZN6S494C34v106Ev();
extern void _ZN6S494C34v107Ev();
extern void _ZN6S494C24v108Ev();
extern void _ZN6S494C24v109Ev();
extern void _ZN6S494C24v110Ev();
extern void _ZN6S494C24v111Ev();
extern void _ZN6S494C24v112Ev();
extern void _ZN6S494C24v113Ev();
extern void _ZN6S494C24v114Ev();
extern void _ZN6S494C24v115Ev();
extern void _ZN6S494C24v116Ev();
extern void _ZN6S494C24v117Ev();
extern void _ZN6S494C24v118Ev();
extern void _ZN6S494C24v119Ev();
extern void _ZN6S494C24v120Ev();
extern void _ZN6S494C24v121Ev();
extern void _ZN6S494C24v122Ev();
extern void _ZN6S494C24v123Ev();
extern void _ZN6S494C24v124Ev();
extern void _ZN6S494C24v125Ev();
extern void _ZN6S494C24v126Ev();
extern void _ZN6S494C24v127Ev();
extern void _ZN6S494C24v128Ev();
extern void _ZN6S494C24v129Ev();
extern void _ZN6S494C24v130Ev();
extern void _ZN6S494C24v131Ev();
extern void _ZN6S494C24v132Ev();
extern void _ZN6S494C24v133Ev();
extern void _ZN6S494C24v134Ev();
extern void _ZN6S494C24v135Ev();
extern void _ZN6S494C24v136Ev();
extern void _ZN6S494C24v137Ev();
extern void _ZN6S494C24v138Ev();
extern void _ZN6S494C24v139Ev();
extern void _ZN6S494C24v140Ev();
extern void _ZN6S494C24v141Ev();
extern void _ZN6S494C24v142Ev();
extern void _ZN6S494C24v143Ev();
extern void _ZN6S494C24v144Ev();
extern void _ZN6S494C24v145Ev();
extern void _ZN6S494C24v146Ev();
extern void _ZN6S494C24v147Ev();
extern void _ZN6S494C24v148Ev();
extern void _ZN6S494C24v149Ev();
extern void _ZN6S494C24v150Ev();
extern void _ZN6S494C24v151Ev();
extern void _ZN6S494C24v152Ev();
extern void _ZN6S494C24v153Ev();
extern void _ZN6S494C24v154Ev();
extern void _ZN6S494C24v155Ev();
extern void _ZN6S494C24v156Ev();
extern void _ZN6S494C24v157Ev();
extern void _ZN6S494C24v158Ev();
extern void _ZN6S494C24v159Ev();
extern void _ZN6S494C24v160Ev();
extern void _ZN6S494C24v161Ev();
extern void _ZN6S494C24v162Ev();
extern void _ZN6S494C24v163Ev();
extern void _ZN6S494C24v164Ev();
extern void _ZN6S494C24v165Ev();
extern void _ZN6S494C24v166Ev();
extern void _ZN6S494C24v167Ev();
extern void _ZN6S494C24v168Ev();
extern void _ZN6S494C12v1Ev();
extern void _ZN6S494C12v2Ev();
extern void _ZN6S494C12v3Ev();
extern void _ZN6S494C12v4Ev();
extern void _ZN6S494C12v5Ev();
extern void _ZN6S494C12v6Ev();
extern void _ZN6S494C12v7Ev();
extern void _ZN6S494C12v8Ev();
extern void _ZN6S494C12v9Ev();
extern void _ZN6S494C13v10Ev();
extern void _ZN6S494C13v11Ev();
extern void _ZN6S494C13v12Ev();
extern void _ZN6S494C13v13Ev();
extern void _ZN6S494C13v14Ev();
extern void _ZN6S494C13v15Ev();
extern void _ZN6S494C13v16Ev();
extern void _ZN7S494C184v169Ev();
extern void _ZN7S494C184v170Ev();
extern void _ZN7S494C184v171Ev();
extern void _ZN7S494C184v172Ev();
extern void _ZN7S494C184v173Ev();
extern void _ZN7S494C184v174Ev();
extern void _ZN7S494C184v175Ev();
extern void _ZN7S494C184v176Ev();
static  VTBL_ENTRY vtc_S494C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S494C1[0]),
  (VTBL_ENTRY)&_ZN6S494C1D1Ev,
  (VTBL_ENTRY)&_ZN6S494C1D0Ev,
  (VTBL_ENTRY)&_ZN6S494C53v17Ev,
  (VTBL_ENTRY)&_ZN6S494C53v18Ev,
  (VTBL_ENTRY)&_ZN6S494C53v19Ev,
  (VTBL_ENTRY)&_ZN6S494C53v20Ev,
  (VTBL_ENTRY)&_ZN6S494C53v21Ev,
  (VTBL_ENTRY)&_ZN6S494C53v22Ev,
  (VTBL_ENTRY)&_ZN6S494C53v23Ev,
  (VTBL_ENTRY)&_ZN6S494C53v24Ev,
  (VTBL_ENTRY)&_ZN6S494C53v25Ev,
  (VTBL_ENTRY)&_ZN6S494C53v26Ev,
  (VTBL_ENTRY)&_ZN6S494C53v27Ev,
  (VTBL_ENTRY)&_ZN6S494C53v28Ev,
  (VTBL_ENTRY)&_ZN6S494C53v29Ev,
  (VTBL_ENTRY)&_ZN6S494C53v30Ev,
  (VTBL_ENTRY)&_ZN6S494C53v31Ev,
  (VTBL_ENTRY)&_ZN6S494C53v32Ev,
  (VTBL_ENTRY)&_ZN6S494C53v33Ev,
  (VTBL_ENTRY)&_ZN6S494C53v34Ev,
  (VTBL_ENTRY)&_ZN6S494C53v35Ev,
  (VTBL_ENTRY)&_ZN6S494C53v36Ev,
  (VTBL_ENTRY)&_ZN6S494C53v37Ev,
  (VTBL_ENTRY)&_ZN6S494C53v38Ev,
  (VTBL_ENTRY)&_ZN6S494C53v39Ev,
  (VTBL_ENTRY)&_ZN6S494C53v40Ev,
  (VTBL_ENTRY)&_ZN6S494C53v41Ev,
  (VTBL_ENTRY)&_ZN6S494C53v42Ev,
  (VTBL_ENTRY)&_ZN6S494C53v43Ev,
  (VTBL_ENTRY)&_ZN6S494C53v44Ev,
  (VTBL_ENTRY)&_ZN6S494C53v45Ev,
  (VTBL_ENTRY)&_ZN6S494C53v46Ev,
  (VTBL_ENTRY)&_ZN6S494C53v47Ev,
  (VTBL_ENTRY)&_ZN6S494C53v48Ev,
  (VTBL_ENTRY)&_ZN6S494C53v49Ev,
  (VTBL_ENTRY)&_ZN6S494C53v50Ev,
  (VTBL_ENTRY)&_ZN6S494C53v51Ev,
  (VTBL_ENTRY)&_ZN6S494C53v52Ev,
  (VTBL_ENTRY)&_ZN6S494C53v53Ev,
  (VTBL_ENTRY)&_ZN6S494C53v54Ev,
  (VTBL_ENTRY)&_ZN6S494C53v55Ev,
  (VTBL_ENTRY)&_ZN6S494C53v56Ev,
  (VTBL_ENTRY)&_ZN6S494C53v57Ev,
  (VTBL_ENTRY)&_ZN6S494C53v58Ev,
  (VTBL_ENTRY)&_ZN6S494C53v59Ev,
  (VTBL_ENTRY)&_ZN6S494C53v60Ev,
  (VTBL_ENTRY)&_ZN6S494C53v61Ev,
  (VTBL_ENTRY)&_ZN6S494C53v62Ev,
  (VTBL_ENTRY)&_ZN6S494C53v63Ev,
  (VTBL_ENTRY)&_ZN6S494C53v64Ev,
  (VTBL_ENTRY)&_ZN6S494C53v65Ev,
  (VTBL_ENTRY)&_ZN6S494C53v66Ev,
  (VTBL_ENTRY)&_ZN6S494C53v67Ev,
  (VTBL_ENTRY)&_ZN6S494C53v68Ev,
  (VTBL_ENTRY)&_ZN6S494C53v69Ev,
  (VTBL_ENTRY)&_ZN6S494C53v70Ev,
  (VTBL_ENTRY)&_ZN6S494C53v71Ev,
  (VTBL_ENTRY)&_ZN6S494C53v72Ev,
  (VTBL_ENTRY)&_ZN6S494C53v73Ev,
  (VTBL_ENTRY)&_ZN6S494C53v74Ev,
  (VTBL_ENTRY)&_ZN6S494C53v75Ev,
  (VTBL_ENTRY)&_ZN6S494C53v76Ev,
  (VTBL_ENTRY)&_ZN6S494C53v77Ev,
  (VTBL_ENTRY)&_ZN6S494C53v78Ev,
  (VTBL_ENTRY)&_ZN6S494C53v79Ev,
  (VTBL_ENTRY)&_ZN6S494C53v80Ev,
  (VTBL_ENTRY)&_ZN6S494C43v81Ev,
  (VTBL_ENTRY)&_ZN6S494C43v82Ev,
  (VTBL_ENTRY)&_ZN6S494C43v83Ev,
  (VTBL_ENTRY)&_ZN6S494C43v84Ev,
  (VTBL_ENTRY)&_ZN6S494C43v85Ev,
  (VTBL_ENTRY)&_ZN6S494C33v86Ev,
  (VTBL_ENTRY)&_ZN6S494C33v87Ev,
  (VTBL_ENTRY)&_ZN6S494C33v88Ev,
  (VTBL_ENTRY)&_ZN6S494C33v89Ev,
  (VTBL_ENTRY)&_ZN6S494C33v90Ev,
  (VTBL_ENTRY)&_ZN6S494C33v91Ev,
  (VTBL_ENTRY)&_ZN6S494C33v92Ev,
  (VTBL_ENTRY)&_ZN6S494C33v93Ev,
  (VTBL_ENTRY)&_ZN6S494C33v94Ev,
  (VTBL_ENTRY)&_ZN6S494C33v95Ev,
  (VTBL_ENTRY)&_ZN6S494C33v96Ev,
  (VTBL_ENTRY)&_ZN6S494C33v97Ev,
  (VTBL_ENTRY)&_ZN6S494C33v98Ev,
  (VTBL_ENTRY)&_ZN6S494C33v99Ev,
  (VTBL_ENTRY)&_ZN6S494C34v100Ev,
  (VTBL_ENTRY)&_ZN6S494C34v101Ev,
  (VTBL_ENTRY)&_ZN6S494C34v102Ev,
  (VTBL_ENTRY)&_ZN6S494C34v103Ev,
  (VTBL_ENTRY)&_ZN6S494C34v104Ev,
  (VTBL_ENTRY)&_ZN6S494C34v105Ev,
  (VTBL_ENTRY)&_ZN6S494C34v106Ev,
  (VTBL_ENTRY)&_ZN6S494C34v107Ev,
  (VTBL_ENTRY)&_ZN6S494C24v108Ev,
  (VTBL_ENTRY)&_ZN6S494C24v109Ev,
  (VTBL_ENTRY)&_ZN6S494C24v110Ev,
  (VTBL_ENTRY)&_ZN6S494C24v111Ev,
  (VTBL_ENTRY)&_ZN6S494C24v112Ev,
  (VTBL_ENTRY)&_ZN6S494C24v113Ev,
  (VTBL_ENTRY)&_ZN6S494C24v114Ev,
  (VTBL_ENTRY)&_ZN6S494C24v115Ev,
  (VTBL_ENTRY)&_ZN6S494C24v116Ev,
  (VTBL_ENTRY)&_ZN6S494C24v117Ev,
  (VTBL_ENTRY)&_ZN6S494C24v118Ev,
  (VTBL_ENTRY)&_ZN6S494C24v119Ev,
  (VTBL_ENTRY)&_ZN6S494C24v120Ev,
  (VTBL_ENTRY)&_ZN6S494C24v121Ev,
  (VTBL_ENTRY)&_ZN6S494C24v122Ev,
  (VTBL_ENTRY)&_ZN6S494C24v123Ev,
  (VTBL_ENTRY)&_ZN6S494C24v124Ev,
  (VTBL_ENTRY)&_ZN6S494C24v125Ev,
  (VTBL_ENTRY)&_ZN6S494C24v126Ev,
  (VTBL_ENTRY)&_ZN6S494C24v127Ev,
  (VTBL_ENTRY)&_ZN6S494C24v128Ev,
  (VTBL_ENTRY)&_ZN6S494C24v129Ev,
  (VTBL_ENTRY)&_ZN6S494C24v130Ev,
  (VTBL_ENTRY)&_ZN6S494C24v131Ev,
  (VTBL_ENTRY)&_ZN6S494C24v132Ev,
  (VTBL_ENTRY)&_ZN6S494C24v133Ev,
  (VTBL_ENTRY)&_ZN6S494C24v134Ev,
  (VTBL_ENTRY)&_ZN6S494C24v135Ev,
  (VTBL_ENTRY)&_ZN6S494C24v136Ev,
  (VTBL_ENTRY)&_ZN6S494C24v137Ev,
  (VTBL_ENTRY)&_ZN6S494C24v138Ev,
  (VTBL_ENTRY)&_ZN6S494C24v139Ev,
  (VTBL_ENTRY)&_ZN6S494C24v140Ev,
  (VTBL_ENTRY)&_ZN6S494C24v141Ev,
  (VTBL_ENTRY)&_ZN6S494C24v142Ev,
  (VTBL_ENTRY)&_ZN6S494C24v143Ev,
  (VTBL_ENTRY)&_ZN6S494C24v144Ev,
  (VTBL_ENTRY)&_ZN6S494C24v145Ev,
  (VTBL_ENTRY)&_ZN6S494C24v146Ev,
  (VTBL_ENTRY)&_ZN6S494C24v147Ev,
  (VTBL_ENTRY)&_ZN6S494C24v148Ev,
  (VTBL_ENTRY)&_ZN6S494C24v149Ev,
  (VTBL_ENTRY)&_ZN6S494C24v150Ev,
  (VTBL_ENTRY)&_ZN6S494C24v151Ev,
  (VTBL_ENTRY)&_ZN6S494C24v152Ev,
  (VTBL_ENTRY)&_ZN6S494C24v153Ev,
  (VTBL_ENTRY)&_ZN6S494C24v154Ev,
  (VTBL_ENTRY)&_ZN6S494C24v155Ev,
  (VTBL_ENTRY)&_ZN6S494C24v156Ev,
  (VTBL_ENTRY)&_ZN6S494C24v157Ev,
  (VTBL_ENTRY)&_ZN6S494C24v158Ev,
  (VTBL_ENTRY)&_ZN6S494C24v159Ev,
  (VTBL_ENTRY)&_ZN6S494C24v160Ev,
  (VTBL_ENTRY)&_ZN6S494C24v161Ev,
  (VTBL_ENTRY)&_ZN6S494C24v162Ev,
  (VTBL_ENTRY)&_ZN6S494C24v163Ev,
  (VTBL_ENTRY)&_ZN6S494C24v164Ev,
  (VTBL_ENTRY)&_ZN6S494C24v165Ev,
  (VTBL_ENTRY)&_ZN6S494C24v166Ev,
  (VTBL_ENTRY)&_ZN6S494C24v167Ev,
  (VTBL_ENTRY)&_ZN6S494C24v168Ev,
  (VTBL_ENTRY)&_ZN6S494C12v1Ev,
  (VTBL_ENTRY)&_ZN6S494C12v2Ev,
  (VTBL_ENTRY)&_ZN6S494C12v3Ev,
  (VTBL_ENTRY)&_ZN6S494C12v4Ev,
  (VTBL_ENTRY)&_ZN6S494C12v5Ev,
  (VTBL_ENTRY)&_ZN6S494C12v6Ev,
  (VTBL_ENTRY)&_ZN6S494C12v7Ev,
  (VTBL_ENTRY)&_ZN6S494C12v8Ev,
  (VTBL_ENTRY)&_ZN6S494C12v9Ev,
  (VTBL_ENTRY)&_ZN6S494C13v10Ev,
  (VTBL_ENTRY)&_ZN6S494C13v11Ev,
  (VTBL_ENTRY)&_ZN6S494C13v12Ev,
  (VTBL_ENTRY)&_ZN6S494C13v13Ev,
  (VTBL_ENTRY)&_ZN6S494C13v14Ev,
  (VTBL_ENTRY)&_ZN6S494C13v15Ev,
  (VTBL_ENTRY)&_ZN6S494C13v16Ev,
  ABISELECT(-368,-272),
  (VTBL_ENTRY)&(_ZTI6S494C1[0]),
  (VTBL_ENTRY)&_ZN7S494C184v169Ev,
  (VTBL_ENTRY)&_ZN7S494C184v170Ev,
  (VTBL_ENTRY)&_ZN7S494C184v171Ev,
  (VTBL_ENTRY)&_ZN7S494C184v172Ev,
  (VTBL_ENTRY)&_ZN7S494C184v173Ev,
  (VTBL_ENTRY)&_ZN7S494C184v174Ev,
  (VTBL_ENTRY)&_ZN7S494C184v175Ev,
  (VTBL_ENTRY)&_ZN7S494C184v176Ev,
};
extern VTBL_ENTRY _ZTI6S494C1[];
extern  VTBL_ENTRY _ZTV6S494C1[];
Class_Descriptor cd_S494C1 = {  "S494C1", // class name
  bases_S494C1, 5,
  &(vtc_S494C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(408,296), // object size
  NSPAIRA(_ZTI6S494C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S494C1),182, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S495C5  {
  int s495c5f0;
  __tsi64 s495c5f1;
  void *s495c5f2[4];
  int s495c5f3[2];
  void *s495c5f4;
  ::S95C8_nt s495c5f5;
  void *s495c5f6[2];
  virtual  ~S495C5(); // _ZN6S495C5D1Ev
  virtual void  v17(); // _ZN6S495C53v17Ev
  virtual void  v18(); // _ZN6S495C53v18Ev
  virtual void  v19(); // _ZN6S495C53v19Ev
  virtual void  v20(); // _ZN6S495C53v20Ev
  virtual void  v21(); // _ZN6S495C53v21Ev
  virtual void  v22(); // _ZN6S495C53v22Ev
  virtual void  v23(); // _ZN6S495C53v23Ev
  virtual void  v24(); // _ZN6S495C53v24Ev
  virtual void  v25(); // _ZN6S495C53v25Ev
  virtual void  v26(); // _ZN6S495C53v26Ev
  virtual void  v27(); // _ZN6S495C53v27Ev
  virtual void  v28(); // _ZN6S495C53v28Ev
  virtual void  v29(); // _ZN6S495C53v29Ev
  virtual void  v30(); // _ZN6S495C53v30Ev
  virtual void  v31(); // _ZN6S495C53v31Ev
  virtual void  v32(); // _ZN6S495C53v32Ev
  virtual void  v33(); // _ZN6S495C53v33Ev
  virtual void  v34(); // _ZN6S495C53v34Ev
  virtual void  v35(); // _ZN6S495C53v35Ev
  virtual void  v36(); // _ZN6S495C53v36Ev
  virtual void  v37(); // _ZN6S495C53v37Ev
  virtual void  v38(); // _ZN6S495C53v38Ev
  virtual void  v39(); // _ZN6S495C53v39Ev
  virtual void  v40(); // _ZN6S495C53v40Ev
  virtual void  v41(); // _ZN6S495C53v41Ev
  virtual void  v42(); // _ZN6S495C53v42Ev
  virtual void  v43(); // _ZN6S495C53v43Ev
  virtual void  v44(); // _ZN6S495C53v44Ev
  virtual void  v45(); // _ZN6S495C53v45Ev
  virtual void  v46(); // _ZN6S495C53v46Ev
  virtual void  v47(); // _ZN6S495C53v47Ev
  virtual void  v48(); // _ZN6S495C53v48Ev
  virtual void  v49(); // _ZN6S495C53v49Ev
  virtual void  v50(); // _ZN6S495C53v50Ev
  virtual void  v51(); // _ZN6S495C53v51Ev
  virtual void  v52(); // _ZN6S495C53v52Ev
  virtual void  v53(); // _ZN6S495C53v53Ev
  virtual void  v54(); // _ZN6S495C53v54Ev
  virtual void  v55(); // _ZN6S495C53v55Ev
  virtual void  v56(); // _ZN6S495C53v56Ev
  virtual void  v57(); // _ZN6S495C53v57Ev
  virtual void  v58(); // _ZN6S495C53v58Ev
  virtual void  v59(); // _ZN6S495C53v59Ev
  virtual void  v60(); // _ZN6S495C53v60Ev
  virtual void  v61(); // _ZN6S495C53v61Ev
  virtual void  v62(); // _ZN6S495C53v62Ev
  virtual void  v63(); // _ZN6S495C53v63Ev
  virtual void  v64(); // _ZN6S495C53v64Ev
  virtual void  v65(); // _ZN6S495C53v65Ev
  virtual void  v66(); // _ZN6S495C53v66Ev
  virtual void  v67(); // _ZN6S495C53v67Ev
  virtual void  v68(); // _ZN6S495C53v68Ev
  virtual void  v69(); // _ZN6S495C53v69Ev
  virtual void  v70(); // _ZN6S495C53v70Ev
  virtual void  v71(); // _ZN6S495C53v71Ev
  virtual void  v72(); // _ZN6S495C53v72Ev
  virtual void  v73(); // _ZN6S495C53v73Ev
  virtual void  v74(); // _ZN6S495C53v74Ev
  virtual void  v75(); // _ZN6S495C53v75Ev
  virtual void  v76(); // _ZN6S495C53v76Ev
  virtual void  v77(); // _ZN6S495C53v77Ev
  virtual void  v78(); // _ZN6S495C53v78Ev
  virtual void  v79(); // _ZN6S495C53v79Ev
  virtual void  v80(); // _ZN6S495C53v80Ev
  S495C5(); // tgen
};
//SIG(-1 S495C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S495C5 ::~S495C5(){ note_dtor("S495C5", this);}
void  S495C5 ::v17(){vfunc_called(this, "_ZN6S495C53v17Ev");}
void  S495C5 ::v18(){vfunc_called(this, "_ZN6S495C53v18Ev");}
void  S495C5 ::v19(){vfunc_called(this, "_ZN6S495C53v19Ev");}
void  S495C5 ::v20(){vfunc_called(this, "_ZN6S495C53v20Ev");}
void  S495C5 ::v21(){vfunc_called(this, "_ZN6S495C53v21Ev");}
void  S495C5 ::v22(){vfunc_called(this, "_ZN6S495C53v22Ev");}
void  S495C5 ::v23(){vfunc_called(this, "_ZN6S495C53v23Ev");}
void  S495C5 ::v24(){vfunc_called(this, "_ZN6S495C53v24Ev");}
void  S495C5 ::v25(){vfunc_called(this, "_ZN6S495C53v25Ev");}
void  S495C5 ::v26(){vfunc_called(this, "_ZN6S495C53v26Ev");}
void  S495C5 ::v27(){vfunc_called(this, "_ZN6S495C53v27Ev");}
void  S495C5 ::v28(){vfunc_called(this, "_ZN6S495C53v28Ev");}
void  S495C5 ::v29(){vfunc_called(this, "_ZN6S495C53v29Ev");}
void  S495C5 ::v30(){vfunc_called(this, "_ZN6S495C53v30Ev");}
void  S495C5 ::v31(){vfunc_called(this, "_ZN6S495C53v31Ev");}
void  S495C5 ::v32(){vfunc_called(this, "_ZN6S495C53v32Ev");}
void  S495C5 ::v33(){vfunc_called(this, "_ZN6S495C53v33Ev");}
void  S495C5 ::v34(){vfunc_called(this, "_ZN6S495C53v34Ev");}
void  S495C5 ::v35(){vfunc_called(this, "_ZN6S495C53v35Ev");}
void  S495C5 ::v36(){vfunc_called(this, "_ZN6S495C53v36Ev");}
void  S495C5 ::v37(){vfunc_called(this, "_ZN6S495C53v37Ev");}
void  S495C5 ::v38(){vfunc_called(this, "_ZN6S495C53v38Ev");}
void  S495C5 ::v39(){vfunc_called(this, "_ZN6S495C53v39Ev");}
void  S495C5 ::v40(){vfunc_called(this, "_ZN6S495C53v40Ev");}
void  S495C5 ::v41(){vfunc_called(this, "_ZN6S495C53v41Ev");}
void  S495C5 ::v42(){vfunc_called(this, "_ZN6S495C53v42Ev");}
void  S495C5 ::v43(){vfunc_called(this, "_ZN6S495C53v43Ev");}
void  S495C5 ::v44(){vfunc_called(this, "_ZN6S495C53v44Ev");}
void  S495C5 ::v45(){vfunc_called(this, "_ZN6S495C53v45Ev");}
void  S495C5 ::v46(){vfunc_called(this, "_ZN6S495C53v46Ev");}
void  S495C5 ::v47(){vfunc_called(this, "_ZN6S495C53v47Ev");}
void  S495C5 ::v48(){vfunc_called(this, "_ZN6S495C53v48Ev");}
void  S495C5 ::v49(){vfunc_called(this, "_ZN6S495C53v49Ev");}
void  S495C5 ::v50(){vfunc_called(this, "_ZN6S495C53v50Ev");}
void  S495C5 ::v51(){vfunc_called(this, "_ZN6S495C53v51Ev");}
void  S495C5 ::v52(){vfunc_called(this, "_ZN6S495C53v52Ev");}
void  S495C5 ::v53(){vfunc_called(this, "_ZN6S495C53v53Ev");}
void  S495C5 ::v54(){vfunc_called(this, "_ZN6S495C53v54Ev");}
void  S495C5 ::v55(){vfunc_called(this, "_ZN6S495C53v55Ev");}
void  S495C5 ::v56(){vfunc_called(this, "_ZN6S495C53v56Ev");}
void  S495C5 ::v57(){vfunc_called(this, "_ZN6S495C53v57Ev");}
void  S495C5 ::v58(){vfunc_called(this, "_ZN6S495C53v58Ev");}
void  S495C5 ::v59(){vfunc_called(this, "_ZN6S495C53v59Ev");}
void  S495C5 ::v60(){vfunc_called(this, "_ZN6S495C53v60Ev");}
void  S495C5 ::v61(){vfunc_called(this, "_ZN6S495C53v61Ev");}
void  S495C5 ::v62(){vfunc_called(this, "_ZN6S495C53v62Ev");}
void  S495C5 ::v63(){vfunc_called(this, "_ZN6S495C53v63Ev");}
void  S495C5 ::v64(){vfunc_called(this, "_ZN6S495C53v64Ev");}
void  S495C5 ::v65(){vfunc_called(this, "_ZN6S495C53v65Ev");}
void  S495C5 ::v66(){vfunc_called(this, "_ZN6S495C53v66Ev");}
void  S495C5 ::v67(){vfunc_called(this, "_ZN6S495C53v67Ev");}
void  S495C5 ::v68(){vfunc_called(this, "_ZN6S495C53v68Ev");}
void  S495C5 ::v69(){vfunc_called(this, "_ZN6S495C53v69Ev");}
void  S495C5 ::v70(){vfunc_called(this, "_ZN6S495C53v70Ev");}
void  S495C5 ::v71(){vfunc_called(this, "_ZN6S495C53v71Ev");}
void  S495C5 ::v72(){vfunc_called(this, "_ZN6S495C53v72Ev");}
void  S495C5 ::v73(){vfunc_called(this, "_ZN6S495C53v73Ev");}
void  S495C5 ::v74(){vfunc_called(this, "_ZN6S495C53v74Ev");}
void  S495C5 ::v75(){vfunc_called(this, "_ZN6S495C53v75Ev");}
void  S495C5 ::v76(){vfunc_called(this, "_ZN6S495C53v76Ev");}
void  S495C5 ::v77(){vfunc_called(this, "_ZN6S495C53v77Ev");}
void  S495C5 ::v78(){vfunc_called(this, "_ZN6S495C53v78Ev");}
void  S495C5 ::v79(){vfunc_called(this, "_ZN6S495C53v79Ev");}
void  S495C5 ::v80(){vfunc_called(this, "_ZN6S495C53v80Ev");}
S495C5 ::S495C5(){ note_ctor("S495C5", this);} // tgen

static void Test_S495C5()
{
  extern Class_Descriptor cd_S495C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S495C5, buf);
    S495C5 *dp, &lv = *(dp=new (buf) S495C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S495C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S495C5)");
    check_field_offset(lv, s495c5f0, ABISELECT(8,4), "S495C5.s495c5f0");
    check_field_offset(lv, s495c5f1, ABISELECT(16,8), "S495C5.s495c5f1");
    check_field_offset(lv, s495c5f2, ABISELECT(24,16), "S495C5.s495c5f2");
    check_field_offset(lv, s495c5f3, ABISELECT(56,32), "S495C5.s495c5f3");
    check_field_offset(lv, s495c5f4, ABISELECT(64,40), "S495C5.s495c5f4");
    check_field_offset(lv, s495c5f5, ABISELECT(72,44), "S495C5.s495c5f5");
    check_field_offset(lv, s495c5f6, ABISELECT(80,52), "S495C5.s495c5f6");
    test_class_info(&lv, &cd_S495C5);
    dp->~S495C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS495C5(Test_S495C5, "S495C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S495C5C1Ev();
extern void _ZN6S495C5D1Ev();
Name_Map name_map_S495C5[] = {
  NSPAIR(_ZN6S495C5C1Ev),
  NSPAIR(_ZN6S495C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S495C5[];
extern void _ZN6S495C5D1Ev();
extern void _ZN6S495C5D0Ev();
extern void _ZN6S495C53v17Ev();
extern void _ZN6S495C53v18Ev();
extern void _ZN6S495C53v19Ev();
extern void _ZN6S495C53v20Ev();
extern void _ZN6S495C53v21Ev();
extern void _ZN6S495C53v22Ev();
extern void _ZN6S495C53v23Ev();
extern void _ZN6S495C53v24Ev();
extern void _ZN6S495C53v25Ev();
extern void _ZN6S495C53v26Ev();
extern void _ZN6S495C53v27Ev();
extern void _ZN6S495C53v28Ev();
extern void _ZN6S495C53v29Ev();
extern void _ZN6S495C53v30Ev();
extern void _ZN6S495C53v31Ev();
extern void _ZN6S495C53v32Ev();
extern void _ZN6S495C53v33Ev();
extern void _ZN6S495C53v34Ev();
extern void _ZN6S495C53v35Ev();
extern void _ZN6S495C53v36Ev();
extern void _ZN6S495C53v37Ev();
extern void _ZN6S495C53v38Ev();
extern void _ZN6S495C53v39Ev();
extern void _ZN6S495C53v40Ev();
extern void _ZN6S495C53v41Ev();
extern void _ZN6S495C53v42Ev();
extern void _ZN6S495C53v43Ev();
extern void _ZN6S495C53v44Ev();
extern void _ZN6S495C53v45Ev();
extern void _ZN6S495C53v46Ev();
extern void _ZN6S495C53v47Ev();
extern void _ZN6S495C53v48Ev();
extern void _ZN6S495C53v49Ev();
extern void _ZN6S495C53v50Ev();
extern void _ZN6S495C53v51Ev();
extern void _ZN6S495C53v52Ev();
extern void _ZN6S495C53v53Ev();
extern void _ZN6S495C53v54Ev();
extern void _ZN6S495C53v55Ev();
extern void _ZN6S495C53v56Ev();
extern void _ZN6S495C53v57Ev();
extern void _ZN6S495C53v58Ev();
extern void _ZN6S495C53v59Ev();
extern void _ZN6S495C53v60Ev();
extern void _ZN6S495C53v61Ev();
extern void _ZN6S495C53v62Ev();
extern void _ZN6S495C53v63Ev();
extern void _ZN6S495C53v64Ev();
extern void _ZN6S495C53v65Ev();
extern void _ZN6S495C53v66Ev();
extern void _ZN6S495C53v67Ev();
extern void _ZN6S495C53v68Ev();
extern void _ZN6S495C53v69Ev();
extern void _ZN6S495C53v70Ev();
extern void _ZN6S495C53v71Ev();
extern void _ZN6S495C53v72Ev();
extern void _ZN6S495C53v73Ev();
extern void _ZN6S495C53v74Ev();
extern void _ZN6S495C53v75Ev();
extern void _ZN6S495C53v76Ev();
extern void _ZN6S495C53v77Ev();
extern void _ZN6S495C53v78Ev();
extern void _ZN6S495C53v79Ev();
extern void _ZN6S495C53v80Ev();
static  VTBL_ENTRY vtc_S495C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S495C5[0]),
  (VTBL_ENTRY)&_ZN6S495C5D1Ev,
  (VTBL_ENTRY)&_ZN6S495C5D0Ev,
  (VTBL_ENTRY)&_ZN6S495C53v17Ev,
  (VTBL_ENTRY)&_ZN6S495C53v18Ev,
  (VTBL_ENTRY)&_ZN6S495C53v19Ev,
  (VTBL_ENTRY)&_ZN6S495C53v20Ev,
  (VTBL_ENTRY)&_ZN6S495C53v21Ev,
  (VTBL_ENTRY)&_ZN6S495C53v22Ev,
  (VTBL_ENTRY)&_ZN6S495C53v23Ev,
  (VTBL_ENTRY)&_ZN6S495C53v24Ev,
  (VTBL_ENTRY)&_ZN6S495C53v25Ev,
  (VTBL_ENTRY)&_ZN6S495C53v26Ev,
  (VTBL_ENTRY)&_ZN6S495C53v27Ev,
  (VTBL_ENTRY)&_ZN6S495C53v28Ev,
  (VTBL_ENTRY)&_ZN6S495C53v29Ev,
  (VTBL_ENTRY)&_ZN6S495C53v30Ev,
  (VTBL_ENTRY)&_ZN6S495C53v31Ev,
  (VTBL_ENTRY)&_ZN6S495C53v32Ev,
  (VTBL_ENTRY)&_ZN6S495C53v33Ev,
  (VTBL_ENTRY)&_ZN6S495C53v34Ev,
  (VTBL_ENTRY)&_ZN6S495C53v35Ev,
  (VTBL_ENTRY)&_ZN6S495C53v36Ev,
  (VTBL_ENTRY)&_ZN6S495C53v37Ev,
  (VTBL_ENTRY)&_ZN6S495C53v38Ev,
  (VTBL_ENTRY)&_ZN6S495C53v39Ev,
  (VTBL_ENTRY)&_ZN6S495C53v40Ev,
  (VTBL_ENTRY)&_ZN6S495C53v41Ev,
  (VTBL_ENTRY)&_ZN6S495C53v42Ev,
  (VTBL_ENTRY)&_ZN6S495C53v43Ev,
  (VTBL_ENTRY)&_ZN6S495C53v44Ev,
  (VTBL_ENTRY)&_ZN6S495C53v45Ev,
  (VTBL_ENTRY)&_ZN6S495C53v46Ev,
  (VTBL_ENTRY)&_ZN6S495C53v47Ev,
  (VTBL_ENTRY)&_ZN6S495C53v48Ev,
  (VTBL_ENTRY)&_ZN6S495C53v49Ev,
  (VTBL_ENTRY)&_ZN6S495C53v50Ev,
  (VTBL_ENTRY)&_ZN6S495C53v51Ev,
  (VTBL_ENTRY)&_ZN6S495C53v52Ev,
  (VTBL_ENTRY)&_ZN6S495C53v53Ev,
  (VTBL_ENTRY)&_ZN6S495C53v54Ev,
  (VTBL_ENTRY)&_ZN6S495C53v55Ev,
  (VTBL_ENTRY)&_ZN6S495C53v56Ev,
  (VTBL_ENTRY)&_ZN6S495C53v57Ev,
  (VTBL_ENTRY)&_ZN6S495C53v58Ev,
  (VTBL_ENTRY)&_ZN6S495C53v59Ev,
  (VTBL_ENTRY)&_ZN6S495C53v60Ev,
  (VTBL_ENTRY)&_ZN6S495C53v61Ev,
  (VTBL_ENTRY)&_ZN6S495C53v62Ev,
  (VTBL_ENTRY)&_ZN6S495C53v63Ev,
  (VTBL_ENTRY)&_ZN6S495C53v64Ev,
  (VTBL_ENTRY)&_ZN6S495C53v65Ev,
  (VTBL_ENTRY)&_ZN6S495C53v66Ev,
  (VTBL_ENTRY)&_ZN6S495C53v67Ev,
  (VTBL_ENTRY)&_ZN6S495C53v68Ev,
  (VTBL_ENTRY)&_ZN6S495C53v69Ev,
  (VTBL_ENTRY)&_ZN6S495C53v70Ev,
  (VTBL_ENTRY)&_ZN6S495C53v71Ev,
  (VTBL_ENTRY)&_ZN6S495C53v72Ev,
  (VTBL_ENTRY)&_ZN6S495C53v73Ev,
  (VTBL_ENTRY)&_ZN6S495C53v74Ev,
  (VTBL_ENTRY)&_ZN6S495C53v75Ev,
  (VTBL_ENTRY)&_ZN6S495C53v76Ev,
  (VTBL_ENTRY)&_ZN6S495C53v77Ev,
  (VTBL_ENTRY)&_ZN6S495C53v78Ev,
  (VTBL_ENTRY)&_ZN6S495C53v79Ev,
  (VTBL_ENTRY)&_ZN6S495C53v80Ev,
};
extern VTBL_ENTRY _ZTI6S495C5[];
extern  VTBL_ENTRY _ZTV6S495C5[];
Class_Descriptor cd_S495C5 = {  "S495C5", // class name
  0,0,//no base classes
  &(vtc_S495C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S495C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S495C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S495C4  : S495C5 {
  void *s495c4f0;
  ::S95C8_nt s495c4f1;
  virtual  ~S495C4(); // _ZN6S495C4D1Ev
  virtual void  v81(); // _ZN6S495C43v81Ev
  virtual void  v82(); // _ZN6S495C43v82Ev
  virtual void  v83(); // _ZN6S495C43v83Ev
  virtual void  v84(); // _ZN6S495C43v84Ev
  virtual void  v85(); // _ZN6S495C43v85Ev
  S495C4(); // tgen
};
//SIG(-1 S495C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S495C4 ::~S495C4(){ note_dtor("S495C4", this);}
void  S495C4 ::v81(){vfunc_called(this, "_ZN6S495C43v81Ev");}
void  S495C4 ::v82(){vfunc_called(this, "_ZN6S495C43v82Ev");}
void  S495C4 ::v83(){vfunc_called(this, "_ZN6S495C43v83Ev");}
void  S495C4 ::v84(){vfunc_called(this, "_ZN6S495C43v84Ev");}
void  S495C4 ::v85(){vfunc_called(this, "_ZN6S495C43v85Ev");}
S495C4 ::S495C4(){ note_ctor("S495C4", this);} // tgen

static void Test_S495C4()
{
  extern Class_Descriptor cd_S495C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S495C4, buf);
    S495C4 *dp, &lv = *(dp=new (buf) S495C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S495C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S495C4)");
    check_base_class_offset(lv, (S495C5*), 0, "S495C4");
    check_field_offset(lv, s495c4f0, ABISELECT(96,60), "S495C4.s495c4f0");
    check_field_offset(lv, s495c4f1, ABISELECT(104,64), "S495C4.s495c4f1");
    test_class_info(&lv, &cd_S495C4);
    dp->~S495C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS495C4(Test_S495C4, "S495C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S495C4C1Ev();
extern void _ZN6S495C4D1Ev();
Name_Map name_map_S495C4[] = {
  NSPAIR(_ZN6S495C4C1Ev),
  NSPAIR(_ZN6S495C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S495C5;
extern VTBL_ENTRY _ZTI6S495C5[];
extern  VTBL_ENTRY _ZTV6S495C5[];
static Base_Class bases_S495C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S495C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S495C4[];
extern void _ZN6S495C4D1Ev();
extern void _ZN6S495C4D0Ev();
extern void _ZN6S495C53v17Ev();
extern void _ZN6S495C53v18Ev();
extern void _ZN6S495C53v19Ev();
extern void _ZN6S495C53v20Ev();
extern void _ZN6S495C53v21Ev();
extern void _ZN6S495C53v22Ev();
extern void _ZN6S495C53v23Ev();
extern void _ZN6S495C53v24Ev();
extern void _ZN6S495C53v25Ev();
extern void _ZN6S495C53v26Ev();
extern void _ZN6S495C53v27Ev();
extern void _ZN6S495C53v28Ev();
extern void _ZN6S495C53v29Ev();
extern void _ZN6S495C53v30Ev();
extern void _ZN6S495C53v31Ev();
extern void _ZN6S495C53v32Ev();
extern void _ZN6S495C53v33Ev();
extern void _ZN6S495C53v34Ev();
extern void _ZN6S495C53v35Ev();
extern void _ZN6S495C53v36Ev();
extern void _ZN6S495C53v37Ev();
extern void _ZN6S495C53v38Ev();
extern void _ZN6S495C53v39Ev();
extern void _ZN6S495C53v40Ev();
extern void _ZN6S495C53v41Ev();
extern void _ZN6S495C53v42Ev();
extern void _ZN6S495C53v43Ev();
extern void _ZN6S495C53v44Ev();
extern void _ZN6S495C53v45Ev();
extern void _ZN6S495C53v46Ev();
extern void _ZN6S495C53v47Ev();
extern void _ZN6S495C53v48Ev();
extern void _ZN6S495C53v49Ev();
extern void _ZN6S495C53v50Ev();
extern void _ZN6S495C53v51Ev();
extern void _ZN6S495C53v52Ev();
extern void _ZN6S495C53v53Ev();
extern void _ZN6S495C53v54Ev();
extern void _ZN6S495C53v55Ev();
extern void _ZN6S495C53v56Ev();
extern void _ZN6S495C53v57Ev();
extern void _ZN6S495C53v58Ev();
extern void _ZN6S495C53v59Ev();
extern void _ZN6S495C53v60Ev();
extern void _ZN6S495C53v61Ev();
extern void _ZN6S495C53v62Ev();
extern void _ZN6S495C53v63Ev();
extern void _ZN6S495C53v64Ev();
extern void _ZN6S495C53v65Ev();
extern void _ZN6S495C53v66Ev();
extern void _ZN6S495C53v67Ev();
extern void _ZN6S495C53v68Ev();
extern void _ZN6S495C53v69Ev();
extern void _ZN6S495C53v70Ev();
extern void _ZN6S495C53v71Ev();
extern void _ZN6S495C53v72Ev();
extern void _ZN6S495C53v73Ev();
extern void _ZN6S495C53v74Ev();
extern void _ZN6S495C53v75Ev();
extern void _ZN6S495C53v76Ev();
extern void _ZN6S495C53v77Ev();
extern void _ZN6S495C53v78Ev();
extern void _ZN6S495C53v79Ev();
extern void _ZN6S495C53v80Ev();
extern void _ZN6S495C43v81Ev();
extern void _ZN6S495C43v82Ev();
extern void _ZN6S495C43v83Ev();
extern void _ZN6S495C43v84Ev();
extern void _ZN6S495C43v85Ev();
static  VTBL_ENTRY vtc_S495C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S495C4[0]),
  (VTBL_ENTRY)&_ZN6S495C4D1Ev,
  (VTBL_ENTRY)&_ZN6S495C4D0Ev,
  (VTBL_ENTRY)&_ZN6S495C53v17Ev,
  (VTBL_ENTRY)&_ZN6S495C53v18Ev,
  (VTBL_ENTRY)&_ZN6S495C53v19Ev,
  (VTBL_ENTRY)&_ZN6S495C53v20Ev,
  (VTBL_ENTRY)&_ZN6S495C53v21Ev,
  (VTBL_ENTRY)&_ZN6S495C53v22Ev,
  (VTBL_ENTRY)&_ZN6S495C53v23Ev,
  (VTBL_ENTRY)&_ZN6S495C53v24Ev,
  (VTBL_ENTRY)&_ZN6S495C53v25Ev,
  (VTBL_ENTRY)&_ZN6S495C53v26Ev,
  (VTBL_ENTRY)&_ZN6S495C53v27Ev,
  (VTBL_ENTRY)&_ZN6S495C53v28Ev,
  (VTBL_ENTRY)&_ZN6S495C53v29Ev,
  (VTBL_ENTRY)&_ZN6S495C53v30Ev,
  (VTBL_ENTRY)&_ZN6S495C53v31Ev,
  (VTBL_ENTRY)&_ZN6S495C53v32Ev,
  (VTBL_ENTRY)&_ZN6S495C53v33Ev,
  (VTBL_ENTRY)&_ZN6S495C53v34Ev,
  (VTBL_ENTRY)&_ZN6S495C53v35Ev,
  (VTBL_ENTRY)&_ZN6S495C53v36Ev,
  (VTBL_ENTRY)&_ZN6S495C53v37Ev,
  (VTBL_ENTRY)&_ZN6S495C53v38Ev,
  (VTBL_ENTRY)&_ZN6S495C53v39Ev,
  (VTBL_ENTRY)&_ZN6S495C53v40Ev,
  (VTBL_ENTRY)&_ZN6S495C53v41Ev,
  (VTBL_ENTRY)&_ZN6S495C53v42Ev,
  (VTBL_ENTRY)&_ZN6S495C53v43Ev,
  (VTBL_ENTRY)&_ZN6S495C53v44Ev,
  (VTBL_ENTRY)&_ZN6S495C53v45Ev,
  (VTBL_ENTRY)&_ZN6S495C53v46Ev,
  (VTBL_ENTRY)&_ZN6S495C53v47Ev,
  (VTBL_ENTRY)&_ZN6S495C53v48Ev,
  (VTBL_ENTRY)&_ZN6S495C53v49Ev,
  (VTBL_ENTRY)&_ZN6S495C53v50Ev,
  (VTBL_ENTRY)&_ZN6S495C53v51Ev,
  (VTBL_ENTRY)&_ZN6S495C53v52Ev,
  (VTBL_ENTRY)&_ZN6S495C53v53Ev,
  (VTBL_ENTRY)&_ZN6S495C53v54Ev,
  (VTBL_ENTRY)&_ZN6S495C53v55Ev,
  (VTBL_ENTRY)&_ZN6S495C53v56Ev,
  (VTBL_ENTRY)&_ZN6S495C53v57Ev,
  (VTBL_ENTRY)&_ZN6S495C53v58Ev,
  (VTBL_ENTRY)&_ZN6S495C53v59Ev,
  (VTBL_ENTRY)&_ZN6S495C53v60Ev,
  (VTBL_ENTRY)&_ZN6S495C53v61Ev,
  (VTBL_ENTRY)&_ZN6S495C53v62Ev,
  (VTBL_ENTRY)&_ZN6S495C53v63Ev,
  (VTBL_ENTRY)&_ZN6S495C53v64Ev,
  (VTBL_ENTRY)&_ZN6S495C53v65Ev,
  (VTBL_ENTRY)&_ZN6S495C53v66Ev,
  (VTBL_ENTRY)&_ZN6S495C53v67Ev,
  (VTBL_ENTRY)&_ZN6S495C53v68Ev,
  (VTBL_ENTRY)&_ZN6S495C53v69Ev,
  (VTBL_ENTRY)&_ZN6S495C53v70Ev,
  (VTBL_ENTRY)&_ZN6S495C53v71Ev,
  (VTBL_ENTRY)&_ZN6S495C53v72Ev,
  (VTBL_ENTRY)&_ZN6S495C53v73Ev,
  (VTBL_ENTRY)&_ZN6S495C53v74Ev,
  (VTBL_ENTRY)&_ZN6S495C53v75Ev,
  (VTBL_ENTRY)&_ZN6S495C53v76Ev,
  (VTBL_ENTRY)&_ZN6S495C53v77Ev,
  (VTBL_ENTRY)&_ZN6S495C53v78Ev,
  (VTBL_ENTRY)&_ZN6S495C53v79Ev,
  (VTBL_ENTRY)&_ZN6S495C53v80Ev,
  (VTBL_ENTRY)&_ZN6S495C43v81Ev,
  (VTBL_ENTRY)&_ZN6S495C43v82Ev,
  (VTBL_ENTRY)&_ZN6S495C43v83Ev,
  (VTBL_ENTRY)&_ZN6S495C43v84Ev,
  (VTBL_ENTRY)&_ZN6S495C43v85Ev,
};
extern VTBL_ENTRY _ZTI6S495C4[];
extern  VTBL_ENTRY _ZTV6S495C4[];
Class_Descriptor cd_S495C4 = {  "S495C4", // class name
  bases_S495C4, 1,
  &(vtc_S495C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S495C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S495C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S495C3  : S495C4 {
  void *s495c3f0[2];
  unsigned int s495c3f1:1;
  unsigned int s495c3f2:1;
  unsigned int s495c3f3:1;
  unsigned int s495c3f4:1;
  char s495c3f5;
  virtual  ~S495C3(); // _ZN6S495C3D1Ev
  virtual void  v86(); // _ZN6S495C33v86Ev
  virtual void  v87(); // _ZN6S495C33v87Ev
  virtual void  v88(); // _ZN6S495C33v88Ev
  virtual void  v89(); // _ZN6S495C33v89Ev
  virtual void  v90(); // _ZN6S495C33v90Ev
  virtual void  v91(); // _ZN6S495C33v91Ev
  virtual void  v92(); // _ZN6S495C33v92Ev
  virtual void  v93(); // _ZN6S495C33v93Ev
  virtual void  v94(); // _ZN6S495C33v94Ev
  virtual void  v95(); // _ZN6S495C33v95Ev
  virtual void  v96(); // _ZN6S495C33v96Ev
  virtual void  v97(); // _ZN6S495C33v97Ev
  virtual void  v98(); // _ZN6S495C33v98Ev
  virtual void  v99(); // _ZN6S495C33v99Ev
  virtual void  v100(); // _ZN6S495C34v100Ev
  virtual void  v101(); // _ZN6S495C34v101Ev
  virtual void  v102(); // _ZN6S495C34v102Ev
  virtual void  v103(); // _ZN6S495C34v103Ev
  virtual void  v104(); // _ZN6S495C34v104Ev
  virtual void  v105(); // _ZN6S495C34v105Ev
  virtual void  v106(); // _ZN6S495C34v106Ev
  virtual void  v107(); // _ZN6S495C34v107Ev
  S495C3(); // tgen
};
//SIG(-1 S495C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S495C3 ::~S495C3(){ note_dtor("S495C3", this);}
void  S495C3 ::v86(){vfunc_called(this, "_ZN6S495C33v86Ev");}
void  S495C3 ::v87(){vfunc_called(this, "_ZN6S495C33v87Ev");}
void  S495C3 ::v88(){vfunc_called(this, "_ZN6S495C33v88Ev");}
void  S495C3 ::v89(){vfunc_called(this, "_ZN6S495C33v89Ev");}
void  S495C3 ::v90(){vfunc_called(this, "_ZN6S495C33v90Ev");}
void  S495C3 ::v91(){vfunc_called(this, "_ZN6S495C33v91Ev");}
void  S495C3 ::v92(){vfunc_called(this, "_ZN6S495C33v92Ev");}
void  S495C3 ::v93(){vfunc_called(this, "_ZN6S495C33v93Ev");}
void  S495C3 ::v94(){vfunc_called(this, "_ZN6S495C33v94Ev");}
void  S495C3 ::v95(){vfunc_called(this, "_ZN6S495C33v95Ev");}
void  S495C3 ::v96(){vfunc_called(this, "_ZN6S495C33v96Ev");}
void  S495C3 ::v97(){vfunc_called(this, "_ZN6S495C33v97Ev");}
void  S495C3 ::v98(){vfunc_called(this, "_ZN6S495C33v98Ev");}
void  S495C3 ::v99(){vfunc_called(this, "_ZN6S495C33v99Ev");}
void  S495C3 ::v100(){vfunc_called(this, "_ZN6S495C34v100Ev");}
void  S495C3 ::v101(){vfunc_called(this, "_ZN6S495C34v101Ev");}
void  S495C3 ::v102(){vfunc_called(this, "_ZN6S495C34v102Ev");}
void  S495C3 ::v103(){vfunc_called(this, "_ZN6S495C34v103Ev");}
void  S495C3 ::v104(){vfunc_called(this, "_ZN6S495C34v104Ev");}
void  S495C3 ::v105(){vfunc_called(this, "_ZN6S495C34v105Ev");}
void  S495C3 ::v106(){vfunc_called(this, "_ZN6S495C34v106Ev");}
void  S495C3 ::v107(){vfunc_called(this, "_ZN6S495C34v107Ev");}
S495C3 ::S495C3(){ note_ctor("S495C3", this);} // tgen

static void Test_S495C3()
{
  extern Class_Descriptor cd_S495C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S495C3, buf);
    S495C3 *dp, &lv = *(dp=new (buf) S495C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S495C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S495C3)");
    check_base_class_offset(lv, (S495C5*)(S495C4*), 0, "S495C3");
    check_base_class_offset(lv, (S495C4*), 0, "S495C3");
    check_field_offset(lv, s495c3f0, ABISELECT(112,72), "S495C3.s495c3f0");
    set_bf_and_test(lv, s495c3f1, ABISELECT(128,80), 0, 1, 1, "S495C3");
    set_bf_and_test(lv, s495c3f2, ABISELECT(128,80), 1, 1, 1, "S495C3");
    set_bf_and_test(lv, s495c3f3, ABISELECT(128,80), 2, 1, 1, "S495C3");
    set_bf_and_test(lv, s495c3f4, ABISELECT(128,80), 3, 1, 1, "S495C3");
    check_field_offset(lv, s495c3f5, ABISELECT(129,81), "S495C3.s495c3f5");
    test_class_info(&lv, &cd_S495C3);
    dp->~S495C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS495C3(Test_S495C3, "S495C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S495C3C1Ev();
extern void _ZN6S495C3D1Ev();
Name_Map name_map_S495C3[] = {
  NSPAIR(_ZN6S495C3C1Ev),
  NSPAIR(_ZN6S495C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S495C5;
extern VTBL_ENTRY _ZTI6S495C5[];
extern  VTBL_ENTRY _ZTV6S495C5[];
extern Class_Descriptor cd_S495C4;
extern VTBL_ENTRY _ZTI6S495C4[];
extern  VTBL_ENTRY _ZTV6S495C4[];
static Base_Class bases_S495C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S495C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S495C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S495C3[];
extern void _ZN6S495C3D1Ev();
extern void _ZN6S495C3D0Ev();
extern void _ZN6S495C53v17Ev();
extern void _ZN6S495C53v18Ev();
extern void _ZN6S495C53v19Ev();
extern void _ZN6S495C53v20Ev();
extern void _ZN6S495C53v21Ev();
extern void _ZN6S495C53v22Ev();
extern void _ZN6S495C53v23Ev();
extern void _ZN6S495C53v24Ev();
extern void _ZN6S495C53v25Ev();
extern void _ZN6S495C53v26Ev();
extern void _ZN6S495C53v27Ev();
extern void _ZN6S495C53v28Ev();
extern void _ZN6S495C53v29Ev();
extern void _ZN6S495C53v30Ev();
extern void _ZN6S495C53v31Ev();
extern void _ZN6S495C53v32Ev();
extern void _ZN6S495C53v33Ev();
extern void _ZN6S495C53v34Ev();
extern void _ZN6S495C53v35Ev();
extern void _ZN6S495C53v36Ev();
extern void _ZN6S495C53v37Ev();
extern void _ZN6S495C53v38Ev();
extern void _ZN6S495C53v39Ev();
extern void _ZN6S495C53v40Ev();
extern void _ZN6S495C53v41Ev();
extern void _ZN6S495C53v42Ev();
extern void _ZN6S495C53v43Ev();
extern void _ZN6S495C53v44Ev();
extern void _ZN6S495C53v45Ev();
extern void _ZN6S495C53v46Ev();
extern void _ZN6S495C53v47Ev();
extern void _ZN6S495C53v48Ev();
extern void _ZN6S495C53v49Ev();
extern void _ZN6S495C53v50Ev();
extern void _ZN6S495C53v51Ev();
extern void _ZN6S495C53v52Ev();
extern void _ZN6S495C53v53Ev();
extern void _ZN6S495C53v54Ev();
extern void _ZN6S495C53v55Ev();
extern void _ZN6S495C53v56Ev();
extern void _ZN6S495C53v57Ev();
extern void _ZN6S495C53v58Ev();
extern void _ZN6S495C53v59Ev();
extern void _ZN6S495C53v60Ev();
extern void _ZN6S495C53v61Ev();
extern void _ZN6S495C53v62Ev();
extern void _ZN6S495C53v63Ev();
extern void _ZN6S495C53v64Ev();
extern void _ZN6S495C53v65Ev();
extern void _ZN6S495C53v66Ev();
extern void _ZN6S495C53v67Ev();
extern void _ZN6S495C53v68Ev();
extern void _ZN6S495C53v69Ev();
extern void _ZN6S495C53v70Ev();
extern void _ZN6S495C53v71Ev();
extern void _ZN6S495C53v72Ev();
extern void _ZN6S495C53v73Ev();
extern void _ZN6S495C53v74Ev();
extern void _ZN6S495C53v75Ev();
extern void _ZN6S495C53v76Ev();
extern void _ZN6S495C53v77Ev();
extern void _ZN6S495C53v78Ev();
extern void _ZN6S495C53v79Ev();
extern void _ZN6S495C53v80Ev();
extern void _ZN6S495C43v81Ev();
extern void _ZN6S495C43v82Ev();
extern void _ZN6S495C43v83Ev();
extern void _ZN6S495C43v84Ev();
extern void _ZN6S495C43v85Ev();
extern void _ZN6S495C33v86Ev();
extern void _ZN6S495C33v87Ev();
extern void _ZN6S495C33v88Ev();
extern void _ZN6S495C33v89Ev();
extern void _ZN6S495C33v90Ev();
extern void _ZN6S495C33v91Ev();
extern void _ZN6S495C33v92Ev();
extern void _ZN6S495C33v93Ev();
extern void _ZN6S495C33v94Ev();
extern void _ZN6S495C33v95Ev();
extern void _ZN6S495C33v96Ev();
extern void _ZN6S495C33v97Ev();
extern void _ZN6S495C33v98Ev();
extern void _ZN6S495C33v99Ev();
extern void _ZN6S495C34v100Ev();
extern void _ZN6S495C34v101Ev();
extern void _ZN6S495C34v102Ev();
extern void _ZN6S495C34v103Ev();
extern void _ZN6S495C34v104Ev();
extern void _ZN6S495C34v105Ev();
extern void _ZN6S495C34v106Ev();
extern void _ZN6S495C34v107Ev();
static  VTBL_ENTRY vtc_S495C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S495C3[0]),
  (VTBL_ENTRY)&_ZN6S495C3D1Ev,
  (VTBL_ENTRY)&_ZN6S495C3D0Ev,
  (VTBL_ENTRY)&_ZN6S495C53v17Ev,
  (VTBL_ENTRY)&_ZN6S495C53v18Ev,
  (VTBL_ENTRY)&_ZN6S495C53v19Ev,
  (VTBL_ENTRY)&_ZN6S495C53v20Ev,
  (VTBL_ENTRY)&_ZN6S495C53v21Ev,
  (VTBL_ENTRY)&_ZN6S495C53v22Ev,
  (VTBL_ENTRY)&_ZN6S495C53v23Ev,
  (VTBL_ENTRY)&_ZN6S495C53v24Ev,
  (VTBL_ENTRY)&_ZN6S495C53v25Ev,
  (VTBL_ENTRY)&_ZN6S495C53v26Ev,
  (VTBL_ENTRY)&_ZN6S495C53v27Ev,
  (VTBL_ENTRY)&_ZN6S495C53v28Ev,
  (VTBL_ENTRY)&_ZN6S495C53v29Ev,
  (VTBL_ENTRY)&_ZN6S495C53v30Ev,
  (VTBL_ENTRY)&_ZN6S495C53v31Ev,
  (VTBL_ENTRY)&_ZN6S495C53v32Ev,
  (VTBL_ENTRY)&_ZN6S495C53v33Ev,
  (VTBL_ENTRY)&_ZN6S495C53v34Ev,
  (VTBL_ENTRY)&_ZN6S495C53v35Ev,
  (VTBL_ENTRY)&_ZN6S495C53v36Ev,
  (VTBL_ENTRY)&_ZN6S495C53v37Ev,
  (VTBL_ENTRY)&_ZN6S495C53v38Ev,
  (VTBL_ENTRY)&_ZN6S495C53v39Ev,
  (VTBL_ENTRY)&_ZN6S495C53v40Ev,
  (VTBL_ENTRY)&_ZN6S495C53v41Ev,
  (VTBL_ENTRY)&_ZN6S495C53v42Ev,
  (VTBL_ENTRY)&_ZN6S495C53v43Ev,
  (VTBL_ENTRY)&_ZN6S495C53v44Ev,
  (VTBL_ENTRY)&_ZN6S495C53v45Ev,
  (VTBL_ENTRY)&_ZN6S495C53v46Ev,
  (VTBL_ENTRY)&_ZN6S495C53v47Ev,
  (VTBL_ENTRY)&_ZN6S495C53v48Ev,
  (VTBL_ENTRY)&_ZN6S495C53v49Ev,
  (VTBL_ENTRY)&_ZN6S495C53v50Ev,
  (VTBL_ENTRY)&_ZN6S495C53v51Ev,
  (VTBL_ENTRY)&_ZN6S495C53v52Ev,
  (VTBL_ENTRY)&_ZN6S495C53v53Ev,
  (VTBL_ENTRY)&_ZN6S495C53v54Ev,
  (VTBL_ENTRY)&_ZN6S495C53v55Ev,
  (VTBL_ENTRY)&_ZN6S495C53v56Ev,
  (VTBL_ENTRY)&_ZN6S495C53v57Ev,
  (VTBL_ENTRY)&_ZN6S495C53v58Ev,
  (VTBL_ENTRY)&_ZN6S495C53v59Ev,
  (VTBL_ENTRY)&_ZN6S495C53v60Ev,
  (VTBL_ENTRY)&_ZN6S495C53v61Ev,
  (VTBL_ENTRY)&_ZN6S495C53v62Ev,
  (VTBL_ENTRY)&_ZN6S495C53v63Ev,
  (VTBL_ENTRY)&_ZN6S495C53v64Ev,
  (VTBL_ENTRY)&_ZN6S495C53v65Ev,
  (VTBL_ENTRY)&_ZN6S495C53v66Ev,
  (VTBL_ENTRY)&_ZN6S495C53v67Ev,
  (VTBL_ENTRY)&_ZN6S495C53v68Ev,
  (VTBL_ENTRY)&_ZN6S495C53v69Ev,
  (VTBL_ENTRY)&_ZN6S495C53v70Ev,
  (VTBL_ENTRY)&_ZN6S495C53v71Ev,
  (VTBL_ENTRY)&_ZN6S495C53v72Ev,
  (VTBL_ENTRY)&_ZN6S495C53v73Ev,
  (VTBL_ENTRY)&_ZN6S495C53v74Ev,
  (VTBL_ENTRY)&_ZN6S495C53v75Ev,
  (VTBL_ENTRY)&_ZN6S495C53v76Ev,
  (VTBL_ENTRY)&_ZN6S495C53v77Ev,
  (VTBL_ENTRY)&_ZN6S495C53v78Ev,
  (VTBL_ENTRY)&_ZN6S495C53v79Ev,
  (VTBL_ENTRY)&_ZN6S495C53v80Ev,
  (VTBL_ENTRY)&_ZN6S495C43v81Ev,
  (VTBL_ENTRY)&_ZN6S495C43v82Ev,
  (VTBL_ENTRY)&_ZN6S495C43v83Ev,
  (VTBL_ENTRY)&_ZN6S495C43v84Ev,
  (VTBL_ENTRY)&_ZN6S495C43v85Ev,
  (VTBL_ENTRY)&_ZN6S495C33v86Ev,
  (VTBL_ENTRY)&_ZN6S495C33v87Ev,
  (VTBL_ENTRY)&_ZN6S495C33v88Ev,
  (VTBL_ENTRY)&_ZN6S495C33v89Ev,
  (VTBL_ENTRY)&_ZN6S495C33v90Ev,
  (VTBL_ENTRY)&_ZN6S495C33v91Ev,
  (VTBL_ENTRY)&_ZN6S495C33v92Ev,
  (VTBL_ENTRY)&_ZN6S495C33v93Ev,
  (VTBL_ENTRY)&_ZN6S495C33v94Ev,
  (VTBL_ENTRY)&_ZN6S495C33v95Ev,
  (VTBL_ENTRY)&_ZN6S495C33v96Ev,
  (VTBL_ENTRY)&_ZN6S495C33v97Ev,
  (VTBL_ENTRY)&_ZN6S495C33v98Ev,
  (VTBL_ENTRY)&_ZN6S495C33v99Ev,
  (VTBL_ENTRY)&_ZN6S495C34v100Ev,
  (VTBL_ENTRY)&_ZN6S495C34v101Ev,
  (VTBL_ENTRY)&_ZN6S495C34v102Ev,
  (VTBL_ENTRY)&_ZN6S495C34v103Ev,
  (VTBL_ENTRY)&_ZN6S495C34v104Ev,
  (VTBL_ENTRY)&_ZN6S495C34v105Ev,
  (VTBL_ENTRY)&_ZN6S495C34v106Ev,
  (VTBL_ENTRY)&_ZN6S495C34v107Ev,
};
extern VTBL_ENTRY _ZTI6S495C3[];
extern  VTBL_ENTRY _ZTV6S495C3[];
Class_Descriptor cd_S495C3 = {  "S495C3", // class name
  bases_S495C3, 2,
  &(vtc_S495C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S495C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S495C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S495C2  : S495C3 {
  void *s495c2f0;
  ::S95C9_nt s495c2f1;
  int s495c2f2;
  ::S236C15_nt s495c2f3;
  int s495c2f4;
  ::S490C27 s495c2f5;
  int s495c2f6;
  void *s495c2f7[2];
  ::S95C13 s495c2f8;
  void *s495c2f9;
  int s495c2f10[2];
  char s495c2f11[3];
  int s495c2f12;
  unsigned int s495c2f13:1;
  unsigned int s495c2f14:1;
  unsigned int s495c2f15:1;
  unsigned int s495c2f16:1;
  unsigned int s495c2f17:1;
  unsigned int s495c2f18:1;
  unsigned int s495c2f19:1;
  unsigned int s495c2f20:1;
  unsigned int s495c2f21:1;
  unsigned int s495c2f22:1;
  unsigned int s495c2f23:1;
  unsigned int s495c2f24:1;
  unsigned int s495c2f25:1;
  unsigned int s495c2f26:1;
  int s495c2f27;
  unsigned int s495c2f28:1;
  unsigned int s495c2f29:1;
  unsigned int s495c2f30:1;
  unsigned int s495c2f31:1;
  unsigned int s495c2f32:1;
  unsigned int s495c2f33:1;
  ::S112C22_nt s495c2f34;
  unsigned int s495c2f35:1;
  unsigned int s495c2f36:1;
  unsigned int s495c2f37:1;
  unsigned int s495c2f38:1;
  unsigned int s495c2f39:1;
  unsigned int s495c2f40:1;
  unsigned int s495c2f41:1;
  char s495c2f42;
  ::S95C16 s495c2f43;
  unsigned int s495c2f44:1;
  unsigned int s495c2f45:1;
  unsigned int s495c2f46:1;
  unsigned int s495c2f47:1;
  unsigned int s495c2f48:1;
  unsigned int s495c2f49:1;
  unsigned int s495c2f50:1;
  unsigned int s495c2f51:1;
  unsigned int s495c2f52:1;
  unsigned int s495c2f53:1;
  unsigned int s495c2f54:1;
  unsigned int s495c2f55:1;
  ::S490C26 s495c2f56;
  void *s495c2f57[2];
  char s495c2f58;
  ::S236C15_nt s495c2f59;
  ::S236C18_nt s495c2f60;
  ::S95C14_nt s495c2f61;
  int s495c2f62;
  ::S236C18_nt s495c2f63;
  unsigned int s495c2f64:1;
  unsigned int s495c2f65:1;
  unsigned int s495c2f66:1;
  int s495c2f67[3];
  virtual  ~S495C2(); // _ZN6S495C2D1Ev
  virtual void  v108(); // _ZN6S495C24v108Ev
  virtual void  v109(); // _ZN6S495C24v109Ev
  virtual void  v110(); // _ZN6S495C24v110Ev
  virtual void  v111(); // _ZN6S495C24v111Ev
  virtual void  v112(); // _ZN6S495C24v112Ev
  virtual void  v113(); // _ZN6S495C24v113Ev
  virtual void  v114(); // _ZN6S495C24v114Ev
  virtual void  v115(); // _ZN6S495C24v115Ev
  virtual void  v116(); // _ZN6S495C24v116Ev
  virtual void  v117(); // _ZN6S495C24v117Ev
  virtual void  v118(); // _ZN6S495C24v118Ev
  virtual void  v119(); // _ZN6S495C24v119Ev
  virtual void  v120(); // _ZN6S495C24v120Ev
  virtual void  v121(); // _ZN6S495C24v121Ev
  virtual void  v122(); // _ZN6S495C24v122Ev
  virtual void  v123(); // _ZN6S495C24v123Ev
  virtual void  v124(); // _ZN6S495C24v124Ev
  virtual void  v125(); // _ZN6S495C24v125Ev
  virtual void  v126(); // _ZN6S495C24v126Ev
  virtual void  v127(); // _ZN6S495C24v127Ev
  virtual void  v128(); // _ZN6S495C24v128Ev
  virtual void  v129(); // _ZN6S495C24v129Ev
  virtual void  v130(); // _ZN6S495C24v130Ev
  virtual void  v131(); // _ZN6S495C24v131Ev
  virtual void  v132(); // _ZN6S495C24v132Ev
  virtual void  v133(); // _ZN6S495C24v133Ev
  virtual void  v134(); // _ZN6S495C24v134Ev
  virtual void  v135(); // _ZN6S495C24v135Ev
  virtual void  v136(); // _ZN6S495C24v136Ev
  virtual void  v137(); // _ZN6S495C24v137Ev
  virtual void  v138(); // _ZN6S495C24v138Ev
  virtual void  v139(); // _ZN6S495C24v139Ev
  virtual void  v140(); // _ZN6S495C24v140Ev
  virtual void  v141(); // _ZN6S495C24v141Ev
  virtual void  v142(); // _ZN6S495C24v142Ev
  virtual void  v143(); // _ZN6S495C24v143Ev
  virtual void  v144(); // _ZN6S495C24v144Ev
  virtual void  v145(); // _ZN6S495C24v145Ev
  virtual void  v146(); // _ZN6S495C24v146Ev
  virtual void  v147(); // _ZN6S495C24v147Ev
  virtual void  v148(); // _ZN6S495C24v148Ev
  virtual void  v149(); // _ZN6S495C24v149Ev
  virtual void  v150(); // _ZN6S495C24v150Ev
  virtual void  v151(); // _ZN6S495C24v151Ev
  virtual void  v152(); // _ZN6S495C24v152Ev
  virtual void  v153(); // _ZN6S495C24v153Ev
  virtual void  v154(); // _ZN6S495C24v154Ev
  virtual void  v155(); // _ZN6S495C24v155Ev
  virtual void  v156(); // _ZN6S495C24v156Ev
  virtual void  v157(); // _ZN6S495C24v157Ev
  virtual void  v158(); // _ZN6S495C24v158Ev
  virtual void  v159(); // _ZN6S495C24v159Ev
  virtual void  v160(); // _ZN6S495C24v160Ev
  virtual void  v161(); // _ZN6S495C24v161Ev
  virtual void  v162(); // _ZN6S495C24v162Ev
  virtual void  v163(); // _ZN6S495C24v163Ev
  virtual void  v164(); // _ZN6S495C24v164Ev
  virtual void  v165(); // _ZN6S495C24v165Ev
  virtual void  v166(); // _ZN6S495C24v166Ev
  virtual void  v167(); // _ZN6S495C24v167Ev
  virtual void  v168(); // _ZN6S495C24v168Ev
  S495C2(); // tgen
};
//SIG(-1 S495C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S495C2 ::~S495C2(){ note_dtor("S495C2", this);}
void  S495C2 ::v108(){vfunc_called(this, "_ZN6S495C24v108Ev");}
void  S495C2 ::v109(){vfunc_called(this, "_ZN6S495C24v109Ev");}
void  S495C2 ::v110(){vfunc_called(this, "_ZN6S495C24v110Ev");}
void  S495C2 ::v111(){vfunc_called(this, "_ZN6S495C24v111Ev");}
void  S495C2 ::v112(){vfunc_called(this, "_ZN6S495C24v112Ev");}
void  S495C2 ::v113(){vfunc_called(this, "_ZN6S495C24v113Ev");}
void  S495C2 ::v114(){vfunc_called(this, "_ZN6S495C24v114Ev");}
void  S495C2 ::v115(){vfunc_called(this, "_ZN6S495C24v115Ev");}
void  S495C2 ::v116(){vfunc_called(this, "_ZN6S495C24v116Ev");}
void  S495C2 ::v117(){vfunc_called(this, "_ZN6S495C24v117Ev");}
void  S495C2 ::v118(){vfunc_called(this, "_ZN6S495C24v118Ev");}
void  S495C2 ::v119(){vfunc_called(this, "_ZN6S495C24v119Ev");}
void  S495C2 ::v120(){vfunc_called(this, "_ZN6S495C24v120Ev");}
void  S495C2 ::v121(){vfunc_called(this, "_ZN6S495C24v121Ev");}
void  S495C2 ::v122(){vfunc_called(this, "_ZN6S495C24v122Ev");}
void  S495C2 ::v123(){vfunc_called(this, "_ZN6S495C24v123Ev");}
void  S495C2 ::v124(){vfunc_called(this, "_ZN6S495C24v124Ev");}
void  S495C2 ::v125(){vfunc_called(this, "_ZN6S495C24v125Ev");}
void  S495C2 ::v126(){vfunc_called(this, "_ZN6S495C24v126Ev");}
void  S495C2 ::v127(){vfunc_called(this, "_ZN6S495C24v127Ev");}
void  S495C2 ::v128(){vfunc_called(this, "_ZN6S495C24v128Ev");}
void  S495C2 ::v129(){vfunc_called(this, "_ZN6S495C24v129Ev");}
void  S495C2 ::v130(){vfunc_called(this, "_ZN6S495C24v130Ev");}
void  S495C2 ::v131(){vfunc_called(this, "_ZN6S495C24v131Ev");}
void  S495C2 ::v132(){vfunc_called(this, "_ZN6S495C24v132Ev");}
void  S495C2 ::v133(){vfunc_called(this, "_ZN6S495C24v133Ev");}
void  S495C2 ::v134(){vfunc_called(this, "_ZN6S495C24v134Ev");}
void  S495C2 ::v135(){vfunc_called(this, "_ZN6S495C24v135Ev");}
void  S495C2 ::v136(){vfunc_called(this, "_ZN6S495C24v136Ev");}
void  S495C2 ::v137(){vfunc_called(this, "_ZN6S495C24v137Ev");}
void  S495C2 ::v138(){vfunc_called(this, "_ZN6S495C24v138Ev");}
void  S495C2 ::v139(){vfunc_called(this, "_ZN6S495C24v139Ev");}
void  S495C2 ::v140(){vfunc_called(this, "_ZN6S495C24v140Ev");}
void  S495C2 ::v141(){vfunc_called(this, "_ZN6S495C24v141Ev");}
void  S495C2 ::v142(){vfunc_called(this, "_ZN6S495C24v142Ev");}
void  S495C2 ::v143(){vfunc_called(this, "_ZN6S495C24v143Ev");}
void  S495C2 ::v144(){vfunc_called(this, "_ZN6S495C24v144Ev");}
void  S495C2 ::v145(){vfunc_called(this, "_ZN6S495C24v145Ev");}
void  S495C2 ::v146(){vfunc_called(this, "_ZN6S495C24v146Ev");}
void  S495C2 ::v147(){vfunc_called(this, "_ZN6S495C24v147Ev");}
void  S495C2 ::v148(){vfunc_called(this, "_ZN6S495C24v148Ev");}
void  S495C2 ::v149(){vfunc_called(this, "_ZN6S495C24v149Ev");}
void  S495C2 ::v150(){vfunc_called(this, "_ZN6S495C24v150Ev");}
void  S495C2 ::v151(){vfunc_called(this, "_ZN6S495C24v151Ev");}
void  S495C2 ::v152(){vfunc_called(this, "_ZN6S495C24v152Ev");}
void  S495C2 ::v153(){vfunc_called(this, "_ZN6S495C24v153Ev");}
void  S495C2 ::v154(){vfunc_called(this, "_ZN6S495C24v154Ev");}
void  S495C2 ::v155(){vfunc_called(this, "_ZN6S495C24v155Ev");}
void  S495C2 ::v156(){vfunc_called(this, "_ZN6S495C24v156Ev");}
void  S495C2 ::v157(){vfunc_called(this, "_ZN6S495C24v157Ev");}
void  S495C2 ::v158(){vfunc_called(this, "_ZN6S495C24v158Ev");}
void  S495C2 ::v159(){vfunc_called(this, "_ZN6S495C24v159Ev");}
void  S495C2 ::v160(){vfunc_called(this, "_ZN6S495C24v160Ev");}
void  S495C2 ::v161(){vfunc_called(this, "_ZN6S495C24v161Ev");}
void  S495C2 ::v162(){vfunc_called(this, "_ZN6S495C24v162Ev");}
void  S495C2 ::v163(){vfunc_called(this, "_ZN6S495C24v163Ev");}
void  S495C2 ::v164(){vfunc_called(this, "_ZN6S495C24v164Ev");}
void  S495C2 ::v165(){vfunc_called(this, "_ZN6S495C24v165Ev");}
void  S495C2 ::v166(){vfunc_called(this, "_ZN6S495C24v166Ev");}
void  S495C2 ::v167(){vfunc_called(this, "_ZN6S495C24v167Ev");}
void  S495C2 ::v168(){vfunc_called(this, "_ZN6S495C24v168Ev");}
S495C2 ::S495C2(){ note_ctor("S495C2", this);} // tgen

static void Test_S495C2()
{
  extern Class_Descriptor cd_S495C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S495C2, buf);
    S495C2 *dp, &lv = *(dp=new (buf) S495C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S495C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S495C2)");
    check_base_class_offset(lv, (S495C5*)(S495C4*)(S495C3*), 0, "S495C2");
    check_base_class_offset(lv, (S495C4*)(S495C3*), 0, "S495C2");
    check_base_class_offset(lv, (S495C3*), 0, "S495C2");
    check_field_offset(lv, s495c2f0, ABISELECT(136,84), "S495C2.s495c2f0");
    check_field_offset(lv, s495c2f1, ABISELECT(144,88), "S495C2.s495c2f1");
    check_field_offset(lv, s495c2f2, ABISELECT(148,92), "S495C2.s495c2f2");
    check_field_offset(lv, s495c2f3, ABISELECT(152,96), "S495C2.s495c2f3");
    check_field_offset(lv, s495c2f4, ABISELECT(156,100), "S495C2.s495c2f4");
    check_field_offset(lv, s495c2f5, ABISELECT(160,104), "S495C2.s495c2f5");
    check_field_offset(lv, s495c2f6, ABISELECT(176,116), "S495C2.s495c2f6");
    check_field_offset(lv, s495c2f7, ABISELECT(184,120), "S495C2.s495c2f7");
    check_field_offset(lv, s495c2f8, ABISELECT(200,128), "S495C2.s495c2f8");
    check_field_offset(lv, s495c2f9, ABISELECT(232,156), "S495C2.s495c2f9");
    check_field_offset(lv, s495c2f10, ABISELECT(240,160), "S495C2.s495c2f10");
    check_field_offset(lv, s495c2f11, ABISELECT(248,168), "S495C2.s495c2f11");
    check_field_offset(lv, s495c2f12, ABISELECT(252,172), "S495C2.s495c2f12");
    set_bf_and_test(lv, s495c2f13, ABISELECT(256,176), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f14, ABISELECT(256,176), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f15, ABISELECT(256,176), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f16, ABISELECT(256,176), 3, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f17, ABISELECT(256,176), 4, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f18, ABISELECT(256,176), 5, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f19, ABISELECT(256,176), 6, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f20, ABISELECT(256,176), 7, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f21, ABISELECT(257,177), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f22, ABISELECT(257,177), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f23, ABISELECT(257,177), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f24, ABISELECT(257,177), 3, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f25, ABISELECT(257,177), 4, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f26, ABISELECT(257,177), 5, 1, 1, "S495C2");
    check_field_offset(lv, s495c2f27, ABISELECT(260,180), "S495C2.s495c2f27");
    set_bf_and_test(lv, s495c2f28, ABISELECT(264,184), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f29, ABISELECT(264,184), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f30, ABISELECT(264,184), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f31, ABISELECT(264,184), 3, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f32, ABISELECT(264,184), 4, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f33, ABISELECT(264,184), 5, 1, 1, "S495C2");
    check_field_offset(lv, s495c2f34, ABISELECT(265,185), "S495C2.s495c2f34");
    set_bf_and_test(lv, s495c2f35, ABISELECT(266,186), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f36, ABISELECT(266,186), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f37, ABISELECT(266,186), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f38, ABISELECT(266,186), 3, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f39, ABISELECT(266,186), 4, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f40, ABISELECT(266,186), 5, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f41, ABISELECT(266,186), 6, 1, 1, "S495C2");
    check_field_offset(lv, s495c2f42, ABISELECT(267,187), "S495C2.s495c2f42");
    check_field_offset(lv, s495c2f43, ABISELECT(268,188), "S495C2.s495c2f43");
    set_bf_and_test(lv, s495c2f44, ABISELECT(269,189), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f45, ABISELECT(269,189), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f46, ABISELECT(269,189), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f47, ABISELECT(269,189), 3, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f48, ABISELECT(269,189), 4, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f49, ABISELECT(269,189), 5, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f50, ABISELECT(269,189), 6, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f51, ABISELECT(269,189), 7, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f52, ABISELECT(270,190), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f53, ABISELECT(270,190), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f54, ABISELECT(270,190), 2, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f55, ABISELECT(270,190), 3, 1, 1, "S495C2");
    check_field_offset(lv, s495c2f56, ABISELECT(272,192), "S495C2.s495c2f56");
    check_field_offset(lv, s495c2f57, ABISELECT(288,204), "S495C2.s495c2f57");
    check_field_offset(lv, s495c2f58, ABISELECT(304,212), "S495C2.s495c2f58");
    check_field_offset(lv, s495c2f59, ABISELECT(305,213), "S495C2.s495c2f59");
    check_field_offset(lv, s495c2f60, ABISELECT(308,216), "S495C2.s495c2f60");
    check_field_offset(lv, s495c2f61, ABISELECT(320,228), "S495C2.s495c2f61");
    check_field_offset(lv, s495c2f62, ABISELECT(332,240), "S495C2.s495c2f62");
    check_field_offset(lv, s495c2f63, ABISELECT(336,244), "S495C2.s495c2f63");
    set_bf_and_test(lv, s495c2f64, ABISELECT(348,256), 0, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f65, ABISELECT(348,256), 1, 1, 1, "S495C2");
    set_bf_and_test(lv, s495c2f66, ABISELECT(348,256), 2, 1, 1, "S495C2");
    check_field_offset(lv, s495c2f67, ABISELECT(352,260), "S495C2.s495c2f67");
    test_class_info(&lv, &cd_S495C2);
    dp->~S495C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS495C2(Test_S495C2, "S495C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S495C2C1Ev();
extern void _ZN6S495C2D1Ev();
Name_Map name_map_S495C2[] = {
  NSPAIR(_ZN6S495C2C1Ev),
  NSPAIR(_ZN6S495C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S495C5;
extern VTBL_ENTRY _ZTI6S495C5[];
extern  VTBL_ENTRY _ZTV6S495C5[];
extern Class_Descriptor cd_S495C4;
extern VTBL_ENTRY _ZTI6S495C4[];
extern  VTBL_ENTRY _ZTV6S495C4[];
extern Class_Descriptor cd_S495C3;
extern VTBL_ENTRY _ZTI6S495C3[];
extern  VTBL_ENTRY _ZTV6S495C3[];
static Base_Class bases_S495C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S495C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S495C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S495C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S495C2[];
extern void _ZN6S495C2D1Ev();
extern void _ZN6S495C2D0Ev();
extern void _ZN6S495C53v17Ev();
extern void _ZN6S495C53v18Ev();
extern void _ZN6S495C53v19Ev();
extern void _ZN6S495C53v20Ev();
extern void _ZN6S495C53v21Ev();
extern void _ZN6S495C53v22Ev();
extern void _ZN6S495C53v23Ev();
extern void _ZN6S495C53v24Ev();
extern void _ZN6S495C53v25Ev();
extern void _ZN6S495C53v26Ev();
extern void _ZN6S495C53v27Ev();
extern void _ZN6S495C53v28Ev();
extern void _ZN6S495C53v29Ev();
extern void _ZN6S495C53v30Ev();
extern void _ZN6S495C53v31Ev();
extern void _ZN6S495C53v32Ev();
extern void _ZN6S495C53v33Ev();
extern void _ZN6S495C53v34Ev();
extern void _ZN6S495C53v35Ev();
extern void _ZN6S495C53v36Ev();
extern void _ZN6S495C53v37Ev();
extern void _ZN6S495C53v38Ev();
extern void _ZN6S495C53v39Ev();
extern void _ZN6S495C53v40Ev();
extern void _ZN6S495C53v41Ev();
extern void _ZN6S495C53v42Ev();
extern void _ZN6S495C53v43Ev();
extern void _ZN6S495C53v44Ev();
extern void _ZN6S495C53v45Ev();
extern void _ZN6S495C53v46Ev();
extern void _ZN6S495C53v47Ev();
extern void _ZN6S495C53v48Ev();
extern void _ZN6S495C53v49Ev();
extern void _ZN6S495C53v50Ev();
extern void _ZN6S495C53v51Ev();
extern void _ZN6S495C53v52Ev();
extern void _ZN6S495C53v53Ev();
extern void _ZN6S495C53v54Ev();
extern void _ZN6S495C53v55Ev();
extern void _ZN6S495C53v56Ev();
extern void _ZN6S495C53v57Ev();
extern void _ZN6S495C53v58Ev();
extern void _ZN6S495C53v59Ev();
extern void _ZN6S495C53v60Ev();
extern void _ZN6S495C53v61Ev();
extern void _ZN6S495C53v62Ev();
extern void _ZN6S495C53v63Ev();
extern void _ZN6S495C53v64Ev();
extern void _ZN6S495C53v65Ev();
extern void _ZN6S495C53v66Ev();
extern void _ZN6S495C53v67Ev();
extern void _ZN6S495C53v68Ev();
extern void _ZN6S495C53v69Ev();
extern void _ZN6S495C53v70Ev();
extern void _ZN6S495C53v71Ev();
extern void _ZN6S495C53v72Ev();
extern void _ZN6S495C53v73Ev();
extern void _ZN6S495C53v74Ev();
extern void _ZN6S495C53v75Ev();
extern void _ZN6S495C53v76Ev();
extern void _ZN6S495C53v77Ev();
extern void _ZN6S495C53v78Ev();
extern void _ZN6S495C53v79Ev();
extern void _ZN6S495C53v80Ev();
extern void _ZN6S495C43v81Ev();
extern void _ZN6S495C43v82Ev();
extern void _ZN6S495C43v83Ev();
extern void _ZN6S495C43v84Ev();
extern void _ZN6S495C43v85Ev();
extern void _ZN6S495C33v86Ev();
extern void _ZN6S495C33v87Ev();
extern void _ZN6S495C33v88Ev();
extern void _ZN6S495C33v89Ev();
extern void _ZN6S495C33v90Ev();
extern void _ZN6S495C33v91Ev();
extern void _ZN6S495C33v92Ev();
extern void _ZN6S495C33v93Ev();
extern void _ZN6S495C33v94Ev();
extern void _ZN6S495C33v95Ev();
extern void _ZN6S495C33v96Ev();
extern void _ZN6S495C33v97Ev();
extern void _ZN6S495C33v98Ev();
extern void _ZN6S495C33v99Ev();
extern void _ZN6S495C34v100Ev();
extern void _ZN6S495C34v101Ev();
extern void _ZN6S495C34v102Ev();
extern void _ZN6S495C34v103Ev();
extern void _ZN6S495C34v104Ev();
extern void _ZN6S495C34v105Ev();
extern void _ZN6S495C34v106Ev();
extern void _ZN6S495C34v107Ev();
extern void _ZN6S495C24v108Ev();
extern void _ZN6S495C24v109Ev();
extern void _ZN6S495C24v110Ev();
extern void _ZN6S495C24v111Ev();
extern void _ZN6S495C24v112Ev();
extern void _ZN6S495C24v113Ev();
extern void _ZN6S495C24v114Ev();
extern void _ZN6S495C24v115Ev();
extern void _ZN6S495C24v116Ev();
extern void _ZN6S495C24v117Ev();
extern void _ZN6S495C24v118Ev();
extern void _ZN6S495C24v119Ev();
extern void _ZN6S495C24v120Ev();
extern void _ZN6S495C24v121Ev();
extern void _ZN6S495C24v122Ev();
extern void _ZN6S495C24v123Ev();
extern void _ZN6S495C24v124Ev();
extern void _ZN6S495C24v125Ev();
extern void _ZN6S495C24v126Ev();
extern void _ZN6S495C24v127Ev();
extern void _ZN6S495C24v128Ev();
extern void _ZN6S495C24v129Ev();
extern void _ZN6S495C24v130Ev();
extern void _ZN6S495C24v131Ev();
extern void _ZN6S495C24v132Ev();
extern void _ZN6S495C24v133Ev();
extern void _ZN6S495C24v134Ev();
extern void _ZN6S495C24v135Ev();
extern void _ZN6S495C24v136Ev();
extern void _ZN6S495C24v137Ev();
extern void _ZN6S495C24v138Ev();
extern void _ZN6S495C24v139Ev();
extern void _ZN6S495C24v140Ev();
extern void _ZN6S495C24v141Ev();
extern void _ZN6S495C24v142Ev();
extern void _ZN6S495C24v143Ev();
extern void _ZN6S495C24v144Ev();
extern void _ZN6S495C24v145Ev();
extern void _ZN6S495C24v146Ev();
extern void _ZN6S495C24v147Ev();
extern void _ZN6S495C24v148Ev();
extern void _ZN6S495C24v149Ev();
extern void _ZN6S495C24v150Ev();
extern void _ZN6S495C24v151Ev();
extern void _ZN6S495C24v152Ev();
extern void _ZN6S495C24v153Ev();
extern void _ZN6S495C24v154Ev();
extern void _ZN6S495C24v155Ev();
extern void _ZN6S495C24v156Ev();
extern void _ZN6S495C24v157Ev();
extern void _ZN6S495C24v158Ev();
extern void _ZN6S495C24v159Ev();
extern void _ZN6S495C24v160Ev();
extern void _ZN6S495C24v161Ev();
extern void _ZN6S495C24v162Ev();
extern void _ZN6S495C24v163Ev();
extern void _ZN6S495C24v164Ev();
extern void _ZN6S495C24v165Ev();
extern void _ZN6S495C24v166Ev();
extern void _ZN6S495C24v167Ev();
extern void _ZN6S495C24v168Ev();
static  VTBL_ENTRY vtc_S495C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S495C2[0]),
  (VTBL_ENTRY)&_ZN6S495C2D1Ev,
  (VTBL_ENTRY)&_ZN6S495C2D0Ev,
  (VTBL_ENTRY)&_ZN6S495C53v17Ev,
  (VTBL_ENTRY)&_ZN6S495C53v18Ev,
  (VTBL_ENTRY)&_ZN6S495C53v19Ev,
  (VTBL_ENTRY)&_ZN6S495C53v20Ev,
  (VTBL_ENTRY)&_ZN6S495C53v21Ev,
  (VTBL_ENTRY)&_ZN6S495C53v22Ev,
  (VTBL_ENTRY)&_ZN6S495C53v23Ev,
  (VTBL_ENTRY)&_ZN6S495C53v24Ev,
  (VTBL_ENTRY)&_ZN6S495C53v25Ev,
  (VTBL_ENTRY)&_ZN6S495C53v26Ev,
  (VTBL_ENTRY)&_ZN6S495C53v27Ev,
  (VTBL_ENTRY)&_ZN6S495C53v28Ev,
  (VTBL_ENTRY)&_ZN6S495C53v29Ev,
  (VTBL_ENTRY)&_ZN6S495C53v30Ev,
  (VTBL_ENTRY)&_ZN6S495C53v31Ev,
  (VTBL_ENTRY)&_ZN6S495C53v32Ev,
  (VTBL_ENTRY)&_ZN6S495C53v33Ev,
  (VTBL_ENTRY)&_ZN6S495C53v34Ev,
  (VTBL_ENTRY)&_ZN6S495C53v35Ev,
  (VTBL_ENTRY)&_ZN6S495C53v36Ev,
  (VTBL_ENTRY)&_ZN6S495C53v37Ev,
  (VTBL_ENTRY)&_ZN6S495C53v38Ev,
  (VTBL_ENTRY)&_ZN6S495C53v39Ev,
  (VTBL_ENTRY)&_ZN6S495C53v40Ev,
  (VTBL_ENTRY)&_ZN6S495C53v41Ev,
  (VTBL_ENTRY)&_ZN6S495C53v42Ev,
  (VTBL_ENTRY)&_ZN6S495C53v43Ev,
  (VTBL_ENTRY)&_ZN6S495C53v44Ev,
  (VTBL_ENTRY)&_ZN6S495C53v45Ev,
  (VTBL_ENTRY)&_ZN6S495C53v46Ev,
  (VTBL_ENTRY)&_ZN6S495C53v47Ev,
  (VTBL_ENTRY)&_ZN6S495C53v48Ev,
  (VTBL_ENTRY)&_ZN6S495C53v49Ev,
  (VTBL_ENTRY)&_ZN6S495C53v50Ev,
  (VTBL_ENTRY)&_ZN6S495C53v51Ev,
  (VTBL_ENTRY)&_ZN6S495C53v52Ev,
  (VTBL_ENTRY)&_ZN6S495C53v53Ev,
  (VTBL_ENTRY)&_ZN6S495C53v54Ev,
  (VTBL_ENTRY)&_ZN6S495C53v55Ev,
  (VTBL_ENTRY)&_ZN6S495C53v56Ev,
  (VTBL_ENTRY)&_ZN6S495C53v57Ev,
  (VTBL_ENTRY)&_ZN6S495C53v58Ev,
  (VTBL_ENTRY)&_ZN6S495C53v59Ev,
  (VTBL_ENTRY)&_ZN6S495C53v60Ev,
  (VTBL_ENTRY)&_ZN6S495C53v61Ev,
  (VTBL_ENTRY)&_ZN6S495C53v62Ev,
  (VTBL_ENTRY)&_ZN6S495C53v63Ev,
  (VTBL_ENTRY)&_ZN6S495C53v64Ev,
  (VTBL_ENTRY)&_ZN6S495C53v65Ev,
  (VTBL_ENTRY)&_ZN6S495C53v66Ev,
  (VTBL_ENTRY)&_ZN6S495C53v67Ev,
  (VTBL_ENTRY)&_ZN6S495C53v68Ev,
  (VTBL_ENTRY)&_ZN6S495C53v69Ev,
  (VTBL_ENTRY)&_ZN6S495C53v70Ev,
  (VTBL_ENTRY)&_ZN6S495C53v71Ev,
  (VTBL_ENTRY)&_ZN6S495C53v72Ev,
  (VTBL_ENTRY)&_ZN6S495C53v73Ev,
  (VTBL_ENTRY)&_ZN6S495C53v74Ev,
  (VTBL_ENTRY)&_ZN6S495C53v75Ev,
  (VTBL_ENTRY)&_ZN6S495C53v76Ev,
  (VTBL_ENTRY)&_ZN6S495C53v77Ev,
  (VTBL_ENTRY)&_ZN6S495C53v78Ev,
  (VTBL_ENTRY)&_ZN6S495C53v79Ev,
  (VTBL_ENTRY)&_ZN6S495C53v80Ev,
  (VTBL_ENTRY)&_ZN6S495C43v81Ev,
  (VTBL_ENTRY)&_ZN6S495C43v82Ev,
  (VTBL_ENTRY)&_ZN6S495C43v83Ev,
  (VTBL_ENTRY)&_ZN6S495C43v84Ev,
  (VTBL_ENTRY)&_ZN6S495C43v85Ev,
  (VTBL_ENTRY)&_ZN6S495C33v86Ev,
  (VTBL_ENTRY)&_ZN6S495C33v87Ev,
  (VTBL_ENTRY)&_ZN6S495C33v88Ev,
  (VTBL_ENTRY)&_ZN6S495C33v89Ev,
  (VTBL_ENTRY)&_ZN6S495C33v90Ev,
  (VTBL_ENTRY)&_ZN6S495C33v91Ev,
  (VTBL_ENTRY)&_ZN6S495C33v92Ev,
  (VTBL_ENTRY)&_ZN6S495C33v93Ev,
  (VTBL_ENTRY)&_ZN6S495C33v94Ev,
  (VTBL_ENTRY)&_ZN6S495C33v95Ev,
  (VTBL_ENTRY)&_ZN6S495C33v96Ev,
  (VTBL_ENTRY)&_ZN6S495C33v97Ev,
  (VTBL_ENTRY)&_ZN6S495C33v98Ev,
  (VTBL_ENTRY)&_ZN6S495C33v99Ev,
  (VTBL_ENTRY)&_ZN6S495C34v100Ev,
  (VTBL_ENTRY)&_ZN6S495C34v101Ev,
  (VTBL_ENTRY)&_ZN6S495C34v102Ev,
  (VTBL_ENTRY)&_ZN6S495C34v103Ev,
  (VTBL_ENTRY)&_ZN6S495C34v104Ev,
  (VTBL_ENTRY)&_ZN6S495C34v105Ev,
  (VTBL_ENTRY)&_ZN6S495C34v106Ev,
  (VTBL_ENTRY)&_ZN6S495C34v107Ev,
  (VTBL_ENTRY)&_ZN6S495C24v108Ev,
  (VTBL_ENTRY)&_ZN6S495C24v109Ev,
  (VTBL_ENTRY)&_ZN6S495C24v110Ev,
  (VTBL_ENTRY)&_ZN6S495C24v111Ev,
  (VTBL_ENTRY)&_ZN6S495C24v112Ev,
  (VTBL_ENTRY)&_ZN6S495C24v113Ev,
  (VTBL_ENTRY)&_ZN6S495C24v114Ev,
  (VTBL_ENTRY)&_ZN6S495C24v115Ev,
  (VTBL_ENTRY)&_ZN6S495C24v116Ev,
  (VTBL_ENTRY)&_ZN6S495C24v117Ev,
  (VTBL_ENTRY)&_ZN6S495C24v118Ev,
  (VTBL_ENTRY)&_ZN6S495C24v119Ev,
  (VTBL_ENTRY)&_ZN6S495C24v120Ev,
  (VTBL_ENTRY)&_ZN6S495C24v121Ev,
  (VTBL_ENTRY)&_ZN6S495C24v122Ev,
  (VTBL_ENTRY)&_ZN6S495C24v123Ev,
  (VTBL_ENTRY)&_ZN6S495C24v124Ev,
  (VTBL_ENTRY)&_ZN6S495C24v125Ev,
  (VTBL_ENTRY)&_ZN6S495C24v126Ev,
  (VTBL_ENTRY)&_ZN6S495C24v127Ev,
  (VTBL_ENTRY)&_ZN6S495C24v128Ev,
  (VTBL_ENTRY)&_ZN6S495C24v129Ev,
  (VTBL_ENTRY)&_ZN6S495C24v130Ev,
  (VTBL_ENTRY)&_ZN6S495C24v131Ev,
  (VTBL_ENTRY)&_ZN6S495C24v132Ev,
  (VTBL_ENTRY)&_ZN6S495C24v133Ev,
  (VTBL_ENTRY)&_ZN6S495C24v134Ev,
  (VTBL_ENTRY)&_ZN6S495C24v135Ev,
  (VTBL_ENTRY)&_ZN6S495C24v136Ev,
  (VTBL_ENTRY)&_ZN6S495C24v137Ev,
  (VTBL_ENTRY)&_ZN6S495C24v138Ev,
  (VTBL_ENTRY)&_ZN6S495C24v139Ev,
  (VTBL_ENTRY)&_ZN6S495C24v140Ev,
  (VTBL_ENTRY)&_ZN6S495C24v141Ev,
  (VTBL_ENTRY)&_ZN6S495C24v142Ev,
  (VTBL_ENTRY)&_ZN6S495C24v143Ev,
  (VTBL_ENTRY)&_ZN6S495C24v144Ev,
  (VTBL_ENTRY)&_ZN6S495C24v145Ev,
  (VTBL_ENTRY)&_ZN6S495C24v146Ev,
  (VTBL_ENTRY)&_ZN6S495C24v147Ev,
  (VTBL_ENTRY)&_ZN6S495C24v148Ev,
  (VTBL_ENTRY)&_ZN6S495C24v149Ev,
  (VTBL_ENTRY)&_ZN6S495C24v150Ev,
  (VTBL_ENTRY)&_ZN6S495C24v151Ev,
  (VTBL_ENTRY)&_ZN6S495C24v152Ev,
  (VTBL_ENTRY)&_ZN6S495C24v153Ev,
  (VTBL_ENTRY)&_ZN6S495C24v154Ev,
  (VTBL_ENTRY)&_ZN6S495C24v155Ev,
  (VTBL_ENTRY)&_ZN6S495C24v156Ev,
  (VTBL_ENTRY)&_ZN6S495C24v157Ev,
  (VTBL_ENTRY)&_ZN6S495C24v158Ev,
  (VTBL_ENTRY)&_ZN6S495C24v159Ev,
  (VTBL_ENTRY)&_ZN6S495C24v160Ev,
  (VTBL_ENTRY)&_ZN6S495C24v161Ev,
  (VTBL_ENTRY)&_ZN6S495C24v162Ev,
  (VTBL_ENTRY)&_ZN6S495C24v163Ev,
  (VTBL_ENTRY)&_ZN6S495C24v164Ev,
  (VTBL_ENTRY)&_ZN6S495C24v165Ev,
  (VTBL_ENTRY)&_ZN6S495C24v166Ev,
  (VTBL_ENTRY)&_ZN6S495C24v167Ev,
  (VTBL_ENTRY)&_ZN6S495C24v168Ev,
};
extern VTBL_ENTRY _ZTI6S495C2[];
extern  VTBL_ENTRY _ZTV6S495C2[];
Class_Descriptor cd_S495C2 = {  "S495C2", // class name
  bases_S495C2, 3,
  &(vtc_S495C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S495C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S495C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S495C1  : S495C2 {
  void *s495c1f0[4];
  unsigned int s495c1f1:1;
  unsigned int s495c1f2:1;
  unsigned int s495c1f3:1;
  unsigned int s495c1f4:1;
  unsigned int s495c1f5:1;
  unsigned int s495c1f6:1;
  int s495c1f7[4];
  ::S95C40_nt s495c1f8;
  void *s495c1f9;
  virtual  ~S495C1(); // _ZN6S495C1D1Ev
  virtual void  v1(); // _ZN6S495C12v1Ev
  virtual void  v2(); // _ZN6S495C12v2Ev
  virtual void  v3(); // _ZN6S495C12v3Ev
  virtual void  v4(); // _ZN6S495C12v4Ev
  virtual void  v5(); // _ZN6S495C12v5Ev
  virtual void  v6(); // _ZN6S495C12v6Ev
  virtual void  v7(); // _ZN6S495C12v7Ev
  virtual void  v8(); // _ZN6S495C12v8Ev
  virtual void  v9(); // _ZN6S495C12v9Ev
  virtual void  v10(); // _ZN6S495C13v10Ev
  virtual void  v11(); // _ZN6S495C13v11Ev
  virtual void  v12(); // _ZN6S495C13v12Ev
  virtual void  v13(); // _ZN6S495C13v13Ev
  virtual void  v14(); // _ZN6S495C13v14Ev
  virtual void  v15(); // _ZN6S495C13v15Ev
  virtual void  v16(); // _ZN6S495C13v16Ev
  S495C1(); // tgen
};
//SIG(1 S495C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84 v85 Fp FC6} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp[4] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[4] FC17{ m Fi[4]} Fp}


 S495C1 ::~S495C1(){ note_dtor("S495C1", this);}
void  S495C1 ::v1(){vfunc_called(this, "_ZN6S495C12v1Ev");}
void  S495C1 ::v2(){vfunc_called(this, "_ZN6S495C12v2Ev");}
void  S495C1 ::v3(){vfunc_called(this, "_ZN6S495C12v3Ev");}
void  S495C1 ::v4(){vfunc_called(this, "_ZN6S495C12v4Ev");}
void  S495C1 ::v5(){vfunc_called(this, "_ZN6S495C12v5Ev");}
void  S495C1 ::v6(){vfunc_called(this, "_ZN6S495C12v6Ev");}
void  S495C1 ::v7(){vfunc_called(this, "_ZN6S495C12v7Ev");}
void  S495C1 ::v8(){vfunc_called(this, "_ZN6S495C12v8Ev");}
void  S495C1 ::v9(){vfunc_called(this, "_ZN6S495C12v9Ev");}
void  S495C1 ::v10(){vfunc_called(this, "_ZN6S495C13v10Ev");}
void  S495C1 ::v11(){vfunc_called(this, "_ZN6S495C13v11Ev");}
void  S495C1 ::v12(){vfunc_called(this, "_ZN6S495C13v12Ev");}
void  S495C1 ::v13(){vfunc_called(this, "_ZN6S495C13v13Ev");}
void  S495C1 ::v14(){vfunc_called(this, "_ZN6S495C13v14Ev");}
void  S495C1 ::v15(){vfunc_called(this, "_ZN6S495C13v15Ev");}
void  S495C1 ::v16(){vfunc_called(this, "_ZN6S495C13v16Ev");}
S495C1 ::S495C1(){ note_ctor("S495C1", this);} // tgen

static void Test_S495C1()
{
  extern Class_Descriptor cd_S495C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(57,83)];
    init_test(&cd_S495C1, buf);
    S495C1 *dp, &lv = *(dp=new (buf) S495C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,328), "sizeof(S495C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S495C1)");
    check_base_class_offset(lv, (S495C5*)(S495C4*)(S495C3*)(S495C2*), 0, "S495C1");
    check_base_class_offset(lv, (S495C4*)(S495C3*)(S495C2*), 0, "S495C1");
    check_base_class_offset(lv, (S495C3*)(S495C2*), 0, "S495C1");
    check_base_class_offset(lv, (S495C2*), 0, "S495C1");
    check_field_offset(lv, s495c1f0, ABISELECT(368,272), "S495C1.s495c1f0");
    set_bf_and_test(lv, s495c1f1, ABISELECT(400,288), 0, 1, 1, "S495C1");
    set_bf_and_test(lv, s495c1f2, ABISELECT(400,288), 1, 1, 1, "S495C1");
    set_bf_and_test(lv, s495c1f3, ABISELECT(400,288), 2, 1, 1, "S495C1");
    set_bf_and_test(lv, s495c1f4, ABISELECT(400,288), 3, 1, 1, "S495C1");
    set_bf_and_test(lv, s495c1f5, ABISELECT(400,288), 4, 1, 1, "S495C1");
    set_bf_and_test(lv, s495c1f6, ABISELECT(400,288), 5, 1, 1, "S495C1");
    check_field_offset(lv, s495c1f7, ABISELECT(404,292), "S495C1.s495c1f7");
    check_field_offset(lv, s495c1f8, ABISELECT(420,308), "S495C1.s495c1f8");
    check_field_offset(lv, s495c1f9, ABISELECT(440,324), "S495C1.s495c1f9");
    test_class_info(&lv, &cd_S495C1);
    dp->~S495C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS495C1(Test_S495C1, "S495C1", ABISELECT(448,328));

#else // __cplusplus

extern void _ZN6S495C1C1Ev();
extern void _ZN6S495C1D1Ev();
Name_Map name_map_S495C1[] = {
  NSPAIR(_ZN6S495C1C1Ev),
  NSPAIR(_ZN6S495C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S495C5;
extern VTBL_ENTRY _ZTI6S495C5[];
extern  VTBL_ENTRY _ZTV6S495C5[];
extern Class_Descriptor cd_S495C4;
extern VTBL_ENTRY _ZTI6S495C4[];
extern  VTBL_ENTRY _ZTV6S495C4[];
extern Class_Descriptor cd_S495C3;
extern VTBL_ENTRY _ZTI6S495C3[];
extern  VTBL_ENTRY _ZTV6S495C3[];
extern Class_Descriptor cd_S495C2;
extern VTBL_ENTRY _ZTI6S495C2[];
extern  VTBL_ENTRY _ZTV6S495C2[];
static Base_Class bases_S495C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S495C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S495C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S495C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S495C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S495C1[];
extern void _ZN6S495C1D1Ev();
extern void _ZN6S495C1D0Ev();
extern void _ZN6S495C53v17Ev();
extern void _ZN6S495C53v18Ev();
extern void _ZN6S495C53v19Ev();
extern void _ZN6S495C53v20Ev();
extern void _ZN6S495C53v21Ev();
extern void _ZN6S495C53v22Ev();
extern void _ZN6S495C53v23Ev();
extern void _ZN6S495C53v24Ev();
extern void _ZN6S495C53v25Ev();
extern void _ZN6S495C53v26Ev();
extern void _ZN6S495C53v27Ev();
extern void _ZN6S495C53v28Ev();
extern void _ZN6S495C53v29Ev();
extern void _ZN6S495C53v30Ev();
extern void _ZN6S495C53v31Ev();
extern void _ZN6S495C53v32Ev();
extern void _ZN6S495C53v33Ev();
extern void _ZN6S495C53v34Ev();
extern void _ZN6S495C53v35Ev();
extern void _ZN6S495C53v36Ev();
extern void _ZN6S495C53v37Ev();
extern void _ZN6S495C53v38Ev();
extern void _ZN6S495C53v39Ev();
extern void _ZN6S495C53v40Ev();
extern void _ZN6S495C53v41Ev();
extern void _ZN6S495C53v42Ev();
extern void _ZN6S495C53v43Ev();
extern void _ZN6S495C53v44Ev();
extern void _ZN6S495C53v45Ev();
extern void _ZN6S495C53v46Ev();
extern void _ZN6S495C53v47Ev();
extern void _ZN6S495C53v48Ev();
extern void _ZN6S495C53v49Ev();
extern void _ZN6S495C53v50Ev();
extern void _ZN6S495C53v51Ev();
extern void _ZN6S495C53v52Ev();
extern void _ZN6S495C53v53Ev();
extern void _ZN6S495C53v54Ev();
extern void _ZN6S495C53v55Ev();
extern void _ZN6S495C53v56Ev();
extern void _ZN6S495C53v57Ev();
extern void _ZN6S495C53v58Ev();
extern void _ZN6S495C53v59Ev();
extern void _ZN6S495C53v60Ev();
extern void _ZN6S495C53v61Ev();
extern void _ZN6S495C53v62Ev();
extern void _ZN6S495C53v63Ev();
extern void _ZN6S495C53v64Ev();
extern void _ZN6S495C53v65Ev();
extern void _ZN6S495C53v66Ev();
extern void _ZN6S495C53v67Ev();
extern void _ZN6S495C53v68Ev();
extern void _ZN6S495C53v69Ev();
extern void _ZN6S495C53v70Ev();
extern void _ZN6S495C53v71Ev();
extern void _ZN6S495C53v72Ev();
extern void _ZN6S495C53v73Ev();
extern void _ZN6S495C53v74Ev();
extern void _ZN6S495C53v75Ev();
extern void _ZN6S495C53v76Ev();
extern void _ZN6S495C53v77Ev();
extern void _ZN6S495C53v78Ev();
extern void _ZN6S495C53v79Ev();
extern void _ZN6S495C53v80Ev();
extern void _ZN6S495C43v81Ev();
extern void _ZN6S495C43v82Ev();
extern void _ZN6S495C43v83Ev();
extern void _ZN6S495C43v84Ev();
extern void _ZN6S495C43v85Ev();
extern void _ZN6S495C33v86Ev();
extern void _ZN6S495C33v87Ev();
extern void _ZN6S495C33v88Ev();
extern void _ZN6S495C33v89Ev();
extern void _ZN6S495C33v90Ev();
extern void _ZN6S495C33v91Ev();
extern void _ZN6S495C33v92Ev();
extern void _ZN6S495C33v93Ev();
extern void _ZN6S495C33v94Ev();
extern void _ZN6S495C33v95Ev();
extern void _ZN6S495C33v96Ev();
extern void _ZN6S495C33v97Ev();
extern void _ZN6S495C33v98Ev();
extern void _ZN6S495C33v99Ev();
extern void _ZN6S495C34v100Ev();
extern void _ZN6S495C34v101Ev();
extern void _ZN6S495C34v102Ev();
extern void _ZN6S495C34v103Ev();
extern void _ZN6S495C34v104Ev();
extern void _ZN6S495C34v105Ev();
extern void _ZN6S495C34v106Ev();
extern void _ZN6S495C34v107Ev();
extern void _ZN6S495C24v108Ev();
extern void _ZN6S495C24v109Ev();
extern void _ZN6S495C24v110Ev();
extern void _ZN6S495C24v111Ev();
extern void _ZN6S495C24v112Ev();
extern void _ZN6S495C24v113Ev();
extern void _ZN6S495C24v114Ev();
extern void _ZN6S495C24v115Ev();
extern void _ZN6S495C24v116Ev();
extern void _ZN6S495C24v117Ev();
extern void _ZN6S495C24v118Ev();
extern void _ZN6S495C24v119Ev();
extern void _ZN6S495C24v120Ev();
extern void _ZN6S495C24v121Ev();
extern void _ZN6S495C24v122Ev();
extern void _ZN6S495C24v123Ev();
extern void _ZN6S495C24v124Ev();
extern void _ZN6S495C24v125Ev();
extern void _ZN6S495C24v126Ev();
extern void _ZN6S495C24v127Ev();
extern void _ZN6S495C24v128Ev();
extern void _ZN6S495C24v129Ev();
extern void _ZN6S495C24v130Ev();
extern void _ZN6S495C24v131Ev();
extern void _ZN6S495C24v132Ev();
extern void _ZN6S495C24v133Ev();
extern void _ZN6S495C24v134Ev();
extern void _ZN6S495C24v135Ev();
extern void _ZN6S495C24v136Ev();
extern void _ZN6S495C24v137Ev();
extern void _ZN6S495C24v138Ev();
extern void _ZN6S495C24v139Ev();
extern void _ZN6S495C24v140Ev();
extern void _ZN6S495C24v141Ev();
extern void _ZN6S495C24v142Ev();
extern void _ZN6S495C24v143Ev();
extern void _ZN6S495C24v144Ev();
extern void _ZN6S495C24v145Ev();
extern void _ZN6S495C24v146Ev();
extern void _ZN6S495C24v147Ev();
extern void _ZN6S495C24v148Ev();
extern void _ZN6S495C24v149Ev();
extern void _ZN6S495C24v150Ev();
extern void _ZN6S495C24v151Ev();
extern void _ZN6S495C24v152Ev();
extern void _ZN6S495C24v153Ev();
extern void _ZN6S495C24v154Ev();
extern void _ZN6S495C24v155Ev();
extern void _ZN6S495C24v156Ev();
extern void _ZN6S495C24v157Ev();
extern void _ZN6S495C24v158Ev();
extern void _ZN6S495C24v159Ev();
extern void _ZN6S495C24v160Ev();
extern void _ZN6S495C24v161Ev();
extern void _ZN6S495C24v162Ev();
extern void _ZN6S495C24v163Ev();
extern void _ZN6S495C24v164Ev();
extern void _ZN6S495C24v165Ev();
extern void _ZN6S495C24v166Ev();
extern void _ZN6S495C24v167Ev();
extern void _ZN6S495C24v168Ev();
extern void _ZN6S495C12v1Ev();
extern void _ZN6S495C12v2Ev();
extern void _ZN6S495C12v3Ev();
extern void _ZN6S495C12v4Ev();
extern void _ZN6S495C12v5Ev();
extern void _ZN6S495C12v6Ev();
extern void _ZN6S495C12v7Ev();
extern void _ZN6S495C12v8Ev();
extern void _ZN6S495C12v9Ev();
extern void _ZN6S495C13v10Ev();
extern void _ZN6S495C13v11Ev();
extern void _ZN6S495C13v12Ev();
extern void _ZN6S495C13v13Ev();
extern void _ZN6S495C13v14Ev();
extern void _ZN6S495C13v15Ev();
extern void _ZN6S495C13v16Ev();
static  VTBL_ENTRY vtc_S495C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S495C1[0]),
  (VTBL_ENTRY)&_ZN6S495C1D1Ev,
  (VTBL_ENTRY)&_ZN6S495C1D0Ev,
  (VTBL_ENTRY)&_ZN6S495C53v17Ev,
  (VTBL_ENTRY)&_ZN6S495C53v18Ev,
  (VTBL_ENTRY)&_ZN6S495C53v19Ev,
  (VTBL_ENTRY)&_ZN6S495C53v20Ev,
  (VTBL_ENTRY)&_ZN6S495C53v21Ev,
  (VTBL_ENTRY)&_ZN6S495C53v22Ev,
  (VTBL_ENTRY)&_ZN6S495C53v23Ev,
  (VTBL_ENTRY)&_ZN6S495C53v24Ev,
  (VTBL_ENTRY)&_ZN6S495C53v25Ev,
  (VTBL_ENTRY)&_ZN6S495C53v26Ev,
  (VTBL_ENTRY)&_ZN6S495C53v27Ev,
  (VTBL_ENTRY)&_ZN6S495C53v28Ev,
  (VTBL_ENTRY)&_ZN6S495C53v29Ev,
  (VTBL_ENTRY)&_ZN6S495C53v30Ev,
  (VTBL_ENTRY)&_ZN6S495C53v31Ev,
  (VTBL_ENTRY)&_ZN6S495C53v32Ev,
  (VTBL_ENTRY)&_ZN6S495C53v33Ev,
  (VTBL_ENTRY)&_ZN6S495C53v34Ev,
  (VTBL_ENTRY)&_ZN6S495C53v35Ev,
  (VTBL_ENTRY)&_ZN6S495C53v36Ev,
  (VTBL_ENTRY)&_ZN6S495C53v37Ev,
  (VTBL_ENTRY)&_ZN6S495C53v38Ev,
  (VTBL_ENTRY)&_ZN6S495C53v39Ev,
  (VTBL_ENTRY)&_ZN6S495C53v40Ev,
  (VTBL_ENTRY)&_ZN6S495C53v41Ev,
  (VTBL_ENTRY)&_ZN6S495C53v42Ev,
  (VTBL_ENTRY)&_ZN6S495C53v43Ev,
  (VTBL_ENTRY)&_ZN6S495C53v44Ev,
  (VTBL_ENTRY)&_ZN6S495C53v45Ev,
  (VTBL_ENTRY)&_ZN6S495C53v46Ev,
  (VTBL_ENTRY)&_ZN6S495C53v47Ev,
  (VTBL_ENTRY)&_ZN6S495C53v48Ev,
  (VTBL_ENTRY)&_ZN6S495C53v49Ev,
  (VTBL_ENTRY)&_ZN6S495C53v50Ev,
  (VTBL_ENTRY)&_ZN6S495C53v51Ev,
  (VTBL_ENTRY)&_ZN6S495C53v52Ev,
  (VTBL_ENTRY)&_ZN6S495C53v53Ev,
  (VTBL_ENTRY)&_ZN6S495C53v54Ev,
  (VTBL_ENTRY)&_ZN6S495C53v55Ev,
  (VTBL_ENTRY)&_ZN6S495C53v56Ev,
  (VTBL_ENTRY)&_ZN6S495C53v57Ev,
  (VTBL_ENTRY)&_ZN6S495C53v58Ev,
  (VTBL_ENTRY)&_ZN6S495C53v59Ev,
  (VTBL_ENTRY)&_ZN6S495C53v60Ev,
  (VTBL_ENTRY)&_ZN6S495C53v61Ev,
  (VTBL_ENTRY)&_ZN6S495C53v62Ev,
  (VTBL_ENTRY)&_ZN6S495C53v63Ev,
  (VTBL_ENTRY)&_ZN6S495C53v64Ev,
  (VTBL_ENTRY)&_ZN6S495C53v65Ev,
  (VTBL_ENTRY)&_ZN6S495C53v66Ev,
  (VTBL_ENTRY)&_ZN6S495C53v67Ev,
  (VTBL_ENTRY)&_ZN6S495C53v68Ev,
  (VTBL_ENTRY)&_ZN6S495C53v69Ev,
  (VTBL_ENTRY)&_ZN6S495C53v70Ev,
  (VTBL_ENTRY)&_ZN6S495C53v71Ev,
  (VTBL_ENTRY)&_ZN6S495C53v72Ev,
  (VTBL_ENTRY)&_ZN6S495C53v73Ev,
  (VTBL_ENTRY)&_ZN6S495C53v74Ev,
  (VTBL_ENTRY)&_ZN6S495C53v75Ev,
  (VTBL_ENTRY)&_ZN6S495C53v76Ev,
  (VTBL_ENTRY)&_ZN6S495C53v77Ev,
  (VTBL_ENTRY)&_ZN6S495C53v78Ev,
  (VTBL_ENTRY)&_ZN6S495C53v79Ev,
  (VTBL_ENTRY)&_ZN6S495C53v80Ev,
  (VTBL_ENTRY)&_ZN6S495C43v81Ev,
  (VTBL_ENTRY)&_ZN6S495C43v82Ev,
  (VTBL_ENTRY)&_ZN6S495C43v83Ev,
  (VTBL_ENTRY)&_ZN6S495C43v84Ev,
  (VTBL_ENTRY)&_ZN6S495C43v85Ev,
  (VTBL_ENTRY)&_ZN6S495C33v86Ev,
  (VTBL_ENTRY)&_ZN6S495C33v87Ev,
  (VTBL_ENTRY)&_ZN6S495C33v88Ev,
  (VTBL_ENTRY)&_ZN6S495C33v89Ev,
  (VTBL_ENTRY)&_ZN6S495C33v90Ev,
  (VTBL_ENTRY)&_ZN6S495C33v91Ev,
  (VTBL_ENTRY)&_ZN6S495C33v92Ev,
  (VTBL_ENTRY)&_ZN6S495C33v93Ev,
  (VTBL_ENTRY)&_ZN6S495C33v94Ev,
  (VTBL_ENTRY)&_ZN6S495C33v95Ev,
  (VTBL_ENTRY)&_ZN6S495C33v96Ev,
  (VTBL_ENTRY)&_ZN6S495C33v97Ev,
  (VTBL_ENTRY)&_ZN6S495C33v98Ev,
  (VTBL_ENTRY)&_ZN6S495C33v99Ev,
  (VTBL_ENTRY)&_ZN6S495C34v100Ev,
  (VTBL_ENTRY)&_ZN6S495C34v101Ev,
  (VTBL_ENTRY)&_ZN6S495C34v102Ev,
  (VTBL_ENTRY)&_ZN6S495C34v103Ev,
  (VTBL_ENTRY)&_ZN6S495C34v104Ev,
  (VTBL_ENTRY)&_ZN6S495C34v105Ev,
  (VTBL_ENTRY)&_ZN6S495C34v106Ev,
  (VTBL_ENTRY)&_ZN6S495C34v107Ev,
  (VTBL_ENTRY)&_ZN6S495C24v108Ev,
  (VTBL_ENTRY)&_ZN6S495C24v109Ev,
  (VTBL_ENTRY)&_ZN6S495C24v110Ev,
  (VTBL_ENTRY)&_ZN6S495C24v111Ev,
  (VTBL_ENTRY)&_ZN6S495C24v112Ev,
  (VTBL_ENTRY)&_ZN6S495C24v113Ev,
  (VTBL_ENTRY)&_ZN6S495C24v114Ev,
  (VTBL_ENTRY)&_ZN6S495C24v115Ev,
  (VTBL_ENTRY)&_ZN6S495C24v116Ev,
  (VTBL_ENTRY)&_ZN6S495C24v117Ev,
  (VTBL_ENTRY)&_ZN6S495C24v118Ev,
  (VTBL_ENTRY)&_ZN6S495C24v119Ev,
  (VTBL_ENTRY)&_ZN6S495C24v120Ev,
  (VTBL_ENTRY)&_ZN6S495C24v121Ev,
  (VTBL_ENTRY)&_ZN6S495C24v122Ev,
  (VTBL_ENTRY)&_ZN6S495C24v123Ev,
  (VTBL_ENTRY)&_ZN6S495C24v124Ev,
  (VTBL_ENTRY)&_ZN6S495C24v125Ev,
  (VTBL_ENTRY)&_ZN6S495C24v126Ev,
  (VTBL_ENTRY)&_ZN6S495C24v127Ev,
  (VTBL_ENTRY)&_ZN6S495C24v128Ev,
  (VTBL_ENTRY)&_ZN6S495C24v129Ev,
  (VTBL_ENTRY)&_ZN6S495C24v130Ev,
  (VTBL_ENTRY)&_ZN6S495C24v131Ev,
  (VTBL_ENTRY)&_ZN6S495C24v132Ev,
  (VTBL_ENTRY)&_ZN6S495C24v133Ev,
  (VTBL_ENTRY)&_ZN6S495C24v134Ev,
  (VTBL_ENTRY)&_ZN6S495C24v135Ev,
  (VTBL_ENTRY)&_ZN6S495C24v136Ev,
  (VTBL_ENTRY)&_ZN6S495C24v137Ev,
  (VTBL_ENTRY)&_ZN6S495C24v138Ev,
  (VTBL_ENTRY)&_ZN6S495C24v139Ev,
  (VTBL_ENTRY)&_ZN6S495C24v140Ev,
  (VTBL_ENTRY)&_ZN6S495C24v141Ev,
  (VTBL_ENTRY)&_ZN6S495C24v142Ev,
  (VTBL_ENTRY)&_ZN6S495C24v143Ev,
  (VTBL_ENTRY)&_ZN6S495C24v144Ev,
  (VTBL_ENTRY)&_ZN6S495C24v145Ev,
  (VTBL_ENTRY)&_ZN6S495C24v146Ev,
  (VTBL_ENTRY)&_ZN6S495C24v147Ev,
  (VTBL_ENTRY)&_ZN6S495C24v148Ev,
  (VTBL_ENTRY)&_ZN6S495C24v149Ev,
  (VTBL_ENTRY)&_ZN6S495C24v150Ev,
  (VTBL_ENTRY)&_ZN6S495C24v151Ev,
  (VTBL_ENTRY)&_ZN6S495C24v152Ev,
  (VTBL_ENTRY)&_ZN6S495C24v153Ev,
  (VTBL_ENTRY)&_ZN6S495C24v154Ev,
  (VTBL_ENTRY)&_ZN6S495C24v155Ev,
  (VTBL_ENTRY)&_ZN6S495C24v156Ev,
  (VTBL_ENTRY)&_ZN6S495C24v157Ev,
  (VTBL_ENTRY)&_ZN6S495C24v158Ev,
  (VTBL_ENTRY)&_ZN6S495C24v159Ev,
  (VTBL_ENTRY)&_ZN6S495C24v160Ev,
  (VTBL_ENTRY)&_ZN6S495C24v161Ev,
  (VTBL_ENTRY)&_ZN6S495C24v162Ev,
  (VTBL_ENTRY)&_ZN6S495C24v163Ev,
  (VTBL_ENTRY)&_ZN6S495C24v164Ev,
  (VTBL_ENTRY)&_ZN6S495C24v165Ev,
  (VTBL_ENTRY)&_ZN6S495C24v166Ev,
  (VTBL_ENTRY)&_ZN6S495C24v167Ev,
  (VTBL_ENTRY)&_ZN6S495C24v168Ev,
  (VTBL_ENTRY)&_ZN6S495C12v1Ev,
  (VTBL_ENTRY)&_ZN6S495C12v2Ev,
  (VTBL_ENTRY)&_ZN6S495C12v3Ev,
  (VTBL_ENTRY)&_ZN6S495C12v4Ev,
  (VTBL_ENTRY)&_ZN6S495C12v5Ev,
  (VTBL_ENTRY)&_ZN6S495C12v6Ev,
  (VTBL_ENTRY)&_ZN6S495C12v7Ev,
  (VTBL_ENTRY)&_ZN6S495C12v8Ev,
  (VTBL_ENTRY)&_ZN6S495C12v9Ev,
  (VTBL_ENTRY)&_ZN6S495C13v10Ev,
  (VTBL_ENTRY)&_ZN6S495C13v11Ev,
  (VTBL_ENTRY)&_ZN6S495C13v12Ev,
  (VTBL_ENTRY)&_ZN6S495C13v13Ev,
  (VTBL_ENTRY)&_ZN6S495C13v14Ev,
  (VTBL_ENTRY)&_ZN6S495C13v15Ev,
  (VTBL_ENTRY)&_ZN6S495C13v16Ev,
};
extern VTBL_ENTRY _ZTI6S495C1[];
extern  VTBL_ENTRY _ZTV6S495C1[];
Class_Descriptor cd_S495C1 = {  "S495C1", // class name
  bases_S495C1, 4,
  &(vtc_S495C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(448,328), // object size
  NSPAIRA(_ZTI6S495C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S495C1),172, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S496C5  {
  int s496c5f0;
  __tsi64 s496c5f1;
  void *s496c5f2[4];
  int s496c5f3[2];
  void *s496c5f4;
  ::S95C8_nt s496c5f5;
  void *s496c5f6[2];
  virtual  ~S496C5(); // _ZN6S496C5D1Ev
  virtual void  v17(); // _ZN6S496C53v17Ev
  virtual void  v18(); // _ZN6S496C53v18Ev
  virtual void  v19(); // _ZN6S496C53v19Ev
  virtual void  v20(); // _ZN6S496C53v20Ev
  virtual void  v21(); // _ZN6S496C53v21Ev
  virtual void  v22(); // _ZN6S496C53v22Ev
  virtual void  v23(); // _ZN6S496C53v23Ev
  virtual void  v24(); // _ZN6S496C53v24Ev
  virtual void  v25(); // _ZN6S496C53v25Ev
  virtual void  v26(); // _ZN6S496C53v26Ev
  virtual void  v27(); // _ZN6S496C53v27Ev
  virtual void  v28(); // _ZN6S496C53v28Ev
  virtual void  v29(); // _ZN6S496C53v29Ev
  virtual void  v30(); // _ZN6S496C53v30Ev
  virtual void  v31(); // _ZN6S496C53v31Ev
  virtual void  v32(); // _ZN6S496C53v32Ev
  virtual void  v33(); // _ZN6S496C53v33Ev
  virtual void  v34(); // _ZN6S496C53v34Ev
  virtual void  v35(); // _ZN6S496C53v35Ev
  virtual void  v36(); // _ZN6S496C53v36Ev
  virtual void  v37(); // _ZN6S496C53v37Ev
  virtual void  v38(); // _ZN6S496C53v38Ev
  virtual void  v39(); // _ZN6S496C53v39Ev
  virtual void  v40(); // _ZN6S496C53v40Ev
  virtual void  v41(); // _ZN6S496C53v41Ev
  virtual void  v42(); // _ZN6S496C53v42Ev
  virtual void  v43(); // _ZN6S496C53v43Ev
  virtual void  v44(); // _ZN6S496C53v44Ev
  virtual void  v45(); // _ZN6S496C53v45Ev
  virtual void  v46(); // _ZN6S496C53v46Ev
  virtual void  v47(); // _ZN6S496C53v47Ev
  virtual void  v48(); // _ZN6S496C53v48Ev
  virtual void  v49(); // _ZN6S496C53v49Ev
  virtual void  v50(); // _ZN6S496C53v50Ev
  virtual void  v51(); // _ZN6S496C53v51Ev
  virtual void  v52(); // _ZN6S496C53v52Ev
  virtual void  v53(); // _ZN6S496C53v53Ev
  virtual void  v54(); // _ZN6S496C53v54Ev
  virtual void  v55(); // _ZN6S496C53v55Ev
  virtual void  v56(); // _ZN6S496C53v56Ev
  virtual void  v57(); // _ZN6S496C53v57Ev
  virtual void  v58(); // _ZN6S496C53v58Ev
  virtual void  v59(); // _ZN6S496C53v59Ev
  virtual void  v60(); // _ZN6S496C53v60Ev
  virtual void  v61(); // _ZN6S496C53v61Ev
  virtual void  v62(); // _ZN6S496C53v62Ev
  virtual void  v63(); // _ZN6S496C53v63Ev
  virtual void  v64(); // _ZN6S496C53v64Ev
  virtual void  v65(); // _ZN6S496C53v65Ev
  virtual void  v66(); // _ZN6S496C53v66Ev
  virtual void  v67(); // _ZN6S496C53v67Ev
  virtual void  v68(); // _ZN6S496C53v68Ev
  virtual void  v69(); // _ZN6S496C53v69Ev
  virtual void  v70(); // _ZN6S496C53v70Ev
  virtual void  v71(); // _ZN6S496C53v71Ev
  virtual void  v72(); // _ZN6S496C53v72Ev
  virtual void  v73(); // _ZN6S496C53v73Ev
  virtual void  v74(); // _ZN6S496C53v74Ev
  virtual void  v75(); // _ZN6S496C53v75Ev
  virtual void  v76(); // _ZN6S496C53v76Ev
  virtual void  v77(); // _ZN6S496C53v77Ev
  virtual void  v78(); // _ZN6S496C53v78Ev
  virtual void  v79(); // _ZN6S496C53v79Ev
  virtual void  v80(); // _ZN6S496C53v80Ev
  S496C5(); // tgen
};
//SIG(-1 S496C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S496C5 ::~S496C5(){ note_dtor("S496C5", this);}
void  S496C5 ::v17(){vfunc_called(this, "_ZN6S496C53v17Ev");}
void  S496C5 ::v18(){vfunc_called(this, "_ZN6S496C53v18Ev");}
void  S496C5 ::v19(){vfunc_called(this, "_ZN6S496C53v19Ev");}
void  S496C5 ::v20(){vfunc_called(this, "_ZN6S496C53v20Ev");}
void  S496C5 ::v21(){vfunc_called(this, "_ZN6S496C53v21Ev");}
void  S496C5 ::v22(){vfunc_called(this, "_ZN6S496C53v22Ev");}
void  S496C5 ::v23(){vfunc_called(this, "_ZN6S496C53v23Ev");}
void  S496C5 ::v24(){vfunc_called(this, "_ZN6S496C53v24Ev");}
void  S496C5 ::v25(){vfunc_called(this, "_ZN6S496C53v25Ev");}
void  S496C5 ::v26(){vfunc_called(this, "_ZN6S496C53v26Ev");}
void  S496C5 ::v27(){vfunc_called(this, "_ZN6S496C53v27Ev");}
void  S496C5 ::v28(){vfunc_called(this, "_ZN6S496C53v28Ev");}
void  S496C5 ::v29(){vfunc_called(this, "_ZN6S496C53v29Ev");}
void  S496C5 ::v30(){vfunc_called(this, "_ZN6S496C53v30Ev");}
void  S496C5 ::v31(){vfunc_called(this, "_ZN6S496C53v31Ev");}
void  S496C5 ::v32(){vfunc_called(this, "_ZN6S496C53v32Ev");}
void  S496C5 ::v33(){vfunc_called(this, "_ZN6S496C53v33Ev");}
void  S496C5 ::v34(){vfunc_called(this, "_ZN6S496C53v34Ev");}
void  S496C5 ::v35(){vfunc_called(this, "_ZN6S496C53v35Ev");}
void  S496C5 ::v36(){vfunc_called(this, "_ZN6S496C53v36Ev");}
void  S496C5 ::v37(){vfunc_called(this, "_ZN6S496C53v37Ev");}
void  S496C5 ::v38(){vfunc_called(this, "_ZN6S496C53v38Ev");}
void  S496C5 ::v39(){vfunc_called(this, "_ZN6S496C53v39Ev");}
void  S496C5 ::v40(){vfunc_called(this, "_ZN6S496C53v40Ev");}
void  S496C5 ::v41(){vfunc_called(this, "_ZN6S496C53v41Ev");}
void  S496C5 ::v42(){vfunc_called(this, "_ZN6S496C53v42Ev");}
void  S496C5 ::v43(){vfunc_called(this, "_ZN6S496C53v43Ev");}
void  S496C5 ::v44(){vfunc_called(this, "_ZN6S496C53v44Ev");}
void  S496C5 ::v45(){vfunc_called(this, "_ZN6S496C53v45Ev");}
void  S496C5 ::v46(){vfunc_called(this, "_ZN6S496C53v46Ev");}
void  S496C5 ::v47(){vfunc_called(this, "_ZN6S496C53v47Ev");}
void  S496C5 ::v48(){vfunc_called(this, "_ZN6S496C53v48Ev");}
void  S496C5 ::v49(){vfunc_called(this, "_ZN6S496C53v49Ev");}
void  S496C5 ::v50(){vfunc_called(this, "_ZN6S496C53v50Ev");}
void  S496C5 ::v51(){vfunc_called(this, "_ZN6S496C53v51Ev");}
void  S496C5 ::v52(){vfunc_called(this, "_ZN6S496C53v52Ev");}
void  S496C5 ::v53(){vfunc_called(this, "_ZN6S496C53v53Ev");}
void  S496C5 ::v54(){vfunc_called(this, "_ZN6S496C53v54Ev");}
void  S496C5 ::v55(){vfunc_called(this, "_ZN6S496C53v55Ev");}
void  S496C5 ::v56(){vfunc_called(this, "_ZN6S496C53v56Ev");}
void  S496C5 ::v57(){vfunc_called(this, "_ZN6S496C53v57Ev");}
void  S496C5 ::v58(){vfunc_called(this, "_ZN6S496C53v58Ev");}
void  S496C5 ::v59(){vfunc_called(this, "_ZN6S496C53v59Ev");}
void  S496C5 ::v60(){vfunc_called(this, "_ZN6S496C53v60Ev");}
void  S496C5 ::v61(){vfunc_called(this, "_ZN6S496C53v61Ev");}
void  S496C5 ::v62(){vfunc_called(this, "_ZN6S496C53v62Ev");}
void  S496C5 ::v63(){vfunc_called(this, "_ZN6S496C53v63Ev");}
void  S496C5 ::v64(){vfunc_called(this, "_ZN6S496C53v64Ev");}
void  S496C5 ::v65(){vfunc_called(this, "_ZN6S496C53v65Ev");}
void  S496C5 ::v66(){vfunc_called(this, "_ZN6S496C53v66Ev");}
void  S496C5 ::v67(){vfunc_called(this, "_ZN6S496C53v67Ev");}
void  S496C5 ::v68(){vfunc_called(this, "_ZN6S496C53v68Ev");}
void  S496C5 ::v69(){vfunc_called(this, "_ZN6S496C53v69Ev");}
void  S496C5 ::v70(){vfunc_called(this, "_ZN6S496C53v70Ev");}
void  S496C5 ::v71(){vfunc_called(this, "_ZN6S496C53v71Ev");}
void  S496C5 ::v72(){vfunc_called(this, "_ZN6S496C53v72Ev");}
void  S496C5 ::v73(){vfunc_called(this, "_ZN6S496C53v73Ev");}
void  S496C5 ::v74(){vfunc_called(this, "_ZN6S496C53v74Ev");}
void  S496C5 ::v75(){vfunc_called(this, "_ZN6S496C53v75Ev");}
void  S496C5 ::v76(){vfunc_called(this, "_ZN6S496C53v76Ev");}
void  S496C5 ::v77(){vfunc_called(this, "_ZN6S496C53v77Ev");}
void  S496C5 ::v78(){vfunc_called(this, "_ZN6S496C53v78Ev");}
void  S496C5 ::v79(){vfunc_called(this, "_ZN6S496C53v79Ev");}
void  S496C5 ::v80(){vfunc_called(this, "_ZN6S496C53v80Ev");}
S496C5 ::S496C5(){ note_ctor("S496C5", this);} // tgen

static void Test_S496C5()
{
  extern Class_Descriptor cd_S496C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S496C5, buf);
    S496C5 *dp, &lv = *(dp=new (buf) S496C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S496C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S496C5)");
    check_field_offset(lv, s496c5f0, ABISELECT(8,4), "S496C5.s496c5f0");
    check_field_offset(lv, s496c5f1, ABISELECT(16,8), "S496C5.s496c5f1");
    check_field_offset(lv, s496c5f2, ABISELECT(24,16), "S496C5.s496c5f2");
    check_field_offset(lv, s496c5f3, ABISELECT(56,32), "S496C5.s496c5f3");
    check_field_offset(lv, s496c5f4, ABISELECT(64,40), "S496C5.s496c5f4");
    check_field_offset(lv, s496c5f5, ABISELECT(72,44), "S496C5.s496c5f5");
    check_field_offset(lv, s496c5f6, ABISELECT(80,52), "S496C5.s496c5f6");
    test_class_info(&lv, &cd_S496C5);
    dp->~S496C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS496C5(Test_S496C5, "S496C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S496C5C1Ev();
extern void _ZN6S496C5D1Ev();
Name_Map name_map_S496C5[] = {
  NSPAIR(_ZN6S496C5C1Ev),
  NSPAIR(_ZN6S496C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S496C5[];
extern void _ZN6S496C5D1Ev();
extern void _ZN6S496C5D0Ev();
extern void _ZN6S496C53v17Ev();
extern void _ZN6S496C53v18Ev();
extern void _ZN6S496C53v19Ev();
extern void _ZN6S496C53v20Ev();
extern void _ZN6S496C53v21Ev();
extern void _ZN6S496C53v22Ev();
extern void _ZN6S496C53v23Ev();
extern void _ZN6S496C53v24Ev();
extern void _ZN6S496C53v25Ev();
extern void _ZN6S496C53v26Ev();
extern void _ZN6S496C53v27Ev();
extern void _ZN6S496C53v28Ev();
extern void _ZN6S496C53v29Ev();
extern void _ZN6S496C53v30Ev();
extern void _ZN6S496C53v31Ev();
extern void _ZN6S496C53v32Ev();
extern void _ZN6S496C53v33Ev();
extern void _ZN6S496C53v34Ev();
extern void _ZN6S496C53v35Ev();
extern void _ZN6S496C53v36Ev();
extern void _ZN6S496C53v37Ev();
extern void _ZN6S496C53v38Ev();
extern void _ZN6S496C53v39Ev();
extern void _ZN6S496C53v40Ev();
extern void _ZN6S496C53v41Ev();
extern void _ZN6S496C53v42Ev();
extern void _ZN6S496C53v43Ev();
extern void _ZN6S496C53v44Ev();
extern void _ZN6S496C53v45Ev();
extern void _ZN6S496C53v46Ev();
extern void _ZN6S496C53v47Ev();
extern void _ZN6S496C53v48Ev();
extern void _ZN6S496C53v49Ev();
extern void _ZN6S496C53v50Ev();
extern void _ZN6S496C53v51Ev();
extern void _ZN6S496C53v52Ev();
extern void _ZN6S496C53v53Ev();
extern void _ZN6S496C53v54Ev();
extern void _ZN6S496C53v55Ev();
extern void _ZN6S496C53v56Ev();
extern void _ZN6S496C53v57Ev();
extern void _ZN6S496C53v58Ev();
extern void _ZN6S496C53v59Ev();
extern void _ZN6S496C53v60Ev();
extern void _ZN6S496C53v61Ev();
extern void _ZN6S496C53v62Ev();
extern void _ZN6S496C53v63Ev();
extern void _ZN6S496C53v64Ev();
extern void _ZN6S496C53v65Ev();
extern void _ZN6S496C53v66Ev();
extern void _ZN6S496C53v67Ev();
extern void _ZN6S496C53v68Ev();
extern void _ZN6S496C53v69Ev();
extern void _ZN6S496C53v70Ev();
extern void _ZN6S496C53v71Ev();
extern void _ZN6S496C53v72Ev();
extern void _ZN6S496C53v73Ev();
extern void _ZN6S496C53v74Ev();
extern void _ZN6S496C53v75Ev();
extern void _ZN6S496C53v76Ev();
extern void _ZN6S496C53v77Ev();
extern void _ZN6S496C53v78Ev();
extern void _ZN6S496C53v79Ev();
extern void _ZN6S496C53v80Ev();
static  VTBL_ENTRY vtc_S496C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S496C5[0]),
  (VTBL_ENTRY)&_ZN6S496C5D1Ev,
  (VTBL_ENTRY)&_ZN6S496C5D0Ev,
  (VTBL_ENTRY)&_ZN6S496C53v17Ev,
  (VTBL_ENTRY)&_ZN6S496C53v18Ev,
  (VTBL_ENTRY)&_ZN6S496C53v19Ev,
  (VTBL_ENTRY)&_ZN6S496C53v20Ev,
  (VTBL_ENTRY)&_ZN6S496C53v21Ev,
  (VTBL_ENTRY)&_ZN6S496C53v22Ev,
  (VTBL_ENTRY)&_ZN6S496C53v23Ev,
  (VTBL_ENTRY)&_ZN6S496C53v24Ev,
  (VTBL_ENTRY)&_ZN6S496C53v25Ev,
  (VTBL_ENTRY)&_ZN6S496C53v26Ev,
  (VTBL_ENTRY)&_ZN6S496C53v27Ev,
  (VTBL_ENTRY)&_ZN6S496C53v28Ev,
  (VTBL_ENTRY)&_ZN6S496C53v29Ev,
  (VTBL_ENTRY)&_ZN6S496C53v30Ev,
  (VTBL_ENTRY)&_ZN6S496C53v31Ev,
  (VTBL_ENTRY)&_ZN6S496C53v32Ev,
  (VTBL_ENTRY)&_ZN6S496C53v33Ev,
  (VTBL_ENTRY)&_ZN6S496C53v34Ev,
  (VTBL_ENTRY)&_ZN6S496C53v35Ev,
  (VTBL_ENTRY)&_ZN6S496C53v36Ev,
  (VTBL_ENTRY)&_ZN6S496C53v37Ev,
  (VTBL_ENTRY)&_ZN6S496C53v38Ev,
  (VTBL_ENTRY)&_ZN6S496C53v39Ev,
  (VTBL_ENTRY)&_ZN6S496C53v40Ev,
  (VTBL_ENTRY)&_ZN6S496C53v41Ev,
  (VTBL_ENTRY)&_ZN6S496C53v42Ev,
  (VTBL_ENTRY)&_ZN6S496C53v43Ev,
  (VTBL_ENTRY)&_ZN6S496C53v44Ev,
  (VTBL_ENTRY)&_ZN6S496C53v45Ev,
  (VTBL_ENTRY)&_ZN6S496C53v46Ev,
  (VTBL_ENTRY)&_ZN6S496C53v47Ev,
  (VTBL_ENTRY)&_ZN6S496C53v48Ev,
  (VTBL_ENTRY)&_ZN6S496C53v49Ev,
  (VTBL_ENTRY)&_ZN6S496C53v50Ev,
  (VTBL_ENTRY)&_ZN6S496C53v51Ev,
  (VTBL_ENTRY)&_ZN6S496C53v52Ev,
  (VTBL_ENTRY)&_ZN6S496C53v53Ev,
  (VTBL_ENTRY)&_ZN6S496C53v54Ev,
  (VTBL_ENTRY)&_ZN6S496C53v55Ev,
  (VTBL_ENTRY)&_ZN6S496C53v56Ev,
  (VTBL_ENTRY)&_ZN6S496C53v57Ev,
  (VTBL_ENTRY)&_ZN6S496C53v58Ev,
  (VTBL_ENTRY)&_ZN6S496C53v59Ev,
  (VTBL_ENTRY)&_ZN6S496C53v60Ev,
  (VTBL_ENTRY)&_ZN6S496C53v61Ev,
  (VTBL_ENTRY)&_ZN6S496C53v62Ev,
  (VTBL_ENTRY)&_ZN6S496C53v63Ev,
  (VTBL_ENTRY)&_ZN6S496C53v64Ev,
  (VTBL_ENTRY)&_ZN6S496C53v65Ev,
  (VTBL_ENTRY)&_ZN6S496C53v66Ev,
  (VTBL_ENTRY)&_ZN6S496C53v67Ev,
  (VTBL_ENTRY)&_ZN6S496C53v68Ev,
  (VTBL_ENTRY)&_ZN6S496C53v69Ev,
  (VTBL_ENTRY)&_ZN6S496C53v70Ev,
  (VTBL_ENTRY)&_ZN6S496C53v71Ev,
  (VTBL_ENTRY)&_ZN6S496C53v72Ev,
  (VTBL_ENTRY)&_ZN6S496C53v73Ev,
  (VTBL_ENTRY)&_ZN6S496C53v74Ev,
  (VTBL_ENTRY)&_ZN6S496C53v75Ev,
  (VTBL_ENTRY)&_ZN6S496C53v76Ev,
  (VTBL_ENTRY)&_ZN6S496C53v77Ev,
  (VTBL_ENTRY)&_ZN6S496C53v78Ev,
  (VTBL_ENTRY)&_ZN6S496C53v79Ev,
  (VTBL_ENTRY)&_ZN6S496C53v80Ev,
};
extern VTBL_ENTRY _ZTI6S496C5[];
extern  VTBL_ENTRY _ZTV6S496C5[];
Class_Descriptor cd_S496C5 = {  "S496C5", // class name
  0,0,//no base classes
  &(vtc_S496C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S496C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S496C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S496C4  : S496C5 {
  void *s496c4f0;
  ::S95C8_nt s496c4f1;
  virtual  ~S496C4(); // _ZN6S496C4D1Ev
  virtual void  v81(); // _ZN6S496C43v81Ev
  virtual void  v82(); // _ZN6S496C43v82Ev
  virtual void  v83(); // _ZN6S496C43v83Ev
  virtual void  v84(); // _ZN6S496C43v84Ev
  virtual void  v85(); // _ZN6S496C43v85Ev
  S496C4(); // tgen
};
//SIG(-1 S496C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S496C4 ::~S496C4(){ note_dtor("S496C4", this);}
void  S496C4 ::v81(){vfunc_called(this, "_ZN6S496C43v81Ev");}
void  S496C4 ::v82(){vfunc_called(this, "_ZN6S496C43v82Ev");}
void  S496C4 ::v83(){vfunc_called(this, "_ZN6S496C43v83Ev");}
void  S496C4 ::v84(){vfunc_called(this, "_ZN6S496C43v84Ev");}
void  S496C4 ::v85(){vfunc_called(this, "_ZN6S496C43v85Ev");}
S496C4 ::S496C4(){ note_ctor("S496C4", this);} // tgen

static void Test_S496C4()
{
  extern Class_Descriptor cd_S496C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S496C4, buf);
    S496C4 *dp, &lv = *(dp=new (buf) S496C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S496C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S496C4)");
    check_base_class_offset(lv, (S496C5*), 0, "S496C4");
    check_field_offset(lv, s496c4f0, ABISELECT(96,60), "S496C4.s496c4f0");
    check_field_offset(lv, s496c4f1, ABISELECT(104,64), "S496C4.s496c4f1");
    test_class_info(&lv, &cd_S496C4);
    dp->~S496C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS496C4(Test_S496C4, "S496C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S496C4C1Ev();
extern void _ZN6S496C4D1Ev();
Name_Map name_map_S496C4[] = {
  NSPAIR(_ZN6S496C4C1Ev),
  NSPAIR(_ZN6S496C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S496C5;
extern VTBL_ENTRY _ZTI6S496C5[];
extern  VTBL_ENTRY _ZTV6S496C5[];
static Base_Class bases_S496C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S496C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S496C4[];
extern void _ZN6S496C4D1Ev();
extern void _ZN6S496C4D0Ev();
extern void _ZN6S496C53v17Ev();
extern void _ZN6S496C53v18Ev();
extern void _ZN6S496C53v19Ev();
extern void _ZN6S496C53v20Ev();
extern void _ZN6S496C53v21Ev();
extern void _ZN6S496C53v22Ev();
extern void _ZN6S496C53v23Ev();
extern void _ZN6S496C53v24Ev();
extern void _ZN6S496C53v25Ev();
extern void _ZN6S496C53v26Ev();
extern void _ZN6S496C53v27Ev();
extern void _ZN6S496C53v28Ev();
extern void _ZN6S496C53v29Ev();
extern void _ZN6S496C53v30Ev();
extern void _ZN6S496C53v31Ev();
extern void _ZN6S496C53v32Ev();
extern void _ZN6S496C53v33Ev();
extern void _ZN6S496C53v34Ev();
extern void _ZN6S496C53v35Ev();
extern void _ZN6S496C53v36Ev();
extern void _ZN6S496C53v37Ev();
extern void _ZN6S496C53v38Ev();
extern void _ZN6S496C53v39Ev();
extern void _ZN6S496C53v40Ev();
extern void _ZN6S496C53v41Ev();
extern void _ZN6S496C53v42Ev();
extern void _ZN6S496C53v43Ev();
extern void _ZN6S496C53v44Ev();
extern void _ZN6S496C53v45Ev();
extern void _ZN6S496C53v46Ev();
extern void _ZN6S496C53v47Ev();
extern void _ZN6S496C53v48Ev();
extern void _ZN6S496C53v49Ev();
extern void _ZN6S496C53v50Ev();
extern void _ZN6S496C53v51Ev();
extern void _ZN6S496C53v52Ev();
extern void _ZN6S496C53v53Ev();
extern void _ZN6S496C53v54Ev();
extern void _ZN6S496C53v55Ev();
extern void _ZN6S496C53v56Ev();
extern void _ZN6S496C53v57Ev();
extern void _ZN6S496C53v58Ev();
extern void _ZN6S496C53v59Ev();
extern void _ZN6S496C53v60Ev();
extern void _ZN6S496C53v61Ev();
extern void _ZN6S496C53v62Ev();
extern void _ZN6S496C53v63Ev();
extern void _ZN6S496C53v64Ev();
extern void _ZN6S496C53v65Ev();
extern void _ZN6S496C53v66Ev();
extern void _ZN6S496C53v67Ev();
extern void _ZN6S496C53v68Ev();
extern void _ZN6S496C53v69Ev();
extern void _ZN6S496C53v70Ev();
extern void _ZN6S496C53v71Ev();
extern void _ZN6S496C53v72Ev();
extern void _ZN6S496C53v73Ev();
extern void _ZN6S496C53v74Ev();
extern void _ZN6S496C53v75Ev();
extern void _ZN6S496C53v76Ev();
extern void _ZN6S496C53v77Ev();
extern void _ZN6S496C53v78Ev();
extern void _ZN6S496C53v79Ev();
extern void _ZN6S496C53v80Ev();
extern void _ZN6S496C43v81Ev();
extern void _ZN6S496C43v82Ev();
extern void _ZN6S496C43v83Ev();
extern void _ZN6S496C43v84Ev();
extern void _ZN6S496C43v85Ev();
static  VTBL_ENTRY vtc_S496C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S496C4[0]),
  (VTBL_ENTRY)&_ZN6S496C4D1Ev,
  (VTBL_ENTRY)&_ZN6S496C4D0Ev,
  (VTBL_ENTRY)&_ZN6S496C53v17Ev,
  (VTBL_ENTRY)&_ZN6S496C53v18Ev,
  (VTBL_ENTRY)&_ZN6S496C53v19Ev,
  (VTBL_ENTRY)&_ZN6S496C53v20Ev,
  (VTBL_ENTRY)&_ZN6S496C53v21Ev,
  (VTBL_ENTRY)&_ZN6S496C53v22Ev,
  (VTBL_ENTRY)&_ZN6S496C53v23Ev,
  (VTBL_ENTRY)&_ZN6S496C53v24Ev,
  (VTBL_ENTRY)&_ZN6S496C53v25Ev,
  (VTBL_ENTRY)&_ZN6S496C53v26Ev,
  (VTBL_ENTRY)&_ZN6S496C53v27Ev,
  (VTBL_ENTRY)&_ZN6S496C53v28Ev,
  (VTBL_ENTRY)&_ZN6S496C53v29Ev,
  (VTBL_ENTRY)&_ZN6S496C53v30Ev,
  (VTBL_ENTRY)&_ZN6S496C53v31Ev,
  (VTBL_ENTRY)&_ZN6S496C53v32Ev,
  (VTBL_ENTRY)&_ZN6S496C53v33Ev,
  (VTBL_ENTRY)&_ZN6S496C53v34Ev,
  (VTBL_ENTRY)&_ZN6S496C53v35Ev,
  (VTBL_ENTRY)&_ZN6S496C53v36Ev,
  (VTBL_ENTRY)&_ZN6S496C53v37Ev,
  (VTBL_ENTRY)&_ZN6S496C53v38Ev,
  (VTBL_ENTRY)&_ZN6S496C53v39Ev,
  (VTBL_ENTRY)&_ZN6S496C53v40Ev,
  (VTBL_ENTRY)&_ZN6S496C53v41Ev,
  (VTBL_ENTRY)&_ZN6S496C53v42Ev,
  (VTBL_ENTRY)&_ZN6S496C53v43Ev,
  (VTBL_ENTRY)&_ZN6S496C53v44Ev,
  (VTBL_ENTRY)&_ZN6S496C53v45Ev,
  (VTBL_ENTRY)&_ZN6S496C53v46Ev,
  (VTBL_ENTRY)&_ZN6S496C53v47Ev,
  (VTBL_ENTRY)&_ZN6S496C53v48Ev,
  (VTBL_ENTRY)&_ZN6S496C53v49Ev,
  (VTBL_ENTRY)&_ZN6S496C53v50Ev,
  (VTBL_ENTRY)&_ZN6S496C53v51Ev,
  (VTBL_ENTRY)&_ZN6S496C53v52Ev,
  (VTBL_ENTRY)&_ZN6S496C53v53Ev,
  (VTBL_ENTRY)&_ZN6S496C53v54Ev,
  (VTBL_ENTRY)&_ZN6S496C53v55Ev,
  (VTBL_ENTRY)&_ZN6S496C53v56Ev,
  (VTBL_ENTRY)&_ZN6S496C53v57Ev,
  (VTBL_ENTRY)&_ZN6S496C53v58Ev,
  (VTBL_ENTRY)&_ZN6S496C53v59Ev,
  (VTBL_ENTRY)&_ZN6S496C53v60Ev,
  (VTBL_ENTRY)&_ZN6S496C53v61Ev,
  (VTBL_ENTRY)&_ZN6S496C53v62Ev,
  (VTBL_ENTRY)&_ZN6S496C53v63Ev,
  (VTBL_ENTRY)&_ZN6S496C53v64Ev,
  (VTBL_ENTRY)&_ZN6S496C53v65Ev,
  (VTBL_ENTRY)&_ZN6S496C53v66Ev,
  (VTBL_ENTRY)&_ZN6S496C53v67Ev,
  (VTBL_ENTRY)&_ZN6S496C53v68Ev,
  (VTBL_ENTRY)&_ZN6S496C53v69Ev,
  (VTBL_ENTRY)&_ZN6S496C53v70Ev,
  (VTBL_ENTRY)&_ZN6S496C53v71Ev,
  (VTBL_ENTRY)&_ZN6S496C53v72Ev,
  (VTBL_ENTRY)&_ZN6S496C53v73Ev,
  (VTBL_ENTRY)&_ZN6S496C53v74Ev,
  (VTBL_ENTRY)&_ZN6S496C53v75Ev,
  (VTBL_ENTRY)&_ZN6S496C53v76Ev,
  (VTBL_ENTRY)&_ZN6S496C53v77Ev,
  (VTBL_ENTRY)&_ZN6S496C53v78Ev,
  (VTBL_ENTRY)&_ZN6S496C53v79Ev,
  (VTBL_ENTRY)&_ZN6S496C53v80Ev,
  (VTBL_ENTRY)&_ZN6S496C43v81Ev,
  (VTBL_ENTRY)&_ZN6S496C43v82Ev,
  (VTBL_ENTRY)&_ZN6S496C43v83Ev,
  (VTBL_ENTRY)&_ZN6S496C43v84Ev,
  (VTBL_ENTRY)&_ZN6S496C43v85Ev,
};
extern VTBL_ENTRY _ZTI6S496C4[];
extern  VTBL_ENTRY _ZTV6S496C4[];
Class_Descriptor cd_S496C4 = {  "S496C4", // class name
  bases_S496C4, 1,
  &(vtc_S496C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S496C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S496C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S496C3  : S496C4 {
  void *s496c3f0[2];
  unsigned int s496c3f1:1;
  unsigned int s496c3f2:1;
  unsigned int s496c3f3:1;
  unsigned int s496c3f4:1;
  char s496c3f5;
  virtual  ~S496C3(); // _ZN6S496C3D1Ev
  virtual void  v86(); // _ZN6S496C33v86Ev
  virtual void  v87(); // _ZN6S496C33v87Ev
  virtual void  v88(); // _ZN6S496C33v88Ev
  virtual void  v89(); // _ZN6S496C33v89Ev
  virtual void  v90(); // _ZN6S496C33v90Ev
  virtual void  v91(); // _ZN6S496C33v91Ev
  virtual void  v92(); // _ZN6S496C33v92Ev
  virtual void  v93(); // _ZN6S496C33v93Ev
  virtual void  v94(); // _ZN6S496C33v94Ev
  virtual void  v95(); // _ZN6S496C33v95Ev
  virtual void  v96(); // _ZN6S496C33v96Ev
  virtual void  v97(); // _ZN6S496C33v97Ev
  virtual void  v98(); // _ZN6S496C33v98Ev
  virtual void  v99(); // _ZN6S496C33v99Ev
  virtual void  v100(); // _ZN6S496C34v100Ev
  virtual void  v101(); // _ZN6S496C34v101Ev
  virtual void  v102(); // _ZN6S496C34v102Ev
  virtual void  v103(); // _ZN6S496C34v103Ev
  virtual void  v104(); // _ZN6S496C34v104Ev
  virtual void  v105(); // _ZN6S496C34v105Ev
  virtual void  v106(); // _ZN6S496C34v106Ev
  virtual void  v107(); // _ZN6S496C34v107Ev
  S496C3(); // tgen
};
//SIG(-1 S496C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S496C3 ::~S496C3(){ note_dtor("S496C3", this);}
void  S496C3 ::v86(){vfunc_called(this, "_ZN6S496C33v86Ev");}
void  S496C3 ::v87(){vfunc_called(this, "_ZN6S496C33v87Ev");}
void  S496C3 ::v88(){vfunc_called(this, "_ZN6S496C33v88Ev");}
void  S496C3 ::v89(){vfunc_called(this, "_ZN6S496C33v89Ev");}
void  S496C3 ::v90(){vfunc_called(this, "_ZN6S496C33v90Ev");}
void  S496C3 ::v91(){vfunc_called(this, "_ZN6S496C33v91Ev");}
void  S496C3 ::v92(){vfunc_called(this, "_ZN6S496C33v92Ev");}
void  S496C3 ::v93(){vfunc_called(this, "_ZN6S496C33v93Ev");}
void  S496C3 ::v94(){vfunc_called(this, "_ZN6S496C33v94Ev");}
void  S496C3 ::v95(){vfunc_called(this, "_ZN6S496C33v95Ev");}
void  S496C3 ::v96(){vfunc_called(this, "_ZN6S496C33v96Ev");}
void  S496C3 ::v97(){vfunc_called(this, "_ZN6S496C33v97Ev");}
void  S496C3 ::v98(){vfunc_called(this, "_ZN6S496C33v98Ev");}
void  S496C3 ::v99(){vfunc_called(this, "_ZN6S496C33v99Ev");}
void  S496C3 ::v100(){vfunc_called(this, "_ZN6S496C34v100Ev");}
void  S496C3 ::v101(){vfunc_called(this, "_ZN6S496C34v101Ev");}
void  S496C3 ::v102(){vfunc_called(this, "_ZN6S496C34v102Ev");}
void  S496C3 ::v103(){vfunc_called(this, "_ZN6S496C34v103Ev");}
void  S496C3 ::v104(){vfunc_called(this, "_ZN6S496C34v104Ev");}
void  S496C3 ::v105(){vfunc_called(this, "_ZN6S496C34v105Ev");}
void  S496C3 ::v106(){vfunc_called(this, "_ZN6S496C34v106Ev");}
void  S496C3 ::v107(){vfunc_called(this, "_ZN6S496C34v107Ev");}
S496C3 ::S496C3(){ note_ctor("S496C3", this);} // tgen

static void Test_S496C3()
{
  extern Class_Descriptor cd_S496C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S496C3, buf);
    S496C3 *dp, &lv = *(dp=new (buf) S496C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S496C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S496C3)");
    check_base_class_offset(lv, (S496C5*)(S496C4*), 0, "S496C3");
    check_base_class_offset(lv, (S496C4*), 0, "S496C3");
    check_field_offset(lv, s496c3f0, ABISELECT(112,72), "S496C3.s496c3f0");
    set_bf_and_test(lv, s496c3f1, ABISELECT(128,80), 0, 1, 1, "S496C3");
    set_bf_and_test(lv, s496c3f2, ABISELECT(128,80), 1, 1, 1, "S496C3");
    set_bf_and_test(lv, s496c3f3, ABISELECT(128,80), 2, 1, 1, "S496C3");
    set_bf_and_test(lv, s496c3f4, ABISELECT(128,80), 3, 1, 1, "S496C3");
    check_field_offset(lv, s496c3f5, ABISELECT(129,81), "S496C3.s496c3f5");
    test_class_info(&lv, &cd_S496C3);
    dp->~S496C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS496C3(Test_S496C3, "S496C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S496C3C1Ev();
extern void _ZN6S496C3D1Ev();
Name_Map name_map_S496C3[] = {
  NSPAIR(_ZN6S496C3C1Ev),
  NSPAIR(_ZN6S496C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S496C5;
extern VTBL_ENTRY _ZTI6S496C5[];
extern  VTBL_ENTRY _ZTV6S496C5[];
extern Class_Descriptor cd_S496C4;
extern VTBL_ENTRY _ZTI6S496C4[];
extern  VTBL_ENTRY _ZTV6S496C4[];
static Base_Class bases_S496C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S496C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S496C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S496C3[];
extern void _ZN6S496C3D1Ev();
extern void _ZN6S496C3D0Ev();
extern void _ZN6S496C53v17Ev();
extern void _ZN6S496C53v18Ev();
extern void _ZN6S496C53v19Ev();
extern void _ZN6S496C53v20Ev();
extern void _ZN6S496C53v21Ev();
extern void _ZN6S496C53v22Ev();
extern void _ZN6S496C53v23Ev();
extern void _ZN6S496C53v24Ev();
extern void _ZN6S496C53v25Ev();
extern void _ZN6S496C53v26Ev();
extern void _ZN6S496C53v27Ev();
extern void _ZN6S496C53v28Ev();
extern void _ZN6S496C53v29Ev();
extern void _ZN6S496C53v30Ev();
extern void _ZN6S496C53v31Ev();
extern void _ZN6S496C53v32Ev();
extern void _ZN6S496C53v33Ev();
extern void _ZN6S496C53v34Ev();
extern void _ZN6S496C53v35Ev();
extern void _ZN6S496C53v36Ev();
extern void _ZN6S496C53v37Ev();
extern void _ZN6S496C53v38Ev();
extern void _ZN6S496C53v39Ev();
extern void _ZN6S496C53v40Ev();
extern void _ZN6S496C53v41Ev();
extern void _ZN6S496C53v42Ev();
extern void _ZN6S496C53v43Ev();
extern void _ZN6S496C53v44Ev();
extern void _ZN6S496C53v45Ev();
extern void _ZN6S496C53v46Ev();
extern void _ZN6S496C53v47Ev();
extern void _ZN6S496C53v48Ev();
extern void _ZN6S496C53v49Ev();
extern void _ZN6S496C53v50Ev();
extern void _ZN6S496C53v51Ev();
extern void _ZN6S496C53v52Ev();
extern void _ZN6S496C53v53Ev();
extern void _ZN6S496C53v54Ev();
extern void _ZN6S496C53v55Ev();
extern void _ZN6S496C53v56Ev();
extern void _ZN6S496C53v57Ev();
extern void _ZN6S496C53v58Ev();
extern void _ZN6S496C53v59Ev();
extern void _ZN6S496C53v60Ev();
extern void _ZN6S496C53v61Ev();
extern void _ZN6S496C53v62Ev();
extern void _ZN6S496C53v63Ev();
extern void _ZN6S496C53v64Ev();
extern void _ZN6S496C53v65Ev();
extern void _ZN6S496C53v66Ev();
extern void _ZN6S496C53v67Ev();
extern void _ZN6S496C53v68Ev();
extern void _ZN6S496C53v69Ev();
extern void _ZN6S496C53v70Ev();
extern void _ZN6S496C53v71Ev();
extern void _ZN6S496C53v72Ev();
extern void _ZN6S496C53v73Ev();
extern void _ZN6S496C53v74Ev();
extern void _ZN6S496C53v75Ev();
extern void _ZN6S496C53v76Ev();
extern void _ZN6S496C53v77Ev();
extern void _ZN6S496C53v78Ev();
extern void _ZN6S496C53v79Ev();
extern void _ZN6S496C53v80Ev();
extern void _ZN6S496C43v81Ev();
extern void _ZN6S496C43v82Ev();
extern void _ZN6S496C43v83Ev();
extern void _ZN6S496C43v84Ev();
extern void _ZN6S496C43v85Ev();
extern void _ZN6S496C33v86Ev();
extern void _ZN6S496C33v87Ev();
extern void _ZN6S496C33v88Ev();
extern void _ZN6S496C33v89Ev();
extern void _ZN6S496C33v90Ev();
extern void _ZN6S496C33v91Ev();
extern void _ZN6S496C33v92Ev();
extern void _ZN6S496C33v93Ev();
extern void _ZN6S496C33v94Ev();
extern void _ZN6S496C33v95Ev();
extern void _ZN6S496C33v96Ev();
extern void _ZN6S496C33v97Ev();
extern void _ZN6S496C33v98Ev();
extern void _ZN6S496C33v99Ev();
extern void _ZN6S496C34v100Ev();
extern void _ZN6S496C34v101Ev();
extern void _ZN6S496C34v102Ev();
extern void _ZN6S496C34v103Ev();
extern void _ZN6S496C34v104Ev();
extern void _ZN6S496C34v105Ev();
extern void _ZN6S496C34v106Ev();
extern void _ZN6S496C34v107Ev();
static  VTBL_ENTRY vtc_S496C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S496C3[0]),
  (VTBL_ENTRY)&_ZN6S496C3D1Ev,
  (VTBL_ENTRY)&_ZN6S496C3D0Ev,
  (VTBL_ENTRY)&_ZN6S496C53v17Ev,
  (VTBL_ENTRY)&_ZN6S496C53v18Ev,
  (VTBL_ENTRY)&_ZN6S496C53v19Ev,
  (VTBL_ENTRY)&_ZN6S496C53v20Ev,
  (VTBL_ENTRY)&_ZN6S496C53v21Ev,
  (VTBL_ENTRY)&_ZN6S496C53v22Ev,
  (VTBL_ENTRY)&_ZN6S496C53v23Ev,
  (VTBL_ENTRY)&_ZN6S496C53v24Ev,
  (VTBL_ENTRY)&_ZN6S496C53v25Ev,
  (VTBL_ENTRY)&_ZN6S496C53v26Ev,
  (VTBL_ENTRY)&_ZN6S496C53v27Ev,
  (VTBL_ENTRY)&_ZN6S496C53v28Ev,
  (VTBL_ENTRY)&_ZN6S496C53v29Ev,
  (VTBL_ENTRY)&_ZN6S496C53v30Ev,
  (VTBL_ENTRY)&_ZN6S496C53v31Ev,
  (VTBL_ENTRY)&_ZN6S496C53v32Ev,
  (VTBL_ENTRY)&_ZN6S496C53v33Ev,
  (VTBL_ENTRY)&_ZN6S496C53v34Ev,
  (VTBL_ENTRY)&_ZN6S496C53v35Ev,
  (VTBL_ENTRY)&_ZN6S496C53v36Ev,
  (VTBL_ENTRY)&_ZN6S496C53v37Ev,
  (VTBL_ENTRY)&_ZN6S496C53v38Ev,
  (VTBL_ENTRY)&_ZN6S496C53v39Ev,
  (VTBL_ENTRY)&_ZN6S496C53v40Ev,
  (VTBL_ENTRY)&_ZN6S496C53v41Ev,
  (VTBL_ENTRY)&_ZN6S496C53v42Ev,
  (VTBL_ENTRY)&_ZN6S496C53v43Ev,
  (VTBL_ENTRY)&_ZN6S496C53v44Ev,
  (VTBL_ENTRY)&_ZN6S496C53v45Ev,
  (VTBL_ENTRY)&_ZN6S496C53v46Ev,
  (VTBL_ENTRY)&_ZN6S496C53v47Ev,
  (VTBL_ENTRY)&_ZN6S496C53v48Ev,
  (VTBL_ENTRY)&_ZN6S496C53v49Ev,
  (VTBL_ENTRY)&_ZN6S496C53v50Ev,
  (VTBL_ENTRY)&_ZN6S496C53v51Ev,
  (VTBL_ENTRY)&_ZN6S496C53v52Ev,
  (VTBL_ENTRY)&_ZN6S496C53v53Ev,
  (VTBL_ENTRY)&_ZN6S496C53v54Ev,
  (VTBL_ENTRY)&_ZN6S496C53v55Ev,
  (VTBL_ENTRY)&_ZN6S496C53v56Ev,
  (VTBL_ENTRY)&_ZN6S496C53v57Ev,
  (VTBL_ENTRY)&_ZN6S496C53v58Ev,
  (VTBL_ENTRY)&_ZN6S496C53v59Ev,
  (VTBL_ENTRY)&_ZN6S496C53v60Ev,
  (VTBL_ENTRY)&_ZN6S496C53v61Ev,
  (VTBL_ENTRY)&_ZN6S496C53v62Ev,
  (VTBL_ENTRY)&_ZN6S496C53v63Ev,
  (VTBL_ENTRY)&_ZN6S496C53v64Ev,
  (VTBL_ENTRY)&_ZN6S496C53v65Ev,
  (VTBL_ENTRY)&_ZN6S496C53v66Ev,
  (VTBL_ENTRY)&_ZN6S496C53v67Ev,
  (VTBL_ENTRY)&_ZN6S496C53v68Ev,
  (VTBL_ENTRY)&_ZN6S496C53v69Ev,
  (VTBL_ENTRY)&_ZN6S496C53v70Ev,
  (VTBL_ENTRY)&_ZN6S496C53v71Ev,
  (VTBL_ENTRY)&_ZN6S496C53v72Ev,
  (VTBL_ENTRY)&_ZN6S496C53v73Ev,
  (VTBL_ENTRY)&_ZN6S496C53v74Ev,
  (VTBL_ENTRY)&_ZN6S496C53v75Ev,
  (VTBL_ENTRY)&_ZN6S496C53v76Ev,
  (VTBL_ENTRY)&_ZN6S496C53v77Ev,
  (VTBL_ENTRY)&_ZN6S496C53v78Ev,
  (VTBL_ENTRY)&_ZN6S496C53v79Ev,
  (VTBL_ENTRY)&_ZN6S496C53v80Ev,
  (VTBL_ENTRY)&_ZN6S496C43v81Ev,
  (VTBL_ENTRY)&_ZN6S496C43v82Ev,
  (VTBL_ENTRY)&_ZN6S496C43v83Ev,
  (VTBL_ENTRY)&_ZN6S496C43v84Ev,
  (VTBL_ENTRY)&_ZN6S496C43v85Ev,
  (VTBL_ENTRY)&_ZN6S496C33v86Ev,
  (VTBL_ENTRY)&_ZN6S496C33v87Ev,
  (VTBL_ENTRY)&_ZN6S496C33v88Ev,
  (VTBL_ENTRY)&_ZN6S496C33v89Ev,
  (VTBL_ENTRY)&_ZN6S496C33v90Ev,
  (VTBL_ENTRY)&_ZN6S496C33v91Ev,
  (VTBL_ENTRY)&_ZN6S496C33v92Ev,
  (VTBL_ENTRY)&_ZN6S496C33v93Ev,
  (VTBL_ENTRY)&_ZN6S496C33v94Ev,
  (VTBL_ENTRY)&_ZN6S496C33v95Ev,
  (VTBL_ENTRY)&_ZN6S496C33v96Ev,
  (VTBL_ENTRY)&_ZN6S496C33v97Ev,
  (VTBL_ENTRY)&_ZN6S496C33v98Ev,
  (VTBL_ENTRY)&_ZN6S496C33v99Ev,
  (VTBL_ENTRY)&_ZN6S496C34v100Ev,
  (VTBL_ENTRY)&_ZN6S496C34v101Ev,
  (VTBL_ENTRY)&_ZN6S496C34v102Ev,
  (VTBL_ENTRY)&_ZN6S496C34v103Ev,
  (VTBL_ENTRY)&_ZN6S496C34v104Ev,
  (VTBL_ENTRY)&_ZN6S496C34v105Ev,
  (VTBL_ENTRY)&_ZN6S496C34v106Ev,
  (VTBL_ENTRY)&_ZN6S496C34v107Ev,
};
extern VTBL_ENTRY _ZTI6S496C3[];
extern  VTBL_ENTRY _ZTV6S496C3[];
Class_Descriptor cd_S496C3 = {  "S496C3", // class name
  bases_S496C3, 2,
  &(vtc_S496C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S496C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S496C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S496C2  : S496C3 {
  void *s496c2f0;
  ::S95C9_nt s496c2f1;
  int s496c2f2;
  ::S236C15_nt s496c2f3;
  int s496c2f4;
  ::S490C27 s496c2f5;
  int s496c2f6;
  void *s496c2f7[2];
  ::S95C13 s496c2f8;
  void *s496c2f9;
  int s496c2f10[2];
  char s496c2f11[3];
  int s496c2f12;
  unsigned int s496c2f13:1;
  unsigned int s496c2f14:1;
  unsigned int s496c2f15:1;
  unsigned int s496c2f16:1;
  unsigned int s496c2f17:1;
  unsigned int s496c2f18:1;
  unsigned int s496c2f19:1;
  unsigned int s496c2f20:1;
  unsigned int s496c2f21:1;
  unsigned int s496c2f22:1;
  unsigned int s496c2f23:1;
  unsigned int s496c2f24:1;
  unsigned int s496c2f25:1;
  unsigned int s496c2f26:1;
  int s496c2f27;
  unsigned int s496c2f28:1;
  unsigned int s496c2f29:1;
  unsigned int s496c2f30:1;
  unsigned int s496c2f31:1;
  unsigned int s496c2f32:1;
  unsigned int s496c2f33:1;
  ::S112C22_nt s496c2f34;
  unsigned int s496c2f35:1;
  unsigned int s496c2f36:1;
  unsigned int s496c2f37:1;
  unsigned int s496c2f38:1;
  unsigned int s496c2f39:1;
  unsigned int s496c2f40:1;
  unsigned int s496c2f41:1;
  char s496c2f42;
  ::S95C16 s496c2f43;
  unsigned int s496c2f44:1;
  unsigned int s496c2f45:1;
  unsigned int s496c2f46:1;
  unsigned int s496c2f47:1;
  unsigned int s496c2f48:1;
  unsigned int s496c2f49:1;
  unsigned int s496c2f50:1;
  unsigned int s496c2f51:1;
  unsigned int s496c2f52:1;
  unsigned int s496c2f53:1;
  unsigned int s496c2f54:1;
  unsigned int s496c2f55:1;
  ::S490C26 s496c2f56;
  void *s496c2f57[2];
  char s496c2f58;
  ::S236C15_nt s496c2f59;
  ::S236C18_nt s496c2f60;
  ::S95C14_nt s496c2f61;
  int s496c2f62;
  ::S236C18_nt s496c2f63;
  unsigned int s496c2f64:1;
  unsigned int s496c2f65:1;
  unsigned int s496c2f66:1;
  int s496c2f67[3];
  virtual  ~S496C2(); // _ZN6S496C2D1Ev
  virtual void  v108(); // _ZN6S496C24v108Ev
  virtual void  v109(); // _ZN6S496C24v109Ev
  virtual void  v110(); // _ZN6S496C24v110Ev
  virtual void  v111(); // _ZN6S496C24v111Ev
  virtual void  v112(); // _ZN6S496C24v112Ev
  virtual void  v113(); // _ZN6S496C24v113Ev
  virtual void  v114(); // _ZN6S496C24v114Ev
  virtual void  v115(); // _ZN6S496C24v115Ev
  virtual void  v116(); // _ZN6S496C24v116Ev
  virtual void  v117(); // _ZN6S496C24v117Ev
  virtual void  v118(); // _ZN6S496C24v118Ev
  virtual void  v119(); // _ZN6S496C24v119Ev
  virtual void  v120(); // _ZN6S496C24v120Ev
  virtual void  v121(); // _ZN6S496C24v121Ev
  virtual void  v122(); // _ZN6S496C24v122Ev
  virtual void  v123(); // _ZN6S496C24v123Ev
  virtual void  v124(); // _ZN6S496C24v124Ev
  virtual void  v125(); // _ZN6S496C24v125Ev
  virtual void  v126(); // _ZN6S496C24v126Ev
  virtual void  v127(); // _ZN6S496C24v127Ev
  virtual void  v128(); // _ZN6S496C24v128Ev
  virtual void  v129(); // _ZN6S496C24v129Ev
  virtual void  v130(); // _ZN6S496C24v130Ev
  virtual void  v131(); // _ZN6S496C24v131Ev
  virtual void  v132(); // _ZN6S496C24v132Ev
  virtual void  v133(); // _ZN6S496C24v133Ev
  virtual void  v134(); // _ZN6S496C24v134Ev
  virtual void  v135(); // _ZN6S496C24v135Ev
  virtual void  v136(); // _ZN6S496C24v136Ev
  virtual void  v137(); // _ZN6S496C24v137Ev
  virtual void  v138(); // _ZN6S496C24v138Ev
  virtual void  v139(); // _ZN6S496C24v139Ev
  virtual void  v140(); // _ZN6S496C24v140Ev
  virtual void  v141(); // _ZN6S496C24v141Ev
  virtual void  v142(); // _ZN6S496C24v142Ev
  virtual void  v143(); // _ZN6S496C24v143Ev
  virtual void  v144(); // _ZN6S496C24v144Ev
  virtual void  v145(); // _ZN6S496C24v145Ev
  virtual void  v146(); // _ZN6S496C24v146Ev
  virtual void  v147(); // _ZN6S496C24v147Ev
  virtual void  v148(); // _ZN6S496C24v148Ev
  virtual void  v149(); // _ZN6S496C24v149Ev
  virtual void  v150(); // _ZN6S496C24v150Ev
  virtual void  v151(); // _ZN6S496C24v151Ev
  virtual void  v152(); // _ZN6S496C24v152Ev
  virtual void  v153(); // _ZN6S496C24v153Ev
  virtual void  v154(); // _ZN6S496C24v154Ev
  virtual void  v155(); // _ZN6S496C24v155Ev
  virtual void  v156(); // _ZN6S496C24v156Ev
  virtual void  v157(); // _ZN6S496C24v157Ev
  virtual void  v158(); // _ZN6S496C24v158Ev
  virtual void  v159(); // _ZN6S496C24v159Ev
  virtual void  v160(); // _ZN6S496C24v160Ev
  virtual void  v161(); // _ZN6S496C24v161Ev
  virtual void  v162(); // _ZN6S496C24v162Ev
  virtual void  v163(); // _ZN6S496C24v163Ev
  virtual void  v164(); // _ZN6S496C24v164Ev
  virtual void  v165(); // _ZN6S496C24v165Ev
  virtual void  v166(); // _ZN6S496C24v166Ev
  virtual void  v167(); // _ZN6S496C24v167Ev
  virtual void  v168(); // _ZN6S496C24v168Ev
  S496C2(); // tgen
};
//SIG(-1 S496C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC8} Fp[2] Fc FC7 FC15{ m Fi[3]} FC11 Fi FC15 Fi:1 Fi:1 Fi:1 Fi[3]}


 S496C2 ::~S496C2(){ note_dtor("S496C2", this);}
void  S496C2 ::v108(){vfunc_called(this, "_ZN6S496C24v108Ev");}
void  S496C2 ::v109(){vfunc_called(this, "_ZN6S496C24v109Ev");}
void  S496C2 ::v110(){vfunc_called(this, "_ZN6S496C24v110Ev");}
void  S496C2 ::v111(){vfunc_called(this, "_ZN6S496C24v111Ev");}
void  S496C2 ::v112(){vfunc_called(this, "_ZN6S496C24v112Ev");}
void  S496C2 ::v113(){vfunc_called(this, "_ZN6S496C24v113Ev");}
void  S496C2 ::v114(){vfunc_called(this, "_ZN6S496C24v114Ev");}
void  S496C2 ::v115(){vfunc_called(this, "_ZN6S496C24v115Ev");}
void  S496C2 ::v116(){vfunc_called(this, "_ZN6S496C24v116Ev");}
void  S496C2 ::v117(){vfunc_called(this, "_ZN6S496C24v117Ev");}
void  S496C2 ::v118(){vfunc_called(this, "_ZN6S496C24v118Ev");}
void  S496C2 ::v119(){vfunc_called(this, "_ZN6S496C24v119Ev");}
void  S496C2 ::v120(){vfunc_called(this, "_ZN6S496C24v120Ev");}
void  S496C2 ::v121(){vfunc_called(this, "_ZN6S496C24v121Ev");}
void  S496C2 ::v122(){vfunc_called(this, "_ZN6S496C24v122Ev");}
void  S496C2 ::v123(){vfunc_called(this, "_ZN6S496C24v123Ev");}
void  S496C2 ::v124(){vfunc_called(this, "_ZN6S496C24v124Ev");}
void  S496C2 ::v125(){vfunc_called(this, "_ZN6S496C24v125Ev");}
void  S496C2 ::v126(){vfunc_called(this, "_ZN6S496C24v126Ev");}
void  S496C2 ::v127(){vfunc_called(this, "_ZN6S496C24v127Ev");}
void  S496C2 ::v128(){vfunc_called(this, "_ZN6S496C24v128Ev");}
void  S496C2 ::v129(){vfunc_called(this, "_ZN6S496C24v129Ev");}
void  S496C2 ::v130(){vfunc_called(this, "_ZN6S496C24v130Ev");}
void  S496C2 ::v131(){vfunc_called(this, "_ZN6S496C24v131Ev");}
void  S496C2 ::v132(){vfunc_called(this, "_ZN6S496C24v132Ev");}
void  S496C2 ::v133(){vfunc_called(this, "_ZN6S496C24v133Ev");}
void  S496C2 ::v134(){vfunc_called(this, "_ZN6S496C24v134Ev");}
void  S496C2 ::v135(){vfunc_called(this, "_ZN6S496C24v135Ev");}
void  S496C2 ::v136(){vfunc_called(this, "_ZN6S496C24v136Ev");}
void  S496C2 ::v137(){vfunc_called(this, "_ZN6S496C24v137Ev");}
void  S496C2 ::v138(){vfunc_called(this, "_ZN6S496C24v138Ev");}
void  S496C2 ::v139(){vfunc_called(this, "_ZN6S496C24v139Ev");}
void  S496C2 ::v140(){vfunc_called(this, "_ZN6S496C24v140Ev");}
void  S496C2 ::v141(){vfunc_called(this, "_ZN6S496C24v141Ev");}
void  S496C2 ::v142(){vfunc_called(this, "_ZN6S496C24v142Ev");}
void  S496C2 ::v143(){vfunc_called(this, "_ZN6S496C24v143Ev");}
void  S496C2 ::v144(){vfunc_called(this, "_ZN6S496C24v144Ev");}
void  S496C2 ::v145(){vfunc_called(this, "_ZN6S496C24v145Ev");}
void  S496C2 ::v146(){vfunc_called(this, "_ZN6S496C24v146Ev");}
void  S496C2 ::v147(){vfunc_called(this, "_ZN6S496C24v147Ev");}
void  S496C2 ::v148(){vfunc_called(this, "_ZN6S496C24v148Ev");}
void  S496C2 ::v149(){vfunc_called(this, "_ZN6S496C24v149Ev");}
void  S496C2 ::v150(){vfunc_called(this, "_ZN6S496C24v150Ev");}
void  S496C2 ::v151(){vfunc_called(this, "_ZN6S496C24v151Ev");}
void  S496C2 ::v152(){vfunc_called(this, "_ZN6S496C24v152Ev");}
void  S496C2 ::v153(){vfunc_called(this, "_ZN6S496C24v153Ev");}
void  S496C2 ::v154(){vfunc_called(this, "_ZN6S496C24v154Ev");}
void  S496C2 ::v155(){vfunc_called(this, "_ZN6S496C24v155Ev");}
void  S496C2 ::v156(){vfunc_called(this, "_ZN6S496C24v156Ev");}
void  S496C2 ::v157(){vfunc_called(this, "_ZN6S496C24v157Ev");}
void  S496C2 ::v158(){vfunc_called(this, "_ZN6S496C24v158Ev");}
void  S496C2 ::v159(){vfunc_called(this, "_ZN6S496C24v159Ev");}
void  S496C2 ::v160(){vfunc_called(this, "_ZN6S496C24v160Ev");}
void  S496C2 ::v161(){vfunc_called(this, "_ZN6S496C24v161Ev");}
void  S496C2 ::v162(){vfunc_called(this, "_ZN6S496C24v162Ev");}
void  S496C2 ::v163(){vfunc_called(this, "_ZN6S496C24v163Ev");}
void  S496C2 ::v164(){vfunc_called(this, "_ZN6S496C24v164Ev");}
void  S496C2 ::v165(){vfunc_called(this, "_ZN6S496C24v165Ev");}
void  S496C2 ::v166(){vfunc_called(this, "_ZN6S496C24v166Ev");}
void  S496C2 ::v167(){vfunc_called(this, "_ZN6S496C24v167Ev");}
void  S496C2 ::v168(){vfunc_called(this, "_ZN6S496C24v168Ev");}
S496C2 ::S496C2(){ note_ctor("S496C2", this);} // tgen

static void Test_S496C2()
{
  extern Class_Descriptor cd_S496C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S496C2, buf);
    S496C2 *dp, &lv = *(dp=new (buf) S496C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S496C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S496C2)");
    check_base_class_offset(lv, (S496C5*)(S496C4*)(S496C3*), 0, "S496C2");
    check_base_class_offset(lv, (S496C4*)(S496C3*), 0, "S496C2");
    check_base_class_offset(lv, (S496C3*), 0, "S496C2");
    check_field_offset(lv, s496c2f0, ABISELECT(136,84), "S496C2.s496c2f0");
    check_field_offset(lv, s496c2f1, ABISELECT(144,88), "S496C2.s496c2f1");
    check_field_offset(lv, s496c2f2, ABISELECT(148,92), "S496C2.s496c2f2");
    check_field_offset(lv, s496c2f3, ABISELECT(152,96), "S496C2.s496c2f3");
    check_field_offset(lv, s496c2f4, ABISELECT(156,100), "S496C2.s496c2f4");
    check_field_offset(lv, s496c2f5, ABISELECT(160,104), "S496C2.s496c2f5");
    check_field_offset(lv, s496c2f6, ABISELECT(176,116), "S496C2.s496c2f6");
    check_field_offset(lv, s496c2f7, ABISELECT(184,120), "S496C2.s496c2f7");
    check_field_offset(lv, s496c2f8, ABISELECT(200,128), "S496C2.s496c2f8");
    check_field_offset(lv, s496c2f9, ABISELECT(232,156), "S496C2.s496c2f9");
    check_field_offset(lv, s496c2f10, ABISELECT(240,160), "S496C2.s496c2f10");
    check_field_offset(lv, s496c2f11, ABISELECT(248,168), "S496C2.s496c2f11");
    check_field_offset(lv, s496c2f12, ABISELECT(252,172), "S496C2.s496c2f12");
    set_bf_and_test(lv, s496c2f13, ABISELECT(256,176), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f14, ABISELECT(256,176), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f15, ABISELECT(256,176), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f16, ABISELECT(256,176), 3, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f17, ABISELECT(256,176), 4, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f18, ABISELECT(256,176), 5, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f19, ABISELECT(256,176), 6, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f20, ABISELECT(256,176), 7, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f21, ABISELECT(257,177), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f22, ABISELECT(257,177), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f23, ABISELECT(257,177), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f24, ABISELECT(257,177), 3, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f25, ABISELECT(257,177), 4, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f26, ABISELECT(257,177), 5, 1, 1, "S496C2");
    check_field_offset(lv, s496c2f27, ABISELECT(260,180), "S496C2.s496c2f27");
    set_bf_and_test(lv, s496c2f28, ABISELECT(264,184), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f29, ABISELECT(264,184), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f30, ABISELECT(264,184), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f31, ABISELECT(264,184), 3, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f32, ABISELECT(264,184), 4, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f33, ABISELECT(264,184), 5, 1, 1, "S496C2");
    check_field_offset(lv, s496c2f34, ABISELECT(265,185), "S496C2.s496c2f34");
    set_bf_and_test(lv, s496c2f35, ABISELECT(266,186), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f36, ABISELECT(266,186), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f37, ABISELECT(266,186), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f38, ABISELECT(266,186), 3, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f39, ABISELECT(266,186), 4, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f40, ABISELECT(266,186), 5, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f41, ABISELECT(266,186), 6, 1, 1, "S496C2");
    check_field_offset(lv, s496c2f42, ABISELECT(267,187), "S496C2.s496c2f42");
    check_field_offset(lv, s496c2f43, ABISELECT(268,188), "S496C2.s496c2f43");
    set_bf_and_test(lv, s496c2f44, ABISELECT(269,189), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f45, ABISELECT(269,189), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f46, ABISELECT(269,189), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f47, ABISELECT(269,189), 3, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f48, ABISELECT(269,189), 4, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f49, ABISELECT(269,189), 5, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f50, ABISELECT(269,189), 6, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f51, ABISELECT(269,189), 7, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f52, ABISELECT(270,190), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f53, ABISELECT(270,190), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f54, ABISELECT(270,190), 2, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f55, ABISELECT(270,190), 3, 1, 1, "S496C2");
    check_field_offset(lv, s496c2f56, ABISELECT(272,192), "S496C2.s496c2f56");
    check_field_offset(lv, s496c2f57, ABISELECT(288,204), "S496C2.s496c2f57");
    check_field_offset(lv, s496c2f58, ABISELECT(304,212), "S496C2.s496c2f58");
    check_field_offset(lv, s496c2f59, ABISELECT(305,213), "S496C2.s496c2f59");
    check_field_offset(lv, s496c2f60, ABISELECT(308,216), "S496C2.s496c2f60");
    check_field_offset(lv, s496c2f61, ABISELECT(320,228), "S496C2.s496c2f61");
    check_field_offset(lv, s496c2f62, ABISELECT(332,240), "S496C2.s496c2f62");
    check_field_offset(lv, s496c2f63, ABISELECT(336,244), "S496C2.s496c2f63");
    set_bf_and_test(lv, s496c2f64, ABISELECT(348,256), 0, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f65, ABISELECT(348,256), 1, 1, 1, "S496C2");
    set_bf_and_test(lv, s496c2f66, ABISELECT(348,256), 2, 1, 1, "S496C2");
    check_field_offset(lv, s496c2f67, ABISELECT(352,260), "S496C2.s496c2f67");
    test_class_info(&lv, &cd_S496C2);
    dp->~S496C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS496C2(Test_S496C2, "S496C2", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S496C2C1Ev();
extern void _ZN6S496C2D1Ev();
Name_Map name_map_S496C2[] = {
  NSPAIR(_ZN6S496C2C1Ev),
  NSPAIR(_ZN6S496C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S496C5;
extern VTBL_ENTRY _ZTI6S496C5[];
extern  VTBL_ENTRY _ZTV6S496C5[];
extern Class_Descriptor cd_S496C4;
extern VTBL_ENTRY _ZTI6S496C4[];
extern  VTBL_ENTRY _ZTV6S496C4[];
extern Class_Descriptor cd_S496C3;
extern VTBL_ENTRY _ZTI6S496C3[];
extern  VTBL_ENTRY _ZTV6S496C3[];
static Base_Class bases_S496C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S496C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S496C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S496C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S496C2[];
extern void _ZN6S496C2D1Ev();
extern void _ZN6S496C2D0Ev();
extern void _ZN6S496C53v17Ev();
extern void _ZN6S496C53v18Ev();
extern void _ZN6S496C53v19Ev();
extern void _ZN6S496C53v20Ev();
extern void _ZN6S496C53v21Ev();
extern void _ZN6S496C53v22Ev();
extern void _ZN6S496C53v23Ev();
extern void _ZN6S496C53v24Ev();
extern void _ZN6S496C53v25Ev();
extern void _ZN6S496C53v26Ev();
extern void _ZN6S496C53v27Ev();
extern void _ZN6S496C53v28Ev();
extern void _ZN6S496C53v29Ev();
extern void _ZN6S496C53v30Ev();
extern void _ZN6S496C53v31Ev();
extern void _ZN6S496C53v32Ev();
extern void _ZN6S496C53v33Ev();
extern void _ZN6S496C53v34Ev();
extern void _ZN6S496C53v35Ev();
extern void _ZN6S496C53v36Ev();
extern void _ZN6S496C53v37Ev();
extern void _ZN6S496C53v38Ev();
extern void _ZN6S496C53v39Ev();
extern void _ZN6S496C53v40Ev();
extern void _ZN6S496C53v41Ev();
extern void _ZN6S496C53v42Ev();
extern void _ZN6S496C53v43Ev();
extern void _ZN6S496C53v44Ev();
extern void _ZN6S496C53v45Ev();
extern void _ZN6S496C53v46Ev();
extern void _ZN6S496C53v47Ev();
extern void _ZN6S496C53v48Ev();
extern void _ZN6S496C53v49Ev();
extern void _ZN6S496C53v50Ev();
extern void _ZN6S496C53v51Ev();
extern void _ZN6S496C53v52Ev();
extern void _ZN6S496C53v53Ev();
extern void _ZN6S496C53v54Ev();
extern void _ZN6S496C53v55Ev();
extern void _ZN6S496C53v56Ev();
extern void _ZN6S496C53v57Ev();
extern void _ZN6S496C53v58Ev();
extern void _ZN6S496C53v59Ev();
extern void _ZN6S496C53v60Ev();
extern void _ZN6S496C53v61Ev();
extern void _ZN6S496C53v62Ev();
extern void _ZN6S496C53v63Ev();
extern void _ZN6S496C53v64Ev();
extern void _ZN6S496C53v65Ev();
extern void _ZN6S496C53v66Ev();
extern void _ZN6S496C53v67Ev();
extern void _ZN6S496C53v68Ev();
extern void _ZN6S496C53v69Ev();
extern void _ZN6S496C53v70Ev();
extern void _ZN6S496C53v71Ev();
extern void _ZN6S496C53v72Ev();
extern void _ZN6S496C53v73Ev();
extern void _ZN6S496C53v74Ev();
extern void _ZN6S496C53v75Ev();
extern void _ZN6S496C53v76Ev();
extern void _ZN6S496C53v77Ev();
extern void _ZN6S496C53v78Ev();
extern void _ZN6S496C53v79Ev();
extern void _ZN6S496C53v80Ev();
extern void _ZN6S496C43v81Ev();
extern void _ZN6S496C43v82Ev();
extern void _ZN6S496C43v83Ev();
extern void _ZN6S496C43v84Ev();
extern void _ZN6S496C43v85Ev();
extern void _ZN6S496C33v86Ev();
extern void _ZN6S496C33v87Ev();
extern void _ZN6S496C33v88Ev();
extern void _ZN6S496C33v89Ev();
extern void _ZN6S496C33v90Ev();
extern void _ZN6S496C33v91Ev();
extern void _ZN6S496C33v92Ev();
extern void _ZN6S496C33v93Ev();
extern void _ZN6S496C33v94Ev();
extern void _ZN6S496C33v95Ev();
extern void _ZN6S496C33v96Ev();
extern void _ZN6S496C33v97Ev();
extern void _ZN6S496C33v98Ev();
extern void _ZN6S496C33v99Ev();
extern void _ZN6S496C34v100Ev();
extern void _ZN6S496C34v101Ev();
extern void _ZN6S496C34v102Ev();
extern void _ZN6S496C34v103Ev();
extern void _ZN6S496C34v104Ev();
extern void _ZN6S496C34v105Ev();
extern void _ZN6S496C34v106Ev();
extern void _ZN6S496C34v107Ev();
extern void _ZN6S496C24v108Ev();
extern void _ZN6S496C24v109Ev();
extern void _ZN6S496C24v110Ev();
extern void _ZN6S496C24v111Ev();
extern void _ZN6S496C24v112Ev();
extern void _ZN6S496C24v113Ev();
extern void _ZN6S496C24v114Ev();
extern void _ZN6S496C24v115Ev();
extern void _ZN6S496C24v116Ev();
extern void _ZN6S496C24v117Ev();
extern void _ZN6S496C24v118Ev();
extern void _ZN6S496C24v119Ev();
extern void _ZN6S496C24v120Ev();
extern void _ZN6S496C24v121Ev();
extern void _ZN6S496C24v122Ev();
extern void _ZN6S496C24v123Ev();
extern void _ZN6S496C24v124Ev();
extern void _ZN6S496C24v125Ev();
extern void _ZN6S496C24v126Ev();
extern void _ZN6S496C24v127Ev();
extern void _ZN6S496C24v128Ev();
extern void _ZN6S496C24v129Ev();
extern void _ZN6S496C24v130Ev();
extern void _ZN6S496C24v131Ev();
extern void _ZN6S496C24v132Ev();
extern void _ZN6S496C24v133Ev();
extern void _ZN6S496C24v134Ev();
extern void _ZN6S496C24v135Ev();
extern void _ZN6S496C24v136Ev();
extern void _ZN6S496C24v137Ev();
extern void _ZN6S496C24v138Ev();
extern void _ZN6S496C24v139Ev();
extern void _ZN6S496C24v140Ev();
extern void _ZN6S496C24v141Ev();
extern void _ZN6S496C24v142Ev();
extern void _ZN6S496C24v143Ev();
extern void _ZN6S496C24v144Ev();
extern void _ZN6S496C24v145Ev();
extern void _ZN6S496C24v146Ev();
extern void _ZN6S496C24v147Ev();
extern void _ZN6S496C24v148Ev();
extern void _ZN6S496C24v149Ev();
extern void _ZN6S496C24v150Ev();
extern void _ZN6S496C24v151Ev();
extern void _ZN6S496C24v152Ev();
extern void _ZN6S496C24v153Ev();
extern void _ZN6S496C24v154Ev();
extern void _ZN6S496C24v155Ev();
extern void _ZN6S496C24v156Ev();
extern void _ZN6S496C24v157Ev();
extern void _ZN6S496C24v158Ev();
extern void _ZN6S496C24v159Ev();
extern void _ZN6S496C24v160Ev();
extern void _ZN6S496C24v161Ev();
extern void _ZN6S496C24v162Ev();
extern void _ZN6S496C24v163Ev();
extern void _ZN6S496C24v164Ev();
extern void _ZN6S496C24v165Ev();
extern void _ZN6S496C24v166Ev();
extern void _ZN6S496C24v167Ev();
extern void _ZN6S496C24v168Ev();
static  VTBL_ENTRY vtc_S496C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S496C2[0]),
  (VTBL_ENTRY)&_ZN6S496C2D1Ev,
  (VTBL_ENTRY)&_ZN6S496C2D0Ev,
  (VTBL_ENTRY)&_ZN6S496C53v17Ev,
  (VTBL_ENTRY)&_ZN6S496C53v18Ev,
  (VTBL_ENTRY)&_ZN6S496C53v19Ev,
  (VTBL_ENTRY)&_ZN6S496C53v20Ev,
  (VTBL_ENTRY)&_ZN6S496C53v21Ev,
  (VTBL_ENTRY)&_ZN6S496C53v22Ev,
  (VTBL_ENTRY)&_ZN6S496C53v23Ev,
  (VTBL_ENTRY)&_ZN6S496C53v24Ev,
  (VTBL_ENTRY)&_ZN6S496C53v25Ev,
  (VTBL_ENTRY)&_ZN6S496C53v26Ev,
  (VTBL_ENTRY)&_ZN6S496C53v27Ev,
  (VTBL_ENTRY)&_ZN6S496C53v28Ev,
  (VTBL_ENTRY)&_ZN6S496C53v29Ev,
  (VTBL_ENTRY)&_ZN6S496C53v30Ev,
  (VTBL_ENTRY)&_ZN6S496C53v31Ev,
  (VTBL_ENTRY)&_ZN6S496C53v32Ev,
  (VTBL_ENTRY)&_ZN6S496C53v33Ev,
  (VTBL_ENTRY)&_ZN6S496C53v34Ev,
  (VTBL_ENTRY)&_ZN6S496C53v35Ev,
  (VTBL_ENTRY)&_ZN6S496C53v36Ev,
  (VTBL_ENTRY)&_ZN6S496C53v37Ev,
  (VTBL_ENTRY)&_ZN6S496C53v38Ev,
  (VTBL_ENTRY)&_ZN6S496C53v39Ev,
  (VTBL_ENTRY)&_ZN6S496C53v40Ev,
  (VTBL_ENTRY)&_ZN6S496C53v41Ev,
  (VTBL_ENTRY)&_ZN6S496C53v42Ev,
  (VTBL_ENTRY)&_ZN6S496C53v43Ev,
  (VTBL_ENTRY)&_ZN6S496C53v44Ev,
  (VTBL_ENTRY)&_ZN6S496C53v45Ev,
  (VTBL_ENTRY)&_ZN6S496C53v46Ev,
  (VTBL_ENTRY)&_ZN6S496C53v47Ev,
  (VTBL_ENTRY)&_ZN6S496C53v48Ev,
  (VTBL_ENTRY)&_ZN6S496C53v49Ev,
  (VTBL_ENTRY)&_ZN6S496C53v50Ev,
  (VTBL_ENTRY)&_ZN6S496C53v51Ev,
  (VTBL_ENTRY)&_ZN6S496C53v52Ev,
  (VTBL_ENTRY)&_ZN6S496C53v53Ev,
  (VTBL_ENTRY)&_ZN6S496C53v54Ev,
  (VTBL_ENTRY)&_ZN6S496C53v55Ev,
  (VTBL_ENTRY)&_ZN6S496C53v56Ev,
  (VTBL_ENTRY)&_ZN6S496C53v57Ev,
  (VTBL_ENTRY)&_ZN6S496C53v58Ev,
  (VTBL_ENTRY)&_ZN6S496C53v59Ev,
  (VTBL_ENTRY)&_ZN6S496C53v60Ev,
  (VTBL_ENTRY)&_ZN6S496C53v61Ev,
  (VTBL_ENTRY)&_ZN6S496C53v62Ev,
  (VTBL_ENTRY)&_ZN6S496C53v63Ev,
  (VTBL_ENTRY)&_ZN6S496C53v64Ev,
  (VTBL_ENTRY)&_ZN6S496C53v65Ev,
  (VTBL_ENTRY)&_ZN6S496C53v66Ev,
  (VTBL_ENTRY)&_ZN6S496C53v67Ev,
  (VTBL_ENTRY)&_ZN6S496C53v68Ev,
  (VTBL_ENTRY)&_ZN6S496C53v69Ev,
  (VTBL_ENTRY)&_ZN6S496C53v70Ev,
  (VTBL_ENTRY)&_ZN6S496C53v71Ev,
  (VTBL_ENTRY)&_ZN6S496C53v72Ev,
  (VTBL_ENTRY)&_ZN6S496C53v73Ev,
  (VTBL_ENTRY)&_ZN6S496C53v74Ev,
  (VTBL_ENTRY)&_ZN6S496C53v75Ev,
  (VTBL_ENTRY)&_ZN6S496C53v76Ev,
  (VTBL_ENTRY)&_ZN6S496C53v77Ev,
  (VTBL_ENTRY)&_ZN6S496C53v78Ev,
  (VTBL_ENTRY)&_ZN6S496C53v79Ev,
  (VTBL_ENTRY)&_ZN6S496C53v80Ev,
  (VTBL_ENTRY)&_ZN6S496C43v81Ev,
  (VTBL_ENTRY)&_ZN6S496C43v82Ev,
  (VTBL_ENTRY)&_ZN6S496C43v83Ev,
  (VTBL_ENTRY)&_ZN6S496C43v84Ev,
  (VTBL_ENTRY)&_ZN6S496C43v85Ev,
  (VTBL_ENTRY)&_ZN6S496C33v86Ev,
  (VTBL_ENTRY)&_ZN6S496C33v87Ev,
  (VTBL_ENTRY)&_ZN6S496C33v88Ev,
  (VTBL_ENTRY)&_ZN6S496C33v89Ev,
  (VTBL_ENTRY)&_ZN6S496C33v90Ev,
  (VTBL_ENTRY)&_ZN6S496C33v91Ev,
  (VTBL_ENTRY)&_ZN6S496C33v92Ev,
  (VTBL_ENTRY)&_ZN6S496C33v93Ev,
  (VTBL_ENTRY)&_ZN6S496C33v94Ev,
  (VTBL_ENTRY)&_ZN6S496C33v95Ev,
  (VTBL_ENTRY)&_ZN6S496C33v96Ev,
  (VTBL_ENTRY)&_ZN6S496C33v97Ev,
  (VTBL_ENTRY)&_ZN6S496C33v98Ev,
  (VTBL_ENTRY)&_ZN6S496C33v99Ev,
  (VTBL_ENTRY)&_ZN6S496C34v100Ev,
  (VTBL_ENTRY)&_ZN6S496C34v101Ev,
  (VTBL_ENTRY)&_ZN6S496C34v102Ev,
  (VTBL_ENTRY)&_ZN6S496C34v103Ev,
  (VTBL_ENTRY)&_ZN6S496C34v104Ev,
  (VTBL_ENTRY)&_ZN6S496C34v105Ev,
  (VTBL_ENTRY)&_ZN6S496C34v106Ev,
  (VTBL_ENTRY)&_ZN6S496C34v107Ev,
  (VTBL_ENTRY)&_ZN6S496C24v108Ev,
  (VTBL_ENTRY)&_ZN6S496C24v109Ev,
  (VTBL_ENTRY)&_ZN6S496C24v110Ev,
  (VTBL_ENTRY)&_ZN6S496C24v111Ev,
  (VTBL_ENTRY)&_ZN6S496C24v112Ev,
  (VTBL_ENTRY)&_ZN6S496C24v113Ev,
  (VTBL_ENTRY)&_ZN6S496C24v114Ev,
  (VTBL_ENTRY)&_ZN6S496C24v115Ev,
  (VTBL_ENTRY)&_ZN6S496C24v116Ev,
  (VTBL_ENTRY)&_ZN6S496C24v117Ev,
  (VTBL_ENTRY)&_ZN6S496C24v118Ev,
  (VTBL_ENTRY)&_ZN6S496C24v119Ev,
  (VTBL_ENTRY)&_ZN6S496C24v120Ev,
  (VTBL_ENTRY)&_ZN6S496C24v121Ev,
  (VTBL_ENTRY)&_ZN6S496C24v122Ev,
  (VTBL_ENTRY)&_ZN6S496C24v123Ev,
  (VTBL_ENTRY)&_ZN6S496C24v124Ev,
  (VTBL_ENTRY)&_ZN6S496C24v125Ev,
  (VTBL_ENTRY)&_ZN6S496C24v126Ev,
  (VTBL_ENTRY)&_ZN6S496C24v127Ev,
  (VTBL_ENTRY)&_ZN6S496C24v128Ev,
  (VTBL_ENTRY)&_ZN6S496C24v129Ev,
  (VTBL_ENTRY)&_ZN6S496C24v130Ev,
  (VTBL_ENTRY)&_ZN6S496C24v131Ev,
  (VTBL_ENTRY)&_ZN6S496C24v132Ev,
  (VTBL_ENTRY)&_ZN6S496C24v133Ev,
  (VTBL_ENTRY)&_ZN6S496C24v134Ev,
  (VTBL_ENTRY)&_ZN6S496C24v135Ev,
  (VTBL_ENTRY)&_ZN6S496C24v136Ev,
  (VTBL_ENTRY)&_ZN6S496C24v137Ev,
  (VTBL_ENTRY)&_ZN6S496C24v138Ev,
  (VTBL_ENTRY)&_ZN6S496C24v139Ev,
  (VTBL_ENTRY)&_ZN6S496C24v140Ev,
  (VTBL_ENTRY)&_ZN6S496C24v141Ev,
  (VTBL_ENTRY)&_ZN6S496C24v142Ev,
  (VTBL_ENTRY)&_ZN6S496C24v143Ev,
  (VTBL_ENTRY)&_ZN6S496C24v144Ev,
  (VTBL_ENTRY)&_ZN6S496C24v145Ev,
  (VTBL_ENTRY)&_ZN6S496C24v146Ev,
  (VTBL_ENTRY)&_ZN6S496C24v147Ev,
  (VTBL_ENTRY)&_ZN6S496C24v148Ev,
  (VTBL_ENTRY)&_ZN6S496C24v149Ev,
  (VTBL_ENTRY)&_ZN6S496C24v150Ev,
  (VTBL_ENTRY)&_ZN6S496C24v151Ev,
  (VTBL_ENTRY)&_ZN6S496C24v152Ev,
  (VTBL_ENTRY)&_ZN6S496C24v153Ev,
  (VTBL_ENTRY)&_ZN6S496C24v154Ev,
  (VTBL_ENTRY)&_ZN6S496C24v155Ev,
  (VTBL_ENTRY)&_ZN6S496C24v156Ev,
  (VTBL_ENTRY)&_ZN6S496C24v157Ev,
  (VTBL_ENTRY)&_ZN6S496C24v158Ev,
  (VTBL_ENTRY)&_ZN6S496C24v159Ev,
  (VTBL_ENTRY)&_ZN6S496C24v160Ev,
  (VTBL_ENTRY)&_ZN6S496C24v161Ev,
  (VTBL_ENTRY)&_ZN6S496C24v162Ev,
  (VTBL_ENTRY)&_ZN6S496C24v163Ev,
  (VTBL_ENTRY)&_ZN6S496C24v164Ev,
  (VTBL_ENTRY)&_ZN6S496C24v165Ev,
  (VTBL_ENTRY)&_ZN6S496C24v166Ev,
  (VTBL_ENTRY)&_ZN6S496C24v167Ev,
  (VTBL_ENTRY)&_ZN6S496C24v168Ev,
};
extern VTBL_ENTRY _ZTI6S496C2[];
extern  VTBL_ENTRY _ZTV6S496C2[];
Class_Descriptor cd_S496C2 = {  "S496C2", // class name
  bases_S496C2, 3,
  &(vtc_S496C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S496C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S496C2),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S496C1  : S496C2 {
  void *s496c1f0;
  int s496c1f1;
  short s496c1f2;
  ::S236C26 s496c1f3;
  ::S95C38 s496c1f4;
  ::S95C36 s496c1f5;
  virtual  ~S496C1(); // _ZN6S496C1D1Ev
  virtual void  v1(); // _ZN6S496C12v1Ev
  virtual void  v2(); // _ZN6S496C12v2Ev
  virtual void  v3(); // _ZN6S496C12v3Ev
  virtual void  v4(); // _ZN6S496C12v4Ev
  virtual void  v5(); // _ZN6S496C12v5Ev
  virtual void  v6(); // _ZN6S496C12v6Ev
  virtual void  v7(); // _ZN6S496C12v7Ev
  virtual void  v8(); // _ZN6S496C12v8Ev
  virtual void  v9(); // _ZN6S496C12v9Ev
  virtual void  v10(); // _ZN6S496C13v10Ev
  virtual void  v11(); // _ZN6S496C13v11Ev
  virtual void  v12(); // _ZN6S496C13v12Ev
  virtual void  v13(); // _ZN6S496C13v13Ev
  virtual void  v14(); // _ZN6S496C13v14Ev
  virtual void  v15(); // _ZN6S496C13v15Ev
  virtual void  v16(); // _ZN6S496C13v16Ev
  S496C1(); // tgen
};
//SIG(1 S496C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84 v85 Fp FC6} vd v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC14{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ BC9} Fp[2] Fc FC8 FC16{ m Fi[3]} FC12 Fi FC16 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fp Fi Fs FC17{ BC10} FC18{ BC10} FC19{ BC10}}


 S496C1 ::~S496C1(){ note_dtor("S496C1", this);}
void  S496C1 ::v1(){vfunc_called(this, "_ZN6S496C12v1Ev");}
void  S496C1 ::v2(){vfunc_called(this, "_ZN6S496C12v2Ev");}
void  S496C1 ::v3(){vfunc_called(this, "_ZN6S496C12v3Ev");}
void  S496C1 ::v4(){vfunc_called(this, "_ZN6S496C12v4Ev");}
void  S496C1 ::v5(){vfunc_called(this, "_ZN6S496C12v5Ev");}
void  S496C1 ::v6(){vfunc_called(this, "_ZN6S496C12v6Ev");}
void  S496C1 ::v7(){vfunc_called(this, "_ZN6S496C12v7Ev");}
void  S496C1 ::v8(){vfunc_called(this, "_ZN6S496C12v8Ev");}
void  S496C1 ::v9(){vfunc_called(this, "_ZN6S496C12v9Ev");}
void  S496C1 ::v10(){vfunc_called(this, "_ZN6S496C13v10Ev");}
void  S496C1 ::v11(){vfunc_called(this, "_ZN6S496C13v11Ev");}
void  S496C1 ::v12(){vfunc_called(this, "_ZN6S496C13v12Ev");}
void  S496C1 ::v13(){vfunc_called(this, "_ZN6S496C13v13Ev");}
void  S496C1 ::v14(){vfunc_called(this, "_ZN6S496C13v14Ev");}
void  S496C1 ::v15(){vfunc_called(this, "_ZN6S496C13v15Ev");}
void  S496C1 ::v16(){vfunc_called(this, "_ZN6S496C13v16Ev");}
S496C1 ::S496C1(){ note_ctor("S496C1", this);} // tgen

static void Test_S496C1()
{
  extern Class_Descriptor cd_S496C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,81)];
    init_test(&cd_S496C1, buf);
    S496C1 *dp, &lv = *(dp=new (buf) S496C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,320), "sizeof(S496C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S496C1)");
    check_base_class_offset(lv, (S496C5*)(S496C4*)(S496C3*)(S496C2*), 0, "S496C1");
    check_base_class_offset(lv, (S496C4*)(S496C3*)(S496C2*), 0, "S496C1");
    check_base_class_offset(lv, (S496C3*)(S496C2*), 0, "S496C1");
    check_base_class_offset(lv, (S496C2*), 0, "S496C1");
    check_field_offset(lv, s496c1f0, ABISELECT(368,272), "S496C1.s496c1f0");
    check_field_offset(lv, s496c1f1, ABISELECT(376,276), "S496C1.s496c1f1");
    check_field_offset(lv, s496c1f2, ABISELECT(380,280), "S496C1.s496c1f2");
    check_field_offset(lv, s496c1f3, ABISELECT(384,284), "S496C1.s496c1f3");
    check_field_offset(lv, s496c1f4, ABISELECT(400,296), "S496C1.s496c1f4");
    check_field_offset(lv, s496c1f5, ABISELECT(416,308), "S496C1.s496c1f5");
    test_class_info(&lv, &cd_S496C1);
    dp->~S496C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS496C1(Test_S496C1, "S496C1", ABISELECT(432,320));

#else // __cplusplus

extern void _ZN6S496C1C1Ev();
extern void _ZN6S496C1D1Ev();
Name_Map name_map_S496C1[] = {
  NSPAIR(_ZN6S496C1C1Ev),
  NSPAIR(_ZN6S496C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S496C5;
extern VTBL_ENTRY _ZTI6S496C5[];
extern  VTBL_ENTRY _ZTV6S496C5[];
extern Class_Descriptor cd_S496C4;
extern VTBL_ENTRY _ZTI6S496C4[];
extern  VTBL_ENTRY _ZTV6S496C4[];
extern Class_Descriptor cd_S496C3;
extern VTBL_ENTRY _ZTI6S496C3[];
extern  VTBL_ENTRY _ZTV6S496C3[];
extern Class_Descriptor cd_S496C2;
extern VTBL_ENTRY _ZTI6S496C2[];
extern  VTBL_ENTRY _ZTV6S496C2[];
static Base_Class bases_S496C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S496C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S496C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S496C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S496C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S496C1[];
extern void _ZN6S496C1D1Ev();
extern void _ZN6S496C1D0Ev();
extern void _ZN6S496C53v17Ev();
extern void _ZN6S496C53v18Ev();
extern void _ZN6S496C53v19Ev();
extern void _ZN6S496C53v20Ev();
extern void _ZN6S496C53v21Ev();
extern void _ZN6S496C53v22Ev();
extern void _ZN6S496C53v23Ev();
extern void _ZN6S496C53v24Ev();
extern void _ZN6S496C53v25Ev();
extern void _ZN6S496C53v26Ev();
extern void _ZN6S496C53v27Ev();
extern void _ZN6S496C53v28Ev();
extern void _ZN6S496C53v29Ev();
extern void _ZN6S496C53v30Ev();
extern void _ZN6S496C53v31Ev();
extern void _ZN6S496C53v32Ev();
extern void _ZN6S496C53v33Ev();
extern void _ZN6S496C53v34Ev();
extern void _ZN6S496C53v35Ev();
extern void _ZN6S496C53v36Ev();
extern void _ZN6S496C53v37Ev();
extern void _ZN6S496C53v38Ev();
extern void _ZN6S496C53v39Ev();
extern void _ZN6S496C53v40Ev();
extern void _ZN6S496C53v41Ev();
extern void _ZN6S496C53v42Ev();
extern void _ZN6S496C53v43Ev();
extern void _ZN6S496C53v44Ev();
extern void _ZN6S496C53v45Ev();
extern void _ZN6S496C53v46Ev();
extern void _ZN6S496C53v47Ev();
extern void _ZN6S496C53v48Ev();
extern void _ZN6S496C53v49Ev();
extern void _ZN6S496C53v50Ev();
extern void _ZN6S496C53v51Ev();
extern void _ZN6S496C53v52Ev();
extern void _ZN6S496C53v53Ev();
extern void _ZN6S496C53v54Ev();
extern void _ZN6S496C53v55Ev();
extern void _ZN6S496C53v56Ev();
extern void _ZN6S496C53v57Ev();
extern void _ZN6S496C53v58Ev();
extern void _ZN6S496C53v59Ev();
extern void _ZN6S496C53v60Ev();
extern void _ZN6S496C53v61Ev();
extern void _ZN6S496C53v62Ev();
extern void _ZN6S496C53v63Ev();
extern void _ZN6S496C53v64Ev();
extern void _ZN6S496C53v65Ev();
extern void _ZN6S496C53v66Ev();
extern void _ZN6S496C53v67Ev();
extern void _ZN6S496C53v68Ev();
extern void _ZN6S496C53v69Ev();
extern void _ZN6S496C53v70Ev();
extern void _ZN6S496C53v71Ev();
extern void _ZN6S496C53v72Ev();
extern void _ZN6S496C53v73Ev();
extern void _ZN6S496C53v74Ev();
extern void _ZN6S496C53v75Ev();
extern void _ZN6S496C53v76Ev();
extern void _ZN6S496C53v77Ev();
extern void _ZN6S496C53v78Ev();
extern void _ZN6S496C53v79Ev();
extern void _ZN6S496C53v80Ev();
extern void _ZN6S496C43v81Ev();
extern void _ZN6S496C43v82Ev();
extern void _ZN6S496C43v83Ev();
extern void _ZN6S496C43v84Ev();
extern void _ZN6S496C43v85Ev();
extern void _ZN6S496C33v86Ev();
extern void _ZN6S496C33v87Ev();
extern void _ZN6S496C33v88Ev();
extern void _ZN6S496C33v89Ev();
extern void _ZN6S496C33v90Ev();
extern void _ZN6S496C33v91Ev();
extern void _ZN6S496C33v92Ev();
extern void _ZN6S496C33v93Ev();
extern void _ZN6S496C33v94Ev();
extern void _ZN6S496C33v95Ev();
extern void _ZN6S496C33v96Ev();
extern void _ZN6S496C33v97Ev();
extern void _ZN6S496C33v98Ev();
extern void _ZN6S496C33v99Ev();
extern void _ZN6S496C34v100Ev();
extern void _ZN6S496C34v101Ev();
extern void _ZN6S496C34v102Ev();
extern void _ZN6S496C34v103Ev();
extern void _ZN6S496C34v104Ev();
extern void _ZN6S496C34v105Ev();
extern void _ZN6S496C34v106Ev();
extern void _ZN6S496C34v107Ev();
extern void _ZN6S496C24v108Ev();
extern void _ZN6S496C24v109Ev();
extern void _ZN6S496C24v110Ev();
extern void _ZN6S496C24v111Ev();
extern void _ZN6S496C24v112Ev();
extern void _ZN6S496C24v113Ev();
extern void _ZN6S496C24v114Ev();
extern void _ZN6S496C24v115Ev();
extern void _ZN6S496C24v116Ev();
extern void _ZN6S496C24v117Ev();
extern void _ZN6S496C24v118Ev();
extern void _ZN6S496C24v119Ev();
extern void _ZN6S496C24v120Ev();
extern void _ZN6S496C24v121Ev();
extern void _ZN6S496C24v122Ev();
extern void _ZN6S496C24v123Ev();
extern void _ZN6S496C24v124Ev();
extern void _ZN6S496C24v125Ev();
extern void _ZN6S496C24v126Ev();
extern void _ZN6S496C24v127Ev();
extern void _ZN6S496C24v128Ev();
extern void _ZN6S496C24v129Ev();
extern void _ZN6S496C24v130Ev();
extern void _ZN6S496C24v131Ev();
extern void _ZN6S496C24v132Ev();
extern void _ZN6S496C24v133Ev();
extern void _ZN6S496C24v134Ev();
extern void _ZN6S496C24v135Ev();
extern void _ZN6S496C24v136Ev();
extern void _ZN6S496C24v137Ev();
extern void _ZN6S496C24v138Ev();
extern void _ZN6S496C24v139Ev();
extern void _ZN6S496C24v140Ev();
extern void _ZN6S496C24v141Ev();
extern void _ZN6S496C24v142Ev();
extern void _ZN6S496C24v143Ev();
extern void _ZN6S496C24v144Ev();
extern void _ZN6S496C24v145Ev();
extern void _ZN6S496C24v146Ev();
extern void _ZN6S496C24v147Ev();
extern void _ZN6S496C24v148Ev();
extern void _ZN6S496C24v149Ev();
extern void _ZN6S496C24v150Ev();
extern void _ZN6S496C24v151Ev();
extern void _ZN6S496C24v152Ev();
extern void _ZN6S496C24v153Ev();
extern void _ZN6S496C24v154Ev();
extern void _ZN6S496C24v155Ev();
extern void _ZN6S496C24v156Ev();
extern void _ZN6S496C24v157Ev();
extern void _ZN6S496C24v158Ev();
extern void _ZN6S496C24v159Ev();
extern void _ZN6S496C24v160Ev();
extern void _ZN6S496C24v161Ev();
extern void _ZN6S496C24v162Ev();
extern void _ZN6S496C24v163Ev();
extern void _ZN6S496C24v164Ev();
extern void _ZN6S496C24v165Ev();
extern void _ZN6S496C24v166Ev();
extern void _ZN6S496C24v167Ev();
extern void _ZN6S496C24v168Ev();
extern void _ZN6S496C12v1Ev();
extern void _ZN6S496C12v2Ev();
extern void _ZN6S496C12v3Ev();
extern void _ZN6S496C12v4Ev();
extern void _ZN6S496C12v5Ev();
extern void _ZN6S496C12v6Ev();
extern void _ZN6S496C12v7Ev();
extern void _ZN6S496C12v8Ev();
extern void _ZN6S496C12v9Ev();
extern void _ZN6S496C13v10Ev();
extern void _ZN6S496C13v11Ev();
extern void _ZN6S496C13v12Ev();
extern void _ZN6S496C13v13Ev();
extern void _ZN6S496C13v14Ev();
extern void _ZN6S496C13v15Ev();
extern void _ZN6S496C13v16Ev();
static  VTBL_ENTRY vtc_S496C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S496C1[0]),
  (VTBL_ENTRY)&_ZN6S496C1D1Ev,
  (VTBL_ENTRY)&_ZN6S496C1D0Ev,
  (VTBL_ENTRY)&_ZN6S496C53v17Ev,
  (VTBL_ENTRY)&_ZN6S496C53v18Ev,
  (VTBL_ENTRY)&_ZN6S496C53v19Ev,
  (VTBL_ENTRY)&_ZN6S496C53v20Ev,
  (VTBL_ENTRY)&_ZN6S496C53v21Ev,
  (VTBL_ENTRY)&_ZN6S496C53v22Ev,
  (VTBL_ENTRY)&_ZN6S496C53v23Ev,
  (VTBL_ENTRY)&_ZN6S496C53v24Ev,
  (VTBL_ENTRY)&_ZN6S496C53v25Ev,
  (VTBL_ENTRY)&_ZN6S496C53v26Ev,
  (VTBL_ENTRY)&_ZN6S496C53v27Ev,
  (VTBL_ENTRY)&_ZN6S496C53v28Ev,
  (VTBL_ENTRY)&_ZN6S496C53v29Ev,
  (VTBL_ENTRY)&_ZN6S496C53v30Ev,
  (VTBL_ENTRY)&_ZN6S496C53v31Ev,
  (VTBL_ENTRY)&_ZN6S496C53v32Ev,
  (VTBL_ENTRY)&_ZN6S496C53v33Ev,
  (VTBL_ENTRY)&_ZN6S496C53v34Ev,
  (VTBL_ENTRY)&_ZN6S496C53v35Ev,
  (VTBL_ENTRY)&_ZN6S496C53v36Ev,
  (VTBL_ENTRY)&_ZN6S496C53v37Ev,
  (VTBL_ENTRY)&_ZN6S496C53v38Ev,
  (VTBL_ENTRY)&_ZN6S496C53v39Ev,
  (VTBL_ENTRY)&_ZN6S496C53v40Ev,
  (VTBL_ENTRY)&_ZN6S496C53v41Ev,
  (VTBL_ENTRY)&_ZN6S496C53v42Ev,
  (VTBL_ENTRY)&_ZN6S496C53v43Ev,
  (VTBL_ENTRY)&_ZN6S496C53v44Ev,
  (VTBL_ENTRY)&_ZN6S496C53v45Ev,
  (VTBL_ENTRY)&_ZN6S496C53v46Ev,
  (VTBL_ENTRY)&_ZN6S496C53v47Ev,
  (VTBL_ENTRY)&_ZN6S496C53v48Ev,
  (VTBL_ENTRY)&_ZN6S496C53v49Ev,
  (VTBL_ENTRY)&_ZN6S496C53v50Ev,
  (VTBL_ENTRY)&_ZN6S496C53v51Ev,
  (VTBL_ENTRY)&_ZN6S496C53v52Ev,
  (VTBL_ENTRY)&_ZN6S496C53v53Ev,
  (VTBL_ENTRY)&_ZN6S496C53v54Ev,
  (VTBL_ENTRY)&_ZN6S496C53v55Ev,
  (VTBL_ENTRY)&_ZN6S496C53v56Ev,
  (VTBL_ENTRY)&_ZN6S496C53v57Ev,
  (VTBL_ENTRY)&_ZN6S496C53v58Ev,
  (VTBL_ENTRY)&_ZN6S496C53v59Ev,
  (VTBL_ENTRY)&_ZN6S496C53v60Ev,
  (VTBL_ENTRY)&_ZN6S496C53v61Ev,
  (VTBL_ENTRY)&_ZN6S496C53v62Ev,
  (VTBL_ENTRY)&_ZN6S496C53v63Ev,
  (VTBL_ENTRY)&_ZN6S496C53v64Ev,
  (VTBL_ENTRY)&_ZN6S496C53v65Ev,
  (VTBL_ENTRY)&_ZN6S496C53v66Ev,
  (VTBL_ENTRY)&_ZN6S496C53v67Ev,
  (VTBL_ENTRY)&_ZN6S496C53v68Ev,
  (VTBL_ENTRY)&_ZN6S496C53v69Ev,
  (VTBL_ENTRY)&_ZN6S496C53v70Ev,
  (VTBL_ENTRY)&_ZN6S496C53v71Ev,
  (VTBL_ENTRY)&_ZN6S496C53v72Ev,
  (VTBL_ENTRY)&_ZN6S496C53v73Ev,
  (VTBL_ENTRY)&_ZN6S496C53v74Ev,
  (VTBL_ENTRY)&_ZN6S496C53v75Ev,
  (VTBL_ENTRY)&_ZN6S496C53v76Ev,
  (VTBL_ENTRY)&_ZN6S496C53v77Ev,
  (VTBL_ENTRY)&_ZN6S496C53v78Ev,
  (VTBL_ENTRY)&_ZN6S496C53v79Ev,
  (VTBL_ENTRY)&_ZN6S496C53v80Ev,
  (VTBL_ENTRY)&_ZN6S496C43v81Ev,
  (VTBL_ENTRY)&_ZN6S496C43v82Ev,
  (VTBL_ENTRY)&_ZN6S496C43v83Ev,
  (VTBL_ENTRY)&_ZN6S496C43v84Ev,
  (VTBL_ENTRY)&_ZN6S496C43v85Ev,
  (VTBL_ENTRY)&_ZN6S496C33v86Ev,
  (VTBL_ENTRY)&_ZN6S496C33v87Ev,
  (VTBL_ENTRY)&_ZN6S496C33v88Ev,
  (VTBL_ENTRY)&_ZN6S496C33v89Ev,
  (VTBL_ENTRY)&_ZN6S496C33v90Ev,
  (VTBL_ENTRY)&_ZN6S496C33v91Ev,
  (VTBL_ENTRY)&_ZN6S496C33v92Ev,
  (VTBL_ENTRY)&_ZN6S496C33v93Ev,
  (VTBL_ENTRY)&_ZN6S496C33v94Ev,
  (VTBL_ENTRY)&_ZN6S496C33v95Ev,
  (VTBL_ENTRY)&_ZN6S496C33v96Ev,
  (VTBL_ENTRY)&_ZN6S496C33v97Ev,
  (VTBL_ENTRY)&_ZN6S496C33v98Ev,
  (VTBL_ENTRY)&_ZN6S496C33v99Ev,
  (VTBL_ENTRY)&_ZN6S496C34v100Ev,
  (VTBL_ENTRY)&_ZN6S496C34v101Ev,
  (VTBL_ENTRY)&_ZN6S496C34v102Ev,
  (VTBL_ENTRY)&_ZN6S496C34v103Ev,
  (VTBL_ENTRY)&_ZN6S496C34v104Ev,
  (VTBL_ENTRY)&_ZN6S496C34v105Ev,
  (VTBL_ENTRY)&_ZN6S496C34v106Ev,
  (VTBL_ENTRY)&_ZN6S496C34v107Ev,
  (VTBL_ENTRY)&_ZN6S496C24v108Ev,
  (VTBL_ENTRY)&_ZN6S496C24v109Ev,
  (VTBL_ENTRY)&_ZN6S496C24v110Ev,
  (VTBL_ENTRY)&_ZN6S496C24v111Ev,
  (VTBL_ENTRY)&_ZN6S496C24v112Ev,
  (VTBL_ENTRY)&_ZN6S496C24v113Ev,
  (VTBL_ENTRY)&_ZN6S496C24v114Ev,
  (VTBL_ENTRY)&_ZN6S496C24v115Ev,
  (VTBL_ENTRY)&_ZN6S496C24v116Ev,
  (VTBL_ENTRY)&_ZN6S496C24v117Ev,
  (VTBL_ENTRY)&_ZN6S496C24v118Ev,
  (VTBL_ENTRY)&_ZN6S496C24v119Ev,
  (VTBL_ENTRY)&_ZN6S496C24v120Ev,
  (VTBL_ENTRY)&_ZN6S496C24v121Ev,
  (VTBL_ENTRY)&_ZN6S496C24v122Ev,
  (VTBL_ENTRY)&_ZN6S496C24v123Ev,
  (VTBL_ENTRY)&_ZN6S496C24v124Ev,
  (VTBL_ENTRY)&_ZN6S496C24v125Ev,
  (VTBL_ENTRY)&_ZN6S496C24v126Ev,
  (VTBL_ENTRY)&_ZN6S496C24v127Ev,
  (VTBL_ENTRY)&_ZN6S496C24v128Ev,
  (VTBL_ENTRY)&_ZN6S496C24v129Ev,
  (VTBL_ENTRY)&_ZN6S496C24v130Ev,
  (VTBL_ENTRY)&_ZN6S496C24v131Ev,
  (VTBL_ENTRY)&_ZN6S496C24v132Ev,
  (VTBL_ENTRY)&_ZN6S496C24v133Ev,
  (VTBL_ENTRY)&_ZN6S496C24v134Ev,
  (VTBL_ENTRY)&_ZN6S496C24v135Ev,
  (VTBL_ENTRY)&_ZN6S496C24v136Ev,
  (VTBL_ENTRY)&_ZN6S496C24v137Ev,
  (VTBL_ENTRY)&_ZN6S496C24v138Ev,
  (VTBL_ENTRY)&_ZN6S496C24v139Ev,
  (VTBL_ENTRY)&_ZN6S496C24v140Ev,
  (VTBL_ENTRY)&_ZN6S496C24v141Ev,
  (VTBL_ENTRY)&_ZN6S496C24v142Ev,
  (VTBL_ENTRY)&_ZN6S496C24v143Ev,
  (VTBL_ENTRY)&_ZN6S496C24v144Ev,
  (VTBL_ENTRY)&_ZN6S496C24v145Ev,
  (VTBL_ENTRY)&_ZN6S496C24v146Ev,
  (VTBL_ENTRY)&_ZN6S496C24v147Ev,
  (VTBL_ENTRY)&_ZN6S496C24v148Ev,
  (VTBL_ENTRY)&_ZN6S496C24v149Ev,
  (VTBL_ENTRY)&_ZN6S496C24v150Ev,
  (VTBL_ENTRY)&_ZN6S496C24v151Ev,
  (VTBL_ENTRY)&_ZN6S496C24v152Ev,
  (VTBL_ENTRY)&_ZN6S496C24v153Ev,
  (VTBL_ENTRY)&_ZN6S496C24v154Ev,
  (VTBL_ENTRY)&_ZN6S496C24v155Ev,
  (VTBL_ENTRY)&_ZN6S496C24v156Ev,
  (VTBL_ENTRY)&_ZN6S496C24v157Ev,
  (VTBL_ENTRY)&_ZN6S496C24v158Ev,
  (VTBL_ENTRY)&_ZN6S496C24v159Ev,
  (VTBL_ENTRY)&_ZN6S496C24v160Ev,
  (VTBL_ENTRY)&_ZN6S496C24v161Ev,
  (VTBL_ENTRY)&_ZN6S496C24v162Ev,
  (VTBL_ENTRY)&_ZN6S496C24v163Ev,
  (VTBL_ENTRY)&_ZN6S496C24v164Ev,
  (VTBL_ENTRY)&_ZN6S496C24v165Ev,
  (VTBL_ENTRY)&_ZN6S496C24v166Ev,
  (VTBL_ENTRY)&_ZN6S496C24v167Ev,
  (VTBL_ENTRY)&_ZN6S496C24v168Ev,
  (VTBL_ENTRY)&_ZN6S496C12v1Ev,
  (VTBL_ENTRY)&_ZN6S496C12v2Ev,
  (VTBL_ENTRY)&_ZN6S496C12v3Ev,
  (VTBL_ENTRY)&_ZN6S496C12v4Ev,
  (VTBL_ENTRY)&_ZN6S496C12v5Ev,
  (VTBL_ENTRY)&_ZN6S496C12v6Ev,
  (VTBL_ENTRY)&_ZN6S496C12v7Ev,
  (VTBL_ENTRY)&_ZN6S496C12v8Ev,
  (VTBL_ENTRY)&_ZN6S496C12v9Ev,
  (VTBL_ENTRY)&_ZN6S496C13v10Ev,
  (VTBL_ENTRY)&_ZN6S496C13v11Ev,
  (VTBL_ENTRY)&_ZN6S496C13v12Ev,
  (VTBL_ENTRY)&_ZN6S496C13v13Ev,
  (VTBL_ENTRY)&_ZN6S496C13v14Ev,
  (VTBL_ENTRY)&_ZN6S496C13v15Ev,
  (VTBL_ENTRY)&_ZN6S496C13v16Ev,
};
extern VTBL_ENTRY _ZTI6S496C1[];
extern  VTBL_ENTRY _ZTV6S496C1[];
Class_Descriptor cd_S496C1 = {  "S496C1", // class name
  bases_S496C1, 4,
  &(vtc_S496C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,320), // object size
  NSPAIRA(_ZTI6S496C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S496C1),172, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S689C5  {
  int s689c5f0;
  __tsi64 s689c5f1;
  void *s689c5f2[4];
  int s689c5f3[2];
  void *s689c5f4;
  ::S95C8_nt s689c5f5;
  void *s689c5f6[2];
  virtual  ~S689C5(); // _ZN6S689C5D1Ev
  virtual void  v7(); // _ZN6S689C52v7Ev
  virtual void  v8(); // _ZN6S689C52v8Ev
  virtual void  v9(); // _ZN6S689C52v9Ev
  virtual void  v10(); // _ZN6S689C53v10Ev
  virtual void  v11(); // _ZN6S689C53v11Ev
  virtual void  v12(); // _ZN6S689C53v12Ev
  virtual void  v13(); // _ZN6S689C53v13Ev
  virtual void  v14(); // _ZN6S689C53v14Ev
  virtual void  v15(); // _ZN6S689C53v15Ev
  virtual void  v16(); // _ZN6S689C53v16Ev
  virtual void  v17(); // _ZN6S689C53v17Ev
  virtual void  v18(); // _ZN6S689C53v18Ev
  virtual void  v19(); // _ZN6S689C53v19Ev
  virtual void  v20(); // _ZN6S689C53v20Ev
  virtual void  v21(); // _ZN6S689C53v21Ev
  virtual void  v22(); // _ZN6S689C53v22Ev
  virtual void  v23(); // _ZN6S689C53v23Ev
  virtual void  v24(); // _ZN6S689C53v24Ev
  virtual void  v25(); // _ZN6S689C53v25Ev
  virtual void  v26(); // _ZN6S689C53v26Ev
  virtual void  v27(); // _ZN6S689C53v27Ev
  virtual void  v28(); // _ZN6S689C53v28Ev
  virtual void  v29(); // _ZN6S689C53v29Ev
  virtual void  v30(); // _ZN6S689C53v30Ev
  virtual void  v31(); // _ZN6S689C53v31Ev
  virtual void  v32(); // _ZN6S689C53v32Ev
  virtual void  v33(); // _ZN6S689C53v33Ev
  virtual void  v34(); // _ZN6S689C53v34Ev
  virtual void  v35(); // _ZN6S689C53v35Ev
  virtual void  v36(); // _ZN6S689C53v36Ev
  virtual void  v37(); // _ZN6S689C53v37Ev
  virtual void  v38(); // _ZN6S689C53v38Ev
  virtual void  v39(); // _ZN6S689C53v39Ev
  virtual void  v40(); // _ZN6S689C53v40Ev
  virtual void  v41(); // _ZN6S689C53v41Ev
  virtual void  v42(); // _ZN6S689C53v42Ev
  virtual void  v43(); // _ZN6S689C53v43Ev
  virtual void  v44(); // _ZN6S689C53v44Ev
  virtual void  v45(); // _ZN6S689C53v45Ev
  virtual void  v46(); // _ZN6S689C53v46Ev
  virtual void  v47(); // _ZN6S689C53v47Ev
  virtual void  v48(); // _ZN6S689C53v48Ev
  virtual void  v49(); // _ZN6S689C53v49Ev
  virtual void  v50(); // _ZN6S689C53v50Ev
  virtual void  v51(); // _ZN6S689C53v51Ev
  virtual void  v52(); // _ZN6S689C53v52Ev
  virtual void  v53(); // _ZN6S689C53v53Ev
  virtual void  v54(); // _ZN6S689C53v54Ev
  virtual void  v55(); // _ZN6S689C53v55Ev
  virtual void  v56(); // _ZN6S689C53v56Ev
  virtual void  v57(); // _ZN6S689C53v57Ev
  virtual void  v58(); // _ZN6S689C53v58Ev
  virtual void  v59(); // _ZN6S689C53v59Ev
  virtual void  v60(); // _ZN6S689C53v60Ev
  virtual void  v61(); // _ZN6S689C53v61Ev
  virtual void  v62(); // _ZN6S689C53v62Ev
  virtual void  v63(); // _ZN6S689C53v63Ev
  virtual void  v64(); // _ZN6S689C53v64Ev
  virtual void  v65(); // _ZN6S689C53v65Ev
  virtual void  v66(); // _ZN6S689C53v66Ev
  virtual void  v67(); // _ZN6S689C53v67Ev
  virtual void  v68(); // _ZN6S689C53v68Ev
  virtual void  v69(); // _ZN6S689C53v69Ev
  virtual void  v70(); // _ZN6S689C53v70Ev
  S689C5(); // tgen
};
//SIG(-1 S689C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S689C5 ::~S689C5(){ note_dtor("S689C5", this);}
void  S689C5 ::v7(){vfunc_called(this, "_ZN6S689C52v7Ev");}
void  S689C5 ::v8(){vfunc_called(this, "_ZN6S689C52v8Ev");}
void  S689C5 ::v9(){vfunc_called(this, "_ZN6S689C52v9Ev");}
void  S689C5 ::v10(){vfunc_called(this, "_ZN6S689C53v10Ev");}
void  S689C5 ::v11(){vfunc_called(this, "_ZN6S689C53v11Ev");}
void  S689C5 ::v12(){vfunc_called(this, "_ZN6S689C53v12Ev");}
void  S689C5 ::v13(){vfunc_called(this, "_ZN6S689C53v13Ev");}
void  S689C5 ::v14(){vfunc_called(this, "_ZN6S689C53v14Ev");}
void  S689C5 ::v15(){vfunc_called(this, "_ZN6S689C53v15Ev");}
void  S689C5 ::v16(){vfunc_called(this, "_ZN6S689C53v16Ev");}
void  S689C5 ::v17(){vfunc_called(this, "_ZN6S689C53v17Ev");}
void  S689C5 ::v18(){vfunc_called(this, "_ZN6S689C53v18Ev");}
void  S689C5 ::v19(){vfunc_called(this, "_ZN6S689C53v19Ev");}
void  S689C5 ::v20(){vfunc_called(this, "_ZN6S689C53v20Ev");}
void  S689C5 ::v21(){vfunc_called(this, "_ZN6S689C53v21Ev");}
void  S689C5 ::v22(){vfunc_called(this, "_ZN6S689C53v22Ev");}
void  S689C5 ::v23(){vfunc_called(this, "_ZN6S689C53v23Ev");}
void  S689C5 ::v24(){vfunc_called(this, "_ZN6S689C53v24Ev");}
void  S689C5 ::v25(){vfunc_called(this, "_ZN6S689C53v25Ev");}
void  S689C5 ::v26(){vfunc_called(this, "_ZN6S689C53v26Ev");}
void  S689C5 ::v27(){vfunc_called(this, "_ZN6S689C53v27Ev");}
void  S689C5 ::v28(){vfunc_called(this, "_ZN6S689C53v28Ev");}
void  S689C5 ::v29(){vfunc_called(this, "_ZN6S689C53v29Ev");}
void  S689C5 ::v30(){vfunc_called(this, "_ZN6S689C53v30Ev");}
void  S689C5 ::v31(){vfunc_called(this, "_ZN6S689C53v31Ev");}
void  S689C5 ::v32(){vfunc_called(this, "_ZN6S689C53v32Ev");}
void  S689C5 ::v33(){vfunc_called(this, "_ZN6S689C53v33Ev");}
void  S689C5 ::v34(){vfunc_called(this, "_ZN6S689C53v34Ev");}
void  S689C5 ::v35(){vfunc_called(this, "_ZN6S689C53v35Ev");}
void  S689C5 ::v36(){vfunc_called(this, "_ZN6S689C53v36Ev");}
void  S689C5 ::v37(){vfunc_called(this, "_ZN6S689C53v37Ev");}
void  S689C5 ::v38(){vfunc_called(this, "_ZN6S689C53v38Ev");}
void  S689C5 ::v39(){vfunc_called(this, "_ZN6S689C53v39Ev");}
void  S689C5 ::v40(){vfunc_called(this, "_ZN6S689C53v40Ev");}
void  S689C5 ::v41(){vfunc_called(this, "_ZN6S689C53v41Ev");}
void  S689C5 ::v42(){vfunc_called(this, "_ZN6S689C53v42Ev");}
void  S689C5 ::v43(){vfunc_called(this, "_ZN6S689C53v43Ev");}
void  S689C5 ::v44(){vfunc_called(this, "_ZN6S689C53v44Ev");}
void  S689C5 ::v45(){vfunc_called(this, "_ZN6S689C53v45Ev");}
void  S689C5 ::v46(){vfunc_called(this, "_ZN6S689C53v46Ev");}
void  S689C5 ::v47(){vfunc_called(this, "_ZN6S689C53v47Ev");}
void  S689C5 ::v48(){vfunc_called(this, "_ZN6S689C53v48Ev");}
void  S689C5 ::v49(){vfunc_called(this, "_ZN6S689C53v49Ev");}
void  S689C5 ::v50(){vfunc_called(this, "_ZN6S689C53v50Ev");}
void  S689C5 ::v51(){vfunc_called(this, "_ZN6S689C53v51Ev");}
void  S689C5 ::v52(){vfunc_called(this, "_ZN6S689C53v52Ev");}
void  S689C5 ::v53(){vfunc_called(this, "_ZN6S689C53v53Ev");}
void  S689C5 ::v54(){vfunc_called(this, "_ZN6S689C53v54Ev");}
void  S689C5 ::v55(){vfunc_called(this, "_ZN6S689C53v55Ev");}
void  S689C5 ::v56(){vfunc_called(this, "_ZN6S689C53v56Ev");}
void  S689C5 ::v57(){vfunc_called(this, "_ZN6S689C53v57Ev");}
void  S689C5 ::v58(){vfunc_called(this, "_ZN6S689C53v58Ev");}
void  S689C5 ::v59(){vfunc_called(this, "_ZN6S689C53v59Ev");}
void  S689C5 ::v60(){vfunc_called(this, "_ZN6S689C53v60Ev");}
void  S689C5 ::v61(){vfunc_called(this, "_ZN6S689C53v61Ev");}
void  S689C5 ::v62(){vfunc_called(this, "_ZN6S689C53v62Ev");}
void  S689C5 ::v63(){vfunc_called(this, "_ZN6S689C53v63Ev");}
void  S689C5 ::v64(){vfunc_called(this, "_ZN6S689C53v64Ev");}
void  S689C5 ::v65(){vfunc_called(this, "_ZN6S689C53v65Ev");}
void  S689C5 ::v66(){vfunc_called(this, "_ZN6S689C53v66Ev");}
void  S689C5 ::v67(){vfunc_called(this, "_ZN6S689C53v67Ev");}
void  S689C5 ::v68(){vfunc_called(this, "_ZN6S689C53v68Ev");}
void  S689C5 ::v69(){vfunc_called(this, "_ZN6S689C53v69Ev");}
void  S689C5 ::v70(){vfunc_called(this, "_ZN6S689C53v70Ev");}
S689C5 ::S689C5(){ note_ctor("S689C5", this);} // tgen

static void Test_S689C5()
{
  extern Class_Descriptor cd_S689C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S689C5, buf);
    S689C5 *dp, &lv = *(dp=new (buf) S689C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S689C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S689C5)");
    check_field_offset(lv, s689c5f0, ABISELECT(8,4), "S689C5.s689c5f0");
    check_field_offset(lv, s689c5f1, ABISELECT(16,8), "S689C5.s689c5f1");
    check_field_offset(lv, s689c5f2, ABISELECT(24,16), "S689C5.s689c5f2");
    check_field_offset(lv, s689c5f3, ABISELECT(56,32), "S689C5.s689c5f3");
    check_field_offset(lv, s689c5f4, ABISELECT(64,40), "S689C5.s689c5f4");
    check_field_offset(lv, s689c5f5, ABISELECT(72,44), "S689C5.s689c5f5");
    check_field_offset(lv, s689c5f6, ABISELECT(80,52), "S689C5.s689c5f6");
    test_class_info(&lv, &cd_S689C5);
    dp->~S689C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS689C5(Test_S689C5, "S689C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S689C5C1Ev();
extern void _ZN6S689C5D1Ev();
Name_Map name_map_S689C5[] = {
  NSPAIR(_ZN6S689C5C1Ev),
  NSPAIR(_ZN6S689C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S689C5[];
extern void _ZN6S689C5D1Ev();
extern void _ZN6S689C5D0Ev();
extern void _ZN6S689C52v7Ev();
extern void _ZN6S689C52v8Ev();
extern void _ZN6S689C52v9Ev();
extern void _ZN6S689C53v10Ev();
extern void _ZN6S689C53v11Ev();
extern void _ZN6S689C53v12Ev();
extern void _ZN6S689C53v13Ev();
extern void _ZN6S689C53v14Ev();
extern void _ZN6S689C53v15Ev();
extern void _ZN6S689C53v16Ev();
extern void _ZN6S689C53v17Ev();
extern void _ZN6S689C53v18Ev();
extern void _ZN6S689C53v19Ev();
extern void _ZN6S689C53v20Ev();
extern void _ZN6S689C53v21Ev();
extern void _ZN6S689C53v22Ev();
extern void _ZN6S689C53v23Ev();
extern void _ZN6S689C53v24Ev();
extern void _ZN6S689C53v25Ev();
extern void _ZN6S689C53v26Ev();
extern void _ZN6S689C53v27Ev();
extern void _ZN6S689C53v28Ev();
extern void _ZN6S689C53v29Ev();
extern void _ZN6S689C53v30Ev();
extern void _ZN6S689C53v31Ev();
extern void _ZN6S689C53v32Ev();
extern void _ZN6S689C53v33Ev();
extern void _ZN6S689C53v34Ev();
extern void _ZN6S689C53v35Ev();
extern void _ZN6S689C53v36Ev();
extern void _ZN6S689C53v37Ev();
extern void _ZN6S689C53v38Ev();
extern void _ZN6S689C53v39Ev();
extern void _ZN6S689C53v40Ev();
extern void _ZN6S689C53v41Ev();
extern void _ZN6S689C53v42Ev();
extern void _ZN6S689C53v43Ev();
extern void _ZN6S689C53v44Ev();
extern void _ZN6S689C53v45Ev();
extern void _ZN6S689C53v46Ev();
extern void _ZN6S689C53v47Ev();
extern void _ZN6S689C53v48Ev();
extern void _ZN6S689C53v49Ev();
extern void _ZN6S689C53v50Ev();
extern void _ZN6S689C53v51Ev();
extern void _ZN6S689C53v52Ev();
extern void _ZN6S689C53v53Ev();
extern void _ZN6S689C53v54Ev();
extern void _ZN6S689C53v55Ev();
extern void _ZN6S689C53v56Ev();
extern void _ZN6S689C53v57Ev();
extern void _ZN6S689C53v58Ev();
extern void _ZN6S689C53v59Ev();
extern void _ZN6S689C53v60Ev();
extern void _ZN6S689C53v61Ev();
extern void _ZN6S689C53v62Ev();
extern void _ZN6S689C53v63Ev();
extern void _ZN6S689C53v64Ev();
extern void _ZN6S689C53v65Ev();
extern void _ZN6S689C53v66Ev();
extern void _ZN6S689C53v67Ev();
extern void _ZN6S689C53v68Ev();
extern void _ZN6S689C53v69Ev();
extern void _ZN6S689C53v70Ev();
static  VTBL_ENTRY vtc_S689C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S689C5[0]),
  (VTBL_ENTRY)&_ZN6S689C5D1Ev,
  (VTBL_ENTRY)&_ZN6S689C5D0Ev,
  (VTBL_ENTRY)&_ZN6S689C52v7Ev,
  (VTBL_ENTRY)&_ZN6S689C52v8Ev,
  (VTBL_ENTRY)&_ZN6S689C52v9Ev,
  (VTBL_ENTRY)&_ZN6S689C53v10Ev,
  (VTBL_ENTRY)&_ZN6S689C53v11Ev,
  (VTBL_ENTRY)&_ZN6S689C53v12Ev,
  (VTBL_ENTRY)&_ZN6S689C53v13Ev,
  (VTBL_ENTRY)&_ZN6S689C53v14Ev,
  (VTBL_ENTRY)&_ZN6S689C53v15Ev,
  (VTBL_ENTRY)&_ZN6S689C53v16Ev,
  (VTBL_ENTRY)&_ZN6S689C53v17Ev,
  (VTBL_ENTRY)&_ZN6S689C53v18Ev,
  (VTBL_ENTRY)&_ZN6S689C53v19Ev,
  (VTBL_ENTRY)&_ZN6S689C53v20Ev,
  (VTBL_ENTRY)&_ZN6S689C53v21Ev,
  (VTBL_ENTRY)&_ZN6S689C53v22Ev,
  (VTBL_ENTRY)&_ZN6S689C53v23Ev,
  (VTBL_ENTRY)&_ZN6S689C53v24Ev,
  (VTBL_ENTRY)&_ZN6S689C53v25Ev,
  (VTBL_ENTRY)&_ZN6S689C53v26Ev,
  (VTBL_ENTRY)&_ZN6S689C53v27Ev,
  (VTBL_ENTRY)&_ZN6S689C53v28Ev,
  (VTBL_ENTRY)&_ZN6S689C53v29Ev,
  (VTBL_ENTRY)&_ZN6S689C53v30Ev,
  (VTBL_ENTRY)&_ZN6S689C53v31Ev,
  (VTBL_ENTRY)&_ZN6S689C53v32Ev,
  (VTBL_ENTRY)&_ZN6S689C53v33Ev,
  (VTBL_ENTRY)&_ZN6S689C53v34Ev,
  (VTBL_ENTRY)&_ZN6S689C53v35Ev,
  (VTBL_ENTRY)&_ZN6S689C53v36Ev,
  (VTBL_ENTRY)&_ZN6S689C53v37Ev,
  (VTBL_ENTRY)&_ZN6S689C53v38Ev,
  (VTBL_ENTRY)&_ZN6S689C53v39Ev,
  (VTBL_ENTRY)&_ZN6S689C53v40Ev,
  (VTBL_ENTRY)&_ZN6S689C53v41Ev,
  (VTBL_ENTRY)&_ZN6S689C53v42Ev,
  (VTBL_ENTRY)&_ZN6S689C53v43Ev,
  (VTBL_ENTRY)&_ZN6S689C53v44Ev,
  (VTBL_ENTRY)&_ZN6S689C53v45Ev,
  (VTBL_ENTRY)&_ZN6S689C53v46Ev,
  (VTBL_ENTRY)&_ZN6S689C53v47Ev,
  (VTBL_ENTRY)&_ZN6S689C53v48Ev,
  (VTBL_ENTRY)&_ZN6S689C53v49Ev,
  (VTBL_ENTRY)&_ZN6S689C53v50Ev,
  (VTBL_ENTRY)&_ZN6S689C53v51Ev,
  (VTBL_ENTRY)&_ZN6S689C53v52Ev,
  (VTBL_ENTRY)&_ZN6S689C53v53Ev,
  (VTBL_ENTRY)&_ZN6S689C53v54Ev,
  (VTBL_ENTRY)&_ZN6S689C53v55Ev,
  (VTBL_ENTRY)&_ZN6S689C53v56Ev,
  (VTBL_ENTRY)&_ZN6S689C53v57Ev,
  (VTBL_ENTRY)&_ZN6S689C53v58Ev,
  (VTBL_ENTRY)&_ZN6S689C53v59Ev,
  (VTBL_ENTRY)&_ZN6S689C53v60Ev,
  (VTBL_ENTRY)&_ZN6S689C53v61Ev,
  (VTBL_ENTRY)&_ZN6S689C53v62Ev,
  (VTBL_ENTRY)&_ZN6S689C53v63Ev,
  (VTBL_ENTRY)&_ZN6S689C53v64Ev,
  (VTBL_ENTRY)&_ZN6S689C53v65Ev,
  (VTBL_ENTRY)&_ZN6S689C53v66Ev,
  (VTBL_ENTRY)&_ZN6S689C53v67Ev,
  (VTBL_ENTRY)&_ZN6S689C53v68Ev,
  (VTBL_ENTRY)&_ZN6S689C53v69Ev,
  (VTBL_ENTRY)&_ZN6S689C53v70Ev,
};
extern VTBL_ENTRY _ZTI6S689C5[];
extern  VTBL_ENTRY _ZTV6S689C5[];
Class_Descriptor cd_S689C5 = {  "S689C5", // class name
  0,0,//no base classes
  &(vtc_S689C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S689C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S689C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S689C4  : S689C5 {
  void *s689c4f0;
  ::S95C8_nt s689c4f1;
  virtual  ~S689C4(); // _ZN6S689C4D1Ev
  virtual void  v71(); // _ZN6S689C43v71Ev
  virtual void  v72(); // _ZN6S689C43v72Ev
  virtual void  v73(); // _ZN6S689C43v73Ev
  virtual void  v74(); // _ZN6S689C43v74Ev
  virtual void  v75(); // _ZN6S689C43v75Ev
  S689C4(); // tgen
};
//SIG(-1 S689C4) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S689C4 ::~S689C4(){ note_dtor("S689C4", this);}
void  S689C4 ::v71(){vfunc_called(this, "_ZN6S689C43v71Ev");}
void  S689C4 ::v72(){vfunc_called(this, "_ZN6S689C43v72Ev");}
void  S689C4 ::v73(){vfunc_called(this, "_ZN6S689C43v73Ev");}
void  S689C4 ::v74(){vfunc_called(this, "_ZN6S689C43v74Ev");}
void  S689C4 ::v75(){vfunc_called(this, "_ZN6S689C43v75Ev");}
S689C4 ::S689C4(){ note_ctor("S689C4", this);} // tgen

static void Test_S689C4()
{
  extern Class_Descriptor cd_S689C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S689C4, buf);
    S689C4 *dp, &lv = *(dp=new (buf) S689C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S689C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S689C4)");
    check_base_class_offset(lv, (S689C5*), 0, "S689C4");
    check_field_offset(lv, s689c4f0, ABISELECT(96,60), "S689C4.s689c4f0");
    check_field_offset(lv, s689c4f1, ABISELECT(104,64), "S689C4.s689c4f1");
    test_class_info(&lv, &cd_S689C4);
    dp->~S689C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS689C4(Test_S689C4, "S689C4", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S689C4C1Ev();
extern void _ZN6S689C4D1Ev();
Name_Map name_map_S689C4[] = {
  NSPAIR(_ZN6S689C4C1Ev),
  NSPAIR(_ZN6S689C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S689C5;
extern VTBL_ENTRY _ZTI6S689C5[];
extern  VTBL_ENTRY _ZTV6S689C5[];
static Base_Class bases_S689C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S689C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S689C4[];
extern void _ZN6S689C4D1Ev();
extern void _ZN6S689C4D0Ev();
extern void _ZN6S689C52v7Ev();
extern void _ZN6S689C52v8Ev();
extern void _ZN6S689C52v9Ev();
extern void _ZN6S689C53v10Ev();
extern void _ZN6S689C53v11Ev();
extern void _ZN6S689C53v12Ev();
extern void _ZN6S689C53v13Ev();
extern void _ZN6S689C53v14Ev();
extern void _ZN6S689C53v15Ev();
extern void _ZN6S689C53v16Ev();
extern void _ZN6S689C53v17Ev();
extern void _ZN6S689C53v18Ev();
extern void _ZN6S689C53v19Ev();
extern void _ZN6S689C53v20Ev();
extern void _ZN6S689C53v21Ev();
extern void _ZN6S689C53v22Ev();
extern void _ZN6S689C53v23Ev();
extern void _ZN6S689C53v24Ev();
extern void _ZN6S689C53v25Ev();
extern void _ZN6S689C53v26Ev();
extern void _ZN6S689C53v27Ev();
extern void _ZN6S689C53v28Ev();
extern void _ZN6S689C53v29Ev();
extern void _ZN6S689C53v30Ev();
extern void _ZN6S689C53v31Ev();
extern void _ZN6S689C53v32Ev();
extern void _ZN6S689C53v33Ev();
extern void _ZN6S689C53v34Ev();
extern void _ZN6S689C53v35Ev();
extern void _ZN6S689C53v36Ev();
extern void _ZN6S689C53v37Ev();
extern void _ZN6S689C53v38Ev();
extern void _ZN6S689C53v39Ev();
extern void _ZN6S689C53v40Ev();
extern void _ZN6S689C53v41Ev();
extern void _ZN6S689C53v42Ev();
extern void _ZN6S689C53v43Ev();
extern void _ZN6S689C53v44Ev();
extern void _ZN6S689C53v45Ev();
extern void _ZN6S689C53v46Ev();
extern void _ZN6S689C53v47Ev();
extern void _ZN6S689C53v48Ev();
extern void _ZN6S689C53v49Ev();
extern void _ZN6S689C53v50Ev();
extern void _ZN6S689C53v51Ev();
extern void _ZN6S689C53v52Ev();
extern void _ZN6S689C53v53Ev();
extern void _ZN6S689C53v54Ev();
extern void _ZN6S689C53v55Ev();
extern void _ZN6S689C53v56Ev();
extern void _ZN6S689C53v57Ev();
extern void _ZN6S689C53v58Ev();
extern void _ZN6S689C53v59Ev();
extern void _ZN6S689C53v60Ev();
extern void _ZN6S689C53v61Ev();
extern void _ZN6S689C53v62Ev();
extern void _ZN6S689C53v63Ev();
extern void _ZN6S689C53v64Ev();
extern void _ZN6S689C53v65Ev();
extern void _ZN6S689C53v66Ev();
extern void _ZN6S689C53v67Ev();
extern void _ZN6S689C53v68Ev();
extern void _ZN6S689C53v69Ev();
extern void _ZN6S689C53v70Ev();
extern void _ZN6S689C43v71Ev();
extern void _ZN6S689C43v72Ev();
extern void _ZN6S689C43v73Ev();
extern void _ZN6S689C43v74Ev();
extern void _ZN6S689C43v75Ev();
static  VTBL_ENTRY vtc_S689C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S689C4[0]),
  (VTBL_ENTRY)&_ZN6S689C4D1Ev,
  (VTBL_ENTRY)&_ZN6S689C4D0Ev,
  (VTBL_ENTRY)&_ZN6S689C52v7Ev,
  (VTBL_ENTRY)&_ZN6S689C52v8Ev,
  (VTBL_ENTRY)&_ZN6S689C52v9Ev,
  (VTBL_ENTRY)&_ZN6S689C53v10Ev,
  (VTBL_ENTRY)&_ZN6S689C53v11Ev,
  (VTBL_ENTRY)&_ZN6S689C53v12Ev,
  (VTBL_ENTRY)&_ZN6S689C53v13Ev,
  (VTBL_ENTRY)&_ZN6S689C53v14Ev,
  (VTBL_ENTRY)&_ZN6S689C53v15Ev,
  (VTBL_ENTRY)&_ZN6S689C53v16Ev,
  (VTBL_ENTRY)&_ZN6S689C53v17Ev,
  (VTBL_ENTRY)&_ZN6S689C53v18Ev,
  (VTBL_ENTRY)&_ZN6S689C53v19Ev,
  (VTBL_ENTRY)&_ZN6S689C53v20Ev,
  (VTBL_ENTRY)&_ZN6S689C53v21Ev,
  (VTBL_ENTRY)&_ZN6S689C53v22Ev,
  (VTBL_ENTRY)&_ZN6S689C53v23Ev,
  (VTBL_ENTRY)&_ZN6S689C53v24Ev,
  (VTBL_ENTRY)&_ZN6S689C53v25Ev,
  (VTBL_ENTRY)&_ZN6S689C53v26Ev,
  (VTBL_ENTRY)&_ZN6S689C53v27Ev,
  (VTBL_ENTRY)&_ZN6S689C53v28Ev,
  (VTBL_ENTRY)&_ZN6S689C53v29Ev,
  (VTBL_ENTRY)&_ZN6S689C53v30Ev,
  (VTBL_ENTRY)&_ZN6S689C53v31Ev,
  (VTBL_ENTRY)&_ZN6S689C53v32Ev,
  (VTBL_ENTRY)&_ZN6S689C53v33Ev,
  (VTBL_ENTRY)&_ZN6S689C53v34Ev,
  (VTBL_ENTRY)&_ZN6S689C53v35Ev,
  (VTBL_ENTRY)&_ZN6S689C53v36Ev,
  (VTBL_ENTRY)&_ZN6S689C53v37Ev,
  (VTBL_ENTRY)&_ZN6S689C53v38Ev,
  (VTBL_ENTRY)&_ZN6S689C53v39Ev,
  (VTBL_ENTRY)&_ZN6S689C53v40Ev,
  (VTBL_ENTRY)&_ZN6S689C53v41Ev,
  (VTBL_ENTRY)&_ZN6S689C53v42Ev,
  (VTBL_ENTRY)&_ZN6S689C53v43Ev,
  (VTBL_ENTRY)&_ZN6S689C53v44Ev,
  (VTBL_ENTRY)&_ZN6S689C53v45Ev,
  (VTBL_ENTRY)&_ZN6S689C53v46Ev,
  (VTBL_ENTRY)&_ZN6S689C53v47Ev,
  (VTBL_ENTRY)&_ZN6S689C53v48Ev,
  (VTBL_ENTRY)&_ZN6S689C53v49Ev,
  (VTBL_ENTRY)&_ZN6S689C53v50Ev,
  (VTBL_ENTRY)&_ZN6S689C53v51Ev,
  (VTBL_ENTRY)&_ZN6S689C53v52Ev,
  (VTBL_ENTRY)&_ZN6S689C53v53Ev,
  (VTBL_ENTRY)&_ZN6S689C53v54Ev,
  (VTBL_ENTRY)&_ZN6S689C53v55Ev,
  (VTBL_ENTRY)&_ZN6S689C53v56Ev,
  (VTBL_ENTRY)&_ZN6S689C53v57Ev,
  (VTBL_ENTRY)&_ZN6S689C53v58Ev,
  (VTBL_ENTRY)&_ZN6S689C53v59Ev,
  (VTBL_ENTRY)&_ZN6S689C53v60Ev,
  (VTBL_ENTRY)&_ZN6S689C53v61Ev,
  (VTBL_ENTRY)&_ZN6S689C53v62Ev,
  (VTBL_ENTRY)&_ZN6S689C53v63Ev,
  (VTBL_ENTRY)&_ZN6S689C53v64Ev,
  (VTBL_ENTRY)&_ZN6S689C53v65Ev,
  (VTBL_ENTRY)&_ZN6S689C53v66Ev,
  (VTBL_ENTRY)&_ZN6S689C53v67Ev,
  (VTBL_ENTRY)&_ZN6S689C53v68Ev,
  (VTBL_ENTRY)&_ZN6S689C53v69Ev,
  (VTBL_ENTRY)&_ZN6S689C53v70Ev,
  (VTBL_ENTRY)&_ZN6S689C43v71Ev,
  (VTBL_ENTRY)&_ZN6S689C43v72Ev,
  (VTBL_ENTRY)&_ZN6S689C43v73Ev,
  (VTBL_ENTRY)&_ZN6S689C43v74Ev,
  (VTBL_ENTRY)&_ZN6S689C43v75Ev,
};
extern VTBL_ENTRY _ZTI6S689C4[];
extern  VTBL_ENTRY _ZTV6S689C4[];
Class_Descriptor cd_S689C4 = {  "S689C4", // class name
  bases_S689C4, 1,
  &(vtc_S689C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S689C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S689C4),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S689C3  : S689C4 {
  void *s689c3f0[2];
  unsigned int s689c3f1:1;
  unsigned int s689c3f2:1;
  unsigned int s689c3f3:1;
  unsigned int s689c3f4:1;
  char s689c3f5;
  virtual  ~S689C3(); // _ZN6S689C3D1Ev
  virtual void  v76(); // _ZN6S689C33v76Ev
  virtual void  v77(); // _ZN6S689C33v77Ev
  virtual void  v78(); // _ZN6S689C33v78Ev
  virtual void  v79(); // _ZN6S689C33v79Ev
  virtual void  v80(); // _ZN6S689C33v80Ev
  virtual void  v81(); // _ZN6S689C33v81Ev
  virtual void  v82(); // _ZN6S689C33v82Ev
  virtual void  v83(); // _ZN6S689C33v83Ev
  virtual void  v84(); // _ZN6S689C33v84Ev
  virtual void  v85(); // _ZN6S689C33v85Ev
  virtual void  v86(); // _ZN6S689C33v86Ev
  virtual void  v87(); // _ZN6S689C33v87Ev
  virtual void  v88(); // _ZN6S689C33v88Ev
  virtual void  v89(); // _ZN6S689C33v89Ev
  virtual void  v90(); // _ZN6S689C33v90Ev
  virtual void  v91(); // _ZN6S689C33v91Ev
  virtual void  v92(); // _ZN6S689C33v92Ev
  virtual void  v93(); // _ZN6S689C33v93Ev
  virtual void  v94(); // _ZN6S689C33v94Ev
  virtual void  v95(); // _ZN6S689C33v95Ev
  virtual void  v96(); // _ZN6S689C33v96Ev
  virtual void  v97(); // _ZN6S689C33v97Ev
  S689C3(); // tgen
};
//SIG(-1 S689C3) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S689C3 ::~S689C3(){ note_dtor("S689C3", this);}
void  S689C3 ::v76(){vfunc_called(this, "_ZN6S689C33v76Ev");}
void  S689C3 ::v77(){vfunc_called(this, "_ZN6S689C33v77Ev");}
void  S689C3 ::v78(){vfunc_called(this, "_ZN6S689C33v78Ev");}
void  S689C3 ::v79(){vfunc_called(this, "_ZN6S689C33v79Ev");}
void  S689C3 ::v80(){vfunc_called(this, "_ZN6S689C33v80Ev");}
void  S689C3 ::v81(){vfunc_called(this, "_ZN6S689C33v81Ev");}
void  S689C3 ::v82(){vfunc_called(this, "_ZN6S689C33v82Ev");}
void  S689C3 ::v83(){vfunc_called(this, "_ZN6S689C33v83Ev");}
void  S689C3 ::v84(){vfunc_called(this, "_ZN6S689C33v84Ev");}
void  S689C3 ::v85(){vfunc_called(this, "_ZN6S689C33v85Ev");}
void  S689C3 ::v86(){vfunc_called(this, "_ZN6S689C33v86Ev");}
void  S689C3 ::v87(){vfunc_called(this, "_ZN6S689C33v87Ev");}
void  S689C3 ::v88(){vfunc_called(this, "_ZN6S689C33v88Ev");}
void  S689C3 ::v89(){vfunc_called(this, "_ZN6S689C33v89Ev");}
void  S689C3 ::v90(){vfunc_called(this, "_ZN6S689C33v90Ev");}
void  S689C3 ::v91(){vfunc_called(this, "_ZN6S689C33v91Ev");}
void  S689C3 ::v92(){vfunc_called(this, "_ZN6S689C33v92Ev");}
void  S689C3 ::v93(){vfunc_called(this, "_ZN6S689C33v93Ev");}
void  S689C3 ::v94(){vfunc_called(this, "_ZN6S689C33v94Ev");}
void  S689C3 ::v95(){vfunc_called(this, "_ZN6S689C33v95Ev");}
void  S689C3 ::v96(){vfunc_called(this, "_ZN6S689C33v96Ev");}
void  S689C3 ::v97(){vfunc_called(this, "_ZN6S689C33v97Ev");}
S689C3 ::S689C3(){ note_ctor("S689C3", this);} // tgen

static void Test_S689C3()
{
  extern Class_Descriptor cd_S689C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,22)];
    init_test(&cd_S689C3, buf);
    S689C3 *dp, &lv = *(dp=new (buf) S689C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,84), "sizeof(S689C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S689C3)");
    check_base_class_offset(lv, (S689C5*)(S689C4*), 0, "S689C3");
    check_base_class_offset(lv, (S689C4*), 0, "S689C3");
    check_field_offset(lv, s689c3f0, ABISELECT(112,72), "S689C3.s689c3f0");
    set_bf_and_test(lv, s689c3f1, ABISELECT(128,80), 0, 1, 1, "S689C3");
    set_bf_and_test(lv, s689c3f2, ABISELECT(128,80), 1, 1, 1, "S689C3");
    set_bf_and_test(lv, s689c3f3, ABISELECT(128,80), 2, 1, 1, "S689C3");
    set_bf_and_test(lv, s689c3f4, ABISELECT(128,80), 3, 1, 1, "S689C3");
    check_field_offset(lv, s689c3f5, ABISELECT(129,81), "S689C3.s689c3f5");
    test_class_info(&lv, &cd_S689C3);
    dp->~S689C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS689C3(Test_S689C3, "S689C3", ABISELECT(136,84));

#else // __cplusplus

extern void _ZN6S689C3C1Ev();
extern void _ZN6S689C3D1Ev();
Name_Map name_map_S689C3[] = {
  NSPAIR(_ZN6S689C3C1Ev),
  NSPAIR(_ZN6S689C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S689C5;
extern VTBL_ENTRY _ZTI6S689C5[];
extern  VTBL_ENTRY _ZTV6S689C5[];
extern Class_Descriptor cd_S689C4;
extern VTBL_ENTRY _ZTI6S689C4[];
extern  VTBL_ENTRY _ZTV6S689C4[];
static Base_Class bases_S689C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S689C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S689C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S689C3[];
extern void _ZN6S689C3D1Ev();
extern void _ZN6S689C3D0Ev();
extern void _ZN6S689C52v7Ev();
extern void _ZN6S689C52v8Ev();
extern void _ZN6S689C52v9Ev();
extern void _ZN6S689C53v10Ev();
extern void _ZN6S689C53v11Ev();
extern void _ZN6S689C53v12Ev();
extern void _ZN6S689C53v13Ev();
extern void _ZN6S689C53v14Ev();
extern void _ZN6S689C53v15Ev();
extern void _ZN6S689C53v16Ev();
extern void _ZN6S689C53v17Ev();
extern void _ZN6S689C53v18Ev();
extern void _ZN6S689C53v19Ev();
extern void _ZN6S689C53v20Ev();
extern void _ZN6S689C53v21Ev();
extern void _ZN6S689C53v22Ev();
extern void _ZN6S689C53v23Ev();
extern void _ZN6S689C53v24Ev();
extern void _ZN6S689C53v25Ev();
extern void _ZN6S689C53v26Ev();
extern void _ZN6S689C53v27Ev();
extern void _ZN6S689C53v28Ev();
extern void _ZN6S689C53v29Ev();
extern void _ZN6S689C53v30Ev();
extern void _ZN6S689C53v31Ev();
extern void _ZN6S689C53v32Ev();
extern void _ZN6S689C53v33Ev();
extern void _ZN6S689C53v34Ev();
extern void _ZN6S689C53v35Ev();
extern void _ZN6S689C53v36Ev();
extern void _ZN6S689C53v37Ev();
extern void _ZN6S689C53v38Ev();
extern void _ZN6S689C53v39Ev();
extern void _ZN6S689C53v40Ev();
extern void _ZN6S689C53v41Ev();
extern void _ZN6S689C53v42Ev();
extern void _ZN6S689C53v43Ev();
extern void _ZN6S689C53v44Ev();
extern void _ZN6S689C53v45Ev();
extern void _ZN6S689C53v46Ev();
extern void _ZN6S689C53v47Ev();
extern void _ZN6S689C53v48Ev();
extern void _ZN6S689C53v49Ev();
extern void _ZN6S689C53v50Ev();
extern void _ZN6S689C53v51Ev();
extern void _ZN6S689C53v52Ev();
extern void _ZN6S689C53v53Ev();
extern void _ZN6S689C53v54Ev();
extern void _ZN6S689C53v55Ev();
extern void _ZN6S689C53v56Ev();
extern void _ZN6S689C53v57Ev();
extern void _ZN6S689C53v58Ev();
extern void _ZN6S689C53v59Ev();
extern void _ZN6S689C53v60Ev();
extern void _ZN6S689C53v61Ev();
extern void _ZN6S689C53v62Ev();
extern void _ZN6S689C53v63Ev();
extern void _ZN6S689C53v64Ev();
extern void _ZN6S689C53v65Ev();
extern void _ZN6S689C53v66Ev();
extern void _ZN6S689C53v67Ev();
extern void _ZN6S689C53v68Ev();
extern void _ZN6S689C53v69Ev();
extern void _ZN6S689C53v70Ev();
extern void _ZN6S689C43v71Ev();
extern void _ZN6S689C43v72Ev();
extern void _ZN6S689C43v73Ev();
extern void _ZN6S689C43v74Ev();
extern void _ZN6S689C43v75Ev();
extern void _ZN6S689C33v76Ev();
extern void _ZN6S689C33v77Ev();
extern void _ZN6S689C33v78Ev();
extern void _ZN6S689C33v79Ev();
extern void _ZN6S689C33v80Ev();
extern void _ZN6S689C33v81Ev();
extern void _ZN6S689C33v82Ev();
extern void _ZN6S689C33v83Ev();
extern void _ZN6S689C33v84Ev();
extern void _ZN6S689C33v85Ev();
extern void _ZN6S689C33v86Ev();
extern void _ZN6S689C33v87Ev();
extern void _ZN6S689C33v88Ev();
extern void _ZN6S689C33v89Ev();
extern void _ZN6S689C33v90Ev();
extern void _ZN6S689C33v91Ev();
extern void _ZN6S689C33v92Ev();
extern void _ZN6S689C33v93Ev();
extern void _ZN6S689C33v94Ev();
extern void _ZN6S689C33v95Ev();
extern void _ZN6S689C33v96Ev();
extern void _ZN6S689C33v97Ev();
static  VTBL_ENTRY vtc_S689C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S689C3[0]),
  (VTBL_ENTRY)&_ZN6S689C3D1Ev,
  (VTBL_ENTRY)&_ZN6S689C3D0Ev,
  (VTBL_ENTRY)&_ZN6S689C52v7Ev,
  (VTBL_ENTRY)&_ZN6S689C52v8Ev,
  (VTBL_ENTRY)&_ZN6S689C52v9Ev,
  (VTBL_ENTRY)&_ZN6S689C53v10Ev,
  (VTBL_ENTRY)&_ZN6S689C53v11Ev,
  (VTBL_ENTRY)&_ZN6S689C53v12Ev,
  (VTBL_ENTRY)&_ZN6S689C53v13Ev,
  (VTBL_ENTRY)&_ZN6S689C53v14Ev,
  (VTBL_ENTRY)&_ZN6S689C53v15Ev,
  (VTBL_ENTRY)&_ZN6S689C53v16Ev,
  (VTBL_ENTRY)&_ZN6S689C53v17Ev,
  (VTBL_ENTRY)&_ZN6S689C53v18Ev,
  (VTBL_ENTRY)&_ZN6S689C53v19Ev,
  (VTBL_ENTRY)&_ZN6S689C53v20Ev,
  (VTBL_ENTRY)&_ZN6S689C53v21Ev,
  (VTBL_ENTRY)&_ZN6S689C53v22Ev,
  (VTBL_ENTRY)&_ZN6S689C53v23Ev,
  (VTBL_ENTRY)&_ZN6S689C53v24Ev,
  (VTBL_ENTRY)&_ZN6S689C53v25Ev,
  (VTBL_ENTRY)&_ZN6S689C53v26Ev,
  (VTBL_ENTRY)&_ZN6S689C53v27Ev,
  (VTBL_ENTRY)&_ZN6S689C53v28Ev,
  (VTBL_ENTRY)&_ZN6S689C53v29Ev,
  (VTBL_ENTRY)&_ZN6S689C53v30Ev,
  (VTBL_ENTRY)&_ZN6S689C53v31Ev,
  (VTBL_ENTRY)&_ZN6S689C53v32Ev,
  (VTBL_ENTRY)&_ZN6S689C53v33Ev,
  (VTBL_ENTRY)&_ZN6S689C53v34Ev,
  (VTBL_ENTRY)&_ZN6S689C53v35Ev,
  (VTBL_ENTRY)&_ZN6S689C53v36Ev,
  (VTBL_ENTRY)&_ZN6S689C53v37Ev,
  (VTBL_ENTRY)&_ZN6S689C53v38Ev,
  (VTBL_ENTRY)&_ZN6S689C53v39Ev,
  (VTBL_ENTRY)&_ZN6S689C53v40Ev,
  (VTBL_ENTRY)&_ZN6S689C53v41Ev,
  (VTBL_ENTRY)&_ZN6S689C53v42Ev,
  (VTBL_ENTRY)&_ZN6S689C53v43Ev,
  (VTBL_ENTRY)&_ZN6S689C53v44Ev,
  (VTBL_ENTRY)&_ZN6S689C53v45Ev,
  (VTBL_ENTRY)&_ZN6S689C53v46Ev,
  (VTBL_ENTRY)&_ZN6S689C53v47Ev,
  (VTBL_ENTRY)&_ZN6S689C53v48Ev,
  (VTBL_ENTRY)&_ZN6S689C53v49Ev,
  (VTBL_ENTRY)&_ZN6S689C53v50Ev,
  (VTBL_ENTRY)&_ZN6S689C53v51Ev,
  (VTBL_ENTRY)&_ZN6S689C53v52Ev,
  (VTBL_ENTRY)&_ZN6S689C53v53Ev,
  (VTBL_ENTRY)&_ZN6S689C53v54Ev,
  (VTBL_ENTRY)&_ZN6S689C53v55Ev,
  (VTBL_ENTRY)&_ZN6S689C53v56Ev,
  (VTBL_ENTRY)&_ZN6S689C53v57Ev,
  (VTBL_ENTRY)&_ZN6S689C53v58Ev,
  (VTBL_ENTRY)&_ZN6S689C53v59Ev,
  (VTBL_ENTRY)&_ZN6S689C53v60Ev,
  (VTBL_ENTRY)&_ZN6S689C53v61Ev,
  (VTBL_ENTRY)&_ZN6S689C53v62Ev,
  (VTBL_ENTRY)&_ZN6S689C53v63Ev,
  (VTBL_ENTRY)&_ZN6S689C53v64Ev,
  (VTBL_ENTRY)&_ZN6S689C53v65Ev,
  (VTBL_ENTRY)&_ZN6S689C53v66Ev,
  (VTBL_ENTRY)&_ZN6S689C53v67Ev,
  (VTBL_ENTRY)&_ZN6S689C53v68Ev,
  (VTBL_ENTRY)&_ZN6S689C53v69Ev,
  (VTBL_ENTRY)&_ZN6S689C53v70Ev,
  (VTBL_ENTRY)&_ZN6S689C43v71Ev,
  (VTBL_ENTRY)&_ZN6S689C43v72Ev,
  (VTBL_ENTRY)&_ZN6S689C43v73Ev,
  (VTBL_ENTRY)&_ZN6S689C43v74Ev,
  (VTBL_ENTRY)&_ZN6S689C43v75Ev,
  (VTBL_ENTRY)&_ZN6S689C33v76Ev,
  (VTBL_ENTRY)&_ZN6S689C33v77Ev,
  (VTBL_ENTRY)&_ZN6S689C33v78Ev,
  (VTBL_ENTRY)&_ZN6S689C33v79Ev,
  (VTBL_ENTRY)&_ZN6S689C33v80Ev,
  (VTBL_ENTRY)&_ZN6S689C33v81Ev,
  (VTBL_ENTRY)&_ZN6S689C33v82Ev,
  (VTBL_ENTRY)&_ZN6S689C33v83Ev,
  (VTBL_ENTRY)&_ZN6S689C33v84Ev,
  (VTBL_ENTRY)&_ZN6S689C33v85Ev,
  (VTBL_ENTRY)&_ZN6S689C33v86Ev,
  (VTBL_ENTRY)&_ZN6S689C33v87Ev,
  (VTBL_ENTRY)&_ZN6S689C33v88Ev,
  (VTBL_ENTRY)&_ZN6S689C33v89Ev,
  (VTBL_ENTRY)&_ZN6S689C33v90Ev,
  (VTBL_ENTRY)&_ZN6S689C33v91Ev,
  (VTBL_ENTRY)&_ZN6S689C33v92Ev,
  (VTBL_ENTRY)&_ZN6S689C33v93Ev,
  (VTBL_ENTRY)&_ZN6S689C33v94Ev,
  (VTBL_ENTRY)&_ZN6S689C33v95Ev,
  (VTBL_ENTRY)&_ZN6S689C33v96Ev,
  (VTBL_ENTRY)&_ZN6S689C33v97Ev,
};
extern VTBL_ENTRY _ZTI6S689C3[];
extern  VTBL_ENTRY _ZTV6S689C3[];
Class_Descriptor cd_S689C3 = {  "S689C3", // class name
  bases_S689C3, 2,
  &(vtc_S689C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI6S689C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S689C3),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S689C2  : S689C3 {
  void *s689c2f0;
  ::S95C9_nt s689c2f1;
  int s689c2f2;
  ::S236C15_nt s689c2f3;
  int s689c2f4;
  ::S490C27 s689c2f5;
  int s689c2f6;
  void *s689c2f7[2];
  ::S95C13 s689c2f8;
  void *s689c2f9;
  int s689c2f10[2];
  char s689c2f11[3];
  int s689c2f12;
  unsigned int s689c2f13:1;
  unsigned int s689c2f14:1;
  unsigned int s689c2f15:1;
  unsigned int s689c2f16:1;
  unsigned int s689c2f17:1;
  unsigned int s689c2f18:1;
  unsigned int s689c2f19:1;
  unsigned int s689c2f20:1;
  unsigned int s689c2f21:1;
  unsigned int s689c2f22:1;
  unsigned int s689c2f23:1;
  unsigned int s689c2f24:1;
  unsigned int s689c2f25:1;
  unsigned int s689c2f26:1;
  int s689c2f27;
  unsigned int s689c2f28:1;
  unsigned int s689c2f29:1;
  unsigned int s689c2f30:1;
  unsigned int s689c2f31:1;
  unsigned int s689c2f32:1;
  unsigned int s689c2f33:1;
  ::S112C22_nt s689c2f34;
  unsigned int s689c2f35:1;
  unsigned int s689c2f36:1;
  unsigned int s689c2f37:1;
  unsigned int s689c2f38:1;
  unsigned int s689c2f39:1;
  unsigned int s689c2f40:1;
  unsigned int s689c2f41:1;
  char s689c2f42;
  ::S95C16 s689c2f43;
  unsigned int s689c2f44:1;
  unsigned int s689c2f45:1;
  unsigned int s689c2f46:1;
  unsigned int s689c2f47:1;
  unsigned int s689c2f48:1;
  unsigned int s689c2f49:1;
  unsigned int s689c2f50:1;
  unsigned int s689c2f51:1;
  unsigned int s689c2f52:1;
  unsigned int s689c2f53:1;
  unsigned int s689c2f54:1;
  unsigned int s689c2f55:1;
  ::S490C26 s689c2f56;
  void *s689c2f57[2];
  char s689c2f58;
  ::S236C15_nt s689c2f59;
  ::S236C18_nt s689c2f60;
  ::S95C14_nt s689c2f61;
  int s689c2f62;
  ::S236C18_nt s689c2f63;
  unsigned int s689c2f64:1;
  unsigned int s689c2f65:1;
  unsigned int s689c2f66:1;
  int s689c2f67[3];
  virtual  ~S689C2(); // _ZN6S689C2D1Ev
  virtual void  v98(); // _ZN6S689C23v98Ev
  virtual void  v99(); // _ZN6S689C23v99Ev
  virtual void  v100(); // _ZN6S689C24v100Ev
  virtual void  v101(); // _ZN6S689C24v101Ev
  virtual void  v102(); // _ZN6S689C24v102Ev
  virtual void  v103(); // _ZN6S689C24v103Ev
  virtual void  v104(); // _ZN6S689C24v104Ev
  virtual void  v105(); // _ZN6S689C24v105Ev
  virtual void  v106(); // _ZN6S689C24v106Ev
  virtual void  v107(); // _ZN6S689C24v107Ev
  virtual void  v108(); // _ZN6S689C24v108Ev
  virtual void  v109(); // _ZN6S689C24v109Ev
  virtual void  v110(); // _ZN6S689C24v110Ev
  virtual void  v111(); // _ZN6S689C24v111Ev
  virtual void  v112(); // _ZN6S689C24v112Ev
  virtual void  v113(); // _ZN6S689C24v113Ev
  virtual void  v114(); // _ZN6S689C24v114Ev
  virtual void  v115(); // _ZN6S689C24v115Ev
  virtual void  v116(); // _ZN6S689C24v116Ev
  virtual void  v117(); // _ZN6S689C24v117Ev
  virtual void  v118(); // _ZN6S689C24v118Ev
  virtual void  v119(); // _ZN6S689C24v119Ev
  virtual void  v120(); // _ZN6S689C24v120Ev
  virtual void  v121(); // _ZN6S689C24v121Ev
  virtual void  v122(); // _ZN6S689C24v122Ev
  virtual void  v123(); // _ZN6S689C24v123Ev
  virtual void  v124(); // _ZN6S689C24v124Ev
  virtual void  v125(); // _ZN6S689C24v125Ev
  virtual void  v126(); // _ZN6S689C24v126Ev
  virtual void  v127(); // _ZN6S689C24v127Ev
  virtual void  v128(); // _ZN6S689C24v128Ev
  virtual void  v129(); // _ZN6S689C24v129Ev
  virtual void  v130(); // _ZN6S689C24v130Ev
  virtual void  v131(); // _ZN6S689C24v131Ev
  virtual void  v132(); // _ZN6S689C24v132Ev
  virtual void  v133(); // _ZN6S689C24v133Ev
  virtual void  v134(); // _ZN6S689C24v134Ev
  virtual void  v135(); // _ZN6S689C24v135Ev
  virtual void  v136(); // _ZN6S689C24v136Ev
  virtual void  v137(); // _ZN6S689C24v137Ev
  virtual void  v138(); // _ZN6S689C24v138Ev
  virtual void  v139(); // _ZN6S689C24v139Ev
  virtual void  v140(); // _ZN6S689C24v140Ev
  virtual void  v141(); // _ZN6S689C24v141Ev
  virtual void  v142(); // _ZN6S689C24v142Ev
  virtual void  v143(); // _ZN6S689C24v143Ev
  virtual void  v144(); // _ZN6S689C24v144Ev
  virtual void  v145(); // _ZN6S689C24v145Ev
  virtual void  v146(); // _ZN6S689C24v146Ev
  virtual void  v147(); // _ZN6S689C24v147Ev
  virtual void  v148(); // _ZN6S689C24v148Ev
  virtual void  v149(); // _ZN6S689C24v149Ev
  virtual void  v150(); // _ZN6S689C24v150Ev
  virtual void  v151(); // _ZN6S689C24v151Ev
  virtual void  v152(); // _ZN6S689C24v152Ev
  virtual void  v153(); // _ZN6S689C24v153Ev
  virtual void  v154(); // _ZN6S689C24v154Ev
  virtual void  v155(); // _ZN6S689C24v155Ev
  virtual void  v156(); // _ZN6S689C24v156Ev
  virtual void  v157(); // _ZN6S689C24v157Ev
  virtual void  v158(); // _ZN6S689C24v158Ev
  S689C2(); // tgen
};
//SIG(-1 S689C2) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi 