// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1541C5_nt  {
  int s1541c5f0[2];
  void  mf1541c5(); // _ZN10S1541C5_nt8mf1541c5Ev
};
//SIG(-1 S1541C5_nt) C1{ m Fi[2]}


void  S1541C5_nt ::mf1541c5(){}

//skip512 S1541C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C4_nt  {
  int s1541c4f0;
  __tsi64 s1541c4f1;
  void *s1541c4f2[4];
  int s1541c4f3[2];
  void *s1541c4f4;
  ::S1541C5_nt s1541c4f5;
  void *s1541c4f6[2];
  virtual  ~S1541C4_nt(); // _ZN10S1541C4_ntD1Ev
  virtual void  v7(); // _ZN10S1541C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1541C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1541C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1541C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1541C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1541C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1541C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1541C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1541C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1541C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1541C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1541C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1541C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1541C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1541C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1541C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1541C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1541C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1541C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1541C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1541C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1541C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1541C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1541C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1541C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1541C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1541C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1541C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1541C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1541C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1541C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1541C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1541C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1541C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1541C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1541C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1541C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1541C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1541C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1541C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1541C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1541C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1541C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1541C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1541C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1541C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1541C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1541C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1541C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1541C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1541C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1541C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1541C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1541C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1541C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1541C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1541C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1541C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1541C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1541C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1541C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1541C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1541C4_nt3v69Ev
  virtual void  v70(); // _ZN10S1541C4_nt3v70Ev
  S1541C4_nt(); // tgen
};
//SIG(-1 S1541C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1541C4_nt ::~S1541C4_nt(){ note_dtor("S1541C4_nt", this);}
void  S1541C4_nt ::v7(){vfunc_called(this, "_ZN10S1541C4_nt2v7Ev");}
void  S1541C4_nt ::v8(){vfunc_called(this, "_ZN10S1541C4_nt2v8Ev");}
void  S1541C4_nt ::v9(){vfunc_called(this, "_ZN10S1541C4_nt2v9Ev");}
void  S1541C4_nt ::v10(){vfunc_called(this, "_ZN10S1541C4_nt3v10Ev");}
void  S1541C4_nt ::v11(){vfunc_called(this, "_ZN10S1541C4_nt3v11Ev");}
void  S1541C4_nt ::v12(){vfunc_called(this, "_ZN10S1541C4_nt3v12Ev");}
void  S1541C4_nt ::v13(){vfunc_called(this, "_ZN10S1541C4_nt3v13Ev");}
void  S1541C4_nt ::v14(){vfunc_called(this, "_ZN10S1541C4_nt3v14Ev");}
void  S1541C4_nt ::v15(){vfunc_called(this, "_ZN10S1541C4_nt3v15Ev");}
void  S1541C4_nt ::v16(){vfunc_called(this, "_ZN10S1541C4_nt3v16Ev");}
void  S1541C4_nt ::v17(){vfunc_called(this, "_ZN10S1541C4_nt3v17Ev");}
void  S1541C4_nt ::v18(){vfunc_called(this, "_ZN10S1541C4_nt3v18Ev");}
void  S1541C4_nt ::v19(){vfunc_called(this, "_ZN10S1541C4_nt3v19Ev");}
void  S1541C4_nt ::v20(){vfunc_called(this, "_ZN10S1541C4_nt3v20Ev");}
void  S1541C4_nt ::v21(){vfunc_called(this, "_ZN10S1541C4_nt3v21Ev");}
void  S1541C4_nt ::v22(){vfunc_called(this, "_ZN10S1541C4_nt3v22Ev");}
void  S1541C4_nt ::v23(){vfunc_called(this, "_ZN10S1541C4_nt3v23Ev");}
void  S1541C4_nt ::v24(){vfunc_called(this, "_ZN10S1541C4_nt3v24Ev");}
void  S1541C4_nt ::v25(){vfunc_called(this, "_ZN10S1541C4_nt3v25Ev");}
void  S1541C4_nt ::v26(){vfunc_called(this, "_ZN10S1541C4_nt3v26Ev");}
void  S1541C4_nt ::v27(){vfunc_called(this, "_ZN10S1541C4_nt3v27Ev");}
void  S1541C4_nt ::v28(){vfunc_called(this, "_ZN10S1541C4_nt3v28Ev");}
void  S1541C4_nt ::v29(){vfunc_called(this, "_ZN10S1541C4_nt3v29Ev");}
void  S1541C4_nt ::v30(){vfunc_called(this, "_ZN10S1541C4_nt3v30Ev");}
void  S1541C4_nt ::v31(){vfunc_called(this, "_ZN10S1541C4_nt3v31Ev");}
void  S1541C4_nt ::v32(){vfunc_called(this, "_ZN10S1541C4_nt3v32Ev");}
void  S1541C4_nt ::v33(){vfunc_called(this, "_ZN10S1541C4_nt3v33Ev");}
void  S1541C4_nt ::v34(){vfunc_called(this, "_ZN10S1541C4_nt3v34Ev");}
void  S1541C4_nt ::v35(){vfunc_called(this, "_ZN10S1541C4_nt3v35Ev");}
void  S1541C4_nt ::v36(){vfunc_called(this, "_ZN10S1541C4_nt3v36Ev");}
void  S1541C4_nt ::v37(){vfunc_called(this, "_ZN10S1541C4_nt3v37Ev");}
void  S1541C4_nt ::v38(){vfunc_called(this, "_ZN10S1541C4_nt3v38Ev");}
void  S1541C4_nt ::v39(){vfunc_called(this, "_ZN10S1541C4_nt3v39Ev");}
void  S1541C4_nt ::v40(){vfunc_called(this, "_ZN10S1541C4_nt3v40Ev");}
void  S1541C4_nt ::v41(){vfunc_called(this, "_ZN10S1541C4_nt3v41Ev");}
void  S1541C4_nt ::v42(){vfunc_called(this, "_ZN10S1541C4_nt3v42Ev");}
void  S1541C4_nt ::v43(){vfunc_called(this, "_ZN10S1541C4_nt3v43Ev");}
void  S1541C4_nt ::v44(){vfunc_called(this, "_ZN10S1541C4_nt3v44Ev");}
void  S1541C4_nt ::v45(){vfunc_called(this, "_ZN10S1541C4_nt3v45Ev");}
void  S1541C4_nt ::v46(){vfunc_called(this, "_ZN10S1541C4_nt3v46Ev");}
void  S1541C4_nt ::v47(){vfunc_called(this, "_ZN10S1541C4_nt3v47Ev");}
void  S1541C4_nt ::v48(){vfunc_called(this, "_ZN10S1541C4_nt3v48Ev");}
void  S1541C4_nt ::v49(){vfunc_called(this, "_ZN10S1541C4_nt3v49Ev");}
void  S1541C4_nt ::v50(){vfunc_called(this, "_ZN10S1541C4_nt3v50Ev");}
void  S1541C4_nt ::v51(){vfunc_called(this, "_ZN10S1541C4_nt3v51Ev");}
void  S1541C4_nt ::v52(){vfunc_called(this, "_ZN10S1541C4_nt3v52Ev");}
void  S1541C4_nt ::v53(){vfunc_called(this, "_ZN10S1541C4_nt3v53Ev");}
void  S1541C4_nt ::v54(){vfunc_called(this, "_ZN10S1541C4_nt3v54Ev");}
void  S1541C4_nt ::v55(){vfunc_called(this, "_ZN10S1541C4_nt3v55Ev");}
void  S1541C4_nt ::v56(){vfunc_called(this, "_ZN10S1541C4_nt3v56Ev");}
void  S1541C4_nt ::v57(){vfunc_called(this, "_ZN10S1541C4_nt3v57Ev");}
void  S1541C4_nt ::v58(){vfunc_called(this, "_ZN10S1541C4_nt3v58Ev");}
void  S1541C4_nt ::v59(){vfunc_called(this, "_ZN10S1541C4_nt3v59Ev");}
void  S1541C4_nt ::v60(){vfunc_called(this, "_ZN10S1541C4_nt3v60Ev");}
void  S1541C4_nt ::v61(){vfunc_called(this, "_ZN10S1541C4_nt3v61Ev");}
void  S1541C4_nt ::v62(){vfunc_called(this, "_ZN10S1541C4_nt3v62Ev");}
void  S1541C4_nt ::v63(){vfunc_called(this, "_ZN10S1541C4_nt3v63Ev");}
void  S1541C4_nt ::v64(){vfunc_called(this, "_ZN10S1541C4_nt3v64Ev");}
void  S1541C4_nt ::v65(){vfunc_called(this, "_ZN10S1541C4_nt3v65Ev");}
void  S1541C4_nt ::v66(){vfunc_called(this, "_ZN10S1541C4_nt3v66Ev");}
void  S1541C4_nt ::v67(){vfunc_called(this, "_ZN10S1541C4_nt3v67Ev");}
void  S1541C4_nt ::v68(){vfunc_called(this, "_ZN10S1541C4_nt3v68Ev");}
void  S1541C4_nt ::v69(){vfunc_called(this, "_ZN10S1541C4_nt3v69Ev");}
void  S1541C4_nt ::v70(){vfunc_called(this, "_ZN10S1541C4_nt3v70Ev");}
S1541C4_nt ::S1541C4_nt(){ note_ctor("S1541C4_nt", this);} // tgen

//skip512 S1541C4_nt

#else // __cplusplus

extern void _ZN10S1541C4_ntC1Ev();
extern void _ZN10S1541C4_ntD1Ev();
Name_Map name_map_S1541C4_nt[] = {
  NSPAIR(_ZN10S1541C4_ntC1Ev),
  NSPAIR(_ZN10S1541C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1541C4_nt[];
extern void _ZN10S1541C4_ntD1Ev();
extern void _ZN10S1541C4_ntD0Ev();
extern void _ZN10S1541C4_nt2v7Ev();
extern void _ZN10S1541C4_nt2v8Ev();
extern void _ZN10S1541C4_nt2v9Ev();
extern void _ZN10S1541C4_nt3v10Ev();
extern void _ZN10S1541C4_nt3v11Ev();
extern void _ZN10S1541C4_nt3v12Ev();
extern void _ZN10S1541C4_nt3v13Ev();
extern void _ZN10S1541C4_nt3v14Ev();
extern void _ZN10S1541C4_nt3v15Ev();
extern void _ZN10S1541C4_nt3v16Ev();
extern void _ZN10S1541C4_nt3v17Ev();
extern void _ZN10S1541C4_nt3v18Ev();
extern void _ZN10S1541C4_nt3v19Ev();
extern void _ZN10S1541C4_nt3v20Ev();
extern void _ZN10S1541C4_nt3v21Ev();
extern void _ZN10S1541C4_nt3v22Ev();
extern void _ZN10S1541C4_nt3v23Ev();
extern void _ZN10S1541C4_nt3v24Ev();
extern void _ZN10S1541C4_nt3v25Ev();
extern void _ZN10S1541C4_nt3v26Ev();
extern void _ZN10S1541C4_nt3v27Ev();
extern void _ZN10S1541C4_nt3v28Ev();
extern void _ZN10S1541C4_nt3v29Ev();
extern void _ZN10S1541C4_nt3v30Ev();
extern void _ZN10S1541C4_nt3v31Ev();
extern void _ZN10S1541C4_nt3v32Ev();
extern void _ZN10S1541C4_nt3v33Ev();
extern void _ZN10S1541C4_nt3v34Ev();
extern void _ZN10S1541C4_nt3v35Ev();
extern void _ZN10S1541C4_nt3v36Ev();
extern void _ZN10S1541C4_nt3v37Ev();
extern void _ZN10S1541C4_nt3v38Ev();
extern void _ZN10S1541C4_nt3v39Ev();
extern void _ZN10S1541C4_nt3v40Ev();
extern void _ZN10S1541C4_nt3v41Ev();
extern void _ZN10S1541C4_nt3v42Ev();
extern void _ZN10S1541C4_nt3v43Ev();
extern void _ZN10S1541C4_nt3v44Ev();
extern void _ZN10S1541C4_nt3v45Ev();
extern void _ZN10S1541C4_nt3v46Ev();
extern void _ZN10S1541C4_nt3v47Ev();
extern void _ZN10S1541C4_nt3v48Ev();
extern void _ZN10S1541C4_nt3v49Ev();
extern void _ZN10S1541C4_nt3v50Ev();
extern void _ZN10S1541C4_nt3v51Ev();
extern void _ZN10S1541C4_nt3v52Ev();
extern void _ZN10S1541C4_nt3v53Ev();
extern void _ZN10S1541C4_nt3v54Ev();
extern void _ZN10S1541C4_nt3v55Ev();
extern void _ZN10S1541C4_nt3v56Ev();
extern void _ZN10S1541C4_nt3v57Ev();
extern void _ZN10S1541C4_nt3v58Ev();
extern void _ZN10S1541C4_nt3v59Ev();
extern void _ZN10S1541C4_nt3v60Ev();
extern void _ZN10S1541C4_nt3v61Ev();
extern void _ZN10S1541C4_nt3v62Ev();
extern void _ZN10S1541C4_nt3v63Ev();
extern void _ZN10S1541C4_nt3v64Ev();
extern void _ZN10S1541C4_nt3v65Ev();
extern void _ZN10S1541C4_nt3v66Ev();
extern void _ZN10S1541C4_nt3v67Ev();
extern void _ZN10S1541C4_nt3v68Ev();
extern void _ZN10S1541C4_nt3v69Ev();
extern void _ZN10S1541C4_nt3v70Ev();
static  VTBL_ENTRY vtc_S1541C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1541C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1541C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI10S1541C4_nt[];
VTBL_ENTRY *P__ZTI10S1541C4_nt = _ZTI10S1541C4_nt; 
extern  VTBL_ENTRY _ZTV10S1541C4_nt[];
Class_Descriptor cd_S1541C4_nt = {  "S1541C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1541C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1541C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1541C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C8_nt  {
  void *s1541c8f0;
  int s1541c8f1[2];
  void  mf1541c8(); // _ZN10S1541C8_nt8mf1541c8Ev
};
//SIG(-1 S1541C8_nt) C1{ m Fp Fi[2]}


void  S1541C8_nt ::mf1541c8(){}

//skip512 S1541C8_nt

#else // __cplusplus

Class_Descriptor cd_S1541C8_nt = {  "S1541C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C7_nt  : S1541C8_nt {
};
//SIG(-1 S1541C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1541C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
static Base_Class bases_S1541C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C7_nt = {  "S1541C7_nt", // class name
  bases_S1541C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C6_nt  : S1541C7_nt {
};
//SIG(-1 S1541C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1541C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
extern Class_Descriptor cd_S1541C7_nt;
static Base_Class bases_S1541C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C9_nt  {
  int s1541c9f0;
  void  mf1541c9(); // _ZN10S1541C9_nt8mf1541c9Ev
};
//SIG(-1 S1541C9_nt) C1{ m Fi}


void  S1541C9_nt ::mf1541c9(){}

//skip512 S1541C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1541C9_nt[];
VTBL_ENTRY *P__ZTI10S1541C9_nt = _ZTI10S1541C9_nt; 
Class_Descriptor cd_S1541C9_nt = {  "S1541C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1541C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C13  : S1541C8_nt {
};
//SIG(-1 S1541C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1541C13()
{
  extern Class_Descriptor cd_S1541C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C13, buf);
    S1541C13 &lv = *(new (buf) S1541C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C13)");
    check_base_class_offset(lv, (S1541C8_nt*), 0, "S1541C13");
    test_class_info(&lv, &cd_S1541C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C13(Test_S1541C13, "S1541C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
static Base_Class bases_S1541C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C13 = {  "S1541C13", // class name
  bases_S1541C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C12  : S1541C13 {
};
//SIG(-1 S1541C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1541C12()
{
  extern Class_Descriptor cd_S1541C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C12, buf);
    S1541C12 &lv = *(new (buf) S1541C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C12)");
    check_base_class_offset(lv, (S1541C8_nt*)(S1541C13*), 0, "S1541C12");
    check_base_class_offset(lv, (S1541C13*), 0, "S1541C12");
    test_class_info(&lv, &cd_S1541C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C12(Test_S1541C12, "S1541C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
extern Class_Descriptor cd_S1541C13;
static Base_Class bases_S1541C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C12 = {  "S1541C12", // class name
  bases_S1541C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C14_nt  {
  int s1541c14f0[3];
  void  mf1541c14(); // _ZN11S1541C14_nt9mf1541c14Ev
};
//SIG(-1 S1541C14_nt) C1{ m Fi[3]}


void  S1541C14_nt ::mf1541c14(){}

//skip512 S1541C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C19  : S1541C8_nt {
};
//SIG(-1 S1541C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1541C19()
{
  extern Class_Descriptor cd_S1541C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C19, buf);
    S1541C19 &lv = *(new (buf) S1541C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C19)");
    check_base_class_offset(lv, (S1541C8_nt*), 0, "S1541C19");
    test_class_info(&lv, &cd_S1541C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C19(Test_S1541C19, "S1541C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
static Base_Class bases_S1541C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C19 = {  "S1541C19", // class name
  bases_S1541C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C18  : S1541C19 {
};
//SIG(-1 S1541C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1541C18()
{
  extern Class_Descriptor cd_S1541C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C18, buf);
    S1541C18 &lv = *(new (buf) S1541C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C18)");
    check_base_class_offset(lv, (S1541C8_nt*)(S1541C19*), 0, "S1541C18");
    check_base_class_offset(lv, (S1541C19*), 0, "S1541C18");
    test_class_info(&lv, &cd_S1541C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C18(Test_S1541C18, "S1541C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
extern Class_Descriptor cd_S1541C19;
static Base_Class bases_S1541C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C18 = {  "S1541C18", // class name
  bases_S1541C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C3_nt  : S1541C4_nt {
  ::S1541C6_nt s1541c3f0;
  ::S1541C6_nt s1541c3f1;
  ::S1541C9_nt s1541c3f2;
  int s1541c3f3;
  char s1541c3f4[4];
  void *s1541c3f5[2];
  ::S1541C6_nt s1541c3f6;
  unsigned int s1541c3f7:1;
  unsigned int s1541c3f8:1;
  unsigned int s1541c3f9:1;
  unsigned int s1541c3f10:1;
  unsigned int s1541c3f11:1;
  unsigned int s1541c3f12:1;
  unsigned int s1541c3f13:1;
  unsigned int s1541c3f14:1;
  unsigned int s1541c3f15:1;
  unsigned int s1541c3f16:1;
  unsigned int s1541c3f17:1;
  unsigned int s1541c3f18:1;
  unsigned int s1541c3f19:1;
  unsigned int s1541c3f20:1;
  unsigned int s1541c3f21:1;
  unsigned int s1541c3f22:1;
  unsigned int s1541c3f23:1;
  unsigned int s1541c3f24:1;
  unsigned int s1541c3f25:1;
  unsigned int s1541c3f26:1;
  unsigned int s1541c3f27:1;
  unsigned int s1541c3f28:1;
  unsigned int s1541c3f29:1;
  unsigned int s1541c3f30:1;
  unsigned int s1541c3f31:1;
  unsigned int s1541c3f32:1;
  unsigned int s1541c3f33:1;
  unsigned int s1541c3f34:1;
  unsigned int s1541c3f35:1;
  unsigned int s1541c3f36:1;
  unsigned int s1541c3f37:1;
  unsigned int s1541c3f38:1;
  unsigned int s1541c3f39:1;
  unsigned int s1541c3f40:1;
  unsigned int s1541c3f41:1;
  unsigned int s1541c3f42:1;
  unsigned int s1541c3f43:1;
  unsigned int s1541c3f44:1;
  unsigned int s1541c3f45:1;
  unsigned int s1541c3f46:1;
  unsigned int s1541c3f47:1;
  unsigned int s1541c3f48:1;
  unsigned int s1541c3f49:1;
  unsigned int s1541c3f50:1;
  unsigned int s1541c3f51:1;
  unsigned int s1541c3f52:1;
  unsigned int s1541c3f53:1;
  unsigned int s1541c3f54:1;
  unsigned int s1541c3f55:1;
  unsigned int s1541c3f56:1;
  unsigned int s1541c3f57:1;
  unsigned int s1541c3f58:1;
  unsigned int s1541c3f59:1;
  unsigned int s1541c3f60:1;
  unsigned int s1541c3f61:1;
  unsigned int s1541c3f62:1;
  unsigned int s1541c3f63:1;
  unsigned int s1541c3f64:1;
  unsigned int s1541c3f65:1;
  unsigned int s1541c3f66:1;
  unsigned int s1541c3f67:1;
  unsigned int s1541c3f68:1;
  unsigned int s1541c3f69:1;
  unsigned int s1541c3f70:1;
  unsigned int s1541c3f71:1;
  unsigned int s1541c3f72:1;
  unsigned int s1541c3f73:1;
  unsigned int s1541c3f74:1;
  unsigned int s1541c3f75:1;
  unsigned int s1541c3f76:1;
  unsigned int s1541c3f77:1;
  unsigned int s1541c3f78:1;
  unsigned int s1541c3f79:1;
  unsigned int s1541c3f80:1;
  unsigned int s1541c3f81:1;
  unsigned int s1541c3f82:1;
  unsigned int s1541c3f83:1;
  int s1541c3f84[5];
  void *s1541c3f85[2];
  int s1541c3f86[3];
  ::S1541C5_nt s1541c3f87;
  ::S1541C5_nt s1541c3f88;
  ::S1541C5_nt s1541c3f89;
  ::S1541C12 s1541c3f90;
  ::S1541C12 s1541c3f91;
  int s1541c3f92;
  void *s1541c3f93[2];
  ::S1541C14_nt s1541c3f94;
  ::S1541C14_nt s1541c3f95;
  ::S1541C14_nt s1541c3f96;
  ::S1541C14_nt s1541c3f97;
  void *s1541c3f98;
  ::S1541C5_nt s1541c3f99;
  ::S1541C12 s1541c3f100;
  ::S1541C14_nt s1541c3f101;
  ::S1541C14_nt s1541c3f102;
  int s1541c3f103;
  ::S1541C14_nt s1541c3f104;
  ::S1541C14_nt s1541c3f105;
  void *s1541c3f106;
  int s1541c3f107;
  char s1541c3f108;
  ::S1541C14_nt s1541c3f109;
  ::S1541C14_nt s1541c3f110;
  void *s1541c3f111;
  int s1541c3f112;
  void *s1541c3f113;
  ::S1541C12 s1541c3f114;
  ::S1541C18 s1541c3f115;
  ::S1541C18 s1541c3f116;
  virtual  ~S1541C3_nt(); // _ZN10S1541C3_ntD1Ev
  virtual void  v71(); // _ZN10S1541C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1541C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1541C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1541C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1541C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1541C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1541C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1541C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1541C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1541C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1541C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1541C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1541C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1541C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1541C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1541C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1541C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1541C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1541C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1541C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1541C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1541C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1541C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1541C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1541C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1541C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1541C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1541C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1541C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1541C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1541C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1541C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1541C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1541C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1541C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1541C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1541C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1541C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1541C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1541C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1541C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1541C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1541C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1541C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1541C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1541C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1541C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1541C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1541C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1541C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1541C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1541C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1541C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1541C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1541C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1541C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1541C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1541C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1541C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1541C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1541C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1541C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1541C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1541C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1541C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1541C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1541C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1541C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1541C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1541C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1541C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1541C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1541C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1541C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1541C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1541C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1541C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1541C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1541C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1541C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1541C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1541C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1541C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1541C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1541C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1541C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1541C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1541C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1541C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1541C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1541C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1541C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1541C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1541C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1541C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1541C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1541C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1541C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1541C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1541C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1541C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1541C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1541C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1541C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1541C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1541C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1541C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1541C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1541C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1541C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1541C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1541C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1541C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1541C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1541C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1541C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1541C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1541C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1541C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1541C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1541C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1541C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1541C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1541C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1541C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1541C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1541C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1541C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1541C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1541C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1541C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1541C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1541C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1541C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1541C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1541C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1541C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1541C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1541C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1541C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1541C3_nt4v211Ev
  virtual void  v212(); // _ZN10S1541C3_nt4v212Ev
  virtual void  v213(); // _ZN10S1541C3_nt4v213Ev
  S1541C3_nt(); // tgen
};
//SIG(-1 S1541C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1541C3_nt ::~S1541C3_nt(){ note_dtor("S1541C3_nt", this);}
void  S1541C3_nt ::v71(){vfunc_called(this, "_ZN10S1541C3_nt3v71Ev");}
void  S1541C3_nt ::v72(){vfunc_called(this, "_ZN10S1541C3_nt3v72Ev");}
void  S1541C3_nt ::v73(){vfunc_called(this, "_ZN10S1541C3_nt3v73Ev");}
void  S1541C3_nt ::v74(){vfunc_called(this, "_ZN10S1541C3_nt3v74Ev");}
void  S1541C3_nt ::v75(){vfunc_called(this, "_ZN10S1541C3_nt3v75Ev");}
void  S1541C3_nt ::v76(){vfunc_called(this, "_ZN10S1541C3_nt3v76Ev");}
void  S1541C3_nt ::v77(){vfunc_called(this, "_ZN10S1541C3_nt3v77Ev");}
void  S1541C3_nt ::v78(){vfunc_called(this, "_ZN10S1541C3_nt3v78Ev");}
void  S1541C3_nt ::v79(){vfunc_called(this, "_ZN10S1541C3_nt3v79Ev");}
void  S1541C3_nt ::v80(){vfunc_called(this, "_ZN10S1541C3_nt3v80Ev");}
void  S1541C3_nt ::v81(){vfunc_called(this, "_ZN10S1541C3_nt3v81Ev");}
void  S1541C3_nt ::v82(){vfunc_called(this, "_ZN10S1541C3_nt3v82Ev");}
void  S1541C3_nt ::v83(){vfunc_called(this, "_ZN10S1541C3_nt3v83Ev");}
void  S1541C3_nt ::v84(){vfunc_called(this, "_ZN10S1541C3_nt3v84Ev");}
void  S1541C3_nt ::v85(){vfunc_called(this, "_ZN10S1541C3_nt3v85Ev");}
void  S1541C3_nt ::v86(){vfunc_called(this, "_ZN10S1541C3_nt3v86Ev");}
void  S1541C3_nt ::v87(){vfunc_called(this, "_ZN10S1541C3_nt3v87Ev");}
void  S1541C3_nt ::v88(){vfunc_called(this, "_ZN10S1541C3_nt3v88Ev");}
void  S1541C3_nt ::v89(){vfunc_called(this, "_ZN10S1541C3_nt3v89Ev");}
void  S1541C3_nt ::v90(){vfunc_called(this, "_ZN10S1541C3_nt3v90Ev");}
void  S1541C3_nt ::v91(){vfunc_called(this, "_ZN10S1541C3_nt3v91Ev");}
void  S1541C3_nt ::v92(){vfunc_called(this, "_ZN10S1541C3_nt3v92Ev");}
void  S1541C3_nt ::v93(){vfunc_called(this, "_ZN10S1541C3_nt3v93Ev");}
void  S1541C3_nt ::v94(){vfunc_called(this, "_ZN10S1541C3_nt3v94Ev");}
void  S1541C3_nt ::v95(){vfunc_called(this, "_ZN10S1541C3_nt3v95Ev");}
void  S1541C3_nt ::v96(){vfunc_called(this, "_ZN10S1541C3_nt3v96Ev");}
void  S1541C3_nt ::v97(){vfunc_called(this, "_ZN10S1541C3_nt3v97Ev");}
void  S1541C3_nt ::v98(){vfunc_called(this, "_ZN10S1541C3_nt3v98Ev");}
void  S1541C3_nt ::v99(){vfunc_called(this, "_ZN10S1541C3_nt3v99Ev");}
void  S1541C3_nt ::v100(){vfunc_called(this, "_ZN10S1541C3_nt4v100Ev");}
void  S1541C3_nt ::v101(){vfunc_called(this, "_ZN10S1541C3_nt4v101Ev");}
void  S1541C3_nt ::v102(){vfunc_called(this, "_ZN10S1541C3_nt4v102Ev");}
void  S1541C3_nt ::v103(){vfunc_called(this, "_ZN10S1541C3_nt4v103Ev");}
void  S1541C3_nt ::v104(){vfunc_called(this, "_ZN10S1541C3_nt4v104Ev");}
void  S1541C3_nt ::v105(){vfunc_called(this, "_ZN10S1541C3_nt4v105Ev");}
void  S1541C3_nt ::v106(){vfunc_called(this, "_ZN10S1541C3_nt4v106Ev");}
void  S1541C3_nt ::v107(){vfunc_called(this, "_ZN10S1541C3_nt4v107Ev");}
void  S1541C3_nt ::v108(){vfunc_called(this, "_ZN10S1541C3_nt4v108Ev");}
void  S1541C3_nt ::v109(){vfunc_called(this, "_ZN10S1541C3_nt4v109Ev");}
void  S1541C3_nt ::v110(){vfunc_called(this, "_ZN10S1541C3_nt4v110Ev");}
void  S1541C3_nt ::v111(){vfunc_called(this, "_ZN10S1541C3_nt4v111Ev");}
void  S1541C3_nt ::v112(){vfunc_called(this, "_ZN10S1541C3_nt4v112Ev");}
void  S1541C3_nt ::v113(){vfunc_called(this, "_ZN10S1541C3_nt4v113Ev");}
void  S1541C3_nt ::v114(){vfunc_called(this, "_ZN10S1541C3_nt4v114Ev");}
void  S1541C3_nt ::v115(){vfunc_called(this, "_ZN10S1541C3_nt4v115Ev");}
void  S1541C3_nt ::v116(){vfunc_called(this, "_ZN10S1541C3_nt4v116Ev");}
void  S1541C3_nt ::v117(){vfunc_called(this, "_ZN10S1541C3_nt4v117Ev");}
void  S1541C3_nt ::v118(){vfunc_called(this, "_ZN10S1541C3_nt4v118Ev");}
void  S1541C3_nt ::v119(){vfunc_called(this, "_ZN10S1541C3_nt4v119Ev");}
void  S1541C3_nt ::v120(){vfunc_called(this, "_ZN10S1541C3_nt4v120Ev");}
void  S1541C3_nt ::v121(){vfunc_called(this, "_ZN10S1541C3_nt4v121Ev");}
void  S1541C3_nt ::v122(){vfunc_called(this, "_ZN10S1541C3_nt4v122Ev");}
void  S1541C3_nt ::v123(){vfunc_called(this, "_ZN10S1541C3_nt4v123Ev");}
void  S1541C3_nt ::v124(){vfunc_called(this, "_ZN10S1541C3_nt4v124Ev");}
void  S1541C3_nt ::v125(){vfunc_called(this, "_ZN10S1541C3_nt4v125Ev");}
void  S1541C3_nt ::v126(){vfunc_called(this, "_ZN10S1541C3_nt4v126Ev");}
void  S1541C3_nt ::v127(){vfunc_called(this, "_ZN10S1541C3_nt4v127Ev");}
void  S1541C3_nt ::v128(){vfunc_called(this, "_ZN10S1541C3_nt4v128Ev");}
void  S1541C3_nt ::v129(){vfunc_called(this, "_ZN10S1541C3_nt4v129Ev");}
void  S1541C3_nt ::v130(){vfunc_called(this, "_ZN10S1541C3_nt4v130Ev");}
void  S1541C3_nt ::v131(){vfunc_called(this, "_ZN10S1541C3_nt4v131Ev");}
void  S1541C3_nt ::v132(){vfunc_called(this, "_ZN10S1541C3_nt4v132Ev");}
void  S1541C3_nt ::v133(){vfunc_called(this, "_ZN10S1541C3_nt4v133Ev");}
void  S1541C3_nt ::v134(){vfunc_called(this, "_ZN10S1541C3_nt4v134Ev");}
void  S1541C3_nt ::v135(){vfunc_called(this, "_ZN10S1541C3_nt4v135Ev");}
void  S1541C3_nt ::v136(){vfunc_called(this, "_ZN10S1541C3_nt4v136Ev");}
void  S1541C3_nt ::v137(){vfunc_called(this, "_ZN10S1541C3_nt4v137Ev");}
void  S1541C3_nt ::v138(){vfunc_called(this, "_ZN10S1541C3_nt4v138Ev");}
void  S1541C3_nt ::v139(){vfunc_called(this, "_ZN10S1541C3_nt4v139Ev");}
void  S1541C3_nt ::v140(){vfunc_called(this, "_ZN10S1541C3_nt4v140Ev");}
void  S1541C3_nt ::v141(){vfunc_called(this, "_ZN10S1541C3_nt4v141Ev");}
void  S1541C3_nt ::v142(){vfunc_called(this, "_ZN10S1541C3_nt4v142Ev");}
void  S1541C3_nt ::v143(){vfunc_called(this, "_ZN10S1541C3_nt4v143Ev");}
void  S1541C3_nt ::v144(){vfunc_called(this, "_ZN10S1541C3_nt4v144Ev");}
void  S1541C3_nt ::v145(){vfunc_called(this, "_ZN10S1541C3_nt4v145Ev");}
void  S1541C3_nt ::v146(){vfunc_called(this, "_ZN10S1541C3_nt4v146Ev");}
void  S1541C3_nt ::v147(){vfunc_called(this, "_ZN10S1541C3_nt4v147Ev");}
void  S1541C3_nt ::v148(){vfunc_called(this, "_ZN10S1541C3_nt4v148Ev");}
void  S1541C3_nt ::v149(){vfunc_called(this, "_ZN10S1541C3_nt4v149Ev");}
void  S1541C3_nt ::v150(){vfunc_called(this, "_ZN10S1541C3_nt4v150Ev");}
void  S1541C3_nt ::v151(){vfunc_called(this, "_ZN10S1541C3_nt4v151Ev");}
void  S1541C3_nt ::v152(){vfunc_called(this, "_ZN10S1541C3_nt4v152Ev");}
void  S1541C3_nt ::v153(){vfunc_called(this, "_ZN10S1541C3_nt4v153Ev");}
void  S1541C3_nt ::v154(){vfunc_called(this, "_ZN10S1541C3_nt4v154Ev");}
void  S1541C3_nt ::v155(){vfunc_called(this, "_ZN10S1541C3_nt4v155Ev");}
void  S1541C3_nt ::v156(){vfunc_called(this, "_ZN10S1541C3_nt4v156Ev");}
void  S1541C3_nt ::v157(){vfunc_called(this, "_ZN10S1541C3_nt4v157Ev");}
void  S1541C3_nt ::v158(){vfunc_called(this, "_ZN10S1541C3_nt4v158Ev");}
void  S1541C3_nt ::v159(){vfunc_called(this, "_ZN10S1541C3_nt4v159Ev");}
void  S1541C3_nt ::v160(){vfunc_called(this, "_ZN10S1541C3_nt4v160Ev");}
void  S1541C3_nt ::v161(){vfunc_called(this, "_ZN10S1541C3_nt4v161Ev");}
void  S1541C3_nt ::v162(){vfunc_called(this, "_ZN10S1541C3_nt4v162Ev");}
void  S1541C3_nt ::v163(){vfunc_called(this, "_ZN10S1541C3_nt4v163Ev");}
void  S1541C3_nt ::v164(){vfunc_called(this, "_ZN10S1541C3_nt4v164Ev");}
void  S1541C3_nt ::v165(){vfunc_called(this, "_ZN10S1541C3_nt4v165Ev");}
void  S1541C3_nt ::v166(){vfunc_called(this, "_ZN10S1541C3_nt4v166Ev");}
void  S1541C3_nt ::v167(){vfunc_called(this, "_ZN10S1541C3_nt4v167Ev");}
void  S1541C3_nt ::v168(){vfunc_called(this, "_ZN10S1541C3_nt4v168Ev");}
void  S1541C3_nt ::v169(){vfunc_called(this, "_ZN10S1541C3_nt4v169Ev");}
void  S1541C3_nt ::v170(){vfunc_called(this, "_ZN10S1541C3_nt4v170Ev");}
void  S1541C3_nt ::v171(){vfunc_called(this, "_ZN10S1541C3_nt4v171Ev");}
void  S1541C3_nt ::v172(){vfunc_called(this, "_ZN10S1541C3_nt4v172Ev");}
void  S1541C3_nt ::v173(){vfunc_called(this, "_ZN10S1541C3_nt4v173Ev");}
void  S1541C3_nt ::v174(){vfunc_called(this, "_ZN10S1541C3_nt4v174Ev");}
void  S1541C3_nt ::v175(){vfunc_called(this, "_ZN10S1541C3_nt4v175Ev");}
void  S1541C3_nt ::v176(){vfunc_called(this, "_ZN10S1541C3_nt4v176Ev");}
void  S1541C3_nt ::v177(){vfunc_called(this, "_ZN10S1541C3_nt4v177Ev");}
void  S1541C3_nt ::v178(){vfunc_called(this, "_ZN10S1541C3_nt4v178Ev");}
void  S1541C3_nt ::v179(){vfunc_called(this, "_ZN10S1541C3_nt4v179Ev");}
void  S1541C3_nt ::v180(){vfunc_called(this, "_ZN10S1541C3_nt4v180Ev");}
void  S1541C3_nt ::v181(){vfunc_called(this, "_ZN10S1541C3_nt4v181Ev");}
void  S1541C3_nt ::v182(){vfunc_called(this, "_ZN10S1541C3_nt4v182Ev");}
void  S1541C3_nt ::v183(){vfunc_called(this, "_ZN10S1541C3_nt4v183Ev");}
void  S1541C3_nt ::v184(){vfunc_called(this, "_ZN10S1541C3_nt4v184Ev");}
void  S1541C3_nt ::v185(){vfunc_called(this, "_ZN10S1541C3_nt4v185Ev");}
void  S1541C3_nt ::v186(){vfunc_called(this, "_ZN10S1541C3_nt4v186Ev");}
void  S1541C3_nt ::v187(){vfunc_called(this, "_ZN10S1541C3_nt4v187Ev");}
void  S1541C3_nt ::v188(){vfunc_called(this, "_ZN10S1541C3_nt4v188Ev");}
void  S1541C3_nt ::v189(){vfunc_called(this, "_ZN10S1541C3_nt4v189Ev");}
void  S1541C3_nt ::v190(){vfunc_called(this, "_ZN10S1541C3_nt4v190Ev");}
void  S1541C3_nt ::v191(){vfunc_called(this, "_ZN10S1541C3_nt4v191Ev");}
void  S1541C3_nt ::v192(){vfunc_called(this, "_ZN10S1541C3_nt4v192Ev");}
void  S1541C3_nt ::v193(){vfunc_called(this, "_ZN10S1541C3_nt4v193Ev");}
void  S1541C3_nt ::v194(){vfunc_called(this, "_ZN10S1541C3_nt4v194Ev");}
void  S1541C3_nt ::v195(){vfunc_called(this, "_ZN10S1541C3_nt4v195Ev");}
void  S1541C3_nt ::v196(){vfunc_called(this, "_ZN10S1541C3_nt4v196Ev");}
void  S1541C3_nt ::v197(){vfunc_called(this, "_ZN10S1541C3_nt4v197Ev");}
void  S1541C3_nt ::v198(){vfunc_called(this, "_ZN10S1541C3_nt4v198Ev");}
void  S1541C3_nt ::v199(){vfunc_called(this, "_ZN10S1541C3_nt4v199Ev");}
void  S1541C3_nt ::v200(){vfunc_called(this, "_ZN10S1541C3_nt4v200Ev");}
void  S1541C3_nt ::v201(){vfunc_called(this, "_ZN10S1541C3_nt4v201Ev");}
void  S1541C3_nt ::v202(){vfunc_called(this, "_ZN10S1541C3_nt4v202Ev");}
void  S1541C3_nt ::v203(){vfunc_called(this, "_ZN10S1541C3_nt4v203Ev");}
void  S1541C3_nt ::v204(){vfunc_called(this, "_ZN10S1541C3_nt4v204Ev");}
void  S1541C3_nt ::v205(){vfunc_called(this, "_ZN10S1541C3_nt4v205Ev");}
void  S1541C3_nt ::v206(){vfunc_called(this, "_ZN10S1541C3_nt4v206Ev");}
void  S1541C3_nt ::v207(){vfunc_called(this, "_ZN10S1541C3_nt4v207Ev");}
void  S1541C3_nt ::v208(){vfunc_called(this, "_ZN10S1541C3_nt4v208Ev");}
void  S1541C3_nt ::v209(){vfunc_called(this, "_ZN10S1541C3_nt4v209Ev");}
void  S1541C3_nt ::v210(){vfunc_called(this, "_ZN10S1541C3_nt4v210Ev");}
void  S1541C3_nt ::v211(){vfunc_called(this, "_ZN10S1541C3_nt4v211Ev");}
void  S1541C3_nt ::v212(){vfunc_called(this, "_ZN10S1541C3_nt4v212Ev");}
void  S1541C3_nt ::v213(){vfunc_called(this, "_ZN10S1541C3_nt4v213Ev");}
S1541C3_nt ::S1541C3_nt(){ note_ctor("S1541C3_nt", this);} // tgen

//skip512 S1541C3_nt

#else // __cplusplus

extern void _ZN10S1541C3_ntC1Ev();
extern void _ZN10S1541C3_ntD1Ev();
Name_Map name_map_S1541C3_nt[] = {
  NSPAIR(_ZN10S1541C3_ntC1Ev),
  NSPAIR(_ZN10S1541C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1541C4_nt;
extern VTBL_ENTRY _ZTI10S1541C4_nt[];
extern  VTBL_ENTRY _ZTV10S1541C4_nt[];
static Base_Class bases_S1541C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1541C3_nt[];
extern void _ZN10S1541C3_ntD1Ev();
extern void _ZN10S1541C3_ntD0Ev();
extern void _ZN10S1541C4_nt2v7Ev();
extern void _ZN10S1541C4_nt2v8Ev();
extern void _ZN10S1541C4_nt2v9Ev();
extern void _ZN10S1541C4_nt3v10Ev();
extern void _ZN10S1541C4_nt3v11Ev();
extern void _ZN10S1541C4_nt3v12Ev();
extern void _ZN10S1541C4_nt3v13Ev();
extern void _ZN10S1541C4_nt3v14Ev();
extern void _ZN10S1541C4_nt3v15Ev();
extern void _ZN10S1541C4_nt3v16Ev();
extern void _ZN10S1541C4_nt3v17Ev();
extern void _ZN10S1541C4_nt3v18Ev();
extern void _ZN10S1541C4_nt3v19Ev();
extern void _ZN10S1541C4_nt3v20Ev();
extern void _ZN10S1541C4_nt3v21Ev();
extern void _ZN10S1541C4_nt3v22Ev();
extern void _ZN10S1541C4_nt3v23Ev();
extern void _ZN10S1541C4_nt3v24Ev();
extern void _ZN10S1541C4_nt3v25Ev();
extern void _ZN10S1541C4_nt3v26Ev();
extern void _ZN10S1541C4_nt3v27Ev();
extern void _ZN10S1541C4_nt3v28Ev();
extern void _ZN10S1541C4_nt3v29Ev();
extern void _ZN10S1541C4_nt3v30Ev();
extern void _ZN10S1541C4_nt3v31Ev();
extern void _ZN10S1541C4_nt3v32Ev();
extern void _ZN10S1541C4_nt3v33Ev();
extern void _ZN10S1541C4_nt3v34Ev();
extern void _ZN10S1541C4_nt3v35Ev();
extern void _ZN10S1541C4_nt3v36Ev();
extern void _ZN10S1541C4_nt3v37Ev();
extern void _ZN10S1541C4_nt3v38Ev();
extern void _ZN10S1541C4_nt3v39Ev();
extern void _ZN10S1541C4_nt3v40Ev();
extern void _ZN10S1541C4_nt3v41Ev();
extern void _ZN10S1541C4_nt3v42Ev();
extern void _ZN10S1541C4_nt3v43Ev();
extern void _ZN10S1541C4_nt3v44Ev();
extern void _ZN10S1541C4_nt3v45Ev();
extern void _ZN10S1541C4_nt3v46Ev();
extern void _ZN10S1541C4_nt3v47Ev();
extern void _ZN10S1541C4_nt3v48Ev();
extern void _ZN10S1541C4_nt3v49Ev();
extern void _ZN10S1541C4_nt3v50Ev();
extern void _ZN10S1541C4_nt3v51Ev();
extern void _ZN10S1541C4_nt3v52Ev();
extern void _ZN10S1541C4_nt3v53Ev();
extern void _ZN10S1541C4_nt3v54Ev();
extern void _ZN10S1541C4_nt3v55Ev();
extern void _ZN10S1541C4_nt3v56Ev();
extern void _ZN10S1541C4_nt3v57Ev();
extern void _ZN10S1541C4_nt3v58Ev();
extern void _ZN10S1541C4_nt3v59Ev();
extern void _ZN10S1541C4_nt3v60Ev();
extern void _ZN10S1541C4_nt3v61Ev();
extern void _ZN10S1541C4_nt3v62Ev();
extern void _ZN10S1541C4_nt3v63Ev();
extern void _ZN10S1541C4_nt3v64Ev();
extern void _ZN10S1541C4_nt3v65Ev();
extern void _ZN10S1541C4_nt3v66Ev();
extern void _ZN10S1541C4_nt3v67Ev();
extern void _ZN10S1541C4_nt3v68Ev();
extern void _ZN10S1541C4_nt3v69Ev();
extern void _ZN10S1541C4_nt3v70Ev();
extern void _ZN10S1541C3_nt3v71Ev();
extern void _ZN10S1541C3_nt3v72Ev();
extern void _ZN10S1541C3_nt3v73Ev();
extern void _ZN10S1541C3_nt3v74Ev();
extern void _ZN10S1541C3_nt3v75Ev();
extern void _ZN10S1541C3_nt3v76Ev();
extern void _ZN10S1541C3_nt3v77Ev();
extern void _ZN10S1541C3_nt3v78Ev();
extern void _ZN10S1541C3_nt3v79Ev();
extern void _ZN10S1541C3_nt3v80Ev();
extern void _ZN10S1541C3_nt3v81Ev();
extern void _ZN10S1541C3_nt3v82Ev();
extern void _ZN10S1541C3_nt3v83Ev();
extern void _ZN10S1541C3_nt3v84Ev();
extern void _ZN10S1541C3_nt3v85Ev();
extern void _ZN10S1541C3_nt3v86Ev();
extern void _ZN10S1541C3_nt3v87Ev();
extern void _ZN10S1541C3_nt3v88Ev();
extern void _ZN10S1541C3_nt3v89Ev();
extern void _ZN10S1541C3_nt3v90Ev();
extern void _ZN10S1541C3_nt3v91Ev();
extern void _ZN10S1541C3_nt3v92Ev();
extern void _ZN10S1541C3_nt3v93Ev();
extern void _ZN10S1541C3_nt3v94Ev();
extern void _ZN10S1541C3_nt3v95Ev();
extern void _ZN10S1541C3_nt3v96Ev();
extern void _ZN10S1541C3_nt3v97Ev();
extern void _ZN10S1541C3_nt3v98Ev();
extern void _ZN10S1541C3_nt3v99Ev();
extern void _ZN10S1541C3_nt4v100Ev();
extern void _ZN10S1541C3_nt4v101Ev();
extern void _ZN10S1541C3_nt4v102Ev();
extern void _ZN10S1541C3_nt4v103Ev();
extern void _ZN10S1541C3_nt4v104Ev();
extern void _ZN10S1541C3_nt4v105Ev();
extern void _ZN10S1541C3_nt4v106Ev();
extern void _ZN10S1541C3_nt4v107Ev();
extern void _ZN10S1541C3_nt4v108Ev();
extern void _ZN10S1541C3_nt4v109Ev();
extern void _ZN10S1541C3_nt4v110Ev();
extern void _ZN10S1541C3_nt4v111Ev();
extern void _ZN10S1541C3_nt4v112Ev();
extern void _ZN10S1541C3_nt4v113Ev();
extern void _ZN10S1541C3_nt4v114Ev();
extern void _ZN10S1541C3_nt4v115Ev();
extern void _ZN10S1541C3_nt4v116Ev();
extern void _ZN10S1541C3_nt4v117Ev();
extern void _ZN10S1541C3_nt4v118Ev();
extern void _ZN10S1541C3_nt4v119Ev();
extern void _ZN10S1541C3_nt4v120Ev();
extern void _ZN10S1541C3_nt4v121Ev();
extern void _ZN10S1541C3_nt4v122Ev();
extern void _ZN10S1541C3_nt4v123Ev();
extern void _ZN10S1541C3_nt4v124Ev();
extern void _ZN10S1541C3_nt4v125Ev();
extern void _ZN10S1541C3_nt4v126Ev();
extern void _ZN10S1541C3_nt4v127Ev();
extern void _ZN10S1541C3_nt4v128Ev();
extern void _ZN10S1541C3_nt4v129Ev();
extern void _ZN10S1541C3_nt4v130Ev();
extern void _ZN10S1541C3_nt4v131Ev();
extern void _ZN10S1541C3_nt4v132Ev();
extern void _ZN10S1541C3_nt4v133Ev();
extern void _ZN10S1541C3_nt4v134Ev();
extern void _ZN10S1541C3_nt4v135Ev();
extern void _ZN10S1541C3_nt4v136Ev();
extern void _ZN10S1541C3_nt4v137Ev();
extern void _ZN10S1541C3_nt4v138Ev();
extern void _ZN10S1541C3_nt4v139Ev();
extern void _ZN10S1541C3_nt4v140Ev();
extern void _ZN10S1541C3_nt4v141Ev();
extern void _ZN10S1541C3_nt4v142Ev();
extern void _ZN10S1541C3_nt4v143Ev();
extern void _ZN10S1541C3_nt4v144Ev();
extern void _ZN10S1541C3_nt4v145Ev();
extern void _ZN10S1541C3_nt4v146Ev();
extern void _ZN10S1541C3_nt4v147Ev();
extern void _ZN10S1541C3_nt4v148Ev();
extern void _ZN10S1541C3_nt4v149Ev();
extern void _ZN10S1541C3_nt4v150Ev();
extern void _ZN10S1541C3_nt4v151Ev();
extern void _ZN10S1541C3_nt4v152Ev();
extern void _ZN10S1541C3_nt4v153Ev();
extern void _ZN10S1541C3_nt4v154Ev();
extern void _ZN10S1541C3_nt4v155Ev();
extern void _ZN10S1541C3_nt4v156Ev();
extern void _ZN10S1541C3_nt4v157Ev();
extern void _ZN10S1541C3_nt4v158Ev();
extern void _ZN10S1541C3_nt4v159Ev();
extern void _ZN10S1541C3_nt4v160Ev();
extern void _ZN10S1541C3_nt4v161Ev();
extern void _ZN10S1541C3_nt4v162Ev();
extern void _ZN10S1541C3_nt4v163Ev();
extern void _ZN10S1541C3_nt4v164Ev();
extern void _ZN10S1541C3_nt4v165Ev();
extern void _ZN10S1541C3_nt4v166Ev();
extern void _ZN10S1541C3_nt4v167Ev();
extern void _ZN10S1541C3_nt4v168Ev();
extern void _ZN10S1541C3_nt4v169Ev();
extern void _ZN10S1541C3_nt4v170Ev();
extern void _ZN10S1541C3_nt4v171Ev();
extern void _ZN10S1541C3_nt4v172Ev();
extern void _ZN10S1541C3_nt4v173Ev();
extern void _ZN10S1541C3_nt4v174Ev();
extern void _ZN10S1541C3_nt4v175Ev();
extern void _ZN10S1541C3_nt4v176Ev();
extern void _ZN10S1541C3_nt4v177Ev();
extern void _ZN10S1541C3_nt4v178Ev();
extern void _ZN10S1541C3_nt4v179Ev();
extern void _ZN10S1541C3_nt4v180Ev();
extern void _ZN10S1541C3_nt4v181Ev();
extern void _ZN10S1541C3_nt4v182Ev();
extern void _ZN10S1541C3_nt4v183Ev();
extern void _ZN10S1541C3_nt4v184Ev();
extern void _ZN10S1541C3_nt4v185Ev();
extern void _ZN10S1541C3_nt4v186Ev();
extern void _ZN10S1541C3_nt4v187Ev();
extern void _ZN10S1541C3_nt4v188Ev();
extern void _ZN10S1541C3_nt4v189Ev();
extern void _ZN10S1541C3_nt4v190Ev();
extern void _ZN10S1541C3_nt4v191Ev();
extern void _ZN10S1541C3_nt4v192Ev();
extern void _ZN10S1541C3_nt4v193Ev();
extern void _ZN10S1541C3_nt4v194Ev();
extern void _ZN10S1541C3_nt4v195Ev();
extern void _ZN10S1541C3_nt4v196Ev();
extern void _ZN10S1541C3_nt4v197Ev();
extern void _ZN10S1541C3_nt4v198Ev();
extern void _ZN10S1541C3_nt4v199Ev();
extern void _ZN10S1541C3_nt4v200Ev();
extern void _ZN10S1541C3_nt4v201Ev();
extern void _ZN10S1541C3_nt4v202Ev();
extern void _ZN10S1541C3_nt4v203Ev();
extern void _ZN10S1541C3_nt4v204Ev();
extern void _ZN10S1541C3_nt4v205Ev();
extern void _ZN10S1541C3_nt4v206Ev();
extern void _ZN10S1541C3_nt4v207Ev();
extern void _ZN10S1541C3_nt4v208Ev();
extern void _ZN10S1541C3_nt4v209Ev();
extern void _ZN10S1541C3_nt4v210Ev();
extern void _ZN10S1541C3_nt4v211Ev();
extern void _ZN10S1541C3_nt4v212Ev();
extern void _ZN10S1541C3_nt4v213Ev();
static  VTBL_ENTRY vtc_S1541C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1541C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1541C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v213Ev,
};
extern VTBL_ENTRY _ZTI10S1541C3_nt[];
VTBL_ENTRY *P__ZTI10S1541C3_nt = _ZTI10S1541C3_nt; 
extern  VTBL_ENTRY _ZTV10S1541C3_nt[];
Class_Descriptor cd_S1541C3_nt = {  "S1541C3_nt", // class name
  bases_S1541C3_nt, 1,
  &(vtc_S1541C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1541C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1541C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C22_nt  {
  void  mf1541c22(); // _ZN11S1541C22_nt9mf1541c22Ev
};
//SIG(-1 S1541C22_nt) C1{ m}


void  S1541C22_nt ::mf1541c22(){}

//skip512 S1541C22_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S1541C22_nt[];
VTBL_ENTRY *P__ZTI11S1541C22_nt = _ZTI11S1541C22_nt; 
Class_Descriptor cd_S1541C22_nt = {  "S1541C22_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S1541C22_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C23_nt  {
  unsigned int s1541c23f0:1;
  unsigned int s1541c23f1:1;
  unsigned int s1541c23f2:1;
  unsigned int s1541c23f3:1;
  int s1541c23f4[6];
  ::S1541C22_nt s1541c23f5;
  char s1541c23f6;
  int s1541c23f7[2];
  ::S1541C14_nt s1541c23f8;
  int s1541c23f9[3];
  unsigned int s1541c23f10:1;
  int s1541c23f11[4];
  ::S1541C14_nt s1541c23f12;
  ::S1541C14_nt s1541c23f13;
  ::S1541C14_nt s1541c23f14;
  int s1541c23f15;
  void  mf1541c23(); // _ZN11S1541C23_nt9mf1541c23Ev
};
//SIG(-1 S1541C23_nt) C1{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC2{ m} Fc Fi[2] FC3{ m Fi[3]} Fi[3] Fi:1 Fi[4] FC3 FC3 FC3 Fi}


void  S1541C23_nt ::mf1541c23(){}

//skip512 S1541C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C25  {
  ::S1541C14_nt s1541c25f0;
  ::S1541C14_nt s1541c25f1;
  int s1541c25f2;
  void  mf1541c25(); // _ZN8S1541C259mf1541c25Ev
};
//SIG(-1 S1541C25) C1{ m FC2{ m Fi[3]} FC2 Fi}


void  S1541C25 ::mf1541c25(){}

static void Test_S1541C25()
{
  {
    init_simple_test("S1541C25");
    S1541C25 lv;
    check2(sizeof(lv), 28, "sizeof(S1541C25)");
    check2(__alignof__(lv), 4, "__alignof__(S1541C25)");
    check_field_offset(lv, s1541c25f0, 0, "S1541C25.s1541c25f0");
    check_field_offset(lv, s1541c25f1, 12, "S1541C25.s1541c25f1");
    check_field_offset(lv, s1541c25f2, 24, "S1541C25.s1541c25f2");
  }
}
static Arrange_To_Call_Me vS1541C25(Test_S1541C25, "S1541C25", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C24  {
  int s1541c24f0;
  ::S1541C25 s1541c24f1;
};
//SIG(-1 S1541C24) C1{ Fi FC2{ m FC3{ m Fi[3]} FC3 Fi}}



static void Test_S1541C24()
{
  {
    init_simple_test("S1541C24");
    S1541C24 lv;
    check2(sizeof(lv), 32, "sizeof(S1541C24)");
    check2(__alignof__(lv), 4, "__alignof__(S1541C24)");
    check_field_offset(lv, s1541c24f0, 0, "S1541C24.s1541c24f0");
    check_field_offset(lv, s1541c24f1, 4, "S1541C24.s1541c24f1");
  }
}
static Arrange_To_Call_Me vS1541C24(Test_S1541C24, "S1541C24", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C26  {
  void *s1541c26f0[2];
  ::S1541C25 s1541c26f1;
  int s1541c26f2;
  void *s1541c26f3;
};
//SIG(-1 S1541C26) C1{ Fp[2] FC2{ m FC3{ m Fi[3]} FC3 Fi} Fi Fp}



static void Test_S1541C26()
{
  {
    init_simple_test("S1541C26");
    S1541C26 lv;
    check2(sizeof(lv), ABISELECT(56,44), "sizeof(S1541C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C26)");
    check_field_offset(lv, s1541c26f0, 0, "S1541C26.s1541c26f0");
    check_field_offset(lv, s1541c26f1, ABISELECT(16,8), "S1541C26.s1541c26f1");
    check_field_offset(lv, s1541c26f2, ABISELECT(44,36), "S1541C26.s1541c26f2");
    check_field_offset(lv, s1541c26f3, ABISELECT(48,40), "S1541C26.s1541c26f3");
  }
}
static Arrange_To_Call_Me vS1541C26(Test_S1541C26, "S1541C26", ABISELECT(56,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C27  {
  int s1541c27f0;
  char s1541c27f1;
  int s1541c27f2;
  void  mf1541c27(); // _ZN8S1541C279mf1541c27Ev
};
//SIG(-1 S1541C27) C1{ m Fi Fc Fi}


void  S1541C27 ::mf1541c27(){}

static void Test_S1541C27()
{
  {
    init_simple_test("S1541C27");
    S1541C27 lv;
    check2(sizeof(lv), 12, "sizeof(S1541C27)");
    check2(__alignof__(lv), 4, "__alignof__(S1541C27)");
    check_field_offset(lv, s1541c27f0, 0, "S1541C27.s1541c27f0");
    check_field_offset(lv, s1541c27f1, 4, "S1541C27.s1541c27f1");
    check_field_offset(lv, s1541c27f2, 8, "S1541C27.s1541c27f2");
  }
}
static Arrange_To_Call_Me vS1541C27(Test_S1541C27, "S1541C27", 12);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C29  : S1541C8_nt {
};
//SIG(-1 S1541C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1541C29()
{
  extern Class_Descriptor cd_S1541C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C29, buf);
    S1541C29 &lv = *(new (buf) S1541C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C29)");
    check_base_class_offset(lv, (S1541C8_nt*), 0, "S1541C29");
    test_class_info(&lv, &cd_S1541C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C29(Test_S1541C29, "S1541C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
static Base_Class bases_S1541C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C29 = {  "S1541C29", // class name
  bases_S1541C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C28  : S1541C29 {
};
//SIG(-1 S1541C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1541C28()
{
  extern Class_Descriptor cd_S1541C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1541C28, buf);
    S1541C28 &lv = *(new (buf) S1541C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1541C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C28)");
    check_base_class_offset(lv, (S1541C8_nt*)(S1541C29*), 0, "S1541C28");
    check_base_class_offset(lv, (S1541C29*), 0, "S1541C28");
    test_class_info(&lv, &cd_S1541C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C28(Test_S1541C28, "S1541C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1541C8_nt;
extern Class_Descriptor cd_S1541C29;
static Base_Class bases_S1541C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1541C28 = {  "S1541C28", // class name
  bases_S1541C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C2  : S1541C3_nt {
  void *s1541c2f0;
  ::S1541C5_nt s1541c2f1;
  int s1541c2f2;
  unsigned int s1541c2f3:1;
  unsigned int s1541c2f4:1;
  unsigned int s1541c2f5:1;
  unsigned int s1541c2f6:1;
  unsigned int s1541c2f7:1;
  unsigned int s1541c2f8:1;
  int s1541c2f9[3];
  ::S1541C22_nt s1541c2f10;
  int s1541c2f11;
  ::S1541C23_nt s1541c2f12;
  ::S1541C14_nt s1541c2f13;
  ::S1541C14_nt s1541c2f14;
  ::S1541C14_nt s1541c2f15;
  int s1541c2f16[2];
  ::S1541C24 s1541c2f17;
  ::S1541C26 s1541c2f18;
  ::S1541C26 s1541c2f19;
  int s1541c2f20;
  ::S1541C27 s1541c2f21;
  ::S1541C28 s1541c2f22;
  int s1541c2f23;
  ::S1541C14_nt s1541c2f24;
  virtual  ~S1541C2(); // _ZN7S1541C2D1Ev
  virtual void  v214(); // _ZN7S1541C24v214Ev
  virtual void  v215(); // _ZN7S1541C24v215Ev
  virtual void  v216(); // _ZN7S1541C24v216Ev
  virtual void  v217(); // _ZN7S1541C24v217Ev
  virtual void  v218(); // _ZN7S1541C24v218Ev
  S1541C2(); // tgen
};
//SIG(-1 S1541C2) C1{ BC2{ BC3{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 Fp FC4 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] FC14{ m} Fi FC15{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC14 Fc Fi[2] FC11 Fi[3] Fi:1 Fi[4] FC11 FC11 FC11 Fi} FC11 FC11 FC11 Fi[2] FC16{ Fi FC17{ m FC11 FC11 Fi}} FC18{ Fp[2] FC17 Fi Fp} FC18 Fi FC19{ m Fi Fc Fi} FC20{ BC21{ BC7}} Fi FC11}


 S1541C2 ::~S1541C2(){ note_dtor("S1541C2", this);}
void  S1541C2 ::v214(){vfunc_called(this, "_ZN7S1541C24v214Ev");}
void  S1541C2 ::v215(){vfunc_called(this, "_ZN7S1541C24v215Ev");}
void  S1541C2 ::v216(){vfunc_called(this, "_ZN7S1541C24v216Ev");}
void  S1541C2 ::v217(){vfunc_called(this, "_ZN7S1541C24v217Ev");}
void  S1541C2 ::v218(){vfunc_called(this, "_ZN7S1541C24v218Ev");}
S1541C2 ::S1541C2(){ note_ctor("S1541C2", this);} // tgen

static void Test_S1541C2()
{
  extern Class_Descriptor cd_S1541C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(123,203)];
    init_test(&cd_S1541C2, buf);
    S1541C2 *dp, &lv = *(dp=new (buf) S1541C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(976,808), "sizeof(S1541C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C2)");
    check_base_class_offset(lv, (S1541C4_nt*)(S1541C3_nt*), 0, "S1541C2");
    check_base_class_offset(lv, (S1541C3_nt*), 0, "S1541C2");
    check_field_offset(lv, s1541c2f0, ABISELECT(568,436), "S1541C2.s1541c2f0");
    check_field_offset(lv, s1541c2f1, ABISELECT(576,440), "S1541C2.s1541c2f1");
    check_field_offset(lv, s1541c2f2, ABISELECT(584,448), "S1541C2.s1541c2f2");
    set_bf_and_test(lv, s1541c2f3, ABISELECT(588,452), 0, 1, 1, "S1541C2");
    set_bf_and_test(lv, s1541c2f4, ABISELECT(588,452), 1, 1, 1, "S1541C2");
    set_bf_and_test(lv, s1541c2f5, ABISELECT(588,452), 2, 1, 1, "S1541C2");
    set_bf_and_test(lv, s1541c2f6, ABISELECT(588,452), 3, 1, 1, "S1541C2");
    set_bf_and_test(lv, s1541c2f7, ABISELECT(588,452), 4, 1, 1, "S1541C2");
    set_bf_and_test(lv, s1541c2f8, ABISELECT(588,452), 5, 1, 1, "S1541C2");
    check_field_offset(lv, s1541c2f9, ABISELECT(592,456), "S1541C2.s1541c2f9");
    check_field_offset(lv, s1541c2f10, ABISELECT(604,468), "S1541C2.s1541c2f10");
    check_field_offset(lv, s1541c2f11, ABISELECT(608,472), "S1541C2.s1541c2f11");
    check_field_offset(lv, s1541c2f12, ABISELECT(612,476), "S1541C2.s1541c2f12");
    check_field_offset(lv, s1541c2f13, ABISELECT(736,600), "S1541C2.s1541c2f13");
    check_field_offset(lv, s1541c2f14, ABISELECT(748,612), "S1541C2.s1541c2f14");
    check_field_offset(lv, s1541c2f15, ABISELECT(760,624), "S1541C2.s1541c2f15");
    check_field_offset(lv, s1541c2f16, ABISELECT(772,636), "S1541C2.s1541c2f16");
    check_field_offset(lv, s1541c2f17, ABISELECT(780,644), "S1541C2.s1541c2f17");
    check_field_offset(lv, s1541c2f18, ABISELECT(816,676), "S1541C2.s1541c2f18");
    check_field_offset(lv, s1541c2f19, ABISELECT(872,720), "S1541C2.s1541c2f19");
    check_field_offset(lv, s1541c2f20, ABISELECT(928,764), "S1541C2.s1541c2f20");
    check_field_offset(lv, s1541c2f21, ABISELECT(932,768), "S1541C2.s1541c2f21");
    check_field_offset(lv, s1541c2f22, ABISELECT(944,780), "S1541C2.s1541c2f22");
    check_field_offset(lv, s1541c2f23, ABISELECT(960,792), "S1541C2.s1541c2f23");
    check_field_offset(lv, s1541c2f24, ABISELECT(964,796), "S1541C2.s1541c2f24");
    test_class_info(&lv, &cd_S1541C2);
    dp->~S1541C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C2(Test_S1541C2, "S1541C2", ABISELECT(976,808));

#else // __cplusplus

extern void _ZN7S1541C2C1Ev();
extern void _ZN7S1541C2D1Ev();
Name_Map name_map_S1541C2[] = {
  NSPAIR(_ZN7S1541C2C1Ev),
  NSPAIR(_ZN7S1541C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1541C4_nt;
extern VTBL_ENTRY _ZTI10S1541C4_nt[];
extern  VTBL_ENTRY _ZTV10S1541C4_nt[];
extern Class_Descriptor cd_S1541C3_nt;
extern VTBL_ENTRY _ZTI10S1541C3_nt[];
extern  VTBL_ENTRY _ZTV10S1541C3_nt[];
static Base_Class bases_S1541C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1541C2[];
extern void _ZN7S1541C2D1Ev();
extern void _ZN7S1541C2D0Ev();
extern void _ZN10S1541C4_nt2v7Ev();
extern void _ZN10S1541C4_nt2v8Ev();
extern void _ZN10S1541C4_nt2v9Ev();
extern void _ZN10S1541C4_nt3v10Ev();
extern void _ZN10S1541C4_nt3v11Ev();
extern void _ZN10S1541C4_nt3v12Ev();
extern void _ZN10S1541C4_nt3v13Ev();
extern void _ZN10S1541C4_nt3v14Ev();
extern void _ZN10S1541C4_nt3v15Ev();
extern void _ZN10S1541C4_nt3v16Ev();
extern void _ZN10S1541C4_nt3v17Ev();
extern void _ZN10S1541C4_nt3v18Ev();
extern void _ZN10S1541C4_nt3v19Ev();
extern void _ZN10S1541C4_nt3v20Ev();
extern void _ZN10S1541C4_nt3v21Ev();
extern void _ZN10S1541C4_nt3v22Ev();
extern void _ZN10S1541C4_nt3v23Ev();
extern void _ZN10S1541C4_nt3v24Ev();
extern void _ZN10S1541C4_nt3v25Ev();
extern void _ZN10S1541C4_nt3v26Ev();
extern void _ZN10S1541C4_nt3v27Ev();
extern void _ZN10S1541C4_nt3v28Ev();
extern void _ZN10S1541C4_nt3v29Ev();
extern void _ZN10S1541C4_nt3v30Ev();
extern void _ZN10S1541C4_nt3v31Ev();
extern void _ZN10S1541C4_nt3v32Ev();
extern void _ZN10S1541C4_nt3v33Ev();
extern void _ZN10S1541C4_nt3v34Ev();
extern void _ZN10S1541C4_nt3v35Ev();
extern void _ZN10S1541C4_nt3v36Ev();
extern void _ZN10S1541C4_nt3v37Ev();
extern void _ZN10S1541C4_nt3v38Ev();
extern void _ZN10S1541C4_nt3v39Ev();
extern void _ZN10S1541C4_nt3v40Ev();
extern void _ZN10S1541C4_nt3v41Ev();
extern void _ZN10S1541C4_nt3v42Ev();
extern void _ZN10S1541C4_nt3v43Ev();
extern void _ZN10S1541C4_nt3v44Ev();
extern void _ZN10S1541C4_nt3v45Ev();
extern void _ZN10S1541C4_nt3v46Ev();
extern void _ZN10S1541C4_nt3v47Ev();
extern void _ZN10S1541C4_nt3v48Ev();
extern void _ZN10S1541C4_nt3v49Ev();
extern void _ZN10S1541C4_nt3v50Ev();
extern void _ZN10S1541C4_nt3v51Ev();
extern void _ZN10S1541C4_nt3v52Ev();
extern void _ZN10S1541C4_nt3v53Ev();
extern void _ZN10S1541C4_nt3v54Ev();
extern void _ZN10S1541C4_nt3v55Ev();
extern void _ZN10S1541C4_nt3v56Ev();
extern void _ZN10S1541C4_nt3v57Ev();
extern void _ZN10S1541C4_nt3v58Ev();
extern void _ZN10S1541C4_nt3v59Ev();
extern void _ZN10S1541C4_nt3v60Ev();
extern void _ZN10S1541C4_nt3v61Ev();
extern void _ZN10S1541C4_nt3v62Ev();
extern void _ZN10S1541C4_nt3v63Ev();
extern void _ZN10S1541C4_nt3v64Ev();
extern void _ZN10S1541C4_nt3v65Ev();
extern void _ZN10S1541C4_nt3v66Ev();
extern void _ZN10S1541C4_nt3v67Ev();
extern void _ZN10S1541C4_nt3v68Ev();
extern void _ZN10S1541C4_nt3v69Ev();
extern void _ZN10S1541C4_nt3v70Ev();
extern void _ZN10S1541C3_nt3v71Ev();
extern void _ZN10S1541C3_nt3v72Ev();
extern void _ZN10S1541C3_nt3v73Ev();
extern void _ZN10S1541C3_nt3v74Ev();
extern void _ZN10S1541C3_nt3v75Ev();
extern void _ZN10S1541C3_nt3v76Ev();
extern void _ZN10S1541C3_nt3v77Ev();
extern void _ZN10S1541C3_nt3v78Ev();
extern void _ZN10S1541C3_nt3v79Ev();
extern void _ZN10S1541C3_nt3v80Ev();
extern void _ZN10S1541C3_nt3v81Ev();
extern void _ZN10S1541C3_nt3v82Ev();
extern void _ZN10S1541C3_nt3v83Ev();
extern void _ZN10S1541C3_nt3v84Ev();
extern void _ZN10S1541C3_nt3v85Ev();
extern void _ZN10S1541C3_nt3v86Ev();
extern void _ZN10S1541C3_nt3v87Ev();
extern void _ZN10S1541C3_nt3v88Ev();
extern void _ZN10S1541C3_nt3v89Ev();
extern void _ZN10S1541C3_nt3v90Ev();
extern void _ZN10S1541C3_nt3v91Ev();
extern void _ZN10S1541C3_nt3v92Ev();
extern void _ZN10S1541C3_nt3v93Ev();
extern void _ZN10S1541C3_nt3v94Ev();
extern void _ZN10S1541C3_nt3v95Ev();
extern void _ZN10S1541C3_nt3v96Ev();
extern void _ZN10S1541C3_nt3v97Ev();
extern void _ZN10S1541C3_nt3v98Ev();
extern void _ZN10S1541C3_nt3v99Ev();
extern void _ZN10S1541C3_nt4v100Ev();
extern void _ZN10S1541C3_nt4v101Ev();
extern void _ZN10S1541C3_nt4v102Ev();
extern void _ZN10S1541C3_nt4v103Ev();
extern void _ZN10S1541C3_nt4v104Ev();
extern void _ZN10S1541C3_nt4v105Ev();
extern void _ZN10S1541C3_nt4v106Ev();
extern void _ZN10S1541C3_nt4v107Ev();
extern void _ZN10S1541C3_nt4v108Ev();
extern void _ZN10S1541C3_nt4v109Ev();
extern void _ZN10S1541C3_nt4v110Ev();
extern void _ZN10S1541C3_nt4v111Ev();
extern void _ZN10S1541C3_nt4v112Ev();
extern void _ZN10S1541C3_nt4v113Ev();
extern void _ZN10S1541C3_nt4v114Ev();
extern void _ZN10S1541C3_nt4v115Ev();
extern void _ZN10S1541C3_nt4v116Ev();
extern void _ZN10S1541C3_nt4v117Ev();
extern void _ZN10S1541C3_nt4v118Ev();
extern void _ZN10S1541C3_nt4v119Ev();
extern void _ZN10S1541C3_nt4v120Ev();
extern void _ZN10S1541C3_nt4v121Ev();
extern void _ZN10S1541C3_nt4v122Ev();
extern void _ZN10S1541C3_nt4v123Ev();
extern void _ZN10S1541C3_nt4v124Ev();
extern void _ZN10S1541C3_nt4v125Ev();
extern void _ZN10S1541C3_nt4v126Ev();
extern void _ZN10S1541C3_nt4v127Ev();
extern void _ZN10S1541C3_nt4v128Ev();
extern void _ZN10S1541C3_nt4v129Ev();
extern void _ZN10S1541C3_nt4v130Ev();
extern void _ZN10S1541C3_nt4v131Ev();
extern void _ZN10S1541C3_nt4v132Ev();
extern void _ZN10S1541C3_nt4v133Ev();
extern void _ZN10S1541C3_nt4v134Ev();
extern void _ZN10S1541C3_nt4v135Ev();
extern void _ZN10S1541C3_nt4v136Ev();
extern void _ZN10S1541C3_nt4v137Ev();
extern void _ZN10S1541C3_nt4v138Ev();
extern void _ZN10S1541C3_nt4v139Ev();
extern void _ZN10S1541C3_nt4v140Ev();
extern void _ZN10S1541C3_nt4v141Ev();
extern void _ZN10S1541C3_nt4v142Ev();
extern void _ZN10S1541C3_nt4v143Ev();
extern void _ZN10S1541C3_nt4v144Ev();
extern void _ZN10S1541C3_nt4v145Ev();
extern void _ZN10S1541C3_nt4v146Ev();
extern void _ZN10S1541C3_nt4v147Ev();
extern void _ZN10S1541C3_nt4v148Ev();
extern void _ZN10S1541C3_nt4v149Ev();
extern void _ZN10S1541C3_nt4v150Ev();
extern void _ZN10S1541C3_nt4v151Ev();
extern void _ZN10S1541C3_nt4v152Ev();
extern void _ZN10S1541C3_nt4v153Ev();
extern void _ZN10S1541C3_nt4v154Ev();
extern void _ZN10S1541C3_nt4v155Ev();
extern void _ZN10S1541C3_nt4v156Ev();
extern void _ZN10S1541C3_nt4v157Ev();
extern void _ZN10S1541C3_nt4v158Ev();
extern void _ZN10S1541C3_nt4v159Ev();
extern void _ZN10S1541C3_nt4v160Ev();
extern void _ZN10S1541C3_nt4v161Ev();
extern void _ZN10S1541C3_nt4v162Ev();
extern void _ZN10S1541C3_nt4v163Ev();
extern void _ZN10S1541C3_nt4v164Ev();
extern void _ZN10S1541C3_nt4v165Ev();
extern void _ZN10S1541C3_nt4v166Ev();
extern void _ZN10S1541C3_nt4v167Ev();
extern void _ZN10S1541C3_nt4v168Ev();
extern void _ZN10S1541C3_nt4v169Ev();
extern void _ZN10S1541C3_nt4v170Ev();
extern void _ZN10S1541C3_nt4v171Ev();
extern void _ZN10S1541C3_nt4v172Ev();
extern void _ZN10S1541C3_nt4v173Ev();
extern void _ZN10S1541C3_nt4v174Ev();
extern void _ZN10S1541C3_nt4v175Ev();
extern void _ZN10S1541C3_nt4v176Ev();
extern void _ZN10S1541C3_nt4v177Ev();
extern void _ZN10S1541C3_nt4v178Ev();
extern void _ZN10S1541C3_nt4v179Ev();
extern void _ZN10S1541C3_nt4v180Ev();
extern void _ZN10S1541C3_nt4v181Ev();
extern void _ZN10S1541C3_nt4v182Ev();
extern void _ZN10S1541C3_nt4v183Ev();
extern void _ZN10S1541C3_nt4v184Ev();
extern void _ZN10S1541C3_nt4v185Ev();
extern void _ZN10S1541C3_nt4v186Ev();
extern void _ZN10S1541C3_nt4v187Ev();
extern void _ZN10S1541C3_nt4v188Ev();
extern void _ZN10S1541C3_nt4v189Ev();
extern void _ZN10S1541C3_nt4v190Ev();
extern void _ZN10S1541C3_nt4v191Ev();
extern void _ZN10S1541C3_nt4v192Ev();
extern void _ZN10S1541C3_nt4v193Ev();
extern void _ZN10S1541C3_nt4v194Ev();
extern void _ZN10S1541C3_nt4v195Ev();
extern void _ZN10S1541C3_nt4v196Ev();
extern void _ZN10S1541C3_nt4v197Ev();
extern void _ZN10S1541C3_nt4v198Ev();
extern void _ZN10S1541C3_nt4v199Ev();
extern void _ZN10S1541C3_nt4v200Ev();
extern void _ZN10S1541C3_nt4v201Ev();
extern void _ZN10S1541C3_nt4v202Ev();
extern void _ZN10S1541C3_nt4v203Ev();
extern void _ZN10S1541C3_nt4v204Ev();
extern void _ZN10S1541C3_nt4v205Ev();
extern void _ZN10S1541C3_nt4v206Ev();
extern void _ZN10S1541C3_nt4v207Ev();
extern void _ZN10S1541C3_nt4v208Ev();
extern void _ZN10S1541C3_nt4v209Ev();
extern void _ZN10S1541C3_nt4v210Ev();
extern void _ZN10S1541C3_nt4v211Ev();
extern void _ZN10S1541C3_nt4v212Ev();
extern void _ZN10S1541C3_nt4v213Ev();
extern void _ZN7S1541C24v214Ev();
extern void _ZN7S1541C24v215Ev();
extern void _ZN7S1541C24v216Ev();
extern void _ZN7S1541C24v217Ev();
extern void _ZN7S1541C24v218Ev();
static  VTBL_ENTRY vtc_S1541C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1541C2[0]),
  (VTBL_ENTRY)&_ZN7S1541C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1541C2D0Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v214Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v215Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v216Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v217Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v218Ev,
};
extern VTBL_ENTRY _ZTI7S1541C2[];
extern  VTBL_ENTRY _ZTV7S1541C2[];
Class_Descriptor cd_S1541C2 = {  "S1541C2", // class name
  bases_S1541C2, 2,
  &(vtc_S1541C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(976,808), // object size
  NSPAIRA(_ZTI7S1541C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1541C2),216, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1541C1  : S1541C2 {
  void *s1541c1f0[8];
  ::S1541C28 s1541c1f1;
  ::S1541C28 s1541c1f2;
  void *s1541c1f3[2];
  virtual  ~S1541C1(); // _ZN7S1541C1D1Ev
  virtual void  v1(); // _ZN7S1541C12v1Ev
  virtual void  v2(); // _ZN7S1541C12v2Ev
  virtual void  v3(); // _ZN7S1541C12v3Ev
  virtual void  v4(); // _ZN7S1541C12v4Ev
  virtual void  v5(); // _ZN7S1541C12v5Ev
  virtual void  v6(); // _ZN7S1541C12v6Ev
  S1541C1(); // tgen
};
//SIG(1 S1541C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v214 v215 v216 v217 v218 Fp FC5 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[3] FC15{ m} Fi FC16{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC15 Fc Fi[2] FC12 Fi[3] Fi:1 Fi[4] FC12 FC12 FC12 Fi} FC12 FC12 FC12 Fi[2] FC17{ Fi FC18{ m FC12 FC12 Fi}} FC19{ Fp[2] FC18 Fi Fp} FC19 Fi FC20{ m Fi Fc Fi} FC21{ BC22{ BC8}} Fi FC12} vd v1 v2 v3 v4 v5 v6 Fp[8] FC21 FC21 Fp[2]}


 S1541C1 ::~S1541C1(){ note_dtor("S1541C1", this);}
void  S1541C1 ::v1(){vfunc_called(this, "_ZN7S1541C12v1Ev");}
void  S1541C1 ::v2(){vfunc_called(this, "_ZN7S1541C12v2Ev");}
void  S1541C1 ::v3(){vfunc_called(this, "_ZN7S1541C12v3Ev");}
void  S1541C1 ::v4(){vfunc_called(this, "_ZN7S1541C12v4Ev");}
void  S1541C1 ::v5(){vfunc_called(this, "_ZN7S1541C12v5Ev");}
void  S1541C1 ::v6(){vfunc_called(this, "_ZN7S1541C12v6Ev");}
S1541C1 ::S1541C1(){ note_ctor("S1541C1", this);} // tgen

static void Test_S1541C1()
{
  extern Class_Descriptor cd_S1541C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(137,219)];
    init_test(&cd_S1541C1, buf);
    S1541C1 *dp, &lv = *(dp=new (buf) S1541C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1088,872), "sizeof(S1541C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1541C1)");
    check_base_class_offset(lv, (S1541C4_nt*)(S1541C3_nt*)(S1541C2*), 0, "S1541C1");
    check_base_class_offset(lv, (S1541C3_nt*)(S1541C2*), 0, "S1541C1");
    check_base_class_offset(lv, (S1541C2*), 0, "S1541C1");
    check_field_offset(lv, s1541c1f0, ABISELECT(976,808), "S1541C1.s1541c1f0");
    check_field_offset(lv, s1541c1f1, ABISELECT(1040,840), "S1541C1.s1541c1f1");
    check_field_offset(lv, s1541c1f2, ABISELECT(1056,852), "S1541C1.s1541c1f2");
    check_field_offset(lv, s1541c1f3, ABISELECT(1072,864), "S1541C1.s1541c1f3");
    test_class_info(&lv, &cd_S1541C1);
    dp->~S1541C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1541C1(Test_S1541C1, "S1541C1", ABISELECT(1088,872));

#else // __cplusplus

extern void _ZN7S1541C1C1Ev();
extern void _ZN7S1541C1D1Ev();
Name_Map name_map_S1541C1[] = {
  NSPAIR(_ZN7S1541C1C1Ev),
  NSPAIR(_ZN7S1541C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1541C4_nt;
extern VTBL_ENTRY _ZTI10S1541C4_nt[];
extern  VTBL_ENTRY _ZTV10S1541C4_nt[];
extern Class_Descriptor cd_S1541C3_nt;
extern VTBL_ENTRY _ZTI10S1541C3_nt[];
extern  VTBL_ENTRY _ZTV10S1541C3_nt[];
extern Class_Descriptor cd_S1541C2;
extern VTBL_ENTRY _ZTI7S1541C2[];
extern  VTBL_ENTRY _ZTV7S1541C2[];
static Base_Class bases_S1541C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1541C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1541C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1541C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1541C1[];
extern void _ZN7S1541C1D1Ev();
extern void _ZN7S1541C1D0Ev();
extern void _ZN10S1541C4_nt2v7Ev();
extern void _ZN10S1541C4_nt2v8Ev();
extern void _ZN10S1541C4_nt2v9Ev();
extern void _ZN10S1541C4_nt3v10Ev();
extern void _ZN10S1541C4_nt3v11Ev();
extern void _ZN10S1541C4_nt3v12Ev();
extern void _ZN10S1541C4_nt3v13Ev();
extern void _ZN10S1541C4_nt3v14Ev();
extern void _ZN10S1541C4_nt3v15Ev();
extern void _ZN10S1541C4_nt3v16Ev();
extern void _ZN10S1541C4_nt3v17Ev();
extern void _ZN10S1541C4_nt3v18Ev();
extern void _ZN10S1541C4_nt3v19Ev();
extern void _ZN10S1541C4_nt3v20Ev();
extern void _ZN10S1541C4_nt3v21Ev();
extern void _ZN10S1541C4_nt3v22Ev();
extern void _ZN10S1541C4_nt3v23Ev();
extern void _ZN10S1541C4_nt3v24Ev();
extern void _ZN10S1541C4_nt3v25Ev();
extern void _ZN10S1541C4_nt3v26Ev();
extern void _ZN10S1541C4_nt3v27Ev();
extern void _ZN10S1541C4_nt3v28Ev();
extern void _ZN10S1541C4_nt3v29Ev();
extern void _ZN10S1541C4_nt3v30Ev();
extern void _ZN10S1541C4_nt3v31Ev();
extern void _ZN10S1541C4_nt3v32Ev();
extern void _ZN10S1541C4_nt3v33Ev();
extern void _ZN10S1541C4_nt3v34Ev();
extern void _ZN10S1541C4_nt3v35Ev();
extern void _ZN10S1541C4_nt3v36Ev();
extern void _ZN10S1541C4_nt3v37Ev();
extern void _ZN10S1541C4_nt3v38Ev();
extern void _ZN10S1541C4_nt3v39Ev();
extern void _ZN10S1541C4_nt3v40Ev();
extern void _ZN10S1541C4_nt3v41Ev();
extern void _ZN10S1541C4_nt3v42Ev();
extern void _ZN10S1541C4_nt3v43Ev();
extern void _ZN10S1541C4_nt3v44Ev();
extern void _ZN10S1541C4_nt3v45Ev();
extern void _ZN10S1541C4_nt3v46Ev();
extern void _ZN10S1541C4_nt3v47Ev();
extern void _ZN10S1541C4_nt3v48Ev();
extern void _ZN10S1541C4_nt3v49Ev();
extern void _ZN10S1541C4_nt3v50Ev();
extern void _ZN10S1541C4_nt3v51Ev();
extern void _ZN10S1541C4_nt3v52Ev();
extern void _ZN10S1541C4_nt3v53Ev();
extern void _ZN10S1541C4_nt3v54Ev();
extern void _ZN10S1541C4_nt3v55Ev();
extern void _ZN10S1541C4_nt3v56Ev();
extern void _ZN10S1541C4_nt3v57Ev();
extern void _ZN10S1541C4_nt3v58Ev();
extern void _ZN10S1541C4_nt3v59Ev();
extern void _ZN10S1541C4_nt3v60Ev();
extern void _ZN10S1541C4_nt3v61Ev();
extern void _ZN10S1541C4_nt3v62Ev();
extern void _ZN10S1541C4_nt3v63Ev();
extern void _ZN10S1541C4_nt3v64Ev();
extern void _ZN10S1541C4_nt3v65Ev();
extern void _ZN10S1541C4_nt3v66Ev();
extern void _ZN10S1541C4_nt3v67Ev();
extern void _ZN10S1541C4_nt3v68Ev();
extern void _ZN10S1541C4_nt3v69Ev();
extern void _ZN10S1541C4_nt3v70Ev();
extern void _ZN10S1541C3_nt3v71Ev();
extern void _ZN10S1541C3_nt3v72Ev();
extern void _ZN10S1541C3_nt3v73Ev();
extern void _ZN10S1541C3_nt3v74Ev();
extern void _ZN10S1541C3_nt3v75Ev();
extern void _ZN10S1541C3_nt3v76Ev();
extern void _ZN10S1541C3_nt3v77Ev();
extern void _ZN10S1541C3_nt3v78Ev();
extern void _ZN10S1541C3_nt3v79Ev();
extern void _ZN10S1541C3_nt3v80Ev();
extern void _ZN10S1541C3_nt3v81Ev();
extern void _ZN10S1541C3_nt3v82Ev();
extern void _ZN10S1541C3_nt3v83Ev();
extern void _ZN10S1541C3_nt3v84Ev();
extern void _ZN10S1541C3_nt3v85Ev();
extern void _ZN10S1541C3_nt3v86Ev();
extern void _ZN10S1541C3_nt3v87Ev();
extern void _ZN10S1541C3_nt3v88Ev();
extern void _ZN10S1541C3_nt3v89Ev();
extern void _ZN10S1541C3_nt3v90Ev();
extern void _ZN10S1541C3_nt3v91Ev();
extern void _ZN10S1541C3_nt3v92Ev();
extern void _ZN10S1541C3_nt3v93Ev();
extern void _ZN10S1541C3_nt3v94Ev();
extern void _ZN10S1541C3_nt3v95Ev();
extern void _ZN10S1541C3_nt3v96Ev();
extern void _ZN10S1541C3_nt3v97Ev();
extern void _ZN10S1541C3_nt3v98Ev();
extern void _ZN10S1541C3_nt3v99Ev();
extern void _ZN10S1541C3_nt4v100Ev();
extern void _ZN10S1541C3_nt4v101Ev();
extern void _ZN10S1541C3_nt4v102Ev();
extern void _ZN10S1541C3_nt4v103Ev();
extern void _ZN10S1541C3_nt4v104Ev();
extern void _ZN10S1541C3_nt4v105Ev();
extern void _ZN10S1541C3_nt4v106Ev();
extern void _ZN10S1541C3_nt4v107Ev();
extern void _ZN10S1541C3_nt4v108Ev();
extern void _ZN10S1541C3_nt4v109Ev();
extern void _ZN10S1541C3_nt4v110Ev();
extern void _ZN10S1541C3_nt4v111Ev();
extern void _ZN10S1541C3_nt4v112Ev();
extern void _ZN10S1541C3_nt4v113Ev();
extern void _ZN10S1541C3_nt4v114Ev();
extern void _ZN10S1541C3_nt4v115Ev();
extern void _ZN10S1541C3_nt4v116Ev();
extern void _ZN10S1541C3_nt4v117Ev();
extern void _ZN10S1541C3_nt4v118Ev();
extern void _ZN10S1541C3_nt4v119Ev();
extern void _ZN10S1541C3_nt4v120Ev();
extern void _ZN10S1541C3_nt4v121Ev();
extern void _ZN10S1541C3_nt4v122Ev();
extern void _ZN10S1541C3_nt4v123Ev();
extern void _ZN10S1541C3_nt4v124Ev();
extern void _ZN10S1541C3_nt4v125Ev();
extern void _ZN10S1541C3_nt4v126Ev();
extern void _ZN10S1541C3_nt4v127Ev();
extern void _ZN10S1541C3_nt4v128Ev();
extern void _ZN10S1541C3_nt4v129Ev();
extern void _ZN10S1541C3_nt4v130Ev();
extern void _ZN10S1541C3_nt4v131Ev();
extern void _ZN10S1541C3_nt4v132Ev();
extern void _ZN10S1541C3_nt4v133Ev();
extern void _ZN10S1541C3_nt4v134Ev();
extern void _ZN10S1541C3_nt4v135Ev();
extern void _ZN10S1541C3_nt4v136Ev();
extern void _ZN10S1541C3_nt4v137Ev();
extern void _ZN10S1541C3_nt4v138Ev();
extern void _ZN10S1541C3_nt4v139Ev();
extern void _ZN10S1541C3_nt4v140Ev();
extern void _ZN10S1541C3_nt4v141Ev();
extern void _ZN10S1541C3_nt4v142Ev();
extern void _ZN10S1541C3_nt4v143Ev();
extern void _ZN10S1541C3_nt4v144Ev();
extern void _ZN10S1541C3_nt4v145Ev();
extern void _ZN10S1541C3_nt4v146Ev();
extern void _ZN10S1541C3_nt4v147Ev();
extern void _ZN10S1541C3_nt4v148Ev();
extern void _ZN10S1541C3_nt4v149Ev();
extern void _ZN10S1541C3_nt4v150Ev();
extern void _ZN10S1541C3_nt4v151Ev();
extern void _ZN10S1541C3_nt4v152Ev();
extern void _ZN10S1541C3_nt4v153Ev();
extern void _ZN10S1541C3_nt4v154Ev();
extern void _ZN10S1541C3_nt4v155Ev();
extern void _ZN10S1541C3_nt4v156Ev();
extern void _ZN10S1541C3_nt4v157Ev();
extern void _ZN10S1541C3_nt4v158Ev();
extern void _ZN10S1541C3_nt4v159Ev();
extern void _ZN10S1541C3_nt4v160Ev();
extern void _ZN10S1541C3_nt4v161Ev();
extern void _ZN10S1541C3_nt4v162Ev();
extern void _ZN10S1541C3_nt4v163Ev();
extern void _ZN10S1541C3_nt4v164Ev();
extern void _ZN10S1541C3_nt4v165Ev();
extern void _ZN10S1541C3_nt4v166Ev();
extern void _ZN10S1541C3_nt4v167Ev();
extern void _ZN10S1541C3_nt4v168Ev();
extern void _ZN10S1541C3_nt4v169Ev();
extern void _ZN10S1541C3_nt4v170Ev();
extern void _ZN10S1541C3_nt4v171Ev();
extern void _ZN10S1541C3_nt4v172Ev();
extern void _ZN10S1541C3_nt4v173Ev();
extern void _ZN10S1541C3_nt4v174Ev();
extern void _ZN10S1541C3_nt4v175Ev();
extern void _ZN10S1541C3_nt4v176Ev();
extern void _ZN10S1541C3_nt4v177Ev();
extern void _ZN10S1541C3_nt4v178Ev();
extern void _ZN10S1541C3_nt4v179Ev();
extern void _ZN10S1541C3_nt4v180Ev();
extern void _ZN10S1541C3_nt4v181Ev();
extern void _ZN10S1541C3_nt4v182Ev();
extern void _ZN10S1541C3_nt4v183Ev();
extern void _ZN10S1541C3_nt4v184Ev();
extern void _ZN10S1541C3_nt4v185Ev();
extern void _ZN10S1541C3_nt4v186Ev();
extern void _ZN10S1541C3_nt4v187Ev();
extern void _ZN10S1541C3_nt4v188Ev();
extern void _ZN10S1541C3_nt4v189Ev();
extern void _ZN10S1541C3_nt4v190Ev();
extern void _ZN10S1541C3_nt4v191Ev();
extern void _ZN10S1541C3_nt4v192Ev();
extern void _ZN10S1541C3_nt4v193Ev();
extern void _ZN10S1541C3_nt4v194Ev();
extern void _ZN10S1541C3_nt4v195Ev();
extern void _ZN10S1541C3_nt4v196Ev();
extern void _ZN10S1541C3_nt4v197Ev();
extern void _ZN10S1541C3_nt4v198Ev();
extern void _ZN10S1541C3_nt4v199Ev();
extern void _ZN10S1541C3_nt4v200Ev();
extern void _ZN10S1541C3_nt4v201Ev();
extern void _ZN10S1541C3_nt4v202Ev();
extern void _ZN10S1541C3_nt4v203Ev();
extern void _ZN10S1541C3_nt4v204Ev();
extern void _ZN10S1541C3_nt4v205Ev();
extern void _ZN10S1541C3_nt4v206Ev();
extern void _ZN10S1541C3_nt4v207Ev();
extern void _ZN10S1541C3_nt4v208Ev();
extern void _ZN10S1541C3_nt4v209Ev();
extern void _ZN10S1541C3_nt4v210Ev();
extern void _ZN10S1541C3_nt4v211Ev();
extern void _ZN10S1541C3_nt4v212Ev();
extern void _ZN10S1541C3_nt4v213Ev();
extern void _ZN7S1541C24v214Ev();
extern void _ZN7S1541C24v215Ev();
extern void _ZN7S1541C24v216Ev();
extern void _ZN7S1541C24v217Ev();
extern void _ZN7S1541C24v218Ev();
extern void _ZN7S1541C12v1Ev();
extern void _ZN7S1541C12v2Ev();
extern void _ZN7S1541C12v3Ev();
extern void _ZN7S1541C12v4Ev();
extern void _ZN7S1541C12v5Ev();
extern void _ZN7S1541C12v6Ev();
static  VTBL_ENTRY vtc_S1541C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1541C1[0]),
  (VTBL_ENTRY)&_ZN7S1541C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1541C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1541C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1541C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v214Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v215Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v216Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v217Ev,
  (VTBL_ENTRY)&_ZN7S1541C24v218Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1541C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1541C1[];
extern  VTBL_ENTRY _ZTV7S1541C1[];
Class_Descriptor cd_S1541C1 = {  "S1541C1", // class name
  bases_S1541C1, 3,
  &(vtc_S1541C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1088,872), // object size
  NSPAIRA(_ZTI7S1541C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1541C1),222, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C4  {
  int s21070c4f0;
  short s21070c4f1;
  void *s21070c4f2[2];
  long double s21070c4f3[8];
  void *s21070c4f4;
  short s21070c4f5;
  long s21070c4f6;
  char s21070c4f7;
  int s21070c4f8[2];
  virtual void  v3(); // _ZN8S21070C42v3Ev
  virtual void  v4(); // _ZN8S21070C42v4Ev
  virtual void  v5(); // _ZN8S21070C42v5Ev
  ~S21070C4(); // tgen
  S21070C4(); // tgen
};
//SIG(-1 S21070C4) C1{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]}


void  S21070C4 ::v3(){vfunc_called(this, "_ZN8S21070C42v3Ev");}
void  S21070C4 ::v4(){vfunc_called(this, "_ZN8S21070C42v4Ev");}
void  S21070C4 ::v5(){vfunc_called(this, "_ZN8S21070C42v5Ev");}
S21070C4 ::~S21070C4(){ note_dtor("S21070C4", this);} // tgen
S21070C4 ::S21070C4(){ note_ctor("S21070C4", this);} // tgen

static void Test_S21070C4()
{
  extern Class_Descriptor cd_S21070C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,36)];
    init_test(&cd_S21070C4, buf);
    S21070C4 *dp, &lv = *(dp=new (buf) S21070C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,140), "sizeof(S21070C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C4)");
    check_field_offset(lv, s21070c4f0, ABISELECT(8,4), "S21070C4.s21070c4f0");
    check_field_offset(lv, s21070c4f1, ABISELECT(12,8), "S21070C4.s21070c4f1");
    check_field_offset(lv, s21070c4f2, ABISELECT(16,12), "S21070C4.s21070c4f2");
    check_field_offset(lv, s21070c4f3, ABISELECT(32,20), "S21070C4.s21070c4f3");
    check_field_offset(lv, s21070c4f4, ABISELECT(160,116), "S21070C4.s21070c4f4");
    check_field_offset(lv, s21070c4f5, ABISELECT(168,120), "S21070C4.s21070c4f5");
    check_field_offset(lv, s21070c4f6, ABISELECT(176,124), "S21070C4.s21070c4f6");
    check_field_offset(lv, s21070c4f7, ABISELECT(184,128), "S21070C4.s21070c4f7");
    check_field_offset(lv, s21070c4f8, ABISELECT(188,132), "S21070C4.s21070c4f8");
    test_class_info(&lv, &cd_S21070C4);
    dp->~S21070C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C4(Test_S21070C4, "S21070C4", ABISELECT(208,140));

#else // __cplusplus

extern void _ZN8S21070C4C1Ev();
extern void _ZN8S21070C4D1Ev();
Name_Map name_map_S21070C4[] = {
  NSPAIR(_ZN8S21070C4C1Ev),
  NSPAIR(_ZN8S21070C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21070C4[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY vtc_S21070C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C4[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
Class_Descriptor cd_S21070C4 = {  "S21070C4", // class name
  0,0,//no base classes
  &(vtc_S21070C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,140), // object size
  NSPAIRA(_ZTI8S21070C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21070C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C7  : virtual S21070C4 {
  int s21070c7f0;
  void *s21070c7f1[8];
  __tsi64 s21070c7f2;
  int s21070c7f3;
  long s21070c7f4;
  virtual void  v6(); // _ZN8S21070C72v6Ev
  ~S21070C7(); // tgen
  S21070C7(); // tgen
};
//SIG(-1 S21070C7) C1{ VBC2{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} v1 Fi Fp[8] FL Fi Fl}


void  S21070C7 ::v6(){vfunc_called(this, "_ZN8S21070C72v6Ev");}
S21070C7 ::~S21070C7(){ note_dtor("S21070C7", this);} // tgen
S21070C7 ::S21070C7(){ note_ctor("S21070C7", this);} // tgen

static void Test_S21070C7()
{
  extern Class_Descriptor cd_S21070C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(21,50)];
    init_test(&cd_S21070C7, buf);
    S21070C7 *dp, &lv = *(dp=new (buf) S21070C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,196), "sizeof(S21070C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C7)");
    check_base_class_offset(lv, (S21070C4*), ABISELECT(112,56), "S21070C7");
    check_field_offset(lv, s21070c7f0, ABISELECT(8,4), "S21070C7.s21070c7f0");
    check_field_offset(lv, s21070c7f1, ABISELECT(16,8), "S21070C7.s21070c7f1");
    check_field_offset(lv, s21070c7f2, ABISELECT(80,40), "S21070C7.s21070c7f2");
    check_field_offset(lv, s21070c7f3, ABISELECT(88,48), "S21070C7.s21070c7f3");
    check_field_offset(lv, s21070c7f4, ABISELECT(96,52), "S21070C7.s21070c7f4");
    test_class_info(&lv, &cd_S21070C7);
    dp->~S21070C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C7(Test_S21070C7, "S21070C7", ABISELECT(320,196));

#else // __cplusplus

extern void _ZN8S21070C7C1Ev();
extern void _ZN8S21070C7D1Ev();
Name_Map name_map_S21070C7[] = {
  NSPAIR(_ZN8S21070C7C1Ev),
  NSPAIR(_ZN8S21070C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
static Base_Class bases_S21070C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(112,56), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C7[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY vtc_S21070C7[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern VTBL_ENTRY _ZTV8S21070C7[];
static  VTT_ENTRY vtt_S21070C7[] = {
  {&(_ZTV8S21070C7[3]),  3,12},
  {&(_ZTV8S21070C7[9]),  9,12},
};
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
Class_Descriptor cd_S21070C7 = {  "S21070C7", // class name
  bases_S21070C7, 1,
  &(vtc_S21070C7[0]), // expected_vtbl_contents
  &(vtt_S21070C7[0]), // expected_vtt_contents
  ABISELECT(320,196), // object size
  NSPAIRA(_ZTI8S21070C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S21070C7),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C7),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S21070C9  {
  long double s21070c9f0;
  long double s21070c9f1;
  __tsi64 s21070c9f2[6];
  void *s21070c9f3;
  void *s21070c9f4;
  char s21070c9f5;
  long double s21070c9f6[5];
  long double s21070c9f7;
  void *s21070c9f8;
  void *s21070c9f9;
  short s21070c9f10;
  void  mf21070c9(); // _ZN8S21070C99mf21070c9Ev
};
//SIG(1 S21070C9) U1{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs}

#endif // __cplusplus
#ifdef __cplusplus

struct  S21070C10_nt  {
};
//SIG(-1 S21070C10_nt) C1{}



//skip512 S21070C10_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S21070C10_nt[];
VTBL_ENTRY *P__ZTI12S21070C10_nt = _ZTI12S21070C10_nt; 
Class_Descriptor cd_S21070C10_nt = {  "S21070C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S21070C10_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C8  : virtual S21070C4 , virtual S21070C7 {
  char s21070c8f0;
  ::S21070C9 s21070c8f1;
  int s21070c8f2;
  ::S21070C10_nt s21070c8f3;
  void *s21070c8f4;
  ::S21070C9 s21070c8f5;
  int s21070c8f6;
  int s21070c8f7[3];
  ~S21070C8(); // tgen
  S21070C8(); // tgen
};
//SIG(-1 S21070C8) C1{ VBC2{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC3{ VBC2 v4 Fi Fp[8] FL Fi Fl} Fc FU4{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC5{} Fp FU4 Fi Fi[3]}


S21070C8 ::~S21070C8(){ note_dtor("S21070C8", this);} // tgen
S21070C8 ::S21070C8(){ note_ctor("S21070C8", this);} // tgen

static void Test_S21070C8()
{
  extern Class_Descriptor cd_S21070C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33,89)];
    init_test(&cd_S21070C8, buf);
    S21070C8 *dp, &lv = *(dp=new (buf) S21070C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,352), "sizeof(S21070C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C8)");
    check_base_class_offset(lv, (S21070C4*), ABISELECT(208,156), "S21070C8");
    check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(208,156), "S21070C8");
    check_base_class_offset(lv, (S21070C7*), ABISELECT(408,296), "S21070C8");
    check_field_offset(lv, s21070c8f0, ABISELECT(8,4), "S21070C8.s21070c8f0");
    check_field_offset(lv, s21070c8f1, ABISELECT(16,8), "S21070C8.s21070c8f1");
    check_field_offset(lv, s21070c8f2, ABISELECT(96,68), "S21070C8.s21070c8f2");
    check_field_offset(lv, s21070c8f3, ABISELECT(100,72), "S21070C8.s21070c8f3");
    check_field_offset(lv, s21070c8f4, ABISELECT(104,76), "S21070C8.s21070c8f4");
    check_field_offset(lv, s21070c8f5, ABISELECT(112,80), "S21070C8.s21070c8f5");
    check_field_offset(lv, s21070c8f6, ABISELECT(192,140), "S21070C8.s21070c8f6");
    check_field_offset(lv, s21070c8f7, ABISELECT(196,144), "S21070C8.s21070c8f7");
    test_class_info(&lv, &cd_S21070C8);
    dp->~S21070C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C8(Test_S21070C8, "S21070C8", ABISELECT(512,352));

#else // __cplusplus

extern void _ZN8S21070C8C1Ev();
extern void _ZN8S21070C8D1Ev();
Name_Map name_map_S21070C8[] = {
  NSPAIR(_ZN8S21070C8C1Ev),
  NSPAIR(_ZN8S21070C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
static Base_Class bases_S21070C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(208,156), //bcp->offset
    4, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    ABISELECT(408,296), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C8[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C8[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  0,
  0,
  0,
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  0,
  ABISELECT(-200,-140),
  ABISELECT(-408,-296),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV8S21070C8[];
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__8S21070C8[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C8[] = {
  {&(_ZTV8S21070C8[4]),  4,17},
  {&(_ZTV8S21070C8[9]),  9,17},
  {&(_ZTV8S21070C8[16]),  16,17},
  {&(_tg__ZTV8S21070C7__8S21070C8[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__8S21070C8[5]),  5,8},
};
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
Class_Descriptor cd_S21070C8 = {  "S21070C8", // class name
  bases_S21070C8, 2,
  &(vtc_S21070C8[0]), // expected_vtbl_contents
  &(vtt_S21070C8[0]), // expected_vtt_contents
  ABISELECT(512,352), // object size
  NSPAIRA(_ZTI8S21070C8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S21070C8),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C8),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C6  : virtual S21070C4 , S21070C7 , virtual S21070C8 {
  __tsi64 s21070c6f0;
  int s21070c6f1;
  long double s21070c6f2;
  virtual  ~S21070C6(); // _ZN8S21070C6D2Ev
  S21070C6(); // tgen
};
//SIG(-1 S21070C6) C1{ VBC2{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC3{ VBC2 v4 Fi Fp[8] FL Fi Fl} VBC4{ VBC2 VBC3 Fc FU5{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC6{} Fp FU5 Fi Fi[3]} vd FL Fi FD}


 S21070C6 ::~S21070C6(){ note_dtor("S21070C6", this);}
S21070C6 ::S21070C6(){ note_ctor("S21070C6", this);} // tgen

static void Test_S21070C6()
{
  extern Class_Descriptor cd_S21070C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(43,109)];
    init_test(&cd_S21070C6, buf);
    S21070C6 *dp, &lv = *(dp=new (buf) S21070C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(672,432), "sizeof(S21070C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C6)");
    check_base_class_offset(lv, (S21070C4*), ABISELECT(144,80), "S21070C6");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(144,80), "S21070C6");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(144,80), "S21070C6");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(144,80), "S21070C6");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), 0, "S21070C6");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(560,376), "S21070C6");
    check_base_class_offset(lv, (S21070C8*), ABISELECT(352,220), "S21070C6");
    check_field_offset(lv, s21070c6f0, ABISELECT(104,56), "S21070C6.s21070c6f0");
    check_field_offset(lv, s21070c6f1, ABISELECT(112,64), "S21070C6.s21070c6f1");
    check_field_offset(lv, s21070c6f2, ABISELECT(128,68), "S21070C6.s21070c6f2");
    test_class_info(&lv, &cd_S21070C6);
    dp->~S21070C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C6(Test_S21070C6, "S21070C6", ABISELECT(672,432));

#else // __cplusplus

extern void _ZN8S21070C6C1Ev();
extern void _ZN8S21070C6D2Ev();
Name_Map name_map_S21070C6[] = {
  NSPAIR(_ZN8S21070C6C1Ev),
  NSPAIR(_ZN8S21070C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
static Base_Class bases_S21070C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(144,80), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(560,376), //bcp->offset
    20, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(352,220), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C6[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C6[] = {
  ABISELECT(560,376),
  ABISELECT(352,220),
  ABISELECT(144,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
  0,
  0,
  0,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV8S21070C6[];
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C6[] = {
  ABISELECT(144,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A__8S21070C6[] = {
  0,
  0,
  0,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C6[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__8S21070C6[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__8S21070C6[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C6[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__8S21070C6[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C6[] = {
  {&(_ZTV8S21070C6[5]),  5,25},
  {&(_tg__ZTV8S21070C7__A__8S21070C6[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A__8S21070C6[5]),  5,8},
  {&(_ZTV8S21070C6[13]),  13,25},
  {&(_ZTV8S21070C6[20]),  20,25},
  {&(_ZTV8S21070C6[24]),  24,25},
  {&(_tg__ZTV8S21070C8__8S21070C6[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__8S21070C6[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__8S21070C6[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__8S21070C6[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__8S21070C6[5]),  5,8},
};
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
Class_Descriptor cd_S21070C6 = {  "S21070C6", // class name
  bases_S21070C6, 4,
  &(vtc_S21070C6[0]), // expected_vtbl_contents
  &(vtt_S21070C6[0]), // expected_vtt_contents
  ABISELECT(672,432), // object size
  NSPAIRA(_ZTI8S21070C6),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S21070C6),25, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C6),11, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C11  : virtual S21070C4 , virtual S21070C8 , S21070C7 , S21070C6 {
  int s21070c11f0;
  void *s21070c11f1;
  ::S21070C7 s21070c11f2;
  int s21070c11f3[2];
  void *s21070c11f4[3];
  char s21070c11f5;
  __tsi64 s21070c11f6;
  void *s21070c11f7[9];
  ::S21070C4 s21070c11f8;
  virtual void  v7(); // _ZN9S21070C112v7Ev
  ~S21070C11(); // tgen
  S21070C11(); // tgen
};
//SIG(-1 S21070C11) C1{ VBC2{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC3{ VBC2 VBC4{ VBC2 v5 Fi Fp[8] FL Fi Fl} Fc FU5{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC6{} Fp FU5 Fi Fi[3]} BC4 BC7{ VBC2 BC4 VBC3 vd FL Fi FD} v1 Fi Fp FC4 Fi[2] Fp[3] Fc FL Fp[9] FC2}


void  S21070C11 ::v7(){vfunc_called(this, "_ZN9S21070C112v7Ev");}
S21070C11 ::~S21070C11(){ note_dtor("S21070C11", this);} // tgen
S21070C11 ::S21070C11(){ note_ctor("S21070C11", this);} // tgen

static void Test_S21070C11()
{
  extern Class_Descriptor cd_S21070C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(92,226)];
    init_test(&cd_S21070C11, buf);
    S21070C11 *dp, &lv = *(dp=new (buf) S21070C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1456,900), "sizeof(S21070C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C11)");
    check_base_class_offset(lv, (S21070C4*), ABISELECT(928,548), "S21070C11");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(928,548), "S21070C11");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(928,548), "S21070C11");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(928,548), "S21070C11");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*), ABISELECT(928,548), "S21070C11");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*), ABISELECT(928,548), "S21070C11");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(1344,844), "S21070C11");
    check_base_class_offset(lv, (S21070C8*), ABISELECT(1136,688), "S21070C11");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*), ABISELECT(1136,688), "S21070C11");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), 0, "S21070C11");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*), ABISELECT(112,56), "S21070C11");
    check_base_class_offset(lv, (S21070C6*), ABISELECT(112,56), "S21070C11");
    check_field_offset(lv, s21070c11f0, ABISELECT(256,136), "S21070C11.s21070c11f0");
    check_field_offset(lv, s21070c11f1, ABISELECT(264,140), "S21070C11.s21070c11f1");
    check_field_offset(lv, s21070c11f2, ABISELECT(272,144), "S21070C11.s21070c11f2");
    check_field_offset(lv, s21070c11f3, ABISELECT(592,340), "S21070C11.s21070c11f3");
    check_field_offset(lv, s21070c11f4, ABISELECT(600,348), "S21070C11.s21070c11f4");
    check_field_offset(lv, s21070c11f5, ABISELECT(624,360), "S21070C11.s21070c11f5");
    check_field_offset(lv, s21070c11f6, ABISELECT(632,364), "S21070C11.s21070c11f6");
    check_field_offset(lv, s21070c11f7, ABISELECT(640,372), "S21070C11.s21070c11f7");
    check_field_offset(lv, s21070c11f8, ABISELECT(720,408), "S21070C11.s21070c11f8");
    test_class_info(&lv, &cd_S21070C11);
    dp->~S21070C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C11(Test_S21070C11, "S21070C11", ABISELECT(1456,900));

#else // __cplusplus

extern void _ZN9S21070C11C1Ev();
extern void _ZN9S21070C11D1Ev();
Name_Map name_map_S21070C11[] = {
  NSPAIR(_ZN9S21070C11C1Ev),
  NSPAIR(_ZN9S21070C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
static Base_Class bases_S21070C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(928,548), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    ABISELECT(1344,844), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(1136,688), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(112,56), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C11[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C11[] = {
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1136,-688),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1344,-844),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV9S21070C11[];
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__9S21070C11[] = {
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A__9S21070C11[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C6__A2__9S21070C11[] = {
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C6__A2__9S21070C11[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C6__9S21070C11[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C6__9S21070C11[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1024,-632),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C6__9S21070C11[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1232,-788),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C11[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C11[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C11[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C11[] = {
  {&(_ZTV9S21070C11[5]),  5,34},
  {&(_tg__ZTV8S21070C7__A__9S21070C11[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A__9S21070C11[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C11[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C6__A2__9S21070C11[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C6__A2__9S21070C11[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C6__9S21070C11[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C6__9S21070C11[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C6__9S21070C11[4]),  4,5},
  {&(_ZTV9S21070C11[22]),  22,34},
  {&(_ZTV9S21070C11[29]),  29,34},
  {&(_ZTV9S21070C11[33]),  33,34},
  {&(_ZTV9S21070C11[14]),  14,34},
  {&(_tg__ZTV8S21070C8__9S21070C11[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C11[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C11[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C11[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C11[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
Class_Descriptor cd_S21070C11 = {  "S21070C11", // class name
  bases_S21070C11, 6,
  &(vtc_S21070C11[0]), // expected_vtbl_contents
  &(vtt_S21070C11[0]), // expected_vtt_contents
  ABISELECT(1456,900), // object size
  NSPAIRA(_ZTI9S21070C11),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21070C11),34, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C11),18, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C5  : S21070C6 , S21070C4 , S21070C8 , S21070C11 , S21070C7 {
  short s21070c5f0;
  ::S21070C10_nt s21070c5f1;
  int s21070c5f2;
  long double s21070c5f3;
  void *s21070c5f4[8];
  void *s21070c5f5[10];
  short s21070c5f6:3;
  void *s21070c5f7;
  virtual  ~S21070C5(); // _ZN8S21070C5D2Ev
  S21070C5(); // tgen
};
//SIG(-1 S21070C5) C1{ BC2{ VBC3{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC4{ VBC3 v4 Fi Fp[8] FL Fi Fl} VBC5{ VBC3 VBC4 Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} vd FL Fi FD} BC3 BC5 BC8{ VBC3 VBC5 BC4 BC2 v5 Fi Fp FC4 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC4 vd Fs FC7 Fi FD Fp[8] Fp[10] Fs:3 Fp}


 S21070C5 ::~S21070C5(){ note_dtor("S21070C5", this);}
S21070C5 ::S21070C5(){ note_ctor("S21070C5", this);} // tgen

static void Test_S21070C5()
{
  extern Class_Descriptor cd_S21070C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(145,359)];
    init_test(&cd_S21070C5, buf);
    S21070C5 *dp, &lv = *(dp=new (buf) S21070C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2304,1432), "sizeof(S21070C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C5)");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(1776,1080), "S21070C5");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(1776,1080), "S21070C5");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(1776,1080), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*), 0, "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(2192,1376), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(2192,1376), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*), ABISELECT(1984,1220), "S21070C5");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(1984,1220), "S21070C5");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(1984,1220), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*), 0, "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*), ABISELECT(144,80), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*), ABISELECT(352,220), "S21070C5");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(560,376), "S21070C5");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(672,432), "S21070C5");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(672,432), "S21070C5");
    check_base_class_offset(lv, (S21070C11*), ABISELECT(560,376), "S21070C5");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), ABISELECT(1488,924), "S21070C5");
    check_field_offset(lv, s21070c5f0, ABISELECT(1592,980), "S21070C5.s21070c5f0");
    check_field_offset(lv, s21070c5f1, ABISELECT(1594,982), "S21070C5.s21070c5f1");
    check_field_offset(lv, s21070c5f2, ABISELECT(1596,984), "S21070C5.s21070c5f2");
    check_field_offset(lv, s21070c5f3, ABISELECT(1600,988), "S21070C5.s21070c5f3");
    check_field_offset(lv, s21070c5f4, ABISELECT(1616,1000), "S21070C5.s21070c5f4");
    check_field_offset(lv, s21070c5f5, ABISELECT(1680,1032), "S21070C5.s21070c5f5");
    set_bf_and_test(lv, s21070c5f6, ABISELECT(1760,1072), 0, 3, 1, "S21070C5");
    set_bf_and_test(lv, s21070c5f6, ABISELECT(1760,1072), 0, 3, hide_sll(1LL<<2), "S21070C5");
    check_field_offset(lv, s21070c5f7, ABISELECT(1768,1076), "S21070C5.s21070c5f7");
    test_class_info(&lv, &cd_S21070C5);
    dp->~S21070C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C5(Test_S21070C5, "S21070C5", ABISELECT(2304,1432));

#else // __cplusplus

extern void _ZN8S21070C5C1Ev();
extern void _ZN8S21070C5D2Ev();
Name_Map name_map_S21070C5[] = {
  NSPAIR(_ZN8S21070C5C1Ev),
  NSPAIR(_ZN8S21070C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
static Base_Class bases_S21070C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(1776,1080), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2192,1376), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(1984,1220), //bcp->offset
    46, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C4,    ABISELECT(144,80), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C8,    ABISELECT(352,220), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(560,376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(672,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(672,432), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(560,376), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(1488,924), //bcp->offset
    34, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C5[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C5[] = {
  ABISELECT(2192,1376),
  ABISELECT(1984,1220),
  ABISELECT(1776,1080),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(1840,1156),
  ABISELECT(1424,860),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  ABISELECT(1632,1000),
  ABISELECT(1424,844),
  ABISELECT(1216,704),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
  ABISELECT(1520,944),
  ABISELECT(1312,788),
  ABISELECT(1104,648),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
  ABISELECT(288,156),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-1776,-1080),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1984,-1220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2192,-1376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV8S21070C5[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C6__8S21070C5[] = {
  ABISELECT(2192,1376),
  ABISELECT(1984,1220),
  ABISELECT(1776,1080),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C6__8S21070C5[] = {
  ABISELECT(1776,1080),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C6__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1776,-1080),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C6__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1776,-1080),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C6__8S21070C5[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1984,-1220),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C6__8S21070C5[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2192,-1376),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C5[] = {
  ABISELECT(1840,1156),
  ABISELECT(1424,860),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__A__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1424,-860),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__A__8S21070C5[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1840,-1156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C5[] = {
  ABISELECT(1632,1000),
  ABISELECT(1424,844),
  ABISELECT(1216,704),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A2__8S21070C5[] = {
  ABISELECT(1216,704),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A2__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1216,-704),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C5[] = {
  ABISELECT(1520,944),
  ABISELECT(1312,788),
  ABISELECT(1104,648),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A3__8S21070C5[] = {
  ABISELECT(1104,648),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A3__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1104,-648),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__A1__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1104,-648),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__A1__8S21070C5[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1312,-788),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A1__8S21070C5[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1520,-944),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-1216,-704),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__8S21070C5[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1424,-844),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__8S21070C5[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1632,-1000),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__8S21070C5[] = {
  ABISELECT(1520,944),
  ABISELECT(1312,788),
  ABISELECT(1104,648),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C5[] = {
  ABISELECT(288,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(-288,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C5[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__8S21070C5[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C5[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__8S21070C5[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C5[] = {
  {&(_ZTV8S21070C5[5]),  5,55},
  {&(_tg__ZTV8S21070C6__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C6__8S21070C5[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C6__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C6__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C6__8S21070C5[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C6__8S21070C5[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C5[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__A__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__A__8S21070C5[4]),  4,5},
  {&(_tg__ZTV9S21070C11__8S21070C5[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A2__8S21070C5[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A2__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A3__8S21070C5[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A3__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__A1__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__A1__8S21070C5[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A1__8S21070C5[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__8S21070C5[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__8S21070C5[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C5[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A__8S21070C5[5]),  5,8},
  {&(_ZTV8S21070C5[43]),  43,55},
  {&(_ZTV8S21070C5[50]),  50,55},
  {&(_ZTV8S21070C5[54]),  54,55},
  {&(_ZTV8S21070C5[17]),  17,55},
  {&(_ZTV8S21070C5[22]),  22,55},
  {&(_ZTV8S21070C5[31]),  31,55},
  {&(_ZTV8S21070C5[37]),  37,55},
  {&(_tg__ZTV8S21070C8__8S21070C5[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__8S21070C5[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__8S21070C5[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__8S21070C5[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__8S21070C5[5]),  5,8},
};
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
Class_Descriptor cd_S21070C5 = {  "S21070C5", // class name
  bases_S21070C5, 12,
  &(vtc_S21070C5[0]), // expected_vtbl_contents
  &(vtt_S21070C5[0]), // expected_vtt_contents
  ABISELECT(2304,1432), // object size
  NSPAIRA(_ZTI8S21070C5),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S21070C5),55, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C5),37, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C13  {
  ::S21070C9 s21070c13f0;
  void  mf21070c13(); // _ZN9S21070C1310mf21070c13Ev
};
//SIG(-1 S21070C13) C1{ m FU2{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs}}


void  S21070C13 ::mf21070c13(){}

static void Test_S21070C13()
{
  {
    init_simple_test("S21070C13");
    S21070C13 lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S21070C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C13)");
    check_field_offset(lv, s21070c13f0, 0, "S21070C13.s21070c13f0");
  }
}
static Arrange_To_Call_Me vS21070C13(Test_S21070C13, "S21070C13", ABISELECT(80,60));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S21070C13[];
VTBL_ENTRY *P__ZTI9S21070C13 = _ZTI9S21070C13; 
Class_Descriptor cd_S21070C13 = {  "S21070C13", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI9S21070C13),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C14  : virtual S21070C4 , S21070C7 , virtual S21070C8 , S21070C6 {
  void *s21070c14f0;
  void *s21070c14f1;
  __tsi64 s21070c14f2;
  char s21070c14f3;
  void *s21070c14f4;
  void *s21070c14f5;
  __tsi64 s21070c14f6[3];
  void *s21070c14f7;
  char s21070c14f8;
  char s21070c14f9;
  ::S21070C7 s21070c14f10;
  int s21070c14f11;
  virtual  ~S21070C14(); // _ZN9S21070C14D2Ev
  virtual void  v8(); // _ZN9S21070C142v8Ev
  S21070C14(); // tgen
};
//SIG(-1 S21070C14) C1{ VBC2{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC3{ VBC2 v5 Fi Fp[8] FL Fi Fl} VBC4{ VBC2 VBC3 Fc FU5{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC6{} Fp FU5 Fi Fi[3]} BC7{ VBC2 BC3 VBC4 vd FL Fi FD} vd v1 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC3 Fi}


 S21070C14 ::~S21070C14(){ note_dtor("S21070C14", this);}
void  S21070C14 ::v8(){vfunc_called(this, "_ZN9S21070C142v8Ev");}
S21070C14 ::S21070C14(){ note_ctor("S21070C14", this);} // tgen

static void Test_S21070C14()
{
  extern Class_Descriptor cd_S21070C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(77,188)];
    init_test(&cd_S21070C14, buf);
    S21070C14 *dp, &lv = *(dp=new (buf) S21070C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1216,748), "sizeof(S21070C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C14)");
    check_base_class_offset(lv, (S21070C4*), ABISELECT(688,396), "S21070C14");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(688,396), "S21070C14");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(688,396), "S21070C14");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(688,396), "S21070C14");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*), ABISELECT(688,396), "S21070C14");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*), ABISELECT(688,396), "S21070C14");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), 0, "S21070C14");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(1104,692), "S21070C14");
    check_base_class_offset(lv, (S21070C8*), ABISELECT(896,536), "S21070C14");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*), ABISELECT(896,536), "S21070C14");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*), ABISELECT(112,56), "S21070C14");
    check_base_class_offset(lv, (S21070C6*), ABISELECT(112,56), "S21070C14");
    check_field_offset(lv, s21070c14f0, ABISELECT(256,136), "S21070C14.s21070c14f0");
    check_field_offset(lv, s21070c14f1, ABISELECT(264,140), "S21070C14.s21070c14f1");
    check_field_offset(lv, s21070c14f2, ABISELECT(272,144), "S21070C14.s21070c14f2");
    check_field_offset(lv, s21070c14f3, ABISELECT(280,152), "S21070C14.s21070c14f3");
    check_field_offset(lv, s21070c14f4, ABISELECT(288,156), "S21070C14.s21070c14f4");
    check_field_offset(lv, s21070c14f5, ABISELECT(296,160), "S21070C14.s21070c14f5");
    check_field_offset(lv, s21070c14f6, ABISELECT(304,164), "S21070C14.s21070c14f6");
    check_field_offset(lv, s21070c14f7, ABISELECT(328,188), "S21070C14.s21070c14f7");
    check_field_offset(lv, s21070c14f8, ABISELECT(336,192), "S21070C14.s21070c14f8");
    check_field_offset(lv, s21070c14f9, ABISELECT(337,193), "S21070C14.s21070c14f9");
    check_field_offset(lv, s21070c14f10, ABISELECT(352,196), "S21070C14.s21070c14f10");
    check_field_offset(lv, s21070c14f11, ABISELECT(672,392), "S21070C14.s21070c14f11");
    test_class_info(&lv, &cd_S21070C14);
    dp->~S21070C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C14(Test_S21070C14, "S21070C14", ABISELECT(1216,748));

#else // __cplusplus

extern void _ZN9S21070C14C1Ev();
extern void _ZN9S21070C14D2Ev();
Name_Map name_map_S21070C14[] = {
  NSPAIR(_ZN9S21070C14C1Ev),
  NSPAIR(_ZN9S21070C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
static Base_Class bases_S21070C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(688,396), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(1104,692), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(896,536), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    ABISELECT(112,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(112,56), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C14[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C14[] = {
  ABISELECT(1104,692),
  ABISELECT(896,536),
  ABISELECT(688,396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(992,636),
  ABISELECT(784,480),
  ABISELECT(576,340),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
  0,
  0,
  0,
  ABISELECT(-688,-396),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-896,-536),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1104,-692),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV9S21070C14[];
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__9S21070C14[] = {
  ABISELECT(688,396),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A__9S21070C14[] = {
  0,
  0,
  0,
  ABISELECT(-688,-396),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14[] = {
  ABISELECT(992,636),
  ABISELECT(784,480),
  ABISELECT(576,340),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C6__A2__9S21070C14[] = {
  ABISELECT(576,340),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C6__A2__9S21070C14[] = {
  0,
  0,
  0,
  ABISELECT(-576,-340),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C6__9S21070C14[] = {
  0,
  0,
  0,
  ABISELECT(-576,-340),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C6__9S21070C14[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-784,-480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C6__9S21070C14[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-992,-636),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C14[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C14[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__9S21070C14[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C14[] = {
  {&(_ZTV9S21070C14[5]),  5,34},
  {&(_tg__ZTV8S21070C7__A__9S21070C14[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A__9S21070C14[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C14[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C6__A2__9S21070C14[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C6__A2__9S21070C14[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C6__9S21070C14[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C6__9S21070C14[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C6__9S21070C14[4]),  4,5},
  {&(_ZTV9S21070C14[22]),  22,34},
  {&(_ZTV9S21070C14[29]),  29,34},
  {&(_ZTV9S21070C14[33]),  33,34},
  {&(_ZTV9S21070C14[14]),  14,34},
  {&(_tg__ZTV8S21070C8__9S21070C14[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C14[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C14[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__9S21070C14[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
Class_Descriptor cd_S21070C14 = {  "S21070C14", // class name
  bases_S21070C14, 6,
  &(vtc_S21070C14[0]), // expected_vtbl_contents
  &(vtt_S21070C14[0]), // expected_vtt_contents
  ABISELECT(1216,748), // object size
  NSPAIRA(_ZTI9S21070C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21070C14),34, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C14),18, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C15  : virtual S21070C11 {
  int s21070c15f0:6;
  ~S21070C15(); // tgen
  S21070C15(); // tgen
};
//SIG(-1 S21070C15) C1{ VBC2{ VBC3{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC4{ VBC3 VBC5{ VBC3 v4 Fi Fp[8] FL Fi Fl} Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} BC5 BC8{ VBC3 BC5 VBC4 vd FL Fi FD} v5 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC3} Fi:6}


S21070C15 ::~S21070C15(){ note_dtor("S21070C15", this);} // tgen
S21070C15 ::S21070C15(){ note_ctor("S21070C15", this);} // tgen

static void Test_S21070C15()
{
  extern Class_Descriptor cd_S21070C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(93,228)];
    init_test(&cd_S21070C15, buf);
    S21070C15 *dp, &lv = *(dp=new (buf) S21070C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1472,908), "sizeof(S21070C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C15)");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(944,556), "S21070C15");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(944,556), "S21070C15");
    /*is_ambiguous_... S21070C15::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(944,556), "S21070C15");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(944,556), "S21070C15");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(944,556), "S21070C15");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(944,556), "S21070C15");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(1360,852), "S21070C15");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(1152,696), "S21070C15");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(1152,696), "S21070C15");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(16,8), "S21070C15");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(128,64), "S21070C15");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(128,64), "S21070C15");
    check_base_class_offset(lv, (S21070C11*), ABISELECT(16,8), "S21070C15");
    set_bf_and_test(lv, s21070c15f0, ABISELECT(8,4), 0, 6, 1, "S21070C15");
    set_bf_and_test(lv, s21070c15f0, ABISELECT(8,4), 0, 6, hide_sll(1LL<<5), "S21070C15");
    test_class_info(&lv, &cd_S21070C15);
    dp->~S21070C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C15(Test_S21070C15, "S21070C15", ABISELECT(1472,908));

#else // __cplusplus

extern void _ZN9S21070C15C1Ev();
extern void _ZN9S21070C15D1Ev();
Name_Map name_map_S21070C15[] = {
  NSPAIR(_ZN9S21070C15C1Ev),
  NSPAIR(_ZN9S21070C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
static Base_Class bases_S21070C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(944,556), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(1360,852), //bcp->offset
    40, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(1152,696), //bcp->offset
    36, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(128,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(128,64), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(16,8), //bcp->offset
    8, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C15[];
extern void _ZN9S21070C15D1Ev();
extern void _ZN9S21070C15D0Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZThn16_N9S21070C15D1Ev,_ZThn8_N9S21070C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev)();
extern void ABISELECT(_ZThn16_N9S21070C15D0Ev,_ZThn8_N9S21070C15D0Ev)() __attribute__((weak));
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C15[] = {
  ABISELECT(1360,852),
  ABISELECT(1152,696),
  ABISELECT(944,556),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN9S21070C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C15D0Ev,
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev),
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-128,-64),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev),
  0,
  0,
  0,
  ABISELECT(-944,-556),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1152,-696),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1360,-852),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV9S21070C15[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C15[] = {
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A1__9S21070C15[] = {
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C15[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C15[] = {
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C15[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1024,-632),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C15[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1232,-788),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__9S21070C15[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1136,-688),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__9S21070C15[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1344,-844),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__9S21070C15[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C15[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C15[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C15[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C15[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C15[] = {
  {&(_ZTV9S21070C15[6]),  6,45},
  {&(_ZTV9S21070C15[16]),  16,45},
  {&(_ZTV9S21070C15[33]),  33,45},
  {&(_ZTV9S21070C15[40]),  40,45},
  {&(_ZTV9S21070C15[44]),  44,45},
  {&(_ZTV9S21070C15[25]),  25,45},
  {&(_tg__ZTV9S21070C11__9S21070C15[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A1__9S21070C15[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C15[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C15[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C15[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__9S21070C15[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__9S21070C15[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C15[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C15[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C15[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C15[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C15[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C15[];
extern  VTBL_ENTRY _ZTV9S21070C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C15[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S21070C15D0Ev,_ZThn8_N9S21070C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S21070C15D1Ev,_ZThn8_N9S21070C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C15 = {  "S21070C15", // class name
  bases_S21070C15, 7,
  &(vtc_S21070C15[0]), // expected_vtbl_contents
  &(vtt_S21070C15[0]), // expected_vtt_contents
  ABISELECT(1472,908), // object size
  NSPAIRA(_ZTI9S21070C15),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S21070C15),45, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C15),24, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C12  : virtual S21070C11 , S21070C5 , S21070C13 , virtual S21070C14 , S21070C15 {
  __tsi64 s21070c12f0:49;
  ::S21070C4 s21070c12f1;
  __tsi64 s21070c12f2;
  short s21070c12f3;
  void *s21070c12f4;
  int s21070c12f5;
  void *s21070c12f6[10];
  short s21070c12f7;
  void *s21070c12f8;
  ::S21070C6 s21070c12f9;
  void *s21070c12f10;
  __tsi64 s21070c12f11:5;
  virtual void  v9(); // _ZN9S21070C122v9Ev
  ~S21070C12(); // tgen
  S21070C12(); // tgen
};
//SIG(-1 S21070C12) C1{ VBC2{ VBC3{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC4{ VBC3 VBC5{ VBC3 v5 Fi Fp[8] FL Fi Fl} Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} BC5 BC8{ VBC3 BC5 VBC4 vd FL Fi FD} v6 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC9{ BC8 BC3 BC4 BC2 BC5 vd Fs FC7 Fi FD Fp[8] Fp[10] Fs:3 Fp} BC10{ m FU6} VBC11{ VBC3 BC5 VBC4 BC8 vd v7 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} BC12{ VBC2 Fi:6} v1 FL:49 FC3 FL Fs Fp Fi Fp[10] Fs Fp FC8 Fp FL:5}


void  S21070C12 ::v9(){vfunc_called(this, "_ZN9S21070C122v9Ev");}
S21070C12 ::~S21070C12(){ note_dtor("S21070C12", this);} // tgen
S21070C12 ::S21070C12(){ note_ctor("S21070C12", this);} // tgen

static void Test_S21070C12()
{
  extern Class_Descriptor cd_S21070C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(316,775)];
    init_test(&cd_S21070C12, buf);
    S21070C12 *dp, &lv = *(dp=new (buf) S21070C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5040,3096), "sizeof(S21070C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C12)");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*), ABISELECT(3824,2348), "S21070C12");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(3824,2348), "S21070C12");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(3824,2348), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(4240,2644), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*), ABISELECT(4240,2644), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(4032,2488), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(4032,2488), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*), ABISELECT(4032,2488), "S21070C12");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*), ABISELECT(4032,2488), "S21070C12");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(4032,2488), "S21070C12");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(4032,2488), "S21070C12");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(4032,2488), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(2896,1800), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(3008,1856), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(3008,1856), "S21070C12");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C11*), ABISELECT(2896,1800), "S21070C12");
    check_base_class_offset(lv, (S21070C11*)(S21070C15*), ABISELECT(2896,1800), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*), 0, "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*), 0, "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*), ABISELECT(144,80), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*), ABISELECT(352,220), "S21070C12");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(560,376), "S21070C12");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(672,432), "S21070C12");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(672,432), "S21070C12");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*), ABISELECT(560,376), "S21070C12");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*), ABISELECT(1488,924), "S21070C12");
    check_base_class_offset(lv, (S21070C5*), 0, "S21070C12");
    check_base_class_offset(lv, (S21070C13*), ABISELECT(1776,1080), "S21070C12");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(4352,2700), "S21070C12");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(4464,2756), "S21070C12");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(4464,2756), "S21070C12");
    check_base_class_offset(lv, (S21070C14*), ABISELECT(4352,2700), "S21070C12");
    check_base_class_offset(lv, (S21070C15*), ABISELECT(1856,1140), "S21070C12");
    set_bf_and_test(lv, s21070c12f0, ABISELECT(1865,1145), 0, 49, 1, "S21070C12");
    set_bf_and_test(lv, s21070c12f0, ABISELECT(1865,1145), 0, 49, hide_sll(1LL<<48), "S21070C12");
    check_field_offset(lv, s21070c12f1, ABISELECT(1872,1152), "S21070C12.s21070c12f1");
    check_field_offset(lv, s21070c12f2, ABISELECT(2080,1292), "S21070C12.s21070c12f2");
    check_field_offset(lv, s21070c12f3, ABISELECT(2088,1300), "S21070C12.s21070c12f3");
    check_field_offset(lv, s21070c12f4, ABISELECT(2096,1304), "S21070C12.s21070c12f4");
    check_field_offset(lv, s21070c12f5, ABISELECT(2104,1308), "S21070C12.s21070c12f5");
    check_field_offset(lv, s21070c12f6, ABISELECT(2112,1312), "S21070C12.s21070c12f6");
    check_field_offset(lv, s21070c12f7, ABISELECT(2192,1352), "S21070C12.s21070c12f7");
    check_field_offset(lv, s21070c12f8, ABISELECT(2200,1356), "S21070C12.s21070c12f8");
    check_field_offset(lv, s21070c12f9, ABISELECT(2208,1360), "S21070C12.s21070c12f9");
    check_field_offset(lv, s21070c12f10, ABISELECT(2880,1792), "S21070C12.s21070c12f10");
    set_bf_and_test(lv, s21070c12f11, ABISELECT(2888,1796), 0, 5, 1, "S21070C12");
    set_bf_and_test(lv, s21070c12f11, ABISELECT(2888,1796), 0, 5, hide_sll(1LL<<4), "S21070C12");
    test_class_info(&lv, &cd_S21070C12);
    dp->~S21070C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C12(Test_S21070C12, "S21070C12", ABISELECT(5040,3096));

#else // __cplusplus

extern void _ZN9S21070C12C1Ev();
extern void _ZN9S21070C12D1Ev();
Name_Map name_map_S21070C12[] = {
  NSPAIR(_ZN9S21070C12C1Ev),
  NSPAIR(_ZN9S21070C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C13;
extern VTBL_ENTRY _ZTI9S21070C13[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C15;
extern VTBL_ENTRY _ZTI9S21070C15[];
extern  VTBL_ENTRY _ZTV9S21070C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C15[];
static Base_Class bases_S21070C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(3824,2348), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4240,2644), //bcp->offset
    81, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(4032,2488), //bcp->offset
    77, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(2896,1800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(3008,1856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(3008,1856), //bcp->offset
    61, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(2896,1800), //bcp->offset
    49, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(144,80), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(352,220), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(560,376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(672,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(672,432), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(560,376), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(1488,924), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C13,    ABISELECT(1776,1080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(4352,2700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(4464,2756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4464,2756), //bcp->offset
    98, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(4352,2700), //bcp->offset
    86, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C15,    ABISELECT(1856,1140), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C12[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C12D1Ev();
extern void _ZN9S21070C12D0Ev();
extern void _ZN9S21070C122v9Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev)() __attribute__((weak));
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn4352_N9S21070C12D1Ev,_ZThn2700_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn4352_N9S21070C12D0Ev,_ZThn2700_N9S21070C12D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev)();
static  VTBL_ENTRY vtc_S21070C12[] = {
  ABISELECT(4352,2700),
  ABISELECT(2896,1800),
  ABISELECT(4240,2644),
  ABISELECT(4032,2488),
  ABISELECT(3824,2348),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(3888,2424),
  ABISELECT(3472,2128),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  ABISELECT(3680,2268),
  ABISELECT(3472,2112),
  ABISELECT(3264,1972),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev),
  ABISELECT(3568,2212),
  ABISELECT(3360,2056),
  ABISELECT(3152,1916),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev),
  ABISELECT(2336,1424),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(2384,1504),
  ABISELECT(2176,1348),
  ABISELECT(1968,1208),
  ABISELECT(1040,660),
  ABISELECT(-1856,-1140),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev),
  ABISELECT(-2896,-1800),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-2896,-1800),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev),
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-3008,-1856),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev),
  0,
  0,
  0,
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-4032,-2488),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4240,-2644),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  ABISELECT(-4352,-2700),
  0,
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-4352,-2700),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  ABISELECT(-4464,-2756),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev),
};
extern VTBL_ENTRY _ZTV9S21070C12[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C5__9S21070C12[] = {
  ABISELECT(4240,2644),
  ABISELECT(4032,2488),
  ABISELECT(3824,2348),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C5__A1__9S21070C12[] = {
  ABISELECT(4240,2644),
  ABISELECT(4032,2488),
  ABISELECT(3824,2348),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C5__A3__9S21070C12[] = {
  ABISELECT(3824,2348),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A3__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C5__A1__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C5__A1__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-4032,-2488),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A1__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4240,-2644),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C12[] = {
  ABISELECT(3888,2424),
  ABISELECT(3472,2128),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C5__A1__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3472,-2128),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C5__A1__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3888,-2424),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__A1__9S21070C12[] = {
  ABISELECT(3680,2268),
  ABISELECT(3472,2112),
  ABISELECT(3264,1972),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C5__A4__9S21070C12[] = {
  ABISELECT(3264,1972),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A4__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3264,-1972),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12[] = {
  ABISELECT(3568,2212),
  ABISELECT(3360,2056),
  ABISELECT(3152,1916),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A5__9S21070C12[] = {
  ABISELECT(3152,1916),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A5__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3152,-1916),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A2__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3152,-1916),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A2__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3360,-2056),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A2__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3568,-2212),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C5__A1__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3264,-1972),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C5__A1__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3472,-2112),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C5__A1__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3680,-2268),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C5__A1__9S21070C12[] = {
  ABISELECT(3568,2212),
  ABISELECT(3360,2056),
  ABISELECT(3152,1916),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A6__9S21070C12[] = {
  ABISELECT(2336,1424),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C5__A6__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-2336,-1424),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C5__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C5__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-4032,-2488),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C5__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4240,-2644),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C5__9S21070C12[] = {
  ABISELECT(3888,2424),
  ABISELECT(3472,2128),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C5__9S21070C12[] = {
  ABISELECT(3680,2268),
  ABISELECT(3472,2112),
  ABISELECT(3264,1972),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C5__9S21070C12[] = {
  ABISELECT(3568,2212),
  ABISELECT(3360,2056),
  ABISELECT(3152,1916),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C5__9S21070C12[] = {
  ABISELECT(2336,1424),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN9S21070C15D1Ev();
extern void _ZN9S21070C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C15__9S21070C12[] = {
  ABISELECT(2384,1504),
  ABISELECT(2176,1348),
  ABISELECT(1968,1208),
  ABISELECT(1040,660),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN9S21070C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C15D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C15__9S21070C12[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C15__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-1968,-1208),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C15__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2176,-1348),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C15__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2384,-1504),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C15__9S21070C12[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-1152,-716),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C12[] = {
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A1__9S21070C12[] = {
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C12[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C12[] = {
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1024,-632),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1232,-788),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1136,-688),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1344,-844),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__9S21070C12[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C12[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C12[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C14__A7__9S21070C12[] = {
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C14__A7__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A3__9S21070C12[] = {
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C14__A8__9S21070C12[] = {
  ABISELECT(-640,-408),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A8__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(640,408),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C14__A3__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(640,408),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C14__A3__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(432,268),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A3__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(224,112),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C14__9S21070C12[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14__9S21070C12[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14__9S21070C12[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14__9S21070C12[] = {
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
};
static  VTT_ENTRY vtt_S21070C12[] = {
  {&(_ZTV9S21070C12[7]),  7,106},
  {&(_tg__ZTV8S21070C5__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C5__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C5__A3__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A3__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C5__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C5__A1__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A1__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C5__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C5__A1__9S21070C12[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C5__A1__9S21070C12[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C5__A4__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A4__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A5__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A5__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A2__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A2__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A2__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C5__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C5__A1__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C5__A1__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C5__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A6__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C5__A6__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C5__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C5__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C5__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C5__9S21070C12[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C5__9S21070C12[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C5__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C5__9S21070C12[3]),  3,4},
  {&(_tg__ZTV9S21070C15__9S21070C12[6]),  6,8},
  {&(_tg__ZTV9S21070C11__9S21070C15__9S21070C12[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C15__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C15__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C15__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C15__9S21070C12[5]),  5,8},
  {&(_ZTV9S21070C12[57]),  57,106},
  {&(_ZTV9S21070C12[74]),  74,106},
  {&(_ZTV9S21070C12[81]),  81,106},
  {&(_ZTV9S21070C12[85]),  85,106},
  {&(_ZTV9S21070C12[66]),  66,106},
  {&(_ZTV9S21070C12[20]),  20,106},
  {&(_ZTV9S21070C12[25]),  25,106},
  {&(_ZTV9S21070C12[34]),  34,106},
  {&(_ZTV9S21070C12[40]),  40,106},
  {&(_ZTV9S21070C12[94]),  94,106},
  {&(_ZTV9S21070C12[103]),  103,106},
  {&(_ZTV9S21070C12[47]),  47,106},
  {&(_tg__ZTV9S21070C11__9S21070C12[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A1__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C12[5]),  5,8},
  {&(_tg__ZTV9S21070C14__9S21070C12[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C14__A7__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C14__A7__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C14__A3__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C14__A8__9S21070C12[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A8__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C14__A3__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C14__A3__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A3__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C14__9S21070C12[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C14__9S21070C12[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14__9S21070C12[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C14__9S21070C12[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C12[];
extern  VTBL_ENTRY _ZTV9S21070C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C12[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4352_N9S21070C12D0Ev,_ZThn2700_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4352_N9S21070C12D1Ev,_ZThn2700_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C12 = {  "S21070C12", // class name
  bases_S21070C12, 23,
  &(vtc_S21070C12[0]), // expected_vtbl_contents
  &(vtt_S21070C12[0]), // expected_vtt_contents
  ABISELECT(5040,3096), // object size
  NSPAIRA(_ZTI9S21070C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S21070C12),106, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C12),82, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C3  : virtual S21070C4 , S21070C5 , virtual S21070C12 {
  long double s21070c3f0;
  void *s21070c3f1;
  __tsi64 s21070c3f2;
  int s21070c3f3;
  __tsi64 s21070c3f4;
  virtual  ~S21070C3(); // _ZN8S21070C3D2Ev
  S21070C3(); // tgen
};
//SIG(-1 S21070C3) C1{ VBC2{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC3{ BC4{ VBC2 BC5{ VBC2 v4 Fi Fp[8] FL Fi Fl} VBC6{ VBC2 VBC5 Fc FU7{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC8{} Fp FU7 Fi Fi[3]} vd FL Fi FD} BC2 BC6 BC9{ VBC2 VBC6 BC5 BC4 v5 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC2} BC5 vd Fs FC8 Fi FD Fp[8] Fp[10] Fs:3 Fp} VBC10{ VBC9 BC3 BC11{ m FU7} VBC12{ VBC2 BC5 VBC6 BC4 vd v6 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} BC13{ VBC9 Fi:6} v7 FL:49 FC2 FL Fs Fp Fi Fp[10] Fs Fp FC4 Fp FL:5} vd FD Fp FL Fi FL}


 S21070C3 ::~S21070C3(){ note_dtor("S21070C3", this);}
S21070C3 ::S21070C3(){ note_ctor("S21070C3", this);} // tgen

static void Test_S21070C3()
{
  extern Class_Descriptor cd_S21070C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(430,1054)];
    init_test(&cd_S21070C3, buf);
    S21070C3 *dp, &lv = *(dp=new (buf) S21070C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6864,4212), "sizeof(S21070C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C3)");
    /*is_ambiguous_... S21070C3::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(1824,1116), "S21070C3");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(1824,1116), "S21070C3");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(1824,1116), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*), 0, "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(2240,1412), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*), ABISELECT(2240,1412), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(2240,1412), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(2032,1256), "S21070C3");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(2032,1256), "S21070C3");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(2032,1256), "S21070C3");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(2032,1256), "S21070C3");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(2032,1256), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*), 0, "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*), ABISELECT(144,80), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*), ABISELECT(352,220), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(560,376), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(672,432), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(672,432), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C5*), ABISELECT(560,376), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*), ABISELECT(1488,924), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C5*), 0, "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(5248,3268), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(5360,3324), "S21070C3");
    /*is_ambiguous_... S21070C3::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(5360,3324), "S21070C3");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C12*), ABISELECT(5248,3268), "S21070C3");
    check_base_class_offset(lv, (S21070C11*)(S21070C15*)(S21070C12*), ABISELECT(5248,3268), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(2352,1468), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(2352,1468), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C12*), ABISELECT(2496,1548), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(2704,1688), "S21070C3");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(2912,1844), "S21070C3");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(3024,1900), "S21070C3");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(3024,1900), "S21070C3");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(2912,1844), "S21070C3");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(3840,2392), "S21070C3");
    check_base_class_offset(lv, (S21070C5*)(S21070C12*), ABISELECT(2352,1468), "S21070C3");
    check_base_class_offset(lv, (S21070C13*)(S21070C12*), ABISELECT(4128,2548), "S21070C3");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(6176,3816), "S21070C3");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(6288,3872), "S21070C3");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(6288,3872), "S21070C3");
    check_base_class_offset(lv, (S21070C14*)(S21070C12*), ABISELECT(6176,3816), "S21070C3");
    check_base_class_offset(lv, (S21070C15*)(S21070C12*), ABISELECT(4208,2608), "S21070C3");
    check_base_class_offset(lv, (S21070C12*), ABISELECT(2352,1468), "S21070C3");
    check_field_offset(lv, s21070c3f0, ABISELECT(1776,1080), "S21070C3.s21070c3f0");
    check_field_offset(lv, s21070c3f1, ABISELECT(1792,1092), "S21070C3.s21070c3f1");
    check_field_offset(lv, s21070c3f2, ABISELECT(1800,1096), "S21070C3.s21070c3f2");
    check_field_offset(lv, s21070c3f3, ABISELECT(1808,1104), "S21070C3.s21070c3f3");
    check_field_offset(lv, s21070c3f4, ABISELECT(1816,1108), "S21070C3.s21070c3f4");
    test_class_info(&lv, &cd_S21070C3);
    dp->~S21070C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C3(Test_S21070C3, "S21070C3", ABISELECT(6864,4212));

#else // __cplusplus

extern void _ZN8S21070C3C1Ev();
extern void _ZN8S21070C3D2Ev();
Name_Map name_map_S21070C3[] = {
  NSPAIR(_ZN8S21070C3C1Ev),
  NSPAIR(_ZN8S21070C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C13;
extern VTBL_ENTRY _ZTI9S21070C13[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C15;
extern VTBL_ENTRY _ZTI9S21070C15[];
extern  VTBL_ENTRY _ZTV9S21070C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C15[];
extern Class_Descriptor cd_S21070C12;
extern VTBL_ENTRY _ZTI9S21070C12[];
extern  VTBL_ENTRY _ZTV9S21070C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C12[];
static Base_Class bases_S21070C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(1824,1116), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2240,1412), //bcp->offset
    53, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(2032,1256), //bcp->offset
    49, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(144,80), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(352,220), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(560,376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(672,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(672,432), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(560,376), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(1488,924), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(5248,3268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    109, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5360,3324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    112, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(5360,3324), //bcp->offset
    126, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    111, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(5248,3268), //bcp->offset
    114, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(2352,1468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2352,1468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(2496,1548), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(2704,1688), //bcp->offset
    81, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2912,1844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(3024,1900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(3024,1900), //bcp->offset
    94, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(2912,1844), //bcp->offset
    85, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(3840,2392), //bcp->offset
    102, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(2352,1468), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C13,    ABISELECT(4128,2548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6176,3816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    122, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6288,3872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    125, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(6288,3872), //bcp->offset
    146, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    124, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(6176,3816), //bcp->offset
    134, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    121, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S21070C15,    ABISELECT(4208,2608), //bcp->offset
    106, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C12,    ABISELECT(2352,1468), //bcp->offset
    58, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C3[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C3D1Ev();
extern void _ZN8S21070C3D0Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C3D1Ev,_ZThn376_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C3D0Ev,_ZThn376_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C3D1Ev,_ZThn432_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C3D0Ev,_ZThn432_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn2352_N8S21070C3D1Ev,_ZThn1468_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn2352_N8S21070C3D0Ev,_ZThn1468_N8S21070C3D0Ev)() __attribute__((weak));
extern void _ZN9S21070C122v9Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTvn560_n72_N8S21070C3D1Ev,_ZTvn376_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn560_n72_N8S21070C3D0Ev,_ZTvn376_n36_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn672_n72_N8S21070C3D1Ev,_ZTvn432_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn672_n72_N8S21070C3D0Ev,_ZTvn432_n36_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn1856_n72_N8S21070C3D1Ev,_ZTvn1140_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn1856_n72_N8S21070C3D0Ev,_ZTvn1140_n36_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn5248_N8S21070C3D1Ev,_ZThn3268_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn5248_N8S21070C3D0Ev,_ZThn3268_N8S21070C3D0Ev)() __attribute__((weak));
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N8S21070C3D1Ev,_ZTvn56_n32_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N8S21070C3D0Ev,_ZTvn56_n32_N8S21070C3D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn6176_N8S21070C3D1Ev,_ZThn3816_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn6176_N8S21070C3D0Ev,_ZThn3816_N8S21070C3D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N8S21070C3D1Ev,_ZTvn56_n28_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N8S21070C3D0Ev,_ZTvn56_n28_N8S21070C3D0Ev)();
static  VTBL_ENTRY vtc_S21070C3[] = {
  ABISELECT(6176,3816),
  ABISELECT(5248,3268),
  ABISELECT(2352,1468),
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C3D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C3D0Ev,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C3D1Ev,_ZThn376_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C3D0Ev,_ZThn376_N8S21070C3D0Ev),
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C3D1Ev,_ZThn432_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C3D0Ev,_ZThn432_N8S21070C3D0Ev),
  ABISELECT(336,192),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  ABISELECT(560,376),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(-2352,-1468),
  0,
  ABISELECT(3824,2348),
  ABISELECT(2896,1800),
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-2352,-1468),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
  ABISELECT(-2496,-1548),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-2704,-1688),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-2912,-1844),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C3D1Ev,_ZTvn376_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C3D0Ev,_ZTvn376_n36_N8S21070C3D0Ev),
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-3024,-1900),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C3D1Ev,_ZTvn432_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C3D0Ev,_ZTvn432_n36_N8S21070C3D0Ev),
  ABISELECT(-2016,-1276),
  ABISELECT(-3840,-2392),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  ABISELECT(-4208,-2608),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C3D1Ev,_ZTvn1140_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C3D0Ev,_ZTvn1140_n36_N8S21070C3D0Ev),
  ABISELECT(-5248,-3268),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-5248,-3268),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev),
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-5360,-3324),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C3D1Ev,_ZTvn56_n32_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C3D0Ev,_ZTvn56_n32_N8S21070C3D0Ev),
  0,
  ABISELECT(-6176,-3816),
  0,
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  ABISELECT(-6176,-3816),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-6288,-3872),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C3D1Ev,_ZTvn56_n28_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C3D0Ev,_ZTvn56_n28_N8S21070C3D0Ev),
};
extern VTBL_ENTRY _ZTV8S21070C3[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C5__8S21070C3[] = {
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C5__8S21070C3[] = {
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C5__8S21070C3[] = {
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C5__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C5__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__8S21070C3[] = {
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C5__A1__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1472,-896),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C5__A1__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1888,-1192),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__8S21070C3[] = {
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C5__A2__8S21070C3[] = {
  ABISELECT(1264,740),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A2__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-740),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A1__8S21070C3[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A3__8S21070C3[] = {
  ABISELECT(1152,684),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A3__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1152,-684),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A1__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1152,-684),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A1__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1360,-824),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A1__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1568,-980),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-740),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C5__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1472,-880),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C5__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1680,-1036),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C5__8S21070C3[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A4__8S21070C3[] = {
  ABISELECT(336,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C5__A4__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-336,-192),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C5__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C5__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C5__8S21070C3[] = {
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C5__8S21070C3[] = {
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C5__8S21070C3[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C5__8S21070C3[] = {
  ABISELECT(336,192),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C3[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C12D1Ev();
extern void _ZN9S21070C12D0Ev();
extern void _ZN9S21070C122v9Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C12__8S21070C3[] = {
  ABISELECT(3824,2348),
  ABISELECT(2896,1800),
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C59S21070C12__A3__8S21070C3[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C3[] = {
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A3__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A3__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A3__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C3[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A2__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(880,572),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A2__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(464,276),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C3[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C3[] = {
  ABISELECT(-1088,-728),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(1088,728),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C3[] = {
  ABISELECT(-1200,-784),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(1200,784),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(1200,784),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(992,644),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(784,488),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A2__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(1088,728),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A2__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(880,588),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A2__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(672,432),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A2__8S21070C3[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C3[] = {
  ABISELECT(-2016,-1276),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A10__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(2016,1276),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C59S21070C12__A1__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C59S21070C12__A1__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C59S21070C12__A1__8S21070C3[] = {
  ABISELECT(-2016,-1276),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN9S21070C15D1Ev();
extern void _ZN9S21070C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C159S21070C12__8S21070C3[] = {
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN9S21070C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C15D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C159S21070C12__8S21070C3[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C159S21070C12__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(2384,1492),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C159S21070C12__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(2176,1352),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C159S21070C12__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(1968,1196),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__8S21070C3[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-1152,-716),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C12__8S21070C3[] = {
  ABISELECT(-2896,-1800),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-2896,-1800),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C12__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C12__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C12__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C12__8S21070C3[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-3008,-1856),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C12__8S21070C3[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__A1__9S21070C12__8S21070C3[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__8S21070C3[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A6__9S21070C12__8S21070C3[] = {
  ABISELECT(-2016,-1276),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn3824_N9S21070C12D1Ev,_ZThn2348_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn3824_N9S21070C12D0Ev,_ZThn2348_N9S21070C12D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C12__8S21070C3[] = {
  0,
  ABISELECT(-3824,-2348),
  0,
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A3__9S21070C12__8S21070C3[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-3936,-2404),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev),
};
extern void ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C15__9S21070C12__8S21070C3[] = {
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  ABISELECT(-1856,-1140),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__A1__8S21070C3[] = {
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A5__8S21070C3[] = {
  ABISELECT(-3424,-2152),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(3424,2152),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A2__8S21070C3[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A6__8S21070C3[] = {
  ABISELECT(-3536,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A6__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(3536,2208),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__A2__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(3536,2208),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__A2__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(3328,2068),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A2__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3120,1912),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__A1__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(3424,2152),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__A1__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(3216,2012),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__A1__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3008,1856),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__A1__8S21070C3[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__8S21070C3[] = {
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C14__A11__8S21070C3[] = {
  ABISELECT(-4352,-2700),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C14__A11__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(4352,2700),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A5__8S21070C3[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C14__A12__8S21070C3[] = {
  ABISELECT(-4464,-2756),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A12__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(4464,2756),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C14__A5__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(4464,2756),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C14__A5__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4256,2616),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A5__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(4048,2460),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C14__8S21070C3[] = {
  0,
  0,
  0,
  ABISELECT(4352,2700),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14__8S21070C3[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4144,2560),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14__8S21070C3[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3936,2404),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14__8S21070C3[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
};
static  VTT_ENTRY vtt_S21070C3[] = {
  {&(_ZTV8S21070C3[8]),  8,154},
  {&(_tg__ZTV8S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C5__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C5__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C5__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C5__A1__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C5__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C5__A1__8S21070C3[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C5__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C5__A2__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A3__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A3__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A1__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A1__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C5__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C5__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A4__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C5__A4__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C5__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C5__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C5__8S21070C3[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C5__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C5__8S21070C3[3]),  3,4},
  {&(_ZTV8S21070C3[46]),  46,154},
  {&(_ZTV8S21070C3[53]),  53,154},
  {&(_ZTV8S21070C3[57]),  57,154},
  {&(_ZTV8S21070C3[20]),  20,154},
  {&(_ZTV8S21070C3[25]),  25,154},
  {&(_ZTV8S21070C3[34]),  34,154},
  {&(_ZTV8S21070C3[40]),  40,154},
  {&(_ZTV8S21070C3[72]),  72,154},
  {&(_ZTV8S21070C3[122]),  122,154},
  {&(_ZTV8S21070C3[131]),  131,154},
  {&(_ZTV8S21070C3[78]),  78,154},
  {&(_ZTV8S21070C3[85]),  85,154},
  {&(_ZTV8S21070C3[90]),  90,154},
  {&(_ZTV8S21070C3[99]),  99,154},
  {&(_ZTV8S21070C3[105]),  105,154},
  {&(_ZTV8S21070C3[142]),  142,154},
  {&(_ZTV8S21070C3[151]),  151,154},
  {&(_ZTV8S21070C3[112]),  112,154},
  {&(_tg__ZTV8S21070C8__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV9S21070C12__8S21070C3[7]),  7,11},
  {&(_tg__ZTV8S21070C59S21070C12__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C59S21070C12__A3__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A3__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A3__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A3__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A2__8S21070C3[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A2__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A2__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A10__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C59S21070C12__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C59S21070C12__A1__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C59S21070C12__A1__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C59S21070C12__A1__8S21070C3[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C59S21070C12__A1__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C59S21070C12__A1__8S21070C3[3]),  3,4},
  {&(_tg__ZTV9S21070C159S21070C12__8S21070C3[6]),  6,8},
  {&(_tg__ZTV9S21070C11__9S21070C159S21070C12__8S21070C3[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C159S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C159S21070C12__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C159S21070C12__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV9S21070C11__9S21070C12__8S21070C3[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C12__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C12__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C12__8S21070C3[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__A1__9S21070C12__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A6__9S21070C12__8S21070C3[3]),  3,4},
  {&(_tg__ZTV9S21070C14__9S21070C12__8S21070C3[8]),  8,12},
  {&(_tg__ZTV8S21070C69S21070C14__A3__9S21070C12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV9S21070C15__9S21070C12__8S21070C3[6]),  6,8},
  {&(_tg__ZTV9S21070C11__A1__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A5__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A6__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A6__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__A2__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__A2__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A2__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__A1__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__A1__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__A1__8S21070C3[5]),  5,8},
  {&(_tg__ZTV9S21070C14__8S21070C3[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C14__A11__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C14__A11__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C14__A5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C14__A12__8S21070C3[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A12__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C14__A5__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C14__A5__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A5__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C14__8S21070C3[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C14__8S21070C3[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14__8S21070C3[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C14__8S21070C3[5]),  5,8},
};
extern VTBL_ENTRY _ZTI8S21070C3[];
extern  VTBL_ENTRY _ZTV8S21070C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C3[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N9S21070C12D0Ev,_ZThn2348_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N9S21070C12D1Ev,_ZThn2348_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6176_N8S21070C3D0Ev,_ZThn3816_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6176_N8S21070C3D1Ev,_ZThn3816_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5248_N8S21070C3D0Ev,_ZThn3268_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5248_N8S21070C3D1Ev,_ZThn3268_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2352_N8S21070C3D0Ev,_ZThn1468_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2352_N8S21070C3D1Ev,_ZThn1468_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C3 = {  "S21070C3", // class name
  bases_S21070C3, 34,
  &(vtc_S21070C3[0]), // expected_vtbl_contents
  &(vtt_S21070C3[0]), // expected_vtt_contents
  ABISELECT(6864,4212), // object size
  NSPAIRA(_ZTI8S21070C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S21070C3),154, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C3),133, //virtual table table var
  33, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C18  : virtual S21070C8 {
  __tsi64 s21070c18f0;
  void *s21070c18f1;
  char s21070c18f2;
  int s21070c18f3;
  void *s21070c18f4[3];
  __tsi64 s21070c18f5;
  ~S21070C18(); // tgen
  S21070C18(); // tgen
};
//SIG(-1 S21070C18) C1{ VBC2{ VBC3{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC4{ VBC3 v4 Fi Fp[8] FL Fi Fl} Fc FU5{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC6{} Fp FU5 Fi Fi[3]} FL Fp Fc Fi Fp[3] FL}


S21070C18 ::~S21070C18(){ note_dtor("S21070C18", this);} // tgen
S21070C18 ::S21070C18(){ note_ctor("S21070C18", this);} // tgen

static void Test_S21070C18()
{
  extern Class_Descriptor cd_S21070C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(37,100)];
    init_test(&cd_S21070C18, buf);
    S21070C18 *dp, &lv = *(dp=new (buf) S21070C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,396), "sizeof(S21070C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C18)");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(272,200), "S21070C18");
    check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(272,200), "S21070C18");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(472,340), "S21070C18");
    check_base_class_offset(lv, (S21070C8*), ABISELECT(64,44), "S21070C18");
    check_field_offset(lv, s21070c18f0, ABISELECT(8,4), "S21070C18.s21070c18f0");
    check_field_offset(lv, s21070c18f1, ABISELECT(16,12), "S21070C18.s21070c18f1");
    check_field_offset(lv, s21070c18f2, ABISELECT(24,16), "S21070C18.s21070c18f2");
    check_field_offset(lv, s21070c18f3, ABISELECT(28,20), "S21070C18.s21070c18f3");
    check_field_offset(lv, s21070c18f4, ABISELECT(32,24), "S21070C18.s21070c18f4");
    check_field_offset(lv, s21070c18f5, ABISELECT(56,36), "S21070C18.s21070c18f5");
    test_class_info(&lv, &cd_S21070C18);
    dp->~S21070C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C18(Test_S21070C18, "S21070C18", ABISELECT(576,396));

#else // __cplusplus

extern void _ZN9S21070C18C1Ev();
extern void _ZN9S21070C18D1Ev();
Name_Map name_map_S21070C18[] = {
  NSPAIR(_ZN9S21070C18C1Ev),
  NSPAIR(_ZN9S21070C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
static Base_Class bases_S21070C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(272,200), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(472,340), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(64,44), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C18[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY vtc_S21070C18[] = {
  ABISELECT(472,340),
  ABISELECT(272,200),
  ABISELECT(64,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  0,
  0,
  0,
  ABISELECT(-272,-200),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  0,
  ABISELECT(-200,-140),
  ABISELECT(-472,-340),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern VTBL_ENTRY _ZTV9S21070C18[];
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C18[] = {
  0,
  0,
  0,
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C18[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(-408,-296),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C18[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTT_ENTRY vtt_S21070C18[] = {
  {&(_ZTV9S21070C18[5]),  5,22},
  {&(_ZTV9S21070C18[9]),  9,22},
  {&(_ZTV9S21070C18[14]),  14,22},
  {&(_ZTV9S21070C18[21]),  21,22},
  {&(_tg__ZTV8S21070C8__9S21070C18[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C18[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C18[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C18[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C18[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
Class_Descriptor cd_S21070C18 = {  "S21070C18", // class name
  bases_S21070C18, 3,
  &(vtc_S21070C18[0]), // expected_vtbl_contents
  &(vtt_S21070C18[0]), // expected_vtt_contents
  ABISELECT(576,396), // object size
  NSPAIRA(_ZTI9S21070C18),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S21070C18),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C18),9, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C19  : virtual S21070C7 , S21070C4 , S21070C6 , virtual S21070C18 {
  int s21070c19f0;
  int s21070c19f1;
  ::S21070C5 s21070c19f2[3];
  ::S21070C4 s21070c19f3;
  __tsi64 s21070c19f4[9];
  ::S21070C11 s21070c19f5;
  char s21070c19f6;
  __tsi64 s21070c19f7;
  ::S21070C11 s21070c19f8;
  virtual  ~S21070C19(); // _ZN9S21070C19D2Ev
  virtual void  v10(); // _ZN9S21070C193v10Ev
  virtual void  v11(); // _ZN9S21070C193v11Ev
  virtual void  v12(); // _ZN9S21070C193v12Ev
  S21070C19(); // tgen
};
//SIG(-1 S21070C19) C1{ VBC2{ VBC3{ v4 v5 v6 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} v7 Fi Fp[8] FL Fi Fl} BC3 BC4{ VBC3 BC2 VBC5{ VBC3 VBC2 Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} vd FL Fi FD} VBC8{ VBC5 FL Fp Fc Fi Fp[3] FL} vd v1 v2 v3 Fi Fi FC9{ BC4 BC3 BC5 BC10{ VBC3 VBC5 BC2 BC4 v8 Fi Fp FC2 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC2 vd Fs FC7 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC3 FL[9] FC10 Fc FL FC10}


 S21070C19 ::~S21070C19(){ note_dtor("S21070C19", this);}
void  S21070C19 ::v10(){vfunc_called(this, "_ZN9S21070C193v10Ev");}
void  S21070C19 ::v11(){vfunc_called(this, "_ZN9S21070C193v11Ev");}
void  S21070C19 ::v12(){vfunc_called(this, "_ZN9S21070C193v12Ev");}
S21070C19 ::S21070C19(){ note_ctor("S21070C19", this);} // tgen

static void Test_S21070C19()
{
  extern Class_Descriptor cd_S21070C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(694,1737)];
    init_test(&cd_S21070C19, buf);
    S21070C19 *dp, &lv = *(dp=new (buf) S21070C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(11088,6944), "sizeof(S21070C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C19)");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(10608,6604), "S21070C19");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*), ABISELECT(10608,6604), "S21070C19");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*), ABISELECT(10608,6604), "S21070C19");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(10608,6604), "S21070C19");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), ABISELECT(10496,6548), "S21070C19");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(10496,6548), "S21070C19");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*), 0, "S21070C19");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*), ABISELECT(208,140), "S21070C19");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*), ABISELECT(10816,6744), "S21070C19");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(10816,6744), "S21070C19");
    check_base_class_offset(lv, (S21070C6*), ABISELECT(208,140), "S21070C19");
    check_base_class_offset(lv, (S21070C18*), ABISELECT(11024,6900), "S21070C19");
    check_field_offset(lv, s21070c19f0, ABISELECT(352,220), "S21070C19.s21070c19f0");
    check_field_offset(lv, s21070c19f1, ABISELECT(356,224), "S21070C19.s21070c19f1");
    check_field_offset(lv, s21070c19f2, ABISELECT(368,228), "S21070C19.s21070c19f2");
    check_field_offset(lv, s21070c19f3, ABISELECT(7280,4524), "S21070C19.s21070c19f3");
    check_field_offset(lv, s21070c19f4, ABISELECT(7488,4664), "S21070C19.s21070c19f4");
    check_field_offset(lv, s21070c19f5, ABISELECT(7568,4736), "S21070C19.s21070c19f5");
    check_field_offset(lv, s21070c19f6, ABISELECT(9024,5636), "S21070C19.s21070c19f6");
    check_field_offset(lv, s21070c19f7, ABISELECT(9032,5640), "S21070C19.s21070c19f7");
    check_field_offset(lv, s21070c19f8, ABISELECT(9040,5648), "S21070C19.s21070c19f8");
    test_class_info(&lv, &cd_S21070C19);
    dp->~S21070C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C19(Test_S21070C19, "S21070C19", ABISELECT(11088,6944));

#else // __cplusplus

extern void _ZN9S21070C19C1Ev();
extern void _ZN9S21070C19D2Ev();
Name_Map name_map_S21070C19[] = {
  NSPAIR(_ZN9S21070C19C1Ev),
  NSPAIR(_ZN9S21070C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
static Base_Class bases_S21070C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(10608,6604), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(10496,6548), //bcp->offset
    22, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(208,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(10816,6744), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S21070C6,    ABISELECT(208,140), //bcp->offset
    14, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C18,    ABISELECT(11024,6900), //bcp->offset
    39, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C19[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY vtc_S21070C19[] = {
  ABISELECT(11024,6900),
  ABISELECT(10816,6744),
  ABISELECT(10608,6604),
  ABISELECT(10496,6548),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(10288,6408),
  ABISELECT(10608,6604),
  ABISELECT(10400,6464),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
  0,
  ABISELECT(112,56),
  ABISELECT(-10496,-6548),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-10608,-6604),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-320,-196),
  ABISELECT(-208,-140),
  ABISELECT(-10816,-6744),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  ABISELECT(-528,-352),
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  ABISELECT(-11024,-6900),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
extern VTBL_ENTRY _ZTV9S21070C19[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19[] = {
  ABISELECT(10288,6408),
  ABISELECT(10608,6604),
  ABISELECT(10400,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C6__A1__9S21070C19[] = {
  ABISELECT(10400,6464),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C6__A1__9S21070C19[] = {
  0,
  0,
  0,
  ABISELECT(-10400,-6464),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C6__9S21070C19[] = {
  0,
  0,
  0,
  ABISELECT(-10400,-6464),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C6__9S21070C19[] = {
  ABISELECT(-320,-196),
  ABISELECT(-208,-140),
  ABISELECT(-10608,-6604),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C6__9S21070C19[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-10288,-6408),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C19[] = {
  0,
  0,
  0,
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19[] = {
  ABISELECT(-320,-196),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C19[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C19[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(320,196),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19[] = {
  ABISELECT(-528,-352),
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C19[] = {
  ABISELECT(-320,-196),
  ABISELECT(-208,-140),
  ABISELECT(208,156),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C19[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C19[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTT_ENTRY vtt_S21070C19[] = {
  {&(_ZTV9S21070C19[6]),  6,44},
  {&(_tg__ZTV8S21070C6__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C6__A1__9S21070C19[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C6__A1__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C6__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C6__9S21070C19[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C6__9S21070C19[4]),  4,5},
  {&(_ZTV9S21070C19[26]),  26,44},
  {&(_ZTV9S21070C19[32]),  32,44},
  {&(_ZTV9S21070C19[19]),  19,44},
  {&(_ZTV9S21070C19[39]),  39,44},
  {&(_ZTV9S21070C19[44]),  44,44},
  {&(_tg__ZTV8S21070C7__9S21070C19[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C19[4]),  4,5},
  {&(_tg__ZTV9S21070C18__9S21070C19[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C19[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C19[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C19[4]),  4,5},
};
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
Class_Descriptor cd_S21070C19 = {  "S21070C19", // class name
  bases_S21070C19, 7,
  &(vtc_S21070C19[0]), // expected_vtbl_contents
  &(vtt_S21070C19[0]), // expected_vtt_contents
  ABISELECT(11088,6944), // object size
  NSPAIRA(_ZTI9S21070C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21070C19),44, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C19),21, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C17  : virtual S21070C7 , virtual S21070C18 , virtual S21070C19 {
  __tsi64 s21070c17f0;
  void *s21070c17f1;
  ::S21070C4 s21070c17f2[9];
  char s21070c17f3;
  virtual  ~S21070C17(); // _ZN9S21070C17D2Ev
  virtual void  v13(); // _ZN9S21070C173v13Ev
  S21070C17(); // tgen
};
//SIG(-1 S21070C17) C1{ VBC2{ VBC3{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} v5 Fi Fp[8] FL Fi Fl} VBC4{ VBC5{ VBC3 VBC2 Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} FL Fp Fc Fi Fp[3] FL} VBC8{ VBC2 BC3 BC9{ VBC3 BC2 VBC5 vd FL Fi FD} VBC4 vd v6 v7 v8 Fi Fi FC10{ BC9 BC3 BC5 BC11{ VBC3 VBC5 BC2 BC9 v9 Fi Fp FC2 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC2 vd Fs FC7 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC3 FL[9] FC11 Fc FL FC11} vd v1 FL Fp FC3[9] Fc}


 S21070C17 ::~S21070C17(){ note_dtor("S21070C17", this);}
void  S21070C17 ::v13(){vfunc_called(this, "_ZN9S21070C173v13Ev");}
S21070C17 ::S21070C17(){ note_ctor("S21070C17", this);} // tgen

static void Test_S21070C17()
{
  extern Class_Descriptor cd_S21070C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(813,2057)];
    init_test(&cd_S21070C17, buf);
    S21070C17 *dp, &lv = *(dp=new (buf) S21070C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12992,8224), "sizeof(S21070C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C17)");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(2016,1336), "S21070C17");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(2016,1336), "S21070C17");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(2016,1336), "S21070C17");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2016,1336), "S21070C17");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*), ABISELECT(1912,1280), "S21070C17");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(1912,1280), "S21070C17");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(1912,1280), "S21070C17");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(2288,1520), "S21070C17");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(2288,1520), "S21070C17");
    check_base_class_offset(lv, (S21070C18*), ABISELECT(2216,1476), "S21070C17");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(2216,1476), "S21070C17");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(2496,1676), "S21070C17");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2704,1816), "S21070C17");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(2704,1816), "S21070C17");
    check_base_class_offset(lv, (S21070C19*), ABISELECT(2496,1676), "S21070C17");
    check_field_offset(lv, s21070c17f0, ABISELECT(8,4), "S21070C17.s21070c17f0");
    check_field_offset(lv, s21070c17f1, ABISELECT(16,12), "S21070C17.s21070c17f1");
    check_field_offset(lv, s21070c17f2, ABISELECT(32,16), "S21070C17.s21070c17f2");
    check_field_offset(lv, s21070c17f3, ABISELECT(1904,1276), "S21070C17.s21070c17f3");
    test_class_info(&lv, &cd_S21070C17);
    dp->~S21070C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C17(Test_S21070C17, "S21070C17", ABISELECT(12992,8224));

#else // __cplusplus

extern void _ZN9S21070C17C1Ev();
extern void _ZN9S21070C17D2Ev();
Name_Map name_map_S21070C17[] = {
  NSPAIR(_ZN9S21070C17C1Ev),
  NSPAIR(_ZN9S21070C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
static Base_Class bases_S21070C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(2016,1336), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(1912,1280), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C8,    ABISELECT(2288,1520), //bcp->offset
    28, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C18,    ABISELECT(2216,1476), //bcp->offset
    23, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C4,    ABISELECT(2496,1676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2704,1816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2704,1816), //bcp->offset
    54, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(2496,1676), //bcp->offset
    32, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C17[];
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn2496_N9S21070C17D1Ev,_ZThn1676_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn2496_N9S21070C17D0Ev,_ZThn1676_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY vtc_S21070C17[] = {
  ABISELECT(2496,1676),
  ABISELECT(2288,1520),
  ABISELECT(2216,1476),
  ABISELECT(2016,1336),
  ABISELECT(1912,1280),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  0,
  ABISELECT(104,56),
  ABISELECT(-1912,-1280),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-2016,-1336),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-304,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-2216,-1476),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  ABISELECT(-376,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2288,-1520),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2496,-1676),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-584,-396),
  ABISELECT(-2496,-1676),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-792,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-2704,-1816),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern VTBL_ENTRY _ZTV9S21070C17[];
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C17[] = {
  ABISELECT(104,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C17[] = {
  ABISELECT(-304,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C17[] = {
  ABISELECT(-376,-240),
  ABISELECT(-272,-184),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C17[] = {
  0,
  ABISELECT(104,56),
  ABISELECT(304,196),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C17[] = {
  ABISELECT(-376,-240),
  ABISELECT(-272,-184),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(272,184),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C17[] = {
  0,
  ABISELECT(104,56),
  ABISELECT(376,240),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C17[] = {
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-584,-396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C17[] = {
  ABISELECT(-792,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C17[] = {
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C17[] = {
  ABISELECT(-376,-240),
  ABISELECT(-272,-184),
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C17[] = {
  0,
  ABISELECT(104,56),
  ABISELECT(792,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C17[] = {
  0,
  ABISELECT(104,56),
  ABISELECT(584,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C17[] = {
  0,
  0,
  0,
  ABISELECT(480,340),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C17[] = {
  ABISELECT(-792,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C17[] = {
  ABISELECT(-376,-240),
  ABISELECT(-272,-184),
  ABISELECT(208,156),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C17[] = {
  ABISELECT(-304,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(280,200),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTT_ENTRY vtt_S21070C17[] = {
  {&(_ZTV9S21070C17[7]),  7,62},
  {&(_ZTV9S21070C17[14]),  14,62},
  {&(_ZTV9S21070C17[20]),  20,62},
  {&(_ZTV9S21070C17[28]),  28,62},
  {&(_ZTV9S21070C17[32]),  32,62},
  {&(_ZTV9S21070C17[46]),  46,62},
  {&(_ZTV9S21070C17[59]),  59,62},
  {&(_tg__ZTV8S21070C7__9S21070C17[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C17[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C17[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C17[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C17[4]),  4,5},
  {&(_tg__ZTV8S21070C8__9S21070C17[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C17[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C17[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C17[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C17[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C17[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C17[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C17[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C17[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C17[5]),  5,5},
};
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2496_N9S21070C17D0Ev,_ZThn1676_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2496_N9S21070C17D1Ev,_ZThn1676_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C17 = {  "S21070C17", // class name
  bases_S21070C17, 8,
  &(vtc_S21070C17[0]), // expected_vtbl_contents
  &(vtt_S21070C17[0]), // expected_vtt_contents
  ABISELECT(12992,8224), // object size
  NSPAIRA(_ZTI9S21070C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S21070C17),62, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C17),28, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C16  : virtual S21070C8 , S21070C17 {
  void *s21070c16f0[4];
  void *s21070c16f1;
  int s21070c16f2;
  virtual  ~S21070C16(); // _ZN9S21070C16D2Ev
  virtual void  v14(); // _ZN9S21070C163v14Ev
  S21070C16(); // tgen
};
//SIG(-1 S21070C16) C1{ VBC2{ VBC3{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC4{ VBC3 v5 Fi Fp[8] FL Fi Fl} Fc FU5{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC6{} Fp FU5 Fi Fi[3]} BC7{ VBC4 VBC8{ VBC2 FL Fp Fc Fi Fp[3] FL} VBC9{ VBC4 BC3 BC10{ VBC3 BC4 VBC2 vd FL Fi FD} VBC8 vd v6 v7 v8 Fi Fi FC11{ BC10 BC3 BC2 BC12{ VBC3 VBC2 BC4 BC10 v10 Fi Fp FC4 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC4 vd Fs FC6 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC3 FL[9] FC12 Fc FL FC12} vd v9 FL Fp FC3[9] Fc} vd v1 Fp[4] Fp Fi}


 S21070C16 ::~S21070C16(){ note_dtor("S21070C16", this);}
void  S21070C16 ::v14(){vfunc_called(this, "_ZN9S21070C163v14Ev");}
S21070C16 ::S21070C16(){ note_ctor("S21070C16", this);} // tgen

static void Test_S21070C16()
{
  extern Class_Descriptor cd_S21070C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(816,2063)];
    init_test(&cd_S21070C16, buf);
    S21070C16 *dp, &lv = *(dp=new (buf) S21070C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13040,8248), "sizeof(S21070C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C16)");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(2176,1460), "S21070C16");
    /*is_ambiguous_... S21070C16::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(2176,1460), "S21070C16");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(2176,1460), "S21070C16");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2176,1460), "S21070C16");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(2376,1600), "S21070C16");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*), ABISELECT(2376,1600), "S21070C16");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(2376,1600), "S21070C16");
    check_base_class_offset(lv, (S21070C8*), ABISELECT(1968,1304), "S21070C16");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(1968,1304), "S21070C16");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(1968,1304), "S21070C16");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*), ABISELECT(2480,1656), "S21070C16");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(2480,1656), "S21070C16");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(2544,1700), "S21070C16");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2752,1840), "S21070C16");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(2752,1840), "S21070C16");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*), ABISELECT(2544,1700), "S21070C16");
    check_base_class_offset(lv, (S21070C17*), 0, "S21070C16");
    check_field_offset(lv, s21070c16f0, ABISELECT(1912,1280), "S21070C16.s21070c16f0");
    check_field_offset(lv, s21070c16f1, ABISELECT(1944,1296), "S21070C16.s21070c16f1");
    check_field_offset(lv, s21070c16f2, ABISELECT(1952,1300), "S21070C16.s21070c16f2");
    test_class_info(&lv, &cd_S21070C16);
    dp->~S21070C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C16(Test_S21070C16, "S21070C16", ABISELECT(13040,8248));

#else // __cplusplus

extern void _ZN9S21070C16C1Ev();
extern void _ZN9S21070C16D2Ev();
Name_Map name_map_S21070C16[] = {
  NSPAIR(_ZN9S21070C16C1Ev),
  NSPAIR(_ZN9S21070C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
static Base_Class bases_S21070C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(2176,1460), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(2376,1600), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(1968,1304), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C18,    ABISELECT(2480,1656), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(2544,1700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2752,1840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2752,1840), //bcp->offset
    55, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(2544,1700), //bcp->offset
    33, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S21070C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C16[];
extern void _ZN9S21070C16D1Ev();
extern void _ZN9S21070C16D0Ev();
extern void _ZN9S21070C173v13Ev();
extern void _ZN9S21070C163v14Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev)();
extern void ABISELECT(_ZThn2544_N9S21070C16D1Ev,_ZThn1700_N9S21070C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev)();
extern void ABISELECT(_ZThn2544_N9S21070C16D0Ev,_ZThn1700_N9S21070C16D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C16D1Ev,_ZTvn140_n40_N9S21070C16D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C16D0Ev,_ZTvn140_n40_N9S21070C16D0Ev)();
static  VTBL_ENTRY vtc_S21070C16[] = {
  ABISELECT(2544,1700),
  ABISELECT(1968,1304),
  ABISELECT(2480,1656),
  ABISELECT(2176,1460),
  ABISELECT(2376,1600),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN9S21070C16D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C16D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  (VTBL_ENTRY)&_ZN9S21070C163v14Ev,
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(-1968,-1304),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  0,
  0,
  0,
  ABISELECT(-2176,-1460),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  0,
  ABISELECT(-200,-140),
  ABISELECT(-2376,-1600),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-104,-56),
  ABISELECT(-304,-196),
  ABISELECT(-512,-352),
  ABISELECT(-2480,-1656),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2544,-1700),
  0,
  0,
  0,
  ABISELECT(-64,-44),
  ABISELECT(-576,-396),
  ABISELECT(-368,-240),
  ABISELECT(-168,-100),
  ABISELECT(-2544,-1700),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-376,-240),
  ABISELECT(-784,-536),
  ABISELECT(-576,-380),
  ABISELECT(-2752,-1840),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C16D1Ev,_ZTvn140_n40_N9S21070C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C16D0Ev,_ZTvn140_n40_N9S21070C16D0Ev),
};
extern VTBL_ENTRY _ZTV9S21070C16[];
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C16[] = {
  ABISELECT(2544,1700),
  ABISELECT(1968,1304),
  ABISELECT(2480,1656),
  ABISELECT(2176,1460),
  ABISELECT(2376,1600),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C17__9S21070C16[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(-2376,-1600),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C17__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(-2176,-1460),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C17__9S21070C16[] = {
  ABISELECT(-104,-56),
  ABISELECT(-304,-196),
  ABISELECT(-512,-352),
  ABISELECT(-2480,-1656),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C17__9S21070C16[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(-1968,-1304),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn2544_N9S21070C17D1Ev,_ZThn1700_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn2544_N9S21070C17D0Ev,_ZThn1700_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C17__9S21070C16[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2544,-1700),
  0,
  0,
  0,
  ABISELECT(-64,-44),
  ABISELECT(-576,-396),
  ABISELECT(-368,-240),
  ABISELECT(-168,-100),
  ABISELECT(-2544,-1700),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C17__9S21070C16[] = {
  ABISELECT(-376,-240),
  ABISELECT(-784,-536),
  ABISELECT(-576,-380),
  ABISELECT(-2752,-1840),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C16[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C16[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(-408,-296),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C16[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C16[] = {
  ABISELECT(-104,-56),
  ABISELECT(-304,-196),
  ABISELECT(-512,-352),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C16[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(512,352),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(304,196),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C16[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C16[] = {
  ABISELECT(-64,-44),
  ABISELECT(-576,-396),
  ABISELECT(-368,-240),
  ABISELECT(-168,-100),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C16[] = {
  ABISELECT(-376,-240),
  ABISELECT(-784,-536),
  ABISELECT(-576,-380),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C16[] = {
  ABISELECT(-576,-380),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(576,380),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(576,380),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C16[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(784,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C16[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(376,240),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C16[] = {
  0,
  ABISELECT(-200,-140),
  ABISELECT(168,100),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C16[] = {
  0,
  0,
  0,
  ABISELECT(368,240),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C16[] = {
  ABISELECT(-376,-240),
  ABISELECT(-784,-536),
  ABISELECT(-576,-380),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C16[] = {
  ABISELECT(408,296),
  ABISELECT(208,156),
  ABISELECT(576,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C16[] = {
  ABISELECT(-104,-56),
  ABISELECT(-304,-196),
  ABISELECT(-512,-352),
  ABISELECT(64,44),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTT_ENTRY vtt_S21070C16[] = {
  {&(_ZTV9S21070C16[7]),  7,63},
  {&(_tg__ZTV9S21070C17__9S21070C16[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C17__9S21070C16[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C17__9S21070C16[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C17__9S21070C16[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C17__9S21070C16[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C17__9S21070C16[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C17__9S21070C16[5]),  5,8},
  {&(_ZTV9S21070C16[15]),  15,63},
  {&(_ZTV9S21070C16[20]),  20,63},
  {&(_ZTV9S21070C16[27]),  27,63},
  {&(_ZTV9S21070C16[33]),  33,63},
  {&(_ZTV9S21070C16[47]),  47,63},
  {&(_ZTV9S21070C16[60]),  60,63},
  {&(_tg__ZTV8S21070C8__9S21070C16[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C16[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C16[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C16[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C16[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C16[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C16[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C16[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C16[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C16[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C16[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C16[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C16[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C16[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C16[5]),  5,5},
};
extern VTBL_ENTRY _ZTI9S21070C16[];
extern  VTBL_ENTRY _ZTV9S21070C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C16[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2544_N9S21070C17D0Ev,_ZThn1700_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2544_N9S21070C17D1Ev,_ZThn1700_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2544_N9S21070C16D0Ev,_ZThn1700_N9S21070C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2544_N9S21070C16D1Ev,_ZThn1700_N9S21070C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C16 = {  "S21070C16", // class name
  bases_S21070C16, 9,
  &(vtc_S21070C16[0]), // expected_vtbl_contents
  &(vtt_S21070C16[0]), // expected_vtt_contents
  ABISELECT(13040,8248), // object size
  NSPAIRA(_ZTI9S21070C16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S21070C16),63, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C16),35, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C22  {
  void *s21070c22f0;
  int s21070c22f1;
  virtual void  v15(); // _ZN9S21070C223v15Ev
  virtual void  v16(); // _ZN9S21070C223v16Ev
  virtual void  v17(); // _ZN9S21070C223v17Ev
  ~S21070C22(); // tgen
  S21070C22(); // tgen
};
//SIG(-1 S21070C22) C1{ v1 v2 v3 Fp Fi}


void  S21070C22 ::v15(){vfunc_called(this, "_ZN9S21070C223v15Ev");}
void  S21070C22 ::v16(){vfunc_called(this, "_ZN9S21070C223v16Ev");}
void  S21070C22 ::v17(){vfunc_called(this, "_ZN9S21070C223v17Ev");}
S21070C22 ::~S21070C22(){ note_dtor("S21070C22", this);} // tgen
S21070C22 ::S21070C22(){ note_ctor("S21070C22", this);} // tgen

static void Test_S21070C22()
{
  extern Class_Descriptor cd_S21070C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21070C22, buf);
    S21070C22 *dp, &lv = *(dp=new (buf) S21070C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21070C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21070C22)");
    check_field_offset(lv, s21070c22f0, ABISELECT(8,4), "S21070C22.s21070c22f0");
    check_field_offset(lv, s21070c22f1, ABISELECT(16,8), "S21070C22.s21070c22f1");
    test_class_info(&lv, &cd_S21070C22);
    dp->~S21070C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C22(Test_S21070C22, "S21070C22", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21070C22C1Ev();
extern void _ZN9S21070C22D1Ev();
Name_Map name_map_S21070C22[] = {
  NSPAIR(_ZN9S21070C22C1Ev),
  NSPAIR(_ZN9S21070C22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21070C22[];
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY vtc_S21070C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C22[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
Class_Descriptor cd_S21070C22 = {  "S21070C22", // class name
  0,0,//no base classes
  &(vtc_S21070C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21070C22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21070C22),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C21  : S21070C4 , S21070C17 , virtual S21070C22 {
  __tsi64 s21070c21f0:3;
  __tsi64 s21070c21f1;
  virtual  ~S21070C21(); // _ZN9S21070C21D2Ev
  S21070C21(); // tgen
};
//SIG(-1 S21070C21) C1{ BC2{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC3{ VBC4{ VBC2 v4 Fi Fp[8] FL Fi Fl} VBC5{ VBC6{ VBC2 VBC4 Fc FU7{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC8{} Fp FU7 Fi Fi[3]} FL Fp Fc Fi Fp[3] FL} VBC9{ VBC4 BC2 BC10{ VBC2 BC4 VBC6 vd FL Fi FD} VBC5 vd v5 v6 v7 Fi Fi FC11{ BC10 BC2 BC6 BC12{ VBC2 VBC6 BC4 BC10 v12 Fi Fp FC4 Fi[2] Fp[3] Fc FL Fp[9] FC2} BC4 vd Fs FC8 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC2 FL[9] FC12 Fc FL FC12} vd v8 FL Fp FC2[9] Fc} VBC13{ v9 v10 v11 Fp Fi} vd FL:3 FL}


 S21070C21 ::~S21070C21(){ note_dtor("S21070C21", this);}
S21070C21 ::S21070C21(){ note_ctor("S21070C21", this);} // tgen

static void Test_S21070C21()
{
  extern Class_Descriptor cd_S21070C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(829,2097)];
    init_test(&cd_S21070C21, buf);
    S21070C21 *dp, &lv = *(dp=new (buf) S21070C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13248,8384), "sizeof(S21070C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C21)");
    /*is_ambiguous_... S21070C21::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*), 0, "S21070C21");
    /*is_ambiguous_... S21070C21::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(2240,1484), "S21070C21");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(2240,1484), "S21070C21");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(2240,1484), "S21070C21");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2240,1484), "S21070C21");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*), ABISELECT(2128,1428), "S21070C21");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(2128,1428), "S21070C21");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(2128,1428), "S21070C21");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(2512,1668), "S21070C21");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(2512,1668), "S21070C21");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*), ABISELECT(2440,1624), "S21070C21");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(2440,1624), "S21070C21");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(2720,1824), "S21070C21");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(2928,1964), "S21070C21");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(2928,1964), "S21070C21");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*), ABISELECT(2720,1824), "S21070C21");
    check_base_class_offset(lv, (S21070C17*), ABISELECT(208,140), "S21070C21");
    check_base_class_offset(lv, (S21070C22*), ABISELECT(13216,8372), "S21070C21");
    set_bf_and_test(lv, s21070c21f0, ABISELECT(2113,1417), 0, 3, 1, "S21070C21");
    set_bf_and_test(lv, s21070c21f0, ABISELECT(2113,1417), 0, 3, hide_sll(1LL<<2), "S21070C21");
    check_field_offset(lv, s21070c21f1, ABISELECT(2120,1420), "S21070C21.s21070c21f1");
    test_class_info(&lv, &cd_S21070C21);
    dp->~S21070C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C21(Test_S21070C21, "S21070C21", ABISELECT(13248,8384));

#else // __cplusplus

extern void _ZN9S21070C21C1Ev();
extern void _ZN9S21070C21D2Ev();
Name_Map name_map_S21070C21[] = {
  NSPAIR(_ZN9S21070C21C1Ev),
  NSPAIR(_ZN9S21070C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
static Base_Class bases_S21070C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C4,    ABISELECT(2240,1484), //bcp->offset
    28, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(2128,1428), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(2512,1668), //bcp->offset
    41, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C18,    ABISELECT(2440,1624), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(2720,1824), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2928,1964), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2928,1964), //bcp->offset
    67, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(2720,1824), //bcp->offset
    45, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(208,140), //bcp->offset
    13, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C22,    ABISELECT(13216,8372), //bcp->offset
    75, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C21[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn2720_N9S21070C21D1Ev,_ZThn1824_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn2720_N9S21070C21D0Ev,_ZThn1824_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY vtc_S21070C21[] = {
  ABISELECT(13216,8372),
  ABISELECT(2720,1824),
  ABISELECT(2512,1668),
  ABISELECT(2440,1624),
  ABISELECT(2240,1484),
  ABISELECT(2128,1428),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
  ABISELECT(2512,1684),
  ABISELECT(2304,1528),
  ABISELECT(2232,1484),
  ABISELECT(2032,1344),
  ABISELECT(1920,1288),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  0,
  ABISELECT(112,56),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-2240,-1484),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-2440,-1624),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2512,-1668),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2720,-1824),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-2720,-1824),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-2928,-1964),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
  0,
  0,
  0,
  ABISELECT(-13216,-8372),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern VTBL_ENTRY _ZTV9S21070C21[];
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21[] = {
  ABISELECT(2512,1684),
  ABISELECT(2304,1528),
  ABISELECT(2232,1484),
  ABISELECT(2032,1344),
  ABISELECT(1920,1288),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C17__9S21070C21[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1920,-1288),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C17__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(-2032,-1344),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C17__9S21070C21[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-2232,-1484),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C17__9S21070C21[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2304,-1528),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn2512_N9S21070C17D1Ev,_ZThn1684_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn2512_N9S21070C17D0Ev,_ZThn1684_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C17__9S21070C21[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2512,-1684),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-2512,-1684),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C17__9S21070C21[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-2720,-1824),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C21[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C21[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(312,196),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(272,184),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C21[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(384,240),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21[] = {
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C21[] = {
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C21[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C21[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(800,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C21[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(592,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C21[] = {
  0,
  0,
  0,
  ABISELECT(480,340),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C21[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C21[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(208,156),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C21[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(280,200),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTT_ENTRY vtt_S21070C21[] = {
  {&(_ZTV9S21070C21[8]),  8,83},
  {&(_tg__ZTV9S21070C17__9S21070C21[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C17__9S21070C21[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C17__9S21070C21[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C17__9S21070C21[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C17__9S21070C21[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C17__9S21070C21[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C17__9S21070C21[5]),  5,8},
  {&(_ZTV9S21070C21[20]),  20,83},
  {&(_ZTV9S21070C21[27]),  27,83},
  {&(_ZTV9S21070C21[33]),  33,83},
  {&(_ZTV9S21070C21[41]),  41,83},
  {&(_ZTV9S21070C21[45]),  45,83},
  {&(_ZTV9S21070C21[59]),  59,83},
  {&(_ZTV9S21070C21[72]),  72,83},
  {&(_ZTV9S21070C21[80]),  80,83},
  {&(_tg__ZTV8S21070C7__9S21070C21[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C21[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C21[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C21[4]),  4,5},
  {&(_tg__ZTV8S21070C8__9S21070C21[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C21[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C21[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C21[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C21[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C21[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C21[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C21[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C21[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C21[5]),  5,5},
};
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2512_N9S21070C17D0Ev,_ZThn1684_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2512_N9S21070C17D1Ev,_ZThn1684_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N9S21070C21D0Ev,_ZThn1824_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N9S21070C21D1Ev,_ZThn1824_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C21 = {  "S21070C21", // class name
  bases_S21070C21, 11,
  &(vtc_S21070C21[0]), // expected_vtbl_contents
  &(vtt_S21070C21[0]), // expected_vtt_contents
  ABISELECT(13248,8384), // object size
  NSPAIRA(_ZTI9S21070C21),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S21070C21),83, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C21),37, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C24  {
  char s21070c24f0;
  ::S21070C9 s21070c24f1[9];
  void *s21070c24f2;
  ::S21070C14 s21070c24f3;
  void *s21070c24f4;
  __tsi64 s21070c24f5;
  void *s21070c24f6[9];
  __tsi64 s21070c24f7;
  void  mf21070c24(); // _ZN9S21070C2410mf21070c24Ev
};
//SIG(-1 S21070C24) C1{ m Fc FU2{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs}[9] Fp FC3{ VBC4{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC5{ VBC4 v5 Fi Fp[8] FL Fi Fl} VBC6{ VBC4 VBC5 Fc FU2 Fi FC7{} Fp FU2 Fi Fi[3]} BC8{ VBC4 BC5 VBC6 vd FL Fi FD} vd v1 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} Fp FL Fp[9] FL}


void  S21070C24 ::mf21070c24(){}

static void Test_S21070C24()
{
  {
    init_simple_test("S21070C24");
    S21070C24 lv;
    check2(sizeof(lv), ABISELECT(2064,1352), "sizeof(S21070C24)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C24)");
    check_field_offset(lv, s21070c24f0, 0, "S21070C24.s21070c24f0");
    check_field_offset(lv, s21070c24f1, ABISELECT(16,4), "S21070C24.s21070c24f1");
    check_field_offset(lv, s21070c24f2, ABISELECT(736,544), "S21070C24.s21070c24f2");
    check_field_offset(lv, s21070c24f3, ABISELECT(752,548), "S21070C24.s21070c24f3");
    check_field_offset(lv, s21070c24f4, ABISELECT(1968,1296), "S21070C24.s21070c24f4");
    check_field_offset(lv, s21070c24f5, ABISELECT(1976,1300), "S21070C24.s21070c24f5");
    check_field_offset(lv, s21070c24f6, ABISELECT(1984,1308), "S21070C24.s21070c24f6");
    check_field_offset(lv, s21070c24f7, ABISELECT(2056,1344), "S21070C24.s21070c24f7");
  }
}
static Arrange_To_Call_Me vS21070C24(Test_S21070C24, "S21070C24", ABISELECT(2064,1352));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S21070C24[];
VTBL_ENTRY *P__ZTI9S21070C24 = _ZTI9S21070C24; 
Class_Descriptor cd_S21070C24 = {  "S21070C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(2064,1352), // object size
  NSPAIRA(_ZTI9S21070C24),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C23  : virtual S21070C21 {
  void *s21070c23f0;
  __tsi64 s21070c23f1;
  char s21070c23f2;
  ::S21070C22 s21070c23f3;
  ::S21070C14 s21070c23f4;
  void *s21070c23f5[7];
  int s21070c23f6;
  ::S21070C24 s21070c23f7;
  __tsi64 s21070c23f8[8];
  virtual  ~S21070C23(); // _ZN9S21070C23D2Ev
  virtual void  v18(); // _ZN9S21070C233v18Ev
  virtual void  v19(); // _ZN9S21070C233v19Ev
  S21070C23(); // tgen
};
//SIG(-1 S21070C23) C1{ VBC2{ BC3{ v3 v4 v5 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC4{ VBC5{ VBC3 v6 Fi Fp[8] FL Fi Fl} VBC6{ VBC7{ VBC3 VBC5 Fc FU8{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC9{} Fp FU8 Fi Fi[3]} FL Fp Fc Fi Fp[3] FL} VBC10{ VBC5 BC3 BC11{ VBC3 BC5 VBC7 vd FL Fi FD} VBC6 vd v7 v8 v9 Fi Fi FC12{ BC11 BC3 BC7 BC13{ VBC3 VBC7 BC5 BC11 v15 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC5 vd Fs FC9 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC3 FL[9] FC13 Fc FL FC13} vd v10 FL Fp FC3[9] Fc} VBC14{ v11 v12 v13 Fp Fi} vd FL:3 FL} vd v1 v2 Fp FL Fc FC14 FC15{ VBC3 BC5 VBC7 BC11 vd v14 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} Fp[7] Fi FC16{ m Fc FU8[9] Fp FC15 Fp FL Fp[9] FL} FL[8]}


 S21070C23 ::~S21070C23(){ note_dtor("S21070C23", this);}
void  S21070C23 ::v18(){vfunc_called(this, "_ZN9S21070C233v18Ev");}
void  S21070C23 ::v19(){vfunc_called(this, "_ZN9S21070C233v19Ev");}
S21070C23 ::S21070C23(){ note_ctor("S21070C23", this);} // tgen

static void Test_S21070C23()
{
  extern Class_Descriptor cd_S21070C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1046,2654)];
    init_test(&cd_S21070C23, buf);
    S21070C23 *dp, &lv = *(dp=new (buf) S21070C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16720,10612), "sizeof(S21070C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C23)");
    /*is_ambiguous_... S21070C21::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), ABISELECT(3472,2228), "S21070C23");
    /*is_ambiguous_... S21070C23::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(5712,3712), "S21070C23");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(5712,3712), "S21070C23");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(5712,3712), "S21070C23");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(5712,3712), "S21070C23");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(5600,3656), "S21070C23");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(5600,3656), "S21070C23");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(5600,3656), "S21070C23");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(5984,3896), "S21070C23");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(5984,3896), "S21070C23");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(5912,3852), "S21070C23");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(5912,3852), "S21070C23");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(6192,4052), "S21070C23");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(6400,4192), "S21070C23");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(6400,4192), "S21070C23");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(6192,4052), "S21070C23");
    check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(3680,2368), "S21070C23");
    check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(16688,10600), "S21070C23");
    check_base_class_offset(lv, (S21070C21*), ABISELECT(3472,2228), "S21070C23");
    check_field_offset(lv, s21070c23f0, ABISELECT(8,4), "S21070C23.s21070c23f0");
    check_field_offset(lv, s21070c23f1, ABISELECT(16,8), "S21070C23.s21070c23f1");
    check_field_offset(lv, s21070c23f2, ABISELECT(24,16), "S21070C23.s21070c23f2");
    check_field_offset(lv, s21070c23f3, ABISELECT(32,20), "S21070C23.s21070c23f3");
    check_field_offset(lv, s21070c23f4, ABISELECT(64,32), "S21070C23.s21070c23f4");
    check_field_offset(lv, s21070c23f5, ABISELECT(1280,780), "S21070C23.s21070c23f5");
    check_field_offset(lv, s21070c23f6, ABISELECT(1336,808), "S21070C23.s21070c23f6");
    check_field_offset(lv, s21070c23f7, ABISELECT(1344,812), "S21070C23.s21070c23f7");
    check_field_offset(lv, s21070c23f8, ABISELECT(3408,2164), "S21070C23.s21070c23f8");
    test_class_info(&lv, &cd_S21070C23);
    dp->~S21070C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C23(Test_S21070C23, "S21070C23", ABISELECT(16720,10612));

#else // __cplusplus

extern void _ZN9S21070C23C1Ev();
extern void _ZN9S21070C23D2Ev();
Name_Map name_map_S21070C23[] = {
  NSPAIR(_ZN9S21070C23C1Ev),
  NSPAIR(_ZN9S21070C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
static Base_Class bases_S21070C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(3472,2228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(5712,3712), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(5600,3656), //bcp->offset
    41, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(5984,3896), //bcp->offset
    59, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C18,    ABISELECT(5912,3852), //bcp->offset
    54, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(6192,4052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6400,4192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(6400,4192), //bcp->offset
    85, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(6192,4052), //bcp->offset
    63, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(3680,2368), //bcp->offset
    31, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(16688,10600), //bcp->offset
    93, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S21070C21,    ABISELECT(3472,2228), //bcp->offset
    13, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C23[];
extern void _ZN9S21070C23D1Ev();
extern void _ZN9S21070C23D0Ev();
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZThn6192_N9S21070C23D1Ev,_ZThn4052_N9S21070C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev)();
extern void ABISELECT(_ZThn6192_N9S21070C23D0Ev,_ZThn4052_N9S21070C23D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY vtc_S21070C23[] = {
  ABISELECT(16688,10600),
  ABISELECT(6192,4052),
  ABISELECT(5984,3896),
  ABISELECT(5912,3852),
  ABISELECT(5712,3712),
  ABISELECT(5600,3656),
  ABISELECT(3472,2228),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C23D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C23D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
  ABISELECT(208,140),
  ABISELECT(-3472,-2228),
  0,
  0,
  0,
  ABISELECT(13216,8372),
  ABISELECT(2720,1824),
  ABISELECT(2512,1668),
  ABISELECT(2440,1624),
  ABISELECT(2240,1484),
  ABISELECT(2128,1428),
  ABISELECT(-3472,-2228),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev),
  ABISELECT(2512,1684),
  ABISELECT(2304,1528),
  ABISELECT(2232,1484),
  ABISELECT(2032,1344),
  ABISELECT(1920,1288),
  ABISELECT(-3680,-2368),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  0,
  ABISELECT(112,56),
  ABISELECT(-5600,-3656),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-5712,-3712),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-5912,-3852),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-5984,-3896),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-6192,-4052),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-6192,-4052),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-6400,-4192),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev),
  0,
  0,
  0,
  ABISELECT(-16688,-10600),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern VTBL_ENTRY _ZTV9S21070C23[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__9S21070C23[] = {
  ABISELECT(13216,8372),
  ABISELECT(2720,1824),
  ABISELECT(2512,1668),
  ABISELECT(2440,1624),
  ABISELECT(2240,1484),
  ABISELECT(2128,1428),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C23[] = {
  ABISELECT(2512,1684),
  ABISELECT(2304,1528),
  ABISELECT(2232,1484),
  ABISELECT(2032,1344),
  ABISELECT(1920,1288),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1920,-1288),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(-2032,-1344),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C23[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-2232,-1484),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2304,-1528),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn2512_N9S21070C17D1Ev,_ZThn1684_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn2512_N9S21070C17D0Ev,_ZThn1684_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C23[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2512,-1684),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-2512,-1684),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C23[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-2720,-1824),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__9S21070C23[] = {
  ABISELECT(2512,1684),
  ABISELECT(2304,1528),
  ABISELECT(2232,1484),
  ABISELECT(2032,1344),
  ABISELECT(1920,1288),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(-2240,-1484),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__9S21070C23[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-2440,-1624),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2512,-1668),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn2720_N9S21070C21D1Ev,_ZThn1824_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn2720_N9S21070C21D0Ev,_ZThn1824_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__9S21070C23[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-2720,-1824),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-2720,-1824),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__9S21070C23[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-2928,-1964),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(-13216,-8372),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C23[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C23[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(312,196),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(272,184),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(384,240),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C23[] = {
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C23[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C23[] = {
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(800,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C23[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(592,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C23[] = {
  0,
  0,
  0,
  ABISELECT(480,340),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C23[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C23[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(208,156),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C23[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(280,200),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTT_ENTRY vtt_S21070C23[] = {
  {&(_ZTV9S21070C23[9]),  9,101},
  {&(_ZTV9S21070C23[26]),  26,101},
  {&(_ZTV9S21070C23[38]),  38,101},
  {&(_ZTV9S21070C23[45]),  45,101},
  {&(_ZTV9S21070C23[51]),  51,101},
  {&(_ZTV9S21070C23[59]),  59,101},
  {&(_ZTV9S21070C23[63]),  63,101},
  {&(_ZTV9S21070C23[77]),  77,101},
  {&(_ZTV9S21070C23[90]),  90,101},
  {&(_ZTV9S21070C23[98]),  98,101},
  {&(_tg__ZTV9S21070C21__9S21070C23[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C23[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C23[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C23[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C23[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C23[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C23[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C23[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__9S21070C23[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__9S21070C23[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__9S21070C23[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__9S21070C23[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__9S21070C23[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__9S21070C23[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__9S21070C23[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C23[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C23[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C23[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C23[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C23[4]),  4,5},
  {&(_tg__ZTV8S21070C8__9S21070C23[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C23[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C23[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C23[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C23[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C23[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C23[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C23[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C23[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C23[5]),  5,5},
};
extern VTBL_ENTRY _ZTI9S21070C23[];
extern  VTBL_ENTRY _ZTV9S21070C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C23[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N9S21070C21D0Ev,_ZThn1824_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2720_N9S21070C21D1Ev,_ZThn1824_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2512_N9S21070C17D0Ev,_ZThn1684_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2512_N9S21070C17D1Ev,_ZThn1684_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6192_N9S21070C23D0Ev,_ZThn4052_N9S21070C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6192_N9S21070C23D1Ev,_ZThn4052_N9S21070C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C23 = {  "S21070C23", // class name
  bases_S21070C23, 12,
  &(vtc_S21070C23[0]), // expected_vtbl_contents
  &(vtt_S21070C23[0]), // expected_vtt_contents
  ABISELECT(16720,10612), // object size
  NSPAIRA(_ZTI9S21070C23),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S21070C23),101, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C23),47, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C20  : S21070C21 , S21070C5 , S21070C22 , virtual S21070C23 {
  void *s21070c20f0;
  int s21070c20f1;
  __tsi64 s21070c20f2;
  int s21070c20f3;
  char s21070c20f4[8];
  void *s21070c20f5;
  void *s21070c20f6;
  int s21070c20f7;
  __tsi64 s21070c20f8;
  int s21070c20f9;
  int s21070c20f10;
  void *s21070c20f11;
  virtual  ~S21070C20(); // _ZN9S21070C20D2Ev
  virtual void  v20(); // _ZN9S21070C203v20Ev
  virtual void  v21(); // _ZN9S21070C203v21Ev
  S21070C20(); // tgen
};
//SIG(-1 S21070C20) C1{ BC2{ BC3{ v3 v4 v5 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC4{ VBC5{ VBC3 v6 Fi Fp[8] FL Fi Fl} VBC6{ VBC7{ VBC3 VBC5 Fc FU8{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC9{} Fp FU8 Fi Fi[3]} FL Fp Fc Fi Fp[3] FL} VBC10{ VBC5 BC3 BC11{ VBC3 BC5 VBC7 vd FL Fi FD} VBC6 vd v7 v8 v9 Fi Fi FC12{ BC11 BC3 BC7 BC13{ VBC3 VBC7 BC5 BC11 v14 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC5 vd Fs FC9 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC3 FL[9] FC13 Fc FL FC13} vd v10 FL Fp FC3[9] Fc} VBC14{ v11 v12 v13 Fp Fi} vd FL:3 FL} BC12 BC14 VBC15{ VBC2 vd v15 v16 Fp FL Fc FC14 FC16{ VBC3 BC5 VBC7 BC11 vd v17 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} Fp[7] Fi FC17{ m Fc FU8[9] Fp FC16 Fp FL Fp[9] FL} FL[8]} vd v1 v2 Fp Fi FL Fi Fc[8] Fp Fp Fi FL Fi Fi Fp}


 S21070C20 ::~S21070C20(){ note_dtor("S21070C20", this);}
void  S21070C20 ::v20(){vfunc_called(this, "_ZN9S21070C203v20Ev");}
void  S21070C20 ::v21(){vfunc_called(this, "_ZN9S21070C203v21Ev");}
S21070C20 ::S21070C20(){ note_ctor("S21070C20", this);} // tgen

static void Test_S21070C20()
{
  extern Class_Descriptor cd_S21070C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1297,3299)];
    init_test(&cd_S21070C20, buf);
    S21070C20 *dp, &lv = *(dp=new (buf) S21070C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(20736,13192), "sizeof(S21070C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C20)");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), 0, "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(4128,2636), "S21070C20");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*), ABISELECT(4128,2636), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(4016,2580), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(4016,2580), "S21070C20");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(4016,2580), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*), ABISELECT(4016,2580), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(4016,2580), "S21070C20");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(4400,2820), "S21070C20");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(4400,2820), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*), ABISELECT(4400,2820), "S21070C20");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*), ABISELECT(4400,2820), "S21070C20");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(4400,2820), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(4328,2776), "S21070C20");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(4328,2776), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(4328,2776), "S21070C20");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(4608,2976), "S21070C20");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(4816,3116), "S21070C20");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(4816,3116), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(4608,2976), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(4608,2976), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(208,140), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(15104,9524), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(15104,9524), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C21*), 0, "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(2128,1428), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*), ABISELECT(2128,1428), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*), ABISELECT(2272,1508), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*), ABISELECT(2480,1648), "S21070C20");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(2688,1804), "S21070C20");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(2800,1860), "S21070C20");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(2800,1860), "S21070C20");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*), ABISELECT(2688,1804), "S21070C20");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*), ABISELECT(3616,2352), "S21070C20");
    check_base_class_offset(lv, (S21070C5*), ABISELECT(2128,1428), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C22 */ AMB_check_base_class_offset(lv, (S21070C22*), ABISELECT(3904,2508), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), ABISELECT(18608,11764), "S21070C20");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(18816,11904), "S21070C20");
    check_base_class_offset(lv, (S21070C21*)(S21070C23*), ABISELECT(18608,11764), "S21070C20");
    check_base_class_offset(lv, (S21070C23*), ABISELECT(15136,9536), "S21070C20");
    check_field_offset(lv, s21070c20f0, ABISELECT(3928,2520), "S21070C20.s21070c20f0");
    check_field_offset(lv, s21070c20f1, ABISELECT(3936,2524), "S21070C20.s21070c20f1");
    check_field_offset(lv, s21070c20f2, ABISELECT(3944,2528), "S21070C20.s21070c20f2");
    check_field_offset(lv, s21070c20f3, ABISELECT(3952,2536), "S21070C20.s21070c20f3");
    check_field_offset(lv, s21070c20f4, ABISELECT(3956,2540), "S21070C20.s21070c20f4");
    check_field_offset(lv, s21070c20f5, ABISELECT(3968,2548), "S21070C20.s21070c20f5");
    check_field_offset(lv, s21070c20f6, ABISELECT(3976,2552), "S21070C20.s21070c20f6");
    check_field_offset(lv, s21070c20f7, ABISELECT(3984,2556), "S21070C20.s21070c20f7");
    check_field_offset(lv, s21070c20f8, ABISELECT(3992,2560), "S21070C20.s21070c20f8");
    check_field_offset(lv, s21070c20f9, ABISELECT(4000,2568), "S21070C20.s21070c20f9");
    check_field_offset(lv, s21070c20f10, ABISELECT(4004,2572), "S21070C20.s21070c20f10");
    check_field_offset(lv, s21070c20f11, ABISELECT(4008,2576), "S21070C20.s21070c20f11");
    test_class_info(&lv, &cd_S21070C20);
    dp->~S21070C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C20(Test_S21070C20, "S21070C20", ABISELECT(20736,13192));

#else // __cplusplus

extern void _ZN9S21070C20C1Ev();
extern void _ZN9S21070C20D2Ev();
Name_Map name_map_S21070C20[] = {
  NSPAIR(_ZN9S21070C20C1Ev),
  NSPAIR(_ZN9S21070C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C23;
extern VTBL_ENTRY _ZTI9S21070C23[];
extern  VTBL_ENTRY _ZTV9S21070C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C23[];
static Base_Class bases_S21070C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(4128,2636), //bcp->offset
    75, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4016,2580), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(4400,2820), //bcp->offset
    88, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C18,    ABISELECT(4328,2776), //bcp->offset
    83, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(4608,2976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(4816,3116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4816,3116), //bcp->offset
    114, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    76, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(4608,2976), //bcp->offset
    92, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    75, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(208,140), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(15104,9524), //bcp->offset
    122, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S21070C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(2128,1428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2128,1428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(2272,1508), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(2480,1648), //bcp->offset
    40, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    59, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2688,1804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(2800,1860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(2800,1860), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    61, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(2688,1804), //bcp->offset
    44, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    60, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(3616,2352), //bcp->offset
    61, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    62, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(2128,1428), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C22,    ABISELECT(3904,2508), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C4,    ABISELECT(18608,11764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21070C17,    ABISELECT(18816,11904), //bcp->offset
    164, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    65, //bcp->index_in_construction_vtbl_array
    98, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21070C21,    ABISELECT(18608,11764), //bcp->offset
    146, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    64, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S21070C23,    ABISELECT(15136,9536), //bcp->offset
    130, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    63, //bcp->index_in_construction_vtbl_array
    87, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C20[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C20D1Ev();
extern void _ZN9S21070C20D0Ev();
extern void _ZN9S21070C203v20Ev();
extern void _ZN9S21070C203v21Ev();
extern void ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn4608_N9S21070C20D1Ev,_ZThn2976_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn4608_N9S21070C20D0Ev,_ZThn2976_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn15136_N9S21070C20D1Ev,_ZThn9536_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn15136_N9S21070C20D0Ev,_ZThn9536_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn18608_N9S21070C20D1Ev,_ZThn11764_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn18608_N9S21070C20D0Ev,_ZThn11764_N9S21070C20D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY vtc_S21070C20[] = {
  ABISELECT(18608,11764),
  ABISELECT(15136,9536),
  ABISELECT(15104,9524),
  ABISELECT(4608,2976),
  ABISELECT(4400,2820),
  ABISELECT(4328,2776),
  ABISELECT(4128,2636),
  ABISELECT(4016,2580),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v20Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v21Ev,
  ABISELECT(4400,2836),
  ABISELECT(4192,2680),
  ABISELECT(4120,2636),
  ABISELECT(3920,2496),
  ABISELECT(3808,2440),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  ABISELECT(1888,1152),
  ABISELECT(2272,1392),
  ABISELECT(2000,1208),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev),
  ABISELECT(-2272,-1508),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(1536,932),
  ABISELECT(1648,988),
  ABISELECT(-2480,-1648),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  ABISELECT(1328,776),
  ABISELECT(1712,1016),
  ABISELECT(1440,832),
  ABISELECT(-2688,-1804),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev),
  ABISELECT(1216,720),
  ABISELECT(1600,960),
  ABISELECT(1328,776),
  ABISELECT(-2800,-1860),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev),
  ABISELECT(512,284),
  ABISELECT(-3616,-2352),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-3904,-2508),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  0,
  ABISELECT(112,56),
  ABISELECT(-4016,-2580),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-4128,-2636),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-4328,-2776),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-4400,-2820),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-4608,-2976),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-4608,-2976),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-4816,-3116),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev),
  0,
  0,
  0,
  ABISELECT(-15104,-9524),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  0,
  0,
  ABISELECT(-15136,-9536),
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-10736,-6716),
  ABISELECT(-10808,-6760),
  ABISELECT(-11008,-6900),
  ABISELECT(-11120,-6956),
  ABISELECT(3472,2228),
  ABISELECT(-15136,-9536),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
  ABISELECT(208,140),
  ABISELECT(-18608,-11764),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-14208,-8944),
  ABISELECT(-14280,-8988),
  ABISELECT(-14480,-9128),
  ABISELECT(-14592,-9184),
  ABISELECT(-18608,-11764),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev),
  ABISELECT(-14208,-8928),
  ABISELECT(-14416,-9084),
  ABISELECT(-14488,-9128),
  ABISELECT(-14688,-9268),
  ABISELECT(-14800,-9324),
  ABISELECT(-18816,-11904),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern VTBL_ENTRY _ZTV9S21070C20[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__A__9S21070C20[] = {
  ABISELECT(15104,9524),
  ABISELECT(4608,2976),
  ABISELECT(4400,2820),
  ABISELECT(4328,2776),
  ABISELECT(4128,2636),
  ABISELECT(4016,2580),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C20[] = {
  ABISELECT(4400,2836),
  ABISELECT(4192,2680),
  ABISELECT(4120,2636),
  ABISELECT(3920,2496),
  ABISELECT(3808,2440),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-3808,-2440),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-3920,-2496),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-4120,-2636),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-4192,-2680),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn4400_N9S21070C17D1Ev,_ZThn2836_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn4400_N9S21070C17D0Ev,_ZThn2836_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C20[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-4400,-2836),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-4400,-2836),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-4608,-2976),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__A__9S21070C20[] = {
  ABISELECT(4400,2836),
  ABISELECT(4192,2680),
  ABISELECT(4120,2636),
  ABISELECT(3920,2496),
  ABISELECT(3808,2440),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__A__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-4016,-2580),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__A__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-4128,-2636),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__A__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(-4328,-2776),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__A__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-4400,-2820),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn4608_N9S21070C21D1Ev,_ZThn2976_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn4608_N9S21070C21D0Ev,_ZThn2976_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__A__9S21070C20[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-4608,-2976),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(-4608,-2976),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__A__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-4816,-3116),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__A__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-15104,-9524),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C5__9S21070C20[] = {
  ABISELECT(1888,1152),
  ABISELECT(2272,1392),
  ABISELECT(2000,1208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C5__A1__9S21070C20[] = {
  ABISELECT(1888,1152),
  ABISELECT(2272,1392),
  ABISELECT(2000,1208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C5__A2__9S21070C20[] = {
  ABISELECT(2000,1208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A2__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-2000,-1208),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C5__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-2000,-1208),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C5__A1__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2272,-1392),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A1__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1888,-1152),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C20[] = {
  ABISELECT(1536,932),
  ABISELECT(1648,988),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C5__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-1648,-988),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C5__A1__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1536,-932),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__9S21070C20[] = {
  ABISELECT(1328,776),
  ABISELECT(1712,1016),
  ABISELECT(1440,832),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C5__A3__9S21070C20[] = {
  ABISELECT(1440,832),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A3__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-1440,-832),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20[] = {
  ABISELECT(1216,720),
  ABISELECT(1600,960),
  ABISELECT(1328,776),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A4__9S21070C20[] = {
  ABISELECT(1328,776),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A4__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-1328,-776),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A2__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-1328,-776),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A2__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-1600,-960),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A2__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1216,-720),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C5__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-1440,-832),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C5__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-1712,-1016),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C5__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1328,-776),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C5__9S21070C20[] = {
  ABISELECT(1216,720),
  ABISELECT(1600,960),
  ABISELECT(1328,776),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A5__9S21070C20[] = {
  ABISELECT(512,284),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C5__A5__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-512,-284),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C5__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-2000,-1208),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C5__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-2272,-1392),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C5__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(-1888,-1152),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C5__9S21070C20[] = {
  ABISELECT(1536,932),
  ABISELECT(1648,988),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C5__9S21070C20[] = {
  ABISELECT(1328,776),
  ABISELECT(1712,1016),
  ABISELECT(1440,832),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C5__9S21070C20[] = {
  ABISELECT(1216,720),
  ABISELECT(1600,960),
  ABISELECT(1328,776),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C5__9S21070C20[] = {
  ABISELECT(512,284),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C20[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(200,140),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(312,196),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(272,184),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(384,240),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C20[] = {
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C20[] = {
  ABISELECT(-688,-480),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(688,480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(800,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(592,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(480,340),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(208,156),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(280,200),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
extern void _ZN9S21070C23D1Ev();
extern void _ZN9S21070C23D0Ev();
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C23__9S21070C20[] = {
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-10736,-6716),
  ABISELECT(-10808,-6760),
  ABISELECT(-11008,-6900),
  ABISELECT(-11120,-6956),
  ABISELECT(3472,2228),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C23D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C23D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C21__9S21070C23__9S21070C20[] = {
  ABISELECT(208,140),
  ABISELECT(-3472,-2228),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-14208,-8944),
  ABISELECT(-14280,-8988),
  ABISELECT(-14480,-9128),
  ABISELECT(-14592,-9184),
  ABISELECT(-3472,-2228),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev),
};
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C23__9S21070C20[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-14416,-9084),
  ABISELECT(-14488,-9128),
  ABISELECT(-14688,-9268),
  ABISELECT(-14800,-9324),
  ABISELECT(-3680,-2368),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C23__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(11120,6956),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C23__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(11008,6900),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C23__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(10808,6760),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C23__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(10736,6716),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C23__9S21070C20[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(10528,6560),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(10528,6560),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C23__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(10320,6420),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C23__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__A1__9S21070C20[] = {
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-14208,-8944),
  ABISELECT(-14280,-8988),
  ABISELECT(-14480,-9128),
  ABISELECT(-14592,-9184),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__A1__9S21070C20[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-14416,-9084),
  ABISELECT(-14488,-9128),
  ABISELECT(-14688,-9268),
  ABISELECT(-14800,-9324),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__A1__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(14800,9324),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(14688,9268),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__A1__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(14488,9128),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__A1__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(14416,9084),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__A1__9S21070C20[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14208,8928),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(14208,8928),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A1__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__A1__9S21070C20[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-14416,-9084),
  ABISELECT(-14488,-9128),
  ABISELECT(-14688,-9268),
  ABISELECT(-14800,-9324),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__A1__9S21070C20[] = {
  0,
  ABISELECT(112,56),
  ABISELECT(14592,9184),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(14480,9128),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__A1__9S21070C20[] = {
  ABISELECT(-312,-196),
  ABISELECT(-200,-140),
  ABISELECT(72,44),
  ABISELECT(14280,8988),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__A1__9S21070C20[] = {
  ABISELECT(-384,-240),
  ABISELECT(-272,-184),
  ABISELECT(14208,8944),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__A1__9S21070C20[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14000,8788),
  0,
  0,
  0,
  ABISELECT(-280,-200),
  ABISELECT(-208,-156),
  ABISELECT(-480,-340),
  ABISELECT(-592,-396),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__A1__9S21070C20[] = {
  ABISELECT(-800,-536),
  ABISELECT(-416,-296),
  ABISELECT(-688,-480),
  ABISELECT(13792,8648),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__A1__9S21070C20[] = {
  0,
  0,
  0,
  ABISELECT(3504,2240),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
static  VTT_ENTRY vtt_S21070C20[] = {
  {&(_ZTV9S21070C20[10]),  10,174},
  {&(_tg__ZTV9S21070C21__A__9S21070C20[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C20[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C20[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__A__9S21070C20[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__A__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__A__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__A__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__A__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__A__9S21070C20[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__A__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__A__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C5__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C5__A2__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A2__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C5__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C5__A1__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A1__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C5__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C5__A1__9S21070C20[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C5__9S21070C20[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C5__A3__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A3__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A4__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A4__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A2__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A2__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A2__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C5__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C5__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A5__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C5__A5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C5__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C5__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C5__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C5__9S21070C20[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C5__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C5__9S21070C20[3]),  3,4},
  {&(_ZTV9S21070C20[24]),  24,174},
  {&(_ZTV9S21070C20[74]),  74,174},
  {&(_ZTV9S21070C20[80]),  80,174},
  {&(_ZTV9S21070C20[88]),  88,174},
  {&(_ZTV9S21070C20[92]),  92,174},
  {&(_ZTV9S21070C20[106]),  106,174},
  {&(_ZTV9S21070C20[119]),  119,174},
  {&(_ZTV9S21070C20[127]),  127,174},
  {&(_ZTV9S21070C20[32]),  32,174},
  {&(_ZTV9S21070C20[44]),  44,174},
  {&(_ZTV9S21070C20[49]),  49,174},
  {&(_ZTV9S21070C20[58]),  58,174},
  {&(_ZTV9S21070C20[64]),  64,174},
  {&(_ZTV9S21070C20[142]),  142,174},
  {&(_ZTV9S21070C20[159]),  159,174},
  {&(_ZTV9S21070C20[171]),  171,174},
  {&(_tg__ZTV8S21070C7__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C8__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C20[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C20[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A1__9S21070C20[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__9S21070C20[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C20[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C20[5]),  5,5},
  {&(_tg__ZTV9S21070C23__9S21070C20[9]),  9,13},
  {&(_tg__ZTV9S21070C21__9S21070C23__9S21070C20[13]),  13,18},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C23__9S21070C20[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C23__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C23__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C23__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C23__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C23__9S21070C20[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C23__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C23__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C21__A1__9S21070C20[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__A1__9S21070C20[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__A1__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__A1__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__A1__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__A1__9S21070C20[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__A1__9S21070C20[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__A1__9S21070C20[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__A1__9S21070C20[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__A1__9S21070C20[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__A1__9S21070C20[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__A1__9S21070C20[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__A1__9S21070C20[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C20[];
extern  VTBL_ENTRY _ZTV9S21070C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C20[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4608_N9S21070C21D0Ev,_ZThn2976_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4608_N9S21070C21D1Ev,_ZThn2976_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4400_N9S21070C17D0Ev,_ZThn2836_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4400_N9S21070C17D1Ev,_ZThn2836_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18608_N9S21070C20D0Ev,_ZThn11764_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn18608_N9S21070C20D1Ev,_ZThn11764_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15136_N9S21070C20D0Ev,_ZThn9536_N9S21070C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4608_N9S21070C20D0Ev,_ZThn2976_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn15136_N9S21070C20D1Ev,_ZThn9536_N9S21070C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn4608_N9S21070C20D1Ev,_ZThn2976_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C20 = {  "S21070C20", // class name
  bases_S21070C20, 27,
  &(vtc_S21070C20[0]), // expected_vtbl_contents
  &(vtt_S21070C20[0]), // expected_vtt_contents
  ABISELECT(20736,13192), // object size
  NSPAIRA(_ZTI9S21070C20),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21070C20),174, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C20),112, //virtual table table var
  27, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C2  : virtual S21070C3 , S21070C16 , S21070C20 , S21070C8 , S21070C5 {
  void *s21070c2f0;
  __tsi64 s21070c2f1;
  void *s21070c2f2;
  __tsi64 s21070c2f3;
  short s21070c2f4;
  void *s21070c2f5;
  virtual  ~S21070C2(); // _ZN8S21070C2D2Ev
  S21070C2(); // tgen
};
//SIG(-1 S21070C2) C1{ VBC2{ VBC3{ v1 v2 v3 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC4{ BC5{ VBC3 BC6{ VBC3 v4 Fi Fp[8] FL Fi Fl} VBC7{ VBC3 VBC6 Fc FU8{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC9{} Fp FU8 Fi Fi[3]} vd FL Fi FD} BC3 BC7 BC10{ VBC3 VBC7 BC6 BC5 v5 Fi Fp FC6 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC6 vd Fs FC9 Fi FD Fp[8] Fp[10] Fs:3 Fp} VBC11{ VBC10 BC4 BC12{ m FU8} VBC13{ VBC3 BC6 VBC7 BC5 vd v6 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC6 Fi} BC14{ VBC10 Fi:6} v7 FL:49 FC3 FL Fs Fp Fi Fp[10] Fs Fp FC5 Fp FL:5} vd FD Fp FL Fi FL} BC15{ VBC7 BC16{ VBC6 VBC17{ VBC7 FL Fp Fc Fi Fp[3] FL} VBC18{ VBC6 BC3 BC5 VBC17 vd v8 v9 v10 Fi Fi FC4[3] FC3 FL[9] FC10 Fc FL FC10} vd v11 FL Fp FC3[9] Fc} vd v12 Fp[4] Fp Fi} BC19{ BC20{ BC3 BC16 VBC21{ v13 v14 v15 Fp Fi} vd FL:3 FL} BC4 BC21 VBC22{ VBC20 vd v16 v17 Fp FL Fc FC21 FC13 Fp[7] Fi FC23{ m Fc FU8[9] Fp FC13 Fp FL Fp[9] FL} FL[8]} vd v18 v19 Fp Fi FL Fi Fc[8] Fp Fp Fi FL Fi Fi Fp} BC7 BC4 vd Fp FL Fp FL Fs Fp}


 S21070C2 ::~S21070C2(){ note_dtor("S21070C2", this);}
S21070C2 ::S21070C2(){ note_ctor("S21070C2", this);} // tgen

static void Test_S21070C2()
{
  extern Class_Descriptor cd_S21070C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1943,4907)];
    init_test(&cd_S21070C2, buf);
    S21070C2 *dp, &lv = *(dp=new (buf) S21070C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(31072,19624), "sizeof(S21070C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C2)");
    /*is_ambiguous_... S21070C3::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C3*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C20*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*), ABISELECT(9840,6268), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C3*), ABISELECT(8016,5152), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C3*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C16*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*), ABISELECT(10256,6564), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C3*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C16*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(10048,6408), "S21070C2");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(10048,6408), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C3*), ABISELECT(8016,5152), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C3*), ABISELECT(8160,5232), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C3*), ABISELECT(8368,5372), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(8576,5528), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(8688,5584), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(8688,5584), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C3*), ABISELECT(8576,5528), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C3*), ABISELECT(9504,6076), "S21070C2");
    /*is_ambiguous_... S21070C3::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C5*)(S21070C3*), ABISELECT(8016,5152), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(13264,8420), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(13376,8476), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(13376,8476), "S21070C2");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C12*), ABISELECT(13264,8420), "S21070C2");
    check_base_class_offset(lv, (S21070C11*)(S21070C15*)(S21070C12*), ABISELECT(13264,8420), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(10368,6620), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(10368,6620), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C12*), ABISELECT(10512,6700), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(10720,6840), "S21070C2");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(10928,6996), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(11040,7052), "S21070C2");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(11040,7052), "S21070C2");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(10928,6996), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(11856,7544), "S21070C2");
    check_base_class_offset(lv, (S21070C5*)(S21070C12*), ABISELECT(10368,6620), "S21070C2");
    check_base_class_offset(lv, (S21070C13*)(S21070C12*), ABISELECT(12144,7700), "S21070C2");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(14192,8968), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(14304,9024), "S21070C2");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(14304,9024), "S21070C2");
    check_base_class_offset(lv, (S21070C14*)(S21070C12*), ABISELECT(14192,8968), "S21070C2");
    check_base_class_offset(lv, (S21070C15*)(S21070C12*), ABISELECT(12224,7760), "S21070C2");
    check_base_class_offset(lv, (S21070C12*)(S21070C3*), ABISELECT(10368,6620), "S21070C2");
    check_base_class_offset(lv, (S21070C3*), ABISELECT(8016,5152), "S21070C2");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C16*), ABISELECT(14872,9364), "S21070C2");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(14872,9364), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(14872,9364), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(14872,9364), "S21070C2");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(14944,9408), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(15152,9548), "S21070C2");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(15152,9548), "S21070C2");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C16*), ABISELECT(14944,9408), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(14944,9408), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(14944,9408), "S21070C2");
    check_base_class_offset(lv, (S21070C17*)(S21070C16*), 0, "S21070C2");
    check_base_class_offset(lv, (S21070C16*), 0, "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*)(S21070C20*), ABISELECT(1968,1304), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(2176,1444), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*)(S21070C20*), ABISELECT(25440,15956), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(25440,15956), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C21*)(S21070C20*), ABISELECT(1968,1304), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(4096,2732), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(4096,2732), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C20*), ABISELECT(4240,2812), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(4448,2952), "S21070C2");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(4656,3108), "S21070C2");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(4768,3164), "S21070C2");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(4768,3164), "S21070C2");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(4656,3108), "S21070C2");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C20*), ABISELECT(5584,3656), "S21070C2");
    check_base_class_offset(lv, (S21070C5*)(S21070C20*), ABISELECT(4096,2732), "S21070C2");
    /*is_ambiguous_... S21070C20::S21070C22 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C20*), ABISELECT(5872,3812), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), ABISELECT(28944,18196), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(29152,18336), "S21070C2");
    check_base_class_offset(lv, (S21070C21*)(S21070C23*), ABISELECT(28944,18196), "S21070C2");
    check_base_class_offset(lv, (S21070C23*)(S21070C20*), ABISELECT(25472,15968), "S21070C2");
    check_base_class_offset(lv, (S21070C20*), ABISELECT(1968,1304), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*), ABISELECT(5984,3884), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*), ABISELECT(6192,4040), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*), ABISELECT(6192,4040), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*), ABISELECT(6336,4120), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*), ABISELECT(6544,4260), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*), ABISELECT(6752,4416), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(6864,4472), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*), ABISELECT(6864,4472), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C5*), ABISELECT(6752,4416), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*), ABISELECT(7680,4964), "S21070C2");
    /*is_ambiguous_... S21070C2::S21070C5 */ AMB_check_base_class_offset(lv, (S21070C5*), ABISELECT(6192,4040), "S21070C2");
    check_field_offset(lv, s21070c2f0, ABISELECT(7968,5120), "S21070C2.s21070c2f0");
    check_field_offset(lv, s21070c2f1, ABISELECT(7976,5124), "S21070C2.s21070c2f1");
    check_field_offset(lv, s21070c2f2, ABISELECT(7984,5132), "S21070C2.s21070c2f2");
    check_field_offset(lv, s21070c2f3, ABISELECT(7992,5136), "S21070C2.s21070c2f3");
    check_field_offset(lv, s21070c2f4, ABISELECT(8000,5144), "S21070C2.s21070c2f4");
    check_field_offset(lv, s21070c2f5, ABISELECT(8008,5148), "S21070C2.s21070c2f5");
    test_class_info(&lv, &cd_S21070C2);
    dp->~S21070C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C2(Test_S21070C2, "S21070C2", ABISELECT(31072,19624));

#else // __cplusplus

extern void _ZN8S21070C2C1Ev();
extern void _ZN8S21070C2D2Ev();
Name_Map name_map_S21070C2[] = {
  NSPAIR(_ZN8S21070C2C1Ev),
  NSPAIR(_ZN8S21070C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C13;
extern VTBL_ENTRY _ZTI9S21070C13[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C15;
extern VTBL_ENTRY _ZTI9S21070C15[];
extern  VTBL_ENTRY _ZTV9S21070C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C15[];
extern Class_Descriptor cd_S21070C12;
extern VTBL_ENTRY _ZTI9S21070C12[];
extern  VTBL_ENTRY _ZTV9S21070C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C12[];
extern Class_Descriptor cd_S21070C3;
extern VTBL_ENTRY _ZTI8S21070C3[];
extern  VTBL_ENTRY _ZTV8S21070C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C3[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C16;
extern VTBL_ENTRY _ZTI9S21070C16[];
extern  VTBL_ENTRY _ZTV9S21070C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C16[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C23;
extern VTBL_ENTRY _ZTI9S21070C23[];
extern  VTBL_ENTRY _ZTV9S21070C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C23[];
extern Class_Descriptor cd_S21070C20;
extern VTBL_ENTRY _ZTI9S21070C20[];
extern  VTBL_ENTRY _ZTV9S21070C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C20[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
static Base_Class bases_S21070C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(9840,6268), //bcp->offset
    177, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    117, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(8016,5152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    159, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(10256,6564), //bcp->offset
    189, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    119, //bcp->index_in_construction_vtbl_array
    210, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(10048,6408), //bcp->offset
    185, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    118, //bcp->index_in_construction_vtbl_array
    207, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C6,    ABISELECT(8016,5152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    158, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(8160,5232), //bcp->offset
    147, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    120, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(8368,5372), //bcp->offset
    152, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    121, //bcp->index_in_construction_vtbl_array
    164, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(8576,5528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    168, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(8688,5584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    171, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(8688,5584), //bcp->offset
    165, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    123, //bcp->index_in_construction_vtbl_array
    170, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(8576,5528), //bcp->offset
    156, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    122, //bcp->index_in_construction_vtbl_array
    167, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(9504,6076), //bcp->offset
    173, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    124, //bcp->index_in_construction_vtbl_array
    180, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(8016,5152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    157, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(13264,8420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    264, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(13376,8476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    267, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(13376,8476), //bcp->offset
    262, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    127, //bcp->index_in_construction_vtbl_array
    266, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(13264,8420), //bcp->offset
    250, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    126, //bcp->index_in_construction_vtbl_array
    263, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(10368,6620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    215, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(10368,6620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    214, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(10512,6700), //bcp->offset
    212, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    128, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(10720,6840), //bcp->offset
    217, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    129, //bcp->index_in_construction_vtbl_array
    220, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(10928,6996), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    224, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(11040,7052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    227, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(11040,7052), //bcp->offset
    230, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    131, //bcp->index_in_construction_vtbl_array
    226, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(10928,6996), //bcp->offset
    221, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    130, //bcp->index_in_construction_vtbl_array
    223, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(11856,7544), //bcp->offset
    238, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    132, //bcp->index_in_construction_vtbl_array
    236, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(10368,6620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    213, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C13,    ABISELECT(12144,7700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(14192,8968), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    277, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(14304,9024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    280, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(14304,9024), //bcp->offset
    282, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    134, //bcp->index_in_construction_vtbl_array
    279, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(14192,8968), //bcp->offset
    270, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    133, //bcp->index_in_construction_vtbl_array
    276, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S21070C15,    ABISELECT(12224,7760), //bcp->offset
    242, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    135, //bcp->index_in_construction_vtbl_array
    245, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21070C12,    ABISELECT(10368,6620), //bcp->offset
    194, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    125, //bcp->index_in_construction_vtbl_array
    212, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S21070C3,    ABISELECT(8016,5152), //bcp->offset
    130, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    116, //bcp->index_in_construction_vtbl_array
    156, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C18,    ABISELECT(14872,9364), //bcp->offset
    290, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    136, //bcp->index_in_construction_vtbl_array
    289, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    39, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(14944,9408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(15152,9548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    295, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(15152,9548), //bcp->offset
    317, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    138, //bcp->index_in_construction_vtbl_array
    294, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(14944,9408), //bcp->offset
    295, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    137, //bcp->index_in_construction_vtbl_array
    293, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S21070C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S21070C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C4,    ABISELECT(1968,1304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S21070C17,    ABISELECT(2176,1444), //bcp->offset
    35, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    140, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(25440,15956), //bcp->offset
    325, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    141, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S21070C21,    ABISELECT(1968,1304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(4096,2732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4096,2732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(4240,2812), //bcp->offset
    53, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(4448,2952), //bcp->offset
    58, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    143, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(4656,3108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    54, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(4768,3164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    55, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4768,3164), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    145, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    56, //init_seq
    53, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(4656,3108), //bcp->offset
    62, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    144, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    57, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5584,3656), //bcp->offset
    79, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    146, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    58, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(4096,2732), //bcp->offset
    45, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    142, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    59, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(5872,3812), //bcp->offset
    83, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    60, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(28944,18196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S21070C17,    ABISELECT(29152,18336), //bcp->offset
    367, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    149, //bcp->index_in_construction_vtbl_array
    316, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    59, //immediately_derived
  0, 0},
  {&cd_S21070C21,    ABISELECT(28944,18196), //bcp->offset
    349, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    148, //bcp->index_in_construction_vtbl_array
    315, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    60, //immediately_derived
  0, 1},
  {&cd_S21070C23,    ABISELECT(25472,15968), //bcp->offset
    333, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    147, //bcp->index_in_construction_vtbl_array
    305, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    61, //immediately_derived
  0, 1},
  {&cd_S21070C20,    ABISELECT(1968,1304), //bcp->offset
    18, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    139, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    61, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C8,    ABISELECT(5984,3884), //bcp->offset
    88, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    150, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    62, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C7,    ABISELECT(6192,4040), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    63, //init_seq
    64, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(6192,4040), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    85, //bcp->base_subarray_index_in_construction_vtbl_array
    64, //init_seq
    72, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(6336,4120), //bcp->offset
    100, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    65, //init_seq
    72, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(6544,4260), //bcp->offset
    105, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    152, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    66, //init_seq
    72, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6752,4416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    95, //bcp->base_subarray_index_in_construction_vtbl_array
    67, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6864,4472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    98, //bcp->base_subarray_index_in_construction_vtbl_array
    68, //init_seq
    69, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(6864,4472), //bcp->offset
    118, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    154, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    69, //init_seq
    70, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(6752,4416), //bcp->offset
    109, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    153, //bcp->index_in_construction_vtbl_array
    94, //bcp->base_subarray_index_in_construction_vtbl_array
    70, //init_seq
    72, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(7680,4964), //bcp->offset
    126, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    155, //bcp->index_in_construction_vtbl_array
    107, //bcp->base_subarray_index_in_construction_vtbl_array
    71, //init_seq
    72, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(6192,4040), //bcp->offset
    92, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    151, //bcp->index_in_construction_vtbl_array
    84, //bcp->base_subarray_index_in_construction_vtbl_array
    72, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21070C2[];
extern void _ZN8S21070C2D1Ev();
extern void _ZN8S21070C2D0Ev();
extern void _ZN9S21070C173v13Ev();
extern void _ZN9S21070C163v14Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZThn1968_N8S21070C2D1Ev,_ZThn1304_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn1968_N8S21070C2D0Ev,_ZThn1304_N8S21070C2D0Ev)();
extern void _ZN9S21070C203v20Ev();
extern void _ZN9S21070C203v21Ev();
extern void ABISELECT(_ZThn2176_N8S21070C2D1Ev,_ZThn1444_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn2176_N8S21070C2D0Ev,_ZThn1444_N8S21070C2D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn4096_N8S21070C2D1Ev,_ZThn2732_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn4096_N8S21070C2D0Ev,_ZThn2732_N8S21070C2D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn4656_N8S21070C2D1Ev,_ZThn3108_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn4656_N8S21070C2D0Ev,_ZThn3108_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn4768_N8S21070C2D1Ev,_ZThn3164_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn4768_N8S21070C2D0Ev,_ZThn3164_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn6192_N8S21070C2D1Ev,_ZThn4040_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn6192_N8S21070C2D0Ev,_ZThn4040_N8S21070C2D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn6752_N8S21070C2D1Ev,_ZThn4416_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn6752_N8S21070C2D0Ev,_ZThn4416_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn6864_N8S21070C2D1Ev,_ZThn4472_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn6864_N8S21070C2D0Ev,_ZThn4472_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn8016_N8S21070C2D1Ev,_ZThn5152_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn8016_N8S21070C2D0Ev,_ZThn5152_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTvn560_n80_N8S21070C2D1Ev,_ZTvn376_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn560_n80_N8S21070C2D0Ev,_ZTvn376_n40_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn672_n80_N8S21070C2D1Ev,_ZTvn432_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn672_n80_N8S21070C2D0Ev,_ZTvn432_n40_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n72_N8S21070C2D1Ev,_ZTv0_n36_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn10368_N8S21070C2D1Ev,_ZThn6620_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S21070C2D0Ev,_ZTv0_n36_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn10368_N8S21070C2D0Ev,_ZThn6620_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN9S21070C122v9Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTvn560_n72_N8S21070C2D1Ev,_ZTvn376_n36_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn560_n72_N8S21070C2D0Ev,_ZTvn376_n36_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn672_n72_N8S21070C2D1Ev,_ZTvn432_n36_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn672_n72_N8S21070C2D0Ev,_ZTvn432_n36_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn1856_n72_N8S21070C2D1Ev,_ZTvn1140_n36_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn1856_n72_N8S21070C2D0Ev,_ZTvn1140_n36_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N8S21070C2D1Ev,_ZTv0_n32_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn13264_N8S21070C2D1Ev,_ZThn8420_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S21070C2D0Ev,_ZTv0_n32_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn13264_N8S21070C2D0Ev,_ZThn8420_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N8S21070C2D1Ev,_ZTvn56_n32_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N8S21070C2D0Ev,_ZTvn56_n32_N8S21070C2D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N8S21070C2D1Ev,_ZTv0_n28_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn14192_N8S21070C2D1Ev,_ZThn8968_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S21070C2D0Ev,_ZTv0_n28_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn14192_N8S21070C2D0Ev,_ZThn8968_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N8S21070C2D1Ev,_ZTvn56_n28_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N8S21070C2D0Ev,_ZTvn56_n28_N8S21070C2D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn14944_N8S21070C2D1Ev,_ZThn9408_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn14944_N8S21070C2D0Ev,_ZThn9408_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N8S21070C2D1Ev,_ZTvn140_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N8S21070C2D0Ev,_ZTvn140_n40_N8S21070C2D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn25472_N8S21070C2D1Ev,_ZThn15968_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn25472_N8S21070C2D0Ev,_ZThn15968_N8S21070C2D0Ev)() __attribute__((weak));
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N8S21070C2D1Ev,_ZTv0_n48_N8S21070C2D1Ev)();
extern void ABISELECT(_ZThn28944_N8S21070C2D1Ev,_ZThn18196_N8S21070C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S21070C2D0Ev,_ZTv0_n48_N8S21070C2D0Ev)();
extern void ABISELECT(_ZThn28944_N8S21070C2D0Ev,_ZThn18196_N8S21070C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn208_n96_N8S21070C2D1Ev,_ZTvn140_n48_N8S21070C2D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N8S21070C2D0Ev,_ZTvn140_n48_N8S21070C2D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY vtc_S21070C2[] = {
  ABISELECT(28944,18196),
  ABISELECT(25472,15968),
  ABISELECT(25440,15956),
  ABISELECT(14192,8968),
  ABISELECT(13264,8420),
  ABISELECT(10368,6620),
  ABISELECT(8016,5152),
  ABISELECT(14944,9408),
  ABISELECT(10048,6408),
  ABISELECT(14872,9364),
  ABISELECT(9840,6268),
  ABISELECT(10256,6564),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C2D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C2D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  (VTBL_ENTRY)&_ZN9S21070C163v14Ev,
  ABISELECT(26976,16892),
  ABISELECT(23504,14664),
  ABISELECT(23472,14652),
  ABISELECT(12976,8104),
  ABISELECT(8080,5104),
  ABISELECT(12904,8060),
  ABISELECT(7872,4964),
  ABISELECT(8288,5260),
  ABISELECT(-1968,-1304),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1968_N8S21070C2D1Ev,_ZThn1304_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1968_N8S21070C2D0Ev,_ZThn1304_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C203v20Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v21Ev,
  ABISELECT(12768,7964),
  ABISELECT(7872,4964),
  ABISELECT(12696,7920),
  ABISELECT(7664,4824),
  ABISELECT(8080,5120),
  ABISELECT(-2176,-1444),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S21070C2D1Ev,_ZThn1444_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2176_N8S21070C2D0Ev,_ZThn1444_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  ABISELECT(6160,3832),
  ABISELECT(5952,3676),
  ABISELECT(5744,3536),
  ABISELECT(-4096,-2732),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4096_N8S21070C2D1Ev,_ZThn2732_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4096_N8S21070C2D0Ev,_ZThn2732_N8S21070C2D0Ev),
  ABISELECT(-4240,-2812),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(5808,3612),
  ABISELECT(5392,3316),
  ABISELECT(-4448,-2952),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(5600,3456),
  ABISELECT(5392,3300),
  ABISELECT(5184,3160),
  ABISELECT(-4656,-3108),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4656_N8S21070C2D1Ev,_ZThn3108_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4656_N8S21070C2D0Ev,_ZThn3108_N8S21070C2D0Ev),
  ABISELECT(5488,3400),
  ABISELECT(5280,3244),
  ABISELECT(5072,3104),
  ABISELECT(-4768,-3164),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn4768_N8S21070C2D1Ev,_ZThn3164_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4768_N8S21070C2D0Ev,_ZThn3164_N8S21070C2D0Ev),
  ABISELECT(4256,2612),
  ABISELECT(-5584,-3656),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-5872,-3812),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  ABISELECT(4272,2680),
  ABISELECT(3856,2384),
  ABISELECT(-5984,-3884),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(4064,2524),
  ABISELECT(3856,2368),
  ABISELECT(3648,2228),
  ABISELECT(-6192,-4040),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn6192_N8S21070C2D1Ev,_ZThn4040_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6192_N8S21070C2D0Ev,_ZThn4040_N8S21070C2D0Ev),
  ABISELECT(-6336,-4120),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(3712,2304),
  ABISELECT(3296,2008),
  ABISELECT(-6544,-4260),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(3504,2148),
  ABISELECT(3296,1992),
  ABISELECT(3088,1852),
  ABISELECT(-6752,-4416),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn6752_N8S21070C2D1Ev,_ZThn4416_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6752_N8S21070C2D0Ev,_ZThn4416_N8S21070C2D0Ev),
  ABISELECT(3392,2092),
  ABISELECT(3184,1936),
  ABISELECT(2976,1796),
  ABISELECT(-6864,-4472),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn6864_N8S21070C2D1Ev,_ZThn4472_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn6864_N8S21070C2D0Ev,_ZThn4472_N8S21070C2D0Ev),
  ABISELECT(2160,1304),
  ABISELECT(-7680,-4964),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(560,376),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(-8016,-5152),
  0,
  ABISELECT(6176,3816),
  ABISELECT(5248,3268),
  ABISELECT(2352,1468),
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  ABISELECT(-8016,-5152),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev),
  ABISELECT(-8160,-5232),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  ABISELECT(-8368,-5372),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  ABISELECT(-8576,-5528),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n80_N8S21070C2D1Ev,_ZTvn376_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n80_N8S21070C2D0Ev,_ZTvn376_n40_N8S21070C2D0Ev),
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-8688,-5584),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n80_N8S21070C2D1Ev,_ZTvn432_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n80_N8S21070C2D0Ev,_ZTvn432_n40_N8S21070C2D0Ev),
  ABISELECT(336,192),
  ABISELECT(-9504,-6076),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  0,
  0,
  ABISELECT(-9840,-6268),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-10048,-6408),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-10256,-6564),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  ABISELECT(560,376),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(-10368,-6620),
  0,
  ABISELECT(3824,2348),
  ABISELECT(2896,1800),
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-10368,-6620),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C2D1Ev,_ZTv0_n36_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C2D0Ev,_ZTv0_n36_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
  ABISELECT(-10512,-6700),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-10720,-6840),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-10928,-6996),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C2D1Ev,_ZTvn376_n36_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C2D0Ev,_ZTvn376_n36_N8S21070C2D0Ev),
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-11040,-7052),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C2D1Ev,_ZTvn432_n36_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C2D0Ev,_ZTvn432_n36_N8S21070C2D0Ev),
  ABISELECT(-2016,-1276),
  ABISELECT(-11856,-7544),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  ABISELECT(-12224,-7760),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C2D1Ev,_ZTvn1140_n36_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C2D0Ev,_ZTvn1140_n36_N8S21070C2D0Ev),
  ABISELECT(-13264,-8420),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-13264,-8420),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C2D1Ev,_ZTv0_n32_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C2D0Ev,_ZTv0_n32_N8S21070C2D0Ev),
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-13376,-8476),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C2D1Ev,_ZTvn56_n32_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C2D0Ev,_ZTvn56_n32_N8S21070C2D0Ev),
  0,
  ABISELECT(-14192,-8968),
  0,
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  ABISELECT(-14192,-8968),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C2D1Ev,_ZTv0_n28_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C2D0Ev,_ZTv0_n28_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-14304,-9024),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C2D1Ev,_ZTvn56_n28_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C2D0Ev,_ZTvn56_n28_N8S21070C2D0Ev),
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-14872,-9364),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-14944,-9408),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-14944,-9408),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-15152,-9548),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N8S21070C2D1Ev,_ZTvn140_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N8S21070C2D0Ev,_ZTvn140_n40_N8S21070C2D0Ev),
  0,
  0,
  0,
  ABISELECT(-25440,-15956),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  0,
  0,
  ABISELECT(-25472,-15968),
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-15424,-9560),
  ABISELECT(-10600,-6604),
  ABISELECT(-15632,-9700),
  ABISELECT(-15216,-9404),
  ABISELECT(3472,2228),
  ABISELECT(-25472,-15968),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
  ABISELECT(208,140),
  ABISELECT(-28944,-18196),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-18896,-11788),
  ABISELECT(-14072,-8832),
  ABISELECT(-19104,-11928),
  ABISELECT(-18688,-11632),
  ABISELECT(-28944,-18196),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S21070C2D1Ev,_ZTv0_n48_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S21070C2D0Ev,_ZTv0_n48_N8S21070C2D0Ev),
  ABISELECT(-14208,-8928),
  ABISELECT(-19104,-11928),
  ABISELECT(-14280,-8972),
  ABISELECT(-19312,-12068),
  ABISELECT(-18896,-11772),
  ABISELECT(-29152,-18336),
  (VTBL_ENTRY)&(_ZTI8S21070C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N8S21070C2D1Ev,_ZTvn140_n48_N8S21070C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N8S21070C2D0Ev,_ZTvn140_n48_N8S21070C2D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern VTBL_ENTRY _ZTV8S21070C2[];
extern void _ZN9S21070C16D1Ev();
extern void _ZN9S21070C16D0Ev();
extern void _ZN9S21070C173v13Ev();
extern void _ZN9S21070C163v14Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C16__8S21070C2[] = {
  ABISELECT(14944,9408),
  ABISELECT(10048,6408),
  ABISELECT(14872,9364),
  ABISELECT(9840,6268),
  ABISELECT(10256,6564),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN9S21070C16D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C16D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  (VTBL_ENTRY)&_ZN9S21070C163v14Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C16__8S21070C2[] = {
  ABISELECT(14944,9408),
  ABISELECT(10048,6408),
  ABISELECT(14872,9364),
  ABISELECT(9840,6268),
  ABISELECT(10256,6564),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C16__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-10256,-6564),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C16__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-9840,-6268),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C16__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-14872,-9364),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C16__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-10048,-6408),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn14944_N9S21070C17D1Ev,_ZThn9408_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn14944_N9S21070C17D0Ev,_ZThn9408_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C16__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-14944,-9408),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-14944,-9408),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C16__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-15152,-9548),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C16__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-10048,-6408),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C16__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-9840,-6268),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C16__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-10256,-6564),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C16__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-14872,-9364),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev)();
extern void ABISELECT(_ZThn14944_N9S21070C16D1Ev,_ZThn9408_N9S21070C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev)();
extern void ABISELECT(_ZThn14944_N9S21070C16D0Ev,_ZThn9408_N9S21070C16D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C16__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-14944,-9408),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-14944,-9408),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C16D1Ev,_ZTvn140_n40_N9S21070C16D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C16D0Ev,_ZTvn140_n40_N9S21070C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C16__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-15152,-9548),
  (VTBL_ENTRY)&(_ZTI9S21070C16[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C16D1Ev,_ZTvn140_n40_N9S21070C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C16D0Ev,_ZTvn140_n40_N9S21070C16D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C20D1Ev();
extern void _ZN9S21070C20D0Ev();
extern void _ZN9S21070C203v20Ev();
extern void _ZN9S21070C203v21Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C20__8S21070C2[] = {
  ABISELECT(26976,16892),
  ABISELECT(23504,14664),
  ABISELECT(23472,14652),
  ABISELECT(12976,8104),
  ABISELECT(8080,5104),
  ABISELECT(12904,8060),
  ABISELECT(7872,4964),
  ABISELECT(8288,5260),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v20Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v21Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(23472,14652),
  ABISELECT(12976,8104),
  ABISELECT(8080,5104),
  ABISELECT(12904,8060),
  ABISELECT(7872,4964),
  ABISELECT(8288,5260),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  ABISELECT(12768,7964),
  ABISELECT(7872,4964),
  ABISELECT(12696,7920),
  ABISELECT(7664,4824),
  ABISELECT(8080,5120),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8080,-5120),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-7664,-4824),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-12696,-7920),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-7872,-4964),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn12768_N9S21070C17D1Ev,_ZThn7964_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn12768_N9S21070C17D0Ev,_ZThn7964_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-12768,-7964),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-12768,-7964),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C219S21070C20__A1__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-12976,-8104),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(12768,7964),
  ABISELECT(7872,4964),
  ABISELECT(12696,7920),
  ABISELECT(7664,4824),
  ABISELECT(8080,5120),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C219S21070C20__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8288,-5260),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C219S21070C20__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-7872,-4964),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-12904,-8060),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8080,-5104),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn12976_N9S21070C21D1Ev,_ZThn8104_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn12976_N9S21070C21D0Ev,_ZThn8104_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-12976,-8104),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-12976,-8104),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C219S21070C20__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-13184,-8244),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C219S21070C20__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-23472,-14652),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(6160,3832),
  ABISELECT(5952,3676),
  ABISELECT(5744,3536),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C59S21070C20__A7__8S21070C2[] = {
  ABISELECT(6160,3832),
  ABISELECT(5952,3676),
  ABISELECT(5744,3536),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C59S21070C20__A14__8S21070C2[] = {
  ABISELECT(5744,3536),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C20__A14__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5744,-3536),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C59S21070C20__A7__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5744,-3536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C59S21070C20__A7__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5952,-3676),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C20__A7__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-6160,-3832),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C20__A3__8S21070C2[] = {
  ABISELECT(5808,3612),
  ABISELECT(5392,3316),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C59S21070C20__A3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5392,-3316),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C59S21070C20__A3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5808,-3612),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C20__A3__8S21070C2[] = {
  ABISELECT(5600,3456),
  ABISELECT(5392,3300),
  ABISELECT(5184,3160),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C59S21070C20__A15__8S21070C2[] = {
  ABISELECT(5184,3160),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C20__A15__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5184,-3160),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[] = {
  ABISELECT(5488,3400),
  ABISELECT(5280,3244),
  ABISELECT(5072,3104),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C20__A16__8S21070C2[] = {
  ABISELECT(5072,3104),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C20__A16__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5072,-3104),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5072,-3104),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5280,-3244),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5488,-3400),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C59S21070C20__A3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5184,-3160),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C59S21070C20__A3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5392,-3300),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C59S21070C20__A3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5600,-3456),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C59S21070C20__A3__8S21070C2[] = {
  ABISELECT(5488,3400),
  ABISELECT(5280,3244),
  ABISELECT(5072,3104),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C20__A17__8S21070C2[] = {
  ABISELECT(4256,2612),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C59S21070C20__A17__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-4256,-2612),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C59S21070C20__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-5744,-3536),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5952,-3676),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C59S21070C20__A2__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-6160,-3832),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(5808,3612),
  ABISELECT(5392,3316),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(5600,3456),
  ABISELECT(5392,3300),
  ABISELECT(5184,3160),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(5488,3400),
  ABISELECT(5280,3244),
  ABISELECT(5072,3104),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C59S21070C20__A2__8S21070C2[] = {
  ABISELECT(4256,2612),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C20__8S21070C2[] = {
  ABISELECT(12768,7964),
  ABISELECT(7872,4964),
  ABISELECT(12696,7920),
  ABISELECT(7664,4824),
  ABISELECT(8080,5120),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C20__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8288,-5260),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C20__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-7872,-4964),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C20__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(-12904,-8060),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C20__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8080,-5104),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn12976_N9S21070C20D1Ev,_ZThn8104_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn12976_N9S21070C20D0Ev,_ZThn8104_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C20__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-12976,-8104),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(-12976,-8104),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C20__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-13184,-8244),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C20__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-23472,-14652),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C5__9S21070C20__8S21070C2[] = {
  ABISELECT(6160,3832),
  ABISELECT(5952,3676),
  ABISELECT(5744,3536),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C20__8S21070C2[] = {
  ABISELECT(5808,3612),
  ABISELECT(5392,3316),
  ABISELECT(-2480,-1648),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__9S21070C20__8S21070C2[] = {
  ABISELECT(5600,3456),
  ABISELECT(5392,3300),
  ABISELECT(5184,3160),
  ABISELECT(-2688,-1804),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20__8S21070C2[] = {
  ABISELECT(5488,3400),
  ABISELECT(5280,3244),
  ABISELECT(5072,3104),
  ABISELECT(-2800,-1860),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A5__9S21070C20__8S21070C2[] = {
  ABISELECT(4256,2612),
  ABISELECT(-3616,-2352),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn23504_N9S21070C20D1Ev,_ZThn14664_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn23504_N9S21070C20D0Ev,_ZThn14664_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C23__9S21070C20__8S21070C2[] = {
  0,
  0,
  ABISELECT(-23504,-14664),
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-15424,-9560),
  ABISELECT(-10600,-6604),
  ABISELECT(-15632,-9700),
  ABISELECT(-15216,-9404),
  ABISELECT(3472,2228),
  ABISELECT(-23504,-14664),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn26976_N9S21070C20D1Ev,_ZThn16892_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn26976_N9S21070C20D0Ev,_ZThn16892_N9S21070C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C21__A1__9S21070C20__8S21070C2[] = {
  ABISELECT(208,140),
  ABISELECT(-26976,-16892),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-18896,-11788),
  ABISELECT(-14072,-8832),
  ABISELECT(-19104,-11928),
  ABISELECT(-18688,-11632),
  ABISELECT(-26976,-16892),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev),
};
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__A1__9S21070C20__8S21070C2[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-19104,-11928),
  ABISELECT(-14280,-8972),
  ABISELECT(-19312,-12068),
  ABISELECT(-18896,-11772),
  ABISELECT(-27184,-17032),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C2[] = {
  ABISELECT(4272,2680),
  ABISELECT(3856,2384),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__A__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3856,-2384),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__A__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4272,-2680),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C5__A3__8S21070C2[] = {
  ABISELECT(4064,2524),
  ABISELECT(3856,2368),
  ABISELECT(3648,2228),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C5__A9__8S21070C2[] = {
  ABISELECT(4064,2524),
  ABISELECT(3856,2368),
  ABISELECT(3648,2228),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C5__A18__8S21070C2[] = {
  ABISELECT(3648,2228),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A18__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3648,-2228),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C5__A9__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3648,-2228),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C5__A9__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3856,-2368),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A9__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4064,-2524),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A5__8S21070C2[] = {
  ABISELECT(3712,2304),
  ABISELECT(3296,2008),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C5__A5__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3296,-2008),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C5__A5__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3712,-2304),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__A4__8S21070C2[] = {
  ABISELECT(3504,2148),
  ABISELECT(3296,1992),
  ABISELECT(3088,1852),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C5__A19__8S21070C2[] = {
  ABISELECT(3088,1852),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A19__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3088,-1852),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A10__8S21070C2[] = {
  ABISELECT(3392,2092),
  ABISELECT(3184,1936),
  ABISELECT(2976,1796),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A20__8S21070C2[] = {
  ABISELECT(2976,1796),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A20__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-1796),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A10__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-1796),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A10__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3184,-1936),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A10__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3392,-2092),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C5__A4__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3088,-1852),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C5__A4__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3296,-1992),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C5__A4__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3504,-2148),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C5__A4__8S21070C2[] = {
  ABISELECT(3392,2092),
  ABISELECT(3184,1936),
  ABISELECT(2976,1796),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A21__8S21070C2[] = {
  ABISELECT(2160,1304),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C5__A21__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-2160,-1304),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C5__A3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-3648,-2228),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C5__A3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3856,-2368),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C5__A3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-4064,-2524),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C5__A3__8S21070C2[] = {
  ABISELECT(3712,2304),
  ABISELECT(3296,2008),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C5__A3__8S21070C2[] = {
  ABISELECT(3504,2148),
  ABISELECT(3296,1992),
  ABISELECT(3088,1852),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C5__A3__8S21070C2[] = {
  ABISELECT(3392,2092),
  ABISELECT(3184,1936),
  ABISELECT(2976,1796),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C5__A3__8S21070C2[] = {
  ABISELECT(2160,1304),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C3D1Ev();
extern void _ZN8S21070C3D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C3__8S21070C2[] = {
  ABISELECT(6176,3816),
  ABISELECT(5248,3268),
  ABISELECT(2352,1468),
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C3D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C3D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(2240,1412),
  ABISELECT(2032,1256),
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1824,1116),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C58S21070C3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C58S21070C3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C58S21070C3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C58S21070C3__A1__8S21070C2[] = {
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C58S21070C3__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1472,-896),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C58S21070C3__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1888,-1192),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C58S21070C3__A2__8S21070C2[] = {
  ABISELECT(1264,740),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C58S21070C3__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-740),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C58S21070C3__A3__8S21070C2[] = {
  ABISELECT(1152,684),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C58S21070C3__A3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1152,-684),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1152,-684),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1360,-824),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1568,-980),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C58S21070C3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1264,-740),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1472,-880),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C58S21070C3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1680,-1036),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C58S21070C3__A4__8S21070C2[] = {
  ABISELECT(336,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C58S21070C3__A4__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-336,-192),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C58S21070C3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C58S21070C3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C58S21070C3__8S21070C2[] = {
  ABISELECT(336,192),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(-1824,-1116),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2032,-1256),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2240,-1412),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__8S21070C3__8S21070C2[] = {
  ABISELECT(1888,1192),
  ABISELECT(1472,896),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C3D1Ev,_ZThn376_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C3D0Ev,_ZThn376_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__8S21070C3__8S21070C2[] = {
  ABISELECT(1680,1036),
  ABISELECT(1472,880),
  ABISELECT(1264,740),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C3D1Ev,_ZThn376_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C3D0Ev,_ZThn376_N8S21070C3D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C3D1Ev,_ZThn432_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C3D0Ev,_ZThn432_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A1__8S21070C3__8S21070C2[] = {
  ABISELECT(1568,980),
  ABISELECT(1360,824),
  ABISELECT(1152,684),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C3D1Ev,_ZThn432_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C3D0Ev,_ZThn432_N8S21070C3D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A4__8S21070C3__8S21070C2[] = {
  ABISELECT(336,192),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn2352_N8S21070C3D1Ev,_ZThn1468_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn2352_N8S21070C3D0Ev,_ZThn1468_N8S21070C3D0Ev)() __attribute__((weak));
extern void _ZN9S21070C122v9Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C12__8S21070C3__8S21070C2[] = {
  0,
  ABISELECT(560,376),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(144,80),
  ABISELECT(-2352,-1468),
  0,
  ABISELECT(3824,2348),
  ABISELECT(2896,1800),
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-2352,-1468),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn5248_N8S21070C3D1Ev,_ZThn3268_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn5248_N8S21070C3D0Ev,_ZThn3268_N8S21070C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__A1__8S21070C3__8S21070C2[] = {
  ABISELECT(-5248,-3268),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-5248,-3268),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N8S21070C3D1Ev,_ZTvn56_n32_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N8S21070C3D0Ev,_ZTvn56_n32_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A2__8S21070C3__8S21070C2[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-5360,-3324),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C3D1Ev,_ZTvn56_n32_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N8S21070C3D0Ev,_ZTvn56_n32_N8S21070C3D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C48S21070C59S21070C12__A2__8S21070C3__8S21070C2[] = {
  ABISELECT(-2496,-1548),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C3__8S21070C2[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-2704,-1688),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTvn560_n72_N8S21070C3D1Ev,_ZTvn376_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn560_n72_N8S21070C3D0Ev,_ZTvn376_n36_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C3__8S21070C2[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-2912,-1844),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C3D1Ev,_ZTvn376_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn560_n72_N8S21070C3D0Ev,_ZTvn376_n36_N8S21070C3D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn672_n72_N8S21070C3D1Ev,_ZTvn432_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn672_n72_N8S21070C3D0Ev,_ZTvn432_n36_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3__8S21070C2[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-3024,-1900),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C3D1Ev,_ZTvn432_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn672_n72_N8S21070C3D0Ev,_ZTvn432_n36_N8S21070C3D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C3__8S21070C2[] = {
  ABISELECT(-2016,-1276),
  ABISELECT(-3840,-2392),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev)();
extern void ABISELECT(_ZThn6176_N8S21070C3D1Ev,_ZThn3816_N8S21070C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev)();
extern void ABISELECT(_ZThn6176_N8S21070C3D0Ev,_ZThn3816_N8S21070C3D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__8S21070C3__8S21070C2[] = {
  0,
  ABISELECT(-6176,-3816),
  0,
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  ABISELECT(-6176,-3816),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N8S21070C3D1Ev,_ZTvn56_n28_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N8S21070C3D0Ev,_ZTvn56_n28_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A5__8S21070C3__8S21070C2[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-6288,-3872),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C3D1Ev,_ZTvn56_n28_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N8S21070C3D0Ev,_ZTvn56_n28_N8S21070C3D0Ev),
};
extern void ABISELECT(_ZTvn1856_n72_N8S21070C3D1Ev,_ZTvn1140_n36_N8S21070C3D1Ev)();
extern void ABISELECT(_ZTvn1856_n72_N8S21070C3D0Ev,_ZTvn1140_n36_N8S21070C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C159S21070C12__8S21070C3__8S21070C2[] = {
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  ABISELECT(-4208,-2608),
  (VTBL_ENTRY)&(_ZTI8S21070C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C3D1Ev,_ZTvn1140_n36_N8S21070C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1856_n72_N8S21070C3D0Ev,_ZTvn1140_n36_N8S21070C3D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C2[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C12D1Ev();
extern void _ZN9S21070C12D0Ev();
extern void _ZN9S21070C122v9Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C12__8S21070C2[] = {
  ABISELECT(3824,2348),
  ABISELECT(2896,1800),
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C59S21070C12__A3__8S21070C2[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C2[] = {
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A3__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A3__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A3__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C2[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(880,572),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A2__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(464,276),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C2[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C2[] = {
  ABISELECT(-1088,-728),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(1088,728),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C2[] = {
  ABISELECT(-1200,-784),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(1200,784),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(1200,784),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(992,644),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(784,488),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(1088,728),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A2__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(880,588),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A2__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(672,432),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A2__8S21070C2[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C2[] = {
  ABISELECT(-2016,-1276),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A10__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(2016,1276),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C59S21070C12__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C59S21070C12__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C59S21070C12__A1__8S21070C2[] = {
  ABISELECT(-2016,-1276),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN9S21070C15D1Ev();
extern void _ZN9S21070C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C159S21070C12__8S21070C2[] = {
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN9S21070C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C15D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev)();
extern void ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C159S21070C12__8S21070C2[] = {
  ABISELECT(-1040,-660),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-1040,-660),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C159S21070C12__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(2384,1492),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C159S21070C12__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(2176,1352),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C159S21070C12__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(1968,1196),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__8S21070C2[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-1152,-716),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C12__8S21070C2[] = {
  ABISELECT(-2896,-1800),
  0,
  0,
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  ABISELECT(-2896,-1800),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C12__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C12__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C12__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C12__8S21070C2[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-3008,-1856),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C12__8S21070C2[] = {
  ABISELECT(-464,-276),
  ABISELECT(-880,-572),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__A1__9S21070C12__8S21070C2[] = {
  ABISELECT(-672,-432),
  ABISELECT(-880,-588),
  ABISELECT(-1088,-728),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__8S21070C2[] = {
  ABISELECT(-784,-488),
  ABISELECT(-992,-644),
  ABISELECT(-1200,-784),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A6__9S21070C12__8S21070C2[] = {
  ABISELECT(-2016,-1276),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn3824_N9S21070C12D1Ev,_ZThn2348_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn3824_N9S21070C12D0Ev,_ZThn2348_N9S21070C12D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C12__8S21070C2[] = {
  0,
  ABISELECT(-3824,-2348),
  0,
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  ABISELECT(-3824,-2348),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A3__9S21070C12__8S21070C2[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-3936,-2404),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev),
};
extern void ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C15__9S21070C12__8S21070C2[] = {
  ABISELECT(-1968,-1196),
  ABISELECT(-2176,-1352),
  ABISELECT(-2384,-1492),
  ABISELECT(1040,660),
  ABISELECT(-1856,-1140),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__A1__8S21070C2[] = {
  ABISELECT(-3008,-1856),
  ABISELECT(-3216,-2012),
  ABISELECT(-3424,-2152),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A5__8S21070C2[] = {
  ABISELECT(-3424,-2152),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A5__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(3424,2152),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A2__8S21070C2[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A6__8S21070C2[] = {
  ABISELECT(-3536,-2208),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A6__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(3536,2208),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(3536,2208),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__A2__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(3328,2068),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A2__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3120,1912),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(3424,2152),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__A1__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(3216,2012),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3008,1856),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__A1__8S21070C2[] = {
  ABISELECT(-3120,-1912),
  ABISELECT(-3328,-2068),
  ABISELECT(-3536,-2208),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__8S21070C2[] = {
  ABISELECT(-3936,-2404),
  ABISELECT(-4144,-2560),
  ABISELECT(-4352,-2700),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C14__A11__8S21070C2[] = {
  ABISELECT(-4352,-2700),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C14__A11__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(4352,2700),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A5__8S21070C2[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C14__A12__8S21070C2[] = {
  ABISELECT(-4464,-2756),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A12__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(4464,2756),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C14__A5__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(4464,2756),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C14__A5__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4256,2616),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A5__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(4048,2460),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C14__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(4352,2700),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4144,2560),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(3936,2404),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14__8S21070C2[] = {
  ABISELECT(-4048,-2460),
  ABISELECT(-4256,-2616),
  ABISELECT(-4464,-2756),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4824,2956),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(5032,3096),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(4616,2800),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__8S21070C2[] = {
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__A6__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A13__8S21070C2[] = {
  ABISELECT(-5312,-3280),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A13__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(5312,3280),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__A6__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(5312,3280),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__A6__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(5104,3140),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A6__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(4896,2984),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(4688,2844),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(5104,3140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(4896,3000),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(72,44),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
extern void _ZN9S21070C23D1Ev();
extern void _ZN9S21070C23D0Ev();
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C23__8S21070C2[] = {
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-15424,-9560),
  ABISELECT(-10600,-6604),
  ABISELECT(-15632,-9700),
  ABISELECT(-15216,-9404),
  ABISELECT(3472,2228),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C23D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C23D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C21__9S21070C23__8S21070C2[] = {
  ABISELECT(208,140),
  ABISELECT(-3472,-2228),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-18896,-11788),
  ABISELECT(-14072,-8832),
  ABISELECT(-19104,-11928),
  ABISELECT(-18688,-11632),
  ABISELECT(-3472,-2228),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev),
};
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C23__8S21070C2[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-19104,-11928),
  ABISELECT(-14280,-8972),
  ABISELECT(-19312,-12068),
  ABISELECT(-18896,-11772),
  ABISELECT(-3680,-2368),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C23__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(15216,9404),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C23__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(15632,9700),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C23__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(10600,6604),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C23__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(15424,9560),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C23__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(10528,6560),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(10528,6560),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C23__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(10320,6420),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C23__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__A1__8S21070C2[] = {
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-18896,-11788),
  ABISELECT(-14072,-8832),
  ABISELECT(-19104,-11928),
  ABISELECT(-18688,-11632),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__A2__8S21070C2[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-19104,-11928),
  ABISELECT(-14280,-8972),
  ABISELECT(-19312,-12068),
  ABISELECT(-18896,-11772),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__A2__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(18896,11772),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__A2__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(19312,12068),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__A2__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(14280,8972),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__A2__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(19104,11928),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__A2__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14208,8928),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(14208,8928),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A2__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__A1__8S21070C2[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-19104,-11928),
  ABISELECT(-14280,-8972),
  ABISELECT(-19312,-12068),
  ABISELECT(-18896,-11772),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__A1__8S21070C2[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(18688,11632),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(19104,11928),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__A1__8S21070C2[] = {
  ABISELECT(-4616,-2800),
  ABISELECT(-5032,-3096),
  ABISELECT(-4824,-2956),
  ABISELECT(14072,8832),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__A1__8S21070C2[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(18896,11788),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__A1__8S21070C2[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14000,8788),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-4896,-3000),
  ABISELECT(-5104,-3140),
  ABISELECT(-4688,-2844),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__A1__8S21070C2[] = {
  ABISELECT(-4896,-2984),
  ABISELECT(-5104,-3140),
  ABISELECT(-5312,-3280),
  ABISELECT(13792,8648),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__A1__8S21070C2[] = {
  0,
  0,
  0,
  ABISELECT(3504,2240),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
static  VTT_ENTRY vtt_S21070C2[] = {
  {&(_ZTV8S21070C2[14]),  14,377},
  {&(_tg__ZTV9S21070C16__8S21070C2[7]),  7,11},
  {&(_tg__ZTV9S21070C179S21070C16__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C16__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C16__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C16__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C16__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C16__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C16__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C16__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C16__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C16__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C18__9S21070C16__8S21070C2[5]),  5,5},
  {&(_tg__ZTV9S21070C19__9S21070C16__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C16__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C20__8S21070C2[10]),  10,17},
  {&(_tg__ZTV9S21070C219S21070C20__8S21070C2[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C219S21070C20__A1__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C219S21070C20__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C219S21070C20__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C219S21070C20__A1__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C219S21070C20__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C219S21070C20__A1__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C219S21070C20__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C219S21070C20__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C219S21070C20__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C219S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C219S21070C20__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C219S21070C20__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C219S21070C20__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C219S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C219S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C59S21070C20__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C59S21070C20__A7__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C59S21070C20__A14__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C20__A14__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C59S21070C20__A7__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C59S21070C20__A7__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C20__A7__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C20__A3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C59S21070C20__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C59S21070C20__A3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C59S21070C20__A3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C59S21070C20__A15__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C20__A15__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C20__A16__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C20__A16__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C20__A8__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C59S21070C20__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C59S21070C20__A3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C59S21070C20__A3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C59S21070C20__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C20__A17__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C59S21070C20__A17__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C59S21070C20__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C59S21070C20__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C59S21070C20__A2__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C59S21070C20__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C59S21070C20__A2__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C20__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C59S21070C20__A2__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C20__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C20__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C20__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C20__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C20__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C5__9S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C20__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__9S21070C20__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A5__9S21070C20__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C23__9S21070C20__8S21070C2[12]),  12,16},
  {&(_tg__ZTV9S21070C21__A1__9S21070C20__8S21070C2[13]),  13,18},
  {&(_tg__ZTV9S21070C179S21070C21__A1__9S21070C20__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C8__A__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__A__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__A__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C5__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C5__A9__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C5__A18__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C5__A18__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C5__A9__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C5__A9__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C5__A9__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C5__A5__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C5__A5__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C5__A5__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C5__A4__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C5__A19__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C5__A19__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A10__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C5__A20__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C5__A20__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C5__A10__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C5__A10__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C5__A10__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C5__A4__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C5__A4__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C5__A4__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C5__A4__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A21__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C5__A21__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C5__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C5__A3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C5__A3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C5__A3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C5__A3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C5__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C5__A3__8S21070C2[3]),  3,4},
  {&(_ZTV8S21070C2[144]),  144,377},
  {&(_ZTV8S21070C2[182]),  182,377},
  {&(_ZTV8S21070C2[189]),  189,377},
  {&(_ZTV8S21070C2[193]),  193,377},
  {&(_ZTV8S21070C2[149]),  149,377},
  {&(_ZTV8S21070C2[156]),  156,377},
  {&(_ZTV8S21070C2[161]),  161,377},
  {&(_ZTV8S21070C2[170]),  170,377},
  {&(_ZTV8S21070C2[176]),  176,377},
  {&(_ZTV8S21070C2[208]),  208,377},
  {&(_ZTV8S21070C2[258]),  258,377},
  {&(_ZTV8S21070C2[267]),  267,377},
  {&(_ZTV8S21070C2[214]),  214,377},
  {&(_ZTV8S21070C2[221]),  221,377},
  {&(_ZTV8S21070C2[226]),  226,377},
  {&(_ZTV8S21070C2[235]),  235,377},
  {&(_ZTV8S21070C2[241]),  241,377},
  {&(_ZTV8S21070C2[278]),  278,377},
  {&(_ZTV8S21070C2[287]),  287,377},
  {&(_ZTV8S21070C2[248]),  248,377},
  {&(_ZTV8S21070C2[295]),  295,377},
  {&(_ZTV8S21070C2[309]),  309,377},
  {&(_ZTV8S21070C2[322]),  322,377},
  {&(_ZTV8S21070C2[28]),  28,377},
  {&(_ZTV8S21070C2[42]),  42,377},
  {&(_ZTV8S21070C2[330]),  330,377},
  {&(_ZTV8S21070C2[50]),  50,377},
  {&(_ZTV8S21070C2[62]),  62,377},
  {&(_ZTV8S21070C2[67]),  67,377},
  {&(_ZTV8S21070C2[76]),  76,377},
  {&(_ZTV8S21070C2[82]),  82,377},
  {&(_ZTV8S21070C2[345]),  345,377},
  {&(_ZTV8S21070C2[362]),  362,377},
  {&(_ZTV8S21070C2[374]),  374,377},
  {&(_ZTV8S21070C2[92]),  92,377},
  {&(_ZTV8S21070C2[97]),  97,377},
  {&(_ZTV8S21070C2[109]),  109,377},
  {&(_ZTV8S21070C2[114]),  114,377},
  {&(_ZTV8S21070C2[123]),  123,377},
  {&(_ZTV8S21070C2[129]),  129,377},
  {&(_tg__ZTV8S21070C3__8S21070C2[8]),  8,11},
  {&(_tg__ZTV8S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C58S21070C3__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C58S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C58S21070C3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C58S21070C3__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C58S21070C3__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C58S21070C3__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C58S21070C3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C58S21070C3__A2__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C58S21070C3__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C58S21070C3__A3__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C58S21070C3__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C58S21070C3__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C58S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C58S21070C3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C58S21070C3__A4__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C58S21070C3__A4__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C58S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C58S21070C3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C58S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C58S21070C3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C58S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C58S21070C3__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C5__A1__8S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__8S21070C3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A1__8S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A4__8S21070C3__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C12__8S21070C3__8S21070C2[14]),  14,18},
  {&(_tg__ZTV9S21070C11__A1__8S21070C3__8S21070C2[8]),  8,12},
  {&(_tg__ZTV8S21070C69S21070C11__A2__8S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C48S21070C59S21070C12__A2__8S21070C3__8S21070C2[2]),  2,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C3__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C3__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C14__8S21070C3__8S21070C2[8]),  8,12},
  {&(_tg__ZTV8S21070C69S21070C14__A5__8S21070C3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C159S21070C12__8S21070C3__8S21070C2[6]),  6,8},
  {&(_tg__ZTV8S21070C8__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C12__8S21070C2[7]),  7,11},
  {&(_tg__ZTV8S21070C59S21070C12__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C59S21070C12__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A7__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A3__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A3__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A3__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C12__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A2__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C59S21070C12__A2__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A8__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A9__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A4__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A2__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C12__A10__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A10__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C59S21070C12__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C59S21070C12__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C59S21070C12__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C59S21070C12__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C59S21070C12__A1__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C59S21070C12__A1__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C159S21070C12__8S21070C2[6]),  6,8},
  {&(_tg__ZTV9S21070C11__9S21070C159S21070C12__8S21070C2[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C159S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C159S21070C12__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C159S21070C12__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C11__9S21070C12__8S21070C2[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C12__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C12__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C12__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__A1__9S21070C12__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A6__9S21070C12__8S21070C2[3]),  3,4},
  {&(_tg__ZTV9S21070C14__9S21070C12__8S21070C2[8]),  8,12},
  {&(_tg__ZTV8S21070C69S21070C14__A3__9S21070C12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C15__9S21070C12__8S21070C2[6]),  6,8},
  {&(_tg__ZTV9S21070C11__A1__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A5__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A5__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A6__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A6__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__A2__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C14__8S21070C2[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C14__A11__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C14__A11__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C14__A5__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C14__A12__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A12__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C14__A5__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C14__A5__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A5__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C14__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C14__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C14__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__8S21070C2[4]),  4,5},
  {&(_tg__ZTV9S21070C19__8S21070C2[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__A6__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A13__8S21070C2[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A13__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__A6__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__A6__8S21070C2[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A6__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__8S21070C2[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__8S21070C2[5]),  5,5},
  {&(_tg__ZTV9S21070C23__8S21070C2[9]),  9,13},
  {&(_tg__ZTV9S21070C21__9S21070C23__8S21070C2[13]),  13,18},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C23__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C23__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C23__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C23__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C23__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C23__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C23__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C23__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C21__A1__8S21070C2[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__A2__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__A2__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__A2__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__A2__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__A2__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A2__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__A1__8S21070C2[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__A1__8S21070C2[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__A1__8S21070C2[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__A1__8S21070C2[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__A1__8S21070C2[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__A1__8S21070C2[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__A1__8S21070C2[5]),  5,8},
};
extern VTBL_ENTRY _ZTI8S21070C2[];
extern  VTBL_ENTRY _ZTV8S21070C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C2[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N9S21070C12D0Ev,_ZThn2348_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N9S21070C12D1Ev,_ZThn2348_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D0Ev,_ZThn1800_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2896_N9S21070C12D1Ev,_ZThn1800_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D0Ev,_ZThn660_N9S21070C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S21070C15D1Ev,_ZThn660_N9S21070C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C3D0Ev,_ZTv0_n28_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6176_N8S21070C3D0Ev,_ZThn3816_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C3D1Ev,_ZTv0_n28_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6176_N8S21070C3D1Ev,_ZThn3816_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C3D0Ev,_ZTv0_n32_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5248_N8S21070C3D0Ev,_ZThn3268_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C3D1Ev,_ZTv0_n32_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5248_N8S21070C3D1Ev,_ZThn3268_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C3D0Ev,_ZTv0_n36_N8S21070C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2352_N8S21070C3D0Ev,_ZThn1468_N8S21070C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C3D1Ev,_ZTv0_n36_N8S21070C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2352_N8S21070C3D1Ev,_ZThn1468_N8S21070C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn26976_N9S21070C20D0Ev,_ZThn16892_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn26976_N9S21070C20D1Ev,_ZThn16892_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23504_N9S21070C20D0Ev,_ZThn14664_N9S21070C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn12976_N9S21070C20D0Ev,_ZThn8104_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23504_N9S21070C20D1Ev,_ZThn14664_N9S21070C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn12976_N9S21070C20D1Ev,_ZThn8104_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12976_N9S21070C21D0Ev,_ZThn8104_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12976_N9S21070C21D1Ev,_ZThn8104_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C16D0Ev,_ZTv0_n40_N9S21070C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N9S21070C16D0Ev,_ZThn9408_N9S21070C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C16D1Ev,_ZTv0_n40_N9S21070C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N9S21070C16D1Ev,_ZThn9408_N9S21070C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12768_N9S21070C17D0Ev,_ZThn7964_N9S21070C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N9S21070C17D0Ev,_ZThn9408_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12768_N9S21070C17D1Ev,_ZThn7964_N9S21070C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N9S21070C17D1Ev,_ZThn9408_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S21070C2D0Ev,_ZTv0_n48_N8S21070C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn28944_N8S21070C2D0Ev,_ZThn18196_N8S21070C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S21070C2D1Ev,_ZTv0_n48_N8S21070C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn28944_N8S21070C2D1Ev,_ZThn18196_N8S21070C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C2D0Ev,_ZTv0_n28_N8S21070C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14192_N8S21070C2D0Ev,_ZThn8968_N8S21070C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S21070C2D1Ev,_ZTv0_n28_N8S21070C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn14192_N8S21070C2D1Ev,_ZThn8968_N8S21070C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C2D0Ev,_ZTv0_n32_N8S21070C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13264_N8S21070C2D0Ev,_ZThn8420_N8S21070C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S21070C2D1Ev,_ZTv0_n32_N8S21070C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn13264_N8S21070C2D1Ev,_ZThn8420_N8S21070C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C2D0Ev,_ZTv0_n36_N8S21070C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10368_N8S21070C2D0Ev,_ZThn6620_N8S21070C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N8S21070C2D1Ev,_ZTv0_n36_N8S21070C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10368_N8S21070C2D1Ev,_ZThn6620_N8S21070C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S21070C2D0Ev,_ZTv0_n40_N8S21070C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn25472_N8S21070C2D0Ev,_ZThn15968_N8S21070C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N8S21070C2D0Ev,_ZThn9408_N8S21070C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8016_N8S21070C2D0Ev,_ZThn5152_N8S21070C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S21070C2D1Ev,_ZTv0_n40_N8S21070C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn25472_N8S21070C2D1Ev,_ZThn15968_N8S21070C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn14944_N8S21070C2D1Ev,_ZThn9408_N8S21070C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8016_N8S21070C2D1Ev,_ZThn5152_N8S21070C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C2 = {  "S21070C2", // class name
  bases_S21070C2, 73,
  &(vtc_S21070C2[0]), // expected_vtbl_contents
  &(vtt_S21070C2[0]), // expected_vtt_contents
  ABISELECT(31072,19624), // object size
  NSPAIRA(_ZTI8S21070C2),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S21070C2),377, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21070C2),330, //virtual table table var
  72, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S21070C27  {
  long s21070c27f0;
  void *s21070c27f1;
  long s21070c27f2;
  char s21070c27f3[9];
  void *s21070c27f4;
  __tsi64 s21070c27f5;
  __tsi64 s21070c27f6[3];
  void  mf21070c27(); // _ZN9S21070C2710mf21070c27Ev
};
//SIG(1 S21070C27) U1{ m Fl Fp Fl Fc[9] Fp FL FL[3]}

#endif // __cplusplus
#ifdef __cplusplus

struct  S21070C26  {
  int s21070c26f0;
  int s21070c26f1:32;
  void *s21070c26f2;
  int s21070c26f3;
  __tsi64 s21070c26f4;
  ::S21070C27 s21070c26f5;
  short s21070c26f6[2];
  void *s21070c26f7;
  int s21070c26f8;
  virtual void  v22(); // _ZN9S21070C263v22Ev
  virtual void  v23(); // _ZN9S21070C263v23Ev
  virtual void  v24(); // _ZN9S21070C263v24Ev
  ~S21070C26(); // tgen
  S21070C26(); // tgen
};
//SIG(-1 S21070C26) C1{ v1 v2 v3 Fi Fi:32 Fp Fi FL FU2{ m Fl Fp Fl Fc[9] Fp FL FL[3]} Fs[2] Fp Fi}


void  S21070C26 ::v22(){vfunc_called(this, "_ZN9S21070C263v22Ev");}
void  S21070C26 ::v23(){vfunc_called(this, "_ZN9S21070C263v23Ev");}
void  S21070C26 ::v24(){vfunc_called(this, "_ZN9S21070C263v24Ev");}
S21070C26 ::~S21070C26(){ note_dtor("S21070C26", this);} // tgen
S21070C26 ::S21070C26(){ note_ctor("S21070C26", this);} // tgen

static void Test_S21070C26()
{
  extern Class_Descriptor cd_S21070C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,17)];
    init_test(&cd_S21070C26, buf);
    S21070C26 *dp, &lv = *(dp=new (buf) S21070C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,64), "sizeof(S21070C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21070C26)");
    check_field_offset(lv, s21070c26f0, ABISELECT(8,4), "S21070C26.s21070c26f0");
    set_bf_and_test(lv, s21070c26f1, ABISELECT(12,8), 0, 32, 1, "S21070C26");
    set_bf_and_test(lv, s21070c26f1, ABISELECT(12,8), 0, 32, hide_sll(1LL<<31), "S21070C26");
    check_field_offset(lv, s21070c26f2, ABISELECT(16,12), "S21070C26.s21070c26f2");
    check_field_offset(lv, s21070c26f3, ABISELECT(24,16), "S21070C26.s21070c26f3");
    check_field_offset(lv, s21070c26f4, ABISELECT(32,20), "S21070C26.s21070c26f4");
    check_field_offset(lv, s21070c26f5, ABISELECT(40,28), "S21070C26.s21070c26f5");
    check_field_offset(lv, s21070c26f6, ABISELECT(64,52), "S21070C26.s21070c26f6");
    check_field_offset(lv, s21070c26f7, ABISELECT(72,56), "S21070C26.s21070c26f7");
    check_field_offset(lv, s21070c26f8, ABISELECT(80,60), "S21070C26.s21070c26f8");
    test_class_info(&lv, &cd_S21070C26);
    dp->~S21070C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C26(Test_S21070C26, "S21070C26", ABISELECT(88,64));

#else // __cplusplus

extern void _ZN9S21070C26C1Ev();
extern void _ZN9S21070C26D1Ev();
Name_Map name_map_S21070C26[] = {
  NSPAIR(_ZN9S21070C26C1Ev),
  NSPAIR(_ZN9S21070C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21070C26[];
extern void _ZN9S21070C263v22Ev();
extern void _ZN9S21070C263v23Ev();
extern void _ZN9S21070C263v24Ev();
static  VTBL_ENTRY vtc_S21070C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C26[0]),
  (VTBL_ENTRY)&_ZN9S21070C263v22Ev,
  (VTBL_ENTRY)&_ZN9S21070C263v23Ev,
  (VTBL_ENTRY)&_ZN9S21070C263v24Ev,
};
extern VTBL_ENTRY _ZTI9S21070C26[];
extern  VTBL_ENTRY _ZTV9S21070C26[];
Class_Descriptor cd_S21070C26 = {  "S21070C26", // class name
  0,0,//no base classes
  &(vtc_S21070C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,64), // object size
  NSPAIRA(_ZTI9S21070C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21070C26),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C25  : virtual S21070C11 , S21070C12 , S21070C20 , S21070C26 {
  void *s21070c25f0[5];
  __tsi64 s21070c25f1;
  int s21070c25f2;
  __tsi64 s21070c25f3;
  ::S21070C22 s21070c25f4;
  long double s21070c25f5[9];
  void *s21070c25f6;
  int s21070c25f7;
  virtual  ~S21070C25(); // _ZN9S21070C25D2Ev
  virtual void  v25(); // _ZN9S21070C253v25Ev
  virtual void  v26(); // _ZN9S21070C253v26Ev
  S21070C25(); // tgen
};
//SIG(-1 S21070C25) C1{ VBC2{ VBC3{ v3 v4 v5 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} VBC4{ VBC3 VBC5{ VBC3 v6 Fi Fp[8] FL Fi Fl} Fc FU6{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs} Fi FC7{} Fp FU6 Fi Fi[3]} BC5 BC8{ VBC3 BC5 VBC4 vd FL Fi FD} v7 Fi Fp FC5 Fi[2] Fp[3] Fc FL Fp[9] FC3} BC9{ VBC2 BC10{ BC8 BC3 BC4 BC2 BC5 vd Fs FC7 Fi FD Fp[8] Fp[10] Fs:3 Fp} BC11{ m FU6} VBC12{ VBC3 BC5 VBC4 BC8 vd v8 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC5 Fi} BC13{ VBC2 Fi:6} v9 FL:49 FC3 FL Fs Fp Fi Fp[10] Fs Fp FC8 Fp FL:5} BC14{ BC15{ BC3 BC16{ VBC5 VBC17{ VBC4 FL Fp Fc Fi Fp[3] FL} VBC18{ VBC5 BC3 BC8 VBC17 vd v10 v11 v12 Fi Fi FC10[3] FC3 FL[9] FC2 Fc FL FC2} vd v13 FL Fp FC3[9] Fc} VBC19{ v14 v15 v16 Fp Fi} vd FL:3 FL} BC10 BC19 VBC20{ VBC15 vd v17 v18 Fp FL Fc FC19 FC12 Fp[7] Fi FC21{ m Fc FU6[9] Fp FC12 Fp FL Fp[9] FL} FL[8]} vd v19 v20 Fp Fi FL Fi Fc[8] Fp Fp Fi FL Fi Fi Fp} BC22{ v21 v22 v23 Fi Fi:32 Fp Fi FL FU23{ m Fl Fp Fl Fc[9] Fp FL FL[3]} Fs[2] Fp Fi} vd v1 v2 Fp[5] FL Fi FL FC19 FD[9] Fp Fi}


 S21070C25 ::~S21070C25(){ note_dtor("S21070C25", this);}
void  S21070C25 ::v25(){vfunc_called(this, "_ZN9S21070C253v25Ev");}
void  S21070C25 ::v26(){vfunc_called(this, "_ZN9S21070C253v26Ev");}
S21070C25 ::S21070C25(){ note_ctor("S21070C25", this);} // tgen

static void Test_S21070C25()
{
  extern Class_Descriptor cd_S21070C25;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1600,4043)];
    init_test(&cd_S21070C25, buf);
    S21070C25 *dp, &lv = *(dp=new (buf) S21070C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(25584,16168), "sizeof(S21070C25)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C25)");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C11*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C5*)(S21070C20*), ABISELECT(8176,5160), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(8592,5456), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C11*), ABISELECT(8384,5300), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*), ABISELECT(8384,5300), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C12*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(8384,5300), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8384,5300), "S21070C25");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(8384,5300), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*), ABISELECT(7248,4612), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*), ABISELECT(7360,4668), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C11*), ABISELECT(7360,4668), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C11*), ABISELECT(7248,4612), "S21070C25");
    /*is_ambiguous_... S21070C12::S21070C11 */ AMB_check_base_class_offset(lv, (S21070C11*)(S21070C12*), ABISELECT(7248,4612), "S21070C25");
    check_base_class_offset(lv, (S21070C11*)(S21070C15*)(S21070C12*), ABISELECT(7248,4612), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C12*), 0, "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C12*), 0, "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C12*), ABISELECT(144,80), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C12*), ABISELECT(352,220), "S21070C25");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(560,376), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(672,432), "S21070C25");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(672,432), "S21070C25");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C12*), ABISELECT(560,376), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C12*), ABISELECT(1488,924), "S21070C25");
    check_base_class_offset(lv, (S21070C5*)(S21070C12*), 0, "S21070C25");
    check_base_class_offset(lv, (S21070C13*)(S21070C12*), ABISELECT(1776,1080), "S21070C25");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(8704,5512), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(8816,5568), "S21070C25");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(8816,5568), "S21070C25");
    check_base_class_offset(lv, (S21070C14*)(S21070C12*), ABISELECT(8704,5512), "S21070C25");
    check_base_class_offset(lv, (S21070C15*)(S21070C12*), ABISELECT(1856,1140), "S21070C25");
    check_base_class_offset(lv, (S21070C12*), 0, "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*)(S21070C20*), ABISELECT(2896,1800), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(9384,5908), "S21070C25");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(9384,5908), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(9384,5908), "S21070C25");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(9456,5952), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(9664,6092), "S21070C25");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(9664,6092), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(9456,5952), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(9456,5952), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*)(S21070C20*), ABISELECT(3104,1940), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*)(S21070C20*), ABISELECT(19952,12500), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(19952,12500), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C21*)(S21070C20*), ABISELECT(2896,1800), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(5024,3228), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C6 */ AMB_check_base_class_offset(lv, (S21070C6*)(S21070C5*)(S21070C20*), ABISELECT(5024,3228), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C5*)(S21070C20*), ABISELECT(5168,3308), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C8 */ AMB_check_base_class_offset(lv, (S21070C8*)(S21070C5*)(S21070C20*), ABISELECT(5376,3448), "S21070C25");
    /*is_ambiguous_... S21070C11::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(5584,3604), "S21070C25");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(5696,3660), "S21070C25");
    check_base_class_offset(lv, (S21070C6*)(S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(5696,3660), "S21070C25");
    check_base_class_offset(lv, (S21070C11*)(S21070C5*)(S21070C20*), ABISELECT(5584,3604), "S21070C25");
    /*is_ambiguous_... S21070C5::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C5*)(S21070C20*), ABISELECT(6512,4152), "S21070C25");
    check_base_class_offset(lv, (S21070C5*)(S21070C20*), ABISELECT(5024,3228), "S21070C25");
    /*is_ambiguous_... S21070C20::S21070C22 */ AMB_check_base_class_offset(lv, (S21070C22*)(S21070C20*), ABISELECT(6800,4308), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), ABISELECT(23456,14740), "S21070C25");
    /*is_ambiguous_... S21070C25::S21070C21 */ AMB_check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(23664,14880), "S21070C25");
    check_base_class_offset(lv, (S21070C21*)(S21070C23*), ABISELECT(23456,14740), "S21070C25");
    check_base_class_offset(lv, (S21070C23*)(S21070C20*), ABISELECT(19984,12512), "S21070C25");
    check_base_class_offset(lv, (S21070C20*), ABISELECT(2896,1800), "S21070C25");
    check_base_class_offset(lv, (S21070C26*), ABISELECT(6912,4380), "S21070C25");
    check_field_offset(lv, s21070c25f0, ABISELECT(7000,4444), "S21070C25.s21070c25f0");
    check_field_offset(lv, s21070c25f1, ABISELECT(7040,4464), "S21070C25.s21070c25f1");
    check_field_offset(lv, s21070c25f2, ABISELECT(7048,4472), "S21070C25.s21070c25f2");
    check_field_offset(lv, s21070c25f3, ABISELECT(7056,4476), "S21070C25.s21070c25f3");
    check_field_offset(lv, s21070c25f4, ABISELECT(7064,4484), "S21070C25.s21070c25f4");
    check_field_offset(lv, s21070c25f5, ABISELECT(7088,4496), "S21070C25.s21070c25f5");
    check_field_offset(lv, s21070c25f6, ABISELECT(7232,4604), "S21070C25.s21070c25f6");
    check_field_offset(lv, s21070c25f7, ABISELECT(7240,4608), "S21070C25.s21070c25f7");
    test_class_info(&lv, &cd_S21070C25);
    dp->~S21070C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C25(Test_S21070C25, "S21070C25", ABISELECT(25584,16168));

#else // __cplusplus

extern void _ZN9S21070C25C1Ev();
extern void _ZN9S21070C25D2Ev();
Name_Map name_map_S21070C25[] = {
  NSPAIR(_ZN9S21070C25C1Ev),
  NSPAIR(_ZN9S21070C25D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C13;
extern VTBL_ENTRY _ZTI9S21070C13[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C15;
extern VTBL_ENTRY _ZTI9S21070C15[];
extern  VTBL_ENTRY _ZTV9S21070C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C15[];
extern Class_Descriptor cd_S21070C12;
extern VTBL_ENTRY _ZTI9S21070C12[];
extern  VTBL_ENTRY _ZTV9S21070C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C12[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C11;
extern VTBL_ENTRY _ZTI9S21070C11[];
extern  VTBL_ENTRY _ZTV9S21070C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C11[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C5;
extern VTBL_ENTRY _ZTI8S21070C5[];
extern  VTBL_ENTRY _ZTV8S21070C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C5[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C23;
extern VTBL_ENTRY _ZTI9S21070C23[];
extern  VTBL_ENTRY _ZTV9S21070C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C23[];
extern Class_Descriptor cd_S21070C20;
extern VTBL_ENTRY _ZTI9S21070C20[];
extern  VTBL_ENTRY _ZTV9S21070C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C20[];
extern Class_Descriptor cd_S21070C26;
extern VTBL_ENTRY _ZTI9S21070C26[];
extern  VTBL_ENTRY _ZTV9S21070C26[];
static Base_Class bases_S21070C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C4,    ABISELECT(8176,5160), //bcp->offset
    151, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    119, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(8592,5456), //bcp->offset
    163, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    121, //bcp->index_in_construction_vtbl_array
    160, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(8384,5300), //bcp->offset
    159, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    120, //bcp->index_in_construction_vtbl_array
    157, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(7248,4612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    145, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(7360,4668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    148, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(7360,4668), //bcp->offset
    143, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    122, //bcp->index_in_construction_vtbl_array
    147, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(7248,4612), //bcp->offset
    131, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    118, //bcp->index_in_construction_vtbl_array
    144, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(144,80), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(352,220), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    123, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(560,376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(672,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(672,432), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    125, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(560,376), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    124, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(1488,924), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    126, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21070C13,    ABISELECT(1776,1080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(8704,5512), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    163, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(8816,5568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    166, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(8816,5568), //bcp->offset
    180, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    128, //bcp->index_in_construction_vtbl_array
    165, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(8704,5512), //bcp->offset
    168, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    127, //bcp->index_in_construction_vtbl_array
    162, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S21070C15,    ABISELECT(1856,1140), //bcp->offset
    48, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    129, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21070C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C4,    ABISELECT(2896,1800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S21070C18,    ABISELECT(9384,5908), //bcp->offset
    188, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    132, //bcp->index_in_construction_vtbl_array
    175, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(9456,5952), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(9664,6092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    181, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(9664,6092), //bcp->offset
    215, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    134, //bcp->index_in_construction_vtbl_array
    180, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(9456,5952), //bcp->offset
    193, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    133, //bcp->index_in_construction_vtbl_array
    179, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(3104,1940), //bcp->offset
    73, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    131, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(19952,12500), //bcp->offset
    223, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    135, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S21070C21,    ABISELECT(2896,1800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5024,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(5024,3228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(5168,3308), //bcp->offset
    91, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21070C8,    ABISELECT(5376,3448), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    137, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5584,3604), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5696,3660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    84, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(5696,3660), //bcp->offset
    109, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    139, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S21070C11,    ABISELECT(5584,3604), //bcp->offset
    100, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    138, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6512,4152), //bcp->offset
    117, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    140, //bcp->index_in_construction_vtbl_array
    93, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21070C5,    ABISELECT(5024,3228), //bcp->offset
    83, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    136, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(6800,4308), //bcp->offset
    121, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S21070C4,    ABISELECT(23456,14740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S21070C17,    ABISELECT(23664,14880), //bcp->offset
    265, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    143, //bcp->index_in_construction_vtbl_array
    202, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S21070C21,    ABISELECT(23456,14740), //bcp->offset
    247, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    142, //bcp->index_in_construction_vtbl_array
    201, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    47, //immediately_derived
  0, 1},
  {&cd_S21070C23,    ABISELECT(19984,12512), //bcp->offset
    231, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    141, //bcp->index_in_construction_vtbl_array
    191, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    48, //immediately_derived
  0, 1},
  {&cd_S21070C20,    ABISELECT(2896,1800), //bcp->offset
    56, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    130, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C26,    ABISELECT(6912,4380), //bcp->offset
    126, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C25[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C25D1Ev();
extern void _ZN9S21070C25D0Ev();
extern void _ZN9S21070C122v9Ev();
extern void _ZN9S21070C253v25Ev();
extern void _ZN9S21070C253v26Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N9S21070C25D1Ev,_ZThn376_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn560_N9S21070C25D0Ev,_ZThn376_N9S21070C25D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N9S21070C25D1Ev,_ZThn432_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn672_N9S21070C25D0Ev,_ZThn432_N9S21070C25D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn1856_N9S21070C25D1Ev,_ZThn1140_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn1856_N9S21070C25D0Ev,_ZThn1140_N9S21070C25D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZThn2896_N9S21070C25D1Ev,_ZThn1800_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn2896_N9S21070C25D0Ev,_ZThn1800_N9S21070C25D0Ev)();
extern void _ZN9S21070C203v20Ev();
extern void _ZN9S21070C203v21Ev();
extern void ABISELECT(_ZThn3104_N9S21070C25D1Ev,_ZThn1940_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn3104_N9S21070C25D0Ev,_ZThn1940_N9S21070C25D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn5024_N9S21070C25D1Ev,_ZThn3228_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn5024_N9S21070C25D0Ev,_ZThn3228_N9S21070C25D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn5584_N9S21070C25D1Ev,_ZThn3604_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn5584_N9S21070C25D0Ev,_ZThn3604_N9S21070C25D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn5696_N9S21070C25D1Ev,_ZThn3660_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn5696_N9S21070C25D0Ev,_ZThn3660_N9S21070C25D0Ev)();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void _ZN9S21070C263v22Ev();
extern void _ZN9S21070C263v23Ev();
extern void _ZN9S21070C263v24Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C25D1Ev,_ZTv0_n32_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn7248_N9S21070C25D1Ev,_ZThn4612_N9S21070C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C25D0Ev,_ZTv0_n32_N9S21070C25D0Ev)();
extern void ABISELECT(_ZThn7248_N9S21070C25D0Ev,_ZThn4612_N9S21070C25D0Ev)() __attribute__((weak));
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C25D1Ev,_ZTvn56_n32_N9S21070C25D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C25D0Ev,_ZTvn56_n32_N9S21070C25D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C25D1Ev,_ZTv0_n28_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn8704_N9S21070C25D1Ev,_ZThn5512_N9S21070C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C25D0Ev,_ZTv0_n28_N9S21070C25D0Ev)();
extern void ABISELECT(_ZThn8704_N9S21070C25D0Ev,_ZThn5512_N9S21070C25D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C25D1Ev,_ZTvn56_n28_N9S21070C25D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C25D0Ev,_ZTvn56_n28_N9S21070C25D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C25D1Ev,_ZTv0_n40_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn9456_N9S21070C25D1Ev,_ZThn5952_N9S21070C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C25D0Ev,_ZTv0_n40_N9S21070C25D0Ev)();
extern void ABISELECT(_ZThn9456_N9S21070C25D0Ev,_ZThn5952_N9S21070C25D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C25D1Ev,_ZTvn140_n40_N9S21070C25D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C25D0Ev,_ZTvn140_n40_N9S21070C25D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C25D1Ev,_ZTv0_n40_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn19984_N9S21070C25D1Ev,_ZThn12512_N9S21070C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C25D0Ev,_ZTv0_n40_N9S21070C25D0Ev)();
extern void ABISELECT(_ZThn19984_N9S21070C25D0Ev,_ZThn12512_N9S21070C25D0Ev)() __attribute__((weak));
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C25D1Ev,_ZTv0_n48_N9S21070C25D1Ev)();
extern void ABISELECT(_ZThn23456_N9S21070C25D1Ev,_ZThn14740_N9S21070C25D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C25D0Ev,_ZTv0_n48_N9S21070C25D0Ev)();
extern void ABISELECT(_ZThn23456_N9S21070C25D0Ev,_ZThn14740_N9S21070C25D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn208_n96_N9S21070C25D1Ev,_ZTvn140_n48_N9S21070C25D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C25D0Ev,_ZTvn140_n48_N9S21070C25D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY vtc_S21070C25[] = {
  ABISELECT(23456,14740),
  ABISELECT(19984,12512),
  ABISELECT(19952,12500),
  ABISELECT(9456,5952),
  ABISELECT(9384,5908),
  ABISELECT(8704,5512),
  ABISELECT(7248,4612),
  ABISELECT(8592,5456),
  ABISELECT(8384,5300),
  ABISELECT(8176,5160),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C25D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C25D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
  (VTBL_ENTRY)&_ZN9S21070C253v25Ev,
  (VTBL_ENTRY)&_ZN9S21070C253v26Ev,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(8240,5236),
  ABISELECT(7824,4940),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  ABISELECT(8032,5080),
  ABISELECT(7824,4924),
  ABISELECT(7616,4784),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C25D1Ev,_ZThn376_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C25D0Ev,_ZThn376_N9S21070C25D0Ev),
  ABISELECT(7920,5024),
  ABISELECT(7712,4868),
  ABISELECT(7504,4728),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C25D1Ev,_ZThn432_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C25D0Ev,_ZThn432_N9S21070C25D0Ev),
  ABISELECT(6688,4236),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(6736,4316),
  ABISELECT(6528,4160),
  ABISELECT(6320,4020),
  ABISELECT(5392,3472),
  ABISELECT(-1856,-1140),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C25D1Ev,_ZThn1140_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C25D0Ev,_ZThn1140_N9S21070C25D0Ev),
  ABISELECT(20560,12940),
  ABISELECT(17088,10712),
  ABISELECT(17056,10700),
  ABISELECT(6560,4152),
  ABISELECT(5488,3500),
  ABISELECT(6488,4108),
  ABISELECT(5280,3360),
  ABISELECT(5696,3656),
  ABISELECT(-2896,-1800),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2896_N9S21070C25D1Ev,_ZThn1800_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2896_N9S21070C25D0Ev,_ZThn1800_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C203v20Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v21Ev,
  ABISELECT(6352,4012),
  ABISELECT(5280,3360),
  ABISELECT(6280,3968),
  ABISELECT(5072,3220),
  ABISELECT(5488,3516),
  ABISELECT(-3104,-1940),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn3104_N9S21070C25D1Ev,_ZThn1940_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn3104_N9S21070C25D0Ev,_ZThn1940_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  ABISELECT(3568,2228),
  ABISELECT(3360,2072),
  ABISELECT(3152,1932),
  ABISELECT(-5024,-3228),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn5024_N9S21070C25D1Ev,_ZThn3228_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn5024_N9S21070C25D0Ev,_ZThn3228_N9S21070C25D0Ev),
  ABISELECT(-5168,-3308),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(3216,2008),
  ABISELECT(2800,1712),
  ABISELECT(-5376,-3448),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  ABISELECT(3008,1852),
  ABISELECT(2800,1696),
  ABISELECT(2592,1556),
  ABISELECT(-5584,-3604),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn5584_N9S21070C25D1Ev,_ZThn3604_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn5584_N9S21070C25D0Ev,_ZThn3604_N9S21070C25D0Ev),
  ABISELECT(2896,1796),
  ABISELECT(2688,1640),
  ABISELECT(2480,1500),
  ABISELECT(-5696,-3660),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn5696_N9S21070C25D1Ev,_ZThn3660_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn5696_N9S21070C25D0Ev,_ZThn3660_N9S21070C25D0Ev),
  ABISELECT(1664,1008),
  ABISELECT(-6512,-4152),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-6800,-4308),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  ABISELECT(-6912,-4380),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN9S21070C263v22Ev,
  (VTBL_ENTRY)&_ZN9S21070C263v23Ev,
  (VTBL_ENTRY)&_ZN9S21070C263v24Ev,
  ABISELECT(-7248,-4612),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-7248,-4612),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C25D1Ev,_ZTv0_n32_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C25D0Ev,_ZTv0_n32_N9S21070C25D0Ev),
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-7360,-4668),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C25D1Ev,_ZTvn56_n32_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C25D0Ev,_ZTvn56_n32_N9S21070C25D0Ev),
  0,
  0,
  0,
  ABISELECT(-8176,-5160),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8384,-5300),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8592,-5456),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  0,
  ABISELECT(-8704,-5512),
  0,
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-8704,-5512),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C25D1Ev,_ZTv0_n28_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C25D0Ev,_ZTv0_n28_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  ABISELECT(-8816,-5568),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C25D1Ev,_ZTvn56_n28_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C25D0Ev,_ZTvn56_n28_N9S21070C25D0Ev),
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(-9384,-5908),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-9456,-5952),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(-9456,-5952),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C25D1Ev,_ZTv0_n40_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C25D0Ev,_ZTv0_n40_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(-9664,-6092),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C25D1Ev,_ZTvn140_n40_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C25D0Ev,_ZTvn140_n40_N9S21070C25D0Ev),
  0,
  0,
  0,
  ABISELECT(-19952,-12500),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
  0,
  0,
  ABISELECT(-19984,-12512),
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-11600,-7212),
  ABISELECT(-10600,-6604),
  ABISELECT(-11808,-7352),
  ABISELECT(-11392,-7056),
  ABISELECT(3472,2228),
  ABISELECT(-19984,-12512),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C25D1Ev,_ZTv0_n40_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C25D0Ev,_ZTv0_n40_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
  ABISELECT(208,140),
  ABISELECT(-23456,-14740),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-15072,-9440),
  ABISELECT(-14072,-8832),
  ABISELECT(-15280,-9580),
  ABISELECT(-14864,-9284),
  ABISELECT(-23456,-14740),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C25D1Ev,_ZTv0_n48_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C25D0Ev,_ZTv0_n48_N9S21070C25D0Ev),
  ABISELECT(-14208,-8928),
  ABISELECT(-15280,-9580),
  ABISELECT(-14280,-8972),
  ABISELECT(-15488,-9720),
  ABISELECT(-15072,-9424),
  ABISELECT(-23664,-14880),
  (VTBL_ENTRY)&(_ZTI9S21070C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C25D1Ev,_ZTvn140_n48_N9S21070C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C25D0Ev,_ZTvn140_n48_N9S21070C25D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern VTBL_ENTRY _ZTV9S21070C25[];
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C12D1Ev();
extern void _ZN9S21070C12D0Ev();
extern void _ZN9S21070C122v9Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C12__9S21070C25[] = {
  ABISELECT(8704,5512),
  ABISELECT(7248,4612),
  ABISELECT(8592,5456),
  ABISELECT(8384,5300),
  ABISELECT(8176,5160),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C12D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C122v9Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(8592,5456),
  ABISELECT(8384,5300),
  ABISELECT(8176,5160),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(8592,5456),
  ABISELECT(8384,5300),
  ABISELECT(8176,5160),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A3__9S21070C25[] = {
  ABISELECT(8176,5160),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A3__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-8176,-5160),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-8176,-5160),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8384,-5300),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8592,-5456),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(8240,5236),
  ABISELECT(7824,4940),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-7824,-4940),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8240,-5236),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(8032,5080),
  ABISELECT(7824,4924),
  ABISELECT(7616,4784),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A4__9S21070C25[] = {
  ABISELECT(7616,4784),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A4__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-7616,-4784),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[] = {
  ABISELECT(7920,5024),
  ABISELECT(7712,4868),
  ABISELECT(7504,4728),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A5__9S21070C25[] = {
  ABISELECT(7504,4728),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A5__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-7504,-4728),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-7504,-4728),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-7712,-4868),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-7920,-5024),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-7616,-4784),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-7824,-4924),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8032,-5080),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A1__9S21070C25[] = {
  ABISELECT(7920,5024),
  ABISELECT(7712,4868),
  ABISELECT(7504,4728),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C12__A6__9S21070C25[] = {
  ABISELECT(6688,4236),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A6__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-6688,-4236),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C59S21070C12__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-8176,-5160),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8384,-5300),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C59S21070C12__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8592,-5456),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(8240,5236),
  ABISELECT(7824,4940),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(8032,5080),
  ABISELECT(7824,4924),
  ABISELECT(7616,4784),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(7920,5024),
  ABISELECT(7712,4868),
  ABISELECT(7504,4728),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C59S21070C12__9S21070C25[] = {
  ABISELECT(6688,4236),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN9S21070C15D1Ev();
extern void _ZN9S21070C15D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C159S21070C12__9S21070C25[] = {
  ABISELECT(6736,4316),
  ABISELECT(6528,4160),
  ABISELECT(6320,4020),
  ABISELECT(5392,3472),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN9S21070C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C15D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZThn5392_N9S21070C15D1Ev,_ZThn3472_N9S21070C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev)();
extern void ABISELECT(_ZThn5392_N9S21070C15D0Ev,_ZThn3472_N9S21070C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C159S21070C12__9S21070C25[] = {
  ABISELECT(-5392,-3472),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-5392,-3472),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C159S21070C12__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-6320,-4020),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C159S21070C12__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-6528,-4160),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C159S21070C12__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-6736,-4316),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__9S21070C25[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-5504,-3528),
  (VTBL_ENTRY)&(_ZTI9S21070C15[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D1Ev,_ZTvn56_n32_N9S21070C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C15D0Ev,_ZTvn56_n32_N9S21070C15D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn7248_N9S21070C12D1Ev,_ZThn4612_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn7248_N9S21070C12D0Ev,_ZThn4612_N9S21070C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C12__9S21070C25[] = {
  ABISELECT(-7248,-4612),
  0,
  0,
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  ABISELECT(-7248,-4612),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C12__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-8176,-5160),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C12__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-8384,-5300),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C12__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-8592,-5456),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C12__9S21070C25[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-7360,-4668),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D1Ev,_ZTvn56_n32_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n64_N9S21070C12D0Ev,_ZTvn56_n32_N9S21070C12D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C12__9S21070C25[] = {
  ABISELECT(8240,5236),
  ABISELECT(7824,4940),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__A1__9S21070C12__9S21070C25[] = {
  ABISELECT(8032,5080),
  ABISELECT(7824,4924),
  ABISELECT(7616,4784),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D1Ev,_ZThn376_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N9S21070C12D0Ev,_ZThn376_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__9S21070C25[] = {
  ABISELECT(7920,5024),
  ABISELECT(7712,4868),
  ABISELECT(7504,4728),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D1Ev,_ZThn432_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N9S21070C12D0Ev,_ZThn432_N9S21070C12D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A6__9S21070C12__9S21070C25[] = {
  ABISELECT(6688,4236),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn8704_N9S21070C12D1Ev,_ZThn5512_N9S21070C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev)();
extern void ABISELECT(_ZThn8704_N9S21070C12D0Ev,_ZThn5512_N9S21070C12D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C12__9S21070C25[] = {
  0,
  ABISELECT(-8704,-5512),
  0,
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  ABISELECT(-8704,-5512),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A3__9S21070C12__9S21070C25[] = {
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  ABISELECT(-8816,-5568),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D1Ev,_ZTvn56_n28_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C12D0Ev,_ZTvn56_n28_N9S21070C12D0Ev),
};
extern void ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev)();
extern void ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C15__9S21070C12__9S21070C25[] = {
  ABISELECT(6736,4316),
  ABISELECT(6528,4160),
  ABISELECT(6320,4020),
  ABISELECT(5392,3472),
  ABISELECT(-1856,-1140),
  (VTBL_ENTRY)&(_ZTI9S21070C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D1Ev,_ZThn1140_N9S21070C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1856_N9S21070C12D0Ev,_ZThn1140_N9S21070C12D0Ev),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C20D1Ev();
extern void _ZN9S21070C20D0Ev();
extern void _ZN9S21070C203v20Ev();
extern void _ZN9S21070C203v21Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C20__9S21070C25[] = {
  ABISELECT(20560,12940),
  ABISELECT(17088,10712),
  ABISELECT(17056,10700),
  ABISELECT(6560,4152),
  ABISELECT(5488,3500),
  ABISELECT(6488,4108),
  ABISELECT(5280,3360),
  ABISELECT(5696,3656),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C20D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v20Ev,
  (VTBL_ENTRY)&_ZN9S21070C203v21Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(17056,10700),
  ABISELECT(6560,4152),
  ABISELECT(5488,3500),
  ABISELECT(6488,4108),
  ABISELECT(5280,3360),
  ABISELECT(5696,3656),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(6352,4012),
  ABISELECT(5280,3360),
  ABISELECT(6280,3968),
  ABISELECT(5072,3220),
  ABISELECT(5488,3516),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5488,-3516),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-5072,-3220),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(-6280,-3968),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5280,-3360),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn6352_N9S21070C17D1Ev,_ZThn4012_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn6352_N9S21070C17D0Ev,_ZThn4012_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-6352,-4012),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(-6352,-4012),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(-6560,-4152),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(6352,4012),
  ABISELECT(5280,3360),
  ABISELECT(6280,3968),
  ABISELECT(5072,3220),
  ABISELECT(5488,3516),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C219S21070C20__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5696,-3656),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C219S21070C20__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-5280,-3360),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(-6488,-4108),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5488,-3500),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn6560_N9S21070C21D1Ev,_ZThn4152_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn6560_N9S21070C21D0Ev,_ZThn4152_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-6560,-4152),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(-6560,-4152),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C219S21070C20__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(-6768,-4292),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C219S21070C20__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-17056,-10700),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C5D1Ev();
extern void _ZN8S21070C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(3568,2228),
  ABISELECT(3360,2072),
  ABISELECT(3152,1932),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C5D0Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C68S21070C59S21070C20__A5__9S21070C25[] = {
  ABISELECT(3568,2228),
  ABISELECT(3360,2072),
  ABISELECT(3152,1932),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C68S21070C59S21070C20__A10__9S21070C25[] = {
  ABISELECT(3152,1932),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C20__A10__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-3152,-1932),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C68S21070C59S21070C20__A5__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-3152,-1932),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C68S21070C59S21070C20__A5__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3360,-2072),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C20__A5__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3568,-2228),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C59S21070C20__A2__9S21070C25[] = {
  ABISELECT(3216,2008),
  ABISELECT(2800,1712),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C88S21070C59S21070C20__A2__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-2800,-1712),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C88S21070C59S21070C20__A2__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3216,-2008),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C59S21070C20__A2__9S21070C25[] = {
  ABISELECT(3008,1852),
  ABISELECT(2800,1696),
  ABISELECT(2592,1556),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C118S21070C59S21070C20__A11__9S21070C25[] = {
  ABISELECT(2592,1556),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C20__A11__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-2592,-1556),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[] = {
  ABISELECT(2896,1796),
  ABISELECT(2688,1640),
  ABISELECT(2480,1500),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C20__A12__9S21070C25[] = {
  ABISELECT(2480,1500),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C20__A12__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-2480,-1500),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-2480,-1500),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2688,-1640),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-2896,-1796),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C118S21070C59S21070C20__A2__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-2592,-1556),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C118S21070C59S21070C20__A2__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-2800,-1696),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C118S21070C59S21070C20__A2__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3008,-1852),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C118S21070C59S21070C20__A2__9S21070C25[] = {
  ABISELECT(2896,1796),
  ABISELECT(2688,1640),
  ABISELECT(2480,1500),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C59S21070C20__A13__9S21070C25[] = {
  ABISELECT(1664,1008),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C59S21070C20__A13__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-1664,-1008),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C59S21070C20__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-3152,-1932),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-3360,-2072),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C59S21070C20__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-3568,-2228),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__A__8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(3216,2008),
  ABISELECT(2800,1712),
  ABISELECT(-352,-220),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C11__8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(3008,1852),
  ABISELECT(2800,1696),
  ABISELECT(2592,1556),
  ABISELECT(-560,-376),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D1Ev,_ZThn376_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N8S21070C5D0Ev,_ZThn376_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev)();
extern void ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(2896,1796),
  ABISELECT(2688,1640),
  ABISELECT(2480,1500),
  ABISELECT(-672,-432),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D1Ev,_ZThn432_N8S21070C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn672_N8S21070C5D0Ev,_ZThn432_N8S21070C5D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A__8S21070C59S21070C20__A1__9S21070C25[] = {
  ABISELECT(1664,1008),
  ABISELECT(-1488,-924),
  (VTBL_ENTRY)&(_ZTI8S21070C5[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C20__9S21070C25[] = {
  ABISELECT(6352,4012),
  ABISELECT(5280,3360),
  ABISELECT(6280,3968),
  ABISELECT(5072,3220),
  ABISELECT(5488,3516),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D1Ev,_ZThn140_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C20D0Ev,_ZThn140_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C20__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5696,-3656),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C20__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-5280,-3360),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C20__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(-6488,-4108),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C20__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5488,-3500),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn6560_N9S21070C20D1Ev,_ZThn4152_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn6560_N9S21070C20D0Ev,_ZThn4152_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C20__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-6560,-4152),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(-6560,-4152),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C20__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(-6768,-4292),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D1Ev,_ZTvn140_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C20D0Ev,_ZTvn140_n40_N9S21070C20D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C20__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-17056,-10700),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C5__9S21070C20__9S21070C25[] = {
  ABISELECT(3568,2228),
  ABISELECT(3360,2072),
  ABISELECT(3152,1932),
  ABISELECT(-2128,-1428),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D1Ev,_ZThn1428_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2128_N9S21070C20D0Ev,_ZThn1428_N9S21070C20D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C88S21070C5__A1__9S21070C20__9S21070C25[] = {
  ABISELECT(3216,2008),
  ABISELECT(2800,1712),
  ABISELECT(-2480,-1648),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21070C118S21070C5__9S21070C20__9S21070C25[] = {
  ABISELECT(3008,1852),
  ABISELECT(2800,1696),
  ABISELECT(2592,1556),
  ABISELECT(-2688,-1804),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D1Ev,_ZThn1804_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2688_N9S21070C20D0Ev,_ZThn1804_N9S21070C20D0Ev),
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20__9S21070C25[] = {
  ABISELECT(2896,1796),
  ABISELECT(2688,1640),
  ABISELECT(2480,1500),
  ABISELECT(-2800,-1860),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D1Ev,_ZThn1860_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2800_N9S21070C20D0Ev,_ZThn1860_N9S21070C20D0Ev),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C5__A5__9S21070C20__9S21070C25[] = {
  ABISELECT(1664,1008),
  ABISELECT(-3616,-2352),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn17088_N9S21070C20D1Ev,_ZThn10712_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn17088_N9S21070C20D0Ev,_ZThn10712_N9S21070C20D0Ev)() __attribute__((weak));
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C23__9S21070C20__9S21070C25[] = {
  0,
  0,
  ABISELECT(-17088,-10712),
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-11600,-7212),
  ABISELECT(-10600,-6604),
  ABISELECT(-11808,-7352),
  ABISELECT(-11392,-7056),
  ABISELECT(3472,2228),
  ABISELECT(-17088,-10712),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZThn20560_N9S21070C20D1Ev,_ZThn12940_N9S21070C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev)();
extern void ABISELECT(_ZThn20560_N9S21070C20D0Ev,_ZThn12940_N9S21070C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C21__A1__9S21070C20__9S21070C25[] = {
  ABISELECT(208,140),
  ABISELECT(-20560,-12940),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-15072,-9440),
  ABISELECT(-14072,-8832),
  ABISELECT(-15280,-9580),
  ABISELECT(-14864,-9284),
  ABISELECT(-20560,-12940),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev),
};
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__A1__9S21070C20__9S21070C25[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-15280,-9580),
  ABISELECT(-14280,-8972),
  ABISELECT(-15488,-9720),
  ABISELECT(-15072,-9424),
  ABISELECT(-20768,-13080),
  (VTBL_ENTRY)&(_ZTI9S21070C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D1Ev,_ZTvn140_n48_N9S21070C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C20D0Ev,_ZTvn140_n48_N9S21070C20D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C112v7Ev();
extern void _ZN9S21070C11D1Ev();
extern void _ZN9S21070C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C11__9S21070C25[] = {
  ABISELECT(1344,844),
  ABISELECT(1136,688),
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C112v7Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C11D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C11__A1__9S21070C25[] = {
  ABISELECT(928,548),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C11__9S21070C25[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C25[] = {
  ABISELECT(816,492),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-816,-492),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1024,-632),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1232,-788),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C11__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(-928,-548),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C11__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-1136,-688),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C11__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1344,-844),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C11__9S21070C25[] = {
  ABISELECT(1232,788),
  ABISELECT(1024,632),
  ABISELECT(816,492),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C11[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D1Ev,_ZThn56_N9S21070C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C11D0Ev,_ZThn56_N9S21070C11D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C25[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C25[] = {
  ABISELECT(-112,-56),
  ABISELECT(-320,-212),
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C14__A7__9S21070C25[] = {
  ABISELECT(-528,-352),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C14__A7__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__A3__9S21070C25[] = {
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C14__A8__9S21070C25[] = {
  ABISELECT(-640,-408),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A8__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(640,408),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C14__A3__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(640,408),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C14__A3__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(432,268),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A3__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(224,112),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C14__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(528,352),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(320,212),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14__9S21070C25[] = {
  ABISELECT(-224,-112),
  ABISELECT(-432,-268),
  ABISELECT(-640,-408),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(1000,608),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(1208,748),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(792,452),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C25[] = {
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__A4__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A9__9S21070C25[] = {
  ABISELECT(-1488,-932),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A9__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(1488,932),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__A4__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(1488,932),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__A4__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(1280,792),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A4__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(1072,636),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(864,496),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(1280,792),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(1072,652),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(72,44),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
extern void _ZN9S21070C23D1Ev();
extern void _ZN9S21070C23D0Ev();
extern void _ZN9S21070C233v18Ev();
extern void _ZN9S21070C233v19Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C23__9S21070C25[] = {
  ABISELECT(-32,-12),
  ABISELECT(-10528,-6560),
  ABISELECT(-11600,-7212),
  ABISELECT(-10600,-6604),
  ABISELECT(-11808,-7352),
  ABISELECT(-11392,-7056),
  ABISELECT(3472,2228),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C23D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C23D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v18Ev,
  (VTBL_ENTRY)&_ZN9S21070C233v19Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev)();
extern void ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21070C21__9S21070C23__9S21070C25[] = {
  ABISELECT(208,140),
  ABISELECT(-3472,-2228),
  0,
  0,
  0,
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-15072,-9440),
  ABISELECT(-14072,-8832),
  ABISELECT(-15280,-9580),
  ABISELECT(-14864,-9284),
  ABISELECT(-3472,-2228),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev),
};
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C23__9S21070C25[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-15280,-9580),
  ABISELECT(-14280,-8972),
  ABISELECT(-15488,-9720),
  ABISELECT(-15072,-9424),
  ABISELECT(-3680,-2368),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D1Ev,_ZTvn140_n48_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n96_N9S21070C23D0Ev,_ZTvn140_n48_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C23__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(11392,7056),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C23__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(11808,7352),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C23__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(10600,6604),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C23__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(11600,7212),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C23__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(10528,6560),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(10528,6560),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D1Ev,_ZTv0_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C23D0Ev,_ZTv0_n40_N9S21070C23D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C23__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(10320,6420),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D1Ev,_ZTvn140_n40_N9S21070C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C23D0Ev,_ZTvn140_n40_N9S21070C23D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C23__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S21070C23[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__A1__9S21070C25[] = {
  ABISELECT(-3504,-2240),
  ABISELECT(-14000,-8788),
  ABISELECT(-15072,-9440),
  ABISELECT(-14072,-8832),
  ABISELECT(-15280,-9580),
  ABISELECT(-14864,-9284),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__A1__9S21070C25[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-15280,-9580),
  ABISELECT(-14280,-8972),
  ABISELECT(-15488,-9720),
  ABISELECT(-15072,-9424),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(15072,9424),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(15488,9720),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__A1__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(14280,8972),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__A1__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(15280,9580),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__A1__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14208,8928),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(14208,8928),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A1__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__A1__9S21070C25[] = {
  ABISELECT(-14208,-8928),
  ABISELECT(-15280,-9580),
  ABISELECT(-14280,-8972),
  ABISELECT(-15488,-9720),
  ABISELECT(-15072,-9424),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__A1__9S21070C25[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(14864,9284),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(15280,9580),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__A1__9S21070C25[] = {
  ABISELECT(-792,-452),
  ABISELECT(-1208,-748),
  ABISELECT(-1000,-608),
  ABISELECT(14072,8832),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__A1__9S21070C25[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(15072,9440),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__A1__9S21070C25[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(14000,8788),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-1072,-652),
  ABISELECT(-1280,-792),
  ABISELECT(-864,-496),
  ABISELECT(14000,8788),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__A1__9S21070C25[] = {
  ABISELECT(-1072,-636),
  ABISELECT(-1280,-792),
  ABISELECT(-1488,-932),
  ABISELECT(13792,8648),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__A1__9S21070C25[] = {
  0,
  0,
  0,
  ABISELECT(3504,2240),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
static  VTT_ENTRY vtt_S21070C25[] = {
  {&(_ZTV9S21070C25[12]),  12,275},
  {&(_tg__ZTV9S21070C12__9S21070C25[7]),  7,11},
  {&(_tg__ZTV8S21070C59S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C59S21070C12__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C59S21070C12__A3__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C12__A3__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C59S21070C12__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C59S21070C12__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C12__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C12__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C59S21070C12__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C59S21070C12__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C59S21070C12__A1__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C59S21070C12__A4__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C12__A4__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C12__A5__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C12__A5__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C12__A2__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C59S21070C12__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C59S21070C12__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C59S21070C12__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C59S21070C12__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C12__A6__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C59S21070C12__A6__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C59S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C59S21070C12__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C59S21070C12__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C59S21070C12__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C59S21070C12__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C59S21070C12__9S21070C25[3]),  3,4},
  {&(_tg__ZTV9S21070C159S21070C12__9S21070C25[6]),  6,8},
  {&(_tg__ZTV9S21070C11__9S21070C159S21070C12__9S21070C25[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C159S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C159S21070C12__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C159S21070C12__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C159S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C11__9S21070C12__9S21070C25[8]),  8,12},
  {&(_tg__ZTV8S21070C4__9S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C12__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C12__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C12__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__A1__9S21070C12__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A6__9S21070C12__9S21070C25[3]),  3,4},
  {&(_tg__ZTV9S21070C14__9S21070C12__9S21070C25[8]),  8,12},
  {&(_tg__ZTV8S21070C69S21070C14__A3__9S21070C12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C15__9S21070C12__9S21070C25[6]),  6,8},
  {&(_tg__ZTV9S21070C20__9S21070C25[10]),  10,17},
  {&(_tg__ZTV9S21070C219S21070C20__9S21070C25[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C219S21070C20__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C219S21070C20__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C219S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C219S21070C20__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C219S21070C20__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C219S21070C20__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C219S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C219S21070C20__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C219S21070C20__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C219S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C219S21070C20__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C219S21070C20__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C219S21070C20__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C219S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C219S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C59S21070C20__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C68S21070C59S21070C20__A5__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C68S21070C59S21070C20__A10__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C68S21070C59S21070C20__A10__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C68S21070C59S21070C20__A5__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C68S21070C59S21070C20__A5__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C68S21070C59S21070C20__A5__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C88S21070C59S21070C20__A2__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C88S21070C59S21070C20__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C88S21070C59S21070C20__A2__9S21070C25[4]),  4,5},
  {&(_tg__ZTV9S21070C118S21070C59S21070C20__A2__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C118S21070C59S21070C20__A11__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C118S21070C59S21070C20__A11__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C118S21070C59S21070C20__A12__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C118S21070C59S21070C20__A12__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C118S21070C59S21070C20__A6__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C118S21070C59S21070C20__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C118S21070C59S21070C20__A2__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C118S21070C59S21070C20__A2__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C118S21070C59S21070C20__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C59S21070C20__A13__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C59S21070C20__A13__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C59S21070C20__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C59S21070C20__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C59S21070C20__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C8__A__8S21070C59S21070C20__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C11__8S21070C59S21070C20__A1__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C11__A1__8S21070C59S21070C20__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__A__8S21070C59S21070C20__A1__9S21070C25[3]),  3,4},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C20__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C20__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C20__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C20__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C20__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C5__9S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C88S21070C5__A1__9S21070C20__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C118S21070C5__9S21070C20__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C69S21070C118S21070C5__A2__9S21070C20__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C5__A5__9S21070C20__9S21070C25[3]),  3,4},
  {&(_tg__ZTV9S21070C23__9S21070C20__9S21070C25[12]),  12,16},
  {&(_tg__ZTV9S21070C21__A1__9S21070C20__9S21070C25[13]),  13,18},
  {&(_tg__ZTV9S21070C179S21070C21__A1__9S21070C20__9S21070C25[7]),  7,10},
  {&(_ZTV9S21070C25[139]),  139,275},
  {&(_ZTV9S21070C25[156]),  156,275},
  {&(_ZTV9S21070C25[163]),  163,275},
  {&(_ZTV9S21070C25[167]),  167,275},
  {&(_ZTV9S21070C25[148]),  148,275},
  {&(_ZTV9S21070C25[27]),  27,275},
  {&(_ZTV9S21070C25[32]),  32,275},
  {&(_ZTV9S21070C25[41]),  41,275},
  {&(_ZTV9S21070C25[47]),  47,275},
  {&(_ZTV9S21070C25[176]),  176,275},
  {&(_ZTV9S21070C25[185]),  185,275},
  {&(_ZTV9S21070C25[54]),  54,275},
  {&(_ZTV9S21070C25[66]),  66,275},
  {&(_ZTV9S21070C25[80]),  80,275},
  {&(_ZTV9S21070C25[193]),  193,275},
  {&(_ZTV9S21070C25[207]),  207,275},
  {&(_ZTV9S21070C25[220]),  220,275},
  {&(_ZTV9S21070C25[228]),  228,275},
  {&(_ZTV9S21070C25[88]),  88,275},
  {&(_ZTV9S21070C25[100]),  100,275},
  {&(_ZTV9S21070C25[105]),  105,275},
  {&(_ZTV9S21070C25[114]),  114,275},
  {&(_ZTV9S21070C25[120]),  120,275},
  {&(_ZTV9S21070C25[243]),  243,275},
  {&(_ZTV9S21070C25[260]),  260,275},
  {&(_ZTV9S21070C25[272]),  272,275},
  {&(_tg__ZTV9S21070C11__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C11__A1__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C11__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C11__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C11__A2__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C11__A2__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C11__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C11__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C11__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C11__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C11__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__9S21070C11__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C11__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C14__9S21070C25[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C14__A7__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C14__A7__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C14__A3__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C14__A8__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A8__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C14__A3__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C14__A3__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C14__A3__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C14__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C14__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C14__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C25[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C25[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__A4__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A9__9S21070C25[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A9__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__A4__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__A4__9S21070C25[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A4__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C25[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C25[5]),  5,5},
  {&(_tg__ZTV9S21070C23__9S21070C25[9]),  9,13},
  {&(_tg__ZTV9S21070C21__9S21070C23__9S21070C25[13]),  13,18},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C23__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C23__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C23__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C23__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C23__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C23__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C23__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C23__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C21__A1__9S21070C25[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__A1__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__A1__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__A1__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__A1__9S21070C25[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__A1__9S21070C25[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__A1__9S21070C25[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__A1__9S21070C25[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__A1__9S21070C25[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__A1__9S21070C25[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__A1__9S21070C25[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S21070C25[];
extern  VTBL_ENTRY _ZTV9S21070C25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C25[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D0Ev,_ZTv0_n48_N9S21070C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D0Ev,_ZThn2228_N9S21070C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C23D1Ev,_ZTv0_n48_N9S21070C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3472_N9S21070C23D1Ev,_ZThn2228_N9S21070C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D0Ev,_ZTv0_n48_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20560_N9S21070C20D0Ev,_ZThn12940_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C20D1Ev,_ZTv0_n48_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20560_N9S21070C20D1Ev,_ZThn12940_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D0Ev,_ZTv0_n40_N9S21070C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17088_N9S21070C20D0Ev,_ZThn10712_N9S21070C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6560_N9S21070C20D0Ev,_ZThn4152_N9S21070C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C20D1Ev,_ZTv0_n40_N9S21070C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17088_N9S21070C20D1Ev,_ZThn10712_N9S21070C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6560_N9S21070C20D1Ev,_ZThn4152_N9S21070C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6560_N9S21070C21D0Ev,_ZThn4152_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6560_N9S21070C21D1Ev,_ZThn4152_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S21070C17D0Ev,_ZThn4012_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6352_N9S21070C17D1Ev,_ZThn4012_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D0Ev,_ZTv0_n28_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8704_N9S21070C12D0Ev,_ZThn5512_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C12D1Ev,_ZTv0_n28_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8704_N9S21070C12D1Ev,_ZThn5512_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D0Ev,_ZTv0_n32_N9S21070C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7248_N9S21070C12D0Ev,_ZThn4612_N9S21070C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C12D1Ev,_ZTv0_n32_N9S21070C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7248_N9S21070C12D1Ev,_ZThn4612_N9S21070C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D0Ev,_ZTv0_n32_N9S21070C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5392_N9S21070C15D0Ev,_ZThn3472_N9S21070C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C15D1Ev,_ZTv0_n32_N9S21070C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5392_N9S21070C15D1Ev,_ZThn3472_N9S21070C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C25D0Ev,_ZTv0_n48_N9S21070C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23456_N9S21070C25D0Ev,_ZThn14740_N9S21070C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S21070C25D1Ev,_ZTv0_n48_N9S21070C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23456_N9S21070C25D1Ev,_ZThn14740_N9S21070C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C25D0Ev,_ZTv0_n40_N9S21070C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19984_N9S21070C25D0Ev,_ZThn12512_N9S21070C25D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn9456_N9S21070C25D0Ev,_ZThn5952_N9S21070C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C25D1Ev,_ZTv0_n40_N9S21070C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn19984_N9S21070C25D1Ev,_ZThn12512_N9S21070C25D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn9456_N9S21070C25D1Ev,_ZThn5952_N9S21070C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C25D0Ev,_ZTv0_n28_N9S21070C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8704_N9S21070C25D0Ev,_ZThn5512_N9S21070C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C25D1Ev,_ZTv0_n28_N9S21070C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8704_N9S21070C25D1Ev,_ZThn5512_N9S21070C25D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C25D0Ev,_ZTv0_n32_N9S21070C25D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7248_N9S21070C25D0Ev,_ZThn4612_N9S21070C25D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N9S21070C25D1Ev,_ZTv0_n32_N9S21070C25D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7248_N9S21070C25D1Ev,_ZThn4612_N9S21070C25D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C25 = {  "S21070C25", // class name
  bases_S21070C25, 50,
  &(vtc_S21070C25[0]), // expected_vtbl_contents
  &(vtt_S21070C25[0]), // expected_vtt_contents
  ABISELECT(25584,16168), // object size
  NSPAIRA(_ZTI9S21070C25),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21070C25),275, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C25),216, //virtual table table var
  49, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C29  : virtual S21070C24 , virtual S21070C14 , S21070C21 {
  __tsi64 s21070c29f0[4];
  int s21070c29f1;
  __tsi64 s21070c29f2;
  int s21070c29f3;
  int s21070c29f4;
  int s21070c29f5;
  int s21070c29f6;
  virtual  ~S21070C29(); // _ZN9S21070C29D2Ev
  virtual void  v27(); // _ZN9S21070C293v27Ev
  S21070C29(); // tgen
};
//SIG(-1 S21070C29) C1{ VBC2{ m Fc FU3{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs}[9] Fp FC4{ VBC5{ v2 v3 v4 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC6{ VBC5 v5 Fi Fp[8] FL Fi Fl} VBC7{ VBC5 VBC6 Fc FU3 Fi FC8{} Fp FU3 Fi Fi[3]} BC9{ VBC5 BC6 VBC7 vd FL Fi FD} vd v6 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC6 Fi} Fp FL Fp[9] FL} VBC4 BC10{ BC5 BC11{ VBC6 VBC12{ VBC7 FL Fp Fc Fi Fp[3] FL} VBC13{ VBC6 BC5 BC9 VBC12 vd v7 v8 v9 Fi Fi FC14{ BC9 BC5 BC7 BC15{ VBC5 VBC7 BC6 BC9 v14 Fi Fp FC6 Fi[2] Fp[3] Fc FL Fp[9] FC5} BC6 vd Fs FC8 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC5 FL[9] FC15 Fc FL FC15} vd v10 FL Fp FC5[9] Fc} VBC16{ v11 v12 v13 Fp Fi} vd FL:3 FL} vd v1 FL[4] Fi FL Fi Fi Fi Fi}


 S21070C29 ::~S21070C29(){ note_dtor("S21070C29", this);}
void  S21070C29 ::v27(){vfunc_called(this, "_ZN9S21070C293v27Ev");}
S21070C29 ::S21070C29(){ note_ctor("S21070C29", this);} // tgen

static void Test_S21070C29()
{
  extern Class_Descriptor cd_S21070C29;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1005,2549)];
    init_test(&cd_S21070C29, buf);
    S21070C29 *dp, &lv = *(dp=new (buf) S21070C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16064,10192), "sizeof(S21070C29)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C29)");
    check_base_class_offset(lv, (S21070C24*), ABISELECT(2192,1488), "S21070C29");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(4944,3236), "S21070C29");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(4944,3236), "S21070C29");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(4944,3236), "S21070C29");
    /*is_ambiguous_... S21070C29::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(4944,3236), "S21070C29");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(4944,3236), "S21070C29");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(4944,3236), "S21070C29");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(4944,3236), "S21070C29");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(4944,3236), "S21070C29");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(4256,2840), "S21070C29");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(5360,3532), "S21070C29");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*), ABISELECT(5360,3532), "S21070C29");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(5360,3532), "S21070C29");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(5152,3376), "S21070C29");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(5152,3376), "S21070C29");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(5152,3376), "S21070C29");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(5152,3376), "S21070C29");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(4368,2896), "S21070C29");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(4368,2896), "S21070C29");
    check_base_class_offset(lv, (S21070C14*), ABISELECT(4256,2840), "S21070C29");
    /*is_ambiguous_... S21070C21::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*), 0, "S21070C29");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*), ABISELECT(5464,3588), "S21070C29");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(5464,3588), "S21070C29");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(5536,3632), "S21070C29");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(5744,3772), "S21070C29");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(5744,3772), "S21070C29");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*), ABISELECT(5536,3632), "S21070C29");
    check_base_class_offset(lv, (S21070C17*)(S21070C21*), ABISELECT(208,140), "S21070C29");
    check_base_class_offset(lv, (S21070C22*)(S21070C21*), ABISELECT(16032,10180), "S21070C29");
    check_base_class_offset(lv, (S21070C21*), 0, "S21070C29");
    check_field_offset(lv, s21070c29f0, ABISELECT(2128,1428), "S21070C29.s21070c29f0");
    check_field_offset(lv, s21070c29f1, ABISELECT(2160,1460), "S21070C29.s21070c29f1");
    check_field_offset(lv, s21070c29f2, ABISELECT(2168,1464), "S21070C29.s21070c29f2");
    check_field_offset(lv, s21070c29f3, ABISELECT(2176,1472), "S21070C29.s21070c29f3");
    check_field_offset(lv, s21070c29f4, ABISELECT(2180,1476), "S21070C29.s21070c29f4");
    check_field_offset(lv, s21070c29f5, ABISELECT(2184,1480), "S21070C29.s21070c29f5");
    check_field_offset(lv, s21070c29f6, ABISELECT(2188,1484), "S21070C29.s21070c29f6");
    test_class_info(&lv, &cd_S21070C29);
    dp->~S21070C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C29(Test_S21070C29, "S21070C29", ABISELECT(16064,10192));

#else // __cplusplus

extern void _ZN9S21070C29C1Ev();
extern void _ZN9S21070C29D2Ev();
Name_Map name_map_S21070C29[] = {
  NSPAIR(_ZN9S21070C29C1Ev),
  NSPAIR(_ZN9S21070C29D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C24;
extern VTBL_ENTRY _ZTI9S21070C24[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
static Base_Class bases_S21070C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C24,    ABISELECT(2192,1488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C4,    ABISELECT(4944,3236), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4256,2840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5360,3532), //bcp->offset
    58, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(5152,3376), //bcp->offset
    54, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4368,2896), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4368,2896), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(4256,2840), //bcp->offset
    26, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C18,    ABISELECT(5464,3588), //bcp->offset
    63, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(5536,3632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5744,3772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(5744,3772), //bcp->offset
    90, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(5536,3632), //bcp->offset
    68, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(208,140), //bcp->offset
    16, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21070C22,    ABISELECT(16032,10180), //bcp->offset
    98, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S21070C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C29[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C29D1Ev();
extern void _ZN9S21070C29D0Ev();
extern void _ZN9S21070C293v27Ev();
extern void ABISELECT(_ZThn208_N9S21070C29D1Ev,_ZThn140_N9S21070C29D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C29D0Ev,_ZThn140_N9S21070C29D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C29D1Ev,_ZTv0_n28_N9S21070C29D1Ev)();
extern void ABISELECT(_ZThn4256_N9S21070C29D1Ev,_ZThn2840_N9S21070C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C29D0Ev,_ZTv0_n28_N9S21070C29D0Ev)();
extern void ABISELECT(_ZThn4256_N9S21070C29D0Ev,_ZThn2840_N9S21070C29D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C29D1Ev,_ZTvn56_n28_N9S21070C29D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C29D0Ev,_ZTvn56_n28_N9S21070C29D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C29D1Ev,_ZTv0_n40_N9S21070C29D1Ev)();
extern void ABISELECT(_ZThn5536_N9S21070C29D1Ev,_ZThn3632_N9S21070C29D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C29D0Ev,_ZTv0_n40_N9S21070C29D0Ev)();
extern void ABISELECT(_ZThn5536_N9S21070C29D0Ev,_ZThn3632_N9S21070C29D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C29D1Ev,_ZTvn140_n40_N9S21070C29D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C29D0Ev,_ZTvn140_n40_N9S21070C29D0Ev)();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY vtc_S21070C29[] = {
  ABISELECT(4256,2840),
  ABISELECT(2192,1488),
  ABISELECT(16032,10180),
  ABISELECT(5536,3632),
  ABISELECT(5152,3376),
  ABISELECT(5464,3588),
  ABISELECT(4944,3236),
  ABISELECT(5360,3532),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C29D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C293v27Ev,
  ABISELECT(5328,3492),
  ABISELECT(4944,3236),
  ABISELECT(5256,3448),
  ABISELECT(4736,3096),
  ABISELECT(5152,3392),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C29D1Ev,_ZThn140_N9S21070C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C29D0Ev,_ZThn140_N9S21070C29D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
  0,
  ABISELECT(-4256,-2840),
  0,
  ABISELECT(1104,692),
  ABISELECT(896,536),
  ABISELECT(688,396),
  ABISELECT(-4256,-2840),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C29D1Ev,_ZTv0_n28_N9S21070C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S21070C29D0Ev,_ZTv0_n28_N9S21070C29D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
  ABISELECT(992,636),
  ABISELECT(784,480),
  ABISELECT(576,340),
  ABISELECT(-4368,-2896),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C29D1Ev,_ZTvn56_n28_N9S21070C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n56_N9S21070C29D0Ev,_ZTvn56_n28_N9S21070C29D0Ev),
  0,
  0,
  0,
  ABISELECT(-4944,-3236),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5152,-3376),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5360,-3532),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  ABISELECT(-104,-56),
  ABISELECT(-520,-352),
  ABISELECT(-312,-212),
  ABISELECT(-5464,-3588),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-5536,-3632),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-384,-256),
  ABISELECT(-592,-396),
  ABISELECT(-176,-100),
  ABISELECT(-5536,-3632),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C29D1Ev,_ZTv0_n40_N9S21070C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C29D0Ev,_ZTv0_n40_N9S21070C29D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
  ABISELECT(-384,-240),
  ABISELECT(-592,-396),
  ABISELECT(-800,-536),
  ABISELECT(-5744,-3772),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C29D1Ev,_ZTvn140_n40_N9S21070C29D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C29D0Ev,_ZTvn140_n40_N9S21070C29D0Ev),
  0,
  0,
  0,
  ABISELECT(-16032,-10180),
  (VTBL_ENTRY)&(_ZTI9S21070C29[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern VTBL_ENTRY _ZTV9S21070C29[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C21D1Ev();
extern void _ZN9S21070C21D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C21__9S21070C29[] = {
  ABISELECT(16032,10180),
  ABISELECT(5536,3632),
  ABISELECT(5152,3376),
  ABISELECT(5464,3588),
  ABISELECT(4944,3236),
  ABISELECT(5360,3532),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C21D0Ev,
};
extern void _ZN9S21070C17D1Ev();
extern void _ZN9S21070C17D0Ev();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C179S21070C21__9S21070C29[] = {
  ABISELECT(5328,3492),
  ABISELECT(4944,3236),
  ABISELECT(5256,3448),
  ABISELECT(4736,3096),
  ABISELECT(5152,3392),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN9S21070C17D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C17D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5152,-3392),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-4736,-3096),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C29[] = {
  ABISELECT(-104,-56),
  ABISELECT(-520,-352),
  ABISELECT(-312,-212),
  ABISELECT(-5256,-3448),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-4944,-3236),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZThn5328_N9S21070C17D1Ev,_ZThn3492_N9S21070C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev)();
extern void ABISELECT(_ZThn5328_N9S21070C17D0Ev,_ZThn3492_N9S21070C17D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C29[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-5328,-3492),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-384,-256),
  ABISELECT(-592,-396),
  ABISELECT(-176,-100),
  ABISELECT(-5328,-3492),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C29[] = {
  ABISELECT(-384,-240),
  ABISELECT(-592,-396),
  ABISELECT(-800,-536),
  ABISELECT(-5536,-3632),
  (VTBL_ENTRY)&(_ZTI9S21070C17[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D1Ev,_ZTvn140_n40_N9S21070C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C17D0Ev,_ZTvn140_n40_N9S21070C17D0Ev),
};
extern void ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev)();
extern void _ZN9S21070C173v13Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C17__9S21070C21__9S21070C29[] = {
  ABISELECT(5328,3492),
  ABISELECT(4944,3236),
  ABISELECT(5256,3448),
  ABISELECT(4736,3096),
  ABISELECT(5152,3392),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D1Ev,_ZThn140_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C21D0Ev,_ZThn140_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C173v13Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C21__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-5360,-3532),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__A1__9S21070C21__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-4944,-3236),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C21__9S21070C29[] = {
  ABISELECT(-104,-56),
  ABISELECT(-520,-352),
  ABISELECT(-312,-212),
  ABISELECT(-5464,-3588),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C21__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-5152,-3376),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZThn5536_N9S21070C21D1Ev,_ZThn3632_N9S21070C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev)();
extern void ABISELECT(_ZThn5536_N9S21070C21D0Ev,_ZThn3632_N9S21070C21D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C21__9S21070C29[] = {
  ABISELECT(208,140),
  0,
  0,
  0,
  ABISELECT(-5536,-3632),
  0,
  0,
  0,
  ABISELECT(-72,-44),
  ABISELECT(-384,-256),
  ABISELECT(-592,-396),
  ABISELECT(-176,-100),
  ABISELECT(-5536,-3632),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev),
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__9S21070C21__9S21070C29[] = {
  ABISELECT(-384,-240),
  ABISELECT(-592,-396),
  ABISELECT(-800,-536),
  ABISELECT(-5744,-3772),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D1Ev,_ZTvn140_n40_N9S21070C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn208_n80_N9S21070C21D0Ev,_ZTvn140_n40_N9S21070C21D0Ev),
};
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C22__9S21070C21__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-16032,-10180),
  (VTBL_ENTRY)&(_ZTI9S21070C21[0]),
  (VTBL_ENTRY)&_ZN9S21070C223v15Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v16Ev,
  (VTBL_ENTRY)&_ZN9S21070C223v17Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN9S21070C14D1Ev();
extern void _ZN9S21070C14D0Ev();
extern void _ZN9S21070C142v8Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C14__9S21070C29[] = {
  ABISELECT(1104,692),
  ABISELECT(896,536),
  ABISELECT(688,396),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C142v8Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C79S21070C14__9S21070C29[] = {
  ABISELECT(688,396),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C79S21070C14__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-688,-396),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C14__9S21070C29[] = {
  ABISELECT(992,636),
  ABISELECT(784,480),
  ABISELECT(576,340),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C14__A2__9S21070C29[] = {
  ABISELECT(576,340),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A2__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-576,-340),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C14__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-576,-340),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C14__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-784,-480),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C14__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-992,-636),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C14__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(-688,-396),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C14__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(-896,-536),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C14__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-1104,-692),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C14__9S21070C29[] = {
  ABISELECT(992,636),
  ABISELECT(784,480),
  ABISELECT(576,340),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S21070C14[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D1Ev,_ZThn56_N9S21070C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21070C14D0Ev,_ZThn56_N9S21070C14D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C8__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(208,140),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__8S21070C8__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21070C8[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__9S21070C29[] = {
  ABISELECT(-416,-296),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C7__A1__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(416,296),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C29[] = {
  ABISELECT(-104,-56),
  ABISELECT(-520,-352),
  ABISELECT(-312,-212),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C18__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(312,212),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C18__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(520,352),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C18__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI9S21070C18[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C19D1Ev();
extern void _ZN9S21070C19D0Ev();
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
static  VTBL_ENTRY _tg__ZTV9S21070C19__9S21070C29[] = {
  ABISELECT(-72,-44),
  ABISELECT(-384,-256),
  ABISELECT(-592,-396),
  ABISELECT(-176,-100),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v10Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v11Ev,
  (VTBL_ENTRY)&_ZN9S21070C193v12Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C6D1Ev();
extern void _ZN8S21070C6D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C69S21070C19__A1__9S21070C29[] = {
  ABISELECT(-384,-240),
  ABISELECT(-592,-396),
  ABISELECT(-800,-536),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21070C6D0Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C78S21070C69S21070C19__A3__9S21070C29[] = {
  ABISELECT(-800,-536),
  0,
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A3__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(800,536),
  (VTBL_ENTRY)&(_ZTI8S21070C7[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__8S21070C69S21070C19__A1__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(800,536),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__8S21070C69S21070C19__A1__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(592,396),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A1__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(384,240),
  (VTBL_ENTRY)&(_ZTI8S21070C6[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C72v6Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C7__9S21070C19__9S21070C29[] = {
  0,
  ABISELECT(-416,-296),
  ABISELECT(176,100),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
};
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
static  VTBL_ENTRY _tg__ZTV8S21070C4__9S21070C19__9S21070C29[] = {
  0,
  0,
  0,
  ABISELECT(592,396),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
};
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21070C6__9S21070C19__9S21070C29[] = {
  ABISELECT(-384,-240),
  ABISELECT(-592,-396),
  ABISELECT(-800,-536),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
  (VTBL_ENTRY)&_ZN8S21070C72v6Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D1Ev,_ZThn140_N9S21070C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C19D0Ev,_ZThn140_N9S21070C19D0Ev),
};
static  VTBL_ENTRY _tg__ZTV8S21070C8__9S21070C19__9S21070C29[] = {
  ABISELECT(208,156),
  ABISELECT(-208,-140),
  ABISELECT(384,256),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTBL_ENTRY _tg__ZTV9S21070C18__9S21070C19__9S21070C29[] = {
  ABISELECT(-104,-56),
  ABISELECT(-520,-352),
  ABISELECT(-312,-212),
  ABISELECT(72,44),
  (VTBL_ENTRY)&(_ZTI9S21070C19[0]),
};
static  VTT_ENTRY vtt_S21070C29[] = {
  {&(_ZTV9S21070C29[10]),  10,106},
  {&(_tg__ZTV9S21070C21__9S21070C29[8]),  8,13},
  {&(_tg__ZTV9S21070C179S21070C21__9S21070C29[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C179S21070C21__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C179S21070C21__9S21070C29[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C179S21070C21__9S21070C29[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C179S21070C21__9S21070C29[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C179S21070C21__9S21070C29[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C179S21070C21__9S21070C29[5]),  5,8},
  {&(_tg__ZTV9S21070C17__9S21070C21__9S21070C29[7]),  7,10},
  {&(_tg__ZTV8S21070C7__9S21070C21__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C4__A1__9S21070C21__9S21070C29[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C21__9S21070C29[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C21__9S21070C29[4]),  4,4},
  {&(_tg__ZTV9S21070C19__9S21070C21__9S21070C29[14]),  14,22},
  {&(_tg__ZTV8S21070C69S21070C19__9S21070C21__9S21070C29[5]),  5,8},
  {&(_tg__ZTV9S21070C22__9S21070C21__9S21070C29[5]),  5,8},
  {&(_ZTV9S21070C29[34]),  34,106},
  {&(_ZTV9S21070C29[51]),  51,106},
  {&(_ZTV9S21070C29[58]),  58,106},
  {&(_ZTV9S21070C29[62]),  62,106},
  {&(_ZTV9S21070C29[43]),  43,106},
  {&(_ZTV9S21070C29[23]),  23,106},
  {&(_ZTV9S21070C29[68]),  68,106},
  {&(_ZTV9S21070C29[82]),  82,106},
  {&(_ZTV9S21070C29[95]),  95,106},
  {&(_ZTV9S21070C29[103]),  103,106},
  {&(_tg__ZTV9S21070C14__9S21070C29[5]),  5,9},
  {&(_tg__ZTV8S21070C79S21070C14__9S21070C29[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C79S21070C14__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C69S21070C14__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C14__A2__9S21070C29[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C14__A2__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C14__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C14__9S21070C29[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C14__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C14__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C14__9S21070C29[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__9S21070C14__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C6__9S21070C14__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C29[4]),  4,4},
  {&(_tg__ZTV8S21070C4__8S21070C8__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C7__8S21070C8__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C7__A1__9S21070C29[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C7__A1__9S21070C29[5]),  5,8},
  {&(_tg__ZTV9S21070C18__9S21070C29[5]),  5,5},
  {&(_tg__ZTV8S21070C8__9S21070C18__9S21070C29[4]),  4,4},
  {&(_tg__ZTV8S21070C4__9S21070C18__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C7__9S21070C18__9S21070C29[4]),  4,5},
  {&(_tg__ZTV9S21070C19__9S21070C29[6]),  6,14},
  {&(_tg__ZTV8S21070C69S21070C19__A1__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C78S21070C69S21070C19__A3__9S21070C29[3]),  3,4},
  {&(_tg__ZTV8S21070C4__8S21070C78S21070C69S21070C19__A3__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C4__8S21070C69S21070C19__A1__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C8__8S21070C69S21070C19__A1__9S21070C29[4]),  4,4},
  {&(_tg__ZTV8S21070C7__A1__8S21070C69S21070C19__A1__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C7__9S21070C19__9S21070C29[4]),  4,5},
  {&(_tg__ZTV8S21070C4__9S21070C19__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C6__9S21070C19__9S21070C29[5]),  5,8},
  {&(_tg__ZTV8S21070C8__9S21070C19__9S21070C29[4]),  4,4},
  {&(_tg__ZTV9S21070C18__9S21070C19__9S21070C29[5]),  5,5},
};
extern VTBL_ENTRY _ZTI9S21070C29[];
extern  VTBL_ENTRY _ZTV9S21070C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C29[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D0Ev,_ZTv0_n40_N9S21070C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5536_N9S21070C21D0Ev,_ZThn3632_N9S21070C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C21D1Ev,_ZTv0_n40_N9S21070C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5536_N9S21070C21D1Ev,_ZThn3632_N9S21070C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D0Ev,_ZTv0_n40_N9S21070C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5328_N9S21070C17D0Ev,_ZThn3492_N9S21070C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C17D1Ev,_ZTv0_n40_N9S21070C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5328_N9S21070C17D1Ev,_ZThn3492_N9S21070C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C29D0Ev,_ZTv0_n40_N9S21070C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5536_N9S21070C29D0Ev,_ZThn3632_N9S21070C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21070C29D1Ev,_ZTv0_n40_N9S21070C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5536_N9S21070C29D1Ev,_ZThn3632_N9S21070C29D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C29D0Ev,_ZTv0_n28_N9S21070C29D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4256_N9S21070C29D0Ev,_ZThn2840_N9S21070C29D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S21070C29D1Ev,_ZTv0_n28_N9S21070C29D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4256_N9S21070C29D1Ev,_ZThn2840_N9S21070C29D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21070C29 = {  "S21070C29", // class name
  bases_S21070C29, 17,
  &(vtc_S21070C29[0]), // expected_vtbl_contents
  &(vtt_S21070C29[0]), // expected_vtt_contents
  ABISELECT(16064,10192), // object size
  NSPAIRA(_ZTI9S21070C29),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S21070C29),106, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21070C29),61, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21070C28  : S21070C13 , virtual S21070C22 , S21070C29 , S21070C26 {
  ::S21070C4 s21070c28f0;
  int s21070c28f1;
  __tsi64 s21070c28f2;
  void *s21070c28f3[8];
  __tsi64 s21070c28f4;
  int s21070c28f5;
  ::S21070C13 s21070c28f6;
  ::S21070C27 s21070c28f7;
  int s21070c28f8;
  virtual void  v28(); // _ZN9S21070C283v28Ev
  virtual void  v29(); // _ZN9S21070C283v29Ev
  ~S21070C28(); // tgen
  S21070C28(); // tgen
};
//SIG(-1 S21070C28) C1{ BC2{ m FU3{ m FD FD FL[6] Fp Fp Fc FD[5] FD Fp Fp Fs}} VBC4{ v3 v4 v5 Fp Fi} BC5{ VBC6{ m Fc FU3[9] Fp FC7{ VBC8{ v6 v7 v8 Fi Fs Fp[2] FD[8] Fp Fs Fl Fc Fi[2]} BC9{ VBC8 v9 Fi Fp[8] FL Fi Fl} VBC10{ VBC8 VBC9 Fc FU3 Fi FC11{} Fp FU3 Fi Fi[3]} BC12{ VBC8 BC9 VBC10 vd FL Fi FD} vd v10 Fp Fp FL Fc Fp Fp FL[3] Fp Fc Fc FC9 Fi} Fp FL Fp[9] FL} VBC7 BC13{ BC8 BC14{ VBC9 VBC15{ VBC10 FL Fp Fc Fi Fp[3] FL} VBC16{ VBC9 BC8 BC12 VBC15 vd v11 v12 v13 Fi Fi FC17{ BC12 BC8 BC10 BC18{ VBC8 VBC10 BC9 BC12 v19 Fi Fp FC9 Fi[2] Fp[3] Fc FL Fp[9] FC8} BC9 vd Fs FC11 Fi FD Fp[8] Fp[10] Fs:3 Fp}[3] FC8 FL[9] FC18 Fc FL FC18} vd v14 FL Fp FC8[9] Fc} VBC4 vd FL:3 FL} vd v15 FL[4] Fi FL Fi Fi Fi Fi} BC19{ v16 v17 v18 Fi Fi:32 Fp Fi FL FU20{ m Fl Fp Fl Fc[9] Fp FL FL[3]} Fs[2] Fp Fi} v1 v2 FC8 Fi FL Fp[8] FL Fi FC2 FU20 Fi}


void  S21070C28 ::v28(){vfunc_called(this, "_ZN9S21070C283v28Ev");}
void  S21070C28 ::v29(){vfunc_called(this, "_ZN9S21070C283v29Ev");}
S21070C28 ::~S21070C28(){ note_dtor("S21070C28", this);} // tgen
S21070C28 ::S21070C28(){ note_ctor("S21070C28", this);} // tgen

static void Test_S21070C28()
{
  extern Class_Descriptor cd_S21070C28;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1042,2651)];
    init_test(&cd_S21070C28, buf);
    S21070C28 *dp, &lv = *(dp=new (buf) S21070C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16656,10600), "sizeof(S21070C28)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S21070C28)");
    check_base_class_offset(lv, (S21070C13*), ABISELECT(2192,1488), "S21070C28");
    check_base_class_offset(lv, (S21070C22*), ABISELECT(2784,1896), "S21070C28");
    check_base_class_offset(lv, (S21070C22*)(S21070C21*)(S21070C29*), ABISELECT(2784,1896), "S21070C28");
    check_base_class_offset(lv, (S21070C24*)(S21070C29*), ABISELECT(2816,1908), "S21070C28");
    check_base_class_offset(lv, (S21070C4*)(S21070C14*), ABISELECT(5568,3656), "S21070C28");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C14*), ABISELECT(5568,3656), "S21070C28");
    check_base_class_offset(lv, (S21070C4*)(S21070C8*), ABISELECT(5568,3656), "S21070C28");
    /*is_ambiguous_... S21070C28::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*), ABISELECT(5568,3656), "S21070C28");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C14*), ABISELECT(5568,3656), "S21070C28");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(5568,3656), "S21070C28");
    check_base_class_offset(lv, (S21070C4*)(S21070C6*)(S21070C19*), ABISELECT(5568,3656), "S21070C28");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(5568,3656), "S21070C28");
    /*is_ambiguous_... S21070C14::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C14*), ABISELECT(4880,3260), "S21070C28");
    check_base_class_offset(lv, (S21070C7*)(S21070C8*), ABISELECT(5984,3952), "S21070C28");
    /*is_ambiguous_... S21070C17::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C17*)(S21070C21*)(S21070C29*), ABISELECT(5984,3952), "S21070C28");
    /*is_ambiguous_... S21070C19::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C19*), ABISELECT(5984,3952), "S21070C28");
    check_base_class_offset(lv, (S21070C8*)(S21070C14*), ABISELECT(5776,3796), "S21070C28");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C14*), ABISELECT(5776,3796), "S21070C28");
    check_base_class_offset(lv, (S21070C8*)(S21070C18*), ABISELECT(5776,3796), "S21070C28");
    check_base_class_offset(lv, (S21070C8*)(S21070C6*)(S21070C19*), ABISELECT(5776,3796), "S21070C28");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C14*), ABISELECT(4992,3316), "S21070C28");
    check_base_class_offset(lv, (S21070C6*)(S21070C14*), ABISELECT(4992,3316), "S21070C28");
    check_base_class_offset(lv, (S21070C14*)(S21070C29*), ABISELECT(4880,3260), "S21070C28");
    /*is_ambiguous_... S21070C21::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C21*)(S21070C29*), 0, "S21070C28");
    check_base_class_offset(lv, (S21070C18*)(S21070C17*)(S21070C21*)(S21070C29*), ABISELECT(6088,4008), "S21070C28");
    check_base_class_offset(lv, (S21070C18*)(S21070C19*), ABISELECT(6088,4008), "S21070C28");
    /*is_ambiguous_... S21070C19::S21070C4 */ AMB_check_base_class_offset(lv, (S21070C4*)(S21070C19*), ABISELECT(6160,4052), "S21070C28");
    /*is_ambiguous_... S21070C6::S21070C7 */ AMB_check_base_class_offset(lv, (S21070C7*)(S21070C6*)(S21070C19*), ABISELECT(6368,4192), "S21070C28");
    check_base_class_offset(lv, (S21070C6*)(S21070C19*), ABISELECT(6368,4192), "S21070C28");
    check_base_class_offset(lv, (S21070C19*)(S21070C17*)(S21070C21*)(S21070C29*), ABISELECT(6160,4052), "S21070C28");
    check_base_class_offset(lv, (S21070C17*)(S21070C21*)(S21070C29*), ABISELECT(208,140), "S21070C28");
    check_base_class_offset(lv, (S21070C21*)(S21070C29*), 0, "S21070C28");
    check_base_class_offset(lv, (S21070C29*), 0, "S21070C28");
    check_base_class_offset(lv, (S21070C26*), ABISELECT(2272,1548), "S21070C28");
    check_field_offset(lv, s21070c28f0, ABISELECT(2368,1612), "S21070C28.s21070c28f0");
    check_field_offset(lv, s21070c28f1, ABISELECT(2576,1752), "S21070C28.s21070c28f1");
    check_field_offset(lv, s21070c28f2, ABISELECT(2584,1756), "S21070C28.s21070c28f2");
    check_field_offset(lv, s21070c28f3, ABISELECT(2592,1764), "S21070C28.s21070c28f3");
    check_field_offset(lv, s21070c28f4, ABISELECT(2656,1796), "S21070C28.s21070c28f4");
    check_field_offset(lv, s21070c28f5, ABISELECT(2664,1804), "S21070C28.s21070c28f5");
    check_field_offset(lv, s21070c28f6, ABISELECT(2672,1808), "S21070C28.s21070c28f6");
    check_field_offset(lv, s21070c28f7, ABISELECT(2752,1868), "S21070C28.s21070c28f7");
    check_field_offset(lv, s21070c28f8, ABISELECT(2776,1892), "S21070C28.s21070c28f8");
    test_class_info(&lv, &cd_S21070C28);
    dp->~S21070C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21070C28(Test_S21070C28, "S21070C28", ABISELECT(16656,10600));

#else // __cplusplus

extern void _ZN9S21070C28C1Ev();
extern void _ZN9S21070C28D1Ev();
Name_Map name_map_S21070C28[] = {
  NSPAIR(_ZN9S21070C28C1Ev),
  NSPAIR(_ZN9S21070C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21070C13;
extern VTBL_ENTRY _ZTI9S21070C13[];
extern Class_Descriptor cd_S21070C22;
extern VTBL_ENTRY _ZTI9S21070C22[];
extern  VTBL_ENTRY _ZTV9S21070C22[];
extern Class_Descriptor cd_S21070C24;
extern VTBL_ENTRY _ZTI9S21070C24[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C8;
extern VTBL_ENTRY _ZTI8S21070C8[];
extern  VTBL_ENTRY _ZTV8S21070C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C8[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C14;
extern VTBL_ENTRY _ZTI9S21070C14[];
extern  VTBL_ENTRY _ZTV9S21070C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C14[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C18;
extern VTBL_ENTRY _ZTI9S21070C18[];
extern  VTBL_ENTRY _ZTV9S21070C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C18[];
extern Class_Descriptor cd_S21070C4;
extern VTBL_ENTRY _ZTI8S21070C4[];
extern  VTBL_ENTRY _ZTV8S21070C4[];
extern Class_Descriptor cd_S21070C7;
extern VTBL_ENTRY _ZTI8S21070C7[];
extern  VTBL_ENTRY _ZTV8S21070C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C7[];
extern Class_Descriptor cd_S21070C6;
extern VTBL_ENTRY _ZTI8S21070C6[];
extern  VTBL_ENTRY _ZTV8S21070C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21070C6[];
extern Class_Descriptor cd_S21070C19;
extern VTBL_ENTRY _ZTI9S21070C19[];
extern  VTBL_ENTRY _ZTV9S21070C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C19[];
extern Class_Descriptor cd_S21070C17;
extern VTBL_ENTRY _ZTI9S21070C17[];
extern  VTBL_ENTRY _ZTV9S21070C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C17[];
extern Class_Descriptor cd_S21070C21;
extern VTBL_ENTRY _ZTI9S21070C21[];
extern  VTBL_ENTRY _ZTV9S21070C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C21[];
extern Class_Descriptor cd_S21070C29;
extern VTBL_ENTRY _ZTI9S21070C29[];
extern  VTBL_ENTRY _ZTV9S21070C29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21070C29[];
extern Class_Descriptor cd_S21070C26;
extern VTBL_ENTRY _ZTI9S21070C26[];
extern  VTBL_ENTRY _ZTV9S21070C26[];
static Base_Class bases_S21070C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21070C13,    ABISELECT(2192,1488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C22,    ABISELECT(2784,1896), //bcp->offset
    33, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21070C24,    ABISELECT(2816,1908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(5568,3656), //bcp->offset
    61, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4880,3260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(5984,3952), //bcp->offset
    73, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S21070C8,    ABISELECT(5776,3796), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S21070C7,    ABISELECT(4992,3316), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(4992,3316), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21070C14,    ABISELECT(4880,3260), //bcp->offset
    41, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S21070C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S21070C18,    ABISELECT(6088,4008), //bcp->offset
    78, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S21070C4,    ABISELECT(6160,4052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21070C7,    ABISELECT(6368,4192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21070C6,    ABISELECT(6368,4192), //bcp->offset
    105, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21070C19,    ABISELECT(6160,4052), //bcp->offset
    83, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S21070C17,    ABISELECT(208,140), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S21070C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S21070C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21070C26,    ABISELECT(2272,1548), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21070C28[];
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN9S21070C28D1Ev();
extern void _ZN9S21070C28D0Ev();
extern void _ZN9S21070C293v27Ev();
extern void _ZN9S21070C283v28Ev();
extern void _ZN9S21070C283v29Ev();
extern void ABISELECT(_ZThn208_N9S21070C28D1Ev,_ZThn140_N9S21070C28D1Ev)();
extern void ABISELECT(_ZThn208_N9S21070C28D0Ev,_ZThn140_N9S21070C28D0Ev)();
extern void _ZN9S21070C173v13Ev();
extern void _ZN9S21070C263v22Ev();
extern void _ZN9S21070C263v23Ev();
extern void _ZN9S21070C263v24Ev();
extern void _ZN9S21070C223v15Ev();
extern void _ZN9S21070C223v16Ev();
extern void _ZN9S21070C223v17Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTv0_n56_N9S21070C28D1Ev,_ZTv0_n28_N9S21070C28D1Ev)();
extern void ABISELECT(_ZThn4880_N9S21070C28D1Ev,_ZThn3260_N9S21070C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S21070C28D0Ev,_ZTv0_n28_N9S21070C28D0Ev)();
extern void ABISELECT(_ZThn4880_N9S21070C28D0Ev,_ZThn3260_N9S21070C28D0Ev)() __attribute__((weak));
extern void _ZN9S21070C142v8Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn112_n56_N9S21070C28D1Ev,_ZTvn56_n28_N9S21070C28D1Ev)();
extern void ABISELECT(_ZTvn112_n56_N9S21070C28D0Ev,_ZTvn56_n28_N9S21070C28D0Ev)();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void _ZN8S21070C72v6Ev();
extern void _ZN8S21070C42v3Ev();
extern void _ZN8S21070C42v4Ev();
extern void _ZN8S21070C42v5Ev();
extern void ABISELECT(_ZTv0_n80_N9S21070C28D1Ev,_ZTv0_n40_N9S21070C28D1Ev)();
extern void ABISELECT(_ZThn6160_N9S21070C28D1Ev,_ZThn4052_N9S21070C28D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21070C28D0Ev,_ZTv0_n40_N9S21070C28D0Ev)();
extern void ABISELECT(_ZThn6160_N9S21070C28D0Ev,_ZThn4052_N9S21070C28D0Ev)() __attribute__((weak));
extern void _ZN9S21070C193v10Ev();
extern void _ZN9S21070C193v11Ev();
extern void _ZN9S21070C193v12Ev();
extern void _ZN8S21070C72v6Ev();
extern void ABISELECT(_ZTvn208_n80_N9S21070C28D1Ev,_ZTvn140_n40_N9S21070C28D1Ev)();
extern void ABISELECT(_ZTvn208_n80_N9S21070C28D0Ev,_ZTvn140_n40_N9S21070C28D0Ev)();
static  VTBL_ENTRY vtc_S21070C28[] = {
  ABISELECT(4880,3260),
  ABISELECT(2816,1908),
  ABISELECT(2784,1896),
  ABISELECT(6160,4052),
  ABISELECT(5776,3796),
  ABISELECT(6088,4008),
  ABISELECT(5568,3656),
  ABISELECT(5984,3952),
  0,
  (VTBL_ENTRY)&(_ZTI9S21070C28[0]),
  (VTBL_ENTRY)&_ZN8S21070C42v3Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v4Ev,
  (VTBL_ENTRY)&_ZN8S21070C42v5Ev,
  (VTBL_ENTRY)&_ZN9S21070C28D1Ev,
  (VTBL_ENTRY)&_ZN9S21070C28D0Ev,
  (VTBL_ENTRY)&_ZN9S21070C293v27Ev,
  (VTBL_ENTRY)&_ZN9S21070C283v28Ev,
  (VTBL_ENTRY)&_ZN9S21070C283v29Ev,
  ABISELECT(5952,3912),
  ABISELECT(5568,3656),
  ABISELECT(5880,3868),
  ABISELECT(5360,3516),
  ABISELECT(5776,3812),
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI9S21070C28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C28D1Ev,_ZThn140_N9S21070C28D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21070C28D0Ev,_ZThn140_N9S21070C28D0Ev),
  (